-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-35324701-9
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-10-09 18:43:00','Actividad Generica 1','000001',NULL),(2,NULL,'2022-10-09 18:43:00','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Ealmiron27',NULL,1,40724,'2022-12-02'),(2,NULL,'Ealmiron27',NULL,1,40724,'2022-12-02'),(3,NULL,'Ealmiron27',NULL,1,40724,'2022-12-02'),(4,NULL,'Ealmiron27',NULL,1,40719,'2023-01-03'),(5,NULL,'Ealmiron28',NULL,1,40719,'2023-01-03'),(6,NULL,'Ealmiron27',NULL,1,40719,'2023-01-03'),(7,NULL,'Ealmiron27',NULL,1,40724,'2023-01-05'),(8,NULL,'20ANGELv22',NULL,1,40766,'2023-01-27'),(9,NULL,'Oximetal250',NULL,1,40782,'2023-01-27'),(10,NULL,'Oximetal250',NULL,1,40782,'2023-01-27'),(11,NULL,'Dariomonsa778',NULL,1,40791,'2023-01-30'),(12,NULL,'Monsada783',NULL,3,40791,'2023-01-30'),(13,NULL,'Nocera2021',NULL,1,40796,'2023-01-30'),(14,NULL,'Nocera2021',NULL,3,40796,'2023-01-30'),(15,NULL,'Dariomonsa778',NULL,1,40791,'2023-01-30'),(16,NULL,'Monsada783',NULL,3,40791,'2023-01-30'),(17,NULL,'Fernando2022',NULL,1,40790,'2023-01-30'),(18,NULL,'Fernando2020',NULL,3,40790,'2023-01-30'),(19,NULL,'Allojorge9261',NULL,1,40802,'2023-01-30'),(20,NULL,'Giles2022',NULL,3,40802,'2023-01-30'),(21,NULL,'Martin20282',NULL,1,40877,'2023-01-31'),(22,NULL,'Nicolas2022',NULL,1,40876,'2023-01-31'),(23,NULL,'Espequi2004',NULL,1,40884,'2023-01-31'),(24,NULL,'Maria202108',NULL,1,40883,'2023-01-31'),(25,NULL,'Maria202108',NULL,1,40882,'2023-01-31'),(26,NULL,'Mariana272178',NULL,1,40880,'2023-01-31'),(27,NULL,'Susana271141',NULL,1,40879,'2023-01-31'),(28,NULL,'Martin20282',NULL,1,40878,'2023-01-31'),(29,NULL,'Fernando6060',NULL,1,40877,'2023-01-31'),(30,NULL,'Alberti2022',NULL,1,40875,'2023-01-31'),(31,NULL,'Joaquin89901419',NULL,1,40874,'2023-01-31'),(32,NULL,'Alberto2008',NULL,1,40873,'2023-01-31'),(33,NULL,'Fati250218',NULL,1,40881,'2023-01-31'),(34,NULL,'Fati250218',NULL,1,40881,'2023-01-31'),(35,NULL,'Ealmiron27',NULL,1,41019,'2023-01-31'),(36,NULL,'Fundar20221',NULL,2,41019,'2023-01-31'),(37,'XINYU SI','SA7991psic',NULL,1,40846,'2023-01-31'),(38,NULL,'Ccic2500',NULL,3,40846,'2023-01-31'),(39,'XINYU SI','2005CCIC',NULL,2,40846,'2023-01-31'),(40,'XINYU SI','SA7991psic',NULL,1,40846,'2023-01-31'),(41,NULL,'Ccic2500',NULL,3,40846,'2023-01-31'),(42,'XINYU SI','2005CCIC',NULL,2,40846,'2023-01-31'),(43,NULL,'Gisela2022',NULL,1,41263,'2023-02-01'),(44,NULL,'530517',NULL,3,41263,'2023-02-01'),(45,NULL,'Oximetal250',NULL,1,40782,'2023-02-01'),(46,NULL,'Isabel2312',NULL,1,41264,'2023-02-01'),(47,NULL,'Oximetal250',NULL,1,40782,'2023-02-01'),(48,NULL,'Oximetal250',NULL,1,40782,'2023-02-01'),(49,NULL,'Oximetal250',NULL,1,40782,'2023-02-01'),(50,NULL,'Oximetal250',NULL,1,40782,'2023-02-13'),(51,NULL,'Oximetal250',NULL,1,40782,'2023-02-13'),(52,NULL,'Oximetal250',NULL,1,40782,'2023-02-13'),(53,'XINYU SI','SA7991psic',NULL,1,40846,'2023-03-09'),(54,NULL,'Ccic2500',NULL,3,40846,'2023-03-09'),(55,'XINYU SI','2005CCIC',NULL,2,40846,'2023-03-09'),(56,NULL,'Gasuar2022',NULL,1,40869,'2023-03-13'),(57,NULL,'avel2018',NULL,2,40869,'2023-03-13'),(58,'XINYU SI','SA7991psic',NULL,1,40846,'2023-03-16'),(59,NULL,'Ccic2500',NULL,3,40846,'2023-03-16'),(60,'XINYU SI','2005CCIC',NULL,2,40846,'2023-03-16'),(61,NULL,'Matias28866',NULL,1,41421,'2023-03-16'),(62,NULL,'Matias28866',NULL,1,41421,'2023-03-16'),(63,NULL,'Matias28866',NULL,1,41421,'2023-03-16'),(64,NULL,'Matias28866',NULL,1,41421,'2023-03-16'),(65,NULL,'Leticia2381',NULL,1,40788,'2023-03-17'),(66,NULL,'OGBV2021',NULL,2,40788,'2023-03-17'),(67,NULL,'Fati250218',NULL,1,40881,'2023-03-17'),(68,NULL,'Fati250218',NULL,1,40881,'2023-03-17'),(69,NULL,'Conifurlani92',NULL,1,41418,'2023-03-17'),(70,NULL,'Yampol2023',NULL,1,40781,'2023-03-17'),(71,NULL,'Lyon52021',NULL,3,40781,'2023-03-17'),(72,NULL,'Lyon2022',NULL,2,40781,'2023-03-17'),(73,NULL,'Nicolas2022',NULL,1,40876,'2023-03-17'),(74,NULL,'27238453211',NULL,1,41734,'2023-03-17'),(75,NULL,'33716792329',NULL,3,41734,'2023-03-17'),(76,NULL,'27238453211',NULL,1,41734,'2023-03-17'),(77,NULL,'33716792329',NULL,3,41734,'2023-03-17'),(78,NULL,'Fati250218',NULL,1,40881,'2023-03-20'),(79,NULL,'Conifurlani92',NULL,1,41418,'2023-03-20');
INSERT INTO `back_up_claves_details` VALUES (80,NULL,'Yampol2023',NULL,1,40781,'2023-03-20'),(81,NULL,'Lyon52021',NULL,3,40781,'2023-03-20'),(82,NULL,'Lyon2022',NULL,2,40781,'2023-03-20'),(83,NULL,'Nicolas2022',NULL,1,40876,'2023-03-20'),(84,NULL,'00Afip2022',NULL,1,40798,'2023-03-20'),(85,NULL,'Inddel2021',NULL,2,40798,'2023-03-20'),(86,NULL,'Leal2023',NULL,3,40798,'2023-03-20'),(87,NULL,'Ealmiron27',NULL,1,40719,'2023-03-20'),(88,NULL,'Yanina2725',NULL,1,40765,'2023-03-20'),(89,NULL,'Matias28866',NULL,1,41421,'2023-03-22'),(90,NULL,'Botanico2021',NULL,1,40800,'2023-03-28'),(91,NULL,'Lebron2021',NULL,3,40800,'2023-03-28'),(92,NULL,'Botanico2021',NULL,1,40800,'2023-03-28'),(93,NULL,'Lebron2021',NULL,3,40800,'2023-03-28'),(94,NULL,'Mariana272178',NULL,1,40880,'2023-03-28'),(95,NULL,'Martin20282',NULL,1,40878,'2023-03-28'),(96,NULL,'Espequi2004',NULL,1,40884,'2023-03-29'),(97,NULL,'Alberti2022',NULL,1,40875,'2023-03-29'),(98,NULL,'Fernando6060',NULL,1,40877,'2023-03-29'),(99,NULL,'Martha2022',NULL,1,40803,'2023-03-30'),(100,NULL,'Estudio9784',NULL,3,40803,'2023-03-30'),(101,NULL,'Yanina2725',NULL,1,40765,'2023-03-30'),(102,NULL,'Gasuar2022',NULL,1,40795,'2023-03-30'),(103,NULL,'avel2018',NULL,2,40795,'2023-03-30'),(104,NULL,'Gasuar2022',NULL,1,40795,'2023-03-30'),(105,NULL,'avel2018',NULL,2,40795,'2023-03-30'),(106,NULL,'Gasuar2022',NULL,1,40795,'2023-03-31'),(107,NULL,'avel2018',NULL,2,40795,'2023-03-31'),(108,NULL,'Alberti2022',NULL,1,40875,'2023-04-03'),(109,NULL,'Alberti2022',NULL,1,40875,'2023-04-05'),(110,NULL,'Alberti2022',NULL,1,40875,'2023-04-05'),(111,NULL,'Alberto2008',NULL,1,41082,'2023-04-05'),(112,NULL,'Alberto2007',NULL,3,41082,'2023-04-05'),(113,NULL,'Feliciano22',NULL,1,40794,'2023-04-05'),(114,NULL,'Fati250218',NULL,1,40881,'2023-04-05'),(115,NULL,'Oximetal250',NULL,1,40782,'2023-04-13'),(116,NULL,'Leticia2381',NULL,1,40929,'2023-04-13'),(117,NULL,'OGBV2021',NULL,2,40929,'2023-04-13'),(118,NULL,'Matias28866',NULL,1,41421,'2023-04-14'),(119,NULL,'Federico1122',NULL,1,40764,'2023-04-17'),(120,NULL,'Frigoelpopu123',NULL,1,41145,'2023-04-17'),(121,NULL,'Margarita2705',NULL,1,42356,'2023-04-28'),(122,NULL,'Margarita2705',NULL,3,42356,'2023-04-28'),(123,NULL,'Botana2022',NULL,1,41420,'2023-05-16'),(124,NULL,'27238453211',NULL,1,41734,'2023-05-17'),(125,NULL,'33716792329',NULL,3,41734,'2023-05-17'),(126,NULL,'27238453211',NULL,1,41734,'2023-05-17'),(127,NULL,'33716792329',NULL,3,41734,'2023-05-17'),(128,NULL,'Alberti2022',NULL,1,40875,'2023-05-31'),(129,NULL,'Joaquin89901419',NULL,1,40874,'2023-10-20'),(130,NULL,'Joaquin89901419',NULL,1,40874,'2023-10-20');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'ezequiel.almiron@yahoo.com.ar','1169126728',NULL,1,40719,'2022-12-02'),(2,'ezequiel.almiron@yahoo.com.ar','1169126728',NULL,1,40719,'2023-01-03'),(3,'ezequiel.almiron@yahoo.com.ar','1169126728',NULL,1,40719,'2023-01-03'),(4,'ezequiel.almiron@yahoo.com.ar','1169126728',NULL,1,40719,'2023-01-03'),(5,'finance@ccicsa.com',NULL,'',1,40846,'2023-01-31'),(6,'finance@ccicsa.com',NULL,'',1,40846,'2023-01-31'),(7,'finance@ccicsa.com',NULL,'',1,40846,'2023-03-09'),(8,'finance@ccicsa.com',NULL,'',1,40846,'2023-03-16'),(9,'ezequiel.almiron@yahoo.com.ar','1169126728',NULL,1,40719,'2023-03-20'),(10,'administracion@fundareco.com.ar',NULL,NULL,1,40765,'2023-03-30'),(11,'administracion@fundareco.com.ar',NULL,NULL,1,40782,'2023-04-13'),(12,'administracion@fundareco.com.ar',NULL,NULL,1,40764,'2023-04-17');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24230 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7931,40719,12,5,1,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1000.00,NULL,NULL,1,'2022-12-02 16:34:12','2022-12-02 16:34:12',NULL),(2,7931,40724,7527,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-02','2022-10-02',109952.00,NULL,NULL,1,'2022-12-02 17:00:43','2023-04-12 11:43:56','2023-04-12 11:43:56'),(3,7931,40724,7527,3,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',69736.00,NULL,NULL,1,'2022-12-02 17:00:43','2023-04-12 11:50:59','2023-04-12 11:50:59'),(4,7931,40724,7527,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',190.00,NULL,NULL,1,'2022-12-02 17:00:43','2022-12-02 17:00:43',NULL),(5,7931,40724,7527,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',55000.00,NULL,NULL,1,'2022-12-02 17:00:43','2022-12-02 17:00:43',NULL),(6,7931,40724,7527,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',12984.00,NULL,NULL,1,'2022-12-02 17:00:43','2023-04-12 12:54:17','2023-04-12 12:54:17'),(7,7931,40724,7527,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',95.00,NULL,NULL,1,'2022-12-02 17:00:43','2023-04-13 10:45:23','2023-04-13 10:45:23'),(8,7931,40724,7527,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',2500.01,NULL,NULL,1,'2022-12-02 17:00:43','2023-04-12 13:12:29','2023-04-12 13:12:29'),(9,7931,40724,7527,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',16335.00,NULL,NULL,1,'2022-12-02 17:00:43','2023-04-12 13:02:03','2023-04-12 13:02:03'),(10,7931,40724,7527,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',5004.26,NULL,NULL,1,'2022-12-02 17:00:44','2023-04-13 10:48:34','2023-04-13 10:48:34'),(11,7931,40724,7527,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',6000.00,NULL,NULL,1,'2022-12-02 17:00:44','2023-04-12 13:21:21','2023-04-12 13:21:21'),(12,7931,40724,7527,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',2770.00,NULL,NULL,1,'2022-12-02 17:00:44','2023-04-12 11:48:47','2023-04-12 11:48:47'),(13,7931,40724,7527,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',8990.00,NULL,NULL,1,'2022-12-02 17:00:44','2022-12-02 17:00:44',NULL),(14,7931,40724,7527,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',326.00,NULL,NULL,1,'2022-12-02 17:00:44','2022-12-02 17:00:44',NULL),(15,7931,40724,7527,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',14633.41,NULL,NULL,1,'2022-12-02 17:00:44','2023-04-15 20:33:06','2023-04-15 20:33:06'),(16,7931,40724,7527,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',266.53,NULL,NULL,1,'2022-12-02 17:00:44','2023-04-13 10:45:53','2023-04-13 10:45:53'),(17,7931,40724,7527,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',2875.00,NULL,NULL,1,'2022-12-02 17:00:44','2023-04-12 13:09:14','2023-04-12 13:09:14'),(18,7931,40724,7527,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',400.00,NULL,NULL,1,'2022-12-02 17:00:44','2023-04-15 20:32:58','2023-04-15 20:32:58'),(19,7931,40724,7527,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',3050.00,NULL,NULL,1,'2022-12-02 17:00:44','2023-04-12 11:48:22','2023-04-12 11:48:22'),(20,7931,40724,7527,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',16600.00,NULL,NULL,1,'2022-12-02 17:00:45','2023-04-15 20:32:45','2023-04-15 20:32:45');
INSERT INTO `balance_libro` VALUES (21,7931,40724,7527,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',83335.17,NULL,NULL,1,'2022-12-02 17:00:45','2023-04-12 11:50:40','2023-04-12 11:50:40'),(22,7931,40724,7527,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',120000.00,NULL,NULL,1,'2022-12-02 17:00:45','2023-04-13 11:39:32','2023-04-13 11:39:32'),(23,7931,40724,7527,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',76200.00,NULL,NULL,1,'2022-12-02 17:00:45','2023-04-13 11:41:45','2023-04-13 11:41:45'),(24,7931,40724,7527,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',93728.29,NULL,NULL,1,'2022-12-02 17:00:45','2023-04-13 11:44:05','2023-04-13 11:44:05'),(25,7931,40724,7527,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',2600.00,NULL,NULL,1,'2022-12-02 17:00:45','2023-04-13 11:44:30','2023-04-13 11:44:30'),(26,7931,40724,7527,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',45510.70,NULL,NULL,1,'2022-12-02 17:00:45','2023-04-15 20:31:55','2023-04-15 20:31:55'),(27,7931,40724,7527,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',136380.19,NULL,NULL,1,'2022-12-02 17:00:45','2023-04-13 11:48:14','2023-04-13 11:48:14'),(28,7931,40724,7527,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',137685.00,NULL,NULL,1,'2022-12-02 17:00:45','2023-04-13 11:55:33','2023-04-13 11:55:33'),(29,7931,40724,7527,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',137685.00,NULL,NULL,1,'2022-12-02 17:00:45','2023-04-13 11:55:58','2023-04-13 11:55:58'),(30,7931,40724,7527,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',137685.00,NULL,NULL,1,'2022-12-02 17:00:45','2023-04-13 11:56:23','2023-04-13 11:56:23'),(31,7931,40724,7528,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',3050.00,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-12 11:47:52','2023-04-12 11:47:52'),(32,7931,40724,7528,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',51112.18,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-12 11:51:46','2023-04-12 11:51:46'),(33,7931,40724,7528,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',118334.00,NULL,NULL,1,'2022-12-07 14:21:35','2022-12-07 14:21:35',NULL),(34,7931,40724,7528,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',109952.00,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-12 11:44:13','2023-04-12 11:44:13'),(35,7931,40724,7528,3,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',16359.00,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-12 12:54:40','2023-04-12 12:54:40'),(36,7931,40724,7528,3,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',43082.00,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-12 12:58:47','2023-04-12 12:58:47'),(37,7931,40724,7528,3,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',16335.00,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-12 13:02:29','2023-04-12 13:02:29'),(38,7931,40724,7528,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2900.01,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-12 13:12:49','2023-04-12 13:12:49'),(39,7931,40724,7528,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',6000.00,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-12 13:21:53','2023-04-12 13:21:53'),(40,7931,40724,7528,3,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',4050.00,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-12 13:09:38','2023-04-12 13:09:38');
INSERT INTO `balance_libro` VALUES (41,7931,40724,7528,3,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',3900.00,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-13 11:44:55','2023-04-13 11:44:55'),(42,7931,40724,7528,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',14845.00,NULL,NULL,1,'2022-12-07 14:21:35','2022-12-07 14:21:35',NULL),(43,7931,40724,7528,3,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',24000.00,NULL,NULL,1,'2022-12-07 14:21:35','2022-12-07 14:21:35',NULL),(44,7931,40724,7528,3,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',9728.77,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-12 13:15:29','2023-04-12 13:15:29'),(45,7931,40724,7528,3,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',11198.00,NULL,NULL,1,'2022-12-07 14:21:35','2022-12-07 14:21:35',NULL),(46,7931,40724,7528,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',7250.00,NULL,NULL,1,'2022-12-07 14:21:35','2022-12-07 14:21:35',NULL),(47,7931,40724,7528,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',68.00,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-13 10:46:15','2023-04-13 10:46:15'),(48,7931,40724,7528,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',9514.51,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-12 13:17:11','2023-04-12 13:17:11'),(49,7931,40724,7528,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',3569.00,NULL,NULL,1,'2022-12-07 14:21:35','2022-12-07 14:21:35',NULL),(50,7931,40724,7528,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',4797.00,NULL,NULL,1,'2022-12-07 14:21:35','2022-12-07 14:21:35',NULL),(51,7931,40724,7528,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',46799.78,NULL,NULL,1,'2022-12-07 14:21:35','2022-12-07 14:21:35',NULL),(52,7931,40724,7528,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',91941.12,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-13 09:59:48','2023-04-13 09:59:48'),(53,7931,40724,7528,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',4798.00,NULL,NULL,1,'2022-12-07 14:21:35','2022-12-07 14:21:35',NULL),(54,7931,40724,7528,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3050.00,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-12 11:47:27','2023-04-12 11:47:27'),(55,7931,40724,7528,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',138662.27,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-13 11:39:56','2023-04-13 11:39:56'),(56,7931,40724,7528,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',76200.00,NULL,NULL,1,'2022-12-07 14:21:35','2023-04-13 11:42:04','2023-04-13 11:42:04'),(57,7931,40724,7528,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6750.00,NULL,NULL,1,'2022-12-07 14:21:36','2023-04-13 11:45:23','2023-04-13 11:45:23'),(58,7931,40724,7528,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',120799.92,NULL,NULL,1,'2022-12-07 14:21:36','2023-04-13 11:45:48','2023-04-13 11:45:48'),(59,7931,40724,7528,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',124243.92,NULL,NULL,1,'2022-12-07 14:21:36','2023-04-13 11:51:26','2023-04-13 11:51:26'),(60,7931,40724,7528,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',138036.30,NULL,NULL,1,'2022-12-07 14:21:36','2022-12-12 11:01:47','2022-12-12 11:01:47');
INSERT INTO `balance_libro` VALUES (61,7931,40724,7528,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',137685.00,NULL,NULL,1,'2022-12-07 14:21:36','2023-04-13 11:56:43','2023-04-13 11:56:43'),(62,7931,40724,7527,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',5414.41,NULL,NULL,1,'2022-12-07 15:44:08','2023-04-15 20:30:44','2023-04-15 20:30:44'),(63,7931,40724,7528,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',138036.30,NULL,NULL,1,'2022-12-12 11:05:02','2023-04-13 11:48:42','2023-04-13 11:48:42'),(64,8434,40846,119616,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',134784.00,NULL,NULL,1,'2023-01-30 13:33:41','2023-01-30 13:33:41',NULL),(65,8434,40846,119616,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',8164.92,NULL,NULL,1,'2023-01-30 13:33:41','2023-01-30 13:33:41',NULL),(66,8434,40846,119616,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',160954.20,NULL,NULL,1,'2023-01-30 13:33:41','2023-01-30 13:33:41',NULL),(67,8434,40846,119616,3,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',12100.00,NULL,NULL,1,'2023-01-30 13:33:41','2023-01-30 13:33:41',NULL),(68,8434,40846,119616,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',145502.50,NULL,NULL,1,'2023-01-30 13:33:41','2023-01-30 13:33:41',NULL),(69,8434,40846,119616,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',145502.50,NULL,NULL,1,'2023-01-30 13:33:41','2023-01-30 13:33:41',NULL),(70,8434,40846,119616,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1200.00,NULL,NULL,1,'2023-01-30 13:33:41','2023-01-30 13:33:41',NULL),(71,8434,40846,119616,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',101334.17,NULL,NULL,1,'2023-01-30 13:33:41','2023-01-30 13:33:41',NULL),(72,8434,40846,119616,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',11741.24,NULL,NULL,1,'2023-01-30 13:33:41','2023-01-30 13:45:03','2023-01-30 13:45:03'),(73,8434,40846,119616,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8800.00,NULL,NULL,1,'2023-01-30 13:33:41','2023-01-30 13:33:41',NULL),(74,8434,40846,119616,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',12785.02,NULL,NULL,1,'2023-01-30 13:33:41','2023-01-30 13:50:34','2023-01-30 13:50:34'),(75,8434,40846,119616,3,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4890.00,NULL,NULL,1,'2023-01-30 13:33:41','2023-01-30 13:33:41',NULL),(76,8434,40846,119616,3,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',2060.39,NULL,NULL,1,'2023-01-30 13:33:41','2023-01-30 13:48:39','2023-01-30 13:48:39'),(77,8434,40846,119616,3,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',905.00,NULL,NULL,1,'2023-01-30 13:33:42','2023-01-30 13:33:42',NULL),(78,8434,40846,119616,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4840000.00,NULL,NULL,1,'2023-01-30 13:33:42','2023-01-30 13:33:42',NULL),(79,8434,40846,119616,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1700.00,NULL,NULL,1,'2023-01-30 13:33:42','2023-01-30 13:33:42',NULL),(80,8434,40846,119616,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',20625.00,NULL,NULL,1,'2023-01-30 13:33:42','2023-01-30 13:57:56','2023-01-30 13:57:56');
INSERT INTO `balance_libro` VALUES (81,8434,40846,119616,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',22625.00,NULL,NULL,1,'2023-01-30 13:33:42','2023-01-30 13:58:29','2023-01-30 13:58:29'),(82,8434,40846,119616,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',20714.06,NULL,NULL,1,'2023-01-30 13:33:42','2023-01-30 13:41:23','2023-01-30 13:41:23'),(83,8434,40846,119616,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2360.00,NULL,NULL,1,'2023-01-30 13:33:42','2023-01-30 13:33:42',NULL),(84,8434,40846,119616,3,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',95000.00,NULL,NULL,1,'2023-01-30 13:33:42','2023-01-30 13:33:42',NULL),(85,8434,40846,119616,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1373500.00,NULL,NULL,1,'2023-01-30 13:33:42','2023-01-30 13:33:42',NULL),(86,8434,40846,119616,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',57632.89,NULL,NULL,1,'2023-01-30 13:33:42','2023-01-30 13:40:44','2023-01-30 13:40:44'),(87,8434,40846,119616,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',57632.89,NULL,NULL,1,'2023-01-30 13:40:44','2023-02-10 10:17:49','2023-02-10 10:17:49'),(88,8434,40846,119616,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',20714.06,NULL,NULL,1,'2023-01-30 13:41:23','2023-01-30 13:41:23',NULL),(89,8434,40846,119616,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',11741.24,NULL,NULL,1,'2023-01-30 13:45:03','2023-01-30 13:45:03',NULL),(90,8434,40846,119616,3,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',2060.39,NULL,NULL,1,'2023-01-30 13:48:39','2023-01-30 13:48:39',NULL),(91,8434,40846,119616,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',12785.02,NULL,NULL,1,'2023-01-30 13:50:34','2023-01-30 13:50:34',NULL),(92,8434,40846,119616,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',20625.00,NULL,NULL,1,'2023-01-30 13:57:56','2023-01-30 13:57:56',NULL),(93,8434,40846,119616,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',22625.00,NULL,NULL,1,'2023-01-30 13:58:29','2023-01-30 13:58:29',NULL),(94,8434,40846,119616,21,93,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,93,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',134784.00,NULL,NULL,1,'2023-01-30 14:18:34','2023-01-30 14:18:34',NULL),(95,8434,40846,119616,21,94,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,94,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',160954.20,NULL,NULL,1,'2023-01-30 14:20:08','2023-01-30 14:20:08',NULL),(96,8434,40846,119616,21,95,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,95,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12100.00,NULL,NULL,1,'2023-01-30 14:20:52','2023-01-30 14:20:52',NULL),(97,8434,40846,119616,21,96,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,96,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',101334.17,NULL,NULL,1,'2023-01-30 14:22:39','2023-01-30 14:22:39',NULL),(98,8434,40846,119616,21,97,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,97,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',291005.00,NULL,NULL,1,'2023-01-30 14:26:51','2023-01-30 14:26:51',NULL),(99,8434,40846,119616,21,99,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,99,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',4840000.00,NULL,NULL,1,'2023-01-30 14:41:02','2023-01-30 15:16:50','2023-01-30 15:16:50'),(100,8434,40846,119616,21,100,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,100,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',95000.00,NULL,NULL,1,'2023-01-30 14:42:14','2023-01-30 15:04:30','2023-01-30 15:04:30');
INSERT INTO `balance_libro` VALUES (101,8434,40846,119616,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5534.79,NULL,NULL,1,'2023-01-30 14:48:09','2023-01-30 14:48:09',NULL),(102,8434,40846,119616,21,102,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,102,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',5534.79,NULL,NULL,1,'2023-01-30 14:48:58','2023-01-30 14:48:58',NULL),(103,8434,40846,119616,21,104,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,104,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',5178.27,NULL,NULL,1,'2023-01-30 14:52:06','2023-01-30 14:52:06',NULL),(104,8434,40846,119616,21,105,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,105,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',11741.24,NULL,NULL,1,'2023-01-30 15:03:14','2023-01-30 15:03:14',NULL),(105,8434,40846,119616,21,106,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,106,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',95000.00,NULL,NULL,1,'2023-01-30 15:05:07','2023-01-30 15:05:07',NULL),(106,8434,40846,119616,21,107,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,107,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8800.00,NULL,NULL,1,'2023-01-30 15:08:37','2023-01-30 15:08:37',NULL),(107,8434,40846,119616,21,108,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,108,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1200.00,NULL,NULL,1,'2023-01-30 15:10:58','2023-01-30 15:10:58',NULL),(108,8434,40846,119616,21,109,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,109,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1700.00,NULL,NULL,1,'2023-01-30 15:11:37','2023-01-30 15:11:37',NULL),(109,8434,40846,119616,21,110,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,110,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',4890.00,NULL,NULL,1,'2023-01-30 15:12:52','2023-01-30 15:12:52',NULL),(110,8434,40846,119616,21,111,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,111,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',2060.39,NULL,NULL,1,'2023-01-30 15:13:45','2023-01-30 15:13:45',NULL),(111,8434,40846,119616,21,112,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,112,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',905.00,NULL,NULL,1,'2023-01-30 15:14:47','2023-01-30 15:14:47',NULL),(112,8434,40846,119616,21,114,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,114,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',374993.52,NULL,NULL,1,'2023-01-30 15:18:51','2023-01-30 15:18:51',NULL),(113,8434,40846,119616,21,115,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,115,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',4840000.00,NULL,NULL,1,'2023-01-30 19:19:00','2023-01-30 19:19:00',NULL),(114,8434,40846,119616,21,116,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,116,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2360.00,NULL,NULL,1,'2023-01-31 14:18:04','2023-01-31 14:18:04',NULL),(115,8434,40846,119616,21,117,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,117,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',8164.92,NULL,NULL,1,'2023-01-31 14:20:33','2023-01-31 14:20:33',NULL),(116,8434,40846,119616,21,118,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,118,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',12785.02,NULL,NULL,1,'2023-01-31 14:21:24','2023-01-31 14:21:24',NULL),(117,8434,40846,119616,21,119,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,119,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',20625.00,NULL,NULL,1,'2023-01-31 14:27:14','2023-01-31 14:27:14',NULL),(118,8434,40846,119616,21,120,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,120,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',22625.00,NULL,NULL,1,'2023-01-31 14:27:47','2023-01-31 14:27:47',NULL),(119,8434,40846,119616,21,122,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,122,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',16034.51,NULL,NULL,1,'2023-01-31 16:13:48','2023-01-31 16:17:52','2023-01-31 16:17:52'),(120,8434,40846,119616,3,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',16034.51,NULL,NULL,1,'2023-01-31 16:17:00','2023-01-31 16:17:00',NULL);
INSERT INTO `balance_libro` VALUES (121,8434,40846,119616,21,124,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,124,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',16034.51,NULL,NULL,1,'2023-01-31 16:18:23','2023-01-31 16:18:23',NULL),(122,8433,40846,119616,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10717.80,NULL,NULL,1,'2023-02-01 10:47:28','2023-02-02 12:10:09','2023-02-02 12:10:09'),(123,8434,40846,119616,3,123,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10902.50,NULL,NULL,1,'2023-02-01 11:30:40','2023-02-02 11:59:49','2023-02-02 11:59:49'),(124,8434,40846,119616,3,124,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',20172.32,NULL,NULL,1,'2023-02-01 11:59:25','2023-02-02 12:00:29','2023-02-02 12:00:29'),(125,8434,40846,119616,1,125,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',615000.00,NULL,NULL,1,'2023-02-01 12:21:43','2023-02-02 11:31:56','2023-02-02 11:31:56'),(126,8434,40846,119616,3,126,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',246.68,NULL,NULL,1,'2023-02-01 13:03:40','2023-02-02 11:26:43','2023-02-02 11:26:43'),(127,8434,40846,119616,3,127,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7835.88,NULL,NULL,1,'2023-02-01 13:05:34','2023-02-02 11:26:10','2023-02-02 11:26:10'),(128,8434,40846,119616,3,128,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2206.15,NULL,NULL,1,'2023-02-01 13:06:40','2023-02-02 11:11:47','2023-02-02 11:11:47'),(129,8433,40846,119616,16,129,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',20862.29,NULL,NULL,1,'2023-02-01 13:32:49','2023-02-01 13:38:46','2023-02-01 13:38:46'),(130,8434,40846,119616,16,130,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',20862.29,NULL,NULL,1,'2023-02-01 13:38:46','2023-02-02 11:27:46','2023-02-02 11:27:46'),(131,8434,40846,119616,3,131,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',86963.36,NULL,NULL,1,'2023-02-01 13:48:42','2023-02-02 11:30:42','2023-02-02 11:30:42'),(132,8434,40846,119616,3,132,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',13758.00,NULL,NULL,1,'2023-02-01 13:49:50','2023-02-02 11:25:16','2023-02-02 11:25:16'),(133,8434,40846,119616,3,133,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2206.15,'Pago AYSA',NULL,1,'2023-02-02 11:11:47','2023-02-02 11:13:55','2023-02-02 11:13:55'),(134,8434,40846,119616,3,134,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2206.15,'Pago AYSA',NULL,1,'2023-02-02 11:13:55','2023-02-02 11:13:55',NULL),(135,8434,40846,119616,3,135,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',13758.00,'Pago a cuenta SICORE 01/2023',NULL,1,'2023-02-02 11:25:16','2023-02-02 11:25:16',NULL),(136,8434,40846,119616,3,136,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7835.88,'Pago EDENOR',NULL,1,'2023-02-02 11:26:10','2023-02-02 11:26:10',NULL),(137,8434,40846,119616,3,137,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',246.68,'Pago METROGAS',NULL,1,'2023-02-02 11:26:43','2023-02-02 11:26:43',NULL),(138,8434,40846,119616,3,138,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',20862.29,'Pago IIBB 12/2022',NULL,1,'2023-02-02 11:27:46','2024-02-09 06:12:52','2024-02-09 06:12:52');
INSERT INTO `balance_libro` VALUES (139,8434,40846,119616,3,139,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',86963.36,'Pago DDJJ SICORE 12/2022 e Intereses viejos',NULL,1,'2023-02-02 11:30:42','2023-02-02 11:30:42',NULL),(140,8434,40846,119616,3,140,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',615000.00,'Pago Sueldos 12/2022',NULL,1,'2023-02-02 11:31:56','2023-02-02 11:31:56',NULL),(141,8434,40846,119616,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',139312.50,NULL,NULL,1,'2023-02-02 11:39:30','2023-02-02 11:39:30',NULL),(142,8434,40846,119616,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',139312.50,NULL,NULL,1,'2023-02-02 11:39:30','2023-02-02 11:39:30',NULL),(143,8434,40846,119616,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',278625.00,NULL,NULL,1,'2023-02-02 11:39:30','2023-02-02 11:39:30',NULL),(144,8434,40846,119616,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',48400.00,NULL,NULL,1,'2023-02-02 11:39:30','2023-02-02 11:39:30',NULL),(145,8434,40846,119616,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',24200.00,NULL,NULL,1,'2023-02-02 11:39:30','2023-02-02 11:39:30',NULL),(146,8434,40846,119616,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',157300.00,NULL,NULL,1,'2023-02-02 11:39:30','2023-02-02 11:39:30',NULL),(147,8434,40846,119616,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',96800.00,NULL,NULL,1,'2023-02-02 11:39:30','2023-02-02 11:39:30',NULL),(148,8434,40846,119616,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',24200.00,NULL,NULL,1,'2023-02-02 11:39:30','2023-02-02 11:39:30',NULL),(149,8434,40846,119616,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',108900.00,NULL,NULL,1,'2023-02-02 11:39:30','2023-02-02 11:39:30',NULL),(150,8434,40846,119616,2,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4840000.00,NULL,NULL,1,'2023-02-02 11:39:30','2023-02-02 11:39:30',NULL),(151,8434,40846,119616,20,136,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,136,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3828375.14,NULL,NULL,1,'2023-02-02 11:46:24','2023-02-02 11:46:24',NULL),(152,8434,40846,119616,3,152,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',433345.54,'Pago Tarjeta VISA',NULL,1,'2023-02-02 11:49:37','2023-02-09 18:22:59','2023-02-09 18:22:59'),(153,8434,40846,119616,3,153,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10902.50,'Taxi/UBER Enero',NULL,1,'2023-02-02 11:59:49','2023-02-10 02:18:54','2023-02-10 02:18:54'),(154,8434,40846,119616,3,154,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',20172.32,'Pago ABL',NULL,1,'2023-02-02 12:00:29','2023-02-02 12:01:33','2023-02-02 12:01:33'),(155,8434,40846,119616,3,155,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',20172.32,'Pago ABL',NULL,1,'2023-02-02 12:01:33','2023-02-02 12:01:33',NULL),(156,8434,40846,119616,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10717.80,NULL,NULL,1,'2023-02-02 12:10:09','2023-02-02 12:10:58','2023-02-02 12:10:58'),(157,8434,40846,119616,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10717.80,NULL,NULL,1,'2023-02-02 12:10:58','2023-02-10 08:42:47','2023-02-10 08:42:47');
INSERT INTO `balance_libro` VALUES (158,8434,40846,119616,3,158,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',42170.09,'Alquiler',NULL,1,'2023-02-02 12:57:38','2023-02-09 18:21:48','2023-02-09 18:21:48'),(159,8434,40846,119616,3,159,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',85834.53,'Pago Sicore mensual 12-2022',NULL,1,'2023-02-02 13:06:08','2023-02-10 01:52:14','2023-02-10 01:52:14'),(160,8433,40846,119616,3,160,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',209418.83,'Pago Cargas sociales 12-2022',NULL,1,'2023-02-02 13:08:50','2023-02-02 13:08:50',NULL),(161,8433,40846,119616,3,161,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1200.00,'Refrigerio',NULL,1,'2023-02-02 13:31:37','2023-02-02 13:31:37',NULL),(162,8433,40846,119616,20,140,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,140,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',3601855.04,NULL,NULL,1,'2023-02-02 13:54:18','2023-02-02 13:54:18',NULL),(163,8434,40846,119616,20,141,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,141,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',557250.00,NULL,NULL,1,'2023-02-02 13:58:13','2023-09-21 01:41:37','2023-09-21 01:41:37'),(164,8434,40846,119616,20,142,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,142,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',459800.00,NULL,NULL,1,'2023-02-02 14:07:35','2023-09-21 01:32:46','2023-09-21 01:32:46'),(165,8434,40846,119616,20,143,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,143,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4840000.00,NULL,NULL,1,'2023-02-02 14:09:04','2023-09-21 01:40:24','2023-09-21 01:40:24'),(166,8434,40846,119616,10,166,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',166804.99,'Asiento Preliminar IIBB 01-2023',NULL,1,'2023-02-03 13:59:31','2023-02-10 01:40:30','2023-02-10 01:40:30'),(167,8433,40846,119616,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9531.85,NULL,NULL,1,'2023-02-03 19:15:30','2023-02-03 19:15:30',NULL),(168,8434,40846,119616,5,168,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',372929.76,'Gastos Bancarios',NULL,1,'2023-02-03 19:18:27','2023-02-09 18:18:28','2023-02-09 18:18:28'),(169,8436,40762,54471,1,169,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1162952.01,'Devengamiento de Sueldos 01-2023',NULL,1,'2023-02-07 11:55:06','2023-02-07 11:55:06',NULL),(170,8433,40762,54471,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2655.44,NULL,NULL,1,'2023-02-07 13:02:15','2023-02-07 13:04:10','2023-02-07 13:04:10'),(171,8433,40762,54471,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2655.44,NULL,NULL,1,'2023-02-07 13:04:10','2023-02-07 13:39:14','2023-02-07 13:39:14'),(172,8433,40762,54471,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2145.87,NULL,NULL,1,'2023-02-07 13:39:14','2023-02-07 13:39:14',NULL),(173,8433,40762,54471,3,173,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',847526.00,'Pago de Sueldos',NULL,1,'2023-02-07 13:52:14','2023-02-07 13:52:14',NULL),(174,8436,40762,54471,19,174,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',351190.00,'Servicio de Consultoria',NULL,1,'2023-02-08 10:17:30','2023-02-08 10:17:30',NULL),(175,8433,40762,54471,5,175,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',350000.00,'Suscripción FCI Super Ahorro $ A',NULL,1,'2023-02-08 10:19:23','2023-02-08 10:19:23',NULL);
INSERT INTO `balance_libro` VALUES (176,8433,40762,54471,5,176,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1500000.00,'Suscripción FCI Super Ahorro $ A',NULL,1,'2023-02-08 10:21:50','2023-02-08 10:21:50',NULL),(177,8433,40762,54471,5,177,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',690000.00,'Suscripción FCI Super Ahorro $ A',NULL,1,'2023-02-08 10:22:53','2023-02-08 10:22:53',NULL),(178,8433,40762,54471,5,178,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1005034.98,'Rescate FCI Superfondo Renta fija A',NULL,1,'2023-02-08 10:25:36','2023-02-08 10:26:41','2023-02-08 10:26:41'),(179,8433,40762,54471,5,179,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1005034.98,'Rescate FCI Super ahorro $ A',NULL,1,'2023-02-08 10:26:41','2023-02-08 10:26:41',NULL),(180,8433,40762,54471,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',126483.01,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:14:21','2023-02-08 11:14:21'),(181,8433,40762,54471,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',15000.00,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:23:56','2023-02-08 11:23:56'),(182,8433,40762,54471,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',90205.50,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:03:37',NULL),(183,8433,40762,54471,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',150000.00,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:22:34','2023-02-08 11:22:34'),(184,8433,40762,54471,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',24889.70,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:03:37',NULL),(185,8433,40762,54471,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',55000.00,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:26:38','2023-02-08 11:26:38'),(186,8433,40762,54471,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',910000.01,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:03:37',NULL),(187,8433,40762,54471,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',185000.00,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:29:37','2023-02-08 11:29:37'),(188,8433,40762,54471,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',176680.00,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:24:58','2023-02-08 11:24:58'),(189,8433,40762,54471,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',60500.00,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:16:44','2023-02-08 11:16:44'),(190,8433,40762,54471,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',300000.00,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:21:20','2023-02-08 11:21:20'),(191,8433,40762,54471,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',47508.00,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:20:01','2023-02-08 11:20:01'),(192,8433,40762,54471,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',6684.76,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:03:37',NULL),(193,8433,40762,54471,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',10633.72,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:03:37',NULL),(194,8433,40762,54471,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',5900.00,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:32:04','2023-02-08 11:32:04');
INSERT INTO `balance_libro` VALUES (195,8433,40762,54471,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7827.26,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:03:37',NULL),(196,8433,40762,54471,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',367171.45,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:03:37',NULL),(197,8433,40762,54471,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',11684.30,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:46:42','2023-02-08 11:46:42'),(198,8433,40762,54471,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',0.00,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:03:37',NULL),(199,8433,40762,54471,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3231.12,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:03:37',NULL),(200,8433,40762,54471,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',81187.38,NULL,NULL,1,'2023-02-08 11:03:37','2023-02-08 11:43:39','2023-02-08 11:43:39'),(201,8433,40762,54471,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',378.43,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:03:38',NULL),(202,8433,40762,54471,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',30415.04,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:03:38',NULL),(203,8433,40762,54471,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',356432.22,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:03:38',NULL),(204,8433,40762,54471,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',345.62,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:03:38',NULL),(205,8433,40762,54471,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',3425.01,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:03:38',NULL),(206,8433,40762,54471,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',159.84,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:03:38',NULL),(207,8433,40762,54471,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1378.16,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:03:38',NULL),(208,8433,40762,54471,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',150000.00,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:57:54','2023-02-08 11:57:54'),(209,8433,40762,54471,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',18000.00,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:03:38',NULL),(210,8433,40762,54471,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',8265.03,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:03:38',NULL),(211,8433,40762,54471,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',24600.01,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:03:38',NULL),(212,8433,40762,54471,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',35002.28,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:03:38',NULL),(213,8433,40762,54471,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',136800.00,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 12:09:42','2023-02-08 12:09:42'),(214,8433,40762,54471,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15000.00,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:08:58','2023-02-08 11:08:58');
INSERT INTO `balance_libro` VALUES (215,8433,40762,54471,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2197500.74,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:53:03','2023-02-08 11:53:03'),(216,8433,40762,54471,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16252.79,NULL,NULL,1,'2023-02-08 11:03:38','2023-02-08 11:54:44','2023-02-08 11:54:44'),(217,8433,40762,54471,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15000.00,NULL,NULL,1,'2023-02-08 11:08:58','2023-02-08 11:08:58',NULL),(218,8433,40762,54471,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',126483.01,NULL,NULL,1,'2023-02-08 11:14:21','2023-02-08 11:14:21',NULL),(219,8433,40762,54471,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',60500.00,NULL,NULL,1,'2023-02-08 11:16:44','2023-02-08 11:16:44',NULL),(220,8433,40762,54471,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',47508.00,NULL,NULL,1,'2023-02-08 11:20:01','2023-02-08 11:20:01',NULL),(221,8433,40762,54471,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',300000.00,NULL,NULL,1,'2023-02-08 11:21:20','2023-02-08 11:21:20',NULL),(222,8433,40762,54471,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',150000.00,NULL,NULL,1,'2023-02-08 11:22:34','2023-02-08 11:22:34',NULL),(223,8433,40762,54471,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',15000.00,NULL,NULL,1,'2023-02-08 11:23:56','2023-02-08 11:23:56',NULL),(224,8433,40762,54471,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',176680.00,NULL,NULL,1,'2023-02-08 11:24:58','2023-02-08 11:24:58',NULL),(225,8433,40762,54471,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',55000.00,NULL,NULL,1,'2023-02-08 11:26:38','2023-02-08 11:26:38',NULL),(226,8433,40762,54471,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',185000.00,NULL,NULL,1,'2023-02-08 11:29:37','2023-02-08 11:29:37',NULL),(227,8433,40762,54471,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',5900.00,NULL,NULL,1,'2023-02-08 11:32:04','2023-02-08 11:32:04',NULL),(228,8433,40762,54471,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',81187.38,NULL,NULL,1,'2023-02-08 11:43:39','2023-02-08 11:43:39',NULL),(229,8433,40762,54471,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',11684.30,NULL,NULL,1,'2023-02-08 11:46:42','2023-02-08 11:46:42',NULL),(230,8433,40762,54471,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2197500.74,NULL,NULL,1,'2023-02-08 11:53:03','2023-02-08 11:53:03',NULL),(231,8433,40762,54471,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16252.79,NULL,NULL,1,'2023-02-08 11:54:44','2023-02-08 11:54:44',NULL),(232,8433,40762,54471,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',150000.00,NULL,NULL,1,'2023-02-08 11:57:54','2023-02-08 11:57:54',NULL),(233,8433,40762,54471,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',136800.00,NULL,NULL,1,'2023-02-08 12:09:42','2023-02-08 12:09:42',NULL),(234,8436,40762,54471,3,234,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',592729.65,'Tarjeta de Credito 01-2023',NULL,1,'2023-02-08 12:16:24','2023-02-08 12:16:24',NULL);
INSERT INTO `balance_libro` VALUES (235,8433,40762,54471,3,235,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',54021.12,'Pago Autonomos 12/2022',NULL,1,'2023-02-08 13:12:31','2023-02-08 13:12:31',NULL),(236,8433,40762,54471,3,236,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',19081.96,'Retenciones SICORE 12-2022',NULL,1,'2023-02-08 13:16:36','2023-02-08 13:16:36',NULL),(237,8433,40762,54471,3,237,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',14302.09,'Pago Cargas sociales 12-2022',NULL,1,'2023-02-08 13:19:21','2023-02-08 13:19:21',NULL),(238,8433,40762,54471,3,238,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',14614.87,'Pago IIBB 12-2022',NULL,1,'2023-02-08 13:25:30','2023-02-08 13:25:30',NULL),(239,8433,40762,54471,3,239,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',616299.90,'Pago IVA 10-2022',NULL,1,'2023-02-08 13:29:07','2023-02-08 13:29:07',NULL),(240,8433,40762,54471,3,240,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',167744.89,'Pago a cuenta SICORE 01-2023',NULL,1,'2023-02-08 13:30:57','2023-02-08 13:30:57',NULL),(241,8433,40762,54471,21,202,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,202,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',15000.00,NULL,NULL,1,'2023-02-08 14:12:17','2023-02-08 14:20:50','2023-02-08 14:20:50'),(242,8433,40762,54471,21,203,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,203,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',300000.00,NULL,NULL,1,'2023-02-08 14:21:47','2023-02-08 14:21:47',NULL),(243,8434,40846,119616,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',827.74,NULL,NULL,1,'2023-02-09 18:13:56','2023-02-09 18:13:56',NULL),(244,8434,40846,119616,5,244,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',372929.76,'Gastos Bancarios 01/2023',NULL,1,'2023-02-09 18:18:28','2024-02-09 05:51:34','2024-02-09 05:51:34'),(245,8434,40846,119616,3,245,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',180.00,'Peaje Tarjeta VISA',NULL,1,'2023-02-09 18:20:13','2023-02-09 18:20:13',NULL),(246,8434,40846,119616,3,246,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',42170.09,'Expensas Sr. Si 12/2022',NULL,1,'2023-02-09 18:21:48','2023-02-09 18:21:48',NULL),(247,8434,40846,119616,3,247,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',433345.54,'Pago Tarjeta VISA 12/2022',NULL,1,'2023-02-09 18:22:59','2023-02-09 18:22:59',NULL),(248,8434,40846,119616,3,248,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',13946.33,'Gastos Tarjeta de Credito 01/2023',NULL,1,'2023-02-09 18:28:13','2023-02-09 18:28:13',NULL),(249,8434,40846,119616,3,249,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2137.80,'GOOGLE *GSUITE_c P0OtnpOA',NULL,1,'2023-02-09 18:31:17','2023-02-09 18:31:17',NULL),(250,8434,40846,119616,3,250,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',6967.45,'GOOGLE CLOUD 5F A70534275USD',NULL,1,'2023-02-09 18:32:34','2023-02-09 18:32:34',NULL),(251,8434,40846,119616,3,251,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',8818.43,'Google LLC GSUIT A84436198',NULL,1,'2023-02-10 01:27:49','2023-02-10 01:27:49',NULL),(252,8434,40846,119616,3,252,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',360.73,'GOOGLE *Google S P0OJWptx',NULL,1,'2023-02-10 01:29:14','2023-02-10 01:29:14',NULL);
INSERT INTO `balance_libro` VALUES (253,8434,40846,119616,16,253,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',166804.99,'Asiento Preliminar IIBB 01-2023',NULL,1,'2023-02-10 01:40:30','2023-04-09 20:31:10','2023-04-09 20:31:10'),(254,8434,40846,119616,3,254,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',85834.53,'Pago Sicore mensual 12-2022',NULL,1,'2023-02-10 01:52:14','2023-02-10 01:52:14',NULL),(255,8434,40846,119616,20,206,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,206,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2812645.63,NULL,NULL,1,'2023-02-10 02:01:56','2023-02-10 02:01:56',NULL),(256,8434,40846,119616,21,207,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,207,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9531.85,NULL,NULL,1,'2023-02-10 02:05:29','2023-02-10 02:05:29',NULL),(257,8434,40846,119616,21,208,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,208,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',827.74,NULL,NULL,1,'2023-02-10 02:06:14','2023-02-10 02:06:14',NULL),(258,8434,40846,119616,3,258,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',11622.50,'Taxi/UBER Enero',NULL,1,'2023-02-10 02:18:54','2023-02-10 02:18:54',NULL),(259,8434,40846,119616,11,259,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',393770.39,'Reversion Anticipo de clientes LDC',NULL,1,'2023-02-10 02:21:38','2023-02-10 02:21:38',NULL),(260,8434,40846,119616,11,260,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',155625.74,'Reversion provision para gastos 12/2022',NULL,1,'2023-02-10 02:23:27','2023-02-10 02:24:52','2023-02-10 02:24:52'),(261,8434,40846,119616,11,261,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',155625.74,'Reversion provision para gastos 12/2022',NULL,1,'2023-02-10 02:24:52','2023-12-07 15:51:19','2023-12-07 15:51:19'),(262,8434,40846,119616,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10717.80,NULL,NULL,1,'2023-02-10 08:42:47','2023-02-10 08:42:47',NULL),(263,8434,40846,119616,1,263,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',802930.36,'Devengamiento Sueldos 01/2023',NULL,1,'2023-02-10 09:26:57','2023-04-18 13:36:26','2023-04-18 13:36:26'),(264,8434,40846,119616,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',57632.89,NULL,NULL,1,'2023-02-10 10:17:49','2023-02-10 10:17:49',NULL),(265,8433,40762,54471,21,212,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,212,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',15000.00,NULL,NULL,1,'2023-02-10 10:51:43','2023-02-10 10:51:43',NULL),(266,8433,40762,54471,21,213,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,213,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',176680.00,NULL,NULL,1,'2023-02-10 10:53:25','2023-02-10 10:53:25',NULL),(267,8433,40762,54471,21,214,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,214,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',55000.00,NULL,NULL,1,'2023-02-10 10:54:17','2023-02-10 10:54:17',NULL),(268,8433,40762,54471,21,215,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,215,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',90205.50,NULL,NULL,1,'2023-02-10 10:55:26','2023-02-10 10:55:26',NULL),(269,8433,40762,54471,21,216,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,216,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',185000.00,NULL,NULL,1,'2023-02-10 10:56:22','2023-02-10 10:56:22',NULL),(270,8433,40762,54471,21,217,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,217,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',150000.00,NULL,NULL,1,'2023-02-10 10:58:52','2023-02-10 10:58:52',NULL),(271,8433,40762,54471,21,218,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,218,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',60500.00,NULL,NULL,1,'2023-02-10 10:59:55','2023-02-10 10:59:55',NULL);
INSERT INTO `balance_libro` VALUES (272,8433,40762,54471,21,219,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,219,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',5900.00,NULL,NULL,1,'2023-02-10 11:00:52','2023-02-10 11:00:52',NULL),(273,8433,40762,54471,21,220,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,220,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2145.87,NULL,NULL,1,'2023-02-10 11:02:21','2023-02-10 11:02:21',NULL),(274,8433,40762,54471,5,274,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',202414.05,'Otros Gastos bancarios',NULL,1,'2023-02-10 11:15:52','2023-02-10 11:15:52',NULL),(275,8437,40881,140823,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5039.66,NULL,NULL,1,'2023-02-13 10:04:34','2023-02-13 10:29:08','2023-02-13 10:29:08'),(276,8437,40881,140823,3,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',12800.00,NULL,NULL,1,'2023-02-13 10:04:34','2023-02-13 10:25:25','2023-02-13 10:25:25'),(277,8437,40881,140823,3,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',47633.76,NULL,NULL,1,'2023-02-13 10:04:34','2023-04-05 13:48:15','2023-04-05 13:48:15'),(278,8437,40881,140823,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',10913.33,NULL,NULL,1,'2023-02-13 10:04:34','2023-04-05 13:49:22','2023-04-05 13:49:22'),(279,8437,40881,140823,3,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',5565.89,NULL,NULL,1,'2023-02-13 10:04:34','2023-04-05 13:50:02','2023-04-05 13:50:02'),(280,8437,40881,140823,3,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3000.00,NULL,NULL,1,'2023-02-13 10:04:34','2023-04-20 10:02:50','2023-04-20 10:02:50'),(281,8437,40881,140823,3,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',15624.58,NULL,NULL,1,'2023-02-13 10:04:34','2023-04-05 13:52:08','2023-04-05 13:52:08'),(282,8437,40881,140823,3,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1678.42,NULL,NULL,1,'2023-02-13 10:04:34','2023-02-13 10:23:04','2023-02-13 10:23:04'),(283,8437,40881,140823,3,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',16393.51,NULL,NULL,1,'2023-02-13 10:04:34','2023-04-05 13:54:13','2023-04-05 13:54:13'),(284,8437,40881,140823,3,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',95.00,NULL,NULL,1,'2023-02-13 10:04:34','2023-04-05 13:52:41','2023-04-05 13:52:41'),(285,8437,40881,140823,3,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',26961.55,NULL,NULL,1,'2023-02-13 10:04:34','2023-04-05 13:55:38','2023-04-05 13:55:38'),(286,8437,40881,140823,3,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',206.61,NULL,NULL,1,'2023-02-13 10:04:34','2023-02-13 10:18:37','2023-02-13 10:18:37'),(287,8437,40881,140823,3,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',492000.00,NULL,NULL,1,'2023-02-13 10:04:34','2023-02-13 10:14:51','2023-02-13 10:14:51'),(288,8437,40881,140823,3,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1620.00,NULL,NULL,1,'2023-02-13 10:04:34','2023-04-05 13:56:58','2023-04-05 13:56:58'),(289,8437,40881,140823,3,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',40040.11,NULL,NULL,1,'2023-02-13 10:04:34','2023-04-05 13:57:47','2023-04-05 13:57:47'),(290,8437,40881,140823,3,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',492000.00,NULL,NULL,1,'2023-02-13 10:14:51','2023-04-05 13:56:18','2023-04-05 13:56:18');
INSERT INTO `balance_libro` VALUES (291,8437,40881,140823,3,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',206.61,NULL,NULL,1,'2023-02-13 10:18:37','2023-04-20 10:04:14','2023-04-20 10:04:14'),(292,8437,40881,140823,3,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1678.44,NULL,NULL,1,'2023-02-13 10:23:04','2023-04-05 13:53:19','2023-04-05 13:53:19'),(293,8437,40881,140823,3,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',12800.00,NULL,NULL,1,'2023-02-13 10:25:25','2023-04-05 13:47:21','2023-04-05 13:47:21'),(294,8437,40881,140823,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5039.66,NULL,NULL,1,'2023-02-13 10:29:08','2023-04-05 13:45:59','2023-04-05 13:45:59'),(295,8437,40881,140823,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',256663.06,NULL,NULL,1,'2023-02-13 10:36:40','2023-02-13 10:36:40',NULL),(296,8437,40881,140823,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',221447.00,NULL,NULL,1,'2023-02-13 10:36:40','2023-02-13 10:36:40',NULL),(297,8437,40881,140823,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',151039.00,NULL,NULL,1,'2023-02-13 10:36:40','2023-02-13 10:36:40',NULL),(298,8437,40881,140823,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',221447.00,NULL,NULL,1,'2023-02-13 10:36:41','2023-02-13 10:36:41',NULL),(299,8437,40881,140823,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',7125.00,NULL,NULL,1,'2023-02-13 10:36:41','2023-02-13 10:36:41',NULL),(300,8437,40881,140823,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',202077.00,NULL,NULL,1,'2023-02-13 10:36:41','2023-02-13 10:36:41',NULL),(301,8437,40881,140823,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',334535.00,NULL,NULL,1,'2023-02-13 10:36:41','2023-02-13 10:36:41',NULL),(302,8437,40881,140823,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',161109.00,NULL,NULL,1,'2023-02-13 10:36:41','2023-02-13 10:36:41',NULL),(303,8437,40881,140823,3,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',5919.86,NULL,NULL,1,'2023-02-13 12:05:44','2023-02-13 12:05:44',NULL),(304,8437,40881,140823,3,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',13223.46,NULL,NULL,1,'2023-02-13 12:08:36','2023-02-13 12:08:36',NULL),(305,8437,40881,140823,3,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',5524.67,NULL,NULL,1,'2023-02-13 12:10:41','2023-02-13 12:10:41',NULL),(306,8437,40884,145368,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',78776.00,NULL,NULL,1,'2023-02-13 12:20:20','2023-02-13 12:20:20',NULL),(307,8437,40884,145368,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',14631.34,NULL,NULL,1,'2023-02-13 12:20:20','2023-02-13 12:20:20',NULL),(308,8437,40884,145368,3,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3050.01,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:22:07',NULL),(309,8437,40884,145368,3,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',22589.01,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:22:07',NULL),(310,8437,40884,145368,3,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',652.00,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:22:07',NULL);
INSERT INTO `balance_libro` VALUES (311,8437,40884,145368,3,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1552.16,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:27:17','2023-02-13 12:27:17'),(312,8437,40884,145368,3,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2843.38,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:28:53','2023-02-13 12:28:53'),(313,8437,40884,145368,3,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',489.00,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:22:07',NULL),(314,8437,40884,145368,3,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',513.39,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:29:49','2023-02-13 12:29:49'),(315,8437,40884,145368,3,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8741.12,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:30:53','2023-02-13 12:30:53'),(316,8437,40884,145368,3,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',7876.70,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:22:07',NULL),(317,8437,40884,145368,3,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',208.26,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:31:39','2023-02-13 12:31:39'),(318,8437,40884,145368,3,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',6425.00,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:22:07',NULL),(319,8437,40884,145368,3,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',828.78,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:32:58','2023-02-13 12:32:58'),(320,8437,40884,145368,3,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1737.00,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:22:07',NULL),(321,8437,40884,145368,3,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',11773.19,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:22:07',NULL),(322,8437,40884,145368,3,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',20575.38,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:34:13','2023-02-13 12:34:13'),(323,8437,40884,145368,3,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',28947.72,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:35:51','2023-02-13 12:35:51'),(324,8437,40884,145368,3,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2107.10,NULL,NULL,1,'2023-02-13 12:22:07','2023-02-13 12:22:07',NULL),(325,8437,40884,145368,3,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1552.17,NULL,NULL,1,'2023-02-13 12:27:17','2023-02-13 12:27:17',NULL),(326,8437,40884,145368,3,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2843.39,NULL,NULL,1,'2023-02-13 12:28:53','2023-02-13 12:28:53',NULL),(327,8437,40884,145368,3,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',513.39,NULL,NULL,1,'2023-02-13 12:29:49','2023-02-13 12:29:49',NULL),(328,8437,40884,145368,3,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8741.12,NULL,NULL,1,'2023-02-13 12:30:53','2023-02-13 12:30:53',NULL),(329,8437,40884,145368,3,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',208.26,NULL,NULL,1,'2023-02-13 12:31:39','2023-02-13 12:31:39',NULL),(330,8437,40884,145368,3,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',828.78,NULL,NULL,1,'2023-02-13 12:32:58','2023-02-13 12:32:58',NULL);
INSERT INTO `balance_libro` VALUES (331,8437,40884,145368,3,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',20575.38,NULL,NULL,1,'2023-02-13 12:34:13','2023-02-13 12:34:13',NULL),(332,8437,40884,145368,3,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',28947.72,NULL,NULL,1,'2023-02-13 12:35:51','2023-02-13 12:35:51',NULL),(333,8437,40884,145368,3,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',9400.17,NULL,NULL,1,'2023-02-13 12:45:29','2023-02-13 12:45:29',NULL),(334,8437,40884,145368,3,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',20802.53,NULL,NULL,1,'2023-02-13 12:47:37','2023-02-13 12:47:37',NULL),(335,8437,40884,145368,3,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',13544.68,NULL,NULL,1,'2023-02-13 12:49:43','2023-02-13 12:49:43',NULL),(336,8437,40885,146883,3,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3050.01,NULL,NULL,1,'2023-02-13 13:02:11','2023-02-13 13:02:11',NULL),(337,8437,40885,146883,3,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7777.89,NULL,NULL,1,'2023-02-13 13:02:11','2023-02-13 13:02:11',NULL),(338,8437,40885,146883,3,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',11440.00,NULL,NULL,1,'2023-02-13 13:02:11','2023-02-13 13:02:11',NULL),(339,8437,40885,146883,3,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8220.99,NULL,NULL,1,'2023-02-13 13:05:52','2023-02-13 13:05:52',NULL),(340,8437,40885,146883,3,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',7059.31,NULL,NULL,1,'2023-02-13 13:08:04','2023-02-13 13:08:04',NULL),(341,8437,40941,231723,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2999.99,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:23:46',NULL),(342,8437,40941,231723,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',16760.00,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:27:16','2023-02-14 09:27:16'),(343,8437,40941,231723,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',24017.48,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:23:46',NULL),(344,8437,40941,231723,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',75956.19,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:23:46',NULL),(345,8437,40941,231723,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',33659.22,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:23:46',NULL),(346,8437,40941,231723,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5900.00,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:23:46',NULL),(347,8437,40941,231723,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5204.93,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:23:46',NULL),(348,8437,40941,231723,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3715.06,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:23:46',NULL),(349,8437,40941,231723,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',202761.43,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:23:46',NULL),(350,8437,40941,231723,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',105809.39,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:23:46',NULL),(351,8437,40941,231723,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4640.00,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:23:46',NULL);
INSERT INTO `balance_libro` VALUES (352,8437,40941,231723,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',3731.70,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:23:46',NULL),(353,8437,40941,231723,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9896.03,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:31:30','2023-02-14 09:31:30'),(354,8437,40941,231723,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17355.34,NULL,NULL,1,'2023-02-14 09:23:46','2023-02-14 09:32:45','2023-02-14 09:32:45'),(355,8437,40941,231723,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',16760.00,NULL,NULL,1,'2023-02-14 09:27:16','2023-02-14 09:27:16',NULL),(356,8437,40941,231723,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9896.03,NULL,NULL,1,'2023-02-14 09:31:30','2023-02-14 09:31:30',NULL),(357,8437,40941,231723,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17355.34,NULL,NULL,1,'2023-02-14 09:32:45','2023-02-14 09:32:45',NULL),(358,8437,40941,231723,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',11500.50,NULL,NULL,1,'2023-02-14 09:41:05','2023-02-14 09:41:05',NULL),(359,8437,40941,231723,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',12100.40,NULL,NULL,1,'2023-02-14 09:42:58','2023-02-14 09:42:58',NULL),(360,8437,40941,231723,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10909.60,NULL,NULL,1,'2023-02-14 09:44:30','2023-02-14 09:44:30',NULL),(361,8437,40941,231723,3,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',3150.01,NULL,NULL,1,'2023-02-14 09:46:29','2023-02-14 09:46:29',NULL),(362,8437,40790,42351,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',15040.01,NULL,NULL,1,'2023-02-14 10:09:54','2023-02-14 10:09:54',NULL),(363,8437,40790,42351,3,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',17800.00,NULL,NULL,1,'2023-02-14 10:09:54','2023-02-14 10:09:54',NULL),(364,8437,40790,42351,3,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',74142.00,NULL,NULL,1,'2023-02-14 10:09:54','2023-02-14 10:09:54',NULL),(365,8437,40790,42351,3,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',158043.84,NULL,NULL,1,'2023-02-14 10:09:54','2023-02-14 10:09:54',NULL),(366,8437,40790,42351,3,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1735.27,NULL,NULL,1,'2023-02-14 10:09:55','2023-02-14 10:09:55',NULL),(367,8437,40790,42351,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',21823.56,NULL,NULL,1,'2023-02-14 10:09:55','2023-02-14 10:09:55',NULL),(368,8437,40790,42351,3,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',74920.00,NULL,NULL,1,'2023-02-14 10:09:55','2023-02-14 10:09:55',NULL),(369,8437,40790,42351,3,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',5210.13,NULL,NULL,1,'2023-02-14 10:09:55','2023-02-14 10:09:55',NULL),(370,8437,40790,42351,3,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',88509.70,NULL,NULL,1,'2023-02-14 10:09:55','2023-02-14 10:09:55',NULL),(371,8437,40790,42351,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10911.78,NULL,NULL,1,'2023-02-14 10:09:55','2023-02-14 10:09:55',NULL),(372,8437,40790,42351,3,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',115381.80,NULL,NULL,1,'2023-02-14 10:09:55','2023-02-14 10:09:55',NULL);
INSERT INTO `balance_libro` VALUES (373,8437,40790,42351,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',72673.86,NULL,NULL,1,'2023-02-14 10:09:55','2023-02-14 10:09:55',NULL),(374,8437,40790,42351,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',260.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(375,8437,40790,42351,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',450.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(376,8437,40790,42351,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',100.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(377,8437,40790,42351,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',350.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(378,8437,40790,42351,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',255.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(379,8437,40790,42351,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',720.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(380,8437,40790,42351,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',660.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(381,8437,40790,42351,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',110.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(382,8437,40790,42351,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',350.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(383,8437,40790,42351,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',650.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(384,8437,40790,42351,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',320.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(385,8437,40790,42351,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',670.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(386,8437,40790,42351,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',340.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(387,8437,40790,42351,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1080.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(388,8437,40790,42351,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',360.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(389,8437,40790,42351,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',600.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(390,8437,40790,42351,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',480.00,NULL,NULL,1,'2023-02-14 10:10:16','2023-02-14 10:10:16',NULL),(391,8437,40790,42351,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',120.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(392,8437,40790,42351,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',380.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(393,8437,40790,42351,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',320.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL);
INSERT INTO `balance_libro` VALUES (394,8437,40790,42351,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',160.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(395,8437,40790,42351,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',720.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(396,8437,40790,42351,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1190.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(397,8437,40790,42351,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',100.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(398,8437,40790,42351,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',550.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(399,8437,40790,42351,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',240.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(400,8437,40790,42351,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',180.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(401,8437,40790,42351,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',180.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(402,8437,40790,42351,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',65.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(403,8437,40790,42351,2,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',150.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(404,8437,40790,42351,2,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',590.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(405,8437,40790,42351,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',500.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(406,8437,40790,42351,2,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',370.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(407,8437,40790,42351,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',680.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(408,8437,40790,42351,2,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',190.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(409,8437,40790,42351,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',135.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(410,8437,40790,42351,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',720.00,NULL,NULL,1,'2023-02-14 10:10:17','2023-02-14 10:10:17',NULL),(411,8437,40790,42351,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1090.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(412,8437,40790,42351,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',360.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(413,8437,40790,42351,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',360.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(414,8437,40790,42351,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',120.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL);
INSERT INTO `balance_libro` VALUES (415,8437,40790,42351,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',260.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(416,8437,40790,42351,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',140.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(417,8437,40790,42351,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',360.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(418,8437,40790,42351,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',240.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(419,8437,40790,42351,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',480.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(420,8437,40790,42351,2,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1070.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(421,8437,40790,42351,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',720.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(422,8437,40790,42351,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',720.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(423,8437,40790,42351,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',360.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(424,8437,40790,42351,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',150.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(425,8437,40790,42351,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',890.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(426,8437,40790,42351,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',700.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(427,8437,40790,42351,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',360.00,NULL,NULL,1,'2023-02-14 10:10:18','2023-02-14 10:10:18',NULL),(428,8437,40790,42351,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',540.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(429,8437,40790,42351,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1040.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(430,8437,40790,42351,2,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',360.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(431,8437,40790,42351,2,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1180.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(432,8437,40790,42351,2,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',450.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(433,8437,40790,42351,2,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',720.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(434,8437,40790,42351,2,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',700.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(435,8437,40790,42351,2,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',110.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL);
INSERT INTO `balance_libro` VALUES (436,8437,40790,42351,2,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',700.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(437,8437,40790,42351,2,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',920.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(438,8437,40790,42351,2,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',720.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(439,8437,40790,42351,2,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',720.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(440,8437,40790,42351,2,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',150.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(441,8437,40790,42351,2,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',240.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(442,8437,40790,42351,2,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1090.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(443,8437,40790,42351,2,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',360.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(444,8437,40790,42351,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',720.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(445,8437,40790,42351,2,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',100.00,NULL,NULL,1,'2023-02-14 10:10:19','2023-02-14 10:10:19',NULL),(446,8437,40790,42351,2,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',370.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(447,8437,40790,42351,2,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',720.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(448,8437,40790,42351,2,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',360.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(449,8437,40790,42351,2,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',720.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(450,8437,40790,42351,2,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',360.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(451,8437,40790,42351,2,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',140.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(452,8437,40790,42351,2,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',600.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(453,8437,40790,42351,2,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',920.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(454,8437,40790,42351,2,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',80.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(455,8437,40790,42351,2,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',190.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(456,8437,40790,42351,2,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',200.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL);
INSERT INTO `balance_libro` VALUES (457,8437,40790,42351,2,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',150.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(458,8437,40790,42351,2,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',520.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(459,8437,40790,42351,2,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',360.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(460,8437,40790,42351,2,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',840.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(461,8437,40790,42351,2,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',450.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(462,8437,40790,42351,2,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',120.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(463,8437,40790,42351,2,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',240.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(464,8437,40790,42351,2,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',720.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(465,8437,40790,42351,2,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',360.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(466,8437,40790,42351,2,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',230.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(467,8437,40790,42351,2,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',100.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(468,8437,40790,42351,2,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',720.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(469,8437,40790,42351,2,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',360.00,NULL,NULL,1,'2023-02-14 10:10:20','2023-02-14 10:10:20',NULL),(470,8437,40790,42351,2,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',180.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(471,8437,40790,42351,2,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',110.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(472,8437,40790,42351,2,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',510.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(473,8437,40790,42351,2,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',280.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(474,8437,40790,42351,2,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',180.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(475,8437,40790,42351,2,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',840.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(476,8437,40790,42351,2,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',360.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(477,8437,40790,42351,2,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',360.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL);
INSERT INTO `balance_libro` VALUES (478,8437,40790,42351,2,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',940.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(479,8437,40790,42351,2,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',900.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(480,8437,40790,42351,2,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',840.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(481,8437,40790,42351,2,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',90.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(482,8437,40790,42351,2,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',360.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(483,8437,40790,42351,2,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',150.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(484,8437,40790,42351,2,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',150.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(485,8437,40790,42351,2,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',360.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(486,8437,40790,42351,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',60.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(487,8437,40790,42351,2,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',150.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(488,8437,40790,42351,2,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',180.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(489,8437,40790,42351,2,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',740.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(490,8437,40790,42351,2,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',690.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(491,8437,40790,42351,2,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',720.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(492,8437,40790,42351,2,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',360.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(493,8437,40790,42351,2,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',780.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(494,8437,40790,42351,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',550.00,NULL,NULL,1,'2023-02-14 10:10:21','2023-02-14 10:10:21',NULL),(495,8437,40790,42351,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',120.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(496,8437,40790,42351,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',360.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(497,8437,40790,42351,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',680.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(498,8437,40790,42351,2,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',360.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL);
INSERT INTO `balance_libro` VALUES (499,8437,40790,42351,2,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',360.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(500,8437,40790,42351,2,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',360.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(501,8437,40790,42351,2,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',350.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(502,8437,40790,42351,2,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',420.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(503,8437,40790,42351,2,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1100.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(504,8437,40790,42351,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',480.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(505,8437,40790,42351,2,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',530.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(506,8437,40790,42351,2,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',720.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(507,8437,40790,42351,2,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',480.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(508,8437,40790,42351,2,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',720.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(509,8437,40790,42351,2,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1120.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(510,8437,40790,42351,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',400.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(511,8437,40790,42351,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',150.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(512,8437,40790,42351,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',180.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(513,8437,40790,42351,2,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',820.00,NULL,NULL,1,'2023-02-14 10:10:22','2023-02-14 10:10:22',NULL),(514,8437,40790,42351,2,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',350.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(515,8437,40790,42351,2,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',500.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(516,8437,40790,42351,2,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',720.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(517,8437,40790,42351,2,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',360.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(518,8437,40790,42351,2,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',890.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(519,8437,40790,42351,2,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',480.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL);
INSERT INTO `balance_libro` VALUES (520,8437,40790,42351,2,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1040.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(521,8437,40790,42351,2,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1130.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(522,8437,40790,42351,2,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',690.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(523,8437,40790,42351,2,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',90.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(524,8437,40790,42351,2,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',560.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(525,8437,40790,42351,2,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',370.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(526,8437,40790,42351,2,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',150.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(527,8437,40790,42351,2,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',600.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(528,8437,40790,42351,2,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',910.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(529,8437,40790,42351,2,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',90.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(530,8437,40790,42351,2,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',720.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(531,8437,40790,42351,2,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1090.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(532,8437,40790,42351,2,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1440.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(533,8437,40790,42351,2,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',300.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(534,8437,40790,42351,2,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',380.00,NULL,NULL,1,'2023-02-14 10:10:23','2023-02-14 10:10:23',NULL),(535,8437,40790,42351,2,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',180.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(536,8437,40790,42351,2,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',720.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(537,8437,40790,42351,2,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',200.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(538,8437,40790,42351,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',70.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(539,8437,40790,42351,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',100.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(540,8437,40790,42351,2,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',360.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL);
INSERT INTO `balance_libro` VALUES (541,8437,40790,42351,2,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1880.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(542,8437,40790,42351,2,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',540.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(543,8437,40790,42351,2,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',320.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(544,8437,40790,42351,2,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',180.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(545,8437,40790,42351,2,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',720.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(546,8437,40790,42351,2,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',300.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(547,8437,40790,42351,2,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1030.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(548,8437,40790,42351,2,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',360.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(549,8437,40790,42351,2,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',150.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(550,8437,40790,42351,2,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',770.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(551,8437,40790,42351,2,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',600.00,NULL,NULL,1,'2023-02-14 10:10:24','2023-02-14 10:10:24',NULL),(552,8437,40790,42351,2,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',130.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(553,8437,40790,42351,2,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',320.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(554,8437,40790,42351,2,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1420.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(555,8437,40790,42351,2,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',210.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(556,8437,40790,42351,2,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',360.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(557,8437,40790,42351,2,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',450.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(558,8437,40790,42351,2,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',90.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(559,8437,40790,42351,2,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',380.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(560,8437,40790,42351,2,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',70.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(561,8437,40790,42351,2,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',360.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL);
INSERT INTO `balance_libro` VALUES (562,8437,40790,42351,2,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',330.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(563,8437,40790,42351,2,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',240.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(564,8437,40790,42351,2,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',450.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(565,8437,40790,42351,2,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',360.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(566,8437,40790,42351,2,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',250.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(567,8437,40790,42351,2,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',360.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(568,8437,40790,42351,2,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',240.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(569,8437,40790,42351,2,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',550.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(570,8437,40790,42351,2,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',360.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(571,8437,40790,42351,2,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',940.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(572,8437,40790,42351,2,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1060.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(573,8437,40790,42351,2,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',720.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(574,8437,40790,42351,2,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',60.00,NULL,NULL,1,'2023-02-14 10:10:25','2023-02-14 10:10:25',NULL),(575,8437,40790,42351,2,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',720.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL),(576,8437,40790,42351,2,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1080.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL),(577,8437,40790,42351,2,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',360.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL),(578,8437,40790,42351,2,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',960.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL),(579,8437,40790,42351,2,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',480.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL),(580,8437,40790,42351,2,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',150.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL),(581,8437,40790,42351,2,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',360.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL),(582,8437,40790,42351,2,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',190.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL);
INSERT INTO `balance_libro` VALUES (583,8437,40790,42351,2,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1070.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL),(584,8437,40790,42351,2,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',430.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL),(585,8437,40790,42351,2,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1080.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL),(586,8437,40790,42351,2,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',610.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL),(587,8437,40790,42351,2,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',360.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL),(588,8437,40790,42351,2,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',0.00,NULL,NULL,1,'2023-02-14 10:10:26','2023-02-14 10:10:26',NULL),(589,8437,40790,42351,2,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',720.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(590,8437,40790,42351,2,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',160.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(591,8437,40790,42351,2,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',150.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(592,8437,40790,42351,2,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',180.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(593,8437,40790,42351,2,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',360.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(594,8437,40790,42351,2,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',360.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(595,8437,40790,42351,2,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',360.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(596,8437,40790,42351,2,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1220.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(597,8437,40790,42351,2,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1440.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(598,8437,40790,42351,2,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',240.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(599,8437,40790,42351,2,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',250.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(600,8437,40790,42351,2,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',270.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(601,8437,40790,42351,2,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',720.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(602,8437,40790,42351,2,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',500.00,NULL,NULL,1,'2023-02-14 10:10:27','2023-02-14 10:10:27',NULL),(603,8437,40790,42351,2,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',360.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL);
INSERT INTO `balance_libro` VALUES (604,8437,40790,42351,2,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',940.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(605,8437,40790,42351,2,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',360.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(606,8437,40790,42351,2,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',100.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(607,8437,40790,42351,2,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',210.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(608,8437,40790,42351,2,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',360.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(609,8437,40790,42351,2,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',90.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(610,8437,40790,42351,2,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',630.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(611,8437,40790,42351,2,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',870.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(612,8437,40790,42351,2,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',570.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(613,8437,40790,42351,2,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',720.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(614,8437,40790,42351,2,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',660.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(615,8437,40790,42351,2,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',720.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(616,8437,40790,42351,2,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',840.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(617,8437,40790,42351,2,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',540.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(618,8437,40790,42351,2,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',480.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(619,8437,40790,42351,2,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',100.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(620,8437,40790,42351,2,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',350.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(621,8437,40790,42351,2,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',100.00,NULL,NULL,1,'2023-02-14 10:10:28','2023-02-14 10:10:28',NULL),(622,8437,40790,42351,2,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',200.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL),(623,8437,40790,42351,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',360.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL),(624,8437,40790,42351,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',720.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL);
INSERT INTO `balance_libro` VALUES (625,8437,40790,42351,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',770.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL),(626,8437,40790,42351,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',720.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL),(627,8437,40790,42351,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',360.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL),(628,8437,40790,42351,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',240.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL),(629,8437,40790,42351,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',720.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL),(630,8437,40790,42351,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',700.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL),(631,8437,40790,42351,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',300.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL),(632,8437,40790,42351,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',120.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL),(633,8437,40790,42351,2,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',180.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL),(634,8437,40790,42351,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',610.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL),(635,8437,40790,42351,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',190.00,NULL,NULL,1,'2023-02-14 10:10:29','2023-02-14 10:10:29',NULL),(636,8437,40790,42351,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',670.00,NULL,NULL,1,'2023-02-14 10:10:30','2023-02-14 10:10:30',NULL),(637,8437,40790,42351,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',150.00,NULL,NULL,1,'2023-02-14 10:10:30','2023-02-14 10:10:30',NULL),(638,8437,40790,42351,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',120.00,NULL,NULL,1,'2023-02-14 10:10:30','2023-02-14 10:10:30',NULL),(639,8437,40790,42351,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1540.00,NULL,NULL,1,'2023-02-14 10:10:30','2023-02-14 10:10:30',NULL),(640,8437,40790,42351,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',710.00,NULL,NULL,1,'2023-02-14 10:10:30','2023-02-14 10:10:30',NULL),(641,8437,40790,42351,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',800.00,NULL,NULL,1,'2023-02-14 10:10:30','2023-02-14 10:10:30',NULL),(642,8437,40790,42351,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',360.00,NULL,NULL,1,'2023-02-14 10:10:30','2023-02-14 10:10:30',NULL),(643,8437,40790,42351,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',480.00,NULL,NULL,1,'2023-02-14 10:10:30','2023-02-14 10:10:30',NULL),(644,8437,40790,42351,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',880.00,NULL,NULL,1,'2023-02-14 10:10:30','2023-02-14 10:10:30',NULL),(645,8437,40790,42351,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',720.00,NULL,NULL,1,'2023-02-14 10:10:30','2023-02-14 10:10:30',NULL);
INSERT INTO `balance_libro` VALUES (646,8437,40790,42351,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',120.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(647,8437,40790,42351,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',500.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(648,8437,40790,42351,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',290.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(649,8437,40790,42351,2,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',200.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(650,8437,40790,42351,2,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',510.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(651,8437,40790,42351,2,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',360.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(652,8437,40790,42351,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',360.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(653,8437,40790,42351,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1100.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(654,8437,40790,42351,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',360.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(655,8437,40790,42351,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',920.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(656,8437,40790,42351,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',360.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(657,8437,40790,42351,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',360.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(658,8437,40790,42351,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',300.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(659,8437,40790,42351,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',300.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(660,8437,40790,42351,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',810.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(661,8437,40790,42351,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',100.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(662,8437,40790,42351,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',360.00,NULL,NULL,1,'2023-02-14 10:10:31','2023-02-14 10:10:31',NULL),(663,8437,40790,42351,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',360.00,NULL,NULL,1,'2023-02-14 10:10:32','2023-02-14 10:10:32',NULL),(664,8437,40790,42351,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',300.00,NULL,NULL,1,'2023-02-14 10:10:32','2023-02-14 10:10:32',NULL),(665,8437,40790,42351,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',100.00,NULL,NULL,1,'2023-02-14 10:10:32','2023-02-14 10:10:32',NULL),(666,8437,40790,42351,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',480.00,NULL,NULL,1,'2023-02-14 10:10:32','2023-02-14 10:10:32',NULL);
INSERT INTO `balance_libro` VALUES (667,8437,40880,139308,3,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2636.71,NULL,NULL,1,'2023-02-14 10:17:57','2023-02-14 10:17:57',NULL),(668,8437,40880,139308,3,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',16389.99,NULL,NULL,1,'2023-02-14 10:17:57','2023-02-14 10:17:57',NULL),(669,8437,40880,139308,3,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',19912.00,NULL,NULL,1,'2023-02-14 10:17:57','2023-02-14 10:17:57',NULL),(670,8437,40880,139308,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',15850.38,NULL,NULL,1,'2023-02-14 10:17:57','2023-02-14 10:22:05','2023-02-14 10:22:05'),(671,8437,40880,139308,3,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',43419.19,NULL,NULL,1,'2023-02-14 10:17:57','2023-02-14 10:17:57',NULL),(672,8437,40880,139308,3,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',420.00,NULL,NULL,1,'2023-02-14 10:17:57','2023-02-14 10:17:57',NULL),(673,8437,40880,139308,3,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1550.00,NULL,NULL,1,'2023-02-14 10:17:57','2023-02-14 10:17:57',NULL),(674,8437,40880,139308,3,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',6472.89,NULL,NULL,1,'2023-02-14 10:17:57','2023-02-14 10:17:57',NULL),(675,8437,40880,139308,3,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',4000.53,NULL,NULL,1,'2023-02-14 10:17:57','2023-02-14 10:24:01','2023-02-14 10:24:01'),(676,8437,40880,139308,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',395.00,NULL,NULL,1,'2023-02-14 10:17:57','2023-02-14 10:17:57',NULL),(677,8437,40880,139308,3,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17710.00,NULL,NULL,1,'2023-02-14 10:17:57','2023-02-14 10:24:47','2023-02-14 10:24:47'),(678,8437,40880,139308,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',939250.00,NULL,NULL,1,'2023-02-14 10:18:38','2023-02-14 10:18:38',NULL),(679,8437,40880,139308,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',884000.00,NULL,NULL,1,'2023-02-14 10:18:38','2023-02-14 10:18:38',NULL),(680,8437,40880,139308,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',57717.00,NULL,NULL,1,'2023-02-14 10:18:38','2023-02-14 10:18:38',NULL),(681,8437,40880,139308,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',29900.00,NULL,NULL,1,'2023-02-14 10:18:38','2023-02-14 10:18:38',NULL),(682,8437,40880,139308,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',15850.38,NULL,NULL,1,'2023-02-14 10:22:05','2023-02-14 10:22:05',NULL),(683,8437,40880,139308,3,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',4000.53,NULL,NULL,1,'2023-02-14 10:24:01','2023-02-14 10:24:01',NULL),(684,8437,40880,139308,3,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17710.00,NULL,NULL,1,'2023-02-14 10:24:47','2023-02-14 10:24:47',NULL),(685,8437,40880,139308,3,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',13910.28,NULL,NULL,1,'2023-02-14 10:31:25','2023-02-14 10:31:25',NULL),(686,8437,40880,139308,3,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',10000.73,NULL,NULL,1,'2023-02-14 10:41:33','2023-02-14 10:41:33',NULL),(687,8437,40880,139308,3,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',23243.38,NULL,NULL,1,'2023-02-14 11:15:43','2023-02-14 11:15:43',NULL);
INSERT INTO `balance_libro` VALUES (688,8437,40880,139308,3,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',23243.38,NULL,NULL,1,'2023-02-14 11:17:17','2023-02-14 11:18:19','2023-02-14 11:18:19'),(689,8437,40880,139308,3,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',5611.56,NULL,NULL,1,'2023-02-14 11:18:19','2023-02-14 11:18:19',NULL),(690,8437,40880,139308,3,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',12000.01,NULL,NULL,1,'2023-02-14 11:22:57','2023-02-14 11:22:57',NULL),(691,8437,40880,139308,3,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',56822.49,NULL,NULL,1,'2023-02-14 11:24:59','2023-02-14 11:24:59',NULL),(692,8437,40880,139308,3,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',45133.28,NULL,NULL,1,'2023-02-14 11:26:22','2023-02-14 11:26:22',NULL),(693,8437,40880,139308,3,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',47829.79,NULL,NULL,1,'2023-02-14 11:27:52','2023-02-14 11:27:52',NULL),(694,8437,40880,139308,3,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',8000.00,NULL,NULL,1,'2023-02-14 11:30:20','2023-02-14 11:30:20',NULL),(695,8437,40880,139308,3,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',17300.00,NULL,NULL,1,'2023-02-14 11:32:37','2023-02-14 11:32:37',NULL),(696,8437,40880,139308,3,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',5670.00,NULL,NULL,1,'2023-02-14 11:34:25','2023-02-14 11:34:25',NULL),(697,8437,40880,139308,3,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',4999.90,NULL,NULL,1,'2023-02-14 11:37:54','2023-02-14 11:37:54',NULL),(698,8437,40880,139308,3,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',16530.24,NULL,NULL,1,'2023-02-14 11:40:24','2023-02-14 11:40:24',NULL),(699,8437,40880,139308,3,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',9998.35,NULL,NULL,1,'2023-02-14 13:47:57','2023-02-14 13:47:57',NULL),(700,8437,40880,139308,3,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',6000.00,NULL,NULL,1,'2023-02-14 13:49:57','2023-02-14 13:49:57',NULL),(701,8437,40880,139308,3,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',6000.60,NULL,NULL,1,'2023-02-14 13:52:54','2023-02-14 13:52:54',NULL),(702,8437,40880,139308,3,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',19581.79,NULL,NULL,1,'2023-02-14 13:55:35','2023-02-14 13:55:35',NULL),(703,8444,40874,130218,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',77229.87,NULL,NULL,1,'2023-02-14 13:56:29','2023-02-15 09:38:15','2023-02-15 09:38:15'),(704,8444,40874,130218,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',219480.15,NULL,NULL,1,'2023-02-14 13:58:46','2023-02-16 09:36:48','2023-02-16 09:36:48'),(705,8437,40880,139308,3,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',400.00,NULL,NULL,1,'2023-02-14 14:18:00','2023-02-14 14:18:00',NULL),(706,8437,40880,139308,3,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',17160.00,NULL,NULL,1,'2023-02-14 14:20:23','2023-02-14 14:20:23',NULL),(707,8437,40880,139308,3,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',400.00,NULL,NULL,1,'2023-02-14 14:21:44','2023-02-14 14:21:44',NULL),(708,8437,40880,139308,3,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',19220.00,NULL,NULL,1,'2023-02-14 14:23:26','2023-02-14 14:23:26',NULL);
INSERT INTO `balance_libro` VALUES (709,8437,40880,139308,3,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',45059.14,NULL,NULL,1,'2023-02-14 14:25:36','2023-02-14 14:25:36',NULL),(710,8437,40880,139308,3,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',10000.01,NULL,NULL,1,'2023-02-14 14:27:16','2023-02-14 14:27:16',NULL),(711,8437,40880,139308,3,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',54998.75,NULL,NULL,1,'2023-02-14 14:28:47','2023-02-14 14:50:19','2023-02-14 14:50:19'),(712,8437,40880,139308,3,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',12100.50,NULL,NULL,1,'2023-02-14 14:38:02','2023-02-14 14:38:02',NULL),(713,8437,40880,139308,3,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',70087.60,NULL,NULL,1,'2023-02-14 14:39:46','2023-02-14 14:39:46',NULL),(714,8437,40880,139308,3,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',36436.36,NULL,NULL,1,'2023-02-14 14:41:39','2023-02-14 14:41:39',NULL),(715,8437,40880,139308,3,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',12038.95,NULL,NULL,1,'2023-02-14 14:43:04','2023-02-14 14:43:04',NULL),(716,8437,40880,139308,3,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',69633.49,NULL,NULL,1,'2023-02-14 14:44:42','2023-02-14 14:44:42',NULL),(717,8437,40880,139308,3,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',4800.19,NULL,NULL,1,'2023-02-14 14:46:15','2023-02-14 14:46:15',NULL),(718,8437,40880,139308,3,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',5000.00,NULL,NULL,1,'2023-02-14 14:47:31','2023-02-14 14:47:31',NULL),(719,8437,40880,139308,3,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',5000.00,NULL,NULL,1,'2023-02-14 14:48:38','2023-02-14 14:48:38',NULL),(720,8437,40880,139308,3,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',54998.75,NULL,NULL,1,'2023-02-14 14:50:19','2023-02-14 14:50:19',NULL),(721,8433,40798,55986,3,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',44730.00,NULL,NULL,1,'2023-02-14 17:08:34','2023-02-22 14:50:43','2023-02-22 14:50:43'),(722,8433,40798,55986,3,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8412.00,NULL,NULL,1,'2023-02-14 17:08:34','2023-02-28 12:04:01','2023-02-28 12:04:01'),(723,8433,40798,55986,3,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',14.70,NULL,NULL,1,'2023-02-14 17:08:34','2023-02-28 12:05:37','2023-02-28 12:05:37'),(724,8433,40798,55986,3,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',942172.00,NULL,NULL,1,'2023-02-14 17:08:34','2023-02-28 12:06:37','2023-02-28 12:06:37'),(725,8433,40798,55986,3,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',342500.01,NULL,NULL,1,'2023-02-14 17:08:34','2023-02-28 12:07:28','2023-02-28 12:07:28'),(726,8433,40798,55986,3,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',897366.02,NULL,NULL,1,'2023-02-14 17:08:34','2023-04-13 11:46:21','2023-04-13 11:46:21'),(727,8433,40798,55986,3,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',23800.85,NULL,NULL,1,'2023-02-14 17:08:34','2023-02-28 12:08:27','2023-02-28 12:08:27'),(728,8433,40798,55986,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',342500.01,NULL,NULL,1,'2023-02-14 17:08:34','2023-02-28 12:09:19','2023-02-28 12:09:19');
INSERT INTO `balance_libro` VALUES (729,8433,40798,55986,3,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',342500.01,NULL,NULL,1,'2023-02-14 17:08:35','2023-02-28 12:10:05','2023-02-28 12:10:05'),(730,8433,40798,55986,3,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',46479.16,NULL,NULL,1,'2023-02-14 17:08:35','2023-04-12 09:48:44','2023-04-12 09:48:44'),(731,8433,40798,55986,3,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',46479.16,NULL,NULL,1,'2023-02-14 17:08:35','2023-04-12 09:49:09','2023-04-12 09:49:09'),(732,8433,40798,55986,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',631454.84,NULL,NULL,1,'2023-02-14 17:15:12','2023-02-14 17:15:12',NULL),(733,8433,40724,7530,3,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',122388.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-02-16 11:48:08','2023-02-16 11:48:08'),(734,8433,40724,7530,3,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3050.01,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-12 11:46:52','2023-04-12 11:46:52'),(735,8433,40724,7530,3,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3050.01,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-12 11:46:26','2023-04-12 11:46:26'),(736,8433,40724,7530,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',83335.17,NULL,NULL,1,'2023-02-14 17:17:37','2023-02-16 11:48:48','2023-02-16 11:48:48'),(737,8433,40724,7530,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',51112.18,NULL,NULL,1,'2023-02-14 17:17:37','2023-02-16 11:49:27','2023-02-16 11:49:27'),(738,8433,40724,7530,3,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',14450.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-13 12:54:22','2023-04-13 12:54:22'),(739,8433,40724,7530,3,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',16359.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-12 12:55:10','2023-04-12 12:55:10'),(740,8433,40724,7530,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',43082.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-02-16 11:49:55','2023-02-16 11:49:55'),(741,8433,40724,7530,3,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',20812.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-12 13:02:51','2023-04-12 13:02:51'),(742,8433,40724,7530,3,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4050.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-02-16 11:50:30','2023-02-16 11:50:30'),(743,8433,40724,7530,3,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',3520.01,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-12 13:13:14','2023-04-12 13:13:14'),(744,8433,40724,7530,3,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8691.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-02-16 11:54:38','2023-02-16 11:54:38'),(745,8433,40724,7530,3,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',145224.20,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-12 13:19:52','2023-04-12 13:19:52'),(746,8433,40724,7530,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',11000.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-02-16 11:55:34','2023-02-16 11:55:34'),(747,8433,40724,7530,3,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',37990.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-12 13:25:53','2023-04-12 13:25:53');
INSERT INTO `balance_libro` VALUES (748,8433,40724,7530,3,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',20994.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-13 09:53:01','2023-04-13 09:53:01'),(749,8433,40724,7530,3,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',37990.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-12 13:26:14','2023-04-12 13:26:14'),(750,8433,40724,7530,3,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',13480.80,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-13 10:13:43','2023-04-13 10:13:43'),(751,8433,40724,7530,3,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',190.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-13 10:46:37','2023-04-13 10:46:37'),(752,8433,40724,7530,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',11000.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-02-16 11:56:04','2023-02-16 11:56:04'),(753,8433,40724,7530,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',5169.12,NULL,NULL,1,'2023-02-14 17:17:37','2023-02-16 12:00:17','2023-02-16 12:00:17'),(754,8433,40724,7530,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',9844.96,NULL,NULL,1,'2023-02-14 17:17:37','2023-02-16 12:02:36','2023-02-16 12:02:36'),(755,8433,40724,7530,3,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',11300.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-13 12:48:13','2023-04-13 12:48:13'),(756,8433,40724,7530,3,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',11300.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-04-13 12:52:11','2023-04-13 12:52:11'),(757,8433,40724,7530,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',138662.27,NULL,NULL,1,'2023-02-14 17:17:37','2023-02-16 12:03:14','2023-02-16 12:03:14'),(758,8433,40724,7530,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',76200.00,NULL,NULL,1,'2023-02-14 17:17:37','2023-02-16 12:03:47','2023-02-16 12:03:47'),(759,8433,40724,7530,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',124006.16,NULL,NULL,1,'2023-02-14 17:17:38','2023-02-16 12:04:23','2023-02-16 12:04:23'),(760,8433,40724,7530,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6000.00,NULL,NULL,1,'2023-02-14 17:17:38','2023-02-16 12:04:52','2023-02-16 12:04:52'),(761,8433,40724,7530,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',150869.49,NULL,NULL,1,'2023-02-14 17:17:38','2023-02-16 12:05:32','2023-02-16 12:05:32'),(762,8433,40724,7530,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',120000.00,NULL,NULL,1,'2023-02-14 17:17:38','2023-02-16 12:05:54','2023-02-16 12:05:54'),(763,8433,40724,7530,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',120000.00,NULL,NULL,1,'2023-02-14 17:17:38','2023-02-16 12:06:24','2023-02-16 12:06:24'),(764,8433,40724,7530,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',150004.01,NULL,NULL,1,'2023-02-14 17:17:38','2023-02-16 12:06:59','2023-02-16 12:06:59'),(765,8433,40724,7530,3,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',12000.01,NULL,NULL,1,'2023-02-14 17:17:38','2023-04-13 11:54:24','2023-04-13 11:54:24'),(766,8433,40724,7530,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',144932.00,NULL,NULL,1,'2023-02-14 17:17:38','2023-02-16 12:07:30','2023-02-16 12:07:30');
INSERT INTO `balance_libro` VALUES (767,8433,40870,127191,3,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',11470.00,NULL,NULL,1,'2023-02-14 17:40:43','2023-02-16 11:18:47','2023-02-16 11:18:47'),(768,8433,40870,127191,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7582.30,NULL,NULL,1,'2023-02-14 17:40:43','2023-02-16 11:20:50','2023-02-16 11:20:50'),(769,8433,40870,127191,3,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3700.00,NULL,NULL,1,'2023-02-14 17:40:43','2023-05-10 10:21:56','2023-05-10 10:21:56'),(770,8433,40870,127191,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',7362.87,NULL,NULL,1,'2023-02-14 17:40:43','2023-02-16 11:22:30','2023-02-16 11:22:30'),(771,8433,40870,127191,3,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',275000.00,NULL,NULL,1,'2023-02-14 17:40:43','2023-02-16 11:24:01','2023-02-16 11:24:01'),(772,8433,40870,127191,3,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',275000.00,NULL,NULL,1,'2023-02-14 17:40:43','2023-02-16 11:23:39','2023-02-16 11:23:39'),(773,8433,40795,49926,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2233.86,NULL,NULL,1,'2023-02-14 17:48:31','2023-02-16 11:29:01','2023-02-16 11:29:01'),(774,8433,40795,49926,3,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',39591.20,NULL,NULL,1,'2023-02-14 17:48:31','2023-03-31 10:41:13','2023-03-31 10:41:13'),(775,8433,40795,49926,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',30712.50,NULL,NULL,1,'2023-02-14 17:48:31','2023-02-16 11:28:27','2023-02-16 11:28:27'),(776,8433,40795,49926,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',130025.00,NULL,NULL,1,'2023-02-14 17:48:31','2023-02-16 11:27:52','2023-02-16 11:27:52'),(777,8433,40795,49926,3,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3682.79,NULL,NULL,1,'2023-02-14 17:48:31','2023-02-14 17:48:31',NULL),(778,8433,40795,49926,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',14000.00,NULL,NULL,1,'2023-02-14 17:48:31','2023-02-16 11:25:35','2023-02-16 11:25:35'),(779,8433,40795,49926,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1882.29,NULL,NULL,1,'2023-02-14 17:48:31','2023-03-31 10:40:34','2023-03-31 10:40:34'),(780,8433,40795,49926,3,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',25000.00,NULL,NULL,1,'2023-02-14 17:48:31','2023-02-14 17:48:31',NULL),(781,8433,40795,49926,3,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',12480.00,NULL,NULL,1,'2023-02-14 17:48:31','2023-03-31 10:39:46','2023-03-31 10:39:46'),(782,8433,40783,31749,3,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',22310.00,NULL,NULL,1,'2023-02-14 17:56:03','2023-04-11 11:38:51','2023-04-11 11:38:51'),(783,8433,40783,31749,3,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',21450.00,NULL,NULL,1,'2023-02-14 17:56:03','2023-02-16 11:35:50','2023-02-16 11:35:50'),(784,8433,40783,31749,3,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',12562.73,NULL,NULL,1,'2023-02-14 17:56:03','2023-02-16 11:36:33','2023-02-16 11:36:33'),(785,8433,40783,31749,3,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',102852.00,NULL,NULL,1,'2023-02-14 17:56:03','2023-04-11 11:34:11','2023-04-11 11:34:11');
INSERT INTO `balance_libro` VALUES (786,8433,40783,31749,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',18375.57,NULL,NULL,1,'2023-02-14 17:56:03','2023-02-16 11:38:55','2023-02-16 11:38:55'),(787,8433,40783,31749,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',46263.16,NULL,NULL,1,'2023-02-14 17:56:03','2023-02-16 11:40:55','2023-02-16 11:40:55'),(788,8433,40783,31749,2,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',64350.00,NULL,NULL,1,'2023-02-14 17:57:35','2023-02-14 17:57:35',NULL),(789,8437,40873,128703,3,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',30000.00,NULL,NULL,1,'2023-02-15 09:27:10','2023-02-15 09:27:10',NULL),(790,8437,40873,128703,3,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',367.00,NULL,NULL,1,'2023-02-15 09:27:10','2023-02-15 09:27:10',NULL),(791,8437,40873,128703,3,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5700.00,NULL,NULL,1,'2023-02-15 09:27:10','2023-02-15 09:27:10',NULL),(792,8437,40873,128703,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',235577.89,NULL,NULL,1,'2023-02-15 09:27:10','2023-02-15 09:54:53','2023-02-15 09:54:53'),(793,8437,40873,128703,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2405.54,NULL,NULL,1,'2023-02-15 09:27:10','2023-02-15 10:28:35','2023-02-15 10:28:35'),(794,8437,40873,128703,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',33169.25,NULL,NULL,1,'2023-02-15 09:27:10','2023-02-15 10:23:22','2023-02-15 10:23:22'),(795,8437,40873,128703,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',8433.99,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 10:30:28','2023-02-15 10:30:28'),(796,8437,40873,128703,3,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',7849.94,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(797,8437,40873,128703,3,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',11999.00,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(798,8437,40873,128703,3,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',559998.00,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(799,8437,40873,128703,3,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3865.57,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(800,8437,40873,128703,3,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',100300.00,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(801,8437,40873,128703,3,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',100300.00,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(802,8437,40873,128703,3,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',100300.00,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(803,8437,40873,128703,3,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',100300.00,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(804,8437,40873,128703,3,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',100300.00,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(805,8437,40873,128703,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',44884.85,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 10:12:05','2023-02-15 10:12:05');
INSERT INTO `balance_libro` VALUES (806,8437,40873,128703,3,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',200.00,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(807,8437,40873,128703,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',173563.90,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:31:30','2023-02-15 09:31:30'),(808,8437,40873,128703,3,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',7488.43,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(809,8437,40873,128703,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5429.18,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 10:25:25','2023-02-15 10:25:25'),(810,8437,40873,128703,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',27344.04,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 10:20:20','2023-02-15 10:20:20'),(811,8437,40873,128703,3,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2542.10,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(812,8437,40873,128703,3,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',45000.00,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(813,8437,40873,128703,3,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',57300.00,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(814,8437,40873,128703,3,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',9282.68,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 09:27:11',NULL),(815,8437,40873,128703,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4171.59,NULL,NULL,1,'2023-02-15 09:27:11','2023-02-15 10:26:36','2023-02-15 10:26:36'),(816,8437,40873,128703,3,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',173563.90,NULL,NULL,1,'2023-02-15 09:31:30','2023-02-15 09:31:30',NULL),(817,8444,40874,130218,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',77229.87,NULL,NULL,1,'2023-02-15 09:38:15','2023-02-16 09:36:53','2023-02-16 09:36:53'),(818,8433,40869,125676,3,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',12350.00,NULL,NULL,1,'2023-02-15 09:41:16','2023-02-15 09:45:17','2023-02-15 09:45:17'),(819,8433,40869,125676,3,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',12350.00,NULL,NULL,1,'2023-02-15 09:45:17','2023-04-11 09:22:18','2023-04-11 09:22:18'),(820,8437,40873,128703,3,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',224573.02,NULL,NULL,1,'2023-02-15 09:54:53','2023-02-15 09:54:53',NULL),(821,8437,40873,128703,3,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',57671.61,NULL,NULL,1,'2023-02-15 10:05:17','2023-02-15 10:05:17',NULL),(822,8437,40873,128703,3,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',44884.86,NULL,NULL,1,'2023-02-15 10:12:05','2023-02-15 10:12:05',NULL),(823,8437,40873,128703,3,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',27344.05,NULL,NULL,1,'2023-02-15 10:20:20','2023-02-15 10:20:20',NULL),(824,8437,40873,128703,3,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',33169.25,NULL,NULL,1,'2023-02-15 10:23:22','2023-02-15 10:23:22',NULL),(825,8437,40873,128703,3,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5429.18,NULL,NULL,1,'2023-02-15 10:25:25','2023-02-15 10:25:25',NULL);
INSERT INTO `balance_libro` VALUES (1065,8437,40873,128703,3,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4171.59,NULL,NULL,1,'2023-02-15 10:26:36','2023-02-15 10:26:36',NULL),(1129,8437,40873,128703,3,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2405.54,NULL,NULL,1,'2023-02-15 10:28:35','2023-02-15 10:28:35',NULL),(1130,8437,40873,128703,3,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',8433.99,NULL,NULL,1,'2023-02-15 10:30:28','2023-02-15 10:30:28',NULL),(1131,8437,40873,128703,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',9595.27,NULL,NULL,1,'2023-02-15 10:33:14','2023-02-15 10:33:14',NULL),(1132,8437,40873,128703,3,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4182.46,NULL,NULL,1,'2023-02-15 10:34:38','2023-02-15 10:34:38',NULL),(1133,8437,41082,434733,3,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',9800.00,NULL,NULL,1,'2023-02-15 10:40:36','2023-02-15 10:40:36',NULL),(1134,8437,41082,434733,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2999.99,NULL,NULL,1,'2023-02-15 10:40:36','2023-02-15 10:40:36',NULL),(1135,8437,41082,434733,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',40000.00,NULL,NULL,1,'2023-02-15 10:40:36','2023-02-15 10:40:36',NULL),(1136,8437,41082,434733,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',19219.00,NULL,NULL,1,'2023-02-15 10:40:36','2023-02-15 10:40:36',NULL),(1137,8437,41082,434733,3,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',226303.17,NULL,NULL,1,'2023-02-15 10:40:36','2023-02-15 10:40:36',NULL),(1138,8437,41082,434733,3,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',21600.00,NULL,NULL,1,'2023-02-15 10:40:36','2023-02-15 10:40:36',NULL),(1139,8437,41082,434733,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',198782.87,NULL,NULL,1,'2023-02-15 10:40:36','2023-02-15 10:40:36',NULL),(1140,8437,41082,434733,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',74824.89,NULL,NULL,1,'2023-02-15 10:40:36','2023-02-15 10:40:36',NULL),(1141,8437,41082,434733,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',188760.00,NULL,NULL,1,'2023-02-15 10:40:36','2023-02-15 10:40:36',NULL),(1142,8437,41082,434733,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',106277.33,NULL,NULL,1,'2023-02-15 10:40:36','2023-02-15 10:40:36',NULL),(1143,8437,41082,434733,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',401600.70,NULL,NULL,1,'2023-02-15 10:40:36','2023-02-15 10:53:42','2023-02-15 10:53:42'),(1144,8437,41082,434733,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1072.71,NULL,NULL,1,'2023-02-15 10:40:36','2023-02-15 10:40:36',NULL),(1145,8437,41082,434733,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',553632.50,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1146,8437,41082,434733,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',16592.00,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1147,8437,41082,434733,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',165750.00,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1148,8437,41082,434733,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',290.12,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL);
INSERT INTO `balance_libro` VALUES (1149,8437,41082,434733,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',105.00,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1150,8437,41082,434733,3,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1411.57,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1151,8437,41082,434733,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',113740.00,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1152,8437,41082,434733,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',28600.00,NULL,NULL,1,'2023-02-15 10:40:37','2023-03-30 10:44:30','2023-03-30 10:44:30'),(1153,8437,41082,434733,3,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',268515.00,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1154,8437,41082,434733,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',181500.00,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1155,8437,41082,434733,3,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8236.25,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1156,8437,41082,434733,3,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',45792.42,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1157,8437,41082,434733,3,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',224588.10,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1158,8437,41082,434733,3,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',7500.00,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1159,8437,41082,434733,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',23210.00,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1160,8437,41082,434733,3,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',11501.51,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1161,8437,41082,434733,3,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',320000.00,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1162,8437,41082,434733,3,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7100.00,NULL,NULL,1,'2023-02-15 10:40:37','2023-02-15 10:40:37',NULL),(1163,8437,41082,434733,3,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',17601.03,NULL,NULL,1,'2023-02-15 10:44:34','2023-02-15 10:44:34',NULL),(1164,8437,41082,434733,3,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',18000.21,NULL,NULL,1,'2023-02-15 10:47:14','2023-02-15 10:47:14',NULL),(1165,8433,41420,752877,2,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',45000.00,NULL,NULL,1,'2023-02-15 10:47:54','2023-02-15 10:47:54',NULL),(1166,8437,41082,434733,3,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',41308.32,NULL,NULL,1,'2023-02-15 10:49:49','2023-02-15 10:49:49',NULL),(1167,8437,41082,434733,3,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5700.76,NULL,NULL,1,'2023-02-15 10:50:56','2023-02-15 10:50:56',NULL),(1168,8437,41082,434733,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',401600.70,NULL,NULL,1,'2023-02-15 10:53:42','2023-02-15 10:53:42',NULL);
INSERT INTO `balance_libro` VALUES (1169,8437,41082,434733,3,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',8927.07,NULL,NULL,1,'2023-02-15 11:07:05','2023-02-15 11:07:05',NULL),(1170,8437,41082,434733,3,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',19080.34,NULL,NULL,1,'2023-02-15 11:09:28','2023-02-15 11:09:28',NULL),(1171,8437,41082,434733,3,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',21843.94,NULL,NULL,1,'2023-02-15 11:14:09','2023-02-15 11:14:09',NULL),(1172,8437,41082,434733,3,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',6213.48,NULL,NULL,1,'2023-02-15 11:18:06','2023-02-15 11:18:06',NULL),(1173,8437,41082,434733,3,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',14020.48,NULL,NULL,1,'2023-02-15 11:20:43','2023-02-15 11:20:43',NULL),(1174,8437,41082,434733,3,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',17154.06,NULL,NULL,1,'2023-02-15 11:22:38','2023-02-15 11:22:38',NULL),(1175,8437,41082,434733,3,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2030.30,NULL,NULL,1,'2023-02-15 11:27:04','2023-02-15 11:27:04',NULL),(1176,8437,41082,434733,3,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',600.16,NULL,NULL,1,'2023-02-15 11:29:03','2023-02-15 11:29:03',NULL),(1177,8437,40786,36294,3,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',61198.30,NULL,NULL,1,'2023-02-15 11:36:08','2023-02-15 11:36:08',NULL),(1178,8437,40786,36294,3,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',67430.00,NULL,NULL,1,'2023-02-15 11:36:08','2023-02-15 11:41:06','2023-02-15 11:41:06'),(1179,8437,40786,36294,3,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',11340.00,NULL,NULL,1,'2023-02-15 11:36:08','2023-02-15 11:36:08',NULL),(1180,8437,40786,36294,3,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8631.00,NULL,NULL,1,'2023-02-15 11:36:08','2023-02-15 11:36:08',NULL),(1181,8437,40786,36294,3,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8500.00,NULL,NULL,1,'2023-02-15 11:36:08','2023-02-15 11:36:08',NULL),(1182,8437,40786,36294,3,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',65999.00,NULL,NULL,1,'2023-02-15 11:36:08','2023-02-15 11:36:08',NULL),(1183,8437,40786,36294,3,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1765.97,NULL,NULL,1,'2023-02-15 11:36:08','2023-02-15 11:36:08',NULL),(1184,8437,40786,36294,3,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2511.00,NULL,NULL,1,'2023-02-15 11:36:08','2023-02-15 11:36:08',NULL),(1185,8437,40786,36294,3,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2511.00,NULL,NULL,1,'2023-02-15 11:36:08','2023-02-15 11:36:08',NULL),(1186,8437,40786,36294,3,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',123373.00,NULL,NULL,1,'2023-02-15 11:36:08','2023-02-15 11:36:08',NULL),(1187,8437,40786,36294,3,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7108.65,NULL,NULL,1,'2023-02-15 11:36:08','2023-02-15 11:36:08',NULL),(1188,8433,40724,7530,2,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',101277.00,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL);
INSERT INTO `balance_libro` VALUES (1189,8433,40724,7530,2,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',195052.00,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1190,8433,40724,7530,2,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',102245.00,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1191,8433,40724,7530,2,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',33486.75,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1192,8433,40724,7530,2,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',96800.00,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1193,8433,40724,7530,2,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',22880.00,NULL,NULL,1,'2023-02-15 11:36:20','2023-04-15 21:13:59','2023-04-15 21:13:59'),(1194,8433,40724,7530,2,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',57632.30,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1195,8433,40724,7530,2,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',160954.20,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1196,8433,40724,7530,2,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',60258.00,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1197,8433,40724,7530,2,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',105754.00,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1198,8433,40724,7530,2,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',34727.00,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1199,8433,40724,7530,2,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',102136.10,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1200,8433,40724,7530,2,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',208180.50,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1201,8433,40724,7530,2,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',90205.50,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1202,8433,40724,7530,2,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',166496.00,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1203,8433,40724,7530,2,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',233094.40,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1204,8433,40724,7530,2,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',51328.20,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1205,8433,40724,7530,2,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',127050.00,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1206,8433,40724,7530,2,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',78976.70,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1207,8433,40724,7530,2,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',62434.20,NULL,NULL,1,'2023-02-15 11:36:20','2023-04-15 21:13:11','2023-04-15 21:13:11'),(1208,8433,40724,7530,2,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',20150.00,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL);
INSERT INTO `balance_libro` VALUES (1209,8433,40724,7530,2,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',20150.00,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1210,8433,40724,7530,2,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',106177.50,NULL,NULL,1,'2023-02-15 11:36:20','2023-02-15 11:36:20',NULL),(1211,8437,40786,36294,2,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',90750.00,NULL,NULL,1,'2023-02-15 11:36:23','2023-02-15 11:36:23',NULL),(1212,8437,40786,36294,3,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',67430.00,NULL,NULL,1,'2023-02-15 11:41:06','2023-02-15 11:41:06',NULL),(1213,8437,41734,755907,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',23943.56,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1214,8437,41734,755907,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',59240.12,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1215,8437,41734,755907,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',29887.00,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1216,8437,41734,755907,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2935.46,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1217,8437,41734,755907,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',32118.00,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1218,8437,41734,755907,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',9487.44,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1219,8437,41734,755907,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',30075.44,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1220,8437,41734,755907,3,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',68780.09,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1221,8437,41734,755907,3,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8891.15,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1222,8437,41734,755907,3,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6000.51,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1223,8437,41734,755907,3,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',98662.72,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1224,8437,41734,755907,3,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',51474.44,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1225,8437,41734,755907,3,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',76230.00,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1226,8437,41734,755907,3,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',60932.36,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1227,8437,41734,755907,3,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',18500.01,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1228,8437,41734,755907,3,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',30166.44,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL);
INSERT INTO `balance_libro` VALUES (1229,8437,41734,755907,3,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',167075.95,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1230,8437,41734,755907,3,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',30166.44,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1231,8437,41734,755907,3,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',52199.40,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1232,8437,41734,755907,3,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',10890.00,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1233,8437,41734,755907,3,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',33492.80,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1234,8437,41734,755907,3,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',52300.00,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1235,8437,41734,755907,3,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',30166.44,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1236,8437,41734,755907,3,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',22748.00,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1237,8437,41734,755907,3,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',22264.00,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1238,8437,41734,755907,3,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',22748.00,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1239,8437,41734,755907,3,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',15000.00,NULL,NULL,1,'2023-02-15 11:56:50','2023-02-15 11:56:50',NULL),(1240,8437,41734,755907,3,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',117819.90,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1241,8437,41734,755907,3,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',62013.03,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1242,8437,41734,755907,3,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',28072.00,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1243,8437,41734,755907,3,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',21220.46,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1244,8437,41734,755907,3,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',33850.00,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1245,8437,41734,755907,3,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',32584.14,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1246,8437,41734,755907,3,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',73108.20,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1247,8437,41734,755907,3,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',21220.46,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1248,8437,41734,755907,3,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',13200.00,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL);
INSERT INTO `balance_libro` VALUES (1249,8437,41734,755907,3,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',21220.46,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1250,8437,41734,755907,3,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',63760.00,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1251,8437,41734,755907,3,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',17820.00,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1252,8437,41734,755907,3,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',17420.00,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1253,8437,41734,755907,3,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',67711.60,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1254,8437,41734,755907,3,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',38516.97,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1255,8437,41734,755907,3,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',50989.40,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1256,8437,41734,755907,3,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',17940.22,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1257,8437,41734,755907,3,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',152995.97,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1258,8437,41734,755907,3,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',18911.99,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1259,8437,41734,755907,3,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',65646.87,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1260,8437,41734,755907,3,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',7505.94,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1261,8437,41734,755907,3,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',31028.80,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1262,8437,41734,755907,3,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',43388.33,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1263,8437,41734,755907,3,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',5399.98,NULL,NULL,1,'2023-02-15 11:56:51','2023-02-15 11:56:51',NULL),(1264,8437,41734,755907,3,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',30746.10,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1265,8437,41734,755907,3,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2745.44,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1266,8437,41734,755907,3,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4569.65,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1267,8437,41734,755907,3,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8260.11,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1268,8437,41734,755907,3,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',65646.87,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL);
INSERT INTO `balance_libro` VALUES (1269,8437,41734,755907,3,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',31992.40,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1270,8437,41734,755907,3,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',105000.00,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1271,8437,41734,755907,3,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',20233.00,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1272,8437,41734,755907,3,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',65646.87,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1273,8437,41734,755907,3,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',32936.20,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1274,8437,41734,755907,3,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',65323.37,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1275,8437,41734,755907,3,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',131456.80,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1276,8437,41734,755907,3,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',79690.60,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1277,8437,41734,755907,3,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',101087.69,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1278,8437,41734,755907,3,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',140741.01,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1279,8437,41734,755907,3,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',86333.56,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1280,8437,41734,755907,3,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',86333.56,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1281,8437,41734,755907,3,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',111232.74,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1282,8437,41734,755907,3,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',140741.01,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1283,8437,41734,755907,3,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',101087.69,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1284,8437,41734,755907,3,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',46569.80,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1285,8437,41734,755907,3,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2662.00,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1286,8437,41734,755907,3,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',26899.99,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1287,8437,41734,755907,3,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',50388.45,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL),(1288,8437,41734,755907,3,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',99328.90,NULL,NULL,1,'2023-02-15 11:56:52','2023-02-15 11:56:52',NULL);
INSERT INTO `balance_libro` VALUES (1289,8437,41734,755907,3,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',13213.07,NULL,NULL,1,'2023-02-15 11:56:53','2023-02-15 11:56:53',NULL),(1290,8437,41734,755907,3,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',9711.58,NULL,NULL,1,'2023-02-15 11:56:53','2023-02-15 11:56:53',NULL),(1291,8437,41734,755907,3,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',28225.07,NULL,NULL,1,'2023-02-15 11:56:53','2023-02-15 11:56:53',NULL),(1292,8437,41734,755907,3,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1139.97,NULL,NULL,1,'2023-02-15 11:56:53','2023-02-15 11:56:53',NULL),(1293,8437,41734,755907,3,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',37300.02,NULL,NULL,1,'2023-02-15 11:56:53','2023-02-15 11:56:53',NULL),(1294,8437,41734,755907,3,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',41546.50,NULL,NULL,1,'2023-02-15 11:56:53','2023-02-15 11:56:53',NULL),(1295,8437,41734,755907,3,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',41546.50,NULL,NULL,1,'2023-02-15 11:56:53','2023-02-15 11:56:53',NULL),(1296,8437,41734,755907,3,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',50388.45,NULL,NULL,1,'2023-02-15 11:56:53','2023-02-15 11:56:53',NULL),(1297,8437,41734,755907,3,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',41546.50,NULL,NULL,1,'2023-02-15 11:56:53','2023-02-15 11:56:53',NULL),(1298,8437,41734,755907,3,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',117890.30,NULL,NULL,1,'2023-02-15 11:56:53','2023-02-15 11:56:53',NULL),(1299,8437,41734,755907,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',125952.01,NULL,NULL,1,'2023-02-15 11:56:53','2023-02-15 11:56:53',NULL),(1300,8437,41734,755907,3,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9090.42,NULL,NULL,1,'2023-02-15 11:56:53','2023-02-15 11:56:53',NULL),(1301,8437,41734,755907,3,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',43789.14,NULL,NULL,1,'2023-02-15 11:56:53','2023-02-15 11:56:53',NULL),(1302,8437,41734,755907,2,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',37900.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL),(1303,8437,41734,755907,2,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',25400.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL),(1304,8437,41734,755907,2,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',11200.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL),(1305,8437,41734,755907,2,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',11600.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL),(1306,8437,41734,755907,2,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',17500.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL),(1307,8437,41734,755907,2,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',24900.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL),(1308,8437,41734,755907,2,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',15100.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL);
INSERT INTO `balance_libro` VALUES (1309,8437,41734,755907,2,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',400.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL),(1310,8437,41734,755907,2,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',19900.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL),(1311,8437,41734,755907,2,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',19100.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL),(1312,8437,41734,755907,2,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',14100.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL),(1313,8437,41734,755907,2,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',13450.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL),(1314,8437,41734,755907,2,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',27000.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL),(1315,8437,41734,755907,2,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10200.00,NULL,NULL,1,'2023-02-15 11:57:49','2023-02-15 11:57:49',NULL),(1316,8437,41734,755907,2,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',450.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1317,8437,41734,755907,2,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2850.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1318,8437,41734,755907,2,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2900.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1319,8437,41734,755907,2,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',13800.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1320,8437,41734,755907,2,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',900.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1321,8437,41734,755907,2,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',13450.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1322,8437,41734,755907,2,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10200.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1323,8437,41734,755907,2,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',900.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1324,8437,41734,755907,2,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',23700.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1325,8437,41734,755907,2,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',24100.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1326,8437,41734,755907,2,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',9500.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1327,8437,41734,755907,2,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',7450.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1328,8437,41734,755907,2,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',4200.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL);
INSERT INTO `balance_libro` VALUES (1329,8437,41734,755907,2,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1200.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1330,8437,41734,755907,2,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',8400.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1331,8437,41734,755907,2,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3800.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1332,8437,41734,755907,2,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',15300.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1333,8437,41734,755907,2,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',15300.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1334,8437,41734,755907,2,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',3100.00,NULL,NULL,1,'2023-02-15 11:57:50','2023-02-15 11:57:50',NULL),(1335,8437,41734,755907,2,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1100.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1336,8437,41734,755907,2,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2400.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1337,8437,41734,755907,2,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',12000.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1338,8437,41734,755907,2,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',15412.50,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1339,8437,41734,755907,2,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',9975.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1340,8437,41734,755907,2,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',15300.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1341,8437,41734,755907,2,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',5000.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1342,8437,41734,755907,2,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',5000.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1343,8437,41734,755907,2,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',450.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1344,8437,41734,755907,2,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',5500.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1345,8437,41734,755907,2,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',5500.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1346,8437,41734,755907,2,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',7200.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1347,8437,41734,755907,2,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',33600.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1348,8437,41734,755907,2,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',5000.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL);
INSERT INTO `balance_libro` VALUES (1349,8437,41734,755907,2,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2250.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1350,8437,41734,755907,2,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',36300.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1351,8437,41734,755907,2,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2500.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1352,8437,41734,755907,2,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',9300.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1353,8437,41734,755907,2,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',16850.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1354,8437,41734,755907,2,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2500.00,NULL,NULL,1,'2023-02-15 11:57:51','2023-02-15 11:57:51',NULL),(1355,8437,41734,755907,2,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1500.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1356,8437,41734,755907,2,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',18900.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1357,8437,41734,755907,2,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',10900.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1358,8437,41734,755907,2,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',19400.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1359,8437,41734,755907,2,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',39500.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1360,8437,41734,755907,2,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',4200.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1361,8437,41734,755907,2,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',22140.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1362,8437,41734,755907,2,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',25900.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1363,8437,41734,755907,2,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',36100.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1364,8437,41734,755907,2,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',29250.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1365,8437,41734,755907,2,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',8900.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1366,8437,41734,755907,2,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',17850.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1367,8437,41734,755907,2,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4000.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1368,8437,41734,755907,2,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',6100.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL);
INSERT INTO `balance_libro` VALUES (1369,8437,41734,755907,2,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1250.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1370,8437,41734,755907,2,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',14700.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1371,8437,41734,755907,2,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',7200.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1372,8437,41734,755907,2,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',19900.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1373,8437,41734,755907,2,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',15000.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1374,8437,41734,755907,2,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4800.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1375,8437,41734,755907,2,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',26200.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1376,8437,41734,755907,2,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10800.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1377,8437,41734,755907,2,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',28000.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1378,8437,41734,755907,2,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',11200.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1379,8437,41734,755907,2,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3600.00,NULL,NULL,1,'2023-02-15 11:57:52','2023-02-15 11:57:52',NULL),(1380,8437,41734,755907,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1400.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1381,8437,41734,755907,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10800.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1382,8437,41734,755907,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',39200.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1383,8437,41734,755907,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',8600.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1384,8437,41734,755907,2,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',36000.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1385,8437,41734,755907,2,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',18000.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1386,8437,41734,755907,2,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3600.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1387,8437,41734,755907,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',7500.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1388,8437,41734,755907,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',42450.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL);
INSERT INTO `balance_libro` VALUES (1389,8437,41734,755907,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3000.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1390,8437,41734,755907,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',32100.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1391,8437,41734,755907,2,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',9800.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1392,8437,41734,755907,2,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',9000.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1393,8437,41734,755907,2,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',3900.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1394,8437,41734,755907,2,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',7900.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1395,8437,41734,755907,2,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',22400.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1396,8437,41734,755907,2,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',3200.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1397,8437,41734,755907,2,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',9800.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1398,8437,41734,755907,2,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',17150.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1399,8437,41734,755907,2,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',22850.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1400,8437,41734,755907,2,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',20850.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1401,8437,41734,755907,2,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',21800.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1402,8437,41734,755907,2,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',34700.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1403,8437,41734,755907,2,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',13250.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1404,8437,41734,755907,2,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',15700.00,NULL,NULL,1,'2023-02-15 11:57:53','2023-02-15 11:57:53',NULL),(1405,8437,41734,755907,2,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',450.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1406,8437,41734,755907,2,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',500.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1407,8437,41734,755907,2,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',15700.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1408,8437,41734,755907,2,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1800.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL);
INSERT INTO `balance_libro` VALUES (1409,8437,41734,755907,2,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',11000.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1410,8437,41734,755907,2,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',15700.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1411,8437,41734,755907,2,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',12800.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1412,8437,41734,755907,2,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',5500.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1413,8437,41734,755907,2,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',20500.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1414,8437,41734,755907,2,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',21850.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1415,8437,41734,755907,2,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',49600.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1416,8437,41734,755907,2,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',14100.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1417,8437,41734,755907,2,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',14800.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1418,8437,41734,755907,2,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',6250.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1419,8437,41734,755907,2,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4700.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1420,8437,41734,755907,2,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',30950.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1421,8437,41734,755907,2,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',12550.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1422,8437,41734,755907,2,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',14700.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1423,8437,41734,755907,2,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',10500.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1424,8437,41734,755907,2,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',21950.00,NULL,NULL,1,'2023-02-15 11:57:54','2023-02-15 11:57:54',NULL),(1425,8437,41734,755907,2,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2400.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1426,8437,41734,755907,2,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',53050.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1427,8437,41734,755907,2,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7200.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1428,8437,41734,755907,2,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1800.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL);
INSERT INTO `balance_libro` VALUES (1429,8437,41734,755907,2,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1800.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1430,8437,41734,755907,2,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1200.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1431,8437,41734,755907,2,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8000.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1432,8437,41734,755907,2,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',16400.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1433,8437,41734,755907,2,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1800.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1434,8437,41734,755907,2,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',11200.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1435,8437,41734,755907,2,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',16900.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1436,8437,41734,755907,2,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',12800.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1437,8437,41734,755907,2,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3000.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1438,8437,41734,755907,2,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',13550.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1439,8437,41734,755907,2,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',49800.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1440,8437,41734,755907,2,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3250.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1441,8437,41734,755907,2,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',23900.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1442,8437,41734,755907,2,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2400.00,NULL,NULL,1,'2023-02-15 11:57:55','2023-02-15 11:57:55',NULL),(1443,8437,41734,755907,2,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',600.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1444,8437,41734,755907,2,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8400.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1445,8437,41734,755907,2,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',600.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1446,8437,41734,755907,2,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',8300.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1447,8437,41734,755907,2,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6400.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1448,8437,41734,755907,2,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1200.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL);
INSERT INTO `balance_libro` VALUES (1449,8437,41734,755907,2,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',13400.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1450,8437,41734,755907,2,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',121000.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1451,8437,41734,755907,2,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',57700.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1452,8437,41734,755907,2,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',15450.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1453,8437,41734,755907,2,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',29000.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1454,8437,41734,755907,2,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',48000.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1455,8437,41734,755907,2,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',600.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1456,8437,41734,755907,2,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',21500.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1457,8437,41734,755907,2,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',14950.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1458,8437,41734,755907,2,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',800.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1459,8437,41734,755907,2,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',10000.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1460,8437,41734,755907,2,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',49100.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1461,8437,41734,755907,2,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4200.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1462,8437,41734,755907,2,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',10500.00,NULL,NULL,1,'2023-02-15 11:57:56','2023-02-15 11:57:56',NULL),(1463,8437,41734,755907,2,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',14350.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1464,8437,41734,755907,2,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',7600.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1465,8437,41734,755907,2,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',14750.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1466,8437,41734,755907,2,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',30300.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1467,8437,41734,755907,2,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',17400.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1468,8437,41734,755907,2,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3000.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL);
INSERT INTO `balance_libro` VALUES (1469,8437,41734,755907,2,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',13400.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1470,8437,41734,755907,2,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',2400.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1471,8437,41734,755907,2,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',2600.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1472,8437,41734,755907,2,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',3000.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1473,8437,41734,755907,2,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',40300.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1474,8437,41734,755907,2,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',21400.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1475,8437,41734,755907,2,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',11200.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1476,8437,41734,755907,2,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',2400.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1477,8437,41734,755907,2,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',14150.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1478,8437,41734,755907,2,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',41750.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1479,8437,41734,755907,2,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',500.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1480,8437,41734,755907,2,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2400.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1481,8437,41734,755907,2,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4200.00,NULL,NULL,1,'2023-02-15 11:57:57','2023-02-15 11:57:57',NULL),(1482,8437,41734,755907,2,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1500.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1483,8437,41734,755907,2,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',460.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1484,8437,41734,755907,2,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',22000.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1485,8437,41734,755907,2,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',21100.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1486,8437,41734,755907,2,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',22550.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1487,8437,41734,755907,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',14130.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1488,8437,41734,755907,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',27600.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL);
INSERT INTO `balance_libro` VALUES (1489,8437,41734,755907,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1800.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1490,8437,41734,755907,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',15250.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1491,8437,41734,755907,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',12300.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1492,8437,41734,755907,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10300.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1493,8437,41734,755907,2,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',14950.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1494,8437,41734,755907,2,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1200.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1495,8437,41734,755907,2,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1800.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1496,8437,41734,755907,2,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',9500.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1497,8437,41734,755907,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2200.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1498,8437,41734,755907,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3400.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1499,8437,41734,755907,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1800.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1500,8437,41734,755907,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1440.00,NULL,NULL,1,'2023-02-15 11:57:58','2023-02-15 11:57:58',NULL),(1501,8437,41734,755907,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',38000.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1502,8437,41734,755907,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',60000.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1503,8437,41734,755907,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',45000.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1504,8437,41734,755907,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',49000.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1505,8437,41734,755907,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',20450.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1506,8437,41734,755907,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8400.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1507,8437,41734,755907,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',14000.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1508,8437,41734,755907,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',21690.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL);
INSERT INTO `balance_libro` VALUES (1509,8437,41734,755907,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',36360.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1510,8437,41734,755907,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',44730.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1511,8437,41734,755907,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',18540.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1512,8437,41734,755907,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',14400.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1513,8437,41734,755907,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1514,8437,41734,755907,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',12600.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1515,8437,41734,755907,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',11000.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1516,8437,41734,755907,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',16500.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1517,8437,41734,755907,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',16700.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1518,8437,41734,755907,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3100.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1519,8437,41734,755907,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',29880.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1520,8437,41734,755907,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3400.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1521,8437,41734,755907,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',9825.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1522,8437,41734,755907,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',3600.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1523,8437,41734,755907,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',31150.00,NULL,NULL,1,'2023-02-15 11:57:59','2023-02-15 11:57:59',NULL),(1524,8437,41734,755907,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',31050.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1525,8437,41734,755907,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',22300.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1526,8437,41734,755907,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',19800.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1527,8437,41734,755907,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',18000.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1528,8437,41734,755907,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL);
INSERT INTO `balance_libro` VALUES (1529,8437,41734,755907,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1800.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1530,8437,41734,755907,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8700.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1531,8437,41734,755907,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',13000.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1532,8437,41734,755907,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',15250.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1533,8437,41734,755907,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',9300.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1534,8437,41734,755907,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',24200.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1535,8437,41734,755907,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',4900.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1536,8437,41734,755907,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1500.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1537,8437,41734,755907,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1600.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1538,8437,41734,755907,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2400.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1539,8437,41734,755907,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',5600.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1540,8437,41734,755907,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',40000.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1541,8437,41734,755907,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',47700.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1542,8437,41734,755907,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',46200.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1543,8437,41734,755907,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',14600.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1544,8437,41734,755907,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',14800.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1545,8437,41734,755907,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',23490.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1546,8437,41734,755907,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',16320.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1547,8437,41734,755907,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',24560.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1548,8437,41734,755907,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1200.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL);
INSERT INTO `balance_libro` VALUES (1549,8437,41734,755907,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',8700.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1550,8437,41734,755907,2,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',14300.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1551,8437,41734,755907,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1600.00,NULL,NULL,1,'2023-02-15 11:58:00','2023-02-15 11:58:00',NULL),(1552,8437,41734,755907,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',12400.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1553,8437,41734,755907,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',37980.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1554,8437,41734,755907,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',46000.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1555,8437,41734,755907,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',47700.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1556,8437,41734,755907,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',23490.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1557,8437,41734,755907,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',48150.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1558,8437,41734,755907,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',57750.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1559,8437,41734,755907,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',26730.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1560,8437,41734,755907,2,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',33345.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1561,8437,41734,755907,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1200.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1562,8437,41734,755907,2,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',23500.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1563,8437,41734,755907,2,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',200.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1564,8437,41734,755907,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2000.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1565,8437,41734,755907,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',20100.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1566,8437,41734,755907,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17300.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1567,8437,41734,755907,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3400.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL),(1568,8437,41734,755907,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',200.00,NULL,NULL,1,'2023-02-15 11:58:01','2023-02-15 11:58:01',NULL);
INSERT INTO `balance_libro` VALUES (1569,8437,40800,59016,3,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',24430.00,NULL,NULL,1,'2023-02-15 12:09:33','2023-02-15 12:09:33',NULL),(1570,8437,40800,59016,3,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',44268.00,NULL,NULL,1,'2023-02-15 12:09:33','2023-02-15 12:09:33',NULL),(1571,8437,40800,59016,3,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',66600.00,NULL,NULL,1,'2023-02-15 12:09:33','2023-02-15 12:09:33',NULL),(1572,8437,40800,59016,3,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',66600.00,NULL,NULL,1,'2023-02-15 12:09:33','2023-02-15 12:09:33',NULL),(1573,8437,40800,59016,3,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3159.34,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1574,8437,40800,59016,3,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',42183.60,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1575,8437,40800,59016,3,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',55695.02,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1576,8437,40800,59016,3,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',66230.31,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1577,8437,40800,59016,3,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',78690.47,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1578,8437,40800,59016,3,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',60021.58,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1579,8437,40800,59016,3,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',19613.00,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1580,8437,40800,59016,3,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',22272.80,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1581,8437,40800,59016,3,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',3067.65,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1582,8437,40800,59016,3,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',43422.97,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1583,8437,40800,59016,3,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',22202.00,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1584,8437,40800,59016,3,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1403.15,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1585,8437,40800,59016,3,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',49740.47,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1586,8437,40800,59016,3,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',78771.00,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1587,8437,40800,59016,3,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-02-15 12:09:34','2023-02-15 12:09:34',NULL),(1588,8437,40800,59016,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30550.00,NULL,NULL,1,'2023-02-15 12:11:21','2023-02-15 12:11:21',NULL),(1589,8437,40800,59016,2,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',29990.00,NULL,NULL,1,'2023-02-15 12:11:21','2023-02-15 12:11:21',NULL);
INSERT INTO `balance_libro` VALUES (1590,8437,40800,59016,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30100.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1591,8437,40800,59016,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',29500.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1592,8437,40800,59016,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30000.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1593,8437,40800,59016,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30450.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1594,8437,40800,59016,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30500.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1595,8437,40800,59016,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30200.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1596,8437,40800,59016,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',29990.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1597,8437,40800,59016,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30000.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1598,8437,40800,59016,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30000.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1599,8437,40800,59016,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30000.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1600,8437,40800,59016,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30000.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1601,8437,40800,59016,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30000.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1602,8437,40800,59016,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30000.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1603,8437,40800,59016,2,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',29990.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1604,8437,40800,59016,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30000.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1605,8437,40800,59016,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',29500.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1606,8437,40800,59016,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30000.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1607,8437,40800,59016,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30000.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1608,8437,40800,59016,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',30000.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1609,8437,40800,59016,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',30230.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1610,8437,40800,59016,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',30000.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL);
INSERT INTO `balance_libro` VALUES (1611,8437,40800,59016,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',28666.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1612,8437,40800,59016,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',28500.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1613,8437,40800,59016,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',30000.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1614,8437,40800,59016,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',28500.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1615,8437,40800,59016,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',29500.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1616,8437,40800,59016,2,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',29950.00,NULL,NULL,1,'2023-02-15 12:11:22','2023-02-15 12:11:22',NULL),(1617,8437,40800,59016,2,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',30000.00,NULL,NULL,1,'2023-02-15 12:11:23','2023-02-15 12:11:23',NULL),(1618,8437,40800,59016,2,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',28700.00,NULL,NULL,1,'2023-02-15 12:11:23','2023-02-15 12:11:23',NULL),(1619,8437,40800,59016,3,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5168.68,NULL,NULL,1,'2023-02-15 12:14:54','2023-02-15 12:14:54',NULL),(1620,8437,40800,59016,3,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8270.97,NULL,NULL,1,'2023-02-15 12:17:58','2023-02-15 12:17:58',NULL),(1621,8437,40800,59016,3,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',42400.00,NULL,NULL,1,'2023-02-15 12:33:34','2023-02-15 12:33:34',NULL),(1622,8437,40941,231723,7,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',33926.72,NULL,NULL,1,'2023-02-15 12:51:05','2023-02-15 12:51:05',NULL),(1623,8437,40877,134763,3,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',4589.99,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL),(1624,8437,40877,134763,3,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',4589.99,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL),(1625,8437,40877,134763,3,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',22880.00,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL),(1626,8437,40877,134763,3,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',120997.00,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL),(1627,8437,40877,134763,3,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',37481.81,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL),(1628,8437,40877,134763,3,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',94936.49,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL),(1629,8437,40877,134763,3,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',110672.89,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL),(1630,8437,40877,134763,3,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',73433.99,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL);
INSERT INTO `balance_libro` VALUES (1631,8437,40877,134763,3,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',91425.00,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL),(1632,8437,40877,134763,3,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',65000.00,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL),(1633,8437,40877,134763,3,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',50403.28,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL),(1634,8437,40877,134763,3,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',166293.58,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL),(1635,8437,40877,134763,3,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',168085.00,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL),(1636,8437,40877,134763,3,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',29528.60,NULL,NULL,1,'2023-02-15 13:01:52','2023-02-15 13:01:52',NULL),(1637,8433,41421,754392,3,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',9920.00,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-14 00:04:29','2023-04-14 00:04:29'),(1638,8433,41421,754392,3,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',250.28,NULL,NULL,1,'2023-02-15 13:04:42','2023-02-17 09:49:32','2023-02-17 09:49:32'),(1639,8433,41421,754392,3,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1344.00,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-14 00:02:07','2023-04-14 00:02:07'),(1640,8433,41421,754392,3,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',11090.41,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-14 00:01:38','2023-04-14 00:01:38'),(1641,8433,41421,754392,3,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7010.65,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-14 00:00:55','2023-04-14 00:00:55'),(1642,8433,41421,754392,3,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',32768.00,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 23:58:55','2023-04-13 23:58:55'),(1643,8433,41421,754392,3,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',177851.85,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 23:55:57','2023-04-13 23:55:57'),(1644,8433,41421,754392,3,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2832.30,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 23:44:59','2023-04-13 23:44:59'),(1645,8433,41421,754392,3,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',8592.00,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 23:44:19','2023-04-13 23:44:19'),(1646,8433,41421,754392,3,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7400.99,NULL,NULL,1,'2023-02-15 13:04:42','2023-02-17 09:50:36','2023-02-17 09:50:36'),(1647,8433,41421,754392,3,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',3724.99,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 23:43:32','2023-04-13 23:43:32'),(1648,8433,41421,754392,3,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4800.00,NULL,NULL,1,'2023-02-15 13:04:42','2023-02-17 09:51:06','2023-02-17 09:51:06'),(1649,8433,41421,754392,3,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6180.91,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 23:49:40','2023-04-13 23:49:40');
INSERT INTO `balance_libro` VALUES (1650,8433,41421,754392,3,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',8.83,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 23:48:29','2023-04-13 23:48:29'),(1651,8433,41421,754392,3,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3197.69,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 23:47:58','2023-04-13 23:47:58'),(1652,8433,41421,754392,3,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',204.00,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 23:21:16','2023-04-13 23:21:16'),(1653,8433,41421,754392,3,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',88.49,NULL,NULL,1,'2023-02-15 13:04:42','2023-02-17 09:52:03','2023-02-17 09:52:03'),(1654,8433,41421,754392,3,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',584.00,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 23:20:15','2023-04-13 23:20:15'),(1655,8433,41421,754392,3,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8702.20,NULL,NULL,1,'2023-02-15 13:04:42','2023-02-17 09:53:01','2023-02-17 09:53:01'),(1656,8433,41421,754392,3,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',58856.29,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 23:46:00','2023-04-13 23:46:00'),(1657,8433,41421,754392,3,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7178.80,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 22:59:46','2023-04-13 22:59:46'),(1658,8433,41421,754392,3,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',552.91,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 23:00:25','2023-04-13 23:00:25'),(1659,8433,41421,754392,3,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',40878.00,NULL,NULL,1,'2023-02-15 13:04:42','2023-04-13 23:02:04','2023-04-13 23:02:04'),(1660,8433,41421,754392,3,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',16422.37,NULL,NULL,1,'2023-02-15 13:04:43','2023-04-13 23:02:26','2023-04-13 23:02:26'),(1661,8433,41421,754392,3,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',100.00,NULL,NULL,1,'2023-02-15 13:04:43','2023-04-13 23:03:06','2023-04-13 23:03:06'),(1662,8433,41421,754392,3,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5040.00,NULL,NULL,1,'2023-02-15 13:04:43','2023-04-13 23:03:54','2023-04-13 23:03:54'),(1663,8433,41421,754392,3,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',111663.18,NULL,NULL,1,'2023-02-15 13:04:43','2023-02-17 09:54:28','2023-02-17 09:54:28'),(1664,8433,41421,754392,3,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',7490.00,NULL,NULL,1,'2023-02-15 13:04:43','2023-04-13 23:06:27','2023-04-13 23:06:27'),(1665,8433,41421,754392,3,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3214.99,NULL,NULL,1,'2023-02-15 13:04:43','2023-04-13 23:07:59','2023-04-13 23:07:59'),(1666,8433,41421,754392,3,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',28613.09,NULL,NULL,1,'2023-02-15 13:04:43','2023-04-13 23:07:07','2023-04-13 23:07:07'),(1667,8437,40877,134763,3,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',18000.69,NULL,NULL,1,'2023-02-15 13:06:28','2023-02-15 13:06:28',NULL),(1668,8437,40877,134764,3,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',9500.30,NULL,NULL,1,'2023-02-15 13:08:42','2023-02-15 13:08:42',NULL);
INSERT INTO `balance_libro` VALUES (1669,8437,40877,134764,3,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',15001.90,NULL,NULL,1,'2023-02-15 13:10:29','2023-02-15 13:10:29',NULL),(1670,8437,40877,134763,3,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',11805.90,NULL,NULL,1,'2023-02-15 13:12:11','2023-02-15 13:12:11',NULL),(1671,8437,40877,134763,3,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',6000.00,NULL,NULL,1,'2023-02-15 13:13:19','2023-02-15 13:13:19',NULL),(1672,8437,40877,134763,3,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',16699.80,NULL,NULL,1,'2023-02-15 13:15:12','2023-02-15 13:15:12',NULL),(1673,8437,40877,134763,2,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1657245.85,NULL,NULL,1,'2023-02-15 13:20:59','2023-02-15 13:20:59',NULL),(1674,8437,40807,69621,3,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',120000.00,NULL,NULL,1,'2023-02-16 09:23:54','2023-02-16 09:23:54',NULL),(1675,8437,40796,51441,3,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',34727.00,NULL,NULL,1,'2023-02-16 09:35:02','2023-02-16 09:35:02',NULL),(1676,8437,40796,51441,3,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',987.00,NULL,NULL,1,'2023-02-16 09:35:02','2023-02-16 09:35:02',NULL),(1677,8437,40796,51441,3,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',28011.20,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1678,8437,40796,51441,3,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4894.71,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1679,8437,40796,51441,3,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',2193.47,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1680,8437,40796,51441,3,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',17720.06,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1681,8437,40796,51441,3,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',67362.62,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1682,8437,40796,51441,3,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',67362.62,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1683,8437,40796,51441,3,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1300.00,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1684,8437,40796,51441,3,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8999.00,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1685,8437,40796,51441,3,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',14722.00,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1686,8437,40796,51441,3,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',9789.43,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1687,8437,40796,51441,3,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1645.40,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1688,8437,40796,51441,3,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3526.00,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1689,8437,40796,51441,3,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',47459.85,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL);
INSERT INTO `balance_libro` VALUES (1690,8437,40796,51441,3,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',16919.59,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1691,8437,40796,51441,3,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',142069.91,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1692,8437,40796,51441,3,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3700.00,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1693,8437,40796,51441,3,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3500.00,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1694,8437,40796,51441,3,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',8930.00,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1695,8437,40796,51441,3,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',119760.68,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1696,8437,40796,51441,3,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',119760.68,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1697,8437,40796,51441,3,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',119760.68,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1698,8437,40796,51441,3,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1600.00,NULL,NULL,1,'2023-02-16 09:35:03','2023-02-16 09:35:03',NULL),(1699,8437,40796,51441,3,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',18365.50,NULL,NULL,1,'2023-02-16 09:35:04','2023-02-16 09:35:04',NULL),(1700,8437,40796,51441,3,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',20229.68,NULL,NULL,1,'2023-02-16 09:39:54','2023-02-16 09:39:54',NULL),(1701,8433,40929,213543,3,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',14540.00,NULL,NULL,1,'2023-02-16 09:41:08','2023-02-16 09:42:07','2023-02-16 09:42:07'),(1702,8433,40929,213543,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',22930.00,NULL,NULL,1,'2023-02-16 09:41:08','2023-02-16 09:42:33','2023-02-16 09:42:33'),(1703,8444,40874,130218,2,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',75895.23,NULL,NULL,1,'2023-02-16 09:41:37','2023-02-16 09:41:37',NULL),(1704,8433,40929,213543,3,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',14540.00,NULL,NULL,1,'2023-02-16 09:42:07','2023-03-20 16:42:00','2023-03-20 16:42:00'),(1705,8433,40929,213543,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',22930.00,NULL,NULL,1,'2023-02-16 09:42:33','2023-03-20 16:41:18','2023-03-20 16:41:18'),(1706,8437,40796,51441,3,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1719.70,NULL,NULL,1,'2023-02-16 09:43:48','2023-02-16 10:13:07','2023-02-16 10:13:07'),(1707,8437,40796,51442,3,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1194.25,NULL,NULL,1,'2023-02-16 09:47:10','2023-02-16 09:47:10',NULL),(1708,8437,40796,51441,3,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',632.81,NULL,NULL,1,'2023-02-16 09:50:22','2023-02-16 09:50:22',NULL),(1709,8437,40796,51441,3,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3270.40,NULL,NULL,1,'2023-02-16 09:52:55','2023-02-16 10:12:26','2023-02-16 10:12:26');
INSERT INTO `balance_libro` VALUES (1710,8433,41418,751362,2,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',162162.00,NULL,NULL,1,'2023-02-16 09:53:37','2023-02-16 09:53:37',NULL),(1711,8437,40796,51441,3,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',5988.51,NULL,NULL,1,'2023-02-16 09:55:51','2023-02-16 10:12:03','2023-02-16 10:12:03'),(1712,8437,40796,51441,3,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',74399.45,NULL,NULL,1,'2023-02-16 09:57:11','2023-02-16 10:11:44','2023-02-16 10:11:44'),(1713,8444,40874,130218,2,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',84194.99,NULL,NULL,1,'2023-02-16 09:57:46','2023-02-16 09:57:46',NULL),(1714,8444,40874,130218,2,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',98027.19,NULL,NULL,1,'2023-02-16 09:58:20','2023-02-16 09:58:20',NULL),(1715,8444,40874,130218,2,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',94241.94,NULL,NULL,1,'2023-02-16 09:58:54','2023-02-16 09:59:23','2023-02-16 09:59:23'),(1716,8437,40796,51441,3,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1000.00,NULL,NULL,1,'2023-02-16 09:59:12','2023-02-16 10:11:19','2023-02-16 10:11:19'),(1717,8444,40874,130218,2,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',94241.94,NULL,NULL,1,'2023-02-16 09:59:23','2023-02-16 09:59:23',NULL),(1718,8444,40874,130218,2,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',140176.59,NULL,NULL,1,'2023-02-16 10:00:41','2023-02-16 10:00:41',NULL),(1719,8433,40799,57501,3,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',5215.50,NULL,NULL,1,'2023-02-16 10:00:51','2023-02-16 10:00:51',NULL),(1720,8433,40799,57501,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',34093.00,NULL,NULL,1,'2023-02-16 10:00:51','2023-02-16 10:03:25','2023-02-16 10:03:25'),(1721,8433,40799,57501,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',342000.00,NULL,NULL,1,'2023-02-16 10:00:51','2023-02-16 10:02:39','2023-02-16 10:02:39'),(1722,8433,40799,57501,3,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1929.63,NULL,NULL,1,'2023-02-16 10:00:51','2023-02-16 10:00:51',NULL),(1723,8433,40799,57501,3,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',342000.00,NULL,NULL,1,'2023-02-16 10:02:39','2023-02-16 10:02:39',NULL),(1724,8444,40874,130218,2,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',148311.48,NULL,NULL,1,'2023-02-16 10:03:05','2023-02-16 12:01:31','2023-02-16 12:01:31'),(1725,8433,40799,57501,3,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',34093.00,NULL,NULL,1,'2023-02-16 10:03:25','2023-02-16 10:03:25',NULL),(1726,8444,40874,130218,2,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',77593.25,NULL,NULL,1,'2023-02-16 10:03:46','2023-02-16 10:03:46',NULL),(1727,8437,40796,51441,3,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',8591.06,NULL,NULL,1,'2023-02-16 10:05:24','2023-02-16 10:05:24',NULL),(1728,8437,40796,51441,3,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',29493.02,NULL,NULL,1,'2023-02-16 10:09:15','2023-02-16 10:10:43','2023-02-16 10:10:43'),(1729,8444,40874,130218,2,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',65321.46,NULL,NULL,1,'2023-02-16 10:12:35','2023-02-16 10:12:35',NULL);
INSERT INTO `balance_libro` VALUES (1730,8433,40781,28719,2,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',119999.94,NULL,NULL,1,'2023-02-16 10:17:43','2023-02-16 10:17:43',NULL),(1731,8433,40781,28719,2,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',90827.82,NULL,NULL,1,'2023-02-16 10:17:43','2023-02-16 10:17:43',NULL),(1732,8444,40874,130218,2,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',87154.85,NULL,NULL,1,'2023-02-16 10:17:47','2023-02-16 10:17:47',NULL),(1733,8433,40781,28719,3,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',23000.00,NULL,NULL,1,'2023-02-16 10:18:51','2023-02-16 10:21:00','2023-02-16 10:21:00'),(1734,8433,40781,28719,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',20000.00,NULL,NULL,1,'2023-02-16 10:18:51','2023-02-16 10:21:35','2023-02-16 10:21:35'),(1735,8433,40781,28719,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',45000.00,NULL,NULL,1,'2023-02-16 10:18:51','2023-02-16 10:22:08','2023-02-16 10:22:08'),(1736,8433,40781,28719,3,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5369.83,NULL,NULL,1,'2023-02-16 10:18:51','2023-04-24 11:01:29','2023-04-24 11:01:29'),(1737,8433,40781,28719,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',122575.52,NULL,NULL,1,'2023-02-16 10:18:51','2023-02-16 10:35:47','2023-02-16 10:35:47'),(1738,8433,40781,28719,3,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',645.00,NULL,NULL,1,'2023-02-16 10:18:51','2023-04-24 11:03:22','2023-04-24 11:03:22'),(1739,8433,40781,28719,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6319.55,NULL,NULL,1,'2023-02-16 10:18:51','2023-02-16 10:38:04','2023-02-16 10:38:04'),(1740,8433,40781,28719,3,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',46780.00,NULL,NULL,1,'2023-02-16 10:18:51','2023-04-24 11:09:03','2023-04-24 11:09:03'),(1741,8433,40781,28719,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',44058.54,NULL,NULL,1,'2023-02-16 10:18:52','2023-02-16 10:40:15','2023-02-16 10:40:15'),(1742,8433,40781,28719,3,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',720.75,NULL,NULL,1,'2023-02-16 10:18:52','2023-02-16 10:18:52',NULL),(1743,8444,40874,130218,2,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',64315.53,NULL,NULL,1,'2023-02-16 10:19:14','2023-02-16 10:19:14',NULL),(1744,8444,40874,130218,2,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',97928.88,NULL,NULL,1,'2023-02-16 10:19:39','2023-02-16 10:19:39',NULL),(1745,8444,40874,130218,2,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',90910.77,NULL,NULL,1,'2023-02-16 10:20:57','2023-02-16 10:20:57',NULL),(1746,8433,40781,28719,3,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',23000.00,NULL,NULL,1,'2023-02-16 10:21:00','2023-04-24 10:46:59','2023-04-24 10:46:59'),(1747,8433,40781,28719,3,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',20000.00,NULL,NULL,1,'2023-02-16 10:21:35','2023-04-24 10:51:22','2023-04-24 10:51:22'),(1748,8444,40874,130218,2,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',96694.19,NULL,NULL,1,'2023-02-16 10:21:35','2023-02-16 10:21:35',NULL);
INSERT INTO `balance_libro` VALUES (1749,8433,40781,28719,3,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',45000.00,NULL,NULL,1,'2023-02-16 10:22:08','2023-04-24 10:53:00','2023-04-24 10:53:00'),(1750,8437,40796,51441,3,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',35498.00,NULL,NULL,1,'2023-02-16 10:23:46','2023-02-16 10:23:46',NULL),(1751,8444,40874,130218,2,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',100599.51,NULL,NULL,1,'2023-02-16 10:24:40','2023-02-16 10:24:40',NULL),(1752,8433,40781,28719,3,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',122575.52,NULL,NULL,1,'2023-02-16 10:35:47','2023-04-24 11:03:00','2023-04-24 11:03:00'),(1753,8437,40796,51441,3,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1204.46,NULL,NULL,1,'2023-02-16 10:37:29','2023-02-16 10:37:29',NULL),(1754,8433,40781,28719,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6319.55,NULL,NULL,1,'2023-02-16 10:38:04','2023-02-17 10:08:30','2023-02-17 10:08:30'),(1755,8433,40781,28719,3,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',44058.54,NULL,NULL,1,'2023-02-16 10:40:15','2023-02-16 10:40:15',NULL),(1756,8437,40796,51441,3,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1420.00,NULL,NULL,1,'2023-02-16 10:43:10','2023-02-16 10:43:10',NULL),(1757,8444,40874,130218,2,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',58564.94,NULL,NULL,1,'2023-02-16 10:44:43','2023-02-16 10:44:43',NULL),(1758,8433,40797,52956,3,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1815.00,NULL,NULL,1,'2023-02-16 10:46:14','2023-02-16 10:46:14',NULL),(1759,8433,40797,52956,3,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',350000.00,NULL,NULL,1,'2023-02-16 10:46:14','2023-02-16 10:48:29','2023-02-16 10:48:29'),(1760,8433,40797,52956,3,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',28500.00,NULL,NULL,1,'2023-02-16 10:46:14','2023-02-16 10:46:14',NULL),(1761,8433,40797,52956,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',112500.00,NULL,NULL,1,'2023-02-16 10:46:14','2023-02-16 10:48:51','2023-02-16 10:48:51'),(1762,8433,40797,52956,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',41000.00,NULL,NULL,1,'2023-02-16 10:46:14','2023-02-16 10:49:12','2023-02-16 10:49:12'),(1763,8433,40797,52956,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',300000.00,NULL,NULL,1,'2023-02-16 10:46:14','2023-02-16 10:49:37','2023-02-16 10:49:37'),(1764,8433,40797,52956,3,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',32866.53,NULL,NULL,1,'2023-02-16 10:46:14','2023-04-19 10:39:04','2023-04-19 10:39:04'),(1765,8433,40797,52956,3,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',350000.00,NULL,NULL,1,'2023-02-16 10:48:29','2023-02-16 10:48:29',NULL),(1766,8433,40797,52956,3,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',112500.00,NULL,NULL,1,'2023-02-16 10:48:51','2023-04-19 10:32:40','2023-04-19 10:32:40'),(1767,8433,40797,52956,3,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',41000.00,NULL,NULL,1,'2023-02-16 10:49:12','2023-04-19 10:33:02','2023-04-19 10:33:02'),(1768,8433,40797,52956,3,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',300000.00,NULL,NULL,1,'2023-02-16 10:49:37','2023-04-19 10:43:50','2023-04-19 10:43:50');
INSERT INTO `balance_libro` VALUES (1769,8437,40796,51441,3,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1469.75,NULL,NULL,1,'2023-02-16 10:50:50','2023-02-16 10:50:50',NULL),(1770,8437,40796,51441,3,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',994.12,NULL,NULL,1,'2023-02-16 10:51:49','2023-02-16 10:51:49',NULL),(1771,8437,40796,51441,3,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1553.45,NULL,NULL,1,'2023-02-16 10:53:02','2023-02-16 10:53:02',NULL),(1772,8437,40796,51441,3,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1479.96,NULL,NULL,1,'2023-02-16 10:54:27','2023-02-16 10:54:27',NULL),(1773,8437,40796,51441,3,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',831.84,NULL,NULL,1,'2023-02-16 10:55:55','2023-02-16 10:55:55',NULL),(1774,8437,40796,51441,3,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1572.84,NULL,NULL,1,'2023-02-16 10:57:12','2023-02-16 10:57:12',NULL),(1775,8437,40796,51441,3,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1561.61,NULL,NULL,1,'2023-02-16 10:58:28','2023-02-16 10:58:28',NULL),(1776,8437,40796,51441,3,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1582.02,NULL,NULL,1,'2023-02-16 10:59:50','2023-02-16 10:59:50',NULL),(1777,8433,40797,52956,3,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21888.00,NULL,NULL,1,'2023-02-16 11:00:18','2023-02-16 11:00:18',NULL),(1778,8437,40796,51441,3,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1398.31,NULL,NULL,1,'2023-02-16 11:01:26','2023-02-16 11:01:26',NULL),(1779,8437,40796,51441,3,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1043.12,NULL,NULL,1,'2023-02-16 11:02:55','2023-02-16 11:02:55',NULL),(1780,8437,40796,51441,3,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1674.91,NULL,NULL,1,'2023-02-16 11:03:52','2023-02-16 11:03:52',NULL),(1781,8437,40796,51441,3,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1408.51,NULL,NULL,1,'2023-02-16 11:05:14','2023-02-16 11:05:14',NULL),(1782,8437,40796,51441,3,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',7634.92,NULL,NULL,1,'2023-02-16 11:07:58','2023-02-16 11:07:58',NULL),(1783,8437,40796,51441,3,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1386.06,NULL,NULL,1,'2023-02-16 11:09:42','2023-02-16 11:09:42',NULL),(1784,8437,40796,51441,3,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1536.09,NULL,NULL,1,'2023-02-16 11:10:42','2023-02-16 11:10:42',NULL),(1785,8437,40796,51441,3,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1678.98,NULL,NULL,1,'2023-02-16 11:13:02','2023-02-16 11:13:02',NULL),(1786,8437,40796,51441,3,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',475.00,NULL,NULL,1,'2023-02-16 11:15:51','2023-02-16 11:15:51',NULL),(1787,8437,40796,51441,3,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',26094.54,NULL,NULL,1,'2023-02-16 11:17:16','2023-02-16 11:17:16',NULL),(1788,8437,40796,51442,3,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1255.41,NULL,NULL,1,'2023-02-16 11:18:39','2023-02-16 11:18:39',NULL),(1789,8433,40870,127191,3,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',11470.00,NULL,NULL,1,'2023-02-16 11:18:47','2023-05-10 10:11:53','2023-05-10 10:11:53');
INSERT INTO `balance_libro` VALUES (1790,8437,40796,51442,3,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1459.55,NULL,NULL,1,'2023-02-16 11:19:32','2023-02-16 11:19:32',NULL),(1791,8437,40796,51442,3,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1610.60,NULL,NULL,1,'2023-02-16 11:20:16','2023-02-16 11:20:16',NULL),(1792,8433,40870,127191,3,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7582.30,NULL,NULL,1,'2023-02-16 11:20:50','2023-05-10 10:19:07','2023-05-10 10:19:07'),(1793,8437,40796,51441,3,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1602.44,NULL,NULL,1,'2023-02-16 11:21:58','2023-02-16 11:21:58',NULL),(1794,8433,40870,127191,3,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',7362.87,NULL,NULL,1,'2023-02-16 11:22:30','2023-05-10 10:19:24','2023-05-10 10:19:24'),(1795,8437,40796,51441,3,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',11129.87,NULL,NULL,1,'2023-02-16 11:23:13','2023-02-16 11:23:13',NULL),(1796,8433,40870,127191,3,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',275000.00,NULL,NULL,1,'2023-02-16 11:23:39','2023-05-10 10:24:35','2023-05-10 10:24:35'),(1797,8433,40870,127191,3,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',275000.00,NULL,NULL,1,'2023-02-16 11:24:01','2023-05-10 10:24:07','2023-05-10 10:24:07'),(1798,8437,40796,51441,3,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1388.10,NULL,NULL,1,'2023-02-16 11:24:53','2023-02-16 11:24:53',NULL),(1799,8433,40795,49926,3,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',14000.00,NULL,NULL,1,'2023-02-16 11:25:35','2023-02-16 11:25:35',NULL),(1800,8437,40796,51441,3,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2041.32,NULL,NULL,1,'2023-02-16 11:25:52','2023-02-16 11:25:52',NULL),(1801,8437,40796,51441,3,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1281.95,NULL,NULL,1,'2023-02-16 11:26:50','2023-02-16 11:26:50',NULL),(1802,8433,40795,49926,3,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',130025.00,NULL,NULL,1,'2023-02-16 11:27:52','2023-02-16 11:27:52',NULL),(1803,8437,40796,51441,3,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1469.75,NULL,NULL,1,'2023-02-16 11:28:09','2023-02-16 11:28:09',NULL),(1804,8433,40795,49926,3,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',30712.50,NULL,NULL,1,'2023-02-16 11:28:27','2023-02-16 11:28:27',NULL),(1805,8444,40874,130218,2,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',103140.71,NULL,NULL,1,'2023-02-16 11:28:35','2023-02-16 12:01:53','2023-02-16 12:01:53'),(1806,8433,40795,49926,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2286.36,NULL,NULL,1,'2023-02-16 11:29:01','2023-03-31 10:42:25','2023-03-31 10:42:25'),(1807,8444,40874,130218,2,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',86212.89,NULL,NULL,1,'2023-02-16 11:29:02','2023-02-16 11:29:02',NULL),(1808,8437,40796,51441,3,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',893.08,NULL,NULL,1,'2023-02-16 11:29:19','2023-02-16 11:29:19',NULL),(1809,8444,40874,130218,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',81861.50,NULL,NULL,1,'2023-02-16 11:29:35','2023-02-16 11:29:35',NULL);
INSERT INTO `balance_libro` VALUES (1810,8437,40796,51441,3,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1451.38,NULL,NULL,1,'2023-02-16 11:31:16','2023-02-16 11:31:16',NULL),(1811,8437,40796,51441,3,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3063.75,NULL,NULL,1,'2023-02-16 11:33:55','2023-02-16 11:33:55',NULL),(1812,8444,40874,130218,2,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',61789.50,NULL,NULL,1,'2023-02-16 11:33:58','2023-02-16 11:33:58',NULL),(1813,8444,40874,130218,2,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',162186.72,NULL,NULL,1,'2023-02-16 11:34:25','2023-02-16 11:34:25',NULL),(1814,8444,40874,130218,2,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',136839.57,NULL,NULL,1,'2023-02-16 11:34:58','2023-02-16 11:34:58',NULL),(1815,8437,40796,51441,3,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1452.43,NULL,NULL,1,'2023-02-16 11:35:15','2023-02-16 11:35:15',NULL),(1816,8433,40783,31749,3,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',21450.00,NULL,NULL,1,'2023-02-16 11:35:50','2023-03-21 10:15:31','2023-03-21 10:15:31'),(1817,8444,40874,130218,2,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',91923.17,NULL,NULL,1,'2023-02-16 11:36:02','2023-02-16 11:56:44','2023-02-16 11:56:44'),(1818,8433,40783,31749,3,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',12562.73,NULL,NULL,1,'2023-02-16 11:36:33','2023-03-21 10:14:19','2023-03-21 10:14:19'),(1819,8444,40874,130218,2,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',59549.40,NULL,NULL,1,'2023-02-16 11:36:33','2023-02-16 11:36:33',NULL),(1820,8437,40796,51441,3,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1378.37,NULL,NULL,1,'2023-02-16 11:37:27','2023-02-16 11:37:27',NULL),(1821,8437,40796,51441,3,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1499.35,NULL,NULL,1,'2023-02-16 11:38:21','2023-02-16 11:38:21',NULL),(1822,8433,40783,31749,3,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',18375.57,NULL,NULL,1,'2023-02-16 11:38:55','2023-02-16 11:38:55',NULL),(1823,8437,40796,51441,3,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1353.40,NULL,NULL,1,'2023-02-16 11:39:17','2023-02-16 11:39:17',NULL),(1824,8437,40796,51441,3,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1294.20,NULL,NULL,1,'2023-02-16 11:40:43','2023-02-16 11:40:43',NULL),(1825,8433,40783,31749,3,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',46263.16,NULL,NULL,1,'2023-02-16 11:40:55','2023-04-11 11:34:52','2023-04-11 11:34:52'),(1826,8444,40874,130218,2,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',69755.40,NULL,NULL,1,'2023-02-16 11:41:46','2023-02-16 11:41:46',NULL),(1827,8437,40796,51441,3,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1692.26,NULL,NULL,1,'2023-02-16 11:41:54','2023-02-16 11:41:54',NULL),(1828,8437,40796,51441,3,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',1428.92,NULL,NULL,1,'2023-02-16 11:42:53','2023-02-16 11:42:53',NULL),(1829,8444,40874,130218,2,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',90700.16,NULL,NULL,1,'2023-02-16 11:43:24','2023-02-16 11:43:24',NULL);
INSERT INTO `balance_libro` VALUES (1830,8444,40874,130218,2,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',77739.33,NULL,NULL,1,'2023-02-16 11:43:58','2023-02-16 11:43:58',NULL),(1831,8437,40796,51442,3,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1240.10,NULL,NULL,1,'2023-02-16 11:44:09','2023-02-16 11:44:09',NULL),(1832,8444,40874,130218,2,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',196343.29,NULL,NULL,1,'2023-02-16 11:44:43','2023-02-16 11:44:43',NULL),(1833,8437,40796,51442,3,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1189.07,NULL,NULL,1,'2023-02-16 11:45:19','2023-02-16 11:45:19',NULL),(1834,8437,40796,51442,3,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',4048.27,NULL,NULL,1,'2023-02-16 11:46:58','2023-02-16 11:46:58',NULL),(1835,8437,40796,51442,3,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',823.67,NULL,NULL,1,'2023-02-16 11:47:51','2023-02-16 11:47:51',NULL),(1836,8433,40724,7530,3,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',122388.00,NULL,NULL,1,'2023-02-16 11:48:08','2023-03-15 09:23:54','2023-03-15 09:23:54'),(1837,8433,40724,7530,3,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',83335.17,NULL,NULL,1,'2023-02-16 11:48:48','2023-04-12 11:50:19','2023-04-12 11:50:19'),(1838,8433,40724,7530,3,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',51112.18,NULL,NULL,1,'2023-02-16 11:49:27','2023-04-12 11:52:08','2023-04-12 11:52:08'),(1839,8433,40724,7530,3,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',43082.00,NULL,NULL,1,'2023-02-16 11:49:55','2023-04-12 12:59:19','2023-04-12 12:59:19'),(1840,8433,40724,7530,3,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4050.00,NULL,NULL,1,'2023-02-16 11:50:30','2023-04-12 13:10:03','2023-04-12 13:10:03'),(1841,8437,40796,51442,2,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',33510.34,NULL,NULL,1,'2023-02-16 11:51:36','2023-02-22 11:36:12','2023-02-22 11:36:12'),(1842,8433,40724,7530,3,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8691.00,NULL,NULL,1,'2023-02-16 11:54:38','2023-04-12 13:17:35','2023-04-12 13:17:35'),(1843,8444,40874,130218,2,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',219480.15,NULL,NULL,1,'2023-02-16 11:55:05','2023-02-16 11:55:05',NULL),(1844,8444,40874,130218,2,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',77229.86,NULL,NULL,1,'2023-02-16 11:55:30','2023-02-16 11:55:30',NULL),(1845,8433,40724,7530,3,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',11000.00,NULL,NULL,1,'2023-02-16 11:55:34','2023-04-12 13:22:20','2023-04-12 13:22:20'),(1846,8433,40724,7530,3,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',11000.00,NULL,NULL,1,'2023-02-16 11:56:04','2023-04-12 13:22:43','2023-04-12 13:22:43'),(1847,8444,40874,130218,2,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',91923.17,NULL,NULL,1,'2023-02-16 11:56:44','2023-02-16 11:56:44',NULL),(1848,8433,40724,7530,3,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',5169.12,NULL,NULL,1,'2023-02-16 12:00:17','2023-04-13 10:48:49','2023-04-13 10:48:49'),(1849,8444,40874,130218,2,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',148311.48,NULL,NULL,1,'2023-02-16 12:01:31','2023-02-16 12:01:31',NULL);
INSERT INTO `balance_libro` VALUES (1850,8444,40874,130218,2,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',103140.71,NULL,NULL,1,'2023-02-16 12:01:53','2023-02-16 12:01:53',NULL),(1851,8437,40790,42351,3,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',5503.61,NULL,NULL,1,'2023-02-16 12:02:11','2023-02-16 12:02:11',NULL),(1852,8433,40724,7530,3,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',9844.96,NULL,NULL,1,'2023-02-16 12:02:36','2023-04-12 13:17:58','2023-04-12 13:17:58'),(1853,8433,40724,7530,3,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',138662.27,NULL,NULL,1,'2023-02-16 12:03:14','2023-04-13 11:40:16','2023-04-13 11:40:16'),(1854,8437,40790,42351,3,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7147.10,NULL,NULL,1,'2023-02-16 12:03:33','2023-02-16 12:03:33',NULL),(1855,8433,40724,7530,3,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',76200.00,NULL,NULL,1,'2023-02-16 12:03:47','2023-04-13 11:42:26','2023-04-13 11:42:26'),(1856,8433,40724,7530,3,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',124006.16,NULL,NULL,1,'2023-02-16 12:04:23','2023-04-13 11:46:12','2023-04-13 11:46:12'),(1857,8433,40724,7530,3,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6000.00,NULL,NULL,1,'2023-02-16 12:04:52','2023-04-13 11:46:36','2023-04-13 11:46:36'),(1858,8437,40790,42352,3,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',3000.00,NULL,NULL,1,'2023-02-16 12:04:56','2023-02-16 12:04:56',NULL),(1859,8433,40724,7530,3,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',150869.49,NULL,NULL,1,'2023-02-16 12:05:32','2023-04-13 11:49:05','2023-04-13 11:49:05'),(1860,8433,40724,7530,3,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',120000.00,NULL,NULL,1,'2023-02-16 12:05:54','2023-04-13 11:49:27','2023-04-13 11:49:27'),(1861,8433,40724,7530,3,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',120000.00,NULL,NULL,1,'2023-02-16 12:06:24','2023-04-13 11:49:52','2023-04-13 11:49:52'),(1862,8433,40724,7530,3,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',150004.01,NULL,NULL,1,'2023-02-16 12:06:59','2023-04-13 11:51:48','2023-04-13 11:51:48'),(1863,8433,40724,7530,3,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',144932.00,NULL,NULL,1,'2023-02-16 12:07:30','2023-04-13 11:57:13','2023-04-13 11:57:13'),(1864,8437,40790,42351,3,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',6300.63,NULL,NULL,1,'2023-02-16 12:11:26','2023-02-16 12:11:26',NULL),(1865,8437,40790,42351,3,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',4500.01,NULL,NULL,1,'2023-02-16 12:17:28','2023-02-16 12:17:28',NULL),(1866,8437,40790,42351,3,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3000.04,NULL,NULL,1,'2023-02-16 12:19:29','2023-02-16 12:19:29',NULL),(1867,8437,40790,42351,3,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',4000.00,NULL,NULL,1,'2023-02-16 12:21:03','2023-02-16 12:21:03',NULL),(1868,8437,40790,42351,3,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3000.00,NULL,NULL,1,'2023-02-16 12:22:20','2023-02-16 12:22:20',NULL),(1869,8437,40790,42351,3,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',9900.60,NULL,NULL,1,'2023-02-16 12:23:50','2023-02-16 12:23:50',NULL);
INSERT INTO `balance_libro` VALUES (1870,8437,40790,42351,3,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3999.99,NULL,NULL,1,'2023-02-16 12:24:48','2023-02-16 12:24:48',NULL),(1871,8437,40790,42351,3,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3000.00,NULL,NULL,1,'2023-02-16 12:26:42','2023-02-16 12:26:42',NULL),(1872,8437,40790,42351,3,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2000.00,NULL,NULL,1,'2023-02-16 12:27:50','2023-02-16 12:27:50',NULL),(1873,8437,40790,42351,3,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2999.99,NULL,NULL,1,'2023-02-16 12:29:17','2023-02-16 12:29:17',NULL),(1874,8437,40790,42351,3,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',8000.00,NULL,NULL,1,'2023-02-16 12:30:43','2023-02-16 12:30:43',NULL),(1875,8437,40790,42351,3,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3000.00,NULL,NULL,1,'2023-02-16 12:31:35','2023-02-16 12:31:35',NULL),(1876,8437,40874,130218,3,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3050.01,NULL,NULL,1,'2023-02-16 12:46:09','2023-02-16 12:46:09',NULL),(1877,8437,40874,130218,3,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3050.01,NULL,NULL,1,'2023-02-16 12:46:09','2023-02-16 12:46:09',NULL),(1878,8437,40874,130218,3,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',60121.59,NULL,NULL,1,'2023-02-16 12:46:09','2023-02-16 12:46:09',NULL),(1879,8437,40874,130218,3,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',18584.56,NULL,NULL,1,'2023-02-16 12:46:09','2023-02-16 12:46:09',NULL),(1880,8437,40874,130218,3,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',34216.49,NULL,NULL,1,'2023-02-16 12:46:09','2023-02-16 12:46:09',NULL),(1881,8437,40874,130218,3,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',27337.23,NULL,NULL,1,'2023-02-16 12:46:09','2023-02-16 12:46:09',NULL),(1882,8437,40874,130218,3,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',109109.56,NULL,NULL,1,'2023-02-16 12:46:09','2023-02-16 12:46:09',NULL),(1883,8437,40874,130218,3,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',35130.07,NULL,NULL,1,'2023-02-16 12:46:09','2023-02-16 12:46:09',NULL),(1884,8437,40874,130218,3,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',94644.58,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1885,8437,40874,130218,3,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',44200.01,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1886,8437,40874,130218,3,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',29615.10,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1887,8437,40874,130218,3,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',14473.22,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1888,8437,40874,130218,3,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',16554.72,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1889,8437,40874,130218,3,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',34100.28,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL);
INSERT INTO `balance_libro` VALUES (1890,8437,40874,130218,3,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',13911.85,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1891,8437,40874,130218,3,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',73758.14,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1892,8437,40874,130218,3,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',48882.53,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1893,8437,40874,130218,3,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2452.13,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1894,8437,40874,130218,3,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',41344.22,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1895,8437,40874,130218,3,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',39216.10,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1896,8437,40874,130218,3,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',30900.90,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1897,8437,40874,130218,3,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',22596.94,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1898,8437,40874,130218,3,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',86561.60,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1899,8437,40874,130218,3,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',147977.29,NULL,NULL,1,'2023-02-16 12:46:10','2023-02-16 12:46:10',NULL),(1900,8437,40874,130218,3,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5561.45,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL),(1901,8437,40874,130218,3,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',81821.29,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL),(1902,8437,40874,130218,3,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',71643.03,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL),(1903,8437,40874,130218,3,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',39722.36,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL),(1904,8437,40874,130218,3,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',62110.26,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL),(1905,8437,40874,130218,3,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2336.27,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL),(1906,8437,40874,130218,3,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',988.30,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL),(1907,8437,40874,130218,3,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',58010.61,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL),(1908,8437,40874,130218,3,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',40498.03,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL),(1909,8437,40874,130218,3,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',109900.42,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL);
INSERT INTO `balance_libro` VALUES (1910,8437,40874,130218,3,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',50656.60,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL),(1911,8437,40874,130218,3,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',22439.37,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL),(1912,8437,40874,130218,3,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',60339.00,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL),(1913,8437,40874,130218,3,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3972.24,NULL,NULL,1,'2023-02-16 12:46:11','2023-02-16 12:46:11',NULL),(1914,8437,40874,130218,3,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',79521.05,NULL,NULL,1,'2023-02-16 12:46:12','2023-02-16 12:46:12',NULL),(1915,8437,40874,130218,3,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',22907.01,NULL,NULL,1,'2023-02-16 12:46:12','2023-02-16 12:46:12',NULL),(1916,8437,40874,130218,3,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',20696.80,NULL,NULL,1,'2023-02-16 12:46:12','2023-02-16 12:46:12',NULL),(1917,8437,40874,130218,3,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',13506.56,NULL,NULL,1,'2023-02-16 12:46:12','2023-02-16 12:46:12',NULL),(1918,8437,40874,130218,3,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1453.42,NULL,NULL,1,'2023-02-16 12:46:12','2023-02-16 12:46:12',NULL),(1919,8437,40874,130218,3,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',28887.38,NULL,NULL,1,'2023-02-16 12:46:12','2023-02-16 12:46:12',NULL),(1920,8437,40874,130218,3,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2193.00,NULL,NULL,1,'2023-02-16 12:46:12','2023-02-16 12:46:12',NULL),(1921,8437,40874,130218,3,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',94344.87,NULL,NULL,1,'2023-02-16 12:46:12','2023-02-16 12:46:12',NULL),(1922,8437,40874,130218,3,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',22948.41,NULL,NULL,1,'2023-02-16 12:46:12','2023-02-16 12:46:12',NULL),(1923,8437,40874,130218,3,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',12346.92,NULL,NULL,1,'2023-02-16 12:46:13','2023-02-16 12:46:13',NULL),(1924,8437,40874,130218,3,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',22591.21,NULL,NULL,1,'2023-02-16 12:46:13','2023-02-16 12:46:13',NULL),(1925,8437,40874,130218,3,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',31752.43,NULL,NULL,1,'2023-02-16 12:46:13','2023-02-16 12:46:13',NULL),(1926,8437,40874,130218,3,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',108100.38,NULL,NULL,1,'2023-02-16 12:46:13','2023-02-16 12:46:13',NULL),(1927,8437,40874,130218,3,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',30079.93,NULL,NULL,1,'2023-02-16 12:46:13','2023-02-16 12:46:13',NULL),(1928,8437,40874,130218,3,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',19032.24,NULL,NULL,1,'2023-02-16 12:46:13','2023-02-16 12:46:13',NULL),(1929,8437,40874,130218,3,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',26966.33,NULL,NULL,1,'2023-02-16 12:46:13','2023-02-16 12:46:13',NULL);
INSERT INTO `balance_libro` VALUES (1930,8437,40874,130218,3,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',41686.55,NULL,NULL,1,'2023-02-16 12:46:13','2023-02-16 12:46:13',NULL),(1931,8437,40874,130218,3,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',12439.21,NULL,NULL,1,'2023-02-16 12:46:13','2023-02-16 12:46:13',NULL),(1932,8437,40874,130218,3,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',12775.51,NULL,NULL,1,'2023-02-16 12:46:13','2023-02-16 12:46:13',NULL),(1933,8437,40874,130218,3,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',33854.42,NULL,NULL,1,'2023-02-16 12:46:14','2023-02-16 12:46:14',NULL),(1934,8437,40874,130218,3,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',23658.04,NULL,NULL,1,'2023-02-16 12:46:14','2023-02-16 12:46:14',NULL),(1935,8437,40874,130218,3,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',5799.00,NULL,NULL,1,'2023-02-16 12:46:14','2023-02-16 12:46:14',NULL),(1936,8437,40874,130218,3,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',67322.02,NULL,NULL,1,'2023-02-16 12:46:14','2023-02-16 12:46:14',NULL),(1937,8437,40874,130218,3,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',12383.22,NULL,NULL,1,'2023-02-16 12:46:14','2023-02-16 12:46:14',NULL),(1938,8437,40874,130218,3,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',33354.35,NULL,NULL,1,'2023-02-16 12:46:14','2023-02-16 12:46:14',NULL),(1939,8437,40874,130218,3,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',10597.19,NULL,NULL,1,'2023-02-16 12:46:14','2023-02-16 12:46:14',NULL),(1940,8437,40874,130218,3,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',434.13,NULL,NULL,1,'2023-02-16 12:46:14','2023-02-16 12:46:14',NULL),(1941,8437,40874,130218,3,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',544.88,NULL,NULL,1,'2023-02-16 12:46:15','2023-02-16 12:46:15',NULL),(1942,8437,40874,130218,3,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',30863.98,NULL,NULL,1,'2023-02-16 12:46:15','2023-02-16 12:46:15',NULL),(1943,8437,40874,130218,3,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19525.30,NULL,NULL,1,'2023-02-16 12:46:15','2023-02-16 12:46:15',NULL),(1944,8437,40874,130218,3,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',135099.51,NULL,NULL,1,'2023-02-16 12:46:15','2023-02-16 12:46:15',NULL),(1945,8437,40874,130218,3,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13915.00,NULL,NULL,1,'2023-02-16 12:46:15','2023-02-16 12:46:15',NULL),(1946,8437,40874,130218,3,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',4200.41,NULL,NULL,1,'2023-02-16 12:50:30','2023-02-16 12:50:30',NULL),(1947,8437,40874,130218,3,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',7884.30,NULL,NULL,1,'2023-02-16 12:52:09','2023-02-16 12:52:09',NULL),(1948,8437,40874,130218,3,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',17323.62,NULL,NULL,1,'2023-02-16 12:53:20','2023-02-16 12:53:20',NULL),(1949,8437,40874,130218,3,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',17007.45,NULL,NULL,1,'2023-02-16 12:54:25','2023-02-16 12:54:25',NULL);
INSERT INTO `balance_libro` VALUES (1950,8437,40874,130218,3,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',41855.25,NULL,NULL,1,'2023-02-16 12:58:10','2023-02-16 12:58:10',NULL),(1951,8437,40794,48411,3,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',80000.00,NULL,NULL,1,'2023-02-16 13:01:36','2023-02-16 13:07:13','2023-02-16 13:07:13'),(1952,8437,40794,48411,3,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',70000.00,NULL,NULL,1,'2023-02-16 13:01:36','2023-02-16 13:07:43','2023-02-16 13:07:43'),(1953,8437,40794,48411,2,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',301084.30,NULL,NULL,1,'2023-02-16 13:01:45','2023-02-16 13:01:45',NULL),(1954,8437,40794,48411,2,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',544726.88,NULL,NULL,1,'2023-02-16 13:01:46','2023-02-16 13:01:46',NULL),(1955,8437,40794,48411,3,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',80000.00,NULL,NULL,1,'2023-02-16 13:07:13','2023-02-16 13:07:13',NULL),(1956,8437,40794,48411,3,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',70000.00,NULL,NULL,1,'2023-02-16 13:07:43','2023-02-16 13:07:43',NULL),(1957,8433,40724,7530,3,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',15306.40,NULL,NULL,1,'2023-02-16 13:19:03','2023-05-08 11:12:30','2023-05-08 11:12:30'),(1958,8433,40724,7530,3,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',9901.20,NULL,NULL,1,'2023-02-16 13:22:23','2023-05-08 11:12:01','2023-05-08 11:12:01'),(1959,8433,40724,7530,3,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5000.00,NULL,NULL,1,'2023-02-16 13:24:00','2023-05-08 11:11:44','2023-05-08 11:11:44'),(1960,8433,40724,7530,3,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',4669.40,NULL,NULL,1,'2023-02-16 13:25:53','2023-05-08 11:11:19','2023-05-08 11:11:19'),(1961,8433,40724,7530,3,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',5000.00,NULL,NULL,1,'2023-02-16 13:27:24','2023-03-30 11:26:03','2023-03-30 11:26:03'),(1962,8433,40799,57501,3,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8193.93,NULL,NULL,1,'2023-02-16 13:40:35','2023-02-16 13:40:35',NULL),(1963,8437,40874,130218,3,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',520.00,NULL,NULL,1,'2023-02-16 13:54:25','2023-02-16 13:54:25',NULL),(1964,8437,40874,130218,3,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',7028.93,NULL,NULL,1,'2023-02-16 14:01:03','2023-02-16 14:01:03',NULL),(1965,8437,40874,130218,3,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6503.21,NULL,NULL,1,'2023-02-16 14:03:03','2023-02-16 14:03:03',NULL),(1966,8437,40874,130218,3,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',11465.15,NULL,NULL,1,'2023-02-16 14:04:36','2023-02-16 14:04:36',NULL),(1967,8437,40875,131733,3,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',4589.99,NULL,NULL,1,'2023-02-16 14:09:48','2023-02-16 14:09:48',NULL),(1968,8437,40875,131733,3,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',163.00,NULL,NULL,1,'2023-02-16 14:09:48','2023-04-05 11:31:18','2023-04-05 11:31:18'),(1969,8437,40875,131733,3,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',230.00,NULL,NULL,1,'2023-02-16 14:09:48','2023-04-05 09:39:47','2023-04-05 09:39:47');
INSERT INTO `balance_libro` VALUES (1970,8437,40875,131733,3,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',68.00,NULL,NULL,1,'2023-02-16 14:09:48','2023-04-05 11:31:44','2023-04-05 11:31:44'),(1971,8437,40875,131733,3,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',92109.33,NULL,NULL,1,'2023-02-16 14:09:48','2023-02-16 14:09:48',NULL),(1972,8437,40875,131733,3,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8747.11,NULL,NULL,1,'2023-02-16 14:09:49','2023-04-05 10:41:11','2023-04-05 10:41:11'),(1973,8437,40875,131733,3,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',48000.00,NULL,NULL,1,'2023-02-16 14:09:49','2023-04-05 10:52:46','2023-04-05 10:52:46'),(1974,8437,40875,131733,3,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5528.42,NULL,NULL,1,'2023-02-16 14:09:49','2023-04-05 10:40:10','2023-04-05 10:40:10'),(1975,8437,40875,131733,3,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',32772.98,NULL,NULL,1,'2023-02-16 14:09:49','2023-04-05 10:42:41','2023-04-05 10:42:41'),(1976,8437,40875,131733,3,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',15000.00,NULL,NULL,1,'2023-02-16 14:09:49','2023-04-05 11:32:16','2023-04-05 11:32:16'),(1977,8437,40875,131733,3,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1190.00,NULL,NULL,1,'2023-02-16 14:09:49','2023-02-16 14:09:49',NULL),(1978,8437,40875,131733,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8710.11,NULL,NULL,1,'2023-02-16 14:09:49','2023-04-05 10:43:53','2023-04-05 10:43:53'),(1979,8437,40875,131733,3,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',8342.80,NULL,NULL,1,'2023-02-16 14:09:49','2023-04-05 10:45:38','2023-04-05 10:45:38'),(1980,8437,40875,131733,3,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',9383.16,NULL,NULL,1,'2023-02-16 14:09:49','2023-04-05 10:46:49','2023-04-05 10:46:49'),(1981,8437,40875,131733,3,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',104.13,NULL,NULL,1,'2023-02-16 14:09:49','2023-04-05 10:52:03','2023-04-05 10:52:03'),(1982,8437,40875,131733,3,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',520.66,NULL,NULL,1,'2023-02-16 14:09:49','2023-04-05 10:51:15','2023-04-05 10:51:15'),(1983,8437,40875,131733,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1345.00,NULL,NULL,1,'2023-02-16 14:09:49','2023-04-05 11:33:00','2023-04-05 11:33:00'),(1984,8437,40875,131733,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',10424.24,NULL,NULL,1,'2023-02-16 14:09:49','2023-04-05 10:47:55','2023-04-05 10:47:55'),(1985,8437,40875,131733,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',7825.89,NULL,NULL,1,'2023-02-16 14:09:49','2023-04-05 10:49:07','2023-04-05 10:49:07'),(1986,8437,40875,131733,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',16000.99,NULL,NULL,1,'2023-02-16 14:09:50','2023-04-05 10:50:17','2023-04-05 10:50:17'),(1987,8437,40875,131733,3,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',7900.01,NULL,NULL,1,'2023-02-16 14:09:50','2023-02-16 14:09:50',NULL),(1988,8437,40875,131733,3,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',8750.00,NULL,NULL,1,'2023-02-16 14:09:50','2023-02-16 14:09:50',NULL);
INSERT INTO `balance_libro` VALUES (1989,8437,40875,131733,3,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',96418.29,NULL,NULL,1,'2023-02-16 14:09:50','2023-02-16 14:09:50',NULL),(1990,8437,40875,131733,2,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',206220.30,NULL,NULL,1,'2023-02-16 14:10:08','2023-02-16 14:10:08',NULL),(1991,8437,40875,131733,2,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',221163.80,NULL,NULL,1,'2023-02-16 14:10:09','2023-02-16 14:10:09',NULL),(1992,8437,40875,131733,2,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',70238.08,NULL,NULL,1,'2023-02-16 14:10:09','2023-02-16 14:10:09',NULL),(1993,8437,40875,131733,2,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',81000.74,NULL,NULL,1,'2023-02-16 14:10:09','2023-02-16 14:10:09',NULL),(1994,8437,40875,131733,2,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',46357.52,NULL,NULL,1,'2023-02-16 14:10:09','2023-02-16 14:10:09',NULL),(1995,8437,40875,131733,3,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4690.45,NULL,NULL,1,'2023-02-17 09:23:23','2023-02-17 09:23:23',NULL),(1996,8437,40875,131733,3,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8102.62,NULL,NULL,1,'2023-02-17 09:26:58','2023-02-17 09:26:58',NULL),(1997,8437,40875,131733,3,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',10000.85,NULL,NULL,1,'2023-02-17 09:29:05','2023-02-17 09:29:05',NULL),(1998,8437,40875,131733,3,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5000.78,NULL,NULL,1,'2023-02-17 09:33:51','2023-02-17 09:33:51',NULL),(1999,8437,40875,131733,3,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1110.68,NULL,NULL,1,'2023-02-17 09:38:59','2023-02-17 09:38:59',NULL),(2000,8437,40875,131733,3,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5000.60,NULL,NULL,1,'2023-02-17 09:40:06','2023-02-17 09:40:06',NULL),(2001,8437,40875,131733,3,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',7088.38,NULL,NULL,1,'2023-02-17 09:44:10','2023-02-17 09:44:10',NULL),(2002,8437,40875,131733,3,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1229.47,NULL,NULL,1,'2023-02-17 09:49:08','2023-02-17 09:49:08',NULL),(2003,8433,41421,754392,3,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',250.28,NULL,NULL,1,'2023-02-17 09:49:32','2023-04-14 00:02:44','2023-04-14 00:02:44'),(2004,8433,41421,754392,3,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',7400.99,NULL,NULL,1,'2023-02-17 09:50:36','2023-04-13 23:52:39','2023-04-13 23:52:39'),(2005,8433,41421,754392,3,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4800.00,NULL,NULL,1,'2023-02-17 09:51:06','2023-04-13 23:50:49','2023-04-13 23:50:49'),(2006,8433,41421,754392,3,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',88.50,NULL,NULL,1,'2023-02-17 09:52:03','2023-04-13 23:20:53','2023-04-13 23:20:53'),(2007,8433,41421,754392,3,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8702.19,NULL,NULL,1,'2023-02-17 09:53:01','2023-04-13 23:46:22','2023-04-13 23:46:22'),(2008,8433,41421,754392,3,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',111663.18,NULL,NULL,1,'2023-02-17 09:54:28','2023-04-13 23:04:42','2023-04-13 23:04:42');
INSERT INTO `balance_libro` VALUES (2009,8437,41145,528663,3,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',18000.00,NULL,NULL,1,'2023-02-17 10:03:03','2023-04-17 10:14:59','2023-04-17 10:14:59'),(2010,8437,41145,528663,3,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',228305.61,NULL,NULL,1,'2023-02-17 10:03:03','2023-02-17 10:03:03',NULL),(2011,8437,41145,528663,3,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',87433.27,NULL,NULL,1,'2023-02-17 10:03:03','2023-02-17 10:03:03',NULL),(2012,8437,41145,528663,3,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',187187.00,NULL,NULL,1,'2023-02-17 10:03:03','2023-04-17 10:21:41','2023-04-17 10:21:41'),(2013,8437,41145,528663,3,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',167385.12,NULL,NULL,1,'2023-02-17 10:03:03','2023-02-17 10:03:03',NULL),(2014,8437,41145,528663,3,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',292684.74,NULL,NULL,1,'2023-02-17 10:03:03','2023-02-17 10:03:03',NULL),(2015,8437,41145,528663,3,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',101102.17,NULL,NULL,1,'2023-02-17 10:03:03','2023-04-17 10:46:55','2023-04-17 10:46:55'),(2016,8437,41145,528663,3,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',768.11,NULL,NULL,1,'2023-02-17 10:03:03','2023-02-17 10:03:03',NULL),(2017,8437,41145,528663,3,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',17713.04,NULL,NULL,1,'2023-02-17 10:03:03','2023-02-17 10:03:03',NULL),(2018,8437,41145,528663,3,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',197621.46,NULL,NULL,1,'2023-02-17 10:03:03','2023-02-17 10:03:03',NULL),(2019,8437,41145,528663,3,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',196042.94,NULL,NULL,1,'2023-02-17 10:03:03','2023-04-17 10:47:35','2023-04-17 10:47:35'),(2020,8437,41145,528663,3,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',111026.19,NULL,NULL,1,'2023-02-17 10:03:03','2023-04-17 10:51:26','2023-04-17 10:51:26'),(2021,8437,41145,528663,3,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',109439.48,NULL,NULL,1,'2023-02-17 10:03:03','2023-04-17 10:50:56','2023-04-17 10:50:56'),(2022,8437,41145,528663,3,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',218160.04,NULL,NULL,1,'2023-02-17 10:03:03','2023-02-17 10:03:03',NULL),(2023,8437,41145,528663,3,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',83073.90,NULL,NULL,1,'2023-02-17 10:03:03','2023-02-17 10:03:03',NULL),(2024,8437,41145,528663,3,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',30630.60,NULL,NULL,1,'2023-02-17 10:03:03','2023-02-17 10:03:03',NULL),(2025,8437,41145,528663,3,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',104539.27,NULL,NULL,1,'2023-02-17 10:03:03','2023-04-17 10:48:14','2023-04-17 10:48:14'),(2026,8437,41145,528663,3,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',280998.92,NULL,NULL,1,'2023-02-17 10:03:03','2023-02-17 10:03:03',NULL),(2027,8437,41145,528663,3,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',183506.52,NULL,NULL,1,'2023-02-17 10:03:03','2023-02-17 10:03:03',NULL),(2028,8437,41145,528663,3,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',100354.31,NULL,NULL,1,'2023-02-17 10:03:03','2023-04-17 10:48:43','2023-04-17 10:48:43');
INSERT INTO `balance_libro` VALUES (2029,8437,41145,528663,3,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',4059.99,NULL,NULL,1,'2023-02-17 10:03:04','2023-02-17 10:03:04',NULL),(2030,8437,41145,528663,3,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',4059.99,NULL,NULL,1,'2023-02-17 10:03:04','2023-02-17 10:03:04',NULL),(2031,8437,41145,528663,3,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',182637.49,NULL,NULL,1,'2023-02-17 10:03:04','2023-04-17 10:51:56','2023-04-17 10:51:56'),(2032,8437,41145,528663,3,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',498.90,NULL,NULL,1,'2023-02-17 10:03:04','2023-02-17 10:03:04',NULL),(2033,8437,41145,528663,3,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',80156.70,NULL,NULL,1,'2023-02-17 10:03:04','2023-02-17 10:03:04',NULL),(2034,8437,41145,528663,3,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',169885.03,NULL,NULL,1,'2023-02-17 10:03:04','2023-02-17 10:03:04',NULL),(2035,8437,41145,528663,3,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',101935.35,NULL,NULL,1,'2023-02-17 10:03:04','2023-04-17 10:52:25','2023-04-17 10:52:25'),(2036,8437,41145,528663,3,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',212253.10,NULL,NULL,1,'2023-02-17 10:03:04','2023-02-17 10:03:04',NULL),(2037,8437,41145,528663,3,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',169617.90,NULL,NULL,1,'2023-02-17 10:03:04','2023-04-17 10:52:54','2023-04-17 10:52:54'),(2038,8437,41145,528663,3,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',593761.77,NULL,NULL,1,'2023-02-17 10:03:04','2023-02-17 10:03:04',NULL),(2039,8437,41145,528663,3,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3624.99,NULL,NULL,1,'2023-02-17 10:03:04','2023-02-17 10:03:04',NULL),(2040,8437,41145,528663,3,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',25910.69,NULL,NULL,1,'2023-02-17 10:03:04','2023-02-17 10:03:04',NULL),(2041,8437,41145,528663,3,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',139395.75,NULL,NULL,1,'2023-02-17 10:03:04','2023-02-17 10:03:04',NULL),(2042,8437,41145,528663,3,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',189571.04,NULL,NULL,1,'2023-02-17 10:03:04','2023-02-17 10:03:04',NULL),(2043,8437,41145,528663,3,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',576539.00,NULL,NULL,1,'2023-02-17 10:03:04','2023-02-17 10:03:04',NULL),(2044,8437,41145,528663,3,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',89721.71,NULL,NULL,1,'2023-02-17 10:03:04','2023-04-17 10:53:44','2023-04-17 10:53:44'),(2045,8437,41145,528663,3,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',176290.31,NULL,NULL,1,'2023-02-17 10:03:04','2023-04-17 10:50:08','2023-04-17 10:50:08'),(2046,8437,41145,528663,2,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1303900.00,NULL,NULL,1,'2023-02-17 10:03:30','2023-02-17 10:03:30',NULL),(2047,8437,41145,528663,2,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1955850.00,NULL,NULL,1,'2023-02-17 10:03:30','2023-02-17 10:03:30',NULL),(2048,8437,41145,528663,2,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1695070.00,NULL,NULL,1,'2023-02-17 10:03:30','2023-02-17 10:03:30',NULL);
INSERT INTO `balance_libro` VALUES (2049,8433,40781,28719,3,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3000.04,NULL,NULL,1,'2023-02-17 10:05:35','2023-02-17 10:05:35',NULL),(2050,8433,40781,28719,3,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',6319.55,NULL,NULL,1,'2023-02-17 10:08:30','2023-04-24 11:05:14','2023-04-24 11:05:14'),(2051,8437,41145,528663,3,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',135483.76,NULL,NULL,1,'2023-02-17 10:11:32','2023-04-17 10:15:44','2023-04-17 10:15:44'),(2052,8433,40781,28719,3,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2999.94,NULL,NULL,1,'2023-02-17 10:12:44','2023-02-17 10:12:44',NULL),(2053,8433,40781,28719,3,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3001.39,NULL,NULL,1,'2023-02-17 10:15:42','2023-02-17 10:15:42',NULL),(2054,8437,40793,46896,3,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',91456.32,NULL,NULL,1,'2023-02-17 10:17:02','2023-02-17 10:17:02',NULL),(2055,8437,40793,46896,3,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',74470.45,NULL,NULL,1,'2023-02-17 10:17:02','2023-02-17 10:17:02',NULL),(2056,8433,40781,28719,3,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',5796.07,NULL,NULL,1,'2023-02-17 10:17:58','2023-02-17 10:17:58',NULL),(2057,8433,40781,28719,3,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3000.05,NULL,NULL,1,'2023-02-17 10:19:43','2023-02-17 10:19:43',NULL),(2058,8437,40793,46896,3,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',18438.23,NULL,NULL,1,'2023-02-17 10:21:59','2023-02-17 10:21:59',NULL),(2059,8433,40781,28719,3,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',3062.83,NULL,NULL,1,'2023-02-17 10:23:04','2023-02-17 10:23:04',NULL),(2060,8433,40781,28719,3,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2999.94,NULL,NULL,1,'2023-02-17 10:24:31','2023-02-17 10:24:31',NULL),(2061,8437,40903,174153,3,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',18600.00,NULL,NULL,1,'2023-02-17 10:43:16','2023-02-17 10:43:16',NULL),(2062,8437,40903,174153,3,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',4500.00,NULL,NULL,1,'2023-02-17 10:43:16','2023-02-17 10:43:16',NULL),(2063,8437,40883,143853,3,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2999.99,NULL,NULL,1,'2023-02-17 10:50:54','2023-02-17 10:50:54',NULL),(2064,8433,40876,133248,3,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',11300.00,NULL,NULL,1,'2023-02-17 10:53:30','2023-05-08 12:13:50','2023-05-08 12:13:50'),(2065,8433,40876,133248,3,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',11300.00,NULL,NULL,1,'2023-02-17 10:53:31','2023-05-08 12:13:16','2023-05-08 12:13:16'),(2066,8433,40876,133248,3,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',13636.24,NULL,NULL,1,'2023-02-17 10:53:31','2023-02-17 10:57:06','2023-02-17 10:57:06'),(2067,8433,40876,133248,3,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4876.58,NULL,NULL,1,'2023-02-17 10:53:31','2023-02-17 10:58:00','2023-02-17 10:58:00'),(2068,8433,40876,133248,3,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',211799.00,NULL,NULL,1,'2023-02-17 10:53:31','2023-05-08 12:11:38','2023-05-08 12:11:38');
INSERT INTO `balance_libro` VALUES (2069,8433,40876,133248,3,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',9859.80,NULL,NULL,1,'2023-02-17 10:53:31','2023-02-17 10:59:05','2023-02-17 10:59:05'),(2070,8433,40876,133248,3,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',900.00,NULL,NULL,1,'2023-02-17 10:53:31','2023-05-08 13:33:26','2023-05-08 13:33:26'),(2071,8433,40876,133248,3,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',13636.24,NULL,NULL,1,'2023-02-17 10:57:06','2023-02-17 10:57:06',NULL),(2072,8433,40876,133248,3,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',4876.58,NULL,NULL,1,'2023-02-17 10:58:00','2023-02-17 10:58:00',NULL),(2073,8433,40876,133248,3,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',9859.80,NULL,NULL,1,'2023-02-17 10:59:05','2023-02-17 10:59:05',NULL),(2074,8437,40878,136278,3,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',16143.62,NULL,NULL,1,'2023-02-17 11:01:49','2023-02-17 11:16:50','2023-02-17 11:16:50'),(2075,8437,40878,136278,3,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',30000.00,NULL,NULL,1,'2023-02-17 11:01:49','2023-02-17 11:16:46','2023-02-17 11:16:46'),(2076,8437,40878,136278,3,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',18000.00,NULL,NULL,1,'2023-02-17 11:01:49','2023-02-17 11:16:42','2023-02-17 11:16:42'),(2077,8437,40878,136278,3,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',13146.34,NULL,NULL,1,'2023-02-17 11:01:49','2023-02-17 11:16:36','2023-02-17 11:16:36'),(2078,8437,40878,136278,3,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',26625.50,NULL,NULL,1,'2023-02-17 11:01:49','2023-02-17 11:16:29','2023-02-17 11:16:29'),(2079,8437,40878,136278,3,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5944.00,NULL,NULL,1,'2023-02-17 11:01:49','2023-02-17 11:16:24','2023-02-17 11:16:24'),(2080,8437,40878,136278,3,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1394.63,NULL,NULL,1,'2023-02-17 11:01:49','2023-02-17 11:01:49',NULL),(2081,8437,40878,136278,3,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1170.00,NULL,NULL,1,'2023-02-17 11:01:49','2023-02-17 11:16:19','2023-02-17 11:16:19'),(2082,8437,40878,136278,3,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',24500.00,NULL,NULL,1,'2023-02-17 11:01:49','2023-02-17 11:16:15','2023-02-17 11:16:15'),(2083,8437,40878,136278,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9704.99,NULL,NULL,1,'2023-02-17 11:01:49','2023-02-17 11:15:38','2023-02-17 11:15:38'),(2084,8437,40878,136278,3,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9896.03,NULL,NULL,1,'2023-02-17 11:01:50','2023-02-17 11:16:10','2023-02-17 11:16:10'),(2085,8437,40878,136278,3,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13355.34,NULL,NULL,1,'2023-02-17 11:01:50','2023-02-17 11:16:05','2023-02-17 11:16:05'),(2086,8437,40878,136278,3,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13131.95,NULL,NULL,1,'2023-02-17 11:01:50','2023-02-17 11:16:00','2023-02-17 11:16:00'),(2087,8437,40878,136278,3,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17355.34,NULL,NULL,1,'2023-02-17 11:01:50','2023-02-17 11:15:55','2023-02-17 11:15:55');
INSERT INTO `balance_libro` VALUES (2088,8437,40878,136278,3,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9896.03,NULL,NULL,1,'2023-02-17 11:01:50','2023-02-17 11:15:50','2023-02-17 11:15:50'),(2089,8437,40878,136278,3,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',182520.23,NULL,NULL,1,'2023-02-17 11:01:50','2023-02-17 11:01:50',NULL),(2090,8433,40876,133248,2,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',318887.00,NULL,NULL,1,'2023-02-17 11:01:54','2023-02-17 11:01:54',NULL),(2091,8433,40876,133248,2,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',700405.00,NULL,NULL,1,'2023-02-17 11:01:54','2023-02-17 11:01:54',NULL),(2092,8433,40876,133248,2,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',10086.00,NULL,NULL,1,'2023-02-17 11:01:54','2023-02-17 11:01:54',NULL),(2093,8433,40876,133248,2,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',30000.00,NULL,NULL,1,'2023-02-17 11:01:54','2023-02-17 11:01:54',NULL),(2094,8433,40876,133248,2,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',600347.00,NULL,NULL,1,'2023-02-17 11:01:54','2023-02-17 11:01:54',NULL),(2131,8437,40878,136278,2,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',16143.62,NULL,NULL,1,'2023-02-17 11:21:41','2023-02-17 11:25:22','2023-02-17 11:25:22'),(2132,8437,40878,136278,2,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',30000.00,NULL,NULL,1,'2023-02-17 11:21:41','2023-02-17 11:25:18','2023-02-17 11:25:18'),(2133,8437,40878,136278,2,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',18000.00,NULL,NULL,1,'2023-02-17 11:21:41','2023-02-17 11:25:14','2023-02-17 11:25:14'),(2134,8437,40878,136278,2,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',13146.34,NULL,NULL,1,'2023-02-17 11:21:41','2023-02-17 11:25:10','2023-02-17 11:25:10'),(2135,8437,40878,136278,2,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',26625.50,NULL,NULL,1,'2023-02-17 11:21:41','2023-02-17 11:25:06','2023-02-17 11:25:06'),(2136,8437,40878,136278,2,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',5944.00,NULL,NULL,1,'2023-02-17 11:21:42','2023-02-17 11:24:18','2023-02-17 11:24:18'),(2137,8437,40878,136278,2,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1394.63,NULL,NULL,1,'2023-02-17 11:21:42','2023-02-17 11:25:02','2023-02-17 11:25:02'),(2138,8437,40878,136278,2,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1170.00,NULL,NULL,1,'2023-02-17 11:21:42','2023-02-17 11:24:58','2023-02-17 11:24:58'),(2139,8437,40878,136278,2,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',24500.00,NULL,NULL,1,'2023-02-17 11:21:42','2023-02-17 11:24:54','2023-02-17 11:24:54'),(2140,8437,40878,136278,2,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9704.99,NULL,NULL,1,'2023-02-17 11:21:42','2023-02-17 11:24:51','2023-02-17 11:24:51'),(2141,8437,40878,136278,2,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9896.03,NULL,NULL,1,'2023-02-17 11:21:42','2023-02-17 11:24:47','2023-02-17 11:24:47'),(2142,8437,40878,136278,2,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13355.34,NULL,NULL,1,'2023-02-17 11:21:42','2023-02-17 11:24:40','2023-02-17 11:24:40');
INSERT INTO `balance_libro` VALUES (2143,8437,40878,136278,2,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13131.95,NULL,NULL,1,'2023-02-17 11:21:42','2023-02-17 11:24:35','2023-02-17 11:24:35'),(2144,8437,40878,136278,2,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17355.34,NULL,NULL,1,'2023-02-17 11:21:42','2023-02-17 11:24:30','2023-02-17 11:24:30'),(2145,8437,40878,136278,2,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9896.03,NULL,NULL,1,'2023-02-17 11:21:43','2023-02-17 11:24:26','2023-02-17 11:24:26'),(2146,8437,40878,136278,2,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',182520.23,NULL,NULL,1,'2023-02-17 11:21:43','2023-02-17 11:24:22','2023-02-17 11:24:22'),(2147,8433,40876,133248,3,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',7047.72,NULL,NULL,1,'2023-02-22 11:07:07','2023-05-08 12:09:40','2023-05-08 12:09:40'),(2148,8433,40876,133248,3,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',6500.60,NULL,NULL,1,'2023-02-22 11:09:13','2023-05-08 12:09:12','2023-05-08 12:09:12'),(2149,8433,40876,133248,3,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',7902.82,NULL,NULL,1,'2023-02-22 11:12:46','2023-05-08 12:08:40','2023-05-08 12:08:40'),(2150,8436,40801,60531,3,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',60258.00,NULL,NULL,1,'2023-02-22 11:14:38','2023-02-22 11:14:38',NULL),(2151,8436,40801,60531,3,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',20812.00,NULL,NULL,1,'2023-02-22 11:14:38','2023-02-22 11:14:38',NULL),(2152,8436,40801,60531,3,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',18777.99,NULL,NULL,1,'2023-02-22 11:14:39','2023-02-22 11:14:39',NULL),(2153,8436,40801,60531,3,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',89818.91,NULL,NULL,1,'2023-02-22 11:14:39','2023-02-22 11:14:39',NULL),(2154,8436,40801,60531,3,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',18150.00,NULL,NULL,1,'2023-02-22 11:14:39','2023-02-22 11:14:39',NULL),(2155,8436,40801,60531,3,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5318.58,NULL,NULL,1,'2023-02-22 11:14:39','2023-02-22 11:14:39',NULL),(2156,8436,40801,60531,3,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',11397.00,NULL,NULL,1,'2023-02-22 11:14:39','2023-02-22 11:14:39',NULL),(2157,8436,40801,60531,3,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',163809.13,NULL,NULL,1,'2023-02-22 11:14:39','2023-02-22 11:14:39',NULL),(2158,8436,40801,60531,3,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',5873.11,NULL,NULL,1,'2023-02-22 11:14:39','2023-02-22 11:14:39',NULL),(2159,8436,40801,60531,3,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',28200.00,NULL,NULL,1,'2023-02-22 11:14:39','2023-02-22 11:14:39',NULL),(2160,8436,40801,60531,3,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1862.00,NULL,NULL,1,'2023-02-22 11:14:39','2023-02-22 11:14:39',NULL),(2161,8436,40801,60531,3,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',6990.00,NULL,NULL,1,'2023-02-22 11:14:39','2023-02-22 11:14:39',NULL),(2162,8436,40801,60531,3,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1400.00,NULL,NULL,1,'2023-02-22 11:14:39','2023-02-22 11:14:39',NULL);
INSERT INTO `balance_libro` VALUES (2163,8436,40801,60531,3,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',11376.90,NULL,NULL,1,'2023-02-22 11:14:40','2023-02-22 11:14:40',NULL),(2164,8436,40801,60531,3,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',11376.90,NULL,NULL,1,'2023-02-22 11:14:40','2023-02-22 11:14:40',NULL),(2165,8436,40801,60531,3,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',11376.90,NULL,NULL,1,'2023-02-22 11:14:40','2023-02-22 11:14:40',NULL),(2166,8436,40801,60531,3,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12032.75,NULL,NULL,1,'2023-02-22 11:14:40','2023-02-22 11:14:40',NULL),(2167,8436,40801,60531,3,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10574.25,NULL,NULL,1,'2023-02-22 11:14:40','2023-02-22 11:14:40',NULL),(2168,8436,40801,60531,3,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',11376.90,NULL,NULL,1,'2023-02-22 11:14:40','2023-02-22 11:14:40',NULL),(2169,8436,40801,60531,3,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',10584.66,NULL,NULL,1,'2023-02-22 11:14:40','2023-02-22 11:14:40',NULL),(2170,8436,40801,60531,3,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',92091.65,NULL,NULL,1,'2023-02-22 11:14:40','2023-02-22 11:14:40',NULL),(2171,8436,40801,60531,3,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',29744.22,NULL,NULL,1,'2023-02-22 11:14:40','2023-02-22 11:14:40',NULL),(2172,8436,40801,60531,3,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4925.24,NULL,NULL,1,'2023-02-22 11:14:40','2023-02-22 11:14:40',NULL),(2173,8436,40801,60531,3,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5153.74,NULL,NULL,1,'2023-02-22 11:14:40','2023-02-22 11:14:40',NULL),(2174,8436,40801,60531,3,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1443.99,NULL,NULL,1,'2023-02-22 11:14:40','2023-02-22 11:14:40',NULL),(2175,8436,40801,60531,3,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',20630.35,NULL,NULL,1,'2023-02-22 11:14:40','2023-02-22 11:14:40',NULL),(2176,8436,40801,60531,3,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',18249.00,NULL,NULL,1,'2023-02-22 11:14:41','2023-02-22 11:14:41',NULL),(2177,8436,40801,60531,3,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',76573.92,NULL,NULL,1,'2023-02-22 11:14:41','2023-02-22 11:14:41',NULL),(2178,8436,40801,60531,3,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',4169.72,NULL,NULL,1,'2023-02-22 11:14:41','2023-02-22 11:14:41',NULL),(2179,8436,40801,60531,3,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3775.92,NULL,NULL,1,'2023-02-22 11:14:41','2023-02-22 11:14:41',NULL),(2180,8436,40801,60531,3,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',26670.00,NULL,NULL,1,'2023-02-22 11:14:41','2023-02-22 11:14:41',NULL),(2181,8436,40801,60531,3,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',26670.00,NULL,NULL,1,'2023-02-22 11:14:41','2023-02-22 11:14:41',NULL),(2182,8436,40801,60531,3,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',119221.25,NULL,NULL,1,'2023-02-22 11:14:41','2023-02-22 11:14:41',NULL),(2183,8436,40801,60531,3,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1441437.00,NULL,NULL,1,'2023-02-22 11:14:41','2023-02-22 11:14:41',NULL);
INSERT INTO `balance_libro` VALUES (2184,8436,40801,60531,3,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',13335.00,NULL,NULL,1,'2023-02-22 11:14:41','2023-02-22 11:14:41',NULL),(2185,8436,40801,60531,3,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',13335.00,NULL,NULL,1,'2023-02-22 11:14:42','2023-02-22 11:14:42',NULL),(2186,8436,40801,60531,3,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',13335.00,NULL,NULL,1,'2023-02-22 11:14:42','2023-02-22 11:14:42',NULL),(2187,8436,40801,60531,3,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',196350.00,NULL,NULL,1,'2023-02-22 11:14:42','2023-02-22 11:14:42',NULL),(2188,8436,40801,60531,3,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',14968.30,NULL,NULL,1,'2023-02-22 11:14:42','2023-02-22 11:14:42',NULL),(2189,8436,40801,60531,3,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',7810.00,NULL,NULL,1,'2023-02-22 11:14:42','2023-02-22 11:14:42',NULL),(2190,8436,40801,60531,3,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3027.06,NULL,NULL,1,'2023-02-22 11:14:42','2023-02-22 11:14:42',NULL),(2191,8436,40801,60531,3,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',12625.14,NULL,NULL,1,'2023-02-22 11:14:42','2023-02-22 11:14:42',NULL),(2192,8436,40801,60531,3,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',12625.14,NULL,NULL,1,'2023-02-22 11:14:42','2023-02-22 11:14:42',NULL),(2193,8436,40801,60531,3,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',11900.00,NULL,NULL,1,'2023-02-22 11:14:42','2023-02-22 11:14:42',NULL),(2194,8436,40801,60531,3,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',6052.96,NULL,NULL,1,'2023-02-22 11:14:42','2023-02-22 11:14:42',NULL),(2195,8436,40801,60531,3,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',618858.24,NULL,NULL,1,'2023-02-22 11:14:42','2023-02-22 11:14:42',NULL),(2196,8436,40801,60531,3,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1337339.79,NULL,NULL,1,'2023-02-22 11:14:42','2023-02-22 11:14:42',NULL),(2197,8436,40801,60531,3,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',653871.68,NULL,NULL,1,'2023-02-22 11:14:43','2023-02-22 11:14:43',NULL),(2198,8436,40801,60531,3,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',686926.32,NULL,NULL,1,'2023-02-22 11:14:43','2023-02-22 11:14:43',NULL),(2199,8436,40801,60531,3,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',344829.36,NULL,NULL,1,'2023-02-22 11:14:43','2023-02-22 11:14:43',NULL),(2200,8436,40801,60531,3,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',326364.48,NULL,NULL,1,'2023-02-22 11:14:43','2023-02-22 11:14:43',NULL),(2201,8436,40801,60531,3,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',702195.34,NULL,NULL,1,'2023-02-22 11:14:43','2023-02-22 11:14:43',NULL),(2202,8436,40801,60531,3,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',369456.78,NULL,NULL,1,'2023-02-22 11:14:43','2023-02-22 11:14:43',NULL),(2203,8436,40801,60531,3,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',414322.80,NULL,NULL,1,'2023-02-22 11:14:43','2023-02-22 11:14:43',NULL);
INSERT INTO `balance_libro` VALUES (2204,8436,40801,60531,3,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',10550.00,NULL,NULL,1,'2023-02-22 11:14:44','2023-02-22 11:14:44',NULL),(2205,8436,40801,60531,3,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',10403.99,NULL,NULL,1,'2023-02-22 11:14:44','2023-02-22 11:14:44',NULL),(2206,8436,40801,60531,3,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1722.84,NULL,NULL,1,'2023-02-22 11:14:44','2023-02-22 11:14:44',NULL),(2207,8436,40801,60531,3,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',861.42,NULL,NULL,1,'2023-02-22 11:14:44','2023-02-22 11:14:44',NULL),(2208,8436,40801,60531,3,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',9458.58,NULL,NULL,1,'2023-02-22 11:14:44','2023-02-22 11:14:44',NULL),(2209,8436,40801,60531,3,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',12625.14,NULL,NULL,1,'2023-02-22 11:14:44','2023-02-22 11:14:44',NULL),(2210,8436,40801,60531,3,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4990.00,NULL,NULL,1,'2023-02-22 11:14:44','2023-02-22 11:14:44',NULL),(2211,8436,40801,60531,3,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',24756.75,NULL,NULL,1,'2023-02-22 11:14:44','2023-02-22 11:14:44',NULL),(2212,8436,40801,60531,3,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',43365.00,NULL,NULL,1,'2023-02-22 11:14:44','2023-02-22 11:14:44',NULL),(2213,8436,40801,60531,3,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',9116.48,NULL,NULL,1,'2023-02-22 11:14:44','2023-02-22 11:14:44',NULL),(2214,8436,40801,60531,3,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',604200.19,NULL,NULL,1,'2023-02-22 11:14:45','2023-02-22 11:14:45',NULL),(2215,8436,40801,60531,3,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2408.47,NULL,NULL,1,'2023-02-22 11:14:45','2023-02-22 11:14:45',NULL),(2216,8436,40801,60531,3,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',99864.17,NULL,NULL,1,'2023-02-22 11:14:45','2023-02-22 11:14:45',NULL),(2217,8436,40801,60531,3,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',935.62,NULL,NULL,1,'2023-02-22 11:14:45','2023-02-22 11:14:45',NULL),(2218,8436,40801,60531,3,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16799.00,NULL,NULL,1,'2023-02-22 11:14:45','2023-02-22 11:14:45',NULL),(2219,8436,40801,60531,3,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',178938.27,NULL,NULL,1,'2023-02-22 11:14:45','2023-02-22 11:14:45',NULL),(2220,8436,40801,60531,3,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16017.00,NULL,NULL,1,'2023-02-22 11:14:45','2023-02-22 11:14:45',NULL),(2221,8433,40876,133248,3,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',9767.11,NULL,NULL,1,'2023-02-22 11:19:04','2023-05-08 12:08:05','2023-05-08 12:08:05'),(2222,8433,40876,133248,3,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2234.34,NULL,NULL,1,'2023-02-22 11:21:19','2023-05-08 12:06:35','2023-05-08 12:06:35'),(2223,8433,40876,133248,3,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',7599.95,NULL,NULL,1,'2023-02-22 11:23:06','2023-05-08 12:05:48','2023-05-08 12:05:48');
INSERT INTO `balance_libro` VALUES (2224,8437,40796,51442,3,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',33510.34,NULL,NULL,1,'2023-02-22 11:40:33','2023-02-22 11:40:33',NULL),(2225,8437,40879,137793,3,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3990.00,NULL,NULL,1,'2023-02-22 12:28:14','2023-02-22 12:28:14',NULL),(2226,8437,40879,137793,3,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',58338.72,NULL,NULL,1,'2023-02-22 12:28:14','2023-02-22 12:28:14',NULL),(2227,8437,40879,137793,3,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',43430.00,NULL,NULL,1,'2023-02-22 12:28:14','2023-02-22 12:28:14',NULL),(2228,8437,40879,137793,3,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',34400.00,NULL,NULL,1,'2023-02-22 12:28:14','2023-02-22 12:28:14',NULL),(2229,8437,40879,137793,3,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',68921.60,NULL,NULL,1,'2023-02-22 12:28:14','2023-02-22 12:28:14',NULL),(2230,8437,40879,137793,3,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',70579.30,NULL,NULL,1,'2023-02-22 12:28:14','2023-02-22 12:28:14',NULL),(2231,8437,40879,137793,3,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',84461.63,NULL,NULL,1,'2023-02-22 12:28:14','2023-02-22 12:28:14',NULL),(2232,8437,40879,137793,3,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3000.00,NULL,NULL,1,'2023-02-22 12:28:14','2023-02-22 12:28:14',NULL),(2233,8437,40879,137793,3,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-02-22 12:28:14','2023-02-22 12:28:14',NULL),(2234,8437,40879,137793,3,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-02-22 12:28:14','2023-02-22 12:28:14',NULL),(2235,8433,40798,55986,3,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',44730.00,NULL,NULL,1,'2023-02-22 14:50:43','2023-04-12 09:39:04','2023-04-12 09:39:04'),(2236,8437,40804,65076,2,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',50000.00,NULL,NULL,1,'2023-02-23 09:46:11','2023-02-23 09:46:11',NULL),(2237,8437,40941,231723,7,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',118743.18,NULL,NULL,1,'2023-02-23 10:00:43','2023-02-23 10:00:43',NULL),(2238,8437,40941,231723,3,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',23430.64,NULL,NULL,1,'2023-02-23 10:03:37','2023-02-23 10:05:56','2023-02-23 10:05:56'),(2239,8437,40941,231723,3,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',93578.57,NULL,NULL,1,'2023-02-23 10:05:56','2023-02-23 10:05:56',NULL),(2240,8437,40941,231723,7,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',9960.47,NULL,NULL,1,'2023-02-23 10:11:01','2023-02-23 10:11:01',NULL),(2241,8437,40941,231723,7,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',44829.66,NULL,NULL,1,'2023-02-23 10:12:12','2023-02-23 10:12:12',NULL),(2242,8437,40941,231723,3,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',35329.05,NULL,NULL,1,'2023-02-23 10:17:46','2023-02-23 10:17:46',NULL),(2267,8437,40878,136278,2,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',338991.00,NULL,NULL,1,'2023-02-23 11:28:41','2023-02-23 11:28:41',NULL);
INSERT INTO `balance_libro` VALUES (2268,8437,40878,136278,2,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',277189.00,NULL,NULL,1,'2023-02-23 11:28:41','2023-02-23 11:28:41',NULL),(2269,8437,40878,136278,2,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',91392.00,NULL,NULL,1,'2023-02-23 11:28:41','2023-02-23 11:28:41',NULL),(2270,8437,40878,136278,2,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4000.00,NULL,NULL,1,'2023-02-23 11:28:41','2023-02-23 11:28:41',NULL),(2271,8437,40878,136278,2,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',4000.00,NULL,NULL,1,'2023-02-23 11:28:41','2023-02-23 11:28:41',NULL),(2272,8437,40878,136278,2,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',38628.10,NULL,NULL,1,'2023-02-23 11:28:41','2023-02-23 11:28:41',NULL),(2273,8437,40878,136278,2,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4000.00,NULL,NULL,1,'2023-02-23 11:28:41','2023-02-23 11:28:41',NULL),(2274,8437,40878,136278,2,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4000.00,NULL,NULL,1,'2023-02-23 11:28:41','2023-02-23 11:28:41',NULL),(2275,8437,40878,136278,2,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',4000.00,NULL,NULL,1,'2023-02-23 11:28:41','2023-02-23 11:28:41',NULL),(2276,8437,40878,136278,2,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',273293.00,NULL,NULL,1,'2023-02-23 11:28:41','2023-02-23 11:28:41',NULL),(2277,8437,40878,136278,2,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-02-23 11:28:41','2023-02-23 11:32:32','2023-02-23 11:32:32'),(2280,8437,40878,136278,2,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',360924.00,NULL,NULL,1,'2023-02-23 11:35:09','2023-02-23 11:35:09',NULL),(2281,8437,40878,136278,2,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4000.00,NULL,NULL,1,'2023-02-23 11:41:26','2023-02-23 11:41:26',NULL),(2282,8437,40878,136278,2,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4000.00,NULL,NULL,1,'2023-02-23 11:42:41','2023-02-23 11:42:41',NULL),(2283,8437,40878,136278,2,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',4000.00,NULL,NULL,1,'2023-02-23 11:43:12','2023-02-23 11:43:12',NULL),(2284,8433,40846,119617,3,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',160954.20,NULL,NULL,1,'2023-02-27 11:58:50','2023-02-27 11:58:50',NULL),(2285,8433,40846,119617,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',134478.00,NULL,NULL,1,'2023-02-27 11:58:50','2023-02-28 11:50:38','2023-02-28 11:50:38'),(2286,8433,40846,119617,3,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',7645.39,NULL,NULL,1,'2023-02-27 11:58:50','2023-02-27 11:58:50',NULL),(2287,8433,40846,119617,3,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',145502.50,NULL,NULL,1,'2023-02-27 11:58:50','2023-02-27 11:58:50',NULL),(2288,8433,40846,119617,3,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',145502.50,NULL,NULL,1,'2023-02-27 11:58:50','2023-02-27 11:58:50',NULL),(2289,8433,40846,119617,3,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',18150.00,NULL,NULL,1,'2023-02-27 11:58:50','2023-02-27 11:58:50',NULL);
INSERT INTO `balance_libro` VALUES (2290,8433,40846,119617,3,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',105814.97,NULL,NULL,1,'2023-02-27 11:58:50','2023-02-27 11:58:50',NULL),(2291,8433,40846,119617,3,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1800.00,NULL,NULL,1,'2023-02-27 11:58:50','2023-02-28 10:41:31','2023-02-28 10:41:31'),(2292,8433,40846,119617,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',6682.15,NULL,NULL,1,'2023-02-27 11:58:50','2023-02-28 13:57:51','2023-02-28 13:57:51'),(2293,8433,40846,119617,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1544.66,NULL,NULL,1,'2023-02-27 11:58:50','2023-02-28 10:39:18','2023-02-28 10:39:18'),(2294,8433,40846,119617,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',13424.28,NULL,NULL,1,'2023-02-27 11:58:50','2023-02-28 14:04:02','2023-02-28 14:04:02'),(2295,8433,40846,119617,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',100846.00,NULL,NULL,1,'2023-02-27 11:58:50','2023-03-18 21:38:52','2023-03-18 21:38:52'),(2296,8433,40846,119617,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8222.98,NULL,NULL,1,'2023-02-27 11:58:50','2023-03-16 10:05:15','2023-03-16 10:05:15'),(2297,8433,40846,119617,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8222.98,NULL,NULL,1,'2023-02-27 11:58:50','2023-03-16 10:04:43','2023-03-16 10:04:43'),(2298,8433,40846,119617,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',78615.71,NULL,NULL,1,'2023-02-27 11:58:51','2023-03-10 19:14:31','2023-03-10 19:14:31'),(2299,8433,40846,119617,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',89000.00,NULL,NULL,1,'2023-02-27 11:58:51','2023-02-28 13:53:33','2023-02-28 13:53:33'),(2300,8433,40846,119617,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',500.00,NULL,NULL,1,'2023-02-27 11:58:51','2023-02-28 10:34:12','2023-02-28 10:34:12'),(2301,8433,40846,119617,3,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1700.00,NULL,NULL,1,'2023-02-27 11:58:51','2023-02-27 11:58:51',NULL),(2302,8433,40846,119617,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',398.18,NULL,NULL,1,'2023-02-27 11:58:51','2023-03-18 21:26:46','2023-03-18 21:26:46'),(2303,8433,40846,119617,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1275.45,NULL,NULL,1,'2023-02-27 11:58:51','2023-02-28 10:37:38','2023-02-28 10:37:38'),(2304,8433,40846,119617,3,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',23375.00,NULL,NULL,1,'2023-02-27 11:58:51','2023-02-28 13:42:44','2023-02-28 13:42:44'),(2305,8433,40846,119617,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',25625.00,NULL,NULL,1,'2023-02-27 11:58:51','2023-02-28 13:43:45','2023-02-28 13:43:45'),(2306,8433,40846,119617,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',18583.50,NULL,NULL,1,'2023-02-27 11:58:51','2023-03-10 19:19:20','2023-03-10 19:19:20'),(2307,8433,40846,119617,3,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',7500.00,NULL,NULL,1,'2023-02-27 11:58:51','2023-02-27 11:58:51',NULL),(2308,8433,40846,119617,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',15000.01,NULL,NULL,1,'2023-02-27 11:58:51','2023-03-10 19:12:30','2023-03-10 19:12:30');
INSERT INTO `balance_libro` VALUES (2309,8433,40846,119617,3,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',4440.00,NULL,NULL,1,'2023-02-27 11:58:51','2023-02-27 11:58:51',NULL),(2310,8433,40846,119617,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',89677.00,NULL,NULL,1,'2023-02-27 11:58:51','2023-03-18 21:08:22','2023-03-18 21:08:22'),(2311,8433,40846,119617,3,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',89677.00,NULL,NULL,1,'2023-02-27 11:58:51','2023-03-18 21:07:36','2023-03-18 21:07:36'),(2312,8433,40846,119617,3,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',62364.32,NULL,NULL,1,'2023-02-27 11:58:51','2023-03-10 19:09:56','2023-03-10 19:09:56'),(2313,8433,40846,119617,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',500.00,NULL,NULL,1,'2023-02-28 10:34:12','2023-03-18 21:29:26','2023-03-18 21:29:26'),(2314,8433,40846,119617,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1275.44,NULL,NULL,1,'2023-02-28 10:37:38','2023-03-18 21:25:49','2023-03-18 21:25:49'),(2315,8433,40846,119617,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1544.67,NULL,NULL,1,'2023-02-28 10:39:18','2023-03-18 21:27:56','2023-03-18 21:27:56'),(2316,8433,40846,119617,3,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1800.00,NULL,NULL,1,'2023-02-28 10:41:31','2023-02-28 10:41:31',NULL),(2317,8433,40846,119617,3,2317,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2084.30,'Taxi/UBER Febrero',NULL,1,'2023-02-28 10:48:05','2023-02-28 10:49:23','2023-02-28 10:49:23'),(2318,8434,40846,119617,3,2318,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2084.30,'Taxi/UBER Febrero',NULL,1,'2023-02-28 10:49:23','2023-03-20 23:11:02','2023-03-20 23:11:02'),(2319,8433,40846,119617,3,2319,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',194686.33,'Pago Cargas sociales 01-2023',NULL,1,'2023-02-28 10:55:37','2023-02-28 10:55:37',NULL),(2320,8433,40846,119617,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1950.00,NULL,NULL,1,'2023-02-28 10:59:51','2023-03-10 19:06:29','2023-03-10 19:06:29'),(2321,8433,40846,119617,3,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',12236.03,NULL,NULL,1,'2023-02-28 11:04:10','2023-03-17 20:14:44','2023-03-17 20:14:44'),(2322,8433,40846,119617,3,2322,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',23623.20,'Compra Refrigerio - VERITEK',NULL,1,'2023-02-28 11:48:28','2023-02-28 11:48:28',NULL),(2323,8433,40846,119617,3,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',134478.00,NULL,NULL,1,'2023-02-28 11:50:38','2023-02-28 11:50:38',NULL),(2324,8433,40798,55986,3,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8412.00,NULL,NULL,1,'2023-02-28 12:04:01','2023-04-12 09:40:11','2023-04-12 09:40:11'),(2325,8433,40798,55986,3,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',14.70,NULL,NULL,1,'2023-02-28 12:05:37','2023-04-13 11:27:31','2023-04-13 11:27:31'),(2326,8433,40798,55986,3,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',942172.00,NULL,NULL,1,'2023-02-28 12:06:37','2023-04-13 11:27:49','2023-04-13 11:27:49'),(2327,8433,40798,55986,3,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',342500.01,NULL,NULL,1,'2023-02-28 12:07:28','2023-04-13 11:28:03','2023-04-13 11:28:03');
INSERT INTO `balance_libro` VALUES (2328,8433,40798,55986,3,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',23800.85,NULL,NULL,1,'2023-02-28 12:08:27','2023-04-13 11:47:19','2023-04-13 11:47:19'),(2329,8433,40798,55986,3,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',342500.01,NULL,NULL,1,'2023-02-28 12:09:19','2023-04-13 11:50:10','2023-04-13 11:50:10'),(2330,8433,40798,55986,3,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',342500.01,NULL,NULL,1,'2023-02-28 12:10:05','2023-04-13 11:50:21','2023-04-13 11:50:21'),(2331,8433,40846,119617,3,2331,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',8103.29,'Pago EDENOR',NULL,1,'2023-02-28 13:22:21','2023-02-28 13:22:21',NULL),(2332,8433,40846,119617,3,2332,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',245.64,'Pago METROGAS',NULL,1,'2023-02-28 13:32:42','2023-02-28 13:32:42',NULL),(2333,8434,40846,119617,3,2333,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',78656.60,'Pago Sicore mensual 01-2023',NULL,1,'2023-02-28 13:38:37','2023-03-17 19:08:10','2023-03-17 19:08:10'),(2334,8433,40846,119617,3,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',23375.00,NULL,NULL,1,'2023-02-28 13:42:44','2023-02-28 13:42:44',NULL),(2335,8433,40846,119617,3,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',25625.00,NULL,NULL,1,'2023-02-28 13:43:45','2023-02-28 13:43:45',NULL),(2336,8433,40846,119617,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',89000.00,NULL,NULL,1,'2023-02-28 13:53:33','2023-03-18 21:44:10','2023-03-18 21:44:10'),(2337,8433,40846,119617,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',6682.15,NULL,NULL,1,'2023-02-28 13:57:51','2023-03-17 12:57:18','2023-03-17 12:57:18'),(2338,8433,40846,119617,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',13424.28,NULL,NULL,1,'2023-02-28 14:04:02','2023-03-20 22:38:15','2023-03-20 22:38:15'),(2339,8434,40846,119617,3,2339,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',7608.84,'GOOGLE CLOUD 5F A70534275USD',NULL,1,'2023-03-01 11:27:32','2023-03-07 10:14:06','2023-03-07 10:14:06'),(2340,8434,40846,119617,3,2340,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',387.05,'GOOGLE *Google S P0OJWptx',NULL,1,'2023-03-01 11:33:38','2023-03-07 10:16:35','2023-03-07 10:16:35'),(2341,8434,40846,119617,3,2341,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',9627.75,'Google LLC GSUIT A84436198',NULL,1,'2023-03-01 11:36:54','2023-03-07 10:14:57','2023-03-07 10:14:57'),(2342,8433,40846,119617,1,2342,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',410000.00,'Pago Sueldos 01-2023',NULL,1,'2023-03-01 12:22:18','2023-03-03 11:53:26','2023-03-03 11:53:26'),(2343,8433,40846,119617,21,2274,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2274,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',23375.00,NULL,NULL,1,'2023-03-01 12:34:32','2023-03-01 12:34:32',NULL),(2344,8433,40846,119617,21,2275,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2275,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',25625.00,NULL,NULL,1,'2023-03-01 12:35:24','2023-03-01 12:35:24',NULL),(2345,8433,40846,119617,21,2276,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2276,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',160954.20,NULL,NULL,1,'2023-03-01 13:37:33','2023-03-01 13:37:33',NULL);
INSERT INTO `balance_libro` VALUES (2346,8433,40846,119617,21,2277,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2277,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',18150.00,NULL,NULL,1,'2023-03-01 13:38:36','2023-03-01 13:38:36',NULL),(2347,8433,40846,119617,21,2278,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2278,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',134478.00,NULL,NULL,1,'2023-03-01 13:39:33','2023-03-01 13:39:33',NULL),(2348,8434,40846,119617,21,2279,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2279,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',89000.00,NULL,NULL,1,'2023-03-01 13:40:54','2023-03-18 21:43:17','2023-03-18 21:43:17'),(2349,8434,40846,119617,3,2349,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',13758.00,'Pago a cuenta SICORE 02-2023',NULL,1,'2023-03-02 10:31:07','2023-03-17 19:12:29','2023-03-17 19:12:29'),(2350,8433,40846,119617,21,2280,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2280,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',291005.00,NULL,NULL,1,'2023-03-02 10:44:55','2023-03-02 10:44:55',NULL),(2351,8434,40846,119617,21,2281,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2281,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',100846.00,NULL,NULL,1,'2023-03-02 10:49:43','2023-03-18 21:20:39','2023-03-18 21:20:39'),(2352,8433,40846,119617,21,2282,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2282,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',105814.97,NULL,NULL,1,'2023-03-02 10:56:35','2023-03-02 10:56:35',NULL),(2353,8434,40846,119617,21,2283,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2283,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',12236.03,NULL,NULL,1,'2023-03-02 10:59:00','2023-03-17 20:12:20','2023-03-17 20:12:20'),(2354,8433,40846,119617,2,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',147187.50,NULL,NULL,1,'2023-03-02 11:19:08','2023-03-02 11:19:08',NULL),(2355,8434,40846,119617,3,2355,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',15000.00,'Compra Débito PERU DELI',NULL,1,'2023-03-02 11:24:41','2023-03-20 23:09:51','2023-03-20 23:09:51'),(2356,8433,40846,119617,3,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7793.55,NULL,NULL,1,'2023-03-02 11:28:12','2023-03-17 12:36:42','2023-03-17 12:36:42'),(2357,8434,40846,119617,21,2286,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2286,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7793.55,NULL,NULL,1,'2023-03-02 11:31:22','2023-03-17 12:35:43','2023-03-17 12:35:43'),(2358,8434,40846,119617,3,2358,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',15914.13,'Gastos Bancarios 02-2023',NULL,1,'2023-03-02 11:37:43','2023-03-17 19:04:24','2023-03-17 19:04:24'),(2359,8433,40846,119617,20,2287,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2287,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',147187.50,NULL,NULL,1,'2023-03-03 10:47:23','2023-03-03 10:47:23',NULL),(2360,8433,40846,119617,3,2360,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',42170.09,'Expensas Sr. Si 01-2023',NULL,1,'2023-03-03 10:57:56','2023-03-03 10:57:56',NULL),(2361,8433,40846,119617,3,2361,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',2206.15,'Pago AYSA',NULL,1,'2023-03-03 10:59:43','2023-03-03 10:59:43',NULL),(2362,8434,40846,119617,21,2288,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2288,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1950.00,NULL,NULL,1,'2023-03-03 11:11:33','2023-03-10 19:05:38','2023-03-10 19:05:38'),(2363,8433,40846,119617,21,2289,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2289,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',7500.00,NULL,NULL,1,'2023-03-03 11:14:36','2023-03-03 11:14:36',NULL);
INSERT INTO `balance_libro` VALUES (2364,8433,40846,119617,1,2364,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',592000.00,'Pago Sueldos 01-2023',NULL,1,'2023-03-03 11:53:26','2023-03-03 11:53:26',NULL),(2365,8437,40800,59017,3,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',24430.00,NULL,NULL,1,'2023-03-06 11:23:14','2023-03-06 11:23:14',NULL),(2366,8437,40800,59017,3,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',6758.00,NULL,NULL,1,'2023-03-06 11:23:14','2023-03-06 11:23:14',NULL),(2367,8437,40800,59017,3,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',19384.51,NULL,NULL,1,'2023-03-06 11:23:14','2023-03-28 11:31:50','2023-03-28 11:31:50'),(2368,8437,40800,59017,3,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',31504.19,NULL,NULL,1,'2023-03-06 11:23:14','2023-03-28 11:33:02','2023-03-28 11:33:02'),(2369,8437,40800,59017,3,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',43422.97,NULL,NULL,1,'2023-03-06 11:23:14','2023-03-28 11:30:38','2023-03-28 11:30:38'),(2370,8437,40800,59017,3,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3087.50,NULL,NULL,1,'2023-03-06 11:23:14','2023-03-06 11:23:14',NULL),(2371,8437,40800,59017,3,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',10625.00,NULL,NULL,1,'2023-03-06 11:23:14','2023-03-28 11:33:48','2023-03-28 11:33:48'),(2372,8437,40800,59017,3,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',44506.59,NULL,NULL,1,'2023-03-06 11:23:14','2023-03-28 11:36:11','2023-03-28 11:36:11'),(2373,8437,40800,59017,3,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',38273.24,NULL,NULL,1,'2023-03-06 11:23:14','2023-03-28 11:37:43','2023-03-28 11:37:43'),(2374,8437,40800,59017,3,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',8098.57,NULL,NULL,1,'2023-03-06 11:23:14','2023-03-28 11:39:05','2023-03-28 11:39:05'),(2375,8437,40800,59017,3,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',93248.02,NULL,NULL,1,'2023-03-06 11:23:14','2023-03-28 11:39:48','2023-03-28 11:39:48'),(2376,8437,40800,59017,3,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',92376.99,NULL,NULL,1,'2023-03-06 11:23:14','2023-03-06 11:23:14',NULL),(2377,8437,40800,59017,3,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',40233.13,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-06 11:23:15',NULL),(2378,8437,40800,59017,3,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',31041.65,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-06 11:23:15',NULL),(2379,8437,40800,59017,3,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',21614.01,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-06 11:23:15',NULL),(2380,8437,40800,59017,3,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',21614.01,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-27 13:29:33','2023-03-27 13:29:33'),(2381,8437,40800,59017,3,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',21614.01,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-06 11:23:15',NULL),(2382,8437,40800,59017,3,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',168350.00,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-06 11:23:15',NULL),(2383,8437,40800,59017,3,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',14902.68,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-30 09:20:57','2023-03-30 09:20:57');
INSERT INTO `balance_libro` VALUES (2384,8437,40800,59017,3,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',46973.14,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-30 09:21:24','2023-03-30 09:21:24'),(2385,8437,40800,59017,3,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',7251.83,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-06 11:23:15',NULL),(2386,8437,40800,59017,3,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',51376.12,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-28 11:45:07','2023-03-28 11:45:07'),(2387,8437,40800,59017,3,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',67121.58,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-28 11:46:25','2023-03-28 11:46:25'),(2388,8437,40800,59017,3,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',35633.04,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-28 11:47:22','2023-03-28 11:47:22'),(2389,8437,40800,59017,3,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',42379.89,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-28 11:48:30','2023-03-28 11:48:30'),(2390,8437,40800,59017,3,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',6146.77,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-28 11:49:54','2023-03-28 11:49:54'),(2391,8437,40800,59017,3,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',7436.00,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-28 11:51:15','2023-03-28 11:51:15'),(2392,8437,40800,59017,3,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',42128.10,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-30 09:22:27','2023-03-30 09:22:27'),(2393,8437,40800,59017,3,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',10644.63,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-30 09:21:55','2023-03-30 09:21:55'),(2394,8437,40800,59017,3,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',47382.14,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-28 11:53:03','2023-03-28 11:53:03'),(2395,8437,40800,59017,3,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',20341.57,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-28 11:54:15','2023-03-28 11:54:15'),(2396,8437,40800,59017,3,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',38492.61,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-28 11:55:04','2023-03-28 11:55:04'),(2397,8437,40800,59017,3,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',94506.24,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-28 11:56:57','2023-03-28 11:56:57'),(2398,8437,40800,59017,3,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-03-06 11:23:15','2023-03-06 11:23:15',NULL),(2399,8437,40800,59017,3,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',4134.82,NULL,NULL,1,'2023-03-06 11:30:12','2023-03-06 11:30:12',NULL),(2400,8437,40800,59017,3,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3490.02,NULL,NULL,1,'2023-03-06 11:34:58','2023-03-06 11:34:58',NULL),(2401,8437,40800,59017,3,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',32299.99,NULL,NULL,1,'2023-03-06 11:39:49','2023-03-06 11:39:49',NULL),(2402,8437,40800,59017,3,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',5168.55,NULL,NULL,1,'2023-03-06 11:45:37','2023-03-06 11:45:37',NULL);
INSERT INTO `balance_libro` VALUES (2403,8437,40800,59017,3,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',4134.94,NULL,NULL,1,'2023-03-06 11:49:08','2023-03-06 11:49:08',NULL),(2404,8434,40846,119617,21,2329,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2329,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',6682.15,NULL,NULL,1,'2023-03-07 09:57:40','2023-03-17 12:56:37','2023-03-17 12:56:37'),(2405,8434,40846,119617,21,2330,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2330,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',57632.89,NULL,NULL,1,'2023-03-07 09:59:01','2023-03-07 09:59:01',NULL),(2406,8434,40846,119617,21,2331,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2331,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',7645.39,NULL,NULL,1,'2023-03-07 10:00:11','2023-03-07 10:00:11',NULL),(2407,8434,40846,119617,21,2332,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2332,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',13424.28,NULL,NULL,1,'2023-03-07 10:01:20','2023-03-20 22:37:07','2023-03-20 22:37:07'),(2408,8434,40846,119617,3,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',936.26,NULL,NULL,1,'2023-03-07 10:04:35','2023-03-07 10:04:35',NULL),(2409,8434,40846,119617,21,2334,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2334,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',936.26,NULL,NULL,1,'2023-03-07 10:05:47','2023-03-07 10:05:47',NULL),(2410,8434,40846,119617,3,2410,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',28163.47,'Gastos Tarjeta de Credito 02/2023',NULL,1,'2023-03-07 10:09:21','2023-03-07 10:09:21',NULL),(2411,8434,40846,119617,3,2411,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',38050.57,'Pago OSDE',NULL,1,'2023-03-07 10:11:40','2023-03-07 10:11:40',NULL),(2412,8434,40846,119617,3,2412,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2374.44,'GOOGLE GSUITE_c A62874085USD',NULL,1,'2023-03-07 10:14:06','2023-03-07 10:14:06',NULL),(2413,8434,40846,119617,3,2413,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',7740.67,'GOOGLE CLOUD vM A86690394USD',NULL,1,'2023-03-07 10:14:57','2023-03-07 10:14:57',NULL),(2414,8434,40846,119617,3,2414,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',9794.57,'Google LLC GSUIT A84186451USD',NULL,1,'2023-03-07 10:16:35','2023-03-07 10:16:35',NULL),(2415,8434,40846,119617,3,2415,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',393.76,'GOOGLE *Google S P0PtH3uE USD',NULL,1,'2023-03-07 10:17:44','2023-03-07 10:18:04','2023-03-07 10:18:04'),(2416,8434,40846,119617,3,2416,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',393.76,'GOOGLE *Google S P0PtH3uE USD',NULL,1,'2023-03-07 10:18:04','2023-03-07 10:18:04',NULL),(2417,8434,40846,119617,3,2417,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9794.57,'GOOGLE GSUITE_c A20912281USD',NULL,1,'2023-03-07 10:19:33','2023-03-07 10:19:33',NULL),(2418,8434,40846,119617,3,2418,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2374.44,'GOOGLE GSUITE_c A61865779USD',NULL,1,'2023-03-07 10:20:21','2023-03-07 10:20:21',NULL),(2419,8434,40846,119617,3,2419,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7036.26,'GOOGLE *CLOUD 8B P0PUUpIt USD',NULL,1,'2023-03-07 10:22:49','2023-03-07 10:22:49',NULL),(2420,8434,40846,119617,21,2335,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2335,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',4440.00,NULL,NULL,1,'2023-03-07 10:29:23','2023-03-07 10:29:23',NULL);
INSERT INTO `balance_libro` VALUES (2421,8434,40846,119617,21,2336,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2336,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',398.18,NULL,NULL,1,'2023-03-07 10:48:21','2023-03-18 21:20:21','2023-03-18 21:20:21'),(2422,8434,40846,119617,21,2337,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2337,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1544.67,NULL,NULL,1,'2023-03-07 10:49:36','2023-03-18 21:20:15','2023-03-18 21:20:15'),(2423,8434,40846,119617,21,2338,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2338,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1275.44,NULL,NULL,1,'2023-03-07 10:50:47','2023-03-18 21:20:09','2023-03-18 21:20:09'),(2424,8434,40846,119617,21,2339,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2339,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',500.00,NULL,NULL,1,'2023-03-07 10:51:54','2023-03-18 21:20:54','2023-03-18 21:20:54'),(2425,8433,40846,119617,21,2340,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2340,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1800.00,NULL,NULL,1,'2023-03-07 10:52:50','2023-03-07 10:52:50',NULL),(2426,8433,40846,119617,21,2341,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2341,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1700.00,NULL,NULL,1,'2023-03-07 10:53:58','2023-03-07 10:53:58',NULL),(2427,8437,41082,434734,3,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2999.99,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2428,8437,41082,434734,3,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',9800.00,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2429,8437,41082,434734,3,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',40000.00,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2430,8437,41082,434734,3,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',11100.00,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2431,8437,41082,434734,3,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',207400.00,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2432,8437,41082,434734,3,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',78524.00,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2433,8437,41082,434734,3,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',39800.09,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2434,8437,41082,434734,3,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',381832.00,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2435,8437,41082,434734,3,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',75908.75,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2436,8437,41082,434734,3,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',82654.00,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2437,8437,41082,434734,3,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',12000.60,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2438,8437,41082,434734,3,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',9000.00,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2439,8437,41082,434734,3,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',38865.20,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2440,8437,41082,434734,3,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',28253.50,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL);
INSERT INTO `balance_libro` VALUES (2441,8437,41082,434734,3,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',6860.70,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2442,8437,41082,434734,3,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',5112.80,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2443,8437,41082,434734,3,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',6461.10,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2444,8437,41082,434734,3,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',21866.20,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2445,8437,41082,434734,3,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',320000.00,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2446,8437,41082,434734,3,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4219.20,NULL,NULL,1,'2023-03-07 11:42:26','2023-03-07 11:42:26',NULL),(2447,8437,41082,434734,3,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',9999.99,NULL,NULL,1,'2023-03-09 11:28:46','2023-03-09 11:28:46',NULL),(2448,8437,41082,434734,3,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',11501.51,NULL,NULL,1,'2023-03-09 11:35:23','2023-03-09 11:35:23',NULL),(2449,8437,41082,434734,3,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',12002.51,NULL,NULL,1,'2023-03-09 11:37:23','2023-03-09 11:37:23',NULL),(2450,8437,41082,434734,3,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1629.49,NULL,NULL,1,'2023-03-09 11:42:11','2023-03-09 11:42:11',NULL),(2451,8434,40846,119616,8,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',207671.67,NULL,NULL,1,'2023-03-09 15:09:39','2023-03-09 15:09:39',NULL),(2452,8434,40846,119616,8,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',29056.93,NULL,NULL,1,'2023-03-09 15:09:39','2023-03-09 15:09:39',NULL),(2453,8434,40846,119616,8,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',664.73,NULL,NULL,1,'2023-03-09 15:09:39','2023-03-09 15:09:39',NULL),(2454,8434,40846,119616,16,1008,'App\\Models\\PeriodLiquidation',NULL,1008,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',483756.00,NULL,NULL,1,'2023-03-09 15:14:28','2023-03-09 16:16:18','2023-03-09 16:16:18'),(2455,8434,40846,757610,15,1011,'App\\Models\\PeriodLiquidation',NULL,1011,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',5514692.33,NULL,NULL,1,'2023-03-09 16:02:13','2023-03-09 16:02:33','2023-03-09 16:02:33'),(2456,8434,40846,119616,7,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',393770.39,NULL,NULL,1,'2023-03-09 16:04:46','2023-03-09 16:20:19','2023-03-09 16:20:19'),(2457,8434,40846,119616,7,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',123.41,NULL,NULL,1,'2023-03-09 16:12:29','2023-03-09 16:19:28','2023-03-09 16:19:28'),(2458,8434,40846,119616,7,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',275.54,NULL,NULL,1,'2023-03-09 16:12:29','2023-03-09 16:19:22','2023-03-09 16:19:22'),(2459,8434,40846,119616,7,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',168.75,NULL,NULL,1,'2023-03-09 16:12:29','2023-03-09 16:19:15','2023-03-09 16:19:15'),(2460,8434,40846,119616,7,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',130.54,NULL,NULL,1,'2023-03-09 16:12:30','2023-03-09 16:19:05','2023-03-09 16:19:05');
INSERT INTO `balance_libro` VALUES (2461,8434,40846,119616,7,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',543.00,NULL,NULL,1,'2023-03-09 16:12:30','2023-03-09 16:18:58','2023-03-09 16:18:58'),(2462,8434,40846,119616,7,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',495.00,NULL,NULL,1,'2023-03-09 16:12:30','2023-03-09 16:18:48','2023-03-09 16:18:48'),(2463,8434,40846,119616,7,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',6720.00,NULL,NULL,1,'2023-03-09 16:12:42','2023-03-09 16:23:17','2023-03-09 16:23:17'),(2464,8434,40846,119616,7,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',21840.00,NULL,NULL,1,'2023-03-09 16:12:42','2023-03-09 16:23:26','2023-03-09 16:23:26'),(2465,8434,40846,119616,7,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3360.00,NULL,NULL,1,'2023-03-09 16:12:42','2023-03-09 16:18:28','2023-03-09 16:18:28'),(2466,8434,40846,119616,7,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',3360.00,NULL,NULL,1,'2023-03-09 16:12:42','2023-03-09 16:18:35','2023-03-09 16:18:35'),(2467,8434,40846,119616,7,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',15120.00,NULL,NULL,1,'2023-03-09 16:12:42','2023-03-09 16:23:32','2023-03-09 16:23:32'),(2468,8434,40846,119616,7,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',13440.00,NULL,NULL,1,'2023-03-09 16:12:42','2023-03-09 16:23:43','2023-03-09 16:23:43'),(2469,8434,40846,119616,7,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',531542.99,NULL,NULL,1,'2023-03-09 16:12:42','2023-03-09 16:16:56','2023-03-09 16:16:56'),(2470,8434,40846,119616,7,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',393770.39,NULL,NULL,1,'2023-03-09 16:20:19','2023-03-09 16:20:19',NULL),(2471,8433,41420,752878,2,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',45000.00,NULL,NULL,1,'2023-03-10 09:39:01','2023-03-10 09:39:01',NULL),(2472,8433,41418,751363,2,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',162162.00,NULL,NULL,1,'2023-03-10 09:49:37','2023-03-10 09:49:37',NULL),(2473,8433,41418,751363,2,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',8000.00,NULL,NULL,1,'2023-03-10 09:49:37','2023-03-10 09:49:37',NULL),(2474,8437,40875,131734,2,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',144353.00,NULL,NULL,1,'2023-03-10 10:04:02','2023-03-10 10:04:02',NULL),(2475,8437,40875,131734,2,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',259203.97,NULL,NULL,1,'2023-03-10 10:04:02','2023-03-10 10:04:02',NULL),(2476,8437,40875,131734,2,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',48906.99,NULL,NULL,1,'2023-03-10 10:04:02','2023-03-10 10:04:02',NULL),(2477,8437,40875,131734,3,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4589.99,NULL,NULL,1,'2023-03-10 10:04:24','2023-03-10 10:04:24',NULL),(2478,8437,40875,131734,3,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',964.00,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-27 12:06:51','2023-03-27 12:06:51'),(2479,8437,40875,131734,3,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1640.78,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-27 12:07:59','2023-03-27 12:07:59');
INSERT INTO `balance_libro` VALUES (2480,8437,40875,131734,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',51000.00,NULL,NULL,1,'2023-03-10 10:04:25','2023-04-03 12:17:56','2023-04-03 12:17:56'),(2481,8437,40875,131734,3,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',24925.03,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-27 12:36:38','2023-03-27 12:36:38'),(2482,8437,40875,131734,3,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',12644.50,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-10 10:04:25',NULL),(2483,8437,40875,131734,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8340.12,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-29 11:38:42','2023-03-29 11:38:42'),(2484,8437,40875,131734,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',8200.00,NULL,NULL,1,'2023-03-10 10:04:25','2023-04-03 11:54:03','2023-04-03 11:54:03'),(2485,8437,40875,131734,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1190.00,NULL,NULL,1,'2023-03-10 10:04:25','2023-04-03 11:51:35','2023-04-03 11:51:35'),(2486,8437,40875,131734,3,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',7921.98,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-23 12:31:12','2023-03-23 12:31:12'),(2487,8437,40875,131734,3,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',6000.00,NULL,NULL,1,'2023-03-10 10:04:25','2023-04-03 11:50:07','2023-04-03 11:50:07'),(2488,8437,40875,131734,3,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1345.00,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-10 10:04:25',NULL),(2489,8437,40875,131734,3,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',8700.00,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-10 10:04:25',NULL),(2490,8437,40875,131734,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',45531.82,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-29 11:28:15','2023-03-29 11:28:15'),(2491,8437,40875,131734,3,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',408.26,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-29 11:28:54','2023-03-29 11:28:54'),(2492,8437,40875,131734,3,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',816.53,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-29 11:29:35','2023-03-29 11:29:35'),(2493,8437,40875,131734,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',6358.81,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-23 12:41:19','2023-03-23 12:41:19'),(2494,8437,40875,131734,3,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',8500.01,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-10 10:04:25',NULL),(2495,8437,40875,131734,3,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',8299.90,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-10 10:04:25',NULL),(2496,8437,40875,131734,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7800.00,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-23 12:29:36','2023-03-23 12:29:36'),(2497,8437,40875,131734,3,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',17300.00,NULL,NULL,1,'2023-03-10 10:04:25','2023-03-10 10:04:25',NULL),(2498,8437,40794,48412,2,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',301084.30,NULL,NULL,1,'2023-03-10 10:12:37','2023-03-10 10:12:37',NULL);
INSERT INTO `balance_libro` VALUES (2499,8437,40794,48412,2,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',544726.88,NULL,NULL,1,'2023-03-10 10:12:37','2023-03-10 10:12:37',NULL),(2500,8433,40869,125677,3,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',12350.00,NULL,NULL,1,'2023-03-10 10:12:46','2023-03-10 10:13:34','2023-03-10 10:13:34'),(2501,8433,40869,125677,3,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',12350.00,NULL,NULL,1,'2023-03-10 10:13:34','2023-04-11 09:22:39','2023-04-11 09:22:39'),(2502,8437,40881,140824,3,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1342.02,NULL,NULL,1,'2023-03-10 10:16:39','2023-03-27 13:04:33','2023-03-27 13:04:33'),(2503,8437,40881,140824,3,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',190.00,NULL,NULL,1,'2023-03-10 10:16:39','2023-03-27 13:05:20','2023-03-27 13:05:20'),(2504,8437,40881,140824,3,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',11893.81,NULL,NULL,1,'2023-03-10 10:16:39','2023-03-20 11:37:33','2023-03-20 11:37:33'),(2505,8437,40881,140824,3,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',6595.59,NULL,NULL,1,'2023-03-10 10:16:39','2023-03-27 13:08:18','2023-03-27 13:08:18'),(2506,8437,40881,140824,3,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',214.00,NULL,NULL,1,'2023-03-10 10:16:39','2023-03-27 13:09:21','2023-03-27 13:09:21'),(2507,8437,40881,140824,3,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',4584.27,NULL,NULL,1,'2023-03-10 10:16:39','2023-03-27 13:11:00','2023-03-27 13:11:00'),(2508,8437,40881,140824,3,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',3150.00,NULL,NULL,1,'2023-03-10 10:16:39','2023-03-10 10:16:39',NULL),(2509,8437,40881,140824,3,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',6204.48,NULL,NULL,1,'2023-03-10 10:16:40','2023-03-20 11:31:42','2023-03-20 11:31:42'),(2510,8437,40881,140824,3,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2640.00,NULL,NULL,1,'2023-03-10 10:16:40','2023-03-27 13:13:55','2023-03-27 13:13:55'),(2511,8437,40881,140824,2,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',6755.00,NULL,NULL,1,'2023-03-10 10:16:51','2023-03-10 10:16:51',NULL),(2512,8437,40881,140824,2,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',162139.54,NULL,NULL,1,'2023-03-10 10:16:51','2023-03-10 10:16:51',NULL),(2513,8437,40881,140824,2,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',222285.00,NULL,NULL,1,'2023-03-10 10:16:51','2023-03-10 10:16:51',NULL),(2514,8433,40868,124162,3,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',234429.00,NULL,NULL,1,'2023-03-10 10:19:40','2023-03-20 15:57:15','2023-03-20 15:57:15'),(2515,8437,40881,140824,2,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',12391.59,NULL,NULL,1,'2023-03-10 10:21:12','2023-03-10 10:32:02','2023-03-10 10:32:02'),(2516,8437,40881,140824,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',5244.78,NULL,NULL,1,'2023-03-10 10:29:05','2023-03-10 10:31:58','2023-03-10 10:31:58'),(2517,8437,40881,140824,3,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',12391.59,NULL,NULL,1,'2023-03-10 10:36:58','2023-03-10 10:36:58',NULL);
INSERT INTO `balance_libro` VALUES (2518,8437,40881,140824,3,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',5244.78,NULL,NULL,1,'2023-03-10 10:44:29','2023-03-20 11:32:37','2023-03-20 11:32:37'),(2519,8433,40795,49927,3,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',30712.50,NULL,NULL,1,'2023-03-10 10:50:14','2023-03-10 10:52:03','2023-03-10 10:52:03'),(2520,8433,40795,49927,3,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',136150.00,NULL,NULL,1,'2023-03-10 10:50:14','2023-03-10 10:54:27','2023-03-10 10:54:27'),(2521,8433,40795,49927,3,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',6000.00,NULL,NULL,1,'2023-03-10 10:50:15','2023-03-10 11:05:43','2023-03-10 11:05:43'),(2522,8433,40795,49927,3,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',29120.00,NULL,NULL,1,'2023-03-10 10:50:15','2023-03-31 18:15:01','2023-03-31 18:15:01'),(2523,8433,40795,49927,3,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',3245.40,NULL,NULL,1,'2023-03-10 10:50:15','2023-03-31 10:39:26','2023-03-31 10:39:26'),(2524,8433,40795,49927,3,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',16320.00,NULL,NULL,1,'2023-03-10 10:50:15','2023-03-31 10:38:49','2023-03-31 10:38:49'),(2525,8433,40795,49927,3,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',6000.00,NULL,NULL,1,'2023-03-10 10:50:15','2023-03-10 10:55:30','2023-03-10 10:55:30'),(2526,8433,40795,49927,3,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',30712.50,NULL,NULL,1,'2023-03-10 10:52:03','2023-03-10 10:52:03',NULL),(2527,8433,40795,49927,3,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',136150.00,NULL,NULL,1,'2023-03-10 10:54:27','2023-03-10 10:54:27',NULL),(2528,8433,40795,49927,3,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',6000.00,NULL,NULL,1,'2023-03-10 10:55:30','2023-03-10 10:55:30',NULL),(2529,8437,40877,134764,3,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4589.99,NULL,NULL,1,'2023-03-10 10:59:35','2023-03-10 10:59:35',NULL),(2530,8437,40877,134764,3,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4589.99,NULL,NULL,1,'2023-03-10 10:59:35','2023-03-10 10:59:35',NULL),(2531,8437,40877,134764,3,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',22880.00,NULL,NULL,1,'2023-03-10 10:59:35','2023-03-27 10:24:17','2023-03-27 10:24:17'),(2532,8437,40877,134764,3,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',81593.33,NULL,NULL,1,'2023-03-10 10:59:35','2023-03-10 10:59:35',NULL),(2533,8437,40877,134764,3,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',918.00,NULL,NULL,1,'2023-03-10 10:59:35','2023-03-10 10:59:35',NULL),(2534,8437,40877,134764,3,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',910.00,NULL,NULL,1,'2023-03-10 10:59:35','2023-03-10 10:59:35',NULL),(2535,8437,40877,134764,3,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',918.00,NULL,NULL,1,'2023-03-10 10:59:35','2023-03-10 10:59:35',NULL),(2536,8437,40877,134764,3,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',16191.54,NULL,NULL,1,'2023-03-10 10:59:35','2023-03-10 10:59:35',NULL),(2537,8437,40877,134764,3,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',10700.40,NULL,NULL,1,'2023-03-10 10:59:35','2023-03-10 11:01:55','2023-03-10 11:01:55');
INSERT INTO `balance_libro` VALUES (2538,8437,40877,134764,3,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',166483.06,NULL,NULL,1,'2023-03-10 10:59:35','2023-03-10 11:03:10','2023-03-10 11:03:10'),(2539,8437,40877,134764,3,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',100486.59,NULL,NULL,1,'2023-03-10 10:59:35','2023-03-10 11:04:52','2023-03-10 11:04:52'),(2540,8437,40877,134764,3,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',175295.12,NULL,NULL,1,'2023-03-10 10:59:35','2023-03-10 10:59:35',NULL),(2541,8437,40877,134764,3,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',221159.00,NULL,NULL,1,'2023-03-10 10:59:35','2023-03-10 10:59:35',NULL),(2542,8437,40877,134764,3,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',54094.26,NULL,NULL,1,'2023-03-10 10:59:36','2023-03-10 10:59:36',NULL),(2543,8437,40877,134764,3,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',262127.75,NULL,NULL,1,'2023-03-10 10:59:36','2023-03-10 10:59:36',NULL),(2544,8437,40877,134764,3,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',10700.41,NULL,NULL,1,'2023-03-10 11:01:55','2023-03-10 11:01:55',NULL),(2545,8437,40877,134764,3,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',166483.05,NULL,NULL,1,'2023-03-10 11:03:10','2023-03-10 11:03:10',NULL),(2546,8437,40877,134764,3,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',100486.59,NULL,NULL,1,'2023-03-10 11:04:52','2023-03-10 11:04:52',NULL),(2547,8433,40795,49927,3,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',6000.00,NULL,NULL,1,'2023-03-10 11:05:43','2023-03-10 11:05:43',NULL),(2548,8437,40877,134764,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1702688.98,NULL,NULL,1,'2023-03-10 11:10:45','2023-03-27 10:18:25','2023-03-27 10:18:25'),(2549,8433,40783,31750,3,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',182765.60,NULL,NULL,1,'2023-03-10 11:11:32','2023-03-10 11:15:03','2023-03-10 11:15:03'),(2550,8433,40783,31750,3,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',24310.00,NULL,NULL,1,'2023-03-10 11:11:32','2023-03-10 11:16:26','2023-03-10 11:16:26'),(2551,8433,40783,31750,3,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',14246.28,NULL,NULL,1,'2023-03-10 11:11:32','2023-03-10 11:17:26','2023-03-10 11:17:26'),(2552,8433,40783,31750,3,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',17128.71,NULL,NULL,1,'2023-03-10 11:11:32','2023-03-10 11:20:15','2023-03-10 11:20:15'),(2553,8433,40783,31750,3,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',182765.60,NULL,NULL,1,'2023-03-10 11:15:03','2023-04-11 11:35:10','2023-04-11 11:35:10'),(2554,8433,40783,31750,3,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',24310.00,NULL,NULL,1,'2023-03-10 11:16:26','2023-03-10 11:16:26',NULL),(2555,8433,40783,31750,3,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',14246.28,NULL,NULL,1,'2023-03-10 11:17:26','2023-03-10 11:17:26',NULL),(2556,8433,40783,31750,3,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',17128.71,NULL,NULL,1,'2023-03-10 11:20:15','2023-03-10 11:20:15',NULL),(2557,8437,40786,36295,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',90750.00,NULL,NULL,1,'2023-03-10 11:22:46','2023-03-10 11:22:46',NULL);
INSERT INTO `balance_libro` VALUES (2558,8437,40786,36295,3,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',67430.00,NULL,NULL,1,'2023-03-10 11:22:56','2023-03-10 11:25:16','2023-03-10 11:25:16'),(2559,8437,40786,36295,3,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',34100.00,NULL,NULL,1,'2023-03-10 11:22:56','2023-03-10 11:22:56',NULL),(2560,8437,40786,36295,3,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8000.00,NULL,NULL,1,'2023-03-10 11:22:56','2023-03-10 11:25:52','2023-03-10 11:25:52'),(2561,8437,40786,36295,3,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',133501.01,NULL,NULL,1,'2023-03-10 11:22:56','2023-03-10 11:22:56',NULL),(2562,8437,40786,36295,3,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',67430.00,NULL,NULL,1,'2023-03-10 11:25:16','2023-03-10 11:25:16',NULL),(2563,8437,40786,36295,3,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8000.00,NULL,NULL,1,'2023-03-10 11:25:52','2023-03-10 11:25:52',NULL),(2564,8433,40870,127192,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',2700197.32,NULL,NULL,1,'2023-03-10 11:38:16','2023-03-10 11:38:16',NULL),(2565,8433,40870,127192,3,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',11470.00,NULL,NULL,1,'2023-03-10 11:38:43','2023-03-10 11:50:47','2023-03-10 11:50:47'),(2566,8433,40870,127192,3,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',312.34,NULL,NULL,1,'2023-03-10 11:38:43','2023-03-10 11:51:19','2023-03-10 11:51:19'),(2567,8433,40870,127192,3,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',54900.73,NULL,NULL,1,'2023-03-10 11:38:43','2023-03-23 15:58:24','2023-03-23 15:58:24'),(2568,8433,40870,127192,3,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',54900.73,NULL,NULL,1,'2023-03-10 11:38:43','2023-03-23 15:58:03','2023-03-23 15:58:03'),(2569,8433,40870,127192,3,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',8000.00,NULL,NULL,1,'2023-03-10 11:38:43','2023-03-10 13:55:22','2023-03-10 13:55:22'),(2570,8433,40870,127192,3,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',127440.00,NULL,NULL,1,'2023-03-10 11:38:43','2023-05-10 10:49:24','2023-05-10 10:49:24'),(2571,8433,40870,127192,3,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',4159.00,NULL,NULL,1,'2023-03-10 11:38:43','2023-03-10 13:56:00','2023-03-10 13:56:00'),(2572,8433,40870,127192,3,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',4159.00,NULL,NULL,1,'2023-03-10 11:38:43','2023-03-10 13:56:34','2023-03-10 13:56:34'),(2573,8433,40870,127192,3,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',7914.89,NULL,NULL,1,'2023-03-10 11:38:43','2023-03-13 09:51:36','2023-03-13 09:51:36'),(2574,8433,40870,127192,3,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',6000.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-03-13 09:52:24','2023-03-13 09:52:24'),(2575,8433,40870,127192,3,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',2100.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 10:59:47','2023-05-10 10:59:47'),(2576,8433,40870,127192,3,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',275000.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-03-13 09:52:57','2023-03-13 09:52:57');
INSERT INTO `balance_libro` VALUES (2577,8433,40870,127192,3,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',2170.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 11:03:00','2023-05-10 11:03:00'),(2578,8433,40870,127192,3,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',5750.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 11:04:19','2023-05-10 11:04:19'),(2579,8433,40870,127192,3,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1100.01,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 11:57:06','2023-05-10 11:57:06'),(2580,8433,40870,127192,3,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',375.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 11:43:04','2023-05-10 11:43:04'),(2581,8433,40870,127192,3,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8001.30,NULL,NULL,1,'2023-03-10 11:38:44','2023-03-13 09:54:05','2023-03-13 09:54:05'),(2582,8433,40870,127192,3,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',600.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 11:52:02','2023-05-10 11:52:02'),(2583,8433,40870,127192,3,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1799.99,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 11:58:00','2023-05-10 11:58:00'),(2584,8433,40870,127192,3,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',16000.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-03-13 09:54:35','2023-03-13 09:54:35'),(2585,8433,40870,127192,3,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',64779.06,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 12:12:12','2023-05-10 12:12:12'),(2586,8433,40870,127192,3,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',990.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-03-13 09:55:00','2023-03-13 09:55:00'),(2587,8433,40870,127192,3,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1500.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 11:52:17','2023-05-10 11:52:17'),(2588,8433,40870,127192,3,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',660.01,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 12:51:07','2023-05-10 12:51:07'),(2589,8433,40870,127192,3,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',6220.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-03-13 09:55:33','2023-03-13 09:55:33'),(2590,8433,40870,127192,3,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1761.76,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 12:56:34','2023-05-10 12:56:34'),(2591,8433,40870,127192,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',54500.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-03-13 09:56:02','2023-03-13 09:56:02'),(2592,8433,40870,127192,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',75000.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-03-13 09:56:28','2023-03-13 09:56:28'),(2593,8433,40870,127192,3,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',100.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-11 13:51:50','2023-05-11 13:51:50'),(2594,8433,40870,127192,3,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',6050.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 12:56:52','2023-05-10 12:56:52'),(2595,8433,40870,127192,3,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',51598.00,NULL,NULL,1,'2023-03-10 11:38:44','2023-03-23 16:02:00','2023-03-23 16:02:00');
INSERT INTO `balance_libro` VALUES (2596,8433,40870,127192,3,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3589.99,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 13:08:57','2023-05-10 13:08:57'),(2597,8433,40870,127192,3,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1789.99,NULL,NULL,1,'2023-03-10 11:38:44','2023-05-10 13:09:30','2023-05-10 13:09:30'),(2598,8433,40870,127192,3,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',110000.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-03-13 09:56:58','2023-03-13 09:56:58'),(2599,8433,40870,127192,3,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',20000.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-03-13 09:57:24','2023-03-13 09:57:24'),(2600,8433,40870,127192,3,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',4300.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-10 11:00:09','2023-05-10 11:00:09'),(2601,8433,40870,127192,3,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',800.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-11 13:55:31','2023-05-11 13:55:31'),(2602,8433,40870,127192,3,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',710.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-11 13:55:54','2023-05-11 13:55:54'),(2603,8433,40870,127192,3,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',14530.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-03-13 09:57:55','2023-03-13 09:57:55'),(2604,8433,40870,127192,3,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',8500.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-10 13:28:15','2023-05-10 13:28:15'),(2605,8433,40870,127192,3,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',4400.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-10 13:30:05','2023-05-10 13:30:05'),(2606,8433,40870,127192,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',18000.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-03-13 09:58:23','2023-03-13 09:58:23'),(2607,8433,40870,127192,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',10900.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-03-13 09:58:52','2023-03-13 09:58:52'),(2608,8433,40870,127192,3,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',6272.64,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-10 12:57:12','2023-05-10 12:57:12'),(2609,8433,40870,127192,3,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',760.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-03-13 09:59:22','2023-03-13 09:59:22'),(2610,8433,40870,127192,3,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1089.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-11 13:52:36','2023-05-11 13:52:36'),(2611,8433,40870,127192,3,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1500.40,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-10 13:39:17','2023-05-10 13:39:17'),(2612,8433,40870,127192,3,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3840.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-10 13:43:09','2023-05-10 13:43:09'),(2613,8433,40870,127192,3,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',6879.96,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-10 13:09:49','2023-05-10 13:09:49'),(2614,8433,40870,127192,3,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',9999.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-10 13:45:39','2023-05-10 13:45:39');
INSERT INTO `balance_libro` VALUES (2615,8433,40870,127192,3,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1895.35,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-10 12:12:28','2023-05-10 12:12:28'),(2616,8433,40870,127192,3,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',111892.33,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-10 13:47:56','2023-05-10 13:47:56'),(2617,8433,40870,127192,3,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',14490.96,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-10 13:48:16','2023-05-10 13:48:16'),(2618,8433,40870,127192,3,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',450.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-03-13 09:59:53','2023-03-13 09:59:53'),(2619,8433,40870,127192,3,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1001.30,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-11 13:01:51','2023-05-11 13:01:51'),(2620,8433,40870,127192,3,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',695.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-03-13 10:00:23','2023-03-13 10:00:23'),(2621,8433,40870,127192,3,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',990.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-11 13:56:17','2023-05-11 13:56:17'),(2622,8433,40870,127192,3,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',990.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-11 13:56:31','2023-05-11 13:56:31'),(2623,8433,40870,127192,3,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',25800.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-11 13:06:34','2023-05-11 13:06:34'),(2624,8433,40870,127192,3,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1180.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-03-13 10:00:47','2023-03-13 10:00:47'),(2625,8433,40870,127192,3,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',25000.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-03-13 10:01:16','2023-03-13 10:01:16'),(2626,8433,40870,127192,3,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1500.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-05-10 11:04:46','2023-05-10 11:04:46'),(2627,8433,40870,127192,3,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',19260.00,NULL,NULL,1,'2023-03-10 11:38:45','2023-03-13 10:01:57','2023-03-13 10:01:57'),(2628,8433,40870,127192,3,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',387.20,NULL,NULL,1,'2023-03-10 11:38:46','2023-05-11 13:14:45','2023-05-11 13:14:45'),(2629,8433,40870,127192,3,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',8340.70,NULL,NULL,1,'2023-03-10 11:38:46','2023-03-13 10:03:18','2023-03-13 10:03:18'),(2630,8433,40870,127192,3,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',366.99,NULL,NULL,1,'2023-03-10 11:38:46','2023-05-11 13:17:59','2023-05-11 13:17:59'),(2631,8433,40870,127192,3,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',610.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-05-11 13:18:47','2023-05-11 13:18:47'),(2632,8433,40870,127192,3,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',2720.03,NULL,NULL,1,'2023-03-10 11:38:46','2023-05-11 13:23:03','2023-05-11 13:23:03'),(2633,8433,40870,127192,3,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',5100.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-05-11 13:23:41','2023-05-11 13:23:41');
INSERT INTO `balance_libro` VALUES (2634,8433,40870,127192,3,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',14000.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-03-13 10:03:55','2023-03-13 10:03:55'),(2635,8433,40870,127192,3,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',38999.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-05-11 13:26:49','2023-05-11 13:26:49'),(2636,8433,40870,127192,3,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7400.04,NULL,NULL,1,'2023-03-10 11:38:46','2023-05-11 13:28:24','2023-05-11 13:28:24'),(2637,8433,40870,127192,3,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-03-13 10:04:24','2023-03-13 10:04:24'),(2638,8433,40870,127192,3,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',17750.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-03-13 10:04:56','2023-03-13 10:04:56'),(2639,8433,40870,127192,3,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',8750.71,NULL,NULL,1,'2023-03-10 11:38:46','2023-03-13 10:05:40','2023-03-13 10:05:40'),(2640,8433,40870,127192,3,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4160.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-05-11 13:56:44','2023-05-11 13:56:44'),(2641,8433,40870,127192,3,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2760.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-05-11 13:32:50','2023-05-11 13:32:50'),(2642,8433,40870,127192,3,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',307.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-03-13 10:06:06','2023-03-13 10:06:06'),(2643,8433,40870,127192,3,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',62875.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-03-13 10:06:46','2023-03-13 10:06:46'),(2644,8433,40870,127192,3,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',415.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-05-11 13:19:13','2023-05-11 13:19:13'),(2645,8433,40870,127192,3,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',100.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-05-11 13:19:32','2023-05-11 13:19:32'),(2646,8433,40870,127192,3,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3371.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-05-11 13:36:01','2023-05-11 13:36:01'),(2647,8433,40870,127192,3,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4000.00,NULL,NULL,1,'2023-03-10 11:38:46','2023-03-13 10:07:46','2023-03-13 10:07:46'),(2648,8433,40870,127192,3,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',11470.00,NULL,NULL,1,'2023-03-10 11:50:47','2023-05-10 10:17:29','2023-05-10 10:17:29'),(2649,8433,40870,127192,3,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',312.34,NULL,NULL,1,'2023-03-10 11:51:19','2023-05-11 13:44:54','2023-05-11 13:44:54'),(2650,8437,40796,51442,3,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',34727.00,NULL,NULL,1,'2023-03-10 12:45:59','2023-03-10 12:45:59',NULL),(2651,8437,40796,51442,3,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',29411.78,NULL,NULL,1,'2023-03-10 12:45:59','2023-03-10 12:45:59',NULL),(2652,8437,40796,51442,3,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1290.00,NULL,NULL,1,'2023-03-10 12:45:59','2023-03-10 12:45:59',NULL);
INSERT INTO `balance_libro` VALUES (2653,8437,40796,51442,3,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',13000.00,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2654,8437,40796,51442,3,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',10180.99,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2655,8437,40796,51442,3,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',750.00,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2656,8437,40796,51442,3,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',21075.00,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2657,8437,40796,51442,3,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',63374.71,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2658,8437,40796,51442,3,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',5606.68,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2659,8437,40796,51442,3,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1290.00,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2660,8437,40796,51442,3,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',2000.00,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2661,8437,40796,51442,3,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',5294.11,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2662,8437,40796,51442,3,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',12300.52,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2663,8437,40796,51442,3,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',7590.00,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2664,8437,40796,51442,3,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3000.00,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2665,8437,40796,51442,3,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',17693.21,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2666,8437,40796,51442,3,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',20592.43,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2667,8437,40796,51442,3,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',12290.00,NULL,NULL,1,'2023-03-10 12:46:00','2023-03-10 12:46:00',NULL),(2668,8433,40870,127192,3,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',8000.00,NULL,NULL,1,'2023-03-10 13:55:22','2023-05-10 10:47:34','2023-05-10 10:47:34'),(2669,8433,40870,127192,3,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',4159.00,NULL,NULL,1,'2023-03-10 13:56:00','2023-05-10 10:51:12','2023-05-10 10:51:12'),(2670,8433,40870,127192,3,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',4159.00,NULL,NULL,1,'2023-03-10 13:56:34','2023-05-10 10:51:33','2023-05-10 10:51:33'),(2671,8433,40846,119616,15,1046,'App\\Models\\PeriodLiquidation',NULL,1046,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7075660.22,NULL,NULL,1,'2023-03-10 17:55:29','2023-03-31 14:08:15','2023-03-31 14:08:15'),(2672,8434,40846,757610,15,1011,'App\\Models\\PeriodLiquidation',NULL,1011,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',5514692.33,NULL,NULL,1,'2023-03-10 17:59:20','2023-03-10 17:59:20',NULL);
INSERT INTO `balance_libro` VALUES (2673,8433,40846,119616,16,1047,'App\\Models\\PeriodLiquidation',NULL,1047,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',483756.00,NULL,NULL,1,'2023-03-10 18:21:56','2023-03-31 14:08:02','2023-03-31 14:08:02'),(2674,8434,40846,119616,18,2674,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',393770.39,'Reclasificacion de cuentas',NULL,1,'2023-03-10 18:49:57','2023-03-10 18:49:57',NULL),(2675,8434,40846,119617,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1950.00,NULL,NULL,1,'2023-03-10 19:06:29','2023-03-10 19:06:44','2023-03-10 19:06:44'),(2676,8434,40846,119617,3,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1950.00,NULL,NULL,1,'2023-03-10 19:06:44','2023-03-10 19:06:44',NULL),(2677,8434,40846,119617,21,2568,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,2568,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1950.00,NULL,NULL,1,'2023-03-10 19:07:55','2023-03-10 19:07:55',NULL),(2678,8434,40846,119617,3,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',62364.32,NULL,NULL,1,'2023-03-10 19:09:56','2023-03-10 19:09:56',NULL),(2679,8434,40846,119617,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',15000.01,NULL,NULL,1,'2023-03-10 19:12:30','2023-03-18 21:10:30','2023-03-18 21:10:30'),(2680,8434,40846,119617,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',78615.71,NULL,NULL,1,'2023-03-10 19:14:31','2023-03-17 12:59:08','2023-03-17 12:59:08'),(2681,8434,40846,119617,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',18583.50,NULL,NULL,1,'2023-03-10 19:19:20','2023-03-17 17:19:21','2023-03-17 17:19:21'),(2682,8437,40875,131734,3,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',5008.02,NULL,NULL,1,'2023-03-13 09:32:55','2023-03-13 09:32:55',NULL),(2683,8437,40875,131734,3,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',8339.21,NULL,NULL,1,'2023-03-13 09:35:27','2023-03-13 09:35:27',NULL),(2684,8437,40875,131734,3,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',8317.43,NULL,NULL,1,'2023-03-13 09:43:15','2023-03-13 09:43:15',NULL),(2685,8437,40875,131734,3,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',2283.75,NULL,NULL,1,'2023-03-13 09:49:21','2023-03-13 09:49:21',NULL),(2686,8433,40870,127192,3,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',7914.89,NULL,NULL,1,'2023-03-13 09:51:36','2023-03-23 11:39:32','2023-03-23 11:39:32'),(2687,8433,40870,127192,3,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',6000.00,NULL,NULL,1,'2023-03-13 09:52:24','2023-05-10 10:57:15','2023-05-10 10:57:15'),(2688,8433,40870,127192,3,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',275000.00,NULL,NULL,1,'2023-03-13 09:52:57','2023-05-10 10:25:05','2023-05-10 10:25:05'),(2689,8433,40870,127192,3,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',8001.31,NULL,NULL,1,'2023-03-13 09:54:05','2023-05-10 11:43:55','2023-05-10 11:43:55'),(2690,8433,40870,127192,3,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',16000.00,NULL,NULL,1,'2023-03-13 09:54:35','2023-05-10 11:59:53','2023-05-10 11:59:53'),(2691,8433,40870,127192,3,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',990.00,NULL,NULL,1,'2023-03-13 09:55:00','2023-03-23 16:04:08','2023-03-23 16:04:08');
INSERT INTO `balance_libro` VALUES (2692,8437,40875,131734,3,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',6985.51,NULL,NULL,1,'2023-03-13 09:55:30','2023-03-13 09:55:30',NULL),(2693,8433,40870,127192,3,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',6220.00,NULL,NULL,1,'2023-03-13 09:55:33','2023-05-10 12:49:16','2023-05-10 12:49:16'),(2694,8433,40870,127192,3,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',54500.00,NULL,NULL,1,'2023-03-13 09:56:02','2023-05-11 13:49:16','2023-05-11 13:49:16'),(2695,8433,40870,127192,3,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',75000.00,NULL,NULL,1,'2023-03-13 09:56:28','2023-05-10 13:03:14','2023-05-10 13:03:14'),(2696,8433,40870,127192,3,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',110000.00,NULL,NULL,1,'2023-03-13 09:56:58','2023-05-10 12:00:16','2023-05-10 12:00:16'),(2697,8433,40870,127192,3,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',20000.00,NULL,NULL,1,'2023-03-13 09:57:24','2023-05-10 13:15:08','2023-05-10 13:15:08'),(2698,8433,40870,127192,3,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',14530.00,NULL,NULL,1,'2023-03-13 09:57:55','2023-05-10 13:26:54','2023-05-10 13:26:54'),(2699,8437,40875,131734,3,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',4000.56,NULL,NULL,1,'2023-03-13 09:57:57','2023-03-13 09:57:57',NULL),(2700,8433,40870,127192,3,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',18000.00,NULL,NULL,1,'2023-03-13 09:58:23','2023-03-13 09:58:23',NULL),(2701,8433,40870,127192,3,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',10900.00,NULL,NULL,1,'2023-03-13 09:58:52','2023-05-11 13:49:40','2023-05-11 13:49:40'),(2702,8433,40870,127192,3,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',760.00,NULL,NULL,1,'2023-03-13 09:59:22','2023-05-10 13:34:47','2023-05-10 13:34:47'),(2703,8433,40870,127192,3,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',450.00,NULL,NULL,1,'2023-03-13 09:59:53','2023-05-10 13:52:26','2023-05-10 13:52:26'),(2704,8433,40870,127192,3,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',695.00,NULL,NULL,1,'2023-03-13 10:00:23','2023-05-11 13:03:37','2023-05-11 13:03:37'),(2705,8433,40870,127192,3,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1180.00,NULL,NULL,1,'2023-03-13 10:00:47','2023-05-11 13:53:25','2023-05-11 13:53:25'),(2706,8433,40870,127192,3,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',25000.00,NULL,NULL,1,'2023-03-13 10:01:16','2023-05-11 13:09:55','2023-05-11 13:09:55'),(2707,8433,40870,127192,3,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',19260.00,NULL,NULL,1,'2023-03-13 10:01:57','2023-05-11 13:11:37','2023-05-11 13:11:37'),(2708,8433,40870,127192,3,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',8340.70,NULL,NULL,1,'2023-03-13 10:03:18','2023-05-10 11:44:21','2023-05-10 11:44:21'),(2709,8437,40875,131734,3,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',8000.10,NULL,NULL,1,'2023-03-13 10:03:29','2023-03-13 10:03:29',NULL),(2710,8433,40870,127192,3,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',14000.00,NULL,NULL,1,'2023-03-13 10:03:55','2023-05-11 13:25:13','2023-05-11 13:25:13');
INSERT INTO `balance_libro` VALUES (2711,8433,40870,127192,3,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-13 10:04:24','2023-05-11 13:30:12','2023-05-11 13:30:12'),(2712,8433,40870,127192,3,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',17750.00,NULL,NULL,1,'2023-03-13 10:04:56','2023-05-10 12:49:38','2023-05-10 12:49:38'),(2713,8437,40875,131734,3,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3500.83,NULL,NULL,1,'2023-03-13 10:05:26','2023-03-13 10:05:26',NULL),(2714,8433,40870,127192,3,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',8750.71,NULL,NULL,1,'2023-03-13 10:05:40','2023-05-10 11:44:44','2023-05-10 11:44:44'),(2715,8433,40870,127192,3,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',307.00,NULL,NULL,1,'2023-03-13 10:06:06','2023-05-11 13:03:52','2023-05-11 13:03:52'),(2716,8433,40870,127192,3,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',62875.00,NULL,NULL,1,'2023-03-13 10:06:46','2023-05-11 13:41:10','2023-05-11 13:41:10'),(2717,8437,40875,131734,3,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',548.05,NULL,NULL,1,'2023-03-13 10:07:32','2023-03-13 10:10:21','2023-03-13 10:10:21'),(2718,8433,40870,127192,3,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4000.00,NULL,NULL,1,'2023-03-13 10:07:46','2023-05-11 13:37:45','2023-05-11 13:37:45'),(2719,8437,40875,131734,3,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5938.90,NULL,NULL,1,'2023-03-13 10:10:21','2023-03-13 10:10:21',NULL),(2720,8437,40875,131734,3,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',8400.09,NULL,NULL,1,'2023-03-13 10:13:46','2023-03-13 10:13:46',NULL),(2721,8437,40875,131734,3,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',10428.14,NULL,NULL,1,'2023-03-13 10:17:03','2023-03-13 10:17:03',NULL),(2722,8433,40929,213544,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',14540.00,NULL,NULL,1,'2023-03-13 10:17:17','2023-03-13 10:18:11','2023-03-13 10:18:11'),(2723,8433,40929,213544,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',22930.00,NULL,NULL,1,'2023-03-13 10:17:17','2023-03-13 10:18:33','2023-03-13 10:18:33'),(2724,8433,40929,213544,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',14540.00,NULL,NULL,1,'2023-03-13 10:18:11','2023-03-20 16:41:11','2023-03-20 16:41:11'),(2725,8433,40929,213544,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',22930.00,NULL,NULL,1,'2023-03-13 10:18:33','2023-03-20 16:40:34','2023-03-20 16:40:34'),(2726,8437,40875,131734,3,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',9409.70,NULL,NULL,1,'2023-03-13 10:20:27','2023-03-13 10:20:27',NULL),(2727,8437,40877,134764,3,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',14702.60,NULL,NULL,1,'2023-03-13 10:31:35','2023-03-13 10:31:35',NULL),(2728,8433,40799,57502,2,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',42350.00,NULL,NULL,1,'2023-03-13 10:32:14','2023-03-13 10:32:14',NULL),(2729,8433,40799,57502,2,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',23000.00,NULL,NULL,1,'2023-03-13 10:32:15','2023-03-13 10:32:15',NULL),(2730,8433,40799,57502,2,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',23000.00,NULL,NULL,1,'2023-03-13 10:32:15','2023-03-13 10:32:15',NULL);
INSERT INTO `balance_libro` VALUES (2731,8433,40799,57502,2,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',23000.00,NULL,NULL,1,'2023-03-13 10:32:15','2023-03-13 10:32:15',NULL),(2732,8433,40799,57502,2,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',23000.00,NULL,NULL,1,'2023-03-13 10:32:15','2023-03-13 10:32:15',NULL),(2733,8433,40799,57502,2,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',23000.00,NULL,NULL,1,'2023-03-13 10:32:15','2023-03-13 10:32:15',NULL),(2734,8433,40799,57502,3,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',212355.00,NULL,NULL,1,'2023-03-13 10:32:41','2023-03-13 10:32:41',NULL),(2735,8433,40799,57502,3,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',112500.00,NULL,NULL,1,'2023-03-13 10:32:42','2023-03-13 10:33:50','2023-03-13 10:33:50'),(2736,8433,40799,57502,3,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',10890.00,NULL,NULL,1,'2023-03-13 10:32:42','2023-03-13 10:32:42',NULL),(2737,8433,40799,57502,3,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',0.01,NULL,NULL,1,'2023-03-13 10:32:42','2023-03-13 10:32:42',NULL),(2738,8433,40799,57502,3,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',2727.00,NULL,NULL,1,'2023-03-13 10:32:42','2023-03-27 13:35:30','2023-03-27 13:35:30'),(2739,8433,40799,57502,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',746000.00,NULL,NULL,1,'2023-03-13 10:32:42','2023-03-13 10:34:17','2023-03-13 10:34:17'),(2740,8433,40799,57502,3,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',746000.00,NULL,NULL,1,'2023-03-13 10:32:42','2023-03-13 10:34:39','2023-03-13 10:34:39'),(2741,8433,40799,57502,3,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5438.35,NULL,NULL,1,'2023-03-13 10:32:42','2023-03-13 10:32:42',NULL),(2742,8437,40877,134765,3,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',24684.10,NULL,NULL,1,'2023-03-13 10:33:26','2023-03-13 10:33:26',NULL),(2743,8433,40799,57502,3,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',112500.00,NULL,NULL,1,'2023-03-13 10:33:50','2023-03-13 10:33:50',NULL),(2744,8433,40799,57502,3,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',746000.00,NULL,NULL,1,'2023-03-13 10:34:17','2023-03-13 10:34:17',NULL),(2745,8433,40799,57502,3,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',746000.00,NULL,NULL,1,'2023-03-13 10:34:39','2023-03-13 10:34:39',NULL),(2746,8433,40799,57502,3,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9222.70,NULL,NULL,1,'2023-03-13 10:38:45','2023-03-13 10:38:45',NULL),(2747,8433,40798,55987,2,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',287148.13,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL),(2748,8433,40798,55987,2,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',172288.88,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL),(2749,8433,40798,55987,2,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',114859.25,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL),(2750,8433,40798,55987,2,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',114859.25,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL);
INSERT INTO `balance_libro` VALUES (2751,8433,40798,55987,2,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',57429.63,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL),(2752,8433,40798,55987,2,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',139507.48,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL),(2753,8433,40798,55987,2,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',232307.90,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL),(2754,8433,40798,55987,2,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',174230.93,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL),(2755,8433,40798,55987,2,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',58076.98,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL),(2756,8433,40798,55987,2,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',116153.95,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL),(2757,8433,40798,55987,2,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',63884.67,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL),(2758,8433,40798,55987,2,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',58076.98,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL),(2759,8433,40798,55987,2,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',58076.98,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL),(2760,8433,40798,55987,2,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',406538.83,NULL,NULL,1,'2023-03-13 10:45:39','2023-03-13 10:45:39',NULL),(2761,8433,40798,55987,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',44730.00,NULL,NULL,1,'2023-03-13 10:46:00','2023-03-13 10:47:34','2023-03-13 10:47:34'),(2762,8433,40798,55987,3,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',8303.00,NULL,NULL,1,'2023-03-13 10:46:00','2023-03-13 10:48:30','2023-03-13 10:48:30'),(2763,8433,40798,55987,3,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',48283.65,NULL,NULL,1,'2023-03-13 10:46:00','2023-04-13 11:51:44','2023-04-13 11:51:44'),(2764,8433,40798,55987,3,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',19822.46,NULL,NULL,1,'2023-03-13 10:46:00','2023-04-12 09:49:36','2023-04-12 09:49:36'),(2765,8433,40798,55987,3,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',5402.63,NULL,NULL,1,'2023-03-13 10:46:00','2023-03-13 10:51:43','2023-03-13 10:51:43'),(2766,8433,40798,55987,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',445704.98,NULL,NULL,1,'2023-03-13 10:46:00','2023-03-13 10:54:54','2023-03-13 10:54:54'),(2767,8433,40798,55987,3,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',105906.68,NULL,NULL,1,'2023-03-13 10:46:00','2023-04-12 10:14:36','2023-04-12 10:14:36'),(2768,8433,40798,55987,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',148835.05,NULL,NULL,1,'2023-03-13 10:46:00','2023-03-13 10:57:29','2023-03-13 10:57:29'),(2769,8437,40941,231724,3,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2999.99,NULL,NULL,1,'2023-03-13 10:46:12','2023-03-13 10:46:12',NULL),(2770,8437,40941,231724,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',16760.00,NULL,NULL,1,'2023-03-13 10:46:12','2023-03-13 10:48:42','2023-03-13 10:48:42');
INSERT INTO `balance_libro` VALUES (2771,8437,40941,231724,3,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',58699.00,NULL,NULL,1,'2023-03-13 10:46:12','2023-03-13 10:46:12',NULL),(2772,8437,40941,231724,3,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',41987.00,NULL,NULL,1,'2023-03-13 10:46:12','2023-03-13 10:46:12',NULL),(2773,8437,40941,231724,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',6232.79,NULL,NULL,1,'2023-03-13 10:46:12','2023-03-13 10:51:56','2023-03-13 10:51:56'),(2774,8437,40941,231724,3,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',11703.16,NULL,NULL,1,'2023-03-13 10:46:12','2023-03-13 10:46:12',NULL),(2775,8437,40941,231724,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',11472.83,NULL,NULL,1,'2023-03-13 10:46:12','2023-03-13 10:54:27','2023-03-13 10:54:27'),(2776,8437,40941,231724,3,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',15778.54,NULL,NULL,1,'2023-03-13 10:46:12','2023-03-13 10:55:50','2023-03-13 10:55:50'),(2777,8433,40798,55987,3,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',44730.00,NULL,NULL,1,'2023-03-13 10:47:34','2023-04-12 09:39:25','2023-04-12 09:39:25'),(2778,8433,40798,55987,3,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',8303.00,NULL,NULL,1,'2023-03-13 10:48:30','2023-04-12 09:40:30','2023-04-12 09:40:30'),(2779,8437,40941,231724,3,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',16760.00,NULL,NULL,1,'2023-03-13 10:48:42','2023-03-13 10:48:42',NULL),(2780,8433,40798,55987,3,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',5402.63,NULL,NULL,1,'2023-03-13 10:51:43','2023-04-12 09:55:56','2023-04-12 09:55:56'),(2781,8437,40941,231724,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',6082.00,NULL,NULL,1,'2023-03-13 10:51:56','2023-03-13 10:53:07','2023-03-13 10:53:07'),(2782,8437,40941,231724,3,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',6232.79,NULL,NULL,1,'2023-03-13 10:53:07','2023-03-13 10:53:07',NULL),(2783,8437,40941,231724,3,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',11472.83,NULL,NULL,1,'2023-03-13 10:54:27','2023-03-13 10:54:27',NULL),(2784,8433,40798,55987,3,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',445704.98,NULL,NULL,1,'2023-03-13 10:54:54','2023-04-12 10:10:09','2023-04-12 10:10:09'),(2785,8437,40941,231724,3,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',15778.54,NULL,NULL,1,'2023-03-13 10:55:50','2023-03-13 10:55:50',NULL),(2786,8433,40798,55987,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',148835.05,NULL,NULL,1,'2023-03-13 10:57:29','2023-03-20 15:56:46','2023-03-20 15:56:46'),(2787,8437,40941,231724,3,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',10505.09,NULL,NULL,1,'2023-03-13 11:00:03','2023-03-13 11:00:03',NULL),(2788,8437,40941,231724,3,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',14003.31,NULL,NULL,1,'2023-03-13 11:01:41','2023-03-13 11:01:41',NULL),(2789,8433,40797,52957,3,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',75000.00,NULL,NULL,1,'2023-03-13 11:10:32','2023-03-13 11:10:32',NULL),(2790,8433,40797,52957,3,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',62678.00,NULL,NULL,1,'2023-03-13 11:10:32','2023-04-19 10:50:24','2023-04-19 10:50:24');
INSERT INTO `balance_libro` VALUES (2791,8433,40797,52957,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',746000.00,NULL,NULL,1,'2023-03-13 11:10:32','2023-03-13 11:11:25','2023-03-13 11:11:25'),(2792,8433,40797,52957,3,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4650.99,NULL,NULL,1,'2023-03-13 11:10:32','2023-03-13 11:10:32',NULL),(2793,8433,40797,52957,3,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30175.22,NULL,NULL,1,'2023-03-13 11:10:32','2023-04-19 10:39:24','2023-04-19 10:39:24'),(2794,8433,40797,52957,3,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',746000.00,NULL,NULL,1,'2023-03-13 11:11:25','2023-03-13 11:11:25',NULL),(2795,8433,40797,52957,3,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7192.63,NULL,NULL,1,'2023-03-13 11:14:16','2023-03-13 11:14:16',NULL),(2796,8437,40874,130219,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3050.01,NULL,NULL,1,'2023-03-13 11:15:37','2023-03-20 14:49:27','2023-03-20 14:49:27'),(2797,8437,40874,130219,3,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3050.01,NULL,NULL,1,'2023-03-13 11:15:37','2023-03-13 11:15:37',NULL),(2798,8437,40874,130219,3,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',36466.25,NULL,NULL,1,'2023-03-13 11:15:37','2023-03-13 11:15:37',NULL),(2799,8437,40874,130219,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',98146.34,NULL,NULL,1,'2023-03-13 11:15:37','2023-03-21 13:54:55','2023-03-21 13:54:55'),(2800,8437,40874,130219,3,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',67267.61,NULL,NULL,1,'2023-03-13 11:15:37','2023-03-21 13:57:42','2023-03-21 13:57:42'),(2801,8437,40874,130219,3,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',17703.60,NULL,NULL,1,'2023-03-13 11:15:37','2023-03-21 13:58:49','2023-03-21 13:58:49'),(2802,8437,40874,130219,3,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',19274.83,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 11:37:34','2023-03-21 11:37:34'),(2803,8437,40874,130219,3,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',31097.38,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 09:58:50','2023-03-21 09:58:50'),(2804,8437,40874,130219,3,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',13072.23,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 10:00:30','2023-03-21 10:00:30'),(2805,8437,40874,130219,3,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',32018.31,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 09:57:19','2023-03-21 09:57:19'),(2806,8437,40874,130219,3,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',31411.41,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 10:03:03','2023-03-21 10:03:03'),(2807,8437,40874,130219,3,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',23463.78,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 09:59:30','2023-03-21 09:59:30'),(2808,8437,40874,130219,3,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',7879.75,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 10:00:59','2023-03-21 10:00:59'),(2809,8437,40874,130219,3,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',13017.90,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 10:02:31','2023-03-21 10:02:31');
INSERT INTO `balance_libro` VALUES (2810,8437,40874,130219,3,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',35797.81,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 10:01:51','2023-03-21 10:01:51'),(2811,8437,40874,130219,3,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',20765.11,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 09:58:14','2023-03-21 09:58:14'),(2812,8437,40874,130219,3,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',31974.40,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 09:45:23','2023-03-21 09:45:23'),(2813,8437,40874,130219,3,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',112905.60,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 11:54:51','2023-03-21 11:54:51'),(2814,8437,40874,130219,3,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',92172.19,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 09:52:46','2023-03-21 09:52:46'),(2815,8437,40874,130219,3,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',96715.65,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 09:44:18','2023-03-21 09:44:18'),(2816,8437,40874,130219,3,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',152711.35,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-13 11:15:38',NULL),(2817,8437,40874,130219,3,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',43958.86,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 11:55:43','2023-03-21 11:55:43'),(2818,8437,40874,130219,3,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',16611.01,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 11:38:45','2023-03-21 11:38:45'),(2819,8437,40874,130219,3,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',31202.57,NULL,NULL,1,'2023-03-13 11:15:38','2023-03-21 11:38:09','2023-03-21 11:38:09'),(2820,8437,40874,130219,3,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',75174.19,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL),(2821,8437,40874,130219,3,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',34979.76,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-21 13:04:23','2023-03-21 13:04:23'),(2822,8437,40874,130219,3,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',20412.02,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-21 11:39:22','2023-03-21 11:39:22'),(2823,8437,40874,130219,3,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',11650.72,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL),(2824,8437,40874,130219,3,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',45120.20,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL),(2825,8437,40874,130219,3,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',25119.90,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL),(2826,8437,40874,130219,3,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',14580.22,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL),(2827,8437,40874,130219,3,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',31686.89,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL),(2828,8437,40874,130219,3,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',44539.31,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL);
INSERT INTO `balance_libro` VALUES (2829,8437,40874,130219,3,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',153197.37,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL),(2830,8437,40874,130219,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',41518.58,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-21 12:01:24','2023-03-21 12:01:24'),(2831,8437,40874,130219,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',7279.72,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-21 12:01:54','2023-03-21 12:01:54'),(2832,8437,40874,130219,3,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',64079.61,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL),(2833,8437,40874,130219,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',15652.81,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-21 11:39:57','2023-03-21 11:39:57'),(2834,8437,40874,130219,3,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',21051.00,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL),(2835,8437,40874,130219,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',38365.52,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-21 12:51:05','2023-03-21 12:51:05'),(2836,8437,40874,130219,3,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',23898.44,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL),(2837,8437,40874,130219,3,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',29673.45,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL),(2838,8437,40874,130219,3,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',143655.56,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL),(2839,8437,40874,130219,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',51321.60,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-21 12:33:42','2023-03-21 12:33:42'),(2840,8437,40874,130219,3,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1621.95,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-13 11:15:39',NULL),(2841,8437,40874,130219,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',30544.42,NULL,NULL,1,'2023-03-13 11:15:39','2023-03-21 12:25:19','2023-03-21 12:25:19'),(2842,8437,40874,130219,3,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',77793.80,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-13 11:15:40',NULL),(2843,8437,40874,130219,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',171535.08,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 09:52:15','2023-03-21 09:52:15'),(2844,8437,40874,130219,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',93997.21,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 09:51:49','2023-03-21 09:51:49'),(2845,8437,40874,130219,3,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',29687.70,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-13 11:15:40',NULL),(2846,8437,40874,130219,3,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',13763.68,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-13 11:15:40',NULL),(2847,8437,40874,130219,3,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',39086.45,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-13 11:15:40',NULL),(2848,8437,40874,130219,3,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',22158.38,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-13 11:15:40',NULL);
INSERT INTO `balance_libro` VALUES (2849,8437,40874,130219,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',68328.70,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 09:51:18','2023-03-21 09:51:18'),(2850,8437,40874,130219,3,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',33195.90,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-13 11:15:40',NULL),(2851,8437,40874,130219,3,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',33569.31,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-13 11:15:40',NULL),(2852,8437,40874,130219,3,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',35640.65,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 11:40:33','2023-03-21 11:40:33'),(2853,8437,40874,130219,3,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',70975.37,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-13 11:15:40',NULL),(2854,8437,40874,130219,3,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3252.62,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-13 11:15:40',NULL),(2855,8437,40874,130219,3,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1194.40,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 12:33:06','2023-03-21 12:33:06'),(2856,8437,40874,130219,3,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',27248.52,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 13:33:16','2023-03-21 13:33:16'),(2857,8437,40874,130219,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',77437.42,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 13:32:25','2023-03-21 13:32:25'),(2858,8437,40874,130219,3,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',929.01,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-13 11:15:40',NULL),(2859,8437,40874,130219,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',41922.27,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 09:50:29','2023-03-21 09:50:29'),(2860,8437,40874,130219,3,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',11339.90,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 09:50:04','2023-03-21 09:50:04'),(2861,8437,40874,130219,3,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',34332.99,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 09:46:32','2023-03-21 09:46:32'),(2862,8437,40874,130219,3,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',89775.50,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-13 11:15:40',NULL),(2863,8437,40874,130219,3,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',37921.10,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 10:04:26','2023-03-21 10:04:26'),(2864,8437,40874,130219,3,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',76057.83,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 10:07:41','2023-03-21 10:07:41'),(2865,8437,40874,130219,3,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3086.71,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 10:09:50','2023-03-21 10:09:50'),(2866,8437,40874,130219,3,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',31316.27,NULL,NULL,1,'2023-03-13 11:15:40','2023-03-21 10:09:03','2023-03-21 10:09:03'),(2867,8437,40874,130219,3,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',79792.48,NULL,NULL,1,'2023-03-13 11:15:41','2023-03-21 10:06:19','2023-03-21 10:06:19');
INSERT INTO `balance_libro` VALUES (2868,8437,40874,130219,3,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3627.74,NULL,NULL,1,'2023-03-13 11:15:41','2023-03-21 10:06:54','2023-03-21 10:06:54'),(2869,8437,40874,130219,3,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',434.13,NULL,NULL,1,'2023-03-13 11:15:41','2023-03-13 11:15:41',NULL),(2870,8437,40874,130219,3,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',57881.60,NULL,NULL,1,'2023-03-13 11:15:41','2023-03-21 12:24:26','2023-03-21 12:24:26'),(2871,8437,40874,130219,3,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7005.74,NULL,NULL,1,'2023-03-13 11:15:41','2023-03-21 09:45:50','2023-03-21 09:45:50'),(2872,8437,40874,130219,3,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',73530.41,NULL,NULL,1,'2023-03-13 11:15:41','2023-03-13 11:15:41',NULL),(2873,8437,40874,130219,3,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',21907.75,NULL,NULL,1,'2023-03-13 11:15:41','2023-03-13 11:15:41',NULL),(2874,8437,40874,130219,3,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',35485.27,NULL,NULL,1,'2023-03-13 11:15:41','2023-03-21 11:41:01','2023-03-21 11:41:01'),(2875,8437,40874,130219,2,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',110001.10,NULL,NULL,1,'2023-03-13 11:17:01','2023-03-21 13:12:16','2023-03-21 13:12:16'),(2876,8437,40874,130219,2,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',81070.00,NULL,NULL,1,'2023-03-13 11:17:01','2023-03-13 11:17:01',NULL),(2877,8437,40874,130219,2,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',120879.00,NULL,NULL,1,'2023-03-13 11:17:01','2023-03-13 11:17:01',NULL),(2878,8433,40869,125676,16,297,'App\\Models\\PeriodLiquidation',NULL,297,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-03-13 11:27:30','2023-04-11 09:20:40','2023-04-11 09:20:40'),(2879,8433,40869,125677,16,1060,'App\\Models\\PeriodLiquidation',NULL,1060,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-03-13 11:28:41','2023-04-11 09:21:24','2023-04-11 09:21:24'),(2880,8433,40869,125676,15,296,'App\\Models\\PeriodLiquidation',NULL,296,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-03-13 11:29:36','2023-04-11 09:21:15','2023-04-11 09:21:15'),(2881,8437,40874,130219,3,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',46367.29,NULL,NULL,1,'2023-03-13 11:32:36','2023-03-21 12:43:17','2023-03-21 12:43:17'),(2882,8437,40874,130219,3,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',12301.03,NULL,NULL,1,'2023-03-13 11:34:35','2023-03-13 11:34:35',NULL),(2883,8437,40874,130219,3,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',25529.00,NULL,NULL,1,'2023-03-13 11:37:33','2023-03-13 11:37:33',NULL),(2884,8434,40724,7531,8,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',2129.25,NULL,NULL,1,'2023-03-13 11:38:04','2023-03-13 11:38:04',NULL),(2885,8434,40724,7531,8,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',87.35,NULL,NULL,1,'2023-03-13 11:38:04','2023-03-13 11:38:04',NULL),(2886,8437,40874,130219,3,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1704.07,NULL,NULL,1,'2023-03-13 11:38:41','2023-03-13 11:38:41',NULL),(2887,8437,40874,130219,3,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',11822.32,NULL,NULL,1,'2023-03-13 11:40:09','2023-03-13 11:40:09',NULL);
INSERT INTO `balance_libro` VALUES (2888,8437,40874,130219,3,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',5403.22,NULL,NULL,1,'2023-03-13 11:41:12','2023-03-13 11:41:12',NULL),(2889,8437,40796,51442,3,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1189.07,NULL,NULL,1,'2023-03-13 12:16:39','2023-03-13 12:16:39',NULL),(2890,8437,41082,434734,3,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3445.63,NULL,NULL,1,'2023-03-13 12:33:56','2023-03-13 12:33:56',NULL),(2891,8437,41082,434734,3,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',12020.29,NULL,NULL,1,'2023-03-13 12:37:16','2023-03-13 12:37:16',NULL),(2892,8437,41082,434734,3,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',14933.48,NULL,NULL,1,'2023-03-13 12:39:03','2023-03-13 12:39:03',NULL),(2893,8437,41082,434735,3,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',4400.00,NULL,NULL,1,'2023-03-13 12:42:38','2023-03-13 12:42:38',NULL),(2894,8437,41082,434735,3,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',6500.10,NULL,NULL,1,'2023-03-13 12:44:10','2023-03-13 12:44:10',NULL),(2895,8437,41082,434735,3,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',600.00,NULL,NULL,1,'2023-03-13 12:44:54','2023-03-13 12:44:54',NULL),(2896,8433,40724,7531,2,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',166496.00,NULL,NULL,1,'2023-03-13 12:47:22','2023-03-13 12:47:22',NULL),(2897,8433,40724,7531,2,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',233094.40,NULL,NULL,1,'2023-03-13 12:47:22','2023-03-13 12:47:22',NULL),(2898,8433,40724,7531,2,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',51328.20,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2899,8433,40724,7531,2,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',127050.00,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2900,8433,40724,7531,2,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',78976.70,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2901,8433,40724,7531,2,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',195052.00,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2902,8433,40724,7531,2,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',60258.00,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2903,8433,40724,7531,2,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',105754.00,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2904,8433,40724,7531,2,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',34727.00,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2905,8433,40724,7531,2,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',102136.10,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2906,8433,40724,7531,2,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',20150.00,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2907,8433,40724,7531,2,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',20150.00,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2908,8433,40724,7531,2,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',160954.20,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL);
INSERT INTO `balance_libro` VALUES (2909,8433,40724,7531,2,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',126596.25,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2910,8433,40724,7531,2,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',122694.00,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2911,8433,40724,7531,2,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',41858.44,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2912,8433,40724,7531,2,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',111320.00,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2913,8433,40724,7531,2,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',22880.00,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-20 14:59:16','2023-03-20 14:59:16'),(2914,8433,40724,7531,2,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',57632.30,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2915,8433,40724,7531,2,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',208180.50,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2916,8433,40724,7531,2,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',90205.50,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2917,8433,40724,7531,2,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',7502.00,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-13 12:47:23',NULL),(2918,8433,40724,7531,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',255855.00,NULL,NULL,1,'2023-03-13 12:47:23','2023-03-20 14:51:27','2023-03-20 14:51:27'),(2919,8433,40724,7531,3,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3050.01,NULL,NULL,1,'2023-03-13 12:48:40','2023-04-12 11:46:03','2023-04-12 11:46:03'),(2920,8433,40724,7531,3,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',100151.90,NULL,NULL,1,'2023-03-13 12:48:40','2023-03-13 12:50:04','2023-03-13 12:50:04'),(2921,8433,40724,7531,3,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3050.01,NULL,NULL,1,'2023-03-13 12:48:40','2023-04-12 11:45:40','2023-04-12 11:45:40'),(2922,8433,40724,7531,3,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',61893.90,NULL,NULL,1,'2023-03-13 12:48:40','2023-03-13 12:50:51','2023-03-13 12:50:51'),(2923,8433,40724,7531,3,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',145224.20,NULL,NULL,1,'2023-03-13 12:48:40','2023-04-12 13:20:14','2023-04-12 13:20:14'),(2924,8433,40724,7531,3,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',26236.25,NULL,NULL,1,'2023-03-13 12:48:40','2023-04-13 11:59:40','2023-04-13 11:59:40'),(2925,8433,40724,7531,3,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',134540.00,NULL,NULL,1,'2023-03-13 12:48:40','2023-03-13 12:55:11','2023-03-13 12:55:11'),(2926,8433,40724,7531,3,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',19760.00,NULL,NULL,1,'2023-03-13 12:48:40','2023-04-12 12:58:01','2023-04-12 12:58:01'),(2927,8433,40724,7531,3,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',52453.90,NULL,NULL,1,'2023-03-13 12:48:40','2023-03-13 12:55:52','2023-03-13 12:55:52'),(2928,8433,40724,7531,3,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',20812.00,NULL,NULL,1,'2023-03-13 12:48:40','2023-04-12 13:03:11','2023-04-12 13:03:11');
INSERT INTO `balance_libro` VALUES (2929,8433,40724,7531,3,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',52453.90,NULL,NULL,1,'2023-03-13 12:48:40','2023-03-13 12:56:31','2023-03-13 12:56:31'),(2930,8433,40724,7531,3,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',4960.00,NULL,NULL,1,'2023-03-13 12:48:40','2023-04-13 12:01:55','2023-04-13 12:01:55'),(2931,8433,40724,7531,3,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',125.14,NULL,NULL,1,'2023-03-13 12:48:40','2023-03-13 12:57:39','2023-03-13 12:57:39'),(2932,8433,40724,7531,3,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',258.00,NULL,NULL,1,'2023-03-13 12:48:40','2023-04-13 10:47:05','2023-04-13 10:47:05'),(2933,8433,40724,7531,3,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',4050.00,NULL,NULL,1,'2023-03-13 12:48:40','2023-03-13 12:58:38','2023-03-13 12:58:38'),(2934,8433,40724,7531,3,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',3100.00,NULL,NULL,1,'2023-03-13 12:48:40','2023-04-12 13:13:34','2023-04-12 13:13:34'),(2935,8433,40724,7531,3,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',9746.54,NULL,NULL,1,'2023-03-13 12:48:40','2023-03-13 13:00:37','2023-03-13 13:00:37'),(2936,8433,40724,7531,3,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',128480.00,NULL,NULL,1,'2023-03-13 12:48:41','2023-04-13 12:43:50','2023-04-13 12:43:50'),(2937,8433,40724,7531,3,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',29890.00,NULL,NULL,1,'2023-03-13 12:48:41','2023-04-13 12:46:58','2023-04-13 12:46:58'),(2938,8433,40724,7531,3,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',148662.27,NULL,NULL,1,'2023-03-13 12:48:41','2023-03-13 13:01:07','2023-03-13 13:01:07'),(2939,8433,40724,7531,3,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',76200.00,NULL,NULL,1,'2023-03-13 12:48:41','2023-03-13 13:01:34','2023-03-13 13:01:34'),(2940,8433,40724,7531,3,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',124006.16,NULL,NULL,1,'2023-03-13 12:48:41','2023-03-13 13:02:03','2023-03-13 13:02:03'),(2941,8433,40724,7531,3,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',11000.00,NULL,NULL,1,'2023-03-13 12:48:41','2023-03-13 13:02:22','2023-03-13 13:02:22'),(2942,8433,40724,7531,3,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',161529.31,NULL,NULL,1,'2023-03-13 12:48:41','2023-03-13 13:02:47','2023-03-13 13:02:47'),(2943,8433,40724,7531,3,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',147408.16,NULL,NULL,1,'2023-03-13 12:48:41','2023-03-13 13:03:25','2023-03-13 13:03:25'),(2944,8433,40724,7531,3,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',12000.01,NULL,NULL,1,'2023-03-13 12:48:41','2023-04-13 11:54:48','2023-04-13 11:54:48'),(2945,8433,40724,7531,3,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',154932.00,NULL,NULL,1,'2023-03-13 12:48:41','2023-03-13 13:03:50','2023-03-13 13:03:50'),(2946,8433,40724,7531,3,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',100151.90,NULL,NULL,1,'2023-03-13 12:50:04','2023-04-12 11:49:58','2023-04-12 11:49:58'),(2947,8433,40724,7531,3,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',61893.90,NULL,NULL,1,'2023-03-13 12:50:51','2023-04-12 11:52:28','2023-04-12 11:52:28');
INSERT INTO `balance_libro` VALUES (2948,8437,41734,755908,2,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',12420.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2949,8437,41734,755908,2,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',14580.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2950,8437,41734,755908,2,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',20250.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2951,8437,41734,755908,2,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',14300.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2952,8437,41734,755908,2,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2953,8437,41734,755908,2,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',13140.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2954,8437,41734,755908,2,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',35100.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2955,8437,41734,755908,2,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',2400.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2956,8437,41734,755908,2,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4000.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2957,8437,41734,755908,2,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',10000.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2958,8437,41734,755908,2,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',20000.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2959,8437,41734,755908,2,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',27850.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2960,8437,41734,755908,2,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',27960.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2961,8437,41734,755908,2,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',20000.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2962,8437,41734,755908,2,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',10000.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2963,8437,41734,755908,2,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',30000.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2964,8437,41734,755908,2,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',40000.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2965,8437,41734,755908,2,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',16000.00,NULL,NULL,1,'2023-03-13 12:52:04','2023-03-13 12:52:04',NULL),(2966,8437,41734,755908,2,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',4000.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2967,8437,41734,755908,2,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',14350.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL);
INSERT INTO `balance_libro` VALUES (2968,8437,41734,755908,2,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',19400.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2969,8437,41734,755908,2,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',4000.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2970,8437,41734,755908,2,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',4000.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2971,8437,41734,755908,2,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',30000.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2972,8437,41734,755908,2,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',3050.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2973,8437,41734,755908,2,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',30000.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2974,8437,41734,755908,2,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',15570.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2975,8437,41734,755908,2,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',6300.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2976,8437,41734,755908,2,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',11430.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2977,8437,41734,755908,2,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',17300.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2978,8437,41734,755908,2,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',18500.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2979,8437,41734,755908,2,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1800.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2980,8437,41734,755908,2,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',34000.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2981,8437,41734,755908,2,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',15930.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2982,8437,41734,755908,2,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',24435.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2983,8437,41734,755908,2,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',15300.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2984,8437,41734,755908,2,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',42000.00,NULL,NULL,1,'2023-03-13 12:52:05','2023-03-13 12:52:05',NULL),(2985,8437,41734,755908,2,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',17100.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(2986,8437,41734,755908,2,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',2100.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(2987,8437,41734,755908,2,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',6800.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL);
INSERT INTO `balance_libro` VALUES (2988,8437,41734,755908,2,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',22500.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(2989,8437,41734,755908,2,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',18180.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(2990,8437,41734,755908,2,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',7110.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(2991,8437,41734,755908,2,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',16550.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(2992,8437,41734,755908,2,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',18500.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(2993,8437,41734,755908,2,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',24650.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(2994,8437,41734,755908,2,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',28575.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(2995,8437,41734,755908,2,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',24525.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(2996,8437,41734,755908,2,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',800.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(2997,8437,41734,755908,2,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',41895.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(2998,8437,41734,755908,2,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',7800.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(2999,8437,41734,755908,2,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',9800.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(3000,8437,41734,755908,2,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',20000.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(3001,8437,41734,755908,2,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',29700.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(3002,8437,41734,755908,2,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',19350.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(3003,8437,41734,755908,2,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',46500.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(3004,8437,41734,755908,2,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',45600.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(3005,8437,41734,755908,2,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3550.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(3006,8437,41734,755908,2,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',24030.00,NULL,NULL,1,'2023-03-13 12:52:06','2023-03-13 12:52:06',NULL),(3007,8437,41734,755908,2,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',10200.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL);
INSERT INTO `balance_libro` VALUES (3008,8437,41734,755908,2,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',16100.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3009,8437,41734,755908,2,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',3800.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3010,8437,41734,755908,2,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',24000.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3011,8437,41734,755908,2,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',4320.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3012,8437,41734,755908,2,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',3300.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3013,8437,41734,755908,2,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',28305.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3014,8437,41734,755908,2,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',34560.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3015,8437,41734,755908,2,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',2400.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3016,8437,41734,755908,2,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',14850.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3017,8437,41734,755908,2,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',44100.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3018,8437,41734,755908,2,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',5400.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3019,8437,41734,755908,2,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1500.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3020,8437,41734,755908,2,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',2000.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3021,8437,41734,755908,2,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',16100.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3022,8437,41734,755908,2,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',19000.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3023,8437,41734,755908,2,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',32650.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3024,8437,41734,755908,2,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',11600.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3025,8437,41734,755908,2,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',24000.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3026,8437,41734,755908,2,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',27200.00,NULL,NULL,1,'2023-03-13 12:52:07','2023-03-13 12:52:07',NULL),(3027,8437,41734,755908,2,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',14300.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL);
INSERT INTO `balance_libro` VALUES (3028,8437,41734,755908,2,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',13000.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3029,8437,41734,755908,2,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1200.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3030,8437,41734,755908,2,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',12000.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3031,8437,41734,755908,2,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',12100.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3032,8437,41734,755908,2,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',20130.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3033,8437,41734,755908,2,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',21300.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3034,8437,41734,755908,2,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',13700.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3035,8437,41734,755908,2,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',20130.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3036,8437,41734,755908,2,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5000.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3037,8437,41734,755908,2,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',12800.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3038,8437,41734,755908,2,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',42200.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3039,8437,41734,755908,2,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',9100.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3040,8437,41734,755908,2,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1200.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3041,8437,41734,755908,2,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',6000.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3042,8437,41734,755908,2,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',6000.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3043,8437,41734,755908,2,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',14100.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3044,8437,41734,755908,2,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',43350.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3045,8437,41734,755908,2,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',29800.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3046,8437,41734,755908,2,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',5000.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3047,8437,41734,755908,2,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',29800.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL);
INSERT INTO `balance_libro` VALUES (3048,8437,41734,755908,2,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',29800.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3049,8437,41734,755908,2,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',13800.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3050,8437,41734,755908,2,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',27200.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3051,8437,41734,755908,2,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',30000.00,NULL,NULL,1,'2023-03-13 12:52:08','2023-03-13 12:52:08',NULL),(3052,8437,41734,755908,2,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',15000.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3053,8437,41734,755908,2,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',45000.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3054,8437,41734,755908,2,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',30000.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3055,8437,41734,755908,2,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',12250.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3056,8437,41734,755908,2,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',17600.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3057,8437,41734,755908,2,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',10000.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3058,8437,41734,755908,2,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',19550.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3059,8437,41734,755908,2,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',19350.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3060,8437,41734,755908,2,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',15450.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3061,8437,41734,755908,2,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',14000.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3062,8437,41734,755908,2,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',10000.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3063,8437,41734,755908,2,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',10000.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3064,8437,41734,755908,2,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',10800.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3065,8437,41734,755908,2,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',8955.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3066,8437,41734,755908,2,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',18400.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3067,8437,41734,755908,2,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',43950.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL);
INSERT INTO `balance_libro` VALUES (3068,8437,41734,755908,2,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',11300.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3069,8437,41734,755908,2,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',33850.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3070,8437,41734,755908,2,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',37800.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3071,8437,41734,755908,2,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',29900.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3072,8437,41734,755908,2,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',22900.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3073,8437,41734,755908,2,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',26700.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3074,8437,41734,755908,2,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',30850.00,NULL,NULL,1,'2023-03-13 12:52:09','2023-03-13 12:52:09',NULL),(3075,8437,41734,755908,2,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',29750.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3076,8437,41734,755908,2,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',26950.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3077,8437,41734,755908,2,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',26950.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3078,8437,41734,755908,2,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',26950.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3079,8437,41734,755908,2,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',26950.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3080,8437,41734,755908,2,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',26950.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3081,8437,41734,755908,2,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',26950.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3082,8437,41734,755908,2,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',3000.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3083,8437,41734,755908,2,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',16000.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3084,8437,41734,755908,2,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',44100.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3085,8437,41734,755908,2,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',6900.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3086,8437,41734,755908,2,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',15650.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3087,8437,41734,755908,2,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',25200.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL);
INSERT INTO `balance_libro` VALUES (3088,8437,41734,755908,2,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',11000.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3089,8437,41734,755908,2,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',27100.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3090,8437,41734,755908,2,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',48050.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3091,8437,41734,755908,2,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',26950.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3092,8437,41734,755908,2,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',26950.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3093,8437,41734,755908,2,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',26950.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3094,8437,41734,755908,2,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',26950.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3095,8437,41734,755908,2,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',26950.00,NULL,NULL,1,'2023-03-13 12:52:10','2023-03-13 12:52:10',NULL),(3096,8437,41734,755908,2,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',17200.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3097,8437,41734,755908,2,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',39450.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3098,8437,41734,755908,2,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',7200.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3099,8437,41734,755908,2,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',51550.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3100,8437,41734,755908,2,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',21562.50,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3101,8437,41734,755908,2,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',24100.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3102,8437,41734,755908,2,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',23450.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3103,8437,41734,755908,2,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',25000.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3104,8437,41734,755908,2,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',26100.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3105,8437,41734,755908,2,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',18050.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3106,8437,41734,755908,2,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',18150.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3107,8437,41734,755908,2,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',40950.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL);
INSERT INTO `balance_libro` VALUES (3108,8437,41734,755908,2,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',3400.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3109,8437,41734,755908,2,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1200.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3110,8437,41734,755908,2,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',2100.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3111,8437,41734,755908,2,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',4200.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3112,8437,41734,755908,2,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',12200.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3113,8437,41734,755908,2,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',16750.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3114,8437,41734,755908,2,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',24400.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3115,8437,41734,755908,2,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',22800.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3116,8437,41734,755908,2,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3600.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3117,8437,41734,755908,2,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',10700.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3118,8437,41734,755908,2,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1800.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3119,8437,41734,755908,2,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',11400.00,NULL,NULL,1,'2023-03-13 12:52:11','2023-03-13 12:52:11',NULL),(3120,8437,41734,755908,2,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3800.00,NULL,NULL,1,'2023-03-13 12:52:12','2023-03-13 12:52:12',NULL),(3121,8437,41734,755908,2,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',25550.00,NULL,NULL,1,'2023-03-13 12:52:12','2023-03-13 12:52:12',NULL),(3122,8437,41734,755908,2,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',750.00,NULL,NULL,1,'2023-03-13 12:52:12','2023-03-13 12:52:12',NULL),(3123,8437,41734,755908,2,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',16700.00,NULL,NULL,1,'2023-03-13 12:52:12','2023-03-13 12:52:12',NULL),(3124,8437,41734,755908,2,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',18900.00,NULL,NULL,1,'2023-03-13 12:52:12','2023-03-13 12:52:12',NULL),(3125,8437,41734,755908,2,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',25700.00,NULL,NULL,1,'2023-03-13 12:52:12','2023-03-13 12:52:12',NULL),(3126,8437,41734,755908,2,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',21900.00,NULL,NULL,1,'2023-03-13 12:52:12','2023-03-13 12:52:12',NULL),(3127,8437,41734,755908,2,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',32600.00,NULL,NULL,1,'2023-03-13 12:52:12','2023-03-13 12:52:12',NULL);
INSERT INTO `balance_libro` VALUES (3128,8437,41734,755908,2,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',32400.00,NULL,NULL,1,'2023-03-13 12:52:12','2023-03-13 12:52:12',NULL),(3129,8437,41734,755908,2,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',16400.00,NULL,NULL,1,'2023-03-13 12:52:12','2023-03-15 09:51:45','2023-03-15 09:51:45'),(3130,8437,41734,755908,3,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',23943.56,NULL,NULL,1,'2023-03-13 12:52:26','2023-03-13 12:52:26',NULL),(3131,8437,41734,755908,3,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2935.46,NULL,NULL,1,'2023-03-13 12:52:26','2023-03-13 12:52:26',NULL),(3132,8437,41734,755908,3,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',9276.22,NULL,NULL,1,'2023-03-13 12:52:26','2023-03-13 12:55:46','2023-03-13 12:55:46'),(3133,8437,41734,755908,3,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',77716.97,NULL,NULL,1,'2023-03-13 12:52:26','2023-03-13 12:52:26',NULL),(3134,8437,41734,755908,3,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',43789.14,NULL,NULL,1,'2023-03-13 12:52:26','2023-03-13 12:52:26',NULL),(3135,8437,41734,755908,3,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',23040.12,NULL,NULL,1,'2023-03-13 12:52:26','2023-03-13 12:52:26',NULL),(3136,8437,41734,755908,3,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',9487.44,NULL,NULL,1,'2023-03-13 12:52:26','2023-03-13 12:52:26',NULL),(3137,8437,41734,755908,3,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',17580.00,NULL,NULL,1,'2023-03-13 12:52:26','2023-03-13 12:52:26',NULL),(3138,8437,41734,755908,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',21985.70,NULL,NULL,1,'2023-03-13 12:52:26','2023-03-13 12:52:26',NULL),(3139,8437,41734,755908,3,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',220459.70,NULL,NULL,1,'2023-03-13 12:52:26','2023-03-13 12:52:26',NULL),(3140,8437,41734,755908,3,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',220459.70,NULL,NULL,1,'2023-03-13 12:52:26','2023-03-13 12:52:26',NULL),(3141,8437,41734,755908,3,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',198559.91,NULL,NULL,1,'2023-03-13 12:52:26','2023-03-13 12:52:26',NULL),(3142,8437,41734,755908,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',106148.06,NULL,NULL,1,'2023-03-13 12:52:26','2023-03-13 12:58:30','2023-03-13 12:58:30'),(3143,8437,41734,755908,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',28745.89,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 13:00:46','2023-03-13 13:00:46'),(3144,8437,41734,755908,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',17987.77,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3145,8437,41734,755908,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',11616.00,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3146,8437,41734,755908,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',55272.80,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3147,8437,41734,755908,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',13166.36,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL);
INSERT INTO `balance_libro` VALUES (3148,8437,41734,755908,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',24747.77,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 13:03:24','2023-03-13 13:03:24'),(3149,8437,41734,755908,3,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',22082.50,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3150,8437,41734,755908,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',15706.02,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 13:05:47','2023-03-13 13:05:47'),(3151,8437,41734,755908,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',35169.66,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 13:07:25','2023-03-13 13:07:25'),(3152,8437,41734,755908,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',37824.60,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3153,8437,41734,755908,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',22559.80,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 13:08:44','2023-03-13 13:08:44'),(3154,8437,41734,755908,3,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',9090.42,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3155,8437,41734,755908,3,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',4545.21,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3156,8437,41734,755908,3,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',4545.21,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3157,8437,41734,755908,3,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',25616.01,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 13:10:00','2023-03-13 13:10:00'),(3158,8437,41734,755908,3,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',18392.00,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3159,8437,41734,755908,3,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',2000.98,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3160,8437,41734,755908,3,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',48992.90,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3161,8437,41734,755908,3,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',26136.00,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3162,8437,41734,755908,3,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',4840.00,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3163,8437,41734,755908,3,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',14762.00,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 12:52:27',NULL),(3164,8437,41734,755908,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',34447.55,NULL,NULL,1,'2023-03-13 12:52:27','2023-03-13 13:12:18','2023-03-13 13:12:18'),(3165,8437,41734,755908,3,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',62436.00,NULL,NULL,1,'2023-03-13 12:52:28','2023-03-13 12:52:28',NULL),(3166,8437,41734,755908,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',29376.76,NULL,NULL,1,'2023-03-13 12:52:28','2023-03-13 13:15:14','2023-03-13 13:15:14'),(3167,8437,41734,755908,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',29376.76,NULL,NULL,1,'2023-03-13 12:52:28','2023-03-13 13:19:05','2023-03-13 13:19:05');
INSERT INTO `balance_libro` VALUES (3168,8437,41734,755908,3,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',17474.14,NULL,NULL,1,'2023-03-13 12:52:28','2023-03-13 12:52:28',NULL),(3169,8437,41734,755908,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',49814.89,NULL,NULL,1,'2023-03-13 12:52:28','2023-03-13 13:21:42','2023-03-13 13:21:42'),(3170,8437,41734,755908,3,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',17474.14,NULL,NULL,1,'2023-03-13 12:52:28','2023-03-13 12:52:28',NULL),(3171,8437,41734,755908,3,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',49814.89,NULL,NULL,1,'2023-03-13 12:52:28','2023-03-17 11:58:42','2023-03-17 11:58:42'),(3172,8437,41734,755908,3,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',16552.80,NULL,NULL,1,'2023-03-13 12:52:28','2023-03-13 12:52:28',NULL),(3173,8437,41734,755908,3,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',117819.88,NULL,NULL,1,'2023-03-13 12:52:28','2023-03-13 12:52:28',NULL),(3174,8437,41734,755908,3,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',8900.00,NULL,NULL,1,'2023-03-13 12:52:28','2023-03-13 12:52:28',NULL),(3175,8437,41734,755908,3,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',13624.60,NULL,NULL,1,'2023-03-13 12:52:28','2023-03-13 12:52:28',NULL),(3176,8433,40724,7531,3,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',134540.00,NULL,NULL,1,'2023-03-13 12:55:11','2023-04-12 11:43:37','2023-04-12 11:43:37'),(3177,8437,41734,755908,3,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',9276.22,NULL,NULL,1,'2023-03-13 12:55:46','2023-03-17 11:14:43','2023-03-17 11:14:43'),(3178,8433,40724,7531,3,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',52453.90,NULL,NULL,1,'2023-03-13 12:55:52','2023-04-12 12:59:42','2023-04-12 12:59:42'),(3179,8433,40724,7531,3,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',52453.90,NULL,NULL,1,'2023-03-13 12:56:31','2023-04-12 13:00:05','2023-04-12 13:00:05'),(3180,8433,40724,7531,3,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',125.14,NULL,NULL,1,'2023-03-13 12:57:39','2023-04-13 12:34:56','2023-04-13 12:34:56'),(3181,8437,41734,755908,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',106148.05,NULL,NULL,1,'2023-03-13 12:58:30','2023-03-13 12:58:30',NULL),(3182,8433,40724,7531,3,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',4050.00,NULL,NULL,1,'2023-03-13 12:58:38','2023-04-12 13:10:25','2023-04-12 13:10:25'),(3183,8433,40724,7531,3,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',9746.53,NULL,NULL,1,'2023-03-13 13:00:37','2023-03-20 14:27:01','2023-03-20 14:27:01'),(3184,8437,41734,755908,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',28745.89,NULL,NULL,1,'2023-03-13 13:00:46','2023-03-17 11:25:17','2023-03-17 11:25:17'),(3185,8433,40724,7531,3,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',148662.27,NULL,NULL,1,'2023-03-13 13:01:07','2023-04-13 11:40:36','2023-04-13 11:40:36'),(3186,8433,40724,7531,3,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',76200.00,NULL,NULL,1,'2023-03-13 13:01:34','2023-04-13 11:42:47','2023-04-13 11:42:47');
INSERT INTO `balance_libro` VALUES (3187,8433,40724,7531,3,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',124006.16,NULL,NULL,1,'2023-03-13 13:02:03','2023-04-13 11:47:00','2023-04-13 11:47:00'),(3188,8433,40724,7531,3,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',11000.00,NULL,NULL,1,'2023-03-13 13:02:22','2023-04-13 11:47:22','2023-04-13 11:47:22'),(3189,8433,40724,7531,3,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',161529.31,NULL,NULL,1,'2023-03-13 13:02:47','2023-04-13 11:50:13','2023-04-13 11:50:13'),(3190,8437,41734,755908,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',24747.78,NULL,NULL,1,'2023-03-13 13:03:24','2023-03-17 11:42:03','2023-03-17 11:42:03'),(3191,8433,40724,7531,3,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',147408.16,NULL,NULL,1,'2023-03-13 13:03:25','2023-04-13 11:52:09','2023-04-13 11:52:09'),(3192,8433,40724,7531,3,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',154932.00,NULL,NULL,1,'2023-03-13 13:03:50','2023-04-13 11:57:42','2023-04-13 11:57:42'),(3193,8437,41734,755908,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',15706.02,NULL,NULL,1,'2023-03-13 13:05:47','2023-03-17 11:46:16','2023-03-17 11:46:16'),(3194,8437,41734,755908,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',35169.65,NULL,NULL,1,'2023-03-13 13:07:25','2023-03-17 11:47:36','2023-03-17 11:47:36'),(3195,8433,40724,7531,3,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',5600.00,NULL,NULL,1,'2023-03-13 13:07:32','2023-05-08 11:37:44','2023-05-08 11:37:44'),(3196,8437,41734,755908,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',22559.80,NULL,NULL,1,'2023-03-13 13:08:44','2023-03-17 11:50:52','2023-03-17 11:50:52'),(3197,8437,41734,755908,3,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',25616.01,NULL,NULL,1,'2023-03-13 13:10:00','2023-03-17 11:52:05','2023-03-17 11:52:05'),(3198,8437,41734,755908,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',34447.55,NULL,NULL,1,'2023-03-13 13:12:18','2023-03-17 11:53:07','2023-03-17 11:53:07'),(3199,8433,40724,7531,3,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',10000.00,NULL,NULL,1,'2023-03-13 13:14:48','2023-05-08 11:35:25','2023-05-08 11:35:25'),(3200,8437,41734,755908,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',29376.76,NULL,NULL,1,'2023-03-13 13:15:14','2023-03-17 11:54:24','2023-03-17 11:54:24'),(3201,8433,40724,7531,3,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',15563.98,NULL,NULL,1,'2023-03-13 13:16:24','2023-05-08 11:35:09','2023-05-08 11:35:09'),(3202,8433,40724,7531,3,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',10000.00,NULL,NULL,1,'2023-03-13 13:18:25','2023-05-08 11:34:47','2023-05-08 11:34:47'),(3203,8437,41734,755908,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',29376.75,NULL,NULL,1,'2023-03-13 13:19:05','2023-03-17 11:56:05','2023-03-17 11:56:05'),(3204,8433,40724,7531,3,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3500.00,NULL,NULL,1,'2023-03-13 13:21:19','2023-05-08 11:44:39','2023-05-08 11:44:39'),(3205,8437,41734,755908,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',49814.89,NULL,NULL,1,'2023-03-13 13:21:42','2023-03-17 11:57:16','2023-03-17 11:57:16');
INSERT INTO `balance_libro` VALUES (3206,8433,40724,7531,3,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4000.00,NULL,NULL,1,'2023-03-13 13:26:46','2023-05-08 11:19:25','2023-05-08 11:19:25'),(3207,8433,40724,7531,3,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',6005.81,NULL,NULL,1,'2023-03-13 13:28:21','2023-05-08 11:18:58','2023-05-08 11:18:58'),(3208,8433,40724,7531,3,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3669.41,NULL,NULL,1,'2023-03-13 13:30:30','2023-05-08 11:18:39','2023-05-08 11:18:39'),(3209,8437,40804,65077,2,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',50000.00,NULL,NULL,1,'2023-03-14 09:25:50','2023-03-14 09:25:50',NULL),(3210,8433,40724,7531,3,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6000.00,NULL,NULL,1,'2023-03-14 09:46:47','2023-05-08 11:18:10','2023-05-08 11:18:10'),(3211,8433,40724,7531,3,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6000.00,NULL,NULL,1,'2023-03-14 09:48:23','2023-05-08 11:17:46','2023-05-08 11:17:46'),(3212,8437,40793,46896,2,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1315447.25,NULL,NULL,1,'2023-03-14 09:48:48','2023-03-14 09:48:48',NULL),(3213,8433,40724,7531,3,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6000.00,NULL,NULL,1,'2023-03-14 09:49:56','2023-03-30 11:32:21','2023-03-30 11:32:21'),(3214,8437,40793,46896,7,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',19329.00,NULL,NULL,1,'2023-03-14 09:52:01','2023-03-14 09:52:01',NULL),(3215,8433,40724,7531,3,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',9160.01,NULL,NULL,1,'2023-03-14 09:54:26','2023-05-08 11:17:20','2023-05-08 11:17:20'),(3216,8437,40793,46897,3,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',226450.94,NULL,NULL,1,'2023-03-14 09:56:13','2023-03-22 10:41:30','2023-03-22 10:41:30'),(3217,8437,40793,46897,3,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',682801.09,NULL,NULL,1,'2023-03-14 09:56:13','2023-03-14 09:56:13',NULL),(3218,8437,40793,46897,3,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',64454.93,NULL,NULL,1,'2023-03-14 09:56:13','2023-03-14 09:56:13',NULL),(3219,8437,40793,46897,3,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',58451.04,NULL,NULL,1,'2023-03-14 09:56:13','2023-03-14 09:56:13',NULL),(3220,8433,40724,7531,3,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',7100.90,NULL,NULL,1,'2023-03-14 09:57:06','2023-05-08 11:15:31','2023-05-08 11:15:31'),(3221,8433,40724,7531,3,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6230.00,NULL,NULL,1,'2023-03-14 09:58:48','2023-03-30 11:28:48','2023-03-30 11:28:48'),(3222,8437,40806,68107,2,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',36300.00,NULL,NULL,1,'2023-03-14 10:06:38','2023-03-14 10:06:38',NULL),(3223,8433,41421,754393,2,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',450649.98,NULL,NULL,1,'2023-03-14 10:06:49','2023-03-14 10:06:49',NULL),(3224,8433,41421,754393,2,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',111666.24,NULL,NULL,1,'2023-03-14 10:06:49','2023-03-14 10:06:49',NULL),(3225,8433,41421,754393,2,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',223332.48,NULL,NULL,1,'2023-03-14 10:06:49','2023-03-14 10:06:49',NULL);
INSERT INTO `balance_libro` VALUES (3226,8433,41421,754393,2,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',138198.94,NULL,NULL,1,'2023-03-14 10:06:49','2023-03-14 10:06:49',NULL),(3227,8433,41421,754393,3,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',42000.00,NULL,NULL,1,'2023-03-14 10:07:11','2023-03-14 10:09:03','2023-03-14 10:09:03'),(3228,8433,41421,754393,3,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',19954.09,NULL,NULL,1,'2023-03-14 10:07:12','2023-04-14 00:09:39','2023-04-14 00:09:39'),(3229,8433,41421,754393,3,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',213.63,NULL,NULL,1,'2023-03-14 10:07:12','2023-03-14 10:10:27','2023-03-14 10:10:27'),(3230,8433,41421,754393,3,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1249.00,NULL,NULL,1,'2023-03-14 10:07:12','2023-03-22 13:21:04','2023-03-22 13:21:04'),(3231,8433,41421,754393,3,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3724.99,NULL,NULL,1,'2023-03-14 10:07:12','2023-03-22 13:21:51','2023-03-22 13:21:51'),(3232,8433,41421,754393,3,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',5040.00,NULL,NULL,1,'2023-03-14 10:07:12','2023-04-14 00:09:55','2023-04-14 00:09:55'),(3233,8433,41421,754393,3,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3363.66,NULL,NULL,1,'2023-03-14 10:07:12','2023-04-14 00:10:11','2023-04-14 00:10:11'),(3234,8433,41421,754393,3,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',18900.00,NULL,NULL,1,'2023-03-14 10:07:12','2023-03-22 13:22:39','2023-03-22 13:22:39'),(3235,8433,41421,754393,3,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',0.00,NULL,NULL,1,'2023-03-14 10:07:12','2023-05-08 11:01:37','2023-05-08 11:01:37'),(3236,8433,41421,754393,3,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',22000.00,NULL,NULL,1,'2023-03-14 10:07:12','2023-03-14 10:11:00','2023-03-14 10:11:00'),(3237,8433,41421,754393,3,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',0.00,NULL,NULL,1,'2023-03-14 10:07:12','2023-05-08 11:01:55','2023-05-08 11:01:55'),(3238,8433,41421,754393,3,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1500.00,NULL,NULL,1,'2023-03-14 10:07:12','2023-03-14 10:11:39','2023-03-14 10:11:39'),(3239,8433,41421,754393,3,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',842.00,NULL,NULL,1,'2023-03-14 10:07:12','2023-03-22 13:23:37','2023-03-22 13:23:37'),(3240,8433,41421,754393,3,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',8990.00,NULL,NULL,1,'2023-03-14 10:07:12','2023-03-22 13:24:36','2023-03-22 13:24:36'),(3241,8433,41421,754393,3,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',200.00,NULL,NULL,1,'2023-03-14 10:07:12','2023-03-22 13:25:01','2023-03-22 13:25:01'),(3242,8433,41421,754393,3,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',120216.58,NULL,NULL,1,'2023-03-14 10:07:12','2023-03-14 10:14:43','2023-03-14 10:14:43'),(3243,8433,41421,754393,3,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',12981.97,NULL,NULL,1,'2023-03-14 10:07:12','2023-04-14 00:10:27','2023-04-14 00:10:27'),(3244,8433,41421,754393,3,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',18370.00,NULL,NULL,1,'2023-03-14 10:07:12','2023-03-22 13:25:29','2023-03-22 13:25:29');
INSERT INTO `balance_libro` VALUES (3245,8433,41421,754393,3,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3312.40,NULL,NULL,1,'2023-03-14 10:07:12','2023-04-14 00:10:42','2023-04-14 00:10:42'),(3246,8433,41421,754393,3,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',194153.70,NULL,NULL,1,'2023-03-14 10:07:12','2023-04-14 00:10:58','2023-04-14 00:10:58'),(3247,8433,41421,754393,3,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',42000.00,NULL,NULL,1,'2023-03-14 10:09:03','2023-04-14 00:21:29','2023-04-14 00:21:29'),(3248,8433,41421,754393,3,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',213.64,NULL,NULL,1,'2023-03-14 10:10:27','2023-03-22 15:28:17','2023-03-22 15:28:17'),(3249,8433,41421,754393,3,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',22000.00,NULL,NULL,1,'2023-03-14 10:11:00','2023-04-14 00:23:04','2023-04-14 00:23:04'),(3250,8433,41421,754393,3,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1500.00,NULL,NULL,1,'2023-03-14 10:11:39','2023-04-14 00:23:27','2023-04-14 00:23:27'),(3251,8433,41421,754393,3,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',120216.58,NULL,NULL,1,'2023-03-14 10:14:43','2023-04-14 00:11:34','2023-04-14 00:11:34'),(3252,8437,40807,69622,3,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',13000.00,NULL,NULL,1,'2023-03-14 10:14:47','2023-03-14 10:14:47',NULL),(3253,8437,40807,69622,3,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',135000.00,NULL,NULL,1,'2023-03-14 10:14:47','2023-03-14 10:14:47',NULL),(3254,8437,40807,69622,2,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',161230.84,NULL,NULL,1,'2023-03-14 10:15:02','2023-03-14 10:15:02',NULL),(3255,8437,40807,69622,2,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',30000.00,NULL,NULL,1,'2023-03-14 10:15:02','2023-03-14 10:15:02',NULL),(3256,8437,40807,69622,2,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',40322.00,NULL,NULL,1,'2023-03-14 10:15:02','2023-03-14 10:15:02',NULL),(3257,8433,40781,28720,2,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',194447.90,NULL,NULL,1,'2023-03-14 10:22:16','2023-03-14 10:22:16',NULL),(3258,8433,40781,28720,2,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',194447.90,NULL,NULL,1,'2023-03-14 10:22:16','2023-03-14 10:22:16',NULL),(3259,8433,40781,28720,2,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',194447.90,NULL,NULL,1,'2023-03-14 10:22:16','2023-03-14 10:22:16',NULL),(3260,8433,40781,28720,2,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',194447.90,NULL,NULL,1,'2023-03-14 10:22:16','2023-03-14 10:22:16',NULL),(3261,8433,40781,28720,2,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',59999.99,NULL,NULL,1,'2023-03-14 10:22:16','2023-03-14 10:22:16',NULL),(3262,8433,40781,28720,3,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',20000.00,NULL,NULL,1,'2023-03-14 10:22:48','2023-03-14 10:24:01','2023-03-14 10:24:01'),(3263,8433,40781,28720,3,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',45000.00,NULL,NULL,1,'2023-03-14 10:22:48','2023-03-14 10:24:29','2023-03-14 10:24:29'),(3264,8433,40781,28720,3,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',7031.77,NULL,NULL,1,'2023-03-14 10:22:48','2023-03-14 10:27:41','2023-03-14 10:27:41');
INSERT INTO `balance_libro` VALUES (3265,8433,40781,28720,3,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',162742.29,NULL,NULL,1,'2023-03-14 10:22:49','2023-03-14 10:36:02','2023-03-14 10:36:02'),(3266,8433,40781,28720,3,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1269.75,NULL,NULL,1,'2023-03-14 10:22:49','2023-04-24 11:04:06','2023-04-24 11:04:06'),(3267,8433,40781,28720,3,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',23000.00,NULL,NULL,1,'2023-03-14 10:22:49','2023-03-14 10:36:39','2023-03-14 10:36:39'),(3268,8433,40781,28720,3,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',28175.00,NULL,NULL,1,'2023-03-14 10:22:49','2023-03-14 10:22:49',NULL),(3269,8433,40781,28720,3,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',95.90,NULL,NULL,1,'2023-03-14 10:22:49','2023-03-14 10:22:49',NULL),(3270,8433,40781,28720,3,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',47675.13,NULL,NULL,1,'2023-03-14 10:22:49','2023-03-14 10:37:38','2023-03-14 10:37:38'),(3271,8433,40781,28720,3,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',20000.00,NULL,NULL,1,'2023-03-14 10:24:01','2023-04-24 10:51:40','2023-04-24 10:51:40'),(3272,8433,40781,28720,3,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',45000.00,NULL,NULL,1,'2023-03-14 10:24:29','2023-04-24 10:53:18','2023-04-24 10:53:18'),(3273,8433,40781,28720,3,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',7031.78,NULL,NULL,1,'2023-03-14 10:27:41','2023-04-24 11:01:53','2023-04-24 11:01:53'),(3274,8437,40883,143854,3,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2999.99,NULL,NULL,1,'2023-03-14 10:32:09','2023-03-14 10:32:09',NULL),(3275,8433,40781,28720,3,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',162742.29,NULL,NULL,1,'2023-03-14 10:36:02','2023-03-20 12:28:50','2023-03-20 12:28:50'),(3276,8433,40781,28720,3,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',23000.00,NULL,NULL,1,'2023-03-14 10:36:39','2023-04-24 10:49:16','2023-04-24 10:49:16'),(3277,8433,40781,28720,3,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',47675.13,NULL,NULL,1,'2023-03-14 10:37:38','2023-03-14 10:37:38',NULL),(3278,8433,40876,133249,2,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',308136.00,NULL,NULL,1,'2023-03-14 10:44:39','2023-03-14 10:44:39',NULL),(3279,8433,40876,133249,3,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',7242.71,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-14 10:47:50','2023-03-14 10:47:50'),(3280,8433,40876,133249,3,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',9979.21,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-27 15:27:06','2023-03-27 15:27:06'),(3281,8433,40876,133249,3,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',9979.21,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-27 15:26:58','2023-03-27 15:26:58'),(3282,8433,40876,133249,3,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',8482.32,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-27 15:26:50','2023-03-27 15:26:50'),(3283,8433,40876,133249,3,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',9979.21,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-27 15:26:41','2023-03-27 15:26:41');
INSERT INTO `balance_libro` VALUES (3284,8433,40876,133249,3,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',9979.21,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-27 15:26:29','2023-03-27 15:26:29'),(3285,8433,40876,133249,3,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',13636.24,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-14 10:52:53','2023-03-14 10:52:53'),(3286,8433,40876,133249,3,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',4876.58,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-14 10:54:29','2023-03-14 10:54:29'),(3287,8433,40876,133249,3,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',12014.66,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-27 15:25:14','2023-03-27 15:25:14'),(3288,8433,40876,133249,3,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',31364.51,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-27 15:25:21','2023-03-27 15:25:21'),(3289,8433,40876,133249,3,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',31364.51,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-27 15:24:57','2023-03-27 15:24:57'),(3290,8433,40876,133249,3,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',10027.34,NULL,NULL,1,'2023-03-14 10:45:01','2023-05-08 13:01:50','2023-05-08 13:01:50'),(3291,8433,40876,133249,3,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',12999.00,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-27 15:14:29','2023-03-27 15:14:29'),(3292,8433,40876,133249,3,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',38496.28,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-14 10:59:52','2023-03-14 10:59:52'),(3293,8433,40876,133249,3,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',54572.38,NULL,NULL,1,'2023-03-14 10:45:01','2023-03-14 11:04:03','2023-03-14 11:04:03'),(3294,8433,40876,133249,3,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',15682.25,NULL,NULL,1,'2023-03-14 10:45:02','2023-03-27 15:26:20','2023-03-27 15:26:20'),(3295,8433,40876,133249,3,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',5638.00,NULL,NULL,1,'2023-03-14 10:45:02','2023-03-14 11:04:31','2023-03-14 11:04:31'),(3296,8433,40876,133249,3,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4240.47,NULL,NULL,1,'2023-03-14 10:45:02','2023-03-27 15:26:15','2023-03-27 15:26:15'),(3297,8433,40876,133249,3,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1080.00,NULL,NULL,1,'2023-03-14 10:45:02','2023-05-08 13:35:59','2023-05-08 13:35:59'),(3298,8433,40876,133249,3,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',7242.71,NULL,NULL,1,'2023-03-14 10:47:50','2023-03-20 13:47:43','2023-03-20 13:47:43'),(3299,8437,40873,128704,3,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',30000.00,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:51:23','2023-03-14 10:51:23'),(3300,8437,40873,128704,3,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',207400.00,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:48:06',NULL),(3301,8437,40873,128704,3,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',207400.00,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:48:06',NULL),(3302,8437,40873,128704,3,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3275759.64,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:48:06',NULL);
INSERT INTO `balance_libro` VALUES (3303,8437,40873,128704,3,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',66099.88,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:48:06',NULL),(3304,8437,40873,128704,3,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',355030.89,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:48:06',NULL),(3305,8437,40873,128704,3,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',158015.00,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:48:06',NULL),(3306,8437,40873,128704,3,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',34557.23,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:54:06','2023-03-14 10:54:06'),(3307,8437,40873,128704,3,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',6098.00,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:48:06',NULL),(3308,8437,40873,128704,3,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',24584.79,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:55:38','2023-03-14 10:55:38'),(3309,8437,40873,128704,3,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',15995.00,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:48:06',NULL),(3310,8437,40873,128704,3,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',5827.96,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:57:18','2023-03-14 10:57:18'),(3311,8437,40873,128704,3,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',21259.34,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:58:34','2023-03-14 10:58:34'),(3312,8437,40873,128704,3,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',32194.53,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 11:00:04','2023-03-14 11:00:04'),(3313,8437,40873,128704,3,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',10721.18,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 11:01:52','2023-03-14 11:01:52'),(3314,8437,40873,128704,3,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',18400.00,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:48:06',NULL),(3315,8437,40873,128704,3,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',84209.97,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 11:03:33','2023-03-14 11:03:33'),(3316,8437,40873,128704,3,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',9199.39,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 11:04:36','2023-03-14 11:04:36'),(3317,8437,40873,128704,3,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',600.00,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:48:06',NULL),(3318,8437,40873,128704,3,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',2619.48,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 11:05:32','2023-03-14 11:05:32'),(3319,8437,40873,128704,3,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',4949.01,NULL,NULL,1,'2023-03-14 10:48:06','2023-03-14 10:48:06',NULL),(3320,8437,40873,128704,3,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',12257.55,NULL,NULL,1,'2023-03-14 10:48:07','2023-03-14 11:06:53','2023-03-14 11:06:53'),(3321,8437,40873,128704,3,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',30000.00,NULL,NULL,1,'2023-03-14 10:51:23','2023-03-14 10:51:23',NULL);
INSERT INTO `balance_libro` VALUES (3322,8433,40876,133249,3,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',13636.24,NULL,NULL,1,'2023-03-14 10:52:53','2023-03-20 13:49:01','2023-03-20 13:49:01'),(3323,8437,40873,128704,3,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',34557.23,NULL,NULL,1,'2023-03-14 10:54:06','2023-03-14 10:54:06',NULL),(3324,8433,40876,133249,3,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',4876.58,NULL,NULL,1,'2023-03-14 10:54:29','2023-03-20 13:49:39','2023-03-20 13:49:39'),(3325,8437,40873,128704,3,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',24584.79,NULL,NULL,1,'2023-03-14 10:55:38','2023-03-14 10:55:38',NULL),(3326,8437,40873,128704,3,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',5827.96,NULL,NULL,1,'2023-03-14 10:57:18','2023-03-14 10:57:18',NULL),(3327,8437,40873,128704,3,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',21259.34,NULL,NULL,1,'2023-03-14 10:58:34','2023-03-14 10:58:34',NULL),(3328,8433,40876,133249,3,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',38496.28,NULL,NULL,1,'2023-03-14 10:59:52','2023-03-14 10:59:52',NULL),(3329,8437,40873,128704,3,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',32194.53,NULL,NULL,1,'2023-03-14 11:00:04','2023-03-14 11:00:04',NULL),(3330,8437,40873,128704,3,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',10721.18,NULL,NULL,1,'2023-03-14 11:01:52','2023-03-14 11:01:52',NULL),(3331,8437,40873,128704,3,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',84209.97,NULL,NULL,1,'2023-03-14 11:03:33','2023-03-14 11:03:33',NULL),(3332,8433,40876,133249,3,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',54572.38,NULL,NULL,1,'2023-03-14 11:04:03','2023-03-20 13:46:48','2023-03-20 13:46:48'),(3333,8433,40876,133249,3,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',5638.00,NULL,NULL,1,'2023-03-14 11:04:31','2023-05-08 13:35:21','2023-05-08 13:35:21'),(3334,8437,40873,128704,3,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',9199.39,NULL,NULL,1,'2023-03-14 11:04:36','2023-03-14 11:04:36',NULL),(3335,8437,40873,128704,3,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',2619.47,NULL,NULL,1,'2023-03-14 11:05:32','2023-03-14 11:05:32',NULL),(3336,8437,40873,128704,3,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',12257.55,NULL,NULL,1,'2023-03-14 11:06:53','2023-03-14 11:06:53',NULL),(3337,8437,40873,128704,3,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',7980.85,NULL,NULL,1,'2023-03-14 11:10:03','2023-03-14 11:10:03',NULL),(3338,8437,40873,128704,3,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',17564.03,NULL,NULL,1,'2023-03-14 11:16:37','2023-03-14 11:16:37',NULL),(3339,8437,40873,128704,3,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',2774.96,NULL,NULL,1,'2023-03-14 11:18:44','2023-03-14 11:18:44',NULL),(3340,8437,40873,128704,3,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',9642.80,NULL,NULL,1,'2023-03-14 11:20:00','2023-03-14 11:20:00',NULL),(3341,8437,40790,42352,3,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',17800.00,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-14 11:35:28','2023-03-14 11:35:28');
INSERT INTO `balance_libro` VALUES (3342,8437,40790,42352,3,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',16391.87,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-14 11:34:00',NULL),(3343,8437,40790,42352,3,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',12600.00,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-27 14:25:08','2023-03-27 14:25:08'),(3344,8437,40790,42352,3,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',7556.38,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-14 11:34:00',NULL),(3345,8437,40790,42352,3,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',114268.50,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-27 14:27:45','2023-03-27 14:27:45'),(3346,8437,40790,42352,3,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',10911.78,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-14 11:34:00',NULL),(3347,8437,40790,42352,3,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',10911.78,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-14 11:34:00',NULL),(3348,8437,40790,42352,3,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',725.49,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-14 11:34:00',NULL),(3349,8437,40790,42352,3,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',116420.25,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-14 11:38:37','2023-03-14 11:38:37'),(3350,8437,40790,42352,3,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',116420.25,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-14 11:39:58','2023-03-14 11:39:58'),(3351,8437,40790,42352,3,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',12302.34,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-14 11:34:00',NULL),(3352,8437,40790,42352,3,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',10911.78,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-14 11:34:00',NULL),(3353,8437,40790,42352,3,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',106165.00,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-14 11:41:15','2023-03-14 11:41:15'),(3354,8437,40790,42352,3,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',6150.45,NULL,NULL,1,'2023-03-14 11:34:00','2023-03-14 11:36:58','2023-03-14 11:36:58'),(3355,8437,40790,42352,3,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',17800.00,NULL,NULL,1,'2023-03-14 11:35:28','2023-03-14 11:35:28',NULL),(3356,8437,40790,42352,3,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',6150.45,NULL,NULL,1,'2023-03-14 11:36:58','2023-03-27 14:11:02','2023-03-27 14:11:02'),(3357,8437,40790,42352,3,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',116420.25,NULL,NULL,1,'2023-03-14 11:38:37','2023-03-14 11:38:37',NULL),(3358,8437,40790,42352,3,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',116420.25,NULL,NULL,1,'2023-03-14 11:39:58','2023-03-14 11:39:58',NULL),(3359,8437,40790,42352,3,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',106165.00,NULL,NULL,1,'2023-03-14 11:41:15','2023-03-14 11:41:15',NULL),(3360,8437,40790,42352,2,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',960.00,NULL,NULL,1,'2023-03-14 11:42:06','2023-03-15 12:25:02','2023-03-15 12:25:02'),(3361,8437,40790,42352,2,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',320.00,NULL,NULL,1,'2023-03-14 11:42:06','2023-03-15 12:24:48','2023-03-15 12:24:48');
INSERT INTO `balance_libro` VALUES (3362,8437,40790,42352,2,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',320.00,NULL,NULL,1,'2023-03-14 11:42:06','2023-03-15 12:24:36','2023-03-15 12:24:36'),(3363,8437,40790,42352,2,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',360.00,NULL,NULL,1,'2023-03-14 11:42:06','2023-03-15 12:24:31','2023-03-15 12:24:31'),(3364,8437,40790,42352,2,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',360.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:24:22','2023-03-15 12:24:22'),(3365,8437,40790,42352,2,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',150.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:24:16','2023-03-15 12:24:16'),(3366,8437,40790,42352,2,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',710.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:24:10','2023-03-15 12:24:10'),(3367,8437,40790,42352,2,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',150.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:24:04','2023-03-15 12:24:04'),(3368,8437,40790,42352,2,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',150.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:23:57','2023-03-15 12:23:57'),(3369,8437,40790,42352,2,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',720.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:23:49','2023-03-15 12:23:49'),(3370,8437,40790,42352,2,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',490.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:23:40','2023-03-15 12:23:40'),(3371,8437,40790,42352,2,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1270.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:23:36','2023-03-15 12:23:36'),(3372,8437,40790,42352,2,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',120.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:23:30','2023-03-15 12:23:30'),(3373,8437,40790,42352,2,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',240.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:23:25','2023-03-15 12:23:25'),(3374,8437,40790,42352,2,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',450.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:23:18','2023-03-15 12:23:18'),(3375,8437,40790,42352,2,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',120.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:23:11','2023-03-15 12:23:11'),(3376,8437,40790,42352,2,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',500.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:23:03','2023-03-15 12:23:03'),(3377,8437,40790,42352,2,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',660.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:22:58','2023-03-15 12:22:58'),(3378,8437,40790,42352,2,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',30.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:22:50','2023-03-15 12:22:50'),(3379,8437,40790,42352,2,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',360.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:22:45','2023-03-15 12:22:45'),(3380,8437,40790,42352,2,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',480.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:22:40','2023-03-15 12:22:40');
INSERT INTO `balance_libro` VALUES (3381,8437,40790,42352,2,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',720.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:22:36','2023-03-15 12:22:36'),(3382,8437,40790,42352,2,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',710.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:22:32','2023-03-15 12:22:32'),(3383,8437,40790,42352,2,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',690.00,NULL,NULL,1,'2023-03-14 11:42:07','2023-03-15 12:22:26','2023-03-15 12:22:26'),(3384,8437,40790,42352,2,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1650.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:22:22','2023-03-15 12:22:22'),(3385,8437,40790,42352,2,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',190.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:22:16','2023-03-15 12:22:16'),(3386,8437,40790,42352,2,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',810.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:22:11','2023-03-15 12:22:11'),(3387,8437,40790,42352,2,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',320.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:22:04','2023-03-15 12:22:04'),(3388,8437,40790,42352,2,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',360.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:21:59','2023-03-15 12:21:59'),(3389,8437,40790,42352,2,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',200.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:21:54','2023-03-15 12:21:54'),(3390,8437,40790,42352,2,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',300.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:21:49','2023-03-15 12:21:49'),(3391,8437,40790,42352,2,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',150.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:21:44','2023-03-15 12:21:44'),(3392,8437,40790,42352,2,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',800.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:21:39','2023-03-15 12:21:39'),(3393,8437,40790,42352,2,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',350.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:21:35','2023-03-15 12:21:35'),(3394,8437,40790,42352,2,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',720.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:21:29','2023-03-15 12:21:29'),(3395,8437,40790,42352,2,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',190.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:21:24','2023-03-15 12:21:24'),(3396,8437,40790,42352,2,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',700.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:21:20','2023-03-15 12:21:20'),(3397,8437,40790,42352,2,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',720.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:21:15','2023-03-15 12:21:15'),(3398,8437,40790,42352,2,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',100.00,NULL,NULL,1,'2023-03-14 11:42:08','2023-03-15 12:21:10','2023-03-15 12:21:10'),(3399,8437,40790,42352,2,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',360.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:21:04','2023-03-15 12:21:04');
INSERT INTO `balance_libro` VALUES (3400,8437,40790,42352,2,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',720.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:20:59','2023-03-15 12:20:59'),(3401,8437,40790,42352,2,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',150.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:20:53','2023-03-15 12:20:53'),(3402,8437,40790,42352,2,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1040.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:20:46','2023-03-15 12:20:46'),(3403,8437,40790,42352,2,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1480.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:20:41','2023-03-15 12:20:41'),(3404,8437,40790,42352,2,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',980.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:20:35','2023-03-15 12:20:35'),(3405,8437,40790,42352,2,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',730.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:20:24','2023-03-15 12:20:24'),(3406,8437,40790,42352,2,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1440.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:20:29','2023-03-15 12:20:29'),(3407,8437,40790,42352,2,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',150.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:20:18','2023-03-15 12:20:18'),(3408,8437,40790,42352,2,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',70.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:20:13','2023-03-15 12:20:13'),(3409,8437,40790,42352,2,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',720.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:20:08','2023-03-15 12:20:08'),(3410,8437,40790,42352,2,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',670.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:20:02','2023-03-15 12:20:02'),(3411,8437,40790,42352,2,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',180.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:19:58','2023-03-15 12:19:58'),(3412,8437,40790,42352,2,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',100.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:19:53','2023-03-15 12:19:53'),(3413,8437,40790,42352,2,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',170.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:19:48','2023-03-15 12:19:48'),(3414,8437,40790,42352,2,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2340.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:19:43','2023-03-15 12:19:43'),(3415,8437,40790,42352,2,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',900.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:19:37','2023-03-15 12:19:37'),(3416,8437,40790,42352,2,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',400.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:19:31','2023-03-15 12:19:31'),(3417,8437,40790,42352,2,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',400.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:19:25','2023-03-15 12:19:25'),(3418,8437,40790,42352,2,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',750.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:19:20','2023-03-15 12:19:20');
INSERT INTO `balance_libro` VALUES (3419,8437,40790,42352,2,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',350.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:19:14','2023-03-15 12:19:14'),(3420,8437,40790,42352,2,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',180.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:19:09','2023-03-15 12:19:09'),(3421,8437,40790,42352,2,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',900.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:19:04','2023-03-15 12:19:04'),(3422,8437,40790,42352,2,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',530.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:18:59','2023-03-15 12:18:59'),(3423,8437,40790,42352,2,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',220.00,NULL,NULL,1,'2023-03-14 11:42:09','2023-03-15 12:18:53','2023-03-15 12:18:53'),(3424,8437,40790,42352,2,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',450.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:18:48','2023-03-15 12:18:48'),(3425,8437,40790,42352,2,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',400.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:18:43','2023-03-15 12:18:43'),(3426,8437,40790,42352,2,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',550.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:18:37','2023-03-15 12:18:37'),(3427,8437,40790,42352,2,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',200.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:18:30','2023-03-15 12:18:30'),(3428,8437,40790,42352,2,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',300.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:18:24','2023-03-15 12:18:24'),(3429,8437,40790,42352,2,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',100.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:18:17','2023-03-15 12:18:17'),(3430,8437,40790,42352,2,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',220.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:18:12','2023-03-15 12:18:12'),(3431,8437,40790,42352,2,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',160.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:18:07','2023-03-15 12:18:07'),(3432,8437,40790,42352,2,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',360.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:17:35','2023-03-15 12:17:35'),(3433,8437,40790,42352,2,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',200.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:17:16','2023-03-15 12:17:16'),(3434,8437,40790,42352,2,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',900.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:17:05','2023-03-15 12:17:05'),(3435,8437,40790,42352,2,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',370.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:16:47','2023-03-15 12:16:47'),(3436,8437,40790,42352,2,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',450.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:16:39','2023-03-15 12:16:39'),(3437,8437,40790,42352,2,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',450.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:16:31','2023-03-15 12:16:31');
INSERT INTO `balance_libro` VALUES (3438,8437,40790,42352,2,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',300.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:16:22','2023-03-15 12:16:22'),(3439,8437,40790,42352,2,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',450.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:16:17','2023-03-15 12:16:17'),(3440,8437,40790,42352,2,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',220.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:16:12','2023-03-15 12:16:12'),(3441,8437,40790,42352,2,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',210.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:16:07','2023-03-15 12:16:07'),(3442,8437,40790,42352,2,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',200.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:16:01','2023-03-15 12:16:01'),(3443,8437,40790,42352,2,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',180.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:15:56','2023-03-15 12:15:56'),(3444,8437,40790,42352,2,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',450.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:15:46','2023-03-15 12:15:46'),(3445,8437,40790,42352,2,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',400.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:15:40','2023-03-15 12:15:40'),(3446,8437,40790,42352,2,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',360.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:15:35','2023-03-15 12:15:35'),(3447,8437,40790,42352,2,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',450.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:15:30','2023-03-15 12:15:30'),(3448,8437,40790,42352,2,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',450.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:15:25','2023-03-15 12:15:25'),(3449,8437,40790,42352,2,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',450.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:15:14','2023-03-15 12:15:14'),(3450,8437,40790,42352,2,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',480.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:15:09','2023-03-15 12:15:09'),(3451,8437,40790,42352,2,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',450.00,NULL,NULL,1,'2023-03-14 11:42:10','2023-03-15 12:15:20','2023-03-15 12:15:20'),(3452,8437,40790,42352,2,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',220.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:14:56','2023-03-15 12:14:56'),(3453,8437,40790,42352,2,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',450.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:14:51','2023-03-15 12:14:51'),(3454,8437,40790,42352,2,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',650.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:14:47','2023-03-15 12:14:47'),(3455,8437,40790,42352,2,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',520.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:14:41','2023-03-15 12:14:41'),(3456,8437,40790,42352,2,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',120.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:14:36','2023-03-15 12:14:36');
INSERT INTO `balance_libro` VALUES (3457,8437,40790,42352,2,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1300.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:14:31','2023-03-15 12:14:31'),(3458,8437,40790,42352,2,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',530.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:14:17','2023-03-15 12:14:17'),(3459,8437,40790,42352,2,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',750.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:14:25','2023-03-15 12:14:25'),(3460,8437,40790,42352,2,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',400.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:14:12','2023-03-15 12:14:12'),(3461,8437,40790,42352,2,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',150.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:13:56','2023-03-15 12:13:56'),(3462,8437,40790,42352,2,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',180.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:14:01','2023-03-15 12:14:01'),(3463,8437,40790,42352,2,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',260.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:14:07','2023-03-15 12:14:07'),(3464,8437,40790,42352,2,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',700.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:13:46','2023-03-15 12:13:46'),(3465,8437,40790,42352,2,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',100.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:13:33','2023-03-15 12:13:33'),(3466,8437,40790,42352,2,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1260.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:13:28','2023-03-15 12:13:28'),(3467,8437,40790,42352,2,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',450.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:13:22','2023-03-15 12:13:22'),(3468,8437,40790,42352,2,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2250.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:13:39','2023-03-15 12:13:39'),(3469,8437,40790,42352,2,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',100.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:13:06','2023-03-15 12:13:06'),(3470,8437,40790,42352,2,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',230.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:13:17','2023-03-15 12:13:17'),(3471,8437,40790,42352,2,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',200.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:13:12','2023-03-15 12:13:12'),(3472,8437,40790,42352,2,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1350.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:13:00','2023-03-15 12:13:00'),(3473,8437,40790,42352,2,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',550.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:12:52','2023-03-15 12:12:52'),(3474,8437,40790,42352,2,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',400.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:13:50','2023-03-15 12:13:50'),(3475,8437,40790,42352,2,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',450.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:12:46','2023-03-15 12:12:46');
INSERT INTO `balance_libro` VALUES (3476,8437,40790,42352,2,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',450.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:12:40','2023-03-15 12:12:40'),(3477,8437,40790,42352,2,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',900.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:12:35','2023-03-15 12:12:35'),(3478,8437,40790,42352,2,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',580.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:12:30','2023-03-15 12:12:30'),(3479,8437,40790,42352,2,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',400.00,NULL,NULL,1,'2023-03-14 11:42:11','2023-03-15 12:12:25','2023-03-15 12:12:25'),(3480,8437,40790,42352,2,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',670.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:12:15','2023-03-15 12:12:15'),(3481,8437,40790,42352,2,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',450.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:12:10','2023-03-15 12:12:10'),(3482,8437,40790,42352,2,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',450.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:12:20','2023-03-15 12:12:20'),(3483,8437,40790,42352,2,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',360.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:12:05','2023-03-15 12:12:05'),(3484,8437,40790,42352,2,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',450.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:11:59','2023-03-15 12:11:59'),(3485,8437,40790,42352,2,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',150.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:11:54','2023-03-15 12:11:54'),(3486,8437,40790,42352,2,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',600.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:11:48','2023-03-15 12:11:48'),(3487,8437,40790,42352,2,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',800.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:11:44','2023-03-15 12:11:44'),(3488,8437,40790,42352,2,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',850.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:11:33','2023-03-15 12:11:33'),(3489,8437,40790,42352,2,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',570.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:11:38','2023-03-15 12:11:38'),(3490,8437,40790,42352,2,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',300.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:11:28','2023-03-15 12:11:28'),(3491,8437,40790,42352,2,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',450.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:11:22','2023-03-15 12:11:22'),(3492,8437,40790,42352,2,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1050.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:11:15','2023-03-15 12:11:15'),(3493,8437,40790,42352,2,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',760.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:11:07','2023-03-15 12:11:07'),(3494,8437,40790,42352,2,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',900.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:11:01','2023-03-15 12:11:01');
INSERT INTO `balance_libro` VALUES (3495,8437,40790,42352,2,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1000.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:10:56','2023-03-15 12:10:56'),(3496,8437,40790,42352,2,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',180.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:10:51','2023-03-15 12:10:51'),(3497,8437,40790,42352,2,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',450.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:10:47','2023-03-15 12:10:47'),(3498,8437,40790,42352,2,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',700.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:10:41','2023-03-15 12:10:41'),(3499,8437,40790,42352,2,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',320.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:10:36','2023-03-15 12:10:36'),(3500,8437,40790,42352,2,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',540.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:10:30','2023-03-15 12:10:30'),(3501,8437,40790,42352,2,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',900.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:10:24','2023-03-15 12:10:24'),(3502,8437,40790,42352,2,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',180.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:10:18','2023-03-15 12:10:18'),(3503,8437,40790,42352,2,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',360.00,NULL,NULL,1,'2023-03-14 11:42:12','2023-03-15 12:10:14','2023-03-15 12:10:14'),(3504,8437,40790,42352,2,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',220.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:10:09','2023-03-15 12:10:09'),(3505,8437,40790,42352,2,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',900.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:10:01','2023-03-15 12:10:01'),(3506,8437,40790,42352,2,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',350.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:09:54','2023-03-15 12:09:54'),(3507,8437,40790,42352,2,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',360.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:09:46','2023-03-15 12:09:46'),(3508,8437,40790,42352,2,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1300.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:09:40','2023-03-15 12:09:40'),(3509,8437,40790,42352,2,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',850.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:09:35','2023-03-15 12:09:35'),(3510,8437,40790,42352,2,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',450.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:09:30','2023-03-15 12:09:30'),(3511,8437,40790,42352,2,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',250.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:09:24','2023-03-15 12:09:24'),(3512,8437,40790,42352,2,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',120.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:09:19','2023-03-15 12:09:19'),(3513,8437,40790,42352,2,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',490.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:09:14','2023-03-15 12:09:14');
INSERT INTO `balance_libro` VALUES (3514,8437,40790,42352,2,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',450.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:09:09','2023-03-15 12:09:09'),(3515,8437,40790,42352,2,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',450.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:08:57','2023-03-15 12:08:57'),(3516,8437,40790,42352,2,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',850.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:09:03','2023-03-15 12:09:03'),(3517,8437,40790,42352,2,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',230.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:08:46','2023-03-15 12:08:46'),(3518,8437,40790,42352,2,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',225.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:08:52','2023-03-15 12:08:52'),(3519,8437,40790,42352,2,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',570.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:08:39','2023-03-15 12:08:39'),(3520,8437,40790,42352,2,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',350.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:08:33','2023-03-15 12:08:33'),(3521,8437,40790,42352,2,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',900.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:08:28','2023-03-15 12:08:28'),(3522,8437,40790,42352,2,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1800.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:08:23','2023-03-15 12:08:23'),(3523,8437,40790,42352,2,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1200.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:08:18','2023-03-15 12:08:18'),(3524,8437,40790,42352,2,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',370.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:08:11','2023-03-15 12:08:11'),(3525,8437,40790,42352,2,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',450.00,NULL,NULL,1,'2023-03-14 11:42:13','2023-03-15 12:08:06','2023-03-15 12:08:06'),(3526,8437,40790,42352,2,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',400.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:08:02','2023-03-15 12:08:02'),(3527,8437,40790,42352,2,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',220.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:07:55','2023-03-15 12:07:55'),(3528,8437,40790,42352,2,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',900.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:07:48','2023-03-15 12:07:48'),(3529,8437,40790,42352,2,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',900.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:07:36','2023-03-15 12:07:36'),(3530,8437,40790,42352,2,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',450.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:07:31','2023-03-15 12:07:31'),(3531,8437,40790,42352,2,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1130.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:07:21','2023-03-15 12:07:21'),(3532,8437,40790,42352,2,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',490.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:07:14','2023-03-15 12:07:14');
INSERT INTO `balance_libro` VALUES (3533,8437,40790,42352,2,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',180.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:07:02','2023-03-15 12:07:02'),(3534,8437,40790,42352,2,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',400.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:07:07','2023-03-15 12:07:07'),(3535,8437,40790,42352,2,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',220.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:06:57','2023-03-15 12:06:57'),(3536,8437,40790,42352,2,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',900.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:06:48','2023-03-15 12:06:48'),(3537,8437,40790,42352,2,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',420.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:06:36','2023-03-15 12:06:36'),(3538,8437,40790,42352,2,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',300.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:06:42','2023-03-15 12:06:42'),(3539,8437,40790,42352,2,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',370.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:06:31','2023-03-15 12:06:31'),(3540,8437,40790,42352,2,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',450.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:06:26','2023-03-15 12:06:26'),(3541,8437,40790,42352,2,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',180.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:06:20','2023-03-15 12:06:20'),(3542,8437,40790,42352,2,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',180.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:06:12','2023-03-15 12:06:12'),(3543,8437,40790,42352,2,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',800.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:06:06','2023-03-15 12:06:06'),(3544,8437,40790,42352,2,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2050.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:05:20','2023-03-15 12:05:20'),(3545,8437,40790,42352,2,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',350.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:05:59','2023-03-15 12:05:59'),(3546,8437,40790,42352,2,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1000.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:05:42','2023-03-15 12:05:42'),(3547,8437,40790,42352,2,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',360.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:05:54','2023-03-15 12:05:54'),(3548,8437,40790,42352,2,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',320.00,NULL,NULL,1,'2023-03-14 11:42:14','2023-03-15 12:05:49','2023-03-15 12:05:49'),(3549,8437,40790,42352,2,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',150.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:05:01','2023-03-15 12:05:01'),(3550,8437,40790,42352,2,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',220.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:05:07','2023-03-15 12:05:07'),(3551,8437,40790,42352,2,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',370.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:04:55','2023-03-15 12:04:55');
INSERT INTO `balance_libro` VALUES (3552,8437,40790,42352,2,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',150.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:04:49','2023-03-15 12:04:49'),(3553,8437,40790,42352,2,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',600.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:04:42','2023-03-15 12:04:42'),(3554,8437,40790,42352,2,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1300.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:04:36','2023-03-15 12:04:36'),(3555,8437,40790,42352,2,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',450.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:04:29','2023-03-15 12:04:29'),(3556,8437,40790,42352,2,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',375.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:04:24','2023-03-15 12:04:24'),(3557,8437,40790,42352,2,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',400.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:04:18','2023-03-15 12:04:18'),(3558,8437,40790,42352,2,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',400.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:04:07','2023-03-15 12:04:07'),(3559,8437,40790,42352,2,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',190.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:04:12','2023-03-15 12:04:12'),(3560,8437,40790,42352,2,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',85.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:03:57','2023-03-15 12:03:57'),(3561,8437,40790,42352,2,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',600.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:04:02','2023-03-15 12:04:02'),(3562,8437,40790,42352,2,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',510.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:03:52','2023-03-15 12:03:52'),(3563,8437,40790,42352,2,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',450.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:03:47','2023-03-15 12:03:47'),(3564,8437,40790,42352,2,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1600.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:03:41','2023-03-15 12:03:41'),(3565,8437,40790,42352,2,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',900.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:03:36','2023-03-15 12:03:36'),(3566,8437,40790,42352,2,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1020.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:03:29','2023-03-15 12:03:29'),(3567,8437,40790,42352,2,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1200.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:03:23','2023-03-15 12:03:23'),(3568,8437,40790,42352,2,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',250.00,NULL,NULL,1,'2023-03-14 11:42:15','2023-03-15 12:03:15','2023-03-15 12:03:15'),(3569,8437,40790,42352,2,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',150.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:03:07','2023-03-15 12:03:07'),(3570,8437,40790,42352,2,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',450.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:03:01','2023-03-15 12:03:01');
INSERT INTO `balance_libro` VALUES (3571,8437,40790,42352,2,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1760.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:02:56','2023-03-15 12:02:56'),(3572,8437,40790,42352,2,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',210.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:02:49','2023-03-15 12:02:49'),(3573,8437,40790,42352,2,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',450.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:02:42','2023-03-15 12:02:42'),(3574,8437,40790,42352,2,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',900.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:02:34','2023-03-15 12:02:34'),(3575,8437,40790,42352,2,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',497.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:02:25','2023-03-15 12:02:25'),(3576,8437,40790,42352,2,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1220.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:02:19','2023-03-15 12:02:19'),(3577,8437,40790,42352,2,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',450.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:02:12','2023-03-15 12:02:12'),(3578,8437,40790,42352,2,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',980.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:02:07','2023-03-15 12:02:07'),(3579,8437,40790,42352,2,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',165.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:02:01','2023-03-15 12:02:01'),(3580,8437,40790,42352,2,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',300.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:01:54','2023-03-15 12:01:54'),(3581,8437,40790,42352,2,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',450.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:01:48','2023-03-15 12:01:48'),(3582,8437,40790,42352,2,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',700.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:01:41','2023-03-15 12:01:41'),(3583,8437,40790,42352,2,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',450.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:01:34','2023-03-15 12:01:34'),(3584,8437,40790,42352,2,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',220.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:00:24','2023-03-15 12:00:24'),(3585,8437,40790,42352,2,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',300.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:01:25','2023-03-15 12:01:25'),(3586,8437,40790,42352,2,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',910.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:01:16','2023-03-15 12:01:16'),(3587,8437,40790,42352,2,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',180.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:01:09','2023-03-15 12:01:09'),(3588,8437,40790,42352,2,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1750.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:00:56','2023-03-15 12:00:56'),(3589,8437,40790,42352,2,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',300.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:00:41','2023-03-15 12:00:41');
INSERT INTO `balance_libro` VALUES (3590,8437,40790,42352,2,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',900.00,NULL,NULL,1,'2023-03-14 11:42:16','2023-03-15 12:00:30','2023-03-15 12:00:30'),(3591,8437,40790,42352,2,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',450.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 12:00:48','2023-03-15 12:00:48'),(3592,8437,40790,42352,2,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1200.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 12:00:35','2023-03-15 12:00:35'),(3593,8437,40790,42352,2,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',450.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 12:01:02','2023-03-15 12:01:02'),(3594,8437,40790,42352,2,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',900.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 12:00:10','2023-03-15 12:00:10'),(3595,8437,40790,42352,2,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',900.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 12:00:04','2023-03-15 12:00:04'),(3596,8437,40790,42352,2,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',400.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:59:58','2023-03-15 11:59:58'),(3597,8437,40790,42352,2,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',400.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:59:53','2023-03-15 11:59:53'),(3598,8437,40790,42352,2,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1050.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:59:47','2023-03-15 11:59:47'),(3599,8437,40790,42352,2,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',90.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:59:42','2023-03-15 11:59:42'),(3600,8437,40790,42352,2,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',580.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:59:37','2023-03-15 11:59:37'),(3601,8437,40790,42352,2,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',320.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:59:32','2023-03-15 11:59:32'),(3602,8437,40790,42352,2,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',450.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:59:26','2023-03-15 11:59:26'),(3603,8437,40790,42352,2,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',600.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:59:21','2023-03-15 11:59:21'),(3604,8437,40790,42352,2,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',700.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:59:14','2023-03-15 11:59:14'),(3605,8437,40790,42352,2,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',500.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:59:09','2023-03-15 11:59:09'),(3606,8437,40790,42352,2,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',2220.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:59:03','2023-03-15 11:59:03'),(3607,8437,40790,42352,2,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',440.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:58:58','2023-03-15 11:58:58'),(3608,8437,40790,42352,2,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',440.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:58:51','2023-03-15 11:58:51');
INSERT INTO `balance_libro` VALUES (3609,8437,40790,42352,2,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',150.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:58:46','2023-03-15 11:58:46'),(3610,8437,40790,42352,2,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',600.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:58:41','2023-03-15 11:58:41'),(3611,8437,40790,42352,2,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',350.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:58:34','2023-03-15 11:58:34'),(3612,8437,40790,42352,2,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',510.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:58:29','2023-03-15 11:58:29'),(3613,8437,40790,42352,2,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',150.00,NULL,NULL,1,'2023-03-14 11:42:17','2023-03-15 11:58:24','2023-03-15 11:58:24'),(3614,8437,40790,42352,2,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',350.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:58:17','2023-03-15 11:58:17'),(3615,8437,40790,42352,2,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',960.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:58:11','2023-03-15 11:58:11'),(3616,8437,40790,42352,2,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',440.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:58:06','2023-03-15 11:58:06'),(3617,8437,40790,42352,2,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',180.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:58:01','2023-03-15 11:58:01'),(3618,8437,40790,42352,2,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',150.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:57:54','2023-03-15 11:57:54'),(3619,8437,40790,42352,2,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',350.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:57:49','2023-03-15 11:57:49'),(3620,8437,40790,42352,2,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',900.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:57:43','2023-03-15 11:57:43'),(3621,8437,40790,42352,2,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',300.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:57:37','2023-03-15 11:57:37'),(3622,8437,40790,42352,2,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',750.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:57:10','2023-03-15 11:57:10'),(3623,8437,40790,42352,2,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',200.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:56:59','2023-03-15 11:56:59'),(3624,8437,40790,42352,2,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',340.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:56:53','2023-03-15 11:56:53'),(3625,8437,40790,42352,2,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',900.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:56:47','2023-03-15 11:56:47'),(3626,8437,40790,42352,2,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',360.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:56:41','2023-03-15 11:56:41'),(3627,8437,40790,42352,2,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',180.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:56:34','2023-03-15 11:56:34');
INSERT INTO `balance_libro` VALUES (3628,8437,40790,42352,2,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',220.00,NULL,NULL,1,'2023-03-14 11:42:18','2023-03-15 11:56:27','2023-03-15 11:56:27'),(3629,8437,40790,42352,2,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',225.00,NULL,NULL,1,'2023-03-14 11:42:19','2023-03-15 11:56:22','2023-03-15 11:56:22'),(3630,8437,40790,42352,2,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',450.00,NULL,NULL,1,'2023-03-14 11:42:19','2023-03-15 11:56:15','2023-03-15 11:56:15'),(3631,8437,40790,42352,2,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',400.00,NULL,NULL,1,'2023-03-14 11:42:19','2023-03-15 11:56:08','2023-03-15 11:56:08'),(3632,8437,40790,42352,2,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',920.00,NULL,NULL,1,'2023-03-14 11:42:19','2023-03-15 11:56:02','2023-03-15 11:56:02'),(3633,8437,40790,42352,2,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',450.00,NULL,NULL,1,'2023-03-14 11:42:19','2023-03-15 11:55:54','2023-03-15 11:55:54'),(3634,8437,40790,42352,2,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',130.00,NULL,NULL,1,'2023-03-14 11:42:19','2023-03-15 11:55:43','2023-03-15 11:55:43'),(3635,8437,40790,42352,2,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1300.00,NULL,NULL,1,'2023-03-14 11:42:19','2023-03-15 11:55:30','2023-03-15 11:55:30'),(3636,8437,40790,42352,2,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',900.00,NULL,NULL,1,'2023-03-14 11:42:19','2023-03-15 11:55:24','2023-03-15 11:55:24'),(3637,8437,40790,42352,2,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',750.00,NULL,NULL,1,'2023-03-14 11:42:19','2023-03-15 11:55:17','2023-03-15 11:55:17'),(3638,8437,40790,42352,2,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1250.00,NULL,NULL,1,'2023-03-14 11:42:19','2023-03-15 11:55:12','2023-03-15 11:55:12'),(3639,8437,40790,42352,2,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1100.00,NULL,NULL,1,'2023-03-14 11:42:19','2023-03-15 11:53:57','2023-03-15 11:53:57'),(3640,8437,40790,42352,2,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',450.00,NULL,NULL,1,'2023-03-14 11:42:19','2023-03-15 11:53:50','2023-03-15 11:53:50'),(3641,8437,40790,42352,2,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1250.00,NULL,NULL,1,'2023-03-14 11:42:20','2023-03-15 11:54:40','2023-03-15 11:54:40'),(3642,8437,40790,42352,2,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',520.00,NULL,NULL,1,'2023-03-14 11:42:20','2023-03-15 11:53:44','2023-03-15 11:53:44'),(3643,8437,40790,42352,2,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',900.00,NULL,NULL,1,'2023-03-14 11:42:20','2023-03-15 11:52:32','2023-03-15 11:52:32'),(3644,8437,40790,42352,2,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',450.00,NULL,NULL,1,'2023-03-14 11:42:20','2023-03-15 11:52:23','2023-03-15 11:52:23'),(3645,8437,40790,42352,2,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1260.00,NULL,NULL,1,'2023-03-14 11:42:20','2023-03-15 11:52:14','2023-03-15 11:52:14'),(3646,8437,40790,42352,2,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',120.00,NULL,NULL,1,'2023-03-14 11:42:20','2023-03-15 11:52:05','2023-03-15 11:52:05');
INSERT INTO `balance_libro` VALUES (3647,8437,40790,42352,2,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',450.00,NULL,NULL,1,'2023-03-14 11:42:20','2023-03-15 11:51:57','2023-03-15 11:51:57'),(3648,8437,40790,42352,2,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',450.00,NULL,NULL,1,'2023-03-14 11:42:20','2023-03-15 11:51:47','2023-03-15 11:51:47'),(3649,8437,40790,42352,2,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',200.00,NULL,NULL,1,'2023-03-14 11:42:20','2023-03-15 11:51:37','2023-03-15 11:51:37'),(3650,8437,40790,42352,2,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-03-14 11:42:20','2023-03-15 11:51:29','2023-03-15 11:51:29'),(3651,8437,40790,42352,2,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',220.00,NULL,NULL,1,'2023-03-14 11:42:20','2023-03-15 11:51:20','2023-03-15 11:51:20'),(3652,8437,40790,42352,3,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',4000.00,NULL,NULL,1,'2023-03-14 11:52:19','2023-03-14 11:52:19',NULL),(3653,8437,40790,42353,3,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',3000.00,NULL,NULL,1,'2023-03-14 11:53:27','2023-03-14 11:53:27',NULL),(3654,8437,40790,42353,3,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',4000.01,NULL,NULL,1,'2023-03-14 11:55:30','2023-03-14 11:55:30',NULL),(3655,8437,40790,42352,3,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4000.01,NULL,NULL,1,'2023-03-14 11:56:33','2023-03-14 11:56:33',NULL),(3656,8433,41420,752878,8,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',0.00,NULL,NULL,1,'2023-03-14 12:48:44','2023-03-14 12:48:44',NULL),(3657,8433,40724,7530,3,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',122388.00,NULL,NULL,1,'2023-03-15 09:23:54','2023-04-12 11:43:16','2023-04-12 11:43:16'),(3658,8444,40874,130219,2,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',71507.41,NULL,NULL,1,'2023-03-15 10:43:28','2023-03-15 10:43:28',NULL),(3659,8444,40874,130219,2,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',117432.35,NULL,NULL,1,'2023-03-15 10:44:02','2023-03-15 11:17:42','2023-03-15 11:17:42'),(3660,8444,40874,130219,2,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',117932.25,NULL,NULL,1,'2023-03-15 10:44:46','2023-03-15 11:17:25','2023-03-15 11:17:25'),(3661,8444,40874,130219,2,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',72897.15,NULL,NULL,1,'2023-03-15 11:07:46','2023-03-15 11:17:17','2023-03-15 11:17:17'),(3662,8444,40874,130219,2,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',87218.66,NULL,NULL,1,'2023-03-15 11:07:59','2023-03-15 11:17:04','2023-03-15 11:17:04'),(3663,8444,40874,130219,2,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',98907.28,NULL,NULL,1,'2023-03-15 11:08:21','2023-03-15 11:16:51','2023-03-15 11:16:51'),(3664,8444,40874,130219,2,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',110717.18,NULL,NULL,1,'2023-03-15 11:08:32','2023-03-15 11:16:37','2023-03-15 11:16:37'),(3665,8444,40874,130219,2,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',83053.93,NULL,NULL,1,'2023-03-15 11:08:44','2023-03-15 11:16:19','2023-03-15 11:16:19');
INSERT INTO `balance_libro` VALUES (3666,8444,40874,130219,2,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',88605.72,NULL,NULL,1,'2023-03-15 11:08:55','2023-03-15 11:16:09','2023-03-15 11:16:09'),(3667,8444,40874,130219,2,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',128017.04,NULL,NULL,1,'2023-03-15 11:09:10','2023-03-15 11:16:02','2023-03-15 11:16:02'),(3668,8444,40874,130219,2,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',87848.43,NULL,NULL,1,'2023-03-15 11:09:53','2023-03-15 11:15:50','2023-03-15 11:15:50'),(3669,8444,40874,130219,2,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',117768.95,NULL,NULL,1,'2023-03-15 11:10:04','2023-03-15 11:15:37','2023-03-15 11:15:37'),(3670,8444,40874,130219,2,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',37564.83,NULL,NULL,1,'2023-03-15 11:10:15','2023-03-15 11:15:27','2023-03-15 11:15:27'),(3671,8444,40874,130219,2,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',82647.99,NULL,NULL,1,'2023-03-15 11:10:27','2023-03-15 11:12:58','2023-03-15 11:12:58'),(3672,8444,40874,130219,2,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',116210.35,NULL,NULL,1,'2023-03-15 11:10:41','2023-03-15 11:12:28','2023-03-15 11:12:28'),(3673,8444,40874,130219,2,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',123509.72,NULL,NULL,1,'2023-03-15 11:10:52','2023-03-15 11:12:13','2023-03-15 11:12:13'),(3674,8444,40874,130219,2,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',90026.08,NULL,NULL,1,'2023-03-15 11:11:10','2023-03-15 11:12:01','2023-03-15 11:12:01'),(3675,8444,40874,130219,2,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',90026.08,NULL,NULL,1,'2023-03-15 11:12:01','2023-03-15 11:12:01',NULL),(3676,8444,40874,130219,2,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',123509.72,NULL,NULL,1,'2023-03-15 11:12:13','2023-03-15 11:12:13',NULL),(3677,8444,40874,130219,2,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',116210.35,NULL,NULL,1,'2023-03-15 11:12:28','2023-03-15 11:12:28',NULL),(3678,8444,40874,130219,2,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',82647.99,NULL,NULL,1,'2023-03-15 11:12:58','2023-03-15 11:12:58',NULL),(3679,8444,40874,130219,2,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',37564.83,NULL,NULL,1,'2023-03-15 11:15:27','2023-03-15 11:15:27',NULL),(3680,8444,40874,130219,2,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',117768.95,NULL,NULL,1,'2023-03-15 11:15:37','2023-03-15 11:15:37',NULL),(3681,8444,40874,130219,2,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',87848.43,NULL,NULL,1,'2023-03-15 11:15:50','2023-03-15 11:15:50',NULL),(3682,8444,40874,130219,2,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',128017.04,NULL,NULL,1,'2023-03-15 11:16:02','2023-03-15 11:16:02',NULL),(3683,8444,40874,130219,2,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',88605.72,NULL,NULL,1,'2023-03-15 11:16:09','2023-03-15 11:16:09',NULL),(3684,8444,40874,130219,2,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',83053.93,NULL,NULL,1,'2023-03-15 11:16:19','2023-03-15 11:16:19',NULL),(3685,8444,40874,130219,2,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',110717.18,NULL,NULL,1,'2023-03-15 11:16:37','2023-03-15 11:16:37',NULL);
INSERT INTO `balance_libro` VALUES (3686,8444,40874,130219,2,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',98907.28,NULL,NULL,1,'2023-03-15 11:16:51','2023-03-15 11:16:51',NULL),(3687,8444,40874,130219,2,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',87218.66,NULL,NULL,1,'2023-03-15 11:17:04','2023-03-15 11:17:04',NULL),(3688,8444,40874,130219,2,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',72897.15,NULL,NULL,1,'2023-03-15 11:17:17','2023-03-15 11:17:17',NULL),(3689,8444,40874,130219,2,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',117932.25,NULL,NULL,1,'2023-03-15 11:17:25','2023-03-15 11:17:25',NULL),(3690,8444,40874,130219,2,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',117432.35,NULL,NULL,1,'2023-03-15 11:17:42','2023-03-15 11:17:42',NULL),(3691,8437,40800,59017,3,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',7234.18,NULL,NULL,1,'2023-03-15 13:13:13','2023-03-15 13:13:13',NULL),(3692,8437,40800,59017,3,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',20800.59,NULL,NULL,1,'2023-03-15 13:16:58','2023-03-15 13:16:58',NULL),(3693,8437,41145,528664,3,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',299544.73,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3694,8437,41145,528664,3,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',185098.27,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3695,8437,41145,528664,3,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',18000.00,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3696,8437,41145,528664,3,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',119175.43,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3697,8437,41145,528664,3,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',140867.13,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3698,8437,41145,528664,3,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',158145.04,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3699,8437,41145,528664,3,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',243702.89,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3700,8437,41145,528664,3,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',99450.00,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3701,8437,41145,528664,3,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',87629.64,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3702,8437,41145,528664,3,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',166257.42,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3703,8437,41145,528664,3,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',128744.38,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3704,8437,41145,528664,3,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',155615.26,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3705,8437,41145,528664,3,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',6000.00,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL);
INSERT INTO `balance_libro` VALUES (3706,8437,41145,528664,3,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',196084.68,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3707,8437,41145,528664,3,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',227928.07,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3708,8437,41145,528664,3,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',135749.25,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3709,8437,41145,528664,3,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',72365.90,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3710,8437,41145,528664,3,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',29742.18,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3711,8437,41145,528664,3,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',21043.12,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3712,8437,41145,528664,3,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',769.81,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3713,8437,41145,528664,3,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',8748.84,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3714,8437,41145,528664,3,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',231391.97,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3715,8437,41145,528664,3,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',170691.85,NULL,NULL,1,'2023-03-15 13:31:42','2023-03-15 13:31:42',NULL),(3716,8437,41145,528664,3,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',142336.44,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3717,8437,41145,528664,3,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',165701.10,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3718,8437,41145,528664,3,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',136743.75,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3719,8437,41145,528664,3,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',93219.70,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3720,8437,41145,528664,3,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',498.90,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3721,8437,41145,528664,3,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',263418.41,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3722,8437,41145,528664,3,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',68207.32,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3723,8437,41145,528664,3,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',137970.30,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3724,8437,41145,528664,3,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',135919.42,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3725,8437,41145,528664,3,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',95633.36,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL);
INSERT INTO `balance_libro` VALUES (3726,8437,41145,528664,3,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',513209.66,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3727,8437,41145,528664,3,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',161277.15,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3728,8437,41145,528664,3,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',155426.97,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3729,8437,41145,528664,3,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',136521.65,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3730,8437,41145,528664,3,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',171140.84,NULL,NULL,1,'2023-03-15 13:31:43','2023-03-15 13:31:43',NULL),(3731,8437,41145,528664,2,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1823250.00,NULL,NULL,1,'2023-03-15 13:32:00','2023-03-15 13:32:00',NULL),(3732,8437,41145,528664,2,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1823250.00,NULL,NULL,1,'2023-03-15 13:32:00','2023-03-15 13:32:00',NULL),(3733,8437,41145,528664,2,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',10939.50,NULL,NULL,1,'2023-03-15 13:32:00','2023-03-15 13:32:00',NULL),(3734,8437,41145,528664,2,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',109200.00,NULL,NULL,1,'2023-03-15 13:32:00','2023-03-15 13:32:00',NULL),(3735,8437,41145,528664,2,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',45310.00,NULL,NULL,1,'2023-03-15 13:32:00','2023-03-15 13:32:00',NULL),(3736,8437,41145,528664,2,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1823250.00,NULL,NULL,1,'2023-03-15 13:32:00','2023-03-15 13:32:00',NULL),(3737,8437,41145,528664,2,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1823250.00,NULL,NULL,1,'2023-03-15 13:32:00','2023-03-15 13:32:00',NULL),(3738,8437,41145,528664,3,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',134524.49,NULL,NULL,1,'2023-03-15 13:39:00','2023-03-15 13:39:00',NULL),(3739,8437,40790,42352,2,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',160072.00,NULL,NULL,1,'2023-03-15 13:47:51','2023-03-15 13:47:51',NULL),(3740,8437,40885,146884,3,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3050.01,NULL,NULL,1,'2023-03-15 13:57:51','2023-03-17 14:06:25','2023-03-17 14:06:25'),(3741,8437,40885,146884,3,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',9774.13,NULL,NULL,1,'2023-03-15 13:57:51','2023-03-17 14:12:13','2023-03-17 14:12:13'),(3742,8437,40885,146884,3,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',110001.10,NULL,NULL,1,'2023-03-15 13:57:51','2023-03-15 13:57:51',NULL),(3743,8437,40903,174154,3,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',81070.00,NULL,NULL,1,'2023-03-15 14:36:53','2023-03-15 14:36:53',NULL),(3744,8437,40884,145369,3,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3050.01,NULL,NULL,1,'2023-03-15 14:43:24','2023-03-15 14:43:24',NULL),(3745,8437,40884,145369,3,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',22999.01,NULL,NULL,1,'2023-03-15 14:43:24','2023-03-15 14:43:24',NULL);
INSERT INTO `balance_libro` VALUES (3746,8437,40884,145369,3,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',11773.19,NULL,NULL,1,'2023-03-15 14:43:24','2023-03-15 14:43:24',NULL),(3747,8437,40884,145369,3,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',33339.51,NULL,NULL,1,'2023-03-15 14:43:24','2023-03-15 14:43:24',NULL),(3748,8437,40884,145369,3,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',242.92,NULL,NULL,1,'2023-03-15 14:43:24','2023-03-29 10:04:37','2023-03-29 10:04:37'),(3749,8437,40884,145369,3,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',120879.00,NULL,NULL,1,'2023-03-15 14:43:24','2023-03-15 14:43:24',NULL),(3750,8437,40884,145369,3,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4500.00,NULL,NULL,1,'2023-03-15 14:43:24','2023-03-15 14:43:24',NULL),(3751,8437,40884,145369,2,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',90741.00,NULL,NULL,1,'2023-03-15 14:43:36','2023-03-23 09:13:59','2023-03-23 09:13:59'),(3752,8437,40884,145369,2,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',33339.51,NULL,NULL,1,'2023-03-15 14:45:38','2023-03-15 14:49:53','2023-03-15 14:49:53'),(3753,8437,40884,145369,2,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',15133.23,NULL,NULL,1,'2023-03-15 14:47:35','2023-03-15 14:49:48','2023-03-15 14:49:48'),(3754,8437,40884,145369,2,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',19500.00,NULL,NULL,1,'2023-03-15 14:49:19','2023-03-15 14:49:43','2023-03-15 14:49:43'),(3755,8437,40884,145369,3,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',15133.23,NULL,NULL,1,'2023-03-15 14:51:46','2023-03-15 14:51:46',NULL),(3756,8437,40884,145369,3,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',19500.00,NULL,NULL,1,'2023-03-15 14:52:55','2023-03-15 14:52:55',NULL),(3757,7931,40719,19,22,76,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,76,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2500.00,'',NULL,1,'2023-03-16 08:04:45','2023-03-16 08:04:45',NULL),(3758,7931,40719,20,22,77,'App\\Models\\CtaCteTesoreria',NULL,NULL,NULL,NULL,77,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3000.00,'',NULL,1,'2023-03-16 08:07:14','2023-03-16 08:07:14',NULL),(3759,7931,40719,20,20,3641,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3641,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',10000.00,NULL,NULL,1,'2023-03-16 08:10:13','2023-03-16 08:10:13',NULL),(3760,8437,40880,139309,2,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',57717.00,NULL,NULL,1,'2023-03-16 09:20:09','2023-03-16 09:20:09',NULL),(3761,8437,40880,139309,2,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4813877.25,NULL,NULL,1,'2023-03-16 09:20:09','2023-03-16 09:20:09',NULL),(3762,8437,40880,139309,3,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2636.71,NULL,NULL,1,'2023-03-16 09:20:23','2023-03-16 09:20:23',NULL),(3763,8437,40880,139309,3,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2380.00,NULL,NULL,1,'2023-03-16 09:20:23','2023-03-16 09:20:23',NULL),(3764,8437,40880,139309,3,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',21548.00,NULL,NULL,1,'2023-03-16 09:20:23','2023-03-16 09:20:23',NULL),(3765,8437,40880,139309,3,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8500.00,NULL,NULL,1,'2023-03-16 09:20:23','2023-03-16 09:20:23',NULL);
INSERT INTO `balance_libro` VALUES (3766,8437,40880,139309,3,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',420.00,NULL,NULL,1,'2023-03-16 09:20:23','2023-03-16 09:20:23',NULL),(3767,8437,40880,139309,3,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1550.00,NULL,NULL,1,'2023-03-16 09:20:24','2023-03-16 09:20:24',NULL),(3768,8437,40880,139309,3,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',30000.00,NULL,NULL,1,'2023-03-16 09:20:24','2023-03-16 09:22:56','2023-03-16 09:22:56'),(3769,8437,40880,139309,3,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',2171531.06,NULL,NULL,1,'2023-03-16 09:20:24','2023-03-16 09:20:24',NULL),(3770,8437,40880,139309,3,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7300.00,NULL,NULL,1,'2023-03-16 09:20:24','2023-03-16 09:24:26','2023-03-16 09:24:26'),(3771,8437,40880,139309,3,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',30000.00,NULL,NULL,1,'2023-03-16 09:22:56','2023-03-16 09:22:56',NULL),(3772,8437,40880,139309,3,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7300.00,NULL,NULL,1,'2023-03-16 09:24:26','2023-03-16 09:24:26',NULL),(3773,8437,40880,139309,3,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',2000.00,NULL,NULL,1,'2023-03-16 09:28:51','2023-03-16 09:28:51',NULL),(3774,8437,40880,139309,3,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',6000.00,NULL,NULL,1,'2023-03-16 09:29:58','2023-03-16 09:29:58',NULL),(3775,8437,40880,139309,3,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2502.20,NULL,NULL,1,'2023-03-16 09:31:22','2023-03-16 09:31:22',NULL),(3776,8437,40880,139309,3,3327,'App\\Models\\Receipt',3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',37755.09,NULL,NULL,1,'2023-03-16 09:32:57','2023-03-16 09:32:57',NULL),(3777,8437,40880,139309,3,3328,'App\\Models\\Receipt',3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',5670.00,NULL,NULL,1,'2023-03-16 09:37:21','2023-03-16 09:37:21',NULL),(3778,8437,40880,139309,3,3329,'App\\Models\\Receipt',3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',5670.00,NULL,NULL,1,'2023-03-16 09:38:34','2023-03-16 09:38:34',NULL),(3779,8437,40880,139309,3,3330,'App\\Models\\Receipt',3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',61457.95,NULL,NULL,1,'2023-03-16 09:41:46','2023-03-16 09:41:46',NULL),(3780,8437,40880,139309,3,3331,'App\\Models\\Receipt',3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',56041.33,NULL,NULL,1,'2023-03-16 09:43:49','2023-03-16 09:43:49',NULL),(3781,8437,40880,139309,3,3332,'App\\Models\\Receipt',3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',3200.00,NULL,NULL,1,'2023-03-16 09:44:54','2023-03-16 09:44:54',NULL),(3782,8437,40880,139309,3,3333,'App\\Models\\Receipt',3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',8000.00,NULL,NULL,1,'2023-03-16 09:46:20','2023-03-16 09:46:20',NULL),(3783,8437,40880,139309,3,3334,'App\\Models\\Receipt',3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',3800.00,NULL,NULL,1,'2023-03-16 09:47:33','2023-03-16 09:47:33',NULL),(3784,8437,40880,139309,3,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',9000.00,NULL,NULL,1,'2023-03-16 09:48:39','2023-03-16 09:48:39',NULL),(3785,8437,40878,136279,3,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',77221.06,NULL,NULL,1,'2023-03-16 10:01:34','2023-03-30 08:40:33','2023-03-30 08:40:33');
INSERT INTO `balance_libro` VALUES (3786,8437,40878,136279,3,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',24642.35,NULL,NULL,1,'2023-03-16 10:01:34','2023-03-30 08:41:24','2023-03-30 08:41:24'),(3787,8437,40878,136279,3,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',12561.98,NULL,NULL,1,'2023-03-16 10:01:34','2023-03-30 08:56:13','2023-03-30 08:56:13'),(3788,8437,40878,136279,3,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',19679.75,NULL,NULL,1,'2023-03-16 10:01:34','2023-03-30 08:42:08','2023-03-30 08:42:08'),(3789,8437,40878,136279,3,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1677.27,NULL,NULL,1,'2023-03-16 10:01:34','2023-03-30 08:42:45','2023-03-30 08:42:45'),(3790,8437,40878,136279,3,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',95895.36,NULL,NULL,1,'2023-03-16 10:01:34','2023-03-16 10:01:34',NULL),(3791,8437,40878,136279,3,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',20353.70,NULL,NULL,1,'2023-03-16 10:01:34','2023-03-23 09:37:52','2023-03-23 09:37:52'),(3792,8437,40878,136279,3,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-16 10:01:34','2023-03-22 12:09:34','2023-03-22 12:09:34'),(3793,8434,40846,119617,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8222.98,NULL,NULL,1,'2023-03-16 10:04:43','2023-03-18 21:19:02','2023-03-18 21:19:02'),(3794,8434,40846,119617,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8486.11,NULL,NULL,1,'2023-03-16 10:05:15','2023-03-17 17:29:20','2023-03-17 17:29:20'),(3795,8434,40846,119617,8,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1946.66,NULL,NULL,1,'2023-03-16 10:34:23','2023-03-16 10:34:23',NULL),(3796,8434,40846,119617,8,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',81.66,NULL,NULL,1,'2023-03-16 10:34:23','2023-03-16 10:34:23',NULL),(3797,8434,40846,119617,8,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3.05,NULL,NULL,1,'2023-03-16 10:34:23','2023-03-16 10:34:23',NULL),(3835,8437,41145,528664,7,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.22,NULL,NULL,1,'2023-03-16 12:21:50','2023-03-16 12:21:50',NULL),(3836,8437,41145,528664,7,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.97,NULL,NULL,1,'2023-03-16 12:21:50','2023-03-16 12:21:50',NULL),(3837,8437,41145,528664,7,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.15,NULL,NULL,1,'2023-03-16 12:21:50','2023-03-16 12:21:50',NULL),(3838,8437,41145,528664,7,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.51,NULL,NULL,1,'2023-03-16 12:21:50','2023-03-16 12:21:50',NULL),(3839,8437,41145,528664,7,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.97,NULL,NULL,1,'2023-03-16 12:21:50','2023-03-16 12:21:50',NULL),(3840,8437,41145,528664,7,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.07,NULL,NULL,1,'2023-03-16 12:21:50','2023-03-16 12:21:50',NULL),(3841,8437,41145,528664,7,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.40,NULL,NULL,1,'2023-03-16 12:21:50','2023-03-16 12:21:50',NULL),(3842,8437,41145,528664,7,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.12,NULL,NULL,1,'2023-03-16 12:21:50','2023-03-16 12:21:50',NULL);
INSERT INTO `balance_libro` VALUES (3843,8437,41145,528664,7,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.14,NULL,NULL,1,'2023-03-16 12:21:50','2023-03-16 12:21:50',NULL),(3844,8437,41145,528664,7,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.51,NULL,NULL,1,'2023-03-16 12:21:50','2023-03-16 12:21:50',NULL),(3845,8437,41145,528664,7,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.16,NULL,NULL,1,'2023-03-16 12:21:51','2023-03-16 12:21:51',NULL),(3846,8437,41145,528664,7,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.99,NULL,NULL,1,'2023-03-16 12:21:51','2023-03-16 12:21:51',NULL),(3847,8437,41145,528664,7,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.20,NULL,NULL,1,'2023-03-16 12:21:51','2023-03-16 12:21:51',NULL),(3848,8437,41145,528664,7,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.12,NULL,NULL,1,'2023-03-16 12:21:51','2023-03-16 12:21:51',NULL),(3849,8437,41145,528664,7,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.31,NULL,NULL,1,'2023-03-16 12:21:51','2023-03-16 12:21:51',NULL),(3850,8437,41145,528664,7,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.37,NULL,NULL,1,'2023-03-16 12:21:51','2023-03-16 12:21:51',NULL),(3851,8437,41145,528664,7,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.94,NULL,NULL,1,'2023-03-16 12:21:51','2023-03-16 12:21:51',NULL),(3852,8437,41145,528664,7,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.34,NULL,NULL,1,'2023-03-16 12:21:51','2023-03-16 12:21:51',NULL),(3853,8437,41145,528664,7,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.38,NULL,NULL,1,'2023-03-16 12:21:51','2023-03-16 12:21:51',NULL),(3854,8437,41145,528664,7,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',70641.60,NULL,NULL,1,'2023-03-16 12:22:05','2023-04-17 11:22:21','2023-04-17 11:22:21'),(3855,8433,41421,754393,16,2219,'App\\Models\\PeriodLiquidation',NULL,2219,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',46196.78,NULL,NULL,1,'2023-03-16 14:51:45','2023-03-16 15:06:20','2023-03-16 15:06:20'),(3856,8433,41421,754393,16,2221,'App\\Models\\PeriodLiquidation',NULL,2221,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',46196.78,NULL,NULL,1,'2023-03-16 15:08:03','2023-03-22 13:17:49','2023-03-22 13:17:49'),(3857,8433,40788,39325,16,2234,'App\\Models\\PeriodLiquidation',NULL,2234,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-03-17 10:46:33','2023-03-17 10:46:33',NULL),(3858,8433,40881,140824,7,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',135.10,NULL,NULL,1,'2023-03-17 11:09:41','2023-03-17 11:09:41',NULL),(3859,8433,40881,140824,7,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',3238.03,NULL,NULL,1,'2023-03-17 11:09:41','2023-03-17 11:09:41',NULL),(3861,8435,41734,755908,3,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',9276.22,NULL,NULL,1,'2023-03-17 11:14:43','2023-03-17 11:14:43',NULL),(3864,8435,41734,755908,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',28745.89,NULL,NULL,1,'2023-03-17 11:25:17','2023-03-17 11:25:17',NULL),(3865,8433,41418,751363,7,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2432.43,NULL,NULL,1,'2023-03-17 11:36:48','2023-03-17 11:36:48',NULL);
INSERT INTO `balance_libro` VALUES (3866,8437,41734,755908,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',24747.78,NULL,NULL,1,'2023-03-17 11:42:03','2023-03-17 11:42:03',NULL),(3867,8437,41734,755908,3,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',15706.02,NULL,NULL,1,'2023-03-17 11:46:16','2023-03-17 11:46:16',NULL),(3868,8437,41734,755908,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',35169.66,NULL,NULL,1,'2023-03-17 11:47:36','2023-03-17 11:47:36',NULL),(3869,8437,41734,755908,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',22559.80,NULL,NULL,1,'2023-03-17 11:50:52','2023-03-17 11:50:52',NULL),(3870,8437,41734,755908,3,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',25616.01,NULL,NULL,1,'2023-03-17 11:52:05','2023-03-17 11:52:05',NULL),(3871,8437,41734,755908,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',34447.55,NULL,NULL,1,'2023-03-17 11:53:07','2023-03-17 12:04:06','2023-03-17 12:04:06'),(3872,8437,41734,755908,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',29376.75,NULL,NULL,1,'2023-03-17 11:54:24','2023-03-17 11:54:24',NULL),(3873,8437,41734,755908,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',29376.75,NULL,NULL,1,'2023-03-17 11:56:05','2023-03-17 11:56:05',NULL),(3874,8437,41734,755908,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',49814.89,NULL,NULL,1,'2023-03-17 11:57:16','2023-03-17 11:57:16',NULL),(3875,8437,41734,755908,3,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',49814.89,NULL,NULL,1,'2023-03-17 11:58:42','2023-03-17 11:58:42',NULL),(3877,8433,40781,28720,8,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',4827.40,NULL,NULL,1,'2023-03-17 12:03:32','2023-03-17 12:03:32',NULL),(3878,8433,40781,28720,8,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',58.66,NULL,NULL,1,'2023-03-17 12:03:32','2023-03-17 12:03:32',NULL),(3879,8437,41734,755908,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',34447.55,NULL,NULL,1,'2023-03-17 12:04:06','2023-03-17 12:04:06',NULL),(3880,8434,40846,119617,3,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',12793.55,NULL,NULL,1,'2023-03-17 12:36:42','2023-03-17 12:36:42',NULL),(3881,8434,40846,119617,21,3691,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3691,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',12793.55,NULL,NULL,1,'2023-03-17 12:37:40','2023-03-17 12:37:40',NULL),(3882,8435,41734,755908,8,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',267.96,NULL,NULL,1,'2023-03-17 12:49:37','2023-03-17 12:49:37',NULL),(3883,8434,40846,119617,3,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',6682.15,NULL,NULL,1,'2023-03-17 12:57:18','2023-03-17 12:57:18',NULL),(3884,8434,40846,119617,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',78615.71,NULL,NULL,1,'2023-03-17 12:59:08','2023-03-17 17:28:02','2023-03-17 17:28:02'),(3887,8436,40846,119617,2,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13291.72,NULL,NULL,1,'2023-03-17 13:15:42','2023-03-17 17:22:03','2023-03-17 17:22:03'),(3888,8436,40846,119617,2,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30103.75,NULL,NULL,1,'2023-03-17 13:17:23','2023-03-17 17:21:48','2023-03-17 17:21:48');
INSERT INTO `balance_libro` VALUES (3890,8437,40885,146884,3,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3050.00,NULL,NULL,1,'2023-03-17 14:06:25','2023-03-17 14:06:25',NULL),(3891,8437,40885,146884,3,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',9774.13,NULL,NULL,1,'2023-03-17 14:12:13','2023-03-17 14:12:13',NULL),(3892,8435,41734,755908,2,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',16400.00,NULL,NULL,1,'2023-03-17 15:30:38','2023-03-17 15:30:38',NULL),(3893,8435,41734,755908,7,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',92.70,NULL,NULL,1,'2023-03-17 15:56:07','2023-03-17 15:56:07',NULL),(3894,8435,41734,755908,7,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',42.00,NULL,NULL,1,'2023-03-17 15:56:07','2023-03-17 15:56:07',NULL),(3895,8435,41734,755908,7,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',72.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3896,8435,41734,755908,7,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',70.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3897,8435,41734,755908,7,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',182.50,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3898,8435,41734,755908,7,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',18.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3899,8435,41734,755908,7,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',874.10,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3900,8435,41734,755908,7,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',117.50,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3901,8435,41734,755908,7,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',71.50,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3902,8435,41734,755908,7,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',187.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3903,8435,41734,755908,7,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',29.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3904,8435,41734,755908,7,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',129.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3905,8435,41734,755908,7,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',49.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3906,8435,41734,755908,7,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',92.50,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3907,8435,41734,755908,7,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',210.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3908,8435,41734,755908,7,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',784.25,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3909,8435,41734,755908,7,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',123.25,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3910,8435,41734,755908,7,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',130.50,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL);
INSERT INTO `balance_libro` VALUES (3911,8435,41734,755908,7,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',228.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3912,8435,41734,755908,7,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',150.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3913,8435,41734,755908,7,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',232.50,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3914,8435,41734,755908,7,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',51.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3915,8435,41734,755908,7,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',80.50,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3916,8435,41734,755908,7,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',120.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3917,8435,41734,755908,7,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',163.25,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3918,8435,41734,755908,7,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',185.76,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3919,8435,41734,755908,7,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1439.05,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3920,8435,41734,755908,7,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',25.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3921,8435,41734,755908,7,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',45.50,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3922,8435,41734,755908,7,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',141.50,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3923,8435,41734,755908,7,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',518.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3924,8435,41734,755908,7,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',75.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3925,8435,41734,755908,7,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',136.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3926,8435,41734,755908,7,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',69.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3927,8435,41734,755908,7,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',25.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3928,8435,41734,755908,7,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',70.00,NULL,NULL,1,'2023-03-17 15:56:08','2023-03-17 15:56:08',NULL),(3929,8435,41734,755908,7,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',225.00,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3930,8435,41734,755908,7,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',14.00,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3931,8435,41734,755908,7,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',56.50,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL);
INSERT INTO `balance_libro` VALUES (3932,8435,41734,755908,7,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1708.25,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3933,8435,41734,755908,7,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',138.00,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3934,8435,41734,755908,7,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',271.75,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3935,8435,41734,755908,7,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',50.00,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3936,8435,41734,755908,7,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',50.00,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3937,8435,41734,755908,7,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',219.75,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3938,8435,41734,755908,7,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',169.00,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3939,8435,41734,755908,7,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1626.35,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3940,8435,41734,755908,7,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',219.75,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3941,8435,41734,755908,7,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1625.52,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3942,8435,41734,755908,7,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',122.00,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3943,8435,41734,755908,7,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',386.75,NULL,NULL,1,'2023-03-17 15:56:09','2023-03-17 15:56:09',NULL),(3944,8434,40846,119617,3,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13291.72,NULL,NULL,1,'2023-03-17 17:16:51','2023-03-17 17:19:50','2023-03-17 17:19:50'),(3945,8434,40846,119617,3,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30103.75,NULL,NULL,1,'2023-03-17 17:16:51','2023-03-17 17:18:31','2023-03-17 17:18:31'),(3946,8434,40846,119617,3,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30103.75,NULL,NULL,1,'2023-03-17 17:18:31','2023-03-17 17:18:55','2023-03-17 17:18:55'),(3947,8434,40846,119617,3,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',30103.75,NULL,NULL,1,'2023-03-17 17:18:55','2023-03-17 17:18:55',NULL),(3948,8434,40846,119617,3,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',18583.50,NULL,NULL,1,'2023-03-17 17:19:21','2023-03-17 17:19:21',NULL),(3949,8434,40846,119617,3,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13291.72,NULL,NULL,1,'2023-03-17 17:19:50','2023-03-17 20:07:13','2023-03-17 20:07:13'),(3950,8434,40846,119617,3,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',78615.71,NULL,NULL,1,'2023-03-17 17:28:02','2023-03-17 17:28:02',NULL),(3951,8434,40846,119617,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8222.98,NULL,NULL,1,'2023-03-17 17:29:20','2023-03-18 21:16:44','2023-03-18 21:16:44');
INSERT INTO `balance_libro` VALUES (3952,8434,40846,119617,16,2330,'App\\Models\\PeriodLiquidation',NULL,2330,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',321901.63,NULL,NULL,1,'2023-03-17 17:49:09','2023-03-17 18:47:48','2023-03-17 18:47:48'),(3953,8434,40846,119617,3,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',6250.89,NULL,NULL,1,'2023-03-17 18:49:47','2023-03-17 18:49:47',NULL),(3954,8434,40846,119617,3,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5232.63,NULL,NULL,1,'2023-03-17 18:52:44','2023-03-17 18:52:44',NULL),(3955,8434,40846,119617,3,3955,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',18492.88,'Gastos Bancarios 02-2023',NULL,1,'2023-03-17 19:04:24','2023-03-17 19:04:24',NULL),(3956,8434,40846,119617,3,3956,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',78656.60,'Pago Sicore mensual 01-2023',NULL,1,'2023-03-17 19:08:10','2023-03-17 19:08:10',NULL),(3957,8434,40846,119617,3,3957,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',13758.00,'Pago a cuenta SICORE 02-2023',NULL,1,'2023-03-17 19:12:29','2023-03-17 19:12:29',NULL),(3958,8434,40846,119617,21,3709,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3709,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',6682.15,NULL,NULL,1,'2023-03-17 19:16:27','2023-03-17 19:16:27',NULL),(3959,8434,40846,119617,3,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13291.72,NULL,NULL,1,'2023-03-17 20:07:13','2023-03-17 20:07:13',NULL),(3960,8434,40846,119617,3,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',12236.03,NULL,NULL,1,'2023-03-17 20:14:44','2023-03-17 20:14:44',NULL),(3961,8434,40846,119617,21,3712,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3712,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',12236.03,NULL,NULL,1,'2023-03-17 20:16:13','2023-03-17 20:16:13',NULL),(3962,8434,40846,119617,3,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',89677.00,NULL,NULL,1,'2023-03-18 21:07:36','2023-03-18 21:07:36',NULL),(3963,8434,40846,119617,3,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',89677.00,NULL,NULL,1,'2023-03-18 21:08:22','2023-03-18 21:08:22',NULL),(3964,8434,40846,119617,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',15000.01,NULL,NULL,1,'2023-03-18 21:10:30','2023-03-18 21:22:16','2023-03-18 21:22:16'),(3965,8434,40846,119617,3,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8222.98,NULL,NULL,1,'2023-03-18 21:16:44','2023-03-18 21:16:44',NULL),(3966,8434,40846,119617,3,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8222.98,NULL,NULL,1,'2023-03-18 21:19:02','2023-03-18 21:19:02',NULL),(3967,8434,40846,119617,3,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',15000.01,NULL,NULL,1,'2023-03-18 21:22:16','2023-03-18 21:22:16',NULL),(3968,8434,40846,119617,3,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1275.44,NULL,NULL,1,'2023-03-18 21:25:49','2023-03-18 21:25:49',NULL),(3969,8434,40846,119617,3,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',398.18,NULL,NULL,1,'2023-03-18 21:26:46','2023-03-18 21:26:46',NULL),(3970,8434,40846,119617,3,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1544.67,NULL,NULL,1,'2023-03-18 21:27:56','2023-03-18 21:27:56',NULL),(3971,8434,40846,119617,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',500.00,NULL,NULL,1,'2023-03-18 21:29:26','2023-03-20 23:14:47','2023-03-20 23:14:47');
INSERT INTO `balance_libro` VALUES (3972,8434,40846,119617,3,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',100846.00,NULL,NULL,1,'2023-03-18 21:38:52','2023-03-18 21:38:52',NULL),(3973,8434,40846,119617,21,3724,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3724,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',100846.00,NULL,NULL,1,'2023-03-18 21:42:54','2023-03-18 21:42:54',NULL),(3974,8434,40846,119617,3,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',89000.00,NULL,NULL,1,'2023-03-18 21:44:10','2023-03-18 21:44:10',NULL),(3975,8434,40846,119617,21,3726,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3726,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',89000.00,NULL,NULL,1,'2023-03-18 21:45:12','2023-03-18 21:45:12',NULL),(3976,8434,40846,119617,21,3727,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3727,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',500.00,NULL,NULL,1,'2023-03-18 21:58:02','2023-03-20 23:14:00','2023-03-20 23:14:00'),(3977,8434,40846,119617,21,3728,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3728,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1544.67,NULL,NULL,1,'2023-03-18 22:00:24','2023-03-18 22:00:24',NULL),(3978,8434,40846,119617,21,3729,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3729,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',398.18,NULL,NULL,1,'2023-03-18 22:01:07','2023-03-18 22:01:07',NULL),(3979,8434,40846,119617,21,3730,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3730,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1275.44,NULL,NULL,1,'2023-03-18 22:02:07','2023-03-18 22:02:07',NULL),(3980,8434,40846,119617,16,2364,'App\\Models\\PeriodLiquidation',NULL,2364,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',321901.63,NULL,NULL,1,'2023-03-20 10:42:41','2023-03-20 22:37:52','2023-03-20 22:37:52'),(3981,8433,40881,140824,3,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',6204.48,NULL,NULL,1,'2023-03-20 11:31:42','2023-03-27 13:13:10','2023-03-27 13:13:10'),(3982,8433,40881,140824,3,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',5244.78,NULL,NULL,1,'2023-03-20 11:32:37','2023-03-20 11:32:37',NULL),(3983,8433,40881,140824,3,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',11421.83,NULL,NULL,1,'2023-03-20 11:37:33','2023-03-20 11:38:25','2023-03-20 11:38:25'),(3984,8433,40881,140824,3,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',11893.81,NULL,NULL,1,'2023-03-20 11:38:25','2023-03-27 13:08:33','2023-03-27 13:08:33'),(3985,8433,40881,140824,7,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-20 11:42:42','2023-03-20 11:42:42',NULL),(3986,8433,40881,140824,7,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-20 11:42:42','2023-03-20 11:42:42',NULL),(3987,8434,40781,28720,3,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',162741.99,NULL,NULL,1,'2023-03-20 12:28:50','2023-03-27 15:03:45','2023-03-27 15:03:45'),(3988,8437,40798,55987,7,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',57010.12,NULL,NULL,1,'2023-03-20 12:29:29','2023-03-20 12:29:29',NULL),(3989,8433,40781,28720,3,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5067.60,NULL,NULL,1,'2023-03-20 13:06:12','2023-03-27 15:05:51','2023-03-27 15:05:51'),(3991,8434,41418,751363,16,2394,'App\\Models\\PeriodLiquidation',NULL,2394,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13480.66,NULL,NULL,1,'2023-03-20 13:18:21','2023-03-20 13:18:21',NULL);
INSERT INTO `balance_libro` VALUES (3992,8434,40781,28720,16,2393,'App\\Models\\PeriodLiquidation',NULL,2393,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',185037.16,NULL,NULL,1,'2023-03-20 13:37:17','2023-03-27 15:00:36','2023-03-27 15:00:36'),(3994,8434,40876,133249,8,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',978.43,NULL,NULL,1,'2023-03-20 13:40:55','2023-03-20 13:40:55',NULL),(3995,8434,40876,133249,3,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',53946.85,NULL,NULL,1,'2023-03-20 13:46:48','2023-03-20 13:48:07','2023-03-20 13:48:07'),(3996,8434,40876,133249,3,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',7242.71,NULL,NULL,1,'2023-03-20 13:47:43','2023-05-08 13:00:37','2023-05-08 13:00:37'),(3997,8434,40876,133249,3,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',53946.86,NULL,NULL,1,'2023-03-20 13:48:07','2023-03-20 13:53:26','2023-03-20 13:53:26'),(3998,8434,40876,133249,3,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',13474.55,NULL,NULL,1,'2023-03-20 13:49:01','2023-03-20 13:50:45','2023-03-20 13:50:45'),(3999,8434,40876,133249,3,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',4876.58,NULL,NULL,1,'2023-03-20 13:49:39','2023-03-20 13:49:39',NULL),(4000,8434,40876,133249,3,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',13636.24,NULL,NULL,1,'2023-03-20 13:50:45','2023-03-20 13:50:45',NULL),(4001,8434,40876,133249,3,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',54572.38,NULL,NULL,1,'2023-03-20 13:53:26','2023-03-20 13:53:26',NULL),(4002,8433,40876,133249,16,2414,'App\\Models\\PeriodLiquidation',NULL,2414,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',49920.77,NULL,NULL,1,'2023-03-20 13:55:15','2023-03-27 15:12:14','2023-03-27 15:12:14'),(4004,8434,40881,140824,8,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',646.02,NULL,NULL,1,'2023-03-20 14:01:27','2023-03-20 14:01:27',NULL),(4005,8434,40881,140824,8,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2953.07,NULL,NULL,1,'2023-03-20 14:01:40','2023-03-20 14:01:40',NULL),(4006,8434,40881,140824,16,2418,'App\\Models\\PeriodLiquidation',NULL,2418,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13370.20,NULL,NULL,1,'2023-03-20 14:03:06','2023-03-27 12:07:25','2023-03-27 12:07:25'),(4007,8434,40724,7531,3,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',9746.54,NULL,NULL,1,'2023-03-20 14:27:01','2023-04-12 13:18:18','2023-04-12 13:18:18'),(4008,8437,40874,130219,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3050.01,NULL,NULL,1,'2023-03-20 14:49:27','2023-03-21 10:17:30','2023-03-21 10:17:30'),(4009,8434,40724,7531,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',262321.95,NULL,NULL,1,'2023-03-20 14:51:27','2023-03-20 14:57:38','2023-03-20 14:57:38'),(4010,8434,40724,7531,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',255855.00,NULL,NULL,1,'2023-03-20 14:57:38','2023-03-20 14:57:38',NULL),(4011,8434,40724,7531,2,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',22880.00,NULL,NULL,1,'2023-03-20 14:59:16','2023-03-20 14:59:16',NULL),(4012,8434,40868,124161,15,2432,'App\\Models\\PeriodLiquidation',NULL,2432,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-03-20 15:32:19','2023-03-20 15:32:19',NULL);
INSERT INTO `balance_libro` VALUES (4013,8434,40798,55987,7,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',8144.30,NULL,NULL,1,'2023-03-20 15:43:49','2023-03-20 15:43:49',NULL),(4014,8434,40798,55987,3,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',148835.05,NULL,NULL,1,'2023-03-20 15:56:46','2023-04-13 12:07:15','2023-04-13 12:07:15'),(4015,8433,40868,124162,3,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',234429.00,NULL,NULL,1,'2023-03-20 15:57:15','2023-04-11 11:14:27','2023-04-11 11:14:27'),(4016,8433,40868,124162,15,2439,'App\\Models\\PeriodLiquidation',NULL,2439,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-03-20 16:04:23','2023-04-11 11:10:51','2023-04-11 11:10:51'),(4017,8434,40724,7531,15,2430,'App\\Models\\PeriodLiquidation',NULL,2430,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',410028.05,NULL,NULL,1,'2023-03-20 16:07:05','2023-03-30 11:27:36','2023-03-30 11:27:36'),(4018,8434,40929,213544,3,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',22930.00,NULL,NULL,1,'2023-03-20 16:40:34','2023-03-20 16:40:34',NULL),(4019,8434,40929,213544,3,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',14540.00,NULL,NULL,1,'2023-03-20 16:41:11','2023-03-20 16:41:11',NULL),(4020,8434,40929,213543,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',22930.00,NULL,NULL,1,'2023-03-20 16:41:18','2023-03-20 16:41:36','2023-03-20 16:41:36'),(4021,8434,40929,213543,3,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',22930.00,NULL,NULL,1,'2023-03-20 16:41:36','2023-03-20 16:41:36',NULL),(4022,8434,40929,213543,3,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',14540.00,NULL,NULL,1,'2023-03-20 16:42:00','2023-03-20 16:42:00',NULL),(4023,8434,40929,213544,15,2442,'App\\Models\\PeriodLiquidation',NULL,2442,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',73872.25,NULL,NULL,1,'2023-03-20 16:44:51','2023-04-03 12:33:16','2023-04-03 12:33:16'),(4024,8434,40846,119617,3,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',13424.28,NULL,NULL,1,'2023-03-20 22:38:15','2023-03-20 22:38:15',NULL),(4025,8434,40846,119617,21,3757,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,3757,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',13424.28,NULL,NULL,1,'2023-03-20 22:39:07','2023-03-20 22:39:07',NULL),(4026,8434,40846,119617,3,4026,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2084.30,'Taxi/UBER Febrero',NULL,1,'2023-03-20 23:11:02','2023-03-20 23:11:02',NULL),(4027,8434,40846,119617,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',500.00,NULL,NULL,1,'2023-03-20 23:14:47','2023-03-31 16:41:23','2023-03-31 16:41:23'),(4028,8433,40846,119617,16,2453,'App\\Models\\PeriodLiquidation',NULL,2453,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',321901.63,NULL,NULL,1,'2023-03-20 23:21:50','2023-03-31 14:08:30','2023-03-31 14:08:30'),(4029,8433,40846,119617,15,2452,'App\\Models\\PeriodLiquidation',NULL,2452,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',6308299.69,NULL,NULL,1,'2023-03-20 23:22:41','2023-03-31 14:08:43','2023-03-31 14:08:43'),(4030,8437,40874,130219,3,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',96715.65,NULL,NULL,1,'2023-03-21 09:44:18','2023-03-21 11:03:21','2023-03-21 11:03:21'),(4031,8437,40874,130219,3,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',31974.40,NULL,NULL,1,'2023-03-21 09:45:23','2023-03-21 09:45:23',NULL);
INSERT INTO `balance_libro` VALUES (4032,8437,40874,130219,3,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',7005.74,NULL,NULL,1,'2023-03-21 09:45:50','2023-03-21 09:45:50',NULL),(4033,8437,40874,130219,3,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',34332.99,NULL,NULL,1,'2023-03-21 09:46:32','2023-03-21 09:46:32',NULL),(4034,8437,40874,130219,3,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',11339.90,NULL,NULL,1,'2023-03-21 09:50:04','2023-03-21 09:50:04',NULL),(4035,8437,40874,130219,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',41922.27,NULL,NULL,1,'2023-03-21 09:50:29','2023-03-21 09:50:48','2023-03-21 09:50:48'),(4036,8437,40874,130219,3,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',41922.27,NULL,NULL,1,'2023-03-21 09:50:48','2023-03-21 09:50:48',NULL),(4037,8437,40874,130219,3,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',68328.70,NULL,NULL,1,'2023-03-21 09:51:19','2023-03-21 09:51:19',NULL),(4038,8437,40874,130219,3,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',93997.21,NULL,NULL,1,'2023-03-21 09:51:49','2023-03-21 09:51:49',NULL),(4039,8437,40874,130219,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',172203.24,NULL,NULL,1,'2023-03-21 09:52:15','2023-03-21 10:25:42','2023-03-21 10:25:42'),(4040,8437,40874,130219,3,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',95331.19,NULL,NULL,1,'2023-03-21 09:52:46','2023-03-21 10:23:33','2023-03-21 10:23:33'),(4041,8437,40874,130219,3,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',32018.31,NULL,NULL,1,'2023-03-21 09:57:19','2023-03-21 09:57:19',NULL),(4042,8437,40874,130219,3,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',20765.11,NULL,NULL,1,'2023-03-21 09:58:14','2023-03-21 09:58:14',NULL),(4043,8437,40874,130219,3,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',31097.38,NULL,NULL,1,'2023-03-21 09:58:50','2023-03-21 09:58:50',NULL),(4044,8437,40874,130219,3,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',23463.78,NULL,NULL,1,'2023-03-21 09:59:30','2023-03-21 09:59:30',NULL),(4045,8437,40874,130219,3,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',13072.23,NULL,NULL,1,'2023-03-21 10:00:30','2023-03-21 10:00:30',NULL),(4046,8437,40874,130219,3,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',7879.75,NULL,NULL,1,'2023-03-21 10:00:59','2023-03-21 10:00:59',NULL),(4047,8437,40874,130219,3,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',34047.94,NULL,NULL,1,'2023-03-21 10:01:51','2023-03-21 10:11:48','2023-03-21 10:11:48'),(4048,8437,40874,130219,3,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',13017.90,NULL,NULL,1,'2023-03-21 10:02:31','2023-03-21 10:02:31',NULL),(4049,8437,40874,130219,3,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',31411.41,NULL,NULL,1,'2023-03-21 10:03:03','2023-03-21 10:03:03',NULL),(4050,8437,40874,130219,3,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',37921.10,NULL,NULL,1,'2023-03-21 10:04:26','2023-03-21 10:04:26',NULL),(4051,8437,40874,130219,3,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',79791.76,NULL,NULL,1,'2023-03-21 10:06:19','2023-03-21 10:06:19',NULL);
INSERT INTO `balance_libro` VALUES (4052,8437,40874,130219,3,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3627.74,NULL,NULL,1,'2023-03-21 10:06:54','2023-03-21 10:06:54',NULL),(4053,8437,40874,130219,3,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',76057.83,NULL,NULL,1,'2023-03-21 10:07:41','2023-03-21 10:07:41',NULL),(4054,8437,40874,130219,3,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',31316.27,NULL,NULL,1,'2023-03-21 10:09:03','2023-03-21 10:09:03',NULL),(4055,8437,40874,130219,3,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',3086.71,NULL,NULL,1,'2023-03-21 10:09:50','2023-03-21 10:09:50',NULL),(4056,8437,40874,130219,3,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',35797.81,NULL,NULL,1,'2023-03-21 10:11:48','2023-03-21 10:11:48',NULL),(4057,8433,40783,31749,3,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',12562.73,NULL,NULL,1,'2023-03-21 10:14:19','2023-03-21 10:14:19',NULL),(4058,8433,40783,31749,3,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',21450.00,NULL,NULL,1,'2023-03-21 10:15:31','2023-03-21 10:15:31',NULL),(4059,8437,40874,130219,3,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',3050.01,NULL,NULL,1,'2023-03-21 10:17:30','2023-03-21 10:17:30',NULL),(4060,8437,40874,130219,3,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',92172.19,NULL,NULL,1,'2023-03-21 10:23:33','2023-03-21 10:23:33',NULL),(4061,8437,40874,130219,3,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',171535.08,NULL,NULL,1,'2023-03-21 10:25:42','2023-03-21 10:25:42',NULL),(4062,8437,40874,130219,3,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',96715.65,NULL,NULL,1,'2023-03-21 11:03:21','2023-03-21 11:03:21',NULL),(4063,8437,40874,130219,3,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',19274.83,NULL,NULL,1,'2023-03-21 11:37:34','2023-03-21 11:37:34',NULL),(4064,8437,40874,130219,3,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',31202.57,NULL,NULL,1,'2023-03-21 11:38:09','2023-03-21 11:38:09',NULL),(4065,8437,40874,130219,3,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',16611.01,NULL,NULL,1,'2023-03-21 11:38:45','2023-03-21 11:38:45',NULL),(4066,8437,40874,130219,3,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',20412.02,NULL,NULL,1,'2023-03-21 11:39:22','2023-03-21 11:39:22',NULL),(4067,8437,40874,130219,3,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',15652.81,NULL,NULL,1,'2023-03-21 11:39:57','2023-03-21 11:39:57',NULL),(4068,8437,40874,130219,3,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',35640.66,NULL,NULL,1,'2023-03-21 11:40:33','2023-03-21 11:40:33',NULL),(4069,8437,40874,130219,3,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',35485.27,NULL,NULL,1,'2023-03-21 11:41:01','2023-03-21 11:41:01',NULL),(4070,8437,40874,130219,3,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',112905.60,NULL,NULL,1,'2023-03-21 11:54:51','2023-03-21 11:54:51',NULL),(4071,8437,40874,130219,3,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',43958.86,NULL,NULL,1,'2023-03-21 11:55:43','2023-03-21 11:55:43',NULL);
INSERT INTO `balance_libro` VALUES (4072,8437,40874,130219,3,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',41518.58,NULL,NULL,1,'2023-03-21 12:01:24','2023-03-21 12:01:24',NULL),(4073,8437,40874,130219,3,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',7279.72,NULL,NULL,1,'2023-03-21 12:01:54','2023-03-21 12:01:54',NULL),(4074,8437,40874,130219,3,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',57881.60,NULL,NULL,1,'2023-03-21 12:24:26','2023-03-21 12:24:26',NULL),(4075,8437,40874,130219,3,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',30544.42,NULL,NULL,1,'2023-03-21 12:25:19','2023-03-21 12:25:19',NULL),(4076,8437,40874,130219,3,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1194.40,NULL,NULL,1,'2023-03-21 12:33:06','2023-03-21 12:45:22','2023-03-21 12:45:22'),(4077,8437,40874,130219,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',51321.59,NULL,NULL,1,'2023-03-21 12:33:42','2023-03-21 13:50:13','2023-03-21 13:50:13'),(4078,8437,40874,130219,3,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',46367.29,NULL,NULL,1,'2023-03-21 12:43:17','2023-03-21 12:43:17',NULL),(4079,8437,40874,130219,3,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1194.40,NULL,NULL,1,'2023-03-21 12:45:22','2023-03-21 12:45:22',NULL),(4080,8437,40874,130219,3,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',38365.52,NULL,NULL,1,'2023-03-21 12:51:05','2023-03-21 12:51:05',NULL),(4081,8437,40874,130219,3,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',34979.76,NULL,NULL,1,'2023-03-21 13:04:23','2023-03-21 13:04:23',NULL),(4082,8437,40874,130219,2,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',110001.10,NULL,NULL,1,'2023-03-21 13:12:16','2023-03-21 13:12:16',NULL),(4083,8437,40874,130219,3,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',77437.41,NULL,NULL,1,'2023-03-21 13:32:25','2023-03-21 13:32:25',NULL),(4084,8437,40874,130219,3,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',27248.50,NULL,NULL,1,'2023-03-21 13:33:16','2023-03-21 13:33:16',NULL),(4085,8437,40874,130219,3,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',51321.59,NULL,NULL,1,'2023-03-21 13:50:13','2023-03-21 13:50:13',NULL),(4086,8437,40874,130219,3,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',98146.34,NULL,NULL,1,'2023-03-21 13:54:55','2023-03-21 13:54:55',NULL),(4087,8437,40874,130219,3,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',67267.61,NULL,NULL,1,'2023-03-21 13:57:42','2023-03-21 13:57:42',NULL),(4088,8437,40874,130219,3,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',17703.60,NULL,NULL,1,'2023-03-21 13:58:49','2023-03-21 13:58:49',NULL),(4089,8437,40793,46897,3,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',226450.95,NULL,NULL,1,'2023-03-22 10:41:30','2023-03-22 10:41:30',NULL),(4090,8437,40793,46897,3,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',7202.71,NULL,NULL,1,'2023-03-22 10:45:10','2023-03-22 10:45:10',NULL),(4091,8437,40879,137794,3,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4750.00,NULL,NULL,1,'2023-03-22 11:10:21','2023-03-22 11:26:40','2023-03-22 11:26:40');
INSERT INTO `balance_libro` VALUES (4092,8437,40879,137794,3,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',182050.55,NULL,NULL,1,'2023-03-22 11:10:21','2023-03-22 11:10:21',NULL),(4093,8437,40879,137794,3,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',43430.00,NULL,NULL,1,'2023-03-22 11:10:21','2023-03-22 11:12:50','2023-03-22 11:12:50'),(4094,8437,40879,137794,3,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',86018.90,NULL,NULL,1,'2023-03-22 11:10:21','2023-03-22 11:10:21',NULL),(4095,8437,40879,137794,3,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',6050.00,NULL,NULL,1,'2023-03-22 11:10:22','2023-03-22 11:13:24','2023-03-22 11:13:24'),(4096,8437,40879,137794,3,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',93762.90,NULL,NULL,1,'2023-03-22 11:10:22','2023-03-22 11:10:22',NULL),(4097,8437,40879,137794,3,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',222752.48,NULL,NULL,1,'2023-03-22 11:10:22','2023-03-22 11:10:22',NULL),(4098,8437,40879,137794,3,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',22920.00,NULL,NULL,1,'2023-03-22 11:10:22','2023-03-22 11:14:01','2023-03-22 11:14:01'),(4099,8437,40879,137794,3,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-03-22 11:10:22','2023-03-22 11:10:22',NULL),(4100,8437,40879,137794,3,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-03-22 11:10:22','2023-03-22 11:10:22',NULL),(4101,8437,40879,137794,3,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',43430.00,NULL,NULL,1,'2023-03-22 11:12:50','2023-03-22 11:12:50',NULL),(4102,8437,40879,137794,3,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',6050.00,NULL,NULL,1,'2023-03-22 11:13:24','2023-03-22 11:13:24',NULL),(4103,8437,40879,137794,3,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',22920.00,NULL,NULL,1,'2023-03-22 11:14:01','2023-03-22 11:14:01',NULL),(4104,8437,40879,137794,3,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',178550.02,NULL,NULL,1,'2023-03-22 11:22:54','2023-03-22 11:22:54',NULL),(4105,8437,40879,137794,3,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',227100.00,NULL,NULL,1,'2023-03-22 11:23:52','2023-03-22 11:23:52',NULL),(4106,8437,40879,137794,3,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4750.00,NULL,NULL,1,'2023-03-22 11:26:40','2023-03-22 11:26:40',NULL),(4107,8437,40878,136279,2,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4000.00,NULL,NULL,1,'2023-03-22 12:17:07','2023-03-23 09:44:18','2023-03-23 09:44:18'),(4108,8437,40878,136279,2,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',133000.00,NULL,NULL,1,'2023-03-22 12:17:07','2023-03-23 09:43:50','2023-03-23 09:43:50'),(4109,8437,40878,136279,2,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4000.00,NULL,NULL,1,'2023-03-22 12:17:07','2023-03-23 09:43:20','2023-03-23 09:43:20'),(4110,8437,40878,136279,2,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',26509.38,NULL,NULL,1,'2023-03-22 12:17:07','2023-03-23 09:42:51','2023-03-23 09:42:51'),(4111,8437,40878,136279,2,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4000.00,NULL,NULL,1,'2023-03-22 12:17:07','2023-03-23 09:42:18','2023-03-23 09:42:18');
INSERT INTO `balance_libro` VALUES (4112,8437,40878,136279,2,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4000.00,NULL,NULL,1,'2023-03-22 12:17:07','2023-03-23 09:41:45','2023-03-23 09:41:45'),(4113,8437,40878,136279,2,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',355029.00,NULL,NULL,1,'2023-03-22 12:17:07','2023-03-23 09:41:10','2023-03-23 09:41:10'),(4114,8437,40878,136279,2,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-22 12:17:07','2023-03-22 12:17:40','2023-03-22 12:17:40'),(4115,8437,40878,136279,2,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4000.00,NULL,NULL,1,'2023-03-22 12:20:52','2023-03-23 09:40:33','2023-03-23 09:40:33'),(4116,8437,40878,136279,2,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4000.00,NULL,NULL,1,'2023-03-22 12:21:28','2023-03-23 09:40:10','2023-03-23 09:40:10'),(4117,8437,40878,136279,2,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4000.00,NULL,NULL,1,'2023-03-22 12:22:02','2023-03-22 12:22:21','2023-03-22 12:22:21'),(4118,8437,40878,136279,2,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',25000.00,NULL,NULL,1,'2023-03-22 12:23:26','2023-03-23 09:39:49','2023-03-23 09:39:49'),(4119,8437,40878,136279,2,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4000.00,NULL,NULL,1,'2023-03-22 12:24:04','2023-03-23 09:39:13','2023-03-23 09:39:13'),(4120,8437,40878,136279,2,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4000.00,NULL,NULL,1,'2023-03-22 12:24:31','2023-03-23 09:38:46','2023-03-23 09:38:46'),(4121,8433,41421,754393,3,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1249.00,NULL,NULL,1,'2023-03-22 13:21:04','2023-04-14 00:12:00','2023-04-14 00:12:00'),(4122,8433,41421,754393,3,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3724.99,NULL,NULL,1,'2023-03-22 13:21:51','2023-04-14 00:12:20','2023-04-14 00:12:20'),(4123,8433,41421,754393,3,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',18900.00,NULL,NULL,1,'2023-03-22 13:22:39','2023-04-14 00:13:30','2023-04-14 00:13:30'),(4124,8433,41421,754393,3,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',842.00,NULL,NULL,1,'2023-03-22 13:23:37','2023-04-14 00:13:56','2023-04-14 00:13:56'),(4125,8433,41421,754393,3,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',8990.00,NULL,NULL,1,'2023-03-22 13:24:36','2023-04-14 00:14:33','2023-04-14 00:14:33'),(4126,8433,41421,754393,3,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',200.00,NULL,NULL,1,'2023-03-22 13:25:01','2023-04-14 00:16:23','2023-04-14 00:16:23'),(4127,8433,41421,754393,3,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',18370.00,NULL,NULL,1,'2023-03-22 13:25:29','2023-04-14 00:18:07','2023-04-14 00:18:07'),(4128,8434,41421,754393,3,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',213.64,NULL,NULL,1,'2023-03-22 15:28:17','2023-04-14 00:18:33','2023-04-14 00:18:33'),(4129,8434,41421,754393,15,2640,'App\\Models\\PeriodLiquidation',NULL,2640,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1135798.24,NULL,NULL,1,'2023-03-22 15:31:56','2023-04-14 00:08:58','2023-04-14 00:08:58'),(4130,8434,41421,754393,16,2641,'App\\Models\\PeriodLiquidation',NULL,2641,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',46196.78,NULL,NULL,1,'2023-03-22 15:32:39','2023-04-14 00:08:51','2023-04-14 00:08:51');
INSERT INTO `balance_libro` VALUES (4131,8433,40876,133249,15,2412,'App\\Models\\PeriodLiquidation',NULL,2412,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',95687.01,NULL,NULL,1,'2023-03-22 15:41:16','2023-03-27 14:54:32','2023-03-27 14:54:32'),(4132,8433,40876,133248,15,897,'App\\Models\\PeriodLiquidation',NULL,897,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',49245.31,NULL,NULL,1,'2023-03-22 15:41:36','2023-03-27 14:54:54','2023-03-27 14:54:54'),(4133,8434,40798,55987,3,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',267782.82,NULL,NULL,1,'2023-03-23 01:08:03','2023-03-23 01:34:27','2023-03-23 01:34:27'),(4134,8434,40798,55987,3,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',183169.62,NULL,NULL,1,'2023-03-23 01:14:30','2023-03-23 01:14:30',NULL),(4135,8434,40798,55987,3,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',272.45,NULL,NULL,1,'2023-03-23 01:19:35','2023-04-13 12:09:25','2023-04-13 12:09:25'),(4136,8434,40798,55987,16,2647,'App\\Models\\PeriodLiquidation',NULL,2647,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',618770.47,NULL,NULL,1,'2023-03-23 01:20:26','2023-03-23 01:33:06','2023-03-23 01:33:06'),(4137,8434,40798,55987,3,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',280527.94,NULL,NULL,1,'2023-03-23 01:34:27','2023-03-23 01:34:27',NULL),(4138,8433,40798,55987,16,2649,'App\\Models\\PeriodLiquidation',NULL,2649,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',618770.47,NULL,NULL,1,'2023-03-23 01:35:31','2023-04-12 09:37:02','2023-04-12 09:37:02'),(4139,8433,40798,55987,15,2648,'App\\Models\\PeriodLiquidation',NULL,2648,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',432582.43,NULL,NULL,1,'2023-03-23 01:42:53','2023-04-12 09:37:19','2023-04-12 09:37:19'),(4140,8437,40884,145369,2,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',90741.00,NULL,NULL,1,'2023-03-23 09:13:59','2023-03-23 09:30:25','2023-03-23 09:30:25'),(4141,8437,40884,145369,2,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',90741.00,NULL,NULL,1,'2023-03-23 09:30:25','2023-03-23 13:01:32','2023-03-23 13:01:32'),(4142,8437,40878,136279,3,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',20353.70,NULL,NULL,1,'2023-03-23 09:37:52','2023-03-23 09:37:52',NULL),(4143,8437,40878,136279,2,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4000.01,NULL,NULL,1,'2023-03-23 09:38:46','2023-03-23 10:19:08','2023-03-23 10:19:08'),(4144,8437,40878,136279,2,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4000.01,NULL,NULL,1,'2023-03-23 09:39:13','2023-03-23 10:19:13','2023-03-23 10:19:13'),(4145,8437,40878,136279,2,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',25000.00,NULL,NULL,1,'2023-03-23 09:39:49','2023-03-23 10:19:19','2023-03-23 10:19:19'),(4146,8437,40878,136279,2,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4000.01,NULL,NULL,1,'2023-03-23 09:40:10','2023-03-23 10:19:23','2023-03-23 10:19:23'),(4147,8437,40878,136279,2,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4000.01,NULL,NULL,1,'2023-03-23 09:40:33','2023-03-23 10:19:29','2023-03-23 10:19:29'),(4148,8437,40878,136279,2,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',355029.00,NULL,NULL,1,'2023-03-23 09:41:10','2023-03-23 10:19:37','2023-03-23 10:19:37'),(4149,8437,40878,136279,2,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4000.01,NULL,NULL,1,'2023-03-23 09:41:45','2023-03-23 10:19:46','2023-03-23 10:19:46');
INSERT INTO `balance_libro` VALUES (4150,8437,40878,136279,2,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4000.01,NULL,NULL,1,'2023-03-23 09:42:18','2023-03-23 10:19:52','2023-03-23 10:19:52'),(4151,8437,40878,136279,2,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',26509.38,NULL,NULL,1,'2023-03-23 09:42:51','2023-03-23 10:19:56','2023-03-23 10:19:56'),(4152,8437,40878,136279,2,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4000.01,NULL,NULL,1,'2023-03-23 09:43:20','2023-03-23 10:20:03','2023-03-23 10:20:03'),(4153,8437,40878,136279,2,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',133000.01,NULL,NULL,1,'2023-03-23 09:43:50','2023-03-23 10:20:08','2023-03-23 10:20:08'),(4154,8437,40878,136279,2,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4000.01,NULL,NULL,1,'2023-03-23 09:44:18','2023-03-23 10:20:14','2023-03-23 10:20:14'),(4155,8437,40878,136279,2,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4000.00,NULL,NULL,1,'2023-03-23 10:26:09','2023-03-23 10:26:09',NULL),(4156,8437,40878,136279,2,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',133000.00,NULL,NULL,1,'2023-03-23 10:26:09','2023-03-23 10:26:09',NULL),(4157,8437,40878,136279,2,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4000.00,NULL,NULL,1,'2023-03-23 10:26:09','2023-03-23 10:26:09',NULL),(4158,8437,40878,136279,2,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',26509.38,NULL,NULL,1,'2023-03-23 10:26:09','2023-03-23 10:26:09',NULL),(4159,8437,40878,136279,2,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4000.00,NULL,NULL,1,'2023-03-23 10:26:09','2023-03-23 10:26:09',NULL),(4160,8437,40878,136279,2,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',4000.00,NULL,NULL,1,'2023-03-23 10:26:09','2023-03-23 10:26:09',NULL),(4161,8437,40878,136279,2,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',355029.00,NULL,NULL,1,'2023-03-23 10:26:09','2023-03-23 10:26:09',NULL),(4162,8437,40878,136279,2,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-23 10:26:09','2023-03-23 10:27:03','2023-03-23 10:27:03'),(4163,8437,40878,136279,2,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',4000.00,NULL,NULL,1,'2023-03-23 10:29:06','2023-03-23 10:29:06',NULL),(4164,8437,40878,136279,2,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',4000.00,NULL,NULL,1,'2023-03-23 10:29:43','2023-03-23 10:29:43',NULL),(4165,8437,40878,136279,2,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',25000.00,NULL,NULL,1,'2023-03-23 10:30:34','2023-03-23 10:30:34',NULL),(4166,8437,40878,136279,2,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4000.00,NULL,NULL,1,'2023-03-23 10:31:12','2023-03-23 10:32:08','2023-03-23 10:32:08'),(4167,8437,40878,136279,2,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',4000.00,NULL,NULL,1,'2023-03-23 10:31:51','2023-03-23 10:31:51',NULL),(4168,8437,40878,136279,2,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',4000.00,NULL,NULL,1,'2023-03-23 10:32:08','2023-03-23 10:32:08',NULL),(4169,8433,40870,127192,3,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',7914.89,NULL,NULL,1,'2023-03-23 11:39:32','2023-05-10 10:19:54','2023-05-10 10:19:54');
INSERT INTO `balance_libro` VALUES (4170,8437,40875,131734,3,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7800.00,NULL,NULL,1,'2023-03-23 12:29:36','2023-03-23 12:29:36',NULL),(4171,8437,40875,131734,3,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',7921.98,NULL,NULL,1,'2023-03-23 12:31:12','2023-03-29 11:39:32','2023-03-29 11:39:32'),(4172,8437,40875,131734,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',6358.81,NULL,NULL,1,'2023-03-23 12:41:19','2023-03-29 11:40:28','2023-03-29 11:40:28'),(4173,8437,40884,145369,2,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',90741.00,NULL,NULL,1,'2023-03-23 13:01:32','2023-03-23 13:01:32',NULL),(4174,8434,40870,127192,3,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',7000.14,NULL,NULL,1,'2023-03-23 15:44:07','2023-03-23 15:44:07',NULL),(4175,8434,40870,127192,3,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',8650.32,NULL,NULL,1,'2023-03-23 15:46:31','2023-03-23 15:46:31',NULL),(4176,8434,40870,127192,3,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1830.10,NULL,NULL,1,'2023-03-23 15:48:25','2023-03-23 15:48:25',NULL),(4177,8434,40870,127192,3,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',6260.89,NULL,NULL,1,'2023-03-23 15:49:12','2023-03-23 15:49:12',NULL),(4178,8434,40870,127192,3,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',66429.86,NULL,NULL,1,'2023-03-23 15:58:03','2023-05-11 13:44:07','2023-05-11 13:44:07'),(4179,8434,40870,127192,3,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',66429.86,NULL,NULL,1,'2023-03-23 15:58:24','2023-05-11 13:43:44','2023-05-11 13:43:44'),(4180,8434,40870,127192,3,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',51598.00,NULL,NULL,1,'2023-03-23 16:02:00','2023-05-10 13:07:20','2023-05-10 13:07:20'),(4181,8433,40870,127192,15,2737,'App\\Models\\PeriodLiquidation',NULL,2737,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',468629.29,NULL,NULL,1,'2023-03-23 16:09:16','2023-05-10 10:15:36','2023-05-10 10:15:36'),(4182,8437,40877,134764,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1702688.98,NULL,NULL,1,'2023-03-27 10:18:25','2023-03-27 10:43:28','2023-03-27 10:43:28'),(4183,8437,40877,134764,3,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',22880.00,NULL,NULL,1,'2023-03-27 10:24:17','2023-03-27 10:24:17',NULL),(4184,8437,40877,134764,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1702688.98,NULL,NULL,1,'2023-03-27 10:43:28','2023-03-27 10:43:28',NULL),(4185,8437,40875,131734,3,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',964.00,NULL,NULL,1,'2023-03-27 12:06:51','2023-03-27 12:06:51',NULL),(4186,8437,40875,131734,3,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1765.10,NULL,NULL,1,'2023-03-27 12:07:59','2023-03-27 12:09:04','2023-03-27 12:09:04'),(4187,8434,40881,140824,7,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',118.99,NULL,NULL,1,'2023-03-27 12:08:01','2023-03-27 12:08:01',NULL),(4188,8437,40875,131734,3,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1640.78,NULL,NULL,1,'2023-03-27 12:09:04','2023-03-27 12:09:04',NULL),(4189,8437,40875,131734,3,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',24925.03,NULL,NULL,1,'2023-03-27 12:36:38','2023-03-27 12:36:38',NULL);
INSERT INTO `balance_libro` VALUES (4190,8433,40789,40840,15,2757,'App\\Models\\PeriodLiquidation',NULL,2757,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',435.03,NULL,NULL,1,'2023-03-27 12:55:15','2023-03-27 12:55:15',NULL),(4191,8433,40881,140824,3,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1342.02,NULL,NULL,1,'2023-03-27 13:04:33','2023-03-27 13:04:33',NULL),(4192,8433,40881,140824,3,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',190.00,NULL,NULL,1,'2023-03-27 13:05:20','2023-03-27 13:05:20',NULL),(4193,8437,40800,59017,2,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4194,8437,40800,59017,2,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4195,8437,40800,59017,2,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',29900.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4196,8437,40800,59017,2,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4197,8437,40800,59017,2,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4198,8437,40800,59017,2,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4199,8437,40800,59017,2,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4200,8437,40800,59017,2,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4201,8437,40800,59017,2,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4202,8437,40800,59017,2,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4203,8437,40800,59017,2,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4204,8437,40800,59017,2,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4205,8437,40800,59017,2,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4206,8437,40800,59017,2,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4207,8437,40800,59017,2,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4208,8437,40800,59017,2,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4209,8437,40800,59017,2,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:20:48','2023-03-27 13:20:48');
INSERT INTO `balance_libro` VALUES (4210,8437,40800,59017,2,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:21:25','2023-03-27 13:21:25'),(4211,8437,40800,59017,2,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4212,8437,40800,59017,2,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:09','2023-03-27 13:08:09',NULL),(4213,8437,40800,59017,2,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:08:10',NULL),(4214,8437,40800,59017,2,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:08:10',NULL),(4215,8437,40800,59017,2,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:08:10',NULL),(4216,8437,40800,59017,2,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:08:10',NULL),(4217,8437,40800,59017,2,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:08:10',NULL),(4218,8437,40800,59017,2,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:08:10',NULL),(4219,8437,40800,59017,2,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:08:10',NULL),(4220,8437,40800,59017,2,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:08:10',NULL),(4221,8437,40800,59017,2,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:22:35','2023-03-27 13:22:35'),(4222,8437,40800,59017,2,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:08:10',NULL),(4223,8437,40800,59017,2,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:22:16','2023-03-27 13:22:16'),(4224,8437,40800,59017,2,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:08:10',NULL),(4225,8437,40800,59017,2,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:22:02','2023-03-27 13:22:02'),(4226,8437,40800,59017,2,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:08:10','2023-03-27 13:21:44','2023-03-27 13:21:44'),(4227,8433,40881,140824,3,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',6595.59,NULL,NULL,1,'2023-03-27 13:08:18','2023-03-27 13:08:18',NULL),(4228,8433,40881,140824,3,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',214.00,NULL,NULL,1,'2023-03-27 13:09:21','2023-03-27 13:09:21',NULL),(4229,8433,40881,140824,3,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',4584.27,NULL,NULL,1,'2023-03-27 13:11:00','2023-03-27 13:11:00',NULL);
INSERT INTO `balance_libro` VALUES (4230,8433,40881,140824,3,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',6204.48,NULL,NULL,1,'2023-03-27 13:13:10','2023-03-27 13:13:10',NULL),(4231,8433,40881,140824,3,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2640.00,NULL,NULL,1,'2023-03-27 13:13:55','2023-03-27 13:13:55',NULL),(4232,8437,40800,59017,2,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:20:48','2023-03-27 13:20:48',NULL),(4233,8437,40800,59017,2,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:21:25','2023-03-27 13:21:25',NULL),(4234,8437,40800,59017,2,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:21:44','2023-03-27 13:21:44',NULL),(4235,8437,40800,59017,2,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:22:02','2023-03-27 13:22:02',NULL),(4236,8437,40800,59017,2,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:22:16','2023-03-27 13:22:16',NULL),(4237,8437,40800,59017,2,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3000.00,NULL,NULL,1,'2023-03-27 13:22:35','2023-03-27 13:22:51','2023-03-27 13:22:51'),(4238,8437,40800,59017,2,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',30000.00,NULL,NULL,1,'2023-03-27 13:22:51','2023-03-27 13:22:51',NULL),(4239,8437,40800,59017,3,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',21614.01,NULL,NULL,1,'2023-03-27 13:29:33','2023-03-27 13:29:33',NULL),(4240,8433,40799,57502,3,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',2727.00,NULL,NULL,1,'2023-03-27 13:35:30','2023-03-27 13:35:30',NULL),(4241,8437,40790,42352,3,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',6150.45,NULL,NULL,1,'2023-03-27 14:11:02','2023-03-27 14:11:02',NULL),(4242,8437,40790,42352,3,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',605.23,NULL,NULL,1,'2023-03-27 14:15:17','2023-03-27 14:15:17',NULL),(4243,8437,40790,42352,3,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',53421.58,NULL,NULL,1,'2023-03-27 14:17:40','2023-03-27 14:17:40',NULL),(4244,8437,40790,42352,3,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',53620.44,NULL,NULL,1,'2023-03-27 14:19:11','2023-03-27 14:19:11',NULL),(4245,8437,40790,42352,3,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',12599.99,NULL,NULL,1,'2023-03-27 14:25:08','2023-03-27 14:25:08',NULL),(4246,8437,40790,42352,3,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',114268.50,NULL,NULL,1,'2023-03-27 14:27:45','2023-03-27 14:27:45',NULL),(4247,8434,40881,140824,3,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',471.99,NULL,NULL,1,'2023-03-27 14:35:33','2023-03-27 14:35:33',NULL),(4248,8434,40881,140824,16,2816,'App\\Models\\PeriodLiquidation',NULL,2816,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',13370.20,NULL,NULL,1,'2023-03-27 14:36:31','2023-03-27 14:36:31',NULL),(4249,8434,40881,140824,15,2815,'App\\Models\\PeriodLiquidation',NULL,2815,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',38313.25,NULL,NULL,1,'2023-03-27 14:36:48','2023-03-27 14:36:48',NULL);
INSERT INTO `balance_libro` VALUES (4250,8433,40799,57502,15,2799,'App\\Models\\PeriodLiquidation',NULL,2799,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',61211.18,NULL,NULL,1,'2023-03-27 14:39:38','2023-03-27 14:41:08','2023-03-27 14:41:08'),(4251,8434,40781,28720,3,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',162742.29,NULL,NULL,1,'2023-03-27 15:03:45','2023-04-24 11:03:42','2023-04-24 11:03:42'),(4252,8434,40781,28720,3,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',340.16,NULL,NULL,1,'2023-03-27 15:05:51','2023-03-27 15:05:51',NULL),(4253,8434,40781,28720,16,2822,'App\\Models\\PeriodLiquidation',NULL,2822,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',185037.16,NULL,NULL,1,'2023-03-27 15:07:13','2023-03-27 15:12:41','2023-03-27 15:12:41'),(4254,8433,40876,133249,3,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',12999.00,NULL,NULL,1,'2023-03-27 15:14:29','2023-03-27 15:14:29',NULL),(4255,8433,40781,28720,3,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',3000.03,NULL,NULL,1,'2023-03-27 15:23:15','2023-03-27 15:23:15',NULL),(4256,8433,40876,133249,16,2846,'App\\Models\\PeriodLiquidation',NULL,2846,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',49920.77,NULL,NULL,1,'2023-03-27 15:33:56','2023-05-08 12:58:05','2023-05-08 12:58:05'),(4257,8434,40876,133249,15,2845,'App\\Models\\PeriodLiquidation',NULL,2845,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',779678.36,NULL,NULL,1,'2023-03-27 15:34:36','2023-04-24 17:53:36','2023-04-24 17:53:36'),(4258,8433,40781,28720,16,2826,'App\\Models\\PeriodLiquidation',NULL,2826,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',185037.16,NULL,NULL,1,'2023-03-27 15:53:42','2023-04-24 10:47:45','2023-04-24 10:47:45'),(4259,8433,40781,28720,15,2825,'App\\Models\\PeriodLiquidation',NULL,2825,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',323673.14,NULL,NULL,1,'2023-03-27 15:54:35','2023-04-24 10:48:12','2023-04-24 10:48:12'),(4260,8437,40800,59017,7,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1282.80,NULL,NULL,1,'2023-03-27 15:56:53','2023-03-27 15:56:53',NULL),(4261,8434,40799,57502,15,2799,'App\\Models\\PeriodLiquidation',NULL,2799,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',61211.18,NULL,NULL,1,'2023-03-27 18:04:03','2023-03-27 18:04:03',NULL),(4262,8437,40885,146884,7,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',76.80,NULL,NULL,1,'2023-03-28 09:27:58','2023-03-28 09:27:58',NULL),(4263,8437,40880,139309,7,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3127.22,NULL,NULL,1,'2023-03-28 09:45:08','2023-03-28 09:45:08',NULL),(4264,8433,40846,119618,3,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',160954.20,NULL,NULL,1,'2023-03-28 10:03:32','2023-03-28 10:03:32',NULL),(4265,8433,40846,119618,3,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',7641.78,NULL,NULL,1,'2023-03-28 10:03:32','2023-03-28 10:03:32',NULL),(4266,8433,40846,119618,3,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',201011.25,NULL,NULL,1,'2023-03-28 10:03:33','2023-04-06 11:48:31','2023-04-06 11:48:31'),(4267,8433,40846,119618,3,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',18150.00,NULL,NULL,1,'2023-03-28 10:03:33','2023-03-28 10:03:33',NULL),(4268,8433,40846,119618,3,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',201011.25,NULL,NULL,1,'2023-03-28 10:03:33','2023-04-06 11:48:17','2023-04-06 11:48:17');
INSERT INTO `balance_libro` VALUES (4269,8433,40846,119618,3,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',111821.51,NULL,NULL,1,'2023-03-28 10:03:33','2023-03-28 10:03:33',NULL),(4270,8433,40846,119618,3,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2579478.00,NULL,NULL,1,'2023-03-28 10:03:33','2023-03-31 16:36:15','2023-03-31 16:36:15'),(4271,8433,40846,119618,3,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',950.00,NULL,NULL,1,'2023-03-28 10:03:33','2023-03-28 10:03:33',NULL),(4272,8433,40846,119618,3,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7666.54,NULL,NULL,1,'2023-03-28 10:03:33','2023-03-29 11:18:02','2023-03-29 11:18:02'),(4273,8433,40846,119618,3,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',11000.00,NULL,NULL,1,'2023-03-28 10:03:33','2023-03-28 12:01:53','2023-03-28 12:01:53'),(4274,8433,40846,119618,3,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',33810.46,NULL,NULL,1,'2023-03-28 10:03:33','2023-04-05 16:51:11','2023-04-05 16:51:11'),(4275,8433,40846,119618,3,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',142.00,NULL,NULL,1,'2023-03-28 10:03:34','2023-03-28 10:03:34',NULL),(4276,8433,40846,119618,3,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',134478.00,NULL,NULL,1,'2023-03-28 10:03:34','2023-03-28 11:50:39','2023-03-28 11:50:39'),(4277,8433,40846,119618,3,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',14028.37,NULL,NULL,1,'2023-03-28 10:03:34','2023-03-29 11:27:43','2023-03-29 11:27:43'),(4278,8433,40846,119618,3,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',497360.01,NULL,NULL,1,'2023-03-28 10:03:34','2023-04-05 16:52:45','2023-04-05 16:52:45'),(4279,8433,40846,119618,3,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',11000.00,NULL,NULL,1,'2023-03-28 10:03:34','2023-03-28 12:02:40','2023-03-28 12:02:40'),(4280,8433,40846,119618,3,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1900.00,NULL,NULL,1,'2023-03-28 10:03:34','2023-03-28 10:32:28','2023-03-28 10:32:28'),(4281,8433,40846,119618,3,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',12365.63,NULL,NULL,1,'2023-03-28 10:03:34','2023-03-28 11:34:42','2023-03-28 11:34:42'),(4282,8433,40846,119618,3,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',10300.00,NULL,NULL,1,'2023-03-28 10:03:34','2023-04-03 10:23:55','2023-04-03 10:23:55'),(4283,8433,40846,119618,3,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',21660.00,NULL,NULL,1,'2023-03-28 10:03:34','2023-04-03 10:26:28','2023-04-03 10:26:28'),(4284,8433,40846,119618,3,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3200.00,NULL,NULL,1,'2023-03-28 10:03:34','2023-03-30 10:39:18','2023-03-30 10:39:18'),(4285,8433,40846,119618,3,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',23375.00,NULL,NULL,1,'2023-03-28 10:03:35','2023-03-30 13:15:49','2023-03-30 13:15:49'),(4286,8433,40846,119618,3,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',25625.00,NULL,NULL,1,'2023-03-28 10:03:35','2023-03-30 13:16:46','2023-03-30 13:16:46'),(4287,8433,40846,119618,3,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',15125.00,NULL,NULL,1,'2023-03-28 10:03:35','2023-04-03 11:04:32','2023-04-03 11:04:32');
INSERT INTO `balance_libro` VALUES (4288,8433,40846,119618,3,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3580.00,NULL,NULL,1,'2023-03-28 10:03:35','2023-03-30 10:40:05','2023-03-30 10:40:05'),(4289,8433,40846,119618,3,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',11756.33,NULL,NULL,1,'2023-03-28 10:03:35','2023-03-30 12:58:42','2023-03-30 12:58:42'),(4290,8433,40846,119618,3,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',100365.00,NULL,NULL,1,'2023-03-28 10:03:35','2023-03-30 13:03:04','2023-03-30 13:03:04'),(4291,8433,40846,119618,3,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',94760.00,NULL,NULL,1,'2023-03-28 10:03:35','2023-03-30 13:03:32','2023-03-30 13:03:32'),(4292,8433,40846,119618,3,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1900.00,NULL,NULL,1,'2023-03-28 10:03:35','2023-03-28 10:03:35',NULL),(4293,8433,40846,119618,3,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3580.00,NULL,NULL,1,'2023-03-28 10:03:35','2023-03-30 10:40:45','2023-03-30 10:40:45'),(4294,8433,40846,119618,3,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',3580.00,NULL,NULL,1,'2023-03-28 10:03:35','2023-03-30 10:41:18','2023-03-30 10:41:18'),(4295,8433,40846,119618,3,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',67141.16,NULL,NULL,1,'2023-03-28 10:03:35','2023-03-29 11:26:38','2023-03-29 11:26:38'),(4296,8433,40846,119618,3,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',16850.10,NULL,NULL,1,'2023-03-28 10:03:35','2023-04-03 12:47:45','2023-04-03 12:47:45'),(4297,8433,40846,119618,3,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',20570.00,NULL,NULL,1,'2023-03-28 10:03:35','2023-04-03 12:49:09','2023-04-03 12:49:09'),(4298,8433,40846,119618,3,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',22358.61,NULL,NULL,1,'2023-03-28 10:03:35','2023-04-03 12:50:08','2023-04-03 12:50:08'),(4299,8433,40846,119618,3,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',833.00,NULL,NULL,1,'2023-03-28 10:20:48','2023-03-28 10:20:48',NULL),(4300,8433,40846,119618,3,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',940.00,NULL,NULL,1,'2023-03-28 10:25:08','2023-04-05 16:54:54','2023-04-05 16:54:54'),(4301,8433,40846,119618,3,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1899.99,NULL,NULL,1,'2023-03-28 10:32:28','2023-03-28 10:33:12','2023-03-28 10:33:12'),(4302,8433,40846,119618,3,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1900.00,NULL,NULL,1,'2023-03-28 10:33:12','2023-03-28 10:33:12',NULL),(4303,8433,40846,119618,3,4303,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',227441.01,'Pago Cargas sociales 02-2023',NULL,1,'2023-03-28 10:38:20','2023-03-28 10:38:20',NULL),(4304,8433,40846,119618,3,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1400.00,NULL,NULL,1,'2023-03-28 10:43:02','2023-04-05 16:56:09','2023-04-05 16:56:09'),(4305,8433,40846,119618,3,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',3200.00,NULL,NULL,1,'2023-03-28 10:46:14','2023-04-05 18:45:37','2023-04-05 18:45:37'),(4306,8437,40800,59017,7,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',19904.20,NULL,NULL,1,'2023-03-28 10:49:46','2023-03-28 10:58:56','2023-03-28 10:58:56');
INSERT INTO `balance_libro` VALUES (4307,8437,40800,59017,7,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',19.75,NULL,NULL,1,'2023-03-28 10:51:03','2023-03-28 11:02:17','2023-03-28 11:02:17'),(4308,8437,40800,59017,7,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',305.20,NULL,NULL,1,'2023-03-28 10:51:03','2023-03-28 11:07:05','2023-03-28 11:07:05'),(4309,8437,40800,59017,7,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',5.00,NULL,NULL,1,'2023-03-28 10:51:03','2023-03-28 11:06:59','2023-03-28 11:06:59'),(4310,8437,40800,59017,7,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',612.90,NULL,NULL,1,'2023-03-28 10:51:03','2023-03-28 11:06:52','2023-03-28 11:06:52'),(4311,8437,40800,59017,7,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',22.75,NULL,NULL,1,'2023-03-28 10:51:03','2023-03-28 11:06:46','2023-03-28 11:06:46'),(4312,8437,40800,59017,7,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',20.00,NULL,NULL,1,'2023-03-28 10:51:03','2023-03-28 11:06:41','2023-03-28 11:06:41'),(4313,8437,40800,59017,7,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',14.00,NULL,NULL,1,'2023-03-28 10:51:03','2023-03-28 11:06:31','2023-03-28 11:06:31'),(4314,8437,40800,59017,7,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',68.50,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:06:22','2023-03-28 11:06:22'),(4315,8437,40800,59017,7,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',52.00,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:06:12','2023-03-28 11:06:12'),(4316,8437,40800,59017,7,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',12.50,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:06:02','2023-03-28 11:06:02'),(4317,8437,40800,59017,7,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',5.50,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:05:46','2023-03-28 11:05:46'),(4318,8437,40800,59017,7,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1062.15,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:05:56','2023-03-28 11:05:56'),(4319,8437,40800,59017,7,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',64.45,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:05:34','2023-03-28 11:05:34'),(4320,8437,40800,59017,7,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',16.00,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:05:27','2023-03-28 11:05:27'),(4321,8437,40800,59017,7,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',17.00,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:05:18','2023-03-28 11:05:18'),(4322,8437,40800,59017,7,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',60.75,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:05:13','2023-03-28 11:05:13'),(4323,8437,40800,59017,7,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',45.25,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:05:07','2023-03-28 11:05:07'),(4324,8437,40800,59017,7,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',46.75,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:04:59','2023-03-28 11:04:59'),(4325,8437,40800,59017,7,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',38.50,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:04:53','2023-03-28 11:04:53');
INSERT INTO `balance_libro` VALUES (4326,8437,40800,59017,7,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',24.25,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:04:48','2023-03-28 11:04:48'),(4327,8437,40800,59017,7,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1101.43,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:04:43','2023-03-28 11:04:43'),(4328,8437,40800,59017,7,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',118.28,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:04:37','2023-03-28 11:04:37'),(4329,8437,40800,59017,7,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',28.50,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:03:32','2023-03-28 11:03:32'),(4330,8437,40800,59017,7,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',74.90,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:03:25','2023-03-28 11:03:25'),(4331,8437,40800,59017,7,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',208.00,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:03:18','2023-03-28 11:03:18'),(4332,8437,40800,59017,7,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',49.00,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:03:12','2023-03-28 11:03:12'),(4333,8437,40800,59017,7,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1440.20,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:03:06','2023-03-28 11:03:06'),(4334,8437,40800,59017,7,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',57.75,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:02:55','2023-03-28 11:02:55'),(4335,8437,40800,59017,7,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',31.00,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:02:48','2023-03-28 11:02:48'),(4336,8437,40800,59017,7,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',353.15,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:02:42','2023-03-28 11:02:42'),(4337,8437,40800,59017,7,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',116.75,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:02:37','2023-03-28 11:02:37'),(4338,8437,40800,59017,7,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',625.05,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:02:32','2023-03-28 11:02:32'),(4339,8437,40800,59017,7,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',87.00,NULL,NULL,1,'2023-03-28 10:51:04','2023-03-28 11:02:25','2023-03-28 11:02:25'),(4340,8437,40800,59017,7,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',19904.20,NULL,NULL,1,'2023-03-28 10:53:15','2023-03-28 10:57:45','2023-03-28 10:57:45'),(4341,8437,40800,59017,7,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:08','2023-03-28 11:11:05','2023-03-28 11:11:05'),(4342,8437,40800,59017,7,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:14:08','2023-03-28 11:14:08'),(4343,8437,40800,59017,7,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:14:03','2023-03-28 11:14:03'),(4344,8437,40800,59017,7,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:13:58','2023-03-28 11:13:58');
INSERT INTO `balance_libro` VALUES (4345,8437,40800,59017,7,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:13:52','2023-03-28 11:13:52'),(4346,8437,40800,59017,7,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:13:48','2023-03-28 11:13:48'),(4347,8437,40800,59017,7,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:13:43','2023-03-28 11:13:43'),(4348,8437,40800,59017,7,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:13:39','2023-03-28 11:13:39'),(4349,8437,40800,59017,7,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:13:35','2023-03-28 11:13:35'),(4350,8437,40800,59017,7,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:13:30','2023-03-28 11:13:30'),(4351,8437,40800,59017,7,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:13:23','2023-03-28 11:13:23'),(4352,8437,40800,59017,7,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:13:19','2023-03-28 11:13:19'),(4353,8437,40800,59017,7,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:13:15','2023-03-28 11:13:15'),(4354,8437,40800,59017,7,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:13:09','2023-03-28 11:13:09'),(4355,8437,40800,59017,7,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:13:04','2023-03-28 11:13:04'),(4356,8437,40800,59017,7,3666,'App\\Models\\Receipt',3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:12:58','2023-03-28 11:12:58'),(4357,8437,40800,59017,7,3667,'App\\Models\\Receipt',3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:12:53','2023-03-28 11:12:53'),(4358,8437,40800,59017,7,3668,'App\\Models\\Receipt',3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:12:49','2023-03-28 11:12:49'),(4359,8437,40800,59017,7,3669,'App\\Models\\Receipt',3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:31','2023-03-28 11:12:44','2023-03-28 11:12:44'),(4360,8437,40800,59017,7,3670,'App\\Models\\Receipt',3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:12:39','2023-03-28 11:12:39'),(4361,8437,40800,59017,7,3671,'App\\Models\\Receipt',3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:12:34','2023-03-28 11:12:34'),(4362,8437,40800,59017,7,3672,'App\\Models\\Receipt',3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:12:28','2023-03-28 11:12:28'),(4363,8437,40800,59017,7,3673,'App\\Models\\Receipt',3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:12:18','2023-03-28 11:12:18');
INSERT INTO `balance_libro` VALUES (4364,8437,40800,59017,7,3674,'App\\Models\\Receipt',3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:12:11','2023-03-28 11:12:11'),(4365,8437,40800,59017,7,3675,'App\\Models\\Receipt',3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:12:06','2023-03-28 11:12:06'),(4366,8437,40800,59017,7,3676,'App\\Models\\Receipt',3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:12:00','2023-03-28 11:12:00'),(4367,8437,40800,59017,7,3677,'App\\Models\\Receipt',3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:11:52','2023-03-28 11:11:52'),(4368,8437,40800,59017,7,3678,'App\\Models\\Receipt',3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:11:46','2023-03-28 11:11:46'),(4369,8437,40800,59017,7,3679,'App\\Models\\Receipt',3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:11:39','2023-03-28 11:11:39'),(4370,8437,40800,59017,7,3680,'App\\Models\\Receipt',3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:11:33','2023-03-28 11:11:33'),(4371,8437,40800,59017,7,3681,'App\\Models\\Receipt',3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:11:29','2023-03-28 11:11:29'),(4372,8437,40800,59017,7,3682,'App\\Models\\Receipt',3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:11:23','2023-03-28 11:11:23'),(4373,8437,40800,59017,7,3683,'App\\Models\\Receipt',3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:11:18','2023-03-28 11:11:18'),(4374,8437,40800,59017,7,3684,'App\\Models\\Receipt',3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.00,NULL,NULL,1,'2023-03-28 11:08:32','2023-03-28 11:11:12','2023-03-28 11:11:12'),(4375,8437,40800,59017,8,3685,'App\\Models\\Receipt',3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',19904.20,NULL,NULL,1,'2023-03-28 11:10:34','2023-03-28 11:18:40','2023-03-28 11:18:40'),(4376,8433,40846,119618,3,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',5050.00,NULL,NULL,1,'2023-03-28 11:15:31','2023-04-06 11:39:41','2023-04-06 11:39:41'),(4377,8433,40846,119618,3,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',9379.96,NULL,NULL,1,'2023-03-28 11:18:40','2023-04-06 11:43:15','2023-04-06 11:43:15'),(4378,8437,40800,59017,8,3688,'App\\Models\\Receipt',3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',11924.40,NULL,NULL,1,'2023-03-28 11:21:33','2023-03-28 11:21:33',NULL),(4379,8433,40846,119618,3,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',9501.00,NULL,NULL,1,'2023-03-28 11:21:53','2023-04-06 11:44:57','2023-04-06 11:44:57'),(4380,8437,40800,59017,7,3690,'App\\Models\\Receipt',3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',28.65,NULL,NULL,1,'2023-03-28 11:22:29','2023-03-28 11:22:29',NULL),(4381,8437,40800,59017,7,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',36.25,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4382,8437,40800,59017,7,3692,'App\\Models\\Receipt',3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',74.75,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL);
INSERT INTO `balance_libro` VALUES (4383,8437,40800,59017,7,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',89.00,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4384,8437,40800,59017,7,3694,'App\\Models\\Receipt',3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',766.05,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4385,8437,40800,59017,7,3695,'App\\Models\\Receipt',3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',24.25,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4386,8437,40800,59017,7,3696,'App\\Models\\Receipt',3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',36.50,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4387,8437,40800,59017,7,3697,'App\\Models\\Receipt',3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',57.25,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4388,8437,40800,59017,7,3698,'App\\Models\\Receipt',3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',757.50,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4389,8437,40800,59017,7,3699,'App\\Models\\Receipt',3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',26.25,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4390,8437,40800,59017,7,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',7.00,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4391,8437,40800,59017,7,3701,'App\\Models\\Receipt',3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',61.75,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4392,8437,40800,59017,7,3702,'App\\Models\\Receipt',3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',9.75,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4393,8437,40800,59017,7,3703,'App\\Models\\Receipt',3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',9.50,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4394,8437,40800,59017,7,3704,'App\\Models\\Receipt',3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',109.50,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4395,8437,40800,59017,7,3705,'App\\Models\\Receipt',3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1293.15,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4396,8437,40800,59017,7,3706,'App\\Models\\Receipt',3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',44.00,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4397,8437,40800,59017,7,3707,'App\\Models\\Receipt',3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',4.75,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4398,8437,40800,59017,7,3708,'App\\Models\\Receipt',3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',554.75,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4399,8437,40800,59017,7,3709,'App\\Models\\Receipt',3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',53.00,NULL,NULL,1,'2023-03-28 11:22:30','2023-03-28 11:22:30',NULL),(4400,8433,40846,119618,3,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',11100.40,NULL,NULL,1,'2023-03-28 11:25:17','2023-04-06 11:46:06','2023-04-06 11:46:06'),(4401,8437,40800,59017,3,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',43423.07,NULL,NULL,1,'2023-03-28 11:30:38','2023-03-28 11:30:38',NULL),(4402,8437,40800,59017,3,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',19384.51,NULL,NULL,1,'2023-03-28 11:31:50','2023-03-28 11:31:50',NULL),(4403,8437,40800,59017,3,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',31504.19,NULL,NULL,1,'2023-03-28 11:33:02','2023-03-28 11:33:02',NULL);
INSERT INTO `balance_libro` VALUES (4404,8437,40800,59017,3,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',10625.00,NULL,NULL,1,'2023-03-28 11:33:48','2023-03-28 11:33:48',NULL),(4405,8433,40846,119618,3,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',12365.63,NULL,NULL,1,'2023-03-28 11:34:42','2023-04-03 10:16:33','2023-04-03 10:16:33'),(4406,8437,40800,59017,3,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',44506.60,NULL,NULL,1,'2023-03-28 11:36:11','2023-03-28 11:36:11',NULL),(4407,8437,40800,59017,3,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',38273.24,NULL,NULL,1,'2023-03-28 11:37:43','2023-03-28 11:37:43',NULL),(4408,8437,40800,59017,3,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',8098.57,NULL,NULL,1,'2023-03-28 11:39:05','2023-03-28 11:39:05',NULL),(4409,8437,40800,59017,3,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',102250.28,NULL,NULL,1,'2023-03-28 11:39:48','2023-03-28 11:40:47','2023-03-28 11:40:47'),(4410,8437,40800,59017,3,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',93248.02,NULL,NULL,1,'2023-03-28 11:40:47','2023-03-28 11:40:47',NULL),(4411,8433,40846,119618,3,4411,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',28968.00,'Compra SOENSA',NULL,1,'2023-03-28 11:44:29','2023-03-28 11:44:29',NULL),(4412,8437,40800,59017,3,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',51376.12,NULL,NULL,1,'2023-03-28 11:45:07','2023-03-28 11:45:07',NULL),(4413,8437,40800,59017,3,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',67121.58,NULL,NULL,1,'2023-03-28 11:46:25','2023-03-28 11:46:25',NULL),(4414,8437,40800,59017,3,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',35633.04,NULL,NULL,1,'2023-03-28 11:47:22','2023-03-28 11:47:22',NULL),(4415,8434,40846,119618,3,4415,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',2206.15,'Pago AYSA',NULL,1,'2023-03-28 11:48:01','2023-12-06 22:50:45','2023-12-06 22:50:45'),(4416,8437,40800,59017,3,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',42379.89,NULL,NULL,1,'2023-03-28 11:48:30','2023-03-28 11:48:30',NULL),(4417,8437,40800,59017,3,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',6146.77,NULL,NULL,1,'2023-03-28 11:49:54','2023-03-28 11:49:54',NULL),(4418,8433,40846,119618,3,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',134478.00,NULL,NULL,1,'2023-03-28 11:50:39','2023-04-06 11:47:54','2023-04-06 11:47:54'),(4419,8437,40800,59017,3,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',7436.00,NULL,NULL,1,'2023-03-28 11:51:15','2023-03-28 11:51:15',NULL),(4420,8437,40800,59017,3,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',47382.14,NULL,NULL,1,'2023-03-28 11:53:03','2023-03-28 11:53:03',NULL),(4421,8437,40800,59017,3,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',20341.57,NULL,NULL,1,'2023-03-28 11:54:15','2023-03-28 11:54:15',NULL),(4422,8433,40846,119618,3,4422,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',9479.56,'Pago EDENOR',NULL,1,'2023-03-28 11:54:52','2023-03-28 11:54:52',NULL),(4423,8437,40800,59017,3,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',38492.61,NULL,NULL,1,'2023-03-28 11:55:04','2023-03-28 11:55:04',NULL);
INSERT INTO `balance_libro` VALUES (4424,8437,40800,59017,3,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',94506.24,NULL,NULL,1,'2023-03-28 11:56:57','2023-03-28 11:56:57',NULL),(4425,8433,40846,119618,3,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',11000.00,NULL,NULL,1,'2023-03-28 12:01:53','2023-03-31 16:39:40','2023-03-31 16:39:40'),(4426,8433,40846,119618,3,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',11000.00,NULL,NULL,1,'2023-03-28 12:02:40','2023-04-05 16:46:48','2023-04-05 16:46:48'),(4427,8433,40846,119618,3,4427,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',240.79,'Pago METROGAS',NULL,1,'2023-03-28 12:17:33','2023-03-28 12:17:33',NULL),(4428,8437,40878,136279,7,3711,'App\\Models\\Receipt',3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4503.00,NULL,NULL,1,'2023-03-28 12:53:22','2023-03-28 12:53:52','2023-03-28 12:53:52'),(4429,8437,40878,136279,7,3712,'App\\Models\\Receipt',3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',5043.43,NULL,NULL,1,'2023-03-28 12:53:22','2023-03-28 12:53:48','2023-03-28 12:53:48'),(4430,8437,40878,136279,8,3713,'App\\Models\\Receipt',3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9546.43,NULL,NULL,1,'2023-03-28 12:54:45','2023-03-28 12:54:45',NULL),(4431,8437,40878,136279,7,3714,'App\\Models\\Receipt',3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',3724.00,NULL,NULL,1,'2023-03-28 12:57:53','2023-03-28 12:57:53',NULL),(4432,8437,40878,136279,7,3715,'App\\Models\\Receipt',3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',495.38,NULL,NULL,1,'2023-03-28 12:57:53','2023-03-28 12:57:53',NULL),(4433,8437,40884,145369,3,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',242.91,NULL,NULL,1,'2023-03-29 10:04:37','2023-03-29 10:04:37',NULL),(4434,8433,40846,119618,3,4434,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',26682.30,'Taxi/UBER Marzo',NULL,1,'2023-03-29 10:21:45','2023-04-04 10:22:56','2023-04-04 10:22:56'),(4435,8433,40846,119618,3,4435,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',3050.00,'Refrigerio',NULL,1,'2023-03-29 10:23:41','2023-03-29 10:23:41',NULL),(4436,8434,40846,119618,3,4436,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',19263.00,'Pago a cuenta SICORE 03-2023',NULL,1,'2023-03-29 10:29:07','2023-04-06 16:59:18','2023-04-06 16:59:18'),(4437,8434,40846,119618,3,4437,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',323.48,'Pago Sicore mensual 02-2023',NULL,1,'2023-03-29 10:31:39','2023-04-06 17:00:31','2023-04-06 17:00:31'),(4438,8433,40846,119618,3,4438,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',3870.00,'Compra Mc Donalds',NULL,1,'2023-03-29 10:53:32','2023-03-29 10:53:32',NULL),(4439,8433,40846,119618,3,4439,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',5950.00,'Compra La Juliana',NULL,1,'2023-03-29 10:54:57','2023-03-29 10:54:57',NULL),(4440,8433,40846,119618,3,4440,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1600.00,'Refrigerio',NULL,1,'2023-03-29 10:59:12','2023-03-29 13:07:34','2023-03-29 13:07:34'),(4441,8434,40846,119618,3,4441,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',725.00,'Estacionamiento',NULL,1,'2023-03-29 11:10:55','2023-04-06 14:54:13','2023-04-06 14:54:13'),(4442,8433,40846,119618,3,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7666.53,NULL,NULL,1,'2023-03-29 11:18:02','2023-03-29 11:18:02',NULL);
INSERT INTO `balance_libro` VALUES (4443,8437,40875,131734,7,3716,'App\\Models\\Receipt',3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',700.00,NULL,NULL,1,'2023-03-29 11:19:45','2023-03-29 11:20:25','2023-03-29 11:20:25'),(4444,8437,40875,131734,7,3717,'App\\Models\\Receipt',3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8736.94,NULL,NULL,1,'2023-03-29 11:19:45','2023-03-29 11:20:20','2023-03-29 11:20:20'),(4445,8437,40875,131734,7,3718,'App\\Models\\Receipt',3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',260.00,NULL,NULL,1,'2023-03-29 11:19:45','2023-03-29 11:20:14','2023-03-29 11:20:14'),(4446,8437,40875,131734,7,3719,'App\\Models\\Receipt',3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',530.00,NULL,NULL,1,'2023-03-29 11:19:45','2023-03-29 11:20:11','2023-03-29 11:20:11'),(4447,8437,40875,131734,8,3720,'App\\Models\\Receipt',3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',10226.94,NULL,NULL,1,'2023-03-29 11:21:05','2023-03-29 11:21:05',NULL),(4448,8433,40846,119618,3,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',67141.16,NULL,NULL,1,'2023-03-29 11:26:38','2023-03-29 11:26:38',NULL),(4449,8433,40846,119618,3,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',14028.37,NULL,NULL,1,'2023-03-29 11:27:43','2023-03-29 11:27:43',NULL),(4450,8437,40875,131734,3,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',45531.82,NULL,NULL,1,'2023-03-29 11:28:15','2023-03-29 11:28:15',NULL),(4451,8437,40875,131734,3,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',408.26,NULL,NULL,1,'2023-03-29 11:28:54','2023-03-29 11:28:54',NULL),(4452,8437,40875,131734,3,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',816.52,NULL,NULL,1,'2023-03-29 11:29:35','2023-03-29 11:29:35',NULL),(4453,8433,40846,119618,3,3721,'App\\Models\\Receipt',3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',46558.07,NULL,NULL,1,'2023-03-29 11:35:09','2023-03-29 11:35:09',NULL),(4454,8437,40875,131734,3,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',8340.12,NULL,NULL,1,'2023-03-29 11:38:42','2023-03-29 11:38:42',NULL),(4455,8437,40875,131734,3,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',7921.98,NULL,NULL,1,'2023-03-29 11:39:32','2023-03-29 11:39:32',NULL),(4456,8437,40875,131734,3,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',6358.81,NULL,NULL,1,'2023-03-29 11:40:28','2023-03-29 11:40:28',NULL),(4457,8433,40846,119618,3,4457,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1600.00,'Refrigerio Azúcar Cafe Bar',NULL,1,'2023-03-29 13:07:34','2023-03-29 13:07:34',NULL),(4458,8433,40846,119618,3,4458,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',670000.00,'Pago Sueldos 02-2023',NULL,1,'2023-03-29 13:12:08','2023-03-29 13:12:24','2023-03-29 13:12:24'),(4459,8433,40846,119618,1,4459,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',670000.00,'Pago Sueldos 02-2023',NULL,1,'2023-03-29 13:12:24','2023-03-29 13:12:24',NULL),(4460,8437,40878,136279,3,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',77221.06,NULL,NULL,1,'2023-03-30 08:40:33','2023-03-30 08:40:33',NULL),(4461,8437,40878,136279,3,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',24642.35,NULL,NULL,1,'2023-03-30 08:41:24','2023-03-30 08:41:24',NULL),(4462,8437,40878,136279,3,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',19679.75,NULL,NULL,1,'2023-03-30 08:42:08','2023-03-30 08:42:08',NULL);
INSERT INTO `balance_libro` VALUES (4463,8437,40878,136279,3,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1677.27,NULL,NULL,1,'2023-03-30 08:42:45','2023-03-30 08:42:45',NULL),(4464,8437,40878,136279,3,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',12561.98,NULL,NULL,1,'2023-03-30 08:56:13','2023-03-30 08:56:13',NULL),(4465,8437,40800,59017,3,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',14902.68,NULL,NULL,1,'2023-03-30 09:20:57','2023-03-30 09:20:57',NULL),(4466,8437,40800,59017,3,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',46973.14,NULL,NULL,1,'2023-03-30 09:21:24','2023-03-30 09:21:24',NULL),(4467,8437,40800,59017,3,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',10644.63,NULL,NULL,1,'2023-03-30 09:21:55','2023-03-30 09:21:55',NULL),(4468,8437,40800,59017,3,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',42128.10,NULL,NULL,1,'2023-03-30 09:22:27','2023-03-30 09:22:27',NULL),(4469,8433,40846,119618,3,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3200.00,NULL,NULL,1,'2023-03-30 10:39:18','2024-03-06 11:39:32','2024-03-06 11:39:32'),(4470,8433,40846,119618,3,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3580.00,NULL,NULL,1,'2023-03-30 10:40:05','2024-03-06 11:39:15','2024-03-06 11:39:15'),(4471,8433,40846,119618,3,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3580.00,NULL,NULL,1,'2023-03-30 10:40:45','2024-03-06 11:38:56','2024-03-06 11:38:56'),(4472,8433,40846,119618,3,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',3580.00,NULL,NULL,1,'2023-03-30 10:41:18','2024-03-06 11:38:28','2024-03-06 11:38:28'),(4473,8437,41082,434733,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',28600.00,NULL,NULL,1,'2023-03-30 10:44:30','2023-03-30 10:44:30',NULL),(4474,8434,40724,7530,3,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',5000.00,NULL,NULL,1,'2023-03-30 11:26:03','2023-05-08 11:10:52','2023-05-08 11:10:52'),(4475,8434,40724,7531,3,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6230.00,NULL,NULL,1,'2023-03-30 11:28:48','2023-03-30 11:31:20','2023-03-30 11:31:20'),(4476,8434,40724,7531,3,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6230.00,NULL,NULL,1,'2023-03-30 11:31:20','2023-03-30 11:31:20',NULL),(4477,8434,40724,7531,3,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',6000.00,NULL,NULL,1,'2023-03-30 11:32:21','2023-03-30 11:32:21',NULL),(4478,8436,40795,49926,8,3724,'App\\Models\\Receipt',3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-03-30 12:34:48','2023-03-30 13:55:15','2023-03-30 13:55:15'),(4479,8436,40795,49926,8,3725,'App\\Models\\Receipt',3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2700.00,NULL,NULL,1,'2023-03-30 12:47:59','2023-03-30 12:47:59',NULL),(4480,8436,40795,49926,8,3726,'App\\Models\\Receipt',3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',850.00,NULL,NULL,1,'2023-03-30 12:47:59','2023-03-30 12:47:59',NULL),(4481,8436,40795,49926,3,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3715.25,NULL,NULL,1,'2023-03-30 12:58:39','2023-03-30 21:02:32','2023-03-30 21:02:32'),(4482,8433,40846,119618,3,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',11756.33,NULL,NULL,1,'2023-03-30 12:58:42','2023-04-15 19:42:11','2023-04-15 19:42:11');
INSERT INTO `balance_libro` VALUES (4483,8433,40846,119618,3,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',100365.00,NULL,NULL,1,'2023-03-30 13:03:04','2023-03-30 13:03:04',NULL),(4484,8433,40846,119618,3,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',94760.00,NULL,NULL,1,'2023-03-30 13:03:32','2023-03-30 13:03:32',NULL),(4485,8433,40846,119618,3,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',23375.00,NULL,NULL,1,'2023-03-30 13:15:49','2023-03-30 13:15:49',NULL),(4486,8433,40846,119618,3,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',25625.00,NULL,NULL,1,'2023-03-30 13:16:46','2023-03-30 13:16:46',NULL),(4487,8436,40795,49927,3,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3964.40,NULL,NULL,1,'2023-03-30 13:57:58','2023-03-31 11:14:02','2023-03-31 11:14:02'),(4488,8436,40795,49926,3,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7312.50,NULL,NULL,1,'2023-03-30 21:02:32','2023-03-31 09:47:37','2023-03-31 09:47:37'),(4489,8436,40795,49926,3,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7312.50,NULL,NULL,1,'2023-03-31 09:47:37','2023-03-31 09:47:37',NULL),(4490,8436,40795,49927,3,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',16320.00,NULL,NULL,1,'2023-03-31 10:38:49','2023-03-31 10:38:49',NULL),(4491,8436,40795,49927,3,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',3245.40,NULL,NULL,1,'2023-03-31 10:39:26','2023-03-31 10:39:26',NULL),(4492,8436,40795,49926,3,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',12480.00,NULL,NULL,1,'2023-03-31 10:39:46','2023-03-31 10:39:46',NULL),(4493,8436,40795,49926,3,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1882.29,NULL,NULL,1,'2023-03-31 10:40:34','2023-03-31 10:40:34',NULL),(4494,8436,40795,49926,3,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',39591.20,NULL,NULL,1,'2023-03-31 10:41:13','2023-03-31 10:41:13',NULL),(4495,8436,40795,49926,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2286.36,NULL,NULL,1,'2023-03-31 10:42:25','2023-03-31 15:42:13','2023-03-31 15:42:13'),(4496,8434,40795,49926,16,3213,'App\\Models\\PeriodLiquidation',NULL,3213,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',12767.29,NULL,NULL,1,'2023-03-31 10:53:40','2023-03-31 15:36:20','2023-03-31 15:36:20'),(4497,8436,40795,49927,3,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7312.50,NULL,NULL,1,'2023-03-31 11:14:02','2023-03-31 18:06:29','2023-03-31 18:06:29'),(4498,8436,40795,49927,8,3731,'App\\Models\\Receipt',3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',16085.99,NULL,NULL,1,'2023-03-31 11:14:58','2023-03-31 11:14:58',NULL),(4499,8436,40795,49927,8,3732,'App\\Models\\Receipt',3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',325.00,NULL,NULL,1,'2023-03-31 11:14:58','2023-03-31 11:14:58',NULL),(4500,8434,40795,49926,3,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',2233.86,NULL,NULL,1,'2023-03-31 15:42:13','2023-03-31 15:42:13',NULL),(4501,8434,40795,760829,15,3204,'App\\Models\\PeriodLiquidation',NULL,3204,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',241028.51,NULL,NULL,1,'2023-03-31 15:44:53','2023-03-31 15:44:53',NULL),(4502,8434,40795,49926,16,3217,'App\\Models\\PeriodLiquidation',NULL,3217,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',12767.29,NULL,NULL,1,'2023-03-31 15:45:35','2023-03-31 15:45:35',NULL);
INSERT INTO `balance_libro` VALUES (4503,8434,40795,49926,15,3218,'App\\Models\\PeriodLiquidation',NULL,3218,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',247780.30,NULL,NULL,1,'2023-03-31 15:56:18','2023-03-31 18:22:16','2023-03-31 18:22:16'),(4504,8434,40795,49927,16,3216,'App\\Models\\PeriodLiquidation',NULL,3216,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',29515.78,NULL,NULL,1,'2023-03-31 15:56:45','2023-03-31 18:03:30','2023-03-31 18:03:30'),(4505,8433,40846,119618,3,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2579478.00,NULL,NULL,1,'2023-03-31 16:36:15','2023-03-31 16:36:15',NULL),(4506,8433,40846,119618,3,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',11000.00,NULL,NULL,1,'2023-03-31 16:39:40','2023-03-31 16:39:40',NULL),(4507,8433,40846,119617,3,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',500.00,NULL,NULL,1,'2023-03-31 16:41:23','2023-03-31 16:41:23',NULL),(4508,8434,40795,49927,3,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7711.80,NULL,NULL,1,'2023-03-31 18:06:29','2023-03-31 18:06:29',NULL),(4509,8434,40795,49927,3,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',29120.00,NULL,NULL,1,'2023-03-31 18:15:01','2023-03-31 18:15:01',NULL),(4510,8434,40795,49926,15,3218,'App\\Models\\PeriodLiquidation',NULL,3218,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',247780.31,NULL,NULL,1,'2023-03-31 18:22:37','2023-03-31 18:22:37',NULL),(4511,8434,40795,49927,15,3229,'App\\Models\\PeriodLiquidation',NULL,3229,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',253903.61,NULL,NULL,1,'2023-03-31 18:26:39','2023-03-31 18:26:39',NULL),(4512,8434,40795,49927,16,3227,'App\\Models\\PeriodLiquidation',NULL,3227,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',29515.78,NULL,NULL,1,'2023-03-31 18:27:10','2023-03-31 18:27:10',NULL),(4513,8444,40724,7533,2,3733,'App\\Models\\Receipt',3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',27460.95,NULL,NULL,1,'2023-04-03 08:29:07','2023-04-03 08:29:07',NULL),(4514,8444,40724,7533,2,3734,'App\\Models\\Receipt',3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',45145.10,NULL,NULL,1,'2023-04-03 09:39:52','2023-04-03 09:39:52',NULL),(4515,8444,40724,7533,2,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',137480.20,NULL,NULL,1,'2023-04-03 09:39:53','2023-04-03 09:39:53',NULL),(4516,8433,40846,119618,2,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',155625.00,NULL,NULL,1,'2023-04-03 10:13:22','2023-04-03 10:13:22',NULL),(4517,8433,40846,119618,3,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',12365.63,NULL,NULL,1,'2023-04-03 10:16:33','2023-04-03 10:16:33',NULL),(4518,8433,40846,119618,3,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',10300.00,NULL,NULL,1,'2023-04-03 10:23:55','2023-04-03 10:23:55',NULL),(4519,8433,40846,119618,3,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',21660.00,NULL,NULL,1,'2023-04-03 10:26:28','2023-04-03 10:26:28',NULL),(4520,8433,40846,119618,3,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',15125.00,NULL,NULL,1,'2023-04-03 11:04:32','2023-04-03 12:45:10','2023-04-03 12:45:10'),(4521,8437,40875,131734,3,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',6000.00,NULL,NULL,1,'2023-04-03 11:50:07','2023-04-03 11:50:07',NULL),(4522,8444,40724,7533,2,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',122560.90,NULL,NULL,1,'2023-04-03 11:50:30','2023-04-03 11:50:30',NULL);
INSERT INTO `balance_libro` VALUES (4523,8444,40724,7533,2,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',69163.60,NULL,NULL,1,'2023-04-03 11:50:57','2023-04-03 11:50:57',NULL),(4524,8437,40875,131734,3,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1190.00,NULL,NULL,1,'2023-04-03 11:51:35','2023-04-03 11:51:35',NULL),(4525,8437,40875,131734,3,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',8200.00,NULL,NULL,1,'2023-04-03 11:54:03','2023-04-03 11:54:03',NULL),(4526,8437,40875,131734,3,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',51000.00,NULL,NULL,1,'2023-04-03 12:17:56','2023-04-03 12:17:56',NULL),(4527,8437,41082,434733,16,3171,'App\\Models\\PeriodLiquidation',NULL,3171,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',95867.57,NULL,NULL,1,'2023-04-03 12:33:07','2023-04-03 12:33:07',NULL),(4528,8437,41082,434734,16,3260,'App\\Models\\PeriodLiquidation',NULL,3260,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',95867.57,NULL,NULL,1,'2023-04-03 12:33:16','2023-04-03 12:33:16',NULL),(4529,8433,40846,119618,3,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',15125.00,NULL,NULL,1,'2023-04-03 12:45:10','2023-04-03 12:45:10',NULL),(4530,8433,40846,119618,3,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',16850.10,NULL,NULL,1,'2023-04-03 12:47:45','2023-04-03 12:47:45',NULL),(4531,8433,40846,119618,3,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',20570.00,NULL,NULL,1,'2023-04-03 12:49:09','2023-04-03 12:49:09',NULL),(4532,8433,40846,119618,3,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',22358.61,NULL,NULL,1,'2023-04-03 12:50:08','2023-04-06 11:47:25','2023-04-06 11:47:25'),(4533,NULL,40724,7533,2,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',270634.65,NULL,NULL,1,'2023-04-03 16:31:28','2023-04-03 16:31:28',NULL),(4534,NULL,40724,7533,2,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',55684.20,NULL,NULL,1,'2023-04-03 16:31:32','2023-04-03 16:31:32',NULL),(4535,NULL,40724,7533,2,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',13310.00,NULL,NULL,1,'2023-04-03 16:31:34','2023-04-03 16:31:34',NULL),(4536,NULL,40724,7533,2,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',127050.00,NULL,NULL,1,'2023-04-03 16:31:36','2023-04-03 16:31:36',NULL),(4537,NULL,40724,7533,2,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',209240.46,NULL,NULL,1,'2023-04-03 16:31:38','2023-04-03 16:31:38',NULL),(4538,NULL,40724,7533,2,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',72309.60,NULL,NULL,1,'2023-04-03 16:31:40','2023-04-03 16:31:40',NULL),(4539,NULL,40724,7533,2,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',147232.80,NULL,NULL,1,'2023-04-03 16:31:42','2023-04-03 16:31:42',NULL),(4540,NULL,40724,7533,2,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',50227.10,NULL,NULL,1,'2023-04-03 16:31:43','2023-04-03 16:31:43',NULL),(4541,NULL,40724,7533,2,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',105875.00,NULL,NULL,1,'2023-04-03 16:31:45','2023-04-03 16:31:45',NULL),(4542,NULL,40724,7533,2,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',108246.60,NULL,NULL,1,'2023-04-03 16:31:47','2023-04-03 16:31:47',NULL);
INSERT INTO `balance_libro` VALUES (4543,NULL,40724,7533,2,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',199795.20,NULL,NULL,1,'2023-04-03 16:31:49','2023-04-03 16:31:49',NULL),(4544,NULL,40724,7533,2,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',279715.70,NULL,NULL,1,'2023-04-03 16:31:51','2023-04-03 16:31:51',NULL),(4545,NULL,40724,7533,2,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',66726.66,NULL,NULL,1,'2023-04-03 16:31:54','2023-04-03 16:31:54',NULL),(4546,NULL,40724,7533,2,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',151915.50,NULL,NULL,1,'2023-04-03 16:31:57','2023-04-03 16:31:57',NULL),(4547,NULL,40724,7533,2,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',102668.50,NULL,NULL,1,'2023-04-03 16:31:59','2023-04-03 16:31:59',NULL),(4548,NULL,40724,7533,2,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',116160.00,NULL,NULL,1,'2023-04-03 16:32:00','2023-04-03 16:32:00',NULL),(4549,NULL,40724,7533,2,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',234062.40,NULL,NULL,1,'2023-04-03 16:32:02','2023-04-03 16:32:02',NULL),(4550,NULL,40724,7533,2,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',19985.00,NULL,NULL,1,'2023-04-03 16:32:04','2023-04-03 16:32:04',NULL),(4551,NULL,40724,7533,2,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',19985.00,NULL,NULL,1,'2023-04-03 16:32:07','2023-04-03 16:32:07',NULL),(4552,8444,40724,7533,2,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',13310.00,NULL,NULL,1,'2023-04-03 17:05:47','2023-04-03 17:05:47',NULL),(4553,8444,40724,7533,2,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',8000.00,NULL,NULL,1,'2023-04-03 17:07:03','2023-04-03 17:07:03',NULL),(4554,8444,40724,7533,2,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',84700.00,NULL,NULL,1,'2023-04-03 17:16:35','2023-04-03 17:16:35',NULL),(4555,8434,40846,119616,16,1047,'App\\Models\\PeriodLiquidation',NULL,1047,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',483756.00,NULL,NULL,1,'2023-04-04 09:48:45','2023-09-21 01:36:22','2023-09-21 01:36:22'),(4556,8434,40846,119616,15,1046,'App\\Models\\PeriodLiquidation',NULL,1046,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7075660.22,NULL,NULL,1,'2023-04-04 09:51:16','2023-09-21 01:36:17','2023-09-21 01:36:17'),(4557,8433,40846,119617,16,3225,'App\\Models\\PeriodLiquidation',NULL,3225,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',321901.63,NULL,NULL,1,'2023-04-04 09:52:40','2023-04-04 09:52:40',NULL),(4558,8434,40846,119617,15,3224,'App\\Models\\PeriodLiquidation',NULL,3224,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',6308299.69,NULL,NULL,1,'2023-04-04 09:54:00','2024-02-09 06:59:57','2024-02-09 06:59:57'),(4559,8433,40846,119618,3,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',434.00,NULL,NULL,1,'2023-04-04 10:16:57','2023-04-04 10:16:57',NULL),(4560,8433,40846,119618,3,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',8060.00,NULL,NULL,1,'2023-04-04 10:20:23','2023-04-04 10:20:23',NULL),(4561,8434,40846,119618,3,4561,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',27678.50,'Taxi/UBER Marzo',NULL,1,'2023-04-04 10:22:56','2023-04-06 14:50:17','2023-04-06 14:50:17'),(4562,8433,40846,119618,3,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2850.00,NULL,NULL,1,'2023-04-04 10:36:59','2023-04-04 10:36:59',NULL);
INSERT INTO `balance_libro` VALUES (4563,8433,40846,119618,3,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',40000.00,NULL,NULL,1,'2023-04-04 10:51:19','2024-03-06 11:40:50','2024-03-06 11:40:50'),(4564,8444,40724,7533,2,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',234062.40,NULL,NULL,1,'2023-04-04 15:53:15','2023-04-04 15:53:15',NULL),(4565,8444,40724,7533,2,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',19985.00,NULL,NULL,1,'2023-04-04 16:11:03','2023-04-04 16:11:03',NULL),(4566,8444,40724,7533,2,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',19985.00,NULL,NULL,1,'2023-04-04 16:12:33','2023-04-04 16:12:33',NULL),(4567,8437,40875,131733,3,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',230.00,NULL,NULL,1,'2023-04-05 09:39:47','2023-04-05 11:30:45','2023-04-05 11:30:45'),(4568,8437,40875,131733,8,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',11842.79,NULL,NULL,1,'2023-04-05 10:31:40','2023-04-05 10:31:40',NULL),(4569,8437,40875,131733,3,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5528.42,NULL,NULL,1,'2023-04-05 10:40:10','2023-04-05 11:07:23','2023-04-05 11:07:23'),(4570,8437,40875,131733,3,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',8747.11,NULL,NULL,1,'2023-04-05 10:41:11','2023-04-05 10:41:11',NULL),(4571,8437,40875,131733,3,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',32772.98,NULL,NULL,1,'2023-04-05 10:42:41','2023-04-05 10:42:41',NULL),(4572,8437,40875,131733,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8710.11,NULL,NULL,1,'2023-04-05 10:43:53','2023-04-05 11:04:33','2023-04-05 11:04:33'),(4573,8437,40875,131733,3,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',8342.80,NULL,NULL,1,'2023-04-05 10:45:38','2023-04-05 11:08:22','2023-04-05 11:08:22'),(4574,8437,40875,131733,3,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',9383.16,NULL,NULL,1,'2023-04-05 10:46:49','2023-04-05 11:09:14','2023-04-05 11:09:14'),(4575,8437,40875,131733,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',10424.24,NULL,NULL,1,'2023-04-05 10:47:55','2023-04-05 11:10:15','2023-04-05 11:10:15'),(4576,8437,40875,131733,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',7825.89,NULL,NULL,1,'2023-04-05 10:49:07','2023-04-05 11:10:45','2023-04-05 11:10:45'),(4577,8437,40875,131733,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',16000.99,NULL,NULL,1,'2023-04-05 10:50:17','2023-04-05 11:44:17','2023-04-05 11:44:17'),(4578,8437,40875,131733,3,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',520.66,NULL,NULL,1,'2023-04-05 10:51:15','2023-04-05 10:51:15',NULL),(4579,8437,40875,131733,3,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',104.12,NULL,NULL,1,'2023-04-05 10:52:03','2023-04-05 10:52:03',NULL),(4580,8437,40875,131733,3,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',48000.00,NULL,NULL,1,'2023-04-05 10:52:46','2023-04-05 10:52:46',NULL),(4581,8444,40724,7533,2,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',195052.00,NULL,NULL,1,'2023-04-05 10:59:48','2023-04-05 10:59:48',NULL),(4582,8437,40875,131733,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8710.11,NULL,NULL,1,'2023-04-05 11:04:33','2023-04-05 11:41:30','2023-04-05 11:41:30');
INSERT INTO `balance_libro` VALUES (4583,8437,40875,131733,3,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',5528.42,NULL,NULL,1,'2023-04-05 11:07:23','2023-04-05 11:07:23',NULL),(4584,8437,40875,131733,3,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',8342.80,NULL,NULL,1,'2023-04-05 11:08:22','2023-04-05 11:08:22',NULL),(4585,8437,40875,131733,3,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',9383.16,NULL,NULL,1,'2023-04-05 11:09:14','2023-04-05 11:09:14',NULL),(4586,8437,40875,131733,3,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',10424.24,NULL,NULL,1,'2023-04-05 11:10:15','2023-04-05 11:10:15',NULL),(4587,8437,40875,131733,3,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',7825.89,NULL,NULL,1,'2023-04-05 11:10:45','2023-04-05 11:10:45',NULL),(4588,8437,40875,131733,16,3368,'App\\Models\\PeriodLiquidation',NULL,3368,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',25825.63,NULL,NULL,1,'2023-04-05 11:13:25','2023-04-05 11:30:18','2023-04-05 11:30:18'),(4589,8437,40875,131734,16,3257,'App\\Models\\PeriodLiquidation',NULL,3257,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16827.16,NULL,NULL,1,'2023-04-05 11:18:35','2023-04-05 11:18:35',NULL),(4590,8437,40875,761021,15,3369,'App\\Models\\PeriodLiquidation',NULL,3369,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',0.00,NULL,NULL,1,'2023-04-05 11:25:00','2023-04-05 11:25:00',NULL),(4591,8437,40875,131733,3,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',230.00,NULL,NULL,1,'2023-04-05 11:30:45','2023-04-05 11:30:45',NULL),(4592,8437,40875,131733,3,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',163.00,NULL,NULL,1,'2023-04-05 11:31:18','2023-04-05 11:31:18',NULL),(4593,8437,40875,131733,3,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',68.00,NULL,NULL,1,'2023-04-05 11:31:44','2023-04-05 11:31:44',NULL),(4594,8437,40875,131733,3,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',15000.00,NULL,NULL,1,'2023-04-05 11:32:16','2023-04-05 11:32:16',NULL),(4595,8437,40875,131733,3,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1345.00,NULL,NULL,1,'2023-04-05 11:33:00','2023-04-05 11:33:00',NULL),(4596,8437,40875,131733,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',9629.18,NULL,NULL,1,'2023-04-05 11:41:30','2023-04-05 11:41:49','2023-04-05 11:41:49'),(4597,8437,40875,131733,3,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8710.11,NULL,NULL,1,'2023-04-05 11:41:49','2023-04-05 11:41:49',NULL),(4598,8437,40875,131733,3,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',16000.99,NULL,NULL,1,'2023-04-05 11:44:17','2023-04-05 11:44:17',NULL),(4599,8437,40875,131733,16,3386,'App\\Models\\PeriodLiquidation',NULL,3386,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23243.07,NULL,NULL,1,'2023-04-05 11:49:25','2023-04-05 11:49:25',NULL),(4600,8437,40875,131733,15,3385,'App\\Models\\PeriodLiquidation',NULL,3385,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',108467.68,NULL,NULL,1,'2023-04-05 11:49:55','2023-04-05 11:49:55',NULL),(4601,8437,40875,131734,15,3256,'App\\Models\\PeriodLiquidation',NULL,3256,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',78526.80,NULL,NULL,1,'2023-04-05 11:54:46','2023-04-05 11:54:46',NULL),(4602,8437,41082,761216,15,3387,'App\\Models\\PeriodLiquidation',NULL,3387,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3443298.86,NULL,NULL,1,'2023-04-05 12:04:47','2023-04-05 12:05:59','2023-04-05 12:05:59');
INSERT INTO `balance_libro` VALUES (4603,8437,41082,761216,15,3387,'App\\Models\\PeriodLiquidation',NULL,3387,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',606457.72,NULL,NULL,1,'2023-04-05 12:08:57','2023-04-05 12:08:57',NULL),(4604,8437,40794,761411,15,3390,'App\\Models\\PeriodLiquidation',NULL,3390,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',0.00,NULL,NULL,1,'2023-04-05 12:46:06','2023-04-05 12:46:06',NULL),(4605,8444,40724,7533,2,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',20150.00,NULL,NULL,1,'2023-04-05 13:01:22','2023-04-05 13:01:22',NULL),(4606,8437,40881,761606,15,3393,'App\\Models\\PeriodLiquidation',NULL,3393,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',33409.76,NULL,NULL,1,'2023-04-05 13:35:54','2023-04-05 13:35:54',NULL),(4607,8437,40881,140823,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5039.66,NULL,NULL,1,'2023-04-05 13:45:59','2023-04-20 09:44:09','2023-04-20 09:44:09'),(4608,8437,40881,140823,3,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',12800.00,NULL,NULL,1,'2023-04-05 13:47:21','2023-04-05 13:47:21',NULL),(4609,8437,40881,140823,3,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',47633.76,NULL,NULL,1,'2023-04-05 13:48:15','2023-04-05 13:48:15',NULL),(4610,8437,40881,140823,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',10913.33,NULL,NULL,1,'2023-04-05 13:49:22','2023-04-05 13:49:22',NULL),(4611,8437,40881,140823,3,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',5565.89,NULL,NULL,1,'2023-04-05 13:50:02','2023-04-20 09:58:36','2023-04-20 09:58:36'),(4612,8437,40881,140823,3,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',15624.58,NULL,NULL,1,'2023-04-05 13:52:08','2023-04-05 13:52:08',NULL),(4613,8437,40881,140823,3,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',95.00,NULL,NULL,1,'2023-04-05 13:52:41','2023-04-20 09:39:05','2023-04-20 09:39:05'),(4614,8437,40881,140823,3,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1805.59,NULL,NULL,1,'2023-04-05 13:53:19','2023-04-20 09:44:51','2023-04-20 09:44:51'),(4615,8437,40881,140823,3,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',16393.51,NULL,NULL,1,'2023-04-05 13:54:13','2023-04-05 13:54:13',NULL),(4616,8437,40881,140823,3,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',26961.55,NULL,NULL,1,'2023-04-05 13:55:38','2023-04-05 13:55:38',NULL),(4617,8437,40881,140823,3,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',492000.00,NULL,NULL,1,'2023-04-05 13:56:18','2023-04-05 13:56:18',NULL),(4618,8437,40881,140823,3,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1620.00,NULL,NULL,1,'2023-04-05 13:56:58','2023-04-20 10:04:45','2023-04-20 10:04:45'),(4619,8437,40881,140823,3,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',40040.11,NULL,NULL,1,'2023-04-05 13:57:47','2023-04-05 13:57:47',NULL),(4620,8444,40724,7533,2,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',20150.00,NULL,NULL,1,'2023-04-05 16:15:46','2023-04-05 16:15:46',NULL),(4621,8444,40724,7533,2,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',20150.00,NULL,NULL,1,'2023-04-05 16:19:08','2023-04-05 16:19:08',NULL),(4622,8444,40724,7533,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',20150.00,NULL,NULL,1,'2023-04-05 16:20:28','2023-04-05 16:20:28',NULL);
INSERT INTO `balance_libro` VALUES (4623,8444,40724,7533,2,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',20150.00,NULL,NULL,1,'2023-04-05 16:21:19','2023-04-05 16:21:19',NULL),(4624,8444,40724,7533,2,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',20150.00,NULL,NULL,1,'2023-04-05 16:25:06','2023-04-05 16:25:06',NULL),(4625,8434,40846,119618,3,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',11000.00,NULL,NULL,1,'2023-04-05 16:46:48','2023-04-05 16:46:48',NULL),(4626,8434,40846,119618,3,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',33810.46,NULL,NULL,1,'2023-04-05 16:51:11','2023-04-05 16:51:11',NULL),(4627,8434,40846,119618,3,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',497360.01,NULL,NULL,1,'2023-04-05 16:52:45','2023-04-05 16:52:45',NULL),(4628,8434,40846,119618,3,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',940.00,NULL,NULL,1,'2023-04-05 16:54:54','2023-04-05 16:54:54',NULL),(4629,8434,40846,119618,3,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1400.00,NULL,NULL,1,'2023-04-05 16:56:09','2023-04-05 16:56:09',NULL),(4630,8434,40846,119618,3,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',3200.00,NULL,NULL,1,'2023-04-05 18:45:37','2023-04-05 18:45:37',NULL),(4631,8434,40846,119618,3,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',5050.00,NULL,NULL,1,'2023-04-06 11:39:41','2023-04-06 11:39:41',NULL),(4632,8434,40846,119618,3,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',9379.96,NULL,NULL,1,'2023-04-06 11:43:15','2023-04-06 11:43:15',NULL),(4633,8434,40846,119618,3,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',9501.00,NULL,NULL,1,'2023-04-06 11:44:57','2023-04-06 11:44:57',NULL),(4634,8434,40846,119618,3,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',11100.40,NULL,NULL,1,'2023-04-06 11:46:06','2023-04-09 23:51:02','2023-04-09 23:51:02'),(4635,8434,40846,119618,3,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',22358.61,NULL,NULL,1,'2023-04-06 11:47:25','2023-04-06 11:47:25',NULL),(4636,8434,40846,119618,3,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',134478.00,NULL,NULL,1,'2023-04-06 11:47:54','2023-04-06 11:47:54',NULL),(4637,8434,40846,119618,3,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',201011.25,NULL,NULL,1,'2023-04-06 11:48:17','2023-04-06 11:48:17',NULL),(4638,8434,40846,119618,3,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',201011.25,NULL,NULL,1,'2023-04-06 11:48:31','2023-04-06 11:48:31',NULL),(4639,8434,40846,119618,3,4639,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',28403.50,'Taxi/Estacionamiento/Micros Marzo',NULL,1,'2023-04-06 14:50:17','2023-04-06 14:50:17',NULL),(4640,8434,40846,119618,3,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8761.55,NULL,NULL,1,'2023-04-06 15:16:09','2023-04-06 15:16:09',NULL),(4641,8434,40846,119618,3,4641,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',30846.08,'Gastos Bancarios 03/2023',NULL,1,'2023-04-06 15:19:57','2023-04-06 15:19:57',NULL),(4642,8434,40846,119618,3,4642,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',45736.09,'Expensas Sr. Si 02/2023',NULL,1,'2023-04-06 15:25:52','2023-04-06 15:25:52',NULL);
INSERT INTO `balance_libro` VALUES (4643,8434,40846,119618,3,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',11174.78,NULL,NULL,1,'2023-04-06 16:47:43','2023-04-15 19:58:12','2023-04-15 19:58:12'),(4644,8434,40846,119618,3,4644,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',19263.00,'Pago a cuenta SICORE 03-2023',NULL,1,'2023-04-06 16:59:18','2023-04-06 16:59:18',NULL),(4645,8434,40846,119618,3,4645,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',323.48,'Pago Sicore mensual 02-2023',NULL,1,'2023-04-06 17:00:31','2023-04-06 17:00:31',NULL),(4646,8434,40846,119618,5,4646,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',6327945.21,'Acreditacion Plazo Fijo',NULL,1,'2023-04-06 17:18:03','2023-04-06 17:18:03',NULL),(4647,8434,40846,119618,3,4647,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',76356.03,'Pago Inspeccion SEC',NULL,1,'2023-04-06 17:22:37','2023-04-09 23:47:35','2023-04-09 23:47:35'),(4648,8434,40846,119618,3,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',6250.89,NULL,NULL,1,'2023-04-06 17:52:01','2023-04-06 17:52:01',NULL),(4649,8434,40846,119618,3,4649,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3200.00,'Compra debito KFC',NULL,1,'2023-04-06 17:53:45','2023-04-06 17:53:45',NULL),(4650,8434,40846,119618,3,3779,'App\\Models\\Receipt',3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',600.16,NULL,NULL,1,'2023-04-06 17:55:35','2023-04-06 17:55:35',NULL),(4651,8434,40846,119618,3,4651,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',310.87,'Gastos Tarjeta de Credito 03/2023',NULL,1,'2023-04-06 17:56:58','2023-04-06 17:56:58',NULL),(4652,8434,40846,119618,21,4202,'App\\Models\\CtaCteCliente',NULL,NULL,NULL,4202,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',62364.32,NULL,NULL,1,'2023-04-06 18:07:59','2023-04-06 18:07:59',NULL),(4653,8434,40846,119618,3,4653,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',41982.22,'Pago OSDE',NULL,1,'2023-04-06 18:09:29','2023-04-06 18:09:29',NULL),(4654,8434,40846,119618,3,4654,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',415.09,'GOOGLE *Google S P0QbVbEh',NULL,1,'2023-04-09 19:44:12','2023-04-09 19:44:12',NULL),(4655,8434,40846,119618,3,4655,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',76356.03,'Pago Inspeccion SEC',NULL,1,'2023-04-09 23:47:35','2023-04-09 23:47:35',NULL),(4656,8434,40846,119618,3,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',11100.40,NULL,NULL,1,'2023-04-09 23:51:02','2023-04-09 23:51:02',NULL),(4657,8437,40794,48413,3,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',80000.00,NULL,NULL,1,'2023-04-10 10:05:36','2023-04-10 10:08:49','2023-04-10 10:08:49'),(4658,8437,40794,48413,3,3781,'App\\Models\\Receipt',3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',47318.41,NULL,NULL,1,'2023-04-10 10:05:36','2023-04-10 10:11:36','2023-04-10 10:11:36'),(4659,8437,40794,48413,3,3782,'App\\Models\\Receipt',3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',70000.00,NULL,NULL,1,'2023-04-10 10:05:36','2023-04-10 10:10:04','2023-04-10 10:10:04'),(4660,8437,40794,48413,3,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',80000.