-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-36746223-0
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-17 20:40:00','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-17 20:40:00','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'contador.alejandrososa@gmail.com','2631542796',NULL,1,40719,'2022-10-27');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(5,3,1,63,NULL,0.00,'2023-04-18 17:56:34','2023-04-18 17:56:34',NULL),(6,3,1,484,NULL,0.00,'2023-04-18 17:56:34','2023-04-18 17:56:34',NULL),(7,3,1,485,NULL,0.00,'2023-04-18 17:56:34','2023-04-18 17:56:34',NULL),(8,3,1,486,NULL,0.00,'2023-04-18 17:56:34','2023-04-18 17:56:34',NULL),(9,3,1,359,NULL,0.00,'2023-04-18 17:56:34','2023-04-18 17:56:34',NULL),(10,3,1,410,NULL,0.00,'2023-04-18 17:56:34','2023-04-18 17:56:34',NULL),(11,3,1,410,NULL,0.00,'2023-04-18 17:56:34','2023-04-18 17:56:34',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,7562,1,2,'Pago de Sueldo y CS',0.00,'2023-04-18 17:56:34','2023-04-18 17:56:34',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1036 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7562,40721,3051,3,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1540.00,NULL,NULL,1,'2023-04-11 19:52:55','2023-04-11 19:52:55',NULL),(2,7562,40721,3051,3,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3162.89,NULL,NULL,1,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(3,7562,40721,3051,3,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',2000.00,NULL,NULL,1,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(4,7562,40721,3051,3,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',6449.30,NULL,NULL,1,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(5,7562,40721,3051,3,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',68400.01,NULL,NULL,1,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(6,7562,40721,3051,3,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',2200.00,NULL,NULL,1,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(7,7562,40721,3051,3,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',70400.00,NULL,NULL,1,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(8,7562,40721,3051,3,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1950.00,NULL,NULL,1,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(9,7562,40721,3051,3,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',700.00,NULL,NULL,1,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(10,7562,40721,3051,3,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',900.00,NULL,NULL,1,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(11,7562,40721,3051,3,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',15001.18,NULL,NULL,1,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(12,7562,40721,3051,3,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',2000.00,NULL,NULL,1,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(13,7562,40721,3051,3,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',1999.99,NULL,NULL,1,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(14,7562,40721,3051,3,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',3000.13,NULL,NULL,1,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(15,7562,40721,3051,3,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',5000.12,NULL,NULL,1,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(16,7562,40721,3051,3,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',3000.13,NULL,NULL,1,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(17,7562,40721,3051,3,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',5000.01,NULL,NULL,1,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(18,7562,40721,3051,3,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',5000.07,NULL,NULL,1,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(19,7562,40721,3051,3,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',5000.05,NULL,NULL,1,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(20,7562,40721,3051,3,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',6500.07,NULL,NULL,1,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(21,7562,40720,1539,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',5350.00,NULL,NULL,1,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(22,7562,40720,1539,2,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3030.02,NULL,NULL,1,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(23,7562,40720,1539,2,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',3000.00,NULL,NULL,1,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(24,7562,40720,1539,2,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',33000.00,NULL,NULL,1,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(25,7562,40720,1539,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1344323.85,NULL,NULL,1,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL);
INSERT INTO `balance_libro` VALUES (26,7562,40720,1539,3,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',126383.19,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(27,7562,40720,1539,3,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',8605.52,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(28,7562,40720,1539,3,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',19190.21,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(29,7562,40720,1539,3,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',14302.78,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(30,7562,40720,1539,3,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',19363.41,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(31,7562,40720,1539,3,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',45737.20,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(32,7562,40720,1539,3,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',24452.94,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(33,7562,40720,1539,3,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',8948.33,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(34,7562,40720,1539,3,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4500.01,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(35,7562,40720,1539,3,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1962.52,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(36,7562,40720,1539,3,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',200.00,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(37,7562,40720,1539,3,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',29912.76,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(38,7562,40720,1539,3,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',11204.62,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(39,7562,40720,1539,3,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',10004.44,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(40,7562,40720,1539,3,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',3294.23,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(41,7562,40720,1539,3,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',7376.47,NULL,NULL,1,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(42,7562,40740,4623,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2000.00,NULL,NULL,1,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(43,7562,40740,4623,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',3200.00,NULL,NULL,1,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(44,7562,40740,4623,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2300.00,NULL,NULL,1,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(45,7562,40740,4623,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',4800.00,NULL,NULL,1,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(46,7562,40740,4623,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',5175.00,NULL,NULL,1,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(47,7562,40740,4623,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',4900.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(48,7562,40740,4623,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',6000.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(49,7562,40740,4623,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',3000.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(50,7562,40740,4623,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',17800.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL);
INSERT INTO `balance_libro` VALUES (51,7562,40740,4623,2,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2700.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(52,7562,40740,4623,2,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',5600.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(53,7562,40740,4623,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',9900.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(54,7562,40740,4623,2,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',4200.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(55,7562,40740,4623,2,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',6780.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(56,7562,40740,4623,2,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',16800.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(57,7562,40740,4623,2,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',9800.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(58,7562,40740,4623,2,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',5600.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(59,7562,40740,4623,2,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3800.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(60,7562,40740,4623,2,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1500.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(61,7562,40740,4623,2,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',5060.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(62,7562,40740,4623,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',3900.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(63,7562,40740,4623,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',4500.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(64,7562,40740,4623,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',13800.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(65,7562,40740,4623,2,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',5290.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(66,7562,40740,4623,2,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',12600.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(67,7562,40740,4623,2,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',7900.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(68,7562,40740,4623,2,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',4200.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(69,7562,40740,4623,2,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',2800.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(70,7562,40740,4623,2,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',13800.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(71,7562,40740,4623,2,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',7930.00,NULL,NULL,1,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(72,7562,40740,4623,2,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',5500.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(73,7562,40740,4623,2,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',11000.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(74,7562,40740,4623,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',5000.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(75,7562,40740,4623,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',4800.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL);
INSERT INTO `balance_libro` VALUES (76,7562,40740,4623,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',15000.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(77,7562,40740,4623,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',4200.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(78,7562,40740,4623,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',5900.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(79,7562,40740,4623,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',5600.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(80,7562,40740,4623,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',5175.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(81,7562,40740,4623,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',9900.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(82,7562,40740,4623,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',10000.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(83,7562,40740,4623,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',10000.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(84,7562,40740,4623,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3900.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(85,7562,40740,4623,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',9200.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(86,7562,40740,4623,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',3500.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(87,7562,40740,4623,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',9900.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(88,7562,40740,4623,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',4000.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(89,7562,40740,4623,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',5000.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(90,7562,40740,4623,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',8900.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(91,7562,40740,4623,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',3910.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(92,7562,40740,4623,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',4300.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(93,7562,40740,4623,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',6800.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(94,7562,40740,4623,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',5000.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(95,7562,40740,4623,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',8000.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(96,7562,40740,4623,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3900.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(97,7562,40740,4623,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',3900.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(98,7562,40740,4623,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',16000.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(99,7562,40740,4623,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',11800.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(100,7562,40740,4623,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',6780.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL);
INSERT INTO `balance_libro` VALUES (101,7562,40740,4623,2,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',10235.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(102,7562,40740,4623,2,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',8900.00,NULL,NULL,1,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(103,7562,40740,4623,2,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',4400.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(104,7562,40740,4623,2,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',10400.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(105,7562,40740,4623,2,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',7470.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(106,7562,40740,4623,2,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',7470.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(107,7562,40740,4623,2,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',5900.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(108,7562,40740,4623,2,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',4400.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(109,7562,40740,4623,2,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',5900.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(110,7562,40740,4623,2,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',15580.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(111,7562,40740,4623,2,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',7300.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(112,7562,40740,4623,2,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',5500.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(113,7562,40740,4623,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',13800.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(114,7562,40740,4623,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',5000.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(115,7562,40740,4623,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',4900.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(116,7562,40740,4623,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',6500.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(117,7562,40740,4623,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',4800.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(118,7562,40740,4623,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',3680.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(119,7562,40740,4623,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',6800.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(120,7562,40740,4623,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',4600.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(121,7562,40740,4623,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',6000.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(122,7562,40740,4623,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',8160.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(123,7562,40740,4623,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',12880.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(124,7562,40740,4623,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',4900.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(125,7562,40740,4623,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',2800.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL);
INSERT INTO `balance_libro` VALUES (126,7562,40740,4623,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',6300.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(127,7562,40740,4623,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',11210.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(128,7562,40740,4623,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',6320.00,NULL,NULL,1,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(129,7562,40740,4623,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',4900.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(130,7562,40740,4623,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',8000.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(131,7562,40740,4623,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',6200.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(132,7562,40740,4623,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',12000.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(133,7562,40740,4623,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',5060.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(134,7562,40740,4623,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',6000.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(135,7562,40740,4623,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',9500.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(136,7562,40740,4623,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5500.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(137,7562,40740,4623,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',15000.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(138,7562,40740,4623,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',12000.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(139,7562,40740,4623,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8000.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(140,7562,40740,4623,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',15000.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(141,7562,40740,4623,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10000.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(142,7562,40740,4623,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',10000.00,NULL,NULL,1,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(143,7562,40740,4623,3,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',79656.72,NULL,NULL,1,'2023-04-14 16:20:00','2023-04-14 16:20:00',NULL),(144,7562,40740,4623,3,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',38231.16,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(145,7562,40740,4623,3,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',9177.76,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(146,7562,40740,4623,3,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',5894.39,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(147,7562,40740,4623,3,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3992.77,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(148,7562,40740,4623,3,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',368.72,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(149,7562,40740,4623,3,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',10391.73,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(150,7562,40740,4623,3,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',94609.90,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL);
INSERT INTO `balance_libro` VALUES (151,7562,40740,4623,3,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',11374.00,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(152,7562,40740,4623,3,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',18399.26,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(153,7562,40740,4623,3,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',45445.21,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(154,7562,40740,4623,3,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',17554.10,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(155,7562,40740,4623,3,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',5965.01,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(156,7562,40740,4623,3,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',5965.01,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:31:14','2023-04-14 16:31:14'),(157,7562,40740,4623,3,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',4610.00,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:31:04','2023-04-14 16:31:04'),(158,7562,40740,4623,3,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',250000.00,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(159,7562,40740,4623,3,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',7710.12,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(160,7562,40740,4623,3,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',5940.84,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(161,7562,40740,4623,3,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',105366.80,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(162,7562,40740,4623,3,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',74304.26,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(163,7562,40740,4623,3,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8777.05,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(164,7562,40740,4623,3,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',9999.96,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(165,7562,40740,4623,3,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',4400.05,NULL,NULL,1,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(172,7562,40720,1515,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',4722514.77,NULL,NULL,1,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(173,7562,40720,1515,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',4722514.77,NULL,NULL,1,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(174,7562,40720,1515,13,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',331249.55,'Pago de Sueldos y Cargas Sociales 2021-06',NULL,1,'2023-04-17 16:50:38','2023-04-17 16:50:38',NULL),(175,7562,40720,1515,13,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',3363.90,'Pago de IVA 2021-06',NULL,1,'2023-04-17 16:51:57','2023-04-17 16:51:57',NULL),(179,7562,40720,1515,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',354515.71,NULL,NULL,1,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(180,7562,40720,1516,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',359520.43,NULL,NULL,1,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(181,7562,40720,1517,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',367754.54,NULL,NULL,1,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(182,7562,40720,1518,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',435783.18,NULL,NULL,1,'2023-04-17 16:54:27','2023-04-17 16:54:28',NULL),(183,7562,40720,1519,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',422866.88,NULL,NULL,1,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL);
INSERT INTO `balance_libro` VALUES (184,7562,40720,1520,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',562211.33,NULL,NULL,1,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(185,7562,40720,1522,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',376742.13,NULL,NULL,1,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(186,7562,40720,1523,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',434923.95,NULL,NULL,1,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(187,7562,40720,1524,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',559256.99,NULL,NULL,1,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(188,7562,40720,1525,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',559256.99,NULL,NULL,1,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(189,7562,40720,1526,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',523925.63,NULL,NULL,1,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(190,7562,40720,1527,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',806645.90,NULL,NULL,1,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(191,7562,40720,1519,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',236135.04,'DDJJ IG 2021',NULL,1,'2023-04-18 17:03:16','2023-04-18 17:33:29','2023-04-18 17:33:29'),(192,7562,40720,1519,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',236135.04,'DDJJ IG 2021',NULL,1,'2023-04-18 17:33:29','2023-04-20 16:05:55','2023-04-20 16:05:55'),(193,7562,40720,1519,13,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',919695.70,'Resultado del Ej. Ant',NULL,1,'2023-04-18 17:36:37','2023-04-21 15:07:15','2023-04-21 15:07:15'),(194,7562,40720,1515,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',300923.62,'Pago de Sueldos',NULL,1,'2023-04-18 17:48:30','2023-04-18 17:48:30',NULL),(195,7562,40720,1516,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-10','2021-08-10',35619.12,'Pago de CS - 2021-02',NULL,1,'2023-04-18 17:59:21','2023-04-18 17:59:21',NULL),(196,7562,40720,1516,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',304140.28,'Pago de CS y Sueldos - 2021-08',NULL,1,'2023-04-18 18:02:49','2023-04-18 18:30:21','2023-04-18 18:30:21'),(197,7562,40720,1517,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',316599.51,'Pago de Sueldo y CS - 2021-08',NULL,1,'2023-04-18 18:07:36','2023-04-18 18:07:36',NULL),(198,7562,40720,1518,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',374704.23,'Pago de Sueldo y CS - 2021-09',NULL,1,'2023-04-18 18:12:29','2023-04-18 18:12:29',NULL),(199,7562,40720,1519,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',371526.93,'Pago de Sueldo y CS - 2021-10',NULL,1,'2023-04-18 18:14:08','2023-04-18 18:54:04','2023-04-18 18:54:04'),(200,7562,40720,1520,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',366889.15,'Pago de Sueldo y CS -2021-11',NULL,1,'2023-04-18 18:16:10','2023-04-18 18:16:10',NULL),(201,7562,40720,1522,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',479290.49,'Pago de Sueldo y CS - 2021-12',NULL,1,'2023-04-18 18:18:36','2023-04-18 18:18:36',NULL),(202,7562,40720,1523,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',330418.84,'Pago de Sueldo y CS - 2022-01',NULL,1,'2023-04-18 18:20:30','2023-04-18 18:20:30',NULL),(203,7562,40720,1524,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-07','2022-03-07',380423.56,'Pago de Sueldo y CS -2022-02',NULL,1,'2023-04-18 18:22:34','2023-04-18 18:22:34',NULL),(204,7562,40720,1525,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',486943.39,'Pago de Sueldo y CS -2022-03',NULL,1,'2023-04-18 18:24:17','2023-04-18 18:24:17',NULL),(205,7562,40720,1526,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',487025.64,'Pago de Sueldo y CS -2022-04',NULL,1,'2023-04-18 18:27:40','2023-04-18 18:27:40',NULL);
INSERT INTO `balance_libro` VALUES (206,7562,40720,1527,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-10','2022-06-10',444024.35,'Pago de Sueldo y CS - 2022-05',NULL,1,'2023-04-18 18:29:16','2023-04-18 18:29:16',NULL),(207,7562,40720,1516,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20','2021-08-20',304140.28,'Pago de CS y Sueldos - 2021-07',NULL,1,'2023-04-18 18:30:21','2023-04-18 18:30:21',NULL),(208,7562,40720,1519,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',36966.77,'Pago de Sueldo y CS - 2021-10',NULL,1,'2023-04-18 18:54:04','2023-04-18 18:54:04',NULL),(209,7562,40720,1515,13,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',26014.98,'Pago de prestamo',NULL,1,'2023-04-19 15:06:37','2023-04-19 15:06:37',NULL),(232,7562,40720,1515,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',595073.69,NULL,NULL,1,'2023-04-19 15:45:06','2023-04-19 15:47:19','2023-04-19 15:47:19'),(233,7562,40720,1516,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',772428.79,NULL,NULL,1,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(234,7562,40720,1517,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',860924.60,NULL,NULL,1,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(235,7562,40720,1518,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',641654.65,NULL,NULL,1,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(236,7562,40720,1519,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',842808.87,NULL,NULL,1,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(237,7562,40720,1520,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',679554.78,NULL,NULL,1,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(238,7562,40720,1522,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-30','2022-01-30',828103.12,NULL,NULL,1,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(239,7562,40720,1523,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',845676.63,NULL,NULL,1,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(240,7562,40720,1524,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',802012.31,NULL,NULL,1,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(241,7562,40720,1540,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1019799.39,NULL,NULL,1,'2023-04-19 15:45:39','2023-04-19 15:46:00','2023-04-19 15:46:00'),(242,7562,40720,1541,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',813356.62,NULL,NULL,1,'2023-04-19 15:45:39','2023-04-19 15:46:19','2023-04-19 15:46:19'),(243,7562,40720,1542,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',941815.01,NULL,NULL,1,'2023-04-19 15:45:40','2023-04-19 15:46:31','2023-04-19 15:46:31'),(244,7562,40720,1525,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1019799.39,NULL,NULL,1,'2023-04-19 15:46:00','2023-04-19 15:47:19','2023-04-19 15:47:19'),(245,7562,40720,1526,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',813356.62,NULL,NULL,1,'2023-04-19 15:46:19','2023-04-19 15:47:19','2023-04-19 15:47:19'),(246,7562,40720,1527,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',941815.01,NULL,NULL,1,'2023-04-19 15:46:31','2023-04-19 15:47:19','2023-04-19 15:47:19'),(247,7562,40720,1515,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',595073.69,NULL,NULL,1,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(248,7562,40720,1516,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',772428.79,NULL,NULL,1,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(249,7562,40720,1517,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',860924.60,NULL,NULL,1,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL);
INSERT INTO `balance_libro` VALUES (250,7562,40720,1518,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',641654.65,NULL,NULL,1,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(251,7562,40720,1519,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',842808.87,NULL,NULL,1,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(252,7562,40720,1520,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',679554.78,NULL,NULL,1,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(253,7562,40720,1522,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-30','2022-01-30',828103.12,NULL,NULL,1,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(254,7562,40720,1523,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',845676.63,NULL,NULL,1,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(255,7562,40720,1524,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',802012.31,NULL,NULL,1,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(256,7562,40720,1540,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1019799.39,NULL,NULL,1,'2023-04-19 15:49:08','2023-04-19 15:49:51','2023-04-19 15:49:51'),(257,7562,40720,1541,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',813356.62,NULL,NULL,1,'2023-04-19 15:49:08','2023-04-19 15:50:00','2023-04-19 15:50:00'),(258,7562,40720,1542,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',941815.01,NULL,NULL,1,'2023-04-19 15:49:08','2023-04-19 15:50:11','2023-04-19 15:50:11'),(259,7562,40720,1525,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1019799.39,NULL,NULL,1,'2023-04-19 15:49:51','2023-04-19 15:49:51',NULL),(260,7562,40720,1526,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',813356.62,NULL,NULL,1,'2023-04-19 15:50:00','2023-04-19 15:50:00',NULL),(261,7562,40720,1527,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',941815.01,NULL,NULL,1,'2023-04-19 15:50:11','2023-04-19 15:50:11',NULL),(262,7562,40720,1515,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',188063.76,'Compras - 2021-07',NULL,1,'2023-04-19 16:48:13','2023-04-19 16:48:13',NULL),(263,7562,40720,1516,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',220890.99,'compras - 2021-08',NULL,1,'2023-04-19 16:50:26','2023-04-19 16:50:26',NULL),(264,7562,40720,1517,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',237244.14,'compras - 2021-09',NULL,1,'2023-04-19 16:52:24','2023-04-19 16:52:24',NULL),(265,7562,40720,1518,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',219817.87,'compras - 2021-10',NULL,1,'2023-04-19 18:23:10','2023-04-19 18:23:10',NULL),(266,7562,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',240055.02,'Compras - 2021-11',NULL,1,'2023-04-19 18:25:19','2023-04-19 18:25:19',NULL),(267,7562,40720,1520,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',219918.37,'Compras - 2021-12',NULL,1,'2023-04-19 18:27:21','2023-04-19 18:27:21',NULL),(268,7562,40720,1522,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',238362.99,'Compras - 2022-01',NULL,1,'2023-04-19 18:29:26','2023-04-19 18:29:26',NULL),(269,7562,40720,1523,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',231844.80,'Compras - 2022-02',NULL,1,'2023-04-19 18:31:46','2023-04-19 18:31:46',NULL),(270,7562,40720,1524,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',285790.03,'Compras - 2022-03',NULL,1,'2023-04-19 18:36:19','2023-04-19 18:43:19','2023-04-19 18:43:19'),(271,7562,40720,1525,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',245675.30,'Compras - 2022-04',NULL,1,'2023-04-19 18:40:57','2023-04-19 18:40:57',NULL),(272,7562,40720,1524,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',285934.28,'Compras - 2022-03',NULL,1,'2023-04-19 18:43:19','2023-04-19 18:43:19',NULL);
INSERT INTO `balance_libro` VALUES (273,7562,40720,1526,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',341790.24,'Compras - 2022-05',NULL,1,'2023-04-19 18:45:28','2023-04-19 18:45:28',NULL),(274,7562,40720,1527,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',257950.74,'Compras - 2022-06',NULL,1,'2023-04-19 18:47:44','2023-04-19 18:47:44',NULL),(275,7562,40720,1527,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',119441.52,'Gastos Bancarios',NULL,1,'2023-04-19 22:40:34','2023-04-19 22:40:34',NULL),(276,7562,40720,1527,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',165996.18,'Retenciones IG 2021-22',NULL,1,'2023-04-19 22:42:15','2023-04-19 22:42:15',NULL),(277,7562,40720,1527,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',489959.51,'P.Pago AFIP - P687293',NULL,1,'2023-04-19 22:57:19','2023-04-19 22:57:57','2023-04-19 22:57:57'),(278,7562,40720,1522,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',489959.51,'P.Pago AFIP - P687293',NULL,1,'2023-04-19 22:57:57','2023-04-19 23:07:16','2023-04-19 23:07:16'),(279,7562,40720,1522,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',131240.96,'P.Pago AFIP - P687253',NULL,1,'2023-04-19 23:01:51','2023-04-19 23:01:51',NULL),(280,7562,40720,1523,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',148761.28,'P.Pago AFIP - P801411',NULL,1,'2023-04-19 23:04:33','2023-04-19 23:04:33',NULL),(281,7562,40720,1526,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-19','2022-05-19',109246.16,'P.Pago AFIP - Q312355',NULL,1,'2023-04-19 23:06:36','2023-04-19 23:06:36',NULL),(282,7562,40720,1522,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',489959.51,'P.Pago AFIP - M 014874',NULL,1,'2023-04-19 23:07:16','2023-04-19 23:07:50','2023-04-19 23:07:50'),(283,7562,40720,1522,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',489959.51,'P.Pago AFIP - P687293',NULL,1,'2023-04-19 23:07:50','2023-04-19 23:07:50',NULL),(284,7562,40720,1527,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',102372.51,'Pagos de IVA',NULL,1,'2023-04-20 15:22:36','2023-04-20 15:23:17','2023-04-20 15:23:17'),(285,7562,40720,1527,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',102372.51,'Pagos de IVA',NULL,1,'2023-04-20 15:23:17','2023-04-20 16:05:00','2023-04-20 16:05:00'),(286,7562,40720,1515,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',24135.74,'Ingresos Brutos - 2021-07',NULL,1,'2023-04-20 15:31:23','2023-04-20 15:31:23',NULL),(287,7562,40720,1516,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',30651.53,'Ingresos Brutos - 2021-08',NULL,1,'2023-04-20 15:32:59','2023-04-20 15:32:59',NULL),(288,7562,40720,1517,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',34644.74,'Ingresos Brutos - 2021-09',NULL,1,'2023-04-20 15:33:57','2023-04-20 15:33:57',NULL),(289,7562,40720,1518,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',25585.21,'Ingresos Brutos - 2021-10',NULL,1,'2023-04-20 15:35:01','2023-04-20 15:35:01',NULL),(290,7562,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',33260.08,'Ingresos Brutos - 2021-11',NULL,1,'2023-04-20 15:36:03','2023-04-20 15:36:03',NULL),(291,7562,40720,1520,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',28400.13,'Ingresos Brutos - 2021-12',NULL,1,'2023-04-20 15:37:18','2023-04-20 15:37:18',NULL),(292,7562,40720,1522,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',32622.87,'Ingresos Brutos - 2022-01',NULL,1,'2023-04-20 15:38:15','2023-04-20 15:38:15',NULL),(293,7562,40720,1523,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',35654.27,'Ingresos Brutos - 2022-02',NULL,1,'2023-04-20 15:39:50','2023-04-20 15:39:50',NULL);
INSERT INTO `balance_libro` VALUES (294,7562,40720,1524,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',32110.44,'Ingresos Brutos - 2022-03',NULL,1,'2023-04-20 15:40:46','2023-04-20 15:40:46',NULL),(295,7562,40720,1525,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',40363.70,'Ingresos Brutos - 2022-04',NULL,1,'2023-04-20 15:41:41','2023-04-20 15:41:41',NULL),(296,7562,40720,1526,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',32534.26,'Ingresos Brutos - 2022-05',NULL,1,'2023-04-20 15:42:43','2023-04-20 15:42:43',NULL),(297,7562,40720,1527,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',38676.25,'Ingresos Brutos - 2022-06',NULL,1,'2023-04-20 15:43:48','2023-04-20 15:48:46','2023-04-20 15:48:46'),(298,7562,40720,1527,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',38676.25,'Ingresos Brutos - 2022-06',NULL,1,'2023-04-20 15:48:46','2023-04-20 15:48:46',NULL),(299,7562,40720,1527,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',42124.30,'Pago de plan de ATM',NULL,1,'2023-04-20 15:53:24','2023-04-20 15:53:24',NULL),(300,7562,40720,1527,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',7242.89,'Ajuste de cierre',NULL,1,'2023-04-20 15:57:55','2023-04-20 15:57:55',NULL),(301,7562,40720,1527,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',423908.65,'Pagos de Planes AFIP',NULL,1,'2023-04-20 16:02:14','2023-04-20 16:18:58','2023-04-20 16:18:58'),(302,7562,40720,1527,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',102372.52,'Pagos de IVA',NULL,1,'2023-04-20 16:05:00','2023-04-20 16:05:00',NULL),(303,7562,40720,1519,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',236135.04,'DDJJ IG 2021',NULL,1,'2023-04-20 16:05:55','2023-04-20 16:05:55',NULL),(304,7562,40720,1527,21,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2982258.44,'Pago a Proveedores',NULL,1,'2023-04-20 16:16:26','2023-04-20 16:16:26',NULL),(305,7562,40720,1527,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',423908.65,'Pagos de Planes AFIP',NULL,1,'2023-04-20 16:18:58','2023-04-20 16:18:58',NULL),(306,7562,40720,1527,18,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',312769.41,'Ajuste de Deudores',NULL,1,'2023-04-20 16:25:53','2023-04-20 16:25:53',NULL),(307,7562,40720,1515,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',147510.00,NULL,NULL,1,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(308,7562,40720,1515,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',47565.63,NULL,NULL,1,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(309,7562,40720,1516,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',61276.25,NULL,NULL,1,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(310,7562,40720,1517,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',148299.00,NULL,NULL,1,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(311,7562,40720,1517,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',68345.68,NULL,NULL,1,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(312,7562,40720,1518,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-30','2021-10-30',51053.86,NULL,NULL,1,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(313,7562,40720,1519,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',147914.00,NULL,NULL,1,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(314,7562,40720,1519,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',66520.17,NULL,NULL,1,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(315,7562,40720,1520,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',145617.00,NULL,NULL,1,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(316,7562,40720,1520,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-30','2021-12-30',53758.62,NULL,NULL,1,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL);
INSERT INTO `balance_libro` VALUES (317,7562,40720,1522,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-30','2022-01-30',127001.00,NULL,NULL,1,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(318,7562,40720,1522,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-30','2022-01-30',65245.74,NULL,NULL,1,'2023-04-21 11:33:44','2023-04-21 11:33:45',NULL),(319,7562,40720,1523,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',166821.00,NULL,NULL,1,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(320,7562,40720,1523,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',67116.17,NULL,NULL,1,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(321,7562,40720,1524,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',144281.00,NULL,NULL,1,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(322,7562,40720,1524,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-30','2022-03-30',63498.68,NULL,NULL,1,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(323,7562,40720,1540,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',161299.00,NULL,NULL,1,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(324,7562,40720,1540,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',80727.41,NULL,NULL,1,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(325,7562,40720,1541,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',65068.53,NULL,NULL,1,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(326,7562,40720,1542,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',73089.54,NULL,NULL,1,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(327,7562,40720,1527,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1295355.03,'Compras de Insumos',NULL,1,'2023-04-21 14:41:47','2023-04-21 14:41:47',NULL),(328,7562,40720,1519,13,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',919695.70,'Resultado del Ej. Ant',NULL,1,'2023-04-21 15:07:15','2023-04-21 15:07:15',NULL),(329,7562,40720,1527,11,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',9036518.14,'Costo de venta de servicios',NULL,1,'2023-04-21 16:09:36','2023-04-21 16:09:36',NULL),(330,7562,40720,1527,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',4748198.94,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-21 16:25:24','2023-04-21 16:25:26',NULL),(331,7562,40720,1540,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',9983.00,NULL,NULL,1,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(332,7562,40720,1540,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',2760.00,NULL,NULL,1,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(333,7562,40720,1540,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',8520.02,NULL,NULL,1,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(334,7562,40720,1540,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',1707231.10,NULL,NULL,1,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(335,7562,40720,1540,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',2190.00,NULL,NULL,1,'2023-05-17 11:08:58','2023-05-17 11:08:58',NULL),(336,7562,40720,1540,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',16000.00,NULL,NULL,1,'2023-05-17 11:08:58','2023-05-17 11:08:58',NULL),(337,7562,40720,1540,3,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',173932.62,NULL,NULL,1,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(338,7562,40720,1540,3,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',26940.78,NULL,NULL,1,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(339,7562,40720,1540,3,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1563.93,NULL,NULL,1,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(340,7562,40720,1540,3,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',23000.00,NULL,NULL,1,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL);
INSERT INTO `balance_libro` VALUES (341,7562,40720,1540,3,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',9359.60,NULL,NULL,1,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(342,7562,40720,1540,3,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',61676.88,NULL,NULL,1,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(343,7562,40720,1540,3,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',47576.34,NULL,NULL,1,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(344,7562,40720,1540,3,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',15824.38,NULL,NULL,1,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(345,7562,40720,1540,3,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',11658.31,NULL,NULL,1,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(346,7562,40720,1540,3,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',7082.61,NULL,NULL,1,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(347,7562,40720,1540,3,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',45631.30,NULL,NULL,1,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(348,7562,40720,1540,3,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',37000.00,NULL,NULL,1,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(349,7562,40720,1540,3,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',9265.74,NULL,NULL,1,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(350,7562,40720,1540,3,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',10849.96,NULL,NULL,1,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(351,7562,40740,4624,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',2000.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(352,7562,40740,4624,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',5500.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(353,7562,40740,4624,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',7900.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(354,7562,40740,4624,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',4900.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(355,7562,40740,4624,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',6100.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(356,7562,40740,4624,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',6900.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(357,7562,40740,4624,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',25760.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(358,7562,40740,4624,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',3200.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(359,7562,40740,4624,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',5520.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(360,7562,40740,4624,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2000.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(361,7562,40740,4624,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',26450.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(362,7562,40740,4624,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',10800.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(363,7562,40740,4624,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',24900.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(364,7562,40740,4624,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',5000.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(365,7562,40740,4624,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',10000.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL);
INSERT INTO `balance_libro` VALUES (366,7562,40740,4624,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',6900.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(367,7562,40740,4624,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',5000.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(368,7562,40740,4624,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',5250.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(369,7562,40740,4624,2,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',6800.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(370,7562,40740,4624,2,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',6800.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(371,7562,40740,4624,2,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',8900.00,NULL,NULL,1,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(372,7562,40740,4624,2,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',9770.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(373,7562,40740,4624,2,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',5200.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(374,7562,40740,4624,2,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',5520.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(375,7562,40740,4624,2,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',6800.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(376,7562,40740,4624,2,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',8900.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(377,7562,40740,4624,2,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',9770.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(378,7562,40740,4624,2,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',3800.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(379,7562,40740,4624,2,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',5000.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(380,7562,40740,4624,2,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',3400.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(381,7562,40740,4624,2,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',11500.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(382,7562,40740,4624,2,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',8100.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(383,7562,40740,4624,2,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',3400.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(384,7562,40740,4624,2,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',15640.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(385,7562,40740,4624,2,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',8620.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(386,7562,40740,4624,2,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',4600.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(387,7562,40740,4624,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',4600.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(388,7562,40740,4624,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',3400.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(389,7562,40740,4624,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',7200.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(390,7562,40740,4624,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',5700.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL);
INSERT INTO `balance_libro` VALUES (391,7562,40740,4624,2,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',10000.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(392,7562,40740,4624,2,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',5000.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(393,7562,40740,4624,2,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',5000.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(394,7562,40740,4624,2,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',7000.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(395,7562,40740,4624,2,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',18000.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(396,7562,40740,4624,2,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',18600.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(397,7562,40740,4624,2,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',4800.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(398,7562,40740,4624,2,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',5600.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(399,7562,40740,4624,2,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',18400.00,NULL,NULL,1,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(400,7562,40740,4624,2,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',11500.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(401,7562,40740,4624,2,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',13800.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(402,7562,40740,4624,2,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',6780.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(403,7562,40740,4624,2,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',5290.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(404,7562,40740,4624,2,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',6780.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(405,7562,40740,4624,2,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',30600.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(406,7562,40740,4624,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',10000.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(407,7562,40740,4624,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',5630.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(408,7562,40740,4624,2,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',3800.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(409,7562,40740,4624,2,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',15000.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(410,7562,40740,4624,2,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',6000.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(411,7562,40740,4624,2,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',8400.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(412,7562,40740,4624,2,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',6800.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(413,7562,40740,4624,2,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',4900.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(414,7562,40740,4624,2,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',5600.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(415,7562,40740,4624,2,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',24000.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL);
INSERT INTO `balance_libro` VALUES (416,7562,40740,4624,2,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',5900.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(417,7562,40740,4624,2,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',3900.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(418,7562,40740,4624,2,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',7900.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(419,7562,40740,4624,2,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',6780.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(420,7562,40740,4624,2,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',12500.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(421,7562,40740,4624,2,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',9900.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(422,7562,40740,4624,2,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',5900.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(423,7562,40740,4624,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',6800.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(424,7562,40740,4624,2,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',5900.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(425,7562,40740,4624,2,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',5000.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(426,7562,40740,4624,2,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',11960.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(427,7562,40740,4624,2,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',5000.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(428,7562,40740,4624,2,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',14700.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(429,7562,40740,4624,2,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',7000.00,NULL,NULL,1,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(430,7562,40740,4624,2,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',6780.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(431,7562,40740,4624,2,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',27600.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(432,7562,40740,4624,2,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',5980.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(433,7562,40740,4624,2,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',5630.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(434,7562,40740,4624,2,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',9770.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(435,7562,40740,4624,2,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',11300.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(436,7562,40740,4624,2,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',4000.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(437,7562,40740,4624,2,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',2000.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(438,7562,40740,4624,2,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',3900.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(439,7562,40740,4624,2,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',7900.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(440,7562,40740,4624,2,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',9000.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL);
INSERT INTO `balance_libro` VALUES (441,7562,40740,4624,2,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',10000.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(442,7562,40740,4624,2,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',5280.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(443,7562,40740,4624,2,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',12000.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(444,7562,40740,4624,2,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',15830.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(445,7562,40740,4624,2,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',20000.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(446,7562,40740,4624,2,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',8000.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(447,7562,40740,4624,2,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',3500.00,NULL,NULL,1,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(448,7562,40740,4624,3,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',3694.84,NULL,NULL,1,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(449,7562,40740,4624,3,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',8280.26,NULL,NULL,1,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(450,7562,40740,4624,3,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',16560.52,NULL,NULL,1,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(451,7562,40740,4624,3,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',4583.48,NULL,NULL,1,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(452,7562,40740,4624,3,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',9286.06,NULL,NULL,1,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(453,7562,40740,4624,3,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',484.00,NULL,NULL,1,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(454,7562,40740,4624,3,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',33861.20,NULL,NULL,1,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(455,7562,40740,4624,3,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',5965.01,NULL,NULL,1,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(456,7562,40740,4624,3,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',7637.52,NULL,NULL,1,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(457,7562,40740,4624,3,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',6332.94,NULL,NULL,1,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(458,7562,40740,4624,3,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',312966.50,NULL,NULL,1,'2023-05-17 13:33:22','2023-05-17 13:33:22',NULL),(459,7562,40721,3052,3,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1000.00,NULL,NULL,1,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(460,7562,40721,3052,3,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',4627.61,NULL,NULL,1,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(461,7562,40721,3052,3,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',6041.19,NULL,NULL,1,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(462,7562,40721,3052,3,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',11187.19,NULL,NULL,1,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(463,7562,40721,3052,3,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',10269.53,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(464,7562,40721,3052,3,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',170000.00,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(465,7562,40721,3052,3,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',3366.09,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL);
INSERT INTO `balance_libro` VALUES (466,7562,40721,3052,3,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',33180.21,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(467,7562,40721,3052,3,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',12950.00,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(468,7562,40721,3052,3,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',14647.67,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(469,7562,40721,3052,3,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',5610.14,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(470,7562,40721,3052,3,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',10050.01,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(471,7562,40721,3052,3,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',2243.93,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(472,7562,40721,3052,3,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',15047.73,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(473,7562,40721,3052,3,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',2583.92,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(474,7562,40721,3052,3,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',2243.93,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(475,7562,40721,3052,3,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',4786.27,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(476,7562,40721,3052,3,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',5593.56,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(477,7562,40721,3052,3,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',3729.49,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(478,7562,40721,3052,3,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',932.37,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(479,7562,40721,3052,3,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',3000.00,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(480,7562,40721,3052,3,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',3356.33,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(481,7562,40721,3052,3,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',4622.96,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(482,7562,40721,3052,3,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',2500.00,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(483,7562,40721,3052,3,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',4786.61,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(484,7562,40721,3052,3,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',3026.44,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(485,7562,40721,3052,3,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',756.61,NULL,NULL,1,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(486,7562,40719,4,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',66000.00,'Aporte de capital',NULL,1,'2023-05-29 16:14:33','2023-05-29 16:14:33',NULL),(487,7562,40719,8,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1450.00,'Ventas - 2022 06',NULL,1,'2023-05-29 16:16:26','2023-05-29 16:16:26',NULL),(488,7562,40719,9,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3400.01,'Ventas - 2022 07',NULL,1,'2023-05-29 16:18:00','2023-05-29 16:18:00',NULL),(489,7562,40719,10,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',7000.00,'Ventas - 2022 08',NULL,1,'2023-05-29 16:18:35','2023-05-29 16:18:35',NULL);
INSERT INTO `balance_libro` VALUES (490,7562,40719,11,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',152900.06,'Ventas - 2022 09',NULL,1,'2023-05-29 16:19:46','2023-05-29 16:19:46',NULL),(491,7562,40719,12,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',100500.19,'Ventas - 2022 10',NULL,1,'2023-05-29 16:22:02','2023-05-29 16:22:02',NULL),(492,7562,40719,13,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',12100.03,'Ventas - 2022 11',NULL,1,'2023-05-29 16:23:28','2023-05-29 16:23:28',NULL),(493,7562,40719,14,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',191180.00,'Ventas - 2022 12',NULL,1,'2023-05-29 16:24:42','2023-05-29 16:24:42',NULL),(494,7562,40719,5,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',250701.47,'Compras - 2022-03',NULL,1,'2023-05-29 16:26:49','2023-05-29 16:26:49',NULL),(495,7562,40719,6,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',416813.91,'Compras - 2022-04',NULL,1,'2023-05-29 16:28:13','2023-05-29 16:28:13',NULL),(496,7562,40719,7,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',102097.99,'Compras - 2022-05',NULL,1,'2023-05-29 16:29:16','2023-05-29 16:29:16',NULL),(497,7562,40719,8,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',64299.99,'Compras - 2022-06',NULL,1,'2023-05-29 16:30:13','2023-05-29 16:30:13',NULL),(498,7562,40719,9,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',166993.90,'Compras - 2022-07',NULL,1,'2023-05-29 16:31:08','2023-05-29 16:31:08',NULL),(499,7562,40719,10,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',71809.13,'Compras - 2022-08',NULL,1,'2023-05-29 16:31:54','2023-05-29 16:31:54',NULL),(500,7562,40719,11,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',14809.33,'Compras - 2022-09',NULL,1,'2023-05-29 16:32:58','2023-05-29 16:32:58',NULL),(501,7562,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',94381.99,'Compras - 2022-10',NULL,1,'2023-05-29 16:33:58','2023-05-29 16:33:58',NULL),(502,7562,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',75345.16,'Compras - 2022-11',NULL,1,'2023-05-29 16:34:56','2023-05-29 16:34:56',NULL),(503,7562,40719,14,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',116300.27,'Compras - 2022-12',NULL,1,'2023-05-29 16:36:42','2023-05-29 16:36:42',NULL),(504,7562,40719,14,10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',91344.87,'IVA del ejericio',NULL,1,'2023-05-29 16:49:11','2023-05-29 16:49:11',NULL),(505,7562,40719,5,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',592.00,'IIBB - 2022-03',NULL,1,'2023-05-29 16:50:29','2023-05-29 16:50:29',NULL),(506,7562,40719,6,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',592.00,'IIBB - 2022-04',NULL,1,'2023-05-29 16:51:10','2023-05-29 16:51:10',NULL),(507,7562,40719,7,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',592.00,'IIBB - 2022-05',NULL,1,'2023-05-29 16:51:56','2023-05-29 16:51:56',NULL),(508,7562,40719,8,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',592.00,'IIBB - 2022-06',NULL,1,'2023-05-29 16:52:41','2023-05-29 16:52:41',NULL),(509,7562,40719,9,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',592.00,'IIBB - 2022-07',NULL,1,'2023-05-29 16:53:53','2023-05-29 16:53:53',NULL),(510,7562,40719,10,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',592.00,'IIBB - 2022-08',NULL,1,'2023-05-29 16:54:32','2023-05-29 16:54:32',NULL),(511,7562,40719,11,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',5055.24,'IIBB - 2022-09',NULL,1,'2023-05-29 16:55:36','2023-05-29 16:55:36',NULL),(512,7562,40719,12,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3301.74,'IIBB - 2022-10',NULL,1,'2023-05-29 16:56:20','2023-05-29 16:56:20',NULL);
INSERT INTO `balance_libro` VALUES (513,7562,40719,13,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',592.00,'IIBB - 2022-11',NULL,1,'2023-05-29 16:57:17','2023-05-29 16:57:17',NULL),(514,7562,40719,14,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6422.05,'IIBB - 2022-12',NULL,1,'2023-05-29 16:58:00','2023-05-29 16:58:00',NULL),(515,7562,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',49500.00,'Aporte de capital',NULL,1,'2023-05-29 17:01:31','2023-05-29 17:13:43','2023-05-29 17:13:43'),(516,7562,40719,14,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1530248.98,'Pago a Proveedores',NULL,1,'2023-05-29 17:05:23','2023-05-29 17:12:25','2023-05-29 17:12:25'),(517,7562,40719,14,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',534333.65,'Pago a Proveedores',NULL,1,'2023-05-29 17:12:25','2023-05-29 17:16:22','2023-05-29 17:16:22'),(518,7562,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',49500.00,'Aporte de capital',NULL,1,'2023-05-29 17:13:43','2023-05-29 17:13:43',NULL),(519,7562,40719,14,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1334333.65,'Pago a Proveedores',NULL,1,'2023-05-29 17:16:22','2023-05-29 17:16:22',NULL),(520,7562,40719,14,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',544628.36,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-06-08 13:52:50','2023-06-08 13:52:50',NULL),(521,7562,40719,14,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1823949.28,'Reclasificacion de gastos',NULL,1,'2023-06-08 14:22:32','2023-06-08 14:22:32',NULL),(522,7562,40719,14,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',470000.00,'Reclasificacion socios cuenta corriente',NULL,1,'2023-06-08 17:00:09','2023-06-08 17:00:09',NULL),(523,7562,40740,4625,2,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',2800.00,NULL,NULL,1,'2023-06-12 15:18:11','2023-06-12 15:18:11',NULL),(524,7562,40740,4625,2,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',12000.00,NULL,NULL,1,'2023-06-12 15:18:11','2023-06-12 15:18:11',NULL),(525,7562,40740,4625,2,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',7930.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(526,7562,40740,4625,2,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',13800.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(527,7562,40740,4625,2,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',9000.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(528,7562,40740,4625,2,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',11500.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(529,7562,40740,4625,2,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',4900.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(530,7562,40740,4625,2,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',11270.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(531,7562,40740,4625,2,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',4900.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(532,7562,40740,4625,2,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',6900.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(533,7562,40740,4625,2,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',26000.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(534,7562,40740,4625,2,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',6900.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(535,7562,40740,4625,2,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',11500.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL);
INSERT INTO `balance_libro` VALUES (536,7562,40740,4625,2,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',10000.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(537,7562,40740,4625,2,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',6900.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(538,7562,40740,4625,2,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',6900.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(539,7562,40740,4625,2,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-06','2023-05-06',5750.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(540,7562,40740,4625,2,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',6900.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(541,7562,40740,4625,2,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',20700.00,NULL,NULL,1,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(542,7562,40740,4625,2,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',7900.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(543,7562,40740,4625,2,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',7900.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(544,7562,40740,4625,2,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',3800.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(545,7562,40740,4625,2,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',13400.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(546,7562,40740,4625,2,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',8900.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(547,7562,40740,4625,2,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-10','2023-05-10',7900.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(548,7562,40740,4625,2,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',3700.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(549,7562,40740,4625,2,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',3200.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(550,7562,40740,4625,2,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',6900.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(551,7562,40740,4625,2,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',8900.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(552,7562,40740,4625,2,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',12000.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(553,7562,40740,4625,2,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',10000.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(554,7562,40740,4625,2,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',6900.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(555,7562,40740,4625,2,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',8900.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(556,7562,40740,4625,2,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-13','2023-05-13',8000.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(557,7562,40740,4625,2,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',5000.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(558,7562,40740,4625,2,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',7900.00,NULL,NULL,1,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(559,7562,40740,4625,2,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',5900.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(560,7562,40740,4625,2,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',10000.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL);
INSERT INTO `balance_libro` VALUES (561,7562,40740,4625,2,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',4700.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(562,7562,40740,4625,2,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',27000.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(563,7562,40740,4625,2,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',5800.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(564,7562,40740,4625,2,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',28750.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(565,7562,40740,4625,2,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',6500.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(566,7562,40740,4625,2,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',9900.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(567,7562,40740,4625,2,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',10000.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(568,7562,40740,4625,2,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',10000.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(569,7562,40740,4625,2,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',23040.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(570,7562,40740,4625,2,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',10000.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(571,7562,40740,4625,2,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',4000.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(572,7562,40740,4625,2,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',7900.00,NULL,NULL,1,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(573,7562,40740,4625,2,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',5700.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(574,7562,40740,4625,2,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',19200.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(575,7562,40740,4625,2,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',7000.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(576,7562,40740,4625,2,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',6240.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(577,7562,40740,4625,2,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',5900.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(578,7562,40740,4625,2,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',44280.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(579,7562,40740,4625,2,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',6900.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(580,7562,40740,4625,2,378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',10000.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(581,7562,40740,4625,2,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',9200.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(582,7562,40740,4625,2,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',9480.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(583,7562,40740,4625,2,381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',13200.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(584,7562,40740,4625,2,382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',4200.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(585,7562,40740,4625,2,383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',15000.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL);
INSERT INTO `balance_libro` VALUES (586,7562,40740,4625,2,384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',36000.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(587,7562,40740,4625,2,385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',6000.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(588,7562,40740,4625,2,386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',9900.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(589,7562,40740,4625,2,387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',4000.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(590,7562,40740,4625,2,388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',15600.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(591,7562,40740,4625,2,389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',2000.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(592,7562,40740,4625,2,390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',5900.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(593,7562,40740,4625,2,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',15600.00,NULL,NULL,1,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(594,7562,40740,4625,2,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',7200.00,NULL,NULL,1,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(595,7562,40740,4625,2,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',1700.00,NULL,NULL,1,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(596,7562,40740,4625,2,394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',6500.00,NULL,NULL,1,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(597,7562,40740,4625,2,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',5000.00,NULL,NULL,1,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(598,7562,40740,4625,2,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',8900.00,NULL,NULL,1,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(599,7562,40740,4625,3,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-01','2023-05-01',15900.00,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:26:39','2023-06-12 15:26:39'),(600,7562,40740,4625,3,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',99617.36,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(601,7562,40740,4625,3,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',150.00,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(602,7562,40740,4625,3,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',12696.17,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(603,7562,40740,4625,3,401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',5336.10,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(604,7562,40740,4625,3,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',4100.00,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(605,7562,40740,4625,3,403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',8992.36,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(606,7562,40740,4625,3,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',14002.12,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(607,7562,40740,4625,3,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',8992.36,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(608,7562,40740,4625,3,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',13036.54,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(609,7562,40740,4625,3,407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',26977.07,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(610,7562,40740,4625,3,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',26977.07,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL);
INSERT INTO `balance_libro` VALUES (611,7562,40740,4625,3,409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',26977.07,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(612,7562,40740,4625,3,410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',6860.01,NULL,NULL,1,'2023-06-12 15:18:46','2023-06-12 15:26:21','2023-06-12 15:26:21'),(613,7562,40740,4625,3,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',5300.00,NULL,NULL,1,'2023-06-12 15:18:47','2023-06-12 15:26:13','2023-06-12 15:26:13'),(614,7562,40740,4625,3,412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',6860.01,NULL,NULL,1,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(615,7562,40740,4625,3,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',6820.57,NULL,NULL,1,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(616,7562,40740,4625,3,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',903.76,NULL,NULL,1,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(617,7562,40740,4625,3,415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',8810.00,NULL,NULL,1,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(618,7562,40740,4625,3,416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',10000.05,NULL,NULL,1,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(619,7562,40740,4625,3,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',80586.00,NULL,NULL,1,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(620,7562,40740,4625,3,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',380278.80,NULL,NULL,1,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(621,7562,40740,4625,3,419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',94089.60,NULL,NULL,1,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(622,7562,40740,4625,3,420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',219832.80,NULL,NULL,1,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(623,7562,40740,4625,3,421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',8512.14,NULL,NULL,1,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(624,7562,40720,1541,3,422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',15063.90,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(625,7562,40720,1541,3,423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',169382.92,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(626,7562,40720,1541,3,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-03','2023-05-03',11500.00,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(627,7562,40720,1541,3,425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',9158.70,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(628,7562,40720,1541,3,426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',17251.84,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(629,7562,40720,1541,3,427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',5260.16,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(630,7562,40720,1541,3,428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',11419.64,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(631,7562,40720,1541,3,429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',12573.55,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(632,7562,40720,1541,3,430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',54263.36,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(633,7562,40720,1541,3,431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',8770.08,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(634,7562,40720,1541,3,432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',14334.60,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL);
INSERT INTO `balance_libro` VALUES (635,7562,40720,1541,3,433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-15','2023-05-15',12815.79,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(636,7562,40720,1541,3,434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',46606.88,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(637,7562,40720,1541,3,435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',3363.93,NULL,NULL,1,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(638,7562,40720,1541,3,436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',10769.10,NULL,NULL,1,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(639,7562,40720,1541,3,437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',25000.00,NULL,NULL,1,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(640,7562,40720,1541,3,438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-29','2023-05-29',10761.14,NULL,NULL,1,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(641,7562,40720,1541,3,439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',15080.41,NULL,NULL,1,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(646,7562,40720,1541,2,444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-04','2023-05-04',5368.00,NULL,NULL,1,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(647,7562,40720,1541,2,445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',1800.00,NULL,NULL,1,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(648,7562,40720,1541,2,446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',10000.00,NULL,NULL,1,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(649,7562,40720,1541,2,447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',5885.00,NULL,NULL,1,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(650,7562,40720,1541,2,448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',3155.00,NULL,NULL,1,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(651,7562,40720,1541,2,449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-31','2023-05-31',1834268.50,NULL,NULL,1,'2023-06-13 09:11:53','2023-06-13 09:11:53',NULL),(652,7562,40721,3053,3,450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',2200.00,NULL,NULL,1,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(653,7562,40721,3053,3,451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',5000.00,NULL,NULL,1,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(654,7562,40721,3053,3,452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',1180.00,NULL,NULL,1,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(655,7562,40721,3053,3,453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',7260.99,NULL,NULL,1,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(656,7562,40721,3053,3,454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',802.11,NULL,NULL,1,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(657,7562,40721,3053,3,455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-24','2023-05-24',220.22,NULL,NULL,1,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(660,7562,40721,3053,3,458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-05','2023-05-05',3356.17,NULL,NULL,1,'2023-06-13 13:11:32','2023-06-13 13:11:32',NULL),(661,7562,40721,3053,3,459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-07','2023-05-07',5593.56,NULL,NULL,1,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(662,7562,40721,3053,3,460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-08','2023-05-08',5593.56,NULL,NULL,1,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(663,7562,40721,3053,3,461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-09','2023-05-09',7663.02,NULL,NULL,1,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(664,7562,40721,3053,3,462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-16','2023-05-16',3348.81,NULL,NULL,1,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(665,7562,40721,3053,3,463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-19','2023-05-19',4444.31,NULL,NULL,1,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL);
INSERT INTO `balance_libro` VALUES (666,7562,40721,3053,3,464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-20','2023-05-20',3333.43,NULL,NULL,1,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(667,7562,40721,3053,3,465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-23','2023-05-23',11111.03,NULL,NULL,1,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(668,7562,40778,7664,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-01','2020-08-01',122261.72,'Asiento de apertura',NULL,1,'2023-06-13 16:16:05','2023-06-13 16:16:05',NULL),(669,7562,40778,7664,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-08-31','2020-08-31',4100.00,'Pago de cuotas',NULL,1,'2023-06-13 16:38:12','2023-06-13 16:38:12',NULL),(670,7562,40778,7665,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-09-30','2020-09-30',4100.00,'Pago de cuotas',NULL,1,'2023-06-13 16:38:54','2023-06-13 16:38:54',NULL),(671,7562,40778,7666,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-10-31','2020-10-31',4100.00,'Pago de cuotas',NULL,1,'2023-06-13 16:39:31','2023-06-13 16:39:31',NULL),(672,7562,40778,7667,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-30','2020-11-30',4000.00,'Pago de cuotas',NULL,1,'2023-06-13 16:40:09','2023-06-13 16:40:09',NULL),(673,7562,40778,7668,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-12-31','2020-12-31',18678.00,'pago de cuotas y gastos',NULL,1,'2023-06-13 16:44:30','2023-06-13 16:44:30',NULL),(674,7562,40778,7670,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31','2021-01-31',3800.00,'Pago de cuotas',NULL,1,'2023-06-13 16:45:02','2023-06-13 16:45:02',NULL),(675,7562,40778,7671,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-28','2021-02-28',3700.00,'Pago de cuotas',NULL,1,'2023-06-13 16:45:37','2023-06-13 16:45:37',NULL),(676,7562,40778,7672,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',5450.00,'Pago de cuotas',NULL,1,'2023-06-13 16:46:15','2023-06-13 16:46:15',NULL),(677,7562,40778,7673,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',5550.00,'Pago de cuotas',NULL,1,'2023-06-13 16:46:51','2023-06-13 16:46:51',NULL),(678,7562,40778,7674,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',5400.00,'Pago de cuotas',NULL,1,'2023-06-13 16:47:34','2023-06-13 16:47:34',NULL),(679,7562,40778,7675,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',5400.00,'Pago de cuotas',NULL,1,'2023-06-13 16:48:06','2023-06-13 16:48:06',NULL),(680,7562,40778,7676,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',5350.00,'Pago de cuotas',NULL,1,'2023-06-13 16:48:40','2023-06-13 16:48:40',NULL),(681,7562,40778,7676,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',23044.09,'Plazo fijo Al cierre',NULL,1,'2023-06-23 12:54:42','2023-06-23 12:54:42',NULL),(682,7562,40778,7676,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2250.00,'Arqueo caja',NULL,1,'2023-06-23 13:46:59','2023-06-23 13:46:59',NULL),(683,7562,40778,7676,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',68641.83,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-06-23 13:49:32','2023-06-23 13:49:32',NULL),(684,7562,40778,7677,19,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',185577.81,'Asiento de apertura',NULL,1,'2023-06-23 15:19:06','2023-06-23 15:19:06',NULL),(685,7562,40778,7677,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31','2021-08-31',5300.00,'Cuotas - 2021 08',NULL,1,'2023-06-23 15:20:20','2023-06-23 15:20:20',NULL),(686,7562,40778,7678,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',5200.00,'Cuotas - 2021 09',NULL,1,'2023-06-23 15:20:59','2023-06-23 15:20:59',NULL),(687,7562,40778,7679,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',5100.00,'Cuotas - 2021 10',NULL,1,'2023-06-23 15:21:34','2023-06-23 15:21:34',NULL),(688,7562,40778,7680,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',4800.00,'Cuotas - 2021 11',NULL,1,'2023-06-23 15:22:37','2023-06-23 15:22:37',NULL);
INSERT INTO `balance_libro` VALUES (689,7562,40778,7681,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',4700.00,'Cuotas - 2021 12',NULL,1,'2023-06-23 15:23:12','2023-06-23 15:23:12',NULL),(690,7562,40778,7685,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',6400.00,'Cuotas - 2022 01',NULL,1,'2023-06-23 15:23:54','2023-06-23 15:23:54',NULL),(691,7562,40778,7686,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',6400.00,'Cuotas - 2022 02',NULL,1,'2023-06-23 15:24:30','2023-06-23 15:24:30',NULL),(692,7562,40778,7687,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',6150.00,'Cuotas - 2022 03',NULL,1,'2023-06-23 15:25:40','2023-06-23 15:25:40',NULL),(693,7562,40778,7688,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',6150.00,'Cuotas - 2022 04',NULL,1,'2023-06-23 15:26:12','2023-06-23 15:26:12',NULL),(694,7562,40778,7689,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',7950.00,'Cuotas - 2022 05',NULL,1,'2023-06-23 15:26:43','2023-06-23 15:26:43',NULL),(695,7562,40778,7690,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',7750.00,'Cuotas - 2022 06',NULL,1,'2023-06-23 15:27:14','2023-06-23 15:27:14',NULL),(696,7562,40778,7691,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',7050.00,'Cuotas - 2022 07',NULL,1,'2023-06-23 15:27:54','2023-06-23 15:27:54',NULL),(697,7562,40778,7681,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',27860.00,'Gastos del Ejercicio',NULL,1,'2023-06-23 15:45:39','2023-06-23 15:45:39',NULL),(698,7562,40778,7691,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',31962.55,'Plazo fijo Al cierre',NULL,1,'2023-06-23 15:47:35','2023-06-23 15:47:35',NULL),(699,7562,40778,7691,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',145141.61,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-06-23 16:02:42','2023-06-23 16:02:42',NULL),(700,7562,40720,1542,2,466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',10766.00,NULL,NULL,1,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(701,7562,40720,1542,2,467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',3000.00,NULL,NULL,1,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(702,7562,40720,1542,2,468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',4800.00,NULL,NULL,1,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(703,7562,40720,1542,2,469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',1768464.00,NULL,NULL,1,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(704,7562,40720,1542,2,470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',4800.00,NULL,NULL,1,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(705,7562,40720,1542,3,471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',147054.11,NULL,NULL,1,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(706,7562,40720,1542,3,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',10727.52,NULL,NULL,1,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(707,7562,40720,1542,3,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',55802.86,NULL,NULL,1,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(708,7562,40720,1542,3,474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',30000.00,NULL,NULL,1,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(709,7562,40720,1542,3,475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',9394.44,NULL,NULL,1,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(710,7562,40720,1542,3,476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',7453.14,NULL,NULL,1,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(711,7562,40720,1542,3,477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',12063.89,NULL,NULL,1,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL);
INSERT INTO `balance_libro` VALUES (712,7562,40720,1542,3,478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',24917.06,NULL,NULL,1,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(713,7562,40720,1542,3,479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',16082.52,NULL,NULL,1,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(714,7562,40720,1542,3,480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',27798.07,NULL,NULL,1,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(715,7562,40720,1542,3,481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',23163.39,NULL,NULL,1,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(716,7562,40720,1542,3,482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',2499.99,NULL,NULL,1,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(717,7562,40720,1542,3,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',34370.62,NULL,NULL,1,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(718,7562,40720,1542,3,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',11349.53,NULL,NULL,1,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(719,7562,40740,4626,2,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',13440.00,NULL,NULL,1,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(720,7562,40740,4626,2,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',12000.00,NULL,NULL,1,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(721,7562,40740,4626,2,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',21600.00,NULL,NULL,1,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(722,7562,40740,4626,2,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',11880.00,NULL,NULL,1,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(723,7562,40740,4626,2,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',5900.00,NULL,NULL,1,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(724,7562,40740,4626,2,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',13000.00,NULL,NULL,1,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(725,7562,40740,4626,2,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',6600.00,NULL,NULL,1,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(726,7562,40740,4626,2,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',10800.00,NULL,NULL,1,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(727,7562,40740,4626,2,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',4300.00,NULL,NULL,1,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(728,7562,40740,4626,2,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',24800.00,NULL,NULL,1,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(729,7562,40740,4626,2,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',5700.00,NULL,NULL,1,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(730,7562,40740,4626,2,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',1200.00,NULL,NULL,1,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(731,7562,40740,4626,2,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',10000.00,NULL,NULL,1,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(732,7562,40740,4626,2,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',12000.00,NULL,NULL,1,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(733,7562,40740,4626,2,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',8900.00,NULL,NULL,1,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(734,7562,40740,4626,2,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',14000.00,NULL,NULL,1,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(735,7562,40740,4626,2,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',10800.00,NULL,NULL,1,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(736,7562,40740,4626,2,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',19200.00,NULL,NULL,1,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL);
INSERT INTO `balance_libro` VALUES (737,7562,40740,4626,2,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-07','2023-06-07',19080.00,NULL,NULL,1,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(738,7562,40740,4626,2,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',7400.00,NULL,NULL,1,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(739,7562,40740,4626,2,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',8900.00,NULL,NULL,1,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(740,7562,40740,4626,2,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',8900.00,NULL,NULL,1,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(741,7562,40740,4626,2,507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',10000.00,NULL,NULL,1,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(742,7562,40740,4626,2,508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',13800.00,NULL,NULL,1,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(743,7562,40740,4626,2,509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',5900.00,NULL,NULL,1,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(744,7562,40740,4626,2,510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',7400.00,NULL,NULL,1,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(745,7562,40740,4626,2,511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',10000.00,NULL,NULL,1,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(746,7562,40740,4626,2,512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',10000.00,NULL,NULL,1,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(747,7562,40740,4626,2,513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',10000.00,NULL,NULL,1,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(748,7562,40740,4626,2,514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',5500.00,NULL,NULL,1,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(749,7562,40740,4626,2,515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-08','2023-06-08',5000.00,NULL,NULL,1,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(750,7562,40740,4626,2,516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',6900.00,NULL,NULL,1,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(751,7562,40740,4626,2,517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',9000.00,NULL,NULL,1,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(752,7562,40740,4626,2,518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',9000.00,NULL,NULL,1,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(753,7562,40740,4626,2,519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',22600.00,NULL,NULL,1,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(754,7562,40740,4626,2,520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',11800.00,NULL,NULL,1,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(755,7562,40740,4626,2,521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',8280.00,NULL,NULL,1,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(756,7562,40740,4626,2,522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',8280.00,NULL,NULL,1,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(757,7562,40740,4626,2,523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',6900.00,NULL,NULL,1,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(758,7562,40740,4626,2,524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',5300.00,NULL,NULL,1,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(759,7562,40740,4626,2,525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',5000.00,NULL,NULL,1,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(760,7562,40740,4626,2,526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',9900.00,NULL,NULL,1,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(761,7562,40740,4626,2,527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',22600.00,NULL,NULL,1,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL);
INSERT INTO `balance_libro` VALUES (762,7562,40740,4626,2,528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',11800.00,NULL,NULL,1,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(763,7562,40740,4626,2,529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',7900.00,NULL,NULL,1,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(764,7562,40740,4626,2,530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',7900.00,NULL,NULL,1,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(765,7562,40740,4626,2,531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',8900.00,NULL,NULL,1,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(766,7562,40740,4626,2,532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',8900.00,NULL,NULL,1,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(767,7562,40740,4626,2,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',7900.00,NULL,NULL,1,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(768,7562,40740,4626,2,534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',2000.00,NULL,NULL,1,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(769,7562,40740,4626,2,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',6500.00,NULL,NULL,1,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(770,7562,40740,4626,2,536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',29880.00,NULL,NULL,1,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(771,7562,40740,4626,2,537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',16080.00,NULL,NULL,1,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(772,7562,40740,4626,2,538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',9600.00,NULL,NULL,1,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(773,7562,40740,4626,2,539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',9000.00,NULL,NULL,1,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(774,7562,40740,4626,2,540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',7000.00,NULL,NULL,1,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(775,7562,40740,4626,2,541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',7900.00,NULL,NULL,1,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(776,7562,40740,4626,2,542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',13800.00,NULL,NULL,1,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(777,7562,40740,4626,2,543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',6000.00,NULL,NULL,1,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(778,7562,40740,4626,2,544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',8280.00,NULL,NULL,1,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(779,7562,40740,4626,2,545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-14','2023-06-14',10800.00,NULL,NULL,1,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(780,7562,40740,4626,2,546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',13600.00,NULL,NULL,1,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(781,7562,40740,4626,2,547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',33600.00,NULL,NULL,1,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(782,7562,40740,4626,2,548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',21600.00,NULL,NULL,1,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(783,7562,40740,4626,2,549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',2900.00,NULL,NULL,1,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(784,7562,40740,4626,2,550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',23000.00,NULL,NULL,1,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(785,7562,40740,4626,2,551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',21600.00,NULL,NULL,1,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(786,7562,40740,4626,2,552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',7500.00,NULL,NULL,1,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL);
INSERT INTO `balance_libro` VALUES (787,7562,40740,4626,2,553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',28000.00,NULL,NULL,1,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(788,7562,40740,4626,2,554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',12000.00,NULL,NULL,1,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(789,7562,40740,4626,2,555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',1700.00,NULL,NULL,1,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(790,7562,40740,4626,2,556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',3600.00,NULL,NULL,1,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(791,7562,40740,4626,2,557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',7900.00,NULL,NULL,1,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(792,7562,40740,4626,2,558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',32760.00,NULL,NULL,1,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(793,7562,40740,4626,2,559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',30000.00,NULL,NULL,1,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(794,7562,40740,4626,2,560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',10000.00,NULL,NULL,1,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(795,7562,40740,4626,2,561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-17','2023-06-17',25000.00,NULL,NULL,1,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(796,7562,40740,4626,2,562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',7200.00,NULL,NULL,1,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(797,7562,40740,4626,2,563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',13560.00,NULL,NULL,1,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(798,7562,40740,4626,2,564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',9600.00,NULL,NULL,1,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(799,7562,40740,4626,2,565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',2300.00,NULL,NULL,1,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(800,7562,40740,4626,2,566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',2300.00,NULL,NULL,1,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(801,7562,40740,4626,2,567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',11000.00,NULL,NULL,1,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(802,7562,40740,4626,2,568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',4900.00,NULL,NULL,1,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(803,7562,40740,4626,2,569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',10000.00,NULL,NULL,1,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(804,7562,40740,4626,2,570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',4900.00,NULL,NULL,1,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(805,7562,40740,4626,2,571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',5500.00,NULL,NULL,1,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(806,7562,40740,4626,2,572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',7080.00,NULL,NULL,1,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(807,7562,40740,4626,2,573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',6800.00,NULL,NULL,1,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(808,7562,40740,4626,2,574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',6900.00,NULL,NULL,1,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(809,7562,40740,4626,2,575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',30000.00,NULL,NULL,1,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(810,7562,40740,4626,2,576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',3600.00,NULL,NULL,1,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(811,7562,40740,4626,2,577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',12000.00,NULL,NULL,1,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL);
INSERT INTO `balance_libro` VALUES (812,7562,40740,4626,2,578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',4000.00,NULL,NULL,1,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(813,7562,40740,4626,2,579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',38280.00,NULL,NULL,1,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(814,7562,40740,4626,2,580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',11280.00,NULL,NULL,1,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(815,7562,40740,4626,2,581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',12000.00,NULL,NULL,1,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(816,7562,40740,4626,2,582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',6500.00,NULL,NULL,1,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(817,7562,40740,4626,2,583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',12200.00,NULL,NULL,1,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(818,7562,40740,4626,2,584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',10000.00,NULL,NULL,1,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(819,7562,40740,4626,2,585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',18800.00,NULL,NULL,1,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(820,7562,40740,4626,2,586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-23','2023-06-23',10500.00,NULL,NULL,1,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(821,7562,40740,4626,2,587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',10000.00,NULL,NULL,1,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(822,7562,40740,4626,2,588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',6900.00,NULL,NULL,1,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(823,7562,40740,4626,2,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',4200.00,NULL,NULL,1,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(824,7562,40740,4626,2,590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-24','2023-06-24',6400.00,NULL,NULL,1,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(825,7562,40740,4626,2,591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',10000.00,NULL,NULL,1,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(826,7562,40740,4626,2,592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',9000.00,NULL,NULL,1,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(827,7562,40740,4626,2,593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',4680.00,NULL,NULL,1,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(828,7562,40740,4626,2,594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',6500.00,NULL,NULL,1,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(829,7562,40740,4626,2,595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',10100.00,NULL,NULL,1,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(830,7562,40740,4626,2,596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',10000.00,NULL,NULL,1,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(831,7562,40740,4626,2,597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',20000.00,NULL,NULL,1,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(832,7562,40740,4626,2,598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',15000.00,NULL,NULL,1,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(833,7562,40740,4626,2,599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',13500.00,NULL,NULL,1,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(834,7562,40740,4626,2,600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',13500.00,NULL,NULL,1,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(835,7562,40740,4626,2,601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-28','2023-06-28',6900.00,NULL,NULL,1,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(836,7562,40740,4626,2,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',12000.00,NULL,NULL,1,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL);
INSERT INTO `balance_libro` VALUES (837,7562,40740,4626,2,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',7900.00,NULL,NULL,1,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(838,7562,40740,4626,2,604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',6900.00,NULL,NULL,1,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(839,7562,40740,4626,2,605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',7900.00,NULL,NULL,1,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(840,7562,40740,4626,2,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4900.00,NULL,NULL,1,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(841,7562,40740,4626,2,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',7900.00,NULL,NULL,1,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(842,7562,40740,4626,2,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',9900.00,NULL,NULL,1,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(843,7562,40740,4626,3,609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',6219.40,NULL,NULL,1,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(844,7562,40740,4626,3,610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',38859.85,NULL,NULL,1,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(845,7562,40740,4626,3,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-02','2023-06-02',9250.03,NULL,NULL,1,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(846,7562,40740,4626,3,612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',158631.00,NULL,NULL,1,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(847,7562,40740,4626,3,613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-13','2023-06-13',44870.60,NULL,NULL,1,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(848,7562,40740,4626,3,614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',2657.56,NULL,NULL,1,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(849,7562,40740,4626,3,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-22','2023-06-22',288.97,NULL,NULL,1,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(850,7562,40740,4626,3,616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',141570.00,NULL,NULL,1,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(851,7562,40740,4626,3,617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',7300.00,NULL,NULL,1,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(852,7562,40740,4626,3,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',3872.00,NULL,NULL,1,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(853,7562,40740,4626,3,619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',4687.54,NULL,NULL,1,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(854,7562,40740,4626,3,620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',6219.40,NULL,NULL,1,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(855,7562,40740,4626,3,621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',2831.40,NULL,NULL,1,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(856,7562,40740,4626,3,622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-30','2023-06-30',0.00,NULL,NULL,1,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(857,7562,40740,4626,3,623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',161.86,NULL,NULL,1,'2023-07-14 10:26:04','2023-07-14 10:31:48','2023-07-14 10:31:48'),(858,7562,40740,4626,3,624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',1.86,NULL,NULL,1,'2023-07-14 10:26:05','2023-07-14 10:31:41','2023-07-14 10:31:41'),(859,7562,40740,4626,3,625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-25','2023-06-25',105.34,NULL,NULL,1,'2023-07-14 10:26:05','2023-07-14 10:31:35','2023-07-14 10:31:35'),(860,7562,40740,4626,3,626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-06','2023-06-06',45099.99,NULL,NULL,1,'2023-07-14 10:26:05','2023-07-14 10:28:22','2023-07-14 10:28:22');
INSERT INTO `balance_libro` VALUES (861,7562,40740,4626,3,627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',17750.00,NULL,NULL,1,'2023-07-14 10:26:05','2023-07-14 10:28:14','2023-07-14 10:28:14'),(862,7562,40740,4626,3,628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',5740.01,NULL,NULL,1,'2023-07-14 10:26:05','2023-07-14 10:28:04','2023-07-14 10:28:04'),(863,7562,40740,4626,3,629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',7300.00,NULL,NULL,1,'2023-07-14 10:26:05','2023-07-14 10:27:57','2023-07-14 10:27:57'),(864,7562,40721,3054,3,630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',43500.04,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(865,7562,40721,3054,3,631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-03','2023-06-03',11461.43,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(866,7562,40721,3054,3,632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',3331.62,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(867,7562,40721,3054,3,633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',3313.17,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(868,7562,40721,3054,3,634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',10500.01,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(869,7562,40721,3054,3,635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',2450.00,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(870,7562,40721,3054,3,636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',13837.47,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(871,7562,40721,3054,3,637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-10','2023-06-10',3331.62,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(872,7562,40721,3054,3,638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',7855.83,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(873,7562,40721,3054,3,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',7798.45,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(874,7562,40721,3054,3,640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',3572.33,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(875,7562,40721,3054,3,641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',5726.68,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(876,7562,40721,3054,3,642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',15613.08,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(877,7562,40721,3054,3,643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-18','2023-06-18',7044.03,NULL,NULL,1,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(878,7562,40721,3054,3,644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',4430.34,NULL,NULL,1,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(879,7562,40720,1543,2,645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',5116.00,NULL,NULL,1,'2023-08-12 09:55:25','2023-08-12 09:55:25',NULL),(880,7562,40720,1543,2,646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',1715329.39,NULL,NULL,1,'2023-08-12 09:55:25','2023-08-12 09:55:25',NULL),(881,7562,40720,1543,3,647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',157865.52,NULL,NULL,1,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(882,7562,40720,1543,3,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',16244.73,NULL,NULL,1,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(883,7562,40720,1543,3,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',69467.68,NULL,NULL,1,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(884,7562,40720,1543,3,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',74402.27,NULL,NULL,1,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL);
INSERT INTO `balance_libro` VALUES (885,7562,40720,1543,3,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',19449.44,NULL,NULL,1,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(886,7562,40720,1543,3,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-09','2023-07-09',13206.85,NULL,NULL,1,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(887,7562,40720,1543,3,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',8644.40,NULL,NULL,1,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(888,7562,40720,1543,3,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',21495.66,NULL,NULL,1,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(889,7562,40720,1543,3,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',1957.54,NULL,NULL,1,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(890,7562,40720,1543,3,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',5565.82,NULL,NULL,1,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(891,7562,40720,1543,3,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',25628.70,NULL,NULL,1,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(892,7562,40720,1543,3,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',6961.43,NULL,NULL,1,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(893,7562,40720,1543,3,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',30000.00,NULL,NULL,1,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(894,7562,40720,1543,3,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',8398.24,NULL,NULL,1,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(895,7562,40721,3055,3,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',7044.03,NULL,NULL,1,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(896,7562,40721,3055,3,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',1428.92,NULL,NULL,1,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(897,7562,40721,3055,3,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',4417.43,NULL,NULL,1,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(898,7562,40721,3055,3,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',10680.67,NULL,NULL,1,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(899,7562,40721,3055,3,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',7850.04,NULL,NULL,1,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(900,7562,40721,3055,3,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',7115.67,NULL,NULL,1,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(901,7562,40721,3055,3,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',5499.28,NULL,NULL,1,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(902,7562,40721,3055,3,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',4500.00,NULL,NULL,1,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(903,7562,40721,3055,3,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',11312.03,NULL,NULL,1,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(904,7562,40721,3055,3,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',3000.00,NULL,NULL,1,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(905,7562,40721,3055,3,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',5132.24,NULL,NULL,1,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(906,7562,40721,3055,3,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',2000.00,NULL,NULL,1,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(907,7562,40721,3055,3,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',144699.99,NULL,NULL,1,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(908,7562,40721,3055,3,674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',89999.99,NULL,NULL,1,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(909,7562,40740,4627,2,675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',10000.00,NULL,NULL,1,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL);
INSERT INTO `balance_libro` VALUES (910,7562,40740,4627,2,676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',6900.00,NULL,NULL,1,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(911,7562,40740,4627,2,677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',31200.00,NULL,NULL,1,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(912,7562,40740,4627,2,678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',11000.00,NULL,NULL,1,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(913,7562,40740,4627,2,679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-01','2023-07-01',14000.00,NULL,NULL,1,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(914,7562,40740,4627,2,680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',14000.00,NULL,NULL,1,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(915,7562,40740,4627,2,681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',13000.00,NULL,NULL,1,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(916,7562,40740,4627,2,682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',14880.00,NULL,NULL,1,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(917,7562,40740,4627,2,683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',10000.00,NULL,NULL,1,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(918,7562,40740,4627,2,684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',4200.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(919,7562,40740,4627,2,685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',6900.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(920,7562,40740,4627,2,686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',8000.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(921,7562,40740,4627,2,687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-03','2023-07-03',6900.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(922,7562,40740,4627,2,688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',5200.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(923,7562,40740,4627,2,689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',8000.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(924,7562,40740,4627,2,690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',6900.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(925,7562,40740,4627,2,691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',6900.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(926,7562,40740,4627,2,692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',7900.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(927,7562,40740,4627,2,693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',8900.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(928,7562,40740,4627,2,694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',28900.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(929,7562,40740,4627,2,695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',9000.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(930,7562,40740,4627,2,696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',27000.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(931,7562,40740,4627,2,697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',8900.00,NULL,NULL,1,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(932,7562,40740,4627,2,698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-06','2023-07-06',20000.00,NULL,NULL,1,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(933,7562,40740,4627,2,699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',3200.00,NULL,NULL,1,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(934,7562,40740,4627,2,700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',6000.00,NULL,NULL,1,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL);
INSERT INTO `balance_libro` VALUES (935,7562,40740,4627,2,701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',6000.00,NULL,NULL,1,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(936,7562,40740,4627,2,702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',3900.00,NULL,NULL,1,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(937,7562,40740,4627,2,703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',15400.00,NULL,NULL,1,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(938,7562,40740,4627,2,704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',5200.00,NULL,NULL,1,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(939,7562,40740,4627,2,705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',4800.00,NULL,NULL,1,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(940,7562,40740,4627,2,706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',4800.00,NULL,NULL,1,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(941,7562,40740,4627,2,707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',10300.00,NULL,NULL,1,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(942,7562,40740,4627,2,708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',14000.00,NULL,NULL,1,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(943,7562,40740,4627,2,709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',5700.00,NULL,NULL,1,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(944,7562,40740,4627,2,710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-08','2023-07-08',12000.00,NULL,NULL,1,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(945,7562,40740,4627,2,711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',5300.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(946,7562,40740,4627,2,712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',700.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(947,7562,40740,4627,2,713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',30000.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(948,7562,40740,4627,2,714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',4800.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(949,7562,40740,4627,2,715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',15600.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(950,7562,40740,4627,2,716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',8900.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(951,7562,40740,4627,2,717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',4900.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(952,7562,40740,4627,2,718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',6000.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(953,7562,40740,4627,2,719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-11','2023-07-11',3400.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(954,7562,40740,4627,2,720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',3000.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(955,7562,40740,4627,2,721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',6900.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(956,7562,40740,4627,2,722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',6900.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(957,7562,40740,4627,2,723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',20800.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(958,7562,40740,4627,2,724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',12100.00,NULL,NULL,1,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(959,7562,40740,4627,2,725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',18400.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL);
INSERT INTO `balance_libro` VALUES (960,7562,40740,4627,2,726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',15000.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(961,7562,40740,4627,2,727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',21600.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(962,7562,40740,4627,2,728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',4300.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(963,7562,40740,4627,2,729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',6500.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(964,7562,40740,4627,2,730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',17800.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(965,7562,40740,4627,2,731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',9900.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(966,7562,40740,4627,2,732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',3500.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(967,7562,40740,4627,2,733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',10000.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(968,7562,40740,4627,2,734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',22500.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(969,7562,40740,4627,2,735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-15','2023-07-15',3900.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(970,7562,40740,4627,2,736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',5700.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(971,7562,40740,4627,2,737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',8900.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(972,7562,40740,4627,2,738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',4800.00,NULL,NULL,1,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(973,7562,40740,4627,2,739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',1500.00,NULL,NULL,1,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(974,7562,40740,4627,2,740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',11400.00,NULL,NULL,1,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(975,7562,40740,4627,2,741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',12000.00,NULL,NULL,1,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(976,7562,40740,4627,2,742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',21600.00,NULL,NULL,1,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(977,7562,40740,4627,2,743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',5000.00,NULL,NULL,1,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(978,7562,40740,4627,2,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',10000.00,NULL,NULL,1,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(979,7562,40740,4627,2,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',15000.00,NULL,NULL,1,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(980,7562,40740,4627,2,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',6900.00,NULL,NULL,1,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(981,7562,40740,4627,2,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',6900.00,NULL,NULL,1,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(982,7562,40740,4627,2,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',12000.00,NULL,NULL,1,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(983,7562,40740,4627,2,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-19','2023-07-19',15400.00,NULL,NULL,1,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(984,7562,40740,4627,2,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',10000.00,NULL,NULL,1,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL);
INSERT INTO `balance_libro` VALUES (985,7562,40740,4627,2,751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',15000.00,NULL,NULL,1,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(986,7562,40740,4627,2,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',15000.00,NULL,NULL,1,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(987,7562,40740,4627,2,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',50000.00,NULL,NULL,1,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(988,7562,40740,4627,2,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',6000.00,NULL,NULL,1,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(989,7562,40740,4627,2,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',1600.00,NULL,NULL,1,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(990,7562,40740,4627,2,756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',7800.00,NULL,NULL,1,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(991,7562,40740,4627,2,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',8000.00,NULL,NULL,1,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(992,7562,40740,4627,2,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',9000.00,NULL,NULL,1,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(993,7562,40740,4627,2,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',20000.00,NULL,NULL,1,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(994,7562,40740,4627,2,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',23000.00,NULL,NULL,1,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(995,7562,40740,4627,2,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-22','2023-07-22',9600.00,NULL,NULL,1,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(996,7562,40740,4627,2,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',15000.00,NULL,NULL,1,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(997,7562,40740,4627,2,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-24','2023-07-24',15525.00,NULL,NULL,1,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(998,7562,40740,4627,2,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',12960.00,NULL,NULL,1,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(999,7562,40740,4627,2,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',15300.00,NULL,NULL,1,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(1000,7562,40740,4627,2,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',5900.00,NULL,NULL,1,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(1001,7562,40740,4627,2,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',10000.00,NULL,NULL,1,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(1002,7562,40740,4627,2,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',5900.00,NULL,NULL,1,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(1003,7562,40740,4627,2,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',8280.00,NULL,NULL,1,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(1004,7562,40740,4627,2,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',4320.00,NULL,NULL,1,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(1005,7562,40740,4627,2,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',10000.00,NULL,NULL,1,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(1006,7562,40740,4627,2,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',5900.00,NULL,NULL,1,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(1007,7562,40740,4627,2,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',5100.00,NULL,NULL,1,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(1008,7562,40740,4627,2,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',5200.00,NULL,NULL,1,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(1009,7562,40740,4627,2,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',10000.00,NULL,NULL,1,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL);
INSERT INTO `balance_libro` VALUES (1010,7562,40740,4627,2,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',4000.00,NULL,NULL,1,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(1011,7562,40740,4627,2,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',11880.00,NULL,NULL,1,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(1012,7562,40740,4627,2,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',6000.00,NULL,NULL,1,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(1013,7562,40740,4627,2,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',10000.00,NULL,NULL,1,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(1014,7562,40740,4627,2,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',15000.00,NULL,NULL,1,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(1015,7562,40740,4627,2,781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',10000.00,NULL,NULL,1,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(1016,7562,40740,4627,2,782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-29','2023-07-29',5000.00,NULL,NULL,1,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(1017,7562,40740,4627,2,783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',12000.00,NULL,NULL,1,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(1018,7562,40740,4627,2,784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',10000.00,NULL,NULL,1,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(1019,7562,40740,4627,2,785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',15000.00,NULL,NULL,1,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(1020,7562,40740,4627,3,786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',27034.35,NULL,NULL,1,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(1021,7562,40740,4627,3,787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',49101.80,NULL,NULL,1,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(1022,7562,40740,4627,3,788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',15010.05,NULL,NULL,1,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(1023,7562,40740,4627,3,789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',194.00,NULL,NULL,1,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(1024,7562,40740,4627,3,790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-16','2023-07-16',194.00,NULL,NULL,1,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(1025,7562,40740,4627,3,791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-16','2023-07-16',194.00,NULL,NULL,1,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(1026,7562,40740,4627,3,792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-20','2023-07-20',141570.00,NULL,NULL,1,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(1027,7562,40740,4627,3,793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',7920.03,NULL,NULL,1,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(1028,7562,40740,4627,3,794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',7970.19,NULL,NULL,1,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(1029,7562,40740,4627,3,795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',12044.34,NULL,NULL,1,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(1030,7562,40740,4627,3,796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',11144.10,NULL,NULL,1,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(1031,7562,40740,4627,3,797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',16313.22,NULL,NULL,1,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(1032,7562,40740,4627,3,798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',10877.90,NULL,NULL,1,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(1033,7562,40740,4627,3,799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-26','2023-07-26',13402.01,NULL,NULL,1,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL);
INSERT INTO `balance_libro` VALUES (1034,7562,40740,4627,3,800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',33690.01,NULL,NULL,1,'2023-08-12 12:39:56','2023-08-12 12:39:56',NULL),(1035,7562,40740,4627,3,801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',10501.42,NULL,NULL,1,'2023-08-12 12:41:04','2023-08-12 12:41:04',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3659 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7562,1,40721,3051,3,250,1,1272.73,NULL,'2023-04-11 19:52:55','2023-04-11 19:52:55',NULL),(2,7562,1,40721,3051,3,68,1,267.27,NULL,'2023-04-11 19:52:55','2023-04-11 19:52:55',NULL),(3,7562,1,40721,3051,3,57,2,1540.00,NULL,'2023-04-11 19:52:55','2023-04-11 19:52:55',NULL),(4,7562,2,40721,3051,3,250,1,2613.96,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(5,7562,2,40721,3051,3,68,1,548.93,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(6,7562,2,40721,3051,3,57,2,3162.89,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(7,7562,3,40721,3051,3,250,1,1652.89,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(8,7562,3,40721,3051,3,68,1,347.11,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(9,7562,3,40721,3051,3,57,2,2000.00,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(10,7562,4,40721,3051,3,250,1,5330.00,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(11,7562,4,40721,3051,3,68,1,1119.30,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(12,7562,4,40721,3051,3,57,2,6449.30,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(13,7562,5,40721,3051,3,237,1,1513.27,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(14,7562,5,40721,3051,3,250,1,60530.99,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(15,7562,5,40721,3051,3,68,1,6355.75,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(16,7562,5,40721,3051,3,57,2,68400.01,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(17,7562,6,40721,3051,3,250,1,1818.18,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(18,7562,6,40721,3051,3,68,1,381.82,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(19,7562,6,40721,3051,3,57,2,2200.00,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(20,7562,7,40721,3051,3,237,1,1557.52,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(21,7562,7,40721,3051,3,250,1,62300.89,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(22,7562,7,40721,3051,3,68,1,6541.59,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(23,7562,7,40721,3051,3,57,2,70400.00,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(24,7562,8,40721,3051,3,250,1,1611.57,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(25,7562,8,40721,3051,3,68,1,338.43,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(26,7562,8,40721,3051,3,57,2,1950.00,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(27,7562,9,40721,3051,3,250,1,578.51,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(28,7562,9,40721,3051,3,68,1,121.49,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(29,7562,9,40721,3051,3,57,2,700.00,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(30,7562,10,40721,3051,3,217,1,743.80,NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(31,7562,10,40721,3051,3,68,1,156.20,NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(32,7562,10,40721,3051,3,57,2,900.00,NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(33,7562,11,40721,3051,3,217,1,11621.16,NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(34,7562,11,40721,3051,3,68,1,2440.44,NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(35,7562,11,40721,3051,3,217,1,939.58,NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(36,7562,11,40721,3051,3,57,2,15001.18,NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(37,7562,12,40721,3051,3,217,1,1392.38,NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(38,7562,12,40721,3051,3,68,1,292.40,NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(39,7562,12,40721,3051,3,217,1,315.22,NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(40,7562,12,40721,3051,3,57,2,2000.00,NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(41,7562,13,40721,3051,3,217,1,1546.76,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(42,7562,13,40721,3051,3,68,1,324.82,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(43,7562,13,40721,3051,3,217,1,128.41,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL);
INSERT INTO `balance_libro_details` VALUES (44,7562,13,40721,3051,3,57,2,1999.99,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(45,7562,14,40721,3051,3,217,1,2328.21,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(46,7562,14,40721,3051,3,68,1,488.92,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(47,7562,14,40721,3051,3,217,1,183.00,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(48,7562,14,40721,3051,3,57,2,3000.13,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(49,7562,15,40721,3051,3,217,1,3880.27,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(50,7562,15,40721,3051,3,68,1,814.86,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(51,7562,15,40721,3051,3,217,1,304.99,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(52,7562,15,40721,3051,3,57,2,5000.12,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(53,7562,16,40721,3051,3,217,1,2328.21,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(54,7562,16,40721,3051,3,68,1,488.92,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(55,7562,16,40721,3051,3,217,1,183.00,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(56,7562,16,40721,3051,3,57,2,3000.13,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(57,7562,17,40721,3051,3,217,1,3678.95,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(58,7562,17,40721,3051,3,68,1,772.58,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(59,7562,17,40721,3051,3,217,1,548.48,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(60,7562,17,40721,3051,3,57,2,5000.01,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(61,7562,18,40721,3051,3,217,1,3678.99,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(62,7562,18,40721,3051,3,68,1,772.59,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(63,7562,18,40721,3051,3,217,1,548.49,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(64,7562,18,40721,3051,3,57,2,5000.07,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(65,7562,19,40721,3051,3,217,1,3702.05,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(66,7562,19,40721,3051,3,68,1,777.43,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(67,7562,19,40721,3051,3,217,1,520.57,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(68,7562,19,40721,3051,3,57,2,5000.05,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(69,7562,20,40721,3051,3,217,1,4813.25,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(70,7562,20,40721,3051,3,68,1,1010.78,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(71,7562,20,40721,3051,3,217,1,676.04,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(72,7562,20,40721,3051,3,57,2,6500.07,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(73,7562,21,40720,1539,2,218,2,5350.00,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(74,7562,21,40720,1539,2,13,1,5350.00,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(75,7562,22,40720,1539,2,96,2,2504.14,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(76,7562,22,40720,1539,2,67,2,525.87,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(77,7562,22,40720,1539,2,218,2,0.01,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(78,7562,22,40720,1539,2,13,1,3030.02,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(79,7562,23,40720,1539,2,96,2,2479.33,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(80,7562,23,40720,1539,2,67,2,520.66,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(81,7562,23,40720,1539,2,218,2,0.01,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(82,7562,23,40720,1539,2,13,1,3000.00,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(83,7562,24,40720,1539,2,96,2,27272.71,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(84,7562,24,40720,1539,2,67,2,5727.27,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(85,7562,24,40720,1539,2,218,2,0.02,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(86,7562,24,40720,1539,2,13,1,33000.00,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL);
INSERT INTO `balance_libro_details` VALUES (87,7562,25,40720,1539,2,218,2,1209316.00,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(88,7562,25,40720,1539,2,96,2,122179.05,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(89,7562,25,40720,1539,2,67,2,12828.80,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(90,7562,25,40720,1539,2,13,1,1344323.85,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(91,7562,26,40720,1539,3,217,1,126383.19,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(92,7562,26,40720,1539,3,57,2,126383.19,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(93,7562,27,40720,1539,3,250,1,7112.00,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(94,7562,27,40720,1539,3,68,1,1493.52,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(95,7562,27,40720,1539,3,57,2,8605.52,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(96,7562,28,40720,1539,3,250,1,15859.68,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(97,7562,28,40720,1539,3,68,1,3330.53,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(98,7562,28,40720,1539,3,57,2,19190.21,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(99,7562,29,40720,1539,3,237,1,616.75,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(100,7562,29,40720,1539,3,220,1,327.17,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(101,7562,29,40720,1539,3,250,1,8186.30,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(102,7562,29,40720,1539,3,68,1,1719.12,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(103,7562,29,40720,1539,3,250,1,2719.24,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(104,7562,29,40720,1539,3,68,1,734.20,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(105,7562,29,40720,1539,3,57,2,14302.78,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(106,7562,30,40720,1539,3,250,1,16002.82,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(107,7562,30,40720,1539,3,68,1,3360.59,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(108,7562,30,40720,1539,3,57,2,19363.41,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(109,7562,31,40720,1539,3,250,1,45737.20,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(110,7562,31,40720,1539,3,57,2,45737.20,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(111,7562,32,40720,1539,3,250,1,20209.04,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(112,7562,32,40720,1539,3,68,1,4243.90,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(113,7562,32,40720,1539,3,57,2,24452.94,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(114,7562,33,40720,1539,3,250,1,7395.31,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(115,7562,33,40720,1539,3,68,1,1553.02,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(116,7562,33,40720,1539,3,57,2,8948.33,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(117,7562,34,40720,1539,3,221,2,102.93,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(118,7562,34,40720,1539,3,237,2,194.04,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(119,7562,34,40720,1539,3,250,2,2575.61,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(120,7562,34,40720,1539,3,67,2,540.88,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(121,7562,34,40720,1539,3,250,2,855.55,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(122,7562,34,40720,1539,3,67,2,231.00,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(123,7562,34,40720,1539,3,57,1,4500.01,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(124,7562,35,40720,1539,3,250,1,1621.92,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(125,7562,35,40720,1539,3,68,1,340.60,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(126,7562,35,40720,1539,3,57,2,1962.52,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(127,7562,36,40720,1539,3,250,1,165.29,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(128,7562,36,40720,1539,3,68,1,34.71,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL);
INSERT INTO `balance_libro_details` VALUES (129,7562,36,40720,1539,3,57,2,200.00,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(130,7562,37,40720,1539,3,250,1,24721.29,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(131,7562,37,40720,1539,3,68,1,5191.47,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(132,7562,37,40720,1539,3,57,2,29912.76,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(133,7562,38,40720,1539,3,250,1,9260.02,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(134,7562,38,40720,1539,3,68,1,1944.60,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(135,7562,38,40720,1539,3,57,2,11204.62,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(136,7562,39,40720,1539,3,250,1,8268.13,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(137,7562,39,40720,1539,3,68,1,1736.31,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(138,7562,39,40720,1539,3,57,2,10004.44,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(139,7562,40,40720,1539,3,250,1,2722.50,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(140,7562,40,40720,1539,3,68,1,571.73,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(141,7562,40,40720,1539,3,57,2,3294.23,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(142,7562,41,40720,1539,3,250,1,6096.26,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(143,7562,41,40720,1539,3,68,1,1280.21,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(144,7562,41,40720,1539,3,57,2,7376.47,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(145,7562,42,40740,4623,2,96,2,1652.89,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(146,7562,42,40740,4623,2,67,2,347.11,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(147,7562,42,40740,4623,2,13,1,2000.00,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(148,7562,43,40740,4623,2,96,2,2644.63,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(149,7562,43,40740,4623,2,67,2,555.37,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(150,7562,43,40740,4623,2,13,1,3200.00,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(151,7562,44,40740,4623,2,96,2,1900.83,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(152,7562,44,40740,4623,2,67,2,399.17,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(153,7562,44,40740,4623,2,13,1,2300.00,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(154,7562,45,40740,4623,2,96,2,3966.94,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(155,7562,45,40740,4623,2,67,2,833.06,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(156,7562,45,40740,4623,2,13,1,4800.00,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(157,7562,46,40740,4623,2,96,2,4276.86,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(158,7562,46,40740,4623,2,67,2,898.14,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(159,7562,46,40740,4623,2,13,1,5175.00,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(160,7562,47,40740,4623,2,96,2,4049.59,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(161,7562,47,40740,4623,2,67,2,850.41,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(162,7562,47,40740,4623,2,13,1,4900.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(163,7562,48,40740,4623,2,96,2,4958.68,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(164,7562,48,40740,4623,2,67,2,1041.32,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(165,7562,48,40740,4623,2,13,1,6000.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(166,7562,49,40740,4623,2,96,2,2479.34,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(167,7562,49,40740,4623,2,67,2,520.66,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(168,7562,49,40740,4623,2,13,1,3000.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(169,7562,50,40740,4623,2,96,2,14710.74,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(170,7562,50,40740,4623,2,67,2,3089.26,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL);
INSERT INTO `balance_libro_details` VALUES (171,7562,50,40740,4623,2,13,1,17800.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(172,7562,51,40740,4623,2,96,2,2231.40,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(173,7562,51,40740,4623,2,67,2,468.60,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(174,7562,51,40740,4623,2,13,1,2700.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(175,7562,52,40740,4623,2,96,2,4628.10,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(176,7562,52,40740,4623,2,67,2,971.90,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(177,7562,52,40740,4623,2,13,1,5600.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(178,7562,53,40740,4623,2,96,2,8181.82,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(179,7562,53,40740,4623,2,67,2,1718.18,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(180,7562,53,40740,4623,2,13,1,9900.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(181,7562,54,40740,4623,2,96,2,3471.07,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(182,7562,54,40740,4623,2,67,2,728.93,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(183,7562,54,40740,4623,2,13,1,4200.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(184,7562,55,40740,4623,2,96,2,5603.31,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(185,7562,55,40740,4623,2,67,2,1176.69,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(186,7562,55,40740,4623,2,13,1,6780.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(187,7562,56,40740,4623,2,96,2,13884.30,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(188,7562,56,40740,4623,2,67,2,2915.70,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(189,7562,56,40740,4623,2,13,1,16800.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(190,7562,57,40740,4623,2,96,2,8099.17,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(191,7562,57,40740,4623,2,67,2,1700.83,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(192,7562,57,40740,4623,2,13,1,9800.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(193,7562,58,40740,4623,2,96,2,4628.10,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(194,7562,58,40740,4623,2,67,2,971.90,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(195,7562,58,40740,4623,2,13,1,5600.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(196,7562,59,40740,4623,2,96,2,3140.50,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(197,7562,59,40740,4623,2,67,2,659.50,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(198,7562,59,40740,4623,2,13,1,3800.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(199,7562,60,40740,4623,2,96,2,1239.67,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(200,7562,60,40740,4623,2,67,2,260.33,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(201,7562,60,40740,4623,2,13,1,1500.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(202,7562,61,40740,4623,2,96,2,4181.82,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(203,7562,61,40740,4623,2,67,2,878.18,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(204,7562,61,40740,4623,2,13,1,5060.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(205,7562,62,40740,4623,2,96,2,3223.14,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(206,7562,62,40740,4623,2,67,2,676.86,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(207,7562,62,40740,4623,2,13,1,3900.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(208,7562,63,40740,4623,2,96,2,3719.01,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(209,7562,63,40740,4623,2,67,2,780.99,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(210,7562,63,40740,4623,2,13,1,4500.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(211,7562,64,40740,4623,2,96,2,11404.96,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(212,7562,64,40740,4623,2,67,2,2395.04,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL);
INSERT INTO `balance_libro_details` VALUES (213,7562,64,40740,4623,2,13,1,13800.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(214,7562,65,40740,4623,2,96,2,4371.90,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(215,7562,65,40740,4623,2,67,2,918.10,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(216,7562,65,40740,4623,2,13,1,5290.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(217,7562,66,40740,4623,2,96,2,10413.22,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(218,7562,66,40740,4623,2,67,2,2186.78,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(219,7562,66,40740,4623,2,13,1,12600.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(220,7562,67,40740,4623,2,96,2,6528.93,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(221,7562,67,40740,4623,2,67,2,1371.07,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(222,7562,67,40740,4623,2,13,1,7900.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(223,7562,68,40740,4623,2,96,2,3471.07,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(224,7562,68,40740,4623,2,67,2,728.93,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(225,7562,68,40740,4623,2,13,1,4200.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(226,7562,69,40740,4623,2,96,2,2314.05,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(227,7562,69,40740,4623,2,67,2,485.95,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(228,7562,69,40740,4623,2,13,1,2800.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(229,7562,70,40740,4623,2,96,2,11404.96,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(230,7562,70,40740,4623,2,67,2,2395.04,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(231,7562,70,40740,4623,2,13,1,13800.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(232,7562,71,40740,4623,2,96,2,6553.72,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(233,7562,71,40740,4623,2,67,2,1376.28,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(234,7562,71,40740,4623,2,13,1,7930.00,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(235,7562,72,40740,4623,2,96,2,4545.45,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(236,7562,72,40740,4623,2,67,2,954.55,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(237,7562,72,40740,4623,2,13,1,5500.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(238,7562,73,40740,4623,2,96,2,9090.91,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(239,7562,73,40740,4623,2,67,2,1909.09,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(240,7562,73,40740,4623,2,13,1,11000.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(241,7562,74,40740,4623,2,96,2,4132.23,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(242,7562,74,40740,4623,2,67,2,867.77,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(243,7562,74,40740,4623,2,13,1,5000.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(244,7562,75,40740,4623,2,96,2,3966.94,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(245,7562,75,40740,4623,2,67,2,833.06,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(246,7562,75,40740,4623,2,13,1,4800.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(247,7562,76,40740,4623,2,96,2,12396.69,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(248,7562,76,40740,4623,2,67,2,2603.31,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(249,7562,76,40740,4623,2,13,1,15000.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(250,7562,77,40740,4623,2,96,2,3471.07,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(251,7562,77,40740,4623,2,67,2,728.93,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(252,7562,77,40740,4623,2,13,1,4200.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(253,7562,78,40740,4623,2,96,2,4876.03,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(254,7562,78,40740,4623,2,67,2,1023.97,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL);
INSERT INTO `balance_libro_details` VALUES (255,7562,78,40740,4623,2,13,1,5900.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(256,7562,79,40740,4623,2,96,2,4628.10,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(257,7562,79,40740,4623,2,67,2,971.90,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(258,7562,79,40740,4623,2,13,1,5600.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(259,7562,80,40740,4623,2,96,2,4276.86,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(260,7562,80,40740,4623,2,67,2,898.14,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(261,7562,80,40740,4623,2,13,1,5175.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(262,7562,81,40740,4623,2,96,2,8181.82,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(263,7562,81,40740,4623,2,67,2,1718.18,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(264,7562,81,40740,4623,2,13,1,9900.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(265,7562,82,40740,4623,2,96,2,8264.46,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(266,7562,82,40740,4623,2,67,2,1735.54,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(267,7562,82,40740,4623,2,13,1,10000.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(268,7562,83,40740,4623,2,96,2,8264.46,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(269,7562,83,40740,4623,2,67,2,1735.54,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(270,7562,83,40740,4623,2,13,1,10000.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(271,7562,84,40740,4623,2,96,2,3223.14,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(272,7562,84,40740,4623,2,67,2,676.86,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(273,7562,84,40740,4623,2,13,1,3900.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(274,7562,85,40740,4623,2,96,2,7603.31,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(275,7562,85,40740,4623,2,67,2,1596.69,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(276,7562,85,40740,4623,2,13,1,9200.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(277,7562,86,40740,4623,2,96,2,2892.56,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(278,7562,86,40740,4623,2,67,2,607.44,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(279,7562,86,40740,4623,2,13,1,3500.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(280,7562,87,40740,4623,2,96,2,8181.82,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(281,7562,87,40740,4623,2,67,2,1718.18,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(282,7562,87,40740,4623,2,13,1,9900.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(283,7562,88,40740,4623,2,96,2,3305.79,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(284,7562,88,40740,4623,2,67,2,694.21,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(285,7562,88,40740,4623,2,13,1,4000.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(286,7562,89,40740,4623,2,96,2,4132.23,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(287,7562,89,40740,4623,2,67,2,867.77,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(288,7562,89,40740,4623,2,13,1,5000.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(289,7562,90,40740,4623,2,96,2,7355.37,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(290,7562,90,40740,4623,2,67,2,1544.63,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(291,7562,90,40740,4623,2,13,1,8900.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(292,7562,91,40740,4623,2,96,2,3231.40,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(293,7562,91,40740,4623,2,67,2,678.60,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(294,7562,91,40740,4623,2,13,1,3910.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(295,7562,92,40740,4623,2,96,2,3553.72,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(296,7562,92,40740,4623,2,67,2,746.28,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL);
INSERT INTO `balance_libro_details` VALUES (297,7562,92,40740,4623,2,13,1,4300.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(298,7562,93,40740,4623,2,96,2,5619.83,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(299,7562,93,40740,4623,2,67,2,1180.17,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(300,7562,93,40740,4623,2,13,1,6800.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(301,7562,94,40740,4623,2,96,2,4132.23,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(302,7562,94,40740,4623,2,67,2,867.77,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(303,7562,94,40740,4623,2,13,1,5000.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(304,7562,95,40740,4623,2,96,2,6611.57,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(305,7562,95,40740,4623,2,67,2,1388.43,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(306,7562,95,40740,4623,2,13,1,8000.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(307,7562,96,40740,4623,2,96,2,3223.14,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(308,7562,96,40740,4623,2,67,2,676.86,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(309,7562,96,40740,4623,2,13,1,3900.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(310,7562,97,40740,4623,2,96,2,3223.14,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(311,7562,97,40740,4623,2,67,2,676.86,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(312,7562,97,40740,4623,2,13,1,3900.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(313,7562,98,40740,4623,2,96,2,13223.14,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(314,7562,98,40740,4623,2,67,2,2776.86,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(315,7562,98,40740,4623,2,13,1,16000.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(316,7562,99,40740,4623,2,96,2,9752.07,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(317,7562,99,40740,4623,2,67,2,2047.93,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(318,7562,99,40740,4623,2,13,1,11800.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(319,7562,100,40740,4623,2,96,2,5603.31,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(320,7562,100,40740,4623,2,67,2,1176.69,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(321,7562,100,40740,4623,2,13,1,6780.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(322,7562,101,40740,4623,2,96,2,8458.68,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(323,7562,101,40740,4623,2,67,2,1776.32,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(324,7562,101,40740,4623,2,13,1,10235.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(325,7562,102,40740,4623,2,96,2,7355.37,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(326,7562,102,40740,4623,2,67,2,1544.63,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(327,7562,102,40740,4623,2,13,1,8900.00,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(328,7562,103,40740,4623,2,96,2,3636.36,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(329,7562,103,40740,4623,2,67,2,763.64,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(330,7562,103,40740,4623,2,13,1,4400.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(331,7562,104,40740,4623,2,96,2,8595.04,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(332,7562,104,40740,4623,2,67,2,1804.96,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(333,7562,104,40740,4623,2,13,1,10400.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(334,7562,105,40740,4623,2,96,2,6173.55,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(335,7562,105,40740,4623,2,67,2,1296.45,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(336,7562,105,40740,4623,2,13,1,7470.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(337,7562,106,40740,4623,2,96,2,6173.55,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(338,7562,106,40740,4623,2,67,2,1296.45,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL);
INSERT INTO `balance_libro_details` VALUES (339,7562,106,40740,4623,2,13,1,7470.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(340,7562,107,40740,4623,2,96,2,4876.03,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(341,7562,107,40740,4623,2,67,2,1023.97,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(342,7562,107,40740,4623,2,13,1,5900.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(343,7562,108,40740,4623,2,96,2,3636.36,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(344,7562,108,40740,4623,2,67,2,763.64,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(345,7562,108,40740,4623,2,13,1,4400.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(346,7562,109,40740,4623,2,96,2,4876.03,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(347,7562,109,40740,4623,2,67,2,1023.97,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(348,7562,109,40740,4623,2,13,1,5900.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(349,7562,110,40740,4623,2,96,2,12876.03,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(350,7562,110,40740,4623,2,67,2,2703.97,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(351,7562,110,40740,4623,2,13,1,15580.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(352,7562,111,40740,4623,2,96,2,6033.06,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(353,7562,111,40740,4623,2,67,2,1266.94,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(354,7562,111,40740,4623,2,13,1,7300.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(355,7562,112,40740,4623,2,96,2,4545.45,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(356,7562,112,40740,4623,2,67,2,954.55,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(357,7562,112,40740,4623,2,13,1,5500.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(358,7562,113,40740,4623,2,96,2,11404.96,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(359,7562,113,40740,4623,2,67,2,2395.04,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(360,7562,113,40740,4623,2,13,1,13800.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(361,7562,114,40740,4623,2,96,2,4132.23,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(362,7562,114,40740,4623,2,67,2,867.77,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(363,7562,114,40740,4623,2,13,1,5000.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(364,7562,115,40740,4623,2,96,2,4049.59,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(365,7562,115,40740,4623,2,67,2,850.41,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(366,7562,115,40740,4623,2,13,1,4900.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(367,7562,116,40740,4623,2,96,2,5371.90,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(368,7562,116,40740,4623,2,67,2,1128.10,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(369,7562,116,40740,4623,2,13,1,6500.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(370,7562,117,40740,4623,2,96,2,3966.94,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(371,7562,117,40740,4623,2,67,2,833.06,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(372,7562,117,40740,4623,2,13,1,4800.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(373,7562,118,40740,4623,2,96,2,3041.32,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(374,7562,118,40740,4623,2,67,2,638.68,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(375,7562,118,40740,4623,2,13,1,3680.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(376,7562,119,40740,4623,2,96,2,5619.83,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(377,7562,119,40740,4623,2,67,2,1180.17,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(378,7562,119,40740,4623,2,13,1,6800.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(379,7562,120,40740,4623,2,96,2,3801.65,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(380,7562,120,40740,4623,2,67,2,798.35,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL);
INSERT INTO `balance_libro_details` VALUES (381,7562,120,40740,4623,2,13,1,4600.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(382,7562,121,40740,4623,2,96,2,4958.68,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(383,7562,121,40740,4623,2,67,2,1041.32,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(384,7562,121,40740,4623,2,13,1,6000.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(385,7562,122,40740,4623,2,96,2,6743.80,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(386,7562,122,40740,4623,2,67,2,1416.20,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(387,7562,122,40740,4623,2,13,1,8160.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(388,7562,123,40740,4623,2,96,2,10644.63,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(389,7562,123,40740,4623,2,67,2,2235.37,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(390,7562,123,40740,4623,2,13,1,12880.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(391,7562,124,40740,4623,2,96,2,4049.59,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(392,7562,124,40740,4623,2,67,2,850.41,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(393,7562,124,40740,4623,2,13,1,4900.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(394,7562,125,40740,4623,2,96,2,2314.05,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(395,7562,125,40740,4623,2,67,2,485.95,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(396,7562,125,40740,4623,2,13,1,2800.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(397,7562,126,40740,4623,2,96,2,5206.61,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(398,7562,126,40740,4623,2,67,2,1093.39,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(399,7562,126,40740,4623,2,13,1,6300.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(400,7562,127,40740,4623,2,96,2,9264.46,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(401,7562,127,40740,4623,2,67,2,1945.54,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(402,7562,127,40740,4623,2,13,1,11210.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(403,7562,128,40740,4623,2,96,2,5223.14,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(404,7562,128,40740,4623,2,67,2,1096.86,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(405,7562,128,40740,4623,2,13,1,6320.00,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(406,7562,129,40740,4623,2,96,2,4049.59,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(407,7562,129,40740,4623,2,67,2,850.41,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(408,7562,129,40740,4623,2,13,1,4900.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(409,7562,130,40740,4623,2,96,2,6611.57,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(410,7562,130,40740,4623,2,67,2,1388.43,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(411,7562,130,40740,4623,2,13,1,8000.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(412,7562,131,40740,4623,2,96,2,5123.97,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(413,7562,131,40740,4623,2,67,2,1076.03,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(414,7562,131,40740,4623,2,13,1,6200.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(415,7562,132,40740,4623,2,96,2,9917.36,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(416,7562,132,40740,4623,2,67,2,2082.64,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(417,7562,132,40740,4623,2,13,1,12000.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(418,7562,133,40740,4623,2,96,2,4181.82,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(419,7562,133,40740,4623,2,67,2,878.18,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(420,7562,133,40740,4623,2,13,1,5060.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(421,7562,134,40740,4623,2,96,2,4958.68,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(422,7562,134,40740,4623,2,67,2,1041.32,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL);
INSERT INTO `balance_libro_details` VALUES (423,7562,134,40740,4623,2,13,1,6000.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(424,7562,135,40740,4623,2,96,2,7851.24,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(425,7562,135,40740,4623,2,67,2,1648.76,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(426,7562,135,40740,4623,2,13,1,9500.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(427,7562,136,40740,4623,2,96,2,4545.45,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(428,7562,136,40740,4623,2,67,2,954.55,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(429,7562,136,40740,4623,2,13,1,5500.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(430,7562,137,40740,4623,2,96,2,12396.69,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(431,7562,137,40740,4623,2,67,2,2603.31,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(432,7562,137,40740,4623,2,13,1,15000.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(433,7562,138,40740,4623,2,96,2,9917.36,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(434,7562,138,40740,4623,2,67,2,2082.64,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(435,7562,138,40740,4623,2,13,1,12000.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(436,7562,139,40740,4623,2,96,2,6611.57,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(437,7562,139,40740,4623,2,67,2,1388.43,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(438,7562,139,40740,4623,2,13,1,8000.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(439,7562,140,40740,4623,2,96,2,12396.69,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(440,7562,140,40740,4623,2,67,2,2603.31,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(441,7562,140,40740,4623,2,13,1,15000.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(442,7562,141,40740,4623,2,96,2,8264.46,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(443,7562,141,40740,4623,2,67,2,1735.54,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(444,7562,141,40740,4623,2,13,1,10000.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(445,7562,142,40740,4623,2,96,2,8264.46,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(446,7562,142,40740,4623,2,67,2,1735.54,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(447,7562,142,40740,4623,2,13,1,10000.00,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(448,7562,143,40740,4623,3,217,1,65832.00,NULL,'2023-04-14 16:20:00','2023-04-14 16:20:00',NULL),(449,7562,143,40740,4623,3,68,1,13824.72,NULL,'2023-04-14 16:20:00','2023-04-14 16:20:00',NULL),(450,7562,143,40740,4623,3,57,2,79656.72,NULL,'2023-04-14 16:20:00','2023-04-14 16:20:00',NULL),(451,7562,144,40740,4623,3,217,1,31596.00,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(452,7562,144,40740,4623,3,68,1,6635.16,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(453,7562,144,40740,4623,3,57,2,38231.16,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(454,7562,145,40740,4623,3,217,1,7584.93,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(455,7562,145,40740,4623,3,68,1,1592.84,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(456,7562,145,40740,4623,3,217,1,-0.01,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(457,7562,145,40740,4623,3,57,2,9177.76,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(458,7562,146,40740,4623,3,217,2,4871.40,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(459,7562,146,40740,4623,3,67,2,1022.99,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(460,7562,146,40740,4623,3,57,1,5894.39,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(461,7562,147,40740,4623,3,217,1,3010.03,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(462,7562,147,40740,4623,3,68,1,812.71,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(463,7562,147,40740,4623,3,217,1,170.03,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(464,7562,147,40740,4623,3,57,2,3992.77,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL);
INSERT INTO `balance_libro_details` VALUES (465,7562,148,40740,4623,3,217,1,304.73,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(466,7562,148,40740,4623,3,68,1,63.99,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(467,7562,148,40740,4623,3,57,2,368.72,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(468,7562,149,40740,4623,3,217,1,8588.21,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(469,7562,149,40740,4623,3,68,1,1803.52,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(470,7562,149,40740,4623,3,57,2,10391.73,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(471,7562,150,40740,4623,3,217,2,78190.00,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(472,7562,150,40740,4623,3,67,2,16419.90,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(473,7562,150,40740,4623,3,57,1,94609.90,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(474,7562,151,40740,4623,3,217,1,9400.00,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(475,7562,151,40740,4623,3,68,1,1974.00,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(476,7562,151,40740,4623,3,57,2,11374.00,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(477,7562,152,40740,4623,3,217,1,15206.00,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(478,7562,152,40740,4623,3,68,1,3193.26,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(479,7562,152,40740,4623,3,57,2,18399.26,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(480,7562,153,40740,4623,3,217,1,37558.02,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(481,7562,153,40740,4623,3,68,1,7887.18,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(482,7562,153,40740,4623,3,217,1,0.01,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(483,7562,153,40740,4623,3,57,2,45445.21,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(484,7562,154,40740,4623,3,217,1,14507.52,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(485,7562,154,40740,4623,3,68,1,3046.58,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(486,7562,154,40740,4623,3,57,2,17554.10,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(487,7562,155,40740,4623,3,217,1,4929.76,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(488,7562,155,40740,4623,3,68,1,1035.25,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(489,7562,155,40740,4623,3,57,2,5965.01,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(490,7562,156,40740,4623,3,217,1,4929.76,NULL,'2023-04-14 16:20:01','2023-04-14 16:31:14','2023-04-14 16:31:14'),(491,7562,156,40740,4623,3,68,1,1035.25,NULL,'2023-04-14 16:20:01','2023-04-14 16:31:14','2023-04-14 16:31:14'),(492,7562,156,40740,4623,3,57,2,5965.01,NULL,'2023-04-14 16:20:01','2023-04-14 16:31:14','2023-04-14 16:31:14'),(493,7562,157,40740,4623,3,217,1,3809.92,NULL,'2023-04-14 16:20:01','2023-04-14 16:31:04','2023-04-14 16:31:04'),(494,7562,157,40740,4623,3,68,1,800.08,NULL,'2023-04-14 16:20:01','2023-04-14 16:31:04','2023-04-14 16:31:04'),(495,7562,157,40740,4623,3,57,2,4610.00,NULL,'2023-04-14 16:20:01','2023-04-14 16:31:04','2023-04-14 16:31:04'),(496,7562,158,40740,4623,3,217,1,206611.57,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(497,7562,158,40740,4623,3,68,1,43388.43,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(498,7562,158,40740,4623,3,57,2,250000.00,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(499,7562,159,40740,4623,3,217,1,6372.00,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(500,7562,159,40740,4623,3,68,1,1338.12,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(501,7562,159,40740,4623,3,57,2,7710.12,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(502,7562,160,40740,4623,3,217,1,4791.00,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(503,7562,160,40740,4623,3,68,1,1006.11,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(504,7562,160,40740,4623,3,217,1,143.73,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL);
INSERT INTO `balance_libro_details` VALUES (505,7562,160,40740,4623,3,57,2,5940.84,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(506,7562,161,40740,4623,3,217,1,87080.00,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(507,7562,161,40740,4623,3,68,1,18286.80,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(508,7562,161,40740,4623,3,57,2,105366.80,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(509,7562,162,40740,4623,3,217,1,61408.48,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(510,7562,162,40740,4623,3,68,1,12895.78,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(511,7562,162,40740,4623,3,57,2,74304.26,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(512,7562,163,40740,4623,3,217,2,7253.76,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(513,7562,163,40740,4623,3,67,2,1523.29,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(514,7562,163,40740,4623,3,57,1,8777.05,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(515,7562,164,40740,4623,3,217,1,7760.34,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(516,7562,164,40740,4623,3,68,1,1629.67,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(517,7562,164,40740,4623,3,217,1,609.95,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(518,7562,164,40740,4623,3,57,2,9999.96,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(519,7562,165,40740,4623,3,217,1,3206.18,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(520,7562,165,40740,4623,3,68,1,673.30,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(521,7562,165,40740,4623,3,217,1,520.57,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(522,7562,165,40740,4623,3,57,2,4400.05,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(656,7562,172,40720,1515,12,359,1,662292.49,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(657,7562,172,40720,1515,12,410,1,228613.08,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(658,7562,172,40720,1515,12,13,1,1325611.35,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(659,7562,172,40720,1515,12,23,1,205593.07,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(660,7562,172,40720,1515,12,24,1,136409.23,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(661,7562,172,40720,1515,12,437,1,30541.97,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(662,7562,172,40720,1515,12,313,1,2823.58,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(663,7562,172,40720,1515,12,416,1,1096071.16,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(664,7562,172,40720,1515,12,57,2,259140.08,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(665,7562,172,40720,1515,12,74,2,3363.90,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(666,7562,172,40720,1515,12,79,2,103268.78,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(667,7562,172,40720,1515,12,482,2,394794.38,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(668,7562,172,40720,1515,12,483,2,42124.30,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(669,7562,172,40720,1515,12,435,1,114863.18,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(670,7562,172,40720,1515,12,62,2,299106.30,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(671,7562,172,40720,1515,12,63,2,224111.94,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(672,7562,172,40720,1515,12,64,2,133223.52,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(673,7562,172,40720,1515,12,444,2,26014.98,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(674,7562,172,40720,1515,12,369,2,100000.00,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40');
INSERT INTO `balance_libro_details` VALUES (675,7562,172,40720,1515,12,88,2,1119712.78,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(676,7562,172,40720,1515,12,381,2,71588.47,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(677,7562,172,40720,1515,12,92,2,1946065.34,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(678,7562,172,40720,1515,12,383,1,919695.66,NULL,'2023-04-16 16:45:04','2023-04-17 16:15:40','2023-04-17 16:15:40'),(679,7562,173,40720,1515,12,359,1,662292.49,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(680,7562,173,40720,1515,12,410,1,228613.08,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(681,7562,173,40720,1515,12,13,1,1325611.35,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(682,7562,173,40720,1515,12,23,1,205593.07,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(683,7562,173,40720,1515,12,24,1,136409.23,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(684,7562,173,40720,1515,12,437,1,30541.97,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(685,7562,173,40720,1515,12,313,1,2823.58,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(686,7562,173,40720,1515,12,416,1,1096071.16,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(687,7562,173,40720,1515,12,57,2,259140.08,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(688,7562,173,40720,1515,12,74,2,3363.90,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(689,7562,173,40720,1515,12,79,2,103268.78,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(690,7562,173,40720,1515,12,482,2,394794.38,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(691,7562,173,40720,1515,12,483,2,42124.30,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(692,7562,173,40720,1515,12,435,1,114863.18,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(693,7562,173,40720,1515,12,62,2,299106.30,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(694,7562,173,40720,1515,12,63,2,224111.94,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(695,7562,173,40720,1515,12,444,2,26014.98,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(696,7562,173,40720,1515,12,369,2,100000.00,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(697,7562,173,40720,1515,12,88,2,1119712.78,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(698,7562,173,40720,1515,12,381,2,71588.47,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(699,7562,173,40720,1515,12,92,2,1946065.34,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(700,7562,173,40720,1515,12,383,1,919695.66,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(701,7562,173,40720,1515,12,484,2,133223.52,NULL,'2023-04-17 16:15:40','2023-04-17 16:15:40',NULL),(702,7562,174,40720,1515,13,62,1,299106.30,NULL,'2023-04-17 16:50:38','2023-04-17 16:50:38',NULL),(703,7562,174,40720,1515,13,63,1,32143.25,NULL,'2023-04-17 16:50:38','2023-04-17 16:50:38',NULL),(704,7562,174,40720,1515,13,359,2,331249.55,NULL,'2023-04-17 16:50:38','2023-04-17 16:50:38',NULL),(705,7562,175,40720,1515,13,74,1,3363.90,NULL,'2023-04-17 16:51:57','2023-04-17 16:51:57',NULL),(706,7562,175,40720,1515,13,410,2,3363.90,NULL,'2023-04-17 16:51:57','2023-04-17 16:51:57',NULL),(727,7562,179,40720,1515,1,110,1,311755.24,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(728,7562,179,40720,1515,1,191,1,42760.47,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(729,7562,179,40720,1515,1,62,2,268780.37,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(730,7562,179,40720,1515,1,63,2,51162.80,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(731,7562,179,40720,1515,1,484,2,28511.01,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(732,7562,179,40720,1515,1,485,2,5891.08,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(733,7562,179,40720,1515,1,486,2,170.45,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(734,7562,180,40720,1516,1,110,1,315407.06,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL);
INSERT INTO `balance_libro_details` VALUES (735,7562,180,40720,1516,1,191,1,44113.37,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(736,7562,180,40720,1516,1,62,2,269567.74,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(737,7562,180,40720,1516,1,63,2,54043.09,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(738,7562,180,40720,1516,1,484,2,29712.16,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(739,7562,180,40720,1516,1,485,2,6026.99,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(740,7562,180,40720,1516,1,486,2,170.45,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(741,7562,181,40720,1517,1,110,1,323796.15,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(742,7562,181,40720,1517,1,191,1,43958.39,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(743,7562,181,40720,1517,1,62,2,280689.91,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(744,7562,181,40720,1517,1,63,2,49368.24,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(745,7562,181,40720,1517,1,484,2,31004.97,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(746,7562,181,40720,1517,1,485,2,6520.97,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(747,7562,181,40720,1517,1,486,2,170.45,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(748,7562,182,40720,1518,1,110,1,387707.30,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(749,7562,182,40720,1518,1,191,1,48075.88,NULL,'2023-04-17 16:54:27','2023-04-17 16:54:27',NULL),(750,7562,182,40720,1518,1,62,2,337007.84,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(751,7562,182,40720,1518,1,63,2,61808.57,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(752,7562,182,40720,1518,1,484,2,29920.26,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(753,7562,182,40720,1518,1,485,2,6876.06,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(754,7562,182,40720,1518,1,486,2,170.45,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(755,7562,183,40720,1519,1,110,1,380597.83,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(756,7562,183,40720,1519,1,191,1,42269.05,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(757,7562,183,40720,1519,1,62,2,334560.16,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(758,7562,183,40720,1519,1,63,2,55977.73,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(759,7562,183,40720,1519,1,484,2,25775.90,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(760,7562,183,40720,1519,1,485,2,6382.64,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(761,7562,183,40720,1519,1,486,2,170.45,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(762,7562,184,40720,1520,1,110,1,505128.37,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(763,7562,184,40720,1520,1,191,1,57082.96,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(764,7562,184,40720,1520,1,62,2,440716.30,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(765,7562,184,40720,1520,1,63,2,82920.84,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(766,7562,184,40720,1520,1,484,2,29159.48,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(767,7562,184,40720,1520,1,485,2,9244.26,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(768,7562,184,40720,1520,1,486,2,170.45,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(769,7562,185,40720,1522,1,110,1,332237.48,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(770,7562,185,40720,1522,1,191,1,44504.65,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(771,7562,185,40720,1522,1,62,2,291972.56,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(772,7562,185,40720,1522,1,63,2,46323.29,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(773,7562,185,40720,1522,1,484,2,30931.08,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(774,7562,185,40720,1522,1,485,2,7344.75,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(775,7562,185,40720,1522,1,486,2,170.45,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL);
INSERT INTO `balance_libro_details` VALUES (776,7562,186,40720,1523,1,110,1,387042.03,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(777,7562,186,40720,1523,1,191,1,47881.92,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(778,7562,186,40720,1523,1,62,2,340631.70,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(779,7562,186,40720,1523,1,63,2,54500.39,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(780,7562,186,40720,1523,1,484,2,32035.80,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(781,7562,186,40720,1523,1,485,2,7585.61,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(782,7562,186,40720,1523,1,486,2,170.45,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(783,7562,187,40720,1524,1,110,1,503976.29,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(784,7562,187,40720,1524,1,191,1,55280.70,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(785,7562,187,40720,1524,1,62,2,444407.70,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(786,7562,187,40720,1524,1,63,2,72231.35,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(787,7562,187,40720,1524,1,484,2,34074.35,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(788,7562,187,40720,1524,1,485,2,8283.12,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(789,7562,187,40720,1524,1,486,2,260.47,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(790,7562,188,40720,1525,1,110,1,503976.29,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(791,7562,188,40720,1525,1,191,1,55280.70,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(792,7562,188,40720,1525,1,62,2,444407.70,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(793,7562,188,40720,1525,1,63,2,72231.35,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(794,7562,188,40720,1525,1,484,2,34074.35,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(795,7562,188,40720,1525,1,485,2,8283.12,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(796,7562,188,40720,1525,1,486,2,260.47,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(797,7562,189,40720,1526,1,110,1,461498.71,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(798,7562,189,40720,1526,1,191,1,62426.92,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(799,7562,189,40720,1526,1,62,2,396785.84,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(800,7562,189,40720,1526,1,63,2,79901.28,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(801,7562,189,40720,1526,1,484,2,37766.88,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(802,7562,189,40720,1526,1,485,2,9211.16,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(803,7562,189,40720,1526,1,486,2,260.47,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(804,7562,190,40720,1527,1,110,1,716448.84,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(805,7562,190,40720,1527,1,191,1,90197.06,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(806,7562,190,40720,1527,1,62,2,617000.12,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(807,7562,190,40720,1527,1,63,2,127787.12,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(808,7562,190,40720,1527,1,484,2,47880.04,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(809,7562,190,40720,1527,1,485,2,13718.15,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(810,7562,190,40720,1527,1,486,2,260.47,NULL,'2023-04-17 16:54:28','2023-04-17 16:54:28',NULL),(811,7562,191,40720,1519,10,79,1,103268.80,NULL,'2023-04-18 17:03:16','2023-04-18 17:33:29','2023-04-18 17:33:29'),(812,7562,191,40720,1519,10,23,2,107858.83,NULL,'2023-04-18 17:03:16','2023-04-18 17:33:29','2023-04-18 17:33:29'),(813,7562,191,40720,1519,10,24,1,4590.05,NULL,'2023-04-18 17:03:16','2023-04-18 17:33:29','2023-04-18 17:33:29'),(814,7562,191,40720,1519,10,23,2,97734.24,NULL,'2023-04-18 17:03:16','2023-04-18 17:33:29','2023-04-18 17:33:29'),(815,7562,191,40720,1519,10,437,2,30541.97,NULL,'2023-04-18 17:03:16','2023-04-18 17:33:29','2023-04-18 17:33:29');
INSERT INTO `balance_libro_details` VALUES (816,7562,191,40720,1519,10,396,1,30541.97,NULL,'2023-04-18 17:03:16','2023-04-18 17:33:29','2023-04-18 17:33:29'),(817,7562,191,40720,1519,10,24,1,97734.22,NULL,'2023-04-18 17:03:16','2023-04-18 17:33:29','2023-04-18 17:33:29'),(818,7562,192,40720,1519,10,79,1,103268.82,NULL,'2023-04-18 17:33:29','2023-04-20 16:05:55','2023-04-20 16:05:55'),(819,7562,192,40720,1519,10,23,2,107858.83,NULL,'2023-04-18 17:33:29','2023-04-20 16:05:55','2023-04-20 16:05:55'),(820,7562,192,40720,1519,10,24,1,4590.05,NULL,'2023-04-18 17:33:29','2023-04-20 16:05:55','2023-04-20 16:05:55'),(821,7562,192,40720,1519,10,23,2,97734.24,NULL,'2023-04-18 17:33:29','2023-04-20 16:05:55','2023-04-20 16:05:55'),(822,7562,192,40720,1519,10,437,2,30541.97,NULL,'2023-04-18 17:33:29','2023-04-20 16:05:55','2023-04-20 16:05:55'),(823,7562,192,40720,1519,10,396,1,30541.97,NULL,'2023-04-18 17:33:29','2023-04-20 16:05:55','2023-04-20 16:05:55'),(824,7562,192,40720,1519,10,24,1,97734.20,NULL,'2023-04-18 17:33:29','2023-04-20 16:05:55','2023-04-20 16:05:55'),(825,7562,193,40720,1519,13,383,1,919695.70,NULL,'2023-04-18 17:36:37','2023-04-21 15:07:15','2023-04-21 15:07:15'),(826,7562,193,40720,1519,13,92,2,919695.70,NULL,'2023-04-18 17:36:37','2023-04-21 15:07:15','2023-04-21 15:07:15'),(827,7562,194,40720,1515,21,62,1,268780.37,NULL,'2023-04-18 17:48:30','2023-04-18 17:48:30',NULL),(828,7562,194,40720,1515,21,484,1,24818.11,NULL,'2023-04-18 17:48:30','2023-04-18 17:48:30',NULL),(829,7562,194,40720,1515,21,485,1,7154.69,NULL,'2023-04-18 17:48:30','2023-04-18 17:48:30',NULL),(830,7562,194,40720,1515,21,486,1,170.45,NULL,'2023-04-18 17:48:30','2023-04-18 17:48:30',NULL),(831,7562,194,40720,1515,21,410,2,32143.25,NULL,'2023-04-18 17:48:30','2023-04-18 17:48:30',NULL),(832,7562,194,40720,1515,21,410,2,268780.37,NULL,'2023-04-18 17:48:30','2023-04-18 17:48:30',NULL),(833,7562,195,40720,1516,1,63,1,35619.12,NULL,'2023-04-18 17:59:21','2023-04-18 17:59:21',NULL),(834,7562,195,40720,1516,1,410,2,35619.12,NULL,'2023-04-18 17:59:21','2023-04-18 17:59:21',NULL),(835,7562,196,40720,1516,1,484,1,28511.01,NULL,'2023-04-18 18:02:49','2023-04-18 18:30:21','2023-04-18 18:30:21'),(836,7562,196,40720,1516,1,485,1,5891.08,NULL,'2023-04-18 18:02:49','2023-04-18 18:30:21','2023-04-18 18:30:21'),(837,7562,196,40720,1516,1,486,1,170.45,NULL,'2023-04-18 18:02:49','2023-04-18 18:30:21','2023-04-18 18:30:21'),(838,7562,196,40720,1516,1,410,2,34572.54,NULL,'2023-04-18 18:02:49','2023-04-18 18:30:21','2023-04-18 18:30:21'),(839,7562,196,40720,1516,1,410,2,269567.74,NULL,'2023-04-18 18:02:49','2023-04-18 18:30:21','2023-04-18 18:30:21'),(840,7562,196,40720,1516,1,62,1,269567.74,NULL,'2023-04-18 18:02:49','2023-04-18 18:30:21','2023-04-18 18:30:21'),(841,7562,197,40720,1517,1,484,1,29712.16,NULL,'2023-04-18 18:07:36','2023-04-18 18:07:36',NULL),(842,7562,197,40720,1517,1,485,1,6026.99,NULL,'2023-04-18 18:07:36','2023-04-18 18:07:36',NULL),(843,7562,197,40720,1517,1,486,1,170.45,NULL,'2023-04-18 18:07:36','2023-04-18 18:07:36',NULL),(844,7562,197,40720,1517,1,410,2,35909.60,NULL,'2023-04-18 18:07:36','2023-04-18 18:07:36',NULL),(845,7562,197,40720,1517,1,410,2,280689.91,NULL,'2023-04-18 18:07:36','2023-04-18 18:07:36',NULL),(846,7562,197,40720,1517,1,62,1,280689.91,NULL,'2023-04-18 18:07:36','2023-04-18 18:07:36',NULL),(847,7562,198,40720,1518,1,484,1,31004.97,NULL,'2023-04-18 18:12:29','2023-04-18 18:12:29',NULL),(848,7562,198,40720,1518,1,485,1,6520.97,NULL,'2023-04-18 18:12:29','2023-04-18 18:12:29',NULL),(849,7562,198,40720,1518,1,486,1,170.45,NULL,'2023-04-18 18:12:29','2023-04-18 18:12:29',NULL),(850,7562,198,40720,1518,1,410,2,37696.39,NULL,'2023-04-18 18:12:29','2023-04-18 18:12:29',NULL),(851,7562,198,40720,1518,1,410,2,337007.84,NULL,'2023-04-18 18:12:29','2023-04-18 18:12:29',NULL),(852,7562,198,40720,1518,1,62,1,337007.84,NULL,'2023-04-18 18:12:29','2023-04-18 18:12:29',NULL),(853,7562,199,40720,1519,1,484,1,29920.26,NULL,'2023-04-18 18:14:08','2023-04-18 18:54:04','2023-04-18 18:54:04');
INSERT INTO `balance_libro_details` VALUES (854,7562,199,40720,1519,1,485,1,6876.06,NULL,'2023-04-18 18:14:08','2023-04-18 18:54:04','2023-04-18 18:54:04'),(855,7562,199,40720,1519,1,486,1,170.45,NULL,'2023-04-18 18:14:08','2023-04-18 18:54:04','2023-04-18 18:54:04'),(856,7562,199,40720,1519,1,410,2,36966.77,NULL,'2023-04-18 18:14:08','2023-04-18 18:54:04','2023-04-18 18:54:04'),(857,7562,199,40720,1519,1,410,2,334560.16,NULL,'2023-04-18 18:14:08','2023-04-18 18:54:04','2023-04-18 18:54:04'),(858,7562,199,40720,1519,1,62,1,334560.16,NULL,'2023-04-18 18:14:08','2023-04-18 18:54:04','2023-04-18 18:54:04'),(859,7562,200,40720,1520,1,484,1,25775.90,NULL,'2023-04-18 18:16:10','2023-04-18 18:16:10',NULL),(860,7562,200,40720,1520,1,485,1,6382.64,NULL,'2023-04-18 18:16:10','2023-04-18 18:16:10',NULL),(861,7562,200,40720,1520,1,486,1,170.45,NULL,'2023-04-18 18:16:10','2023-04-18 18:16:10',NULL),(862,7562,200,40720,1520,1,410,2,32328.99,NULL,'2023-04-18 18:16:10','2023-04-18 18:16:10',NULL),(863,7562,200,40720,1520,1,410,2,334560.16,NULL,'2023-04-18 18:16:10','2023-04-18 18:16:10',NULL),(864,7562,200,40720,1520,1,62,1,334560.16,NULL,'2023-04-18 18:16:10','2023-04-18 18:16:10',NULL),(865,7562,201,40720,1522,1,484,1,29159.48,NULL,'2023-04-18 18:18:36','2023-04-18 18:18:36',NULL),(866,7562,201,40720,1522,1,485,1,9244.26,NULL,'2023-04-18 18:18:36','2023-04-18 18:18:36',NULL),(867,7562,201,40720,1522,1,486,1,170.45,NULL,'2023-04-18 18:18:36','2023-04-18 18:18:36',NULL),(868,7562,201,40720,1522,1,410,2,38574.19,NULL,'2023-04-18 18:18:36','2023-04-18 18:18:36',NULL),(869,7562,201,40720,1522,1,410,2,440716.30,NULL,'2023-04-18 18:18:36','2023-04-18 18:18:36',NULL),(870,7562,201,40720,1522,1,62,1,440716.30,NULL,'2023-04-18 18:18:36','2023-04-18 18:18:36',NULL),(871,7562,202,40720,1523,1,484,1,30931.08,NULL,'2023-04-18 18:20:30','2023-04-18 18:20:30',NULL),(872,7562,202,40720,1523,1,485,1,7344.75,NULL,'2023-04-18 18:20:30','2023-04-18 18:20:30',NULL),(873,7562,202,40720,1523,1,486,1,170.45,NULL,'2023-04-18 18:20:30','2023-04-18 18:20:30',NULL),(874,7562,202,40720,1523,1,410,2,38446.28,NULL,'2023-04-18 18:20:30','2023-04-18 18:20:30',NULL),(875,7562,202,40720,1523,1,410,2,291972.56,NULL,'2023-04-18 18:20:30','2023-04-18 18:20:30',NULL),(876,7562,202,40720,1523,1,62,1,291972.56,NULL,'2023-04-18 18:20:30','2023-04-18 18:20:30',NULL),(877,7562,203,40720,1524,1,484,1,32035.80,NULL,'2023-04-18 18:22:34','2023-04-18 18:22:34',NULL),(878,7562,203,40720,1524,1,485,1,7585.61,NULL,'2023-04-18 18:22:34','2023-04-18 18:22:34',NULL),(879,7562,203,40720,1524,1,486,1,170.45,NULL,'2023-04-18 18:22:34','2023-04-18 18:22:34',NULL),(880,7562,203,40720,1524,1,410,2,39791.86,NULL,'2023-04-18 18:22:34','2023-04-18 18:22:34',NULL),(881,7562,203,40720,1524,1,410,2,340631.70,NULL,'2023-04-18 18:22:34','2023-04-18 18:22:34',NULL),(882,7562,203,40720,1524,1,62,1,340631.70,NULL,'2023-04-18 18:22:34','2023-04-18 18:22:34',NULL),(883,7562,204,40720,1525,1,484,1,34074.35,NULL,'2023-04-18 18:24:17','2023-04-18 18:24:17',NULL),(884,7562,204,40720,1525,1,485,1,8200.87,NULL,'2023-04-18 18:24:17','2023-04-18 18:24:17',NULL),(885,7562,204,40720,1525,1,486,1,260.47,NULL,'2023-04-18 18:24:17','2023-04-18 18:24:17',NULL),(886,7562,204,40720,1525,1,410,2,42535.69,NULL,'2023-04-18 18:24:17','2023-04-18 18:24:17',NULL),(887,7562,204,40720,1525,1,410,2,444407.70,NULL,'2023-04-18 18:24:17','2023-04-18 18:24:17',NULL),(888,7562,204,40720,1525,1,62,1,444407.70,NULL,'2023-04-18 18:24:17','2023-04-18 18:24:17',NULL),(889,7562,205,40720,1526,1,484,1,34074.35,NULL,'2023-04-18 18:27:40','2023-04-18 18:27:40',NULL),(890,7562,205,40720,1526,1,485,1,8283.12,NULL,'2023-04-18 18:27:40','2023-04-18 18:27:40',NULL),(891,7562,205,40720,1526,1,486,1,260.47,NULL,'2023-04-18 18:27:40','2023-04-18 18:27:40',NULL),(892,7562,205,40720,1526,1,410,2,42617.94,NULL,'2023-04-18 18:27:40','2023-04-18 18:27:40',NULL),(893,7562,205,40720,1526,1,410,2,444407.70,NULL,'2023-04-18 18:27:40','2023-04-18 18:27:40',NULL);
INSERT INTO `balance_libro_details` VALUES (894,7562,205,40720,1526,1,62,1,444407.70,NULL,'2023-04-18 18:27:40','2023-04-18 18:27:40',NULL),(895,7562,206,40720,1527,1,484,1,37766.88,NULL,'2023-04-18 18:29:16','2023-04-18 18:29:16',NULL),(896,7562,206,40720,1527,1,485,1,9211.16,NULL,'2023-04-18 18:29:16','2023-04-18 18:29:16',NULL),(897,7562,206,40720,1527,1,486,1,260.47,NULL,'2023-04-18 18:29:16','2023-04-18 18:29:16',NULL),(898,7562,206,40720,1527,1,410,2,47238.51,NULL,'2023-04-18 18:29:16','2023-04-18 18:29:16',NULL),(899,7562,206,40720,1527,1,410,2,396785.84,NULL,'2023-04-18 18:29:16','2023-04-18 18:29:16',NULL),(900,7562,206,40720,1527,1,62,1,396785.84,NULL,'2023-04-18 18:29:16','2023-04-18 18:29:16',NULL),(901,7562,207,40720,1516,1,484,1,28511.01,NULL,'2023-04-18 18:30:21','2023-04-18 18:30:21',NULL),(902,7562,207,40720,1516,1,485,1,5891.08,NULL,'2023-04-18 18:30:21','2023-04-18 18:30:21',NULL),(903,7562,207,40720,1516,1,486,1,170.45,NULL,'2023-04-18 18:30:21','2023-04-18 18:30:21',NULL),(904,7562,207,40720,1516,1,410,2,34572.54,NULL,'2023-04-18 18:30:21','2023-04-18 18:30:21',NULL),(905,7562,207,40720,1516,1,410,2,269567.74,NULL,'2023-04-18 18:30:21','2023-04-18 18:30:21',NULL),(906,7562,207,40720,1516,1,62,1,269567.74,NULL,'2023-04-18 18:30:21','2023-04-18 18:30:21',NULL),(907,7562,208,40720,1519,1,484,1,29920.26,NULL,'2023-04-18 18:54:04','2023-04-18 18:54:04',NULL),(908,7562,208,40720,1519,1,485,1,6876.06,NULL,'2023-04-18 18:54:04','2023-04-18 18:54:04',NULL),(909,7562,208,40720,1519,1,486,1,170.45,NULL,'2023-04-18 18:54:04','2023-04-18 18:54:04',NULL),(910,7562,208,40720,1519,1,410,2,36966.77,NULL,'2023-04-18 18:54:04','2023-04-18 18:54:04',NULL),(911,7562,209,40720,1515,13,444,1,26014.98,NULL,'2023-04-19 15:06:37','2023-04-19 15:06:37',NULL),(912,7562,209,40720,1515,13,359,2,26014.98,NULL,'2023-04-19 15:06:37','2023-04-19 15:06:37',NULL),(1023,7562,232,40720,1515,2,96,2,2396.70,NULL,'2023-04-19 15:45:06','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1024,7562,232,40720,1515,2,218,2,592173.68,NULL,'2023-04-19 15:45:06','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1025,7562,232,40720,1515,2,67,2,503.31,NULL,'2023-04-19 15:45:06','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1026,7562,232,40720,1515,2,410,1,24135.74,NULL,'2023-04-19 15:45:06','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1027,7562,232,40720,1515,2,263,1,570937.95,NULL,'2023-04-19 15:45:06','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1028,7562,233,40720,1516,2,96,2,54466.23,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1029,7562,233,40720,1516,2,218,2,711486.91,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1030,7562,233,40720,1516,2,67,2,6475.65,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1031,7562,233,40720,1516,2,410,1,30651.53,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1032,7562,233,40720,1516,2,263,1,741777.26,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1033,7562,234,40720,1517,2,96,2,54957.40,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1034,7562,234,40720,1517,2,218,2,799363.62,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1035,7562,234,40720,1517,2,67,2,6603.58,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1036,7562,234,40720,1517,2,410,1,34644.74,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1037,7562,234,40720,1517,2,263,1,826279.86,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1038,7562,235,40720,1518,2,96,2,28528.48,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1039,7562,235,40720,1518,2,218,2,609644.73,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1040,7562,235,40720,1518,2,67,2,3481.44,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19');
INSERT INTO `balance_libro_details` VALUES (1041,7562,235,40720,1518,2,410,1,25585.21,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1042,7562,235,40720,1518,2,263,1,616069.44,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1043,7562,236,40720,1519,2,96,2,100865.52,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1044,7562,236,40720,1519,2,218,2,730636.56,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1045,7562,236,40720,1519,2,67,2,11306.79,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1046,7562,236,40720,1519,2,410,1,31924.56,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1047,7562,236,40720,1519,2,263,1,810884.31,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1048,7562,237,40720,1520,2,96,2,62196.79,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1049,7562,237,40720,1520,2,218,2,609786.00,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1050,7562,237,40720,1520,2,67,2,7571.99,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1051,7562,237,40720,1520,2,410,1,28400.13,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1052,7562,237,40720,1520,2,263,1,651154.65,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1053,7562,238,40720,1522,2,96,2,103395.95,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1054,7562,238,40720,1522,2,218,2,712175.80,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1055,7562,238,40720,1522,2,67,2,12531.37,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1056,7562,238,40720,1522,2,410,1,30944.49,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1057,7562,238,40720,1522,2,263,1,797158.63,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1058,7562,239,40720,1523,2,96,2,55128.48,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1059,7562,239,40720,1523,2,218,2,783831.15,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1060,7562,239,40720,1523,2,67,2,6717.00,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1061,7562,239,40720,1523,2,410,1,35654.27,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1062,7562,239,40720,1523,2,263,1,810022.36,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1063,7562,240,40720,1524,2,96,2,49920.18,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1064,7562,240,40720,1524,2,218,2,743813.32,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1065,7562,240,40720,1524,2,67,2,8278.81,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1066,7562,240,40720,1524,2,410,1,32110.44,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1067,7562,240,40720,1524,2,263,1,769901.87,NULL,'2023-04-19 15:45:39','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1068,7562,241,40720,1540,2,96,2,88209.41,NULL,'2023-04-19 15:45:39','2023-04-19 15:46:00','2023-04-19 15:46:00'),(1069,7562,241,40720,1540,2,218,2,920883.16,NULL,'2023-04-19 15:45:39','2023-04-19 15:46:00','2023-04-19 15:46:00'),(1070,7562,241,40720,1540,2,67,2,10706.82,NULL,'2023-04-19 15:45:39','2023-04-19 15:46:00','2023-04-19 15:46:00'),(1071,7562,241,40720,1540,2,410,1,39573.44,NULL,'2023-04-19 15:45:39','2023-04-19 15:46:00','2023-04-19 15:46:00'),(1072,7562,241,40720,1540,2,263,1,980225.95,NULL,'2023-04-19 15:45:39','2023-04-19 15:46:00','2023-04-19 15:46:00'),(1073,7562,242,40720,1541,2,96,2,0.00,NULL,'2023-04-19 15:45:40','2023-04-19 15:46:19','2023-04-19 15:46:19'),(1074,7562,242,40720,1541,2,218,2,813356.62,NULL,'2023-04-19 15:45:40','2023-04-19 15:46:19','2023-04-19 15:46:19');
INSERT INTO `balance_libro_details` VALUES (1075,7562,242,40720,1541,2,67,2,0.00,NULL,'2023-04-19 15:45:40','2023-04-19 15:46:19','2023-04-19 15:46:19'),(1076,7562,242,40720,1541,2,410,1,31715.27,NULL,'2023-04-19 15:45:40','2023-04-19 15:46:19','2023-04-19 15:46:19'),(1077,7562,242,40720,1541,2,263,1,781641.35,NULL,'2023-04-19 15:45:40','2023-04-19 15:46:19','2023-04-19 15:46:19'),(1078,7562,243,40720,1542,2,96,2,263820.26,NULL,'2023-04-19 15:45:40','2023-04-19 15:46:31','2023-04-19 15:46:31'),(1079,7562,243,40720,1542,2,218,2,649798.99,NULL,'2023-04-19 15:45:40','2023-04-19 15:46:31','2023-04-19 15:46:31'),(1080,7562,243,40720,1542,2,67,2,28195.76,NULL,'2023-04-19 15:45:40','2023-04-19 15:46:31','2023-04-19 15:46:31'),(1081,7562,243,40720,1542,2,410,1,38676.25,NULL,'2023-04-19 15:45:40','2023-04-19 15:46:31','2023-04-19 15:46:31'),(1082,7562,243,40720,1542,2,263,1,903138.76,NULL,'2023-04-19 15:45:40','2023-04-19 15:46:31','2023-04-19 15:46:31'),(1083,7562,244,40720,1525,2,96,2,88209.41,NULL,'2023-04-19 15:46:00','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1084,7562,244,40720,1525,2,218,2,920883.16,NULL,'2023-04-19 15:46:00','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1085,7562,244,40720,1525,2,67,2,10706.82,NULL,'2023-04-19 15:46:00','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1086,7562,244,40720,1525,2,410,1,39573.44,NULL,'2023-04-19 15:46:00','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1087,7562,244,40720,1525,2,263,1,980225.95,NULL,'2023-04-19 15:46:00','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1088,7562,245,40720,1526,2,218,2,813356.62,NULL,'2023-04-19 15:46:19','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1089,7562,245,40720,1526,2,410,1,31715.27,NULL,'2023-04-19 15:46:19','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1090,7562,245,40720,1526,2,263,1,781641.35,NULL,'2023-04-19 15:46:19','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1091,7562,246,40720,1527,2,96,2,263820.26,NULL,'2023-04-19 15:46:31','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1092,7562,246,40720,1527,2,218,2,649798.99,NULL,'2023-04-19 15:46:31','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1093,7562,246,40720,1527,2,67,2,28195.76,NULL,'2023-04-19 15:46:31','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1094,7562,246,40720,1527,2,410,1,38676.25,NULL,'2023-04-19 15:46:31','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1095,7562,246,40720,1527,2,263,1,903138.76,NULL,'2023-04-19 15:46:31','2023-04-19 15:47:19','2023-04-19 15:47:19'),(1096,7562,247,40720,1515,2,96,2,2396.70,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1097,7562,247,40720,1515,2,218,2,592173.68,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1098,7562,247,40720,1515,2,67,2,503.31,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1099,7562,247,40720,1515,2,263,1,24135.74,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1100,7562,247,40720,1515,2,410,1,570937.95,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1101,7562,248,40720,1516,2,96,2,54466.23,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1102,7562,248,40720,1516,2,218,2,711486.91,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1103,7562,248,40720,1516,2,67,2,6475.65,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1104,7562,248,40720,1516,2,263,1,30651.53,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1105,7562,248,40720,1516,2,410,1,741777.26,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1106,7562,249,40720,1517,2,96,2,54957.40,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1107,7562,249,40720,1517,2,218,2,799363.62,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1108,7562,249,40720,1517,2,67,2,6603.58,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1109,7562,249,40720,1517,2,263,1,34644.74,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1110,7562,249,40720,1517,2,410,1,826279.86,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1111,7562,250,40720,1518,2,96,2,28528.48,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL);
INSERT INTO `balance_libro_details` VALUES (1112,7562,250,40720,1518,2,218,2,609644.73,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1113,7562,250,40720,1518,2,67,2,3481.44,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1114,7562,250,40720,1518,2,263,1,25585.21,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1115,7562,250,40720,1518,2,410,1,616069.44,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1116,7562,251,40720,1519,2,96,2,100865.52,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1117,7562,251,40720,1519,2,218,2,730636.56,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1118,7562,251,40720,1519,2,67,2,11306.79,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1119,7562,251,40720,1519,2,263,1,31924.56,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1120,7562,251,40720,1519,2,410,1,810884.31,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1121,7562,252,40720,1520,2,96,2,62196.79,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1122,7562,252,40720,1520,2,218,2,609786.00,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1123,7562,252,40720,1520,2,67,2,7571.99,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1124,7562,252,40720,1520,2,263,1,28400.13,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1125,7562,252,40720,1520,2,410,1,651154.65,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1126,7562,253,40720,1522,2,96,2,103395.95,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1127,7562,253,40720,1522,2,218,2,712175.80,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1128,7562,253,40720,1522,2,67,2,12531.37,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1129,7562,253,40720,1522,2,263,1,30944.49,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1130,7562,253,40720,1522,2,410,1,797158.63,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1131,7562,254,40720,1523,2,96,2,55128.48,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1132,7562,254,40720,1523,2,218,2,783831.15,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1133,7562,254,40720,1523,2,67,2,6717.00,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1134,7562,254,40720,1523,2,263,1,35654.27,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1135,7562,254,40720,1523,2,410,1,810022.36,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1136,7562,255,40720,1524,2,96,2,49920.18,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1137,7562,255,40720,1524,2,218,2,743813.32,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1138,7562,255,40720,1524,2,67,2,8278.81,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1139,7562,255,40720,1524,2,263,1,32110.44,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1140,7562,255,40720,1524,2,410,1,769901.87,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:08',NULL),(1141,7562,256,40720,1540,2,96,2,88209.41,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:51','2023-04-19 15:49:51'),(1142,7562,256,40720,1540,2,218,2,920883.16,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:51','2023-04-19 15:49:51'),(1143,7562,256,40720,1540,2,67,2,10706.82,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:51','2023-04-19 15:49:51'),(1144,7562,256,40720,1540,2,263,1,39573.44,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:51','2023-04-19 15:49:51'),(1145,7562,256,40720,1540,2,410,1,980225.95,NULL,'2023-04-19 15:49:08','2023-04-19 15:49:51','2023-04-19 15:49:51'),(1146,7562,257,40720,1541,2,96,2,0.00,NULL,'2023-04-19 15:49:08','2023-04-19 15:50:00','2023-04-19 15:50:00'),(1147,7562,257,40720,1541,2,218,2,813356.62,NULL,'2023-04-19 15:49:08','2023-04-19 15:50:00','2023-04-19 15:50:00'),(1148,7562,257,40720,1541,2,67,2,0.00,NULL,'2023-04-19 15:49:08','2023-04-19 15:50:00','2023-04-19 15:50:00'),(1149,7562,257,40720,1541,2,263,1,31715.27,NULL,'2023-04-19 15:49:08','2023-04-19 15:50:00','2023-04-19 15:50:00'),(1150,7562,257,40720,1541,2,410,1,781641.35,NULL,'2023-04-19 15:49:08','2023-04-19 15:50:00','2023-04-19 15:50:00');
INSERT INTO `balance_libro_details` VALUES (1151,7562,258,40720,1542,2,96,2,263820.26,NULL,'2023-04-19 15:49:08','2023-04-19 15:50:11','2023-04-19 15:50:11'),(1152,7562,258,40720,1542,2,218,2,649798.99,NULL,'2023-04-19 15:49:08','2023-04-19 15:50:11','2023-04-19 15:50:11'),(1153,7562,258,40720,1542,2,67,2,28195.76,NULL,'2023-04-19 15:49:08','2023-04-19 15:50:11','2023-04-19 15:50:11'),(1154,7562,258,40720,1542,2,263,1,38676.25,NULL,'2023-04-19 15:49:08','2023-04-19 15:50:11','2023-04-19 15:50:11'),(1155,7562,258,40720,1542,2,410,1,903138.76,NULL,'2023-04-19 15:49:08','2023-04-19 15:50:11','2023-04-19 15:50:11'),(1156,7562,259,40720,1525,2,96,2,88209.41,NULL,'2023-04-19 15:49:51','2023-04-19 15:49:51',NULL),(1157,7562,259,40720,1525,2,218,2,920883.16,NULL,'2023-04-19 15:49:51','2023-04-19 15:49:51',NULL),(1158,7562,259,40720,1525,2,67,2,10706.82,NULL,'2023-04-19 15:49:51','2023-04-19 15:49:51',NULL),(1159,7562,259,40720,1525,2,263,1,39573.44,NULL,'2023-04-19 15:49:51','2023-04-19 15:49:51',NULL),(1160,7562,259,40720,1525,2,410,1,980225.95,NULL,'2023-04-19 15:49:51','2023-04-19 15:49:51',NULL),(1161,7562,260,40720,1526,2,218,2,813356.62,NULL,'2023-04-19 15:50:00','2023-04-19 15:50:00',NULL),(1162,7562,260,40720,1526,2,263,1,31715.27,NULL,'2023-04-19 15:50:00','2023-04-19 15:50:00',NULL),(1163,7562,260,40720,1526,2,410,1,781641.35,NULL,'2023-04-19 15:50:00','2023-04-19 15:50:00',NULL),(1164,7562,261,40720,1527,2,96,2,263820.26,NULL,'2023-04-19 15:50:11','2023-04-19 15:50:11',NULL),(1165,7562,261,40720,1527,2,218,2,649798.99,NULL,'2023-04-19 15:50:11','2023-04-19 15:50:11',NULL),(1166,7562,261,40720,1527,2,67,2,28195.76,NULL,'2023-04-19 15:50:11','2023-04-19 15:50:11',NULL),(1167,7562,261,40720,1527,2,263,1,38676.25,NULL,'2023-04-19 15:50:11','2023-04-19 15:50:11',NULL),(1168,7562,261,40720,1527,2,410,1,903138.76,NULL,'2023-04-19 15:50:11','2023-04-19 15:50:11',NULL),(1169,7562,262,40720,1515,3,217,1,177434.93,NULL,'2023-04-19 16:48:13','2023-04-19 16:48:13',NULL),(1170,7562,262,40720,1515,3,135,2,24016.14,NULL,'2023-04-19 16:48:13','2023-04-19 16:48:13',NULL),(1171,7562,262,40720,1515,3,68,1,42.52,NULL,'2023-04-19 16:48:13','2023-04-19 16:48:13',NULL),(1172,7562,262,40720,1515,3,409,1,10586.31,NULL,'2023-04-19 16:48:13','2023-04-19 16:48:13',NULL),(1173,7562,262,40720,1515,3,57,2,164047.62,NULL,'2023-04-19 16:48:13','2023-04-19 16:48:13',NULL),(1174,7562,263,40720,1516,3,217,1,177537.28,NULL,'2023-04-19 16:50:26','2023-04-19 16:50:26',NULL),(1175,7562,263,40720,1516,3,135,1,27350.92,NULL,'2023-04-19 16:50:26','2023-04-19 16:50:26',NULL),(1176,7562,263,40720,1516,3,68,1,1136.20,NULL,'2023-04-19 16:50:26','2023-04-19 16:50:26',NULL),(1177,7562,263,40720,1516,3,409,1,14866.59,NULL,'2023-04-19 16:50:26','2023-04-19 16:50:26',NULL),(1178,7562,263,40720,1516,3,57,2,220890.99,NULL,'2023-04-19 16:50:26','2023-04-19 16:50:26',NULL),(1179,7562,264,40720,1517,3,217,1,180121.80,NULL,'2023-04-19 16:52:24','2023-04-19 16:52:24',NULL),(1180,7562,264,40720,1517,3,135,1,38065.59,NULL,'2023-04-19 16:52:24','2023-04-19 16:52:24',NULL),(1181,7562,264,40720,1517,3,68,1,1219.63,NULL,'2023-04-19 16:52:24','2023-04-19 16:52:24',NULL),(1182,7562,264,40720,1517,3,409,1,17837.12,NULL,'2023-04-19 16:52:24','2023-04-19 16:52:24',NULL),(1183,7562,264,40720,1517,3,57,2,237244.14,NULL,'2023-04-19 16:52:24','2023-04-19 16:52:24',NULL),(1184,7562,265,40720,1518,3,217,1,172636.10,NULL,'2023-04-19 18:23:10','2023-04-19 18:23:10',NULL),(1185,7562,265,40720,1518,3,135,1,31766.39,NULL,'2023-04-19 18:23:10','2023-04-19 18:23:10',NULL),(1186,7562,265,40720,1518,3,68,1,693.69,NULL,'2023-04-19 18:23:10','2023-04-19 18:23:10',NULL),(1187,7562,265,40720,1518,3,409,1,14721.69,NULL,'2023-04-19 18:23:10','2023-04-19 18:23:10',NULL),(1188,7562,265,40720,1518,3,57,2,219817.87,NULL,'2023-04-19 18:23:10','2023-04-19 18:23:10',NULL),(1189,7562,266,40720,1519,3,217,1,185759.16,NULL,'2023-04-19 18:25:19','2023-04-19 18:25:19',NULL),(1190,7562,266,40720,1519,3,135,1,34661.46,NULL,'2023-04-19 18:25:19','2023-04-19 18:25:19',NULL);
INSERT INTO `balance_libro_details` VALUES (1191,7562,266,40720,1519,3,68,1,2375.76,NULL,'2023-04-19 18:25:19','2023-04-19 18:25:19',NULL),(1192,7562,266,40720,1519,3,409,1,17258.64,NULL,'2023-04-19 18:25:19','2023-04-19 18:25:19',NULL),(1193,7562,266,40720,1519,3,57,2,240055.02,NULL,'2023-04-19 18:25:19','2023-04-19 18:25:19',NULL),(1194,7562,267,40720,1520,3,217,1,168297.62,NULL,'2023-04-19 18:27:21','2023-04-19 18:27:21',NULL),(1195,7562,267,40720,1520,3,135,1,34888.82,NULL,'2023-04-19 18:27:21','2023-04-19 18:27:21',NULL),(1196,7562,267,40720,1520,3,193,1,1143.46,NULL,'2023-04-19 18:27:21','2023-04-19 18:27:21',NULL),(1197,7562,267,40720,1520,3,68,1,1449.73,NULL,'2023-04-19 18:27:21','2023-04-19 18:27:21',NULL),(1198,7562,267,40720,1520,3,409,1,14138.74,NULL,'2023-04-19 18:27:21','2023-04-19 18:27:21',NULL),(1199,7562,267,40720,1520,3,57,2,219918.37,NULL,'2023-04-19 18:27:21','2023-04-19 18:27:21',NULL),(1200,7562,268,40720,1522,3,217,1,177594.95,NULL,'2023-04-19 18:29:26','2023-04-19 18:29:26',NULL),(1201,7562,268,40720,1522,3,135,1,34888.82,NULL,'2023-04-19 18:29:26','2023-04-19 18:29:26',NULL),(1202,7562,268,40720,1522,3,193,1,6514.76,NULL,'2023-04-19 18:29:26','2023-04-19 18:29:26',NULL),(1203,7562,268,40720,1522,3,68,1,2459.29,NULL,'2023-04-19 18:29:26','2023-04-19 18:29:26',NULL),(1204,7562,268,40720,1522,3,409,1,16905.17,NULL,'2023-04-19 18:29:26','2023-04-19 18:29:26',NULL),(1205,7562,268,40720,1522,3,57,2,238362.99,NULL,'2023-04-19 18:29:26','2023-04-19 18:29:26',NULL),(1206,7562,269,40720,1523,3,217,1,170417.94,NULL,'2023-04-19 18:31:46','2023-04-19 18:31:46',NULL),(1207,7562,269,40720,1523,3,135,1,37987.04,NULL,'2023-04-19 18:31:46','2023-04-19 18:31:46',NULL),(1208,7562,269,40720,1523,3,193,1,4406.13,NULL,'2023-04-19 18:31:46','2023-04-19 18:31:46',NULL),(1209,7562,269,40720,1523,3,68,1,1256.22,NULL,'2023-04-19 18:31:46','2023-04-19 18:31:46',NULL),(1210,7562,269,40720,1523,3,409,1,17777.47,NULL,'2023-04-19 18:31:46','2023-04-19 18:31:46',NULL),(1211,7562,269,40720,1523,3,57,2,231844.80,NULL,'2023-04-19 18:31:46','2023-04-19 18:31:46',NULL),(1212,7562,270,40720,1524,3,217,1,213708.29,NULL,'2023-04-19 18:36:19','2023-04-19 18:43:19','2023-04-19 18:43:19'),(1213,7562,270,40720,1524,3,135,1,3400.00,NULL,'2023-04-19 18:36:19','2023-04-19 18:43:19','2023-04-19 18:43:19'),(1214,7562,270,40720,1524,3,135,1,37987.04,NULL,'2023-04-19 18:36:19','2023-04-19 18:43:19','2023-04-19 18:43:19'),(1215,7562,270,40720,1524,3,193,1,6508.59,NULL,'2023-04-19 18:36:19','2023-04-19 18:43:19','2023-04-19 18:43:19'),(1216,7562,270,40720,1524,3,68,1,1523.72,NULL,'2023-04-19 18:36:19','2023-04-19 18:43:19','2023-04-19 18:43:19'),(1217,7562,270,40720,1524,3,409,1,22662.39,NULL,'2023-04-19 18:36:19','2023-04-19 18:43:19','2023-04-19 18:43:19'),(1218,7562,270,40720,1524,3,57,2,285790.03,NULL,'2023-04-19 18:36:19','2023-04-19 18:43:19','2023-04-19 18:43:19'),(1219,7562,271,40720,1525,3,217,1,185554.44,NULL,'2023-04-19 18:40:57','2023-04-19 18:40:57',NULL),(1220,7562,271,40720,1525,3,135,1,40238.41,NULL,'2023-04-19 18:40:57','2023-04-19 18:40:57',NULL),(1221,7562,271,40720,1525,3,193,1,2601.52,NULL,'2023-04-19 18:40:57','2023-04-19 18:40:57',NULL),(1222,7562,271,40720,1525,3,68,1,1497.21,NULL,'2023-04-19 18:40:57','2023-04-19 18:40:57',NULL),(1223,7562,271,40720,1525,3,409,1,15712.11,NULL,'2023-04-19 18:40:57','2023-04-19 18:40:57',NULL),(1224,7562,271,40720,1525,3,25,1,71.61,NULL,'2023-04-19 18:40:57','2023-04-19 18:40:57',NULL),(1225,7562,271,40720,1525,3,57,2,245675.30,NULL,'2023-04-19 18:40:57','2023-04-19 18:40:57',NULL),(1226,7562,272,40720,1524,3,217,1,213708.29,NULL,'2023-04-19 18:43:19','2023-04-19 18:43:19',NULL),(1227,7562,272,40720,1524,3,135,1,3400.00,NULL,'2023-04-19 18:43:19','2023-04-19 18:43:19',NULL),(1228,7562,272,40720,1524,3,135,1,37987.04,NULL,'2023-04-19 18:43:19','2023-04-19 18:43:19',NULL),(1229,7562,272,40720,1524,3,193,1,6508.59,NULL,'2023-04-19 18:43:19','2023-04-19 18:43:19',NULL);
INSERT INTO `balance_libro_details` VALUES (1230,7562,272,40720,1524,3,68,1,1523.72,NULL,'2023-04-19 18:43:19','2023-04-19 18:43:19',NULL),(1231,7562,272,40720,1524,3,409,1,22662.39,NULL,'2023-04-19 18:43:19','2023-04-19 18:43:19',NULL),(1232,7562,272,40720,1524,3,25,1,144.25,NULL,'2023-04-19 18:43:19','2023-04-19 18:43:19',NULL),(1233,7562,272,40720,1524,3,57,2,285934.28,NULL,'2023-04-19 18:43:19','2023-04-19 18:43:19',NULL),(1234,7562,273,40720,1526,3,217,1,258519.65,NULL,'2023-04-19 18:45:28','2023-04-19 18:45:28',NULL),(1235,7562,273,40720,1526,3,135,1,51262.69,NULL,'2023-04-19 18:45:28','2023-04-19 18:45:28',NULL),(1236,7562,273,40720,1526,3,193,1,828.16,NULL,'2023-04-19 18:45:28','2023-04-19 18:45:28',NULL),(1237,7562,273,40720,1526,3,409,1,31179.74,NULL,'2023-04-19 18:45:28','2023-04-19 18:45:28',NULL),(1238,7562,273,40720,1526,3,57,2,341790.24,NULL,'2023-04-19 18:45:28','2023-04-19 18:45:28',NULL),(1239,7562,274,40720,1527,3,217,1,180413.56,NULL,'2023-04-19 18:47:44','2023-04-19 18:47:44',NULL),(1240,7562,274,40720,1527,3,135,1,55096.87,NULL,'2023-04-19 18:47:44','2023-04-19 18:47:44',NULL),(1241,7562,274,40720,1527,3,193,1,4175.62,NULL,'2023-04-19 18:47:44','2023-04-19 18:47:44',NULL),(1242,7562,274,40720,1527,3,25,1,114.93,NULL,'2023-04-19 18:47:44','2023-04-19 18:47:44',NULL),(1243,7562,274,40720,1527,3,68,1,5245.28,NULL,'2023-04-19 18:47:44','2023-04-19 18:47:44',NULL),(1244,7562,274,40720,1527,3,409,1,12904.48,NULL,'2023-04-19 18:47:44','2023-04-19 18:47:44',NULL),(1245,7562,274,40720,1527,3,57,2,257950.74,NULL,'2023-04-19 18:47:44','2023-04-19 18:47:44',NULL),(1246,7562,275,40720,1527,5,437,1,42867.97,NULL,'2023-04-19 22:40:34','2023-04-19 22:40:34',NULL),(1247,7562,275,40720,1527,5,396,1,32428.00,NULL,'2023-04-19 22:40:34','2023-04-19 22:40:34',NULL),(1248,7562,275,40720,1527,5,410,2,119441.52,NULL,'2023-04-19 22:40:34','2023-04-19 22:40:34',NULL),(1249,7562,275,40720,1527,5,437,1,44145.55,NULL,'2023-04-19 22:40:34','2023-04-19 22:40:34',NULL),(1250,7562,276,40720,1527,6,23,1,165996.18,NULL,'2023-04-19 22:42:15','2023-04-19 22:42:15',NULL),(1251,7562,276,40720,1527,6,410,2,165996.18,NULL,'2023-04-19 22:42:15','2023-04-19 22:42:15',NULL),(1252,7562,277,40720,1527,10,482,2,489959.51,NULL,'2023-04-19 22:57:19','2023-04-19 22:57:57','2023-04-19 22:57:57'),(1253,7562,277,40720,1527,10,435,1,131365.22,NULL,'2023-04-19 22:57:19','2023-04-19 22:57:57','2023-04-19 22:57:57'),(1254,7562,277,40720,1527,10,204,1,2400.00,NULL,'2023-04-19 22:57:19','2023-04-19 22:57:57','2023-04-19 22:57:57'),(1255,7562,277,40720,1527,10,63,1,338873.96,NULL,'2023-04-19 22:57:19','2023-04-19 22:57:57','2023-04-19 22:57:57'),(1256,7562,277,40720,1527,10,141,1,17320.33,NULL,'2023-04-19 22:57:19','2023-04-19 22:57:57','2023-04-19 22:57:57'),(1257,7562,278,40720,1522,10,482,2,489959.51,NULL,'2023-04-19 22:57:57','2023-04-19 23:07:16','2023-04-19 23:07:16'),(1258,7562,278,40720,1522,10,435,1,131365.22,NULL,'2023-04-19 22:57:57','2023-04-19 23:07:16','2023-04-19 23:07:16'),(1259,7562,278,40720,1522,10,204,1,2400.00,NULL,'2023-04-19 22:57:57','2023-04-19 23:07:16','2023-04-19 23:07:16'),(1260,7562,278,40720,1522,10,63,1,338873.96,NULL,'2023-04-19 22:57:57','2023-04-19 23:07:16','2023-04-19 23:07:16'),(1261,7562,278,40720,1522,10,141,1,17320.33,NULL,'2023-04-19 22:57:57','2023-04-19 23:07:16','2023-04-19 23:07:16'),(1262,7562,279,40720,1522,10,482,2,131240.96,NULL,'2023-04-19 23:01:51','2023-04-19 23:01:51',NULL),(1263,7562,279,40720,1522,10,63,1,101674.07,NULL,'2023-04-19 23:01:51','2023-04-19 23:01:51',NULL),(1264,7562,279,40720,1522,10,435,1,15594.72,NULL,'2023-04-19 23:01:51','2023-04-19 23:01:51',NULL),(1265,7562,279,40720,1522,10,141,1,13972.17,NULL,'2023-04-19 23:01:51','2023-04-19 23:01:51',NULL),(1266,7562,280,40720,1523,10,482,2,148761.28,NULL,'2023-04-19 23:04:33','2023-04-19 23:04:33',NULL),(1267,7562,280,40720,1523,10,435,1,18228.97,NULL,'2023-04-19 23:04:33','2023-04-19 23:04:33',NULL),(1268,7562,280,40720,1523,10,63,1,117786.30,NULL,'2023-04-19 23:04:33','2023-04-19 23:04:33',NULL);
INSERT INTO `balance_libro_details` VALUES (1269,7562,280,40720,1523,10,141,1,12746.01,NULL,'2023-04-19 23:04:33','2023-04-19 23:04:33',NULL),(1270,7562,281,40720,1526,10,482,2,109246.16,NULL,'2023-04-19 23:06:36','2023-04-19 23:06:36',NULL),(1271,7562,281,40720,1526,10,435,1,13386.83,NULL,'2023-04-19 23:06:36','2023-04-19 23:06:36',NULL),(1272,7562,281,40720,1526,10,63,1,82920.84,NULL,'2023-04-19 23:06:36','2023-04-19 23:06:36',NULL),(1273,7562,281,40720,1526,10,141,1,12938.49,NULL,'2023-04-19 23:06:36','2023-04-19 23:06:36',NULL),(1274,7562,282,40720,1522,10,482,2,489959.51,NULL,'2023-04-19 23:07:16','2023-04-19 23:07:50','2023-04-19 23:07:50'),(1275,7562,282,40720,1522,10,435,1,131365.22,NULL,'2023-04-19 23:07:16','2023-04-19 23:07:50','2023-04-19 23:07:50'),(1276,7562,282,40720,1522,10,204,1,2400.00,NULL,'2023-04-19 23:07:16','2023-04-19 23:07:50','2023-04-19 23:07:50'),(1277,7562,282,40720,1522,10,63,1,338873.96,NULL,'2023-04-19 23:07:16','2023-04-19 23:07:50','2023-04-19 23:07:50'),(1278,7562,282,40720,1522,10,141,1,17320.33,NULL,'2023-04-19 23:07:16','2023-04-19 23:07:50','2023-04-19 23:07:50'),(1279,7562,283,40720,1522,10,482,2,489959.51,NULL,'2023-04-19 23:07:50','2023-04-19 23:07:50',NULL),(1280,7562,283,40720,1522,10,435,1,131365.22,NULL,'2023-04-19 23:07:50','2023-04-19 23:07:50',NULL),(1281,7562,283,40720,1522,10,204,1,2400.00,NULL,'2023-04-19 23:07:50','2023-04-19 23:07:50',NULL),(1282,7562,283,40720,1522,10,63,1,338873.96,NULL,'2023-04-19 23:07:50','2023-04-19 23:07:50',NULL),(1283,7562,283,40720,1522,10,141,1,17320.33,NULL,'2023-04-19 23:07:50','2023-04-19 23:07:50',NULL),(1284,7562,284,40720,1527,10,67,1,102372.51,NULL,'2023-04-20 15:22:36','2023-04-20 15:23:17','2023-04-20 15:23:17'),(1285,7562,284,40720,1527,10,68,2,18899.25,NULL,'2023-04-20 15:22:36','2023-04-20 15:23:17','2023-04-20 15:23:17'),(1286,7562,284,40720,1527,10,25,2,330.79,NULL,'2023-04-20 15:22:36','2023-04-20 15:23:17','2023-04-20 15:23:17'),(1287,7562,284,40720,1527,10,410,2,83142.47,NULL,'2023-04-20 15:22:36','2023-04-20 15:23:17','2023-04-20 15:23:17'),(1288,7562,285,40720,1527,10,67,1,102372.51,NULL,'2023-04-20 15:23:17','2023-04-20 16:05:00','2023-04-20 16:05:00'),(1289,7562,285,40720,1527,10,68,2,18899.25,NULL,'2023-04-20 15:23:17','2023-04-20 16:05:00','2023-04-20 16:05:00'),(1290,7562,285,40720,1527,10,25,2,330.79,NULL,'2023-04-20 15:23:17','2023-04-20 16:05:00','2023-04-20 16:05:00'),(1291,7562,285,40720,1527,10,410,2,60306.93,NULL,'2023-04-20 15:23:17','2023-04-20 16:05:00','2023-04-20 16:05:00'),(1292,7562,285,40720,1527,10,74,2,22835.54,NULL,'2023-04-20 15:23:17','2023-04-20 16:05:00','2023-04-20 16:05:00'),(1293,7562,286,40720,1515,3,288,1,23782.82,NULL,'2023-04-20 15:31:23','2023-04-20 15:31:23',NULL),(1294,7562,286,40720,1515,3,263,2,24135.74,NULL,'2023-04-20 15:31:23','2023-04-20 15:31:23',NULL),(1295,7562,286,40720,1515,3,313,1,352.92,NULL,'2023-04-20 15:31:23','2023-04-20 15:31:23',NULL),(1296,7562,287,40720,1516,3,288,1,30638.13,NULL,'2023-04-20 15:32:59','2023-04-20 15:32:59',NULL),(1297,7562,287,40720,1516,3,263,2,30651.53,NULL,'2023-04-20 15:32:59','2023-04-20 15:32:59',NULL),(1298,7562,287,40720,1516,3,313,1,13.40,NULL,'2023-04-20 15:32:59','2023-04-20 15:32:59',NULL),(1299,7562,288,40720,1517,3,288,1,34172.84,NULL,'2023-04-20 15:33:57','2023-04-20 15:33:57',NULL),(1300,7562,288,40720,1517,3,263,2,34644.74,NULL,'2023-04-20 15:33:57','2023-04-20 15:33:57',NULL),(1301,7562,288,40720,1517,3,313,1,471.90,NULL,'2023-04-20 15:33:57','2023-04-20 15:33:57',NULL),(1302,7562,289,40720,1518,3,288,1,25526.93,NULL,'2023-04-20 15:35:01','2023-04-20 15:35:01',NULL),(1303,7562,289,40720,1518,3,263,2,25585.21,NULL,'2023-04-20 15:35:01','2023-04-20 15:35:01',NULL),(1304,7562,289,40720,1518,3,313,1,58.28,NULL,'2023-04-20 15:35:01','2023-04-20 15:35:01',NULL),(1305,7562,290,40720,1519,3,263,2,31924.56,NULL,'2023-04-20 15:36:03','2023-04-20 15:36:03',NULL),(1306,7562,290,40720,1519,3,288,1,33260.08,NULL,'2023-04-20 15:36:03','2023-04-20 15:36:03',NULL);
INSERT INTO `balance_libro_details` VALUES (1307,7562,290,40720,1519,3,313,2,1335.52,NULL,'2023-04-20 15:36:03','2023-04-20 15:36:03',NULL),(1308,7562,291,40720,1520,3,288,1,26879.31,NULL,'2023-04-20 15:37:18','2023-04-20 15:37:18',NULL),(1309,7562,291,40720,1520,3,263,2,28400.13,NULL,'2023-04-20 15:37:18','2023-04-20 15:37:18',NULL),(1310,7562,291,40720,1520,3,313,1,1520.82,NULL,'2023-04-20 15:37:18','2023-04-20 15:37:18',NULL),(1311,7562,292,40720,1522,3,288,1,32622.87,NULL,'2023-04-20 15:38:15','2023-04-20 15:38:15',NULL),(1312,7562,292,40720,1522,3,263,2,30944.49,NULL,'2023-04-20 15:38:15','2023-04-20 15:38:15',NULL),(1313,7562,292,40720,1522,3,313,2,1678.38,NULL,'2023-04-20 15:38:15','2023-04-20 15:38:15',NULL),(1314,7562,293,40720,1523,3,288,1,33558.39,NULL,'2023-04-20 15:39:50','2023-04-20 15:39:50',NULL),(1315,7562,293,40720,1523,3,263,2,35654.27,NULL,'2023-04-20 15:39:50','2023-04-20 15:39:50',NULL),(1316,7562,293,40720,1523,3,313,1,2095.88,NULL,'2023-04-20 15:39:50','2023-04-20 15:39:50',NULL),(1317,7562,294,40720,1524,3,288,1,31749.34,NULL,'2023-04-20 15:40:46','2023-04-20 15:40:46',NULL),(1318,7562,294,40720,1524,3,263,2,32110.44,NULL,'2023-04-20 15:40:46','2023-04-20 15:40:46',NULL),(1319,7562,294,40720,1524,3,313,1,361.10,NULL,'2023-04-20 15:40:46','2023-04-20 15:40:46',NULL),(1320,7562,295,40720,1525,3,288,1,40363.70,NULL,'2023-04-20 15:41:41','2023-04-20 15:41:41',NULL),(1321,7562,295,40720,1525,3,263,2,39573.44,NULL,'2023-04-20 15:41:41','2023-04-20 15:41:41',NULL),(1322,7562,295,40720,1525,3,313,2,790.26,NULL,'2023-04-20 15:41:41','2023-04-20 15:41:41',NULL),(1323,7562,296,40720,1526,3,288,1,32534.26,NULL,'2023-04-20 15:42:43','2023-04-20 15:42:43',NULL),(1324,7562,296,40720,1526,3,263,2,31715.27,NULL,'2023-04-20 15:42:43','2023-04-20 15:42:43',NULL),(1325,7562,296,40720,1526,3,313,2,818.99,NULL,'2023-04-20 15:42:43','2023-04-20 15:42:43',NULL),(1326,7562,297,40720,1527,3,288,1,36544.77,NULL,'2023-04-20 15:43:48','2023-04-20 15:48:46','2023-04-20 15:48:46'),(1327,7562,297,40720,1527,3,263,2,38676.25,NULL,'2023-04-20 15:43:48','2023-04-20 15:48:46','2023-04-20 15:48:46'),(1328,7562,297,40720,1527,3,313,1,2131.48,NULL,'2023-04-20 15:43:48','2023-04-20 15:48:46','2023-04-20 15:48:46'),(1329,7562,298,40720,1527,3,288,1,36480.60,NULL,'2023-04-20 15:48:46','2023-04-20 15:48:46',NULL),(1330,7562,298,40720,1527,3,263,2,38676.25,NULL,'2023-04-20 15:48:46','2023-04-20 15:48:46',NULL),(1331,7562,298,40720,1527,3,313,1,2195.65,NULL,'2023-04-20 15:48:46','2023-04-20 15:48:46',NULL),(1332,7562,299,40720,1527,19,483,1,42124.30,NULL,'2023-04-20 15:53:24','2023-04-20 15:53:24',NULL),(1333,7562,299,40720,1527,19,359,2,42124.30,NULL,'2023-04-20 15:53:24','2023-04-20 15:53:24',NULL),(1334,7562,300,40720,1527,11,486,2,170.45,NULL,'2023-04-20 15:57:55','2023-04-20 15:57:55',NULL),(1335,7562,300,40720,1527,11,485,2,7072.44,NULL,'2023-04-20 15:57:55','2023-04-20 15:57:55',NULL),(1336,7562,300,40720,1527,11,191,1,7242.89,NULL,'2023-04-20 15:57:55','2023-04-20 15:57:55',NULL),(1337,7562,301,40720,1527,10,448,1,332753.43,NULL,'2023-04-20 16:02:14','2023-04-20 16:18:58','2023-04-20 16:18:58'),(1338,7562,301,40720,1527,10,410,2,332753.43,NULL,'2023-04-20 16:02:14','2023-04-20 16:18:58','2023-04-20 16:18:58'),(1339,7562,301,40720,1527,10,435,2,91155.22,NULL,'2023-04-20 16:02:14','2023-04-20 16:18:58','2023-04-20 16:18:58'),(1340,7562,301,40720,1527,10,141,1,91155.22,NULL,'2023-04-20 16:02:14','2023-04-20 16:18:58','2023-04-20 16:18:58'),(1341,7562,302,40720,1527,10,67,1,102372.52,NULL,'2023-04-20 16:05:00','2023-04-20 16:05:00',NULL),(1342,7562,302,40720,1527,10,68,2,18899.25,NULL,'2023-04-20 16:05:00','2023-04-20 16:05:00',NULL),(1343,7562,302,40720,1527,10,25,2,330.79,NULL,'2023-04-20 16:05:00','2023-04-20 16:05:00',NULL),(1344,7562,302,40720,1527,10,410,2,60306.94,NULL,'2023-04-20 16:05:00','2023-04-20 16:05:00',NULL),(1345,7562,302,40720,1527,10,74,2,22835.54,NULL,'2023-04-20 16:05:00','2023-04-20 16:05:00',NULL);
INSERT INTO `balance_libro_details` VALUES (1346,7562,303,40720,1519,10,79,1,103268.78,NULL,'2023-04-20 16:05:55','2023-04-20 16:05:55',NULL),(1347,7562,303,40720,1519,10,23,2,107858.83,NULL,'2023-04-20 16:05:55','2023-04-20 16:05:55',NULL),(1348,7562,303,40720,1519,10,24,1,4590.05,NULL,'2023-04-20 16:05:55','2023-04-20 16:05:55',NULL),(1349,7562,303,40720,1519,10,23,2,97734.24,NULL,'2023-04-20 16:05:55','2023-04-20 16:05:55',NULL),(1350,7562,303,40720,1519,10,437,2,30541.97,NULL,'2023-04-20 16:05:55','2023-04-20 16:05:55',NULL),(1351,7562,303,40720,1519,10,396,1,30541.97,NULL,'2023-04-20 16:05:55','2023-04-20 16:05:55',NULL),(1352,7562,303,40720,1519,10,24,1,97734.24,NULL,'2023-04-20 16:05:55','2023-04-20 16:05:55',NULL),(1353,7562,304,40720,1527,21,57,1,2982258.44,NULL,'2023-04-20 16:16:26','2023-04-20 16:16:26',NULL),(1354,7562,304,40720,1527,21,410,2,2982258.44,NULL,'2023-04-20 16:16:26','2023-04-20 16:16:26',NULL),(1355,7562,305,40720,1527,10,410,2,332753.43,NULL,'2023-04-20 16:18:58','2023-04-20 16:18:58',NULL),(1356,7562,305,40720,1527,10,435,2,91155.22,NULL,'2023-04-20 16:18:58','2023-04-20 16:18:58',NULL),(1357,7562,305,40720,1527,10,141,1,91155.22,NULL,'2023-04-20 16:18:58','2023-04-20 16:18:58',NULL),(1358,7562,305,40720,1527,10,482,1,332753.43,NULL,'2023-04-20 16:18:58','2023-04-20 16:18:58',NULL),(1359,7562,306,40720,1527,18,13,1,312769.41,NULL,'2023-04-20 16:25:53','2023-04-20 16:25:53',NULL),(1360,7562,306,40720,1527,18,410,2,312769.41,NULL,'2023-04-20 16:25:53','2023-04-20 16:25:53',NULL),(1361,7562,307,40720,1515,2,410,1,147510.00,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1362,7562,307,40720,1515,2,487,2,147510.00,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1363,7562,308,40720,1515,3,488,1,47565.63,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1364,7562,308,40720,1515,3,410,2,47565.63,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1365,7562,309,40720,1516,3,488,1,61276.25,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1366,7562,309,40720,1516,3,410,2,61276.25,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1367,7562,310,40720,1517,2,410,1,148299.00,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1368,7562,310,40720,1517,2,487,2,148299.00,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1369,7562,311,40720,1517,3,488,1,68345.68,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1370,7562,311,40720,1517,3,410,2,68345.68,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1371,7562,312,40720,1518,3,488,1,51053.86,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1372,7562,312,40720,1518,3,410,2,51053.86,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1373,7562,313,40720,1519,2,410,1,147914.00,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1374,7562,313,40720,1519,2,487,2,147914.00,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1375,7562,314,40720,1519,3,488,1,66520.17,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1376,7562,314,40720,1519,3,410,2,66520.17,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1377,7562,315,40720,1520,2,410,1,145617.00,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1378,7562,315,40720,1520,2,487,2,145617.00,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1379,7562,316,40720,1520,3,488,1,53758.62,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1380,7562,316,40720,1520,3,410,2,53758.62,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1381,7562,317,40720,1522,2,410,1,127001.00,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1382,7562,317,40720,1522,2,487,2,127001.00,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1383,7562,318,40720,1522,3,488,1,65245.74,NULL,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(1384,7562,318,40720,1522,3,410,2,65245.74,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1385,7562,319,40720,1523,2,410,1,166821.00,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL);
INSERT INTO `balance_libro_details` VALUES (1386,7562,319,40720,1523,2,487,2,166821.00,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1387,7562,320,40720,1523,3,488,1,67116.17,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1388,7562,320,40720,1523,3,410,2,67116.17,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1389,7562,321,40720,1524,2,410,1,144281.00,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1390,7562,321,40720,1524,2,487,2,144281.00,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1391,7562,322,40720,1524,3,488,1,63498.68,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1392,7562,322,40720,1524,3,410,2,63498.68,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1393,7562,323,40720,1540,2,410,1,161299.00,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1394,7562,323,40720,1540,2,487,2,161299.00,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1395,7562,324,40720,1540,3,488,1,80727.41,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1396,7562,324,40720,1540,3,410,2,80727.41,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1397,7562,325,40720,1541,3,488,1,65068.53,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1398,7562,325,40720,1541,3,410,2,65068.53,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1399,7562,326,40720,1542,3,488,1,73089.54,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1400,7562,326,40720,1542,3,410,2,73089.54,NULL,'2023-04-21 11:33:45','2023-04-21 11:33:45',NULL),(1401,7562,327,40720,1527,19,416,1,1208258.73,NULL,'2023-04-21 14:41:47','2023-04-21 14:41:47',NULL),(1402,7562,327,40720,1527,19,359,1,87096.30,NULL,'2023-04-21 14:41:47','2023-04-21 14:41:47',NULL),(1403,7562,327,40720,1527,19,410,2,1295355.03,NULL,'2023-04-21 14:41:47','2023-04-21 14:41:47',NULL),(1404,7562,328,40720,1519,13,383,2,919695.70,NULL,'2023-04-21 15:07:15','2023-04-21 15:07:15',NULL),(1405,7562,328,40720,1519,13,92,1,919695.70,NULL,'2023-04-21 15:07:15','2023-04-21 15:07:15',NULL),(1406,7562,329,40720,1527,11,489,1,8036518.14,NULL,'2023-04-21 16:09:36','2023-04-21 16:09:36',NULL),(1407,7562,329,40720,1527,11,392,1,1000000.00,NULL,'2023-04-21 16:09:36','2023-04-21 16:09:36',NULL),(1408,7562,329,40720,1527,11,110,2,5129571.55,NULL,'2023-04-21 16:09:36','2023-04-21 16:09:36',NULL),(1409,7562,329,40720,1527,11,191,2,641075.00,NULL,'2023-04-21 16:09:36','2023-04-21 16:09:36',NULL),(1410,7562,329,40720,1527,11,416,2,2247995.72,NULL,'2023-04-21 16:09:36','2023-04-21 16:09:36',NULL),(1411,7562,329,40720,1527,11,193,2,26178.24,NULL,'2023-04-21 16:09:36','2023-04-21 16:09:36',NULL),(1412,7562,329,40720,1527,11,135,2,403577.91,NULL,'2023-04-21 16:09:36','2023-04-21 16:09:36',NULL),(1413,7562,329,40720,1527,11,409,2,206550.45,NULL,'2023-04-21 16:09:36','2023-04-21 16:09:36',NULL),(1414,7562,329,40720,1527,11,288,2,381569.27,NULL,'2023-04-21 16:09:36','2023-04-21 16:09:36',NULL),(1415,7562,330,40720,1527,23,409,1,59271.68,NULL,'2023-04-21 16:25:24','2023-04-21 16:25:24',NULL),(1416,7562,330,40720,1527,23,217,1,677328.92,NULL,'2023-04-21 16:25:24','2023-04-21 16:25:24',NULL),(1417,7562,330,40720,1527,23,96,2,200153.01,NULL,'2023-04-21 16:25:24','2023-04-21 16:25:24',NULL),(1418,7562,330,40720,1527,23,110,1,1401598.80,NULL,'2023-04-21 16:25:24','2023-04-21 16:25:24',NULL),(1419,7562,330,40720,1527,23,92,2,771711.95,NULL,'2023-04-21 16:25:24','2023-04-21 16:25:24',NULL),(1420,7562,330,40720,1527,23,488,1,214388.23,NULL,'2023-04-21 16:25:24','2023-04-21 16:25:24',NULL),(1421,7562,330,40720,1527,23,88,2,662992.86,NULL,'2023-04-21 16:25:24','2023-04-21 16:25:24',NULL),(1422,7562,330,40720,1527,23,288,1,113200.70,NULL,'2023-04-21 16:25:24','2023-04-21 16:25:24',NULL),(1423,7562,330,40720,1527,23,416,1,648994.43,NULL,'2023-04-21 16:25:25','2023-04-21 16:25:25',NULL),(1424,7562,330,40720,1527,23,135,1,95772.95,NULL,'2023-04-21 16:25:25','2023-04-21 16:25:25',NULL),(1425,7562,330,40720,1527,23,218,2,2629864.40,NULL,'2023-04-21 16:25:25','2023-04-21 16:25:25',NULL);
INSERT INTO `balance_libro_details` VALUES (1426,7562,330,40720,1527,23,191,1,176120.05,NULL,'2023-04-21 16:25:25','2023-04-21 16:25:25',NULL),(1427,7562,330,40720,1527,23,383,1,163988.45,NULL,'2023-04-21 16:25:25','2023-04-21 16:25:25',NULL),(1428,7562,330,40720,1527,23,381,2,42388.23,NULL,'2023-04-21 16:25:25','2023-04-21 16:25:25',NULL),(1429,7562,330,40720,1527,23,487,2,381877.51,NULL,'2023-04-21 16:25:25','2023-04-21 16:25:25',NULL),(1430,7562,330,40720,1527,23,88,2,59210.98,NULL,'2023-04-21 16:25:25','2023-04-21 16:25:25',NULL),(1431,7562,330,40720,1527,23,193,1,4993.84,NULL,'2023-04-21 16:25:26','2023-04-21 16:25:26',NULL),(1432,7562,330,40720,1527,23,141,1,13619.72,NULL,'2023-04-21 16:25:26','2023-04-21 16:25:26',NULL),(1433,7562,330,40720,1527,23,204,1,745.73,NULL,'2023-04-21 16:25:26','2023-04-21 16:25:26',NULL),(1434,7562,330,40720,1527,23,396,1,12638.34,NULL,'2023-04-21 16:25:26','2023-04-21 16:25:26',NULL),(1435,7562,330,40720,1527,23,476,1,1165537.10,NULL,'2023-04-21 16:25:26','2023-04-21 16:25:26',NULL),(1436,7562,331,40720,1540,2,218,2,9983.00,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(1437,7562,331,40720,1540,2,13,1,9983.00,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(1438,7562,332,40720,1540,2,218,2,2760.00,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(1439,7562,332,40720,1540,2,13,1,2760.00,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(1440,7562,333,40720,1540,2,96,2,3966.95,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(1441,7562,333,40720,1540,2,67,2,833.06,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(1442,7562,333,40720,1540,2,218,2,0.01,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(1443,7562,333,40720,1540,2,218,2,3720.00,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(1444,7562,333,40720,1540,2,13,1,8520.02,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(1445,7562,334,40720,1540,2,218,2,1504693.33,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(1446,7562,334,40720,1540,2,96,2,183292.10,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(1447,7562,334,40720,1540,2,67,2,19245.67,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(1448,7562,334,40720,1540,2,13,1,1707231.10,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(1449,7562,335,40720,1540,2,218,2,2190.00,NULL,'2023-05-17 11:08:58','2023-05-17 11:08:58',NULL),(1450,7562,335,40720,1540,2,13,1,2190.00,NULL,'2023-05-17 11:08:58','2023-05-17 11:08:58',NULL),(1451,7562,336,40720,1540,2,218,2,16000.00,NULL,'2023-05-17 11:08:58','2023-05-17 11:08:58',NULL),(1452,7562,336,40720,1540,2,13,1,16000.00,NULL,'2023-05-17 11:08:58','2023-05-17 11:08:58',NULL),(1453,7562,337,40720,1540,3,217,1,173932.62,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(1454,7562,337,40720,1540,3,57,2,173932.62,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(1455,7562,338,40720,1540,3,250,1,22265.11,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(1456,7562,338,40720,1540,3,68,1,4675.67,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(1457,7562,338,40720,1540,3,57,2,26940.78,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(1458,7562,339,40720,1540,3,250,1,1292.50,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(1459,7562,339,40720,1540,3,68,1,271.43,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(1460,7562,339,40720,1540,3,57,2,1563.93,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(1461,7562,340,40720,1540,3,217,1,23000.00,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(1462,7562,340,40720,1540,3,57,2,23000.00,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(1463,7562,341,40720,1540,3,237,1,422.70,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1464,7562,341,40720,1540,3,220,1,215.39,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1465,7562,341,40720,1540,3,250,1,6611.00,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1466,7562,341,40720,1540,3,68,1,1388.31,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL);
INSERT INTO `balance_libro_details` VALUES (1467,7562,341,40720,1540,3,250,1,568.66,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1468,7562,341,40720,1540,3,68,1,153.54,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1469,7562,341,40720,1540,3,57,2,9359.60,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1470,7562,342,40720,1540,3,250,1,61676.88,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1471,7562,342,40720,1540,3,57,2,61676.88,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1472,7562,343,40720,1540,3,250,1,39319.29,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1473,7562,343,40720,1540,3,68,1,8257.05,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1474,7562,343,40720,1540,3,57,2,47576.34,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1475,7562,344,40720,1540,3,250,1,13078.00,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1476,7562,344,40720,1540,3,68,1,2746.38,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1477,7562,344,40720,1540,3,57,2,15824.38,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1478,7562,345,40720,1540,3,250,1,9634.97,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1479,7562,345,40720,1540,3,68,1,2023.34,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1480,7562,345,40720,1540,3,57,2,11658.31,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1481,7562,346,40720,1540,3,250,1,5853.40,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1482,7562,346,40720,1540,3,68,1,1229.21,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1483,7562,346,40720,1540,3,57,2,7082.61,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1484,7562,347,40720,1540,3,250,1,37711.82,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1485,7562,347,40720,1540,3,68,1,7919.48,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1486,7562,347,40720,1540,3,57,2,45631.30,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1487,7562,348,40720,1540,3,217,1,37000.00,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1488,7562,348,40720,1540,3,57,2,37000.00,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1489,7562,349,40720,1540,3,250,1,7657.64,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1490,7562,349,40720,1540,3,68,1,1608.10,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1491,7562,349,40720,1540,3,57,2,9265.74,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1492,7562,350,40720,1540,3,250,1,8966.91,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1493,7562,350,40720,1540,3,68,1,1883.05,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1494,7562,350,40720,1540,3,57,2,10849.96,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(1495,7562,351,40740,4624,2,96,2,1652.89,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1496,7562,351,40740,4624,2,67,2,347.11,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1497,7562,351,40740,4624,2,13,1,2000.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1498,7562,352,40740,4624,2,96,2,4545.45,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1499,7562,352,40740,4624,2,67,2,954.55,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1500,7562,352,40740,4624,2,13,1,5500.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1501,7562,353,40740,4624,2,96,2,6528.93,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1502,7562,353,40740,4624,2,67,2,1371.07,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1503,7562,353,40740,4624,2,13,1,7900.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1504,7562,354,40740,4624,2,96,2,4049.59,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1505,7562,354,40740,4624,2,67,2,850.41,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1506,7562,354,40740,4624,2,13,1,4900.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1507,7562,355,40740,4624,2,96,2,5041.32,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL);
INSERT INTO `balance_libro_details` VALUES (1508,7562,355,40740,4624,2,67,2,1058.68,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1509,7562,355,40740,4624,2,13,1,6100.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1510,7562,356,40740,4624,2,96,2,5702.48,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1511,7562,356,40740,4624,2,67,2,1197.52,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1512,7562,356,40740,4624,2,13,1,6900.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1513,7562,357,40740,4624,2,96,2,21289.26,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1514,7562,357,40740,4624,2,67,2,4470.74,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1515,7562,357,40740,4624,2,13,1,25760.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1516,7562,358,40740,4624,2,96,2,2644.63,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1517,7562,358,40740,4624,2,67,2,555.37,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1518,7562,358,40740,4624,2,13,1,3200.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1519,7562,359,40740,4624,2,96,2,4561.98,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1520,7562,359,40740,4624,2,67,2,958.02,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1521,7562,359,40740,4624,2,13,1,5520.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1522,7562,360,40740,4624,2,96,2,1652.89,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1523,7562,360,40740,4624,2,67,2,347.11,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1524,7562,360,40740,4624,2,13,1,2000.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1525,7562,361,40740,4624,2,96,2,21859.50,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1526,7562,361,40740,4624,2,67,2,4590.50,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1527,7562,361,40740,4624,2,13,1,26450.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1528,7562,362,40740,4624,2,96,2,8925.62,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1529,7562,362,40740,4624,2,67,2,1874.38,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1530,7562,362,40740,4624,2,13,1,10800.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1531,7562,363,40740,4624,2,96,2,20578.51,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1532,7562,363,40740,4624,2,67,2,4321.49,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1533,7562,363,40740,4624,2,13,1,24900.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1534,7562,364,40740,4624,2,96,2,4132.23,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1535,7562,364,40740,4624,2,67,2,867.77,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1536,7562,364,40740,4624,2,13,1,5000.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1537,7562,365,40740,4624,2,96,2,8264.46,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1538,7562,365,40740,4624,2,67,2,1735.54,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1539,7562,365,40740,4624,2,13,1,10000.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1540,7562,366,40740,4624,2,96,2,5702.48,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1541,7562,366,40740,4624,2,67,2,1197.52,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1542,7562,366,40740,4624,2,13,1,6900.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1543,7562,367,40740,4624,2,96,2,4132.23,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1544,7562,367,40740,4624,2,67,2,867.77,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1545,7562,367,40740,4624,2,13,1,5000.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1546,7562,368,40740,4624,2,96,2,4338.84,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1547,7562,368,40740,4624,2,67,2,911.16,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1548,7562,368,40740,4624,2,13,1,5250.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL);
INSERT INTO `balance_libro_details` VALUES (1549,7562,369,40740,4624,2,96,2,5619.83,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1550,7562,369,40740,4624,2,67,2,1180.17,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1551,7562,369,40740,4624,2,13,1,6800.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1552,7562,370,40740,4624,2,96,2,5619.83,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1553,7562,370,40740,4624,2,67,2,1180.17,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1554,7562,370,40740,4624,2,13,1,6800.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1555,7562,371,40740,4624,2,96,2,7355.37,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1556,7562,371,40740,4624,2,67,2,1544.63,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1557,7562,371,40740,4624,2,13,1,8900.00,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(1558,7562,372,40740,4624,2,96,2,8074.38,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1559,7562,372,40740,4624,2,67,2,1695.62,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1560,7562,372,40740,4624,2,13,1,9770.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1561,7562,373,40740,4624,2,96,2,4297.52,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1562,7562,373,40740,4624,2,67,2,902.48,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1563,7562,373,40740,4624,2,13,1,5200.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1564,7562,374,40740,4624,2,96,2,4561.98,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1565,7562,374,40740,4624,2,67,2,958.02,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1566,7562,374,40740,4624,2,13,1,5520.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1567,7562,375,40740,4624,2,96,2,5619.83,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1568,7562,375,40740,4624,2,67,2,1180.17,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1569,7562,375,40740,4624,2,13,1,6800.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1570,7562,376,40740,4624,2,96,2,7355.37,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1571,7562,376,40740,4624,2,67,2,1544.63,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1572,7562,376,40740,4624,2,13,1,8900.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1573,7562,377,40740,4624,2,96,2,8074.38,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1574,7562,377,40740,4624,2,67,2,1695.62,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1575,7562,377,40740,4624,2,13,1,9770.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1576,7562,378,40740,4624,2,96,2,3140.50,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1577,7562,378,40740,4624,2,67,2,659.50,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1578,7562,378,40740,4624,2,13,1,3800.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1579,7562,379,40740,4624,2,96,2,4132.23,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1580,7562,379,40740,4624,2,67,2,867.77,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1581,7562,379,40740,4624,2,13,1,5000.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1582,7562,380,40740,4624,2,96,2,2809.92,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1583,7562,380,40740,4624,2,67,2,590.08,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1584,7562,380,40740,4624,2,13,1,3400.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1585,7562,381,40740,4624,2,96,2,9504.13,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1586,7562,381,40740,4624,2,67,2,1995.87,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1587,7562,381,40740,4624,2,13,1,11500.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1588,7562,382,40740,4624,2,96,2,6694.21,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1589,7562,382,40740,4624,2,67,2,1405.79,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL);
INSERT INTO `balance_libro_details` VALUES (1590,7562,382,40740,4624,2,13,1,8100.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1591,7562,383,40740,4624,2,96,2,2809.92,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1592,7562,383,40740,4624,2,67,2,590.08,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1593,7562,383,40740,4624,2,13,1,3400.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1594,7562,384,40740,4624,2,96,2,12925.62,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1595,7562,384,40740,4624,2,67,2,2714.38,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1596,7562,384,40740,4624,2,13,1,15640.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1597,7562,385,40740,4624,2,96,2,7123.97,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1598,7562,385,40740,4624,2,67,2,1496.03,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1599,7562,385,40740,4624,2,13,1,8620.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1600,7562,386,40740,4624,2,96,2,3801.65,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1601,7562,386,40740,4624,2,67,2,798.35,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1602,7562,386,40740,4624,2,13,1,4600.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1603,7562,387,40740,4624,2,96,2,3801.65,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1604,7562,387,40740,4624,2,67,2,798.35,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1605,7562,387,40740,4624,2,13,1,4600.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1606,7562,388,40740,4624,2,96,2,2809.92,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1607,7562,388,40740,4624,2,67,2,590.08,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1608,7562,388,40740,4624,2,13,1,3400.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1609,7562,389,40740,4624,2,96,2,5950.41,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1610,7562,389,40740,4624,2,67,2,1249.59,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1611,7562,389,40740,4624,2,13,1,7200.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1612,7562,390,40740,4624,2,96,2,4710.74,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1613,7562,390,40740,4624,2,67,2,989.26,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1614,7562,390,40740,4624,2,13,1,5700.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1615,7562,391,40740,4624,2,96,2,8264.46,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1616,7562,391,40740,4624,2,67,2,1735.54,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1617,7562,391,40740,4624,2,13,1,10000.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1618,7562,392,40740,4624,2,96,2,4132.23,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1619,7562,392,40740,4624,2,67,2,867.77,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1620,7562,392,40740,4624,2,13,1,5000.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1621,7562,393,40740,4624,2,96,2,4132.23,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1622,7562,393,40740,4624,2,67,2,867.77,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1623,7562,393,40740,4624,2,13,1,5000.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1624,7562,394,40740,4624,2,96,2,5785.12,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1625,7562,394,40740,4624,2,67,2,1214.88,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1626,7562,394,40740,4624,2,13,1,7000.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1627,7562,395,40740,4624,2,96,2,14876.03,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1628,7562,395,40740,4624,2,67,2,3123.97,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1629,7562,395,40740,4624,2,13,1,18000.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1630,7562,396,40740,4624,2,96,2,15371.90,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL);
INSERT INTO `balance_libro_details` VALUES (1631,7562,396,40740,4624,2,67,2,3228.10,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1632,7562,396,40740,4624,2,13,1,18600.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1633,7562,397,40740,4624,2,96,2,3966.94,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1634,7562,397,40740,4624,2,67,2,833.06,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1635,7562,397,40740,4624,2,13,1,4800.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1636,7562,398,40740,4624,2,96,2,4628.10,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1637,7562,398,40740,4624,2,67,2,971.90,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1638,7562,398,40740,4624,2,13,1,5600.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1639,7562,399,40740,4624,2,96,2,15206.61,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1640,7562,399,40740,4624,2,67,2,3193.39,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1641,7562,399,40740,4624,2,13,1,18400.00,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(1642,7562,400,40740,4624,2,96,2,9504.13,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1643,7562,400,40740,4624,2,67,2,1995.87,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1644,7562,400,40740,4624,2,13,1,11500.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1645,7562,401,40740,4624,2,96,2,11404.96,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1646,7562,401,40740,4624,2,67,2,2395.04,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1647,7562,401,40740,4624,2,13,1,13800.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1648,7562,402,40740,4624,2,96,2,5603.31,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1649,7562,402,40740,4624,2,67,2,1176.69,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1650,7562,402,40740,4624,2,13,1,6780.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1651,7562,403,40740,4624,2,96,2,4371.90,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1652,7562,403,40740,4624,2,67,2,918.10,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1653,7562,403,40740,4624,2,13,1,5290.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1654,7562,404,40740,4624,2,96,2,5603.31,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1655,7562,404,40740,4624,2,67,2,1176.69,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1656,7562,404,40740,4624,2,13,1,6780.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1657,7562,405,40740,4624,2,96,2,25289.26,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1658,7562,405,40740,4624,2,67,2,5310.74,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1659,7562,405,40740,4624,2,13,1,30600.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1660,7562,406,40740,4624,2,96,2,8264.46,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1661,7562,406,40740,4624,2,67,2,1735.54,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1662,7562,406,40740,4624,2,13,1,10000.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1663,7562,407,40740,4624,2,96,2,4652.89,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1664,7562,407,40740,4624,2,67,2,977.11,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1665,7562,407,40740,4624,2,13,1,5630.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1666,7562,408,40740,4624,2,96,2,3140.50,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1667,7562,408,40740,4624,2,67,2,659.50,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1668,7562,408,40740,4624,2,13,1,3800.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1669,7562,409,40740,4624,2,96,2,12396.69,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1670,7562,409,40740,4624,2,67,2,2603.31,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1671,7562,409,40740,4624,2,13,1,15000.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL);
INSERT INTO `balance_libro_details` VALUES (1672,7562,410,40740,4624,2,96,2,4958.68,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1673,7562,410,40740,4624,2,67,2,1041.32,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1674,7562,410,40740,4624,2,13,1,6000.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1675,7562,411,40740,4624,2,96,2,6942.15,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1676,7562,411,40740,4624,2,67,2,1457.85,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1677,7562,411,40740,4624,2,13,1,8400.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1678,7562,412,40740,4624,2,96,2,5619.83,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1679,7562,412,40740,4624,2,67,2,1180.17,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1680,7562,412,40740,4624,2,13,1,6800.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1681,7562,413,40740,4624,2,96,2,4049.59,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1682,7562,413,40740,4624,2,67,2,850.41,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1683,7562,413,40740,4624,2,13,1,4900.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1684,7562,414,40740,4624,2,96,2,4628.10,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1685,7562,414,40740,4624,2,67,2,971.90,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1686,7562,414,40740,4624,2,13,1,5600.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1687,7562,415,40740,4624,2,96,2,19834.71,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1688,7562,415,40740,4624,2,67,2,4165.29,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1689,7562,415,40740,4624,2,13,1,24000.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1690,7562,416,40740,4624,2,96,2,4876.03,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1691,7562,416,40740,4624,2,67,2,1023.97,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1692,7562,416,40740,4624,2,13,1,5900.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1693,7562,417,40740,4624,2,96,2,3223.14,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1694,7562,417,40740,4624,2,67,2,676.86,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1695,7562,417,40740,4624,2,13,1,3900.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1696,7562,418,40740,4624,2,96,2,6528.93,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1697,7562,418,40740,4624,2,67,2,1371.07,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1698,7562,418,40740,4624,2,13,1,7900.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1699,7562,419,40740,4624,2,96,2,5603.31,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1700,7562,419,40740,4624,2,67,2,1176.69,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1701,7562,419,40740,4624,2,13,1,6780.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1702,7562,420,40740,4624,2,96,2,10330.58,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1703,7562,420,40740,4624,2,67,2,2169.42,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1704,7562,420,40740,4624,2,13,1,12500.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1705,7562,421,40740,4624,2,96,2,8181.82,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1706,7562,421,40740,4624,2,67,2,1718.18,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1707,7562,421,40740,4624,2,13,1,9900.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1708,7562,422,40740,4624,2,96,2,4876.03,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1709,7562,422,40740,4624,2,67,2,1023.97,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1710,7562,422,40740,4624,2,13,1,5900.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1711,7562,423,40740,4624,2,96,2,5619.83,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1712,7562,423,40740,4624,2,67,2,1180.17,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL);
INSERT INTO `balance_libro_details` VALUES (1713,7562,423,40740,4624,2,13,1,6800.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1714,7562,424,40740,4624,2,96,2,4876.03,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1715,7562,424,40740,4624,2,67,2,1023.97,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1716,7562,424,40740,4624,2,13,1,5900.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1717,7562,425,40740,4624,2,96,2,4132.23,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1718,7562,425,40740,4624,2,67,2,867.77,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1719,7562,425,40740,4624,2,13,1,5000.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1720,7562,426,40740,4624,2,96,2,9884.30,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1721,7562,426,40740,4624,2,67,2,2075.70,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1722,7562,426,40740,4624,2,13,1,11960.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1723,7562,427,40740,4624,2,96,2,4132.23,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1724,7562,427,40740,4624,2,67,2,867.77,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1725,7562,427,40740,4624,2,13,1,5000.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1726,7562,428,40740,4624,2,96,2,12148.76,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1727,7562,428,40740,4624,2,67,2,2551.24,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1728,7562,428,40740,4624,2,13,1,14700.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1729,7562,429,40740,4624,2,96,2,5785.12,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1730,7562,429,40740,4624,2,67,2,1214.88,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1731,7562,429,40740,4624,2,13,1,7000.00,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(1732,7562,430,40740,4624,2,96,2,5603.31,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1733,7562,430,40740,4624,2,67,2,1176.69,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1734,7562,430,40740,4624,2,13,1,6780.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1735,7562,431,40740,4624,2,96,2,22809.92,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1736,7562,431,40740,4624,2,67,2,4790.08,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1737,7562,431,40740,4624,2,13,1,27600.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1738,7562,432,40740,4624,2,96,2,4942.15,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1739,7562,432,40740,4624,2,67,2,1037.85,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1740,7562,432,40740,4624,2,13,1,5980.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1741,7562,433,40740,4624,2,96,2,4652.89,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1742,7562,433,40740,4624,2,67,2,977.11,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1743,7562,433,40740,4624,2,13,1,5630.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1744,7562,434,40740,4624,2,96,2,8074.38,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1745,7562,434,40740,4624,2,67,2,1695.62,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1746,7562,434,40740,4624,2,13,1,9770.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1747,7562,435,40740,4624,2,96,2,9338.84,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1748,7562,435,40740,4624,2,67,2,1961.16,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1749,7562,435,40740,4624,2,13,1,11300.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1750,7562,436,40740,4624,2,96,2,3305.79,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1751,7562,436,40740,4624,2,67,2,694.21,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1752,7562,436,40740,4624,2,13,1,4000.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1753,7562,437,40740,4624,2,96,2,1652.89,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL);
INSERT INTO `balance_libro_details` VALUES (1754,7562,437,40740,4624,2,67,2,347.11,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1755,7562,437,40740,4624,2,13,1,2000.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1756,7562,438,40740,4624,2,96,2,3223.14,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1757,7562,438,40740,4624,2,67,2,676.86,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1758,7562,438,40740,4624,2,13,1,3900.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1759,7562,439,40740,4624,2,96,2,6528.93,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1760,7562,439,40740,4624,2,67,2,1371.07,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1761,7562,439,40740,4624,2,13,1,7900.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1762,7562,440,40740,4624,2,96,2,7438.02,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1763,7562,440,40740,4624,2,67,2,1561.98,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1764,7562,440,40740,4624,2,13,1,9000.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1765,7562,441,40740,4624,2,96,2,8264.46,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1766,7562,441,40740,4624,2,67,2,1735.54,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1767,7562,441,40740,4624,2,13,1,10000.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1768,7562,442,40740,4624,2,96,2,4363.64,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1769,7562,442,40740,4624,2,67,2,916.36,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1770,7562,442,40740,4624,2,13,1,5280.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1771,7562,443,40740,4624,2,96,2,9917.36,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1772,7562,443,40740,4624,2,67,2,2082.64,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1773,7562,443,40740,4624,2,13,1,12000.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1774,7562,444,40740,4624,2,96,2,13082.64,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1775,7562,444,40740,4624,2,67,2,2747.36,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1776,7562,444,40740,4624,2,13,1,15830.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1777,7562,445,40740,4624,2,96,2,16528.93,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1778,7562,445,40740,4624,2,67,2,3471.07,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1779,7562,445,40740,4624,2,13,1,20000.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1780,7562,446,40740,4624,2,96,2,6611.57,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1781,7562,446,40740,4624,2,67,2,1388.43,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1782,7562,446,40740,4624,2,13,1,8000.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1783,7562,447,40740,4624,2,96,2,2892.56,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1784,7562,447,40740,4624,2,67,2,607.44,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1785,7562,447,40740,4624,2,13,1,3500.00,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(1786,7562,448,40740,4624,3,217,1,2782.65,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1787,7562,448,40740,4624,3,68,1,751.32,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1788,7562,448,40740,4624,3,217,1,160.87,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1789,7562,448,40740,4624,3,57,2,3694.84,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1790,7562,449,40740,4624,3,217,1,6843.19,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1791,7562,449,40740,4624,3,68,1,1437.07,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1792,7562,449,40740,4624,3,57,2,8280.26,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1793,7562,450,40740,4624,3,217,1,13686.38,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1794,7562,450,40740,4624,3,68,1,2874.14,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL);
INSERT INTO `balance_libro_details` VALUES (1795,7562,450,40740,4624,3,57,2,16560.52,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1796,7562,451,40740,4624,3,217,1,3788.00,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1797,7562,451,40740,4624,3,68,1,795.48,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1798,7562,451,40740,4624,3,57,2,4583.48,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1799,7562,452,40740,4624,3,217,1,7674.43,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1800,7562,452,40740,4624,3,68,1,1611.63,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1801,7562,452,40740,4624,3,57,2,9286.06,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1802,7562,453,40740,4624,3,217,1,400.00,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1803,7562,453,40740,4624,3,68,1,84.00,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1804,7562,453,40740,4624,3,57,2,484.00,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1805,7562,454,40740,4624,3,217,1,27984.46,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1806,7562,454,40740,4624,3,68,1,5876.74,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1807,7562,454,40740,4624,3,57,2,33861.20,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1808,7562,455,40740,4624,3,217,1,4929.76,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1809,7562,455,40740,4624,3,68,1,1035.25,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1810,7562,455,40740,4624,3,57,2,5965.01,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1811,7562,456,40740,4624,3,217,1,6312.00,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1812,7562,456,40740,4624,3,68,1,1325.52,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1813,7562,456,40740,4624,3,57,2,7637.52,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1814,7562,457,40740,4624,3,217,1,5107.21,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1815,7562,457,40740,4624,3,68,1,1072.51,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1816,7562,457,40740,4624,3,217,1,153.22,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1817,7562,457,40740,4624,3,57,2,6332.94,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(1818,7562,458,40740,4624,3,217,1,258650.00,NULL,'2023-05-17 13:33:22','2023-05-17 13:33:22',NULL),(1819,7562,458,40740,4624,3,68,1,54316.50,NULL,'2023-05-17 13:33:22','2023-05-17 13:33:22',NULL),(1820,7562,458,40740,4624,3,57,2,312966.50,NULL,'2023-05-17 13:33:22','2023-05-17 13:33:22',NULL),(1821,7562,459,40721,3052,3,250,1,826.45,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1822,7562,459,40721,3052,3,68,1,173.55,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1823,7562,459,40721,3052,3,57,2,1000.00,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1824,7562,460,40721,3052,3,221,1,627.58,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1825,7562,460,40721,3052,3,250,1,3046.48,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1826,7562,460,40721,3052,3,68,1,639.76,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1827,7562,460,40721,3052,3,250,1,313.79,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1828,7562,460,40721,3052,3,57,2,4627.61,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1829,7562,461,40721,3052,3,221,1,1041.14,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1830,7562,461,40721,3052,3,250,1,3702.05,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1831,7562,461,40721,3052,3,68,1,777.43,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1832,7562,461,40721,3052,3,250,1,520.57,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1833,7562,461,40721,3052,3,57,2,6041.19,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1834,7562,462,40721,3052,3,221,1,1187.14,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1835,7562,462,40721,3052,3,250,1,7773.95,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL);
INSERT INTO `balance_libro_details` VALUES (1836,7562,462,40721,3052,3,68,1,1632.53,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1837,7562,462,40721,3052,3,250,1,593.57,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1838,7562,462,40721,3052,3,57,2,11187.19,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(1839,7562,463,40721,3052,3,221,1,1269.36,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1840,7562,463,40721,3052,3,250,1,6913.62,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1841,7562,463,40721,3052,3,68,1,1451.86,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1842,7562,463,40721,3052,3,250,1,634.69,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1843,7562,463,40721,3052,3,57,2,10269.53,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1844,7562,464,40721,3052,3,250,1,140495.87,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1845,7562,464,40721,3052,3,68,1,29504.13,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1846,7562,464,40721,3052,3,57,2,170000.00,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1847,7562,465,40721,3052,3,221,1,366.00,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1848,7562,465,40721,3052,3,250,1,2328.19,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1849,7562,465,40721,3052,3,68,1,488.92,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1850,7562,465,40721,3052,3,250,1,182.98,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1851,7562,465,40721,3052,3,57,2,3366.09,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1852,7562,466,40721,3052,3,250,1,27421.66,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1853,7562,466,40721,3052,3,68,1,5758.55,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1854,7562,466,40721,3052,3,57,2,33180.21,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1855,7562,467,40721,3052,3,250,1,10702.48,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1856,7562,467,40721,3052,3,68,1,2247.52,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1857,7562,467,40721,3052,3,57,2,12950.00,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1858,7562,468,40721,3052,3,221,1,1646.98,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1859,7562,468,40721,3052,3,250,1,10063.81,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1860,7562,468,40721,3052,3,68,1,2113.40,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1861,7562,468,40721,3052,3,250,1,823.48,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1862,7562,468,40721,3052,3,57,2,14647.67,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1863,7562,469,40721,3052,3,221,1,609.98,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1864,7562,469,40721,3052,3,250,1,3880.29,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1865,7562,469,40721,3052,3,68,1,814.86,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1866,7562,469,40721,3052,3,250,1,305.01,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1867,7562,469,40721,3052,3,57,2,5610.14,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1868,7562,470,40721,3052,3,250,1,8305.79,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1869,7562,470,40721,3052,3,68,1,1744.22,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1870,7562,470,40721,3052,3,57,2,10050.01,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1871,7562,471,40721,3052,3,221,1,243.98,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1872,7562,471,40721,3052,3,250,1,1552.05,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1873,7562,471,40721,3052,3,68,1,325.93,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1874,7562,471,40721,3052,3,250,1,121.97,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1875,7562,471,40721,3052,3,57,2,2243.93,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1876,7562,472,40721,3052,3,221,1,1544.20,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1877,7562,472,40721,3052,3,250,1,10521.86,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1878,7562,472,40721,3052,3,68,1,2209.59,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1879,7562,472,40721,3052,3,250,1,772.08,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1880,7562,472,40721,3052,3,57,2,15047.73,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1881,7562,473,40721,3052,3,250,1,2135.47,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1882,7562,473,40721,3052,3,68,1,448.45,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1883,7562,473,40721,3052,3,57,2,2583.92,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1884,7562,474,40721,3052,3,221,1,243.98,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1885,7562,474,40721,3052,3,250,1,1552.05,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1886,7562,474,40721,3052,3,68,1,325.93,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1887,7562,474,40721,3052,3,250,1,121.97,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1888,7562,474,40721,3052,3,57,2,2243.93,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1889,7562,475,40721,3052,3,221,1,786.18,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1890,7562,475,40721,3052,3,250,1,2981.00,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1891,7562,475,40721,3052,3,68,1,626.01,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1892,7562,475,40721,3052,3,250,1,393.08,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1893,7562,475,40721,3052,3,57,2,4786.27,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1894,7562,476,40721,3052,3,221,1,593.58,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1895,7562,476,40721,3052,3,250,1,3886.95,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1896,7562,476,40721,3052,3,68,1,816.26,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1897,7562,476,40721,3052,3,250,1,296.77,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1898,7562,476,40721,3052,3,57,2,5593.56,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1899,7562,477,40721,3052,3,250,1,3082.22,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1900,7562,477,40721,3052,3,68,1,647.27,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1901,7562,477,40721,3052,3,57,2,3729.49,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1902,7562,478,40721,3052,3,250,2,770.55,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1903,7562,478,40721,3052,3,67,2,161.82,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1904,7562,478,40721,3052,3,57,1,932.37,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1905,7562,479,40721,3052,3,250,1,2479.34,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1906,7562,479,40721,3052,3,68,1,520.66,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1907,7562,479,40721,3052,3,57,2,3000.00,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1908,7562,480,40721,3052,3,221,1,356.16,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1909,7562,480,40721,3052,3,250,1,2332.29,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1910,7562,480,40721,3052,3,68,1,489.78,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1911,7562,480,40721,3052,3,250,1,178.10,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1912,7562,480,40721,3052,3,57,2,3356.33,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1913,7562,481,40721,3052,3,221,1,622.86,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1914,7562,481,40721,3052,3,250,1,3048.48,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1915,7562,481,40721,3052,3,68,1,640.18,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1916,7562,481,40721,3052,3,250,1,311.44,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1917,7562,481,40721,3052,3,57,2,4622.96,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1918,7562,482,40721,3052,3,250,1,2066.12,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1919,7562,482,40721,3052,3,68,1,433.88,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1920,7562,482,40721,3052,3,57,2,2500.00,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1921,7562,483,40721,3052,3,221,1,786.24,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1922,7562,483,40721,3052,3,250,1,2981.19,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1923,7562,483,40721,3052,3,68,1,626.05,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1924,7562,483,40721,3052,3,250,1,393.13,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1925,7562,483,40721,3052,3,57,2,4786.61,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1926,7562,484,40721,3052,3,250,1,2501.19,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1927,7562,484,40721,3052,3,68,1,525.25,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1928,7562,484,40721,3052,3,57,2,3026.44,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1929,7562,485,40721,3052,3,250,2,625.30,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1930,7562,485,40721,3052,3,67,2,131.31,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1931,7562,485,40721,3052,3,57,1,756.61,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(1932,7562,486,40719,4,12,359,1,16500.00,NULL,'2023-05-29 16:14:33','2023-05-29 16:14:33',NULL),(1933,7562,486,40719,4,12,369,2,66000.00,NULL,'2023-05-29 16:14:33','2023-05-29 16:14:33',NULL),(1934,7562,486,40719,4,12,368,1,49500.00,NULL,'2023-05-29 16:14:33','2023-05-29 16:14:33',NULL),(1935,7562,487,40719,8,2,218,2,1450.00,NULL,'2023-05-29 16:16:26','2023-05-29 16:16:26',NULL),(1936,7562,487,40719,8,2,359,1,1450.00,NULL,'2023-05-29 16:16:26','2023-05-29 16:16:26',NULL),(1937,7562,488,40719,9,2,218,2,1400.00,NULL,'2023-05-29 16:18:00','2023-05-29 16:18:00',NULL),(1938,7562,488,40719,9,2,96,2,1652.90,NULL,'2023-05-29 16:18:00','2023-05-29 16:18:00',NULL),(1939,7562,488,40719,9,2,67,2,347.11,NULL,'2023-05-29 16:18:00','2023-05-29 16:18:00',NULL),(1940,7562,488,40719,9,2,359,1,3400.01,NULL,'2023-05-29 16:18:00','2023-05-29 16:18:00',NULL),(1941,7562,489,40719,10,2,218,2,7000.00,NULL,'2023-05-29 16:18:35','2023-05-29 16:18:35',NULL),(1942,7562,489,40719,10,2,359,1,7000.00,NULL,'2023-05-29 16:18:35','2023-05-29 16:18:35',NULL),(1943,7562,490,40719,11,2,96,2,126281.04,NULL,'2023-05-29 16:19:46','2023-05-29 16:19:46',NULL),(1944,7562,490,40719,11,2,218,2,100.00,NULL,'2023-05-29 16:19:46','2023-05-29 16:19:46',NULL),(1945,7562,490,40719,11,2,67,2,26519.02,NULL,'2023-05-29 16:19:46','2023-05-29 16:19:46',NULL),(1946,7562,490,40719,11,2,359,1,152900.06,NULL,'2023-05-29 16:19:46','2023-05-29 16:19:46',NULL),(1947,7562,491,40719,12,2,96,2,1448.00,NULL,'2023-05-29 16:22:02','2023-05-29 16:22:02',NULL),(1948,7562,491,40719,12,2,96,2,78843.10,NULL,'2023-05-29 16:22:02','2023-05-29 16:22:02',NULL),(1949,7562,491,40719,12,2,218,2,3500.00,NULL,'2023-05-29 16:22:02','2023-05-29 16:22:02',NULL),(1950,7562,491,40719,12,2,67,2,16709.09,NULL,'2023-05-29 16:22:02','2023-05-29 16:22:02',NULL),(1951,7562,491,40719,12,2,359,1,100500.19,NULL,'2023-05-29 16:22:02','2023-05-29 16:22:02',NULL),(1952,7562,492,40719,13,2,96,2,8512.42,NULL,'2023-05-29 16:23:28','2023-05-29 16:23:28',NULL),(1953,7562,492,40719,13,2,218,2,1800.00,NULL,'2023-05-29 16:23:28','2023-05-29 16:23:28',NULL),(1954,7562,492,40719,13,2,67,2,1787.61,NULL,'2023-05-29 16:23:28','2023-05-29 16:23:28',NULL),(1955,7562,492,40719,13,2,359,1,12100.03,NULL,'2023-05-29 16:23:28','2023-05-29 16:23:28',NULL),(1956,7562,493,40719,14,2,96,2,145851.24,NULL,'2023-05-29 16:24:42','2023-05-29 16:24:42',NULL),(1957,7562,493,40719,14,2,218,2,14700.00,NULL,'2023-05-29 16:24:42','2023-05-29 16:24:42',NULL),(1958,7562,493,40719,14,2,67,2,30628.76,NULL,'2023-05-29 16:24:42','2023-05-29 16:24:42',NULL),(1959,7562,493,40719,14,2,359,1,191180.00,NULL,'2023-05-29 16:24:42','2023-05-29 16:24:42',NULL);
INSERT INTO `balance_libro_details` VALUES (1960,7562,494,40719,5,3,217,1,124546.67,NULL,'2023-05-29 16:26:49','2023-05-29 16:26:49',NULL),(1961,7562,494,40719,5,3,250,1,126154.80,NULL,'2023-05-29 16:26:49','2023-05-29 16:26:49',NULL),(1962,7562,494,40719,5,3,57,2,250701.47,NULL,'2023-05-29 16:26:49','2023-05-29 16:26:49',NULL),(1963,7562,495,40719,6,3,217,1,251499.10,NULL,'2023-05-29 16:28:13','2023-05-29 16:28:13',NULL),(1964,7562,495,40719,6,3,250,1,112500.00,NULL,'2023-05-29 16:28:13','2023-05-29 16:28:13',NULL),(1965,7562,495,40719,6,3,68,1,52814.81,NULL,'2023-05-29 16:28:13','2023-05-29 16:28:13',NULL),(1966,7562,495,40719,6,3,57,2,416813.91,NULL,'2023-05-29 16:28:13','2023-05-29 16:28:13',NULL),(1967,7562,496,40719,7,3,217,1,43056.19,NULL,'2023-05-29 16:29:16','2023-05-29 16:29:16',NULL),(1968,7562,496,40719,7,3,250,1,50000.00,NULL,'2023-05-29 16:29:16','2023-05-29 16:29:16',NULL),(1969,7562,496,40719,7,3,68,1,9041.80,NULL,'2023-05-29 16:29:16','2023-05-29 16:29:16',NULL),(1970,7562,496,40719,7,3,57,2,102097.99,NULL,'2023-05-29 16:29:16','2023-05-29 16:29:16',NULL),(1971,7562,497,40719,8,3,217,1,3719.00,NULL,'2023-05-29 16:30:13','2023-05-29 16:30:13',NULL),(1972,7562,497,40719,8,3,250,1,60580.99,NULL,'2023-05-29 16:30:13','2023-05-29 16:30:13',NULL),(1973,7562,497,40719,8,3,57,2,64299.99,NULL,'2023-05-29 16:30:13','2023-05-29 16:30:13',NULL),(1974,7562,498,40719,9,3,217,1,86313.14,NULL,'2023-05-29 16:31:08','2023-05-29 16:31:08',NULL),(1975,7562,498,40719,9,3,250,1,70874.72,NULL,'2023-05-29 16:31:08','2023-05-29 16:31:08',NULL),(1976,7562,498,40719,9,3,68,1,9806.04,NULL,'2023-05-29 16:31:08','2023-05-29 16:31:08',NULL),(1977,7562,498,40719,9,3,57,2,166993.90,NULL,'2023-05-29 16:31:08','2023-05-29 16:31:08',NULL),(1978,7562,499,40719,10,3,217,1,15792.67,NULL,'2023-05-29 16:31:54','2023-05-29 16:31:54',NULL),(1979,7562,499,40719,10,3,250,1,56016.46,NULL,'2023-05-29 16:31:54','2023-05-29 16:31:54',NULL),(1980,7562,499,40719,10,3,57,2,71809.13,NULL,'2023-05-29 16:31:54','2023-05-29 16:31:54',NULL),(1981,7562,500,40719,11,3,217,1,9844.57,NULL,'2023-05-29 16:32:58','2023-05-29 16:32:58',NULL),(1982,7562,500,40719,11,3,250,1,2899.47,NULL,'2023-05-29 16:32:58','2023-05-29 16:32:58',NULL),(1983,7562,500,40719,11,3,68,1,2065.29,NULL,'2023-05-29 16:32:58','2023-05-29 16:32:58',NULL),(1984,7562,500,40719,11,3,57,2,14809.33,NULL,'2023-05-29 16:32:58','2023-05-29 16:32:58',NULL),(1985,7562,501,40719,12,3,217,1,30067.76,NULL,'2023-05-29 16:33:58','2023-05-29 16:33:58',NULL),(1986,7562,501,40719,12,3,250,1,58265.20,NULL,'2023-05-29 16:33:58','2023-05-29 16:33:58',NULL),(1987,7562,501,40719,12,3,68,1,6049.03,NULL,'2023-05-29 16:33:58','2023-05-29 16:33:58',NULL),(1988,7562,501,40719,12,3,57,2,94381.99,NULL,'2023-05-29 16:33:58','2023-05-29 16:33:58',NULL),(1989,7562,502,40719,13,3,217,1,14219.14,NULL,'2023-05-29 16:34:56','2023-05-29 16:34:56',NULL),(1990,7562,502,40719,13,3,250,1,58662.55,NULL,'2023-05-29 16:34:56','2023-05-29 16:34:56',NULL),(1991,7562,502,40719,13,3,68,1,2463.47,NULL,'2023-05-29 16:34:56','2023-05-29 16:34:56',NULL),(1992,7562,502,40719,13,3,57,2,75345.16,NULL,'2023-05-29 16:34:56','2023-05-29 16:34:56',NULL),(1993,7562,503,40719,14,3,217,1,47747.14,NULL,'2023-05-29 16:36:42','2023-05-29 16:36:42',NULL),(1994,7562,503,40719,14,3,250,1,59448.70,NULL,'2023-05-29 16:36:42','2023-05-29 16:36:42',NULL),(1995,7562,503,40719,14,3,68,1,9104.43,NULL,'2023-05-29 16:36:42','2023-05-29 16:36:42',NULL),(1996,7562,503,40719,14,3,57,2,116300.27,NULL,'2023-05-29 16:36:42','2023-05-29 16:36:42',NULL),(1997,7562,504,40719,14,10,67,1,75991.59,NULL,'2023-05-29 16:49:11','2023-05-29 16:49:11',NULL),(1998,7562,504,40719,14,10,68,2,91344.87,NULL,'2023-05-29 16:49:11','2023-05-29 16:49:11',NULL),(1999,7562,504,40719,14,10,353,1,15353.28,NULL,'2023-05-29 16:49:11','2023-05-29 16:49:11',NULL),(2000,7562,505,40719,5,3,156,1,592.00,NULL,'2023-05-29 16:50:29','2023-05-29 16:50:29',NULL),(2001,7562,505,40719,5,3,338,2,592.00,NULL,'2023-05-29 16:50:29','2023-05-29 16:50:29',NULL);
INSERT INTO `balance_libro_details` VALUES (2002,7562,506,40719,6,3,156,1,592.00,NULL,'2023-05-29 16:51:10','2023-05-29 16:51:10',NULL),(2003,7562,506,40719,6,3,338,2,592.00,NULL,'2023-05-29 16:51:10','2023-05-29 16:51:10',NULL),(2004,7562,507,40719,7,3,156,1,592.00,NULL,'2023-05-29 16:51:56','2023-05-29 16:51:56',NULL),(2005,7562,507,40719,7,3,338,2,592.00,NULL,'2023-05-29 16:51:56','2023-05-29 16:51:56',NULL),(2006,7562,508,40719,8,3,156,1,592.00,NULL,'2023-05-29 16:52:41','2023-05-29 16:52:41',NULL),(2007,7562,508,40719,8,3,338,2,592.00,NULL,'2023-05-29 16:52:41','2023-05-29 16:52:41',NULL),(2008,7562,509,40719,9,3,156,1,592.00,NULL,'2023-05-29 16:53:53','2023-05-29 16:53:53',NULL),(2009,7562,509,40719,9,3,338,2,592.00,NULL,'2023-05-29 16:53:53','2023-05-29 16:53:53',NULL),(2010,7562,510,40719,10,3,156,1,592.00,NULL,'2023-05-29 16:54:32','2023-05-29 16:54:32',NULL),(2011,7562,510,40719,10,3,338,2,592.00,NULL,'2023-05-29 16:54:32','2023-05-29 16:54:32',NULL),(2012,7562,511,40719,11,3,156,1,5055.24,NULL,'2023-05-29 16:55:36','2023-05-29 16:55:36',NULL),(2013,7562,511,40719,11,3,338,2,5055.24,NULL,'2023-05-29 16:55:36','2023-05-29 16:55:36',NULL),(2014,7562,512,40719,12,3,156,1,3301.74,NULL,'2023-05-29 16:56:20','2023-05-29 16:56:20',NULL),(2015,7562,512,40719,12,3,338,2,3301.74,NULL,'2023-05-29 16:56:20','2023-05-29 16:56:20',NULL),(2016,7562,513,40719,13,3,156,1,592.00,NULL,'2023-05-29 16:57:17','2023-05-29 16:57:17',NULL),(2017,7562,513,40719,13,3,359,2,62.90,NULL,'2023-05-29 16:57:17','2023-05-29 16:57:17',NULL),(2018,7562,513,40719,13,3,338,2,529.10,NULL,'2023-05-29 16:57:17','2023-05-29 16:57:17',NULL),(2019,7562,514,40719,14,3,156,1,6422.05,NULL,'2023-05-29 16:58:00','2023-05-29 16:58:00',NULL),(2020,7562,514,40719,14,3,359,2,133.74,NULL,'2023-05-29 16:58:00','2023-05-29 16:58:00',NULL),(2021,7562,514,40719,14,3,338,2,6288.31,NULL,'2023-05-29 16:58:00','2023-05-29 16:58:00',NULL),(2022,7562,515,40719,14,19,368,1,49500.00,NULL,'2023-05-29 17:01:31','2023-05-29 17:13:43','2023-05-29 17:13:43'),(2023,7562,515,40719,14,19,359,2,49500.00,NULL,'2023-05-29 17:01:31','2023-05-29 17:13:43','2023-05-29 17:13:43'),(2024,7562,516,40719,14,17,57,1,534333.65,NULL,'2023-05-29 17:05:23','2023-05-29 17:12:25','2023-05-29 17:12:25'),(2025,7562,516,40719,14,17,359,2,534333.65,NULL,'2023-05-29 17:05:23','2023-05-29 17:12:25','2023-05-29 17:12:25'),(2026,7562,516,40719,14,17,368,2,995915.33,NULL,'2023-05-29 17:05:23','2023-05-29 17:12:25','2023-05-29 17:12:25'),(2027,7562,516,40719,14,17,57,1,995915.33,NULL,'2023-05-29 17:05:23','2023-05-29 17:12:25','2023-05-29 17:12:25'),(2028,7562,517,40719,14,17,57,1,534333.65,NULL,'2023-05-29 17:12:25','2023-05-29 17:16:22','2023-05-29 17:16:22'),(2029,7562,517,40719,14,17,359,2,534333.65,NULL,'2023-05-29 17:12:25','2023-05-29 17:16:22','2023-05-29 17:16:22'),(2030,7562,518,40719,14,19,368,2,49500.00,NULL,'2023-05-29 17:13:43','2023-05-29 17:13:43',NULL),(2031,7562,518,40719,14,19,359,1,49500.00,NULL,'2023-05-29 17:13:43','2023-05-29 17:13:43',NULL),(2032,7562,519,40719,14,17,57,1,534333.65,NULL,'2023-05-29 17:16:22','2023-05-29 17:16:22',NULL),(2033,7562,519,40719,14,17,359,2,534333.65,NULL,'2023-05-29 17:16:22','2023-05-29 17:16:22',NULL),(2034,7562,519,40719,14,17,57,1,732023.65,NULL,'2023-05-29 17:16:22','2023-05-29 17:16:22',NULL),(2035,7562,519,40719,14,17,368,2,800000.00,NULL,'2023-05-29 17:16:22','2023-05-29 17:16:22',NULL),(2036,7562,519,40719,14,17,359,1,67976.35,NULL,'2023-05-29 17:16:22','2023-05-29 17:16:22',NULL),(2037,7562,520,40719,14,23,88,2,52217.15,NULL,'2023-06-08 13:52:50','2023-06-08 13:52:50',NULL),(2038,7562,520,40719,14,23,250,1,249291.86,NULL,'2023-06-08 13:52:50','2023-06-08 13:52:50',NULL),(2039,7562,520,40719,14,23,156,1,2887.35,NULL,'2023-06-08 13:52:50','2023-06-08 13:52:50',NULL),(2040,7562,520,40719,14,23,217,1,292449.15,NULL,'2023-06-08 13:52:50','2023-06-08 13:52:50',NULL),(2041,7562,520,40719,14,23,218,2,3275.92,NULL,'2023-06-08 13:52:50','2023-06-08 13:52:50',NULL);
INSERT INTO `balance_libro_details` VALUES (2042,7562,520,40719,14,23,96,2,31087.40,NULL,'2023-06-08 13:52:50','2023-06-08 13:52:50',NULL),(2043,7562,520,40719,14,23,476,2,458047.89,NULL,'2023-06-08 13:52:50','2023-06-08 13:52:50',NULL),(2044,7562,521,40719,14,3,116,1,547184.78,NULL,'2023-06-08 14:22:32','2023-06-08 14:22:32',NULL),(2045,7562,521,40719,14,3,490,1,273592.39,NULL,'2023-06-08 14:22:32','2023-06-08 14:22:32',NULL),(2046,7562,521,40719,14,3,491,1,237113.41,NULL,'2023-06-08 14:22:32','2023-06-08 14:22:32',NULL),(2047,7562,521,40719,14,3,492,1,91197.46,NULL,'2023-06-08 14:22:32','2023-06-08 14:22:32',NULL),(2048,7562,521,40719,14,3,493,1,36478.99,NULL,'2023-06-08 14:22:32','2023-06-08 14:22:32',NULL),(2049,7562,521,40719,14,3,494,1,18239.49,NULL,'2023-06-08 14:22:32','2023-06-08 14:22:32',NULL),(2050,7562,521,40719,14,3,217,2,919254.53,NULL,'2023-06-08 14:22:32','2023-06-08 14:22:32',NULL),(2051,7562,521,40719,14,3,250,2,904694.75,NULL,'2023-06-08 14:22:32','2023-06-08 14:22:32',NULL),(2052,7562,521,40719,14,3,250,1,620142.76,NULL,'2023-06-08 14:22:32','2023-06-08 14:22:32',NULL),(2053,7562,522,40719,14,19,368,2,470000.00,NULL,'2023-06-08 17:00:09','2023-06-08 17:00:09',NULL),(2054,7562,522,40719,14,19,388,1,470000.00,NULL,'2023-06-08 17:00:09','2023-06-08 17:00:09',NULL),(2055,7562,523,40740,4625,2,96,2,2314.05,NULL,'2023-06-12 15:18:11','2023-06-12 15:18:11',NULL),(2056,7562,523,40740,4625,2,67,2,485.95,NULL,'2023-06-12 15:18:11','2023-06-12 15:18:11',NULL),(2057,7562,523,40740,4625,2,13,1,2800.00,NULL,'2023-06-12 15:18:11','2023-06-12 15:18:11',NULL),(2058,7562,524,40740,4625,2,96,2,9917.36,NULL,'2023-06-12 15:18:11','2023-06-12 15:18:11',NULL),(2059,7562,524,40740,4625,2,67,2,2082.64,NULL,'2023-06-12 15:18:11','2023-06-12 15:18:11',NULL),(2060,7562,524,40740,4625,2,13,1,12000.00,NULL,'2023-06-12 15:18:11','2023-06-12 15:18:11',NULL),(2061,7562,525,40740,4625,2,96,2,6553.72,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2062,7562,525,40740,4625,2,67,2,1376.28,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2063,7562,525,40740,4625,2,13,1,7930.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2064,7562,526,40740,4625,2,96,2,11404.96,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2065,7562,526,40740,4625,2,67,2,2395.04,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2066,7562,526,40740,4625,2,13,1,13800.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2067,7562,527,40740,4625,2,96,2,7438.02,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2068,7562,527,40740,4625,2,67,2,1561.98,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2069,7562,527,40740,4625,2,13,1,9000.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2070,7562,528,40740,4625,2,96,2,9504.13,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2071,7562,528,40740,4625,2,67,2,1995.87,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2072,7562,528,40740,4625,2,13,1,11500.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2073,7562,529,40740,4625,2,96,2,4049.59,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2074,7562,529,40740,4625,2,67,2,850.41,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2075,7562,529,40740,4625,2,13,1,4900.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2076,7562,530,40740,4625,2,96,2,9314.05,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2077,7562,530,40740,4625,2,67,2,1955.95,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2078,7562,530,40740,4625,2,13,1,11270.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2079,7562,531,40740,4625,2,96,2,4049.59,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2080,7562,531,40740,4625,2,67,2,850.41,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2081,7562,531,40740,4625,2,13,1,4900.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2082,7562,532,40740,4625,2,96,2,5702.48,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL);
INSERT INTO `balance_libro_details` VALUES (2083,7562,532,40740,4625,2,67,2,1197.52,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2084,7562,532,40740,4625,2,13,1,6900.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2085,7562,533,40740,4625,2,96,2,21487.60,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2086,7562,533,40740,4625,2,67,2,4512.40,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2087,7562,533,40740,4625,2,13,1,26000.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2088,7562,534,40740,4625,2,96,2,5702.48,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2089,7562,534,40740,4625,2,67,2,1197.52,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2090,7562,534,40740,4625,2,13,1,6900.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2091,7562,535,40740,4625,2,96,2,9504.13,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2092,7562,535,40740,4625,2,67,2,1995.87,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2093,7562,535,40740,4625,2,13,1,11500.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2094,7562,536,40740,4625,2,96,2,8264.46,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2095,7562,536,40740,4625,2,67,2,1735.54,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2096,7562,536,40740,4625,2,13,1,10000.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2097,7562,537,40740,4625,2,96,2,5702.48,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2098,7562,537,40740,4625,2,67,2,1197.52,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2099,7562,537,40740,4625,2,13,1,6900.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2100,7562,538,40740,4625,2,96,2,5702.48,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2101,7562,538,40740,4625,2,67,2,1197.52,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2102,7562,538,40740,4625,2,13,1,6900.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2103,7562,539,40740,4625,2,96,2,4752.07,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2104,7562,539,40740,4625,2,67,2,997.93,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2105,7562,539,40740,4625,2,13,1,5750.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2106,7562,540,40740,4625,2,96,2,5702.48,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2107,7562,540,40740,4625,2,67,2,1197.52,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2108,7562,540,40740,4625,2,13,1,6900.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2109,7562,541,40740,4625,2,96,2,17107.44,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2110,7562,541,40740,4625,2,67,2,3592.56,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2111,7562,541,40740,4625,2,13,1,20700.00,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(2112,7562,542,40740,4625,2,96,2,6528.93,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2113,7562,542,40740,4625,2,67,2,1371.07,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2114,7562,542,40740,4625,2,13,1,7900.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2115,7562,543,40740,4625,2,96,2,6528.93,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2116,7562,543,40740,4625,2,67,2,1371.07,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2117,7562,543,40740,4625,2,13,1,7900.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2118,7562,544,40740,4625,2,96,2,3140.50,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2119,7562,544,40740,4625,2,67,2,659.50,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2120,7562,544,40740,4625,2,13,1,3800.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2121,7562,545,40740,4625,2,96,2,11074.38,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2122,7562,545,40740,4625,2,67,2,2325.62,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2123,7562,545,40740,4625,2,13,1,13400.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL);
INSERT INTO `balance_libro_details` VALUES (2124,7562,546,40740,4625,2,96,2,7355.37,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2125,7562,546,40740,4625,2,67,2,1544.63,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2126,7562,546,40740,4625,2,13,1,8900.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2127,7562,547,40740,4625,2,96,2,6528.93,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2128,7562,547,40740,4625,2,67,2,1371.07,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2129,7562,547,40740,4625,2,13,1,7900.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2130,7562,548,40740,4625,2,96,2,3057.85,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2131,7562,548,40740,4625,2,67,2,642.15,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2132,7562,548,40740,4625,2,13,1,3700.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2133,7562,549,40740,4625,2,96,2,2644.63,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2134,7562,549,40740,4625,2,67,2,555.37,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2135,7562,549,40740,4625,2,13,1,3200.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2136,7562,550,40740,4625,2,96,2,5702.48,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2137,7562,550,40740,4625,2,67,2,1197.52,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2138,7562,550,40740,4625,2,13,1,6900.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2139,7562,551,40740,4625,2,96,2,7355.37,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2140,7562,551,40740,4625,2,67,2,1544.63,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2141,7562,551,40740,4625,2,13,1,8900.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2142,7562,552,40740,4625,2,96,2,9917.36,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2143,7562,552,40740,4625,2,67,2,2082.64,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2144,7562,552,40740,4625,2,13,1,12000.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2145,7562,553,40740,4625,2,96,2,8264.46,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2146,7562,553,40740,4625,2,67,2,1735.54,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2147,7562,553,40740,4625,2,13,1,10000.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2148,7562,554,40740,4625,2,96,2,5702.48,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2149,7562,554,40740,4625,2,67,2,1197.52,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2150,7562,554,40740,4625,2,13,1,6900.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2151,7562,555,40740,4625,2,96,2,7355.37,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2152,7562,555,40740,4625,2,67,2,1544.63,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2153,7562,555,40740,4625,2,13,1,8900.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2154,7562,556,40740,4625,2,96,2,6611.57,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2155,7562,556,40740,4625,2,67,2,1388.43,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2156,7562,556,40740,4625,2,13,1,8000.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2157,7562,557,40740,4625,2,96,2,4132.23,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2158,7562,557,40740,4625,2,67,2,867.77,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2159,7562,557,40740,4625,2,13,1,5000.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2160,7562,558,40740,4625,2,96,2,6528.93,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2161,7562,558,40740,4625,2,67,2,1371.07,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2162,7562,558,40740,4625,2,13,1,7900.00,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(2163,7562,559,40740,4625,2,96,2,4876.03,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2164,7562,559,40740,4625,2,67,2,1023.97,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL);
INSERT INTO `balance_libro_details` VALUES (2165,7562,559,40740,4625,2,13,1,5900.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2166,7562,560,40740,4625,2,96,2,8264.46,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2167,7562,560,40740,4625,2,67,2,1735.54,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2168,7562,560,40740,4625,2,13,1,10000.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2169,7562,561,40740,4625,2,96,2,3884.30,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2170,7562,561,40740,4625,2,67,2,815.70,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2171,7562,561,40740,4625,2,13,1,4700.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2172,7562,562,40740,4625,2,96,2,22314.05,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2173,7562,562,40740,4625,2,67,2,4685.95,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2174,7562,562,40740,4625,2,13,1,27000.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2175,7562,563,40740,4625,2,96,2,4793.39,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2176,7562,563,40740,4625,2,67,2,1006.61,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2177,7562,563,40740,4625,2,13,1,5800.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2178,7562,564,40740,4625,2,96,2,23760.33,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2179,7562,564,40740,4625,2,67,2,4989.67,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2180,7562,564,40740,4625,2,13,1,28750.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2181,7562,565,40740,4625,2,96,2,5371.90,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2182,7562,565,40740,4625,2,67,2,1128.10,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2183,7562,565,40740,4625,2,13,1,6500.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2184,7562,566,40740,4625,2,96,2,8181.82,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2185,7562,566,40740,4625,2,67,2,1718.18,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2186,7562,566,40740,4625,2,13,1,9900.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2187,7562,567,40740,4625,2,96,2,8264.46,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2188,7562,567,40740,4625,2,67,2,1735.54,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2189,7562,567,40740,4625,2,13,1,10000.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2190,7562,568,40740,4625,2,96,2,8264.46,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2191,7562,568,40740,4625,2,67,2,1735.54,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2192,7562,568,40740,4625,2,13,1,10000.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2193,7562,569,40740,4625,2,96,2,19041.32,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2194,7562,569,40740,4625,2,67,2,3998.68,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2195,7562,569,40740,4625,2,13,1,23040.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2196,7562,570,40740,4625,2,96,2,8264.46,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2197,7562,570,40740,4625,2,67,2,1735.54,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2198,7562,570,40740,4625,2,13,1,10000.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2199,7562,571,40740,4625,2,96,2,3305.79,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2200,7562,571,40740,4625,2,67,2,694.21,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2201,7562,571,40740,4625,2,13,1,4000.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2202,7562,572,40740,4625,2,96,2,6528.93,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2203,7562,572,40740,4625,2,67,2,1371.07,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2204,7562,572,40740,4625,2,13,1,7900.00,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(2205,7562,573,40740,4625,2,96,2,4710.74,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL);
INSERT INTO `balance_libro_details` VALUES (2206,7562,573,40740,4625,2,67,2,989.26,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2207,7562,573,40740,4625,2,13,1,5700.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2208,7562,574,40740,4625,2,96,2,15867.77,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2209,7562,574,40740,4625,2,67,2,3332.23,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2210,7562,574,40740,4625,2,13,1,19200.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2211,7562,575,40740,4625,2,96,2,5785.12,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2212,7562,575,40740,4625,2,67,2,1214.88,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2213,7562,575,40740,4625,2,13,1,7000.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2214,7562,576,40740,4625,2,96,2,5157.02,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2215,7562,576,40740,4625,2,67,2,1082.98,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2216,7562,576,40740,4625,2,13,1,6240.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2217,7562,577,40740,4625,2,96,2,4876.03,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2218,7562,577,40740,4625,2,67,2,1023.97,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2219,7562,577,40740,4625,2,13,1,5900.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2220,7562,578,40740,4625,2,96,2,36595.04,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2221,7562,578,40740,4625,2,67,2,7684.96,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2222,7562,578,40740,4625,2,13,1,44280.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2223,7562,579,40740,4625,2,96,2,5702.48,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2224,7562,579,40740,4625,2,67,2,1197.52,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2225,7562,579,40740,4625,2,13,1,6900.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2226,7562,580,40740,4625,2,96,2,8264.46,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2227,7562,580,40740,4625,2,67,2,1735.54,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2228,7562,580,40740,4625,2,13,1,10000.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2229,7562,581,40740,4625,2,96,2,7603.31,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2230,7562,581,40740,4625,2,67,2,1596.69,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2231,7562,581,40740,4625,2,13,1,9200.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2232,7562,582,40740,4625,2,96,2,7834.71,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2233,7562,582,40740,4625,2,67,2,1645.29,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2234,7562,582,40740,4625,2,13,1,9480.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2235,7562,583,40740,4625,2,96,2,10909.09,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2236,7562,583,40740,4625,2,67,2,2290.91,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2237,7562,583,40740,4625,2,13,1,13200.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2238,7562,584,40740,4625,2,96,2,3471.07,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2239,7562,584,40740,4625,2,67,2,728.93,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2240,7562,584,40740,4625,2,13,1,4200.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2241,7562,585,40740,4625,2,96,2,12396.69,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2242,7562,585,40740,4625,2,67,2,2603.31,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2243,7562,585,40740,4625,2,13,1,15000.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2244,7562,586,40740,4625,2,96,2,29752.07,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2245,7562,586,40740,4625,2,67,2,6247.93,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2246,7562,586,40740,4625,2,13,1,36000.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL);
INSERT INTO `balance_libro_details` VALUES (2247,7562,587,40740,4625,2,96,2,4958.68,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2248,7562,587,40740,4625,2,67,2,1041.32,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2249,7562,587,40740,4625,2,13,1,6000.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2250,7562,588,40740,4625,2,96,2,8181.82,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2251,7562,588,40740,4625,2,67,2,1718.18,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2252,7562,588,40740,4625,2,13,1,9900.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2253,7562,589,40740,4625,2,96,2,3305.79,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2254,7562,589,40740,4625,2,67,2,694.21,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2255,7562,589,40740,4625,2,13,1,4000.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2256,7562,590,40740,4625,2,96,2,12892.56,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2257,7562,590,40740,4625,2,67,2,2707.44,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2258,7562,590,40740,4625,2,13,1,15600.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2259,7562,591,40740,4625,2,96,2,1652.89,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2260,7562,591,40740,4625,2,67,2,347.11,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2261,7562,591,40740,4625,2,13,1,2000.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2262,7562,592,40740,4625,2,96,2,4876.03,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2263,7562,592,40740,4625,2,67,2,1023.97,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2264,7562,592,40740,4625,2,13,1,5900.00,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2265,7562,593,40740,4625,2,96,2,12892.56,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2266,7562,593,40740,4625,2,67,2,2707.44,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(2267,7562,593,40740,4625,2,13,1,15600.00,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2268,7562,594,40740,4625,2,96,2,5950.41,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2269,7562,594,40740,4625,2,67,2,1249.59,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2270,7562,594,40740,4625,2,13,1,7200.00,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2271,7562,595,40740,4625,2,96,2,1404.96,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2272,7562,595,40740,4625,2,67,2,295.04,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2273,7562,595,40740,4625,2,13,1,1700.00,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2274,7562,596,40740,4625,2,96,2,5371.90,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2275,7562,596,40740,4625,2,67,2,1128.10,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2276,7562,596,40740,4625,2,13,1,6500.00,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2277,7562,597,40740,4625,2,96,2,4132.23,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2278,7562,597,40740,4625,2,67,2,867.77,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2279,7562,597,40740,4625,2,13,1,5000.00,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2280,7562,598,40740,4625,2,96,2,7355.37,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2281,7562,598,40740,4625,2,67,2,1544.63,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2282,7562,598,40740,4625,2,13,1,8900.00,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(2283,7562,599,40740,4625,3,217,1,13140.50,NULL,'2023-06-12 15:18:46','2023-06-12 15:26:39','2023-06-12 15:26:39'),(2284,7562,599,40740,4625,3,68,1,2759.50,NULL,'2023-06-12 15:18:46','2023-06-12 15:26:39','2023-06-12 15:26:39'),(2285,7562,599,40740,4625,3,57,2,15900.00,NULL,'2023-06-12 15:18:46','2023-06-12 15:26:39','2023-06-12 15:26:39'),(2286,7562,600,40740,4625,3,217,1,82328.40,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2287,7562,600,40740,4625,3,68,1,17288.96,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL);
INSERT INTO `balance_libro_details` VALUES (2288,7562,600,40740,4625,3,57,2,99617.36,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2289,7562,601,40740,4625,3,217,1,123.97,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2290,7562,601,40740,4625,3,68,1,26.03,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2291,7562,601,40740,4625,3,57,2,150.00,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2292,7562,602,40740,4625,3,217,1,10492.70,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2293,7562,602,40740,4625,3,68,1,2203.47,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2294,7562,602,40740,4625,3,57,2,12696.17,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2295,7562,603,40740,4625,3,217,1,4410.00,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2296,7562,603,40740,4625,3,68,1,926.10,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2297,7562,603,40740,4625,3,57,2,5336.10,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2298,7562,604,40740,4625,3,217,1,3388.43,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2299,7562,604,40740,4625,3,68,1,711.57,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2300,7562,604,40740,4625,3,57,2,4100.00,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2301,7562,605,40740,4625,3,217,1,7431.70,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2302,7562,605,40740,4625,3,68,1,1560.66,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2303,7562,605,40740,4625,3,57,2,8992.36,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2304,7562,606,40740,4625,3,217,1,11572.00,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2305,7562,606,40740,4625,3,68,1,2430.12,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2306,7562,606,40740,4625,3,57,2,14002.12,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2307,7562,607,40740,4625,3,217,1,7431.70,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2308,7562,607,40740,4625,3,68,1,1560.66,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2309,7562,607,40740,4625,3,57,2,8992.36,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2310,7562,608,40740,4625,3,217,1,10774.00,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2311,7562,608,40740,4625,3,68,1,2262.54,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2312,7562,608,40740,4625,3,57,2,13036.54,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2313,7562,609,40740,4625,3,217,1,22295.10,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2314,7562,609,40740,4625,3,68,1,4681.97,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2315,7562,609,40740,4625,3,57,2,26977.07,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2316,7562,610,40740,4625,3,217,1,22295.10,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2317,7562,610,40740,4625,3,68,1,4681.97,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2318,7562,610,40740,4625,3,57,2,26977.07,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2319,7562,611,40740,4625,3,217,1,22295.10,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2320,7562,611,40740,4625,3,68,1,4681.97,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2321,7562,611,40740,4625,3,57,2,26977.07,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(2322,7562,612,40740,4625,3,217,1,5669.43,NULL,'2023-06-12 15:18:46','2023-06-12 15:26:21','2023-06-12 15:26:21'),(2323,7562,612,40740,4625,3,68,1,1190.58,NULL,'2023-06-12 15:18:46','2023-06-12 15:26:21','2023-06-12 15:26:21'),(2324,7562,612,40740,4625,3,57,2,6860.01,NULL,'2023-06-12 15:18:46','2023-06-12 15:26:21','2023-06-12 15:26:21'),(2325,7562,613,40740,4625,3,217,1,4380.17,NULL,'2023-06-12 15:18:47','2023-06-12 15:26:13','2023-06-12 15:26:13'),(2326,7562,613,40740,4625,3,68,1,919.83,NULL,'2023-06-12 15:18:47','2023-06-12 15:26:13','2023-06-12 15:26:13'),(2327,7562,613,40740,4625,3,57,2,5300.00,NULL,'2023-06-12 15:18:47','2023-06-12 15:26:13','2023-06-12 15:26:13');
INSERT INTO `balance_libro_details` VALUES (2328,7562,614,40740,4625,3,217,1,5669.43,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(2329,7562,614,40740,4625,3,68,1,1190.58,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(2330,7562,614,40740,4625,3,57,2,6860.01,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(2331,7562,615,40740,4625,3,217,1,5500.46,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(2332,7562,615,40740,4625,3,68,1,1155.10,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(2333,7562,615,40740,4625,3,217,1,165.01,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(2334,7562,615,40740,4625,3,57,2,6820.57,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(2335,7562,616,40740,4625,3,217,1,746.91,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(2336,7562,616,40740,4625,3,68,1,156.85,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(2337,7562,616,40740,4625,3,57,2,903.76,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(2338,7562,617,40740,4625,3,217,1,7280.99,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(2339,7562,617,40740,4625,3,68,1,1529.01,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(2340,7562,617,40740,4625,3,57,2,8810.00,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(2341,7562,618,40740,4625,3,217,1,7773.95,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2342,7562,618,40740,4625,3,68,1,1632.53,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2343,7562,618,40740,4625,3,217,1,593.57,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2344,7562,618,40740,4625,3,57,2,10000.05,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2345,7562,619,40740,4625,3,217,1,66600.00,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2346,7562,619,40740,4625,3,68,1,13986.00,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2347,7562,619,40740,4625,3,57,2,80586.00,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2348,7562,620,40740,4625,3,217,1,314280.00,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2349,7562,620,40740,4625,3,68,1,65998.80,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2350,7562,620,40740,4625,3,57,2,380278.80,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2351,7562,621,40740,4625,3,217,1,77760.00,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2352,7562,621,40740,4625,3,68,1,16329.60,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2353,7562,621,40740,4625,3,57,2,94089.60,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2354,7562,622,40740,4625,3,217,1,181680.00,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2355,7562,622,40740,4625,3,68,1,38152.80,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2356,7562,622,40740,4625,3,57,2,219832.80,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2357,7562,623,40740,4625,3,217,1,7034.81,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2358,7562,623,40740,4625,3,68,1,1477.33,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2359,7562,623,40740,4625,3,57,2,8512.14,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(2360,7562,624,40720,1541,3,250,1,12449.50,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2361,7562,624,40720,1541,3,68,1,2614.40,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2362,7562,624,40720,1541,3,57,2,15063.90,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2363,7562,625,40720,1541,3,217,1,169382.92,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2364,7562,625,40720,1541,3,57,2,169382.92,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2365,7562,626,40720,1541,3,250,1,11500.00,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2366,7562,626,40720,1541,3,57,2,11500.00,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2367,7562,627,40720,1541,3,250,1,7569.17,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2368,7562,627,40720,1541,3,68,1,1589.53,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL);
INSERT INTO `balance_libro_details` VALUES (2369,7562,627,40720,1541,3,57,2,9158.70,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2370,7562,628,40720,1541,3,250,1,14257.72,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2371,7562,628,40720,1541,3,68,1,2994.12,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2372,7562,628,40720,1541,3,57,2,17251.84,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2373,7562,629,40720,1541,3,250,1,4347.24,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2374,7562,629,40720,1541,3,68,1,912.92,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2375,7562,629,40720,1541,3,57,2,5260.16,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2376,7562,630,40720,1541,3,237,1,478.81,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2377,7562,630,40720,1541,3,220,1,262.74,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2378,7562,630,40720,1541,3,250,1,7408.00,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2379,7562,630,40720,1541,3,68,1,1555.68,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2380,7562,630,40720,1541,3,250,1,1349.93,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2381,7562,630,40720,1541,3,68,1,364.48,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2382,7562,630,40720,1541,3,57,2,11419.64,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2383,7562,631,40720,1541,3,250,1,10391.36,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2384,7562,631,40720,1541,3,68,1,2182.19,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2385,7562,631,40720,1541,3,57,2,12573.55,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2386,7562,632,40720,1541,3,250,1,54263.36,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2387,7562,632,40720,1541,3,57,2,54263.36,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2388,7562,633,40720,1541,3,250,2,7248.00,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2389,7562,633,40720,1541,3,67,2,1522.08,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2390,7562,633,40720,1541,3,57,1,8770.08,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2391,7562,634,40720,1541,3,250,1,11846.78,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2392,7562,634,40720,1541,3,68,1,2487.82,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2393,7562,634,40720,1541,3,57,2,14334.60,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2394,7562,635,40720,1541,3,250,1,10591.56,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2395,7562,635,40720,1541,3,68,1,2224.23,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2396,7562,635,40720,1541,3,57,2,12815.79,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2397,7562,636,40720,1541,3,250,1,38518.08,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2398,7562,636,40720,1541,3,68,1,8088.80,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2399,7562,636,40720,1541,3,57,2,46606.88,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2400,7562,637,40720,1541,3,250,1,2780.11,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2401,7562,637,40720,1541,3,68,1,583.82,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2402,7562,637,40720,1541,3,57,2,3363.93,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(2403,7562,638,40720,1541,3,250,1,8900.08,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(2404,7562,638,40720,1541,3,68,1,1869.02,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(2405,7562,638,40720,1541,3,57,2,10769.10,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(2406,7562,639,40720,1541,3,217,1,25000.00,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(2407,7562,639,40720,1541,3,57,2,25000.00,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(2408,7562,640,40720,1541,3,250,1,8893.50,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(2409,7562,640,40720,1541,3,68,1,1867.64,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL);
INSERT INTO `balance_libro_details` VALUES (2410,7562,640,40720,1541,3,57,2,10761.14,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(2411,7562,641,40720,1541,3,250,1,12463.15,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(2412,7562,641,40720,1541,3,68,1,2617.26,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(2413,7562,641,40720,1541,3,57,2,15080.41,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(2422,7562,646,40720,1541,2,218,2,0.00,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2423,7562,646,40720,1541,2,218,2,5368.00,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2424,7562,646,40720,1541,2,13,1,5368.00,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2425,7562,647,40720,1541,2,96,2,1487.61,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2426,7562,647,40720,1541,2,67,2,312.39,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2427,7562,647,40720,1541,2,13,1,1800.00,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2428,7562,648,40720,1541,2,218,2,0.00,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2429,7562,648,40720,1541,2,218,2,10000.00,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2430,7562,648,40720,1541,2,13,1,10000.00,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2431,7562,649,40720,1541,2,218,2,0.00,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2432,7562,649,40720,1541,2,218,2,5885.00,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2433,7562,649,40720,1541,2,13,1,5885.00,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2434,7562,650,40720,1541,2,218,2,0.00,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2435,7562,650,40720,1541,2,218,2,3155.00,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2436,7562,650,40720,1541,2,13,1,3155.00,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(2437,7562,651,40720,1541,2,96,2,110049.05,NULL,'2023-06-13 09:11:53','2023-06-13 09:11:53',NULL),(2438,7562,651,40720,1541,2,67,2,23110.30,NULL,'2023-06-13 09:11:53','2023-06-13 09:11:53',NULL),(2439,7562,651,40720,1541,2,218,2,1701109.15,NULL,'2023-06-13 09:11:53','2023-06-13 09:11:53',NULL),(2440,7562,651,40720,1541,2,13,1,1834268.50,NULL,'2023-06-13 09:11:53','2023-06-13 09:11:53',NULL),(2441,7562,652,40721,3053,3,217,1,1818.18,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2442,7562,652,40721,3053,3,68,1,381.82,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2443,7562,652,40721,3053,3,57,2,2200.00,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2444,7562,653,40721,3053,3,250,1,5000.00,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2445,7562,653,40721,3053,3,57,2,5000.00,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2446,7562,654,40721,3053,3,217,1,975.21,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2447,7562,654,40721,3053,3,68,1,204.79,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2448,7562,654,40721,3053,3,57,2,1180.00,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2449,7562,655,40721,3053,3,217,1,6000.82,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2450,7562,655,40721,3053,3,68,1,1260.17,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2451,7562,655,40721,3053,3,57,2,7260.99,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2452,7562,656,40721,3053,3,217,1,662.90,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2453,7562,656,40721,3053,3,68,1,139.21,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2454,7562,656,40721,3053,3,57,2,802.11,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2455,7562,657,40721,3053,3,217,1,182.00,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2456,7562,657,40721,3053,3,68,1,38.22,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2457,7562,657,40721,3053,3,57,2,220.22,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(2468,7562,660,40721,3053,3,221,1,356.14,NULL,'2023-06-13 13:11:32','2023-06-13 13:11:32',NULL);
INSERT INTO `balance_libro_details` VALUES (2469,7562,660,40721,3053,3,250,1,2332.19,NULL,'2023-06-13 13:11:32','2023-06-13 13:11:32',NULL),(2470,7562,660,40721,3053,3,68,1,489.76,NULL,'2023-06-13 13:11:32','2023-06-13 13:11:32',NULL),(2471,7562,660,40721,3053,3,250,1,178.08,NULL,'2023-06-13 13:11:32','2023-06-13 13:11:32',NULL),(2472,7562,660,40721,3053,3,57,2,3356.17,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2473,7562,661,40721,3053,3,221,1,593.58,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2474,7562,661,40721,3053,3,250,1,3886.95,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2475,7562,661,40721,3053,3,68,1,816.26,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2476,7562,661,40721,3053,3,250,1,296.77,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2477,7562,661,40721,3053,3,57,2,5593.56,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2478,7562,662,40721,3053,3,221,1,593.58,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2479,7562,662,40721,3053,3,250,1,3886.95,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2480,7562,662,40721,3053,3,68,1,816.26,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2481,7562,662,40721,3053,3,250,1,296.77,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2482,7562,662,40721,3053,3,57,2,5593.56,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2483,7562,663,40721,3053,3,221,1,1258.72,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2484,7562,663,40721,3053,3,250,1,4772.67,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2485,7562,663,40721,3053,3,68,1,1002.26,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2486,7562,663,40721,3053,3,250,1,629.37,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2487,7562,663,40721,3053,3,57,2,7663.02,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2488,7562,664,40721,3053,3,221,1,348.66,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2489,7562,664,40721,3053,3,250,1,2335.38,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2490,7562,664,40721,3053,3,68,1,490.43,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2491,7562,664,40721,3053,3,250,1,174.34,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2492,7562,664,40721,3053,3,57,2,3348.81,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2493,7562,665,40721,3053,3,221,1,444.38,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2494,7562,665,40721,3053,3,250,1,3122.10,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2495,7562,665,40721,3053,3,68,1,655.64,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2496,7562,665,40721,3053,3,250,1,222.19,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2497,7562,665,40721,3053,3,57,2,4444.31,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2498,7562,666,40721,3053,3,221,1,333.30,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2499,7562,666,40721,3053,3,250,1,2341.71,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2500,7562,666,40721,3053,3,68,1,491.76,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2501,7562,666,40721,3053,3,250,1,166.66,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2502,7562,666,40721,3053,3,57,2,3333.43,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2503,7562,667,40721,3053,3,221,1,1110.98,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2504,7562,667,40721,3053,3,250,1,7805.43,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2505,7562,667,40721,3053,3,68,1,1639.14,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2506,7562,667,40721,3053,3,250,1,555.48,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2507,7562,667,40721,3053,3,57,2,11111.03,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(2508,7562,668,40778,7664,19,359,1,27414.11,NULL,'2023-06-13 16:16:05','2023-06-13 16:16:05',NULL),(2509,7562,668,40778,7664,19,410,1,2250.00,NULL,'2023-06-13 16:16:05','2023-06-13 16:16:05',NULL);
INSERT INTO `balance_libro_details` VALUES (2510,7562,668,40778,7664,19,386,1,92597.61,NULL,'2023-06-13 16:16:05','2023-06-13 16:16:05',NULL),(2511,7562,668,40778,7664,19,369,2,2250.00,NULL,'2023-06-13 16:16:05','2023-06-13 16:16:05',NULL),(2512,7562,668,40778,7664,19,88,2,4153.70,NULL,'2023-06-13 16:16:05','2023-06-13 16:16:05',NULL),(2513,7562,668,40778,7664,19,383,2,113555.47,NULL,'2023-06-13 16:16:05','2023-06-13 16:16:05',NULL),(2514,7562,668,40778,7664,19,30,2,2302.55,NULL,'2023-06-13 16:16:05','2023-06-13 16:16:05',NULL),(2515,7562,669,40778,7664,2,96,2,4100.00,NULL,'2023-06-13 16:38:12','2023-06-13 16:38:12',NULL),(2516,7562,669,40778,7664,2,359,1,4100.00,NULL,'2023-06-13 16:38:12','2023-06-13 16:38:12',NULL),(2517,7562,670,40778,7665,2,359,1,4100.00,NULL,'2023-06-13 16:38:54','2023-06-13 16:38:54',NULL),(2518,7562,670,40778,7665,2,96,2,4100.00,NULL,'2023-06-13 16:38:54','2023-06-13 16:38:54',NULL),(2519,7562,671,40778,7666,2,359,1,4100.00,NULL,'2023-06-13 16:39:31','2023-06-13 16:39:31',NULL),(2520,7562,671,40778,7666,2,96,2,4100.00,NULL,'2023-06-13 16:39:31','2023-06-13 16:39:31',NULL),(2521,7562,672,40778,7667,2,359,1,4000.00,NULL,'2023-06-13 16:40:09','2023-06-13 16:40:09',NULL),(2522,7562,672,40778,7667,2,96,2,4000.00,NULL,'2023-06-13 16:40:09','2023-06-13 16:40:09',NULL),(2523,7562,673,40778,7668,19,359,1,4000.00,NULL,'2023-06-13 16:44:30','2023-06-13 16:44:30',NULL),(2524,7562,673,40778,7668,19,96,2,4000.00,NULL,'2023-06-13 16:44:30','2023-06-13 16:44:30',NULL),(2525,7562,673,40778,7668,19,492,1,410.00,NULL,'2023-06-13 16:44:30','2023-06-13 16:44:30',NULL),(2526,7562,673,40778,7668,19,488,1,13268.00,NULL,'2023-06-13 16:44:30','2023-06-13 16:44:30',NULL),(2527,7562,673,40778,7668,19,135,1,1000.00,NULL,'2023-06-13 16:44:30','2023-06-13 16:44:30',NULL),(2528,7562,673,40778,7668,19,359,2,14678.00,NULL,'2023-06-13 16:44:30','2023-06-13 16:44:30',NULL),(2529,7562,674,40778,7670,2,359,1,3800.00,NULL,'2023-06-13 16:45:02','2023-06-13 16:45:02',NULL),(2530,7562,674,40778,7670,2,96,2,3800.00,NULL,'2023-06-13 16:45:02','2023-06-13 16:45:02',NULL),(2531,7562,675,40778,7671,2,359,1,3700.00,NULL,'2023-06-13 16:45:37','2023-06-13 16:45:37',NULL),(2532,7562,675,40778,7671,2,96,2,3700.00,NULL,'2023-06-13 16:45:37','2023-06-13 16:45:37',NULL),(2533,7562,676,40778,7672,2,359,1,5450.00,NULL,'2023-06-13 16:46:15','2023-06-13 16:46:15',NULL),(2534,7562,676,40778,7672,2,96,2,5450.00,NULL,'2023-06-13 16:46:15','2023-06-13 16:46:15',NULL),(2535,7562,677,40778,7673,2,359,1,5550.00,NULL,'2023-06-13 16:46:51','2023-06-13 16:46:51',NULL),(2536,7562,677,40778,7673,2,96,2,5550.00,NULL,'2023-06-13 16:46:51','2023-06-13 16:46:51',NULL),(2537,7562,678,40778,7674,2,359,1,5400.00,NULL,'2023-06-13 16:47:34','2023-06-13 16:47:34',NULL),(2538,7562,678,40778,7674,2,96,2,5400.00,NULL,'2023-06-13 16:47:34','2023-06-13 16:47:34',NULL),(2539,7562,679,40778,7675,2,359,1,5400.00,NULL,'2023-06-13 16:48:06','2023-06-13 16:48:06',NULL),(2540,7562,679,40778,7675,2,96,2,5400.00,NULL,'2023-06-13 16:48:06','2023-06-13 16:48:06',NULL),(2541,7562,680,40778,7676,2,359,1,5350.00,NULL,'2023-06-13 16:48:40','2023-06-13 16:48:40',NULL),(2542,7562,680,40778,7676,2,96,2,5350.00,NULL,'2023-06-13 16:48:40','2023-06-13 16:48:40',NULL),(2543,7562,681,40778,7676,2,386,1,23044.09,NULL,'2023-06-23 12:54:42','2023-06-23 12:54:42',NULL),(2544,7562,681,40778,7676,2,30,2,1273.28,NULL,'2023-06-23 12:54:42','2023-06-23 12:54:42',NULL),(2545,7562,681,40778,7676,2,102,2,21770.81,NULL,'2023-06-23 12:54:42','2023-06-23 12:54:42',NULL),(2546,7562,682,40778,7676,19,359,1,2250.00,NULL,'2023-06-23 13:46:59','2023-06-23 13:46:59',NULL),(2547,7562,682,40778,7676,19,410,2,2250.00,NULL,'2023-06-23 13:46:59','2023-06-23 13:46:59',NULL),(2548,7562,683,40778,7676,23,96,2,11330.08,NULL,'2023-06-23 13:49:32','2023-06-23 13:49:32',NULL),(2549,7562,683,40778,7676,23,88,2,1984.47,NULL,'2023-06-23 13:49:32','2023-06-23 13:49:32',NULL),(2550,7562,683,40778,7676,23,383,2,54252.32,NULL,'2023-06-23 13:49:32','2023-06-23 13:49:32',NULL);
INSERT INTO `balance_libro_details` VALUES (2551,7562,683,40778,7676,23,88,2,1074.96,NULL,'2023-06-23 13:49:32','2023-06-23 13:49:32',NULL),(2552,7562,683,40778,7676,23,488,1,3858.38,NULL,'2023-06-23 13:49:32','2023-06-23 13:49:32',NULL),(2553,7562,683,40778,7676,23,135,1,290.80,NULL,'2023-06-23 13:49:32','2023-06-23 13:49:32',NULL),(2554,7562,683,40778,7676,23,492,1,119.23,NULL,'2023-06-23 13:49:32','2023-06-23 13:49:32',NULL),(2555,7562,683,40778,7676,23,476,1,64373.42,NULL,'2023-06-23 13:49:32','2023-06-23 13:49:32',NULL),(2556,7562,684,40778,7677,19,359,1,69936.11,NULL,'2023-06-23 15:19:06','2023-06-23 15:19:06',NULL),(2557,7562,684,40778,7677,19,386,1,115641.70,NULL,'2023-06-23 15:19:06','2023-06-23 15:19:06',NULL),(2558,7562,684,40778,7677,19,30,2,3575.83,NULL,'2023-06-23 15:19:06','2023-06-23 15:19:06',NULL),(2559,7562,684,40778,7677,19,369,2,2250.00,NULL,'2023-06-23 15:19:06','2023-06-23 15:19:06',NULL),(2560,7562,684,40778,7677,19,88,2,7213.14,NULL,'2023-06-23 15:19:06','2023-06-23 15:19:06',NULL),(2561,7562,684,40778,7677,19,383,2,172538.84,NULL,'2023-06-23 15:19:06','2023-06-23 15:19:06',NULL),(2562,7562,685,40778,7677,2,359,1,5300.00,NULL,'2023-06-23 15:20:20','2023-06-23 15:20:20',NULL),(2563,7562,685,40778,7677,2,96,2,5300.00,NULL,'2023-06-23 15:20:20','2023-06-23 15:20:20',NULL),(2564,7562,686,40778,7678,2,359,1,5200.00,NULL,'2023-06-23 15:20:59','2023-06-23 15:20:59',NULL),(2565,7562,686,40778,7678,2,96,2,5200.00,NULL,'2023-06-23 15:20:59','2023-06-23 15:20:59',NULL),(2566,7562,687,40778,7679,2,359,1,5100.00,NULL,'2023-06-23 15:21:34','2023-06-23 15:21:34',NULL),(2567,7562,687,40778,7679,2,96,2,5100.00,NULL,'2023-06-23 15:21:34','2023-06-23 15:21:34',NULL),(2568,7562,688,40778,7680,2,359,1,4800.00,NULL,'2023-06-23 15:22:37','2023-06-23 15:22:37',NULL),(2569,7562,688,40778,7680,2,96,2,4800.00,NULL,'2023-06-23 15:22:37','2023-06-23 15:22:37',NULL),(2570,7562,689,40778,7681,2,359,1,4700.00,NULL,'2023-06-23 15:23:12','2023-06-23 15:23:12',NULL),(2571,7562,689,40778,7681,2,96,2,4700.00,NULL,'2023-06-23 15:23:12','2023-06-23 15:23:12',NULL),(2572,7562,690,40778,7685,2,359,1,6400.00,NULL,'2023-06-23 15:23:54','2023-06-23 15:23:54',NULL),(2573,7562,690,40778,7685,2,96,2,6400.00,NULL,'2023-06-23 15:23:54','2023-06-23 15:23:54',NULL),(2574,7562,691,40778,7686,2,359,1,6400.00,NULL,'2023-06-23 15:24:30','2023-06-23 15:24:30',NULL),(2575,7562,691,40778,7686,2,96,2,6400.00,NULL,'2023-06-23 15:24:30','2023-06-23 15:24:30',NULL),(2576,7562,692,40778,7687,2,359,1,6150.00,NULL,'2023-06-23 15:25:40','2023-06-23 15:25:40',NULL),(2577,7562,692,40778,7687,2,96,2,6150.00,NULL,'2023-06-23 15:25:40','2023-06-23 15:25:40',NULL),(2578,7562,693,40778,7688,2,359,1,6150.00,NULL,'2023-06-23 15:26:12','2023-06-23 15:26:12',NULL),(2579,7562,693,40778,7688,2,96,2,6150.00,NULL,'2023-06-23 15:26:12','2023-06-23 15:26:12',NULL),(2580,7562,694,40778,7689,2,359,1,7950.00,NULL,'2023-06-23 15:26:43','2023-06-23 15:26:43',NULL),(2581,7562,694,40778,7689,2,96,2,7950.00,NULL,'2023-06-23 15:26:43','2023-06-23 15:26:43',NULL),(2582,7562,695,40778,7690,2,359,1,7750.00,NULL,'2023-06-23 15:27:14','2023-06-23 15:27:14',NULL),(2583,7562,695,40778,7690,2,96,2,7750.00,NULL,'2023-06-23 15:27:14','2023-06-23 15:27:14',NULL),(2584,7562,696,40778,7691,2,359,1,7050.00,NULL,'2023-06-23 15:27:54','2023-06-23 15:27:54',NULL),(2585,7562,696,40778,7691,2,96,2,7050.00,NULL,'2023-06-23 15:27:54','2023-06-23 15:27:54',NULL),(2586,7562,697,40778,7681,3,488,1,17330.00,NULL,'2023-06-23 15:45:39','2023-06-23 15:45:39',NULL),(2587,7562,697,40778,7681,3,135,1,410.00,NULL,'2023-06-23 15:45:39','2023-06-23 15:45:39',NULL),(2588,7562,697,40778,7681,3,221,1,7620.00,NULL,'2023-06-23 15:45:39','2023-06-23 15:45:39',NULL),(2589,7562,697,40778,7681,3,396,1,2500.00,NULL,'2023-06-23 15:45:39','2023-06-23 15:45:39',NULL),(2590,7562,697,40778,7681,3,359,2,27860.00,NULL,'2023-06-23 15:45:39','2023-06-23 15:45:39',NULL),(2591,7562,698,40778,7691,2,386,1,31962.55,NULL,'2023-06-23 15:47:35','2023-06-23 15:47:35',NULL);
INSERT INTO `balance_libro_details` VALUES (2592,7562,698,40778,7691,2,102,2,29324.35,NULL,'2023-06-23 15:47:35','2023-06-23 15:47:35',NULL),(2593,7562,698,40778,7691,2,30,2,2638.20,NULL,'2023-06-23 15:47:35','2023-06-23 15:47:35',NULL),(2594,7562,699,40778,7691,23,383,2,115399.10,NULL,'2023-06-23 16:02:42','2023-06-23 16:02:42',NULL),(2595,7562,699,40778,7691,23,88,2,1504.87,NULL,'2023-06-23 16:02:42','2023-06-23 16:02:42',NULL),(2596,7562,699,40778,7691,23,96,2,23413.28,NULL,'2023-06-23 16:02:42','2023-06-23 16:02:42',NULL),(2597,7562,699,40778,7691,23,88,2,4824.36,NULL,'2023-06-23 16:02:42','2023-06-23 16:02:42',NULL),(2598,7562,699,40778,7691,23,135,1,189.57,NULL,'2023-06-23 16:02:42','2023-06-23 16:02:42',NULL),(2599,7562,699,40778,7691,23,488,1,8012.65,NULL,'2023-06-23 16:02:42','2023-06-23 16:02:42',NULL),(2600,7562,699,40778,7691,23,476,1,136939.39,NULL,'2023-06-23 16:02:42','2023-06-23 16:02:42',NULL),(2601,7562,700,40720,1542,2,218,2,10766.00,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(2602,7562,700,40720,1542,2,13,1,10766.00,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(2603,7562,701,40720,1542,2,218,2,3000.00,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(2604,7562,701,40720,1542,2,13,1,3000.00,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(2605,7562,702,40720,1542,2,218,2,4800.00,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(2606,7562,702,40720,1542,2,13,1,4800.00,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(2607,7562,703,40720,1542,2,218,2,1597483.04,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(2608,7562,703,40720,1542,2,96,2,154733.90,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(2609,7562,703,40720,1542,2,67,2,16247.06,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(2610,7562,703,40720,1542,2,13,1,1768464.00,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(2611,7562,704,40720,1542,2,218,2,4800.00,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(2612,7562,704,40720,1542,2,13,1,4800.00,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(2613,7562,705,40720,1542,3,217,1,147054.11,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(2614,7562,705,40720,1542,3,57,2,147054.11,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(2615,7562,706,40720,1542,3,250,1,8865.72,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(2616,7562,706,40720,1542,3,68,1,1861.80,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(2617,7562,706,40720,1542,3,57,2,10727.52,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(2618,7562,707,40720,1542,3,250,1,55802.86,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(2619,7562,707,40720,1542,3,57,2,55802.86,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(2620,7562,708,40720,1542,3,217,1,30000.00,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(2621,7562,708,40720,1542,3,57,2,30000.00,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(2622,7562,709,40720,1542,3,250,1,7764.00,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(2623,7562,709,40720,1542,3,68,1,1630.44,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(2624,7562,709,40720,1542,3,57,2,9394.44,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(2625,7562,710,40720,1542,3,250,1,6159.62,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2626,7562,710,40720,1542,3,68,1,1293.52,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2627,7562,710,40720,1542,3,57,2,7453.14,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2628,7562,711,40720,1542,3,237,1,504.75,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2629,7562,711,40720,1542,3,220,1,278.04,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2630,7562,711,40720,1542,3,250,1,8153.00,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2631,7562,711,40720,1542,3,68,1,1712.13,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2632,7562,711,40720,1542,3,250,1,1114.94,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL);
INSERT INTO `balance_libro_details` VALUES (2633,7562,711,40720,1542,3,68,1,301.03,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2634,7562,711,40720,1542,3,57,2,12063.89,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2635,7562,712,40720,1542,3,250,1,20592.61,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2636,7562,712,40720,1542,3,68,1,4324.45,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2637,7562,712,40720,1542,3,57,2,24917.06,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2638,7562,713,40720,1542,3,250,1,13291.34,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2639,7562,713,40720,1542,3,68,1,2791.18,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2640,7562,713,40720,1542,3,57,2,16082.52,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2641,7562,714,40720,1542,3,250,1,22973.61,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2642,7562,714,40720,1542,3,68,1,4824.46,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2643,7562,714,40720,1542,3,57,2,27798.07,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2644,7562,715,40720,1542,3,250,1,19143.30,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2645,7562,715,40720,1542,3,68,1,4020.09,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2646,7562,715,40720,1542,3,57,2,23163.39,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2647,7562,716,40720,1542,3,221,2,57.61,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2648,7562,716,40720,1542,3,237,2,104.60,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2649,7562,716,40720,1542,3,250,2,1689.55,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2650,7562,716,40720,1542,3,67,2,354.81,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2651,7562,716,40720,1542,3,250,2,231.04,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2652,7562,716,40720,1542,3,67,2,62.38,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2653,7562,716,40720,1542,3,57,1,2499.99,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2654,7562,717,40720,1542,3,250,1,28405.47,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2655,7562,717,40720,1542,3,68,1,5965.15,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2656,7562,717,40720,1542,3,57,2,34370.62,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2657,7562,718,40720,1542,3,250,1,9379.78,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2658,7562,718,40720,1542,3,68,1,1969.75,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2659,7562,718,40720,1542,3,57,2,11349.53,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(2660,7562,719,40740,4626,2,96,2,11107.44,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2661,7562,719,40740,4626,2,67,2,2332.56,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2662,7562,719,40740,4626,2,13,1,13440.00,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2663,7562,720,40740,4626,2,96,2,9917.36,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2664,7562,720,40740,4626,2,67,2,2082.64,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2665,7562,720,40740,4626,2,13,1,12000.00,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2666,7562,721,40740,4626,2,96,2,17851.24,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2667,7562,721,40740,4626,2,67,2,3748.76,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2668,7562,721,40740,4626,2,13,1,21600.00,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2669,7562,722,40740,4626,2,96,2,9818.18,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2670,7562,722,40740,4626,2,67,2,2061.82,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2671,7562,722,40740,4626,2,13,1,11880.00,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2672,7562,723,40740,4626,2,96,2,4876.03,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2673,7562,723,40740,4626,2,67,2,1023.97,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL);
INSERT INTO `balance_libro_details` VALUES (2674,7562,723,40740,4626,2,13,1,5900.00,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2675,7562,724,40740,4626,2,96,2,10743.80,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2676,7562,724,40740,4626,2,67,2,2256.20,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2677,7562,724,40740,4626,2,13,1,13000.00,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2678,7562,725,40740,4626,2,96,2,5454.55,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2679,7562,725,40740,4626,2,67,2,1145.45,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2680,7562,725,40740,4626,2,13,1,6600.00,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2681,7562,726,40740,4626,2,96,2,8925.62,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2682,7562,726,40740,4626,2,67,2,1874.38,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2683,7562,726,40740,4626,2,13,1,10800.00,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2684,7562,727,40740,4626,2,96,2,3553.72,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2685,7562,727,40740,4626,2,67,2,746.28,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2686,7562,727,40740,4626,2,13,1,4300.00,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2687,7562,728,40740,4626,2,96,2,20495.87,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2688,7562,728,40740,4626,2,67,2,4304.13,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2689,7562,728,40740,4626,2,13,1,24800.00,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2690,7562,729,40740,4626,2,96,2,4710.74,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2691,7562,729,40740,4626,2,67,2,989.26,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2692,7562,729,40740,4626,2,13,1,5700.00,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(2693,7562,730,40740,4626,2,96,2,991.74,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2694,7562,730,40740,4626,2,67,2,208.26,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2695,7562,730,40740,4626,2,13,1,1200.00,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2696,7562,731,40740,4626,2,96,2,8264.46,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2697,7562,731,40740,4626,2,67,2,1735.54,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2698,7562,731,40740,4626,2,13,1,10000.00,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2699,7562,732,40740,4626,2,96,2,9917.36,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2700,7562,732,40740,4626,2,67,2,2082.64,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2701,7562,732,40740,4626,2,13,1,12000.00,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2702,7562,733,40740,4626,2,96,2,7355.37,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2703,7562,733,40740,4626,2,67,2,1544.63,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2704,7562,733,40740,4626,2,13,1,8900.00,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2705,7562,734,40740,4626,2,96,2,11570.25,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2706,7562,734,40740,4626,2,67,2,2429.75,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2707,7562,734,40740,4626,2,13,1,14000.00,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2708,7562,735,40740,4626,2,96,2,8925.62,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2709,7562,735,40740,4626,2,67,2,1874.38,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2710,7562,735,40740,4626,2,13,1,10800.00,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2711,7562,736,40740,4626,2,96,2,15867.77,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2712,7562,736,40740,4626,2,67,2,3332.23,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2713,7562,736,40740,4626,2,13,1,19200.00,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2714,7562,737,40740,4626,2,96,2,15768.60,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL);
INSERT INTO `balance_libro_details` VALUES (2715,7562,737,40740,4626,2,67,2,3311.40,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2716,7562,737,40740,4626,2,13,1,19080.00,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2717,7562,738,40740,4626,2,96,2,6115.70,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2718,7562,738,40740,4626,2,67,2,1284.30,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2719,7562,738,40740,4626,2,13,1,7400.00,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2720,7562,739,40740,4626,2,96,2,7355.37,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2721,7562,739,40740,4626,2,67,2,1544.63,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2722,7562,739,40740,4626,2,13,1,8900.00,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(2723,7562,740,40740,4626,2,96,2,7355.37,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2724,7562,740,40740,4626,2,67,2,1544.63,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2725,7562,740,40740,4626,2,13,1,8900.00,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2726,7562,741,40740,4626,2,96,2,8264.46,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2727,7562,741,40740,4626,2,67,2,1735.54,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2728,7562,741,40740,4626,2,13,1,10000.00,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2729,7562,742,40740,4626,2,96,2,11404.96,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2730,7562,742,40740,4626,2,67,2,2395.04,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2731,7562,742,40740,4626,2,13,1,13800.00,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2732,7562,743,40740,4626,2,96,2,4876.03,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2733,7562,743,40740,4626,2,67,2,1023.97,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2734,7562,743,40740,4626,2,13,1,5900.00,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2735,7562,744,40740,4626,2,96,2,6115.70,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2736,7562,744,40740,4626,2,67,2,1284.30,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2737,7562,744,40740,4626,2,13,1,7400.00,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2738,7562,745,40740,4626,2,96,2,8264.46,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2739,7562,745,40740,4626,2,67,2,1735.54,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2740,7562,745,40740,4626,2,13,1,10000.00,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2741,7562,746,40740,4626,2,96,2,8264.46,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2742,7562,746,40740,4626,2,67,2,1735.54,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2743,7562,746,40740,4626,2,13,1,10000.00,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2744,7562,747,40740,4626,2,96,2,8264.46,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2745,7562,747,40740,4626,2,67,2,1735.54,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2746,7562,747,40740,4626,2,13,1,10000.00,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2747,7562,748,40740,4626,2,96,2,4545.45,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2748,7562,748,40740,4626,2,67,2,954.55,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2749,7562,748,40740,4626,2,13,1,5500.00,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2750,7562,749,40740,4626,2,96,2,4132.23,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2751,7562,749,40740,4626,2,67,2,867.77,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2752,7562,749,40740,4626,2,13,1,5000.00,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2753,7562,750,40740,4626,2,96,2,5702.48,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2754,7562,750,40740,4626,2,67,2,1197.52,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(2755,7562,750,40740,4626,2,13,1,6900.00,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL);
INSERT INTO `balance_libro_details` VALUES (2756,7562,751,40740,4626,2,96,2,7438.02,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2757,7562,751,40740,4626,2,67,2,1561.98,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2758,7562,751,40740,4626,2,13,1,9000.00,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2759,7562,752,40740,4626,2,96,2,7438.02,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2760,7562,752,40740,4626,2,67,2,1561.98,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2761,7562,752,40740,4626,2,13,1,9000.00,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2762,7562,753,40740,4626,2,96,2,18677.69,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2763,7562,753,40740,4626,2,67,2,3922.31,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2764,7562,753,40740,4626,2,13,1,22600.00,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2765,7562,754,40740,4626,2,96,2,9752.07,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2766,7562,754,40740,4626,2,67,2,2047.93,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2767,7562,754,40740,4626,2,13,1,11800.00,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2768,7562,755,40740,4626,2,96,2,6842.98,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2769,7562,755,40740,4626,2,67,2,1437.02,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2770,7562,755,40740,4626,2,13,1,8280.00,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2771,7562,756,40740,4626,2,96,2,6842.98,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2772,7562,756,40740,4626,2,67,2,1437.02,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2773,7562,756,40740,4626,2,13,1,8280.00,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2774,7562,757,40740,4626,2,96,2,5702.48,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2775,7562,757,40740,4626,2,67,2,1197.52,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2776,7562,757,40740,4626,2,13,1,6900.00,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2777,7562,758,40740,4626,2,96,2,4380.17,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2778,7562,758,40740,4626,2,67,2,919.83,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2779,7562,758,40740,4626,2,13,1,5300.00,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2780,7562,759,40740,4626,2,96,2,4132.23,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2781,7562,759,40740,4626,2,67,2,867.77,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2782,7562,759,40740,4626,2,13,1,5000.00,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2783,7562,760,40740,4626,2,96,2,8181.82,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2784,7562,760,40740,4626,2,67,2,1718.18,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2785,7562,760,40740,4626,2,13,1,9900.00,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2786,7562,761,40740,4626,2,96,2,18677.69,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2787,7562,761,40740,4626,2,67,2,3922.31,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2788,7562,761,40740,4626,2,13,1,22600.00,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2789,7562,762,40740,4626,2,96,2,9752.07,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2790,7562,762,40740,4626,2,67,2,2047.93,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2791,7562,762,40740,4626,2,13,1,11800.00,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(2792,7562,763,40740,4626,2,96,2,6528.93,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2793,7562,763,40740,4626,2,67,2,1371.07,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2794,7562,763,40740,4626,2,13,1,7900.00,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2795,7562,764,40740,4626,2,96,2,6528.93,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2796,7562,764,40740,4626,2,67,2,1371.07,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL);
INSERT INTO `balance_libro_details` VALUES (2797,7562,764,40740,4626,2,13,1,7900.00,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2798,7562,765,40740,4626,2,96,2,7355.37,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2799,7562,765,40740,4626,2,67,2,1544.63,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2800,7562,765,40740,4626,2,13,1,8900.00,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2801,7562,766,40740,4626,2,96,2,7355.37,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2802,7562,766,40740,4626,2,67,2,1544.63,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2803,7562,766,40740,4626,2,13,1,8900.00,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2804,7562,767,40740,4626,2,96,2,6528.93,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2805,7562,767,40740,4626,2,67,2,1371.07,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2806,7562,767,40740,4626,2,13,1,7900.00,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2807,7562,768,40740,4626,2,96,2,1652.89,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2808,7562,768,40740,4626,2,67,2,347.11,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2809,7562,768,40740,4626,2,13,1,2000.00,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2810,7562,769,40740,4626,2,96,2,5371.90,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2811,7562,769,40740,4626,2,67,2,1128.10,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2812,7562,769,40740,4626,2,13,1,6500.00,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2813,7562,770,40740,4626,2,96,2,24694.21,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2814,7562,770,40740,4626,2,67,2,5185.79,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2815,7562,770,40740,4626,2,13,1,29880.00,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2816,7562,771,40740,4626,2,96,2,13289.26,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2817,7562,771,40740,4626,2,67,2,2790.74,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2818,7562,771,40740,4626,2,13,1,16080.00,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2819,7562,772,40740,4626,2,96,2,7933.88,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2820,7562,772,40740,4626,2,67,2,1666.12,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2821,7562,772,40740,4626,2,13,1,9600.00,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2822,7562,773,40740,4626,2,96,2,7438.02,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2823,7562,773,40740,4626,2,67,2,1561.98,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2824,7562,773,40740,4626,2,13,1,9000.00,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(2825,7562,774,40740,4626,2,96,2,5785.12,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2826,7562,774,40740,4626,2,67,2,1214.88,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2827,7562,774,40740,4626,2,13,1,7000.00,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2828,7562,775,40740,4626,2,96,2,6528.93,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2829,7562,775,40740,4626,2,67,2,1371.07,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2830,7562,775,40740,4626,2,13,1,7900.00,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2831,7562,776,40740,4626,2,96,2,11404.96,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2832,7562,776,40740,4626,2,67,2,2395.04,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2833,7562,776,40740,4626,2,13,1,13800.00,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2834,7562,777,40740,4626,2,96,2,4958.68,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2835,7562,777,40740,4626,2,67,2,1041.32,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2836,7562,777,40740,4626,2,13,1,6000.00,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2837,7562,778,40740,4626,2,96,2,6842.98,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL);
INSERT INTO `balance_libro_details` VALUES (2838,7562,778,40740,4626,2,67,2,1437.02,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2839,7562,778,40740,4626,2,13,1,8280.00,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2840,7562,779,40740,4626,2,96,2,8925.62,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2841,7562,779,40740,4626,2,67,2,1874.38,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2842,7562,779,40740,4626,2,13,1,10800.00,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2843,7562,780,40740,4626,2,96,2,11239.67,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2844,7562,780,40740,4626,2,67,2,2360.33,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2845,7562,780,40740,4626,2,13,1,13600.00,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2846,7562,781,40740,4626,2,96,2,27768.60,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2847,7562,781,40740,4626,2,67,2,5831.40,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2848,7562,781,40740,4626,2,13,1,33600.00,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2849,7562,782,40740,4626,2,96,2,17851.24,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2850,7562,782,40740,4626,2,67,2,3748.76,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2851,7562,782,40740,4626,2,13,1,21600.00,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2852,7562,783,40740,4626,2,96,2,2396.69,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2853,7562,783,40740,4626,2,67,2,503.31,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2854,7562,783,40740,4626,2,13,1,2900.00,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(2855,7562,784,40740,4626,2,96,2,19008.26,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2856,7562,784,40740,4626,2,67,2,3991.74,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2857,7562,784,40740,4626,2,13,1,23000.00,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2858,7562,785,40740,4626,2,96,2,17851.24,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2859,7562,785,40740,4626,2,67,2,3748.76,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2860,7562,785,40740,4626,2,13,1,21600.00,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2861,7562,786,40740,4626,2,96,2,6198.35,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2862,7562,786,40740,4626,2,67,2,1301.65,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2863,7562,786,40740,4626,2,13,1,7500.00,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2864,7562,787,40740,4626,2,96,2,23140.50,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2865,7562,787,40740,4626,2,67,2,4859.50,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2866,7562,787,40740,4626,2,13,1,28000.00,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2867,7562,788,40740,4626,2,96,2,9917.36,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2868,7562,788,40740,4626,2,67,2,2082.64,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2869,7562,788,40740,4626,2,13,1,12000.00,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2870,7562,789,40740,4626,2,96,2,1404.96,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2871,7562,789,40740,4626,2,67,2,295.04,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2872,7562,789,40740,4626,2,13,1,1700.00,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2873,7562,790,40740,4626,2,96,2,2975.21,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2874,7562,790,40740,4626,2,67,2,624.79,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2875,7562,790,40740,4626,2,13,1,3600.00,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2876,7562,791,40740,4626,2,96,2,6528.93,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2877,7562,791,40740,4626,2,67,2,1371.07,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2878,7562,791,40740,4626,2,13,1,7900.00,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL);
INSERT INTO `balance_libro_details` VALUES (2879,7562,792,40740,4626,2,96,2,27074.38,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2880,7562,792,40740,4626,2,67,2,5685.62,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2881,7562,792,40740,4626,2,13,1,32760.00,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2882,7562,793,40740,4626,2,96,2,24793.39,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2883,7562,793,40740,4626,2,67,2,5206.61,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2884,7562,793,40740,4626,2,13,1,30000.00,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2885,7562,794,40740,4626,2,96,2,8264.46,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2886,7562,794,40740,4626,2,67,2,1735.54,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2887,7562,794,40740,4626,2,13,1,10000.00,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2888,7562,795,40740,4626,2,96,2,20661.16,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2889,7562,795,40740,4626,2,67,2,4338.84,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2890,7562,795,40740,4626,2,13,1,25000.00,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(2891,7562,796,40740,4626,2,96,2,5950.41,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2892,7562,796,40740,4626,2,67,2,1249.59,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2893,7562,796,40740,4626,2,13,1,7200.00,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2894,7562,797,40740,4626,2,96,2,11206.61,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2895,7562,797,40740,4626,2,67,2,2353.39,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2896,7562,797,40740,4626,2,13,1,13560.00,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2897,7562,798,40740,4626,2,96,2,7933.88,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2898,7562,798,40740,4626,2,67,2,1666.12,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2899,7562,798,40740,4626,2,13,1,9600.00,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2900,7562,799,40740,4626,2,96,2,1900.83,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2901,7562,799,40740,4626,2,67,2,399.17,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2902,7562,799,40740,4626,2,13,1,2300.00,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2903,7562,800,40740,4626,2,96,2,1900.83,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2904,7562,800,40740,4626,2,67,2,399.17,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2905,7562,800,40740,4626,2,13,1,2300.00,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2906,7562,801,40740,4626,2,96,2,9090.91,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2907,7562,801,40740,4626,2,67,2,1909.09,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2908,7562,801,40740,4626,2,13,1,11000.00,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2909,7562,802,40740,4626,2,96,2,4049.59,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2910,7562,802,40740,4626,2,67,2,850.41,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2911,7562,802,40740,4626,2,13,1,4900.00,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2912,7562,803,40740,4626,2,96,2,8264.46,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2913,7562,803,40740,4626,2,67,2,1735.54,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2914,7562,803,40740,4626,2,13,1,10000.00,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2915,7562,804,40740,4626,2,96,2,4049.59,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2916,7562,804,40740,4626,2,67,2,850.41,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2917,7562,804,40740,4626,2,13,1,4900.00,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2918,7562,805,40740,4626,2,96,2,4545.45,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2919,7562,805,40740,4626,2,67,2,954.55,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL);
INSERT INTO `balance_libro_details` VALUES (2920,7562,805,40740,4626,2,13,1,5500.00,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2921,7562,806,40740,4626,2,96,2,5851.24,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2922,7562,806,40740,4626,2,67,2,1228.76,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2923,7562,806,40740,4626,2,13,1,7080.00,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2924,7562,807,40740,4626,2,96,2,5619.83,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2925,7562,807,40740,4626,2,67,2,1180.17,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2926,7562,807,40740,4626,2,13,1,6800.00,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2927,7562,808,40740,4626,2,96,2,5702.48,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2928,7562,808,40740,4626,2,67,2,1197.52,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2929,7562,808,40740,4626,2,13,1,6900.00,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(2930,7562,809,40740,4626,2,96,2,24793.39,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2931,7562,809,40740,4626,2,67,2,5206.61,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2932,7562,809,40740,4626,2,13,1,30000.00,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2933,7562,810,40740,4626,2,96,2,2975.21,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2934,7562,810,40740,4626,2,67,2,624.79,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2935,7562,810,40740,4626,2,13,1,3600.00,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2936,7562,811,40740,4626,2,96,2,9917.36,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2937,7562,811,40740,4626,2,67,2,2082.64,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2938,7562,811,40740,4626,2,13,1,12000.00,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2939,7562,812,40740,4626,2,96,2,3305.79,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2940,7562,812,40740,4626,2,67,2,694.21,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2941,7562,812,40740,4626,2,13,1,4000.00,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2942,7562,813,40740,4626,2,96,2,31636.36,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2943,7562,813,40740,4626,2,67,2,6643.64,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2944,7562,813,40740,4626,2,13,1,38280.00,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2945,7562,814,40740,4626,2,96,2,9322.31,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2946,7562,814,40740,4626,2,67,2,1957.69,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2947,7562,814,40740,4626,2,13,1,11280.00,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2948,7562,815,40740,4626,2,96,2,9917.36,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2949,7562,815,40740,4626,2,67,2,2082.64,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2950,7562,815,40740,4626,2,13,1,12000.00,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2951,7562,816,40740,4626,2,96,2,5371.90,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2952,7562,816,40740,4626,2,67,2,1128.10,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2953,7562,816,40740,4626,2,13,1,6500.00,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2954,7562,817,40740,4626,2,96,2,10082.64,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2955,7562,817,40740,4626,2,67,2,2117.36,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2956,7562,817,40740,4626,2,13,1,12200.00,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2957,7562,818,40740,4626,2,96,2,8264.46,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2958,7562,818,40740,4626,2,67,2,1735.54,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2959,7562,818,40740,4626,2,13,1,10000.00,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2960,7562,819,40740,4626,2,96,2,15537.19,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL);
INSERT INTO `balance_libro_details` VALUES (2961,7562,819,40740,4626,2,67,2,3262.81,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2962,7562,819,40740,4626,2,13,1,18800.00,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2963,7562,820,40740,4626,2,96,2,8677.69,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2964,7562,820,40740,4626,2,67,2,1822.31,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2965,7562,820,40740,4626,2,13,1,10500.00,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2966,7562,821,40740,4626,2,96,2,8264.46,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2967,7562,821,40740,4626,2,67,2,1735.54,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2968,7562,821,40740,4626,2,13,1,10000.00,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(2969,7562,822,40740,4626,2,96,2,5702.48,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2970,7562,822,40740,4626,2,67,2,1197.52,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2971,7562,822,40740,4626,2,13,1,6900.00,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2972,7562,823,40740,4626,2,96,2,3471.07,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2973,7562,823,40740,4626,2,67,2,728.93,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2974,7562,823,40740,4626,2,13,1,4200.00,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2975,7562,824,40740,4626,2,96,2,5289.26,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2976,7562,824,40740,4626,2,67,2,1110.74,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2977,7562,824,40740,4626,2,13,1,6400.00,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2978,7562,825,40740,4626,2,96,2,8264.46,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2979,7562,825,40740,4626,2,67,2,1735.54,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2980,7562,825,40740,4626,2,13,1,10000.00,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2981,7562,826,40740,4626,2,96,2,7438.02,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2982,7562,826,40740,4626,2,67,2,1561.98,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2983,7562,826,40740,4626,2,13,1,9000.00,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2984,7562,827,40740,4626,2,96,2,3867.77,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2985,7562,827,40740,4626,2,67,2,812.23,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2986,7562,827,40740,4626,2,13,1,4680.00,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2987,7562,828,40740,4626,2,96,2,5371.90,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2988,7562,828,40740,4626,2,67,2,1128.10,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2989,7562,828,40740,4626,2,13,1,6500.00,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2990,7562,829,40740,4626,2,96,2,8347.11,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2991,7562,829,40740,4626,2,67,2,1752.89,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2992,7562,829,40740,4626,2,13,1,10100.00,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2993,7562,830,40740,4626,2,96,2,8264.46,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2994,7562,830,40740,4626,2,67,2,1735.54,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2995,7562,830,40740,4626,2,13,1,10000.00,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2996,7562,831,40740,4626,2,96,2,16528.93,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2997,7562,831,40740,4626,2,67,2,3471.07,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2998,7562,831,40740,4626,2,13,1,20000.00,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(2999,7562,832,40740,4626,2,96,2,12396.69,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(3000,7562,832,40740,4626,2,67,2,2603.31,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(3001,7562,832,40740,4626,2,13,1,15000.00,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL);
INSERT INTO `balance_libro_details` VALUES (3002,7562,833,40740,4626,2,96,2,11157.02,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3003,7562,833,40740,4626,2,67,2,2342.98,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3004,7562,833,40740,4626,2,13,1,13500.00,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3005,7562,834,40740,4626,2,96,2,11157.02,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3006,7562,834,40740,4626,2,67,2,2342.98,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3007,7562,834,40740,4626,2,13,1,13500.00,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3008,7562,835,40740,4626,2,96,2,5702.48,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3009,7562,835,40740,4626,2,67,2,1197.52,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3010,7562,835,40740,4626,2,13,1,6900.00,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3011,7562,836,40740,4626,2,96,2,9917.36,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3012,7562,836,40740,4626,2,67,2,2082.64,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3013,7562,836,40740,4626,2,13,1,12000.00,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3014,7562,837,40740,4626,2,96,2,6528.93,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3015,7562,837,40740,4626,2,67,2,1371.07,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3016,7562,837,40740,4626,2,13,1,7900.00,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3017,7562,838,40740,4626,2,96,2,5702.48,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3018,7562,838,40740,4626,2,67,2,1197.52,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3019,7562,838,40740,4626,2,13,1,6900.00,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3020,7562,839,40740,4626,2,96,2,6528.93,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3021,7562,839,40740,4626,2,67,2,1371.07,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3022,7562,839,40740,4626,2,13,1,7900.00,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3023,7562,840,40740,4626,2,96,2,4049.59,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3024,7562,840,40740,4626,2,67,2,850.41,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3025,7562,840,40740,4626,2,13,1,4900.00,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3026,7562,841,40740,4626,2,96,2,6528.93,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3027,7562,841,40740,4626,2,67,2,1371.07,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3028,7562,841,40740,4626,2,13,1,7900.00,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3029,7562,842,40740,4626,2,96,2,8181.82,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3030,7562,842,40740,4626,2,67,2,1718.18,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3031,7562,842,40740,4626,2,13,1,9900.00,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(3032,7562,843,40740,4626,3,217,1,5140.00,NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(3033,7562,843,40740,4626,3,68,1,1079.40,NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(3034,7562,843,40740,4626,3,57,2,6219.40,NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(3035,7562,844,40740,4626,3,217,1,32115.58,NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(3036,7562,844,40740,4626,3,68,1,6744.27,NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(3037,7562,844,40740,4626,3,57,2,38859.85,NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(3038,7562,845,40740,4626,3,217,1,7644.65,NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(3039,7562,845,40740,4626,3,68,1,1605.38,NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(3040,7562,845,40740,4626,3,57,2,9250.03,NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(3041,7562,846,40740,4626,3,217,1,131100.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3042,7562,846,40740,4626,3,68,1,27531.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL);
INSERT INTO `balance_libro_details` VALUES (3043,7562,846,40740,4626,3,57,2,158631.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3044,7562,847,40740,4626,3,217,1,37083.14,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3045,7562,847,40740,4626,3,68,1,7787.46,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3046,7562,847,40740,4626,3,57,2,44870.60,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3047,7562,848,40740,4626,3,217,1,2384.51,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3048,7562,848,40740,4626,3,68,1,273.05,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3049,7562,848,40740,4626,3,57,2,2657.56,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3050,7562,849,40740,4626,3,217,1,238.82,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3051,7562,849,40740,4626,3,68,1,50.15,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3052,7562,849,40740,4626,3,57,2,288.97,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3053,7562,850,40740,4626,3,217,1,117000.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3054,7562,850,40740,4626,3,68,1,24570.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3055,7562,850,40740,4626,3,57,2,141570.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3056,7562,851,40740,4626,3,217,1,6033.06,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3057,7562,851,40740,4626,3,68,1,1266.94,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3058,7562,851,40740,4626,3,57,2,7300.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3059,7562,852,40740,4626,3,217,1,3200.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3060,7562,852,40740,4626,3,68,1,672.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3061,7562,852,40740,4626,3,57,2,3872.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3062,7562,853,40740,4626,3,217,1,3874.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3063,7562,853,40740,4626,3,68,1,813.54,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3064,7562,853,40740,4626,3,57,2,4687.54,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3065,7562,854,40740,4626,3,217,1,5140.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3066,7562,854,40740,4626,3,68,1,1079.40,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3067,7562,854,40740,4626,3,57,2,6219.40,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3068,7562,855,40740,4626,3,217,1,2340.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3069,7562,855,40740,4626,3,68,1,491.40,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3070,7562,855,40740,4626,3,57,2,2831.40,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3071,7562,856,40740,4626,3,250,1,0.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3072,7562,856,40740,4626,3,57,2,0.00,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(3073,7562,857,40740,4626,3,217,2,121.70,NULL,'2023-07-14 10:26:04','2023-07-14 10:31:48','2023-07-14 10:31:48'),(3074,7562,857,40740,4626,3,67,2,32.86,NULL,'2023-07-14 10:26:04','2023-07-14 10:31:48','2023-07-14 10:31:48'),(3075,7562,857,40740,4626,3,217,2,7.30,NULL,'2023-07-14 10:26:04','2023-07-14 10:31:48','2023-07-14 10:31:48'),(3076,7562,857,40740,4626,3,57,1,161.86,NULL,'2023-07-14 10:26:04','2023-07-14 10:31:48','2023-07-14 10:31:48'),(3077,7562,858,40740,4626,3,217,2,1.40,NULL,'2023-07-14 10:26:05','2023-07-14 10:31:41','2023-07-14 10:31:41'),(3078,7562,858,40740,4626,3,67,2,0.38,NULL,'2023-07-14 10:26:05','2023-07-14 10:31:41','2023-07-14 10:31:41'),(3079,7562,858,40740,4626,3,217,2,0.08,NULL,'2023-07-14 10:26:05','2023-07-14 10:31:41','2023-07-14 10:31:41'),(3080,7562,858,40740,4626,3,57,1,1.86,NULL,'2023-07-14 10:26:05','2023-07-14 10:31:41','2023-07-14 10:31:41'),(3081,7562,859,40740,4626,3,217,2,79.20,NULL,'2023-07-14 10:26:05','2023-07-14 10:31:35','2023-07-14 10:31:35'),(3082,7562,859,40740,4626,3,67,2,21.38,NULL,'2023-07-14 10:26:05','2023-07-14 10:31:35','2023-07-14 10:31:35');
INSERT INTO `balance_libro_details` VALUES (3083,7562,859,40740,4626,3,217,2,4.76,NULL,'2023-07-14 10:26:05','2023-07-14 10:31:35','2023-07-14 10:31:35'),(3084,7562,859,40740,4626,3,57,1,105.34,NULL,'2023-07-14 10:26:05','2023-07-14 10:31:35','2023-07-14 10:31:35'),(3085,7562,860,40740,4626,3,217,1,37272.72,NULL,'2023-07-14 10:26:05','2023-07-14 10:28:22','2023-07-14 10:28:22'),(3086,7562,860,40740,4626,3,68,1,7827.27,NULL,'2023-07-14 10:26:05','2023-07-14 10:28:22','2023-07-14 10:28:22'),(3087,7562,860,40740,4626,3,57,2,45099.99,NULL,'2023-07-14 10:26:05','2023-07-14 10:28:22','2023-07-14 10:28:22'),(3088,7562,861,40740,4626,3,217,1,14669.42,NULL,'2023-07-14 10:26:05','2023-07-14 10:28:14','2023-07-14 10:28:14'),(3089,7562,861,40740,4626,3,68,1,3080.58,NULL,'2023-07-14 10:26:05','2023-07-14 10:28:14','2023-07-14 10:28:14'),(3090,7562,861,40740,4626,3,57,2,17750.00,NULL,'2023-07-14 10:26:05','2023-07-14 10:28:14','2023-07-14 10:28:14'),(3091,7562,862,40740,4626,3,217,1,4743.81,NULL,'2023-07-14 10:26:05','2023-07-14 10:28:04','2023-07-14 10:28:04'),(3092,7562,862,40740,4626,3,68,1,996.20,NULL,'2023-07-14 10:26:05','2023-07-14 10:28:04','2023-07-14 10:28:04'),(3093,7562,862,40740,4626,3,57,2,5740.01,NULL,'2023-07-14 10:26:05','2023-07-14 10:28:04','2023-07-14 10:28:04'),(3094,7562,863,40740,4626,3,217,1,6033.06,NULL,'2023-07-14 10:26:05','2023-07-14 10:27:57','2023-07-14 10:27:57'),(3095,7562,863,40740,4626,3,68,1,1266.94,NULL,'2023-07-14 10:26:05','2023-07-14 10:27:57','2023-07-14 10:27:57'),(3096,7562,863,40740,4626,3,57,2,7300.00,NULL,'2023-07-14 10:26:05','2023-07-14 10:27:57','2023-07-14 10:27:57'),(3097,7562,864,40721,3054,3,250,1,35950.43,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3098,7562,864,40721,3054,3,68,1,7549.59,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3099,7562,864,40721,3054,3,250,1,0.02,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3100,7562,864,40721,3054,3,57,2,43500.04,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3101,7562,865,40721,3054,3,221,1,1461.48,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3102,7562,865,40721,3054,3,250,1,7660.52,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3103,7562,865,40721,3054,3,68,1,1608.71,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3104,7562,865,40721,3054,3,250,1,730.72,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3105,7562,865,40721,3054,3,57,2,11461.43,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3106,7562,866,40721,3054,3,221,1,331.52,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3107,7562,866,40721,3054,3,250,1,2342.43,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3108,7562,866,40721,3054,3,68,1,491.91,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3109,7562,866,40721,3054,3,250,1,165.76,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3110,7562,866,40721,3054,3,57,2,3331.62,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3111,7562,867,40721,3054,3,221,1,313.14,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3112,7562,867,40721,3054,3,250,1,2349.95,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3113,7562,867,40721,3054,3,68,1,493.49,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3114,7562,867,40721,3054,3,250,1,156.59,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3115,7562,867,40721,3054,3,57,2,3313.17,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3116,7562,868,40721,3054,3,250,1,8677.69,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3117,7562,868,40721,3054,3,68,1,1822.32,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3118,7562,868,40721,3054,3,57,2,10500.01,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3119,7562,869,40721,3054,3,237,1,49.60,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3120,7562,869,40721,3054,3,250,1,1983.80,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3121,7562,869,40721,3054,3,68,1,416.60,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL);
INSERT INTO `balance_libro_details` VALUES (3122,7562,869,40721,3054,3,57,2,2450.00,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3123,7562,870,40721,3054,3,221,1,1436.60,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3124,7562,870,40721,3054,3,250,1,9655.00,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3125,7562,870,40721,3054,3,68,1,2027.55,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3126,7562,870,40721,3054,3,250,1,718.32,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3127,7562,870,40721,3054,3,57,2,13837.47,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3128,7562,871,40721,3054,3,221,1,331.52,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3129,7562,871,40721,3054,3,250,1,2342.43,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3130,7562,871,40721,3054,3,68,1,491.91,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3131,7562,871,40721,3054,3,250,1,165.76,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3132,7562,871,40721,3054,3,57,2,3331.62,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3133,7562,872,40721,3054,3,250,1,6492.42,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3134,7562,872,40721,3054,3,68,1,1363.41,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3135,7562,872,40721,3054,3,57,2,7855.83,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3136,7562,873,40721,3054,3,250,1,6445.00,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3137,7562,873,40721,3054,3,68,1,1353.45,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3138,7562,873,40721,3054,3,57,2,7798.45,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3139,7562,874,40721,3054,3,237,1,72.31,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3140,7562,874,40721,3054,3,250,1,2892.57,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3141,7562,874,40721,3054,3,68,1,607.44,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3142,7562,874,40721,3054,3,250,1,0.01,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3143,7562,874,40721,3054,3,57,2,3572.33,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3144,7562,875,40721,3054,3,221,1,726.80,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3145,7562,875,40721,3054,3,250,1,3831.81,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3146,7562,875,40721,3054,3,68,1,804.68,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3147,7562,875,40721,3054,3,250,1,363.39,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3148,7562,875,40721,3054,3,57,2,5726.68,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3149,7562,876,40721,3054,3,221,1,1512.70,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3150,7562,876,40721,3054,3,250,1,11028.14,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3151,7562,876,40721,3054,3,68,1,2315.91,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3152,7562,876,40721,3054,3,250,1,756.33,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3153,7562,876,40721,3054,3,57,2,15613.08,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(3154,7562,877,40721,3054,3,221,1,1043.96,NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(3155,7562,877,40721,3054,3,250,1,4527.33,NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(3156,7562,877,40721,3054,3,68,1,950.74,NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(3157,7562,877,40721,3054,3,250,1,522.00,NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(3158,7562,877,40721,3054,3,57,2,7044.03,NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(3159,7562,878,40721,3054,3,221,1,429.24,NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(3160,7562,878,40721,3054,3,250,1,3129.33,NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(3161,7562,878,40721,3054,3,68,1,657.16,NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(3162,7562,878,40721,3054,3,250,1,214.61,NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL);
INSERT INTO `balance_libro_details` VALUES (3163,7562,878,40721,3054,3,57,2,4430.34,NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(3164,7562,879,40720,1543,2,218,2,5116.00,NULL,'2023-08-12 09:55:25','2023-08-12 09:55:25',NULL),(3165,7562,879,40720,1543,2,13,1,5116.00,NULL,'2023-08-12 09:55:25','2023-08-12 09:55:25',NULL),(3166,7562,880,40720,1543,2,218,2,1547483.47,NULL,'2023-08-12 09:55:25','2023-08-12 09:55:25',NULL),(3167,7562,880,40720,1543,2,96,2,151896.76,NULL,'2023-08-12 09:55:25','2023-08-12 09:55:25',NULL),(3168,7562,880,40720,1543,2,67,2,15949.16,NULL,'2023-08-12 09:55:25','2023-08-12 09:55:25',NULL),(3169,7562,880,40720,1543,2,13,1,1715329.39,NULL,'2023-08-12 09:55:25','2023-08-12 09:55:25',NULL),(3170,7562,881,40720,1543,3,217,1,157865.52,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3171,7562,881,40720,1543,3,57,2,157865.52,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3172,7562,882,40720,1543,3,250,1,13425.40,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3173,7562,882,40720,1543,3,68,1,2819.33,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3174,7562,882,40720,1543,3,57,2,16244.73,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3175,7562,883,40720,1543,3,250,1,69467.68,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3176,7562,883,40720,1543,3,57,2,69467.68,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3177,7562,884,40720,1543,3,250,1,61489.48,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3178,7562,884,40720,1543,3,68,1,12912.79,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3179,7562,884,40720,1543,3,57,2,74402.27,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3180,7562,885,40720,1543,3,250,1,16073.92,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3181,7562,885,40720,1543,3,68,1,3375.52,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3182,7562,885,40720,1543,3,57,2,19449.44,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3183,7562,886,40720,1543,3,237,1,522.13,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3184,7562,886,40720,1543,3,220,1,304.24,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3185,7562,886,40720,1543,3,250,1,8317.00,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3186,7562,886,40720,1543,3,68,1,1746.57,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3187,7562,886,40720,1543,3,250,1,1824.34,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3188,7562,886,40720,1543,3,68,1,492.57,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3189,7562,886,40720,1543,3,57,2,13206.85,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3190,7562,887,40720,1543,3,250,1,7144.13,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3191,7562,887,40720,1543,3,68,1,1500.27,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3192,7562,887,40720,1543,3,57,2,8644.40,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3193,7562,888,40720,1543,3,250,1,17765.01,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3194,7562,888,40720,1543,3,68,1,3730.65,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3195,7562,888,40720,1543,3,57,2,21495.66,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(3196,7562,889,40720,1543,3,250,1,1617.80,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3197,7562,889,40720,1543,3,68,1,339.74,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3198,7562,889,40720,1543,3,57,2,1957.54,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3199,7562,890,40720,1543,3,250,1,4599.85,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3200,7562,890,40720,1543,3,68,1,965.97,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3201,7562,890,40720,1543,3,57,2,5565.82,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3202,7562,891,40720,1543,3,250,1,21180.74,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3203,7562,891,40720,1543,3,68,1,4447.96,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL);
INSERT INTO `balance_libro_details` VALUES (3204,7562,891,40720,1543,3,57,2,25628.70,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3205,7562,892,40720,1543,3,250,1,5753.25,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3206,7562,892,40720,1543,3,68,1,1208.18,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3207,7562,892,40720,1543,3,57,2,6961.43,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3208,7562,893,40720,1543,3,217,1,30000.00,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3209,7562,893,40720,1543,3,57,2,30000.00,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3210,7562,894,40720,1543,3,250,1,6940.69,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3211,7562,894,40720,1543,3,68,1,1457.55,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3212,7562,894,40720,1543,3,57,2,8398.24,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(3213,7562,895,40721,3055,3,221,1,1043.96,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3214,7562,895,40721,3055,3,250,1,4527.33,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3215,7562,895,40721,3055,3,68,1,950.74,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3216,7562,895,40721,3055,3,250,1,522.00,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3217,7562,895,40721,3055,3,57,2,7044.03,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3218,7562,896,40721,3055,3,237,1,28.93,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3219,7562,896,40721,3055,3,217,1,1157.00,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3220,7562,896,40721,3055,3,68,1,242.97,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3221,7562,896,40721,3055,3,217,1,0.02,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3222,7562,896,40721,3055,3,57,2,1428.92,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3223,7562,897,40721,3055,3,221,1,417.50,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3224,7562,897,40721,3055,3,250,1,3133.19,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3225,7562,897,40721,3055,3,68,1,657.97,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3226,7562,897,40721,3055,3,250,1,208.77,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3227,7562,897,40721,3055,3,57,2,4417.43,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3228,7562,898,40721,3055,3,250,1,8827.00,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3229,7562,898,40721,3055,3,68,1,1853.67,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3230,7562,898,40721,3055,3,57,2,10680.67,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3231,7562,899,40721,3055,3,250,1,6487.62,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3232,7562,899,40721,3055,3,68,1,1362.40,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3233,7562,899,40721,3055,3,250,1,0.02,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3234,7562,899,40721,3055,3,57,2,7850.04,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3235,7562,900,40721,3055,3,221,1,1015.64,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3236,7562,900,40721,3055,3,250,1,4621.67,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3237,7562,900,40721,3055,3,68,1,970.55,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3238,7562,900,40721,3055,3,250,1,507.81,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3239,7562,900,40721,3055,3,57,2,7115.67,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3240,7562,901,40721,3055,3,221,1,499.42,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3241,7562,901,40721,3055,3,250,1,3925.76,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3242,7562,901,40721,3055,3,68,1,824.41,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3243,7562,901,40721,3055,3,250,1,249.69,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(3244,7562,901,40721,3055,3,57,2,5499.28,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL);
INSERT INTO `balance_libro_details` VALUES (3245,7562,902,40721,3055,3,237,1,99.56,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3246,7562,902,40721,3055,3,250,1,3982.30,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3247,7562,902,40721,3055,3,68,1,418.14,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3248,7562,902,40721,3055,3,57,2,4500.00,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3249,7562,903,40721,3055,3,221,1,1312.00,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3250,7562,903,40721,3055,3,250,1,7722.33,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3251,7562,903,40721,3055,3,68,1,1621.69,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3252,7562,903,40721,3055,3,250,1,656.01,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3253,7562,903,40721,3055,3,57,2,11312.03,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3254,7562,904,40721,3055,3,250,1,2479.34,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3255,7562,904,40721,3055,3,68,1,520.66,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3256,7562,904,40721,3055,3,57,2,3000.00,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3257,7562,905,40721,3055,3,221,1,732.54,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3258,7562,905,40721,3055,3,250,1,3333.43,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3259,7562,905,40721,3055,3,68,1,700.02,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3260,7562,905,40721,3055,3,250,1,366.25,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3261,7562,905,40721,3055,3,57,2,5132.24,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3262,7562,906,40721,3055,3,250,1,1652.89,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3263,7562,906,40721,3055,3,68,1,347.11,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3264,7562,906,40721,3055,3,57,2,2000.00,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3265,7562,907,40721,3055,3,237,1,2929.15,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3266,7562,907,40721,3055,3,250,1,117165.98,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3267,7562,907,40721,3055,3,68,1,24604.86,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3268,7562,907,40721,3055,3,57,2,144699.99,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3269,7562,908,40721,3055,3,217,1,74380.14,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3270,7562,908,40721,3055,3,68,1,15619.83,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3271,7562,908,40721,3055,3,217,1,0.02,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3272,7562,908,40721,3055,3,57,2,89999.99,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(3273,7562,909,40740,4627,2,96,2,8264.46,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3274,7562,909,40740,4627,2,67,2,1735.54,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3275,7562,909,40740,4627,2,13,1,10000.00,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3276,7562,910,40740,4627,2,96,2,5702.48,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3277,7562,910,40740,4627,2,67,2,1197.52,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3278,7562,910,40740,4627,2,13,1,6900.00,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3279,7562,911,40740,4627,2,96,2,25785.12,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3280,7562,911,40740,4627,2,67,2,5414.88,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3281,7562,911,40740,4627,2,13,1,31200.00,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3282,7562,912,40740,4627,2,96,2,9090.91,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3283,7562,912,40740,4627,2,67,2,1909.09,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3284,7562,912,40740,4627,2,13,1,11000.00,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3285,7562,913,40740,4627,2,96,2,11570.25,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL);
INSERT INTO `balance_libro_details` VALUES (3286,7562,913,40740,4627,2,67,2,2429.75,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3287,7562,913,40740,4627,2,13,1,14000.00,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3288,7562,914,40740,4627,2,96,2,11570.25,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3289,7562,914,40740,4627,2,67,2,2429.75,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3290,7562,914,40740,4627,2,13,1,14000.00,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3291,7562,915,40740,4627,2,96,2,10743.80,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3292,7562,915,40740,4627,2,67,2,2256.20,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3293,7562,915,40740,4627,2,13,1,13000.00,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3294,7562,916,40740,4627,2,96,2,12297.52,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3295,7562,916,40740,4627,2,67,2,2582.48,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3296,7562,916,40740,4627,2,13,1,14880.00,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3297,7562,917,40740,4627,2,96,2,8264.46,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3298,7562,917,40740,4627,2,67,2,1735.54,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3299,7562,917,40740,4627,2,13,1,10000.00,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(3300,7562,918,40740,4627,2,96,2,3471.07,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3301,7562,918,40740,4627,2,67,2,728.93,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3302,7562,918,40740,4627,2,13,1,4200.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3303,7562,919,40740,4627,2,96,2,5702.48,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3304,7562,919,40740,4627,2,67,2,1197.52,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3305,7562,919,40740,4627,2,13,1,6900.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3306,7562,920,40740,4627,2,96,2,6611.57,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3307,7562,920,40740,4627,2,67,2,1388.43,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3308,7562,920,40740,4627,2,13,1,8000.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3309,7562,921,40740,4627,2,96,2,5702.48,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3310,7562,921,40740,4627,2,67,2,1197.52,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3311,7562,921,40740,4627,2,13,1,6900.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3312,7562,922,40740,4627,2,96,2,4297.52,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3313,7562,922,40740,4627,2,67,2,902.48,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3314,7562,922,40740,4627,2,13,1,5200.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3315,7562,923,40740,4627,2,96,2,6611.57,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3316,7562,923,40740,4627,2,67,2,1388.43,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3317,7562,923,40740,4627,2,13,1,8000.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3318,7562,924,40740,4627,2,96,2,5702.48,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3319,7562,924,40740,4627,2,67,2,1197.52,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3320,7562,924,40740,4627,2,13,1,6900.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3321,7562,925,40740,4627,2,96,2,5702.48,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3322,7562,925,40740,4627,2,67,2,1197.52,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3323,7562,925,40740,4627,2,13,1,6900.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3324,7562,926,40740,4627,2,96,2,6528.93,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3325,7562,926,40740,4627,2,67,2,1371.07,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3326,7562,926,40740,4627,2,13,1,7900.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL);
INSERT INTO `balance_libro_details` VALUES (3327,7562,927,40740,4627,2,96,2,7355.37,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3328,7562,927,40740,4627,2,67,2,1544.63,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3329,7562,927,40740,4627,2,13,1,8900.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3330,7562,928,40740,4627,2,96,2,23884.30,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3331,7562,928,40740,4627,2,67,2,5015.70,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3332,7562,928,40740,4627,2,13,1,28900.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3333,7562,929,40740,4627,2,96,2,7438.02,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3334,7562,929,40740,4627,2,67,2,1561.98,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3335,7562,929,40740,4627,2,13,1,9000.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3336,7562,930,40740,4627,2,96,2,22314.05,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3337,7562,930,40740,4627,2,67,2,4685.95,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3338,7562,930,40740,4627,2,13,1,27000.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3339,7562,931,40740,4627,2,96,2,7355.37,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3340,7562,931,40740,4627,2,67,2,1544.63,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3341,7562,931,40740,4627,2,13,1,8900.00,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(3342,7562,932,40740,4627,2,96,2,16528.93,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3343,7562,932,40740,4627,2,67,2,3471.07,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3344,7562,932,40740,4627,2,13,1,20000.00,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3345,7562,933,40740,4627,2,96,2,2644.63,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3346,7562,933,40740,4627,2,67,2,555.37,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3347,7562,933,40740,4627,2,13,1,3200.00,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3348,7562,934,40740,4627,2,96,2,4958.68,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3349,7562,934,40740,4627,2,67,2,1041.32,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3350,7562,934,40740,4627,2,13,1,6000.00,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3351,7562,935,40740,4627,2,96,2,4958.68,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3352,7562,935,40740,4627,2,67,2,1041.32,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3353,7562,935,40740,4627,2,13,1,6000.00,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3354,7562,936,40740,4627,2,96,2,3223.14,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3355,7562,936,40740,4627,2,67,2,676.86,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3356,7562,936,40740,4627,2,13,1,3900.00,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3357,7562,937,40740,4627,2,96,2,12727.27,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3358,7562,937,40740,4627,2,67,2,2672.73,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3359,7562,937,40740,4627,2,13,1,15400.00,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3360,7562,938,40740,4627,2,96,2,4297.52,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3361,7562,938,40740,4627,2,67,2,902.48,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3362,7562,938,40740,4627,2,13,1,5200.00,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3363,7562,939,40740,4627,2,96,2,3966.94,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3364,7562,939,40740,4627,2,67,2,833.06,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3365,7562,939,40740,4627,2,13,1,4800.00,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3366,7562,940,40740,4627,2,96,2,3966.94,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3367,7562,940,40740,4627,2,67,2,833.06,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL);
INSERT INTO `balance_libro_details` VALUES (3368,7562,940,40740,4627,2,13,1,4800.00,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3369,7562,941,40740,4627,2,96,2,8512.40,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3370,7562,941,40740,4627,2,67,2,1787.60,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3371,7562,941,40740,4627,2,13,1,10300.00,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3372,7562,942,40740,4627,2,96,2,11570.25,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3373,7562,942,40740,4627,2,67,2,2429.75,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3374,7562,942,40740,4627,2,13,1,14000.00,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3375,7562,943,40740,4627,2,96,2,4710.74,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3376,7562,943,40740,4627,2,67,2,989.26,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3377,7562,943,40740,4627,2,13,1,5700.00,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3378,7562,944,40740,4627,2,96,2,9917.36,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3379,7562,944,40740,4627,2,67,2,2082.64,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3380,7562,944,40740,4627,2,13,1,12000.00,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(3381,7562,945,40740,4627,2,96,2,4380.17,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3382,7562,945,40740,4627,2,67,2,919.83,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3383,7562,945,40740,4627,2,13,1,5300.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3384,7562,946,40740,4627,2,96,2,578.51,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3385,7562,946,40740,4627,2,67,2,121.49,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3386,7562,946,40740,4627,2,13,1,700.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3387,7562,947,40740,4627,2,96,2,24793.39,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3388,7562,947,40740,4627,2,67,2,5206.61,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3389,7562,947,40740,4627,2,13,1,30000.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3390,7562,948,40740,4627,2,96,2,3966.94,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3391,7562,948,40740,4627,2,67,2,833.06,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3392,7562,948,40740,4627,2,13,1,4800.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3393,7562,949,40740,4627,2,96,2,12892.56,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3394,7562,949,40740,4627,2,67,2,2707.44,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3395,7562,949,40740,4627,2,13,1,15600.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3396,7562,950,40740,4627,2,96,2,7355.37,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3397,7562,950,40740,4627,2,67,2,1544.63,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3398,7562,950,40740,4627,2,13,1,8900.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3399,7562,951,40740,4627,2,96,2,4049.59,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3400,7562,951,40740,4627,2,67,2,850.41,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3401,7562,951,40740,4627,2,13,1,4900.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3402,7562,952,40740,4627,2,96,2,4958.68,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3403,7562,952,40740,4627,2,67,2,1041.32,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3404,7562,952,40740,4627,2,13,1,6000.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3405,7562,953,40740,4627,2,96,2,2809.92,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3406,7562,953,40740,4627,2,67,2,590.08,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3407,7562,953,40740,4627,2,13,1,3400.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3408,7562,954,40740,4627,2,96,2,2479.34,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL);
INSERT INTO `balance_libro_details` VALUES (3409,7562,954,40740,4627,2,67,2,520.66,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3410,7562,954,40740,4627,2,13,1,3000.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3411,7562,955,40740,4627,2,96,2,5702.48,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3412,7562,955,40740,4627,2,67,2,1197.52,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3413,7562,955,40740,4627,2,13,1,6900.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3414,7562,956,40740,4627,2,96,2,5702.48,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3415,7562,956,40740,4627,2,67,2,1197.52,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3416,7562,956,40740,4627,2,13,1,6900.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3417,7562,957,40740,4627,2,96,2,17190.08,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3418,7562,957,40740,4627,2,67,2,3609.92,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3419,7562,957,40740,4627,2,13,1,20800.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3420,7562,958,40740,4627,2,96,2,10000.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3421,7562,958,40740,4627,2,67,2,2100.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3422,7562,958,40740,4627,2,13,1,12100.00,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(3423,7562,959,40740,4627,2,96,2,15206.61,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3424,7562,959,40740,4627,2,67,2,3193.39,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3425,7562,959,40740,4627,2,13,1,18400.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3426,7562,960,40740,4627,2,96,2,12396.69,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3427,7562,960,40740,4627,2,67,2,2603.31,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3428,7562,960,40740,4627,2,13,1,15000.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3429,7562,961,40740,4627,2,96,2,17851.24,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3430,7562,961,40740,4627,2,67,2,3748.76,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3431,7562,961,40740,4627,2,13,1,21600.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3432,7562,962,40740,4627,2,96,2,3553.72,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3433,7562,962,40740,4627,2,67,2,746.28,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3434,7562,962,40740,4627,2,13,1,4300.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3435,7562,963,40740,4627,2,96,2,5371.90,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3436,7562,963,40740,4627,2,67,2,1128.10,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3437,7562,963,40740,4627,2,13,1,6500.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3438,7562,964,40740,4627,2,96,2,14710.74,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3439,7562,964,40740,4627,2,67,2,3089.26,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3440,7562,964,40740,4627,2,13,1,17800.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3441,7562,965,40740,4627,2,96,2,8181.82,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3442,7562,965,40740,4627,2,67,2,1718.18,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3443,7562,965,40740,4627,2,13,1,9900.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3444,7562,966,40740,4627,2,96,2,2892.56,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3445,7562,966,40740,4627,2,67,2,607.44,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3446,7562,966,40740,4627,2,13,1,3500.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3447,7562,967,40740,4627,2,96,2,8264.46,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3448,7562,967,40740,4627,2,67,2,1735.54,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3449,7562,967,40740,4627,2,13,1,10000.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL);
INSERT INTO `balance_libro_details` VALUES (3450,7562,968,40740,4627,2,96,2,18595.04,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3451,7562,968,40740,4627,2,67,2,3904.96,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3452,7562,968,40740,4627,2,13,1,22500.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3453,7562,969,40740,4627,2,96,2,3223.14,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3454,7562,969,40740,4627,2,67,2,676.86,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3455,7562,969,40740,4627,2,13,1,3900.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3456,7562,970,40740,4627,2,96,2,4710.74,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3457,7562,970,40740,4627,2,67,2,989.26,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3458,7562,970,40740,4627,2,13,1,5700.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3459,7562,971,40740,4627,2,96,2,7355.37,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3460,7562,971,40740,4627,2,67,2,1544.63,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3461,7562,971,40740,4627,2,13,1,8900.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3462,7562,972,40740,4627,2,96,2,3966.94,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3463,7562,972,40740,4627,2,67,2,833.06,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3464,7562,972,40740,4627,2,13,1,4800.00,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(3465,7562,973,40740,4627,2,96,2,1239.67,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3466,7562,973,40740,4627,2,67,2,260.33,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3467,7562,973,40740,4627,2,13,1,1500.00,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3468,7562,974,40740,4627,2,96,2,9421.49,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3469,7562,974,40740,4627,2,67,2,1978.51,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3470,7562,974,40740,4627,2,13,1,11400.00,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3471,7562,975,40740,4627,2,96,2,9917.36,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3472,7562,975,40740,4627,2,67,2,2082.64,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3473,7562,975,40740,4627,2,13,1,12000.00,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3474,7562,976,40740,4627,2,96,2,17851.24,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3475,7562,976,40740,4627,2,67,2,3748.76,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3476,7562,976,40740,4627,2,13,1,21600.00,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3477,7562,977,40740,4627,2,96,2,4132.23,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3478,7562,977,40740,4627,2,67,2,867.77,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3479,7562,977,40740,4627,2,13,1,5000.00,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3480,7562,978,40740,4627,2,96,2,8264.46,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3481,7562,978,40740,4627,2,67,2,1735.54,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3482,7562,978,40740,4627,2,13,1,10000.00,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3483,7562,979,40740,4627,2,96,2,12396.69,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3484,7562,979,40740,4627,2,67,2,2603.31,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3485,7562,979,40740,4627,2,13,1,15000.00,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3486,7562,980,40740,4627,2,96,2,5702.48,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3487,7562,980,40740,4627,2,67,2,1197.52,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3488,7562,980,40740,4627,2,13,1,6900.00,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3489,7562,981,40740,4627,2,96,2,5702.48,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3490,7562,981,40740,4627,2,67,2,1197.52,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL);
INSERT INTO `balance_libro_details` VALUES (3491,7562,981,40740,4627,2,13,1,6900.00,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3492,7562,982,40740,4627,2,96,2,9917.36,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3493,7562,982,40740,4627,2,67,2,2082.64,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3494,7562,982,40740,4627,2,13,1,12000.00,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3495,7562,983,40740,4627,2,96,2,12727.27,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3496,7562,983,40740,4627,2,67,2,2672.73,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3497,7562,983,40740,4627,2,13,1,15400.00,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3498,7562,984,40740,4627,2,96,2,8264.46,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3499,7562,984,40740,4627,2,67,2,1735.54,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3500,7562,984,40740,4627,2,13,1,10000.00,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3501,7562,985,40740,4627,2,96,2,12396.69,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3502,7562,985,40740,4627,2,67,2,2603.31,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3503,7562,985,40740,4627,2,13,1,15000.00,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(3504,7562,986,40740,4627,2,96,2,12396.69,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3505,7562,986,40740,4627,2,67,2,2603.31,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3506,7562,986,40740,4627,2,13,1,15000.00,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3507,7562,987,40740,4627,2,96,2,41322.31,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3508,7562,987,40740,4627,2,67,2,8677.69,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3509,7562,987,40740,4627,2,13,1,50000.00,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3510,7562,988,40740,4627,2,96,2,4958.68,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3511,7562,988,40740,4627,2,67,2,1041.32,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3512,7562,988,40740,4627,2,13,1,6000.00,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3513,7562,989,40740,4627,2,96,2,1322.31,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3514,7562,989,40740,4627,2,67,2,277.69,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3515,7562,989,40740,4627,2,13,1,1600.00,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3516,7562,990,40740,4627,2,96,2,6446.28,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3517,7562,990,40740,4627,2,67,2,1353.72,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3518,7562,990,40740,4627,2,13,1,7800.00,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3519,7562,991,40740,4627,2,96,2,6611.57,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3520,7562,991,40740,4627,2,67,2,1388.43,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3521,7562,991,40740,4627,2,13,1,8000.00,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3522,7562,992,40740,4627,2,96,2,7438.02,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3523,7562,992,40740,4627,2,67,2,1561.98,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3524,7562,992,40740,4627,2,13,1,9000.00,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3525,7562,993,40740,4627,2,96,2,16528.93,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3526,7562,993,40740,4627,2,67,2,3471.07,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3527,7562,993,40740,4627,2,13,1,20000.00,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3528,7562,994,40740,4627,2,96,2,19008.26,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3529,7562,994,40740,4627,2,67,2,3991.74,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3530,7562,994,40740,4627,2,13,1,23000.00,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3531,7562,995,40740,4627,2,96,2,7933.88,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL);
INSERT INTO `balance_libro_details` VALUES (3532,7562,995,40740,4627,2,67,2,1666.12,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3533,7562,995,40740,4627,2,13,1,9600.00,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3534,7562,996,40740,4627,2,96,2,12396.69,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3535,7562,996,40740,4627,2,67,2,2603.31,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3536,7562,996,40740,4627,2,13,1,15000.00,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3537,7562,997,40740,4627,2,96,2,12830.58,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3538,7562,997,40740,4627,2,67,2,2694.42,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(3539,7562,997,40740,4627,2,13,1,15525.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3540,7562,998,40740,4627,2,96,2,10710.74,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3541,7562,998,40740,4627,2,67,2,2249.26,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3542,7562,998,40740,4627,2,13,1,12960.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3543,7562,999,40740,4627,2,96,2,12644.63,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3544,7562,999,40740,4627,2,67,2,2655.37,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3545,7562,999,40740,4627,2,13,1,15300.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3546,7562,1000,40740,4627,2,96,2,4876.03,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3547,7562,1000,40740,4627,2,67,2,1023.97,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3548,7562,1000,40740,4627,2,13,1,5900.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3549,7562,1001,40740,4627,2,96,2,8264.46,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3550,7562,1001,40740,4627,2,67,2,1735.54,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3551,7562,1001,40740,4627,2,13,1,10000.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3552,7562,1002,40740,4627,2,96,2,4876.03,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3553,7562,1002,40740,4627,2,67,2,1023.97,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3554,7562,1002,40740,4627,2,13,1,5900.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3555,7562,1003,40740,4627,2,96,2,6842.98,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3556,7562,1003,40740,4627,2,67,2,1437.02,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3557,7562,1003,40740,4627,2,13,1,8280.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3558,7562,1004,40740,4627,2,96,2,3570.25,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3559,7562,1004,40740,4627,2,67,2,749.75,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3560,7562,1004,40740,4627,2,13,1,4320.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3561,7562,1005,40740,4627,2,96,2,8264.46,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3562,7562,1005,40740,4627,2,67,2,1735.54,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3563,7562,1005,40740,4627,2,13,1,10000.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3564,7562,1006,40740,4627,2,96,2,4876.03,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3565,7562,1006,40740,4627,2,67,2,1023.97,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3566,7562,1006,40740,4627,2,13,1,5900.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3567,7562,1007,40740,4627,2,96,2,4214.88,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3568,7562,1007,40740,4627,2,67,2,885.12,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3569,7562,1007,40740,4627,2,13,1,5100.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3570,7562,1008,40740,4627,2,96,2,4297.52,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3571,7562,1008,40740,4627,2,67,2,902.48,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3572,7562,1008,40740,4627,2,13,1,5200.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL);
INSERT INTO `balance_libro_details` VALUES (3573,7562,1009,40740,4627,2,96,2,8264.46,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3574,7562,1009,40740,4627,2,67,2,1735.54,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3575,7562,1009,40740,4627,2,13,1,10000.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3576,7562,1010,40740,4627,2,96,2,3305.79,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3577,7562,1010,40740,4627,2,67,2,694.21,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3578,7562,1010,40740,4627,2,13,1,4000.00,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(3579,7562,1011,40740,4627,2,96,2,9818.18,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3580,7562,1011,40740,4627,2,67,2,2061.82,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3581,7562,1011,40740,4627,2,13,1,11880.00,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3582,7562,1012,40740,4627,2,96,2,4958.68,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3583,7562,1012,40740,4627,2,67,2,1041.32,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3584,7562,1012,40740,4627,2,13,1,6000.00,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3585,7562,1013,40740,4627,2,96,2,8264.46,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3586,7562,1013,40740,4627,2,67,2,1735.54,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3587,7562,1013,40740,4627,2,13,1,10000.00,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3588,7562,1014,40740,4627,2,96,2,12396.69,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3589,7562,1014,40740,4627,2,67,2,2603.31,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3590,7562,1014,40740,4627,2,13,1,15000.00,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3591,7562,1015,40740,4627,2,96,2,8264.46,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3592,7562,1015,40740,4627,2,67,2,1735.54,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3593,7562,1015,40740,4627,2,13,1,10000.00,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3594,7562,1016,40740,4627,2,96,2,4132.23,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3595,7562,1016,40740,4627,2,67,2,867.77,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3596,7562,1016,40740,4627,2,13,1,5000.00,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3597,7562,1017,40740,4627,2,96,2,9917.36,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3598,7562,1017,40740,4627,2,67,2,2082.64,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3599,7562,1017,40740,4627,2,13,1,12000.00,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3600,7562,1018,40740,4627,2,96,2,8264.46,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3601,7562,1018,40740,4627,2,67,2,1735.54,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3602,7562,1018,40740,4627,2,13,1,10000.00,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3603,7562,1019,40740,4627,2,96,2,12396.69,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3604,7562,1019,40740,4627,2,67,2,2603.31,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3605,7562,1019,40740,4627,2,13,1,15000.00,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(3606,7562,1020,40740,4627,3,221,1,2555.14,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3607,7562,1020,40740,4627,3,250,1,19174.90,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3608,7562,1020,40740,4627,3,68,1,4026.73,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3609,7562,1020,40740,4627,3,250,1,1277.58,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3610,7562,1020,40740,4627,3,57,2,27034.35,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3611,7562,1021,40740,4627,3,250,1,40580.00,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3612,7562,1021,40740,4627,3,68,1,8521.80,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3613,7562,1021,40740,4627,3,57,2,49101.80,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL);
INSERT INTO `balance_libro_details` VALUES (3614,7562,1022,40740,4627,3,250,1,12405.00,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3615,7562,1022,40740,4627,3,68,1,2605.05,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3616,7562,1022,40740,4627,3,57,2,15010.05,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3617,7562,1023,40740,4627,3,250,2,160.33,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3618,7562,1023,40740,4627,3,67,2,33.67,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3619,7562,1023,40740,4627,3,57,1,194.00,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3620,7562,1024,40740,4627,3,250,1,160.33,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3621,7562,1024,40740,4627,3,68,1,33.67,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3622,7562,1024,40740,4627,3,57,2,194.00,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3623,7562,1025,40740,4627,3,250,1,160.33,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3624,7562,1025,40740,4627,3,68,1,33.67,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3625,7562,1025,40740,4627,3,57,2,194.00,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3626,7562,1026,40740,4627,3,250,2,117000.00,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3627,7562,1026,40740,4627,3,67,2,24570.00,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3628,7562,1026,40740,4627,3,57,1,141570.00,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3629,7562,1027,40740,4627,3,250,1,6545.48,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3630,7562,1027,40740,4627,3,68,1,1374.55,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3631,7562,1027,40740,4627,3,57,2,7920.03,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3632,7562,1028,40740,4627,3,237,1,192.83,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3633,7562,1028,40740,4627,3,250,1,6427.57,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3634,7562,1028,40740,4627,3,68,1,1349.79,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3635,7562,1028,40740,4627,3,57,2,7970.19,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3636,7562,1029,40740,4627,3,250,1,9954.00,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3637,7562,1029,40740,4627,3,68,1,2090.34,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3638,7562,1029,40740,4627,3,57,2,12044.34,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3639,7562,1030,40740,4627,3,250,1,9210.00,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(3640,7562,1030,40740,4627,3,68,1,1934.10,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(3641,7562,1030,40740,4627,3,57,2,11144.10,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(3642,7562,1031,40740,4627,3,250,1,13482.00,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(3643,7562,1031,40740,4627,3,68,1,2831.22,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(3644,7562,1031,40740,4627,3,57,2,16313.22,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(3645,7562,1032,40740,4627,3,250,1,8990.00,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(3646,7562,1032,40740,4627,3,68,1,1887.90,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(3647,7562,1032,40740,4627,3,57,2,10877.90,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(3648,7562,1033,40740,4627,3,217,1,10153.98,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(3649,7562,1033,40740,4627,3,68,1,2132.34,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(3650,7562,1033,40740,4627,3,217,1,1115.69,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(3651,7562,1033,40740,4627,3,57,2,13402.01,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(3652,7562,1034,40740,4627,3,217,1,27842.98,NULL,'2023-08-12 12:39:56','2023-08-12 12:39:56',NULL),(3653,7562,1034,40740,4627,3,68,1,5847.03,NULL,'2023-08-12 12:39:56','2023-08-12 12:39:56',NULL),(3654,7562,1034,40740,4627,3,57,2,33690.01,NULL,'2023-08-12 12:39:56','2023-08-12 12:39:56',NULL);
INSERT INTO `balance_libro_details` VALUES (3655,7562,1035,40740,4627,3,217,1,7726.82,NULL,'2023-08-12 12:41:04','2023-08-12 12:41:04',NULL),(3656,7562,1035,40740,4627,3,68,1,1622.63,NULL,'2023-08-12 12:41:04','2023-08-12 12:41:04',NULL),(3657,7562,1035,40740,4627,3,217,1,1151.97,NULL,'2023-08-12 12:41:04','2023-08-12 12:41:04',NULL),(3658,7562,1035,40740,4627,3,57,2,10501.42,NULL,'2023-08-12 12:41:04','2023-08-12 12:41:04',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-08-17 20:40:00',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-08-17 20:40:00',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-08-17 20:40:00',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-08-17 20:40:00','2022-08-17 20:40:00',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-08-17 20:40:20','2022-08-17 20:40:20',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-08-17 20:40:20','2022-08-17 20:40:20',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-08-17 20:40:20','2022-08-17 20:40:20',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-08-17 20:40:20','2022-08-17 20:40:20',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:03:30','2023-05-30 15:03:30',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:03:30','2023-05-30 15:03:30',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:03:30','2023-05-30 15:03:30',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:03:30','2023-05-30 15:03:30',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:03:30','2023-05-30 15:03:30',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:03:30','2023-05-30 15:03:30',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar`
--

DROP TABLE IF EXISTS `calendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `ws_telefono_id` bigint(20) unsigned DEFAULT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion_text` longtext COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `start` datetime DEFAULT NULL,
  `startEditable` tinyint(1) NOT NULL DEFAULT '1',
  `startStr` text COLLATE utf8mb4_unicode_ci,
  `end` datetime DEFAULT NULL,
  `endStr` text COLLATE utf8mb4_unicode_ci,
  `allDay` tinyint(1) NOT NULL DEFAULT '1',
  `allow` tinyint(1) DEFAULT NULL,
  `backgroundColor` text COLLATE utf8mb4_unicode_ci,
  `borderColor` text COLLATE utf8mb4_unicode_ci,
  `classNames` longtext COLLATE utf8mb4_unicode_ci,
  `constraint` text COLLATE utf8mb4_unicode_ci,
  `display` text COLLATE utf8mb4_unicode_ci,
  `durationEditable` tinyint(1) NOT NULL DEFAULT '1',
  `extendedProps` longtext COLLATE utf8mb4_unicode_ci,
  `groupId` text COLLATE utf8mb4_unicode_ci,
  `overlap` text COLLATE utf8mb4_unicode_ci,
  `source` longtext COLLATE utf8mb4_unicode_ci,
  `textColor` text COLLATE utf8mb4_unicode_ci,
  `is_impuesto_from_taxes` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_person_id_foreign` (`person_id`),
  KEY `calendar_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `calendar_ws_telefono_id_foreign` (`ws_telefono_id`),
  CONSTRAINT `calendar_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_ws_telefono_id_foreign` FOREIGN KEY (`ws_telefono_id`) REFERENCES `ws_telefonos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar`
--

LOCK TABLES `calendar` WRITE;
/*!40000 ALTER TABLE `calendar` DISABLE KEYS */;
INSERT INTO `calendar` VALUES (1,NULL,40720,NULL,NULL,'Ganancias Sociedades',NULL,NULL,'','2023-11-13 10:00:00',1,NULL,'2023-11-13 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(2,NULL,40720,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-02-17 10:00:00',1,NULL,'2022-02-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(3,NULL,40720,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-03-16 10:00:00',1,NULL,'2022-03-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(4,NULL,40720,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-04-18 10:00:00',1,NULL,'2022-04-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(5,NULL,40720,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-05-17 10:00:00',1,NULL,'2022-05-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(6,NULL,40720,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-06-21 10:00:00',1,NULL,'2022-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(7,NULL,40720,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-07-18 10:00:00',1,NULL,'2022-07-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(8,NULL,40720,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-08-16 10:00:00',1,NULL,'2022-08-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(9,NULL,40720,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-09-19 10:00:00',1,NULL,'2022-09-19 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(10,NULL,40720,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-10-17 10:00:00',1,NULL,'2022-10-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(11,NULL,40720,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-11-16 10:00:00',1,NULL,'2022-11-16 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(12,NULL,40720,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2022-12-19 10:00:00',1,NULL,'2022-12-19 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(13,NULL,40720,NULL,NULL,'IIBB Mendoza - DDJJ Mensual',NULL,NULL,'','2023-01-17 10:00:00',1,NULL,'2023-01-17 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(14,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-01-18 10:00:00',1,NULL,'2023-01-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(15,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-02-22 10:00:00',1,NULL,'2023-02-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(16,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-03-20 10:00:00',1,NULL,'2023-03-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(17,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-04-18 10:00:00',1,NULL,'2023-04-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(18,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-05-18 10:00:00',1,NULL,'2023-05-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(19,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (20,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-07-18 10:00:00',1,NULL,'2023-07-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(21,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-08-18 10:00:00',1,NULL,'2023-08-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(22,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-09-18 10:00:00',1,NULL,'2023-09-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(23,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(24,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-11-21 10:00:00',1,NULL,'2023-11-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(25,NULL,40720,NULL,NULL,'IVA',NULL,NULL,'','2023-12-18 10:00:00',1,NULL,'2023-12-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(26,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-01-18 10:00:00',1,NULL,'2023-01-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(27,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-02-22 10:00:00',1,NULL,'2023-02-22 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(28,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-03-20 10:00:00',1,NULL,'2023-03-20 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(29,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-04-18 10:00:00',1,NULL,'2023-04-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(30,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-05-18 10:00:00',1,NULL,'2023-05-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(31,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-06-21 10:00:00',1,NULL,'2023-06-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(32,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-07-18 10:00:00',1,NULL,'2023-07-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(33,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-08-18 10:00:00',1,NULL,'2023-08-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(34,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-09-18 10:00:00',1,NULL,'2023-09-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(35,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-10-18 10:00:00',1,NULL,'2023-10-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(36,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-11-21 10:00:00',1,NULL,'2023-11-21 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(37,NULL,40720,NULL,NULL,'IVA - CITI - Regimen Informativo',NULL,NULL,'','2023-12-18 10:00:00',1,NULL,'2023-12-18 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(38,NULL,40720,NULL,NULL,'Sindicato - FATSA (Sanidad)',NULL,NULL,'','2023-01-09 10:00:00',1,NULL,'2023-01-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
INSERT INTO `calendar` VALUES (39,NULL,40720,NULL,NULL,'Sindicato - FATSA (Sanidad)',NULL,NULL,'','2023-02-09 10:00:00',1,NULL,'2023-02-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(40,NULL,40720,NULL,NULL,'Sindicato - FATSA (Sanidad)',NULL,NULL,'','2023-03-09 10:00:00',1,NULL,'2023-03-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(41,NULL,40720,NULL,NULL,'Sindicato - FATSA (Sanidad)',NULL,NULL,'','2023-04-10 10:00:00',1,NULL,'2023-04-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(42,NULL,40720,NULL,NULL,'Sindicato - FATSA (Sanidad)',NULL,NULL,'','2023-05-09 10:00:00',1,NULL,'2023-05-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(43,NULL,40720,NULL,NULL,'Sindicato - FATSA (Sanidad)',NULL,NULL,'','2023-06-09 10:00:00',1,NULL,'2023-06-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(44,NULL,40720,NULL,NULL,'Sindicato - FATSA (Sanidad)',NULL,NULL,'','2023-07-10 10:00:00',1,NULL,'2023-07-10 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(45,NULL,40720,NULL,NULL,'Sindicato - FATSA (Sanidad)',NULL,NULL,'','2023-08-09 10:00:00',1,NULL,'2023-08-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(46,NULL,40720,NULL,NULL,'Sindicato - FATSA (Sanidad)',NULL,NULL,'','2023-09-11 10:00:00',1,NULL,'2023-09-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(47,NULL,40720,NULL,NULL,'Sindicato - FATSA (Sanidad)',NULL,NULL,'','2023-10-09 10:00:00',1,NULL,'2023-10-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(48,NULL,40720,NULL,NULL,'Sindicato - FATSA (Sanidad)',NULL,NULL,'','2023-11-09 10:00:00',1,NULL,'2023-11-09 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL),(49,NULL,40720,NULL,NULL,'Sindicato - FATSA (Sanidad)',NULL,NULL,'','2023-12-11 10:00:00',1,NULL,'2023-12-11 10:30:00',NULL,0,NULL,'#FF0000',NULL,NULL,NULL,'auto',1,NULL,NULL,NULL,NULL,'#FFFFFF',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `calendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_emails_telefonos`
--

DROP TABLE IF EXISTS `calendar_emails_telefonos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_emails_telefonos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci,
  `celular` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_emails_telefonos_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_emails_telefonos_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_emails_telefonos`
--

LOCK TABLES `calendar_emails_telefonos` WRITE;
/*!40000 ALTER TABLE `calendar_emails_telefonos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_emails_telefonos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_files`
--

DROP TABLE IF EXISTS `calendar_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_files_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_files_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_files`
--

LOCK TABLES `calendar_files` WRITE;
/*!40000 ALTER TABLE `calendar_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1`
--

DROP TABLE IF EXISTS `calendar_niv_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_1_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1`
--

LOCK TABLES `calendar_niv_1` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1_2`
--

DROP TABLE IF EXISTS `calendar_niv_1_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_2_person_id_foreign` (`person_id`),
  KEY `calendar_niv_1_2_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_niv_1_2_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_niv_1_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1_2`
--

LOCK TABLES `calendar_niv_1_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_2`
--

DROP TABLE IF EXISTS `calendar_niv_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_2_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_2`
--

LOCK TABLES `calendar_niv_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_notificaciones`
--

DROP TABLE IF EXISTS `calendar_notificaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_notificaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `start` datetime DEFAULT NULL,
  `tipo_de_notificacion_id` int(10) unsigned NOT NULL,
  `cantidad` int(10) unsigned NOT NULL,
  `unidad_de_tiempo_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_notificaciones_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_notificaciones_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_notificaciones`
--

LOCK TABLES `calendar_notificaciones` WRITE;
/*!40000 ALTER TABLE `calendar_notificaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_notificaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo`
--

DROP TABLE IF EXISTS `calendar_tur_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `dia_hora` datetime(5) DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:30',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_tur_dispo_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_tur_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo`
--

LOCK TABLES `calendar_tur_dispo` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo_datos`
--

DROP TABLE IF EXISTS `calendar_tur_dispo_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_tur_dispo_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre_ape` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_datos_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` (`calendar_tur_dispo_id`),
  CONSTRAINT `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` FOREIGN KEY (`calendar_tur_dispo_id`) REFERENCES `calendar_tur_dispo` (`id`),
  CONSTRAINT `calendar_tur_dispo_datos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo_datos`
--

LOCK TABLES `calendar_tur_dispo_datos` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-10-23 23:33:12',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-10-23 23:33:12',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-10-23 23:33:12',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-10-23 23:33:12',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-10-23 23:33:12',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-10-23 23:33:12',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:33:12',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:33:12',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',2108288.01,175690.67,'No Excluida','0',30,3330,485448.92,1047.86,1047.86,4623.27,6457.26,12128.39,12128.39,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',3133941.63,261161.80,'No Excluida','0',45,5000,485448.92,2018.89,2018.89,5085.60,6457.26,13561.75,13561.75,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',4387518.23,365626.52,'No Excluida','0',60,6700,970897.79,3452.09,3190.00,5594.16,6457.26,15503.51,15241.42,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',5449094.55,454091.21,'No Excluida','0',85,10000,970897.79,5671.23,5239.75,6153.58,7673.13,19497.94,19066.46,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',6416528.72,534710.73,'No Excluida','0',110,13000,1209769.40,10787.67,8368.13,6768.94,9389.36,26945.97,24526.43,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',8020660.90,668388.41,'No Excluida','0',150,16500,1213622.14,14840.88,10926.38,7445.83,10850.90,33137.61,29223.11,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',9624793.05,802066.09,'No Excluida','0',200,20000,1456346.67,18878.58,13623.24,8190.41,11625.96,38694.95,33439.61,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',11916410.45,993034.20,'No Excluida','0',200,20000,1941795.53,43150.91,33442.08,9009.45,13951.15,66111.51,56402.68,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',13337213.22,1111434.44,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,53938.71,9910.39,17272.86,NULL,81121.96,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',15285088.04,1273757.34,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,63385.73,10901.43,19332.31,NULL,93619.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',16957968.71,1413164.06,'Venta de Bs Muebles','0',200,20000,1941795.53,NULL,72817.31,11991.57,22155.77,NULL,106964.65,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL),(2,NULL,'Articulo 6',6,0,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL),(3,NULL,'Articulo 7',7,0,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL),(4,NULL,'Articulo 8',8,0,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL),(5,NULL,'Articulo 9',9,0,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL),(6,NULL,'Articulo 10',10,0,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL),(7,NULL,'Articulo 11',11,0,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL),(8,NULL,'Articulo 12',12,0,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL),(9,NULL,'Articulo 13',13,0,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL),(10,NULL,'Articulo 14',14,1,'2022-08-17 20:40:11','2022-08-17 20:40:11',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_datos`
--

DROP TABLE IF EXISTS `cobradores_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `url_panel` longtext COLLATE utf8mb4_unicode_ci,
  `usuario` text COLLATE utf8mb4_unicode_ci,
  `clave` text COLLATE utf8mb4_unicode_ci,
  `numero_de_soporte` text COLLATE utf8mb4_unicode_ci,
  `inicial_create_user` text COLLATE utf8mb4_unicode_ci,
  `imp_min_p_retirar` int(11) DEFAULT NULL,
  `secret_recarga` text COLLATE utf8mb4_unicode_ci,
  `secret_on_off` text COLLATE utf8mb4_unicode_ci,
  `clave_new_user` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_datos_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_datos_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_datos`
--

LOCK TABLES `cobradores_datos` WRITE;
/*!40000 ALTER TABLE `cobradores_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_metodos`
--

DROP TABLE IF EXISTS `cobradores_metodos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_metodos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cobradores_metodos_descripcion_unique` (`descripcion`),
  KEY `cobradores_metodos_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_metodos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_metodos`
--

LOCK TABLES `cobradores_metodos` WRITE;
/*!40000 ALTER TABLE `cobradores_metodos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_metodos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_on_off`
--

DROP TABLE IF EXISTS `cobradores_on_off`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_on_off` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `on_off` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_on_off_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_on_off_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_on_off`
--

LOCK TABLES `cobradores_on_off` WRITE;
/*!40000 ALTER TABLE `cobradores_on_off` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_on_off` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:42:25','2023-03-12 23:42:25',NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
INSERT INTO `consultas_aux` VALUES (1,NULL,1,NULL,'[{\"id\":40720,\"user_id\":7562,\"field_name1\":\"BIO ANALITICA DR.E.BISOGNO SRL\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"30-71231080-0\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-04-06T13:51:28.000000Z\",\"updated_at\":\"2023-04-06T13:51:28.000000Z\",\"activity_id\":null,\"address\":\"SAN MARTIN 92 Piso:PB Dpto:3\",\"person_type_id\":2,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":3,\"user_id\":7562,\"person_id\":40720,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-04-06T13:51:28.000000Z\",\"updated_at\":\"2023-04-06T14:02:53.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":6,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2021-07\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":1,\"is_itc\":0,\"priority_order\":1,\"person_id_administrador\":40720,\"person_id_titular\":40720,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2023-04-06T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":1,\"user_id\":7562,\"person_id\":40720,\"liquidator_id\":8,\"created_at\":\"2023-04-06T14:02:53.000000Z\",\"updated_at\":\"2023-04-06T14:02:53.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":7562,\"name\":\"Alejandro\",\"created_at\":\"2023-04-06T14:00:34.000000Z\",\"updated_at\":\"2023-04-06T14:00:34.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":1539,\"user_id\":null,\"code\":\"2023-03\",\"year\":2023,\"period_number\":3,\"date_from\":\"2023-03-01\",\"date_to\":\"2023-03-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40720,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40719,\"user_id\":7562,\"field_name1\":\"Sosa Alejandro\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-36746223-0\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-08-18T05:39:49.000000Z\",\"updated_at\":\"2022-10-27T15:42:43.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":2,\"user_id\":7562,\"person_id\":40719,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-08-17T23:40:24.000000Z\",\"updated_at\":\"2022-10-27T15:42:43.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":1,\"obligation_sell\":0,\"obligation_buy\":0,\"obligation_iva\":0,\"obligation_electronic_receipt\":0,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-1\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":2,\"person_id_administrador\":40719,\"person_id_titular\":40719,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-10-27T03:00:00.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":null,\"periods\":[{\"id\":20,\"user_id\":null,\"code\":\"2023-03\",\"year\":2023,\"period_number\":3,\"date_from\":\"2023-03-01\",\"date_to\":\"2023-03-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40719,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40721,\"user_id\":7562,\"field_name1\":\"SUCESION DE AVILA CIRO JACINTO\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-06897295-8\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2023-04-11T22:46:47.000000Z\",\"updated_at\":\"2023-04-11T22:46:47.000000Z\",\"activity_id\":null,\"address\":\"CORONOLE PLAZA 371 - GENERAL SAN MARTIN - MENDOZA\",\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"status_liq_sueldos\":\"Sin Usar\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":4,\"user_id\":7562,\"person_id\":40721,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2023-04-11T22:46:47.000000Z\",\"updated_at\":\"2023-04-11T22:46:47.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2023-01\",\"obligation_salaries\":1,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":1,\"priority_order\":1,\"person_id_administrador\":40721,\"person_id_titular\":40721,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"-000001-11-30T03:53:48.000000Z\",\"iibb\":null,\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":2,\"user_id\":7562,\"person_id\":40721,\"liquidator_id\":8,\"created_at\":\"2023-04-11T22:46:47.000000Z\",\"updated_at\":\"2023-04-11T22:46:47.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":8,\"user_id\":7562,\"name\":\"Alejandro\",\"created_at\":\"2023-04-06T14:00:34.000000Z\",\"updated_at\":\"2023-04-06T14:00:34.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":3051,\"user_id\":null,\"code\":\"2023-03\",\"year\":2023,\"period_number\":3,\"date_from\":\"2023-03-01\",\"date_to\":\"2023-03-31\",\"created_at\":null,\"updated_at\":null,\"person_id\":40721,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]}]',1,'2023-04-14 12:09:29','2023-04-14 12:09:32',NULL);
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1027 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales','Result. Negativo',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22'),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(482,7562,2110352,5,2,2110300,'Plan de Pago - AFIP','Pasivo',NULL,1,1,1,1,1,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (483,7562,2110351,5,2,2110300,'Plan de Pago - ATM','Pasivo',NULL,1,1,1,1,1,0,NULL),(484,7562,2110210,5,2,2110200,'Obra Social a Pagar','Pasivo',NULL,1,1,1,1,1,0,NULL),(485,7562,2110209,5,2,2110200,'A.R.T.','Pasivo',NULL,1,1,1,1,1,0,NULL),(486,7562,2110353,5,2,2110300,'SVCO','Pasivo',NULL,1,1,1,1,1,1,NULL),(487,7562,4120101,5,1,4120100,'REPRO II','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(488,7562,5120108,5,2,5120100,'Gastos administrativos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(489,7562,5120108,5,2,5120100,'Costo de Venta de servicios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(490,7562,5120108,5,2,5120100,'Insumos medicos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(491,7562,5120108,5,2,5120100,'Mantenimientos y Reparaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(492,7562,5120108,5,2,5120100,'Libreria y Papeleria','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(493,7562,5120108,5,2,5120100,'Servicio de Informatica','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(494,7562,5120108,5,2,5120100,'Combustible y lubricantes','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(1001,NULL,5140170,5,1,5140100,'SIRTAC Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1002,NULL,5140171,5,1,5140100,'SIRTAC Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1003,NULL,5140172,5,1,5140100,'SIRTAC Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1004,NULL,5140173,5,1,5140100,'SIRTAC Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1005,NULL,5140174,5,1,5140100,'SIRTAC Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1006,NULL,5140175,5,1,5140100,'SIRTAC Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1007,NULL,5140176,5,1,5140100,'SIRTAC Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1008,NULL,5140177,5,1,5140100,'SIRTAC La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1009,NULL,5140178,5,1,5140100,'SIRTAC La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1010,NULL,5140179,5,1,5140100,'SIRTAC Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1011,NULL,5140180,5,1,5140100,'SIRTAC Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1012,NULL,5140181,5,1,5140100,'SIRTAC Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1013,NULL,5140182,5,1,5140100,'SIRTAC Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1014,NULL,5140183,5,1,5140100,'SIRTAC Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1015,NULL,5140184,5,1,5140100,'SIRTAC San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1016,NULL,5140185,5,1,5140100,'SIRTAC San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1017,NULL,5140186,5,1,5140100,'SIRTAC Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1018,NULL,5140187,5,1,5140100,'SIRTAC Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1019,NULL,5140188,5,1,5140100,'SIRTAC Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1020,NULL,5140189,5,1,5140100,'SIRTAC Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1021,NULL,5140190,5,1,5140100,'SIRTAC Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1022,NULL,5140191,5,1,5140100,'SIRTAC Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1023,NULL,5140192,5,1,5140100,'SIRTAC Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1024,NULL,5140193,5,1,5140100,'SIRTAC Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1025,NULL,5140194,5,1,5140100,'SIRTAC Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1026,NULL,6110104,5,1,6110100,'BANCO SIRTAC','Movimiento',NULL,1,2,0,0,1,1,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL),(24,'SIRTAC','2023-10-16 21:14:07','2023-10-16 21:14:07',NULL,20);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=802 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,7562,3,40721,40722,57,3051,2,0,'2023-03-03','2023-03-03',1540.00,1,1.00,'Factura A N°: 0020-00000346',NULL,'2023-04-11 19:52:55','2023-04-11 19:52:55',NULL),(2,7562,3,40721,40723,57,3051,2,0,'2023-03-03','2023-03-03',3162.89,1,1.00,'Factura A N°: 0012-00002785',NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(3,7562,3,40721,40724,57,3051,2,0,'2023-03-08','2023-03-08',2000.00,1,1.00,'Factura A N°: 0009-00008648',NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(4,7562,3,40721,40725,57,3051,2,0,'2023-03-13','2023-03-13',6449.30,1,1.00,'Factura A N°: 0011-00000619',NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(5,7562,3,40721,40726,57,3051,2,0,'2023-03-17','2023-03-17',68400.01,1,1.00,'Factura A N°: 0003-00050630',NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(6,7562,3,40721,40722,57,3051,2,0,'2023-03-18','2023-03-18',2200.00,1,1.00,'Factura A N°: 0020-00000402',NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(7,7562,3,40721,40726,57,3051,2,0,'2023-03-20','2023-03-20',70400.00,1,1.00,'Factura A N°: 0003-00050655',NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(8,7562,3,40721,40724,57,3051,2,0,'2023-03-21','2023-03-21',1950.00,1,1.00,'Factura A N°: 0009-00008697',NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(9,7562,3,40721,40722,57,3051,2,0,'2023-03-29','2023-03-29',700.00,1,1.00,'Factura A N°: 0020-00000446',NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(10,7562,3,40721,40727,57,3051,2,0,'1969-12-31','1969-12-31',900.00,1,1.00,'Tique Factura A N°: 0019-00001463',NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(11,7562,3,40721,40728,57,3051,2,0,'1969-12-31','1969-12-31',15001.18,1,1.00,'Tique Factura A N°: 0076-00048744',NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(12,7562,3,40721,40729,57,3051,2,0,'1969-12-31','1969-12-31',2000.00,1,1.00,'Tique Factura A N°: 0023-00067484',NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(13,7562,3,40721,40729,57,3051,2,0,'1969-12-31','1969-12-31',1999.99,1,1.00,'Tique Factura A N°: 0024-00032194',NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(14,7562,3,40721,40730,57,3051,2,0,'1969-12-31','1969-12-31',3000.13,1,1.00,'Tique Factura A N°: 0221-00026817',NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(15,7562,3,40721,40730,57,3051,2,0,'1969-12-31','1969-12-31',5000.12,1,1.00,'Tique Factura A N°: 0221-00026648',NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(16,7562,3,40721,40730,57,3051,2,0,'1969-12-31','1969-12-31',3000.13,1,1.00,'Tique Factura A N°: 0221-00026853',NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(17,7562,3,40721,40730,57,3051,2,0,'1969-12-31','1969-12-31',5000.01,1,1.00,'Tique Factura A N°: 0221-00026208',NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(18,7562,3,40721,40730,57,3051,2,0,'1969-12-31','1969-12-31',5000.07,1,1.00,'Tique Factura A N°: 0221-00025674',NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(19,7562,3,40721,40730,57,3051,2,0,'1969-12-31','1969-12-31',5000.05,1,1.00,'Tique Factura A N°: 0221-00026476',NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(20,7562,3,40721,40730,57,3051,2,0,'1969-12-31','1969-12-31',6500.07,1,1.00,'Tique Factura A N°: 0225-00033485',NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(21,7562,2,40720,40731,13,1539,1,0,'2023-03-08','2023-03-08',5350.00,1,1.00,'Factura A N°: 0002-00000117',NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(22,7562,2,40720,40732,13,1539,1,0,'2023-03-17','2023-03-17',3030.02,1,1.00,'Factura B N°: 0002-00000429',NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(23,7562,2,40720,40733,13,1539,1,0,'2023-03-23','2023-03-23',3000.00,1,1.00,'Factura B N°: 0002-00000430',NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(24,7562,2,40720,40734,13,1539,1,0,'2023-03-28','2023-03-28',33000.00,1,1.00,'Factura A N°: 0002-00000118',NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL);
INSERT INTO `cta_cte_cliente` VALUES (25,7562,2,40720,40735,13,1539,1,0,'2023-03-31','2023-03-31',1344323.85,1,1.00,'Cuenta de Venta y Líquido Producto A N°: 0006-00012798',NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(26,7562,3,40720,40736,57,1539,2,0,'2023-03-01','2023-03-01',126383.19,1,1.00,'Factura A N°: 0005-00157668',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(27,7562,3,40720,40735,57,1539,2,0,'2023-03-02','2023-03-02',8605.52,1,1.00,'Factura A N°: 0005-00049287',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(28,7562,3,40720,40735,57,1539,2,0,'2023-03-02','2023-03-02',19190.21,1,1.00,'Factura A N°: 0005-00049308',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(29,7562,3,40720,40737,57,1539,2,0,'2023-03-09','2023-03-09',14302.78,1,1.00,'Factura A N°: 0948-00916176',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(30,7562,3,40720,40735,57,1539,2,0,'2023-03-09','2023-03-09',19363.41,1,1.00,'Factura A N°: 0005-00049456',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(31,7562,3,40720,40731,57,1539,2,0,'2023-03-09','2023-03-09',45737.20,1,1.00,'Factura A N°: 0003-00011739',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(32,7562,3,40720,40735,57,1539,2,0,'2023-03-13','2023-03-13',24452.94,1,1.00,'Factura A N°: 0005-00049524',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(33,7562,3,40720,40735,57,1539,2,0,'2023-03-14','2023-03-14',8948.33,1,1.00,'Factura A N°: 0005-00049536',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(34,7562,3,40720,40737,57,1539,1,0,'2023-03-14','2023-03-14',4500.01,1,1.00,'Nota de crédito A N°: 1428-00360389',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(35,7562,3,40720,40735,57,1539,2,0,'2023-03-16','2023-03-16',1962.52,1,1.00,'Factura A N°: 0005-00049606',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(36,7562,3,40720,40738,57,1539,2,0,'2023-03-17','2023-03-17',200.00,1,1.00,'Factura A N°: 0004-00016099',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(37,7562,3,40720,40735,57,1539,2,0,'2023-03-23','2023-03-23',29912.76,1,1.00,'Factura A N°: 0005-00049795',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(38,7562,3,40720,40735,57,1539,2,0,'2023-03-27','2023-03-27',11204.62,1,1.00,'Factura A N°: 0005-00049820',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(39,7562,3,40720,40735,57,1539,2,0,'2023-03-28','2023-03-28',10004.44,1,1.00,'Factura A N°: 0005-00049848',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(40,7562,3,40720,40735,57,1539,2,0,'2023-03-30','2023-03-30',3294.23,1,1.00,'Factura A N°: 0005-00049906',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(41,7562,3,40720,40739,57,1539,2,0,'2023-03-31','2023-03-31',7376.47,1,1.00,'Factura A N°: 0002-00038444',NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(42,7562,2,40740,40741,13,4623,1,0,'2023-03-01','2023-03-01',2000.00,1,1.00,'Factura B N°: 0002-00005358',NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(43,7562,2,40740,40741,13,4623,1,0,'2023-03-01','2023-03-01',3200.00,1,1.00,'Factura B N°: 0002-00005359',NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(44,7562,2,40740,40741,13,4623,1,0,'2023-03-02','2023-03-02',2300.00,1,1.00,'Factura B N°: 0002-00005360',NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(45,7562,2,40740,40741,13,4623,1,0,'2023-03-02','2023-03-02',4800.00,1,1.00,'Factura B N°: 0002-00005361',NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(46,7562,2,40740,40741,13,4623,1,0,'2023-03-02','2023-03-02',5175.00,1,1.00,'Factura B N°: 0002-00005362',NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(47,7562,2,40740,40741,13,4623,1,0,'2023-03-02','2023-03-02',4900.00,1,1.00,'Factura B N°: 0002-00005363',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(48,7562,2,40740,40741,13,4623,1,0,'2023-03-02','2023-03-02',6000.00,1,1.00,'Factura B N°: 0002-00005364',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL);
INSERT INTO `cta_cte_cliente` VALUES (49,7562,2,40740,40741,13,4623,1,0,'2023-03-02','2023-03-02',3000.00,1,1.00,'Factura B N°: 0002-00005365',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(50,7562,2,40740,40741,13,4623,1,0,'2023-03-02','2023-03-02',17800.00,1,1.00,'Factura B N°: 0002-00005366',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(51,7562,2,40740,40741,13,4623,1,0,'2023-03-02','2023-03-02',2700.00,1,1.00,'Factura B N°: 0002-00005367',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(52,7562,2,40740,40741,13,4623,1,0,'2023-03-03','2023-03-03',5600.00,1,1.00,'Factura B N°: 0002-00005368',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(53,7562,2,40740,40741,13,4623,1,0,'2023-03-03','2023-03-03',9900.00,1,1.00,'Factura B N°: 0002-00005369',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(54,7562,2,40740,40741,13,4623,1,0,'2023-03-03','2023-03-03',4200.00,1,1.00,'Factura B N°: 0002-00005370',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(55,7562,2,40740,40741,13,4623,1,0,'2023-03-04','2023-03-04',6780.00,1,1.00,'Factura B N°: 0002-00005371',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(56,7562,2,40740,40741,13,4623,1,0,'2023-03-04','2023-03-04',16800.00,1,1.00,'Factura B N°: 0002-00005372',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(57,7562,2,40740,40741,13,4623,1,0,'2023-03-04','2023-03-04',9800.00,1,1.00,'Factura B N°: 0002-00005373',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(58,7562,2,40740,40741,13,4623,1,0,'2023-03-04','2023-03-04',5600.00,1,1.00,'Factura B N°: 0002-00005374',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(59,7562,2,40740,40741,13,4623,1,0,'2023-03-04','2023-03-04',3800.00,1,1.00,'Factura B N°: 0002-00005375',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(60,7562,2,40740,40741,13,4623,1,0,'2023-03-04','2023-03-04',1500.00,1,1.00,'Factura B N°: 0002-00005376',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(61,7562,2,40740,40741,13,4623,1,0,'2023-03-06','2023-03-06',5060.00,1,1.00,'Factura B N°: 0002-00005377',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(62,7562,2,40740,40741,13,4623,1,0,'2023-03-06','2023-03-06',3900.00,1,1.00,'Factura B N°: 0002-00005378',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(63,7562,2,40740,40741,13,4623,1,0,'2023-03-08','2023-03-08',4500.00,1,1.00,'Factura B N°: 0002-00005379',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(64,7562,2,40740,40741,13,4623,1,0,'2023-03-09','2023-03-09',13800.00,1,1.00,'Factura B N°: 0002-00005380',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(65,7562,2,40740,40741,13,4623,1,0,'2023-03-09','2023-03-09',5290.00,1,1.00,'Factura B N°: 0002-00005381',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(66,7562,2,40740,40742,13,4623,1,0,'2023-03-09','2023-03-09',12600.00,1,1.00,'Factura B N°: 0002-00005382',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(67,7562,2,40740,40741,13,4623,1,0,'2023-03-09','2023-03-09',7900.00,1,1.00,'Factura B N°: 0002-00005383',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(68,7562,2,40740,40741,13,4623,1,0,'2023-03-09','2023-03-09',4200.00,1,1.00,'Factura B N°: 0002-00005384',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(69,7562,2,40740,40741,13,4623,1,0,'2023-03-10','2023-03-10',2800.00,1,1.00,'Factura B N°: 0002-00005385',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(70,7562,2,40740,40741,13,4623,1,0,'2023-03-10','2023-03-10',13800.00,1,1.00,'Factura B N°: 0002-00005386',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(71,7562,2,40740,40741,13,4623,1,0,'2023-03-10','2023-03-10',7930.00,1,1.00,'Factura B N°: 0002-00005387',NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(72,7562,2,40740,40741,13,4623,1,0,'2023-03-10','2023-03-10',5500.00,1,1.00,'Factura B N°: 0002-00005388',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL);
INSERT INTO `cta_cte_cliente` VALUES (73,7562,2,40740,40741,13,4623,1,0,'2023-03-10','2023-03-10',11000.00,1,1.00,'Factura B N°: 0002-00005389',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(74,7562,2,40740,40741,13,4623,1,0,'2023-03-10','2023-03-10',5000.00,1,1.00,'Factura B N°: 0002-00005390',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(75,7562,2,40740,40741,13,4623,1,0,'2023-03-10','2023-03-10',4800.00,1,1.00,'Factura B N°: 0002-00005391',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(76,7562,2,40740,40741,13,4623,1,0,'2023-03-10','2023-03-10',15000.00,1,1.00,'Factura B N°: 0002-00005392',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(77,7562,2,40740,40741,13,4623,1,0,'2023-03-11','2023-03-11',4200.00,1,1.00,'Factura B N°: 0002-00005393',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(78,7562,2,40740,40741,13,4623,1,0,'2023-03-11','2023-03-11',5900.00,1,1.00,'Factura B N°: 0002-00005394',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(79,7562,2,40740,40741,13,4623,1,0,'2023-03-11','2023-03-11',5600.00,1,1.00,'Factura B N°: 0002-00005395',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(80,7562,2,40740,40741,13,4623,1,0,'2023-03-11','2023-03-11',5175.00,1,1.00,'Factura B N°: 0002-00005396',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(81,7562,2,40740,40741,13,4623,1,0,'2023-03-11','2023-03-11',9900.00,1,1.00,'Factura B N°: 0002-00005397',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(82,7562,2,40740,40741,13,4623,1,0,'2023-03-11','2023-03-11',10000.00,1,1.00,'Factura B N°: 0002-00005398',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(83,7562,2,40740,40741,13,4623,1,0,'2023-03-11','2023-03-11',10000.00,1,1.00,'Factura B N°: 0002-00005399',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(84,7562,2,40740,40741,13,4623,1,0,'2023-03-13','2023-03-13',3900.00,1,1.00,'Factura B N°: 0002-00005400',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(85,7562,2,40740,40741,13,4623,1,0,'2023-03-13','2023-03-13',9200.00,1,1.00,'Factura B N°: 0002-00005401',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(86,7562,2,40740,40741,13,4623,1,0,'2023-03-13','2023-03-13',3500.00,1,1.00,'Factura B N°: 0002-00005402',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(87,7562,2,40740,40741,13,4623,1,0,'2023-03-13','2023-03-13',9900.00,1,1.00,'Factura B N°: 0002-00005403',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(88,7562,2,40740,40741,13,4623,1,0,'2023-03-14','2023-03-14',4000.00,1,1.00,'Factura B N°: 0002-00005404',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(89,7562,2,40740,40741,13,4623,1,0,'2023-03-15','2023-03-15',5000.00,1,1.00,'Factura B N°: 0002-00005405',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(90,7562,2,40740,40741,13,4623,1,0,'2023-03-15','2023-03-15',8900.00,1,1.00,'Factura B N°: 0002-00005406',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(91,7562,2,40740,40741,13,4623,1,0,'2023-03-15','2023-03-15',3910.00,1,1.00,'Factura B N°: 0002-00005407',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(92,7562,2,40740,40741,13,4623,1,0,'2023-03-15','2023-03-15',4300.00,1,1.00,'Factura B N°: 0002-00005408',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(93,7562,2,40740,40741,13,4623,1,0,'2023-03-15','2023-03-15',6800.00,1,1.00,'Factura B N°: 0002-00005409',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(94,7562,2,40740,40741,13,4623,1,0,'2023-03-16','2023-03-16',5000.00,1,1.00,'Factura B N°: 0002-00005410',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(95,7562,2,40740,40741,13,4623,1,0,'2023-03-16','2023-03-16',8000.00,1,1.00,'Factura B N°: 0002-00005411',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(96,7562,2,40740,40741,13,4623,1,0,'2023-03-17','2023-03-17',3900.00,1,1.00,'Factura B N°: 0002-00005412',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL);
INSERT INTO `cta_cte_cliente` VALUES (97,7562,2,40740,40741,13,4623,1,0,'2023-03-17','2023-03-17',3900.00,1,1.00,'Factura B N°: 0002-00005413',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(98,7562,2,40740,40741,13,4623,1,0,'2023-03-17','2023-03-17',16000.00,1,1.00,'Factura B N°: 0002-00005414',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(99,7562,2,40740,40741,13,4623,1,0,'2023-03-17','2023-03-17',11800.00,1,1.00,'Factura B N°: 0002-00005415',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(100,7562,2,40740,40741,13,4623,1,0,'2023-03-17','2023-03-17',6780.00,1,1.00,'Factura B N°: 0002-00005416',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(101,7562,2,40740,40741,13,4623,1,0,'2023-03-18','2023-03-18',10235.00,1,1.00,'Factura B N°: 0002-00005421',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(102,7562,2,40740,40741,13,4623,1,0,'2023-03-18','2023-03-18',8900.00,1,1.00,'Factura B N°: 0002-00005422',NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(103,7562,2,40740,40741,13,4623,1,0,'2023-03-18','2023-03-18',4400.00,1,1.00,'Factura B N°: 0002-00005423',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(104,7562,2,40740,40741,13,4623,1,0,'2023-03-18','2023-03-18',10400.00,1,1.00,'Factura B N°: 0002-00005424',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(105,7562,2,40740,40741,13,4623,1,0,'2023-03-18','2023-03-18',7470.00,1,1.00,'Factura B N°: 0002-00005425',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(106,7562,2,40740,40741,13,4623,1,0,'2023-03-18','2023-03-18',7470.00,1,1.00,'Factura B N°: 0002-00005426',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(107,7562,2,40740,40741,13,4623,1,0,'2023-03-18','2023-03-18',5900.00,1,1.00,'Factura B N°: 0002-00005427',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(108,7562,2,40740,40741,13,4623,1,0,'2023-03-18','2023-03-18',4400.00,1,1.00,'Factura B N°: 0002-00005428',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(109,7562,2,40740,40741,13,4623,1,0,'2023-03-18','2023-03-18',5900.00,1,1.00,'Factura B N°: 0002-00005429',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(110,7562,2,40740,40741,13,4623,1,0,'2023-03-18','2023-03-18',15580.00,1,1.00,'Factura B N°: 0002-00005417',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(111,7562,2,40740,40741,13,4623,1,0,'2023-03-18','2023-03-18',7300.00,1,1.00,'Factura B N°: 0002-00005418',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(112,7562,2,40740,40741,13,4623,1,0,'2023-03-18','2023-03-18',5500.00,1,1.00,'Factura B N°: 0002-00005419',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(113,7562,2,40740,40741,13,4623,1,0,'2023-03-18','2023-03-18',13800.00,1,1.00,'Factura B N°: 0002-00005420',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(114,7562,2,40740,40741,13,4623,1,0,'2023-03-20','2023-03-20',5000.00,1,1.00,'Factura B N°: 0002-00005430',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(115,7562,2,40740,40741,13,4623,1,0,'2023-03-21','2023-03-21',4900.00,1,1.00,'Factura B N°: 0002-00005431',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(116,7562,2,40740,40741,13,4623,1,0,'2023-03-22','2023-03-22',6500.00,1,1.00,'Factura B N°: 0002-00005432',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(117,7562,2,40740,40741,13,4623,1,0,'2023-03-22','2023-03-22',4800.00,1,1.00,'Factura B N°: 0002-00005433',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(118,7562,2,40740,40741,13,4623,1,0,'2023-03-22','2023-03-22',3680.00,1,1.00,'Factura B N°: 0002-00005434',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(119,7562,2,40740,40741,13,4623,1,0,'2023-03-22','2023-03-22',6800.00,1,1.00,'Factura B N°: 0002-00005435',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(120,7562,2,40740,40741,13,4623,1,0,'2023-03-22','2023-03-22',4600.00,1,1.00,'Factura B N°: 0002-00005436',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL);
INSERT INTO `cta_cte_cliente` VALUES (121,7562,2,40740,40741,13,4623,1,0,'2023-03-23','2023-03-23',6000.00,1,1.00,'Factura B N°: 0002-00005437',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(122,7562,2,40740,40741,13,4623,1,0,'2023-03-25','2023-03-25',8160.00,1,1.00,'Factura B N°: 0002-00005438',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(123,7562,2,40740,40741,13,4623,1,0,'2023-03-25','2023-03-25',12880.00,1,1.00,'Factura B N°: 0002-00005439',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(124,7562,2,40740,40741,13,4623,1,0,'2023-03-25','2023-03-25',4900.00,1,1.00,'Factura B N°: 0002-00005440',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(125,7562,2,40740,40741,13,4623,1,0,'2023-03-25','2023-03-25',2800.00,1,1.00,'Factura B N°: 0002-00005441',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(126,7562,2,40740,40741,13,4623,1,0,'2023-03-25','2023-03-25',6300.00,1,1.00,'Factura B N°: 0002-00005442',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(127,7562,2,40740,40741,13,4623,1,0,'2023-03-27','2023-03-27',11210.00,1,1.00,'Factura B N°: 0002-00005443',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(128,7562,2,40740,40741,13,4623,1,0,'2023-03-28','2023-03-28',6320.00,1,1.00,'Factura B N°: 0002-00005444',NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(129,7562,2,40740,40741,13,4623,1,0,'2023-03-28','2023-03-28',4900.00,1,1.00,'Factura B N°: 0002-00005445',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(130,7562,2,40740,40741,13,4623,1,0,'2023-03-29','2023-03-29',8000.00,1,1.00,'Factura B N°: 0002-00005446',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(131,7562,2,40740,40741,13,4623,1,0,'2023-03-29','2023-03-29',6200.00,1,1.00,'Factura B N°: 0002-00005447',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(132,7562,2,40740,40741,13,4623,1,0,'2023-03-30','2023-03-30',12000.00,1,1.00,'Factura B N°: 0002-00005448',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(133,7562,2,40740,40741,13,4623,1,0,'2023-03-30','2023-03-30',5060.00,1,1.00,'Factura B N°: 0002-00005449',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(134,7562,2,40740,40741,13,4623,1,0,'2023-03-30','2023-03-30',6000.00,1,1.00,'Factura B N°: 0002-00005450',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(135,7562,2,40740,40741,13,4623,1,0,'2023-03-31','2023-03-31',9500.00,1,1.00,'Factura B N°: 0002-00005451',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(136,7562,2,40740,40741,13,4623,1,0,'2023-03-31','2023-03-31',5500.00,1,1.00,'Factura B N°: 0002-00005452',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(137,7562,2,40740,40741,13,4623,1,0,'2023-03-31','2023-03-31',15000.00,1,1.00,'Factura B N°: 0002-00005453',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(138,7562,2,40740,40741,13,4623,1,0,'2023-03-31','2023-03-31',12000.00,1,1.00,'Factura B N°: 0002-00005454',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(139,7562,2,40740,40741,13,4623,1,0,'2023-03-31','2023-03-31',8000.00,1,1.00,'Factura B N°: 0002-00005455',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(140,7562,2,40740,40741,13,4623,1,0,'2023-03-31','2023-03-31',15000.00,1,1.00,'Factura B N°: 0002-00005456',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(141,7562,2,40740,40741,13,4623,1,0,'2023-03-31','2023-03-31',10000.00,1,1.00,'Factura B N°: 0002-00005457',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(142,7562,2,40740,40741,13,4623,1,0,'2023-03-31','2023-03-31',10000.00,1,1.00,'Factura B N°: 0002-00005458',NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(143,7562,3,40740,40743,57,4623,2,0,'2023-03-01','2023-03-01',79656.72,1,1.00,'Factura A N°: 0003-00013990',NULL,'2023-04-14 16:20:00','2023-04-14 16:20:00',NULL),(144,7562,3,40740,40743,57,4623,2,0,'2023-03-01','2023-03-01',38231.16,1,1.00,'Factura A N°: 0003-00013989',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL);
INSERT INTO `cta_cte_cliente` VALUES (145,7562,3,40740,40744,57,4623,2,0,'2023-03-02','2023-03-02',9177.76,1,1.00,'Factura A N°: 0020-00004473',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(146,7562,3,40740,40743,57,4623,1,0,'2023-03-02','2023-03-02',5894.39,1,1.00,'Nota de crédito A N°: 0003-00009140',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(147,7562,3,40740,40737,57,4623,2,0,'2023-03-03','2023-03-03',3992.77,1,1.00,'Factura A N°: 0943-01398001',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(148,7562,3,40740,40745,57,4623,2,0,'2023-03-05','2023-03-05',368.72,1,1.00,'Factura A N°: 0022-01010658',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(149,7562,3,40740,40746,57,4623,2,0,'2023-03-14','2023-03-14',10391.73,1,1.00,'Factura A N°: 0001-00002134',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(150,7562,3,40740,40747,57,4623,1,0,'2023-03-14','2023-03-14',94609.90,1,1.00,'Nota de crédito A N°: 0001-00036923',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(151,7562,3,40740,40748,57,4623,2,0,'2023-03-16','2023-03-16',11374.00,1,1.00,'Factura A N°: 0005-00019910',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(152,7562,3,40740,40748,57,4623,2,0,'2023-03-20','2023-03-20',18399.26,1,1.00,'Factura A N°: 0005-00019940',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(153,7562,3,40740,40749,57,4623,2,0,'2023-03-20','2023-03-20',45445.21,1,1.00,'Factura A N°: 0004-00011537',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(154,7562,3,40740,40747,57,4623,2,0,'2023-03-23','2023-03-23',17554.10,1,1.00,'Factura A N°: 0001-00569286',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(155,7562,3,40740,40750,57,4623,2,0,'2023-03-27','2023-03-27',5965.01,1,1.00,'Factura A N°: 0006-00038810',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(156,7562,3,40740,40750,57,4623,2,0,'2023-03-27','2023-03-27',5965.01,1,1.00,'Factura B N°: 0006-00437036',NULL,'2023-04-14 16:20:01','2023-04-14 16:31:14','2023-04-14 16:31:14'),(157,7562,3,40740,40750,57,4623,2,0,'2023-03-27','2023-03-27',4610.00,1,1.00,'Factura B N°: 0006-00437037',NULL,'2023-04-14 16:20:01','2023-04-14 16:31:04','2023-04-14 16:31:04'),(158,7562,3,40740,40751,57,4623,2,0,'2023-03-29','2023-03-29',250000.00,1,1.00,'Factura A N°: 0007-00003309',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(159,7562,3,40740,40748,57,4623,2,0,'2023-03-30','2023-03-30',7710.12,1,1.00,'Factura A N°: 0005-00019968',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(160,7562,3,40740,40752,57,4623,2,0,'2023-03-31','2023-03-31',5940.84,1,1.00,'Factura A N°: 0006-13871512',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(161,7562,3,40740,40747,57,4623,2,0,'2023-03-31','2023-03-31',105366.80,1,1.00,'Factura A N°: 0001-00582642',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(162,7562,3,40740,40753,57,4623,2,0,'2023-03-31','2023-03-31',74304.26,1,1.00,'Factura A N°: 0004-00000230',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(163,7562,3,40740,40747,57,4623,1,0,'2023-03-31','2023-03-31',8777.05,1,1.00,'Nota de crédito A N°: 0001-00038442',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(164,7562,3,40740,40730,57,4623,2,0,'1969-12-31','1969-12-31',9999.96,1,1.00,'Tique Factura A N°: 0225-00033947',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(165,7562,3,40740,40730,57,4623,2,0,'1969-12-31','1969-12-31',4400.05,1,1.00,'Tique Factura A N°: 0225-00034604',NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(166,7562,2,40720,40731,13,1540,1,0,'2023-04-10','2023-04-10',9983.00,1,1.00,'Factura A N°: 0002-00000119',NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(167,7562,2,40720,40754,13,1540,1,0,'2023-04-10','2023-04-10',2760.00,1,1.00,'Factura B N°: 0002-00000433',NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(168,7562,2,40720,40755,13,1540,1,0,'2023-04-10','2023-04-10',8520.02,1,1.00,'Factura B N°: 0002-00000432',NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL);
INSERT INTO `cta_cte_cliente` VALUES (169,7562,2,40720,40735,13,1540,1,0,'2023-04-30','2023-04-30',1707231.10,1,1.00,'Cuenta de Venta y Líquido Producto A N°: 0006-00013035',NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(170,7562,2,40720,40756,13,1540,1,0,'2023-04-10','2023-04-10',2190.00,1,1.00,'Factura B N°: 0002-00000431',NULL,'2023-05-17 11:08:58','2023-05-17 11:08:58',NULL),(171,7562,2,40720,40757,13,1540,1,0,'2023-04-12','2023-04-12',16000.00,1,1.00,'Factura B N°: 0002-00000434',NULL,'2023-05-17 11:08:58','2023-05-17 11:08:58',NULL),(172,7562,3,40720,40736,57,1540,2,0,'2023-04-03','2023-04-03',173932.62,1,1.00,'Factura A N°: 0005-00159457',NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(173,7562,3,40720,40735,57,1540,2,0,'2023-04-03','2023-04-03',26940.78,1,1.00,'Factura A N°: 0005-00049964',NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(174,7562,3,40720,40735,57,1540,2,0,'2023-04-04','2023-04-04',1563.93,1,1.00,'Factura A N°: 0005-00050012',NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(175,7562,3,40720,40719,57,1540,2,0,'2023-04-30','2023-04-30',23000.00,1,1.00,'Factura C N°: 0001-00000100',NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(176,7562,3,40720,40737,57,1540,2,0,'2023-04-09','2023-04-09',9359.60,1,1.00,'Factura A N°: 0948-00939664',NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(177,7562,3,40720,40731,57,1540,2,0,'2023-04-10','2023-04-10',61676.88,1,1.00,'Factura A N°: 0003-00011946',NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(178,7562,3,40720,40735,57,1540,2,0,'2023-04-10','2023-04-10',47576.34,1,1.00,'Factura A N°: 0005-00050078',NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(179,7562,3,40720,40735,57,1540,2,0,'2023-04-18','2023-04-18',15824.38,1,1.00,'Factura A N°: 0005-00050258',NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(180,7562,3,40720,40735,57,1540,2,0,'2023-04-20','2023-04-20',11658.31,1,1.00,'Factura A N°: 0005-00050309',NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(181,7562,3,40720,40735,57,1540,2,0,'2023-04-24','2023-04-24',7082.61,1,1.00,'Factura A N°: 0005-00050417',NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(182,7562,3,40720,40735,57,1540,2,0,'2023-04-25','2023-04-25',45631.30,1,1.00,'Factura A N°: 0005-00050446',NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(183,7562,3,40720,40758,57,1540,2,0,'2023-04-25','2023-04-25',37000.00,1,1.00,'Factura C N°: 0003-00001439',NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(184,7562,3,40720,40735,57,1540,2,0,'2023-04-27','2023-04-27',9265.74,1,1.00,'Factura A N°: 0005-00050504',NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(185,7562,3,40720,40739,57,1540,2,0,'2023-04-30','2023-04-30',10849.96,1,1.00,'Factura A N°: 0002-00039236',NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(186,7562,2,40740,40741,13,4624,1,0,'2023-04-01','2023-04-01',2000.00,1,1.00,'Factura B N°: 0002-00005459',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(187,7562,2,40740,40741,13,4624,1,0,'2023-04-01','2023-04-01',5500.00,1,1.00,'Factura B N°: 0002-00005460',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(188,7562,2,40740,40741,13,4624,1,0,'2023-04-01','2023-04-01',7900.00,1,1.00,'Factura B N°: 0002-00005461',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(189,7562,2,40740,40741,13,4624,1,0,'2023-04-01','2023-04-01',4900.00,1,1.00,'Factura B N°: 0002-00005462',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(190,7562,2,40740,40741,13,4624,1,0,'2023-04-01','2023-04-01',6100.00,1,1.00,'Factura B N°: 0002-00005463',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(191,7562,2,40740,40741,13,4624,1,0,'2023-04-01','2023-04-01',6900.00,1,1.00,'Factura B N°: 0002-00005464',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(192,7562,2,40740,40741,13,4624,1,0,'2023-04-01','2023-04-01',25760.00,1,1.00,'Factura B N°: 0002-00005465',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL);
INSERT INTO `cta_cte_cliente` VALUES (193,7562,2,40740,40741,13,4624,1,0,'2023-04-01','2023-04-01',3200.00,1,1.00,'Factura B N°: 0002-00005466',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(194,7562,2,40740,40741,13,4624,1,0,'2023-04-03','2023-04-03',5520.00,1,1.00,'Factura B N°: 0002-00005467',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(195,7562,2,40740,40741,13,4624,1,0,'2023-04-03','2023-04-03',2000.00,1,1.00,'Factura B N°: 0002-00005468',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(196,7562,2,40740,40741,13,4624,1,0,'2023-04-03','2023-04-03',26450.00,1,1.00,'Factura B N°: 0002-00005469',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(197,7562,2,40740,40741,13,4624,1,0,'2023-04-04','2023-04-04',10800.00,1,1.00,'Factura B N°: 0002-00005470',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(198,7562,2,40740,40741,13,4624,1,0,'2023-04-05','2023-04-05',24900.00,1,1.00,'Factura B N°: 0002-00005471',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(199,7562,2,40740,40741,13,4624,1,0,'2023-04-06','2023-04-06',5000.00,1,1.00,'Factura B N°: 0002-00005472',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(200,7562,2,40740,40741,13,4624,1,0,'2023-04-06','2023-04-06',10000.00,1,1.00,'Factura B N°: 0002-00005473',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(201,7562,2,40740,40741,13,4624,1,0,'2023-04-06','2023-04-06',6900.00,1,1.00,'Factura B N°: 0002-00005474',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(202,7562,2,40740,40741,13,4624,1,0,'2023-04-06','2023-04-06',5000.00,1,1.00,'Factura B N°: 0002-00005475',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(203,7562,2,40740,40741,13,4624,1,0,'2023-04-08','2023-04-08',5250.00,1,1.00,'Factura B N°: 0002-00005476',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(204,7562,2,40740,40741,13,4624,1,0,'2023-04-08','2023-04-08',6800.00,1,1.00,'Factura B N°: 0002-00005477',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(205,7562,2,40740,40741,13,4624,1,0,'2023-04-08','2023-04-08',6800.00,1,1.00,'Factura B N°: 0002-00005478',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(206,7562,2,40740,40741,13,4624,1,0,'2023-04-08','2023-04-08',8900.00,1,1.00,'Factura B N°: 0002-00005479',NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(207,7562,2,40740,40741,13,4624,1,0,'2023-04-08','2023-04-08',9770.00,1,1.00,'Factura B N°: 0002-00005480',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(208,7562,2,40740,40741,13,4624,1,0,'2023-04-08','2023-04-08',5200.00,1,1.00,'Factura B N°: 0002-00005481',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(209,7562,2,40740,40741,13,4624,1,0,'2023-04-08','2023-04-08',5520.00,1,1.00,'Factura B N°: 0002-00005482',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(210,7562,2,40740,40741,13,4624,1,0,'2023-04-10','2023-04-10',6800.00,1,1.00,'Factura B N°: 0002-00005483',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(211,7562,2,40740,40741,13,4624,1,0,'2023-04-10','2023-04-10',8900.00,1,1.00,'Factura B N°: 0002-00005484',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(212,7562,2,40740,40741,13,4624,1,0,'2023-04-10','2023-04-10',9770.00,1,1.00,'Factura B N°: 0002-00005485',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(213,7562,2,40740,40741,13,4624,1,0,'2023-04-10','2023-04-10',3800.00,1,1.00,'Factura B N°: 0002-00005486',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(214,7562,2,40740,40741,13,4624,1,0,'2023-04-10','2023-04-10',5000.00,1,1.00,'Factura B N°: 0002-00005487',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(215,7562,2,40740,40741,13,4624,1,0,'2023-04-11','2023-04-11',3400.00,1,1.00,'Factura B N°: 0002-00005488',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(216,7562,2,40740,40741,13,4624,1,0,'2023-04-11','2023-04-11',11500.00,1,1.00,'Factura B N°: 0002-00005489',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL);
INSERT INTO `cta_cte_cliente` VALUES (217,7562,2,40740,40741,13,4624,1,0,'2023-04-11','2023-04-11',8100.00,1,1.00,'Factura B N°: 0002-00005490',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(218,7562,2,40740,40741,13,4624,1,0,'2023-04-12','2023-04-12',3400.00,1,1.00,'Factura B N°: 0002-00005491',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(219,7562,2,40740,40741,13,4624,1,0,'2023-04-12','2023-04-12',15640.00,1,1.00,'Factura B N°: 0002-00005492',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(220,7562,2,40740,40741,13,4624,1,0,'2023-04-12','2023-04-12',8620.00,1,1.00,'Factura B N°: 0002-00005493',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(221,7562,2,40740,40741,13,4624,1,0,'2023-04-12','2023-04-12',4600.00,1,1.00,'Factura B N°: 0002-00005494',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(222,7562,2,40740,40741,13,4624,1,0,'2023-04-13','2023-04-13',4600.00,1,1.00,'Factura B N°: 0002-00005495',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(223,7562,2,40740,40741,13,4624,1,0,'2023-04-13','2023-04-13',3400.00,1,1.00,'Factura B N°: 0002-00005496',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(224,7562,2,40740,40741,13,4624,1,0,'2023-04-13','2023-04-13',7200.00,1,1.00,'Factura B N°: 0002-00005497',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(225,7562,2,40740,40741,13,4624,1,0,'2023-04-14','2023-04-14',5700.00,1,1.00,'Factura B N°: 0002-00005498',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(226,7562,2,40740,40741,13,4624,1,0,'2023-04-14','2023-04-14',10000.00,1,1.00,'Factura B N°: 0002-00005499',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(227,7562,2,40740,40741,13,4624,1,0,'2023-04-14','2023-04-14',5000.00,1,1.00,'Factura B N°: 0002-00005500',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(228,7562,2,40740,40741,13,4624,1,0,'2023-04-14','2023-04-14',5000.00,1,1.00,'Factura B N°: 0002-00005501',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(229,7562,2,40740,40741,13,4624,1,0,'2023-04-14','2023-04-14',7000.00,1,1.00,'Factura B N°: 0002-00005502',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(230,7562,2,40740,40741,13,4624,1,0,'2023-04-14','2023-04-14',18000.00,1,1.00,'Factura B N°: 0002-00005503',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(231,7562,2,40740,40741,13,4624,1,0,'2023-04-14','2023-04-14',18600.00,1,1.00,'Factura B N°: 0002-00005504',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(232,7562,2,40740,40741,13,4624,1,0,'2023-04-14','2023-04-14',4800.00,1,1.00,'Factura B N°: 0002-00005505',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(233,7562,2,40740,40741,13,4624,1,0,'2023-04-14','2023-04-14',5600.00,1,1.00,'Factura B N°: 0002-00005506',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(234,7562,2,40740,40741,13,4624,1,0,'2023-04-14','2023-04-14',18400.00,1,1.00,'Factura B N°: 0002-00005507',NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(235,7562,2,40740,40741,13,4624,1,0,'2023-04-14','2023-04-14',11500.00,1,1.00,'Factura B N°: 0002-00005508',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(236,7562,2,40740,40741,13,4624,1,0,'2023-04-17','2023-04-17',13800.00,1,1.00,'Factura B N°: 0002-00005509',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(237,7562,2,40740,40741,13,4624,1,0,'2023-04-17','2023-04-17',6780.00,1,1.00,'Factura B N°: 0002-00005510',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(238,7562,2,40740,40741,13,4624,1,0,'2023-04-17','2023-04-17',5290.00,1,1.00,'Factura B N°: 0002-00005511',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(239,7562,2,40740,40741,13,4624,1,0,'2023-04-17','2023-04-17',6780.00,1,1.00,'Factura B N°: 0002-00005512',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(240,7562,2,40740,40741,13,4624,1,0,'2023-04-17','2023-04-17',30600.00,1,1.00,'Factura B N°: 0002-00005513',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL);
INSERT INTO `cta_cte_cliente` VALUES (241,7562,2,40740,40741,13,4624,1,0,'2023-04-17','2023-04-17',10000.00,1,1.00,'Factura B N°: 0002-00005514',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(242,7562,2,40740,40741,13,4624,1,0,'2023-04-18','2023-04-18',5630.00,1,1.00,'Factura B N°: 0002-00005515',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(243,7562,2,40740,40741,13,4624,1,0,'2023-04-18','2023-04-18',3800.00,1,1.00,'Factura B N°: 0002-00005516',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(244,7562,2,40740,40741,13,4624,1,0,'2023-04-18','2023-04-18',15000.00,1,1.00,'Factura B N°: 0002-00005517',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(245,7562,2,40740,40741,13,4624,1,0,'2023-04-19','2023-04-19',6000.00,1,1.00,'Factura B N°: 0002-00005518',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(246,7562,2,40740,40741,13,4624,1,0,'2023-04-19','2023-04-19',8400.00,1,1.00,'Factura B N°: 0002-00005519',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(247,7562,2,40740,40741,13,4624,1,0,'2023-04-19','2023-04-19',6800.00,1,1.00,'Factura B N°: 0002-00005520',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(248,7562,2,40740,40741,13,4624,1,0,'2023-04-20','2023-04-20',4900.00,1,1.00,'Factura B N°: 0002-00005521',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(249,7562,2,40740,40741,13,4624,1,0,'2023-04-22','2023-04-22',5600.00,1,1.00,'Factura B N°: 0002-00005522',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(250,7562,2,40740,40741,13,4624,1,0,'2023-04-22','2023-04-22',24000.00,1,1.00,'Factura B N°: 0002-00005523',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(251,7562,2,40740,40741,13,4624,1,0,'2023-04-22','2023-04-22',5900.00,1,1.00,'Factura B N°: 0002-00005524',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(252,7562,2,40740,40741,13,4624,1,0,'2023-04-22','2023-04-22',3900.00,1,1.00,'Factura B N°: 0002-00005525',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(253,7562,2,40740,40741,13,4624,1,0,'2023-04-22','2023-04-22',7900.00,1,1.00,'Factura B N°: 0002-00005526',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(254,7562,2,40740,40741,13,4624,1,0,'2023-04-22','2023-04-22',6780.00,1,1.00,'Factura B N°: 0002-00005527',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(255,7562,2,40740,40741,13,4624,1,0,'2023-04-22','2023-04-22',12500.00,1,1.00,'Factura B N°: 0002-00005528',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(256,7562,2,40740,40741,13,4624,1,0,'2023-04-22','2023-04-22',9900.00,1,1.00,'Factura B N°: 0002-00005529',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(257,7562,2,40740,40741,13,4624,1,0,'2023-04-22','2023-04-22',5900.00,1,1.00,'Factura B N°: 0002-00005530',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(258,7562,2,40740,40741,13,4624,1,0,'2023-04-22','2023-04-22',6800.00,1,1.00,'Factura B N°: 0002-00005531',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(259,7562,2,40740,40741,13,4624,1,0,'2023-04-22','2023-04-22',5900.00,1,1.00,'Factura B N°: 0002-00005532',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(260,7562,2,40740,40741,13,4624,1,0,'2023-04-22','2023-04-22',5000.00,1,1.00,'Factura B N°: 0002-00005533',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(261,7562,2,40740,40741,13,4624,1,0,'2023-04-24','2023-04-24',11960.00,1,1.00,'Factura B N°: 0002-00005534',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(262,7562,2,40740,40741,13,4624,1,0,'2023-04-24','2023-04-24',5000.00,1,1.00,'Factura B N°: 0002-00005535',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(263,7562,2,40740,40741,13,4624,1,0,'2023-04-24','2023-04-24',14700.00,1,1.00,'Factura B N°: 0002-00005536',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(264,7562,2,40740,40741,13,4624,1,0,'2023-04-24','2023-04-24',7000.00,1,1.00,'Factura B N°: 0002-00005537',NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL);
INSERT INTO `cta_cte_cliente` VALUES (265,7562,2,40740,40741,13,4624,1,0,'2023-04-25','2023-04-25',6780.00,1,1.00,'Factura B N°: 0002-00005538',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(266,7562,2,40740,40741,13,4624,1,0,'2023-04-25','2023-04-25',27600.00,1,1.00,'Factura B N°: 0002-00005539',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(267,7562,2,40740,40741,13,4624,1,0,'2023-04-25','2023-04-25',5980.00,1,1.00,'Factura B N°: 0002-00005540',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(268,7562,2,40740,40741,13,4624,1,0,'2023-04-26','2023-04-26',5630.00,1,1.00,'Factura B N°: 0002-00005541',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(269,7562,2,40740,40741,13,4624,1,0,'2023-04-27','2023-04-27',9770.00,1,1.00,'Factura B N°: 0002-00005542',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(270,7562,2,40740,40741,13,4624,1,0,'2023-04-27','2023-04-27',11300.00,1,1.00,'Factura B N°: 0002-00005543',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(271,7562,2,40740,40741,13,4624,1,0,'2023-04-27','2023-04-27',4000.00,1,1.00,'Factura B N°: 0002-00005544',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(272,7562,2,40740,40741,13,4624,1,0,'2023-04-27','2023-04-27',2000.00,1,1.00,'Factura B N°: 0002-00005545',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(273,7562,2,40740,40741,13,4624,1,0,'2023-04-28','2023-04-28',3900.00,1,1.00,'Factura B N°: 0002-00005546',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(274,7562,2,40740,40741,13,4624,1,0,'2023-04-28','2023-04-28',7900.00,1,1.00,'Factura B N°: 0002-00005547',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(275,7562,2,40740,40741,13,4624,1,0,'2023-04-28','2023-04-28',9000.00,1,1.00,'Factura B N°: 0002-00005548',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(276,7562,2,40740,40741,13,4624,1,0,'2023-04-29','2023-04-29',10000.00,1,1.00,'Factura B N°: 0002-00005549',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(277,7562,2,40740,40741,13,4624,1,0,'2023-04-29','2023-04-29',5280.00,1,1.00,'Factura B N°: 0002-00005550',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(278,7562,2,40740,40741,13,4624,1,0,'2023-04-29','2023-04-29',12000.00,1,1.00,'Factura B N°: 0002-00005551',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(279,7562,2,40740,40741,13,4624,1,0,'2023-04-29','2023-04-29',15830.00,1,1.00,'Factura B N°: 0002-00005552',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(280,7562,2,40740,40741,13,4624,1,0,'2023-04-29','2023-04-29',20000.00,1,1.00,'Factura B N°: 0002-00005553',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(281,7562,2,40740,40741,13,4624,1,0,'2023-04-29','2023-04-29',8000.00,1,1.00,'Factura B N°: 0002-00005554',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(282,7562,2,40740,40741,13,4624,1,0,'2023-04-29','2023-04-29',3500.00,1,1.00,'Factura B N°: 0002-00005555',NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(283,7562,3,40740,40737,57,4624,2,0,'2023-04-03','2023-04-03',3694.84,1,1.00,'Factura A N°: 0943-01434988',NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(284,7562,3,40740,40753,57,4624,2,0,'2023-04-11','2023-04-11',8280.26,1,1.00,'Factura A N°: 0004-00000255',NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(285,7562,3,40740,40753,57,4624,2,0,'2023-04-11','2023-04-11',16560.52,1,1.00,'Factura A N°: 0004-00000248',NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(286,7562,3,40740,40748,57,4624,2,0,'2023-04-13','2023-04-13',4583.48,1,1.00,'Factura A N°: 0005-00019990',NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(287,7562,3,40740,40747,57,4624,2,0,'2023-04-14','2023-04-14',9286.06,1,1.00,'Factura A N°: 0001-00585921',NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(288,7562,3,40740,40748,57,4624,2,0,'2023-04-19','2023-04-19',484.00,1,1.00,'Factura A N°: 0005-00020014',NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL);
INSERT INTO `cta_cte_cliente` VALUES (289,7562,3,40740,40749,57,4624,2,0,'2023-04-24','2023-04-24',33861.20,1,1.00,'Factura A N°: 0004-00011695',NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(290,7562,3,40740,40750,57,4624,2,0,'2023-04-26','2023-04-26',5965.01,1,1.00,'Factura A N°: 0006-00039799',NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(291,7562,3,40740,40748,57,4624,2,0,'2023-04-27','2023-04-27',7637.52,1,1.00,'Factura A N°: 0005-00020039',NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(292,7562,3,40740,40752,57,4624,2,0,'2023-04-30','2023-04-30',6332.94,1,1.00,'Factura A N°: 0006-13993944',NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(293,7562,3,40740,40759,57,4624,2,0,'2023-04-17','2023-04-17',312966.50,1,1.00,'Factura A N°: 0004-00000517',NULL,'2023-05-17 13:33:22','2023-05-17 13:33:22',NULL),(294,7562,3,40721,40760,57,3052,2,0,'2023-04-01','2023-04-01',1000.00,1,1.00,'Factura A N°: 0009-00022298',NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(295,7562,3,40721,40730,57,3052,2,0,'2023-04-01','2023-04-01',4627.61,1,1.00,'Tique Factura A N°: 0225-00034925',NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(296,7562,3,40721,40730,57,3052,2,0,'2023-04-02','2023-04-02',6041.19,1,1.00,'Tique Factura A N°: 0221-00027015',NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(297,7562,3,40721,40730,57,3052,2,0,'2023-04-29','2023-04-29',11187.19,1,1.00,'Tique Factura A N°: 0225-00036948',NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(298,7562,3,40721,40730,57,3052,2,0,'2023-04-03','2023-04-03',10269.53,1,1.00,'Tique Factura A N°: 0225-00035046',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(299,7562,3,40721,40761,57,3052,2,0,'2023-04-04','2023-04-04',170000.00,1,1.00,'Factura A N°: 0006-00015800',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(300,7562,3,40721,40730,57,3052,2,0,'2023-04-04','2023-04-04',3366.09,1,1.00,'Tique Factura A N°: 0225-00035136',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(301,7562,3,40721,40762,57,3052,2,0,'2023-04-08','2023-04-08',33180.21,1,1.00,'Factura A N°: 0005-00002932',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(302,7562,3,40721,40725,57,3052,2,0,'2023-04-08','2023-04-08',12950.00,1,1.00,'Factura A N°: 0011-00000683',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(303,7562,3,40721,40730,57,3052,2,0,'2023-04-08','2023-04-08',14647.67,1,1.00,'Tique Factura A N°: 0225-00035365',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(304,7562,3,40721,40730,57,3052,2,0,'2023-04-08','2023-04-08',5610.14,1,1.00,'Tique Factura A N°: 0225-00035399',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(305,7562,3,40721,40724,57,3052,2,0,'2023-04-11','2023-04-11',10050.01,1,1.00,'Factura A N°: 0009-00008779',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(306,7562,3,40721,40730,57,3052,2,0,'2023-04-13','2023-04-13',2243.93,1,1.00,'Tique Factura A N°: 0225-00035749',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(307,7562,3,40721,40763,57,3052,2,0,'2023-04-14','2023-04-14',15047.73,1,1.00,'Tique Factura A N°: 0021-00011157',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(308,7562,3,40721,40723,57,3052,2,0,'2023-04-15','2023-04-15',2583.92,1,1.00,'Factura A N°: 0013-00003077',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(309,7562,3,40721,40730,57,3052,2,0,'2023-04-15','2023-04-15',2243.93,1,1.00,'Tique Factura A N°: 0225-00035922',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(310,7562,3,40721,40730,57,3052,2,0,'2023-04-16','2023-04-16',4786.27,1,1.00,'Tique Factura A N°: 0225-00035966',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(311,7562,3,40721,40730,57,3052,2,0,'2023-04-17','2023-04-17',5593.56,1,1.00,'Tique Factura A N°: 0226-00020932',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(312,7562,3,40721,40764,57,3052,2,0,'2023-04-18','2023-04-18',3729.49,1,1.00,'Factura A N°: 0076-00027383',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL);
INSERT INTO `cta_cte_cliente` VALUES (313,7562,3,40721,40764,57,3052,1,0,'2023-04-18','2023-04-18',932.37,1,1.00,'Nota de crédito A N°: 0076-00002085',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(314,7562,3,40721,40724,57,3052,2,0,'2023-04-20','2023-04-20',3000.00,1,1.00,'Factura A N°: 0009-00008820',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(315,7562,3,40721,40730,57,3052,2,0,'2023-04-21','2023-04-21',3356.33,1,1.00,'Tique Factura A N°: 0221-00027678',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(316,7562,3,40721,40730,57,3052,2,0,'2023-04-25','2023-04-25',4622.96,1,1.00,'Tique Factura A N°: 0226-00021292',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(317,7562,3,40721,40765,57,3052,2,0,'2023-04-26','2023-04-26',2500.00,1,1.00,'Factura A N°: 0002-00003704',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(318,7562,3,40721,40730,57,3052,2,0,'2023-04-26','2023-04-26',4786.61,1,1.00,'Tique Factura A N°: 0225-00036709',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(319,7562,3,40721,40764,57,3052,2,0,'2023-04-27','2023-04-27',3026.44,1,1.00,'Factura A N°: 0076-00027588',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(320,7562,3,40721,40764,57,3052,1,0,'2023-04-27','2023-04-27',756.61,1,1.00,'Nota de crédito A N°: 0076-00002102',NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(321,7562,2,40740,40741,13,4625,1,0,'2023-05-02','2023-05-02',2800.00,1,1.00,'Factura B N°: 0002-00005556',NULL,'2023-06-12 15:18:11','2023-06-12 15:18:11',NULL),(322,7562,2,40740,40741,13,4625,1,0,'2023-05-02','2023-05-02',12000.00,1,1.00,'Factura B N°: 0002-00005557',NULL,'2023-06-12 15:18:11','2023-06-12 15:18:11',NULL),(323,7562,2,40740,40741,13,4625,1,0,'2023-05-02','2023-05-02',7930.00,1,1.00,'Factura B N°: 0002-00005558',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(324,7562,2,40740,40741,13,4625,1,0,'2023-05-03','2023-05-03',13800.00,1,1.00,'Factura B N°: 0002-00005559',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(325,7562,2,40740,40741,13,4625,1,0,'2023-05-04','2023-05-04',9000.00,1,1.00,'Factura B N°: 0002-00005560',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(326,7562,2,40740,40741,13,4625,1,0,'2023-05-05','2023-05-05',11500.00,1,1.00,'Factura B N°: 0002-00005561',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(327,7562,2,40740,40741,13,4625,1,0,'2023-05-05','2023-05-05',4900.00,1,1.00,'Factura B N°: 0002-00005562',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(328,7562,2,40740,40741,13,4625,1,0,'2023-05-05','2023-05-05',11270.00,1,1.00,'Factura B N°: 0002-00005563',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(329,7562,2,40740,40741,13,4625,1,0,'2023-05-05','2023-05-05',4900.00,1,1.00,'Factura B N°: 0002-00005564',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(330,7562,2,40740,40741,13,4625,1,0,'2023-05-05','2023-05-05',6900.00,1,1.00,'Factura B N°: 0002-00005565',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(331,7562,2,40740,40741,13,4625,1,0,'2023-05-05','2023-05-05',26000.00,1,1.00,'Factura B N°: 0002-00005566',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(332,7562,2,40740,40741,13,4625,1,0,'2023-05-05','2023-05-05',6900.00,1,1.00,'Factura B N°: 0002-00005567',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(333,7562,2,40740,40741,13,4625,1,0,'2023-05-06','2023-05-06',11500.00,1,1.00,'Factura B N°: 0002-00005568',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(334,7562,2,40740,40741,13,4625,1,0,'2023-05-06','2023-05-06',10000.00,1,1.00,'Factura B N°: 0002-00005569',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(335,7562,2,40740,40741,13,4625,1,0,'2023-05-06','2023-05-06',6900.00,1,1.00,'Factura B N°: 0002-00005570',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(336,7562,2,40740,40741,13,4625,1,0,'2023-05-06','2023-05-06',6900.00,1,1.00,'Factura B N°: 0002-00005571',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL);
INSERT INTO `cta_cte_cliente` VALUES (337,7562,2,40740,40741,13,4625,1,0,'2023-05-06','2023-05-06',5750.00,1,1.00,'Factura B N°: 0002-00005572',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(338,7562,2,40740,40741,13,4625,1,0,'2023-05-08','2023-05-08',6900.00,1,1.00,'Factura B N°: 0002-00005573',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(339,7562,2,40740,40741,13,4625,1,0,'2023-05-08','2023-05-08',20700.00,1,1.00,'Factura B N°: 0002-00005574',NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(340,7562,2,40740,40741,13,4625,1,0,'2023-05-10','2023-05-10',7900.00,1,1.00,'Factura B N°: 0002-00005575',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(341,7562,2,40740,40741,13,4625,1,0,'2023-05-10','2023-05-10',7900.00,1,1.00,'Factura B N°: 0002-00005576',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(342,7562,2,40740,40741,13,4625,1,0,'2023-05-10','2023-05-10',3800.00,1,1.00,'Factura B N°: 0002-00005577',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(343,7562,2,40740,40741,13,4625,1,0,'2023-05-10','2023-05-10',13400.00,1,1.00,'Factura B N°: 0002-00005578',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(344,7562,2,40740,40741,13,4625,1,0,'2023-05-10','2023-05-10',8900.00,1,1.00,'Factura B N°: 0002-00005579',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(345,7562,2,40740,40741,13,4625,1,0,'2023-05-10','2023-05-10',7900.00,1,1.00,'Factura B N°: 0002-00005580',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(346,7562,2,40740,40741,13,4625,1,0,'2023-05-11','2023-05-11',3700.00,1,1.00,'Factura B N°: 0002-00005581',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(347,7562,2,40740,40741,13,4625,1,0,'2023-05-11','2023-05-11',3200.00,1,1.00,'Factura B N°: 0002-00005582',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(348,7562,2,40740,40741,13,4625,1,0,'2023-05-13','2023-05-13',6900.00,1,1.00,'Factura B N°: 0002-00005583',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(349,7562,2,40740,40741,13,4625,1,0,'2023-05-13','2023-05-13',8900.00,1,1.00,'Factura B N°: 0002-00005584',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(350,7562,2,40740,40741,13,4625,1,0,'2023-05-13','2023-05-13',12000.00,1,1.00,'Factura B N°: 0002-00005585',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(351,7562,2,40740,40741,13,4625,1,0,'2023-05-13','2023-05-13',10000.00,1,1.00,'Factura B N°: 0002-00005586',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(352,7562,2,40740,40741,13,4625,1,0,'2023-05-13','2023-05-13',6900.00,1,1.00,'Factura B N°: 0002-00005587',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(353,7562,2,40740,40741,13,4625,1,0,'2023-05-13','2023-05-13',8900.00,1,1.00,'Factura B N°: 0002-00005588',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(354,7562,2,40740,40741,13,4625,1,0,'2023-05-13','2023-05-13',8000.00,1,1.00,'Factura B N°: 0002-00005589',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(355,7562,2,40740,40741,13,4625,1,0,'2023-05-15','2023-05-15',5000.00,1,1.00,'Factura B N°: 0002-00005590',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(356,7562,2,40740,40741,13,4625,1,0,'2023-05-15','2023-05-15',7900.00,1,1.00,'Factura B N°: 0002-00005591',NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(357,7562,2,40740,40741,13,4625,1,0,'2023-05-15','2023-05-15',5900.00,1,1.00,'Factura B N°: 0002-00005592',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(358,7562,2,40740,40741,13,4625,1,0,'2023-05-15','2023-05-15',10000.00,1,1.00,'Factura B N°: 0002-00005593',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(359,7562,2,40740,40741,13,4625,1,0,'2023-05-16','2023-05-16',4700.00,1,1.00,'Factura B N°: 0002-00005594',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(360,7562,2,40740,40741,13,4625,1,0,'2023-05-16','2023-05-16',27000.00,1,1.00,'Factura B N°: 0002-00005595',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL);
INSERT INTO `cta_cte_cliente` VALUES (361,7562,2,40740,40741,13,4625,1,0,'2023-05-16','2023-05-16',5800.00,1,1.00,'Factura B N°: 0002-00005596',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(362,7562,2,40740,40741,13,4625,1,0,'2023-05-17','2023-05-17',28750.00,1,1.00,'Factura B N°: 0002-00005597',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(363,7562,2,40740,40741,13,4625,1,0,'2023-05-17','2023-05-17',6500.00,1,1.00,'Factura B N°: 0002-00005598',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(364,7562,2,40740,40741,13,4625,1,0,'2023-05-17','2023-05-17',9900.00,1,1.00,'Factura B N°: 0002-00005599',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(365,7562,2,40740,40741,13,4625,1,0,'2023-05-18','2023-05-18',10000.00,1,1.00,'Factura B N°: 0002-00005600',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(366,7562,2,40740,40741,13,4625,1,0,'2023-05-18','2023-05-18',10000.00,1,1.00,'Factura B N°: 0002-00005601',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(367,7562,2,40740,40741,13,4625,1,0,'2023-05-19','2023-05-19',23040.00,1,1.00,'Factura B N°: 0002-00005602',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(368,7562,2,40740,40741,13,4625,1,0,'2023-05-19','2023-05-19',10000.00,1,1.00,'Factura B N°: 0002-00005603',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(369,7562,2,40740,40741,13,4625,1,0,'2023-05-20','2023-05-20',4000.00,1,1.00,'Factura B N°: 0002-00005604',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(370,7562,2,40740,40741,13,4625,1,0,'2023-05-20','2023-05-20',7900.00,1,1.00,'Factura B N°: 0002-00005605',NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(371,7562,2,40740,40741,13,4625,1,0,'2023-05-20','2023-05-20',5700.00,1,1.00,'Factura B N°: 0002-00005606',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(372,7562,2,40740,40741,13,4625,1,0,'2023-05-20','2023-05-20',19200.00,1,1.00,'Factura B N°: 0002-00005607',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(373,7562,2,40740,40741,13,4625,1,0,'2023-05-20','2023-05-20',7000.00,1,1.00,'Factura B N°: 0002-00005608',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(374,7562,2,40740,40741,13,4625,1,0,'2023-05-22','2023-05-22',6240.00,1,1.00,'Factura B N°: 0002-00005609',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(375,7562,2,40740,40741,13,4625,1,0,'2023-05-22','2023-05-22',5900.00,1,1.00,'Factura B N°: 0002-00005610',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(376,7562,2,40740,40741,13,4625,1,0,'2023-05-22','2023-05-22',44280.00,1,1.00,'Factura B N°: 0002-00005611',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(377,7562,2,40740,40741,13,4625,1,0,'2023-05-22','2023-05-22',6900.00,1,1.00,'Factura B N°: 0002-00005612',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(378,7562,2,40740,40741,13,4625,1,0,'2023-05-22','2023-05-22',10000.00,1,1.00,'Factura B N°: 0002-00005613',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(379,7562,2,40740,40741,13,4625,1,0,'2023-05-22','2023-05-22',9200.00,1,1.00,'Factura B N°: 0002-00005614',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(380,7562,2,40740,40741,13,4625,1,0,'2023-05-22','2023-05-22',9480.00,1,1.00,'Factura B N°: 0002-00005615',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(381,7562,2,40740,40741,13,4625,1,0,'2023-05-24','2023-05-24',13200.00,1,1.00,'Factura B N°: 0002-00005616',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(382,7562,2,40740,40741,13,4625,1,0,'2023-05-24','2023-05-24',4200.00,1,1.00,'Factura B N°: 0002-00005617',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(383,7562,2,40740,40741,13,4625,1,0,'2023-05-24','2023-05-24',15000.00,1,1.00,'Factura B N°: 0002-00005618',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(384,7562,2,40740,40741,13,4625,1,0,'2023-05-27','2023-05-27',36000.00,1,1.00,'Factura B N°: 0002-00005619',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL);
INSERT INTO `cta_cte_cliente` VALUES (385,7562,2,40740,40741,13,4625,1,0,'2023-05-27','2023-05-27',6000.00,1,1.00,'Factura B N°: 0002-00005620',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(386,7562,2,40740,40741,13,4625,1,0,'2023-05-27','2023-05-27',9900.00,1,1.00,'Factura B N°: 0002-00005621',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(387,7562,2,40740,40741,13,4625,1,0,'2023-05-27','2023-05-27',4000.00,1,1.00,'Factura B N°: 0002-00005622',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(388,7562,2,40740,40741,13,4625,1,0,'2023-05-27','2023-05-27',15600.00,1,1.00,'Factura B N°: 0002-00005623',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(389,7562,2,40740,40741,13,4625,1,0,'2023-05-29','2023-05-29',2000.00,1,1.00,'Factura B N°: 0002-00005624',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(390,7562,2,40740,40741,13,4625,1,0,'2023-05-29','2023-05-29',5900.00,1,1.00,'Factura B N°: 0002-00005625',NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(391,7562,2,40740,40741,13,4625,1,0,'2023-05-29','2023-05-29',15600.00,1,1.00,'Factura B N°: 0002-00005626',NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(392,7562,2,40740,40741,13,4625,1,0,'2023-05-29','2023-05-29',7200.00,1,1.00,'Factura B N°: 0002-00005627',NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(393,7562,2,40740,40741,13,4625,1,0,'2023-05-30','2023-05-30',1700.00,1,1.00,'Factura B N°: 0002-00005628',NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(394,7562,2,40740,40741,13,4625,1,0,'2023-05-30','2023-05-30',6500.00,1,1.00,'Factura B N°: 0002-00005629',NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(395,7562,2,40740,40741,13,4625,1,0,'2023-05-31','2023-05-31',5000.00,1,1.00,'Factura B N°: 0002-00005630',NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(396,7562,2,40740,40741,13,4625,1,0,'2023-05-31','2023-05-31',8900.00,1,1.00,'Factura B N°: 0002-00005631',NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(397,7562,3,40740,40767,57,4625,2,0,'2023-05-01','2023-05-01',15900.00,1,1.00,'Factura B N°: 0004-00010063',NULL,'2023-06-12 15:18:46','2023-06-12 15:26:39','2023-06-12 15:26:39'),(398,7562,3,40740,40768,57,4625,2,0,'2023-05-04','2023-05-04',99617.36,1,1.00,'Factura A N°: 0006-00007399',NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(399,7562,3,40740,40745,57,4625,2,0,'2023-05-05','2023-05-05',150.00,1,1.00,'Factura A N°: 0022-01259206',NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(400,7562,3,40740,40746,57,4625,2,0,'2023-05-08','2023-05-08',12696.17,1,1.00,'Factura A N°: 0001-00002942',NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(401,7562,3,40740,40748,57,4625,2,0,'2023-05-09','2023-05-09',5336.10,1,1.00,'Factura A N°: 0005-00020060',NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(402,7562,3,40740,40769,57,4625,2,0,'2023-05-11','2023-05-11',4100.00,1,1.00,'Factura A N°: 0002-00005231',NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(403,7562,3,40740,40753,57,4625,2,0,'2023-05-17','2023-05-17',8992.36,1,1.00,'Factura A N°: 0004-00000364',NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(404,7562,3,40740,40748,57,4625,2,0,'2023-05-18','2023-05-18',14002.12,1,1.00,'Factura A N°: 0005-00020088',NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(405,7562,3,40740,40753,57,4625,2,0,'2023-05-22','2023-05-22',8992.36,1,1.00,'Factura A N°: 0004-00000372',NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(406,7562,3,40740,40748,57,4625,2,0,'2023-05-23','2023-05-23',13036.54,1,1.00,'Factura A N°: 0005-00020118',NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(407,7562,3,40740,40753,57,4625,2,0,'2023-05-23','2023-05-23',26977.07,1,1.00,'Factura A N°: 0004-00000378',NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(408,7562,3,40740,40753,57,4625,2,0,'2023-05-24','2023-05-24',26977.07,1,1.00,'Factura A N°: 0004-00000381',NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL);
INSERT INTO `cta_cte_cliente` VALUES (409,7562,3,40740,40753,57,4625,2,0,'2023-05-27','2023-05-27',26977.07,1,1.00,'Factura A N°: 0004-00000382',NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(410,7562,3,40740,40750,57,4625,2,0,'2023-05-29','2023-05-29',6860.01,1,1.00,'Factura B N°: 0006-00468674',NULL,'2023-06-12 15:18:46','2023-06-12 15:26:21','2023-06-12 15:26:21'),(411,7562,3,40740,40750,57,4625,2,0,'2023-05-29','2023-05-29',5300.00,1,1.00,'Factura B N°: 0006-00468675',NULL,'2023-06-12 15:18:47','2023-06-12 15:26:13','2023-06-12 15:26:13'),(412,7562,3,40740,40750,57,4625,2,0,'2023-05-29','2023-05-29',6860.01,1,1.00,'Factura A N°: 0006-00040789',NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(413,7562,3,40740,40752,57,4625,2,0,'2023-05-31','2023-05-31',6820.57,1,1.00,'Factura A N°: 0006-14191525',NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(414,7562,3,40740,40770,57,4625,2,0,'2023-05-31','2023-05-31',903.76,1,1.00,'Factura M N°: 0020-00061031',NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(415,7562,3,40740,40722,57,4625,2,0,'2023-05-31','2023-05-31',8810.00,1,1.00,'Factura A N°: 0020-00000738',NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(416,7562,3,40740,40730,57,4625,2,0,'2023-05-08','2023-05-08',10000.05,1,1.00,'Factura A N°: 0225-00037618',NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(417,7562,3,40740,40759,57,4625,2,0,'2023-05-08','2023-05-08',80586.00,1,1.00,'Factura A N°: 0004-00000598',NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(418,7562,3,40740,40759,57,4625,2,0,'2023-05-11','2023-05-11',380278.80,1,1.00,'Factura A N°: 0004-00000602',NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(419,7562,3,40740,40759,57,4625,2,0,'2023-05-15','2023-05-15',94089.60,1,1.00,'Factura A N°: 0004-00000621',NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(420,7562,3,40740,40759,57,4625,2,0,'2023-05-18','2023-05-18',219832.80,1,1.00,'Factura A N°: 0004-00000635',NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(421,7562,3,40740,40771,57,4625,2,0,'2023-05-05','2023-05-05',8512.14,1,1.00,'Factura A N°: 0014-00039167',NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(422,7562,3,40720,40735,57,1541,2,0,'2023-05-02','2023-05-02',15063.90,1,1.00,'Factura A N°: 0005-00050570',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(423,7562,3,40720,40736,57,1541,2,0,'2023-05-02','2023-05-02',169382.92,1,1.00,'Factura A N°: 0005-00161257',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(424,7562,3,40720,40772,57,1541,2,0,'2023-05-03','2023-05-03',11500.00,1,1.00,'Factura A N°: 0050-00041037',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(425,7562,3,40720,40739,57,1541,2,0,'2023-05-31','2023-05-31',9158.70,1,1.00,'Factura A N°: 0002-00039987',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(426,7562,3,40720,40735,57,1541,2,0,'2023-05-04','2023-05-04',17251.84,1,1.00,'Factura A N°: 0005-00050646',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(427,7562,3,40720,40735,57,1541,2,0,'2023-05-09','2023-05-09',5260.16,1,1.00,'Factura A N°: 0005-00050709',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(428,7562,3,40720,40737,57,1541,2,0,'2023-05-09','2023-05-09',11419.64,1,1.00,'Factura A N°: 0948-00962445',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(429,7562,3,40720,40735,57,1541,2,0,'2023-05-11','2023-05-11',12573.55,1,1.00,'Factura A N°: 0005-00050778',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(430,7562,3,40720,40731,57,1541,2,0,'2023-05-11','2023-05-11',54263.36,1,1.00,'Factura A N°: 0003-00012143',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(431,7562,3,40720,40735,57,1541,1,0,'2023-05-11','2023-05-11',8770.08,1,1.00,'Nota de crédito A N°: 0005-00003567',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(432,7562,3,40720,40735,57,1541,2,0,'2023-05-12','2023-05-12',14334.60,1,1.00,'Factura A N°: 0005-00050815',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL);
INSERT INTO `cta_cte_cliente` VALUES (433,7562,3,40720,40735,57,1541,2,0,'2023-05-15','2023-05-15',12815.79,1,1.00,'Factura A N°: 0005-00050846',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(434,7562,3,40720,40735,57,1541,2,0,'2023-05-19','2023-05-19',46606.88,1,1.00,'Factura A N°: 0005-00050975',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(435,7562,3,40720,40735,57,1541,2,0,'2023-05-22','2023-05-22',3363.93,1,1.00,'Factura A N°: 0005-00051032',NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(436,7562,3,40720,40735,57,1541,2,0,'2023-05-23','2023-05-23',10769.10,1,1.00,'Factura A N°: 0005-00051061',NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(437,7562,3,40720,40719,57,1541,2,0,'2023-05-23','2023-05-23',25000.00,1,1.00,'Factura C N°: 0001-00000108',NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(438,7562,3,40720,40735,57,1541,2,0,'2023-05-29','2023-05-29',10761.14,1,1.00,'Factura A N°: 0005-00051113',NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(439,7562,3,40720,40735,57,1541,2,0,'2023-05-30','2023-05-30',15080.41,1,1.00,'Factura A N°: 0005-00051128',NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(444,7562,2,40720,40731,13,1541,1,0,'2023-05-04','2023-05-04',5368.00,1,1.00,'Factura A N°: 0002-00000120',NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(445,7562,2,40720,40773,13,1541,1,0,'2023-05-09','2023-05-09',1800.00,1,1.00,'Factura B N°: 0002-00000435',NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(446,7562,2,40720,40757,13,1541,1,0,'2023-05-09','2023-05-09',10000.00,1,1.00,'Factura B N°: 0002-00000436',NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(447,7562,2,40720,40774,13,1541,1,0,'2023-05-12','2023-05-12',5885.00,1,1.00,'Factura B N°: 0002-00000437',NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(448,7562,2,40720,40775,13,1541,1,0,'2023-05-18','2023-05-18',3155.00,1,1.00,'Factura B N°: 0002-00000438',NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(449,7562,2,40720,40735,13,1541,1,0,'2023-05-31','2023-05-31',1834268.50,1,1.00,'Liquidaciones A N°: 0006-00013269',NULL,'2023-06-13 09:11:53','2023-06-13 09:11:53',NULL),(450,7562,3,40721,40724,57,3053,2,0,'2023-05-08','2023-05-08',2200.00,1,1.00,'Factura A N°: 0009-00008880',NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(451,7562,3,40721,40776,57,3053,2,0,'2023-05-09','2023-05-09',5000.00,1,1.00,'Factura C N°: 0002-00000250',NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(452,7562,3,40721,40777,57,3053,2,0,'2023-05-22','2023-05-22',1180.00,1,1.00,'Factura A N°: 0005-00005108',NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(453,7562,3,40721,40725,57,3053,2,0,'2023-05-22','2023-05-22',7260.99,1,1.00,'Factura A N°: 0011-00000773',NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(454,7562,3,40721,40723,57,3053,2,0,'2023-05-24','2023-05-24',802.11,1,1.00,'Factura A N°: 0013-00003246',NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(455,7562,3,40721,40723,57,3053,2,0,'2023-05-24','2023-05-24',220.22,1,1.00,'Factura A N°: 0013-00003247',NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(458,7562,3,40721,40730,57,3053,2,0,'2023-05-05','2023-05-05',3356.17,1,1.00,'Tique Factura A N°: 0221-00027972',NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(459,7562,3,40721,40730,57,3053,2,0,'2023-05-07','2023-05-07',5593.56,1,1.00,'Tique Factura A N°: 0221-00028018',NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(460,7562,3,40721,40730,57,3053,2,0,'2023-05-08','2023-05-08',5593.56,1,1.00,'Tique Factura A N°: 0225-00037632',NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(461,7562,3,40721,40730,57,3053,2,0,'2023-05-09','2023-05-09',7663.02,1,1.00,'Tique Factura A N°: 0225-00037671',NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(462,7562,3,40721,40730,57,3053,2,0,'2023-05-16','2023-05-16',3348.81,1,1.00,'Tique Factura A N°: 0225-00038286',NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL);
INSERT INTO `cta_cte_cliente` VALUES (463,7562,3,40721,40730,57,3053,2,0,'2023-05-19','2023-05-19',4444.31,1,1.00,'Tique Factura A N°: 0226-00022399',NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(464,7562,3,40721,40730,57,3053,2,0,'2023-05-20','2023-05-20',3333.43,1,1.00,'Tique Factura A N°: 0225-00038682',NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(465,7562,3,40721,40730,57,3053,2,0,'2023-05-23','2023-05-23',11111.03,1,1.00,'Tique Factura A N°: 0225-00038891',NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(466,7562,2,40720,40731,13,1542,1,0,'2023-06-01','2023-06-01',10766.00,1,1.00,'Factura A N°: 0002-00000121',NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(467,7562,2,40720,40757,13,1542,1,0,'2023-06-06','2023-06-06',3000.00,1,1.00,'Factura B N°: 0002-00000441',NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(468,7562,2,40720,40779,13,1542,1,0,'2023-06-06','2023-06-06',4800.00,1,1.00,'Factura B N°: 0002-00000439',NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(469,7562,2,40720,40735,13,1542,1,0,'2023-06-30','2023-06-30',1768464.00,1,1.00,'Cuenta de Venta y Líquido Producto A N°: 0006-00013502',NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(470,7562,2,40720,40780,13,1542,1,0,'2023-06-06','2023-06-06',4800.00,1,1.00,'Factura B N°: 0002-00000440',NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(471,7562,3,40720,40736,57,1542,2,0,'2023-06-01','2023-06-01',147054.11,1,1.00,'Factura A N°: 0005-00163057',NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(472,7562,3,40720,40735,57,1542,2,0,'2023-06-05','2023-06-05',10727.52,1,1.00,'Factura A N°: 0005-00051296',NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(473,7562,3,40720,40731,57,1542,2,0,'2023-06-06','2023-06-06',55802.86,1,1.00,'Factura A N°: 0003-00012341',NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(474,7562,3,40720,40719,57,1542,2,0,'2023-06-30','2023-06-30',30000.00,1,1.00,'Factura C N°: 0001-00000128',NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(475,7562,3,40720,40735,57,1542,2,0,'2023-06-06','2023-06-06',9394.44,1,1.00,'Factura A N°: 0005-00051306',NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(476,7562,3,40720,40735,57,1542,2,0,'2023-06-08','2023-06-08',7453.14,1,1.00,'Factura A N°: 0005-00051376',NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(477,7562,3,40720,40737,57,1542,2,0,'2023-06-09','2023-06-09',12063.89,1,1.00,'Factura A N°: 0948-00984849',NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(478,7562,3,40720,40735,57,1542,2,0,'2023-06-13','2023-06-13',24917.06,1,1.00,'Factura A N°: 0005-00051448',NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(479,7562,3,40720,40735,57,1542,2,0,'2023-06-22','2023-06-22',16082.52,1,1.00,'Factura A N°: 0005-00051603',NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(480,7562,3,40720,40735,57,1542,2,0,'2023-06-26','2023-06-26',27798.07,1,1.00,'Factura A N°: 0005-00051683',NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(481,7562,3,40720,40735,57,1542,2,0,'2023-06-27','2023-06-27',23163.39,1,1.00,'Factura A N°: 0005-00051702',NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(482,7562,3,40720,40737,57,1542,1,0,'2023-06-28','2023-06-28',2499.99,1,1.00,'Nota de crédito A N°: 1428-00386841',NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(483,7562,3,40720,40735,57,1542,2,0,'2023-06-29','2023-06-29',34370.62,1,1.00,'Factura A N°: 0005-00051757',NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(484,7562,3,40720,40739,57,1542,2,0,'2023-06-30','2023-06-30',11349.53,1,1.00,'Factura A N°: 0002-00040753',NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(485,7562,2,40740,40741,13,4626,1,0,'2023-06-01','2023-06-01',13440.00,1,1.00,'Factura B N°: 0002-00005632',NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(486,7562,2,40740,40741,13,4626,1,0,'2023-06-01','2023-06-01',12000.00,1,1.00,'Factura B N°: 0002-00005633',NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL);
INSERT INTO `cta_cte_cliente` VALUES (487,7562,2,40740,40741,13,4626,1,0,'2023-06-01','2023-06-01',21600.00,1,1.00,'Factura B N°: 0002-00005634',NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(488,7562,2,40740,40741,13,4626,1,0,'2023-06-02','2023-06-02',11880.00,1,1.00,'Factura B N°: 0002-00005635',NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(489,7562,2,40740,40741,13,4626,1,0,'2023-06-02','2023-06-02',5900.00,1,1.00,'Factura B N°: 0002-00005636',NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(490,7562,2,40740,40741,13,4626,1,0,'2023-06-02','2023-06-02',13000.00,1,1.00,'Factura B N°: 0002-00005637',NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(491,7562,2,40740,40741,13,4626,1,0,'2023-06-02','2023-06-02',6600.00,1,1.00,'Factura B N°: 0002-00005638',NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(492,7562,2,40740,40741,13,4626,1,0,'2023-06-03','2023-06-03',10800.00,1,1.00,'Factura B N°: 0002-00005639',NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(493,7562,2,40740,40741,13,4626,1,0,'2023-06-03','2023-06-03',4300.00,1,1.00,'Factura B N°: 0002-00005640',NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(494,7562,2,40740,40741,13,4626,1,0,'2023-06-03','2023-06-03',24800.00,1,1.00,'Factura B N°: 0002-00005641',NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(495,7562,2,40740,40741,13,4626,1,0,'2023-06-03','2023-06-03',5700.00,1,1.00,'Factura B N°: 0002-00005642',NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(496,7562,2,40740,40741,13,4626,1,0,'2023-06-03','2023-06-03',1200.00,1,1.00,'Factura B N°: 0002-00005643',NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(497,7562,2,40740,40741,13,4626,1,0,'2023-06-03','2023-06-03',10000.00,1,1.00,'Factura B N°: 0002-00005644',NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(498,7562,2,40740,40741,13,4626,1,0,'2023-06-03','2023-06-03',12000.00,1,1.00,'Factura B N°: 0002-00005645',NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(499,7562,2,40740,40741,13,4626,1,0,'2023-06-03','2023-06-03',8900.00,1,1.00,'Factura B N°: 0002-00005646',NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(500,7562,2,40740,40741,13,4626,1,0,'2023-06-06','2023-06-06',14000.00,1,1.00,'Factura B N°: 0002-00005647',NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(501,7562,2,40740,40741,13,4626,1,0,'2023-06-06','2023-06-06',10800.00,1,1.00,'Factura B N°: 0002-00005648',NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(502,7562,2,40740,40741,13,4626,1,0,'2023-06-06','2023-06-06',19200.00,1,1.00,'Factura B N°: 0002-00005649',NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(503,7562,2,40740,40741,13,4626,1,0,'2023-06-07','2023-06-07',19080.00,1,1.00,'Factura B N°: 0002-00005650',NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(504,7562,2,40740,40741,13,4626,1,0,'2023-06-08','2023-06-08',7400.00,1,1.00,'Factura B N°: 0002-00005651',NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(505,7562,2,40740,40741,13,4626,1,0,'2023-06-08','2023-06-08',8900.00,1,1.00,'Factura B N°: 0002-00005652',NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(506,7562,2,40740,40741,13,4626,1,0,'2023-06-08','2023-06-08',8900.00,1,1.00,'Factura B N°: 0002-00005653',NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(507,7562,2,40740,40741,13,4626,1,0,'2023-06-08','2023-06-08',10000.00,1,1.00,'Factura B N°: 0002-00005654',NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(508,7562,2,40740,40741,13,4626,1,0,'2023-06-08','2023-06-08',13800.00,1,1.00,'Factura B N°: 0002-00005655',NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(509,7562,2,40740,40741,13,4626,1,0,'2023-06-08','2023-06-08',5900.00,1,1.00,'Factura B N°: 0002-00005656',NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(510,7562,2,40740,40741,13,4626,1,0,'2023-06-08','2023-06-08',7400.00,1,1.00,'Factura B N°: 0002-00005657',NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL);
INSERT INTO `cta_cte_cliente` VALUES (511,7562,2,40740,40741,13,4626,1,0,'2023-06-08','2023-06-08',10000.00,1,1.00,'Factura B N°: 0002-00005658',NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(512,7562,2,40740,40741,13,4626,1,0,'2023-06-08','2023-06-08',10000.00,1,1.00,'Factura B N°: 0002-00005659',NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(513,7562,2,40740,40741,13,4626,1,0,'2023-06-08','2023-06-08',10000.00,1,1.00,'Factura B N°: 0002-00005660',NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(514,7562,2,40740,40741,13,4626,1,0,'2023-06-08','2023-06-08',5500.00,1,1.00,'Factura B N°: 0002-00005661',NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(515,7562,2,40740,40741,13,4626,1,0,'2023-06-08','2023-06-08',5000.00,1,1.00,'Factura B N°: 0002-00005662',NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(516,7562,2,40740,40741,13,4626,1,0,'2023-06-09','2023-06-09',6900.00,1,1.00,'Factura B N°: 0002-00005663',NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(517,7562,2,40740,40741,13,4626,1,0,'2023-06-09','2023-06-09',9000.00,1,1.00,'Factura B N°: 0002-00005664',NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(518,7562,2,40740,40741,13,4626,1,0,'2023-06-09','2023-06-09',9000.00,1,1.00,'Factura B N°: 0002-00005665',NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(519,7562,2,40740,40741,13,4626,1,0,'2023-06-09','2023-06-09',22600.00,1,1.00,'Factura B N°: 0002-00005666',NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(520,7562,2,40740,40741,13,4626,1,0,'2023-06-09','2023-06-09',11800.00,1,1.00,'Factura B N°: 0002-00005667',NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(521,7562,2,40740,40741,13,4626,1,0,'2023-06-10','2023-06-10',8280.00,1,1.00,'Factura B N°: 0002-00005668',NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(522,7562,2,40740,40741,13,4626,1,0,'2023-06-10','2023-06-10',8280.00,1,1.00,'Factura B N°: 0002-00005669',NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(523,7562,2,40740,40741,13,4626,1,0,'2023-06-10','2023-06-10',6900.00,1,1.00,'Factura B N°: 0002-00005670',NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(524,7562,2,40740,40741,13,4626,1,0,'2023-06-10','2023-06-10',5300.00,1,1.00,'Factura B N°: 0002-00005671',NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(525,7562,2,40740,40741,13,4626,1,0,'2023-06-10','2023-06-10',5000.00,1,1.00,'Factura B N°: 0002-00005672',NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(526,7562,2,40740,40741,13,4626,1,0,'2023-06-10','2023-06-10',9900.00,1,1.00,'Factura B N°: 0002-00005673',NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(527,7562,2,40740,40741,13,4626,1,0,'2023-06-10','2023-06-10',22600.00,1,1.00,'Factura B N°: 0002-00005674',NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(528,7562,2,40740,40741,13,4626,1,0,'2023-06-10','2023-06-10',11800.00,1,1.00,'Factura B N°: 0002-00005675',NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(529,7562,2,40740,40741,13,4626,1,0,'2023-06-12','2023-06-12',7900.00,1,1.00,'Factura B N°: 0002-00005676',NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(530,7562,2,40740,40741,13,4626,1,0,'2023-06-12','2023-06-12',7900.00,1,1.00,'Factura B N°: 0002-00005677',NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(531,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',8900.00,1,1.00,'Factura B N°: 0002-00005678',NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(532,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',8900.00,1,1.00,'Factura B N°: 0002-00005679',NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(533,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',7900.00,1,1.00,'Factura B N°: 0002-00005680',NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(534,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',2000.00,1,1.00,'Factura B N°: 0002-00005681',NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL);
INSERT INTO `cta_cte_cliente` VALUES (535,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',6500.00,1,1.00,'Factura B N°: 0002-00005682',NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(536,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',29880.00,1,1.00,'Factura B N°: 0002-00005683',NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(537,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',16080.00,1,1.00,'Factura B N°: 0002-00005684',NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(538,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',9600.00,1,1.00,'Factura B N°: 0002-00005685',NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(539,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',9000.00,1,1.00,'Factura B N°: 0002-00005686',NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(540,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',7000.00,1,1.00,'Factura B N°: 0002-00005687',NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(541,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',7900.00,1,1.00,'Factura B N°: 0002-00005688',NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(542,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',13800.00,1,1.00,'Factura B N°: 0002-00005689',NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(543,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',6000.00,1,1.00,'Factura B N°: 0002-00005690',NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(544,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',8280.00,1,1.00,'Factura B N°: 0002-00005691',NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(545,7562,2,40740,40741,13,4626,1,0,'2023-06-14','2023-06-14',10800.00,1,1.00,'Factura B N°: 0002-00005692',NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(546,7562,2,40740,40741,13,4626,1,0,'2023-06-15','2023-06-15',13600.00,1,1.00,'Factura B N°: 0002-00005693',NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(547,7562,2,40740,40741,13,4626,1,0,'2023-06-15','2023-06-15',33600.00,1,1.00,'Factura B N°: 0002-00005694',NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(548,7562,2,40740,40741,13,4626,1,0,'2023-06-15','2023-06-15',21600.00,1,1.00,'Factura B N°: 0002-00005695',NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(549,7562,2,40740,40741,13,4626,1,0,'2023-06-15','2023-06-15',2900.00,1,1.00,'Factura B N°: 0002-00005696',NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(550,7562,2,40740,40741,13,4626,1,0,'2023-06-16','2023-06-16',23000.00,1,1.00,'Factura B N°: 0002-00005697',NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(551,7562,2,40740,40741,13,4626,1,0,'2023-06-16','2023-06-16',21600.00,1,1.00,'Factura B N°: 0002-00005698',NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(552,7562,2,40740,40741,13,4626,1,0,'2023-06-16','2023-06-16',7500.00,1,1.00,'Factura B N°: 0002-00005699',NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(553,7562,2,40740,40741,13,4626,1,0,'2023-06-16','2023-06-16',28000.00,1,1.00,'Factura B N°: 0002-00005700',NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(554,7562,2,40740,40741,13,4626,1,0,'2023-06-16','2023-06-16',12000.00,1,1.00,'Factura B N°: 0002-00005701',NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(555,7562,2,40740,40741,13,4626,1,0,'2023-06-16','2023-06-16',1700.00,1,1.00,'Factura B N°: 0002-00005702',NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(556,7562,2,40740,40741,13,4626,1,0,'2023-06-16','2023-06-16',3600.00,1,1.00,'Factura B N°: 0002-00005703',NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(557,7562,2,40740,40741,13,4626,1,0,'2023-06-16','2023-06-16',7900.00,1,1.00,'Factura B N°: 0002-00005704',NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(558,7562,2,40740,40741,13,4626,1,0,'2023-06-16','2023-06-16',32760.00,1,1.00,'Factura B N°: 0002-00005705',NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL);
INSERT INTO `cta_cte_cliente` VALUES (559,7562,2,40740,40741,13,4626,1,0,'2023-06-16','2023-06-16',30000.00,1,1.00,'Factura B N°: 0002-00005706',NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(560,7562,2,40740,40741,13,4626,1,0,'2023-06-16','2023-06-16',10000.00,1,1.00,'Factura B N°: 0002-00005707',NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(561,7562,2,40740,40741,13,4626,1,0,'2023-06-17','2023-06-17',25000.00,1,1.00,'Factura B N°: 0002-00005708',NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(562,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',7200.00,1,1.00,'Factura B N°: 0002-00005709',NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(563,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',13560.00,1,1.00,'Factura B N°: 0002-00005710',NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(564,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',9600.00,1,1.00,'Factura B N°: 0002-00005711',NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(565,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',2300.00,1,1.00,'Factura B N°: 0002-00005712',NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(566,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',2300.00,1,1.00,'Factura B N°: 0002-00005713',NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(567,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',11000.00,1,1.00,'Factura B N°: 0002-00005714',NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(568,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',4900.00,1,1.00,'Factura B N°: 0002-00005715',NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(569,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',10000.00,1,1.00,'Factura B N°: 0002-00005716',NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(570,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',4900.00,1,1.00,'Factura B N°: 0002-00005717',NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(571,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',5500.00,1,1.00,'Factura B N°: 0002-00005718',NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(572,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',7080.00,1,1.00,'Factura B N°: 0002-00005719',NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(573,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',6800.00,1,1.00,'Factura B N°: 0002-00005720',NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(574,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',6900.00,1,1.00,'Factura B N°: 0002-00005721',NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(575,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',30000.00,1,1.00,'Factura B N°: 0002-00005722',NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(576,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',3600.00,1,1.00,'Factura B N°: 0002-00005723',NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(577,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',12000.00,1,1.00,'Factura B N°: 0002-00005724',NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(578,7562,2,40740,40741,13,4626,1,0,'2023-06-21','2023-06-21',4000.00,1,1.00,'Factura B N°: 0002-00005725',NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(579,7562,2,40740,40741,13,4626,1,0,'2023-06-22','2023-06-22',38280.00,1,1.00,'Factura B N°: 0002-00005726',NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(580,7562,2,40740,40741,13,4626,1,0,'2023-06-22','2023-06-22',11280.00,1,1.00,'Factura B N°: 0002-00005727',NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(581,7562,2,40740,40741,13,4626,1,0,'2023-06-22','2023-06-22',12000.00,1,1.00,'Factura B N°: 0002-00005728',NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(582,7562,2,40740,40741,13,4626,1,0,'2023-06-22','2023-06-22',6500.00,1,1.00,'Factura B N°: 0002-00005729',NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL);
INSERT INTO `cta_cte_cliente` VALUES (583,7562,2,40740,40741,13,4626,1,0,'2023-06-23','2023-06-23',12200.00,1,1.00,'Factura B N°: 0002-00005730',NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(584,7562,2,40740,40741,13,4626,1,0,'2023-06-23','2023-06-23',10000.00,1,1.00,'Factura B N°: 0002-00005731',NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(585,7562,2,40740,40741,13,4626,1,0,'2023-06-23','2023-06-23',18800.00,1,1.00,'Factura B N°: 0002-00005732',NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(586,7562,2,40740,40741,13,4626,1,0,'2023-06-23','2023-06-23',10500.00,1,1.00,'Factura B N°: 0002-00005733',NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(587,7562,2,40740,40741,13,4626,1,0,'2023-06-24','2023-06-24',10000.00,1,1.00,'Factura B N°: 0002-00005734',NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(588,7562,2,40740,40741,13,4626,1,0,'2023-06-24','2023-06-24',6900.00,1,1.00,'Factura B N°: 0002-00005735',NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(589,7562,2,40740,40741,13,4626,1,0,'2023-06-24','2023-06-24',4200.00,1,1.00,'Factura B N°: 0002-00005736',NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(590,7562,2,40740,40741,13,4626,1,0,'2023-06-24','2023-06-24',6400.00,1,1.00,'Factura B N°: 0002-00005737',NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(591,7562,2,40740,40741,13,4626,1,0,'2023-06-26','2023-06-26',10000.00,1,1.00,'Factura B N°: 0002-00005738',NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(592,7562,2,40740,40741,13,4626,1,0,'2023-06-26','2023-06-26',9000.00,1,1.00,'Factura B N°: 0002-00005739',NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(593,7562,2,40740,40741,13,4626,1,0,'2023-06-27','2023-06-27',4680.00,1,1.00,'Factura B N°: 0002-00005740',NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(594,7562,2,40740,40741,13,4626,1,0,'2023-06-27','2023-06-27',6500.00,1,1.00,'Factura B N°: 0002-00005741',NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(595,7562,2,40740,40741,13,4626,1,0,'2023-06-27','2023-06-27',10100.00,1,1.00,'Factura B N°: 0002-00005742',NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(596,7562,2,40740,40741,13,4626,1,0,'2023-06-27','2023-06-27',10000.00,1,1.00,'Factura B N°: 0002-00005743',NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(597,7562,2,40740,40741,13,4626,1,0,'2023-06-27','2023-06-27',20000.00,1,1.00,'Factura B N°: 0002-00005744',NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(598,7562,2,40740,40741,13,4626,1,0,'2023-06-27','2023-06-27',15000.00,1,1.00,'Factura B N°: 0002-00005745',NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(599,7562,2,40740,40741,13,4626,1,0,'2023-06-28','2023-06-28',13500.00,1,1.00,'Factura B N°: 0002-00005746',NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(600,7562,2,40740,40741,13,4626,1,0,'2023-06-28','2023-06-28',13500.00,1,1.00,'Factura B N°: 0002-00005747',NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(601,7562,2,40740,40741,13,4626,1,0,'2023-06-28','2023-06-28',6900.00,1,1.00,'Factura B N°: 0002-00005748',NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(602,7562,2,40740,40741,13,4626,1,0,'2023-06-29','2023-06-29',12000.00,1,1.00,'Factura B N°: 0002-00005749',NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(603,7562,2,40740,40741,13,4626,1,0,'2023-06-29','2023-06-29',7900.00,1,1.00,'Factura B N°: 0002-00005750',NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(604,7562,2,40740,40741,13,4626,1,0,'2023-06-30','2023-06-30',6900.00,1,1.00,'Factura B N°: 0002-00005751',NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(605,7562,2,40740,40741,13,4626,1,0,'2023-06-30','2023-06-30',7900.00,1,1.00,'Factura B N°: 0002-00005752',NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(606,7562,2,40740,40741,13,4626,1,0,'2023-06-30','2023-06-30',4900.00,1,1.00,'Factura B N°: 0002-00005753',NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL);
INSERT INTO `cta_cte_cliente` VALUES (607,7562,2,40740,40741,13,4626,1,0,'2023-06-30','2023-06-30',7900.00,1,1.00,'Factura B N°: 0002-00005754',NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(608,7562,2,40740,40741,13,4626,1,0,'2023-06-30','2023-06-30',9900.00,1,1.00,'Factura B N°: 0002-00005755',NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(609,7562,3,40740,40748,57,4626,2,0,'2023-06-01','2023-06-01',6219.40,1,1.00,'Factura A N°: 0005-00020133',NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(610,7562,3,40740,40749,57,4626,2,0,'2023-06-01','2023-06-01',38859.85,1,1.00,'Factura A N°: 0004-00011817',NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(611,7562,3,40740,40722,57,4626,2,0,'2023-06-02','2023-06-02',9250.03,1,1.00,'Factura A N°: 0020-00000749',NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(612,7562,3,40740,40781,57,4626,2,0,'2023-06-05','2023-06-05',158631.00,1,1.00,'Factura A N°: 0002-00004246',NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(613,7562,3,40740,40782,57,4626,2,0,'2023-06-13','2023-06-13',44870.60,1,1.00,'Factura A N°: 0005-00003369',NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(614,7562,3,40740,40783,57,4626,2,0,'2023-06-22','2023-06-22',2657.56,1,1.00,'Factura A N°: 0004-00005576',NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(615,7562,3,40740,40783,57,4626,2,0,'2023-06-22','2023-06-22',288.97,1,1.00,'Factura A N°: 0004-00005577',NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(616,7562,3,40740,40781,57,4626,2,0,'2023-06-26','2023-06-26',141570.00,1,1.00,'Factura A N°: 0002-00004310',NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(617,7562,3,40740,40750,57,4626,2,0,'2023-06-26','2023-06-26',7300.00,1,1.00,'Factura A N°: 0006-00041786',NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(618,7562,3,40740,40748,57,4626,2,0,'2023-06-30','2023-06-30',3872.00,1,1.00,'Factura A N°: 0005-00020208',NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(619,7562,3,40740,40748,57,4626,2,0,'2023-06-30','2023-06-30',4687.54,1,1.00,'Factura A N°: 0005-00020224',NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(620,7562,3,40740,40748,57,4626,2,0,'2023-06-30','2023-06-30',6219.40,1,1.00,'Factura A N°: 0005-00020162',NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(621,7562,3,40740,40748,57,4626,2,0,'2023-06-30','2023-06-30',2831.40,1,1.00,'Factura A N°: 0005-00020182',NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(622,7562,3,40740,40752,57,4626,2,0,'2023-06-30','2023-06-30',0.00,1,1.00,'Factura A N°: 0006-14363592',NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(623,7562,3,40740,40737,57,4626,1,0,'2023-06-25','2023-06-25',161.86,1,1.00,'Nota de crédito A N°: 1144-01309114',NULL,'2023-07-14 10:26:05','2023-07-14 10:31:48','2023-07-14 10:31:48'),(624,7562,3,40740,40737,57,4626,1,0,'2023-06-25','2023-06-25',1.86,1,1.00,'Nota de crédito A N°: 1144-01309115',NULL,'2023-07-14 10:26:05','2023-07-14 10:31:41','2023-07-14 10:31:41'),(625,7562,3,40740,40737,57,4626,1,0,'2023-06-25','2023-06-25',105.34,1,1.00,'Nota de crédito A N°: 1144-01309127',NULL,'2023-07-14 10:26:05','2023-07-14 10:31:35','2023-07-14 10:31:35'),(626,7562,3,40740,40784,57,4626,2,0,'2023-06-06','2023-06-06',45099.99,1,1.00,'Factura B N°: 0003-00002534',NULL,'2023-07-14 10:26:05','2023-07-14 10:28:22','2023-07-14 10:28:22'),(627,7562,3,40740,40785,57,4626,2,0,'2023-06-15','2023-06-15',17750.00,1,1.00,'Factura B N°: 0001-00005564',NULL,'2023-07-14 10:26:05','2023-07-14 10:28:14','2023-07-14 10:28:14'),(628,7562,3,40740,40750,57,4626,2,0,'2023-06-26','2023-06-26',5740.01,1,1.00,'Factura B N°: 0006-00484774',NULL,'2023-07-14 10:26:05','2023-07-14 10:28:04','2023-07-14 10:28:04'),(629,7562,3,40740,40750,57,4626,2,0,'2023-06-26','2023-06-26',7300.00,1,1.00,'Factura B N°: 0006-00484773',NULL,'2023-07-14 10:26:05','2023-07-14 10:27:57','2023-07-14 10:27:57');
INSERT INTO `cta_cte_cliente` VALUES (630,7562,3,40721,40786,57,3054,2,0,'2023-06-01','2023-06-01',43500.04,1,1.00,'Factura A N°: 0003-00000953',NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(631,7562,3,40721,40730,57,3054,2,0,'2023-06-03','2023-06-03',11461.43,1,1.00,'Tique Factura A N°: 0225-00039765',NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(632,7562,3,40721,40730,57,3054,2,0,'2023-06-05','2023-06-05',3331.62,1,1.00,'Tique Factura A N°: 0226-00023346',NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(633,7562,3,40721,40730,57,3054,2,0,'2023-06-27','2023-06-27',3313.17,1,1.00,'Tique Factura A N°: 0225-00041092',NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(634,7562,3,40721,40787,57,3054,2,0,'2023-06-09','2023-06-09',10500.01,1,1.00,'Factura A N°: 0005-00010208',NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(635,7562,3,40721,40726,57,3054,2,0,'2023-06-10','2023-06-10',2450.00,1,1.00,'Factura A N°: 0003-00051900',NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(636,7562,3,40721,40730,57,3054,2,0,'2023-06-10','2023-06-10',13837.47,1,1.00,'Tique Factura A N°: 0225-00040267',NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(637,7562,3,40721,40730,57,3054,2,0,'2023-06-10','2023-06-10',3331.62,1,1.00,'Tique Factura A N°: 0226-00023754',NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(638,7562,3,40721,40723,57,3054,2,0,'2023-06-12','2023-06-12',7855.83,1,1.00,'Factura A N°: 0012-00003255',NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(639,7562,3,40721,40725,57,3054,2,0,'2023-06-15','2023-06-15',7798.45,1,1.00,'Factura A N°: 0011-00000819',NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(640,7562,3,40721,40788,57,3054,2,0,'2023-06-16','2023-06-16',3572.33,1,1.00,'Factura A N°: 0003-00003271',NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(641,7562,3,40721,40730,57,3054,2,0,'2023-06-16','2023-06-16',5726.68,1,1.00,'Tique Factura A N°: 0225-00040552',NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(642,7562,3,40721,40730,57,3054,2,0,'2023-06-18','2023-06-18',15613.08,1,1.00,'Tique Factura A N°: 0225-00040672',NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(643,7562,3,40721,40730,57,3054,2,0,'2023-06-18','2023-06-18',7044.03,1,1.00,'Tique Factura A N°: 0225-00040686',NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(644,7562,3,40721,40730,57,3054,2,0,'2023-06-21','2023-06-21',4430.34,1,1.00,'Tique Factura A N°: 0226-00024617',NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(645,7562,2,40720,40731,13,1543,1,0,'2023-07-03','2023-07-03',5116.00,1,1.00,'Factura A N°: 0002-00000122',NULL,'2023-08-12 09:55:25','2023-08-12 09:55:25',NULL),(646,7562,2,40720,40735,13,1543,1,0,'2023-07-31','2023-07-31',1715329.39,1,1.00,'Cuenta de Venta y Líquido Producto A N°: 0006-00013731',NULL,'2023-08-12 09:55:25','2023-08-12 09:55:25',NULL),(647,7562,3,40720,40736,57,1543,2,0,'2023-07-03','2023-07-03',157865.52,1,1.00,'Factura A N°: 0005-00164855',NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(648,7562,3,40720,40735,57,1543,2,0,'2023-07-04','2023-07-04',16244.73,1,1.00,'Factura A N°: 0005-00051854',NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(649,7562,3,40720,40731,57,1543,2,0,'2023-07-06','2023-07-06',69467.68,1,1.00,'Factura A N°: 0003-00012539',NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(650,7562,3,40720,40735,57,1543,2,0,'2023-07-31','2023-07-31',74402.27,1,1.00,'Factura A N°: 0005-00052439',NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(651,7562,3,40720,40735,57,1543,2,0,'2023-07-06','2023-07-06',19449.44,1,1.00,'Factura A N°: 0005-00051942',NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(652,7562,3,40720,40737,57,1543,2,0,'2023-07-09','2023-07-09',13206.85,1,1.00,'Factura A N°: 0948-01006188',NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(653,7562,3,40720,40735,57,1543,2,0,'2023-07-10','2023-07-10',8644.40,1,1.00,'Factura A N°: 0005-00051986',NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL);
INSERT INTO `cta_cte_cliente` VALUES (654,7562,3,40720,40735,57,1543,2,0,'2023-07-10','2023-07-10',21495.66,1,1.00,'Factura A N°: 0005-00051990',NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(655,7562,3,40720,40735,57,1543,2,0,'2023-07-11','2023-07-11',1957.54,1,1.00,'Factura A N°: 0005-00052016',NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(656,7562,3,40720,40735,57,1543,2,0,'2023-07-17','2023-07-17',5565.82,1,1.00,'Factura A N°: 0005-00052137',NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(657,7562,3,40720,40735,57,1543,2,0,'2023-07-17','2023-07-17',25628.70,1,1.00,'Factura A N°: 0005-00052134',NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(658,7562,3,40720,40735,57,1543,2,0,'2023-07-24','2023-07-24',6961.43,1,1.00,'Factura A N°: 0005-00052311',NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(659,7562,3,40720,40719,57,1543,2,0,'2023-07-24','2023-07-24',30000.00,1,1.00,'Factura C N°: 0001-00000149',NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(660,7562,3,40720,40739,57,1543,2,0,'2023-07-31','2023-07-31',8398.24,1,1.00,'Factura A N°: 0002-00041478',NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(661,7562,3,40721,40730,57,3055,2,0,'2023-07-01','2023-07-01',7044.03,1,1.00,'Tique Factura A N°: 0226-00025668',NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(662,7562,3,40721,40788,57,3055,2,0,'2023-07-05','2023-07-05',1428.92,1,1.00,'Factura A N°: 0003-00003310',NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(663,7562,3,40721,40730,57,3055,2,0,'2023-07-06','2023-07-06',4417.43,1,1.00,'Tique Factura A N°: 0226-00026139',NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(664,7562,3,40721,40789,57,3055,2,0,'2023-07-28','2023-07-28',10680.67,1,1.00,'Factura A N°: 0001-00000020',NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(665,7562,3,40721,40725,57,3055,2,0,'2023-07-07','2023-07-07',7850.04,1,1.00,'Factura A N°: 0011-00000878',NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(666,7562,3,40721,40730,57,3055,2,0,'2023-07-12','2023-07-12',7115.67,1,1.00,'Tique Factura A N°: 0226-00026810',NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(667,7562,3,40721,40730,57,3055,2,0,'2023-07-12','2023-07-12',5499.28,1,1.00,'Tique Factura A N°: 0226-00026852',NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(668,7562,3,40721,40726,57,3055,2,0,'2023-07-13','2023-07-13',4500.00,1,1.00,'Factura A N°: 0003-00052336',NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(669,7562,3,40721,40730,57,3055,2,0,'2023-07-13','2023-07-13',11312.03,1,1.00,'Tique Factura A N°: 0226-00027020',NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(670,7562,3,40721,40724,57,3055,2,0,'2023-07-17','2023-07-17',3000.00,1,1.00,'Factura A N°: 0009-00009144',NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(671,7562,3,40721,40730,57,3055,2,0,'2023-07-20','2023-07-20',5132.24,1,1.00,'Tique Factura A N°: 0226-00027793',NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(672,7562,3,40721,40724,57,3055,2,0,'2023-07-22','2023-07-22',2000.00,1,1.00,'Factura A N°: 0009-00009169',NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(673,7562,3,40721,40726,57,3055,2,0,'2023-07-22','2023-07-22',144699.99,1,1.00,'Factura A N°: 0003-00052452',NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(674,7562,3,40721,40788,57,3055,2,0,'2023-07-26','2023-07-26',89999.99,1,1.00,'Factura A N°: 0003-00003343',NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(675,7562,2,40740,40741,13,4627,1,0,'2023-07-01','2023-07-01',10000.00,1,1.00,'Factura B N°: 0002-00005756',NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(676,7562,2,40740,40741,13,4627,1,0,'2023-07-01','2023-07-01',6900.00,1,1.00,'Factura B N°: 0002-00005757',NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(677,7562,2,40740,40741,13,4627,1,0,'2023-07-01','2023-07-01',31200.00,1,1.00,'Factura B N°: 0002-00005758',NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL);
INSERT INTO `cta_cte_cliente` VALUES (678,7562,2,40740,40741,13,4627,1,0,'2023-07-01','2023-07-01',11000.00,1,1.00,'Factura B N°: 0002-00005759',NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(679,7562,2,40740,40741,13,4627,1,0,'2023-07-01','2023-07-01',14000.00,1,1.00,'Factura B N°: 0002-00005760',NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(680,7562,2,40740,40741,13,4627,1,0,'2023-07-03','2023-07-03',14000.00,1,1.00,'Factura B N°: 0002-00005761',NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(681,7562,2,40740,40741,13,4627,1,0,'2023-07-03','2023-07-03',13000.00,1,1.00,'Factura B N°: 0002-00005762',NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(682,7562,2,40740,40741,13,4627,1,0,'2023-07-03','2023-07-03',14880.00,1,1.00,'Factura B N°: 0002-00005763',NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(683,7562,2,40740,40741,13,4627,1,0,'2023-07-03','2023-07-03',10000.00,1,1.00,'Factura B N°: 0002-00005764',NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(684,7562,2,40740,40741,13,4627,1,0,'2023-07-03','2023-07-03',4200.00,1,1.00,'Factura B N°: 0002-00005765',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(685,7562,2,40740,40741,13,4627,1,0,'2023-07-03','2023-07-03',6900.00,1,1.00,'Factura B N°: 0002-00005766',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(686,7562,2,40740,40741,13,4627,1,0,'2023-07-03','2023-07-03',8000.00,1,1.00,'Factura B N°: 0002-00005767',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(687,7562,2,40740,40741,13,4627,1,0,'2023-07-03','2023-07-03',6900.00,1,1.00,'Factura B N°: 0002-00005768',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(688,7562,2,40740,40741,13,4627,1,0,'2023-07-05','2023-07-05',5200.00,1,1.00,'Factura B N°: 0002-00005769',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(689,7562,2,40740,40741,13,4627,1,0,'2023-07-05','2023-07-05',8000.00,1,1.00,'Factura B N°: 0002-00005770',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(690,7562,2,40740,40741,13,4627,1,0,'2023-07-05','2023-07-05',6900.00,1,1.00,'Factura B N°: 0002-00005771',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(691,7562,2,40740,40741,13,4627,1,0,'2023-07-05','2023-07-05',6900.00,1,1.00,'Factura B N°: 0002-00005772',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(692,7562,2,40740,40741,13,4627,1,0,'2023-07-05','2023-07-05',7900.00,1,1.00,'Factura B N°: 0002-00005773',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(693,7562,2,40740,40741,13,4627,1,0,'2023-07-05','2023-07-05',8900.00,1,1.00,'Factura B N°: 0002-00005774',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(694,7562,2,40740,40741,13,4627,1,0,'2023-07-06','2023-07-06',28900.00,1,1.00,'Factura B N°: 0002-00005775',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(695,7562,2,40740,40741,13,4627,1,0,'2023-07-06','2023-07-06',9000.00,1,1.00,'Factura B N°: 0002-00005776',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(696,7562,2,40740,40741,13,4627,1,0,'2023-07-06','2023-07-06',27000.00,1,1.00,'Factura B N°: 0002-00005777',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(697,7562,2,40740,40741,13,4627,1,0,'2023-07-06','2023-07-06',8900.00,1,1.00,'Factura B N°: 0002-00005778',NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(698,7562,2,40740,40741,13,4627,1,0,'2023-07-06','2023-07-06',20000.00,1,1.00,'Factura B N°: 0002-00005779',NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(699,7562,2,40740,40741,13,4627,1,0,'2023-07-07','2023-07-07',3200.00,1,1.00,'Factura B N°: 0002-00005780',NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(700,7562,2,40740,40741,13,4627,1,0,'2023-07-07','2023-07-07',6000.00,1,1.00,'Factura B N°: 0002-00005781',NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(701,7562,2,40740,40741,13,4627,1,0,'2023-07-07','2023-07-07',6000.00,1,1.00,'Factura B N°: 0002-00005782',NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL);
INSERT INTO `cta_cte_cliente` VALUES (702,7562,2,40740,40741,13,4627,1,0,'2023-07-08','2023-07-08',3900.00,1,1.00,'Factura B N°: 0002-00005783',NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(703,7562,2,40740,40741,13,4627,1,0,'2023-07-08','2023-07-08',15400.00,1,1.00,'Factura B N°: 0002-00005784',NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(704,7562,2,40740,40741,13,4627,1,0,'2023-07-08','2023-07-08',5200.00,1,1.00,'Factura B N°: 0002-00005785',NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(705,7562,2,40740,40741,13,4627,1,0,'2023-07-08','2023-07-08',4800.00,1,1.00,'Factura B N°: 0002-00005786',NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(706,7562,2,40740,40741,13,4627,1,0,'2023-07-08','2023-07-08',4800.00,1,1.00,'Factura B N°: 0002-00005787',NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(707,7562,2,40740,40741,13,4627,1,0,'2023-07-08','2023-07-08',10300.00,1,1.00,'Factura B N°: 0002-00005788',NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(708,7562,2,40740,40741,13,4627,1,0,'2023-07-08','2023-07-08',14000.00,1,1.00,'Factura B N°: 0002-00005789',NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(709,7562,2,40740,40741,13,4627,1,0,'2023-07-08','2023-07-08',5700.00,1,1.00,'Factura B N°: 0002-00005790',NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(710,7562,2,40740,40741,13,4627,1,0,'2023-07-08','2023-07-08',12000.00,1,1.00,'Factura B N°: 0002-00005791',NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(711,7562,2,40740,40741,13,4627,1,0,'2023-07-10','2023-07-10',5300.00,1,1.00,'Factura B N°: 0002-00005792',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(712,7562,2,40740,40741,13,4627,1,0,'2023-07-10','2023-07-10',700.00,1,1.00,'Factura B N°: 0002-00005793',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(713,7562,2,40740,40741,13,4627,1,0,'2023-07-10','2023-07-10',30000.00,1,1.00,'Factura B N°: 0002-00005794',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(714,7562,2,40740,40741,13,4627,1,0,'2023-07-10','2023-07-10',4800.00,1,1.00,'Factura B N°: 0002-00005795',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(715,7562,2,40740,40741,13,4627,1,0,'2023-07-10','2023-07-10',15600.00,1,1.00,'Factura B N°: 0002-00005796',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(716,7562,2,40740,40741,13,4627,1,0,'2023-07-11','2023-07-11',8900.00,1,1.00,'Factura B N°: 0002-00005797',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(717,7562,2,40740,40741,13,4627,1,0,'2023-07-11','2023-07-11',4900.00,1,1.00,'Factura B N°: 0002-00005798',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(718,7562,2,40740,40741,13,4627,1,0,'2023-07-11','2023-07-11',6000.00,1,1.00,'Factura B N°: 0002-00005799',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(719,7562,2,40740,40741,13,4627,1,0,'2023-07-11','2023-07-11',3400.00,1,1.00,'Factura B N°: 0002-00005800',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(720,7562,2,40740,40741,13,4627,1,0,'2023-07-12','2023-07-12',3000.00,1,1.00,'Factura B N°: 0002-00005801',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(721,7562,2,40740,40741,13,4627,1,0,'2023-07-12','2023-07-12',6900.00,1,1.00,'Factura B N°: 0002-00005802',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(722,7562,2,40740,40741,13,4627,1,0,'2023-07-12','2023-07-12',6900.00,1,1.00,'Factura B N°: 0002-00005803',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(723,7562,2,40740,40741,13,4627,1,0,'2023-07-12','2023-07-12',20800.00,1,1.00,'Factura B N°: 0002-00005804',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(724,7562,2,40740,40741,13,4627,1,0,'2023-07-13','2023-07-13',12100.00,1,1.00,'Factura B N°: 0002-00005805',NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(725,7562,2,40740,40741,13,4627,1,0,'2023-07-13','2023-07-13',18400.00,1,1.00,'Factura B N°: 0002-00005806',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL);
INSERT INTO `cta_cte_cliente` VALUES (726,7562,2,40740,40741,13,4627,1,0,'2023-07-14','2023-07-14',15000.00,1,1.00,'Factura B N°: 0002-00005807',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(727,7562,2,40740,40741,13,4627,1,0,'2023-07-14','2023-07-14',21600.00,1,1.00,'Factura B N°: 0002-00005808',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(728,7562,2,40740,40741,13,4627,1,0,'2023-07-14','2023-07-14',4300.00,1,1.00,'Factura B N°: 0002-00005809',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(729,7562,2,40740,40741,13,4627,1,0,'2023-07-14','2023-07-14',6500.00,1,1.00,'Factura B N°: 0002-00005810',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(730,7562,2,40740,40741,13,4627,1,0,'2023-07-14','2023-07-14',17800.00,1,1.00,'Factura B N°: 0002-00005811',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(731,7562,2,40740,40741,13,4627,1,0,'2023-07-15','2023-07-15',9900.00,1,1.00,'Factura B N°: 0002-00005812',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(732,7562,2,40740,40741,13,4627,1,0,'2023-07-15','2023-07-15',3500.00,1,1.00,'Factura B N°: 0002-00005813',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(733,7562,2,40740,40741,13,4627,1,0,'2023-07-15','2023-07-15',10000.00,1,1.00,'Factura B N°: 0002-00005814',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(734,7562,2,40740,40741,13,4627,1,0,'2023-07-15','2023-07-15',22500.00,1,1.00,'Factura B N°: 0002-00005815',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(735,7562,2,40740,40741,13,4627,1,0,'2023-07-15','2023-07-15',3900.00,1,1.00,'Factura B N°: 0002-00005816',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(736,7562,2,40740,40741,13,4627,1,0,'2023-07-17','2023-07-17',5700.00,1,1.00,'Factura B N°: 0002-00005817',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(737,7562,2,40740,40741,13,4627,1,0,'2023-07-17','2023-07-17',8900.00,1,1.00,'Factura B N°: 0002-00005818',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(738,7562,2,40740,40741,13,4627,1,0,'2023-07-17','2023-07-17',4800.00,1,1.00,'Factura B N°: 0002-00005819',NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(739,7562,2,40740,40741,13,4627,1,0,'2023-07-17','2023-07-17',1500.00,1,1.00,'Factura B N°: 0002-00005820',NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(740,7562,2,40740,40741,13,4627,1,0,'2023-07-17','2023-07-17',11400.00,1,1.00,'Factura B N°: 0002-00005821',NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(741,7562,2,40740,40741,13,4627,1,0,'2023-07-17','2023-07-17',12000.00,1,1.00,'Factura B N°: 0002-00005822',NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(742,7562,2,40740,40741,13,4627,1,0,'2023-07-18','2023-07-18',21600.00,1,1.00,'Factura B N°: 0002-00005823',NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(743,7562,2,40740,40741,13,4627,1,0,'2023-07-18','2023-07-18',5000.00,1,1.00,'Factura B N°: 0002-00005824',NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(744,7562,2,40740,40741,13,4627,1,0,'2023-07-18','2023-07-18',10000.00,1,1.00,'Factura B N°: 0002-00005825',NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(745,7562,2,40740,40741,13,4627,1,0,'2023-07-18','2023-07-18',15000.00,1,1.00,'Factura B N°: 0002-00005826',NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(746,7562,2,40740,40741,13,4627,1,0,'2023-07-19','2023-07-19',6900.00,1,1.00,'Factura B N°: 0002-00005827',NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(747,7562,2,40740,40741,13,4627,1,0,'2023-07-19','2023-07-19',6900.00,1,1.00,'Factura B N°: 0002-00005828',NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(748,7562,2,40740,40741,13,4627,1,0,'2023-07-19','2023-07-19',12000.00,1,1.00,'Factura B N°: 0002-00005829',NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(749,7562,2,40740,40741,13,4627,1,0,'2023-07-19','2023-07-19',15400.00,1,1.00,'Factura B N°: 0002-00005830',NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL);
INSERT INTO `cta_cte_cliente` VALUES (750,7562,2,40740,40741,13,4627,1,0,'2023-07-20','2023-07-20',10000.00,1,1.00,'Factura B N°: 0002-00005831',NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(751,7562,2,40740,40741,13,4627,1,0,'2023-07-20','2023-07-20',15000.00,1,1.00,'Factura B N°: 0002-00005832',NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(752,7562,2,40740,40741,13,4627,1,0,'2023-07-20','2023-07-20',15000.00,1,1.00,'Factura B N°: 0002-00005833',NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(753,7562,2,40740,40741,13,4627,1,0,'2023-07-20','2023-07-20',50000.00,1,1.00,'Factura B N°: 0002-00005834',NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(754,7562,2,40740,40741,13,4627,1,0,'2023-07-20','2023-07-20',6000.00,1,1.00,'Factura B N°: 0002-00005835',NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(755,7562,2,40740,40741,13,4627,1,0,'2023-07-21','2023-07-21',1600.00,1,1.00,'Factura B N°: 0002-00005836',NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(756,7562,2,40740,40741,13,4627,1,0,'2023-07-21','2023-07-21',7800.00,1,1.00,'Factura B N°: 0002-00005837',NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(757,7562,2,40740,40741,13,4627,1,0,'2023-07-21','2023-07-21',8000.00,1,1.00,'Factura B N°: 0002-00005838',NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(758,7562,2,40740,40741,13,4627,1,0,'2023-07-21','2023-07-21',9000.00,1,1.00,'Factura B N°: 0002-00005839',NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(759,7562,2,40740,40741,13,4627,1,0,'2023-07-22','2023-07-22',20000.00,1,1.00,'Factura B N°: 0002-00005840',NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(760,7562,2,40740,40741,13,4627,1,0,'2023-07-22','2023-07-22',23000.00,1,1.00,'Factura B N°: 0002-00005841',NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(761,7562,2,40740,40741,13,4627,1,0,'2023-07-22','2023-07-22',9600.00,1,1.00,'Factura B N°: 0002-00005842',NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(762,7562,2,40740,40741,13,4627,1,0,'2023-07-24','2023-07-24',15000.00,1,1.00,'Factura B N°: 0002-00005843',NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(763,7562,2,40740,40741,13,4627,1,0,'2023-07-24','2023-07-24',15525.00,1,1.00,'Factura B N°: 0002-00005844',NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(764,7562,2,40740,40741,13,4627,1,0,'2023-07-26','2023-07-26',12960.00,1,1.00,'Factura B N°: 0002-00005845',NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(765,7562,2,40740,40741,13,4627,1,0,'2023-07-26','2023-07-26',15300.00,1,1.00,'Factura B N°: 0002-00005846',NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(766,7562,2,40740,40741,13,4627,1,0,'2023-07-26','2023-07-26',5900.00,1,1.00,'Factura B N°: 0002-00005847',NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(767,7562,2,40740,40741,13,4627,1,0,'2023-07-26','2023-07-26',10000.00,1,1.00,'Factura B N°: 0002-00005848',NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(768,7562,2,40740,40741,13,4627,1,0,'2023-07-27','2023-07-27',5900.00,1,1.00,'Factura B N°: 0002-00005849',NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(769,7562,2,40740,40741,13,4627,1,0,'2023-07-27','2023-07-27',8280.00,1,1.00,'Factura B N°: 0002-00005850',NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(770,7562,2,40740,40741,13,4627,1,0,'2023-07-27','2023-07-27',4320.00,1,1.00,'Factura B N°: 0002-00005851',NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(771,7562,2,40740,40741,13,4627,1,0,'2023-07-27','2023-07-27',10000.00,1,1.00,'Factura B N°: 0002-00005852',NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(772,7562,2,40740,40741,13,4627,1,0,'2023-07-28','2023-07-28',5900.00,1,1.00,'Factura B N°: 0002-00005853',NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(773,7562,2,40740,40741,13,4627,1,0,'2023-07-28','2023-07-28',5100.00,1,1.00,'Factura B N°: 0002-00005854',NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL);
INSERT INTO `cta_cte_cliente` VALUES (774,7562,2,40740,40792,13,4627,1,0,'2023-07-28','2023-07-28',5200.00,1,1.00,'Factura B N°: 0002-00005855',NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(775,7562,2,40740,40741,13,4627,1,0,'2023-07-29','2023-07-29',10000.00,1,1.00,'Factura B N°: 0002-00005856',NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(776,7562,2,40740,40741,13,4627,1,0,'2023-07-29','2023-07-29',4000.00,1,1.00,'Factura B N°: 0002-00005857',NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(777,7562,2,40740,40741,13,4627,1,0,'2023-07-29','2023-07-29',11880.00,1,1.00,'Factura B N°: 0002-00005858',NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(778,7562,2,40740,40741,13,4627,1,0,'2023-07-29','2023-07-29',6000.00,1,1.00,'Factura B N°: 0002-00005859',NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(779,7562,2,40740,40741,13,4627,1,0,'2023-07-29','2023-07-29',10000.00,1,1.00,'Factura B N°: 0002-00005860',NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(780,7562,2,40740,40741,13,4627,1,0,'2023-07-29','2023-07-29',15000.00,1,1.00,'Factura B N°: 0002-00005861',NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(781,7562,2,40740,40741,13,4627,1,0,'2023-07-29','2023-07-29',10000.00,1,1.00,'Factura B N°: 0002-00005862',NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(782,7562,2,40740,40741,13,4627,1,0,'2023-07-29','2023-07-29',5000.00,1,1.00,'Factura B N°: 0002-00005863',NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(783,7562,2,40740,40741,13,4627,1,0,'2023-07-31','2023-07-31',12000.00,1,1.00,'Factura B N°: 0002-00005864',NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(784,7562,2,40740,40741,13,4627,1,0,'2023-07-31','2023-07-31',10000.00,1,1.00,'Factura B N°: 0002-00005865',NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(785,7562,2,40740,40741,13,4627,1,0,'2023-07-31','2023-07-31',15000.00,1,1.00,'Factura B N°: 0002-00005866',NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(786,7562,3,40740,40730,57,4627,2,0,'2023-07-07','2023-07-07',27034.35,1,1.00,'Tique Factura A N°: 0226-00026310',NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(787,7562,3,40740,40793,57,4627,2,0,'2023-07-14','2023-07-14',49101.80,1,1.00,'Factura A N°: 0002-00003300',NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(788,7562,3,40740,40748,57,4627,2,0,'2023-07-31','2023-07-31',15010.05,1,1.00,'Factura A N°: 0005-00020252',NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(789,7562,3,40740,40745,57,4627,1,0,'2023-07-14','2023-07-14',194.00,1,1.00,'Nota de crédito A N°: 0022-00053308',NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(790,7562,3,40740,40745,57,4627,2,0,'2023-07-16','2023-07-16',194.00,1,1.00,'Factura A N°: 0022-01441444',NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(791,7562,3,40740,40745,57,4627,2,0,'2023-07-16','2023-07-16',194.00,1,1.00,'Factura A N°: 0022-01440519',NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(792,7562,3,40740,40781,57,4627,1,0,'2023-07-20','2023-07-20',141570.00,1,1.00,'Nota de crédito A N°: 0002-00000118',NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(793,7562,3,40740,40750,57,4627,2,0,'2023-07-26','2023-07-26',7920.03,1,1.00,'Factura A N°: 0006-00043259',NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(794,7562,3,40740,40752,57,4627,2,0,'2023-07-31','2023-07-31',7970.19,1,1.00,'Factura A N°: 0006-14495693',NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(795,7562,3,40740,40748,57,4627,2,0,'2023-07-31','2023-07-31',12044.34,1,1.00,'Factura A N°: 0005-00020279',NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(796,7562,3,40740,40748,57,4627,2,0,'2023-07-31','2023-07-31',11144.10,1,1.00,'Factura A N°: 0005-00020303',NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(797,7562,3,40740,40748,57,4627,2,0,'2023-07-31','2023-07-31',16313.22,1,1.00,'Factura A N°: 0005-00020325',NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL);
INSERT INTO `cta_cte_cliente` VALUES (798,7562,3,40740,40748,57,4627,2,0,'2023-07-31','2023-07-31',10877.90,1,1.00,'Factura A N°: 0005-00020348',NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(799,7562,3,40740,40730,57,4627,2,0,'2023-07-26','2023-07-26',13402.01,1,1.00,'Factura A N°: 0226-00028382',NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(800,7562,3,40740,40795,57,4627,2,0,'2023-03-02','2023-03-02',33690.01,1,1.00,'Factura A N°: 0004-00069182',NULL,'2023-08-12 12:39:56','2023-08-12 12:39:56',NULL),(801,7562,3,40740,40730,57,4627,2,0,'2023-03-02','2023-03-02',10501.42,1,1.00,'Tique Factura A N°: 0226-00019287',NULL,'2023-08-12 12:41:04','2023-08-12 12:41:04',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(11) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=802 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1,7562,1,1,NULL,'2023-04-11 19:52:55','2023-04-11 19:52:55',NULL),(2,7562,2,2,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(3,7562,3,3,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(4,7562,4,4,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(5,7562,5,5,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(6,7562,6,6,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(7,7562,7,7,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(8,7562,8,8,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(9,7562,9,9,NULL,'2023-04-11 19:52:56','2023-04-11 19:52:56',NULL),(10,7562,10,10,NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(11,7562,11,11,NULL,'2023-04-11 19:55:29','2023-04-11 19:55:29',NULL),(12,7562,12,12,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(13,7562,13,13,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(14,7562,14,14,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(15,7562,15,15,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(16,7562,16,16,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(17,7562,17,17,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(18,7562,18,18,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(19,7562,19,19,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(20,7562,20,20,NULL,'2023-04-11 19:55:30','2023-04-11 19:55:30',NULL),(21,7562,21,21,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(22,7562,22,22,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(23,7562,23,23,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(24,7562,24,24,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(25,7562,25,25,NULL,'2023-04-14 11:52:25','2023-04-14 11:52:25',NULL),(26,7562,26,26,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(27,7562,27,27,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(28,7562,28,28,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(29,7562,29,29,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(30,7562,30,30,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(31,7562,31,31,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(32,7562,32,32,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(33,7562,33,33,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(34,7562,34,34,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(35,7562,35,35,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(36,7562,36,36,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(37,7562,37,37,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(38,7562,38,38,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(39,7562,39,39,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(40,7562,40,40,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(41,7562,41,41,NULL,'2023-04-14 11:52:35','2023-04-14 11:52:35',NULL),(42,7562,42,42,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(43,7562,43,43,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(44,7562,44,44,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(45,7562,45,45,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(46,7562,46,46,NULL,'2023-04-14 16:12:17','2023-04-14 16:12:17',NULL),(47,7562,47,47,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(48,7562,48,48,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(49,7562,49,49,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(50,7562,50,50,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(51,7562,51,51,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(52,7562,52,52,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(53,7562,53,53,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(54,7562,54,54,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(55,7562,55,55,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(56,7562,56,56,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(57,7562,57,57,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (58,7562,58,58,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(59,7562,59,59,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(60,7562,60,60,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(61,7562,61,61,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(62,7562,62,62,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(63,7562,63,63,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(64,7562,64,64,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(65,7562,65,65,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(66,7562,66,66,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(67,7562,67,67,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(68,7562,68,68,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(69,7562,69,69,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(70,7562,70,70,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(71,7562,71,71,NULL,'2023-04-14 16:12:18','2023-04-14 16:12:18',NULL),(72,7562,72,72,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(73,7562,73,73,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(74,7562,74,74,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(75,7562,75,75,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(76,7562,76,76,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(77,7562,77,77,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(78,7562,78,78,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(79,7562,79,79,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(80,7562,80,80,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(81,7562,81,81,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(82,7562,82,82,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(83,7562,83,83,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(84,7562,84,84,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(85,7562,85,85,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(86,7562,86,86,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(87,7562,87,87,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(88,7562,88,88,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(89,7562,89,89,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(90,7562,90,90,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(91,7562,91,91,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(92,7562,92,92,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(93,7562,93,93,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(94,7562,94,94,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(95,7562,95,95,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(96,7562,96,96,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(97,7562,97,97,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(98,7562,98,98,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(99,7562,99,99,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(100,7562,100,100,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(101,7562,101,101,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(102,7562,102,102,NULL,'2023-04-14 16:12:19','2023-04-14 16:12:19',NULL),(103,7562,103,103,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(104,7562,104,104,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(105,7562,105,105,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(106,7562,106,106,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(107,7562,107,107,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(108,7562,108,108,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(109,7562,109,109,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(110,7562,110,110,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(111,7562,111,111,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(112,7562,112,112,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(113,7562,113,113,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (114,7562,114,114,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(115,7562,115,115,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(116,7562,116,116,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(117,7562,117,117,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(118,7562,118,118,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(119,7562,119,119,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(120,7562,120,120,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(121,7562,121,121,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(122,7562,122,122,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(123,7562,123,123,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(124,7562,124,124,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(125,7562,125,125,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(126,7562,126,126,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(127,7562,127,127,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(128,7562,128,128,NULL,'2023-04-14 16:12:20','2023-04-14 16:12:20',NULL),(129,7562,129,129,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(130,7562,130,130,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(131,7562,131,131,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(132,7562,132,132,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(133,7562,133,133,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(134,7562,134,134,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(135,7562,135,135,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(136,7562,136,136,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(137,7562,137,137,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(138,7562,138,138,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(139,7562,139,139,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(140,7562,140,140,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(141,7562,141,141,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(142,7562,142,142,NULL,'2023-04-14 16:12:21','2023-04-14 16:12:21',NULL),(143,7562,143,143,NULL,'2023-04-14 16:20:00','2023-04-14 16:20:00',NULL),(144,7562,144,144,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(145,7562,145,145,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(146,7562,146,146,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(147,7562,147,147,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(148,7562,148,148,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(149,7562,149,149,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(150,7562,150,150,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(151,7562,151,151,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(152,7562,152,152,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(153,7562,153,153,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(154,7562,154,154,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(155,7562,155,155,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(156,7562,156,156,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(157,7562,157,157,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(158,7562,158,158,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(159,7562,159,159,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(160,7562,160,160,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(161,7562,161,161,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(162,7562,162,162,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(163,7562,163,163,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(164,7562,164,164,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(165,7562,165,165,NULL,'2023-04-14 16:20:01','2023-04-14 16:20:01',NULL),(166,7562,166,166,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(167,7562,167,167,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (168,7562,168,168,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(169,7562,169,169,NULL,'2023-05-17 11:08:57','2023-05-17 11:08:57',NULL),(170,7562,170,170,NULL,'2023-05-17 11:08:58','2023-05-17 11:08:58',NULL),(171,7562,171,171,NULL,'2023-05-17 11:08:58','2023-05-17 11:08:58',NULL),(172,7562,172,172,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(173,7562,173,173,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(174,7562,174,174,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(175,7562,175,175,NULL,'2023-05-17 11:09:07','2023-05-17 11:09:07',NULL),(176,7562,176,176,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(177,7562,177,177,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(178,7562,178,178,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(179,7562,179,179,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(180,7562,180,180,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(181,7562,181,181,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(182,7562,182,182,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(183,7562,183,183,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(184,7562,184,184,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(185,7562,185,185,NULL,'2023-05-17 11:09:08','2023-05-17 11:09:08',NULL),(186,7562,186,186,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(187,7562,187,187,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(188,7562,188,188,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(189,7562,189,189,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(190,7562,190,190,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(191,7562,191,191,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(192,7562,192,192,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(193,7562,193,193,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(194,7562,194,194,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(195,7562,195,195,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(196,7562,196,196,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(197,7562,197,197,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(198,7562,198,198,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(199,7562,199,199,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(200,7562,200,200,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(201,7562,201,201,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(202,7562,202,202,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(203,7562,203,203,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(204,7562,204,204,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(205,7562,205,205,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(206,7562,206,206,NULL,'2023-05-17 13:24:39','2023-05-17 13:24:39',NULL),(207,7562,207,207,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(208,7562,208,208,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(209,7562,209,209,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(210,7562,210,210,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(211,7562,211,211,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(212,7562,212,212,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(213,7562,213,213,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(214,7562,214,214,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(215,7562,215,215,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(216,7562,216,216,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(217,7562,217,217,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(218,7562,218,218,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(219,7562,219,219,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(220,7562,220,220,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(221,7562,221,221,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (222,7562,222,222,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(223,7562,223,223,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(224,7562,224,224,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(225,7562,225,225,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(226,7562,226,226,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(227,7562,227,227,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(228,7562,228,228,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(229,7562,229,229,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(230,7562,230,230,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(231,7562,231,231,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(232,7562,232,232,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(233,7562,233,233,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(234,7562,234,234,NULL,'2023-05-17 13:24:40','2023-05-17 13:24:40',NULL),(235,7562,235,235,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(236,7562,236,236,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(237,7562,237,237,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(238,7562,238,238,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(239,7562,239,239,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(240,7562,240,240,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(241,7562,241,241,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(242,7562,242,242,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(243,7562,243,243,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(244,7562,244,244,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(245,7562,245,245,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(246,7562,246,246,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(247,7562,247,247,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(248,7562,248,248,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(249,7562,249,249,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(250,7562,250,250,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(251,7562,251,251,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(252,7562,252,252,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(253,7562,253,253,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(254,7562,254,254,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(255,7562,255,255,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(256,7562,256,256,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(257,7562,257,257,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(258,7562,258,258,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(259,7562,259,259,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(260,7562,260,260,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(261,7562,261,261,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(262,7562,262,262,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(263,7562,263,263,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(264,7562,264,264,NULL,'2023-05-17 13:24:41','2023-05-17 13:24:41',NULL),(265,7562,265,265,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(266,7562,266,266,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(267,7562,267,267,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(268,7562,268,268,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(269,7562,269,269,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(270,7562,270,270,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(271,7562,271,271,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(272,7562,272,272,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(273,7562,273,273,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(274,7562,274,274,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(275,7562,275,275,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (276,7562,276,276,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(277,7562,277,277,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(278,7562,278,278,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(279,7562,279,279,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(280,7562,280,280,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(281,7562,281,281,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(282,7562,282,282,NULL,'2023-05-17 13:24:42','2023-05-17 13:24:42',NULL),(283,7562,283,283,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(284,7562,284,284,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(285,7562,285,285,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(286,7562,286,286,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(287,7562,287,287,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(288,7562,288,288,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(289,7562,289,289,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(290,7562,290,290,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(291,7562,291,291,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(292,7562,292,292,NULL,'2023-05-17 13:29:36','2023-05-17 13:29:36',NULL),(293,7562,293,293,NULL,'2023-05-17 13:33:22','2023-05-17 13:33:22',NULL),(294,7562,294,294,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(295,7562,295,295,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(296,7562,296,296,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(297,7562,297,297,NULL,'2023-05-17 15:15:25','2023-05-17 15:15:25',NULL),(298,7562,298,298,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(299,7562,299,299,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(300,7562,300,300,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(301,7562,301,301,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(302,7562,302,302,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(303,7562,303,303,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(304,7562,304,304,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(305,7562,305,305,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(306,7562,306,306,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(307,7562,307,307,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(308,7562,308,308,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(309,7562,309,309,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(310,7562,310,310,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(311,7562,311,311,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(312,7562,312,312,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(313,7562,313,313,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(314,7562,314,314,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(315,7562,315,315,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(316,7562,316,316,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(317,7562,317,317,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(318,7562,318,318,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(319,7562,319,319,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(320,7562,320,320,NULL,'2023-05-17 15:15:26','2023-05-17 15:15:26',NULL),(321,7562,321,321,NULL,'2023-06-12 15:18:11','2023-06-12 15:18:11',NULL),(322,7562,322,322,NULL,'2023-06-12 15:18:11','2023-06-12 15:18:11',NULL),(323,7562,323,323,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(324,7562,324,324,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(325,7562,325,325,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(326,7562,326,326,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(327,7562,327,327,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(328,7562,328,328,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(329,7562,329,329,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (330,7562,330,330,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(331,7562,331,331,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(332,7562,332,332,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(333,7562,333,333,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(334,7562,334,334,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(335,7562,335,335,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(336,7562,336,336,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(337,7562,337,337,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(338,7562,338,338,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(339,7562,339,339,NULL,'2023-06-12 15:18:12','2023-06-12 15:18:12',NULL),(340,7562,340,340,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(341,7562,341,341,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(342,7562,342,342,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(343,7562,343,343,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(344,7562,344,344,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(345,7562,345,345,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(346,7562,346,346,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(347,7562,347,347,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(348,7562,348,348,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(349,7562,349,349,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(350,7562,350,350,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(351,7562,351,351,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(352,7562,352,352,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(353,7562,353,353,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(354,7562,354,354,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(355,7562,355,355,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(356,7562,356,356,NULL,'2023-06-12 15:18:13','2023-06-12 15:18:13',NULL),(357,7562,357,357,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(358,7562,358,358,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(359,7562,359,359,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(360,7562,360,360,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(361,7562,361,361,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(362,7562,362,362,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(363,7562,363,363,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(364,7562,364,364,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(365,7562,365,365,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(366,7562,366,366,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(367,7562,367,367,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(368,7562,368,368,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(369,7562,369,369,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(370,7562,370,370,NULL,'2023-06-12 15:18:14','2023-06-12 15:18:14',NULL),(371,7562,371,371,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(372,7562,372,372,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(373,7562,373,373,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(374,7562,374,374,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(375,7562,375,375,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(376,7562,376,376,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(377,7562,377,377,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(378,7562,378,378,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(379,7562,379,379,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(380,7562,380,380,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(381,7562,381,381,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(382,7562,382,382,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(383,7562,383,383,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (384,7562,384,384,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(385,7562,385,385,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(386,7562,386,386,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(387,7562,387,387,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(388,7562,388,388,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(389,7562,389,389,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(390,7562,390,390,NULL,'2023-06-12 15:18:15','2023-06-12 15:18:15',NULL),(391,7562,391,391,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(392,7562,392,392,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(393,7562,393,393,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(394,7562,394,394,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(395,7562,395,395,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(396,7562,396,396,NULL,'2023-06-12 15:18:16','2023-06-12 15:18:16',NULL),(397,7562,397,397,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(398,7562,398,398,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(399,7562,399,399,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(400,7562,400,400,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(401,7562,401,401,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(402,7562,402,402,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(403,7562,403,403,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(404,7562,404,404,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(405,7562,405,405,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(406,7562,406,406,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(407,7562,407,407,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(408,7562,408,408,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(409,7562,409,409,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(410,7562,410,410,NULL,'2023-06-12 15:18:46','2023-06-12 15:18:46',NULL),(411,7562,411,411,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(412,7562,412,412,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(413,7562,413,413,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(414,7562,414,414,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(415,7562,415,415,NULL,'2023-06-12 15:18:47','2023-06-12 15:18:47',NULL),(416,7562,416,416,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(417,7562,417,417,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(418,7562,418,418,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(419,7562,419,419,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(420,7562,420,420,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(421,7562,421,421,NULL,'2023-06-12 15:34:26','2023-06-12 15:34:26',NULL),(422,7562,422,422,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(423,7562,423,423,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(424,7562,424,424,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(425,7562,425,425,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(426,7562,426,426,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(427,7562,427,427,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(428,7562,428,428,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(429,7562,429,429,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(430,7562,430,430,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(431,7562,431,431,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(432,7562,432,432,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(433,7562,433,433,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(434,7562,434,434,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(435,7562,435,435,NULL,'2023-06-13 09:03:53','2023-06-13 09:03:53',NULL),(436,7562,436,436,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(437,7562,437,437,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (438,7562,438,438,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(439,7562,439,439,NULL,'2023-06-13 09:03:54','2023-06-13 09:03:54',NULL),(444,7562,444,444,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(445,7562,445,445,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(446,7562,446,446,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(447,7562,447,447,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(448,7562,448,448,NULL,'2023-06-13 09:08:29','2023-06-13 09:08:29',NULL),(449,7562,449,449,NULL,'2023-06-13 09:11:53','2023-06-13 09:11:53',NULL),(450,7562,450,450,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(451,7562,451,451,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(452,7562,452,452,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(453,7562,453,453,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(454,7562,454,454,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(455,7562,455,455,NULL,'2023-06-13 13:07:56','2023-06-13 13:07:56',NULL),(458,7562,458,458,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(459,7562,459,459,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(460,7562,460,460,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(461,7562,461,461,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(462,7562,462,462,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(463,7562,463,463,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(464,7562,464,464,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(465,7562,465,465,NULL,'2023-06-13 13:11:33','2023-06-13 13:11:33',NULL),(466,7562,466,466,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(467,7562,467,467,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(468,7562,468,468,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(469,7562,469,469,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(470,7562,470,470,NULL,'2023-07-13 16:17:46','2023-07-13 16:17:46',NULL),(471,7562,471,471,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(472,7562,472,472,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(473,7562,473,473,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(474,7562,474,474,NULL,'2023-07-13 16:18:00','2023-07-13 16:18:00',NULL),(475,7562,475,475,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(476,7562,476,476,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(477,7562,477,477,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(478,7562,478,478,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(479,7562,479,479,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(480,7562,480,480,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(481,7562,481,481,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(482,7562,482,482,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(483,7562,483,483,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(484,7562,484,484,NULL,'2023-07-13 16:18:01','2023-07-13 16:18:01',NULL),(485,7562,485,485,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(486,7562,486,486,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(487,7562,487,487,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(488,7562,488,488,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(489,7562,489,489,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(490,7562,490,490,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(491,7562,491,491,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(492,7562,492,492,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(493,7562,493,493,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(494,7562,494,494,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(495,7562,495,495,NULL,'2023-07-14 10:24:00','2023-07-14 10:24:00',NULL),(496,7562,496,496,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(497,7562,497,497,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (498,7562,498,498,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(499,7562,499,499,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(500,7562,500,500,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(501,7562,501,501,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(502,7562,502,502,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(503,7562,503,503,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(504,7562,504,504,NULL,'2023-07-14 10:24:01','2023-07-14 10:24:01',NULL),(505,7562,505,505,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(506,7562,506,506,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(507,7562,507,507,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(508,7562,508,508,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(509,7562,509,509,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(510,7562,510,510,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(511,7562,511,511,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(512,7562,512,512,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(513,7562,513,513,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(514,7562,514,514,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(515,7562,515,515,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(516,7562,516,516,NULL,'2023-07-14 10:24:02','2023-07-14 10:24:02',NULL),(517,7562,517,517,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(518,7562,518,518,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(519,7562,519,519,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(520,7562,520,520,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(521,7562,521,521,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(522,7562,522,522,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(523,7562,523,523,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(524,7562,524,524,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(525,7562,525,525,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(526,7562,526,526,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(527,7562,527,527,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(528,7562,528,528,NULL,'2023-07-14 10:24:03','2023-07-14 10:24:03',NULL),(529,7562,529,529,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(530,7562,530,530,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(531,7562,531,531,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(532,7562,532,532,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(533,7562,533,533,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(534,7562,534,534,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(535,7562,535,535,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(536,7562,536,536,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(537,7562,537,537,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(538,7562,538,538,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(539,7562,539,539,NULL,'2023-07-14 10:24:04','2023-07-14 10:24:04',NULL),(540,7562,540,540,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(541,7562,541,541,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(542,7562,542,542,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(543,7562,543,543,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(544,7562,544,544,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(545,7562,545,545,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(546,7562,546,546,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(547,7562,547,547,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(548,7562,548,548,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(549,7562,549,549,NULL,'2023-07-14 10:24:05','2023-07-14 10:24:05',NULL),(550,7562,550,550,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(551,7562,551,551,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (552,7562,552,552,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(553,7562,553,553,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(554,7562,554,554,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(555,7562,555,555,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(556,7562,556,556,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(557,7562,557,557,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(558,7562,558,558,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(559,7562,559,559,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(560,7562,560,560,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(561,7562,561,561,NULL,'2023-07-14 10:24:06','2023-07-14 10:24:06',NULL),(562,7562,562,562,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(563,7562,563,563,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(564,7562,564,564,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(565,7562,565,565,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(566,7562,566,566,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(567,7562,567,567,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(568,7562,568,568,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(569,7562,569,569,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(570,7562,570,570,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(571,7562,571,571,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(572,7562,572,572,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(573,7562,573,573,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(574,7562,574,574,NULL,'2023-07-14 10:24:07','2023-07-14 10:24:07',NULL),(575,7562,575,575,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(576,7562,576,576,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(577,7562,577,577,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(578,7562,578,578,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(579,7562,579,579,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(580,7562,580,580,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(581,7562,581,581,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(582,7562,582,582,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(583,7562,583,583,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(584,7562,584,584,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(585,7562,585,585,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(586,7562,586,586,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(587,7562,587,587,NULL,'2023-07-14 10:24:08','2023-07-14 10:24:08',NULL),(588,7562,588,588,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(589,7562,589,589,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(590,7562,590,590,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(591,7562,591,591,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(592,7562,592,592,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(593,7562,593,593,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(594,7562,594,594,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(595,7562,595,595,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(596,7562,596,596,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(597,7562,597,597,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(598,7562,598,598,NULL,'2023-07-14 10:24:09','2023-07-14 10:24:09',NULL),(599,7562,599,599,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(600,7562,600,600,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(601,7562,601,601,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(602,7562,602,602,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(603,7562,603,603,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(604,7562,604,604,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(605,7562,605,605,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (606,7562,606,606,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(607,7562,607,607,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(608,7562,608,608,NULL,'2023-07-14 10:24:10','2023-07-14 10:24:10',NULL),(609,7562,609,609,NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(610,7562,610,610,NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(611,7562,611,611,NULL,'2023-07-14 10:26:03','2023-07-14 10:26:03',NULL),(612,7562,612,612,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(613,7562,613,613,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(614,7562,614,614,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(615,7562,615,615,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(616,7562,616,616,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(617,7562,617,617,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(618,7562,618,618,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(619,7562,619,619,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(620,7562,620,620,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(621,7562,621,621,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(622,7562,622,622,NULL,'2023-07-14 10:26:04','2023-07-14 10:26:04',NULL),(623,7562,623,623,NULL,'2023-07-14 10:26:05','2023-07-14 10:26:05',NULL),(624,7562,624,624,NULL,'2023-07-14 10:26:05','2023-07-14 10:26:05',NULL),(625,7562,625,625,NULL,'2023-07-14 10:26:05','2023-07-14 10:26:05',NULL),(626,7562,626,626,NULL,'2023-07-14 10:26:05','2023-07-14 10:26:05',NULL),(627,7562,627,627,NULL,'2023-07-14 10:26:05','2023-07-14 10:26:05',NULL),(628,7562,628,628,NULL,'2023-07-14 10:26:05','2023-07-14 10:26:05',NULL),(629,7562,629,629,NULL,'2023-07-14 10:26:05','2023-07-14 10:26:05',NULL),(630,7562,630,630,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(631,7562,631,631,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(632,7562,632,632,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(633,7562,633,633,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(634,7562,634,634,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(635,7562,635,635,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(636,7562,636,636,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(637,7562,637,637,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(638,7562,638,638,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(639,7562,639,639,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(640,7562,640,640,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(641,7562,641,641,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(642,7562,642,642,NULL,'2023-07-14 11:44:26','2023-07-14 11:44:26',NULL),(643,7562,643,643,NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(644,7562,644,644,NULL,'2023-07-14 11:44:27','2023-07-14 11:44:27',NULL),(645,7562,645,645,NULL,'2023-08-12 09:55:25','2023-08-12 09:55:25',NULL),(646,7562,646,646,NULL,'2023-08-12 09:55:25','2023-08-12 09:55:25',NULL),(647,7562,647,647,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(648,7562,648,648,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(649,7562,649,649,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(650,7562,650,650,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(651,7562,651,651,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(652,7562,652,652,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(653,7562,653,653,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(654,7562,654,654,NULL,'2023-08-12 09:57:00','2023-08-12 09:57:00',NULL),(655,7562,655,655,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(656,7562,656,656,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(657,7562,657,657,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(658,7562,658,658,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(659,7562,659,659,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (660,7562,660,660,NULL,'2023-08-12 09:57:01','2023-08-12 09:57:01',NULL),(661,7562,661,661,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(662,7562,662,662,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(663,7562,663,663,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(664,7562,664,664,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(665,7562,665,665,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(666,7562,666,666,NULL,'2023-08-12 11:15:50','2023-08-12 11:15:50',NULL),(667,7562,667,667,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(668,7562,668,668,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(669,7562,669,669,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(670,7562,670,670,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(671,7562,671,671,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(672,7562,672,672,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(673,7562,673,673,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(674,7562,674,674,NULL,'2023-08-12 11:15:51','2023-08-12 11:15:51',NULL),(675,7562,675,675,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(676,7562,676,676,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(677,7562,677,677,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(678,7562,678,678,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(679,7562,679,679,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(680,7562,680,680,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(681,7562,681,681,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(682,7562,682,682,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(683,7562,683,683,NULL,'2023-08-12 12:18:32','2023-08-12 12:18:32',NULL),(684,7562,684,684,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(685,7562,685,685,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(686,7562,686,686,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(687,7562,687,687,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(688,7562,688,688,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(689,7562,689,689,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(690,7562,690,690,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(691,7562,691,691,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(692,7562,692,692,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(693,7562,693,693,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(694,7562,694,694,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(695,7562,695,695,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(696,7562,696,696,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(697,7562,697,697,NULL,'2023-08-12 12:18:33','2023-08-12 12:18:33',NULL),(698,7562,698,698,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(699,7562,699,699,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(700,7562,700,700,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(701,7562,701,701,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(702,7562,702,702,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(703,7562,703,703,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(704,7562,704,704,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(705,7562,705,705,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(706,7562,706,706,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(707,7562,707,707,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(708,7562,708,708,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(709,7562,709,709,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(710,7562,710,710,NULL,'2023-08-12 12:18:34','2023-08-12 12:18:34',NULL),(711,7562,711,711,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(712,7562,712,712,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(713,7562,713,713,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (714,7562,714,714,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(715,7562,715,715,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(716,7562,716,716,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(717,7562,717,717,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(718,7562,718,718,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(719,7562,719,719,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(720,7562,720,720,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(721,7562,721,721,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(722,7562,722,722,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(723,7562,723,723,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(724,7562,724,724,NULL,'2023-08-12 12:18:35','2023-08-12 12:18:35',NULL),(725,7562,725,725,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(726,7562,726,726,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(727,7562,727,727,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(728,7562,728,728,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(729,7562,729,729,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(730,7562,730,730,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(731,7562,731,731,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(732,7562,732,732,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(733,7562,733,733,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(734,7562,734,734,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(735,7562,735,735,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(736,7562,736,736,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(737,7562,737,737,NULL,'2023-08-12 12:18:36','2023-08-12 12:18:36',NULL),(738,7562,738,738,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(739,7562,739,739,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(740,7562,740,740,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(741,7562,741,741,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(742,7562,742,742,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(743,7562,743,743,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(744,7562,744,744,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(745,7562,745,745,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(746,7562,746,746,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(747,7562,747,747,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(748,7562,748,748,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(749,7562,749,749,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(750,7562,750,750,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(751,7562,751,751,NULL,'2023-08-12 12:18:37','2023-08-12 12:18:37',NULL),(752,7562,752,752,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(753,7562,753,753,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(754,7562,754,754,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(755,7562,755,755,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(756,7562,756,756,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(757,7562,757,757,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(758,7562,758,758,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(759,7562,759,759,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(760,7562,760,760,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(761,7562,761,761,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(762,7562,762,762,NULL,'2023-08-12 12:18:38','2023-08-12 12:18:38',NULL),(763,7562,763,763,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(764,7562,764,764,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(765,7562,765,765,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(766,7562,766,766,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(767,7562,767,767,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (768,7562,768,768,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(769,7562,769,769,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(770,7562,770,770,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(771,7562,771,771,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(772,7562,772,772,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(773,7562,773,773,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(774,7562,774,774,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(775,7562,775,775,NULL,'2023-08-12 12:18:39','2023-08-12 12:18:39',NULL),(776,7562,776,776,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(777,7562,777,777,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(778,7562,778,778,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(779,7562,779,779,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(780,7562,780,780,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(781,7562,781,781,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(782,7562,782,782,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(783,7562,783,783,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(784,7562,784,784,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(785,7562,785,785,NULL,'2023-08-12 12:18:40','2023-08-12 12:18:40',NULL),(786,7562,786,786,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(787,7562,787,787,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(788,7562,788,788,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(789,7562,789,789,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(790,7562,790,790,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(791,7562,791,791,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(792,7562,792,792,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(793,7562,793,793,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(794,7562,794,794,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(795,7562,795,795,NULL,'2023-08-12 12:18:56','2023-08-12 12:18:56',NULL),(796,7562,796,796,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(797,7562,797,797,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(798,7562,798,798,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(799,7562,799,799,NULL,'2023-08-12 12:18:57','2023-08-12 12:18:57',NULL),(800,7562,800,800,NULL,'2023-08-12 12:39:56','2023-08-12 12:39:56',NULL),(801,7562,801,801,NULL,'2023-08-12 12:41:04','2023-08-12 12:41:04',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `ticket_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `cta_cte_tesoreria_moneda_id_foreign` (`moneda_id`),
  KEY `cta_cte_tesoreria_ticket_id_foreign` (`ticket_id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_cheq`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_cheq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_cheq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `chequera_tipo_id` int(10) unsigned NOT NULL,
  `serie` text COLLATE utf8mb4_unicode_ci,
  `numero_cheque` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_cheq_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` (`cta_cte_tesoreria_banco_id`),
  KEY `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` (`chequera_tipo_id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` FOREIGN KEY (`chequera_tipo_id`) REFERENCES `chequeras_tipos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_cheq`
--

LOCK TABLES `cta_cte_tesoreria_banco_cheq` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_claves`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_claves_person_id_foreign` (`person_id`),
  KEY `ct_cuenta_id` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ct_banco_id` (`cta_cte_tesoreria_banco_id`),
  CONSTRAINT `ct_banco_id` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `ct_cuenta_id` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_claves_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_claves`
--

LOCK TABLES `cta_cte_tesoreria_banco_claves` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_bancos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `ctacte_banco_id` int(10) unsigned NOT NULL,
  `persona_empresa` int(11) NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id_diferido` int(10) unsigned DEFAULT NULL,
  `cuenta_contable_id_pend_acred` int(10) unsigned DEFAULT NULL,
  `numero_cuenta` text COLLATE utf8mb4_unicode_ci,
  `cbu` text COLLATE utf8mb4_unicode_ci,
  `alias` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_bancos_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` (`ctacte_banco_id`),
  KEY `cta_cte_tesoreria_bancos_zone_id_foreign` (`zone_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` (`cuenta_contable_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` (`cuenta_contable_id_diferido`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` (`cuenta_contable_id_pend_acred`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` FOREIGN KEY (`ctacte_banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` FOREIGN KEY (`cuenta_contable_id_diferido`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` FOREIGN KEY (`cuenta_contable_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` FOREIGN KEY (`cuenta_contable_id_pend_acred`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_bancos`
--

LOCK TABLES `cta_cte_tesoreria_bancos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuenta_tipos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuenta_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuenta_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuenta_tipos`
--

LOCK TABLES `cta_cte_tesoreria_cuenta_tipos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuenta_tipos` VALUES (1,NULL,'CAJA',1,NULL,NULL,NULL),(2,NULL,'BANCOS',1,NULL,NULL,NULL),(3,NULL,'CHEQUES',1,NULL,NULL,NULL),(4,NULL,'RETENCIONES',1,NULL,NULL,NULL),(5,NULL,'PERCEPCIONES',1,NULL,NULL,NULL),(6,NULL,'RESULTADO NEGATIVO',1,NULL,NULL,NULL),(7,NULL,'RESULTADO POSITIVO',1,NULL,NULL,NULL),(8,NULL,'MOVIMIENTO',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_tipo_id` int(10) unsigned NOT NULL DEFAULT '8',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `cta_tes_tipo_id_foreign` (`cta_cte_tesoreria_cuenta_tipo_id`),
  KEY `cta_cte_tesoreria_cuentas_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_tes_tipo_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_tipo_id`) REFERENCES `cta_cte_tesoreria_cuenta_tipos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,NULL,1,13,NULL,8,'Clientes - Deudores',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,NULL,1,20,NULL,8,'Anticipos Impuesto a las Ganancias',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,NULL,1,23,NULL,4,'Retenciones Impuesto a las Ganancias',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(25,NULL,1,25,NULL,4,'Retenciones de IVA',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(57,NULL,1,57,NULL,8,'Proveedores en Cta. Cte. locales',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,NULL,1,60,NULL,3,'Cheques emitidos ',NULL,0,1,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(62,NULL,1,62,NULL,8,'Sueldos y Jornales a pagar',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,NULL,1,140,NULL,6,'Intereses y Gastos bancarios',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(162,NULL,1,162,NULL,4,'Retenciones SUSS',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(176,NULL,1,176,NULL,3,'Cheques en Cartera',NULL,1,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(201,NULL,1,201,NULL,6,'Monotributo',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(203,NULL,1,203,NULL,6,'Autonomos',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(219,NULL,1,219,NULL,8,'Pagos AFIP',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,NULL,1,251,NULL,4,'Retenciones de IIBB Buenos Aires',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(252,NULL,1,252,NULL,4,'Retenciones de IIBB Capital Federal',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(253,NULL,1,253,NULL,4,'Retenciones de IIBB Catamarca',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(254,NULL,1,254,NULL,4,'Retenciones de IIBB Chaco',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(255,NULL,1,255,NULL,4,'Retenciones de IIBB Chubut',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(256,NULL,1,256,NULL,4,'Retenciones de IIBB Córdoba',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(257,NULL,1,257,NULL,4,'Retenciones de IIBB Corrientes',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(258,NULL,1,258,NULL,4,'Retenciones de IIBB Entre Ríos',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(259,NULL,1,259,NULL,4,'Retenciones de IIBB Formosa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(260,NULL,1,260,NULL,4,'Retenciones de IIBB Jujuy',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(261,NULL,1,261,NULL,4,'Retenciones de IIBB La Pampa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(262,NULL,1,262,NULL,4,'Retenciones de IIBB La Rioja',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:51',NULL),(263,NULL,1,263,NULL,4,'Retenciones de IIBB Mendoza',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL),(264,NULL,1,264,NULL,4,'Retenciones de IIBB Misiones',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL),(265,NULL,1,265,NULL,4,'Retenciones de IIBB Neuquén',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL),(266,NULL,1,266,NULL,4,'Retenciones de IIBB Pascua Lama',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL),(267,NULL,1,267,NULL,4,'Retenciones de IIBB Río Negro',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL),(268,NULL,1,268,NULL,4,'Retenciones de IIBB Salta',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL),(269,NULL,1,269,NULL,4,'Retenciones de IIBB San Juan',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL),(270,NULL,1,270,NULL,4,'Retenciones de IIBB San Luis',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (271,NULL,1,271,NULL,4,'Retenciones de IIBB Santa Cruz',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL),(272,NULL,1,272,NULL,4,'Retenciones de IIBB Santa Fe',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL),(273,NULL,1,273,NULL,4,'Retenciones de IIBB Santiago del Estero',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL),(274,NULL,1,274,NULL,4,'Retenciones de IIBB Tierra del Fuego',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL),(275,NULL,1,275,NULL,4,'Retenciones de IIBB Tucuman',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL),(351,NULL,1,351,NULL,8,'BANCO SIRCREB',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,NULL,1,359,NULL,8,'Caja en Pesos',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:13:22','2023-03-20 23:13:22'),(360,NULL,1,360,NULL,8,'Retenciones Bancarias de Ganancias a Favor',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,NULL,1,364,NULL,8,'Anticipo de Clientes',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,NULL,1,384,NULL,8,'Caja en Dolares',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:13:22','2023-03-20 23:13:22'),(409,NULL,1,409,NULL,6,'IVA Crédito Fiscal No computable',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:02:52',NULL),(418,NULL,1,418,NULL,8,'Deudas Bancarias',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,NULL,1,433,NULL,8,'Préstamo',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,N