-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-40548869-9
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-08-11 08:55:07','Actividad Generica 1','000001',NULL),(2,NULL,'2022-08-11 08:55:07','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1473 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7532,40720,1524,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',55000.00,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(2,7532,40720,1524,2,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',549999.99,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(3,7532,40720,1524,2,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',549999.99,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(4,7532,40720,1524,2,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',55000.00,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(5,7532,40720,1524,2,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',55000.00,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(6,7532,40720,1524,2,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',35000.00,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(7,7532,40720,1524,2,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',3900.00,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(8,7532,40720,1524,2,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',18150.07,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(9,7532,40720,1524,2,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',150000.00,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(10,7532,40720,1524,2,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1953389.97,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(11,7532,40720,1524,2,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',221000.00,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(12,7532,40720,1524,2,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',15064.50,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(13,7532,40720,1524,2,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',35000.00,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(14,7532,40720,1524,2,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',60000.00,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(15,7532,40720,1524,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',55000.00,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(16,7532,40720,1524,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',35000.00,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(17,7532,40720,1524,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',100000.00,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(18,7532,40720,1524,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',6050.00,NULL,NULL,1,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(19,7532,40720,1524,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',55000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(20,7532,40720,1524,2,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',55000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(21,7532,40720,1524,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',9471.01,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(22,7532,40720,1524,2,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',168000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10');
INSERT INTO `balance_libro` VALUES (23,7532,40720,1524,2,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',408000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(24,7532,40720,1524,2,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',30000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(25,7532,40720,1524,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',13100.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(26,7532,40720,1524,2,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',75000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(27,7532,40720,1524,2,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',25000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(28,7532,40720,1524,2,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',14233.16,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(29,7532,40720,1524,2,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',40000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(30,7532,40720,1524,2,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',75000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(31,7532,40720,1524,2,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',40000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(32,7532,40720,1524,2,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1810.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(33,7532,40720,1524,2,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',25000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(34,7532,40720,1524,2,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',30000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(35,7532,40720,1524,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',30000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(36,7532,40720,1524,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',12360.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(37,7532,40720,1524,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',50000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(38,7532,40720,1524,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',60000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(39,7532,40720,1524,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',372680.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(40,7532,40720,1524,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',25000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(41,7532,40720,1524,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',65000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(42,7532,40720,1524,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',70000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(43,7532,40720,1524,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',65000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(44,7532,40720,1524,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',75000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10');
INSERT INTO `balance_libro` VALUES (45,7532,40720,1524,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',50000.00,NULL,NULL,1,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(46,7532,40720,1524,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',50000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(47,7532,40720,1524,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',393144.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(48,7532,40720,1524,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',75000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(49,7532,40720,1524,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',273460.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(50,7532,40720,1524,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',60000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(51,7532,40720,1524,2,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(52,7532,40720,1524,2,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',35000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(53,7532,40720,1524,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(54,7532,40720,1524,2,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(55,7532,40720,1524,2,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(56,7532,40720,1524,2,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(57,7532,40720,1524,2,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(58,7532,40720,1524,2,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5685.75,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(59,7532,40720,1524,2,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',43861.51,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(60,7532,40720,1524,2,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(61,7532,40720,1524,2,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',7500.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(62,7532,40720,1524,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(63,7532,40720,1524,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(64,7532,40720,1524,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1300.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(65,7532,40720,1524,2,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(66,7532,40720,1524,2,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10');
INSERT INTO `balance_libro` VALUES (67,7532,40720,1524,2,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:11','2022-08-11 10:38:11'),(68,7532,40720,1524,2,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:11','2022-08-11 10:38:11'),(69,7532,40720,1524,2,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1370.00,NULL,NULL,1,'2022-08-11 10:01:45','2022-08-11 10:38:11','2022-08-11 10:38:11'),(70,7532,40720,1524,2,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2250.12,NULL,NULL,1,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(71,7532,40720,1524,2,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(72,7532,40720,1524,2,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(73,7532,40720,1524,2,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(74,7532,40720,1524,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',35000.00,NULL,NULL,1,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(75,7532,40720,1524,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(76,7532,40720,1524,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(77,7532,40720,1524,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',353925.00,NULL,NULL,1,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(78,7532,40720,1524,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(79,7532,40720,1524,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',26531.40,NULL,NULL,1,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(80,7532,40720,1524,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(81,7532,40720,1524,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(82,7532,40720,1524,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(83,7532,40720,1524,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7699.99,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(84,7532,40720,1524,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(85,7532,40720,1524,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(86,7532,40720,1524,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(87,7532,40720,1524,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',360000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(88,7532,40720,1524,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11');
INSERT INTO `balance_libro` VALUES (89,7532,40720,1524,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(90,7532,40720,1524,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(91,7532,40720,1524,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',25000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(92,7532,40720,1524,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',25000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(93,7532,40720,1524,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(94,7532,40720,1524,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(95,7532,40720,1524,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(96,7532,40720,1524,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(97,7532,40720,1524,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',35000.00,NULL,NULL,1,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(98,7532,40720,1524,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',100000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(99,7532,40720,1524,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',261900.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(100,7532,40720,1524,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',250107.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(101,7532,40720,1524,2,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',50000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(102,7532,40720,1524,2,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',173750.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(103,7532,40720,1524,2,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',140000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(104,7532,40720,1524,2,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',50000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(105,7532,40720,1524,2,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',50000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(106,7532,40720,1524,2,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',41000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(107,7532,40720,1524,2,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',50000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(108,7532,40720,1524,2,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',20000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(109,7532,40720,1524,2,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',50000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(110,7532,40720,1524,2,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',50000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11');
INSERT INTO `balance_libro` VALUES (111,7532,40720,1524,2,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',48000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(112,7532,40720,1524,2,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',196000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(113,7532,40720,1524,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',82000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(114,7532,40720,1524,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',384780.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(115,7532,40720,1524,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4099.99,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(116,7532,40720,1524,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2178000.00,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(117,7532,40720,1524,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',18170.03,NULL,NULL,1,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(118,7532,40720,1524,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1800.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(119,7532,40720,1524,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2480.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(120,7532,40720,1524,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1450.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(121,7532,40720,1524,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',609.92,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(122,7532,40720,1524,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',365420.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(123,7532,40720,1524,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',34765.30,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(124,7532,40720,1524,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',178000.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(125,7532,40720,1524,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',250.29,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(126,7532,40720,1524,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',178000.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(127,7532,40720,1524,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',21400.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(128,7532,40720,1524,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',50000.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(129,7532,40720,1524,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',24600.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(130,7532,40720,1524,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',60000.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(131,7532,40720,1524,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',270000.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(132,7532,40720,1524,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',35000.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12');
INSERT INTO `balance_libro` VALUES (133,7532,40720,1524,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5641.73,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(134,7532,40720,1524,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1750.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(135,7532,40720,1524,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1210000.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(136,7532,40720,1524,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',100000.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(137,7532,40720,1524,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2800.00,NULL,NULL,1,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(138,7532,40720,1524,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',12600.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(139,7532,40720,1524,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',400.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(140,7532,40720,1524,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',200000.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(141,7532,40720,1524,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',110000.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(142,7532,40720,1524,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5000.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(143,7532,40720,1524,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',200000.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(144,7532,40720,1524,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',186000.04,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(145,7532,40720,1524,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',36900.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(146,7532,40720,1524,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',15470.01,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(147,7532,40720,1524,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',32689.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(148,7532,40720,1524,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',32689.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(149,7532,40720,1524,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',2000.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(150,7532,40720,1524,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',70000.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(151,7532,40720,1524,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',34002.17,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(152,7532,40720,1524,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1790.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(153,7532,40720,1524,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2700.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(154,7532,40720,1524,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1200.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12');
INSERT INTO `balance_libro` VALUES (155,7532,40720,1524,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',18333.15,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(156,7532,40720,1524,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',9019.98,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(157,7532,40720,1524,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',33779.97,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(158,7532,40720,1524,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',15000.00,NULL,NULL,1,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(159,7532,40720,1524,2,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',600000.00,NULL,NULL,1,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(160,7532,40720,1524,2,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',160415.10,NULL,NULL,1,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(161,7532,40720,1524,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1500.00,NULL,NULL,1,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(162,7532,40720,1524,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',87790.15,NULL,NULL,1,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(163,7532,40720,1524,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',11794.95,NULL,NULL,1,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(164,7532,40720,1524,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',400000.00,NULL,NULL,1,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(165,7532,40720,1524,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1499.99,NULL,NULL,1,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(166,7532,40720,1524,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',8969.98,NULL,NULL,1,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(167,7532,40720,1524,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',10701.62,NULL,NULL,1,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(168,7532,40720,1524,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1210000.00,NULL,NULL,1,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(169,7532,40720,1524,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',60000.00,NULL,NULL,1,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(170,7532,40720,1524,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',50000.00,NULL,NULL,1,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(171,7532,40720,1524,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',190000.00,NULL,NULL,1,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(172,7532,40720,1524,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',520000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(173,7532,40720,1524,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',504000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(174,7532,40720,1524,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',510000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(175,7532,40720,1524,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',950000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(176,7532,40720,1524,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1600000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12');
INSERT INTO `balance_libro` VALUES (177,7532,40720,1524,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',500000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(178,7532,40720,1524,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2500000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(179,7532,40720,1524,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1740000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(180,7532,40720,1524,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',720000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(181,7532,40720,1524,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',289379.51,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(182,7532,40720,1524,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9102372.70,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(183,7532,40720,1524,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',720000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(184,7532,40720,1524,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',720000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(185,7532,40720,1524,2,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',984000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(186,7532,40720,1524,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1700000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(187,7532,40720,1524,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1500000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(188,7532,40720,1524,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',470000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(189,7532,40720,1524,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',300000.00,NULL,NULL,1,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(190,7532,40720,1524,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',984000.00,NULL,NULL,1,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(191,7532,40720,1524,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1700000.00,NULL,NULL,1,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(192,7532,40720,1524,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1100000.00,NULL,NULL,1,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(193,7532,40720,1524,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2700000.00,NULL,NULL,1,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(194,7532,40720,1524,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',700000.00,NULL,NULL,1,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(195,7532,40720,1524,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',620000.01,NULL,NULL,1,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(196,7532,40720,1524,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',984000.00,NULL,NULL,1,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(197,7532,40720,1524,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1070000.00,NULL,NULL,1,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(198,7532,40720,1524,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',600000.00,NULL,NULL,1,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12');
INSERT INTO `balance_libro` VALUES (199,7532,40720,1524,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',520000.00,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(200,7532,40720,1524,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',504000.00,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(201,7532,40720,1524,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',510000.00,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(202,7532,40720,1524,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',950000.00,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(203,7532,40720,1524,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1600000.00,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(204,7532,40720,1524,2,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',500000.00,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(205,7532,40720,1524,2,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2500000.00,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(206,7532,40720,1524,2,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1740000.00,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(207,7532,40720,1524,2,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',720000.00,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(208,7532,40720,1524,2,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',289379.51,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(209,7532,40720,1524,2,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9102372.70,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(210,7532,40720,1524,2,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',720000.00,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(211,7532,40720,1524,2,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',720000.00,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(212,7532,40720,1524,2,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',984000.00,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(213,7532,40720,1524,2,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1700000.00,NULL,NULL,1,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(214,7532,40720,1524,2,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1500000.00,NULL,NULL,1,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(215,7532,40720,1524,2,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',470000.00,NULL,NULL,1,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(216,7532,40720,1524,2,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',300000.00,NULL,NULL,1,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(217,7532,40720,1524,2,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',984000.00,NULL,NULL,1,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(218,7532,40720,1524,2,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1700000.00,NULL,NULL,1,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(219,7532,40720,1524,2,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1100000.00,NULL,NULL,1,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(220,7532,40720,1524,2,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2700000.00,NULL,NULL,1,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24');
INSERT INTO `balance_libro` VALUES (221,7532,40720,1524,2,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',700000.00,NULL,NULL,1,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(222,7532,40720,1524,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',620000.01,NULL,NULL,1,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(223,7532,40720,1524,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',984000.00,NULL,NULL,1,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(224,7532,40720,1524,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1070000.00,NULL,NULL,1,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(225,7532,40720,1524,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',600000.00,NULL,NULL,1,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(226,7532,40720,1524,3,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',55000.00,NULL,NULL,1,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(227,7532,40720,1524,3,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',549999.99,NULL,NULL,1,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(228,7532,40720,1524,3,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',549999.99,NULL,NULL,1,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(229,7532,40720,1524,3,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',55000.00,NULL,NULL,1,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(230,7532,40720,1524,3,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',55000.00,NULL,NULL,1,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(231,7532,40720,1524,3,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',35000.00,NULL,NULL,1,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(232,7532,40720,1524,3,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',3900.00,NULL,NULL,1,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(233,7532,40720,1524,3,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',18150.07,NULL,NULL,1,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(234,7532,40720,1524,3,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',150000.00,NULL,NULL,1,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(235,7532,40720,1524,3,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1953389.97,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(236,7532,40720,1524,3,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',221000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(237,7532,40720,1524,3,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',15064.50,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(238,7532,40720,1524,3,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',35000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(239,7532,40720,1524,3,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',60000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(240,7532,40720,1524,3,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',55000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(241,7532,40720,1524,3,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',35000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(242,7532,40720,1524,3,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',100000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(243,7532,40720,1524,3,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',6050.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(244,7532,40720,1524,3,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',55000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL);
INSERT INTO `balance_libro` VALUES (245,7532,40720,1524,3,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',55000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(246,7532,40720,1524,3,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-02','2022-07-02',9471.01,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(247,7532,40720,1524,3,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',168000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(248,7532,40720,1524,3,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',408000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(249,7532,40720,1524,3,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',30000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(250,7532,40720,1524,3,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',13100.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(251,7532,40720,1524,3,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',75000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(252,7532,40720,1524,3,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',25000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(253,7532,40720,1524,3,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',14233.16,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(254,7532,40720,1524,3,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',40000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(255,7532,40720,1524,3,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',75000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(256,7532,40720,1524,3,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',40000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(257,7532,40720,1524,3,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',1810.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(258,7532,40720,1524,3,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',25000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(259,7532,40720,1524,3,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',30000.00,NULL,NULL,1,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(260,7532,40720,1524,3,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',30000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(261,7532,40720,1524,3,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',12360.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(262,7532,40720,1524,3,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',50000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(263,7532,40720,1524,3,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',60000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(264,7532,40720,1524,3,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',372680.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(265,7532,40720,1524,3,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',25000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(266,7532,40720,1524,3,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',65000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(267,7532,40720,1524,3,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',70000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(268,7532,40720,1524,3,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',65000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(269,7532,40720,1524,3,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',75000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL);
INSERT INTO `balance_libro` VALUES (270,7532,40720,1524,3,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',50000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(271,7532,40720,1524,3,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',50000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(272,7532,40720,1524,3,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',393144.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(273,7532,40720,1524,3,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',75000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(274,7532,40720,1524,3,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',273460.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(275,7532,40720,1524,3,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',60000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(276,7532,40720,1524,3,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(277,7532,40720,1524,3,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',35000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(278,7532,40720,1524,3,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(279,7532,40720,1524,3,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(280,7532,40720,1524,3,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(281,7532,40720,1524,3,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(282,7532,40720,1524,3,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(283,7532,40720,1524,3,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',5685.75,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(284,7532,40720,1524,3,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',43861.51,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(285,7532,40720,1524,3,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(286,7532,40720,1524,3,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',7500.00,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(287,7532,40720,1524,3,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(288,7532,40720,1524,3,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(289,7532,40720,1524,3,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1300.00,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(290,7532,40720,1524,3,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(291,7532,40720,1524,3,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(292,7532,40720,1524,3,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(293,7532,40720,1524,3,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(294,7532,40720,1524,3,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1370.00,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL);
INSERT INTO `balance_libro` VALUES (295,7532,40720,1524,3,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',2250.12,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(296,7532,40720,1524,3,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(297,7532,40720,1524,3,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(298,7532,40720,1524,3,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(299,7532,40720,1524,3,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',35000.00,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(300,7532,40720,1524,3,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',20000.00,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(301,7532,40720,1524,3,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',25000.00,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(302,7532,40720,1524,3,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',353925.00,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(303,7532,40720,1524,3,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(304,7532,40720,1524,3,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',26531.40,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(305,7532,40720,1524,3,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(306,7532,40720,1524,3,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(307,7532,40720,1524,3,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(308,7532,40720,1524,3,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',7699.99,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(309,7532,40720,1524,3,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(310,7532,40720,1524,3,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(311,7532,40720,1524,3,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',5000.00,NULL,NULL,1,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(312,7532,40720,1524,3,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',360000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(313,7532,40720,1524,3,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(314,7532,40720,1524,3,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(315,7532,40720,1524,3,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(316,7532,40720,1524,3,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',25000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(317,7532,40720,1524,3,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',25000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(318,7532,40720,1524,3,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(319,7532,40720,1524,3,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL);
INSERT INTO `balance_libro` VALUES (320,7532,40720,1524,3,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(321,7532,40720,1524,3,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',20000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(322,7532,40720,1524,3,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-07','2022-07-07',35000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(323,7532,40720,1524,3,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',100000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(324,7532,40720,1524,3,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-08','2022-07-08',261900.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(325,7532,40720,1524,3,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',250107.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(326,7532,40720,1524,3,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',50000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(327,7532,40720,1524,3,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',173750.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(328,7532,40720,1524,3,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',140000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(329,7532,40720,1524,3,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',50000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(330,7532,40720,1524,3,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',50000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(331,7532,40720,1524,3,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',41000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(332,7532,40720,1524,3,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',50000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(333,7532,40720,1524,3,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',20000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(334,7532,40720,1524,3,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',50000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(335,7532,40720,1524,3,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',50000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(336,7532,40720,1524,3,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',48000.00,NULL,NULL,1,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(337,7532,40720,1524,3,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',196000.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(338,7532,40720,1524,3,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-11','2022-07-11',82000.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(339,7532,40720,1524,3,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',384780.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(340,7532,40720,1524,3,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',4099.99,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(341,7532,40720,1524,3,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2178000.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(342,7532,40720,1524,3,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',18170.03,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(343,7532,40720,1524,3,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1800.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(344,7532,40720,1524,3,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',2480.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL);
INSERT INTO `balance_libro` VALUES (345,7532,40720,1524,3,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1450.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(346,7532,40720,1524,3,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',609.92,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(347,7532,40720,1524,3,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',365420.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(348,7532,40720,1524,3,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',34765.30,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(349,7532,40720,1524,3,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',178000.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(350,7532,40720,1524,3,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',250.29,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(351,7532,40720,1524,3,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',178000.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(352,7532,40720,1524,3,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',21400.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(353,7532,40720,1524,3,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-13','2022-07-13',50000.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(354,7532,40720,1524,3,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',24600.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(355,7532,40720,1524,3,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',60000.00,NULL,NULL,1,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(356,7532,40720,1524,3,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',270000.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(357,7532,40720,1524,3,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',35000.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(358,7532,40720,1524,3,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5641.73,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 11:56:10','2022-08-11 11:56:10'),(359,7532,40720,1524,3,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',1750.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(360,7532,40720,1524,3,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1210000.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(361,7532,40720,1524,3,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',100000.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(362,7532,40720,1524,3,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',2800.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(363,7532,40720,1524,3,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',12600.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(364,7532,40720,1524,3,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',400.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(365,7532,40720,1524,3,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',200000.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(366,7532,40720,1524,3,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',110000.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(367,7532,40720,1524,3,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-20','2022-07-20',5000.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(368,7532,40720,1524,3,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',200000.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL);
INSERT INTO `balance_libro` VALUES (369,7532,40720,1524,3,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',186000.04,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(370,7532,40720,1524,3,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',36900.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(371,7532,40720,1524,3,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',15470.01,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(372,7532,40720,1524,3,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',32689.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(373,7532,40720,1524,3,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-22','2022-07-22',32689.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(374,7532,40720,1524,3,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',2000.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(375,7532,40720,1524,3,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-23','2022-07-23',70000.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(376,7532,40720,1524,3,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',34002.17,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(377,7532,40720,1524,3,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1790.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(378,7532,40720,1524,3,378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',2700.00,NULL,NULL,1,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(379,7532,40720,1524,3,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-25','2022-07-25',1200.00,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(380,7532,40720,1524,3,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',18333.15,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(381,7532,40720,1524,3,381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',9019.98,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(382,7532,40720,1524,3,382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',33779.97,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(383,7532,40720,1524,3,383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',15000.00,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(384,7532,40720,1524,3,384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26','2022-07-26',600000.00,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(385,7532,40720,1524,3,385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',160415.10,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(386,7532,40720,1524,3,386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',1500.00,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(387,7532,40720,1524,3,387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',87790.15,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(388,7532,40720,1524,3,388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-28','2022-07-28',11794.95,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(389,7532,40720,1524,3,389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',400000.00,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(390,7532,40720,1524,3,390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1499.99,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(391,7532,40720,1524,3,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',8969.98,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(392,7532,40720,1524,3,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',10701.62,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(393,7532,40720,1524,3,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',1210000.00,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL);
INSERT INTO `balance_libro` VALUES (394,7532,40720,1524,3,394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',60000.00,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(395,7532,40720,1524,3,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-30','2022-07-30',50000.00,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(396,7532,40720,1524,3,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',190000.00,NULL,NULL,1,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(397,7532,40720,1524,2,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',520000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(398,7532,40720,1524,2,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',504000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(399,7532,40720,1524,2,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',510000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(400,7532,40720,1524,2,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',950000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(401,7532,40720,1524,2,401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',1600000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(402,7532,40720,1524,2,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',500000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(403,7532,40720,1524,2,403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-01','2022-07-01',2500000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(404,7532,40720,1524,2,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',1740000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(405,7532,40720,1524,2,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-04','2022-07-04',720000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(406,7532,40720,1524,2,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',289379.51,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(407,7532,40720,1524,2,407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-05','2022-07-05',9102372.70,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(408,7532,40720,1524,2,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',720000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(409,7532,40720,1524,2,409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',720000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(410,7532,40720,1524,2,410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',984000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(411,7532,40720,1524,2,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-06','2022-07-06',1700000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(412,7532,40720,1524,2,412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',1500000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(413,7532,40720,1524,2,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',470000.00,NULL,NULL,1,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(414,7532,40720,1524,2,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-12','2022-07-12',300000.00,NULL,NULL,1,'2022-08-11 11:48:19','2022-08-12 11:03:47','2022-08-12 11:03:47'),(415,7532,40720,1524,2,415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-14','2022-07-14',984000.00,NULL,NULL,1,'2022-08-11 11:48:19','2022-08-12 11:03:47','2022-08-12 11:03:47');
INSERT INTO `balance_libro` VALUES (416,7532,40720,1524,2,416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-18','2022-07-18',1700000.00,NULL,NULL,1,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(417,7532,40720,1524,2,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',1100000.00,NULL,NULL,1,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(418,7532,40720,1524,2,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-21','2022-07-21',2700000.00,NULL,NULL,1,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(419,7532,40720,1524,2,419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',700000.00,NULL,NULL,1,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(420,7532,40720,1524,2,420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-27','2022-07-27',620000.01,NULL,NULL,1,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(421,7532,40720,1524,2,421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',984000.00,NULL,NULL,1,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(422,7532,40720,1524,2,422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-29','2022-07-29',1070000.00,NULL,NULL,1,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(423,7532,40720,1524,2,423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',600000.00,NULL,NULL,1,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(424,7532,40720,1524,3,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-15','2022-07-15',5641.73,NULL,NULL,1,'2022-08-11 11:56:10','2022-08-11 11:56:10',NULL),(425,7532,40720,1518,2,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',600000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(426,7532,40720,1518,2,425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',600000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(427,7532,40720,1518,2,426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',330000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(428,7532,40720,1518,2,427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',320000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(429,7532,40720,1518,2,428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',500000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(430,7532,40720,1518,2,429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',550000.01,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(431,7532,40720,1518,2,430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',550000.01,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(432,7532,40720,1518,2,431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',1100000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(433,7532,40720,1518,2,432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',2000000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(434,7532,40720,1518,2,433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',2000000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(435,7532,40720,1518,2,434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',450000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(436,7532,40720,1518,2,435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',600000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(437,7532,40720,1518,2,436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',670000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(438,7532,40720,1518,2,437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',1000000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(439,7532,40720,1518,2,438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',1000000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL);
INSERT INTO `balance_libro` VALUES (440,7532,40720,1518,2,439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',475000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(441,7532,40720,1518,2,440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',685000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(442,7532,40720,1518,2,441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',400000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(443,7532,40720,1518,2,442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',600000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(444,7532,40720,1518,2,443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',450000.00,NULL,NULL,1,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(445,7532,40720,1518,2,444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',450000.00,NULL,NULL,1,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(446,7532,40720,1518,2,445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2000000.00,NULL,NULL,1,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(447,7532,40720,1518,2,446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',280000.00,NULL,NULL,1,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(448,7532,40720,1518,2,447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',180000.00,NULL,NULL,1,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(449,7532,40720,1518,2,448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',300000.01,NULL,NULL,1,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(450,7532,40720,1518,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',13269209.97,'Por reactivación de cuentas patrimoniales',NULL,1,'2022-08-12 09:47:35','2022-08-12 10:40:24','2022-08-12 10:40:24'),(451,7532,40720,1519,2,449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',600000.00,NULL,NULL,1,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(452,7532,40720,1519,2,450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',600000.00,NULL,NULL,1,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(453,7532,40720,1519,2,451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',585000.01,NULL,NULL,1,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(454,7532,40720,1519,2,452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',710000.00,NULL,NULL,1,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(455,7532,40720,1519,2,453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',720000.00,NULL,NULL,1,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(456,7532,40720,1519,2,454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',720000.00,NULL,NULL,1,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(457,7532,40720,1519,2,455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',600000.00,NULL,NULL,1,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(458,7532,40720,1519,2,456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',1450000.00,NULL,NULL,1,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(459,7532,40720,1519,2,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',2100000.00,NULL,NULL,1,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(460,7532,40720,1519,2,458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',890000.00,NULL,NULL,1,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(461,7532,40720,1519,2,459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',820000.00,NULL,NULL,1,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(462,7532,40720,1519,2,460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',430000.00,NULL,NULL,1,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48');
INSERT INTO `balance_libro` VALUES (463,7532,40720,1519,2,461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',420000.00,NULL,NULL,1,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(464,7532,40720,1519,2,462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',650000.00,NULL,NULL,1,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(465,7532,40720,1519,2,463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',820000.00,NULL,NULL,1,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(466,7532,40720,1519,2,464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',520000.00,NULL,NULL,1,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(467,7532,40720,1519,2,465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',390000.00,NULL,NULL,1,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(468,7532,40720,1519,2,466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',250000.00,NULL,NULL,1,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(469,7532,40720,1519,2,467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',600000.00,NULL,NULL,1,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(470,7532,40720,1518,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',20144930.69,'Por reactivación de cuentas patrimoniales',NULL,1,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(471,7532,40720,1518,12,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',21464061.30,'Por reactivación de cuentas patrimoniales',NULL,1,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(472,7532,40720,1519,2,468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',600000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(473,7532,40720,1519,2,469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',600000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(474,7532,40720,1519,2,470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',585000.01,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(475,7532,40720,1519,2,471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',710000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(476,7532,40720,1519,2,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',720000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(477,7532,40720,1519,2,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',720000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(478,7532,40720,1519,2,474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',600000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(479,7532,40720,1519,2,475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',1450000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(480,7532,40720,1519,2,476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',2100000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(481,7532,40720,1519,2,477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',890000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(482,7532,40720,1519,2,478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',820000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(483,7532,40720,1519,2,479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',430000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(484,7532,40720,1519,2,480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',420000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21');
INSERT INTO `balance_libro` VALUES (485,7532,40720,1519,2,481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',650000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(486,7532,40720,1519,2,482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',820000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(487,7532,40720,1519,2,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',520000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(488,7532,40720,1519,2,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',390000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(489,7532,40720,1519,2,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',250000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(490,7532,40720,1519,2,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',600000.00,NULL,NULL,1,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(491,7532,40720,1519,2,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',600000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(492,7532,40720,1519,2,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',600000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(493,7532,40720,1519,2,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',585000.01,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(494,7532,40720,1519,2,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',710000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(495,7532,40720,1519,2,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',720000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(496,7532,40720,1519,2,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',720000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(497,7532,40720,1519,2,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',600000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(498,7532,40720,1519,2,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',1450000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(499,7532,40720,1519,2,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',2100000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(500,7532,40720,1519,2,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',890000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(501,7532,40720,1519,2,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',820000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(502,7532,40720,1519,2,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',430000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(503,7532,40720,1519,2,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',420000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(504,7532,40720,1519,2,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',650000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(505,7532,40720,1519,2,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',820000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(506,7532,40720,1519,2,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',520000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22');
INSERT INTO `balance_libro` VALUES (507,7532,40720,1519,2,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',390000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(508,7532,40720,1519,2,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',250000.00,NULL,NULL,1,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(509,7532,40720,1519,2,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',600000.00,NULL,NULL,1,'2022-08-12 11:34:54','2022-08-12 11:44:47','2022-08-12 11:44:47'),(510,7532,40720,1519,2,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',600000.00,NULL,NULL,1,'2022-08-12 11:44:47','2022-08-12 11:45:36','2022-08-12 11:45:36'),(512,7532,40720,1519,20,NULL,NULL,NULL,509,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',600000.00,NULL,NULL,1,'2022-08-12 11:45:35','2022-08-12 11:48:38','2022-08-12 11:48:38'),(513,7532,40720,1519,2,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',600000.00,NULL,NULL,1,'2022-08-12 11:45:36','2022-08-12 11:48:38','2022-08-12 11:48:38'),(514,7532,40720,1522,2,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-05','2022-05-05',600000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(515,7532,40720,1522,2,507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-06','2022-05-06',900000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(516,7532,40720,1522,2,508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',420000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(517,7532,40720,1522,2,509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',650000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(518,7532,40720,1522,2,510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-09','2022-05-09',430000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(519,7532,40720,1522,2,511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',600000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(520,7532,40720,1522,2,512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',600000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(521,7532,40720,1522,2,513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',1450000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(522,7532,40720,1522,2,514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',600000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(523,7532,40720,1522,2,515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',620000.01,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(524,7532,40720,1522,2,516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',1300000.01,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(525,7532,40720,1522,2,517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',390000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(526,7532,40720,1522,2,518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',2100000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(527,7532,40720,1522,2,519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-11','2022-05-11',820000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(528,7532,40720,1522,2,520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-16','2022-05-16',1375000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(529,7532,40720,1522,2,521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',820000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41');
INSERT INTO `balance_libro` VALUES (530,7532,40720,1522,2,522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-17','2022-05-17',890000.00,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(531,7532,40720,1522,2,523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',1309521.94,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(532,7532,40720,1522,2,524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-20','2022-05-20',260165.03,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(533,7532,40720,1522,2,525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-23','2022-05-23',1800000.01,NULL,NULL,1,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(534,7532,40720,1522,2,526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',250000.00,NULL,NULL,1,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(535,7532,40720,1522,2,527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',520000.00,NULL,NULL,1,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(536,7532,40720,1522,2,528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',820000.00,NULL,NULL,1,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(537,7532,40720,1522,2,529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-26','2022-05-26',600000.00,NULL,NULL,1,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(538,7532,40720,1522,2,530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-30','2022-05-30',390000.00,NULL,NULL,1,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(610,7532,40720,1518,3,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',40000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:37:48','2022-08-17 10:37:48'),(611,7532,40720,1518,3,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',9801000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:37:48','2022-08-17 10:37:48'),(612,7532,40720,1519,3,604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1627825.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(613,7532,40720,1519,3,605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',221000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(614,7532,40720,1519,3,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(615,7532,40720,1519,3,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(616,7532,40720,1519,3,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(617,7532,40720,1519,3,609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(618,7532,40720,1519,3,610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(619,7532,40720,1519,3,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(620,7532,40720,1519,3,612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(621,7532,40720,1519,3,613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(622,7532,40720,1519,3,614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10');
INSERT INTO `balance_libro` VALUES (623,7532,40720,1519,3,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(624,7532,40720,1519,3,616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(625,7532,40720,1519,3,617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(626,7532,40720,1519,3,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(627,7532,40720,1519,3,619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(628,7532,40720,1519,3,620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(629,7532,40720,1519,3,621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(630,7532,40720,1519,3,622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(631,7532,40720,1519,3,623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(632,7532,40720,1519,3,624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(633,7532,40720,1519,3,625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(634,7532,40720,1519,3,626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(635,7532,40720,1519,3,627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(636,7532,40720,1519,3,628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(637,7532,40720,1519,3,629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(638,7532,40720,1519,3,630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(639,7532,40720,1519,3,631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(640,7532,40720,1519,3,632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',35000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(641,7532,40720,1519,3,633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(642,7532,40720,1519,3,634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(643,7532,40720,1519,3,635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(644,7532,40720,1519,3,636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11');
INSERT INTO `balance_libro` VALUES (645,7532,40720,1519,3,637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(646,7532,40720,1519,3,638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(647,7532,40720,1519,3,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',35000.00,NULL,NULL,1,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(648,7532,40720,1519,3,640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',50000.00,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(649,7532,40720,1519,3,641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',75000.00,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(650,7532,40720,1519,3,642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',150312.25,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(651,7532,40720,1519,3,643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',349800.11,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(652,7532,40720,1519,3,644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',207031.00,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(653,7532,40720,1519,3,645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',7439.39,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(654,7532,40720,1519,3,646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',20000.00,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(655,7532,40720,1519,3,647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',5280.00,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(656,7532,40720,1519,3,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',60000.00,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(657,7532,40720,1519,3,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',200000.00,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(658,7532,40720,1519,3,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',1869.11,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(659,7532,40720,1519,3,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',45035.47,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(660,7532,40720,1519,3,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',1000000.00,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(661,7532,40720,1519,3,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',700.00,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(662,7532,40720,1519,3,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',650.00,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(663,7532,40720,1519,3,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',330.00,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(664,7532,40720,1519,3,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',29999.99,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(665,7532,40720,1519,3,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',5100.00,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(666,7532,40720,1519,3,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',160000.01,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11');
INSERT INTO `balance_libro` VALUES (667,7532,40720,1519,3,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1400.01,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(668,7532,40720,1519,3,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',1480.00,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(669,7532,40720,1519,3,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2754.47,NULL,NULL,1,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(670,7532,40720,1519,3,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',199563.14,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(671,7532,40720,1519,3,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',75000.00,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(672,7532,40720,1519,3,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',800000.01,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(673,7532,40720,1519,3,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',12004.99,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(674,7532,40720,1519,3,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',80000.00,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(675,7532,40720,1519,3,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',120.00,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(676,7532,40720,1519,3,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',489560.33,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(677,7532,40720,1519,3,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',19517.36,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(678,7532,40720,1519,3,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',105921.83,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(679,7532,40720,1519,3,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',11316.63,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(680,7532,40720,1519,3,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',175000.00,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(681,7532,40720,1519,3,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',30695.53,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(682,7532,40720,1519,3,674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',30692.37,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(683,7532,40720,1519,3,675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',140000.00,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(684,7532,40720,1519,3,676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',4000.00,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(685,7532,40720,1519,3,677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',3480.00,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(686,7532,40720,1519,3,678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',1160.00,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(687,7532,40720,1519,3,679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',524528.92,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(688,7532,40720,1519,3,680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',34071.49,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11');
INSERT INTO `balance_libro` VALUES (689,7532,40720,1519,3,681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',16302.93,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(690,7532,40720,1519,3,682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',13133.16,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(691,7532,40720,1519,3,683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',40000.00,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(692,7532,40720,1519,3,684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',48000.00,NULL,NULL,1,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(693,7532,40720,1519,3,685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',4455.00,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(694,7532,40720,1519,3,686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',10164.00,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(695,7532,40720,1519,3,687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',3000.00,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(696,7532,40720,1519,3,688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',1700.64,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(697,7532,40720,1519,3,689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',157824.00,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(698,7532,40720,1519,3,690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',289190.00,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(699,7532,40720,1519,3,691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',200847.90,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(700,7532,40720,1519,3,692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',1156.27,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(701,7532,40720,1519,3,693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',400.00,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(702,7532,40720,1519,3,694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',14092.12,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(703,7532,40720,1519,3,695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',850.63,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(704,7532,40720,1519,3,696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',34800.01,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(705,7532,40720,1519,3,697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',3999.99,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(706,7532,40720,1519,3,698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',18200.03,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(707,7532,40720,1519,3,699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',4823.10,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(708,7532,40720,1519,3,700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',1580.75,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(709,7532,40720,1519,3,701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',56771.39,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(710,7532,40720,1519,3,702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',6777.28,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12');
INSERT INTO `balance_libro` VALUES (711,7532,40720,1519,3,703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',7500.00,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(712,7532,40720,1519,3,704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',29999.99,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(713,7532,40720,1519,3,705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',98560.01,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(714,7532,40720,1519,3,706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',238590.00,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(715,7532,40720,1519,3,707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',398000.00,NULL,NULL,1,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(716,7532,40720,1519,3,708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',264850.08,NULL,NULL,1,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(717,7532,40720,1519,3,709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2502.11,NULL,NULL,1,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(718,7532,40720,1519,3,710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',5108.83,NULL,NULL,1,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(719,7532,40720,1519,3,711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',6738.90,NULL,NULL,1,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(720,7532,40720,1519,3,712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',800000.01,NULL,NULL,1,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(721,7532,40720,1519,3,713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',29000.00,NULL,NULL,1,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(722,7532,40720,1519,3,714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',38799.98,NULL,NULL,1,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(723,7532,40720,1519,3,715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7080.00,NULL,NULL,1,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(724,7532,40720,1519,3,716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1750.00,NULL,NULL,1,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(725,7532,40720,1519,3,717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',10510.00,NULL,NULL,1,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(726,7532,40720,1518,3,718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',40000.00,NULL,NULL,1,'2022-08-17 10:38:36','2022-08-17 10:41:06','2022-08-17 10:41:06'),(727,7532,40720,1518,3,719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',9801000.00,NULL,NULL,1,'2022-08-17 10:38:36','2022-08-17 10:41:06','2022-08-17 10:41:06'),(728,7532,40720,1519,3,720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1627825.00,NULL,NULL,1,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(729,7532,40720,1519,3,721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',221000.00,NULL,NULL,1,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(730,7532,40720,1519,3,722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(731,7532,40720,1519,3,723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(732,7532,40720,1519,3,724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13');
INSERT INTO `balance_libro` VALUES (733,7532,40720,1519,3,725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(734,7532,40720,1519,3,726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(735,7532,40720,1519,3,727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(736,7532,40720,1519,3,728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(737,7532,40720,1519,3,729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(738,7532,40720,1519,3,730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(739,7532,40720,1519,3,731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(740,7532,40720,1519,3,732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(741,7532,40720,1519,3,733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(742,7532,40720,1519,3,734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(743,7532,40720,1519,3,735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(744,7532,40720,1519,3,736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(745,7532,40720,1519,3,737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(746,7532,40720,1519,3,738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(747,7532,40720,1519,3,739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(748,7532,40720,1519,3,740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(749,7532,40720,1519,3,741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(750,7532,40720,1519,3,742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(751,7532,40720,1519,3,743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(752,7532,40720,1519,3,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(753,7532,40720,1519,3,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(754,7532,40720,1519,3,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13');
INSERT INTO `balance_libro` VALUES (755,7532,40720,1519,3,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(756,7532,40720,1519,3,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',35000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(757,7532,40720,1519,3,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(758,7532,40720,1519,3,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(759,7532,40720,1519,3,751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(760,7532,40720,1519,3,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(761,7532,40720,1519,3,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(762,7532,40720,1519,3,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(763,7532,40720,1519,3,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',35000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(764,7532,40720,1519,3,756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',50000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(765,7532,40720,1519,3,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',75000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(766,7532,40720,1519,3,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',150312.25,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(767,7532,40720,1519,3,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',349800.11,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(768,7532,40720,1519,3,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',207031.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(769,7532,40720,1519,3,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',7439.39,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(770,7532,40720,1519,3,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',20000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(771,7532,40720,1519,3,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',5280.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(772,7532,40720,1519,3,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',60000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(773,7532,40720,1519,3,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',200000.00,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(774,7532,40720,1519,3,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',1869.11,NULL,NULL,1,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(775,7532,40720,1519,3,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',45035.47,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(776,7532,40720,1519,3,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',1000000.00,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13');
INSERT INTO `balance_libro` VALUES (777,7532,40720,1519,3,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',700.00,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(778,7532,40720,1519,3,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',650.00,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(779,7532,40720,1519,3,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',330.00,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(780,7532,40720,1519,3,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',29999.99,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(781,7532,40720,1519,3,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',5100.00,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(782,7532,40720,1519,3,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',160000.01,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(783,7532,40720,1519,3,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1400.01,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(784,7532,40720,1519,3,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',1480.00,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(785,7532,40720,1519,3,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2754.47,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(786,7532,40720,1519,3,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',199563.14,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(787,7532,40720,1519,3,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',75000.00,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(788,7532,40720,1519,3,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',800000.01,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(789,7532,40720,1519,3,781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',12004.99,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(790,7532,40720,1519,3,782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',80000.00,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(791,7532,40720,1519,3,783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',120.00,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(792,7532,40720,1519,3,784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',489560.33,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(793,7532,40720,1519,3,785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',19517.36,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(794,7532,40720,1519,3,786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',105921.83,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(795,7532,40720,1519,3,787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',11316.63,NULL,NULL,1,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(796,7532,40720,1519,3,788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',175000.00,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(797,7532,40720,1519,3,789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',30695.53,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(798,7532,40720,1519,3,790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',30692.37,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14');
INSERT INTO `balance_libro` VALUES (799,7532,40720,1519,3,791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',140000.00,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(800,7532,40720,1519,3,792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',4000.00,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(801,7532,40720,1519,3,793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',3480.00,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(802,7532,40720,1519,3,794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',1160.00,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(803,7532,40720,1519,3,795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',524528.92,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(804,7532,40720,1519,3,796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',34071.49,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(805,7532,40720,1519,3,797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',16302.93,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(806,7532,40720,1519,3,798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',13133.16,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(807,7532,40720,1519,3,799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',40000.00,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(808,7532,40720,1519,3,800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',48000.00,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(809,7532,40720,1519,3,801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',4455.00,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(810,7532,40720,1519,3,802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',10164.00,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(811,7532,40720,1519,3,803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',3000.00,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(812,7532,40720,1519,3,804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',1700.64,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(813,7532,40720,1519,3,805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',157824.00,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(814,7532,40720,1519,3,806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',289190.00,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(815,7532,40720,1519,3,807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',200847.90,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(816,7532,40720,1519,3,808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',1156.27,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(817,7532,40720,1519,3,809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',400.00,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(818,7532,40720,1519,3,810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',14092.12,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(819,7532,40720,1519,3,811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',850.63,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(820,7532,40720,1519,3,812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',34800.01,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14');
INSERT INTO `balance_libro` VALUES (821,7532,40720,1519,3,813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',3999.99,NULL,NULL,1,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(822,7532,40720,1519,3,814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',18200.03,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(823,7532,40720,1519,3,815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',4823.10,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(824,7532,40720,1519,3,816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',1580.75,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(825,7532,40720,1519,3,817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',56771.39,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(826,7532,40720,1519,3,818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',6777.28,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(827,7532,40720,1519,3,819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',7500.00,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(828,7532,40720,1519,3,820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',29999.99,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(829,7532,40720,1519,3,821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',98560.01,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(830,7532,40720,1519,3,822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',238590.00,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(831,7532,40720,1519,3,823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',398000.00,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(832,7532,40720,1519,3,824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',264850.08,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(833,7532,40720,1519,3,825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2502.11,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(834,7532,40720,1519,3,826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',5108.83,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(835,7532,40720,1519,3,827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',6738.90,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(836,7532,40720,1519,3,828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',800000.01,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(837,7532,40720,1519,3,829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',29000.00,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(838,7532,40720,1519,3,830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',38799.98,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(839,7532,40720,1519,3,831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7080.00,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(840,7532,40720,1519,3,832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1750.00,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(841,7532,40720,1519,3,833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',10510.00,NULL,NULL,1,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(842,7532,40720,1518,3,834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',40000.00,NULL,NULL,1,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08');
INSERT INTO `balance_libro` VALUES (843,7532,40720,1518,3,835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',9801000.00,NULL,NULL,1,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(844,7532,40720,1518,3,836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1627825.00,NULL,NULL,1,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(845,7532,40720,1518,3,837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',221000.00,NULL,NULL,1,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(846,7532,40720,1518,3,838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(847,7532,40720,1518,3,839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(848,7532,40720,1518,3,840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(849,7532,40720,1518,3,841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(850,7532,40720,1518,3,842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(851,7532,40720,1518,3,843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(852,7532,40720,1518,3,844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(853,7532,40720,1518,3,845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(854,7532,40720,1518,3,846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(855,7532,40720,1518,3,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(856,7532,40720,1518,3,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(857,7532,40720,1518,3,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(858,7532,40720,1518,3,850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(859,7532,40720,1518,3,851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(860,7532,40720,1518,3,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 10:52:20','2022-08-17 10:52:20'),(861,7532,40720,1518,3,853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(862,7532,40720,1518,3,854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(863,7532,40720,1518,3,855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(864,7532,40720,1518,3,856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08');
INSERT INTO `balance_libro` VALUES (865,7532,40720,1518,3,857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(866,7532,40720,1518,3,858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(867,7532,40720,1518,3,859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(868,7532,40720,1518,3,860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(869,7532,40720,1518,3,861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(870,7532,40720,1518,3,862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(871,7532,40720,1518,3,863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(872,7532,40720,1518,3,864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',35000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(873,7532,40720,1518,3,865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(874,7532,40720,1518,3,866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(875,7532,40720,1518,3,867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(876,7532,40720,1518,3,868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(877,7532,40720,1518,3,869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(878,7532,40720,1518,3,870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(879,7532,40720,1518,3,871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',35000.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(880,7532,40720,1518,3,872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',50000.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(881,7532,40720,1518,3,873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',75000.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(882,7532,40720,1518,3,874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',150312.25,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(883,7532,40720,1518,3,875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',349800.11,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(884,7532,40720,1518,3,876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',207031.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(885,7532,40720,1518,3,877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',7439.39,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(886,7532,40720,1518,3,878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',20000.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08');
INSERT INTO `balance_libro` VALUES (887,7532,40720,1518,3,879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',5280.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(888,7532,40720,1518,3,880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',60000.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(889,7532,40720,1518,3,881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',200000.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(890,7532,40720,1518,3,882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',1869.11,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(891,7532,40720,1518,3,883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',45035.47,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(892,7532,40720,1518,3,884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',1000000.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(893,7532,40720,1518,3,885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',700.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(894,7532,40720,1518,3,886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',650.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(895,7532,40720,1518,3,887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',330.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(896,7532,40720,1518,3,888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',29999.99,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(897,7532,40720,1518,3,889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',5100.00,NULL,NULL,1,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(898,7532,40720,1518,3,890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',160000.01,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(899,7532,40720,1518,3,891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1400.01,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(900,7532,40720,1518,3,892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',1480.00,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(901,7532,40720,1518,3,893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2754.47,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(902,7532,40720,1518,3,894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',199563.14,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(903,7532,40720,1518,3,895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',75000.00,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(904,7532,40720,1518,3,896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',800000.01,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(905,7532,40720,1518,3,897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',12004.99,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(906,7532,40720,1518,3,898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',80000.00,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(907,7532,40720,1518,3,899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',120.00,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(908,7532,40720,1518,3,900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',489560.33,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09');
INSERT INTO `balance_libro` VALUES (909,7532,40720,1518,3,901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',19517.36,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(910,7532,40720,1518,3,902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',105921.83,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(911,7532,40720,1518,3,903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',11316.63,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(912,7532,40720,1518,3,904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',175000.00,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(913,7532,40720,1518,3,905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',30695.53,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(914,7532,40720,1518,3,906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',30692.37,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(915,7532,40720,1518,3,907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',140000.00,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(916,7532,40720,1518,3,908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',4000.00,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(917,7532,40720,1518,3,909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',3480.00,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(918,7532,40720,1518,3,910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',1160.00,NULL,NULL,1,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(919,7532,40720,1518,3,911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',524528.92,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(920,7532,40720,1518,3,912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',34071.49,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(921,7532,40720,1518,3,913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',16302.93,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(922,7532,40720,1518,3,914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',13133.16,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(923,7532,40720,1518,3,915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',40000.00,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(924,7532,40720,1518,3,916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',48000.00,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(925,7532,40720,1518,3,917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',4455.00,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(926,7532,40720,1518,3,918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',10164.00,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(927,7532,40720,1518,3,919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',3000.00,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(928,7532,40720,1518,3,920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',1700.64,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(929,7532,40720,1518,3,921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',157824.00,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(930,7532,40720,1518,3,922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',289190.00,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09');
INSERT INTO `balance_libro` VALUES (931,7532,40720,1518,3,923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',200847.90,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(932,7532,40720,1518,3,924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',1156.27,NULL,NULL,1,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(933,7532,40720,1518,3,925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',400.00,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(934,7532,40720,1518,3,926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',14092.12,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(935,7532,40720,1518,3,927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',850.63,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(936,7532,40720,1518,3,928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',34800.01,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(937,7532,40720,1518,3,929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',3999.99,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(938,7532,40720,1518,3,930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',18200.03,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(939,7532,40720,1518,3,931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',4823.10,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(940,7532,40720,1518,3,932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',1580.75,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(941,7532,40720,1518,3,933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',56771.39,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(942,7532,40720,1518,3,934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',6777.28,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(943,7532,40720,1518,3,935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',7500.00,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(944,7532,40720,1518,3,936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',29999.99,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(945,7532,40720,1518,3,937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',98560.01,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(946,7532,40720,1518,3,938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',238590.00,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(947,7532,40720,1518,3,939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',398000.00,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(948,7532,40720,1518,3,940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',264850.08,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(949,7532,40720,1518,3,941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2502.11,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(950,7532,40720,1518,3,942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',5108.83,NULL,NULL,1,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(951,7532,40720,1518,3,943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',6738.90,NULL,NULL,1,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(952,7532,40720,1518,3,944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',800000.01,NULL,NULL,1,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09');
INSERT INTO `balance_libro` VALUES (953,7532,40720,1518,3,945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',29000.00,NULL,NULL,1,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(954,7532,40720,1518,3,946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',38799.98,NULL,NULL,1,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(955,7532,40720,1518,3,947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7080.00,NULL,NULL,1,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(956,7532,40720,1518,3,948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1750.00,NULL,NULL,1,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(957,7532,40720,1518,3,949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',10510.00,NULL,NULL,1,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(958,7532,40720,1521,3,950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',301290.00,NULL,NULL,1,'2022-08-17 10:45:12','2022-08-17 10:45:12',NULL),(959,7532,40720,1521,3,951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',403900.00,NULL,NULL,1,'2022-08-17 10:45:12','2022-08-17 10:45:12',NULL),(960,7532,40720,1521,3,952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1627825.00,NULL,NULL,1,'2022-08-17 10:45:12','2022-08-17 10:45:12',NULL),(961,7532,40720,1521,3,953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',221000.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(962,7532,40720,1521,3,954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',2540.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(963,7532,40720,1521,3,955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',1060.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(964,7532,40720,1521,3,956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',35000.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(965,7532,40720,1521,3,957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',50000.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(966,7532,40720,1521,3,958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',60000.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(967,7532,40720,1521,3,959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',75000.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(968,7532,40720,1521,3,960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',75000.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(969,7532,40720,1521,3,961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',50000.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(970,7532,40720,1521,3,962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',100000.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(971,7532,40720,1521,3,963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',50000.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(972,7532,40720,1521,3,964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-01','2022-04-01',50000.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(973,7532,40720,1521,3,965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-02','2022-04-02',233530.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(974,7532,40720,1521,3,966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',240790.00,NULL,NULL,1,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(975,7532,40720,1521,3,967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',74750.00,NULL,NULL,1,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(976,7532,40720,1521,3,968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',105000.00,NULL,NULL,1,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL);
INSERT INTO `balance_libro` VALUES (977,7532,40720,1521,3,969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',74750.00,NULL,NULL,1,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(978,7532,40720,1521,3,970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',105000.00,NULL,NULL,1,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(979,7532,40720,1521,3,971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',74750.00,NULL,NULL,1,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(980,7532,40720,1521,3,972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',105000.00,NULL,NULL,1,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(981,7532,40720,1521,3,973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',940.00,NULL,NULL,1,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(982,7532,40720,1521,3,974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',12619.96,NULL,NULL,1,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(983,7532,40720,1521,3,975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',5000.00,NULL,NULL,1,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(984,7532,40720,1521,3,976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',169770.01,NULL,NULL,1,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(985,7532,40720,1521,3,977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',1440.09,NULL,NULL,1,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(986,7532,40720,1521,3,978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',223.00,NULL,NULL,1,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(987,7532,40720,1521,3,979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',1350.00,NULL,NULL,1,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(988,7532,40720,1521,3,980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',35000.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(989,7532,40720,1521,3,981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',75000.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(990,7532,40720,1521,3,982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',75000.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(991,7532,40720,1521,3,983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',30000.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(992,7532,40720,1521,3,984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',65000.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(993,7532,40720,1521,3,985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',75000.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(994,7532,40720,1521,3,986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',40000.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(995,7532,40720,1521,3,987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',35000.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(996,7532,40720,1521,3,988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',224939.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(997,7532,40720,1521,3,989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',13000.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(998,7532,40720,1521,3,990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',10384.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(999,7532,40720,1521,3,991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',6635.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(1000,7532,40720,1521,3,992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',140000.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(1001,7532,40720,1521,3,993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL);
INSERT INTO `balance_libro` VALUES (1002,7532,40720,1521,3,994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(1003,7532,40720,1521,3,995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(1004,7532,40720,1521,3,996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1005,7532,40720,1521,3,997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1006,7532,40720,1521,3,998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1007,7532,40720,1521,3,999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1008,7532,40720,1521,3,1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',25000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1009,7532,40720,1521,3,1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1010,7532,40720,1521,3,1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1011,7532,40720,1521,3,1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',25000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1012,7532,40720,1521,3,1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1013,7532,40720,1521,3,1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1014,7532,40720,1521,3,1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1015,7532,40720,1521,3,1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1016,7532,40720,1521,3,1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1017,7532,40720,1521,3,1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1018,7532,40720,1521,3,1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1019,7532,40720,1521,3,1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1020,7532,40720,1521,3,1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',25000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1021,7532,40720,1521,3,1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1022,7532,40720,1521,3,1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1023,7532,40720,1521,3,1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',25000.00,NULL,NULL,1,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(1024,7532,40720,1521,3,1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1025,7532,40720,1521,3,1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',35000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL);
INSERT INTO `balance_libro` VALUES (1026,7532,40720,1521,3,1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',25000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1027,7532,40720,1521,3,1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',25000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1028,7532,40720,1521,3,1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1029,7532,40720,1521,3,1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',25000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1030,7532,40720,1521,3,1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',25000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1031,7532,40720,1521,3,1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1032,7532,40720,1521,3,1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',25000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1033,7532,40720,1521,3,1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1034,7532,40720,1521,3,1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',20000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1035,7532,40720,1521,3,1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-05','2022-04-05',35000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1036,7532,40720,1521,3,1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',5880.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1037,7532,40720,1521,3,1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',3800.01,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1038,7532,40720,1521,3,1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-06','2022-04-06',19283.62,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1039,7532,40720,1521,3,1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',3539.63,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1040,7532,40720,1521,3,1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',4000.02,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1041,7532,40720,1521,3,1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',899.97,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1042,7532,40720,1521,3,1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',30000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1043,7532,40720,1521,3,1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-07','2022-04-07',25000.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1044,7532,40720,1521,3,1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-08','2022-04-08',55055.00,NULL,NULL,1,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(1045,7532,40720,1521,3,1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',160000.01,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1046,7532,40720,1521,3,1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',13000.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1047,7532,40720,1521,3,1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',27446.29,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1048,7532,40720,1521,3,1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',60000.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1049,7532,40720,1521,3,1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-11','2022-04-11',60000.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL);
INSERT INTO `balance_libro` VALUES (1050,7532,40720,1521,3,1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',3120.01,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1051,7532,40720,1521,3,1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',28137.83,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1052,7532,40720,1521,3,1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',150000.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1053,7532,40720,1521,3,1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12','2022-04-12',4897.56,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1054,7532,40720,1521,3,1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',190000.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1055,7532,40720,1521,3,1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',30238.43,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1056,7532,40720,1521,3,1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',75434.69,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1057,7532,40720,1521,3,1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',24417.10,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1058,7532,40720,1521,3,1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',340000.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1059,7532,40720,1521,3,1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',140000.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1060,7532,40720,1521,3,1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-13','2022-04-13',520.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1061,7532,40720,1521,3,1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',45000.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1062,7532,40720,1521,3,1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-14','2022-04-14',60000.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1063,7532,40720,1521,3,1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',1210000.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1064,7532,40720,1521,3,1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-16','2022-04-16',5000.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1065,7532,40720,1521,3,1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-18','2022-04-18',25000.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1066,7532,40720,1521,3,1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',460257.00,NULL,NULL,1,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(1067,7532,40720,1521,3,1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',12520.00,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1068,7532,40720,1521,3,1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',1913.74,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1069,7532,40720,1521,3,1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',1913.74,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1070,7532,40720,1521,3,1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',2000.01,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1071,7532,40720,1521,3,1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',1750.01,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1072,7532,40720,1521,3,1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-19','2022-04-19',2600.00,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1073,7532,40720,1521,3,1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',46931.48,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL);
INSERT INTO `balance_libro` VALUES (1074,7532,40720,1521,3,1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',351900.00,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1075,7532,40720,1521,3,1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',354046.00,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1076,7532,40720,1521,3,1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',177421.28,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1077,7532,40720,1521,3,1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-20','2022-04-20',60000.00,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1078,7532,40720,1521,3,1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',487.68,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1079,7532,40720,1521,3,1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',2522.04,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1080,7532,40720,1521,3,1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',150000.00,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1081,7532,40720,1521,3,1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-21','2022-04-21',150000.00,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1082,7532,40720,1521,3,1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',2400.00,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1083,7532,40720,1521,3,1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',1450.02,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1084,7532,40720,1521,3,1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',29036.36,NULL,NULL,1,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(1085,7532,40720,1521,3,1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',2046.72,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1086,7532,40720,1521,3,1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',100000.00,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1087,7532,40720,1521,3,1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',89300.00,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1088,7532,40720,1521,3,1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-22','2022-04-22',89000.00,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1089,7532,40720,1521,3,1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',36300.00,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1090,7532,40720,1521,3,1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',60000.00,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1091,7532,40720,1521,3,1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',25000.00,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1092,7532,40720,1521,3,1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',25000.00,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1093,7532,40720,1521,3,1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',25000.00,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1094,7532,40720,1521,3,1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',25000.00,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1095,7532,40720,1521,3,1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',20000.00,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1096,7532,40720,1521,3,1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',40000.00,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1097,7532,40720,1521,3,1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-25','2022-04-25',25000.00,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL);
INSERT INTO `balance_libro` VALUES (1098,7532,40720,1521,3,1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',2530.00,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1099,7532,40720,1521,3,1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',33899.84,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1100,7532,40720,1521,3,1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',7439.39,NULL,NULL,1,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(1101,7532,40720,1521,3,1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',1584.95,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1102,7532,40720,1521,3,1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-26','2022-04-26',12075.34,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1103,7532,40720,1521,3,1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',61500.00,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1104,7532,40720,1521,3,1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',33060.06,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1105,7532,40720,1521,3,1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',3240.19,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1106,7532,40720,1521,3,1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',2243.78,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1107,7532,40720,1521,3,1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',150000.00,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1108,7532,40720,1521,3,1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',35000.00,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1109,7532,40720,1521,3,1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',466800.00,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1110,7532,40720,1521,3,1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',434000.04,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1111,7532,40720,1521,3,1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',220000.00,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1112,7532,40720,1521,3,1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',700.00,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1113,7532,40720,1521,3,1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2047.44,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1114,7532,40720,1521,3,1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',100000.00,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1115,7532,40720,1521,3,1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',55000.00,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1116,7532,40720,1521,3,1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',120000.00,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1117,7532,40720,1521,3,1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1210000.00,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1118,7532,40720,1521,3,1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',96250.01,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1119,7532,40720,1521,3,1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2000.01,NULL,NULL,1,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(1120,7532,40720,1518,3,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 10:52:20','2022-08-17 11:02:08','2022-08-17 11:02:08'),(1121,7532,40720,1518,3,1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',40000.00,NULL,NULL,1,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49');
INSERT INTO `balance_libro` VALUES (1122,7532,40720,1518,3,1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',9801000.00,NULL,NULL,1,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1123,7532,40720,1518,3,1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1627825.00,NULL,NULL,1,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1124,7532,40720,1518,3,1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',221000.00,NULL,NULL,1,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1125,7532,40720,1518,3,1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1126,7532,40720,1518,3,1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1127,7532,40720,1518,3,1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1128,7532,40720,1518,3,1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1129,7532,40720,1518,3,1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1130,7532,40720,1518,3,1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1131,7532,40720,1518,3,1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1132,7532,40720,1518,3,1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1133,7532,40720,1518,3,1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1134,7532,40720,1518,3,1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1135,7532,40720,1518,3,1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1136,7532,40720,1518,3,1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1137,7532,40720,1518,3,1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1138,7532,40720,1518,3,1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1139,7532,40720,1518,3,1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1140,7532,40720,1518,3,1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1141,7532,40720,1518,3,1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1142,7532,40720,1518,3,1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1143,7532,40720,1518,3,1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49');
INSERT INTO `balance_libro` VALUES (1144,7532,40720,1518,3,1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1145,7532,40720,1518,3,1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1146,7532,40720,1518,3,1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1147,7532,40720,1518,3,1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1148,7532,40720,1518,3,1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1149,7532,40720,1518,3,1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(1150,7532,40720,1518,3,1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1151,7532,40720,1518,3,1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',35000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1152,7532,40720,1518,3,1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1153,7532,40720,1518,3,1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:02:46','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1154,7532,40720,1518,3,1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1155,7532,40720,1518,3,1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1156,7532,40720,1518,3,1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1157,7532,40720,1518,3,1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1158,7532,40720,1518,3,1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',35000.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1159,7532,40720,1518,3,1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',50000.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1160,7532,40720,1518,3,1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',75000.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1161,7532,40720,1518,3,1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',150312.25,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1162,7532,40720,1518,3,1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',349800.11,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1163,7532,40720,1518,3,1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',207031.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1164,7532,40720,1518,3,1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',7439.39,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1165,7532,40720,1518,3,1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',20000.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50');
INSERT INTO `balance_libro` VALUES (1166,7532,40720,1518,3,1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',5280.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1167,7532,40720,1518,3,1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',60000.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1168,7532,40720,1518,3,1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',200000.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1169,7532,40720,1518,3,1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',1869.11,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1170,7532,40720,1518,3,1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',45035.47,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1171,7532,40720,1518,3,1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',1000000.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1172,7532,40720,1518,3,1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',700.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1173,7532,40720,1518,3,1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',650.00,NULL,NULL,1,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1174,7532,40720,1518,3,1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',330.00,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1175,7532,40720,1518,3,1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',29999.99,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1176,7532,40720,1518,3,1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',5100.00,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1177,7532,40720,1518,3,1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',160000.01,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1178,7532,40720,1518,3,1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1400.01,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1179,7532,40720,1518,3,1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',1480.00,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1180,7532,40720,1518,3,1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2754.47,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1181,7532,40720,1518,3,1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',199563.14,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1182,7532,40720,1518,3,1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',75000.00,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1183,7532,40720,1518,3,1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',800000.01,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1184,7532,40720,1518,3,1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',12004.99,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1185,7532,40720,1518,3,1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',80000.00,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1186,7532,40720,1518,3,1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',120.00,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1187,7532,40720,1518,3,1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',489560.33,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50');
INSERT INTO `balance_libro` VALUES (1188,7532,40720,1518,3,1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',19517.36,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1189,7532,40720,1518,3,1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',105921.83,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1190,7532,40720,1518,3,1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',11316.63,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1191,7532,40720,1518,3,1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',175000.00,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1192,7532,40720,1518,3,1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',30695.53,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1193,7532,40720,1518,3,1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',30692.37,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1194,7532,40720,1518,3,1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',140000.00,NULL,NULL,1,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1195,7532,40720,1518,3,1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',4000.00,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1196,7532,40720,1518,3,1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',3480.00,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1197,7532,40720,1518,3,1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',1160.00,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1198,7532,40720,1518,3,1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',524528.92,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1199,7532,40720,1518,3,1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',34071.49,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1200,7532,40720,1518,3,1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',16302.93,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1201,7532,40720,1518,3,1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',13133.16,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1202,7532,40720,1518,3,1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',40000.00,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1203,7532,40720,1518,3,1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',48000.00,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1204,7532,40720,1518,3,1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',4455.00,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1205,7532,40720,1518,3,1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',10164.00,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1206,7532,40720,1518,3,1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',3000.00,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1207,7532,40720,1518,3,1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',1700.64,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1208,7532,40720,1518,3,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',157824.00,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1209,7532,40720,1518,3,1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',289190.00,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50');
INSERT INTO `balance_libro` VALUES (1210,7532,40720,1518,3,1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',200847.90,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1211,7532,40720,1518,3,1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',1156.27,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1212,7532,40720,1518,3,1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',400.00,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1213,7532,40720,1518,3,1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',14092.12,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1214,7532,40720,1518,3,1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',850.63,NULL,NULL,1,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1215,7532,40720,1518,3,1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',34800.01,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1216,7532,40720,1518,3,1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',3999.99,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1217,7532,40720,1518,3,1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',18200.03,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1218,7532,40720,1518,3,1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',4823.10,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1219,7532,40720,1518,3,1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',1580.75,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1220,7532,40720,1518,3,1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',56771.39,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(1221,7532,40720,1518,3,1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',6777.28,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1222,7532,40720,1518,3,1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',7500.00,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1223,7532,40720,1518,3,1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',29999.99,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1224,7532,40720,1518,3,1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',98560.01,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1225,7532,40720,1518,3,1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',238590.00,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1226,7532,40720,1518,3,1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',398000.00,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1227,7532,40720,1518,3,1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',264850.08,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1228,7532,40720,1518,3,1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2502.11,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1229,7532,40720,1518,3,1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',5108.83,NULL,NULL,1,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1230,7532,40720,1518,3,1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',6738.90,NULL,NULL,1,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1231,7532,40720,1518,3,1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',800000.01,NULL,NULL,1,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51');
INSERT INTO `balance_libro` VALUES (1232,7532,40720,1518,3,1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',29000.00,NULL,NULL,1,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1233,7532,40720,1518,3,1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',38799.98,NULL,NULL,1,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1234,7532,40720,1518,3,1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7080.00,NULL,NULL,1,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1235,7532,40720,1518,3,1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1750.00,NULL,NULL,1,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1236,7532,40720,1518,3,1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',10510.00,NULL,NULL,1,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(1237,7532,40720,1518,3,1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',29999.99,NULL,NULL,1,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(1238,7532,40720,1518,3,1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',160000.01,NULL,NULL,1,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(1239,7532,40720,1518,3,1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',800000.01,NULL,NULL,1,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(1240,7532,40720,1518,3,1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-29','2022-01-29',800000.01,NULL,NULL,1,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(1241,7532,40720,1518,3,1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',9801000.00,NULL,NULL,1,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(1242,7532,40720,1518,3,1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',850.63,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1243,7532,40720,1518,3,1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',34800.01,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1244,7532,40720,1518,3,1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',140000.00,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1245,7532,40720,1518,3,1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',150312.25,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1246,7532,40720,1518,3,1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',349800.11,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1247,7532,40720,1518,3,1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',207031.00,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1248,7532,40720,1518,3,1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',98560.01,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1249,7532,40720,1518,3,1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',238590.00,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1250,7532,40720,1518,3,1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',398000.00,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1251,7532,40720,1518,3,1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',264850.07,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1252,7532,40720,1518,3,1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',1000000.00,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1253,7532,40720,1518,3,1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',1627825.00,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1254,7532,40720,1518,3,1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',221000.00,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1255,7532,40720,1518,3,1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',10164.00,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL);
INSERT INTO `balance_libro` VALUES (1256,7532,40720,1518,3,1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',29000.00,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1257,7532,40720,1518,3,1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',289190.00,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1258,7532,40720,1518,3,1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',200847.90,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1259,7532,40720,1518,3,1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',38799.98,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1260,7532,40720,1518,3,1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',1156.27,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1261,7532,40720,1518,3,1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',3000.00,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1262,7532,40720,1518,3,1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',3999.99,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1263,7532,40720,1518,3,1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',700.00,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1264,7532,40720,1518,3,1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',650.00,NULL,NULL,1,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(1265,7532,40720,1518,3,1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',330.00,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1266,7532,40720,1518,3,1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',1480.00,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1267,7532,40720,1518,3,1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',120.00,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1268,7532,40720,1518,3,1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',400.00,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1269,7532,40720,1518,3,1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',29999.99,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1270,7532,40720,1518,3,1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',4000.00,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1271,7532,40720,1518,3,1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',18200.03,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1272,7532,40720,1518,3,1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',4455.00,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1273,7532,40720,1518,3,1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',5100.00,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1274,7532,40720,1518,3,1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',7080.00,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1275,7532,40720,1518,3,1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',3480.00,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1276,7532,40720,1518,3,1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',1160.00,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1277,7532,40720,1518,3,1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',12004.99,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1278,7532,40720,1518,3,1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1750.00,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1279,7532,40720,1518,3,1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',1700.64,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL);
INSERT INTO `balance_libro` VALUES (1280,7532,40720,1518,3,1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',4823.10,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1281,7532,40720,1518,3,1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',489560.33,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1282,7532,40720,1518,3,1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',524528.92,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1283,7532,40720,1518,3,1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',7439.40,NULL,NULL,1,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(1284,7532,40720,1518,3,1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',5280.00,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1285,7532,40720,1518,3,1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',1400.00,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1286,7532,40720,1518,3,1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',14092.13,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1287,7532,40720,1518,3,1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',19517.36,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1288,7532,40720,1518,3,1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',1900.00,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1289,7532,40720,1518,3,1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2800.00,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1290,7532,40720,1518,3,1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',34000.00,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1291,7532,40720,1518,3,1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',1607.11,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1292,7532,40720,1518,3,1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',105921.83,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1293,7532,40720,1518,3,1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',11316.63,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1294,7532,40720,1518,3,1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',56771.39,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1295,7532,40720,1518,3,1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',175000.00,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1296,7532,40720,1518,3,1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',6777.28,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1297,7532,40720,1518,3,1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',199563.14,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1298,7532,40720,1518,3,1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',30692.37,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1299,7532,40720,1518,3,1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',5108.83,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1300,7532,40720,1518,3,1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',6738.90,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1301,7532,40720,1518,3,1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',16302.93,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1302,7532,40720,1518,3,1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',13133.16,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(1303,7532,40720,1518,3,1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',45035.47,NULL,NULL,1,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL);
INSERT INTO `balance_libro` VALUES (1304,7532,40720,1518,3,1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',30695.53,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1305,7532,40720,1518,3,1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',2502.11,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1306,7532,40720,1518,3,1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1307,7532,40720,1518,3,1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1308,7532,40720,1518,3,1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1309,7532,40720,1518,3,1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1310,7532,40720,1518,3,1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1311,7532,40720,1518,3,1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1312,7532,40720,1518,3,1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1313,7532,40720,1518,3,1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1314,7532,40720,1518,3,1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1315,7532,40720,1518,3,1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1316,7532,40720,1518,3,1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1317,7532,40720,1518,3,1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1318,7532,40720,1518,3,1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1319,7532,40720,1518,3,1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(1320,7532,40720,1518,3,1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1321,7532,40720,1518,3,1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1322,7532,40720,1518,3,1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1323,7532,40720,1518,3,1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1324,7532,40720,1518,3,1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1325,7532,40720,1518,3,1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1326,7532,40720,1518,3,1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1327,7532,40720,1518,3,1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL);
INSERT INTO `balance_libro` VALUES (1328,7532,40720,1518,3,1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1329,7532,40720,1518,3,1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1330,7532,40720,1518,3,1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',35000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1331,7532,40720,1518,3,1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1332,7532,40720,1518,3,1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1333,7532,40720,1518,3,1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1334,7532,40720,1518,3,1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1335,7532,40720,1518,3,1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(1336,7532,40720,1518,3,1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',40000.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1337,7532,40720,1518,3,1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',40000.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1338,7532,40720,1518,3,1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',60000.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1339,7532,40720,1518,3,1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1340,7532,40720,1518,3,1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',25000.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1341,7532,40720,1518,3,1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20000.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1342,7532,40720,1518,3,1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',20000.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1343,7532,40720,1518,3,1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',48000.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1344,7532,40720,1518,3,1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',157824.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1345,7532,40720,1518,3,1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',10510.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1346,7532,40720,1518,3,1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',50000.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1347,7532,40720,1518,3,1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',80000.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1348,7532,40720,1518,3,1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',7500.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1349,7532,40720,1518,3,1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',35000.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1350,7532,40720,1518,3,1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-09','2022-01-09',200000.00,NULL,NULL,1,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(1351,7532,40720,1519,3,1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',35947.90,NULL,NULL,1,'2022-08-17 11:22:24','2022-08-17 11:22:24',NULL);
INSERT INTO `balance_libro` VALUES (1352,7532,40720,1519,3,1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',160000.01,NULL,NULL,1,'2022-08-17 11:22:24','2022-08-17 11:22:24',NULL),(1353,7532,40720,1519,3,1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',4950.11,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1354,7532,40720,1519,3,1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',800000.01,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1355,7532,40720,1519,3,1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',196020.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1356,7532,40720,1519,3,1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',80000.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1357,7532,40720,1519,3,1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',301000.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1358,7532,40720,1519,3,1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',99000.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1359,7532,40720,1519,3,1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',200000.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1360,7532,40720,1519,3,1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',349900.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1361,7532,40720,1519,3,1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',98650.01,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1362,7532,40720,1519,3,1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',1627825.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1363,7532,40720,1519,3,1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',221000.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1364,7532,40720,1519,3,1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',21200.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1365,7532,40720,1519,3,1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',3300.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1366,7532,40720,1519,3,1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16','2022-02-16',8109.98,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1367,7532,40720,1519,3,1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',27800.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1368,7532,40720,1519,3,1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',2760.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1369,7532,40720,1519,3,1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1900.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1370,7532,40720,1519,3,1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',16000.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1371,7532,40720,1519,3,1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',677.00,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1372,7532,40720,1519,3,1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',5989.98,NULL,NULL,1,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(1373,7532,40720,1519,3,1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',3250.00,NULL,NULL,1,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(1374,7532,40720,1519,3,1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',4924.31,NULL,NULL,1,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(1375,7532,40720,1519,3,1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',15000.01,NULL,NULL,1,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL);
INSERT INTO `balance_libro` VALUES (1376,7532,40720,1519,3,1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',5255.77,NULL,NULL,1,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(1377,7532,40720,1519,3,1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',64500.01,NULL,NULL,1,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(1378,7532,40720,1519,3,1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-18','2022-02-18',33799.99,NULL,NULL,1,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(1379,7532,40720,1519,3,1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',6000.01,NULL,NULL,1,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(1380,7532,40720,1519,3,1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',3000.00,NULL,NULL,1,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(1381,7532,40720,1519,3,1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-17','2022-02-17',17210.00,NULL,NULL,1,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(1382,7532,40720,1519,3,1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',3154.75,NULL,NULL,1,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(1383,7532,40720,1519,3,1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',1512.02,NULL,NULL,1,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(1384,7532,40720,1519,3,1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',2820.00,NULL,NULL,1,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(1385,7532,40720,1519,3,1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',340.42,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1386,7532,40720,1519,3,1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',1978.51,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1387,7532,40720,1519,3,1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',115650.00,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1388,7532,40720,1519,3,1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',19979.52,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1389,7532,40720,1519,3,1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',7699.99,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1390,7532,40720,1519,3,1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',3879.97,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1391,7532,40720,1519,3,1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',2580.00,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1392,7532,40720,1519,3,1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-08','2022-02-08',4599.99,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1393,7532,40720,1519,3,1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',199999.98,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1394,7532,40720,1519,3,1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-03','2022-02-03',17583.14,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1395,7532,40720,1519,3,1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',1573.93,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1396,7532,40720,1519,3,1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23','2022-02-23',1350.00,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1397,7532,40720,1519,3,1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21','2022-02-21',2163.82,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1398,7532,40720,1519,3,1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',2163.82,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(1399,7532,40720,1519,3,1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',20000.00,NULL,NULL,1,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL);
INSERT INTO `balance_libro` VALUES (1400,7532,40720,1519,3,1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(1401,7532,40720,1519,3,1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(1402,7532,40720,1519,3,1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(1403,7532,40720,1519,3,1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(1404,7532,40720,1519,3,1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(1405,7532,40720,1519,3,1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(1406,7532,40720,1519,3,1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(1407,7532,40720,1519,3,1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(1408,7532,40720,1519,3,1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(1409,7532,40720,1519,3,1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(1410,7532,40720,1519,3,1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(1411,7532,40720,1519,3,1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(1412,7532,40720,1519,3,1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',40000.00,NULL,NULL,1,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(1413,7532,40720,1519,3,1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(1414,7532,40720,1519,3,1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(1415,7532,40720,1519,3,1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(1416,7532,40720,1519,3,1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(1417,7532,40720,1519,3,1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(1418,7532,40720,1519,3,1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(1419,7532,40720,1519,3,1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(1420,7532,40720,1519,3,1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(1421,7532,40720,1519,3,1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(1422,7532,40720,1519,3,1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(1423,7532,40720,1519,3,1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL);
INSERT INTO `balance_libro` VALUES (1424,7532,40720,1519,3,1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',35000.00,NULL,NULL,1,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(1425,7532,40720,1519,3,1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(1426,7532,40720,1519,3,1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(1427,7532,40720,1519,3,1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(1428,7532,40720,1519,3,1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(1429,7532,40720,1519,3,1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(1430,7532,40720,1519,3,1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',40000.00,NULL,NULL,1,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(1431,7532,40720,1519,3,1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',60000.00,NULL,NULL,1,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(1432,7532,40720,1519,3,1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',40000.00,NULL,NULL,1,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(1433,7532,40720,1519,3,1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(1434,7532,40720,1519,3,1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(1435,7532,40720,1519,3,1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(1436,7532,40720,1519,3,1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(1437,7532,40720,1519,3,1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(1438,7532,40720,1519,3,1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',24000.00,NULL,NULL,1,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(1439,7532,40720,1519,3,1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',40000.00,NULL,NULL,1,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(1440,7532,40720,1519,3,1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(1441,7532,40720,1519,3,1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(1442,7532,40720,1519,3,1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',20000.00,NULL,NULL,1,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(1443,7532,40720,1519,3,1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',20000.00,NULL,NULL,1,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(1444,7532,40720,1519,3,1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',25000.00,NULL,NULL,1,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(1445,7532,40720,1519,3,1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',960.00,NULL,NULL,1,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(1446,7532,40720,1519,3,1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-04','2022-02-04',50000.00,NULL,NULL,1,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(1447,7532,40720,1519,3,1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',720.00,NULL,NULL,1,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL);
INSERT INTO `balance_libro` VALUES (1448,7532,40720,1519,3,1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',3850.00,NULL,NULL,1,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(1449,7532,40720,1519,3,1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',40000.00,NULL,NULL,1,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(1450,7532,40720,1519,3,1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',35000.00,NULL,NULL,1,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(1451,7532,40720,1519,3,1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-01','2022-02-01',75000.00,NULL,NULL,1,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(1452,7532,40720,1519,3,1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-14','2022-02-14',50000.00,NULL,NULL,1,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(1453,7532,40720,1519,3,1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-11','2022-02-11',25000.00,NULL,NULL,1,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(1454,7532,40720,1519,2,1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',600000.00,NULL,NULL,1,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(1455,7532,40720,1519,2,1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-02','2022-02-02',600000.00,NULL,NULL,1,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(1456,7532,40720,1519,2,1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',585000.01,NULL,NULL,1,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(1457,7532,40720,1519,2,1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-07','2022-02-07',710000.00,NULL,NULL,1,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(1458,7532,40720,1519,2,1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',720000.00,NULL,NULL,1,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(1459,7532,40720,1519,2,1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',720000.00,NULL,NULL,1,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(1460,7532,40720,1519,2,1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',600000.00,NULL,NULL,1,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(1461,7532,40720,1519,2,1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-09','2022-02-09',1450000.00,NULL,NULL,1,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(1462,7532,40720,1519,2,1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',2100000.00,NULL,NULL,1,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(1463,7532,40720,1519,2,1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',890000.00,NULL,NULL,1,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(1464,7532,40720,1519,2,1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',820000.00,NULL,NULL,1,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(1465,7532,40720,1519,2,1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',430000.00,NULL,NULL,1,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(1466,7532,40720,1519,2,1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',420000.00,NULL,NULL,1,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(1467,7532,40720,1519,2,1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-15','2022-02-15',650000.00,NULL,NULL,1,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(1468,7532,40720,1519,2,1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',820000.00,NULL,NULL,1,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(1469,7532,40720,1519,2,1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-22','2022-02-22',520000.00,NULL,NULL,1,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(1470,7532,40720,1519,2,1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',390000.00,NULL,NULL,1,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(1471,7532,40720,1519,2,1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-24','2022-02-24',250000.00,NULL,NULL,1,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL);
INSERT INTO `balance_libro` VALUES (1472,7532,40720,1519,2,1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-25','2022-02-25',600000.00,NULL,NULL,1,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4185 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,7532,1,40720,1524,2,218,2,55000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(2,7532,1,40720,1524,2,13,1,55000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(3,7532,2,40720,1524,2,96,2,454545.45,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(4,7532,2,40720,1524,2,67,2,95454.54,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(5,7532,2,40720,1524,2,13,1,549999.99,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(6,7532,3,40720,1524,2,96,2,454545.45,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(7,7532,3,40720,1524,2,67,2,95454.54,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(8,7532,3,40720,1524,2,13,1,549999.99,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(9,7532,4,40720,1524,2,218,2,55000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(10,7532,4,40720,1524,2,13,1,55000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(11,7532,5,40720,1524,2,218,2,55000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(12,7532,5,40720,1524,2,13,1,55000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(13,7532,6,40720,1524,2,218,2,35000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(14,7532,6,40720,1524,2,13,1,35000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(15,7532,7,40720,1524,2,96,2,3223.14,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(16,7532,7,40720,1524,2,67,2,676.86,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(17,7532,7,40720,1524,2,13,1,3900.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(18,7532,8,40720,1524,2,96,2,15000.06,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(19,7532,8,40720,1524,2,67,2,3150.01,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(20,7532,8,40720,1524,2,13,1,18150.07,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(21,7532,9,40720,1524,2,218,2,150000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(22,7532,9,40720,1524,2,13,1,150000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(23,7532,10,40720,1524,2,96,2,1614371.88,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(24,7532,10,40720,1524,2,67,2,339018.09,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(25,7532,10,40720,1524,2,13,1,1953389.97,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(26,7532,11,40720,1524,2,96,2,182644.63,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(27,7532,11,40720,1524,2,67,2,38355.37,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(28,7532,11,40720,1524,2,13,1,221000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(29,7532,12,40720,1524,2,96,2,12450.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(30,7532,12,40720,1524,2,67,2,2614.50,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(31,7532,12,40720,1524,2,13,1,15064.50,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(32,7532,13,40720,1524,2,218,2,35000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(33,7532,13,40720,1524,2,13,1,35000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(34,7532,14,40720,1524,2,218,2,60000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(35,7532,14,40720,1524,2,13,1,60000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(36,7532,15,40720,1524,2,218,2,55000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10');
INSERT INTO `balance_libro_details` VALUES (37,7532,15,40720,1524,2,13,1,55000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(38,7532,16,40720,1524,2,218,2,35000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(39,7532,16,40720,1524,2,13,1,35000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(40,7532,17,40720,1524,2,218,2,100000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(41,7532,17,40720,1524,2,13,1,100000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(42,7532,18,40720,1524,2,96,2,5000.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(43,7532,18,40720,1524,2,67,2,1050.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(44,7532,18,40720,1524,2,13,1,6050.00,NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(45,7532,19,40720,1524,2,218,2,55000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(46,7532,19,40720,1524,2,13,1,55000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(47,7532,20,40720,1524,2,218,2,55000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(48,7532,20,40720,1524,2,13,1,55000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(49,7532,21,40720,1524,2,96,2,7827.28,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(50,7532,21,40720,1524,2,67,2,1643.73,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(51,7532,21,40720,1524,2,13,1,9471.01,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(52,7532,22,40720,1524,2,218,2,168000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(53,7532,22,40720,1524,2,13,1,168000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(54,7532,23,40720,1524,2,218,2,408000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(55,7532,23,40720,1524,2,13,1,408000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(56,7532,24,40720,1524,2,218,2,30000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(57,7532,24,40720,1524,2,13,1,30000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(58,7532,25,40720,1524,2,96,2,10650.41,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(59,7532,25,40720,1524,2,67,2,2236.58,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(60,7532,25,40720,1524,2,218,2,213.01,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(61,7532,25,40720,1524,2,13,1,13100.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(62,7532,26,40720,1524,2,218,2,75000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(63,7532,26,40720,1524,2,13,1,75000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(64,7532,27,40720,1524,2,218,2,25000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(65,7532,27,40720,1524,2,13,1,25000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(66,7532,28,40720,1524,2,96,2,11762.94,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(67,7532,28,40720,1524,2,67,2,2470.22,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(68,7532,28,40720,1524,2,13,1,14233.16,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(69,7532,29,40720,1524,2,218,2,40000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(70,7532,29,40720,1524,2,13,1,40000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(71,7532,30,40720,1524,2,218,2,75000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(72,7532,30,40720,1524,2,13,1,75000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10');
INSERT INTO `balance_libro_details` VALUES (73,7532,31,40720,1524,2,218,2,40000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(74,7532,31,40720,1524,2,13,1,40000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(75,7532,32,40720,1524,2,96,2,1495.87,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(76,7532,32,40720,1524,2,67,2,314.13,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(77,7532,32,40720,1524,2,13,1,1810.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(78,7532,33,40720,1524,2,218,2,25000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(79,7532,33,40720,1524,2,13,1,25000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(80,7532,34,40720,1524,2,218,2,30000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(81,7532,34,40720,1524,2,13,1,30000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(82,7532,35,40720,1524,2,218,2,30000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(83,7532,35,40720,1524,2,13,1,30000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(84,7532,36,40720,1524,2,96,2,10214.88,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(85,7532,36,40720,1524,2,67,2,2145.12,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(86,7532,36,40720,1524,2,13,1,12360.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(87,7532,37,40720,1524,2,218,2,50000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(88,7532,37,40720,1524,2,13,1,50000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(89,7532,38,40720,1524,2,218,2,60000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(90,7532,38,40720,1524,2,13,1,60000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(91,7532,39,40720,1524,2,96,2,308000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(92,7532,39,40720,1524,2,67,2,64680.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(93,7532,39,40720,1524,2,13,1,372680.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(94,7532,40,40720,1524,2,218,2,25000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(95,7532,40,40720,1524,2,13,1,25000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(96,7532,41,40720,1524,2,218,2,65000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(97,7532,41,40720,1524,2,13,1,65000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(98,7532,42,40720,1524,2,218,2,70000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(99,7532,42,40720,1524,2,13,1,70000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(100,7532,43,40720,1524,2,218,2,65000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(101,7532,43,40720,1524,2,13,1,65000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(102,7532,44,40720,1524,2,218,2,75000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(103,7532,44,40720,1524,2,13,1,75000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(104,7532,45,40720,1524,2,218,2,50000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(105,7532,45,40720,1524,2,13,1,50000.00,NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(106,7532,46,40720,1524,2,218,2,50000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(107,7532,46,40720,1524,2,13,1,50000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10');
INSERT INTO `balance_libro_details` VALUES (108,7532,47,40720,1524,2,96,2,324912.40,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(109,7532,47,40720,1524,2,67,2,68231.60,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(110,7532,47,40720,1524,2,13,1,393144.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(111,7532,48,40720,1524,2,218,2,75000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(112,7532,48,40720,1524,2,13,1,75000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(113,7532,49,40720,1524,2,96,2,226000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(114,7532,49,40720,1524,2,67,2,47460.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(115,7532,49,40720,1524,2,13,1,273460.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(116,7532,50,40720,1524,2,218,2,60000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(117,7532,50,40720,1524,2,13,1,60000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(118,7532,51,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(119,7532,51,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(120,7532,52,40720,1524,2,218,2,35000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(121,7532,52,40720,1524,2,13,1,35000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(122,7532,53,40720,1524,2,218,2,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(123,7532,53,40720,1524,2,13,1,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(124,7532,54,40720,1524,2,218,2,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(125,7532,54,40720,1524,2,13,1,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(126,7532,55,40720,1524,2,218,2,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(127,7532,55,40720,1524,2,13,1,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(128,7532,56,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(129,7532,56,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(130,7532,57,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(131,7532,57,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(132,7532,58,40720,1524,2,96,2,4698.97,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(133,7532,58,40720,1524,2,67,2,986.78,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(134,7532,58,40720,1524,2,13,1,5685.75,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(135,7532,59,40720,1524,2,96,2,36249.18,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(136,7532,59,40720,1524,2,67,2,7612.33,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(137,7532,59,40720,1524,2,13,1,43861.51,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(138,7532,60,40720,1524,2,218,2,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(139,7532,60,40720,1524,2,13,1,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(140,7532,61,40720,1524,2,218,2,7500.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(141,7532,61,40720,1524,2,13,1,7500.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(142,7532,62,40720,1524,2,218,2,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10');
INSERT INTO `balance_libro_details` VALUES (143,7532,62,40720,1524,2,13,1,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(144,7532,63,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(145,7532,63,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(146,7532,64,40720,1524,2,96,2,1074.38,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(147,7532,64,40720,1524,2,67,2,225.62,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(148,7532,64,40720,1524,2,13,1,1300.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(149,7532,65,40720,1524,2,218,2,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(150,7532,65,40720,1524,2,13,1,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(151,7532,66,40720,1524,2,218,2,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(152,7532,66,40720,1524,2,13,1,25000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(153,7532,67,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:11','2022-08-11 10:38:11'),(154,7532,67,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:11','2022-08-11 10:38:11'),(155,7532,68,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:11','2022-08-11 10:38:11'),(156,7532,68,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:11','2022-08-11 10:38:11'),(157,7532,69,40720,1524,2,96,2,1132.23,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:11','2022-08-11 10:38:11'),(158,7532,69,40720,1524,2,67,2,237.77,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:11','2022-08-11 10:38:11'),(159,7532,69,40720,1524,2,13,1,1370.00,NULL,'2022-08-11 10:01:45','2022-08-11 10:38:11','2022-08-11 10:38:11'),(160,7532,70,40720,1524,2,96,2,1859.60,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(161,7532,70,40720,1524,2,67,2,390.52,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(162,7532,70,40720,1524,2,13,1,2250.12,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(163,7532,71,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(164,7532,71,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(165,7532,72,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(166,7532,72,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(167,7532,73,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(168,7532,73,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(169,7532,74,40720,1524,2,218,2,35000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(170,7532,74,40720,1524,2,13,1,35000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(171,7532,75,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(172,7532,75,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(173,7532,76,40720,1524,2,218,2,25000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(174,7532,76,40720,1524,2,13,1,25000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(175,7532,77,40720,1524,2,96,2,292500.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(176,7532,77,40720,1524,2,67,2,61425.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(177,7532,77,40720,1524,2,13,1,353925.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11');
INSERT INTO `balance_libro_details` VALUES (178,7532,78,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(179,7532,78,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(180,7532,79,40720,1524,2,96,2,21570.25,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(181,7532,79,40720,1524,2,67,2,4529.75,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(182,7532,79,40720,1524,2,218,2,431.40,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(183,7532,79,40720,1524,2,13,1,26531.40,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(184,7532,80,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(185,7532,80,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(186,7532,81,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(187,7532,81,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(188,7532,82,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(189,7532,82,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(190,7532,83,40720,1524,2,96,2,6363.63,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(191,7532,83,40720,1524,2,67,2,1336.36,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(192,7532,83,40720,1524,2,13,1,7699.99,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(193,7532,84,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(194,7532,84,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(195,7532,85,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(196,7532,85,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(197,7532,86,40720,1524,2,218,2,5000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(198,7532,86,40720,1524,2,13,1,5000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(199,7532,87,40720,1524,2,218,2,360000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(200,7532,87,40720,1524,2,13,1,360000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(201,7532,88,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(202,7532,88,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(203,7532,89,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(204,7532,89,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(205,7532,90,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(206,7532,90,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(207,7532,91,40720,1524,2,218,1,25000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(208,7532,91,40720,1524,2,13,2,25000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(209,7532,92,40720,1524,2,218,2,25000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(210,7532,92,40720,1524,2,13,1,25000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(211,7532,93,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(212,7532,93,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11');
INSERT INTO `balance_libro_details` VALUES (213,7532,94,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(214,7532,94,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(215,7532,95,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(216,7532,95,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(217,7532,96,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(218,7532,96,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(219,7532,97,40720,1524,2,218,2,35000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(220,7532,97,40720,1524,2,13,1,35000.00,NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(221,7532,98,40720,1524,2,218,2,100000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(222,7532,98,40720,1524,2,13,1,100000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(223,7532,99,40720,1524,2,218,2,261900.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(224,7532,99,40720,1524,2,13,1,261900.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(225,7532,100,40720,1524,2,96,2,206700.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(226,7532,100,40720,1524,2,67,2,43407.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(227,7532,100,40720,1524,2,13,1,250107.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(228,7532,101,40720,1524,2,218,2,50000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(229,7532,101,40720,1524,2,13,1,50000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(230,7532,102,40720,1524,2,96,2,143595.04,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(231,7532,102,40720,1524,2,67,2,30154.96,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(232,7532,102,40720,1524,2,13,1,173750.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(233,7532,103,40720,1524,2,218,2,140000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(234,7532,103,40720,1524,2,13,1,140000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(235,7532,104,40720,1524,2,218,2,50000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(236,7532,104,40720,1524,2,13,1,50000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(237,7532,105,40720,1524,2,218,2,50000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(238,7532,105,40720,1524,2,13,1,50000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(239,7532,106,40720,1524,2,218,2,41000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(240,7532,106,40720,1524,2,13,1,41000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(241,7532,107,40720,1524,2,218,2,50000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(242,7532,107,40720,1524,2,13,1,50000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(243,7532,108,40720,1524,2,218,2,20000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(244,7532,108,40720,1524,2,13,1,20000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(245,7532,109,40720,1524,2,218,2,50000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(246,7532,109,40720,1524,2,13,1,50000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(247,7532,110,40720,1524,2,218,2,50000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11');
INSERT INTO `balance_libro_details` VALUES (248,7532,110,40720,1524,2,13,1,50000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(249,7532,111,40720,1524,2,218,2,48000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(250,7532,111,40720,1524,2,13,1,48000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(251,7532,112,40720,1524,2,96,2,161983.47,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(252,7532,112,40720,1524,2,67,2,34016.53,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(253,7532,112,40720,1524,2,13,1,196000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(254,7532,113,40720,1524,2,218,2,82000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(255,7532,113,40720,1524,2,13,1,82000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(256,7532,114,40720,1524,2,96,2,318000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(257,7532,114,40720,1524,2,67,2,66780.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(258,7532,114,40720,1524,2,13,1,384780.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(259,7532,115,40720,1524,2,96,2,3388.42,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(260,7532,115,40720,1524,2,67,2,711.57,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(261,7532,115,40720,1524,2,13,1,4099.99,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(262,7532,116,40720,1524,2,96,2,1800000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(263,7532,116,40720,1524,2,67,2,378000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(264,7532,116,40720,1524,2,13,1,2178000.00,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(265,7532,117,40720,1524,2,96,2,15016.55,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(266,7532,117,40720,1524,2,67,2,3153.48,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(267,7532,117,40720,1524,2,13,1,18170.03,NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(268,7532,118,40720,1524,2,218,2,1800.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(269,7532,118,40720,1524,2,13,1,1800.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(270,7532,119,40720,1524,2,96,2,2049.59,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(271,7532,119,40720,1524,2,67,2,430.41,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(272,7532,119,40720,1524,2,13,1,2480.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(273,7532,120,40720,1524,2,96,2,1198.35,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(274,7532,120,40720,1524,2,67,2,251.65,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(275,7532,120,40720,1524,2,13,1,1450.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(276,7532,121,40720,1524,2,96,2,495.87,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(277,7532,121,40720,1524,2,67,2,104.13,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(278,7532,121,40720,1524,2,218,2,9.92,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(279,7532,121,40720,1524,2,13,1,609.92,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(280,7532,122,40720,1524,2,96,2,302000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(281,7532,122,40720,1524,2,67,2,63420.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(282,7532,122,40720,1524,2,13,1,365420.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11');
INSERT INTO `balance_libro_details` VALUES (283,7532,123,40720,1524,2,96,2,28264.47,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(284,7532,123,40720,1524,2,67,2,5935.54,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(285,7532,123,40720,1524,2,218,2,565.29,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(286,7532,123,40720,1524,2,13,1,34765.30,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(287,7532,124,40720,1524,2,96,1,147107.44,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(288,7532,124,40720,1524,2,68,1,30892.56,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(289,7532,124,40720,1524,2,13,2,178000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(290,7532,125,40720,1524,2,96,2,206.85,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(291,7532,125,40720,1524,2,67,2,43.44,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(292,7532,125,40720,1524,2,13,1,250.29,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(293,7532,126,40720,1524,2,96,2,147107.44,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(294,7532,126,40720,1524,2,67,2,30892.56,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(295,7532,126,40720,1524,2,13,1,178000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(296,7532,127,40720,1524,2,218,2,21400.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(297,7532,127,40720,1524,2,13,1,21400.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(298,7532,128,40720,1524,2,218,2,50000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(299,7532,128,40720,1524,2,13,1,50000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(300,7532,129,40720,1524,2,218,2,24600.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(301,7532,129,40720,1524,2,13,1,24600.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(302,7532,130,40720,1524,2,218,2,60000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(303,7532,130,40720,1524,2,13,1,60000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(304,7532,131,40720,1524,2,218,2,270000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(305,7532,131,40720,1524,2,13,1,270000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(306,7532,132,40720,1524,2,218,2,35000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(307,7532,132,40720,1524,2,13,1,35000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(308,7532,133,40720,1524,2,96,2,4586.78,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(309,7532,133,40720,1524,2,67,2,963.22,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(310,7532,133,40720,1524,2,218,2,91.73,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(311,7532,133,40720,1524,2,13,1,5641.73,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(312,7532,134,40720,1524,2,96,2,1446.28,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(313,7532,134,40720,1524,2,67,2,303.72,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(314,7532,134,40720,1524,2,13,1,1750.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(315,7532,135,40720,1524,2,96,2,1000000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(316,7532,135,40720,1524,2,67,2,210000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(317,7532,135,40720,1524,2,13,1,1210000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12');
INSERT INTO `balance_libro_details` VALUES (318,7532,136,40720,1524,2,218,2,100000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(319,7532,136,40720,1524,2,13,1,100000.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(320,7532,137,40720,1524,2,218,2,2800.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(321,7532,137,40720,1524,2,13,1,2800.00,NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(322,7532,138,40720,1524,2,96,2,10413.22,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(323,7532,138,40720,1524,2,67,2,2186.78,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(324,7532,138,40720,1524,2,13,1,12600.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(325,7532,139,40720,1524,2,218,2,400.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(326,7532,139,40720,1524,2,13,1,400.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(327,7532,140,40720,1524,2,218,2,200000.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(328,7532,140,40720,1524,2,13,1,200000.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(329,7532,141,40720,1524,2,96,2,90909.09,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(330,7532,141,40720,1524,2,67,2,19090.91,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(331,7532,141,40720,1524,2,13,1,110000.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(332,7532,142,40720,1524,2,218,2,5000.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(333,7532,142,40720,1524,2,13,1,5000.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(334,7532,143,40720,1524,2,218,2,200000.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(335,7532,143,40720,1524,2,13,1,200000.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(336,7532,144,40720,1524,2,96,2,153719.04,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(337,7532,144,40720,1524,2,67,2,32281.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(338,7532,144,40720,1524,2,13,1,186000.04,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(339,7532,145,40720,1524,2,96,2,30000.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(340,7532,145,40720,1524,2,67,2,6300.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(341,7532,145,40720,1524,2,218,2,600.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(342,7532,145,40720,1524,2,13,1,36900.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(343,7532,146,40720,1524,2,96,2,12785.13,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(344,7532,146,40720,1524,2,67,2,2684.88,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(345,7532,146,40720,1524,2,13,1,15470.01,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(346,7532,147,40720,1524,2,96,2,27015.70,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(347,7532,147,40720,1524,2,67,2,5673.30,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(348,7532,147,40720,1524,2,13,1,32689.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(349,7532,148,40720,1524,2,96,2,27015.70,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(350,7532,148,40720,1524,2,67,2,5673.30,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(351,7532,148,40720,1524,2,13,1,32689.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(352,7532,149,40720,1524,2,96,2,1318.18,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12');
INSERT INTO `balance_libro_details` VALUES (353,7532,149,40720,1524,2,67,2,276.82,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(354,7532,149,40720,1524,2,218,2,405.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(355,7532,149,40720,1524,2,13,1,2000.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(356,7532,150,40720,1524,2,218,2,70000.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(357,7532,150,40720,1524,2,13,1,70000.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(358,7532,151,40720,1524,2,96,2,28100.97,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(359,7532,151,40720,1524,2,67,2,5901.20,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(360,7532,151,40720,1524,2,13,1,34002.17,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(361,7532,152,40720,1524,2,96,2,1479.34,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(362,7532,152,40720,1524,2,67,2,310.66,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(363,7532,152,40720,1524,2,13,1,1790.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(364,7532,153,40720,1524,2,96,2,2056.14,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(365,7532,153,40720,1524,2,67,2,431.79,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(366,7532,153,40720,1524,2,218,2,212.07,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(367,7532,153,40720,1524,2,13,1,2700.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(368,7532,154,40720,1524,2,96,2,991.74,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(369,7532,154,40720,1524,2,67,2,208.26,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(370,7532,154,40720,1524,2,13,1,1200.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(371,7532,155,40720,1524,2,96,2,15151.36,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(372,7532,155,40720,1524,2,67,2,3181.79,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(373,7532,155,40720,1524,2,13,1,18333.15,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(374,7532,156,40720,1524,2,96,2,7454.53,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(375,7532,156,40720,1524,2,67,2,1565.45,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(376,7532,156,40720,1524,2,13,1,9019.98,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(377,7532,157,40720,1524,2,96,2,27917.33,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(378,7532,157,40720,1524,2,67,2,5862.64,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(379,7532,157,40720,1524,2,13,1,33779.97,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(380,7532,158,40720,1524,2,218,2,15000.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(381,7532,158,40720,1524,2,13,1,15000.00,NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(382,7532,159,40720,1524,2,96,2,495867.77,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(383,7532,159,40720,1524,2,67,2,104132.23,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(384,7532,159,40720,1524,2,13,1,600000.00,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(385,7532,160,40720,1524,2,218,2,160415.10,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(386,7532,160,40720,1524,2,13,1,160415.10,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(387,7532,161,40720,1524,2,218,2,1500.00,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12');
INSERT INTO `balance_libro_details` VALUES (388,7532,161,40720,1524,2,13,1,1500.00,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(389,7532,162,40720,1524,2,96,2,71374.11,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(390,7532,162,40720,1524,2,67,2,14988.56,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(391,7532,162,40720,1524,2,218,2,1427.48,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(392,7532,162,40720,1524,2,13,1,87790.15,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(393,7532,163,40720,1524,2,96,2,9747.90,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(394,7532,163,40720,1524,2,67,2,2047.05,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(395,7532,163,40720,1524,2,13,1,11794.95,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(396,7532,164,40720,1524,2,96,2,330578.51,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(397,7532,164,40720,1524,2,67,2,69421.49,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(398,7532,164,40720,1524,2,13,1,400000.00,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(399,7532,165,40720,1524,2,96,2,1239.66,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(400,7532,165,40720,1524,2,67,2,260.33,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(401,7532,165,40720,1524,2,13,1,1499.99,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(402,7532,166,40720,1524,2,96,2,7413.21,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(403,7532,166,40720,1524,2,67,2,1556.77,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(404,7532,166,40720,1524,2,13,1,8969.98,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(405,7532,167,40720,1524,2,96,2,8844.31,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(406,7532,167,40720,1524,2,67,2,1857.31,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(407,7532,167,40720,1524,2,13,1,10701.62,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(408,7532,168,40720,1524,2,96,2,1000000.00,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(409,7532,168,40720,1524,2,67,2,210000.00,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(410,7532,168,40720,1524,2,13,1,1210000.00,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(411,7532,169,40720,1524,2,218,2,60000.00,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(412,7532,169,40720,1524,2,13,1,60000.00,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(413,7532,170,40720,1524,2,218,2,50000.00,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(414,7532,170,40720,1524,2,13,1,50000.00,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(415,7532,171,40720,1524,2,218,2,190000.00,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(416,7532,171,40720,1524,2,13,1,190000.00,NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(417,7532,172,40720,1524,2,96,2,429752.07,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(418,7532,172,40720,1524,2,67,2,90247.93,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(419,7532,172,40720,1524,2,13,1,520000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(420,7532,173,40720,1524,2,96,2,416528.93,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(421,7532,173,40720,1524,2,67,2,87471.07,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(422,7532,173,40720,1524,2,13,1,504000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12');
INSERT INTO `balance_libro_details` VALUES (423,7532,174,40720,1524,2,96,2,421487.60,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(424,7532,174,40720,1524,2,67,2,88512.40,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(425,7532,174,40720,1524,2,13,1,510000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(426,7532,175,40720,1524,2,96,2,785123.97,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(427,7532,175,40720,1524,2,67,2,164876.03,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(428,7532,175,40720,1524,2,13,1,950000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(429,7532,176,40720,1524,2,96,2,1322314.05,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(430,7532,176,40720,1524,2,67,2,277685.95,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(431,7532,176,40720,1524,2,13,1,1600000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(432,7532,177,40720,1524,2,96,2,413223.14,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(433,7532,177,40720,1524,2,67,2,86776.86,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(434,7532,177,40720,1524,2,13,1,500000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(435,7532,178,40720,1524,2,96,2,2066115.70,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(436,7532,178,40720,1524,2,67,2,433884.30,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(437,7532,178,40720,1524,2,13,1,2500000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(438,7532,179,40720,1524,2,96,2,1438016.53,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(439,7532,179,40720,1524,2,67,2,301983.47,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(440,7532,179,40720,1524,2,13,1,1740000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(441,7532,180,40720,1524,2,96,2,595041.32,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(442,7532,180,40720,1524,2,67,2,124958.68,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(443,7532,180,40720,1524,2,13,1,720000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(444,7532,181,40720,1524,2,96,2,239156.62,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(445,7532,181,40720,1524,2,67,2,50222.89,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(446,7532,181,40720,1524,2,13,1,289379.51,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(447,7532,182,40720,1524,2,96,2,7522622.07,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(448,7532,182,40720,1524,2,67,2,1579750.63,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(449,7532,182,40720,1524,2,13,1,9102372.70,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(450,7532,183,40720,1524,2,96,2,595041.32,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(451,7532,183,40720,1524,2,67,2,124958.68,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(452,7532,183,40720,1524,2,13,1,720000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(453,7532,184,40720,1524,2,96,2,595041.32,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(454,7532,184,40720,1524,2,67,2,124958.68,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(455,7532,184,40720,1524,2,13,1,720000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(456,7532,185,40720,1524,2,96,2,813223.14,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(457,7532,185,40720,1524,2,67,2,170776.86,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12');
INSERT INTO `balance_libro_details` VALUES (458,7532,185,40720,1524,2,13,1,984000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(459,7532,186,40720,1524,2,96,2,1404958.68,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(460,7532,186,40720,1524,2,67,2,295041.32,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(461,7532,186,40720,1524,2,13,1,1700000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(462,7532,187,40720,1524,2,96,2,1239669.42,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(463,7532,187,40720,1524,2,67,2,260330.58,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(464,7532,187,40720,1524,2,13,1,1500000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(465,7532,188,40720,1524,2,96,2,388429.75,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(466,7532,188,40720,1524,2,67,2,81570.25,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(467,7532,188,40720,1524,2,13,1,470000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(468,7532,189,40720,1524,2,96,2,247933.88,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(469,7532,189,40720,1524,2,67,2,52066.12,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(470,7532,189,40720,1524,2,13,1,300000.00,NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(471,7532,190,40720,1524,2,96,2,813223.14,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(472,7532,190,40720,1524,2,67,2,170776.86,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(473,7532,190,40720,1524,2,13,1,984000.00,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(474,7532,191,40720,1524,2,96,2,1404958.68,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(475,7532,191,40720,1524,2,67,2,295041.32,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(476,7532,191,40720,1524,2,13,1,1700000.00,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(477,7532,192,40720,1524,2,96,2,909090.91,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(478,7532,192,40720,1524,2,67,2,190909.09,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(479,7532,192,40720,1524,2,13,1,1100000.00,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(480,7532,193,40720,1524,2,96,2,2231404.96,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(481,7532,193,40720,1524,2,67,2,468595.04,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(482,7532,193,40720,1524,2,13,1,2700000.00,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(483,7532,194,40720,1524,2,96,2,578512.40,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(484,7532,194,40720,1524,2,67,2,121487.60,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(485,7532,194,40720,1524,2,13,1,700000.00,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(486,7532,195,40720,1524,2,96,2,512396.70,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(487,7532,195,40720,1524,2,67,2,107603.31,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(488,7532,195,40720,1524,2,13,1,620000.01,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(489,7532,196,40720,1524,2,96,2,813223.14,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(490,7532,196,40720,1524,2,67,2,170776.86,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(491,7532,196,40720,1524,2,13,1,984000.00,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(492,7532,197,40720,1524,2,96,2,884297.52,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12');
INSERT INTO `balance_libro_details` VALUES (493,7532,197,40720,1524,2,67,2,185702.48,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(494,7532,197,40720,1524,2,13,1,1070000.00,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(495,7532,198,40720,1524,2,96,2,495867.77,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(496,7532,198,40720,1524,2,67,2,104132.23,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(497,7532,198,40720,1524,2,13,1,600000.00,NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(498,7532,199,40720,1524,2,96,2,429752.07,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(499,7532,199,40720,1524,2,67,2,90247.93,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(500,7532,199,40720,1524,2,13,1,520000.00,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(501,7532,200,40720,1524,2,96,2,416528.93,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(502,7532,200,40720,1524,2,67,2,87471.07,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(503,7532,200,40720,1524,2,13,1,504000.00,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(504,7532,201,40720,1524,2,96,2,421487.60,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(505,7532,201,40720,1524,2,67,2,88512.40,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(506,7532,201,40720,1524,2,13,1,510000.00,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(507,7532,202,40720,1524,2,96,2,785123.97,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(508,7532,202,40720,1524,2,67,2,164876.03,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(509,7532,202,40720,1524,2,13,1,950000.00,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(510,7532,203,40720,1524,2,96,2,1322314.05,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(511,7532,203,40720,1524,2,67,2,277685.95,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(512,7532,203,40720,1524,2,13,1,1600000.00,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(513,7532,204,40720,1524,2,96,2,413223.14,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(514,7532,204,40720,1524,2,67,2,86776.86,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(515,7532,204,40720,1524,2,13,1,500000.00,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(516,7532,205,40720,1524,2,96,2,2066115.70,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(517,7532,205,40720,1524,2,67,2,433884.30,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(518,7532,205,40720,1524,2,13,1,2500000.00,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(519,7532,206,40720,1524,2,96,2,1438016.53,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(520,7532,206,40720,1524,2,67,2,301983.47,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(521,7532,206,40720,1524,2,13,1,1740000.00,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(522,7532,207,40720,1524,2,96,2,595041.32,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(523,7532,207,40720,1524,2,67,2,124958.68,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(524,7532,207,40720,1524,2,13,1,720000.00,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(525,7532,208,40720,1524,2,96,2,239156.62,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(526,7532,208,40720,1524,2,67,2,50222.89,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(527,7532,208,40720,1524,2,13,1,289379.51,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24');
INSERT INTO `balance_libro_details` VALUES (528,7532,209,40720,1524,2,96,2,7522622.07,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(529,7532,209,40720,1524,2,67,2,1579750.63,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(530,7532,209,40720,1524,2,13,1,9102372.70,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(531,7532,210,40720,1524,2,96,2,595041.32,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(532,7532,210,40720,1524,2,67,2,124958.68,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(533,7532,210,40720,1524,2,13,1,720000.00,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(534,7532,211,40720,1524,2,96,2,595041.32,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(535,7532,211,40720,1524,2,67,2,124958.68,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(536,7532,211,40720,1524,2,13,1,720000.00,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(537,7532,212,40720,1524,2,96,2,813223.14,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(538,7532,212,40720,1524,2,67,2,170776.86,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(539,7532,212,40720,1524,2,13,1,984000.00,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(540,7532,213,40720,1524,2,96,2,1404958.68,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(541,7532,213,40720,1524,2,67,2,295041.32,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(542,7532,213,40720,1524,2,13,1,1700000.00,NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(543,7532,214,40720,1524,2,96,2,1239669.42,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(544,7532,214,40720,1524,2,67,2,260330.58,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(545,7532,214,40720,1524,2,13,1,1500000.00,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(546,7532,215,40720,1524,2,96,2,388429.75,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(547,7532,215,40720,1524,2,67,2,81570.25,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(548,7532,215,40720,1524,2,13,1,470000.00,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(549,7532,216,40720,1524,2,96,2,247933.88,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(550,7532,216,40720,1524,2,67,2,52066.12,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(551,7532,216,40720,1524,2,13,1,300000.00,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(552,7532,217,40720,1524,2,96,2,813223.14,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(553,7532,217,40720,1524,2,67,2,170776.86,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(554,7532,217,40720,1524,2,13,1,984000.00,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(555,7532,218,40720,1524,2,96,2,1404958.68,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(556,7532,218,40720,1524,2,67,2,295041.32,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(557,7532,218,40720,1524,2,13,1,1700000.00,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(558,7532,219,40720,1524,2,96,2,909090.91,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(559,7532,219,40720,1524,2,67,2,190909.09,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(560,7532,219,40720,1524,2,13,1,1100000.00,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(561,7532,220,40720,1524,2,96,2,2231404.96,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(562,7532,220,40720,1524,2,67,2,468595.04,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24');
INSERT INTO `balance_libro_details` VALUES (563,7532,220,40720,1524,2,13,1,2700000.00,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(564,7532,221,40720,1524,2,96,2,578512.40,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(565,7532,221,40720,1524,2,67,2,121487.60,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(566,7532,221,40720,1524,2,13,1,700000.00,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(567,7532,222,40720,1524,2,96,2,512396.70,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(568,7532,222,40720,1524,2,67,2,107603.31,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(569,7532,222,40720,1524,2,13,1,620000.01,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(570,7532,223,40720,1524,2,96,2,813223.14,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(571,7532,223,40720,1524,2,67,2,170776.86,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(572,7532,223,40720,1524,2,13,1,984000.00,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(573,7532,224,40720,1524,2,96,2,884297.52,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(574,7532,224,40720,1524,2,67,2,185702.48,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(575,7532,224,40720,1524,2,13,1,1070000.00,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(576,7532,225,40720,1524,2,96,2,495867.77,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(577,7532,225,40720,1524,2,67,2,104132.23,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(578,7532,225,40720,1524,2,13,1,600000.00,NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(579,7532,226,40720,1524,3,250,1,55000.00,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(580,7532,226,40720,1524,3,57,2,55000.00,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(581,7532,227,40720,1524,3,217,1,454545.45,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(582,7532,227,40720,1524,3,68,1,95454.54,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(583,7532,227,40720,1524,3,57,2,549999.99,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(584,7532,228,40720,1524,3,217,1,454545.45,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(585,7532,228,40720,1524,3,68,1,95454.54,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(586,7532,228,40720,1524,3,57,2,549999.99,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(587,7532,229,40720,1524,3,250,1,55000.00,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(588,7532,229,40720,1524,3,57,2,55000.00,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(589,7532,230,40720,1524,3,250,1,55000.00,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(590,7532,230,40720,1524,3,57,2,55000.00,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(591,7532,231,40720,1524,3,250,1,35000.00,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(592,7532,231,40720,1524,3,57,2,35000.00,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(593,7532,232,40720,1524,3,217,1,3223.14,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(594,7532,232,40720,1524,3,68,1,676.86,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(595,7532,232,40720,1524,3,57,2,3900.00,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(596,7532,233,40720,1524,3,217,1,15000.06,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(597,7532,233,40720,1524,3,68,1,3150.01,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(598,7532,233,40720,1524,3,57,2,18150.07,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(599,7532,234,40720,1524,3,250,1,150000.00,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(600,7532,234,40720,1524,3,57,2,150000.00,NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL);
INSERT INTO `balance_libro_details` VALUES (601,7532,235,40720,1524,3,217,1,1614371.88,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(602,7532,235,40720,1524,3,68,1,339018.09,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(603,7532,235,40720,1524,3,57,2,1953389.97,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(604,7532,236,40720,1524,3,217,1,182644.63,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(605,7532,236,40720,1524,3,68,1,38355.37,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(606,7532,236,40720,1524,3,57,2,221000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(607,7532,237,40720,1524,3,217,1,12450.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(608,7532,237,40720,1524,3,68,1,2614.50,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(609,7532,237,40720,1524,3,57,2,15064.50,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(610,7532,238,40720,1524,3,250,1,35000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(611,7532,238,40720,1524,3,57,2,35000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(612,7532,239,40720,1524,3,250,1,60000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(613,7532,239,40720,1524,3,57,2,60000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(614,7532,240,40720,1524,3,250,1,55000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(615,7532,240,40720,1524,3,57,2,55000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(616,7532,241,40720,1524,3,250,1,35000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(617,7532,241,40720,1524,3,57,2,35000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(618,7532,242,40720,1524,3,250,1,100000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(619,7532,242,40720,1524,3,57,2,100000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(620,7532,243,40720,1524,3,217,1,5000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(621,7532,243,40720,1524,3,68,1,1050.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(622,7532,243,40720,1524,3,57,2,6050.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(623,7532,244,40720,1524,3,250,1,55000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(624,7532,244,40720,1524,3,57,2,55000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(625,7532,245,40720,1524,3,250,1,55000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(626,7532,245,40720,1524,3,57,2,55000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(627,7532,246,40720,1524,3,217,1,7827.28,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(628,7532,246,40720,1524,3,68,1,1643.73,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(629,7532,246,40720,1524,3,57,2,9471.01,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(630,7532,247,40720,1524,3,250,1,168000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(631,7532,247,40720,1524,3,57,2,168000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(632,7532,248,40720,1524,3,250,1,408000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(633,7532,248,40720,1524,3,57,2,408000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(634,7532,249,40720,1524,3,250,1,30000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(635,7532,249,40720,1524,3,57,2,30000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(636,7532,250,40720,1524,3,217,1,10650.41,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(637,7532,250,40720,1524,3,68,1,2236.58,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(638,7532,250,40720,1524,3,217,1,213.01,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(639,7532,250,40720,1524,3,57,2,13100.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(640,7532,251,40720,1524,3,250,1,75000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(641,7532,251,40720,1524,3,57,2,75000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL);
INSERT INTO `balance_libro_details` VALUES (642,7532,252,40720,1524,3,250,1,25000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(643,7532,252,40720,1524,3,57,2,25000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(644,7532,253,40720,1524,3,217,1,11762.94,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(645,7532,253,40720,1524,3,68,1,2470.22,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(646,7532,253,40720,1524,3,57,2,14233.16,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(647,7532,254,40720,1524,3,250,1,40000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(648,7532,254,40720,1524,3,57,2,40000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(649,7532,255,40720,1524,3,250,1,75000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(650,7532,255,40720,1524,3,57,2,75000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(651,7532,256,40720,1524,3,250,1,40000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(652,7532,256,40720,1524,3,57,2,40000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(653,7532,257,40720,1524,3,217,1,1495.87,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(654,7532,257,40720,1524,3,68,1,314.13,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(655,7532,257,40720,1524,3,57,2,1810.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(656,7532,258,40720,1524,3,250,1,25000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(657,7532,258,40720,1524,3,57,2,25000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(658,7532,259,40720,1524,3,250,1,30000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(659,7532,259,40720,1524,3,57,2,30000.00,NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(660,7532,260,40720,1524,3,250,1,30000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(661,7532,260,40720,1524,3,57,2,30000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(662,7532,261,40720,1524,3,217,1,10214.88,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(663,7532,261,40720,1524,3,68,1,2145.12,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(664,7532,261,40720,1524,3,57,2,12360.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(665,7532,262,40720,1524,3,250,1,50000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(666,7532,262,40720,1524,3,57,2,50000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(667,7532,263,40720,1524,3,250,1,60000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(668,7532,263,40720,1524,3,57,2,60000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(669,7532,264,40720,1524,3,217,1,308000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(670,7532,264,40720,1524,3,68,1,64680.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(671,7532,264,40720,1524,3,57,2,372680.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(672,7532,265,40720,1524,3,250,1,25000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(673,7532,265,40720,1524,3,57,2,25000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(674,7532,266,40720,1524,3,250,1,65000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(675,7532,266,40720,1524,3,57,2,65000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(676,7532,267,40720,1524,3,250,1,70000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(677,7532,267,40720,1524,3,57,2,70000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(678,7532,268,40720,1524,3,250,1,65000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(679,7532,268,40720,1524,3,57,2,65000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(680,7532,269,40720,1524,3,250,1,75000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(681,7532,269,40720,1524,3,57,2,75000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(682,7532,270,40720,1524,3,250,1,50000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL);
INSERT INTO `balance_libro_details` VALUES (683,7532,270,40720,1524,3,57,2,50000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(684,7532,271,40720,1524,3,250,1,50000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(685,7532,271,40720,1524,3,57,2,50000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(686,7532,272,40720,1524,3,217,1,324912.40,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(687,7532,272,40720,1524,3,68,1,68231.60,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(688,7532,272,40720,1524,3,57,2,393144.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(689,7532,273,40720,1524,3,250,1,75000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(690,7532,273,40720,1524,3,57,2,75000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(691,7532,274,40720,1524,3,217,1,226000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(692,7532,274,40720,1524,3,68,1,47460.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(693,7532,274,40720,1524,3,57,2,273460.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(694,7532,275,40720,1524,3,250,1,60000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(695,7532,275,40720,1524,3,57,2,60000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(696,7532,276,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(697,7532,276,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(698,7532,277,40720,1524,3,250,1,35000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(699,7532,277,40720,1524,3,57,2,35000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(700,7532,278,40720,1524,3,250,1,25000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(701,7532,278,40720,1524,3,57,2,25000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(702,7532,279,40720,1524,3,250,1,25000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(703,7532,279,40720,1524,3,57,2,25000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(704,7532,280,40720,1524,3,250,1,25000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(705,7532,280,40720,1524,3,57,2,25000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(706,7532,281,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(707,7532,281,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(708,7532,282,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(709,7532,282,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(710,7532,283,40720,1524,3,217,1,4698.97,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(711,7532,283,40720,1524,3,68,1,986.78,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(712,7532,283,40720,1524,3,57,2,5685.75,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(713,7532,284,40720,1524,3,217,1,36249.18,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(714,7532,284,40720,1524,3,68,1,7612.33,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(715,7532,284,40720,1524,3,57,2,43861.51,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(716,7532,285,40720,1524,3,250,1,25000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(717,7532,285,40720,1524,3,57,2,25000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(718,7532,286,40720,1524,3,250,1,7500.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(719,7532,286,40720,1524,3,57,2,7500.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(720,7532,287,40720,1524,3,250,1,25000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(721,7532,287,40720,1524,3,57,2,25000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(722,7532,288,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(723,7532,288,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL);
INSERT INTO `balance_libro_details` VALUES (724,7532,289,40720,1524,3,217,1,1074.38,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(725,7532,289,40720,1524,3,68,1,225.62,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(726,7532,289,40720,1524,3,57,2,1300.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(727,7532,290,40720,1524,3,250,1,25000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(728,7532,290,40720,1524,3,57,2,25000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(729,7532,291,40720,1524,3,250,1,25000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(730,7532,291,40720,1524,3,57,2,25000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(731,7532,292,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(732,7532,292,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(733,7532,293,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(734,7532,293,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(735,7532,294,40720,1524,3,217,1,1132.23,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(736,7532,294,40720,1524,3,68,1,237.77,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(737,7532,294,40720,1524,3,57,2,1370.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(738,7532,295,40720,1524,3,217,1,1859.60,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(739,7532,295,40720,1524,3,68,1,390.52,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(740,7532,295,40720,1524,3,57,2,2250.12,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(741,7532,296,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(742,7532,296,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(743,7532,297,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(744,7532,297,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(745,7532,298,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(746,7532,298,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(747,7532,299,40720,1524,3,250,1,35000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(748,7532,299,40720,1524,3,57,2,35000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(749,7532,300,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(750,7532,300,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(751,7532,301,40720,1524,3,250,1,25000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(752,7532,301,40720,1524,3,57,2,25000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(753,7532,302,40720,1524,3,217,1,292500.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(754,7532,302,40720,1524,3,68,1,61425.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(755,7532,302,40720,1524,3,57,2,353925.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(756,7532,303,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(757,7532,303,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(758,7532,304,40720,1524,3,217,1,21570.25,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(759,7532,304,40720,1524,3,68,1,4529.75,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(760,7532,304,40720,1524,3,217,1,431.40,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(761,7532,304,40720,1524,3,57,2,26531.40,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(762,7532,305,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(763,7532,305,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(764,7532,306,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL);
INSERT INTO `balance_libro_details` VALUES (765,7532,306,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(766,7532,307,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(767,7532,307,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(768,7532,308,40720,1524,3,217,1,6363.63,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(769,7532,308,40720,1524,3,68,1,1336.36,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(770,7532,308,40720,1524,3,57,2,7699.99,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(771,7532,309,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(772,7532,309,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(773,7532,310,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(774,7532,310,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(775,7532,311,40720,1524,3,250,1,5000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(776,7532,311,40720,1524,3,57,2,5000.00,NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(777,7532,312,40720,1524,3,250,1,360000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(778,7532,312,40720,1524,3,57,2,360000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(779,7532,313,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(780,7532,313,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(781,7532,314,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(782,7532,314,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(783,7532,315,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(784,7532,315,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(785,7532,316,40720,1524,3,250,2,25000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(786,7532,316,40720,1524,3,57,1,25000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(787,7532,317,40720,1524,3,250,1,25000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(788,7532,317,40720,1524,3,57,2,25000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(789,7532,318,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(790,7532,318,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(791,7532,319,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(792,7532,319,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(793,7532,320,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(794,7532,320,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(795,7532,321,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(796,7532,321,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(797,7532,322,40720,1524,3,250,1,35000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(798,7532,322,40720,1524,3,57,2,35000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(799,7532,323,40720,1524,3,250,1,100000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(800,7532,323,40720,1524,3,57,2,100000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(801,7532,324,40720,1524,3,250,1,261900.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(802,7532,324,40720,1524,3,57,2,261900.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(803,7532,325,40720,1524,3,217,1,206700.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(804,7532,325,40720,1524,3,68,1,43407.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(805,7532,325,40720,1524,3,57,2,250107.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL);
INSERT INTO `balance_libro_details` VALUES (806,7532,326,40720,1524,3,250,1,50000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(807,7532,326,40720,1524,3,57,2,50000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(808,7532,327,40720,1524,3,217,1,143595.04,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(809,7532,327,40720,1524,3,68,1,30154.96,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(810,7532,327,40720,1524,3,57,2,173750.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(811,7532,328,40720,1524,3,250,1,140000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(812,7532,328,40720,1524,3,57,2,140000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(813,7532,329,40720,1524,3,250,1,50000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(814,7532,329,40720,1524,3,57,2,50000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(815,7532,330,40720,1524,3,250,1,50000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(816,7532,330,40720,1524,3,57,2,50000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(817,7532,331,40720,1524,3,250,1,41000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(818,7532,331,40720,1524,3,57,2,41000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(819,7532,332,40720,1524,3,250,1,50000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(820,7532,332,40720,1524,3,57,2,50000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(821,7532,333,40720,1524,3,250,1,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(822,7532,333,40720,1524,3,57,2,20000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(823,7532,334,40720,1524,3,250,1,50000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(824,7532,334,40720,1524,3,57,2,50000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(825,7532,335,40720,1524,3,250,1,50000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(826,7532,335,40720,1524,3,57,2,50000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(827,7532,336,40720,1524,3,250,1,48000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(828,7532,336,40720,1524,3,57,2,48000.00,NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(829,7532,337,40720,1524,3,217,1,161983.47,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(830,7532,337,40720,1524,3,68,1,34016.53,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(831,7532,337,40720,1524,3,57,2,196000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(832,7532,338,40720,1524,3,250,1,82000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(833,7532,338,40720,1524,3,57,2,82000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(834,7532,339,40720,1524,3,217,1,318000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(835,7532,339,40720,1524,3,68,1,66780.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(836,7532,339,40720,1524,3,57,2,384780.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(837,7532,340,40720,1524,3,217,1,3388.42,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(838,7532,340,40720,1524,3,68,1,711.57,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(839,7532,340,40720,1524,3,57,2,4099.99,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(840,7532,341,40720,1524,3,217,1,1800000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(841,7532,341,40720,1524,3,68,1,378000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(842,7532,341,40720,1524,3,57,2,2178000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(843,7532,342,40720,1524,3,217,1,15016.55,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(844,7532,342,40720,1524,3,68,1,3153.48,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(845,7532,342,40720,1524,3,57,2,18170.03,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(846,7532,343,40720,1524,3,250,1,1800.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL);
INSERT INTO `balance_libro_details` VALUES (847,7532,343,40720,1524,3,57,2,1800.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(848,7532,344,40720,1524,3,217,1,2049.59,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(849,7532,344,40720,1524,3,68,1,430.41,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(850,7532,344,40720,1524,3,57,2,2480.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(851,7532,345,40720,1524,3,217,1,1198.35,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(852,7532,345,40720,1524,3,68,1,251.65,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(853,7532,345,40720,1524,3,57,2,1450.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(854,7532,346,40720,1524,3,217,1,495.87,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(855,7532,346,40720,1524,3,68,1,104.13,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(856,7532,346,40720,1524,3,217,1,9.92,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(857,7532,346,40720,1524,3,57,2,609.92,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(858,7532,347,40720,1524,3,217,1,302000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(859,7532,347,40720,1524,3,68,1,63420.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(860,7532,347,40720,1524,3,57,2,365420.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(861,7532,348,40720,1524,3,217,1,28264.47,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(862,7532,348,40720,1524,3,68,1,5935.54,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(863,7532,348,40720,1524,3,217,1,565.29,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(864,7532,348,40720,1524,3,57,2,34765.30,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(865,7532,349,40720,1524,3,217,2,147107.44,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(866,7532,349,40720,1524,3,67,2,30892.56,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(867,7532,349,40720,1524,3,57,1,178000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(868,7532,350,40720,1524,3,217,1,206.85,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(869,7532,350,40720,1524,3,68,1,43.44,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(870,7532,350,40720,1524,3,57,2,250.29,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(871,7532,351,40720,1524,3,217,1,147107.44,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(872,7532,351,40720,1524,3,68,1,30892.56,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(873,7532,351,40720,1524,3,57,2,178000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(874,7532,352,40720,1524,3,250,1,21400.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(875,7532,352,40720,1524,3,57,2,21400.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(876,7532,353,40720,1524,3,250,1,50000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(877,7532,353,40720,1524,3,57,2,50000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(878,7532,354,40720,1524,3,250,1,24600.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(879,7532,354,40720,1524,3,57,2,24600.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(880,7532,355,40720,1524,3,250,1,60000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(881,7532,355,40720,1524,3,57,2,60000.00,NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(882,7532,356,40720,1524,3,250,1,270000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(883,7532,356,40720,1524,3,57,2,270000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(884,7532,357,40720,1524,3,250,1,35000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(885,7532,357,40720,1524,3,57,2,35000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(886,7532,358,40720,1524,3,217,1,4586.78,NULL,'2022-08-11 10:43:02','2022-08-11 11:56:10','2022-08-11 11:56:10'),(887,7532,358,40720,1524,3,68,1,963.22,NULL,'2022-08-11 10:43:02','2022-08-11 11:56:10','2022-08-11 11:56:10');
INSERT INTO `balance_libro_details` VALUES (888,7532,358,40720,1524,3,217,1,91.73,NULL,'2022-08-11 10:43:02','2022-08-11 11:56:10','2022-08-11 11:56:10'),(889,7532,358,40720,1524,3,57,2,5641.73,NULL,'2022-08-11 10:43:02','2022-08-11 11:56:10','2022-08-11 11:56:10'),(890,7532,359,40720,1524,3,217,1,1446.28,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(891,7532,359,40720,1524,3,68,1,303.72,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(892,7532,359,40720,1524,3,57,2,1750.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(893,7532,360,40720,1524,3,217,1,1000000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(894,7532,360,40720,1524,3,68,1,210000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(895,7532,360,40720,1524,3,57,2,1210000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(896,7532,361,40720,1524,3,250,1,100000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(897,7532,361,40720,1524,3,57,2,100000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(898,7532,362,40720,1524,3,250,1,2800.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(899,7532,362,40720,1524,3,57,2,2800.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(900,7532,363,40720,1524,3,217,1,10413.22,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(901,7532,363,40720,1524,3,68,1,2186.78,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(902,7532,363,40720,1524,3,57,2,12600.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(903,7532,364,40720,1524,3,250,1,400.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(904,7532,364,40720,1524,3,57,2,400.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(905,7532,365,40720,1524,3,250,1,200000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(906,7532,365,40720,1524,3,57,2,200000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(907,7532,366,40720,1524,3,217,1,90909.09,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(908,7532,366,40720,1524,3,68,1,19090.91,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(909,7532,366,40720,1524,3,57,2,110000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(910,7532,367,40720,1524,3,250,1,5000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(911,7532,367,40720,1524,3,57,2,5000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(912,7532,368,40720,1524,3,250,1,200000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(913,7532,368,40720,1524,3,57,2,200000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(914,7532,369,40720,1524,3,217,1,153719.04,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(915,7532,369,40720,1524,3,68,1,32281.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(916,7532,369,40720,1524,3,57,2,186000.04,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(917,7532,370,40720,1524,3,217,1,30000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(918,7532,370,40720,1524,3,68,1,6300.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(919,7532,370,40720,1524,3,217,1,600.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(920,7532,370,40720,1524,3,57,2,36900.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(921,7532,371,40720,1524,3,217,1,12785.13,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(922,7532,371,40720,1524,3,68,1,2684.88,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(923,7532,371,40720,1524,3,57,2,15470.01,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(924,7532,372,40720,1524,3,217,1,27015.70,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(925,7532,372,40720,1524,3,68,1,5673.30,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(926,7532,372,40720,1524,3,57,2,32689.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(927,7532,373,40720,1524,3,217,1,27015.70,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(928,7532,373,40720,1524,3,68,1,5673.30,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL);
INSERT INTO `balance_libro_details` VALUES (929,7532,373,40720,1524,3,57,2,32689.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(930,7532,374,40720,1524,3,217,1,1318.18,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(931,7532,374,40720,1524,3,68,1,276.82,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(932,7532,374,40720,1524,3,217,1,405.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(933,7532,374,40720,1524,3,57,2,2000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(934,7532,375,40720,1524,3,250,1,70000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(935,7532,375,40720,1524,3,57,2,70000.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(936,7532,376,40720,1524,3,217,1,28100.97,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(937,7532,376,40720,1524,3,68,1,5901.20,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(938,7532,376,40720,1524,3,57,2,34002.17,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(939,7532,377,40720,1524,3,217,1,1479.34,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(940,7532,377,40720,1524,3,68,1,310.66,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(941,7532,377,40720,1524,3,57,2,1790.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(942,7532,378,40720,1524,3,217,1,2056.14,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(943,7532,378,40720,1524,3,68,1,431.79,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(944,7532,378,40720,1524,3,217,1,212.07,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(945,7532,378,40720,1524,3,57,2,2700.00,NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(946,7532,379,40720,1524,3,217,1,991.74,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(947,7532,379,40720,1524,3,68,1,208.26,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(948,7532,379,40720,1524,3,57,2,1200.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(949,7532,380,40720,1524,3,217,1,15151.36,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(950,7532,380,40720,1524,3,68,1,3181.79,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(951,7532,380,40720,1524,3,57,2,18333.15,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(952,7532,381,40720,1524,3,217,1,7454.53,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(953,7532,381,40720,1524,3,68,1,1565.45,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(954,7532,381,40720,1524,3,57,2,9019.98,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(955,7532,382,40720,1524,3,217,1,27917.33,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(956,7532,382,40720,1524,3,68,1,5862.64,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(957,7532,382,40720,1524,3,57,2,33779.97,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(958,7532,383,40720,1524,3,250,1,15000.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(959,7532,383,40720,1524,3,57,2,15000.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(960,7532,384,40720,1524,3,217,1,495867.77,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(961,7532,384,40720,1524,3,68,1,104132.23,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(962,7532,384,40720,1524,3,57,2,600000.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(963,7532,385,40720,1524,3,250,1,160415.10,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(964,7532,385,40720,1524,3,57,2,160415.10,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(965,7532,386,40720,1524,3,250,1,1500.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(966,7532,386,40720,1524,3,57,2,1500.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(967,7532,387,40720,1524,3,217,1,71374.11,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(968,7532,387,40720,1524,3,68,1,14988.56,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(969,7532,387,40720,1524,3,217,1,1427.48,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL);
INSERT INTO `balance_libro_details` VALUES (970,7532,387,40720,1524,3,57,2,87790.15,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(971,7532,388,40720,1524,3,217,1,9747.90,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(972,7532,388,40720,1524,3,68,1,2047.05,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(973,7532,388,40720,1524,3,57,2,11794.95,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(974,7532,389,40720,1524,3,217,1,330578.51,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(975,7532,389,40720,1524,3,68,1,69421.49,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(976,7532,389,40720,1524,3,57,2,400000.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(977,7532,390,40720,1524,3,217,1,1239.66,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(978,7532,390,40720,1524,3,68,1,260.33,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(979,7532,390,40720,1524,3,57,2,1499.99,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(980,7532,391,40720,1524,3,217,1,7413.21,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(981,7532,391,40720,1524,3,68,1,1556.77,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(982,7532,391,40720,1524,3,57,2,8969.98,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(983,7532,392,40720,1524,3,217,1,8844.31,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(984,7532,392,40720,1524,3,68,1,1857.31,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(985,7532,392,40720,1524,3,57,2,10701.62,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(986,7532,393,40720,1524,3,217,1,1000000.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(987,7532,393,40720,1524,3,68,1,210000.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(988,7532,393,40720,1524,3,57,2,1210000.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(989,7532,394,40720,1524,3,250,1,60000.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(990,7532,394,40720,1524,3,57,2,60000.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(991,7532,395,40720,1524,3,250,1,50000.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(992,7532,395,40720,1524,3,57,2,50000.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(993,7532,396,40720,1524,3,250,1,190000.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(994,7532,396,40720,1524,3,57,2,190000.00,NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(995,7532,397,40720,1524,2,96,2,429752.07,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(996,7532,397,40720,1524,2,67,2,90247.93,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(997,7532,397,40720,1524,2,13,1,520000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(998,7532,398,40720,1524,2,96,2,416528.93,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(999,7532,398,40720,1524,2,67,2,87471.07,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1000,7532,398,40720,1524,2,13,1,504000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1001,7532,399,40720,1524,2,96,2,421487.60,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1002,7532,399,40720,1524,2,67,2,88512.40,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1003,7532,399,40720,1524,2,13,1,510000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1004,7532,400,40720,1524,2,96,2,785123.97,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1005,7532,400,40720,1524,2,67,2,164876.03,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1006,7532,400,40720,1524,2,13,1,950000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1007,7532,401,40720,1524,2,96,2,1322314.05,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47');
INSERT INTO `balance_libro_details` VALUES (1008,7532,401,40720,1524,2,67,2,277685.95,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1009,7532,401,40720,1524,2,13,1,1600000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1010,7532,402,40720,1524,2,96,2,413223.14,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1011,7532,402,40720,1524,2,67,2,86776.86,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1012,7532,402,40720,1524,2,13,1,500000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1013,7532,403,40720,1524,2,96,2,2066115.70,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1014,7532,403,40720,1524,2,67,2,433884.30,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1015,7532,403,40720,1524,2,13,1,2500000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1016,7532,404,40720,1524,2,96,2,1438016.53,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1017,7532,404,40720,1524,2,67,2,301983.47,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1018,7532,404,40720,1524,2,13,1,1740000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1019,7532,405,40720,1524,2,96,2,595041.32,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1020,7532,405,40720,1524,2,67,2,124958.68,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1021,7532,405,40720,1524,2,13,1,720000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1022,7532,406,40720,1524,2,96,2,239156.62,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1023,7532,406,40720,1524,2,67,2,50222.89,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1024,7532,406,40720,1524,2,13,1,289379.51,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1025,7532,407,40720,1524,2,96,2,7522622.07,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1026,7532,407,40720,1524,2,67,2,1579750.63,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1027,7532,407,40720,1524,2,13,1,9102372.70,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1028,7532,408,40720,1524,2,96,2,595041.32,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1029,7532,408,40720,1524,2,67,2,124958.68,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1030,7532,408,40720,1524,2,13,1,720000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1031,7532,409,40720,1524,2,96,2,595041.32,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1032,7532,409,40720,1524,2,67,2,124958.68,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1033,7532,409,40720,1524,2,13,1,720000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1034,7532,410,40720,1524,2,96,2,813223.14,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1035,7532,410,40720,1524,2,67,2,170776.86,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1036,7532,410,40720,1524,2,13,1,984000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1037,7532,411,40720,1524,2,96,2,1404958.68,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1038,7532,411,40720,1524,2,67,2,295041.32,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1039,7532,411,40720,1524,2,13,1,1700000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1040,7532,412,40720,1524,2,96,2,1239669.42,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1041,7532,412,40720,1524,2,67,2,260330.58,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47');
INSERT INTO `balance_libro_details` VALUES (1042,7532,412,40720,1524,2,13,1,1500000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1043,7532,413,40720,1524,2,96,2,388429.75,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1044,7532,413,40720,1524,2,67,2,81570.25,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1045,7532,413,40720,1524,2,13,1,470000.00,NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1046,7532,414,40720,1524,2,96,2,247933.88,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1047,7532,414,40720,1524,2,67,2,52066.12,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1048,7532,414,40720,1524,2,13,1,300000.00,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1049,7532,415,40720,1524,2,96,2,813223.14,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1050,7532,415,40720,1524,2,67,2,170776.86,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1051,7532,415,40720,1524,2,13,1,984000.00,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:47','2022-08-12 11:03:47'),(1052,7532,416,40720,1524,2,96,2,1404958.68,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1053,7532,416,40720,1524,2,67,2,295041.32,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1054,7532,416,40720,1524,2,13,1,1700000.00,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1055,7532,417,40720,1524,2,96,2,909090.91,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1056,7532,417,40720,1524,2,67,2,190909.09,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1057,7532,417,40720,1524,2,13,1,1100000.00,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1058,7532,418,40720,1524,2,96,2,2231404.96,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1059,7532,418,40720,1524,2,67,2,468595.04,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1060,7532,418,40720,1524,2,13,1,2700000.00,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1061,7532,419,40720,1524,2,96,2,578512.40,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1062,7532,419,40720,1524,2,67,2,121487.60,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1063,7532,419,40720,1524,2,13,1,700000.00,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1064,7532,420,40720,1524,2,96,2,512396.70,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1065,7532,420,40720,1524,2,67,2,107603.31,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1066,7532,420,40720,1524,2,13,1,620000.01,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1067,7532,421,40720,1524,2,96,2,813223.14,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1068,7532,421,40720,1524,2,67,2,170776.86,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1069,7532,421,40720,1524,2,13,1,984000.00,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1070,7532,422,40720,1524,2,96,2,884297.52,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1071,7532,422,40720,1524,2,67,2,185702.48,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1072,7532,422,40720,1524,2,13,1,1070000.00,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1073,7532,423,40720,1524,2,96,2,495867.77,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1074,7532,423,40720,1524,2,67,2,104132.23,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1075,7532,423,40720,1524,2,13,1,600000.00,NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1076,7532,424,40720,1524,3,217,1,4586.78,NULL,'2022-08-11 11:56:10','2022-08-11 11:56:10',NULL);
INSERT INTO `balance_libro_details` VALUES (1077,7532,424,40720,1524,3,68,1,963.22,NULL,'2022-08-11 11:56:10','2022-08-11 11:56:10',NULL),(1078,7532,424,40720,1524,3,233,1,91.73,NULL,'2022-08-11 11:56:10','2022-08-11 11:56:10',NULL),(1079,7532,424,40720,1524,3,57,2,5641.73,NULL,'2022-08-11 11:56:10','2022-08-11 11:56:10',NULL),(1080,7532,425,40720,1518,2,96,2,495867.77,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1081,7532,425,40720,1518,2,67,2,104132.23,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1082,7532,425,40720,1518,2,13,1,600000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1083,7532,426,40720,1518,2,96,2,495867.77,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1084,7532,426,40720,1518,2,67,2,104132.23,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1085,7532,426,40720,1518,2,13,1,600000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1086,7532,427,40720,1518,2,96,2,272727.27,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1087,7532,427,40720,1518,2,67,2,57272.73,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1088,7532,427,40720,1518,2,13,1,330000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1089,7532,428,40720,1518,2,96,2,264462.81,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1090,7532,428,40720,1518,2,67,2,55537.19,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1091,7532,428,40720,1518,2,13,1,320000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1092,7532,429,40720,1518,2,96,2,413223.14,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1093,7532,429,40720,1518,2,67,2,86776.86,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1094,7532,429,40720,1518,2,13,1,500000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1095,7532,430,40720,1518,2,96,2,454545.46,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1096,7532,430,40720,1518,2,67,2,95454.55,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1097,7532,430,40720,1518,2,13,1,550000.01,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1098,7532,431,40720,1518,2,96,2,454545.46,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1099,7532,431,40720,1518,2,67,2,95454.55,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1100,7532,431,40720,1518,2,13,1,550000.01,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1101,7532,432,40720,1518,2,96,2,909090.91,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1102,7532,432,40720,1518,2,67,2,190909.09,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1103,7532,432,40720,1518,2,13,1,1100000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1104,7532,433,40720,1518,2,96,2,1652892.56,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1105,7532,433,40720,1518,2,67,2,347107.44,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1106,7532,433,40720,1518,2,13,1,2000000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1107,7532,434,40720,1518,2,96,2,1652892.56,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1108,7532,434,40720,1518,2,67,2,347107.44,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1109,7532,434,40720,1518,2,13,1,2000000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1110,7532,435,40720,1518,2,96,2,371900.83,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1111,7532,435,40720,1518,2,67,2,78099.17,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1112,7532,435,40720,1518,2,13,1,450000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1113,7532,436,40720,1518,2,96,2,495867.77,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1114,7532,436,40720,1518,2,67,2,104132.23,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1115,7532,436,40720,1518,2,13,1,600000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1116,7532,437,40720,1518,2,96,2,553719.01,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL);
INSERT INTO `balance_libro_details` VALUES (1117,7532,437,40720,1518,2,67,2,116280.99,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1118,7532,437,40720,1518,2,13,1,670000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1119,7532,438,40720,1518,2,96,2,826446.28,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1120,7532,438,40720,1518,2,67,2,173553.72,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1121,7532,438,40720,1518,2,13,1,1000000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1122,7532,439,40720,1518,2,96,2,826446.28,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1123,7532,439,40720,1518,2,67,2,173553.72,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1124,7532,439,40720,1518,2,13,1,1000000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1125,7532,440,40720,1518,2,96,2,392561.98,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1126,7532,440,40720,1518,2,67,2,82438.02,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1127,7532,440,40720,1518,2,13,1,475000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1128,7532,441,40720,1518,2,96,2,566115.70,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1129,7532,441,40720,1518,2,67,2,118884.30,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1130,7532,441,40720,1518,2,13,1,685000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1131,7532,442,40720,1518,2,96,2,330578.51,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1132,7532,442,40720,1518,2,67,2,69421.49,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1133,7532,442,40720,1518,2,13,1,400000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1134,7532,443,40720,1518,2,96,2,495867.77,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1135,7532,443,40720,1518,2,67,2,104132.23,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1136,7532,443,40720,1518,2,13,1,600000.00,NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(1137,7532,444,40720,1518,2,96,2,371900.83,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1138,7532,444,40720,1518,2,67,2,78099.17,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1139,7532,444,40720,1518,2,13,1,450000.00,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1140,7532,445,40720,1518,2,96,2,371900.83,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1141,7532,445,40720,1518,2,67,2,78099.17,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1142,7532,445,40720,1518,2,13,1,450000.00,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1143,7532,446,40720,1518,2,96,2,1652892.56,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1144,7532,446,40720,1518,2,67,2,347107.44,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1145,7532,446,40720,1518,2,13,1,2000000.00,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1146,7532,447,40720,1518,2,96,2,231404.96,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1147,7532,447,40720,1518,2,67,2,48595.04,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1148,7532,447,40720,1518,2,13,1,280000.00,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1149,7532,448,40720,1518,2,96,2,148760.33,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1150,7532,448,40720,1518,2,67,2,31239.67,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1151,7532,448,40720,1518,2,13,1,180000.00,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1152,7532,449,40720,1518,2,96,2,247933.89,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1153,7532,449,40720,1518,2,67,2,52066.12,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1154,7532,449,40720,1518,2,13,1,300000.01,NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(1155,7532,450,40720,1518,12,359,1,39117.22,NULL,'2022-08-12 09:47:35','2022-08-12 10:40:24','2022-08-12 10:40:24'),(1156,7532,450,40720,1518,12,482,1,13230092.75,NULL,'2022-08-12 09:47:35','2022-08-12 10:40:24','2022-08-12 10:40:24');
INSERT INTO `balance_libro_details` VALUES (1157,7532,450,40720,1518,12,369,2,13269209.97,NULL,'2022-08-12 09:47:35','2022-08-12 10:40:24','2022-08-12 10:40:24'),(1158,7532,451,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1159,7532,451,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1160,7532,451,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1161,7532,452,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1162,7532,452,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1163,7532,452,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1164,7532,453,40720,1519,2,96,2,483471.08,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1165,7532,453,40720,1519,2,67,2,101528.93,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1166,7532,453,40720,1519,2,13,1,585000.01,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1167,7532,454,40720,1519,2,96,2,586776.86,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1168,7532,454,40720,1519,2,67,2,123223.14,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1169,7532,454,40720,1519,2,13,1,710000.00,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1170,7532,455,40720,1519,2,96,2,595041.32,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1171,7532,455,40720,1519,2,67,2,124958.68,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1172,7532,455,40720,1519,2,13,1,720000.00,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1173,7532,456,40720,1519,2,96,2,595041.32,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1174,7532,456,40720,1519,2,67,2,124958.68,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1175,7532,456,40720,1519,2,13,1,720000.00,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1176,7532,457,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1177,7532,457,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1178,7532,457,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1179,7532,458,40720,1519,2,96,2,1198347.11,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1180,7532,458,40720,1519,2,67,2,251652.89,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1181,7532,458,40720,1519,2,13,1,1450000.00,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1182,7532,459,40720,1519,2,96,2,1735537.19,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1183,7532,459,40720,1519,2,67,2,364462.81,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1184,7532,459,40720,1519,2,13,1,2100000.00,NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1185,7532,460,40720,1519,2,96,2,735537.19,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1186,7532,460,40720,1519,2,67,2,154462.81,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1187,7532,460,40720,1519,2,13,1,890000.00,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1188,7532,461,40720,1519,2,96,2,677685.95,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1189,7532,461,40720,1519,2,67,2,142314.05,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1190,7532,461,40720,1519,2,13,1,820000.00,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48');
INSERT INTO `balance_libro_details` VALUES (1191,7532,462,40720,1519,2,96,2,355371.90,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1192,7532,462,40720,1519,2,67,2,74628.10,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1193,7532,462,40720,1519,2,13,1,430000.00,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1194,7532,463,40720,1519,2,96,2,347107.44,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1195,7532,463,40720,1519,2,67,2,72892.56,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1196,7532,463,40720,1519,2,13,1,420000.00,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1197,7532,464,40720,1519,2,96,2,537190.08,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1198,7532,464,40720,1519,2,67,2,112809.92,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1199,7532,464,40720,1519,2,13,1,650000.00,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1200,7532,465,40720,1519,2,96,2,677685.95,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1201,7532,465,40720,1519,2,67,2,142314.05,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1202,7532,465,40720,1519,2,13,1,820000.00,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1203,7532,466,40720,1519,2,96,2,429752.07,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1204,7532,466,40720,1519,2,67,2,90247.93,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1205,7532,466,40720,1519,2,13,1,520000.00,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1206,7532,467,40720,1519,2,96,2,322314.05,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1207,7532,467,40720,1519,2,67,2,67685.95,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1208,7532,467,40720,1519,2,13,1,390000.00,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1209,7532,468,40720,1519,2,96,2,206611.57,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1210,7532,468,40720,1519,2,67,2,43388.43,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1211,7532,468,40720,1519,2,13,1,250000.00,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1212,7532,469,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1213,7532,469,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1214,7532,469,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(1215,7532,470,40720,1518,12,359,1,39117.22,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1216,7532,470,40720,1518,12,482,1,13230092.75,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1217,7532,470,40720,1518,12,483,1,922179.97,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1218,7532,470,40720,1518,12,176,1,1853547.26,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1219,7532,470,40720,1518,12,20,1,560149.43,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1220,7532,470,40720,1518,12,363,1,57959.64,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1221,7532,470,40720,1518,12,361,1,948067.81,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1222,7532,470,40720,1518,12,419,1,2067910.40,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1223,7532,470,40720,1518,12,23,1,465906.21,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1224,7532,470,40720,1518,12,62,2,289863.88,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13');
INSERT INTO `balance_libro_details` VALUES (1225,7532,470,40720,1518,12,63,2,69293.04,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1226,7532,470,40720,1518,12,74,2,1512078.18,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1227,7532,470,40720,1518,12,82,2,1120848.10,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1228,7532,470,40720,1518,12,78,2,191870.65,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1229,7532,470,40720,1518,12,369,2,200000.00,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1230,7532,470,40720,1518,12,88,2,468925.09,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1231,7532,470,40720,1518,12,381,2,242354.48,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1232,7532,470,40720,1518,12,426,2,4604735.29,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1233,7532,470,40720,1518,12,91,2,10055558.72,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1234,7532,470,40720,1518,12,48,2,8406.81,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1235,7532,470,40720,1518,12,420,2,1240746.22,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1236,7532,470,40720,1518,12,364,2,140250.23,NULL,'2022-08-12 10:40:24','2022-08-12 11:13:13','2022-08-12 11:13:13'),(1237,7532,471,40720,1518,12,359,1,39117.22,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1238,7532,471,40720,1518,12,482,1,13230092.75,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1239,7532,471,40720,1518,12,483,1,922179.97,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1240,7532,471,40720,1518,12,176,1,1853547.26,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1241,7532,471,40720,1518,12,20,1,560149.43,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1242,7532,471,40720,1518,12,363,1,57959.64,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1243,7532,471,40720,1518,12,361,1,948067.81,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1244,7532,471,40720,1518,12,419,1,2067910.40,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1245,7532,471,40720,1518,12,23,1,465906.21,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1246,7532,471,40720,1518,12,62,2,289863.88,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1247,7532,471,40720,1518,12,63,2,69293.04,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1248,7532,471,40720,1518,12,74,2,1512078.18,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1249,7532,471,40720,1518,12,82,2,1120848.10,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1250,7532,471,40720,1518,12,78,2,191870.65,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1251,7532,471,40720,1518,12,369,2,200000.00,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1252,7532,471,40720,1518,12,88,2,468925.09,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1253,7532,471,40720,1518,12,381,2,242354.48,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1254,7532,471,40720,1518,12,426,2,4604735.29,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1255,7532,471,40720,1518,12,91,2,10055558.72,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1256,7532,471,40720,1518,12,48,2,8406.81,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1257,7532,471,40720,1518,12,420,2,1240746.22,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1258,7532,471,40720,1518,12,484,1,1226216.28,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1259,7532,471,40720,1518,12,485,1,30915.53,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1260,7532,471,40720,1518,12,435,1,61998.80,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1261,7532,471,40720,1518,12,486,2,71366.90,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1262,7532,471,40720,1518,12,487,2,34648.73,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL);
INSERT INTO `balance_libro_details` VALUES (1263,7532,471,40720,1518,12,488,2,21295.41,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1264,7532,471,40720,1518,12,489,2,1089000.00,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1265,7532,471,40720,1518,12,414,2,131433.50,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1266,7532,471,40720,1518,12,492,2,3149.74,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1267,7532,471,40720,1518,12,493,2,108486.56,NULL,'2022-08-12 11:13:13','2022-08-12 11:13:13',NULL),(1268,7532,472,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1269,7532,472,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1270,7532,472,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1271,7532,473,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1272,7532,473,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1273,7532,473,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1274,7532,474,40720,1519,2,96,2,483471.08,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1275,7532,474,40720,1519,2,67,2,101528.93,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1276,7532,474,40720,1519,2,13,1,585000.01,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1277,7532,475,40720,1519,2,96,2,586776.86,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1278,7532,475,40720,1519,2,67,2,123223.14,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1279,7532,475,40720,1519,2,13,1,710000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1280,7532,476,40720,1519,2,96,2,595041.32,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1281,7532,476,40720,1519,2,67,2,124958.68,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1282,7532,476,40720,1519,2,13,1,720000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1283,7532,477,40720,1519,2,96,2,595041.32,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1284,7532,477,40720,1519,2,67,2,124958.68,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1285,7532,477,40720,1519,2,13,1,720000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1286,7532,478,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1287,7532,478,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1288,7532,478,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1289,7532,479,40720,1519,2,96,2,1198347.11,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1290,7532,479,40720,1519,2,67,2,251652.89,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1291,7532,479,40720,1519,2,13,1,1450000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1292,7532,480,40720,1519,2,96,2,1735537.19,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1293,7532,480,40720,1519,2,67,2,364462.81,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1294,7532,480,40720,1519,2,13,1,2100000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1295,7532,481,40720,1519,2,96,2,735537.19,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1296,7532,481,40720,1519,2,67,2,154462.81,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1297,7532,481,40720,1519,2,13,1,890000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21');
INSERT INTO `balance_libro_details` VALUES (1298,7532,482,40720,1519,2,96,2,677685.95,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1299,7532,482,40720,1519,2,67,2,142314.05,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1300,7532,482,40720,1519,2,13,1,820000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1301,7532,483,40720,1519,2,96,2,355371.90,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1302,7532,483,40720,1519,2,67,2,74628.10,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1303,7532,483,40720,1519,2,13,1,430000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1304,7532,484,40720,1519,2,96,2,347107.44,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1305,7532,484,40720,1519,2,67,2,72892.56,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1306,7532,484,40720,1519,2,13,1,420000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1307,7532,485,40720,1519,2,96,2,537190.08,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1308,7532,485,40720,1519,2,67,2,112809.92,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1309,7532,485,40720,1519,2,13,1,650000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1310,7532,486,40720,1519,2,96,2,677685.95,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1311,7532,486,40720,1519,2,67,2,142314.05,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1312,7532,486,40720,1519,2,13,1,820000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1313,7532,487,40720,1519,2,96,2,429752.07,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1314,7532,487,40720,1519,2,67,2,90247.93,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1315,7532,487,40720,1519,2,13,1,520000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1316,7532,488,40720,1519,2,96,2,322314.05,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1317,7532,488,40720,1519,2,67,2,67685.95,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1318,7532,488,40720,1519,2,13,1,390000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1319,7532,489,40720,1519,2,96,2,206611.57,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1320,7532,489,40720,1519,2,67,2,43388.43,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1321,7532,489,40720,1519,2,13,1,250000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1322,7532,490,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1323,7532,490,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1324,7532,490,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(1325,7532,491,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(1326,7532,491,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(1327,7532,491,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(1328,7532,492,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(1329,7532,492,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(1330,7532,492,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(1331,7532,493,40720,1519,2,96,2,483471.08,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21');
INSERT INTO `balance_libro_details` VALUES (1332,7532,493,40720,1519,2,67,2,101528.93,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(1333,7532,493,40720,1519,2,13,1,585000.01,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(1334,7532,494,40720,1519,2,96,2,586776.86,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(1335,7532,494,40720,1519,2,67,2,123223.14,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(1336,7532,494,40720,1519,2,13,1,710000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:21','2022-08-17 11:21:21'),(1337,7532,495,40720,1519,2,96,2,595041.32,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1338,7532,495,40720,1519,2,67,2,124958.68,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1339,7532,495,40720,1519,2,13,1,720000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1340,7532,496,40720,1519,2,96,2,595041.32,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1341,7532,496,40720,1519,2,67,2,124958.68,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1342,7532,496,40720,1519,2,13,1,720000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1343,7532,497,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1344,7532,497,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1345,7532,497,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1346,7532,498,40720,1519,2,96,2,1198347.11,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1347,7532,498,40720,1519,2,67,2,251652.89,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1348,7532,498,40720,1519,2,13,1,1450000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1349,7532,499,40720,1519,2,96,2,1735537.19,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1350,7532,499,40720,1519,2,67,2,364462.81,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1351,7532,499,40720,1519,2,13,1,2100000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1352,7532,500,40720,1519,2,96,2,735537.19,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1353,7532,500,40720,1519,2,67,2,154462.81,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1354,7532,500,40720,1519,2,13,1,890000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1355,7532,501,40720,1519,2,96,2,677685.95,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1356,7532,501,40720,1519,2,67,2,142314.05,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1357,7532,501,40720,1519,2,13,1,820000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1358,7532,502,40720,1519,2,96,2,355371.90,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1359,7532,502,40720,1519,2,67,2,74628.10,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1360,7532,502,40720,1519,2,13,1,430000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1361,7532,503,40720,1519,2,96,2,347107.44,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1362,7532,503,40720,1519,2,67,2,72892.56,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1363,7532,503,40720,1519,2,13,1,420000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1364,7532,504,40720,1519,2,96,2,537190.08,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1365,7532,504,40720,1519,2,67,2,112809.92,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22');
INSERT INTO `balance_libro_details` VALUES (1366,7532,504,40720,1519,2,13,1,650000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1367,7532,505,40720,1519,2,96,2,677685.95,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1368,7532,505,40720,1519,2,67,2,142314.05,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1369,7532,505,40720,1519,2,13,1,820000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1370,7532,506,40720,1519,2,96,2,429752.07,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1371,7532,506,40720,1519,2,67,2,90247.93,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1372,7532,506,40720,1519,2,13,1,520000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1373,7532,507,40720,1519,2,96,2,322314.05,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1374,7532,507,40720,1519,2,67,2,67685.95,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1375,7532,507,40720,1519,2,13,1,390000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1376,7532,508,40720,1519,2,96,2,206611.57,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1377,7532,508,40720,1519,2,67,2,43388.43,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1378,7532,508,40720,1519,2,13,1,250000.00,NULL,'2022-08-12 11:34:53','2022-08-17 11:21:22','2022-08-17 11:21:22'),(1379,7532,509,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 11:34:54','2022-08-12 11:44:47','2022-08-12 11:44:47'),(1380,7532,509,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 11:34:54','2022-08-12 11:44:47','2022-08-12 11:44:47'),(1381,7532,509,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 11:34:54','2022-08-12 11:44:47','2022-08-12 11:44:47'),(1382,7532,510,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 11:44:47','2022-08-12 11:45:36','2022-08-12 11:45:36'),(1383,7532,510,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 11:44:47','2022-08-12 11:45:36','2022-08-12 11:45:36'),(1384,7532,510,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 11:44:47','2022-08-12 11:45:36','2022-08-12 11:45:36'),(1387,7532,512,40720,1519,20,13,2,600000.00,NULL,'2022-08-12 11:45:35','2022-08-12 11:48:38','2022-08-12 11:48:38'),(1388,7532,512,40720,1519,20,359,1,600000.00,NULL,'2022-08-12 11:45:35','2022-08-12 11:48:38','2022-08-12 11:48:38'),(1389,7532,513,40720,1519,2,96,2,495867.77,NULL,'2022-08-12 11:45:36','2022-08-12 11:48:38','2022-08-12 11:48:38'),(1390,7532,513,40720,1519,2,67,2,104132.23,NULL,'2022-08-12 11:45:36','2022-08-12 11:48:38','2022-08-12 11:48:38'),(1391,7532,513,40720,1519,2,13,1,600000.00,NULL,'2022-08-12 11:45:36','2022-08-12 11:48:38','2022-08-12 11:48:38'),(1392,7532,514,40720,1522,2,96,2,495867.77,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1393,7532,514,40720,1522,2,67,2,104132.23,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1394,7532,514,40720,1522,2,13,1,600000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1395,7532,515,40720,1522,2,96,2,743801.65,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1396,7532,515,40720,1522,2,67,2,156198.35,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1397,7532,515,40720,1522,2,13,1,900000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1398,7532,516,40720,1522,2,96,2,347107.44,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1399,7532,516,40720,1522,2,67,2,72892.56,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1400,7532,516,40720,1522,2,13,1,420000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1401,7532,517,40720,1522,2,96,2,537190.08,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41');
INSERT INTO `balance_libro_details` VALUES (1402,7532,517,40720,1522,2,67,2,112809.92,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1403,7532,517,40720,1522,2,13,1,650000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1404,7532,518,40720,1522,2,96,2,355371.90,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1405,7532,518,40720,1522,2,67,2,74628.10,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1406,7532,518,40720,1522,2,13,1,430000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1407,7532,519,40720,1522,2,96,2,495867.77,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1408,7532,519,40720,1522,2,67,2,104132.23,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1409,7532,519,40720,1522,2,13,1,600000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1410,7532,520,40720,1522,2,96,2,495867.77,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1411,7532,520,40720,1522,2,67,2,104132.23,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1412,7532,520,40720,1522,2,13,1,600000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1413,7532,521,40720,1522,2,96,2,1198347.11,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1414,7532,521,40720,1522,2,67,2,251652.89,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1415,7532,521,40720,1522,2,13,1,1450000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1416,7532,522,40720,1522,2,96,2,495867.77,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1417,7532,522,40720,1522,2,67,2,104132.23,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1418,7532,522,40720,1522,2,13,1,600000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1419,7532,523,40720,1522,2,96,2,512396.70,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1420,7532,523,40720,1522,2,67,2,107603.31,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1421,7532,523,40720,1522,2,13,1,620000.01,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1422,7532,524,40720,1522,2,96,2,1074380.17,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1423,7532,524,40720,1522,2,67,2,225619.84,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1424,7532,524,40720,1522,2,13,1,1300000.01,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1425,7532,525,40720,1522,2,96,2,322314.05,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1426,7532,525,40720,1522,2,67,2,67685.95,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1427,7532,525,40720,1522,2,13,1,390000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1428,7532,526,40720,1522,2,96,2,1735537.19,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1429,7532,526,40720,1522,2,67,2,364462.81,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1430,7532,526,40720,1522,2,13,1,2100000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1431,7532,527,40720,1522,2,96,2,677685.95,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1432,7532,527,40720,1522,2,67,2,142314.05,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1433,7532,527,40720,1522,2,13,1,820000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1434,7532,528,40720,1522,2,96,2,1136363.64,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1435,7532,528,40720,1522,2,67,2,238636.36,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41');
INSERT INTO `balance_libro_details` VALUES (1436,7532,528,40720,1522,2,13,1,1375000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1437,7532,529,40720,1522,2,96,2,677685.95,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1438,7532,529,40720,1522,2,67,2,142314.05,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1439,7532,529,40720,1522,2,13,1,820000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1440,7532,530,40720,1522,2,96,2,735537.19,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1441,7532,530,40720,1522,2,67,2,154462.81,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1442,7532,530,40720,1522,2,13,1,890000.00,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1443,7532,531,40720,1522,2,96,2,1082249.54,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1444,7532,531,40720,1522,2,67,2,227272.40,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1445,7532,531,40720,1522,2,13,1,1309521.94,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1446,7532,532,40720,1522,2,96,2,215012.42,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1447,7532,532,40720,1522,2,67,2,45152.61,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1448,7532,532,40720,1522,2,13,1,260165.03,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1449,7532,533,40720,1522,2,96,2,1487603.31,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1450,7532,533,40720,1522,2,67,2,312396.70,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1451,7532,533,40720,1522,2,13,1,1800000.01,NULL,'2022-08-12 11:50:52','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1452,7532,534,40720,1522,2,96,2,206611.57,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1453,7532,534,40720,1522,2,67,2,43388.43,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1454,7532,534,40720,1522,2,13,1,250000.00,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1455,7532,535,40720,1522,2,96,2,429752.07,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1456,7532,535,40720,1522,2,67,2,90247.93,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1457,7532,535,40720,1522,2,13,1,520000.00,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1458,7532,536,40720,1522,2,96,2,677685.95,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1459,7532,536,40720,1522,2,67,2,142314.05,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1460,7532,536,40720,1522,2,13,1,820000.00,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1461,7532,537,40720,1522,2,96,2,495867.77,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1462,7532,537,40720,1522,2,67,2,104132.23,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1463,7532,537,40720,1522,2,13,1,600000.00,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1464,7532,538,40720,1522,2,96,2,322314.05,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1465,7532,538,40720,1522,2,67,2,67685.95,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1466,7532,538,40720,1522,2,13,1,390000.00,NULL,'2022-08-12 11:50:53','2022-08-12 11:57:41','2022-08-12 11:57:41'),(1644,7532,610,40720,1518,3,482,1,40000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:37:48','2022-08-17 10:37:48'),(1645,7532,610,40720,1518,3,57,2,40000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:37:48','2022-08-17 10:37:48'),(1646,7532,611,40720,1518,3,482,1,8100000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:37:48','2022-08-17 10:37:48');
INSERT INTO `balance_libro_details` VALUES (1647,7532,611,40720,1518,3,68,1,1701000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:37:48','2022-08-17 10:37:48'),(1648,7532,611,40720,1518,3,57,2,9801000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:37:48','2022-08-17 10:37:48'),(1649,7532,612,40720,1519,3,482,1,1345309.92,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1650,7532,612,40720,1519,3,68,1,282515.08,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1651,7532,612,40720,1519,3,57,2,1627825.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1652,7532,613,40720,1519,3,482,1,182644.63,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1653,7532,613,40720,1519,3,68,1,38355.37,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1654,7532,613,40720,1519,3,57,2,221000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1655,7532,614,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1656,7532,614,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1657,7532,615,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1658,7532,615,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1659,7532,616,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1660,7532,616,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1661,7532,617,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1662,7532,617,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1663,7532,618,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1664,7532,618,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1665,7532,619,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1666,7532,619,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1667,7532,620,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1668,7532,620,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1669,7532,621,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1670,7532,621,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1671,7532,622,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1672,7532,622,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1673,7532,623,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1674,7532,623,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:47','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1675,7532,624,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1676,7532,624,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1677,7532,625,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1678,7532,625,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1679,7532,626,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1680,7532,626,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10');
INSERT INTO `balance_libro_details` VALUES (1681,7532,627,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1682,7532,627,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1683,7532,628,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1684,7532,628,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1685,7532,629,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1686,7532,629,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1687,7532,630,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1688,7532,630,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1689,7532,631,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1690,7532,631,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1691,7532,632,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1692,7532,632,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1693,7532,633,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1694,7532,633,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1695,7532,634,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1696,7532,634,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:10','2022-08-17 10:38:10'),(1697,7532,635,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1698,7532,635,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1699,7532,636,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1700,7532,636,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1701,7532,637,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1702,7532,637,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1703,7532,638,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1704,7532,638,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1705,7532,639,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1706,7532,639,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1707,7532,640,40720,1519,3,482,1,35000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1708,7532,640,40720,1519,3,57,2,35000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1709,7532,641,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1710,7532,641,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1711,7532,642,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1712,7532,642,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1713,7532,643,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1714,7532,643,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1715,7532,644,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11');
INSERT INTO `balance_libro_details` VALUES (1716,7532,644,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1717,7532,645,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1718,7532,645,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1719,7532,646,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1720,7532,646,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1721,7532,647,40720,1519,3,482,1,35000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1722,7532,647,40720,1519,3,57,2,35000.00,NULL,'2022-08-17 10:29:48','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1723,7532,648,40720,1519,3,482,1,50000.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1724,7532,648,40720,1519,3,57,2,50000.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1725,7532,649,40720,1519,3,482,1,75000.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1726,7532,649,40720,1519,3,57,2,75000.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1727,7532,650,40720,1519,3,482,1,124225.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1728,7532,650,40720,1519,3,68,1,26087.25,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1729,7532,650,40720,1519,3,57,2,150312.25,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1730,7532,651,40720,1519,3,482,1,289091.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1731,7532,651,40720,1519,3,68,1,60709.11,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1732,7532,651,40720,1519,3,57,2,349800.11,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1733,7532,652,40720,1519,3,482,1,171100.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1734,7532,652,40720,1519,3,68,1,35931.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1735,7532,652,40720,1519,3,57,2,207031.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1736,7532,653,40720,1519,3,482,1,6148.26,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1737,7532,653,40720,1519,3,68,1,1291.13,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1738,7532,653,40720,1519,3,57,2,7439.39,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1739,7532,654,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1740,7532,654,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1741,7532,655,40720,1519,3,482,1,4363.64,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1742,7532,655,40720,1519,3,68,1,916.36,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1743,7532,655,40720,1519,3,57,2,5280.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1744,7532,656,40720,1519,3,482,1,60000.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1745,7532,656,40720,1519,3,57,2,60000.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1746,7532,657,40720,1519,3,482,1,200000.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1747,7532,657,40720,1519,3,57,2,200000.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1748,7532,658,40720,1519,3,482,1,1544.72,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1749,7532,658,40720,1519,3,68,1,324.39,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1750,7532,658,40720,1519,3,57,2,1869.11,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11');
INSERT INTO `balance_libro_details` VALUES (1751,7532,659,40720,1519,3,482,1,36614.20,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1752,7532,659,40720,1519,3,68,1,7688.98,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1753,7532,659,40720,1519,3,482,1,732.29,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1754,7532,659,40720,1519,3,57,2,45035.47,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1755,7532,660,40720,1519,3,482,1,826446.28,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1756,7532,660,40720,1519,3,68,1,173553.72,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1757,7532,660,40720,1519,3,57,2,1000000.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1758,7532,661,40720,1519,3,482,1,578.51,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1759,7532,661,40720,1519,3,68,1,121.49,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1760,7532,661,40720,1519,3,57,2,700.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1761,7532,662,40720,1519,3,482,1,537.19,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1762,7532,662,40720,1519,3,68,1,112.81,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1763,7532,662,40720,1519,3,57,2,650.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1764,7532,663,40720,1519,3,482,1,272.73,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1765,7532,663,40720,1519,3,68,1,57.27,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1766,7532,663,40720,1519,3,57,2,330.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1767,7532,664,40720,1519,3,482,1,24793.38,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1768,7532,664,40720,1519,3,68,1,5206.61,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1769,7532,664,40720,1519,3,57,2,29999.99,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1770,7532,665,40720,1519,3,482,1,4214.88,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1771,7532,665,40720,1519,3,68,1,885.12,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1772,7532,665,40720,1519,3,57,2,5100.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1773,7532,666,40720,1519,3,482,1,132231.41,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1774,7532,666,40720,1519,3,68,1,27768.60,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1775,7532,666,40720,1519,3,57,2,160000.01,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1776,7532,667,40720,1519,3,482,1,1157.03,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1777,7532,667,40720,1519,3,68,1,242.98,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1778,7532,667,40720,1519,3,57,2,1400.01,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1779,7532,668,40720,1519,3,482,1,1223.14,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1780,7532,668,40720,1519,3,68,1,256.86,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1781,7532,668,40720,1519,3,57,2,1480.00,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1782,7532,669,40720,1519,3,482,1,2276.42,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1783,7532,669,40720,1519,3,68,1,478.05,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1784,7532,669,40720,1519,3,57,2,2754.47,NULL,'2022-08-17 10:29:49','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1785,7532,670,40720,1519,3,482,1,162246.46,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11');
INSERT INTO `balance_libro_details` VALUES (1786,7532,670,40720,1519,3,68,1,34071.76,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1787,7532,670,40720,1519,3,482,1,3244.92,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1788,7532,670,40720,1519,3,57,2,199563.14,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1789,7532,671,40720,1519,3,482,1,75000.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1790,7532,671,40720,1519,3,57,2,75000.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1791,7532,672,40720,1519,3,482,1,661157.03,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1792,7532,672,40720,1519,3,68,1,138842.98,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1793,7532,672,40720,1519,3,57,2,800000.01,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1794,7532,673,40720,1519,3,482,1,9921.48,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1795,7532,673,40720,1519,3,68,1,2083.51,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1796,7532,673,40720,1519,3,57,2,12004.99,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1797,7532,674,40720,1519,3,482,1,80000.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1798,7532,674,40720,1519,3,57,2,80000.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1799,7532,675,40720,1519,3,482,1,99.17,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1800,7532,675,40720,1519,3,68,1,20.83,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1801,7532,675,40720,1519,3,57,2,120.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1802,7532,676,40720,1519,3,482,1,398016.53,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1803,7532,676,40720,1519,3,68,1,83583.47,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1804,7532,676,40720,1519,3,482,1,7960.33,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1805,7532,676,40720,1519,3,57,2,489560.33,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1806,7532,677,40720,1519,3,482,1,15867.77,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1807,7532,677,40720,1519,3,68,1,3332.23,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1808,7532,677,40720,1519,3,482,1,317.36,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1809,7532,677,40720,1519,3,57,2,19517.36,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1810,7532,678,40720,1519,3,482,1,86115.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1811,7532,678,40720,1519,3,68,1,18084.15,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1812,7532,678,40720,1519,3,482,1,1722.68,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1813,7532,678,40720,1519,3,57,2,105921.83,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1814,7532,679,40720,1519,3,482,1,9200.38,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1815,7532,679,40720,1519,3,68,1,1932.08,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1816,7532,679,40720,1519,3,482,1,184.17,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1817,7532,679,40720,1519,3,57,2,11316.63,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1818,7532,680,40720,1519,3,482,1,144628.10,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1819,7532,680,40720,1519,3,68,1,30371.90,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1820,7532,680,40720,1519,3,57,2,175000.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11');
INSERT INTO `balance_libro_details` VALUES (1821,7532,681,40720,1519,3,482,1,25368.21,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1822,7532,681,40720,1519,3,68,1,5327.32,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1823,7532,681,40720,1519,3,57,2,30695.53,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1824,7532,682,40720,1519,3,482,1,24953.15,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1825,7532,682,40720,1519,3,68,1,5240.16,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1826,7532,682,40720,1519,3,482,1,499.06,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1827,7532,682,40720,1519,3,57,2,30692.37,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1828,7532,683,40720,1519,3,482,1,115702.48,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1829,7532,683,40720,1519,3,68,1,24297.52,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1830,7532,683,40720,1519,3,57,2,140000.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1831,7532,684,40720,1519,3,482,1,2000.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1832,7532,684,40720,1519,3,68,1,420.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1833,7532,684,40720,1519,3,482,1,1580.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1834,7532,684,40720,1519,3,57,2,4000.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1835,7532,685,40720,1519,3,482,1,2876.03,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1836,7532,685,40720,1519,3,68,1,603.97,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1837,7532,685,40720,1519,3,57,2,3480.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1838,7532,686,40720,1519,3,482,1,958.68,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1839,7532,686,40720,1519,3,68,1,201.32,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1840,7532,686,40720,1519,3,57,2,1160.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1841,7532,687,40720,1519,3,482,1,426446.28,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1842,7532,687,40720,1519,3,68,1,89553.72,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1843,7532,687,40720,1519,3,482,1,8528.92,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1844,7532,687,40720,1519,3,57,2,524528.92,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1845,7532,688,40720,1519,3,482,1,27700.38,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1846,7532,688,40720,1519,3,68,1,5817.08,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1847,7532,688,40720,1519,3,482,1,554.03,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1848,7532,688,40720,1519,3,57,2,34071.49,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1849,7532,689,40720,1519,3,482,1,13254.41,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1850,7532,689,40720,1519,3,68,1,2783.43,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1851,7532,689,40720,1519,3,482,1,265.09,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1852,7532,689,40720,1519,3,57,2,16302.93,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1853,7532,690,40720,1519,3,482,1,10677.36,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1854,7532,690,40720,1519,3,68,1,2242.25,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1855,7532,690,40720,1519,3,482,1,213.55,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11');
INSERT INTO `balance_libro_details` VALUES (1856,7532,690,40720,1519,3,57,2,13133.16,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1857,7532,691,40720,1519,3,482,1,40000.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1858,7532,691,40720,1519,3,57,2,40000.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1859,7532,692,40720,1519,3,482,1,48000.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1860,7532,692,40720,1519,3,57,2,48000.00,NULL,'2022-08-17 10:29:50','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1861,7532,693,40720,1519,3,482,1,3681.82,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1862,7532,693,40720,1519,3,68,1,773.18,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1863,7532,693,40720,1519,3,57,2,4455.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1864,7532,694,40720,1519,3,482,1,8400.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1865,7532,694,40720,1519,3,68,1,1764.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1866,7532,694,40720,1519,3,57,2,10164.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1867,7532,695,40720,1519,3,482,1,2479.34,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1868,7532,695,40720,1519,3,68,1,520.66,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1869,7532,695,40720,1519,3,57,2,3000.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1870,7532,696,40720,1519,3,482,1,1382.64,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1871,7532,696,40720,1519,3,68,1,290.35,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1872,7532,696,40720,1519,3,482,1,27.65,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1873,7532,696,40720,1519,3,57,2,1700.64,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1874,7532,697,40720,1519,3,482,1,157824.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1875,7532,697,40720,1519,3,57,2,157824.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:11','2022-08-17 10:38:11'),(1876,7532,698,40720,1519,3,482,1,239000.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1877,7532,698,40720,1519,3,68,1,50190.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1878,7532,698,40720,1519,3,57,2,289190.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1879,7532,699,40720,1519,3,482,1,165990.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1880,7532,699,40720,1519,3,68,1,34857.90,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1881,7532,699,40720,1519,3,57,2,200847.90,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1882,7532,700,40720,1519,3,482,1,1046.40,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1883,7532,700,40720,1519,3,68,1,109.87,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1884,7532,700,40720,1519,3,57,2,1156.27,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1885,7532,701,40720,1519,3,482,1,330.58,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1886,7532,701,40720,1519,3,68,1,69.42,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1887,7532,701,40720,1519,3,57,2,400.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1888,7532,702,40720,1519,3,482,1,11646.38,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1889,7532,702,40720,1519,3,68,1,2445.74,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1890,7532,702,40720,1519,3,57,2,14092.12,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12');
INSERT INTO `balance_libro_details` VALUES (1891,7532,703,40720,1519,3,482,1,703.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1892,7532,703,40720,1519,3,68,1,147.63,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1893,7532,703,40720,1519,3,57,2,850.63,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1894,7532,704,40720,1519,3,482,1,28760.34,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1895,7532,704,40720,1519,3,68,1,6039.67,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1896,7532,704,40720,1519,3,57,2,34800.01,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1897,7532,705,40720,1519,3,482,1,3305.78,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1898,7532,705,40720,1519,3,68,1,694.21,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1899,7532,705,40720,1519,3,57,2,3999.99,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1900,7532,706,40720,1519,3,482,1,15041.35,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1901,7532,706,40720,1519,3,68,1,3158.68,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1902,7532,706,40720,1519,3,57,2,18200.03,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1903,7532,707,40720,1519,3,482,1,3986.03,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1904,7532,707,40720,1519,3,68,1,837.07,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1905,7532,707,40720,1519,3,57,2,4823.10,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1906,7532,708,40720,1519,3,482,1,1186.66,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1907,7532,708,40720,1519,3,68,1,249.20,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1908,7532,708,40720,1519,3,482,1,131.12,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1909,7532,708,40720,1519,3,68,1,13.77,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1910,7532,708,40720,1519,3,57,2,1580.75,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1911,7532,709,40720,1519,3,482,1,46155.60,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1912,7532,709,40720,1519,3,68,1,9692.68,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1913,7532,709,40720,1519,3,482,1,923.11,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1914,7532,709,40720,1519,3,57,2,56771.39,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1915,7532,710,40720,1519,3,482,1,5509.98,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1916,7532,710,40720,1519,3,68,1,1157.10,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1917,7532,710,40720,1519,3,482,1,110.20,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1918,7532,710,40720,1519,3,57,2,6777.28,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1919,7532,711,40720,1519,3,482,1,7500.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1920,7532,711,40720,1519,3,57,2,7500.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1921,7532,712,40720,1519,3,482,1,24793.38,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1922,7532,712,40720,1519,3,68,1,5206.61,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1923,7532,712,40720,1519,3,57,2,29999.99,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1924,7532,713,40720,1519,3,482,1,81454.55,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1925,7532,713,40720,1519,3,68,1,17105.46,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12');
INSERT INTO `balance_libro_details` VALUES (1926,7532,713,40720,1519,3,57,2,98560.01,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1927,7532,714,40720,1519,3,482,1,197181.82,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1928,7532,714,40720,1519,3,68,1,41408.18,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1929,7532,714,40720,1519,3,57,2,238590.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1930,7532,715,40720,1519,3,482,1,328925.62,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1931,7532,715,40720,1519,3,68,1,69074.38,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1932,7532,715,40720,1519,3,57,2,398000.00,NULL,'2022-08-17 10:29:51','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1933,7532,716,40720,1519,3,482,1,218884.36,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1934,7532,716,40720,1519,3,68,1,45965.72,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1935,7532,716,40720,1519,3,57,2,264850.08,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1936,7532,717,40720,1519,3,482,2,2067.86,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1937,7532,717,40720,1519,3,67,2,434.25,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1938,7532,717,40720,1519,3,57,1,2502.11,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1939,7532,718,40720,1519,3,482,1,4153.52,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1940,7532,718,40720,1519,3,68,1,872.24,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1941,7532,718,40720,1519,3,482,1,83.07,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1942,7532,718,40720,1519,3,57,2,5108.83,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1943,7532,719,40720,1519,3,482,1,5478.78,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1944,7532,719,40720,1519,3,68,1,1150.54,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1945,7532,719,40720,1519,3,482,1,109.58,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1946,7532,719,40720,1519,3,57,2,6738.90,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1947,7532,720,40720,1519,3,482,1,661157.03,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1948,7532,720,40720,1519,3,68,1,138842.98,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1949,7532,720,40720,1519,3,57,2,800000.01,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1950,7532,721,40720,1519,3,482,1,23966.94,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1951,7532,721,40720,1519,3,68,1,5033.06,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1952,7532,721,40720,1519,3,57,2,29000.00,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1953,7532,722,40720,1519,3,482,1,32066.10,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1954,7532,722,40720,1519,3,68,1,6733.88,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1955,7532,722,40720,1519,3,57,2,38799.98,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1956,7532,723,40720,1519,3,482,1,5851.24,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1957,7532,723,40720,1519,3,68,1,1228.76,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1958,7532,723,40720,1519,3,57,2,7080.00,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1959,7532,724,40720,1519,3,482,1,1446.28,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1960,7532,724,40720,1519,3,68,1,303.72,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12');
INSERT INTO `balance_libro_details` VALUES (1961,7532,724,40720,1519,3,57,2,1750.00,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1962,7532,725,40720,1519,3,482,1,10510.00,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1963,7532,725,40720,1519,3,57,2,10510.00,NULL,'2022-08-17 10:29:52','2022-08-17 10:38:12','2022-08-17 10:38:12'),(1964,7532,726,40720,1518,3,482,1,40000.00,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:06','2022-08-17 10:41:06'),(1965,7532,726,40720,1518,3,57,2,40000.00,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:06','2022-08-17 10:41:06'),(1966,7532,727,40720,1518,3,482,1,8100000.00,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:06','2022-08-17 10:41:06'),(1967,7532,727,40720,1518,3,68,1,1701000.00,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:06','2022-08-17 10:41:06'),(1968,7532,727,40720,1518,3,57,2,9801000.00,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:06','2022-08-17 10:41:06'),(1969,7532,728,40720,1519,3,482,1,1345309.92,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1970,7532,728,40720,1519,3,68,1,282515.08,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1971,7532,728,40720,1519,3,57,2,1627825.00,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1972,7532,729,40720,1519,3,482,1,182644.63,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1973,7532,729,40720,1519,3,68,1,38355.37,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1974,7532,729,40720,1519,3,57,2,221000.00,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1975,7532,730,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1976,7532,730,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1977,7532,731,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1978,7532,731,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1979,7532,732,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1980,7532,732,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:36','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1981,7532,733,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1982,7532,733,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1983,7532,734,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1984,7532,734,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1985,7532,735,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1986,7532,735,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1987,7532,736,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1988,7532,736,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1989,7532,737,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1990,7532,737,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1991,7532,738,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1992,7532,738,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1993,7532,739,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1994,7532,739,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13');
INSERT INTO `balance_libro_details` VALUES (1995,7532,740,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1996,7532,740,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1997,7532,741,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1998,7532,741,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(1999,7532,742,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2000,7532,742,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2001,7532,743,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2002,7532,743,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2003,7532,744,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2004,7532,744,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2005,7532,745,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2006,7532,745,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2007,7532,746,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2008,7532,746,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2009,7532,747,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2010,7532,747,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2011,7532,748,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2012,7532,748,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2013,7532,749,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2014,7532,749,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2015,7532,750,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2016,7532,750,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2017,7532,751,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2018,7532,751,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:37','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2019,7532,752,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2020,7532,752,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2021,7532,753,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2022,7532,753,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2023,7532,754,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2024,7532,754,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2025,7532,755,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2026,7532,755,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2027,7532,756,40720,1519,3,482,1,35000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2028,7532,756,40720,1519,3,57,2,35000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2029,7532,757,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13');
INSERT INTO `balance_libro_details` VALUES (2030,7532,757,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2031,7532,758,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2032,7532,758,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2033,7532,759,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2034,7532,759,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2035,7532,760,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2036,7532,760,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2037,7532,761,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2038,7532,761,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2039,7532,762,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2040,7532,762,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2041,7532,763,40720,1519,3,482,1,35000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2042,7532,763,40720,1519,3,57,2,35000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2043,7532,764,40720,1519,3,482,1,50000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2044,7532,764,40720,1519,3,57,2,50000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2045,7532,765,40720,1519,3,482,1,75000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2046,7532,765,40720,1519,3,57,2,75000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2047,7532,766,40720,1519,3,482,1,124225.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2048,7532,766,40720,1519,3,68,1,26087.25,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2049,7532,766,40720,1519,3,57,2,150312.25,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2050,7532,767,40720,1519,3,482,1,289091.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2051,7532,767,40720,1519,3,68,1,60709.11,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2052,7532,767,40720,1519,3,57,2,349800.11,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2053,7532,768,40720,1519,3,482,1,171100.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2054,7532,768,40720,1519,3,68,1,35931.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2055,7532,768,40720,1519,3,57,2,207031.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2056,7532,769,40720,1519,3,482,1,6148.26,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2057,7532,769,40720,1519,3,68,1,1291.13,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2058,7532,769,40720,1519,3,57,2,7439.39,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2059,7532,770,40720,1519,3,482,1,20000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2060,7532,770,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2061,7532,771,40720,1519,3,482,1,4363.64,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2062,7532,771,40720,1519,3,68,1,916.36,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2063,7532,771,40720,1519,3,57,2,5280.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2064,7532,772,40720,1519,3,482,1,60000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13');
INSERT INTO `balance_libro_details` VALUES (2065,7532,772,40720,1519,3,57,2,60000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2066,7532,773,40720,1519,3,482,1,200000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2067,7532,773,40720,1519,3,57,2,200000.00,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2068,7532,774,40720,1519,3,482,1,1544.72,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2069,7532,774,40720,1519,3,68,1,324.39,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2070,7532,774,40720,1519,3,57,2,1869.11,NULL,'2022-08-17 10:38:38','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2071,7532,775,40720,1519,3,482,1,36614.20,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2072,7532,775,40720,1519,3,68,1,7688.98,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2073,7532,775,40720,1519,3,482,1,732.29,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2074,7532,775,40720,1519,3,57,2,45035.47,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2075,7532,776,40720,1519,3,482,1,826446.28,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2076,7532,776,40720,1519,3,68,1,173553.72,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2077,7532,776,40720,1519,3,57,2,1000000.00,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2078,7532,777,40720,1519,3,482,1,578.51,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2079,7532,777,40720,1519,3,68,1,121.49,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2080,7532,777,40720,1519,3,57,2,700.00,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2081,7532,778,40720,1519,3,482,1,537.19,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2082,7532,778,40720,1519,3,68,1,112.81,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2083,7532,778,40720,1519,3,57,2,650.00,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2084,7532,779,40720,1519,3,482,1,272.73,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2085,7532,779,40720,1519,3,68,1,57.27,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2086,7532,779,40720,1519,3,57,2,330.00,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2087,7532,780,40720,1519,3,482,1,24793.38,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2088,7532,780,40720,1519,3,68,1,5206.61,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2089,7532,780,40720,1519,3,57,2,29999.99,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2090,7532,781,40720,1519,3,482,1,4214.88,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2091,7532,781,40720,1519,3,68,1,885.12,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2092,7532,781,40720,1519,3,57,2,5100.00,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2093,7532,782,40720,1519,3,482,1,132231.41,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2094,7532,782,40720,1519,3,68,1,27768.60,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2095,7532,782,40720,1519,3,57,2,160000.01,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2096,7532,783,40720,1519,3,482,1,1157.03,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2097,7532,783,40720,1519,3,68,1,242.98,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2098,7532,783,40720,1519,3,57,2,1400.01,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:13','2022-08-17 10:41:13'),(2099,7532,784,40720,1519,3,482,1,1223.14,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14');
INSERT INTO `balance_libro_details` VALUES (2100,7532,784,40720,1519,3,68,1,256.86,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2101,7532,784,40720,1519,3,57,2,1480.00,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2102,7532,785,40720,1519,3,482,1,2276.42,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2103,7532,785,40720,1519,3,68,1,478.05,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2104,7532,785,40720,1519,3,57,2,2754.47,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2105,7532,786,40720,1519,3,482,1,162246.46,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2106,7532,786,40720,1519,3,68,1,34071.76,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2107,7532,786,40720,1519,3,482,1,3244.92,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2108,7532,786,40720,1519,3,57,2,199563.14,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2109,7532,787,40720,1519,3,482,1,75000.00,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2110,7532,787,40720,1519,3,57,2,75000.00,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2111,7532,788,40720,1519,3,482,1,661157.03,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2112,7532,788,40720,1519,3,68,1,138842.98,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2113,7532,788,40720,1519,3,57,2,800000.01,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2114,7532,789,40720,1519,3,482,1,9921.48,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2115,7532,789,40720,1519,3,68,1,2083.51,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2116,7532,789,40720,1519,3,57,2,12004.99,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2117,7532,790,40720,1519,3,482,1,80000.00,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2118,7532,790,40720,1519,3,57,2,80000.00,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2119,7532,791,40720,1519,3,482,1,99.17,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2120,7532,791,40720,1519,3,68,1,20.83,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2121,7532,791,40720,1519,3,57,2,120.00,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2122,7532,792,40720,1519,3,482,1,398016.53,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2123,7532,792,40720,1519,3,68,1,83583.47,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2124,7532,792,40720,1519,3,482,1,7960.33,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2125,7532,792,40720,1519,3,57,2,489560.33,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2126,7532,793,40720,1519,3,482,1,15867.77,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2127,7532,793,40720,1519,3,68,1,3332.23,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2128,7532,793,40720,1519,3,482,1,317.36,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2129,7532,793,40720,1519,3,57,2,19517.36,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2130,7532,794,40720,1519,3,482,1,86115.00,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2131,7532,794,40720,1519,3,68,1,18084.15,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2132,7532,794,40720,1519,3,482,1,1722.68,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2133,7532,794,40720,1519,3,57,2,105921.83,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2134,7532,795,40720,1519,3,482,1,9200.38,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14');
INSERT INTO `balance_libro_details` VALUES (2135,7532,795,40720,1519,3,68,1,1932.08,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2136,7532,795,40720,1519,3,482,1,184.17,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2137,7532,795,40720,1519,3,57,2,11316.63,NULL,'2022-08-17 10:38:39','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2138,7532,796,40720,1519,3,482,1,144628.10,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2139,7532,796,40720,1519,3,68,1,30371.90,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2140,7532,796,40720,1519,3,57,2,175000.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2141,7532,797,40720,1519,3,482,1,25368.21,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2142,7532,797,40720,1519,3,68,1,5327.32,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2143,7532,797,40720,1519,3,57,2,30695.53,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2144,7532,798,40720,1519,3,482,1,24953.15,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2145,7532,798,40720,1519,3,68,1,5240.16,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2146,7532,798,40720,1519,3,482,1,499.06,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2147,7532,798,40720,1519,3,57,2,30692.37,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2148,7532,799,40720,1519,3,482,1,115702.48,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2149,7532,799,40720,1519,3,68,1,24297.52,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2150,7532,799,40720,1519,3,57,2,140000.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2151,7532,800,40720,1519,3,482,1,2000.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2152,7532,800,40720,1519,3,68,1,420.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2153,7532,800,40720,1519,3,482,1,1580.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2154,7532,800,40720,1519,3,57,2,4000.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2155,7532,801,40720,1519,3,482,1,2876.03,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2156,7532,801,40720,1519,3,68,1,603.97,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2157,7532,801,40720,1519,3,57,2,3480.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2158,7532,802,40720,1519,3,482,1,958.68,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2159,7532,802,40720,1519,3,68,1,201.32,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2160,7532,802,40720,1519,3,57,2,1160.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2161,7532,803,40720,1519,3,482,1,426446.28,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2162,7532,803,40720,1519,3,68,1,89553.72,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2163,7532,803,40720,1519,3,482,1,8528.92,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2164,7532,803,40720,1519,3,57,2,524528.92,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2165,7532,804,40720,1519,3,482,1,27700.38,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2166,7532,804,40720,1519,3,68,1,5817.08,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2167,7532,804,40720,1519,3,482,1,554.03,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2168,7532,804,40720,1519,3,57,2,34071.49,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2169,7532,805,40720,1519,3,482,1,13254.41,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14');
INSERT INTO `balance_libro_details` VALUES (2170,7532,805,40720,1519,3,68,1,2783.43,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2171,7532,805,40720,1519,3,482,1,265.09,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2172,7532,805,40720,1519,3,57,2,16302.93,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2173,7532,806,40720,1519,3,482,1,10677.36,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2174,7532,806,40720,1519,3,68,1,2242.25,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2175,7532,806,40720,1519,3,482,1,213.55,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2176,7532,806,40720,1519,3,57,2,13133.16,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2177,7532,807,40720,1519,3,482,1,40000.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2178,7532,807,40720,1519,3,57,2,40000.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2179,7532,808,40720,1519,3,482,1,48000.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2180,7532,808,40720,1519,3,57,2,48000.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2181,7532,809,40720,1519,3,482,1,3681.82,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2182,7532,809,40720,1519,3,68,1,773.18,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2183,7532,809,40720,1519,3,57,2,4455.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2184,7532,810,40720,1519,3,482,1,8400.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2185,7532,810,40720,1519,3,68,1,1764.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2186,7532,810,40720,1519,3,57,2,10164.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2187,7532,811,40720,1519,3,482,1,2479.34,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2188,7532,811,40720,1519,3,68,1,520.66,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2189,7532,811,40720,1519,3,57,2,3000.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2190,7532,812,40720,1519,3,482,1,1382.64,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2191,7532,812,40720,1519,3,68,1,290.35,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2192,7532,812,40720,1519,3,482,1,27.65,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2193,7532,812,40720,1519,3,57,2,1700.64,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2194,7532,813,40720,1519,3,482,1,157824.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2195,7532,813,40720,1519,3,57,2,157824.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2196,7532,814,40720,1519,3,482,1,239000.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2197,7532,814,40720,1519,3,68,1,50190.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2198,7532,814,40720,1519,3,57,2,289190.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2199,7532,815,40720,1519,3,482,1,165990.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2200,7532,815,40720,1519,3,68,1,34857.90,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2201,7532,815,40720,1519,3,57,2,200847.90,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2202,7532,816,40720,1519,3,482,1,1046.40,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2203,7532,816,40720,1519,3,68,1,109.87,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2204,7532,816,40720,1519,3,57,2,1156.27,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14');
INSERT INTO `balance_libro_details` VALUES (2205,7532,817,40720,1519,3,482,1,330.58,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2206,7532,817,40720,1519,3,68,1,69.42,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2207,7532,817,40720,1519,3,57,2,400.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2208,7532,818,40720,1519,3,482,1,11646.38,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2209,7532,818,40720,1519,3,68,1,2445.74,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2210,7532,818,40720,1519,3,57,2,14092.12,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2211,7532,819,40720,1519,3,482,1,703.00,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2212,7532,819,40720,1519,3,68,1,147.63,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2213,7532,819,40720,1519,3,57,2,850.63,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2214,7532,820,40720,1519,3,482,1,28760.34,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2215,7532,820,40720,1519,3,68,1,6039.67,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2216,7532,820,40720,1519,3,57,2,34800.01,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2217,7532,821,40720,1519,3,482,1,3305.78,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2218,7532,821,40720,1519,3,68,1,694.21,NULL,'2022-08-17 10:38:40','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2219,7532,821,40720,1519,3,57,2,3999.99,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2220,7532,822,40720,1519,3,482,1,15041.35,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2221,7532,822,40720,1519,3,68,1,3158.68,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2222,7532,822,40720,1519,3,57,2,18200.03,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2223,7532,823,40720,1519,3,482,1,3986.03,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2224,7532,823,40720,1519,3,68,1,837.07,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2225,7532,823,40720,1519,3,57,2,4823.10,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2226,7532,824,40720,1519,3,482,1,1186.66,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2227,7532,824,40720,1519,3,68,1,249.20,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2228,7532,824,40720,1519,3,482,1,131.12,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2229,7532,824,40720,1519,3,68,1,13.77,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2230,7532,824,40720,1519,3,57,2,1580.75,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2231,7532,825,40720,1519,3,482,1,46155.60,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2232,7532,825,40720,1519,3,68,1,9692.68,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2233,7532,825,40720,1519,3,482,1,923.11,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2234,7532,825,40720,1519,3,57,2,56771.39,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2235,7532,826,40720,1519,3,482,1,5509.98,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2236,7532,826,40720,1519,3,68,1,1157.10,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2237,7532,826,40720,1519,3,482,1,110.20,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2238,7532,826,40720,1519,3,57,2,6777.28,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2239,7532,827,40720,1519,3,482,1,7500.00,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14');
INSERT INTO `balance_libro_details` VALUES (2240,7532,827,40720,1519,3,57,2,7500.00,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2241,7532,828,40720,1519,3,482,1,24793.38,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2242,7532,828,40720,1519,3,68,1,5206.61,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2243,7532,828,40720,1519,3,57,2,29999.99,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2244,7532,829,40720,1519,3,482,1,81454.55,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2245,7532,829,40720,1519,3,68,1,17105.46,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2246,7532,829,40720,1519,3,57,2,98560.01,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2247,7532,830,40720,1519,3,482,1,197181.82,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2248,7532,830,40720,1519,3,68,1,41408.18,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2249,7532,830,40720,1519,3,57,2,238590.00,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2250,7532,831,40720,1519,3,482,1,328925.62,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2251,7532,831,40720,1519,3,68,1,69074.38,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2252,7532,831,40720,1519,3,57,2,398000.00,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2253,7532,832,40720,1519,3,482,1,218884.36,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2254,7532,832,40720,1519,3,68,1,45965.72,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2255,7532,832,40720,1519,3,57,2,264850.08,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2256,7532,833,40720,1519,3,482,2,2067.86,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2257,7532,833,40720,1519,3,67,2,434.25,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2258,7532,833,40720,1519,3,57,1,2502.11,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2259,7532,834,40720,1519,3,482,1,4153.52,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2260,7532,834,40720,1519,3,68,1,872.24,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2261,7532,834,40720,1519,3,482,1,83.07,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2262,7532,834,40720,1519,3,57,2,5108.83,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2263,7532,835,40720,1519,3,482,1,5478.78,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2264,7532,835,40720,1519,3,68,1,1150.54,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2265,7532,835,40720,1519,3,482,1,109.58,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2266,7532,835,40720,1519,3,57,2,6738.90,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:14','2022-08-17 10:41:14'),(2267,7532,836,40720,1519,3,482,1,661157.03,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2268,7532,836,40720,1519,3,68,1,138842.98,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2269,7532,836,40720,1519,3,57,2,800000.01,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2270,7532,837,40720,1519,3,482,1,23966.94,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2271,7532,837,40720,1519,3,68,1,5033.06,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2272,7532,837,40720,1519,3,57,2,29000.00,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2273,7532,838,40720,1519,3,482,1,32066.10,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2274,7532,838,40720,1519,3,68,1,6733.88,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15');
INSERT INTO `balance_libro_details` VALUES (2275,7532,838,40720,1519,3,57,2,38799.98,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2276,7532,839,40720,1519,3,482,1,5851.24,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2277,7532,839,40720,1519,3,68,1,1228.76,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2278,7532,839,40720,1519,3,57,2,7080.00,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2279,7532,840,40720,1519,3,482,1,1446.28,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2280,7532,840,40720,1519,3,68,1,303.72,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2281,7532,840,40720,1519,3,57,2,1750.00,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2282,7532,841,40720,1519,3,482,1,10510.00,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2283,7532,841,40720,1519,3,57,2,10510.00,NULL,'2022-08-17 10:38:41','2022-08-17 10:41:15','2022-08-17 10:41:15'),(2284,7532,842,40720,1518,3,482,1,40000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2285,7532,842,40720,1518,3,57,2,40000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2286,7532,843,40720,1518,3,482,1,8100000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2287,7532,843,40720,1518,3,68,1,1701000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2288,7532,843,40720,1518,3,57,2,9801000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2289,7532,844,40720,1518,3,482,1,1345309.92,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2290,7532,844,40720,1518,3,68,1,282515.08,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2291,7532,844,40720,1518,3,57,2,1627825.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2292,7532,845,40720,1518,3,482,1,182644.63,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2293,7532,845,40720,1518,3,68,1,38355.37,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2294,7532,845,40720,1518,3,57,2,221000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2295,7532,846,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2296,7532,846,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2297,7532,847,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2298,7532,847,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2299,7532,848,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2300,7532,848,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2301,7532,849,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2302,7532,849,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2303,7532,850,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2304,7532,850,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2305,7532,851,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2306,7532,851,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2307,7532,852,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2308,7532,852,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2309,7532,853,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08');
INSERT INTO `balance_libro_details` VALUES (2310,7532,853,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2311,7532,854,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2312,7532,854,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:35','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2313,7532,855,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2314,7532,855,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2315,7532,856,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2316,7532,856,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2317,7532,857,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2318,7532,857,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2319,7532,858,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2320,7532,858,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2321,7532,859,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2322,7532,859,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2323,7532,860,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 10:52:20','2022-08-17 10:52:20'),(2324,7532,860,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 10:52:20','2022-08-17 10:52:20'),(2325,7532,861,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2326,7532,861,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2327,7532,862,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2328,7532,862,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2329,7532,863,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2330,7532,863,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2331,7532,864,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2332,7532,864,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2333,7532,865,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2334,7532,865,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2335,7532,866,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2336,7532,866,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2337,7532,867,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2338,7532,867,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2339,7532,868,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2340,7532,868,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2341,7532,869,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2342,7532,869,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2343,7532,870,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2344,7532,870,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08');
INSERT INTO `balance_libro_details` VALUES (2345,7532,871,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2346,7532,871,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2347,7532,872,40720,1518,3,482,1,35000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2348,7532,872,40720,1518,3,57,2,35000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2349,7532,873,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2350,7532,873,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2351,7532,874,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2352,7532,874,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2353,7532,875,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2354,7532,875,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2355,7532,876,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2356,7532,876,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2357,7532,877,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2358,7532,877,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 10:41:36','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2359,7532,878,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2360,7532,878,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2361,7532,879,40720,1518,3,482,1,35000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2362,7532,879,40720,1518,3,57,2,35000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2363,7532,880,40720,1518,3,482,1,50000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2364,7532,880,40720,1518,3,57,2,50000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2365,7532,881,40720,1518,3,482,1,75000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2366,7532,881,40720,1518,3,57,2,75000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2367,7532,882,40720,1518,3,482,1,124225.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2368,7532,882,40720,1518,3,68,1,26087.25,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2369,7532,882,40720,1518,3,57,2,150312.25,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2370,7532,883,40720,1518,3,482,1,289091.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2371,7532,883,40720,1518,3,68,1,60709.11,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2372,7532,883,40720,1518,3,57,2,349800.11,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2373,7532,884,40720,1518,3,482,1,171100.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2374,7532,884,40720,1518,3,68,1,35931.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2375,7532,884,40720,1518,3,57,2,207031.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2376,7532,885,40720,1518,3,482,1,6148.26,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2377,7532,885,40720,1518,3,68,1,1291.13,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2378,7532,885,40720,1518,3,57,2,7439.39,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2379,7532,886,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08');
INSERT INTO `balance_libro_details` VALUES (2380,7532,886,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2381,7532,887,40720,1518,3,482,1,4363.64,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2382,7532,887,40720,1518,3,68,1,916.36,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2383,7532,887,40720,1518,3,57,2,5280.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2384,7532,888,40720,1518,3,482,1,60000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2385,7532,888,40720,1518,3,57,2,60000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2386,7532,889,40720,1518,3,482,1,200000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2387,7532,889,40720,1518,3,57,2,200000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2388,7532,890,40720,1518,3,482,1,1544.72,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2389,7532,890,40720,1518,3,68,1,324.39,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2390,7532,890,40720,1518,3,57,2,1869.11,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2391,7532,891,40720,1518,3,482,1,36614.20,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2392,7532,891,40720,1518,3,68,1,7688.98,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2393,7532,891,40720,1518,3,482,1,732.29,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2394,7532,891,40720,1518,3,57,2,45035.47,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2395,7532,892,40720,1518,3,482,1,826446.28,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2396,7532,892,40720,1518,3,68,1,173553.72,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2397,7532,892,40720,1518,3,57,2,1000000.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2398,7532,893,40720,1518,3,482,1,578.51,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2399,7532,893,40720,1518,3,68,1,121.49,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2400,7532,893,40720,1518,3,57,2,700.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2401,7532,894,40720,1518,3,482,1,537.19,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2402,7532,894,40720,1518,3,68,1,112.81,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2403,7532,894,40720,1518,3,57,2,650.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2404,7532,895,40720,1518,3,482,1,272.73,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2405,7532,895,40720,1518,3,68,1,57.27,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2406,7532,895,40720,1518,3,57,2,330.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2407,7532,896,40720,1518,3,482,1,24793.38,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2408,7532,896,40720,1518,3,68,1,5206.61,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2409,7532,896,40720,1518,3,57,2,29999.99,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2410,7532,897,40720,1518,3,482,1,4214.88,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2411,7532,897,40720,1518,3,68,1,885.12,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2412,7532,897,40720,1518,3,57,2,5100.00,NULL,'2022-08-17 10:41:37','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2413,7532,898,40720,1518,3,482,1,132231.41,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2414,7532,898,40720,1518,3,68,1,27768.60,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08');
INSERT INTO `balance_libro_details` VALUES (2415,7532,898,40720,1518,3,57,2,160000.01,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2416,7532,899,40720,1518,3,482,1,1157.03,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2417,7532,899,40720,1518,3,68,1,242.98,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2418,7532,899,40720,1518,3,57,2,1400.01,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2419,7532,900,40720,1518,3,482,1,1223.14,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2420,7532,900,40720,1518,3,68,1,256.86,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2421,7532,900,40720,1518,3,57,2,1480.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2422,7532,901,40720,1518,3,482,1,2276.42,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2423,7532,901,40720,1518,3,68,1,478.05,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2424,7532,901,40720,1518,3,57,2,2754.47,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2425,7532,902,40720,1518,3,482,1,162246.46,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2426,7532,902,40720,1518,3,68,1,34071.76,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2427,7532,902,40720,1518,3,482,1,3244.92,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2428,7532,902,40720,1518,3,57,2,199563.14,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2429,7532,903,40720,1518,3,482,1,75000.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2430,7532,903,40720,1518,3,57,2,75000.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2431,7532,904,40720,1518,3,482,1,661157.03,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2432,7532,904,40720,1518,3,68,1,138842.98,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2433,7532,904,40720,1518,3,57,2,800000.01,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:08','2022-08-17 11:02:08'),(2434,7532,905,40720,1518,3,482,1,9921.48,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2435,7532,905,40720,1518,3,68,1,2083.51,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2436,7532,905,40720,1518,3,57,2,12004.99,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2437,7532,906,40720,1518,3,482,1,80000.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2438,7532,906,40720,1518,3,57,2,80000.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2439,7532,907,40720,1518,3,482,1,99.17,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2440,7532,907,40720,1518,3,68,1,20.83,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2441,7532,907,40720,1518,3,57,2,120.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2442,7532,908,40720,1518,3,482,1,398016.53,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2443,7532,908,40720,1518,3,68,1,83583.47,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2444,7532,908,40720,1518,3,482,1,7960.33,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2445,7532,908,40720,1518,3,57,2,489560.33,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2446,7532,909,40720,1518,3,482,1,15867.77,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2447,7532,909,40720,1518,3,68,1,3332.23,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2448,7532,909,40720,1518,3,482,1,317.36,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2449,7532,909,40720,1518,3,57,2,19517.36,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09');
INSERT INTO `balance_libro_details` VALUES (2450,7532,910,40720,1518,3,482,1,86115.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2451,7532,910,40720,1518,3,68,1,18084.15,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2452,7532,910,40720,1518,3,482,1,1722.68,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2453,7532,910,40720,1518,3,57,2,105921.83,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2454,7532,911,40720,1518,3,482,1,9200.38,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2455,7532,911,40720,1518,3,68,1,1932.08,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2456,7532,911,40720,1518,3,482,1,184.17,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2457,7532,911,40720,1518,3,57,2,11316.63,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2458,7532,912,40720,1518,3,482,1,144628.10,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2459,7532,912,40720,1518,3,68,1,30371.90,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2460,7532,912,40720,1518,3,57,2,175000.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2461,7532,913,40720,1518,3,482,1,25368.21,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2462,7532,913,40720,1518,3,68,1,5327.32,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2463,7532,913,40720,1518,3,57,2,30695.53,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2464,7532,914,40720,1518,3,482,1,24953.15,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2465,7532,914,40720,1518,3,68,1,5240.16,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2466,7532,914,40720,1518,3,482,1,499.06,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2467,7532,914,40720,1518,3,57,2,30692.37,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2468,7532,915,40720,1518,3,482,1,115702.48,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2469,7532,915,40720,1518,3,68,1,24297.52,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2470,7532,915,40720,1518,3,57,2,140000.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2471,7532,916,40720,1518,3,482,1,2000.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2472,7532,916,40720,1518,3,68,1,420.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2473,7532,916,40720,1518,3,482,1,1580.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2474,7532,916,40720,1518,3,57,2,4000.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2475,7532,917,40720,1518,3,482,1,2876.03,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2476,7532,917,40720,1518,3,68,1,603.97,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2477,7532,917,40720,1518,3,57,2,3480.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2478,7532,918,40720,1518,3,482,1,958.68,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2479,7532,918,40720,1518,3,68,1,201.32,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2480,7532,918,40720,1518,3,57,2,1160.00,NULL,'2022-08-17 10:41:38','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2481,7532,919,40720,1518,3,482,1,426446.28,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2482,7532,919,40720,1518,3,68,1,89553.72,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2483,7532,919,40720,1518,3,482,1,8528.92,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2484,7532,919,40720,1518,3,57,2,524528.92,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09');
INSERT INTO `balance_libro_details` VALUES (2485,7532,920,40720,1518,3,482,1,27700.38,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2486,7532,920,40720,1518,3,68,1,5817.08,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2487,7532,920,40720,1518,3,482,1,554.03,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2488,7532,920,40720,1518,3,57,2,34071.49,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2489,7532,921,40720,1518,3,482,1,13254.41,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2490,7532,921,40720,1518,3,68,1,2783.43,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2491,7532,921,40720,1518,3,482,1,265.09,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2492,7532,921,40720,1518,3,57,2,16302.93,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2493,7532,922,40720,1518,3,482,1,10677.36,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2494,7532,922,40720,1518,3,68,1,2242.25,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2495,7532,922,40720,1518,3,482,1,213.55,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2496,7532,922,40720,1518,3,57,2,13133.16,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2497,7532,923,40720,1518,3,482,1,40000.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2498,7532,923,40720,1518,3,57,2,40000.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2499,7532,924,40720,1518,3,482,1,48000.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2500,7532,924,40720,1518,3,57,2,48000.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2501,7532,925,40720,1518,3,482,1,3681.82,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2502,7532,925,40720,1518,3,68,1,773.18,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2503,7532,925,40720,1518,3,57,2,4455.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2504,7532,926,40720,1518,3,482,1,8400.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2505,7532,926,40720,1518,3,68,1,1764.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2506,7532,926,40720,1518,3,57,2,10164.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2507,7532,927,40720,1518,3,482,1,2479.34,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2508,7532,927,40720,1518,3,68,1,520.66,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2509,7532,927,40720,1518,3,57,2,3000.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2510,7532,928,40720,1518,3,482,1,1382.64,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2511,7532,928,40720,1518,3,68,1,290.35,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2512,7532,928,40720,1518,3,482,1,27.65,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2513,7532,928,40720,1518,3,57,2,1700.64,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2514,7532,929,40720,1518,3,482,1,157824.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2515,7532,929,40720,1518,3,57,2,157824.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2516,7532,930,40720,1518,3,482,1,239000.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2517,7532,930,40720,1518,3,68,1,50190.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2518,7532,930,40720,1518,3,57,2,289190.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2519,7532,931,40720,1518,3,482,1,165990.00,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09');
INSERT INTO `balance_libro_details` VALUES (2520,7532,931,40720,1518,3,68,1,34857.90,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2521,7532,931,40720,1518,3,57,2,200847.90,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2522,7532,932,40720,1518,3,482,1,1046.40,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2523,7532,932,40720,1518,3,68,1,109.87,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2524,7532,932,40720,1518,3,57,2,1156.27,NULL,'2022-08-17 10:41:39','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2525,7532,933,40720,1518,3,482,1,330.58,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2526,7532,933,40720,1518,3,68,1,69.42,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2527,7532,933,40720,1518,3,57,2,400.00,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2528,7532,934,40720,1518,3,482,1,11646.38,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2529,7532,934,40720,1518,3,68,1,2445.74,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2530,7532,934,40720,1518,3,57,2,14092.12,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2531,7532,935,40720,1518,3,482,1,703.00,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2532,7532,935,40720,1518,3,68,1,147.63,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2533,7532,935,40720,1518,3,57,2,850.63,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2534,7532,936,40720,1518,3,482,1,28760.34,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2535,7532,936,40720,1518,3,68,1,6039.67,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2536,7532,936,40720,1518,3,57,2,34800.01,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2537,7532,937,40720,1518,3,482,1,3305.78,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2538,7532,937,40720,1518,3,68,1,694.21,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2539,7532,937,40720,1518,3,57,2,3999.99,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2540,7532,938,40720,1518,3,482,1,15041.35,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2541,7532,938,40720,1518,3,68,1,3158.68,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2542,7532,938,40720,1518,3,57,2,18200.03,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2543,7532,939,40720,1518,3,482,1,3986.03,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2544,7532,939,40720,1518,3,68,1,837.07,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2545,7532,939,40720,1518,3,57,2,4823.10,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2546,7532,940,40720,1518,3,482,1,1186.66,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2547,7532,940,40720,1518,3,68,1,249.20,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2548,7532,940,40720,1518,3,482,1,131.12,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2549,7532,940,40720,1518,3,68,1,13.77,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2550,7532,940,40720,1518,3,57,2,1580.75,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2551,7532,941,40720,1518,3,482,1,46155.60,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2552,7532,941,40720,1518,3,68,1,9692.68,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2553,7532,941,40720,1518,3,482,1,923.11,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2554,7532,941,40720,1518,3,57,2,56771.39,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09');
INSERT INTO `balance_libro_details` VALUES (2555,7532,942,40720,1518,3,482,1,5509.98,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2556,7532,942,40720,1518,3,68,1,1157.10,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2557,7532,942,40720,1518,3,482,1,110.20,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2558,7532,942,40720,1518,3,57,2,6777.28,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2559,7532,943,40720,1518,3,482,1,7500.00,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2560,7532,943,40720,1518,3,57,2,7500.00,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2561,7532,944,40720,1518,3,482,1,24793.38,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2562,7532,944,40720,1518,3,68,1,5206.61,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2563,7532,944,40720,1518,3,57,2,29999.99,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2564,7532,945,40720,1518,3,482,1,81454.55,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2565,7532,945,40720,1518,3,68,1,17105.46,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2566,7532,945,40720,1518,3,57,2,98560.01,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2567,7532,946,40720,1518,3,482,1,197181.82,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2568,7532,946,40720,1518,3,68,1,41408.18,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2569,7532,946,40720,1518,3,57,2,238590.00,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2570,7532,947,40720,1518,3,482,1,328925.62,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2571,7532,947,40720,1518,3,68,1,69074.38,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2572,7532,947,40720,1518,3,57,2,398000.00,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2573,7532,948,40720,1518,3,482,1,218884.36,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2574,7532,948,40720,1518,3,68,1,45965.72,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2575,7532,948,40720,1518,3,57,2,264850.08,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2576,7532,949,40720,1518,3,482,2,2067.86,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2577,7532,949,40720,1518,3,67,2,434.25,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2578,7532,949,40720,1518,3,57,1,2502.11,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2579,7532,950,40720,1518,3,482,1,4153.52,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2580,7532,950,40720,1518,3,68,1,872.24,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2581,7532,950,40720,1518,3,482,1,83.07,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2582,7532,950,40720,1518,3,57,2,5108.83,NULL,'2022-08-17 10:41:40','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2583,7532,951,40720,1518,3,482,1,5478.78,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2584,7532,951,40720,1518,3,68,1,1150.54,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2585,7532,951,40720,1518,3,482,1,109.58,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2586,7532,951,40720,1518,3,57,2,6738.90,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2587,7532,952,40720,1518,3,482,1,661157.03,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2588,7532,952,40720,1518,3,68,1,138842.98,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2589,7532,952,40720,1518,3,57,2,800000.01,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09');
INSERT INTO `balance_libro_details` VALUES (2590,7532,953,40720,1518,3,482,1,23966.94,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2591,7532,953,40720,1518,3,68,1,5033.06,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2592,7532,953,40720,1518,3,57,2,29000.00,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2593,7532,954,40720,1518,3,482,1,32066.10,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2594,7532,954,40720,1518,3,68,1,6733.88,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2595,7532,954,40720,1518,3,57,2,38799.98,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2596,7532,955,40720,1518,3,482,1,5851.24,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2597,7532,955,40720,1518,3,68,1,1228.76,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2598,7532,955,40720,1518,3,57,2,7080.00,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2599,7532,956,40720,1518,3,482,1,1446.28,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2600,7532,956,40720,1518,3,68,1,303.72,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2601,7532,956,40720,1518,3,57,2,1750.00,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2602,7532,957,40720,1518,3,482,1,10510.00,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2603,7532,957,40720,1518,3,57,2,10510.00,NULL,'2022-08-17 10:41:41','2022-08-17 11:02:09','2022-08-17 11:02:09'),(2604,7532,958,40720,1521,3,217,1,249000.00,NULL,'2022-08-17 10:45:12','2022-08-17 10:45:12',NULL),(2605,7532,958,40720,1521,3,68,1,52290.00,NULL,'2022-08-17 10:45:12','2022-08-17 10:45:12',NULL),(2606,7532,958,40720,1521,3,57,2,301290.00,NULL,'2022-08-17 10:45:12','2022-08-17 10:45:12',NULL),(2607,7532,959,40720,1521,3,482,1,333801.65,NULL,'2022-08-17 10:45:12','2022-08-17 10:45:12',NULL),(2608,7532,959,40720,1521,3,68,1,70098.35,NULL,'2022-08-17 10:45:12','2022-08-17 10:45:12',NULL),(2609,7532,959,40720,1521,3,57,2,403900.00,NULL,'2022-08-17 10:45:12','2022-08-17 10:45:12',NULL),(2610,7532,960,40720,1521,3,217,1,1345309.92,NULL,'2022-08-17 10:45:12','2022-08-17 10:45:12',NULL),(2611,7532,960,40720,1521,3,68,1,282515.08,NULL,'2022-08-17 10:45:12','2022-08-17 10:45:12',NULL),(2612,7532,960,40720,1521,3,57,2,1627825.00,NULL,'2022-08-17 10:45:12','2022-08-17 10:45:12',NULL),(2613,7532,961,40720,1521,3,217,1,182644.63,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2614,7532,961,40720,1521,3,68,1,38355.37,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2615,7532,961,40720,1521,3,57,2,221000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2616,7532,962,40720,1521,3,217,1,2099.17,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2617,7532,962,40720,1521,3,68,1,440.83,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2618,7532,962,40720,1521,3,57,2,2540.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2619,7532,963,40720,1521,3,217,1,876.03,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2620,7532,963,40720,1521,3,68,1,183.97,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2621,7532,963,40720,1521,3,57,2,1060.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2622,7532,964,40720,1521,3,250,1,35000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2623,7532,964,40720,1521,3,57,2,35000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2624,7532,965,40720,1521,3,250,1,50000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2625,7532,965,40720,1521,3,57,2,50000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2626,7532,966,40720,1521,3,250,1,60000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2627,7532,966,40720,1521,3,57,2,60000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL);
INSERT INTO `balance_libro_details` VALUES (2628,7532,967,40720,1521,3,250,1,75000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2629,7532,967,40720,1521,3,57,2,75000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2630,7532,968,40720,1521,3,250,1,75000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2631,7532,968,40720,1521,3,57,2,75000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2632,7532,969,40720,1521,3,250,1,50000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2633,7532,969,40720,1521,3,57,2,50000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2634,7532,970,40720,1521,3,250,1,100000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2635,7532,970,40720,1521,3,57,2,100000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2636,7532,971,40720,1521,3,250,1,50000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2637,7532,971,40720,1521,3,57,2,50000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2638,7532,972,40720,1521,3,250,1,50000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2639,7532,972,40720,1521,3,57,2,50000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2640,7532,973,40720,1521,3,217,1,193000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2641,7532,973,40720,1521,3,68,1,40530.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2642,7532,973,40720,1521,3,57,2,233530.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2643,7532,974,40720,1521,3,217,1,199000.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2644,7532,974,40720,1521,3,68,1,41790.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2645,7532,974,40720,1521,3,57,2,240790.00,NULL,'2022-08-17 10:45:13','2022-08-17 10:45:13',NULL),(2646,7532,975,40720,1521,3,217,2,61776.86,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2647,7532,975,40720,1521,3,67,2,12973.14,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2648,7532,975,40720,1521,3,57,1,74750.00,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2649,7532,976,40720,1521,3,217,2,86776.86,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2650,7532,976,40720,1521,3,67,2,18223.14,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2651,7532,976,40720,1521,3,57,1,105000.00,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2652,7532,977,40720,1521,3,217,1,61776.86,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2653,7532,977,40720,1521,3,68,1,12973.14,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2654,7532,977,40720,1521,3,57,2,74750.00,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2655,7532,978,40720,1521,3,217,1,86776.86,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2656,7532,978,40720,1521,3,68,1,18223.14,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2657,7532,978,40720,1521,3,57,2,105000.00,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2658,7532,979,40720,1521,3,217,1,61776.86,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2659,7532,979,40720,1521,3,68,1,12973.14,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2660,7532,979,40720,1521,3,57,2,74750.00,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2661,7532,980,40720,1521,3,217,1,86776.86,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2662,7532,980,40720,1521,3,68,1,18223.14,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2663,7532,980,40720,1521,3,57,2,105000.00,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2664,7532,981,40720,1521,3,217,1,776.86,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2665,7532,981,40720,1521,3,68,1,163.14,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2666,7532,981,40720,1521,3,57,2,940.00,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2667,7532,982,40720,1521,3,217,1,10429.72,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2668,7532,982,40720,1521,3,68,1,2190.24,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL);
INSERT INTO `balance_libro_details` VALUES (2669,7532,982,40720,1521,3,57,2,12619.96,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2670,7532,983,40720,1521,3,217,1,4132.23,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2671,7532,983,40720,1521,3,68,1,867.77,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2672,7532,983,40720,1521,3,57,2,5000.00,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2673,7532,984,40720,1521,3,217,1,140305.79,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2674,7532,984,40720,1521,3,68,1,29464.22,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2675,7532,984,40720,1521,3,57,2,169770.01,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2676,7532,985,40720,1521,3,217,1,1190.16,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2677,7532,985,40720,1521,3,68,1,249.93,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2678,7532,985,40720,1521,3,57,2,1440.09,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2679,7532,986,40720,1521,3,217,1,184.30,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2680,7532,986,40720,1521,3,68,1,38.70,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2681,7532,986,40720,1521,3,57,2,223.00,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2682,7532,987,40720,1521,3,217,1,1115.70,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2683,7532,987,40720,1521,3,68,1,234.30,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2684,7532,987,40720,1521,3,57,2,1350.00,NULL,'2022-08-17 10:45:14','2022-08-17 10:45:14',NULL),(2685,7532,988,40720,1521,3,250,1,35000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2686,7532,988,40720,1521,3,57,2,35000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2687,7532,989,40720,1521,3,250,1,75000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2688,7532,989,40720,1521,3,57,2,75000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2689,7532,990,40720,1521,3,250,1,75000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2690,7532,990,40720,1521,3,57,2,75000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2691,7532,991,40720,1521,3,250,1,30000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2692,7532,991,40720,1521,3,57,2,30000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2693,7532,992,40720,1521,3,250,1,65000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2694,7532,992,40720,1521,3,57,2,65000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2695,7532,993,40720,1521,3,250,1,75000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2696,7532,993,40720,1521,3,57,2,75000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2697,7532,994,40720,1521,3,250,1,40000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2698,7532,994,40720,1521,3,57,2,40000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2699,7532,995,40720,1521,3,250,1,35000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2700,7532,995,40720,1521,3,57,2,35000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2701,7532,996,40720,1521,3,217,1,185900.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2702,7532,996,40720,1521,3,68,1,39039.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2703,7532,996,40720,1521,3,57,2,224939.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2704,7532,997,40720,1521,3,217,1,10743.80,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2705,7532,997,40720,1521,3,68,1,2256.20,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2706,7532,997,40720,1521,3,57,2,13000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2707,7532,998,40720,1521,3,217,1,8581.82,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2708,7532,998,40720,1521,3,68,1,1802.18,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2709,7532,998,40720,1521,3,57,2,10384.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL);
INSERT INTO `balance_libro_details` VALUES (2710,7532,999,40720,1521,3,217,1,5483.47,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2711,7532,999,40720,1521,3,68,1,1151.53,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2712,7532,999,40720,1521,3,57,2,6635.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2713,7532,1000,40720,1521,3,250,1,140000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2714,7532,1000,40720,1521,3,57,2,140000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2715,7532,1001,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2716,7532,1001,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2717,7532,1002,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2718,7532,1002,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2719,7532,1003,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2720,7532,1003,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:15','2022-08-17 10:45:15',NULL),(2721,7532,1004,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2722,7532,1004,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2723,7532,1005,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2724,7532,1005,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2725,7532,1006,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2726,7532,1006,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2727,7532,1007,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2728,7532,1007,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2729,7532,1008,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2730,7532,1008,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2731,7532,1009,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2732,7532,1009,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2733,7532,1010,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2734,7532,1010,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2735,7532,1011,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2736,7532,1011,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2737,7532,1012,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2738,7532,1012,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2739,7532,1013,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2740,7532,1013,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2741,7532,1014,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2742,7532,1014,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2743,7532,1015,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2744,7532,1015,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2745,7532,1016,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2746,7532,1016,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2747,7532,1017,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2748,7532,1017,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2749,7532,1018,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL);
INSERT INTO `balance_libro_details` VALUES (2750,7532,1018,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2751,7532,1019,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2752,7532,1019,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2753,7532,1020,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2754,7532,1020,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2755,7532,1021,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2756,7532,1021,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2757,7532,1022,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2758,7532,1022,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2759,7532,1023,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2760,7532,1023,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:16','2022-08-17 10:45:16',NULL),(2761,7532,1024,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2762,7532,1024,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2763,7532,1025,40720,1521,3,250,1,35000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2764,7532,1025,40720,1521,3,57,2,35000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2765,7532,1026,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2766,7532,1026,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2767,7532,1027,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2768,7532,1027,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2769,7532,1028,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2770,7532,1028,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2771,7532,1029,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2772,7532,1029,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2773,7532,1030,40720,1521,3,482,1,25000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2774,7532,1030,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2775,7532,1031,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2776,7532,1031,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2777,7532,1032,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2778,7532,1032,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2779,7532,1033,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2780,7532,1033,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2781,7532,1034,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2782,7532,1034,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2783,7532,1035,40720,1521,3,250,1,35000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2784,7532,1035,40720,1521,3,57,2,35000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2785,7532,1036,40720,1521,3,217,1,4859.50,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2786,7532,1036,40720,1521,3,68,1,1020.50,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2787,7532,1036,40720,1521,3,57,2,5880.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2788,7532,1037,40720,1521,3,217,1,3140.50,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2789,7532,1037,40720,1521,3,68,1,659.51,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL);
INSERT INTO `balance_libro_details` VALUES (2790,7532,1037,40720,1521,3,57,2,3800.01,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2791,7532,1038,40720,1521,3,217,1,15677.74,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2792,7532,1038,40720,1521,3,68,1,3292.33,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2793,7532,1038,40720,1521,3,233,1,313.55,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2794,7532,1038,40720,1521,3,57,2,19283.62,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2795,7532,1039,40720,1521,3,217,1,2925.31,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2796,7532,1039,40720,1521,3,68,1,614.32,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2797,7532,1039,40720,1521,3,57,2,3539.63,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2798,7532,1040,40720,1521,3,217,1,3305.80,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2799,7532,1040,40720,1521,3,68,1,694.22,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2800,7532,1040,40720,1521,3,57,2,4000.02,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2801,7532,1041,40720,1521,3,217,1,743.78,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2802,7532,1041,40720,1521,3,68,1,156.19,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2803,7532,1041,40720,1521,3,57,2,899.97,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2804,7532,1042,40720,1521,3,250,1,30000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2805,7532,1042,40720,1521,3,57,2,30000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2806,7532,1043,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2807,7532,1043,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2808,7532,1044,40720,1521,3,217,1,45500.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2809,7532,1044,40720,1521,3,68,1,9555.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2810,7532,1044,40720,1521,3,57,2,55055.00,NULL,'2022-08-17 10:45:17','2022-08-17 10:45:17',NULL),(2811,7532,1045,40720,1521,3,217,1,132231.41,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2812,7532,1045,40720,1521,3,68,1,27768.60,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2813,7532,1045,40720,1521,3,57,2,160000.01,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2814,7532,1046,40720,1521,3,217,1,10743.80,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2815,7532,1046,40720,1521,3,68,1,2256.20,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2816,7532,1046,40720,1521,3,57,2,13000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2817,7532,1047,40720,1521,3,217,1,22314.06,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2818,7532,1047,40720,1521,3,68,1,4685.95,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2819,7532,1047,40720,1521,3,233,1,446.28,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2820,7532,1047,40720,1521,3,57,2,27446.29,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2821,7532,1048,40720,1521,3,250,1,60000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2822,7532,1048,40720,1521,3,57,2,60000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2823,7532,1049,40720,1521,3,250,1,60000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2824,7532,1049,40720,1521,3,57,2,60000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2825,7532,1050,40720,1521,3,217,1,2578.52,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2826,7532,1050,40720,1521,3,68,1,541.49,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2827,7532,1050,40720,1521,3,57,2,3120.01,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2828,7532,1051,40720,1521,3,217,1,22876.28,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2829,7532,1051,40720,1521,3,68,1,4804.02,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2830,7532,1051,40720,1521,3,233,1,457.53,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL);
INSERT INTO `balance_libro_details` VALUES (2831,7532,1051,40720,1521,3,57,2,28137.83,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2832,7532,1052,40720,1521,3,250,1,150000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2833,7532,1052,40720,1521,3,57,2,150000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2834,7532,1053,40720,1521,3,250,1,4897.56,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2835,7532,1053,40720,1521,3,57,2,4897.56,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2836,7532,1054,40720,1521,3,217,1,157024.79,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2837,7532,1054,40720,1521,3,68,1,32975.21,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2838,7532,1054,40720,1521,3,57,2,190000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2839,7532,1055,40720,1521,3,217,1,24990.44,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2840,7532,1055,40720,1521,3,68,1,5247.99,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2841,7532,1055,40720,1521,3,57,2,30238.43,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2842,7532,1056,40720,1521,3,482,1,58875.90,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2843,7532,1056,40720,1521,3,68,1,12363.94,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2844,7532,1056,40720,1521,3,482,1,2682.07,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2845,7532,1056,40720,1521,3,68,1,281.62,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2846,7532,1056,40720,1521,3,233,1,1231.16,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2847,7532,1056,40720,1521,3,57,2,75434.69,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2848,7532,1057,40720,1521,3,482,1,19851.30,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2849,7532,1057,40720,1521,3,68,1,4168.77,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2850,7532,1057,40720,1521,3,233,1,397.03,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2851,7532,1057,40720,1521,3,57,2,24417.10,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2852,7532,1058,40720,1521,3,250,1,340000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2853,7532,1058,40720,1521,3,57,2,340000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2854,7532,1059,40720,1521,3,250,1,140000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2855,7532,1059,40720,1521,3,57,2,140000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2856,7532,1060,40720,1521,3,250,1,520.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2857,7532,1060,40720,1521,3,57,2,520.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2858,7532,1061,40720,1521,3,250,1,45000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2859,7532,1061,40720,1521,3,57,2,45000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2860,7532,1062,40720,1521,3,250,1,60000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2861,7532,1062,40720,1521,3,57,2,60000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2862,7532,1063,40720,1521,3,217,1,1000000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2863,7532,1063,40720,1521,3,68,1,210000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2864,7532,1063,40720,1521,3,57,2,1210000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2865,7532,1064,40720,1521,3,250,1,5000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2866,7532,1064,40720,1521,3,57,2,5000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2867,7532,1065,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2868,7532,1065,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2869,7532,1066,40720,1521,3,217,1,380377.69,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2870,7532,1066,40720,1521,3,68,1,79879.31,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL);
INSERT INTO `balance_libro_details` VALUES (2871,7532,1066,40720,1521,3,57,2,460257.00,NULL,'2022-08-17 10:45:18','2022-08-17 10:45:18',NULL),(2872,7532,1067,40720,1521,3,217,1,10347.11,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2873,7532,1067,40720,1521,3,68,1,2172.89,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2874,7532,1067,40720,1521,3,57,2,12520.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2875,7532,1068,40720,1521,3,217,2,1581.60,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2876,7532,1068,40720,1521,3,67,2,332.14,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2877,7532,1068,40720,1521,3,57,1,1913.74,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2878,7532,1069,40720,1521,3,217,1,1581.60,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2879,7532,1069,40720,1521,3,68,1,332.14,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2880,7532,1069,40720,1521,3,57,2,1913.74,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2881,7532,1070,40720,1521,3,217,1,1337.85,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2882,7532,1070,40720,1521,3,68,1,280.95,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2883,7532,1070,40720,1521,3,221,1,381.21,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2884,7532,1070,40720,1521,3,57,2,2000.01,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2885,7532,1071,40720,1521,3,217,1,1446.29,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2886,7532,1071,40720,1521,3,68,1,303.72,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2887,7532,1071,40720,1521,3,57,2,1750.01,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2888,7532,1072,40720,1521,3,250,1,2600.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2889,7532,1072,40720,1521,3,57,2,2600.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2890,7532,1073,40720,1521,3,217,1,38786.35,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2891,7532,1073,40720,1521,3,68,1,8145.13,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2892,7532,1073,40720,1521,3,57,2,46931.48,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2893,7532,1074,40720,1521,3,482,1,290826.45,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2894,7532,1074,40720,1521,3,68,1,61073.55,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2895,7532,1074,40720,1521,3,57,2,351900.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2896,7532,1075,40720,1521,3,482,1,292600.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2897,7532,1075,40720,1521,3,68,1,61446.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2898,7532,1075,40720,1521,3,57,2,354046.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2899,7532,1076,40720,1521,3,482,1,144244.95,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2900,7532,1076,40720,1521,3,68,1,30291.44,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2901,7532,1076,40720,1521,3,233,1,2884.89,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2902,7532,1076,40720,1521,3,57,2,177421.28,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2903,7532,1077,40720,1521,3,482,1,60000.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2904,7532,1077,40720,1521,3,57,2,60000.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2905,7532,1078,40720,1521,3,217,1,403.04,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2906,7532,1078,40720,1521,3,68,1,84.64,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2907,7532,1078,40720,1521,3,57,2,487.68,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2908,7532,1079,40720,1521,3,217,1,2084.33,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2909,7532,1079,40720,1521,3,68,1,437.71,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2910,7532,1079,40720,1521,3,57,2,2522.04,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL);
INSERT INTO `balance_libro_details` VALUES (2911,7532,1080,40720,1521,3,250,1,150000.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2912,7532,1080,40720,1521,3,57,2,150000.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2913,7532,1081,40720,1521,3,250,1,150000.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2914,7532,1081,40720,1521,3,57,2,150000.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2915,7532,1082,40720,1521,3,482,1,1983.47,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2916,7532,1082,40720,1521,3,68,1,416.53,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2917,7532,1082,40720,1521,3,57,2,2400.00,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2918,7532,1083,40720,1521,3,217,1,1198.36,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2919,7532,1083,40720,1521,3,68,1,251.66,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2920,7532,1083,40720,1521,3,57,2,1450.02,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2921,7532,1084,40720,1521,3,217,1,23996.99,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2922,7532,1084,40720,1521,3,68,1,5039.37,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2923,7532,1084,40720,1521,3,57,2,29036.36,NULL,'2022-08-17 10:45:19','2022-08-17 10:45:19',NULL),(2924,7532,1085,40720,1521,3,217,1,1691.50,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2925,7532,1085,40720,1521,3,68,1,355.22,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2926,7532,1085,40720,1521,3,57,2,2046.72,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2927,7532,1086,40720,1521,3,250,1,100000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2928,7532,1086,40720,1521,3,57,2,100000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2929,7532,1087,40720,1521,3,250,1,89300.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2930,7532,1087,40720,1521,3,57,2,89300.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2931,7532,1088,40720,1521,3,250,1,89000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2932,7532,1088,40720,1521,3,57,2,89000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2933,7532,1089,40720,1521,3,217,1,30000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2934,7532,1089,40720,1521,3,68,1,6300.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2935,7532,1089,40720,1521,3,57,2,36300.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2936,7532,1090,40720,1521,3,250,1,60000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2937,7532,1090,40720,1521,3,57,2,60000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2938,7532,1091,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2939,7532,1091,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2940,7532,1092,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2941,7532,1092,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2942,7532,1093,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2943,7532,1093,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2944,7532,1094,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2945,7532,1094,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2946,7532,1095,40720,1521,3,250,1,20000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2947,7532,1095,40720,1521,3,57,2,20000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2948,7532,1096,40720,1521,3,250,1,40000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2949,7532,1096,40720,1521,3,57,2,40000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2950,7532,1097,40720,1521,3,250,1,25000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL);
INSERT INTO `balance_libro_details` VALUES (2951,7532,1097,40720,1521,3,57,2,25000.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2952,7532,1098,40720,1521,3,217,1,2090.91,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2953,7532,1098,40720,1521,3,68,1,439.09,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2954,7532,1098,40720,1521,3,57,2,2530.00,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2955,7532,1099,40720,1521,3,217,1,28016.40,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2956,7532,1099,40720,1521,3,68,1,5883.44,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2957,7532,1099,40720,1521,3,57,2,33899.84,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2958,7532,1100,40720,1521,3,482,2,6148.26,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2959,7532,1100,40720,1521,3,67,2,1291.13,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2960,7532,1100,40720,1521,3,57,1,7439.39,NULL,'2022-08-17 10:45:20','2022-08-17 10:45:20',NULL),(2961,7532,1101,40720,1521,3,217,1,1309.88,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2962,7532,1101,40720,1521,3,68,1,275.07,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2963,7532,1101,40720,1521,3,57,2,1584.95,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2964,7532,1102,40720,1521,3,217,1,9817.35,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2965,7532,1102,40720,1521,3,68,1,2061.64,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2966,7532,1102,40720,1521,3,233,1,196.35,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2967,7532,1102,40720,1521,3,57,2,12075.34,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2968,7532,1103,40720,1521,3,482,1,50826.45,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2969,7532,1103,40720,1521,3,68,1,10673.55,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2970,7532,1103,40720,1521,3,57,2,61500.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2971,7532,1104,40720,1521,3,217,1,27322.36,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2972,7532,1104,40720,1521,3,68,1,5737.70,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2973,7532,1104,40720,1521,3,57,2,33060.06,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2974,7532,1105,40720,1521,3,217,1,2634.30,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2975,7532,1105,40720,1521,3,68,1,553.20,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2976,7532,1105,40720,1521,3,233,1,52.69,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2977,7532,1105,40720,1521,3,57,2,3240.19,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2978,7532,1106,40720,1521,3,217,1,1854.36,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2979,7532,1106,40720,1521,3,68,1,389.42,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2980,7532,1106,40720,1521,3,57,2,2243.78,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2981,7532,1107,40720,1521,3,217,1,103544.15,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2982,7532,1107,40720,1521,3,68,1,21744.27,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2983,7532,1107,40720,1521,3,217,1,23285.24,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2984,7532,1107,40720,1521,3,221,1,1426.34,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2985,7532,1107,40720,1521,3,57,2,150000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2986,7532,1108,40720,1521,3,250,1,35000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2987,7532,1108,40720,1521,3,57,2,35000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2988,7532,1109,40720,1521,3,482,1,385785.12,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2989,7532,1109,40720,1521,3,68,1,81014.88,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2990,7532,1109,40720,1521,3,57,2,466800.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL);
INSERT INTO `balance_libro_details` VALUES (2991,7532,1110,40720,1521,3,482,1,358677.72,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2992,7532,1110,40720,1521,3,68,1,75322.32,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2993,7532,1110,40720,1521,3,57,2,434000.04,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2994,7532,1111,40720,1521,3,250,1,220000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2995,7532,1111,40720,1521,3,57,2,220000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2996,7532,1112,40720,1521,3,217,1,578.51,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2997,7532,1112,40720,1521,3,68,1,121.49,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2998,7532,1112,40720,1521,3,57,2,700.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(2999,7532,1113,40720,1521,3,482,1,1664.59,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3000,7532,1113,40720,1521,3,68,1,349.56,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3001,7532,1113,40720,1521,3,233,1,33.29,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3002,7532,1113,40720,1521,3,57,2,2047.44,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3003,7532,1114,40720,1521,3,250,1,100000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3004,7532,1114,40720,1521,3,57,2,100000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3005,7532,1115,40720,1521,3,250,1,55000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3006,7532,1115,40720,1521,3,57,2,55000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3007,7532,1116,40720,1521,3,482,1,120000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3008,7532,1116,40720,1521,3,57,2,120000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3009,7532,1117,40720,1521,3,217,1,1000000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3010,7532,1117,40720,1521,3,68,1,210000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3011,7532,1117,40720,1521,3,57,2,1210000.00,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3012,7532,1118,40720,1521,3,217,1,79545.46,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3013,7532,1118,40720,1521,3,68,1,16704.55,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3014,7532,1118,40720,1521,3,57,2,96250.01,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3015,7532,1119,40720,1521,3,217,1,1363.06,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3016,7532,1119,40720,1521,3,68,1,286.24,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3017,7532,1119,40720,1521,3,221,1,350.71,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3018,7532,1119,40720,1521,3,57,2,2000.01,NULL,'2022-08-17 10:45:21','2022-08-17 10:45:21',NULL),(3019,7532,1120,40720,1518,3,201,1,20000.00,NULL,'2022-08-17 10:52:20','2022-08-17 11:02:08','2022-08-17 11:02:08'),(3020,7532,1120,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 10:52:20','2022-08-17 11:02:08','2022-08-17 11:02:08'),(3021,7532,1121,40720,1518,3,482,1,40000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3022,7532,1121,40720,1518,3,57,2,40000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3023,7532,1122,40720,1518,3,482,1,8100000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3024,7532,1122,40720,1518,3,68,1,1701000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3025,7532,1122,40720,1518,3,57,2,9801000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3026,7532,1123,40720,1518,3,482,1,1345309.92,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3027,7532,1123,40720,1518,3,68,1,282515.08,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3028,7532,1123,40720,1518,3,57,2,1627825.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49');
INSERT INTO `balance_libro_details` VALUES (3029,7532,1124,40720,1518,3,482,1,182644.63,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3030,7532,1124,40720,1518,3,68,1,38355.37,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3031,7532,1124,40720,1518,3,57,2,221000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3032,7532,1125,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3033,7532,1125,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3034,7532,1126,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3035,7532,1126,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3036,7532,1127,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3037,7532,1127,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3038,7532,1128,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3039,7532,1128,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3040,7532,1129,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3041,7532,1129,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3042,7532,1130,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3043,7532,1130,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3044,7532,1131,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3045,7532,1131,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:45','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3046,7532,1132,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3047,7532,1132,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3048,7532,1133,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3049,7532,1133,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3050,7532,1134,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3051,7532,1134,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3052,7532,1135,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3053,7532,1135,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3054,7532,1136,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3055,7532,1136,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3056,7532,1137,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3057,7532,1137,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3058,7532,1138,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3059,7532,1138,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3060,7532,1139,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3061,7532,1139,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3062,7532,1140,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49');
INSERT INTO `balance_libro_details` VALUES (3063,7532,1140,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3064,7532,1141,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3065,7532,1141,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3066,7532,1142,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3067,7532,1142,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3068,7532,1143,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3069,7532,1143,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3070,7532,1144,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3071,7532,1144,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3072,7532,1145,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3073,7532,1145,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3074,7532,1146,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3075,7532,1146,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3076,7532,1147,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3077,7532,1147,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3078,7532,1148,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3079,7532,1148,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3080,7532,1149,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3081,7532,1149,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:49','2022-08-17 11:13:49'),(3082,7532,1150,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3083,7532,1150,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3084,7532,1151,40720,1518,3,482,1,35000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3085,7532,1151,40720,1518,3,57,2,35000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3086,7532,1152,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3087,7532,1152,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3088,7532,1153,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3089,7532,1153,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:02:46','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3090,7532,1154,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3091,7532,1154,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3092,7532,1155,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3093,7532,1155,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3094,7532,1156,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3095,7532,1156,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3096,7532,1157,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50');
INSERT INTO `balance_libro_details` VALUES (3097,7532,1157,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3098,7532,1158,40720,1518,3,482,1,35000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3099,7532,1158,40720,1518,3,57,2,35000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3100,7532,1159,40720,1518,3,482,1,50000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3101,7532,1159,40720,1518,3,57,2,50000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3102,7532,1160,40720,1518,3,482,1,75000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3103,7532,1160,40720,1518,3,57,2,75000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3104,7532,1161,40720,1518,3,482,1,124225.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3105,7532,1161,40720,1518,3,68,1,26087.25,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3106,7532,1161,40720,1518,3,57,2,150312.25,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3107,7532,1162,40720,1518,3,482,1,289091.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3108,7532,1162,40720,1518,3,68,1,60709.11,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3109,7532,1162,40720,1518,3,57,2,349800.11,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3110,7532,1163,40720,1518,3,482,1,171100.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3111,7532,1163,40720,1518,3,68,1,35931.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3112,7532,1163,40720,1518,3,57,2,207031.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3113,7532,1164,40720,1518,3,482,1,6148.26,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3114,7532,1164,40720,1518,3,68,1,1291.13,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3115,7532,1164,40720,1518,3,57,2,7439.39,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3116,7532,1165,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3117,7532,1165,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3118,7532,1166,40720,1518,3,482,1,4363.64,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3119,7532,1166,40720,1518,3,68,1,916.36,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3120,7532,1166,40720,1518,3,57,2,5280.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3121,7532,1167,40720,1518,3,482,1,60000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3122,7532,1167,40720,1518,3,57,2,60000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3123,7532,1168,40720,1518,3,482,1,200000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3124,7532,1168,40720,1518,3,57,2,200000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3125,7532,1169,40720,1518,3,482,1,1544.72,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3126,7532,1169,40720,1518,3,68,1,324.39,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3127,7532,1169,40720,1518,3,57,2,1869.11,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3128,7532,1170,40720,1518,3,482,1,36614.20,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3129,7532,1170,40720,1518,3,68,1,7688.98,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3130,7532,1170,40720,1518,3,482,1,732.29,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50');
INSERT INTO `balance_libro_details` VALUES (3131,7532,1170,40720,1518,3,57,2,45035.47,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3132,7532,1171,40720,1518,3,482,1,826446.28,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3133,7532,1171,40720,1518,3,68,1,173553.72,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3134,7532,1171,40720,1518,3,57,2,1000000.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3135,7532,1172,40720,1518,3,482,1,578.51,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3136,7532,1172,40720,1518,3,68,1,121.49,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3137,7532,1172,40720,1518,3,57,2,700.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3138,7532,1173,40720,1518,3,482,1,537.19,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3139,7532,1173,40720,1518,3,68,1,112.81,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3140,7532,1173,40720,1518,3,57,2,650.00,NULL,'2022-08-17 11:02:47','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3141,7532,1174,40720,1518,3,482,1,272.73,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3142,7532,1174,40720,1518,3,68,1,57.27,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3143,7532,1174,40720,1518,3,57,2,330.00,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3144,7532,1175,40720,1518,3,482,1,24793.38,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3145,7532,1175,40720,1518,3,68,1,5206.61,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3146,7532,1175,40720,1518,3,57,2,29999.99,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3147,7532,1176,40720,1518,3,482,1,4214.88,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3148,7532,1176,40720,1518,3,68,1,885.12,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3149,7532,1176,40720,1518,3,57,2,5100.00,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3150,7532,1177,40720,1518,3,482,1,132231.41,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3151,7532,1177,40720,1518,3,68,1,27768.60,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3152,7532,1177,40720,1518,3,57,2,160000.01,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3153,7532,1178,40720,1518,3,482,1,1157.03,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3154,7532,1178,40720,1518,3,68,1,242.98,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3155,7532,1178,40720,1518,3,57,2,1400.01,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3156,7532,1179,40720,1518,3,482,1,1223.14,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3157,7532,1179,40720,1518,3,68,1,256.86,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3158,7532,1179,40720,1518,3,57,2,1480.00,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3159,7532,1180,40720,1518,3,482,1,2276.42,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3160,7532,1180,40720,1518,3,68,1,478.05,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3161,7532,1180,40720,1518,3,57,2,2754.47,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3162,7532,1181,40720,1518,3,482,1,162246.46,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3163,7532,1181,40720,1518,3,68,1,34071.76,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3164,7532,1181,40720,1518,3,482,1,3244.92,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3165,7532,1181,40720,1518,3,57,2,199563.14,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50');
INSERT INTO `balance_libro_details` VALUES (3166,7532,1182,40720,1518,3,482,1,75000.00,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3167,7532,1182,40720,1518,3,57,2,75000.00,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3168,7532,1183,40720,1518,3,482,1,661157.03,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3169,7532,1183,40720,1518,3,68,1,138842.98,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3170,7532,1183,40720,1518,3,57,2,800000.01,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3171,7532,1184,40720,1518,3,482,1,9921.48,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3172,7532,1184,40720,1518,3,68,1,2083.51,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3173,7532,1184,40720,1518,3,57,2,12004.99,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3174,7532,1185,40720,1518,3,482,1,80000.00,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3175,7532,1185,40720,1518,3,57,2,80000.00,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3176,7532,1186,40720,1518,3,482,1,99.17,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3177,7532,1186,40720,1518,3,68,1,20.83,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3178,7532,1186,40720,1518,3,57,2,120.00,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3179,7532,1187,40720,1518,3,482,1,398016.53,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3180,7532,1187,40720,1518,3,68,1,83583.47,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3181,7532,1187,40720,1518,3,482,1,7960.33,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3182,7532,1187,40720,1518,3,57,2,489560.33,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3183,7532,1188,40720,1518,3,482,1,15867.77,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3184,7532,1188,40720,1518,3,68,1,3332.23,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3185,7532,1188,40720,1518,3,482,1,317.36,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3186,7532,1188,40720,1518,3,57,2,19517.36,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3187,7532,1189,40720,1518,3,482,1,86115.00,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3188,7532,1189,40720,1518,3,68,1,18084.15,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3189,7532,1189,40720,1518,3,482,1,1722.68,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3190,7532,1189,40720,1518,3,57,2,105921.83,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3191,7532,1190,40720,1518,3,482,1,9200.38,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3192,7532,1190,40720,1518,3,68,1,1932.08,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3193,7532,1190,40720,1518,3,482,1,184.17,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3194,7532,1190,40720,1518,3,57,2,11316.63,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3195,7532,1191,40720,1518,3,482,1,144628.10,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3196,7532,1191,40720,1518,3,68,1,30371.90,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3197,7532,1191,40720,1518,3,57,2,175000.00,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3198,7532,1192,40720,1518,3,482,1,25368.21,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3199,7532,1192,40720,1518,3,68,1,5327.32,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50');
INSERT INTO `balance_libro_details` VALUES (3200,7532,1192,40720,1518,3,57,2,30695.53,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3201,7532,1193,40720,1518,3,482,1,24953.15,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3202,7532,1193,40720,1518,3,68,1,5240.16,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3203,7532,1193,40720,1518,3,482,1,499.06,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3204,7532,1193,40720,1518,3,57,2,30692.37,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3205,7532,1194,40720,1518,3,482,1,115702.48,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3206,7532,1194,40720,1518,3,68,1,24297.52,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3207,7532,1194,40720,1518,3,57,2,140000.00,NULL,'2022-08-17 11:02:48','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3208,7532,1195,40720,1518,3,482,1,2000.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3209,7532,1195,40720,1518,3,68,1,420.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3210,7532,1195,40720,1518,3,482,1,1580.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3211,7532,1195,40720,1518,3,57,2,4000.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3212,7532,1196,40720,1518,3,482,1,2876.03,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3213,7532,1196,40720,1518,3,68,1,603.97,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3214,7532,1196,40720,1518,3,57,2,3480.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3215,7532,1197,40720,1518,3,482,1,958.68,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3216,7532,1197,40720,1518,3,68,1,201.32,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3217,7532,1197,40720,1518,3,57,2,1160.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3218,7532,1198,40720,1518,3,482,1,426446.28,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3219,7532,1198,40720,1518,3,68,1,89553.72,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3220,7532,1198,40720,1518,3,482,1,8528.92,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3221,7532,1198,40720,1518,3,57,2,524528.92,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3222,7532,1199,40720,1518,3,482,1,27700.38,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3223,7532,1199,40720,1518,3,68,1,5817.08,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3224,7532,1199,40720,1518,3,482,1,554.03,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3225,7532,1199,40720,1518,3,57,2,34071.49,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3226,7532,1200,40720,1518,3,482,1,13254.41,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3227,7532,1200,40720,1518,3,68,1,2783.43,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3228,7532,1200,40720,1518,3,482,1,265.09,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3229,7532,1200,40720,1518,3,57,2,16302.93,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3230,7532,1201,40720,1518,3,482,1,10677.36,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3231,7532,1201,40720,1518,3,68,1,2242.25,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3232,7532,1201,40720,1518,3,482,1,213.55,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3233,7532,1201,40720,1518,3,57,2,13133.16,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50');
INSERT INTO `balance_libro_details` VALUES (3234,7532,1202,40720,1518,3,482,1,40000.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3235,7532,1202,40720,1518,3,57,2,40000.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3236,7532,1203,40720,1518,3,482,1,48000.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3237,7532,1203,40720,1518,3,57,2,48000.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3238,7532,1204,40720,1518,3,482,1,3681.82,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3239,7532,1204,40720,1518,3,68,1,773.18,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3240,7532,1204,40720,1518,3,57,2,4455.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3241,7532,1205,40720,1518,3,482,1,8400.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3242,7532,1205,40720,1518,3,68,1,1764.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3243,7532,1205,40720,1518,3,57,2,10164.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3244,7532,1206,40720,1518,3,482,1,2479.34,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3245,7532,1206,40720,1518,3,68,1,520.66,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3246,7532,1206,40720,1518,3,57,2,3000.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3247,7532,1207,40720,1518,3,482,1,1382.64,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3248,7532,1207,40720,1518,3,68,1,290.35,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3249,7532,1207,40720,1518,3,482,1,27.65,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3250,7532,1207,40720,1518,3,57,2,1700.64,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3251,7532,1208,40720,1518,3,482,1,157824.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3252,7532,1208,40720,1518,3,57,2,157824.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3253,7532,1209,40720,1518,3,482,1,239000.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3254,7532,1209,40720,1518,3,68,1,50190.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3255,7532,1209,40720,1518,3,57,2,289190.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3256,7532,1210,40720,1518,3,482,1,165990.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3257,7532,1210,40720,1518,3,68,1,34857.90,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3258,7532,1210,40720,1518,3,57,2,200847.90,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3259,7532,1211,40720,1518,3,482,1,1046.40,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3260,7532,1211,40720,1518,3,68,1,109.87,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3261,7532,1211,40720,1518,3,57,2,1156.27,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3262,7532,1212,40720,1518,3,482,1,330.58,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3263,7532,1212,40720,1518,3,68,1,69.42,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3264,7532,1212,40720,1518,3,57,2,400.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3265,7532,1213,40720,1518,3,482,1,11646.38,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3266,7532,1213,40720,1518,3,68,1,2445.74,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3267,7532,1213,40720,1518,3,57,2,14092.12,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50');
INSERT INTO `balance_libro_details` VALUES (3268,7532,1214,40720,1518,3,482,1,703.00,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3269,7532,1214,40720,1518,3,68,1,147.63,NULL,'2022-08-17 11:02:49','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3270,7532,1214,40720,1518,3,57,2,850.63,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3271,7532,1215,40720,1518,3,482,1,28760.34,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3272,7532,1215,40720,1518,3,68,1,6039.67,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3273,7532,1215,40720,1518,3,57,2,34800.01,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3274,7532,1216,40720,1518,3,482,1,3305.78,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3275,7532,1216,40720,1518,3,68,1,694.21,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3276,7532,1216,40720,1518,3,57,2,3999.99,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3277,7532,1217,40720,1518,3,482,1,15041.35,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3278,7532,1217,40720,1518,3,68,1,3158.68,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3279,7532,1217,40720,1518,3,57,2,18200.03,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3280,7532,1218,40720,1518,3,482,1,3986.03,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3281,7532,1218,40720,1518,3,68,1,837.07,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3282,7532,1218,40720,1518,3,57,2,4823.10,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3283,7532,1219,40720,1518,3,482,1,1186.66,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3284,7532,1219,40720,1518,3,68,1,249.20,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3285,7532,1219,40720,1518,3,482,1,131.12,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3286,7532,1219,40720,1518,3,68,1,13.77,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3287,7532,1219,40720,1518,3,57,2,1580.75,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3288,7532,1220,40720,1518,3,482,1,46155.60,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3289,7532,1220,40720,1518,3,68,1,9692.68,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3290,7532,1220,40720,1518,3,482,1,923.11,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3291,7532,1220,40720,1518,3,57,2,56771.39,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:50','2022-08-17 11:13:50'),(3292,7532,1221,40720,1518,3,482,1,5509.98,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3293,7532,1221,40720,1518,3,68,1,1157.10,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3294,7532,1221,40720,1518,3,482,1,110.20,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3295,7532,1221,40720,1518,3,57,2,6777.28,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3296,7532,1222,40720,1518,3,482,1,7500.00,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3297,7532,1222,40720,1518,3,57,2,7500.00,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3298,7532,1223,40720,1518,3,482,1,24793.38,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3299,7532,1223,40720,1518,3,68,1,5206.61,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3300,7532,1223,40720,1518,3,57,2,29999.99,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3301,7532,1224,40720,1518,3,482,1,81454.55,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3302,7532,1224,40720,1518,3,68,1,17105.46,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51');
INSERT INTO `balance_libro_details` VALUES (3303,7532,1224,40720,1518,3,57,2,98560.01,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3304,7532,1225,40720,1518,3,482,1,197181.82,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3305,7532,1225,40720,1518,3,68,1,41408.18,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3306,7532,1225,40720,1518,3,57,2,238590.00,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3307,7532,1226,40720,1518,3,482,1,328925.62,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3308,7532,1226,40720,1518,3,68,1,69074.38,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3309,7532,1226,40720,1518,3,57,2,398000.00,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3310,7532,1227,40720,1518,3,482,1,218884.36,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3311,7532,1227,40720,1518,3,68,1,45965.72,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3312,7532,1227,40720,1518,3,57,2,264850.08,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3313,7532,1228,40720,1518,3,482,2,2067.86,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3314,7532,1228,40720,1518,3,67,2,434.25,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3315,7532,1228,40720,1518,3,57,1,2502.11,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3316,7532,1229,40720,1518,3,482,1,4153.52,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3317,7532,1229,40720,1518,3,68,1,872.24,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3318,7532,1229,40720,1518,3,482,1,83.07,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3319,7532,1229,40720,1518,3,57,2,5108.83,NULL,'2022-08-17 11:02:50','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3320,7532,1230,40720,1518,3,482,1,5478.78,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3321,7532,1230,40720,1518,3,68,1,1150.54,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3322,7532,1230,40720,1518,3,482,1,109.58,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3323,7532,1230,40720,1518,3,57,2,6738.90,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3324,7532,1231,40720,1518,3,482,1,661157.03,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3325,7532,1231,40720,1518,3,68,1,138842.98,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3326,7532,1231,40720,1518,3,57,2,800000.01,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3327,7532,1232,40720,1518,3,482,1,23966.94,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3328,7532,1232,40720,1518,3,68,1,5033.06,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3329,7532,1232,40720,1518,3,57,2,29000.00,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3330,7532,1233,40720,1518,3,482,1,32066.10,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3331,7532,1233,40720,1518,3,68,1,6733.88,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3332,7532,1233,40720,1518,3,57,2,38799.98,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3333,7532,1234,40720,1518,3,482,1,5851.24,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3334,7532,1234,40720,1518,3,68,1,1228.76,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3335,7532,1234,40720,1518,3,57,2,7080.00,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3336,7532,1235,40720,1518,3,482,1,1446.28,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51');
INSERT INTO `balance_libro_details` VALUES (3337,7532,1235,40720,1518,3,68,1,303.72,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3338,7532,1235,40720,1518,3,57,2,1750.00,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3339,7532,1236,40720,1518,3,482,1,10510.00,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3340,7532,1236,40720,1518,3,57,2,10510.00,NULL,'2022-08-17 11:02:51','2022-08-17 11:13:51','2022-08-17 11:13:51'),(3341,7532,1237,40720,1518,3,250,1,24793.38,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3342,7532,1237,40720,1518,3,68,1,5206.61,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3343,7532,1237,40720,1518,3,57,2,29999.99,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3344,7532,1238,40720,1518,3,250,1,132231.41,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3345,7532,1238,40720,1518,3,68,1,27768.60,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3346,7532,1238,40720,1518,3,57,2,160000.01,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3347,7532,1239,40720,1518,3,250,1,661157.03,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3348,7532,1239,40720,1518,3,68,1,138842.98,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3349,7532,1239,40720,1518,3,57,2,800000.01,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3350,7532,1240,40720,1518,3,250,1,661157.03,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3351,7532,1240,40720,1518,3,68,1,138842.98,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3352,7532,1240,40720,1518,3,57,2,800000.01,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3353,7532,1241,40720,1518,3,482,1,8100000.00,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3354,7532,1241,40720,1518,3,68,1,1701000.00,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3355,7532,1241,40720,1518,3,57,2,9801000.00,NULL,'2022-08-17 11:14:57','2022-08-17 11:14:57',NULL),(3356,7532,1242,40720,1518,3,482,1,703.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3357,7532,1242,40720,1518,3,68,1,147.63,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3358,7532,1242,40720,1518,3,57,2,850.63,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3359,7532,1243,40720,1518,3,482,1,28760.34,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3360,7532,1243,40720,1518,3,68,1,6039.67,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3361,7532,1243,40720,1518,3,57,2,34800.01,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3362,7532,1244,40720,1518,3,250,1,115702.48,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3363,7532,1244,40720,1518,3,68,1,24297.52,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3364,7532,1244,40720,1518,3,57,2,140000.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3365,7532,1245,40720,1518,3,482,1,124225.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3366,7532,1245,40720,1518,3,68,1,26087.25,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3367,7532,1245,40720,1518,3,57,2,150312.25,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3368,7532,1246,40720,1518,3,482,1,289091.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3369,7532,1246,40720,1518,3,68,1,60709.11,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3370,7532,1246,40720,1518,3,57,2,349800.11,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3371,7532,1247,40720,1518,3,482,1,171100.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3372,7532,1247,40720,1518,3,68,1,35931.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3373,7532,1247,40720,1518,3,57,2,207031.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3374,7532,1248,40720,1518,3,482,1,81454.55,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3375,7532,1248,40720,1518,3,68,1,17105.46,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL);
INSERT INTO `balance_libro_details` VALUES (3376,7532,1248,40720,1518,3,57,2,98560.01,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3377,7532,1249,40720,1518,3,482,1,197181.82,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3378,7532,1249,40720,1518,3,68,1,41408.18,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3379,7532,1249,40720,1518,3,57,2,238590.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3380,7532,1250,40720,1518,3,482,1,328925.62,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3381,7532,1250,40720,1518,3,68,1,69074.38,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3382,7532,1250,40720,1518,3,57,2,398000.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3383,7532,1251,40720,1518,3,482,1,218884.36,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3384,7532,1251,40720,1518,3,68,1,45965.71,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3385,7532,1251,40720,1518,3,57,2,264850.07,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3386,7532,1252,40720,1518,3,482,1,826446.28,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3387,7532,1252,40720,1518,3,68,1,173553.72,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3388,7532,1252,40720,1518,3,57,2,1000000.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3389,7532,1253,40720,1518,3,250,1,1345309.92,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3390,7532,1253,40720,1518,3,68,1,282515.08,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3391,7532,1253,40720,1518,3,57,2,1627825.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3392,7532,1254,40720,1518,3,250,1,182644.63,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3393,7532,1254,40720,1518,3,68,1,38355.37,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3394,7532,1254,40720,1518,3,57,2,221000.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3395,7532,1255,40720,1518,3,482,1,8400.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3396,7532,1255,40720,1518,3,68,1,1764.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3397,7532,1255,40720,1518,3,57,2,10164.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3398,7532,1256,40720,1518,3,482,1,23966.94,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3399,7532,1256,40720,1518,3,68,1,5033.06,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3400,7532,1256,40720,1518,3,57,2,29000.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3401,7532,1257,40720,1518,3,250,1,239000.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3402,7532,1257,40720,1518,3,68,1,50190.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3403,7532,1257,40720,1518,3,57,2,289190.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3404,7532,1258,40720,1518,3,250,1,165990.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3405,7532,1258,40720,1518,3,68,1,34857.90,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3406,7532,1258,40720,1518,3,57,2,200847.90,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3407,7532,1259,40720,1518,3,482,1,32066.10,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3408,7532,1259,40720,1518,3,68,1,6733.88,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3409,7532,1259,40720,1518,3,57,2,38799.98,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3410,7532,1260,40720,1518,3,482,1,1046.40,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3411,7532,1260,40720,1518,3,68,1,109.87,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3412,7532,1260,40720,1518,3,57,2,1156.27,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3413,7532,1261,40720,1518,3,482,1,2479.34,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3414,7532,1261,40720,1518,3,68,1,520.66,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3415,7532,1261,40720,1518,3,57,2,3000.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL);
INSERT INTO `balance_libro_details` VALUES (3416,7532,1262,40720,1518,3,482,1,3305.78,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3417,7532,1262,40720,1518,3,68,1,694.21,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3418,7532,1262,40720,1518,3,57,2,3999.99,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3419,7532,1263,40720,1518,3,250,1,578.51,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3420,7532,1263,40720,1518,3,68,1,121.49,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3421,7532,1263,40720,1518,3,57,2,700.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3422,7532,1264,40720,1518,3,250,1,537.19,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3423,7532,1264,40720,1518,3,68,1,112.81,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3424,7532,1264,40720,1518,3,57,2,650.00,NULL,'2022-08-17 11:14:58','2022-08-17 11:14:58',NULL),(3425,7532,1265,40720,1518,3,250,1,272.73,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3426,7532,1265,40720,1518,3,68,1,57.27,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3427,7532,1265,40720,1518,3,57,2,330.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3428,7532,1266,40720,1518,3,250,1,1223.14,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3429,7532,1266,40720,1518,3,68,1,256.86,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3430,7532,1266,40720,1518,3,57,2,1480.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3431,7532,1267,40720,1518,3,250,1,99.17,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3432,7532,1267,40720,1518,3,68,1,20.83,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3433,7532,1267,40720,1518,3,57,2,120.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3434,7532,1268,40720,1518,3,250,1,330.58,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3435,7532,1268,40720,1518,3,68,1,69.42,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3436,7532,1268,40720,1518,3,57,2,400.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3437,7532,1269,40720,1518,3,482,1,24793.38,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3438,7532,1269,40720,1518,3,68,1,5206.61,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3439,7532,1269,40720,1518,3,57,2,29999.99,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3440,7532,1270,40720,1518,3,482,1,2000.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3441,7532,1270,40720,1518,3,68,1,420.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3442,7532,1270,40720,1518,3,482,1,1580.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3443,7532,1270,40720,1518,3,57,2,4000.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3444,7532,1271,40720,1518,3,250,1,15041.35,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3445,7532,1271,40720,1518,3,68,1,3158.68,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3446,7532,1271,40720,1518,3,57,2,18200.03,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3447,7532,1272,40720,1518,3,482,1,3681.82,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3448,7532,1272,40720,1518,3,68,1,773.18,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3449,7532,1272,40720,1518,3,57,2,4455.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3450,7532,1273,40720,1518,3,250,1,4214.88,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3451,7532,1273,40720,1518,3,68,1,885.12,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3452,7532,1273,40720,1518,3,57,2,5100.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3453,7532,1274,40720,1518,3,250,1,5851.24,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3454,7532,1274,40720,1518,3,68,1,1228.76,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3455,7532,1274,40720,1518,3,57,2,7080.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3456,7532,1275,40720,1518,3,482,1,2876.03,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL);
INSERT INTO `balance_libro_details` VALUES (3457,7532,1275,40720,1518,3,68,1,603.97,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3458,7532,1275,40720,1518,3,57,2,3480.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3459,7532,1276,40720,1518,3,482,1,958.68,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3460,7532,1276,40720,1518,3,68,1,201.32,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3461,7532,1276,40720,1518,3,57,2,1160.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3462,7532,1277,40720,1518,3,482,1,9921.48,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3463,7532,1277,40720,1518,3,68,1,2083.51,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3464,7532,1277,40720,1518,3,57,2,12004.99,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3465,7532,1278,40720,1518,3,250,1,1446.28,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3466,7532,1278,40720,1518,3,68,1,303.72,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3467,7532,1278,40720,1518,3,57,2,1750.00,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3468,7532,1279,40720,1518,3,217,1,1382.64,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3469,7532,1279,40720,1518,3,68,1,290.35,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3470,7532,1279,40720,1518,3,217,1,27.65,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3471,7532,1279,40720,1518,3,57,2,1700.64,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3472,7532,1280,40720,1518,3,250,1,3986.03,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3473,7532,1280,40720,1518,3,68,1,837.07,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3474,7532,1280,40720,1518,3,57,2,4823.10,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3475,7532,1281,40720,1518,3,482,1,398016.53,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3476,7532,1281,40720,1518,3,68,1,83583.47,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3477,7532,1281,40720,1518,3,482,1,7960.33,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3478,7532,1281,40720,1518,3,57,2,489560.33,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3479,7532,1282,40720,1518,3,482,1,426446.28,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3480,7532,1282,40720,1518,3,68,1,89553.72,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3481,7532,1282,40720,1518,3,482,1,8528.92,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3482,7532,1282,40720,1518,3,57,2,524528.92,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3483,7532,1283,40720,1518,3,482,1,6148.26,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3484,7532,1283,40720,1518,3,68,1,1291.14,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3485,7532,1283,40720,1518,3,57,2,7439.40,NULL,'2022-08-17 11:14:59','2022-08-17 11:14:59',NULL),(3486,7532,1284,40720,1518,3,482,1,4363.64,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3487,7532,1284,40720,1518,3,68,1,916.36,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3488,7532,1284,40720,1518,3,57,2,5280.00,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3489,7532,1285,40720,1518,3,250,1,1157.03,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3490,7532,1285,40720,1518,3,68,1,242.97,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3491,7532,1285,40720,1518,3,57,2,1400.00,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3492,7532,1286,40720,1518,3,250,1,11646.38,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3493,7532,1286,40720,1518,3,68,1,2445.75,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3494,7532,1286,40720,1518,3,57,2,14092.13,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3495,7532,1287,40720,1518,3,250,1,15867.77,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3496,7532,1287,40720,1518,3,68,1,3332.23,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3497,7532,1287,40720,1518,3,250,1,317.36,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL);
INSERT INTO `balance_libro_details` VALUES (3498,7532,1287,40720,1518,3,57,2,19517.36,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3499,7532,1288,40720,1518,3,233,1,30.89,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3500,7532,1288,40720,1518,3,482,1,1544.72,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3501,7532,1288,40720,1518,3,68,1,324.39,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3502,7532,1288,40720,1518,3,57,2,1900.00,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3503,7532,1289,40720,1518,3,233,1,45.53,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3504,7532,1289,40720,1518,3,482,1,2276.42,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3505,7532,1289,40720,1518,3,68,1,478.05,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3506,7532,1289,40720,1518,3,57,2,2800.00,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3507,7532,1290,40720,1518,3,482,1,27700.38,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3508,7532,1290,40720,1518,3,68,1,5745.59,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3509,7532,1290,40720,1518,3,482,1,554.03,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3510,7532,1290,40720,1518,3,57,2,34000.00,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3511,7532,1291,40720,1518,3,233,1,26.36,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3512,7532,1291,40720,1518,3,482,1,131.12,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3513,7532,1291,40720,1518,3,68,1,13.77,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3514,7532,1291,40720,1518,3,482,1,1186.66,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3515,7532,1291,40720,1518,3,68,1,249.20,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3516,7532,1291,40720,1518,3,57,2,1607.11,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3517,7532,1292,40720,1518,3,482,1,86115.00,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3518,7532,1292,40720,1518,3,68,1,18084.15,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3519,7532,1292,40720,1518,3,482,1,1722.68,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3520,7532,1292,40720,1518,3,57,2,105921.83,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3521,7532,1293,40720,1518,3,482,1,9200.38,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3522,7532,1293,40720,1518,3,68,1,1932.08,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3523,7532,1293,40720,1518,3,482,1,184.17,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3524,7532,1293,40720,1518,3,57,2,11316.63,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3525,7532,1294,40720,1518,3,482,1,46155.60,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3526,7532,1294,40720,1518,3,68,1,9692.68,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3527,7532,1294,40720,1518,3,482,1,923.11,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3528,7532,1294,40720,1518,3,57,2,56771.39,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3529,7532,1295,40720,1518,3,482,1,144628.10,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3530,7532,1295,40720,1518,3,68,1,30371.90,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3531,7532,1295,40720,1518,3,57,2,175000.00,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3532,7532,1296,40720,1518,3,482,1,5509.98,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3533,7532,1296,40720,1518,3,68,1,1157.10,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3534,7532,1296,40720,1518,3,482,1,110.20,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3535,7532,1296,40720,1518,3,57,2,6777.28,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3536,7532,1297,40720,1518,3,482,1,162246.46,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3537,7532,1297,40720,1518,3,68,1,34071.76,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3538,7532,1297,40720,1518,3,482,1,3244.92,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL);
INSERT INTO `balance_libro_details` VALUES (3539,7532,1297,40720,1518,3,57,2,199563.14,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3540,7532,1298,40720,1518,3,482,1,24953.15,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3541,7532,1298,40720,1518,3,68,1,5240.16,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3542,7532,1298,40720,1518,3,482,1,499.06,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3543,7532,1298,40720,1518,3,57,2,30692.37,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3544,7532,1299,40720,1518,3,482,1,4153.52,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3545,7532,1299,40720,1518,3,68,1,872.24,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3546,7532,1299,40720,1518,3,482,1,83.07,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3547,7532,1299,40720,1518,3,57,2,5108.83,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3548,7532,1300,40720,1518,3,482,1,5478.78,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3549,7532,1300,40720,1518,3,68,1,1150.54,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3550,7532,1300,40720,1518,3,482,1,109.58,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3551,7532,1300,40720,1518,3,57,2,6738.90,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3552,7532,1301,40720,1518,3,482,1,13254.41,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3553,7532,1301,40720,1518,3,68,1,2783.43,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3554,7532,1301,40720,1518,3,482,1,265.09,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3555,7532,1301,40720,1518,3,57,2,16302.93,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3556,7532,1302,40720,1518,3,482,1,10677.36,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3557,7532,1302,40720,1518,3,68,1,2242.25,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3558,7532,1302,40720,1518,3,482,1,213.55,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3559,7532,1302,40720,1518,3,57,2,13133.16,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3560,7532,1303,40720,1518,3,482,1,36614.20,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3561,7532,1303,40720,1518,3,68,1,7688.98,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3562,7532,1303,40720,1518,3,482,1,732.29,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3563,7532,1303,40720,1518,3,57,2,45035.47,NULL,'2022-08-17 11:15:00','2022-08-17 11:15:00',NULL),(3564,7532,1304,40720,1518,3,482,2,25368.21,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3565,7532,1304,40720,1518,3,67,2,5327.32,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3566,7532,1304,40720,1518,3,57,1,30695.53,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3567,7532,1305,40720,1518,3,482,2,2067.86,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3568,7532,1305,40720,1518,3,67,2,434.25,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3569,7532,1305,40720,1518,3,57,1,2502.11,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3570,7532,1306,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3571,7532,1306,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3572,7532,1306,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3573,7532,1306,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3574,7532,1307,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3575,7532,1307,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3576,7532,1307,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3577,7532,1307,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3578,7532,1308,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL);
INSERT INTO `balance_libro_details` VALUES (3579,7532,1308,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3580,7532,1308,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3581,7532,1308,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3582,7532,1309,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3583,7532,1309,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3584,7532,1309,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3585,7532,1309,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3586,7532,1310,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3587,7532,1310,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3588,7532,1310,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3589,7532,1310,40720,1518,3,136,2,25000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3590,7532,1311,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3591,7532,1311,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3592,7532,1311,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3593,7532,1311,40720,1518,3,136,2,25000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3594,7532,1312,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3595,7532,1312,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3596,7532,1312,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3597,7532,1312,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3598,7532,1313,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3599,7532,1313,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3600,7532,1313,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3601,7532,1313,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3602,7532,1314,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3603,7532,1314,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3604,7532,1314,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3605,7532,1314,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3606,7532,1315,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3607,7532,1315,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3608,7532,1315,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3609,7532,1315,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3610,7532,1316,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3611,7532,1316,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3612,7532,1316,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3613,7532,1316,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3614,7532,1317,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3615,7532,1317,40720,1518,3,482,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3616,7532,1317,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3617,7532,1317,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3618,7532,1318,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL);
INSERT INTO `balance_libro_details` VALUES (3619,7532,1318,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3620,7532,1318,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3621,7532,1318,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3622,7532,1319,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3623,7532,1319,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3624,7532,1319,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3625,7532,1319,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:01','2022-08-17 11:15:01',NULL),(3626,7532,1320,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3627,7532,1320,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3628,7532,1320,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3629,7532,1320,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3630,7532,1321,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3631,7532,1321,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3632,7532,1321,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3633,7532,1321,40720,1518,3,136,2,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3634,7532,1322,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3635,7532,1322,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3636,7532,1322,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3637,7532,1322,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3638,7532,1323,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3639,7532,1323,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3640,7532,1323,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3641,7532,1323,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3642,7532,1324,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3643,7532,1324,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3644,7532,1324,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3645,7532,1324,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3646,7532,1325,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3647,7532,1325,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3648,7532,1325,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3649,7532,1325,40720,1518,3,136,2,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3650,7532,1326,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3651,7532,1326,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3652,7532,1326,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3653,7532,1326,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3654,7532,1327,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3655,7532,1327,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3656,7532,1327,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3657,7532,1327,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3658,7532,1328,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL);
INSERT INTO `balance_libro_details` VALUES (3659,7532,1328,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3660,7532,1328,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3661,7532,1328,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3662,7532,1329,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3663,7532,1329,40720,1518,3,482,1,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3664,7532,1329,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3665,7532,1329,40720,1518,3,136,2,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3666,7532,1330,40720,1518,3,217,1,35000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3667,7532,1330,40720,1518,3,217,1,35000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3668,7532,1330,40720,1518,3,57,2,35000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3669,7532,1330,40720,1518,3,136,2,35000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3670,7532,1331,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3671,7532,1331,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3672,7532,1331,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3673,7532,1331,40720,1518,3,136,2,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3674,7532,1332,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3675,7532,1332,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3676,7532,1332,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3677,7532,1332,40720,1518,3,136,2,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3678,7532,1333,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3679,7532,1333,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3680,7532,1333,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3681,7532,1333,40720,1518,3,136,2,25000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3682,7532,1334,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3683,7532,1334,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3684,7532,1334,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3685,7532,1334,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3686,7532,1335,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3687,7532,1335,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3688,7532,1335,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3689,7532,1335,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:02','2022-08-17 11:15:02',NULL),(3690,7532,1336,40720,1518,3,217,1,40000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3691,7532,1336,40720,1518,3,217,1,40000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3692,7532,1336,40720,1518,3,57,2,40000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3693,7532,1336,40720,1518,3,136,2,40000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3694,7532,1337,40720,1518,3,217,1,40000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3695,7532,1337,40720,1518,3,217,1,40000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3696,7532,1337,40720,1518,3,57,2,40000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3697,7532,1337,40720,1518,3,136,2,40000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3698,7532,1338,40720,1518,3,217,1,60000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL);
INSERT INTO `balance_libro_details` VALUES (3699,7532,1338,40720,1518,3,217,1,60000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3700,7532,1338,40720,1518,3,57,2,60000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3701,7532,1338,40720,1518,3,136,2,60000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3702,7532,1339,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3703,7532,1339,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3704,7532,1339,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3705,7532,1339,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3706,7532,1340,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3707,7532,1340,40720,1518,3,217,1,25000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3708,7532,1340,40720,1518,3,57,2,25000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3709,7532,1340,40720,1518,3,136,2,25000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3710,7532,1341,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3711,7532,1341,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3712,7532,1341,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3713,7532,1341,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3714,7532,1342,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3715,7532,1342,40720,1518,3,217,1,20000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3716,7532,1342,40720,1518,3,57,2,20000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3717,7532,1342,40720,1518,3,136,2,20000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3718,7532,1343,40720,1518,3,482,1,48000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3719,7532,1343,40720,1518,3,482,1,48000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3720,7532,1343,40720,1518,3,57,2,48000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3721,7532,1343,40720,1518,3,136,2,48000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3722,7532,1344,40720,1518,3,482,1,157824.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3723,7532,1344,40720,1518,3,482,1,157824.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3724,7532,1344,40720,1518,3,57,2,157824.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3725,7532,1344,40720,1518,3,136,2,157824.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3726,7532,1345,40720,1518,3,482,1,10510.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3727,7532,1345,40720,1518,3,482,1,10510.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3728,7532,1345,40720,1518,3,57,2,10510.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3729,7532,1345,40720,1518,3,136,2,10510.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3730,7532,1346,40720,1518,3,217,1,50000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3731,7532,1346,40720,1518,3,217,1,50000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3732,7532,1346,40720,1518,3,57,2,50000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3733,7532,1346,40720,1518,3,136,2,50000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3734,7532,1347,40720,1518,3,482,1,80000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3735,7532,1347,40720,1518,3,482,1,80000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3736,7532,1347,40720,1518,3,57,2,80000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3737,7532,1347,40720,1518,3,136,2,80000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3738,7532,1348,40720,1518,3,482,1,7500.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL);
INSERT INTO `balance_libro_details` VALUES (3739,7532,1348,40720,1518,3,482,1,7500.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3740,7532,1348,40720,1518,3,57,2,7500.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3741,7532,1348,40720,1518,3,136,2,7500.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3742,7532,1349,40720,1518,3,217,1,35000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3743,7532,1349,40720,1518,3,217,1,35000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3744,7532,1349,40720,1518,3,57,2,35000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3745,7532,1349,40720,1518,3,136,2,35000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3746,7532,1350,40720,1518,3,482,1,200000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3747,7532,1350,40720,1518,3,482,1,200000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3748,7532,1350,40720,1518,3,57,2,200000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3749,7532,1350,40720,1518,3,136,2,200000.00,NULL,'2022-08-17 11:15:03','2022-08-17 11:15:03',NULL),(3750,7532,1351,40720,1519,3,250,1,29709.01,NULL,'2022-08-17 11:22:24','2022-08-17 11:22:24',NULL),(3751,7532,1351,40720,1519,3,68,1,6238.89,NULL,'2022-08-17 11:22:24','2022-08-17 11:22:24',NULL),(3752,7532,1351,40720,1519,3,57,2,35947.90,NULL,'2022-08-17 11:22:24','2022-08-17 11:22:24',NULL),(3753,7532,1352,40720,1519,3,250,1,132231.41,NULL,'2022-08-17 11:22:24','2022-08-17 11:22:24',NULL),(3754,7532,1352,40720,1519,3,68,1,27768.60,NULL,'2022-08-17 11:22:24','2022-08-17 11:22:24',NULL),(3755,7532,1352,40720,1519,3,57,2,160000.01,NULL,'2022-08-17 11:22:24','2022-08-17 11:22:24',NULL),(3756,7532,1353,40720,1519,3,250,1,4091.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3757,7532,1353,40720,1519,3,68,1,859.11,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3758,7532,1353,40720,1519,3,57,2,4950.11,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3759,7532,1354,40720,1519,3,250,1,661157.03,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3760,7532,1354,40720,1519,3,68,1,138842.98,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3761,7532,1354,40720,1519,3,57,2,800000.01,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3762,7532,1355,40720,1519,3,250,1,162000.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3763,7532,1355,40720,1519,3,68,1,34020.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3764,7532,1355,40720,1519,3,57,2,196020.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3765,7532,1356,40720,1519,3,250,1,66115.70,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3766,7532,1356,40720,1519,3,68,1,13884.30,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3767,7532,1356,40720,1519,3,57,2,80000.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3768,7532,1357,40720,1519,3,482,1,248760.33,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3769,7532,1357,40720,1519,3,68,1,52239.67,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3770,7532,1357,40720,1519,3,57,2,301000.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3771,7532,1358,40720,1519,3,482,1,81818.18,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3772,7532,1358,40720,1519,3,68,1,17181.82,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3773,7532,1358,40720,1519,3,57,2,99000.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3774,7532,1359,40720,1519,3,482,1,165289.26,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3775,7532,1359,40720,1519,3,68,1,34710.74,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3776,7532,1359,40720,1519,3,57,2,200000.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3777,7532,1360,40720,1519,3,482,1,289173.55,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3778,7532,1360,40720,1519,3,68,1,60726.45,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL);
INSERT INTO `balance_libro_details` VALUES (3779,7532,1360,40720,1519,3,57,2,349900.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3780,7532,1361,40720,1519,3,250,1,81528.93,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3781,7532,1361,40720,1519,3,68,1,17121.08,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3782,7532,1361,40720,1519,3,57,2,98650.01,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3783,7532,1362,40720,1519,3,250,1,1345309.92,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3784,7532,1362,40720,1519,3,68,1,282515.08,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3785,7532,1362,40720,1519,3,57,2,1627825.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3786,7532,1363,40720,1519,3,250,1,182644.63,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3787,7532,1363,40720,1519,3,68,1,38355.37,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3788,7532,1363,40720,1519,3,57,2,221000.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3789,7532,1364,40720,1519,3,250,1,17520.66,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3790,7532,1364,40720,1519,3,68,1,3679.34,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3791,7532,1364,40720,1519,3,57,2,21200.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3792,7532,1365,40720,1519,3,250,1,2727.27,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3793,7532,1365,40720,1519,3,68,1,572.73,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3794,7532,1365,40720,1519,3,57,2,3300.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3795,7532,1366,40720,1519,3,250,1,2090.89,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3796,7532,1366,40720,1519,3,68,1,439.09,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3797,7532,1366,40720,1519,3,250,1,5580.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3798,7532,1366,40720,1519,3,57,2,8109.98,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3799,7532,1367,40720,1519,3,482,1,22975.21,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3800,7532,1367,40720,1519,3,68,1,4824.79,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3801,7532,1367,40720,1519,3,57,2,27800.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3802,7532,1368,40720,1519,3,250,1,2280.99,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3803,7532,1368,40720,1519,3,68,1,479.01,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3804,7532,1368,40720,1519,3,57,2,2760.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3805,7532,1369,40720,1519,3,250,1,1570.25,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3806,7532,1369,40720,1519,3,68,1,329.75,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3807,7532,1369,40720,1519,3,57,2,1900.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3808,7532,1370,40720,1519,3,482,1,6200.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3809,7532,1370,40720,1519,3,68,1,1302.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3810,7532,1370,40720,1519,3,482,1,8498.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3811,7532,1370,40720,1519,3,57,2,16000.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3812,7532,1371,40720,1519,3,250,1,559.50,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3813,7532,1371,40720,1519,3,68,1,117.50,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3814,7532,1371,40720,1519,3,57,2,677.00,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3815,7532,1372,40720,1519,3,250,1,4950.40,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3816,7532,1372,40720,1519,3,68,1,1039.58,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3817,7532,1372,40720,1519,3,57,2,5989.98,NULL,'2022-08-17 11:22:25','2022-08-17 11:22:25',NULL),(3818,7532,1373,40720,1519,3,250,1,2685.95,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3819,7532,1373,40720,1519,3,68,1,564.05,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL);
INSERT INTO `balance_libro_details` VALUES (3820,7532,1373,40720,1519,3,57,2,3250.00,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3821,7532,1374,40720,1519,3,482,1,4069.68,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3822,7532,1374,40720,1519,3,68,1,854.63,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3823,7532,1374,40720,1519,3,57,2,4924.31,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3824,7532,1375,40720,1519,3,482,1,12396.70,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3825,7532,1375,40720,1519,3,68,1,2603.31,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3826,7532,1375,40720,1519,3,57,2,15000.01,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3827,7532,1376,40720,1519,3,482,1,4343.61,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3828,7532,1376,40720,1519,3,68,1,912.16,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3829,7532,1376,40720,1519,3,57,2,5255.77,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3830,7532,1377,40720,1519,3,250,1,53305.79,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3831,7532,1377,40720,1519,3,68,1,11194.22,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3832,7532,1377,40720,1519,3,57,2,64500.01,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3833,7532,1378,40720,1519,3,250,1,27933.88,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3834,7532,1378,40720,1519,3,68,1,5866.11,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3835,7532,1378,40720,1519,3,57,2,33799.99,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3836,7532,1379,40720,1519,3,250,1,4958.69,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3837,7532,1379,40720,1519,3,68,1,1041.32,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3838,7532,1379,40720,1519,3,57,2,6000.01,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3839,7532,1380,40720,1519,3,250,1,2479.34,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3840,7532,1380,40720,1519,3,68,1,520.66,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3841,7532,1380,40720,1519,3,57,2,3000.00,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3842,7532,1381,40720,1519,3,250,1,14223.14,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3843,7532,1381,40720,1519,3,68,1,2986.86,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3844,7532,1381,40720,1519,3,57,2,17210.00,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3845,7532,1382,40720,1519,3,250,1,2607.23,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3846,7532,1382,40720,1519,3,68,1,547.52,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3847,7532,1382,40720,1519,3,57,2,3154.75,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3848,7532,1383,40720,1519,3,250,1,1249.60,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3849,7532,1383,40720,1519,3,68,1,262.42,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3850,7532,1383,40720,1519,3,57,2,1512.02,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3851,7532,1384,40720,1519,3,250,1,769.23,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3852,7532,1384,40720,1519,3,68,1,80.77,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3853,7532,1384,40720,1519,3,250,1,1628.10,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3854,7532,1384,40720,1519,3,68,1,341.90,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3855,7532,1384,40720,1519,3,57,2,2820.00,NULL,'2022-08-17 11:22:26','2022-08-17 11:22:26',NULL),(3856,7532,1385,40720,1519,3,250,1,281.34,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3857,7532,1385,40720,1519,3,68,1,59.08,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3858,7532,1385,40720,1519,3,57,2,340.42,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3859,7532,1386,40720,1519,3,233,1,78.51,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3860,7532,1386,40720,1519,3,250,1,1570.25,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL);
INSERT INTO `balance_libro_details` VALUES (3861,7532,1386,40720,1519,3,68,1,329.75,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3862,7532,1386,40720,1519,3,57,2,1978.51,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3863,7532,1387,40720,1519,3,250,1,95578.51,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3864,7532,1387,40720,1519,3,68,1,20071.49,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3865,7532,1387,40720,1519,3,57,2,115650.00,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3866,7532,1388,40720,1519,3,250,1,16512.00,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3867,7532,1388,40720,1519,3,68,1,3467.52,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3868,7532,1388,40720,1519,3,57,2,19979.52,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3869,7532,1389,40720,1519,3,250,1,6363.63,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3870,7532,1389,40720,1519,3,68,1,1336.36,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3871,7532,1389,40720,1519,3,57,2,7699.99,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3872,7532,1390,40720,1519,3,250,1,3206.59,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3873,7532,1390,40720,1519,3,68,1,673.38,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3874,7532,1390,40720,1519,3,57,2,3879.97,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3875,7532,1391,40720,1519,3,250,1,2132.23,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3876,7532,1391,40720,1519,3,68,1,447.77,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3877,7532,1391,40720,1519,3,57,2,2580.00,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3878,7532,1392,40720,1519,3,233,1,74.80,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3879,7532,1392,40720,1519,3,482,1,3739.83,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3880,7532,1392,40720,1519,3,68,1,785.36,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3881,7532,1392,40720,1519,3,57,2,4599.99,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3882,7532,1393,40720,1519,3,221,1,2127.32,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3883,7532,1393,40720,1519,3,250,1,134829.45,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3884,7532,1393,40720,1519,3,68,1,28314.18,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3885,7532,1393,40720,1519,3,250,1,34729.03,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3886,7532,1393,40720,1519,3,57,2,199999.98,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3887,7532,1394,40720,1519,3,233,1,285.90,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3888,7532,1394,40720,1519,3,482,1,14295.24,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3889,7532,1394,40720,1519,3,68,1,3002.00,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3890,7532,1394,40720,1519,3,57,2,17583.14,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3891,7532,1395,40720,1519,3,233,1,26.08,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3892,7532,1395,40720,1519,3,482,1,283.39,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3893,7532,1395,40720,1519,3,68,1,29.76,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3894,7532,1395,40720,1519,3,482,1,1020.41,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3895,7532,1395,40720,1519,3,68,1,214.29,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3896,7532,1395,40720,1519,3,57,2,1573.93,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3897,7532,1396,40720,1519,3,250,1,1115.70,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3898,7532,1396,40720,1519,3,68,1,234.30,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3899,7532,1396,40720,1519,3,57,2,1350.00,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3900,7532,1397,40720,1519,3,233,1,35.18,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3901,7532,1397,40720,1519,3,482,1,1759.21,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL);
INSERT INTO `balance_libro_details` VALUES (3902,7532,1397,40720,1519,3,68,1,369.43,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3903,7532,1397,40720,1519,3,57,2,2163.82,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3904,7532,1398,40720,1519,3,233,1,35.18,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3905,7532,1398,40720,1519,3,482,1,1759.21,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3906,7532,1398,40720,1519,3,68,1,369.43,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3907,7532,1398,40720,1519,3,57,2,2163.82,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3908,7532,1399,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3909,7532,1399,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3910,7532,1399,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3911,7532,1399,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:27','2022-08-17 11:22:27',NULL),(3912,7532,1400,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3913,7532,1400,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3914,7532,1400,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3915,7532,1400,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3916,7532,1401,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3917,7532,1401,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3918,7532,1401,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3919,7532,1401,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3920,7532,1402,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3921,7532,1402,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3922,7532,1402,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3923,7532,1402,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3924,7532,1403,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3925,7532,1403,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3926,7532,1403,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3927,7532,1403,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3928,7532,1404,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3929,7532,1404,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3930,7532,1404,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3931,7532,1404,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3932,7532,1405,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3933,7532,1405,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3934,7532,1405,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3935,7532,1405,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3936,7532,1406,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3937,7532,1406,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3938,7532,1406,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3939,7532,1406,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:28','2022-08-17 11:22:28',NULL),(3940,7532,1407,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3941,7532,1407,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL);
INSERT INTO `balance_libro_details` VALUES (3942,7532,1407,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3943,7532,1407,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3944,7532,1408,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3945,7532,1408,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3946,7532,1408,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3947,7532,1408,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3948,7532,1409,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3949,7532,1409,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3950,7532,1409,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3951,7532,1409,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3952,7532,1410,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3953,7532,1410,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3954,7532,1410,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3955,7532,1410,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3956,7532,1411,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3957,7532,1411,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3958,7532,1411,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3959,7532,1411,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3960,7532,1412,40720,1519,3,217,1,40000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3961,7532,1412,40720,1519,3,217,1,40000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3962,7532,1412,40720,1519,3,57,2,40000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3963,7532,1412,40720,1519,3,136,2,40000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3964,7532,1413,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3965,7532,1413,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3966,7532,1413,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3967,7532,1413,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:29','2022-08-17 11:22:29',NULL),(3968,7532,1414,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3969,7532,1414,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3970,7532,1414,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3971,7532,1414,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3972,7532,1415,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3973,7532,1415,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3974,7532,1415,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3975,7532,1415,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3976,7532,1416,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3977,7532,1416,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3978,7532,1416,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3979,7532,1416,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3980,7532,1417,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3981,7532,1417,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL);
INSERT INTO `balance_libro_details` VALUES (3982,7532,1417,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3983,7532,1417,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3984,7532,1418,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3985,7532,1418,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3986,7532,1418,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3987,7532,1418,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3988,7532,1419,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3989,7532,1419,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3990,7532,1419,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3991,7532,1419,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3992,7532,1420,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3993,7532,1420,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3994,7532,1420,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3995,7532,1420,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3996,7532,1421,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3997,7532,1421,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3998,7532,1421,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(3999,7532,1421,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:30','2022-08-17 11:22:30',NULL),(4000,7532,1422,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4001,7532,1422,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4002,7532,1422,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4003,7532,1422,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4004,7532,1423,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4005,7532,1423,40720,1519,3,482,1,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4006,7532,1423,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4007,7532,1423,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4008,7532,1424,40720,1519,3,217,1,35000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4009,7532,1424,40720,1519,3,217,1,35000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4010,7532,1424,40720,1519,3,57,2,35000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4011,7532,1424,40720,1519,3,136,2,35000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4012,7532,1425,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4013,7532,1425,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4014,7532,1425,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4015,7532,1425,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4016,7532,1426,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4017,7532,1426,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4018,7532,1426,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4019,7532,1426,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4020,7532,1427,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4021,7532,1427,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL);
INSERT INTO `balance_libro_details` VALUES (4022,7532,1427,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4023,7532,1427,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4024,7532,1428,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4025,7532,1428,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4026,7532,1428,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4027,7532,1428,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:31','2022-08-17 11:22:31',NULL),(4028,7532,1429,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4029,7532,1429,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4030,7532,1429,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4031,7532,1429,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4032,7532,1430,40720,1519,3,217,1,40000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4033,7532,1430,40720,1519,3,217,1,40000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4034,7532,1430,40720,1519,3,57,2,40000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4035,7532,1430,40720,1519,3,136,2,40000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4036,7532,1431,40720,1519,3,217,1,60000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4037,7532,1431,40720,1519,3,217,1,60000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4038,7532,1431,40720,1519,3,57,2,60000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4039,7532,1431,40720,1519,3,136,2,60000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4040,7532,1432,40720,1519,3,217,1,40000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4041,7532,1432,40720,1519,3,217,1,40000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4042,7532,1432,40720,1519,3,57,2,40000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4043,7532,1432,40720,1519,3,136,2,40000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4044,7532,1433,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4045,7532,1433,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4046,7532,1433,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4047,7532,1433,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4048,7532,1434,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4049,7532,1434,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4050,7532,1434,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4051,7532,1434,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4052,7532,1435,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4053,7532,1435,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4054,7532,1435,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4055,7532,1435,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4056,7532,1436,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4057,7532,1436,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4058,7532,1436,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4059,7532,1436,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4060,7532,1437,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4061,7532,1437,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL);
INSERT INTO `balance_libro_details` VALUES (4062,7532,1437,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4063,7532,1437,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4064,7532,1438,40720,1519,3,217,1,24000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4065,7532,1438,40720,1519,3,217,1,24000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4066,7532,1438,40720,1519,3,57,2,24000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4067,7532,1438,40720,1519,3,136,2,24000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4068,7532,1439,40720,1519,3,217,1,40000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4069,7532,1439,40720,1519,3,217,1,40000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4070,7532,1439,40720,1519,3,57,2,40000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4071,7532,1439,40720,1519,3,136,2,40000.00,NULL,'2022-08-17 11:22:32','2022-08-17 11:22:32',NULL),(4072,7532,1440,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4073,7532,1440,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4074,7532,1440,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4075,7532,1440,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4076,7532,1441,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4077,7532,1441,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4078,7532,1441,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4079,7532,1441,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4080,7532,1442,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4081,7532,1442,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4082,7532,1442,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4083,7532,1442,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4084,7532,1443,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4085,7532,1443,40720,1519,3,217,1,20000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4086,7532,1443,40720,1519,3,57,2,20000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4087,7532,1443,40720,1519,3,136,2,20000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4088,7532,1444,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4089,7532,1444,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4090,7532,1444,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4091,7532,1444,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4092,7532,1445,40720,1519,3,217,1,960.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4093,7532,1445,40720,1519,3,217,1,960.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4094,7532,1445,40720,1519,3,57,2,960.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4095,7532,1445,40720,1519,3,136,2,960.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4096,7532,1446,40720,1519,3,217,1,50000.00,NULL,'2022-08-17 11:22:33','2022-08-17 11:22:33',NULL),(4097,7532,1446,40720,1519,3,217,1,50000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4098,7532,1446,40720,1519,3,57,2,50000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4099,7532,1446,40720,1519,3,136,2,50000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4100,7532,1447,40720,1519,3,217,1,720.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4101,7532,1447,40720,1519,3,217,1,720.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL);
INSERT INTO `balance_libro_details` VALUES (4102,7532,1447,40720,1519,3,57,2,720.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4103,7532,1447,40720,1519,3,136,2,720.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4104,7532,1448,40720,1519,3,217,1,3850.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4105,7532,1448,40720,1519,3,217,1,3850.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4106,7532,1448,40720,1519,3,57,2,3850.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4107,7532,1448,40720,1519,3,136,2,3850.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4108,7532,1449,40720,1519,3,217,1,40000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4109,7532,1449,40720,1519,3,217,1,40000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4110,7532,1449,40720,1519,3,57,2,40000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4111,7532,1449,40720,1519,3,136,2,40000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4112,7532,1450,40720,1519,3,217,1,35000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4113,7532,1450,40720,1519,3,217,1,35000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4114,7532,1450,40720,1519,3,57,2,35000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4115,7532,1450,40720,1519,3,136,2,35000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4116,7532,1451,40720,1519,3,482,1,75000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4117,7532,1451,40720,1519,3,482,1,75000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4118,7532,1451,40720,1519,3,57,2,75000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4119,7532,1451,40720,1519,3,136,2,75000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4120,7532,1452,40720,1519,3,217,1,50000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4121,7532,1452,40720,1519,3,217,1,50000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4122,7532,1452,40720,1519,3,57,2,50000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4123,7532,1452,40720,1519,3,136,2,50000.00,NULL,'2022-08-17 11:22:34','2022-08-17 11:22:34',NULL),(4124,7532,1453,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:35','2022-08-17 11:22:35',NULL),(4125,7532,1453,40720,1519,3,217,1,25000.00,NULL,'2022-08-17 11:22:35','2022-08-17 11:22:35',NULL),(4126,7532,1453,40720,1519,3,57,2,25000.00,NULL,'2022-08-17 11:22:35','2022-08-17 11:22:35',NULL),(4127,7532,1453,40720,1519,3,136,2,25000.00,NULL,'2022-08-17 11:22:35','2022-08-17 11:22:35',NULL),(4128,7532,1454,40720,1519,2,96,2,495867.77,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4129,7532,1454,40720,1519,2,67,2,104132.23,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4130,7532,1454,40720,1519,2,13,1,600000.00,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4131,7532,1455,40720,1519,2,96,2,495867.77,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4132,7532,1455,40720,1519,2,67,2,104132.23,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4133,7532,1455,40720,1519,2,13,1,600000.00,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4134,7532,1456,40720,1519,2,96,2,483471.08,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4135,7532,1456,40720,1519,2,67,2,101528.93,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4136,7532,1456,40720,1519,2,13,1,585000.01,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4137,7532,1457,40720,1519,2,96,2,586776.86,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4138,7532,1457,40720,1519,2,67,2,123223.14,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4139,7532,1457,40720,1519,2,13,1,710000.00,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4140,7532,1458,40720,1519,2,96,2,595041.32,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4141,7532,1458,40720,1519,2,67,2,124958.68,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL);
INSERT INTO `balance_libro_details` VALUES (4142,7532,1458,40720,1519,2,13,1,720000.00,NULL,'2022-08-17 11:24:33','2022-08-17 11:24:33',NULL),(4143,7532,1459,40720,1519,2,96,2,595041.32,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4144,7532,1459,40720,1519,2,67,2,124958.68,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4145,7532,1459,40720,1519,2,13,1,720000.00,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4146,7532,1460,40720,1519,2,96,2,495867.77,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4147,7532,1460,40720,1519,2,67,2,104132.23,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4148,7532,1460,40720,1519,2,13,1,600000.00,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4149,7532,1461,40720,1519,2,96,2,1198347.11,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4150,7532,1461,40720,1519,2,67,2,251652.89,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4151,7532,1461,40720,1519,2,13,1,1450000.00,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4152,7532,1462,40720,1519,2,96,2,1735537.19,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4153,7532,1462,40720,1519,2,67,2,364462.81,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4154,7532,1462,40720,1519,2,13,1,2100000.00,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4155,7532,1463,40720,1519,2,96,2,735537.19,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4156,7532,1463,40720,1519,2,67,2,154462.81,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4157,7532,1463,40720,1519,2,13,1,890000.00,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4158,7532,1464,40720,1519,2,96,2,677685.95,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4159,7532,1464,40720,1519,2,67,2,142314.05,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4160,7532,1464,40720,1519,2,13,1,820000.00,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4161,7532,1465,40720,1519,2,96,2,355371.90,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4162,7532,1465,40720,1519,2,67,2,74628.10,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4163,7532,1465,40720,1519,2,13,1,430000.00,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4164,7532,1466,40720,1519,2,96,2,347107.44,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4165,7532,1466,40720,1519,2,67,2,72892.56,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4166,7532,1466,40720,1519,2,13,1,420000.00,NULL,'2022-08-17 11:24:34','2022-08-17 11:24:34',NULL),(4167,7532,1467,40720,1519,2,96,2,537190.08,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4168,7532,1467,40720,1519,2,67,2,112809.92,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4169,7532,1467,40720,1519,2,13,1,650000.00,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4170,7532,1468,40720,1519,2,96,2,677685.95,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4171,7532,1468,40720,1519,2,67,2,142314.05,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4172,7532,1468,40720,1519,2,13,1,820000.00,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4173,7532,1469,40720,1519,2,96,2,429752.07,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4174,7532,1469,40720,1519,2,67,2,90247.93,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4175,7532,1469,40720,1519,2,13,1,520000.00,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4176,7532,1470,40720,1519,2,96,2,322314.05,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4177,7532,1470,40720,1519,2,67,2,67685.95,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4178,7532,1470,40720,1519,2,13,1,390000.00,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4179,7532,1471,40720,1519,2,96,2,206611.57,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4180,7532,1471,40720,1519,2,67,2,43388.43,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4181,7532,1471,40720,1519,2,13,1,250000.00,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL);
INSERT INTO `balance_libro_details` VALUES (4182,7532,1472,40720,1519,2,96,2,495867.77,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4183,7532,1472,40720,1519,2,67,2,104132.23,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL),(4184,7532,1472,40720,1519,2,13,1,600000.00,NULL,'2022-08-17 11:24:35','2022-08-17 11:24:35',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-08-11 08:55:06',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-08-11 08:55:06',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-08-11 08:55:06',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-08-11 08:55:06','2022-08-11 08:55:06',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-08-11 08:55:13','2022-08-11 08:55:13',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-08-11 08:55:13','2022-08-11 08:55:13',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-08-11 08:55:13','2022-08-11 08:55:13',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-08-11 08:55:13','2022-08-11 08:55:13',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-08-11 08:55:20','2022-08-11 08:55:20',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-08-11 08:55:20','2022-08-11 08:55:20',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-08-11 08:55:20','2022-08-11 08:55:20',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-08-11 08:55:20','2022-08-11 08:55:20',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:03:21','2023-05-30 15:03:21',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:03:21','2023-05-30 15:03:21',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:03:21','2023-05-30 15:03:21',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:03:21','2023-05-30 15:03:21',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:03:21','2023-05-30 15:03:21',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:03:21','2023-05-30 15:03:21',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-10-23 23:32:56',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-10-23 23:32:56',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-10-23 23:32:56',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-10-23 23:32:56',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-10-23 23:32:56',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-10-23 23:32:56',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:32:56',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-10-23 23:32:56',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',1414762.00,117896.00,'No Excluida','0',30,3330,230178.48,496.85,496.85,2192.15,3061.75,5750.75,5750.75,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',2103025.00,175252.00,'No Excluida','0',45,5000,230178.48,957.27,957.27,2411.36,3061.75,6430.38,6430.38,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',2944235.00,245352.00,'No Excluida','0',60,6700,460356.93,1636.83,1512.56,2652.52,3061.75,7351.10,7226.83,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',3656604.00,304717.00,'No Excluida','0',85,10000,460356.93,2689.05,2484.46,2917.75,3638.26,9245.06,9040.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',4305799.00,358816.00,'No Excluida','0',110,13000,573619.32,5115.04,3967.80,3209.55,4452.02,12776.61,11629.37,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',5382248.00,448520.00,'No Excluida','0',150,16500,575446.12,7036.89,5180.81,3530.49,5145.02,15712.40,13856.32,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',6458698.00,538224.00,'No Excluida','0',200,20000,690535.39,8951.39,6459.54,3883.53,5512.52,18347.44,15855.59,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',7996484.00,666373.00,'No Excluida','0',200,20000,920713.84,20460.26,15856.76,4271.88,6615.02,31347.16,26743.66,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',8949911.00,745825.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,25575.36,4699.08,8190.03,NULL,38464.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',10257028.00,854752.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,30054.72,5169.03,9166.53,NULL,44390.28,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',11379612.00,948301.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,34526.76,5685.87,10505.29,NULL,50717.92,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-08-11 08:55:13','2022-08-11 08:55:14',NULL),(2,NULL,'Articulo 6',6,0,'2022-08-11 08:55:13','2022-08-11 08:55:14',NULL),(3,NULL,'Articulo 7',7,0,'2022-08-11 08:55:13','2022-08-11 08:55:14',NULL),(4,NULL,'Articulo 8',8,0,'2022-08-11 08:55:13','2022-08-11 08:55:14',NULL),(5,NULL,'Articulo 9',9,0,'2022-08-11 08:55:13','2022-08-11 08:55:14',NULL),(6,NULL,'Articulo 10',10,0,'2022-08-11 08:55:13','2022-08-11 08:55:14',NULL),(7,NULL,'Articulo 11',11,0,'2022-08-11 08:55:13','2022-08-11 08:55:14',NULL),(8,NULL,'Articulo 12',12,0,'2022-08-11 08:55:13','2022-08-11 08:55:14',NULL),(9,NULL,'Articulo 13',13,0,'2022-08-11 08:55:13','2022-08-11 08:55:14',NULL),(10,NULL,'Articulo 14',14,1,'2022-08-11 08:55:13','2022-08-11 08:55:14',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:42:15','2023-03-12 23:42:15',NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=494 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales','Result. Negativo',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22'),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,7532,1220110,5,1,1220100,'Amortización Acumulada Equipos De Computación','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,7532,2110351,5,2,2110300,'Intereses negativos a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(482,7532,1110214,5,1,1110200,'Banco Formosa Cuenta Corriente','Activo',NULL,1,1,1,1,1,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (483,7532,1110215,5,1,1110200,'Banco BBVA Francés Cuenta Corriente','Activo',NULL,1,1,1,1,1,1,NULL),(484,7532,1220801,5,1,1220800,'Herramientas menores','Activo',NULL,1,1,1,1,1,1,NULL),(485,7532,1220701,5,1,1220700,'Equipos Varios','Activo',NULL,1,1,1,1,1,1,NULL),(486,7532,2110206,5,2,2110200,'Aportes a pagar','Pasivo',NULL,1,1,0,0,0,0,NULL),(487,7532,2110207,5,2,2110200,'Leyes Sociales A Pagar','Pasivo',NULL,1,1,0,0,0,0,NULL),(488,7532,2110208,5,2,2110200,'Indemnización Por Extinción Laboral A Pagar','Pasivo',NULL,1,1,0,0,0,0,NULL),(489,7532,2110209,5,2,2110200,'Cheques diferidos a pagar','Pasivo',NULL,1,1,0,0,0,0,NULL),(490,7532,1220700,4,1,1220000,'EQUIPOS VARIOS','Activo',NULL,1,1,0,0,0,0,NULL),(491,7532,1220800,4,1,1220000,'HERRAMIENTAS MENORES','Activo',NULL,1,1,0,0,0,0,NULL),(492,7532,1220702,5,1,1220700,'Amortización Acumulada Equipos Varios','Activo',NULL,1,1,0,0,0,0,NULL),(493,7532,1220802,5,1,1220800,'Amortización Acumulada Herramientas Menores','Activo',NULL,1,1,0,0,0,0,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1470 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,7532,2,40720,40721,13,1524,1,0,'2022-07-01',55000.00,1,1.00,'Factura C N°: 0002-00000009',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(2,7532,2,40720,40722,13,1524,1,0,'2022-07-01',549999.99,1,1.00,'Factura A N°: 0003-00000039',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(3,7532,2,40720,40722,13,1524,1,0,'2022-07-01',549999.99,1,1.00,'Factura A N°: 0003-00000040',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(4,7532,2,40720,40723,13,1524,1,0,'2022-07-01',55000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(5,7532,2,40720,40724,13,1524,1,0,'2022-07-01',55000.00,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(6,7532,2,40720,40725,13,1524,1,0,'2022-07-01',35000.00,1,1.00,'Factura C N°: 0002-00000004',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(7,7532,2,40720,40726,13,1524,1,0,'2022-07-01',3900.00,1,1.00,'Factura A N°: 0005-00005200',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(8,7532,2,40720,40727,13,1524,1,0,'2022-07-01',18150.07,1,1.00,'Factura A N°: 0006-00001171',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(9,7532,2,40720,40728,13,1524,1,0,'2022-07-01',150000.00,1,1.00,'Factura C N°: 0002-00000173',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(10,7532,2,40720,40729,13,1524,1,0,'2022-07-01',1953389.97,1,1.00,'Factura A N°: 0003-00000317',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(11,7532,2,40720,40729,13,1524,1,0,'2022-07-01',221000.00,1,1.00,'Factura A N°: 0003-00000318',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(12,7532,2,40720,40730,13,1524,1,0,'2022-07-01',15064.50,1,1.00,'Factura A N°: 0001-00000389',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(13,7532,2,40720,40731,13,1524,1,0,'2022-07-01',35000.00,1,1.00,'Factura C N°: 0001-00000004',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(14,7532,2,40720,40732,13,1524,1,0,'2022-07-01',60000.00,1,1.00,'Factura C N°: 0001-00000027',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(15,7532,2,40720,40733,13,1524,1,0,'2022-07-01',55000.00,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(16,7532,2,40720,40734,13,1524,1,0,'2022-07-01',35000.00,1,1.00,'Factura C N°: 0001-00000004',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(17,7532,2,40720,40735,13,1524,1,0,'2022-07-01',100000.00,1,1.00,'Factura C N°: 0002-00000003',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(18,7532,2,40720,40736,13,1524,1,0,'2022-07-01',6050.00,1,1.00,'Factura A N°: 0001-00000426',NULL,'2022-08-11 10:01:43','2022-08-11 10:38:10','2022-08-11 10:38:10'),(19,7532,2,40720,40737,13,1524,1,0,'2022-07-01',55000.00,1,1.00,'Factura C N°: 0003-00000009',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(20,7532,2,40720,40738,13,1524,1,0,'2022-07-01',55000.00,1,1.00,'Factura C N°: 0002-00000005',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(21,7532,2,40720,40730,13,1524,1,0,'2022-07-02',9471.01,1,1.00,'Factura A N°: 0001-00000396',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(22,7532,2,40720,40739,13,1524,1,0,'2022-07-04',168000.00,1,1.00,'Factura C N°: 0003-00000067',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(23,7532,2,40720,40739,13,1524,1,0,'2022-07-04',408000.00,1,1.00,'Factura C N°: 0003-00000068',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(24,7532,2,40720,40740,13,1524,1,0,'2022-07-05',30000.00,1,1.00,'Factura C N°: 0001-00000005',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10');
INSERT INTO `cta_cte_cliente` VALUES (25,7532,2,40720,40741,13,1524,1,0,'2022-07-05',13100.00,1,1.00,'Factura A N°: 0027-00004080',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(26,7532,2,40720,40742,13,1524,1,0,'2022-07-05',75000.00,1,1.00,'Factura C N°: 0001-00000005',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(27,7532,2,40720,40743,13,1524,1,0,'2022-07-05',25000.00,1,1.00,'Factura C N°: 0001-00000004',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(28,7532,2,40720,40726,13,1524,1,0,'2022-07-05',14233.16,1,1.00,'Factura A N°: 0005-00005228',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(29,7532,2,40720,40744,13,1524,1,0,'2022-07-05',40000.00,1,1.00,'Factura C N°: 0001-00000199',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(30,7532,2,40720,40745,13,1524,1,0,'2022-07-05',75000.00,1,1.00,'Factura C N°: 0001-00000037',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(31,7532,2,40720,40746,13,1524,1,0,'2022-07-05',40000.00,1,1.00,'Factura C N°: 0001-00000092',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(32,7532,2,40720,40727,13,1524,1,0,'2022-07-05',1810.00,1,1.00,'Factura A N°: 0006-00001188',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(33,7532,2,40720,40747,13,1524,1,0,'2022-07-05',25000.00,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(34,7532,2,40720,40748,13,1524,1,0,'2022-07-05',30000.00,1,1.00,'Factura C N°: 0001-00000006',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(35,7532,2,40720,40749,13,1524,1,0,'2022-07-05',30000.00,1,1.00,'Factura C N°: 0001-00000004',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(36,7532,2,40720,40750,13,1524,1,0,'2022-07-05',12360.00,1,1.00,'Factura A N°: 0009-00005093',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(37,7532,2,40720,40751,13,1524,1,0,'2022-07-05',50000.00,1,1.00,'Factura C N°: 0001-00000016',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(38,7532,2,40720,40728,13,1524,1,0,'2022-07-05',60000.00,1,1.00,'Factura C N°: 0002-00000174',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(39,7532,2,40720,40752,13,1524,1,0,'2022-07-05',372680.00,1,1.00,'Factura A N°: 0001-00000038',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(40,7532,2,40720,40753,13,1524,1,0,'2022-07-05',25000.00,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(41,7532,2,40720,40754,13,1524,1,0,'2022-07-05',65000.00,1,1.00,'Factura C N°: 0001-00000007',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(42,7532,2,40720,40755,13,1524,1,0,'2022-07-05',70000.00,1,1.00,'Factura C N°: 0002-00000370',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(43,7532,2,40720,40756,13,1524,1,0,'2022-07-05',65000.00,1,1.00,'Factura C N°: 0001-00000001',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(44,7532,2,40720,40757,13,1524,1,0,'2022-07-05',75000.00,1,1.00,'Factura C N°: 0001-00000007',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(45,7532,2,40720,40758,13,1524,1,0,'2022-07-05',50000.00,1,1.00,'Factura C N°: 0001-00000001',NULL,'2022-08-11 10:01:44','2022-08-11 10:38:10','2022-08-11 10:38:10'),(46,7532,2,40720,40759,13,1524,1,0,'2022-07-05',50000.00,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(47,7532,2,40720,40760,13,1524,1,0,'2022-07-05',393144.00,1,1.00,'Factura A N°: 0001-00000006',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(48,7532,2,40720,40761,13,1524,1,0,'2022-07-05',75000.00,1,1.00,'Factura C N°: 0002-00000005',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10');
INSERT INTO `cta_cte_cliente` VALUES (49,7532,2,40720,40762,13,1524,1,0,'2022-07-06',273460.00,1,1.00,'Factura A N°: 0003-00001034',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(50,7532,2,40720,40763,13,1524,1,0,'2022-07-06',60000.00,1,1.00,'Factura C N°: 0001-00000001',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(51,7532,2,40720,40764,13,1524,1,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(52,7532,2,40720,40765,13,1524,1,0,'2022-07-06',35000.00,1,1.00,'Factura C N°: 0001-00000012',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(53,7532,2,40720,40766,13,1524,1,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0002-00000010',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(54,7532,2,40720,40767,13,1524,1,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000012',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(55,7532,2,40720,40768,13,1524,1,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000012',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(56,7532,2,40720,40769,13,1524,1,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000012',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(57,7532,2,40720,40770,13,1524,1,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0002-00000011',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(58,7532,2,40720,40771,13,1524,1,0,'2022-07-06',5685.75,1,1.00,'Factura A N°: 0001-00009491',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(59,7532,2,40720,40771,13,1524,1,0,'2022-07-06',43861.51,1,1.00,'Factura A N°: 0001-00009490',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(60,7532,2,40720,40772,13,1524,1,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(61,7532,2,40720,40773,13,1524,1,0,'2022-07-06',7500.00,1,1.00,'Factura C N°: 0002-00000237',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(62,7532,2,40720,40774,13,1524,1,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000012',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(63,7532,2,40720,40775,13,1524,1,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000012',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(64,7532,2,40720,40776,13,1524,1,0,'2022-07-06',1300.00,1,1.00,'Factura A N°: 0005-00000077',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(65,7532,2,40720,40777,13,1524,1,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(66,7532,2,40720,40778,13,1524,1,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:10','2022-08-11 10:38:10'),(67,7532,2,40720,40779,13,1524,1,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:11','2022-08-11 10:38:11'),(68,7532,2,40720,40780,13,1524,1,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:01:45','2022-08-11 10:38:11','2022-08-11 10:38:11'),(69,7532,2,40720,40776,13,1524,1,0,'2022-07-06',1370.00,1,1.00,'Factura A N°: 0005-00000073',NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(70,7532,2,40720,40781,13,1524,1,0,'2022-07-06',2250.12,1,1.00,'Factura A N°: 0007-00009011',NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(71,7532,2,40720,40782,13,1524,1,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0002-00000009',NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(72,7532,2,40720,40783,13,1524,1,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11');
INSERT INTO `cta_cte_cliente` VALUES (73,7532,2,40720,40784,13,1524,1,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(74,7532,2,40720,40785,13,1524,1,0,'2022-07-06',35000.00,1,1.00,'Factura C N°: 0003-00000012',NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(75,7532,2,40720,40786,13,1524,1,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(76,7532,2,40720,40787,13,1524,1,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(77,7532,2,40720,40762,13,1524,1,0,'2022-07-07',353925.00,1,1.00,'Factura A N°: 0003-00001036',NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(78,7532,2,40720,40788,13,1524,1,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(79,7532,2,40720,40789,13,1524,1,0,'2022-07-07',26531.40,1,1.00,'Factura A N°: 0015-00004838',NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(80,7532,2,40720,40790,13,1524,1,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000006',NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(81,7532,2,40720,40791,13,1524,1,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:01:46','2022-08-11 10:38:11','2022-08-11 10:38:11'),(82,7532,2,40720,40792,13,1524,1,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(83,7532,2,40720,40727,13,1524,1,0,'2022-07-07',7699.99,1,1.00,'Factura A N°: 0006-00001206',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(84,7532,2,40720,40793,13,1524,1,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(85,7532,2,40720,40794,13,1524,1,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(86,7532,2,40720,40795,13,1524,1,0,'2022-07-07',5000.00,1,1.00,'Factura C N°: 0001-00000105',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(87,7532,2,40720,40732,13,1524,1,0,'2022-07-07',360000.00,1,1.00,'Factura C N°: 0001-00000028',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(88,7532,2,40720,40796,13,1524,1,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000009',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(89,7532,2,40720,40797,13,1524,1,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(90,7532,2,40720,40798,13,1524,1,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000008',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(91,7532,2,40720,40799,13,1524,2,0,'2022-07-07',25000.00,1,1.00,'Nota de crédito C N°: 0001-00000001',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(92,7532,2,40720,40799,13,1524,1,0,'2022-07-07',25000.00,1,1.00,'Factura C N°: 0001-00000004',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(93,7532,2,40720,40800,13,1524,1,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0002-00000011',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(94,7532,2,40720,40801,13,1524,1,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000009',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(95,7532,2,40720,40802,13,1524,1,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(96,7532,2,40720,40803,13,1524,1,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11');
INSERT INTO `cta_cte_cliente` VALUES (97,7532,2,40720,40804,13,1524,1,0,'2022-07-07',35000.00,1,1.00,'Factura C N°: 0001-00000001',NULL,'2022-08-11 10:01:47','2022-08-11 10:38:11','2022-08-11 10:38:11'),(98,7532,2,40720,40805,13,1524,1,0,'2022-07-08',100000.00,1,1.00,'Factura C N°: 0001-00000085',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(99,7532,2,40720,40806,13,1524,1,0,'2022-07-08',261900.00,1,1.00,'Factura C N°: 0003-00000278',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(100,7532,2,40720,40762,13,1524,1,0,'2022-07-11',250107.00,1,1.00,'Factura A N°: 0003-00001039',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(101,7532,2,40720,40807,13,1524,1,0,'2022-07-11',50000.00,1,1.00,'Factura C N°: 0001-00000076',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(102,7532,2,40720,40808,13,1524,1,0,'2022-07-11',173750.00,1,1.00,'Factura A N°: 0002-00000149',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(103,7532,2,40720,40809,13,1524,1,0,'2022-07-11',140000.00,1,1.00,'Factura C N°: 0002-00000044',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(104,7532,2,40720,40810,13,1524,1,0,'2022-07-11',50000.00,1,1.00,'Factura C N°: 0001-00000076',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(105,7532,2,40720,40811,13,1524,1,0,'2022-07-11',50000.00,1,1.00,'Factura C N°: 0001-00000080',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(106,7532,2,40720,40812,13,1524,1,0,'2022-07-11',41000.00,1,1.00,'Factura C N°: 0001-00000080',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(107,7532,2,40720,40813,13,1524,1,0,'2022-07-11',50000.00,1,1.00,'Factura C N°: 0002-00000059',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(108,7532,2,40720,40814,13,1524,1,0,'2022-07-11',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(109,7532,2,40720,40815,13,1524,1,0,'2022-07-11',50000.00,1,1.00,'Factura C N°: 0001-00000060',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(110,7532,2,40720,40799,13,1524,1,0,'2022-07-11',50000.00,1,1.00,'Factura C N°: 0001-00000005',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(111,7532,2,40720,40816,13,1524,1,0,'2022-07-11',48000.00,1,1.00,'Factura C N°: 0001-00000002',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(112,7532,2,40720,40817,13,1524,1,0,'2022-07-11',196000.00,1,1.00,'Factura A N°: 0002-00000018',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(113,7532,2,40720,40818,13,1524,1,0,'2022-07-11',82000.00,1,1.00,'Factura C N°: 0001-00000081',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(114,7532,2,40720,40762,13,1524,1,0,'2022-07-12',384780.00,1,1.00,'Factura A N°: 0003-00001045',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(115,7532,2,40720,40726,13,1524,1,0,'2022-07-12',4099.99,1,1.00,'Factura A N°: 0005-00005275',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(116,7532,2,40720,40819,13,1524,1,0,'2022-07-12',2178000.00,1,1.00,'Factura A N°: 0004-00000001',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(117,7532,2,40720,40727,13,1524,1,0,'2022-07-12',18170.03,1,1.00,'Factura A N°: 0006-00001229',NULL,'2022-08-11 10:01:48','2022-08-11 10:38:11','2022-08-11 10:38:11'),(118,7532,2,40720,40820,13,1524,1,0,'2022-07-12',1800.00,1,1.00,'Factura C N°: 0002-00000486',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(119,7532,2,40720,40776,13,1524,1,0,'2022-07-12',2480.00,1,1.00,'Factura A N°: 0005-00000113',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11');
INSERT INTO `cta_cte_cliente` VALUES (120,7532,2,40720,40776,13,1524,1,0,'2022-07-12',1450.00,1,1.00,'Factura A N°: 0005-00000112',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(121,7532,2,40720,40821,13,1524,1,0,'2022-07-13',609.92,1,1.00,'Factura A N°: 0009-00001119',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(122,7532,2,40720,40762,13,1524,1,0,'2022-07-13',365420.00,1,1.00,'Factura A N°: 0003-00001047',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(123,7532,2,40720,40789,13,1524,1,0,'2022-07-13',34765.30,1,1.00,'Factura A N°: 0015-00004854',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(124,7532,2,40720,40822,13,1524,2,0,'2022-07-13',178000.00,1,1.00,'Nota de crédito A N°: 0003-00000003',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(125,7532,2,40720,40727,13,1524,1,0,'2022-07-13',250.29,1,1.00,'Factura A N°: 0006-00001232',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(126,7532,2,40720,40822,13,1524,1,0,'2022-07-13',178000.00,1,1.00,'Factura A N°: 0003-00000269',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(127,7532,2,40720,40773,13,1524,1,0,'2022-07-13',21400.00,1,1.00,'Factura C N°: 0002-00000238',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(128,7532,2,40720,40823,13,1524,1,0,'2022-07-13',50000.00,1,1.00,'Factura C N°: 0001-00000001',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:11','2022-08-11 10:38:11'),(129,7532,2,40720,40824,13,1524,1,0,'2022-07-14',24600.00,1,1.00,'Factura C N°: 0001-00000028',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(130,7532,2,40720,40824,13,1524,1,0,'2022-07-14',60000.00,1,1.00,'Factura C N°: 0001-00000027',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(131,7532,2,40720,40825,13,1524,1,0,'2022-07-14',270000.00,1,1.00,'Factura C N°: 0005-00000017',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(132,7532,2,40720,40825,13,1524,1,0,'2022-07-14',35000.00,1,1.00,'Factura C N°: 0006-00000013',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(133,7532,2,40720,40821,13,1524,1,0,'2022-07-15',5641.73,1,1.00,'Factura A N°: 0009-00001121',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(134,7532,2,40720,40826,13,1524,1,0,'2022-07-15',1750.00,1,1.00,'Factura A N°: 0005-00000050',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(135,7532,2,40720,40808,13,1524,1,0,'2022-07-18',1210000.00,1,1.00,'Factura A N°: 0002-00000151',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(136,7532,2,40720,40799,13,1524,1,0,'2022-07-18',100000.00,1,1.00,'Factura C N°: 0001-00000006',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(137,7532,2,40720,40827,13,1524,1,0,'2022-07-19',2800.00,1,1.00,'RECIBO C N°: 0006-00015661',NULL,'2022-08-11 10:01:49','2022-08-11 10:38:12','2022-08-11 10:38:12'),(138,7532,2,40720,40750,13,1524,1,0,'2022-07-19',12600.00,1,1.00,'Factura A N°: 0009-00005262',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(139,7532,2,40720,40828,13,1524,1,0,'2022-07-19',400.00,1,1.00,'Factura C N°: 0001-00000094',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(140,7532,2,40720,40805,13,1524,1,0,'2022-07-20',200000.00,1,1.00,'Factura C N°: 0001-00000086',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(141,7532,2,40720,40829,13,1524,1,0,'2022-07-20',110000.00,1,1.00,'Factura A N°: 0003-00000039',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(142,7532,2,40720,40830,13,1524,1,0,'2022-07-20',5000.00,1,1.00,'Factura C N°: 0002-00000084',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12');
INSERT INTO `cta_cte_cliente` VALUES (143,7532,2,40720,40831,13,1524,1,0,'2022-07-21',200000.00,1,1.00,'RECIBO C N°: 0001-00000213',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(144,7532,2,40720,40832,13,1524,1,0,'2022-07-22',186000.04,1,1.00,'Factura A N°: 0001-00002416',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(145,7532,2,40720,40789,13,1524,1,0,'2022-07-22',36900.00,1,1.00,'Factura A N°: 0015-00004879',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(146,7532,2,40720,40727,13,1524,1,0,'2022-07-22',15470.01,1,1.00,'Factura A N°: 0006-00001361',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(147,7532,2,40720,40833,13,1524,1,0,'2022-07-22',32689.00,1,1.00,'Factura A N°: 0001-00011426',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(148,7532,2,40720,40833,13,1524,1,0,'2022-07-22',32689.00,1,1.00,'Factura A N°: 0001-00011427',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(149,7532,2,40720,40834,13,1524,1,0,'2022-07-23',2000.00,1,1.00,'RECIBO A N°: 0001-00001828',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(150,7532,2,40720,40799,13,1524,1,0,'2022-07-23',70000.00,1,1.00,'Factura C N°: 0001-00000007',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(151,7532,2,40720,40835,13,1524,1,0,'2022-07-25',34002.17,1,1.00,'Factura A N°: 0010-00000465',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(152,7532,2,40720,40727,13,1524,1,0,'2022-07-25',1790.00,1,1.00,'Factura A N°: 0006-00001384',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(153,7532,2,40720,40836,13,1524,1,0,'2022-07-25',2700.00,1,1.00,'Factura A N°: 8364-00004325',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(154,7532,2,40720,40776,13,1524,1,0,'2022-07-25',1200.00,1,1.00,'Factura A N°: 0005-00000177',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(155,7532,2,40720,40726,13,1524,1,0,'2022-07-26',18333.15,1,1.00,'Factura A N°: 0005-00005377',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(156,7532,2,40720,40727,13,1524,1,0,'2022-07-26',9019.98,1,1.00,'Factura A N°: 0006-00001413',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(157,7532,2,40720,40727,13,1524,1,0,'2022-07-26',33779.97,1,1.00,'Factura A N°: 0006-00001437',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(158,7532,2,40720,40837,13,1524,1,0,'2022-07-26',15000.00,1,1.00,'Factura C N°: 0002-00000237',NULL,'2022-08-11 10:01:50','2022-08-11 10:38:12','2022-08-11 10:38:12'),(159,7532,2,40720,40729,13,1524,1,0,'2022-07-26',600000.00,1,1.00,'Factura A N°: 0003-00000320',NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(160,7532,2,40720,40838,13,1524,1,0,'2022-07-27',160415.10,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(161,7532,2,40720,40839,13,1524,1,0,'2022-07-27',1500.00,1,1.00,'Factura C N°: 0003-00000159',NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(162,7532,2,40720,40741,13,1524,1,0,'2022-07-28',87790.15,1,1.00,'Factura A N°: 0027-00004224',NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(163,7532,2,40720,40840,13,1524,1,0,'2022-07-28',11794.95,1,1.00,'Factura A N°: 0014-00023157',NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(164,7532,2,40720,40841,13,1524,1,0,'2022-07-29',400000.00,1,1.00,'Factura A N°: 0006-00000194',NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(165,7532,2,40720,40842,13,1524,1,0,'2022-07-29',1499.99,1,1.00,'Factura A N°: 0008-00024246',NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(166,7532,2,40720,40727,13,1524,1,0,'2022-07-29',8969.98,1,1.00,'Factura A N°: 0006-00001506',NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12');
INSERT INTO `cta_cte_cliente` VALUES (167,7532,2,40720,40843,13,1524,1,0,'2022-07-29',10701.62,1,1.00,'Factura A N°: 0009-00010456',NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(168,7532,2,40720,40808,13,1524,1,0,'2022-07-30',1210000.00,1,1.00,'Factura A N°: 0002-00000154',NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(169,7532,2,40720,40844,13,1524,1,0,'2022-07-30',60000.00,1,1.00,'Factura C N°: 0001-00000057',NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(170,7532,2,40720,40799,13,1524,1,0,'2022-07-30',50000.00,1,1.00,'Factura C N°: 0001-00000008',NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(171,7532,2,40720,40845,13,1524,1,0,'2022-07-31',190000.00,1,1.00,'Factura C N°: 0001-00000002',NULL,'2022-08-11 10:01:51','2022-08-11 10:38:12','2022-08-11 10:38:12'),(172,7532,2,40720,40846,13,1524,1,0,'2022-07-01',520000.00,1,1.00,'Factura A N°: 0001-00000556',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(173,7532,2,40720,40847,13,1524,1,0,'2022-07-01',504000.00,1,1.00,'Factura A N°: 0001-00000557',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(174,7532,2,40720,40848,13,1524,1,0,'2022-07-01',510000.00,1,1.00,'Factura A N°: 0001-00000558',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(175,7532,2,40720,40849,13,1524,1,0,'2022-07-01',950000.00,1,1.00,'Factura A N°: 0001-00000559',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(176,7532,2,40720,40850,13,1524,1,0,'2022-07-01',1600000.00,1,1.00,'Factura A N°: 0001-00000560',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(177,7532,2,40720,40850,13,1524,1,0,'2022-07-01',500000.00,1,1.00,'Factura A N°: 0001-00000561',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(178,7532,2,40720,40850,13,1524,1,0,'2022-07-01',2500000.00,1,1.00,'Factura A N°: 0001-00000562',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(179,7532,2,40720,40851,13,1524,1,0,'2022-07-04',1740000.00,1,1.00,'Factura A N°: 0001-00000563',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(180,7532,2,40720,40851,13,1524,1,0,'2022-07-04',720000.00,1,1.00,'Factura A N°: 0001-00000564',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(181,7532,2,40720,40852,13,1524,1,0,'2022-07-05',289379.51,1,1.00,'Factura A N°: 0001-00000565',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(182,7532,2,40720,40852,13,1524,1,0,'2022-07-05',9102372.70,1,1.00,'Factura A N°: 0001-00000566',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(183,7532,2,40720,40853,13,1524,1,0,'2022-07-06',720000.00,1,1.00,'Factura A N°: 0001-00000567',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(184,7532,2,40720,40853,13,1524,1,0,'2022-07-06',720000.00,1,1.00,'Factura A N°: 0001-00000568',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(185,7532,2,40720,40854,13,1524,1,0,'2022-07-06',984000.00,1,1.00,'Factura A N°: 0001-00000569',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(186,7532,2,40720,40855,13,1524,1,0,'2022-07-06',1700000.00,1,1.00,'Factura A N°: 0001-00000570',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(187,7532,2,40720,40855,13,1524,1,0,'2022-07-12',1500000.00,1,1.00,'Factura A N°: 0001-00000571',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(188,7532,2,40720,40853,13,1524,1,0,'2022-07-12',470000.00,1,1.00,'Factura A N°: 0001-00000572',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12'),(189,7532,2,40720,40853,13,1524,1,0,'2022-07-12',300000.00,1,1.00,'Factura A N°: 0001-00000573',NULL,'2022-08-11 10:27:32','2022-08-11 10:38:12','2022-08-11 10:38:12');
INSERT INTO `cta_cte_cliente` VALUES (190,7532,2,40720,40854,13,1524,1,0,'2022-07-14',984000.00,1,1.00,'Factura A N°: 0001-00000574',NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(191,7532,2,40720,40855,13,1524,1,0,'2022-07-18',1700000.00,1,1.00,'Factura A N°: 0001-00000575',NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(192,7532,2,40720,40853,13,1524,1,0,'2022-07-19',1100000.00,1,1.00,'Factura A N°: 0001-00000576',NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(193,7532,2,40720,40851,13,1524,1,0,'2022-07-21',2700000.00,1,1.00,'Factura A N°: 0001-00000577',NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(194,7532,2,40720,40853,13,1524,1,0,'2022-07-27',700000.00,1,1.00,'Factura A N°: 0001-00000578',NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(195,7532,2,40720,40853,13,1524,1,0,'2022-07-27',620000.01,1,1.00,'Factura A N°: 0001-00000579',NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(196,7532,2,40720,40854,13,1524,1,0,'2022-07-29',984000.00,1,1.00,'Factura A N°: 0001-00000580',NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(197,7532,2,40720,40853,13,1524,1,0,'2022-07-29',1070000.00,1,1.00,'Factura A N°: 0001-00000581',NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(198,7532,2,40720,40854,13,1524,1,0,'2022-07-31',600000.00,1,1.00,'Factura A N°: 0001-00000582',NULL,'2022-08-11 10:27:33','2022-08-11 10:38:12','2022-08-11 10:38:12'),(199,7532,2,40720,40846,13,1524,1,0,'2022-07-01',520000.00,1,1.00,'Factura A N°: 0001-00000556',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(200,7532,2,40720,40847,13,1524,1,0,'2022-07-01',504000.00,1,1.00,'Factura A N°: 0001-00000557',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(201,7532,2,40720,40848,13,1524,1,0,'2022-07-01',510000.00,1,1.00,'Factura A N°: 0001-00000558',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(202,7532,2,40720,40849,13,1524,1,0,'2022-07-01',950000.00,1,1.00,'Factura A N°: 0001-00000559',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(203,7532,2,40720,40850,13,1524,1,0,'2022-07-01',1600000.00,1,1.00,'Factura A N°: 0001-00000560',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(204,7532,2,40720,40850,13,1524,1,0,'2022-07-01',500000.00,1,1.00,'Factura A N°: 0001-00000561',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(205,7532,2,40720,40850,13,1524,1,0,'2022-07-01',2500000.00,1,1.00,'Factura A N°: 0001-00000562',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(206,7532,2,40720,40851,13,1524,1,0,'2022-07-04',1740000.00,1,1.00,'Factura A N°: 0001-00000563',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(207,7532,2,40720,40851,13,1524,1,0,'2022-07-04',720000.00,1,1.00,'Factura A N°: 0001-00000564',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(208,7532,2,40720,40852,13,1524,1,0,'2022-07-05',289379.51,1,1.00,'Factura A N°: 0001-00000565',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(209,7532,2,40720,40852,13,1524,1,0,'2022-07-05',9102372.70,1,1.00,'Factura A N°: 0001-00000566',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(210,7532,2,40720,40853,13,1524,1,0,'2022-07-06',720000.00,1,1.00,'Factura A N°: 0001-00000567',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(211,7532,2,40720,40853,13,1524,1,0,'2022-07-06',720000.00,1,1.00,'Factura A N°: 0001-00000568',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(212,7532,2,40720,40854,13,1524,1,0,'2022-07-06',984000.00,1,1.00,'Factura A N°: 0001-00000569',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24');
INSERT INTO `cta_cte_cliente` VALUES (213,7532,2,40720,40855,13,1524,1,0,'2022-07-06',1700000.00,1,1.00,'Factura A N°: 0001-00000570',NULL,'2022-08-11 10:38:43','2022-08-11 10:42:24','2022-08-11 10:42:24'),(214,7532,2,40720,40855,13,1524,1,0,'2022-07-12',1500000.00,1,1.00,'Factura A N°: 0001-00000571',NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(215,7532,2,40720,40853,13,1524,1,0,'2022-07-12',470000.00,1,1.00,'Factura A N°: 0001-00000572',NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(216,7532,2,40720,40853,13,1524,1,0,'2022-07-12',300000.00,1,1.00,'Factura A N°: 0001-00000573',NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(217,7532,2,40720,40854,13,1524,1,0,'2022-07-14',984000.00,1,1.00,'Factura A N°: 0001-00000574',NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(218,7532,2,40720,40855,13,1524,1,0,'2022-07-18',1700000.00,1,1.00,'Factura A N°: 0001-00000575',NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(219,7532,2,40720,40853,13,1524,1,0,'2022-07-19',1100000.00,1,1.00,'Factura A N°: 0001-00000576',NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(220,7532,2,40720,40851,13,1524,1,0,'2022-07-21',2700000.00,1,1.00,'Factura A N°: 0001-00000577',NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(221,7532,2,40720,40853,13,1524,1,0,'2022-07-27',700000.00,1,1.00,'Factura A N°: 0001-00000578',NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(222,7532,2,40720,40853,13,1524,1,0,'2022-07-27',620000.01,1,1.00,'Factura A N°: 0001-00000579',NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(223,7532,2,40720,40854,13,1524,1,0,'2022-07-29',984000.00,1,1.00,'Factura A N°: 0001-00000580',NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(224,7532,2,40720,40853,13,1524,1,0,'2022-07-29',1070000.00,1,1.00,'Factura A N°: 0001-00000581',NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(225,7532,2,40720,40854,13,1524,1,0,'2022-07-31',600000.00,1,1.00,'Factura A N°: 0001-00000582',NULL,'2022-08-11 10:38:44','2022-08-11 10:42:24','2022-08-11 10:42:24'),(226,7532,3,40720,40721,57,1524,2,0,'2022-07-01',55000.00,1,1.00,'Factura C N°: 0002-00000009',NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(227,7532,3,40720,40722,57,1524,2,0,'2022-07-01',549999.99,1,1.00,'Factura A N°: 0003-00000039',NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(228,7532,3,40720,40722,57,1524,2,0,'2022-07-01',549999.99,1,1.00,'Factura A N°: 0003-00000040',NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(229,7532,3,40720,40723,57,1524,2,0,'2022-07-01',55000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(230,7532,3,40720,40724,57,1524,2,0,'2022-07-01',55000.00,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(231,7532,3,40720,40725,57,1524,2,0,'2022-07-01',35000.00,1,1.00,'Factura C N°: 0002-00000004',NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(232,7532,3,40720,40726,57,1524,2,0,'2022-07-01',3900.00,1,1.00,'Factura A N°: 0005-00005200',NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(233,7532,3,40720,40727,57,1524,2,0,'2022-07-01',18150.07,1,1.00,'Factura A N°: 0006-00001171',NULL,'2022-08-11 10:42:55','2022-08-11 10:42:55',NULL),(234,7532,3,40720,40728,57,1524,2,0,'2022-07-01',150000.00,1,1.00,'Factura C N°: 0002-00000173',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(235,7532,3,40720,40729,57,1524,2,0,'2022-07-01',1953389.97,1,1.00,'Factura A N°: 0003-00000317',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(236,7532,3,40720,40729,57,1524,2,0,'2022-07-01',221000.00,1,1.00,'Factura A N°: 0003-00000318',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(237,7532,3,40720,40730,57,1524,2,0,'2022-07-01',15064.50,1,1.00,'Factura A N°: 0001-00000389',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL);
INSERT INTO `cta_cte_cliente` VALUES (238,7532,3,40720,40731,57,1524,2,0,'2022-07-01',35000.00,1,1.00,'Factura C N°: 0001-00000004',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(239,7532,3,40720,40732,57,1524,2,0,'2022-07-01',60000.00,1,1.00,'Factura C N°: 0001-00000027',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(240,7532,3,40720,40733,57,1524,2,0,'2022-07-01',55000.00,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(241,7532,3,40720,40734,57,1524,2,0,'2022-07-01',35000.00,1,1.00,'Factura C N°: 0001-00000004',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(242,7532,3,40720,40735,57,1524,2,0,'2022-07-01',100000.00,1,1.00,'Factura C N°: 0002-00000003',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(243,7532,3,40720,40736,57,1524,2,0,'2022-07-01',6050.00,1,1.00,'Factura A N°: 0001-00000426',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(244,7532,3,40720,40737,57,1524,2,0,'2022-07-01',55000.00,1,1.00,'Factura C N°: 0003-00000009',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(245,7532,3,40720,40738,57,1524,2,0,'2022-07-01',55000.00,1,1.00,'Factura C N°: 0002-00000005',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(246,7532,3,40720,40730,57,1524,2,0,'2022-07-02',9471.01,1,1.00,'Factura A N°: 0001-00000396',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(247,7532,3,40720,40739,57,1524,2,0,'2022-07-04',168000.00,1,1.00,'Factura C N°: 0003-00000067',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(248,7532,3,40720,40739,57,1524,2,0,'2022-07-04',408000.00,1,1.00,'Factura C N°: 0003-00000068',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(249,7532,3,40720,40740,57,1524,2,0,'2022-07-05',30000.00,1,1.00,'Factura C N°: 0001-00000005',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(250,7532,3,40720,40741,57,1524,2,0,'2022-07-05',13100.00,1,1.00,'Factura A N°: 0027-00004080',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(251,7532,3,40720,40742,57,1524,2,0,'2022-07-05',75000.00,1,1.00,'Factura C N°: 0001-00000005',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(252,7532,3,40720,40743,57,1524,2,0,'2022-07-05',25000.00,1,1.00,'Factura C N°: 0001-00000004',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(253,7532,3,40720,40726,57,1524,2,0,'2022-07-05',14233.16,1,1.00,'Factura A N°: 0005-00005228',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(254,7532,3,40720,40744,57,1524,2,0,'2022-07-05',40000.00,1,1.00,'Factura C N°: 0001-00000199',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(255,7532,3,40720,40745,57,1524,2,0,'2022-07-05',75000.00,1,1.00,'Factura C N°: 0001-00000037',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(256,7532,3,40720,40746,57,1524,2,0,'2022-07-05',40000.00,1,1.00,'Factura C N°: 0001-00000092',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(257,7532,3,40720,40727,57,1524,2,0,'2022-07-05',1810.00,1,1.00,'Factura A N°: 0006-00001188',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(258,7532,3,40720,40747,57,1524,2,0,'2022-07-05',25000.00,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(259,7532,3,40720,40748,57,1524,2,0,'2022-07-05',30000.00,1,1.00,'Factura C N°: 0001-00000006',NULL,'2022-08-11 10:42:56','2022-08-11 10:42:56',NULL),(260,7532,3,40720,40749,57,1524,2,0,'2022-07-05',30000.00,1,1.00,'Factura C N°: 0001-00000004',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(261,7532,3,40720,40750,57,1524,2,0,'2022-07-05',12360.00,1,1.00,'Factura A N°: 0009-00005093',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(262,7532,3,40720,40751,57,1524,2,0,'2022-07-05',50000.00,1,1.00,'Factura C N°: 0001-00000016',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(263,7532,3,40720,40728,57,1524,2,0,'2022-07-05',60000.00,1,1.00,'Factura C N°: 0002-00000174',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL);
INSERT INTO `cta_cte_cliente` VALUES (264,7532,3,40720,40752,57,1524,2,0,'2022-07-05',372680.00,1,1.00,'Factura A N°: 0001-00000038',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(265,7532,3,40720,40753,57,1524,2,0,'2022-07-05',25000.00,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(266,7532,3,40720,40754,57,1524,2,0,'2022-07-05',65000.00,1,1.00,'Factura C N°: 0001-00000007',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(267,7532,3,40720,40755,57,1524,2,0,'2022-07-05',70000.00,1,1.00,'Factura C N°: 0002-00000370',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(268,7532,3,40720,40756,57,1524,2,0,'2022-07-05',65000.00,1,1.00,'Factura C N°: 0001-00000001',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(269,7532,3,40720,40757,57,1524,2,0,'2022-07-05',75000.00,1,1.00,'Factura C N°: 0001-00000007',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(270,7532,3,40720,40758,57,1524,2,0,'2022-07-05',50000.00,1,1.00,'Factura C N°: 0001-00000001',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(271,7532,3,40720,40759,57,1524,2,0,'2022-07-05',50000.00,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(272,7532,3,40720,40760,57,1524,2,0,'2022-07-05',393144.00,1,1.00,'Factura A N°: 0001-00000006',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(273,7532,3,40720,40761,57,1524,2,0,'2022-07-05',75000.00,1,1.00,'Factura C N°: 0002-00000005',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(274,7532,3,40720,40762,57,1524,2,0,'2022-07-06',273460.00,1,1.00,'Factura A N°: 0003-00001034',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(275,7532,3,40720,40763,57,1524,2,0,'2022-07-06',60000.00,1,1.00,'Factura C N°: 0001-00000001',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(276,7532,3,40720,40764,57,1524,2,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(277,7532,3,40720,40765,57,1524,2,0,'2022-07-06',35000.00,1,1.00,'Factura C N°: 0001-00000012',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(278,7532,3,40720,40766,57,1524,2,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0002-00000010',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(279,7532,3,40720,40767,57,1524,2,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000012',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(280,7532,3,40720,40768,57,1524,2,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000012',NULL,'2022-08-11 10:42:57','2022-08-11 10:42:57',NULL),(281,7532,3,40720,40769,57,1524,2,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000012',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(282,7532,3,40720,40770,57,1524,2,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0002-00000011',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(283,7532,3,40720,40771,57,1524,2,0,'2022-07-06',5685.75,1,1.00,'Factura A N°: 0001-00009491',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(284,7532,3,40720,40771,57,1524,2,0,'2022-07-06',43861.51,1,1.00,'Factura A N°: 0001-00009490',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(285,7532,3,40720,40772,57,1524,2,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(286,7532,3,40720,40773,57,1524,2,0,'2022-07-06',7500.00,1,1.00,'Factura C N°: 0002-00000237',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(287,7532,3,40720,40774,57,1524,2,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000012',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(288,7532,3,40720,40775,57,1524,2,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000012',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(289,7532,3,40720,40776,57,1524,2,0,'2022-07-06',1300.00,1,1.00,'Factura A N°: 0005-00000077',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL);
INSERT INTO `cta_cte_cliente` VALUES (290,7532,3,40720,40777,57,1524,2,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(291,7532,3,40720,40778,57,1524,2,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(292,7532,3,40720,40779,57,1524,2,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(293,7532,3,40720,40780,57,1524,2,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(294,7532,3,40720,40776,57,1524,2,0,'2022-07-06',1370.00,1,1.00,'Factura A N°: 0005-00000073',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(295,7532,3,40720,40781,57,1524,2,0,'2022-07-06',2250.12,1,1.00,'Factura A N°: 0007-00009011',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(296,7532,3,40720,40782,57,1524,2,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0002-00000009',NULL,'2022-08-11 10:42:58','2022-08-11 10:42:58',NULL),(297,7532,3,40720,40783,57,1524,2,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(298,7532,3,40720,40784,57,1524,2,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(299,7532,3,40720,40785,57,1524,2,0,'2022-07-06',35000.00,1,1.00,'Factura C N°: 0003-00000012',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(300,7532,3,40720,40786,57,1524,2,0,'2022-07-06',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(301,7532,3,40720,40787,57,1524,2,0,'2022-07-06',25000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(302,7532,3,40720,40762,57,1524,2,0,'2022-07-07',353925.00,1,1.00,'Factura A N°: 0003-00001036',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(303,7532,3,40720,40788,57,1524,2,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(304,7532,3,40720,40789,57,1524,2,0,'2022-07-07',26531.40,1,1.00,'Factura A N°: 0015-00004838',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(305,7532,3,40720,40790,57,1524,2,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000006',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(306,7532,3,40720,40791,57,1524,2,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(307,7532,3,40720,40792,57,1524,2,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(308,7532,3,40720,40727,57,1524,2,0,'2022-07-07',7699.99,1,1.00,'Factura A N°: 0006-00001206',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(309,7532,3,40720,40793,57,1524,2,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(310,7532,3,40720,40794,57,1524,2,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(311,7532,3,40720,40795,57,1524,2,0,'2022-07-07',5000.00,1,1.00,'Factura C N°: 0001-00000105',NULL,'2022-08-11 10:42:59','2022-08-11 10:42:59',NULL),(312,7532,3,40720,40732,57,1524,2,0,'2022-07-07',360000.00,1,1.00,'Factura C N°: 0001-00000028',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(313,7532,3,40720,40796,57,1524,2,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000009',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(314,7532,3,40720,40797,57,1524,2,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(315,7532,3,40720,40798,57,1524,2,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000008',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL);
INSERT INTO `cta_cte_cliente` VALUES (316,7532,3,40720,40799,57,1524,1,0,'2022-07-07',25000.00,1,1.00,'Nota de crédito C N°: 0001-00000001',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(317,7532,3,40720,40799,57,1524,2,0,'2022-07-07',25000.00,1,1.00,'Factura C N°: 0001-00000004',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(318,7532,3,40720,40800,57,1524,2,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0002-00000011',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(319,7532,3,40720,40801,57,1524,2,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000009',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(320,7532,3,40720,40802,57,1524,2,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(321,7532,3,40720,40803,57,1524,2,0,'2022-07-07',20000.00,1,1.00,'Factura C N°: 0001-00000011',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(322,7532,3,40720,40804,57,1524,2,0,'2022-07-07',35000.00,1,1.00,'Factura C N°: 0001-00000001',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(323,7532,3,40720,40805,57,1524,2,0,'2022-07-08',100000.00,1,1.00,'Factura C N°: 0001-00000085',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(324,7532,3,40720,40806,57,1524,2,0,'2022-07-08',261900.00,1,1.00,'Factura C N°: 0003-00000278',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(325,7532,3,40720,40762,57,1524,2,0,'2022-07-11',250107.00,1,1.00,'Factura A N°: 0003-00001039',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(326,7532,3,40720,40807,57,1524,2,0,'2022-07-11',50000.00,1,1.00,'Factura C N°: 0001-00000076',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(327,7532,3,40720,40808,57,1524,2,0,'2022-07-11',173750.00,1,1.00,'Factura A N°: 0002-00000149',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(328,7532,3,40720,40809,57,1524,2,0,'2022-07-11',140000.00,1,1.00,'Factura C N°: 0002-00000044',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(329,7532,3,40720,40810,57,1524,2,0,'2022-07-11',50000.00,1,1.00,'Factura C N°: 0001-00000076',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(330,7532,3,40720,40811,57,1524,2,0,'2022-07-11',50000.00,1,1.00,'Factura C N°: 0001-00000080',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(331,7532,3,40720,40812,57,1524,2,0,'2022-07-11',41000.00,1,1.00,'Factura C N°: 0001-00000080',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(332,7532,3,40720,40813,57,1524,2,0,'2022-07-11',50000.00,1,1.00,'Factura C N°: 0002-00000059',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(333,7532,3,40720,40814,57,1524,2,0,'2022-07-11',20000.00,1,1.00,'Factura C N°: 0001-00000010',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(334,7532,3,40720,40815,57,1524,2,0,'2022-07-11',50000.00,1,1.00,'Factura C N°: 0001-00000060',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(335,7532,3,40720,40799,57,1524,2,0,'2022-07-11',50000.00,1,1.00,'Factura C N°: 0001-00000005',NULL,'2022-08-11 10:43:00','2022-08-11 10:43:00',NULL),(336,7532,3,40720,40816,57,1524,2,0,'2022-07-11',48000.00,1,1.00,'Factura C N°: 0001-00000002',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(337,7532,3,40720,40817,57,1524,2,0,'2022-07-11',196000.00,1,1.00,'Factura A N°: 0002-00000018',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(338,7532,3,40720,40818,57,1524,2,0,'2022-07-11',82000.00,1,1.00,'Factura C N°: 0001-00000081',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(339,7532,3,40720,40762,57,1524,2,0,'2022-07-12',384780.00,1,1.00,'Factura A N°: 0003-00001045',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(340,7532,3,40720,40726,57,1524,2,0,'2022-07-12',4099.99,1,1.00,'Factura A N°: 0005-00005275',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(341,7532,3,40720,40819,57,1524,2,0,'2022-07-12',2178000.00,1,1.00,'Factura A N°: 0004-00000001',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL);
INSERT INTO `cta_cte_cliente` VALUES (342,7532,3,40720,40727,57,1524,2,0,'2022-07-12',18170.03,1,1.00,'Factura A N°: 0006-00001229',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(343,7532,3,40720,40820,57,1524,2,0,'2022-07-12',1800.00,1,1.00,'Factura C N°: 0002-00000486',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(344,7532,3,40720,40776,57,1524,2,0,'2022-07-12',2480.00,1,1.00,'Factura A N°: 0005-00000113',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(345,7532,3,40720,40776,57,1524,2,0,'2022-07-12',1450.00,1,1.00,'Factura A N°: 0005-00000112',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(346,7532,3,40720,40821,57,1524,2,0,'2022-07-13',609.92,1,1.00,'Factura A N°: 0009-00001119',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(347,7532,3,40720,40762,57,1524,2,0,'2022-07-13',365420.00,1,1.00,'Factura A N°: 0003-00001047',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(348,7532,3,40720,40789,57,1524,2,0,'2022-07-13',34765.30,1,1.00,'Factura A N°: 0015-00004854',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(349,7532,3,40720,40822,57,1524,1,0,'2022-07-13',178000.00,1,1.00,'Nota de crédito A N°: 0003-00000003',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(350,7532,3,40720,40727,57,1524,2,0,'2022-07-13',250.29,1,1.00,'Factura A N°: 0006-00001232',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(351,7532,3,40720,40822,57,1524,2,0,'2022-07-13',178000.00,1,1.00,'Factura A N°: 0003-00000269',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(352,7532,3,40720,40773,57,1524,2,0,'2022-07-13',21400.00,1,1.00,'Factura C N°: 0002-00000238',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(353,7532,3,40720,40823,57,1524,2,0,'2022-07-13',50000.00,1,1.00,'Factura C N°: 0001-00000001',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(354,7532,3,40720,40824,57,1524,2,0,'2022-07-14',24600.00,1,1.00,'Factura C N°: 0001-00000028',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(355,7532,3,40720,40824,57,1524,2,0,'2022-07-14',60000.00,1,1.00,'Factura C N°: 0001-00000027',NULL,'2022-08-11 10:43:01','2022-08-11 10:43:01',NULL),(356,7532,3,40720,40825,57,1524,2,0,'2022-07-14',270000.00,1,1.00,'Factura C N°: 0005-00000017',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(357,7532,3,40720,40825,57,1524,2,0,'2022-07-14',35000.00,1,1.00,'Factura C N°: 0006-00000013',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(358,7532,3,40720,40821,57,1524,2,0,'2022-07-15',5641.73,1,1.00,'Factura A N°: 0009-00001121',NULL,'2022-08-11 10:43:02','2022-08-11 11:56:10','2022-08-11 11:56:10'),(359,7532,3,40720,40826,57,1524,2,0,'2022-07-15',1750.00,1,1.00,'Factura A N°: 0005-00000050',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(360,7532,3,40720,40808,57,1524,2,0,'2022-07-18',1210000.00,1,1.00,'Factura A N°: 0002-00000151',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(361,7532,3,40720,40799,57,1524,2,0,'2022-07-18',100000.00,1,1.00,'Factura C N°: 0001-00000006',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(362,7532,3,40720,40827,57,1524,2,0,'2022-07-19',2800.00,1,1.00,'RECIBO C N°: 0006-00015661',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(363,7532,3,40720,40750,57,1524,2,0,'2022-07-19',12600.00,1,1.00,'Factura A N°: 0009-00005262',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(364,7532,3,40720,40828,57,1524,2,0,'2022-07-19',400.00,1,1.00,'Factura C N°: 0001-00000094',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(365,7532,3,40720,40805,57,1524,2,0,'2022-07-20',200000.00,1,1.00,'Factura C N°: 0001-00000086',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(366,7532,3,40720,40829,57,1524,2,0,'2022-07-20',110000.00,1,1.00,'Factura A N°: 0003-00000039',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(367,7532,3,40720,40830,57,1524,2,0,'2022-07-20',5000.00,1,1.00,'Factura C N°: 0002-00000084',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL);
INSERT INTO `cta_cte_cliente` VALUES (368,7532,3,40720,40831,57,1524,2,0,'2022-07-21',200000.00,1,1.00,'RECIBO C N°: 0001-00000213',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(369,7532,3,40720,40832,57,1524,2,0,'2022-07-22',186000.04,1,1.00,'Factura A N°: 0001-00002416',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(370,7532,3,40720,40789,57,1524,2,0,'2022-07-22',36900.00,1,1.00,'Factura A N°: 0015-00004879',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(371,7532,3,40720,40727,57,1524,2,0,'2022-07-22',15470.01,1,1.00,'Factura A N°: 0006-00001361',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(372,7532,3,40720,40833,57,1524,2,0,'2022-07-22',32689.00,1,1.00,'Factura A N°: 0001-00011426',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(373,7532,3,40720,40833,57,1524,2,0,'2022-07-22',32689.00,1,1.00,'Factura A N°: 0001-00011427',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(374,7532,3,40720,40834,57,1524,2,0,'2022-07-23',2000.00,1,1.00,'RECIBO A N°: 0001-00001828',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(375,7532,3,40720,40799,57,1524,2,0,'2022-07-23',70000.00,1,1.00,'Factura C N°: 0001-00000007',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(376,7532,3,40720,40835,57,1524,2,0,'2022-07-25',34002.17,1,1.00,'Factura A N°: 0010-00000465',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(377,7532,3,40720,40727,57,1524,2,0,'2022-07-25',1790.00,1,1.00,'Factura A N°: 0006-00001384',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(378,7532,3,40720,40836,57,1524,2,0,'2022-07-25',2700.00,1,1.00,'Factura A N°: 8364-00004325',NULL,'2022-08-11 10:43:02','2022-08-11 10:43:02',NULL),(379,7532,3,40720,40776,57,1524,2,0,'2022-07-25',1200.00,1,1.00,'Factura A N°: 0005-00000177',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(380,7532,3,40720,40726,57,1524,2,0,'2022-07-26',18333.15,1,1.00,'Factura A N°: 0005-00005377',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(381,7532,3,40720,40727,57,1524,2,0,'2022-07-26',9019.98,1,1.00,'Factura A N°: 0006-00001413',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(382,7532,3,40720,40727,57,1524,2,0,'2022-07-26',33779.97,1,1.00,'Factura A N°: 0006-00001437',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(383,7532,3,40720,40837,57,1524,2,0,'2022-07-26',15000.00,1,1.00,'Factura C N°: 0002-00000237',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(384,7532,3,40720,40729,57,1524,2,0,'2022-07-26',600000.00,1,1.00,'Factura A N°: 0003-00000320',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(385,7532,3,40720,40838,57,1524,2,0,'2022-07-27',160415.10,1,1.00,'Factura C N°: 0001-00000003',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(386,7532,3,40720,40839,57,1524,2,0,'2022-07-27',1500.00,1,1.00,'Factura C N°: 0003-00000159',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(387,7532,3,40720,40741,57,1524,2,0,'2022-07-28',87790.15,1,1.00,'Factura A N°: 0027-00004224',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(388,7532,3,40720,40840,57,1524,2,0,'2022-07-28',11794.95,1,1.00,'Factura A N°: 0014-00023157',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(389,7532,3,40720,40841,57,1524,2,0,'2022-07-29',400000.00,1,1.00,'Factura A N°: 0006-00000194',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(390,7532,3,40720,40842,57,1524,2,0,'2022-07-29',1499.99,1,1.00,'Factura A N°: 0008-00024246',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(391,7532,3,40720,40727,57,1524,2,0,'2022-07-29',8969.98,1,1.00,'Factura A N°: 0006-00001506',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(392,7532,3,40720,40843,57,1524,2,0,'2022-07-29',10701.62,1,1.00,'Factura A N°: 0009-00010456',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(393,7532,3,40720,40808,57,1524,2,0,'2022-07-30',1210000.00,1,1.00,'Factura A N°: 0002-00000154',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL);
INSERT INTO `cta_cte_cliente` VALUES (394,7532,3,40720,40844,57,1524,2,0,'2022-07-30',60000.00,1,1.00,'Factura C N°: 0001-00000057',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(395,7532,3,40720,40799,57,1524,2,0,'2022-07-30',50000.00,1,1.00,'Factura C N°: 0001-00000008',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(396,7532,3,40720,40845,57,1524,2,0,'2022-07-31',190000.00,1,1.00,'Factura C N°: 0001-00000002',NULL,'2022-08-11 10:43:03','2022-08-11 10:43:03',NULL),(397,7532,2,40720,40846,13,1524,1,0,'2022-07-01',520000.00,1,1.00,'Factura A N°: 0001-00000556',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(398,7532,2,40720,40847,13,1524,1,0,'2022-07-01',504000.00,1,1.00,'Factura A N°: 0001-00000557',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(399,7532,2,40720,40848,13,1524,1,0,'2022-07-01',510000.00,1,1.00,'Factura A N°: 0001-00000558',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(400,7532,2,40720,40849,13,1524,1,0,'2022-07-01',950000.00,1,1.00,'Factura A N°: 0001-00000559',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(401,7532,2,40720,40850,13,1524,1,0,'2022-07-01',1600000.00,1,1.00,'Factura A N°: 0001-00000560',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(402,7532,2,40720,40850,13,1524,1,0,'2022-07-01',500000.00,1,1.00,'Factura A N°: 0001-00000561',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(403,7532,2,40720,40850,13,1524,1,0,'2022-07-01',2500000.00,1,1.00,'Factura A N°: 0001-00000562',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(404,7532,2,40720,40851,13,1524,1,0,'2022-07-04',1740000.00,1,1.00,'Factura A N°: 0001-00000563',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(405,7532,2,40720,40851,13,1524,1,0,'2022-07-04',720000.00,1,1.00,'Factura A N°: 0001-00000564',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(406,7532,2,40720,40852,13,1524,1,0,'2022-07-05',289379.51,1,1.00,'Factura A N°: 0001-00000565',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(407,7532,2,40720,40852,13,1524,1,0,'2022-07-05',9102372.70,1,1.00,'Factura A N°: 0001-00000566',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(408,7532,2,40720,40853,13,1524,1,0,'2022-07-06',720000.00,1,1.00,'Factura A N°: 0001-00000567',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(409,7532,2,40720,40853,13,1524,1,0,'2022-07-06',720000.00,1,1.00,'Factura A N°: 0001-00000568',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(410,7532,2,40720,40854,13,1524,1,0,'2022-07-06',984000.00,1,1.00,'Factura A N°: 0001-00000569',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(411,7532,2,40720,40855,13,1524,1,0,'2022-07-06',1700000.00,1,1.00,'Factura A N°: 0001-00000570',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(412,7532,2,40720,40855,13,1524,1,0,'2022-07-12',1500000.00,1,1.00,'Factura A N°: 0001-00000571',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(413,7532,2,40720,40853,13,1524,1,0,'2022-07-12',470000.00,1,1.00,'Factura A N°: 0001-00000572',NULL,'2022-08-11 11:48:18','2022-08-12 11:03:47','2022-08-12 11:03:47'),(414,7532,2,40720,40853,13,1524,1,0,'2022-07-12',300000.00,1,1.00,'Factura A N°: 0001-00000573',NULL,'2022-08-11 11:48:19','2022-08-12 11:03:47','2022-08-12 11:03:47'),(415,7532,2,40720,40854,13,1524,1,0,'2022-07-14',984000.00,1,1.00,'Factura A N°: 0001-00000574',NULL,'2022-08-11 11:48:19','2022-08-12 11:03:47','2022-08-12 11:03:47'),(416,7532,2,40720,40855,13,1524,1,0,'2022-07-18',1700000.00,1,1.00,'Factura A N°: 0001-00000575',NULL,'2022-08-11 11:48:19','2022-08-12 11:03:47','2022-08-12 11:03:47'),(417,7532,2,40720,40853,13,1524,1,0,'2022-07-19',1100000.00,1,1.00,'Factura A N°: 0001-00000576',NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48');
INSERT INTO `cta_cte_cliente` VALUES (418,7532,2,40720,40851,13,1524,1,0,'2022-07-21',2700000.00,1,1.00,'Factura A N°: 0001-00000577',NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(419,7532,2,40720,40853,13,1524,1,0,'2022-07-27',700000.00,1,1.00,'Factura A N°: 0001-00000578',NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(420,7532,2,40720,40853,13,1524,1,0,'2022-07-27',620000.01,1,1.00,'Factura A N°: 0001-00000579',NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(421,7532,2,40720,40854,13,1524,1,0,'2022-07-29',984000.00,1,1.00,'Factura A N°: 0001-00000580',NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(422,7532,2,40720,40853,13,1524,1,0,'2022-07-29',1070000.00,1,1.00,'Factura A N°: 0001-00000581',NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(423,7532,2,40720,40854,13,1524,1,0,'2022-07-31',600000.00,1,1.00,'Factura A N°: 0001-00000582',NULL,'2022-08-11 11:48:19','2022-08-12 11:03:48','2022-08-12 11:03:48'),(424,7532,3,40720,40821,57,1524,2,0,'2022-07-15',5641.73,1,1.00,'Factura A N°: 0009-00001121',NULL,'2022-08-11 11:56:10','2022-08-11 11:56:10',NULL),(425,7532,2,40720,40853,13,1518,1,0,'2022-01-05',600000.00,1,1.00,'Factura A N°: 0001-00000415',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(426,7532,2,40720,40853,13,1518,1,0,'2022-01-05',600000.00,1,1.00,'Factura A N°: 0001-00000416',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(427,7532,2,40720,40846,13,1518,1,0,'2022-01-05',330000.00,1,1.00,'Factura A N°: 0001-00000417',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(428,7532,2,40720,40848,13,1518,1,0,'2022-01-05',320000.00,1,1.00,'Factura A N°: 0001-00000418',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(429,7532,2,40720,40849,13,1518,1,0,'2022-01-05',500000.00,1,1.00,'Factura A N°: 0001-00000419',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(430,7532,2,40720,40851,13,1518,1,0,'2022-01-07',550000.01,1,1.00,'Factura A N°: 0001-00000420',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(431,7532,2,40720,40851,13,1518,1,0,'2022-01-07',550000.01,1,1.00,'Factura A N°: 0001-00000421',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(432,7532,2,40720,40851,13,1518,1,0,'2022-01-07',1100000.00,1,1.00,'Factura A N°: 0001-00000422',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(433,7532,2,40720,40851,13,1518,1,0,'2022-01-07',2000000.00,1,1.00,'Factura A N°: 0001-00000423',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(434,7532,2,40720,40854,13,1518,1,0,'2022-01-07',2000000.00,1,1.00,'Factura A N°: 0001-00000424',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(435,7532,2,40720,40853,13,1518,1,0,'2022-01-10',450000.00,1,1.00,'Factura A N°: 0001-00000425',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(436,7532,2,40720,40854,13,1518,1,0,'2022-01-12',600000.00,1,1.00,'Factura A N°: 0001-00000426',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(437,7532,2,40720,40856,13,1518,1,0,'2022-01-13',670000.00,1,1.00,'Factura A N°: 0001-00000427',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(438,7532,2,40720,40850,13,1518,1,0,'2022-01-17',1000000.00,1,1.00,'Factura A N°: 0001-00000428',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(439,7532,2,40720,40850,13,1518,1,0,'2022-01-17',1000000.00,1,1.00,'Factura A N°: 0001-00000429',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(440,7532,2,40720,40847,13,1518,1,0,'2022-01-17',475000.00,1,1.00,'Factura A N°: 0001-00000430',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(441,7532,2,40720,40853,13,1518,1,0,'2022-01-19',685000.00,1,1.00,'Factura A N°: 0001-00000431',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(442,7532,2,40720,40853,13,1518,1,0,'2022-01-24',400000.00,1,1.00,'Factura A N°: 0001-00000432',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL);
INSERT INTO `cta_cte_cliente` VALUES (443,7532,2,40720,40851,13,1518,1,0,'2022-01-26',600000.00,1,1.00,'Factura A N°: 0001-00000433',NULL,'2022-08-12 09:28:08','2022-08-12 09:28:08',NULL),(444,7532,2,40720,40853,13,1518,1,0,'2022-01-26',450000.00,1,1.00,'Factura A N°: 0001-00000434',NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(445,7532,2,40720,40853,13,1518,1,0,'2022-01-26',450000.00,1,1.00,'Factura A N°: 0001-00000435',NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(446,7532,2,40720,40850,13,1518,1,0,'2022-01-28',2000000.00,1,1.00,'Factura A N°: 0001-00000436',NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(447,7532,2,40720,40850,13,1518,1,0,'2022-01-28',280000.00,1,1.00,'Factura A N°: 0001-00000437',NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(448,7532,2,40720,40853,13,1518,1,0,'2022-01-28',180000.00,1,1.00,'Factura A N°: 0001-00000438',NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(449,7532,2,40720,40853,13,1518,1,0,'2022-01-28',300000.01,1,1.00,'Factura A N°: 0001-00000439',NULL,'2022-08-12 09:28:09','2022-08-12 09:28:09',NULL),(450,7532,2,40720,40853,13,1519,1,0,'2022-02-02',600000.00,1,1.00,'Factura A N°: 0001-00000440',NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(451,7532,2,40720,40853,13,1519,1,0,'2022-02-02',600000.00,1,1.00,'Factura A N°: 0001-00000441',NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(452,7532,2,40720,40853,13,1519,1,0,'2022-02-07',585000.01,1,1.00,'Factura A N°: 0001-00000442',NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(453,7532,2,40720,40854,13,1519,1,0,'2022-02-07',710000.00,1,1.00,'Factura A N°: 0001-00000443',NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(454,7532,2,40720,40851,13,1519,1,0,'2022-02-09',720000.00,1,1.00,'Factura A N°: 0001-00000444',NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(455,7532,2,40720,40851,13,1519,1,0,'2022-02-09',720000.00,1,1.00,'Factura A N°: 0001-00000445',NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(456,7532,2,40720,40851,13,1519,1,0,'2022-02-09',600000.00,1,1.00,'Factura A N°: 0001-00000446',NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(457,7532,2,40720,40851,13,1519,1,0,'2022-02-09',1450000.00,1,1.00,'Factura A N°: 0001-00000447',NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(458,7532,2,40720,40851,13,1519,1,0,'2022-02-10',2100000.00,1,1.00,'Factura A N°: 0001-00000448',NULL,'2022-08-12 10:25:59','2022-08-12 11:03:48','2022-08-12 11:03:48'),(459,7532,2,40720,40853,13,1519,1,0,'2022-02-15',890000.00,1,1.00,'Factura A N°: 0001-00000449',NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(460,7532,2,40720,40854,13,1519,1,0,'2022-02-15',820000.00,1,1.00,'Factura A N°: 0001-00000450',NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(461,7532,2,40720,40846,13,1519,1,0,'2022-02-15',430000.00,1,1.00,'Factura A N°: 0001-00000451',NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(462,7532,2,40720,40848,13,1519,1,0,'2022-02-15',420000.00,1,1.00,'Factura A N°: 0001-00000452',NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(463,7532,2,40720,40849,13,1519,1,0,'2022-02-15',650000.00,1,1.00,'Factura A N°: 0001-00000453',NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(464,7532,2,40720,40854,13,1519,1,0,'2022-02-22',820000.00,1,1.00,'Factura A N°: 0001-00000454',NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(465,7532,2,40720,40853,13,1519,1,0,'2022-02-22',520000.00,1,1.00,'Factura A N°: 0001-00000455',NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(466,7532,2,40720,40853,13,1519,1,0,'2022-02-24',390000.00,1,1.00,'Factura A N°: 0001-00000456',NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48');
INSERT INTO `cta_cte_cliente` VALUES (467,7532,2,40720,40853,13,1519,1,0,'2022-02-24',250000.00,1,1.00,'Factura A N°: 0001-00000457',NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(468,7532,2,40720,40854,13,1519,1,0,'2022-02-25',600000.00,1,1.00,'Factura A N°: 0001-00000458',NULL,'2022-08-12 10:26:00','2022-08-12 11:03:48','2022-08-12 11:03:48'),(469,7532,2,40720,40853,13,1519,1,0,'2022-02-02',600000.00,1,1.00,'Factura A N°: 0001-00000440',NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(470,7532,2,40720,40853,13,1519,1,0,'2022-02-02',600000.00,1,1.00,'Factura A N°: 0001-00000441',NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(471,7532,2,40720,40853,13,1519,1,0,'2022-02-07',585000.01,1,1.00,'Factura A N°: 0001-00000442',NULL,'2022-08-12 11:32:14','2022-08-12 11:34:21','2022-08-12 11:34:21'),(472,7532,2,40720,40854,13,1519,1,0,'2022-02-07',710000.00,1,1.00,'Factura A N°: 0001-00000443',N