-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db20-94451541-1
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-02-03 19:08:59','Actividad Generica 1','000001',NULL),(2,NULL,'2021-02-03 19:08:59','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'infocompucol@gmail.com','1138245334',NULL,1,40719,'2021-02-03'),(2,'infocompucol@gmail.com','1138245334','',1,40719,'2021-02-03'),(3,'infocompucol@gmail.com','1138245334','',1,40719,'2021-02-03');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18897 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (91,NULL,40719,3,2,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:48:22','2021-02-04 04:48:22',NULL),(92,NULL,40719,3,2,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',70.08,NULL,NULL,1,'2021-02-04 04:48:23','2021-02-04 04:48:23',NULL),(93,NULL,40719,3,2,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',240.00,NULL,NULL,1,'2021-02-04 04:48:24','2021-02-04 04:48:24',NULL),(94,NULL,40719,3,2,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',480.00,NULL,NULL,1,'2021-02-04 04:48:24','2021-02-04 04:48:24',NULL),(95,NULL,40719,3,2,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',384.00,NULL,NULL,1,'2021-02-04 04:48:25','2021-02-04 04:48:25',NULL),(96,NULL,40719,3,2,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',46.56,NULL,NULL,1,'2021-02-04 04:48:26','2021-02-04 04:48:26',NULL),(97,NULL,40719,3,2,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',57.60,NULL,NULL,1,'2021-02-04 04:48:27','2021-02-04 04:48:27',NULL),(98,NULL,40719,3,2,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',129.60,NULL,NULL,1,'2021-02-04 04:48:28','2021-02-04 04:48:28',NULL),(99,NULL,40719,3,2,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',120.00,NULL,NULL,1,'2021-02-04 04:48:28','2021-02-04 04:48:28',NULL),(100,NULL,40719,3,2,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:48:29','2021-02-04 04:48:29',NULL),(101,NULL,40719,3,2,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',24.00,NULL,NULL,1,'2021-02-04 04:48:30','2021-02-04 04:48:30',NULL),(102,NULL,40719,3,2,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',48.00,NULL,NULL,1,'2021-02-04 04:48:31','2021-02-04 04:48:31',NULL),(103,NULL,40719,3,2,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',124.80,NULL,NULL,1,'2021-02-04 04:48:32','2021-02-04 04:48:32',NULL),(104,NULL,40719,3,2,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',67.20,NULL,NULL,1,'2021-02-04 04:48:32','2021-02-04 04:48:32',NULL),(105,NULL,40719,3,2,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:48:33','2021-02-04 04:48:33',NULL),(106,NULL,40719,3,2,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1291.20,NULL,NULL,1,'2021-02-04 04:48:34','2021-02-04 04:48:34',NULL),(107,NULL,40719,3,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:48:35','2021-02-04 04:48:35',NULL),(108,NULL,40719,3,2,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',62.40,NULL,NULL,1,'2021-02-04 04:48:36','2021-02-04 04:48:36',NULL),(109,NULL,40719,3,2,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:48:36','2021-02-04 04:48:36',NULL),(110,NULL,40719,3,2,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2340.00,NULL,NULL,1,'2021-02-04 04:48:37','2021-02-04 04:48:37',NULL),(111,NULL,40719,3,2,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',240.00,NULL,NULL,1,'2021-02-04 04:48:38','2021-02-04 04:48:38',NULL),(112,NULL,40719,3,2,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',240.00,NULL,NULL,1,'2021-02-04 04:48:39','2021-02-04 04:48:39',NULL);
INSERT INTO `balance_libro` VALUES (113,NULL,40719,3,2,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',288.00,NULL,NULL,1,'2021-02-04 04:48:40','2021-02-04 04:48:40',NULL),(114,NULL,40719,3,2,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',48.00,NULL,NULL,1,'2021-02-04 04:48:40','2021-02-04 04:48:40',NULL),(115,NULL,40719,3,2,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:48:41','2021-02-04 04:48:41',NULL),(116,NULL,40719,3,2,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',103.20,NULL,NULL,1,'2021-02-04 04:48:42','2021-02-04 04:48:42',NULL),(117,NULL,40719,3,2,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',100.80,NULL,NULL,1,'2021-02-04 04:48:43','2021-02-04 04:48:43',NULL),(118,NULL,40719,3,2,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2340.00,NULL,NULL,1,'2021-02-04 04:48:43','2021-02-04 04:48:43',NULL),(119,NULL,40719,3,2,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:48:44','2021-02-04 04:48:44',NULL),(120,NULL,40719,3,2,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',288.00,NULL,NULL,1,'2021-02-04 04:48:45','2021-02-04 04:48:45',NULL),(121,NULL,40719,3,2,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:48:46','2021-02-04 04:48:46',NULL),(122,NULL,40719,3,2,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',48.00,NULL,NULL,1,'2021-02-04 04:48:47','2021-02-04 04:48:47',NULL),(123,NULL,40719,3,2,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',288.00,NULL,NULL,1,'2021-02-04 04:48:47','2021-02-04 04:48:47',NULL),(124,NULL,40719,3,2,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',48.00,NULL,NULL,1,'2021-02-04 04:48:48','2021-02-04 04:48:48',NULL),(125,NULL,40719,3,2,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',72.00,NULL,NULL,1,'2021-02-04 04:48:49','2021-02-04 04:48:49',NULL),(126,NULL,40719,3,2,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:48:50','2021-02-04 04:48:50',NULL),(127,NULL,40719,3,2,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',816.00,NULL,NULL,1,'2021-02-04 04:48:51','2021-02-04 04:48:51',NULL),(128,NULL,40719,3,2,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:48:51','2021-02-04 04:48:51',NULL),(129,NULL,40719,3,2,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',240.00,NULL,NULL,1,'2021-02-04 04:48:52','2021-02-04 04:48:52',NULL),(130,NULL,40719,3,2,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:48:53','2021-02-04 04:48:53',NULL),(131,NULL,40719,3,2,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',105.60,NULL,NULL,1,'2021-02-04 04:48:54','2021-02-04 04:48:54',NULL),(132,NULL,40719,3,2,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',48.00,NULL,NULL,1,'2021-02-04 04:48:55','2021-02-04 04:48:55',NULL),(133,NULL,40719,3,2,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',192.00,NULL,NULL,1,'2021-02-04 04:48:55','2021-02-04 04:48:55',NULL),(134,NULL,40719,3,2,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',72.00,NULL,NULL,1,'2021-02-04 04:48:56','2021-02-04 04:48:56',NULL);
INSERT INTO `balance_libro` VALUES (135,NULL,40719,3,2,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:48:57','2021-02-04 04:48:57',NULL),(136,NULL,40719,3,2,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1128.00,NULL,NULL,1,'2021-02-04 04:48:58','2021-02-04 04:48:58',NULL),(137,NULL,40719,3,2,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2995.20,NULL,NULL,1,'2021-02-04 04:48:59','2021-02-04 04:48:59',NULL),(138,NULL,40719,3,2,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:49:00','2021-02-04 04:49:00',NULL),(139,NULL,40719,3,2,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:49:00','2021-02-04 04:49:00',NULL),(140,NULL,40719,3,2,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',192.00,NULL,NULL,1,'2021-02-04 04:49:01','2021-02-04 04:49:01',NULL),(141,NULL,40719,3,2,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',720.00,NULL,NULL,1,'2021-02-04 04:49:02','2021-02-04 04:49:02',NULL),(142,NULL,40719,3,2,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',384.00,NULL,NULL,1,'2021-02-04 04:49:03','2021-02-04 04:49:03',NULL),(143,NULL,40719,3,2,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',72.00,NULL,NULL,1,'2021-02-04 04:49:03','2021-02-04 04:49:03',NULL),(144,NULL,40719,3,2,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:49:04','2021-02-04 04:49:04',NULL),(145,NULL,40719,3,2,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',72.00,NULL,NULL,1,'2021-02-04 04:49:05','2021-02-04 04:49:05',NULL),(146,NULL,40719,3,2,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1473.60,NULL,NULL,1,'2021-02-04 04:49:06','2021-02-04 04:49:06',NULL),(147,NULL,40719,3,2,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:49:07','2021-02-04 04:49:07',NULL),(148,NULL,40719,3,2,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:49:07','2021-02-04 04:49:07',NULL),(149,NULL,40719,3,2,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',28.80,NULL,NULL,1,'2021-02-04 04:49:08','2021-02-04 04:49:08',NULL),(150,NULL,40719,3,2,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',43.20,NULL,NULL,1,'2021-02-04 04:49:09','2021-02-04 04:49:09',NULL),(151,NULL,40719,3,2,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:49:10','2021-02-04 04:49:10',NULL),(152,NULL,40719,3,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',672.00,NULL,NULL,1,'2021-02-04 04:49:11','2021-02-04 04:49:11',NULL),(153,NULL,40719,3,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',48.00,NULL,NULL,1,'2021-02-04 04:49:11','2021-02-04 04:49:11',NULL),(154,NULL,40719,3,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',48.00,NULL,NULL,1,'2021-02-04 04:49:12','2021-02-04 04:49:12',NULL),(155,NULL,40719,3,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:49:13','2021-02-04 04:49:13',NULL),(156,NULL,40719,3,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2285.71,NULL,NULL,1,'2021-02-04 04:49:14','2021-02-04 04:49:14',NULL);
INSERT INTO `balance_libro` VALUES (157,NULL,40719,3,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',24.00,NULL,NULL,1,'2021-02-04 04:49:14','2021-02-04 04:49:14',NULL),(158,NULL,40719,3,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',163.20,NULL,NULL,1,'2021-02-04 04:49:15','2021-02-04 04:49:15',NULL),(159,NULL,40719,3,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',192.00,NULL,NULL,1,'2021-02-04 04:49:16','2021-02-04 04:49:16',NULL),(160,NULL,40719,3,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',72.00,NULL,NULL,1,'2021-02-04 04:49:17','2021-02-04 04:49:17',NULL),(161,NULL,40719,3,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2285.71,NULL,NULL,1,'2021-02-04 04:49:18','2021-02-04 04:49:18',NULL),(162,NULL,40719,3,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',105.60,NULL,NULL,1,'2021-02-04 04:49:18','2021-02-04 04:49:18',NULL),(163,NULL,40719,3,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',355.20,NULL,NULL,1,'2021-02-04 04:49:19','2021-02-04 04:49:19',NULL),(164,NULL,40719,3,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',110.40,NULL,NULL,1,'2021-02-04 04:49:20','2021-02-04 04:49:20',NULL),(165,NULL,40719,3,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',72.00,NULL,NULL,1,'2021-02-04 04:49:21','2021-02-04 04:49:21',NULL),(166,NULL,40719,3,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',72.00,NULL,NULL,1,'2021-02-04 04:49:22','2021-02-04 04:49:22',NULL),(167,NULL,40719,3,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',120.00,NULL,NULL,1,'2021-02-04 04:49:22','2021-02-04 04:49:22',NULL),(168,NULL,40719,3,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:49:23','2021-02-04 04:49:23',NULL),(169,NULL,40719,3,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:49:24','2021-02-04 04:49:24',NULL),(170,NULL,40719,3,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2400.00,NULL,NULL,1,'2021-02-04 04:49:25','2021-02-04 04:49:25',NULL),(171,NULL,40719,3,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',48.00,NULL,NULL,1,'2021-02-04 04:49:25','2021-02-04 04:49:25',NULL),(172,NULL,40719,3,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',240.00,NULL,NULL,1,'2021-02-04 04:49:26','2021-02-04 04:49:26',NULL),(173,NULL,40719,3,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:49:27','2021-02-04 04:49:27',NULL),(174,NULL,40719,3,2,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',48.00,NULL,NULL,1,'2021-02-04 04:49:28','2021-02-04 04:49:28',NULL),(175,NULL,40719,3,2,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',48.00,NULL,NULL,1,'2021-02-04 04:49:29','2021-02-04 04:49:29',NULL),(176,NULL,40719,3,2,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:49:29','2021-02-04 04:49:29',NULL),(177,NULL,40719,3,2,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',120.00,NULL,NULL,1,'2021-02-04 04:49:30','2021-02-04 04:49:30',NULL),(178,NULL,40719,3,2,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',240.00,NULL,NULL,1,'2021-02-04 04:49:31','2021-02-04 04:49:31',NULL);
INSERT INTO `balance_libro` VALUES (179,NULL,40719,3,2,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',28.94,NULL,NULL,1,'2021-02-04 04:49:32','2021-02-04 04:49:32',NULL),(180,NULL,40719,3,2,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:49:33','2021-02-04 04:49:33',NULL),(181,NULL,40719,3,2,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:49:33','2021-02-04 04:49:33',NULL),(182,NULL,40719,3,2,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',48.00,NULL,NULL,1,'2021-02-04 04:49:34','2021-02-04 04:49:34',NULL),(183,NULL,40719,3,2,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',120.00,NULL,NULL,1,'2021-02-04 04:49:35','2021-02-04 04:49:35',NULL),(184,NULL,40719,3,2,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1680.00,NULL,NULL,1,'2021-02-04 04:49:36','2021-02-04 04:49:36',NULL),(185,NULL,40719,3,2,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',960.00,NULL,NULL,1,'2021-02-04 04:49:36','2021-02-04 04:49:36',NULL),(186,NULL,40719,3,2,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',120.00,NULL,NULL,1,'2021-02-04 04:49:37','2021-02-04 04:49:37',NULL),(187,NULL,40719,3,2,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:49:38','2021-02-04 04:49:38',NULL),(188,NULL,40719,3,2,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',360.00,NULL,NULL,1,'2021-02-04 04:49:39','2021-02-04 04:49:39',NULL),(189,NULL,40719,3,2,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',24.00,NULL,NULL,1,'2021-02-04 04:49:40','2021-02-04 04:49:40',NULL),(190,NULL,40719,3,2,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1163.42,NULL,NULL,1,'2021-02-04 04:49:41','2021-02-04 04:49:41',NULL),(191,NULL,40719,3,2,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',312.00,NULL,NULL,1,'2021-02-04 04:49:41','2021-02-04 04:49:41',NULL),(192,NULL,40719,3,2,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',57.84,NULL,NULL,1,'2021-02-04 04:49:42','2021-02-04 04:49:42',NULL),(193,NULL,40719,3,2,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',360.00,NULL,NULL,1,'2021-02-04 04:49:43','2021-02-04 04:49:43',NULL),(194,NULL,40719,3,2,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:49:44','2021-02-04 04:49:44',NULL),(195,NULL,40719,3,2,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:49:45','2021-02-04 04:49:45',NULL),(196,NULL,40719,3,2,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',84.00,NULL,NULL,1,'2021-02-04 04:49:45','2021-02-04 04:49:45',NULL),(197,NULL,40719,3,2,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',240.00,NULL,NULL,1,'2021-02-04 04:49:46','2021-02-04 04:49:46',NULL),(198,NULL,40719,3,2,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',216.00,NULL,NULL,1,'2021-02-04 04:49:47','2021-02-04 04:49:47',NULL),(199,NULL,40719,3,2,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',387.84,NULL,NULL,1,'2021-02-04 04:49:48','2021-02-04 04:49:48',NULL),(200,NULL,40719,3,2,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',168.00,NULL,NULL,1,'2021-02-04 04:49:49','2021-02-04 04:49:49',NULL);
INSERT INTO `balance_libro` VALUES (201,NULL,40719,3,2,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:49:50','2021-02-04 04:49:50',NULL),(202,NULL,40719,3,2,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',240.00,NULL,NULL,1,'2021-02-04 04:49:51','2021-02-04 04:49:51',NULL),(203,NULL,40719,3,2,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',24.00,NULL,NULL,1,'2021-02-04 04:49:51','2021-02-04 04:49:51',NULL),(204,NULL,40719,3,2,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',384.00,NULL,NULL,1,'2021-02-04 04:49:52','2021-02-04 04:49:52',NULL),(205,NULL,40719,3,2,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:49:53','2021-02-04 04:49:53',NULL),(206,NULL,40719,3,2,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',288.00,NULL,NULL,1,'2021-02-04 04:49:54','2021-02-04 04:49:54',NULL),(207,NULL,40719,3,2,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',240.00,NULL,NULL,1,'2021-02-04 04:49:55','2021-02-04 04:49:55',NULL),(208,NULL,40719,3,2,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',192.00,NULL,NULL,1,'2021-02-04 04:49:56','2021-02-04 04:49:56',NULL),(209,NULL,40719,3,2,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',72.00,NULL,NULL,1,'2021-02-04 04:49:56','2021-02-04 04:49:56',NULL),(210,NULL,40719,3,2,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',134.40,NULL,NULL,1,'2021-02-04 04:49:57','2021-02-04 04:49:57',NULL),(211,NULL,40719,3,2,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',240.00,NULL,NULL,1,'2021-02-04 04:49:58','2021-02-04 04:49:58',NULL),(212,NULL,40719,3,2,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',144.00,NULL,NULL,1,'2021-02-04 04:49:59','2021-02-04 04:49:59',NULL),(213,NULL,40719,3,2,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',326.40,NULL,NULL,1,'2021-02-04 04:50:00','2021-02-04 04:50:00',NULL),(214,NULL,40719,3,2,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',499.20,NULL,NULL,1,'2021-02-04 04:50:00','2021-02-04 04:50:00',NULL),(215,NULL,40719,3,2,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:50:01','2021-02-04 04:50:01',NULL),(216,NULL,40719,3,2,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',240.00,NULL,NULL,1,'2021-02-04 04:50:02','2021-02-04 04:50:02',NULL),(217,NULL,40719,3,2,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',48.00,NULL,NULL,1,'2021-02-04 04:50:03','2021-02-04 04:50:03',NULL),(218,NULL,40719,3,2,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:50:04','2021-02-04 04:50:04',NULL),(219,NULL,40719,3,2,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',48.00,NULL,NULL,1,'2021-02-04 04:50:04','2021-02-04 04:50:04',NULL),(220,NULL,40719,3,2,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',1152.00,NULL,NULL,1,'2021-02-04 04:50:05','2021-02-04 04:50:05',NULL),(221,NULL,40719,3,2,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2285.76,NULL,NULL,1,'2021-02-04 04:50:06','2021-02-04 04:50:06',NULL),(222,NULL,40719,3,2,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',587.04,NULL,NULL,1,'2021-02-04 04:50:07','2021-02-04 04:50:07',NULL);
INSERT INTO `balance_libro` VALUES (223,NULL,40719,3,2,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',96.00,NULL,NULL,1,'2021-02-04 04:50:08','2021-02-04 04:50:08',NULL),(224,NULL,40719,3,2,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',60.00,NULL,NULL,1,'2021-02-04 19:04:48','2021-02-04 19:04:48',NULL),(225,NULL,40719,3,2,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',60.00,NULL,NULL,1,'2021-02-04 19:04:49','2021-02-04 19:04:49',NULL),(226,NULL,40719,3,2,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',100.00,NULL,NULL,1,'2021-02-04 19:04:51','2021-02-04 19:04:51',NULL),(227,NULL,40719,3,2,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:04:52','2021-02-04 19:04:52',NULL),(228,NULL,40719,3,2,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',60.00,NULL,NULL,1,'2021-02-04 19:04:53','2021-02-04 19:04:53',NULL),(229,NULL,40719,3,2,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',60.00,NULL,NULL,1,'2021-02-04 19:04:54','2021-02-04 19:04:54',NULL),(230,NULL,40719,3,2,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',42.00,NULL,NULL,1,'2021-02-04 19:04:56','2021-02-04 19:04:56',NULL),(231,NULL,40719,3,2,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:04:57','2021-02-04 19:04:57',NULL),(232,NULL,40719,3,2,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',60.00,NULL,NULL,1,'2021-02-04 19:04:58','2021-02-04 19:04:58',NULL),(233,NULL,40719,3,2,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',100.00,NULL,NULL,1,'2021-02-04 19:04:59','2021-02-04 19:04:59',NULL),(234,NULL,40719,3,2,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:00','2021-02-04 19:05:00',NULL),(235,NULL,40719,3,2,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',60.00,NULL,NULL,1,'2021-02-04 19:05:01','2021-02-04 19:05:01',NULL),(236,NULL,40719,3,2,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',300.00,NULL,NULL,1,'2021-02-04 19:05:02','2021-02-04 19:05:02',NULL),(237,NULL,40719,3,2,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:03','2021-02-04 19:05:03',NULL),(238,NULL,40719,3,2,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',60.00,NULL,NULL,1,'2021-02-04 19:05:04','2021-02-04 19:05:04',NULL),(239,NULL,40719,3,2,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',60.00,NULL,NULL,1,'2021-02-04 19:05:05','2021-02-04 19:05:05',NULL),(240,NULL,40719,3,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',80.00,NULL,NULL,1,'2021-02-04 19:05:07','2021-02-04 19:05:07',NULL),(241,NULL,40719,3,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:08','2021-02-04 19:05:08',NULL),(242,NULL,40719,3,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',160.00,NULL,NULL,1,'2021-02-04 19:05:09','2021-02-04 19:05:09',NULL),(243,NULL,40719,3,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',200.00,NULL,NULL,1,'2021-02-04 19:05:10','2021-02-04 19:05:10',NULL),(244,NULL,40719,3,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:12','2021-02-04 19:05:12',NULL);
INSERT INTO `balance_libro` VALUES (245,NULL,40719,3,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:13','2021-02-04 19:05:13',NULL),(246,NULL,40719,3,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',57.30,NULL,NULL,1,'2021-02-04 19:05:16','2021-02-04 19:05:16',NULL),(247,NULL,40719,3,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',54.00,NULL,NULL,1,'2021-02-04 19:05:18','2021-02-04 19:05:18',NULL),(248,NULL,40719,3,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:20','2021-02-04 19:05:20',NULL),(249,NULL,40719,3,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:22','2021-02-04 19:05:22',NULL),(250,NULL,40719,3,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:23','2021-02-04 19:05:23',NULL),(251,NULL,40719,3,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',214.00,NULL,NULL,1,'2021-02-04 19:05:26','2021-02-04 19:05:26',NULL),(252,NULL,40719,3,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:27','2021-02-04 19:05:27',NULL),(253,NULL,40719,3,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:29','2021-02-04 19:05:29',NULL),(254,NULL,40719,3,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',60.00,NULL,NULL,1,'2021-02-04 19:05:31','2021-02-04 19:05:31',NULL),(255,NULL,40719,3,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',80.00,NULL,NULL,1,'2021-02-04 19:05:33','2021-02-04 19:05:33',NULL),(256,NULL,40719,3,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',60.00,NULL,NULL,1,'2021-02-04 19:05:35','2021-02-04 19:05:35',NULL),(257,NULL,40719,3,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:37','2021-02-04 19:05:37',NULL),(258,NULL,40719,3,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',108.00,NULL,NULL,1,'2021-02-04 19:05:38','2021-02-04 19:05:38',NULL),(259,NULL,40719,3,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',160.00,NULL,NULL,1,'2021-02-04 19:05:40','2021-02-04 19:05:40',NULL),(260,NULL,40719,3,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:41','2021-02-04 19:05:41',NULL),(261,NULL,40719,3,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',80.00,NULL,NULL,1,'2021-02-04 19:05:43','2021-02-04 19:05:43',NULL),(262,NULL,40719,3,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',160.00,NULL,NULL,1,'2021-02-04 19:05:44','2021-02-04 19:05:44',NULL),(263,NULL,40719,3,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:46','2021-02-04 19:05:46',NULL),(264,NULL,40719,3,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:47','2021-02-04 19:05:47',NULL),(265,NULL,40719,3,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:49','2021-02-04 19:05:49',NULL),(266,NULL,40719,3,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',300.00,NULL,NULL,1,'2021-02-04 19:05:50','2021-02-04 19:05:50',NULL);
INSERT INTO `balance_libro` VALUES (267,NULL,40719,3,2,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:52','2021-02-04 19:05:52',NULL),(268,NULL,40719,3,2,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:53','2021-02-04 19:05:53',NULL),(269,NULL,40719,3,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',60.00,NULL,NULL,1,'2021-02-04 19:05:54','2021-02-04 19:05:54',NULL),(270,NULL,40719,3,2,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',50.00,NULL,NULL,1,'2021-02-04 19:05:55','2021-02-04 19:05:55',NULL),(271,NULL,40719,3,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',50.00,NULL,NULL,1,'2021-02-04 19:05:56','2021-02-04 19:05:56',NULL),(272,NULL,40719,3,2,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',40.00,NULL,NULL,1,'2021-02-04 19:05:57','2021-02-04 19:05:57',NULL),(273,NULL,40719,3,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',100.00,NULL,NULL,1,'2021-02-04 19:05:58','2021-02-04 19:05:58',NULL),(274,NULL,40719,3,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',99.36,NULL,NULL,1,'2021-02-04 19:05:59','2021-02-04 19:05:59',NULL),(275,NULL,40719,3,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',60.00,NULL,NULL,1,'2021-02-04 19:06:00','2021-02-04 19:06:00',NULL),(276,NULL,40719,3,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',60.00,NULL,NULL,1,'2021-02-04 19:06:00','2021-02-04 19:06:00',NULL),(277,NULL,40719,3,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',50.00,NULL,NULL,1,'2021-02-04 19:06:01','2021-02-04 19:06:01',NULL),(278,NULL,40719,3,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',50.00,NULL,NULL,1,'2021-02-04 19:06:02','2021-02-04 19:06:02',NULL),(279,NULL,40719,3,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',400.00,NULL,NULL,1,'2021-02-04 19:06:04','2021-02-04 19:06:04',NULL),(280,NULL,40719,3,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',64.00,NULL,NULL,1,'2021-02-04 19:06:04','2021-02-04 19:06:04',NULL),(281,NULL,40719,3,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',50.00,NULL,NULL,1,'2021-02-04 19:06:05','2021-02-04 19:06:05',NULL),(282,NULL,40719,3,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',150.00,NULL,NULL,1,'2021-02-04 19:06:06','2021-02-04 19:06:06',NULL),(283,NULL,40719,4,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',600.00,NULL,NULL,1,'2021-02-09 12:23:55','2021-02-09 12:23:55',NULL),(284,NULL,40719,4,2,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1185.00,NULL,NULL,1,'2021-02-09 12:23:56','2021-02-09 12:23:56',NULL),(285,NULL,40719,4,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',240.00,NULL,NULL,1,'2021-02-09 12:23:57','2021-02-09 12:23:57',NULL),(286,NULL,40719,4,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 12:23:58','2021-02-09 12:23:58',NULL),(287,NULL,40719,4,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',210.00,NULL,NULL,1,'2021-02-09 12:23:59','2021-02-09 12:23:59',NULL),(288,NULL,40719,4,2,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 12:24:00','2021-02-09 12:24:00',NULL);
INSERT INTO `balance_libro` VALUES (289,NULL,40719,4,2,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 12:24:00','2021-02-09 12:24:00',NULL),(290,NULL,40719,4,2,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 12:24:02','2021-02-09 12:24:02',NULL),(291,NULL,40719,4,2,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',90.00,NULL,NULL,1,'2021-02-09 12:24:03','2021-02-09 12:24:03',NULL),(292,NULL,40719,4,2,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',90.00,NULL,NULL,1,'2021-02-09 12:24:04','2021-02-09 12:24:04',NULL),(293,NULL,40719,4,2,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',750.00,NULL,NULL,1,'2021-02-09 12:24:05','2021-02-09 12:24:05',NULL),(294,NULL,40719,4,2,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',90.00,NULL,NULL,1,'2021-02-09 12:24:06','2021-02-09 12:24:06',NULL),(295,NULL,40719,4,2,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 12:24:07','2021-02-09 12:24:07',NULL),(296,NULL,40719,4,2,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',30.00,NULL,NULL,1,'2021-02-09 12:24:08','2021-02-09 12:24:08',NULL),(297,NULL,40719,4,2,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',75.00,NULL,NULL,1,'2021-02-09 12:24:09','2021-02-09 12:24:09',NULL),(298,NULL,40719,4,2,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',120.00,NULL,NULL,1,'2021-02-09 12:24:10','2021-02-09 12:24:10',NULL),(299,NULL,40719,4,2,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1500.00,NULL,NULL,1,'2021-02-09 12:24:11','2021-02-09 12:24:11',NULL),(300,NULL,40719,4,2,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 12:24:13','2021-02-09 12:24:13',NULL),(301,NULL,40719,4,2,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',90.00,NULL,NULL,1,'2021-02-09 12:24:14','2021-02-09 12:24:14',NULL),(302,NULL,40719,4,2,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',15.00,NULL,NULL,1,'2021-02-09 12:24:15','2021-02-09 12:24:15',NULL),(303,NULL,40719,4,2,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',195.00,NULL,NULL,1,'2021-02-09 12:24:16','2021-02-09 12:24:16',NULL),(304,NULL,40719,4,2,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',120.00,NULL,NULL,1,'2021-02-09 12:24:17','2021-02-09 12:24:17',NULL),(305,NULL,40719,4,2,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',105.00,NULL,NULL,1,'2021-02-09 12:24:18','2021-02-09 12:24:18',NULL),(306,NULL,40719,4,2,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',195.00,NULL,NULL,1,'2021-02-09 12:24:19','2021-02-09 12:24:19',NULL),(307,NULL,40719,4,2,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',105.00,NULL,NULL,1,'2021-02-09 12:24:20','2021-02-09 12:24:20',NULL),(308,NULL,40719,4,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',46.83,NULL,NULL,1,'2021-02-09 12:24:22','2021-02-09 12:24:22',NULL),(309,NULL,40719,4,2,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 12:24:23','2021-02-09 12:24:23',NULL),(310,NULL,40719,4,2,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',37.50,NULL,NULL,1,'2021-02-09 12:24:24','2021-02-09 12:24:24',NULL);
INSERT INTO `balance_libro` VALUES (311,NULL,40719,4,2,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',180.00,NULL,NULL,1,'2021-02-09 12:24:25','2021-02-09 12:24:25',NULL),(312,NULL,40719,4,2,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',150.00,NULL,NULL,1,'2021-02-09 12:24:26','2021-02-09 12:24:26',NULL),(313,NULL,40719,4,2,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',300.00,NULL,NULL,1,'2021-02-09 12:24:27','2021-02-09 12:24:27',NULL),(314,NULL,40719,4,2,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',90.00,NULL,NULL,1,'2021-02-09 12:24:28','2021-02-09 12:24:28',NULL),(315,NULL,40719,4,2,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',15.00,NULL,NULL,1,'2021-02-09 12:24:29','2021-02-09 12:24:29',NULL),(316,NULL,40719,4,2,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1423.80,NULL,NULL,1,'2021-02-09 12:24:30','2021-02-09 12:24:30',NULL),(317,NULL,40719,4,2,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',300.00,NULL,NULL,1,'2021-02-09 12:24:31','2021-02-09 12:24:31',NULL),(318,NULL,40719,4,2,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',210.00,NULL,NULL,1,'2021-02-09 12:24:32','2021-02-09 12:24:32',NULL),(319,NULL,40719,4,2,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',30.00,NULL,NULL,1,'2021-02-09 12:24:33','2021-02-09 12:24:33',NULL),(320,NULL,40719,4,2,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',930.96,NULL,NULL,1,'2021-02-09 12:24:35','2021-02-09 12:24:35',NULL),(321,NULL,40719,4,2,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',465.60,NULL,NULL,1,'2021-02-09 12:24:36','2021-02-09 12:24:36',NULL),(322,NULL,40719,4,2,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 12:24:37','2021-02-09 12:24:37',NULL),(323,NULL,40719,4,2,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1095.00,NULL,NULL,1,'2021-02-09 12:24:38','2021-02-09 12:24:38',NULL),(324,NULL,40719,4,2,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 12:24:39','2021-02-09 12:24:39',NULL),(325,NULL,40719,4,2,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',300.00,NULL,NULL,1,'2021-02-09 12:24:40','2021-02-09 12:24:40',NULL),(326,NULL,40719,4,2,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',2099.97,NULL,NULL,1,'2021-02-09 12:24:41','2021-02-09 12:24:41',NULL),(327,NULL,40719,4,2,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',600.00,NULL,NULL,1,'2021-02-09 14:20:13','2021-02-09 14:20:13',NULL),(328,NULL,40719,4,2,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1185.00,NULL,NULL,1,'2021-02-09 14:20:14','2021-02-09 14:20:14',NULL),(329,NULL,40719,4,2,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',240.00,NULL,NULL,1,'2021-02-09 14:20:15','2021-02-09 14:20:15',NULL),(330,NULL,40719,4,2,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 14:20:16','2021-02-09 14:20:16',NULL),(331,NULL,40719,4,2,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',210.00,NULL,NULL,1,'2021-02-09 14:20:17','2021-02-09 14:20:17',NULL),(332,NULL,40719,4,2,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 14:20:18','2021-02-09 14:20:18',NULL);
INSERT INTO `balance_libro` VALUES (333,NULL,40719,4,2,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 14:20:19','2021-02-09 14:20:19',NULL),(334,NULL,40719,4,2,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 14:20:20','2021-02-09 14:20:20',NULL),(335,NULL,40719,4,2,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',90.00,NULL,NULL,1,'2021-02-09 14:20:21','2021-02-09 14:20:21',NULL),(336,NULL,40719,4,2,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',90.00,NULL,NULL,1,'2021-02-09 14:20:22','2021-02-09 14:20:22',NULL),(337,NULL,40719,4,2,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',750.00,NULL,NULL,1,'2021-02-09 14:20:23','2021-02-09 14:20:23',NULL),(338,NULL,40719,4,2,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',90.00,NULL,NULL,1,'2021-02-09 14:20:24','2021-02-09 14:20:24',NULL),(339,NULL,40719,4,2,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 14:20:25','2021-02-09 14:20:25',NULL),(340,NULL,40719,4,2,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',30.00,NULL,NULL,1,'2021-02-09 14:20:26','2021-02-09 14:20:26',NULL),(341,NULL,40719,4,2,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',75.00,NULL,NULL,1,'2021-02-09 14:20:27','2021-02-09 14:20:27',NULL),(342,NULL,40719,4,2,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',120.00,NULL,NULL,1,'2021-02-09 14:20:28','2021-02-09 14:20:28',NULL),(343,NULL,40719,4,2,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1500.00,NULL,NULL,1,'2021-02-09 14:20:29','2021-02-09 14:20:29',NULL),(344,NULL,40719,4,2,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 14:20:30','2021-02-09 14:20:30',NULL),(345,NULL,40719,4,2,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',90.00,NULL,NULL,1,'2021-02-09 14:20:30','2021-02-09 14:20:30',NULL),(346,NULL,40719,4,2,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',15.00,NULL,NULL,1,'2021-02-09 14:20:31','2021-02-09 14:20:31',NULL),(347,NULL,40719,4,2,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',195.00,NULL,NULL,1,'2021-02-09 14:20:32','2021-02-09 14:20:32',NULL),(348,NULL,40719,4,2,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',120.00,NULL,NULL,1,'2021-02-09 14:20:33','2021-02-09 14:20:33',NULL),(349,NULL,40719,4,2,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',105.00,NULL,NULL,1,'2021-02-09 14:20:34','2021-02-09 14:20:34',NULL),(350,NULL,40719,4,2,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',195.00,NULL,NULL,1,'2021-02-09 14:20:34','2021-02-09 14:20:34',NULL),(351,NULL,40719,4,2,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',105.00,NULL,NULL,1,'2021-02-09 14:20:35','2021-02-09 14:20:35',NULL),(352,NULL,40719,4,2,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',46.83,NULL,NULL,1,'2021-02-09 14:20:36','2021-02-09 14:20:36',NULL),(353,NULL,40719,4,2,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 14:20:37','2021-02-09 14:20:37',NULL),(354,NULL,40719,4,2,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',37.50,NULL,NULL,1,'2021-02-09 14:20:38','2021-02-09 14:20:38',NULL);
INSERT INTO `balance_libro` VALUES (355,NULL,40719,4,2,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',180.00,NULL,NULL,1,'2021-02-09 14:20:39','2021-02-09 14:20:39',NULL),(356,NULL,40719,4,2,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',150.00,NULL,NULL,1,'2021-02-09 14:20:40','2021-02-09 14:20:40',NULL),(357,NULL,40719,4,2,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',300.00,NULL,NULL,1,'2021-02-09 14:20:41','2021-02-09 14:20:41',NULL),(358,NULL,40719,4,2,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',90.00,NULL,NULL,1,'2021-02-09 14:20:42','2021-02-09 14:20:42',NULL),(359,NULL,40719,4,2,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',15.00,NULL,NULL,1,'2021-02-09 14:20:42','2021-02-09 14:20:42',NULL),(360,NULL,40719,4,2,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1423.80,NULL,NULL,1,'2021-02-09 14:20:43','2021-02-09 14:20:43',NULL),(361,NULL,40719,4,2,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',300.00,NULL,NULL,1,'2021-02-09 14:20:44','2021-02-09 14:20:44',NULL),(362,NULL,40719,4,2,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',210.00,NULL,NULL,1,'2021-02-09 14:20:45','2021-02-09 14:20:45',NULL),(363,NULL,40719,4,2,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',30.00,NULL,NULL,1,'2021-02-09 14:20:46','2021-02-09 14:20:46',NULL),(364,NULL,40719,4,2,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',930.96,NULL,NULL,1,'2021-02-09 14:20:47','2021-02-09 14:20:47',NULL),(365,NULL,40719,4,2,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',465.60,NULL,NULL,1,'2021-02-09 14:20:48','2021-02-09 14:20:48',NULL),(366,NULL,40719,4,2,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 14:20:48','2021-02-09 14:20:48',NULL),(367,NULL,40719,4,2,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1095.00,NULL,NULL,1,'2021-02-09 14:20:49','2021-02-09 14:20:49',NULL),(368,NULL,40719,4,2,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',60.00,NULL,NULL,1,'2021-02-09 14:20:50','2021-02-09 14:20:50',NULL),(369,NULL,40719,4,2,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',300.00,NULL,NULL,1,'2021-02-09 14:20:51','2021-02-09 14:20:51',NULL),(370,NULL,40719,4,2,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',2099.97,NULL,NULL,1,'2021-02-09 14:20:52','2021-02-09 14:20:52',NULL),(371,2670,40719,4,2,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',680.00,NULL,NULL,1,'2021-02-09 14:39:56','2021-02-09 14:39:56',NULL),(372,2670,40719,4,2,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',192.00,NULL,NULL,1,'2021-02-09 14:39:57','2021-02-09 14:39:57',NULL),(373,2670,40719,4,2,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',482.00,NULL,NULL,1,'2021-02-09 14:39:58','2021-02-09 14:39:58',NULL),(374,2670,40719,4,2,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',237.00,NULL,NULL,1,'2021-02-09 14:39:59','2021-02-09 14:39:59',NULL),(375,2670,40719,4,2,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',124.00,NULL,NULL,1,'2021-02-09 14:40:00','2021-02-09 14:40:00',NULL),(376,2670,40719,4,2,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',159.00,NULL,NULL,1,'2021-02-09 14:40:01','2021-02-09 14:40:01',NULL);
INSERT INTO `balance_libro` VALUES (377,2670,40719,4,2,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1510.00,NULL,NULL,1,'2021-02-09 14:40:02','2021-02-09 14:40:02',NULL),(378,2670,40719,4,2,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',354.00,NULL,NULL,1,'2021-02-09 14:40:03','2021-02-09 14:40:03',NULL),(379,2670,40719,4,2,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',369.00,NULL,NULL,1,'2021-02-09 14:40:04','2021-02-09 14:40:04',NULL),(380,2670,40719,4,2,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',459.00,NULL,NULL,1,'2021-02-09 14:40:05','2021-02-09 14:40:05',NULL),(381,NULL,40719,4,2,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',4500.00,NULL,NULL,1,'2021-02-09 22:00:46','2021-02-09 22:00:46',NULL),(382,NULL,40719,4,2,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',850.00,NULL,NULL,1,'2021-02-09 22:00:47','2021-02-09 22:00:47',NULL),(383,NULL,40719,4,2,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1650.00,NULL,NULL,1,'2021-02-09 22:00:48','2021-02-09 22:00:48',NULL),(384,NULL,40719,4,2,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1200.00,NULL,NULL,1,'2021-02-09 22:00:49','2021-02-09 22:00:49',NULL),(385,NULL,40719,4,2,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',3200.00,NULL,NULL,1,'2021-02-09 22:00:49','2021-02-09 22:00:49',NULL),(386,NULL,40719,4,2,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1980.00,NULL,NULL,1,'2021-02-09 22:00:50','2021-02-09 22:00:50',NULL),(387,NULL,40719,4,2,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1550.00,NULL,NULL,1,'2021-02-09 22:00:51','2021-02-09 22:00:51',NULL),(388,NULL,40719,4,2,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',4780.00,NULL,NULL,1,'2021-02-09 22:00:52','2021-02-09 22:00:52',NULL),(389,NULL,40719,4,2,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',4901.00,NULL,NULL,1,'2021-02-09 22:00:52','2021-02-09 22:00:52',NULL),(390,NULL,40719,4,2,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',3400.00,NULL,NULL,1,'2021-02-09 22:00:53','2021-02-09 22:00:53',NULL),(391,NULL,40719,4,2,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',6100.00,NULL,NULL,1,'2021-02-09 22:00:54','2021-02-09 22:00:54',NULL),(392,NULL,40719,4,2,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',6320.00,NULL,NULL,1,'2021-02-09 22:00:54','2021-02-09 22:00:54',NULL),(393,NULL,40719,4,2,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1800.00,NULL,NULL,1,'2021-02-09 22:00:55','2021-02-09 22:00:55',NULL),(394,NULL,40719,4,2,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1820.00,NULL,NULL,1,'2021-02-09 22:00:56','2021-02-09 22:00:56',NULL),(395,NULL,40719,4,2,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',3700.00,NULL,NULL,1,'2021-02-09 22:00:57','2021-02-09 22:00:57',NULL),(396,NULL,40719,4,2,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',6520.00,NULL,NULL,1,'2021-02-09 22:00:57','2021-02-09 22:00:57',NULL),(397,NULL,40719,4,2,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',7800.00,NULL,NULL,1,'2021-02-09 22:00:58','2021-02-09 22:00:58',NULL);
INSERT INTO `balance_libro` VALUES (398,NULL,40719,4,2,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',2000.00,NULL,NULL,1,'2021-02-09 22:00:59','2021-02-09 22:00:59',NULL),(399,NULL,40719,4,2,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',3200.00,NULL,NULL,1,'2021-02-09 22:01:00','2021-02-09 22:01:00',NULL),(400,NULL,40719,4,2,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',5600.00,NULL,NULL,1,'2021-02-09 22:01:00','2021-02-09 22:01:00',NULL),(401,NULL,40719,4,2,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',4800.00,NULL,NULL,1,'2021-02-09 22:01:01','2021-02-09 22:01:01',NULL),(402,NULL,40719,5,2,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 04:58:32','2021-03-08 04:58:32',NULL),(403,NULL,40719,5,2,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',106.80,NULL,NULL,1,'2021-03-08 04:58:33','2021-03-08 04:58:33',NULL),(404,NULL,40719,5,2,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 04:58:34','2021-03-08 04:58:34',NULL),(405,NULL,40719,5,2,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 04:58:36','2021-03-08 04:58:36',NULL),(406,NULL,40719,5,2,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 04:58:37','2021-03-08 04:58:37',NULL),(407,NULL,40719,5,2,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 04:58:39','2021-03-08 04:58:39',NULL),(408,NULL,40719,5,2,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',28.00,NULL,NULL,1,'2021-03-08 04:58:40','2021-03-08 04:58:40',NULL),(409,NULL,40719,5,2,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 04:58:42','2021-03-08 04:58:42',NULL),(410,NULL,40719,5,2,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 04:58:43','2021-03-08 04:58:43',NULL),(411,NULL,40719,5,2,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',24.00,NULL,NULL,1,'2021-03-08 04:58:45','2021-03-08 04:58:45',NULL),(412,NULL,40719,5,2,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 04:58:46','2021-03-08 04:58:46',NULL),(413,NULL,40719,5,2,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 04:58:48','2021-03-08 04:58:48',NULL),(414,NULL,40719,5,2,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',64.00,NULL,NULL,1,'2021-03-08 04:58:49','2021-03-08 04:58:49',NULL),(415,NULL,40719,5,2,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',220.00,NULL,NULL,1,'2021-03-08 04:58:50','2021-03-08 04:58:50',NULL),(416,NULL,40719,5,2,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 04:58:52','2021-03-08 04:58:52',NULL),(417,NULL,40719,5,2,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',100.00,NULL,NULL,1,'2021-03-08 04:58:53','2021-03-08 04:58:53',NULL),(418,NULL,40719,5,2,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 04:58:54','2021-03-08 04:58:54',NULL),(419,NULL,40719,5,2,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',160.00,NULL,NULL,1,'2021-03-08 04:58:56','2021-03-08 04:58:56',NULL);
INSERT INTO `balance_libro` VALUES (420,NULL,40719,5,2,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',160.00,NULL,NULL,1,'2021-03-08 04:58:57','2021-03-08 04:58:57',NULL),(421,NULL,40719,5,2,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 04:58:58','2021-03-08 04:58:58',NULL),(422,NULL,40719,5,2,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 04:59:00','2021-03-08 04:59:00',NULL),(423,NULL,40719,5,2,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 04:59:01','2021-03-08 04:59:01',NULL),(424,NULL,40719,5,2,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',280.00,NULL,NULL,1,'2021-03-08 04:59:02','2021-03-08 04:59:02',NULL),(425,NULL,40719,5,2,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',160.00,NULL,NULL,1,'2021-03-08 04:59:03','2021-03-08 04:59:03',NULL),(426,NULL,40719,5,2,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 04:59:05','2021-03-08 04:59:05',NULL),(427,NULL,40719,5,2,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 04:59:06','2021-03-08 04:59:06',NULL),(428,NULL,40719,5,2,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 04:59:07','2021-03-08 04:59:07',NULL),(429,NULL,40719,5,2,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 04:59:08','2021-03-08 04:59:08',NULL),(430,NULL,40719,5,2,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 04:59:10','2021-03-08 04:59:10',NULL),(431,NULL,40719,5,2,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',160.00,NULL,NULL,1,'2021-03-08 04:59:11','2021-03-08 04:59:11',NULL),(432,NULL,40719,5,2,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:10:11','2021-03-08 05:10:11',NULL),(433,NULL,40719,5,2,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:10:12','2021-03-08 05:10:12',NULL),(434,NULL,40719,5,2,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',360.00,NULL,NULL,1,'2021-03-08 05:10:13','2021-03-08 05:10:13',NULL),(435,NULL,40719,5,2,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:10:13','2021-03-08 05:10:13',NULL),(436,NULL,40719,5,2,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',177.40,NULL,NULL,1,'2021-03-08 05:10:14','2021-03-08 05:10:14',NULL),(437,NULL,40719,5,2,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:10:15','2021-03-08 05:10:15',NULL),(438,NULL,40719,5,2,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:10:16','2021-03-08 05:10:16',NULL),(439,NULL,40719,5,2,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',140.00,NULL,NULL,1,'2021-03-08 05:10:17','2021-03-08 05:10:17',NULL),(440,NULL,40719,5,2,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',64.00,NULL,NULL,1,'2021-03-08 05:10:17','2021-03-08 05:10:17',NULL),(441,NULL,40719,5,2,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',208.00,NULL,NULL,1,'2021-03-08 05:10:18','2021-03-08 05:10:18',NULL);
INSERT INTO `balance_libro` VALUES (442,NULL,40719,5,2,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',292.00,NULL,NULL,1,'2021-03-08 05:10:19','2021-03-08 05:10:19',NULL),(443,NULL,40719,5,2,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',76.00,NULL,NULL,1,'2021-03-08 05:10:20','2021-03-08 05:10:20',NULL),(444,NULL,40719,5,2,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:10:21','2021-03-08 05:10:21',NULL),(445,NULL,40719,5,2,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1048.00,NULL,NULL,1,'2021-03-08 05:10:22','2021-03-08 05:10:22',NULL),(446,NULL,40719,5,2,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',600.00,NULL,NULL,1,'2021-03-08 05:10:22','2021-03-08 05:10:22',NULL),(447,NULL,40719,5,2,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:10:23','2021-03-08 05:10:23',NULL),(448,NULL,40719,5,2,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 05:10:24','2021-03-08 05:10:24',NULL),(449,NULL,40719,5,2,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:10:25','2021-03-08 05:10:25',NULL),(450,NULL,40719,5,2,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 05:10:26','2021-03-08 05:10:26',NULL),(451,NULL,40719,5,2,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',600.00,NULL,NULL,1,'2021-03-08 05:10:26','2021-03-08 05:10:26',NULL),(452,NULL,40719,5,2,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:10:27','2021-03-08 05:10:27',NULL),(453,NULL,40719,5,2,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',600.00,NULL,NULL,1,'2021-03-08 05:10:28','2021-03-08 05:10:28',NULL),(454,NULL,40719,5,2,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:10:29','2021-03-08 05:10:29',NULL),(455,NULL,40719,5,2,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',100.00,NULL,NULL,1,'2021-03-08 05:10:30','2021-03-08 05:10:30',NULL),(456,NULL,40719,5,2,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',24.00,NULL,NULL,1,'2021-03-08 05:10:30','2021-03-08 05:10:30',NULL),(457,NULL,40719,5,2,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:10:31','2021-03-08 05:10:31',NULL),(458,NULL,40719,5,2,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:10:32','2021-03-08 05:10:32',NULL),(459,NULL,40719,5,2,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',600.00,NULL,NULL,1,'2021-03-08 05:10:33','2021-03-08 05:10:33',NULL),(460,NULL,40719,5,2,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:10:34','2021-03-08 05:10:34',NULL),(461,NULL,40719,5,2,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',32.00,NULL,NULL,1,'2021-03-08 05:10:34','2021-03-08 05:10:34',NULL),(462,NULL,40719,5,2,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 05:10:35','2021-03-08 05:10:35',NULL),(463,NULL,40719,5,2,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',47.20,NULL,NULL,1,'2021-03-08 05:10:36','2021-03-08 05:10:36',NULL);
INSERT INTO `balance_libro` VALUES (464,NULL,40719,5,2,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:10:37','2021-03-08 05:10:37',NULL),(465,NULL,40719,5,2,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:10:38','2021-03-08 05:10:38',NULL),(466,NULL,40719,5,2,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 05:10:39','2021-03-08 05:10:39',NULL),(467,NULL,40719,5,2,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:10:39','2021-03-08 05:10:39',NULL),(468,NULL,40719,5,2,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 05:10:40','2021-03-08 05:10:40',NULL),(469,NULL,40719,5,2,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:10:41','2021-03-08 05:10:41',NULL),(470,NULL,40719,5,2,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 05:10:42','2021-03-08 05:10:42',NULL),(471,NULL,40719,5,2,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:10:42','2021-03-08 05:10:42',NULL),(472,NULL,40719,5,2,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:10:43','2021-03-08 05:10:43',NULL),(473,NULL,40719,5,2,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:10:44','2021-03-08 05:10:44',NULL),(474,NULL,40719,5,2,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',160.00,NULL,NULL,1,'2021-03-08 05:10:45','2021-03-08 05:10:45',NULL),(475,NULL,40719,5,2,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:10:46','2021-03-08 05:10:46',NULL),(476,NULL,40719,5,2,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:10:47','2021-03-08 05:10:47',NULL),(477,NULL,40719,5,2,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:10:47','2021-03-08 05:10:47',NULL),(478,NULL,40719,5,2,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',100.00,NULL,NULL,1,'2021-03-08 05:10:48','2021-03-08 05:10:48',NULL),(479,NULL,40719,5,2,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 05:10:49','2021-03-08 05:10:49',NULL),(480,NULL,40719,5,2,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:10:50','2021-03-08 05:10:50',NULL),(481,NULL,40719,5,2,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',380.96,NULL,NULL,1,'2021-03-08 05:10:51','2021-03-08 05:10:51',NULL),(482,NULL,40719,5,2,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:10:52','2021-03-08 05:10:52',NULL),(483,NULL,40719,5,2,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',26.00,NULL,NULL,1,'2021-03-08 05:10:52','2021-03-08 05:10:52',NULL),(484,NULL,40719,5,2,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',380.92,NULL,NULL,1,'2021-03-08 05:10:53','2021-03-08 05:10:53',NULL),(485,NULL,40719,5,2,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:10:54','2021-03-08 05:10:54',NULL);
INSERT INTO `balance_libro` VALUES (486,NULL,40719,5,2,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:10:55','2021-03-08 05:10:55',NULL),(487,NULL,40719,5,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:10:56','2021-03-08 05:10:56',NULL),(488,NULL,40719,5,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:10:56','2021-03-08 05:10:56',NULL),(489,NULL,40719,5,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',140.00,NULL,NULL,1,'2021-03-08 05:10:57','2021-03-08 05:10:57',NULL),(490,NULL,40719,5,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 05:10:58','2021-03-08 05:10:58',NULL),(491,NULL,40719,5,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:10:59','2021-03-08 05:10:59',NULL),(492,NULL,40719,5,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',300.00,NULL,NULL,1,'2021-03-08 05:11:00','2021-03-08 05:11:00',NULL),(493,NULL,40719,5,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:11:01','2021-03-08 05:11:01',NULL),(494,NULL,40719,5,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',600.00,NULL,NULL,1,'2021-03-08 05:24:16','2021-03-08 05:24:16',NULL),(495,NULL,40719,5,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',370.88,NULL,NULL,1,'2021-03-08 05:24:17','2021-03-08 05:24:17',NULL),(496,NULL,40719,5,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',28.00,NULL,NULL,1,'2021-03-08 05:24:17','2021-03-08 05:24:17',NULL),(497,NULL,40719,5,2,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:24:18','2021-03-08 05:24:18',NULL),(498,NULL,40719,5,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',160.00,NULL,NULL,1,'2021-03-08 05:24:19','2021-03-08 05:24:19',NULL),(499,NULL,40719,5,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',640.00,NULL,NULL,1,'2021-03-08 05:24:20','2021-03-08 05:24:20',NULL),(500,NULL,40719,5,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 05:24:20','2021-03-08 05:24:20',NULL),(501,NULL,40719,5,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:24:21','2021-03-08 05:24:21',NULL),(502,NULL,40719,5,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',133.36,NULL,NULL,1,'2021-03-08 05:24:22','2021-03-08 05:24:22',NULL),(503,NULL,40719,5,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',800.00,NULL,NULL,1,'2021-03-08 05:24:23','2021-03-08 05:24:23',NULL),(504,NULL,40719,5,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 05:24:24','2021-03-08 05:24:24',NULL),(505,NULL,40719,5,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',100.72,NULL,NULL,1,'2021-03-08 05:24:24','2021-03-08 05:24:24',NULL),(506,NULL,40719,5,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',334.12,NULL,NULL,1,'2021-03-08 05:24:25','2021-03-08 05:24:25',NULL),(507,NULL,40719,5,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',240.00,NULL,NULL,1,'2021-03-08 05:24:26','2021-03-08 05:24:26',NULL);
INSERT INTO `balance_libro` VALUES (508,NULL,40719,5,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:24:27','2021-03-08 05:24:27',NULL),(509,NULL,40719,5,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',339.46,NULL,NULL,1,'2021-03-08 05:24:28','2021-03-08 05:24:28',NULL),(510,NULL,40719,5,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',320.00,NULL,NULL,1,'2021-03-08 05:24:28','2021-03-08 05:24:28',NULL),(511,NULL,40719,5,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',169.80,NULL,NULL,1,'2021-03-08 05:24:29','2021-03-08 05:24:29',NULL),(512,NULL,40719,5,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:24:30','2021-03-08 05:24:30',NULL),(513,NULL,40719,5,2,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:24:31','2021-03-08 05:24:31',NULL),(514,NULL,40719,5,2,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',204.00,NULL,NULL,1,'2021-03-08 05:24:32','2021-03-08 05:24:32',NULL),(515,NULL,40719,5,2,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:24:32','2021-03-08 05:24:32',NULL),(516,NULL,40719,5,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',68.00,NULL,NULL,1,'2021-03-08 05:24:33','2021-03-08 05:24:33',NULL),(517,NULL,40719,5,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',160.00,NULL,NULL,1,'2021-03-08 05:24:34','2021-03-08 05:24:34',NULL),(518,NULL,40719,5,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',212.00,NULL,NULL,1,'2021-03-08 05:24:35','2021-03-08 05:24:35',NULL),(519,NULL,40719,5,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:24:35','2021-03-08 05:24:35',NULL),(520,NULL,40719,5,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',626.80,NULL,NULL,1,'2021-03-08 05:24:36','2021-03-08 05:24:36',NULL),(521,NULL,40719,5,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',24.00,NULL,NULL,1,'2021-03-08 05:24:37','2021-03-08 05:24:37',NULL),(522,NULL,40719,5,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 05:24:38','2021-03-08 05:24:38',NULL),(523,NULL,40719,5,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:24:38','2021-03-08 05:24:38',NULL),(524,NULL,40719,5,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:24:39','2021-03-08 05:24:39',NULL),(525,NULL,40719,5,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',160.00,NULL,NULL,1,'2021-03-08 05:24:40','2021-03-08 05:24:40',NULL),(526,NULL,40719,5,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',2000.00,NULL,NULL,1,'2021-03-08 05:24:41','2021-03-08 05:24:41',NULL),(527,NULL,40719,5,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1240.00,NULL,NULL,1,'2021-03-08 05:24:42','2021-03-08 05:24:42',NULL),(528,NULL,40719,5,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',240.00,NULL,NULL,1,'2021-03-08 05:24:42','2021-03-08 05:24:42',NULL),(529,NULL,40719,5,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1128.00,NULL,NULL,1,'2021-03-08 05:24:43','2021-03-08 05:24:43',NULL);
INSERT INTO `balance_libro` VALUES (530,NULL,40719,5,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1224.00,NULL,NULL,1,'2021-03-08 05:24:44','2021-03-08 05:24:44',NULL),(531,NULL,40719,5,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 05:24:45','2021-03-08 05:24:45',NULL),(532,NULL,40719,5,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',140.00,NULL,NULL,1,'2021-03-08 05:24:45','2021-03-08 05:24:45',NULL),(533,NULL,40719,5,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',256.00,NULL,NULL,1,'2021-03-08 05:24:46','2021-03-08 05:24:46',NULL),(534,NULL,40719,5,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:24:47','2021-03-08 05:24:47',NULL),(535,NULL,40719,5,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',28.00,NULL,NULL,1,'2021-03-08 05:24:48','2021-03-08 05:24:48',NULL),(536,NULL,40719,5,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',550.00,NULL,NULL,1,'2021-03-08 05:24:49','2021-03-08 05:24:49',NULL),(537,NULL,40719,5,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',3142.80,NULL,NULL,1,'2021-03-08 05:24:49','2021-03-08 05:24:49',NULL),(538,NULL,40719,5,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1620.00,NULL,NULL,1,'2021-03-08 05:24:50','2021-03-08 05:24:50',NULL),(539,NULL,40719,5,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:24:51','2021-03-08 05:24:51',NULL),(540,NULL,40719,5,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:24:52','2021-03-08 05:24:52',NULL),(541,NULL,40719,5,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 05:24:52','2021-03-08 05:24:52',NULL),(542,NULL,40719,5,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 05:24:53','2021-03-08 05:24:53',NULL),(543,NULL,40719,5,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',28.00,NULL,NULL,1,'2021-03-08 05:24:54','2021-03-08 05:24:54',NULL),(544,NULL,40719,5,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 05:24:55','2021-03-08 05:24:55',NULL),(545,NULL,40719,5,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:24:56','2021-03-08 05:24:56',NULL),(546,NULL,40719,5,2,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',360.00,NULL,NULL,1,'2021-03-08 05:24:56','2021-03-08 05:24:56',NULL),(547,NULL,40719,5,2,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1102.80,NULL,NULL,1,'2021-03-08 05:24:57','2021-03-08 05:24:57',NULL),(548,NULL,40719,5,2,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',48.00,NULL,NULL,1,'2021-03-08 05:24:58','2021-03-08 05:24:58',NULL),(549,NULL,40719,5,2,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:24:59','2021-03-08 05:24:59',NULL),(550,NULL,40719,5,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:24:59','2021-03-08 05:24:59',NULL),(551,NULL,40719,5,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',663.44,NULL,NULL,1,'2021-03-08 05:25:00','2021-03-08 05:25:00',NULL);
INSERT INTO `balance_libro` VALUES (552,NULL,40719,5,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:25:01','2021-03-08 05:25:01',NULL),(553,NULL,40719,5,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',656.00,NULL,NULL,1,'2021-03-08 05:25:02','2021-03-08 05:25:02',NULL),(554,NULL,40719,5,2,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:25:03','2021-03-08 05:25:03',NULL),(555,NULL,40719,5,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:25:03','2021-03-08 05:25:03',NULL),(556,NULL,40719,5,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',742.00,NULL,NULL,1,'2021-03-08 05:25:04','2021-03-08 05:25:04',NULL),(557,NULL,40719,5,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:25:05','2021-03-08 05:25:05',NULL),(558,NULL,40719,5,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:25:06','2021-03-08 05:25:06',NULL),(559,NULL,40719,5,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',584.00,NULL,NULL,1,'2021-03-08 05:25:06','2021-03-08 05:25:06',NULL),(560,NULL,40719,5,2,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',636.00,NULL,NULL,1,'2021-03-08 05:25:07','2021-03-08 05:25:07',NULL),(561,NULL,40719,5,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',958.80,NULL,NULL,1,'2021-03-08 05:25:08','2021-03-08 05:25:08',NULL),(562,NULL,40719,5,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',2288.00,NULL,NULL,1,'2021-03-08 05:25:09','2021-03-08 05:25:09',NULL),(563,NULL,40719,5,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:25:10','2021-03-08 05:25:10',NULL),(564,NULL,40719,5,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:25:10','2021-03-08 05:25:10',NULL),(565,NULL,40719,5,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:25:11','2021-03-08 05:25:11',NULL),(566,NULL,40719,5,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',692.00,NULL,NULL,1,'2021-03-08 05:25:12','2021-03-08 05:25:12',NULL),(567,NULL,40719,5,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',92.00,NULL,NULL,1,'2021-03-08 05:25:13','2021-03-08 05:25:13',NULL),(568,NULL,40719,5,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:25:13','2021-03-08 05:25:13',NULL),(569,NULL,40719,5,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:25:14','2021-03-08 05:25:14',NULL),(570,NULL,40719,5,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',368.00,NULL,NULL,1,'2021-03-08 05:25:15','2021-03-08 05:25:15',NULL),(571,NULL,40719,5,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',656.00,NULL,NULL,1,'2021-03-08 05:25:16','2021-03-08 05:25:16',NULL),(572,NULL,40719,5,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',868.00,NULL,NULL,1,'2021-03-08 05:25:17','2021-03-08 05:25:17',NULL),(573,NULL,40719,5,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',560.00,NULL,NULL,1,'2021-03-08 05:25:17','2021-03-08 05:25:17',NULL);
INSERT INTO `balance_libro` VALUES (574,NULL,40719,5,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:25:18','2021-03-08 05:25:18',NULL),(575,NULL,40719,5,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',280.00,NULL,NULL,1,'2021-03-08 05:25:19','2021-03-08 05:25:19',NULL),(576,NULL,40719,5,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:25:20','2021-03-08 05:25:20',NULL),(577,NULL,40719,5,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',133.80,NULL,NULL,1,'2021-03-08 05:25:20','2021-03-08 05:25:20',NULL),(578,NULL,40719,5,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',122.84,NULL,NULL,1,'2021-03-08 05:25:21','2021-03-08 05:25:21',NULL),(579,NULL,40719,5,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:25:22','2021-03-08 05:25:22',NULL),(580,NULL,40719,5,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:25:23','2021-03-08 05:25:23',NULL),(581,NULL,40719,5,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',104.00,NULL,NULL,1,'2021-03-08 05:25:24','2021-03-08 05:25:24',NULL),(582,NULL,40719,5,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',193.88,NULL,NULL,1,'2021-03-08 05:25:24','2021-03-08 05:25:24',NULL),(583,NULL,40719,5,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',524.00,NULL,NULL,1,'2021-03-08 05:25:25','2021-03-08 05:25:25',NULL),(584,NULL,40719,5,2,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',148.00,NULL,NULL,1,'2021-03-08 05:25:26','2021-03-08 05:25:26',NULL),(585,NULL,40719,5,2,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:25:27','2021-03-08 05:25:27',NULL),(586,NULL,40719,5,2,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:53:50','2021-03-08 05:53:50',NULL),(587,NULL,40719,5,2,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',26.00,NULL,NULL,1,'2021-03-08 05:53:51','2021-03-08 05:53:51',NULL),(588,NULL,40719,5,2,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',268.00,NULL,NULL,1,'2021-03-08 05:53:52','2021-03-08 05:53:52',NULL),(589,NULL,40719,5,2,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',240.00,NULL,NULL,1,'2021-03-08 05:53:52','2021-03-08 05:53:52',NULL),(590,NULL,40719,5,2,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',160.00,NULL,NULL,1,'2021-03-08 05:53:53','2021-03-08 05:53:53',NULL),(591,NULL,40719,5,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1904.76,NULL,NULL,1,'2021-03-08 05:53:54','2021-03-08 05:53:54',NULL),(592,NULL,40719,5,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1904.76,NULL,NULL,1,'2021-03-08 05:53:55','2021-03-08 05:53:55',NULL),(593,NULL,40719,5,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1904.76,NULL,NULL,1,'2021-03-08 05:53:56','2021-03-08 05:53:56',NULL),(594,NULL,40719,5,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:53:58','2021-03-08 05:53:58',NULL),(595,NULL,40719,5,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',100.00,NULL,NULL,1,'2021-03-08 05:53:58','2021-03-08 05:53:58',NULL);
INSERT INTO `balance_libro` VALUES (596,NULL,40719,5,2,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:53:59','2021-03-08 05:53:59',NULL),(597,NULL,40719,5,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',480.00,NULL,NULL,1,'2021-03-08 05:54:00','2021-03-08 05:54:00',NULL),(598,NULL,40719,5,2,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',492.00,NULL,NULL,1,'2021-03-08 05:54:01','2021-03-08 05:54:01',NULL),(599,NULL,40719,5,2,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',320.00,NULL,NULL,1,'2021-03-08 05:54:02','2021-03-08 05:54:02',NULL),(600,NULL,40719,5,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',748.00,NULL,NULL,1,'2021-03-08 05:54:03','2021-03-08 05:54:03',NULL),(601,NULL,40719,5,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',64.00,NULL,NULL,1,'2021-03-08 05:54:03','2021-03-08 05:54:03',NULL),(602,NULL,40719,5,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',994.96,NULL,NULL,1,'2021-03-08 05:54:04','2021-03-08 05:54:04',NULL),(603,NULL,40719,5,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',116.00,NULL,NULL,1,'2021-03-08 05:54:05','2021-03-08 05:54:05',NULL),(604,NULL,40719,5,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 05:54:06','2021-03-08 05:54:06',NULL),(605,NULL,40719,5,2,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',64.00,NULL,NULL,1,'2021-03-08 05:54:07','2021-03-08 05:54:07',NULL),(606,NULL,40719,5,2,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1520.00,NULL,NULL,1,'2021-03-08 05:54:07','2021-03-08 05:54:07',NULL),(607,NULL,40719,5,2,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 05:54:08','2021-03-08 05:54:08',NULL),(608,NULL,40719,5,2,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:54:09','2021-03-08 05:54:09',NULL),(609,NULL,40719,5,2,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',600.00,NULL,NULL,1,'2021-03-08 05:54:10','2021-03-08 05:54:10',NULL),(610,NULL,40719,5,2,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 05:54:11','2021-03-08 05:54:11',NULL),(611,NULL,40719,5,2,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:54:11','2021-03-08 05:54:11',NULL),(612,NULL,40719,5,2,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:54:12','2021-03-08 05:54:12',NULL),(613,NULL,40719,5,2,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',88.00,NULL,NULL,1,'2021-03-08 05:54:13','2021-03-08 05:54:13',NULL),(614,NULL,40719,5,2,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:54:14','2021-03-08 05:54:14',NULL),(615,NULL,40719,5,2,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:54:15','2021-03-08 05:54:15',NULL),(616,NULL,40719,5,2,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',192.00,NULL,NULL,1,'2021-03-08 05:54:15','2021-03-08 05:54:15',NULL),(617,NULL,40719,5,2,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',100.00,NULL,NULL,1,'2021-03-08 05:54:16','2021-03-08 05:54:16',NULL);
INSERT INTO `balance_libro` VALUES (618,NULL,40719,5,2,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',160.00,NULL,NULL,1,'2021-03-08 05:54:17','2021-03-08 05:54:17',NULL),(619,NULL,40719,5,2,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1951.20,NULL,NULL,1,'2021-03-08 05:54:18','2021-03-08 05:54:18',NULL),(620,NULL,40719,5,2,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:54:19','2021-03-08 05:54:19',NULL),(621,NULL,40719,5,2,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:54:20','2021-03-08 05:54:20',NULL),(622,NULL,40719,5,2,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1460.00,NULL,NULL,1,'2021-03-08 05:54:20','2021-03-08 05:54:20',NULL),(623,NULL,40719,5,2,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',100.00,NULL,NULL,1,'2021-03-08 05:54:21','2021-03-08 05:54:21',NULL),(624,NULL,40719,5,2,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',100.00,NULL,NULL,1,'2021-03-08 05:54:22','2021-03-08 05:54:22',NULL),(625,NULL,40719,5,2,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:54:23','2021-03-08 05:54:23',NULL),(626,NULL,40719,5,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:54:23','2021-03-08 05:54:23',NULL),(627,NULL,40719,5,2,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1200.00,NULL,NULL,1,'2021-03-08 05:54:24','2021-03-08 05:54:24',NULL),(628,NULL,40719,5,2,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:54:25','2021-03-08 05:54:25',NULL),(629,NULL,40719,5,2,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',280.00,NULL,NULL,1,'2021-03-08 05:54:26','2021-03-08 05:54:26',NULL),(630,NULL,40719,5,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:54:27','2021-03-08 05:54:27',NULL),(631,NULL,40719,5,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',800.00,NULL,NULL,1,'2021-03-08 05:54:27','2021-03-08 05:54:27',NULL),(632,NULL,40719,5,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:54:28','2021-03-08 05:54:28',NULL),(633,NULL,40719,5,2,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',100.00,NULL,NULL,1,'2021-03-08 05:54:29','2021-03-08 05:54:29',NULL),(634,NULL,40719,5,2,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:54:30','2021-03-08 05:54:30',NULL),(635,NULL,40719,5,2,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:54:30','2021-03-08 05:54:30',NULL),(636,NULL,40719,5,2,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',104.00,NULL,NULL,1,'2021-03-08 05:54:31','2021-03-08 05:54:31',NULL),(637,NULL,40719,5,2,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:54:32','2021-03-08 05:54:32',NULL),(638,NULL,40719,5,2,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:54:33','2021-03-08 05:54:33',NULL),(639,NULL,40719,5,2,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',16.88,NULL,NULL,1,'2021-03-08 05:54:34','2021-03-08 05:54:34',NULL);
INSERT INTO `balance_libro` VALUES (640,NULL,40719,5,2,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1135.60,NULL,NULL,1,'2021-03-08 05:54:35','2021-03-08 05:54:35',NULL),(641,NULL,40719,5,2,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:54:35','2021-03-08 05:54:35',NULL),(642,NULL,40719,5,2,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:54:36','2021-03-08 05:54:36',NULL),(643,NULL,40719,5,2,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',160.00,NULL,NULL,1,'2021-03-08 05:54:37','2021-03-08 05:54:37',NULL),(644,NULL,40719,5,2,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:54:38','2021-03-08 05:54:38',NULL),(645,NULL,40719,5,2,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:54:38','2021-03-08 05:54:38',NULL),(646,NULL,40719,5,2,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',520.00,NULL,NULL,1,'2021-03-08 05:54:39','2021-03-08 05:54:39',NULL),(647,NULL,40719,5,2,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 05:54:40','2021-03-08 05:54:40',NULL),(648,NULL,40719,5,2,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:54:41','2021-03-08 05:54:41',NULL),(649,NULL,40719,5,2,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:54:42','2021-03-08 05:54:42',NULL),(650,NULL,40719,5,2,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:54:42','2021-03-08 05:54:42',NULL),(651,NULL,40719,5,2,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:54:43','2021-03-08 05:54:43',NULL),(652,NULL,40719,5,2,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:54:44','2021-03-08 05:54:44',NULL),(653,NULL,40719,5,2,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:54:45','2021-03-08 05:54:45',NULL),(654,NULL,40719,5,2,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:54:45','2021-03-08 05:54:45',NULL),(655,NULL,40719,5,2,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:54:46','2021-03-08 05:54:46',NULL),(656,NULL,40719,5,2,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:54:47','2021-03-08 05:54:47',NULL),(657,NULL,40719,5,2,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 05:54:48','2021-03-08 05:54:48',NULL),(658,NULL,40719,5,2,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 05:54:49','2021-03-08 05:54:49',NULL),(659,NULL,40719,5,2,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',800.00,NULL,NULL,1,'2021-03-08 05:54:49','2021-03-08 05:54:49',NULL),(660,NULL,40719,5,2,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:54:50','2021-03-08 05:54:50',NULL),(661,NULL,40719,5,2,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',100.00,NULL,NULL,1,'2021-03-08 05:54:51','2021-03-08 05:54:51',NULL);
INSERT INTO `balance_libro` VALUES (662,NULL,40719,5,2,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',600.00,NULL,NULL,1,'2021-03-08 05:54:52','2021-03-08 05:54:52',NULL),(663,NULL,40719,5,2,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:54:53','2021-03-08 05:54:53',NULL),(664,NULL,40719,5,2,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',94.00,NULL,NULL,1,'2021-03-08 05:54:53','2021-03-08 05:54:53',NULL),(665,NULL,40719,5,2,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:54:54','2021-03-08 05:54:54',NULL),(666,NULL,40719,5,2,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',100.00,NULL,NULL,1,'2021-03-08 05:54:55','2021-03-08 05:54:55',NULL),(667,NULL,40719,5,2,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 05:54:56','2021-03-08 05:54:56',NULL),(668,NULL,40719,5,2,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',240.00,NULL,NULL,1,'2021-03-08 05:54:57','2021-03-08 05:54:57',NULL),(669,NULL,40719,5,2,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',64.00,NULL,NULL,1,'2021-03-08 05:54:57','2021-03-08 05:54:57',NULL),(670,NULL,40719,5,2,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 05:54:58','2021-03-08 05:54:58',NULL),(671,NULL,40719,5,2,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 05:54:59','2021-03-08 05:54:59',NULL),(672,NULL,40719,5,2,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 05:55:00','2021-03-08 05:55:00',NULL),(673,NULL,40719,5,2,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 05:55:01','2021-03-08 05:55:01',NULL),(674,NULL,40719,5,2,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',146.00,NULL,NULL,1,'2021-03-08 05:55:01','2021-03-08 05:55:01',NULL),(675,NULL,40719,5,2,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',47.12,NULL,NULL,1,'2021-03-08 05:55:02','2021-03-08 05:55:02',NULL),(676,NULL,40719,5,2,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',240.00,NULL,NULL,1,'2021-03-08 05:55:03','2021-03-08 05:55:03',NULL),(677,NULL,40719,5,2,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',64.00,NULL,NULL,1,'2021-03-08 05:55:04','2021-03-08 05:55:04',NULL),(678,NULL,40719,5,2,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 05:55:04','2021-03-08 05:55:04',NULL),(679,NULL,40719,5,2,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 05:55:05','2021-03-08 05:55:05',NULL),(680,NULL,40719,5,2,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1302.86,NULL,NULL,1,'2021-03-08 05:55:06','2021-03-08 05:55:06',NULL),(681,NULL,40719,5,2,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',220.00,NULL,NULL,1,'2021-03-08 05:55:07','2021-03-08 05:55:07',NULL),(682,NULL,40719,5,2,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 06:13:49','2021-03-08 06:13:49',NULL),(683,NULL,40719,5,2,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',180.00,NULL,NULL,1,'2021-03-08 06:13:50','2021-03-08 06:13:50',NULL);
INSERT INTO `balance_libro` VALUES (684,NULL,40719,5,2,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 06:13:51','2021-03-08 06:13:51',NULL),(685,NULL,40719,5,2,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 06:13:52','2021-03-08 06:13:52',NULL),(686,NULL,40719,5,2,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 06:13:53','2021-03-08 06:13:53',NULL),(687,NULL,40719,5,2,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',180.00,NULL,NULL,1,'2021-03-08 06:13:53','2021-03-08 06:13:53',NULL),(688,NULL,40719,5,2,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',300.00,NULL,NULL,1,'2021-03-08 06:13:54','2021-03-08 06:13:54',NULL),(689,NULL,40719,5,2,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 06:13:55','2021-03-08 06:13:55',NULL),(690,NULL,40719,5,2,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',44.00,NULL,NULL,1,'2021-03-08 06:13:56','2021-03-08 06:13:56',NULL),(691,NULL,40719,5,2,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 06:13:57','2021-03-08 06:13:57',NULL),(692,NULL,40719,5,2,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 06:13:57','2021-03-08 06:13:57',NULL),(693,NULL,40719,5,2,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 06:13:58','2021-03-08 06:13:58',NULL),(694,NULL,40719,5,2,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 06:13:59','2021-03-08 06:13:59',NULL),(695,NULL,40719,5,2,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 06:14:00','2021-03-08 06:14:00',NULL),(696,NULL,40719,5,2,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 06:14:01','2021-03-08 06:14:01',NULL),(697,NULL,40719,5,2,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 06:14:01','2021-03-08 06:14:01',NULL),(698,NULL,40719,5,2,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',240.00,NULL,NULL,1,'2021-03-08 06:14:02','2021-03-08 06:14:02',NULL),(699,NULL,40719,5,2,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 06:14:03','2021-03-08 06:14:03',NULL),(700,NULL,40719,5,2,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 06:14:04','2021-03-08 06:14:04',NULL),(701,NULL,40719,5,2,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 06:14:05','2021-03-08 06:14:05',NULL),(702,NULL,40719,5,2,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 06:14:05','2021-03-08 06:14:05',NULL),(703,NULL,40719,5,2,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',92.00,NULL,NULL,1,'2021-03-08 06:14:06','2021-03-08 06:14:06',NULL),(704,NULL,40719,5,2,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',8.00,NULL,NULL,1,'2021-03-08 06:14:07','2021-03-08 06:14:07',NULL),(705,NULL,40719,5,2,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',820.00,NULL,NULL,1,'2021-03-08 06:14:08','2021-03-08 06:14:08',NULL);
INSERT INTO `balance_libro` VALUES (706,NULL,40719,5,2,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',204.00,NULL,NULL,1,'2021-03-08 06:14:09','2021-03-08 06:14:09',NULL),(707,NULL,40719,5,2,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 06:14:09','2021-03-08 06:14:09',NULL),(708,NULL,40719,5,2,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 06:14:10','2021-03-08 06:14:10',NULL),(709,NULL,40719,5,2,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 06:14:11','2021-03-08 06:14:11',NULL),(710,NULL,40719,5,2,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 06:14:12','2021-03-08 06:14:12',NULL),(711,NULL,40719,5,2,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 06:14:13','2021-03-08 06:14:13',NULL),(712,NULL,40719,5,2,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',140.00,NULL,NULL,1,'2021-03-08 06:14:13','2021-03-08 06:14:13',NULL),(713,NULL,40719,5,2,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',220.00,NULL,NULL,1,'2021-03-08 06:14:14','2021-03-08 06:14:14',NULL),(714,NULL,40719,5,2,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 06:14:15','2021-03-08 06:14:15',NULL),(715,NULL,40719,5,2,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',208.00,NULL,NULL,1,'2021-03-08 06:14:16','2021-03-08 06:14:16',NULL),(716,NULL,40719,5,2,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 06:14:17','2021-03-08 06:14:17',NULL),(717,NULL,40719,5,2,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',480.00,NULL,NULL,1,'2021-03-08 06:14:17','2021-03-08 06:14:17',NULL),(718,NULL,40719,5,2,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1400.00,NULL,NULL,1,'2021-03-08 06:14:18','2021-03-08 06:14:18',NULL),(719,NULL,40719,5,2,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',280.00,NULL,NULL,1,'2021-03-08 06:14:19','2021-03-08 06:14:19',NULL),(720,NULL,40719,5,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',80.00,NULL,NULL,1,'2021-03-08 06:14:20','2021-03-08 06:14:20',NULL),(721,NULL,40719,5,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1000.00,NULL,NULL,1,'2021-03-08 06:14:21','2021-03-08 06:14:21',NULL),(722,NULL,40719,5,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',240.00,NULL,NULL,1,'2021-03-08 06:14:21','2021-03-08 06:14:21',NULL),(723,NULL,40719,5,2,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',68.00,NULL,NULL,1,'2021-03-08 06:14:22','2021-03-08 06:14:22',NULL),(724,NULL,40719,5,2,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 06:14:23','2021-03-08 06:14:23',NULL),(725,NULL,40719,5,2,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',194.40,NULL,NULL,1,'2021-03-08 06:14:24','2021-03-08 06:14:24',NULL),(726,NULL,40719,5,2,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',585.40,NULL,NULL,1,'2021-03-08 06:14:25','2021-03-08 06:14:25',NULL),(727,NULL,40719,5,2,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 06:14:26','2021-03-08 06:14:26',NULL);
INSERT INTO `balance_libro` VALUES (728,NULL,40719,5,2,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 06:14:26','2021-03-08 06:14:26',NULL),(729,NULL,40719,5,2,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',76.00,NULL,NULL,1,'2021-03-08 06:14:27','2021-03-08 06:14:27',NULL),(730,NULL,40719,5,2,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 06:14:28','2021-03-08 06:14:28',NULL),(731,NULL,40719,5,2,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',800.00,NULL,NULL,1,'2021-03-08 06:14:29','2021-03-08 06:14:29',NULL),(732,NULL,40719,5,2,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',212.00,NULL,NULL,1,'2021-03-08 06:14:30','2021-03-08 06:14:30',NULL),(733,NULL,40719,5,2,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',840.00,NULL,NULL,1,'2021-03-08 06:14:31','2021-03-08 06:14:31',NULL),(734,NULL,40719,5,2,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',601.80,NULL,NULL,1,'2021-03-08 06:14:31','2021-03-08 06:14:31',NULL),(735,NULL,40719,5,2,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',340.00,NULL,NULL,1,'2021-03-08 06:14:32','2021-03-08 06:14:32',NULL),(736,NULL,40719,5,2,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',760.00,NULL,NULL,1,'2021-03-08 06:14:33','2021-03-08 06:14:33',NULL),(737,NULL,40719,5,2,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',140.00,NULL,NULL,1,'2021-03-08 06:14:34','2021-03-08 06:14:34',NULL),(738,NULL,40719,5,2,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',116.00,NULL,NULL,1,'2021-03-08 06:14:35','2021-03-08 06:14:35',NULL),(739,NULL,40719,5,2,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',560.00,NULL,NULL,1,'2021-03-08 06:14:35','2021-03-08 06:14:35',NULL),(740,NULL,40719,5,2,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',400.00,NULL,NULL,1,'2021-03-08 06:14:36','2021-03-08 06:14:36',NULL),(741,NULL,40719,5,2,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',60.00,NULL,NULL,1,'2021-03-08 06:14:37','2021-03-08 06:14:37',NULL),(742,NULL,40719,5,2,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',200.00,NULL,NULL,1,'2021-03-08 06:14:38','2021-03-08 06:14:38',NULL),(743,NULL,40719,5,2,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',340.00,NULL,NULL,1,'2021-03-08 06:14:39','2021-03-08 06:14:39',NULL),(744,NULL,40719,5,2,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 06:14:39','2021-03-08 06:14:39',NULL),(745,NULL,40719,5,2,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',52.00,NULL,NULL,1,'2021-03-08 06:14:40','2021-03-08 06:14:40',NULL),(746,NULL,40719,5,2,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 06:14:41','2021-03-08 06:14:41',NULL),(747,NULL,40719,5,2,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 06:14:42','2021-03-08 06:14:42',NULL),(748,NULL,40719,5,2,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',20.00,NULL,NULL,1,'2021-03-08 06:14:43','2021-03-08 06:14:43',NULL),(749,NULL,40719,5,2,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 06:14:44','2021-03-08 06:14:44',NULL);
INSERT INTO `balance_libro` VALUES (750,NULL,40719,5,2,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',504.00,NULL,NULL,1,'2021-03-08 06:14:44','2021-03-08 06:14:44',NULL),(751,NULL,40719,5,2,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',120.00,NULL,NULL,1,'2021-03-08 06:14:45','2021-03-08 06:14:45',NULL),(752,NULL,40719,5,2,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',720.00,NULL,NULL,1,'2021-03-08 06:14:46','2021-03-08 06:14:46',NULL),(753,NULL,40719,5,2,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',800.00,NULL,NULL,1,'2021-03-08 06:14:47','2021-03-08 06:14:47',NULL),(754,NULL,40719,5,2,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',40.00,NULL,NULL,1,'2021-03-08 06:14:48','2021-03-08 06:14:48',NULL),(755,NULL,40719,5,2,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',987.20,NULL,NULL,1,'2021-03-08 06:14:49','2021-03-08 06:14:49',NULL),(756,NULL,40719,5,2,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1008.00,NULL,NULL,1,'2021-03-09 21:15:55','2021-03-09 21:15:55',NULL),(757,NULL,40719,5,2,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',160.00,NULL,NULL,1,'2021-03-09 21:15:57','2021-03-09 21:15:57',NULL),(758,NULL,40719,5,2,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1440.00,NULL,NULL,1,'2021-03-09 21:15:58','2021-03-09 21:15:58',NULL),(759,NULL,40719,5,2,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1800.00,NULL,NULL,1,'2021-03-09 21:16:00','2021-03-09 21:16:00',NULL),(760,NULL,40719,5,2,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',16.04,NULL,NULL,1,'2021-03-09 21:16:01','2021-03-09 21:16:01',NULL),(761,NULL,40719,5,2,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1680.00,NULL,NULL,1,'2021-03-09 21:16:02','2021-03-09 21:16:02',NULL),(762,NULL,40719,5,2,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',80.00,NULL,NULL,1,'2021-03-09 21:16:03','2021-03-09 21:16:03',NULL),(763,NULL,40719,5,2,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',5.60,NULL,NULL,1,'2021-03-09 21:16:04','2021-03-09 21:16:04',NULL),(764,NULL,40719,5,2,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',120.00,NULL,NULL,1,'2021-03-09 21:16:05','2021-03-09 21:16:05',NULL),(765,NULL,40719,5,2,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',773.28,NULL,NULL,1,'2021-03-09 21:16:06','2021-03-09 21:16:06',NULL),(766,NULL,40719,5,2,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',202.80,NULL,NULL,1,'2021-03-09 21:16:07','2021-03-09 21:16:07',NULL),(767,NULL,40719,5,2,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',183.04,NULL,NULL,1,'2021-03-09 21:16:08','2021-03-09 21:16:08',NULL),(768,NULL,40719,5,2,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',520.00,NULL,NULL,1,'2021-03-09 21:16:10','2021-03-09 21:16:10',NULL),(769,NULL,40719,5,2,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',340.00,NULL,NULL,1,'2021-03-09 21:16:12','2021-03-09 21:16:12',NULL),(770,NULL,40719,5,2,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',200.00,NULL,NULL,1,'2021-03-09 21:16:13','2021-03-09 21:16:13',NULL),(771,NULL,40719,5,2,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',200.00,NULL,NULL,1,'2021-03-09 21:16:14','2021-03-09 21:16:14',NULL);
INSERT INTO `balance_libro` VALUES (772,NULL,40719,5,2,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',120.00,NULL,NULL,1,'2021-03-09 21:16:15','2021-03-09 21:16:15',NULL),(773,NULL,40719,5,2,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',120.00,NULL,NULL,1,'2021-03-09 21:16:16','2021-03-09 21:16:16',NULL),(774,NULL,40719,5,2,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',40.00,NULL,NULL,1,'2021-03-09 21:16:17','2021-03-09 21:16:17',NULL),(775,NULL,40719,5,2,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',812.00,NULL,NULL,1,'2021-03-09 21:16:18','2021-03-09 21:16:18',NULL),(776,NULL,40719,5,2,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',360.00,NULL,NULL,1,'2021-03-09 21:16:19','2021-03-09 21:16:19',NULL),(777,NULL,40719,5,2,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1320.00,NULL,NULL,1,'2021-03-09 21:16:20','2021-03-09 21:16:20',NULL),(778,NULL,40719,5,2,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1320.00,NULL,NULL,1,'2021-03-09 21:16:21','2021-03-09 21:16:21',NULL),(779,NULL,40719,5,2,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',621.20,NULL,NULL,1,'2021-03-09 21:16:23','2021-03-09 21:16:23',NULL),(780,NULL,40719,5,2,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',140.00,NULL,NULL,1,'2021-03-09 21:16:24','2021-03-09 21:16:24',NULL),(781,NULL,40719,5,2,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',238.08,NULL,NULL,1,'2021-03-09 21:16:25','2021-03-09 21:16:25',NULL),(782,NULL,40719,5,2,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',60.00,NULL,NULL,1,'2021-03-09 21:16:26','2021-03-09 21:16:26',NULL),(783,NULL,40719,5,2,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',52.00,NULL,NULL,1,'2021-03-09 21:16:27','2021-03-09 21:16:27',NULL),(784,NULL,40719,5,2,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',100.00,NULL,NULL,1,'2021-03-09 21:16:28','2021-03-09 21:16:28',NULL),(785,NULL,40719,5,2,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',20.00,NULL,NULL,1,'2021-03-09 21:16:29','2021-03-09 21:16:29',NULL),(786,NULL,40719,5,2,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1248.32,NULL,NULL,1,'2021-03-09 21:16:30','2021-03-09 21:16:30',NULL),(787,NULL,40719,5,2,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',446.00,NULL,NULL,1,'2021-03-09 21:16:31','2021-03-09 21:16:31',NULL),(788,NULL,40719,5,2,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',80.00,NULL,NULL,1,'2021-03-09 21:16:32','2021-03-09 21:16:32',NULL),(789,NULL,40719,5,2,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',280.00,NULL,NULL,1,'2021-03-09 21:16:33','2021-03-09 21:16:33',NULL),(790,NULL,40719,5,2,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',200.00,NULL,NULL,1,'2021-03-09 21:16:34','2021-03-09 21:16:34',NULL),(791,NULL,40719,5,2,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',120.00,NULL,NULL,1,'2021-03-09 21:16:35','2021-03-09 21:16:35',NULL),(792,NULL,40719,5,2,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',360.00,NULL,NULL,1,'2021-03-09 21:16:36','2021-03-09 21:16:36',NULL),(793,NULL,40719,5,2,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',291.14,NULL,NULL,1,'2021-03-09 21:16:37','2021-03-09 21:16:37',NULL);
INSERT INTO `balance_libro` VALUES (794,NULL,40719,5,2,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1560.00,NULL,NULL,1,'2021-03-09 21:16:38','2021-03-09 21:16:38',NULL),(795,NULL,40719,5,2,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',190.48,NULL,NULL,1,'2021-03-09 21:16:39','2021-03-09 21:16:39',NULL),(796,NULL,40719,5,2,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',132.80,NULL,NULL,1,'2021-03-09 21:16:41','2021-03-09 21:16:41',NULL),(797,NULL,40719,5,2,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',120.00,NULL,NULL,1,'2021-03-09 21:16:41','2021-03-09 21:16:41',NULL),(798,NULL,40719,5,2,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',240.00,NULL,NULL,1,'2021-03-09 21:16:42','2021-03-09 21:16:42',NULL),(799,NULL,40719,5,2,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',200.00,NULL,NULL,1,'2021-03-09 21:16:44','2021-03-09 21:16:44',NULL),(800,NULL,40719,5,2,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',40.00,NULL,NULL,1,'2021-03-09 21:16:45','2021-03-09 21:16:45',NULL),(801,NULL,40719,5,2,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',400.00,NULL,NULL,1,'2021-03-09 21:16:46','2021-03-09 21:16:46',NULL),(802,NULL,40719,5,2,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',160.00,NULL,NULL,1,'2021-03-09 21:16:47','2021-03-09 21:16:47',NULL),(803,NULL,40719,5,2,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1640.00,NULL,NULL,1,'2021-03-09 21:16:48','2021-03-09 21:16:48',NULL),(804,NULL,40719,5,2,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',80.00,NULL,NULL,1,'2021-03-09 21:16:49','2021-03-09 21:16:49',NULL),(805,NULL,40719,5,2,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',80.00,NULL,NULL,1,'2021-03-09 21:16:50','2021-03-09 21:16:50',NULL),(806,NULL,40719,5,2,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',360.00,NULL,NULL,1,'2021-03-09 21:16:51','2021-03-09 21:16:51',NULL),(807,NULL,40719,5,2,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1000.00,NULL,NULL,1,'2021-03-09 21:16:52','2021-03-09 21:16:52',NULL),(808,NULL,40719,5,2,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1200.00,NULL,NULL,1,'2021-03-09 21:16:53','2021-03-09 21:16:53',NULL),(809,NULL,40719,5,2,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',400.00,NULL,NULL,1,'2021-03-09 21:16:55','2021-03-09 21:16:55',NULL),(810,NULL,40719,5,2,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',20.00,NULL,NULL,1,'2021-03-09 21:16:56','2021-03-09 21:16:56',NULL),(811,NULL,40719,5,2,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1862.92,NULL,NULL,1,'2021-03-09 21:16:58','2021-03-09 21:16:58',NULL),(812,NULL,40719,5,2,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',60.00,NULL,NULL,1,'2021-03-09 21:16:59','2021-03-09 21:16:59',NULL),(813,NULL,40719,5,2,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',280.00,NULL,NULL,1,'2021-03-09 21:17:00','2021-03-09 21:17:00',NULL),(814,NULL,40719,5,2,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',96.00,NULL,NULL,1,'2021-03-09 21:17:01','2021-03-09 21:17:01',NULL),(815,NULL,40719,5,2,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',200.00,NULL,NULL,1,'2021-03-09 21:17:02','2021-03-09 21:17:02',NULL);
INSERT INTO `balance_libro` VALUES (816,NULL,40719,5,2,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',200.00,NULL,NULL,1,'2021-03-09 21:17:03','2021-03-09 21:17:03',NULL),(817,NULL,40719,5,2,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',186.36,NULL,NULL,1,'2021-03-09 21:17:04','2021-03-09 21:17:04',NULL),(818,NULL,40719,5,2,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',100.00,NULL,NULL,1,'2021-03-09 21:17:05','2021-03-09 21:17:05',NULL),(819,NULL,40719,5,2,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',80.00,NULL,NULL,1,'2021-03-09 21:17:06','2021-03-09 21:17:06',NULL),(820,NULL,40719,5,2,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',40.00,NULL,NULL,1,'2021-03-09 21:17:08','2021-03-09 21:17:08',NULL),(821,NULL,40719,5,2,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',100.00,NULL,NULL,1,'2021-03-09 21:17:09','2021-03-09 21:17:09',NULL),(822,NULL,40719,5,2,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',52.00,NULL,NULL,1,'2021-03-09 21:17:10','2021-03-09 21:17:10',NULL),(823,NULL,40719,5,2,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',240.00,NULL,NULL,1,'2021-03-09 21:17:11','2021-03-09 21:17:11',NULL),(824,NULL,40719,5,2,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',80.00,NULL,NULL,1,'2021-03-09 21:17:12','2021-03-09 21:17:12',NULL),(825,NULL,40719,5,2,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',20.00,NULL,NULL,1,'2021-03-09 21:17:13','2021-03-09 21:17:13',NULL),(826,NULL,40719,5,2,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',200.00,NULL,NULL,1,'2021-03-09 21:17:14','2021-03-09 21:17:14',NULL),(827,NULL,40719,5,2,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',23.60,NULL,NULL,1,'2021-03-09 21:17:15','2021-03-09 21:17:15',NULL),(828,NULL,40719,5,2,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',320.00,NULL,NULL,1,'2021-03-09 21:17:16','2021-03-09 21:17:16',NULL),(829,NULL,40719,5,2,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',507.32,NULL,NULL,1,'2021-03-09 21:17:17','2021-03-09 21:17:17',NULL),(830,NULL,40719,5,2,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',200.00,NULL,NULL,1,'2021-03-09 21:17:19','2021-03-09 21:17:19',NULL),(831,NULL,40719,5,2,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1200.00,NULL,NULL,1,'2021-03-09 21:17:20','2021-03-09 21:17:20',NULL),(832,NULL,40719,5,2,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',975.60,NULL,NULL,1,'2021-03-09 21:17:21','2021-03-09 21:17:21',NULL),(833,NULL,40719,5,2,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',185.36,NULL,NULL,1,'2021-03-09 21:17:22','2021-03-09 21:17:22',NULL),(834,NULL,40719,5,2,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',80.00,NULL,NULL,1,'2021-03-09 21:17:23','2021-03-09 21:17:23',NULL),(835,NULL,40719,5,2,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1360.00,NULL,NULL,1,'2021-03-09 21:17:24','2021-03-09 21:17:24',NULL),(836,NULL,40719,5,2,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',72.00,NULL,NULL,1,'2021-03-09 21:17:25','2021-03-09 21:17:25',NULL),(837,NULL,40719,5,2,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1080.00,NULL,NULL,1,'2021-03-09 21:17:26','2021-03-09 21:17:26',NULL);
INSERT INTO `balance_libro` VALUES (838,NULL,40719,5,2,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',2000.00,NULL,NULL,1,'2021-03-09 21:17:27','2021-03-09 21:17:27',NULL),(839,NULL,40719,5,2,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',84.00,NULL,NULL,1,'2021-03-09 21:17:28','2021-03-09 21:17:28',NULL),(840,NULL,40719,5,2,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',70.12,NULL,NULL,1,'2021-03-09 21:17:30','2021-03-09 21:17:30',NULL),(841,NULL,40719,5,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1680.00,NULL,NULL,1,'2021-03-09 21:17:31','2021-03-09 21:17:31',NULL),(842,NULL,40719,5,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',20.00,NULL,NULL,1,'2021-03-09 21:17:32','2021-03-09 21:17:32',NULL),(843,NULL,40719,5,2,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',6400.00,NULL,NULL,1,'2021-03-09 21:17:33','2021-03-09 21:17:33',NULL),(844,NULL,40719,5,2,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',200.00,NULL,NULL,1,'2021-03-09 21:17:35','2021-03-09 21:17:35',NULL),(845,NULL,40719,5,2,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',40.00,NULL,NULL,1,'2021-03-09 21:17:36','2021-03-09 21:17:36',NULL),(846,NULL,40719,5,2,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1469.68,NULL,NULL,1,'2021-03-09 21:17:37','2021-03-09 21:17:37',NULL),(847,NULL,40719,5,2,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',200.00,NULL,NULL,1,'2021-03-09 21:17:38','2021-03-09 21:17:38',NULL),(848,NULL,40719,5,2,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',80.00,NULL,NULL,1,'2021-03-09 21:17:39','2021-03-09 21:17:39',NULL),(849,NULL,40719,5,2,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',140.00,NULL,NULL,1,'2021-03-09 21:17:40','2021-03-09 21:17:40',NULL),(850,NULL,40719,5,2,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1720.00,NULL,NULL,1,'2021-03-09 21:17:41','2021-03-09 21:17:41',NULL),(851,NULL,40719,5,2,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',195.12,NULL,NULL,1,'2021-03-09 21:17:42','2021-03-09 21:17:42',NULL),(852,NULL,40719,5,2,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',800.00,NULL,NULL,1,'2021-03-09 21:17:43','2021-03-09 21:17:43',NULL),(853,NULL,40719,5,2,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1759.96,NULL,NULL,1,'2021-03-09 21:17:44','2021-03-09 21:17:44',NULL),(854,NULL,40719,5,2,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',560.00,NULL,NULL,1,'2021-03-09 21:17:45','2021-03-09 21:17:45',NULL),(855,NULL,40719,5,2,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',8200.00,NULL,NULL,1,'2021-03-09 21:17:46','2021-03-09 21:17:46',NULL),(856,NULL,40719,5,2,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',200.00,NULL,NULL,1,'2021-03-09 21:17:47','2021-03-09 21:17:47',NULL),(857,NULL,40719,5,2,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',720.00,NULL,NULL,1,'2021-03-09 21:17:48','2021-03-09 21:17:48',NULL),(858,NULL,40719,5,2,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',280.00,NULL,NULL,1,'2021-03-09 21:17:49','2021-03-09 21:17:49',NULL),(859,NULL,40719,5,2,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',320.00,NULL,NULL,1,'2021-03-09 21:17:50','2021-03-09 21:17:50',NULL);
INSERT INTO `balance_libro` VALUES (860,NULL,40719,5,2,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',88.00,NULL,NULL,1,'2021-03-09 21:17:51','2021-03-09 21:17:51',NULL),(861,NULL,40719,5,2,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',200.00,NULL,NULL,1,'2021-04-10 02:44:35','2021-04-10 02:44:35',NULL),(862,NULL,40719,6,2,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',472.00,NULL,NULL,1,'2021-05-10 22:29:09','2021-05-10 22:29:09',NULL),(863,2670,40719,6,2,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',472.00,NULL,NULL,1,'2021-05-10 22:45:00','2021-05-10 22:45:00',NULL),(864,2670,40719,6,2,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',153.40,NULL,NULL,1,'2021-05-10 22:45:02','2021-05-10 22:45:02',NULL),(865,2670,40719,6,2,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1581.20,NULL,NULL,1,'2021-05-10 22:45:03','2021-05-10 22:45:03',NULL),(866,2670,40719,6,2,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1416.00,NULL,NULL,1,'2021-05-10 22:45:04','2021-05-10 22:45:04',NULL),(867,2670,40719,6,2,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',944.00,NULL,NULL,1,'2021-05-10 22:45:05','2021-05-10 22:45:05',NULL),(868,2670,40719,6,2,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',11238.08,NULL,NULL,1,'2021-05-10 22:45:05','2021-05-10 22:45:05',NULL),(869,2670,40719,6,2,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',11238.08,NULL,NULL,1,'2021-05-10 22:45:06','2021-05-10 22:45:06',NULL),(870,2670,40719,6,2,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',21238.08,NULL,NULL,1,'2021-05-10 22:49:12','2021-05-10 22:49:12',NULL),(871,2670,40719,6,2,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',10180.00,NULL,NULL,1,'2021-05-10 22:49:14','2021-05-10 22:49:14',NULL),(872,2670,40719,6,2,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',5590.00,NULL,NULL,1,'2021-05-10 22:49:15','2021-05-10 22:49:15',NULL),(873,2670,40719,6,2,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',3180.00,NULL,NULL,1,'2021-05-10 22:49:16','2021-05-10 22:49:16',NULL),(874,2670,40719,6,2,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4832.00,NULL,NULL,1,'2021-05-10 22:49:16','2021-05-10 22:49:16',NULL),(875,2670,40719,6,2,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2902.80,NULL,NULL,1,'2021-05-10 22:49:18','2021-05-10 22:49:18',NULL),(876,2670,40719,6,2,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4888.00,NULL,NULL,1,'2021-05-10 22:49:19','2021-05-10 22:49:19',NULL),(877,2670,40719,6,2,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4413.20,NULL,NULL,1,'2021-05-10 22:49:19','2021-05-10 22:49:19',NULL),(878,2670,40719,6,2,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',5077.60,NULL,NULL,1,'2021-05-10 22:49:20','2021-05-10 22:49:20',NULL),(879,2670,40719,6,2,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',5870.26,NULL,NULL,1,'2021-05-10 22:49:21','2021-05-10 22:49:21',NULL),(880,2670,40719,6,2,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',1684.40,NULL,NULL,1,'2021-05-10 22:55:59','2021-05-10 22:55:59',NULL);
INSERT INTO `balance_libro` VALUES (881,2670,40719,6,2,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',8650.00,NULL,NULL,1,'2021-05-10 22:56:01','2021-05-10 22:56:01',NULL),(882,2670,40719,6,2,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',17320.00,NULL,NULL,1,'2021-05-10 22:56:02','2021-05-10 22:56:02',NULL),(883,2670,40719,6,2,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',10000.00,NULL,NULL,1,'2021-05-10 22:56:03','2021-05-10 22:56:03',NULL),(884,2670,40719,6,2,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2360.00,NULL,NULL,1,'2021-05-10 22:56:03','2021-05-10 22:56:03',NULL),(885,2670,40719,6,2,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2400.00,NULL,NULL,1,'2021-05-10 22:56:04','2021-05-10 22:56:04',NULL),(886,2670,40719,6,2,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',3540.00,NULL,NULL,1,'2021-05-10 22:56:05','2021-05-10 22:56:05',NULL),(887,2670,40719,6,2,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',6100.00,NULL,NULL,1,'2021-05-10 22:56:06','2021-05-10 22:56:06',NULL),(888,2670,40719,6,2,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',13500.00,NULL,NULL,1,'2021-05-10 22:56:07','2021-05-10 22:56:07',NULL),(889,2670,40719,6,2,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',16951.00,NULL,NULL,1,'2021-05-10 22:56:08','2021-05-10 22:56:08',NULL),(890,2670,40719,8,2,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',11684.40,NULL,NULL,1,'2021-06-10 21:06:05','2021-06-10 21:06:05',NULL),(891,2670,40719,8,2,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',9650.00,NULL,NULL,1,'2021-06-10 21:06:33','2021-06-10 21:06:33',NULL),(892,2670,40719,8,2,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',17320.00,NULL,NULL,1,'2021-06-10 21:06:34','2021-06-10 21:06:34',NULL),(893,2670,40719,8,2,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',10000.00,NULL,NULL,1,'2021-06-10 21:06:34','2021-06-10 21:06:34',NULL),(894,2670,40719,8,2,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',12360.00,NULL,NULL,1,'2021-06-10 21:06:35','2021-06-10 21:06:35',NULL),(895,2670,40719,8,2,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',17400.00,NULL,NULL,1,'2021-06-10 21:06:36','2021-06-10 21:06:36',NULL),(896,2670,40719,8,2,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',8540.00,NULL,NULL,1,'2021-06-10 21:06:37','2021-06-10 21:06:37',NULL),(897,2670,40719,8,2,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',9100.00,NULL,NULL,1,'2021-06-10 21:06:38','2021-06-10 21:06:38',NULL),(898,2670,40719,8,2,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',13500.00,NULL,NULL,1,'2021-06-10 21:06:39','2021-06-10 21:06:39',NULL),(899,2670,40719,8,2,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',16951.00,NULL,NULL,1,'2021-06-10 21:06:40','2021-06-10 21:06:40',NULL),(900,2670,40719,8,2,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',11238.08,NULL,NULL,1,'2021-06-10 21:12:54','2021-06-10 21:12:54',NULL),(901,2670,40719,8,2,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',11180.00,NULL,NULL,1,'2021-06-10 21:12:56','2021-06-10 21:12:56',NULL);
INSERT INTO `balance_libro` VALUES (902,2670,40719,8,2,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',590.00,NULL,NULL,1,'2021-06-10 21:12:56','2021-06-10 21:12:56',NULL),(903,2670,40719,8,2,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1180.00,NULL,NULL,1,'2021-06-10 21:12:57','2021-06-10 21:12:57',NULL),(904,2670,40719,8,2,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',2832.00,NULL,NULL,1,'2021-06-10 21:12:58','2021-06-10 21:12:58',NULL),(905,2670,40719,8,2,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',2902.80,NULL,NULL,1,'2021-06-10 21:12:59','2021-06-10 21:12:59',NULL),(906,2670,40719,8,2,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1888.00,NULL,NULL,1,'2021-06-10 21:13:00','2021-06-10 21:13:00',NULL),(907,2670,40719,8,2,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4413.20,NULL,NULL,1,'2021-06-10 21:13:01','2021-06-10 21:13:01',NULL),(908,2670,40719,8,2,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',377.60,NULL,NULL,1,'2021-06-10 21:13:02','2021-06-10 21:13:02',NULL),(909,2670,40719,8,2,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',5870.26,NULL,NULL,1,'2021-06-10 21:13:02','2021-06-10 21:13:02',NULL),(910,2670,40719,9,2,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',13238.08,NULL,NULL,1,'2021-07-08 19:46:33','2021-07-08 19:46:33',NULL),(911,2670,40719,9,2,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',11180.00,NULL,NULL,1,'2021-07-08 19:46:37','2021-07-08 19:46:37',NULL),(912,2670,40719,9,2,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',5590.00,NULL,NULL,1,'2021-07-08 19:46:39','2021-07-08 19:46:39',NULL),(913,2670,40719,9,2,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',10180.00,NULL,NULL,1,'2021-07-08 19:46:40','2021-07-08 19:46:40',NULL),(914,2670,40719,9,2,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',12832.00,NULL,NULL,1,'2021-07-08 19:46:41','2021-07-08 19:46:41',NULL),(915,2670,40719,9,2,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',12902.80,NULL,NULL,1,'2021-07-08 19:46:42','2021-07-08 19:46:42',NULL),(916,2670,40719,9,2,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',13888.00,NULL,NULL,1,'2021-07-08 19:46:43','2021-07-08 19:46:43',NULL),(917,2670,40719,9,2,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',10743.20,NULL,NULL,1,'2021-07-08 19:46:44','2021-07-08 19:46:44',NULL),(918,2670,40719,9,2,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',12377.60,NULL,NULL,1,'2021-07-08 19:46:45','2021-07-08 19:46:45',NULL),(919,2670,40719,9,2,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',15870.26,NULL,NULL,1,'2021-07-08 19:46:46','2021-07-08 19:46:46',NULL),(920,NULL,40719,9,2,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',11238.00,NULL,NULL,1,'2021-07-10 01:26:21','2021-07-10 01:26:21',NULL),(921,NULL,40719,9,2,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1180.00,NULL,NULL,1,'2021-07-10 01:26:24','2021-07-10 01:26:24',NULL),(922,NULL,40719,9,2,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',590.00,NULL,NULL,1,'2021-07-10 01:26:25','2021-07-10 01:26:25',NULL);
INSERT INTO `balance_libro` VALUES (923,NULL,40719,9,2,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1180.00,NULL,NULL,1,'2021-07-10 01:26:26','2021-07-10 01:26:26',NULL),(924,NULL,40719,9,2,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2832.00,NULL,NULL,1,'2021-07-10 01:26:27','2021-07-10 01:26:27',NULL),(925,NULL,40719,9,2,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2902.00,NULL,NULL,1,'2021-07-10 01:26:27','2021-07-10 01:26:27',NULL),(926,NULL,40719,9,2,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1888.00,NULL,NULL,1,'2021-07-10 01:26:29','2021-07-10 01:26:29',NULL),(927,NULL,40719,9,2,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4413.00,NULL,NULL,1,'2021-07-10 01:26:30','2021-07-10 01:26:30',NULL),(928,NULL,40719,9,2,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3077.00,NULL,NULL,1,'2021-07-10 01:26:30','2021-07-10 01:26:30',NULL),(929,NULL,40719,9,2,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',5870.00,NULL,NULL,1,'2021-07-10 01:26:31','2021-07-10 01:26:31',NULL),(930,NULL,40719,9,2,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',25444.00,NULL,NULL,1,'2021-07-10 01:26:32','2021-07-10 01:26:32',NULL),(931,NULL,40719,9,2,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',10411.00,NULL,NULL,1,'2021-07-10 01:26:33','2021-07-10 01:26:33',NULL),(932,NULL,40719,9,2,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',5482.00,NULL,NULL,1,'2021-07-10 01:26:34','2021-07-10 01:26:34',NULL),(933,NULL,40719,9,2,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2114.00,NULL,NULL,1,'2021-07-10 01:26:35','2021-07-10 01:26:35',NULL),(934,NULL,40719,9,2,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3147.00,NULL,NULL,1,'2021-07-10 01:26:36','2021-07-10 01:26:36',NULL),(935,NULL,40719,9,2,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',6547.00,NULL,NULL,1,'2021-07-10 01:26:37','2021-07-10 01:26:37',NULL),(936,NULL,40719,9,2,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',8546.00,NULL,NULL,1,'2021-07-10 01:26:38','2021-07-10 01:26:38',NULL),(937,NULL,40719,9,2,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',6574.00,NULL,NULL,1,'2021-07-10 01:26:39','2021-07-10 01:26:39',NULL),(938,NULL,40719,9,2,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',891.00,NULL,NULL,1,'2021-07-10 01:26:40','2021-07-10 01:26:40',NULL),(939,NULL,40719,9,2,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',7531.00,NULL,NULL,1,'2021-07-10 01:26:41','2021-07-10 01:26:41',NULL),(940,NULL,40719,9,2,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',6741.00,NULL,NULL,1,'2021-07-10 01:26:41','2021-07-10 01:26:41',NULL),(941,NULL,40719,9,2,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1203.00,NULL,NULL,1,'2021-07-10 01:26:42','2021-07-10 01:26:42',NULL),(942,NULL,40719,9,2,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',11238.00,NULL,NULL,1,'2021-07-10 01:30:49','2021-07-10 01:30:49',NULL),(943,NULL,40719,9,2,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1180.00,NULL,NULL,1,'2021-07-10 01:30:50','2021-07-10 01:30:50',NULL);
INSERT INTO `balance_libro` VALUES (944,NULL,40719,9,2,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',590.00,NULL,NULL,1,'2021-07-10 01:30:51','2021-07-10 01:30:51',NULL),(945,NULL,40719,9,2,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1180.00,NULL,NULL,1,'2021-07-10 01:30:52','2021-07-10 01:30:52',NULL),(946,NULL,40719,9,2,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2832.00,NULL,NULL,1,'2021-07-10 01:30:53','2021-07-10 01:30:53',NULL),(947,NULL,40719,9,2,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2902.00,NULL,NULL,1,'2021-07-10 01:30:54','2021-07-10 01:30:54',NULL),(948,NULL,40719,9,2,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1888.00,NULL,NULL,1,'2021-07-10 01:30:55','2021-07-10 01:30:55',NULL),(949,NULL,40719,9,2,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4413.00,NULL,NULL,1,'2021-07-10 01:30:55','2021-07-10 01:30:55',NULL),(950,NULL,40719,9,2,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3077.00,NULL,NULL,1,'2021-07-10 01:30:56','2021-07-10 01:30:56',NULL),(951,NULL,40719,9,2,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',5870.00,NULL,NULL,1,'2021-07-10 01:30:57','2021-07-10 01:30:57',NULL),(952,NULL,40719,9,2,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',25444.00,NULL,NULL,1,'2021-07-10 01:30:58','2021-07-10 01:30:58',NULL),(953,NULL,40719,9,2,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',10411.00,NULL,NULL,1,'2021-07-10 01:30:59','2021-07-10 01:30:59',NULL),(954,NULL,40719,9,2,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',5482.00,NULL,NULL,1,'2021-07-10 01:31:00','2021-07-10 01:31:00',NULL),(955,NULL,40719,9,2,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2114.00,NULL,NULL,1,'2021-07-10 01:31:00','2021-07-10 01:31:00',NULL),(956,NULL,40719,9,2,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3147.00,NULL,NULL,1,'2021-07-10 01:31:01','2021-07-10 01:31:01',NULL),(957,NULL,40719,9,2,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',6547.00,NULL,NULL,1,'2021-07-10 01:31:02','2021-07-10 01:31:02',NULL),(958,NULL,40719,9,2,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',8546.00,NULL,NULL,1,'2021-07-10 01:31:03','2021-07-10 01:31:03',NULL),(959,NULL,40719,9,2,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',6574.00,NULL,NULL,1,'2021-07-10 01:31:04','2021-07-10 01:31:04',NULL),(960,NULL,40719,9,2,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',891.00,NULL,NULL,1,'2021-07-10 01:31:04','2021-07-10 01:31:04',NULL),(961,NULL,40719,9,2,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',7531.00,NULL,NULL,1,'2021-07-10 01:31:05','2021-07-10 01:31:05',NULL),(962,NULL,40719,9,2,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',6741.00,NULL,NULL,1,'2021-07-10 01:31:06','2021-07-10 01:31:06',NULL),(963,NULL,40719,9,2,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1203.00,NULL,NULL,1,'2021-07-10 01:31:07','2021-07-10 01:31:07',NULL),(964,NULL,40719,9,2,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1238.00,NULL,NULL,1,'2021-07-10 01:35:23','2021-07-10 01:35:23',NULL);
INSERT INTO `balance_libro` VALUES (965,NULL,40719,9,2,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',180.00,NULL,NULL,1,'2021-07-10 01:35:25','2021-07-10 01:35:25',NULL),(966,NULL,40719,9,2,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',590.00,NULL,NULL,1,'2021-07-10 01:35:26','2021-07-10 01:35:26',NULL),(967,NULL,40719,9,2,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',180.00,NULL,NULL,1,'2021-07-10 01:35:27','2021-07-10 01:35:27',NULL),(968,NULL,40719,9,2,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2832.00,NULL,NULL,1,'2021-07-10 01:35:27','2021-07-10 01:35:27',NULL),(969,NULL,40719,9,2,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2902.00,NULL,NULL,1,'2021-07-10 01:35:28','2021-07-10 01:35:28',NULL),(970,NULL,40719,9,2,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1888.00,NULL,NULL,1,'2021-07-10 01:35:29','2021-07-10 01:35:29',NULL),(971,NULL,40719,9,2,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4413.00,NULL,NULL,1,'2021-07-10 01:35:30','2021-07-10 01:35:30',NULL),(972,NULL,40719,9,2,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3077.00,NULL,NULL,1,'2021-07-10 01:35:30','2021-07-10 01:35:30',NULL),(973,NULL,40719,9,2,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',5870.00,NULL,NULL,1,'2021-07-10 01:35:31','2021-07-10 01:35:31',NULL),(974,NULL,40719,9,2,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2444.00,NULL,NULL,1,'2021-07-10 01:35:32','2021-07-10 01:35:32',NULL),(975,NULL,40719,9,2,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1411.00,NULL,NULL,1,'2021-07-10 01:35:33','2021-07-10 01:35:33',NULL),(976,NULL,40719,9,2,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1482.00,NULL,NULL,1,'2021-07-10 01:35:33','2021-07-10 01:35:33',NULL),(977,NULL,40719,9,2,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2114.00,NULL,NULL,1,'2021-07-10 01:35:34','2021-07-10 01:35:34',NULL),(978,NULL,40719,9,2,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3147.00,NULL,NULL,1,'2021-07-10 01:35:35','2021-07-10 01:35:35',NULL),(979,NULL,40719,9,2,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',5247.00,NULL,NULL,1,'2021-07-10 01:35:36','2021-07-10 01:35:36',NULL),(980,NULL,40719,9,2,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',5246.00,NULL,NULL,1,'2021-07-10 01:35:36','2021-07-10 01:35:36',NULL),(981,NULL,40719,9,2,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1174.00,NULL,NULL,1,'2021-07-10 01:35:37','2021-07-10 01:35:37',NULL),(982,NULL,40719,9,2,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',891.00,NULL,NULL,1,'2021-07-10 01:35:38','2021-07-10 01:35:38',NULL),(983,NULL,40719,9,2,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1531.00,NULL,NULL,1,'2021-07-10 01:35:39','2021-07-10 01:35:39',NULL),(984,NULL,40719,9,2,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1741.00,NULL,NULL,1,'2021-07-10 01:35:39','2021-07-10 01:35:39',NULL),(985,NULL,40719,9,2,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1203.00,NULL,NULL,1,'2021-07-10 01:35:40','2021-07-10 01:35:40',NULL);
INSERT INTO `balance_libro` VALUES (986,NULL,40719,11,2,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',390.00,NULL,NULL,1,'2021-09-09 18:02:18','2021-09-09 18:02:18',NULL),(987,NULL,40719,11,2,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',953.00,NULL,NULL,1,'2021-09-09 18:02:21','2021-09-09 18:02:21',NULL),(988,NULL,40719,11,2,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',740.00,NULL,NULL,1,'2021-09-09 18:02:22','2021-09-09 18:02:22',NULL),(989,NULL,40719,11,2,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1560.00,NULL,NULL,1,'2021-09-09 18:02:22','2021-09-09 18:02:22',NULL),(990,NULL,40719,11,2,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1490.00,NULL,NULL,1,'2021-09-09 18:02:23','2021-09-09 18:02:23',NULL),(991,NULL,40719,11,2,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',3000.00,NULL,NULL,1,'2021-09-09 18:02:24','2021-09-09 18:02:24',NULL),(992,NULL,40719,11,2,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',527.00,NULL,NULL,1,'2021-09-09 18:02:25','2021-09-09 18:02:25',NULL),(993,NULL,40719,11,2,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',840.00,NULL,NULL,1,'2021-09-09 18:02:26','2021-09-09 18:02:26',NULL),(994,NULL,40719,11,2,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1500.00,NULL,NULL,1,'2021-09-09 18:02:27','2021-09-09 18:02:27',NULL),(995,NULL,40719,11,2,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',2000.00,NULL,NULL,1,'2021-09-09 18:02:28','2021-09-09 18:02:28',NULL),(996,NULL,40719,11,2,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1580.00,NULL,NULL,1,'2021-09-09 18:02:29','2021-09-09 18:02:29',NULL),(997,NULL,40719,11,2,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1580.00,NULL,NULL,1,'2021-09-09 18:02:30','2021-09-09 18:02:30',NULL),(998,NULL,40719,11,2,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',950.00,NULL,NULL,1,'2021-09-09 18:02:31','2021-09-09 18:02:31',NULL),(999,NULL,40719,11,2,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',378.00,NULL,NULL,1,'2021-09-09 18:02:32','2021-09-09 18:02:32',NULL),(1000,NULL,40719,11,2,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',951.00,NULL,NULL,1,'2021-09-09 18:02:32','2021-09-09 18:02:32',NULL),(1001,NULL,40719,11,2,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',752.00,NULL,NULL,1,'2021-09-09 18:02:33','2021-09-09 18:02:33',NULL),(1002,NULL,40719,11,2,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1200.00,NULL,NULL,1,'2021-09-09 18:02:34','2021-09-09 18:02:34',NULL),(1003,NULL,40719,11,2,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',2000.00,NULL,NULL,1,'2021-09-09 18:02:35','2021-09-09 18:02:35',NULL),(1004,NULL,40719,11,2,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',380.00,NULL,NULL,1,'2021-09-09 18:02:36','2021-09-09 18:02:36',NULL),(1005,NULL,40719,11,2,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1800.00,NULL,NULL,1,'2021-09-09 18:02:37','2021-09-09 18:02:37',NULL),(1006,NULL,40719,11,2,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1720.00,NULL,NULL,1,'2021-09-09 18:02:38','2021-09-09 18:02:38',NULL);
INSERT INTO `balance_libro` VALUES (1007,NULL,40719,11,2,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1690.00,NULL,NULL,1,'2021-09-09 18:02:38','2021-09-09 18:02:38',NULL),(1008,2670,40719,11,2,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',390.00,NULL,NULL,1,'2021-09-09 18:35:12','2021-09-09 18:35:12',NULL),(1009,2670,40719,11,2,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',953.00,NULL,NULL,1,'2021-09-09 18:35:14','2021-09-09 18:35:14',NULL),(1010,2670,40719,11,2,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',740.00,NULL,NULL,1,'2021-09-09 18:35:15','2021-09-09 18:35:15',NULL),(1011,2670,40719,11,2,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1560.00,NULL,NULL,1,'2021-09-09 18:35:15','2021-09-09 18:35:15',NULL),(1012,2670,40719,11,2,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',1490.00,NULL,NULL,1,'2021-09-09 18:35:16','2021-09-09 18:35:16',NULL),(1013,2670,40719,11,2,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',3000.00,NULL,NULL,1,'2021-09-09 18:35:17','2021-09-09 18:35:17',NULL),(1014,2670,40719,11,2,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',527.00,NULL,NULL,1,'2021-09-09 18:35:18','2021-09-09 18:35:18',NULL),(1015,2670,40719,11,2,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',3900.00,NULL,NULL,1,'2021-09-09 18:41:38','2021-09-09 18:41:38',NULL),(1016,2670,40719,11,2,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',953.00,NULL,NULL,1,'2021-09-09 18:41:40','2021-09-09 18:41:40',NULL),(1017,2670,40719,11,2,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',740.00,NULL,NULL,1,'2021-09-09 18:41:41','2021-09-09 18:41:41',NULL),(1018,2670,40719,11,2,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',390.00,NULL,NULL,1,'2021-09-09 18:54:13','2021-09-09 18:54:13',NULL),(1019,2670,40719,11,2,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',953.00,NULL,NULL,1,'2021-09-09 18:54:15','2021-09-09 18:54:15',NULL),(1020,2670,40719,11,2,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09','2021-09-09',740.00,NULL,NULL,1,'2021-09-09 18:54:16','2021-09-09 18:54:16',NULL),(1021,2670,40719,11,2,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',390.00,NULL,NULL,1,'2021-09-10 15:56:19','2021-09-10 15:56:19',NULL),(1022,2670,40719,11,2,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',953.00,NULL,NULL,1,'2021-09-10 15:56:23','2021-09-10 15:56:23',NULL),(1023,2670,40719,11,2,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',740.00,NULL,NULL,1,'2021-09-10 15:56:23','2021-09-10 15:56:23',NULL),(1024,2670,40719,11,2,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',390.00,NULL,NULL,1,'2021-09-10 16:00:26','2021-09-10 16:00:26',NULL),(1025,2670,40719,11,2,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',953.00,NULL,NULL,1,'2021-09-10 16:00:50','2021-09-10 16:00:50',NULL),(1026,2670,40719,11,2,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',740.00,NULL,NULL,1,'2021-09-10 16:00:52','2021-09-10 16:00:52',NULL),(1027,NULL,40719,12,2,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',5440.00,NULL,NULL,1,'2021-10-08 06:44:35','2021-10-08 06:44:35',NULL);
INSERT INTO `balance_libro` VALUES (1028,NULL,40719,12,2,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',560.00,NULL,NULL,1,'2021-10-08 06:44:39','2021-10-08 06:44:39',NULL),(1029,NULL,40719,12,2,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',1500.00,NULL,NULL,1,'2021-10-08 06:44:40','2021-10-08 06:44:40',NULL),(1030,NULL,40719,12,2,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',520.00,NULL,NULL,1,'2021-10-08 06:44:42','2021-10-08 06:44:42',NULL),(1031,NULL,40719,12,2,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',2540.00,NULL,NULL,1,'2021-10-08 06:44:43','2021-10-08 06:44:43',NULL),(1032,NULL,40719,12,2,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',3100.00,NULL,NULL,1,'2021-10-08 06:44:44','2021-10-08 06:44:44',NULL),(1033,NULL,40719,12,2,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',2890.00,NULL,NULL,1,'2021-10-08 06:44:45','2021-10-08 06:44:45',NULL),(1034,NULL,40719,12,2,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',750.00,NULL,NULL,1,'2021-10-08 06:44:46','2021-10-08 06:44:46',NULL),(1035,NULL,40719,12,2,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',750.00,NULL,NULL,1,'2021-10-08 06:44:47','2021-10-08 06:44:47',NULL),(1036,NULL,40719,12,2,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',980.00,NULL,NULL,1,'2021-10-08 06:44:48','2021-10-08 06:44:48',NULL),(1037,NULL,40719,12,2,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',1522.00,NULL,NULL,1,'2021-10-08 06:44:49','2021-10-08 06:44:49',NULL),(1038,NULL,40719,12,2,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',6000.00,NULL,NULL,1,'2021-10-08 06:44:50','2021-10-08 06:44:50',NULL),(1039,NULL,40719,12,2,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',6410.00,NULL,NULL,1,'2021-10-08 06:44:51','2021-10-08 06:44:51',NULL),(1040,NULL,40719,12,2,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',4300.00,NULL,NULL,1,'2021-10-08 06:44:53','2021-10-08 06:44:53',NULL),(1041,NULL,40719,12,2,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',4290.00,NULL,NULL,1,'2021-10-08 06:44:54','2021-10-08 06:44:54',NULL),(1042,NULL,40719,12,2,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',780.00,NULL,NULL,1,'2021-10-08 06:44:55','2021-10-08 06:44:55',NULL),(1043,NULL,40719,12,2,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',933.00,NULL,NULL,1,'2021-10-08 06:44:56','2021-10-08 06:44:56',NULL),(1044,NULL,40719,12,2,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',1600.00,NULL,NULL,1,'2021-10-08 06:44:57','2021-10-08 06:44:57',NULL),(1045,NULL,40719,12,2,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',2300.00,NULL,NULL,1,'2021-10-08 06:44:58','2021-10-08 06:44:58',NULL),(1046,NULL,40719,12,2,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',4120.00,NULL,NULL,1,'2021-10-08 06:44:59','2021-10-08 06:44:59',NULL),(1047,NULL,40719,12,2,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',780.00,NULL,NULL,1,'2021-10-08 06:45:00','2021-10-08 06:45:00',NULL),(1048,NULL,40719,12,2,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',660.00,NULL,NULL,1,'2021-10-08 06:45:01','2021-10-08 06:45:01',NULL);
INSERT INTO `balance_libro` VALUES (1049,NULL,40719,12,2,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',5000.00,NULL,NULL,1,'2021-10-08 06:45:02','2021-10-08 06:45:02',NULL),(1050,NULL,40719,12,2,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',450.00,NULL,NULL,1,'2021-10-08 06:45:03','2021-10-08 06:45:03',NULL),(1051,NULL,40719,12,2,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',980.00,NULL,NULL,1,'2021-10-08 06:45:04','2021-10-08 06:45:04',NULL),(1052,NULL,40719,12,2,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',880.00,NULL,NULL,1,'2021-10-08 06:45:05','2021-10-08 06:45:05',NULL),(1053,NULL,40719,12,2,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',620.00,NULL,NULL,1,'2021-10-08 06:45:06','2021-10-08 06:45:06',NULL),(1054,NULL,40719,12,2,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',780.00,NULL,NULL,1,'2021-10-08 06:45:07','2021-10-08 06:45:07',NULL),(1055,NULL,40719,12,2,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',6300.00,NULL,NULL,1,'2021-10-08 06:45:08','2021-10-08 06:45:08',NULL),(1056,NULL,40719,12,2,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',3200.00,NULL,NULL,1,'2021-10-08 06:45:09','2021-10-08 06:45:09',NULL),(1057,NULL,40719,12,2,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',2800.00,NULL,NULL,1,'2021-10-08 06:45:10','2021-10-08 06:45:10',NULL),(1058,NULL,40719,12,2,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',1900.00,NULL,NULL,1,'2021-10-08 06:45:11','2021-10-08 06:45:11',NULL),(1059,NULL,40719,12,2,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',1900.00,NULL,NULL,1,'2021-10-08 06:45:12','2021-10-08 06:45:12',NULL),(1060,NULL,40719,12,2,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',890.00,NULL,NULL,1,'2021-10-08 06:45:13','2021-10-08 06:45:13',NULL),(1061,NULL,40719,12,2,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',4200.00,NULL,NULL,1,'2021-10-08 06:45:14','2021-10-08 06:45:14',NULL),(1062,NULL,40719,12,2,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',600.00,NULL,NULL,1,'2021-10-08 06:45:15','2021-10-08 06:45:15',NULL),(1063,NULL,40719,12,2,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',780.00,NULL,NULL,1,'2021-10-08 06:45:16','2021-10-08 06:45:16',NULL),(1064,NULL,40719,12,2,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',780.00,NULL,NULL,1,'2021-10-08 06:45:17','2021-10-08 06:45:17',NULL),(1065,NULL,40719,12,2,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',900.00,NULL,NULL,1,'2021-10-08 06:45:18','2021-10-08 06:45:18',NULL),(1066,NULL,40719,12,2,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',850.00,NULL,NULL,1,'2021-10-08 06:45:19','2021-10-08 06:45:19',NULL),(1067,NULL,40719,12,2,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',680.00,NULL,NULL,1,'2021-10-08 06:45:21','2021-10-08 06:45:21',NULL),(1068,NULL,40719,12,2,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',780.00,NULL,NULL,1,'2021-10-08 06:45:22','2021-10-08 06:45:22',NULL),(1069,NULL,40719,12,2,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',530.00,NULL,NULL,1,'2021-10-08 06:45:23','2021-10-08 06:45:23',NULL);
INSERT INTO `balance_libro` VALUES (1070,NULL,40719,12,2,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',2800.00,NULL,NULL,1,'2021-10-08 06:45:24','2021-10-08 06:45:24',NULL),(1071,NULL,40719,12,2,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',2800.00,NULL,NULL,1,'2021-10-08 06:45:25','2021-10-08 06:45:25',NULL),(1072,NULL,40719,12,2,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',3200.00,NULL,NULL,1,'2021-10-08 06:45:26','2021-10-08 06:45:26',NULL),(1073,NULL,40719,12,2,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',3600.00,NULL,NULL,1,'2021-10-08 06:45:27','2021-10-08 06:45:27',NULL),(1074,NULL,40719,12,2,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',490.00,NULL,NULL,1,'2021-10-08 06:45:28','2021-10-08 06:45:28',NULL),(1075,NULL,40719,12,2,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',6200.00,NULL,NULL,1,'2021-10-08 06:45:29','2021-10-08 06:45:29',NULL),(1076,NULL,40719,12,2,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',3800.00,NULL,NULL,1,'2021-10-08 06:45:30','2021-10-08 06:45:30',NULL),(1077,NULL,40719,12,2,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',980.00,NULL,NULL,1,'2021-10-08 06:45:31','2021-10-08 06:45:31',NULL),(1078,NULL,40719,12,2,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',1700.00,NULL,NULL,1,'2021-10-08 06:45:32','2021-10-08 06:45:32',NULL),(1079,NULL,40719,12,2,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',1700.00,NULL,NULL,1,'2021-10-08 06:45:33','2021-10-08 06:45:33',NULL),(1080,NULL,40719,12,2,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',4000.00,NULL,NULL,1,'2021-10-08 06:45:34','2021-10-08 06:45:34',NULL),(1081,NULL,40719,12,2,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',3600.00,NULL,NULL,1,'2021-10-08 06:45:35','2021-10-08 06:45:35',NULL),(1082,NULL,40719,12,2,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',3820.00,NULL,NULL,1,'2021-10-08 06:45:36','2021-10-08 06:45:36',NULL),(1083,NULL,40719,12,2,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',2700.00,NULL,NULL,1,'2021-10-08 06:45:37','2021-10-08 06:45:37',NULL),(1084,2670,40719,11,2,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',10684.40,NULL,NULL,1,'2021-10-10 22:24:09','2021-10-10 22:24:11','2021-10-10 22:24:11'),(1085,2670,40719,12,2,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',1684.40,NULL,NULL,1,'2021-11-10 22:57:16','2021-11-10 22:57:19','2021-11-10 22:57:19'),(1086,2670,40719,12,2,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',1684.40,NULL,NULL,1,'2021-11-10 22:58:48','2021-11-10 22:58:48',NULL),(1087,2670,40719,12,2,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',8650.00,NULL,NULL,1,'2021-11-10 22:58:50','2021-11-10 22:58:50',NULL),(1088,2670,40719,12,2,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',17320.00,NULL,NULL,1,'2021-11-10 22:58:51','2021-11-10 22:58:51',NULL),(1089,2670,40719,12,2,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',10000.00,NULL,NULL,1,'2021-11-10 22:58:52','2021-11-10 22:58:52',NULL),(1090,2670,40719,12,2,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2360.00,NULL,NULL,1,'2021-11-10 22:58:52','2021-11-10 22:58:52',NULL);
INSERT INTO `balance_libro` VALUES (1091,2670,40719,12,2,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',2400.00,NULL,NULL,1,'2021-11-10 22:58:53','2021-11-10 22:58:53',NULL),(1092,2670,40719,12,2,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',3540.00,NULL,NULL,1,'2021-11-10 22:58:54','2021-11-10 22:58:54',NULL),(1093,2670,40719,12,2,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',6100.00,NULL,NULL,1,'2021-11-10 22:58:55','2021-11-10 22:58:55',NULL),(1094,2670,40719,12,2,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',13500.00,NULL,NULL,1,'2021-11-10 22:58:56','2021-11-10 22:58:56',NULL),(1095,2670,40719,12,2,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',16951.00,NULL,NULL,1,'2021-11-10 22:58:56','2021-11-10 22:58:56',NULL),(1096,NULL,40719,13,2,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',32000.00,NULL,NULL,1,'2021-12-10 21:40:22','2021-12-10 21:40:25','2021-12-10 21:40:25'),(1097,NULL,40719,13,2,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',32000.00,NULL,NULL,1,'2021-12-10 21:45:02','2021-12-10 21:45:04','2021-12-10 21:45:04'),(1098,NULL,40719,13,2,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',32000.00,NULL,NULL,1,'2021-12-10 21:50:09','2021-12-10 21:50:09',NULL),(1099,NULL,40719,13,2,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',18000.00,NULL,NULL,1,'2021-12-10 21:50:11','2021-12-10 21:50:11',NULL),(1100,NULL,40719,13,2,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',5200.00,NULL,NULL,1,'2021-12-10 21:50:11','2021-12-10 21:50:11',NULL),(1101,NULL,40719,13,2,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1200.00,NULL,NULL,1,'2021-12-10 21:50:12','2021-12-10 21:50:12',NULL),(1102,NULL,40719,13,2,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3700.00,NULL,NULL,1,'2021-12-10 21:50:13','2021-12-10 21:50:13',NULL),(1103,NULL,40719,13,2,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',27000.00,NULL,NULL,1,'2021-12-10 21:50:14','2021-12-10 21:50:14',NULL),(1104,NULL,40719,13,2,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',17000.00,NULL,NULL,1,'2021-12-10 21:50:14','2021-12-10 21:50:14',NULL),(1105,NULL,40719,13,2,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3000.00,NULL,NULL,1,'2021-12-10 21:50:15','2021-12-10 21:50:15',NULL),(1106,NULL,40719,13,2,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1800.00,NULL,NULL,1,'2021-12-10 21:50:16','2021-12-10 21:50:16',NULL),(1107,NULL,40719,13,2,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',600.00,NULL,NULL,1,'2021-12-10 21:50:17','2021-12-10 21:50:17',NULL),(1108,NULL,40719,13,2,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',800.00,NULL,NULL,1,'2021-12-10 21:50:18','2021-12-10 21:50:18',NULL),(1109,NULL,40719,13,2,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',900.00,NULL,NULL,1,'2021-12-10 21:50:18','2021-12-10 21:50:18',NULL),(1110,NULL,40719,13,2,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',711.00,NULL,NULL,1,'2021-12-10 21:50:19','2021-12-10 21:50:19',NULL),(1111,NULL,40719,13,2,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',622.00,NULL,NULL,1,'2021-12-10 21:50:20','2021-12-10 21:50:20',NULL);
INSERT INTO `balance_libro` VALUES (1112,NULL,40719,13,2,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',510.00,NULL,NULL,1,'2021-12-10 21:50:21','2021-12-10 21:50:21',NULL),(1113,NULL,40719,13,2,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',941.00,NULL,NULL,1,'2021-12-10 21:50:22','2021-12-10 21:50:22',NULL),(1114,NULL,40719,13,2,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',7895.00,NULL,NULL,1,'2021-12-10 21:50:22','2021-12-10 21:50:22',NULL),(1115,NULL,40719,13,2,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',6541.00,NULL,NULL,1,'2021-12-10 21:50:23','2021-12-10 21:50:23',NULL),(1116,NULL,40719,13,2,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',633.00,NULL,NULL,1,'2021-12-10 21:50:24','2021-12-10 21:50:24',NULL),(1117,NULL,40719,13,2,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',8000.00,NULL,NULL,1,'2021-12-10 21:50:25','2021-12-10 21:50:25',NULL),(1118,NULL,40719,13,2,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',600.00,NULL,NULL,1,'2021-12-10 21:50:25','2021-12-10 21:50:25',NULL),(1119,NULL,40719,13,2,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2010.00,NULL,NULL,1,'2021-12-10 21:50:26','2021-12-10 21:50:26',NULL),(1120,NULL,40719,13,2,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',3584.00,NULL,NULL,1,'2021-12-10 21:50:27','2021-12-10 21:50:27',NULL),(1121,NULL,40719,13,2,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1800.00,NULL,NULL,1,'2021-12-10 21:50:28','2021-12-10 21:50:28',NULL),(1122,NULL,40719,13,2,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',9000.00,NULL,NULL,1,'2021-12-10 21:50:29','2021-12-10 21:50:29',NULL),(1123,NULL,40719,13,2,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1540.00,NULL,NULL,1,'2021-12-10 21:50:29','2021-12-10 21:50:29',NULL),(1124,NULL,40719,13,2,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',11000.00,NULL,NULL,1,'2021-12-10 21:50:30','2021-12-10 21:50:30',NULL),(1125,NULL,40719,13,2,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',2500.00,NULL,NULL,1,'2021-12-10 21:50:31','2021-12-10 21:50:31',NULL),(1126,NULL,40719,13,2,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',200.00,NULL,NULL,1,'2021-12-10 21:50:32','2021-12-10 21:50:32',NULL),(1127,NULL,40719,13,2,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',980.00,NULL,NULL,1,'2021-12-10 21:50:33','2021-12-10 21:50:33',NULL),(1128,NULL,40719,13,2,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',1500.00,NULL,NULL,1,'2021-12-10 21:50:33','2021-12-10 21:50:33',NULL),(1129,NULL,40719,13,2,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',411.00,NULL,NULL,1,'2021-12-10 21:50:34','2021-12-10 21:50:34',NULL),(1130,NULL,40719,13,2,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',680.00,NULL,NULL,1,'2021-12-10 21:50:35','2021-12-10 21:50:35',NULL),(1131,NULL,40719,13,2,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',154.00,NULL,NULL,1,'2021-12-10 21:50:36','2021-12-10 21:50:36',NULL),(1132,NULL,40719,13,2,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',955.00,NULL,NULL,1,'2021-12-10 21:50:36','2021-12-10 21:50:36',NULL);
INSERT INTO `balance_libro` VALUES (1133,NULL,40719,13,2,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',15000.00,NULL,NULL,1,'2021-12-10 21:50:37','2021-12-10 21:50:37',NULL),(1134,NULL,40719,14,2,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',22000.00,NULL,NULL,1,'2022-01-10 12:24:35','2022-01-10 12:24:35',NULL),(1135,NULL,40719,14,2,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',8000.00,NULL,NULL,1,'2022-01-10 12:24:39','2022-01-10 12:24:39',NULL),(1136,NULL,40719,14,2,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',15200.00,NULL,NULL,1,'2022-01-10 12:24:40','2022-01-10 12:24:40',NULL),(1137,NULL,40719,14,2,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2600.00,NULL,NULL,1,'2022-01-10 12:24:41','2022-01-10 12:24:41',NULL),(1138,NULL,40719,14,2,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',7000.00,NULL,NULL,1,'2022-01-10 12:24:42','2022-01-10 12:24:42',NULL),(1139,NULL,40719,14,2,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',7000.00,NULL,NULL,1,'2022-01-10 12:24:43','2022-01-10 12:24:43',NULL),(1140,NULL,40719,14,2,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',10000.00,NULL,NULL,1,'2022-01-10 12:24:44','2022-01-10 12:24:44',NULL),(1141,NULL,40719,14,2,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',500.00,NULL,NULL,1,'2022-01-10 12:24:45','2022-01-10 12:24:45',NULL),(1142,NULL,40719,14,2,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',8200.00,NULL,NULL,1,'2022-01-10 12:24:46','2022-01-10 12:24:46',NULL),(1143,NULL,40719,14,2,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',670.00,NULL,NULL,1,'2022-01-10 12:24:47','2022-01-10 12:24:47',NULL),(1144,NULL,40719,14,2,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',970.00,NULL,NULL,1,'2022-01-10 12:24:48','2022-01-10 12:24:48',NULL),(1145,NULL,40719,14,2,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1200.00,NULL,NULL,1,'2022-01-10 12:24:49','2022-01-10 12:24:49',NULL),(1146,NULL,40719,14,2,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2100.00,NULL,NULL,1,'2022-01-10 12:24:50','2022-01-10 12:24:50',NULL),(1147,NULL,40719,14,2,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',723.00,NULL,NULL,1,'2022-01-10 12:24:51','2022-01-10 12:24:51',NULL),(1148,NULL,40719,14,2,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1900.00,NULL,NULL,1,'2022-01-10 12:24:52','2022-01-10 12:24:52',NULL),(1149,NULL,40719,14,2,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1411.00,NULL,NULL,1,'2022-01-10 12:24:53','2022-01-10 12:24:53',NULL),(1150,NULL,40719,14,2,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',8195.00,NULL,NULL,1,'2022-01-10 12:24:54','2022-01-10 12:24:54',NULL),(1151,NULL,40719,14,2,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',5841.00,NULL,NULL,1,'2022-01-10 12:24:55','2022-01-10 12:24:55',NULL),(1152,NULL,40719,14,2,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',6533.00,NULL,NULL,1,'2022-01-10 12:24:56','2022-01-10 12:24:56',NULL),(1153,NULL,40719,14,2,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',800.00,NULL,NULL,1,'2022-01-10 12:24:57','2022-01-10 12:24:57',NULL);
INSERT INTO `balance_libro` VALUES (1154,NULL,40719,14,2,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',6500.00,NULL,NULL,1,'2022-01-10 12:24:58','2022-01-10 12:24:58',NULL),(1155,NULL,40719,14,2,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',4000.00,NULL,NULL,1,'2022-01-10 12:24:58','2022-01-10 12:24:58',NULL),(1156,NULL,40719,14,2,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2100.00,NULL,NULL,1,'2022-01-10 12:24:59','2022-01-10 12:24:59',NULL),(1157,NULL,40719,14,2,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',980.00,NULL,NULL,1,'2022-01-10 12:25:00','2022-01-10 12:25:00',NULL),(1158,NULL,40719,14,2,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1900.00,NULL,NULL,1,'2022-01-10 12:25:01','2022-01-10 12:25:01',NULL),(1159,NULL,40719,14,2,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1370.00,NULL,NULL,1,'2022-01-10 12:25:02','2022-01-10 12:25:02',NULL),(1160,NULL,40719,14,2,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',10300.00,NULL,NULL,1,'2022-01-10 12:25:03','2022-01-10 12:25:03',NULL),(1161,NULL,40719,14,2,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1500.00,NULL,NULL,1,'2022-01-10 12:25:04','2022-01-10 12:25:04',NULL),(1162,NULL,40719,14,2,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',900.00,NULL,NULL,1,'2022-01-10 12:25:05','2022-01-10 12:25:05',NULL),(1163,NULL,40719,14,2,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1280.00,NULL,NULL,1,'2022-01-10 12:25:06','2022-01-10 12:25:06',NULL),(1164,NULL,40719,14,2,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',1500.00,NULL,NULL,1,'2022-01-10 12:25:07','2022-01-10 12:25:07',NULL),(1165,NULL,40719,14,2,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',911.00,NULL,NULL,1,'2022-01-10 12:25:07','2022-01-10 12:25:07',NULL),(1166,NULL,40719,14,2,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',780.00,NULL,NULL,1,'2022-01-10 12:25:09','2022-01-10 12:25:09',NULL),(1167,NULL,40719,14,2,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',350.00,NULL,NULL,1,'2022-01-10 12:25:11','2022-01-10 12:25:11',NULL),(1168,NULL,40719,14,2,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',2955.00,NULL,NULL,1,'2022-01-10 12:25:12','2022-01-10 12:25:12',NULL),(1169,NULL,40719,14,2,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',9500.00,NULL,NULL,1,'2022-01-10 12:25:13','2022-01-10 12:25:13',NULL),(1170,NULL,40719,19,2,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-10','2022-02-10',3200.00,NULL,NULL,1,'2022-03-03 20:38:09','2022-03-03 20:38:12','2022-03-03 20:38:12'),(1171,NULL,40719,20,2,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3200.00,NULL,NULL,1,'2022-03-03 20:45:50','2022-03-03 20:45:50',NULL),(1172,NULL,40719,20,2,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2400.00,NULL,NULL,1,'2022-03-03 20:45:52','2022-03-03 20:45:52',NULL),(1173,NULL,40719,20,2,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2871.00,NULL,NULL,1,'2022-03-03 20:45:53','2022-03-03 20:45:53',NULL),(1174,NULL,40719,20,2,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3174.00,NULL,NULL,1,'2022-03-03 20:45:54','2022-03-03 20:45:54',NULL);
INSERT INTO `balance_libro` VALUES (1175,NULL,40719,20,2,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2000.00,NULL,NULL,1,'2022-03-03 20:45:54','2022-03-03 20:45:54',NULL),(1176,NULL,40719,20,2,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2970.00,NULL,NULL,1,'2022-03-03 20:45:55','2022-03-03 20:45:55',NULL),(1177,NULL,40719,20,2,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',7500.00,NULL,NULL,1,'2022-03-03 20:45:56','2022-03-03 20:45:56',NULL),(1178,NULL,40719,20,2,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',4200.00,NULL,NULL,1,'2022-03-03 20:45:57','2022-03-03 20:45:57',NULL),(1179,NULL,40719,20,2,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3700.00,NULL,NULL,1,'2022-03-03 20:45:57','2022-03-03 20:45:57',NULL),(1180,NULL,40719,20,2,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',7100.00,NULL,NULL,1,'2022-03-03 20:45:58','2022-03-03 20:45:58',NULL),(1181,NULL,40719,20,2,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2920.00,NULL,NULL,1,'2022-03-03 20:45:59','2022-03-03 20:45:59',NULL),(1182,NULL,40719,20,2,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2780.00,NULL,NULL,1,'2022-03-03 20:46:00','2022-03-03 20:46:00',NULL),(1183,NULL,40719,20,2,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3160.00,NULL,NULL,1,'2022-03-03 20:46:00','2022-03-03 20:46:00',NULL),(1184,NULL,40719,20,2,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2874.00,NULL,NULL,1,'2022-03-03 20:46:01','2022-03-03 20:46:01',NULL),(1185,NULL,40719,20,2,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1231.00,NULL,NULL,1,'2022-03-03 20:46:02','2022-03-03 20:46:02',NULL),(1186,NULL,40719,20,2,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3400.00,NULL,NULL,1,'2022-03-03 20:46:03','2022-03-03 20:46:03',NULL),(1187,NULL,40719,20,2,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3514.00,NULL,NULL,1,'2022-03-03 20:46:03','2022-03-03 20:46:03',NULL),(1188,NULL,40719,20,2,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',4127.00,NULL,NULL,1,'2022-03-03 20:46:04','2022-03-03 20:46:04',NULL),(1189,NULL,40719,20,2,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2745.00,NULL,NULL,1,'2022-03-03 20:46:05','2022-03-03 20:46:05',NULL),(1190,NULL,40719,20,2,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3100.00,NULL,NULL,1,'2022-03-03 20:46:06','2022-03-03 20:46:06',NULL),(1191,NULL,40719,20,2,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2420.00,NULL,NULL,1,'2022-03-03 20:46:06','2022-03-03 20:46:06',NULL),(1192,NULL,40719,20,2,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3010.00,NULL,NULL,1,'2022-03-03 20:46:07','2022-03-03 20:46:07',NULL),(1193,NULL,40719,20,2,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2910.00,NULL,NULL,1,'2022-03-03 20:46:08','2022-03-03 20:46:08',NULL),(1194,NULL,40719,20,2,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2765.00,NULL,NULL,1,'2022-03-03 20:46:09','2022-03-03 20:46:09',NULL),(1195,NULL,40719,20,2,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2400.00,NULL,NULL,1,'2022-03-03 20:46:10','2022-03-03 20:46:10',NULL);
INSERT INTO `balance_libro` VALUES (1196,NULL,40719,20,2,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2633.00,NULL,NULL,1,'2022-03-03 20:46:10','2022-03-03 20:46:10',NULL),(1197,NULL,40719,20,2,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3200.00,NULL,NULL,1,'2022-03-03 20:46:11','2022-03-03 20:46:11',NULL),(1198,NULL,40719,20,2,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2500.00,NULL,NULL,1,'2022-03-03 20:46:12','2022-03-03 20:46:12',NULL),(1199,NULL,40719,20,2,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2050.00,NULL,NULL,1,'2022-03-03 20:46:13','2022-03-03 20:46:13',NULL),(1200,NULL,40719,20,2,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3600.00,NULL,NULL,1,'2022-03-03 20:46:13','2022-03-03 20:46:13',NULL),(1201,NULL,40719,20,2,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2988.00,NULL,NULL,1,'2022-03-03 20:46:14','2022-03-03 20:46:14',NULL),(1202,NULL,40719,20,2,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2300.00,NULL,NULL,1,'2022-03-03 20:46:15','2022-03-03 20:46:15',NULL),(1203,NULL,40719,20,2,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3210.00,NULL,NULL,1,'2022-03-03 20:46:16','2022-03-03 20:46:16',NULL),(1204,NULL,40719,20,2,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2380.00,NULL,NULL,1,'2022-03-03 20:46:16','2022-03-03 20:46:16',NULL),(1205,NULL,40719,20,2,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3200.00,NULL,NULL,1,'2022-03-03 20:46:17','2022-03-03 20:46:17',NULL),(1206,NULL,40719,20,2,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',4180.00,NULL,NULL,1,'2022-03-03 20:46:18','2022-03-03 20:46:18',NULL),(1207,NULL,40719,20,2,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3750.00,NULL,NULL,1,'2022-03-03 20:46:19','2022-03-03 20:46:19',NULL),(1208,NULL,40719,20,2,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2800.00,NULL,NULL,1,'2022-03-03 20:46:19','2022-03-03 20:46:19',NULL),(1209,NULL,40719,20,2,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2960.00,NULL,NULL,1,'2022-03-03 20:46:20','2022-03-03 20:46:20',NULL),(1210,NULL,40719,20,2,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2600.00,NULL,NULL,1,'2022-03-03 20:46:21','2022-03-03 20:46:21',NULL),(1211,NULL,40719,20,2,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3200.00,NULL,NULL,1,'2022-03-03 20:46:22','2022-03-03 20:46:22',NULL),(1212,NULL,40719,20,2,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2450.00,NULL,NULL,1,'2022-03-03 20:46:22','2022-03-03 20:46:22',NULL),(1213,NULL,40719,20,2,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3100.00,NULL,NULL,1,'2022-03-03 20:46:23','2022-03-03 20:46:23',NULL),(1214,NULL,40719,20,2,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2950.00,NULL,NULL,1,'2022-03-03 20:46:24','2022-03-03 20:46:24',NULL),(1215,NULL,40719,20,2,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2700.00,NULL,NULL,1,'2022-03-03 20:46:25','2022-03-03 20:46:25',NULL),(1216,NULL,40719,20,2,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2860.00,NULL,NULL,1,'2022-03-03 20:46:26','2022-03-03 20:46:26',NULL);
INSERT INTO `balance_libro` VALUES (1217,NULL,40719,20,2,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3700.00,NULL,NULL,1,'2022-03-03 20:46:26','2022-03-03 20:46:26',NULL),(1218,NULL,40719,20,2,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3200.00,NULL,NULL,1,'2022-03-03 20:46:27','2022-03-03 20:46:27',NULL),(1219,NULL,40719,20,2,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3700.00,NULL,NULL,1,'2022-03-03 20:46:28','2022-03-03 20:46:28',NULL),(1220,NULL,40719,20,2,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',1970.00,NULL,NULL,1,'2022-03-03 20:46:29','2022-03-03 20:46:29',NULL),(1221,NULL,40719,20,2,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2400.00,NULL,NULL,1,'2022-03-03 20:46:29','2022-03-03 20:46:29',NULL),(1222,NULL,40719,20,2,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3157.00,NULL,NULL,1,'2022-03-03 20:46:30','2022-03-03 20:46:30',NULL),(1223,NULL,40719,20,2,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2486.00,NULL,NULL,1,'2022-03-03 20:46:31','2022-03-03 20:46:31',NULL),(1224,NULL,40719,20,2,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2415.00,NULL,NULL,1,'2022-03-03 20:46:32','2022-03-03 20:46:32',NULL),(1225,NULL,40719,20,2,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2174.00,NULL,NULL,1,'2022-03-03 20:46:33','2022-03-03 20:46:33',NULL),(1226,NULL,40719,20,2,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3451.00,NULL,NULL,1,'2022-03-03 20:46:34','2022-03-03 20:46:34',NULL),(1227,NULL,40719,20,2,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3621.00,NULL,NULL,1,'2022-03-03 20:46:35','2022-03-03 20:46:35',NULL),(1228,NULL,40719,20,2,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',2674.00,NULL,NULL,1,'2022-03-03 20:46:35','2022-03-03 20:46:35',NULL),(1229,NULL,40719,20,2,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3411.00,NULL,NULL,1,'2022-03-03 20:46:36','2022-03-03 20:46:36',NULL),(1230,NULL,40719,20,2,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3470.00,NULL,NULL,1,'2022-03-03 20:46:37','2022-03-03 20:46:37',NULL),(1231,NULL,40719,20,2,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-03','2022-03-03',3800.00,NULL,NULL,1,'2022-03-03 20:46:37','2022-03-03 20:46:37',NULL),(1232,NULL,40719,19,2,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',970.00,NULL,NULL,1,'2022-03-04 02:15:36','2022-03-04 02:15:38','2022-03-04 02:15:38'),(1233,NULL,40719,20,2,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-15','2022-03-15',970.00,NULL,NULL,1,'2022-04-09 19:54:09','2022-04-09 19:54:12','2022-04-09 19:54:12'),(1234,NULL,40719,21,2,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',2300.00,NULL,NULL,1,'2022-04-29 23:11:43','2022-04-29 23:11:43',NULL),(1235,NULL,40719,21,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1150.00,NULL,NULL,1,'2022-04-29 23:11:46','2022-04-29 23:11:46',NULL),(1236,NULL,40719,21,2,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1600.00,NULL,NULL,1,'2022-04-29 23:11:46','2022-04-29 23:11:46',NULL),(1237,NULL,40719,21,2,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',2300.00,NULL,NULL,1,'2022-04-29 23:11:47','2022-04-29 23:11:47',NULL);
INSERT INTO `balance_libro` VALUES (1238,NULL,40719,21,2,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1600.00,NULL,NULL,1,'2022-04-29 23:11:48','2022-04-29 23:11:48',NULL),(1239,NULL,40719,21,2,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1540.00,NULL,NULL,1,'2022-04-29 23:11:49','2022-04-29 23:11:49',NULL),(1240,NULL,40719,21,2,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',780.00,NULL,NULL,1,'2022-04-29 23:11:49','2022-04-29 23:11:49',NULL),(1241,NULL,40719,21,2,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',950.00,NULL,NULL,1,'2022-04-29 23:11:50','2022-04-29 23:11:50',NULL),(1242,NULL,40719,21,2,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1451.00,NULL,NULL,1,'2022-04-29 23:11:51','2022-04-29 23:11:51',NULL),(1243,NULL,40719,21,2,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1300.00,NULL,NULL,1,'2022-04-29 23:11:52','2022-04-29 23:11:52',NULL),(1244,NULL,40719,21,2,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1500.00,NULL,NULL,1,'2022-04-29 23:11:52','2022-04-29 23:11:52',NULL),(1245,NULL,40719,21,2,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',2340.00,NULL,NULL,1,'2022-04-29 23:11:53','2022-04-29 23:11:53',NULL),(1246,NULL,40719,21,2,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',4600.00,NULL,NULL,1,'2022-04-29 23:11:54','2022-04-29 23:11:54',NULL),(1247,NULL,40719,21,2,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1500.00,NULL,NULL,1,'2022-04-29 23:11:55','2022-04-29 23:11:55',NULL),(1248,NULL,40719,21,2,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1978.00,NULL,NULL,1,'2022-04-29 23:11:55','2022-04-29 23:11:55',NULL),(1249,NULL,40719,21,2,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',715.00,NULL,NULL,1,'2022-04-29 23:11:56','2022-04-29 23:11:56',NULL),(1250,NULL,40719,21,2,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',950.00,NULL,NULL,1,'2022-04-29 23:11:57','2022-04-29 23:11:57',NULL),(1251,NULL,40719,21,2,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1630.00,NULL,NULL,1,'2022-04-29 23:11:58','2022-04-29 23:11:58',NULL),(1252,NULL,40719,21,2,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1500.00,NULL,NULL,1,'2022-04-29 23:11:58','2022-04-29 23:11:58',NULL),(1253,NULL,40719,21,2,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1456.00,NULL,NULL,1,'2022-04-29 23:11:59','2022-04-29 23:11:59',NULL),(1254,NULL,40719,21,2,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1657.00,NULL,NULL,1,'2022-04-29 23:12:00','2022-04-29 23:12:00',NULL),(1255,NULL,40719,21,2,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',860.00,NULL,NULL,1,'2022-04-29 23:12:00','2022-04-29 23:12:00',NULL),(1256,NULL,40719,21,2,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1190.00,NULL,NULL,1,'2022-04-29 23:12:01','2022-04-29 23:12:01',NULL),(1257,NULL,40719,21,2,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1234.00,NULL,NULL,1,'2022-04-29 23:12:02','2022-04-29 23:12:02',NULL),(1258,NULL,40719,21,2,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',721.00,NULL,NULL,1,'2022-04-29 23:12:03','2022-04-29 23:12:03',NULL);
INSERT INTO `balance_libro` VALUES (1259,NULL,40719,21,2,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1391.00,NULL,NULL,1,'2022-04-29 23:12:04','2022-04-29 23:12:04',NULL),(1260,NULL,40719,21,2,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1654.00,NULL,NULL,1,'2022-04-29 23:12:05','2022-04-29 23:12:05',NULL),(1261,NULL,40719,21,2,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',1431.00,NULL,NULL,1,'2022-04-29 23:12:06','2022-04-29 23:12:06','2022-04-29 23:12:06'),(1262,NULL,40719,21,2,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2300.00,NULL,NULL,1,'2022-04-29 23:16:50','2022-04-29 23:16:50',NULL),(1263,NULL,40719,21,2,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1150.00,NULL,NULL,1,'2022-04-29 23:16:52','2022-04-29 23:16:52',NULL),(1264,NULL,40719,21,2,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1600.00,NULL,NULL,1,'2022-04-29 23:16:52','2022-04-29 23:16:52',NULL),(1265,NULL,40719,21,2,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2300.00,NULL,NULL,1,'2022-04-29 23:16:53','2022-04-29 23:16:53',NULL),(1266,NULL,40719,21,2,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1600.00,NULL,NULL,1,'2022-04-29 23:16:54','2022-04-29 23:16:54',NULL),(1267,NULL,40719,21,2,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1540.00,NULL,NULL,1,'2022-04-29 23:16:55','2022-04-29 23:16:55',NULL),(1268,NULL,40719,21,2,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',780.00,NULL,NULL,1,'2022-04-29 23:16:55','2022-04-29 23:16:55',NULL),(1269,NULL,40719,21,2,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',950.00,NULL,NULL,1,'2022-04-29 23:16:56','2022-04-29 23:16:56',NULL),(1270,NULL,40719,21,2,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1451.00,NULL,NULL,1,'2022-04-29 23:16:57','2022-04-29 23:16:57',NULL),(1271,NULL,40719,21,2,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1300.00,NULL,NULL,1,'2022-04-29 23:16:58','2022-04-29 23:16:58',NULL),(1272,NULL,40719,21,2,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1500.00,NULL,NULL,1,'2022-04-29 23:16:58','2022-04-29 23:16:58',NULL),(1273,NULL,40719,21,2,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2340.00,NULL,NULL,1,'2022-04-29 23:16:59','2022-04-29 23:16:59',NULL),(1274,NULL,40719,21,2,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',4600.00,NULL,NULL,1,'2022-04-29 23:17:00','2022-04-29 23:17:00',NULL),(1275,NULL,40719,21,2,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1500.00,NULL,NULL,1,'2022-04-29 23:17:01','2022-04-29 23:17:01',NULL),(1276,NULL,40719,21,2,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1978.00,NULL,NULL,1,'2022-04-29 23:17:01','2022-04-29 23:17:01',NULL),(1277,NULL,40719,21,2,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',715.00,NULL,NULL,1,'2022-04-29 23:17:02','2022-04-29 23:17:02',NULL),(1278,NULL,40719,21,2,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',950.00,NULL,NULL,1,'2022-04-29 23:17:03','2022-04-29 23:17:03',NULL),(1279,NULL,40719,21,2,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1630.00,NULL,NULL,1,'2022-04-29 23:17:04','2022-04-29 23:17:04',NULL);
INSERT INTO `balance_libro` VALUES (1280,NULL,40719,21,2,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1500.00,NULL,NULL,1,'2022-04-29 23:17:04','2022-04-29 23:17:04',NULL),(1281,NULL,40719,21,2,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1456.00,NULL,NULL,1,'2022-04-29 23:17:05','2022-04-29 23:17:05',NULL),(1282,NULL,40719,21,2,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1657.00,NULL,NULL,1,'2022-04-29 23:17:06','2022-04-29 23:17:06',NULL),(1283,NULL,40719,21,2,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',860.00,NULL,NULL,1,'2022-04-29 23:17:07','2022-04-29 23:17:07',NULL),(1284,NULL,40719,21,2,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1190.00,NULL,NULL,1,'2022-04-29 23:17:07','2022-04-29 23:17:07',NULL),(1285,NULL,40719,21,2,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1234.00,NULL,NULL,1,'2022-04-29 23:17:08','2022-04-29 23:17:08',NULL),(1286,NULL,40719,21,2,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',721.00,NULL,NULL,1,'2022-04-29 23:17:09','2022-04-29 23:17:09',NULL),(1287,NULL,40719,21,2,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1391.00,NULL,NULL,1,'2022-04-29 23:17:10','2022-04-29 23:17:10',NULL),(1288,NULL,40719,21,2,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1654.00,NULL,NULL,1,'2022-04-29 23:17:10','2022-04-29 23:17:10',NULL),(1289,NULL,40719,21,2,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1431.00,NULL,NULL,1,'2022-04-29 23:17:11','2022-04-29 23:17:12','2022-04-29 23:17:12'),(1290,NULL,40719,21,2,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-28','2022-04-28',2300.00,NULL,NULL,1,'2022-04-29 23:24:34','2022-04-29 23:24:35','2022-04-29 23:24:35'),(1291,NULL,40719,21,2,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2300.00,NULL,NULL,1,'2022-04-29 23:26:19','2022-04-29 23:26:19',NULL),(1292,NULL,40719,21,2,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1150.00,NULL,NULL,1,'2022-04-29 23:26:20','2022-04-29 23:26:20',NULL),(1293,NULL,40719,21,2,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1600.00,NULL,NULL,1,'2022-04-29 23:26:21','2022-04-29 23:26:21',NULL),(1294,NULL,40719,21,2,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2300.00,NULL,NULL,1,'2022-04-29 23:26:22','2022-04-29 23:26:22',NULL),(1295,NULL,40719,21,2,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1600.00,NULL,NULL,1,'2022-04-29 23:26:23','2022-04-29 23:26:23',NULL),(1296,NULL,40719,21,2,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1540.00,NULL,NULL,1,'2022-04-29 23:26:23','2022-04-29 23:26:23',NULL),(1297,NULL,40719,21,2,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',780.00,NULL,NULL,1,'2022-04-29 23:26:24','2022-04-29 23:26:24',NULL),(1298,NULL,40719,21,2,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',950.00,NULL,NULL,1,'2022-04-29 23:26:25','2022-04-29 23:26:25',NULL),(1299,NULL,40719,21,2,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1451.00,NULL,NULL,1,'2022-04-29 23:26:26','2022-04-29 23:26:26',NULL),(1300,NULL,40719,21,2,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1300.00,NULL,NULL,1,'2022-04-29 23:26:26','2022-04-29 23:26:26',NULL);
INSERT INTO `balance_libro` VALUES (1301,NULL,40719,21,2,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1500.00,NULL,NULL,1,'2022-04-29 23:26:27','2022-04-29 23:26:27',NULL),(1302,NULL,40719,21,2,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',2340.00,NULL,NULL,1,'2022-04-29 23:26:28','2022-04-29 23:26:28',NULL),(1303,NULL,40719,21,2,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',4600.00,NULL,NULL,1,'2022-04-29 23:26:29','2022-04-29 23:26:29',NULL),(1304,NULL,40719,21,2,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1500.00,NULL,NULL,1,'2022-04-29 23:26:29','2022-04-29 23:26:29',NULL),(1305,NULL,40719,21,2,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1978.00,NULL,NULL,1,'2022-04-29 23:26:30','2022-04-29 23:26:30',NULL),(1306,NULL,40719,21,2,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',715.00,NULL,NULL,1,'2022-04-29 23:26:31','2022-04-29 23:26:31',NULL),(1307,NULL,40719,21,2,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',950.00,NULL,NULL,1,'2022-04-29 23:26:32','2022-04-29 23:26:32',NULL),(1308,NULL,40719,21,2,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1630.00,NULL,NULL,1,'2022-04-29 23:26:33','2022-04-29 23:26:33',NULL),(1309,NULL,40719,21,2,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1500.00,NULL,NULL,1,'2022-04-29 23:26:34','2022-04-29 23:26:34',NULL),(1310,NULL,40719,21,2,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1456.00,NULL,NULL,1,'2022-04-29 23:26:35','2022-04-29 23:26:35',NULL),(1311,NULL,40719,21,2,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1657.00,NULL,NULL,1,'2022-04-29 23:26:36','2022-04-29 23:26:36',NULL),(1312,NULL,40719,21,2,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',860.00,NULL,NULL,1,'2022-04-29 23:26:37','2022-04-29 23:26:37',NULL),(1313,NULL,40719,21,2,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1190.00,NULL,NULL,1,'2022-04-29 23:26:37','2022-04-29 23:26:37',NULL),(1314,NULL,40719,21,2,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1234.00,NULL,NULL,1,'2022-04-29 23:26:38','2022-04-29 23:26:38',NULL),(1315,NULL,40719,21,2,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',721.00,NULL,NULL,1,'2022-04-29 23:26:39','2022-04-29 23:26:39',NULL),(1316,NULL,40719,21,2,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1391.00,NULL,NULL,1,'2022-04-29 23:26:39','2022-04-29 23:26:39',NULL),(1317,NULL,40719,21,2,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1654.00,NULL,NULL,1,'2022-04-29 23:26:40','2022-04-29 23:26:40',NULL),(1318,NULL,40719,21,2,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',1431.00,NULL,NULL,1,'2022-04-29 23:26:41','2022-04-29 23:26:42','2022-04-29 23:26:42'),(1319,NULL,40719,21,2,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-15','2022-04-15',1560.00,NULL,NULL,1,'2022-04-29 23:54:03','2022-04-29 23:54:05','2022-04-29 23:54:05'),(1320,NULL,40719,21,2,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',1560.00,NULL,NULL,1,'2022-04-29 23:57:23','2022-04-29 23:57:25','2022-04-29 23:57:25'),(1321,NULL,40719,21,2,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-27','2022-04-27',1560.00,NULL,NULL,1,'2022-04-30 00:05:01','2022-04-30 00:05:02','2022-04-30 00:05:02');
INSERT INTO `balance_libro` VALUES (1322,NULL,40719,21,2,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1560.00,NULL,NULL,1,'2022-04-30 00:09:08','2022-04-30 00:09:08',NULL),(1323,NULL,40719,21,2,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',900.00,NULL,NULL,1,'2022-04-30 00:09:10','2022-04-30 00:09:10',NULL),(1324,NULL,40719,21,2,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1300.00,NULL,NULL,1,'2022-04-30 00:09:11','2022-04-30 00:09:11',NULL),(1325,NULL,40719,21,2,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2300.00,NULL,NULL,1,'2022-04-30 00:09:11','2022-04-30 00:09:11',NULL),(1326,NULL,40719,21,2,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',800.00,NULL,NULL,1,'2022-04-30 00:09:12','2022-04-30 00:09:12',NULL),(1327,NULL,40719,21,2,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',905.00,NULL,NULL,1,'2022-04-30 00:09:13','2022-04-30 00:09:13',NULL),(1328,NULL,40719,21,2,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1643.00,NULL,NULL,1,'2022-04-30 00:09:14','2022-04-30 00:09:14',NULL),(1329,NULL,40719,21,2,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1179.00,NULL,NULL,1,'2022-04-30 00:09:15','2022-04-30 00:09:15',NULL),(1330,NULL,40719,21,2,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1200.00,NULL,NULL,1,'2022-04-30 00:09:15','2022-04-30 00:09:15',NULL),(1331,NULL,40719,21,2,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',790.00,NULL,NULL,1,'2022-04-30 00:09:16','2022-04-30 00:09:16',NULL),(1332,NULL,40719,21,2,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',790.00,NULL,NULL,1,'2022-04-30 00:09:17','2022-04-30 00:09:17',NULL),(1333,NULL,40719,21,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1330.00,NULL,NULL,1,'2022-04-30 00:09:18','2022-04-30 00:09:18',NULL),(1334,NULL,40719,21,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1370.00,NULL,NULL,1,'2022-04-30 00:09:19','2022-04-30 00:09:19',NULL),(1335,NULL,40719,21,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1648.00,NULL,NULL,1,'2022-04-30 00:09:19','2022-04-30 00:09:19',NULL),(1336,NULL,40719,21,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',900.00,NULL,NULL,1,'2022-04-30 00:09:20','2022-04-30 00:09:20',NULL),(1337,NULL,40719,21,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',705.00,NULL,NULL,1,'2022-04-30 00:09:21','2022-04-30 00:09:21',NULL),(1338,NULL,40719,21,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',802.00,NULL,NULL,1,'2022-04-30 00:09:22','2022-04-30 00:09:22',NULL),(1339,NULL,40719,21,2,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',934.00,NULL,NULL,1,'2022-04-30 00:09:23','2022-04-30 00:09:23',NULL),(1340,NULL,40719,21,2,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1650.00,NULL,NULL,1,'2022-04-30 00:09:24','2022-04-30 00:09:24',NULL),(1341,NULL,40719,21,2,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',751.00,NULL,NULL,1,'2022-04-30 00:09:24','2022-04-30 00:09:24',NULL),(1342,NULL,40719,21,2,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',970.00,NULL,NULL,1,'2022-04-30 00:09:25','2022-04-30 00:09:25',NULL);
INSERT INTO `balance_libro` VALUES (1343,NULL,40719,21,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',800.00,NULL,NULL,1,'2022-04-30 00:09:26','2022-04-30 00:09:26',NULL),(1344,NULL,40719,21,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1500.00,NULL,NULL,1,'2022-04-30 00:09:27','2022-04-30 00:09:27',NULL),(1345,NULL,40719,21,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1502.00,NULL,NULL,1,'2022-04-30 00:09:28','2022-04-30 00:09:28',NULL),(1346,NULL,40719,21,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1371.00,NULL,NULL,1,'2022-04-30 00:09:28','2022-04-30 00:09:28',NULL),(1347,NULL,40719,21,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1392.00,NULL,NULL,1,'2022-04-30 00:09:29','2022-04-30 00:09:29',NULL),(1348,NULL,40719,21,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1376.00,NULL,NULL,1,'2022-04-30 00:09:30','2022-04-30 00:09:30',NULL),(1349,NULL,40719,21,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1617.00,NULL,NULL,1,'2022-04-30 00:09:31','2022-04-30 00:09:31',NULL),(1350,NULL,40719,21,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1682.00,NULL,NULL,1,'2022-04-30 00:09:31','2022-04-30 00:09:31',NULL),(1351,NULL,40719,21,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',908.00,NULL,NULL,1,'2022-04-30 00:09:32','2022-04-30 00:09:32',NULL),(1352,NULL,40719,21,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1380.00,NULL,NULL,1,'2022-04-30 00:09:33','2022-04-30 00:09:33',NULL),(1353,NULL,40719,21,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1182.00,NULL,NULL,1,'2022-04-30 00:09:34','2022-04-30 00:09:34',NULL),(1354,NULL,40719,21,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',650.00,NULL,NULL,1,'2022-04-30 00:09:34','2022-04-30 00:09:34',NULL),(1355,NULL,40719,21,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',680.00,NULL,NULL,1,'2022-04-30 00:09:35','2022-04-30 00:09:35',NULL),(1356,NULL,40719,21,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',690.00,NULL,NULL,1,'2022-04-30 00:09:36','2022-04-30 00:09:36',NULL),(1357,NULL,40719,21,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',700.00,NULL,NULL,1,'2022-04-30 00:09:37','2022-04-30 00:09:37',NULL),(1358,NULL,40719,21,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',901.00,NULL,NULL,1,'2022-04-30 00:09:38','2022-04-30 00:09:38',NULL),(1359,NULL,40719,21,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1183.00,NULL,NULL,1,'2022-04-30 00:09:38','2022-04-30 00:09:38',NULL),(1360,NULL,40719,21,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1200.00,NULL,NULL,1,'2022-04-30 00:09:39','2022-04-30 00:09:39',NULL),(1361,NULL,40719,21,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1354.00,NULL,NULL,1,'2022-04-30 00:09:40','2022-04-30 00:09:40',NULL),(1362,NULL,40719,21,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1612.00,NULL,NULL,1,'2022-04-30 00:09:41','2022-04-30 00:09:41',NULL),(1363,NULL,40719,21,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',680.00,NULL,NULL,1,'2022-04-30 00:09:41','2022-04-30 00:09:41',NULL);
INSERT INTO `balance_libro` VALUES (1364,NULL,40719,21,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',790.00,NULL,NULL,1,'2022-04-30 00:09:42','2022-04-30 00:09:42',NULL),(1365,NULL,40719,21,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',820.00,NULL,NULL,1,'2022-04-30 00:09:43','2022-04-30 00:09:43',NULL),(1366,NULL,40719,21,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1419.00,NULL,NULL,1,'2022-04-30 00:09:44','2022-04-30 00:09:44',NULL),(1367,NULL,40719,21,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',781.00,NULL,NULL,1,'2022-04-30 00:09:44','2022-04-30 00:09:44',NULL),(1368,NULL,40719,21,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1627.00,NULL,NULL,1,'2022-04-30 00:09:45','2022-04-30 00:09:45',NULL),(1369,NULL,40719,21,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1493.00,NULL,NULL,1,'2022-04-30 00:09:46','2022-04-30 00:09:46',NULL),(1370,NULL,40719,21,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1680.00,NULL,NULL,1,'2022-04-30 00:09:47','2022-04-30 00:09:47',NULL),(1371,NULL,40719,21,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',901.00,NULL,NULL,1,'2022-04-30 00:09:48','2022-04-30 00:09:48',NULL),(1372,NULL,40719,21,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1604.00,NULL,NULL,1,'2022-04-30 00:09:48','2022-04-30 00:09:48',NULL),(1373,NULL,40719,21,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',782.00,NULL,NULL,1,'2022-04-30 00:09:49','2022-04-30 00:09:49',NULL),(1374,NULL,40719,21,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1000.00,NULL,NULL,1,'2022-04-30 00:09:50','2022-04-30 00:09:50',NULL),(1375,NULL,40719,21,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1200.00,NULL,NULL,1,'2022-04-30 00:09:51','2022-04-30 00:09:51',NULL),(1376,NULL,40719,21,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1641.00,NULL,NULL,1,'2022-04-30 00:09:51','2022-04-30 00:09:51',NULL),(1377,NULL,40719,21,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1645.00,NULL,NULL,1,'2022-04-30 00:09:52','2022-04-30 00:09:52',NULL),(1378,NULL,40719,21,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',854.00,NULL,NULL,1,'2022-04-30 00:09:53','2022-04-30 00:09:53',NULL),(1379,NULL,40719,21,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',951.00,NULL,NULL,1,'2022-04-30 00:09:54','2022-04-30 00:09:54',NULL),(1380,NULL,40719,21,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',753.00,NULL,NULL,1,'2022-04-30 00:09:55','2022-04-30 00:09:55',NULL),(1381,NULL,40719,21,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',852.00,NULL,NULL,1,'2022-04-30 00:09:55','2022-04-30 00:09:55',NULL),(1382,NULL,40719,21,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',654.00,NULL,NULL,1,'2022-04-30 00:09:56','2022-04-30 00:09:56',NULL),(1383,NULL,40719,21,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1809.00,NULL,NULL,1,'2022-04-30 00:09:57','2022-04-30 00:09:57',NULL),(1384,NULL,40719,21,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',871.00,NULL,NULL,1,'2022-04-30 00:09:58','2022-04-30 00:09:58',NULL);
INSERT INTO `balance_libro` VALUES (1385,NULL,40719,21,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1741.00,NULL,NULL,1,'2022-04-30 00:09:59','2022-04-30 00:09:59',NULL),(1386,NULL,40719,21,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1753.00,NULL,NULL,1,'2022-04-30 00:09:59','2022-04-30 00:09:59',NULL),(1387,NULL,40719,21,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',957.00,NULL,NULL,1,'2022-04-30 00:10:00','2022-04-30 00:10:00',NULL),(1388,NULL,40719,21,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',859.00,NULL,NULL,1,'2022-04-30 00:10:01','2022-04-30 00:10:01',NULL),(1389,NULL,40719,21,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1670.00,NULL,NULL,1,'2022-04-30 00:10:02','2022-04-30 00:10:02',NULL),(1390,NULL,40719,21,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1720.00,NULL,NULL,1,'2022-04-30 00:10:03','2022-04-30 00:10:03',NULL),(1391,NULL,40719,21,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1341.00,NULL,NULL,1,'2022-04-30 00:10:03','2022-04-30 00:10:03',NULL),(1392,NULL,40719,21,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1530.00,NULL,NULL,1,'2022-04-30 00:10:04','2022-04-30 00:10:04',NULL),(1393,NULL,40719,21,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2970.00,NULL,NULL,1,'2022-04-30 00:10:05','2022-04-30 00:10:05',NULL),(1394,NULL,40719,21,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1860.00,NULL,NULL,1,'2022-04-30 00:10:06','2022-04-30 00:10:06',NULL),(1395,NULL,40719,21,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2300.00,NULL,NULL,1,'2022-04-30 00:10:06','2022-04-30 00:10:06',NULL),(1396,NULL,40719,21,2,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2141.00,NULL,NULL,1,'2022-04-30 00:10:07','2022-04-30 00:10:07',NULL),(1397,NULL,40719,21,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1860.00,NULL,NULL,1,'2022-04-30 00:10:08','2022-04-30 00:10:08',NULL),(1398,NULL,40719,21,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1737.00,NULL,NULL,1,'2022-04-30 00:10:09','2022-04-30 00:10:09',NULL),(1399,NULL,40719,21,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1429.00,NULL,NULL,1,'2022-04-30 00:10:10','2022-04-30 00:10:10',NULL),(1400,NULL,40719,21,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',986.00,NULL,NULL,1,'2022-04-30 00:10:10','2022-04-30 00:10:10',NULL),(1401,NULL,40719,21,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1560.00,NULL,NULL,1,'2022-04-30 00:10:11','2022-04-30 00:10:11',NULL),(1402,NULL,40719,21,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',730.00,NULL,NULL,1,'2022-04-30 00:10:11','2022-04-30 00:10:11',NULL),(1403,NULL,40719,21,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1632.00,NULL,NULL,1,'2022-04-30 00:10:12','2022-04-30 00:10:13','2022-04-30 00:10:13'),(1404,NULL,40719,21,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',900.00,NULL,NULL,1,'2022-04-30 00:10:13','2022-04-30 00:10:13',NULL),(1405,NULL,40719,21,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1300.00,NULL,NULL,1,'2022-04-30 00:10:14','2022-04-30 00:10:14',NULL);
INSERT INTO `balance_libro` VALUES (1406,NULL,40719,21,2,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2300.00,NULL,NULL,1,'2022-04-30 00:10:14','2022-04-30 00:10:14',NULL),(1407,NULL,40719,21,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',800.00,NULL,NULL,1,'2022-04-30 00:10:15','2022-04-30 00:10:15',NULL),(1408,NULL,40719,21,2,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',905.00,NULL,NULL,1,'2022-04-30 00:10:16','2022-04-30 00:10:16',NULL),(1409,NULL,40719,21,2,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1643.00,NULL,NULL,1,'2022-04-30 00:10:17','2022-04-30 00:10:17',NULL),(1410,NULL,40719,21,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1179.00,NULL,NULL,1,'2022-04-30 00:10:17','2022-04-30 00:10:17',NULL),(1411,NULL,40719,21,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1200.00,NULL,NULL,1,'2022-04-30 00:10:18','2022-04-30 00:10:18',NULL),(1412,NULL,40719,21,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',790.00,NULL,NULL,1,'2022-04-30 00:10:19','2022-04-30 00:10:19',NULL),(1413,NULL,40719,21,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',790.00,NULL,NULL,1,'2022-04-30 00:10:20','2022-04-30 00:10:20',NULL),(1414,NULL,40719,21,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1330.00,NULL,NULL,1,'2022-04-30 00:10:21','2022-04-30 00:10:21',NULL),(1415,NULL,40719,21,2,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1370.00,NULL,NULL,1,'2022-04-30 00:10:21','2022-04-30 00:10:21',NULL),(1416,NULL,40719,21,2,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1648.00,NULL,NULL,1,'2022-04-30 00:10:22','2022-04-30 00:10:22',NULL),(1417,NULL,40719,21,2,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',900.00,NULL,NULL,1,'2022-04-30 00:10:23','2022-04-30 00:10:23',NULL),(1418,NULL,40719,21,2,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',705.00,NULL,NULL,1,'2022-04-30 00:10:24','2022-04-30 00:10:24',NULL),(1419,NULL,40719,21,2,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',802.00,NULL,NULL,1,'2022-04-30 00:10:24','2022-04-30 00:10:24',NULL),(1420,NULL,40719,21,2,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',934.00,NULL,NULL,1,'2022-04-30 00:10:25','2022-04-30 00:10:25',NULL),(1421,NULL,40719,21,2,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1650.00,NULL,NULL,1,'2022-04-30 00:10:26','2022-04-30 00:10:26',NULL),(1422,NULL,40719,21,2,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',751.00,NULL,NULL,1,'2022-04-30 00:10:27','2022-04-30 00:10:27',NULL),(1423,NULL,40719,21,2,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',970.00,NULL,NULL,1,'2022-04-30 00:10:28','2022-04-30 00:10:28',NULL),(1424,NULL,40719,21,2,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',800.00,NULL,NULL,1,'2022-04-30 00:10:28','2022-04-30 00:10:28',NULL),(1425,NULL,40719,21,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1500.00,NULL,NULL,1,'2022-04-30 00:10:29','2022-04-30 00:10:29',NULL),(1426,NULL,40719,21,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1502.00,NULL,NULL,1,'2022-04-30 00:10:30','2022-04-30 00:10:30',NULL);
INSERT INTO `balance_libro` VALUES (1427,NULL,40719,21,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1371.00,NULL,NULL,1,'2022-04-30 00:10:31','2022-04-30 00:10:31',NULL),(1428,NULL,40719,21,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1392.00,NULL,NULL,1,'2022-04-30 00:10:31','2022-04-30 00:10:31',NULL),(1429,NULL,40719,21,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1376.00,NULL,NULL,1,'2022-04-30 00:10:32','2022-04-30 00:10:32',NULL),(1430,NULL,40719,21,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1617.00,NULL,NULL,1,'2022-04-30 00:10:33','2022-04-30 00:10:33',NULL),(1431,NULL,40719,21,2,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1682.00,NULL,NULL,1,'2022-04-30 00:10:34','2022-04-30 00:10:34',NULL),(1432,NULL,40719,21,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',908.00,NULL,NULL,1,'2022-04-30 00:10:34','2022-04-30 00:10:34',NULL),(1433,NULL,40719,21,2,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1380.00,NULL,NULL,1,'2022-04-30 00:10:35','2022-04-30 00:10:35',NULL),(1434,NULL,40719,21,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1182.00,NULL,NULL,1,'2022-04-30 00:10:37','2022-04-30 00:10:37',NULL),(1435,NULL,40719,21,2,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',650.00,NULL,NULL,1,'2022-04-30 00:10:37','2022-04-30 00:10:37',NULL),(1436,NULL,40719,21,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',680.00,NULL,NULL,1,'2022-04-30 00:10:38','2022-04-30 00:10:38',NULL),(1437,NULL,40719,21,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',690.00,NULL,NULL,1,'2022-04-30 00:10:39','2022-04-30 00:10:39',NULL),(1438,NULL,40719,21,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',700.00,NULL,NULL,1,'2022-04-30 00:10:40','2022-04-30 00:10:40',NULL),(1439,NULL,40719,21,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',901.00,NULL,NULL,1,'2022-04-30 00:10:40','2022-04-30 00:10:40',NULL),(1440,NULL,40719,21,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1183.00,NULL,NULL,1,'2022-04-30 00:10:41','2022-04-30 00:10:41',NULL),(1441,NULL,40719,21,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1200.00,NULL,NULL,1,'2022-04-30 00:10:42','2022-04-30 00:10:42',NULL),(1442,NULL,40719,21,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1354.00,NULL,NULL,1,'2022-04-30 00:10:43','2022-04-30 00:10:43',NULL),(1443,NULL,40719,21,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1612.00,NULL,NULL,1,'2022-04-30 00:10:43','2022-04-30 00:10:43',NULL),(1444,NULL,40719,21,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',680.00,NULL,NULL,1,'2022-04-30 00:10:44','2022-04-30 00:10:44',NULL),(1445,NULL,40719,21,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',790.00,NULL,NULL,1,'2022-04-30 00:10:45','2022-04-30 00:10:45',NULL),(1446,NULL,40719,21,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',820.00,NULL,NULL,1,'2022-04-30 00:10:46','2022-04-30 00:10:46',NULL),(1447,NULL,40719,21,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1419.00,NULL,NULL,1,'2022-04-30 00:10:47','2022-04-30 00:10:47',NULL);
INSERT INTO `balance_libro` VALUES (1448,NULL,40719,21,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',781.00,NULL,NULL,1,'2022-04-30 00:10:48','2022-04-30 00:10:48',NULL),(1449,NULL,40719,21,2,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1627.00,NULL,NULL,1,'2022-04-30 00:10:48','2022-04-30 00:10:48',NULL),(1450,NULL,40719,21,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1493.00,NULL,NULL,1,'2022-04-30 00:10:49','2022-04-30 00:10:49',NULL),(1451,NULL,40719,21,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1680.00,NULL,NULL,1,'2022-04-30 00:10:50','2022-04-30 00:10:50',NULL),(1452,NULL,40719,21,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',901.00,NULL,NULL,1,'2022-04-30 00:10:51','2022-04-30 00:10:51',NULL),(1453,NULL,40719,21,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1604.00,NULL,NULL,1,'2022-04-30 00:10:51','2022-04-30 00:10:51',NULL),(1454,NULL,40719,21,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',782.00,NULL,NULL,1,'2022-04-30 00:10:52','2022-04-30 00:10:52',NULL),(1455,NULL,40719,21,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1000.00,NULL,NULL,1,'2022-04-30 00:10:53','2022-04-30 00:10:53',NULL),(1456,NULL,40719,21,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1200.00,NULL,NULL,1,'2022-04-30 00:10:54','2022-04-30 00:10:54',NULL),(1457,NULL,40719,21,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1641.00,NULL,NULL,1,'2022-04-30 00:10:55','2022-04-30 00:10:55',NULL),(1458,NULL,40719,21,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1645.00,NULL,NULL,1,'2022-04-30 00:10:55','2022-04-30 00:10:55',NULL),(1459,NULL,40719,21,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',854.00,NULL,NULL,1,'2022-04-30 00:10:56','2022-04-30 00:10:56',NULL),(1460,NULL,40719,21,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',951.00,NULL,NULL,1,'2022-04-30 00:10:57','2022-04-30 00:10:57',NULL),(1461,NULL,40719,21,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',753.00,NULL,NULL,1,'2022-04-30 00:10:58','2022-04-30 00:10:58',NULL),(1462,NULL,40719,21,2,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',852.00,NULL,NULL,1,'2022-04-30 00:10:59','2022-04-30 00:10:59',NULL),(1463,NULL,40719,21,2,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',654.00,NULL,NULL,1,'2022-04-30 00:10:59','2022-04-30 00:10:59',NULL),(1464,NULL,40719,21,2,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1809.00,NULL,NULL,1,'2022-04-30 00:11:00','2022-04-30 00:11:00',NULL),(1465,NULL,40719,21,2,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',871.00,NULL,NULL,1,'2022-04-30 00:11:01','2022-04-30 00:11:01',NULL),(1466,NULL,40719,21,2,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1741.00,NULL,NULL,1,'2022-04-30 00:11:02','2022-04-30 00:11:02',NULL),(1467,NULL,40719,21,2,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1753.00,NULL,NULL,1,'2022-04-30 00:11:02','2022-04-30 00:11:02',NULL),(1468,NULL,40719,21,2,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',957.00,NULL,NULL,1,'2022-04-30 00:11:03','2022-04-30 00:11:03',NULL);
INSERT INTO `balance_libro` VALUES (1469,NULL,40719,21,2,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',859.00,NULL,NULL,1,'2022-04-30 00:11:04','2022-04-30 00:11:04',NULL),(1470,NULL,40719,21,2,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1670.00,NULL,NULL,1,'2022-04-30 00:11:05','2022-04-30 00:11:05',NULL),(1471,NULL,40719,21,2,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1720.00,NULL,NULL,1,'2022-04-30 00:11:06','2022-04-30 00:11:06',NULL),(1472,NULL,40719,21,2,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1341.00,NULL,NULL,1,'2022-04-30 00:11:06','2022-04-30 00:11:06',NULL),(1473,NULL,40719,21,2,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1530.00,NULL,NULL,1,'2022-04-30 00:11:07','2022-04-30 00:11:07',NULL),(1474,NULL,40719,21,2,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2970.00,NULL,NULL,1,'2022-04-30 00:11:08','2022-04-30 00:11:08',NULL),(1475,NULL,40719,21,2,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1860.00,NULL,NULL,1,'2022-04-30 00:11:09','2022-04-30 00:11:09',NULL),(1476,NULL,40719,21,2,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2300.00,NULL,NULL,1,'2022-04-30 00:11:10','2022-04-30 00:11:10',NULL),(1477,NULL,40719,21,2,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2141.00,NULL,NULL,1,'2022-04-30 00:11:11','2022-04-30 00:11:11',NULL),(1478,NULL,40719,21,2,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1860.00,NULL,NULL,1,'2022-04-30 00:11:12','2022-04-30 00:11:12',NULL),(1479,NULL,40719,21,2,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1737.00,NULL,NULL,1,'2022-04-30 00:11:12','2022-04-30 00:11:12',NULL),(1480,NULL,40719,21,2,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1429.00,NULL,NULL,1,'2022-04-30 00:11:13','2022-04-30 00:11:13',NULL),(1481,NULL,40719,21,2,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',986.00,NULL,NULL,1,'2022-04-30 00:11:14','2022-04-30 00:11:14',NULL),(1482,NULL,40719,21,2,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',730.00,NULL,NULL,1,'2022-04-30 00:11:15','2022-04-30 00:11:15',NULL),(1483,NULL,40719,21,2,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1632.00,NULL,NULL,1,'2022-04-30 00:11:15','2022-04-30 00:11:15',NULL),(1484,NULL,40719,21,2,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2119.00,NULL,NULL,1,'2022-04-30 00:11:16','2022-04-30 00:11:16',NULL),(1485,NULL,40719,21,2,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2343.00,NULL,NULL,1,'2022-04-30 00:11:17','2022-04-30 00:11:17',NULL),(1486,NULL,40719,21,2,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',990.00,NULL,NULL,1,'2022-04-30 00:11:18','2022-04-30 00:11:18',NULL),(1487,NULL,40719,21,2,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1700.00,NULL,NULL,1,'2022-04-30 00:11:19','2022-04-30 00:11:19',NULL),(1488,NULL,40719,21,2,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1733.00,NULL,NULL,1,'2022-04-30 00:11:20','2022-04-30 00:11:20',NULL),(1489,NULL,40719,21,2,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1767.00,NULL,NULL,1,'2022-04-30 00:11:20','2022-04-30 00:11:20',NULL);
INSERT INTO `balance_libro` VALUES (1490,NULL,40719,21,2,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1820.00,NULL,NULL,1,'2022-04-30 00:11:21','2022-04-30 00:11:21',NULL),(1491,NULL,40719,21,2,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1763.00,NULL,NULL,1,'2022-04-30 00:11:22','2022-04-30 00:11:22',NULL),(1492,NULL,40719,21,2,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1632.00,NULL,NULL,1,'2022-04-30 00:11:23','2022-04-30 00:11:23',NULL),(1493,NULL,40719,21,2,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1854.00,NULL,NULL,1,'2022-04-30 00:11:24','2022-04-30 00:11:24',NULL),(1494,NULL,40719,21,2,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1901.00,NULL,NULL,1,'2022-04-30 00:11:24','2022-04-30 00:11:24',NULL),(1495,NULL,40719,21,2,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1803.00,NULL,NULL,1,'2022-04-30 00:11:25','2022-04-30 00:11:25',NULL),(1496,NULL,40719,21,2,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1612.00,NULL,NULL,1,'2022-04-30 00:11:26','2022-04-30 00:11:26',NULL),(1497,NULL,40719,21,2,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1701.00,NULL,NULL,1,'2022-04-30 00:11:27','2022-04-30 00:11:27',NULL),(1498,NULL,40719,21,2,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1332.00,NULL,NULL,1,'2022-04-30 00:11:27','2022-04-30 00:11:27',NULL),(1499,NULL,40719,21,2,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1608.00,NULL,NULL,1,'2022-04-30 00:11:28','2022-04-30 00:11:28',NULL),(1500,NULL,40719,21,2,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1327.00,NULL,NULL,1,'2022-04-30 00:11:29','2022-04-30 00:11:29',NULL),(1501,NULL,40719,21,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1346.00,NULL,NULL,1,'2022-04-30 00:11:30','2022-04-30 00:11:30',NULL),(1502,NULL,40719,21,2,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1397.00,NULL,NULL,1,'2022-04-30 00:11:31','2022-04-30 00:11:31',NULL),(1503,NULL,40719,21,2,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1051.00,NULL,NULL,1,'2022-04-30 00:11:32','2022-04-30 00:11:32',NULL),(1504,NULL,40719,21,2,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',873.00,NULL,NULL,1,'2022-04-30 00:11:33','2022-04-30 00:11:33',NULL),(1505,NULL,40719,21,2,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',1300.00,NULL,NULL,1,'2022-04-30 00:11:33','2022-04-30 00:11:33',NULL),(1506,NULL,40719,22,2,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1560.00,NULL,NULL,1,'2022-06-09 21:22:07','2022-06-09 21:22:07',NULL),(1507,NULL,40719,22,2,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',900.00,NULL,NULL,1,'2022-06-09 21:22:07','2022-06-09 21:22:07',NULL),(1508,NULL,40719,22,2,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1300.00,NULL,NULL,1,'2022-06-09 21:22:08','2022-06-09 21:22:08',NULL),(1509,NULL,40719,22,2,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2300.00,NULL,NULL,1,'2022-06-09 21:22:09','2022-06-09 21:22:09',NULL),(1510,NULL,40719,22,2,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',800.00,NULL,NULL,1,'2022-06-09 21:22:10','2022-06-09 21:22:10',NULL);
INSERT INTO `balance_libro` VALUES (1511,NULL,40719,22,2,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',905.00,NULL,NULL,1,'2022-06-09 21:22:10','2022-06-09 21:22:10',NULL),(1512,NULL,40719,22,2,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1643.00,NULL,NULL,1,'2022-06-09 21:22:11','2022-06-09 21:22:11',NULL),(1513,NULL,40719,22,2,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1179.00,NULL,NULL,1,'2022-06-09 21:22:12','2022-06-09 21:22:12',NULL),(1514,NULL,40719,22,2,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1200.00,NULL,NULL,1,'2022-06-09 21:22:13','2022-06-09 21:22:13',NULL),(1515,NULL,40719,22,2,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',790.00,NULL,NULL,1,'2022-06-09 21:22:14','2022-06-09 21:22:14',NULL),(1516,NULL,40719,22,2,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',790.00,NULL,NULL,1,'2022-06-09 21:22:14','2022-06-09 21:22:14',NULL),(1517,NULL,40719,22,2,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1330.00,NULL,NULL,1,'2022-06-09 21:22:15','2022-06-09 21:22:15',NULL),(1518,NULL,40719,22,2,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1370.00,NULL,NULL,1,'2022-06-09 21:22:16','2022-06-09 21:22:16',NULL),(1519,NULL,40719,22,2,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1648.00,NULL,NULL,1,'2022-06-09 21:22:17','2022-06-09 21:22:17',NULL),(1520,NULL,40719,22,2,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',900.00,NULL,NULL,1,'2022-06-09 21:22:18','2022-06-09 21:22:18',NULL),(1521,NULL,40719,22,2,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',705.00,NULL,NULL,1,'2022-06-09 21:22:18','2022-06-09 21:22:18',NULL),(1522,NULL,40719,22,2,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',802.00,NULL,NULL,1,'2022-06-09 21:22:19','2022-06-09 21:22:19',NULL),(1523,NULL,40719,22,2,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',934.00,NULL,NULL,1,'2022-06-09 21:22:20','2022-06-09 21:22:20',NULL),(1524,NULL,40719,22,2,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1650.00,NULL,NULL,1,'2022-06-09 21:22:21','2022-06-09 21:22:21',NULL),(1525,NULL,40719,22,2,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',751.00,NULL,NULL,1,'2022-06-09 21:22:21','2022-06-09 21:22:21',NULL),(1526,NULL,40719,22,2,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',970.00,NULL,NULL,1,'2022-06-09 21:22:22','2022-06-09 21:22:22',NULL),(1527,NULL,40719,22,2,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',800.00,NULL,NULL,1,'2022-06-09 21:22:23','2022-06-09 21:22:23',NULL),(1528,NULL,40719,22,2,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1500.00,NULL,NULL,1,'2022-06-09 21:22:24','2022-06-09 21:22:24',NULL),(1529,NULL,40719,22,2,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1502.00,NULL,NULL,1,'2022-06-09 21:22:25','2022-06-09 21:22:25',NULL),(1530,NULL,40719,22,2,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1371.00,NULL,NULL,1,'2022-06-09 21:22:25','2022-06-09 21:22:25',NULL),(1531,NULL,40719,22,2,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1392.00,NULL,NULL,1,'2022-06-09 21:22:26','2022-06-09 21:22:26',NULL);
INSERT INTO `balance_libro` VALUES (1532,NULL,40719,22,2,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1376.00,NULL,NULL,1,'2022-06-09 21:22:27','2022-06-09 21:22:27',NULL),(1533,NULL,40719,22,2,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1617.00,NULL,NULL,1,'2022-06-09 21:22:28','2022-06-09 21:22:28',NULL),(1534,NULL,40719,22,2,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1682.00,NULL,NULL,1,'2022-06-09 21:22:29','2022-06-09 21:22:29',NULL),(1535,NULL,40719,22,2,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',908.00,NULL,NULL,1,'2022-06-09 21:22:29','2022-06-09 21:22:29',NULL),(1536,NULL,40719,22,2,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1380.00,NULL,NULL,1,'2022-06-09 21:22:30','2022-06-09 21:22:30',NULL),(1537,NULL,40719,22,2,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1182.00,NULL,NULL,1,'2022-06-09 21:22:31','2022-06-09 21:22:31',NULL),(1538,NULL,40719,22,2,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',650.00,NULL,NULL,1,'2022-06-09 21:22:32','2022-06-09 21:22:32',NULL),(1539,NULL,40719,22,2,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',680.00,NULL,NULL,1,'2022-06-09 21:22:32','2022-06-09 21:22:32',NULL),(1540,NULL,40719,22,2,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',690.00,NULL,NULL,1,'2022-06-09 21:22:33','2022-06-09 21:22:33',NULL),(1541,NULL,40719,22,2,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',700.00,NULL,NULL,1,'2022-06-09 21:22:34','2022-06-09 21:22:34',NULL),(1542,NULL,40719,22,2,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',901.00,NULL,NULL,1,'2022-06-09 21:22:35','2022-06-09 21:22:35',NULL),(1543,NULL,40719,22,2,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1183.00,NULL,NULL,1,'2022-06-09 21:22:35','2022-06-09 21:22:35',NULL),(1544,NULL,40719,22,2,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1200.00,NULL,NULL,1,'2022-06-09 21:22:36','2022-06-09 21:22:36',NULL),(1545,NULL,40719,22,2,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1354.00,NULL,NULL,1,'2022-06-09 21:22:37','2022-06-09 21:22:37',NULL),(1546,NULL,40719,22,2,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1612.00,NULL,NULL,1,'2022-06-09 21:22:38','2022-06-09 21:22:38',NULL),(1547,NULL,40719,22,2,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',680.00,NULL,NULL,1,'2022-06-09 21:22:39','2022-06-09 21:22:39',NULL),(1548,NULL,40719,22,2,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',790.00,NULL,NULL,1,'2022-06-09 21:22:39','2022-06-09 21:22:39',NULL),(1549,NULL,40719,22,2,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',820.00,NULL,NULL,1,'2022-06-09 21:22:40','2022-06-09 21:22:40',NULL),(1550,NULL,40719,22,2,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1419.00,NULL,NULL,1,'2022-06-09 21:22:41','2022-06-09 21:22:41',NULL),(1551,NULL,40719,22,2,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',781.00,NULL,NULL,1,'2022-06-09 21:22:42','2022-06-09 21:22:42',NULL),(1552,NULL,40719,22,2,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1627.00,NULL,NULL,1,'2022-06-09 21:22:43','2022-06-09 21:22:43',NULL);
INSERT INTO `balance_libro` VALUES (1553,NULL,40719,22,2,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1493.00,NULL,NULL,1,'2022-06-09 21:22:43','2022-06-09 21:22:43',NULL),(1554,NULL,40719,22,2,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1680.00,NULL,NULL,1,'2022-06-09 21:22:44','2022-06-09 21:22:44',NULL),(1555,NULL,40719,22,2,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',901.00,NULL,NULL,1,'2022-06-09 21:22:45','2022-06-09 21:22:45',NULL),(1556,NULL,40719,22,2,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1604.00,NULL,NULL,1,'2022-06-09 21:22:46','2022-06-09 21:22:46',NULL),(1557,NULL,40719,22,2,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',782.00,NULL,NULL,1,'2022-06-09 21:22:47','2022-06-09 21:22:47',NULL),(1558,NULL,40719,22,2,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1000.00,NULL,NULL,1,'2022-06-09 21:22:47','2022-06-09 21:22:47',NULL),(1559,NULL,40719,22,2,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1200.00,NULL,NULL,1,'2022-06-09 21:22:48','2022-06-09 21:22:48',NULL),(1560,NULL,40719,22,2,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1641.00,NULL,NULL,1,'2022-06-09 21:22:49','2022-06-09 21:22:49',NULL),(1561,NULL,40719,22,2,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1645.00,NULL,NULL,1,'2022-06-09 21:22:50','2022-06-09 21:22:50',NULL),(1562,NULL,40719,22,2,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',854.00,NULL,NULL,1,'2022-06-09 21:22:50','2022-06-09 21:22:50',NULL),(1563,NULL,40719,22,2,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',951.00,NULL,NULL,1,'2022-06-09 21:22:51','2022-06-09 21:22:51',NULL),(1564,NULL,40719,22,2,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',753.00,NULL,NULL,1,'2022-06-09 21:22:52','2022-06-09 21:22:52',NULL),(1565,NULL,40719,22,2,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',852.00,NULL,NULL,1,'2022-06-09 21:22:53','2022-06-09 21:22:53',NULL),(1566,NULL,40719,22,2,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',654.00,NULL,NULL,1,'2022-06-09 21:22:53','2022-06-09 21:22:53',NULL),(1567,NULL,40719,22,2,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1809.00,NULL,NULL,1,'2022-06-09 21:22:54','2022-06-09 21:22:54',NULL),(1568,NULL,40719,22,2,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',871.00,NULL,NULL,1,'2022-06-09 21:22:55','2022-06-09 21:22:55',NULL),(1569,NULL,40719,22,2,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1741.00,NULL,NULL,1,'2022-06-09 21:22:56','2022-06-09 21:22:56',NULL),(1570,NULL,40719,22,2,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1753.00,NULL,NULL,1,'2022-06-09 21:22:57','2022-06-09 21:22:57',NULL),(1571,NULL,40719,22,2,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',957.00,NULL,NULL,1,'2022-06-09 21:22:57','2022-06-09 21:22:57',NULL),(1572,NULL,40719,22,2,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',859.00,NULL,NULL,1,'2022-06-09 21:22:58','2022-06-09 21:22:58',NULL),(1573,NULL,40719,22,2,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1670.00,NULL,NULL,1,'2022-06-09 21:22:59','2022-06-09 21:22:59',NULL);
INSERT INTO `balance_libro` VALUES (1574,NULL,40719,22,2,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1720.00,NULL,NULL,1,'2022-06-09 21:23:00','2022-06-09 21:23:00',NULL),(1575,NULL,40719,22,2,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1341.00,NULL,NULL,1,'2022-06-09 21:23:00','2022-06-09 21:23:00',NULL),(1576,NULL,40719,22,2,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1530.00,NULL,NULL,1,'2022-06-09 21:23:01','2022-06-09 21:23:01',NULL),(1577,NULL,40719,22,2,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2970.00,NULL,NULL,1,'2022-06-09 21:23:02','2022-06-09 21:23:02',NULL),(1578,NULL,40719,22,2,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1860.00,NULL,NULL,1,'2022-06-09 21:23:03','2022-06-09 21:23:03',NULL),(1579,NULL,40719,22,2,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2300.00,NULL,NULL,1,'2022-06-09 21:23:04','2022-06-09 21:23:04',NULL),(1580,NULL,40719,22,2,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2141.00,NULL,NULL,1,'2022-06-09 21:23:04','2022-06-09 21:23:04',NULL),(1581,NULL,40719,22,2,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1860.00,NULL,NULL,1,'2022-06-09 21:23:05','2022-06-09 21:23:05',NULL),(1582,NULL,40719,22,2,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1737.00,NULL,NULL,1,'2022-06-09 21:23:06','2022-06-09 21:23:06',NULL),(1583,NULL,40719,22,2,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1429.00,NULL,NULL,1,'2022-06-09 21:23:07','2022-06-09 21:23:07',NULL),(1584,NULL,40719,22,2,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',986.00,NULL,NULL,1,'2022-06-09 21:23:07','2022-06-09 21:23:07',NULL),(1585,NULL,40719,22,2,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',730.00,NULL,NULL,1,'2022-06-09 21:23:08','2022-06-09 21:23:08',NULL),(1586,NULL,40719,22,2,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1632.00,NULL,NULL,1,'2022-06-09 21:23:09','2022-06-09 21:23:09',NULL),(1587,NULL,40719,22,2,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2119.00,NULL,NULL,1,'2022-06-09 21:23:10','2022-06-09 21:23:10',NULL),(1588,NULL,40719,22,2,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',2343.00,NULL,NULL,1,'2022-06-09 21:23:11','2022-06-09 21:23:11',NULL),(1589,NULL,40719,22,2,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',990.00,NULL,NULL,1,'2022-06-09 21:23:11','2022-06-09 21:23:11',NULL),(1590,NULL,40719,22,2,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1700.00,NULL,NULL,1,'2022-06-09 21:23:12','2022-06-09 21:23:12',NULL),(1591,NULL,40719,22,2,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1733.00,NULL,NULL,1,'2022-06-09 21:23:13','2022-06-09 21:23:13',NULL),(1592,NULL,40719,22,2,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1767.00,NULL,NULL,1,'2022-06-09 21:23:14','2022-06-09 21:23:14',NULL),(1593,NULL,40719,22,2,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1820.00,NULL,NULL,1,'2022-06-09 21:23:14','2022-06-09 21:23:14',NULL),(1594,NULL,40719,22,2,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1763.00,NULL,NULL,1,'2022-06-09 21:23:15','2022-06-09 21:23:15',NULL);
INSERT INTO `balance_libro` VALUES (1595,NULL,40719,22,2,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1632.00,NULL,NULL,1,'2022-06-09 21:23:16','2022-06-09 21:23:16',NULL),(1596,NULL,40719,22,2,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1854.00,NULL,NULL,1,'2022-06-09 21:23:17','2022-06-09 21:23:17',NULL),(1597,NULL,40719,22,2,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1901.00,NULL,NULL,1,'2022-06-09 21:23:17','2022-06-09 21:23:17',NULL),(1598,NULL,40719,22,2,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1803.00,NULL,NULL,1,'2022-06-09 21:23:18','2022-06-09 21:23:18',NULL),(1599,NULL,40719,22,2,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1612.00,NULL,NULL,1,'2022-06-09 21:23:19','2022-06-09 21:23:19',NULL),(1600,NULL,40719,22,2,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1701.00,NULL,NULL,1,'2022-06-09 21:23:20','2022-06-09 21:23:20',NULL),(1601,NULL,40719,22,2,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1332.00,NULL,NULL,1,'2022-06-09 21:23:21','2022-06-09 21:23:21',NULL),(1602,NULL,40719,22,2,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1608.00,NULL,NULL,1,'2022-06-09 21:23:21','2022-06-09 21:23:21',NULL),(1603,NULL,40719,22,2,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1327.00,NULL,NULL,1,'2022-06-09 21:23:22','2022-06-09 21:23:22',NULL),(1604,NULL,40719,22,2,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1346.00,NULL,NULL,1,'2022-06-09 21:23:23','2022-06-09 21:23:23',NULL),(1605,NULL,40719,22,2,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1397.00,NULL,NULL,1,'2022-06-09 21:23:24','2022-06-09 21:23:24',NULL),(1606,NULL,40719,22,2,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1051.00,NULL,NULL,1,'2022-06-09 21:23:25','2022-06-09 21:23:25',NULL),(1607,NULL,40719,22,2,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',873.00,NULL,NULL,1,'2022-06-09 21:23:25','2022-06-09 21:23:25',NULL),(1608,NULL,40719,22,2,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1300.00,NULL,NULL,1,'2022-06-09 21:23:26','2022-06-09 21:23:26',NULL),(1609,NULL,40719,23,2,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1560.00,NULL,NULL,1,'2022-07-10 17:50:51','2022-07-10 17:50:51',NULL),(1610,NULL,40719,23,2,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',900.00,NULL,NULL,1,'2022-07-10 17:50:52','2022-07-10 17:50:52',NULL),(1611,NULL,40719,23,2,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1300.00,NULL,NULL,1,'2022-07-10 17:50:53','2022-07-10 17:50:53',NULL),(1612,NULL,40719,23,2,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2300.00,NULL,NULL,1,'2022-07-10 17:50:54','2022-07-10 17:50:54',NULL),(1613,NULL,40719,23,2,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',800.00,NULL,NULL,1,'2022-07-10 17:50:55','2022-07-10 17:50:55',NULL),(1614,NULL,40719,23,2,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',905.00,NULL,NULL,1,'2022-07-10 17:50:56','2022-07-10 17:50:56',NULL),(1615,NULL,40719,23,2,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1643.00,NULL,NULL,1,'2022-07-10 17:50:57','2022-07-10 17:50:57',NULL);
INSERT INTO `balance_libro` VALUES (1616,NULL,40719,23,2,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1179.00,NULL,NULL,1,'2022-07-10 17:50:58','2022-07-10 17:50:58',NULL),(1617,NULL,40719,23,2,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1200.00,NULL,NULL,1,'2022-07-10 17:50:59','2022-07-10 17:50:59',NULL),(1618,NULL,40719,23,2,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',790.00,NULL,NULL,1,'2022-07-10 17:51:00','2022-07-10 17:51:00',NULL),(1619,NULL,40719,23,2,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',790.00,NULL,NULL,1,'2022-07-10 17:51:01','2022-07-10 17:51:01',NULL),(1620,NULL,40719,23,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1330.00,NULL,NULL,1,'2022-07-10 17:51:02','2022-07-10 17:51:02',NULL),(1621,NULL,40719,23,2,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1370.00,NULL,NULL,1,'2022-07-10 17:51:03','2022-07-10 17:51:03',NULL),(1622,NULL,40719,23,2,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1648.00,NULL,NULL,1,'2022-07-10 17:51:04','2022-07-10 17:51:04',NULL),(1623,NULL,40719,23,2,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',900.00,NULL,NULL,1,'2022-07-10 17:51:05','2022-07-10 17:51:05',NULL),(1624,NULL,40719,23,2,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',705.00,NULL,NULL,1,'2022-07-10 17:51:06','2022-07-10 17:51:06',NULL),(1625,NULL,40719,23,2,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',802.00,NULL,NULL,1,'2022-07-10 17:51:07','2022-07-10 17:51:07',NULL),(1626,NULL,40719,23,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',934.00,NULL,NULL,1,'2022-07-10 17:51:08','2022-07-10 17:51:08',NULL),(1627,NULL,40719,23,2,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1650.00,NULL,NULL,1,'2022-07-10 17:51:09','2022-07-10 17:51:09',NULL),(1628,NULL,40719,23,2,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',751.00,NULL,NULL,1,'2022-07-10 17:51:10','2022-07-10 17:51:10',NULL),(1629,NULL,40719,23,2,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',970.00,NULL,NULL,1,'2022-07-10 17:51:11','2022-07-10 17:51:11',NULL),(1630,NULL,40719,23,2,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',800.00,NULL,NULL,1,'2022-07-10 17:51:12','2022-07-10 17:51:12',NULL),(1631,NULL,40719,23,2,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1500.00,NULL,NULL,1,'2022-07-10 17:51:13','2022-07-10 17:51:13',NULL),(1632,NULL,40719,23,2,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1502.00,NULL,NULL,1,'2022-07-10 17:51:14','2022-07-10 17:51:14',NULL),(1633,NULL,40719,23,2,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1371.00,NULL,NULL,1,'2022-07-10 17:51:15','2022-07-10 17:51:15',NULL),(1634,NULL,40719,23,2,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1392.00,NULL,NULL,1,'2022-07-10 17:51:16','2022-07-10 17:51:16',NULL),(1635,NULL,40719,23,2,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1376.00,NULL,NULL,1,'2022-07-10 17:51:17','2022-07-10 17:51:17',NULL),(1636,NULL,40719,23,2,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1617.00,NULL,NULL,1,'2022-07-10 17:51:18','2022-07-10 17:51:18',NULL);
INSERT INTO `balance_libro` VALUES (1637,NULL,40719,23,2,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1682.00,NULL,NULL,1,'2022-07-10 17:51:19','2022-07-10 17:51:19',NULL),(1638,NULL,40719,23,2,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',908.00,NULL,NULL,1,'2022-07-10 17:51:20','2022-07-10 17:51:20',NULL),(1639,NULL,40719,23,2,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1380.00,NULL,NULL,1,'2022-07-10 17:51:21','2022-07-10 17:51:21',NULL),(1640,NULL,40719,23,2,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1182.00,NULL,NULL,1,'2022-07-10 17:51:22','2022-07-10 17:51:22',NULL),(1641,NULL,40719,23,2,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',650.00,NULL,NULL,1,'2022-07-10 17:51:23','2022-07-10 17:51:23',NULL),(1642,NULL,40719,23,2,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',680.00,NULL,NULL,1,'2022-07-10 17:51:24','2022-07-10 17:51:24',NULL),(1643,NULL,40719,23,2,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',690.00,NULL,NULL,1,'2022-07-10 17:51:25','2022-07-10 17:51:25',NULL),(1644,NULL,40719,23,2,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',700.00,NULL,NULL,1,'2022-07-10 17:51:26','2022-07-10 17:51:26',NULL),(1645,NULL,40719,23,2,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',901.00,NULL,NULL,1,'2022-07-10 17:51:27','2022-07-10 17:51:27',NULL),(1646,NULL,40719,23,2,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1183.00,NULL,NULL,1,'2022-07-10 17:51:28','2022-07-10 17:51:28',NULL),(1647,NULL,40719,23,2,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1200.00,NULL,NULL,1,'2022-07-10 17:51:29','2022-07-10 17:51:29',NULL),(1648,NULL,40719,23,2,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1354.00,NULL,NULL,1,'2022-07-10 17:51:30','2022-07-10 17:51:30',NULL),(1649,NULL,40719,23,2,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1612.00,NULL,NULL,1,'2022-07-10 17:51:31','2022-07-10 17:51:31',NULL),(1650,NULL,40719,23,2,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',680.00,NULL,NULL,1,'2022-07-10 17:51:32','2022-07-10 17:51:32',NULL),(1651,NULL,40719,23,2,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',790.00,NULL,NULL,1,'2022-07-10 17:51:33','2022-07-10 17:51:33',NULL),(1652,NULL,40719,23,2,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',820.00,NULL,NULL,1,'2022-07-10 17:51:34','2022-07-10 17:51:34',NULL),(1653,NULL,40719,23,2,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1419.00,NULL,NULL,1,'2022-07-10 17:51:35','2022-07-10 17:51:35',NULL),(1654,NULL,40719,23,2,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',781.00,NULL,NULL,1,'2022-07-10 17:51:36','2022-07-10 17:51:36',NULL),(1655,NULL,40719,23,2,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1627.00,NULL,NULL,1,'2022-07-10 17:51:37','2022-07-10 17:51:37',NULL),(1656,NULL,40719,23,2,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1493.00,NULL,NULL,1,'2022-07-10 17:51:38','2022-07-10 17:51:38',NULL),(1657,NULL,40719,23,2,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1680.00,NULL,NULL,1,'2022-07-10 17:51:39','2022-07-10 17:51:39',NULL);
INSERT INTO `balance_libro` VALUES (1658,NULL,40719,23,2,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',901.00,NULL,NULL,1,'2022-07-10 17:51:40','2022-07-10 17:51:40',NULL),(1659,NULL,40719,23,2,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1604.00,NULL,NULL,1,'2022-07-10 17:51:41','2022-07-10 17:51:41',NULL),(1660,NULL,40719,23,2,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',782.00,NULL,NULL,1,'2022-07-10 17:51:42','2022-07-10 17:51:42',NULL),(1661,NULL,40719,23,2,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1000.00,NULL,NULL,1,'2022-07-10 17:51:43','2022-07-10 17:51:43',NULL),(1662,NULL,40719,23,2,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1200.00,NULL,NULL,1,'2022-07-10 17:51:44','2022-07-10 17:51:44',NULL),(1663,NULL,40719,23,2,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1641.00,NULL,NULL,1,'2022-07-10 17:51:45','2022-07-10 17:51:45',NULL),(1664,NULL,40719,23,2,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1645.00,NULL,NULL,1,'2022-07-10 17:51:46','2022-07-10 17:51:46',NULL),(1665,NULL,40719,23,2,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',854.00,NULL,NULL,1,'2022-07-10 17:51:47','2022-07-10 17:51:47',NULL),(1666,NULL,40719,23,2,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',951.00,NULL,NULL,1,'2022-07-10 17:51:48','2022-07-10 17:51:48',NULL),(1667,NULL,40719,23,2,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',753.00,NULL,NULL,1,'2022-07-10 17:51:49','2022-07-10 17:51:49',NULL),(1668,NULL,40719,23,2,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',852.00,NULL,NULL,1,'2022-07-10 17:51:50','2022-07-10 17:51:50',NULL),(1669,NULL,40719,23,2,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',654.00,NULL,NULL,1,'2022-07-10 17:51:51','2022-07-10 17:51:51',NULL),(1670,NULL,40719,23,2,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1809.00,NULL,NULL,1,'2022-07-10 17:51:52','2022-07-10 17:51:52',NULL),(1671,NULL,40719,23,2,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',871.00,NULL,NULL,1,'2022-07-10 17:51:53','2022-07-10 17:51:53',NULL),(1672,NULL,40719,23,2,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1741.00,NULL,NULL,1,'2022-07-10 17:51:54','2022-07-10 17:51:54',NULL),(1673,NULL,40719,23,2,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1753.00,NULL,NULL,1,'2022-07-10 17:51:55','2022-07-10 17:51:55',NULL),(1674,NULL,40719,23,2,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',957.00,NULL,NULL,1,'2022-07-10 17:51:56','2022-07-10 17:51:56',NULL),(1675,NULL,40719,23,2,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',859.00,NULL,NULL,1,'2022-07-10 17:51:57','2022-07-10 17:51:57',NULL),(1676,NULL,40719,23,2,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1670.00,NULL,NULL,1,'2022-07-10 17:51:58','2022-07-10 17:51:58',NULL),(1677,NULL,40719,23,2,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1720.00,NULL,NULL,1,'2022-07-10 17:51:59','2022-07-10 17:51:59',NULL),(1678,NULL,40719,23,2,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1341.00,NULL,NULL,1,'2022-07-10 17:52:00','2022-07-10 17:52:00',NULL);
INSERT INTO `balance_libro` VALUES (1679,NULL,40719,23,2,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1530.00,NULL,NULL,1,'2022-07-10 17:52:01','2022-07-10 17:52:01',NULL),(1680,NULL,40719,23,2,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2970.00,NULL,NULL,1,'2022-07-10 17:52:02','2022-07-10 17:52:02',NULL),(1681,NULL,40719,23,2,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1860.00,NULL,NULL,1,'2022-07-10 17:52:03','2022-07-10 17:52:03',NULL),(1682,NULL,40719,23,2,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2300.00,NULL,NULL,1,'2022-07-10 17:52:04','2022-07-10 17:52:04',NULL),(1683,NULL,40719,23,2,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2141.00,NULL,NULL,1,'2022-07-10 17:52:04','2022-07-10 17:52:04',NULL),(1684,NULL,40719,23,2,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1860.00,NULL,NULL,1,'2022-07-10 17:52:05','2022-07-10 17:52:05',NULL),(1685,NULL,40719,23,2,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1737.00,NULL,NULL,1,'2022-07-10 17:52:06','2022-07-10 17:52:06',NULL),(1686,NULL,40719,23,2,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1429.00,NULL,NULL,1,'2022-07-10 17:52:07','2022-07-10 17:52:07',NULL),(1687,NULL,40719,23,2,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',986.00,NULL,NULL,1,'2022-07-10 17:52:08','2022-07-10 17:52:08',NULL),(1688,NULL,40719,23,2,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',730.00,NULL,NULL,1,'2022-07-10 17:52:09','2022-07-10 17:52:09',NULL),(1689,NULL,40719,23,2,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1632.00,NULL,NULL,1,'2022-07-10 17:52:10','2022-07-10 17:52:10',NULL),(1690,NULL,40719,23,2,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2119.00,NULL,NULL,1,'2022-07-10 17:52:11','2022-07-10 17:52:11',NULL),(1691,NULL,40719,23,2,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2343.00,NULL,NULL,1,'2022-07-10 17:52:12','2022-07-10 17:52:12',NULL),(1692,NULL,40719,23,2,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',990.00,NULL,NULL,1,'2022-07-10 17:52:13','2022-07-10 17:52:13',NULL),(1693,NULL,40719,23,2,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1700.00,NULL,NULL,1,'2022-07-10 17:52:14','2022-07-10 17:52:14',NULL),(1694,NULL,40719,23,2,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1733.00,NULL,NULL,1,'2022-07-10 17:52:15','2022-07-10 17:52:15',NULL),(1695,NULL,40719,23,2,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1767.00,NULL,NULL,1,'2022-07-10 17:52:16','2022-07-10 17:52:16',NULL),(1696,NULL,40719,23,2,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1820.00,NULL,NULL,1,'2022-07-10 17:52:17','2022-07-10 17:52:17',NULL),(1697,NULL,40719,23,2,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1763.00,NULL,NULL,1,'2022-07-10 17:52:18','2022-07-10 17:52:18',NULL),(1698,NULL,40719,23,2,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1632.00,NULL,NULL,1,'2022-07-10 17:52:19','2022-07-10 17:52:19',NULL),(1699,NULL,40719,23,2,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1854.00,NULL,NULL,1,'2022-07-10 17:52:20','2022-07-10 17:52:20',NULL);
INSERT INTO `balance_libro` VALUES (1700,NULL,40719,23,2,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1901.00,NULL,NULL,1,'2022-07-10 17:52:21','2022-07-10 17:52:21',NULL),(1701,NULL,40719,23,2,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1803.00,NULL,NULL,1,'2022-07-10 17:52:22','2022-07-10 17:52:22',NULL),(1702,NULL,40719,23,2,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1612.00,NULL,NULL,1,'2022-07-10 17:52:23','2022-07-10 17:52:23',NULL),(1703,NULL,40719,23,2,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1701.00,NULL,NULL,1,'2022-07-10 17:52:24','2022-07-10 17:52:24',NULL),(1704,NULL,40719,23,2,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1332.00,NULL,NULL,1,'2022-07-10 17:52:25','2022-07-10 17:52:25',NULL),(1705,NULL,40719,23,2,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1608.00,NULL,NULL,1,'2022-07-10 17:52:26','2022-07-10 17:52:26',NULL),(1706,NULL,40719,23,2,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1327.00,NULL,NULL,1,'2022-07-10 17:52:27','2022-07-10 17:52:27',NULL),(1707,NULL,40719,23,2,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1346.00,NULL,NULL,1,'2022-07-10 17:52:28','2022-07-10 17:52:28',NULL),(1708,NULL,40719,23,2,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1397.00,NULL,NULL,1,'2022-07-10 17:52:29','2022-07-10 17:52:29',NULL),(1709,NULL,40719,23,2,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1051.00,NULL,NULL,1,'2022-07-10 17:52:30','2022-07-10 17:52:30',NULL),(1710,NULL,40719,23,2,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',873.00,NULL,NULL,1,'2022-07-10 17:52:31','2022-07-10 17:52:31',NULL),(1711,NULL,40719,23,2,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',1300.00,NULL,NULL,1,'2022-07-10 17:52:32','2022-07-10 17:52:32',NULL),(1712,NULL,40719,24,2,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1560.00,NULL,NULL,1,'2022-08-10 20:46:07','2022-08-10 20:46:07',NULL),(1713,NULL,40719,24,2,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',900.00,NULL,NULL,1,'2022-08-10 20:46:08','2022-08-10 20:46:08',NULL),(1714,NULL,40719,24,2,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1300.00,NULL,NULL,1,'2022-08-10 20:46:09','2022-08-10 20:46:09',NULL),(1715,NULL,40719,24,2,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2300.00,NULL,NULL,1,'2022-08-10 20:46:10','2022-08-10 20:46:10',NULL),(1716,NULL,40719,24,2,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',800.00,NULL,NULL,1,'2022-08-10 20:46:11','2022-08-10 20:46:11',NULL),(1717,NULL,40719,24,2,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',905.00,NULL,NULL,1,'2022-08-10 20:46:12','2022-08-10 20:46:12',NULL),(1718,NULL,40719,24,2,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1643.00,NULL,NULL,1,'2022-08-10 20:46:13','2022-08-10 20:46:13',NULL),(1719,NULL,40719,24,2,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1179.00,NULL,NULL,1,'2022-08-10 20:46:14','2022-08-10 20:46:14',NULL),(1720,NULL,40719,24,2,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1200.00,NULL,NULL,1,'2022-08-10 20:46:15','2022-08-10 20:46:15',NULL);
INSERT INTO `balance_libro` VALUES (1721,NULL,40719,24,2,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',790.00,NULL,NULL,1,'2022-08-10 20:46:16','2022-08-10 20:46:16',NULL),(1722,NULL,40719,24,2,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',790.00,NULL,NULL,1,'2022-08-10 20:46:17','2022-08-10 20:46:17',NULL),(1723,NULL,40719,24,2,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1330.00,NULL,NULL,1,'2022-08-10 20:46:18','2022-08-10 20:46:18',NULL),(1724,NULL,40719,24,2,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1370.00,NULL,NULL,1,'2022-08-10 20:46:19','2022-08-10 20:46:19',NULL),(1725,NULL,40719,24,2,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1648.00,NULL,NULL,1,'2022-08-10 20:46:20','2022-08-10 20:46:20',NULL),(1726,NULL,40719,24,2,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',900.00,NULL,NULL,1,'2022-08-10 20:46:21','2022-08-10 20:46:21',NULL),(1727,NULL,40719,24,2,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',705.00,NULL,NULL,1,'2022-08-10 20:46:22','2022-08-10 20:46:22',NULL),(1728,NULL,40719,24,2,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',802.00,NULL,NULL,1,'2022-08-10 20:46:23','2022-08-10 20:46:23',NULL),(1729,NULL,40719,24,2,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',934.00,NULL,NULL,1,'2022-08-10 20:46:24','2022-08-10 20:46:24',NULL),(1730,NULL,40719,24,2,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1650.00,NULL,NULL,1,'2022-08-10 20:46:25','2022-08-10 20:46:25',NULL),(1731,NULL,40719,24,2,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',751.00,NULL,NULL,1,'2022-08-10 20:46:26','2022-08-10 20:46:26',NULL),(1732,NULL,40719,24,2,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',970.00,NULL,NULL,1,'2022-08-10 20:46:27','2022-08-10 20:46:27',NULL),(1733,NULL,40719,24,2,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',800.00,NULL,NULL,1,'2022-08-10 20:46:28','2022-08-10 20:46:28',NULL),(1734,NULL,40719,24,2,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1500.00,NULL,NULL,1,'2022-08-10 20:46:29','2022-08-10 20:46:29',NULL),(1735,NULL,40719,24,2,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1502.00,NULL,NULL,1,'2022-08-10 20:46:30','2022-08-10 20:46:30',NULL),(1736,NULL,40719,24,2,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1371.00,NULL,NULL,1,'2022-08-10 20:46:31','2022-08-10 20:46:31',NULL),(1737,NULL,40719,24,2,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1392.00,NULL,NULL,1,'2022-08-10 20:46:32','2022-08-10 20:46:32',NULL),(1738,NULL,40719,24,2,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1376.00,NULL,NULL,1,'2022-08-10 20:46:33','2022-08-10 20:46:33',NULL),(1739,NULL,40719,24,2,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1617.00,NULL,NULL,1,'2022-08-10 20:46:34','2022-08-10 20:46:34',NULL),(1740,NULL,40719,24,2,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1682.00,NULL,NULL,1,'2022-08-10 20:46:35','2022-08-10 20:46:35',NULL),(1741,NULL,40719,24,2,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',908.00,NULL,NULL,1,'2022-08-10 20:46:36','2022-08-10 20:46:36',NULL);
INSERT INTO `balance_libro` VALUES (1742,NULL,40719,24,2,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1380.00,NULL,NULL,1,'2022-08-10 20:46:37','2022-08-10 20:46:37',NULL),(1743,NULL,40719,24,2,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1182.00,NULL,NULL,1,'2022-08-10 20:46:39','2022-08-10 20:46:39',NULL),(1744,NULL,40719,24,2,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',650.00,NULL,NULL,1,'2022-08-10 20:46:40','2022-08-10 20:46:40',NULL),(1745,NULL,40719,24,2,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',680.00,NULL,NULL,1,'2022-08-10 20:46:41','2022-08-10 20:46:41',NULL),(1746,NULL,40719,24,2,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',690.00,NULL,NULL,1,'2022-08-10 20:46:42','2022-08-10 20:46:42',NULL),(1747,NULL,40719,24,2,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',700.00,NULL,NULL,1,'2022-08-10 20:46:43','2022-08-10 20:46:43',NULL),(1748,NULL,40719,24,2,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',901.00,NULL,NULL,1,'2022-08-10 20:46:44','2022-08-10 20:46:44',NULL),(1749,NULL,40719,24,2,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1183.00,NULL,NULL,1,'2022-08-10 20:46:45','2022-08-10 20:46:45',NULL),(1750,NULL,40719,24,2,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1200.00,NULL,NULL,1,'2022-08-10 20:46:46','2022-08-10 20:46:46',NULL),(1751,NULL,40719,24,2,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1354.00,NULL,NULL,1,'2022-08-10 20:46:47','2022-08-10 20:46:47',NULL),(1752,NULL,40719,24,2,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1612.00,NULL,NULL,1,'2022-08-10 20:46:48','2022-08-10 20:46:48',NULL),(1753,NULL,40719,24,2,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',680.00,NULL,NULL,1,'2022-08-10 20:46:49','2022-08-10 20:46:49',NULL),(1754,NULL,40719,24,2,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',790.00,NULL,NULL,1,'2022-08-10 20:46:50','2022-08-10 20:46:50',NULL),(1755,NULL,40719,24,2,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',820.00,NULL,NULL,1,'2022-08-10 20:46:51','2022-08-10 20:46:51',NULL),(1756,NULL,40719,24,2,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1419.00,NULL,NULL,1,'2022-08-10 20:46:52','2022-08-10 20:46:52',NULL),(1757,NULL,40719,24,2,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',781.00,NULL,NULL,1,'2022-08-10 20:46:53','2022-08-10 20:46:53',NULL),(1758,NULL,40719,24,2,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1627.00,NULL,NULL,1,'2022-08-10 20:46:54','2022-08-10 20:46:54',NULL),(1759,NULL,40719,24,2,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1493.00,NULL,NULL,1,'2022-08-10 20:46:55','2022-08-10 20:46:55',NULL),(1760,NULL,40719,24,2,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1680.00,NULL,NULL,1,'2022-08-10 20:46:56','2022-08-10 20:46:56',NULL),(1761,NULL,40719,24,2,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',901.00,NULL,NULL,1,'2022-08-10 20:46:57','2022-08-10 20:46:57',NULL),(1762,NULL,40719,24,2,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1604.00,NULL,NULL,1,'2022-08-10 20:46:58','2022-08-10 20:46:58',NULL);
INSERT INTO `balance_libro` VALUES (1763,NULL,40719,24,2,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',782.00,NULL,NULL,1,'2022-08-10 20:46:59','2022-08-10 20:46:59',NULL),(1764,NULL,40719,24,2,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1000.00,NULL,NULL,1,'2022-08-10 20:47:00','2022-08-10 20:47:00',NULL),(1765,NULL,40719,24,2,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1200.00,NULL,NULL,1,'2022-08-10 20:47:02','2022-08-10 20:47:02',NULL),(1766,NULL,40719,24,2,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1641.00,NULL,NULL,1,'2022-08-10 20:47:03','2022-08-10 20:47:03',NULL),(1767,NULL,40719,24,2,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1645.00,NULL,NULL,1,'2022-08-10 20:47:04','2022-08-10 20:47:04',NULL),(1768,NULL,40719,24,2,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',854.00,NULL,NULL,1,'2022-08-10 20:47:05','2022-08-10 20:47:05',NULL),(1769,NULL,40719,24,2,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',951.00,NULL,NULL,1,'2022-08-10 20:47:06','2022-08-10 20:47:06',NULL),(1770,NULL,40719,24,2,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',753.00,NULL,NULL,1,'2022-08-10 20:47:07','2022-08-10 20:47:07',NULL),(1771,NULL,40719,24,2,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',852.00,NULL,NULL,1,'2022-08-10 20:47:08','2022-08-10 20:47:08',NULL),(1772,NULL,40719,24,2,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',654.00,NULL,NULL,1,'2022-08-10 20:47:09','2022-08-10 20:47:09',NULL),(1773,NULL,40719,24,2,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1809.00,NULL,NULL,1,'2022-08-10 20:47:10','2022-08-10 20:47:10',NULL),(1774,NULL,40719,24,2,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',871.00,NULL,NULL,1,'2022-08-10 20:47:11','2022-08-10 20:47:11',NULL),(1775,NULL,40719,24,2,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1741.00,NULL,NULL,1,'2022-08-10 20:47:12','2022-08-10 20:47:12',NULL),(1776,NULL,40719,24,2,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1753.00,NULL,NULL,1,'2022-08-10 20:47:13','2022-08-10 20:47:13',NULL),(1777,NULL,40719,24,2,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',957.00,NULL,NULL,1,'2022-08-10 20:47:14','2022-08-10 20:47:14',NULL),(1778,NULL,40719,24,2,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',859.00,NULL,NULL,1,'2022-08-10 20:47:15','2022-08-10 20:47:15',NULL),(1779,NULL,40719,24,2,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1670.00,NULL,NULL,1,'2022-08-10 20:47:16','2022-08-10 20:47:16',NULL),(1780,NULL,40719,24,2,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1720.00,NULL,NULL,1,'2022-08-10 20:47:17','2022-08-10 20:47:17',NULL),(1781,NULL,40719,24,2,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1341.00,NULL,NULL,1,'2022-08-10 20:47:18','2022-08-10 20:47:18',NULL),(1782,NULL,40719,24,2,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1530.00,NULL,NULL,1,'2022-08-10 20:47:19','2022-08-10 20:47:19',NULL),(1783,NULL,40719,24,2,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2970.00,NULL,NULL,1,'2022-08-10 20:47:20','2022-08-10 20:47:20',NULL);
INSERT INTO `balance_libro` VALUES (1784,NULL,40719,24,2,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1860.00,NULL,NULL,1,'2022-08-10 20:47:21','2022-08-10 20:47:21',NULL),(1785,NULL,40719,24,2,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2300.00,NULL,NULL,1,'2022-08-10 20:47:23','2022-08-10 20:47:23',NULL),(1786,NULL,40719,24,2,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2141.00,NULL,NULL,1,'2022-08-10 20:47:24','2022-08-10 20:47:24',NULL),(1787,NULL,40719,24,2,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1860.00,NULL,NULL,1,'2022-08-10 20:47:25','2022-08-10 20:47:25',NULL),(1788,NULL,40719,24,2,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1737.00,NULL,NULL,1,'2022-08-10 20:47:26','2022-08-10 20:47:26',NULL),(1789,NULL,40719,24,2,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1429.00,NULL,NULL,1,'2022-08-10 20:47:27','2022-08-10 20:47:27',NULL),(1790,NULL,40719,24,2,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',986.00,NULL,NULL,1,'2022-08-10 20:47:28','2022-08-10 20:47:28',NULL),(1791,NULL,40719,24,2,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',730.00,NULL,NULL,1,'2022-08-10 20:47:29','2022-08-10 20:47:29',NULL),(1792,NULL,40719,24,2,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1632.00,NULL,NULL,1,'2022-08-10 20:47:30','2022-08-10 20:47:30',NULL),(1793,NULL,40719,24,2,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2119.00,NULL,NULL,1,'2022-08-10 20:47:31','2022-08-10 20:47:31',NULL),(1794,NULL,40719,24,2,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',2343.00,NULL,NULL,1,'2022-08-10 20:47:32','2022-08-10 20:47:32',NULL),(1795,NULL,40719,24,2,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',990.00,NULL,NULL,1,'2022-08-10 20:47:33','2022-08-10 20:47:33',NULL),(1796,NULL,40719,24,2,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1700.00,NULL,NULL,1,'2022-08-10 20:47:34','2022-08-10 20:47:34',NULL),(1797,NULL,40719,24,2,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1733.00,NULL,NULL,1,'2022-08-10 20:47:35','2022-08-10 20:47:35',NULL),(1798,NULL,40719,24,2,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1767.00,NULL,NULL,1,'2022-08-10 20:47:36','2022-08-10 20:47:36',NULL),(1799,NULL,40719,24,2,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1820.00,NULL,NULL,1,'2022-08-10 20:47:37','2022-08-10 20:47:37',NULL),(1800,NULL,40719,24,2,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1763.00,NULL,NULL,1,'2022-08-10 20:47:38','2022-08-10 20:47:38',NULL),(1801,NULL,40719,24,2,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1632.00,NULL,NULL,1,'2022-08-10 20:47:40','2022-08-10 20:47:40',NULL),(1802,NULL,40719,24,2,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1854.00,NULL,NULL,1,'2022-08-10 20:47:41','2022-08-10 20:47:41',NULL),(1803,NULL,40719,24,2,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1901.00,NULL,NULL,1,'2022-08-10 20:47:42','2022-08-10 20:47:42',NULL),(1804,NULL,40719,24,2,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1803.00,NULL,NULL,1,'2022-08-10 20:47:43','2022-08-10 20:47:43',NULL);
INSERT INTO `balance_libro` VALUES (1805,NULL,40719,24,2,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1612.00,NULL,NULL,1,'2022-08-10 20:47:44','2022-08-10 20:47:44',NULL),(1806,NULL,40719,24,2,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1701.00,NULL,NULL,1,'2022-08-10 20:47:45','2022-08-10 20:47:45',NULL),(1807,NULL,40719,24,2,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1332.00,NULL,NULL,1,'2022-08-10 20:47:46','2022-08-10 20:47:46',NULL),(1808,NULL,40719,24,2,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1608.00,NULL,NULL,1,'2022-08-10 20:47:47','2022-08-10 20:47:47',NULL),(1809,NULL,40719,24,2,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1327.00,NULL,NULL,1,'2022-08-10 20:47:48','2022-08-10 20:47:48',NULL),(1810,NULL,40719,24,2,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1346.00,NULL,NULL,1,'2022-08-10 20:47:49','2022-08-10 20:47:49',NULL),(1811,NULL,40719,24,2,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1397.00,NULL,NULL,1,'2022-08-10 20:47:50','2022-08-10 20:47:50',NULL),(1812,NULL,40719,24,2,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1051.00,NULL,NULL,1,'2022-08-10 20:47:51','2022-08-10 20:47:51',NULL),(1813,NULL,40719,24,2,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',873.00,NULL,NULL,1,'2022-08-10 20:47:52','2022-08-10 20:47:52',NULL),(1814,NULL,40719,24,2,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1300.00,NULL,NULL,1,'2022-08-10 20:47:53','2022-08-10 20:47:53',NULL),(1815,NULL,40719,27,2,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',607.00,NULL,NULL,1,'2022-10-30 22:20:13','2022-10-30 22:20:13',NULL),(1816,NULL,40719,27,2,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',482.00,NULL,NULL,1,'2022-10-30 22:20:14','2022-10-30 22:20:14',NULL),(1817,NULL,40719,27,2,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',517.00,NULL,NULL,1,'2022-10-30 22:20:15','2022-10-30 22:20:15',NULL),(1818,NULL,40719,27,2,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',601.00,NULL,NULL,1,'2022-10-30 22:20:16','2022-10-30 22:20:16',NULL),(1819,NULL,40719,27,2,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',708.00,NULL,NULL,1,'2022-10-30 22:20:17','2022-10-30 22:20:17',NULL),(1820,NULL,40719,27,2,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',433.00,NULL,NULL,1,'2022-10-30 22:20:18','2022-10-30 22:20:18',NULL),(1821,NULL,40719,27,2,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',380.00,NULL,NULL,1,'2022-10-30 22:20:19','2022-10-30 22:20:19',NULL),(1822,NULL,40719,27,2,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',910.00,NULL,NULL,1,'2022-10-30 22:20:20','2022-10-30 22:20:20',NULL),(1823,NULL,40719,27,2,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',604.00,NULL,NULL,1,'2022-10-30 22:20:21','2022-10-30 22:20:21',NULL),(1824,NULL,40719,27,2,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',451.00,NULL,NULL,1,'2022-10-30 22:20:22','2022-10-30 22:20:22',NULL),(1825,NULL,40719,27,2,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',311.00,NULL,NULL,1,'2022-10-30 22:20:23','2022-10-30 22:20:23',NULL);
INSERT INTO `balance_libro` VALUES (1826,NULL,40719,27,2,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',841.00,NULL,NULL,1,'2022-10-30 22:20:24','2022-10-30 22:20:24',NULL),(1827,NULL,40719,27,2,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',500.00,NULL,NULL,1,'2022-10-30 22:20:25','2022-10-30 22:20:25',NULL),(1828,NULL,40719,27,2,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:20:26','2022-10-30 22:20:26',NULL),(1829,NULL,40719,27,2,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-10-30 22:20:27','2022-10-30 22:20:27',NULL),(1830,NULL,40719,27,2,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',300.00,NULL,NULL,1,'2022-10-30 22:20:28','2022-10-30 22:20:28',NULL),(1831,NULL,40719,27,2,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',578.00,NULL,NULL,1,'2022-10-30 22:20:29','2022-10-30 22:20:29',NULL),(1832,NULL,40719,27,2,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',641.00,NULL,NULL,1,'2022-10-30 22:20:29','2022-10-30 22:20:29',NULL),(1833,NULL,40719,27,2,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',741.00,NULL,NULL,1,'2022-10-30 22:20:30','2022-10-30 22:20:30',NULL),(1834,NULL,40719,27,2,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',188.00,NULL,NULL,1,'2022-10-30 22:20:31','2022-10-30 22:20:31',NULL),(1835,NULL,40719,27,2,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',607.00,NULL,NULL,1,'2022-10-30 22:20:32','2022-10-30 22:20:32',NULL),(1836,NULL,40719,27,2,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:20:33','2022-10-30 22:20:33',NULL),(1837,NULL,40719,27,2,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',800.00,NULL,NULL,1,'2022-10-30 22:20:34','2022-10-30 22:20:34',NULL),(1838,NULL,40719,27,2,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',300.00,NULL,NULL,1,'2022-10-30 22:20:35','2022-10-30 22:20:35',NULL),(1839,NULL,40719,27,2,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-10-30 22:20:36','2022-10-30 22:20:36',NULL),(1840,NULL,40719,27,2,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',500.00,NULL,NULL,1,'2022-10-30 22:20:37','2022-10-30 22:20:37',NULL),(1841,NULL,40719,27,2,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:20:38','2022-10-30 22:20:38',NULL),(1842,NULL,40719,27,2,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',900.00,NULL,NULL,1,'2022-10-30 22:20:39','2022-10-30 22:20:39',NULL),(1843,NULL,40719,27,2,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',455.00,NULL,NULL,1,'2022-10-30 22:20:40','2022-10-30 22:20:40',NULL),(1844,NULL,40719,27,2,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',655.00,NULL,NULL,1,'2022-10-30 22:20:41','2022-10-30 22:20:41',NULL),(1845,NULL,40719,27,2,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',211.00,NULL,NULL,1,'2022-10-30 22:20:42','2022-10-30 22:20:42',NULL),(1846,NULL,40719,27,2,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',447.00,NULL,NULL,1,'2022-10-30 22:20:43','2022-10-30 22:20:43',NULL);
INSERT INTO `balance_libro` VALUES (1847,NULL,40719,27,2,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',558.00,NULL,NULL,1,'2022-10-30 22:20:44','2022-10-30 22:20:44',NULL),(1848,NULL,40719,27,2,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',330.00,NULL,NULL,1,'2022-10-30 22:20:45','2022-10-30 22:20:45',NULL),(1849,NULL,40719,27,2,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',990.00,NULL,NULL,1,'2022-10-30 22:20:46','2022-10-30 22:20:46',NULL),(1850,NULL,40719,27,2,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',771.00,NULL,NULL,1,'2022-10-30 22:20:47','2022-10-30 22:20:47',NULL),(1851,NULL,40719,27,2,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',607.00,NULL,NULL,1,'2022-10-30 22:20:48','2022-10-30 22:20:48',NULL),(1852,NULL,40719,27,2,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',308.00,NULL,NULL,1,'2022-10-30 22:20:48','2022-10-30 22:20:48',NULL),(1853,NULL,40719,27,2,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',601.00,NULL,NULL,1,'2022-10-30 22:20:49','2022-10-30 22:20:49',NULL),(1854,NULL,40719,27,2,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',410.00,NULL,NULL,1,'2022-10-30 22:20:50','2022-10-30 22:20:50',NULL),(1855,NULL,40719,27,2,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',814.00,NULL,NULL,1,'2022-10-30 22:20:51','2022-10-30 22:20:51',NULL),(1856,NULL,40719,27,2,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',307.00,NULL,NULL,1,'2022-10-30 22:20:52','2022-10-30 22:20:52',NULL),(1857,NULL,40719,27,2,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',200.00,NULL,NULL,1,'2022-10-30 22:20:53','2022-10-30 22:20:53',NULL),(1858,NULL,40719,27,2,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',902.00,NULL,NULL,1,'2022-10-30 22:20:54','2022-10-30 22:20:54',NULL),(1859,NULL,40719,27,2,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',607.00,NULL,NULL,1,'2022-10-30 22:20:55','2022-10-30 22:20:55',NULL),(1860,NULL,40719,27,2,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',608.00,NULL,NULL,1,'2022-10-30 22:20:56','2022-10-30 22:20:56',NULL),(1861,NULL,40719,27,2,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',609.00,NULL,NULL,1,'2022-10-30 22:20:57','2022-10-30 22:20:57',NULL),(1862,NULL,40719,27,2,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',700.00,NULL,NULL,1,'2022-10-30 22:20:58','2022-10-30 22:20:58',NULL),(1863,NULL,40719,27,2,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',500.00,NULL,NULL,1,'2022-10-30 22:20:59','2022-10-30 22:20:59',NULL),(1864,NULL,40719,27,2,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',304.00,NULL,NULL,1,'2022-10-30 22:21:00','2022-10-30 22:21:00',NULL),(1865,NULL,40719,27,2,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',604.00,NULL,NULL,1,'2022-10-30 22:21:01','2022-10-30 22:21:01',NULL),(1866,NULL,40719,27,2,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',700.00,NULL,NULL,1,'2022-10-30 22:21:02','2022-10-30 22:21:02',NULL),(1867,NULL,40719,27,2,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',900.00,NULL,NULL,1,'2022-10-30 22:21:03','2022-10-30 22:21:03',NULL);
INSERT INTO `balance_libro` VALUES (1868,NULL,40719,27,2,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',650.00,NULL,NULL,1,'2022-10-30 22:21:04','2022-10-30 22:21:04',NULL),(1869,NULL,40719,27,2,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',570.00,NULL,NULL,1,'2022-10-30 22:21:05','2022-10-30 22:21:05',NULL),(1870,NULL,40719,27,2,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',680.00,NULL,NULL,1,'2022-10-30 22:21:06','2022-10-30 22:21:06',NULL),(1871,NULL,40719,27,2,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',490.00,NULL,NULL,1,'2022-10-30 22:21:07','2022-10-30 22:21:07',NULL),(1872,NULL,40719,27,2,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',800.00,NULL,NULL,1,'2022-10-30 22:21:07','2022-10-30 22:21:07',NULL),(1873,NULL,40719,27,2,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',700.00,NULL,NULL,1,'2022-10-30 22:21:08','2022-10-30 22:21:08',NULL),(1874,NULL,40719,27,2,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',900.00,NULL,NULL,1,'2022-10-30 22:21:09','2022-10-30 22:21:09',NULL),(1875,NULL,40719,27,2,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',901.00,NULL,NULL,1,'2022-10-30 22:21:10','2022-10-30 22:21:10',NULL),(1876,NULL,40719,27,2,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',388.00,NULL,NULL,1,'2022-10-30 22:21:11','2022-10-30 22:21:11',NULL),(1877,NULL,40719,27,2,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',714.00,NULL,NULL,1,'2022-10-30 22:21:12','2022-10-30 22:21:12',NULL),(1878,NULL,40719,27,2,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',746.00,NULL,NULL,1,'2022-10-30 22:21:13','2022-10-30 22:21:13',NULL),(1879,NULL,40719,27,2,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',681.00,NULL,NULL,1,'2022-10-30 22:21:14','2022-10-30 22:21:14',NULL),(1880,NULL,40719,27,2,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',601.00,NULL,NULL,1,'2022-10-30 22:21:15','2022-10-30 22:21:15',NULL),(1881,NULL,40719,27,2,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',601.00,NULL,NULL,1,'2022-10-30 22:21:16','2022-10-30 22:21:16',NULL),(1882,NULL,40719,27,2,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',900.00,NULL,NULL,1,'2022-10-30 22:21:17','2022-10-30 22:21:17',NULL),(1883,NULL,40719,27,2,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',399.00,NULL,NULL,1,'2022-10-30 22:21:18','2022-10-30 22:21:18',NULL),(1884,NULL,40719,27,2,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',499.00,NULL,NULL,1,'2022-10-30 22:21:19','2022-10-30 22:21:19',NULL),(1885,NULL,40719,27,2,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',799.00,NULL,NULL,1,'2022-10-30 22:21:20','2022-10-30 22:21:20',NULL),(1886,NULL,40719,27,2,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',488.00,NULL,NULL,1,'2022-10-30 22:21:21','2022-10-30 22:21:21',NULL),(1887,NULL,40719,27,2,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',644.00,NULL,NULL,1,'2022-10-30 22:21:22','2022-10-30 22:21:22',NULL),(1888,NULL,40719,27,2,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',611.00,NULL,NULL,1,'2022-10-30 22:21:23','2022-10-30 22:21:23',NULL);
INSERT INTO `balance_libro` VALUES (1889,NULL,40719,27,2,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',288.00,NULL,NULL,1,'2022-10-30 22:21:24','2022-10-30 22:21:24',NULL),(1890,NULL,40719,27,2,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',774.00,NULL,NULL,1,'2022-10-30 22:21:25','2022-10-30 22:21:25',NULL),(1891,NULL,40719,27,2,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',443.00,NULL,NULL,1,'2022-10-30 22:21:26','2022-10-30 22:21:26',NULL),(1892,NULL,40719,27,2,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',442.00,NULL,NULL,1,'2022-10-30 22:21:27','2022-10-30 22:21:27',NULL),(1893,NULL,40719,27,2,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',357.00,NULL,NULL,1,'2022-10-30 22:21:27','2022-10-30 22:21:27',NULL),(1894,NULL,40719,27,2,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:21:28','2022-10-30 22:21:28',NULL),(1895,NULL,40719,27,2,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',123.00,NULL,NULL,1,'2022-10-30 22:21:29','2022-10-30 22:21:29',NULL),(1896,NULL,40719,27,2,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',410.00,NULL,NULL,1,'2022-10-30 22:21:30','2022-10-30 22:21:30',NULL),(1897,NULL,40719,27,2,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',687.00,NULL,NULL,1,'2022-10-30 22:21:31','2022-10-30 22:21:31',NULL),(1898,NULL,40719,27,2,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',789.00,NULL,NULL,1,'2022-10-30 22:21:32','2022-10-30 22:21:32',NULL),(1899,NULL,40719,27,2,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',417.00,NULL,NULL,1,'2022-10-30 22:21:33','2022-10-30 22:21:33',NULL),(1900,NULL,40719,27,2,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',635.00,NULL,NULL,1,'2022-10-30 22:21:34','2022-10-30 22:21:34',NULL),(1901,NULL,40719,27,2,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',851.00,NULL,NULL,1,'2022-10-30 22:21:35','2022-10-30 22:21:35',NULL),(1902,NULL,40719,27,2,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',357.00,NULL,NULL,1,'2022-10-30 22:21:36','2022-10-30 22:21:36',NULL),(1903,NULL,40719,27,2,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:21:37','2022-10-30 22:21:37',NULL),(1904,NULL,40719,27,2,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',258.00,NULL,NULL,1,'2022-10-30 22:21:38','2022-10-30 22:21:38',NULL),(1905,NULL,40719,27,2,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',961.00,NULL,NULL,1,'2022-10-30 22:21:39','2022-10-30 22:21:39',NULL),(1906,NULL,40719,27,2,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',941.00,NULL,NULL,1,'2022-10-30 22:21:40','2022-10-30 22:21:40',NULL),(1907,NULL,40719,27,2,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',900.00,NULL,NULL,1,'2022-10-30 22:21:41','2022-10-30 22:21:41',NULL),(1908,NULL,40719,27,2,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',300.00,NULL,NULL,1,'2022-10-30 22:21:42','2022-10-30 22:21:42',NULL),(1909,NULL,40719,27,2,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:21:43','2022-10-30 22:21:43',NULL);
INSERT INTO `balance_libro` VALUES (1910,NULL,40719,27,2,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',844.00,NULL,NULL,1,'2022-10-30 22:21:44','2022-10-30 22:21:44',NULL),(1911,NULL,40719,27,2,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',844.00,NULL,NULL,1,'2022-10-30 22:21:45','2022-10-30 22:21:45',NULL),(1912,NULL,40719,27,2,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',844.00,NULL,NULL,1,'2022-10-30 22:21:45','2022-10-30 22:21:45',NULL),(1913,NULL,40719,27,2,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',644.00,NULL,NULL,1,'2022-10-30 22:21:46','2022-10-30 22:21:46',NULL),(1914,NULL,40719,27,2,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',741.00,NULL,NULL,1,'2022-10-30 22:21:47','2022-10-30 22:21:47',NULL),(1915,NULL,40719,27,2,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:21:48','2022-10-30 22:21:48',NULL),(1916,NULL,40719,27,2,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',954.00,NULL,NULL,1,'2022-10-30 22:21:49','2022-10-30 22:21:49',NULL),(1917,NULL,40719,27,2,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:21:50','2022-10-30 22:21:50',NULL),(1918,NULL,40719,27,2,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:21:51','2022-10-30 22:21:51',NULL),(1919,NULL,40719,27,2,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',754.00,NULL,NULL,1,'2022-10-30 22:21:52','2022-10-30 22:21:52',NULL),(1920,NULL,40719,27,2,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',645.00,NULL,NULL,1,'2022-10-30 22:21:53','2022-10-30 22:21:53',NULL),(1921,NULL,40719,27,2,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',611.00,NULL,NULL,1,'2022-10-30 22:21:54','2022-10-30 22:21:54',NULL),(1922,NULL,40719,27,2,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',780.00,NULL,NULL,1,'2022-10-30 22:21:55','2022-10-30 22:21:55',NULL),(1923,NULL,40719,27,2,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',781.00,NULL,NULL,1,'2022-10-30 22:21:56','2022-10-30 22:21:56',NULL),(1924,NULL,40719,27,2,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',321.00,NULL,NULL,1,'2022-10-30 22:21:57','2022-10-30 22:21:57',NULL),(1925,NULL,40719,27,2,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:21:58','2022-10-30 22:21:58',NULL),(1926,NULL,40719,27,2,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',951.00,NULL,NULL,1,'2022-10-30 22:21:59','2022-10-30 22:21:59',NULL),(1927,NULL,40719,27,2,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',753.00,NULL,NULL,1,'2022-10-30 22:22:00','2022-10-30 22:22:00',NULL),(1928,NULL,40719,27,2,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:22:01','2022-10-30 22:22:01',NULL),(1929,NULL,40719,27,2,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',456.00,NULL,NULL,1,'2022-10-30 22:22:02','2022-10-30 22:22:02',NULL),(1930,NULL,40719,27,2,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',741.00,NULL,NULL,1,'2022-10-30 22:22:02','2022-10-30 22:22:02',NULL);
INSERT INTO `balance_libro` VALUES (1931,NULL,40719,27,2,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:22:03','2022-10-30 22:22:03',NULL),(1932,NULL,40719,27,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',369.00,NULL,NULL,1,'2022-10-30 22:22:04','2022-10-30 22:22:04',NULL),(1933,NULL,40719,27,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',963.00,NULL,NULL,1,'2022-10-30 22:22:05','2022-10-30 22:22:05',NULL),(1934,NULL,40719,27,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',214.00,NULL,NULL,1,'2022-10-30 22:22:06','2022-10-30 22:22:06',NULL),(1935,NULL,40719,27,2,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',587.00,NULL,NULL,1,'2022-10-30 22:22:07','2022-10-30 22:22:07',NULL),(1936,NULL,40719,27,2,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',984.00,NULL,NULL,1,'2022-10-30 22:22:08','2022-10-30 22:22:08',NULL),(1937,NULL,40719,27,2,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',745.00,NULL,NULL,1,'2022-10-30 22:22:09','2022-10-30 22:22:09',NULL),(1938,NULL,40719,27,2,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:22:10','2022-10-30 22:22:10',NULL),(1939,NULL,40719,27,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',965.00,NULL,NULL,1,'2022-10-30 22:22:11','2022-10-30 22:22:11',NULL),(1940,NULL,40719,27,2,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',632.00,NULL,NULL,1,'2022-10-30 22:22:12','2022-10-30 22:22:12',NULL),(1941,NULL,40719,27,2,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',963.00,NULL,NULL,1,'2022-10-30 22:22:13','2022-10-30 22:22:13',NULL),(1942,NULL,40719,27,2,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',211.00,NULL,NULL,1,'2022-10-30 22:22:14','2022-10-30 22:22:14',NULL),(1943,NULL,40719,27,2,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',541.00,NULL,NULL,1,'2022-10-30 22:22:15','2022-10-30 22:22:15',NULL),(1944,NULL,40719,27,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:22:16','2022-10-30 22:22:16',NULL),(1945,NULL,40719,27,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',855.00,NULL,NULL,1,'2022-10-30 22:22:17','2022-10-30 22:22:17',NULL),(1946,NULL,40719,27,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',854.00,NULL,NULL,1,'2022-10-30 22:22:18','2022-10-30 22:22:18',NULL),(1947,NULL,40719,27,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',941.00,NULL,NULL,1,'2022-10-30 22:22:19','2022-10-30 22:22:19',NULL),(1948,NULL,40719,27,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',942.00,NULL,NULL,1,'2022-10-30 22:22:20','2022-10-30 22:22:20',NULL),(1949,NULL,40719,27,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',781.00,NULL,NULL,1,'2022-10-30 22:22:21','2022-10-30 22:22:21',NULL),(1950,NULL,40719,27,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:22:22','2022-10-30 22:22:22',NULL),(1951,NULL,40719,27,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',784.00,NULL,NULL,1,'2022-10-30 22:22:22','2022-10-30 22:22:22',NULL);
INSERT INTO `balance_libro` VALUES (1952,NULL,40719,27,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:22:23','2022-10-30 22:22:23',NULL),(1953,NULL,40719,27,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:22:24','2022-10-30 22:22:24',NULL),(1954,NULL,40719,27,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',621.00,NULL,NULL,1,'2022-10-30 22:22:25','2022-10-30 22:22:25',NULL),(1955,NULL,40719,27,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',657.00,NULL,NULL,1,'2022-10-30 22:22:26','2022-10-30 22:22:26',NULL),(1956,NULL,40719,27,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',698.00,NULL,NULL,1,'2022-10-30 22:22:27','2022-10-30 22:22:27',NULL),(1957,NULL,40719,27,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',698.00,NULL,NULL,1,'2022-10-30 22:22:28','2022-10-30 22:22:28',NULL),(1958,NULL,40719,27,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',745.00,NULL,NULL,1,'2022-10-30 22:22:29','2022-10-30 22:22:29',NULL),(1959,NULL,40719,27,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',741.00,NULL,NULL,1,'2022-10-30 22:22:30','2022-10-30 22:22:30',NULL),(1960,NULL,40719,27,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',984.00,NULL,NULL,1,'2022-10-30 22:22:31','2022-10-30 22:22:31',NULL),(1961,NULL,40719,27,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:22:32','2022-10-30 22:22:32',NULL),(1962,NULL,40719,27,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',741.00,NULL,NULL,1,'2022-10-30 22:22:33','2022-10-30 22:22:33',NULL),(1963,NULL,40719,27,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',963.00,NULL,NULL,1,'2022-10-30 22:22:34','2022-10-30 22:22:34',NULL),(1964,NULL,40719,27,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:22:35','2022-10-30 22:22:35',NULL),(1965,NULL,40719,27,2,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',632.00,NULL,NULL,1,'2022-10-30 22:22:36','2022-10-30 22:22:36',NULL),(1966,NULL,40719,27,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',741.00,NULL,NULL,1,'2022-10-30 22:22:37','2022-10-30 22:22:37',NULL),(1967,NULL,40719,27,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',965.00,NULL,NULL,1,'2022-10-30 22:22:38','2022-10-30 22:22:38',NULL),(1968,NULL,40719,27,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',854.00,NULL,NULL,1,'2022-10-30 22:22:39','2022-10-30 22:22:39',NULL),(1969,NULL,40719,27,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',569.00,NULL,NULL,1,'2022-10-30 22:22:40','2022-10-30 22:22:40',NULL),(1970,NULL,40719,27,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',568.00,NULL,NULL,1,'2022-10-30 22:22:41','2022-10-30 22:22:41',NULL),(1971,NULL,40719,27,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',547.00,NULL,NULL,1,'2022-10-30 22:22:41','2022-10-30 22:22:41',NULL),(1972,NULL,40719,27,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',587.00,NULL,NULL,1,'2022-10-30 22:22:42','2022-10-30 22:22:42',NULL);
INSERT INTO `balance_libro` VALUES (1973,NULL,40719,27,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',569.00,NULL,NULL,1,'2022-10-30 22:22:43','2022-10-30 22:22:43',NULL),(1974,NULL,40719,27,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',500.00,NULL,NULL,1,'2022-10-30 22:22:44','2022-10-30 22:22:44',NULL),(1975,NULL,40719,27,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:22:45','2022-10-30 22:22:45',NULL),(1976,NULL,40719,27,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',644.00,NULL,NULL,1,'2022-10-30 22:22:46','2022-10-30 22:22:46',NULL),(1977,NULL,40719,27,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',658.00,NULL,NULL,1,'2022-10-30 22:22:47','2022-10-30 22:22:47',NULL),(1978,NULL,40719,27,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',574.00,NULL,NULL,1,'2022-10-30 22:22:48','2022-10-30 22:22:48',NULL),(1979,NULL,40719,27,2,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',859.00,NULL,NULL,1,'2022-10-30 22:22:49','2022-10-30 22:22:49',NULL),(1980,NULL,40719,27,2,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',658.00,NULL,NULL,1,'2022-10-30 22:22:50','2022-10-30 22:22:50',NULL),(1981,NULL,40719,27,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',954.00,NULL,NULL,1,'2022-10-30 22:22:51','2022-10-30 22:22:51',NULL),(1982,NULL,40719,27,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:22:52','2022-10-30 22:22:52',NULL),(1983,NULL,40719,27,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:22:53','2022-10-30 22:22:53',NULL),(1984,NULL,40719,27,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',698.00,NULL,NULL,1,'2022-10-30 22:22:54','2022-10-30 22:22:54',NULL),(1985,NULL,40719,27,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',698.00,NULL,NULL,1,'2022-10-30 22:22:55','2022-10-30 22:22:55',NULL),(1986,NULL,40719,27,2,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',911.00,NULL,NULL,1,'2022-10-30 22:22:56','2022-10-30 22:22:56',NULL),(1987,NULL,40719,27,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',710.00,NULL,NULL,1,'2022-10-30 22:22:57','2022-10-30 22:22:57',NULL),(1988,NULL,40719,27,2,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',604.00,NULL,NULL,1,'2022-10-30 22:22:58','2022-10-30 22:22:58',NULL),(1989,NULL,40719,27,2,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',604.00,NULL,NULL,1,'2022-10-30 22:22:59','2022-10-30 22:22:59',NULL),(1990,NULL,40719,27,2,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',644.00,NULL,NULL,1,'2022-10-30 22:23:00','2022-10-30 22:23:00',NULL),(1991,NULL,40719,27,2,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',684.00,NULL,NULL,1,'2022-10-30 22:23:01','2022-10-30 22:23:01',NULL),(1992,NULL,40719,27,2,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',684.00,NULL,NULL,1,'2022-10-30 22:23:01','2022-10-30 22:23:01',NULL),(1993,NULL,40719,27,2,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',800.00,NULL,NULL,1,'2022-10-30 22:23:02','2022-10-30 22:23:02',NULL);
INSERT INTO `balance_libro` VALUES (1994,NULL,40719,27,2,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',820.00,NULL,NULL,1,'2022-10-30 22:23:03','2022-10-30 22:23:03',NULL),(1995,NULL,40719,27,2,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',700.00,NULL,NULL,1,'2022-10-30 22:23:04','2022-10-30 22:23:04',NULL),(1996,NULL,40719,27,2,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',700.00,NULL,NULL,1,'2022-10-30 22:23:05','2022-10-30 22:23:05',NULL),(1997,NULL,40719,27,2,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',700.00,NULL,NULL,1,'2022-10-30 22:23:06','2022-10-30 22:23:06',NULL),(1998,NULL,40719,27,2,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',645.00,NULL,NULL,1,'2022-10-30 22:23:07','2022-10-30 22:23:07',NULL),(1999,NULL,40719,27,2,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',645.00,NULL,NULL,1,'2022-10-30 22:23:08','2022-10-30 22:23:08',NULL),(2000,NULL,40719,27,2,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:23:09','2022-10-30 22:23:09',NULL),(2001,NULL,40719,27,2,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',850.00,NULL,NULL,1,'2022-10-30 22:23:10','2022-10-30 22:23:10',NULL),(2002,NULL,40719,27,2,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:23:11','2022-10-30 22:23:11',NULL),(2003,NULL,40719,27,2,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:23:12','2022-10-30 22:23:12',NULL),(2004,NULL,40719,27,2,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',951.00,NULL,NULL,1,'2022-10-30 22:23:13','2022-10-30 22:23:13',NULL),(2005,NULL,40719,27,2,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',700.00,NULL,NULL,1,'2022-10-30 22:23:14','2022-10-30 22:23:14',NULL),(2006,NULL,40719,27,2,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',800.00,NULL,NULL,1,'2022-10-30 22:23:15','2022-10-30 22:23:15',NULL),(2007,NULL,40719,27,2,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:23:16','2022-10-30 22:23:16',NULL),(2008,NULL,40719,27,2,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',744.00,NULL,NULL,1,'2022-10-30 22:23:17','2022-10-30 22:23:17',NULL),(2009,NULL,40719,27,2,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',645.00,NULL,NULL,1,'2022-10-30 22:23:18','2022-10-30 22:23:18',NULL),(2010,NULL,40719,27,2,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',700.00,NULL,NULL,1,'2022-10-30 22:23:19','2022-10-30 22:23:19',NULL),(2011,NULL,40719,27,2,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',700.00,NULL,NULL,1,'2022-10-30 22:23:20','2022-10-30 22:23:20',NULL),(2012,NULL,40719,27,2,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',800.00,NULL,NULL,1,'2022-10-30 22:23:21','2022-10-30 22:23:21',NULL),(2013,NULL,40719,27,2,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',900.00,NULL,NULL,1,'2022-10-30 22:23:22','2022-10-30 22:23:22',NULL),(2014,NULL,40719,27,2,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',604.00,NULL,NULL,1,'2022-10-30 22:23:23','2022-10-30 22:23:23',NULL);
INSERT INTO `balance_libro` VALUES (2015,NULL,40719,27,2,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',500.00,NULL,NULL,1,'2022-10-30 22:23:23','2022-10-30 22:23:23',NULL),(2016,NULL,40719,27,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',500.00,NULL,NULL,1,'2022-10-30 22:23:24','2022-10-30 22:23:24',NULL),(2017,NULL,40719,27,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-10-30 22:23:25','2022-10-30 22:23:25',NULL),(2018,NULL,40719,27,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',300.00,NULL,NULL,1,'2022-10-30 22:23:26','2022-10-30 22:23:26',NULL),(2019,NULL,40719,27,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',378.00,NULL,NULL,1,'2022-10-30 22:23:27','2022-10-30 22:23:27',NULL),(2020,NULL,40719,27,2,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',398.00,NULL,NULL,1,'2022-10-30 22:23:28','2022-10-30 22:23:28',NULL),(2021,NULL,40719,27,2,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',409.00,NULL,NULL,1,'2022-10-30 22:23:29','2022-10-30 22:23:29',NULL),(2022,NULL,40719,27,2,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',409.00,NULL,NULL,1,'2022-10-30 22:23:30','2022-10-30 22:23:30',NULL),(2023,NULL,40719,27,2,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',387.00,NULL,NULL,1,'2022-10-30 22:23:31','2022-10-30 22:23:31',NULL),(2024,NULL,40719,27,2,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',387.00,NULL,NULL,1,'2022-10-30 22:23:32','2022-10-30 22:23:32',NULL),(2025,NULL,40719,27,2,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',466.00,NULL,NULL,1,'2022-10-30 22:23:33','2022-10-30 22:23:33',NULL),(2026,NULL,40719,27,2,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',411.00,NULL,NULL,1,'2022-10-30 22:23:34','2022-10-30 22:23:34',NULL),(2027,NULL,40719,27,2,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',344.00,NULL,NULL,1,'2022-10-30 22:23:35','2022-10-30 22:23:35',NULL),(2028,NULL,40719,27,2,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',366.00,NULL,NULL,1,'2022-10-30 22:23:36','2022-10-30 22:23:36',NULL),(2029,NULL,40719,27,2,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',644.00,NULL,NULL,1,'2022-10-30 22:23:37','2022-10-30 22:23:37',NULL),(2030,NULL,40719,27,2,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',644.00,NULL,NULL,1,'2022-10-30 22:23:38','2022-10-30 22:23:38',NULL),(2031,NULL,40719,27,2,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',900.00,NULL,NULL,1,'2022-10-30 22:23:39','2022-10-30 22:23:39',NULL),(2032,NULL,40719,27,2,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',740.00,NULL,NULL,1,'2022-10-30 22:23:40','2022-10-30 22:23:40',NULL),(2033,NULL,40719,27,2,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',900.00,NULL,NULL,1,'2022-10-30 22:23:41','2022-10-30 22:23:41',NULL),(2034,NULL,40719,27,2,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-10-30 22:23:42','2022-10-30 22:23:42',NULL),(2035,NULL,40719,27,2,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:23:43','2022-10-30 22:23:43',NULL);
INSERT INTO `balance_libro` VALUES (2036,NULL,40719,27,2,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:23:44','2022-10-30 22:23:44',NULL),(2037,NULL,40719,27,2,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',414.00,NULL,NULL,1,'2022-10-30 22:23:44','2022-10-30 22:23:44',NULL),(2038,NULL,40719,27,2,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-10-30 22:23:45','2022-10-30 22:23:45',NULL),(2039,NULL,40719,27,2,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-10-30 22:23:46','2022-10-30 22:23:46',NULL),(2040,NULL,40719,27,2,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-10-30 22:23:47','2022-10-30 22:23:47',NULL),(2041,NULL,40719,27,2,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-10-30 22:23:48','2022-10-30 22:23:48',NULL),(2042,NULL,40719,27,2,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',300.00,NULL,NULL,1,'2022-10-30 22:23:49','2022-10-30 22:23:49',NULL),(2043,NULL,40719,27,2,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',300.00,NULL,NULL,1,'2022-10-30 22:23:50','2022-10-30 22:23:50',NULL),(2044,NULL,40719,27,2,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',350.00,NULL,NULL,1,'2022-10-30 22:23:51','2022-10-30 22:23:51',NULL),(2045,NULL,40719,27,2,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',350.00,NULL,NULL,1,'2022-10-30 22:23:52','2022-10-30 22:23:52',NULL),(2046,NULL,40719,27,2,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',147.00,NULL,NULL,1,'2022-10-30 22:23:53','2022-10-30 22:23:53',NULL),(2047,NULL,40719,27,2,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:23:54','2022-10-30 22:23:54',NULL),(2048,NULL,40719,27,2,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:23:55','2022-10-30 22:23:55',NULL),(2049,NULL,40719,27,2,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',450.00,NULL,NULL,1,'2022-10-30 22:23:56','2022-10-30 22:23:56',NULL),(2050,NULL,40719,27,2,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',853.00,NULL,NULL,1,'2022-10-30 22:23:57','2022-10-30 22:23:57',NULL),(2051,NULL,40719,27,2,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',344.00,NULL,NULL,1,'2022-10-30 22:23:58','2022-10-30 22:23:58',NULL),(2052,NULL,40719,27,2,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',355.00,NULL,NULL,1,'2022-10-30 22:23:59','2022-10-30 22:23:59',NULL),(2053,NULL,40719,27,2,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',399.00,NULL,NULL,1,'2022-10-30 22:24:00','2022-10-30 22:24:00',NULL),(2054,NULL,40719,27,2,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:24:01','2022-10-30 22:24:01',NULL),(2055,NULL,40719,27,2,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',607.00,NULL,NULL,1,'2022-10-30 22:24:02','2022-10-30 22:24:02',NULL),(2056,NULL,40719,27,2,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',482.00,NULL,NULL,1,'2022-10-30 22:24:03','2022-10-30 22:24:03',NULL);
INSERT INTO `balance_libro` VALUES (2057,NULL,40719,27,2,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',517.00,NULL,NULL,1,'2022-10-30 22:24:04','2022-10-30 22:24:04',NULL),(2058,NULL,40719,27,2,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',601.00,NULL,NULL,1,'2022-10-30 22:24:05','2022-10-30 22:24:05',NULL),(2059,NULL,40719,27,2,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',708.00,NULL,NULL,1,'2022-10-30 22:24:06','2022-10-30 22:24:06',NULL),(2060,NULL,40719,27,2,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',433.00,NULL,NULL,1,'2022-10-30 22:24:06','2022-10-30 22:24:06',NULL),(2061,NULL,40719,27,2,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',380.00,NULL,NULL,1,'2022-10-30 22:24:07','2022-10-30 22:24:07',NULL),(2062,NULL,40719,27,2,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',910.00,NULL,NULL,1,'2022-10-30 22:24:08','2022-10-30 22:24:08',NULL),(2063,NULL,40719,27,2,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',604.00,NULL,NULL,1,'2022-10-30 22:24:09','2022-10-30 22:24:09',NULL),(2064,NULL,40719,27,2,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',451.00,NULL,NULL,1,'2022-10-30 22:24:10','2022-10-30 22:24:10',NULL),(2065,NULL,40719,27,2,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',311.00,NULL,NULL,1,'2022-10-30 22:24:11','2022-10-30 22:24:11',NULL),(2066,NULL,40719,27,2,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',841.00,NULL,NULL,1,'2022-10-30 22:24:12','2022-10-30 22:24:12',NULL),(2067,NULL,40719,27,2,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',500.00,NULL,NULL,1,'2022-10-30 22:24:13','2022-10-30 22:24:13',NULL),(2068,NULL,40719,27,2,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:24:14','2022-10-30 22:24:14',NULL),(2069,NULL,40719,27,2,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-10-30 22:24:15','2022-10-30 22:24:15',NULL),(2070,NULL,40719,27,2,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',300.00,NULL,NULL,1,'2022-10-30 22:24:16','2022-10-30 22:24:16',NULL),(2071,NULL,40719,27,2,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',578.00,NULL,NULL,1,'2022-10-30 22:24:17','2022-10-30 22:24:17',NULL),(2072,NULL,40719,27,2,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',641.00,NULL,NULL,1,'2022-10-30 22:24:18','2022-10-30 22:24:18',NULL),(2073,NULL,40719,27,2,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',741.00,NULL,NULL,1,'2022-10-30 22:24:19','2022-10-30 22:24:19',NULL),(2074,NULL,40719,27,2,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',188.00,NULL,NULL,1,'2022-10-30 22:24:20','2022-10-30 22:24:20',NULL),(2075,NULL,40719,27,2,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',607.00,NULL,NULL,1,'2022-10-30 22:24:21','2022-10-30 22:24:21',NULL),(2076,NULL,40719,27,2,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:24:22','2022-10-30 22:24:22',NULL),(2077,NULL,40719,27,2,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',800.00,NULL,NULL,1,'2022-10-30 22:24:23','2022-10-30 22:24:23',NULL);
INSERT INTO `balance_libro` VALUES (2078,NULL,40719,27,2,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',300.00,NULL,NULL,1,'2022-10-30 22:24:24','2022-10-30 22:24:24',NULL),(2079,NULL,40719,27,2,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-10-30 22:24:25','2022-10-30 22:24:25',NULL),(2080,NULL,40719,27,2,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',500.00,NULL,NULL,1,'2022-10-30 22:24:26','2022-10-30 22:24:26',NULL),(2081,NULL,40719,27,2,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:24:26','2022-10-30 22:24:26',NULL),(2082,NULL,40719,27,2,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',900.00,NULL,NULL,1,'2022-10-30 22:24:27','2022-10-30 22:24:27',NULL),(2083,NULL,40719,27,2,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',455.00,NULL,NULL,1,'2022-10-30 22:24:28','2022-10-30 22:24:28',NULL),(2084,NULL,40719,27,2,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',655.00,NULL,NULL,1,'2022-10-30 22:24:29','2022-10-30 22:24:29',NULL),(2085,NULL,40719,27,2,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',211.00,NULL,NULL,1,'2022-10-30 22:24:30','2022-10-30 22:24:30',NULL),(2086,NULL,40719,27,2,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',447.00,NULL,NULL,1,'2022-10-30 22:24:31','2022-10-30 22:24:31',NULL),(2087,NULL,40719,27,2,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',558.00,NULL,NULL,1,'2022-10-30 22:24:32','2022-10-30 22:24:32',NULL),(2088,NULL,40719,27,2,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',330.00,NULL,NULL,1,'2022-10-30 22:24:33','2022-10-30 22:24:33',NULL),(2089,NULL,40719,27,2,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',990.00,NULL,NULL,1,'2022-10-30 22:24:34','2022-10-30 22:24:34',NULL),(2090,NULL,40719,27,2,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',771.00,NULL,NULL,1,'2022-10-30 22:24:35','2022-10-30 22:24:35',NULL),(2091,NULL,40719,27,2,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',607.00,NULL,NULL,1,'2022-10-30 22:24:36','2022-10-30 22:24:36',NULL),(2092,NULL,40719,27,2,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',308.00,NULL,NULL,1,'2022-10-30 22:24:37','2022-10-30 22:24:37',NULL),(2093,NULL,40719,27,2,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',601.00,NULL,NULL,1,'2022-10-30 22:24:38','2022-10-30 22:24:38',NULL),(2094,NULL,40719,27,2,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',410.00,NULL,NULL,1,'2022-10-30 22:24:39','2022-10-30 22:24:39',NULL),(2095,NULL,40719,27,2,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',814.00,NULL,NULL,1,'2022-10-30 22:24:40','2022-10-30 22:24:40',NULL),(2096,NULL,40719,27,2,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',307.00,NULL,NULL,1,'2022-10-30 22:24:41','2022-10-30 22:24:41',NULL),(2097,NULL,40719,27,2,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',200.00,NULL,NULL,1,'2022-10-30 22:24:42','2022-10-30 22:24:42',NULL),(2098,NULL,40719,27,2,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',902.00,NULL,NULL,1,'2022-10-30 22:24:43','2022-10-30 22:24:43',NULL);
INSERT INTO `balance_libro` VALUES (2099,NULL,40719,27,2,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',607.00,NULL,NULL,1,'2022-10-30 22:24:43','2022-10-30 22:24:43',NULL),(2100,NULL,40719,27,2,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',608.00,NULL,NULL,1,'2022-10-30 22:24:44','2022-10-30 22:24:44',NULL),(2101,NULL,40719,27,2,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',609.00,NULL,NULL,1,'2022-10-30 22:24:45','2022-10-30 22:24:45',NULL),(2102,NULL,40719,27,2,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',700.00,NULL,NULL,1,'2022-10-30 22:24:46','2022-10-30 22:24:46',NULL),(2103,NULL,40719,27,2,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',500.00,NULL,NULL,1,'2022-10-30 22:24:47','2022-10-30 22:24:47',NULL),(2104,NULL,40719,27,2,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',304.00,NULL,NULL,1,'2022-10-30 22:24:48','2022-10-30 22:24:48',NULL),(2105,NULL,40719,27,2,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',604.00,NULL,NULL,1,'2022-10-30 22:24:49','2022-10-30 22:24:49',NULL),(2106,NULL,40719,27,2,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',700.00,NULL,NULL,1,'2022-10-30 22:24:50','2022-10-30 22:24:50',NULL),(2107,NULL,40719,27,2,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',900.00,NULL,NULL,1,'2022-10-30 22:24:51','2022-10-30 22:24:51',NULL),(2108,NULL,40719,27,2,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',650.00,NULL,NULL,1,'2022-10-30 22:24:52','2022-10-30 22:24:52',NULL),(2109,NULL,40719,27,2,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',570.00,NULL,NULL,1,'2022-10-30 22:24:53','2022-10-30 22:24:53',NULL),(2110,NULL,40719,27,2,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',680.00,NULL,NULL,1,'2022-10-30 22:24:54','2022-10-30 22:24:54',NULL),(2111,NULL,40719,27,2,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',490.00,NULL,NULL,1,'2022-10-30 22:24:55','2022-10-30 22:24:55',NULL),(2112,NULL,40719,27,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',800.00,NULL,NULL,1,'2022-10-30 22:24:56','2022-10-30 22:24:56',NULL),(2113,NULL,40719,27,2,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',700.00,NULL,NULL,1,'2022-10-30 22:24:57','2022-10-30 22:24:57',NULL),(2114,NULL,40719,27,2,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',900.00,NULL,NULL,1,'2022-10-30 22:24:58','2022-10-30 22:24:58',NULL),(2115,NULL,40719,27,2,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',901.00,NULL,NULL,1,'2022-10-30 22:24:59','2022-10-30 22:24:59',NULL),(2116,NULL,40719,27,2,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',388.00,NULL,NULL,1,'2022-10-30 22:25:00','2022-10-30 22:25:00',NULL),(2117,NULL,40719,27,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',714.00,NULL,NULL,1,'2022-10-30 22:25:01','2022-10-30 22:25:01',NULL),(2118,NULL,40719,27,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',746.00,NULL,NULL,1,'2022-10-30 22:25:02','2022-10-30 22:25:02',NULL),(2119,NULL,40719,27,2,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',681.00,NULL,NULL,1,'2022-10-30 22:25:02','2022-10-30 22:25:02',NULL);
INSERT INTO `balance_libro` VALUES (2120,NULL,40719,27,2,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',601.00,NULL,NULL,1,'2022-10-30 22:25:03','2022-10-30 22:25:03',NULL),(2121,NULL,40719,27,2,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',601.00,NULL,NULL,1,'2022-10-30 22:25:04','2022-10-30 22:25:04',NULL),(2122,NULL,40719,27,2,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',900.00,NULL,NULL,1,'2022-10-30 22:25:05','2022-10-30 22:25:05',NULL),(2123,NULL,40719,27,2,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',399.00,NULL,NULL,1,'2022-10-30 22:25:06','2022-10-30 22:25:06',NULL),(2124,NULL,40719,27,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',499.00,NULL,NULL,1,'2022-10-30 22:25:07','2022-10-30 22:25:07',NULL),(2125,NULL,40719,27,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',799.00,NULL,NULL,1,'2022-10-30 22:25:08','2022-10-30 22:25:08',NULL),(2126,NULL,40719,27,2,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',488.00,NULL,NULL,1,'2022-10-30 22:25:09','2022-10-30 22:25:09',NULL),(2127,NULL,40719,27,2,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',644.00,NULL,NULL,1,'2022-10-30 22:25:10','2022-10-30 22:25:10',NULL),(2128,NULL,40719,27,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',611.00,NULL,NULL,1,'2022-10-30 22:25:11','2022-10-30 22:25:11',NULL),(2129,NULL,40719,27,2,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',288.00,NULL,NULL,1,'2022-10-30 22:25:12','2022-10-30 22:25:12',NULL),(2130,NULL,40719,27,2,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',774.00,NULL,NULL,1,'2022-10-30 22:25:13','2022-10-30 22:25:13',NULL),(2131,NULL,40719,27,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',443.00,NULL,NULL,1,'2022-10-30 22:25:14','2022-10-30 22:25:14',NULL),(2132,NULL,40719,27,2,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',442.00,NULL,NULL,1,'2022-10-30 22:25:15','2022-10-30 22:25:15',NULL),(2133,NULL,40719,27,2,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',357.00,NULL,NULL,1,'2022-10-30 22:25:16','2022-10-30 22:25:16',NULL),(2134,NULL,40719,27,2,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:25:17','2022-10-30 22:25:17',NULL),(2135,NULL,40719,27,2,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',123.00,NULL,NULL,1,'2022-10-30 22:25:18','2022-10-30 22:25:18',NULL),(2136,NULL,40719,27,2,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',410.00,NULL,NULL,1,'2022-10-30 22:25:19','2022-10-30 22:25:19',NULL),(2137,NULL,40719,27,2,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',687.00,NULL,NULL,1,'2022-10-30 22:25:20','2022-10-30 22:25:20',NULL),(2138,NULL,40719,27,2,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',789.00,NULL,NULL,1,'2022-10-30 22:25:20','2022-10-30 22:25:20',NULL),(2139,NULL,40719,27,2,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',417.00,NULL,NULL,1,'2022-10-30 22:25:21','2022-10-30 22:25:21',NULL),(2140,NULL,40719,27,2,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',635.00,NULL,NULL,1,'2022-10-30 22:25:22','2022-10-30 22:25:22',NULL);
INSERT INTO `balance_libro` VALUES (2141,NULL,40719,27,2,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',851.00,NULL,NULL,1,'2022-10-30 22:25:23','2022-10-30 22:25:23',NULL),(2142,NULL,40719,27,2,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',357.00,NULL,NULL,1,'2022-10-30 22:25:24','2022-10-30 22:25:24',NULL),(2143,NULL,40719,27,2,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:25:25','2022-10-30 22:25:25',NULL),(2144,NULL,40719,27,2,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',258.00,NULL,NULL,1,'2022-10-30 22:25:26','2022-10-30 22:25:26',NULL),(2145,NULL,40719,27,2,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',961.00,NULL,NULL,1,'2022-10-30 22:25:27','2022-10-30 22:25:27',NULL),(2146,NULL,40719,27,2,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',941.00,NULL,NULL,1,'2022-10-30 22:25:28','2022-10-30 22:25:28',NULL),(2147,NULL,40719,27,2,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',900.00,NULL,NULL,1,'2022-10-30 22:25:29','2022-10-30 22:25:29',NULL),(2148,NULL,40719,27,2,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',300.00,NULL,NULL,1,'2022-10-30 22:25:30','2022-10-30 22:25:30',NULL),(2149,NULL,40719,27,2,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:25:31','2022-10-30 22:25:31',NULL),(2150,NULL,40719,27,2,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',844.00,NULL,NULL,1,'2022-10-30 22:25:32','2022-10-30 22:25:32',NULL),(2151,NULL,40719,27,2,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',844.00,NULL,NULL,1,'2022-10-30 22:25:33','2022-10-30 22:25:33',NULL),(2152,NULL,40719,27,2,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',844.00,NULL,NULL,1,'2022-10-30 22:25:34','2022-10-30 22:25:34',NULL),(2153,NULL,40719,27,2,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',644.00,NULL,NULL,1,'2022-10-30 22:25:35','2022-10-30 22:25:35',NULL),(2154,NULL,40719,27,2,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',741.00,NULL,NULL,1,'2022-10-30 22:25:36','2022-10-30 22:25:36',NULL),(2155,NULL,40719,27,2,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:25:37','2022-10-30 22:25:37',NULL),(2156,NULL,40719,27,2,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',954.00,NULL,NULL,1,'2022-10-30 22:25:38','2022-10-30 22:25:38',NULL),(2157,NULL,40719,27,2,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:25:39','2022-10-30 22:25:39',NULL),(2158,NULL,40719,27,2,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:25:40','2022-10-30 22:25:40',NULL),(2159,NULL,40719,27,2,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',754.00,NULL,NULL,1,'2022-10-30 22:25:41','2022-10-30 22:25:41',NULL),(2160,NULL,40719,27,2,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',645.00,NULL,NULL,1,'2022-10-30 22:25:42','2022-10-30 22:25:42',NULL),(2161,NULL,40719,27,2,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',611.00,NULL,NULL,1,'2022-10-30 22:25:42','2022-10-30 22:25:42',NULL);
INSERT INTO `balance_libro` VALUES (2162,NULL,40719,27,2,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',780.00,NULL,NULL,1,'2022-10-30 22:25:43','2022-10-30 22:25:43',NULL),(2163,NULL,40719,27,2,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',781.00,NULL,NULL,1,'2022-10-30 22:25:44','2022-10-30 22:25:44',NULL),(2164,NULL,40719,27,2,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',321.00,NULL,NULL,1,'2022-10-30 22:25:45','2022-10-30 22:25:45',NULL),(2165,NULL,40719,27,2,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:25:46','2022-10-30 22:25:46',NULL),(2166,NULL,40719,27,2,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',951.00,NULL,NULL,1,'2022-10-30 22:25:47','2022-10-30 22:25:47',NULL),(2167,NULL,40719,27,2,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',753.00,NULL,NULL,1,'2022-10-30 22:25:48','2022-10-30 22:25:48',NULL),(2168,NULL,40719,27,2,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:25:49','2022-10-30 22:25:49',NULL),(2169,NULL,40719,27,2,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',456.00,NULL,NULL,1,'2022-10-30 22:25:50','2022-10-30 22:25:50',NULL),(2170,NULL,40719,27,2,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',741.00,NULL,NULL,1,'2022-10-30 22:25:51','2022-10-30 22:25:51',NULL),(2171,NULL,40719,27,2,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:25:52','2022-10-30 22:25:52',NULL),(2172,NULL,40719,27,2,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',369.00,NULL,NULL,1,'2022-10-30 22:25:53','2022-10-30 22:25:53',NULL),(2173,NULL,40719,27,2,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',963.00,NULL,NULL,1,'2022-10-30 22:25:54','2022-10-30 22:25:54',NULL),(2174,NULL,40719,27,2,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',214.00,NULL,NULL,1,'2022-10-30 22:25:55','2022-10-30 22:25:55',NULL),(2175,NULL,40719,27,2,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',587.00,NULL,NULL,1,'2022-10-30 22:25:56','2022-10-30 22:25:56',NULL),(2176,NULL,40719,27,2,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',984.00,NULL,NULL,1,'2022-10-30 22:25:57','2022-10-30 22:25:57',NULL),(2177,NULL,40719,27,2,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',745.00,NULL,NULL,1,'2022-10-30 22:25:58','2022-10-30 22:25:58',NULL),(2178,NULL,40719,27,2,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:25:59','2022-10-30 22:25:59',NULL),(2179,NULL,40719,27,2,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',965.00,NULL,NULL,1,'2022-10-30 22:25:59','2022-10-30 22:25:59',NULL),(2180,NULL,40719,27,2,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',632.00,NULL,NULL,1,'2022-10-30 22:26:00','2022-10-30 22:26:00',NULL),(2181,NULL,40719,27,2,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',963.00,NULL,NULL,1,'2022-10-30 22:26:01','2022-10-30 22:26:01',NULL),(2182,NULL,40719,27,2,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',211.00,NULL,NULL,1,'2022-10-30 22:26:02','2022-10-30 22:26:02',NULL);
INSERT INTO `balance_libro` VALUES (2183,NULL,40719,27,2,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',541.00,NULL,NULL,1,'2022-10-30 22:26:03','2022-10-30 22:26:03',NULL),(2184,NULL,40719,27,2,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:26:04','2022-10-30 22:26:04',NULL),(2185,NULL,40719,27,2,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',855.00,NULL,NULL,1,'2022-10-30 22:26:05','2022-10-30 22:26:05',NULL),(2186,NULL,40719,27,2,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',854.00,NULL,NULL,1,'2022-10-30 22:26:06','2022-10-30 22:26:06',NULL),(2187,NULL,40719,27,2,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',941.00,NULL,NULL,1,'2022-10-30 22:26:07','2022-10-30 22:26:07',NULL),(2188,NULL,40719,27,2,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',942.00,NULL,NULL,1,'2022-10-30 22:26:08','2022-10-30 22:26:08',NULL),(2189,NULL,40719,27,2,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',781.00,NULL,NULL,1,'2022-10-30 22:26:09','2022-10-30 22:26:09',NULL),(2190,NULL,40719,27,2,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:26:10','2022-10-30 22:26:10',NULL),(2191,NULL,40719,27,2,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',784.00,NULL,NULL,1,'2022-10-30 22:26:11','2022-10-30 22:26:11',NULL),(2192,NULL,40719,27,2,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:26:12','2022-10-30 22:26:12',NULL),(2193,NULL,40719,27,2,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:26:13','2022-10-30 22:26:13',NULL),(2194,NULL,40719,27,2,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',621.00,NULL,NULL,1,'2022-10-30 22:26:14','2022-10-30 22:26:14',NULL),(2195,NULL,40719,27,2,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',657.00,NULL,NULL,1,'2022-10-30 22:26:15','2022-10-30 22:26:15',NULL),(2196,NULL,40719,27,2,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',698.00,NULL,NULL,1,'2022-10-30 22:26:16','2022-10-30 22:26:16',NULL),(2197,NULL,40719,27,2,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',698.00,NULL,NULL,1,'2022-10-30 22:26:17','2022-10-30 22:26:17',NULL),(2198,NULL,40719,27,2,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',745.00,NULL,NULL,1,'2022-10-30 22:26:18','2022-10-30 22:26:18',NULL),(2199,NULL,40719,27,2,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',741.00,NULL,NULL,1,'2022-10-30 22:26:19','2022-10-30 22:26:19',NULL),(2200,NULL,40719,27,2,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',984.00,NULL,NULL,1,'2022-10-30 22:26:20','2022-10-30 22:26:20',NULL),(2201,NULL,40719,27,2,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',852.00,NULL,NULL,1,'2022-10-30 22:26:20','2022-10-30 22:26:20',NULL),(2202,NULL,40719,27,2,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',741.00,NULL,NULL,1,'2022-10-30 22:26:21','2022-10-30 22:26:21',NULL),(2203,NULL,40719,27,2,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',963.00,NULL,NULL,1,'2022-10-30 22:26:22','2022-10-30 22:26:22',NULL);
INSERT INTO `balance_libro` VALUES (2204,NULL,40719,27,2,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',654.00,NULL,NULL,1,'2022-10-30 22:26:23','2022-10-30 22:26:23',NULL),(2205,NULL,40719,27,2,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',632.00,NULL,NULL,1,'2022-10-30 22:26:24','2022-10-30 22:26:24',NULL),(2206,NULL,40719,27,2,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',741.00,NULL,NULL,1,'2022-10-30 22:26:25','2022-10-30 22:26:25',NULL),(2207,NULL,40719,27,2,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',965.00,NULL,NULL,1,'2022-10-30 22:26:26','2022-10-30 22:26:26',NULL),(2208,NULL,40719,27,2,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',854.00,NULL,NULL,1,'2022-10-30 22:26:27','2022-10-30 22:26:27',NULL),(2209,NULL,40719,27,2,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',569.00,NULL,NULL,1,'2022-10-30 22:26:28','2022-10-30 22:26:28',NULL),(2210,NULL,40719,27,2,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',568.00,NULL,NULL,1,'2022-10-30 22:26:29','2022-10-30 22:26:29',NULL),(2211,NULL,40719,27,2,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',547.00,NULL,NULL,1,'2022-10-30 22:26:30','2022-10-30 22:26:30',NULL),(2212,NULL,40719,27,2,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',587.00,NULL,NULL,1,'2022-10-30 22:26:31','2022-10-30 22:26:31',NULL),(2213,NULL,40719,27,2,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',569.00,NULL,NULL,1,'2022-10-30 22:26:32','2022-10-30 22:26:32',NULL),(2214,NULL,40719,27,2,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',500.00,NULL,NULL,1,'2022-10-30 22:26:33','2022-10-30 22:26:33',NULL),(2215,NULL,40719,27,2,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',600.00,NULL,NULL,1,'2022-10-30 22:26:34','2022-10-30 22:26:34',NULL),(2216,NULL,40719,27,2,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',644.00,NULL,NULL,1,'2022-10-30 22:26:35','2022-10-30 22:26:35',NULL),(2217,NULL,40719,27,2,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',658.00,NULL,NULL,1,'2022-10-30 22:26:36','2022-10-30 22:26:36',NULL),(2218,NULL,40719,27,2,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',574.00,NULL,NULL,1,'2022-10-30 22:26:37','2022-10-30 22:26:37',NULL),(2219,NULL,40719,27,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',859.00,NULL,NULL,1,'2022-10-30 22:26:38','2022-10-30 22:26:38',NULL),(2220,NULL,40719,27,2,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',658.00,NULL,NULL,1,'2022-10-30 22:26:39','2022-10-30 22:26:39',NULL),(2221,NULL,40719,27,2,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-10-30 22:26:40','2022-10-30 22:26:40',NULL),(2222,NULL,40719,27,2,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',274.00,NULL,NULL,1,'2022-10-30 22:26:41','2022-10-30 22:26:41',NULL),(2223,NULL,40719,27,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',310.00,NULL,NULL,1,'2022-10-30 22:26:42','2022-10-30 22:26:42',NULL),(2224,NULL,40719,27,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',159.00,NULL,NULL,1,'2022-10-30 22:26:43','2022-10-30 22:26:43',NULL);
INSERT INTO `balance_libro` VALUES (2225,NULL,40719,27,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',340.00,NULL,NULL,1,'2022-10-30 22:26:44','2022-10-30 22:26:44',NULL),(2226,NULL,40719,27,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-10-30 22:26:45','2022-10-30 22:26:45',NULL),(2227,NULL,40719,27,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',300.00,NULL,NULL,1,'2022-10-30 22:26:45','2022-10-30 22:26:45',NULL),(2228,NULL,40719,27,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',300.00,NULL,NULL,1,'2022-10-30 22:26:46','2022-10-30 22:26:46',NULL),(2229,NULL,40719,27,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',350.00,NULL,NULL,1,'2022-10-30 22:26:47','2022-10-30 22:26:47',NULL),(2230,NULL,40719,27,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',350.00,NULL,NULL,1,'2022-10-30 22:26:48','2022-10-30 22:26:48',NULL),(2231,NULL,40719,27,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',380.00,NULL,NULL,1,'2022-10-30 22:26:49','2022-10-30 22:26:49',NULL),(2232,NULL,40719,27,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',380.00,NULL,NULL,1,'2022-10-30 22:26:50','2022-10-30 22:26:50',NULL),(2233,NULL,40719,27,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',280.00,NULL,NULL,1,'2022-10-30 22:26:51','2022-10-30 22:26:51',NULL),(2234,NULL,40719,27,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',290.00,NULL,NULL,1,'2022-10-30 22:26:52','2022-10-30 22:26:52',NULL),(2235,NULL,40719,27,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',299.00,NULL,NULL,1,'2022-10-30 22:26:53','2022-10-30 22:26:53',NULL),(2236,NULL,40719,27,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',400.00,NULL,NULL,1,'2022-10-30 22:26:54','2022-10-30 22:26:54',NULL),(2237,NULL,40719,27,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',311.00,NULL,NULL,1,'2022-10-30 22:26:55','2022-10-30 22:26:55',NULL),(2238,NULL,40719,27,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',322.00,NULL,NULL,1,'2022-10-30 22:26:56','2022-10-30 22:26:56',NULL),(2239,NULL,40719,27,2,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',344.00,NULL,NULL,1,'2022-10-30 22:26:57','2022-10-30 22:26:57',NULL),(2240,NULL,40719,27,2,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',366.00,NULL,NULL,1,'2022-10-30 22:26:58','2022-10-30 22:26:58',NULL),(2241,NULL,40719,27,2,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',180.00,NULL,NULL,1,'2022-10-30 22:26:59','2022-10-30 22:26:59',NULL),(2242,NULL,40719,28,2,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',508.00,NULL,NULL,1,'2022-11-30 22:37:20','2022-11-30 22:37:20',NULL),(2243,NULL,40719,28,2,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',601.00,NULL,NULL,1,'2022-11-30 22:37:21','2022-11-30 22:37:21',NULL),(2244,NULL,40719,28,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',480.00,NULL,NULL,1,'2022-11-30 22:37:22','2022-11-30 22:37:22',NULL),(2245,NULL,40719,28,2,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:37:23','2022-11-30 22:37:23',NULL);
INSERT INTO `balance_libro` VALUES (2246,NULL,40719,28,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:37:24','2022-11-30 22:37:24',NULL),(2247,NULL,40719,28,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',637.00,NULL,NULL,1,'2022-11-30 22:37:25','2022-11-30 22:37:25',NULL),(2248,NULL,40719,28,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',871.00,NULL,NULL,1,'2022-11-30 22:37:26','2022-11-30 22:37:26',NULL),(2249,NULL,40719,28,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',720.00,NULL,NULL,1,'2022-11-30 22:37:27','2022-11-30 22:37:27',NULL),(2250,NULL,40719,28,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',951.00,NULL,NULL,1,'2022-11-30 22:37:28','2022-11-30 22:37:28',NULL),(2251,NULL,40719,28,2,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',547.00,NULL,NULL,1,'2022-11-30 22:37:29','2022-11-30 22:37:29',NULL),(2252,NULL,40719,28,2,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',914.00,NULL,NULL,1,'2022-11-30 22:37:30','2022-11-30 22:37:30',NULL),(2253,NULL,40719,28,2,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:37:31','2022-11-30 22:37:31',NULL),(2254,NULL,40719,28,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',580.00,NULL,NULL,1,'2022-11-30 22:37:32','2022-11-30 22:37:32',NULL),(2255,NULL,40719,28,2,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',852.00,NULL,NULL,1,'2022-11-30 22:37:33','2022-11-30 22:37:33',NULL),(2256,NULL,40719,28,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',311.00,NULL,NULL,1,'2022-11-30 22:37:34','2022-11-30 22:37:34',NULL),(2257,NULL,40719,28,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',322.00,NULL,NULL,1,'2022-11-30 22:37:35','2022-11-30 22:37:35',NULL),(2258,NULL,40719,28,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',400.00,NULL,NULL,1,'2022-11-30 22:37:36','2022-11-30 22:37:36',NULL),(2259,NULL,40719,28,2,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',450.00,NULL,NULL,1,'2022-11-30 22:37:37','2022-11-30 22:37:37',NULL),(2260,NULL,40719,28,2,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',641.00,NULL,NULL,1,'2022-11-30 22:37:38','2022-11-30 22:37:38',NULL),(2261,NULL,40719,28,2,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:37:39','2022-11-30 22:37:39',NULL),(2262,NULL,40719,28,2,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',710.00,NULL,NULL,1,'2022-11-30 22:37:40','2022-11-30 22:37:40',NULL),(2263,NULL,40719,28,2,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',300.00,NULL,NULL,1,'2022-11-30 22:37:41','2022-11-30 22:37:41',NULL),(2264,NULL,40719,28,2,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',410.00,NULL,NULL,1,'2022-11-30 22:37:42','2022-11-30 22:37:42',NULL),(2265,NULL,40719,28,2,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:37:42','2022-11-30 22:37:42',NULL),(2266,NULL,40719,28,2,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',400.00,NULL,NULL,1,'2022-11-30 22:37:43','2022-11-30 22:37:43',NULL);
INSERT INTO `balance_libro` VALUES (2267,NULL,40719,28,2,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',300.00,NULL,NULL,1,'2022-11-30 22:37:44','2022-11-30 22:37:44',NULL),(2268,NULL,40719,28,2,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:37:45','2022-11-30 22:37:45',NULL),(2269,NULL,40719,28,2,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:37:46','2022-11-30 22:37:46',NULL),(2270,NULL,40719,28,2,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',622.00,NULL,NULL,1,'2022-11-30 22:37:47','2022-11-30 22:37:47',NULL),(2271,NULL,40719,28,2,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',387.00,NULL,NULL,1,'2022-11-30 22:37:48','2022-11-30 22:37:48',NULL),(2272,NULL,40719,28,2,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',388.00,NULL,NULL,1,'2022-11-30 22:37:49','2022-11-30 22:37:49',NULL),(2273,NULL,40719,28,2,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:37:50','2022-11-30 22:37:50',NULL),(2274,NULL,40719,28,2,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',620.00,NULL,NULL,1,'2022-11-30 22:37:51','2022-11-30 22:37:51',NULL),(2275,NULL,40719,28,2,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',410.00,NULL,NULL,1,'2022-11-30 22:37:52','2022-11-30 22:37:52',NULL),(2276,NULL,40719,28,2,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',710.00,NULL,NULL,1,'2022-11-30 22:37:53','2022-11-30 22:37:53',NULL),(2277,NULL,40719,28,2,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',180.00,NULL,NULL,1,'2022-11-30 22:37:54','2022-11-30 22:37:54',NULL),(2278,NULL,40719,28,2,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',644.00,NULL,NULL,1,'2022-11-30 22:37:55','2022-11-30 22:37:55',NULL),(2279,NULL,40719,28,2,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',811.00,NULL,NULL,1,'2022-11-30 22:37:56','2022-11-30 22:37:56',NULL),(2280,NULL,40719,28,2,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',349.00,NULL,NULL,1,'2022-11-30 22:37:56','2022-11-30 22:37:56',NULL),(2281,NULL,40719,28,2,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',874.00,NULL,NULL,1,'2022-11-30 22:37:57','2022-11-30 22:37:57',NULL),(2282,NULL,40719,28,2,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',130.00,NULL,NULL,1,'2022-11-30 22:37:58','2022-11-30 22:37:58',NULL),(2283,NULL,40719,28,2,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',810.00,NULL,NULL,1,'2022-11-30 22:37:59','2022-11-30 22:37:59',NULL),(2284,NULL,40719,28,2,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:38:00','2022-11-30 22:38:00',NULL),(2285,NULL,40719,28,2,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',500.00,NULL,NULL,1,'2022-11-30 22:38:01','2022-11-30 22:38:01',NULL),(2286,NULL,40719,28,2,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',560.00,NULL,NULL,1,'2022-11-30 22:38:02','2022-11-30 22:38:02',NULL),(2287,NULL,40719,28,2,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',451.00,NULL,NULL,1,'2022-11-30 22:38:03','2022-11-30 22:38:03',NULL);
INSERT INTO `balance_libro` VALUES (2288,NULL,40719,28,2,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',199.00,NULL,NULL,1,'2022-11-30 22:38:04','2022-11-30 22:38:04',NULL),(2289,NULL,40719,28,2,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:38:05','2022-11-30 22:38:05',NULL),(2290,NULL,40719,28,2,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:38:06','2022-11-30 22:38:06',NULL),(2291,NULL,40719,28,2,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:38:07','2022-11-30 22:38:07',NULL),(2292,NULL,40719,28,2,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',852.00,NULL,NULL,1,'2022-11-30 22:38:08','2022-11-30 22:38:08',NULL),(2293,NULL,40719,28,2,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',963.00,NULL,NULL,1,'2022-11-30 22:38:09','2022-11-30 22:38:09',NULL),(2294,NULL,40719,28,2,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',321.00,NULL,NULL,1,'2022-11-30 22:38:10','2022-11-30 22:38:10',NULL),(2295,NULL,40719,28,2,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:38:11','2022-11-30 22:38:11',NULL),(2296,NULL,40719,28,2,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',987.00,NULL,NULL,1,'2022-11-30 22:38:12','2022-11-30 22:38:12',NULL),(2297,NULL,40719,28,2,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',700.00,NULL,NULL,1,'2022-11-30 22:38:13','2022-11-30 22:38:13',NULL),(2298,NULL,40719,28,2,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',380.00,NULL,NULL,1,'2022-11-30 22:38:14','2022-11-30 22:38:14',NULL),(2299,NULL,40719,28,2,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',288.00,NULL,NULL,1,'2022-11-30 22:38:16','2022-11-30 22:38:16',NULL),(2300,NULL,40719,28,2,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',299.00,NULL,NULL,1,'2022-11-30 22:38:17','2022-11-30 22:38:17',NULL),(2301,NULL,40719,28,2,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',377.00,NULL,NULL,1,'2022-11-30 22:38:17','2022-11-30 22:38:17',NULL),(2302,NULL,40719,28,2,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',199.00,NULL,NULL,1,'2022-11-30 22:38:18','2022-11-30 22:38:18',NULL),(2303,NULL,40719,28,2,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',499.00,NULL,NULL,1,'2022-11-30 22:38:19','2022-11-30 22:38:19',NULL),(2304,NULL,40719,28,2,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',577.00,NULL,NULL,1,'2022-11-30 22:38:21','2022-11-30 22:38:21',NULL),(2305,NULL,40719,28,2,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',588.00,NULL,NULL,1,'2022-11-30 22:38:21','2022-11-30 22:38:21',NULL),(2306,NULL,40719,28,2,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',677.00,NULL,NULL,1,'2022-11-30 22:38:23','2022-11-30 22:38:23',NULL),(2307,NULL,40719,28,2,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',611.00,NULL,NULL,1,'2022-11-30 22:38:23','2022-11-30 22:38:23',NULL),(2308,NULL,40719,28,2,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',611.00,NULL,NULL,1,'2022-11-30 22:38:24','2022-11-30 22:38:24',NULL);
INSERT INTO `balance_libro` VALUES (2309,NULL,40719,28,2,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',641.00,NULL,NULL,1,'2022-11-30 22:38:25','2022-11-30 22:38:25',NULL),(2310,NULL,40719,28,2,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',154.00,NULL,NULL,1,'2022-11-30 22:38:26','2022-11-30 22:38:26',NULL),(2311,NULL,40719,28,2,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:38:27','2022-11-30 22:38:27',NULL),(2312,NULL,40719,28,2,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',541.00,NULL,NULL,1,'2022-11-30 22:38:28','2022-11-30 22:38:28',NULL),(2313,NULL,40719,28,2,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',911.00,NULL,NULL,1,'2022-11-30 22:38:29','2022-11-30 22:38:29',NULL),(2314,NULL,40719,28,2,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',611.00,NULL,NULL,1,'2022-11-30 22:38:30','2022-11-30 22:38:30',NULL),(2315,NULL,40719,28,2,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',521.00,NULL,NULL,1,'2022-11-30 22:38:31','2022-11-30 22:38:31',NULL),(2316,NULL,40719,28,2,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:38:32','2022-11-30 22:38:32',NULL),(2317,NULL,40719,28,2,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',870.00,NULL,NULL,1,'2022-11-30 22:38:33','2022-11-30 22:38:33',NULL),(2318,NULL,40719,28,2,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',546.00,NULL,NULL,1,'2022-11-30 22:38:34','2022-11-30 22:38:34',NULL),(2319,NULL,40719,28,2,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',546.00,NULL,NULL,1,'2022-11-30 22:38:35','2022-11-30 22:38:35',NULL),(2320,NULL,40719,28,2,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',541.00,NULL,NULL,1,'2022-11-30 22:38:36','2022-11-30 22:38:36',NULL),(2321,NULL,40719,28,2,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',574.00,NULL,NULL,1,'2022-11-30 22:38:37','2022-11-30 22:38:37',NULL),(2322,NULL,40719,28,2,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',991.00,NULL,NULL,1,'2022-11-30 22:38:38','2022-11-30 22:38:38',NULL),(2323,NULL,40719,28,2,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',451.00,NULL,NULL,1,'2022-11-30 22:38:39','2022-11-30 22:38:39',NULL),(2324,NULL,40719,28,2,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',877.00,NULL,NULL,1,'2022-11-30 22:38:40','2022-11-30 22:38:40',NULL),(2325,NULL,40719,28,2,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:38:41','2022-11-30 22:38:41',NULL),(2326,NULL,40719,28,2,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',450.00,NULL,NULL,1,'2022-11-30 22:38:42','2022-11-30 22:38:42',NULL),(2327,NULL,40719,28,2,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',781.00,NULL,NULL,1,'2022-11-30 22:38:43','2022-11-30 22:38:43',NULL),(2328,NULL,40719,28,2,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',655.00,NULL,NULL,1,'2022-11-30 22:38:44','2022-11-30 22:38:44',NULL),(2329,NULL,40719,28,2,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',410.00,NULL,NULL,1,'2022-11-30 22:38:45','2022-11-30 22:38:45',NULL);
INSERT INTO `balance_libro` VALUES (2330,NULL,40719,28,2,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',510.00,NULL,NULL,1,'2022-11-30 22:38:46','2022-11-30 22:38:46',NULL),(2331,NULL,40719,28,2,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',655.00,NULL,NULL,1,'2022-11-30 22:38:47','2022-11-30 22:38:47',NULL),(2332,NULL,40719,28,2,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',648.00,NULL,NULL,1,'2022-11-30 22:38:48','2022-11-30 22:38:48',NULL),(2333,NULL,40719,28,2,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',710.00,NULL,NULL,1,'2022-11-30 22:38:48','2022-11-30 22:38:48',NULL),(2334,NULL,40719,28,2,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:38:49','2022-11-30 22:38:49',NULL),(2335,NULL,40719,28,2,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:38:50','2022-11-30 22:38:50',NULL),(2336,NULL,40719,28,2,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:38:51','2022-11-30 22:38:51',NULL),(2337,NULL,40719,28,2,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:38:52','2022-11-30 22:38:52',NULL),(2338,NULL,40719,28,2,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',650.00,NULL,NULL,1,'2022-11-30 22:38:53','2022-11-30 22:38:53',NULL),(2339,NULL,40719,28,2,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',410.00,NULL,NULL,1,'2022-11-30 22:38:54','2022-11-30 22:38:54',NULL),(2340,NULL,40719,28,2,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:38:55','2022-11-30 22:38:55',NULL),(2341,NULL,40719,28,2,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',410.00,NULL,NULL,1,'2022-11-30 22:38:56','2022-11-30 22:38:56',NULL),(2342,NULL,40719,28,2,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',660.00,NULL,NULL,1,'2022-11-30 22:38:57','2022-11-30 22:38:57',NULL),(2343,NULL,40719,28,2,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:38:58','2022-11-30 22:38:58',NULL),(2344,NULL,40719,28,2,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',500.00,NULL,NULL,1,'2022-11-30 22:38:59','2022-11-30 22:38:59',NULL),(2345,NULL,40719,28,2,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',910.00,NULL,NULL,1,'2022-11-30 22:39:00','2022-11-30 22:39:00',NULL),(2346,NULL,40719,28,2,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:39:01','2022-11-30 22:39:01',NULL),(2347,NULL,40719,28,2,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:39:02','2022-11-30 22:39:02',NULL),(2348,NULL,40719,28,2,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:39:03','2022-11-30 22:39:03',NULL),(2349,NULL,40719,28,2,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',650.00,NULL,NULL,1,'2022-11-30 22:39:04','2022-11-30 22:39:04',NULL),(2350,NULL,40719,28,2,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',370.00,NULL,NULL,1,'2022-11-30 22:39:05','2022-11-30 22:39:05',NULL);
INSERT INTO `balance_libro` VALUES (2351,NULL,40719,28,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:39:06','2022-11-30 22:39:06',NULL),(2352,NULL,40719,28,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:39:07','2022-11-30 22:39:07',NULL),(2353,NULL,40719,28,2,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',700.00,NULL,NULL,1,'2022-11-30 22:39:08','2022-11-30 22:39:08',NULL),(2354,NULL,40719,28,2,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:39:09','2022-11-30 22:39:09',NULL),(2355,NULL,40719,28,2,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:39:10','2022-11-30 22:39:10',NULL),(2356,NULL,40719,28,2,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',700.00,NULL,NULL,1,'2022-11-30 22:39:11','2022-11-30 22:39:11',NULL),(2357,NULL,40719,28,2,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:39:12','2022-11-30 22:39:12',NULL),(2358,NULL,40719,28,2,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',500.00,NULL,NULL,1,'2022-11-30 22:39:12','2022-11-30 22:39:12',NULL),(2359,NULL,40719,28,2,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',380.00,NULL,NULL,1,'2022-11-30 22:39:13','2022-11-30 22:39:13',NULL),(2360,NULL,40719,28,2,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:39:14','2022-11-30 22:39:14',NULL),(2361,NULL,40719,28,2,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:39:15','2022-11-30 22:39:15',NULL),(2362,NULL,40719,28,2,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',745.00,NULL,NULL,1,'2022-11-30 22:39:16','2022-11-30 22:39:16',NULL),(2363,NULL,40719,28,2,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',964.00,NULL,NULL,1,'2022-11-30 22:39:17','2022-11-30 22:39:17',NULL),(2364,NULL,40719,28,2,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',987.00,NULL,NULL,1,'2022-11-30 22:39:18','2022-11-30 22:39:18',NULL),(2365,NULL,40719,28,2,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',656.00,NULL,NULL,1,'2022-11-30 22:39:19','2022-11-30 22:39:19',NULL),(2366,NULL,40719,28,2,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:39:20','2022-11-30 22:39:20',NULL),(2367,NULL,40719,28,2,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:39:21','2022-11-30 22:39:21',NULL),(2368,NULL,40719,28,2,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',674.00,NULL,NULL,1,'2022-11-30 22:39:22','2022-11-30 22:39:22',NULL),(2369,NULL,40719,28,2,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:39:23','2022-11-30 22:39:23',NULL),(2370,NULL,40719,28,2,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',852.00,NULL,NULL,1,'2022-11-30 22:39:24','2022-11-30 22:39:24',NULL),(2371,NULL,40719,28,2,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',954.00,NULL,NULL,1,'2022-11-30 22:39:25','2022-11-30 22:39:25',NULL);
INSERT INTO `balance_libro` VALUES (2372,NULL,40719,28,2,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:39:26','2022-11-30 22:39:26',NULL),(2373,NULL,40719,28,2,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',748.00,NULL,NULL,1,'2022-11-30 22:39:27','2022-11-30 22:39:27',NULL),(2374,NULL,40719,28,2,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:39:28','2022-11-30 22:39:28',NULL),(2375,NULL,40719,28,2,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:39:29','2022-11-30 22:39:29',NULL),(2376,NULL,40719,28,2,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:39:30','2022-11-30 22:39:30',NULL),(2377,NULL,40719,28,2,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',640.00,NULL,NULL,1,'2022-11-30 22:39:31','2022-11-30 22:39:31',NULL),(2378,NULL,40719,28,2,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:39:32','2022-11-30 22:39:32',NULL),(2379,NULL,40719,28,2,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',670.00,NULL,NULL,1,'2022-11-30 22:39:33','2022-11-30 22:39:33',NULL),(2380,NULL,40719,28,2,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:39:34','2022-11-30 22:39:34',NULL),(2381,NULL,40719,28,2,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:39:35','2022-11-30 22:39:35',NULL),(2382,NULL,40719,28,2,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:39:36','2022-11-30 22:39:36',NULL),(2383,NULL,40719,28,2,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',655.00,NULL,NULL,1,'2022-11-30 22:39:36','2022-11-30 22:39:36',NULL),(2384,NULL,40719,28,2,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:39:37','2022-11-30 22:39:37',NULL),(2385,NULL,40719,28,2,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',647.00,NULL,NULL,1,'2022-11-30 22:39:38','2022-11-30 22:39:38',NULL),(2386,NULL,40719,28,2,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',911.00,NULL,NULL,1,'2022-11-30 22:39:39','2022-11-30 22:39:39',NULL),(2387,NULL,40719,28,2,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',541.00,NULL,NULL,1,'2022-11-30 22:39:40','2022-11-30 22:39:40',NULL),(2388,NULL,40719,28,2,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',381.00,NULL,NULL,1,'2022-11-30 22:39:41','2022-11-30 22:39:41',NULL),(2389,NULL,40719,28,2,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',700.00,NULL,NULL,1,'2022-11-30 22:39:42','2022-11-30 22:39:42',NULL),(2390,NULL,40719,28,2,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',490.00,NULL,NULL,1,'2022-11-30 22:39:43','2022-11-30 22:39:43',NULL),(2391,NULL,40719,28,2,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',611.00,NULL,NULL,1,'2022-11-30 22:39:44','2022-11-30 22:39:44',NULL),(2392,NULL,40719,28,2,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:39:45','2022-11-30 22:39:45',NULL);
INSERT INTO `balance_libro` VALUES (2393,NULL,40719,28,2,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',367.00,NULL,NULL,1,'2022-11-30 22:39:46','2022-11-30 22:39:46',NULL),(2394,NULL,40719,28,2,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',700.00,NULL,NULL,1,'2022-11-30 22:39:47','2022-11-30 22:39:47',NULL),(2395,NULL,40719,28,2,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',677.00,NULL,NULL,1,'2022-11-30 22:39:48','2022-11-30 22:39:48',NULL),(2396,NULL,40719,28,2,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',630.00,NULL,NULL,1,'2022-11-30 22:39:49','2022-11-30 22:39:49',NULL),(2397,NULL,40719,28,2,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:39:50','2022-11-30 22:39:50',NULL),(2398,NULL,40719,28,2,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:39:51','2022-11-30 22:39:51',NULL),(2399,NULL,40719,28,2,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:39:51','2022-11-30 22:39:51',NULL),(2400,NULL,40719,28,2,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:39:52','2022-11-30 22:39:52',NULL),(2401,NULL,40719,28,2,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',540.00,NULL,NULL,1,'2022-11-30 22:39:53','2022-11-30 22:39:53',NULL),(2402,NULL,40719,28,2,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',700.00,NULL,NULL,1,'2022-11-30 22:39:54','2022-11-30 22:39:54',NULL),(2403,NULL,40719,28,2,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:39:55','2022-11-30 22:39:55',NULL),(2404,NULL,40719,28,2,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',655.00,NULL,NULL,1,'2022-11-30 22:39:56','2022-11-30 22:39:56',NULL),(2405,NULL,40719,28,2,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',410.00,NULL,NULL,1,'2022-11-30 22:39:57','2022-11-30 22:39:57',NULL),(2406,NULL,40719,28,2,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',380.00,NULL,NULL,1,'2022-11-30 22:39:58','2022-11-30 22:39:58',NULL),(2407,NULL,40719,28,2,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',701.00,NULL,NULL,1,'2022-11-30 22:39:59','2022-11-30 22:39:59',NULL),(2408,NULL,40719,28,2,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',51.00,NULL,NULL,1,'2022-11-30 22:40:00','2022-11-30 22:40:00',NULL),(2409,NULL,40719,28,2,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',274.00,NULL,NULL,1,'2022-11-30 22:40:01','2022-11-30 22:40:01',NULL),(2410,NULL,40719,28,2,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',746.00,NULL,NULL,1,'2022-11-30 22:40:02','2022-11-30 22:40:02',NULL),(2411,NULL,40719,28,2,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',674.00,NULL,NULL,1,'2022-11-30 22:40:03','2022-11-30 22:40:03',NULL),(2412,NULL,40719,28,2,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:40:04','2022-11-30 22:40:04',NULL),(2413,NULL,40719,28,2,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:40:05','2022-11-30 22:40:05',NULL);
INSERT INTO `balance_libro` VALUES (2414,NULL,40719,28,2,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',822.00,NULL,NULL,1,'2022-11-30 22:40:06','2022-11-30 22:40:06',NULL),(2415,NULL,40719,28,2,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',917.00,NULL,NULL,1,'2022-11-30 22:40:08','2022-11-30 22:40:08',NULL),(2416,NULL,40719,28,2,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',147.00,NULL,NULL,1,'2022-11-30 22:40:09','2022-11-30 22:40:09',NULL),(2417,NULL,40719,28,2,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',400.00,NULL,NULL,1,'2022-11-30 22:40:10','2022-11-30 22:40:10',NULL),(2418,NULL,40719,28,2,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:40:11','2022-11-30 22:40:11',NULL),(2419,NULL,40719,28,2,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',710.00,NULL,NULL,1,'2022-11-30 22:40:12','2022-11-30 22:40:12',NULL),(2420,NULL,40719,28,2,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',730.00,NULL,NULL,1,'2022-11-30 22:40:13','2022-11-30 22:40:13',NULL),(2421,NULL,40719,28,2,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',674.00,NULL,NULL,1,'2022-11-30 22:40:14','2022-11-30 22:40:14',NULL),(2422,NULL,40719,28,2,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',655.00,NULL,NULL,1,'2022-11-30 22:40:15','2022-11-30 22:40:15',NULL),(2423,NULL,40719,28,2,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',455.00,NULL,NULL,1,'2022-11-30 22:40:15','2022-11-30 22:40:15',NULL),(2424,NULL,40719,28,2,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',811.00,NULL,NULL,1,'2022-11-30 22:40:16','2022-11-30 22:40:16',NULL),(2425,NULL,40719,28,2,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',700.00,NULL,NULL,1,'2022-11-30 22:40:17','2022-11-30 22:40:17',NULL),(2426,NULL,40719,28,2,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',498.00,NULL,NULL,1,'2022-11-30 22:40:18','2022-11-30 22:40:18',NULL),(2427,NULL,40719,28,2,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',471.00,NULL,NULL,1,'2022-11-30 22:40:19','2022-11-30 22:40:19',NULL),(2428,NULL,40719,28,2,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',480.00,NULL,NULL,1,'2022-11-30 22:40:20','2022-11-30 22:40:20',NULL),(2429,NULL,40719,28,2,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:40:21','2022-11-30 22:40:21',NULL),(2430,NULL,40719,28,2,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',400.00,NULL,NULL,1,'2022-11-30 22:40:22','2022-11-30 22:40:22',NULL),(2431,NULL,40719,28,2,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',500.00,NULL,NULL,1,'2022-11-30 22:40:23','2022-11-30 22:40:23',NULL),(2432,NULL,40719,28,2,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',550.00,NULL,NULL,1,'2022-11-30 22:40:24','2022-11-30 22:40:24',NULL),(2433,NULL,40719,28,2,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',554.00,NULL,NULL,1,'2022-11-30 22:40:25','2022-11-30 22:40:25',NULL),(2434,NULL,40719,28,2,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',541.00,NULL,NULL,1,'2022-11-30 22:40:26','2022-11-30 22:40:26',NULL);
INSERT INTO `balance_libro` VALUES (2435,NULL,40719,28,2,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',547.00,NULL,NULL,1,'2022-11-30 22:40:27','2022-11-30 22:40:27',NULL),(2436,NULL,40719,28,2,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',578.00,NULL,NULL,1,'2022-11-30 22:40:28','2022-11-30 22:40:28',NULL),(2437,NULL,40719,28,2,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',546.00,NULL,NULL,1,'2022-11-30 22:40:29','2022-11-30 22:40:29',NULL),(2438,NULL,40719,28,2,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:40:30','2022-11-30 22:40:30',NULL),(2439,NULL,40719,28,2,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',321.00,NULL,NULL,1,'2022-11-30 22:40:31','2022-11-30 22:40:31',NULL),(2440,NULL,40719,28,2,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:40:32','2022-11-30 22:40:32',NULL),(2441,NULL,40719,28,2,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',984.00,NULL,NULL,1,'2022-11-30 22:40:33','2022-11-30 22:40:33',NULL),(2442,NULL,40719,28,2,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',744.00,NULL,NULL,1,'2022-11-30 22:40:34','2022-11-30 22:40:34',NULL),(2443,NULL,40719,28,2,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:40:35','2022-11-30 22:40:35',NULL),(2444,NULL,40719,28,2,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',451.00,NULL,NULL,1,'2022-11-30 22:40:36','2022-11-30 22:40:36',NULL),(2445,NULL,40719,28,2,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1003.00,NULL,NULL,1,'2022-11-30 22:40:37','2022-11-30 22:40:37',NULL),(2446,NULL,40719,28,2,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',870.00,NULL,NULL,1,'2022-11-30 22:40:38','2022-11-30 22:40:38',NULL),(2447,NULL,40719,28,2,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',798.00,NULL,NULL,1,'2022-11-30 22:40:39','2022-11-30 22:40:39',NULL),(2448,NULL,40719,28,2,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:40:40','2022-11-30 22:40:40',NULL),(2449,NULL,40719,28,2,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',749.00,NULL,NULL,1,'2022-11-30 22:40:41','2022-11-30 22:40:41',NULL),(2450,NULL,40719,28,2,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',974.00,NULL,NULL,1,'2022-11-30 22:40:42','2022-11-30 22:40:42',NULL),(2451,NULL,40719,28,2,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',630.00,NULL,NULL,1,'2022-11-30 22:40:43','2022-11-30 22:40:43',NULL),(2452,NULL,40719,28,2,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',479.00,NULL,NULL,1,'2022-11-30 22:40:44','2022-11-30 22:40:44',NULL),(2453,NULL,40719,28,2,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',854.00,NULL,NULL,1,'2022-11-30 22:40:45','2022-11-30 22:40:45',NULL),(2454,NULL,40719,28,2,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',789.00,NULL,NULL,1,'2022-11-30 22:40:46','2022-11-30 22:40:46',NULL),(2455,NULL,40719,28,2,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',617.00,NULL,NULL,1,'2022-11-30 22:40:47','2022-11-30 22:40:47',NULL);
INSERT INTO `balance_libro` VALUES (2456,NULL,40719,28,2,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',645.00,NULL,NULL,1,'2022-11-30 22:40:48','2022-11-30 22:40:48',NULL),(2457,NULL,40719,28,2,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',674.00,NULL,NULL,1,'2022-11-30 22:40:49','2022-11-30 22:40:49',NULL),(2458,NULL,40719,28,2,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',700.00,NULL,NULL,1,'2022-11-30 22:40:50','2022-11-30 22:40:50',NULL),(2459,NULL,40719,28,2,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',841.00,NULL,NULL,1,'2022-11-30 22:40:51','2022-11-30 22:40:51',NULL),(2460,NULL,40719,28,2,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',789.00,NULL,NULL,1,'2022-11-30 22:40:52','2022-11-30 22:40:52',NULL),(2461,NULL,40719,28,2,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:40:53','2022-11-30 22:40:53',NULL),(2462,NULL,40719,28,2,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',481.00,NULL,NULL,1,'2022-11-30 22:40:54','2022-11-30 22:40:54',NULL),(2463,NULL,40719,28,2,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',671.00,NULL,NULL,1,'2022-11-30 22:40:55','2022-11-30 22:40:55',NULL),(2464,NULL,40719,28,2,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',784.00,NULL,NULL,1,'2022-11-30 22:40:56','2022-11-30 22:40:56',NULL),(2465,NULL,40719,28,2,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',914.00,NULL,NULL,1,'2022-11-30 22:40:57','2022-11-30 22:40:57',NULL),(2466,NULL,40719,28,2,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',933.00,NULL,NULL,1,'2022-11-30 22:40:58','2022-11-30 22:40:58',NULL),(2467,NULL,40719,28,2,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',922.00,NULL,NULL,1,'2022-11-30 22:40:59','2022-11-30 22:40:59',NULL),(2468,NULL,40719,28,2,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',911.00,NULL,NULL,1,'2022-11-30 22:41:00','2022-11-30 22:41:00',NULL),(2469,NULL,40719,28,2,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',811.00,NULL,NULL,1,'2022-11-30 22:41:01','2022-11-30 22:41:01',NULL),(2470,NULL,40719,28,2,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',711.00,NULL,NULL,1,'2022-11-30 22:41:02','2022-11-30 22:41:02',NULL),(2471,NULL,40719,28,2,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',722.00,NULL,NULL,1,'2022-11-30 22:41:03','2022-11-30 22:41:03',NULL),(2472,NULL,40719,28,2,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',922.00,NULL,NULL,1,'2022-11-30 22:41:04','2022-11-30 22:41:04',NULL),(2473,NULL,40719,28,2,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',855.00,NULL,NULL,1,'2022-11-30 22:41:05','2022-11-30 22:41:05',NULL),(2474,NULL,40719,28,2,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',844.00,NULL,NULL,1,'2022-11-30 22:41:06','2022-11-30 22:41:06',NULL),(2475,NULL,40719,28,2,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',966.00,NULL,NULL,1,'2022-11-30 22:41:07','2022-11-30 22:41:07',NULL),(2476,NULL,40719,28,2,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',611.00,NULL,NULL,1,'2022-11-30 22:41:08','2022-11-30 22:41:08',NULL);
INSERT INTO `balance_libro` VALUES (2477,NULL,40719,28,2,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',311.00,NULL,NULL,1,'2022-11-30 22:41:09','2022-11-30 22:41:09',NULL),(2478,NULL,40719,28,2,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',411.00,NULL,NULL,1,'2022-11-30 22:41:10','2022-11-30 22:41:10',NULL),(2479,NULL,40719,28,2,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:41:11','2022-11-30 22:41:11',NULL),(2480,NULL,40719,28,2,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',300.00,NULL,NULL,1,'2022-11-30 22:41:12','2022-11-30 22:41:12',NULL),(2481,NULL,40719,28,2,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',500.00,NULL,NULL,1,'2022-11-30 22:41:13','2022-11-30 22:41:13',NULL),(2482,NULL,40719,28,2,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',411.00,NULL,NULL,1,'2022-11-30 22:41:13','2022-11-30 22:41:13',NULL),(2483,NULL,40719,28,2,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:41:14','2022-11-30 22:41:14',NULL),(2484,NULL,40719,28,2,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',640.00,NULL,NULL,1,'2022-11-30 22:41:15','2022-11-30 22:41:15',NULL),(2485,NULL,40719,28,2,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',500.00,NULL,NULL,1,'2022-11-30 22:41:17','2022-11-30 22:41:17',NULL),(2486,NULL,40719,28,2,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:41:18','2022-11-30 22:41:18',NULL),(2487,NULL,40719,28,2,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',642.00,NULL,NULL,1,'2022-11-30 22:41:19','2022-11-30 22:41:19',NULL),(2488,NULL,40719,28,2,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',510.00,NULL,NULL,1,'2022-11-30 22:41:20','2022-11-30 22:41:20',NULL),(2489,NULL,40719,28,2,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',620.00,NULL,NULL,1,'2022-11-30 22:41:21','2022-11-30 22:41:21',NULL),(2490,NULL,40719,28,2,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:41:22','2022-11-30 22:41:22',NULL),(2491,NULL,40719,28,2,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',410.00,NULL,NULL,1,'2022-11-30 22:41:23','2022-11-30 22:41:23',NULL),(2492,NULL,40719,28,2,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',420.00,NULL,NULL,1,'2022-11-30 22:41:24','2022-11-30 22:41:24',NULL),(2493,NULL,40719,28,2,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',321.00,NULL,NULL,1,'2022-11-30 22:41:25','2022-11-30 22:41:25',NULL),(2494,NULL,40719,28,2,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',380.00,NULL,NULL,1,'2022-11-30 22:41:26','2022-11-30 22:41:26',NULL),(2495,NULL,40719,28,2,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',470.00,NULL,NULL,1,'2022-11-30 22:41:27','2022-11-30 22:41:27',NULL),(2496,NULL,40719,28,2,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',700.00,NULL,NULL,1,'2022-11-30 22:41:29','2022-11-30 22:41:29',NULL),(2497,NULL,40719,28,2,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',700.00,NULL,NULL,1,'2022-11-30 22:41:30','2022-11-30 22:41:30',NULL);
INSERT INTO `balance_libro` VALUES (2498,NULL,40719,28,2,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:41:31','2022-11-30 22:41:31',NULL),(2499,NULL,40719,28,2,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',670.00,NULL,NULL,1,'2022-11-30 22:41:32','2022-11-30 22:41:32',NULL),(2500,NULL,40719,28,2,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',570.00,NULL,NULL,1,'2022-11-30 22:41:34','2022-11-30 22:41:34',NULL),(2501,NULL,40719,28,2,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',580.00,NULL,NULL,1,'2022-11-30 22:41:35','2022-11-30 22:41:35',NULL),(2502,NULL,40719,28,2,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',574.00,NULL,NULL,1,'2022-11-30 22:41:36','2022-11-30 22:41:36',NULL),(2503,NULL,40719,28,2,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',576.00,NULL,NULL,1,'2022-11-30 22:41:37','2022-11-30 22:41:37',NULL),(2504,NULL,40719,28,2,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',514.00,NULL,NULL,1,'2022-11-30 22:41:38','2022-11-30 22:41:38',NULL),(2505,NULL,40719,28,2,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',523.00,NULL,NULL,1,'2022-11-30 22:41:39','2022-11-30 22:41:39',NULL),(2506,NULL,40719,28,2,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',517.00,NULL,NULL,1,'2022-11-30 22:41:40','2022-11-30 22:41:40',NULL),(2507,NULL,40719,28,2,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',519.00,NULL,NULL,1,'2022-11-30 22:41:41','2022-11-30 22:41:41',NULL),(2508,NULL,40719,28,2,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',518.00,NULL,NULL,1,'2022-11-30 22:41:43','2022-11-30 22:41:43',NULL),(2509,NULL,40719,28,2,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',874.00,NULL,NULL,1,'2022-11-30 22:41:44','2022-11-30 22:41:44',NULL),(2510,NULL,40719,28,2,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',519.00,NULL,NULL,1,'2022-11-30 22:41:45','2022-11-30 22:41:45',NULL),(2511,NULL,40719,28,2,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',614.00,NULL,NULL,1,'2022-11-30 22:41:46','2022-11-30 22:41:46',NULL),(2512,NULL,40719,28,2,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',547.00,NULL,NULL,1,'2022-11-30 22:41:47','2022-11-30 22:41:47',NULL),(2513,NULL,40719,28,2,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',654.00,NULL,NULL,1,'2022-11-30 22:41:48','2022-11-30 22:41:48',NULL),(2514,NULL,40719,28,2,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',612.00,NULL,NULL,1,'2022-11-30 22:41:49','2022-11-30 22:41:49',NULL),(2515,NULL,40719,28,2,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',635.00,NULL,NULL,1,'2022-11-30 22:41:50','2022-11-30 22:41:50',NULL),(2516,NULL,40719,28,2,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',678.00,NULL,NULL,1,'2022-11-30 22:41:51','2022-11-30 22:41:51',NULL),(2517,NULL,40719,28,2,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',694.00,NULL,NULL,1,'2022-11-30 22:41:52','2022-11-30 22:41:52',NULL),(2518,NULL,40719,28,2,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',647.00,NULL,NULL,1,'2022-11-30 22:41:53','2022-11-30 22:41:53',NULL);
INSERT INTO `balance_libro` VALUES (2519,NULL,40719,28,2,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',614.00,NULL,NULL,1,'2022-11-30 22:41:54','2022-11-30 22:41:54',NULL),(2520,NULL,40719,28,2,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',642.00,NULL,NULL,1,'2022-11-30 22:41:55','2022-11-30 22:41:55',NULL),(2521,NULL,40719,28,2,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',625.00,NULL,NULL,1,'2022-11-30 22:41:56','2022-11-30 22:41:56',NULL),(2522,NULL,40719,28,2,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',623.00,NULL,NULL,1,'2022-11-30 22:41:57','2022-11-30 22:41:57',NULL),(2523,NULL,40719,28,2,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',638.00,NULL,NULL,1,'2022-11-30 22:41:58','2022-11-30 22:41:58',NULL),(2524,NULL,40719,28,2,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',691.00,NULL,NULL,1,'2022-11-30 22:41:58','2022-11-30 22:41:58',NULL),(2525,NULL,40719,28,2,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',671.00,NULL,NULL,1,'2022-11-30 22:41:59','2022-11-30 22:41:59',NULL),(2526,NULL,40719,28,2,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',604.00,NULL,NULL,1,'2022-11-30 22:42:00','2022-11-30 22:42:00',NULL),(2527,NULL,40719,28,2,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',601.00,NULL,NULL,1,'2022-11-30 22:42:01','2022-11-30 22:42:01',NULL),(2528,NULL,40719,28,2,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',632.00,NULL,NULL,1,'2022-11-30 22:42:02','2022-11-30 22:42:02',NULL),(2529,NULL,40719,28,2,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',631.00,NULL,NULL,1,'2022-11-30 22:42:04','2022-11-30 22:42:04',NULL),(2530,NULL,40719,28,2,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',634.00,NULL,NULL,1,'2022-11-30 22:42:04','2022-11-30 22:42:04',NULL),(2531,NULL,40719,28,2,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',635.00,NULL,NULL,1,'2022-11-30 22:42:06','2022-11-30 22:42:06',NULL),(2532,NULL,40719,28,2,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',637.00,NULL,NULL,1,'2022-11-30 22:42:07','2022-11-30 22:42:07',NULL),(2533,NULL,40719,28,2,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',638.00,NULL,NULL,1,'2022-11-30 22:42:08','2022-11-30 22:42:08',NULL),(2534,NULL,40719,28,2,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',639.00,NULL,NULL,1,'2022-11-30 22:42:09','2022-11-30 22:42:09',NULL),(2535,NULL,40719,28,2,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',640.00,NULL,NULL,1,'2022-11-30 22:42:10','2022-11-30 22:42:10',NULL),(2536,NULL,40719,28,2,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',641.00,NULL,NULL,1,'2022-11-30 22:42:10','2022-11-30 22:42:10',NULL),(2537,NULL,40719,28,2,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',642.00,NULL,NULL,1,'2022-11-30 22:42:11','2022-11-30 22:42:11',NULL),(2538,NULL,40719,28,2,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',643.00,NULL,NULL,1,'2022-11-30 22:42:12','2022-11-30 22:42:12',NULL),(2539,NULL,40719,28,2,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',645.00,NULL,NULL,1,'2022-11-30 22:42:13','2022-11-30 22:42:13',NULL);
INSERT INTO `balance_libro` VALUES (2540,NULL,40719,28,2,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:42:14','2022-11-30 22:42:14',NULL),(2541,NULL,40719,28,2,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',500.00,NULL,NULL,1,'2022-11-30 22:42:15','2022-11-30 22:42:15',NULL),(2542,NULL,40719,28,2,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',811.00,NULL,NULL,1,'2022-11-30 22:42:16','2022-11-30 22:42:16',NULL),(2543,NULL,40719,28,2,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',700.00,NULL,NULL,1,'2022-11-30 22:42:17','2022-11-30 22:42:17',NULL),(2544,NULL,40719,28,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:42:18','2022-11-30 22:42:18',NULL),(2545,NULL,40719,28,2,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',450.00,NULL,NULL,1,'2022-11-30 22:42:19','2022-11-30 22:42:19',NULL),(2546,NULL,40719,28,2,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',710.00,NULL,NULL,1,'2022-11-30 22:42:20','2022-11-30 22:42:20',NULL),(2547,NULL,40719,28,2,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:42:21','2022-11-30 22:42:21',NULL),(2548,NULL,40719,28,2,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',700.00,NULL,NULL,1,'2022-11-30 22:42:22','2022-11-30 22:42:22',NULL),(2549,NULL,40719,28,2,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:42:23','2022-11-30 22:42:23',NULL),(2550,NULL,40719,28,2,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',610.00,NULL,NULL,1,'2022-11-30 22:42:24','2022-11-30 22:42:24',NULL),(2551,NULL,40719,28,2,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',400.00,NULL,NULL,1,'2022-11-30 22:42:25','2022-11-30 22:42:25',NULL),(2552,NULL,40719,28,2,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',420.00,NULL,NULL,1,'2022-11-30 22:42:26','2022-11-30 22:42:26',NULL),(2553,NULL,40719,28,2,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',430.00,NULL,NULL,1,'2022-11-30 22:42:27','2022-11-30 22:42:27',NULL),(2554,NULL,40719,28,2,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',450.00,NULL,NULL,1,'2022-11-30 22:42:28','2022-11-30 22:42:28',NULL),(2555,NULL,40719,28,2,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',470.00,NULL,NULL,1,'2022-11-30 22:42:29','2022-11-30 22:42:29',NULL),(2556,NULL,40719,28,2,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',415.00,NULL,NULL,1,'2022-11-30 22:42:30','2022-11-30 22:42:30',NULL),(2557,NULL,40719,28,2,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',410.00,NULL,NULL,1,'2022-11-30 22:42:31','2022-11-30 22:42:31',NULL),(2558,NULL,40719,28,2,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',874.00,NULL,NULL,1,'2022-11-30 22:42:32','2022-11-30 22:42:32',NULL),(2559,NULL,40719,28,2,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',987.00,NULL,NULL,1,'2022-11-30 22:42:33','2022-11-30 22:42:33',NULL),(2560,NULL,40719,28,2,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',508.00,NULL,NULL,1,'2022-11-30 22:42:34','2022-11-30 22:42:34',NULL);
INSERT INTO `balance_libro` VALUES (2561,NULL,40719,28,2,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',601.00,NULL,NULL,1,'2022-11-30 22:42:35','2022-11-30 22:42:35',NULL),(2562,NULL,40719,28,2,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',480.00,NULL,NULL,1,'2022-11-30 22:42:36','2022-11-30 22:42:36',NULL),(2563,NULL,40719,28,2,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:42:37','2022-11-30 22:42:37',NULL),(2564,NULL,40719,28,2,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:42:38','2022-11-30 22:42:38',NULL),(2565,NULL,40719,28,2,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',637.00,NULL,NULL,1,'2022-11-30 22:42:39','2022-11-30 22:42:39',NULL),(2566,NULL,40719,28,2,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',871.00,NULL,NULL,1,'2022-11-30 22:42:40','2022-11-30 22:42:40',NULL),(2567,NULL,40719,28,2,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',720.00,NULL,NULL,1,'2022-11-30 22:42:41','2022-11-30 22:42:41',NULL),(2568,NULL,40719,28,2,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',951.00,NULL,NULL,1,'2022-11-30 22:42:42','2022-11-30 22:42:42',NULL),(2569,NULL,40719,28,2,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',547.00,NULL,NULL,1,'2022-11-30 22:42:43','2022-11-30 22:42:43',NULL),(2570,NULL,40719,28,2,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',914.00,NULL,NULL,1,'2022-11-30 22:42:44','2022-11-30 22:42:44',NULL),(2571,NULL,40719,28,2,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:42:45','2022-11-30 22:42:45',NULL),(2572,NULL,40719,28,2,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',580.00,NULL,NULL,1,'2022-11-30 22:42:46','2022-11-30 22:42:46',NULL),(2573,NULL,40719,28,2,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',852.00,NULL,NULL,1,'2022-11-30 22:42:47','2022-11-30 22:42:47',NULL),(2574,NULL,40719,28,2,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',311.00,NULL,NULL,1,'2022-11-30 22:42:48','2022-11-30 22:42:48',NULL),(2575,NULL,40719,28,2,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',322.00,NULL,NULL,1,'2022-11-30 22:42:49','2022-11-30 22:42:49',NULL),(2576,NULL,40719,28,2,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',400.00,NULL,NULL,1,'2022-11-30 22:42:50','2022-11-30 22:42:50',NULL),(2577,NULL,40719,28,2,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',450.00,NULL,NULL,1,'2022-11-30 22:42:51','2022-11-30 22:42:51',NULL),(2578,NULL,40719,28,2,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',641.00,NULL,NULL,1,'2022-11-30 22:42:52','2022-11-30 22:42:52',NULL),(2579,NULL,40719,28,2,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:42:53','2022-11-30 22:42:53',NULL),(2580,NULL,40719,28,2,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',710.00,NULL,NULL,1,'2022-11-30 22:42:54','2022-11-30 22:42:54',NULL),(2581,NULL,40719,28,2,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',300.00,NULL,NULL,1,'2022-11-30 22:42:55','2022-11-30 22:42:55',NULL);
INSERT INTO `balance_libro` VALUES (2582,NULL,40719,28,2,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',410.00,NULL,NULL,1,'2022-11-30 22:42:56','2022-11-30 22:42:56',NULL),(2583,NULL,40719,28,2,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:42:57','2022-11-30 22:42:57',NULL),(2584,NULL,40719,28,2,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',400.00,NULL,NULL,1,'2022-11-30 22:42:58','2022-11-30 22:42:58',NULL),(2585,NULL,40719,28,2,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',300.00,NULL,NULL,1,'2022-11-30 22:42:59','2022-11-30 22:42:59',NULL),(2586,NULL,40719,28,2,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:43:00','2022-11-30 22:43:00',NULL),(2587,NULL,40719,28,2,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:43:01','2022-11-30 22:43:01',NULL),(2588,NULL,40719,28,2,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',622.00,NULL,NULL,1,'2022-11-30 22:43:02','2022-11-30 22:43:02',NULL),(2589,NULL,40719,28,2,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',387.00,NULL,NULL,1,'2022-11-30 22:43:03','2022-11-30 22:43:03',NULL),(2590,NULL,40719,28,2,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',388.00,NULL,NULL,1,'2022-11-30 22:43:04','2022-11-30 22:43:04',NULL),(2591,NULL,40719,28,2,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:43:05','2022-11-30 22:43:05',NULL),(2592,NULL,40719,28,2,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',620.00,NULL,NULL,1,'2022-11-30 22:43:06','2022-11-30 22:43:06',NULL),(2593,NULL,40719,28,2,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',410.00,NULL,NULL,1,'2022-11-30 22:43:07','2022-11-30 22:43:07',NULL),(2594,NULL,40719,28,2,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',710.00,NULL,NULL,1,'2022-11-30 22:43:08','2022-11-30 22:43:08',NULL),(2595,NULL,40719,28,2,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',180.00,NULL,NULL,1,'2022-11-30 22:43:09','2022-11-30 22:43:09',NULL),(2596,NULL,40719,28,2,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',870.00,NULL,NULL,1,'2022-11-30 22:43:10','2022-11-30 22:43:10',NULL),(2597,NULL,40719,28,2,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',460.00,NULL,NULL,1,'2022-11-30 22:43:11','2022-11-30 22:43:11',NULL),(2598,NULL,40719,28,2,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',450.00,NULL,NULL,1,'2022-11-30 22:43:12','2022-11-30 22:43:12',NULL),(2599,NULL,40719,28,2,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',453.00,NULL,NULL,1,'2022-11-30 22:43:13','2022-11-30 22:43:13',NULL),(2600,NULL,40719,28,2,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',457.00,NULL,NULL,1,'2022-11-30 22:43:14','2022-11-30 22:43:14',NULL),(2601,NULL,40719,28,2,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',422.00,NULL,NULL,1,'2022-11-30 22:43:15','2022-11-30 22:43:15',NULL),(2602,NULL,40719,28,2,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:43:16','2022-11-30 22:43:16',NULL);
INSERT INTO `balance_libro` VALUES (2603,NULL,40719,28,2,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',633.00,NULL,NULL,1,'2022-11-30 22:43:17','2022-11-30 22:43:17',NULL),(2604,NULL,40719,28,2,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',645.00,NULL,NULL,1,'2022-11-30 22:43:18','2022-11-30 22:43:18',NULL),(2605,NULL,40719,28,2,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',611.00,NULL,NULL,1,'2022-11-30 22:43:19','2022-11-30 22:43:19',NULL),(2606,NULL,40719,28,2,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:43:20','2022-11-30 22:43:20',NULL),(2607,NULL,40719,28,2,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',625.00,NULL,NULL,1,'2022-11-30 22:43:21','2022-11-30 22:43:21',NULL),(2608,NULL,40719,28,2,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',645.00,NULL,NULL,1,'2022-11-30 22:43:22','2022-11-30 22:43:22',NULL),(2609,NULL,40719,28,2,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',631.00,NULL,NULL,1,'2022-11-30 22:43:23','2022-11-30 22:43:23',NULL),(2610,NULL,40719,28,2,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',645.00,NULL,NULL,1,'2022-11-30 22:43:24','2022-11-30 22:43:24',NULL),(2611,NULL,40719,28,2,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',622.00,NULL,NULL,1,'2022-11-30 22:43:25','2022-11-30 22:43:25',NULL),(2612,NULL,40719,28,2,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',633.00,NULL,NULL,1,'2022-11-30 22:43:25','2022-11-30 22:43:25',NULL),(2613,NULL,40719,28,2,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',638.00,NULL,NULL,1,'2022-11-30 22:43:27','2022-11-30 22:43:27',NULL),(2614,NULL,40719,28,2,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',677.00,NULL,NULL,1,'2022-11-30 22:43:28','2022-11-30 22:43:28',NULL),(2615,NULL,40719,28,2,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',377.00,NULL,NULL,1,'2022-11-30 22:43:29','2022-11-30 22:43:29',NULL),(2616,NULL,40719,28,2,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',388.00,NULL,NULL,1,'2022-11-30 22:43:30','2022-11-30 22:43:30',NULL),(2617,NULL,40719,28,2,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',451.00,NULL,NULL,1,'2022-11-30 22:43:30','2022-11-30 22:43:30',NULL),(2618,NULL,40719,28,2,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:43:32','2022-11-30 22:43:32',NULL),(2619,NULL,40719,28,2,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',874.00,NULL,NULL,1,'2022-11-30 22:43:33','2022-11-30 22:43:33',NULL),(2620,NULL,40719,28,2,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:43:34','2022-11-30 22:43:34',NULL),(2621,NULL,40719,28,2,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',472.00,NULL,NULL,1,'2022-11-30 22:43:35','2022-11-30 22:43:35',NULL),(2622,NULL,40719,28,2,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:43:36','2022-11-30 22:43:36',NULL),(2623,NULL,40719,28,2,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',300.00,NULL,NULL,1,'2022-11-30 22:43:37','2022-11-30 22:43:37',NULL);
INSERT INTO `balance_libro` VALUES (2624,NULL,40719,28,2,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',852.00,NULL,NULL,1,'2022-11-30 22:43:38','2022-11-30 22:43:38',NULL),(2625,NULL,40719,28,2,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',621.00,NULL,NULL,1,'2022-11-30 22:43:39','2022-11-30 22:43:39',NULL),(2626,NULL,40719,28,2,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',571.00,NULL,NULL,1,'2022-11-30 22:43:40','2022-11-30 22:43:40',NULL),(2627,NULL,40719,28,2,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',591.00,NULL,NULL,1,'2022-11-30 22:43:41','2022-11-30 22:43:41',NULL),(2628,NULL,40719,28,2,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',571.00,NULL,NULL,1,'2022-11-30 22:43:42','2022-11-30 22:43:42',NULL),(2629,NULL,40719,28,2,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',572.00,NULL,NULL,1,'2022-11-30 22:43:43','2022-11-30 22:43:43',NULL),(2630,NULL,40719,28,2,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',532.00,NULL,NULL,1,'2022-11-30 22:43:44','2022-11-30 22:43:44',NULL),(2631,NULL,40719,28,2,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',622.00,NULL,NULL,1,'2022-11-30 22:43:44','2022-11-30 22:43:44',NULL),(2632,NULL,40719,28,2,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',307.00,NULL,NULL,1,'2022-11-30 22:43:45','2022-11-30 22:43:45',NULL),(2633,NULL,40719,28,2,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:43:46','2022-11-30 22:43:46',NULL),(2634,NULL,40719,28,2,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',800.00,NULL,NULL,1,'2022-11-30 22:43:47','2022-11-30 22:43:47',NULL),(2635,NULL,40719,28,2,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',711.00,NULL,NULL,1,'2022-11-30 22:43:48','2022-11-30 22:43:48',NULL),(2636,NULL,40719,28,2,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:43:49','2022-11-30 22:43:49',NULL),(2637,NULL,40719,28,2,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',680.00,NULL,NULL,1,'2022-11-30 22:43:50','2022-11-30 22:43:50',NULL),(2638,NULL,40719,28,2,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',671.00,NULL,NULL,1,'2022-11-30 22:43:51','2022-11-30 22:43:51',NULL),(2639,NULL,40719,28,2,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',488.00,NULL,NULL,1,'2022-11-30 22:43:52','2022-11-30 22:43:52',NULL),(2640,NULL,40719,28,2,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:43:53','2022-11-30 22:43:53',NULL),(2641,NULL,40719,28,2,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',271.00,NULL,NULL,1,'2022-11-30 22:43:54','2022-11-30 22:43:54',NULL),(2642,NULL,40719,28,2,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',634.00,NULL,NULL,1,'2022-11-30 22:43:55','2022-11-30 22:43:55',NULL),(2643,NULL,40719,28,2,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:43:56','2022-11-30 22:43:56',NULL),(2644,NULL,40719,28,2,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',741.00,NULL,NULL,1,'2022-11-30 22:43:57','2022-11-30 22:43:57',NULL);
INSERT INTO `balance_libro` VALUES (2645,NULL,40719,28,2,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',521.00,NULL,NULL,1,'2022-11-30 22:43:58','2022-11-30 22:43:58',NULL),(2646,NULL,40719,28,2,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',123.00,NULL,NULL,1,'2022-11-30 22:43:59','2022-11-30 22:43:59',NULL),(2647,NULL,40719,28,2,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',900.00,NULL,NULL,1,'2022-11-30 22:44:00','2022-11-30 22:44:00',NULL),(2648,NULL,40719,28,2,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',874.00,NULL,NULL,1,'2022-11-30 22:44:01','2022-11-30 22:44:01',NULL),(2649,NULL,40719,28,2,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',471.00,NULL,NULL,1,'2022-11-30 22:44:02','2022-11-30 22:44:02',NULL),(2650,NULL,40719,28,2,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:44:03','2022-11-30 22:44:03',NULL),(2651,NULL,40719,28,2,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:44:04','2022-11-30 22:44:04',NULL),(2652,NULL,40719,28,2,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',611.00,NULL,NULL,1,'2022-11-30 22:44:05','2022-11-30 22:44:05',NULL),(2653,NULL,40719,28,2,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',622.00,NULL,NULL,1,'2022-11-30 22:44:06','2022-11-30 22:44:06',NULL),(2654,NULL,40719,28,2,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',633.00,NULL,NULL,1,'2022-11-30 22:44:07','2022-11-30 22:44:07',NULL),(2655,NULL,40719,28,2,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',644.00,NULL,NULL,1,'2022-11-30 22:44:08','2022-11-30 22:44:08',NULL),(2656,NULL,40719,28,2,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',655.00,NULL,NULL,1,'2022-11-30 22:44:09','2022-11-30 22:44:09',NULL),(2657,NULL,40719,28,2,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',677.00,NULL,NULL,1,'2022-11-30 22:44:10','2022-11-30 22:44:10',NULL),(2658,NULL,40719,28,2,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',688.00,NULL,NULL,1,'2022-11-30 22:44:11','2022-11-30 22:44:11',NULL),(2659,NULL,40719,28,2,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',699.00,NULL,NULL,1,'2022-11-30 22:44:12','2022-11-30 22:44:12',NULL),(2660,NULL,40719,28,2,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',700.00,NULL,NULL,1,'2022-11-30 22:44:13','2022-11-30 22:44:13',NULL),(2661,NULL,40719,28,2,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',500.00,NULL,NULL,1,'2022-11-30 22:44:14','2022-11-30 22:44:14',NULL),(2662,NULL,40719,28,2,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',490.00,NULL,NULL,1,'2022-11-30 22:44:15','2022-11-30 22:44:15',NULL),(2663,NULL,40719,28,2,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',480.00,NULL,NULL,1,'2022-11-30 22:44:16','2022-11-30 22:44:16',NULL),(2664,NULL,40719,28,2,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',470.00,NULL,NULL,1,'2022-11-30 22:44:17','2022-11-30 22:44:17',NULL),(2665,NULL,40719,28,2,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',600.00,NULL,NULL,1,'2022-11-30 22:44:18','2022-11-30 22:44:18',NULL);
INSERT INTO `balance_libro` VALUES (2666,NULL,40719,28,2,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',500.00,NULL,NULL,1,'2022-11-30 22:44:19','2022-11-30 22:44:19',NULL),(2667,NULL,40719,28,2,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',411.00,NULL,NULL,1,'2022-11-30 22:44:21','2022-11-30 22:44:21',NULL),(2668,NULL,40719,28,2,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',500.00,NULL,NULL,1,'2022-11-30 22:44:21','2022-11-30 22:44:21',NULL),(2669,NULL,40719,29,2,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:39:04','2022-12-31 14:39:04',NULL),(2670,NULL,40719,29,2,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',540.00,NULL,NULL,1,'2022-12-31 14:39:05','2022-12-31 14:39:05',NULL),(2671,NULL,40719,29,2,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',620.00,NULL,NULL,1,'2022-12-31 14:39:06','2022-12-31 14:39:06',NULL),(2672,NULL,40719,29,2,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',740.00,NULL,NULL,1,'2022-12-31 14:39:07','2022-12-31 14:39:07',NULL),(2673,NULL,40719,29,2,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',654.00,NULL,NULL,1,'2022-12-31 14:39:08','2022-12-31 14:39:08',NULL),(2674,NULL,40719,29,2,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',741.00,NULL,NULL,1,'2022-12-31 14:39:08','2022-12-31 14:39:08',NULL),(2675,NULL,40719,29,2,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',789.00,NULL,NULL,1,'2022-12-31 14:39:09','2022-12-31 14:39:09',NULL),(2676,NULL,40719,29,2,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',963.00,NULL,NULL,1,'2022-12-31 14:39:10','2022-12-31 14:39:10',NULL),(2677,NULL,40719,29,2,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:39:11','2022-12-31 14:39:11',NULL),(2678,NULL,40719,29,2,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',641.00,NULL,NULL,1,'2022-12-31 14:39:12','2022-12-31 14:39:12',NULL),(2679,NULL,40719,29,2,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',632.00,NULL,NULL,1,'2022-12-31 14:39:13','2022-12-31 14:39:13',NULL),(2680,NULL,40719,29,2,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',800.00,NULL,NULL,1,'2022-12-31 14:39:14','2022-12-31 14:39:14',NULL),(2681,NULL,40719,29,2,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',410.00,NULL,NULL,1,'2022-12-31 14:39:15','2022-12-31 14:39:15',NULL),(2682,NULL,40719,29,2,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',300.00,NULL,NULL,1,'2022-12-31 14:39:16','2022-12-31 14:39:16',NULL),(2683,NULL,40719,29,2,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',300.00,NULL,NULL,1,'2022-12-31 14:39:17','2022-12-31 14:39:17',NULL),(2684,NULL,40719,29,2,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',310.00,NULL,NULL,1,'2022-12-31 14:39:18','2022-12-31 14:39:18',NULL),(2685,NULL,40719,29,2,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',441.00,NULL,NULL,1,'2022-12-31 14:39:18','2022-12-31 14:39:18',NULL),(2686,NULL,40719,29,2,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:39:19','2022-12-31 14:39:19',NULL);
INSERT INTO `balance_libro` VALUES (2687,NULL,40719,29,2,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:39:20','2022-12-31 14:39:20',NULL),(2688,NULL,40719,29,2,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',663.00,NULL,NULL,1,'2022-12-31 14:39:21','2022-12-31 14:39:21',NULL),(2689,NULL,40719,29,2,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',663.00,NULL,NULL,1,'2022-12-31 14:39:22','2022-12-31 14:39:22',NULL),(2690,NULL,40719,29,2,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:39:23','2022-12-31 14:39:23',NULL),(2691,NULL,40719,29,2,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',441.00,NULL,NULL,1,'2022-12-31 14:39:24','2022-12-31 14:39:24',NULL),(2692,NULL,40719,29,2,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',885.00,NULL,NULL,1,'2022-12-31 14:39:25','2022-12-31 14:39:25',NULL),(2693,NULL,40719,29,2,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',996.00,NULL,NULL,1,'2022-12-31 14:39:26','2022-12-31 14:39:26',NULL),(2694,NULL,40719,29,2,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',774.00,NULL,NULL,1,'2022-12-31 14:39:27','2022-12-31 14:39:27',NULL),(2695,NULL,40719,29,2,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:39:27','2022-12-31 14:39:27',NULL),(2696,NULL,40719,29,2,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2022-12-31 14:39:28','2022-12-31 14:39:28',NULL),(2697,NULL,40719,29,2,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:39:29','2022-12-31 14:39:29',NULL),(2698,NULL,40719,29,2,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:39:30','2022-12-31 14:39:30',NULL),(2699,NULL,40719,29,2,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:39:31','2022-12-31 14:39:31',NULL),(2700,NULL,40719,29,2,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2022-12-31 14:39:32','2022-12-31 14:39:32',NULL),(2701,NULL,40719,29,2,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',800.00,NULL,NULL,1,'2022-12-31 14:39:33','2022-12-31 14:39:33',NULL),(2702,NULL,40719,29,2,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:39:34','2022-12-31 14:39:34',NULL),(2703,NULL,40719,29,2,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2022-12-31 14:39:35','2022-12-31 14:39:35',NULL),(2704,NULL,40719,29,2,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',800.00,NULL,NULL,1,'2022-12-31 14:39:36','2022-12-31 14:39:36',NULL),(2705,NULL,40719,29,2,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:39:37','2022-12-31 14:39:37',NULL),(2706,NULL,40719,29,2,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:39:38','2022-12-31 14:39:38',NULL),(2707,NULL,40719,29,2,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',580.00,NULL,NULL,1,'2022-12-31 14:39:39','2022-12-31 14:39:39',NULL);
INSERT INTO `balance_libro` VALUES (2708,NULL,40719,29,2,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:39:39','2022-12-31 14:39:39',NULL),(2709,NULL,40719,29,2,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',450.00,NULL,NULL,1,'2022-12-31 14:39:40','2022-12-31 14:39:40',NULL),(2710,NULL,40719,29,2,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',654.00,NULL,NULL,1,'2022-12-31 14:39:41','2022-12-31 14:39:41',NULL),(2711,NULL,40719,29,2,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',450.00,NULL,NULL,1,'2022-12-31 14:39:42','2022-12-31 14:39:42',NULL),(2712,NULL,40719,29,2,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',978.00,NULL,NULL,1,'2022-12-31 14:39:43','2022-12-31 14:39:43',NULL),(2713,NULL,40719,29,2,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',789.00,NULL,NULL,1,'2022-12-31 14:39:44','2022-12-31 14:39:44',NULL),(2714,NULL,40719,29,2,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',741.00,NULL,NULL,1,'2022-12-31 14:39:45','2022-12-31 14:39:45',NULL),(2715,NULL,40719,29,2,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',753.00,NULL,NULL,1,'2022-12-31 14:39:46','2022-12-31 14:39:46',NULL),(2716,NULL,40719,29,2,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',725.00,NULL,NULL,1,'2022-12-31 14:39:46','2022-12-31 14:39:46',NULL),(2717,NULL,40719,29,2,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',739.00,NULL,NULL,1,'2022-12-31 14:39:47','2022-12-31 14:39:47',NULL),(2718,NULL,40719,29,2,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',640.00,NULL,NULL,1,'2022-12-31 14:39:48','2022-12-31 14:39:48',NULL),(2719,NULL,40719,29,2,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',674.00,NULL,NULL,1,'2022-12-31 14:39:49','2022-12-31 14:39:49',NULL),(2720,NULL,40719,29,2,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',996.00,NULL,NULL,1,'2022-12-31 14:39:50','2022-12-31 14:39:50',NULL),(2721,NULL,40719,29,2,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',774.00,NULL,NULL,1,'2022-12-31 14:39:51','2022-12-31 14:39:51',NULL),(2722,NULL,40719,29,2,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',664.00,NULL,NULL,1,'2022-12-31 14:39:52','2022-12-31 14:39:52',NULL),(2723,NULL,40719,29,2,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',954.00,NULL,NULL,1,'2022-12-31 14:39:53','2022-12-31 14:39:53',NULL),(2724,NULL,40719,29,2,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',855.00,NULL,NULL,1,'2022-12-31 14:39:54','2022-12-31 14:39:54',NULL),(2725,NULL,40719,29,2,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',755.00,NULL,NULL,1,'2022-12-31 14:39:55','2022-12-31 14:39:55',NULL),(2726,NULL,40719,29,2,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',766.00,NULL,NULL,1,'2022-12-31 14:39:56','2022-12-31 14:39:56',NULL),(2727,NULL,40719,29,2,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',744.00,NULL,NULL,1,'2022-12-31 14:39:56','2022-12-31 14:39:56',NULL),(2728,NULL,40719,29,2,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',799.00,NULL,NULL,1,'2022-12-31 14:39:57','2022-12-31 14:39:57',NULL);
INSERT INTO `balance_libro` VALUES (2729,NULL,40719,29,2,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',711.00,NULL,NULL,1,'2022-12-31 14:39:58','2022-12-31 14:39:58',NULL),(2730,NULL,40719,29,2,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',611.00,NULL,NULL,1,'2022-12-31 14:39:59','2022-12-31 14:39:59',NULL),(2731,NULL,40719,29,2,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',644.00,NULL,NULL,1,'2022-12-31 14:40:00','2022-12-31 14:40:00',NULL),(2732,NULL,40719,29,2,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',655.00,NULL,NULL,1,'2022-12-31 14:40:01','2022-12-31 14:40:01',NULL),(2733,NULL,40719,29,2,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',633.00,NULL,NULL,1,'2022-12-31 14:40:02','2022-12-31 14:40:02',NULL),(2734,NULL,40719,29,2,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',620.00,NULL,NULL,1,'2022-12-31 14:40:03','2022-12-31 14:40:03',NULL),(2735,NULL,40719,29,2,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',644.00,NULL,NULL,1,'2022-12-31 14:40:04','2022-12-31 14:40:04',NULL),(2736,NULL,40719,29,2,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2022-12-31 14:40:05','2022-12-31 14:40:05',NULL),(2737,NULL,40719,29,2,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2022-12-31 14:40:06','2022-12-31 14:40:06',NULL),(2738,NULL,40719,29,2,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',751.00,NULL,NULL,1,'2022-12-31 14:40:07','2022-12-31 14:40:07',NULL),(2739,NULL,40719,29,2,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',680.00,NULL,NULL,1,'2022-12-31 14:40:07','2022-12-31 14:40:07',NULL),(2740,NULL,40719,29,2,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',680.00,NULL,NULL,1,'2022-12-31 14:40:08','2022-12-31 14:40:08',NULL),(2741,NULL,40719,29,2,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',680.00,NULL,NULL,1,'2022-12-31 14:40:09','2022-12-31 14:40:09',NULL),(2742,NULL,40719,29,2,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',680.00,NULL,NULL,1,'2022-12-31 14:40:10','2022-12-31 14:40:10',NULL),(2743,NULL,40719,29,2,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',641.00,NULL,NULL,1,'2022-12-31 14:40:11','2022-12-31 14:40:11',NULL),(2744,NULL,40719,29,2,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',641.00,NULL,NULL,1,'2022-12-31 14:40:12','2022-12-31 14:40:12',NULL),(2745,NULL,40719,29,2,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',622.00,NULL,NULL,1,'2022-12-31 14:40:13','2022-12-31 14:40:13',NULL),(2746,NULL,40719,29,2,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',633.00,NULL,NULL,1,'2022-12-31 14:40:14','2022-12-31 14:40:14',NULL),(2747,NULL,40719,29,2,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',655.00,NULL,NULL,1,'2022-12-31 14:40:15','2022-12-31 14:40:15',NULL),(2748,NULL,40719,29,2,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',740.00,NULL,NULL,1,'2022-12-31 14:40:15','2022-12-31 14:40:15',NULL),(2749,NULL,40719,29,2,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',500.00,NULL,NULL,1,'2022-12-31 14:40:16','2022-12-31 14:40:16',NULL);
INSERT INTO `balance_libro` VALUES (2750,NULL,40719,29,2,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',490.00,NULL,NULL,1,'2022-12-31 14:40:17','2022-12-31 14:40:17',NULL),(2751,NULL,40719,29,2,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',403.00,NULL,NULL,1,'2022-12-31 14:40:18','2022-12-31 14:40:18',NULL),(2752,NULL,40719,29,2,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',406.00,NULL,NULL,1,'2022-12-31 14:40:19','2022-12-31 14:40:19',NULL),(2753,NULL,40719,29,2,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',418.00,NULL,NULL,1,'2022-12-31 14:40:20','2022-12-31 14:40:20',NULL),(2754,NULL,40719,29,2,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',467.00,NULL,NULL,1,'2022-12-31 14:40:21','2022-12-31 14:40:21',NULL),(2755,NULL,40719,29,2,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',417.00,NULL,NULL,1,'2022-12-31 14:40:22','2022-12-31 14:40:22',NULL),(2756,NULL,40719,29,2,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',419.00,NULL,NULL,1,'2022-12-31 14:40:23','2022-12-31 14:40:23',NULL),(2757,NULL,40719,29,2,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',418.00,NULL,NULL,1,'2022-12-31 14:40:23','2022-12-31 14:40:23',NULL),(2758,NULL,40719,29,2,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',417.00,NULL,NULL,1,'2022-12-31 14:40:24','2022-12-31 14:40:24',NULL),(2759,NULL,40719,29,2,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',413.00,NULL,NULL,1,'2022-12-31 14:40:25','2022-12-31 14:40:25',NULL),(2760,NULL,40719,29,2,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',415.00,NULL,NULL,1,'2022-12-31 14:40:26','2022-12-31 14:40:26',NULL),(2761,NULL,40719,29,2,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',416.00,NULL,NULL,1,'2022-12-31 14:40:27','2022-12-31 14:40:27',NULL),(2762,NULL,40719,29,2,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',418.00,NULL,NULL,1,'2022-12-31 14:40:28','2022-12-31 14:40:28',NULL),(2763,NULL,40719,29,2,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',436.00,NULL,NULL,1,'2022-12-31 14:40:29','2022-12-31 14:40:29',NULL),(2764,NULL,40719,29,2,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',481.00,NULL,NULL,1,'2022-12-31 14:40:30','2022-12-31 14:40:30',NULL),(2765,NULL,40719,29,2,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',461.00,NULL,NULL,1,'2022-12-31 14:40:31','2022-12-31 14:40:31',NULL),(2766,NULL,40719,29,2,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',432.00,NULL,NULL,1,'2022-12-31 14:40:31','2022-12-31 14:40:31',NULL),(2767,NULL,40719,29,2,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',411.00,NULL,NULL,1,'2022-12-31 14:40:32','2022-12-31 14:40:32',NULL),(2768,NULL,40719,29,2,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',410.00,NULL,NULL,1,'2022-12-31 14:40:33','2022-12-31 14:40:33',NULL),(2769,NULL,40719,29,2,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:40:34','2022-12-31 14:40:34',NULL),(2770,NULL,40719,29,2,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:40:35','2022-12-31 14:40:35',NULL);
INSERT INTO `balance_libro` VALUES (2771,NULL,40719,29,2,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:40:36','2022-12-31 14:40:36',NULL),(2772,NULL,40719,29,2,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',450.00,NULL,NULL,1,'2022-12-31 14:40:37','2022-12-31 14:40:37',NULL),(2773,NULL,40719,29,2,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',460.00,NULL,NULL,1,'2022-12-31 14:40:38','2022-12-31 14:40:38',NULL),(2774,NULL,40719,29,2,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',470.00,NULL,NULL,1,'2022-12-31 14:40:39','2022-12-31 14:40:39',NULL),(2775,NULL,40719,29,2,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',480.00,NULL,NULL,1,'2022-12-31 14:40:39','2022-12-31 14:40:39',NULL),(2776,NULL,40719,29,2,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',490.00,NULL,NULL,1,'2022-12-31 14:40:40','2022-12-31 14:40:40',NULL),(2777,NULL,40719,29,2,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',410.00,NULL,NULL,1,'2022-12-31 14:40:41','2022-12-31 14:40:41',NULL),(2778,NULL,40719,29,2,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',420.00,NULL,NULL,1,'2022-12-31 14:40:42','2022-12-31 14:40:42',NULL),(2779,NULL,40719,29,2,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',430.00,NULL,NULL,1,'2022-12-31 14:40:43','2022-12-31 14:40:43',NULL),(2780,NULL,40719,29,2,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',450.00,NULL,NULL,1,'2022-12-31 14:40:44','2022-12-31 14:40:44',NULL),(2781,NULL,40719,29,2,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',460.00,NULL,NULL,1,'2022-12-31 14:40:45','2022-12-31 14:40:45',NULL),(2782,NULL,40719,29,2,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',490.00,NULL,NULL,1,'2022-12-31 14:40:46','2022-12-31 14:40:46',NULL),(2783,NULL,40719,29,2,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',380.00,NULL,NULL,1,'2022-12-31 14:40:47','2022-12-31 14:40:47',NULL),(2784,NULL,40719,29,2,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',390.00,NULL,NULL,1,'2022-12-31 14:40:47','2022-12-31 14:40:47',NULL),(2785,NULL,40719,29,2,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',380.00,NULL,NULL,1,'2022-12-31 14:40:48','2022-12-31 14:40:48',NULL),(2786,NULL,40719,29,2,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',387.00,NULL,NULL,1,'2022-12-31 14:40:49','2022-12-31 14:40:49',NULL),(2787,NULL,40719,29,2,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',311.00,NULL,NULL,1,'2022-12-31 14:40:50','2022-12-31 14:40:50',NULL),(2788,NULL,40719,29,2,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',411.00,NULL,NULL,1,'2022-12-31 14:40:51','2022-12-31 14:40:51',NULL),(2789,NULL,40719,29,2,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',390.00,NULL,NULL,1,'2022-12-31 14:40:52','2022-12-31 14:40:52',NULL),(2790,NULL,40719,29,2,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',387.00,NULL,NULL,1,'2022-12-31 14:40:53','2022-12-31 14:40:53',NULL),(2791,NULL,40719,29,2,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',398.00,NULL,NULL,1,'2022-12-31 14:40:54','2022-12-31 14:40:54',NULL);
INSERT INTO `balance_libro` VALUES (2792,NULL,40719,29,2,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',364.00,NULL,NULL,1,'2022-12-31 14:40:55','2022-12-31 14:40:55',NULL),(2793,NULL,40719,29,2,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',378.00,NULL,NULL,1,'2022-12-31 14:40:56','2022-12-31 14:40:56',NULL),(2794,NULL,40719,29,2,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:40:57','2022-12-31 14:40:57',NULL),(2795,NULL,40719,29,2,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',422.00,NULL,NULL,1,'2022-12-31 14:40:57','2022-12-31 14:40:57',NULL),(2796,NULL,40719,29,2,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',433.00,NULL,NULL,1,'2022-12-31 14:40:58','2022-12-31 14:40:58',NULL),(2797,NULL,40719,29,2,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',444.00,NULL,NULL,1,'2022-12-31 14:40:59','2022-12-31 14:40:59',NULL),(2798,NULL,40719,29,2,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',466.00,NULL,NULL,1,'2022-12-31 14:41:00','2022-12-31 14:41:00',NULL),(2799,NULL,40719,29,2,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',451.00,NULL,NULL,1,'2022-12-31 14:41:01','2022-12-31 14:41:01',NULL),(2800,NULL,40719,29,2,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:41:02','2022-12-31 14:41:02',NULL),(2801,NULL,40719,29,2,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',465.00,NULL,NULL,1,'2022-12-31 14:41:03','2022-12-31 14:41:03',NULL),(2802,NULL,40719,29,2,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',451.00,NULL,NULL,1,'2022-12-31 14:41:04','2022-12-31 14:41:04',NULL),(2803,NULL,40719,29,2,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',300.00,NULL,NULL,1,'2022-12-31 14:41:05','2022-12-31 14:41:05',NULL),(2804,NULL,40719,29,2,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',300.00,NULL,NULL,1,'2022-12-31 14:41:06','2022-12-31 14:41:06',NULL),(2805,NULL,40719,29,2,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',310.00,NULL,NULL,1,'2022-12-31 14:41:07','2022-12-31 14:41:07',NULL),(2806,NULL,40719,29,2,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',441.00,NULL,NULL,1,'2022-12-31 14:41:08','2022-12-31 14:41:08',NULL),(2807,NULL,40719,29,2,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:41:09','2022-12-31 14:41:09',NULL),(2808,NULL,40719,29,2,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:41:10','2022-12-31 14:41:10',NULL),(2809,NULL,40719,29,2,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',663.00,NULL,NULL,1,'2022-12-31 14:41:10','2022-12-31 14:41:10',NULL),(2810,NULL,40719,29,2,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',663.00,NULL,NULL,1,'2022-12-31 14:41:11','2022-12-31 14:41:11',NULL),(2811,NULL,40719,29,2,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:41:12','2022-12-31 14:41:12',NULL),(2812,NULL,40719,29,2,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',441.00,NULL,NULL,1,'2022-12-31 14:41:13','2022-12-31 14:41:13',NULL);
INSERT INTO `balance_libro` VALUES (2813,NULL,40719,29,2,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',885.00,NULL,NULL,1,'2022-12-31 14:41:14','2022-12-31 14:41:14',NULL),(2814,NULL,40719,29,2,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',996.00,NULL,NULL,1,'2022-12-31 14:41:15','2022-12-31 14:41:15',NULL),(2815,NULL,40719,29,2,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',774.00,NULL,NULL,1,'2022-12-31 14:41:16','2022-12-31 14:41:16',NULL),(2816,NULL,40719,29,2,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:41:17','2022-12-31 14:41:17',NULL),(2817,NULL,40719,29,2,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2022-12-31 14:41:18','2022-12-31 14:41:18',NULL),(2818,NULL,40719,29,2,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:41:19','2022-12-31 14:41:19',NULL),(2819,NULL,40719,29,2,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:41:20','2022-12-31 14:41:20',NULL),(2820,NULL,40719,29,2,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:41:21','2022-12-31 14:41:21',NULL),(2821,NULL,40719,29,2,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2022-12-31 14:41:22','2022-12-31 14:41:22',NULL),(2822,NULL,40719,29,2,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',800.00,NULL,NULL,1,'2022-12-31 14:41:23','2022-12-31 14:41:23',NULL),(2823,NULL,40719,29,2,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:41:25','2022-12-31 14:41:25',NULL),(2824,NULL,40719,29,2,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2022-12-31 14:41:25','2022-12-31 14:41:25',NULL),(2825,NULL,40719,29,2,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',800.00,NULL,NULL,1,'2022-12-31 14:41:26','2022-12-31 14:41:26',NULL),(2826,NULL,40719,29,2,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:41:28','2022-12-31 14:41:28',NULL),(2827,NULL,40719,29,2,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:41:29','2022-12-31 14:41:29',NULL),(2828,NULL,40719,29,2,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',580.00,NULL,NULL,1,'2022-12-31 14:41:30','2022-12-31 14:41:30',NULL),(2829,NULL,40719,29,2,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:41:31','2022-12-31 14:41:31',NULL),(2830,NULL,40719,29,2,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',450.00,NULL,NULL,1,'2022-12-31 14:41:32','2022-12-31 14:41:32',NULL),(2831,NULL,40719,29,2,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',654.00,NULL,NULL,1,'2022-12-31 14:41:33','2022-12-31 14:41:33',NULL),(2832,NULL,40719,29,2,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',450.00,NULL,NULL,1,'2022-12-31 14:41:34','2022-12-31 14:41:34',NULL),(2833,NULL,40719,29,2,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',978.00,NULL,NULL,1,'2022-12-31 14:41:35','2022-12-31 14:41:35',NULL);
INSERT INTO `balance_libro` VALUES (2834,NULL,40719,29,2,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',789.00,NULL,NULL,1,'2022-12-31 14:41:36','2022-12-31 14:41:36',NULL),(2835,NULL,40719,29,2,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:41:37','2022-12-31 14:41:37',NULL),(2836,NULL,40719,29,2,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',540.00,NULL,NULL,1,'2022-12-31 14:41:39','2022-12-31 14:41:39',NULL),(2837,NULL,40719,29,2,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',620.00,NULL,NULL,1,'2022-12-31 14:41:40','2022-12-31 14:41:40',NULL),(2838,NULL,40719,29,2,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',740.00,NULL,NULL,1,'2022-12-31 14:41:41','2022-12-31 14:41:41',NULL),(2839,NULL,40719,29,2,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',654.00,NULL,NULL,1,'2022-12-31 14:41:42','2022-12-31 14:41:42',NULL),(2840,NULL,40719,29,2,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',741.00,NULL,NULL,1,'2022-12-31 14:41:43','2022-12-31 14:41:43',NULL),(2841,NULL,40719,29,2,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',789.00,NULL,NULL,1,'2022-12-31 14:41:44','2022-12-31 14:41:44',NULL),(2842,NULL,40719,29,2,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',963.00,NULL,NULL,1,'2022-12-31 14:41:45','2022-12-31 14:41:45',NULL),(2843,NULL,40719,29,2,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:41:46','2022-12-31 14:41:46',NULL),(2844,NULL,40719,29,2,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',641.00,NULL,NULL,1,'2022-12-31 14:41:47','2022-12-31 14:41:47',NULL),(2845,NULL,40719,29,2,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',632.00,NULL,NULL,1,'2022-12-31 14:41:48','2022-12-31 14:41:48',NULL),(2846,NULL,40719,29,2,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',800.00,NULL,NULL,1,'2022-12-31 14:41:49','2022-12-31 14:41:49',NULL),(2847,NULL,40719,29,2,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',410.00,NULL,NULL,1,'2022-12-31 14:41:50','2022-12-31 14:41:50',NULL),(2848,NULL,40719,29,2,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',370.00,NULL,NULL,1,'2022-12-31 14:41:51','2022-12-31 14:41:51',NULL),(2849,NULL,40719,29,2,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',380.00,NULL,NULL,1,'2022-12-31 14:41:52','2022-12-31 14:41:52',NULL),(2850,NULL,40719,29,2,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',391.00,NULL,NULL,1,'2022-12-31 14:41:53','2022-12-31 14:41:53',NULL),(2851,NULL,40719,29,2,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',381.00,NULL,NULL,1,'2022-12-31 14:41:53','2022-12-31 14:41:53',NULL),(2852,NULL,40719,29,2,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',387.00,NULL,NULL,1,'2022-12-31 14:41:54','2022-12-31 14:41:54',NULL),(2853,NULL,40719,29,2,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',314.00,NULL,NULL,1,'2022-12-31 14:41:55','2022-12-31 14:41:55',NULL),(2854,NULL,40719,29,2,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:41:56','2022-12-31 14:41:56',NULL);
INSERT INTO `balance_libro` VALUES (2855,NULL,40719,29,2,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',300.00,NULL,NULL,1,'2022-12-31 14:41:57','2022-12-31 14:41:57',NULL),(2856,NULL,40719,29,2,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',644.00,NULL,NULL,1,'2022-12-31 14:41:58','2022-12-31 14:41:58',NULL),(2857,NULL,40719,29,2,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',611.00,NULL,NULL,1,'2022-12-31 14:41:59','2022-12-31 14:41:59',NULL),(2858,NULL,40719,29,2,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:42:00','2022-12-31 14:42:00',NULL),(2859,NULL,40719,29,2,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:42:01','2022-12-31 14:42:01',NULL),(2860,NULL,40719,29,2,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',610.00,NULL,NULL,1,'2022-12-31 14:42:02','2022-12-31 14:42:02',NULL),(2861,NULL,40719,29,2,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',177.00,NULL,NULL,1,'2022-12-31 14:42:03','2022-12-31 14:42:03',NULL),(2862,NULL,40719,29,2,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',988.00,NULL,NULL,1,'2022-12-31 14:42:04','2022-12-31 14:42:04',NULL),(2863,NULL,40719,29,2,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',641.00,NULL,NULL,1,'2022-12-31 14:42:04','2022-12-31 14:42:04',NULL),(2864,NULL,40719,29,2,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:42:05','2022-12-31 14:42:05',NULL),(2865,NULL,40719,29,2,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:42:06','2022-12-31 14:42:06',NULL),(2866,NULL,40719,29,2,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:42:07','2022-12-31 14:42:07',NULL),(2867,NULL,40719,29,2,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:42:08','2022-12-31 14:42:08',NULL),(2868,NULL,40719,29,2,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:42:09','2022-12-31 14:42:09',NULL),(2869,NULL,40719,29,2,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:42:10','2022-12-31 14:42:10',NULL),(2870,NULL,40719,29,2,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:42:11','2022-12-31 14:42:11',NULL),(2871,NULL,40719,29,2,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:42:12','2022-12-31 14:42:12',NULL),(2872,NULL,40719,29,2,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',540.00,NULL,NULL,1,'2022-12-31 14:42:13','2022-12-31 14:42:13',NULL),(2873,NULL,40719,29,2,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',620.00,NULL,NULL,1,'2022-12-31 14:42:14','2022-12-31 14:42:14',NULL),(2874,NULL,40719,29,2,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',740.00,NULL,NULL,1,'2022-12-31 14:42:15','2022-12-31 14:42:15',NULL),(2875,NULL,40719,29,2,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',654.00,NULL,NULL,1,'2022-12-31 14:42:16','2022-12-31 14:42:16',NULL);
INSERT INTO `balance_libro` VALUES (2876,NULL,40719,29,2,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',741.00,NULL,NULL,1,'2022-12-31 14:42:16','2022-12-31 14:42:16',NULL),(2877,NULL,40719,29,2,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',789.00,NULL,NULL,1,'2022-12-31 14:42:17','2022-12-31 14:42:17',NULL),(2878,NULL,40719,29,2,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',963.00,NULL,NULL,1,'2022-12-31 14:42:18','2022-12-31 14:42:18',NULL),(2879,NULL,40719,29,2,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:42:19','2022-12-31 14:42:19',NULL),(2880,NULL,40719,29,2,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',641.00,NULL,NULL,1,'2022-12-31 14:42:20','2022-12-31 14:42:20',NULL),(2881,NULL,40719,29,2,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',632.00,NULL,NULL,1,'2022-12-31 14:42:21','2022-12-31 14:42:21',NULL),(2882,NULL,40719,29,2,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',800.00,NULL,NULL,1,'2022-12-31 14:42:22','2022-12-31 14:42:22',NULL),(2883,NULL,40719,29,2,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',410.00,NULL,NULL,1,'2022-12-31 14:42:23','2022-12-31 14:42:23',NULL),(2884,NULL,40719,29,2,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',300.00,NULL,NULL,1,'2022-12-31 14:42:24','2022-12-31 14:42:24',NULL),(2885,NULL,40719,29,2,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',300.00,NULL,NULL,1,'2022-12-31 14:42:25','2022-12-31 14:42:25',NULL),(2886,NULL,40719,29,2,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',310.00,NULL,NULL,1,'2022-12-31 14:42:26','2022-12-31 14:42:26',NULL),(2887,NULL,40719,29,2,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',441.00,NULL,NULL,1,'2022-12-31 14:42:26','2022-12-31 14:42:26',NULL),(2888,NULL,40719,29,2,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:42:27','2022-12-31 14:42:27',NULL),(2889,NULL,40719,29,2,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:42:28','2022-12-31 14:42:28',NULL),(2890,NULL,40719,29,2,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',663.00,NULL,NULL,1,'2022-12-31 14:42:29','2022-12-31 14:42:29',NULL),(2891,NULL,40719,29,2,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',663.00,NULL,NULL,1,'2022-12-31 14:42:30','2022-12-31 14:42:30',NULL),(2892,NULL,40719,29,2,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:42:31','2022-12-31 14:42:31',NULL),(2893,NULL,40719,29,2,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',441.00,NULL,NULL,1,'2022-12-31 14:42:32','2022-12-31 14:42:32',NULL),(2894,NULL,40719,29,2,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',885.00,NULL,NULL,1,'2022-12-31 14:42:33','2022-12-31 14:42:33',NULL),(2895,NULL,40719,29,2,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',996.00,NULL,NULL,1,'2022-12-31 14:42:34','2022-12-31 14:42:34',NULL),(2896,NULL,40719,29,2,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',774.00,NULL,NULL,1,'2022-12-31 14:42:35','2022-12-31 14:42:35',NULL);
INSERT INTO `balance_libro` VALUES (2897,NULL,40719,29,2,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:42:35','2022-12-31 14:42:35',NULL),(2898,NULL,40719,29,2,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2022-12-31 14:42:36','2022-12-31 14:42:36',NULL),(2899,NULL,40719,29,2,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:42:37','2022-12-31 14:42:37',NULL),(2900,NULL,40719,29,2,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:42:38','2022-12-31 14:42:38',NULL),(2901,NULL,40719,29,2,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:42:39','2022-12-31 14:42:39',NULL),(2902,NULL,40719,29,2,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2022-12-31 14:42:40','2022-12-31 14:42:40',NULL),(2903,NULL,40719,29,2,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',800.00,NULL,NULL,1,'2022-12-31 14:42:41','2022-12-31 14:42:41',NULL),(2904,NULL,40719,29,2,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:42:42','2022-12-31 14:42:42',NULL),(2905,NULL,40719,29,2,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:42:43','2022-12-31 14:42:43',NULL),(2906,NULL,40719,29,2,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',200.00,NULL,NULL,1,'2022-12-31 14:42:44','2022-12-31 14:42:44',NULL),(2907,NULL,40719,29,2,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',300.00,NULL,NULL,1,'2022-12-31 14:42:45','2022-12-31 14:42:45',NULL),(2908,NULL,40719,29,2,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:42:45','2022-12-31 14:42:45',NULL),(2909,NULL,40719,29,2,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',420.00,NULL,NULL,1,'2022-12-31 14:42:46','2022-12-31 14:42:46',NULL),(2910,NULL,40719,29,2,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',430.00,NULL,NULL,1,'2022-12-31 14:42:47','2022-12-31 14:42:47',NULL),(2911,NULL,40719,29,2,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',452.00,NULL,NULL,1,'2022-12-31 14:42:48','2022-12-31 14:42:48',NULL),(2912,NULL,40719,29,2,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',560.00,NULL,NULL,1,'2022-12-31 14:42:49','2022-12-31 14:42:49',NULL),(2913,NULL,40719,29,2,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',541.00,NULL,NULL,1,'2022-12-31 14:42:50','2022-12-31 14:42:50',NULL),(2914,NULL,40719,29,2,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',631.00,NULL,NULL,1,'2022-12-31 14:42:51','2022-12-31 14:42:51',NULL),(2915,NULL,40719,29,2,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',412.00,NULL,NULL,1,'2022-12-31 14:42:52','2022-12-31 14:42:52',NULL),(2916,NULL,40719,29,2,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',520.00,NULL,NULL,1,'2022-12-31 14:42:53','2022-12-31 14:42:53',NULL),(2917,NULL,40719,29,2,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',321.00,NULL,NULL,1,'2022-12-31 14:42:54','2022-12-31 14:42:54',NULL);
INSERT INTO `balance_libro` VALUES (2918,NULL,40719,29,2,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',321.00,NULL,NULL,1,'2022-12-31 14:42:54','2022-12-31 14:42:54',NULL),(2919,NULL,40719,29,2,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',789.00,NULL,NULL,1,'2022-12-31 14:42:55','2022-12-31 14:42:55',NULL),(2920,NULL,40719,29,2,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',321.00,NULL,NULL,1,'2022-12-31 14:42:56','2022-12-31 14:42:56',NULL),(2921,NULL,40719,29,2,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',410.00,NULL,NULL,1,'2022-12-31 14:42:57','2022-12-31 14:42:57',NULL),(2922,NULL,40719,29,2,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',630.00,NULL,NULL,1,'2022-12-31 14:42:58','2022-12-31 14:42:58',NULL),(2923,NULL,40719,29,2,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',467.00,NULL,NULL,1,'2022-12-31 14:42:59','2022-12-31 14:42:59',NULL),(2924,NULL,40719,29,2,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',417.00,NULL,NULL,1,'2022-12-31 14:43:00','2022-12-31 14:43:00',NULL),(2925,NULL,40719,29,2,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',419.00,NULL,NULL,1,'2022-12-31 14:43:01','2022-12-31 14:43:01',NULL),(2926,NULL,40719,29,2,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',418.00,NULL,NULL,1,'2022-12-31 14:43:02','2022-12-31 14:43:02',NULL),(2927,NULL,40719,29,2,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',417.00,NULL,NULL,1,'2022-12-31 14:43:03','2022-12-31 14:43:03',NULL),(2928,NULL,40719,29,2,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',413.00,NULL,NULL,1,'2022-12-31 14:43:04','2022-12-31 14:43:04',NULL),(2929,NULL,40719,29,2,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',415.00,NULL,NULL,1,'2022-12-31 14:43:05','2022-12-31 14:43:05',NULL),(2930,NULL,40719,29,2,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',416.00,NULL,NULL,1,'2022-12-31 14:43:06','2022-12-31 14:43:06',NULL),(2931,NULL,40719,29,2,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',418.00,NULL,NULL,1,'2022-12-31 14:43:06','2022-12-31 14:43:06',NULL),(2932,NULL,40719,29,2,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',436.00,NULL,NULL,1,'2022-12-31 14:43:07','2022-12-31 14:43:07',NULL),(2933,NULL,40719,29,2,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',481.00,NULL,NULL,1,'2022-12-31 14:43:08','2022-12-31 14:43:08',NULL),(2934,NULL,40719,29,2,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',461.00,NULL,NULL,1,'2022-12-31 14:43:09','2022-12-31 14:43:09',NULL),(2935,NULL,40719,29,2,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',432.00,NULL,NULL,1,'2022-12-31 14:43:10','2022-12-31 14:43:10',NULL),(2936,NULL,40719,29,2,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',411.00,NULL,NULL,1,'2022-12-31 14:43:11','2022-12-31 14:43:11',NULL),(2937,NULL,40719,29,2,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',410.00,NULL,NULL,1,'2022-12-31 14:43:12','2022-12-31 14:43:12',NULL),(2938,NULL,40719,29,2,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:43:13','2022-12-31 14:43:13',NULL);
INSERT INTO `balance_libro` VALUES (2939,NULL,40719,29,2,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:43:14','2022-12-31 14:43:14',NULL),(2940,NULL,40719,29,2,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:43:14','2022-12-31 14:43:14',NULL),(2941,NULL,40719,29,2,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',450.00,NULL,NULL,1,'2022-12-31 14:43:15','2022-12-31 14:43:15',NULL),(2942,NULL,40719,29,2,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',460.00,NULL,NULL,1,'2022-12-31 14:43:16','2022-12-31 14:43:16',NULL),(2943,NULL,40719,29,2,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',470.00,NULL,NULL,1,'2022-12-31 14:43:17','2022-12-31 14:43:17',NULL),(2944,NULL,40719,29,2,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',480.00,NULL,NULL,1,'2022-12-31 14:43:18','2022-12-31 14:43:18',NULL),(2945,NULL,40719,29,2,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',490.00,NULL,NULL,1,'2022-12-31 14:43:19','2022-12-31 14:43:19',NULL),(2946,NULL,40719,29,2,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',410.00,NULL,NULL,1,'2022-12-31 14:43:20','2022-12-31 14:43:20',NULL),(2947,NULL,40719,29,2,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',420.00,NULL,NULL,1,'2022-12-31 14:43:21','2022-12-31 14:43:21',NULL),(2948,NULL,40719,29,2,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',430.00,NULL,NULL,1,'2022-12-31 14:43:22','2022-12-31 14:43:22',NULL),(2949,NULL,40719,29,2,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',450.00,NULL,NULL,1,'2022-12-31 14:43:23','2022-12-31 14:43:23',NULL),(2950,NULL,40719,29,2,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',460.00,NULL,NULL,1,'2022-12-31 14:43:24','2022-12-31 14:43:24',NULL),(2951,NULL,40719,29,2,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',490.00,NULL,NULL,1,'2022-12-31 14:43:24','2022-12-31 14:43:24',NULL),(2952,NULL,40719,29,2,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',380.00,NULL,NULL,1,'2022-12-31 14:43:25','2022-12-31 14:43:25',NULL),(2953,NULL,40719,29,2,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',390.00,NULL,NULL,1,'2022-12-31 14:43:26','2022-12-31 14:43:26',NULL),(2954,NULL,40719,29,2,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',380.00,NULL,NULL,1,'2022-12-31 14:43:27','2022-12-31 14:43:27',NULL),(2955,NULL,40719,29,2,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',387.00,NULL,NULL,1,'2022-12-31 14:43:28','2022-12-31 14:43:28',NULL),(2956,NULL,40719,29,2,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',311.00,NULL,NULL,1,'2022-12-31 14:43:29','2022-12-31 14:43:29',NULL),(2957,NULL,40719,29,2,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',411.00,NULL,NULL,1,'2022-12-31 14:43:30','2022-12-31 14:43:30',NULL),(2958,NULL,40719,29,2,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',390.00,NULL,NULL,1,'2022-12-31 14:43:31','2022-12-31 14:43:31',NULL),(2959,NULL,40719,29,2,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',387.00,NULL,NULL,1,'2022-12-31 14:43:32','2022-12-31 14:43:32',NULL);
INSERT INTO `balance_libro` VALUES (2960,NULL,40719,29,2,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',398.00,NULL,NULL,1,'2022-12-31 14:43:33','2022-12-31 14:43:33',NULL),(2961,NULL,40719,29,2,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',364.00,NULL,NULL,1,'2022-12-31 14:43:33','2022-12-31 14:43:33',NULL),(2962,NULL,40719,29,2,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',378.00,NULL,NULL,1,'2022-12-31 14:43:34','2022-12-31 14:43:34',NULL),(2963,NULL,40719,29,2,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:43:35','2022-12-31 14:43:35',NULL),(2964,NULL,40719,29,2,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',422.00,NULL,NULL,1,'2022-12-31 14:43:36','2022-12-31 14:43:36',NULL),(2965,NULL,40719,29,2,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',433.00,NULL,NULL,1,'2022-12-31 14:43:37','2022-12-31 14:43:37',NULL),(2966,NULL,40719,29,2,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',444.00,NULL,NULL,1,'2022-12-31 14:43:38','2022-12-31 14:43:38',NULL),(2967,NULL,40719,29,2,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',466.00,NULL,NULL,1,'2022-12-31 14:43:39','2022-12-31 14:43:39',NULL),(2968,NULL,40719,29,2,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',451.00,NULL,NULL,1,'2022-12-31 14:43:40','2022-12-31 14:43:40',NULL),(2969,NULL,40719,29,2,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:43:41','2022-12-31 14:43:41',NULL),(2970,NULL,40719,29,2,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',465.00,NULL,NULL,1,'2022-12-31 14:43:42','2022-12-31 14:43:42',NULL),(2971,NULL,40719,29,2,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',451.00,NULL,NULL,1,'2022-12-31 14:43:43','2022-12-31 14:43:43',NULL),(2972,NULL,40719,29,2,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',467.00,NULL,NULL,1,'2022-12-31 14:43:43','2022-12-31 14:43:43',NULL),(2973,NULL,40719,29,2,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',417.00,NULL,NULL,1,'2022-12-31 14:43:44','2022-12-31 14:43:44',NULL),(2974,NULL,40719,29,2,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',419.00,NULL,NULL,1,'2022-12-31 14:43:45','2022-12-31 14:43:45',NULL),(2975,NULL,40719,29,2,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',418.00,NULL,NULL,1,'2022-12-31 14:43:46','2022-12-31 14:43:46',NULL),(2976,NULL,40719,29,2,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',417.00,NULL,NULL,1,'2022-12-31 14:43:47','2022-12-31 14:43:47',NULL),(2977,NULL,40719,29,2,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',413.00,NULL,NULL,1,'2022-12-31 14:43:48','2022-12-31 14:43:48',NULL),(2978,NULL,40719,29,2,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',415.00,NULL,NULL,1,'2022-12-31 14:43:49','2022-12-31 14:43:49',NULL),(2979,NULL,40719,29,2,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',416.00,NULL,NULL,1,'2022-12-31 14:43:50','2022-12-31 14:43:50',NULL),(2980,NULL,40719,29,2,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',418.00,NULL,NULL,1,'2022-12-31 14:43:51','2022-12-31 14:43:51',NULL);
INSERT INTO `balance_libro` VALUES (2981,NULL,40719,29,2,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',436.00,NULL,NULL,1,'2022-12-31 14:43:52','2022-12-31 14:43:52',NULL),(2982,NULL,40719,29,2,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',481.00,NULL,NULL,1,'2022-12-31 14:43:53','2022-12-31 14:43:53',NULL),(2983,NULL,40719,29,2,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',461.00,NULL,NULL,1,'2022-12-31 14:43:53','2022-12-31 14:43:53',NULL),(2984,NULL,40719,29,2,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',432.00,NULL,NULL,1,'2022-12-31 14:43:54','2022-12-31 14:43:54',NULL),(2985,NULL,40719,29,2,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',411.00,NULL,NULL,1,'2022-12-31 14:43:55','2022-12-31 14:43:55',NULL),(2986,NULL,40719,29,2,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',410.00,NULL,NULL,1,'2022-12-31 14:43:56','2022-12-31 14:43:56',NULL),(2987,NULL,40719,29,2,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:43:57','2022-12-31 14:43:57',NULL),(2988,NULL,40719,29,2,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:43:58','2022-12-31 14:43:58',NULL),(2989,NULL,40719,29,2,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:43:59','2022-12-31 14:43:59',NULL),(2990,NULL,40719,29,2,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',450.00,NULL,NULL,1,'2022-12-31 14:44:00','2022-12-31 14:44:00',NULL),(2991,NULL,40719,29,2,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',460.00,NULL,NULL,1,'2022-12-31 14:44:01','2022-12-31 14:44:01',NULL),(2992,NULL,40719,29,2,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',470.00,NULL,NULL,1,'2022-12-31 14:44:02','2022-12-31 14:44:02',NULL),(2993,NULL,40719,29,2,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',480.00,NULL,NULL,1,'2022-12-31 14:44:03','2022-12-31 14:44:03',NULL),(2994,NULL,40719,29,2,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',490.00,NULL,NULL,1,'2022-12-31 14:44:03','2022-12-31 14:44:03',NULL),(2995,NULL,40719,29,2,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',410.00,NULL,NULL,1,'2022-12-31 14:44:04','2022-12-31 14:44:04',NULL),(2996,NULL,40719,29,2,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',420.00,NULL,NULL,1,'2022-12-31 14:44:05','2022-12-31 14:44:05',NULL),(2997,NULL,40719,29,2,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',430.00,NULL,NULL,1,'2022-12-31 14:44:06','2022-12-31 14:44:06',NULL),(2998,NULL,40719,29,2,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',450.00,NULL,NULL,1,'2022-12-31 14:44:07','2022-12-31 14:44:07',NULL),(2999,NULL,40719,29,2,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',460.00,NULL,NULL,1,'2022-12-31 14:44:08','2022-12-31 14:44:08',NULL),(3000,NULL,40719,29,2,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',490.00,NULL,NULL,1,'2022-12-31 14:44:09','2022-12-31 14:44:09',NULL),(3001,NULL,40719,29,2,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',380.00,NULL,NULL,1,'2022-12-31 14:44:10','2022-12-31 14:44:10',NULL);
INSERT INTO `balance_libro` VALUES (3002,NULL,40719,29,2,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',390.00,NULL,NULL,1,'2022-12-31 14:44:11','2022-12-31 14:44:11',NULL),(3003,NULL,40719,29,2,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',380.00,NULL,NULL,1,'2022-12-31 14:44:12','2022-12-31 14:44:12',NULL),(3004,NULL,40719,29,2,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',387.00,NULL,NULL,1,'2022-12-31 14:44:13','2022-12-31 14:44:13',NULL),(3005,NULL,40719,29,2,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',311.00,NULL,NULL,1,'2022-12-31 14:44:14','2022-12-31 14:44:14',NULL),(3006,NULL,40719,29,2,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',411.00,NULL,NULL,1,'2022-12-31 14:44:14','2022-12-31 14:44:14',NULL),(3007,NULL,40719,29,2,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',390.00,NULL,NULL,1,'2022-12-31 14:44:15','2022-12-31 14:44:15',NULL),(3008,NULL,40719,29,2,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',387.00,NULL,NULL,1,'2022-12-31 14:44:16','2022-12-31 14:44:16',NULL),(3009,NULL,40719,29,2,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',398.00,NULL,NULL,1,'2022-12-31 14:44:17','2022-12-31 14:44:17',NULL),(3010,NULL,40719,29,2,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',364.00,NULL,NULL,1,'2022-12-31 14:44:18','2022-12-31 14:44:18',NULL),(3011,NULL,40719,29,2,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',378.00,NULL,NULL,1,'2022-12-31 14:44:19','2022-12-31 14:44:19',NULL),(3012,NULL,40719,29,2,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:44:20','2022-12-31 14:44:20',NULL),(3013,NULL,40719,29,2,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',422.00,NULL,NULL,1,'2022-12-31 14:44:21','2022-12-31 14:44:21',NULL),(3014,NULL,40719,29,2,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',433.00,NULL,NULL,1,'2022-12-31 14:44:22','2022-12-31 14:44:22',NULL),(3015,NULL,40719,29,2,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',444.00,NULL,NULL,1,'2022-12-31 14:44:23','2022-12-31 14:44:23',NULL),(3016,NULL,40719,29,2,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',466.00,NULL,NULL,1,'2022-12-31 14:44:24','2022-12-31 14:44:24',NULL),(3017,NULL,40719,29,2,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',451.00,NULL,NULL,1,'2022-12-31 14:44:24','2022-12-31 14:44:24',NULL),(3018,NULL,40719,29,2,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:44:25','2022-12-31 14:44:25',NULL),(3019,NULL,40719,29,2,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',465.00,NULL,NULL,1,'2022-12-31 14:44:26','2022-12-31 14:44:26',NULL),(3020,NULL,40719,29,2,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',451.00,NULL,NULL,1,'2022-12-31 14:44:27','2022-12-31 14:44:27',NULL),(3021,NULL,40719,29,2,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',300.00,NULL,NULL,1,'2022-12-31 14:44:28','2022-12-31 14:44:28',NULL),(3022,NULL,40719,29,2,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',300.00,NULL,NULL,1,'2022-12-31 14:44:29','2022-12-31 14:44:29',NULL);
INSERT INTO `balance_libro` VALUES (3023,NULL,40719,29,2,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',310.00,NULL,NULL,1,'2022-12-31 14:44:30','2022-12-31 14:44:30',NULL),(3024,NULL,40719,29,2,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',441.00,NULL,NULL,1,'2022-12-31 14:44:31','2022-12-31 14:44:31',NULL),(3025,NULL,40719,29,2,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:44:32','2022-12-31 14:44:32',NULL),(3026,NULL,40719,29,2,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:44:33','2022-12-31 14:44:33',NULL),(3027,NULL,40719,29,2,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',663.00,NULL,NULL,1,'2022-12-31 14:44:33','2022-12-31 14:44:33',NULL),(3028,NULL,40719,29,2,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',663.00,NULL,NULL,1,'2022-12-31 14:44:34','2022-12-31 14:44:34',NULL),(3029,NULL,40719,29,2,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:44:35','2022-12-31 14:44:35',NULL),(3030,NULL,40719,29,2,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',441.00,NULL,NULL,1,'2022-12-31 14:44:36','2022-12-31 14:44:36',NULL),(3031,NULL,40719,29,2,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',885.00,NULL,NULL,1,'2022-12-31 14:44:37','2022-12-31 14:44:37',NULL),(3032,NULL,40719,29,2,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',996.00,NULL,NULL,1,'2022-12-31 14:44:38','2022-12-31 14:44:38',NULL),(3033,NULL,40719,29,2,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',774.00,NULL,NULL,1,'2022-12-31 14:44:39','2022-12-31 14:44:39',NULL),(3034,NULL,40719,29,2,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:44:40','2022-12-31 14:44:40',NULL),(3035,NULL,40719,29,2,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2022-12-31 14:44:41','2022-12-31 14:44:41',NULL),(3036,NULL,40719,29,2,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:44:41','2022-12-31 14:44:41',NULL),(3037,NULL,40719,29,2,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:44:42','2022-12-31 14:44:42',NULL),(3038,NULL,40719,29,2,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:44:43','2022-12-31 14:44:43',NULL),(3039,NULL,40719,29,2,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2022-12-31 14:44:44','2022-12-31 14:44:44',NULL),(3040,NULL,40719,29,2,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',800.00,NULL,NULL,1,'2022-12-31 14:44:45','2022-12-31 14:44:45',NULL),(3041,NULL,40719,29,2,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:44:46','2022-12-31 14:44:46',NULL),(3042,NULL,40719,29,2,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2022-12-31 14:44:47','2022-12-31 14:44:47',NULL),(3043,NULL,40719,29,2,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',800.00,NULL,NULL,1,'2022-12-31 14:44:48','2022-12-31 14:44:48',NULL);
INSERT INTO `balance_libro` VALUES (3044,NULL,40719,29,2,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:44:49','2022-12-31 14:44:49',NULL),(3045,NULL,40719,29,2,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:44:50','2022-12-31 14:44:50',NULL),(3046,NULL,40719,29,2,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',580.00,NULL,NULL,1,'2022-12-31 14:44:51','2022-12-31 14:44:51',NULL),(3047,NULL,40719,29,2,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',900.00,NULL,NULL,1,'2022-12-31 14:44:52','2022-12-31 14:44:52',NULL),(3048,NULL,40719,29,2,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',450.00,NULL,NULL,1,'2022-12-31 14:44:53','2022-12-31 14:44:53',NULL),(3049,NULL,40719,29,2,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',654.00,NULL,NULL,1,'2022-12-31 14:44:53','2022-12-31 14:44:53',NULL),(3050,NULL,40719,29,2,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',450.00,NULL,NULL,1,'2022-12-31 14:44:54','2022-12-31 14:44:54',NULL),(3051,NULL,40719,29,2,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',978.00,NULL,NULL,1,'2022-12-31 14:44:55','2022-12-31 14:44:55',NULL),(3052,NULL,40719,29,2,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',789.00,NULL,NULL,1,'2022-12-31 14:44:56','2022-12-31 14:44:56',NULL),(3053,NULL,40719,29,2,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:44:57','2022-12-31 14:44:57',NULL),(3054,NULL,40719,29,2,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',540.00,NULL,NULL,1,'2022-12-31 14:44:58','2022-12-31 14:44:58',NULL),(3055,NULL,40719,29,2,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',620.00,NULL,NULL,1,'2022-12-31 14:44:59','2022-12-31 14:44:59',NULL),(3056,NULL,40719,29,2,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',740.00,NULL,NULL,1,'2022-12-31 14:45:00','2022-12-31 14:45:00',NULL),(3057,NULL,40719,29,2,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',654.00,NULL,NULL,1,'2022-12-31 14:45:01','2022-12-31 14:45:01',NULL),(3058,NULL,40719,29,2,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',741.00,NULL,NULL,1,'2022-12-31 14:45:02','2022-12-31 14:45:02',NULL),(3059,NULL,40719,29,2,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',789.00,NULL,NULL,1,'2022-12-31 14:45:03','2022-12-31 14:45:03',NULL),(3060,NULL,40719,29,2,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',963.00,NULL,NULL,1,'2022-12-31 14:45:04','2022-12-31 14:45:04',NULL),(3061,NULL,40719,29,2,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',552.00,NULL,NULL,1,'2022-12-31 14:45:04','2022-12-31 14:45:04',NULL),(3062,NULL,40719,29,2,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',641.00,NULL,NULL,1,'2022-12-31 14:45:05','2022-12-31 14:45:05',NULL),(3063,NULL,40719,29,2,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',632.00,NULL,NULL,1,'2022-12-31 14:45:06','2022-12-31 14:45:06',NULL),(3064,NULL,40719,29,2,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',800.00,NULL,NULL,1,'2022-12-31 14:45:07','2022-12-31 14:45:07',NULL);
INSERT INTO `balance_libro` VALUES (3065,NULL,40719,29,2,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',410.00,NULL,NULL,1,'2022-12-31 14:45:08','2022-12-31 14:45:08',NULL),(3066,NULL,40719,29,2,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',370.00,NULL,NULL,1,'2022-12-31 14:45:09','2022-12-31 14:45:09',NULL),(3067,NULL,40719,29,2,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',380.00,NULL,NULL,1,'2022-12-31 14:45:10','2022-12-31 14:45:10',NULL),(3068,NULL,40719,29,2,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',391.00,NULL,NULL,1,'2022-12-31 14:45:11','2022-12-31 14:45:11',NULL),(3069,NULL,40719,29,2,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',381.00,NULL,NULL,1,'2022-12-31 14:45:12','2022-12-31 14:45:12',NULL),(3070,NULL,40719,29,2,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',387.00,NULL,NULL,1,'2022-12-31 14:45:13','2022-12-31 14:45:13',NULL),(3071,NULL,40719,29,2,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',314.00,NULL,NULL,1,'2022-12-31 14:45:14','2022-12-31 14:45:14',NULL),(3072,NULL,40719,29,2,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:45:14','2022-12-31 14:45:14',NULL),(3073,NULL,40719,29,2,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',300.00,NULL,NULL,1,'2022-12-31 14:45:15','2022-12-31 14:45:15',NULL),(3074,NULL,40719,29,2,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',644.00,NULL,NULL,1,'2022-12-31 14:45:16','2022-12-31 14:45:16',NULL),(3075,NULL,40719,29,2,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',611.00,NULL,NULL,1,'2022-12-31 14:45:17','2022-12-31 14:45:17',NULL),(3076,NULL,40719,29,2,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:45:18','2022-12-31 14:45:18',NULL),(3077,NULL,40719,29,2,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:45:19','2022-12-31 14:45:19',NULL),(3078,NULL,40719,29,2,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',610.00,NULL,NULL,1,'2022-12-31 14:45:20','2022-12-31 14:45:20',NULL),(3079,NULL,40719,29,2,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',177.00,NULL,NULL,1,'2022-12-31 14:45:21','2022-12-31 14:45:21',NULL),(3080,NULL,40719,29,2,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',988.00,NULL,NULL,1,'2022-12-31 14:45:22','2022-12-31 14:45:22',NULL),(3081,NULL,40719,29,2,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',641.00,NULL,NULL,1,'2022-12-31 14:45:23','2022-12-31 14:45:23',NULL),(3082,NULL,40719,29,2,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:45:24','2022-12-31 14:45:24',NULL),(3083,NULL,40719,29,2,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:45:25','2022-12-31 14:45:25',NULL),(3084,NULL,40719,29,2,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2022-12-31 14:45:26','2022-12-31 14:45:26',NULL),(3085,NULL,40719,29,2,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:45:26','2022-12-31 14:45:26',NULL);
INSERT INTO `balance_libro` VALUES (3086,NULL,40719,29,2,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:45:27','2022-12-31 14:45:27',NULL),(3087,NULL,40719,29,2,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:45:28','2022-12-31 14:45:28',NULL),(3088,NULL,40719,29,2,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:45:29','2022-12-31 14:45:29',NULL),(3089,NULL,40719,29,2,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',400.00,NULL,NULL,1,'2022-12-31 14:45:30','2022-12-31 14:45:30',NULL),(3090,NULL,40719,29,2,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',540.00,NULL,NULL,1,'2022-12-31 14:45:31','2022-12-31 14:45:31',NULL),(3091,NULL,40719,29,2,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',620.00,NULL,NULL,1,'2022-12-31 14:45:32','2022-12-31 14:45:32',NULL),(3092,NULL,40719,29,2,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',740.00,NULL,NULL,1,'2022-12-31 14:45:33','2022-12-31 14:45:33',NULL),(3093,NULL,40719,29,2,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',654.00,NULL,NULL,1,'2022-12-31 14:45:34','2022-12-31 14:45:34',NULL),(3094,NULL,40719,29,2,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',741.00,NULL,NULL,1,'2022-12-31 14:45:35','2022-12-31 14:45:35',NULL),(3095,NULL,40719,29,2,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',789.00,NULL,NULL,1,'2022-12-31 14:45:35','2022-12-31 14:45:35',NULL),(3096,NULL,40719,34,2,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:47:27','2023-02-28 15:47:27',NULL),(3097,NULL,40719,34,2,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',540.00,NULL,NULL,1,'2023-02-28 15:47:29','2023-02-28 15:47:29',NULL),(3098,NULL,40719,34,2,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',620.00,NULL,NULL,1,'2023-02-28 15:47:30','2023-02-28 15:47:30',NULL),(3099,NULL,40719,34,2,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',740.00,NULL,NULL,1,'2023-02-28 15:47:31','2023-02-28 15:47:31',NULL),(3100,NULL,40719,34,2,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',654.00,NULL,NULL,1,'2023-02-28 15:47:33','2023-02-28 15:47:33',NULL),(3101,NULL,40719,34,2,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',741.00,NULL,NULL,1,'2023-02-28 15:47:34','2023-02-28 15:47:34',NULL),(3102,NULL,40719,34,2,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',789.00,NULL,NULL,1,'2023-02-28 15:47:36','2023-02-28 15:47:36',NULL),(3103,NULL,40719,34,2,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',963.00,NULL,NULL,1,'2023-02-28 15:47:37','2023-02-28 15:47:37',NULL),(3104,NULL,40719,34,2,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:47:39','2023-02-28 15:47:39',NULL),(3105,NULL,40719,34,2,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',641.00,NULL,NULL,1,'2023-02-28 15:47:40','2023-02-28 15:47:40',NULL),(3106,NULL,40719,34,2,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',632.00,NULL,NULL,1,'2023-02-28 15:47:42','2023-02-28 15:47:42',NULL);
INSERT INTO `balance_libro` VALUES (3107,NULL,40719,34,2,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',800.00,NULL,NULL,1,'2023-02-28 15:47:43','2023-02-28 15:47:43',NULL),(3108,NULL,40719,34,2,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',410.00,NULL,NULL,1,'2023-02-28 15:47:45','2023-02-28 15:47:45',NULL),(3109,NULL,40719,34,2,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',300.00,NULL,NULL,1,'2023-02-28 15:47:47','2023-02-28 15:47:47',NULL),(3110,NULL,40719,34,2,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',300.00,NULL,NULL,1,'2023-02-28 15:47:48','2023-02-28 15:47:48',NULL),(3111,NULL,40719,34,2,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',310.00,NULL,NULL,1,'2023-02-28 15:47:50','2023-02-28 15:47:50',NULL),(3112,NULL,40719,34,2,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',441.00,NULL,NULL,1,'2023-02-28 15:47:51','2023-02-28 15:47:51',NULL),(3113,NULL,40719,34,2,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:47:53','2023-02-28 15:47:53',NULL),(3114,NULL,40719,34,2,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:47:54','2023-02-28 15:47:54',NULL),(3115,NULL,40719,34,2,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',663.00,NULL,NULL,1,'2023-02-28 15:47:55','2023-02-28 15:47:55',NULL),(3116,NULL,40719,34,2,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',663.00,NULL,NULL,1,'2023-02-28 15:47:57','2023-02-28 15:47:57',NULL),(3117,NULL,40719,34,2,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:47:58','2023-02-28 15:47:58',NULL),(3118,NULL,40719,34,2,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',441.00,NULL,NULL,1,'2023-02-28 15:48:00','2023-02-28 15:48:00',NULL),(3119,NULL,40719,34,2,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',885.00,NULL,NULL,1,'2023-02-28 15:48:01','2023-02-28 15:48:01',NULL),(3120,NULL,40719,34,2,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',996.00,NULL,NULL,1,'2023-02-28 15:48:03','2023-02-28 15:48:03',NULL),(3121,NULL,40719,34,2,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',774.00,NULL,NULL,1,'2023-02-28 15:48:04','2023-02-28 15:48:04',NULL),(3122,NULL,40719,34,2,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:48:06','2023-02-28 15:48:06',NULL),(3123,NULL,40719,34,2,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:48:07','2023-02-28 15:48:07',NULL),(3124,NULL,40719,34,2,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:48:09','2023-02-28 15:48:09',NULL),(3125,NULL,40719,34,2,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:48:11','2023-02-28 15:48:11',NULL),(3126,NULL,40719,34,2,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:48:13','2023-02-28 15:48:13',NULL),(3127,NULL,40719,34,2,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:48:15','2023-02-28 15:48:15',NULL);
INSERT INTO `balance_libro` VALUES (3128,NULL,40719,34,2,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',800.00,NULL,NULL,1,'2023-02-28 15:48:17','2023-02-28 15:48:17',NULL),(3129,NULL,40719,34,2,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:48:18','2023-02-28 15:48:18',NULL),(3130,NULL,40719,34,2,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:48:20','2023-02-28 15:48:20',NULL),(3131,NULL,40719,34,2,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',800.00,NULL,NULL,1,'2023-02-28 15:48:21','2023-02-28 15:48:21',NULL),(3132,NULL,40719,34,2,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:48:23','2023-02-28 15:48:23',NULL),(3133,NULL,40719,34,2,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:48:25','2023-02-28 15:48:25',NULL),(3134,NULL,40719,34,2,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',580.00,NULL,NULL,1,'2023-02-28 15:48:26','2023-02-28 15:48:26',NULL),(3135,NULL,40719,34,2,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:48:28','2023-02-28 15:48:28',NULL),(3136,NULL,40719,34,2,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-02-28 15:48:29','2023-02-28 15:48:29',NULL),(3137,NULL,40719,34,2,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',654.00,NULL,NULL,1,'2023-02-28 15:48:30','2023-02-28 15:48:30',NULL),(3138,NULL,40719,34,2,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-02-28 15:48:32','2023-02-28 15:48:32',NULL),(3139,NULL,40719,34,2,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',978.00,NULL,NULL,1,'2023-02-28 15:48:33','2023-02-28 15:48:33',NULL),(3140,NULL,40719,34,2,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',789.00,NULL,NULL,1,'2023-02-28 15:48:35','2023-02-28 15:48:35',NULL),(3141,NULL,40719,34,2,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',741.00,NULL,NULL,1,'2023-02-28 15:48:37','2023-02-28 15:48:37',NULL),(3142,NULL,40719,34,2,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',753.00,NULL,NULL,1,'2023-02-28 15:48:38','2023-02-28 15:48:38',NULL),(3143,NULL,40719,34,2,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',725.00,NULL,NULL,1,'2023-02-28 15:48:39','2023-02-28 15:48:39',NULL),(3144,NULL,40719,34,2,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',739.00,NULL,NULL,1,'2023-02-28 15:48:41','2023-02-28 15:48:41',NULL),(3145,NULL,40719,34,2,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',640.00,NULL,NULL,1,'2023-02-28 15:48:42','2023-02-28 15:48:42',NULL),(3146,NULL,40719,34,2,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',674.00,NULL,NULL,1,'2023-02-28 15:48:43','2023-02-28 15:48:43',NULL),(3147,NULL,40719,34,2,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',996.00,NULL,NULL,1,'2023-02-28 15:48:45','2023-02-28 15:48:45',NULL),(3148,NULL,40719,34,2,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',774.00,NULL,NULL,1,'2023-02-28 15:48:46','2023-02-28 15:48:46',NULL);
INSERT INTO `balance_libro` VALUES (3149,NULL,40719,34,2,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',664.00,NULL,NULL,1,'2023-02-28 15:48:47','2023-02-28 15:48:47',NULL),(3150,NULL,40719,34,2,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',954.00,NULL,NULL,1,'2023-02-28 15:48:49','2023-02-28 15:48:49',NULL),(3151,NULL,40719,34,2,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',855.00,NULL,NULL,1,'2023-02-28 15:48:50','2023-02-28 15:48:50',NULL),(3152,NULL,40719,34,2,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',755.00,NULL,NULL,1,'2023-02-28 15:48:52','2023-02-28 15:48:52',NULL),(3153,NULL,40719,34,2,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',766.00,NULL,NULL,1,'2023-02-28 15:48:53','2023-02-28 15:48:53',NULL),(3154,NULL,40719,34,2,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',744.00,NULL,NULL,1,'2023-02-28 15:48:55','2023-02-28 15:48:55',NULL),(3155,NULL,40719,34,2,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',799.00,NULL,NULL,1,'2023-02-28 15:48:56','2023-02-28 15:48:56',NULL),(3156,NULL,40719,34,2,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',711.00,NULL,NULL,1,'2023-02-28 15:48:57','2023-02-28 15:48:57',NULL),(3157,NULL,40719,34,2,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',611.00,NULL,NULL,1,'2023-02-28 15:48:59','2023-02-28 15:48:59',NULL),(3158,NULL,40719,34,2,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',644.00,NULL,NULL,1,'2023-02-28 15:49:00','2023-02-28 15:49:00',NULL),(3159,NULL,40719,34,2,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',655.00,NULL,NULL,1,'2023-02-28 15:49:01','2023-02-28 15:49:01',NULL),(3160,NULL,40719,34,2,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',633.00,NULL,NULL,1,'2023-02-28 15:49:03','2023-02-28 15:49:03',NULL),(3161,NULL,40719,34,2,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',620.00,NULL,NULL,1,'2023-02-28 15:49:04','2023-02-28 15:49:04',NULL),(3162,NULL,40719,34,2,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',644.00,NULL,NULL,1,'2023-02-28 15:49:05','2023-02-28 15:49:05',NULL),(3163,NULL,40719,34,2,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:49:07','2023-02-28 15:49:07',NULL),(3164,NULL,40719,34,2,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:49:08','2023-02-28 15:49:08',NULL),(3165,NULL,40719,34,2,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',751.00,NULL,NULL,1,'2023-02-28 15:49:10','2023-02-28 15:49:10',NULL),(3166,NULL,40719,34,2,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',680.00,NULL,NULL,1,'2023-02-28 15:49:11','2023-02-28 15:49:11',NULL),(3167,NULL,40719,34,2,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',680.00,NULL,NULL,1,'2023-02-28 15:49:13','2023-02-28 15:49:13',NULL),(3168,NULL,40719,34,2,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',680.00,NULL,NULL,1,'2023-02-28 15:49:14','2023-02-28 15:49:14',NULL),(3169,NULL,40719,34,2,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',680.00,NULL,NULL,1,'2023-02-28 15:49:16','2023-02-28 15:49:16',NULL);
INSERT INTO `balance_libro` VALUES (3170,NULL,40719,34,2,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',641.00,NULL,NULL,1,'2023-02-28 15:49:17','2023-02-28 15:49:17',NULL),(3171,NULL,40719,34,2,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',641.00,NULL,NULL,1,'2023-02-28 15:49:19','2023-02-28 15:49:19',NULL),(3172,NULL,40719,34,2,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',622.00,NULL,NULL,1,'2023-02-28 15:49:20','2023-02-28 15:49:20',NULL),(3173,NULL,40719,34,2,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',633.00,NULL,NULL,1,'2023-02-28 15:49:22','2023-02-28 15:49:22',NULL),(3174,NULL,40719,34,2,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',655.00,NULL,NULL,1,'2023-02-28 15:49:23','2023-02-28 15:49:23',NULL),(3175,NULL,40719,34,2,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',740.00,NULL,NULL,1,'2023-02-28 15:49:25','2023-02-28 15:49:25',NULL),(3176,NULL,40719,34,2,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',500.00,NULL,NULL,1,'2023-02-28 15:49:26','2023-02-28 15:49:26',NULL),(3177,NULL,40719,34,2,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',490.00,NULL,NULL,1,'2023-02-28 15:49:27','2023-02-28 15:49:27',NULL),(3178,NULL,40719,34,2,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',403.00,NULL,NULL,1,'2023-02-28 15:49:29','2023-02-28 15:49:29',NULL),(3179,NULL,40719,34,2,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',406.00,NULL,NULL,1,'2023-02-28 15:49:30','2023-02-28 15:49:30',NULL),(3180,NULL,40719,34,2,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',418.00,NULL,NULL,1,'2023-02-28 15:49:32','2023-02-28 15:49:32',NULL),(3181,NULL,40719,34,2,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',467.00,NULL,NULL,1,'2023-02-28 15:49:33','2023-02-28 15:49:33',NULL),(3182,NULL,40719,34,2,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',417.00,NULL,NULL,1,'2023-02-28 15:49:35','2023-02-28 15:49:35',NULL),(3183,NULL,40719,34,2,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',419.00,NULL,NULL,1,'2023-02-28 15:49:36','2023-02-28 15:49:36',NULL),(3184,NULL,40719,34,2,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',418.00,NULL,NULL,1,'2023-02-28 15:49:38','2023-02-28 15:49:38',NULL),(3185,NULL,40719,34,2,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',417.00,NULL,NULL,1,'2023-02-28 15:49:40','2023-02-28 15:49:40',NULL),(3186,NULL,40719,34,2,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',413.00,NULL,NULL,1,'2023-02-28 15:49:42','2023-02-28 15:49:42',NULL),(3187,NULL,40719,34,2,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',415.00,NULL,NULL,1,'2023-02-28 15:49:44','2023-02-28 15:49:44',NULL),(3188,NULL,40719,34,2,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',416.00,NULL,NULL,1,'2023-02-28 15:49:45','2023-02-28 15:49:45',NULL),(3189,NULL,40719,34,2,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',418.00,NULL,NULL,1,'2023-02-28 15:49:46','2023-02-28 15:49:46',NULL),(3190,NULL,40719,34,2,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',436.00,NULL,NULL,1,'2023-02-28 15:49:48','2023-02-28 15:49:48',NULL);
INSERT INTO `balance_libro` VALUES (3191,NULL,40719,34,2,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',481.00,NULL,NULL,1,'2023-02-28 15:49:49','2023-02-28 15:49:49',NULL),(3192,NULL,40719,34,2,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',461.00,NULL,NULL,1,'2023-02-28 15:49:50','2023-02-28 15:49:50',NULL),(3193,NULL,40719,34,2,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',432.00,NULL,NULL,1,'2023-02-28 15:49:52','2023-02-28 15:49:52',NULL),(3194,NULL,40719,34,2,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',411.00,NULL,NULL,1,'2023-02-28 15:49:53','2023-02-28 15:49:53',NULL),(3195,NULL,40719,34,2,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',410.00,NULL,NULL,1,'2023-02-28 15:49:55','2023-02-28 15:49:55',NULL),(3196,NULL,40719,34,2,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:49:56','2023-02-28 15:49:56',NULL),(3197,NULL,40719,34,2,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:49:57','2023-02-28 15:49:57',NULL),(3198,NULL,40719,34,2,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:49:58','2023-02-28 15:49:58',NULL),(3199,NULL,40719,34,2,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-02-28 15:50:00','2023-02-28 15:50:00',NULL),(3200,NULL,40719,34,2,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',460.00,NULL,NULL,1,'2023-02-28 15:50:01','2023-02-28 15:50:01',NULL),(3201,NULL,40719,34,2,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',470.00,NULL,NULL,1,'2023-02-28 15:50:03','2023-02-28 15:50:03',NULL),(3202,NULL,40719,34,2,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',480.00,NULL,NULL,1,'2023-02-28 15:50:04','2023-02-28 15:50:04',NULL),(3203,NULL,40719,34,2,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',490.00,NULL,NULL,1,'2023-02-28 15:50:06','2023-02-28 15:50:06',NULL),(3204,NULL,40719,34,2,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',410.00,NULL,NULL,1,'2023-02-28 15:50:07','2023-02-28 15:50:07',NULL),(3205,NULL,40719,34,2,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',420.00,NULL,NULL,1,'2023-02-28 15:50:08','2023-02-28 15:50:08',NULL),(3206,NULL,40719,34,2,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',430.00,NULL,NULL,1,'2023-02-28 15:50:10','2023-02-28 15:50:10',NULL),(3207,NULL,40719,34,2,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-02-28 15:50:11','2023-02-28 15:50:11',NULL),(3208,NULL,40719,34,2,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',460.00,NULL,NULL,1,'2023-02-28 15:50:13','2023-02-28 15:50:13',NULL),(3209,NULL,40719,34,2,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',490.00,NULL,NULL,1,'2023-02-28 15:50:14','2023-02-28 15:50:14',NULL),(3210,NULL,40719,34,2,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',380.00,NULL,NULL,1,'2023-02-28 15:50:15','2023-02-28 15:50:15',NULL),(3211,NULL,40719,34,2,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',390.00,NULL,NULL,1,'2023-02-28 15:50:17','2023-02-28 15:50:17',NULL);
INSERT INTO `balance_libro` VALUES (3212,NULL,40719,34,2,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',380.00,NULL,NULL,1,'2023-02-28 15:50:18','2023-02-28 15:50:18',NULL),(3213,NULL,40719,34,2,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',387.00,NULL,NULL,1,'2023-02-28 15:50:19','2023-02-28 15:50:19',NULL),(3214,NULL,40719,34,2,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',311.00,NULL,NULL,1,'2023-02-28 15:50:21','2023-02-28 15:50:21',NULL),(3215,NULL,40719,34,2,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',411.00,NULL,NULL,1,'2023-02-28 15:50:22','2023-02-28 15:50:22',NULL),(3216,NULL,40719,34,2,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',390.00,NULL,NULL,1,'2023-02-28 15:50:24','2023-02-28 15:50:24',NULL),(3217,NULL,40719,34,2,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',387.00,NULL,NULL,1,'2023-02-28 15:50:25','2023-02-28 15:50:25',NULL),(3218,NULL,40719,34,2,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',398.00,NULL,NULL,1,'2023-02-28 15:50:27','2023-02-28 15:50:27',NULL),(3219,NULL,40719,34,2,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',364.00,NULL,NULL,1,'2023-02-28 15:50:28','2023-02-28 15:50:28',NULL),(3220,NULL,40719,34,2,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',378.00,NULL,NULL,1,'2023-02-28 15:50:29','2023-02-28 15:50:29',NULL),(3221,NULL,40719,34,2,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:50:31','2023-02-28 15:50:31',NULL),(3222,NULL,40719,34,2,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',422.00,NULL,NULL,1,'2023-02-28 15:50:33','2023-02-28 15:50:33',NULL),(3223,NULL,40719,34,2,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',433.00,NULL,NULL,1,'2023-02-28 15:50:34','2023-02-28 15:50:34',NULL),(3224,NULL,40719,34,2,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',444.00,NULL,NULL,1,'2023-02-28 15:50:36','2023-02-28 15:50:36',NULL),(3225,NULL,40719,34,2,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',466.00,NULL,NULL,1,'2023-02-28 15:50:37','2023-02-28 15:50:37',NULL),(3226,NULL,40719,34,2,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',451.00,NULL,NULL,1,'2023-02-28 15:50:39','2023-02-28 15:50:39',NULL),(3227,NULL,40719,34,2,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:50:41','2023-02-28 15:50:41',NULL),(3228,NULL,40719,34,2,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',465.00,NULL,NULL,1,'2023-02-28 15:50:42','2023-02-28 15:50:42',NULL),(3229,NULL,40719,34,2,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',451.00,NULL,NULL,1,'2023-02-28 15:50:44','2023-02-28 15:50:44',NULL),(3230,NULL,40719,34,2,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',300.00,NULL,NULL,1,'2023-02-28 15:50:45','2023-02-28 15:50:45',NULL),(3231,NULL,40719,34,2,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',300.00,NULL,NULL,1,'2023-02-28 15:50:47','2023-02-28 15:50:47',NULL),(3232,NULL,40719,34,2,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',310.00,NULL,NULL,1,'2023-02-28 15:50:48','2023-02-28 15:50:48',NULL);
INSERT INTO `balance_libro` VALUES (3233,NULL,40719,34,2,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',441.00,NULL,NULL,1,'2023-02-28 15:50:50','2023-02-28 15:50:50',NULL),(3234,NULL,40719,34,2,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:50:51','2023-02-28 15:50:51',NULL),(3235,NULL,40719,34,2,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:50:53','2023-02-28 15:50:53',NULL),(3236,NULL,40719,34,2,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',663.00,NULL,NULL,1,'2023-02-28 15:50:54','2023-02-28 15:50:54',NULL),(3237,NULL,40719,34,2,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',663.00,NULL,NULL,1,'2023-02-28 15:50:56','2023-02-28 15:50:56',NULL),(3238,NULL,40719,34,2,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:50:57','2023-02-28 15:50:57',NULL),(3239,NULL,40719,34,2,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',441.00,NULL,NULL,1,'2023-02-28 15:50:58','2023-02-28 15:50:58',NULL),(3240,NULL,40719,34,2,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',885.00,NULL,NULL,1,'2023-02-28 15:51:00','2023-02-28 15:51:00',NULL),(3241,NULL,40719,34,2,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',996.00,NULL,NULL,1,'2023-02-28 15:51:01','2023-02-28 15:51:01',NULL),(3242,NULL,40719,34,2,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',774.00,NULL,NULL,1,'2023-02-28 15:51:03','2023-02-28 15:51:03',NULL),(3243,NULL,40719,34,2,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:51:05','2023-02-28 15:51:05',NULL),(3244,NULL,40719,34,2,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:51:07','2023-02-28 15:51:07',NULL),(3245,NULL,40719,34,2,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:51:09','2023-02-28 15:51:09',NULL),(3246,NULL,40719,34,2,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:51:10','2023-02-28 15:51:10',NULL),(3247,NULL,40719,34,2,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:51:12','2023-02-28 15:51:12',NULL),(3248,NULL,40719,34,2,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:51:13','2023-02-28 15:51:13',NULL),(3249,NULL,40719,34,2,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',800.00,NULL,NULL,1,'2023-02-28 15:51:14','2023-02-28 15:51:14',NULL),(3250,NULL,40719,34,2,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:51:16','2023-02-28 15:51:16',NULL),(3251,NULL,40719,34,2,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:51:17','2023-02-28 15:51:17',NULL),(3252,NULL,40719,34,2,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',800.00,NULL,NULL,1,'2023-02-28 15:51:19','2023-02-28 15:51:19',NULL),(3253,NULL,40719,34,2,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:51:20','2023-02-28 15:51:20',NULL);
INSERT INTO `balance_libro` VALUES (3254,NULL,40719,34,2,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:51:22','2023-02-28 15:51:22',NULL),(3255,NULL,40719,34,2,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',580.00,NULL,NULL,1,'2023-02-28 15:51:24','2023-02-28 15:51:24',NULL),(3256,NULL,40719,34,2,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:51:25','2023-02-28 15:51:25',NULL),(3257,NULL,40719,34,2,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-02-28 15:51:27','2023-02-28 15:51:27',NULL),(3258,NULL,40719,34,2,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',654.00,NULL,NULL,1,'2023-02-28 15:51:29','2023-02-28 15:51:29',NULL),(3259,NULL,40719,34,2,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-02-28 15:51:30','2023-02-28 15:51:30',NULL),(3260,NULL,40719,34,2,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',978.00,NULL,NULL,1,'2023-02-28 15:51:31','2023-02-28 15:51:31',NULL),(3261,NULL,40719,34,2,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',789.00,NULL,NULL,1,'2023-02-28 15:51:33','2023-02-28 15:51:33',NULL),(3262,NULL,40719,34,2,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:51:34','2023-02-28 15:51:34',NULL),(3263,NULL,40719,34,2,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',540.00,NULL,NULL,1,'2023-02-28 15:51:35','2023-02-28 15:51:35',NULL),(3264,NULL,40719,34,2,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',620.00,NULL,NULL,1,'2023-02-28 15:51:37','2023-02-28 15:51:37',NULL),(3265,NULL,40719,34,2,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',740.00,NULL,NULL,1,'2023-02-28 15:51:38','2023-02-28 15:51:38',NULL),(3266,NULL,40719,34,2,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',654.00,NULL,NULL,1,'2023-02-28 15:51:40','2023-02-28 15:51:40',NULL),(3267,NULL,40719,34,2,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',741.00,NULL,NULL,1,'2023-02-28 15:51:41','2023-02-28 15:51:41',NULL),(3268,NULL,40719,34,2,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',789.00,NULL,NULL,1,'2023-02-28 15:51:42','2023-02-28 15:51:42',NULL),(3269,NULL,40719,34,2,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',963.00,NULL,NULL,1,'2023-02-28 15:51:44','2023-02-28 15:51:44',NULL),(3270,NULL,40719,34,2,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:51:45','2023-02-28 15:51:45',NULL),(3271,NULL,40719,34,2,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',641.00,NULL,NULL,1,'2023-02-28 15:51:46','2023-02-28 15:51:46',NULL),(3272,NULL,40719,34,2,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',632.00,NULL,NULL,1,'2023-02-28 15:51:48','2023-02-28 15:51:48',NULL),(3273,NULL,40719,34,2,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',800.00,NULL,NULL,1,'2023-02-28 15:51:49','2023-02-28 15:51:49',NULL),(3274,NULL,40719,34,2,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',410.00,NULL,NULL,1,'2023-02-28 15:51:51','2023-02-28 15:51:51',NULL);
INSERT INTO `balance_libro` VALUES (3275,NULL,40719,34,2,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',370.00,NULL,NULL,1,'2023-02-28 15:51:52','2023-02-28 15:51:52',NULL),(3276,NULL,40719,34,2,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',380.00,NULL,NULL,1,'2023-02-28 15:51:54','2023-02-28 15:51:54',NULL),(3277,NULL,40719,34,2,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',391.00,NULL,NULL,1,'2023-02-28 15:51:55','2023-02-28 15:51:55',NULL),(3278,NULL,40719,34,2,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',381.00,NULL,NULL,1,'2023-02-28 15:51:56','2023-02-28 15:51:56',NULL),(3279,NULL,40719,34,2,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',387.00,NULL,NULL,1,'2023-02-28 15:51:58','2023-02-28 15:51:58',NULL),(3280,NULL,40719,34,2,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',314.00,NULL,NULL,1,'2023-02-28 15:51:59','2023-02-28 15:51:59',NULL),(3281,NULL,40719,34,2,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:52:01','2023-02-28 15:52:01',NULL),(3282,NULL,40719,34,2,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',300.00,NULL,NULL,1,'2023-02-28 15:52:02','2023-02-28 15:52:02',NULL),(3283,NULL,40719,34,2,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',644.00,NULL,NULL,1,'2023-02-28 15:52:04','2023-02-28 15:52:04',NULL),(3284,NULL,40719,34,2,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',611.00,NULL,NULL,1,'2023-02-28 15:52:05','2023-02-28 15:52:05',NULL),(3285,NULL,40719,34,2,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:52:06','2023-02-28 15:52:06',NULL),(3286,NULL,40719,34,2,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:52:08','2023-02-28 15:52:08',NULL),(3287,NULL,40719,34,2,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',610.00,NULL,NULL,1,'2023-02-28 15:52:10','2023-02-28 15:52:10',NULL),(3288,NULL,40719,34,2,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',177.00,NULL,NULL,1,'2023-02-28 15:52:12','2023-02-28 15:52:12',NULL),(3289,NULL,40719,34,2,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',988.00,NULL,NULL,1,'2023-02-28 15:52:14','2023-02-28 15:52:14',NULL),(3290,NULL,40719,34,2,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',641.00,NULL,NULL,1,'2023-02-28 15:52:15','2023-02-28 15:52:15',NULL),(3291,NULL,40719,34,2,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:52:16','2023-02-28 15:52:16',NULL),(3292,NULL,40719,34,2,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:52:18','2023-02-28 15:52:18',NULL),(3293,NULL,40719,34,2,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:52:19','2023-02-28 15:52:19',NULL),(3294,NULL,40719,34,2,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:52:21','2023-02-28 15:52:21',NULL),(3295,NULL,40719,34,2,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:52:22','2023-02-28 15:52:22',NULL);
INSERT INTO `balance_libro` VALUES (3296,NULL,40719,34,2,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:52:24','2023-02-28 15:52:24',NULL),(3297,NULL,40719,34,2,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:52:25','2023-02-28 15:52:25',NULL),(3298,NULL,40719,34,2,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:52:27','2023-02-28 15:52:27',NULL),(3299,NULL,40719,34,2,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',540.00,NULL,NULL,1,'2023-02-28 15:52:28','2023-02-28 15:52:28',NULL),(3300,NULL,40719,34,2,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',620.00,NULL,NULL,1,'2023-02-28 15:52:30','2023-02-28 15:52:30',NULL),(3301,NULL,40719,34,2,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',740.00,NULL,NULL,1,'2023-02-28 15:52:31','2023-02-28 15:52:31',NULL),(3302,NULL,40719,34,2,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',654.00,NULL,NULL,1,'2023-02-28 15:52:33','2023-02-28 15:52:33',NULL),(3303,NULL,40719,34,2,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',741.00,NULL,NULL,1,'2023-02-28 15:52:34','2023-02-28 15:52:34',NULL),(3304,NULL,40719,34,2,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',789.00,NULL,NULL,1,'2023-02-28 15:52:35','2023-02-28 15:52:35',NULL),(3305,NULL,40719,34,2,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',963.00,NULL,NULL,1,'2023-02-28 15:52:37','2023-02-28 15:52:37',NULL),(3306,NULL,40719,34,2,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:52:39','2023-02-28 15:52:39',NULL),(3307,NULL,40719,34,2,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',641.00,NULL,NULL,1,'2023-02-28 15:52:40','2023-02-28 15:52:40',NULL),(3308,NULL,40719,34,2,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',632.00,NULL,NULL,1,'2023-02-28 15:52:41','2023-02-28 15:52:41',NULL),(3309,NULL,40719,34,2,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',800.00,NULL,NULL,1,'2023-02-28 15:52:43','2023-02-28 15:52:43',NULL),(3310,NULL,40719,34,2,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',410.00,NULL,NULL,1,'2023-02-28 15:52:44','2023-02-28 15:52:44',NULL),(3311,NULL,40719,34,2,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',300.00,NULL,NULL,1,'2023-02-28 15:52:46','2023-02-28 15:52:46',NULL),(3312,NULL,40719,34,2,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',300.00,NULL,NULL,1,'2023-02-28 15:52:48','2023-02-28 15:52:48',NULL),(3313,NULL,40719,34,2,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',310.00,NULL,NULL,1,'2023-02-28 15:52:49','2023-02-28 15:52:49',NULL),(3314,NULL,40719,34,2,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',441.00,NULL,NULL,1,'2023-02-28 15:52:50','2023-02-28 15:52:50',NULL),(3315,NULL,40719,34,2,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:52:52','2023-02-28 15:52:52',NULL),(3316,NULL,40719,34,2,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:52:53','2023-02-28 15:52:53',NULL);
INSERT INTO `balance_libro` VALUES (3317,NULL,40719,34,2,3327,'App\\Models\\Receipt',3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',663.00,NULL,NULL,1,'2023-02-28 15:52:55','2023-02-28 15:52:55',NULL),(3318,NULL,40719,34,2,3328,'App\\Models\\Receipt',3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',663.00,NULL,NULL,1,'2023-02-28 15:52:56','2023-02-28 15:52:56',NULL),(3319,NULL,40719,34,2,3329,'App\\Models\\Receipt',3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:52:58','2023-02-28 15:52:58',NULL),(3320,NULL,40719,34,2,3330,'App\\Models\\Receipt',3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',441.00,NULL,NULL,1,'2023-02-28 15:52:59','2023-02-28 15:52:59',NULL),(3321,NULL,40719,34,2,3331,'App\\Models\\Receipt',3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',885.00,NULL,NULL,1,'2023-02-28 15:53:01','2023-02-28 15:53:01',NULL),(3322,NULL,40719,34,2,3332,'App\\Models\\Receipt',3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',996.00,NULL,NULL,1,'2023-02-28 15:53:02','2023-02-28 15:53:02',NULL),(3323,NULL,40719,34,2,3333,'App\\Models\\Receipt',3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',774.00,NULL,NULL,1,'2023-02-28 15:53:03','2023-02-28 15:53:03',NULL),(3324,NULL,40719,34,2,3334,'App\\Models\\Receipt',3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:53:05','2023-02-28 15:53:05',NULL),(3325,NULL,40719,34,2,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:53:06','2023-02-28 15:53:06',NULL),(3326,NULL,40719,34,2,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:53:08','2023-02-28 15:53:08',NULL),(3327,NULL,40719,34,2,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:53:10','2023-02-28 15:53:10',NULL),(3328,NULL,40719,34,2,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:53:11','2023-02-28 15:53:11',NULL),(3329,NULL,40719,34,2,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:53:12','2023-02-28 15:53:12',NULL),(3330,NULL,40719,34,2,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',800.00,NULL,NULL,1,'2023-02-28 15:53:14','2023-02-28 15:53:14',NULL),(3331,NULL,40719,34,2,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:53:16','2023-02-28 15:53:16',NULL),(3332,NULL,40719,34,2,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:53:18','2023-02-28 15:53:18',NULL),(3333,NULL,40719,34,2,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',200.00,NULL,NULL,1,'2023-02-28 15:53:19','2023-02-28 15:53:19',NULL),(3334,NULL,40719,34,2,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',300.00,NULL,NULL,1,'2023-02-28 15:53:21','2023-02-28 15:53:21',NULL),(3335,NULL,40719,34,2,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:53:22','2023-02-28 15:53:22',NULL),(3336,NULL,40719,34,2,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',420.00,NULL,NULL,1,'2023-02-28 15:53:24','2023-02-28 15:53:24',NULL),(3337,NULL,40719,34,2,3347,'App\\Models\\Receipt',3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',430.00,NULL,NULL,1,'2023-02-28 15:53:25','2023-02-28 15:53:25',NULL);
INSERT INTO `balance_libro` VALUES (3338,NULL,40719,34,2,3348,'App\\Models\\Receipt',3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',452.00,NULL,NULL,1,'2023-02-28 15:53:26','2023-02-28 15:53:26',NULL),(3339,NULL,40719,34,2,3349,'App\\Models\\Receipt',3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',560.00,NULL,NULL,1,'2023-02-28 15:53:28','2023-02-28 15:53:28',NULL),(3340,NULL,40719,34,2,3350,'App\\Models\\Receipt',3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',541.00,NULL,NULL,1,'2023-02-28 15:53:29','2023-02-28 15:53:29',NULL),(3341,NULL,40719,34,2,3351,'App\\Models\\Receipt',3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',631.00,NULL,NULL,1,'2023-02-28 15:53:30','2023-02-28 15:53:30',NULL),(3342,NULL,40719,34,2,3352,'App\\Models\\Receipt',3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',412.00,NULL,NULL,1,'2023-02-28 15:53:32','2023-02-28 15:53:32',NULL),(3343,NULL,40719,34,2,3353,'App\\Models\\Receipt',3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',520.00,NULL,NULL,1,'2023-02-28 15:53:33','2023-02-28 15:53:33',NULL),(3344,NULL,40719,34,2,3354,'App\\Models\\Receipt',3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',321.00,NULL,NULL,1,'2023-02-28 15:53:35','2023-02-28 15:53:35',NULL),(3345,NULL,40719,34,2,3355,'App\\Models\\Receipt',3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',321.00,NULL,NULL,1,'2023-02-28 15:53:36','2023-02-28 15:53:36',NULL),(3346,NULL,40719,34,2,3356,'App\\Models\\Receipt',3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',789.00,NULL,NULL,1,'2023-02-28 15:53:37','2023-02-28 15:53:37',NULL),(3347,NULL,40719,34,2,3357,'App\\Models\\Receipt',3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',321.00,NULL,NULL,1,'2023-02-28 15:53:39','2023-02-28 15:53:39',NULL),(3348,NULL,40719,34,2,3358,'App\\Models\\Receipt',3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',410.00,NULL,NULL,1,'2023-02-28 15:53:40','2023-02-28 15:53:40',NULL),(3349,NULL,40719,34,2,3359,'App\\Models\\Receipt',3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',630.00,NULL,NULL,1,'2023-02-28 15:53:42','2023-02-28 15:53:42',NULL),(3350,NULL,40719,34,2,3360,'App\\Models\\Receipt',3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',467.00,NULL,NULL,1,'2023-02-28 15:53:43','2023-02-28 15:53:43',NULL),(3351,NULL,40719,34,2,3361,'App\\Models\\Receipt',3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',417.00,NULL,NULL,1,'2023-02-28 15:53:44','2023-02-28 15:53:44',NULL),(3352,NULL,40719,34,2,3362,'App\\Models\\Receipt',3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',419.00,NULL,NULL,1,'2023-02-28 15:53:46','2023-02-28 15:53:46',NULL),(3353,NULL,40719,34,2,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',418.00,NULL,NULL,1,'2023-02-28 15:53:48','2023-02-28 15:53:48',NULL),(3354,NULL,40719,34,2,3364,'App\\Models\\Receipt',3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',417.00,NULL,NULL,1,'2023-02-28 15:53:50','2023-02-28 15:53:50',NULL),(3355,NULL,40719,34,2,3365,'App\\Models\\Receipt',3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',413.00,NULL,NULL,1,'2023-02-28 15:53:51','2023-02-28 15:53:51',NULL),(3356,NULL,40719,34,2,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',415.00,NULL,NULL,1,'2023-02-28 15:53:52','2023-02-28 15:53:52',NULL),(3357,NULL,40719,34,2,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',416.00,NULL,NULL,1,'2023-02-28 15:53:53','2023-02-28 15:53:53',NULL),(3358,NULL,40719,34,2,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',418.00,NULL,NULL,1,'2023-02-28 15:53:55','2023-02-28 15:53:55',NULL);
INSERT INTO `balance_libro` VALUES (3359,NULL,40719,34,2,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',436.00,NULL,NULL,1,'2023-02-28 15:53:56','2023-02-28 15:53:56',NULL),(3360,NULL,40719,34,2,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',481.00,NULL,NULL,1,'2023-02-28 15:53:57','2023-02-28 15:53:57',NULL),(3361,NULL,40719,34,2,3371,'App\\Models\\Receipt',3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',461.00,NULL,NULL,1,'2023-02-28 15:53:59','2023-02-28 15:53:59',NULL),(3362,NULL,40719,34,2,3372,'App\\Models\\Receipt',3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',432.00,NULL,NULL,1,'2023-02-28 15:54:00','2023-02-28 15:54:00',NULL),(3363,NULL,40719,34,2,3373,'App\\Models\\Receipt',3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',411.00,NULL,NULL,1,'2023-02-28 15:54:02','2023-02-28 15:54:02',NULL),(3364,NULL,40719,34,2,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',410.00,NULL,NULL,1,'2023-02-28 15:54:03','2023-02-28 15:54:03',NULL),(3365,NULL,40719,34,2,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:54:05','2023-02-28 15:54:05',NULL),(3366,NULL,40719,34,2,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:54:06','2023-02-28 15:54:06',NULL),(3367,NULL,40719,34,2,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:54:07','2023-02-28 15:54:07',NULL),(3368,NULL,40719,34,2,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-02-28 15:54:09','2023-02-28 15:54:09',NULL),(3369,NULL,40719,34,2,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',460.00,NULL,NULL,1,'2023-02-28 15:54:10','2023-02-28 15:54:10',NULL),(3370,NULL,40719,34,2,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',470.00,NULL,NULL,1,'2023-02-28 15:54:12','2023-02-28 15:54:12',NULL),(3371,NULL,40719,34,2,3381,'App\\Models\\Receipt',3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',480.00,NULL,NULL,1,'2023-02-28 15:54:13','2023-02-28 15:54:13',NULL),(3372,NULL,40719,34,2,3382,'App\\Models\\Receipt',3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',490.00,NULL,NULL,1,'2023-02-28 15:54:15','2023-02-28 15:54:15',NULL),(3373,NULL,40719,34,2,3383,'App\\Models\\Receipt',3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',410.00,NULL,NULL,1,'2023-02-28 15:54:16','2023-02-28 15:54:16',NULL),(3374,NULL,40719,34,2,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',420.00,NULL,NULL,1,'2023-02-28 15:54:18','2023-02-28 15:54:18',NULL),(3375,NULL,40719,34,2,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',430.00,NULL,NULL,1,'2023-02-28 15:54:19','2023-02-28 15:54:19',NULL),(3376,NULL,40719,34,2,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-02-28 15:54:22','2023-02-28 15:54:22',NULL),(3377,NULL,40719,34,2,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',460.00,NULL,NULL,1,'2023-02-28 15:54:24','2023-02-28 15:54:24',NULL),(3378,NULL,40719,34,2,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',490.00,NULL,NULL,1,'2023-02-28 15:54:26','2023-02-28 15:54:26',NULL),(3379,NULL,40719,34,2,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',380.00,NULL,NULL,1,'2023-02-28 15:54:27','2023-02-28 15:54:27',NULL);
INSERT INTO `balance_libro` VALUES (3380,NULL,40719,34,2,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',390.00,NULL,NULL,1,'2023-02-28 15:54:29','2023-02-28 15:54:29',NULL),(3381,NULL,40719,34,2,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',380.00,NULL,NULL,1,'2023-02-28 15:54:30','2023-02-28 15:54:30',NULL),(3382,NULL,40719,34,2,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',387.00,NULL,NULL,1,'2023-02-28 15:54:32','2023-02-28 15:54:32',NULL),(3383,NULL,40719,34,2,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',311.00,NULL,NULL,1,'2023-02-28 15:54:33','2023-02-28 15:54:33',NULL),(3384,NULL,40719,34,2,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',411.00,NULL,NULL,1,'2023-02-28 15:54:35','2023-02-28 15:54:35',NULL),(3385,NULL,40719,34,2,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',390.00,NULL,NULL,1,'2023-02-28 15:54:37','2023-02-28 15:54:37',NULL),(3386,NULL,40719,34,2,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',387.00,NULL,NULL,1,'2023-02-28 15:54:39','2023-02-28 15:54:39',NULL),(3387,NULL,40719,34,2,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',398.00,NULL,NULL,1,'2023-02-28 15:54:41','2023-02-28 15:54:41',NULL),(3388,NULL,40719,34,2,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',364.00,NULL,NULL,1,'2023-02-28 15:54:42','2023-02-28 15:54:42',NULL),(3389,NULL,40719,34,2,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',378.00,NULL,NULL,1,'2023-02-28 15:54:44','2023-02-28 15:54:44',NULL),(3390,NULL,40719,34,2,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:54:45','2023-02-28 15:54:45',NULL),(3391,NULL,40719,34,2,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',422.00,NULL,NULL,1,'2023-02-28 15:54:47','2023-02-28 15:54:47',NULL),(3392,NULL,40719,34,2,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',433.00,NULL,NULL,1,'2023-02-28 15:54:49','2023-02-28 15:54:49',NULL),(3393,NULL,40719,34,2,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',444.00,NULL,NULL,1,'2023-02-28 15:54:51','2023-02-28 15:54:51',NULL),(3394,NULL,40719,34,2,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',466.00,NULL,NULL,1,'2023-02-28 15:54:52','2023-02-28 15:54:52',NULL),(3395,NULL,40719,34,2,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',451.00,NULL,NULL,1,'2023-02-28 15:54:54','2023-02-28 15:54:54',NULL),(3396,NULL,40719,34,2,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:54:56','2023-02-28 15:54:56',NULL),(3397,NULL,40719,34,2,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',465.00,NULL,NULL,1,'2023-02-28 15:54:58','2023-02-28 15:54:58',NULL),(3398,NULL,40719,34,2,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',451.00,NULL,NULL,1,'2023-02-28 15:54:59','2023-02-28 15:54:59',NULL),(3399,NULL,40719,34,2,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',467.00,NULL,NULL,1,'2023-02-28 15:55:01','2023-02-28 15:55:01',NULL),(3400,NULL,40719,34,2,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',417.00,NULL,NULL,1,'2023-02-28 15:55:03','2023-02-28 15:55:03',NULL);
INSERT INTO `balance_libro` VALUES (3401,NULL,40719,34,2,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',419.00,NULL,NULL,1,'2023-02-28 15:55:05','2023-02-28 15:55:05',NULL),(3402,NULL,40719,34,2,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',418.00,NULL,NULL,1,'2023-02-28 15:55:06','2023-02-28 15:55:06',NULL),(3403,NULL,40719,34,2,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',417.00,NULL,NULL,1,'2023-02-28 15:55:08','2023-02-28 15:55:08',NULL),(3404,NULL,40719,34,2,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',413.00,NULL,NULL,1,'2023-02-28 15:55:09','2023-02-28 15:55:09',NULL),(3405,NULL,40719,34,2,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',415.00,NULL,NULL,1,'2023-02-28 15:55:11','2023-02-28 15:55:11',NULL),(3406,NULL,40719,34,2,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',416.00,NULL,NULL,1,'2023-02-28 15:55:13','2023-02-28 15:55:13',NULL),(3407,NULL,40719,34,2,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',418.00,NULL,NULL,1,'2023-02-28 15:55:15','2023-02-28 15:55:15',NULL),(3408,NULL,40719,34,2,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',436.00,NULL,NULL,1,'2023-02-28 15:55:17','2023-02-28 15:55:17',NULL),(3409,NULL,40719,34,2,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',481.00,NULL,NULL,1,'2023-02-28 15:55:19','2023-02-28 15:55:19',NULL),(3410,NULL,40719,34,2,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',461.00,NULL,NULL,1,'2023-02-28 15:55:21','2023-02-28 15:55:21',NULL),(3411,NULL,40719,34,2,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',432.00,NULL,NULL,1,'2023-02-28 15:55:22','2023-02-28 15:55:22',NULL),(3412,NULL,40719,34,2,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',411.00,NULL,NULL,1,'2023-02-28 15:55:24','2023-02-28 15:55:24',NULL),(3413,NULL,40719,34,2,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',410.00,NULL,NULL,1,'2023-02-28 15:55:27','2023-02-28 15:55:27',NULL),(3414,NULL,40719,34,2,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:55:30','2023-02-28 15:55:30',NULL),(3415,NULL,40719,34,2,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:55:32','2023-02-28 15:55:32',NULL),(3416,NULL,40719,34,2,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:55:35','2023-02-28 15:55:35',NULL),(3417,NULL,40719,34,2,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-02-28 15:55:37','2023-02-28 15:55:37',NULL),(3418,NULL,40719,34,2,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',460.00,NULL,NULL,1,'2023-02-28 15:55:39','2023-02-28 15:55:39',NULL),(3419,NULL,40719,34,2,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',470.00,NULL,NULL,1,'2023-02-28 15:55:41','2023-02-28 15:55:41',NULL),(3420,NULL,40719,34,2,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',480.00,NULL,NULL,1,'2023-02-28 15:55:43','2023-02-28 15:55:43',NULL),(3421,NULL,40719,34,2,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',490.00,NULL,NULL,1,'2023-02-28 15:55:45','2023-02-28 15:55:45',NULL);
INSERT INTO `balance_libro` VALUES (3422,NULL,40719,34,2,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',410.00,NULL,NULL,1,'2023-02-28 15:55:47','2023-02-28 15:55:47',NULL),(3423,NULL,40719,34,2,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',420.00,NULL,NULL,1,'2023-02-28 15:55:50','2023-02-28 15:55:50',NULL),(3424,NULL,40719,34,2,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',430.00,NULL,NULL,1,'2023-02-28 15:55:52','2023-02-28 15:55:52',NULL),(3425,NULL,40719,34,2,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-02-28 15:55:54','2023-02-28 15:55:54',NULL),(3426,NULL,40719,34,2,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',460.00,NULL,NULL,1,'2023-02-28 15:55:56','2023-02-28 15:55:56',NULL),(3427,NULL,40719,34,2,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',490.00,NULL,NULL,1,'2023-02-28 15:55:58','2023-02-28 15:55:58',NULL),(3428,NULL,40719,34,2,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',380.00,NULL,NULL,1,'2023-02-28 15:56:00','2023-02-28 15:56:00',NULL),(3429,NULL,40719,34,2,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',390.00,NULL,NULL,1,'2023-02-28 15:56:02','2023-02-28 15:56:02',NULL),(3430,NULL,40719,34,2,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',380.00,NULL,NULL,1,'2023-02-28 15:56:05','2023-02-28 15:56:05',NULL),(3431,NULL,40719,34,2,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',387.00,NULL,NULL,1,'2023-02-28 15:56:06','2023-02-28 15:56:06',NULL),(3432,NULL,40719,34,2,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',311.00,NULL,NULL,1,'2023-02-28 15:56:08','2023-02-28 15:56:08',NULL),(3433,NULL,40719,34,2,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',411.00,NULL,NULL,1,'2023-02-28 15:56:10','2023-02-28 15:56:10',NULL),(3434,NULL,40719,34,2,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',390.00,NULL,NULL,1,'2023-02-28 15:56:12','2023-02-28 15:56:12',NULL),(3435,NULL,40719,34,2,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',387.00,NULL,NULL,1,'2023-02-28 15:56:14','2023-02-28 15:56:14',NULL),(3436,NULL,40719,34,2,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',398.00,NULL,NULL,1,'2023-02-28 15:56:17','2023-02-28 15:56:17',NULL),(3437,NULL,40719,34,2,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',364.00,NULL,NULL,1,'2023-02-28 15:56:19','2023-02-28 15:56:19',NULL),(3438,NULL,40719,34,2,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',378.00,NULL,NULL,1,'2023-02-28 15:56:21','2023-02-28 15:56:21',NULL),(3439,NULL,40719,34,2,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:56:23','2023-02-28 15:56:23',NULL),(3440,NULL,40719,34,2,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',422.00,NULL,NULL,1,'2023-02-28 15:56:25','2023-02-28 15:56:25',NULL),(3441,NULL,40719,34,2,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',433.00,NULL,NULL,1,'2023-02-28 15:56:28','2023-02-28 15:56:28',NULL),(3442,NULL,40719,34,2,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',444.00,NULL,NULL,1,'2023-02-28 15:56:29','2023-02-28 15:56:29',NULL);
INSERT INTO `balance_libro` VALUES (3443,NULL,40719,34,2,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',466.00,NULL,NULL,1,'2023-02-28 15:56:32','2023-02-28 15:56:32',NULL),(3444,NULL,40719,34,2,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',451.00,NULL,NULL,1,'2023-02-28 15:56:34','2023-02-28 15:56:34',NULL),(3445,NULL,40719,34,2,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:56:37','2023-02-28 15:56:37',NULL),(3446,NULL,40719,34,2,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',465.00,NULL,NULL,1,'2023-02-28 15:56:39','2023-02-28 15:56:39',NULL),(3447,NULL,40719,34,2,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',451.00,NULL,NULL,1,'2023-02-28 15:56:41','2023-02-28 15:56:41',NULL),(3448,NULL,40719,34,2,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',300.00,NULL,NULL,1,'2023-02-28 15:56:43','2023-02-28 15:56:43',NULL),(3449,NULL,40719,34,2,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',300.00,NULL,NULL,1,'2023-02-28 15:56:45','2023-02-28 15:56:45',NULL),(3450,NULL,40719,34,2,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',310.00,NULL,NULL,1,'2023-02-28 15:56:47','2023-02-28 15:56:47',NULL),(3451,NULL,40719,34,2,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',441.00,NULL,NULL,1,'2023-02-28 15:56:49','2023-02-28 15:56:49',NULL),(3452,NULL,40719,34,2,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:56:51','2023-02-28 15:56:51',NULL),(3453,NULL,40719,34,2,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:56:53','2023-02-28 15:56:53',NULL),(3454,NULL,40719,34,2,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',663.00,NULL,NULL,1,'2023-02-28 15:56:55','2023-02-28 15:56:55',NULL),(3455,NULL,40719,34,2,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',663.00,NULL,NULL,1,'2023-02-28 15:56:57','2023-02-28 15:56:57',NULL),(3456,NULL,40719,34,2,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:56:59','2023-02-28 15:56:59',NULL),(3457,NULL,40719,34,2,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',441.00,NULL,NULL,1,'2023-02-28 15:57:01','2023-02-28 15:57:01',NULL),(3458,NULL,40719,34,2,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',885.00,NULL,NULL,1,'2023-02-28 15:57:03','2023-02-28 15:57:03',NULL),(3459,NULL,40719,34,2,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',996.00,NULL,NULL,1,'2023-02-28 15:57:05','2023-02-28 15:57:05',NULL),(3460,NULL,40719,34,2,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',774.00,NULL,NULL,1,'2023-02-28 15:57:07','2023-02-28 15:57:07',NULL),(3461,NULL,40719,34,2,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:57:09','2023-02-28 15:57:09',NULL),(3462,NULL,40719,34,2,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:57:11','2023-02-28 15:57:11',NULL),(3463,NULL,40719,34,2,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:57:13','2023-02-28 15:57:13',NULL);
INSERT INTO `balance_libro` VALUES (3464,NULL,40719,34,2,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:57:15','2023-02-28 15:57:15',NULL),(3465,NULL,40719,34,2,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:57:17','2023-02-28 15:57:17',NULL),(3466,NULL,40719,34,2,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:57:19','2023-02-28 15:57:19',NULL),(3467,NULL,40719,34,2,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',800.00,NULL,NULL,1,'2023-02-28 15:57:21','2023-02-28 15:57:21',NULL),(3468,NULL,40719,34,2,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:57:23','2023-02-28 15:57:23',NULL),(3469,NULL,40719,34,2,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:57:25','2023-02-28 15:57:25',NULL),(3470,NULL,40719,34,2,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',800.00,NULL,NULL,1,'2023-02-28 15:57:27','2023-02-28 15:57:27',NULL),(3471,NULL,40719,34,2,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:57:29','2023-02-28 15:57:29',NULL),(3472,NULL,40719,34,2,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:57:31','2023-02-28 15:57:31',NULL),(3473,NULL,40719,34,2,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',580.00,NULL,NULL,1,'2023-02-28 15:57:32','2023-02-28 15:57:32',NULL),(3474,NULL,40719,34,2,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-02-28 15:57:34','2023-02-28 15:57:34',NULL),(3475,NULL,40719,34,2,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-02-28 15:57:37','2023-02-28 15:57:37',NULL),(3476,NULL,40719,34,2,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',654.00,NULL,NULL,1,'2023-02-28 15:57:39','2023-02-28 15:57:39',NULL),(3477,NULL,40719,34,2,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-02-28 15:57:41','2023-02-28 15:57:41',NULL),(3478,NULL,40719,34,2,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',978.00,NULL,NULL,1,'2023-02-28 15:57:43','2023-02-28 15:57:43',NULL),(3479,NULL,40719,34,2,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',789.00,NULL,NULL,1,'2023-02-28 15:57:45','2023-02-28 15:57:45',NULL),(3480,NULL,40719,34,2,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:57:47','2023-02-28 15:57:47',NULL),(3481,NULL,40719,34,2,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',540.00,NULL,NULL,1,'2023-02-28 15:57:50','2023-02-28 15:57:50',NULL),(3482,NULL,40719,34,2,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',620.00,NULL,NULL,1,'2023-02-28 15:57:51','2023-02-28 15:57:51',NULL),(3483,NULL,40719,34,2,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',740.00,NULL,NULL,1,'2023-02-28 15:57:53','2023-02-28 15:57:53',NULL),(3484,NULL,40719,34,2,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',654.00,NULL,NULL,1,'2023-02-28 15:57:55','2023-02-28 15:57:55',NULL);
INSERT INTO `balance_libro` VALUES (3485,NULL,40719,34,2,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',741.00,NULL,NULL,1,'2023-02-28 15:57:57','2023-02-28 15:57:57',NULL),(3486,NULL,40719,34,2,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',789.00,NULL,NULL,1,'2023-02-28 15:57:59','2023-02-28 15:57:59',NULL),(3487,NULL,40719,34,2,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',963.00,NULL,NULL,1,'2023-02-28 15:58:01','2023-02-28 15:58:01',NULL),(3488,NULL,40719,34,2,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',552.00,NULL,NULL,1,'2023-02-28 15:58:03','2023-02-28 15:58:03',NULL),(3489,NULL,40719,34,2,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',641.00,NULL,NULL,1,'2023-02-28 15:58:05','2023-02-28 15:58:05',NULL),(3490,NULL,40719,34,2,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',632.00,NULL,NULL,1,'2023-02-28 15:58:08','2023-02-28 15:58:08',NULL),(3491,NULL,40719,34,2,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',800.00,NULL,NULL,1,'2023-02-28 15:58:10','2023-02-28 15:58:10',NULL),(3492,NULL,40719,34,2,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',410.00,NULL,NULL,1,'2023-02-28 15:58:12','2023-02-28 15:58:12',NULL),(3493,NULL,40719,34,2,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',370.00,NULL,NULL,1,'2023-02-28 15:58:14','2023-02-28 15:58:14',NULL),(3494,NULL,40719,34,2,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',380.00,NULL,NULL,1,'2023-02-28 15:58:16','2023-02-28 15:58:16',NULL),(3495,NULL,40719,34,2,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',391.00,NULL,NULL,1,'2023-02-28 15:58:18','2023-02-28 15:58:18',NULL),(3496,NULL,40719,34,2,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',381.00,NULL,NULL,1,'2023-02-28 15:58:20','2023-02-28 15:58:20',NULL),(3497,NULL,40719,34,2,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',387.00,NULL,NULL,1,'2023-02-28 15:58:22','2023-02-28 15:58:22',NULL),(3498,NULL,40719,34,2,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',314.00,NULL,NULL,1,'2023-02-28 15:58:23','2023-02-28 15:58:23',NULL),(3499,NULL,40719,34,2,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:58:25','2023-02-28 15:58:25',NULL),(3500,NULL,40719,34,2,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',300.00,NULL,NULL,1,'2023-02-28 15:58:27','2023-02-28 15:58:27',NULL),(3501,NULL,40719,34,2,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',644.00,NULL,NULL,1,'2023-02-28 15:58:28','2023-02-28 15:58:28',NULL),(3502,NULL,40719,34,2,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',611.00,NULL,NULL,1,'2023-02-28 15:58:30','2023-02-28 15:58:30',NULL),(3503,NULL,40719,34,2,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:58:31','2023-02-28 15:58:31',NULL),(3504,NULL,40719,34,2,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:58:33','2023-02-28 15:58:33',NULL),(3505,NULL,40719,34,2,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',610.00,NULL,NULL,1,'2023-02-28 15:58:34','2023-02-28 15:58:34',NULL);
INSERT INTO `balance_libro` VALUES (3506,NULL,40719,34,2,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',177.00,NULL,NULL,1,'2023-02-28 15:58:36','2023-02-28 15:58:36',NULL),(3507,NULL,40719,34,2,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',988.00,NULL,NULL,1,'2023-02-28 15:58:37','2023-02-28 15:58:37',NULL),(3508,NULL,40719,34,2,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',641.00,NULL,NULL,1,'2023-02-28 15:58:39','2023-02-28 15:58:39',NULL),(3509,NULL,40719,34,2,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:58:40','2023-02-28 15:58:40',NULL),(3510,NULL,40719,34,2,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:58:42','2023-02-28 15:58:42',NULL),(3511,NULL,40719,34,2,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-02-28 15:58:43','2023-02-28 15:58:43',NULL),(3512,NULL,40719,34,2,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:58:46','2023-02-28 15:58:46',NULL),(3513,NULL,40719,34,2,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:58:48','2023-02-28 15:58:48',NULL),(3514,NULL,40719,34,2,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:58:50','2023-02-28 15:58:50',NULL),(3515,NULL,40719,34,2,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:58:51','2023-02-28 15:58:51',NULL),(3516,NULL,40719,34,2,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',400.00,NULL,NULL,1,'2023-02-28 15:58:53','2023-02-28 15:58:53',NULL),(3517,NULL,40719,34,2,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',540.00,NULL,NULL,1,'2023-02-28 15:58:54','2023-02-28 15:58:54',NULL),(3518,NULL,40719,34,2,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',620.00,NULL,NULL,1,'2023-02-28 15:58:55','2023-02-28 15:58:55',NULL),(3519,NULL,40719,34,2,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',740.00,NULL,NULL,1,'2023-02-28 15:58:57','2023-02-28 15:58:57',NULL),(3520,NULL,40719,34,2,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',654.00,NULL,NULL,1,'2023-02-28 15:58:58','2023-02-28 15:58:58',NULL),(3521,NULL,40719,34,2,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',741.00,NULL,NULL,1,'2023-02-28 15:59:00','2023-02-28 15:59:00',NULL),(3522,NULL,40719,34,2,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',789.00,NULL,NULL,1,'2023-02-28 15:59:01','2023-02-28 15:59:01',NULL),(3523,NULL,40719,34,2,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',611.00,NULL,NULL,1,'2023-02-28 15:59:02','2023-02-28 15:59:02',NULL),(3524,NULL,40719,34,2,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',644.00,NULL,NULL,1,'2023-02-28 15:59:04','2023-02-28 15:59:04',NULL),(3525,NULL,40719,34,2,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',655.00,NULL,NULL,1,'2023-02-28 15:59:05','2023-02-28 15:59:05',NULL),(3526,NULL,40719,34,2,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',633.00,NULL,NULL,1,'2023-02-28 15:59:06','2023-02-28 15:59:06',NULL);
INSERT INTO `balance_libro` VALUES (3527,NULL,40719,34,2,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',620.00,NULL,NULL,1,'2023-02-28 15:59:08','2023-02-28 15:59:08',NULL),(3528,NULL,40719,34,2,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',644.00,NULL,NULL,1,'2023-02-28 15:59:10','2023-02-28 15:59:10',NULL),(3529,NULL,40719,34,2,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:59:11','2023-02-28 15:59:11',NULL),(3530,NULL,40719,34,2,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-02-28 15:59:13','2023-02-28 15:59:13',NULL),(3531,NULL,40719,34,2,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',751.00,NULL,NULL,1,'2023-02-28 15:59:14','2023-02-28 15:59:14',NULL),(3532,NULL,40719,34,2,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',680.00,NULL,NULL,1,'2023-02-28 15:59:15','2023-02-28 15:59:15',NULL),(3533,NULL,40719,34,2,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',680.00,NULL,NULL,1,'2023-02-28 15:59:17','2023-02-28 15:59:17',NULL),(3534,NULL,40719,34,2,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',680.00,NULL,NULL,1,'2023-02-28 15:59:18','2023-02-28 15:59:18',NULL),(3535,NULL,40719,34,2,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',680.00,NULL,NULL,1,'2023-02-28 15:59:19','2023-02-28 15:59:19',NULL),(3536,NULL,40719,34,2,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',641.00,NULL,NULL,1,'2023-02-28 15:59:21','2023-02-28 15:59:21',NULL),(3537,NULL,40719,34,2,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',641.00,NULL,NULL,1,'2023-02-28 15:59:22','2023-02-28 15:59:22',NULL),(3538,NULL,40719,34,2,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',622.00,NULL,NULL,1,'2023-02-28 15:59:24','2023-02-28 15:59:24',NULL),(3539,NULL,40719,34,2,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',633.00,NULL,NULL,1,'2023-02-28 15:59:25','2023-02-28 15:59:25',NULL),(3540,NULL,40719,34,2,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',655.00,NULL,NULL,1,'2023-02-28 15:59:26','2023-02-28 15:59:26',NULL),(3541,NULL,40719,34,2,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',740.00,NULL,NULL,1,'2023-02-28 15:59:28','2023-02-28 15:59:28',NULL),(3542,NULL,40719,34,2,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',500.00,NULL,NULL,1,'2023-02-28 15:59:30','2023-02-28 15:59:30',NULL),(3543,NULL,40719,34,2,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',490.00,NULL,NULL,1,'2023-02-28 15:59:31','2023-02-28 15:59:31',NULL),(3544,NULL,40719,34,2,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',403.00,NULL,NULL,1,'2023-02-28 15:59:33','2023-02-28 15:59:33',NULL),(3545,NULL,40719,34,2,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',406.00,NULL,NULL,1,'2023-02-28 15:59:34','2023-02-28 15:59:34',NULL),(3546,NULL,40719,34,2,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',418.00,NULL,NULL,1,'2023-02-28 15:59:35','2023-02-28 15:59:35',NULL),(3547,NULL,40719,34,2,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',467.00,NULL,NULL,1,'2023-02-28 15:59:37','2023-02-28 15:59:37',NULL);
INSERT INTO `balance_libro` VALUES (3548,NULL,40719,34,2,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',417.00,NULL,NULL,1,'2023-02-28 15:59:38','2023-02-28 15:59:38',NULL),(3549,NULL,40719,34,2,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',419.00,NULL,NULL,1,'2023-02-28 15:59:40','2023-02-28 15:59:40',NULL),(3550,NULL,40719,34,2,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',418.00,NULL,NULL,1,'2023-02-28 15:59:41','2023-02-28 15:59:41',NULL),(3551,NULL,40719,34,2,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',417.00,NULL,NULL,1,'2023-02-28 15:59:43','2023-02-28 15:59:43',NULL),(3552,NULL,40719,34,2,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',680.00,NULL,NULL,1,'2023-02-28 15:59:44','2023-02-28 15:59:44',NULL),(3553,NULL,40719,34,2,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',680.00,NULL,NULL,1,'2023-02-28 15:59:46','2023-02-28 15:59:46',NULL),(3554,NULL,40719,34,2,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',680.00,NULL,NULL,1,'2023-02-28 15:59:47','2023-02-28 15:59:47',NULL),(3555,NULL,40719,34,2,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',641.00,NULL,NULL,1,'2023-02-28 15:59:48','2023-02-28 15:59:48',NULL),(3556,NULL,40719,34,2,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',641.00,NULL,NULL,1,'2023-02-28 15:59:49','2023-02-28 15:59:49',NULL),(3557,NULL,40719,34,2,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',622.00,NULL,NULL,1,'2023-02-28 15:59:51','2023-02-28 15:59:51',NULL),(3558,NULL,40719,34,2,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',633.00,NULL,NULL,1,'2023-02-28 15:59:52','2023-02-28 15:59:52',NULL),(3559,NULL,40719,34,2,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',655.00,NULL,NULL,1,'2023-02-28 15:59:54','2023-02-28 15:59:54',NULL),(3560,NULL,40719,34,2,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',740.00,NULL,NULL,1,'2023-02-28 15:59:55','2023-02-28 15:59:55',NULL),(3561,NULL,40719,34,2,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',500.00,NULL,NULL,1,'2023-02-28 15:59:57','2023-02-28 15:59:57',NULL),(3562,NULL,40719,34,2,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',490.00,NULL,NULL,1,'2023-02-28 15:59:59','2023-02-28 15:59:59',NULL),(3563,NULL,40719,34,2,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',403.00,NULL,NULL,1,'2023-02-28 16:00:01','2023-02-28 16:00:01',NULL),(3564,NULL,40719,34,2,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',406.00,NULL,NULL,1,'2023-02-28 16:00:03','2023-02-28 16:00:03',NULL),(3565,NULL,40719,34,2,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',418.00,NULL,NULL,1,'2023-02-28 16:00:05','2023-02-28 16:00:05',NULL),(3566,NULL,40719,35,2,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',541.00,NULL,NULL,1,'2023-03-31 22:48:27','2023-03-31 22:48:27',NULL),(3567,NULL,40719,35,2,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',534.00,NULL,NULL,1,'2023-03-31 22:48:28','2023-03-31 22:48:28',NULL),(3568,NULL,40719,35,2,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',452.00,NULL,NULL,1,'2023-03-31 22:48:29','2023-03-31 22:48:29',NULL);
INSERT INTO `balance_libro` VALUES (3569,NULL,40719,35,2,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',346.00,NULL,NULL,1,'2023-03-31 22:48:30','2023-03-31 22:48:30',NULL),(3570,NULL,40719,35,2,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',581.00,NULL,NULL,1,'2023-03-31 22:48:31','2023-03-31 22:48:31',NULL),(3571,NULL,40719,35,2,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',828.00,NULL,NULL,1,'2023-03-31 22:48:32','2023-03-31 22:48:32',NULL),(3572,NULL,40719,35,2,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',397.00,NULL,NULL,1,'2023-03-31 22:48:32','2023-03-31 22:48:32',NULL),(3573,NULL,40719,35,2,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',780.00,NULL,NULL,1,'2023-03-31 22:48:33','2023-03-31 22:48:33',NULL),(3574,NULL,40719,35,2,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',569.00,NULL,NULL,1,'2023-03-31 22:48:34','2023-03-31 22:48:34',NULL),(3575,NULL,40719,35,2,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',566.00,NULL,NULL,1,'2023-03-31 22:48:35','2023-03-31 22:48:35',NULL),(3576,NULL,40719,35,2,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',812.00,NULL,NULL,1,'2023-03-31 22:48:36','2023-03-31 22:48:36',NULL),(3577,NULL,40719,35,2,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',336.00,NULL,NULL,1,'2023-03-31 22:48:37','2023-03-31 22:48:37',NULL),(3578,NULL,40719,35,2,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',406.00,NULL,NULL,1,'2023-03-31 22:48:38','2023-03-31 22:48:38',NULL),(3579,NULL,40719,35,2,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',804.00,NULL,NULL,1,'2023-03-31 22:48:39','2023-03-31 22:48:39',NULL),(3580,NULL,40719,35,2,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',728.00,NULL,NULL,1,'2023-03-31 22:48:40','2023-03-31 22:48:40',NULL),(3581,NULL,40719,35,2,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',580.00,NULL,NULL,1,'2023-03-31 22:48:41','2023-03-31 22:48:41',NULL),(3582,NULL,40719,35,2,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',528.00,NULL,NULL,1,'2023-03-31 22:48:42','2023-03-31 22:48:42',NULL),(3583,NULL,40719,35,2,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',851.00,NULL,NULL,1,'2023-03-31 22:48:43','2023-03-31 22:48:43',NULL),(3584,NULL,40719,35,2,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',753.00,NULL,NULL,1,'2023-03-31 22:48:44','2023-03-31 22:48:44',NULL),(3585,NULL,40719,35,2,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',797.00,NULL,NULL,1,'2023-03-31 22:48:45','2023-03-31 22:48:45',NULL),(3586,NULL,40719,35,2,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',828.00,NULL,NULL,1,'2023-03-31 22:48:46','2023-03-31 22:48:46',NULL),(3587,NULL,40719,35,2,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',508.00,NULL,NULL,1,'2023-03-31 22:48:47','2023-03-31 22:48:47',NULL),(3588,NULL,40719,35,2,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',626.00,NULL,NULL,1,'2023-03-31 22:48:48','2023-03-31 22:48:48',NULL),(3589,NULL,40719,35,2,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',583.00,NULL,NULL,1,'2023-03-31 22:48:49','2023-03-31 22:48:49',NULL);
INSERT INTO `balance_libro` VALUES (3590,NULL,40719,35,2,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',659.00,NULL,NULL,1,'2023-03-31 22:48:50','2023-03-31 22:48:50',NULL),(3591,NULL,40719,35,2,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',787.00,NULL,NULL,1,'2023-03-31 22:48:51','2023-03-31 22:48:51',NULL),(3592,NULL,40719,35,2,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',428.00,NULL,NULL,1,'2023-03-31 22:48:51','2023-03-31 22:48:51',NULL),(3593,NULL,40719,35,2,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',366.00,NULL,NULL,1,'2023-03-31 22:48:52','2023-03-31 22:48:52',NULL),(3594,NULL,40719,35,2,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',428.00,NULL,NULL,1,'2023-03-31 22:48:53','2023-03-31 22:48:53',NULL),(3595,NULL,40719,35,2,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',704.00,NULL,NULL,1,'2023-03-31 22:48:54','2023-03-31 22:48:54',NULL),(3596,NULL,40719,35,2,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',395.00,NULL,NULL,1,'2023-03-31 22:48:55','2023-03-31 22:48:55',NULL),(3597,NULL,40719,35,2,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',703.00,NULL,NULL,1,'2023-03-31 22:48:56','2023-03-31 22:48:56',NULL),(3598,NULL,40719,35,2,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',614.00,NULL,NULL,1,'2023-03-31 22:48:57','2023-03-31 22:48:57',NULL),(3599,NULL,40719,35,2,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',379.00,NULL,NULL,1,'2023-03-31 22:48:58','2023-03-31 22:48:58',NULL),(3600,NULL,40719,35,2,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',492.00,NULL,NULL,1,'2023-03-31 22:48:59','2023-03-31 22:48:59',NULL),(3601,NULL,40719,35,2,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',626.00,NULL,NULL,1,'2023-03-31 22:49:00','2023-03-31 22:49:00',NULL),(3602,NULL,40719,35,2,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',474.00,NULL,NULL,1,'2023-03-31 22:49:01','2023-03-31 22:49:01',NULL),(3603,NULL,40719,35,2,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',530.00,NULL,NULL,1,'2023-03-31 22:49:02','2023-03-31 22:49:02',NULL),(3604,NULL,40719,35,2,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',461.00,NULL,NULL,1,'2023-03-31 22:49:03','2023-03-31 22:49:03',NULL),(3605,NULL,40719,35,2,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',310.00,NULL,NULL,1,'2023-03-31 22:49:04','2023-03-31 22:49:04',NULL),(3606,NULL,40719,35,2,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',540.00,NULL,NULL,1,'2023-03-31 22:49:05','2023-03-31 22:49:05',NULL),(3607,NULL,40719,35,2,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',604.00,NULL,NULL,1,'2023-03-31 22:49:06','2023-03-31 22:49:06',NULL),(3608,NULL,40719,35,2,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',564.00,NULL,NULL,1,'2023-03-31 22:49:07','2023-03-31 22:49:07',NULL),(3609,NULL,40719,35,2,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',335.00,NULL,NULL,1,'2023-03-31 22:49:08','2023-03-31 22:49:08',NULL),(3610,NULL,40719,35,2,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',713.00,NULL,NULL,1,'2023-03-31 22:49:09','2023-03-31 22:49:09',NULL);
INSERT INTO `balance_libro` VALUES (3611,NULL,40719,35,2,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',757.00,NULL,NULL,1,'2023-03-31 22:49:10','2023-03-31 22:49:10',NULL),(3612,NULL,40719,35,2,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',845.00,NULL,NULL,1,'2023-03-31 22:49:11','2023-03-31 22:49:11',NULL),(3613,NULL,40719,35,2,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',391.00,NULL,NULL,1,'2023-03-31 22:49:12','2023-03-31 22:49:12',NULL),(3614,NULL,40719,35,2,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',674.00,NULL,NULL,1,'2023-03-31 22:49:13','2023-03-31 22:49:13',NULL),(3615,NULL,40719,35,2,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',519.00,NULL,NULL,1,'2023-03-31 22:49:14','2023-03-31 22:49:14',NULL),(3616,NULL,40719,35,2,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',373.00,NULL,NULL,1,'2023-03-31 22:49:15','2023-03-31 22:49:15',NULL),(3617,NULL,40719,35,2,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',726.00,NULL,NULL,1,'2023-03-31 22:49:16','2023-03-31 22:49:16',NULL),(3618,NULL,40719,35,2,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',550.00,NULL,NULL,1,'2023-03-31 22:49:17','2023-03-31 22:49:17',NULL),(3619,NULL,40719,35,2,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',387.00,NULL,NULL,1,'2023-03-31 22:49:18','2023-03-31 22:49:18',NULL),(3620,NULL,40719,35,2,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',817.00,NULL,NULL,1,'2023-03-31 22:49:19','2023-03-31 22:49:19',NULL),(3621,NULL,40719,35,2,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',525.00,NULL,NULL,1,'2023-03-31 22:49:19','2023-03-31 22:49:19',NULL),(3622,NULL,40719,35,2,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',765.00,NULL,NULL,1,'2023-03-31 22:49:20','2023-03-31 22:49:20',NULL),(3623,NULL,40719,35,2,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',418.00,NULL,NULL,1,'2023-03-31 22:49:21','2023-03-31 22:49:21',NULL),(3624,NULL,40719,35,2,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',570.00,NULL,NULL,1,'2023-03-31 22:49:22','2023-03-31 22:49:22',NULL),(3625,NULL,40719,35,2,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',690.00,NULL,NULL,1,'2023-03-31 22:49:23','2023-03-31 22:49:23',NULL),(3626,NULL,40719,35,2,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',682.00,NULL,NULL,1,'2023-03-31 22:49:24','2023-03-31 22:49:24',NULL),(3627,NULL,40719,35,2,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',453.00,NULL,NULL,1,'2023-03-31 22:49:25','2023-03-31 22:49:25',NULL),(3628,NULL,40719,35,2,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',303.00,NULL,NULL,1,'2023-03-31 22:49:26','2023-03-31 22:49:26',NULL),(3629,NULL,40719,35,2,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',546.00,NULL,NULL,1,'2023-03-31 22:49:27','2023-03-31 22:49:27',NULL),(3630,NULL,40719,35,2,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',781.00,NULL,NULL,1,'2023-03-31 22:49:28','2023-03-31 22:49:28',NULL),(3631,NULL,40719,35,2,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',633.00,NULL,NULL,1,'2023-03-31 22:49:29','2023-03-31 22:49:29',NULL);
INSERT INTO `balance_libro` VALUES (3632,NULL,40719,35,2,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',339.00,NULL,NULL,1,'2023-03-31 22:49:30','2023-03-31 22:49:30',NULL),(3633,NULL,40719,35,2,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',490.00,NULL,NULL,1,'2023-03-31 22:49:31','2023-03-31 22:49:31',NULL),(3634,NULL,40719,35,2,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',419.00,NULL,NULL,1,'2023-03-31 22:49:32','2023-03-31 22:49:32',NULL),(3635,NULL,40719,35,2,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',821.00,NULL,NULL,1,'2023-03-31 22:49:33','2023-03-31 22:49:33',NULL),(3636,NULL,40719,35,2,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',545.00,NULL,NULL,1,'2023-03-31 22:49:34','2023-03-31 22:49:34',NULL),(3637,NULL,40719,35,2,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',636.00,NULL,NULL,1,'2023-03-31 22:49:35','2023-03-31 22:49:35',NULL),(3638,NULL,40719,35,2,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',892.00,NULL,NULL,1,'2023-03-31 22:49:36','2023-03-31 22:49:36',NULL),(3639,NULL,40719,35,2,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',763.00,NULL,NULL,1,'2023-03-31 22:49:37','2023-03-31 22:49:37',NULL),(3640,NULL,40719,35,2,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',533.00,NULL,NULL,1,'2023-03-31 22:49:37','2023-03-31 22:49:37',NULL),(3641,NULL,40719,35,2,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',343.00,NULL,NULL,1,'2023-03-31 22:49:38','2023-03-31 22:49:38',NULL),(3642,NULL,40719,35,2,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',477.00,NULL,NULL,1,'2023-03-31 22:49:39','2023-03-31 22:49:39',NULL),(3643,NULL,40719,35,2,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',535.00,NULL,NULL,1,'2023-03-31 22:49:40','2023-03-31 22:49:40',NULL),(3644,NULL,40719,35,2,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',493.00,NULL,NULL,1,'2023-03-31 22:49:41','2023-03-31 22:49:41',NULL),(3645,NULL,40719,35,2,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',427.00,NULL,NULL,1,'2023-03-31 22:49:42','2023-03-31 22:49:42',NULL),(3646,NULL,40719,35,2,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',704.00,NULL,NULL,1,'2023-03-31 22:49:43','2023-03-31 22:49:43',NULL),(3647,NULL,40719,35,2,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',668.00,NULL,NULL,1,'2023-03-31 22:49:44','2023-03-31 22:49:44',NULL),(3648,NULL,40719,35,2,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',741.00,NULL,NULL,1,'2023-03-31 22:49:45','2023-03-31 22:49:45',NULL),(3649,NULL,40719,35,2,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',794.00,NULL,NULL,1,'2023-03-31 22:49:46','2023-03-31 22:49:46',NULL),(3650,NULL,40719,35,2,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',770.00,NULL,NULL,1,'2023-03-31 22:49:47','2023-03-31 22:49:47',NULL),(3651,NULL,40719,35,2,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',414.00,NULL,NULL,1,'2023-03-31 22:49:48','2023-03-31 22:49:48',NULL),(3652,NULL,40719,35,2,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',558.00,NULL,NULL,1,'2023-03-31 22:49:49','2023-03-31 22:49:49',NULL);
INSERT INTO `balance_libro` VALUES (3653,NULL,40719,35,2,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',770.00,NULL,NULL,1,'2023-03-31 22:49:50','2023-03-31 22:49:50',NULL),(3654,NULL,40719,35,2,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',829.00,NULL,NULL,1,'2023-03-31 22:49:51','2023-03-31 22:49:51',NULL),(3655,NULL,40719,35,2,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',477.00,NULL,NULL,1,'2023-03-31 22:49:51','2023-03-31 22:49:51',NULL),(3656,NULL,40719,35,2,3666,'App\\Models\\Receipt',3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',494.00,NULL,NULL,1,'2023-03-31 22:49:52','2023-03-31 22:49:52',NULL),(3657,NULL,40719,35,2,3667,'App\\Models\\Receipt',3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',542.00,NULL,NULL,1,'2023-03-31 22:49:53','2023-03-31 22:49:53',NULL),(3658,NULL,40719,35,2,3668,'App\\Models\\Receipt',3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',881.00,NULL,NULL,1,'2023-03-31 22:49:54','2023-03-31 22:49:54',NULL),(3659,NULL,40719,35,2,3669,'App\\Models\\Receipt',3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',744.00,NULL,NULL,1,'2023-03-31 22:49:55','2023-03-31 22:49:55',NULL),(3660,NULL,40719,35,2,3670,'App\\Models\\Receipt',3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',872.00,NULL,NULL,1,'2023-03-31 22:49:56','2023-03-31 22:49:56',NULL),(3661,NULL,40719,35,2,3671,'App\\Models\\Receipt',3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',614.00,NULL,NULL,1,'2023-03-31 22:49:57','2023-03-31 22:49:57',NULL),(3662,NULL,40719,35,2,3672,'App\\Models\\Receipt',3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',464.00,NULL,NULL,1,'2023-03-31 22:49:58','2023-03-31 22:49:58',NULL),(3663,NULL,40719,35,2,3673,'App\\Models\\Receipt',3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',660.00,NULL,NULL,1,'2023-03-31 22:49:59','2023-03-31 22:49:59',NULL),(3664,NULL,40719,35,2,3674,'App\\Models\\Receipt',3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',570.00,NULL,NULL,1,'2023-03-31 22:50:00','2023-03-31 22:50:00',NULL),(3665,NULL,40719,35,2,3675,'App\\Models\\Receipt',3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',730.00,NULL,NULL,1,'2023-03-31 22:50:01','2023-03-31 22:50:01',NULL),(3666,NULL,40719,35,2,3676,'App\\Models\\Receipt',3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',847.00,NULL,NULL,1,'2023-03-31 22:50:02','2023-03-31 22:50:02',NULL),(3667,NULL,40719,35,2,3677,'App\\Models\\Receipt',3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',856.00,NULL,NULL,1,'2023-03-31 22:50:03','2023-03-31 22:50:03',NULL),(3668,NULL,40719,35,2,3678,'App\\Models\\Receipt',3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',582.00,NULL,NULL,1,'2023-03-31 22:50:04','2023-03-31 22:50:04',NULL),(3669,NULL,40719,35,2,3679,'App\\Models\\Receipt',3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',795.00,NULL,NULL,1,'2023-03-31 22:50:05','2023-03-31 22:50:05',NULL),(3670,NULL,40719,35,2,3680,'App\\Models\\Receipt',3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',377.00,NULL,NULL,1,'2023-03-31 22:50:06','2023-03-31 22:50:06',NULL),(3671,NULL,40719,35,2,3681,'App\\Models\\Receipt',3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',314.00,NULL,NULL,1,'2023-03-31 22:50:07','2023-03-31 22:50:07',NULL),(3672,NULL,40719,35,2,3682,'App\\Models\\Receipt',3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',454.00,NULL,NULL,1,'2023-03-31 22:50:08','2023-03-31 22:50:08',NULL),(3673,NULL,40719,35,2,3683,'App\\Models\\Receipt',3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',855.00,NULL,NULL,1,'2023-03-31 22:50:09','2023-03-31 22:50:09',NULL);
INSERT INTO `balance_libro` VALUES (3674,NULL,40719,35,2,3684,'App\\Models\\Receipt',3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',632.00,NULL,NULL,1,'2023-03-31 22:50:10','2023-03-31 22:50:10',NULL),(3675,NULL,40719,35,2,3685,'App\\Models\\Receipt',3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',365.00,NULL,NULL,1,'2023-03-31 22:50:11','2023-03-31 22:50:11',NULL),(3676,NULL,40719,35,2,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',660.00,NULL,NULL,1,'2023-03-31 22:50:12','2023-03-31 22:50:12',NULL),(3677,NULL,40719,35,2,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',853.00,NULL,NULL,1,'2023-03-31 22:50:12','2023-03-31 22:50:12',NULL),(3678,NULL,40719,35,2,3688,'App\\Models\\Receipt',3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',451.00,NULL,NULL,1,'2023-03-31 22:50:13','2023-03-31 22:50:13',NULL),(3679,NULL,40719,35,2,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',414.00,NULL,NULL,1,'2023-03-31 22:50:14','2023-03-31 22:50:14',NULL),(3680,NULL,40719,35,2,3690,'App\\Models\\Receipt',3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',834.00,NULL,NULL,1,'2023-03-31 22:50:15','2023-03-31 22:50:15',NULL),(3681,NULL,40719,35,2,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',418.00,NULL,NULL,1,'2023-03-31 22:50:16','2023-03-31 22:50:16',NULL),(3682,NULL,40719,35,2,3692,'App\\Models\\Receipt',3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',422.00,NULL,NULL,1,'2023-03-31 22:50:17','2023-03-31 22:50:17',NULL),(3683,NULL,40719,35,2,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',741.00,NULL,NULL,1,'2023-03-31 22:50:18','2023-03-31 22:50:18',NULL),(3684,NULL,40719,35,2,3694,'App\\Models\\Receipt',3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',822.00,NULL,NULL,1,'2023-03-31 22:50:19','2023-03-31 22:50:19',NULL),(3685,NULL,40719,35,2,3695,'App\\Models\\Receipt',3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',375.00,NULL,NULL,1,'2023-03-31 22:50:20','2023-03-31 22:50:20',NULL),(3686,NULL,40719,35,2,3696,'App\\Models\\Receipt',3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',900.00,NULL,NULL,1,'2023-03-31 22:50:21','2023-03-31 22:50:21',NULL),(3687,NULL,40719,35,2,3697,'App\\Models\\Receipt',3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',874.00,NULL,NULL,1,'2023-03-31 22:50:22','2023-03-31 22:50:22',NULL),(3688,NULL,40719,35,2,3698,'App\\Models\\Receipt',3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',893.00,NULL,NULL,1,'2023-03-31 22:50:23','2023-03-31 22:50:23',NULL),(3689,NULL,40719,35,2,3699,'App\\Models\\Receipt',3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',776.00,NULL,NULL,1,'2023-03-31 22:50:24','2023-03-31 22:50:24',NULL),(3690,NULL,40719,35,2,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',424.00,NULL,NULL,1,'2023-03-31 22:50:25','2023-03-31 22:50:25',NULL),(3691,NULL,40719,35,2,3701,'App\\Models\\Receipt',3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',676.00,NULL,NULL,1,'2023-03-31 22:50:26','2023-03-31 22:50:26',NULL),(3692,NULL,40719,35,2,3702,'App\\Models\\Receipt',3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',538.00,NULL,NULL,1,'2023-03-31 22:50:27','2023-03-31 22:50:27',NULL),(3693,NULL,40719,35,2,3703,'App\\Models\\Receipt',3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',303.00,NULL,NULL,1,'2023-03-31 22:50:28','2023-03-31 22:50:28',NULL),(3694,NULL,40719,35,2,3704,'App\\Models\\Receipt',3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',806.00,NULL,NULL,1,'2023-03-31 22:50:29','2023-03-31 22:50:29',NULL);
INSERT INTO `balance_libro` VALUES (3695,NULL,40719,35,2,3705,'App\\Models\\Receipt',3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',865.00,NULL,NULL,1,'2023-03-31 22:50:30','2023-03-31 22:50:30',NULL),(3696,NULL,40719,35,2,3706,'App\\Models\\Receipt',3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',774.00,NULL,NULL,1,'2023-03-31 22:50:31','2023-03-31 22:50:31',NULL),(3697,NULL,40719,35,2,3707,'App\\Models\\Receipt',3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',588.00,NULL,NULL,1,'2023-03-31 22:50:32','2023-03-31 22:50:32',NULL),(3698,NULL,40719,35,2,3708,'App\\Models\\Receipt',3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',797.00,NULL,NULL,1,'2023-03-31 22:50:33','2023-03-31 22:50:33',NULL),(3699,NULL,40719,35,2,3709,'App\\Models\\Receipt',3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',445.00,NULL,NULL,1,'2023-03-31 22:50:34','2023-03-31 22:50:34',NULL),(3700,NULL,40719,35,2,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',460.00,NULL,NULL,1,'2023-03-31 22:50:35','2023-03-31 22:50:35',NULL),(3701,NULL,40719,35,2,3711,'App\\Models\\Receipt',3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',379.00,NULL,NULL,1,'2023-03-31 22:50:36','2023-03-31 22:50:36',NULL),(3702,NULL,40719,35,2,3712,'App\\Models\\Receipt',3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',389.00,NULL,NULL,1,'2023-03-31 22:50:37','2023-03-31 22:50:37',NULL),(3703,NULL,40719,35,2,3713,'App\\Models\\Receipt',3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',561.00,NULL,NULL,1,'2023-03-31 22:50:38','2023-03-31 22:50:38',NULL),(3704,NULL,40719,35,2,3714,'App\\Models\\Receipt',3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',476.00,NULL,NULL,1,'2023-03-31 22:50:39','2023-03-31 22:50:39',NULL),(3705,NULL,40719,35,2,3715,'App\\Models\\Receipt',3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',654.00,NULL,NULL,1,'2023-03-31 22:50:40','2023-03-31 22:50:40',NULL),(3706,NULL,40719,35,2,3716,'App\\Models\\Receipt',3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',692.00,NULL,NULL,1,'2023-03-31 22:50:41','2023-03-31 22:50:41',NULL),(3707,NULL,40719,35,2,3717,'App\\Models\\Receipt',3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',606.00,NULL,NULL,1,'2023-03-31 22:50:42','2023-03-31 22:50:42',NULL),(3708,NULL,40719,35,2,3718,'App\\Models\\Receipt',3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',713.00,NULL,NULL,1,'2023-03-31 22:50:43','2023-03-31 22:50:43',NULL),(3709,NULL,40719,35,2,3719,'App\\Models\\Receipt',3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',481.00,NULL,NULL,1,'2023-03-31 22:50:43','2023-03-31 22:50:43',NULL),(3710,NULL,40719,35,2,3720,'App\\Models\\Receipt',3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',358.00,NULL,NULL,1,'2023-03-31 22:50:44','2023-03-31 22:50:44',NULL),(3711,NULL,40719,35,2,3721,'App\\Models\\Receipt',3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',819.00,NULL,NULL,1,'2023-03-31 22:50:45','2023-03-31 22:50:45',NULL),(3712,NULL,40719,35,2,3722,'App\\Models\\Receipt',3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',449.00,NULL,NULL,1,'2023-03-31 22:50:46','2023-03-31 22:50:46',NULL),(3713,NULL,40719,35,2,3723,'App\\Models\\Receipt',3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',417.00,NULL,NULL,1,'2023-03-31 22:50:47','2023-03-31 22:50:47',NULL),(3714,NULL,40719,35,2,3724,'App\\Models\\Receipt',3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',343.00,NULL,NULL,1,'2023-03-31 22:50:48','2023-03-31 22:50:48',NULL),(3715,NULL,40719,35,2,3725,'App\\Models\\Receipt',3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',341.00,NULL,NULL,1,'2023-03-31 22:50:49','2023-03-31 22:50:49',NULL);
INSERT INTO `balance_libro` VALUES (3716,NULL,40719,35,2,3726,'App\\Models\\Receipt',3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',481.00,NULL,NULL,1,'2023-03-31 22:50:50','2023-03-31 22:50:50',NULL),(3717,NULL,40719,35,2,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',525.00,NULL,NULL,1,'2023-03-31 22:50:51','2023-03-31 22:50:51',NULL),(3718,NULL,40719,35,2,3728,'App\\Models\\Receipt',3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',855.00,NULL,NULL,1,'2023-03-31 22:50:52','2023-03-31 22:50:52',NULL),(3719,NULL,40719,35,2,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',489.00,NULL,NULL,1,'2023-03-31 22:50:53','2023-03-31 22:50:53',NULL),(3720,NULL,40719,35,2,3730,'App\\Models\\Receipt',3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',871.00,NULL,NULL,1,'2023-03-31 22:50:54','2023-03-31 22:50:54',NULL),(3721,NULL,40719,35,2,3731,'App\\Models\\Receipt',3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',428.00,NULL,NULL,1,'2023-03-31 22:50:55','2023-03-31 22:50:55',NULL),(3722,NULL,40719,35,2,3732,'App\\Models\\Receipt',3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',679.00,NULL,NULL,1,'2023-03-31 22:50:56','2023-03-31 22:50:56',NULL),(3723,NULL,40719,35,2,3733,'App\\Models\\Receipt',3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',895.00,NULL,NULL,1,'2023-03-31 22:50:57','2023-03-31 22:50:57',NULL),(3724,NULL,40719,35,2,3734,'App\\Models\\Receipt',3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',465.00,NULL,NULL,1,'2023-03-31 22:50:58','2023-03-31 22:50:58',NULL),(3725,NULL,40719,35,2,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',379.00,NULL,NULL,1,'2023-03-31 22:50:59','2023-03-31 22:50:59',NULL),(3726,NULL,40719,35,2,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',836.00,NULL,NULL,1,'2023-03-31 22:51:00','2023-03-31 22:51:00',NULL),(3727,NULL,40719,35,2,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',776.00,NULL,NULL,1,'2023-03-31 22:51:01','2023-03-31 22:51:01',NULL),(3728,NULL,40719,35,2,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',349.00,NULL,NULL,1,'2023-03-31 22:51:02','2023-03-31 22:51:02',NULL),(3729,NULL,40719,35,2,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',551.00,NULL,NULL,1,'2023-03-31 22:51:03','2023-03-31 22:51:03',NULL),(3730,NULL,40719,35,2,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',485.00,NULL,NULL,1,'2023-03-31 22:51:04','2023-03-31 22:51:04',NULL),(3731,NULL,40719,35,2,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',482.00,NULL,NULL,1,'2023-03-31 22:51:05','2023-03-31 22:51:05',NULL),(3732,NULL,40719,35,2,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',308.00,NULL,NULL,1,'2023-03-31 22:51:06','2023-03-31 22:51:06',NULL),(3733,NULL,40719,35,2,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',767.00,NULL,NULL,1,'2023-03-31 22:51:07','2023-03-31 22:51:07',NULL),(3734,NULL,40719,35,2,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',719.00,NULL,NULL,1,'2023-03-31 22:51:07','2023-03-31 22:51:07',NULL),(3735,NULL,40719,35,2,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',402.00,NULL,NULL,1,'2023-03-31 22:51:08','2023-03-31 22:51:08',NULL),(3736,NULL,40719,35,2,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',348.00,NULL,NULL,1,'2023-03-31 22:51:09','2023-03-31 22:51:09',NULL);
INSERT INTO `balance_libro` VALUES (3737,NULL,40719,35,2,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',695.00,NULL,NULL,1,'2023-03-31 22:51:10','2023-03-31 22:51:10',NULL),(3738,NULL,40719,35,2,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',304.00,NULL,NULL,1,'2023-03-31 22:51:11','2023-03-31 22:51:11',NULL),(3739,NULL,40719,35,2,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',863.00,NULL,NULL,1,'2023-03-31 22:51:12','2023-03-31 22:51:12',NULL),(3740,NULL,40719,35,2,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',672.00,NULL,NULL,1,'2023-03-31 22:51:13','2023-03-31 22:51:13',NULL),(3741,NULL,40719,35,2,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',900.00,NULL,NULL,1,'2023-03-31 22:51:14','2023-03-31 22:51:14',NULL),(3742,NULL,40719,35,2,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',423.00,NULL,NULL,1,'2023-03-31 22:51:15','2023-03-31 22:51:15',NULL),(3743,NULL,40719,35,2,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',338.00,NULL,NULL,1,'2023-03-31 22:51:16','2023-03-31 22:51:16',NULL),(3744,NULL,40719,35,2,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',772.00,NULL,NULL,1,'2023-03-31 22:51:17','2023-03-31 22:51:17',NULL),(3745,NULL,40719,35,2,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',778.00,NULL,NULL,1,'2023-03-31 22:51:18','2023-03-31 22:51:18',NULL),(3746,NULL,40719,35,2,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',809.00,NULL,NULL,1,'2023-03-31 22:51:19','2023-03-31 22:51:19',NULL),(3747,NULL,40719,35,2,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',827.00,NULL,NULL,1,'2023-03-31 22:51:20','2023-03-31 22:51:20',NULL),(3748,NULL,40719,35,2,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',580.00,NULL,NULL,1,'2023-03-31 22:51:21','2023-03-31 22:51:21',NULL),(3749,NULL,40719,35,2,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',732.00,NULL,NULL,1,'2023-03-31 22:51:22','2023-03-31 22:51:22',NULL),(3750,NULL,40719,35,2,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',728.00,NULL,NULL,1,'2023-03-31 22:51:23','2023-03-31 22:51:23',NULL),(3751,NULL,40719,35,2,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',330.00,NULL,NULL,1,'2023-03-31 22:51:23','2023-03-31 22:51:23',NULL),(3752,NULL,40719,35,2,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',503.00,NULL,NULL,1,'2023-03-31 22:51:24','2023-03-31 22:51:24',NULL),(3753,NULL,40719,35,2,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',376.00,NULL,NULL,1,'2023-03-31 22:51:26','2023-03-31 22:51:26',NULL),(3754,NULL,40719,35,2,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',303.00,NULL,NULL,1,'2023-03-31 22:51:27','2023-03-31 22:51:27',NULL),(3755,NULL,40719,35,2,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',685.00,NULL,NULL,1,'2023-03-31 22:51:27','2023-03-31 22:51:27',NULL),(3756,NULL,40719,35,2,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',593.00,NULL,NULL,1,'2023-03-31 22:51:28','2023-03-31 22:51:28',NULL),(3757,NULL,40719,35,2,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',866.00,NULL,NULL,1,'2023-03-31 22:51:29','2023-03-31 22:51:29',NULL);
INSERT INTO `balance_libro` VALUES (3758,NULL,40719,35,2,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',395.00,NULL,NULL,1,'2023-03-31 22:51:30','2023-03-31 22:51:30',NULL),(3759,NULL,40719,35,2,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',887.00,NULL,NULL,1,'2023-03-31 22:51:31','2023-03-31 22:51:31',NULL),(3760,NULL,40719,35,2,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',645.00,NULL,NULL,1,'2023-03-31 22:51:32','2023-03-31 22:51:32',NULL),(3761,NULL,40719,35,2,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',482.00,NULL,NULL,1,'2023-03-31 22:51:33','2023-03-31 22:51:33',NULL),(3762,NULL,40719,35,2,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',420.00,NULL,NULL,1,'2023-03-31 22:51:34','2023-03-31 22:51:34',NULL),(3763,NULL,40719,35,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',533.00,NULL,NULL,1,'2023-03-31 22:51:35','2023-03-31 22:51:35',NULL),(3764,NULL,40719,35,2,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',335.00,NULL,NULL,1,'2023-03-31 22:51:36','2023-03-31 22:51:36',NULL),(3765,NULL,40719,35,2,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',495.00,NULL,NULL,1,'2023-03-31 22:51:37','2023-03-31 22:51:37',NULL),(3766,NULL,40719,35,2,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',870.00,NULL,NULL,1,'2023-03-31 22:51:38','2023-03-31 22:51:38',NULL),(3767,NULL,40719,35,2,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',473.00,NULL,NULL,1,'2023-03-31 22:51:39','2023-03-31 22:51:39',NULL),(3768,NULL,40719,35,2,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',551.00,NULL,NULL,1,'2023-03-31 22:51:40','2023-03-31 22:51:40',NULL),(3769,NULL,40719,35,2,3779,'App\\Models\\Receipt',3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',323.00,NULL,NULL,1,'2023-03-31 22:51:41','2023-03-31 22:51:41',NULL),(3770,NULL,40719,35,2,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',360.00,NULL,NULL,1,'2023-03-31 22:51:41','2023-03-31 22:51:41',NULL),(3771,NULL,40719,35,2,3781,'App\\Models\\Receipt',3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',464.00,NULL,NULL,1,'2023-03-31 22:51:42','2023-03-31 22:51:42',NULL),(3772,NULL,40719,35,2,3782,'App\\Models\\Receipt',3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',643.00,NULL,NULL,1,'2023-03-31 22:51:43','2023-03-31 22:51:43',NULL),(3773,NULL,40719,35,2,3783,'App\\Models\\Receipt',3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',533.00,NULL,NULL,1,'2023-03-31 22:51:44','2023-03-31 22:51:44',NULL),(3774,NULL,40719,35,2,3784,'App\\Models\\Receipt',3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',501.00,NULL,NULL,1,'2023-03-31 22:51:45','2023-03-31 22:51:45',NULL),(3775,NULL,40719,35,2,3785,'App\\Models\\Receipt',3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',651.00,NULL,NULL,1,'2023-03-31 22:51:46','2023-03-31 22:51:46',NULL),(3776,NULL,40719,35,2,3786,'App\\Models\\Receipt',3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',893.00,NULL,NULL,1,'2023-03-31 22:51:47','2023-03-31 22:51:47',NULL),(3777,NULL,40719,35,2,3787,'App\\Models\\Receipt',3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',362.00,NULL,NULL,1,'2023-03-31 22:51:48','2023-03-31 22:51:48',NULL),(3778,NULL,40719,35,2,3788,'App\\Models\\Receipt',3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',428.00,NULL,NULL,1,'2023-03-31 22:51:49','2023-03-31 22:51:49',NULL);
INSERT INTO `balance_libro` VALUES (3779,NULL,40719,35,2,3789,'App\\Models\\Receipt',3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',801.00,NULL,NULL,1,'2023-03-31 22:51:50','2023-03-31 22:51:50',NULL),(3780,NULL,40719,35,2,3790,'App\\Models\\Receipt',3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',340.00,NULL,NULL,1,'2023-03-31 22:51:51','2023-03-31 22:51:51',NULL),(3781,NULL,40719,35,2,3791,'App\\Models\\Receipt',3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',595.00,NULL,NULL,1,'2023-03-31 22:51:52','2023-03-31 22:51:52',NULL),(3782,NULL,40719,35,2,3792,'App\\Models\\Receipt',3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',606.00,NULL,NULL,1,'2023-03-31 22:51:53','2023-03-31 22:51:53',NULL),(3783,NULL,40719,35,2,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',826.00,NULL,NULL,1,'2023-03-31 22:51:54','2023-03-31 22:51:54',NULL),(3784,NULL,40719,35,2,3794,'App\\Models\\Receipt',3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',546.00,NULL,NULL,1,'2023-03-31 22:51:55','2023-03-31 22:51:55',NULL),(3785,NULL,40719,35,2,3795,'App\\Models\\Receipt',3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',529.00,NULL,NULL,1,'2023-03-31 22:51:55','2023-03-31 22:51:55',NULL),(3786,NULL,40719,35,2,3796,'App\\Models\\Receipt',3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',329.00,NULL,NULL,1,'2023-03-31 22:51:56','2023-03-31 22:51:56',NULL),(3787,NULL,40719,35,2,3797,'App\\Models\\Receipt',3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',621.00,NULL,NULL,1,'2023-03-31 22:51:57','2023-03-31 22:51:57',NULL),(3788,NULL,40719,35,2,3798,'App\\Models\\Receipt',3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',633.00,NULL,NULL,1,'2023-03-31 22:51:58','2023-03-31 22:51:58',NULL),(3789,NULL,40719,35,2,3799,'App\\Models\\Receipt',3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',892.00,NULL,NULL,1,'2023-03-31 22:51:59','2023-03-31 22:51:59',NULL),(3790,NULL,40719,35,2,3800,'App\\Models\\Receipt',3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',815.00,NULL,NULL,1,'2023-03-31 22:52:00','2023-03-31 22:52:00',NULL),(3791,NULL,40719,35,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',448.00,NULL,NULL,1,'2023-03-31 22:52:01','2023-03-31 22:52:01',NULL),(3792,NULL,40719,35,2,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',660.00,NULL,NULL,1,'2023-03-31 22:52:02','2023-03-31 22:52:02',NULL),(3793,NULL,40719,35,2,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',311.00,NULL,NULL,1,'2023-03-31 22:52:03','2023-03-31 22:52:03',NULL),(3794,NULL,40719,35,2,3804,'App\\Models\\Receipt',3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',673.00,NULL,NULL,1,'2023-03-31 22:52:04','2023-03-31 22:52:04',NULL),(3795,NULL,40719,35,2,3805,'App\\Models\\Receipt',3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',768.00,NULL,NULL,1,'2023-03-31 22:52:05','2023-03-31 22:52:05',NULL),(3796,NULL,40719,35,2,3806,'App\\Models\\Receipt',3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',820.00,NULL,NULL,1,'2023-03-31 22:52:06','2023-03-31 22:52:06',NULL),(3797,NULL,40719,35,2,3807,'App\\Models\\Receipt',3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',399.00,NULL,NULL,1,'2023-03-31 22:52:07','2023-03-31 22:52:07',NULL),(3798,NULL,40719,35,2,3808,'App\\Models\\Receipt',3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',316.00,NULL,NULL,1,'2023-03-31 22:52:08','2023-03-31 22:52:08',NULL),(3799,NULL,40719,35,2,3809,'App\\Models\\Receipt',3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',816.00,NULL,NULL,1,'2023-03-31 22:52:09','2023-03-31 22:52:09',NULL);
INSERT INTO `balance_libro` VALUES (3800,NULL,40719,35,2,3810,'App\\Models\\Receipt',3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',579.00,NULL,NULL,1,'2023-03-31 22:52:10','2023-03-31 22:52:10',NULL),(3801,NULL,40719,35,2,3811,'App\\Models\\Receipt',3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',854.00,NULL,NULL,1,'2023-03-31 22:52:11','2023-03-31 22:52:11',NULL),(3802,NULL,40719,35,2,3812,'App\\Models\\Receipt',3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',642.00,NULL,NULL,1,'2023-03-31 22:52:11','2023-03-31 22:52:11',NULL),(3803,NULL,40719,35,2,3813,'App\\Models\\Receipt',3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',881.00,NULL,NULL,1,'2023-03-31 22:52:12','2023-03-31 22:52:12',NULL),(3804,NULL,40719,35,2,3814,'App\\Models\\Receipt',3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',387.00,NULL,NULL,1,'2023-03-31 22:52:13','2023-03-31 22:52:13',NULL),(3805,NULL,40719,35,2,3815,'App\\Models\\Receipt',3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',863.00,NULL,NULL,1,'2023-03-31 22:52:14','2023-03-31 22:52:14',NULL),(3806,NULL,40719,35,2,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',750.00,NULL,NULL,1,'2023-03-31 22:52:15','2023-03-31 22:52:15',NULL),(3807,NULL,40719,35,2,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',616.00,NULL,NULL,1,'2023-03-31 22:52:16','2023-03-31 22:52:16',NULL),(3808,NULL,40719,35,2,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',478.00,NULL,NULL,1,'2023-03-31 22:52:17','2023-03-31 22:52:17',NULL),(3809,NULL,40719,35,2,3819,'App\\Models\\Receipt',3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',376.00,NULL,NULL,1,'2023-03-31 22:52:18','2023-03-31 22:52:18',NULL),(3810,NULL,40719,35,2,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',585.00,NULL,NULL,1,'2023-03-31 22:52:19','2023-03-31 22:52:19',NULL),(3811,NULL,40719,35,2,3821,'App\\Models\\Receipt',3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',569.00,NULL,NULL,1,'2023-03-31 22:52:20','2023-03-31 22:52:20',NULL),(3812,NULL,40719,35,2,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',530.00,NULL,NULL,1,'2023-03-31 22:52:21','2023-03-31 22:52:21',NULL),(3813,NULL,40719,35,2,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',505.00,NULL,NULL,1,'2023-03-31 22:52:22','2023-03-31 22:52:22',NULL),(3814,NULL,40719,35,2,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',655.00,NULL,NULL,1,'2023-03-31 22:52:23','2023-03-31 22:52:23',NULL),(3815,NULL,40719,35,2,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',486.00,NULL,NULL,1,'2023-03-31 22:52:24','2023-03-31 22:52:24',NULL),(3816,NULL,40719,35,2,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',491.00,NULL,NULL,1,'2023-03-31 22:52:25','2023-03-31 22:52:25',NULL),(3817,NULL,40719,35,2,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',784.00,NULL,NULL,1,'2023-03-31 22:52:26','2023-03-31 22:52:26',NULL),(3818,NULL,40719,35,2,3828,'App\\Models\\Receipt',3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',393.00,NULL,NULL,1,'2023-03-31 22:52:27','2023-03-31 22:52:27',NULL),(3819,NULL,40719,35,2,3829,'App\\Models\\Receipt',3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',564.00,NULL,NULL,1,'2023-03-31 22:52:28','2023-03-31 22:52:28',NULL),(3820,NULL,40719,35,2,3830,'App\\Models\\Receipt',3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',630.00,NULL,NULL,1,'2023-03-31 22:52:28','2023-03-31 22:52:28',NULL);
INSERT INTO `balance_libro` VALUES (3821,NULL,40719,35,2,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',485.00,NULL,NULL,1,'2023-03-31 22:52:29','2023-03-31 22:52:29',NULL),(3822,NULL,40719,35,2,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',330.00,NULL,NULL,1,'2023-03-31 22:52:30','2023-03-31 22:52:30',NULL),(3823,NULL,40719,35,2,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',809.00,NULL,NULL,1,'2023-03-31 22:52:31','2023-03-31 22:52:31',NULL),(3824,NULL,40719,35,2,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',687.00,NULL,NULL,1,'2023-03-31 22:52:32','2023-03-31 22:52:32',NULL),(3825,NULL,40719,35,2,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',872.00,NULL,NULL,1,'2023-03-31 22:52:33','2023-03-31 22:52:33',NULL),(3826,NULL,40719,35,2,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',889.00,NULL,NULL,1,'2023-03-31 22:52:34','2023-03-31 22:52:34',NULL),(3827,NULL,40719,35,2,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',444.00,NULL,NULL,1,'2023-03-31 22:52:35','2023-03-31 22:52:35',NULL),(3828,NULL,40719,35,2,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',446.00,NULL,NULL,1,'2023-03-31 22:52:36','2023-03-31 22:52:36',NULL),(3829,NULL,40719,35,2,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',489.00,NULL,NULL,1,'2023-03-31 22:52:37','2023-03-31 22:52:37',NULL),(3830,NULL,40719,35,2,3840,'App\\Models\\Receipt',3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',715.00,NULL,NULL,1,'2023-03-31 22:52:38','2023-03-31 22:52:38',NULL),(3831,NULL,40719,35,2,3841,'App\\Models\\Receipt',3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',506.00,NULL,NULL,1,'2023-03-31 22:52:39','2023-03-31 22:52:39',NULL),(3832,NULL,40719,35,2,3842,'App\\Models\\Receipt',3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',374.00,NULL,NULL,1,'2023-03-31 22:52:40','2023-03-31 22:52:40',NULL),(3833,NULL,40719,35,2,3843,'App\\Models\\Receipt',3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',891.00,NULL,NULL,1,'2023-03-31 22:52:41','2023-03-31 22:52:41',NULL),(3834,NULL,40719,35,2,3844,'App\\Models\\Receipt',3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',630.00,NULL,NULL,1,'2023-03-31 22:52:41','2023-03-31 22:52:41',NULL),(3835,NULL,40719,35,2,3845,'App\\Models\\Receipt',3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',497.00,NULL,NULL,1,'2023-03-31 22:52:42','2023-03-31 22:52:42',NULL),(3836,NULL,40719,35,2,3846,'App\\Models\\Receipt',3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',854.00,NULL,NULL,1,'2023-03-31 22:52:43','2023-03-31 22:52:43',NULL),(3837,NULL,40719,35,2,3847,'App\\Models\\Receipt',3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',798.00,NULL,NULL,1,'2023-03-31 22:52:44','2023-03-31 22:52:44',NULL),(3838,NULL,40719,35,2,3848,'App\\Models\\Receipt',3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',429.00,NULL,NULL,1,'2023-03-31 22:52:45','2023-03-31 22:52:45',NULL),(3839,NULL,40719,35,2,3849,'App\\Models\\Receipt',3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',591.00,NULL,NULL,1,'2023-03-31 22:52:46','2023-03-31 22:52:46',NULL),(3840,NULL,40719,35,2,3850,'App\\Models\\Receipt',3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',795.00,NULL,NULL,1,'2023-03-31 22:52:47','2023-03-31 22:52:47',NULL),(3841,NULL,40719,35,2,3851,'App\\Models\\Receipt',3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',777.00,NULL,NULL,1,'2023-03-31 22:52:48','2023-03-31 22:52:48',NULL);
INSERT INTO `balance_libro` VALUES (3842,NULL,40719,35,2,3852,'App\\Models\\Receipt',3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',431.00,NULL,NULL,1,'2023-03-31 22:52:49','2023-03-31 22:52:49',NULL),(3843,NULL,40719,35,2,3853,'App\\Models\\Receipt',3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',403.00,NULL,NULL,1,'2023-03-31 22:52:50','2023-03-31 22:52:50',NULL),(3844,NULL,40719,35,2,3854,'App\\Models\\Receipt',3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',375.00,NULL,NULL,1,'2023-03-31 22:52:51','2023-03-31 22:52:51',NULL),(3845,NULL,40719,35,2,3855,'App\\Models\\Receipt',3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',700.00,NULL,NULL,1,'2023-03-31 22:52:52','2023-03-31 22:52:52',NULL),(3846,NULL,40719,35,2,3856,'App\\Models\\Receipt',3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',710.00,NULL,NULL,1,'2023-03-31 22:52:52','2023-03-31 22:52:52',NULL),(3847,NULL,40719,35,2,3857,'App\\Models\\Receipt',3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',704.00,NULL,NULL,1,'2023-03-31 22:52:53','2023-03-31 22:52:53',NULL),(3848,NULL,40719,35,2,3858,'App\\Models\\Receipt',3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',376.00,NULL,NULL,1,'2023-03-31 22:52:54','2023-03-31 22:52:54',NULL),(3849,NULL,40719,35,2,3859,'App\\Models\\Receipt',3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',323.00,NULL,NULL,1,'2023-03-31 22:52:55','2023-03-31 22:52:55',NULL),(3850,NULL,40719,35,2,3860,'App\\Models\\Receipt',3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',510.00,NULL,NULL,1,'2023-03-31 22:52:56','2023-03-31 22:52:56',NULL),(3851,NULL,40719,35,2,3861,'App\\Models\\Receipt',3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',806.00,NULL,NULL,1,'2023-03-31 22:52:57','2023-03-31 22:52:57',NULL),(3852,NULL,40719,35,2,3862,'App\\Models\\Receipt',3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',455.00,NULL,NULL,1,'2023-03-31 22:52:58','2023-03-31 22:52:58',NULL),(3853,NULL,40719,35,2,3863,'App\\Models\\Receipt',3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',715.00,NULL,NULL,1,'2023-03-31 22:52:59','2023-03-31 22:52:59',NULL),(3854,NULL,40719,35,2,3864,'App\\Models\\Receipt',3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',463.00,NULL,NULL,1,'2023-03-31 22:53:00','2023-03-31 22:53:00',NULL),(3855,NULL,40719,35,2,3865,'App\\Models\\Receipt',3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',500.00,NULL,NULL,1,'2023-03-31 22:53:01','2023-03-31 22:53:01',NULL),(3856,NULL,40719,35,2,3866,'App\\Models\\Receipt',3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',705.00,NULL,NULL,1,'2023-03-31 22:53:02','2023-03-31 22:53:02',NULL),(3857,NULL,40719,35,2,3867,'App\\Models\\Receipt',3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',687.00,NULL,NULL,1,'2023-03-31 22:53:03','2023-03-31 22:53:03',NULL),(3858,NULL,40719,35,2,3868,'App\\Models\\Receipt',3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',460.00,NULL,NULL,1,'2023-03-31 22:53:04','2023-03-31 22:53:04',NULL),(3859,NULL,40719,35,2,3869,'App\\Models\\Receipt',3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',746.00,NULL,NULL,1,'2023-03-31 22:53:05','2023-03-31 22:53:05',NULL),(3860,NULL,40719,35,2,3870,'App\\Models\\Receipt',3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',798.00,NULL,NULL,1,'2023-03-31 22:53:06','2023-03-31 22:53:06',NULL),(3861,NULL,40719,35,2,3871,'App\\Models\\Receipt',3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',584.00,NULL,NULL,1,'2023-03-31 22:53:07','2023-03-31 22:53:07',NULL),(3862,NULL,40719,35,2,3872,'App\\Models\\Receipt',3872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',464.00,NULL,NULL,1,'2023-03-31 22:53:07','2023-03-31 22:53:07',NULL);
INSERT INTO `balance_libro` VALUES (3863,NULL,40719,35,2,3873,'App\\Models\\Receipt',3873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',439.00,NULL,NULL,1,'2023-03-31 22:53:08','2023-03-31 22:53:08',NULL),(3864,NULL,40719,35,2,3874,'App\\Models\\Receipt',3874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',707.00,NULL,NULL,1,'2023-03-31 22:53:09','2023-03-31 22:53:09',NULL),(3865,NULL,40719,35,2,3875,'App\\Models\\Receipt',3875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',807.00,NULL,NULL,1,'2023-03-31 22:53:10','2023-03-31 22:53:10',NULL),(3866,NULL,40719,35,2,3876,'App\\Models\\Receipt',3876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',459.00,NULL,NULL,1,'2023-03-31 22:53:11','2023-03-31 22:53:11',NULL),(3867,NULL,40719,35,2,3877,'App\\Models\\Receipt',3877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',335.00,NULL,NULL,1,'2023-03-31 22:53:12','2023-03-31 22:53:12',NULL),(3868,NULL,40719,35,2,3878,'App\\Models\\Receipt',3878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',450.00,NULL,NULL,1,'2023-03-31 22:53:13','2023-03-31 22:53:13',NULL),(3869,NULL,40719,35,2,3879,'App\\Models\\Receipt',3879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',791.00,NULL,NULL,1,'2023-03-31 22:53:14','2023-03-31 22:53:14',NULL),(3870,NULL,40719,35,2,3880,'App\\Models\\Receipt',3880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',451.00,NULL,NULL,1,'2023-03-31 22:53:15','2023-03-31 22:53:15',NULL),(3871,NULL,40719,35,2,3881,'App\\Models\\Receipt',3881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',898.00,NULL,NULL,1,'2023-03-31 22:53:16','2023-03-31 22:53:16',NULL),(3872,NULL,40719,35,2,3882,'App\\Models\\Receipt',3882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',474.00,NULL,NULL,1,'2023-03-31 22:53:17','2023-03-31 22:53:17',NULL),(3873,NULL,40719,35,2,3883,'App\\Models\\Receipt',3883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',438.00,NULL,NULL,1,'2023-03-31 22:53:18','2023-03-31 22:53:18',NULL),(3874,NULL,40719,35,2,3884,'App\\Models\\Receipt',3884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',427.00,NULL,NULL,1,'2023-03-31 22:53:19','2023-03-31 22:53:19',NULL),(3875,NULL,40719,35,2,3885,'App\\Models\\Receipt',3885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',743.00,NULL,NULL,1,'2023-03-31 22:53:20','2023-03-31 22:53:20',NULL),(3876,NULL,40719,35,2,3886,'App\\Models\\Receipt',3886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',626.00,NULL,NULL,1,'2023-03-31 22:53:21','2023-03-31 22:53:21',NULL),(3877,NULL,40719,35,2,3887,'App\\Models\\Receipt',3887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',472.00,NULL,NULL,1,'2023-03-31 22:53:22','2023-03-31 22:53:22',NULL),(3878,NULL,40719,35,2,3888,'App\\Models\\Receipt',3888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',613.00,NULL,NULL,1,'2023-03-31 22:53:23','2023-03-31 22:53:23',NULL),(3879,NULL,40719,35,2,3889,'App\\Models\\Receipt',3889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',503.00,NULL,NULL,1,'2023-03-31 22:53:24','2023-03-31 22:53:24',NULL),(3880,NULL,40719,35,2,3890,'App\\Models\\Receipt',3890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',338.00,NULL,NULL,1,'2023-03-31 22:53:24','2023-03-31 22:53:24',NULL),(3881,NULL,40719,35,2,3891,'App\\Models\\Receipt',3891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',666.00,NULL,NULL,1,'2023-03-31 22:53:25','2023-03-31 22:53:25',NULL),(3882,NULL,40719,35,2,3892,'App\\Models\\Receipt',3892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',610.00,NULL,NULL,1,'2023-03-31 22:53:26','2023-03-31 22:53:26',NULL),(3883,NULL,40719,35,2,3893,'App\\Models\\Receipt',3893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',364.00,NULL,NULL,1,'2023-03-31 22:53:27','2023-03-31 22:53:27',NULL);
INSERT INTO `balance_libro` VALUES (3884,NULL,40719,35,2,3894,'App\\Models\\Receipt',3894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',660.00,NULL,NULL,1,'2023-03-31 22:53:28','2023-03-31 22:53:28',NULL),(3885,NULL,40719,35,2,3895,'App\\Models\\Receipt',3895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',384.00,NULL,NULL,1,'2023-03-31 22:53:29','2023-03-31 22:53:29',NULL),(3886,NULL,40719,35,2,3896,'App\\Models\\Receipt',3896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',537.00,NULL,NULL,1,'2023-03-31 22:53:30','2023-03-31 22:53:30',NULL),(3887,NULL,40719,35,2,3897,'App\\Models\\Receipt',3897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',688.00,NULL,NULL,1,'2023-03-31 22:53:31','2023-03-31 22:53:31',NULL),(3888,NULL,40719,35,2,3898,'App\\Models\\Receipt',3898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',730.00,NULL,NULL,1,'2023-03-31 22:53:32','2023-03-31 22:53:32',NULL),(3889,NULL,40719,35,2,3899,'App\\Models\\Receipt',3899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',706.00,NULL,NULL,1,'2023-03-31 22:53:33','2023-03-31 22:53:33',NULL),(3890,NULL,40719,35,2,3900,'App\\Models\\Receipt',3900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',639.00,NULL,NULL,1,'2023-03-31 22:53:34','2023-03-31 22:53:34',NULL),(3891,NULL,40719,35,2,3901,'App\\Models\\Receipt',3901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',562.00,NULL,NULL,1,'2023-03-31 22:53:35','2023-03-31 22:53:35',NULL),(3892,NULL,40719,35,2,3902,'App\\Models\\Receipt',3902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',794.00,NULL,NULL,1,'2023-03-31 22:53:36','2023-03-31 22:53:36',NULL),(3893,NULL,40719,35,2,3903,'App\\Models\\Receipt',3903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',489.00,NULL,NULL,1,'2023-03-31 22:53:37','2023-03-31 22:53:37',NULL),(3894,NULL,40719,35,2,3904,'App\\Models\\Receipt',3904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',818.00,NULL,NULL,1,'2023-03-31 22:53:38','2023-03-31 22:53:38',NULL),(3895,NULL,40719,35,2,3905,'App\\Models\\Receipt',3905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',849.00,NULL,NULL,1,'2023-03-31 22:53:39','2023-03-31 22:53:39',NULL),(3896,NULL,40719,35,2,3906,'App\\Models\\Receipt',3906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',710.00,NULL,NULL,1,'2023-03-31 22:53:40','2023-03-31 22:53:40',NULL),(3897,NULL,40719,35,2,3907,'App\\Models\\Receipt',3907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',765.00,NULL,NULL,1,'2023-03-31 22:53:41','2023-03-31 22:53:41',NULL),(3898,NULL,40719,35,2,3908,'App\\Models\\Receipt',3908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',825.00,NULL,NULL,1,'2023-03-31 22:53:42','2023-03-31 22:53:42',NULL),(3899,NULL,40719,35,2,3909,'App\\Models\\Receipt',3909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',326.00,NULL,NULL,1,'2023-03-31 22:53:42','2023-03-31 22:53:42',NULL),(3900,NULL,40719,35,2,3910,'App\\Models\\Receipt',3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',473.00,NULL,NULL,1,'2023-03-31 22:53:43','2023-03-31 22:53:43',NULL),(3901,NULL,40719,35,2,3911,'App\\Models\\Receipt',3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',508.00,NULL,NULL,1,'2023-03-31 22:53:44','2023-03-31 22:53:44',NULL),(3902,NULL,40719,35,2,3912,'App\\Models\\Receipt',3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',673.00,NULL,NULL,1,'2023-03-31 22:53:45','2023-03-31 22:53:45',NULL),(3903,NULL,40719,35,2,3913,'App\\Models\\Receipt',3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',436.00,NULL,NULL,1,'2023-03-31 22:53:46','2023-03-31 22:53:46',NULL),(3904,NULL,40719,35,2,3914,'App\\Models\\Receipt',3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',435.00,NULL,NULL,1,'2023-03-31 22:53:47','2023-03-31 22:53:47',NULL);
INSERT INTO `balance_libro` VALUES (3905,NULL,40719,35,2,3915,'App\\Models\\Receipt',3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',460.00,NULL,NULL,1,'2023-03-31 22:53:48','2023-03-31 22:53:48',NULL),(3906,NULL,40719,35,2,3916,'App\\Models\\Receipt',3916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',634.00,NULL,NULL,1,'2023-03-31 22:53:49','2023-03-31 22:53:49',NULL),(3907,NULL,40719,35,2,3917,'App\\Models\\Receipt',3917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',760.00,NULL,NULL,1,'2023-03-31 22:53:50','2023-03-31 22:53:50',NULL),(3908,NULL,40719,35,2,3918,'App\\Models\\Receipt',3918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',767.00,NULL,NULL,1,'2023-03-31 22:53:51','2023-03-31 22:53:51',NULL),(3909,NULL,40719,35,2,3919,'App\\Models\\Receipt',3919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',524.00,NULL,NULL,1,'2023-03-31 22:53:52','2023-03-31 22:53:52',NULL),(3910,NULL,40719,35,2,3920,'App\\Models\\Receipt',3920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',693.00,NULL,NULL,1,'2023-03-31 22:53:53','2023-03-31 22:53:53',NULL),(3911,NULL,40719,35,2,3921,'App\\Models\\Receipt',3921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',448.00,NULL,NULL,1,'2023-03-31 22:53:54','2023-03-31 22:53:54',NULL),(3912,NULL,40719,35,2,3922,'App\\Models\\Receipt',3922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',326.00,NULL,NULL,1,'2023-03-31 22:53:55','2023-03-31 22:53:55',NULL),(3913,NULL,40719,35,2,3923,'App\\Models\\Receipt',3923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',464.00,NULL,NULL,1,'2023-03-31 22:53:55','2023-03-31 22:53:55',NULL),(3914,NULL,40719,35,2,3924,'App\\Models\\Receipt',3924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',813.00,NULL,NULL,1,'2023-03-31 22:53:56','2023-03-31 22:53:56',NULL),(3915,NULL,40719,35,2,3925,'App\\Models\\Receipt',3925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',837.00,NULL,NULL,1,'2023-03-31 22:53:57','2023-03-31 22:53:57',NULL),(3916,NULL,40719,35,2,3926,'App\\Models\\Receipt',3926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',479.00,NULL,NULL,1,'2023-03-31 22:53:58','2023-03-31 22:53:58',NULL),(3917,NULL,40719,35,2,3927,'App\\Models\\Receipt',3927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',678.00,NULL,NULL,1,'2023-03-31 22:53:59','2023-03-31 22:53:59',NULL),(3918,NULL,40719,35,2,3928,'App\\Models\\Receipt',3928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',759.00,NULL,NULL,1,'2023-03-31 22:54:00','2023-03-31 22:54:00',NULL),(3919,NULL,40719,35,2,3929,'App\\Models\\Receipt',3929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',550.00,NULL,NULL,1,'2023-03-31 22:54:01','2023-03-31 22:54:01',NULL),(3920,NULL,40719,35,2,3930,'App\\Models\\Receipt',3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',702.00,NULL,NULL,1,'2023-03-31 22:54:02','2023-03-31 22:54:02',NULL),(3921,NULL,40719,35,2,3931,'App\\Models\\Receipt',3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',796.00,NULL,NULL,1,'2023-03-31 22:54:03','2023-03-31 22:54:03',NULL),(3922,NULL,40719,35,2,3932,'App\\Models\\Receipt',3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',806.00,NULL,NULL,1,'2023-03-31 22:54:04','2023-03-31 22:54:04',NULL),(3923,NULL,40719,35,2,3933,'App\\Models\\Receipt',3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',824.00,NULL,NULL,1,'2023-03-31 22:54:05','2023-03-31 22:54:05',NULL),(3924,NULL,40719,35,2,3934,'App\\Models\\Receipt',3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',877.00,NULL,NULL,1,'2023-03-31 22:54:06','2023-03-31 22:54:06',NULL),(3925,NULL,40719,35,2,3935,'App\\Models\\Receipt',3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',330.00,NULL,NULL,1,'2023-03-31 22:54:07','2023-03-31 22:54:07',NULL);
INSERT INTO `balance_libro` VALUES (3926,NULL,40719,35,2,3936,'App\\Models\\Receipt',3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',743.00,NULL,NULL,1,'2023-03-31 22:54:08','2023-03-31 22:54:08',NULL),(3927,NULL,40719,35,2,3937,'App\\Models\\Receipt',3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',791.00,NULL,NULL,1,'2023-03-31 22:54:09','2023-03-31 22:54:09',NULL),(3928,NULL,40719,35,2,3938,'App\\Models\\Receipt',3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',360.00,NULL,NULL,1,'2023-03-31 22:54:10','2023-03-31 22:54:10',NULL),(3929,NULL,40719,35,2,3939,'App\\Models\\Receipt',3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',697.00,NULL,NULL,1,'2023-03-31 22:54:11','2023-03-31 22:54:11',NULL),(3930,NULL,40719,35,2,3940,'App\\Models\\Receipt',3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',629.00,NULL,NULL,1,'2023-03-31 22:54:12','2023-03-31 22:54:12',NULL),(3931,NULL,40719,35,2,3941,'App\\Models\\Receipt',3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',528.00,NULL,NULL,1,'2023-03-31 22:54:13','2023-03-31 22:54:13',NULL),(3932,NULL,40719,35,2,3942,'App\\Models\\Receipt',3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',482.00,NULL,NULL,1,'2023-03-31 22:54:14','2023-03-31 22:54:14',NULL),(3933,NULL,40719,35,2,3943,'App\\Models\\Receipt',3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',848.00,NULL,NULL,1,'2023-03-31 22:54:14','2023-03-31 22:54:14',NULL),(3934,NULL,40719,35,2,3944,'App\\Models\\Receipt',3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',351.00,NULL,NULL,1,'2023-03-31 22:54:15','2023-03-31 22:54:15',NULL),(3935,NULL,40719,35,2,3945,'App\\Models\\Receipt',3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',852.00,NULL,NULL,1,'2023-03-31 22:54:16','2023-03-31 22:54:16',NULL),(3936,NULL,40719,35,2,3946,'App\\Models\\Receipt',3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',555.00,NULL,NULL,1,'2023-03-31 22:54:17','2023-03-31 22:54:17',NULL),(3937,NULL,40719,35,2,3947,'App\\Models\\Receipt',3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',432.00,NULL,NULL,1,'2023-03-31 22:54:18','2023-03-31 22:54:18',NULL),(3938,NULL,40719,35,2,3948,'App\\Models\\Receipt',3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',355.00,NULL,NULL,1,'2023-03-31 22:54:19','2023-03-31 22:54:19',NULL),(3939,NULL,40719,35,2,3949,'App\\Models\\Receipt',3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',666.00,NULL,NULL,1,'2023-03-31 22:54:20','2023-03-31 22:54:20',NULL),(3940,NULL,40719,35,2,3950,'App\\Models\\Receipt',3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',582.00,NULL,NULL,1,'2023-03-31 22:54:21','2023-03-31 22:54:21',NULL),(3941,NULL,40719,35,2,3951,'App\\Models\\Receipt',3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',675.00,NULL,NULL,1,'2023-03-31 22:54:22','2023-03-31 22:54:22',NULL),(3942,NULL,40719,35,2,3952,'App\\Models\\Receipt',3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',608.00,NULL,NULL,1,'2023-03-31 22:54:23','2023-03-31 22:54:23',NULL),(3943,NULL,40719,35,2,3953,'App\\Models\\Receipt',3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',695.00,NULL,NULL,1,'2023-03-31 22:54:24','2023-03-31 22:54:24',NULL),(3944,NULL,40719,35,2,3954,'App\\Models\\Receipt',3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',555.00,NULL,NULL,1,'2023-03-31 22:54:25','2023-03-31 22:54:25',NULL),(3945,NULL,40719,35,2,3955,'App\\Models\\Receipt',3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',659.00,NULL,NULL,1,'2023-03-31 22:54:26','2023-03-31 22:54:26',NULL),(3946,NULL,40719,35,2,3956,'App\\Models\\Receipt',3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',660.00,NULL,NULL,1,'2023-03-31 22:54:27','2023-03-31 22:54:27',NULL);
INSERT INTO `balance_libro` VALUES (3947,NULL,40719,35,2,3957,'App\\Models\\Receipt',3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',789.00,NULL,NULL,1,'2023-03-31 22:54:28','2023-03-31 22:54:28',NULL),(3948,NULL,40719,35,2,3958,'App\\Models\\Receipt',3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',781.00,NULL,NULL,1,'2023-03-31 22:54:29','2023-03-31 22:54:29',NULL),(3949,NULL,40719,35,2,3959,'App\\Models\\Receipt',3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',348.00,NULL,NULL,1,'2023-03-31 22:54:30','2023-03-31 22:54:30',NULL),(3950,NULL,40719,35,2,3960,'App\\Models\\Receipt',3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',633.00,NULL,NULL,1,'2023-03-31 22:54:30','2023-03-31 22:54:30',NULL),(3951,NULL,40719,35,2,3961,'App\\Models\\Receipt',3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',626.00,NULL,NULL,1,'2023-03-31 22:54:31','2023-03-31 22:54:31',NULL),(3952,NULL,40719,35,2,3962,'App\\Models\\Receipt',3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',540.00,NULL,NULL,1,'2023-03-31 22:54:32','2023-03-31 22:54:32',NULL),(3953,NULL,40719,35,2,3963,'App\\Models\\Receipt',3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',575.00,NULL,NULL,1,'2023-03-31 22:54:33','2023-03-31 22:54:33',NULL),(3954,NULL,40719,35,2,3964,'App\\Models\\Receipt',3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',887.00,NULL,NULL,1,'2023-03-31 22:54:34','2023-03-31 22:54:34',NULL),(3955,NULL,40719,35,2,3965,'App\\Models\\Receipt',3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',586.00,NULL,NULL,1,'2023-03-31 22:54:35','2023-03-31 22:54:35',NULL),(3956,NULL,40719,35,2,3966,'App\\Models\\Receipt',3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',752.00,NULL,NULL,1,'2023-03-31 22:54:36','2023-03-31 22:54:36',NULL),(3957,NULL,40719,35,2,3967,'App\\Models\\Receipt',3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',432.00,NULL,NULL,1,'2023-03-31 22:54:37','2023-03-31 22:54:37',NULL),(3958,NULL,40719,35,2,3968,'App\\Models\\Receipt',3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',331.00,NULL,NULL,1,'2023-03-31 22:54:38','2023-03-31 22:54:38',NULL),(3959,NULL,40719,35,2,3969,'App\\Models\\Receipt',3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',769.00,NULL,NULL,1,'2023-03-31 22:54:39','2023-03-31 22:54:39',NULL),(3960,NULL,40719,35,2,3970,'App\\Models\\Receipt',3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',715.00,NULL,NULL,1,'2023-03-31 22:54:40','2023-03-31 22:54:40',NULL),(3961,NULL,40719,35,2,3971,'App\\Models\\Receipt',3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',424.00,NULL,NULL,1,'2023-03-31 22:54:41','2023-03-31 22:54:41',NULL),(3962,NULL,40719,35,2,3972,'App\\Models\\Receipt',3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',795.00,NULL,NULL,1,'2023-03-31 22:54:42','2023-03-31 22:54:42',NULL),(3963,NULL,40719,35,2,3973,'App\\Models\\Receipt',3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',703.00,NULL,NULL,1,'2023-03-31 22:54:43','2023-03-31 22:54:43',NULL),(3964,NULL,40719,35,2,3974,'App\\Models\\Receipt',3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',429.00,NULL,NULL,1,'2023-03-31 22:54:44','2023-03-31 22:54:44',NULL),(3965,NULL,40719,35,2,3975,'App\\Models\\Receipt',3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',708.00,NULL,NULL,1,'2023-03-31 22:54:45','2023-03-31 22:54:45',NULL),(3966,NULL,40719,35,2,3976,'App\\Models\\Receipt',3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',538.00,NULL,NULL,1,'2023-03-31 22:54:46','2023-03-31 22:54:46',NULL),(3967,NULL,40719,35,2,3977,'App\\Models\\Receipt',3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',650.00,NULL,NULL,1,'2023-03-31 22:54:46','2023-03-31 22:54:46',NULL);
INSERT INTO `balance_libro` VALUES (3968,NULL,40719,35,2,3978,'App\\Models\\Receipt',3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',689.00,NULL,NULL,1,'2023-03-31 22:54:47','2023-03-31 22:54:47',NULL),(3969,NULL,40719,35,2,3979,'App\\Models\\Receipt',3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',850.00,NULL,NULL,1,'2023-03-31 22:54:48','2023-03-31 22:54:48',NULL),(3970,NULL,40719,35,2,3980,'App\\Models\\Receipt',3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',331.00,NULL,NULL,1,'2023-03-31 22:54:49','2023-03-31 22:54:49',NULL),(3971,NULL,40719,35,2,3981,'App\\Models\\Receipt',3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',571.00,NULL,NULL,1,'2023-03-31 22:54:50','2023-03-31 22:54:50',NULL),(3972,NULL,40719,35,2,3982,'App\\Models\\Receipt',3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',673.00,NULL,NULL,1,'2023-03-31 22:54:51','2023-03-31 22:54:51',NULL),(3973,NULL,40719,35,2,3983,'App\\Models\\Receipt',3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',715.00,NULL,NULL,1,'2023-03-31 22:54:52','2023-03-31 22:54:52',NULL),(3974,NULL,40719,35,2,3984,'App\\Models\\Receipt',3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',726.00,NULL,NULL,1,'2023-03-31 22:54:53','2023-03-31 22:54:53',NULL),(3975,NULL,40719,35,2,3985,'App\\Models\\Receipt',3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',389.00,NULL,NULL,1,'2023-03-31 22:54:54','2023-03-31 22:54:54',NULL),(3976,NULL,40719,35,2,3986,'App\\Models\\Receipt',3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',313.00,NULL,NULL,1,'2023-03-31 22:54:55','2023-03-31 22:54:55',NULL),(3977,NULL,40719,35,2,3987,'App\\Models\\Receipt',3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',773.00,NULL,NULL,1,'2023-03-31 22:54:56','2023-03-31 22:54:56',NULL),(3978,NULL,40719,35,2,3988,'App\\Models\\Receipt',3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',891.00,NULL,NULL,1,'2023-03-31 22:54:57','2023-03-31 22:54:57',NULL),(3979,NULL,40719,35,2,3989,'App\\Models\\Receipt',3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',506.00,NULL,NULL,1,'2023-03-31 22:54:58','2023-03-31 22:54:58',NULL),(3980,NULL,40719,35,2,3990,'App\\Models\\Receipt',3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',567.00,NULL,NULL,1,'2023-03-31 22:54:59','2023-03-31 22:54:59',NULL),(3981,NULL,40719,35,2,3991,'App\\Models\\Receipt',3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',670.00,NULL,NULL,1,'2023-03-31 22:55:00','2023-03-31 22:55:00',NULL),(3982,NULL,40719,35,2,3992,'App\\Models\\Receipt',3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',543.00,NULL,NULL,1,'2023-03-31 22:55:01','2023-03-31 22:55:01',NULL),(3983,NULL,40719,35,2,3993,'App\\Models\\Receipt',3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',303.00,NULL,NULL,1,'2023-03-31 22:55:01','2023-03-31 22:55:01',NULL),(3984,NULL,40719,35,2,3994,'App\\Models\\Receipt',3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',327.00,NULL,NULL,1,'2023-03-31 22:55:02','2023-03-31 22:55:02',NULL),(3985,NULL,40719,35,2,3995,'App\\Models\\Receipt',3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',402.00,NULL,NULL,1,'2023-03-31 22:55:03','2023-03-31 22:55:03',NULL),(3986,NULL,40719,35,2,3996,'App\\Models\\Receipt',3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',319.00,NULL,NULL,1,'2023-03-31 22:55:04','2023-03-31 22:55:04',NULL),(3987,NULL,40719,35,2,3997,'App\\Models\\Receipt',3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',467.00,NULL,NULL,1,'2023-03-31 22:55:05','2023-03-31 22:55:05',NULL),(3988,NULL,40719,35,2,3998,'App\\Models\\Receipt',3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',880.00,NULL,NULL,1,'2023-03-31 22:55:06','2023-03-31 22:55:06',NULL);
INSERT INTO `balance_libro` VALUES (3989,NULL,40719,35,2,3999,'App\\Models\\Receipt',3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',753.00,NULL,NULL,1,'2023-03-31 22:55:07','2023-03-31 22:55:07',NULL),(3990,NULL,40719,35,2,4000,'App\\Models\\Receipt',4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',763.00,NULL,NULL,1,'2023-03-31 22:55:08','2023-03-31 22:55:08',NULL),(3991,NULL,40719,35,2,4001,'App\\Models\\Receipt',4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',714.00,NULL,NULL,1,'2023-03-31 22:55:09','2023-03-31 22:55:09',NULL),(3992,NULL,40719,35,2,4002,'App\\Models\\Receipt',4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',686.00,NULL,NULL,1,'2023-03-31 22:55:10','2023-03-31 22:55:10',NULL),(3993,NULL,40719,35,2,4003,'App\\Models\\Receipt',4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',535.00,NULL,NULL,1,'2023-03-31 22:55:11','2023-03-31 22:55:11',NULL),(3994,NULL,40719,35,2,4004,'App\\Models\\Receipt',4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',414.00,NULL,NULL,1,'2023-03-31 22:55:12','2023-03-31 22:55:12',NULL),(3995,NULL,40719,35,2,4005,'App\\Models\\Receipt',4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',634.00,NULL,NULL,1,'2023-03-31 22:55:13','2023-03-31 22:55:13',NULL),(3996,NULL,40719,35,2,4006,'App\\Models\\Receipt',4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',530.00,NULL,NULL,1,'2023-03-31 22:55:14','2023-03-31 22:55:14',NULL),(3997,NULL,40719,35,2,4007,'App\\Models\\Receipt',4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',506.00,NULL,NULL,1,'2023-03-31 22:55:15','2023-03-31 22:55:15',NULL),(3998,NULL,40719,35,2,4008,'App\\Models\\Receipt',4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',625.00,NULL,NULL,1,'2023-03-31 22:55:16','2023-03-31 22:55:16',NULL),(3999,NULL,40719,35,2,4009,'App\\Models\\Receipt',4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',861.00,NULL,NULL,1,'2023-03-31 22:55:17','2023-03-31 22:55:17',NULL),(4000,NULL,40719,35,2,4010,'App\\Models\\Receipt',4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',638.00,NULL,NULL,1,'2023-03-31 22:55:18','2023-03-31 22:55:18',NULL),(4001,NULL,40719,35,2,4011,'App\\Models\\Receipt',4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',868.00,NULL,NULL,1,'2023-03-31 22:55:19','2023-03-31 22:55:19',NULL),(4002,NULL,40719,35,2,4012,'App\\Models\\Receipt',4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',878.00,NULL,NULL,1,'2023-03-31 22:55:20','2023-03-31 22:55:20',NULL),(4003,NULL,40719,35,2,4013,'App\\Models\\Receipt',4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',694.00,NULL,NULL,1,'2023-03-31 22:55:21','2023-03-31 22:55:21',NULL),(4004,NULL,40719,35,2,4014,'App\\Models\\Receipt',4014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',715.00,NULL,NULL,1,'2023-03-31 22:55:21','2023-03-31 22:55:21',NULL),(4005,NULL,40719,35,2,4015,'App\\Models\\Receipt',4015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',813.00,NULL,NULL,1,'2023-03-31 22:55:22','2023-03-31 22:55:22',NULL),(4006,NULL,40719,35,2,4016,'App\\Models\\Receipt',4016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',663.00,NULL,NULL,1,'2023-03-31 22:55:23','2023-03-31 22:55:23',NULL),(4007,NULL,40719,35,2,4017,'App\\Models\\Receipt',4017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',826.00,NULL,NULL,1,'2023-03-31 22:55:24','2023-03-31 22:55:24',NULL),(4008,NULL,40719,35,2,4018,'App\\Models\\Receipt',4018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',526.00,NULL,NULL,1,'2023-03-31 22:55:25','2023-03-31 22:55:25',NULL),(4009,NULL,40719,35,2,4019,'App\\Models\\Receipt',4019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',764.00,NULL,NULL,1,'2023-03-31 22:55:26','2023-03-31 22:55:26',NULL);
INSERT INTO `balance_libro` VALUES (4010,NULL,40719,35,2,4020,'App\\Models\\Receipt',4020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',578.00,NULL,NULL,1,'2023-03-31 22:55:27','2023-03-31 22:55:27',NULL),(4011,NULL,40719,35,2,4021,'App\\Models\\Receipt',4021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',889.00,NULL,NULL,1,'2023-03-31 22:55:28','2023-03-31 22:55:28',NULL),(4012,NULL,40719,35,2,4022,'App\\Models\\Receipt',4022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',828.00,NULL,NULL,1,'2023-03-31 22:55:29','2023-03-31 22:55:29',NULL),(4013,NULL,40719,35,2,4023,'App\\Models\\Receipt',4023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',320.00,NULL,NULL,1,'2023-03-31 22:55:30','2023-03-31 22:55:30',NULL),(4014,NULL,40719,35,2,4024,'App\\Models\\Receipt',4024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',469.00,NULL,NULL,1,'2023-03-31 22:55:31','2023-03-31 22:55:31',NULL),(4015,NULL,40719,35,2,4025,'App\\Models\\Receipt',4025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',860.00,NULL,NULL,1,'2023-03-31 22:55:32','2023-03-31 22:55:32',NULL),(4016,NULL,40719,35,2,4026,'App\\Models\\Receipt',4026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',664.00,NULL,NULL,1,'2023-03-31 22:55:33','2023-03-31 22:55:33',NULL),(4017,NULL,40719,35,2,4027,'App\\Models\\Receipt',4027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',710.00,NULL,NULL,1,'2023-03-31 22:55:34','2023-03-31 22:55:34',NULL),(4018,NULL,40719,35,2,4028,'App\\Models\\Receipt',4028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',773.00,NULL,NULL,1,'2023-03-31 22:55:35','2023-03-31 22:55:35',NULL),(4019,NULL,40719,35,2,4029,'App\\Models\\Receipt',4029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',826.00,NULL,NULL,1,'2023-03-31 22:55:36','2023-03-31 22:55:36',NULL),(4020,NULL,40719,35,2,4030,'App\\Models\\Receipt',4030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',508.00,NULL,NULL,1,'2023-03-31 22:55:37','2023-03-31 22:55:37',NULL),(4021,NULL,40719,35,2,4031,'App\\Models\\Receipt',4031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',462.00,NULL,NULL,1,'2023-03-31 22:55:38','2023-03-31 22:55:38',NULL),(4022,NULL,40719,35,2,4032,'App\\Models\\Receipt',4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',811.00,NULL,NULL,1,'2023-03-31 22:55:38','2023-03-31 22:55:38',NULL),(4023,NULL,40719,35,2,4033,'App\\Models\\Receipt',4033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',508.00,NULL,NULL,1,'2023-03-31 22:55:39','2023-03-31 22:55:39',NULL),(4024,NULL,40719,35,2,4034,'App\\Models\\Receipt',4034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',582.00,NULL,NULL,1,'2023-03-31 22:55:40','2023-03-31 22:55:40',NULL),(4025,NULL,40719,35,2,4035,'App\\Models\\Receipt',4035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',409.00,NULL,NULL,1,'2023-03-31 22:55:41','2023-03-31 22:55:41',NULL),(4026,NULL,40719,35,2,4036,'App\\Models\\Receipt',4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',858.00,NULL,NULL,1,'2023-03-31 22:55:42','2023-03-31 22:55:42',NULL),(4027,NULL,40719,35,2,4037,'App\\Models\\Receipt',4037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',600.00,NULL,NULL,1,'2023-03-31 22:55:43','2023-03-31 22:55:43',NULL),(4028,NULL,40719,35,2,4038,'App\\Models\\Receipt',4038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',697.00,NULL,NULL,1,'2023-03-31 22:55:44','2023-03-31 22:55:44',NULL),(4029,NULL,40719,35,2,4039,'App\\Models\\Receipt',4039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',445.00,NULL,NULL,1,'2023-03-31 22:55:45','2023-03-31 22:55:45',NULL),(4030,NULL,40719,35,2,4040,'App\\Models\\Receipt',4040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',449.00,NULL,NULL,1,'2023-03-31 22:55:46','2023-03-31 22:55:46',NULL);
INSERT INTO `balance_libro` VALUES (4031,NULL,40719,35,2,4041,'App\\Models\\Receipt',4041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',655.00,NULL,NULL,1,'2023-03-31 22:55:47','2023-03-31 22:55:47',NULL),(4032,NULL,40719,35,2,4042,'App\\Models\\Receipt',4042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',874.00,NULL,NULL,1,'2023-03-31 22:55:48','2023-03-31 22:55:48',NULL),(4033,NULL,40719,35,2,4043,'App\\Models\\Receipt',4043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',421.00,NULL,NULL,1,'2023-03-31 22:55:49','2023-03-31 22:55:49',NULL),(4034,NULL,40719,35,2,4044,'App\\Models\\Receipt',4044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',781.00,NULL,NULL,1,'2023-03-31 22:55:50','2023-03-31 22:55:50',NULL),(4035,NULL,40719,35,2,4045,'App\\Models\\Receipt',4045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',520.00,NULL,NULL,1,'2023-03-31 22:55:51','2023-03-31 22:55:51',NULL),(4036,NULL,40719,36,2,4046,'App\\Models\\Receipt',4046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',541.00,NULL,NULL,1,'2023-04-30 16:00:46','2023-04-30 16:00:46',NULL),(4037,NULL,40719,36,2,4047,'App\\Models\\Receipt',4047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',534.00,NULL,NULL,1,'2023-04-30 16:00:47','2023-04-30 16:00:47',NULL),(4038,NULL,40719,36,2,4048,'App\\Models\\Receipt',4048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',452.00,NULL,NULL,1,'2023-04-30 16:00:48','2023-04-30 16:00:48',NULL),(4039,NULL,40719,36,2,4049,'App\\Models\\Receipt',4049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',346.00,NULL,NULL,1,'2023-04-30 16:00:49','2023-04-30 16:00:49',NULL),(4040,NULL,40719,36,2,4050,'App\\Models\\Receipt',4050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',581.00,NULL,NULL,1,'2023-04-30 16:00:50','2023-04-30 16:00:50',NULL),(4041,NULL,40719,36,2,4051,'App\\Models\\Receipt',4051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',828.00,NULL,NULL,1,'2023-04-30 16:00:51','2023-04-30 16:00:51',NULL),(4042,NULL,40719,36,2,4052,'App\\Models\\Receipt',4052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',397.00,NULL,NULL,1,'2023-04-30 16:00:51','2023-04-30 16:00:51',NULL),(4043,NULL,40719,36,2,4053,'App\\Models\\Receipt',4053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',780.00,NULL,NULL,1,'2023-04-30 16:00:52','2023-04-30 16:00:52',NULL),(4044,NULL,40719,36,2,4054,'App\\Models\\Receipt',4054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',569.00,NULL,NULL,1,'2023-04-30 16:00:53','2023-04-30 16:00:53',NULL),(4045,NULL,40719,36,2,4055,'App\\Models\\Receipt',4055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',566.00,NULL,NULL,1,'2023-04-30 16:00:54','2023-04-30 16:00:54',NULL),(4046,NULL,40719,36,2,4056,'App\\Models\\Receipt',4056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',812.00,NULL,NULL,1,'2023-04-30 16:00:55','2023-04-30 16:00:55',NULL),(4047,NULL,40719,36,2,4057,'App\\Models\\Receipt',4057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',336.00,NULL,NULL,1,'2023-04-30 16:00:56','2023-04-30 16:00:56',NULL),(4048,NULL,40719,36,2,4058,'App\\Models\\Receipt',4058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',406.00,NULL,NULL,1,'2023-04-30 16:00:56','2023-04-30 16:00:56',NULL),(4049,NULL,40719,36,2,4059,'App\\Models\\Receipt',4059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',804.00,NULL,NULL,1,'2023-04-30 16:00:57','2023-04-30 16:00:57',NULL),(4050,NULL,40719,36,2,4060,'App\\Models\\Receipt',4060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',728.00,NULL,NULL,1,'2023-04-30 16:00:58','2023-04-30 16:00:58',NULL),(4051,NULL,40719,36,2,4061,'App\\Models\\Receipt',4061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',580.00,NULL,NULL,1,'2023-04-30 16:00:59','2023-04-30 16:00:59',NULL);
INSERT INTO `balance_libro` VALUES (4052,NULL,40719,36,2,4062,'App\\Models\\Receipt',4062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',528.00,NULL,NULL,1,'2023-04-30 16:01:00','2023-04-30 16:01:00',NULL),(4053,NULL,40719,36,2,4063,'App\\Models\\Receipt',4063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',851.00,NULL,NULL,1,'2023-04-30 16:01:01','2023-04-30 16:01:01',NULL),(4054,NULL,40719,36,2,4064,'App\\Models\\Receipt',4064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',753.00,NULL,NULL,1,'2023-04-30 16:01:01','2023-04-30 16:01:01',NULL),(4055,NULL,40719,36,2,4065,'App\\Models\\Receipt',4065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',797.00,NULL,NULL,1,'2023-04-30 16:01:02','2023-04-30 16:01:02',NULL),(4056,NULL,40719,36,2,4066,'App\\Models\\Receipt',4066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',828.00,NULL,NULL,1,'2023-04-30 16:01:03','2023-04-30 16:01:03',NULL),(4057,NULL,40719,36,2,4067,'App\\Models\\Receipt',4067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',508.00,NULL,NULL,1,'2023-04-30 16:01:04','2023-04-30 16:01:04',NULL),(4058,NULL,40719,36,2,4068,'App\\Models\\Receipt',4068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',626.00,NULL,NULL,1,'2023-04-30 16:01:05','2023-04-30 16:01:05',NULL),(4059,NULL,40719,36,2,4069,'App\\Models\\Receipt',4069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',583.00,NULL,NULL,1,'2023-04-30 16:01:06','2023-04-30 16:01:06',NULL),(4060,NULL,40719,36,2,4070,'App\\Models\\Receipt',4070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',659.00,NULL,NULL,1,'2023-04-30 16:01:06','2023-04-30 16:01:06',NULL),(4061,NULL,40719,36,2,4071,'App\\Models\\Receipt',4071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',787.00,NULL,NULL,1,'2023-04-30 16:01:07','2023-04-30 16:01:07',NULL),(4062,NULL,40719,36,2,4072,'App\\Models\\Receipt',4072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',428.00,NULL,NULL,1,'2023-04-30 16:01:08','2023-04-30 16:01:08',NULL),(4063,NULL,40719,36,2,4073,'App\\Models\\Receipt',4073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',366.00,NULL,NULL,1,'2023-04-30 16:01:09','2023-04-30 16:01:09',NULL),(4064,NULL,40719,36,2,4074,'App\\Models\\Receipt',4074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',428.00,NULL,NULL,1,'2023-04-30 16:01:10','2023-04-30 16:01:10',NULL),(4065,NULL,40719,36,2,4075,'App\\Models\\Receipt',4075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',704.00,NULL,NULL,1,'2023-04-30 16:01:11','2023-04-30 16:01:11',NULL),(4066,NULL,40719,36,2,4076,'App\\Models\\Receipt',4076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',395.00,NULL,NULL,1,'2023-04-30 16:01:11','2023-04-30 16:01:11',NULL),(4067,NULL,40719,36,2,4077,'App\\Models\\Receipt',4077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',703.00,NULL,NULL,1,'2023-04-30 16:01:12','2023-04-30 16:01:12',NULL),(4068,NULL,40719,36,2,4078,'App\\Models\\Receipt',4078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',614.00,NULL,NULL,1,'2023-04-30 16:01:13','2023-04-30 16:01:13',NULL),(4069,NULL,40719,36,2,4079,'App\\Models\\Receipt',4079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',379.00,NULL,NULL,1,'2023-04-30 16:01:14','2023-04-30 16:01:14',NULL),(4070,NULL,40719,36,2,4080,'App\\Models\\Receipt',4080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',492.00,NULL,NULL,1,'2023-04-30 16:01:15','2023-04-30 16:01:15',NULL),(4071,NULL,40719,36,2,4081,'App\\Models\\Receipt',4081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',626.00,NULL,NULL,1,'2023-04-30 16:01:15','2023-04-30 16:01:15',NULL),(4072,NULL,40719,36,2,4082,'App\\Models\\Receipt',4082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',474.00,NULL,NULL,1,'2023-04-30 16:01:16','2023-04-30 16:01:16',NULL);
INSERT INTO `balance_libro` VALUES (4073,NULL,40719,36,2,4083,'App\\Models\\Receipt',4083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',530.00,NULL,NULL,1,'2023-04-30 16:01:17','2023-04-30 16:01:17',NULL),(4074,NULL,40719,36,2,4084,'App\\Models\\Receipt',4084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',461.00,NULL,NULL,1,'2023-04-30 16:01:18','2023-04-30 16:01:18',NULL),(4075,NULL,40719,36,2,4085,'App\\Models\\Receipt',4085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',310.00,NULL,NULL,1,'2023-04-30 16:01:19','2023-04-30 16:01:19',NULL),(4076,NULL,40719,36,2,4086,'App\\Models\\Receipt',4086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',540.00,NULL,NULL,1,'2023-04-30 16:01:19','2023-04-30 16:01:19',NULL),(4077,NULL,40719,36,2,4087,'App\\Models\\Receipt',4087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',604.00,NULL,NULL,1,'2023-04-30 16:01:20','2023-04-30 16:01:20',NULL),(4078,NULL,40719,36,2,4088,'App\\Models\\Receipt',4088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',564.00,NULL,NULL,1,'2023-04-30 16:01:21','2023-04-30 16:01:21',NULL),(4079,NULL,40719,36,2,4089,'App\\Models\\Receipt',4089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',335.00,NULL,NULL,1,'2023-04-30 16:01:22','2023-04-30 16:01:22',NULL),(4080,NULL,40719,36,2,4090,'App\\Models\\Receipt',4090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',713.00,NULL,NULL,1,'2023-04-30 16:01:23','2023-04-30 16:01:23',NULL),(4081,NULL,40719,36,2,4091,'App\\Models\\Receipt',4091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',757.00,NULL,NULL,1,'2023-04-30 16:01:24','2023-04-30 16:01:24',NULL),(4082,NULL,40719,36,2,4092,'App\\Models\\Receipt',4092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',845.00,NULL,NULL,1,'2023-04-30 16:01:24','2023-04-30 16:01:24',NULL),(4083,NULL,40719,36,2,4093,'App\\Models\\Receipt',4093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',391.00,NULL,NULL,1,'2023-04-30 16:01:25','2023-04-30 16:01:25',NULL),(4084,NULL,40719,36,2,4094,'App\\Models\\Receipt',4094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',674.00,NULL,NULL,1,'2023-04-30 16:01:26','2023-04-30 16:01:26',NULL),(4085,NULL,40719,36,2,4095,'App\\Models\\Receipt',4095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',519.00,NULL,NULL,1,'2023-04-30 16:01:27','2023-04-30 16:01:27',NULL),(4086,NULL,40719,36,2,4096,'App\\Models\\Receipt',4096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',373.00,NULL,NULL,1,'2023-04-30 16:01:28','2023-04-30 16:01:28',NULL),(4087,NULL,40719,36,2,4097,'App\\Models\\Receipt',4097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',726.00,NULL,NULL,1,'2023-04-30 16:01:28','2023-04-30 16:01:28',NULL),(4088,NULL,40719,36,2,4098,'App\\Models\\Receipt',4098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',550.00,NULL,NULL,1,'2023-04-30 16:01:29','2023-04-30 16:01:29',NULL),(4089,NULL,40719,36,2,4099,'App\\Models\\Receipt',4099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',387.00,NULL,NULL,1,'2023-04-30 16:01:30','2023-04-30 16:01:30',NULL),(4090,NULL,40719,36,2,4100,'App\\Models\\Receipt',4100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',817.00,NULL,NULL,1,'2023-04-30 16:01:31','2023-04-30 16:01:31',NULL),(4091,NULL,40719,36,2,4101,'App\\Models\\Receipt',4101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',525.00,NULL,NULL,1,'2023-04-30 16:01:32','2023-04-30 16:01:32',NULL),(4092,NULL,40719,36,2,4102,'App\\Models\\Receipt',4102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',765.00,NULL,NULL,1,'2023-04-30 16:01:32','2023-04-30 16:01:32',NULL),(4093,NULL,40719,36,2,4103,'App\\Models\\Receipt',4103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',418.00,NULL,NULL,1,'2023-04-30 16:01:33','2023-04-30 16:01:33',NULL);
INSERT INTO `balance_libro` VALUES (4094,NULL,40719,36,2,4104,'App\\Models\\Receipt',4104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',570.00,NULL,NULL,1,'2023-04-30 16:01:34','2023-04-30 16:01:34',NULL),(4095,NULL,40719,36,2,4105,'App\\Models\\Receipt',4105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',690.00,NULL,NULL,1,'2023-04-30 16:01:35','2023-04-30 16:01:35',NULL),(4096,NULL,40719,36,2,4106,'App\\Models\\Receipt',4106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',682.00,NULL,NULL,1,'2023-04-30 16:01:36','2023-04-30 16:01:36',NULL),(4097,NULL,40719,36,2,4107,'App\\Models\\Receipt',4107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',453.00,NULL,NULL,1,'2023-04-30 16:01:37','2023-04-30 16:01:37',NULL),(4098,NULL,40719,36,2,4108,'App\\Models\\Receipt',4108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',303.00,NULL,NULL,1,'2023-04-30 16:01:37','2023-04-30 16:01:37',NULL),(4099,NULL,40719,36,2,4109,'App\\Models\\Receipt',4109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',546.00,NULL,NULL,1,'2023-04-30 16:01:38','2023-04-30 16:01:38',NULL),(4100,NULL,40719,36,2,4110,'App\\Models\\Receipt',4110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',781.00,NULL,NULL,1,'2023-04-30 16:01:39','2023-04-30 16:01:39',NULL),(4101,NULL,40719,36,2,4111,'App\\Models\\Receipt',4111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',633.00,NULL,NULL,1,'2023-04-30 16:01:40','2023-04-30 16:01:40',NULL),(4102,NULL,40719,36,2,4112,'App\\Models\\Receipt',4112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',339.00,NULL,NULL,1,'2023-04-30 16:01:41','2023-04-30 16:01:41',NULL),(4103,NULL,40719,36,2,4113,'App\\Models\\Receipt',4113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',490.00,NULL,NULL,1,'2023-04-30 16:01:41','2023-04-30 16:01:41',NULL),(4104,NULL,40719,36,2,4114,'App\\Models\\Receipt',4114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',419.00,NULL,NULL,1,'2023-04-30 16:01:42','2023-04-30 16:01:42',NULL),(4105,NULL,40719,36,2,4115,'App\\Models\\Receipt',4115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',821.00,NULL,NULL,1,'2023-04-30 16:01:43','2023-04-30 16:01:43',NULL),(4106,NULL,40719,36,2,4116,'App\\Models\\Receipt',4116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',545.00,NULL,NULL,1,'2023-04-30 16:01:44','2023-04-30 16:01:44',NULL),(4107,NULL,40719,36,2,4117,'App\\Models\\Receipt',4117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',636.00,NULL,NULL,1,'2023-04-30 16:01:45','2023-04-30 16:01:45',NULL),(4108,NULL,40719,36,2,4118,'App\\Models\\Receipt',4118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',892.00,NULL,NULL,1,'2023-04-30 16:01:45','2023-04-30 16:01:45',NULL),(4109,NULL,40719,36,2,4119,'App\\Models\\Receipt',4119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',763.00,NULL,NULL,1,'2023-04-30 16:01:46','2023-04-30 16:01:46',NULL),(4110,NULL,40719,36,2,4120,'App\\Models\\Receipt',4120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',533.00,NULL,NULL,1,'2023-04-30 16:01:47','2023-04-30 16:01:47',NULL),(4111,NULL,40719,36,2,4121,'App\\Models\\Receipt',4121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',343.00,NULL,NULL,1,'2023-04-30 16:01:48','2023-04-30 16:01:48',NULL),(4112,NULL,40719,36,2,4122,'App\\Models\\Receipt',4122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',477.00,NULL,NULL,1,'2023-04-30 16:01:49','2023-04-30 16:01:49',NULL),(4113,NULL,40719,36,2,4123,'App\\Models\\Receipt',4123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',535.00,NULL,NULL,1,'2023-04-30 16:01:49','2023-04-30 16:01:49',NULL),(4114,NULL,40719,36,2,4124,'App\\Models\\Receipt',4124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',493.00,NULL,NULL,1,'2023-04-30 16:01:50','2023-04-30 16:01:50',NULL);
INSERT INTO `balance_libro` VALUES (4115,NULL,40719,36,2,4125,'App\\Models\\Receipt',4125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',427.00,NULL,NULL,1,'2023-04-30 16:01:51','2023-04-30 16:01:51',NULL),(4116,NULL,40719,36,2,4126,'App\\Models\\Receipt',4126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',704.00,NULL,NULL,1,'2023-04-30 16:01:52','2023-04-30 16:01:52',NULL),(4117,NULL,40719,36,2,4127,'App\\Models\\Receipt',4127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',668.00,NULL,NULL,1,'2023-04-30 16:01:53','2023-04-30 16:01:53',NULL),(4118,NULL,40719,36,2,4128,'App\\Models\\Receipt',4128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',741.00,NULL,NULL,1,'2023-04-30 16:01:53','2023-04-30 16:01:53',NULL),(4119,NULL,40719,36,2,4129,'App\\Models\\Receipt',4129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',794.00,NULL,NULL,1,'2023-04-30 16:01:54','2023-04-30 16:01:54',NULL),(4120,NULL,40719,36,2,4130,'App\\Models\\Receipt',4130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',770.00,NULL,NULL,1,'2023-04-30 16:01:55','2023-04-30 16:01:55',NULL),(4121,NULL,40719,36,2,4131,'App\\Models\\Receipt',4131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',414.00,NULL,NULL,1,'2023-04-30 16:01:56','2023-04-30 16:01:56',NULL),(4122,NULL,40719,36,2,4132,'App\\Models\\Receipt',4132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',558.00,NULL,NULL,1,'2023-04-30 16:01:57','2023-04-30 16:01:57',NULL),(4123,NULL,40719,36,2,4133,'App\\Models\\Receipt',4133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',770.00,NULL,NULL,1,'2023-04-30 16:01:57','2023-04-30 16:01:57',NULL),(4124,NULL,40719,36,2,4134,'App\\Models\\Receipt',4134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',829.00,NULL,NULL,1,'2023-04-30 16:01:58','2023-04-30 16:01:58',NULL),(4125,NULL,40719,36,2,4135,'App\\Models\\Receipt',4135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',477.00,NULL,NULL,1,'2023-04-30 16:01:59','2023-04-30 16:01:59',NULL),(4126,NULL,40719,36,2,4136,'App\\Models\\Receipt',4136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',494.00,NULL,NULL,1,'2023-04-30 16:02:00','2023-04-30 16:02:00',NULL),(4127,NULL,40719,36,2,4137,'App\\Models\\Receipt',4137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',542.00,NULL,NULL,1,'2023-04-30 16:02:01','2023-04-30 16:02:01',NULL),(4128,NULL,40719,36,2,4138,'App\\Models\\Receipt',4138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',881.00,NULL,NULL,1,'2023-04-30 16:02:01','2023-04-30 16:02:01',NULL),(4129,NULL,40719,36,2,4139,'App\\Models\\Receipt',4139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',744.00,NULL,NULL,1,'2023-04-30 16:02:02','2023-04-30 16:02:02',NULL),(4130,NULL,40719,36,2,4140,'App\\Models\\Receipt',4140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',872.00,NULL,NULL,1,'2023-04-30 16:02:03','2023-04-30 16:02:03',NULL),(4131,NULL,40719,36,2,4141,'App\\Models\\Receipt',4141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',614.00,NULL,NULL,1,'2023-04-30 16:02:04','2023-04-30 16:02:04',NULL),(4132,NULL,40719,36,2,4142,'App\\Models\\Receipt',4142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',464.00,NULL,NULL,1,'2023-04-30 16:02:05','2023-04-30 16:02:05',NULL),(4133,NULL,40719,36,2,4143,'App\\Models\\Receipt',4143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',660.00,NULL,NULL,1,'2023-04-30 16:02:05','2023-04-30 16:02:05',NULL),(4134,NULL,40719,36,2,4144,'App\\Models\\Receipt',4144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',570.00,NULL,NULL,1,'2023-04-30 16:02:06','2023-04-30 16:02:06',NULL),(4135,NULL,40719,36,2,4145,'App\\Models\\Receipt',4145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',730.00,NULL,NULL,1,'2023-04-30 16:02:07','2023-04-30 16:02:07',NULL);
INSERT INTO `balance_libro` VALUES (4136,NULL,40719,36,2,4146,'App\\Models\\Receipt',4146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',847.00,NULL,NULL,1,'2023-04-30 16:02:08','2023-04-30 16:02:08',NULL),(4137,NULL,40719,36,2,4147,'App\\Models\\Receipt',4147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',856.00,NULL,NULL,1,'2023-04-30 16:02:09','2023-04-30 16:02:09',NULL),(4138,NULL,40719,36,2,4148,'App\\Models\\Receipt',4148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',582.00,NULL,NULL,1,'2023-04-30 16:02:10','2023-04-30 16:02:10',NULL),(4139,NULL,40719,36,2,4149,'App\\Models\\Receipt',4149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',795.00,NULL,NULL,1,'2023-04-30 16:02:10','2023-04-30 16:02:10',NULL),(4140,NULL,40719,36,2,4150,'App\\Models\\Receipt',4150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',377.00,NULL,NULL,1,'2023-04-30 16:02:11','2023-04-30 16:02:11',NULL),(4141,NULL,40719,36,2,4151,'App\\Models\\Receipt',4151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',314.00,NULL,NULL,1,'2023-04-30 16:02:15','2023-04-30 16:02:15',NULL),(4142,NULL,40719,36,2,4152,'App\\Models\\Receipt',4152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',454.00,NULL,NULL,1,'2023-04-30 16:02:16','2023-04-30 16:02:16',NULL),(4143,NULL,40719,36,2,4153,'App\\Models\\Receipt',4153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',855.00,NULL,NULL,1,'2023-04-30 16:02:17','2023-04-30 16:02:17',NULL),(4144,NULL,40719,36,2,4154,'App\\Models\\Receipt',4154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',632.00,NULL,NULL,1,'2023-04-30 16:02:18','2023-04-30 16:02:18',NULL),(4145,NULL,40719,36,2,4155,'App\\Models\\Receipt',4155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',365.00,NULL,NULL,1,'2023-04-30 16:02:19','2023-04-30 16:02:19',NULL),(4146,NULL,40719,36,2,4156,'App\\Models\\Receipt',4156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',660.00,NULL,NULL,1,'2023-04-30 16:02:20','2023-04-30 16:02:20',NULL),(4147,NULL,40719,36,2,4157,'App\\Models\\Receipt',4157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',853.00,NULL,NULL,1,'2023-04-30 16:02:20','2023-04-30 16:02:20',NULL),(4148,NULL,40719,36,2,4158,'App\\Models\\Receipt',4158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',451.00,NULL,NULL,1,'2023-04-30 16:02:21','2023-04-30 16:02:21',NULL),(4149,NULL,40719,36,2,4159,'App\\Models\\Receipt',4159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',414.00,NULL,NULL,1,'2023-04-30 16:02:22','2023-04-30 16:02:22',NULL),(4150,NULL,40719,36,2,4160,'App\\Models\\Receipt',4160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',834.00,NULL,NULL,1,'2023-04-30 16:02:23','2023-04-30 16:02:23',NULL),(4151,NULL,40719,36,2,4161,'App\\Models\\Receipt',4161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',418.00,NULL,NULL,1,'2023-04-30 16:02:24','2023-04-30 16:02:24',NULL),(4152,NULL,40719,36,2,4162,'App\\Models\\Receipt',4162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',422.00,NULL,NULL,1,'2023-04-30 16:02:25','2023-04-30 16:02:25',NULL),(4153,NULL,40719,36,2,4163,'App\\Models\\Receipt',4163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',741.00,NULL,NULL,1,'2023-04-30 16:02:25','2023-04-30 16:02:25',NULL),(4154,NULL,40719,36,2,4164,'App\\Models\\Receipt',4164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',822.00,NULL,NULL,1,'2023-04-30 16:02:26','2023-04-30 16:02:26',NULL),(4155,NULL,40719,36,2,4165,'App\\Models\\Receipt',4165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',375.00,NULL,NULL,1,'2023-04-30 16:02:27','2023-04-30 16:02:27',NULL),(4156,NULL,40719,36,2,4166,'App\\Models\\Receipt',4166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',900.00,NULL,NULL,1,'2023-04-30 16:02:28','2023-04-30 16:02:28',NULL);
INSERT INTO `balance_libro` VALUES (4157,NULL,40719,36,2,4167,'App\\Models\\Receipt',4167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',874.00,NULL,NULL,1,'2023-04-30 16:02:29','2023-04-30 16:02:29',NULL),(4158,NULL,40719,36,2,4168,'App\\Models\\Receipt',4168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',893.00,NULL,NULL,1,'2023-04-30 16:02:30','2023-04-30 16:02:30',NULL),(4159,NULL,40719,36,2,4169,'App\\Models\\Receipt',4169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',776.00,NULL,NULL,1,'2023-04-30 16:02:30','2023-04-30 16:02:30',NULL),(4160,NULL,40719,36,2,4170,'App\\Models\\Receipt',4170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',424.00,NULL,NULL,1,'2023-04-30 16:02:31','2023-04-30 16:02:31',NULL),(4161,NULL,40719,36,2,4171,'App\\Models\\Receipt',4171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',676.00,NULL,NULL,1,'2023-04-30 16:02:32','2023-04-30 16:02:32',NULL),(4162,NULL,40719,36,2,4172,'App\\Models\\Receipt',4172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',538.00,NULL,NULL,1,'2023-04-30 16:02:33','2023-04-30 16:02:33',NULL),(4163,NULL,40719,36,2,4173,'App\\Models\\Receipt',4173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',303.00,NULL,NULL,1,'2023-04-30 16:02:34','2023-04-30 16:02:34',NULL),(4164,NULL,40719,36,2,4174,'App\\Models\\Receipt',4174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',806.00,NULL,NULL,1,'2023-04-30 16:02:35','2023-04-30 16:02:35',NULL),(4165,NULL,40719,36,2,4175,'App\\Models\\Receipt',4175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',865.00,NULL,NULL,1,'2023-04-30 16:02:35','2023-04-30 16:02:35',NULL),(4166,NULL,40719,36,2,4176,'App\\Models\\Receipt',4176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',774.00,NULL,NULL,1,'2023-04-30 16:02:36','2023-04-30 16:02:36',NULL),(4167,NULL,40719,36,2,4177,'App\\Models\\Receipt',4177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',588.00,NULL,NULL,1,'2023-04-30 16:02:37','2023-04-30 16:02:37',NULL),(4168,NULL,40719,36,2,4178,'App\\Models\\Receipt',4178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',797.00,NULL,NULL,1,'2023-04-30 16:02:38','2023-04-30 16:02:38',NULL),(4169,NULL,40719,36,2,4179,'App\\Models\\Receipt',4179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',445.00,NULL,NULL,1,'2023-04-30 16:02:39','2023-04-30 16:02:39',NULL),(4170,NULL,40719,36,2,4180,'App\\Models\\Receipt',4180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',460.00,NULL,NULL,1,'2023-04-30 16:02:40','2023-04-30 16:02:40',NULL),(4171,NULL,40719,36,2,4181,'App\\Models\\Receipt',4181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',379.00,NULL,NULL,1,'2023-04-30 16:02:41','2023-04-30 16:02:41',NULL),(4172,NULL,40719,36,2,4182,'App\\Models\\Receipt',4182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',389.00,NULL,NULL,1,'2023-04-30 16:02:42','2023-04-30 16:02:42',NULL),(4173,NULL,40719,36,2,4183,'App\\Models\\Receipt',4183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',561.00,NULL,NULL,1,'2023-04-30 16:02:43','2023-04-30 16:02:43',NULL),(4174,NULL,40719,36,2,4184,'App\\Models\\Receipt',4184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',476.00,NULL,NULL,1,'2023-04-30 16:02:44','2023-04-30 16:02:44',NULL),(4175,NULL,40719,36,2,4185,'App\\Models\\Receipt',4185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',654.00,NULL,NULL,1,'2023-04-30 16:02:45','2023-04-30 16:02:45',NULL),(4176,NULL,40719,36,2,4186,'App\\Models\\Receipt',4186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',692.00,NULL,NULL,1,'2023-04-30 16:02:45','2023-04-30 16:02:45',NULL),(4177,NULL,40719,36,2,4187,'App\\Models\\Receipt',4187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',606.00,NULL,NULL,1,'2023-04-30 16:02:46','2023-04-30 16:02:46',NULL);
INSERT INTO `balance_libro` VALUES (4178,NULL,40719,36,2,4188,'App\\Models\\Receipt',4188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',713.00,NULL,NULL,1,'2023-04-30 16:02:47','2023-04-30 16:02:47',NULL),(4179,NULL,40719,36,2,4189,'App\\Models\\Receipt',4189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',481.00,NULL,NULL,1,'2023-04-30 16:02:48','2023-04-30 16:02:48',NULL),(4180,NULL,40719,36,2,4190,'App\\Models\\Receipt',4190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',358.00,NULL,NULL,1,'2023-04-30 16:02:49','2023-04-30 16:02:49',NULL),(4181,NULL,40719,36,2,4191,'App\\Models\\Receipt',4191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',819.00,NULL,NULL,1,'2023-04-30 16:02:50','2023-04-30 16:02:50',NULL),(4182,NULL,40719,36,2,4192,'App\\Models\\Receipt',4192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',449.00,NULL,NULL,1,'2023-04-30 16:02:50','2023-04-30 16:02:50',NULL),(4183,NULL,40719,36,2,4193,'App\\Models\\Receipt',4193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',417.00,NULL,NULL,1,'2023-04-30 16:02:51','2023-04-30 16:02:51',NULL),(4184,NULL,40719,36,2,4194,'App\\Models\\Receipt',4194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',343.00,NULL,NULL,1,'2023-04-30 16:02:52','2023-04-30 16:02:52',NULL),(4185,NULL,40719,36,2,4195,'App\\Models\\Receipt',4195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',341.00,NULL,NULL,1,'2023-04-30 16:02:53','2023-04-30 16:02:53',NULL),(4186,NULL,40719,36,2,4196,'App\\Models\\Receipt',4196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',481.00,NULL,NULL,1,'2023-04-30 16:02:54','2023-04-30 16:02:54',NULL),(4187,NULL,40719,36,2,4197,'App\\Models\\Receipt',4197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',525.00,NULL,NULL,1,'2023-04-30 16:02:54','2023-04-30 16:02:54',NULL),(4188,NULL,40719,36,2,4198,'App\\Models\\Receipt',4198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',855.00,NULL,NULL,1,'2023-04-30 16:02:55','2023-04-30 16:02:55',NULL),(4189,NULL,40719,36,2,4199,'App\\Models\\Receipt',4199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',489.00,NULL,NULL,1,'2023-04-30 16:02:56','2023-04-30 16:02:56',NULL),(4190,NULL,40719,36,2,4200,'App\\Models\\Receipt',4200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',871.00,NULL,NULL,1,'2023-04-30 16:02:57','2023-04-30 16:02:57',NULL),(4191,NULL,40719,36,2,4201,'App\\Models\\Receipt',4201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',428.00,NULL,NULL,1,'2023-04-30 16:02:58','2023-04-30 16:02:58',NULL),(4192,NULL,40719,36,2,4202,'App\\Models\\Receipt',4202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',679.00,NULL,NULL,1,'2023-04-30 16:02:58','2023-04-30 16:02:58',NULL),(4193,NULL,40719,36,2,4203,'App\\Models\\Receipt',4203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',895.00,NULL,NULL,1,'2023-04-30 16:02:59','2023-04-30 16:02:59',NULL),(4194,NULL,40719,36,2,4204,'App\\Models\\Receipt',4204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',465.00,NULL,NULL,1,'2023-04-30 16:03:00','2023-04-30 16:03:00',NULL),(4195,NULL,40719,36,2,4205,'App\\Models\\Receipt',4205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',379.00,NULL,NULL,1,'2023-04-30 16:03:01','2023-04-30 16:03:01',NULL),(4196,NULL,40719,36,2,4206,'App\\Models\\Receipt',4206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',836.00,NULL,NULL,1,'2023-04-30 16:03:02','2023-04-30 16:03:02',NULL),(4197,NULL,40719,36,2,4207,'App\\Models\\Receipt',4207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',776.00,NULL,NULL,1,'2023-04-30 16:03:03','2023-04-30 16:03:03',NULL),(4198,NULL,40719,36,2,4208,'App\\Models\\Receipt',4208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',349.00,NULL,NULL,1,'2023-04-30 16:03:03','2023-04-30 16:03:03',NULL);
INSERT INTO `balance_libro` VALUES (4199,NULL,40719,36,2,4209,'App\\Models\\Receipt',4209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',551.00,NULL,NULL,1,'2023-04-30 16:03:04','2023-04-30 16:03:04',NULL),(4200,NULL,40719,36,2,4210,'App\\Models\\Receipt',4210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',485.00,NULL,NULL,1,'2023-04-30 16:03:05','2023-04-30 16:03:05',NULL),(4201,NULL,40719,36,2,4211,'App\\Models\\Receipt',4211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',482.00,NULL,NULL,1,'2023-04-30 16:03:06','2023-04-30 16:03:06',NULL),(4202,NULL,40719,36,2,4212,'App\\Models\\Receipt',4212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',308.00,NULL,NULL,1,'2023-04-30 16:03:07','2023-04-30 16:03:07',NULL),(4203,NULL,40719,36,2,4213,'App\\Models\\Receipt',4213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',767.00,NULL,NULL,1,'2023-04-30 16:03:07','2023-04-30 16:03:07',NULL),(4204,NULL,40719,36,2,4214,'App\\Models\\Receipt',4214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',719.00,NULL,NULL,1,'2023-04-30 16:03:08','2023-04-30 16:03:08',NULL),(4205,NULL,40719,36,2,4215,'App\\Models\\Receipt',4215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',402.00,NULL,NULL,1,'2023-04-30 16:03:09','2023-04-30 16:03:09',NULL),(4206,NULL,40719,36,2,4216,'App\\Models\\Receipt',4216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',348.00,NULL,NULL,1,'2023-04-30 16:03:10','2023-04-30 16:03:10',NULL),(4207,NULL,40719,36,2,4217,'App\\Models\\Receipt',4217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',695.00,NULL,NULL,1,'2023-04-30 16:03:11','2023-04-30 16:03:11',NULL),(4208,NULL,40719,36,2,4218,'App\\Models\\Receipt',4218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',304.00,NULL,NULL,1,'2023-04-30 16:03:11','2023-04-30 16:03:11',NULL),(4209,NULL,40719,36,2,4219,'App\\Models\\Receipt',4219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',863.00,NULL,NULL,1,'2023-04-30 16:03:12','2023-04-30 16:03:12',NULL),(4210,NULL,40719,36,2,4220,'App\\Models\\Receipt',4220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',672.00,NULL,NULL,1,'2023-04-30 16:03:13','2023-04-30 16:03:13',NULL),(4211,NULL,40719,36,2,4221,'App\\Models\\Receipt',4221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',900.00,NULL,NULL,1,'2023-04-30 16:03:14','2023-04-30 16:03:14',NULL),(4212,NULL,40719,36,2,4222,'App\\Models\\Receipt',4222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',423.00,NULL,NULL,1,'2023-04-30 16:03:15','2023-04-30 16:03:15',NULL),(4213,NULL,40719,36,2,4223,'App\\Models\\Receipt',4223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',338.00,NULL,NULL,1,'2023-04-30 16:03:16','2023-04-30 16:03:16',NULL),(4214,NULL,40719,36,2,4224,'App\\Models\\Receipt',4224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',772.00,NULL,NULL,1,'2023-04-30 16:03:16','2023-04-30 16:03:16',NULL),(4215,NULL,40719,36,2,4225,'App\\Models\\Receipt',4225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',778.00,NULL,NULL,1,'2023-04-30 16:03:17','2023-04-30 16:03:17',NULL),(4216,NULL,40719,36,2,4226,'App\\Models\\Receipt',4226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',809.00,NULL,NULL,1,'2023-04-30 16:03:18','2023-04-30 16:03:18',NULL),(4217,NULL,40719,36,2,4227,'App\\Models\\Receipt',4227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',827.00,NULL,NULL,1,'2023-04-30 16:03:19','2023-04-30 16:03:19',NULL),(4218,NULL,40719,36,2,4228,'App\\Models\\Receipt',4228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',580.00,NULL,NULL,1,'2023-04-30 16:03:20','2023-04-30 16:03:20',NULL),(4219,NULL,40719,36,2,4229,'App\\Models\\Receipt',4229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',732.00,NULL,NULL,1,'2023-04-30 16:03:20','2023-04-30 16:03:20',NULL);
INSERT INTO `balance_libro` VALUES (4220,NULL,40719,36,2,4230,'App\\Models\\Receipt',4230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',728.00,NULL,NULL,1,'2023-04-30 16:03:21','2023-04-30 16:03:21',NULL),(4221,NULL,40719,36,2,4231,'App\\Models\\Receipt',4231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',330.00,NULL,NULL,1,'2023-04-30 16:03:22','2023-04-30 16:03:22',NULL),(4222,NULL,40719,36,2,4232,'App\\Models\\Receipt',4232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',503.00,NULL,NULL,1,'2023-04-30 16:03:23','2023-04-30 16:03:23',NULL),(4223,NULL,40719,36,2,4233,'App\\Models\\Receipt',4233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',376.00,NULL,NULL,1,'2023-04-30 16:03:24','2023-04-30 16:03:24',NULL),(4224,NULL,40719,36,2,4234,'App\\Models\\Receipt',4234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',303.00,NULL,NULL,1,'2023-04-30 16:03:25','2023-04-30 16:03:25',NULL),(4225,NULL,40719,36,2,4235,'App\\Models\\Receipt',4235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',685.00,NULL,NULL,1,'2023-04-30 16:03:26','2023-04-30 16:03:26',NULL),(4226,NULL,40719,36,2,4236,'App\\Models\\Receipt',4236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',593.00,NULL,NULL,1,'2023-04-30 16:03:26','2023-04-30 16:03:26',NULL),(4227,NULL,40719,36,2,4237,'App\\Models\\Receipt',4237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',866.00,NULL,NULL,1,'2023-04-30 16:03:27','2023-04-30 16:03:27',NULL),(4228,NULL,40719,36,2,4238,'App\\Models\\Receipt',4238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',395.00,NULL,NULL,1,'2023-04-30 16:03:28','2023-04-30 16:03:28',NULL),(4229,NULL,40719,36,2,4239,'App\\Models\\Receipt',4239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',887.00,NULL,NULL,1,'2023-04-30 16:03:29','2023-04-30 16:03:29',NULL),(4230,NULL,40719,36,2,4240,'App\\Models\\Receipt',4240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',645.00,NULL,NULL,1,'2023-04-30 16:03:30','2023-04-30 16:03:30',NULL),(4231,NULL,40719,36,2,4241,'App\\Models\\Receipt',4241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',482.00,NULL,NULL,1,'2023-04-30 16:03:30','2023-04-30 16:03:30',NULL),(4232,NULL,40719,36,2,4242,'App\\Models\\Receipt',4242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',420.00,NULL,NULL,1,'2023-04-30 16:03:31','2023-04-30 16:03:31',NULL),(4233,NULL,40719,36,2,4243,'App\\Models\\Receipt',4243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',533.00,NULL,NULL,1,'2023-04-30 16:03:32','2023-04-30 16:03:32',NULL),(4234,NULL,40719,36,2,4244,'App\\Models\\Receipt',4244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',335.00,NULL,NULL,1,'2023-04-30 16:03:33','2023-04-30 16:03:33',NULL),(4235,NULL,40719,36,2,4245,'App\\Models\\Receipt',4245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',495.00,NULL,NULL,1,'2023-04-30 16:03:34','2023-04-30 16:03:34',NULL),(4236,NULL,40719,36,2,4246,'App\\Models\\Receipt',4246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',870.00,NULL,NULL,1,'2023-04-30 16:03:35','2023-04-30 16:03:35',NULL),(4237,NULL,40719,36,2,4247,'App\\Models\\Receipt',4247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',473.00,NULL,NULL,1,'2023-04-30 16:03:35','2023-04-30 16:03:35',NULL),(4238,NULL,40719,36,2,4248,'App\\Models\\Receipt',4248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',551.00,NULL,NULL,1,'2023-04-30 16:03:36','2023-04-30 16:03:36',NULL),(4239,NULL,40719,36,2,4249,'App\\Models\\Receipt',4249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',323.00,NULL,NULL,1,'2023-04-30 16:03:37','2023-04-30 16:03:37',NULL),(4240,NULL,40719,36,2,4250,'App\\Models\\Receipt',4250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',360.00,NULL,NULL,1,'2023-04-30 16:03:38','2023-04-30 16:03:38',NULL);
INSERT INTO `balance_libro` VALUES (4241,NULL,40719,36,2,4251,'App\\Models\\Receipt',4251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',464.00,NULL,NULL,1,'2023-04-30 16:03:39','2023-04-30 16:03:39',NULL),(4242,NULL,40719,36,2,4252,'App\\Models\\Receipt',4252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',643.00,NULL,NULL,1,'2023-04-30 16:03:40','2023-04-30 16:03:40',NULL),(4243,NULL,40719,36,2,4253,'App\\Models\\Receipt',4253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',533.00,NULL,NULL,1,'2023-04-30 16:03:40','2023-04-30 16:03:40',NULL),(4244,NULL,40719,36,2,4254,'App\\Models\\Receipt',4254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',501.00,NULL,NULL,1,'2023-04-30 16:03:41','2023-04-30 16:03:41',NULL),(4245,NULL,40719,36,2,4255,'App\\Models\\Receipt',4255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',651.00,NULL,NULL,1,'2023-04-30 16:03:42','2023-04-30 16:03:42',NULL),(4246,NULL,40719,36,2,4256,'App\\Models\\Receipt',4256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',893.00,NULL,NULL,1,'2023-04-30 16:03:43','2023-04-30 16:03:43',NULL),(4247,NULL,40719,36,2,4257,'App\\Models\\Receipt',4257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',362.00,NULL,NULL,1,'2023-04-30 16:03:44','2023-04-30 16:03:44',NULL),(4248,NULL,40719,36,2,4258,'App\\Models\\Receipt',4258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',428.00,NULL,NULL,1,'2023-04-30 16:03:44','2023-04-30 16:03:44',NULL),(4249,NULL,40719,36,2,4259,'App\\Models\\Receipt',4259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',801.00,NULL,NULL,1,'2023-04-30 16:03:45','2023-04-30 16:03:45',NULL),(4250,NULL,40719,36,2,4260,'App\\Models\\Receipt',4260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',340.00,NULL,NULL,1,'2023-04-30 16:03:46','2023-04-30 16:03:46',NULL),(4251,NULL,40719,36,2,4261,'App\\Models\\Receipt',4261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',595.00,NULL,NULL,1,'2023-04-30 16:03:47','2023-04-30 16:03:47',NULL),(4252,NULL,40719,36,2,4262,'App\\Models\\Receipt',4262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',606.00,NULL,NULL,1,'2023-04-30 16:03:48','2023-04-30 16:03:48',NULL),(4253,NULL,40719,36,2,4263,'App\\Models\\Receipt',4263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',826.00,NULL,NULL,1,'2023-04-30 16:03:49','2023-04-30 16:03:49',NULL),(4254,NULL,40719,36,2,4264,'App\\Models\\Receipt',4264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',546.00,NULL,NULL,1,'2023-04-30 16:03:49','2023-04-30 16:03:49',NULL),(4255,NULL,40719,36,2,4265,'App\\Models\\Receipt',4265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',529.00,NULL,NULL,1,'2023-04-30 16:03:50','2023-04-30 16:03:50',NULL),(4256,NULL,40719,36,2,4266,'App\\Models\\Receipt',4266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',329.00,NULL,NULL,1,'2023-04-30 16:03:51','2023-04-30 16:03:51',NULL),(4257,NULL,40719,36,2,4267,'App\\Models\\Receipt',4267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',621.00,NULL,NULL,1,'2023-04-30 16:03:52','2023-04-30 16:03:52',NULL),(4258,NULL,40719,36,2,4268,'App\\Models\\Receipt',4268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',633.00,NULL,NULL,1,'2023-04-30 16:03:53','2023-04-30 16:03:53',NULL),(4259,NULL,40719,36,2,4269,'App\\Models\\Receipt',4269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',892.00,NULL,NULL,1,'2023-04-30 16:03:54','2023-04-30 16:03:54',NULL),(4260,NULL,40719,36,2,4270,'App\\Models\\Receipt',4270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',815.00,NULL,NULL,1,'2023-04-30 16:03:54','2023-04-30 16:03:54',NULL),(4261,NULL,40719,36,2,4271,'App\\Models\\Receipt',4271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',448.00,NULL,NULL,1,'2023-04-30 16:03:55','2023-04-30 16:03:55',NULL);
INSERT INTO `balance_libro` VALUES (4262,NULL,40719,36,2,4272,'App\\Models\\Receipt',4272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',660.00,NULL,NULL,1,'2023-04-30 16:03:56','2023-04-30 16:03:56',NULL),(4263,NULL,40719,36,2,4273,'App\\Models\\Receipt',4273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',311.00,NULL,NULL,1,'2023-04-30 16:03:57','2023-04-30 16:03:57',NULL),(4264,NULL,40719,36,2,4274,'App\\Models\\Receipt',4274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',673.00,NULL,NULL,1,'2023-04-30 16:03:58','2023-04-30 16:03:58',NULL),(4265,NULL,40719,36,2,4275,'App\\Models\\Receipt',4275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',768.00,NULL,NULL,1,'2023-04-30 16:03:58','2023-04-30 16:03:58',NULL),(4266,NULL,40719,36,2,4276,'App\\Models\\Receipt',4276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',820.00,NULL,NULL,1,'2023-04-30 16:03:59','2023-04-30 16:03:59',NULL),(4267,NULL,40719,36,2,4277,'App\\Models\\Receipt',4277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',399.00,NULL,NULL,1,'2023-04-30 16:04:00','2023-04-30 16:04:00',NULL),(4268,NULL,40719,36,2,4278,'App\\Models\\Receipt',4278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',316.00,NULL,NULL,1,'2023-04-30 16:04:01','2023-04-30 16:04:01',NULL),(4269,NULL,40719,36,2,4279,'App\\Models\\Receipt',4279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',816.00,NULL,NULL,1,'2023-04-30 16:04:02','2023-04-30 16:04:02',NULL),(4270,NULL,40719,36,2,4280,'App\\Models\\Receipt',4280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',579.00,NULL,NULL,1,'2023-04-30 16:04:03','2023-04-30 16:04:03',NULL),(4271,NULL,40719,36,2,4281,'App\\Models\\Receipt',4281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',854.00,NULL,NULL,1,'2023-04-30 16:04:03','2023-04-30 16:04:03',NULL),(4272,NULL,40719,36,2,4282,'App\\Models\\Receipt',4282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',642.00,NULL,NULL,1,'2023-04-30 16:04:04','2023-04-30 16:04:04',NULL),(4273,NULL,40719,36,2,4283,'App\\Models\\Receipt',4283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',881.00,NULL,NULL,1,'2023-04-30 16:04:05','2023-04-30 16:04:05',NULL),(4274,NULL,40719,36,2,4284,'App\\Models\\Receipt',4284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',387.00,NULL,NULL,1,'2023-04-30 16:04:06','2023-04-30 16:04:06',NULL),(4275,NULL,40719,36,2,4285,'App\\Models\\Receipt',4285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',863.00,NULL,NULL,1,'2023-04-30 16:04:07','2023-04-30 16:04:07',NULL),(4276,NULL,40719,36,2,4286,'App\\Models\\Receipt',4286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',750.00,NULL,NULL,1,'2023-04-30 16:04:08','2023-04-30 16:04:08',NULL),(4277,NULL,40719,36,2,4287,'App\\Models\\Receipt',4287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',616.00,NULL,NULL,1,'2023-04-30 16:04:08','2023-04-30 16:04:08',NULL),(4278,NULL,40719,36,2,4288,'App\\Models\\Receipt',4288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',478.00,NULL,NULL,1,'2023-04-30 16:04:09','2023-04-30 16:04:09',NULL),(4279,NULL,40719,36,2,4289,'App\\Models\\Receipt',4289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',376.00,NULL,NULL,1,'2023-04-30 16:04:10','2023-04-30 16:04:10',NULL),(4280,NULL,40719,36,2,4290,'App\\Models\\Receipt',4290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',585.00,NULL,NULL,1,'2023-04-30 16:04:11','2023-04-30 16:04:11',NULL),(4281,NULL,40719,36,2,4291,'App\\Models\\Receipt',4291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',569.00,NULL,NULL,1,'2023-04-30 16:04:12','2023-04-30 16:04:12',NULL),(4282,NULL,40719,36,2,4292,'App\\Models\\Receipt',4292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',530.00,NULL,NULL,1,'2023-04-30 16:04:13','2023-04-30 16:04:13',NULL);
INSERT INTO `balance_libro` VALUES (4283,NULL,40719,36,2,4293,'App\\Models\\Receipt',4293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',505.00,NULL,NULL,1,'2023-04-30 16:04:13','2023-04-30 16:04:13',NULL),(4284,NULL,40719,36,2,4294,'App\\Models\\Receipt',4294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',655.00,NULL,NULL,1,'2023-04-30 16:04:14','2023-04-30 16:04:14',NULL),(4285,NULL,40719,36,2,4295,'App\\Models\\Receipt',4295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',486.00,NULL,NULL,1,'2023-04-30 16:04:15','2023-04-30 16:04:15',NULL),(4286,NULL,40719,36,2,4296,'App\\Models\\Receipt',4296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',491.00,NULL,NULL,1,'2023-04-30 16:04:16','2023-04-30 16:04:16',NULL),(4287,NULL,40719,36,2,4297,'App\\Models\\Receipt',4297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',784.00,NULL,NULL,1,'2023-04-30 16:04:17','2023-04-30 16:04:17',NULL),(4288,NULL,40719,36,2,4298,'App\\Models\\Receipt',4298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',393.00,NULL,NULL,1,'2023-04-30 16:04:17','2023-04-30 16:04:17',NULL),(4289,NULL,40719,36,2,4299,'App\\Models\\Receipt',4299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',564.00,NULL,NULL,1,'2023-04-30 16:04:18','2023-04-30 16:04:18',NULL),(4290,NULL,40719,36,2,4300,'App\\Models\\Receipt',4300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',630.00,NULL,NULL,1,'2023-04-30 16:04:19','2023-04-30 16:04:19',NULL),(4291,NULL,40719,36,2,4301,'App\\Models\\Receipt',4301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',485.00,NULL,NULL,1,'2023-04-30 16:04:20','2023-04-30 16:04:20',NULL),(4292,NULL,40719,36,2,4302,'App\\Models\\Receipt',4302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',330.00,NULL,NULL,1,'2023-04-30 16:04:21','2023-04-30 16:04:21',NULL),(4293,NULL,40719,36,2,4303,'App\\Models\\Receipt',4303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',809.00,NULL,NULL,1,'2023-04-30 16:04:22','2023-04-30 16:04:22',NULL),(4294,NULL,40719,36,2,4304,'App\\Models\\Receipt',4304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',687.00,NULL,NULL,1,'2023-04-30 16:04:22','2023-04-30 16:04:22',NULL),(4295,NULL,40719,36,2,4305,'App\\Models\\Receipt',4305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',872.00,NULL,NULL,1,'2023-04-30 16:04:23','2023-04-30 16:04:23',NULL),(4296,NULL,40719,36,2,4306,'App\\Models\\Receipt',4306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',889.00,NULL,NULL,1,'2023-04-30 16:04:24','2023-04-30 16:04:24',NULL),(4297,NULL,40719,36,2,4307,'App\\Models\\Receipt',4307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',444.00,NULL,NULL,1,'2023-04-30 16:04:25','2023-04-30 16:04:25',NULL),(4298,NULL,40719,36,2,4308,'App\\Models\\Receipt',4308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',446.00,NULL,NULL,1,'2023-04-30 16:04:26','2023-04-30 16:04:26',NULL),(4299,NULL,40719,36,2,4309,'App\\Models\\Receipt',4309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',489.00,NULL,NULL,1,'2023-04-30 16:04:26','2023-04-30 16:04:26',NULL),(4300,NULL,40719,36,2,4310,'App\\Models\\Receipt',4310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',715.00,NULL,NULL,1,'2023-04-30 16:04:27','2023-04-30 16:04:27',NULL),(4301,NULL,40719,36,2,4311,'App\\Models\\Receipt',4311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',506.00,NULL,NULL,1,'2023-04-30 16:04:28','2023-04-30 16:04:28',NULL),(4302,NULL,40719,36,2,4312,'App\\Models\\Receipt',4312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',374.00,NULL,NULL,1,'2023-04-30 16:04:29','2023-04-30 16:04:29',NULL),(4303,NULL,40719,36,2,4313,'App\\Models\\Receipt',4313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',891.00,NULL,NULL,1,'2023-04-30 16:04:30','2023-04-30 16:04:30',NULL);
INSERT INTO `balance_libro` VALUES (4304,NULL,40719,36,2,4314,'App\\Models\\Receipt',4314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',630.00,NULL,NULL,1,'2023-04-30 16:04:31','2023-04-30 16:04:31',NULL),(4305,NULL,40719,36,2,4315,'App\\Models\\Receipt',4315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',497.00,NULL,NULL,1,'2023-04-30 16:04:31','2023-04-30 16:04:31',NULL),(4306,NULL,40719,36,2,4316,'App\\Models\\Receipt',4316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',854.00,NULL,NULL,1,'2023-04-30 16:04:32','2023-04-30 16:04:32',NULL),(4307,NULL,40719,36,2,4317,'App\\Models\\Receipt',4317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',798.00,NULL,NULL,1,'2023-04-30 16:04:33','2023-04-30 16:04:33',NULL),(4308,NULL,40719,36,2,4318,'App\\Models\\Receipt',4318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',429.00,NULL,NULL,1,'2023-04-30 16:04:34','2023-04-30 16:04:34',NULL),(4309,NULL,40719,36,2,4319,'App\\Models\\Receipt',4319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',591.00,NULL,NULL,1,'2023-04-30 16:04:35','2023-04-30 16:04:35',NULL),(4310,NULL,40719,36,2,4320,'App\\Models\\Receipt',4320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',795.00,NULL,NULL,1,'2023-04-30 16:04:35','2023-04-30 16:04:35',NULL),(4311,NULL,40719,36,2,4321,'App\\Models\\Receipt',4321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',777.00,NULL,NULL,1,'2023-04-30 16:04:36','2023-04-30 16:04:36',NULL),(4312,NULL,40719,36,2,4322,'App\\Models\\Receipt',4322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',431.00,NULL,NULL,1,'2023-04-30 16:04:37','2023-04-30 16:04:37',NULL),(4313,NULL,40719,36,2,4323,'App\\Models\\Receipt',4323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',403.00,NULL,NULL,1,'2023-04-30 16:04:38','2023-04-30 16:04:38',NULL),(4314,NULL,40719,36,2,4324,'App\\Models\\Receipt',4324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',375.00,NULL,NULL,1,'2023-04-30 16:04:39','2023-04-30 16:04:39',NULL),(4315,NULL,40719,36,2,4325,'App\\Models\\Receipt',4325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',700.00,NULL,NULL,1,'2023-04-30 16:04:40','2023-04-30 16:04:40',NULL),(4316,NULL,40719,36,2,4326,'App\\Models\\Receipt',4326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',710.00,NULL,NULL,1,'2023-04-30 16:04:40','2023-04-30 16:04:40',NULL),(4317,NULL,40719,36,2,4327,'App\\Models\\Receipt',4327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',704.00,NULL,NULL,1,'2023-04-30 16:04:41','2023-04-30 16:04:41',NULL),(4318,NULL,40719,36,2,4328,'App\\Models\\Receipt',4328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',376.00,NULL,NULL,1,'2023-04-30 16:04:42','2023-04-30 16:04:42',NULL),(4319,NULL,40719,36,2,4329,'App\\Models\\Receipt',4329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',323.00,NULL,NULL,1,'2023-04-30 16:04:43','2023-04-30 16:04:43',NULL),(4320,NULL,40719,36,2,4330,'App\\Models\\Receipt',4330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',510.00,NULL,NULL,1,'2023-04-30 16:04:44','2023-04-30 16:04:44',NULL),(4321,NULL,40719,36,2,4331,'App\\Models\\Receipt',4331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',806.00,NULL,NULL,1,'2023-04-30 16:04:44','2023-04-30 16:04:44',NULL),(4322,NULL,40719,36,2,4332,'App\\Models\\Receipt',4332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',455.00,NULL,NULL,1,'2023-04-30 16:04:45','2023-04-30 16:04:45',NULL),(4323,NULL,40719,36,2,4333,'App\\Models\\Receipt',4333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',715.00,NULL,NULL,1,'2023-04-30 16:04:46','2023-04-30 16:04:46',NULL),(4324,NULL,40719,36,2,4334,'App\\Models\\Receipt',4334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',463.00,NULL,NULL,1,'2023-04-30 16:04:47','2023-04-30 16:04:47',NULL);
INSERT INTO `balance_libro` VALUES (4325,NULL,40719,36,2,4335,'App\\Models\\Receipt',4335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',500.00,NULL,NULL,1,'2023-04-30 16:04:48','2023-04-30 16:04:48',NULL),(4326,NULL,40719,36,2,4336,'App\\Models\\Receipt',4336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',705.00,NULL,NULL,1,'2023-04-30 16:04:49','2023-04-30 16:04:49',NULL),(4327,NULL,40719,36,2,4337,'App\\Models\\Receipt',4337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',687.00,NULL,NULL,1,'2023-04-30 16:04:49','2023-04-30 16:04:49',NULL),(4328,NULL,40719,36,2,4338,'App\\Models\\Receipt',4338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',460.00,NULL,NULL,1,'2023-04-30 16:04:50','2023-04-30 16:04:50',NULL),(4329,NULL,40719,36,2,4339,'App\\Models\\Receipt',4339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',746.00,NULL,NULL,1,'2023-04-30 16:04:51','2023-04-30 16:04:51',NULL),(4330,NULL,40719,36,2,4340,'App\\Models\\Receipt',4340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',798.00,NULL,NULL,1,'2023-04-30 16:04:52','2023-04-30 16:04:52',NULL),(4331,NULL,40719,36,2,4341,'App\\Models\\Receipt',4341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',584.00,NULL,NULL,1,'2023-04-30 16:04:53','2023-04-30 16:04:53',NULL),(4332,NULL,40719,36,2,4342,'App\\Models\\Receipt',4342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',464.00,NULL,NULL,1,'2023-04-30 16:04:54','2023-04-30 16:04:54',NULL),(4333,NULL,40719,36,2,4343,'App\\Models\\Receipt',4343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',439.00,NULL,NULL,1,'2023-04-30 16:04:54','2023-04-30 16:04:54',NULL),(4334,NULL,40719,36,2,4344,'App\\Models\\Receipt',4344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',707.00,NULL,NULL,1,'2023-04-30 16:04:55','2023-04-30 16:04:55',NULL),(4335,NULL,40719,36,2,4345,'App\\Models\\Receipt',4345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',807.00,NULL,NULL,1,'2023-04-30 16:04:56','2023-04-30 16:04:56',NULL),(4336,NULL,40719,36,2,4346,'App\\Models\\Receipt',4346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',459.00,NULL,NULL,1,'2023-04-30 16:04:57','2023-04-30 16:04:57',NULL),(4337,NULL,40719,36,2,4347,'App\\Models\\Receipt',4347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',335.00,NULL,NULL,1,'2023-04-30 16:04:58','2023-04-30 16:04:58',NULL),(4338,NULL,40719,36,2,4348,'App\\Models\\Receipt',4348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',450.00,NULL,NULL,1,'2023-04-30 16:04:59','2023-04-30 16:04:59',NULL),(4339,NULL,40719,36,2,4349,'App\\Models\\Receipt',4349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',791.00,NULL,NULL,1,'2023-04-30 16:04:59','2023-04-30 16:04:59',NULL),(4340,NULL,40719,36,2,4350,'App\\Models\\Receipt',4350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',451.00,NULL,NULL,1,'2023-04-30 16:05:00','2023-04-30 16:05:00',NULL),(4341,NULL,40719,36,2,4351,'App\\Models\\Receipt',4351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',898.00,NULL,NULL,1,'2023-04-30 16:05:01','2023-04-30 16:05:01',NULL),(4342,NULL,40719,36,2,4352,'App\\Models\\Receipt',4352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',474.00,NULL,NULL,1,'2023-04-30 16:05:02','2023-04-30 16:05:02',NULL),(4343,NULL,40719,36,2,4353,'App\\Models\\Receipt',4353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',438.00,NULL,NULL,1,'2023-04-30 16:05:03','2023-04-30 16:05:03',NULL),(4344,NULL,40719,36,2,4354,'App\\Models\\Receipt',4354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',427.00,NULL,NULL,1,'2023-04-30 16:05:04','2023-04-30 16:05:04',NULL),(4345,NULL,40719,36,2,4355,'App\\Models\\Receipt',4355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',743.00,NULL,NULL,1,'2023-04-30 16:05:04','2023-04-30 16:05:04',NULL);
INSERT INTO `balance_libro` VALUES (4346,NULL,40719,36,2,4356,'App\\Models\\Receipt',4356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',626.00,NULL,NULL,1,'2023-04-30 16:05:05','2023-04-30 16:05:05',NULL),(4347,NULL,40719,36,2,4357,'App\\Models\\Receipt',4357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',472.00,NULL,NULL,1,'2023-04-30 16:05:06','2023-04-30 16:05:06',NULL),(4348,NULL,40719,36,2,4358,'App\\Models\\Receipt',4358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',613.00,NULL,NULL,1,'2023-04-30 16:05:07','2023-04-30 16:05:07',NULL),(4349,NULL,40719,36,2,4359,'App\\Models\\Receipt',4359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',503.00,NULL,NULL,1,'2023-04-30 16:05:08','2023-04-30 16:05:08',NULL),(4350,NULL,40719,36,2,4360,'App\\Models\\Receipt',4360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',338.00,NULL,NULL,1,'2023-04-30 16:05:09','2023-04-30 16:05:09',NULL),(4351,NULL,40719,36,2,4361,'App\\Models\\Receipt',4361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',666.00,NULL,NULL,1,'2023-04-30 16:05:09','2023-04-30 16:05:09',NULL),(4352,NULL,40719,36,2,4362,'App\\Models\\Receipt',4362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',610.00,NULL,NULL,1,'2023-04-30 16:05:10','2023-04-30 16:05:10',NULL),(4353,NULL,40719,36,2,4363,'App\\Models\\Receipt',4363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',364.00,NULL,NULL,1,'2023-04-30 16:05:11','2023-04-30 16:05:11',NULL),(4354,NULL,40719,36,2,4364,'App\\Models\\Receipt',4364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',660.00,NULL,NULL,1,'2023-04-30 16:05:12','2023-04-30 16:05:12',NULL),(4355,NULL,40719,36,2,4365,'App\\Models\\Receipt',4365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',384.00,NULL,NULL,1,'2023-04-30 16:05:13','2023-04-30 16:05:13',NULL),(4356,NULL,40719,36,2,4366,'App\\Models\\Receipt',4366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',537.00,NULL,NULL,1,'2023-04-30 16:05:14','2023-04-30 16:05:14',NULL),(4357,NULL,40719,36,2,4367,'App\\Models\\Receipt',4367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',688.00,NULL,NULL,1,'2023-04-30 16:05:14','2023-04-30 16:05:14',NULL),(4358,NULL,40719,36,2,4368,'App\\Models\\Receipt',4368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',730.00,NULL,NULL,1,'2023-04-30 16:05:15','2023-04-30 16:05:15',NULL),(4359,NULL,40719,36,2,4369,'App\\Models\\Receipt',4369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',706.00,NULL,NULL,1,'2023-04-30 16:05:16','2023-04-30 16:05:16',NULL),(4360,NULL,40719,36,2,4370,'App\\Models\\Receipt',4370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',639.00,NULL,NULL,1,'2023-04-30 16:05:17','2023-04-30 16:05:17',NULL),(4361,NULL,40719,36,2,4371,'App\\Models\\Receipt',4371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',562.00,NULL,NULL,1,'2023-04-30 16:05:18','2023-04-30 16:05:18',NULL),(4362,NULL,40719,36,2,4372,'App\\Models\\Receipt',4372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',794.00,NULL,NULL,1,'2023-04-30 16:05:18','2023-04-30 16:05:18',NULL),(4363,NULL,40719,36,2,4373,'App\\Models\\Receipt',4373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',489.00,NULL,NULL,1,'2023-04-30 16:05:19','2023-04-30 16:05:19',NULL),(4364,NULL,40719,36,2,4374,'App\\Models\\Receipt',4374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',818.00,NULL,NULL,1,'2023-04-30 16:05:20','2023-04-30 16:05:20',NULL),(4365,NULL,40719,36,2,4375,'App\\Models\\Receipt',4375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',849.00,NULL,NULL,1,'2023-04-30 16:05:21','2023-04-30 16:05:21',NULL),(4366,NULL,40719,36,2,4376,'App\\Models\\Receipt',4376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',710.00,NULL,NULL,1,'2023-04-30 16:05:22','2023-04-30 16:05:22',NULL);
INSERT INTO `balance_libro` VALUES (4367,NULL,40719,36,2,4377,'App\\Models\\Receipt',4377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',765.00,NULL,NULL,1,'2023-04-30 16:05:23','2023-04-30 16:05:23',NULL),(4368,NULL,40719,36,2,4378,'App\\Models\\Receipt',4378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',825.00,NULL,NULL,1,'2023-04-30 16:05:24','2023-04-30 16:05:24',NULL),(4369,NULL,40719,36,2,4379,'App\\Models\\Receipt',4379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',326.00,NULL,NULL,1,'2023-04-30 16:05:24','2023-04-30 16:05:24',NULL),(4370,NULL,40719,36,2,4380,'App\\Models\\Receipt',4380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',473.00,NULL,NULL,1,'2023-04-30 16:05:25','2023-04-30 16:05:25',NULL),(4371,NULL,40719,36,2,4381,'App\\Models\\Receipt',4381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',508.00,NULL,NULL,1,'2023-04-30 16:05:26','2023-04-30 16:05:26',NULL),(4372,NULL,40719,36,2,4382,'App\\Models\\Receipt',4382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',673.00,NULL,NULL,1,'2023-04-30 16:05:27','2023-04-30 16:05:27',NULL),(4373,NULL,40719,36,2,4383,'App\\Models\\Receipt',4383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',436.00,NULL,NULL,1,'2023-04-30 16:05:28','2023-04-30 16:05:28',NULL),(4374,NULL,40719,36,2,4384,'App\\Models\\Receipt',4384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',435.00,NULL,NULL,1,'2023-04-30 16:05:29','2023-04-30 16:05:29',NULL),(4375,NULL,40719,36,2,4385,'App\\Models\\Receipt',4385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',460.00,NULL,NULL,1,'2023-04-30 16:05:29','2023-04-30 16:05:29',NULL),(4376,NULL,40719,36,2,4386,'App\\Models\\Receipt',4386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',634.00,NULL,NULL,1,'2023-04-30 16:05:30','2023-04-30 16:05:30',NULL),(4377,NULL,40719,36,2,4387,'App\\Models\\Receipt',4387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',760.00,NULL,NULL,1,'2023-04-30 16:05:31','2023-04-30 16:05:31',NULL),(4378,NULL,40719,36,2,4388,'App\\Models\\Receipt',4388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',767.00,NULL,NULL,1,'2023-04-30 16:05:32','2023-04-30 16:05:32',NULL),(4379,NULL,40719,36,2,4389,'App\\Models\\Receipt',4389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',524.00,NULL,NULL,1,'2023-04-30 16:05:33','2023-04-30 16:05:33',NULL),(4380,NULL,40719,36,2,4390,'App\\Models\\Receipt',4390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',693.00,NULL,NULL,1,'2023-04-30 16:05:34','2023-04-30 16:05:34',NULL),(4381,NULL,40719,36,2,4391,'App\\Models\\Receipt',4391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',448.00,NULL,NULL,1,'2023-04-30 16:05:34','2023-04-30 16:05:34',NULL),(4382,NULL,40719,36,2,4392,'App\\Models\\Receipt',4392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',326.00,NULL,NULL,1,'2023-04-30 16:05:35','2023-04-30 16:05:35',NULL),(4383,NULL,40719,36,2,4393,'App\\Models\\Receipt',4393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',464.00,NULL,NULL,1,'2023-04-30 16:05:36','2023-04-30 16:05:36',NULL),(4384,NULL,40719,36,2,4394,'App\\Models\\Receipt',4394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',813.00,NULL,NULL,1,'2023-04-30 16:05:37','2023-04-30 16:05:37',NULL),(4385,NULL,40719,36,2,4395,'App\\Models\\Receipt',4395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',837.00,NULL,NULL,1,'2023-04-30 16:05:38','2023-04-30 16:05:38',NULL),(4386,NULL,40719,36,2,4396,'App\\Models\\Receipt',4396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',479.00,NULL,NULL,1,'2023-04-30 16:05:38','2023-04-30 16:05:38',NULL),(4387,NULL,40719,36,2,4397,'App\\Models\\Receipt',4397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',678.00,NULL,NULL,1,'2023-04-30 16:05:39','2023-04-30 16:05:39',NULL);
INSERT INTO `balance_libro` VALUES (4388,NULL,40719,36,2,4398,'App\\Models\\Receipt',4398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',759.00,NULL,NULL,1,'2023-04-30 16:05:40','2023-04-30 16:05:40',NULL),(4389,NULL,40719,36,2,4399,'App\\Models\\Receipt',4399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',550.00,NULL,NULL,1,'2023-04-30 16:05:41','2023-04-30 16:05:41',NULL),(4390,NULL,40719,36,2,4400,'App\\Models\\Receipt',4400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',702.00,NULL,NULL,1,'2023-04-30 16:05:42','2023-04-30 16:05:42',NULL),(4391,NULL,40719,36,2,4401,'App\\Models\\Receipt',4401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',796.00,NULL,NULL,1,'2023-04-30 16:05:43','2023-04-30 16:05:43',NULL),(4392,NULL,40719,36,2,4402,'App\\Models\\Receipt',4402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',806.00,NULL,NULL,1,'2023-04-30 16:05:44','2023-04-30 16:05:44',NULL),(4393,NULL,40719,36,2,4403,'App\\Models\\Receipt',4403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',824.00,NULL,NULL,1,'2023-04-30 16:05:44','2023-04-30 16:05:44',NULL),(4394,NULL,40719,36,2,4404,'App\\Models\\Receipt',4404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',877.00,NULL,NULL,1,'2023-04-30 16:05:45','2023-04-30 16:05:45',NULL),(4395,NULL,40719,36,2,4405,'App\\Models\\Receipt',4405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',330.00,NULL,NULL,1,'2023-04-30 16:05:46','2023-04-30 16:05:46',NULL),(4396,NULL,40719,36,2,4406,'App\\Models\\Receipt',4406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',743.00,NULL,NULL,1,'2023-04-30 16:05:47','2023-04-30 16:05:47',NULL),(4397,NULL,40719,36,2,4407,'App\\Models\\Receipt',4407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',791.00,NULL,NULL,1,'2023-04-30 16:05:48','2023-04-30 16:05:48',NULL),(4398,NULL,40719,36,2,4408,'App\\Models\\Receipt',4408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',360.00,NULL,NULL,1,'2023-04-30 16:05:49','2023-04-30 16:05:49',NULL),(4399,NULL,40719,36,2,4409,'App\\Models\\Receipt',4409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',697.00,NULL,NULL,1,'2023-04-30 16:05:49','2023-04-30 16:05:49',NULL),(4400,NULL,40719,36,2,4410,'App\\Models\\Receipt',4410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',629.00,NULL,NULL,1,'2023-04-30 16:05:50','2023-04-30 16:05:50',NULL),(4401,NULL,40719,36,2,4411,'App\\Models\\Receipt',4411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',528.00,NULL,NULL,1,'2023-04-30 16:05:51','2023-04-30 16:05:51',NULL),(4402,NULL,40719,36,2,4412,'App\\Models\\Receipt',4412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',482.00,NULL,NULL,1,'2023-04-30 16:05:52','2023-04-30 16:05:52',NULL),(4403,NULL,40719,36,2,4413,'App\\Models\\Receipt',4413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',848.00,NULL,NULL,1,'2023-04-30 16:05:53','2023-04-30 16:05:53',NULL),(4404,NULL,40719,36,2,4414,'App\\Models\\Receipt',4414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',351.00,NULL,NULL,1,'2023-04-30 16:05:54','2023-04-30 16:05:54',NULL),(4405,NULL,40719,36,2,4415,'App\\Models\\Receipt',4415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',852.00,NULL,NULL,1,'2023-04-30 16:05:55','2023-04-30 16:05:55',NULL),(4406,NULL,40719,36,2,4416,'App\\Models\\Receipt',4416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',555.00,NULL,NULL,1,'2023-04-30 16:05:55','2023-04-30 16:05:55',NULL),(4407,NULL,40719,36,2,4417,'App\\Models\\Receipt',4417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',432.00,NULL,NULL,1,'2023-04-30 16:05:56','2023-04-30 16:05:56',NULL),(4408,NULL,40719,36,2,4418,'App\\Models\\Receipt',4418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',355.00,NULL,NULL,1,'2023-04-30 16:05:57','2023-04-30 16:05:57',NULL);
INSERT INTO `balance_libro` VALUES (4409,NULL,40719,36,2,4419,'App\\Models\\Receipt',4419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',666.00,NULL,NULL,1,'2023-04-30 16:05:58','2023-04-30 16:05:58',NULL),(4410,NULL,40719,36,2,4420,'App\\Models\\Receipt',4420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',582.00,NULL,NULL,1,'2023-04-30 16:05:59','2023-04-30 16:05:59',NULL),(4411,NULL,40719,36,2,4421,'App\\Models\\Receipt',4421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',675.00,NULL,NULL,1,'2023-04-30 16:06:00','2023-04-30 16:06:00',NULL),(4412,NULL,40719,36,2,4422,'App\\Models\\Receipt',4422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',608.00,NULL,NULL,1,'2023-04-30 16:06:00','2023-04-30 16:06:00',NULL),(4413,NULL,40719,36,2,4423,'App\\Models\\Receipt',4423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',695.00,NULL,NULL,1,'2023-04-30 16:06:01','2023-04-30 16:06:01',NULL),(4414,NULL,40719,36,2,4424,'App\\Models\\Receipt',4424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',555.00,NULL,NULL,1,'2023-04-30 16:06:02','2023-04-30 16:06:02',NULL),(4415,NULL,40719,36,2,4425,'App\\Models\\Receipt',4425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',659.00,NULL,NULL,1,'2023-04-30 16:06:03','2023-04-30 16:06:03',NULL),(4416,NULL,40719,36,2,4426,'App\\Models\\Receipt',4426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',660.00,NULL,NULL,1,'2023-04-30 16:06:04','2023-04-30 16:06:04',NULL),(4417,NULL,40719,36,2,4427,'App\\Models\\Receipt',4427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',789.00,NULL,NULL,1,'2023-04-30 16:06:05','2023-04-30 16:06:05',NULL),(4418,NULL,40719,36,2,4428,'App\\Models\\Receipt',4428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',781.00,NULL,NULL,1,'2023-04-30 16:06:05','2023-04-30 16:06:05',NULL),(4419,NULL,40719,36,2,4429,'App\\Models\\Receipt',4429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',348.00,NULL,NULL,1,'2023-04-30 16:06:06','2023-04-30 16:06:06',NULL),(4420,NULL,40719,36,2,4430,'App\\Models\\Receipt',4430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',633.00,NULL,NULL,1,'2023-04-30 16:06:07','2023-04-30 16:06:07',NULL),(4421,NULL,40719,36,2,4431,'App\\Models\\Receipt',4431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',626.00,NULL,NULL,1,'2023-04-30 16:06:08','2023-04-30 16:06:08',NULL),(4422,NULL,40719,36,2,4432,'App\\Models\\Receipt',4432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',540.00,NULL,NULL,1,'2023-04-30 16:06:09','2023-04-30 16:06:09',NULL),(4423,NULL,40719,36,2,4433,'App\\Models\\Receipt',4433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',575.00,NULL,NULL,1,'2023-04-30 16:06:10','2023-04-30 16:06:10',NULL),(4424,NULL,40719,36,2,4434,'App\\Models\\Receipt',4434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',887.00,NULL,NULL,1,'2023-04-30 16:06:10','2023-04-30 16:06:10',NULL),(4425,NULL,40719,36,2,4435,'App\\Models\\Receipt',4435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',586.00,NULL,NULL,1,'2023-04-30 16:06:11','2023-04-30 16:06:11',NULL),(4426,NULL,40719,36,2,4436,'App\\Models\\Receipt',4436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',752.00,NULL,NULL,1,'2023-04-30 16:06:12','2023-04-30 16:06:12',NULL),(4427,NULL,40719,36,2,4437,'App\\Models\\Receipt',4437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',432.00,NULL,NULL,1,'2023-04-30 16:06:13','2023-04-30 16:06:13',NULL),(4428,NULL,40719,36,2,4438,'App\\Models\\Receipt',4438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',331.00,NULL,NULL,1,'2023-04-30 16:06:14','2023-04-30 16:06:14',NULL),(4429,NULL,40719,36,2,4439,'App\\Models\\Receipt',4439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',769.00,NULL,NULL,1,'2023-04-30 16:06:14','2023-04-30 16:06:14',NULL);
INSERT INTO `balance_libro` VALUES (4430,NULL,40719,36,2,4440,'App\\Models\\Receipt',4440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',715.00,NULL,NULL,1,'2023-04-30 16:06:15','2023-04-30 16:06:15',NULL),(4431,NULL,40719,36,2,4441,'App\\Models\\Receipt',4441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',424.00,NULL,NULL,1,'2023-04-30 16:06:16','2023-04-30 16:06:16',NULL),(4432,NULL,40719,36,2,4442,'App\\Models\\Receipt',4442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',795.00,NULL,NULL,1,'2023-04-30 16:06:17','2023-04-30 16:06:17',NULL),(4433,NULL,40719,36,2,4443,'App\\Models\\Receipt',4443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',703.00,NULL,NULL,1,'2023-04-30 16:06:18','2023-04-30 16:06:18',NULL),(4434,NULL,40719,36,2,4444,'App\\Models\\Receipt',4444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',429.00,NULL,NULL,1,'2023-04-30 16:06:19','2023-04-30 16:06:19',NULL),(4435,NULL,40719,36,2,4445,'App\\Models\\Receipt',4445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',708.00,NULL,NULL,1,'2023-04-30 16:06:19','2023-04-30 16:06:19',NULL),(4436,NULL,40719,36,2,4446,'App\\Models\\Receipt',4446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',538.00,NULL,NULL,1,'2023-04-30 16:06:20','2023-04-30 16:06:20',NULL),(4437,NULL,40719,36,2,4447,'App\\Models\\Receipt',4447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',650.00,NULL,NULL,1,'2023-04-30 16:06:21','2023-04-30 16:06:21',NULL),(4438,NULL,40719,36,2,4448,'App\\Models\\Receipt',4448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',689.00,NULL,NULL,1,'2023-04-30 16:06:22','2023-04-30 16:06:22',NULL),(4439,NULL,40719,36,2,4449,'App\\Models\\Receipt',4449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',850.00,NULL,NULL,1,'2023-04-30 16:06:23','2023-04-30 16:06:23',NULL),(4440,NULL,40719,36,2,4450,'App\\Models\\Receipt',4450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',331.00,NULL,NULL,1,'2023-04-30 16:06:24','2023-04-30 16:06:24',NULL),(4441,NULL,40719,36,2,4451,'App\\Models\\Receipt',4451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',571.00,NULL,NULL,1,'2023-04-30 16:06:24','2023-04-30 16:06:24',NULL),(4442,NULL,40719,36,2,4452,'App\\Models\\Receipt',4452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',673.00,NULL,NULL,1,'2023-04-30 16:06:25','2023-04-30 16:06:25',NULL),(4443,NULL,40719,36,2,4453,'App\\Models\\Receipt',4453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',715.00,NULL,NULL,1,'2023-04-30 16:06:26','2023-04-30 16:06:26',NULL),(4444,NULL,40719,36,2,4454,'App\\Models\\Receipt',4454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',726.00,NULL,NULL,1,'2023-04-30 16:06:27','2023-04-30 16:06:27',NULL),(4445,NULL,40719,36,2,4455,'App\\Models\\Receipt',4455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',389.00,NULL,NULL,1,'2023-04-30 16:06:28','2023-04-30 16:06:28',NULL),(4446,NULL,40719,36,2,4456,'App\\Models\\Receipt',4456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',313.00,NULL,NULL,1,'2023-04-30 16:06:28','2023-04-30 16:06:28',NULL),(4447,NULL,40719,36,2,4457,'App\\Models\\Receipt',4457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',773.00,NULL,NULL,1,'2023-04-30 16:06:29','2023-04-30 16:06:29',NULL),(4448,NULL,40719,36,2,4458,'App\\Models\\Receipt',4458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',891.00,NULL,NULL,1,'2023-04-30 16:06:30','2023-04-30 16:06:30',NULL),(4449,NULL,40719,36,2,4459,'App\\Models\\Receipt',4459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',506.00,NULL,NULL,1,'2023-04-30 16:06:31','2023-04-30 16:06:31',NULL),(4450,NULL,40719,36,2,4460,'App\\Models\\Receipt',4460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',567.00,NULL,NULL,1,'2023-04-30 16:06:32','2023-04-30 16:06:32',NULL);
INSERT INTO `balance_libro` VALUES (4451,NULL,40719,36,2,4461,'App\\Models\\Receipt',4461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',670.00,NULL,NULL,1,'2023-04-30 16:06:33','2023-04-30 16:06:33',NULL),(4452,NULL,40719,36,2,4462,'App\\Models\\Receipt',4462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',543.00,NULL,NULL,1,'2023-04-30 16:06:33','2023-04-30 16:06:33',NULL),(4453,NULL,40719,36,2,4463,'App\\Models\\Receipt',4463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',303.00,NULL,NULL,1,'2023-04-30 16:06:34','2023-04-30 16:06:34',NULL),(4454,NULL,40719,36,2,4464,'App\\Models\\Receipt',4464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',327.00,NULL,NULL,1,'2023-04-30 16:06:35','2023-04-30 16:06:35',NULL),(4455,NULL,40719,36,2,4465,'App\\Models\\Receipt',4465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',402.00,NULL,NULL,1,'2023-04-30 16:06:36','2023-04-30 16:06:36',NULL),(4456,NULL,40719,36,2,4466,'App\\Models\\Receipt',4466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',319.00,NULL,NULL,1,'2023-04-30 16:06:37','2023-04-30 16:06:37',NULL),(4457,NULL,40719,36,2,4467,'App\\Models\\Receipt',4467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',467.00,NULL,NULL,1,'2023-04-30 16:06:38','2023-04-30 16:06:38',NULL),(4458,NULL,40719,36,2,4468,'App\\Models\\Receipt',4468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',880.00,NULL,NULL,1,'2023-04-30 16:06:38','2023-04-30 16:06:38',NULL),(4459,NULL,40719,36,2,4469,'App\\Models\\Receipt',4469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',753.00,NULL,NULL,1,'2023-04-30 16:06:39','2023-04-30 16:06:39',NULL),(4460,NULL,40719,36,2,4470,'App\\Models\\Receipt',4470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',763.00,NULL,NULL,1,'2023-04-30 16:06:40','2023-04-30 16:06:40',NULL),(4461,NULL,40719,36,2,4471,'App\\Models\\Receipt',4471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',714.00,NULL,NULL,1,'2023-04-30 16:06:41','2023-04-30 16:06:41',NULL),(4462,NULL,40719,36,2,4472,'App\\Models\\Receipt',4472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',686.00,NULL,NULL,1,'2023-04-30 16:06:42','2023-04-30 16:06:42',NULL),(4463,NULL,40719,36,2,4473,'App\\Models\\Receipt',4473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',535.00,NULL,NULL,1,'2023-04-30 16:06:43','2023-04-30 16:06:43',NULL),(4464,NULL,40719,36,2,4474,'App\\Models\\Receipt',4474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',414.00,NULL,NULL,1,'2023-04-30 16:06:43','2023-04-30 16:06:43',NULL),(4465,NULL,40719,36,2,4475,'App\\Models\\Receipt',4475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',634.00,NULL,NULL,1,'2023-04-30 16:06:44','2023-04-30 16:06:44',NULL),(4466,NULL,40719,36,2,4476,'App\\Models\\Receipt',4476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',530.00,NULL,NULL,1,'2023-04-30 16:06:45','2023-04-30 16:06:45',NULL),(4467,NULL,40719,36,2,4477,'App\\Models\\Receipt',4477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',506.00,NULL,NULL,1,'2023-04-30 16:06:46','2023-04-30 16:06:46',NULL),(4468,NULL,40719,36,2,4478,'App\\Models\\Receipt',4478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',625.00,NULL,NULL,1,'2023-04-30 16:06:47','2023-04-30 16:06:47',NULL),(4469,NULL,40719,36,2,4479,'App\\Models\\Receipt',4479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',861.00,NULL,NULL,1,'2023-04-30 16:06:47','2023-04-30 16:06:47',NULL),(4470,NULL,40719,36,2,4480,'App\\Models\\Receipt',4480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',638.00,NULL,NULL,1,'2023-04-30 16:06:48','2023-04-30 16:06:48',NULL),(4471,NULL,40719,36,2,4481,'App\\Models\\Receipt',4481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',868.00,NULL,NULL,1,'2023-04-30 16:06:49','2023-04-30 16:06:49',NULL);
INSERT INTO `balance_libro` VALUES (4472,NULL,40719,36,2,4482,'App\\Models\\Receipt',4482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',878.00,NULL,NULL,1,'2023-04-30 16:06:50','2023-04-30 16:06:50',NULL),(4473,NULL,40719,36,2,4483,'App\\Models\\Receipt',4483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',694.00,NULL,NULL,1,'2023-04-30 16:06:51','2023-04-30 16:06:51',NULL),(4474,NULL,40719,36,2,4484,'App\\Models\\Receipt',4484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',715.00,NULL,NULL,1,'2023-04-30 16:06:52','2023-04-30 16:06:52',NULL),(4475,NULL,40719,36,2,4485,'App\\Models\\Receipt',4485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',813.00,NULL,NULL,1,'2023-04-30 16:06:52','2023-04-30 16:06:52',NULL),(4476,NULL,40719,36,2,4486,'App\\Models\\Receipt',4486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',663.00,NULL,NULL,1,'2023-04-30 16:06:53','2023-04-30 16:06:53',NULL),(4477,NULL,40719,36,2,4487,'App\\Models\\Receipt',4487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',826.00,NULL,NULL,1,'2023-04-30 16:06:54','2023-04-30 16:06:54',NULL),(4478,NULL,40719,36,2,4488,'App\\Models\\Receipt',4488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',526.00,NULL,NULL,1,'2023-04-30 16:06:55','2023-04-30 16:06:55',NULL),(4479,NULL,40719,36,2,4489,'App\\Models\\Receipt',4489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',764.00,NULL,NULL,1,'2023-04-30 16:06:56','2023-04-30 16:06:56',NULL),(4480,NULL,40719,36,2,4490,'App\\Models\\Receipt',4490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',578.00,NULL,NULL,1,'2023-04-30 16:06:57','2023-04-30 16:06:57',NULL),(4481,NULL,40719,36,2,4491,'App\\Models\\Receipt',4491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',889.00,NULL,NULL,1,'2023-04-30 16:06:58','2023-04-30 16:06:58',NULL),(4482,NULL,40719,36,2,4492,'App\\Models\\Receipt',4492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',828.00,NULL,NULL,1,'2023-04-30 16:06:58','2023-04-30 16:06:58',NULL),(4483,NULL,40719,36,2,4493,'App\\Models\\Receipt',4493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',320.00,NULL,NULL,1,'2023-04-30 16:06:59','2023-04-30 16:06:59',NULL),(4484,NULL,40719,36,2,4494,'App\\Models\\Receipt',4494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',469.00,NULL,NULL,1,'2023-04-30 16:07:00','2023-04-30 16:07:00',NULL),(4485,NULL,40719,36,2,4495,'App\\Models\\Receipt',4495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',860.00,NULL,NULL,1,'2023-04-30 16:07:01','2023-04-30 16:07:01',NULL),(4486,NULL,40719,36,2,4496,'App\\Models\\Receipt',4496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',664.00,NULL,NULL,1,'2023-04-30 16:07:02','2023-04-30 16:07:02',NULL),(4487,NULL,40719,36,2,4497,'App\\Models\\Receipt',4497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',710.00,NULL,NULL,1,'2023-04-30 16:07:03','2023-04-30 16:07:03',NULL),(4488,NULL,40719,36,2,4498,'App\\Models\\Receipt',4498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',773.00,NULL,NULL,1,'2023-04-30 16:07:03','2023-04-30 16:07:03',NULL),(4489,NULL,40719,36,2,4499,'App\\Models\\Receipt',4499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',826.00,NULL,NULL,1,'2023-04-30 16:07:04','2023-04-30 16:07:04',NULL),(4490,NULL,40719,36,2,4500,'App\\Models\\Receipt',4500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',508.00,NULL,NULL,1,'2023-04-30 16:07:05','2023-04-30 16:07:05',NULL),(4491,NULL,40719,36,2,4501,'App\\Models\\Receipt',4501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',462.00,NULL,NULL,1,'2023-04-30 16:07:06','2023-04-30 16:07:06',NULL),(4492,NULL,40719,36,2,4502,'App\\Models\\Receipt',4502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',811.00,NULL,NULL,1,'2023-04-30 16:07:07','2023-04-30 16:07:07',NULL);
INSERT INTO `balance_libro` VALUES (4493,NULL,40719,36,2,4503,'App\\Models\\Receipt',4503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',508.00,NULL,NULL,1,'2023-04-30 16:07:08','2023-04-30 16:07:08',NULL),(4494,NULL,40719,36,2,4504,'App\\Models\\Receipt',4504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',582.00,NULL,NULL,1,'2023-04-30 16:07:08','2023-04-30 16:07:08',NULL),(4495,NULL,40719,36,2,4505,'App\\Models\\Receipt',4505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',409.00,NULL,NULL,1,'2023-04-30 16:07:09','2023-04-30 16:07:09',NULL),(4496,NULL,40719,36,2,4506,'App\\Models\\Receipt',4506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',858.00,NULL,NULL,1,'2023-04-30 16:07:10','2023-04-30 16:07:10',NULL),(4497,NULL,40719,36,2,4507,'App\\Models\\Receipt',4507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',600.00,NULL,NULL,1,'2023-04-30 16:07:11','2023-04-30 16:07:11',NULL),(4498,NULL,40719,36,2,4508,'App\\Models\\Receipt',4508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',697.00,NULL,NULL,1,'2023-04-30 16:07:12','2023-04-30 16:07:12',NULL),(4499,NULL,40719,36,2,4509,'App\\Models\\Receipt',4509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',445.00,NULL,NULL,1,'2023-04-30 16:07:13','2023-04-30 16:07:13',NULL),(4500,NULL,40719,36,2,4510,'App\\Models\\Receipt',4510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',449.00,NULL,NULL,1,'2023-04-30 16:07:13','2023-04-30 16:07:13',NULL),(4501,NULL,40719,36,2,4511,'App\\Models\\Receipt',4511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',655.00,NULL,NULL,1,'2023-04-30 16:07:14','2023-04-30 16:07:14',NULL),(4502,NULL,40719,36,2,4512,'App\\Models\\Receipt',4512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',874.00,NULL,NULL,1,'2023-04-30 16:07:15','2023-04-30 16:07:15',NULL),(4503,NULL,40719,36,2,4513,'App\\Models\\Receipt',4513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',421.00,NULL,NULL,1,'2023-04-30 16:07:16','2023-04-30 16:07:16',NULL),(4504,NULL,40719,36,2,4514,'App\\Models\\Receipt',4514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',781.00,NULL,NULL,1,'2023-04-30 16:07:17','2023-04-30 16:07:17',NULL),(4505,NULL,40719,36,2,4515,'App\\Models\\Receipt',4515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',520.00,NULL,NULL,1,'2023-04-30 16:07:17','2023-04-30 16:07:17',NULL),(4506,NULL,40719,37,2,4516,'App\\Models\\Receipt',4516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',541.00,NULL,NULL,1,'2023-05-31 20:28:50','2023-05-31 20:28:50',NULL),(4507,NULL,40719,37,2,4517,'App\\Models\\Receipt',4517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',534.00,NULL,NULL,1,'2023-05-31 20:28:51','2023-05-31 20:28:51',NULL),(4508,NULL,40719,37,2,4518,'App\\Models\\Receipt',4518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',452.00,NULL,NULL,1,'2023-05-31 20:28:52','2023-05-31 20:28:52',NULL),(4509,NULL,40719,37,2,4519,'App\\Models\\Receipt',4519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',346.00,NULL,NULL,1,'2023-05-31 20:28:53','2023-05-31 20:28:53',NULL),(4510,NULL,40719,37,2,4520,'App\\Models\\Receipt',4520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',581.00,NULL,NULL,1,'2023-05-31 20:28:54','2023-05-31 20:28:54',NULL),(4511,NULL,40719,37,2,4521,'App\\Models\\Receipt',4521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',828.00,NULL,NULL,1,'2023-05-31 20:28:55','2023-05-31 20:28:55',NULL),(4512,NULL,40719,37,2,4522,'App\\Models\\Receipt',4522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',397.00,NULL,NULL,1,'2023-05-31 20:28:56','2023-05-31 20:28:56',NULL),(4513,NULL,40719,37,2,4523,'App\\Models\\Receipt',4523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',780.00,NULL,NULL,1,'2023-05-31 20:28:56','2023-05-31 20:28:56',NULL);
INSERT INTO `balance_libro` VALUES (4514,NULL,40719,37,2,4524,'App\\Models\\Receipt',4524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',569.00,NULL,NULL,1,'2023-05-31 20:28:57','2023-05-31 20:28:57',NULL),(4515,NULL,40719,37,2,4525,'App\\Models\\Receipt',4525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',566.00,NULL,NULL,1,'2023-05-31 20:28:58','2023-05-31 20:28:58',NULL),(4516,NULL,40719,37,2,4526,'App\\Models\\Receipt',4526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',812.00,NULL,NULL,1,'2023-05-31 20:29:00','2023-05-31 20:29:00',NULL),(4517,NULL,40719,37,2,4527,'App\\Models\\Receipt',4527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',336.00,NULL,NULL,1,'2023-05-31 20:29:01','2023-05-31 20:29:01',NULL),(4518,NULL,40719,37,2,4528,'App\\Models\\Receipt',4528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',406.00,NULL,NULL,1,'2023-05-31 20:29:02','2023-05-31 20:29:02',NULL),(4519,NULL,40719,37,2,4529,'App\\Models\\Receipt',4529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',804.00,NULL,NULL,1,'2023-05-31 20:29:03','2023-05-31 20:29:03',NULL),(4520,NULL,40719,37,2,4530,'App\\Models\\Receipt',4530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',728.00,NULL,NULL,1,'2023-05-31 20:29:04','2023-05-31 20:29:04',NULL),(4521,NULL,40719,37,2,4531,'App\\Models\\Receipt',4531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',580.00,NULL,NULL,1,'2023-05-31 20:29:04','2023-05-31 20:29:04',NULL),(4522,NULL,40719,37,2,4532,'App\\Models\\Receipt',4532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',528.00,NULL,NULL,1,'2023-05-31 20:29:05','2023-05-31 20:29:05',NULL),(4523,NULL,40719,37,2,4533,'App\\Models\\Receipt',4533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',851.00,NULL,NULL,1,'2023-05-31 20:29:06','2023-05-31 20:29:06',NULL),(4524,NULL,40719,37,2,4534,'App\\Models\\Receipt',4534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',753.00,NULL,NULL,1,'2023-05-31 20:29:07','2023-05-31 20:29:07',NULL),(4525,NULL,40719,37,2,4535,'App\\Models\\Receipt',4535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',797.00,NULL,NULL,1,'2023-05-31 20:29:08','2023-05-31 20:29:08',NULL),(4526,NULL,40719,37,2,4536,'App\\Models\\Receipt',4536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',828.00,NULL,NULL,1,'2023-05-31 20:29:09','2023-05-31 20:29:09',NULL),(4527,NULL,40719,37,2,4537,'App\\Models\\Receipt',4537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',508.00,NULL,NULL,1,'2023-05-31 20:29:10','2023-05-31 20:29:10',NULL),(4528,NULL,40719,37,2,4538,'App\\Models\\Receipt',4538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',626.00,NULL,NULL,1,'2023-05-31 20:29:11','2023-05-31 20:29:11',NULL),(4529,NULL,40719,37,2,4539,'App\\Models\\Receipt',4539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',583.00,NULL,NULL,1,'2023-05-31 20:29:11','2023-05-31 20:29:11',NULL),(4530,NULL,40719,37,2,4540,'App\\Models\\Receipt',4540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',659.00,NULL,NULL,1,'2023-05-31 20:29:12','2023-05-31 20:29:12',NULL),(4531,NULL,40719,37,2,4541,'App\\Models\\Receipt',4541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',787.00,NULL,NULL,1,'2023-05-31 20:29:13','2023-05-31 20:29:13',NULL),(4532,NULL,40719,37,2,4542,'App\\Models\\Receipt',4542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',428.00,NULL,NULL,1,'2023-05-31 20:29:14','2023-05-31 20:29:14',NULL),(4533,NULL,40719,37,2,4543,'App\\Models\\Receipt',4543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',366.00,NULL,NULL,1,'2023-05-31 20:29:15','2023-05-31 20:29:15',NULL),(4534,NULL,40719,37,2,4544,'App\\Models\\Receipt',4544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',428.00,NULL,NULL,1,'2023-05-31 20:29:16','2023-05-31 20:29:16',NULL);
INSERT INTO `balance_libro` VALUES (4535,NULL,40719,37,2,4545,'App\\Models\\Receipt',4545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',704.00,NULL,NULL,1,'2023-05-31 20:29:16','2023-05-31 20:29:16',NULL),(4536,NULL,40719,37,2,4546,'App\\Models\\Receipt',4546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',395.00,NULL,NULL,1,'2023-05-31 20:29:17','2023-05-31 20:29:17',NULL),(4537,NULL,40719,37,2,4547,'App\\Models\\Receipt',4547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',703.00,NULL,NULL,1,'2023-05-31 20:29:18','2023-05-31 20:29:18',NULL),(4538,NULL,40719,37,2,4548,'App\\Models\\Receipt',4548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',614.00,NULL,NULL,1,'2023-05-31 20:29:19','2023-05-31 20:29:19',NULL),(4539,NULL,40719,37,2,4549,'App\\Models\\Receipt',4549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',379.00,NULL,NULL,1,'2023-05-31 20:29:20','2023-05-31 20:29:20',NULL),(4540,NULL,40719,37,2,4550,'App\\Models\\Receipt',4550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',492.00,NULL,NULL,1,'2023-05-31 20:29:21','2023-05-31 20:29:21',NULL),(4541,NULL,40719,37,2,4551,'App\\Models\\Receipt',4551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',626.00,NULL,NULL,1,'2023-05-31 20:29:22','2023-05-31 20:29:22',NULL),(4542,NULL,40719,37,2,4552,'App\\Models\\Receipt',4552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',474.00,NULL,NULL,1,'2023-05-31 20:29:24','2023-05-31 20:29:24',NULL),(4543,NULL,40719,37,2,4553,'App\\Models\\Receipt',4553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',530.00,NULL,NULL,1,'2023-05-31 20:29:25','2023-05-31 20:29:25',NULL),(4544,NULL,40719,37,2,4554,'App\\Models\\Receipt',4554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',461.00,NULL,NULL,1,'2023-05-31 20:29:26','2023-05-31 20:29:26',NULL),(4545,NULL,40719,37,2,4555,'App\\Models\\Receipt',4555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',310.00,NULL,NULL,1,'2023-05-31 20:29:27','2023-05-31 20:29:27',NULL),(4546,NULL,40719,37,2,4556,'App\\Models\\Receipt',4556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',540.00,NULL,NULL,1,'2023-05-31 20:29:27','2023-05-31 20:29:27',NULL),(4547,NULL,40719,37,2,4557,'App\\Models\\Receipt',4557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',604.00,NULL,NULL,1,'2023-05-31 20:29:28','2023-05-31 20:29:28',NULL),(4548,NULL,40719,37,2,4558,'App\\Models\\Receipt',4558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',564.00,NULL,NULL,1,'2023-05-31 20:29:29','2023-05-31 20:29:29',NULL),(4549,NULL,40719,37,2,4559,'App\\Models\\Receipt',4559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',335.00,NULL,NULL,1,'2023-05-31 20:29:30','2023-05-31 20:29:30',NULL),(4550,NULL,40719,37,2,4560,'App\\Models\\Receipt',4560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',713.00,NULL,NULL,1,'2023-05-31 20:29:31','2023-05-31 20:29:31',NULL),(4551,NULL,40719,37,2,4561,'App\\Models\\Receipt',4561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',757.00,NULL,NULL,1,'2023-05-31 20:29:32','2023-05-31 20:29:32',NULL),(4552,NULL,40719,37,2,4562,'App\\Models\\Receipt',4562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',845.00,NULL,NULL,1,'2023-05-31 20:29:33','2023-05-31 20:29:33',NULL),(4553,NULL,40719,37,2,4563,'App\\Models\\Receipt',4563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',391.00,NULL,NULL,1,'2023-05-31 20:29:33','2023-05-31 20:29:33',NULL),(4554,NULL,40719,37,2,4564,'App\\Models\\Receipt',4564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',674.00,NULL,NULL,1,'2023-05-31 20:29:34','2023-05-31 20:29:34',NULL),(4555,NULL,40719,37,2,4565,'App\\Models\\Receipt',4565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',519.00,NULL,NULL,1,'2023-05-31 20:29:35','2023-05-31 20:29:35',NULL);
INSERT INTO `balance_libro` VALUES (4556,NULL,40719,37,2,4566,'App\\Models\\Receipt',4566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',373.00,NULL,NULL,1,'2023-05-31 20:29:36','2023-05-31 20:29:36',NULL),(4557,NULL,40719,37,2,4567,'App\\Models\\Receipt',4567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',726.00,NULL,NULL,1,'2023-05-31 20:29:37','2023-05-31 20:29:37',NULL),(4558,NULL,40719,37,2,4568,'App\\Models\\Receipt',4568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',550.00,NULL,NULL,1,'2023-05-31 20:29:38','2023-05-31 20:29:38',NULL),(4559,NULL,40719,37,2,4569,'App\\Models\\Receipt',4569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',387.00,NULL,NULL,1,'2023-05-31 20:29:39','2023-05-31 20:29:39',NULL),(4560,NULL,40719,37,2,4570,'App\\Models\\Receipt',4570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',817.00,NULL,NULL,1,'2023-05-31 20:29:39','2023-05-31 20:29:39',NULL),(4561,NULL,40719,37,2,4571,'App\\Models\\Receipt',4571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',525.00,NULL,NULL,1,'2023-05-31 20:29:40','2023-05-31 20:29:40',NULL),(4562,NULL,40719,37,2,4572,'App\\Models\\Receipt',4572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',765.00,NULL,NULL,1,'2023-05-31 20:29:41','2023-05-31 20:29:41',NULL),(4563,NULL,40719,37,2,4573,'App\\Models\\Receipt',4573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',418.00,NULL,NULL,1,'2023-05-31 20:29:42','2023-05-31 20:29:42',NULL),(4564,NULL,40719,37,2,4574,'App\\Models\\Receipt',4574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',570.00,NULL,NULL,1,'2023-05-31 20:29:43','2023-05-31 20:29:43',NULL),(4565,NULL,40719,37,2,4575,'App\\Models\\Receipt',4575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',690.00,NULL,NULL,1,'2023-05-31 20:29:44','2023-05-31 20:29:44',NULL),(4566,NULL,40719,37,2,4576,'App\\Models\\Receipt',4576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',682.00,NULL,NULL,1,'2023-05-31 20:29:45','2023-05-31 20:29:45',NULL),(4567,NULL,40719,37,2,4577,'App\\Models\\Receipt',4577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',453.00,NULL,NULL,1,'2023-05-31 20:29:46','2023-05-31 20:29:46',NULL),(4568,NULL,40719,37,2,4578,'App\\Models\\Receipt',4578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',303.00,NULL,NULL,1,'2023-05-31 20:29:47','2023-05-31 20:29:47',NULL),(4569,NULL,40719,37,2,4579,'App\\Models\\Receipt',4579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',546.00,NULL,NULL,1,'2023-05-31 20:29:48','2023-05-31 20:29:48',NULL),(4570,NULL,40719,37,2,4580,'App\\Models\\Receipt',4580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',781.00,NULL,NULL,1,'2023-05-31 20:29:48','2023-05-31 20:29:48',NULL),(4571,NULL,40719,37,2,4581,'App\\Models\\Receipt',4581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',633.00,NULL,NULL,1,'2023-05-31 20:29:49','2023-05-31 20:29:49',NULL),(4572,NULL,40719,37,2,4582,'App\\Models\\Receipt',4582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',339.00,NULL,NULL,1,'2023-05-31 20:29:50','2023-05-31 20:29:50',NULL),(4573,NULL,40719,37,2,4583,'App\\Models\\Receipt',4583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',490.00,NULL,NULL,1,'2023-05-31 20:29:51','2023-05-31 20:29:51',NULL),(4574,NULL,40719,37,2,4584,'App\\Models\\Receipt',4584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',419.00,NULL,NULL,1,'2023-05-31 20:29:52','2023-05-31 20:29:52',NULL),(4575,NULL,40719,37,2,4585,'App\\Models\\Receipt',4585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',821.00,NULL,NULL,1,'2023-05-31 20:29:53','2023-05-31 20:29:53',NULL),(4576,NULL,40719,37,2,4586,'App\\Models\\Receipt',4586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',545.00,NULL,NULL,1,'2023-05-31 20:29:54','2023-05-31 20:29:54',NULL);
INSERT INTO `balance_libro` VALUES (4577,NULL,40719,37,2,4587,'App\\Models\\Receipt',4587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',636.00,NULL,NULL,1,'2023-05-31 20:29:55','2023-05-31 20:29:55',NULL),(4578,NULL,40719,37,2,4588,'App\\Models\\Receipt',4588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',892.00,NULL,NULL,1,'2023-05-31 20:29:56','2023-05-31 20:29:56',NULL),(4579,NULL,40719,37,2,4589,'App\\Models\\Receipt',4589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',763.00,NULL,NULL,1,'2023-05-31 20:29:56','2023-05-31 20:29:56',NULL),(4580,NULL,40719,37,2,4590,'App\\Models\\Receipt',4590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',533.00,NULL,NULL,1,'2023-05-31 20:29:57','2023-05-31 20:29:57',NULL),(4581,NULL,40719,37,2,4591,'App\\Models\\Receipt',4591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',343.00,NULL,NULL,1,'2023-05-31 20:29:58','2023-05-31 20:29:58',NULL),(4582,NULL,40719,37,2,4592,'App\\Models\\Receipt',4592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',477.00,NULL,NULL,1,'2023-05-31 20:29:59','2023-05-31 20:29:59',NULL),(4583,NULL,40719,37,2,4593,'App\\Models\\Receipt',4593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',535.00,NULL,NULL,1,'2023-05-31 20:30:00','2023-05-31 20:30:00',NULL),(4584,NULL,40719,37,2,4594,'App\\Models\\Receipt',4594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',493.00,NULL,NULL,1,'2023-05-31 20:30:01','2023-05-31 20:30:01',NULL),(4585,NULL,40719,37,2,4595,'App\\Models\\Receipt',4595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',427.00,NULL,NULL,1,'2023-05-31 20:30:02','2023-05-31 20:30:02',NULL),(4586,NULL,40719,37,2,4596,'App\\Models\\Receipt',4596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',704.00,NULL,NULL,1,'2023-05-31 20:30:03','2023-05-31 20:30:03',NULL),(4587,NULL,40719,37,2,4597,'App\\Models\\Receipt',4597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',668.00,NULL,NULL,1,'2023-05-31 20:30:04','2023-05-31 20:30:04',NULL),(4588,NULL,40719,37,2,4598,'App\\Models\\Receipt',4598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',741.00,NULL,NULL,1,'2023-05-31 20:30:05','2023-05-31 20:30:05',NULL),(4589,NULL,40719,37,2,4599,'App\\Models\\Receipt',4599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',794.00,NULL,NULL,1,'2023-05-31 20:30:05','2023-05-31 20:30:05',NULL),(4590,NULL,40719,37,2,4600,'App\\Models\\Receipt',4600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',770.00,NULL,NULL,1,'2023-05-31 20:30:06','2023-05-31 20:30:06',NULL),(4591,NULL,40719,37,2,4601,'App\\Models\\Receipt',4601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',414.00,NULL,NULL,1,'2023-05-31 20:30:07','2023-05-31 20:30:07',NULL),(4592,NULL,40719,37,2,4602,'App\\Models\\Receipt',4602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',558.00,NULL,NULL,1,'2023-05-31 20:30:08','2023-05-31 20:30:08',NULL),(4593,NULL,40719,37,2,4603,'App\\Models\\Receipt',4603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',770.00,NULL,NULL,1,'2023-05-31 20:30:09','2023-05-31 20:30:09',NULL),(4594,NULL,40719,37,2,4604,'App\\Models\\Receipt',4604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',829.00,NULL,NULL,1,'2023-05-31 20:30:10','2023-05-31 20:30:10',NULL),(4595,NULL,40719,37,2,4605,'App\\Models\\Receipt',4605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',477.00,NULL,NULL,1,'2023-05-31 20:30:11','2023-05-31 20:30:11',NULL),(4596,NULL,40719,37,2,4606,'App\\Models\\Receipt',4606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',494.00,NULL,NULL,1,'2023-05-31 20:30:12','2023-05-31 20:30:12',NULL),(4597,NULL,40719,37,2,4607,'App\\Models\\Receipt',4607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',542.00,NULL,NULL,1,'2023-05-31 20:30:13','2023-05-31 20:30:13',NULL);
INSERT INTO `balance_libro` VALUES (4598,NULL,40719,37,2,4608,'App\\Models\\Receipt',4608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',881.00,NULL,NULL,1,'2023-05-31 20:30:14','2023-05-31 20:30:14',NULL),(4599,NULL,40719,37,2,4609,'App\\Models\\Receipt',4609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',744.00,NULL,NULL,1,'2023-05-31 20:30:15','2023-05-31 20:30:15',NULL),(4600,NULL,40719,37,2,4610,'App\\Models\\Receipt',4610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',872.00,NULL,NULL,1,'2023-05-31 20:30:16','2023-05-31 20:30:16',NULL),(4601,NULL,40719,37,2,4611,'App\\Models\\Receipt',4611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',614.00,NULL,NULL,1,'2023-05-31 20:30:17','2023-05-31 20:30:17',NULL),(4602,NULL,40719,37,2,4612,'App\\Models\\Receipt',4612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',464.00,NULL,NULL,1,'2023-05-31 20:30:18','2023-05-31 20:30:18',NULL),(4603,NULL,40719,37,2,4613,'App\\Models\\Receipt',4613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',660.00,NULL,NULL,1,'2023-05-31 20:30:19','2023-05-31 20:30:19',NULL),(4604,NULL,40719,37,2,4614,'App\\Models\\Receipt',4614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',570.00,NULL,NULL,1,'2023-05-31 20:30:19','2023-05-31 20:30:19',NULL),(4605,NULL,40719,37,2,4615,'App\\Models\\Receipt',4615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',730.00,NULL,NULL,1,'2023-05-31 20:30:20','2023-05-31 20:30:20',NULL),(4606,NULL,40719,37,2,4616,'App\\Models\\Receipt',4616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',847.00,NULL,NULL,1,'2023-05-31 20:30:21','2023-05-31 20:30:21',NULL),(4607,NULL,40719,37,2,4617,'App\\Models\\Receipt',4617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',856.00,NULL,NULL,1,'2023-05-31 20:30:22','2023-05-31 20:30:22',NULL),(4608,NULL,40719,37,2,4618,'App\\Models\\Receipt',4618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',582.00,NULL,NULL,1,'2023-05-31 20:30:23','2023-05-31 20:30:23',NULL),(4609,NULL,40719,37,2,4619,'App\\Models\\Receipt',4619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',795.00,NULL,NULL,1,'2023-05-31 20:30:24','2023-05-31 20:30:24',NULL),(4610,NULL,40719,37,2,4620,'App\\Models\\Receipt',4620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',377.00,NULL,NULL,1,'2023-05-31 20:30:24','2023-05-31 20:30:24',NULL),(4611,NULL,40719,37,2,4621,'App\\Models\\Receipt',4621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',314.00,NULL,NULL,1,'2023-05-31 20:30:25','2023-05-31 20:30:25',NULL),(4612,NULL,40719,37,2,4622,'App\\Models\\Receipt',4622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',454.00,NULL,NULL,1,'2023-05-31 20:30:26','2023-05-31 20:30:26',NULL),(4613,NULL,40719,37,2,4623,'App\\Models\\Receipt',4623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',855.00,NULL,NULL,1,'2023-05-31 20:30:27','2023-05-31 20:30:27',NULL),(4614,NULL,40719,37,2,4624,'App\\Models\\Receipt',4624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',632.00,NULL,NULL,1,'2023-05-31 20:30:28','2023-05-31 20:30:28',NULL),(4615,NULL,40719,37,2,4625,'App\\Models\\Receipt',4625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',365.00,NULL,NULL,1,'2023-05-31 20:30:29','2023-05-31 20:30:29',NULL),(4616,NULL,40719,37,2,4626,'App\\Models\\Receipt',4626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',660.00,NULL,NULL,1,'2023-05-31 20:30:30','2023-05-31 20:30:30',NULL),(4617,NULL,40719,37,2,4627,'App\\Models\\Receipt',4627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',853.00,NULL,NULL,1,'2023-05-31 20:30:31','2023-05-31 20:30:31',NULL),(4618,NULL,40719,37,2,4628,'App\\Models\\Receipt',4628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',451.00,NULL,NULL,1,'2023-05-31 20:30:32','2023-05-31 20:30:32',NULL);
INSERT INTO `balance_libro` VALUES (4619,NULL,40719,37,2,4629,'App\\Models\\Receipt',4629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',414.00,NULL,NULL,1,'2023-05-31 20:30:33','2023-05-31 20:30:33',NULL),(4620,NULL,40719,37,2,4630,'App\\Models\\Receipt',4630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',834.00,NULL,NULL,1,'2023-05-31 20:30:34','2023-05-31 20:30:34',NULL),(4621,NULL,40719,37,2,4631,'App\\Models\\Receipt',4631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',418.00,NULL,NULL,1,'2023-05-31 20:30:35','2023-05-31 20:30:35',NULL),(4622,NULL,40719,37,2,4632,'App\\Models\\Receipt',4632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',422.00,NULL,NULL,1,'2023-05-31 20:30:35','2023-05-31 20:30:35',NULL),(4623,NULL,40719,37,2,4633,'App\\Models\\Receipt',4633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',741.00,NULL,NULL,1,'2023-05-31 20:30:36','2023-05-31 20:30:36',NULL),(4624,NULL,40719,37,2,4634,'App\\Models\\Receipt',4634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',822.00,NULL,NULL,1,'2023-05-31 20:30:37','2023-05-31 20:30:37',NULL),(4625,NULL,40719,37,2,4635,'App\\Models\\Receipt',4635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',375.00,NULL,NULL,1,'2023-05-31 20:30:38','2023-05-31 20:30:38',NULL),(4626,NULL,40719,37,2,4636,'App\\Models\\Receipt',4636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',900.00,NULL,NULL,1,'2023-05-31 20:30:39','2023-05-31 20:30:39',NULL),(4627,NULL,40719,37,2,4637,'App\\Models\\Receipt',4637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',874.00,NULL,NULL,1,'2023-05-31 20:30:40','2023-05-31 20:30:40',NULL),(4628,NULL,40719,37,2,4638,'App\\Models\\Receipt',4638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',893.00,NULL,NULL,1,'2023-05-31 20:30:41','2023-05-31 20:30:41',NULL),(4629,NULL,40719,37,2,4639,'App\\Models\\Receipt',4639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',776.00,NULL,NULL,1,'2023-05-31 20:30:41','2023-05-31 20:30:41',NULL),(4630,NULL,40719,37,2,4640,'App\\Models\\Receipt',4640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',424.00,NULL,NULL,1,'2023-05-31 20:30:42','2023-05-31 20:30:42',NULL),(4631,NULL,40719,37,2,4641,'App\\Models\\Receipt',4641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',676.00,NULL,NULL,1,'2023-05-31 20:30:43','2023-05-31 20:30:43',NULL),(4632,NULL,40719,37,2,4642,'App\\Models\\Receipt',4642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',538.00,NULL,NULL,1,'2023-05-31 20:30:44','2023-05-31 20:30:44',NULL),(4633,NULL,40719,37,2,4643,'App\\Models\\Receipt',4643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',303.00,NULL,NULL,1,'2023-05-31 20:30:45','2023-05-31 20:30:45',NULL),(4634,NULL,40719,37,2,4644,'App\\Models\\Receipt',4644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',806.00,NULL,NULL,1,'2023-05-31 20:30:46','2023-05-31 20:30:46',NULL),(4635,NULL,40719,37,2,4645,'App\\Models\\Receipt',4645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',865.00,NULL,NULL,1,'2023-05-31 20:30:46','2023-05-31 20:30:46',NULL),(4636,NULL,40719,37,2,4646,'App\\Models\\Receipt',4646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',774.00,NULL,NULL,1,'2023-05-31 20:30:48','2023-05-31 20:30:48',NULL),(4637,NULL,40719,37,2,4647,'App\\Models\\Receipt',4647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',588.00,NULL,NULL,1,'2023-05-31 20:30:49','2023-05-31 20:30:49',NULL),(4638,NULL,40719,37,2,4648,'App\\Models\\Receipt',4648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',797.00,NULL,NULL,1,'2023-05-31 20:30:50','2023-05-31 20:30:50',NULL),(4639,NULL,40719,37,2,4649,'App\\Models\\Receipt',4649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',445.00,NULL,NULL,1,'2023-05-31 20:30:51','2023-05-31 20:30:51',NULL);
INSERT INTO `balance_libro` VALUES (4640,NULL,40719,37,2,4650,'App\\Models\\Receipt',4650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',460.00,NULL,NULL,1,'2023-05-31 20:30:52','2023-05-31 20:30:52',NULL),(4641,NULL,40719,37,2,4651,'App\\Models\\Receipt',4651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',379.00,NULL,NULL,1,'2023-05-31 20:30:53','2023-05-31 20:30:53',NULL),(4642,NULL,40719,37,2,4652,'App\\Models\\Receipt',4652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',389.00,NULL,NULL,1,'2023-05-31 20:30:54','2023-05-31 20:30:54',NULL),(4643,NULL,40719,37,2,4653,'App\\Models\\Receipt',4653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',561.00,NULL,NULL,1,'2023-05-31 20:30:55','2023-05-31 20:30:55',NULL),(4644,NULL,40719,37,2,4654,'App\\Models\\Receipt',4654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',476.00,NULL,NULL,1,'2023-05-31 20:30:56','2023-05-31 20:30:56',NULL),(4645,NULL,40719,37,2,4655,'App\\Models\\Receipt',4655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',654.00,NULL,NULL,1,'2023-05-31 20:30:57','2023-05-31 20:30:57',NULL),(4646,NULL,40719,37,2,4656,'App\\Models\\Receipt',4656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',692.00,NULL,NULL,1,'2023-05-31 20:30:58','2023-05-31 20:30:58',NULL),(4647,NULL,40719,37,2,4657,'App\\Models\\Receipt',4657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',606.00,NULL,NULL,1,'2023-05-31 20:30:59','2023-05-31 20:30:59',NULL),(4648,NULL,40719,37,2,4658,'App\\Models\\Receipt',4658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',713.00,NULL,NULL,1,'2023-05-31 20:31:00','2023-05-31 20:31:00',NULL),(4649,NULL,40719,37,2,4659,'App\\Models\\Receipt',4659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',481.00,NULL,NULL,1,'2023-05-31 20:31:01','2023-05-31 20:31:01',NULL),(4650,NULL,40719,37,2,4660,'App\\Models\\Receipt',4660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',358.00,NULL,NULL,1,'2023-05-31 20:31:02','2023-05-31 20:31:02',NULL),(4651,NULL,40719,37,2,4661,'App\\Models\\Receipt',4661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',819.00,NULL,NULL,1,'2023-05-31 20:31:02','2023-05-31 20:31:02',NULL),(4652,NULL,40719,37,2,4662,'App\\Models\\Receipt',4662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',449.00,NULL,NULL,1,'2023-05-31 20:31:03','2023-05-31 20:31:03',NULL),(4653,NULL,40719,37,2,4663,'App\\Models\\Receipt',