-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db23-25302425-9
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-08-08 11:53:04','Actividad Generica 1','000001',NULL),(2,NULL,'2021-08-08 11:53:04','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'Haddad2021',NULL,1,40720,'2021-08-09'),(2,NULL,'Patricia83342',NULL,1,40749,'2021-08-09');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'juanpablohaddad@hotmail.com',NULL,'',2,40749,'2021-08-09');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3863 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,5481,40720,1533,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',67900.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 22:58:45','2021-08-08 22:58:45'),(2,5481,40720,1533,2,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',14276.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 22:58:55','2021-08-08 22:58:55'),(3,5481,40720,1533,2,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',49276.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 22:58:59','2021-08-08 22:58:59'),(4,5481,40720,1533,2,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',14276.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 22:59:02','2021-08-08 22:59:02'),(5,5481,40720,1533,2,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',25064.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 23:00:48','2021-08-08 23:00:48'),(6,5481,40720,1533,2,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',25064.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 23:00:13','2021-08-08 23:00:13'),(7,5481,40720,1533,2,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',25064.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 22:59:36','2021-08-08 22:59:36'),(8,5481,40720,1533,2,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',42100.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 23:00:16','2021-08-08 23:00:16'),(9,5481,40720,1533,2,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2904.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 23:00:19','2021-08-08 23:00:19'),(10,5481,40720,1533,2,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',11000.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 23:00:23','2021-08-08 23:00:23'),(11,5481,40720,1533,2,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',20000.01,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 23:00:26','2021-08-08 23:00:26'),(12,5481,40720,1533,2,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',9873.60,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 22:59:16','2021-08-08 22:59:16'),(13,5481,40720,1533,2,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',11088.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 22:59:19','2021-08-08 22:59:19'),(14,5481,40720,1533,2,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',16637.50,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 22:58:28','2021-08-08 22:58:28'),(15,5481,40720,1533,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4500.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 22:59:22','2021-08-08 22:59:22'),(16,5481,40720,1533,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',13000.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 22:59:25','2021-08-08 22:59:25'),(17,5481,40720,1533,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',9438.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 22:59:27','2021-08-08 22:59:27'),(18,5481,40720,1533,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',40000.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 23:00:29','2021-08-08 23:00:29'),(19,5481,40720,1533,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',20000.01,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 23:00:44','2021-08-08 23:00:44'),(20,5481,40720,1533,2,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',10500.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 23:00:42','2021-08-08 23:00:42'),(21,5481,40720,1533,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',17500.00,NULL,NULL,1,'2021-08-08 22:09:27','2021-08-08 23:00:39','2021-08-08 23:00:39'),(22,5481,40720,1533,2,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',39000.01,NULL,NULL,1,'2021-08-08 22:09:28','2021-08-08 23:00:36','2021-08-08 23:00:36'),(23,5481,40720,1533,3,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',16304.75,NULL,NULL,1,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20');
INSERT INTO `balance_libro` VALUES (24,5481,40720,1533,3,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1475.00,NULL,NULL,1,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(25,5481,40720,1533,3,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',13668.00,NULL,NULL,1,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(26,5481,40720,1533,3,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',8929.96,NULL,NULL,1,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(27,5481,40720,1533,3,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',690.00,NULL,NULL,1,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(28,5481,40720,1533,3,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',170.00,NULL,NULL,1,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(29,5481,40720,1533,3,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',590.00,NULL,NULL,1,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(30,5481,40720,1533,3,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',690.00,NULL,NULL,1,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(31,5481,40720,1533,3,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',735.80,NULL,NULL,1,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(32,5481,40720,1533,3,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',54588.99,NULL,NULL,1,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(33,5481,40720,1533,3,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',85172.57,NULL,NULL,1,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(34,5481,40720,1533,3,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',2190.00,NULL,NULL,1,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(35,5481,40720,1533,3,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',7490.00,NULL,NULL,1,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(36,5481,40720,1533,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',67900.00,NULL,NULL,1,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(37,5481,40720,1533,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',14276.00,NULL,NULL,1,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(38,5481,40720,1533,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',49276.00,NULL,NULL,1,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(39,5481,40720,1533,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',14276.00,NULL,NULL,1,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(40,5481,40720,1533,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',25064.00,NULL,NULL,1,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(41,5481,40720,1533,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',25064.00,NULL,NULL,1,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(42,5481,40720,1533,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',25064.00,NULL,NULL,1,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(43,5481,40720,1533,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',42100.00,NULL,NULL,1,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(44,5481,40720,1533,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2904.00,NULL,NULL,1,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(45,5481,40720,1533,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',11000.00,NULL,NULL,1,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(46,5481,40720,1533,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',20000.01,NULL,NULL,1,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19');
INSERT INTO `balance_libro` VALUES (47,5481,40720,1533,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',9873.60,NULL,NULL,1,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(48,5481,40720,1533,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',11088.00,NULL,NULL,1,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(49,5481,40720,1533,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',16637.50,NULL,NULL,1,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(50,5481,40720,1533,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4500.00,NULL,NULL,1,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(51,5481,40720,1533,2,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',13000.00,NULL,NULL,1,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(52,5481,40720,1533,2,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',9438.00,NULL,NULL,1,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(53,5481,40720,1533,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',40000.00,NULL,NULL,1,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(54,5481,40720,1533,2,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',20000.01,NULL,NULL,1,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(55,5481,40720,1533,2,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',10500.00,NULL,NULL,1,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(56,5481,40720,1533,2,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',17500.00,NULL,NULL,1,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(57,5481,40720,1533,2,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',39000.01,NULL,NULL,1,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(58,5481,40720,1533,15,NULL,56,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-08','2021-08-08',77946.64,NULL,NULL,1,'2021-08-08 23:27:43','2021-08-09 11:02:07','2021-08-09 11:02:07'),(59,5481,40720,1533,2,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',67900.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(60,5481,40720,1533,2,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',14276.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(61,5481,40720,1533,2,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',49276.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(62,5481,40720,1533,2,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',14276.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(63,5481,40720,1533,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',25064.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(64,5481,40720,1533,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',25064.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(65,5481,40720,1533,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',25064.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(66,5481,40720,1533,2,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',42100.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(67,5481,40720,1533,2,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2904.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(68,5481,40720,1533,2,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',11000.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(69,5481,40720,1533,2,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',20000.01,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(70,5481,40720,1533,2,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',9873.60,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL);
INSERT INTO `balance_libro` VALUES (71,5481,40720,1533,2,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',11088.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(72,5481,40720,1533,2,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',16637.50,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(73,5481,40720,1533,2,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4500.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(74,5481,40720,1533,2,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',13000.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(75,5481,40720,1533,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',9438.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(76,5481,40720,1533,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',40000.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(77,5481,40720,1533,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',20000.01,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(78,5481,40720,1533,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',10500.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(79,5481,40720,1533,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',17500.00,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(80,5481,40720,1533,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',39000.01,NULL,NULL,1,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(81,5481,40720,1533,3,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',16304.75,NULL,NULL,1,'2021-08-09 11:04:58','2021-08-09 19:29:08','2021-08-09 19:29:08'),(82,5481,40720,1533,3,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1475.00,NULL,NULL,1,'2021-08-09 11:04:58','2021-08-09 19:29:08','2021-08-09 19:29:08'),(83,5481,40720,1533,3,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',13668.00,NULL,NULL,1,'2021-08-09 11:04:58','2021-08-09 19:29:09','2021-08-09 19:29:09'),(84,5481,40720,1533,3,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',8929.96,NULL,NULL,1,'2021-08-09 11:04:58','2021-08-09 19:29:09','2021-08-09 19:29:09'),(85,5481,40720,1533,3,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',690.00,NULL,NULL,1,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(86,5481,40720,1533,3,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',170.00,NULL,NULL,1,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(87,5481,40720,1533,3,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',590.00,NULL,NULL,1,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(88,5481,40720,1533,3,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',690.00,NULL,NULL,1,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(89,5481,40720,1533,3,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',735.80,NULL,NULL,1,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(90,5481,40720,1533,3,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',54588.99,NULL,NULL,1,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(91,5481,40720,1533,3,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',85172.57,NULL,NULL,1,'2021-08-09 11:04:59','2021-08-09 11:06:49','2021-08-09 11:06:49'),(92,5481,40720,1533,3,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',2190.00,NULL,NULL,1,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(93,5481,40720,1533,3,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',7490.00,NULL,NULL,1,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09');
INSERT INTO `balance_libro` VALUES (94,5481,40720,1533,3,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',82331.78,NULL,NULL,1,'2021-08-09 11:06:49','2021-08-09 19:29:09','2021-08-09 19:29:09'),(95,5481,40749,12138,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1120.00,NULL,NULL,1,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(96,5481,40749,12138,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',2300.00,NULL,NULL,1,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(97,5481,40749,12138,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',2879.37,NULL,NULL,1,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(98,5481,40749,12138,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1200.00,NULL,NULL,1,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(99,5481,40749,12138,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1976.19,NULL,NULL,1,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(100,5481,40749,12138,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',2104.51,NULL,NULL,1,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(101,5481,40749,12138,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2413.00,NULL,NULL,1,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(102,5481,40749,12138,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1554.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(103,5481,40749,12138,2,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',2028.98,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(104,5481,40749,12138,2,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',3157.80,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(105,5481,40749,12138,2,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2049.98,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(106,5481,40749,12138,2,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',577.50,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(107,5481,40749,12138,2,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',4449.25,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(108,5481,40749,12138,2,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',2260.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(109,5481,40749,12138,2,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',3695.01,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(110,5481,40749,12138,2,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1240.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(111,5481,40749,12138,2,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',3173.01,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(112,5481,40749,12138,2,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',798.99,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(113,5481,40749,12138,2,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',707.50,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(114,5481,40749,12138,2,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',3200.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(115,5481,40749,12138,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',749.99,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(116,5481,40749,12138,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',821.70,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(117,5481,40749,12138,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',2982.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(118,5481,40749,12138,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1310.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL);
INSERT INTO `balance_libro` VALUES (119,5481,40749,12138,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',240.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(120,5481,40749,12138,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',5261.01,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(121,5481,40749,12138,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1240.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(122,5481,40749,12138,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',100.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(123,5481,40749,12138,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',292.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(124,5481,40749,12138,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',496.90,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(125,5481,40749,12138,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',450.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(126,5481,40749,12138,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',338.30,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(127,5481,40749,12138,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1040.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(128,5481,40749,12138,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',3645.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(129,5481,40749,12138,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',728.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(130,5481,40749,12138,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',200.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(131,5481,40749,12138,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',420.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(132,5481,40749,12138,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',328.00,NULL,NULL,1,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(133,5481,40749,12138,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',968.90,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(134,5481,40749,12138,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',499.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(135,5481,40749,12138,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',918.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(136,5481,40749,12138,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',924.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(137,5481,40749,12138,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',371.40,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(138,5481,40749,12138,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',556.85,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(139,5481,40749,12138,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',185.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(140,5481,40749,12138,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',640.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(141,5481,40749,12138,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',610.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(142,5481,40749,12138,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',455.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(143,5481,40749,12138,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',459.70,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL);
INSERT INTO `balance_libro` VALUES (144,5481,40749,12138,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1855.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(145,5481,40749,12138,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',150.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(146,5481,40749,12138,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',320.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(147,5481,40749,12138,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1709.90,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(148,5481,40749,12138,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',368.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(149,5481,40749,12138,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',553.40,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(150,5481,40749,12138,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',310.80,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(151,5481,40749,12138,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',444.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(152,5481,40749,12138,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',310.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(153,5481,40749,12138,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1451.30,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(154,5481,40749,12138,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1549.70,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(155,5481,40749,12138,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',890.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(156,5481,40749,12138,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',2357.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(157,5481,40749,12138,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1315.95,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(158,5481,40749,12138,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',50.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(159,5481,40749,12138,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',700.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(160,5481,40749,12138,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',350.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(161,5481,40749,12138,2,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',300.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(162,5481,40749,12138,2,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2640.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(163,5481,40749,12138,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',653.90,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(164,5481,40749,12138,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',300.00,NULL,NULL,1,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(165,5481,40749,12138,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',510.90,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(166,5481,40749,12138,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',376.25,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(167,5481,40749,12138,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2341.50,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(168,5481,40749,12138,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2423.20,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL);
INSERT INTO `balance_libro` VALUES (169,5481,40749,12138,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',800.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(170,5481,40749,12138,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1250.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(171,5481,40749,12138,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',340.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(172,5481,40749,12138,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',315.20,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(173,5481,40749,12138,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',130.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(174,5481,40749,12138,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',600.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(175,5481,40749,12138,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',230.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(176,5481,40749,12138,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',220.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(177,5481,40749,12138,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',727.50,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(178,5481,40749,12138,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',400.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(179,5481,40749,12138,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',820.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(180,5481,40749,12138,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1566.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(181,5481,40749,12138,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',329.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(182,5481,40749,12138,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1700.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(183,5481,40749,12138,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',210.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(184,5481,40749,12138,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',540.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(185,5481,40749,12138,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',505.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(186,5481,40749,12138,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2486.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(187,5481,40749,12138,2,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',388.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(188,5481,40749,12138,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',285.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(189,5481,40749,12138,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',785.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(190,5481,40749,12138,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',1458.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(191,5481,40749,12138,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',1531.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(192,5481,40749,12138,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',260.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(193,5481,40749,12138,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',310.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL);
INSERT INTO `balance_libro` VALUES (194,5481,40749,12138,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',1260.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(195,5481,40749,12138,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',1095.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(196,5481,40749,12138,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',1150.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(197,5481,40749,12138,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',632.60,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(198,5481,40749,12138,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',400.00,NULL,NULL,1,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(199,5481,40749,12138,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',200.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(200,5481,40749,12138,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',738.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(201,5481,40749,12138,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',821.90,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(202,5481,40749,12138,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',195.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(203,5481,40749,12138,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',739.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(204,5481,40749,12138,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',740.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(205,5481,40749,12138,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',510.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(206,5481,40749,12138,2,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1120.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(207,5481,40749,12138,2,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',200.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(208,5481,40749,12138,2,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',892.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(209,5481,40749,12138,2,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',380.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(210,5481,40749,12138,2,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',268.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(211,5481,40749,12138,2,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',622.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(212,5481,40749,12138,2,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1033.10,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(213,5481,40749,12138,2,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',200.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(214,5481,40749,12138,2,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',160.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(215,5481,40749,12138,2,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1872.20,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(216,5481,40749,12138,2,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',371.60,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(217,5481,40749,12138,2,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',620.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(218,5481,40749,12138,2,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',250.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL);
INSERT INTO `balance_libro` VALUES (219,5481,40749,12138,2,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',436.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(220,5481,40749,12138,2,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',170.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(221,5481,40749,12138,2,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',340.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(222,5481,40749,12138,2,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',627.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(223,5481,40749,12138,2,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',150.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(224,5481,40749,12138,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',400.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(225,5481,40749,12138,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',880.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(226,5481,40749,12138,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',255.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(227,5481,40749,12138,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',230.00,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(228,5481,40749,12138,2,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',714.50,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(229,5481,40749,12138,2,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',228.50,NULL,NULL,1,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(230,5481,40749,12138,2,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',740.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(231,5481,40749,12138,2,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1381.60,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(232,5481,40749,12138,2,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1267.50,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(233,5481,40749,12138,2,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',277.40,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(234,5481,40749,12138,2,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',130.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(235,5481,40749,12138,2,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',577.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(236,5481,40749,12138,2,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',130.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(237,5481,40749,12138,2,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',546.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(238,5481,40749,12138,2,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',160.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(239,5481,40749,12138,2,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',270.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(240,5481,40749,12138,2,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',955.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(241,5481,40749,12138,2,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',218.30,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(242,5481,40749,12138,2,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',580.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(243,5481,40749,12138,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',129.45,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL);
INSERT INTO `balance_libro` VALUES (244,5481,40749,12138,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',60.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(245,5481,40749,12138,2,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',960.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(246,5481,40749,12138,2,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1068.85,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(247,5481,40749,12138,2,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',100.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(248,5481,40749,12138,2,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1080.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(249,5481,40749,12138,2,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',295.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(250,5481,40749,12138,2,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',965.75,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(251,5481,40749,12138,2,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',2300.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(252,5481,40749,12138,2,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',375.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(253,5481,40749,12138,2,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',374.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(254,5481,40749,12138,2,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',2053.75,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(255,5481,40749,12138,2,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',400.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(256,5481,40749,12138,2,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',500.00,NULL,NULL,1,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(257,5481,40749,12138,2,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',920.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(258,5481,40749,12138,2,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1146.30,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(259,5481,40749,12138,2,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2634.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(260,5481,40749,12138,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',724.15,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(261,5481,40749,12138,2,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',145.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(262,5481,40749,12138,2,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1912.60,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(263,5481,40749,12138,2,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',500.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(264,5481,40749,12138,2,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2923.65,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(265,5481,40749,12138,2,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',530.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(266,5481,40749,12138,2,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1036.75,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(267,5481,40749,12138,2,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2773.85,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(268,5481,40749,12138,2,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1370.60,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL);
INSERT INTO `balance_libro` VALUES (269,5481,40749,12138,2,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',300.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(270,5481,40749,12138,2,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',225.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(271,5481,40749,12138,2,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',649.50,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(272,5481,40749,12138,2,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',500.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(273,5481,40749,12138,2,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',830.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(274,5481,40749,12138,2,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',830.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(275,5481,40749,12138,2,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',420.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(276,5481,40749,12138,2,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',500.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(277,5481,40749,12138,2,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',710.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(278,5481,40749,12138,2,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',327.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(279,5481,40749,12138,2,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',368.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(280,5481,40749,12138,2,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',95.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(281,5481,40749,12138,2,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1562.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(282,5481,40749,12138,2,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',160.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(283,5481,40749,12138,2,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',889.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(284,5481,40749,12138,2,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',120.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(285,5481,40749,12138,2,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',420.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(286,5481,40749,12138,2,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1394.60,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(287,5481,40749,12138,2,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',885.25,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(288,5481,40749,12138,2,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',410.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(289,5481,40749,12138,2,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',250.00,NULL,NULL,1,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(290,5481,40749,12138,2,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',869.20,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(291,5481,40749,12138,2,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',330.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(292,5481,40749,12138,2,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',965.50,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(293,5481,40749,12138,2,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',400.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL);
INSERT INTO `balance_libro` VALUES (294,5481,40749,12138,2,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1796.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(295,5481,40749,12138,2,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1960.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(296,5481,40749,12138,2,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1780.50,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(297,5481,40749,12138,2,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',518.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(298,5481,40749,12138,2,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1364.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(299,5481,40749,12138,2,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',200.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(300,5481,40749,12138,2,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',150.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(301,5481,40749,12138,2,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',510.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(302,5481,40749,12138,2,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1850.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(303,5481,40749,12138,2,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',893.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(304,5481,40749,12138,2,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1430.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(305,5481,40749,12138,2,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',920.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(306,5481,40749,12138,2,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',892.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(307,5481,40749,12138,2,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',547.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(308,5481,40749,12138,2,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',438.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(309,5481,40749,12138,2,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',700.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(310,5481,40749,12138,2,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',2424.95,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(311,5481,40749,12138,2,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',600.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(312,5481,40749,12138,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',1400.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(313,5481,40749,12138,2,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',296.80,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(314,5481,40749,12138,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',330.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(315,5481,40749,12138,2,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',200.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(316,5481,40749,12138,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',658.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(317,5481,40749,12138,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',660.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(318,5481,40749,12138,2,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',623.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL);
INSERT INTO `balance_libro` VALUES (319,5481,40749,12138,2,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',366.60,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(320,5481,40749,12138,2,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',170.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(321,5481,40749,12138,2,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',1408.60,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(322,5481,40749,12138,2,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',690.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(323,5481,40749,12138,2,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',320.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(324,5481,40749,12138,2,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1303.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(325,5481,40749,12138,2,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1275.00,NULL,NULL,1,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(326,5481,40749,12138,2,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1514.50,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(327,5481,40749,12138,2,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1030.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(328,5481,40749,12138,2,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',80.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(329,5481,40749,12138,2,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1065.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(330,5481,40749,12138,2,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',470.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(331,5481,40749,12138,2,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',533.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(332,5481,40749,12138,2,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1529.60,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(333,5481,40749,12138,2,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1163.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(334,5481,40749,12138,2,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',861.90,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(335,5481,40749,12138,2,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',199.70,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(336,5481,40749,12138,2,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1318.95,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(337,5481,40749,12138,2,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',562.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(338,5481,40749,12138,2,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',290.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(339,5481,40749,12138,2,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1193.20,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(340,5481,40749,12138,2,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',919.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(341,5481,40749,12138,2,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',350.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(342,5481,40749,12138,2,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',220.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(343,5481,40749,12138,2,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',590.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL);
INSERT INTO `balance_libro` VALUES (344,5481,40749,12138,2,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1380.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(345,5481,40749,12138,2,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',620.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(346,5481,40749,12138,2,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',200.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(347,5481,40749,12138,2,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',580.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(348,5481,40749,12138,2,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',260.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(349,5481,40749,12138,2,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',90.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(350,5481,40749,12138,2,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1531.25,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(351,5481,40749,12138,2,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',305.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(352,5481,40749,12138,2,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',155.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(353,5481,40749,12138,2,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',320.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(354,5481,40749,12138,2,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',820.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(355,5481,40749,12138,2,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',718.45,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(356,5481,40749,12138,2,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',3141.10,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(357,5481,40749,12138,2,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',698.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(358,5481,40749,12138,2,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',390.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(359,5481,40749,12138,2,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1355.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(360,5481,40749,12138,2,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',567.00,NULL,NULL,1,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(361,5481,40749,12138,2,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',834.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(362,5481,40749,12138,2,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1028.20,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(363,5481,40749,12138,2,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',5745.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(364,5481,40749,12138,2,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',200.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(365,5481,40749,12138,2,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',322.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(366,5481,40749,12138,2,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',530.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(367,5481,40749,12138,2,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1102.75,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(368,5481,40749,12138,2,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1086.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL);
INSERT INTO `balance_libro` VALUES (369,5481,40749,12138,2,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',440.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(370,5481,40749,12138,2,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',3693.30,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(371,5481,40749,12138,2,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',440.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(372,5481,40749,12138,2,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',369.30,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(373,5481,40749,12138,2,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',200.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(374,5481,40749,12138,2,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',525.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(375,5481,40749,12138,2,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',216.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(376,5481,40749,12138,2,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',930.20,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(377,5481,40749,12138,2,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',510.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(378,5481,40749,12138,2,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1770.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(379,5481,40749,12138,2,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',870.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(380,5481,40749,12138,2,378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',405.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(381,5481,40749,12138,2,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',281.20,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(382,5481,40749,12138,2,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1528.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(383,5481,40749,12138,2,381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',618.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(384,5481,40749,12138,2,382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',470.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(385,5481,40749,12138,2,383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',961.10,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(386,5481,40749,12138,2,384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1229.50,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(387,5481,40749,12138,2,385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1022.70,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(388,5481,40749,12138,2,386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',560.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(389,5481,40749,12138,2,387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1510.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(390,5481,40749,12138,2,388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',693.10,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(391,5481,40749,12138,2,389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',100.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(392,5481,40749,12138,2,390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',787.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(393,5481,40749,12138,2,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',620.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL);
INSERT INTO `balance_libro` VALUES (394,5481,40749,12138,2,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',737.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(395,5481,40749,12138,2,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',3297.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(396,5481,40749,12138,2,394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',415.00,NULL,NULL,1,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(397,5481,40749,12138,2,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',974.45,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(398,5481,40749,12138,2,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1700.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(399,5481,40749,12138,2,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',260.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(400,5481,40749,12138,2,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',529.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(401,5481,40749,12138,2,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',329.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(402,5481,40749,12138,2,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',2230.20,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(403,5481,40749,12138,2,401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',270.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(404,5481,40749,12138,2,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1979.50,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(405,5481,40749,12138,2,403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',485.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(406,5481,40749,12138,2,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',900.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(407,5481,40749,12138,2,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',580.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(408,5481,40749,12138,2,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1214.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(409,5481,40749,12138,2,407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',390.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(410,5481,40749,12138,2,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1029.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(411,5481,40749,12138,2,409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1005.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(412,5481,40749,12138,2,410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',772.05,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(413,5481,40749,12138,2,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',654.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(414,5481,40749,12138,2,412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',620.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(415,5481,40749,12138,2,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',480.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(416,5481,40749,12138,2,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1170.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(417,5481,40749,12138,2,415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1941.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(418,5481,40749,12138,2,416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',340.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL);
INSERT INTO `balance_libro` VALUES (419,5481,40749,12138,2,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',660.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(420,5481,40749,12138,2,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',280.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(421,5481,40749,12138,2,419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',270.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(422,5481,40749,12138,2,420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',580.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(423,5481,40749,12138,2,421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',460.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(424,5481,40749,12138,2,422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',355.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(425,5481,40749,12138,2,423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1385.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(426,5481,40749,12138,2,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',210.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(427,5481,40749,12138,2,425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1032.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(428,5481,40749,12138,2,426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',45.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(429,5481,40749,12138,2,427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',150.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(430,5481,40749,12138,2,428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',550.00,NULL,NULL,1,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(431,5481,40749,12138,2,429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',415.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(432,5481,40749,12138,2,430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1625.65,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(433,5481,40749,12138,2,431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1010.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(434,5481,40749,12138,2,432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',80.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(435,5481,40749,12138,2,433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',468.65,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(436,5481,40749,12138,2,434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',63.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(437,5481,40749,12138,2,435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',6380.50,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(438,5481,40749,12138,2,436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',568.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(439,5481,40749,12138,2,437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',468.30,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(440,5481,40749,12138,2,438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',720.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(441,5481,40749,12138,2,439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',220.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(442,5481,40749,12138,2,440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',111.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(443,5481,40749,12138,2,441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',487.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL);
INSERT INTO `balance_libro` VALUES (444,5481,40749,12138,2,442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',467.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(445,5481,40749,12138,2,443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',483.45,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(446,5481,40749,12138,2,444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1810.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(447,5481,40749,12138,2,445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',733.50,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(448,5481,40749,12138,2,446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',926.75,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(449,5481,40749,12138,2,447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1280.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(450,5481,40749,12138,2,448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',870.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(451,5481,40749,12138,2,449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',3410.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(452,5481,40749,12138,2,450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',935.10,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(453,5481,40749,12138,2,451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',200.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(454,5481,40749,12138,2,452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1330.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(455,5481,40749,12138,2,453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',170.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(456,5481,40749,12138,2,454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1349.70,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(457,5481,40749,12138,2,455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',300.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(458,5481,40749,12138,2,456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1303.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(459,5481,40749,12138,2,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',698.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(460,5481,40749,12138,2,458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',863.80,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(461,5481,40749,12138,2,459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',970.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(462,5481,40749,12138,2,460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1111.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(463,5481,40749,12138,2,461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',212.00,NULL,NULL,1,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(464,5481,40749,12138,2,462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',185.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(465,5481,40749,12138,2,463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',320.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(466,5481,40749,12138,2,464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',700.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(467,5481,40749,12138,2,465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',540.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(468,5481,40749,12138,2,466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1620.80,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL);
INSERT INTO `balance_libro` VALUES (469,5481,40749,12138,2,467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1801.20,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(470,5481,40749,12138,2,468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1263.20,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(471,5481,40749,12138,2,469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',948.60,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(472,5481,40749,12138,2,470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',488.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(473,5481,40749,12138,2,471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',120.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(474,5481,40749,12138,2,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',518.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(475,5481,40749,12138,2,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',680.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(476,5481,40749,12138,2,474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',75.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(477,5481,40749,12138,2,475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',687.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(478,5481,40749,12138,2,476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',195.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(479,5481,40749,12138,2,477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',241.50,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(480,5481,40749,12138,2,478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',930.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(481,5481,40749,12138,2,479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',295.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(482,5481,40749,12138,2,480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',474.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(483,5481,40749,12138,2,481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',185.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(484,5481,40749,12138,2,482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',510.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(485,5481,40749,12138,2,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',367.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(486,5481,40749,12138,2,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1318.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(487,5481,40749,12138,2,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',450.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(488,5481,40749,12138,2,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',841.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(489,5481,40749,12138,2,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',550.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(490,5481,40749,12138,2,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',647.85,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(491,5481,40749,12138,2,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',479.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(492,5481,40749,12138,2,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',350.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(493,5481,40749,12138,2,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',648.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL);
INSERT INTO `balance_libro` VALUES (494,5481,40749,12138,2,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1698.40,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(495,5481,40749,12138,2,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',470.00,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(496,5481,40749,12138,2,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1769.25,NULL,NULL,1,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(497,5481,40749,12138,2,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',3245.75,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(498,5481,40749,12138,2,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',535.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(499,5481,40749,12138,2,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1877.50,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(500,5481,40749,12138,2,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',210.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(501,5481,40749,12138,2,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',280.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(502,5481,40749,12138,2,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',320.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(503,5481,40749,12138,2,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',516.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(504,5481,40749,12138,2,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1982.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(505,5481,40749,12138,2,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1370.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(506,5481,40749,12138,2,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',130.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(507,5481,40749,12138,2,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',855.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(508,5481,40749,12138,2,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',256.50,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(509,5481,40749,12138,2,507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1767.60,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(510,5481,40749,12138,2,508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',780.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(511,5481,40749,12138,2,509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1268.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(512,5481,40749,12138,2,510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',890.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(513,5481,40749,12138,2,511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',800.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(514,5481,40749,12138,2,512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',115.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(515,5481,40749,12138,2,513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1600.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(516,5481,40749,12138,2,514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1725.70,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(517,5481,40749,12138,2,515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',727.50,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(518,5481,40749,12138,2,516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',420.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL);
INSERT INTO `balance_libro` VALUES (519,5481,40749,12138,2,517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',3300.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(520,5481,40749,12138,2,518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1034.65,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(521,5481,40749,12138,2,519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',287.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(522,5481,40749,12138,2,520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',370.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(523,5481,40749,12138,2,521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',470.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(524,5481,40749,12138,2,522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',432.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(525,5481,40749,12138,2,523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',810.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(526,5481,40749,12138,2,524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',2056.10,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(527,5481,40749,12138,2,525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',365.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(528,5481,40749,12138,2,526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',400.00,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(529,5481,40749,12138,2,527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',879.95,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(530,5481,40749,12138,2,528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',581.15,NULL,NULL,1,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(531,5481,40749,12138,2,529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',600.20,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(532,5481,40749,12138,2,530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',921.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(533,5481,40749,12138,2,531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1425.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(534,5481,40749,12138,2,532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',4913.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(535,5481,40749,12138,2,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',525.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(536,5481,40749,12138,2,534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',240.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(537,5481,40749,12138,2,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',535.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(538,5481,40749,12138,2,536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',329.45,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(539,5481,40749,12138,2,537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',989.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(540,5481,40749,12138,2,538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',95.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(541,5481,40749,12138,2,539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',30.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(542,5481,40749,12138,2,540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',2549.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(543,5481,40749,12138,2,541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',255.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL);
INSERT INTO `balance_libro` VALUES (544,5481,40749,12138,2,542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',680.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(545,5481,40749,12138,2,543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',4171.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(546,5481,40749,12138,2,544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',570.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(547,5481,40749,12138,2,545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',930.60,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(548,5481,40749,12138,2,546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',853.55,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(549,5481,40749,12138,2,547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',292.30,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(550,5481,40749,12138,2,548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',602.50,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(551,5481,40749,12138,2,549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',264.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(552,5481,40749,12138,2,550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1175.25,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(553,5481,40749,12138,2,551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',425.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(554,5481,40749,12138,2,552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',621.75,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(555,5481,40749,12138,2,553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',2340.40,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(556,5481,40749,12138,2,554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1040.30,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(557,5481,40749,12138,2,555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',298.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(558,5481,40749,12138,2,556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',538.20,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(559,5481,40749,12138,2,557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1510.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(560,5481,40749,12138,2,558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',736.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(561,5481,40749,12138,2,559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',760.00,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(562,5481,40749,12138,2,560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1427.75,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(563,5481,40749,12138,2,561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',821.70,NULL,NULL,1,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(564,5481,40749,12138,2,562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',310.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(565,5481,40749,12138,2,563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',900.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(566,5481,40749,12138,2,564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',210.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(567,5481,40749,12138,2,565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',503.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(568,5481,40749,12138,2,566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',225.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL);
INSERT INTO `balance_libro` VALUES (569,5481,40749,12138,2,567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',255.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(570,5481,40749,12138,2,568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',270.55,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(571,5481,40749,12138,2,569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',937.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(572,5481,40749,12138,2,570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',400.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(573,5481,40749,12138,2,571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',360.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(574,5481,40749,12138,2,572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',544.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(575,5481,40749,12138,2,573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',483.75,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(576,5481,40749,12138,2,574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3518.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(577,5481,40749,12138,2,575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',330.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(578,5481,40749,12138,2,576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',330.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(579,5481,40749,12138,2,577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',330.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(580,5481,40749,12138,2,578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2472.50,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(581,5481,40749,12138,2,579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',253.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(582,5481,40749,12138,2,580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',760.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(583,5481,40749,12138,2,581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',914.20,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(584,5481,40749,12138,2,582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',729.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(585,5481,40749,12138,2,583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',420.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(586,5481,40749,12138,2,584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',674.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(587,5481,40749,12138,2,585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',580.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(588,5481,40749,12138,2,586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',425.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(589,5481,40749,12138,2,587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',205.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(590,5481,40749,12138,2,588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',138.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(591,5481,40749,12138,2,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',540.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(592,5481,40749,12138,2,590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',2035.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(593,5481,40749,12138,2,591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1402.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL);
INSERT INTO `balance_libro` VALUES (594,5481,40749,12138,2,592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',578.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(595,5481,40749,12138,2,593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1466.80,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(596,5481,40749,12138,2,594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',420.80,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(597,5481,40749,12138,2,595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',800.00,NULL,NULL,1,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(598,5481,40749,12138,2,596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',977.30,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(599,5481,40749,12138,2,597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',470.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(600,5481,40749,12138,2,598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',300.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(601,5481,40749,12138,2,599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',696.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(602,5481,40749,12138,2,600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',440.28,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(603,5481,40749,12138,2,601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',360.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(604,5481,40749,12138,2,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1335.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(605,5481,40749,12138,2,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',370.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(606,5481,40749,12138,2,604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',998.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(607,5481,40749,12138,2,605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1568.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(608,5481,40749,12138,2,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',420.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(609,5481,40749,12138,2,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',931.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(610,5481,40749,12138,2,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',420.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(611,5481,40749,12138,2,609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',4378.75,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(612,5481,40749,12138,2,610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',488.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(613,5481,40749,12138,2,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',90.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(614,5481,40749,12138,2,612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',514.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(615,5481,40749,12138,2,613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',220.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(616,5481,40749,12138,2,614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',783.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(617,5481,40749,12138,2,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',97.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(618,5481,40749,12138,2,616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',672.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL);
INSERT INTO `balance_libro` VALUES (619,5481,40749,12138,2,617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',376.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(620,5481,40749,12138,2,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',959.45,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(621,5481,40749,12138,2,619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',130.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(622,5481,40749,12138,2,620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',878.80,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(623,5481,40749,12138,2,621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1000.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(624,5481,40749,12138,2,622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',290.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(625,5481,40749,12138,2,623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1440.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(626,5481,40749,12138,2,624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2653.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(627,5481,40749,12138,2,625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1100.00,NULL,NULL,1,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(628,5481,40749,12138,2,626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',790.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(629,5481,40749,12138,2,627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',593.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(630,5481,40749,12138,2,628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',540.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(631,5481,40749,12138,2,629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',730.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(632,5481,40749,12138,2,630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1130.50,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(633,5481,40749,12138,2,631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',965.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(634,5481,40749,12138,2,632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1098.90,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(635,5481,40749,12138,2,633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',240.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(636,5481,40749,12138,2,634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',730.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(637,5481,40749,12138,2,635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',530.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(638,5481,40749,12138,2,636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1505.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(639,5481,40749,12138,2,637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',710.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(640,5481,40749,12138,2,638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1067.90,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(641,5481,40749,12138,2,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1060.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(642,5481,40749,12138,2,640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',115.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(643,5481,40749,12138,2,641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',90.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL);
INSERT INTO `balance_libro` VALUES (644,5481,40749,12138,2,642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',345.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(645,5481,40749,12138,2,643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',590.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(646,5481,40749,12138,2,644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',711.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(647,5481,40749,12138,2,645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',430.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(648,5481,40749,12138,2,646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',160.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(649,5481,40749,12138,2,647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1460.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(650,5481,40749,12138,2,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',200.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(651,5481,40749,12138,2,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',430.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(652,5481,40749,12138,2,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',60.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(653,5481,40749,12138,2,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',320.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(654,5481,40749,12138,2,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',205.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(655,5481,40749,12138,2,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1311.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(656,5481,40749,12138,2,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',130.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(657,5481,40749,12138,2,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',324.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(658,5481,40749,12138,2,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',969.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(659,5481,40749,12138,2,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',95.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(660,5481,40749,12138,2,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',368.00,NULL,NULL,1,'2021-08-09 16:22:42','2021-08-09 16:22:42',NULL),(661,5481,40749,12138,2,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',228.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(662,5481,40749,12138,2,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',150.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(663,5481,40749,12138,2,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',60.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(664,5481,40749,12138,2,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',309.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(665,5481,40749,12138,2,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',531.30,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(666,5481,40749,12138,2,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',138.20,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(667,5481,40749,12138,2,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',217.75,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(668,5481,40749,12138,2,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',369.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL);
INSERT INTO `balance_libro` VALUES (669,5481,40749,12138,2,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',669.50,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(670,5481,40749,12138,2,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',375.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(671,5481,40749,12138,2,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',340.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(672,5481,40749,12138,2,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',620.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(673,5481,40749,12138,2,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',278.20,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(674,5481,40749,12138,2,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',460.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(675,5481,40749,12138,2,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',40.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(676,5481,40749,12138,2,674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1177.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(677,5481,40749,12138,2,675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1118.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(678,5481,40749,12138,2,676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',287.40,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(679,5481,40749,12138,2,677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1198.50,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(680,5481,40749,12138,2,678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',340.50,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(681,5481,40749,12138,2,679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',360.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(682,5481,40749,12138,2,680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',953.55,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(683,5481,40749,12138,2,681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',247.45,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(684,5481,40749,12138,2,682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',422.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(685,5481,40749,12138,2,683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',589.60,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(686,5481,40749,12138,2,684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',120.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(687,5481,40749,12138,2,685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',140.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(688,5481,40749,12138,2,686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1040.65,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(689,5481,40749,12138,2,687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',414.40,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(690,5481,40749,12138,2,688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',80.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(691,5481,40749,12138,2,689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',100.00,NULL,NULL,1,'2021-08-09 16:22:43','2021-08-09 16:22:43',NULL),(692,5481,40749,12138,2,690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',260.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(693,5481,40749,12138,2,691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',250.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL);
INSERT INTO `balance_libro` VALUES (694,5481,40749,12138,2,692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1334.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(695,5481,40749,12138,2,693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',520.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(696,5481,40749,12138,2,694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',3285.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(697,5481,40749,12138,2,695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',255.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(698,5481,40749,12138,2,696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',160.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(699,5481,40749,12138,2,697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',480.75,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(700,5481,40749,12138,2,698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',650.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(701,5481,40749,12138,2,699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',485.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(702,5481,40749,12138,2,700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1320.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(703,5481,40749,12138,2,701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',710.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(704,5481,40749,12138,2,702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',200.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(705,5481,40749,12138,2,703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',290.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(706,5481,40749,12138,2,704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',310.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(707,5481,40749,12138,2,705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',311.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(708,5481,40749,12138,2,706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',825.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(709,5481,40749,12138,2,707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',770.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(710,5481,40749,12138,2,708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',160.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(711,5481,40749,12138,2,709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',720.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(712,5481,40749,12138,2,710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',2533.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(713,5481,40749,12138,2,711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',877.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(714,5481,40749,12138,2,712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',338.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(715,5481,40749,12138,2,713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',625.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(716,5481,40749,12138,2,714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1329.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(717,5481,40749,12138,2,715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',281.65,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(718,5481,40749,12138,2,716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',68.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL);
INSERT INTO `balance_libro` VALUES (719,5481,40749,12138,2,717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1700.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(720,5481,40749,12138,2,718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',510.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(721,5481,40749,12138,2,719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1500.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(722,5481,40749,12138,2,720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',470.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(723,5481,40749,12138,2,721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',937.80,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(724,5481,40749,12138,2,722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',311.00,NULL,NULL,1,'2021-08-09 16:22:44','2021-08-09 16:22:44',NULL),(725,5481,40749,12138,2,723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',140.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(726,5481,40749,12138,2,724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',500.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(727,5481,40749,12138,2,725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1000.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(728,5481,40749,12138,2,726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1111.85,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(729,5481,40749,12138,2,727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',85.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(730,5481,40749,12138,2,728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',65.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(731,5481,40749,12138,2,729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',340.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(732,5481,40749,12138,2,730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',310.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(733,5481,40749,12138,2,731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',2135.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(734,5481,40749,12138,2,732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',330.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(735,5481,40749,12138,2,733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',953.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(736,5481,40749,12138,2,734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',300.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(737,5481,40749,12138,2,735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',693.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(738,5481,40749,12138,2,736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',480.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(739,5481,40749,12138,2,737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1130.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(740,5481,40749,12138,2,738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1170.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(741,5481,40749,12138,2,739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',140.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(742,5481,40749,12138,2,740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',570.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(743,5481,40749,12138,2,741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',260.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL);
INSERT INTO `balance_libro` VALUES (744,5481,40749,12138,2,742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',210.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(745,5481,40749,12138,2,743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',380.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(746,5481,40749,12138,2,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',260.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(747,5481,40749,12138,2,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',360.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(748,5481,40749,12138,2,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',55.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(749,5481,40749,12138,2,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',130.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(750,5481,40749,12138,2,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',822.35,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(751,5481,40749,12138,2,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',494.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(752,5481,40749,12138,2,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',685.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(753,5481,40749,12138,2,751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',880.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(754,5481,40749,12138,2,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',205.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(755,5481,40749,12138,2,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1767.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(756,5481,40749,12138,2,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1811.70,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(757,5481,40749,12138,2,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',450.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(758,5481,40749,12138,2,756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',115.00,NULL,NULL,1,'2021-08-09 16:22:45','2021-08-09 16:22:45',NULL),(759,5481,40749,12138,2,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',755.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(760,5481,40749,12138,2,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',466.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(761,5481,40749,12138,2,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',538.40,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(762,5481,40749,12138,2,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',175.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(763,5481,40749,12138,2,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1905.50,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(764,5481,40749,12138,2,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',120.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(765,5481,40749,12138,2,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1227.75,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(766,5481,40749,12138,2,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',600.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(767,5481,40749,12138,2,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',612.50,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(768,5481,40749,12138,2,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',840.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL);
INSERT INTO `balance_libro` VALUES (769,5481,40749,12138,2,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1560.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(770,5481,40749,12138,2,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',180.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(771,5481,40749,12138,2,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',511.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(772,5481,40749,12138,2,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',485.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(773,5481,40749,12138,2,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',129.75,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(774,5481,40749,12138,2,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',250.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(775,5481,40749,12138,2,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',110.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(776,5481,40749,12138,2,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1272.60,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(777,5481,40749,12138,2,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',750.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(778,5481,40749,12138,2,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',510.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(779,5481,40749,12138,2,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',210.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(780,5481,40749,12138,2,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',379.50,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(781,5481,40749,12138,2,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',410.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(782,5481,40749,12138,2,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1499.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(783,5481,40749,12138,2,781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',330.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(784,5481,40749,12138,2,782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',699.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(785,5481,40749,12138,2,783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',897.20,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(786,5481,40749,12138,2,784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',120.00,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(787,5481,40749,12138,2,785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1314.65,NULL,NULL,1,'2021-08-09 16:22:46','2021-08-09 16:22:46',NULL),(788,5481,40749,12138,2,786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',300.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(789,5481,40749,12138,2,787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',628.40,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(790,5481,40749,12138,2,788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',250.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(791,5481,40749,12138,2,789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',429.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(792,5481,40749,12138,2,790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',195.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(793,5481,40749,12138,2,791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',279.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL);
INSERT INTO `balance_libro` VALUES (794,5481,40749,12138,2,792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',409.10,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(795,5481,40749,12138,2,793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',110.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(796,5481,40749,12138,2,794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',593.40,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(797,5481,40749,12138,2,795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',170.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(798,5481,40749,12138,2,796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',140.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(799,5481,40749,12138,2,797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',175.55,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(800,5481,40749,12138,2,798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',340.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(801,5481,40749,12138,2,799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1080.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(802,5481,40749,12138,2,800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',150.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(803,5481,40749,12138,2,801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',400.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(804,5481,40749,12138,2,802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',2908.45,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(805,5481,40749,12138,2,803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',200.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(806,5481,40749,12138,2,804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',695.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(807,5481,40749,12138,2,805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',2504.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(808,5481,40749,12138,2,806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',320.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(809,5481,40749,12138,2,807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',80.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(810,5481,40749,12138,2,808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',370.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(811,5481,40749,12138,2,809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1752.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(812,5481,40749,12138,2,810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',599.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(813,5481,40749,12138,2,811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',460.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(814,5481,40749,12138,2,812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',260.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(815,5481,40749,12138,2,813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',160.00,NULL,NULL,1,'2021-08-09 16:22:47','2021-08-09 16:22:47',NULL),(816,5481,40749,12138,2,814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',595.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(817,5481,40749,12138,2,815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',245.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(818,5481,40749,12138,2,816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',500.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL);
INSERT INTO `balance_libro` VALUES (819,5481,40749,12138,2,817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',390.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(820,5481,40749,12138,2,818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',50.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(821,5481,40749,12138,2,819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1465.50,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(822,5481,40749,12138,2,820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',4660.50,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(823,5481,40749,12138,2,821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',653.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(824,5481,40749,12138,2,822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',570.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(825,5481,40749,12138,2,823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',566.10,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(826,5481,40749,12138,2,824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',386.20,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(827,5481,40749,12138,2,825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',245.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(828,5481,40749,12138,2,826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',325.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(829,5481,40749,12138,2,827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',120.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(830,5481,40749,12138,2,828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',825.50,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(831,5481,40749,12138,2,829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',95.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(832,5481,40749,12138,2,830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',160.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(833,5481,40749,12138,2,831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',250.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(834,5481,40749,12138,2,832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',270.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(835,5481,40749,12138,2,833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',831.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(836,5481,40749,12138,2,834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',385.50,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(837,5481,40749,12138,2,835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',368.00,NULL,NULL,1,'2021-08-09 16:22:48','2021-08-09 16:22:48',NULL),(838,5481,40749,12138,2,836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',150.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(839,5481,40749,12138,2,837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1349.15,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(840,5481,40749,12138,2,838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',175.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(841,5481,40749,12138,2,839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',542.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(842,5481,40749,12138,2,840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',390.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(843,5481,40749,12138,2,841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',575.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL);
INSERT INTO `balance_libro` VALUES (844,5481,40749,12138,2,842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',430.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(845,5481,40749,12138,2,843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',140.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(846,5481,40749,12138,2,844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',60.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(847,5481,40749,12138,2,845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',150.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(848,5481,40749,12138,2,846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',675.70,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(849,5481,40749,12138,2,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',150.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(850,5481,40749,12138,2,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',70.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(851,5481,40749,12138,2,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',495.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(852,5481,40749,12138,2,850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1160.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(853,5481,40749,12138,2,851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',100.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(854,5481,40749,12138,2,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',8859.80,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(855,5481,40749,12138,2,853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',2970.05,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(856,5481,40749,12138,2,854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',940.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(857,5481,40749,12138,2,855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',910.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(858,5481,40749,12138,2,856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',760.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(859,5481,40749,12138,2,857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',2876.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(860,5481,40749,12138,2,858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',240.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(861,5481,40749,12138,2,859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',430.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(862,5481,40749,12138,2,860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1574.75,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(863,5481,40749,12138,2,861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',333.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(864,5481,40749,12138,2,862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1011.00,NULL,NULL,1,'2021-08-09 16:22:49','2021-08-09 16:22:49',NULL),(865,5481,40749,12138,2,863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',835.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(866,5481,40749,12138,2,864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1483.80,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(867,5481,40749,12138,2,865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',2024.85,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(868,5481,40749,12138,2,866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1076.60,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL);
INSERT INTO `balance_libro` VALUES (869,5481,40749,12138,2,867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',100.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(870,5481,40749,12138,2,868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1910.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(871,5481,40749,12138,2,869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',170.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(872,5481,40749,12138,2,870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1432.65,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(873,5481,40749,12138,2,871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1064.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(874,5481,40749,12138,2,872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',670.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(875,5481,40749,12138,2,873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',178.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(876,5481,40749,12138,2,874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',396.50,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(877,5481,40749,12138,2,875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',450.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(878,5481,40749,12138,2,876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',195.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(879,5481,40749,12138,2,877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',195.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(880,5481,40749,12138,2,878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',660.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(881,5481,40749,12138,2,879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',460.25,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(882,5481,40749,12138,2,880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',450.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(883,5481,40749,12138,2,881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',474.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(884,5481,40749,12138,2,882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',700.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(885,5481,40749,12138,2,883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',90.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(886,5481,40749,12138,2,884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',573.40,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(887,5481,40749,12138,2,885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',219.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(888,5481,40749,12138,2,886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',696.65,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(889,5481,40749,12138,2,887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',811.25,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(890,5481,40749,12138,2,888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',580.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(891,5481,40749,12138,2,889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',840.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(892,5481,40749,12138,2,890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',750.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(893,5481,40749,12138,2,891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',585.90,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL);
INSERT INTO `balance_libro` VALUES (894,5481,40749,12138,2,892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',790.00,NULL,NULL,1,'2021-08-09 16:22:50','2021-08-09 16:22:50',NULL),(895,5481,40749,12138,2,893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',620.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(896,5481,40749,12138,2,894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',430.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(897,5481,40749,12138,2,895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1084.80,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(898,5481,40749,12138,2,896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',330.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(899,5481,40749,12138,2,897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1489.50,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(900,5481,40749,12138,2,898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',420.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(901,5481,40749,12138,2,899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',620.70,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(902,5481,40749,12138,2,900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',433.85,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(903,5481,40749,12138,2,901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',960.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(904,5481,40749,12138,2,902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',373.20,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(905,5481,40749,12138,2,903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1004.95,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(906,5481,40749,12138,2,904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',300.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(907,5481,40749,12138,2,905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',720.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(908,5481,40749,12138,2,906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',275.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(909,5481,40749,12138,2,907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',395.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(910,5481,40749,12138,2,908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',45.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(911,5481,40749,12138,2,909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',115.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(912,5481,40749,12138,2,910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',170.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(913,5481,40749,12138,2,911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1070.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(914,5481,40749,12138,2,912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1323.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(915,5481,40749,12138,2,913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',150.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(916,5481,40749,12138,2,914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',186.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(917,5481,40749,12138,2,915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2613.25,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(918,5481,40749,12138,2,916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',185.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL);
INSERT INTO `balance_libro` VALUES (919,5481,40749,12138,2,917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1842.50,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(920,5481,40749,12138,2,918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',564.40,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(921,5481,40749,12138,2,919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',300.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(922,5481,40749,12138,2,920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',147.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(923,5481,40749,12138,2,921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',953.80,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(924,5481,40749,12138,2,922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',355.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(925,5481,40749,12138,2,923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',868.00,NULL,NULL,1,'2021-08-09 16:22:51','2021-08-09 16:22:51',NULL),(926,5481,40749,12138,2,924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',300.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(927,5481,40749,12138,2,925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',293.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(928,5481,40749,12138,2,926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',418.70,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(929,5481,40749,12138,2,927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',570.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(930,5481,40749,12138,2,928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1383.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(931,5481,40749,12138,2,929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2256.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(932,5481,40749,12138,2,930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',195.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(933,5481,40749,12138,2,931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',955.70,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(934,5481,40749,12138,2,932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1660.60,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(935,5481,40749,12138,2,933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',170.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(936,5481,40749,12138,2,934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',250.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(937,5481,40749,12138,2,935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',450.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(938,5481,40749,12138,2,936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',3488.75,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(939,5481,40749,12138,2,937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1494.65,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(940,5481,40749,12138,2,938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',580.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(941,5481,40749,12138,2,939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1973.85,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(942,5481,40749,12138,2,940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',395.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(943,5481,40749,12138,2,941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',906.80,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL);
INSERT INTO `balance_libro` VALUES (944,5481,40749,12138,2,942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',418.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(945,5481,40749,12138,2,943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',504.40,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(946,5481,40749,12138,2,944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',310.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(947,5481,40749,12138,2,945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1400.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(948,5481,40749,12138,2,946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',840.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(949,5481,40749,12138,2,947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',919.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(950,5481,40749,12138,2,948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',203.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(951,5481,40749,12138,2,949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',275.00,NULL,NULL,1,'2021-08-09 16:22:52','2021-08-09 16:22:52',NULL),(952,5481,40749,12138,2,950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2205.90,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(953,5481,40749,12138,2,951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',90.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(954,5481,40749,12138,2,952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',445.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(955,5481,40749,12138,2,953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',260.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(956,5481,40749,12138,2,954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',880.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(957,5481,40749,12138,2,955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',420.15,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(958,5481,40749,12138,2,956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',866.50,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(959,5481,40749,12138,2,957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',305.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(960,5481,40749,12138,2,958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',300.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(961,5481,40749,12138,2,959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',246.50,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(962,5481,40749,12138,2,960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',240.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(963,5481,40749,12138,2,961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',828.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(964,5481,40749,12138,2,962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',110.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(965,5481,40749,12138,2,963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',630.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(966,5481,40749,12138,2,964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',556.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(967,5481,40749,12138,2,965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',691.60,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(968,5481,40749,12138,2,966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',800.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL);
INSERT INTO `balance_libro` VALUES (969,5481,40749,12138,2,967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',510.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(970,5481,40749,12138,2,968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',980.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(971,5481,40749,12138,2,969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',260.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(972,5481,40749,12138,2,970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',90.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(973,5481,40749,12138,2,971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',733.50,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(974,5481,40749,12138,2,972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2594.25,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(975,5481,40749,12138,2,973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2260.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(976,5481,40749,12138,2,974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',130.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(977,5481,40749,12138,2,975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',325.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(978,5481,40749,12138,2,976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',470.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(979,5481,40749,12138,2,977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',180.00,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(980,5481,40749,12138,2,978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',843.60,NULL,NULL,1,'2021-08-09 16:22:53','2021-08-09 16:22:53',NULL),(981,5481,40749,12138,2,979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',448.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(982,5481,40749,12138,2,980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',759.60,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(983,5481,40749,12138,2,981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',510.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(984,5481,40749,12138,2,982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',1208.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(985,5481,40749,12138,2,983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',846.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(986,5481,40749,12138,2,984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',806.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(987,5481,40749,12138,2,985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',3351.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(988,5481,40749,12138,2,986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',680.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(989,5481,40749,12138,2,987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',550.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(990,5481,40749,12138,2,988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',481.80,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(991,5481,40749,12138,2,989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',370.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(992,5481,40749,12138,2,990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',300.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(993,5481,40749,12138,2,991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',3250.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL);
INSERT INTO `balance_libro` VALUES (994,5481,40749,12138,2,992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',700.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(995,5481,40749,12138,2,993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',496.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(996,5481,40749,12138,2,994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',300.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(997,5481,40749,12138,2,995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',1040.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(998,5481,40749,12138,2,996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',200.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(999,5481,40749,12138,2,997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',170.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1000,5481,40749,12138,2,998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',422.75,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1001,5481,40749,12138,2,999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',105.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1002,5481,40749,12138,2,1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',590.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1003,5481,40749,12138,2,1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',500.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1004,5481,40749,12138,2,1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',1160.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1005,5481,40749,12138,2,1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',127.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1006,5481,40749,12138,2,1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',773.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1007,5481,40749,12138,2,1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',1714.70,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1008,5481,40749,12138,2,1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',469.25,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1009,5481,40749,12138,2,1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',320.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1010,5481,40749,12138,2,1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',330.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1011,5481,40749,12138,2,1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',1166.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1012,5481,40749,12138,2,1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',150.00,NULL,NULL,1,'2021-08-09 16:22:54','2021-08-09 16:22:54',NULL),(1013,5481,40749,12138,2,1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',259.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1014,5481,40749,12138,2,1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',360.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1015,5481,40749,12138,2,1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',858.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1016,5481,40749,12138,2,1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',130.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1017,5481,40749,12138,2,1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',160.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL);
INSERT INTO `balance_libro` VALUES (1018,5481,40749,12138,2,1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',255.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1019,5481,40749,12138,2,1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',2005.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1020,5481,40749,12138,2,1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',419.20,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1021,5481,40749,12138,2,1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',360.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1022,5481,40749,12138,2,1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',195.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1023,5481,40749,12138,2,1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',310.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1024,5481,40749,12138,2,1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',1356.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1025,5481,40749,12138,2,1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',1105.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1026,5481,40749,12138,2,1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',185.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1027,5481,40749,12138,2,1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',480.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1028,5481,40749,12138,2,1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',150.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1029,5481,40749,12138,2,1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',610.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1030,5481,40749,12138,2,1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',702.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1031,5481,40749,12138,2,1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',110.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1032,5481,40749,12138,2,1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',5119.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1033,5481,40749,12138,2,1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',280.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1034,5481,40749,12138,2,1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',470.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1035,5481,40749,12138,2,1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',970.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1036,5481,40749,12138,2,1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',927.10,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1037,5481,40749,12138,2,1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',2320.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1038,5481,40749,12138,2,1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',230.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1039,5481,40749,12138,2,1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',830.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1040,5481,40749,12138,2,1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',472.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1041,5481,40749,12138,2,1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',778.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL);
INSERT INTO `balance_libro` VALUES (1042,5481,40749,12138,2,1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',530.00,NULL,NULL,1,'2021-08-09 16:22:55','2021-08-09 16:22:55',NULL),(1043,5481,40749,12138,2,1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',490.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1044,5481,40749,12138,2,1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',520.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1045,5481,40749,12138,2,1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',977.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1046,5481,40749,12138,2,1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',790.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1047,5481,40749,12138,2,1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',270.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1048,5481,40749,12138,2,1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',398.90,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1049,5481,40749,12138,2,1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-04','2021-07-04',460.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1050,5481,40749,12138,2,1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',290.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1051,5481,40749,12138,2,1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',160.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1052,5481,40749,12138,2,1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',470.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1053,5481,40749,12138,2,1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',146.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1054,5481,40749,12138,2,1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',270.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1055,5481,40749,12138,2,1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',165.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1056,5481,40749,12138,2,1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',350.80,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1057,5481,40749,12138,2,1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',442.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1058,5481,40749,12138,2,1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',255.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1059,5481,40749,12138,2,1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',310.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1060,5481,40749,12138,2,1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',910.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1061,5481,40749,12138,2,1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1080.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1062,5481,40749,12138,2,1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',250.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1063,5481,40749,12138,2,1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',65.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1064,5481,40749,12138,2,1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',219.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1065,5481,40749,12138,2,1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',500.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL);
INSERT INTO `balance_libro` VALUES (1066,5481,40749,12138,2,1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',970.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1067,5481,40749,12138,2,1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',190.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1068,5481,40749,12138,2,1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',960.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1069,5481,40749,12138,2,1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',240.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1070,5481,40749,12138,2,1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',535.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1071,5481,40749,12138,2,1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',136.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1072,5481,40749,12138,2,1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',963.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1073,5481,40749,12138,2,1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1970.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1074,5481,40749,12138,2,1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',490.00,NULL,NULL,1,'2021-08-09 16:22:56','2021-08-09 16:22:56',NULL),(1075,5481,40749,12138,2,1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',552.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1076,5481,40749,12138,2,1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1170.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1077,5481,40749,12138,2,1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',345.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1078,5481,40749,12138,2,1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',300.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1079,5481,40749,12138,2,1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',160.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1080,5481,40749,12138,2,1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',806.70,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1081,5481,40749,12138,2,1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',286.90,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1082,5481,40749,12138,2,1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',520.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1083,5481,40749,12138,2,1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',888.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1084,5481,40749,12138,2,1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',279.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1085,5481,40749,12138,2,1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',570.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1086,5481,40749,12138,2,1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',130.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1087,5481,40749,12138,2,1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',80.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1088,5481,40749,12138,2,1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',670.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1089,5481,40749,12138,2,1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',240.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL);
INSERT INTO `balance_libro` VALUES (1090,5481,40749,12138,2,1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',380.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1091,5481,40749,12138,2,1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',736.30,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1092,5481,40749,12138,2,1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',160.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1093,5481,40749,12138,2,1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',714.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1094,5481,40749,12138,2,1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',210.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1095,5481,40749,12138,2,1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',500.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1096,5481,40749,12138,2,1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1140.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1097,5481,40749,12138,2,1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',185.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1098,5481,40749,12138,2,1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',720.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1099,5481,40749,12138,2,1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',300.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1100,5481,40749,12138,2,1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1311.20,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1101,5481,40749,12138,2,1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',315.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1102,5481,40749,12138,2,1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',400.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1103,5481,40749,12138,2,1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',120.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1104,5481,40749,12138,2,1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',200.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1105,5481,40749,12138,2,1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',815.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1106,5481,40749,12138,2,1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1064.00,NULL,NULL,1,'2021-08-09 16:22:57','2021-08-09 16:22:57',NULL),(1107,5481,40749,12138,2,1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',210.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1108,5481,40749,12138,2,1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',620.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1109,5481,40749,12138,2,1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',385.90,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1110,5481,40749,12138,2,1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',145.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1111,5481,40749,12138,2,1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1283.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1112,5481,40749,12138,2,1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',541.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1113,5481,40749,12138,2,1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',490.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL);
INSERT INTO `balance_libro` VALUES (1114,5481,40749,12138,2,1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',160.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1115,5481,40749,12138,2,1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',460.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1116,5481,40749,12138,2,1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',310.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1117,5481,40749,12138,2,1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',208.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1118,5481,40749,12138,2,1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',80.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1119,5481,40749,12138,2,1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1077.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1120,5481,40749,12138,2,1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1050.85,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1121,5481,40749,12138,2,1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',330.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1122,5481,40749,12138,2,1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',410.05,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1123,5481,40749,12138,2,1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',110.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1124,5481,40749,12138,2,1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',460.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1125,5481,40749,12138,2,1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',3744.80,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1126,5481,40749,12138,2,1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',485.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1127,5481,40749,12138,2,1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',600.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1128,5481,40749,12138,2,1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',200.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1129,5481,40749,12138,2,1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',750.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1130,5481,40749,12138,2,1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',429.50,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1131,5481,40749,12138,2,1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',730.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1132,5481,40749,12138,2,1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',640.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1133,5481,40749,12138,2,1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',880.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1134,5481,40749,12138,2,1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',305.00,NULL,NULL,1,'2021-08-09 16:22:58','2021-08-09 16:22:58',NULL),(1135,5481,40749,12138,2,1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',115.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1136,5481,40749,12138,2,1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',245.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1137,5481,40749,12138,2,1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1288.50,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL);
INSERT INTO `balance_libro` VALUES (1138,5481,40749,12138,2,1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',145.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1139,5481,40749,12138,2,1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',185.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1140,5481,40749,12138,2,1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',105.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1141,5481,40749,12138,2,1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',990.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1142,5481,40749,12138,2,1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',495.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1143,5481,40749,12138,2,1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',45.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1144,5481,40749,12138,2,1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',280.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1145,5481,40749,12138,2,1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',468.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1146,5481,40749,12138,2,1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',340.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1147,5481,40749,12138,2,1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',377.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1148,5481,40749,12138,2,1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1309.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1149,5481,40749,12138,2,1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',400.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1150,5481,40749,12138,2,1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',2949.15,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1151,5481,40749,12138,2,1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',4828.10,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1152,5481,40749,12138,2,1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',930.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1153,5481,40749,12138,2,1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',105.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1154,5481,40749,12138,2,1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',390.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1155,5481,40749,12138,2,1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1832.50,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1156,5481,40749,12138,2,1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',215.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1157,5481,40749,12138,2,1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',326.60,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1158,5481,40749,12138,2,1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',499.10,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1159,5481,40749,12138,2,1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',299.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1160,5481,40749,12138,2,1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',60.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1161,5481,40749,12138,2,1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1157.10,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL);
INSERT INTO `balance_libro` VALUES (1162,5481,40749,12138,2,1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',668.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1163,5481,40749,12138,2,1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1717.10,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1164,5481,40749,12138,2,1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',85.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1165,5481,40749,12138,2,1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',309.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1166,5481,40749,12138,2,1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',290.00,NULL,NULL,1,'2021-08-09 16:22:59','2021-08-09 16:22:59',NULL),(1167,5481,40749,12138,2,1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',328.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1168,5481,40749,12138,2,1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',12621.50,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1169,5481,40749,12138,2,1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',145.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1170,5481,40749,12138,2,1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1045.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1171,5481,40749,12138,2,1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',210.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1172,5481,40749,12138,2,1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',50.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1173,5481,40749,12138,2,1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',439.45,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1174,5481,40749,12138,2,1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1228.85,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1175,5481,40749,12138,2,1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',574.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1176,5481,40749,12138,2,1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',327.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1177,5481,40749,12138,2,1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',86.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1178,5481,40749,12138,2,1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',210.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1179,5481,40749,12138,2,1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',540.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1180,5481,40749,12138,2,1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',320.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1181,5481,40749,12138,2,1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',60.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1182,5481,40749,12138,2,1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',260.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1183,5481,40749,12138,2,1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',230.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1184,5481,40749,12138,2,1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',110.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1185,5481,40749,12138,2,1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',210.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL);
INSERT INTO `balance_libro` VALUES (1186,5481,40749,12138,2,1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',360.05,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1187,5481,40749,12138,2,1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',250.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1188,5481,40749,12138,2,1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1310.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1189,5481,40749,12138,2,1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',823.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1190,5481,40749,12138,2,1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',183.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1191,5481,40749,12138,2,1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',350.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1192,5481,40749,12138,2,1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',909.25,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1193,5481,40749,12138,2,1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',788.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1194,5481,40749,12138,2,1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',514.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1195,5481,40749,12138,2,1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',198.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1196,5481,40749,12138,2,1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',130.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1197,5481,40749,12138,2,1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',820.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1198,5481,40749,12138,2,1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2506.20,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1199,5481,40749,12138,2,1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',183.20,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1200,5481,40749,12138,2,1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',145.00,NULL,NULL,1,'2021-08-09 16:23:00','2021-08-09 16:23:00',NULL),(1201,5481,40749,12138,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',743.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1202,5481,40749,12138,2,1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',180.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1203,5481,40749,12138,2,1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',330.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1204,5481,40749,12138,2,1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',445.40,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1205,5481,40749,12138,2,1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',200.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1206,5481,40749,12138,2,1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',200.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1207,5481,40749,12138,2,1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1263.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1208,5481,40749,12138,2,1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',376.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1209,5481,40749,12138,2,1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',705.20,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL);
INSERT INTO `balance_libro` VALUES (1210,5481,40749,12138,2,1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',521.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1211,5481,40749,12138,2,1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',295.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1212,5481,40749,12138,2,1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',380.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1213,5481,40749,12138,2,1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',832.20,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1214,5481,40749,12138,2,1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1150.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1215,5481,40749,12138,2,1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',400.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1216,5481,40749,12138,2,1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',185.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1217,5481,40749,12138,2,1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',210.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1218,5481,40749,12138,2,1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',535.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1219,5481,40749,12138,2,1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',160.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1220,5481,40749,12138,2,1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',410.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1221,5481,40749,12138,2,1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',280.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1222,5481,40749,12138,2,1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2739.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1223,5481,40749,12138,2,1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',952.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1224,5481,40749,12138,2,1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',554.50,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1225,5481,40749,12138,2,1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',187.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1226,5481,40749,12138,2,1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',673.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1227,5481,40749,12138,2,1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',681.40,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1228,5481,40749,12138,2,1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1411.75,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1229,5481,40749,12138,2,1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',320.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1230,5481,40749,12138,2,1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',490.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1231,5481,40749,12138,2,1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1379.70,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1232,5481,40749,12138,2,1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',550.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL),(1233,5481,40749,12138,2,1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',70.00,NULL,NULL,1,'2021-08-09 16:23:01','2021-08-09 16:23:01',NULL);
INSERT INTO `balance_libro` VALUES (1234,5481,40749,12138,2,1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',722.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1235,5481,40749,12138,2,1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',215.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1236,5481,40749,12138,2,1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',170.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1237,5481,40749,12138,2,1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',50.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1238,5481,40749,12138,2,1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',130.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1239,5481,40749,12138,2,1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',530.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1240,5481,40749,12138,2,1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',320.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1241,5481,40749,12138,2,1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',195.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1242,5481,40749,12138,2,1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',160.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1243,5481,40749,12138,2,1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',350.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1244,5481,40749,12138,2,1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',330.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1245,5481,40749,12138,2,1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1932.80,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1246,5481,40749,12138,2,1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',20.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1247,5481,40749,12138,2,1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',200.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1248,5481,40749,12138,2,1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1000.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1249,5481,40749,12138,2,1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',340.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1250,5481,40749,12138,2,1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',170.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1251,5481,40749,12138,2,1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',440.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1252,5481,40749,12138,2,1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',240.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1253,5481,40749,12138,2,1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',295.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1254,5481,40749,12138,2,1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',315.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1255,5481,40749,12138,2,1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',100.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1256,5481,40749,12138,2,1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',130.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1257,5481,40749,12138,2,1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',140.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL);
INSERT INTO `balance_libro` VALUES (1258,5481,40749,12138,2,1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',128.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1259,5481,40749,12138,2,1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',170.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1260,5481,40749,12138,2,1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',2296.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1261,5481,40749,12138,2,1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',150.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1262,5481,40749,12138,2,1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',460.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1263,5481,40749,12138,2,1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',510.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1264,5481,40749,12138,2,1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',277.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1265,5481,40749,12138,2,1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',105.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1266,5481,40749,12138,2,1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',426.30,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1267,5481,40749,12138,2,1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',70.00,NULL,NULL,1,'2021-08-09 16:23:02','2021-08-09 16:23:02',NULL),(1268,5481,40749,12138,2,1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',220.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1269,5481,40749,12138,2,1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',542.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1270,5481,40749,12138,2,1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1565.60,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1271,5481,40749,12138,2,1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',600.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1272,5481,40749,12138,2,1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',510.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1273,5481,40749,12138,2,1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',130.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1274,5481,40749,12138,2,1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1250.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1275,5481,40749,12138,2,1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',640.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1276,5481,40749,12138,2,1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',829.75,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1277,5481,40749,12138,2,1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',840.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1278,5481,40749,12138,2,1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',150.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1279,5481,40749,12138,2,1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',350.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1280,5481,40749,12138,2,1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',460.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1281,5481,40749,12138,2,1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',405.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL);
INSERT INTO `balance_libro` VALUES (1282,5481,40749,12138,2,1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',699.50,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1283,5481,40749,12138,2,1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',470.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1284,5481,40749,12138,2,1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',210.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1285,5481,40749,12138,2,1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',290.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1286,5481,40749,12138,2,1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',907.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1287,5481,40749,12138,2,1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',50.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1288,5481,40749,12138,2,1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1020.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1289,5481,40749,12138,2,1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1900.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1290,5481,40749,12138,2,1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',50.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1291,5481,40749,12138,2,1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',585.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1292,5481,40749,12138,2,1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',130.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1293,5481,40749,12138,2,1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',860.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1294,5481,40749,12138,2,1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',687.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1295,5481,40749,12138,2,1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',18.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1296,5481,40749,12138,2,1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',235.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1297,5481,40749,12138,2,1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1090.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1298,5481,40749,12138,2,1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',100.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1299,5481,40749,12138,2,1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',255.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1300,5481,40749,12138,2,1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',130.00,NULL,NULL,1,'2021-08-09 16:23:03','2021-08-09 16:23:03',NULL),(1301,5481,40749,12138,2,1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',330.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1302,5481,40749,12138,2,1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1440.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1303,5481,40749,12138,2,1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',394.50,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1304,5481,40749,12138,2,1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1140.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1305,5481,40749,12138,2,1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',105.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL);
INSERT INTO `balance_libro` VALUES (1306,5481,40749,12138,2,1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',180.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1307,5481,40749,12138,2,1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',710.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1308,5481,40749,12138,2,1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',774.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1309,5481,40749,12138,2,1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',500.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1310,5481,40749,12138,2,1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',260.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1311,5481,40749,12138,2,1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',297.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1312,5481,40749,12138,2,1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',300.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1313,5481,40749,12138,2,1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',240.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1314,5481,40749,12138,2,1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',427.50,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1315,5481,40749,12138,2,1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',160.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1316,5481,40749,12138,2,1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',335.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1317,5481,40749,12138,2,1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',100.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1318,5481,40749,12138,2,1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',60.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1319,5481,40749,12138,2,1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',130.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1320,5481,40749,12138,2,1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',100.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1321,5481,40749,12138,2,1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',120.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1322,5481,40749,12138,2,1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1273.55,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1323,5481,40749,12138,2,1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',144.45,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1324,5481,40749,12138,2,1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',958.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1325,5481,40749,12138,2,1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1150.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1326,5481,40749,12138,2,1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1580.10,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1327,5481,40749,12138,2,1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',300.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1328,5481,40749,12138,2,1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',371.10,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1329,5481,40749,12138,2,1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',200.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL);
INSERT INTO `balance_libro` VALUES (1330,5481,40749,12138,2,1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',381.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1331,5481,40749,12138,2,1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',100.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1332,5481,40749,12138,2,1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',360.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1333,5481,40749,12138,2,1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',85.00,NULL,NULL,1,'2021-08-09 16:23:04','2021-08-09 16:23:04',NULL),(1334,5481,40749,12138,2,1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',519.50,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1335,5481,40749,12138,2,1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',330.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1336,5481,40749,12138,2,1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',206.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1337,5481,40749,12138,2,1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',405.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1338,5481,40749,12138,2,1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',100.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1339,5481,40749,12138,2,1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1685.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1340,5481,40749,12138,2,1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',200.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1341,5481,40749,12138,2,1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',130.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1342,5481,40749,12138,2,1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',300.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1343,5481,40749,12138,2,1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',79.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1344,5481,40749,12138,2,1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',67.50,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1345,5481,40749,12138,2,1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',60.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1346,5481,40749,12138,2,1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',190.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1347,5481,40749,12138,2,1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1088.65,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1348,5481,40749,12138,2,1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',100.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1349,5481,40749,12138,2,1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',920.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1350,5481,40749,12138,2,1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',130.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1351,5481,40749,12138,2,1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',200.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1352,5481,40749,12138,2,1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',315.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1353,5481,40749,12138,2,1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',363.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL);
INSERT INTO `balance_libro` VALUES (1354,5481,40749,12138,2,1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',115.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1355,5481,40749,12138,2,1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',390.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1356,5481,40749,12138,2,1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1071.20,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1357,5481,40749,12138,2,1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',120.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1358,5481,40749,12138,2,1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',295.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1359,5481,40749,12138,2,1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',415.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1360,5481,40749,12138,2,1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',80.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1361,5481,40749,12138,2,1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',130.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1362,5481,40749,12138,2,1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1904.45,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1363,5481,40749,12138,2,1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',170.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1364,5481,40749,12138,2,1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',310.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1365,5481,40749,12138,2,1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',607.50,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1366,5481,40749,12138,2,1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',215.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1367,5481,40749,12138,2,1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1202.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1368,5481,40749,12138,2,1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2177.00,NULL,NULL,1,'2021-08-09 16:23:05','2021-08-09 16:23:05',NULL),(1369,5481,40749,12138,2,1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',285.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1370,5481,40749,12138,2,1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',339.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1371,5481,40749,12138,2,1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',70.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1372,5481,40749,12138,2,1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',740.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1373,5481,40749,12138,2,1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',538.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1374,5481,40749,12138,2,1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',158.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1375,5481,40749,12138,2,1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',130.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1376,5481,40749,12138,2,1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',415.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1377,5481,40749,12138,2,1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',390.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL);
INSERT INTO `balance_libro` VALUES (1378,5481,40749,12138,2,1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1290.20,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1379,5481,40749,12138,2,1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1198.50,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1380,5481,40749,12138,2,1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',603.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1381,5481,40749,12138,2,1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',120.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1382,5481,40749,12138,2,1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',350.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1383,5481,40749,12138,2,1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',272.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1384,5481,40749,12138,2,1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',636.25,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1385,5481,40749,12138,2,1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',295.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1386,5481,40749,12138,2,1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',316.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1387,5481,40749,12138,2,1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1963.75,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1388,5481,40749,12138,2,1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',615.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1389,5481,40749,12138,2,1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',786.50,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1390,5481,40749,12138,2,1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',190.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1391,5481,40749,12138,2,1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1007.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1392,5481,40749,12138,2,1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',140.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1393,5481,40749,12138,2,1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',889.70,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1394,5481,40749,12138,2,1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',771.35,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1395,5481,40749,12138,2,1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',330.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1396,5481,40749,12138,2,1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',340.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1397,5481,40749,12138,2,1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',746.40,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1398,5481,40749,12138,2,1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',270.00,NULL,NULL,1,'2021-08-09 16:23:06','2021-08-09 16:23:06',NULL),(1399,5481,40749,12138,2,1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',260.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1400,5481,40749,12138,2,1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1546.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1401,5481,40749,12138,2,1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',136.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL);
INSERT INTO `balance_libro` VALUES (1402,5481,40749,12138,2,1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',200.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1403,5481,40749,12138,2,1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',647.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1404,5481,40749,12138,2,1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',508.25,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1405,5481,40749,12138,2,1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',145.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1406,5481,40749,12138,2,1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',175.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1407,5481,40749,12138,2,1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',198.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1408,5481,40749,12138,2,1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',2437.80,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1409,5481,40749,12138,2,1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',390.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1410,5481,40749,12138,2,1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1471.90,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1411,5481,40749,12138,2,1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1249.85,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1412,5481,40749,12138,2,1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',180.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1413,5481,40749,12138,2,1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',535.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1414,5481,40749,12138,2,1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',347.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1415,5481,40749,12138,2,1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',715.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1416,5481,40749,12138,2,1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1387.10,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1417,5481,40749,12138,2,1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',160.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1418,5481,40749,12138,2,1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',195.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1419,5481,40749,12138,2,1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1270.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1420,5481,40749,12138,2,1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',130.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1421,5481,40749,12138,2,1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',670.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1422,5481,40749,12138,2,1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',529.20,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1423,5481,40749,12138,2,1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1124.45,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1424,5481,40749,12138,2,1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1011.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1425,5481,40749,12138,2,1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',520.00,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL);
INSERT INTO `balance_libro` VALUES (1426,5481,40749,12138,2,1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',634.20,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1427,5481,40749,12138,2,1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',587.55,NULL,NULL,1,'2021-08-09 16:23:07','2021-08-09 16:23:07',NULL),(1428,5481,40749,12138,2,1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',362.75,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1429,5481,40749,12138,2,1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',185.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1430,5481,40749,12138,2,1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',372.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1431,5481,40749,12138,2,1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',252.20,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1432,5481,40749,12138,2,1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',800.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1433,5481,40749,12138,2,1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',100.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1434,5481,40749,12138,2,1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',295.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1435,5481,40749,12138,2,1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',320.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1436,5481,40749,12138,2,1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',480.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1437,5481,40749,12138,2,1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',705.50,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1438,5481,40749,12138,2,1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',251.90,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1439,5481,40749,12138,2,1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',420.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1440,5481,40749,12138,2,1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',110.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1441,5481,40749,12138,2,1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',870.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1442,5481,40749,12138,2,1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',718.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1443,5481,40749,12138,2,1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',275.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1444,5481,40749,12138,2,1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',340.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1445,5481,40749,12138,2,1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',2835.20,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1446,5481,40749,12138,2,1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',2543.25,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1447,5481,40749,12138,2,1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',410.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1448,5481,40749,12138,2,1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',231.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1449,5481,40749,12138,2,1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',175.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL);
INSERT INTO `balance_libro` VALUES (1450,5481,40749,12138,2,1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',960.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1451,5481,40749,12138,2,1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',170.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1452,5481,40749,12138,2,1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',495.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1453,5481,40749,12138,2,1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',300.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1454,5481,40749,12138,2,1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',280.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1455,5481,40749,12138,2,1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',100.00,NULL,NULL,1,'2021-08-09 16:23:08','2021-08-09 16:23:08',NULL),(1456,5481,40749,12138,2,1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',180.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1457,5481,40749,12138,2,1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',190.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1458,5481,40749,12138,2,1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',630.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1459,5481,40749,12138,2,1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',300.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1460,5481,40749,12138,2,1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',499.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1461,5481,40749,12138,2,1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',548.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1462,5481,40749,12138,2,1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',450.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1463,5481,40749,12138,2,1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',454.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1464,5481,40749,12138,2,1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',4160.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1465,5481,40749,12138,2,1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',3026.35,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1466,5481,40749,12138,2,1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',989.35,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1467,5481,40749,12138,2,1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1268.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1468,5481,40749,12138,2,1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',4780.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1469,5481,40749,12138,2,1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',275.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1470,5481,40749,12138,2,1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',580.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1471,5481,40749,12138,2,1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',115.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1472,5481,40749,12138,2,1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',725.15,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1473,5481,40749,12138,2,1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',260.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL);
INSERT INTO `balance_libro` VALUES (1474,5481,40749,12138,2,1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1148.60,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1475,5481,40749,12138,2,1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',710.50,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1476,5481,40749,12138,2,1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',360.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1477,5481,40749,12138,2,1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',270.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1478,5481,40749,12138,2,1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',160.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1479,5481,40749,12138,2,1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',98.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1480,5481,40749,12138,2,1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',520.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1481,5481,40749,12138,2,1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',711.75,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1482,5481,40749,12138,2,1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',265.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1483,5481,40749,12138,2,1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',100.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1484,5481,40749,12138,2,1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',721.15,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1485,5481,40749,12138,2,1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',622.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1486,5481,40749,12138,2,1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',165.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1487,5481,40749,12138,2,1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',544.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1488,5481,40749,12138,2,1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',170.00,NULL,NULL,1,'2021-08-09 16:23:09','2021-08-09 16:23:09',NULL),(1489,5481,40749,12138,2,1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',115.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1490,5481,40749,12138,2,1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',3740.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1491,5481,40749,12138,2,1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',425.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1492,5481,40749,12138,2,1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',200.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1493,5481,40749,12138,2,1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',450.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1494,5481,40749,12138,2,1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',351.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1495,5481,40749,12138,2,1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',740.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1496,5481,40749,12138,2,1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',5725.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1497,5481,40749,12138,2,1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',578.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL);
INSERT INTO `balance_libro` VALUES (1498,5481,40749,12138,2,1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',350.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1499,5481,40749,12138,2,1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',75.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1500,5481,40749,12138,2,1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',794.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1501,5481,40749,12138,2,1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',225.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1502,5481,40749,12138,2,1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',325.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1503,5481,40749,12138,2,1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1182.10,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1504,5481,40749,12138,2,1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',2980.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1505,5481,40749,12138,2,1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',110.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1506,5481,40749,12138,2,1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',3568.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1507,5481,40749,12138,2,1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',85.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1508,5481,40749,12138,2,1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',800.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1509,5481,40749,12138,2,1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',820.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1510,5481,40749,12138,2,1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',360.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1511,5481,40749,12138,2,1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',2430.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1512,5481,40749,12138,2,1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',410.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1513,5481,40749,12138,2,1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1938.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1514,5481,40749,12138,2,1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',300.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1515,5481,40749,12138,2,1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',475.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1516,5481,40749,12138,2,1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',185.00,NULL,NULL,1,'2021-08-09 16:23:10','2021-08-09 16:23:10',NULL),(1517,5481,40749,12138,2,1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',1838.75,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1518,5481,40749,12138,2,1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',190.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1519,5481,40749,12138,2,1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',160.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1520,5481,40749,12138,2,1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',920.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1521,5481,40749,12138,2,1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',150.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL);
INSERT INTO `balance_libro` VALUES (1522,5481,40749,12138,2,1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',852.50,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1523,5481,40749,12138,2,1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',685.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1524,5481,40749,12138,2,1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',480.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1525,5481,40749,12138,2,1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',957.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1526,5481,40749,12138,2,1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2096.85,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1527,5481,40749,12138,2,1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',465.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1528,5481,40749,12138,2,1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',880.20,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1529,5481,40749,12138,2,1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',385.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1530,5481,40749,12138,2,1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',640.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1531,5481,40749,12138,2,1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',818.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1532,5481,40749,12138,2,1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',500.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1533,5481,40749,12138,2,1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',320.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1534,5481,40749,12138,2,1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',420.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1535,5481,40749,12138,2,1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1390.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1536,5481,40749,12138,2,1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2000.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1537,5481,40749,12138,2,1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',90.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1538,5481,40749,12138,2,1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',477.70,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1539,5481,40749,12138,2,1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',603.95,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1540,5481,40749,12138,2,1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2527.40,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1541,5481,40749,12138,2,1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',820.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1542,5481,40749,12138,2,1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',70.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1543,5481,40749,12138,2,1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1067.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1544,5481,40749,12138,2,1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',728.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1545,5481,40749,12138,2,1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1118.20,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL);
INSERT INTO `balance_libro` VALUES (1546,5481,40749,12138,2,1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',420.00,NULL,NULL,1,'2021-08-09 16:23:11','2021-08-09 16:23:11',NULL),(1547,5481,40749,12138,2,1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1140.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1548,5481,40749,12138,2,1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',245.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1549,5481,40749,12138,2,1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',4600.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1550,5481,40749,12138,2,1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',3963.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1551,5481,40749,12138,2,1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',961.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1552,5481,40749,12138,2,1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',200.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1553,5481,40749,12138,2,1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',520.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1554,5481,40749,12138,2,1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1075.50,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1555,5481,40749,12138,2,1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',130.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1556,5481,40749,12138,2,1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1040.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1557,5481,40749,12138,2,1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1174.75,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1558,5481,40749,12138,2,1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',230.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1559,5481,40749,12138,2,1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1475.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1560,5481,40749,12138,2,1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',240.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1561,5481,40749,12138,2,1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',300.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1562,5481,40749,12138,2,1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',787.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1563,5481,40749,12138,2,1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',447.75,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1564,5481,40749,12138,2,1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',540.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1565,5481,40749,12138,2,1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',350.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1566,5481,40749,12138,2,1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',498.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1567,5481,40749,12138,2,1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1986.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1568,5481,40749,12138,2,1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',355.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1569,5481,40749,12138,2,1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',400.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL);
INSERT INTO `balance_libro` VALUES (1570,5481,40749,12138,2,1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1375.65,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1571,5481,40749,12138,2,1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',550.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1572,5481,40749,12138,2,1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',653.30,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1573,5481,40749,12138,2,1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',570.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1574,5481,40749,12138,2,1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',170.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1575,5481,40749,12138,2,1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',390.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1576,5481,40749,12138,2,1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',260.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1577,5481,40749,12138,2,1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',170.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1578,5481,40749,12138,2,1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',200.00,NULL,NULL,1,'2021-08-09 16:23:12','2021-08-09 16:23:12',NULL),(1579,5481,40749,12138,2,1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',150.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1580,5481,40749,12138,2,1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',2098.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1581,5481,40749,12138,2,1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',5033.15,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1582,5481,40749,12138,2,1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',260.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1583,5481,40749,12138,2,1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',430.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1584,5481,40749,12138,2,1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',890.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1585,5481,40749,12138,2,1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',310.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1586,5481,40749,12138,2,1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',200.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1587,5481,40749,12138,2,1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',260.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1588,5481,40749,12138,2,1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',500.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1589,5481,40749,12138,2,1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',420.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1590,5481,40749,12138,2,1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',340.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1591,5481,40749,12138,2,1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',850.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1592,5481,40749,12138,2,1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1263.45,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1593,5481,40749,12138,2,1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1065.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL);
INSERT INTO `balance_libro` VALUES (1594,5481,40749,12138,2,1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',387.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1595,5481,40749,12138,2,1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1278.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1596,5481,40749,12138,2,1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1680.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1597,5481,40749,12138,2,1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',255.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1598,5481,40749,12138,2,1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',320.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1599,5481,40749,12138,2,1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',400.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1600,5481,40749,12138,2,1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',290.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1601,5481,40749,12138,2,1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',500.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1602,5481,40749,12138,2,1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',430.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1603,5481,40749,12138,2,1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',110.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1604,5481,40749,12138,2,1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',320.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1605,5481,40749,12138,2,1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',1730.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1606,5481,40749,12138,2,1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',674.40,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1607,5481,40749,12138,2,1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',990.00,NULL,NULL,1,'2021-08-09 16:23:13','2021-08-09 16:23:13',NULL),(1608,5481,40749,12138,2,1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',200.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1609,5481,40749,12138,2,1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',281.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1610,5481,40749,12138,2,1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',560.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1611,5481,40749,12138,2,1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',726.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1612,5481,40749,12138,2,1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',80.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1613,5481,40749,12138,2,1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',120.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1614,5481,40749,12138,2,1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',529.60,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1615,5481,40749,12138,2,1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',296.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1616,5481,40749,12138,2,1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',370.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1617,5481,40749,12138,2,1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',900.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL);
INSERT INTO `balance_libro` VALUES (1618,5481,40749,12138,2,1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',90.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1619,5481,40749,12138,2,1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',85.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1620,5481,40749,12138,2,1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',105.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1621,5481,40749,12138,2,1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',60.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1622,5481,40749,12138,2,1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',2590.05,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1623,5481,40749,12138,2,1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1021.55,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1624,5481,40749,12138,2,1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',130.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1625,5481,40749,12138,2,1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1660.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1626,5481,40749,12138,2,1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1596.30,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1627,5481,40749,12138,2,1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',684.40,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1628,5481,40749,12138,2,1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',818.80,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1629,5481,40749,12138,2,1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',190.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1630,5481,40749,12138,2,1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',40.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1631,5481,40749,12138,2,1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',390.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1632,5481,40749,12138,2,1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1133.05,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1633,5481,40749,12138,2,1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',826.80,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1634,5481,40749,12138,2,1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1464.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1635,5481,40749,12138,2,1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1270.30,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1636,5481,40749,12138,2,1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',250.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1637,5481,40749,12138,2,1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',280.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1638,5481,40749,12138,2,1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',290.00,NULL,NULL,1,'2021-08-09 16:23:14','2021-08-09 16:23:14',NULL),(1639,5481,40749,12138,2,1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1548.75,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1640,5481,40749,12138,2,1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',437.50,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1641,5481,40749,12138,2,1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',80.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL);
INSERT INTO `balance_libro` VALUES (1642,5481,40749,12138,2,1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',160.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1643,5481,40749,12138,2,1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',490.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1644,5481,40749,12138,2,1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',185.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1645,5481,40749,12138,2,1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',339.50,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1646,5481,40749,12138,2,1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',43.50,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1647,5481,40749,12138,2,1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',200.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1648,5481,40749,12138,2,1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1352.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1649,5481,40749,12138,2,1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',130.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1650,5481,40749,12138,2,1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',430.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1651,5481,40749,12138,2,1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',185.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1652,5481,40749,12138,2,1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',844.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1653,5481,40749,12138,2,1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',649.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1654,5481,40749,12138,2,1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',315.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1655,5481,40749,12138,2,1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',290.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1656,5481,40749,12138,2,1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',300.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1657,5481,40749,12138,2,1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',270.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1658,5481,40749,12138,2,1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',948.85,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1659,5481,40749,12138,2,1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',641.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1660,5481,40749,12138,2,1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',330.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1661,5481,40749,12138,2,1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',300.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1662,5481,40749,12138,2,1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',160.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1663,5481,40749,12138,2,1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',2746.45,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1664,5481,40749,12138,2,1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',330.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1665,5481,40749,12138,2,1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',512.75,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL);
INSERT INTO `balance_libro` VALUES (1666,5481,40749,12138,2,1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1244.50,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1667,5481,40749,12138,2,1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',889.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1668,5481,40749,12138,2,1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',602.00,NULL,NULL,1,'2021-08-09 16:23:15','2021-08-09 16:23:15',NULL),(1669,5481,40749,12138,2,1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',750.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1670,5481,40749,12138,2,1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1020.30,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1671,5481,40749,12138,2,1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1310.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1672,5481,40749,12138,2,1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',515.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1673,5481,40749,12138,2,1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',240.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1674,5481,40749,12138,2,1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',2571.25,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1675,5481,40749,12138,2,1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',360.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1676,5481,40749,12138,2,1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',460.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1677,5481,40749,12138,2,1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1000.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1678,5481,40749,12138,2,1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',739.10,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1679,5481,40749,12138,2,1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',815.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1680,5481,40749,12138,2,1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',890.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1681,5481,40749,12138,2,1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',128.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1682,5481,40749,12138,2,1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',974.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1683,5481,40749,12138,2,1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',690.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1684,5481,40749,12138,2,1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',470.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1685,5481,40749,12138,2,1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',348.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1686,5481,40749,12138,2,1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1288.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1687,5481,40749,12138,2,1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',334.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1688,5481,40749,12138,2,1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',862.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1689,5481,40749,12138,2,1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',898.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL);
INSERT INTO `balance_libro` VALUES (1690,5481,40749,12138,2,1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',100.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1691,5481,40749,12138,2,1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',650.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1692,5481,40749,12138,2,1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',93.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1693,5481,40749,12138,2,1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1954.45,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1694,5481,40749,12138,2,1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',368.60,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1695,5481,40749,12138,2,1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',808.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1696,5481,40749,12138,2,1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',330.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1697,5481,40749,12138,2,1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1010.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1698,5481,40749,12138,2,1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',620.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1699,5481,40749,12138,2,1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',200.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1700,5481,40749,12138,2,1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1265.00,NULL,NULL,1,'2021-08-09 16:23:16','2021-08-09 16:23:16',NULL),(1701,5481,40749,12138,2,1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',160.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1702,5481,40749,12138,2,1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',360.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1703,5481,40749,12138,2,1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',995.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1704,5481,40749,12138,2,1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',420.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1705,5481,40749,12138,2,1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1236.50,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1706,5481,40749,12138,2,1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',970.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1707,5481,40749,12138,2,1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1346.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1708,5481,40749,12138,2,1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',689.75,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1709,5481,40749,12138,2,1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',582.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1710,5481,40749,12138,2,1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1978.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1711,5481,40749,12138,2,1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',110.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1712,5481,40749,12138,2,1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',898.30,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1713,5481,40749,12138,2,1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',730.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL);
INSERT INTO `balance_libro` VALUES (1714,5481,40749,12138,2,1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',270.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1715,5481,40749,12138,2,1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',2791.80,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1716,5481,40749,12138,2,1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',440.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1717,5481,40749,12138,2,1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',777.35,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1718,5481,40749,12138,2,1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',440.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1719,5481,40749,12138,2,1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',670.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1720,5481,40749,12138,2,1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1070.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1721,5481,40749,12138,2,1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1194.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1722,5481,40749,12138,2,1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',460.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1723,5481,40749,12138,2,1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1891.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1724,5481,40749,12138,2,1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',1861.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1725,5481,40749,12138,2,1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',492.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1726,5481,40749,12138,2,1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',600.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1727,5481,40749,12138,2,1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',2620.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1728,5481,40749,12138,2,1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',260.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1729,5481,40749,12138,2,1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',4139.75,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1730,5481,40749,12138,2,1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',250.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1731,5481,40749,12138,2,1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',695.00,NULL,NULL,1,'2021-08-09 16:23:17','2021-08-09 16:23:17',NULL),(1732,5481,40749,12138,2,1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',452.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1733,5481,40749,12138,2,1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',460.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1734,5481,40749,12138,2,1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',260.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1735,5481,40749,12138,2,1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',225.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1736,5481,40749,12138,2,1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',285.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1737,5481,40749,12138,2,1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',200.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL);
INSERT INTO `balance_libro` VALUES (1738,5481,40749,12138,2,1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',425.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1739,5481,40749,12138,2,1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',230.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1740,5481,40749,12138,2,1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',967.50,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1741,5481,40749,12138,2,1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',65.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1742,5481,40749,12138,2,1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',1144.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1743,5481,40749,12138,2,1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',1280.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1744,5481,40749,12138,2,1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',130.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1745,5481,40749,12138,2,1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',378.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1746,5481,40749,12138,2,1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',1000.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1747,5481,40749,12138,2,1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',488.90,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1748,5481,40749,12138,2,1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',230.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1749,5481,40749,12138,2,1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',1240.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1750,5481,40749,12138,2,1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',500.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1751,5481,40749,12138,2,1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',250.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1752,5481,40749,12138,2,1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',55.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1753,5481,40749,12138,2,1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',1765.80,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1754,5481,40749,12138,2,1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',200.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1755,5481,40749,12138,2,1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',436.50,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1756,5481,40749,12138,2,1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',95.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1757,5481,40749,12138,2,1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',845.85,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1758,5481,40749,12138,2,1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',821.65,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1759,5481,40749,12138,2,1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',165.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1760,5481,40749,12138,2,1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',780.00,NULL,NULL,1,'2021-08-09 16:23:18','2021-08-09 16:23:18',NULL),(1761,5481,40749,12138,2,1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',660.35,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL);
INSERT INTO `balance_libro` VALUES (1762,5481,40749,12138,2,1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',300.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1763,5481,40749,12138,2,1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',158.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1764,5481,40749,12138,2,1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',4407.85,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1765,5481,40749,12138,2,1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',430.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1766,5481,40749,12138,2,1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',150.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1767,5481,40749,12138,2,1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',630.50,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1768,5481,40749,12138,2,1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',249.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1769,5481,40749,12138,2,1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',260.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1770,5481,40749,12138,2,1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',1714.35,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1771,5481,40749,12138,2,1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',210.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1772,5481,40749,12138,2,1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',379.50,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1773,5481,40749,12138,2,1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',330.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1774,5481,40749,12138,2,1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',220.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1775,5481,40749,12138,2,1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',130.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1776,5481,40749,12138,2,1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',178.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1777,5481,40749,12138,2,1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',180.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1778,5481,40749,12138,2,1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',97.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1779,5481,40749,12138,2,1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',300.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1780,5481,40749,12138,2,1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',828.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1781,5481,40749,12138,2,1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',280.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1782,5481,40749,12138,2,1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',559.70,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1783,5481,40749,12138,2,1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',300.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1784,5481,40749,12138,2,1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',790.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1785,5481,40749,12138,2,1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',285.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL);
INSERT INTO `balance_libro` VALUES (1786,5481,40749,12138,2,1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',320.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1787,5481,40749,12138,2,1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',2309.90,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1788,5481,40749,12138,2,1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',40.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1789,5481,40749,12138,2,1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',170.00,NULL,NULL,1,'2021-08-09 16:23:19','2021-08-09 16:23:19',NULL),(1790,5481,40749,12138,2,1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',307.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1791,5481,40749,12138,2,1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',710.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1792,5481,40749,12138,2,1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',148.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1793,5481,40749,12138,2,1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',150.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1794,5481,40749,12138,2,1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',100.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1795,5481,40749,12138,2,1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',185.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1796,5481,40749,12138,2,1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',100.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1797,5481,40749,12138,2,1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',270.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1798,5481,40749,12138,2,1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',290.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1799,5481,40749,12138,2,1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',80.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1800,5481,40749,12138,2,1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',225.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1801,5481,40749,12138,2,1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',180.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1802,5481,40749,12138,2,1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',500.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1803,5481,40749,12138,2,1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',405.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1804,5481,40749,12138,2,1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1314.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1805,5481,40749,12138,2,1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',379.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1806,5481,40749,12138,2,1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',822.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1807,5481,40749,12138,2,1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1850.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1808,5481,40749,12138,2,1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',934.70,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1809,5481,40749,12138,2,1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',500.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL);
INSERT INTO `balance_libro` VALUES (1810,5481,40749,12138,2,1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',300.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1811,5481,40749,12138,2,1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',180.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1812,5481,40749,12138,2,1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',720.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1813,5481,40749,12138,2,1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',270.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1814,5481,40749,12138,2,1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1040.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1815,5481,40749,12138,2,1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1185.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1816,5481,40749,12138,2,1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1214.70,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1817,5481,40749,12138,2,1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',260.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1818,5481,40749,12138,2,1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',200.00,NULL,NULL,1,'2021-08-09 16:23:20','2021-08-09 16:23:20',NULL),(1819,5481,40749,12138,2,1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',2676.05,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1820,5481,40749,12138,2,1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',230.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1821,5481,40749,12138,2,1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',300.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1822,5481,40749,12138,2,1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',135.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1823,5481,40749,12138,2,1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',3200.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1824,5481,40749,12138,2,1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',640.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1825,5481,40749,12138,2,1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',260.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1826,5481,40749,12138,2,1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',710.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1827,5481,40749,12138,2,1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',130.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1828,5481,40749,12138,2,1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',189.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1829,5481,40749,12138,2,1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',856.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1830,5481,40749,12138,2,1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',390.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1831,5481,40749,12138,2,1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',278.35,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1832,5481,40749,12138,2,1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',150.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1833,5481,40749,12138,2,1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',681.50,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL);
INSERT INTO `balance_libro` VALUES (1834,5481,40749,12138,2,1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',300.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1835,5481,40749,12138,2,1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',240.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1836,5481,40749,12138,2,1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',265.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1837,5481,40749,12138,2,1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',315.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1838,5481,40749,12138,2,1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',3075.50,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1839,5481,40749,12138,2,1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',220.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1840,5481,40749,12138,2,1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',340.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1841,5481,40749,12138,2,1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',400.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1842,5481,40749,12138,2,1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1030.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1843,5481,40749,12138,2,1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',570.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1844,5481,40749,12138,2,1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',260.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1845,5481,40749,12138,2,1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',270.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1846,5481,40749,12138,2,1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',160.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1847,5481,40749,12138,2,1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',80.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1848,5481,40749,12138,2,1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',420.00,NULL,NULL,1,'2021-08-09 16:23:21','2021-08-09 16:23:21',NULL),(1849,5481,40749,12138,2,1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',200.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1850,5481,40749,12138,2,1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',300.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1851,5481,40749,12138,2,1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',891.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1852,5481,40749,12138,2,1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',230.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1853,5481,40749,12138,2,1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',186.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1854,5481,40749,12138,2,1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',620.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1855,5481,40749,12138,2,1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1035.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1856,5481,40749,12138,2,1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',90.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1857,5481,40749,12138,2,1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1353.30,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL);
INSERT INTO `balance_libro` VALUES (1858,5481,40749,12138,2,1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',230.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1859,5481,40749,12138,2,1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1066.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1860,5481,40749,12138,2,1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',980.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1861,5481,40749,12138,2,1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1631.65,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1862,5481,40749,12138,2,1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',435.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1863,5481,40749,12138,2,1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',120.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1864,5481,40749,12138,2,1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1056.60,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1865,5481,40749,12138,2,1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1012.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1866,5481,40749,12138,2,1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',309.70,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1867,5481,40749,12138,2,1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',356.20,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1868,5481,40749,12138,2,1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1118.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1869,5481,40749,12138,2,1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',430.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1870,5481,40749,12138,2,1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',542.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1871,5481,40749,12138,2,1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',249.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1872,5481,40749,12138,2,1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',360.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1873,5481,40749,12138,2,1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',295.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1874,5481,40749,12138,2,1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',165.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1875,5481,40749,12138,2,1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',120.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1876,5481,40749,12138,2,1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',156.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1877,5481,40749,12138,2,1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1160.00,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1878,5481,40749,12138,2,1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',315.80,NULL,NULL,1,'2021-08-09 16:23:22','2021-08-09 16:23:22',NULL),(1879,5481,40749,12138,2,1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',288.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1880,5481,40749,12138,2,1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',2328.45,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1881,5481,40749,12138,2,1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',230.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL);
INSERT INTO `balance_libro` VALUES (1882,5481,40749,12138,2,1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',150.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1883,5481,40749,12138,2,1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',450.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1884,5481,40749,12138,2,1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',5864.50,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1885,5481,40749,12138,2,1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',120.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1886,5481,40749,12138,2,1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',136.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1887,5481,40749,12138,2,1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',125.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1888,5481,40749,12138,2,1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',130.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1889,5481,40749,12138,2,1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',855.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1890,5481,40749,12138,2,1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',2618.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1891,5481,40749,12138,2,1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',195.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1892,5481,40749,12138,2,1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',439.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1893,5481,40749,12138,2,1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1200.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1894,5481,40749,12138,2,1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',50.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1895,5481,40749,12138,2,1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',710.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1896,5481,40749,12138,2,1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',170.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1897,5481,40749,12138,2,1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',110.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1898,5481,40749,12138,2,1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',130.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1899,5481,40749,12138,2,1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',567.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1900,5481,40749,12138,2,1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',160.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1901,5481,40749,12138,2,1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',180.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1902,5481,40749,12138,2,1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',125.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1903,5481,40749,12138,2,1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',549.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1904,5481,40749,12138,2,1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',544.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1905,5481,40749,12138,2,1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',3251.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL);
INSERT INTO `balance_libro` VALUES (1906,5481,40749,12138,2,1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',887.50,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1907,5481,40749,12138,2,1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',280.00,NULL,NULL,1,'2021-08-09 16:23:23','2021-08-09 16:23:23',NULL),(1908,5481,40749,12138,2,1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',157.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1909,5481,40749,12138,2,1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',278.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1910,5481,40749,12138,2,1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',170.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1911,5481,40749,12138,2,1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',640.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1912,5481,40749,12138,2,1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',130.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1913,5481,40749,12138,2,1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',287.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1914,5481,40749,12138,2,1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',300.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1915,5481,40749,12138,2,1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',800.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1916,5481,40749,12138,2,1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1004.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1917,5481,40749,12138,2,1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1090.20,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1918,5481,40749,12138,2,1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',590.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1919,5481,40749,12138,2,1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',60.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1920,5481,40749,12138,2,1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',323.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1921,5481,40749,12138,2,1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1820.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1922,5481,40749,12138,2,1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1130.40,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1923,5481,40749,12138,2,1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',330.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1924,5481,40749,12138,2,1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',310.05,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1925,5481,40749,12138,2,1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',325.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1926,5481,40749,12138,2,1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',490.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1927,5481,40749,12138,2,1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',300.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1928,5481,40749,12138,2,1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',260.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1929,5481,40749,12138,2,1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',160.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL);
INSERT INTO `balance_libro` VALUES (1930,5481,40749,12138,2,1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',370.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1931,5481,40749,12138,2,1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',526.35,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1932,5481,40749,12138,2,1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',954.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1933,5481,40749,12138,2,1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',130.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1934,5481,40749,12138,2,1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',605.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1935,5481,40749,12138,2,1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1728.50,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1936,5481,40749,12138,2,1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',100.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1937,5481,40749,12138,2,1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',413.00,NULL,NULL,1,'2021-08-09 16:23:24','2021-08-09 16:23:24',NULL),(1938,5481,40749,12138,2,1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',412.40,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1939,5481,40749,12138,2,1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',370.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1940,5481,40749,12138,2,1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',764.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1941,5481,40749,12138,2,1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',845.55,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1942,5481,40749,12138,2,1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',212.50,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1943,5481,40749,12138,2,1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',130.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1944,5481,40749,12138,2,1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',450.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1945,5481,40749,12138,2,1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',35.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1946,5481,40749,12138,2,1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',768.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1947,5481,40749,12138,2,1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',453.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1948,5481,40749,12138,2,1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1162.60,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1949,5481,40749,12138,2,1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',635.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1950,5481,40749,12138,2,1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',170.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1951,5481,40749,12138,2,1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',706.45,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1952,5481,40749,12138,2,1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',275.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1953,5481,40749,12138,2,1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1150.80,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL);
INSERT INTO `balance_libro` VALUES (1954,5481,40749,12138,2,1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',403.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1955,5481,40749,12138,2,1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',480.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1956,5481,40749,12138,2,1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',90.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1957,5481,40749,12138,2,1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',532.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1958,5481,40749,12138,2,1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',125.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1959,5481,40749,12138,2,1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',348.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1960,5481,40749,12138,2,1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1389.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1961,5481,40749,12138,2,1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',780.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1962,5481,40749,12138,2,1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',3872.90,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1963,5481,40749,12138,2,1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1405.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1964,5481,40749,12138,2,1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',640.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1965,5481,40749,12138,2,1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',130.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1966,5481,40749,12138,2,1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1499.25,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1967,5481,40749,12138,2,1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',311.00,NULL,NULL,1,'2021-08-09 16:23:25','2021-08-09 16:23:25',NULL),(1968,5481,40749,12138,2,1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',167.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1969,5481,40749,12138,2,1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',200.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1970,5481,40749,12138,2,1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',260.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1971,5481,40749,12138,2,1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',190.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1972,5481,40749,12138,2,1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',700.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1973,5481,40749,12138,2,1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',185.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1974,5481,40749,12138,2,1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1260.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1975,5481,40749,12138,2,1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',220.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1976,5481,40749,12138,2,1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',858.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1977,5481,40749,12138,2,1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',480.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL);
INSERT INTO `balance_libro` VALUES (1978,5481,40749,12138,2,1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',255.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1979,5481,40749,12138,2,1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',140.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1980,5481,40749,12138,2,1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',270.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1981,5481,40749,12138,2,1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1710.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1982,5481,40749,12138,2,1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',620.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1983,5481,40749,12138,2,1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',822.35,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1984,5481,40749,12138,2,1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',120.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1985,5481,40749,12138,2,1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',80.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1986,5481,40749,12138,2,1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',160.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1987,5481,40749,12138,2,1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',150.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1988,5481,40749,12138,2,1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',220.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1989,5481,40749,12138,2,1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1680.50,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1990,5481,40749,12138,2,1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1171.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1991,5481,40749,12138,2,1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',343.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1992,5481,40749,12138,2,1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',887.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1993,5481,40749,12138,2,1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1220.40,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1994,5481,40749,12138,2,1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',260.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1995,5481,40749,12138,2,1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',70.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1996,5481,40749,12138,2,1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',570.00,NULL,NULL,1,'2021-08-09 16:23:26','2021-08-09 16:23:26',NULL),(1997,5481,40749,12138,2,1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',972.75,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(1998,5481,40749,12138,2,1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',670.90,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(1999,5481,40749,12138,2,1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',90.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2000,5481,40749,12138,2,1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',600.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2001,5481,40749,12138,2,1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',548.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL);
INSERT INTO `balance_libro` VALUES (2002,5481,40749,12138,2,2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',731.80,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2003,5481,40749,12138,2,2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',269.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2004,5481,40749,12138,2,2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',520.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2005,5481,40749,12138,2,2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',520.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2006,5481,40749,12138,2,2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',360.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2007,5481,40749,12138,2,2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',753.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2008,5481,40749,12138,2,2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',600.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2009,5481,40749,12138,2,2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',300.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2010,5481,40749,12138,2,2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',250.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2011,5481,40749,12138,2,2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',300.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2012,5481,40749,12138,2,2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',875.70,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2013,5481,40749,12138,2,2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',3756.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2014,5481,40749,12138,2,2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',100.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2015,5481,40749,12138,2,2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',120.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2016,5481,40749,12138,2,2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1151.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2017,5481,40749,12138,2,2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',100.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2018,5481,40749,12138,2,2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',440.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2019,5481,40749,12138,2,2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',140.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2020,5481,40749,12138,2,2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',300.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2021,5481,40749,12138,2,2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',245.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2022,5481,40749,12138,2,2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',426.50,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2023,5481,40749,12138,2,2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1253.70,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2024,5481,40749,12138,2,2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',610.55,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2025,5481,40749,12138,2,2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',50.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL);
INSERT INTO `balance_libro` VALUES (2026,5481,40749,12138,2,2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',295.00,NULL,NULL,1,'2021-08-09 16:23:27','2021-08-09 16:23:27',NULL),(2027,5481,40749,12138,2,2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1884.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2028,5481,40749,12138,2,2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1636.85,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2029,5481,40749,12138,2,2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',243.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2030,5481,40749,12138,2,2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',215.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2031,5481,40749,12138,2,2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',460.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2032,5481,40749,12138,2,2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',65.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2033,5481,40749,12138,2,2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',680.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2034,5481,40749,12138,2,2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',800.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2035,5481,40749,12138,2,2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',150.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2036,5481,40749,12138,2,2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',440.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2037,5481,40749,12138,2,2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',692.40,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2038,5481,40749,12138,2,2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',283.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2039,5481,40749,12138,2,2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',987.50,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2040,5481,40749,12138,2,2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',130.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2041,5481,40749,12138,2,2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',359.50,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2042,5481,40749,12138,2,2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1150.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2043,5481,40749,12138,2,2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',140.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2044,5481,40749,12138,2,2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',259.30,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2045,5481,40749,12138,2,2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',258.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2046,5481,40749,12138,2,2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',613.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2047,5481,40749,12138,2,2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',100.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2048,5481,40749,12138,2,2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',610.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2049,5481,40749,12138,2,2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',909.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL);
INSERT INTO `balance_libro` VALUES (2050,5481,40749,12138,2,2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',674.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2051,5481,40749,12138,2,2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1465.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2052,5481,40749,12138,2,2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1392.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2053,5481,40749,12138,2,2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',490.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2054,5481,40749,12138,2,2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',725.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2055,5481,40749,12138,2,2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',909.50,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2056,5481,40749,12138,2,2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',520.00,NULL,NULL,1,'2021-08-09 16:23:28','2021-08-09 16:23:28',NULL),(2057,5481,40749,12138,2,2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1814.25,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2058,5481,40749,12138,2,2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1623.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2059,5481,40749,12138,2,2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',386.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2060,5481,40749,12138,2,2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',380.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2061,5481,40749,12138,2,2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',190.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2062,5481,40749,12138,2,2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',373.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2063,5481,40749,12138,2,2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',729.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2064,5481,40749,12138,2,2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1197.20,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2065,5481,40749,12138,2,2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1940.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2066,5481,40749,12138,2,2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',592.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2067,5481,40749,12138,2,2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1079.75,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2068,5481,40749,12138,2,2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',652.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2069,5481,40749,12138,2,2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',40.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2070,5481,40749,12138,2,2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1798.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2071,5481,40749,12138,2,2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',460.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2072,5481,40749,12138,2,2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',267.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2073,5481,40749,12138,2,2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',160.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL);
INSERT INTO `balance_libro` VALUES (2074,5481,40749,12138,2,2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',990.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2075,5481,40749,12138,2,2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',405.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2076,5481,40749,12138,2,2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1556.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2077,5481,40749,12138,2,2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',174.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2078,5481,40749,12138,2,2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',782.60,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2079,5481,40749,12138,2,2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',420.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2080,5481,40749,12138,2,2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',125.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2081,5481,40749,12138,2,2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',203.10,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2082,5481,40749,12138,2,2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',105.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2083,5481,40749,12138,2,2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',405.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2084,5481,40749,12138,2,2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',678.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2085,5481,40749,12138,2,2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1095.00,NULL,NULL,1,'2021-08-09 16:23:29','2021-08-09 16:23:29',NULL),(2086,5481,40749,12138,2,2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',947.50,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2087,5481,40749,12138,2,2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',180.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2088,5481,40749,12138,2,2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1803.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2089,5481,40749,12138,2,2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',260.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2090,5481,40749,12138,2,2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',260.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2091,5481,40749,12138,2,2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',280.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2092,5481,40749,12138,2,2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',285.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2093,5481,40749,12138,2,2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',245.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2094,5481,40749,12138,2,2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',2698.90,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2095,5481,40749,12138,2,2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',198.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2096,5481,40749,12138,2,2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',210.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2097,5481,40749,12138,2,2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',220.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL);
INSERT INTO `balance_libro` VALUES (2098,5481,40749,12138,2,2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',795.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2099,5481,40749,12138,2,2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',470.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2100,5481,40749,12138,2,2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',361.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2101,5481,40749,12138,2,2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',173.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2102,5481,40749,12138,2,2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',799.50,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2103,5481,40749,12138,2,2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',280.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2104,5481,40749,12138,2,2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',530.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2105,5481,40749,12138,2,2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',505.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2106,5481,40749,12138,2,2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',110.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2107,5481,40749,12138,2,2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1473.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2108,5481,40749,12138,2,2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',85.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2109,5481,40749,12138,2,2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',890.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2110,5481,40749,12138,2,2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',568.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2111,5481,40749,12138,2,2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',260.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2112,5481,40749,12138,2,2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',716.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2113,5481,40749,12138,2,2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',265.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2114,5481,40749,12138,2,2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',292.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2115,5481,40749,12138,2,2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',603.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2116,5481,40749,12138,2,2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',125.00,NULL,NULL,1,'2021-08-09 16:23:30','2021-08-09 16:23:30',NULL),(2117,5481,40749,12138,2,2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',230.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2118,5481,40749,12138,2,2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',549.60,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2119,5481,40749,12138,2,2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',245.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2120,5481,40749,12138,2,2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1094.70,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2121,5481,40749,12138,2,2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',854.45,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL);
INSERT INTO `balance_libro` VALUES (2122,5481,40749,12138,2,2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1323.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2123,5481,40749,12138,2,2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',250.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2124,5481,40749,12138,2,2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',90.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2125,5481,40749,12138,2,2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',510.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2126,5481,40749,12138,2,2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1155.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2127,5481,40749,12138,2,2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',150.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2128,5481,40749,12138,2,2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',197.80,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2129,5481,40749,12138,2,2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',140.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2130,5481,40749,12138,2,2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',620.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2131,5481,40749,12138,2,2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',431.70,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2132,5481,40749,12138,2,2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',4211.20,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2133,5481,40749,12138,2,2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',393.90,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2134,5481,40749,12138,2,2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1166.85,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2135,5481,40749,12138,2,2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',585.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2136,5481,40749,12138,2,2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',260.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2137,5481,40749,12138,2,2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',195.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2138,5481,40749,12138,2,2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',220.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2139,5481,40749,12138,2,2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',200.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2140,5481,40749,12138,2,2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1286.40,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2141,5481,40749,12138,2,2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',200.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2142,5481,40749,12138,2,2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1100.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2143,5481,40749,12138,2,2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',880.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2144,5481,40749,12138,2,2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',230.00,NULL,NULL,1,'2021-08-09 16:23:31','2021-08-09 16:23:31',NULL),(2145,5481,40749,12138,2,2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',220.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL);
INSERT INTO `balance_libro` VALUES (2146,5481,40749,12138,2,2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',330.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2147,5481,40749,12138,2,2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',384.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2148,5481,40749,12138,2,2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1020.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2149,5481,40749,12138,2,2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',432.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2150,5481,40749,12138,2,2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',495.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2151,5481,40749,12138,2,2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',460.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2152,5481,40749,12138,2,2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',300.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2153,5481,40749,12138,2,2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',755.90,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2154,5481,40749,12138,2,2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1565.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2155,5481,40749,12138,2,2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',280.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2156,5481,40749,12138,2,2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1237.75,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2157,5481,40749,12138,2,2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',440.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2158,5481,40749,12138,2,2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',120.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2159,5481,40749,12138,2,2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1533.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2160,5481,40749,12138,2,2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',340.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2161,5481,40749,12138,2,2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',300.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2162,5481,40749,12138,2,2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',3009.50,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2163,5481,40749,12138,2,2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',714.35,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2164,5481,40749,12138,2,2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',4672.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2165,5481,40749,12138,2,2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1028.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2166,5481,40749,12138,2,2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',120.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2167,5481,40749,12138,2,2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',330.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2168,5481,40749,12138,2,2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',390.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2169,5481,40749,12138,2,2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',250.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL);
INSERT INTO `balance_libro` VALUES (2170,5481,40749,12138,2,2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',339.20,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2171,5481,40749,12138,2,2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',956.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2172,5481,40749,12138,2,2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',936.00,NULL,NULL,1,'2021-08-09 16:23:32','2021-08-09 16:23:32',NULL),(2173,5481,40749,12138,2,2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',329.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2174,5481,40749,12138,2,2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',160.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2175,5481,40749,12138,2,2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',530.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2176,5481,40749,12138,2,2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',669.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2177,5481,40749,12138,2,2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',292.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2178,5481,40749,12138,2,2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1080.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2179,5481,40749,12138,2,2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',210.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2180,5481,40749,12138,2,2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',669.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2181,5481,40749,12138,2,2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1274.40,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2182,5481,40749,12138,2,2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1267.50,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2183,5481,40749,12138,2,2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1708.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2184,5481,40749,12138,2,2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',130.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2185,5481,40749,12138,2,2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',670.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2186,5481,40749,12138,2,2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1126.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2187,5481,40749,12138,2,2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',544.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2188,5481,40749,12138,2,2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',442.30,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2189,5481,40749,12138,2,2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',250.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2190,5481,40749,12138,2,2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',200.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2191,5481,40749,12138,2,2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',230.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2192,5481,40749,12138,2,2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',255.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2193,5481,40749,12138,2,2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',300.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL);
INSERT INTO `balance_libro` VALUES (2194,5481,40749,12138,2,2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',415.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2195,5481,40749,12138,2,2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',30.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2196,5481,40749,12138,2,2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',300.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2197,5481,40749,12138,2,2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',810.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2198,5481,40749,12138,2,2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',185.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2199,5481,40749,12138,2,2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',960.00,NULL,NULL,1,'2021-08-09 16:23:33','2021-08-09 16:23:33',NULL),(2200,5481,40749,12138,2,2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',310.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2201,5481,40749,12138,2,2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',430.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2202,5481,40749,12138,2,2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',330.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2203,5481,40749,12138,2,2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1200.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2204,5481,40749,12138,2,2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',560.05,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2205,5481,40749,12138,2,2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',320.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2206,5481,40749,12138,2,2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',120.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2207,5481,40749,12138,2,2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',555.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2208,5481,40749,12138,2,2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',45.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2209,5481,40749,12138,2,2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',240.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2210,5481,40749,12138,2,2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',770.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2211,5481,40749,12138,2,2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',365.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2212,5481,40749,12138,2,2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1781.80,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2213,5481,40749,12138,2,2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',185.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2214,5481,40749,12138,2,2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',335.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2215,5481,40749,12138,2,2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',690.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2216,5481,40749,12138,2,2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',420.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2217,5481,40749,12138,2,2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1021.80,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL);
INSERT INTO `balance_libro` VALUES (2218,5481,40749,12138,2,2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',675.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2219,5481,40749,12138,2,2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',300.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2220,5481,40749,12138,2,2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',420.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2221,5481,40749,12138,2,2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',280.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2222,5481,40749,12138,2,2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',40.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2223,5481,40749,12138,2,2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',260.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2224,5481,40749,12138,2,2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',170.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2225,5481,40749,12138,2,2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',160.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2226,5481,40749,12138,2,2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',325.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2227,5481,40749,12138,2,2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',150.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2228,5481,40749,12138,2,2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',160.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2229,5481,40749,12138,2,2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',184.00,NULL,NULL,1,'2021-08-09 16:23:34','2021-08-09 16:23:34',NULL),(2230,5481,40749,12138,2,2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',838.70,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2231,5481,40749,12138,2,2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1351.90,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2232,5481,40749,12138,2,2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',390.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2233,5481,40749,12138,2,2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',360.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2234,5481,40749,12138,2,2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',261.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2235,5481,40749,12138,2,2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1684.80,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2236,5481,40749,12138,2,2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',526.20,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2237,5481,40749,12138,2,2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',405.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2238,5481,40749,12138,2,2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1121.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2239,5481,40749,12138,2,2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',420.90,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2240,5481,40749,12138,2,2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1178.30,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2241,5481,40749,12138,2,2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1274.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL);
INSERT INTO `balance_libro` VALUES (2242,5481,40749,12138,2,2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',464.30,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2243,5481,40749,12138,2,2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',764.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2244,5481,40749,12138,2,2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',687.75,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2245,5481,40749,12138,2,2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',660.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2246,5481,40749,12138,2,2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',302.25,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2247,5481,40749,12138,2,2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1960.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2248,5481,40749,12138,2,2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1378.67,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2249,5481,40749,12138,2,2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',130.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2250,5481,40749,12138,2,2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',140.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2251,5481,40749,12138,2,2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',65.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2252,5481,40749,12138,2,2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',460.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2253,5481,40749,12138,2,2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',225.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2254,5481,40749,12138,2,2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',145.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2255,5481,40749,12138,2,2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',370.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2256,5481,40749,12138,2,2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',100.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2257,5481,40749,12138,2,2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',130.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2258,5481,40749,12138,2,2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',500.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2259,5481,40749,12138,2,2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',160.00,NULL,NULL,1,'2021-08-09 16:23:35','2021-08-09 16:23:35',NULL),(2260,5481,40749,12138,2,2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',426.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2261,5481,40749,12138,2,2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',250.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2262,5481,40749,12138,2,2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',245.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2263,5481,40749,12138,2,2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1400.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2264,5481,40749,12138,2,2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',471.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2265,5481,40749,12138,2,2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',70.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL);
INSERT INTO `balance_libro` VALUES (2266,5481,40749,12138,2,2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1537.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2267,5481,40749,12138,2,2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',446.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2268,5481,40749,12138,2,2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',297.50,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2269,5481,40749,12138,2,2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',160.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2270,5481,40749,12138,2,2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1378.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2271,5481,40749,12138,2,2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',2395.75,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2272,5481,40749,12138,2,2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',571.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2273,5481,40749,12138,2,2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',220.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2274,5481,40749,12138,2,2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',2328.60,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2275,5481,40749,12138,2,2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',300.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2276,5481,40749,12138,2,2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',766.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2277,5481,40749,12138,2,2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',495.95,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2278,5481,40749,12138,2,2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1875.60,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2279,5481,40749,12138,2,2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',900.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2280,5481,40749,12138,2,2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',840.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2281,5481,40749,12138,2,2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',955.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2282,5481,40749,12138,2,2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',460.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2283,5481,40749,12138,2,2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',375.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2284,5481,40749,12138,2,2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',620.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2285,5481,40749,12138,2,2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',180.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2286,5481,40749,12138,2,2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',236.50,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2287,5481,40749,12138,2,2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',663.75,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2288,5481,40749,12138,2,2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',297.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2289,5481,40749,12138,2,2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',714.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL);
INSERT INTO `balance_libro` VALUES (2290,5481,40749,12138,2,2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',190.00,NULL,NULL,1,'2021-08-09 16:23:36','2021-08-09 16:23:36',NULL),(2291,5481,40749,12138,2,2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',460.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2292,5481,40749,12138,2,2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',140.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2293,5481,40749,12138,2,2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',598.95,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2294,5481,40749,12138,2,2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',379.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2295,5481,40749,12138,2,2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',370.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2296,5481,40749,12138,2,2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',345.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2297,5481,40749,12138,2,2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',455.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2298,5481,40749,12138,2,2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',448.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2299,5481,40749,12138,2,2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',472.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2300,5481,40749,12138,2,2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1050.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2301,5481,40749,12138,2,2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',880.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2302,5481,40749,12138,2,2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',3294.95,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2303,5481,40749,12138,2,2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',340.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2304,5481,40749,12138,2,2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',170.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2305,5481,40749,12138,2,2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',2190.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2306,5481,40749,12138,2,2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',720.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2307,5481,40749,12138,2,2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',760.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2308,5481,40749,12138,2,2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',222.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2309,5481,40749,12138,2,2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1018.85,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2310,5481,40749,12138,2,2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',379.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2311,5481,40749,12138,2,2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',450.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2312,5481,40749,12138,2,2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',43.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2313,5481,40749,12138,2,2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',160.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL);
INSERT INTO `balance_libro` VALUES (2314,5481,40749,12138,2,2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',660.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2315,5481,40749,12138,2,2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',490.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2316,5481,40749,12138,2,2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',195.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2317,5481,40749,12138,2,2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',440.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2318,5481,40749,12138,2,2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',400.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2319,5481,40749,12138,2,2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',525.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2320,5481,40749,12138,2,2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',898.00,NULL,NULL,1,'2021-08-09 16:23:37','2021-08-09 16:23:37',NULL),(2321,5481,40749,12138,2,2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1180.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2322,5481,40749,12138,2,2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1064.50,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2323,5481,40749,12138,2,2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',705.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2324,5481,40749,12138,2,2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1622.95,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2325,5481,40749,12138,2,2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',280.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2326,5481,40749,12138,2,2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1174.60,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2327,5481,40749,12138,2,2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',280.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2328,5481,40749,12138,2,2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1668.70,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2329,5481,40749,12138,2,2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',395.50,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2330,5481,40749,12138,2,2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',974.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2331,5481,40749,12138,2,2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',355.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2332,5481,40749,12138,2,2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',528.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2333,5481,40749,12138,2,2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',654.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2334,5481,40749,12138,2,2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',165.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2335,5481,40749,12138,2,2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',380.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2336,5481,40749,12138,2,2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',740.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2337,5481,40749,12138,2,2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',150.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL);
INSERT INTO `balance_libro` VALUES (2338,5481,40749,12138,2,2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',559.50,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2339,5481,40749,12138,2,2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',900.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2340,5481,40749,12138,2,2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',230.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2341,5481,40749,12138,2,2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1119.60,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2342,5481,40749,12138,2,2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',636.65,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2343,5481,40749,12138,2,2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',150.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2344,5481,40749,12138,2,2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',570.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2345,5481,40749,12138,2,2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',366.20,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2346,5481,40749,12138,2,2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1240.00,NULL,NULL,1,'2021-08-09 16:23:38','2021-08-09 16:23:38',NULL),(2347,5481,40749,12138,2,2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',2721.60,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2348,5481,40749,12138,2,2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',925.90,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2349,5481,40749,12138,2,2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',230.00,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2350,5481,40749,12138,2,2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1470.00,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2351,5481,40749,12138,2,2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',850.00,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2352,5481,40749,12138,2,2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',903.10,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2353,5481,40749,12138,2,2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',120.00,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2354,5481,40749,12138,2,2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',410.00,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2355,5481,40749,12138,2,2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',160.00,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2356,5481,40749,12138,2,2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',420.00,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2357,5481,40749,12138,2,2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',110.00,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2358,5481,40749,12138,2,2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',518.00,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2359,5481,40749,12138,2,2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1170.00,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2360,5481,40749,12138,2,2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',337.10,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2361,5481,40749,12138,2,2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',680.00,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL);
INSERT INTO `balance_libro` VALUES (2362,5481,40749,12138,2,2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',90.00,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2363,5481,40749,12138,2,2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1614.75,NULL,NULL,1,'2021-08-09 16:23:39','2021-08-09 16:23:39',NULL),(2364,5481,40749,12138,2,2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1250.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2365,5481,40749,12138,2,2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',430.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2366,5481,40749,12138,2,2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',660.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2367,5481,40749,12138,2,2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',2009.55,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2368,5481,40749,12138,2,2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',670.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2369,5481,40749,12138,2,2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',860.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2370,5481,40749,12138,2,2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',613.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2371,5481,40749,12138,2,2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',395.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2372,5481,40749,12138,2,2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',930.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2373,5481,40749,12138,2,2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',280.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2374,5481,40749,12138,2,2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',760.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2375,5481,40749,12138,2,2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1172.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2376,5481,40749,12138,2,2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',440.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2377,5481,40749,12138,2,2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',440.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2378,5481,40749,12138,2,2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',50.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2379,5481,40749,12138,2,2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',500.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2380,5481,40749,12138,2,2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',220.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2381,5481,40749,12138,2,2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1060.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2382,5481,40749,12138,2,2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',680.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2383,5481,40749,12138,2,2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1390.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2384,5481,40749,12138,2,2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',2092.75,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2385,5481,40749,12138,2,2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',240.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL);
INSERT INTO `balance_libro` VALUES (2386,5481,40749,12138,2,2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',635.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2387,5481,40749,12138,2,2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',120.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2388,5481,40749,12138,2,2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',500.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2389,5481,40749,12138,2,2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',820.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2390,5481,40749,12138,2,2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',99.00,NULL,NULL,1,'2021-08-09 16:23:40','2021-08-09 16:23:40',NULL),(2391,5481,40749,12138,2,2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',490.50,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2392,5481,40749,12138,2,2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',847.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2393,5481,40749,12138,2,2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',130.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2394,5481,40749,12138,2,2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',60.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2395,5481,40749,12138,2,2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',190.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2396,5481,40749,12138,2,2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',872.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2397,5481,40749,12138,2,2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',140.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2398,5481,40749,12138,2,2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',230.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2399,5481,40749,12138,2,2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',440.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2400,5481,40749,12138,2,2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',10230.05,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2401,5481,40749,12138,2,2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',285.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2402,5481,40749,12138,2,2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',465.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2403,5481,40749,12138,2,2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',150.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2404,5481,40749,12138,2,2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',195.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2405,5481,40749,12138,2,2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1630.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2406,5481,40749,12138,2,2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',720.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2407,5481,40749,12138,2,2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1007.50,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2408,5481,40749,12138,2,2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',248.70,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2409,5481,40749,12138,2,2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',4079.05,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL);
INSERT INTO `balance_libro` VALUES (2410,5481,40749,12138,2,2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',300.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2411,5481,40749,12138,2,2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',340.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2412,5481,40749,12138,2,2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',466.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2413,5481,40749,12138,2,2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',340.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2414,5481,40749,12138,2,2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',690.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2415,5481,40749,12138,2,2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1842.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2416,5481,40749,12138,2,2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1309.50,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2417,5481,40749,12138,2,2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',610.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2418,5481,40749,12138,2,2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',280.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2419,5481,40749,12138,2,2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',809.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2420,5481,40749,12138,2,2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',807.00,NULL,NULL,1,'2021-08-09 16:23:41','2021-08-09 16:23:41',NULL),(2421,5481,40749,12138,2,2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',405.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2422,5481,40749,12138,2,2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',500.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2423,5481,40749,12138,2,2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',225.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2424,5481,40749,12138,2,2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',297.05,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2425,5481,40749,12138,2,2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1250.40,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2426,5481,40749,12138,2,2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',459.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2427,5481,40749,12138,2,2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1272.75,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2428,5481,40749,12138,2,2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',2540.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2429,5481,40749,12138,2,2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',508.45,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2430,5481,40749,12138,2,2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',2120.90,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2431,5481,40749,12138,2,2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',315.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2432,5481,40749,12138,2,2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',280.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2433,5481,40749,12138,2,2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',350.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL);
INSERT INTO `balance_libro` VALUES (2434,5481,40749,12138,2,2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',210.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2435,5481,40749,12138,2,2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',324.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2436,5481,40749,12138,2,2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',600.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2437,5481,40749,12138,2,2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',130.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2438,5481,40749,12138,2,2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',882.70,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2439,5481,40749,12138,2,2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',680.30,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2440,5481,40749,12138,2,2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1087.45,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2441,5481,40749,12138,2,2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',450.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2442,5481,40749,12138,2,2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',708.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2443,5481,40749,12138,2,2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',984.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2444,5481,40749,12138,2,2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1251.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2445,5481,40749,12138,2,2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',200.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2446,5481,40749,12138,2,2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',472.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2447,5481,40749,12138,2,2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',670.45,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2448,5481,40749,12138,2,2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',711.70,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2449,5481,40749,12138,2,2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',1414.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2450,5481,40749,12138,2,2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',360.00,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2451,5481,40749,12138,2,2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',642.50,NULL,NULL,1,'2021-08-09 16:23:42','2021-08-09 16:23:42',NULL),(2452,5481,40749,12138,2,2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',330.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2453,5481,40749,12138,2,2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',170.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2454,5481,40749,12138,2,2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',720.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2455,5481,40749,12138,2,2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',600.55,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2456,5481,40749,12138,2,2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',260.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2457,5481,40749,12138,2,2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-18','2021-07-18',120.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL);
INSERT INTO `balance_libro` VALUES (2458,5481,40749,12138,2,2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',245.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2459,5481,40749,12138,2,2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1259.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2460,5481,40749,12138,2,2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1762.25,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2461,5481,40749,12138,2,2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',760.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2462,5481,40749,12138,2,2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',760.75,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2463,5481,40749,12138,2,2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',410.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2464,5481,40749,12138,2,2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',280.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2465,5481,40749,12138,2,2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',270.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2466,5481,40749,12138,2,2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',425.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2467,5481,40749,12138,2,2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',597.35,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2468,5481,40749,12138,2,2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',754.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2469,5481,40749,12138,2,2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',733.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2470,5481,40749,12138,2,2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',986.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2471,5481,40749,12138,2,2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',520.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2472,5481,40749,12138,2,2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',260.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2473,5481,40749,12138,2,2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',326.50,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2474,5481,40749,12138,2,2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',532.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2475,5481,40749,12138,2,2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',800.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2476,5481,40749,12138,2,2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1290.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2477,5481,40749,12138,2,2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',963.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2478,5481,40749,12138,2,2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',350.00,NULL,NULL,1,'2021-08-09 16:23:43','2021-08-09 16:23:43',NULL),(2479,5481,40749,12138,2,2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',316.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2480,5481,40749,12138,2,2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',492.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2481,5481,40749,12138,2,2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',280.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL);
INSERT INTO `balance_libro` VALUES (2482,5481,40749,12138,2,2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',190.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2483,5481,40749,12138,2,2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',2172.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2484,5481,40749,12138,2,2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',240.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2485,5481,40749,12138,2,2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',865.20,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2486,5481,40749,12138,2,2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',227.40,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2487,5481,40749,12138,2,2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',280.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2488,5481,40749,12138,2,2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',120.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2489,5481,40749,12138,2,2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',3329.75,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2490,5481,40749,12138,2,2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',885.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2491,5481,40749,12138,2,2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',755.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2492,5481,40749,12138,2,2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',633.50,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2493,5481,40749,12138,2,2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',260.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2494,5481,40749,12138,2,2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',665.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2495,5481,40749,12138,2,2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',724.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2496,5481,40749,12138,2,2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1864.60,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2497,5481,40749,12138,2,2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',511.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2498,5481,40749,12138,2,2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',610.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2499,5481,40749,12138,2,2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',820.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2500,5481,40749,12138,2,2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',500.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2501,5481,40749,12138,2,2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',350.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2502,5481,40749,12138,2,2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',662.35,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2503,5481,40749,12138,2,2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',320.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2504,5481,40749,12138,2,2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',250.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL),(2505,5481,40749,12138,2,2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',530.00,NULL,NULL,1,'2021-08-09 16:23:44','2021-08-09 16:23:44',NULL);
INSERT INTO `balance_libro` VALUES (2506,5481,40749,12138,2,2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1439.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2507,5481,40749,12138,2,2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1480.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2508,5481,40749,12138,2,2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',397.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2509,5481,40749,12138,2,2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',370.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2510,5481,40749,12138,2,2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',640.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2511,5481,40749,12138,2,2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',330.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2512,5481,40749,12138,2,2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',280.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2513,5481,40749,12138,2,2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',610.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2514,5481,40749,12138,2,2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',190.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2515,5481,40749,12138,2,2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1300.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2516,5481,40749,12138,2,2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',195.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2517,5481,40749,12138,2,2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',570.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2518,5481,40749,12138,2,2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',100.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2519,5481,40749,12138,2,2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',270.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2520,5481,40749,12138,2,2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',980.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2521,5481,40749,12138,2,2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',140.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2522,5481,40749,12138,2,2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',529.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2523,5481,40749,12138,2,2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',350.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2524,5481,40749,12138,2,2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1020.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2525,5481,40749,12138,2,2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',185.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2526,5481,40749,12138,2,2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',301.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2527,5481,40749,12138,2,2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',419.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2528,5481,40749,12138,2,2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',150.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2529,5481,40749,12138,2,2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',3308.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL);
INSERT INTO `balance_libro` VALUES (2530,5481,40749,12138,2,2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',110.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2531,5481,40749,12138,2,2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',769.10,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2532,5481,40749,12138,2,2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',200.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2533,5481,40749,12138,2,2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',689.00,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2534,5481,40749,12138,2,2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',2864.55,NULL,NULL,1,'2021-08-09 16:23:45','2021-08-09 16:23:45',NULL),(2535,5481,40749,12138,2,2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',100.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2536,5481,40749,12138,2,2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',570.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2537,5481,40749,12138,2,2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',547.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2538,5481,40749,12138,2,2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',410.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2539,5481,40749,12138,2,2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',695.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2540,5481,40749,12138,2,2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1248.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2541,5481,40749,12138,2,2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',271.40,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2542,5481,40749,12138,2,2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',500.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2543,5481,40749,12138,2,2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',70.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2544,5481,40749,12138,2,2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',190.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2545,5481,40749,12138,2,2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',300.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2546,5481,40749,12138,2,2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',370.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2547,5481,40749,12138,2,2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',409.80,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2548,5481,40749,12138,2,2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',320.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2549,5481,40749,12138,2,2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',4429.40,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2550,5481,40749,12138,2,2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',740.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2551,5481,40749,12138,2,2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',150.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2552,5481,40749,12138,2,2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',165.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2553,5481,40749,12138,2,2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',281.50,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL);
INSERT INTO `balance_libro` VALUES (2554,5481,40749,12138,2,2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1177.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2555,5481,40749,12138,2,2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',968.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2556,5481,40749,12138,2,2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',699.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2557,5481,40749,12138,2,2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',436.80,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2558,5481,40749,12138,2,2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',543.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2559,5481,40749,12138,2,2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',416.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2560,5481,40749,12138,2,2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',444.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2561,5481,40749,12138,2,2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',765.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2562,5481,40749,12138,2,2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1016.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2563,5481,40749,12138,2,2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1239.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2564,5481,40749,12138,2,2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',3734.30,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2565,5481,40749,12138,2,2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',150.00,NULL,NULL,1,'2021-08-09 16:23:46','2021-08-09 16:23:46',NULL),(2566,5481,40749,12138,2,2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',420.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2567,5481,40749,12138,2,2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',290.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2568,5481,40749,12138,2,2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',98.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2569,5481,40749,12138,2,2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',578.70,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2570,5481,40749,12138,2,2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',65.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2571,5481,40749,12138,2,2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',527.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2572,5481,40749,12138,2,2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',279.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2573,5481,40749,12138,2,2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',720.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2574,5481,40749,12138,2,2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',177.80,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2575,5481,40749,12138,2,2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',942.30,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2576,5481,40749,12138,2,2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',364.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2577,5481,40749,12138,2,2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1144.60,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL);
INSERT INTO `balance_libro` VALUES (2578,5481,40749,12138,2,2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',250.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2579,5481,40749,12138,2,2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',300.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2580,5481,40749,12138,2,2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',769.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2581,5481,40749,12138,2,2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',328.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2582,5481,40749,12138,2,2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',180.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2583,5481,40749,12138,2,2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1225.70,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2584,5481,40749,12138,2,2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',200.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2585,5481,40749,12138,2,2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',535.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2586,5481,40749,12138,2,2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',353.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2587,5481,40749,12138,2,2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',963.30,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2588,5481,40749,12138,2,2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',870.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2589,5481,40749,12138,2,2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',966.45,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2590,5481,40749,12138,2,2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1005.88,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2591,5481,40749,12138,2,2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',440.65,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2592,5481,40749,12138,2,2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',420.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2593,5481,40749,12138,2,2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',460.35,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2594,5481,40749,12138,2,2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',456.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2595,5481,40749,12138,2,2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',160.00,NULL,NULL,1,'2021-08-09 16:23:47','2021-08-09 16:23:47',NULL),(2596,5481,40749,12138,2,2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',390.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2597,5481,40749,12138,2,2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',150.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2598,5481,40749,12138,2,2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',317.65,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2599,5481,40749,12138,2,2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',170.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2600,5481,40749,12138,2,2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',110.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2601,5481,40749,12138,2,2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',919.20,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL);
INSERT INTO `balance_libro` VALUES (2602,5481,40749,12138,2,2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',220.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2603,5481,40749,12138,2,2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',431.20,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2604,5481,40749,12138,2,2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',85.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2605,5481,40749,12138,2,2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',583.35,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2606,5481,40749,12138,2,2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1820.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2607,5481,40749,12138,2,2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',740.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2608,5481,40749,12138,2,2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',190.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2609,5481,40749,12138,2,2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',2765.70,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2610,5481,40749,12138,2,2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',573.90,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2611,5481,40749,12138,2,2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',100.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2612,5481,40749,12138,2,2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',130.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2613,5481,40749,12138,2,2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',280.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2614,5481,40749,12138,2,2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',150.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2615,5481,40749,12138,2,2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',288.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2616,5481,40749,12138,2,2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',200.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2617,5481,40749,12138,2,2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',813.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2618,5481,40749,12138,2,2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',143.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2619,5481,40749,12138,2,2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',585.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2620,5481,40749,12138,2,2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',140.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2621,5481,40749,12138,2,2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',2641.30,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2622,5481,40749,12138,2,2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1393.75,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2623,5481,40749,12138,2,2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1450.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2624,5481,40749,12138,2,2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',130.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL),(2625,5481,40749,12138,2,2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',170.00,NULL,NULL,1,'2021-08-09 16:23:48','2021-08-09 16:23:48',NULL);
INSERT INTO `balance_libro` VALUES (2626,5481,40749,12138,2,2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1371.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2627,5481,40749,12138,2,2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',470.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2628,5481,40749,12138,2,2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',671.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2629,5481,40749,12138,2,2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1906.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2630,5481,40749,12138,2,2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',600.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2631,5481,40749,12138,2,2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',360.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2632,5481,40749,12138,2,2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',625.55,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2633,5481,40749,12138,2,2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',600.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2634,5481,40749,12138,2,2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',680.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2635,5481,40749,12138,2,2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',940.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2636,5481,40749,12138,2,2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1372.80,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2637,5481,40749,12138,2,2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',880.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2638,5481,40749,12138,2,2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',199.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2639,5481,40749,12138,2,2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',260.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2640,5481,40749,12138,2,2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',897.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2641,5481,40749,12138,2,2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',940.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2642,5481,40749,12138,2,2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1910.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2643,5481,40749,12138,2,2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',2428.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2644,5481,40749,12138,2,2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',350.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2645,5481,40749,12138,2,2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',250.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2646,5481,40749,12138,2,2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',950.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2647,5481,40749,12138,2,2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',490.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2648,5481,40749,12138,2,2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',155.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2649,5481,40749,12138,2,2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',195.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL);
INSERT INTO `balance_libro` VALUES (2650,5481,40749,12138,2,2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',650.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2651,5481,40749,12138,2,2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',160.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2652,5481,40749,12138,2,2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',980.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2653,5481,40749,12138,2,2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',170.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2654,5481,40749,12138,2,2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',840.00,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2655,5481,40749,12138,2,2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',932.50,NULL,NULL,1,'2021-08-09 16:23:49','2021-08-09 16:23:49',NULL),(2656,5481,40749,12138,2,2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',287.30,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2657,5481,40749,12138,2,2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',200.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2658,5481,40749,12138,2,2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',213.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2659,5481,40749,12138,2,2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',280.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2660,5481,40749,12138,2,2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',360.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2661,5481,40749,12138,2,2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',408.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2662,5481,40749,12138,2,2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',140.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2663,5481,40749,12138,2,2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',606.50,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2664,5481,40749,12138,2,2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',2310.60,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2665,5481,40749,12138,2,2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',200.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2666,5481,40749,12138,2,2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1401.75,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2667,5481,40749,12138,2,2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',476.65,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2668,5481,40749,12138,2,2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',130.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2669,5481,40749,12138,2,2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',183.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2670,5481,40749,12138,2,2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',450.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2671,5481,40749,12138,2,2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',320.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2672,5481,40749,12138,2,2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',361.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2673,5481,40749,12138,2,2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',616.50,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL);
INSERT INTO `balance_libro` VALUES (2674,5481,40749,12138,2,2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',651.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2675,5481,40749,12138,2,2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',651.10,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2676,5481,40749,12138,2,2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',345.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2677,5481,40749,12138,2,2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',518.55,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2678,5481,40749,12138,2,2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1107.75,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2679,5481,40749,12138,2,2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',420.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2680,5481,40749,12138,2,2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',840.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2681,5481,40749,12138,2,2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',255.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2682,5481,40749,12138,2,2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',618.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2683,5481,40749,12138,2,2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',540.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2684,5481,40749,12138,2,2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',170.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2685,5481,40749,12138,2,2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',720.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2686,5481,40749,12138,2,2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',160.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2687,5481,40749,12138,2,2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',210.00,NULL,NULL,1,'2021-08-09 16:23:50','2021-08-09 16:23:50',NULL),(2688,5481,40749,12138,2,2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',831.70,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2689,5481,40749,12138,2,2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',450.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2690,5481,40749,12138,2,2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',250.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2691,5481,40749,12138,2,2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',445.15,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2692,5481,40749,12138,2,2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',420.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2693,5481,40749,12138,2,2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',500.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2694,5481,40749,12138,2,2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',571.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2695,5481,40749,12138,2,2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1240.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2696,5481,40749,12138,2,2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',443.75,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2697,5481,40749,12138,2,2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',670.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL);
INSERT INTO `balance_libro` VALUES (2698,5481,40749,12138,2,2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1920.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2699,5481,40749,12138,2,2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',487.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2700,5481,40749,12138,2,2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',672.60,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2701,5481,40749,12138,2,2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',443.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2702,5481,40749,12138,2,2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',580.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2703,5481,40749,12138,2,2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1424.50,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2704,5481,40749,12138,2,2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',175.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2705,5481,40749,12138,2,2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',455.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2706,5481,40749,12138,2,2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',474.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2707,5481,40749,12138,2,2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',321.25,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2708,5481,40749,12138,2,2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',2317.50,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2709,5481,40749,12138,2,2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',450.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2710,5481,40749,12138,2,2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',650.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2711,5481,40749,12138,2,2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1070.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2712,5481,40749,12138,2,2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1286.40,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2713,5481,40749,12138,2,2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',270.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2714,5481,40749,12138,2,2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1280.75,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2715,5481,40749,12138,2,2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',415.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2716,5481,40749,12138,2,2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',200.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2717,5481,40749,12138,2,2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',170.00,NULL,NULL,1,'2021-08-09 16:23:51','2021-08-09 16:23:51',NULL),(2718,5481,40749,12138,2,2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',90.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2719,5481,40749,12138,2,2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',420.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2720,5481,40749,12138,2,2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',215.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2721,5481,40749,12138,2,2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',580.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL);
INSERT INTO `balance_libro` VALUES (2722,5481,40749,12138,2,2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',288.50,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2723,5481,40749,12138,2,2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',988.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2724,5481,40749,12138,2,2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',300.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2725,5481,40749,12138,2,2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',608.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2726,5481,40749,12138,2,2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',100.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2727,5481,40749,12138,2,2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1550.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2728,5481,40749,12138,2,2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',280.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2729,5481,40749,12138,2,2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',150.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2730,5481,40749,12138,2,2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1428.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2731,5481,40749,12138,2,2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',130.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2732,5481,40749,12138,2,2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',660.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2733,5481,40749,12138,2,2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',435.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2734,5481,40749,12138,2,2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',834.75,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2735,5481,40749,12138,2,2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',720.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2736,5481,40749,12138,2,2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',375.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2737,5481,40749,12138,2,2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',927.75,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2738,5481,40749,12138,2,2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',100.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2739,5481,40749,12138,2,2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',839.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2740,5481,40749,12138,2,2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',130.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2741,5481,40749,12138,2,2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',365.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2742,5481,40749,12138,2,2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',418.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2743,5481,40749,12138,2,2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1440.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2744,5481,40749,12138,2,2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',170.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2745,5481,40749,12138,2,2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',310.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL);
INSERT INTO `balance_libro` VALUES (2746,5481,40749,12138,2,2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1120.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2747,5481,40749,12138,2,2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',887.00,NULL,NULL,1,'2021-08-09 16:23:52','2021-08-09 16:23:52',NULL),(2748,5481,40749,12138,2,2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',920.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2749,5481,40749,12138,2,2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',200.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2750,5481,40749,12138,2,2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',170.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2751,5481,40749,12138,2,2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',945.55,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2752,5481,40749,12138,2,2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',285.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2753,5481,40749,12138,2,2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',560.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2754,5481,40749,12138,2,2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',917.70,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2755,5481,40749,12138,2,2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',452.75,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2756,5481,40749,12138,2,2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1500.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2757,5481,40749,12138,2,2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',230.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2758,5481,40749,12138,2,2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',70.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2759,5481,40749,12138,2,2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',315.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2760,5481,40749,12138,2,2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',148.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2761,5481,40749,12138,2,2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',398.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2762,5481,40749,12138,2,2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',785.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2763,5481,40749,12138,2,2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',232.40,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2764,5481,40749,12138,2,2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',540.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2765,5481,40749,12138,2,2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',260.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2766,5481,40749,12138,2,2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',457.75,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2767,5481,40749,12138,2,2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1721.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2768,5481,40749,12138,2,2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',239.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2769,5481,40749,12138,2,2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',890.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL);
INSERT INTO `balance_libro` VALUES (2770,5481,40749,12138,2,2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',170.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2771,5481,40749,12138,2,2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1360.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2772,5481,40749,12138,2,2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',752.70,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2773,5481,40749,12138,2,2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',692.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2774,5481,40749,12138,2,2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',90.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2775,5481,40749,12138,2,2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2990.20,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2776,5481,40749,12138,2,2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',150.00,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2777,5481,40749,12138,2,2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',825.75,NULL,NULL,1,'2021-08-09 16:23:53','2021-08-09 16:23:53',NULL),(2778,5481,40749,12138,2,2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',720.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2779,5481,40749,12138,2,2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',680.85,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2780,5481,40749,12138,2,2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',530.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2781,5481,40749,12138,2,2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1422.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2782,5481,40749,12138,2,2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',270.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2783,5481,40749,12138,2,2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',110.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2784,5481,40749,12138,2,2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',630.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2785,5481,40749,12138,2,2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',130.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2786,5481,40749,12138,2,2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',110.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2787,5481,40749,12138,2,2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',200.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2788,5481,40749,12138,2,2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1894.90,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2789,5481,40749,12138,2,2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',250.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2790,5481,40749,12138,2,2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',302.50,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2791,5481,40749,12138,2,2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',779.75,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2792,5481,40749,12138,2,2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',460.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2793,5481,40749,12138,2,2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',550.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL);
INSERT INTO `balance_libro` VALUES (2794,5481,40749,12138,2,2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',130.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2795,5481,40749,12138,2,2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',210.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2796,5481,40749,12138,2,2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',922.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2797,5481,40749,12138,2,2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',329.75,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2798,5481,40749,12138,2,2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1229.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2799,5481,40749,12138,2,2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',130.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2800,5481,40749,12138,2,2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1380.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2801,5481,40749,12138,2,2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',779.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2802,5481,40749,12138,2,2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',375.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2803,5481,40749,12138,2,2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',160.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2804,5481,40749,12138,2,2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',500.90,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2805,5481,40749,12138,2,2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',390.00,NULL,NULL,1,'2021-08-09 16:23:54','2021-08-09 16:23:54',NULL),(2806,5481,40749,12138,2,2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1310.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2807,5481,40749,12138,2,2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',410.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2808,5481,40749,12138,2,2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',409.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2809,5481,40749,12138,2,2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',375.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2810,5481,40749,12138,2,2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',415.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2811,5481,40749,12138,2,2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',310.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2812,5481,40749,12138,2,2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1646.90,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2813,5481,40749,12138,2,2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',433.35,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2814,5481,40749,12138,2,2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',307.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2815,5481,40749,12138,2,2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',730.95,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2816,5481,40749,12138,2,2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',910.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2817,5481,40749,12138,2,2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1198.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL);
INSERT INTO `balance_libro` VALUES (2818,5481,40749,12138,2,2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',168.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2819,5481,40749,12138,2,2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',130.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2820,5481,40749,12138,2,2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',270.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2821,5481,40749,12138,2,2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1240.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2822,5481,40749,12138,2,2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',380.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2823,5481,40749,12138,2,2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',656.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2824,5481,40749,12138,2,2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',395.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2825,5481,40749,12138,2,2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',600.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2826,5481,40749,12138,2,2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',755.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2827,5481,40749,12138,2,2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1040.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2828,5481,40749,12138,2,2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',555.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2829,5481,40749,12138,2,2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',540.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2830,5481,40749,12138,2,2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',135.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2831,5481,40749,12138,2,2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',2064.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2832,5481,40749,12138,2,2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1552.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2833,5481,40749,12138,2,2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',414.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2834,5481,40749,12138,2,2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',145.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2835,5481,40749,12138,2,2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',240.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2836,5481,40749,12138,2,2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',400.00,NULL,NULL,1,'2021-08-09 16:23:55','2021-08-09 16:23:55',NULL),(2837,5481,40749,12138,2,2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1880.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2838,5481,40749,12138,2,2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1200.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2839,5481,40749,12138,2,2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',633.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2840,5481,40749,12138,2,2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',10.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2841,5481,40749,12138,2,2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',846.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL);
INSERT INTO `balance_libro` VALUES (2842,5481,40749,12138,2,2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',120.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2843,5481,40749,12138,2,2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',565.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2844,5481,40749,12138,2,2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',90.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2845,5481,40749,12138,2,2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1085.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2846,5481,40749,12138,2,2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1465.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2847,5481,40749,12138,2,2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',345.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2848,5481,40749,12138,2,2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',465.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2849,5481,40749,12138,2,2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',60.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2850,5481,40749,12138,2,2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',150.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2851,5481,40749,12138,2,2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',535.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2852,5481,40749,12138,2,2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',299.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2853,5481,40749,12138,2,2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',200.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2854,5481,40749,12138,2,2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1084.90,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2855,5481,40749,12138,2,2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',300.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2856,5481,40749,12138,2,2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',425.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2857,5481,40749,12138,2,2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',510.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2858,5481,40749,12138,2,2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',377.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2859,5481,40749,12138,2,2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',140.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2860,5481,40749,12138,2,2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',427.20,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2861,5481,40749,12138,2,2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',953.85,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2862,5481,40749,12138,2,2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',950.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2863,5481,40749,12138,2,2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',478.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2864,5481,40749,12138,2,2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',20.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2865,5481,40749,12138,2,2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',170.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL);
INSERT INTO `balance_libro` VALUES (2866,5481,40749,12138,2,2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',370.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2867,5481,40749,12138,2,2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',593.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2868,5481,40749,12138,2,2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',150.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2869,5481,40749,12138,2,2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',300.00,NULL,NULL,1,'2021-08-09 16:23:56','2021-08-09 16:23:56',NULL),(2870,5481,40749,12138,2,2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1315.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2871,5481,40749,12138,2,2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1490.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2872,5481,40749,12138,2,2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',569.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2873,5481,40749,12138,2,2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',150.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2874,5481,40749,12138,2,2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',197.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2875,5481,40749,12138,2,2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',220.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2876,5481,40749,12138,2,2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',310.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2877,5481,40749,12138,2,2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1309.80,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2878,5481,40749,12138,2,2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',2170.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2879,5481,40749,12138,2,2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1884.75,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2880,5481,40749,12138,2,2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',260.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2881,5481,40749,12138,2,2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',588.15,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2882,5481,40749,12138,2,2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',170.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2883,5481,40749,12138,2,2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',2895.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2884,5481,40749,12138,2,2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',535.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2885,5481,40749,12138,2,2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',315.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2886,5481,40749,12138,2,2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',260.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2887,5481,40749,12138,2,2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',80.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2888,5481,40749,12138,2,2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',50.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2889,5481,40749,12138,2,2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',315.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL);
INSERT INTO `balance_libro` VALUES (2890,5481,40749,12138,2,2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',160.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2891,5481,40749,12138,2,2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1136.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2892,5481,40749,12138,2,2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',160.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2893,5481,40749,12138,2,2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',931.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2894,5481,40749,12138,2,2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',490.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2895,5481,40749,12138,2,2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1348.45,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2896,5481,40749,12138,2,2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',68.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2897,5481,40749,12138,2,2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',749.50,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2898,5481,40749,12138,2,2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',180.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2899,5481,40749,12138,2,2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',403.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2900,5481,40749,12138,2,2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',300.00,NULL,NULL,1,'2021-08-09 16:23:57','2021-08-09 16:23:57',NULL),(2901,5481,40749,12138,2,2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',250.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2902,5481,40749,12138,2,2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',210.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2903,5481,40749,12138,2,2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',578.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2904,5481,40749,12138,2,2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',855.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2905,5481,40749,12138,2,2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1077.80,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2906,5481,40749,12138,2,2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',281.20,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2907,5481,40749,12138,2,2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',130.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2908,5481,40749,12138,2,2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',252.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2909,5481,40749,12138,2,2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',100.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2910,5481,40749,12138,2,2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1098.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2911,5481,40749,12138,2,2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',340.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2912,5481,40749,12138,2,2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',3292.75,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2913,5481,40749,12138,2,2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',102.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL);
INSERT INTO `balance_libro` VALUES (2914,5481,40749,12138,2,2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1826.30,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2915,5481,40749,12138,2,2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',535.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2916,5481,40749,12138,2,2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',720.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2917,5481,40749,12138,2,2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',141.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2918,5481,40749,12138,2,2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',240.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2919,5481,40749,12138,2,2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',115.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2920,5481,40749,12138,2,2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',765.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2921,5481,40749,12138,2,2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',926.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2922,5481,40749,12138,2,2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',280.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2923,5481,40749,12138,2,2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',2963.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2924,5481,40749,12138,2,2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',300.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2925,5481,40749,12138,2,2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',100.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2926,5481,40749,12138,2,2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',380.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2927,5481,40749,12138,2,2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',220.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2928,5481,40749,12138,2,2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',2678.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2929,5481,40749,12138,2,2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',550.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2930,5481,40749,12138,2,2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1357.80,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2931,5481,40749,12138,2,2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',810.00,NULL,NULL,1,'2021-08-09 16:23:58','2021-08-09 16:23:58',NULL),(2932,5481,40749,12138,2,2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',80.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2933,5481,40749,12138,2,2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',140.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2934,5481,40749,12138,2,2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',175.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2935,5481,40749,12138,2,2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',110.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2936,5481,40749,12138,2,2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1360.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2937,5481,40749,12138,2,2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1290.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL);
INSERT INTO `balance_libro` VALUES (2938,5481,40749,12138,2,2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',250.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2939,5481,40749,12138,2,2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1690.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2940,5481,40749,12138,2,2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1090.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2941,5481,40749,12138,2,2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',959.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2942,5481,40749,12138,2,2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',540.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2943,5481,40749,12138,2,2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',363.60,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2944,5481,40749,12138,2,2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',150.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2945,5481,40749,12138,2,2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',600.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2946,5481,40749,12138,2,2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',170.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2947,5481,40749,12138,2,2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1455.85,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2948,5481,40749,12138,2,2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',849.95,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2949,5481,40749,12138,2,2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',228.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2950,5481,40749,12138,2,2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',400.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2951,5481,40749,12138,2,2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1390.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2952,5481,40749,12138,2,2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',280.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2953,5481,40749,12138,2,2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1380.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2954,5481,40749,12138,2,2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',563.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2955,5481,40749,12138,2,2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',890.45,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2956,5481,40749,12138,2,2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',90.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2957,5481,40749,12138,2,2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',143.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2958,5481,40749,12138,2,2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1344.35,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2959,5481,40749,12138,2,2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',93.00,NULL,NULL,1,'2021-08-09 16:23:59','2021-08-09 16:23:59',NULL),(2960,5481,40749,12138,2,2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',759.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2961,5481,40749,12138,2,2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',235.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL);
INSERT INTO `balance_libro` VALUES (2962,5481,40749,12138,2,2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',765.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2963,5481,40749,12138,2,2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',430.50,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2964,5481,40749,12138,2,2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',180.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2965,5481,40749,12138,2,2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1070.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2966,5481,40749,12138,2,2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',283.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2967,5481,40749,12138,2,2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',836.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2968,5481,40749,12138,2,2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',235.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2969,5481,40749,12138,2,2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',126.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2970,5481,40749,12138,2,2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',943.50,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2971,5481,40749,12138,2,2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',891.50,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2972,5481,40749,12138,2,2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',568.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2973,5481,40749,12138,2,2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',541.25,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2974,5481,40749,12138,2,2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1047.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2975,5481,40749,12138,2,2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',540.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2976,5481,40749,12138,2,2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',425.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2977,5481,40749,12138,2,2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',250.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2978,5481,40749,12138,2,2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',241.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2979,5481,40749,12138,2,2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',320.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2980,5481,40749,12138,2,2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',130.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2981,5481,40749,12138,2,2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',485.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2982,5481,40749,12138,2,2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',701.50,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2983,5481,40749,12138,2,2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',178.70,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2984,5481,40749,12138,2,2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',100.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2985,5481,40749,12138,2,2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',258.60,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL);
INSERT INTO `balance_libro` VALUES (2986,5481,40749,12138,2,2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',460.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2987,5481,40749,12138,2,2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1030.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2988,5481,40749,12138,2,2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',180.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2989,5481,40749,12138,2,2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1151.00,NULL,NULL,1,'2021-08-09 16:24:00','2021-08-09 16:24:00',NULL),(2990,5481,40749,12138,2,2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1446.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(2991,5481,40749,12138,2,2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',195.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(2992,5481,40749,12138,2,2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',4566.85,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(2993,5481,40749,12138,2,2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',3480.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(2994,5481,40749,12138,2,2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',520.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(2995,5481,40749,12138,2,2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',2704.95,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(2996,5481,40749,12138,2,2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',850.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(2997,5481,40749,12138,2,2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1857.25,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(2998,5481,40749,12138,2,2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',478.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(2999,5481,40749,12138,2,2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1080.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3000,5481,40749,12138,2,2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',250.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3001,5481,40749,12138,2,2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',483.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3002,5481,40749,12138,2,3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1062.60,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3003,5481,40749,12138,2,3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',872.20,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3004,5481,40749,12138,2,3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',418.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3005,5481,40749,12138,2,3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',680.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3006,5481,40749,12138,2,3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',130.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3007,5481,40749,12138,2,3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',570.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3008,5481,40749,12138,2,3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',396.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3009,5481,40749,12138,2,3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',110.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL);
INSERT INTO `balance_libro` VALUES (3010,5481,40749,12138,2,3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',269.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3011,5481,40749,12138,2,3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',175.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3012,5481,40749,12138,2,3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',230.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3013,5481,40749,12138,2,3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1360.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3014,5481,40749,12138,2,3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1108.80,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3015,5481,40749,12138,2,3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',258.00,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3016,5481,40749,12138,2,3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1069.60,NULL,NULL,1,'2021-08-09 16:24:01','2021-08-09 16:24:01',NULL),(3017,5481,40749,12138,2,3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',625.65,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3018,5481,40749,12138,2,3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1502.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3019,5481,40749,12138,2,3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',315.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3020,5481,40749,12138,2,3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1060.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3021,5481,40749,12138,2,3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',390.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3022,5481,40749,12138,2,3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',280.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3023,5481,40749,12138,2,3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',240.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3024,5481,40749,12138,2,3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',150.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3025,5481,40749,12138,2,3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',500.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3026,5481,40749,12138,2,3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',290.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3027,5481,40749,12138,2,3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',110.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3028,5481,40749,12138,2,3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',4361.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3029,5481,40749,12138,2,3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',380.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3030,5481,40749,12138,2,3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',727.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3031,5481,40749,12138,2,3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',180.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3032,5481,40749,12138,2,3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',350.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3033,5481,40749,12138,2,3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',60.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL);
INSERT INTO `balance_libro` VALUES (3034,5481,40749,12138,2,3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1360.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3035,5481,40749,12138,2,3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',530.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3036,5481,40749,12138,2,3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',327.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3037,5481,40749,12138,2,3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',399.75,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3038,5481,40749,12138,2,3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',525.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3039,5481,40749,12138,2,3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',978.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3040,5481,40749,12138,2,3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',600.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3041,5481,40749,12138,2,3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',150.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3042,5481,40749,12138,2,3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',422.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3043,5481,40749,12138,2,3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',956.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3044,5481,40749,12138,2,3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',335.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3045,5481,40749,12138,2,3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',300.00,NULL,NULL,1,'2021-08-09 16:24:02','2021-08-09 16:24:02',NULL),(3046,5481,40749,12138,2,3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',379.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3047,5481,40749,12138,2,3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',385.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3048,5481,40749,12138,2,3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',220.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3049,5481,40749,12138,2,3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',230.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3050,5481,40749,12138,2,3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',390.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3051,5481,40749,12138,2,3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',564.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3052,5481,40749,12138,2,3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1405.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3053,5481,40749,12138,2,3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',457.50,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3054,5481,40749,12138,2,3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',170.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3055,5481,40749,12138,2,3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',240.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3056,5481,40749,12138,2,3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1696.60,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3057,5481,40749,12138,2,3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',903.90,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL);
INSERT INTO `balance_libro` VALUES (3058,5481,40749,12138,2,3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',190.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3059,5481,40749,12138,2,3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',395.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3060,5481,40749,12138,2,3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',250.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3061,5481,40749,12138,2,3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',602.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3062,5481,40749,12138,2,3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',420.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3063,5481,40749,12138,2,3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',847.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3064,5481,40749,12138,2,3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',1809.70,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3065,5481,40749,12138,2,3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',573.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3066,5481,40749,12138,2,3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',270.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3067,5481,40749,12138,2,3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',678.60,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3068,5481,40749,12138,2,3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',617.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3069,5481,40749,12138,2,3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',460.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3070,5481,40749,12138,2,3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1589.20,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3071,5481,40749,12138,2,3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',450.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3072,5481,40749,12138,2,3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1080.00,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3073,5481,40749,12138,2,3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1577.50,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3074,5481,40749,12138,2,3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',474.70,NULL,NULL,1,'2021-08-09 16:24:03','2021-08-09 16:24:03',NULL),(3075,5481,40749,12138,2,3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',150.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3076,5481,40749,12138,2,3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',300.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3077,5481,40749,12138,2,3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1764.45,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3078,5481,40749,12138,2,3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',130.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3079,5481,40749,12138,2,3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',100.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3080,5481,40749,12138,2,3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',440.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3081,5481,40749,12138,2,3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',295.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL);
INSERT INTO `balance_libro` VALUES (3082,5481,40749,12138,2,3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',130.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3083,5481,40749,12138,2,3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',600.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3084,5481,40749,12138,2,3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1580.05,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3085,5481,40749,12138,2,3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',256.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3086,5481,40749,12138,2,3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',360.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3087,5481,40749,12138,2,3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',570.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3088,5481,40749,12138,2,3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',90.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3089,5481,40749,12138,2,3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',240.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3090,5481,40749,12138,2,3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',590.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3091,5481,40749,12138,2,3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',220.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3092,5481,40749,12138,2,3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',664.70,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3093,5481,40749,12138,2,3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',684.60,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3094,5481,40749,12138,2,3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',803.50,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3095,5481,40749,12138,2,3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',841.60,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3096,5481,40749,12138,2,3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',194.90,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3097,5481,40749,12138,2,3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',430.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3098,5481,40749,12138,2,3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1807.50,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3099,5481,40749,12138,2,3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',990.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3100,5481,40749,12138,2,3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',570.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3101,5481,40749,12138,2,3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',466.00,NULL,NULL,1,'2021-08-09 16:24:04','2021-08-09 16:24:04',NULL),(3102,5481,40749,12138,2,3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',500.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3103,5481,40749,12138,2,3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',595.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3104,5481,40749,12138,2,3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',739.10,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3105,5481,40749,12138,2,3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',540.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL);
INSERT INTO `balance_libro` VALUES (3106,5481,40749,12138,2,3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',470.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3107,5481,40749,12138,2,3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',458.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3108,5481,40749,12138,2,3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',130.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3109,5481,40749,12138,2,3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',460.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3110,5481,40749,12138,2,3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',716.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3111,5481,40749,12138,2,3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',170.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3112,5481,40749,12138,2,3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',520.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3113,5481,40749,12138,2,3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',558.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3114,5481,40749,12138,2,3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1190.45,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3115,5481,40749,12138,2,3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',2510.05,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3116,5481,40749,12138,2,3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',770.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3117,5481,40749,12138,2,3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',380.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3118,5481,40749,12138,2,3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',227.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3119,5481,40749,12138,2,3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',300.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3120,5481,40749,12138,2,3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',480.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3121,5481,40749,12138,2,3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',600.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3122,5481,40749,12138,2,3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',170.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3123,5481,40749,12138,2,3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',590.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3124,5481,40749,12138,2,3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1743.50,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3125,5481,40749,12138,2,3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',150.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3126,5481,40749,12138,2,3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1120.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3127,5481,40749,12138,2,3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',360.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3128,5481,40749,12138,2,3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',1350.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3129,5481,40749,12138,2,3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',220.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL);
INSERT INTO `balance_libro` VALUES (3130,5481,40749,12138,2,3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25','2021-07-25',660.00,NULL,NULL,1,'2021-08-09 16:24:05','2021-08-09 16:24:05',NULL),(3131,5481,40749,12138,2,3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',230.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3132,5481,40749,12138,2,3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',170.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3133,5481,40749,12138,2,3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',75.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3134,5481,40749,12138,2,3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',440.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3135,5481,40749,12138,2,3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',2302.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3136,5481,40749,12138,2,3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',720.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3137,5481,40749,12138,2,3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',260.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3138,5481,40749,12138,2,3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',225.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3139,5481,40749,12138,2,3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',228.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3140,5481,40749,12138,2,3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',175.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3141,5481,40749,12138,2,3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',296.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3142,5481,40749,12138,2,3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1030.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3143,5481,40749,12138,2,3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',348.80,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3144,5481,40749,12138,2,3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1711.80,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3145,5481,40749,12138,2,3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',475.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3146,5481,40749,12138,2,3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1147.70,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3147,5481,40749,12138,2,3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',600.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3148,5481,40749,12138,2,3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',120.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3149,5481,40749,12138,2,3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',55.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3150,5481,40749,12138,2,3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',296.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3151,5481,40749,12138,2,3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1521.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3152,5481,40749,12138,2,3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',520.30,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3153,5481,40749,12138,2,3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',130.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL);
INSERT INTO `balance_libro` VALUES (3154,5481,40749,12138,2,3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',390.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3155,5481,40749,12138,2,3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',380.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3156,5481,40749,12138,2,3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1455.75,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3157,5481,40749,12138,2,3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',500.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3158,5481,40749,12138,2,3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',530.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3159,5481,40749,12138,2,3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',520.00,NULL,NULL,1,'2021-08-09 16:24:06','2021-08-09 16:24:06',NULL),(3160,5481,40749,12138,2,3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',499.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3161,5481,40749,12138,2,3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',94.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3162,5481,40749,12138,2,3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',550.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3163,5481,40749,12138,2,3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',519.25,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3164,5481,40749,12138,2,3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',325.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3165,5481,40749,12138,2,3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',150.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3166,5481,40749,12138,2,3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',320.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3167,5481,40749,12138,2,3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',60.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3168,5481,40749,12138,2,3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',410.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3169,5481,40749,12138,2,3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',684.20,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3170,5481,40749,12138,2,3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',300.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3171,5481,40749,12138,2,3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',200.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3172,5481,40749,12138,2,3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',175.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3173,5481,40749,12138,2,3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',260.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3174,5481,40749,12138,2,3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',265.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3175,5481,40749,12138,2,3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',490.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3176,5481,40749,12138,2,3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',198.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3177,5481,40749,12138,2,3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',70.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL);
INSERT INTO `balance_libro` VALUES (3178,5481,40749,12138,2,3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',440.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3179,5481,40749,12138,2,3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',540.30,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3180,5481,40749,12138,2,3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',160.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3181,5481,40749,12138,2,3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',65.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3182,5481,40749,12138,2,3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1310.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3183,5481,40749,12138,2,3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',753.50,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3184,5481,40749,12138,2,3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1100.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3185,5481,40749,12138,2,3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1705.75,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3186,5481,40749,12138,2,3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',85.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3187,5481,40749,12138,2,3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',304.50,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3188,5481,40749,12138,2,3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',300.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3189,5481,40749,12138,2,3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',500.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3190,5481,40749,12138,2,3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',100.00,NULL,NULL,1,'2021-08-09 16:24:07','2021-08-09 16:24:07',NULL),(3191,5481,40749,12138,2,3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',2440.25,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3192,5481,40749,12138,2,3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',542.75,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3193,5481,40749,12138,2,3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',130.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3194,5481,40749,12138,2,3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',450.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3195,5481,40749,12138,2,3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1870.50,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3196,5481,40749,12138,2,3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',770.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3197,5481,40749,12138,2,3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',525.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3198,5481,40749,12138,2,3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',300.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3199,5481,40749,12138,2,3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',110.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3200,5481,40749,12138,2,3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1669.35,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3201,5481,40749,12138,2,3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',434.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL);
INSERT INTO `balance_libro` VALUES (3202,5481,40749,12138,2,3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',95.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3203,5481,40749,12138,2,3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',160.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3204,5481,40749,12138,2,3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1725.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3205,5481,40749,12138,2,3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',195.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3206,5481,40749,12138,2,3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',600.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3207,5481,40749,12138,2,3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',310.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3208,5481,40749,12138,2,3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',675.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3209,5481,40749,12138,2,3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',465.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3210,5481,40749,12138,2,3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',70.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3211,5481,40749,12138,2,3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1187.50,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3212,5481,40749,12138,2,3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1030.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3213,5481,40749,12138,2,3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',2793.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3214,5481,40749,12138,2,3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1375.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3215,5481,40749,12138,2,3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',750.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3216,5481,40749,12138,2,3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',330.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3217,5481,40749,12138,2,3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',375.00,NULL,NULL,1,'2021-08-09 16:24:08','2021-08-09 16:24:08',NULL),(3218,5481,40749,12138,2,3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',255.50,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3219,5481,40749,12138,2,3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',135.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3220,5481,40749,12138,2,3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1504.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3221,5481,40749,12138,2,3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',195.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3222,5481,40749,12138,2,3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',412.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3223,5481,40749,12138,2,3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',222.30,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3224,5481,40749,12138,2,3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',210.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3225,5481,40749,12138,2,3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',225.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL);
INSERT INTO `balance_libro` VALUES (3226,5481,40749,12138,2,3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',495.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3227,5481,40749,12138,2,3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1753.45,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3228,5481,40749,12138,2,3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',275.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3229,5481,40749,12138,2,3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',235.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3230,5481,40749,12138,2,3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',80.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3231,5481,40749,12138,2,3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1536.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3232,5481,40749,12138,2,3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',953.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3233,5481,40749,12138,2,3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',425.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3234,5481,40749,12138,2,3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',650.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3235,5481,40749,12138,2,3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',325.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3236,5481,40749,12138,2,3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',435.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3237,5481,40749,12138,2,3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',2256.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3238,5481,40749,12138,2,3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',237.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3239,5481,40749,12138,2,3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1084.60,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3240,5481,40749,12138,2,3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1230.85,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3241,5481,40749,12138,2,3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',3714.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3242,5481,40749,12138,2,3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1652.50,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3243,5481,40749,12138,2,3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',170.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3244,5481,40749,12138,2,3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',567.40,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3245,5481,40749,12138,2,3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',85.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3246,5481,40749,12138,2,3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',81.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3247,5481,40749,12138,2,3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',210.00,NULL,NULL,1,'2021-08-09 16:24:09','2021-08-09 16:24:09',NULL),(3248,5481,40749,12138,2,3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',200.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3249,5481,40749,12138,2,3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',58.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL);
INSERT INTO `balance_libro` VALUES (3250,5481,40749,12138,2,3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',760.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3251,5481,40749,12138,2,3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',190.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3252,5481,40749,12138,2,3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',135.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3253,5481,40749,12138,2,3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',490.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3254,5481,40749,12138,2,3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',604.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3255,5481,40749,12138,2,3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',266.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3256,5481,40749,12138,2,3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1149.40,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3257,5481,40749,12138,2,3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',95.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3258,5481,40749,12138,2,3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',140.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3259,5481,40749,12138,2,3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1437.95,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3260,5481,40749,12138,2,3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',770.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3261,5481,40749,12138,2,3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',880.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3262,5481,40749,12138,2,3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',580.60,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3263,5481,40749,12138,2,3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',75.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3264,5481,40749,12138,2,3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1455.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3265,5481,40749,12138,2,3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1814.30,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3266,5481,40749,12138,2,3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',215.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3267,5481,40749,12138,2,3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',645.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3268,5481,40749,12138,2,3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',670.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3269,5481,40749,12138,2,3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',796.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3270,5481,40749,12138,2,3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',320.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3271,5481,40749,12138,2,3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1036.10,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3272,5481,40749,12138,2,3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',488.90,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3273,5481,40749,12138,2,3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',60.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL);
INSERT INTO `balance_libro` VALUES (3274,5481,40749,12138,2,3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',260.00,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3275,5481,40749,12138,2,3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',557.25,NULL,NULL,1,'2021-08-09 16:24:10','2021-08-09 16:24:10',NULL),(3276,5481,40749,12138,2,3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',245.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3277,5481,40749,12138,2,3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',475.40,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3278,5481,40749,12138,2,3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',430.75,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3279,5481,40749,12138,2,3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',371.20,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3280,5481,40749,12138,2,3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',200.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3281,5481,40749,12138,2,3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',280.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3282,5481,40749,12138,2,3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',807.30,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3283,5481,40749,12138,2,3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',220.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3284,5481,40749,12138,2,3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',517.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3285,5481,40749,12138,2,3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',287.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3286,5481,40749,12138,2,3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',130.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3287,5481,40749,12138,2,3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',100.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3288,5481,40749,12138,2,3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',190.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3289,5481,40749,12138,2,3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',941.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3290,5481,40749,12138,2,3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',729.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3291,5481,40749,12138,2,3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1070.50,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3292,5481,40749,12138,2,3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',971.20,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3293,5481,40749,12138,2,3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',100.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3294,5481,40749,12138,2,3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',489.75,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3295,5481,40749,12138,2,3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',705.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3296,5481,40749,12138,2,3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',210.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3297,5481,40749,12138,2,3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1029.35,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL);
INSERT INTO `balance_libro` VALUES (3298,5481,40749,12138,2,3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',460.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3299,5481,40749,12138,2,3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',3660.75,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3300,5481,40749,12138,2,3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1676.25,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3301,5481,40749,12138,2,3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',90.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3302,5481,40749,12138,2,3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1709.05,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3303,5481,40749,12138,2,3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',480.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3304,5481,40749,12138,2,3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',130.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3305,5481,40749,12138,2,3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',45.00,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3306,5481,40749,12138,2,3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',595.50,NULL,NULL,1,'2021-08-09 16:24:11','2021-08-09 16:24:11',NULL),(3307,5481,40749,12138,2,3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1140.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3308,5481,40749,12138,2,3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',103.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3309,5481,40749,12138,2,3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',170.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3310,5481,40749,12138,2,3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',240.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3311,5481,40749,12138,2,3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',130.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3312,5481,40749,12138,2,3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',130.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3313,5481,40749,12138,2,3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',550.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3314,5481,40749,12138,2,3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',520.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3315,5481,40749,12138,2,3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',585.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3316,5481,40749,12138,2,3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',419.40,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3317,5481,40749,12138,2,3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',220.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3318,5481,40749,12138,2,3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',430.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3319,5481,40749,12138,2,3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',170.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3320,5481,40749,12138,2,3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',120.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3321,5481,40749,12138,2,3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',180.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL);
INSERT INTO `balance_libro` VALUES (3322,5481,40749,12138,2,3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',11111.50,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3323,5481,40749,12138,2,3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',400.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3324,5481,40749,12138,2,3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',300.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3325,5481,40749,12138,2,3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',520.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3326,5481,40749,12138,2,3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',442.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3327,5481,40749,12138,2,3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1497.40,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3328,5481,40749,12138,2,3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',430.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3329,5481,40749,12138,2,3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',404.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3330,5481,40749,12138,2,3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',110.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3331,5481,40749,12138,2,3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',300.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3332,5481,40749,12138,2,3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1017.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3333,5481,40749,12138,2,3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',130.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3334,5481,40749,12138,2,3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',771.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3335,5481,40749,12138,2,3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',285.00,NULL,NULL,1,'2021-08-09 16:24:12','2021-08-09 16:24:12',NULL),(3336,5481,40749,12138,2,3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',330.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3337,5481,40749,12138,2,3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',530.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3338,5481,40749,12138,2,3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',300.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3339,5481,40749,12138,2,3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1587.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3340,5481,40749,12138,2,3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1201.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3341,5481,40749,12138,2,3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1506.05,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3342,5481,40749,12138,2,3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1589.75,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3343,5481,40749,12138,2,3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',460.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3344,5481,40749,12138,2,3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',245.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3345,5481,40749,12138,2,3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',717.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL);
INSERT INTO `balance_libro` VALUES (3346,5481,40749,12138,2,3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',480.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3347,5481,40749,12138,2,3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',160.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3348,5481,40749,12138,2,3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',405.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3349,5481,40749,12138,2,3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',130.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3350,5481,40749,12138,2,3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',731.90,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3351,5481,40749,12138,2,3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',540.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3352,5481,40749,12138,2,3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',610.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3353,5481,40749,12138,2,3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',165.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3354,5481,40749,12138,2,3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',456.05,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3355,5481,40749,12138,2,3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',495.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3356,5481,40749,12138,2,3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1007.45,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3357,5481,40749,12138,2,3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1009.80,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3358,5481,40749,12138,2,3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',210.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3359,5481,40749,12138,2,3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',312.50,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3360,5481,40749,12138,2,3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',728.30,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3361,5481,40749,12138,2,3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',160.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3362,5481,40749,12138,2,3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1323.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3363,5481,40749,12138,2,3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',176.65,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3364,5481,40749,12138,2,3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',60.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3365,5481,40749,12138,2,3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',245.00,NULL,NULL,1,'2021-08-09 16:24:13','2021-08-09 16:24:13',NULL),(3366,5481,40749,12138,2,3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',3872.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3367,5481,40749,12138,2,3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',1519.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3368,5481,40749,12138,2,3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',580.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3369,5481,40749,12138,2,3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',150.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL);
INSERT INTO `balance_libro` VALUES (3370,5481,40749,12138,2,3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',165.60,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3371,5481,40749,12138,2,3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',840.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3372,5481,40749,12138,2,3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',355.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3373,5481,40749,12138,2,3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1195.60,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3374,5481,40749,12138,2,3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',145.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3375,5481,40749,12138,2,3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',910.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3376,5481,40749,12138,2,3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1774.40,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3377,5481,40749,12138,2,3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',279.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3378,5481,40749,12138,2,3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',460.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3379,5481,40749,12138,2,3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',735.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3380,5481,40749,12138,2,3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',680.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3381,5481,40749,12138,2,3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',340.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3382,5481,40749,12138,2,3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',240.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3383,5481,40749,12138,2,3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',50.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3384,5481,40749,12138,2,3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',180.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3385,5481,40749,12138,2,3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',140.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3386,5481,40749,12138,2,3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',140.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3387,5481,40749,12138,2,3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',150.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3388,5481,40749,12138,2,3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',71.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3389,5481,40749,12138,2,3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',185.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3390,5481,40749,12138,2,3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1259.75,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3391,5481,40749,12138,2,3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1956.55,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3392,5481,40749,12138,2,3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',115.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3393,5481,40749,12138,2,3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',315.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL);
INSERT INTO `balance_libro` VALUES (3394,5481,40749,12138,2,3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',370.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3395,5481,40749,12138,2,3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',699.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3396,5481,40749,12138,2,3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',225.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3397,5481,40749,12138,2,3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',450.00,NULL,NULL,1,'2021-08-09 16:24:14','2021-08-09 16:24:14',NULL),(3398,5481,40749,12138,2,3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1762.65,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3399,5481,40749,12138,2,3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1268.25,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3400,5481,40749,12138,2,3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',870.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3401,5481,40749,12138,2,3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',520.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3402,5481,40749,12138,2,3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',511.20,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3403,5481,40749,12138,2,3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1200.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3404,5481,40749,12138,2,3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1105.90,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3405,5481,40749,12138,2,3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1910.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3406,5481,40749,12138,2,3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',180.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3407,5481,40749,12138,2,3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',178.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3408,5481,40749,12138,2,3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',229.20,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3409,5481,40749,12138,2,3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',952.70,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3410,5481,40749,12138,2,3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',100.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3411,5481,40749,12138,2,3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',90.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3412,5481,40749,12138,2,3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',100.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3413,5481,40749,12138,2,3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',745.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3414,5481,40749,12138,2,3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',300.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3415,5481,40749,12138,2,3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',220.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3416,5481,40749,12138,2,3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',250.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3417,5481,40749,12138,2,3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',337.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL);
INSERT INTO `balance_libro` VALUES (3418,5481,40749,12138,2,3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',45.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3419,5481,40749,12138,2,3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',130.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3420,5481,40749,12138,2,3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',125.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3421,5481,40749,12138,2,3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',601.80,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3422,5481,40749,12138,2,3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',2486.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3423,5481,40749,12138,2,3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',200.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3424,5481,40749,12138,2,3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1003.50,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3425,5481,40749,12138,2,3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',70.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3426,5481,40749,12138,2,3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',110.00,NULL,NULL,1,'2021-08-09 16:24:15','2021-08-09 16:24:15',NULL),(3427,5481,40749,12138,2,3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',505.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3428,5481,40749,12138,2,3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1993.50,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3429,5481,40749,12138,2,3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1124.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3430,5481,40749,12138,2,3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',221.60,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3431,5481,40749,12138,2,3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',385.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3432,5481,40749,12138,2,3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1659.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3433,5481,40749,12138,2,3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',436.45,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3434,5481,40749,12138,2,3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1060.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3435,5481,40749,12138,2,3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',276.20,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3436,5481,40749,12138,2,3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',190.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3437,5481,40749,12138,2,3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',560.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3438,5481,40749,12138,2,3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',247.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3439,5481,40749,12138,2,3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',511.65,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3440,5481,40749,12138,2,3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',420.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3441,5481,40749,12138,2,3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1426.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL);
INSERT INTO `balance_libro` VALUES (3442,5481,40749,12138,2,3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1250.50,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3443,5481,40749,12138,2,3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',290.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3444,5481,40749,12138,2,3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',110.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3445,5481,40749,12138,2,3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',85.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3446,5481,40749,12138,2,3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1183.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3447,5481,40749,12138,2,3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',479.95,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3448,5481,40749,12138,2,3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',95.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3449,5481,40749,12138,2,3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',500.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3450,5481,40749,12138,2,3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',283.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3451,5481,40749,12138,2,3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',80.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3452,5481,40749,12138,2,3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',451.15,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3453,5481,40749,12138,2,3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',420.00,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3454,5481,40749,12138,2,3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',3530.50,NULL,NULL,1,'2021-08-09 16:24:16','2021-08-09 16:24:16',NULL),(3455,5481,40749,12138,2,3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',3465.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3456,5481,40749,12138,2,3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',325.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3457,5481,40749,12138,2,3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1590.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3458,5481,40749,12138,2,3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',740.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3459,5481,40749,12138,2,3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',346.30,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3460,5481,40749,12138,2,3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',845.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3461,5481,40749,12138,2,3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1200.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3462,5481,40749,12138,2,3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',460.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3463,5481,40749,12138,2,3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',300.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3464,5481,40749,12138,2,3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',110.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3465,5481,40749,12138,2,3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',90.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL);
INSERT INTO `balance_libro` VALUES (3466,5481,40749,12138,2,3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',340.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3467,5481,40749,12138,2,3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',493.90,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3468,5481,40749,12138,2,3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1750.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3469,5481,40749,12138,2,3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',160.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3470,5481,40749,12138,2,3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',930.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3471,5481,40749,12138,2,3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',2442.60,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3472,5481,40749,12138,2,3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',420.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3473,5481,40749,12138,2,3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',470.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3474,5481,40749,12138,2,3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',495.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3475,5481,40749,12138,2,3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',50.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3476,5481,40749,12138,2,3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',695.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3477,5481,40749,12138,2,3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',148.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3478,5481,40749,12138,2,3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',796.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3479,5481,40749,12138,2,3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2575.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3480,5481,40749,12138,2,3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',161.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3481,5481,40749,12138,2,3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',315.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3482,5481,40749,12138,2,3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1592.00,NULL,NULL,1,'2021-08-09 16:24:17','2021-08-09 16:24:17',NULL),(3483,5481,40749,12138,2,3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',380.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3484,5481,40749,12138,2,3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',540.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3485,5481,40749,12138,2,3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',100.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3486,5481,40749,12138,2,3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',300.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3487,5481,40749,12138,2,3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',136.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3488,5481,40749,12138,2,3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',90.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3489,5481,40749,12138,2,3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1913.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL);
INSERT INTO `balance_libro` VALUES (3490,5481,40749,12138,2,3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',80.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3491,5481,40749,12138,2,3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',570.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3492,5481,40749,12138,2,3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',420.50,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3493,5481,40749,12138,2,3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1198.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3494,5481,40749,12138,2,3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',110.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3495,5481,40749,12138,2,3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',328.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3496,5481,40749,12138,2,3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',535.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3497,5481,40749,12138,2,3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',140.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3498,5481,40749,12138,2,3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1170.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3499,5481,40749,12138,2,3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',395.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3500,5481,40749,12138,2,3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',696.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3501,5481,40749,12138,2,3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',560.60,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3502,5481,40749,12138,2,3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',640.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3503,5481,40749,12138,2,3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',230.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3504,5481,40749,12138,2,3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',40.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3505,5481,40749,12138,2,3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',357.60,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3506,5481,40749,12138,2,3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',880.25,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3507,5481,40749,12138,2,3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',377.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3508,5481,40749,12138,2,3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',140.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3509,5481,40749,12138,2,3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1764.35,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3510,5481,40749,12138,2,3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',429.25,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3511,5481,40749,12138,2,3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',220.00,NULL,NULL,1,'2021-08-09 16:24:18','2021-08-09 16:24:18',NULL),(3512,5481,40749,12138,2,3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1303.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3513,5481,40749,12138,2,3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',440.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL);
INSERT INTO `balance_libro` VALUES (3514,5481,40749,12138,2,3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',120.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3515,5481,40749,12138,2,3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1330.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3516,5481,40749,12138,2,3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',377.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3517,5481,40749,12138,2,3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',280.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3518,5481,40749,12138,2,3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',700.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3519,5481,40749,12138,2,3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1650.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3520,5481,40749,12138,2,3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',129.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3521,5481,40749,12138,2,3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1098.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3522,5481,40749,12138,2,3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',528.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3523,5481,40749,12138,2,3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',295.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3524,5481,40749,12138,2,3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',570.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3525,5481,40749,12138,2,3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',300.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3526,5481,40749,12138,2,3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',195.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3527,5481,40749,12138,2,3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',600.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3528,5481,40749,12138,2,3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',964.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3529,5481,40749,12138,2,3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',280.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3530,5481,40749,12138,2,3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',658.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3531,5481,40749,12138,2,3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',552.20,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3532,5481,40749,12138,2,3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',495.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3533,5481,40749,12138,2,3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',468.75,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3534,5481,40749,12138,2,3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',150.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3535,5481,40749,12138,2,3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',365.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3536,5481,40749,12138,2,3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',180.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3537,5481,40749,12138,2,3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1760.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL);
INSERT INTO `balance_libro` VALUES (3538,5481,40749,12138,2,3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',460.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3539,5481,40749,12138,2,3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',866.75,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3540,5481,40749,12138,2,3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',600.00,NULL,NULL,1,'2021-08-09 16:24:19','2021-08-09 16:24:19',NULL),(3541,5481,40749,12138,2,3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1248.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3542,5481,40749,12138,2,3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1197.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3543,5481,40749,12138,2,3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',130.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3544,5481,40749,12138,2,3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1967.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3545,5481,40749,12138,2,3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',469.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3546,5481,40749,12138,2,3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',180.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3547,5481,40749,12138,2,3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',499.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3548,5481,40749,12138,2,3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',517.70,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3549,5481,40749,12138,2,3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3245.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3550,5481,40749,12138,2,3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',101.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3551,5481,40749,12138,2,3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',188.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3552,5481,40749,12138,2,3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',150.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3553,5481,40749,12138,2,3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',446.30,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3554,5481,40749,12138,2,3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',803.05,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3555,5481,40749,12138,2,3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1658.65,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3556,5481,40749,12138,2,3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',255.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3557,5481,40749,12138,2,3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1154.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3558,5481,40749,12138,2,3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',570.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3559,5481,40749,12138,2,3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2319.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3560,5481,40749,12138,2,3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',140.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3561,5481,40749,12138,2,3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',510.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL);
INSERT INTO `balance_libro` VALUES (3562,5481,40749,12138,2,3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1108.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3563,5481,40749,12138,2,3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',367.75,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3564,5481,40749,12138,2,3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',90.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3565,5481,40749,12138,2,3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',135.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3566,5481,40749,12138,2,3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',320.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3567,5481,40749,12138,2,3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',315.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3568,5481,40749,12138,2,3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',110.00,NULL,NULL,1,'2021-08-09 16:24:20','2021-08-09 16:24:20',NULL),(3569,5481,40749,12138,2,3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',600.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3570,5481,40749,12138,2,3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',198.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3571,5481,40749,12138,2,3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1364.50,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3572,5481,40749,12138,2,3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2290.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3573,5481,40749,12138,2,3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',500.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3574,5481,40749,12138,2,3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1490.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3575,5481,40749,12138,2,3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',198.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3576,5481,40749,12138,2,3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',250.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3577,5481,40749,12138,2,3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2671.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3578,5481,40749,12138,2,3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',2709.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3579,5481,40749,12138,2,3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',130.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3580,5481,40749,12138,2,3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',504.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3581,5481,40749,12138,2,3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',866.70,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3582,5481,40749,12138,2,3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',460.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3583,5481,40749,12138,2,3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1961.80,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3584,5481,40749,12138,2,3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',640.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3585,5481,40749,12138,2,3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',543.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL);
INSERT INTO `balance_libro` VALUES (3586,5481,40749,12138,2,3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',780.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3587,5481,40749,12138,2,3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',440.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3588,5481,40749,12138,2,3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',230.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3589,5481,40749,12138,2,3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',498.10,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3590,5481,40749,12138,2,3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',770.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3591,5481,40749,12138,2,3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',80.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3592,5481,40749,12138,2,3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',2136.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3593,5481,40749,12138,2,3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1671.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3594,5481,40749,12138,2,3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1358.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3595,5481,40749,12138,2,3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',188.10,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3596,5481,40749,12138,2,3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',85.00,NULL,NULL,1,'2021-08-09 16:24:21','2021-08-09 16:24:21',NULL),(3597,5481,40749,12138,2,3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',219.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3598,5481,40749,12138,2,3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',536.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3599,5481,40749,12138,2,3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',580.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3600,5481,40749,12138,2,3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',60.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3601,5481,40749,12138,2,3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',160.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3602,5481,40749,12138,2,3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',187.20,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3603,5481,40749,12138,2,3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1089.50,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3604,5481,40749,12138,2,3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',150.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3605,5481,40749,12138,2,3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',225.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3606,5481,40749,12138,2,3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1452.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3607,5481,40749,12138,2,3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',70.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3608,5481,40749,12138,2,3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',340.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3609,5481,40749,12138,2,3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',405.65,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL);
INSERT INTO `balance_libro` VALUES (3610,5481,40749,12138,2,3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',900.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3611,5481,40749,12138,2,3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',115.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3612,5481,40749,12138,2,3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',307.80,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3613,5481,40749,12138,2,3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',176.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3614,5481,40749,12138,2,3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',210.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3615,5481,40749,12138,2,3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1280.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3616,5481,40749,12138,2,3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',145.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3617,5481,40749,12138,2,3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',50.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3618,5481,40749,12138,2,3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',429.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3619,5481,40749,12138,2,3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',782.50,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3620,5481,40749,12138,2,3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',270.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3621,5481,40749,12138,2,3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',330.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3622,5481,40749,12138,2,3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',260.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3623,5481,40749,12138,2,3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',564.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3624,5481,40749,12138,2,3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',623.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3625,5481,40749,12138,2,3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',250.00,NULL,NULL,1,'2021-08-09 16:24:22','2021-08-09 16:24:22',NULL),(3626,5481,40749,12138,2,3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',90.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3627,5481,40749,12138,2,3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',158.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3628,5481,40749,12138,2,3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',3783.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3629,5481,40749,12138,2,3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1356.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3630,5481,40749,12138,2,3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1029.10,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3631,5481,40749,12138,2,3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',590.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3632,5481,40749,12138,2,3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',310.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3633,5481,40749,12138,2,3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',320.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL);
INSERT INTO `balance_libro` VALUES (3634,5481,40749,12138,2,3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',902.75,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3635,5481,40749,12138,2,3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',485.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3636,5481,40749,12138,2,3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',659.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3637,5481,40749,12138,2,3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',570.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3638,5481,40749,12138,2,3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',699.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3639,5481,40749,12138,2,3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',425.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3640,5481,40749,12138,2,3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',630.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3641,5481,40749,12138,2,3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',477.75,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3642,5481,40749,12138,2,3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',198.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3643,5481,40749,12138,2,3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',298.35,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3644,5481,40749,12138,2,3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',370.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3645,5481,40749,12138,2,3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',406.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3646,5481,40749,12138,2,3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1067.05,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3647,5481,40749,12138,2,3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',267.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3648,5481,40749,12138,2,3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1005.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3649,5481,40749,12138,2,3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',195.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3650,5481,40749,12138,2,3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',989.75,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3651,5481,40749,12138,2,3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',180.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3652,5481,40749,12138,2,3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1347.20,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3653,5481,40749,12138,2,3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',921.00,NULL,NULL,1,'2021-08-09 16:24:23','2021-08-09 16:24:23',NULL),(3654,5481,40749,12138,2,3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',40.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3655,5481,40749,12138,2,3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',69.50,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3656,5481,40749,12138,2,3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',7624.50,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3657,5481,40749,12138,2,3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',242.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL);
INSERT INTO `balance_libro` VALUES (3658,5481,40749,12138,2,3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',490.50,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3659,5481,40749,12138,2,3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',60.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3660,5481,40749,12138,2,3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',170.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3661,5481,40749,12138,2,3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',670.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3662,5481,40749,12138,2,3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',160.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3663,5481,40749,12138,2,3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',190.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3664,5481,40749,12138,2,3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',907.50,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3665,5481,40749,12138,2,3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',170.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3666,5481,40749,12138,2,3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',190.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3667,5481,40749,12138,2,3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',2911.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3668,5481,40749,12138,2,3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',679.50,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3669,5481,40749,12138,2,3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',65.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3670,5481,40749,12138,2,3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',2572.65,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3671,5481,40749,12138,2,3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',257.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3672,5481,40749,12138,2,3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',60.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3673,5481,40749,12138,2,3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',200.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3674,5481,40749,12138,2,3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',149.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3675,5481,40749,12138,2,3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',295.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3676,5481,40749,12138,2,3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',255.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3677,5481,40749,12138,2,3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',380.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3678,5481,40749,12138,2,3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',520.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3679,5481,40749,12138,2,3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',195.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3680,5481,40749,12138,2,3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',210.00,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL),(3681,5481,40749,12138,2,3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',677.80,NULL,NULL,1,'2021-08-09 16:24:24','2021-08-09 16:24:24',NULL);
INSERT INTO `balance_libro` VALUES (3682,5481,40749,12138,2,3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',100.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3683,5481,40749,12138,2,3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',824.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3684,5481,40749,12138,2,3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',320.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3685,5481,40749,12138,2,3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1235.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3686,5481,40749,12138,2,3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',870.80,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3687,5481,40749,12138,2,3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1477.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3688,5481,40749,12138,2,3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',607.60,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3689,5481,40749,12138,2,3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',65.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3690,5481,40749,12138,2,3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',217.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3691,5481,40749,12138,2,3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',500.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3692,5481,40749,12138,2,3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1200.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3693,5481,40749,12138,2,3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1620.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3694,5481,40749,12138,2,3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',3182.75,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3695,5481,40749,12138,2,3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',654.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3696,5481,40749,12138,2,3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',283.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3697,5481,40749,12138,2,3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',503.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3698,5481,40749,12138,2,3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1230.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3699,5481,40749,12138,2,3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',3154.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3700,5481,40749,12138,2,3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',305.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3701,5481,40749,12138,2,3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',480.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3702,5481,40749,12138,2,3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',650.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3703,5481,40749,12138,2,3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',465.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3704,5481,40749,12138,2,3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',287.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3705,5481,40749,12138,2,3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',255.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL);
INSERT INTO `balance_libro` VALUES (3706,5481,40749,12138,2,3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',335.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3707,5481,40749,12138,2,3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',330.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3708,5481,40749,12138,2,3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',484.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3709,5481,40749,12138,2,3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',310.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3710,5481,40749,12138,2,3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',440.00,NULL,NULL,1,'2021-08-09 16:24:25','2021-08-09 16:24:25',NULL),(3711,5481,40749,12138,2,3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',610.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3712,5481,40749,12138,2,3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',408.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3713,5481,40749,12138,2,3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',430.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3714,5481,40749,12138,2,3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1229.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3715,5481,40749,12138,2,3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',160.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3716,5481,40749,12138,2,3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',115.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3717,5481,40749,12138,2,3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',220.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3718,5481,40749,12138,2,3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',355.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3719,5481,40749,12138,2,3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',390.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3720,5481,40749,12138,2,3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',730.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3721,5481,40749,12138,2,3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',905.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3722,5481,40749,12138,2,3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',200.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3723,5481,40749,12138,2,3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1159.20,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3724,5481,40749,12138,2,3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',60.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3725,5481,40749,12138,2,3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',330.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3726,5481,40749,12138,2,3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1008.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3727,5481,40749,12138,2,3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',312.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3728,5481,40749,12138,2,3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1325.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3729,5481,40749,12138,2,3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',280.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL);
INSERT INTO `balance_libro` VALUES (3730,5481,40749,12138,2,3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',390.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3731,5481,40749,12138,2,3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',250.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3732,5481,40749,12138,2,3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',850.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3733,5481,40749,12138,2,3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',260.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3734,5481,40749,12138,2,3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',190.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3735,5481,40749,12138,2,3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',510.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3736,5481,40749,12138,2,3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',505.30,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3737,5481,40749,12138,2,3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',130.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3738,5481,40749,12138,2,3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',170.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3739,5481,40749,12138,2,3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',270.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3740,5481,40749,12138,2,3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',450.00,NULL,NULL,1,'2021-08-09 16:24:26','2021-08-09 16:24:26',NULL),(3741,5481,40749,12138,2,3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',100.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3742,5481,40749,12138,2,3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',900.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3743,5481,40749,12138,2,3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',280.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3744,5481,40749,12138,2,3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',518.50,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3745,5481,40749,12138,2,3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',408.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3746,5481,40749,12138,2,3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',860.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3747,5481,40749,12138,2,3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',340.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3748,5481,40749,12138,2,3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',698.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3749,5481,40749,12138,2,3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1330.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3750,5481,40749,12138,2,3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',200.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3751,5481,40749,12138,2,3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',74.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3752,5481,40749,12138,2,3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',701.85,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3753,5481,40749,12138,2,3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',120.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL);
INSERT INTO `balance_libro` VALUES (3754,5481,40749,12138,2,3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',190.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3755,5481,40749,12138,2,3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',566.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3756,5481,40749,12138,2,3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',230.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3757,5481,40749,12138,2,3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',310.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3758,5481,40749,12138,2,3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',230.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3759,5481,40749,12138,2,3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',110.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3760,5481,40749,12138,2,3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',210.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3761,5481,40749,12138,2,3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',150.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3762,5481,40749,12138,2,3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',300.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3763,5481,40749,12138,2,3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',780.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3764,5481,40749,12138,2,3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',200.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3765,5481,40749,12138,2,3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',290.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3766,5481,40749,12138,2,3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',850.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3767,5481,40749,12138,2,3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',670.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3768,5481,40749,12138,2,3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',630.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3769,5481,40749,12138,2,3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',335.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3770,5481,40749,12138,2,3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',718.00,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3771,5481,40749,12138,2,3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',611.10,NULL,NULL,1,'2021-08-09 16:24:27','2021-08-09 16:24:27',NULL),(3772,5481,40749,12138,2,3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',45.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3773,5481,40749,12138,2,3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',598.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3774,5481,40749,12138,2,3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4906.10,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3775,5481,40749,12138,2,3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',888.35,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3776,5481,40749,12138,2,3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',520.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3777,5481,40749,12138,2,3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',880.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL);
INSERT INTO `balance_libro` VALUES (3778,5481,40749,12138,2,3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1357.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3779,5481,40749,12138,2,3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',50.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3780,5481,40749,12138,2,3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',643.25,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3781,5481,40749,12138,2,3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1151.45,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3782,5481,40749,12138,2,3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',609.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3783,5481,40749,12138,2,3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',95.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3784,5481,40749,12138,2,3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',410.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3785,5481,40749,12138,2,3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',310.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3786,5481,40749,12138,2,3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',150.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3787,5481,40749,12138,2,3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1285.40,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3788,5481,40749,12138,2,3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',900.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3789,5481,40749,12138,2,3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',700.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3790,5481,40749,12138,2,3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2124.75,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3791,5481,40749,12138,2,3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',440.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3792,5481,40749,12138,2,3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',50.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3793,5481,40749,12138,2,3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',400.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3794,5481,40749,12138,2,3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',900.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3795,5481,40749,12138,2,3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1463.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3796,5481,40749,12138,2,3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2420.95,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3797,5481,40749,12138,2,3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1530.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3798,5481,40749,12138,2,3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',618.90,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3799,5481,40749,12138,2,3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',690.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3800,5481,40749,12138,2,3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1940.00,NULL,NULL,1,'2021-08-09 16:24:28','2021-08-09 16:24:28',NULL),(3801,5481,40749,12138,2,3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1760.80,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL);
INSERT INTO `balance_libro` VALUES (3802,5481,40749,12138,2,3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',310.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3803,5481,40749,12138,2,3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1460.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3804,5481,40749,12138,2,3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',918.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3805,5481,40749,12138,2,3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',260.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3806,5481,40749,12138,2,3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',990.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3807,5481,40749,12138,2,3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3890.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3808,5481,40749,12138,2,3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',170.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3809,5481,40749,12138,2,3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',60.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3810,5481,40749,12138,2,3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',934.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3811,5481,40749,12138,2,3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',702.50,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3812,5481,40749,12138,2,3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',660.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3813,5481,40749,12138,2,3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',944.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3814,5481,40749,12138,2,3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',845.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3815,5481,40749,12138,2,3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',550.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3816,5481,40749,12138,2,3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1435.55,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3817,5481,40749,12138,2,3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',138.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3818,5481,40749,12138,2,3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',305.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3819,5481,40749,12138,2,3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',340.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3820,5481,40749,12138,2,3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',926.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3821,5481,40749,12138,2,3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',190.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3822,5481,40749,12138,2,3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',390.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3823,5481,40749,12138,2,3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',380.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3824,5481,40749,12138,2,3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',185.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3825,5481,40749,12138,2,3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',624.90,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL);
INSERT INTO `balance_libro` VALUES (3826,5481,40749,12138,2,3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',860.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3827,5481,40749,12138,2,3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1808.50,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3828,5481,40749,12138,2,3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',245.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3829,5481,40749,12138,2,3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',662.75,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3830,5481,40749,12138,2,3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',70.00,NULL,NULL,1,'2021-08-09 16:24:29','2021-08-09 16:24:29',NULL),(3831,5481,40749,12138,2,3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',200.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3832,5481,40749,12138,2,3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1456.50,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3833,5481,40749,12138,2,3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',150.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3834,5481,40749,12138,2,3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',789.60,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3835,5481,40749,12138,2,3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1518.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3836,5481,40749,12138,2,3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',150.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3837,5481,40749,12138,2,3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2531.35,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3838,5481,40749,12138,2,3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2158.50,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3839,5481,40749,12138,2,3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',325.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3840,5481,40749,12138,2,3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',440.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3841,5481,40749,12138,2,3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',285.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3842,5481,40749,12138,2,3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1055.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3843,5481,40749,12138,2,3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',494.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3844,5481,40749,12138,2,3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',6003.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3845,5481,40749,12138,2,3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1010.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3846,5481,40749,12138,2,3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',645.40,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3847,5481,40749,12138,2,3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',260.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3848,5481,40749,12138,2,3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',500.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3849,5481,40749,12138,2,3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',652.25,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL);
INSERT INTO `balance_libro` VALUES (3850,5481,40749,12138,2,3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',690.60,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3851,5481,40749,12138,2,3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',505.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3852,5481,40749,12138,2,3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',385.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3853,5481,40749,12138,2,3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',632.00,NULL,NULL,1,'2021-08-09 16:24:30','2021-08-09 16:24:30',NULL),(3854,5481,40749,12138,2,3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',90.00,NULL,NULL,1,'2021-08-09 16:24:31','2021-08-09 16:24:31',NULL),(3855,5481,40749,12138,2,3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1010.00,NULL,NULL,1,'2021-08-09 16:24:31','2021-08-09 16:24:31',NULL),(3856,5481,40749,12138,2,3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',610.00,NULL,NULL,1,'2021-08-09 16:24:31','2021-08-09 16:24:31',NULL),(3857,5481,40749,12138,2,3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',150.00,NULL,NULL,1,'2021-08-09 16:24:31','2021-08-09 16:24:31',NULL),(3858,5481,40749,12138,2,3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',320.00,NULL,NULL,1,'2021-08-09 16:24:31','2021-08-09 16:24:31',NULL),(3859,5481,40749,12138,2,3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',510.00,NULL,NULL,1,'2021-08-09 16:24:31','2021-08-09 16:24:31',NULL),(3860,5481,40749,12138,2,3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',2063.00,NULL,NULL,1,'2021-08-09 16:24:31','2021-08-09 16:24:31',NULL),(3861,5481,40749,12138,2,3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',560.00,NULL,NULL,1,'2021-08-09 16:24:31','2021-08-09 16:24:31',NULL),(3862,5481,40749,12138,2,3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',328.00,NULL,NULL,1,'2021-08-09 16:24:31','2021-08-09 16:24:31',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,5481,1,40720,1533,2,96,2,56115.69,NULL,'2021-08-08 22:09:27','2021-08-08 22:58:45','2021-08-08 22:58:45'),(2,5481,1,40720,1533,2,67,2,11784.31,NULL,'2021-08-08 22:09:27','2021-08-08 22:58:45','2021-08-08 22:58:45'),(3,5481,1,40720,1533,2,13,1,67900.00,NULL,'2021-08-08 22:09:27','2021-08-08 22:58:45','2021-08-08 22:58:45'),(4,5481,2,40720,1533,2,96,2,11798.35,NULL,'2021-08-08 22:09:27','2021-08-08 22:58:55','2021-08-08 22:58:55'),(5,5481,2,40720,1533,2,67,2,2477.65,NULL,'2021-08-08 22:09:27','2021-08-08 22:58:55','2021-08-08 22:58:55'),(6,5481,2,40720,1533,2,13,1,14276.00,NULL,'2021-08-08 22:09:27','2021-08-08 22:58:55','2021-08-08 22:58:55'),(7,5481,3,40720,1533,2,96,2,40723.97,NULL,'2021-08-08 22:09:27','2021-08-08 22:58:59','2021-08-08 22:58:59'),(8,5481,3,40720,1533,2,67,2,8552.03,NULL,'2021-08-08 22:09:27','2021-08-08 22:58:59','2021-08-08 22:58:59'),(9,5481,3,40720,1533,2,13,1,49276.00,NULL,'2021-08-08 22:09:27','2021-08-08 22:58:59','2021-08-08 22:58:59'),(10,5481,4,40720,1533,2,96,1,11798.35,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:02','2021-08-08 22:59:02'),(11,5481,4,40720,1533,2,68,1,2477.65,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:02','2021-08-08 22:59:02'),(12,5481,4,40720,1533,2,13,2,14276.00,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:02','2021-08-08 22:59:02'),(13,5481,5,40720,1533,2,96,2,20714.05,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:48','2021-08-08 23:00:48'),(14,5481,5,40720,1533,2,67,2,4349.95,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:48','2021-08-08 23:00:48'),(15,5481,5,40720,1533,2,13,1,25064.00,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:48','2021-08-08 23:00:48'),(16,5481,6,40720,1533,2,96,2,20714.05,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:13','2021-08-08 23:00:13'),(17,5481,6,40720,1533,2,67,2,4349.95,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:13','2021-08-08 23:00:13'),(18,5481,6,40720,1533,2,13,1,25064.00,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:13','2021-08-08 23:00:13'),(19,5481,7,40720,1533,2,96,1,20714.05,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:36','2021-08-08 22:59:36'),(20,5481,7,40720,1533,2,68,1,4349.95,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:36','2021-08-08 22:59:36'),(21,5481,7,40720,1533,2,13,2,25064.00,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:36','2021-08-08 22:59:36'),(22,5481,8,40720,1533,2,96,2,34793.39,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:16','2021-08-08 23:00:16'),(23,5481,8,40720,1533,2,67,2,7306.61,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:16','2021-08-08 23:00:16'),(24,5481,8,40720,1533,2,13,1,42100.00,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:16','2021-08-08 23:00:16'),(25,5481,9,40720,1533,2,96,2,2400.00,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:19','2021-08-08 23:00:19'),(26,5481,9,40720,1533,2,67,2,504.00,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:19','2021-08-08 23:00:19'),(27,5481,9,40720,1533,2,13,1,2904.00,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:19','2021-08-08 23:00:19'),(28,5481,10,40720,1533,2,96,2,9090.91,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:23','2021-08-08 23:00:23'),(29,5481,10,40720,1533,2,67,2,1909.09,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:23','2021-08-08 23:00:23'),(30,5481,10,40720,1533,2,13,1,11000.00,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:23','2021-08-08 23:00:23'),(31,5481,11,40720,1533,2,96,2,16528.93,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:26','2021-08-08 23:00:26'),(32,5481,11,40720,1533,2,67,2,3471.08,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:26','2021-08-08 23:00:26'),(33,5481,11,40720,1533,2,13,1,20000.01,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:26','2021-08-08 23:00:26'),(34,5481,12,40720,1533,2,96,2,8160.00,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:16','2021-08-08 22:59:16'),(35,5481,12,40720,1533,2,67,2,1713.60,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:16','2021-08-08 22:59:16'),(36,5481,12,40720,1533,2,13,1,9873.60,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:16','2021-08-08 22:59:16');
INSERT INTO `balance_libro_details` VALUES (37,5481,13,40720,1533,2,96,2,9163.64,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:19','2021-08-08 22:59:19'),(38,5481,13,40720,1533,2,67,2,1924.36,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:19','2021-08-08 22:59:19'),(39,5481,13,40720,1533,2,13,1,11088.00,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:19','2021-08-08 22:59:19'),(40,5481,14,40720,1533,2,96,2,13750.00,NULL,'2021-08-08 22:09:27','2021-08-08 22:58:28','2021-08-08 22:58:28'),(41,5481,14,40720,1533,2,67,2,2887.50,NULL,'2021-08-08 22:09:27','2021-08-08 22:58:28','2021-08-08 22:58:28'),(42,5481,14,40720,1533,2,13,1,16637.50,NULL,'2021-08-08 22:09:27','2021-08-08 22:58:28','2021-08-08 22:58:28'),(43,5481,15,40720,1533,2,96,2,3719.01,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:22','2021-08-08 22:59:22'),(44,5481,15,40720,1533,2,67,2,780.99,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:22','2021-08-08 22:59:22'),(45,5481,15,40720,1533,2,13,1,4500.00,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:22','2021-08-08 22:59:22'),(46,5481,16,40720,1533,2,96,2,10743.80,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:25','2021-08-08 22:59:25'),(47,5481,16,40720,1533,2,67,2,2256.20,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:25','2021-08-08 22:59:25'),(48,5481,16,40720,1533,2,13,1,13000.00,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:25','2021-08-08 22:59:25'),(49,5481,17,40720,1533,2,96,2,7800.00,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:27','2021-08-08 22:59:27'),(50,5481,17,40720,1533,2,67,2,1638.00,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:27','2021-08-08 22:59:27'),(51,5481,17,40720,1533,2,13,1,9438.00,NULL,'2021-08-08 22:09:27','2021-08-08 22:59:27','2021-08-08 22:59:27'),(52,5481,18,40720,1533,2,96,2,33057.85,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:29','2021-08-08 23:00:29'),(53,5481,18,40720,1533,2,67,2,6942.15,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:29','2021-08-08 23:00:29'),(54,5481,18,40720,1533,2,13,1,40000.00,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:29','2021-08-08 23:00:29'),(55,5481,19,40720,1533,2,96,2,16528.93,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:44','2021-08-08 23:00:44'),(56,5481,19,40720,1533,2,67,2,3471.08,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:44','2021-08-08 23:00:44'),(57,5481,19,40720,1533,2,13,1,20000.01,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:44','2021-08-08 23:00:44'),(58,5481,20,40720,1533,2,96,2,8677.69,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:42','2021-08-08 23:00:42'),(59,5481,20,40720,1533,2,67,2,1822.31,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:42','2021-08-08 23:00:42'),(60,5481,20,40720,1533,2,13,1,10500.00,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:42','2021-08-08 23:00:42'),(61,5481,21,40720,1533,2,96,2,14462.81,NULL,'2021-08-08 22:09:27','2021-08-08 23:00:39','2021-08-08 23:00:39'),(62,5481,21,40720,1533,2,67,2,3037.19,NULL,'2021-08-08 22:09:28','2021-08-08 23:00:39','2021-08-08 23:00:39'),(63,5481,21,40720,1533,2,13,1,17500.00,NULL,'2021-08-08 22:09:28','2021-08-08 23:00:39','2021-08-08 23:00:39'),(64,5481,22,40720,1533,2,96,2,32231.41,NULL,'2021-08-08 22:09:28','2021-08-08 23:00:36','2021-08-08 23:00:36'),(65,5481,22,40720,1533,2,67,2,6768.60,NULL,'2021-08-08 22:09:28','2021-08-08 23:00:36','2021-08-08 23:00:36'),(66,5481,22,40720,1533,2,13,1,39000.01,NULL,'2021-08-08 22:09:28','2021-08-08 23:00:36','2021-08-08 23:00:36'),(67,5481,23,40720,1533,3,217,1,13475.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(68,5481,23,40720,1533,3,68,1,2829.75,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(69,5481,23,40720,1533,3,57,2,16304.75,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(70,5481,24,40720,1533,3,217,1,1219.01,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(71,5481,24,40720,1533,3,68,1,255.99,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(72,5481,24,40720,1533,3,57,2,1475.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20');
INSERT INTO `balance_libro_details` VALUES (73,5481,25,40720,1533,3,250,1,0.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(74,5481,25,40720,1533,3,250,1,13668.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(75,5481,25,40720,1533,3,57,2,13668.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(76,5481,26,40720,1533,3,217,1,7380.13,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(77,5481,26,40720,1533,3,68,1,1549.83,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(78,5481,26,40720,1533,3,57,2,8929.96,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(79,5481,27,40720,1533,3,250,1,0.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(80,5481,27,40720,1533,3,250,1,690.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(81,5481,27,40720,1533,3,57,2,690.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(82,5481,28,40720,1533,3,250,1,0.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(83,5481,28,40720,1533,3,250,1,170.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(84,5481,28,40720,1533,3,57,2,170.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(85,5481,29,40720,1533,3,250,1,0.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(86,5481,29,40720,1533,3,250,1,590.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(87,5481,29,40720,1533,3,57,2,590.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(88,5481,30,40720,1533,3,250,1,0.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(89,5481,30,40720,1533,3,250,1,690.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(90,5481,30,40720,1533,3,57,2,690.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(91,5481,31,40720,1533,3,217,1,593.39,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(92,5481,31,40720,1533,3,68,1,124.61,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(93,5481,31,40720,1533,3,217,1,17.80,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(94,5481,31,40720,1533,3,57,2,735.80,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(95,5481,32,40720,1533,3,217,1,45114.87,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(96,5481,32,40720,1533,3,68,1,9474.12,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(97,5481,32,40720,1533,3,57,2,54588.99,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(98,5481,33,40720,1533,3,217,1,74508.40,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(99,5481,33,40720,1533,3,68,1,10664.17,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(100,5481,33,40720,1533,3,57,2,85172.57,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(101,5481,34,40720,1533,3,217,1,1809.92,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(102,5481,34,40720,1533,3,68,1,380.08,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(103,5481,34,40720,1533,3,57,2,2190.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(104,5481,35,40720,1533,3,217,1,6190.08,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(105,5481,35,40720,1533,3,68,1,1299.92,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(106,5481,35,40720,1533,3,57,2,7490.00,NULL,'2021-08-08 22:12:17','2021-08-08 23:14:20','2021-08-08 23:14:20'),(107,5481,36,40720,1533,2,96,2,56115.69,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(108,5481,36,40720,1533,2,67,2,11784.31,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19');
INSERT INTO `balance_libro_details` VALUES (109,5481,36,40720,1533,2,13,1,67900.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(110,5481,37,40720,1533,2,96,2,11798.35,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(111,5481,37,40720,1533,2,67,2,2477.65,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(112,5481,37,40720,1533,2,13,1,14276.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(113,5481,38,40720,1533,2,96,2,40723.97,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(114,5481,38,40720,1533,2,67,2,8552.03,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(115,5481,38,40720,1533,2,13,1,49276.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(116,5481,39,40720,1533,2,96,1,11798.35,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(117,5481,39,40720,1533,2,68,1,2477.65,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(118,5481,39,40720,1533,2,13,2,14276.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(119,5481,40,40720,1533,2,96,2,20714.05,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(120,5481,40,40720,1533,2,67,2,4349.95,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(121,5481,40,40720,1533,2,13,1,25064.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(122,5481,41,40720,1533,2,96,2,20714.05,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(123,5481,41,40720,1533,2,67,2,4349.95,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(124,5481,41,40720,1533,2,13,1,25064.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(125,5481,42,40720,1533,2,96,1,20714.05,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(126,5481,42,40720,1533,2,68,1,4349.95,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(127,5481,42,40720,1533,2,13,2,25064.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(128,5481,43,40720,1533,2,96,2,34793.39,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(129,5481,43,40720,1533,2,67,2,7306.61,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(130,5481,43,40720,1533,2,13,1,42100.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(131,5481,44,40720,1533,2,96,2,2400.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(132,5481,44,40720,1533,2,67,2,504.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(133,5481,44,40720,1533,2,13,1,2904.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(134,5481,45,40720,1533,2,96,2,9090.91,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(135,5481,45,40720,1533,2,67,2,1909.09,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(136,5481,45,40720,1533,2,13,1,11000.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(137,5481,46,40720,1533,2,96,2,16528.93,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(138,5481,46,40720,1533,2,67,2,3471.08,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(139,5481,46,40720,1533,2,13,1,20000.01,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(140,5481,47,40720,1533,2,96,2,8160.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(141,5481,47,40720,1533,2,67,2,1713.60,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(142,5481,47,40720,1533,2,13,1,9873.60,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(143,5481,48,40720,1533,2,96,2,9163.64,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19');
INSERT INTO `balance_libro_details` VALUES (144,5481,48,40720,1533,2,67,2,1924.36,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(145,5481,48,40720,1533,2,13,1,11088.00,NULL,'2021-08-08 23:24:17','2021-08-09 11:02:19','2021-08-09 11:02:19'),(146,5481,49,40720,1533,2,96,2,13750.00,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(147,5481,49,40720,1533,2,67,2,2887.50,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(148,5481,49,40720,1533,2,13,1,16637.50,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(149,5481,50,40720,1533,2,96,2,3719.01,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(150,5481,50,40720,1533,2,67,2,780.99,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(151,5481,50,40720,1533,2,13,1,4500.00,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(152,5481,51,40720,1533,2,96,2,10743.80,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(153,5481,51,40720,1533,2,67,2,2256.20,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(154,5481,51,40720,1533,2,13,1,13000.00,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(155,5481,52,40720,1533,2,96,2,7800.00,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(156,5481,52,40720,1533,2,67,2,1638.00,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(157,5481,52,40720,1533,2,13,1,9438.00,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(158,5481,53,40720,1533,2,96,2,33057.85,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(159,5481,53,40720,1533,2,67,2,6942.15,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(160,5481,53,40720,1533,2,13,1,40000.00,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(161,5481,54,40720,1533,2,96,2,16528.93,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(162,5481,54,40720,1533,2,67,2,3471.08,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(163,5481,54,40720,1533,2,13,1,20000.01,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(164,5481,55,40720,1533,2,96,2,8677.69,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(165,5481,55,40720,1533,2,67,2,1822.31,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(166,5481,55,40720,1533,2,13,1,10500.00,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(167,5481,56,40720,1533,2,96,2,14462.81,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(168,5481,56,40720,1533,2,67,2,3037.19,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(169,5481,56,40720,1533,2,13,1,17500.00,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(170,5481,57,40720,1533,2,96,2,32231.41,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(171,5481,57,40720,1533,2,67,2,6768.60,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(172,5481,57,40720,1533,2,13,1,39000.01,NULL,'2021-08-08 23:24:18','2021-08-09 11:02:19','2021-08-09 11:02:19'),(173,5481,58,40720,1533,15,67,1,77946.64,NULL,'2021-08-08 23:27:43','2021-08-09 11:02:07','2021-08-09 11:02:07'),(174,5481,58,40720,1533,15,68,2,6827.60,NULL,'2021-08-08 23:27:43','2021-08-09 11:02:07','2021-08-09 11:02:07'),(175,5481,58,40720,1533,15,74,2,71119.04,NULL,'2021-08-08 23:27:43','2021-08-09 11:02:07','2021-08-09 11:02:07'),(176,5481,59,40720,1533,2,96,2,56115.69,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(177,5481,59,40720,1533,2,67,2,11784.31,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(178,5481,59,40720,1533,2,13,1,67900.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(179,5481,60,40720,1533,2,96,2,11798.35,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL);
INSERT INTO `balance_libro_details` VALUES (180,5481,60,40720,1533,2,67,2,2477.65,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(181,5481,60,40720,1533,2,13,1,14276.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(182,5481,61,40720,1533,2,96,2,40723.97,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(183,5481,61,40720,1533,2,67,2,8552.03,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(184,5481,61,40720,1533,2,13,1,49276.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(185,5481,62,40720,1533,2,96,1,11798.35,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(186,5481,62,40720,1533,2,68,1,2477.65,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(187,5481,62,40720,1533,2,13,2,14276.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(188,5481,63,40720,1533,2,96,2,20714.05,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(189,5481,63,40720,1533,2,67,2,4349.95,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(190,5481,63,40720,1533,2,13,1,25064.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(191,5481,64,40720,1533,2,96,2,20714.05,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(192,5481,64,40720,1533,2,67,2,4349.95,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(193,5481,64,40720,1533,2,13,1,25064.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(194,5481,65,40720,1533,2,96,1,20714.05,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(195,5481,65,40720,1533,2,68,1,4349.95,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(196,5481,65,40720,1533,2,13,2,25064.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(197,5481,66,40720,1533,2,96,2,34793.39,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(198,5481,66,40720,1533,2,67,2,7306.61,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(199,5481,66,40720,1533,2,13,1,42100.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(200,5481,67,40720,1533,2,96,2,2400.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(201,5481,67,40720,1533,2,67,2,504.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(202,5481,67,40720,1533,2,13,1,2904.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(203,5481,68,40720,1533,2,96,2,9090.91,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(204,5481,68,40720,1533,2,67,2,1909.09,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(205,5481,68,40720,1533,2,13,1,11000.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(206,5481,69,40720,1533,2,96,2,16528.93,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(207,5481,69,40720,1533,2,67,2,3471.08,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(208,5481,69,40720,1533,2,13,1,20000.01,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(209,5481,70,40720,1533,2,96,2,8160.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(210,5481,70,40720,1533,2,67,2,1713.60,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(211,5481,70,40720,1533,2,13,1,9873.60,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(212,5481,71,40720,1533,2,96,2,9163.64,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(213,5481,71,40720,1533,2,67,2,1924.36,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(214,5481,71,40720,1533,2,13,1,11088.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(215,5481,72,40720,1533,2,96,2,13750.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(216,5481,72,40720,1533,2,67,2,2887.50,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(217,5481,72,40720,1533,2,13,1,16637.50,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(218,5481,73,40720,1533,2,96,2,3719.01,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(219,5481,73,40720,1533,2,67,2,780.99,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(220,5481,73,40720,1533,2,13,1,4500.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(221,5481,74,40720,1533,2,96,2,10743.80,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL);
INSERT INTO `balance_libro_details` VALUES (222,5481,74,40720,1533,2,67,2,2256.20,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(223,5481,74,40720,1533,2,13,1,13000.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(224,5481,75,40720,1533,2,96,2,7800.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(225,5481,75,40720,1533,2,67,2,1638.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(226,5481,75,40720,1533,2,13,1,9438.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(227,5481,76,40720,1533,2,96,2,33057.85,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(228,5481,76,40720,1533,2,67,2,6942.15,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(229,5481,76,40720,1533,2,13,1,40000.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(230,5481,77,40720,1533,2,96,2,16528.93,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(231,5481,77,40720,1533,2,67,2,3471.08,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(232,5481,77,40720,1533,2,13,1,20000.01,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(233,5481,78,40720,1533,2,96,2,8677.69,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(234,5481,78,40720,1533,2,67,2,1822.31,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(235,5481,78,40720,1533,2,13,1,10500.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(236,5481,79,40720,1533,2,96,2,14462.81,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(237,5481,79,40720,1533,2,67,2,3037.19,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(238,5481,79,40720,1533,2,13,1,17500.00,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(239,5481,80,40720,1533,2,96,2,32231.41,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(240,5481,80,40720,1533,2,67,2,6768.60,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(241,5481,80,40720,1533,2,13,1,39000.01,NULL,'2021-08-09 11:04:49','2021-08-09 11:04:49',NULL),(242,5481,81,40720,1533,3,217,1,13475.00,NULL,'2021-08-09 11:04:58','2021-08-09 19:29:08','2021-08-09 19:29:08'),(243,5481,81,40720,1533,3,68,1,2829.75,NULL,'2021-08-09 11:04:58','2021-08-09 19:29:08','2021-08-09 19:29:08'),(244,5481,81,40720,1533,3,57,2,16304.75,NULL,'2021-08-09 11:04:58','2021-08-09 19:29:08','2021-08-09 19:29:08'),(245,5481,82,40720,1533,3,217,1,1219.01,NULL,'2021-08-09 11:04:58','2021-08-09 19:29:08','2021-08-09 19:29:08'),(246,5481,82,40720,1533,3,68,1,255.99,NULL,'2021-08-09 11:04:58','2021-08-09 19:29:08','2021-08-09 19:29:08'),(247,5481,82,40720,1533,3,57,2,1475.00,NULL,'2021-08-09 11:04:58','2021-08-09 19:29:08','2021-08-09 19:29:08'),(248,5481,83,40720,1533,3,250,1,0.00,NULL,'2021-08-09 11:04:58','2021-08-09 19:29:09','2021-08-09 19:29:09'),(249,5481,83,40720,1533,3,250,1,13668.00,NULL,'2021-08-09 11:04:58','2021-08-09 19:29:09','2021-08-09 19:29:09'),(250,5481,83,40720,1533,3,57,2,13668.00,NULL,'2021-08-09 11:04:58','2021-08-09 19:29:09','2021-08-09 19:29:09'),(251,5481,84,40720,1533,3,217,1,7380.13,NULL,'2021-08-09 11:04:58','2021-08-09 19:29:09','2021-08-09 19:29:09'),(252,5481,84,40720,1533,3,68,1,1549.83,NULL,'2021-08-09 11:04:58','2021-08-09 19:29:09','2021-08-09 19:29:09'),(253,5481,84,40720,1533,3,57,2,8929.96,NULL,'2021-08-09 11:04:58','2021-08-09 19:29:09','2021-08-09 19:29:09'),(254,5481,85,40720,1533,3,250,1,0.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(255,5481,85,40720,1533,3,250,1,690.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(256,5481,85,40720,1533,3,57,2,690.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(257,5481,86,40720,1533,3,250,1,0.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(258,5481,86,40720,1533,3,250,1,170.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(259,5481,86,40720,1533,3,57,2,170.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(260,5481,87,40720,1533,3,250,1,0.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09');
INSERT INTO `balance_libro_details` VALUES (261,5481,87,40720,1533,3,250,1,590.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(262,5481,87,40720,1533,3,57,2,590.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(263,5481,88,40720,1533,3,250,1,0.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(264,5481,88,40720,1533,3,250,1,690.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(265,5481,88,40720,1533,3,57,2,690.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(266,5481,89,40720,1533,3,217,1,593.39,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(267,5481,89,40720,1533,3,68,1,124.61,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(268,5481,89,40720,1533,3,217,1,17.80,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(269,5481,89,40720,1533,3,57,2,735.80,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(270,5481,90,40720,1533,3,217,1,45114.87,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(271,5481,90,40720,1533,3,68,1,9474.12,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(272,5481,90,40720,1533,3,57,2,54588.99,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(273,5481,91,40720,1533,3,217,1,74508.40,NULL,'2021-08-09 11:04:59','2021-08-09 11:06:49','2021-08-09 11:06:49'),(274,5481,91,40720,1533,3,68,1,10664.17,NULL,'2021-08-09 11:04:59','2021-08-09 11:06:49','2021-08-09 11:06:49'),(275,5481,91,40720,1533,3,57,2,85172.57,NULL,'2021-08-09 11:04:59','2021-08-09 11:06:49','2021-08-09 11:06:49'),(276,5481,92,40720,1533,3,217,1,1809.92,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(277,5481,92,40720,1533,3,68,1,380.08,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(278,5481,92,40720,1533,3,57,2,2190.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(279,5481,93,40720,1533,3,217,1,6190.08,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(280,5481,93,40720,1533,3,68,1,1299.92,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(281,5481,93,40720,1533,3,57,2,7490.00,NULL,'2021-08-09 11:04:59','2021-08-09 19:29:09','2021-08-09 19:29:09'),(282,5481,94,40720,1533,3,46,1,74508.40,NULL,'2021-08-09 11:06:49','2021-08-09 19:29:09','2021-08-09 19:29:09'),(283,5481,94,40720,1533,3,68,1,7823.38,NULL,'2021-08-09 11:06:49','2021-08-09 19:29:09','2021-08-09 19:29:09'),(284,5481,94,40720,1533,3,57,2,82331.78,NULL,'2021-08-09 11:06:49','2021-08-09 19:29:09','2021-08-09 19:29:09'),(285,5481,95,40749,12138,2,96,2,622.62,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(286,5481,95,40749,12138,2,67,2,65.38,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(287,5481,95,40749,12138,2,96,2,357.02,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(288,5481,95,40749,12138,2,67,2,74.98,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(289,5481,95,40749,12138,2,13,1,1120.00,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(290,5481,96,40749,12138,2,96,2,1900.83,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(291,5481,96,40749,12138,2,67,2,399.17,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(292,5481,96,40749,12138,2,13,1,2300.00,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(293,5481,97,40749,12138,2,96,2,2213.94,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(294,5481,97,40749,12138,2,67,2,464.93,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(295,5481,97,40749,12138,2,96,2,125.57,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(296,5481,97,40749,12138,2,67,2,13.18,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(297,5481,97,40749,12138,2,13,1,2879.37,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(298,5481,97,40749,12138,2,136,2,61.75,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL);
INSERT INTO `balance_libro_details` VALUES (299,5481,98,40749,12138,2,96,2,991.74,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(300,5481,98,40749,12138,2,67,2,208.26,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(301,5481,98,40749,12138,2,13,1,1200.00,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(302,5481,99,40749,12138,2,96,2,1223.96,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(303,5481,99,40749,12138,2,67,2,257.03,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(304,5481,99,40749,12138,2,96,2,448.15,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(305,5481,99,40749,12138,2,67,2,47.05,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(306,5481,99,40749,12138,2,13,1,1976.19,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(307,5481,100,40749,12138,2,96,2,1739.26,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(308,5481,100,40749,12138,2,67,2,365.25,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(309,5481,100,40749,12138,2,13,1,2104.51,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(310,5481,101,40749,12138,2,96,2,1544.02,NULL,'2021-08-09 16:22:25','2021-08-09 16:22:25',NULL),(311,5481,101,40749,12138,2,67,2,324.23,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(312,5481,101,40749,12138,2,96,2,437.10,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(313,5481,101,40749,12138,2,67,2,45.90,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(314,5481,101,40749,12138,2,13,1,2413.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(315,5481,101,40749,12138,2,136,2,61.75,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(316,5481,102,40749,12138,2,96,2,1284.30,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(317,5481,102,40749,12138,2,67,2,269.70,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(318,5481,102,40749,12138,2,13,1,1554.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(319,5481,103,40749,12138,2,96,2,1618.99,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(320,5481,103,40749,12138,2,67,2,339.99,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(321,5481,103,40749,12138,2,96,2,63.35,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(322,5481,103,40749,12138,2,67,2,6.65,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(323,5481,103,40749,12138,2,13,1,2028.98,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(324,5481,104,40749,12138,2,96,2,2367.77,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(325,5481,104,40749,12138,2,67,2,497.23,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(326,5481,104,40749,12138,2,96,2,264.98,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(327,5481,104,40749,12138,2,67,2,27.82,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(328,5481,104,40749,12138,2,13,1,3157.80,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(329,5481,105,40749,12138,2,96,2,1694.21,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(330,5481,105,40749,12138,2,67,2,355.77,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(331,5481,105,40749,12138,2,13,1,2049.98,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(332,5481,106,40749,12138,2,96,2,477.28,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(333,5481,106,40749,12138,2,67,2,100.22,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(334,5481,106,40749,12138,2,13,1,577.50,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(335,5481,107,40749,12138,2,96,2,426.47,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(336,5481,107,40749,12138,2,67,2,44.78,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(337,5481,107,40749,12138,2,96,2,3239.02,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(338,5481,107,40749,12138,2,67,2,680.20,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(339,5481,107,40749,12138,2,13,1,4449.25,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(340,5481,107,40749,12138,2,136,2,58.78,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL);
INSERT INTO `balance_libro_details` VALUES (341,5481,108,40749,12138,2,96,2,1816.74,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(342,5481,108,40749,12138,2,67,2,381.51,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(343,5481,108,40749,12138,2,13,1,2260.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(344,5481,108,40749,12138,2,136,2,61.75,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(345,5481,109,40749,12138,2,96,2,2876.86,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(346,5481,109,40749,12138,2,67,2,604.15,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(347,5481,109,40749,12138,2,96,2,193.67,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(348,5481,109,40749,12138,2,67,2,20.33,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(349,5481,109,40749,12138,2,13,1,3695.01,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(350,5481,110,40749,12138,2,96,2,1024.80,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(351,5481,110,40749,12138,2,67,2,215.20,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(352,5481,110,40749,12138,2,13,1,1240.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(353,5481,111,40749,12138,2,96,2,2571.29,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(354,5481,111,40749,12138,2,67,2,539.97,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(355,5481,111,40749,12138,2,13,1,3173.01,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(356,5481,111,40749,12138,2,136,2,61.75,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(357,5481,112,40749,12138,2,96,2,280.16,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(358,5481,112,40749,12138,2,67,2,58.83,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(359,5481,112,40749,12138,2,96,2,416.29,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(360,5481,112,40749,12138,2,67,2,43.71,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(361,5481,112,40749,12138,2,13,1,798.99,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(362,5481,113,40749,12138,2,96,2,584.71,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(363,5481,113,40749,12138,2,67,2,122.79,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(364,5481,113,40749,12138,2,13,1,707.50,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(365,5481,114,40749,12138,2,96,2,2644.63,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(366,5481,114,40749,12138,2,67,2,555.37,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(367,5481,114,40749,12138,2,13,1,3200.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(368,5481,115,40749,12138,2,96,2,619.83,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(369,5481,115,40749,12138,2,67,2,130.16,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(370,5481,115,40749,12138,2,13,1,749.99,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(371,5481,116,40749,12138,2,96,2,74.38,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(372,5481,116,40749,12138,2,67,2,15.62,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(373,5481,116,40749,12138,2,96,2,662.17,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(374,5481,116,40749,12138,2,67,2,69.53,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(375,5481,116,40749,12138,2,13,1,821.70,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(376,5481,117,40749,12138,2,96,2,2413.43,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(377,5481,117,40749,12138,2,67,2,506.82,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(378,5481,117,40749,12138,2,13,1,2982.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(379,5481,117,40749,12138,2,136,2,61.75,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(380,5481,118,40749,12138,2,96,2,1031.61,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(381,5481,118,40749,12138,2,67,2,216.64,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(382,5481,118,40749,12138,2,13,1,1310.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL);
INSERT INTO `balance_libro_details` VALUES (383,5481,118,40749,12138,2,136,2,61.75,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(384,5481,119,40749,12138,2,96,2,198.35,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(385,5481,119,40749,12138,2,67,2,41.65,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(386,5481,119,40749,12138,2,13,1,240.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(387,5481,120,40749,12138,2,96,2,4347.95,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(388,5481,120,40749,12138,2,67,2,913.06,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(389,5481,120,40749,12138,2,13,1,5261.01,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(390,5481,121,40749,12138,2,96,2,1024.80,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(391,5481,121,40749,12138,2,67,2,215.20,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(392,5481,121,40749,12138,2,13,1,1240.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(393,5481,122,40749,12138,2,96,2,82.64,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(394,5481,122,40749,12138,2,67,2,17.36,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(395,5481,122,40749,12138,2,13,1,100.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(396,5481,123,40749,12138,2,96,2,241.32,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(397,5481,123,40749,12138,2,67,2,50.68,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(398,5481,123,40749,12138,2,13,1,292.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(399,5481,124,40749,12138,2,96,2,214.39,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(400,5481,124,40749,12138,2,67,2,22.51,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(401,5481,124,40749,12138,2,96,2,214.88,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(402,5481,124,40749,12138,2,67,2,45.12,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(403,5481,124,40749,12138,2,13,1,496.90,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(404,5481,125,40749,12138,2,96,2,371.90,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(405,5481,125,40749,12138,2,67,2,78.10,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(406,5481,125,40749,12138,2,13,1,450.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(407,5481,126,40749,12138,2,96,2,240.49,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(408,5481,126,40749,12138,2,67,2,50.50,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(409,5481,126,40749,12138,2,96,2,42.81,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(410,5481,126,40749,12138,2,67,2,4.50,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(411,5481,126,40749,12138,2,13,1,338.30,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(412,5481,127,40749,12138,2,96,2,90.91,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(413,5481,127,40749,12138,2,67,2,19.09,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(414,5481,127,40749,12138,2,96,2,841.63,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(415,5481,127,40749,12138,2,67,2,88.37,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(416,5481,127,40749,12138,2,13,1,1040.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(417,5481,128,40749,12138,2,96,2,2142.15,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(418,5481,128,40749,12138,2,67,2,449.85,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(419,5481,128,40749,12138,2,96,2,952.94,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(420,5481,128,40749,12138,2,67,2,100.06,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(421,5481,128,40749,12138,2,13,1,3645.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(422,5481,129,40749,12138,2,96,2,223.14,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(423,5481,129,40749,12138,2,67,2,46.86,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(424,5481,129,40749,12138,2,96,2,414.48,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL);
INSERT INTO `balance_libro_details` VALUES (425,5481,129,40749,12138,2,67,2,43.52,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(426,5481,129,40749,12138,2,13,1,728.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(427,5481,130,40749,12138,2,96,2,165.29,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(428,5481,130,40749,12138,2,67,2,34.71,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(429,5481,130,40749,12138,2,13,1,200.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(430,5481,131,40749,12138,2,96,2,264.47,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(431,5481,131,40749,12138,2,67,2,55.53,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(432,5481,131,40749,12138,2,96,2,90.50,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(433,5481,131,40749,12138,2,67,2,9.50,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(434,5481,131,40749,12138,2,13,1,420.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(435,5481,132,40749,12138,2,96,2,271.07,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(436,5481,132,40749,12138,2,67,2,56.93,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(437,5481,132,40749,12138,2,13,1,328.00,NULL,'2021-08-09 16:22:26','2021-08-09 16:22:26',NULL),(438,5481,133,40749,12138,2,96,2,657.21,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(439,5481,133,40749,12138,2,67,2,138.01,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(440,5481,133,40749,12138,2,96,2,98.73,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(441,5481,133,40749,12138,2,67,2,10.37,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(442,5481,133,40749,12138,2,13,1,968.90,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(443,5481,133,40749,12138,2,136,2,64.58,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(444,5481,134,40749,12138,2,96,2,412.40,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(445,5481,134,40749,12138,2,67,2,86.60,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(446,5481,134,40749,12138,2,13,1,499.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(447,5481,135,40749,12138,2,96,2,758.68,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(448,5481,135,40749,12138,2,67,2,159.32,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(449,5481,135,40749,12138,2,13,1,918.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(450,5481,136,40749,12138,2,96,2,661.57,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(451,5481,136,40749,12138,2,67,2,138.93,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(452,5481,136,40749,12138,2,13,1,924.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(453,5481,136,40749,12138,2,136,2,123.50,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(454,5481,137,40749,12138,2,96,2,152.89,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(455,5481,137,40749,12138,2,67,2,32.10,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(456,5481,137,40749,12138,2,96,2,168.69,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(457,5481,137,40749,12138,2,67,2,17.72,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(458,5481,137,40749,12138,2,13,1,371.40,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(459,5481,138,40749,12138,2,96,2,325.61,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(460,5481,138,40749,12138,2,67,2,68.39,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(461,5481,138,40749,12138,2,96,2,147.38,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(462,5481,138,40749,12138,2,67,2,15.47,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(463,5481,138,40749,12138,2,13,1,556.85,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(464,5481,139,40749,12138,2,96,2,152.90,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(465,5481,139,40749,12138,2,67,2,32.10,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(466,5481,139,40749,12138,2,13,1,185.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL);
INSERT INTO `balance_libro_details` VALUES (467,5481,140,40749,12138,2,96,2,509.91,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(468,5481,140,40749,12138,2,67,2,107.09,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(469,5481,140,40749,12138,2,96,2,20.81,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(470,5481,140,40749,12138,2,67,2,2.19,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(471,5481,140,40749,12138,2,13,1,640.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(472,5481,141,40749,12138,2,96,2,504.13,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(473,5481,141,40749,12138,2,67,2,105.87,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(474,5481,141,40749,12138,2,13,1,610.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(475,5481,142,40749,12138,2,96,2,376.04,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(476,5481,142,40749,12138,2,67,2,78.96,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(477,5481,142,40749,12138,2,13,1,455.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(478,5481,143,40749,12138,2,96,2,180.73,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(479,5481,143,40749,12138,2,67,2,18.97,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(480,5481,143,40749,12138,2,96,2,214.88,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(481,5481,143,40749,12138,2,67,2,45.12,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(482,5481,143,40749,12138,2,13,1,459.70,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(483,5481,144,40749,12138,2,96,2,1415.39,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(484,5481,144,40749,12138,2,67,2,297.22,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(485,5481,144,40749,12138,2,13,1,1855.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(486,5481,144,40749,12138,2,136,2,142.39,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(487,5481,145,40749,12138,2,96,2,123.96,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(488,5481,145,40749,12138,2,67,2,26.04,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(489,5481,145,40749,12138,2,13,1,150.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(490,5481,146,40749,12138,2,96,2,264.46,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(491,5481,146,40749,12138,2,67,2,55.54,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(492,5481,146,40749,12138,2,13,1,320.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(493,5481,147,40749,12138,2,96,2,482.56,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(494,5481,147,40749,12138,2,67,2,101.35,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(495,5481,147,40749,12138,2,96,2,1019.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(496,5481,147,40749,12138,2,67,2,106.99,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(497,5481,147,40749,12138,2,13,1,1709.90,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(498,5481,148,40749,12138,2,96,2,133.06,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(499,5481,148,40749,12138,2,67,2,27.94,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(500,5481,148,40749,12138,2,96,2,187.33,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(501,5481,148,40749,12138,2,67,2,19.67,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(502,5481,148,40749,12138,2,13,1,368.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(503,5481,149,40749,12138,2,96,2,315.29,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(504,5481,149,40749,12138,2,67,2,33.11,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(505,5481,149,40749,12138,2,96,2,169.43,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(506,5481,149,40749,12138,2,67,2,35.57,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(507,5481,149,40749,12138,2,13,1,553.40,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(508,5481,150,40749,12138,2,96,2,231.40,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL);
INSERT INTO `balance_libro_details` VALUES (509,5481,150,40749,12138,2,67,2,48.60,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(510,5481,150,40749,12138,2,96,2,27.87,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(511,5481,150,40749,12138,2,67,2,2.93,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(512,5481,150,40749,12138,2,13,1,310.80,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(513,5481,151,40749,12138,2,96,2,366.94,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(514,5481,151,40749,12138,2,67,2,77.06,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(515,5481,151,40749,12138,2,13,1,444.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(516,5481,152,40749,12138,2,96,2,256.20,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(517,5481,152,40749,12138,2,67,2,53.80,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(518,5481,152,40749,12138,2,13,1,310.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(519,5481,153,40749,12138,2,96,2,892.36,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(520,5481,153,40749,12138,2,67,2,187.39,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(521,5481,153,40749,12138,2,96,2,336.25,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(522,5481,153,40749,12138,2,67,2,35.30,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(523,5481,153,40749,12138,2,13,1,1451.30,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(524,5481,154,40749,12138,2,96,2,36.83,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(525,5481,154,40749,12138,2,67,2,3.87,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(526,5481,154,40749,12138,2,96,2,1247.11,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(527,5481,154,40749,12138,2,67,2,261.89,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(528,5481,154,40749,12138,2,13,1,1549.70,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(529,5481,155,40749,12138,2,96,2,686.95,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(530,5481,155,40749,12138,2,67,2,144.27,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(531,5481,155,40749,12138,2,13,1,890.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(532,5481,155,40749,12138,2,136,2,58.78,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(533,5481,156,40749,12138,2,96,2,1947.97,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(534,5481,156,40749,12138,2,67,2,409.03,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(535,5481,156,40749,12138,2,13,1,2357.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(536,5481,157,40749,12138,2,96,2,238.87,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(537,5481,157,40749,12138,2,67,2,25.08,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(538,5481,157,40749,12138,2,96,2,869.42,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(539,5481,157,40749,12138,2,67,2,182.58,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(540,5481,157,40749,12138,2,13,1,1315.95,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(541,5481,158,40749,12138,2,96,2,41.32,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(542,5481,158,40749,12138,2,67,2,8.68,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(543,5481,158,40749,12138,2,13,1,50.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(544,5481,159,40749,12138,2,96,2,578.51,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(545,5481,159,40749,12138,2,67,2,121.49,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(546,5481,159,40749,12138,2,13,1,700.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(547,5481,160,40749,12138,2,96,2,140.50,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(548,5481,160,40749,12138,2,67,2,29.50,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(549,5481,160,40749,12138,2,96,2,162.90,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(550,5481,160,40749,12138,2,67,2,17.10,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL);
INSERT INTO `balance_libro_details` VALUES (551,5481,160,40749,12138,2,13,1,350.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(552,5481,161,40749,12138,2,96,2,247.93,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(553,5481,161,40749,12138,2,67,2,52.07,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(554,5481,161,40749,12138,2,13,1,300.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(555,5481,162,40749,12138,2,96,2,1977.68,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(556,5481,162,40749,12138,2,67,2,415.32,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(557,5481,162,40749,12138,2,13,1,2640.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(558,5481,162,40749,12138,2,136,2,247.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(559,5481,163,40749,12138,2,96,2,454.55,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(560,5481,163,40749,12138,2,67,2,95.45,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(561,5481,163,40749,12138,2,96,2,94.03,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(562,5481,163,40749,12138,2,67,2,9.87,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(563,5481,163,40749,12138,2,13,1,653.90,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(564,5481,164,40749,12138,2,96,2,94.03,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(565,5481,164,40749,12138,2,67,2,9.87,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(566,5481,164,40749,12138,2,96,2,162.07,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(567,5481,164,40749,12138,2,67,2,34.03,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(568,5481,164,40749,12138,2,13,1,300.00,NULL,'2021-08-09 16:22:27','2021-08-09 16:22:27',NULL),(569,5481,165,40749,12138,2,96,2,309.09,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(570,5481,165,40749,12138,2,67,2,64.91,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(571,5481,165,40749,12138,2,96,2,123.89,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(572,5481,165,40749,12138,2,67,2,13.01,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(573,5481,165,40749,12138,2,13,1,510.90,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(574,5481,166,40749,12138,2,96,2,310.95,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(575,5481,166,40749,12138,2,67,2,65.30,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(576,5481,166,40749,12138,2,13,1,376.25,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(577,5481,167,40749,12138,2,96,2,1935.13,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(578,5481,167,40749,12138,2,67,2,406.37,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(579,5481,167,40749,12138,2,13,1,2341.50,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(580,5481,168,40749,12138,2,96,2,1322.31,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(581,5481,168,40749,12138,2,67,2,277.69,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(582,5481,168,40749,12138,2,96,2,744.98,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(583,5481,168,40749,12138,2,67,2,78.22,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(584,5481,168,40749,12138,2,13,1,2423.20,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(585,5481,169,40749,12138,2,96,2,661.16,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(586,5481,169,40749,12138,2,67,2,138.84,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(587,5481,169,40749,12138,2,13,1,800.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(588,5481,170,40749,12138,2,96,2,900.50,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(589,5481,170,40749,12138,2,67,2,189.10,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(590,5481,170,40749,12138,2,96,2,145.16,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(591,5481,170,40749,12138,2,67,2,15.24,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(592,5481,170,40749,12138,2,13,1,1250.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL);
INSERT INTO `balance_libro_details` VALUES (593,5481,171,40749,12138,2,96,2,280.99,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(594,5481,171,40749,12138,2,67,2,59.01,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(595,5481,171,40749,12138,2,13,1,340.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(596,5481,172,40749,12138,2,96,2,89.26,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(597,5481,172,40749,12138,2,67,2,18.74,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(598,5481,172,40749,12138,2,96,2,187.51,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(599,5481,172,40749,12138,2,67,2,19.69,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(600,5481,172,40749,12138,2,13,1,315.20,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(601,5481,173,40749,12138,2,96,2,107.44,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(602,5481,173,40749,12138,2,67,2,22.56,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(603,5481,173,40749,12138,2,13,1,130.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(604,5481,174,40749,12138,2,96,2,495.87,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(605,5481,174,40749,12138,2,67,2,104.13,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(606,5481,174,40749,12138,2,13,1,600.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(607,5481,175,40749,12138,2,96,2,190.08,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(608,5481,175,40749,12138,2,67,2,39.92,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(609,5481,175,40749,12138,2,13,1,230.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(610,5481,176,40749,12138,2,96,2,181.82,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(611,5481,176,40749,12138,2,67,2,38.18,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(612,5481,176,40749,12138,2,13,1,220.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(613,5481,177,40749,12138,2,96,2,353.30,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(614,5481,177,40749,12138,2,67,2,74.20,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(615,5481,177,40749,12138,2,96,2,271.49,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(616,5481,177,40749,12138,2,67,2,28.51,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(617,5481,177,40749,12138,2,13,1,727.50,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(618,5481,178,40749,12138,2,96,2,330.58,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(619,5481,178,40749,12138,2,67,2,69.42,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(620,5481,178,40749,12138,2,13,1,400.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(621,5481,179,40749,12138,2,96,2,677.68,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(622,5481,179,40749,12138,2,67,2,142.32,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(623,5481,179,40749,12138,2,13,1,820.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(624,5481,180,40749,12138,2,96,2,1294.21,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(625,5481,180,40749,12138,2,67,2,271.79,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(626,5481,180,40749,12138,2,13,1,1566.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(627,5481,181,40749,12138,2,96,2,230.58,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(628,5481,181,40749,12138,2,67,2,48.42,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(629,5481,181,40749,12138,2,96,2,45.25,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(630,5481,181,40749,12138,2,67,2,4.75,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(631,5481,181,40749,12138,2,13,1,329.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(632,5481,182,40749,12138,2,96,2,1404.95,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(633,5481,182,40749,12138,2,67,2,295.05,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(634,5481,182,40749,12138,2,13,1,1700.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL);
INSERT INTO `balance_libro_details` VALUES (635,5481,183,40749,12138,2,96,2,173.55,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(636,5481,183,40749,12138,2,67,2,36.45,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(637,5481,183,40749,12138,2,13,1,210.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(638,5481,184,40749,12138,2,96,2,446.27,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(639,5481,184,40749,12138,2,67,2,93.73,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(640,5481,184,40749,12138,2,13,1,540.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(641,5481,185,40749,12138,2,96,2,417.36,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(642,5481,185,40749,12138,2,67,2,87.64,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(643,5481,185,40749,12138,2,13,1,505.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(644,5481,186,40749,12138,2,96,2,2054.54,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(645,5481,186,40749,12138,2,67,2,431.46,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(646,5481,186,40749,12138,2,13,1,2486.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(647,5481,187,40749,12138,2,96,2,208.14,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(648,5481,187,40749,12138,2,67,2,21.85,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(649,5481,187,40749,12138,2,96,2,130.58,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(650,5481,187,40749,12138,2,67,2,27.43,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(651,5481,187,40749,12138,2,13,1,388.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(652,5481,188,40749,12138,2,96,2,115.70,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(653,5481,188,40749,12138,2,67,2,24.30,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(654,5481,188,40749,12138,2,96,2,131.22,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(655,5481,188,40749,12138,2,67,2,13.78,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(656,5481,188,40749,12138,2,13,1,285.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(657,5481,189,40749,12138,2,96,2,541.33,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(658,5481,189,40749,12138,2,67,2,113.67,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(659,5481,189,40749,12138,2,96,2,117.65,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(660,5481,189,40749,12138,2,67,2,12.35,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(661,5481,189,40749,12138,2,13,1,785.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(662,5481,190,40749,12138,2,96,2,1204.95,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(663,5481,190,40749,12138,2,67,2,253.05,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(664,5481,190,40749,12138,2,13,1,1458.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(665,5481,191,40749,12138,2,96,2,1203.30,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(666,5481,191,40749,12138,2,67,2,252.70,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(667,5481,191,40749,12138,2,96,2,67.87,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(668,5481,191,40749,12138,2,67,2,7.13,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(669,5481,191,40749,12138,2,13,1,1531.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(670,5481,192,40749,12138,2,96,2,214.88,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(671,5481,192,40749,12138,2,67,2,45.12,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(672,5481,192,40749,12138,2,13,1,260.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(673,5481,193,40749,12138,2,96,2,256.19,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(674,5481,193,40749,12138,2,67,2,53.81,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(675,5481,193,40749,12138,2,13,1,310.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(676,5481,194,40749,12138,2,96,2,1041.33,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL);
INSERT INTO `balance_libro_details` VALUES (677,5481,194,40749,12138,2,67,2,218.67,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(678,5481,194,40749,12138,2,13,1,1260.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(679,5481,195,40749,12138,2,96,2,904.95,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(680,5481,195,40749,12138,2,67,2,190.05,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(681,5481,195,40749,12138,2,13,1,1095.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(682,5481,196,40749,12138,2,96,2,45.25,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(683,5481,196,40749,12138,2,67,2,4.75,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(684,5481,196,40749,12138,2,96,2,909.08,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(685,5481,196,40749,12138,2,67,2,190.92,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(686,5481,196,40749,12138,2,13,1,1150.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(687,5481,197,40749,12138,2,96,2,446.29,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(688,5481,197,40749,12138,2,67,2,93.71,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(689,5481,197,40749,12138,2,96,2,83.80,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(690,5481,197,40749,12138,2,67,2,8.80,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(691,5481,197,40749,12138,2,13,1,632.60,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(692,5481,198,40749,12138,2,96,2,330.57,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(693,5481,198,40749,12138,2,67,2,69.43,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(694,5481,198,40749,12138,2,13,1,400.00,NULL,'2021-08-09 16:22:28','2021-08-09 16:22:28',NULL),(695,5481,199,40749,12138,2,96,2,90.91,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(696,5481,199,40749,12138,2,67,2,19.09,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(697,5481,199,40749,12138,2,96,2,81.45,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(698,5481,199,40749,12138,2,67,2,8.55,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(699,5481,199,40749,12138,2,13,1,200.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(700,5481,200,40749,12138,2,96,2,516.53,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(701,5481,200,40749,12138,2,67,2,108.47,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(702,5481,200,40749,12138,2,96,2,102.26,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(703,5481,200,40749,12138,2,67,2,10.74,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(704,5481,200,40749,12138,2,13,1,738.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(705,5481,201,40749,12138,2,96,2,553.71,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(706,5481,201,40749,12138,2,67,2,116.29,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(707,5481,201,40749,12138,2,96,2,137.47,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(708,5481,201,40749,12138,2,67,2,14.43,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(709,5481,201,40749,12138,2,13,1,821.90,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(710,5481,202,40749,12138,2,96,2,161.15,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(711,5481,202,40749,12138,2,67,2,33.85,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(712,5481,202,40749,12138,2,13,1,195.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(713,5481,203,40749,12138,2,96,2,610.74,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(714,5481,203,40749,12138,2,67,2,128.26,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(715,5481,203,40749,12138,2,13,1,739.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(716,5481,204,40749,12138,2,96,2,611.57,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(717,5481,204,40749,12138,2,67,2,128.43,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(718,5481,204,40749,12138,2,13,1,740.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL);
INSERT INTO `balance_libro_details` VALUES (719,5481,205,40749,12138,2,96,2,421.49,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(720,5481,205,40749,12138,2,67,2,88.51,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(721,5481,205,40749,12138,2,13,1,510.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(722,5481,206,40749,12138,2,96,2,925.62,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(723,5481,206,40749,12138,2,67,2,194.38,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(724,5481,206,40749,12138,2,13,1,1120.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(725,5481,207,40749,12138,2,96,2,165.29,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(726,5481,207,40749,12138,2,67,2,34.71,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(727,5481,207,40749,12138,2,13,1,200.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(728,5481,208,40749,12138,2,96,2,737.20,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(729,5481,208,40749,12138,2,67,2,154.80,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(730,5481,208,40749,12138,2,13,1,892.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(731,5481,209,40749,12138,2,96,2,262.44,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(732,5481,209,40749,12138,2,67,2,55.11,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(733,5481,209,40749,12138,2,13,1,380.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(734,5481,209,40749,12138,2,136,2,62.45,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(735,5481,210,40749,12138,2,96,2,200.83,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(736,5481,210,40749,12138,2,67,2,42.17,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(737,5481,210,40749,12138,2,96,2,22.62,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(738,5481,210,40749,12138,2,67,2,2.38,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(739,5481,210,40749,12138,2,13,1,268.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(740,5481,211,40749,12138,2,96,2,514.06,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(741,5481,211,40749,12138,2,67,2,107.94,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(742,5481,211,40749,12138,2,13,1,622.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(743,5481,212,40749,12138,2,96,2,735.54,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(744,5481,212,40749,12138,2,67,2,154.46,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(745,5481,212,40749,12138,2,96,2,129.50,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(746,5481,212,40749,12138,2,67,2,13.60,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(747,5481,212,40749,12138,2,13,1,1033.10,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(748,5481,213,40749,12138,2,96,2,165.29,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(749,5481,213,40749,12138,2,67,2,34.71,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(750,5481,213,40749,12138,2,13,1,200.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(751,5481,214,40749,12138,2,96,2,132.23,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(752,5481,214,40749,12138,2,67,2,27.77,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(753,5481,214,40749,12138,2,13,1,160.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(754,5481,215,40749,12138,2,96,2,1035.96,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(755,5481,215,40749,12138,2,67,2,217.54,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(756,5481,215,40749,12138,2,96,2,559.91,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(757,5481,215,40749,12138,2,67,2,58.79,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(758,5481,215,40749,12138,2,13,1,1872.20,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(759,5481,216,40749,12138,2,96,2,214.87,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(760,5481,216,40749,12138,2,67,2,45.13,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL);
INSERT INTO `balance_libro_details` VALUES (761,5481,216,40749,12138,2,96,2,101.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(762,5481,216,40749,12138,2,67,2,10.60,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(763,5481,216,40749,12138,2,13,1,371.60,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(764,5481,217,40749,12138,2,96,2,512.40,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(765,5481,217,40749,12138,2,67,2,107.60,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(766,5481,217,40749,12138,2,13,1,620.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(767,5481,218,40749,12138,2,96,2,206.60,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(768,5481,218,40749,12138,2,67,2,43.40,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(769,5481,218,40749,12138,2,13,1,250.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(770,5481,219,40749,12138,2,96,2,360.33,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(771,5481,219,40749,12138,2,67,2,75.67,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(772,5481,219,40749,12138,2,13,1,436.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(773,5481,220,40749,12138,2,96,2,140.50,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(774,5481,220,40749,12138,2,67,2,29.50,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(775,5481,220,40749,12138,2,13,1,170.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(776,5481,221,40749,12138,2,96,2,280.99,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(777,5481,221,40749,12138,2,67,2,59.01,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(778,5481,221,40749,12138,2,13,1,340.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(779,5481,222,40749,12138,2,96,2,518.18,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(780,5481,222,40749,12138,2,67,2,108.82,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(781,5481,222,40749,12138,2,13,1,627.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(782,5481,223,40749,12138,2,96,2,123.97,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(783,5481,223,40749,12138,2,67,2,26.03,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(784,5481,223,40749,12138,2,13,1,150.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(785,5481,224,40749,12138,2,96,2,330.58,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(786,5481,224,40749,12138,2,67,2,69.42,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(787,5481,224,40749,12138,2,13,1,400.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(788,5481,225,40749,12138,2,96,2,445.47,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(789,5481,225,40749,12138,2,67,2,93.53,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(790,5481,225,40749,12138,2,96,2,308.60,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(791,5481,225,40749,12138,2,67,2,32.40,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(792,5481,225,40749,12138,2,13,1,880.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(793,5481,226,40749,12138,2,96,2,210.74,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(794,5481,226,40749,12138,2,67,2,44.26,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(795,5481,226,40749,12138,2,13,1,255.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(796,5481,227,40749,12138,2,96,2,190.08,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(797,5481,227,40749,12138,2,67,2,39.92,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(798,5481,227,40749,12138,2,13,1,230.00,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(799,5481,228,40749,12138,2,96,2,549.58,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(800,5481,228,40749,12138,2,67,2,115.42,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(801,5481,228,40749,12138,2,96,2,44.80,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(802,5481,228,40749,12138,2,67,2,4.70,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL);
INSERT INTO `balance_libro_details` VALUES (803,5481,228,40749,12138,2,13,1,714.50,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(804,5481,229,40749,12138,2,96,2,49.59,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(805,5481,229,40749,12138,2,67,2,10.41,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(806,5481,229,40749,12138,2,96,2,152.49,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(807,5481,229,40749,12138,2,67,2,16.01,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(808,5481,229,40749,12138,2,13,1,228.50,NULL,'2021-08-09 16:22:29','2021-08-09 16:22:29',NULL),(809,5481,230,40749,12138,2,96,2,611.57,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(810,5481,230,40749,12138,2,67,2,128.43,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(811,5481,230,40749,12138,2,13,1,740.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(812,5481,231,40749,12138,2,96,2,560.31,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(813,5481,231,40749,12138,2,67,2,117.69,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(814,5481,231,40749,12138,2,96,2,636.74,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(815,5481,231,40749,12138,2,67,2,66.86,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(816,5481,231,40749,12138,2,13,1,1381.60,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(817,5481,232,40749,12138,2,96,2,809.73,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(818,5481,232,40749,12138,2,67,2,170.05,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(819,5481,232,40749,12138,2,96,2,181.45,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(820,5481,232,40749,12138,2,67,2,19.05,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(821,5481,232,40749,12138,2,13,1,1267.50,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(822,5481,232,40749,12138,2,136,2,87.22,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(823,5481,233,40749,12138,2,96,2,189.25,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(824,5481,233,40749,12138,2,67,2,39.75,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(825,5481,233,40749,12138,2,96,2,43.80,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(826,5481,233,40749,12138,2,67,2,4.60,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(827,5481,233,40749,12138,2,13,1,277.40,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(828,5481,234,40749,12138,2,96,2,107.44,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(829,5481,234,40749,12138,2,67,2,22.56,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(830,5481,234,40749,12138,2,13,1,130.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(831,5481,235,40749,12138,2,96,2,377.69,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(832,5481,235,40749,12138,2,67,2,79.31,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(833,5481,235,40749,12138,2,96,2,108.60,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(834,5481,235,40749,12138,2,67,2,11.40,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(835,5481,235,40749,12138,2,13,1,577.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(836,5481,236,40749,12138,2,96,2,107.44,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(837,5481,236,40749,12138,2,67,2,22.56,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(838,5481,236,40749,12138,2,13,1,130.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(839,5481,237,40749,12138,2,96,2,451.25,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(840,5481,237,40749,12138,2,67,2,94.75,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(841,5481,237,40749,12138,2,13,1,546.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(842,5481,238,40749,12138,2,96,2,132.23,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(843,5481,238,40749,12138,2,67,2,27.77,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(844,5481,238,40749,12138,2,13,1,160.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL);
INSERT INTO `balance_libro_details` VALUES (845,5481,239,40749,12138,2,96,2,223.14,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(846,5481,239,40749,12138,2,67,2,46.86,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(847,5481,239,40749,12138,2,13,1,270.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(848,5481,240,40749,12138,2,96,2,789.26,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(849,5481,240,40749,12138,2,67,2,165.74,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(850,5481,240,40749,12138,2,13,1,955.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(851,5481,241,40749,12138,2,96,2,70.25,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(852,5481,241,40749,12138,2,67,2,14.75,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(853,5481,241,40749,12138,2,96,2,120.63,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(854,5481,241,40749,12138,2,67,2,12.67,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(855,5481,241,40749,12138,2,13,1,218.30,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(856,5481,242,40749,12138,2,96,2,479.34,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(857,5481,242,40749,12138,2,67,2,100.66,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(858,5481,242,40749,12138,2,13,1,580.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(859,5481,243,40749,12138,2,96,2,61.98,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(860,5481,243,40749,12138,2,67,2,13.02,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(861,5481,243,40749,12138,2,96,2,49.28,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(862,5481,243,40749,12138,2,67,2,5.17,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(863,5481,243,40749,12138,2,13,1,129.45,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(864,5481,244,40749,12138,2,96,2,49.59,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(865,5481,244,40749,12138,2,67,2,10.41,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(866,5481,244,40749,12138,2,13,1,60.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(867,5481,245,40749,12138,2,96,2,793.39,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(868,5481,245,40749,12138,2,67,2,166.61,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(869,5481,245,40749,12138,2,13,1,960.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(870,5481,246,40749,12138,2,96,2,220.68,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(871,5481,246,40749,12138,2,67,2,23.18,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(872,5481,246,40749,12138,2,96,2,681.82,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(873,5481,246,40749,12138,2,67,2,143.17,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(874,5481,246,40749,12138,2,13,1,1068.85,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(875,5481,247,40749,12138,2,96,2,82.64,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(876,5481,247,40749,12138,2,67,2,17.36,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(877,5481,247,40749,12138,2,13,1,100.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(878,5481,248,40749,12138,2,96,2,892.56,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(879,5481,248,40749,12138,2,67,2,187.44,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(880,5481,248,40749,12138,2,13,1,1080.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(881,5481,249,40749,12138,2,96,2,243.80,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(882,5481,249,40749,12138,2,67,2,51.20,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(883,5481,249,40749,12138,2,13,1,295.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(884,5481,250,40749,12138,2,96,2,100.72,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(885,5481,250,40749,12138,2,67,2,10.58,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(886,5481,250,40749,12138,2,96,2,706.15,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL);
INSERT INTO `balance_libro_details` VALUES (887,5481,250,40749,12138,2,67,2,148.30,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(888,5481,250,40749,12138,2,13,1,965.75,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(889,5481,251,40749,12138,2,96,2,1798.76,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(890,5481,251,40749,12138,2,67,2,377.74,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(891,5481,251,40749,12138,2,13,1,2300.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(892,5481,251,40749,12138,2,136,2,123.50,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(893,5481,252,40749,12138,2,96,2,309.92,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(894,5481,252,40749,12138,2,67,2,65.08,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(895,5481,252,40749,12138,2,13,1,375.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(896,5481,253,40749,12138,2,96,2,198.34,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(897,5481,253,40749,12138,2,67,2,41.66,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(898,5481,253,40749,12138,2,96,2,121.27,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(899,5481,253,40749,12138,2,67,2,12.73,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(900,5481,253,40749,12138,2,13,1,374.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(901,5481,254,40749,12138,2,96,2,1631.20,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(902,5481,254,40749,12138,2,67,2,342.55,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(903,5481,254,40749,12138,2,96,2,72.40,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(904,5481,254,40749,12138,2,67,2,7.60,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(905,5481,254,40749,12138,2,13,1,2053.75,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(906,5481,255,40749,12138,2,96,2,95.04,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(907,5481,255,40749,12138,2,67,2,19.96,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(908,5481,255,40749,12138,2,96,2,257.92,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(909,5481,255,40749,12138,2,67,2,27.08,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(910,5481,255,40749,12138,2,13,1,400.00,NULL,'2021-08-09 16:22:30','2021-08-09 16:22:30',NULL),(911,5481,256,40749,12138,2,96,2,347.11,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(912,5481,256,40749,12138,2,67,2,72.89,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(913,5481,256,40749,12138,2,96,2,72.40,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(914,5481,256,40749,12138,2,67,2,7.60,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(915,5481,256,40749,12138,2,13,1,500.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(916,5481,257,40749,12138,2,96,2,760.33,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(917,5481,257,40749,12138,2,67,2,159.67,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(918,5481,257,40749,12138,2,13,1,920.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(919,5481,258,40749,12138,2,96,2,859.91,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(920,5481,258,40749,12138,2,67,2,180.59,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(921,5481,258,40749,12138,2,96,2,95.75,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(922,5481,258,40749,12138,2,67,2,10.05,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(923,5481,258,40749,12138,2,13,1,1146.30,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(924,5481,259,40749,12138,2,96,2,2121.15,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(925,5481,259,40749,12138,2,67,2,445.44,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(926,5481,259,40749,12138,2,13,1,2634.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(927,5481,259,40749,12138,2,136,2,67.41,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(928,5481,260,40749,12138,2,96,2,395.04,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL);
INSERT INTO `balance_libro_details` VALUES (929,5481,260,40749,12138,2,67,2,82.96,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(930,5481,260,40749,12138,2,96,2,222.76,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(931,5481,260,40749,12138,2,67,2,23.39,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(932,5481,260,40749,12138,2,13,1,724.15,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(933,5481,261,40749,12138,2,96,2,119.83,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(934,5481,261,40749,12138,2,67,2,25.17,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(935,5481,261,40749,12138,2,13,1,145.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(936,5481,262,40749,12138,2,96,2,1480.99,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(937,5481,262,40749,12138,2,67,2,311.01,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(938,5481,262,40749,12138,2,96,2,109.14,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(939,5481,262,40749,12138,2,67,2,11.46,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(940,5481,262,40749,12138,2,13,1,1912.60,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(941,5481,263,40749,12138,2,96,2,413.22,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(942,5481,263,40749,12138,2,67,2,86.78,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(943,5481,263,40749,12138,2,13,1,500.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(944,5481,264,40749,12138,2,96,2,2092.57,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(945,5481,264,40749,12138,2,67,2,439.43,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(946,5481,264,40749,12138,2,96,2,354.43,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(947,5481,264,40749,12138,2,67,2,37.22,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(948,5481,264,40749,12138,2,13,1,2923.65,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(949,5481,265,40749,12138,2,96,2,438.01,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(950,5481,265,40749,12138,2,67,2,91.99,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(951,5481,265,40749,12138,2,13,1,530.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(952,5481,266,40749,12138,2,96,2,768.59,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(953,5481,266,40749,12138,2,67,2,161.41,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(954,5481,266,40749,12138,2,96,2,96.61,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(955,5481,266,40749,12138,2,67,2,10.14,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(956,5481,266,40749,12138,2,13,1,1036.75,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(957,5481,267,40749,12138,2,96,2,103.03,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(958,5481,267,40749,12138,2,67,2,10.82,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(959,5481,267,40749,12138,2,96,2,2198.34,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(960,5481,267,40749,12138,2,67,2,461.66,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(961,5481,267,40749,12138,2,13,1,2773.85,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(962,5481,268,40749,12138,2,96,2,965.03,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(963,5481,268,40749,12138,2,67,2,202.66,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(964,5481,268,40749,12138,2,96,2,154.39,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(965,5481,268,40749,12138,2,67,2,16.21,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(966,5481,268,40749,12138,2,13,1,1370.60,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(967,5481,268,40749,12138,2,136,2,32.31,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(968,5481,269,40749,12138,2,96,2,247.94,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(969,5481,269,40749,12138,2,67,2,52.06,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(970,5481,269,40749,12138,2,13,1,300.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL);
INSERT INTO `balance_libro_details` VALUES (971,5481,270,40749,12138,2,96,2,185.96,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(972,5481,270,40749,12138,2,67,2,39.04,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(973,5481,270,40749,12138,2,13,1,225.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(974,5481,271,40749,12138,2,96,2,536.78,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(975,5481,271,40749,12138,2,67,2,112.72,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(976,5481,271,40749,12138,2,13,1,649.50,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(977,5481,272,40749,12138,2,96,2,413.23,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(978,5481,272,40749,12138,2,67,2,86.77,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(979,5481,272,40749,12138,2,13,1,500.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(980,5481,273,40749,12138,2,96,2,154.75,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(981,5481,273,40749,12138,2,67,2,16.25,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(982,5481,273,40749,12138,2,96,2,494.60,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(983,5481,273,40749,12138,2,67,2,103.86,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(984,5481,273,40749,12138,2,13,1,830.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(985,5481,273,40749,12138,2,136,2,60.54,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(986,5481,274,40749,12138,2,96,2,685.94,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(987,5481,274,40749,12138,2,67,2,144.06,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(988,5481,274,40749,12138,2,13,1,830.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(989,5481,275,40749,12138,2,96,2,347.11,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(990,5481,275,40749,12138,2,67,2,72.89,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(991,5481,275,40749,12138,2,13,1,420.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(992,5481,276,40749,12138,2,96,2,371.08,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(993,5481,276,40749,12138,2,67,2,77.92,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(994,5481,276,40749,12138,2,96,2,46.15,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(995,5481,276,40749,12138,2,67,2,4.85,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(996,5481,276,40749,12138,2,13,1,500.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(997,5481,277,40749,12138,2,96,2,168.33,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(998,5481,277,40749,12138,2,67,2,17.67,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(999,5481,277,40749,12138,2,96,2,433.07,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1000,5481,277,40749,12138,2,67,2,90.93,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1001,5481,277,40749,12138,2,13,1,710.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1002,5481,278,40749,12138,2,96,2,231.39,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1003,5481,278,40749,12138,2,67,2,48.61,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1004,5481,278,40749,12138,2,96,2,42.53,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1005,5481,278,40749,12138,2,67,2,4.47,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1006,5481,278,40749,12138,2,13,1,327.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1007,5481,279,40749,12138,2,96,2,304.13,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1008,5481,279,40749,12138,2,67,2,63.87,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1009,5481,279,40749,12138,2,13,1,368.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1010,5481,280,40749,12138,2,96,2,78.51,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1011,5481,280,40749,12138,2,67,2,16.49,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1012,5481,280,40749,12138,2,13,1,95.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL);
INSERT INTO `balance_libro_details` VALUES (1013,5481,281,40749,12138,2,96,2,1290.90,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1014,5481,281,40749,12138,2,67,2,271.10,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1015,5481,281,40749,12138,2,13,1,1562.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1016,5481,282,40749,12138,2,96,2,132.23,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1017,5481,282,40749,12138,2,67,2,27.77,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1018,5481,282,40749,12138,2,13,1,160.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1019,5481,283,40749,12138,2,96,2,495.87,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1020,5481,283,40749,12138,2,67,2,104.13,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1021,5481,283,40749,12138,2,96,2,261.54,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1022,5481,283,40749,12138,2,67,2,27.46,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1023,5481,283,40749,12138,2,13,1,889.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1024,5481,284,40749,12138,2,96,2,99.17,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1025,5481,284,40749,12138,2,67,2,20.83,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1026,5481,284,40749,12138,2,13,1,120.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1027,5481,285,40749,12138,2,96,2,347.11,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1028,5481,285,40749,12138,2,67,2,72.89,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1029,5481,285,40749,12138,2,13,1,420.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1030,5481,286,40749,12138,2,96,2,901.65,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1031,5481,286,40749,12138,2,67,2,189.35,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1032,5481,286,40749,12138,2,96,2,274.75,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1033,5481,286,40749,12138,2,67,2,28.85,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1034,5481,286,40749,12138,2,13,1,1394.60,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1035,5481,287,40749,12138,2,96,2,396.68,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1036,5481,287,40749,12138,2,67,2,83.32,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1037,5481,287,40749,12138,2,96,2,366.74,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1038,5481,287,40749,12138,2,67,2,38.51,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1039,5481,287,40749,12138,2,13,1,885.25,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1040,5481,288,40749,12138,2,96,2,338.84,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1041,5481,288,40749,12138,2,67,2,71.16,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1042,5481,288,40749,12138,2,13,1,410.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1043,5481,289,40749,12138,2,96,2,206.61,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1044,5481,289,40749,12138,2,67,2,43.39,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1045,5481,289,40749,12138,2,13,1,250.00,NULL,'2021-08-09 16:22:31','2021-08-09 16:22:31',NULL),(1046,5481,290,40749,12138,2,96,2,492.56,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1047,5481,290,40749,12138,2,67,2,103.44,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1048,5481,290,40749,12138,2,96,2,247.24,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1049,5481,290,40749,12138,2,67,2,25.96,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1050,5481,290,40749,12138,2,13,1,869.20,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1051,5481,291,40749,12138,2,96,2,272.73,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1052,5481,291,40749,12138,2,67,2,57.27,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1053,5481,291,40749,12138,2,13,1,330.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL);
INSERT INTO `balance_libro_details` VALUES (1054,5481,292,40749,12138,2,96,2,728.51,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1055,5481,292,40749,12138,2,67,2,152.99,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1056,5481,292,40749,12138,2,96,2,76.02,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1057,5481,292,40749,12138,2,67,2,7.98,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1058,5481,292,40749,12138,2,13,1,965.50,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1059,5481,293,40749,12138,2,96,2,231.87,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1060,5481,293,40749,12138,2,67,2,48.69,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1061,5481,293,40749,12138,2,13,1,400.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1062,5481,293,40749,12138,2,136,2,119.44,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1063,5481,294,40749,12138,2,96,2,1335.54,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1064,5481,294,40749,12138,2,67,2,280.46,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1065,5481,294,40749,12138,2,96,2,162.90,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1066,5481,294,40749,12138,2,67,2,17.10,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1067,5481,294,40749,12138,2,13,1,1796.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1068,5481,295,40749,12138,2,96,2,1619.83,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1069,5481,295,40749,12138,2,67,2,340.17,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1070,5481,295,40749,12138,2,13,1,1960.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1071,5481,296,40749,12138,2,96,2,1408.48,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1072,5481,296,40749,12138,2,67,2,295.78,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1073,5481,296,40749,12138,2,96,2,36.20,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1074,5481,296,40749,12138,2,67,2,3.80,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1075,5481,296,40749,12138,2,13,1,1780.50,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1076,5481,296,40749,12138,2,136,2,36.24,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1077,5481,297,40749,12138,2,96,2,206.61,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1078,5481,297,40749,12138,2,67,2,43.39,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1079,5481,297,40749,12138,2,96,2,242.53,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1080,5481,297,40749,12138,2,67,2,25.47,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1081,5481,297,40749,12138,2,13,1,518.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1082,5481,298,40749,12138,2,96,2,1044.63,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1083,5481,298,40749,12138,2,67,2,219.37,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1084,5481,298,40749,12138,2,96,2,90.50,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1085,5481,298,40749,12138,2,67,2,9.50,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1086,5481,298,40749,12138,2,13,1,1364.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1087,5481,299,40749,12138,2,96,2,165.28,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1088,5481,299,40749,12138,2,67,2,34.72,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1089,5481,299,40749,12138,2,13,1,200.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1090,5481,300,40749,12138,2,96,2,123.97,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1091,5481,300,40749,12138,2,67,2,26.03,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1092,5481,300,40749,12138,2,13,1,150.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1093,5481,301,40749,12138,2,96,2,421.49,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1094,5481,301,40749,12138,2,67,2,88.51,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL);
INSERT INTO `balance_libro_details` VALUES (1095,5481,301,40749,12138,2,13,1,510.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1096,5481,302,40749,12138,2,96,2,1528.93,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1097,5481,302,40749,12138,2,67,2,321.07,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1098,5481,302,40749,12138,2,13,1,1850.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1099,5481,303,40749,12138,2,96,2,738.02,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1100,5481,303,40749,12138,2,67,2,154.98,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1101,5481,303,40749,12138,2,13,1,893.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1102,5481,304,40749,12138,2,96,2,1131.68,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1103,5481,304,40749,12138,2,67,2,237.65,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1104,5481,304,40749,12138,2,13,1,1430.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1105,5481,304,40749,12138,2,136,2,60.67,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1106,5481,305,40749,12138,2,96,2,709.30,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1107,5481,305,40749,12138,2,67,2,148.95,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1108,5481,305,40749,12138,2,13,1,920.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1109,5481,305,40749,12138,2,136,2,61.75,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1110,5481,306,40749,12138,2,96,2,336.65,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1111,5481,306,40749,12138,2,67,2,35.34,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1112,5481,306,40749,12138,2,96,2,429.76,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1113,5481,306,40749,12138,2,67,2,90.25,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1114,5481,306,40749,12138,2,13,1,892.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1115,5481,307,40749,12138,2,96,2,376.03,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1116,5481,307,40749,12138,2,67,2,78.97,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1117,5481,307,40749,12138,2,96,2,83.26,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1118,5481,307,40749,12138,2,67,2,8.74,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1119,5481,307,40749,12138,2,13,1,547.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1120,5481,308,40749,12138,2,96,2,361.98,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1121,5481,308,40749,12138,2,67,2,76.02,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1122,5481,308,40749,12138,2,13,1,438.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1123,5481,309,40749,12138,2,96,2,553.72,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1124,5481,309,40749,12138,2,67,2,116.28,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1125,5481,309,40749,12138,2,96,2,27.15,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1126,5481,309,40749,12138,2,67,2,2.85,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1127,5481,309,40749,12138,2,13,1,700.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1128,5481,310,40749,12138,2,96,2,1900.83,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1129,5481,310,40749,12138,2,67,2,399.17,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1130,5481,310,40749,12138,2,96,2,113.08,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1131,5481,310,40749,12138,2,67,2,11.87,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1132,5481,310,40749,12138,2,13,1,2424.95,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1133,5481,311,40749,12138,2,96,2,232.58,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1134,5481,311,40749,12138,2,67,2,24.42,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1135,5481,311,40749,12138,2,96,2,283.46,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL);
INSERT INTO `balance_libro_details` VALUES (1136,5481,311,40749,12138,2,67,2,59.54,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1137,5481,311,40749,12138,2,13,1,600.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1138,5481,312,40749,12138,2,96,2,1157.02,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1139,5481,312,40749,12138,2,67,2,242.98,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1140,5481,312,40749,12138,2,13,1,1400.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1141,5481,313,40749,12138,2,96,2,132.23,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1142,5481,313,40749,12138,2,67,2,27.77,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1143,5481,313,40749,12138,2,96,2,123.80,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1144,5481,313,40749,12138,2,67,2,13.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1145,5481,313,40749,12138,2,13,1,296.80,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1146,5481,314,40749,12138,2,96,2,272.72,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1147,5481,314,40749,12138,2,67,2,57.28,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1148,5481,314,40749,12138,2,13,1,330.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1149,5481,315,40749,12138,2,96,2,165.29,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1150,5481,315,40749,12138,2,67,2,34.71,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1151,5481,315,40749,12138,2,13,1,200.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1152,5481,316,40749,12138,2,96,2,242.53,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1153,5481,316,40749,12138,2,67,2,25.47,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1154,5481,316,40749,12138,2,96,2,322.31,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1155,5481,316,40749,12138,2,67,2,67.69,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1156,5481,316,40749,12138,2,13,1,658.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1157,5481,317,40749,12138,2,96,2,545.46,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1158,5481,317,40749,12138,2,67,2,114.54,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1159,5481,317,40749,12138,2,13,1,660.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1160,5481,318,40749,12138,2,96,2,514.88,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1161,5481,318,40749,12138,2,67,2,108.12,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1162,5481,318,40749,12138,2,13,1,623.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1163,5481,319,40749,12138,2,96,2,157.02,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1164,5481,319,40749,12138,2,67,2,32.98,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1165,5481,319,40749,12138,2,96,2,159.82,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1166,5481,319,40749,12138,2,67,2,16.78,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1167,5481,319,40749,12138,2,13,1,366.60,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1168,5481,320,40749,12138,2,96,2,140.50,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1169,5481,320,40749,12138,2,67,2,29.50,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1170,5481,320,40749,12138,2,13,1,170.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1171,5481,321,40749,12138,2,96,2,159.82,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1172,5481,321,40749,12138,2,67,2,16.78,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1173,5481,321,40749,12138,2,96,2,1018.19,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1174,5481,321,40749,12138,2,67,2,213.81,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1175,5481,321,40749,12138,2,13,1,1408.60,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1176,5481,322,40749,12138,2,96,2,570.25,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL);
INSERT INTO `balance_libro_details` VALUES (1177,5481,322,40749,12138,2,67,2,119.75,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1178,5481,322,40749,12138,2,13,1,690.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1179,5481,323,40749,12138,2,96,2,264.46,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1180,5481,323,40749,12138,2,67,2,55.54,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1181,5481,323,40749,12138,2,13,1,320.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1182,5481,324,40749,12138,2,96,2,443.44,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1183,5481,324,40749,12138,2,67,2,46.56,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1184,5481,324,40749,12138,2,96,2,671.90,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1185,5481,324,40749,12138,2,67,2,141.10,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1186,5481,324,40749,12138,2,13,1,1303.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1187,5481,325,40749,12138,2,96,2,272.73,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1188,5481,325,40749,12138,2,67,2,57.27,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1189,5481,325,40749,12138,2,96,2,855.20,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1190,5481,325,40749,12138,2,67,2,89.80,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1191,5481,325,40749,12138,2,13,1,1275.00,NULL,'2021-08-09 16:22:32','2021-08-09 16:22:32',NULL),(1192,5481,326,40749,12138,2,96,2,976.85,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1193,5481,326,40749,12138,2,67,2,205.16,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1194,5481,326,40749,12138,2,96,2,300.90,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1195,5481,326,40749,12138,2,67,2,31.59,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1196,5481,326,40749,12138,2,13,1,1514.50,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1197,5481,327,40749,12138,2,96,2,685.94,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1198,5481,327,40749,12138,2,67,2,144.05,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1199,5481,327,40749,12138,2,96,2,181.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1200,5481,327,40749,12138,2,67,2,19.01,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1201,5481,327,40749,12138,2,13,1,1030.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1202,5481,328,40749,12138,2,96,2,66.12,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1203,5481,328,40749,12138,2,67,2,13.88,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1204,5481,328,40749,12138,2,13,1,80.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1205,5481,329,40749,12138,2,96,2,880.17,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1206,5481,329,40749,12138,2,67,2,184.83,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1207,5481,329,40749,12138,2,13,1,1065.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1208,5481,330,40749,12138,2,96,2,342.15,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1209,5481,330,40749,12138,2,67,2,71.85,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1210,5481,330,40749,12138,2,96,2,50.68,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1211,5481,330,40749,12138,2,67,2,5.32,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1212,5481,330,40749,12138,2,13,1,470.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1213,5481,331,40749,12138,2,96,2,357.85,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1214,5481,331,40749,12138,2,67,2,75.15,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1215,5481,331,40749,12138,2,96,2,90.50,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1216,5481,331,40749,12138,2,67,2,9.50,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1217,5481,331,40749,12138,2,13,1,533.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL);
INSERT INTO `balance_libro_details` VALUES (1218,5481,332,40749,12138,2,96,2,515.47,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1219,5481,332,40749,12138,2,67,2,54.13,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1220,5481,332,40749,12138,2,96,2,793.39,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1221,5481,332,40749,12138,2,67,2,166.61,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1222,5481,332,40749,12138,2,13,1,1529.60,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1223,5481,333,40749,12138,2,96,2,533.94,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1224,5481,333,40749,12138,2,67,2,56.06,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1225,5481,333,40749,12138,2,96,2,473.56,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1226,5481,333,40749,12138,2,67,2,99.44,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1227,5481,333,40749,12138,2,13,1,1163.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1228,5481,334,40749,12138,2,96,2,539.11,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1229,5481,334,40749,12138,2,67,2,113.22,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1230,5481,334,40749,12138,2,96,2,134.75,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1231,5481,334,40749,12138,2,67,2,14.15,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1232,5481,334,40749,12138,2,13,1,861.90,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1233,5481,334,40749,12138,2,136,2,60.67,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1234,5481,335,40749,12138,2,96,2,140.50,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1235,5481,335,40749,12138,2,67,2,29.50,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1236,5481,335,40749,12138,2,96,2,26.88,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1237,5481,335,40749,12138,2,67,2,2.82,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1238,5481,335,40749,12138,2,13,1,199.70,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1239,5481,336,40749,12138,2,96,2,1193.62,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1240,5481,336,40749,12138,2,67,2,125.33,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1241,5481,336,40749,12138,2,13,1,1318.95,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1242,5481,337,40749,12138,2,96,2,464.47,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1243,5481,337,40749,12138,2,67,2,97.53,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1244,5481,337,40749,12138,2,13,1,562.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1245,5481,338,40749,12138,2,96,2,239.67,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1246,5481,338,40749,12138,2,67,2,50.33,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1247,5481,338,40749,12138,2,13,1,290.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1248,5481,339,40749,12138,2,96,2,944.06,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1249,5481,339,40749,12138,2,67,2,99.14,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1250,5481,339,40749,12138,2,96,2,123.97,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1251,5481,339,40749,12138,2,67,2,26.03,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1252,5481,339,40749,12138,2,13,1,1193.20,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1253,5481,340,40749,12138,2,96,2,247.11,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1254,5481,340,40749,12138,2,67,2,51.89,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1255,5481,340,40749,12138,2,96,2,561.08,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1256,5481,340,40749,12138,2,67,2,58.92,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1257,5481,340,40749,12138,2,13,1,919.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1258,5481,341,40749,12138,2,96,2,289.26,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL);
INSERT INTO `balance_libro_details` VALUES (1259,5481,341,40749,12138,2,67,2,60.74,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1260,5481,341,40749,12138,2,13,1,350.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1261,5481,342,40749,12138,2,96,2,181.81,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1262,5481,342,40749,12138,2,67,2,38.19,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1263,5481,342,40749,12138,2,13,1,220.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1264,5481,343,40749,12138,2,96,2,487.60,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1265,5481,343,40749,12138,2,67,2,102.40,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1266,5481,343,40749,12138,2,13,1,590.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1267,5481,344,40749,12138,2,96,2,1140.50,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1268,5481,344,40749,12138,2,67,2,239.50,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1269,5481,344,40749,12138,2,13,1,1380.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1270,5481,345,40749,12138,2,96,2,83.47,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1271,5481,345,40749,12138,2,67,2,17.53,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1272,5481,345,40749,12138,2,96,2,469.68,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1273,5481,345,40749,12138,2,67,2,49.32,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1274,5481,345,40749,12138,2,13,1,620.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1275,5481,346,40749,12138,2,96,2,165.29,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1276,5481,346,40749,12138,2,67,2,34.71,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1277,5481,346,40749,12138,2,13,1,200.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1278,5481,347,40749,12138,2,96,2,479.34,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1279,5481,347,40749,12138,2,67,2,100.66,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1280,5481,347,40749,12138,2,13,1,580.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1281,5481,348,40749,12138,2,96,2,214.88,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1282,5481,348,40749,12138,2,67,2,45.12,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1283,5481,348,40749,12138,2,13,1,260.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1284,5481,349,40749,12138,2,96,2,74.38,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1285,5481,349,40749,12138,2,67,2,15.62,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1286,5481,349,40749,12138,2,13,1,90.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1287,5481,350,40749,12138,2,96,2,1224.17,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1288,5481,350,40749,12138,2,67,2,257.08,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1289,5481,350,40749,12138,2,96,2,45.25,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1290,5481,350,40749,12138,2,67,2,4.75,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1291,5481,350,40749,12138,2,13,1,1531.25,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1292,5481,351,40749,12138,2,96,2,252.06,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1293,5481,351,40749,12138,2,67,2,52.94,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1294,5481,351,40749,12138,2,13,1,305.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1295,5481,352,40749,12138,2,96,2,128.10,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1296,5481,352,40749,12138,2,67,2,26.90,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1297,5481,352,40749,12138,2,13,1,155.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1298,5481,353,40749,12138,2,96,2,264.46,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1299,5481,353,40749,12138,2,67,2,55.54,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL);
INSERT INTO `balance_libro_details` VALUES (1300,5481,353,40749,12138,2,13,1,320.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1301,5481,354,40749,12138,2,96,2,677.69,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1302,5481,354,40749,12138,2,67,2,142.31,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1303,5481,354,40749,12138,2,13,1,820.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1304,5481,355,40749,12138,2,96,2,420.50,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1305,5481,355,40749,12138,2,67,2,88.30,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1306,5481,355,40749,12138,2,96,2,189.73,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1307,5481,355,40749,12138,2,67,2,19.92,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1308,5481,355,40749,12138,2,13,1,718.45,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1309,5481,356,40749,12138,2,96,2,2011.54,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1310,5481,356,40749,12138,2,67,2,422.46,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1311,5481,356,40749,12138,2,96,2,639.91,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1312,5481,356,40749,12138,2,67,2,67.19,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1313,5481,356,40749,12138,2,13,1,3141.10,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1314,5481,357,40749,12138,2,96,2,190.07,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1315,5481,357,40749,12138,2,67,2,39.92,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1316,5481,357,40749,12138,2,96,2,423.53,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1317,5481,357,40749,12138,2,67,2,44.48,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1318,5481,357,40749,12138,2,13,1,698.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1319,5481,358,40749,12138,2,96,2,322.31,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1320,5481,358,40749,12138,2,67,2,67.69,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1321,5481,358,40749,12138,2,13,1,390.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1322,5481,359,40749,12138,2,96,2,1119.84,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1323,5481,359,40749,12138,2,67,2,235.16,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1324,5481,359,40749,12138,2,13,1,1355.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1325,5481,360,40749,12138,2,96,2,220.67,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1326,5481,360,40749,12138,2,67,2,46.33,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1327,5481,360,40749,12138,2,96,2,271.49,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1328,5481,360,40749,12138,2,67,2,28.51,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1329,5481,360,40749,12138,2,13,1,567.00,NULL,'2021-08-09 16:22:33','2021-08-09 16:22:33',NULL),(1330,5481,361,40749,12138,2,96,2,103.17,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1331,5481,361,40749,12138,2,67,2,10.83,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1332,5481,361,40749,12138,2,96,2,595.04,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1333,5481,361,40749,12138,2,67,2,124.96,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1334,5481,361,40749,12138,2,13,1,834.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1335,5481,362,40749,12138,2,96,2,281.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1336,5481,362,40749,12138,2,67,2,59.01,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1337,5481,362,40749,12138,2,96,2,622.81,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1338,5481,362,40749,12138,2,67,2,65.38,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1339,5481,362,40749,12138,2,13,1,1028.20,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1340,5481,363,40749,12138,2,96,2,4747.94,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL);
INSERT INTO `balance_libro_details` VALUES (1341,5481,363,40749,12138,2,67,2,997.06,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1342,5481,363,40749,12138,2,13,1,5745.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1343,5481,364,40749,12138,2,96,2,165.28,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1344,5481,364,40749,12138,2,67,2,34.72,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1345,5481,364,40749,12138,2,13,1,200.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1346,5481,365,40749,12138,2,96,2,224.79,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1347,5481,365,40749,12138,2,67,2,47.21,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1348,5481,365,40749,12138,2,96,2,45.25,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1349,5481,365,40749,12138,2,67,2,4.75,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1350,5481,365,40749,12138,2,13,1,322.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1351,5481,366,40749,12138,2,96,2,386.99,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1352,5481,366,40749,12138,2,67,2,81.26,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1353,5481,366,40749,12138,2,13,1,530.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1354,5481,366,40749,12138,2,136,2,61.75,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1355,5481,367,40749,12138,2,96,2,911.37,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1356,5481,367,40749,12138,2,67,2,191.38,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1357,5481,367,40749,12138,2,13,1,1102.75,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1358,5481,368,40749,12138,2,96,2,897.51,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1359,5481,368,40749,12138,2,67,2,188.49,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1360,5481,368,40749,12138,2,13,1,1086.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1361,5481,369,40749,12138,2,96,2,363.64,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1362,5481,369,40749,12138,2,67,2,76.36,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1363,5481,369,40749,12138,2,13,1,440.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1364,5481,370,40749,12138,2,96,2,2900.81,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1365,5481,370,40749,12138,2,67,2,609.19,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1366,5481,370,40749,12138,2,96,2,165.88,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1367,5481,370,40749,12138,2,67,2,17.42,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1368,5481,370,40749,12138,2,13,1,3693.30,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1369,5481,371,40749,12138,2,96,2,312.60,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1370,5481,371,40749,12138,2,67,2,65.65,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1371,5481,371,40749,12138,2,13,1,440.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1372,5481,371,40749,12138,2,136,2,61.75,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1373,5481,372,40749,12138,2,96,2,123.96,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1374,5481,372,40749,12138,2,67,2,26.04,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1375,5481,372,40749,12138,2,96,2,198.46,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1376,5481,372,40749,12138,2,67,2,20.84,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1377,5481,372,40749,12138,2,13,1,369.30,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1378,5481,373,40749,12138,2,96,2,165.29,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1379,5481,373,40749,12138,2,67,2,34.71,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1380,5481,373,40749,12138,2,13,1,200.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1381,5481,374,40749,12138,2,96,2,433.88,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL);
INSERT INTO `balance_libro_details` VALUES (1382,5481,374,40749,12138,2,67,2,91.12,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1383,5481,374,40749,12138,2,13,1,525.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1384,5481,375,40749,12138,2,96,2,82.64,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1385,5481,375,40749,12138,2,67,2,17.37,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1386,5481,375,40749,12138,2,96,2,104.97,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1387,5481,375,40749,12138,2,67,2,11.02,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1388,5481,375,40749,12138,2,13,1,216.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1389,5481,376,40749,12138,2,96,2,184.80,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1390,5481,376,40749,12138,2,67,2,19.40,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1391,5481,376,40749,12138,2,96,2,600.01,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1392,5481,376,40749,12138,2,67,2,125.99,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1393,5481,376,40749,12138,2,13,1,930.20,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1394,5481,377,40749,12138,2,96,2,256.20,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1395,5481,377,40749,12138,2,67,2,53.79,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1396,5481,377,40749,12138,2,96,2,181.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1397,5481,377,40749,12138,2,67,2,19.01,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1398,5481,377,40749,12138,2,13,1,510.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1399,5481,378,40749,12138,2,96,2,1462.81,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1400,5481,378,40749,12138,2,67,2,307.19,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1401,5481,378,40749,12138,2,13,1,1770.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1402,5481,379,40749,12138,2,96,2,719.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1403,5481,379,40749,12138,2,67,2,151.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1404,5481,379,40749,12138,2,13,1,870.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1405,5481,380,40749,12138,2,96,2,334.70,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1406,5481,380,40749,12138,2,67,2,70.30,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1407,5481,380,40749,12138,2,13,1,405.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1408,5481,381,40749,12138,2,96,2,78.01,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1409,5481,381,40749,12138,2,67,2,8.19,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1410,5481,381,40749,12138,2,96,2,161.16,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1411,5481,381,40749,12138,2,67,2,33.84,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1412,5481,381,40749,12138,2,13,1,281.20,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1413,5481,382,40749,12138,2,96,2,1262.80,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1414,5481,382,40749,12138,2,67,2,265.20,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1415,5481,382,40749,12138,2,13,1,1528.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1416,5481,383,40749,12138,2,96,2,510.75,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1417,5481,383,40749,12138,2,67,2,107.25,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1418,5481,383,40749,12138,2,13,1,618.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1419,5481,384,40749,12138,2,96,2,388.43,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1420,5481,384,40749,12138,2,67,2,81.57,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1421,5481,384,40749,12138,2,13,1,470.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1422,5481,385,40749,12138,2,96,2,747.92,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL);
INSERT INTO `balance_libro_details` VALUES (1423,5481,385,40749,12138,2,67,2,157.08,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1424,5481,385,40749,12138,2,96,2,50.77,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1425,5481,385,40749,12138,2,67,2,5.33,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1426,5481,385,40749,12138,2,13,1,961.10,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1427,5481,386,40749,12138,2,96,2,252.94,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1428,5481,386,40749,12138,2,67,2,26.56,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1429,5481,386,40749,12138,2,96,2,785.13,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1430,5481,386,40749,12138,2,67,2,164.87,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1431,5481,386,40749,12138,2,13,1,1229.50,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1432,5481,387,40749,12138,2,96,2,66.70,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1433,5481,387,40749,12138,2,67,2,7.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1434,5481,387,40749,12138,2,96,2,784.28,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1435,5481,387,40749,12138,2,67,2,164.72,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1436,5481,387,40749,12138,2,13,1,1022.70,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1437,5481,388,40749,12138,2,96,2,90.50,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1438,5481,388,40749,12138,2,67,2,9.50,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1439,5481,388,40749,12138,2,96,2,380.16,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1440,5481,388,40749,12138,2,67,2,79.84,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1441,5481,388,40749,12138,2,13,1,560.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1442,5481,389,40749,12138,2,96,2,1247.94,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1443,5481,389,40749,12138,2,67,2,262.06,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1444,5481,389,40749,12138,2,13,1,1510.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1445,5481,390,40749,12138,2,96,2,502.89,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1446,5481,390,40749,12138,2,67,2,105.61,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1447,5481,390,40749,12138,2,96,2,76.56,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1448,5481,390,40749,12138,2,67,2,8.04,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1449,5481,390,40749,12138,2,13,1,693.10,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1450,5481,391,40749,12138,2,96,2,82.64,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1451,5481,391,40749,12138,2,67,2,17.36,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1452,5481,391,40749,12138,2,13,1,100.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1453,5481,392,40749,12138,2,96,2,650.42,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1454,5481,392,40749,12138,2,67,2,136.58,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1455,5481,392,40749,12138,2,13,1,787.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1456,5481,393,40749,12138,2,96,2,512.40,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1457,5481,393,40749,12138,2,67,2,107.60,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1458,5481,393,40749,12138,2,13,1,620.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1459,5481,394,40749,12138,2,96,2,562.80,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1460,5481,394,40749,12138,2,67,2,118.20,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1461,5481,394,40749,12138,2,96,2,50.68,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1462,5481,394,40749,12138,2,67,2,5.32,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1463,5481,394,40749,12138,2,13,1,737.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL);
INSERT INTO `balance_libro_details` VALUES (1464,5481,395,40749,12138,2,96,2,2724.79,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1465,5481,395,40749,12138,2,67,2,572.21,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1466,5481,395,40749,12138,2,13,1,3297.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1467,5481,396,40749,12138,2,96,2,342.97,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1468,5481,396,40749,12138,2,67,2,72.03,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1469,5481,396,40749,12138,2,13,1,415.00,NULL,'2021-08-09 16:22:34','2021-08-09 16:22:34',NULL),(1470,5481,397,40749,12138,2,96,2,474.62,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1471,5481,397,40749,12138,2,67,2,49.83,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1472,5481,397,40749,12138,2,96,2,371.90,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1473,5481,397,40749,12138,2,67,2,78.10,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1474,5481,397,40749,12138,2,13,1,974.45,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1475,5481,398,40749,12138,2,96,2,108.60,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1476,5481,398,40749,12138,2,67,2,11.40,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1477,5481,398,40749,12138,2,96,2,1164.41,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1478,5481,398,40749,12138,2,67,2,244.53,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1479,5481,398,40749,12138,2,13,1,1700.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1480,5481,398,40749,12138,2,136,2,171.06,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1481,5481,399,40749,12138,2,96,2,214.88,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1482,5481,399,40749,12138,2,67,2,45.12,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1483,5481,399,40749,12138,2,13,1,260.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1484,5481,400,40749,12138,2,96,2,437.19,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1485,5481,400,40749,12138,2,67,2,91.81,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1486,5481,400,40749,12138,2,13,1,529.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1487,5481,401,40749,12138,2,96,2,271.90,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1488,5481,401,40749,12138,2,67,2,57.10,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1489,5481,401,40749,12138,2,13,1,329.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1490,5481,402,40749,12138,2,96,2,1413.22,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1491,5481,402,40749,12138,2,67,2,296.78,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1492,5481,402,40749,12138,2,96,2,470.77,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1493,5481,402,40749,12138,2,67,2,49.43,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1494,5481,402,40749,12138,2,13,1,2230.20,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1495,5481,403,40749,12138,2,96,2,223.14,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1496,5481,403,40749,12138,2,67,2,46.86,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1497,5481,403,40749,12138,2,13,1,270.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1498,5481,404,40749,12138,2,96,2,1419.82,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1499,5481,404,40749,12138,2,67,2,298.18,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1500,5481,404,40749,12138,2,96,2,236.65,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1501,5481,404,40749,12138,2,67,2,24.85,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1502,5481,404,40749,12138,2,13,1,1979.50,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1503,5481,405,40749,12138,2,96,2,400.83,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1504,5481,405,40749,12138,2,67,2,84.17,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL);
INSERT INTO `balance_libro_details` VALUES (1505,5481,405,40749,12138,2,13,1,485.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1506,5481,406,40749,12138,2,96,2,743.80,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1507,5481,406,40749,12138,2,67,2,156.20,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1508,5481,406,40749,12138,2,13,1,900.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1509,5481,407,40749,12138,2,96,2,429.75,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1510,5481,407,40749,12138,2,67,2,90.25,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1511,5481,407,40749,12138,2,96,2,54.30,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1512,5481,407,40749,12138,2,67,2,5.70,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1513,5481,407,40749,12138,2,13,1,580.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1514,5481,408,40749,12138,2,96,2,566.11,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1515,5481,408,40749,12138,2,67,2,118.89,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1516,5481,408,40749,12138,2,96,2,478.73,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1517,5481,408,40749,12138,2,67,2,50.27,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1518,5481,408,40749,12138,2,13,1,1214.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1519,5481,409,40749,12138,2,96,2,322.31,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1520,5481,409,40749,12138,2,67,2,67.69,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1521,5481,409,40749,12138,2,13,1,390.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1522,5481,410,40749,12138,2,96,2,693.40,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1523,5481,410,40749,12138,2,67,2,145.60,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1524,5481,410,40749,12138,2,96,2,171.94,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1525,5481,410,40749,12138,2,67,2,18.06,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1526,5481,410,40749,12138,2,13,1,1029.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1527,5481,411,40749,12138,2,96,2,777.18,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1528,5481,411,40749,12138,2,67,2,163.20,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1529,5481,411,40749,12138,2,13,1,1005.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1530,5481,411,40749,12138,2,136,2,64.62,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1531,5481,412,40749,12138,2,96,2,400.83,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1532,5481,412,40749,12138,2,67,2,84.17,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1533,5481,412,40749,12138,2,96,2,259.78,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1534,5481,412,40749,12138,2,67,2,27.27,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1535,5481,412,40749,12138,2,13,1,772.05,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1536,5481,413,40749,12138,2,96,2,468.61,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1537,5481,413,40749,12138,2,67,2,98.39,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1538,5481,413,40749,12138,2,96,2,78.73,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1539,5481,413,40749,12138,2,67,2,8.27,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1540,5481,413,40749,12138,2,13,1,654.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1541,5481,414,40749,12138,2,96,2,421.49,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1542,5481,414,40749,12138,2,67,2,88.51,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1543,5481,414,40749,12138,2,96,2,99.55,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1544,5481,414,40749,12138,2,67,2,10.45,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1545,5481,414,40749,12138,2,13,1,620.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL);
INSERT INTO `balance_libro_details` VALUES (1546,5481,415,40749,12138,2,96,2,396.70,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1547,5481,415,40749,12138,2,67,2,83.30,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1548,5481,415,40749,12138,2,13,1,480.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1549,5481,416,40749,12138,2,96,2,834.71,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1550,5481,416,40749,12138,2,67,2,175.29,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1551,5481,416,40749,12138,2,96,2,144.80,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1552,5481,416,40749,12138,2,67,2,15.20,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1553,5481,416,40749,12138,2,13,1,1170.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1554,5481,417,40749,12138,2,96,2,1542.15,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1555,5481,417,40749,12138,2,67,2,323.85,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1556,5481,417,40749,12138,2,96,2,67.87,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1557,5481,417,40749,12138,2,67,2,7.13,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1558,5481,417,40749,12138,2,13,1,1941.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1559,5481,418,40749,12138,2,96,2,281.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1560,5481,418,40749,12138,2,67,2,59.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1561,5481,418,40749,12138,2,13,1,340.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1562,5481,419,40749,12138,2,96,2,501.65,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1563,5481,419,40749,12138,2,67,2,105.35,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1564,5481,419,40749,12138,2,96,2,47.96,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1565,5481,419,40749,12138,2,67,2,5.04,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1566,5481,419,40749,12138,2,13,1,660.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1567,5481,420,40749,12138,2,96,2,140.50,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1568,5481,420,40749,12138,2,67,2,29.50,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1569,5481,420,40749,12138,2,96,2,99.55,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1570,5481,420,40749,12138,2,67,2,10.45,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1571,5481,420,40749,12138,2,13,1,280.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1572,5481,421,40749,12138,2,96,2,223.14,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1573,5481,421,40749,12138,2,67,2,46.86,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1574,5481,421,40749,12138,2,13,1,270.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1575,5481,422,40749,12138,2,96,2,165.29,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1576,5481,422,40749,12138,2,67,2,34.71,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1577,5481,422,40749,12138,2,96,2,343.89,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1578,5481,422,40749,12138,2,67,2,36.11,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1579,5481,422,40749,12138,2,13,1,580.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1580,5481,423,40749,12138,2,96,2,380.16,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1581,5481,423,40749,12138,2,67,2,79.84,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1582,5481,423,40749,12138,2,13,1,460.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1583,5481,424,40749,12138,2,96,2,293.39,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1584,5481,424,40749,12138,2,67,2,61.61,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1585,5481,424,40749,12138,2,13,1,355.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1586,5481,425,40749,12138,2,96,2,1144.63,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL);
INSERT INTO `balance_libro_details` VALUES (1587,5481,425,40749,12138,2,67,2,240.37,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1588,5481,425,40749,12138,2,13,1,1385.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1589,5481,426,40749,12138,2,96,2,173.56,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1590,5481,426,40749,12138,2,67,2,36.44,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1591,5481,426,40749,12138,2,13,1,210.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1592,5481,427,40749,12138,2,96,2,852.90,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1593,5481,427,40749,12138,2,67,2,179.10,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1594,5481,427,40749,12138,2,13,1,1032.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1595,5481,428,40749,12138,2,96,2,37.19,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1596,5481,428,40749,12138,2,67,2,7.81,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1597,5481,428,40749,12138,2,13,1,45.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1598,5481,429,40749,12138,2,96,2,123.97,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1599,5481,429,40749,12138,2,67,2,26.03,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1600,5481,429,40749,12138,2,13,1,150.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1601,5481,430,40749,12138,2,96,2,454.55,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1602,5481,430,40749,12138,2,67,2,95.45,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1603,5481,430,40749,12138,2,13,1,550.00,NULL,'2021-08-09 16:22:35','2021-08-09 16:22:35',NULL),(1604,5481,431,40749,12138,2,96,2,342.98,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1605,5481,431,40749,12138,2,67,2,72.02,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1606,5481,431,40749,12138,2,13,1,415.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1607,5481,432,40749,12138,2,96,2,1085.94,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1608,5481,432,40749,12138,2,67,2,228.07,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1609,5481,432,40749,12138,2,96,2,282.03,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1610,5481,432,40749,12138,2,67,2,29.61,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1611,5481,432,40749,12138,2,13,1,1625.65,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1612,5481,433,40749,12138,2,96,2,685.94,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1613,5481,433,40749,12138,2,67,2,144.05,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1614,5481,433,40749,12138,2,13,1,1010.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1615,5481,433,40749,12138,2,136,2,180.01,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1616,5481,434,40749,12138,2,96,2,66.12,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1617,5481,434,40749,12138,2,67,2,13.88,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1618,5481,434,40749,12138,2,13,1,80.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1619,5481,435,40749,12138,2,96,2,276.23,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1620,5481,435,40749,12138,2,67,2,58.03,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1621,5481,435,40749,12138,2,96,2,121.62,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1622,5481,435,40749,12138,2,67,2,12.77,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1623,5481,435,40749,12138,2,13,1,468.65,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1624,5481,436,40749,12138,2,96,2,52.07,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1625,5481,436,40749,12138,2,67,2,10.93,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1626,5481,436,40749,12138,2,13,1,63.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1627,5481,437,40749,12138,2,96,2,4376.06,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL);
INSERT INTO `balance_libro_details` VALUES (1628,5481,437,40749,12138,2,67,2,918.94,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1629,5481,437,40749,12138,2,96,2,982.35,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1630,5481,437,40749,12138,2,67,2,103.15,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1631,5481,437,40749,12138,2,13,1,6380.50,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1632,5481,438,40749,12138,2,96,2,469.43,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1633,5481,438,40749,12138,2,67,2,98.57,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1634,5481,438,40749,12138,2,13,1,568.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1635,5481,439,40749,12138,2,96,2,293.39,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1636,5481,439,40749,12138,2,67,2,61.61,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1637,5481,439,40749,12138,2,96,2,102.53,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1638,5481,439,40749,12138,2,67,2,10.77,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1639,5481,439,40749,12138,2,13,1,468.30,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1640,5481,440,40749,12138,2,96,2,595.04,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1641,5481,440,40749,12138,2,67,2,124.96,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1642,5481,440,40749,12138,2,13,1,720.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1643,5481,441,40749,12138,2,96,2,181.82,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1644,5481,441,40749,12138,2,67,2,38.18,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1645,5481,441,40749,12138,2,13,1,220.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1646,5481,442,40749,12138,2,96,2,91.74,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1647,5481,442,40749,12138,2,67,2,19.26,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1648,5481,442,40749,12138,2,13,1,111.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1649,5481,443,40749,12138,2,96,2,402.49,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1650,5481,443,40749,12138,2,67,2,84.51,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1651,5481,443,40749,12138,2,13,1,487.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1652,5481,444,40749,12138,2,96,2,385.95,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1653,5481,444,40749,12138,2,67,2,81.05,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1654,5481,444,40749,12138,2,13,1,467.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1655,5481,445,40749,12138,2,96,2,375.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1656,5481,445,40749,12138,2,67,2,78.75,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1657,5481,445,40749,12138,2,96,2,26.88,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1658,5481,445,40749,12138,2,67,2,2.82,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1659,5481,445,40749,12138,2,13,1,483.45,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1660,5481,446,40749,12138,2,96,2,1395.67,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1661,5481,446,40749,12138,2,67,2,293.10,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1662,5481,446,40749,12138,2,13,1,1810.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1663,5481,446,40749,12138,2,136,2,121.23,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1664,5481,447,40749,12138,2,96,2,510.74,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1665,5481,447,40749,12138,2,67,2,107.27,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1666,5481,447,40749,12138,2,96,2,104.52,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1667,5481,447,40749,12138,2,67,2,10.97,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1668,5481,447,40749,12138,2,13,1,733.50,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL);
INSERT INTO `balance_libro_details` VALUES (1669,5481,448,40749,12138,2,96,2,327.38,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1670,5481,448,40749,12138,2,67,2,34.37,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1671,5481,448,40749,12138,2,96,2,466.95,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1672,5481,448,40749,12138,2,67,2,98.05,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1673,5481,448,40749,12138,2,13,1,926.75,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1674,5481,449,40749,12138,2,96,2,1057.85,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1675,5481,449,40749,12138,2,67,2,222.15,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1676,5481,449,40749,12138,2,13,1,1280.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1677,5481,450,40749,12138,2,96,2,692.31,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1678,5481,450,40749,12138,2,67,2,145.40,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1679,5481,450,40749,12138,2,13,1,870.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1680,5481,450,40749,12138,2,136,2,32.29,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1681,5481,451,40749,12138,2,96,2,2818.18,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1682,5481,451,40749,12138,2,67,2,591.82,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1683,5481,451,40749,12138,2,13,1,3410.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1684,5481,452,40749,12138,2,96,2,595.04,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1685,5481,452,40749,12138,2,67,2,124.96,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1686,5481,452,40749,12138,2,96,2,194.66,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1687,5481,452,40749,12138,2,67,2,20.44,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1688,5481,452,40749,12138,2,13,1,935.10,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1689,5481,453,40749,12138,2,96,2,181.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1690,5481,453,40749,12138,2,67,2,19.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1691,5481,453,40749,12138,2,13,1,200.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1692,5481,454,40749,12138,2,96,2,1099.18,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1693,5481,454,40749,12138,2,67,2,230.82,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1694,5481,454,40749,12138,2,13,1,1330.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1695,5481,455,40749,12138,2,96,2,140.50,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1696,5481,455,40749,12138,2,67,2,29.50,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1697,5481,455,40749,12138,2,13,1,170.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1698,5481,456,40749,12138,2,96,2,937.20,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1699,5481,456,40749,12138,2,67,2,196.80,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1700,5481,456,40749,12138,2,96,2,195.20,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1701,5481,456,40749,12138,2,67,2,20.50,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1702,5481,456,40749,12138,2,13,1,1349.70,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1703,5481,457,40749,12138,2,96,2,247.93,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1704,5481,457,40749,12138,2,67,2,52.07,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1705,5481,457,40749,12138,2,13,1,300.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1706,5481,458,40749,12138,2,96,2,1031.40,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1707,5481,458,40749,12138,2,67,2,216.60,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1708,5481,458,40749,12138,2,96,2,49.77,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1709,5481,458,40749,12138,2,67,2,5.23,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL);
INSERT INTO `balance_libro_details` VALUES (1710,5481,458,40749,12138,2,13,1,1303.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1711,5481,459,40749,12138,2,96,2,328.93,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1712,5481,459,40749,12138,2,67,2,69.07,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1713,5481,459,40749,12138,2,96,2,271.49,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1714,5481,459,40749,12138,2,67,2,28.51,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1715,5481,459,40749,12138,2,13,1,698.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1716,5481,460,40749,12138,2,96,2,440.31,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1717,5481,460,40749,12138,2,67,2,92.47,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1718,5481,460,40749,12138,2,96,2,220.63,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1719,5481,460,40749,12138,2,67,2,23.17,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1720,5481,460,40749,12138,2,13,1,863.80,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1721,5481,460,40749,12138,2,136,2,87.22,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1722,5481,461,40749,12138,2,96,2,714.05,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1723,5481,461,40749,12138,2,67,2,149.95,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1724,5481,461,40749,12138,2,96,2,95.93,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1725,5481,461,40749,12138,2,67,2,10.07,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1726,5481,461,40749,12138,2,13,1,970.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1727,5481,462,40749,12138,2,96,2,918.17,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1728,5481,462,40749,12138,2,67,2,192.83,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1729,5481,462,40749,12138,2,13,1,1111.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1730,5481,463,40749,12138,2,96,2,175.21,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1731,5481,463,40749,12138,2,67,2,36.79,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1732,5481,463,40749,12138,2,13,1,212.00,NULL,'2021-08-09 16:22:36','2021-08-09 16:22:36',NULL),(1733,5481,464,40749,12138,2,96,2,152.89,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1734,5481,464,40749,12138,2,67,2,32.11,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1735,5481,464,40749,12138,2,13,1,185.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1736,5481,465,40749,12138,2,96,2,159.87,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1737,5481,465,40749,12138,2,67,2,33.58,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1738,5481,465,40749,12138,2,96,2,90.50,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1739,5481,465,40749,12138,2,67,2,9.50,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1740,5481,465,40749,12138,2,13,1,320.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1741,5481,465,40749,12138,2,136,2,26.55,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1742,5481,466,40749,12138,2,96,2,214.88,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1743,5481,466,40749,12138,2,67,2,45.12,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1744,5481,466,40749,12138,2,96,2,398.19,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1745,5481,466,40749,12138,2,67,2,41.81,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1746,5481,466,40749,12138,2,13,1,700.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1747,5481,467,40749,12138,2,96,2,446.27,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1748,5481,467,40749,12138,2,67,2,93.73,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1749,5481,467,40749,12138,2,13,1,540.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1750,5481,468,40749,12138,2,96,2,1339.52,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1751,5481,468,40749,12138,2,67,2,281.28,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1752,5481,468,40749,12138,2,13,1,1620.80,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1753,5481,469,40749,12138,2,96,2,863.64,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1754,5481,469,40749,12138,2,67,2,181.36,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1755,5481,469,40749,12138,2,96,2,684.34,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1756,5481,469,40749,12138,2,67,2,71.86,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1757,5481,469,40749,12138,2,13,1,1801.20,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1758,5481,470,40749,12138,2,96,2,561.57,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1759,5481,470,40749,12138,2,67,2,117.93,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1760,5481,470,40749,12138,2,96,2,528.24,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1761,5481,470,40749,12138,2,67,2,55.46,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1762,5481,470,40749,12138,2,13,1,1263.20,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1763,5481,471,40749,12138,2,96,2,595.88,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1764,5481,471,40749,12138,2,67,2,125.12,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1765,5481,471,40749,12138,2,96,2,205.97,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1766,5481,471,40749,12138,2,67,2,21.63,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1767,5481,471,40749,12138,2,13,1,948.60,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1768,5481,472,40749,12138,2,96,2,403.30,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1769,5481,472,40749,12138,2,67,2,84.70,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1770,5481,472,40749,12138,2,13,1,488.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1771,5481,473,40749,12138,2,96,2,108.60,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1772,5481,473,40749,12138,2,67,2,11.40,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1773,5481,473,40749,12138,2,13,1,120.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1774,5481,474,40749,12138,2,96,2,428.10,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1775,5481,474,40749,12138,2,67,2,89.90,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1776,5481,474,40749,12138,2,13,1,518.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1777,5481,475,40749,12138,2,96,2,561.98,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1778,5481,475,40749,12138,2,67,2,118.02,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1779,5481,475,40749,12138,2,13,1,680.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1780,5481,476,40749,12138,2,96,2,61.98,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1781,5481,476,40749,12138,2,67,2,13.02,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1782,5481,476,40749,12138,2,13,1,75.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1783,5481,477,40749,12138,2,96,2,621.72,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1784,5481,477,40749,12138,2,67,2,65.28,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1785,5481,477,40749,12138,2,13,1,687.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1786,5481,478,40749,12138,2,96,2,161.16,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1787,5481,478,40749,12138,2,67,2,33.84,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1788,5481,478,40749,12138,2,13,1,195.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1789,5481,479,40749,12138,2,96,2,199.58,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1790,5481,479,40749,12138,2,67,2,41.92,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1791,5481,479,40749,12138,2,13,1,241.50,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1792,5481,480,40749,12138,2,96,2,768.59,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1793,5481,480,40749,12138,2,67,2,161.41,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1794,5481,480,40749,12138,2,13,1,930.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1795,5481,481,40749,12138,2,96,2,243.80,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1796,5481,481,40749,12138,2,67,2,51.20,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1797,5481,481,40749,12138,2,13,1,295.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1798,5481,482,40749,12138,2,96,2,116.74,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1799,5481,482,40749,12138,2,67,2,12.26,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1800,5481,482,40749,12138,2,96,2,285.13,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1801,5481,482,40749,12138,2,67,2,59.87,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1802,5481,482,40749,12138,2,13,1,474.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1803,5481,483,40749,12138,2,96,2,152.89,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1804,5481,483,40749,12138,2,67,2,32.11,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1805,5481,483,40749,12138,2,13,1,185.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1806,5481,484,40749,12138,2,96,2,321.29,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1807,5481,484,40749,12138,2,67,2,67.48,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1808,5481,484,40749,12138,2,13,1,510.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1809,5481,484,40749,12138,2,136,2,121.23,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1810,5481,485,40749,12138,2,96,2,303.31,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1811,5481,485,40749,12138,2,67,2,63.69,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1812,5481,485,40749,12138,2,13,1,367.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1813,5481,486,40749,12138,2,96,2,288.69,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1814,5481,486,40749,12138,2,67,2,30.31,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1815,5481,486,40749,12138,2,96,2,825.62,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1816,5481,486,40749,12138,2,67,2,173.38,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1817,5481,486,40749,12138,2,13,1,1318.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1818,5481,487,40749,12138,2,96,2,371.90,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1819,5481,487,40749,12138,2,67,2,78.10,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1820,5481,487,40749,12138,2,13,1,450.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1821,5481,488,40749,12138,2,96,2,695.04,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1822,5481,488,40749,12138,2,67,2,145.96,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1823,5481,488,40749,12138,2,13,1,841.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1824,5481,489,40749,12138,2,96,2,454.54,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1825,5481,489,40749,12138,2,67,2,95.46,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1826,5481,489,40749,12138,2,13,1,550.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1827,5481,490,40749,12138,2,96,2,247.93,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1828,5481,490,40749,12138,2,67,2,52.07,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1829,5481,490,40749,12138,2,96,2,314.80,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1830,5481,490,40749,12138,2,67,2,33.05,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1831,5481,490,40749,12138,2,13,1,647.85,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1832,5481,491,40749,12138,2,96,2,344.25,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1833,5481,491,40749,12138,2,67,2,72.30,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1834,5481,491,40749,12138,2,13,1,479.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1835,5481,491,40749,12138,2,136,2,62.45,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1836,5481,492,40749,12138,2,96,2,289.26,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1837,5481,492,40749,12138,2,67,2,60.74,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1838,5481,492,40749,12138,2,13,1,350.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1839,5481,493,40749,12138,2,96,2,337.19,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1840,5481,493,40749,12138,2,67,2,70.81,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1841,5481,493,40749,12138,2,96,2,217.19,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1842,5481,493,40749,12138,2,67,2,22.81,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1843,5481,493,40749,12138,2,13,1,648.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1844,5481,494,40749,12138,2,96,2,563.26,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1845,5481,494,40749,12138,2,67,2,59.14,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1846,5481,494,40749,12138,2,96,2,889.27,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1847,5481,494,40749,12138,2,67,2,186.73,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1848,5481,494,40749,12138,2,13,1,1698.40,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1849,5481,495,40749,12138,2,96,2,388.42,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1850,5481,495,40749,12138,2,67,2,81.58,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1851,5481,495,40749,12138,2,13,1,470.00,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1852,5481,496,40749,12138,2,96,2,1022.93,NULL,'2021-08-09 16:22:37','2021-08-09 16:22:37',NULL),(1853,5481,496,40749,12138,2,67,2,214.81,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1854,5481,496,40749,12138,2,96,2,481.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1855,5481,496,40749,12138,2,67,2,50.51,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1856,5481,496,40749,12138,2,13,1,1769.25,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1857,5481,497,40749,12138,2,96,2,2294.63,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1858,5481,497,40749,12138,2,67,2,481.87,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1859,5481,497,40749,12138,2,96,2,424.66,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1860,5481,497,40749,12138,2,67,2,44.59,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1861,5481,497,40749,12138,2,13,1,3245.75,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1862,5481,498,40749,12138,2,96,2,214.88,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1863,5481,498,40749,12138,2,67,2,45.12,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1864,5481,498,40749,12138,2,96,2,248.87,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1865,5481,498,40749,12138,2,67,2,26.13,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1866,5481,498,40749,12138,2,13,1,535.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1867,5481,499,40749,12138,2,96,2,1347.52,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1868,5481,499,40749,12138,2,67,2,282.98,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1869,5481,499,40749,12138,2,13,1,1877.50,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1870,5481,499,40749,12138,2,136,2,247.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1871,5481,500,40749,12138,2,96,2,190.05,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1872,5481,500,40749,12138,2,67,2,19.95,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1873,5481,500,40749,12138,2,13,1,210.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL);
INSERT INTO `balance_libro_details` VALUES (1874,5481,501,40749,12138,2,96,2,231.41,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1875,5481,501,40749,12138,2,67,2,48.59,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1876,5481,501,40749,12138,2,13,1,280.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1877,5481,502,40749,12138,2,96,2,54.30,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1878,5481,502,40749,12138,2,67,2,5.70,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1879,5481,502,40749,12138,2,96,2,214.88,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1880,5481,502,40749,12138,2,67,2,45.12,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1881,5481,502,40749,12138,2,13,1,320.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1882,5481,503,40749,12138,2,96,2,426.44,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1883,5481,503,40749,12138,2,67,2,89.56,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1884,5481,503,40749,12138,2,13,1,516.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1885,5481,504,40749,12138,2,96,2,1638.03,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1886,5481,504,40749,12138,2,67,2,343.97,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1887,5481,504,40749,12138,2,13,1,1982.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1888,5481,505,40749,12138,2,96,2,945.17,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1889,5481,505,40749,12138,2,67,2,198.49,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1890,5481,505,40749,12138,2,96,2,95.02,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1891,5481,505,40749,12138,2,67,2,9.98,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1892,5481,505,40749,12138,2,13,1,1370.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1893,5481,505,40749,12138,2,136,2,121.34,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1894,5481,506,40749,12138,2,96,2,107.44,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1895,5481,506,40749,12138,2,67,2,22.56,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1896,5481,506,40749,12138,2,13,1,130.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1897,5481,507,40749,12138,2,96,2,706.61,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1898,5481,507,40749,12138,2,67,2,148.39,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1899,5481,507,40749,12138,2,13,1,855.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1900,5481,508,40749,12138,2,96,2,211.98,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1901,5481,508,40749,12138,2,67,2,44.52,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1902,5481,508,40749,12138,2,13,1,256.50,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1903,5481,509,40749,12138,2,96,2,1460.82,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1904,5481,509,40749,12138,2,67,2,306.78,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1905,5481,509,40749,12138,2,13,1,1767.60,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1906,5481,510,40749,12138,2,96,2,644.63,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1907,5481,510,40749,12138,2,67,2,135.37,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1908,5481,510,40749,12138,2,13,1,780.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1909,5481,511,40749,12138,2,96,2,882.64,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1910,5481,511,40749,12138,2,67,2,185.35,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1911,5481,511,40749,12138,2,96,2,181.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1912,5481,511,40749,12138,2,67,2,19.01,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1913,5481,511,40749,12138,2,13,1,1268.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1914,5481,512,40749,12138,2,96,2,708.85,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL);
INSERT INTO `balance_libro_details` VALUES (1915,5481,512,40749,12138,2,67,2,148.86,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1916,5481,512,40749,12138,2,13,1,890.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1917,5481,512,40749,12138,2,136,2,32.29,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1918,5481,513,40749,12138,2,96,2,661.16,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1919,5481,513,40749,12138,2,67,2,138.84,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1920,5481,513,40749,12138,2,13,1,800.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1921,5481,514,40749,12138,2,96,2,95.04,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1922,5481,514,40749,12138,2,67,2,19.96,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1923,5481,514,40749,12138,2,13,1,115.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1924,5481,515,40749,12138,2,96,2,1322.30,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1925,5481,515,40749,12138,2,67,2,277.70,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1926,5481,515,40749,12138,2,13,1,1600.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1927,5481,516,40749,12138,2,96,2,1338.02,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1928,5481,516,40749,12138,2,67,2,280.98,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1929,5481,516,40749,12138,2,96,2,96.56,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1930,5481,516,40749,12138,2,67,2,10.14,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1931,5481,516,40749,12138,2,13,1,1725.70,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1932,5481,517,40749,12138,2,96,2,296.38,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1933,5481,517,40749,12138,2,67,2,31.12,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1934,5481,517,40749,12138,2,96,2,330.58,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1935,5481,517,40749,12138,2,67,2,69.42,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1936,5481,517,40749,12138,2,13,1,727.50,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1937,5481,518,40749,12138,2,96,2,347.11,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1938,5481,518,40749,12138,2,67,2,72.89,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1939,5481,518,40749,12138,2,13,1,420.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1940,5481,519,40749,12138,2,96,2,2727.27,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1941,5481,519,40749,12138,2,67,2,572.73,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1942,5481,519,40749,12138,2,13,1,3300.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1943,5481,520,40749,12138,2,96,2,393.35,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1944,5481,520,40749,12138,2,67,2,41.30,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1945,5481,520,40749,12138,2,96,2,495.86,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1946,5481,520,40749,12138,2,67,2,104.14,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1947,5481,520,40749,12138,2,13,1,1034.65,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1948,5481,521,40749,12138,2,96,2,237.19,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1949,5481,521,40749,12138,2,67,2,49.81,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1950,5481,521,40749,12138,2,13,1,287.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1951,5481,522,40749,12138,2,96,2,305.78,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1952,5481,522,40749,12138,2,67,2,64.22,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1953,5481,522,40749,12138,2,13,1,370.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1954,5481,523,40749,12138,2,96,2,388.43,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1955,5481,523,40749,12138,2,67,2,81.57,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL);
INSERT INTO `balance_libro_details` VALUES (1956,5481,523,40749,12138,2,13,1,470.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1957,5481,524,40749,12138,2,96,2,264.47,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1958,5481,524,40749,12138,2,67,2,55.53,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1959,5481,524,40749,12138,2,96,2,101.36,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1960,5481,524,40749,12138,2,67,2,10.64,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1961,5481,524,40749,12138,2,13,1,432.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1962,5481,525,40749,12138,2,96,2,669.42,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1963,5481,525,40749,12138,2,67,2,140.58,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1964,5481,525,40749,12138,2,13,1,810.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1965,5481,526,40749,12138,2,96,2,1332.64,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1966,5481,526,40749,12138,2,67,2,279.86,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1967,5481,526,40749,12138,2,96,2,401.45,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1968,5481,526,40749,12138,2,67,2,42.15,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1969,5481,526,40749,12138,2,13,1,2056.10,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1970,5481,527,40749,12138,2,96,2,301.66,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1971,5481,527,40749,12138,2,67,2,63.34,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1972,5481,527,40749,12138,2,13,1,365.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1973,5481,528,40749,12138,2,96,2,247.94,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1974,5481,528,40749,12138,2,67,2,52.06,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1975,5481,528,40749,12138,2,96,2,90.50,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1976,5481,528,40749,12138,2,67,2,9.50,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1977,5481,528,40749,12138,2,13,1,400.00,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1978,5481,529,40749,12138,2,96,2,590.62,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1979,5481,529,40749,12138,2,67,2,124.03,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1980,5481,529,40749,12138,2,96,2,149.59,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1981,5481,529,40749,12138,2,67,2,15.71,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1982,5481,529,40749,12138,2,13,1,879.95,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1983,5481,530,40749,12138,2,96,2,337.81,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1984,5481,530,40749,12138,2,67,2,70.94,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1985,5481,530,40749,12138,2,96,2,156.02,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1986,5481,530,40749,12138,2,67,2,16.38,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1987,5481,530,40749,12138,2,13,1,581.15,NULL,'2021-08-09 16:22:38','2021-08-09 16:22:38',NULL),(1988,5481,531,40749,12138,2,96,2,429.74,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(1989,5481,531,40749,12138,2,67,2,90.26,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(1990,5481,531,40749,12138,2,96,2,72.58,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(1991,5481,531,40749,12138,2,67,2,7.62,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(1992,5481,531,40749,12138,2,13,1,600.20,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(1993,5481,532,40749,12138,2,96,2,95.02,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(1994,5481,532,40749,12138,2,67,2,9.98,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(1995,5481,532,40749,12138,2,96,2,674.39,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(1996,5481,532,40749,12138,2,67,2,141.61,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL);
INSERT INTO `balance_libro_details` VALUES (1997,5481,532,40749,12138,2,13,1,921.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(1998,5481,533,40749,12138,2,96,2,1053.72,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(1999,5481,533,40749,12138,2,67,2,221.28,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2000,5481,533,40749,12138,2,96,2,135.75,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2001,5481,533,40749,12138,2,67,2,14.25,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2002,5481,533,40749,12138,2,13,1,1425.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2003,5481,534,40749,12138,2,96,2,3948.73,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2004,5481,534,40749,12138,2,67,2,829.27,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2005,5481,534,40749,12138,2,96,2,122.17,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2006,5481,534,40749,12138,2,67,2,12.83,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2007,5481,534,40749,12138,2,13,1,4913.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2008,5481,535,40749,12138,2,96,2,433.88,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2009,5481,535,40749,12138,2,67,2,91.12,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2010,5481,535,40749,12138,2,13,1,525.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2011,5481,536,40749,12138,2,96,2,198.34,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2012,5481,536,40749,12138,2,67,2,41.66,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2013,5481,536,40749,12138,2,13,1,240.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2014,5481,537,40749,12138,2,96,2,380.17,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2015,5481,537,40749,12138,2,67,2,79.83,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2016,5481,537,40749,12138,2,96,2,67.87,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2017,5481,537,40749,12138,2,67,2,7.13,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2018,5481,537,40749,12138,2,13,1,535.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2019,5481,538,40749,12138,2,96,2,157.03,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2020,5481,538,40749,12138,2,67,2,32.97,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2021,5481,538,40749,12138,2,96,2,126.20,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2022,5481,538,40749,12138,2,67,2,13.25,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2023,5481,538,40749,12138,2,13,1,329.45,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2024,5481,539,40749,12138,2,96,2,817.35,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2025,5481,539,40749,12138,2,67,2,171.65,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2026,5481,539,40749,12138,2,13,1,989.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2027,5481,540,40749,12138,2,96,2,78.51,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2028,5481,540,40749,12138,2,67,2,16.49,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2029,5481,540,40749,12138,2,13,1,95.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2030,5481,541,40749,12138,2,96,2,24.79,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2031,5481,541,40749,12138,2,67,2,5.21,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2032,5481,541,40749,12138,2,13,1,30.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2033,5481,542,40749,12138,2,96,2,454.54,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2034,5481,542,40749,12138,2,67,2,95.46,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2035,5481,542,40749,12138,2,96,2,1809.05,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2036,5481,542,40749,12138,2,67,2,189.95,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2037,5481,542,40749,12138,2,13,1,2549.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL);
INSERT INTO `balance_libro_details` VALUES (2038,5481,543,40749,12138,2,96,2,210.75,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2039,5481,543,40749,12138,2,67,2,44.25,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2040,5481,543,40749,12138,2,13,1,255.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2041,5481,544,40749,12138,2,96,2,561.98,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2042,5481,544,40749,12138,2,67,2,118.02,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2043,5481,544,40749,12138,2,13,1,680.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2044,5481,545,40749,12138,2,96,2,710.40,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2045,5481,545,40749,12138,2,67,2,74.60,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2046,5481,545,40749,12138,2,96,2,2798.34,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2047,5481,545,40749,12138,2,67,2,587.66,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2048,5481,545,40749,12138,2,13,1,4171.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2049,5481,546,40749,12138,2,96,2,471.08,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2050,5481,546,40749,12138,2,67,2,98.92,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2051,5481,546,40749,12138,2,13,1,570.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2052,5481,547,40749,12138,2,96,2,172.49,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2053,5481,547,40749,12138,2,67,2,18.11,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2054,5481,547,40749,12138,2,96,2,611.57,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2055,5481,547,40749,12138,2,67,2,128.43,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2056,5481,547,40749,12138,2,13,1,930.60,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2057,5481,548,40749,12138,2,96,2,659.50,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2058,5481,548,40749,12138,2,67,2,138.50,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2059,5481,548,40749,12138,2,96,2,50.27,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2060,5481,548,40749,12138,2,67,2,5.28,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2061,5481,548,40749,12138,2,13,1,853.55,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2062,5481,549,40749,12138,2,96,2,264.52,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2063,5481,549,40749,12138,2,67,2,27.78,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2064,5481,549,40749,12138,2,13,1,292.30,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2065,5481,550,40749,12138,2,96,2,497.93,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2066,5481,550,40749,12138,2,67,2,104.57,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2067,5481,550,40749,12138,2,13,1,602.50,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2068,5481,551,40749,12138,2,96,2,218.18,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2069,5481,551,40749,12138,2,67,2,45.82,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2070,5481,551,40749,12138,2,13,1,264.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2071,5481,552,40749,12138,2,96,2,571.27,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2072,5481,552,40749,12138,2,67,2,59.98,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2073,5481,552,40749,12138,2,96,2,449.59,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2074,5481,552,40749,12138,2,67,2,94.41,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2075,5481,552,40749,12138,2,13,1,1175.25,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2076,5481,553,40749,12138,2,96,2,351.24,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2077,5481,553,40749,12138,2,67,2,73.76,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2078,5481,553,40749,12138,2,13,1,425.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL);
INSERT INTO `balance_libro_details` VALUES (2079,5481,554,40749,12138,2,96,2,392.55,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2080,5481,554,40749,12138,2,67,2,82.45,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2081,5481,554,40749,12138,2,96,2,132.81,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2082,5481,554,40749,12138,2,67,2,13.94,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2083,5481,554,40749,12138,2,13,1,621.75,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2084,5481,555,40749,12138,2,96,2,1934.23,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2085,5481,555,40749,12138,2,67,2,406.17,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2086,5481,555,40749,12138,2,13,1,2340.40,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2087,5481,556,40749,12138,2,96,2,68.15,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2088,5481,556,40749,12138,2,67,2,7.15,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2089,5481,556,40749,12138,2,96,2,746.04,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2090,5481,556,40749,12138,2,67,2,156.67,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2091,5481,556,40749,12138,2,13,1,1040.30,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2092,5481,556,40749,12138,2,136,2,62.29,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2093,5481,557,40749,12138,2,96,2,246.28,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2094,5481,557,40749,12138,2,67,2,51.72,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2095,5481,557,40749,12138,2,13,1,298.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2096,5481,558,40749,12138,2,96,2,165.29,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2097,5481,558,40749,12138,2,67,2,34.71,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2098,5481,558,40749,12138,2,96,2,306.06,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2099,5481,558,40749,12138,2,67,2,32.14,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2100,5481,558,40749,12138,2,13,1,538.20,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2101,5481,559,40749,12138,2,96,2,1247.94,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2102,5481,559,40749,12138,2,67,2,262.06,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2103,5481,559,40749,12138,2,13,1,1510.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2104,5481,560,40749,12138,2,96,2,575.20,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2105,5481,560,40749,12138,2,67,2,120.80,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2106,5481,560,40749,12138,2,96,2,36.20,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2107,5481,560,40749,12138,2,67,2,3.80,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2108,5481,560,40749,12138,2,13,1,736.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2109,5481,561,40749,12138,2,96,2,628.10,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2110,5481,561,40749,12138,2,67,2,131.90,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2111,5481,561,40749,12138,2,13,1,760.00,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2112,5481,562,40749,12138,2,96,2,1179.96,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2113,5481,562,40749,12138,2,67,2,247.79,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2114,5481,562,40749,12138,2,13,1,1427.75,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2115,5481,563,40749,12138,2,96,2,679.09,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2116,5481,563,40749,12138,2,67,2,142.61,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2117,5481,563,40749,12138,2,13,1,821.70,NULL,'2021-08-09 16:22:39','2021-08-09 16:22:39',NULL),(2118,5481,564,40749,12138,2,96,2,214.88,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2119,5481,564,40749,12138,2,67,2,45.12,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2120,5481,564,40749,12138,2,96,2,45.25,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2121,5481,564,40749,12138,2,67,2,4.75,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2122,5481,564,40749,12138,2,13,1,310.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2123,5481,565,40749,12138,2,96,2,743.80,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2124,5481,565,40749,12138,2,67,2,156.20,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2125,5481,565,40749,12138,2,13,1,900.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2126,5481,566,40749,12138,2,96,2,173.55,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2127,5481,566,40749,12138,2,67,2,36.45,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2128,5481,566,40749,12138,2,13,1,210.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2129,5481,567,40749,12138,2,96,2,415.71,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2130,5481,567,40749,12138,2,67,2,87.29,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2131,5481,567,40749,12138,2,13,1,503.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2132,5481,568,40749,12138,2,96,2,185.95,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2133,5481,568,40749,12138,2,67,2,39.05,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2134,5481,568,40749,12138,2,13,1,225.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2135,5481,569,40749,12138,2,96,2,210.74,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2136,5481,569,40749,12138,2,67,2,44.26,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2137,5481,569,40749,12138,2,13,1,255.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2138,5481,570,40749,12138,2,96,2,161.16,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2139,5481,570,40749,12138,2,67,2,33.84,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2140,5481,570,40749,12138,2,96,2,68.37,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2141,5481,570,40749,12138,2,67,2,7.18,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2142,5481,570,40749,12138,2,13,1,270.55,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2143,5481,571,40749,12138,2,96,2,774.38,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2144,5481,571,40749,12138,2,67,2,162.62,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2145,5481,571,40749,12138,2,13,1,937.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2146,5481,572,40749,12138,2,96,2,330.58,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2147,5481,572,40749,12138,2,67,2,69.42,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2148,5481,572,40749,12138,2,13,1,400.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2149,5481,573,40749,12138,2,96,2,297.53,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2150,5481,573,40749,12138,2,67,2,62.47,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2151,5481,573,40749,12138,2,13,1,360.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2152,5481,574,40749,12138,2,96,2,449.59,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2153,5481,574,40749,12138,2,67,2,94.41,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2154,5481,574,40749,12138,2,13,1,544.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2155,5481,575,40749,12138,2,96,2,399.80,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2156,5481,575,40749,12138,2,67,2,83.95,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2157,5481,575,40749,12138,2,13,1,483.75,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2158,5481,576,40749,12138,2,96,2,2684.28,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2159,5481,576,40749,12138,2,67,2,563.72,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2160,5481,576,40749,12138,2,96,2,244.34,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2161,5481,576,40749,12138,2,67,2,25.66,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2162,5481,576,40749,12138,2,13,1,3518.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2163,5481,577,40749,12138,2,96,2,117.65,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2164,5481,577,40749,12138,2,67,2,12.35,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2165,5481,577,40749,12138,2,96,2,165.29,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2166,5481,577,40749,12138,2,67,2,34.71,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2167,5481,577,40749,12138,2,13,1,330.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2168,5481,578,40749,12138,2,96,2,272.73,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2169,5481,578,40749,12138,2,67,2,57.27,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2170,5481,578,40749,12138,2,13,1,330.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2171,5481,579,40749,12138,2,96,2,221.69,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2172,5481,579,40749,12138,2,67,2,46.56,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2173,5481,579,40749,12138,2,13,1,330.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2174,5481,579,40749,12138,2,136,2,61.75,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2175,5481,580,40749,12138,2,96,2,2043.39,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2176,5481,580,40749,12138,2,67,2,429.11,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2177,5481,580,40749,12138,2,13,1,2472.50,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2178,5481,581,40749,12138,2,96,2,209.09,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2179,5481,581,40749,12138,2,67,2,43.91,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2180,5481,581,40749,12138,2,13,1,253.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2181,5481,582,40749,12138,2,96,2,628.10,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2182,5481,582,40749,12138,2,67,2,131.90,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2183,5481,582,40749,12138,2,13,1,760.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2184,5481,583,40749,12138,2,96,2,435.96,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2185,5481,583,40749,12138,2,67,2,91.54,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2186,5481,583,40749,12138,2,96,2,349.95,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2187,5481,583,40749,12138,2,67,2,36.75,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2188,5481,583,40749,12138,2,13,1,914.20,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2189,5481,584,40749,12138,2,96,2,602.47,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2190,5481,584,40749,12138,2,67,2,126.53,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2191,5481,584,40749,12138,2,13,1,729.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2192,5481,585,40749,12138,2,96,2,347.10,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2193,5481,585,40749,12138,2,67,2,72.90,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2194,5481,585,40749,12138,2,13,1,420.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2195,5481,586,40749,12138,2,96,2,557.04,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2196,5481,586,40749,12138,2,67,2,116.96,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2197,5481,586,40749,12138,2,13,1,674.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2198,5481,587,40749,12138,2,96,2,479.34,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2199,5481,587,40749,12138,2,67,2,100.66,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2200,5481,587,40749,12138,2,13,1,580.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2201,5481,588,40749,12138,2,96,2,351.24,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL);
INSERT INTO `balance_libro_details` VALUES (2202,5481,588,40749,12138,2,67,2,73.76,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2203,5481,588,40749,12138,2,13,1,425.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2204,5481,589,40749,12138,2,96,2,169.42,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2205,5481,589,40749,12138,2,67,2,35.58,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2206,5481,589,40749,12138,2,13,1,205.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2207,5481,590,40749,12138,2,96,2,114.05,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2208,5481,590,40749,12138,2,67,2,23.95,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2209,5481,590,40749,12138,2,13,1,138.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2210,5481,591,40749,12138,2,96,2,330.31,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2211,5481,591,40749,12138,2,67,2,34.69,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2212,5481,591,40749,12138,2,96,2,144.63,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2213,5481,591,40749,12138,2,67,2,30.37,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2214,5481,591,40749,12138,2,13,1,540.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2215,5481,592,40749,12138,2,96,2,46.15,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2216,5481,592,40749,12138,2,67,2,4.85,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2217,5481,592,40749,12138,2,96,2,1588.64,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2218,5481,592,40749,12138,2,67,2,333.61,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2219,5481,592,40749,12138,2,13,1,2035.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2220,5481,592,40749,12138,2,136,2,61.75,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2221,5481,593,40749,12138,2,96,2,1158.68,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2222,5481,593,40749,12138,2,67,2,243.32,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2223,5481,593,40749,12138,2,13,1,1402.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2224,5481,594,40749,12138,2,96,2,370.25,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2225,5481,594,40749,12138,2,67,2,77.75,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2226,5481,594,40749,12138,2,96,2,117.65,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2227,5481,594,40749,12138,2,67,2,12.35,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2228,5481,594,40749,12138,2,13,1,578.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2229,5481,595,40749,12138,2,96,2,1118.60,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2230,5481,595,40749,12138,2,67,2,234.90,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2231,5481,595,40749,12138,2,96,2,102.53,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2232,5481,595,40749,12138,2,67,2,10.77,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2233,5481,595,40749,12138,2,13,1,1466.80,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2234,5481,596,40749,12138,2,96,2,238.01,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2235,5481,596,40749,12138,2,67,2,49.99,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2236,5481,596,40749,12138,2,96,2,120.18,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2237,5481,596,40749,12138,2,67,2,12.62,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2238,5481,596,40749,12138,2,13,1,420.80,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2239,5481,597,40749,12138,2,96,2,661.16,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2240,5481,597,40749,12138,2,67,2,138.84,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2241,5481,597,40749,12138,2,13,1,800.00,NULL,'2021-08-09 16:22:40','2021-08-09 16:22:40',NULL),(2242,5481,598,40749,12138,2,96,2,438.02,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL);
INSERT INTO `balance_libro_details` VALUES (2243,5481,598,40749,12138,2,67,2,91.98,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2244,5481,598,40749,12138,2,96,2,404.80,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2245,5481,598,40749,12138,2,67,2,42.50,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2246,5481,598,40749,12138,2,13,1,977.30,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2247,5481,599,40749,12138,2,96,2,336.81,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2248,5481,599,40749,12138,2,67,2,70.74,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2249,5481,599,40749,12138,2,13,1,470.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2250,5481,599,40749,12138,2,136,2,62.45,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2251,5481,600,40749,12138,2,96,2,247.94,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2252,5481,600,40749,12138,2,67,2,52.06,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2253,5481,600,40749,12138,2,13,1,300.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2254,5481,601,40749,12138,2,96,2,413.23,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2255,5481,601,40749,12138,2,67,2,86.77,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2256,5481,601,40749,12138,2,96,2,177.38,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2257,5481,601,40749,12138,2,67,2,18.62,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2258,5481,601,40749,12138,2,13,1,696.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2259,5481,602,40749,12138,2,96,2,140.53,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2260,5481,602,40749,12138,2,67,2,14.76,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2261,5481,602,40749,12138,2,96,2,235.54,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2262,5481,602,40749,12138,2,67,2,49.45,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2263,5481,602,40749,12138,2,13,1,440.28,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2264,5481,603,40749,12138,2,96,2,297.52,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2265,5481,603,40749,12138,2,67,2,62.48,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2266,5481,603,40749,12138,2,13,1,360.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2267,5481,604,40749,12138,2,96,2,1103.30,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2268,5481,604,40749,12138,2,67,2,231.70,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2269,5481,604,40749,12138,2,13,1,1335.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2270,5481,605,40749,12138,2,96,2,74.38,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2271,5481,605,40749,12138,2,67,2,15.62,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2272,5481,605,40749,12138,2,96,2,253.39,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2273,5481,605,40749,12138,2,67,2,26.61,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2274,5481,605,40749,12138,2,13,1,370.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2275,5481,606,40749,12138,2,96,2,824.80,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2276,5481,606,40749,12138,2,67,2,173.20,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2277,5481,606,40749,12138,2,13,1,998.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2278,5481,607,40749,12138,2,96,2,1116.53,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2279,5481,607,40749,12138,2,67,2,234.47,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2280,5481,607,40749,12138,2,96,2,196.38,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2281,5481,607,40749,12138,2,67,2,20.62,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2282,5481,607,40749,12138,2,13,1,1568.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2283,5481,608,40749,12138,2,96,2,347.10,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL);
INSERT INTO `balance_libro_details` VALUES (2284,5481,608,40749,12138,2,67,2,72.90,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2285,5481,608,40749,12138,2,13,1,420.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2286,5481,609,40749,12138,2,96,2,769.41,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2287,5481,609,40749,12138,2,67,2,161.59,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2288,5481,609,40749,12138,2,13,1,931.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2289,5481,610,40749,12138,2,96,2,347.10,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2290,5481,610,40749,12138,2,67,2,72.90,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2291,5481,610,40749,12138,2,13,1,420.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2292,5481,611,40749,12138,2,96,2,2996.70,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2293,5481,611,40749,12138,2,67,2,629.30,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2294,5481,611,40749,12138,2,96,2,681.22,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2295,5481,611,40749,12138,2,67,2,71.53,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2296,5481,611,40749,12138,2,13,1,4378.75,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2297,5481,612,40749,12138,2,96,2,330.57,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2298,5481,612,40749,12138,2,67,2,69.43,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2299,5481,612,40749,12138,2,96,2,79.64,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2300,5481,612,40749,12138,2,67,2,8.36,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2301,5481,612,40749,12138,2,13,1,488.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2302,5481,613,40749,12138,2,96,2,74.38,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2303,5481,613,40749,12138,2,67,2,15.62,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2304,5481,613,40749,12138,2,13,1,90.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2305,5481,614,40749,12138,2,96,2,424.79,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2306,5481,614,40749,12138,2,67,2,89.21,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2307,5481,614,40749,12138,2,13,1,514.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2308,5481,615,40749,12138,2,96,2,181.82,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2309,5481,615,40749,12138,2,67,2,38.18,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2310,5481,615,40749,12138,2,13,1,220.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2311,5481,616,40749,12138,2,96,2,647.11,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2312,5481,616,40749,12138,2,67,2,135.89,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2313,5481,616,40749,12138,2,13,1,783.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2314,5481,617,40749,12138,2,96,2,80.17,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2315,5481,617,40749,12138,2,67,2,16.83,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2316,5481,617,40749,12138,2,13,1,97.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2317,5481,618,40749,12138,2,96,2,555.37,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2318,5481,618,40749,12138,2,67,2,116.63,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2319,5481,618,40749,12138,2,13,1,672.00,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2320,5481,619,40749,12138,2,96,2,264.46,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(2321,5481,619,40749,12138,2,67,2,55.54,NULL,'2021-08-09 16:22:41','2021-08-09 16:22:41',NULL),(