-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db23-26144179-9
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-10-29 18:49:54','Actividad Generica 1','000001',NULL),(2,NULL,'2022-10-29 18:49:54','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,'afip','maSoraire2023',NULL,1,40720,'2022-12-11'),(2,'afip','SOraireP1515','afip',1,42384,'2024-02-10');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'estudiogarcia.nqn@gmail.com','2996285752',NULL,1,40719,'2022-10-30'),(2,'estudiogarcia.nqn@gmail.com','2996285752','',1,40719,'2022-10-31');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=564 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,8019,40720,19725,3,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-01','2021-01-01',2003.17,NULL,NULL,1,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(2,8019,40720,19725,3,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',5500.00,NULL,NULL,1,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(3,8019,40720,19725,3,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',2878.51,NULL,NULL,1,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(4,8019,40720,19725,3,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',10697.70,NULL,NULL,1,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(5,8019,40720,19725,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',7559.34,NULL,NULL,1,'2022-12-13 10:08:36','2022-12-13 10:09:54','2022-12-13 10:09:54'),(6,8019,40720,19725,3,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',9500.00,NULL,NULL,1,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(7,8019,40720,19725,3,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',4349.97,NULL,NULL,1,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(8,8019,40720,19725,3,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1160.00,NULL,NULL,1,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(9,8019,40720,19725,3,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',600.00,NULL,NULL,1,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(10,8019,40720,19725,3,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',5929.00,NULL,NULL,1,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(11,8019,40720,19725,3,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',1698.00,NULL,NULL,1,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(12,8019,40720,19725,3,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',48308.66,NULL,NULL,1,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(13,8019,40720,19725,3,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',29450.19,NULL,NULL,1,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(14,8019,40720,19725,3,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',7559.34,NULL,NULL,1,'2022-12-13 10:09:54','2022-12-13 10:09:54',NULL),(15,8019,40720,19726,3,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',0.00,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(16,8019,40720,19726,3,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',2003.17,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(17,8019,40720,19726,3,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',1178.38,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(18,8019,40720,19726,3,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',3460.24,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(19,8019,40720,19726,3,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',2450.00,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(20,8019,40720,19726,3,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',3340.30,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(21,8019,40720,19726,3,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',2961.22,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL);
INSERT INTO `balance_libro` VALUES (22,8019,40720,19726,3,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',2297.06,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(23,8019,40720,19726,3,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',14654.40,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(24,8019,40720,19726,3,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',3200.00,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(25,8019,40720,19726,3,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',5500.00,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(26,8019,40720,19726,3,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',9000.00,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(27,8019,40720,19726,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',2837.39,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(28,8019,40720,19726,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1600.00,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(29,8019,40720,19726,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',845.00,NULL,NULL,1,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(30,8019,40720,19727,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2600.00,NULL,NULL,1,'2022-12-13 10:11:05','2022-12-13 10:11:05',NULL),(31,8019,40720,19727,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2003.17,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(32,8019,40720,19727,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',258731.12,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(33,8019,40720,19727,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',5500.00,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(34,8019,40720,19727,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',3020.28,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(35,8019,40720,19727,3,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1100.48,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(36,8019,40720,19727,3,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',2000.00,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(37,8019,40720,19727,3,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',350.00,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(38,8019,40720,19727,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',2639.96,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(39,8019,40720,19727,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',6655.00,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(40,8019,40720,19727,3,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1339.99,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(41,8019,40720,19727,3,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',31655.34,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(42,8019,40720,19727,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',65706.75,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL);
INSERT INTO `balance_libro` VALUES (43,8019,40720,19727,3,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',2499.98,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(44,8019,40720,19727,3,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',1632.74,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(45,8019,40720,19727,3,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',2133.99,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(46,8019,40720,19727,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',28975.00,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(47,8019,40720,19727,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',4499.00,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(48,8019,40720,19727,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',540.00,NULL,NULL,1,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(49,8019,40720,19728,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2003.17,NULL,NULL,1,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(50,8019,40720,19728,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',580.00,NULL,NULL,1,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(51,8019,40720,19728,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1649.67,NULL,NULL,1,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(52,8019,40720,19728,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1820.00,NULL,NULL,1,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(53,8019,40720,19728,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',4305.79,NULL,NULL,1,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(54,8019,40720,19728,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3220.69,NULL,NULL,1,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(55,8019,40720,19728,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',2000.00,NULL,NULL,1,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(56,8019,40720,19728,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',10800.00,NULL,NULL,1,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(57,8019,40720,19728,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',5500.00,NULL,NULL,1,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(58,8019,40720,19728,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',107283.56,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(59,8019,40720,19728,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',4549.95,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(60,8019,40720,19728,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',4983.39,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(61,8019,40720,19728,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',3946.33,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(62,8019,40720,19728,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',9790.00,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(63,8019,40720,19728,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',793.76,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL);
INSERT INTO `balance_libro` VALUES (64,8019,40720,19728,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',400.00,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(65,8019,40720,19728,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',1474.00,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(66,8019,40720,19728,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',58044.16,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(67,8019,40720,19728,3,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',3809.96,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(68,8019,40720,19728,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',1780.89,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(69,8019,40720,19728,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',8096.21,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(70,8019,40720,19728,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',2000.00,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(71,8019,40720,19728,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',900.01,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(72,8019,40720,19728,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',892.50,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(73,8019,40720,19728,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',892.50,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(74,8019,40720,19728,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',3240.00,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(75,8019,40720,19728,3,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',700.00,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(76,8019,40720,19728,3,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',192.81,NULL,NULL,1,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(77,8019,40720,19729,3,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-01','2021-05-01',2922.96,NULL,NULL,1,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(78,8019,40720,19729,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',2402.93,NULL,NULL,1,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(79,8019,40720,19729,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6846.08,NULL,NULL,1,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(80,8019,40720,19729,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',1000.00,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(81,8019,40720,19729,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',5100.48,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(82,8019,40720,19729,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',12792.20,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(83,8019,40720,19729,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',17000.69,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(84,8019,40720,19729,3,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',2000.00,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL);
INSERT INTO `balance_libro` VALUES (85,8019,40720,19729,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',5500.00,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(86,8019,40720,19729,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',10800.00,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(87,8019,40720,19729,3,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',48189.00,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(88,8019,40720,19729,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',1270.00,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(89,8019,40720,19729,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',830.00,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(90,8019,40720,19729,3,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',1200.01,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(91,8019,40720,19729,3,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',70780.28,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(92,8019,40720,19729,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',14999.00,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(93,8019,40720,19729,3,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1000.00,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(94,8019,40720,19729,3,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',35438.41,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(95,8019,40720,19729,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1317.99,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(96,8019,40720,19729,3,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',829.99,NULL,NULL,1,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(97,8019,40720,19730,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2922.96,NULL,NULL,1,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(98,8019,40720,19730,3,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',500.00,NULL,NULL,1,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(99,8019,40720,19730,3,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',76000.00,NULL,NULL,1,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(100,8019,40720,19730,3,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',22868.14,NULL,NULL,1,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(101,8019,40720,19730,3,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',10800.00,NULL,NULL,1,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(102,8019,40720,19730,3,101,'App\\Models\\Receipt',101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',1191.60,NULL,NULL,1,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(103,8019,40720,19730,3,102,'App\\Models\\Receipt',102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',4073.73,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(104,8019,40720,19730,3,103,'App\\Models\\Receipt',103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',5300.00,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(105,8019,40720,19730,3,104,'App\\Models\\Receipt',104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',960.00,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL);
INSERT INTO `balance_libro` VALUES (106,8019,40720,19730,3,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',5500.00,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(107,8019,40720,19730,3,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',4751.30,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(108,8019,40720,19730,3,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',2500.04,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(109,8019,40720,19730,3,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',2079.99,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(110,8019,40720,19730,3,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',36183.84,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(111,8019,40720,19730,3,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',610.00,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(112,8019,40720,19730,3,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1640.47,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(113,8019,40720,19730,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',2649.70,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(114,8019,40720,19730,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1930.00,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(115,8019,40720,19730,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',3300.00,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(116,8019,40720,19730,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',14166.99,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(117,8019,40720,19730,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',2500.00,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(118,8019,40720,19730,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',2000.00,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(119,8019,40720,19730,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',8462.83,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(120,8019,40720,19730,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',72030.82,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(121,8019,40720,19730,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',37217.66,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(122,8019,40720,19730,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1199.99,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(123,8019,40720,19730,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',540.00,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(124,8019,40720,19730,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',800.00,NULL,NULL,1,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(125,8019,40720,19731,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',5120.00,NULL,NULL,1,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(126,8019,40720,19731,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',2922.96,NULL,NULL,1,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL);
INSERT INTO `balance_libro` VALUES (127,8019,40720,19731,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',540.00,NULL,NULL,1,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(128,8019,40720,19731,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',3439.99,NULL,NULL,1,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(129,8019,40720,19731,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',3840.12,NULL,NULL,1,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(130,8019,40720,19731,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',5500.00,NULL,NULL,1,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(131,8019,40720,19731,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',10800.00,NULL,NULL,1,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(132,8019,40720,19731,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',2981.15,NULL,NULL,1,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(133,8019,40720,19731,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',2000.01,NULL,NULL,1,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(134,8019,40720,19731,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',25670.83,NULL,NULL,1,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(135,8019,40720,19731,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',250.00,NULL,NULL,1,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(136,8019,40720,19731,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',5700.00,NULL,NULL,1,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(137,8019,40720,19731,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',3135.00,NULL,NULL,1,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(138,8019,40720,19731,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',2000.00,NULL,NULL,1,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(139,8019,40720,19731,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',22857.88,NULL,NULL,1,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(140,8019,40720,19731,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',276990.92,NULL,NULL,1,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(141,8019,40720,19731,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',9436.10,NULL,NULL,1,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(142,8019,40720,19732,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-01','2021-08-01',3326.26,NULL,NULL,1,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(143,8019,40720,19732,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-05','2021-08-05',7500.00,NULL,NULL,1,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(144,8019,40720,19732,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-07','2021-08-07',16129.99,NULL,NULL,1,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(145,8019,40720,19732,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-08','2021-08-08',3842.26,NULL,NULL,1,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(146,8019,40720,19732,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',375.70,NULL,NULL,1,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(147,8019,40720,19732,3,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-09','2021-08-09',12500.00,NULL,NULL,1,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL);
INSERT INTO `balance_libro` VALUES (148,8019,40720,19732,3,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-11','2021-08-11',4690.00,NULL,NULL,1,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(149,8019,40720,19732,3,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18','2021-08-18',36523.02,NULL,NULL,1,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(150,8019,40720,19732,3,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-25','2021-08-25',5280.00,NULL,NULL,1,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(151,8019,40720,19732,3,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',1294.00,NULL,NULL,1,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(152,8019,40720,19732,3,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30','2021-08-30',2700.00,NULL,NULL,1,'2022-12-13 10:15:02','2022-12-13 10:15:02',NULL),(153,8019,40720,19733,3,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',3376.68,NULL,NULL,1,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(154,8019,40720,19733,3,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01','2021-09-01',1050.00,NULL,NULL,1,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(155,8019,40720,19733,3,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',1380.00,NULL,NULL,1,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(156,8019,40720,19733,3,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-07','2021-09-07',1300.02,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(157,8019,40720,19733,3,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',15115.66,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(158,8019,40720,19733,3,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',15115.66,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(159,8019,40720,19733,3,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',21833.26,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(160,8019,40720,19733,3,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',7500.00,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(161,8019,40720,19733,3,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',3838.17,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(162,8019,40720,19733,3,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08','2021-09-08',52000.00,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(163,8019,40720,19733,3,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',2900.00,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(164,8019,40720,19733,3,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10','2021-09-10',693.23,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(165,8019,40720,19733,3,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-13','2021-09-13',1360.00,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(166,8019,40720,19733,3,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',2920.00,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(167,8019,40720,19733,3,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',3390.70,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(168,8019,40720,19733,3,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-15','2021-09-15',6000.00,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL);
INSERT INTO `balance_libro` VALUES (169,8019,40720,19733,3,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21','2021-09-21',1750.00,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(170,8019,40720,19733,3,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',1040.00,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(171,8019,40720,19733,3,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22','2021-09-22',10625.72,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(172,8019,40720,19733,3,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-27','2021-09-27',13500.01,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(173,8019,40720,19733,3,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',4593.11,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(174,8019,40720,19733,3,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28','2021-09-28',1955.19,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(175,8019,40720,19733,3,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',8668.23,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(176,8019,40720,19733,3,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',78189.72,NULL,NULL,1,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(177,8019,40720,19734,3,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-01','2021-10-01',3326.26,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(178,8019,40720,19734,3,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',1692.31,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(179,8019,40720,19734,3,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04','2021-10-04',440.00,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(180,8019,40720,19734,3,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05','2021-10-05',7500.00,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(181,8019,40720,19734,3,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08','2021-10-08',19190.81,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(182,8019,40720,19734,3,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12','2021-10-12',36597.91,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(183,8019,40720,19734,3,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',109775.75,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(184,8019,40720,19734,3,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',2780.00,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(185,8019,40720,19734,3,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',45869.42,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(186,8019,40720,19734,3,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20','2021-10-20',11000.00,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(187,8019,40720,19734,3,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',3989.00,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(188,8019,40720,19734,3,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',1100.00,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(189,8019,40720,19734,3,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',800.00,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL);
INSERT INTO `balance_libro` VALUES (190,8019,40720,19734,3,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',3260.00,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(191,8019,40720,19734,3,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',22725.62,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(192,8019,40720,19734,3,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22','2021-10-22',3090.00,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(193,8019,40720,19734,3,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-25','2021-10-25',9743.09,NULL,NULL,1,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(194,8019,40720,19734,3,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-26','2021-10-26',15062.17,NULL,NULL,1,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(195,8019,40720,19734,3,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27','2021-10-27',20797.43,NULL,NULL,1,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(196,8019,40720,19734,3,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-28','2021-10-28',915.20,NULL,NULL,1,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(197,8019,40720,19734,3,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',6200.17,NULL,NULL,1,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(198,8019,40720,19734,3,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',886.45,NULL,NULL,1,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(199,8019,40720,19734,3,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-29','2021-10-29',15340.30,NULL,NULL,1,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(200,8019,40720,19735,3,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',1000.00,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(201,8019,40720,19735,3,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',7500.00,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(202,8019,40720,19735,3,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-01','2021-11-01',4183.28,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(203,8019,40720,19735,3,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',3000.00,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(204,8019,40720,19735,3,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-04','2021-11-04',30201.44,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(205,8019,40720,19735,3,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-05','2021-11-05',7020.00,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(206,8019,40720,19735,3,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-08','2021-11-08',22557.00,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(207,8019,40720,19735,3,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',7000.00,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(208,8019,40720,19735,3,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-10','2021-11-10',12518.01,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(209,8019,40720,19735,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',8500.00,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(210,8019,40720,19735,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-15','2021-11-15',300.00,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL);
INSERT INTO `balance_libro` VALUES (211,8019,40720,19735,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',1150.00,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(212,8019,40720,19735,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-16','2021-11-16',13021.75,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(213,8019,40720,19735,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',5450.00,NULL,NULL,1,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(214,8019,40720,19735,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-18','2021-11-18',5200.00,NULL,NULL,1,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(215,8019,40720,19735,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-19','2021-11-19',83563.33,NULL,NULL,1,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(216,8019,40720,19735,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-26','2021-11-26',3553.88,NULL,NULL,1,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(217,8019,40720,19735,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',4666.64,NULL,NULL,1,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(218,8019,40720,19735,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-27','2021-11-27',7285.60,NULL,NULL,1,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(219,8019,40720,19735,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-28','2021-11-28',5971.84,NULL,NULL,1,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(220,8019,40720,19735,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',37610.99,NULL,NULL,1,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(221,8019,40720,19735,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-30','2021-11-30',303815.10,NULL,NULL,1,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(222,8019,40720,19736,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',7500.00,NULL,NULL,1,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(223,8019,40720,19736,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-01','2021-12-01',4183.28,NULL,NULL,1,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(224,8019,40720,19736,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-03','2021-12-03',13299.00,NULL,NULL,1,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(225,8019,40720,19736,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-06','2021-12-06',9980.00,NULL,NULL,1,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(226,8019,40720,19736,3,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-07','2021-12-07',1559.99,NULL,NULL,1,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(227,8019,40720,19736,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',202.11,NULL,NULL,1,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(228,8019,40720,19736,3,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-08','2021-12-08',11000.00,NULL,NULL,1,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(229,8019,40720,19736,3,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-09','2021-12-09',299.98,NULL,NULL,1,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(230,8019,40720,19736,3,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',29999.00,NULL,NULL,1,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(231,8019,40720,19736,3,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',4680.00,NULL,NULL,1,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL);
INSERT INTO `balance_libro` VALUES (232,8019,40720,19736,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-10','2021-12-10',10494.82,NULL,NULL,1,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(233,8019,40720,19736,3,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-13','2021-12-13',50917.42,NULL,NULL,1,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(234,8019,40720,19736,3,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-16','2021-12-16',23056.73,NULL,NULL,1,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(235,8019,40720,19736,3,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-20','2021-12-20',17209.66,NULL,NULL,1,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(236,8019,40720,19736,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-21','2021-12-21',8344.53,NULL,NULL,1,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(237,8019,40720,19736,3,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',4382.67,NULL,NULL,1,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(238,8019,40720,19736,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-22','2021-12-22',90256.32,NULL,NULL,1,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(239,8019,40720,19736,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-23','2021-12-23',9710.64,NULL,NULL,1,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(240,8019,40720,19736,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-28','2021-12-28',570.00,NULL,NULL,1,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(241,8019,40720,19725,2,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',105415.20,NULL,NULL,1,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(242,8019,40720,19725,2,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',72600.00,NULL,NULL,1,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(243,8019,40720,19725,2,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',24393.60,NULL,NULL,1,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(244,8019,40720,19725,2,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',96618.50,NULL,NULL,1,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(245,8019,40720,19725,2,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',1850.00,NULL,NULL,1,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(246,8019,40720,19726,2,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',50000.00,NULL,NULL,1,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(247,8019,40720,19726,2,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',50000.83,NULL,NULL,1,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(248,8019,40720,19726,2,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',50000.00,NULL,NULL,1,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(249,8019,40720,19726,2,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',25192.20,NULL,NULL,1,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(250,8019,40720,19726,2,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',43560.00,NULL,NULL,1,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(251,8019,40720,19727,2,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',32573.20,NULL,NULL,1,'2022-12-13 10:18:07','2022-12-13 10:18:07',NULL),(252,8019,40720,19727,2,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',26499.00,NULL,NULL,1,'2022-12-13 10:18:07','2022-12-13 10:18:07',NULL);
INSERT INTO `balance_libro` VALUES (253,8019,40720,19728,2,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',35719.20,NULL,NULL,1,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(254,8019,40720,19728,2,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',11567.60,NULL,NULL,1,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(255,8019,40720,19728,2,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',116032.95,NULL,NULL,1,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(256,8019,40720,19728,2,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',13975.50,NULL,NULL,1,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(257,8019,40720,19728,2,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',17888.64,NULL,NULL,1,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(258,8019,40720,19728,2,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',532400.00,NULL,NULL,1,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(259,8019,40720,19728,2,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',16770.60,NULL,NULL,1,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(260,8019,40720,19728,2,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',33076.56,NULL,NULL,1,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(261,8019,40720,19728,2,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',94501.00,NULL,NULL,1,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(262,8019,40720,19729,2,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',193600.00,NULL,NULL,1,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(263,8019,40720,19729,2,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',157300.00,NULL,NULL,1,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(264,8019,40720,19729,2,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',52380.90,NULL,NULL,1,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(265,8019,40720,19729,2,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',38993.46,NULL,NULL,1,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(266,8019,40720,19729,2,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',12281.50,NULL,NULL,1,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(267,8019,40720,19730,2,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',17424.00,NULL,NULL,1,'2022-12-13 10:22:09','2022-12-13 10:22:09',NULL),(268,8019,40720,19731,2,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',54424.59,NULL,NULL,1,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(269,8019,40720,19731,2,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',84700.00,NULL,NULL,1,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(270,8019,40720,19731,2,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',89540.00,NULL,NULL,1,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(271,8019,40720,19732,2,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',8046.50,NULL,NULL,1,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(272,8019,40720,19732,2,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-02','2021-08-02',16770.60,NULL,NULL,1,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(273,8019,40720,19732,2,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-12','2021-08-12',2246.97,NULL,NULL,1,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL);
INSERT INTO `balance_libro` VALUES (274,8019,40720,19732,2,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',44842.60,NULL,NULL,1,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(275,8019,40720,19732,2,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',96800.00,NULL,NULL,1,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(276,8019,40720,19732,2,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-27','2021-08-27',34073.60,NULL,NULL,1,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(277,8019,40720,19733,2,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',41473.96,NULL,NULL,1,'2022-12-13 10:23:22','2022-12-13 10:23:22',NULL),(278,8019,40720,19733,2,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14','2021-09-14',39000.00,NULL,NULL,1,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(279,8019,40720,19733,2,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29','2021-09-29',31803.64,NULL,NULL,1,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(280,8019,40720,19733,2,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',89540.00,NULL,NULL,1,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(281,8019,40720,19733,2,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30','2021-09-30',67760.00,NULL,NULL,1,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(282,8019,40720,19734,2,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14','2021-10-14',16601.20,NULL,NULL,1,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(283,8019,40720,19734,2,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18','2021-10-18',71995.00,NULL,NULL,1,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(284,8019,40720,19734,2,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-21','2021-10-21',2940.00,NULL,NULL,1,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(285,8019,40720,19734,2,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-31','2021-10-31',108900.00,NULL,NULL,1,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(286,8019,40720,19735,2,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-24','2021-11-24',215985.00,NULL,NULL,1,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(287,8019,40720,19735,2,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',64178.40,NULL,NULL,1,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(288,8019,40720,19735,2,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-29','2021-11-29',42471.00,NULL,NULL,1,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(349,8019,40861,70033,3,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',13358.40,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(350,8019,40861,70033,3,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',12705.00,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(351,8019,40861,70033,3,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',30250.00,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(352,8019,40861,70033,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-02','2022-01-02',78650.00,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(353,8019,40861,70033,3,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',20907.78,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(354,8019,40861,70033,3,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',319825.51,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL);
INSERT INTO `balance_libro` VALUES (355,8019,40861,70033,3,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',158889.60,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(356,8019,40861,70033,3,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',2290.15,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(357,8019,40861,70033,3,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',121000.00,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(358,8019,40861,70033,3,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',26620.00,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(359,8019,40861,70033,3,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',2662.00,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(360,8019,40861,70033,3,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',121000.00,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(361,8019,40861,70033,3,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',616.34,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(362,8019,40861,70033,3,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',60845.00,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(363,8019,40861,70033,3,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',128952.03,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(364,8019,40861,70033,3,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-04','2022-01-04',7664233.09,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(365,8019,40861,70033,3,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',57200.26,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(366,8019,40861,70033,3,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',45345.96,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(367,8019,40861,70033,3,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',94380.00,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(368,8019,40861,70033,3,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',4840.00,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(369,8019,40861,70033,3,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',19076.86,NULL,NULL,1,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(370,8019,40861,70033,3,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',10166.34,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(371,8019,40861,70033,3,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',12250.04,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(372,8019,40861,70033,3,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-05','2022-01-05',38000.00,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(373,8019,40861,70033,3,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',8210.00,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(374,8019,40861,70033,3,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',4174.53,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(375,8019,40861,70033,3,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',21945.19,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL);
INSERT INTO `balance_libro` VALUES (376,8019,40861,70033,3,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',9450.00,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(377,8019,40861,70033,3,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',90145.00,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(378,8019,40861,70033,3,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-07','2022-01-07',8195108.61,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(379,8019,40861,70033,3,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-08','2022-01-08',4000.26,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(380,8019,40861,70033,3,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',388323.98,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(381,8019,40861,70033,3,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',10043.36,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(382,8019,40861,70033,3,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',7685067.90,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(383,8019,40861,70033,3,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',26759.95,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(384,8019,40861,70033,3,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',321401.94,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(385,8019,40861,70033,3,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',214170.00,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(386,8019,40861,70033,3,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',7183.13,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(387,8019,40861,70033,3,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',84923.22,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(388,8019,40861,70033,3,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',8213.44,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(389,8019,40861,70033,3,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',205.14,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(390,8019,40861,70033,3,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11','2022-01-11',169874.32,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(391,8019,40861,70033,3,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',123570.50,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(392,8019,40861,70033,3,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-12','2022-01-12',50578.00,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(393,8019,40861,70033,3,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',1359.99,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(394,8019,40861,70033,3,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',1529741.50,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(395,8019,40861,70033,3,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',3869.99,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(396,8019,40861,70033,3,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13','2022-01-13',2490.04,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL);
INSERT INTO `balance_libro` VALUES (397,8019,40861,70033,3,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',389561.99,NULL,NULL,1,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(398,8019,40861,70033,3,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',3524.75,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(399,8019,40861,70033,3,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',4500.00,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(400,8019,40861,70033,3,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',8237179.58,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(401,8019,40861,70033,3,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',954624.91,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(402,8019,40861,70033,3,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',1653261.00,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(403,8019,40861,70033,3,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-14','2022-01-14',1633.54,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(404,8019,40861,70033,3,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15','2022-01-15',84373.14,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(405,8019,40861,70033,3,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',6234393.90,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(406,8019,40861,70033,3,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',3646.53,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(407,8019,40861,70033,3,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',278925.73,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(408,8019,40861,70033,3,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',310.85,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(409,8019,40861,70033,3,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-17','2022-01-17',7723869.45,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(410,8019,40861,70033,3,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',50460.19,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(411,8019,40861,70033,3,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-18','2022-01-18',125078.00,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(412,8019,40861,70033,3,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',3500.00,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(413,8019,40861,70033,3,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-19','2022-01-19',866.31,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(414,8019,40861,70033,3,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-20','2022-01-20',8281034.08,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(415,8019,40861,70033,3,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',55552.00,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(416,8019,40861,70033,3,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',55552.00,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(417,8019,40861,70033,3,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',48400.00,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL);
INSERT INTO `balance_libro` VALUES (418,8019,40861,70033,3,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',1337213.35,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(419,8019,40861,70033,3,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',26168.52,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(420,8019,40861,70033,3,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',342831.16,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(421,8019,40861,70033,3,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-21','2022-01-21',630.11,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(422,8019,40861,70033,3,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-22','2022-01-22',400.92,NULL,NULL,1,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(423,8019,40861,70033,3,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',124687.87,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(424,8019,40861,70033,3,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',103.50,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(425,8019,40861,70033,3,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',49005.00,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(426,8019,40861,70033,3,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',83379.28,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(427,8019,40861,70033,3,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',83379.28,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(428,8019,40861,70033,3,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',15800.00,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(429,8019,40861,70033,3,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',920.01,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(430,8019,40861,70033,3,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-24','2022-01-24',1749844.40,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(431,8019,40861,70033,3,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',1073976.00,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(432,8019,40861,70033,3,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',78892.00,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(433,8019,40861,70033,3,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',8297507.78,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(434,8019,40861,70033,3,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',217800.00,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(435,8019,40861,70033,3,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',1403.99,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(436,8019,40861,70033,3,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',24500.00,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(437,8019,40861,70033,3,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',8304072.26,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(438,8019,40861,70033,3,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-25','2022-01-25',156937.00,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL);
INSERT INTO `balance_libro` VALUES (439,8019,40861,70033,3,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',273602.18,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(440,8019,40861,70033,3,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-26','2022-01-26',342.96,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(441,8019,40861,70033,3,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',181233.45,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(442,8019,40861,70033,3,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',6037.42,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(443,8019,40861,70033,3,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',13915.00,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(444,8019,40861,70033,3,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-27','2022-01-27',272856.21,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(445,8019,40861,70033,3,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',55800.00,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(446,8019,40861,70033,3,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',55800.00,NULL,NULL,1,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(447,8019,40861,70033,3,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',6306053.60,NULL,NULL,1,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(448,8019,40861,70033,3,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',201495.19,NULL,NULL,1,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(449,8019,40861,70033,3,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-28','2022-01-28',6303.87,NULL,NULL,1,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(450,8019,40861,70033,3,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',11006.21,NULL,NULL,1,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(451,8019,40861,70033,3,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',24894.20,NULL,NULL,1,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(452,8019,40861,70033,3,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2289223.20,NULL,NULL,1,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(453,8019,40861,70033,3,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',1142.96,NULL,NULL,1,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(454,8019,40861,70033,3,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',96911.30,NULL,NULL,1,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(455,8019,42384,83710,3,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',107186.89,NULL,NULL,1,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(456,8019,42384,83710,3,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',8133.88,NULL,NULL,1,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(457,8019,42384,83710,3,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',5744.56,NULL,NULL,1,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(458,8019,42384,83710,3,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',9762.31,NULL,NULL,1,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(459,8019,42384,83710,3,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',117895.91,NULL,NULL,1,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL);
INSERT INTO `balance_libro` VALUES (460,8019,42384,83711,3,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-02','2023-05-02',53500.00,NULL,NULL,1,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(461,8019,42384,83711,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',53634.52,NULL,NULL,1,'2023-08-19 20:58:16','2023-08-19 20:59:15','2023-08-19 20:59:15'),(462,8019,42384,83711,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',98728.00,NULL,NULL,1,'2023-08-19 20:58:16','2023-08-19 21:00:09','2023-08-19 21:00:09'),(463,8019,42384,83711,3,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1910.60,NULL,NULL,1,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(464,8019,42384,83711,3,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',1054.52,NULL,NULL,1,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(465,8019,42384,83711,3,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-17','2023-05-17',264.00,NULL,NULL,1,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(466,8019,42384,83711,3,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-18','2023-05-18',3177.99,NULL,NULL,1,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(467,8019,42384,83711,3,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-22','2023-05-22',16588.98,NULL,NULL,1,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(468,8019,42384,83711,3,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-30','2023-05-30',16000.00,NULL,NULL,1,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(469,8019,42384,83711,3,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-11','2023-05-11',53634.52,NULL,NULL,1,'2023-08-19 20:59:15','2023-08-19 20:59:15',NULL),(470,8019,42384,83711,3,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-12','2023-05-12',98728.00,NULL,NULL,1,'2023-08-19 21:00:09','2023-08-19 21:00:09',NULL),(471,8019,42384,83712,3,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01','2023-06-01',1199.99,NULL,NULL,1,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(472,8019,42384,83712,3,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-05','2023-06-05',3100.00,NULL,NULL,1,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(473,8019,42384,83712,3,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-11','2023-06-11',126739.00,NULL,NULL,1,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(474,8019,42384,83712,3,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-12','2023-06-12',2250.14,NULL,NULL,1,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(475,8019,42384,83712,3,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-29','2023-06-29',3100.00,NULL,NULL,1,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(476,8019,42384,83714,3,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',308507.00,NULL,NULL,1,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(477,8019,42384,83714,3,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',72992.04,NULL,NULL,1,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(478,8019,42384,83714,3,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',157590.40,NULL,NULL,1,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(479,8019,42384,83714,3,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-04','2023-08-04',240.00,NULL,NULL,1,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(480,8019,42384,83714,3,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',372204.88,NULL,NULL,1,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL);
INSERT INTO `balance_libro` VALUES (481,8019,42384,83714,3,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-08','2023-08-08',13346.66,NULL,NULL,1,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(482,8019,42384,83714,3,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-10','2023-08-10',1800.00,NULL,NULL,1,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(483,8019,42384,83714,3,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-11','2023-08-11',46356.61,NULL,NULL,1,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(484,8019,42384,83714,3,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',9400.00,NULL,NULL,1,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(485,8019,42384,83714,3,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-14','2023-08-14',1200.00,NULL,NULL,1,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(486,8019,42384,83714,3,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',10700.00,NULL,NULL,1,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(487,8019,42384,83714,3,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',16898.29,NULL,NULL,1,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(488,8019,42384,83714,3,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-17','2023-08-17',7895.00,NULL,NULL,1,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(489,8019,42384,83714,3,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-18','2023-08-18',138274.40,NULL,NULL,1,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(490,8019,42384,83711,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-05-27','2023-05-27',108900.00,NULL,NULL,1,'2023-08-19 21:12:03','2023-08-19 21:12:03',NULL),(491,8019,42384,83712,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-09','2023-06-09',28900.00,NULL,NULL,1,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(492,8019,42384,83712,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-15','2023-06-15',4560.01,NULL,NULL,1,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(493,8019,42384,83712,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-16','2023-06-16',107100.00,NULL,NULL,1,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(494,8019,42384,83712,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',19000.02,NULL,NULL,1,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(495,8019,42384,83712,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-21','2023-06-21',43560.00,NULL,NULL,1,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(496,8019,42384,83712,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-26','2023-06-26',20532.01,NULL,NULL,1,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(497,8019,42384,83712,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-27','2023-06-27',467394.69,NULL,NULL,1,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(498,8019,42384,83713,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',143649.99,NULL,NULL,1,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(499,8019,42384,83713,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',67499.85,NULL,NULL,1,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(500,8019,42384,83713,2,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',5850.00,NULL,NULL,1,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(501,8019,42384,83714,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-01','2023-08-01',56099.96,NULL,NULL,1,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL);
INSERT INTO `balance_libro` VALUES (502,8019,42384,83714,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-02','2023-08-02',53550.12,NULL,NULL,1,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(503,8019,42384,83714,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',89999.80,NULL,NULL,1,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(504,8019,42384,83714,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-03','2023-08-03',170999.62,NULL,NULL,1,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(505,8019,42384,83714,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',19800.00,NULL,NULL,1,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(506,8019,42384,83714,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-07','2023-08-07',14900.00,NULL,NULL,1,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(507,8019,42384,83714,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-15','2023-08-15',49000.16,NULL,NULL,1,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(508,8019,42384,83714,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-08-16','2023-08-16',85399.96,NULL,NULL,1,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(509,8019,42384,83713,3,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-04','2023-07-04',1905.39,NULL,NULL,1,'2023-08-19 21:16:36','2023-08-19 21:16:36',NULL),(510,8019,42384,83713,3,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-05','2023-07-05',36000.00,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(511,8019,42384,83713,3,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-07','2023-07-07',12927.04,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(512,8019,42384,83713,3,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-10','2023-07-10',1905.39,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(513,8019,42384,83713,3,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-12','2023-07-12',2160.00,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(514,8019,42384,83713,3,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-13','2023-07-13',99600.96,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(515,8019,42384,83713,3,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',19634.23,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(516,8019,42384,83713,3,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',2656.98,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(517,8019,42384,83713,3,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-14','2023-07-14',2656.98,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(518,8019,42384,83713,3,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-16','2023-07-16',1905.39,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(519,8019,42384,83713,3,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-16','2023-07-16',19634.23,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(520,8019,42384,83713,3,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-17','2023-07-17',99600.96,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(521,8019,42384,83713,3,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',99600.96,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:19:16','2023-08-19 21:19:16'),(522,8019,42384,83713,3,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-21','2023-07-21',5039.99,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL);
INSERT INTO `balance_libro` VALUES (523,8019,42384,83713,3,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-23','2023-07-23',147494.18,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(524,8019,42384,83713,3,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-27','2023-07-27',5039.99,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(525,8019,42384,83713,3,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-28','2023-07-28',5650.00,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(526,8019,42384,83713,3,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',5550.00,NULL,NULL,1,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(527,8019,42384,83713,3,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-31','2023-07-31',2700.00,NULL,NULL,1,'2023-08-19 21:16:38','2023-08-19 21:16:38',NULL),(528,8019,42384,83713,3,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-07-18','2023-07-18',99600.96,NULL,NULL,1,'2023-08-19 21:19:16','2023-08-19 21:19:16',NULL),(529,8019,42425,103843,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',518985.42,NULL,NULL,1,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(530,8019,42425,103843,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',11959761.48,NULL,NULL,1,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(531,8019,42425,103843,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1129008.65,NULL,NULL,1,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(532,8019,42425,103843,3,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',89394.80,NULL,NULL,1,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(533,8019,42425,103843,3,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',2119.99,NULL,NULL,1,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(534,8019,42425,103843,3,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',28749.34,NULL,NULL,1,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(535,8019,42425,103843,3,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-31','2023-12-31',37767.67,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(536,8019,42425,103843,3,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-01','2023-12-01',75000.00,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(537,8019,42425,103843,3,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',66190.02,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(538,8019,42425,103843,3,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',20880.50,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(539,8019,42425,103843,3,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-02','2023-12-02',11990.00,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(540,8019,42425,103843,3,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',20002.02,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(541,8019,42425,103843,3,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-03','2023-12-03',4966.32,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(542,8019,42425,103843,3,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',12000.99,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(543,8019,42425,103843,3,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-04','2023-12-04',695000.00,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL);
INSERT INTO `balance_libro` VALUES (544,8019,42425,103843,3,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',9936.84,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(545,8019,42425,103843,3,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',112170.00,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(546,8019,42425,103843,3,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-05','2023-12-05',50000.00,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(547,8019,42425,103843,3,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',2000.00,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(548,8019,42425,103843,3,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-06','2023-12-06',20134.33,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(549,8019,42425,103843,3,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-07','2023-12-07',9680.00,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(550,8019,42425,103843,3,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-09','2023-12-09',3170.01,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(551,8019,42425,103843,3,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-10','2023-12-10',23900.00,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(552,8019,42425,103843,3,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',128184.77,NULL,NULL,1,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(553,8019,42425,103843,3,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',13068.00,NULL,NULL,1,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(554,8019,42425,103843,3,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-11','2023-12-11',28500.00,NULL,NULL,1,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(555,8019,42425,103843,3,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-14','2023-12-14',60900.06,NULL,NULL,1,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(556,8019,42425,103843,3,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-15','2023-12-15',14336.00,NULL,NULL,1,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(557,8019,42425,103843,3,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-19','2023-12-19',1250.00,NULL,NULL,1,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(558,8019,42425,103843,3,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-20','2023-12-20',100330.00,NULL,NULL,1,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(559,8019,42425,103843,3,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-21','2023-12-21',19549.99,NULL,NULL,1,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(560,8019,42425,103843,3,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',29711.55,NULL,NULL,1,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(561,8019,42425,103843,3,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-22','2023-12-22',47042.12,NULL,NULL,1,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(562,8019,42425,103843,3,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-24','2023-12-24',3630.94,NULL,NULL,1,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(563,8019,42425,103843,3,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-12-29','2023-12-29',49960.01,NULL,NULL,1,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1779 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,8019,1,40720,19725,3,217,1,1641.94,NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(2,8019,1,40720,19725,3,68,1,344.81,NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(3,8019,1,40720,19725,3,217,1,16.42,NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(4,8019,1,40720,19725,3,57,2,2003.17,NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(5,8019,2,40720,19725,3,250,1,5500.00,NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(6,8019,2,40720,19725,3,57,2,5500.00,NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(7,8019,3,40720,19725,3,217,1,2197.44,NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(8,8019,3,40720,19725,3,68,1,531.63,NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(9,8019,3,40720,19725,3,217,1,149.44,NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(10,8019,3,40720,19725,3,57,2,2878.51,NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(11,8019,4,40720,19725,3,217,1,8768.60,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(12,8019,4,40720,19725,3,68,1,1841.41,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(13,8019,4,40720,19725,3,217,1,87.69,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(14,8019,4,40720,19725,3,57,2,10697.70,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(15,8019,5,40720,19725,3,217,1,6196.18,NULL,'2022-12-13 10:08:36','2022-12-13 10:09:54','2022-12-13 10:09:54'),(16,8019,5,40720,19725,3,68,1,1301.20,NULL,'2022-12-13 10:08:36','2022-12-13 10:09:54','2022-12-13 10:09:54'),(17,8019,5,40720,19725,3,217,1,61.96,NULL,'2022-12-13 10:08:36','2022-12-13 10:09:54','2022-12-13 10:09:54'),(18,8019,5,40720,19725,3,57,2,7559.34,NULL,'2022-12-13 10:08:36','2022-12-13 10:09:54','2022-12-13 10:09:54'),(19,8019,6,40720,19725,3,250,1,9500.00,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(20,8019,6,40720,19725,3,57,2,9500.00,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(21,8019,7,40720,19725,3,217,1,3595.02,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(22,8019,7,40720,19725,3,68,1,754.95,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(23,8019,7,40720,19725,3,57,2,4349.97,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(24,8019,8,40720,19725,3,217,1,958.68,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(25,8019,8,40720,19725,3,68,1,201.32,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(26,8019,8,40720,19725,3,57,2,1160.00,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(27,8019,9,40720,19725,3,250,1,600.00,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(28,8019,9,40720,19725,3,57,2,600.00,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(29,8019,10,40720,19725,3,217,1,4900.00,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(30,8019,10,40720,19725,3,68,1,1029.00,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(31,8019,10,40720,19725,3,57,2,5929.00,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(32,8019,11,40720,19725,3,217,1,1403.31,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(33,8019,11,40720,19725,3,68,1,294.69,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(34,8019,11,40720,19725,3,57,2,1698.00,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(35,8019,12,40720,19725,3,217,1,39924.51,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(36,8019,12,40720,19725,3,68,1,8384.15,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(37,8019,12,40720,19725,3,57,2,48308.66,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(38,8019,13,40720,19725,3,217,1,24339.00,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(39,8019,13,40720,19725,3,68,1,5111.19,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(40,8019,13,40720,19725,3,57,2,29450.19,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(41,8019,14,40720,19725,3,217,1,6196.18,NULL,'2022-12-13 10:09:54','2022-12-13 10:09:54',NULL),(42,8019,14,40720,19725,3,68,1,1301.20,NULL,'2022-12-13 10:09:54','2022-12-13 10:09:54',NULL);
INSERT INTO `balance_libro_details` VALUES (43,8019,14,40720,19725,3,217,1,61.96,NULL,'2022-12-13 10:09:54','2022-12-13 10:09:54',NULL),(44,8019,14,40720,19725,3,57,2,7559.34,NULL,'2022-12-13 10:09:54','2022-12-13 10:09:54',NULL),(45,8019,15,40720,19726,3,250,1,0.00,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(46,8019,15,40720,19726,3,57,2,0.00,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(47,8019,16,40720,19726,3,217,1,1641.94,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(48,8019,16,40720,19726,3,68,1,344.81,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(49,8019,16,40720,19726,3,217,1,16.42,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(50,8019,16,40720,19726,3,57,2,2003.17,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(51,8019,17,40720,19726,3,217,1,973.87,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(52,8019,17,40720,19726,3,68,1,204.51,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(53,8019,17,40720,19726,3,57,2,1178.38,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(54,8019,18,40720,19726,3,217,1,2859.70,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(55,8019,18,40720,19726,3,68,1,600.54,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(56,8019,18,40720,19726,3,57,2,3460.24,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(57,8019,19,40720,19726,3,217,1,2217.20,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(58,8019,19,40720,19726,3,68,1,232.81,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(59,8019,19,40720,19726,3,217,1,-0.01,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(60,8019,19,40720,19726,3,57,2,2450.00,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(61,8019,20,40720,19726,3,217,1,2567.00,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(62,8019,20,40720,19726,3,68,1,609.15,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(63,8019,20,40720,19726,3,217,1,164.15,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(64,8019,20,40720,19726,3,57,2,3340.30,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(65,8019,21,40720,19726,3,217,1,2447.29,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(66,8019,21,40720,19726,3,68,1,513.93,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(67,8019,21,40720,19726,3,57,2,2961.22,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(68,8019,22,40720,19726,3,217,1,1898.40,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(69,8019,22,40720,19726,3,68,1,398.66,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(70,8019,22,40720,19726,3,57,2,2297.06,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(71,8019,23,40720,19726,3,217,1,12111.07,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(72,8019,23,40720,19726,3,68,1,2543.33,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(73,8019,23,40720,19726,3,57,2,14654.40,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(74,8019,24,40720,19726,3,217,1,2644.63,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(75,8019,24,40720,19726,3,68,1,555.37,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(76,8019,24,40720,19726,3,57,2,3200.00,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(77,8019,25,40720,19726,3,250,1,5500.00,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(78,8019,25,40720,19726,3,57,2,5500.00,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(79,8019,26,40720,19726,3,250,1,9000.00,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(80,8019,26,40720,19726,3,57,2,9000.00,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(81,8019,27,40720,19726,3,217,1,2344.95,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(82,8019,27,40720,19726,3,68,1,492.44,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(83,8019,27,40720,19726,3,57,2,2837.39,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(84,8019,28,40720,19726,3,250,1,1600.00,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL);
INSERT INTO `balance_libro_details` VALUES (85,8019,28,40720,19726,3,57,2,1600.00,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(86,8019,29,40720,19726,3,250,1,845.00,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(87,8019,29,40720,19726,3,57,2,845.00,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(88,8019,30,40720,19727,3,217,1,2148.76,NULL,'2022-12-13 10:11:05','2022-12-13 10:11:05',NULL),(89,8019,30,40720,19727,3,68,1,451.24,NULL,'2022-12-13 10:11:05','2022-12-13 10:11:05',NULL),(90,8019,30,40720,19727,3,57,2,2600.00,NULL,'2022-12-13 10:11:05','2022-12-13 10:11:05',NULL),(91,8019,31,40720,19727,3,217,1,1641.94,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(92,8019,31,40720,19727,3,68,1,344.81,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(93,8019,31,40720,19727,3,217,1,16.42,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(94,8019,31,40720,19727,3,57,2,2003.17,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(95,8019,32,40720,19727,3,217,1,212074.69,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(96,8019,32,40720,19727,3,68,1,44535.68,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(97,8019,32,40720,19727,3,217,1,2120.75,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(98,8019,32,40720,19727,3,57,2,258731.12,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(99,8019,33,40720,19727,3,250,1,5500.00,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(100,8019,33,40720,19727,3,57,2,5500.00,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(101,8019,34,40720,19727,3,217,1,2303.78,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(102,8019,34,40720,19727,3,68,1,558.67,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(103,8019,34,40720,19727,3,217,1,157.83,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(104,8019,34,40720,19727,3,57,2,3020.28,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(105,8019,35,40720,19727,3,217,1,909.49,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(106,8019,35,40720,19727,3,68,1,190.99,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(107,8019,35,40720,19727,3,57,2,1100.48,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(108,8019,36,40720,19727,3,250,1,2000.00,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(109,8019,36,40720,19727,3,57,2,2000.00,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(110,8019,37,40720,19727,3,217,1,289.26,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(111,8019,37,40720,19727,3,68,1,60.74,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(112,8019,37,40720,19727,3,57,2,350.00,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(113,8019,38,40720,19727,3,217,1,2181.78,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(114,8019,38,40720,19727,3,68,1,458.17,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(115,8019,38,40720,19727,3,217,1,0.01,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(116,8019,38,40720,19727,3,57,2,2639.96,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(117,8019,39,40720,19727,3,217,1,5500.00,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(118,8019,39,40720,19727,3,68,1,1155.00,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(119,8019,39,40720,19727,3,57,2,6655.00,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(120,8019,40,40720,19727,3,217,1,1107.43,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(121,8019,40,40720,19727,3,68,1,232.56,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(122,8019,40,40720,19727,3,57,2,1339.99,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(123,8019,41,40720,19727,3,217,1,26161.44,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(124,8019,41,40720,19727,3,68,1,5493.90,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(125,8019,41,40720,19727,3,57,2,31655.34,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(126,8019,42,40720,19727,3,217,1,54303.10,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL);
INSERT INTO `balance_libro_details` VALUES (127,8019,42,40720,19727,3,68,1,11403.65,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(128,8019,42,40720,19727,3,57,2,65706.75,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(129,8019,43,40720,19727,3,217,1,2066.10,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(130,8019,43,40720,19727,3,68,1,433.88,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(131,8019,43,40720,19727,3,57,2,2499.98,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(132,8019,44,40720,19727,3,250,1,1632.74,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(133,8019,44,40720,19727,3,57,2,1632.74,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(134,8019,45,40720,19727,3,217,1,1763.63,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(135,8019,45,40720,19727,3,68,1,370.36,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(136,8019,45,40720,19727,3,57,2,2133.99,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(137,8019,46,40720,19727,3,250,1,28975.00,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(138,8019,46,40720,19727,3,57,2,28975.00,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(139,8019,47,40720,19727,3,217,1,3718.18,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(140,8019,47,40720,19727,3,68,1,780.82,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(141,8019,47,40720,19727,3,57,2,4499.00,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(142,8019,48,40720,19727,3,217,1,446.28,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(143,8019,48,40720,19727,3,68,1,93.72,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(144,8019,48,40720,19727,3,57,2,540.00,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(145,8019,49,40720,19728,3,217,1,1641.94,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(146,8019,49,40720,19728,3,68,1,344.81,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(147,8019,49,40720,19728,3,217,1,16.42,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(148,8019,49,40720,19728,3,57,2,2003.17,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(149,8019,50,40720,19728,3,217,1,479.34,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(150,8019,50,40720,19728,3,68,1,100.66,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(151,8019,50,40720,19728,3,57,2,580.00,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(152,8019,51,40720,19728,3,217,1,1363.36,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(153,8019,51,40720,19728,3,68,1,286.31,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(154,8019,51,40720,19728,3,57,2,1649.67,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(155,8019,52,40720,19728,3,217,1,1647.06,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(156,8019,52,40720,19728,3,68,1,172.94,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(157,8019,52,40720,19728,3,57,2,1820.00,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(158,8019,53,40720,19728,3,217,1,3529.34,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(159,8019,53,40720,19728,3,68,1,741.16,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(160,8019,53,40720,19728,3,217,1,35.29,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(161,8019,53,40720,19728,3,57,2,4305.79,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(162,8019,54,40720,19728,3,217,1,2465.00,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(163,8019,54,40720,19728,3,68,1,591.93,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(164,8019,54,40720,19728,3,217,1,163.76,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(165,8019,54,40720,19728,3,57,2,3220.69,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(166,8019,55,40720,19728,3,250,1,2000.00,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(167,8019,55,40720,19728,3,57,2,2000.00,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(168,8019,56,40720,19728,3,250,1,10800.00,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL);
INSERT INTO `balance_libro_details` VALUES (169,8019,56,40720,19728,3,57,2,10800.00,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(170,8019,57,40720,19728,3,250,1,5500.00,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(171,8019,57,40720,19728,3,57,2,5500.00,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(172,8019,58,40720,19728,3,217,1,87937.35,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(173,8019,58,40720,19728,3,68,1,18466.84,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(174,8019,58,40720,19728,3,217,1,879.37,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(175,8019,58,40720,19728,3,57,2,107283.56,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(176,8019,59,40720,19728,3,250,1,4549.95,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(177,8019,59,40720,19728,3,57,2,4549.95,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(178,8019,60,40720,19728,3,217,1,4118.50,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(179,8019,60,40720,19728,3,68,1,864.89,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(180,8019,60,40720,19728,3,57,2,4983.39,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(181,8019,61,40720,19728,3,217,1,3261.43,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(182,8019,61,40720,19728,3,68,1,684.90,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(183,8019,61,40720,19728,3,57,2,3946.33,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(184,8019,62,40720,19728,3,217,1,8090.91,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(185,8019,62,40720,19728,3,68,1,1699.09,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(186,8019,62,40720,19728,3,57,2,9790.00,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(187,8019,63,40720,19728,3,217,1,656.00,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(188,8019,63,40720,19728,3,68,1,137.76,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(189,8019,63,40720,19728,3,57,2,793.76,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(190,8019,64,40720,19728,3,217,1,330.58,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(191,8019,64,40720,19728,3,68,1,69.42,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(192,8019,64,40720,19728,3,57,2,400.00,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(193,8019,65,40720,19728,3,217,1,1218.18,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(194,8019,65,40720,19728,3,68,1,255.82,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(195,8019,65,40720,19728,3,57,2,1474.00,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(196,8019,66,40720,19728,3,217,1,47577.18,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(197,8019,66,40720,19728,3,68,1,9991.21,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(198,8019,66,40720,19728,3,217,1,475.77,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(199,8019,66,40720,19728,3,57,2,58044.16,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(200,8019,67,40720,19728,3,217,1,3148.73,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(201,8019,67,40720,19728,3,68,1,661.23,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(202,8019,67,40720,19728,3,57,2,3809.96,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(203,8019,68,40720,19728,3,217,1,1471.81,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(204,8019,68,40720,19728,3,68,1,309.08,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(205,8019,68,40720,19728,3,57,2,1780.89,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(206,8019,69,40720,19728,3,217,1,6691.08,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(207,8019,69,40720,19728,3,68,1,1405.13,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(208,8019,69,40720,19728,3,57,2,8096.21,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(209,8019,70,40720,19728,3,217,1,1652.89,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(210,8019,70,40720,19728,3,68,1,347.11,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL);
INSERT INTO `balance_libro_details` VALUES (211,8019,70,40720,19728,3,57,2,2000.00,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(212,8019,71,40720,19728,3,217,1,743.81,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(213,8019,71,40720,19728,3,68,1,156.20,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(214,8019,71,40720,19728,3,57,2,900.01,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(215,8019,72,40720,19728,3,250,1,892.50,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(216,8019,72,40720,19728,3,57,2,892.50,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(217,8019,73,40720,19728,3,250,1,892.50,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(218,8019,73,40720,19728,3,57,2,892.50,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(219,8019,74,40720,19728,3,217,1,2677.69,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(220,8019,74,40720,19728,3,68,1,562.31,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(221,8019,74,40720,19728,3,57,2,3240.00,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(222,8019,75,40720,19728,3,250,1,700.00,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(223,8019,75,40720,19728,3,57,2,700.00,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(224,8019,76,40720,19728,3,217,1,159.35,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(225,8019,76,40720,19728,3,68,1,33.46,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(226,8019,76,40720,19728,3,57,2,192.81,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(227,8019,77,40720,19729,3,217,1,2395.87,NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(228,8019,77,40720,19729,3,68,1,503.13,NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(229,8019,77,40720,19729,3,217,1,23.96,NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(230,8019,77,40720,19729,3,57,2,2922.96,NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(231,8019,78,40720,19729,3,217,1,1985.89,NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(232,8019,78,40720,19729,3,68,1,417.04,NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(233,8019,78,40720,19729,3,57,2,2402.93,NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(234,8019,79,40720,19729,3,217,1,5657.92,NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(235,8019,79,40720,19729,3,68,1,1188.16,NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(236,8019,79,40720,19729,3,57,2,6846.08,NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(237,8019,80,40720,19729,3,217,1,826.45,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(238,8019,80,40720,19729,3,68,1,173.55,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(239,8019,80,40720,19729,3,57,2,1000.00,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(240,8019,81,40720,19729,3,217,1,4180.72,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(241,8019,81,40720,19729,3,68,1,877.95,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(242,8019,81,40720,19729,3,217,1,41.81,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(243,8019,81,40720,19729,3,57,2,5100.48,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(244,8019,82,40720,19729,3,217,1,10485.41,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(245,8019,82,40720,19729,3,68,1,2201.94,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(246,8019,82,40720,19729,3,217,1,104.85,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(247,8019,82,40720,19729,3,57,2,12792.20,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(248,8019,83,40720,19729,3,217,1,13479.00,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(249,8019,83,40720,19729,3,68,1,2911.53,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(250,8019,83,40720,19729,3,217,1,610.16,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(251,8019,83,40720,19729,3,57,2,17000.69,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(252,8019,84,40720,19729,3,250,1,2000.00,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL);
INSERT INTO `balance_libro_details` VALUES (253,8019,84,40720,19729,3,57,2,2000.00,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(254,8019,85,40720,19729,3,250,1,5500.00,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(255,8019,85,40720,19729,3,57,2,5500.00,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(256,8019,86,40720,19729,3,250,1,10800.00,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(257,8019,86,40720,19729,3,57,2,10800.00,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(258,8019,87,40720,19729,3,217,1,39825.62,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(259,8019,87,40720,19729,3,68,1,8363.38,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(260,8019,87,40720,19729,3,57,2,48189.00,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(261,8019,88,40720,19729,3,217,1,1049.59,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(262,8019,88,40720,19729,3,68,1,220.41,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(263,8019,88,40720,19729,3,57,2,1270.00,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(264,8019,89,40720,19729,3,217,1,685.95,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(265,8019,89,40720,19729,3,68,1,144.05,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(266,8019,89,40720,19729,3,57,2,830.00,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(267,8019,90,40720,19729,3,217,1,991.74,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(268,8019,90,40720,19729,3,68,1,208.27,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(269,8019,90,40720,19729,3,57,2,1200.01,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(270,8019,91,40720,19729,3,217,1,58496.10,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(271,8019,91,40720,19729,3,68,1,12284.18,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(272,8019,91,40720,19729,3,57,2,70780.28,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(273,8019,92,40720,19729,3,217,1,12395.87,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(274,8019,92,40720,19729,3,68,1,2603.13,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(275,8019,92,40720,19729,3,57,2,14999.00,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(276,8019,93,40720,19729,3,217,1,826.45,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(277,8019,93,40720,19729,3,68,1,173.55,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(278,8019,93,40720,19729,3,57,2,1000.00,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(279,8019,94,40720,19729,3,217,1,29287.94,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(280,8019,94,40720,19729,3,68,1,6150.47,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(281,8019,94,40720,19729,3,57,2,35438.41,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(282,8019,95,40720,19729,3,217,1,1089.25,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(283,8019,95,40720,19729,3,68,1,228.74,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(284,8019,95,40720,19729,3,57,2,1317.99,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(285,8019,96,40720,19729,3,217,1,685.92,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(286,8019,96,40720,19729,3,68,1,144.04,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(287,8019,96,40720,19729,3,217,1,0.03,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(288,8019,96,40720,19729,3,57,2,829.99,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(289,8019,97,40720,19730,3,217,1,2395.87,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(290,8019,97,40720,19730,3,68,1,503.13,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(291,8019,97,40720,19730,3,217,1,23.96,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(292,8019,97,40720,19730,3,57,2,2922.96,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(293,8019,98,40720,19730,3,217,1,413.22,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(294,8019,98,40720,19730,3,68,1,86.78,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL);
INSERT INTO `balance_libro_details` VALUES (295,8019,98,40720,19730,3,57,2,500.00,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(296,8019,99,40720,19730,3,217,1,62809.92,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(297,8019,99,40720,19730,3,68,1,13190.08,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(298,8019,99,40720,19730,3,57,2,76000.00,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(299,8019,100,40720,19730,3,217,1,18899.29,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(300,8019,100,40720,19730,3,68,1,3968.85,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(301,8019,100,40720,19730,3,57,2,22868.14,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(302,8019,101,40720,19730,3,250,1,10800.00,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(303,8019,101,40720,19730,3,57,2,10800.00,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(304,8019,102,40720,19730,3,217,1,984.79,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(305,8019,102,40720,19730,3,68,1,206.81,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(306,8019,102,40720,19730,3,57,2,1191.60,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(307,8019,103,40720,19730,3,217,1,3117.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(308,8019,103,40720,19730,3,68,1,750.55,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(309,8019,103,40720,19730,3,217,1,206.18,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(310,8019,103,40720,19730,3,57,2,4073.73,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(311,8019,104,40720,19730,3,217,1,4380.17,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(312,8019,104,40720,19730,3,68,1,919.84,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(313,8019,104,40720,19730,3,217,1,-0.01,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(314,8019,104,40720,19730,3,57,2,5300.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(315,8019,105,40720,19730,3,250,1,960.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(316,8019,105,40720,19730,3,57,2,960.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(317,8019,106,40720,19730,3,250,1,5500.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(318,8019,106,40720,19730,3,57,2,5500.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(319,8019,107,40720,19730,3,217,1,3894.50,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(320,8019,107,40720,19730,3,68,1,817.85,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(321,8019,107,40720,19730,3,217,1,38.95,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(322,8019,107,40720,19730,3,57,2,4751.30,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(323,8019,108,40720,19730,3,217,1,2066.23,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(324,8019,108,40720,19730,3,68,1,433.91,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(325,8019,108,40720,19730,3,217,1,-0.10,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(326,8019,108,40720,19730,3,57,2,2500.04,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(327,8019,109,40720,19730,3,217,1,1719.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(328,8019,109,40720,19730,3,68,1,360.99,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(329,8019,109,40720,19730,3,57,2,2079.99,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(330,8019,110,40720,19730,3,217,1,29904.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(331,8019,110,40720,19730,3,68,1,6279.84,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(332,8019,110,40720,19730,3,57,2,36183.84,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(333,8019,111,40720,19730,3,217,1,504.13,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(334,8019,111,40720,19730,3,68,1,105.87,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(335,8019,111,40720,19730,3,57,2,610.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL);
INSERT INTO `balance_libro_details` VALUES (336,8019,112,40720,19730,3,217,1,1355.76,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(337,8019,112,40720,19730,3,68,1,284.71,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(338,8019,112,40720,19730,3,57,2,1640.47,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(339,8019,113,40720,19730,3,217,1,2164.46,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(340,8019,113,40720,19730,3,68,1,454.54,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(341,8019,113,40720,19730,3,217,1,30.70,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(342,8019,113,40720,19730,3,57,2,2649.70,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(343,8019,114,40720,19730,3,217,1,1595.04,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(344,8019,114,40720,19730,3,68,1,334.96,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(345,8019,114,40720,19730,3,57,2,1930.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(346,8019,115,40720,19730,3,217,1,2986.43,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(347,8019,115,40720,19730,3,68,1,313.58,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(348,8019,115,40720,19730,3,217,1,-0.01,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(349,8019,115,40720,19730,3,57,2,3300.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(350,8019,116,40720,19730,3,217,1,11708.26,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(351,8019,116,40720,19730,3,68,1,2458.73,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(352,8019,116,40720,19730,3,57,2,14166.99,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(353,8019,117,40720,19730,3,217,1,2066.12,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(354,8019,117,40720,19730,3,68,1,433.88,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(355,8019,117,40720,19730,3,57,2,2500.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(356,8019,118,40720,19730,3,250,1,2000.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(357,8019,118,40720,19730,3,57,2,2000.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(358,8019,119,40720,19730,3,217,1,6936.74,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(359,8019,119,40720,19730,3,68,1,1456.72,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(360,8019,119,40720,19730,3,217,1,69.37,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(361,8019,119,40720,19730,3,57,2,8462.83,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(362,8019,120,40720,19730,3,217,1,59529.60,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(363,8019,120,40720,19730,3,68,1,12501.22,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(364,8019,120,40720,19730,3,57,2,72030.82,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(365,8019,121,40720,19730,3,217,1,30758.40,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(366,8019,121,40720,19730,3,68,1,6459.26,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(367,8019,121,40720,19730,3,57,2,37217.66,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(368,8019,122,40720,19730,3,217,1,991.73,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(369,8019,122,40720,19730,3,68,1,208.26,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(370,8019,122,40720,19730,3,57,2,1199.99,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(371,8019,123,40720,19730,3,217,1,446.28,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(372,8019,123,40720,19730,3,68,1,93.72,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(373,8019,123,40720,19730,3,57,2,540.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(374,8019,124,40720,19730,3,217,1,661.16,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(375,8019,124,40720,19730,3,68,1,138.84,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(376,8019,124,40720,19730,3,57,2,800.00,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL);
INSERT INTO `balance_libro_details` VALUES (377,8019,125,40720,19731,3,217,1,4231.41,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(378,8019,125,40720,19731,3,68,1,888.60,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(379,8019,125,40720,19731,3,57,2,5120.00,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(380,8019,125,40720,19731,3,136,2,0.01,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(381,8019,126,40720,19731,3,217,1,2395.87,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(382,8019,126,40720,19731,3,68,1,503.13,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(383,8019,126,40720,19731,3,217,1,23.96,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(384,8019,126,40720,19731,3,57,2,2922.96,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(385,8019,127,40720,19731,3,217,1,446.28,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(386,8019,127,40720,19731,3,68,1,93.72,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(387,8019,127,40720,19731,3,57,2,540.00,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(388,8019,128,40720,19731,3,217,1,2842.97,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(389,8019,128,40720,19731,3,68,1,597.02,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(390,8019,128,40720,19731,3,57,2,3439.99,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(391,8019,129,40720,19731,3,217,1,2932.44,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(392,8019,129,40720,19731,3,68,1,708.81,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(393,8019,129,40720,19731,3,217,1,198.87,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(394,8019,129,40720,19731,3,57,2,3840.12,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(395,8019,130,40720,19731,3,250,1,5500.00,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(396,8019,130,40720,19731,3,57,2,5500.00,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(397,8019,131,40720,19731,3,250,1,10800.00,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(398,8019,131,40720,19731,3,57,2,10800.00,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(399,8019,132,40720,19731,3,217,1,2463.76,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(400,8019,132,40720,19731,3,68,1,517.39,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(401,8019,132,40720,19731,3,57,2,2981.15,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(402,8019,133,40720,19731,3,217,1,1652.90,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(403,8019,133,40720,19731,3,68,1,347.11,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(404,8019,133,40720,19731,3,57,2,2000.01,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(405,8019,134,40720,19731,3,217,1,21051.68,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(406,8019,134,40720,19731,3,68,1,4420.85,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(407,8019,134,40720,19731,3,217,1,198.30,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(408,8019,134,40720,19731,3,57,2,25670.83,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(409,8019,135,40720,19731,3,217,1,206.61,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(410,8019,135,40720,19731,3,68,1,43.39,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(411,8019,135,40720,19731,3,57,2,250.00,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(412,8019,136,40720,19731,3,217,1,4710.74,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(413,8019,136,40720,19731,3,68,1,989.26,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(414,8019,136,40720,19731,3,57,2,5700.00,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(415,8019,137,40720,19731,3,250,1,3135.00,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(416,8019,137,40720,19731,3,57,2,3135.00,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(417,8019,138,40720,19731,3,250,1,2000.00,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL);
INSERT INTO `balance_libro_details` VALUES (418,8019,138,40720,19731,3,57,2,2000.00,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(419,8019,139,40720,19731,3,217,1,18735.97,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(420,8019,139,40720,19731,3,68,1,3934.55,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(421,8019,139,40720,19731,3,217,1,187.36,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(422,8019,139,40720,19731,3,57,2,22857.88,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(423,8019,140,40720,19731,3,217,1,227041.74,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(424,8019,140,40720,19731,3,68,1,47678.76,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(425,8019,140,40720,19731,3,217,1,2270.42,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(426,8019,140,40720,19731,3,57,2,276990.92,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(427,8019,141,40720,19731,3,217,1,7734.50,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(428,8019,141,40720,19731,3,68,1,1624.25,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(429,8019,141,40720,19731,3,217,1,77.35,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(430,8019,141,40720,19731,3,57,2,9436.10,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(431,8019,142,40720,19732,3,217,1,2726.45,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(432,8019,142,40720,19732,3,68,1,572.55,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(433,8019,142,40720,19732,3,217,1,27.26,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(434,8019,142,40720,19732,3,57,2,3326.26,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(435,8019,143,40720,19732,3,250,1,7500.00,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(436,8019,143,40720,19732,3,57,2,7500.00,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(437,8019,144,40720,19732,3,217,1,13330.57,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(438,8019,144,40720,19732,3,68,1,2799.42,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(439,8019,144,40720,19732,3,57,2,16129.99,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(440,8019,145,40720,19732,3,217,1,2934.00,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(441,8019,145,40720,19732,3,68,1,709.24,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(442,8019,145,40720,19732,3,217,1,199.02,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(443,8019,145,40720,19732,3,57,2,3842.26,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(444,8019,146,40720,19732,3,217,2,306.06,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(445,8019,146,40720,19732,3,67,2,60.80,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(446,8019,146,40720,19732,3,217,2,8.85,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(447,8019,146,40720,19732,3,57,1,375.70,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(448,8019,146,40720,19732,3,136,2,0.01,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(449,8019,147,40720,19732,3,250,1,12500.00,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(450,8019,147,40720,19732,3,57,2,12500.00,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(451,8019,148,40720,19732,3,217,1,3876.03,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(452,8019,148,40720,19732,3,68,1,813.97,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(453,8019,148,40720,19732,3,57,2,4690.00,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(454,8019,149,40720,19732,3,217,1,29936.90,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(455,8019,149,40720,19732,3,68,1,6286.75,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(456,8019,149,40720,19732,3,217,1,299.37,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(457,8019,149,40720,19732,3,57,2,36523.02,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(458,8019,150,40720,19732,3,217,1,4363.64,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL);
INSERT INTO `balance_libro_details` VALUES (459,8019,150,40720,19732,3,68,1,916.36,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(460,8019,150,40720,19732,3,57,2,5280.00,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(461,8019,151,40720,19732,3,217,1,1069.42,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(462,8019,151,40720,19732,3,68,1,224.58,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(463,8019,151,40720,19732,3,57,2,1294.00,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(464,8019,152,40720,19732,3,250,1,2700.00,NULL,'2022-12-13 10:15:02','2022-12-13 10:15:02',NULL),(465,8019,152,40720,19732,3,57,2,2700.00,NULL,'2022-12-13 10:15:02','2022-12-13 10:15:02',NULL),(466,8019,153,40720,19733,3,217,1,2767.77,NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(467,8019,153,40720,19733,3,68,1,581.23,NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(468,8019,153,40720,19733,3,217,1,27.68,NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(469,8019,153,40720,19733,3,57,2,3376.68,NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(470,8019,154,40720,19733,3,217,1,867.77,NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(471,8019,154,40720,19733,3,68,1,182.23,NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(472,8019,154,40720,19733,3,57,2,1050.00,NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(473,8019,155,40720,19733,3,217,1,1248.87,NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(474,8019,155,40720,19733,3,68,1,131.13,NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(475,8019,155,40720,19733,3,57,2,1380.00,NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(476,8019,156,40720,19733,3,217,1,1074.40,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(477,8019,156,40720,19733,3,68,1,225.62,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(478,8019,156,40720,19733,3,57,2,1300.02,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(479,8019,157,40720,19733,3,217,1,12492.28,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(480,8019,157,40720,19733,3,68,1,2623.38,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(481,8019,157,40720,19733,3,57,2,15115.66,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(482,8019,158,40720,19733,3,217,1,12492.28,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(483,8019,158,40720,19733,3,68,1,2623.38,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(484,8019,158,40720,19733,3,57,2,15115.66,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(485,8019,159,40720,19733,3,217,1,18044.02,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(486,8019,159,40720,19733,3,68,1,3789.24,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(487,8019,159,40720,19733,3,57,2,21833.26,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(488,8019,160,40720,19733,3,250,1,7500.00,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(489,8019,160,40720,19733,3,57,2,7500.00,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(490,8019,161,40720,19733,3,217,1,2931.00,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(491,8019,161,40720,19733,3,68,1,708.43,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(492,8019,161,40720,19733,3,217,1,198.74,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(493,8019,161,40720,19733,3,57,2,3838.17,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(494,8019,162,40720,19733,3,217,1,42975.21,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(495,8019,162,40720,19733,3,68,1,9024.79,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(496,8019,162,40720,19733,3,57,2,52000.00,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(497,8019,163,40720,19733,3,217,1,2368.92,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(498,8019,163,40720,19733,3,68,1,497.47,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(499,8019,163,40720,19733,3,217,1,33.61,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL);
INSERT INTO `balance_libro_details` VALUES (500,8019,163,40720,19733,3,57,2,2900.00,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(501,8019,164,40720,19733,3,217,1,608.43,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(502,8019,164,40720,19733,3,68,1,84.80,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(503,8019,164,40720,19733,3,57,2,693.23,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(504,8019,165,40720,19733,3,217,1,1123.97,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(505,8019,165,40720,19733,3,68,1,236.03,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(506,8019,165,40720,19733,3,57,2,1360.00,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(507,8019,166,40720,19733,3,217,1,2413.22,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(508,8019,166,40720,19733,3,68,1,506.78,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(509,8019,166,40720,19733,3,57,2,2920.00,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(510,8019,167,40720,19733,3,217,1,2769.76,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(511,8019,167,40720,19733,3,68,1,581.65,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(512,8019,167,40720,19733,3,217,1,39.29,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(513,8019,167,40720,19733,3,57,2,3390.70,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(514,8019,168,40720,19733,3,217,1,4958.68,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(515,8019,168,40720,19733,3,68,1,1041.32,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(516,8019,168,40720,19733,3,57,2,6000.00,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(517,8019,169,40720,19733,3,217,1,1446.28,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(518,8019,169,40720,19733,3,68,1,303.72,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(519,8019,169,40720,19733,3,57,2,1750.00,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(520,8019,170,40720,19733,3,217,1,859.50,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(521,8019,170,40720,19733,3,68,1,180.50,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(522,8019,170,40720,19733,3,57,2,1040.00,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(523,8019,171,40720,19733,3,217,1,8709.60,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(524,8019,171,40720,19733,3,68,1,1829.02,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(525,8019,171,40720,19733,3,217,1,87.10,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(526,8019,171,40720,19733,3,57,2,10625.72,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(527,8019,172,40720,19733,3,217,1,11157.03,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(528,8019,172,40720,19733,3,68,1,2342.98,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(529,8019,172,40720,19733,3,57,2,13500.01,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(530,8019,173,40720,19733,3,217,1,3795.96,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(531,8019,173,40720,19733,3,68,1,797.15,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(532,8019,173,40720,19733,3,57,2,4593.11,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(533,8019,174,40720,19733,3,217,1,1615.86,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(534,8019,174,40720,19733,3,68,1,339.33,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(535,8019,174,40720,19733,3,57,2,1955.19,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(536,8019,175,40720,19733,3,217,1,7163.83,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(537,8019,175,40720,19733,3,68,1,1504.40,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(538,8019,175,40720,19733,3,57,2,8668.23,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(539,8019,176,40720,19733,3,217,1,64619.60,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(540,8019,176,40720,19733,3,68,1,13570.12,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL);
INSERT INTO `balance_libro_details` VALUES (541,8019,176,40720,19733,3,57,2,78189.72,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(542,8019,177,40720,19734,3,217,1,2726.45,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(543,8019,177,40720,19734,3,68,1,572.55,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(544,8019,177,40720,19734,3,217,1,27.26,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(545,8019,177,40720,19734,3,57,2,3326.26,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(546,8019,178,40720,19734,3,217,1,1398.60,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(547,8019,178,40720,19734,3,68,1,293.71,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(548,8019,178,40720,19734,3,57,2,1692.31,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(549,8019,179,40720,19734,3,217,1,363.64,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(550,8019,179,40720,19734,3,68,1,76.36,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(551,8019,179,40720,19734,3,57,2,440.00,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(552,8019,180,40720,19734,3,250,1,7500.00,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(553,8019,180,40720,19734,3,57,2,7500.00,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(554,8019,181,40720,19734,3,217,1,14655.00,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(555,8019,181,40720,19734,3,68,1,3542.11,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(556,8019,181,40720,19734,3,217,1,993.70,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(557,8019,181,40720,19734,3,57,2,19190.81,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(558,8019,182,40720,19734,3,217,1,30246.21,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(559,8019,182,40720,19734,3,68,1,6351.70,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(560,8019,182,40720,19734,3,57,2,36597.91,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(561,8019,183,40720,19734,3,217,1,87820.60,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(562,8019,183,40720,19734,3,68,1,18442.32,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(563,8019,183,40720,19734,3,217,1,3512.83,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(564,8019,183,40720,19734,3,57,2,109775.75,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(565,8019,184,40720,19734,3,217,1,2297.52,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(566,8019,184,40720,19734,3,68,1,482.48,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(567,8019,184,40720,19734,3,57,2,2780.00,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(568,8019,185,40720,19734,3,217,1,37908.61,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(569,8019,185,40720,19734,3,68,1,7960.81,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(570,8019,185,40720,19734,3,57,2,45869.42,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(571,8019,186,40720,19734,3,250,1,11000.00,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(572,8019,186,40720,19734,3,57,2,11000.00,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(573,8019,187,40720,19734,3,217,1,3296.69,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(574,8019,187,40720,19734,3,68,1,692.31,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(575,8019,187,40720,19734,3,57,2,3989.00,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(576,8019,188,40720,19734,3,217,1,909.09,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(577,8019,188,40720,19734,3,68,1,190.91,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(578,8019,188,40720,19734,3,57,2,1100.00,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(579,8019,189,40720,19734,3,217,1,661.16,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(580,8019,189,40720,19734,3,68,1,138.84,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(581,8019,189,40720,19734,3,57,2,800.00,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL);
INSERT INTO `balance_libro_details` VALUES (582,8019,190,40720,19734,3,217,1,2694.21,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(583,8019,190,40720,19734,3,68,1,565.79,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(584,8019,190,40720,19734,3,57,2,3260.00,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(585,8019,191,40720,19734,3,217,1,18627.55,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(586,8019,191,40720,19734,3,68,1,3911.79,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(587,8019,191,40720,19734,3,217,1,186.28,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(588,8019,191,40720,19734,3,57,2,22725.62,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(589,8019,192,40720,19734,3,217,1,2553.72,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(590,8019,192,40720,19734,3,68,1,536.28,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(591,8019,192,40720,19734,3,57,2,3090.00,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(592,8019,193,40720,19734,3,217,1,7986.13,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(593,8019,193,40720,19734,3,68,1,1677.09,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(594,8019,193,40720,19734,3,217,1,79.87,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(595,8019,193,40720,19734,3,57,2,9743.09,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(596,8019,194,40720,19734,3,217,1,12346.03,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(597,8019,194,40720,19734,3,68,1,2592.67,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(598,8019,194,40720,19734,3,217,1,123.47,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(599,8019,194,40720,19734,3,57,2,15062.17,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(600,8019,195,40720,19734,3,217,1,17047.08,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(601,8019,195,40720,19734,3,68,1,3579.89,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(602,8019,195,40720,19734,3,217,1,170.46,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(603,8019,195,40720,19734,3,57,2,20797.43,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(604,8019,196,40720,19734,3,217,1,756.36,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(605,8019,196,40720,19734,3,68,1,158.84,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(606,8019,196,40720,19734,3,57,2,915.20,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(607,8019,197,40720,19734,3,217,1,5124.11,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(608,8019,197,40720,19734,3,68,1,1076.06,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(609,8019,197,40720,19734,3,57,2,6200.17,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(610,8019,198,40720,19734,3,217,1,732.60,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(611,8019,198,40720,19734,3,68,1,153.85,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(612,8019,198,40720,19734,3,57,2,886.45,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(613,8019,199,40720,19734,3,217,1,12574.02,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(614,8019,199,40720,19734,3,68,1,2640.54,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(615,8019,199,40720,19734,3,217,1,125.74,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(616,8019,199,40720,19734,3,57,2,15340.30,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(617,8019,200,40720,19735,3,217,1,826.45,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(618,8019,200,40720,19735,3,68,1,173.55,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(619,8019,200,40720,19735,3,57,2,1000.00,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(620,8019,201,40720,19735,3,250,1,7500.00,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(621,8019,201,40720,19735,3,57,2,7500.00,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(622,8019,202,40720,19735,3,217,1,3428.92,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL);
INSERT INTO `balance_libro_details` VALUES (623,8019,202,40720,19735,3,68,1,720.07,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(624,8019,202,40720,19735,3,217,1,34.29,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(625,8019,202,40720,19735,3,57,2,4183.28,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(626,8019,203,40720,19735,3,217,1,2479.34,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(627,8019,203,40720,19735,3,68,1,520.66,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(628,8019,203,40720,19735,3,57,2,3000.00,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(629,8019,204,40720,19735,3,217,1,24161.16,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(630,8019,204,40720,19735,3,68,1,5073.84,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(631,8019,204,40720,19735,3,217,1,966.44,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(632,8019,204,40720,19735,3,57,2,30201.44,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(633,8019,205,40720,19735,3,217,1,5801.65,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(634,8019,205,40720,19735,3,68,1,1218.35,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(635,8019,205,40720,19735,3,57,2,7020.00,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(636,8019,206,40720,19735,3,217,1,17297.90,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(637,8019,206,40720,19735,3,68,1,4130.44,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(638,8019,206,40720,19735,3,217,1,1128.66,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(639,8019,206,40720,19735,3,57,2,22557.00,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(640,8019,207,40720,19735,3,250,1,7000.00,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(641,8019,207,40720,19735,3,57,2,7000.00,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(642,8019,208,40720,19735,3,217,1,10345.74,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(643,8019,208,40720,19735,3,68,1,2172.61,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(644,8019,208,40720,19735,3,217,1,-0.34,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(645,8019,208,40720,19735,3,57,2,12518.01,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(646,8019,209,40720,19735,3,217,1,7024.79,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(647,8019,209,40720,19735,3,68,1,1475.21,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(648,8019,209,40720,19735,3,57,2,8500.00,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(649,8019,210,40720,19735,3,217,1,271.49,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(650,8019,210,40720,19735,3,68,1,28.51,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(651,8019,210,40720,19735,3,57,2,300.00,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(652,8019,211,40720,19735,3,217,1,950.41,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(653,8019,211,40720,19735,3,68,1,199.59,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(654,8019,211,40720,19735,3,57,2,1150.00,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(655,8019,212,40720,19735,3,217,1,10673.56,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(656,8019,212,40720,19735,3,68,1,2241.45,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(657,8019,212,40720,19735,3,217,1,106.74,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(658,8019,212,40720,19735,3,57,2,13021.75,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(659,8019,213,40720,19735,3,217,1,4504.13,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(660,8019,213,40720,19735,3,68,1,945.87,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(661,8019,213,40720,19735,3,57,2,5450.00,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(662,8019,214,40720,19735,3,217,1,4297.52,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(663,8019,214,40720,19735,3,68,1,902.48,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL);
INSERT INTO `balance_libro_details` VALUES (664,8019,214,40720,19735,3,57,2,5200.00,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(665,8019,215,40720,19735,3,217,1,69060.60,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(666,8019,215,40720,19735,3,68,1,14502.73,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(667,8019,215,40720,19735,3,57,2,83563.33,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(668,8019,216,40720,19735,3,217,1,2937.09,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(669,8019,216,40720,19735,3,68,1,616.79,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(670,8019,216,40720,19735,3,57,2,3553.88,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(671,8019,217,40720,19735,3,217,1,3856.73,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(672,8019,217,40720,19735,3,68,1,809.91,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(673,8019,217,40720,19735,3,57,2,4666.64,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(674,8019,218,40720,19735,3,217,1,6032.23,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(675,8019,218,40720,19735,3,68,1,1253.37,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(676,8019,218,40720,19735,3,57,2,7285.60,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(677,8019,219,40720,19735,3,217,1,4935.41,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(678,8019,219,40720,19735,3,68,1,1036.43,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(679,8019,219,40720,19735,3,57,2,5971.84,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(680,8019,220,40720,19735,3,217,1,31083.46,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(681,8019,220,40720,19735,3,68,1,6527.53,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(682,8019,220,40720,19735,3,57,2,37610.99,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(683,8019,221,40720,19735,3,217,1,249028.77,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(684,8019,221,40720,19735,3,68,1,52296.04,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(685,8019,221,40720,19735,3,217,1,2490.29,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(686,8019,221,40720,19735,3,57,2,303815.10,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(687,8019,222,40720,19736,3,250,1,7500.00,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(688,8019,222,40720,19736,3,57,2,7500.00,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(689,8019,223,40720,19736,3,217,1,3428.92,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(690,8019,223,40720,19736,3,68,1,720.07,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(691,8019,223,40720,19736,3,217,1,34.29,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(692,8019,223,40720,19736,3,57,2,4183.28,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(693,8019,224,40720,19736,3,217,1,12035.29,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(694,8019,224,40720,19736,3,68,1,1263.71,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(695,8019,224,40720,19736,3,57,2,13299.00,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(696,8019,225,40720,19736,3,217,1,8247.93,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(697,8019,225,40720,19736,3,68,1,1732.07,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(698,8019,225,40720,19736,3,57,2,9980.00,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(699,8019,226,40720,19736,3,217,1,1289.21,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(700,8019,226,40720,19736,3,68,1,270.73,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(701,8019,226,40720,19736,3,217,1,0.05,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(702,8019,226,40720,19736,3,57,2,1559.99,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(703,8019,227,40720,19736,3,217,1,157.90,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(704,8019,227,40720,19736,3,68,1,42.63,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL);
INSERT INTO `balance_libro_details` VALUES (705,8019,227,40720,19736,3,217,1,1.58,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(706,8019,227,40720,19736,3,57,2,202.11,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(707,8019,228,40720,19736,3,250,1,11000.00,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(708,8019,228,40720,19736,3,57,2,11000.00,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(709,8019,229,40720,19736,3,217,1,247.92,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(710,8019,229,40720,19736,3,68,1,52.06,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(711,8019,229,40720,19736,3,57,2,299.98,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(712,8019,230,40720,19736,3,217,1,24792.56,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(713,8019,230,40720,19736,3,68,1,5206.44,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(714,8019,230,40720,19736,3,57,2,29999.00,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(715,8019,231,40720,19736,3,217,1,3867.77,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(716,8019,231,40720,19736,3,68,1,812.23,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(717,8019,231,40720,19736,3,57,2,4680.00,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(718,8019,232,40720,19736,3,217,1,8602.31,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(719,8019,232,40720,19736,3,68,1,1806.49,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(720,8019,232,40720,19736,3,217,1,86.02,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(721,8019,232,40720,19736,3,57,2,10494.82,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(722,8019,233,40720,19736,3,217,1,42080.51,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(723,8019,233,40720,19736,3,68,1,8836.91,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(724,8019,233,40720,19736,3,57,2,50917.42,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(725,8019,234,40720,19736,3,217,1,19055.15,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(726,8019,234,40720,19736,3,68,1,4001.58,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(727,8019,234,40720,19736,3,57,2,23056.73,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(728,8019,235,40720,19736,3,217,1,14106.28,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(729,8019,235,40720,19736,3,68,1,2962.32,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(730,8019,235,40720,19736,3,217,1,141.06,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(731,8019,235,40720,19736,3,57,2,17209.66,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(732,8019,236,40720,19736,3,217,1,6675.62,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(733,8019,236,40720,19736,3,68,1,1401.88,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(734,8019,236,40720,19736,3,217,1,267.03,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(735,8019,236,40720,19736,3,57,2,8344.53,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(736,8019,237,40720,19736,3,217,1,3622.04,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(737,8019,237,40720,19736,3,68,1,760.63,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(738,8019,237,40720,19736,3,57,2,4382.67,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(739,8019,238,40720,19736,3,217,1,74592.00,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(740,8019,238,40720,19736,3,68,1,15664.32,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(741,8019,238,40720,19736,3,57,2,90256.32,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(742,8019,239,40720,19736,3,217,1,8025.32,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(743,8019,239,40720,19736,3,68,1,1685.32,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(744,8019,239,40720,19736,3,57,2,9710.64,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(745,8019,240,40720,19736,3,217,1,471.07,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL);
INSERT INTO `balance_libro_details` VALUES (746,8019,240,40720,19736,3,68,1,98.93,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(747,8019,240,40720,19736,3,57,2,570.00,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(748,8019,241,40720,19725,2,96,2,87120.00,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(749,8019,241,40720,19725,2,67,2,18295.20,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(750,8019,241,40720,19725,2,13,1,105415.20,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(751,8019,242,40720,19725,2,96,2,60000.00,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(752,8019,242,40720,19725,2,67,2,12600.00,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(753,8019,242,40720,19725,2,13,1,72600.00,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(754,8019,243,40720,19725,2,96,2,20160.00,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(755,8019,243,40720,19725,2,67,2,4233.60,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(756,8019,243,40720,19725,2,13,1,24393.60,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(757,8019,244,40720,19725,2,96,2,79850.00,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(758,8019,244,40720,19725,2,67,2,16768.50,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(759,8019,244,40720,19725,2,13,1,96618.50,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(760,8019,245,40720,19725,2,96,2,1528.93,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(761,8019,245,40720,19725,2,67,2,321.07,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(762,8019,245,40720,19725,2,13,1,1850.00,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(763,8019,246,40720,19726,2,96,2,41322.31,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(764,8019,246,40720,19726,2,67,2,8677.69,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(765,8019,246,40720,19726,2,13,1,50000.00,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(766,8019,247,40720,19726,2,96,2,41323.00,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(767,8019,247,40720,19726,2,67,2,8677.83,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(768,8019,247,40720,19726,2,13,1,50000.83,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(769,8019,248,40720,19726,2,96,1,41322.31,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(770,8019,248,40720,19726,2,68,1,8677.69,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(771,8019,248,40720,19726,2,13,2,50000.00,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(772,8019,249,40720,19726,2,96,2,20820.00,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(773,8019,249,40720,19726,2,67,2,4372.20,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(774,8019,249,40720,19726,2,13,1,25192.20,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(775,8019,250,40720,19726,2,96,2,36000.00,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(776,8019,250,40720,19726,2,67,2,7560.00,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(777,8019,250,40720,19726,2,13,1,43560.00,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(778,8019,251,40720,19727,2,96,2,26920.00,NULL,'2022-12-13 10:18:07','2022-12-13 10:18:07',NULL),(779,8019,251,40720,19727,2,67,2,5653.20,NULL,'2022-12-13 10:18:07','2022-12-13 10:18:07',NULL),(780,8019,251,40720,19727,2,13,1,32573.20,NULL,'2022-12-13 10:18:07','2022-12-13 10:18:07',NULL),(781,8019,252,40720,19727,2,96,2,21900.00,NULL,'2022-12-13 10:18:07','2022-12-13 10:18:07',NULL),(782,8019,252,40720,19727,2,67,2,4599.00,NULL,'2022-12-13 10:18:07','2022-12-13 10:18:07',NULL),(783,8019,252,40720,19727,2,13,1,26499.00,NULL,'2022-12-13 10:18:07','2022-12-13 10:18:07',NULL),(784,8019,253,40720,19728,2,96,2,29520.00,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(785,8019,253,40720,19728,2,67,2,6199.20,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(786,8019,253,40720,19728,2,13,1,35719.20,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL);
INSERT INTO `balance_libro_details` VALUES (787,8019,254,40720,19728,2,96,2,9560.00,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(788,8019,254,40720,19728,2,67,2,2007.60,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(789,8019,254,40720,19728,2,13,1,11567.60,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(790,8019,255,40720,19728,2,96,2,95895.00,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(791,8019,255,40720,19728,2,67,2,20137.95,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(792,8019,255,40720,19728,2,13,1,116032.95,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(793,8019,256,40720,19728,2,96,2,11550.00,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(794,8019,256,40720,19728,2,67,2,2425.50,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(795,8019,256,40720,19728,2,13,1,13975.50,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(796,8019,257,40720,19728,2,96,2,14784.00,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(797,8019,257,40720,19728,2,67,2,3104.64,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(798,8019,257,40720,19728,2,13,1,17888.64,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(799,8019,258,40720,19728,2,96,2,440000.00,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(800,8019,258,40720,19728,2,67,2,92400.00,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(801,8019,258,40720,19728,2,13,1,532400.00,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(802,8019,259,40720,19728,2,96,2,13860.00,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(803,8019,259,40720,19728,2,67,2,2910.60,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(804,8019,259,40720,19728,2,13,1,16770.60,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(805,8019,260,40720,19728,2,96,2,27336.00,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(806,8019,260,40720,19728,2,67,2,5740.56,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(807,8019,260,40720,19728,2,13,1,33076.56,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(808,8019,261,40720,19728,2,96,2,78100.00,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(809,8019,261,40720,19728,2,67,2,16401.00,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(810,8019,261,40720,19728,2,13,1,94501.00,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(811,8019,262,40720,19729,2,96,2,160000.00,NULL,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(812,8019,262,40720,19729,2,67,2,33600.00,NULL,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(813,8019,262,40720,19729,2,13,1,193600.00,NULL,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(814,8019,263,40720,19729,2,96,2,130000.00,NULL,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(815,8019,263,40720,19729,2,67,2,27300.00,NULL,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(816,8019,263,40720,19729,2,13,1,157300.00,NULL,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(817,8019,264,40720,19729,2,96,2,43290.00,NULL,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(818,8019,264,40720,19729,2,67,2,9090.90,NULL,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(819,8019,264,40720,19729,2,13,1,52380.90,NULL,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(820,8019,265,40720,19729,2,96,2,32226.00,NULL,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(821,8019,265,40720,19729,2,67,2,6767.46,NULL,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(822,8019,265,40720,19729,2,13,1,38993.46,NULL,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(823,8019,266,40720,19729,2,96,2,10150.00,NULL,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(824,8019,266,40720,19729,2,67,2,2131.50,NULL,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(825,8019,266,40720,19729,2,13,1,12281.50,NULL,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(826,8019,267,40720,19730,2,96,2,14400.00,NULL,'2022-12-13 10:22:09','2022-12-13 10:22:09',NULL),(827,8019,267,40720,19730,2,67,2,3024.00,NULL,'2022-12-13 10:22:09','2022-12-13 10:22:09',NULL);
INSERT INTO `balance_libro_details` VALUES (828,8019,267,40720,19730,2,13,1,17424.00,NULL,'2022-12-13 10:22:09','2022-12-13 10:22:09',NULL),(829,8019,268,40720,19731,2,96,2,44979.00,NULL,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(830,8019,268,40720,19731,2,67,2,9445.59,NULL,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(831,8019,268,40720,19731,2,13,1,54424.59,NULL,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(832,8019,269,40720,19731,2,96,2,70000.00,NULL,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(833,8019,269,40720,19731,2,67,2,14700.00,NULL,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(834,8019,269,40720,19731,2,13,1,84700.00,NULL,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(835,8019,270,40720,19731,2,96,2,74000.00,NULL,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(836,8019,270,40720,19731,2,67,2,15540.00,NULL,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(837,8019,270,40720,19731,2,13,1,89540.00,NULL,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(838,8019,271,40720,19732,2,96,2,6650.00,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(839,8019,271,40720,19732,2,67,2,1396.50,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(840,8019,271,40720,19732,2,13,1,8046.50,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(841,8019,272,40720,19732,2,96,2,13860.00,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(842,8019,272,40720,19732,2,67,2,2910.60,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(843,8019,272,40720,19732,2,13,1,16770.60,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(844,8019,273,40720,19732,2,96,2,1857.00,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(845,8019,273,40720,19732,2,67,2,389.97,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(846,8019,273,40720,19732,2,13,1,2246.97,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(847,8019,274,40720,19732,2,96,2,37060.00,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(848,8019,274,40720,19732,2,67,2,7782.60,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(849,8019,274,40720,19732,2,13,1,44842.60,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(850,8019,275,40720,19732,2,96,2,80000.00,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(851,8019,275,40720,19732,2,67,2,16800.00,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(852,8019,275,40720,19732,2,13,1,96800.00,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(853,8019,276,40720,19732,2,96,2,28160.00,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(854,8019,276,40720,19732,2,67,2,5913.60,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(855,8019,276,40720,19732,2,13,1,34073.60,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(856,8019,277,40720,19733,2,96,2,34276.00,NULL,'2022-12-13 10:23:22','2022-12-13 10:23:22',NULL),(857,8019,277,40720,19733,2,67,2,7197.96,NULL,'2022-12-13 10:23:22','2022-12-13 10:23:22',NULL),(858,8019,277,40720,19733,2,13,1,41473.96,NULL,'2022-12-13 10:23:22','2022-12-13 10:23:22',NULL),(859,8019,278,40720,19733,2,96,2,32231.40,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(860,8019,278,40720,19733,2,67,2,6768.60,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(861,8019,278,40720,19733,2,13,1,39000.00,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(862,8019,279,40720,19733,2,96,2,26284.00,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(863,8019,279,40720,19733,2,67,2,5519.64,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(864,8019,279,40720,19733,2,13,1,31803.64,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(865,8019,280,40720,19733,2,96,2,74000.00,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(866,8019,280,40720,19733,2,67,2,15540.00,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(867,8019,280,40720,19733,2,13,1,89540.00,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(868,8019,281,40720,19733,2,96,2,56000.00,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL);
INSERT INTO `balance_libro_details` VALUES (869,8019,281,40720,19733,2,67,2,11760.00,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(870,8019,281,40720,19733,2,13,1,67760.00,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(871,8019,282,40720,19734,2,96,2,13720.00,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(872,8019,282,40720,19734,2,67,2,2881.20,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(873,8019,282,40720,19734,2,13,1,16601.20,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(874,8019,283,40720,19734,2,96,2,59500.00,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(875,8019,283,40720,19734,2,67,2,12495.00,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(876,8019,283,40720,19734,2,13,1,71995.00,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(877,8019,284,40720,19734,2,96,2,2429.75,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(878,8019,284,40720,19734,2,67,2,510.25,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(879,8019,284,40720,19734,2,13,1,2940.00,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(880,8019,285,40720,19734,2,96,2,90000.00,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(881,8019,285,40720,19734,2,67,2,18900.00,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(882,8019,285,40720,19734,2,13,1,108900.00,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(883,8019,286,40720,19735,2,96,2,178500.00,NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(884,8019,286,40720,19735,2,67,2,37485.00,NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(885,8019,286,40720,19735,2,13,1,215985.00,NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(886,8019,287,40720,19735,2,96,2,53040.00,NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(887,8019,287,40720,19735,2,67,2,11138.40,NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(888,8019,287,40720,19735,2,13,1,64178.40,NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(889,8019,288,40720,19735,2,96,2,35100.00,NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(890,8019,288,40720,19735,2,67,2,7371.00,NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(891,8019,288,40720,19735,2,13,1,42471.00,NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(1072,8019,349,40861,70033,3,217,1,11040.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1073,8019,349,40861,70033,3,68,1,2318.40,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1074,8019,349,40861,70033,3,57,2,13358.40,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1075,8019,350,40861,70033,3,217,1,10500.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1076,8019,350,40861,70033,3,68,1,2205.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1077,8019,350,40861,70033,3,57,2,12705.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1078,8019,351,40861,70033,3,217,1,25000.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1079,8019,351,40861,70033,3,68,1,5250.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1080,8019,351,40861,70033,3,57,2,30250.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1081,8019,352,40861,70033,3,217,1,65000.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1082,8019,352,40861,70033,3,68,1,13650.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1083,8019,352,40861,70033,3,57,2,78650.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1084,8019,353,40861,70033,3,217,1,17279.16,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1085,8019,353,40861,70033,3,68,1,3628.62,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1086,8019,353,40861,70033,3,57,2,20907.78,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1087,8019,354,40861,70033,3,217,1,264318.60,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1088,8019,354,40861,70033,3,68,1,55506.91,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1089,8019,354,40861,70033,3,57,2,319825.51,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL);
INSERT INTO `balance_libro_details` VALUES (1090,8019,355,40861,70033,3,217,1,129600.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1091,8019,355,40861,70033,3,68,1,27216.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1092,8019,355,40861,70033,3,217,1,19.20,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1093,8019,355,40861,70033,3,57,2,158889.60,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1094,8019,355,40861,70033,3,136,1,2054.40,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1095,8019,356,40861,70033,3,217,1,1867.98,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1096,8019,356,40861,70033,3,68,1,392.28,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1097,8019,356,40861,70033,3,217,1,29.89,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1098,8019,356,40861,70033,3,57,2,2290.15,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1099,8019,357,40861,70033,3,217,1,100000.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1100,8019,357,40861,70033,3,68,1,21000.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1101,8019,357,40861,70033,3,57,2,121000.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1102,8019,358,40861,70033,3,217,1,22000.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1103,8019,358,40861,70033,3,68,1,4620.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1104,8019,358,40861,70033,3,57,2,26620.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1105,8019,359,40861,70033,3,217,1,2200.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1106,8019,359,40861,70033,3,68,1,462.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1107,8019,359,40861,70033,3,57,2,2662.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1108,8019,360,40861,70033,3,217,1,100000.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1109,8019,360,40861,70033,3,68,1,21000.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1110,8019,360,40861,70033,3,57,2,121000.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1111,8019,361,40861,70033,3,217,1,502.71,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1112,8019,361,40861,70033,3,68,1,105.59,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1113,8019,361,40861,70033,3,217,1,8.04,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1114,8019,361,40861,70033,3,57,2,616.34,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1115,8019,362,40861,70033,3,217,1,49628.88,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1116,8019,362,40861,70033,3,68,1,10422.06,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1117,8019,362,40861,70033,3,217,1,794.06,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1118,8019,362,40861,70033,3,57,2,60845.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1119,8019,363,40861,70033,3,217,1,105181.10,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1120,8019,363,40861,70033,3,68,1,22088.03,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1121,8019,363,40861,70033,3,217,1,1682.90,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1122,8019,363,40861,70033,3,57,2,128952.03,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1123,8019,364,40861,70033,3,217,1,6102095.95,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1124,8019,364,40861,70033,3,68,1,1281440.51,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1125,8019,364,40861,70033,3,217,1,2725.21,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1126,8019,364,40861,70033,3,57,2,7664233.09,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1127,8019,364,40861,70033,3,136,1,277971.42,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1128,8019,365,40861,70033,3,217,1,47402.50,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1129,8019,365,40861,70033,3,68,1,9797.76,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL);
INSERT INTO `balance_libro_details` VALUES (1130,8019,365,40861,70033,3,57,2,57200.26,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1131,8019,366,40861,70033,3,217,1,37476.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1132,8019,366,40861,70033,3,68,1,7869.96,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1133,8019,366,40861,70033,3,57,2,45345.96,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1134,8019,367,40861,70033,3,217,1,78000.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1135,8019,367,40861,70033,3,68,1,16380.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1136,8019,367,40861,70033,3,57,2,94380.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1137,8019,368,40861,70033,3,217,1,4000.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1138,8019,368,40861,70033,3,68,1,840.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1139,8019,368,40861,70033,3,57,2,4840.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1140,8019,369,40861,70033,3,217,1,15766.00,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1141,8019,369,40861,70033,3,68,1,3310.86,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1142,8019,369,40861,70033,3,57,2,19076.86,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(1143,8019,370,40861,70033,3,217,1,7905.39,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1144,8019,370,40861,70033,3,68,1,2134.46,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1145,8019,370,40861,70033,3,217,1,126.49,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1146,8019,370,40861,70033,3,57,2,10166.34,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1147,8019,371,40861,70033,3,217,1,10124.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1148,8019,371,40861,70033,3,68,1,2126.04,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1149,8019,371,40861,70033,3,57,2,12250.04,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1150,8019,372,40861,70033,3,217,1,31404.96,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1151,8019,372,40861,70033,3,68,1,6595.04,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1152,8019,372,40861,70033,3,57,2,38000.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1153,8019,373,40861,70033,3,250,1,8210.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1154,8019,373,40861,70033,3,57,2,8210.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1155,8019,374,40861,70033,3,217,1,3405.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1156,8019,374,40861,70033,3,68,1,715.05,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1157,8019,374,40861,70033,3,217,1,54.48,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1158,8019,374,40861,70033,3,57,2,4174.53,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1159,8019,375,40861,70033,3,217,1,17899.83,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1160,8019,375,40861,70033,3,68,1,3758.96,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1161,8019,375,40861,70033,3,217,1,286.40,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1162,8019,375,40861,70033,3,57,2,21945.19,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1163,8019,376,40861,70033,3,250,1,9450.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1164,8019,376,40861,70033,3,57,2,9450.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1165,8019,377,40861,70033,3,217,1,74500.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1166,8019,377,40861,70033,3,68,1,15645.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1167,8019,377,40861,70033,3,57,2,90145.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1168,8019,378,40861,70033,3,217,1,6524768.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1169,8019,378,40861,70033,3,68,1,1370201.28,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL);
INSERT INTO `balance_libro_details` VALUES (1170,8019,378,40861,70033,3,217,1,300139.33,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1171,8019,378,40861,70033,3,57,2,8195108.61,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1172,8019,379,40861,70033,3,217,1,3306.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1173,8019,379,40861,70033,3,68,1,694.26,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1174,8019,379,40861,70033,3,57,2,4000.26,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1175,8019,380,40861,70033,3,217,1,316740.60,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1176,8019,380,40861,70033,3,68,1,66515.53,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1177,8019,380,40861,70033,3,217,1,5067.85,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1178,8019,380,40861,70033,3,57,2,388323.98,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1179,8019,381,40861,70033,3,217,1,8067.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1180,8019,381,40861,70033,3,68,1,1715.53,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1181,8019,381,40861,70033,3,217,1,260.83,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1182,8019,381,40861,70033,3,57,2,10043.36,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1183,8019,382,40861,70033,3,217,1,6118684.17,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1184,8019,382,40861,70033,3,68,1,1284924.04,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1185,8019,382,40861,70033,3,217,1,2725.21,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1186,8019,382,40861,70033,3,57,2,7685067.90,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1187,8019,382,40861,70033,3,136,1,278734.48,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1188,8019,383,40861,70033,3,217,1,21827.04,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1189,8019,383,40861,70033,3,68,1,4583.68,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1190,8019,383,40861,70033,3,217,1,349.23,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1191,8019,383,40861,70033,3,57,2,26759.95,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1192,8019,384,40861,70033,3,217,1,265621.44,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1193,8019,384,40861,70033,3,68,1,55780.50,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1194,8019,384,40861,70033,3,57,2,321401.94,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1195,8019,385,40861,70033,3,217,1,177000.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1196,8019,385,40861,70033,3,68,1,37170.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1197,8019,385,40861,70033,3,57,2,214170.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1198,8019,386,40861,70033,3,217,1,5859.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1199,8019,386,40861,70033,3,68,1,1230.39,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1200,8019,386,40861,70033,3,217,1,93.74,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1201,8019,386,40861,70033,3,57,2,7183.13,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1202,8019,387,40861,70033,3,250,1,84923.22,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1203,8019,387,40861,70033,3,57,2,84923.22,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1204,8019,388,40861,70033,3,217,1,6787.96,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1205,8019,388,40861,70033,3,68,1,1425.47,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1206,8019,388,40861,70033,3,217,1,0.01,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1207,8019,388,40861,70033,3,57,2,8213.44,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1208,8019,389,40861,70033,3,217,1,169.53,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1209,8019,389,40861,70033,3,68,1,35.60,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL);
INSERT INTO `balance_libro_details` VALUES (1210,8019,389,40861,70033,3,217,1,0.01,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1211,8019,389,40861,70033,3,57,2,205.14,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1212,8019,390,40861,70033,3,217,1,140392.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1213,8019,390,40861,70033,3,68,1,29482.32,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1214,8019,390,40861,70033,3,57,2,169874.32,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1215,8019,391,40861,70033,3,217,2,102124.38,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1216,8019,391,40861,70033,3,67,2,21446.12,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1217,8019,391,40861,70033,3,57,1,123570.50,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1218,8019,392,40861,70033,3,217,1,41800.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1219,8019,392,40861,70033,3,68,1,8778.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1220,8019,392,40861,70033,3,57,2,50578.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1221,8019,393,40861,70033,3,217,1,1123.96,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1222,8019,393,40861,70033,3,68,1,236.03,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1223,8019,393,40861,70033,3,57,2,1359.99,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1224,8019,394,40861,70033,3,217,1,1247750.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1225,8019,394,40861,70033,3,68,1,262027.50,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1226,8019,394,40861,70033,3,217,1,184.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1227,8019,394,40861,70033,3,57,2,1529741.50,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1228,8019,394,40861,70033,3,136,1,19780.00,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1229,8019,395,40861,70033,3,217,1,3198.34,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1230,8019,395,40861,70033,3,68,1,671.65,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1231,8019,395,40861,70033,3,57,2,3869.99,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1232,8019,396,40861,70033,3,217,1,2057.88,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1233,8019,396,40861,70033,3,68,1,432.16,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1234,8019,396,40861,70033,3,57,2,2490.04,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1235,8019,397,40861,70033,3,217,1,317750.40,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1236,8019,397,40861,70033,3,68,1,66727.58,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1237,8019,397,40861,70033,3,217,1,5084.01,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1238,8019,397,40861,70033,3,57,2,389561.99,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(1239,8019,398,40861,70033,3,217,1,2875.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1240,8019,398,40861,70033,3,68,1,603.75,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1241,8019,398,40861,70033,3,217,1,46.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1242,8019,398,40861,70033,3,57,2,3524.75,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1243,8019,399,40861,70033,3,250,1,4500.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1244,8019,399,40861,70033,3,57,2,4500.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1245,8019,400,40861,70033,3,217,1,6558264.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1246,8019,400,40861,70033,3,68,1,1377235.44,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1247,8019,400,40861,70033,3,217,1,301680.14,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1248,8019,400,40861,70033,3,57,2,8237179.58,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1249,8019,401,40861,70033,3,217,1,778650.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1250,8019,401,40861,70033,3,68,1,163516.50,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1251,8019,401,40861,70033,3,217,1,12458.41,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1252,8019,401,40861,70033,3,57,2,954624.91,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1253,8019,402,40861,70033,3,217,1,1348500.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1254,8019,402,40861,70033,3,68,1,283185.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1255,8019,402,40861,70033,3,217,1,198.40,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1256,8019,402,40861,70033,3,57,2,1653261.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1257,8019,402,40861,70033,3,136,1,21377.60,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1258,8019,403,40861,70033,3,217,1,1350.03,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1259,8019,403,40861,70033,3,68,1,283.51,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1260,8019,403,40861,70033,3,57,2,1633.54,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1261,8019,404,40861,70033,3,217,1,56997.34,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1262,8019,404,40861,70033,3,68,1,11969.44,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1263,8019,404,40861,70033,3,217,1,15406.36,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1264,8019,404,40861,70033,3,57,2,84373.14,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1265,8019,405,40861,70033,3,217,1,5085150.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1266,8019,405,40861,70033,3,68,1,1067881.50,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1267,8019,405,40861,70033,3,217,1,748.16,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1268,8019,405,40861,70033,3,57,2,6234393.90,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1269,8019,405,40861,70033,3,136,1,80614.24,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1270,8019,406,40861,70033,3,217,1,2974.33,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1271,8019,406,40861,70033,3,68,1,624.61,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1272,8019,406,40861,70033,3,217,1,47.59,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1273,8019,406,40861,70033,3,57,2,3646.53,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1274,8019,407,40861,70033,3,217,1,227508.75,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1275,8019,407,40861,70033,3,68,1,47776.84,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1276,8019,407,40861,70033,3,217,1,3640.14,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1277,8019,407,40861,70033,3,57,2,278925.73,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1278,8019,408,40861,70033,3,217,1,256.90,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1279,8019,408,40861,70033,3,68,1,53.95,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1280,8019,408,40861,70033,3,57,2,310.85,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1281,8019,409,40861,70033,3,217,1,6149577.17,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1282,8019,409,40861,70033,3,68,1,1291411.35,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1283,8019,409,40861,70033,3,217,1,2724.20,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1284,8019,409,40861,70033,3,57,2,7723869.45,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1285,8019,409,40861,70033,3,136,1,280156.73,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1286,8019,410,40861,70033,3,217,1,41816.93,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1287,8019,410,40861,70033,3,68,1,8643.26,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1288,8019,410,40861,70033,3,57,2,50460.19,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1289,8019,411,40861,70033,3,217,1,103320.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1290,8019,411,40861,70033,3,68,1,21697.20,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1291,8019,411,40861,70033,3,217,1,60.80,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1292,8019,411,40861,70033,3,57,2,125078.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1293,8019,412,40861,70033,3,250,1,3500.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1294,8019,412,40861,70033,3,57,2,3500.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1295,8019,413,40861,70033,3,217,1,706.61,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1296,8019,413,40861,70033,3,68,1,148.39,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1297,8019,413,40861,70033,3,217,1,11.31,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1298,8019,413,40861,70033,3,57,2,866.31,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1299,8019,414,40861,70033,3,217,1,6593180.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1300,8019,414,40861,70033,3,68,1,1384567.80,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1301,8019,414,40861,70033,3,217,1,2909.50,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1302,8019,414,40861,70033,3,57,2,8281034.08,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1303,8019,414,40861,70033,3,136,1,300376.78,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1304,8019,415,40861,70033,3,250,1,0.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1305,8019,415,40861,70033,3,250,1,55552.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1306,8019,415,40861,70033,3,57,2,55552.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1307,8019,416,40861,70033,3,250,1,0.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1308,8019,416,40861,70033,3,250,1,55552.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1309,8019,416,40861,70033,3,57,2,55552.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1310,8019,417,40861,70033,3,217,1,40000.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1311,8019,417,40861,70033,3,68,1,8400.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1312,8019,417,40861,70033,3,57,2,48400.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1313,8019,418,40861,70033,3,217,1,1105135.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1314,8019,418,40861,70033,3,68,1,232078.35,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1315,8019,418,40861,70033,3,57,2,1337213.35,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1316,8019,419,40861,70033,3,217,1,20834.81,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1317,8019,419,40861,70033,3,68,1,4375.31,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1318,8019,419,40861,70033,3,217,1,958.40,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1319,8019,419,40861,70033,3,57,2,26168.52,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1320,8019,420,40861,70033,3,217,1,250046.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1321,8019,420,40861,70033,3,68,1,52509.66,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1322,8019,420,40861,70033,3,217,1,369.50,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1323,8019,420,40861,70033,3,57,2,342831.16,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1324,8019,420,40861,70033,3,136,1,39906.00,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1325,8019,421,40861,70033,3,217,1,520.75,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1326,8019,421,40861,70033,3,68,1,109.36,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1327,8019,421,40861,70033,3,57,2,630.11,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1328,8019,422,40861,70033,3,217,1,331.34,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1329,8019,422,40861,70033,3,68,1,69.58,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1330,8019,422,40861,70033,3,57,2,400.92,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(1331,8019,423,40861,70033,3,217,2,103047.83,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1332,8019,423,40861,70033,3,67,2,21640.04,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1333,8019,423,40861,70033,3,57,1,124687.87,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1334,8019,424,40861,70033,3,217,1,85.54,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1335,8019,424,40861,70033,3,68,1,17.96,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1336,8019,424,40861,70033,3,57,2,103.50,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1337,8019,425,40861,70033,3,217,1,40500.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1338,8019,425,40861,70033,3,68,1,8505.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1339,8019,425,40861,70033,3,57,2,49005.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1340,8019,426,40861,70033,3,217,1,68908.50,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1341,8019,426,40861,70033,3,68,1,14470.78,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1342,8019,426,40861,70033,3,57,2,83379.28,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1343,8019,427,40861,70033,3,217,1,68908.50,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1344,8019,427,40861,70033,3,68,1,14470.78,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1345,8019,427,40861,70033,3,57,2,83379.28,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1346,8019,428,40861,70033,3,217,1,13057.85,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1347,8019,428,40861,70033,3,68,1,2742.15,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1348,8019,428,40861,70033,3,57,2,15800.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1349,8019,429,40861,70033,3,217,1,760.34,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1350,8019,429,40861,70033,3,68,1,159.67,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1351,8019,429,40861,70033,3,57,2,920.01,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1352,8019,430,40861,70033,3,217,1,1446152.40,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1353,8019,430,40861,70033,3,68,1,303692.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1354,8019,430,40861,70033,3,57,2,1749844.40,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1355,8019,431,40861,70033,3,217,1,876000.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1356,8019,431,40861,70033,3,68,1,183960.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1357,8019,431,40861,70033,3,217,1,14016.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1358,8019,431,40861,70033,3,57,2,1073976.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1359,8019,432,40861,70033,3,217,1,65200.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1360,8019,432,40861,70033,3,68,1,13692.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1361,8019,432,40861,70033,3,57,2,78892.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1362,8019,433,40861,70033,3,217,1,6606296.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1363,8019,433,40861,70033,3,68,1,1387322.16,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1364,8019,433,40861,70033,3,217,1,303889.62,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1365,8019,433,40861,70033,3,57,2,8297507.78,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1366,8019,434,40861,70033,3,217,1,180000.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1367,8019,434,40861,70033,3,68,1,37800.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1368,8019,434,40861,70033,3,57,2,217800.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1369,8019,435,40861,70033,3,217,1,1160.32,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL);
INSERT INTO `balance_libro_details` VALUES (1370,8019,435,40861,70033,3,68,1,243.67,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1371,8019,435,40861,70033,3,57,2,1403.99,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1372,8019,436,40861,70033,3,250,1,24500.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1373,8019,436,40861,70033,3,57,2,24500.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1374,8019,437,40861,70033,3,217,1,6611522.50,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1375,8019,437,40861,70033,3,68,1,1388419.73,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1376,8019,437,40861,70033,3,217,1,2909.50,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1377,8019,437,40861,70033,3,57,2,8304072.26,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1378,8019,437,40861,70033,3,136,1,301220.53,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1379,8019,438,40861,70033,3,217,1,129700.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1380,8019,438,40861,70033,3,68,1,27237.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1381,8019,438,40861,70033,3,57,2,156937.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1382,8019,439,40861,70033,3,217,1,226117.50,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1383,8019,439,40861,70033,3,68,1,47484.68,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1384,8019,439,40861,70033,3,57,2,273602.18,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1385,8019,440,40861,70033,3,217,1,283.44,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1386,8019,440,40861,70033,3,68,1,59.52,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1387,8019,440,40861,70033,3,57,2,342.96,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1388,8019,441,40861,70033,3,217,1,147825.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1389,8019,441,40861,70033,3,68,1,31043.25,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1390,8019,441,40861,70033,3,217,1,21.60,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1391,8019,441,40861,70033,3,57,2,181233.45,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1392,8019,441,40861,70033,3,136,1,2343.60,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1393,8019,442,40861,70033,3,217,1,4989.60,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1394,8019,442,40861,70033,3,68,1,1047.82,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1395,8019,442,40861,70033,3,57,2,6037.42,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1396,8019,443,40861,70033,3,217,1,11500.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1397,8019,443,40861,70033,3,68,1,2415.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1398,8019,443,40861,70033,3,57,2,13915.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1399,8019,444,40861,70033,3,217,1,225501.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1400,8019,444,40861,70033,3,68,1,47355.21,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1401,8019,444,40861,70033,3,57,2,272856.21,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1402,8019,445,40861,70033,3,250,1,0.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1403,8019,445,40861,70033,3,250,1,55800.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1404,8019,445,40861,70033,3,57,2,55800.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1405,8019,446,40861,70033,3,250,1,0.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1406,8019,446,40861,70033,3,250,1,55800.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1407,8019,446,40861,70033,3,57,2,55800.00,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(1408,8019,447,40861,70033,3,217,1,5143600.00,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1409,8019,447,40861,70033,3,68,1,1080156.00,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL);
INSERT INTO `balance_libro_details` VALUES (1410,8019,447,40861,70033,3,217,1,748.16,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1411,8019,447,40861,70033,3,57,2,6306053.60,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1412,8019,447,40861,70033,3,136,1,81549.44,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1413,8019,448,40861,70033,3,217,1,164351.70,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1414,8019,448,40861,70033,3,68,1,34513.86,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1415,8019,448,40861,70033,3,217,1,2629.63,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1416,8019,448,40861,70033,3,57,2,201495.19,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1417,8019,449,40861,70033,3,217,1,5141.82,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1418,8019,449,40861,70033,3,68,1,1079.78,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1419,8019,449,40861,70033,3,217,1,82.27,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1420,8019,449,40861,70033,3,57,2,6303.87,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1421,8019,450,40861,70033,3,217,1,8762.90,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1422,8019,450,40861,70033,3,68,1,1840.21,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1423,8019,450,40861,70033,3,217,1,403.10,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1424,8019,450,40861,70033,3,57,2,11006.21,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1425,8019,451,40861,70033,3,217,1,15700.83,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1426,8019,451,40861,70033,3,68,1,3297.17,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1427,8019,451,40861,70033,3,217,1,5896.20,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1428,8019,451,40861,70033,3,57,2,24894.20,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1429,8019,452,40861,70033,3,217,1,1891920.00,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1430,8019,452,40861,70033,3,68,1,397303.20,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1431,8019,452,40861,70033,3,57,2,2289223.20,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1432,8019,453,40861,70033,3,217,1,910.00,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1433,8019,453,40861,70033,3,68,1,191.10,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1434,8019,453,40861,70033,3,217,1,41.86,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1435,8019,453,40861,70033,3,57,2,1142.96,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1436,8019,454,40861,70033,3,217,1,65247.35,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1437,8019,454,40861,70033,3,68,1,13701.94,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1438,8019,454,40861,70033,3,217,1,17962.01,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1439,8019,454,40861,70033,3,57,2,96911.30,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(1440,8019,455,42384,83710,3,217,1,88584.21,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1441,8019,455,42384,83710,3,68,1,18602.68,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1442,8019,455,42384,83710,3,57,2,107186.89,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1443,8019,456,42384,83710,3,217,1,6722.21,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1444,8019,456,42384,83710,3,68,1,1411.67,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1445,8019,456,42384,83710,3,57,2,8133.88,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1446,8019,457,42384,83710,3,217,1,4747.57,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1447,8019,457,42384,83710,3,68,1,996.99,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1448,8019,457,42384,83710,3,57,2,5744.56,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1449,8019,458,42384,83710,3,217,1,7936.83,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL);
INSERT INTO `balance_libro_details` VALUES (1450,8019,458,42384,83710,3,68,1,1666.73,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1451,8019,458,42384,83710,3,217,1,158.75,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1452,8019,458,42384,83710,3,57,2,9762.31,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1453,8019,459,42384,83710,3,217,1,97434.64,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1454,8019,459,42384,83710,3,68,1,20461.27,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1455,8019,459,42384,83710,3,57,2,117895.91,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(1456,8019,460,42384,83711,3,217,1,44214.88,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1457,8019,460,42384,83711,3,68,1,9285.12,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1458,8019,460,42384,83711,3,57,2,53500.00,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1459,8019,461,42384,83711,3,217,1,43605.30,NULL,'2023-08-19 20:58:16','2023-08-19 20:59:15','2023-08-19 20:59:15'),(1460,8019,461,42384,83711,3,68,1,9157.11,NULL,'2023-08-19 20:58:16','2023-08-19 20:59:15','2023-08-19 20:59:15'),(1461,8019,461,42384,83711,3,217,1,872.11,NULL,'2023-08-19 20:58:16','2023-08-19 20:59:15','2023-08-19 20:59:15'),(1462,8019,461,42384,83711,3,57,2,53634.52,NULL,'2023-08-19 20:58:16','2023-08-19 20:59:15','2023-08-19 20:59:15'),(1463,8019,462,42384,83711,3,250,1,98728.00,NULL,'2023-08-19 20:58:16','2023-08-19 21:00:08','2023-08-19 21:00:08'),(1464,8019,462,42384,83711,3,57,2,98728.00,NULL,'2023-08-19 20:58:16','2023-08-19 21:00:08','2023-08-19 21:00:08'),(1465,8019,463,42384,83711,3,217,1,1579.01,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1466,8019,463,42384,83711,3,68,1,331.59,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1467,8019,463,42384,83711,3,57,2,1910.60,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1468,8019,464,42384,83711,3,217,1,871.50,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1469,8019,464,42384,83711,3,68,1,183.02,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1470,8019,464,42384,83711,3,57,2,1054.52,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1471,8019,465,42384,83711,3,217,1,218.18,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1472,8019,465,42384,83711,3,68,1,45.82,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1473,8019,465,42384,83711,3,57,2,264.00,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1474,8019,466,42384,83711,3,217,1,2626.44,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1475,8019,466,42384,83711,3,68,1,551.55,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1476,8019,466,42384,83711,3,57,2,3177.99,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1477,8019,467,42384,83711,3,217,1,13709.90,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1478,8019,467,42384,83711,3,68,1,2879.08,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1479,8019,467,42384,83711,3,57,2,16588.98,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1480,8019,468,42384,83711,3,217,1,13223.14,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1481,8019,468,42384,83711,3,68,1,2776.86,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1482,8019,468,42384,83711,3,57,2,16000.00,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(1483,8019,469,42384,83711,3,217,1,43605.30,NULL,'2023-08-19 20:59:15','2023-08-19 20:59:15',NULL),(1484,8019,469,42384,83711,3,68,1,9157.11,NULL,'2023-08-19 20:59:15','2023-08-19 20:59:15',NULL),(1485,8019,469,42384,83711,3,217,1,872.11,NULL,'2023-08-19 20:59:15','2023-08-19 20:59:15',NULL),(1486,8019,469,42384,83711,3,57,2,53634.52,NULL,'2023-08-19 20:59:15','2023-08-19 20:59:15',NULL),(1487,8019,470,42384,83711,3,250,1,98728.00,NULL,'2023-08-19 21:00:09','2023-08-19 21:00:09',NULL),(1488,8019,470,42384,83711,3,57,2,98728.00,NULL,'2023-08-19 21:00:09','2023-08-19 21:00:09',NULL),(1489,8019,471,42384,83712,3,217,1,991.73,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL);
INSERT INTO `balance_libro_details` VALUES (1490,8019,471,42384,83712,3,68,1,208.26,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1491,8019,471,42384,83712,3,57,2,1199.99,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1492,8019,472,42384,83712,3,217,1,2561.98,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1493,8019,472,42384,83712,3,68,1,538.02,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1494,8019,472,42384,83712,3,57,2,3100.00,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1495,8019,473,42384,83712,3,250,1,126739.00,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1496,8019,473,42384,83712,3,57,2,126739.00,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1497,8019,474,42384,83712,3,217,1,1859.61,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1498,8019,474,42384,83712,3,68,1,390.52,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1499,8019,474,42384,83712,3,217,1,0.01,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1500,8019,474,42384,83712,3,57,2,2250.14,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1501,8019,475,42384,83712,3,217,1,2561.98,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1502,8019,475,42384,83712,3,68,1,538.02,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1503,8019,475,42384,83712,3,57,2,3100.00,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(1504,8019,476,42384,83714,3,217,1,254964.46,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1505,8019,476,42384,83714,3,68,1,53542.54,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1506,8019,476,42384,83714,3,57,2,308507.00,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1507,8019,477,42384,83714,3,217,1,60324.00,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1508,8019,477,42384,83714,3,68,1,12668.04,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1509,8019,477,42384,83714,3,57,2,72992.04,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1510,8019,478,42384,83714,3,217,1,130240.00,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1511,8019,478,42384,83714,3,68,1,27350.40,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1512,8019,478,42384,83714,3,57,2,157590.40,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1513,8019,479,42384,83714,3,217,1,198.35,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1514,8019,479,42384,83714,3,68,1,41.65,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1515,8019,479,42384,83714,3,57,2,240.00,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1516,8019,480,42384,83714,3,217,1,307607.34,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1517,8019,480,42384,83714,3,68,1,64597.54,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1518,8019,480,42384,83714,3,57,2,372204.88,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(1519,8019,481,42384,83714,3,217,1,11030.30,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1520,8019,481,42384,83714,3,68,1,2316.37,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1521,8019,481,42384,83714,3,217,1,-0.01,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1522,8019,481,42384,83714,3,57,2,13346.66,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1523,8019,482,42384,83714,3,217,1,1487.60,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1524,8019,482,42384,83714,3,68,1,312.40,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1525,8019,482,42384,83714,3,57,2,1800.00,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1526,8019,483,42384,83714,3,217,1,38311.25,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1527,8019,483,42384,83714,3,68,1,8045.36,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1528,8019,483,42384,83714,3,57,2,46356.61,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1529,8019,484,42384,83714,3,217,1,7768.60,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1530,8019,484,42384,83714,3,68,1,1631.40,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL);
INSERT INTO `balance_libro_details` VALUES (1531,8019,484,42384,83714,3,57,2,9400.00,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1532,8019,485,42384,83714,3,217,1,991.74,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1533,8019,485,42384,83714,3,68,1,208.26,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1534,8019,485,42384,83714,3,57,2,1200.00,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1535,8019,486,42384,83714,3,217,1,8842.98,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1536,8019,486,42384,83714,3,68,1,1857.02,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1537,8019,486,42384,83714,3,57,2,10700.00,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1538,8019,487,42384,83714,3,217,1,13965.53,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1539,8019,487,42384,83714,3,68,1,2932.76,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1540,8019,487,42384,83714,3,57,2,16898.29,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1541,8019,488,42384,83714,3,217,1,6524.79,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1542,8019,488,42384,83714,3,68,1,1370.21,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1543,8019,488,42384,83714,3,57,2,7895.00,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1544,8019,489,42384,83714,3,250,1,138274.40,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1545,8019,489,42384,83714,3,57,2,138274.40,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(1546,8019,490,42384,83711,2,96,2,90000.00,NULL,'2023-08-19 21:12:03','2023-08-19 21:12:03',NULL),(1547,8019,490,42384,83711,2,67,2,18900.00,NULL,'2023-08-19 21:12:03','2023-08-19 21:12:03',NULL),(1548,8019,490,42384,83711,2,13,1,108900.00,NULL,'2023-08-19 21:12:03','2023-08-19 21:12:03',NULL),(1549,8019,491,42384,83712,2,96,2,23884.30,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1550,8019,491,42384,83712,2,67,2,5015.70,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1551,8019,491,42384,83712,2,13,1,28900.00,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1552,8019,492,42384,83712,2,96,2,3768.60,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1553,8019,492,42384,83712,2,67,2,791.41,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1554,8019,492,42384,83712,2,13,1,4560.01,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1555,8019,493,42384,83712,2,96,2,88512.40,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1556,8019,493,42384,83712,2,67,2,18587.60,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1557,8019,493,42384,83712,2,13,1,107100.00,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1558,8019,494,42384,83712,2,96,2,15702.50,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1559,8019,494,42384,83712,2,67,2,3297.52,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1560,8019,494,42384,83712,2,13,1,19000.02,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1561,8019,495,42384,83712,2,96,2,36000.00,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1562,8019,495,42384,83712,2,67,2,7560.00,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1563,8019,495,42384,83712,2,13,1,43560.00,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1564,8019,496,42384,83712,2,96,2,16968.60,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1565,8019,496,42384,83712,2,67,2,3563.41,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1566,8019,496,42384,83712,2,13,1,20532.01,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1567,8019,497,42384,83712,2,96,2,386276.60,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1568,8019,497,42384,83712,2,67,2,81118.09,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1569,8019,497,42384,83712,2,13,1,467394.69,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(1570,8019,498,42384,83713,2,96,2,118719.00,NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL);
INSERT INTO `balance_libro_details` VALUES (1571,8019,498,42384,83713,2,67,2,24930.99,NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(1572,8019,498,42384,83713,2,13,1,143649.99,NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(1573,8019,499,42384,83713,2,96,2,55785.00,NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(1574,8019,499,42384,83713,2,67,2,11714.85,NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(1575,8019,499,42384,83713,2,13,1,67499.85,NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(1576,8019,500,42384,83713,2,96,2,4834.71,NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(1577,8019,500,42384,83713,2,67,2,1015.29,NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(1578,8019,500,42384,83713,2,13,1,5850.00,NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(1579,8019,501,42384,83714,2,96,2,46363.60,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1580,8019,501,42384,83714,2,67,2,9736.36,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1581,8019,501,42384,83714,2,13,1,56099.96,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1582,8019,502,42384,83714,2,96,2,44256.30,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1583,8019,502,42384,83714,2,67,2,9293.82,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1584,8019,502,42384,83714,2,13,1,53550.12,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1585,8019,503,42384,83714,2,96,2,74380.00,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1586,8019,503,42384,83714,2,67,2,15619.80,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1587,8019,503,42384,83714,2,13,1,89999.80,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1588,8019,504,42384,83714,2,96,2,141322.00,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1589,8019,504,42384,83714,2,67,2,29677.62,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1590,8019,504,42384,83714,2,13,1,170999.62,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1591,8019,505,42384,83714,2,96,2,16363.64,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1592,8019,505,42384,83714,2,67,2,3436.36,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1593,8019,505,42384,83714,2,13,1,19800.00,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1594,8019,506,42384,83714,2,96,2,12314.05,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1595,8019,506,42384,83714,2,67,2,2585.95,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1596,8019,506,42384,83714,2,13,1,14900.00,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1597,8019,507,42384,83714,2,96,2,40496.00,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1598,8019,507,42384,83714,2,67,2,8504.16,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1599,8019,507,42384,83714,2,13,1,49000.16,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1600,8019,508,42384,83714,2,96,2,70578.48,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1601,8019,508,42384,83714,2,67,2,14821.48,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1602,8019,508,42384,83714,2,13,1,85399.96,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(1603,8019,509,42384,83713,3,217,1,1574.70,NULL,'2023-08-19 21:16:36','2023-08-19 21:16:36',NULL),(1604,8019,509,42384,83713,3,68,1,330.69,NULL,'2023-08-19 21:16:36','2023-08-19 21:16:36',NULL),(1605,8019,509,42384,83713,3,57,2,1905.39,NULL,'2023-08-19 21:16:36','2023-08-19 21:16:36',NULL),(1606,8019,510,42384,83713,3,217,1,29752.07,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1607,8019,510,42384,83713,3,68,1,6247.93,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1608,8019,510,42384,83713,3,57,2,36000.00,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1609,8019,511,42384,83713,3,217,1,10683.50,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1610,8019,511,42384,83713,3,68,1,2243.54,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1611,8019,511,42384,83713,3,57,2,12927.04,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1612,8019,512,42384,83713,3,217,2,1574.70,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1613,8019,512,42384,83713,3,67,2,330.69,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1614,8019,512,42384,83713,3,57,1,1905.39,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1615,8019,513,42384,83713,3,217,1,1785.12,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1616,8019,513,42384,83713,3,68,1,374.88,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1617,8019,513,42384,83713,3,57,2,2160.00,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1618,8019,514,42384,83713,3,217,1,81640.13,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1619,8019,514,42384,83713,3,68,1,17144.43,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1620,8019,514,42384,83713,3,217,1,816.40,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1621,8019,514,42384,83713,3,57,2,99600.96,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1622,8019,515,42384,83713,3,217,1,12214.38,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1623,8019,515,42384,83713,3,68,1,2565.02,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1624,8019,515,42384,83713,3,217,1,4854.83,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1625,8019,515,42384,83713,3,57,2,19634.23,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1626,8019,516,42384,83713,3,217,2,2195.85,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1627,8019,516,42384,83713,3,67,2,461.13,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1628,8019,516,42384,83713,3,57,1,2656.98,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1629,8019,517,42384,83713,3,217,1,2195.85,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1630,8019,517,42384,83713,3,68,1,461.13,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1631,8019,517,42384,83713,3,57,2,2656.98,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1632,8019,518,42384,83713,3,217,1,1574.70,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1633,8019,518,42384,83713,3,68,1,330.69,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1634,8019,518,42384,83713,3,57,2,1905.39,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1635,8019,519,42384,83713,3,217,2,12214.38,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1636,8019,519,42384,83713,3,67,2,2565.02,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1637,8019,519,42384,83713,3,217,2,4854.83,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1638,8019,519,42384,83713,3,57,1,19634.23,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1639,8019,520,42384,83713,3,217,1,81640.13,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1640,8019,520,42384,83713,3,68,1,17144.43,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1641,8019,520,42384,83713,3,217,1,816.40,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1642,8019,520,42384,83713,3,57,2,99600.96,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1643,8019,521,42384,83713,3,217,2,81640.13,NULL,'2023-08-19 21:16:37','2023-08-19 21:19:16','2023-08-19 21:19:16'),(1644,8019,521,42384,83713,3,67,2,17144.43,NULL,'2023-08-19 21:16:37','2023-08-19 21:19:16','2023-08-19 21:19:16'),(1645,8019,521,42384,83713,3,217,2,816.40,NULL,'2023-08-19 21:16:37','2023-08-19 21:19:16','2023-08-19 21:19:16'),(1646,8019,521,42384,83713,3,57,1,99600.96,NULL,'2023-08-19 21:16:37','2023-08-19 21:19:16','2023-08-19 21:19:16'),(1647,8019,522,42384,83713,3,217,1,4165.28,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1648,8019,522,42384,83713,3,68,1,874.71,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1649,8019,522,42384,83713,3,57,2,5039.99,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1650,8019,523,42384,83713,3,250,1,147494.18,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL);
INSERT INTO `balance_libro_details` VALUES (1651,8019,523,42384,83713,3,57,2,147494.18,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1652,8019,524,42384,83713,3,217,2,4165.28,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1653,8019,524,42384,83713,3,67,2,874.71,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1654,8019,524,42384,83713,3,57,1,5039.99,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1655,8019,525,42384,83713,3,217,1,4669.42,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1656,8019,525,42384,83713,3,68,1,980.58,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1657,8019,525,42384,83713,3,57,2,5650.00,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1658,8019,526,42384,83713,3,217,1,4586.78,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1659,8019,526,42384,83713,3,68,1,963.22,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1660,8019,526,42384,83713,3,57,2,5550.00,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(1661,8019,527,42384,83713,3,217,1,2231.40,NULL,'2023-08-19 21:16:38','2023-08-19 21:16:38',NULL),(1662,8019,527,42384,83713,3,68,1,468.60,NULL,'2023-08-19 21:16:38','2023-08-19 21:16:38',NULL),(1663,8019,527,42384,83713,3,57,2,2700.00,NULL,'2023-08-19 21:16:38','2023-08-19 21:16:38',NULL),(1664,8019,528,42384,83713,3,217,2,81640.13,NULL,'2023-08-19 21:19:16','2023-08-19 21:19:16',NULL),(1665,8019,528,42384,83713,3,67,2,17144.43,NULL,'2023-08-19 21:19:16','2023-08-19 21:19:16',NULL),(1666,8019,528,42384,83713,3,239,2,816.40,NULL,'2023-08-19 21:19:16','2023-08-19 21:19:16',NULL),(1667,8019,528,42384,83713,3,57,1,99600.96,NULL,'2023-08-19 21:19:16','2023-08-19 21:19:16',NULL),(1668,8019,529,42425,103843,2,13,1,518985.42,NULL,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(1669,8019,529,42425,103843,2,136,2,518985.42,NULL,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(1670,8019,530,42425,103843,2,13,1,11959761.48,NULL,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(1671,8019,530,42425,103843,2,136,2,11959761.48,NULL,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(1672,8019,531,42425,103843,2,13,1,1129008.65,NULL,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(1673,8019,531,42425,103843,2,136,2,1129008.65,NULL,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(1674,8019,532,42425,103843,3,217,1,73880.00,NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(1675,8019,532,42425,103843,3,68,1,15514.80,NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(1676,8019,532,42425,103843,3,57,2,89394.80,NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(1677,8019,533,42425,103843,3,217,1,1752.06,NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(1678,8019,533,42425,103843,3,68,1,367.93,NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(1679,8019,533,42425,103843,3,57,2,2119.99,NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(1680,8019,534,42425,103843,3,217,1,24193.74,NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(1681,8019,534,42425,103843,3,68,1,4555.61,NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(1682,8019,534,42425,103843,3,217,1,-0.01,NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(1683,8019,534,42425,103843,3,57,2,28749.34,NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(1684,8019,535,42425,103843,3,217,1,30214.12,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1685,8019,535,42425,103843,3,68,1,6344.97,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1686,8019,535,42425,103843,3,217,1,1208.58,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1687,8019,535,42425,103843,3,57,2,37767.67,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1688,8019,536,42425,103843,3,217,1,61983.48,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1689,8019,536,42425,103843,3,68,1,13016.53,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1690,8019,536,42425,103843,3,217,1,-0.01,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL);
INSERT INTO `balance_libro_details` VALUES (1691,8019,536,42425,103843,3,57,2,75000.00,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1692,8019,537,42425,103843,3,217,1,54702.50,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1693,8019,537,42425,103843,3,68,1,11487.52,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1694,8019,537,42425,103843,3,57,2,66190.02,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1695,8019,538,42425,103843,3,217,1,17256.61,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1696,8019,538,42425,103843,3,68,1,3623.89,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1697,8019,538,42425,103843,3,57,2,20880.50,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1698,8019,539,42425,103843,3,250,1,11990.00,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1699,8019,539,42425,103843,3,57,2,11990.00,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1700,8019,540,42425,103843,3,217,1,16178.10,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1701,8019,540,42425,103843,3,68,1,3397.40,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1702,8019,540,42425,103843,3,217,1,426.52,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1703,8019,540,42425,103843,3,57,2,20002.02,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1704,8019,541,42425,103843,3,217,1,4039.24,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1705,8019,541,42425,103843,3,68,1,787.28,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1706,8019,541,42425,103843,3,217,1,139.80,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1707,8019,541,42425,103843,3,57,2,4966.32,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1708,8019,542,42425,103843,3,217,1,9694.74,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1709,8019,542,42425,103843,3,68,1,2035.90,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1710,8019,542,42425,103843,3,217,1,270.35,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1711,8019,542,42425,103843,3,57,2,12000.99,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1712,8019,543,42425,103843,3,250,1,695000.00,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1713,8019,543,42425,103843,3,57,2,695000.00,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1714,8019,544,42425,103843,3,217,1,8212.26,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1715,8019,544,42425,103843,3,68,1,1724.57,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1716,8019,544,42425,103843,3,217,1,0.01,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1717,8019,544,42425,103843,3,57,2,9936.84,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1718,8019,545,42425,103843,3,217,1,92702.48,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1719,8019,545,42425,103843,3,68,1,19467.52,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1720,8019,545,42425,103843,3,57,2,112170.00,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1721,8019,546,42425,103843,3,250,1,50000.00,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1722,8019,546,42425,103843,3,57,2,50000.00,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1723,8019,547,42425,103843,3,217,1,1652.89,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1724,8019,547,42425,103843,3,68,1,347.11,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1725,8019,547,42425,103843,3,57,2,2000.00,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1726,8019,548,42425,103843,3,217,1,16639.95,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1727,8019,548,42425,103843,3,68,1,3494.39,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1728,8019,548,42425,103843,3,217,1,-0.01,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1729,8019,548,42425,103843,3,57,2,20134.33,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1730,8019,549,42425,103843,3,217,1,8000.00,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL);
INSERT INTO `balance_libro_details` VALUES (1731,8019,549,42425,103843,3,68,1,1680.00,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1732,8019,549,42425,103843,3,57,2,9680.00,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1733,8019,550,42425,103843,3,217,1,2619.86,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1734,8019,550,42425,103843,3,68,1,550.17,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1735,8019,550,42425,103843,3,217,1,-0.02,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1736,8019,550,42425,103843,3,57,2,3170.01,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1737,8019,551,42425,103843,3,217,1,21628.96,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1738,8019,551,42425,103843,3,68,1,2271.04,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1739,8019,551,42425,103843,3,57,2,23900.00,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1740,8019,552,42425,103843,3,217,1,105937.82,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1741,8019,552,42425,103843,3,68,1,22246.94,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1742,8019,552,42425,103843,3,217,1,0.01,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1743,8019,552,42425,103843,3,57,2,128184.77,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(1744,8019,553,42425,103843,3,217,1,10800.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1745,8019,553,42425,103843,3,68,1,2268.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1746,8019,553,42425,103843,3,57,2,13068.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1747,8019,554,42425,103843,3,250,1,28500.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1748,8019,554,42425,103843,3,57,2,28500.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1749,8019,555,42425,103843,3,217,1,47760.03,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1750,8019,555,42425,103843,3,68,1,10029.61,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1751,8019,555,42425,103843,3,217,1,3110.42,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1752,8019,555,42425,103843,3,57,2,60900.06,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1753,8019,556,42425,103843,3,217,1,11200.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1754,8019,556,42425,103843,3,68,1,2352.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1755,8019,556,42425,103843,3,217,1,784.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1756,8019,556,42425,103843,3,57,2,14336.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1757,8019,557,42425,103843,3,217,1,1033.06,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1758,8019,557,42425,103843,3,68,1,216.94,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1759,8019,557,42425,103843,3,57,2,1250.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1760,8019,558,42425,103843,3,250,1,100330.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1761,8019,558,42425,103843,3,57,2,100330.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1762,8019,559,42425,103843,3,217,1,16157.02,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1763,8019,559,42425,103843,3,68,1,3392.97,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1764,8019,559,42425,103843,3,57,2,19549.99,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1765,8019,560,42425,103843,3,217,1,24555.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1766,8019,560,42425,103843,3,68,1,5156.55,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1767,8019,560,42425,103843,3,57,2,29711.55,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1768,8019,561,42425,103843,3,217,1,41901.29,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1769,8019,561,42425,103843,3,68,1,5140.83,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1770,8019,561,42425,103843,3,57,2,47042.12,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL);
INSERT INTO `balance_libro_details` VALUES (1771,8019,562,42425,103843,3,217,1,2924.00,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1772,8019,562,42425,103843,3,68,1,616.80,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1773,8019,562,42425,103843,3,217,1,90.14,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1774,8019,562,42425,103843,3,57,2,3630.94,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1775,8019,563,42425,103843,3,217,1,41289.29,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1776,8019,563,42425,103843,3,68,1,8670.75,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1777,8019,563,42425,103843,3,217,1,-0.03,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(1778,8019,563,42425,103843,3,57,2,49960.01,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-10-29 18:49:53',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-10-29 18:49:53',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-10-29 18:49:53',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-10-29 18:49:53','2022-10-29 18:49:53',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-10-29 18:50:06','2022-10-29 18:50:06',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-10-29 18:50:07','2022-10-29 18:50:07',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-10-29 18:50:07','2022-10-29 18:50:07',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-10-29 18:50:07','2022-10-29 18:50:07',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:05:15','2023-05-30 15:05:15',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:05:15','2023-05-30 15:05:15',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:05:15','2023-05-30 15:05:15',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:05:15','2023-05-30 15:05:15',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:05:15','2023-05-30 15:05:15',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:05:15','2023-05-30 15:05:15',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar`
--

DROP TABLE IF EXISTS `calendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `ws_telefono_id` bigint(20) unsigned DEFAULT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `descripcion_text` longtext COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `start` datetime DEFAULT NULL,
  `startEditable` tinyint(1) NOT NULL DEFAULT '1',
  `startStr` text COLLATE utf8mb4_unicode_ci,
  `end` datetime DEFAULT NULL,
  `endStr` text COLLATE utf8mb4_unicode_ci,
  `allDay` tinyint(1) NOT NULL DEFAULT '1',
  `allow` tinyint(1) DEFAULT NULL,
  `backgroundColor` text COLLATE utf8mb4_unicode_ci,
  `borderColor` text COLLATE utf8mb4_unicode_ci,
  `classNames` longtext COLLATE utf8mb4_unicode_ci,
  `constraint` text COLLATE utf8mb4_unicode_ci,
  `display` text COLLATE utf8mb4_unicode_ci,
  `durationEditable` tinyint(1) NOT NULL DEFAULT '1',
  `extendedProps` longtext COLLATE utf8mb4_unicode_ci,
  `groupId` text COLLATE utf8mb4_unicode_ci,
  `overlap` text COLLATE utf8mb4_unicode_ci,
  `source` longtext COLLATE utf8mb4_unicode_ci,
  `textColor` text COLLATE utf8mb4_unicode_ci,
  `is_impuesto_from_taxes` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_person_id_foreign` (`person_id`),
  KEY `calendar_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `calendar_ws_telefono_id_foreign` (`ws_telefono_id`),
  CONSTRAINT `calendar_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `calendar_ws_telefono_id_foreign` FOREIGN KEY (`ws_telefono_id`) REFERENCES `ws_telefonos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar`
--

LOCK TABLES `calendar` WRITE;
/*!40000 ALTER TABLE `calendar` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_emails_telefonos`
--

DROP TABLE IF EXISTS `calendar_emails_telefonos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_emails_telefonos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci,
  `celular` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_emails_telefonos_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_emails_telefonos_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_emails_telefonos`
--

LOCK TABLES `calendar_emails_telefonos` WRITE;
/*!40000 ALTER TABLE `calendar_emails_telefonos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_emails_telefonos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_files`
--

DROP TABLE IF EXISTS `calendar_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_files_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_files_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_files`
--

LOCK TABLES `calendar_files` WRITE;
/*!40000 ALTER TABLE `calendar_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1`
--

DROP TABLE IF EXISTS `calendar_niv_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_1_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1`
--

LOCK TABLES `calendar_niv_1` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_1_2`
--

DROP TABLE IF EXISTS `calendar_niv_1_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_1_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_1_2_person_id_foreign` (`person_id`),
  KEY `calendar_niv_1_2_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_niv_1_2_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_niv_1_2_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_niv_1_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_1_2`
--

LOCK TABLES `calendar_niv_1_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_1_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_1_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_niv_2`
--

DROP TABLE IF EXISTS `calendar_niv_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_niv_2` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_niv_2_person_id_foreign` (`person_id`),
  CONSTRAINT `calendar_niv_2_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_niv_2`
--

LOCK TABLES `calendar_niv_2` WRITE;
/*!40000 ALTER TABLE `calendar_niv_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_niv_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_notificaciones`
--

DROP TABLE IF EXISTS `calendar_notificaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_notificaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `calendar_id` bigint(20) unsigned NOT NULL,
  `start` datetime DEFAULT NULL,
  `tipo_de_notificacion_id` int(10) unsigned NOT NULL,
  `cantidad` int(10) unsigned NOT NULL,
  `unidad_de_tiempo_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_notificaciones_calendar_id_foreign` (`calendar_id`),
  CONSTRAINT `calendar_notificaciones_calendar_id_foreign` FOREIGN KEY (`calendar_id`) REFERENCES `calendar` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_notificaciones`
--

LOCK TABLES `calendar_notificaciones` WRITE;
/*!40000 ALTER TABLE `calendar_notificaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_notificaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo`
--

DROP TABLE IF EXISTS `calendar_tur_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_niv_1_id` bigint(20) unsigned NOT NULL,
  `calendar_niv_2_id` bigint(20) unsigned NOT NULL,
  `dia_hora` datetime(5) DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '00:30',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_calendar_niv_1_id_foreign` (`calendar_niv_1_id`),
  KEY `calendar_tur_dispo_calendar_niv_2_id_foreign` (`calendar_niv_2_id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_1_id_foreign` FOREIGN KEY (`calendar_niv_1_id`) REFERENCES `calendar_niv_1` (`id`),
  CONSTRAINT `calendar_tur_dispo_calendar_niv_2_id_foreign` FOREIGN KEY (`calendar_niv_2_id`) REFERENCES `calendar_niv_2` (`id`),
  CONSTRAINT `calendar_tur_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo`
--

LOCK TABLES `calendar_tur_dispo` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calendar_tur_dispo_datos`
--

DROP TABLE IF EXISTS `calendar_tur_dispo_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calendar_tur_dispo_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `calendar_tur_dispo_id` bigint(20) unsigned NOT NULL,
  `email` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombre_ape` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_tur_dispo_datos_person_id_foreign` (`person_id`),
  KEY `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` (`calendar_tur_dispo_id`),
  CONSTRAINT `calendar_tur_dispo_datos_calendar_tur_dispo_id_foreign` FOREIGN KEY (`calendar_tur_dispo_id`) REFERENCES `calendar_tur_dispo` (`id`),
  CONSTRAINT `calendar_tur_dispo_datos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calendar_tur_dispo_datos`
--

LOCK TABLES `calendar_tur_dispo_datos` WRITE;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `calendar_tur_dispo_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-10-29 18:50:08',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-10-29 18:50:08',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-10-29 18:50:08',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-10-29 18:50:08',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-10-29 18:50:08',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-10-29 18:50:08',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-10-29 18:50:08',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-10-29 18:50:08',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',6450000.00,537500.00,'No Excluida','0',30,3330,1500000.00,3000.00,3000.00,9800.00,13800.00,26600.00,26600.00,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',9450000.00,787500.00,'No Excluida','0',45,5000,1500000.00,5700.00,5700.00,10780.00,13800.00,30280.00,30280.00,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',13250000.00,1104166.67,'No Excluida','0',60,6700,2050000.00,9800.00,9000.00,11858.00,13800.00,35458.00,34658.00,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',16450000.00,1370833.33,'No Excluida','0',85,10000,2050000.00,16000.00,14900.00,13043.80,16400.00,45443.80,44343.80,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',19350000.00,1612500.00,'No Excluida','0',110,13000,2600000.00,30000.00,23800.00,14348.18,20000.00,64348.18,58148.18,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',24250000.00,2020833.33,'No Excluida','0',150,16500,2600000.00,42200.00,31000.00,15783.00,23000.00,80983.00,69783.00,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',29000000.00,2416666.67,'No Excluida','0',200,20000,3100000.00,76800.00,38400.00,22096.20,24800.00,123696.20,85296.20,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',44000000.00,3666666.67,'No Excluida','0',200,20000,4500000.00,220000.00,110000.00,30934.68,29800.00,280734.68,170734.68,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',49250000.00,4104166.67,'Venta de Bs Muebles','0',200,20000,4500000.00,437500.00,175000.00,43308.55,36800.00,517608.55,255108.55,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',56400000.00,4700000.00,'Venta de Bs Muebles','0',200,20000,4500000.00,525000.00,210000.00,60631.97,41300.00,626931.97,311931.97,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',68000000.00,5666666.67,'Venta de Bs Muebles','0',200,20000,4500000.00,735000.00,245000.00,84884.76,47200.00,867084.76,377084.76,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,NULL,'Clave Fiscal',NULL,NULL,NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
INSERT INTO `claves_details` VALUES (1,8019,'afip','Marcos2025',NULL,1,40719,1,'2022-10-31 01:18:18','2022-10-31 01:18:18',NULL),(3,8019,'afip','maSoraire2023',NULL,1,40720,1,'2022-12-10 23:19:34','2022-12-10 23:19:34',NULL),(5,8019,'afip','SOraireP1515','afip',1,42384,1,'2024-02-10 18:36:57','2024-02-10 18:36:57',NULL);
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL),(2,NULL,'Articulo 6',6,0,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL),(3,NULL,'Articulo 7',7,0,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL),(4,NULL,'Articulo 8',8,0,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL),(5,NULL,'Articulo 9',9,0,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL),(6,NULL,'Articulo 10',10,0,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL),(7,NULL,'Articulo 11',11,0,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL),(8,NULL,'Articulo 12',12,0,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL),(9,NULL,'Articulo 13',13,0,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL),(10,NULL,'Articulo 14',14,1,'2022-10-29 18:49:59','2022-10-29 18:49:59',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_datos`
--

DROP TABLE IF EXISTS `cobradores_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_datos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `url_panel` longtext COLLATE utf8mb4_unicode_ci,
  `usuario` text COLLATE utf8mb4_unicode_ci,
  `clave` text COLLATE utf8mb4_unicode_ci,
  `numero_de_soporte` text COLLATE utf8mb4_unicode_ci,
  `inicial_create_user` text COLLATE utf8mb4_unicode_ci,
  `imp_min_p_retirar` int(11) DEFAULT NULL,
  `secret_recarga` text COLLATE utf8mb4_unicode_ci,
  `secret_on_off` text COLLATE utf8mb4_unicode_ci,
  `clave_new_user` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_datos_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_datos_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_datos`
--

LOCK TABLES `cobradores_datos` WRITE;
/*!40000 ALTER TABLE `cobradores_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_metodos`
--

DROP TABLE IF EXISTS `cobradores_metodos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_metodos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cobradores_metodos_descripcion_unique` (`descripcion`),
  KEY `cobradores_metodos_person_id_foreign` (`person_id`),
  CONSTRAINT `cobradores_metodos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_metodos`
--

LOCK TABLES `cobradores_metodos` WRITE;
/*!40000 ALTER TABLE `cobradores_metodos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_metodos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores_on_off`
--

DROP TABLE IF EXISTS `cobradores_on_off`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores_on_off` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cobrador_id` bigint(20) unsigned NOT NULL,
  `on_off` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cobradores_on_off_cobrador_id_foreign` (`cobrador_id`),
  CONSTRAINT `cobradores_on_off_cobrador_id_foreign` FOREIGN KEY (`cobrador_id`) REFERENCES `cobradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores_on_off`
--

LOCK TABLES `cobradores_on_off` WRITE;
/*!40000 ALTER TABLE `cobradores_on_off` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores_on_off` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:44:43','2023-03-12 23:44:43',NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1433 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337 Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL),(258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL),(347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,NULL),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL),(438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono Sufrida','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(1001,NULL,5140170,5,1,5140100,'SIRTAC Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1002,NULL,5140171,5,1,5140100,'SIRTAC Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1003,NULL,5140172,5,1,5140100,'SIRTAC Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1004,NULL,5140173,5,1,5140100,'SIRTAC Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1005,NULL,5140174,5,1,5140100,'SIRTAC Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1006,NULL,5140175,5,1,5140100,'SIRTAC Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1007,NULL,5140176,5,1,5140100,'SIRTAC Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1008,NULL,5140177,5,1,5140100,'SIRTAC La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1009,NULL,5140178,5,1,5140100,'SIRTAC La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1010,NULL,5140179,5,1,5140100,'SIRTAC Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1011,NULL,5140180,5,1,5140100,'SIRTAC Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1012,NULL,5140181,5,1,5140100,'SIRTAC Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1013,NULL,5140182,5,1,5140100,'SIRTAC Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1014,NULL,5140183,5,1,5140100,'SIRTAC Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1015,NULL,5140184,5,1,5140100,'SIRTAC San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1016,NULL,5140185,5,1,5140100,'SIRTAC San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1017,NULL,5140186,5,1,5140100,'SIRTAC Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1018,NULL,5140187,5,1,5140100,'SIRTAC Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1019,NULL,5140188,5,1,5140100,'SIRTAC Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1020,NULL,5140189,5,1,5140100,'SIRTAC Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1021,NULL,5140190,5,1,5140100,'SIRTAC Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1022,NULL,5140191,5,1,5140100,'SIRTAC Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1023,NULL,5140192,5,1,5140100,'SIRTAC Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1024,NULL,5140193,5,1,5140100,'SIRTAC Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1025,NULL,5140194,5,1,5140100,'SIRTAC Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1026,NULL,6110104,5,1,6110100,'BANCO SIRTAC','Movimiento',NULL,1,2,0,0,1,1,NULL),(1400,NULL,5140267,5,1,5140100,'Perc IVA -RG3337 Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1401,NULL,5140209,5,1,5140100,'Imps. Internos Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1402,NULL,5140210,5,1,5140100,'Imp. Gasoil Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1403,NULL,5140211,5,1,5140100,'Imp. Hídricos Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1404,NULL,5140212,5,1,5140100,'ITC Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1405,NULL,5140213,5,1,5140100,'Perc IIBB  Buenos Aires Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1406,NULL,5140214,5,1,5140100,'Perc IIBB  Capital Federal Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1407,NULL,5140215,5,1,5140100,'Perc IIBB  Catamarca Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1408,NULL,5140216,5,1,5140100,'Perc IIBB  Chaco Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1409,NULL,5140217,5,1,5140100,'Perc IIBB  Chubut Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1410,NULL,5140218,5,1,5140100,'Perc IIBB  Córdoba Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1411,NULL,5140219,5,1,5140100,'Perc IIBB  Corrientes Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1412,NULL,5140220,5,1,5140100,'Perc IIBB  Entre Ríos Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (1413,NULL,5140221,5,1,5140100,'Perc IIBB  Formosa Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1414,NULL,5140222,5,1,5140100,'Perc IIBB  Jujuy Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1415,NULL,5140223,5,1,5140100,'Perc IIBB  La Pampa Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1416,NULL,5140224,5,1,5140100,'Perc IIBB  La Rioja Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1417,NULL,5140225,5,1,5140100,'Perc IIBB  Mendoza Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1418,NULL,5140226,5,1,5140100,'Perc IIBB  Misiones Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1419,NULL,5140227,5,1,5140100,'Perc IIBB  Neuquén Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1420,NULL,5140228,5,1,5140100,'Perc IIBB  Pascua Lama Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1421,NULL,5140229,5,1,5140100,'Perc IIBB  Río Negro Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1422,NULL,5140230,5,1,5140100,'Perc IIBB  Salta Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1423,NULL,5140231,5,1,5140100,'Perc IIBB  San Juan Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1424,NULL,5140232,5,1,5140100,'Perc IIBB  San Luis Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1425,NULL,5140233,5,1,5140100,'Perc IIBB  Santa Cruz Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1426,NULL,5140234,5,1,5140100,'Perc IIBB  Santa Fe Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1427,NULL,5140235,5,1,5140100,'Perc IIBB  Santiago del Estero Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1428,NULL,5140236,5,1,5140100,'Perc IIBB  Tierra del Fuego Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1429,NULL,5140237,5,1,5140100,'Perc IIBB  Tucuman Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1430,NULL,5140269,5,1,5140100,'CO2 - Imp. Al Carbono Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1431,NULL,5120256,5,1,5120100,'Imp. Municipales Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1432,NULL,5120257,5,1,5120100,'Perc/Ret. Imp. Ganancias Efectuada','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL),(24,'SIRTAC','2023-10-16 21:15:52','2023-10-16 21:15:52',NULL,20);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `numero` bigint(20) DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=564 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,8019,1,3,40720,40737,57,19725,2,0,'2021-01-01','2021-01-01',2003.17,1,1.00,'Factura A N°: 1007-03101842',NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(2,8019,2,3,40720,40738,57,19725,2,0,'2021-01-07','2021-01-07',5500.00,1,1.00,'Factura C N°: 0002-00000151',NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(3,8019,3,3,40720,40739,57,19725,2,0,'2021-01-08','2021-01-08',2878.51,1,1.00,'Factura A N°: 1043-01251913',NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(4,8019,4,3,40720,40740,57,19725,2,0,'2021-01-11','2021-01-11',10697.70,1,1.00,'Factura A N°: 0007-00012280',NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(5,8019,5,3,40720,40741,57,19725,2,0,'2021-01-12','2021-01-12',7559.34,1,1.00,'Factura A N°: 0014-00003699',NULL,'2022-12-13 10:08:36','2022-12-13 10:09:54','2022-12-13 10:09:54'),(6,8019,6,3,40720,40742,57,19725,2,0,'2021-01-14','2021-01-14',9500.00,1,1.00,'Factura C N°: 0002-00000017',NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(7,8019,7,3,40720,40743,57,19725,2,0,'2021-01-15','2021-01-15',4349.97,1,1.00,'Factura A N°: 0002-00005581',NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(8,8019,8,3,40720,40744,57,19725,2,0,'2021-01-18','2021-01-18',1160.00,1,1.00,'Factura A N°: 0003-00000612',NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(9,8019,9,3,40720,40745,57,19725,2,0,'2021-01-19','2021-01-19',600.00,1,1.00,'Factura C N°: 0004-00001121',NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(10,8019,10,3,40720,40746,57,19725,2,0,'2021-01-26','2021-01-26',5929.00,1,1.00,'Factura A N°: 0002-00007242',NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(11,8019,11,3,40720,40747,57,19725,2,0,'2021-01-27','2021-01-27',1698.00,1,1.00,'Factura B N°: 0004-00149948',NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(12,8019,12,3,40720,40748,57,19725,2,0,'2021-01-28','2021-01-28',48308.66,1,1.00,'Factura A N°: 0019-00015910',NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(13,8019,13,3,40720,40749,57,19725,2,0,'2021-01-28','2021-01-28',29450.19,1,1.00,'Factura A N°: 0003-00000344',NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(14,8019,14,3,40720,40741,57,19725,2,0,'2021-01-12','2021-01-12',7559.34,1,1.00,'Factura A N°: 0014-00003699',NULL,'2022-12-13 10:09:55','2022-12-13 10:09:55',NULL),(15,8019,15,3,40720,40750,57,19726,2,0,'2021-02-01','2021-02-01',0.00,1,1.00,'Factura C N°: 0001-00000042',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(16,8019,16,3,40720,40737,57,19726,2,0,'2021-02-01','2021-02-01',2003.17,1,1.00,'Factura A N°: 1007-03119795',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(17,8019,17,3,40720,40751,57,19726,2,0,'2021-02-04','2021-02-04',1178.38,1,1.00,'Factura A N°: 0018-00073321',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(18,8019,18,3,40720,40752,57,19726,2,0,'2021-02-08','2021-02-08',3460.24,1,1.00,'Factura B N°: 0004-00026134',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(19,8019,19,3,40720,40753,57,19726,2,0,'2021-02-08','2021-02-08',2450.00,1,1.00,'Factura A N°: 0003-00002728',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(20,8019,20,3,40720,40739,57,19726,2,0,'2021-02-08','2021-02-08',3340.30,1,1.00,'Factura A N°: 1043-01344437',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(21,8019,21,3,40720,40754,57,19726,2,0,'2021-02-08','2021-02-08',2961.22,1,1.00,'Factura A N°: 0006-00001838',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(22,8019,22,3,40720,40755,57,19726,2,0,'2021-02-09','2021-02-09',2297.06,1,1.00,'Factura A N°: 0004-00005012',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(23,8019,23,3,40720,40756,57,19726,2,0,'2021-02-10','2021-02-10',14654.40,1,1.00,'Factura A N°: 0004-00028854',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(24,8019,24,3,40720,40757,57,19726,2,0,'2021-02-11','2021-02-11',3200.00,1,1.00,'Factura A N°: 0002-00002867',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL);
INSERT INTO `cta_cte_cliente` VALUES (25,8019,25,3,40720,40738,57,19726,2,0,'2021-02-12','2021-02-12',5500.00,1,1.00,'Factura C N°: 0002-00000156',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(26,8019,26,3,40720,40742,57,19726,2,0,'2021-02-12','2021-02-12',9000.00,1,1.00,'Factura C N°: 0002-00000019',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(27,8019,27,3,40720,40758,57,19726,2,0,'2021-02-17','2021-02-17',2837.39,1,1.00,'Factura A N°: 0002-00028196',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(28,8019,28,3,40720,40759,57,19726,2,0,'2021-02-18','2021-02-18',1600.00,1,1.00,'Factura C N°: 0002-00000667',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(29,8019,29,3,40720,40760,57,19726,2,0,'2021-02-22','2021-02-22',845.00,1,1.00,'Factura C N°: 0001-00000391',NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(30,8019,30,3,40720,40761,57,19727,2,0,'2021-03-01','2021-03-01',2600.00,1,1.00,'Factura A N°: 0003-00001120',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(31,8019,31,3,40720,40737,57,19727,2,0,'2021-03-01','2021-03-01',2003.17,1,1.00,'Factura A N°: 1007-03137704',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(32,8019,32,3,40720,40762,57,19727,2,0,'2021-03-01','2021-03-01',258731.12,1,1.00,'Factura A N°: 0046-00032453',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(33,8019,33,3,40720,40738,57,19727,2,0,'2021-03-05','2021-03-05',5500.00,1,1.00,'Factura C N°: 0002-00000158',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(34,8019,34,3,40720,40739,57,19727,2,0,'2021-03-08','2021-03-08',3020.28,1,1.00,'Factura A N°: 1043-01429537',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(35,8019,35,3,40720,40763,57,19727,2,0,'2021-03-09','2021-03-09',1100.48,1,1.00,'Factura A N°: 0044-00031503',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(36,8019,36,3,40720,40759,57,19727,2,0,'2021-03-10','2021-03-10',2000.00,1,1.00,'Factura C N°: 0002-00000680',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(37,8019,37,3,40720,40764,57,19727,2,0,'2021-03-10','2021-03-10',350.00,1,1.00,'Factura A N°: 0002-00003716',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(38,8019,38,3,40720,40765,57,19727,2,0,'2021-03-14','2021-03-14',2639.96,1,1.00,'Factura B N°: 0003-00001901',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(39,8019,39,3,40720,40766,57,19727,2,0,'2021-03-15','2021-03-15',6655.00,1,1.00,'Factura A N°: 0002-00000302',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(40,8019,40,3,40720,40767,57,19727,2,0,'2021-03-19','2021-03-19',1339.99,1,1.00,'Factura A N°: 0003-00001556',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(41,8019,41,3,40720,40749,57,19727,2,0,'2021-03-20','2021-03-20',31655.34,1,1.00,'Factura A N°: 0003-00000350',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(42,8019,42,3,40720,40748,57,19727,2,0,'2021-03-21','2021-03-21',65706.75,1,1.00,'Factura A N°: 0019-00016037',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(43,8019,43,3,40720,40743,57,19727,2,0,'2021-03-23','2021-03-23',2499.98,1,1.00,'Factura A N°: 0002-00005693',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(44,8019,44,3,40720,40768,57,19727,2,0,'2021-03-29','2021-03-29',1632.74,1,1.00,'Factura C N°: 0002-00000175',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(45,8019,45,3,40720,40767,57,19727,2,0,'2021-03-30','2021-03-30',2133.99,1,1.00,'Factura A N°: 0003-00001577',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(46,8019,46,3,40720,40769,57,19727,2,0,'2021-03-30','2021-03-30',28975.00,1,1.00,'Factura C N°: 0001-00000133',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(47,8019,47,3,40720,40770,57,19727,2,0,'2021-03-31','2021-03-31',4499.00,1,1.00,'Factura B N°: 0008-00026261',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(48,8019,48,3,40720,40767,57,19727,2,0,'2021-03-31','2021-03-31',540.00,1,1.00,'Factura A N°: 0003-00001580',NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL);
INSERT INTO `cta_cte_cliente` VALUES (49,8019,49,3,40720,40737,57,19728,2,0,'2021-04-01','2021-04-01',2003.17,1,1.00,'Factura A N°: 1007-03155571',NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(50,8019,50,3,40720,40771,57,19728,2,0,'2021-04-01','2021-04-01',580.00,1,1.00,'Factura A N°: 0004-00000279',NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(51,8019,51,3,40720,40758,57,19728,2,0,'2021-04-05','2021-04-05',1649.67,1,1.00,'Factura A N°: 0002-00028816',NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(52,8019,52,3,40720,40753,57,19728,2,0,'2021-04-06','2021-04-06',1820.00,1,1.00,'Factura A N°: 0003-00002791',NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(53,8019,53,3,40720,40762,57,19728,2,0,'2021-04-08','2021-04-08',4305.79,1,1.00,'Factura A N°: 0046-00034655',NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(54,8019,54,3,40720,40739,57,19728,2,0,'2021-04-08','2021-04-08',3220.69,1,1.00,'Factura A N°: 1043-01521200',NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(55,8019,55,3,40720,40759,57,19728,2,0,'2021-04-09','2021-04-09',2000.00,1,1.00,'Factura C N°: 0002-00000692',NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(56,8019,56,3,40720,40742,57,19728,2,0,'2021-04-09','2021-04-09',10800.00,1,1.00,'Factura C N°: 0002-00000024',NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(57,8019,57,3,40720,40738,57,19728,2,0,'2021-04-12','2021-04-12',5500.00,1,1.00,'Factura C N°: 0002-00000161',NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(58,8019,58,3,40720,40762,57,19728,2,0,'2021-04-12','2021-04-12',107283.56,1,1.00,'Factura A N°: 0046-00034870',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(59,8019,59,3,40720,40772,57,19728,2,0,'2021-04-13','2021-04-13',4549.95,1,1.00,'Factura C N°: 0003-00000106',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(60,8019,60,3,40720,40773,57,19728,2,0,'2021-04-13','2021-04-13',4983.39,1,1.00,'Factura B N°: 0011-00023616',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(61,8019,61,3,40720,40774,57,19728,2,0,'2021-04-13','2021-04-13',3946.33,1,1.00,'Factura A N°: 0009-00001869',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(62,8019,62,3,40720,40775,57,19728,2,0,'2021-04-14','2021-04-14',9790.00,1,1.00,'Factura B N°: 0003-00050351',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(63,8019,63,3,40720,40776,57,19728,2,0,'2021-04-15','2021-04-15',793.76,1,1.00,'Factura A N°: 0001-00000304',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(64,8019,64,3,40720,40776,57,19728,2,0,'2021-04-15','2021-04-15',400.00,1,1.00,'Factura A N°: 0001-00000303',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(65,8019,65,3,40720,40777,57,19728,2,0,'2021-04-19','2021-04-19',1474.00,1,1.00,'Factura A N°: 0002-00000027',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(66,8019,66,3,40720,40762,57,19728,2,0,'2021-04-19','2021-04-19',58044.16,1,1.00,'Factura A N°: 0046-00035313',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(67,8019,67,3,40720,40756,57,19728,2,0,'2021-04-19','2021-04-19',3809.96,1,1.00,'Factura A N°: 0004-00030066',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(68,8019,68,3,40720,40778,57,19728,2,0,'2021-04-20','2021-04-20',1780.89,1,1.00,'Factura A N°: 0033-00046362',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(69,8019,69,3,40720,40751,57,19728,2,0,'2021-04-20','2021-04-20',8096.21,1,1.00,'Factura A N°: 0018-00076343',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(70,8019,70,3,40720,40779,57,19728,2,0,'2021-04-20','2021-04-20',2000.00,1,1.00,'Factura A N°: 0003-00003431',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(71,8019,71,3,40720,40780,57,19728,2,0,'2021-04-26','2021-04-26',900.01,1,1.00,'Factura A N°: 0003-00008612',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(72,8019,72,3,40720,40750,57,19728,2,0,'2021-04-27','2021-04-27',892.50,1,1.00,'Factura C N°: 0001-00000073',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL);
INSERT INTO `cta_cte_cliente` VALUES (73,8019,73,3,40720,40750,57,19728,2,0,'2021-04-27','2021-04-27',892.50,1,1.00,'Factura C N°: 0001-00000072',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(74,8019,74,3,40720,40761,57,19728,2,0,'2021-04-27','2021-04-27',3240.00,1,1.00,'Factura A N°: 0003-00001232',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(75,8019,75,3,40720,40781,57,19728,2,0,'2021-04-28','2021-04-28',700.00,1,1.00,'Factura C N°: 0004-00000376',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(76,8019,76,3,40720,40758,57,19728,2,0,'2021-04-29','2021-04-29',192.81,1,1.00,'Factura A N°: 0002-00029200',NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(77,8019,77,3,40720,40737,57,19729,2,0,'2021-05-01','2021-05-01',2922.96,1,1.00,'Factura A N°: 1007-03173418',NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(78,8019,78,3,40720,40741,57,19729,2,0,'2021-05-05','2021-05-05',2402.93,1,1.00,'Factura A N°: 0014-00005589',NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(79,8019,79,3,40720,40756,57,19729,2,0,'2021-05-05','2021-05-05',6846.08,1,1.00,'Factura A N°: 0004-00030457',NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(80,8019,80,3,40720,40782,57,19729,2,0,'2021-05-06','2021-05-06',1000.00,1,1.00,'Factura A N°: 0003-00001820',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(81,8019,81,3,40720,40741,57,19729,2,0,'2021-05-07','2021-05-07',5100.48,1,1.00,'Factura A N°: 0014-00005631',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(82,8019,82,3,40720,40762,57,19729,2,0,'2021-05-07','2021-05-07',12792.20,1,1.00,'Factura A N°: 0046-00036457',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(83,8019,83,3,40720,40739,57,19729,2,0,'2021-05-08','2021-05-08',17000.69,1,1.00,'Factura A N°: 1281-00077828',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(84,8019,84,3,40720,40759,57,19729,2,0,'2021-05-11','2021-05-11',2000.00,1,1.00,'Factura C N°: 0002-00000718',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(85,8019,85,3,40720,40738,57,19729,2,0,'2021-05-12','2021-05-12',5500.00,1,1.00,'Factura C N°: 0002-00000165',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(86,8019,86,3,40720,40742,57,19729,2,0,'2021-05-13','2021-05-13',10800.00,1,1.00,'Factura C N°: 0002-00000029',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(87,8019,87,3,40720,40783,57,19729,2,0,'2021-05-17','2021-05-17',48189.00,1,1.00,'Factura B N°: 0021-00547329',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(88,8019,88,3,40720,40784,57,19729,2,0,'2021-05-17','2021-05-17',1270.00,1,1.00,'Factura A N°: 0004-00007985',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(89,8019,89,3,40720,40774,57,19729,2,0,'2021-05-17','2021-05-17',830.00,1,1.00,'Factura A N°: 0007-00000691',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(90,8019,90,3,40720,40785,57,19729,2,0,'2021-05-17','2021-05-17',1200.01,1,1.00,'Factura A N°: 0002-00001077',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(91,8019,91,3,40720,40748,57,19729,2,0,'2021-05-26','2021-05-26',70780.28,1,1.00,'Factura A N°: 0029-00000001',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(92,8019,92,3,40720,40786,57,19729,2,0,'2021-05-27','2021-05-27',14999.00,1,1.00,'Factura B N°: 0005-00046229',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(93,8019,93,3,40720,40776,57,19729,2,0,'2021-05-27','2021-05-27',1000.00,1,1.00,'Factura A N°: 0001-00000343',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(94,8019,94,3,40720,40787,57,19729,2,0,'2021-05-28','2021-05-28',35438.41,1,1.00,'Factura A N°: 0006-00003975',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(95,8019,95,3,40720,40774,57,19729,2,0,'2021-05-28','2021-05-28',1317.99,1,1.00,'Factura A N°: 0009-00002161',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(96,8019,96,3,40720,40774,57,19729,2,0,'2021-05-28','2021-05-28',829.99,1,1.00,'Factura A N°: 0009-00002160',NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL);
INSERT INTO `cta_cte_cliente` VALUES (97,8019,97,3,40720,40737,57,19730,2,0,'2021-06-01','2021-06-01',2922.96,1,1.00,'Factura A N°: 1007-03191233',NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(98,8019,98,3,40720,40788,57,19730,2,0,'2021-06-01','2021-06-01',500.00,1,1.00,'Factura A N°: 0004-00000622',NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(99,8019,99,3,40720,40789,57,19730,2,0,'2021-06-03','2021-06-03',76000.00,1,1.00,'Factura A N°: 0004-00003597',NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(100,8019,100,3,40720,40787,57,19730,2,0,'2021-06-04','2021-06-04',22868.14,1,1.00,'Factura A N°: 0006-00004012',NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(101,8019,101,3,40720,40742,57,19730,2,0,'2021-06-06','2021-06-06',10800.00,1,1.00,'Factura C N°: 0002-00000033',NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(102,8019,102,3,40720,40741,57,19730,2,0,'2021-06-08','2021-06-08',1191.60,1,1.00,'Factura A N°: 0014-00006143',NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(103,8019,103,3,40720,40739,57,19730,2,0,'2021-06-08','2021-06-08',4073.73,1,1.00,'Factura A N°: 1281-00167079',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(104,8019,104,3,40720,40790,57,19730,2,0,'2021-06-08','2021-06-08',5300.00,1,1.00,'Factura A N°: 0005-00017430',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(105,8019,105,3,40720,40791,57,19730,2,0,'2021-06-09','2021-06-09',960.00,1,1.00,'Factura C N°: 0003-00000461',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(106,8019,106,3,40720,40738,57,19730,2,0,'2021-06-09','2021-06-09',5500.00,1,1.00,'Factura C N°: 0002-00000167',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(107,8019,107,3,40720,40741,57,19730,2,0,'2021-06-09','2021-06-09',4751.30,1,1.00,'Factura A N°: 0014-00006171',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(108,8019,108,3,40720,40774,57,19730,2,0,'2021-06-09','2021-06-09',2500.04,1,1.00,'Factura A N°: 0009-00002240',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(109,8019,109,3,40720,40767,57,19730,2,0,'2021-06-11','2021-06-11',2079.99,1,1.00,'Factura A N°: 0003-00001702',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(110,8019,110,3,40720,40749,57,19730,2,0,'2021-06-11','2021-06-11',36183.84,1,1.00,'Factura A N°: 0003-00000357',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(111,8019,111,3,40720,40792,57,19730,2,0,'2021-06-14','2021-06-14',610.00,1,1.00,'Factura B N°: 0004-00001706',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(112,8019,112,3,40720,40778,57,19730,2,0,'2021-06-14','2021-06-14',1640.47,1,1.00,'Factura A N°: 0033-00049141',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(113,8019,113,3,40720,40793,57,19730,2,0,'2021-06-15','2021-06-15',2649.70,1,1.00,'Factura A N°: 0093-00001763',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(114,8019,114,3,40720,40790,57,19730,2,0,'2021-06-15','2021-06-15',1930.00,1,1.00,'Factura A N°: 0005-00017453',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(115,8019,115,3,40720,40753,57,19730,2,0,'2021-06-16','2021-06-16',3300.00,1,1.00,'Factura A N°: 0003-00002875',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(116,8019,116,3,40720,40788,57,19730,2,0,'2021-06-16','2021-06-16',14166.99,1,1.00,'Factura A N°: 0004-00000657',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(117,8019,117,3,40720,40794,57,19730,2,0,'2021-06-17','2021-06-17',2500.00,1,1.00,'Factura A N°: 0002-00019121',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(118,8019,118,3,40720,40759,57,19730,2,0,'2021-06-21','2021-06-21',2000.00,1,1.00,'Factura C N°: 0002-00000737',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(119,8019,119,3,40720,40741,57,19730,2,0,'2021-06-22','2021-06-22',8462.83,1,1.00,'Factura A N°: 0014-00006349',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(120,8019,120,3,40720,40748,57,19730,2,0,'2021-06-24','2021-06-24',72030.82,1,1.00,'Factura A N°: 0029-00000021',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL);
INSERT INTO `cta_cte_cliente` VALUES (121,8019,121,3,40720,40749,57,19730,2,0,'2021-06-24','2021-06-24',37217.66,1,1.00,'Factura A N°: 0003-00000362',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(122,8019,122,3,40720,40795,57,19730,2,0,'2021-06-25','2021-06-25',1199.99,1,1.00,'Factura A N°: 0003-00001326',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(123,8019,123,3,40720,40776,57,19730,2,0,'2021-06-28','2021-06-28',540.00,1,1.00,'Factura A N°: 0001-00000374',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(124,8019,124,3,40720,40776,57,19730,2,0,'2021-06-29','2021-06-29',800.00,1,1.00,'Factura A N°: 0001-00000376',NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(125,8019,125,3,40720,40796,57,19731,2,0,'2021-07-01','2021-07-01',5120.00,1,1.00,'Factura B N°: 0006-00020129',NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(126,8019,126,3,40720,40737,57,19731,2,0,'2021-07-01','2021-07-01',2922.96,1,1.00,'Factura A N°: 1007-03209041',NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(127,8019,127,3,40720,40767,57,19731,2,0,'2021-07-06','2021-07-06',540.00,1,1.00,'Factura A N°: 0003-00001732',NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(128,8019,128,3,40720,40795,57,19731,2,0,'2021-07-06','2021-07-06',3439.99,1,1.00,'Factura A N°: 0003-00001346',NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(129,8019,129,3,40720,40739,57,19731,2,0,'2021-07-08','2021-07-08',3840.12,1,1.00,'Factura A N°: 1281-00269248',NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(130,8019,130,3,40720,40738,57,19731,2,0,'2021-07-12','2021-07-12',5500.00,1,1.00,'Factura C N°: 0002-00000171',NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(131,8019,131,3,40720,40742,57,19731,2,0,'2021-07-12','2021-07-12',10800.00,1,1.00,'Factura C N°: 0002-00000038',NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(132,8019,132,3,40720,40751,57,19731,2,0,'2021-07-12','2021-07-12',2981.15,1,1.00,'Factura A N°: 0018-00080044',NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(133,8019,133,3,40720,40797,57,19731,2,0,'2021-07-14','2021-07-14',2000.01,1,1.00,'Factura A N°: 0005-00000597',NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(134,8019,134,3,40720,40741,57,19731,2,0,'2021-07-15','2021-07-15',25670.83,1,1.00,'Factura A N°: 0014-00006881',NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(135,8019,135,3,40720,40785,57,19731,2,0,'2021-07-16','2021-07-16',250.00,1,1.00,'Factura A N°: 0004-00000543',NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(136,8019,136,3,40720,40798,57,19731,2,0,'2021-07-23','2021-07-23',5700.00,1,1.00,'Factura B N°: 0003-00005632',NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(137,8019,137,3,40720,40799,57,19731,2,0,'2021-07-23','2021-07-23',3135.00,1,1.00,'Factura C N°: 0003-00000340',NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(138,8019,138,3,40720,40759,57,19731,2,0,'2021-07-26','2021-07-26',2000.00,1,1.00,'Factura C N°: 0002-00000754',NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(139,8019,139,3,40720,40741,57,19731,2,0,'2021-07-26','2021-07-26',22857.88,1,1.00,'Factura A N°: 0014-00007118',NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(140,8019,140,3,40720,40762,57,19731,2,0,'2021-07-27','2021-07-27',276990.92,1,1.00,'Factura A N°: 0046-00039304',NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(141,8019,141,3,40720,40762,57,19731,2,0,'2021-07-27','2021-07-27',9436.10,1,1.00,'Factura A N°: 0046-00039305',NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(142,8019,142,3,40720,40737,57,19732,2,0,'2021-08-01','2021-08-01',3326.26,1,1.00,'Factura A N°: 1007-03227093',NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(143,8019,143,3,40720,40738,57,19732,2,0,'2021-08-05','2021-08-05',7500.00,1,1.00,'Factura C N°: 0002-00000174',NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL);
INSERT INTO `cta_cte_cliente` VALUES (144,8019,144,3,40720,40800,57,19732,2,0,'2021-08-07','2021-08-07',16129.99,1,1.00,'Factura A N°: 0010-00000186',NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(145,8019,145,3,40720,40739,57,19732,2,0,'2021-08-08','2021-08-08',3842.26,1,1.00,'Factura A N°: 1281-00384057',NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(146,8019,146,3,40720,40801,57,19732,1,0,'2021-08-09','2021-08-09',375.70,1,1.00,'Nota de crédito B N°: 2117-06921427',NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(147,8019,147,3,40720,40742,57,19732,2,0,'2021-08-09','2021-08-09',12500.00,1,1.00,'Factura C N°: 0002-00000041',NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(148,8019,148,3,40720,40802,57,19732,2,0,'2021-08-11','2021-08-11',4690.00,1,1.00,'Factura B N°: 0003-00020730',NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(149,8019,149,3,40720,40741,57,19732,2,0,'2021-08-18','2021-08-18',36523.02,1,1.00,'Factura A N°: 0014-00007609',NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(150,8019,150,3,40720,40796,57,19732,2,0,'2021-08-25','2021-08-25',5280.00,1,1.00,'Factura B N°: 0006-00025105',NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(151,8019,151,3,40720,40767,57,19732,2,0,'2021-08-30','2021-08-30',1294.00,1,1.00,'Factura A N°: 0006-00000128',NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(152,8019,152,3,40720,40803,57,19732,2,0,'2021-08-30','2021-08-30',2700.00,1,1.00,'Factura C N°: 0002-00002768',NULL,'2022-12-13 10:15:02','2022-12-13 10:15:02',NULL),(153,8019,153,3,40720,40737,57,19733,2,0,'2021-09-01','2021-09-01',3376.68,1,1.00,'Factura A N°: 1007-03245143',NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(154,8019,154,3,40720,40804,57,19733,2,0,'2021-09-01','2021-09-01',1050.00,1,1.00,'Factura A N°: 0005-00000033',NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(155,8019,155,3,40720,40767,57,19733,2,0,'2021-09-07','2021-09-07',1380.00,1,1.00,'Factura A N°: 0006-00000149',NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(156,8019,156,3,40720,40758,57,19733,2,0,'2021-09-07','2021-09-07',1300.02,1,1.00,'Factura A N°: 0002-00031136',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(157,8019,157,3,40720,40805,57,19733,2,0,'2021-09-08','2021-09-08',15115.66,1,1.00,'Factura B N°: 0003-00034950',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(158,8019,158,3,40720,40805,57,19733,2,0,'2021-09-08','2021-09-08',15115.66,1,1.00,'Factura B N°: 0003-00034951',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(159,8019,159,3,40720,40806,57,19733,2,0,'2021-09-08','2021-09-08',21833.26,1,1.00,'Factura B N°: 0013-00057410',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(160,8019,160,3,40720,40738,57,19733,2,0,'2021-09-08','2021-09-08',7500.00,1,1.00,'Factura C N°: 0002-00000176',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(161,8019,161,3,40720,40739,57,19733,2,0,'2021-09-08','2021-09-08',3838.17,1,1.00,'Factura A N°: 1281-00502414',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(162,8019,162,3,40720,40807,57,19733,2,0,'2021-09-08','2021-09-08',52000.00,1,1.00,'Factura A N°: 0017-00005428',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(163,8019,163,3,40720,40793,57,19733,2,0,'2021-09-10','2021-09-10',2900.00,1,1.00,'Factura A N°: 0093-00005812',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(164,8019,164,3,40720,40808,57,19733,2,0,'2021-09-10','2021-09-10',693.23,1,1.00,'Factura A N°: 0004-00001306',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(165,8019,165,3,40720,40809,57,19733,2,0,'2021-09-13','2021-09-13',1360.00,1,1.00,'Factura A N°: 0008-00001476',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(166,8019,166,3,40720,40810,57,19733,2,0,'2021-09-15','2021-09-15',2920.00,1,1.00,'Factura A N°: 0005-00000542',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL);
INSERT INTO `cta_cte_cliente` VALUES (167,8019,167,3,40720,40793,57,19733,2,0,'2021-09-15','2021-09-15',3390.70,1,1.00,'Factura A N°: 0093-00006076',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(168,8019,168,3,40720,40807,57,19733,2,0,'2021-09-15','2021-09-15',6000.00,1,1.00,'Factura A N°: 0017-00005457',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(169,8019,169,3,40720,40743,57,19733,2,0,'2021-09-21','2021-09-21',1750.00,1,1.00,'Factura A N°: 0002-00005965',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(170,8019,170,3,40720,40767,57,19733,2,0,'2021-09-22','2021-09-22',1040.00,1,1.00,'Factura A N°: 0006-00000204',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(171,8019,171,3,40720,40741,57,19733,2,0,'2021-09-22','2021-09-22',10625.72,1,1.00,'Factura A N°: 0014-00008285',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(172,8019,172,3,40720,40811,57,19733,2,0,'2021-09-27','2021-09-27',13500.01,1,1.00,'Factura A N°: 0005-00000300',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(173,8019,173,3,40720,40812,57,19733,2,0,'2021-09-28','2021-09-28',4593.11,1,1.00,'Factura B N°: 2663-00003670',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(174,8019,174,3,40720,40774,57,19733,2,0,'2021-09-28','2021-09-28',1955.19,1,1.00,'Factura A N°: 0009-00003008',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(175,8019,175,3,40720,40746,57,19733,2,0,'2021-09-29','2021-09-29',8668.23,1,1.00,'Factura A N°: 0002-00008332',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(176,8019,176,3,40720,40748,57,19733,2,0,'2021-09-30','2021-09-30',78189.72,1,1.00,'Factura A N°: 0029-00000315',NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(177,8019,177,3,40720,40737,57,19734,2,0,'2021-10-01','2021-10-01',3326.26,1,1.00,'Factura A N°: 1007-03263209',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(178,8019,178,3,40720,40812,57,19734,2,0,'2021-10-04','2021-10-04',1692.31,1,1.00,'Factura B N°: 2663-00004196',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(179,8019,179,3,40720,40767,57,19734,2,0,'2021-10-04','2021-10-04',440.00,1,1.00,'Factura A N°: 0006-00000238',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(180,8019,180,3,40720,40738,57,19734,2,0,'2021-10-05','2021-10-05',7500.00,1,1.00,'Factura C N°: 0002-00000179',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(181,8019,181,3,40720,40739,57,19734,2,0,'2021-10-08','2021-10-08',19190.81,1,1.00,'Factura A N°: 1281-00621409',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(182,8019,182,3,40720,40739,57,19734,2,0,'2021-10-12','2021-10-12',36597.91,1,1.00,'Factura A N°: 1174-00001867',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(183,8019,183,3,40720,40813,57,19734,2,0,'2021-10-14','2021-10-14',109775.75,1,1.00,'Factura A N°: 9107-00000385',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(184,8019,184,3,40720,40767,57,19734,2,0,'2021-10-18','2021-10-18',2780.00,1,1.00,'Factura A N°: 0006-00000286',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(185,8019,185,3,40720,40749,57,19734,2,0,'2021-10-20','2021-10-20',45869.42,1,1.00,'Factura A N°: 0003-00000374',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(186,8019,186,3,40720,40742,57,19734,2,0,'2021-10-20','2021-10-20',11000.00,1,1.00,'Factura C N°: 0002-00000049',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(187,8019,187,3,40720,40814,57,19734,2,0,'2021-10-22','2021-10-22',3989.00,1,1.00,'Factura B N°: 0009-00006907',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(188,8019,188,3,40720,40767,57,19734,2,0,'2021-10-22','2021-10-22',1100.00,1,1.00,'Factura A N°: 0006-00000303',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(189,8019,189,3,40720,40767,57,19734,2,0,'2021-10-22','2021-10-22',800.00,1,1.00,'Factura A N°: 0006-00000304',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL);
INSERT INTO `cta_cte_cliente` VALUES (190,8019,190,3,40720,40767,57,19734,2,0,'2021-10-22','2021-10-22',3260.00,1,1.00,'Factura A N°: 0006-00000301',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(191,8019,191,3,40720,40741,57,19734,2,0,'2021-10-22','2021-10-22',22725.62,1,1.00,'Factura A N°: 0014-00008768',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(192,8019,192,3,40720,40771,57,19734,2,0,'2021-10-22','2021-10-22',3090.00,1,1.00,'Factura A N°: 0004-00000698',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(193,8019,193,3,40720,40741,57,19734,2,0,'2021-10-25','2021-10-25',9743.09,1,1.00,'Factura A N°: 0014-00008800',NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(194,8019,194,3,40720,40741,57,19734,2,0,'2021-10-26','2021-10-26',15062.17,1,1.00,'Factura A N°: 0014-00008828',NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(195,8019,195,3,40720,40741,57,19734,2,0,'2021-10-27','2021-10-27',20797.43,1,1.00,'Factura A N°: 0014-00008844',NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(196,8019,196,3,40720,40741,57,19734,2,0,'2021-10-28','2021-10-28',915.20,1,1.00,'Factura A N°: 0014-00008862',NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(197,8019,197,3,40720,40812,57,19734,2,0,'2021-10-29','2021-10-29',6200.17,1,1.00,'Factura B N°: 2663-00006050',NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(198,8019,198,3,40720,40812,57,19734,2,0,'2021-10-29','2021-10-29',886.45,1,1.00,'Factura B N°: 2663-00006057',NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(199,8019,199,3,40720,40762,57,19734,2,0,'2021-10-29','2021-10-29',15340.30,1,1.00,'Factura A N°: 0046-00042763',NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(200,8019,200,3,40720,40776,57,19735,2,0,'2021-11-01','2021-11-01',1000.00,1,1.00,'Factura A N°: 0001-00000502',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(201,8019,201,3,40720,40738,57,19735,2,0,'2021-11-01','2021-11-01',7500.00,1,1.00,'Factura C N°: 0002-00000183',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(202,8019,202,3,40720,40737,57,19735,2,0,'2021-11-01','2021-11-01',4183.28,1,1.00,'Factura A N°: 1007-03281277',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(203,8019,203,3,40720,40776,57,19735,2,0,'2021-11-04','2021-11-04',3000.00,1,1.00,'Factura A N°: 0001-00000509',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(204,8019,204,3,40720,40813,57,19735,2,0,'2021-11-04','2021-11-04',30201.44,1,1.00,'Factura A N°: 9135-00000150',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(205,8019,205,3,40720,40815,57,19735,2,0,'2021-11-05','2021-11-05',7020.00,1,1.00,'Factura B N°: 0002-00012982',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(206,8019,206,3,40720,40739,57,19735,2,0,'2021-11-08','2021-11-08',22557.00,1,1.00,'Factura A N°: 1281-00746195',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(207,8019,207,3,40720,40816,57,19735,2,0,'2021-11-10','2021-11-10',7000.00,1,1.00,'Factura C N°: 0001-00000007',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(208,8019,208,3,40720,40774,57,19735,2,0,'2021-11-10','2021-11-10',12518.01,1,1.00,'Factura A N°: 0009-00003326',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(209,8019,209,3,40720,40798,57,19735,2,0,'2021-11-15','2021-11-15',8500.00,1,1.00,'Factura B N°: 0003-00007141',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(210,8019,210,3,40720,40767,57,19735,2,0,'2021-11-15','2021-11-15',300.00,1,1.00,'Factura A N°: 0006-00000376',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(211,8019,211,3,40720,40767,57,19735,2,0,'2021-11-16','2021-11-16',1150.00,1,1.00,'Factura A N°: 0006-00000380',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(212,8019,212,3,40720,40740,57,19735,2,0,'2021-11-16','2021-11-16',13021.75,1,1.00,'Factura A N°: 0007-00014080',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL);
INSERT INTO `cta_cte_cliente` VALUES (213,8019,213,3,40720,40773,57,19735,2,0,'2021-11-18','2021-11-18',5450.00,1,1.00,'Factura B N°: 0020-00004692',NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(214,8019,214,3,40720,40817,57,19735,2,0,'2021-11-18','2021-11-18',5200.00,1,1.00,'Factura B N°: 0003-00026411',NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(215,8019,215,3,40720,40748,57,19735,2,0,'2021-11-19','2021-11-19',83563.33,1,1.00,'Factura A N°: 0029-00000316',NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(216,8019,216,3,40720,40812,57,19735,2,0,'2021-11-26','2021-11-26',3553.88,1,1.00,'Factura B N°: 2663-00008295',NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(217,8019,217,3,40720,40818,57,19735,2,0,'2021-11-27','2021-11-27',4666.64,1,1.00,'Factura B N°: 0010-00025707',NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(218,8019,218,3,40720,40812,57,19735,2,0,'2021-11-27','2021-11-27',7285.60,1,1.00,'Factura B N°: 2663-00008403',NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(219,8019,219,3,40720,40819,57,19735,2,0,'2021-11-28','2021-11-28',5971.84,1,1.00,'Factura B N°: 0030-00028119',NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(220,8019,220,3,40720,40820,57,19735,2,0,'2021-11-30','2021-11-30',37610.99,1,1.00,'Factura A N°: 0001-00000167',NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(221,8019,221,3,40720,40762,57,19735,2,0,'2021-11-30','2021-11-30',303815.10,1,1.00,'Factura A N°: 0046-00044026',NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(222,8019,222,3,40720,40738,57,19736,2,0,'2021-12-01','2021-12-01',7500.00,1,1.00,'Factura C N°: 0002-00000187',NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(223,8019,223,3,40720,40737,57,19736,2,0,'2021-12-01','2021-12-01',4183.28,1,1.00,'Factura A N°: 1007-03299331',NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(224,8019,224,3,40720,40821,57,19736,2,0,'2021-12-03','2021-12-03',13299.00,1,1.00,'Factura B N°: 2002-00350335',NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(225,8019,225,3,40720,40822,57,19736,2,0,'2021-12-06','2021-12-06',9980.00,1,1.00,'Factura A N°: 0011-00004918',NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(226,8019,226,3,40720,40774,57,19736,2,0,'2021-12-07','2021-12-07',1559.99,1,1.00,'Factura A N°: 0009-00003527',NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(227,8019,227,3,40720,40739,57,19736,2,0,'2021-12-08','2021-12-08',202.11,1,1.00,'Factura A N°: 1281-00872406',NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(228,8019,228,3,40720,40742,57,19736,2,0,'2021-12-08','2021-12-08',11000.00,1,1.00,'Factura C N°: 0002-00000055',NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(229,8019,229,3,40720,40823,57,19736,2,0,'2021-12-09','2021-12-09',299.98,1,1.00,'Factura A N°: 0010-00000462',NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(230,8019,230,3,40720,40747,57,19736,2,0,'2021-12-10','2021-12-10',29999.00,1,1.00,'Factura B N°: 0004-00597238',NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(231,8019,231,3,40720,40767,57,19736,2,0,'2021-12-10','2021-12-10',4680.00,1,1.00,'Factura A N°: 0006-00000490',NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(232,8019,232,3,40720,40741,57,19736,2,0,'2021-12-10','2021-12-10',10494.82,1,1.00,'Factura A N°: 0014-00009599',NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(233,8019,233,3,40720,40749,57,19736,2,0,'2021-12-13','2021-12-13',50917.42,1,1.00,'Factura A N°: 0003-00000383',NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(234,8019,234,3,40720,40756,57,19736,2,0,'2021-12-16','2021-12-16',23056.73,1,1.00,'Factura A N°: 0004-00035722',NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(235,8019,235,3,40720,40741,57,19736,2,0,'2021-12-20','2021-12-20',17209.66,1,1.00,'Factura A N°: 0014-00009739',NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL);
INSERT INTO `cta_cte_cliente` VALUES (236,8019,236,3,40720,40813,57,19736,2,0,'2021-12-21','2021-12-21',8344.53,1,1.00,'Factura A N°: 9135-00000295',NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(237,8019,237,3,40720,40812,57,19736,2,0,'2021-12-22','2021-12-22',4382.67,1,1.00,'Factura B N°: 2663-00010842',NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(238,8019,238,3,40720,40748,57,19736,2,0,'2021-12-22','2021-12-22',90256.32,1,1.00,'Factura A N°: 0029-00000317',NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(239,8019,239,3,40720,40756,57,19736,2,0,'2021-12-23','2021-12-23',9710.64,1,1.00,'Factura A N°: 0004-00035860',NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(240,8019,240,3,40720,40824,57,19736,2,0,'2021-12-28','2021-12-28',570.00,1,1.00,'Factura A N°: 0005-00003102',NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(241,8019,241,2,40720,40825,13,19725,1,0,'2021-01-06','2021-01-06',105415.20,1,1.00,'Factura A N°: 0004-00000225',NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(242,8019,242,2,40720,40826,13,19725,1,0,'2021-01-08','2021-01-08',72600.00,1,1.00,'Factura A N°: 0004-00000226',NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(243,8019,243,2,40720,40827,13,19725,1,0,'2021-01-14','2021-01-14',24393.60,1,1.00,'Factura A N°: 0004-00000227',NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(244,8019,244,2,40720,40828,13,19725,1,0,'2021-01-20','2021-01-20',96618.50,1,1.00,'Factura A N°: 0004-00000228',NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(245,8019,245,2,40720,40829,13,19725,1,0,'2021-01-29','2021-01-29',1850.00,1,1.00,'Factura B N°: 0004-00000060',NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(246,8019,246,2,40720,40830,13,19726,1,0,'2021-02-08','2021-02-08',50000.00,1,1.00,'Factura B N°: 0004-00000061',NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(247,8019,247,2,40720,40830,13,19726,1,0,'2021-02-09','2021-02-09',50000.83,1,1.00,'Factura A N°: 0004-00000229',NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(248,8019,248,2,40720,40830,13,19726,2,0,'2021-02-09','2021-02-09',50000.00,1,1.00,'Nota de crédito B N°: 0004-00000005',NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(249,8019,249,2,40720,40831,13,19726,1,0,'2021-02-12','2021-02-12',25192.20,1,1.00,'Factura A N°: 0004-00000230',NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(250,8019,250,2,40720,40832,13,19726,1,0,'2021-02-17','2021-02-17',43560.00,1,1.00,'Factura A N°: 0004-00000231',NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(251,8019,251,2,40720,40833,13,19727,1,0,'2021-03-02','2021-03-02',32573.20,1,1.00,'Factura A N°: 0004-00000232',NULL,'2022-12-13 10:18:07','2022-12-13 10:18:07',NULL),(252,8019,252,2,40720,40834,13,19727,1,0,'2021-03-22','2021-03-22',26499.00,1,1.00,'Factura A N°: 0004-00000233',NULL,'2022-12-13 10:18:07','2022-12-13 10:18:07',NULL),(253,8019,253,2,40720,40827,13,19728,1,0,'2021-04-05','2021-04-05',35719.20,1,1.00,'Factura A N°: 0004-00000234',NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(254,8019,254,2,40720,40835,13,19728,1,0,'2021-04-05','2021-04-05',11567.60,1,1.00,'Factura A N°: 0004-00000235',NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(255,8019,255,2,40720,40828,13,19728,1,0,'2021-04-07','2021-04-07',116032.95,1,1.00,'Factura A N°: 0004-00000236',NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(256,8019,256,2,40720,40828,13,19728,1,0,'2021-04-14','2021-04-14',13975.50,1,1.00,'Factura A N°: 0004-00000237',NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(257,8019,257,2,40720,40836,13,19728,1,0,'2021-04-21','2021-04-21',17888.64,1,1.00,'Factura A N°: 0004-00000238',NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(258,8019,258,2,40720,40830,13,19728,1,0,'2021-04-22','2021-04-22',532400.00,1,1.00,'Factura A N°: 0004-00000239',NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL);
INSERT INTO `cta_cte_cliente` VALUES (259,8019,259,2,40720,40831,13,19728,1,0,'2021-04-28','2021-04-28',16770.60,1,1.00,'Factura A N°: 0004-00000240',NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(260,8019,260,2,40720,40833,13,19728,1,0,'2021-04-28','2021-04-28',33076.56,1,1.00,'Factura A N°: 0004-00000241',NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(261,8019,261,2,40720,40828,13,19728,1,0,'2021-04-30','2021-04-30',94501.00,1,1.00,'Factura A N°: 0004-00000242',NULL,'2022-12-13 10:18:27','2022-12-13 10:18:27',NULL),(262,8019,262,2,40720,40825,13,19729,1,0,'2021-05-06','2021-05-06',193600.00,1,1.00,'Factura A N°: 0004-00000243',NULL,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(263,8019,263,2,40720,40825,13,19729,1,0,'2021-05-17','2021-05-17',157300.00,1,1.00,'Factura A N°: 0004-00000244',NULL,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(264,8019,264,2,40720,40837,13,19729,1,0,'2021-05-22','2021-05-22',52380.90,1,1.00,'Factura A N°: 0004-00000245',NULL,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(265,8019,265,2,40720,40838,13,19729,1,0,'2021-05-22','2021-05-22',38993.46,1,1.00,'Factura A N°: 0004-00000246',NULL,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(266,8019,266,2,40720,40839,13,19729,1,0,'2021-05-27','2021-05-27',12281.50,1,1.00,'Factura A N°: 0004-00000247',NULL,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(267,8019,267,2,40720,40839,13,19730,1,0,'2021-06-14','2021-06-14',17424.00,1,1.00,'Factura A N°: 0004-00000248',NULL,'2022-12-13 10:22:09','2022-12-13 10:22:09',NULL),(268,8019,268,2,40720,40840,13,19731,1,0,'2021-07-12','2021-07-12',54424.59,1,1.00,'Factura A N°: 0004-00000249',NULL,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(269,8019,269,2,40720,40830,13,19731,1,0,'2021-07-13','2021-07-13',84700.00,1,1.00,'Factura A N°: 0004-00000250',NULL,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(270,8019,270,2,40720,40826,13,19731,1,0,'2021-07-28','2021-07-28',89540.00,1,1.00,'Factura A N°: 0004-00000251',NULL,'2022-12-13 10:22:28','2022-12-13 10:22:28',NULL),(271,8019,271,2,40720,40833,13,19732,1,0,'2021-08-02','2021-08-02',8046.50,1,1.00,'Factura A N°: 0004-00000252',NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(272,8019,272,2,40720,40827,13,19732,1,0,'2021-08-02','2021-08-02',16770.60,1,1.00,'Factura A N°: 0004-00000253',NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(273,8019,273,2,40720,40841,13,19732,1,0,'2021-08-12','2021-08-12',2246.97,1,1.00,'Factura A N°: 0004-00000254',NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(274,8019,274,2,40720,40842,13,19732,1,0,'2021-08-27','2021-08-27',44842.60,1,1.00,'Factura A N°: 0004-00000255',NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(275,8019,275,2,40720,40828,13,19732,1,0,'2021-08-27','2021-08-27',96800.00,1,1.00,'Factura A N°: 0004-00000256',NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(276,8019,276,2,40720,40831,13,19732,1,0,'2021-08-27','2021-08-27',34073.60,1,1.00,'Factura A N°: 0004-00000257',NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(277,8019,277,2,40720,40843,13,19733,1,0,'2021-09-14','2021-09-14',41473.96,1,1.00,'Factura A N°: 0004-00000258',NULL,'2022-12-13 10:23:22','2022-12-13 10:23:22',NULL),(278,8019,278,2,40720,40844,13,19733,1,0,'2021-09-14','2021-09-14',39000.00,1,1.00,'Factura B N°: 0004-00000062',NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(279,8019,279,2,40720,40838,13,19733,1,0,'2021-09-29','2021-09-29',31803.64,1,1.00,'Factura A N°: 0004-00000259',NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(280,8019,280,2,40720,40826,13,19733,1,0,'2021-09-30','2021-09-30',89540.00,1,1.00,'Factura A N°: 0004-00000260',NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(281,8019,281,2,40720,40828,13,19733,1,0,'2021-09-30','2021-09-30',67760.00,1,1.00,'Factura A N°: 0004-00000261',NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL);
INSERT INTO `cta_cte_cliente` VALUES (282,8019,282,2,40720,40839,13,19734,1,0,'2021-10-14','2021-10-14',16601.20,1,1.00,'Factura A N°: 0004-00000262',NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(283,8019,283,2,40720,40825,13,19734,1,0,'2021-10-18','2021-10-18',71995.00,1,1.00,'Factura A N°: 0004-00000263',NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(284,8019,284,2,40720,40845,13,19734,1,0,'2021-10-21','2021-10-21',2940.00,1,1.00,'Factura B N°: 0004-00000063',NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(285,8019,285,2,40720,40832,13,19734,1,0,'2021-10-31','2021-10-31',108900.00,1,1.00,'Factura A N°: 0004-00000264',NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(286,8019,286,2,40720,40825,13,19735,1,0,'2021-11-24','2021-11-24',215985.00,1,1.00,'Factura A N°: 0004-00000265',NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(287,8019,287,2,40720,40827,13,19735,1,0,'2021-11-29','2021-11-29',64178.40,1,1.00,'Factura A N°: 0004-00000266',NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(288,8019,288,2,40720,40842,13,19735,1,0,'2021-11-29','2021-11-29',42471.00,1,1.00,'Factura A N°: 0004-00000267',NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(349,8019,349,3,40861,42302,57,70033,2,0,'2022-01-01','2022-01-01',13358.40,1,1.00,'Factura A N°: 0003-00002995',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(350,8019,350,3,40861,42303,57,70033,2,0,'2022-01-01','2022-01-01',12705.00,1,1.00,'Factura A N°: 0002-00003469',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(351,8019,351,3,40861,42304,57,70033,2,0,'2022-01-02','2022-01-02',30250.00,1,1.00,'Factura A N°: 0003-00000532',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(352,8019,352,3,40861,42304,57,70033,2,0,'2022-01-02','2022-01-02',78650.00,1,1.00,'Factura A N°: 0003-00000531',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(353,8019,353,3,40861,42305,57,70033,2,0,'2022-01-03','2022-01-03',20907.78,1,1.00,'Factura A N°: 0006-00026553',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(354,8019,354,3,40861,42306,57,70033,2,0,'2022-01-03','2022-01-03',319825.51,1,1.00,'Factura A N°: 0002-00000735',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(355,8019,355,3,40861,42307,57,70033,2,0,'2022-01-03','2022-01-03',158889.60,1,1.00,'Factura A N°: 0003-00057867',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(356,8019,356,3,40861,42308,57,70033,2,0,'2022-01-03','2022-01-03',2290.15,1,1.00,'Nota de débito A N°: 0004-00003877',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(357,8019,357,3,40861,42309,57,70033,2,0,'2022-01-03','2022-01-03',121000.00,1,1.00,'Factura A N°: 0001-00000264',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(358,8019,358,3,40861,42309,57,70033,2,0,'2022-01-03','2022-01-03',26620.00,1,1.00,'Factura A N°: 0001-00000263',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(359,8019,359,3,40861,42310,57,70033,2,0,'2022-01-03','2022-01-03',2662.00,1,1.00,'Factura A N°: 0002-00031849',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(360,8019,360,3,40861,42311,57,70033,2,0,'2022-01-03','2022-01-03',121000.00,1,1.00,'Factura A N°: 0002-00000222',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(361,8019,361,3,40861,42312,57,70033,2,0,'2022-01-04','2022-01-04',616.34,1,1.00,'Factura A N°: 0629-02919756',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(362,8019,362,3,40861,42313,57,70033,2,0,'2022-01-04','2022-01-04',60845.00,1,1.00,'Factura A N°: 0002-00123305',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(363,8019,363,3,40861,42314,57,70033,2,0,'2022-01-04','2022-01-04',128952.03,1,1.00,'Factura A N°: 0015-00119001',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(364,8019,364,3,40861,42315,57,70033,2,0,'2022-01-04','2022-01-04',7664233.09,1,1.00,'Factura A N°: 1593-00074657',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL);
INSERT INTO `cta_cte_cliente` VALUES (365,8019,365,3,40861,42316,57,70033,2,0,'2022-01-05','2022-01-05',57200.26,1,1.00,'Factura A N°: 0004-00022399',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(366,8019,366,3,40861,42317,57,70033,2,0,'2022-01-05','2022-01-05',45345.96,1,1.00,'Factura A N°: 0002-00003637',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(367,8019,367,3,40861,42318,57,70033,2,0,'2022-01-05','2022-01-05',94380.00,1,1.00,'Factura A N°: 0001-00001356',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(368,8019,368,3,40861,42319,57,70033,2,0,'2022-01-05','2022-01-05',4840.00,1,1.00,'Factura A N°: 0006-00002101',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(369,8019,369,3,40861,42320,57,70033,2,0,'2022-01-05','2022-01-05',19076.86,1,1.00,'Factura A N°: 0003-00048605',NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(370,8019,370,3,40861,42321,57,70033,2,0,'2022-01-05','2022-01-05',10166.34,1,1.00,'Factura A N°: 0005-02428083',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(371,8019,371,3,40861,42320,57,70033,2,0,'2022-01-05','2022-01-05',12250.04,1,1.00,'Factura A N°: 0003-00048606',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(372,8019,372,3,40861,42322,57,70033,2,0,'2022-01-05','2022-01-05',38000.00,1,1.00,'Factura A N°: 0004-00007836',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(373,8019,373,3,40861,42323,57,70033,2,0,'2022-01-06','2022-01-06',8210.00,1,1.00,'Factura C N°: 0002-00000934',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(374,8019,374,3,40861,42324,57,70033,2,0,'2022-01-06','2022-01-06',4174.53,1,1.00,'Factura A N°: 0012-01451991',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(375,8019,375,3,40861,42324,57,70033,2,0,'2022-01-06','2022-01-06',21945.19,1,1.00,'Factura A N°: 0012-01434983',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(376,8019,376,3,40861,42325,57,70033,2,0,'2022-01-06','2022-01-06',9450.00,1,1.00,'Factura C N°: 0001-00000002',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(377,8019,377,3,40861,42318,57,70033,2,0,'2022-01-07','2022-01-07',90145.00,1,1.00,'Factura A N°: 0001-00001367',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(378,8019,378,3,40861,42326,57,70033,2,0,'2022-01-07','2022-01-07',8195108.61,1,1.00,'Factura A N°: 0113-00060507',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(379,8019,379,3,40861,42327,57,70033,2,0,'2022-01-08','2022-01-08',4000.26,1,1.00,'Factura A N°: 0004-00000045',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(380,8019,380,3,40861,42328,57,70033,2,0,'2022-01-10','2022-01-10',388323.98,1,1.00,'Factura A N°: 0003-00049031',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(381,8019,381,3,40861,42329,57,70033,2,0,'2022-01-10','2022-01-10',10043.36,1,1.00,'Factura A N°: 6364-05600067',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(382,8019,382,3,40861,42315,57,70033,2,0,'2022-01-10','2022-01-10',7685067.90,1,1.00,'Factura A N°: 1593-00074741',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(383,8019,383,3,40861,42330,57,70033,2,0,'2022-01-11','2022-01-11',26759.95,1,1.00,'Factura A N°: 0012-00053172',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(384,8019,384,3,40861,42306,57,70033,2,0,'2022-01-11','2022-01-11',321401.94,1,1.00,'Factura A N°: 0002-00000737',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(385,8019,385,3,40861,42331,57,70033,2,0,'2022-01-11','2022-01-11',214170.00,1,1.00,'Factura A N°: 0001-00000010',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(386,8019,386,3,40861,42332,57,70033,2,0,'2022-01-11','2022-01-11',7183.13,1,1.00,'Factura A N°: 0005-00176925',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(387,8019,387,3,40861,42333,57,70033,2,0,'2022-01-11','2022-01-11',84923.22,1,1.00,'Factura C N°: 0001-00000122',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL);
INSERT INTO `cta_cte_cliente` VALUES (388,8019,388,3,40861,42334,57,70033,2,0,'2022-01-11','2022-01-11',8213.44,1,1.00,'Factura A N°: 0003-00160855',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(389,8019,389,3,40861,42334,57,70033,2,0,'2022-01-11','2022-01-11',205.14,1,1.00,'Factura A N°: 0003-00160863',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(390,8019,390,3,40861,42335,57,70033,2,0,'2022-01-11','2022-01-11',169874.32,1,1.00,'Factura A N°: 0005-00002026',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(391,8019,391,3,40861,42336,57,70033,1,0,'2022-01-12','2022-01-12',123570.50,1,1.00,'Nota de crédito A N°: 0014-00001710',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(392,8019,392,3,40861,42337,57,70033,2,0,'2022-01-12','2022-01-12',50578.00,1,1.00,'Factura A N°: 0003-00004640',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(393,8019,393,3,40861,42338,57,70033,2,0,'2022-01-13','2022-01-13',1359.99,1,1.00,'Factura A N°: 0003-00000226',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(394,8019,394,3,40861,42339,57,70033,2,0,'2022-01-13','2022-01-13',1529741.50,1,1.00,'Factura A N°: 0003-00026758',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(395,8019,395,3,40861,42340,57,70033,2,0,'2022-01-13','2022-01-13',3869.99,1,1.00,'Factura A N°: 0002-00014454',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(396,8019,396,3,40861,42327,57,70033,2,0,'2022-01-13','2022-01-13',2490.04,1,1.00,'Factura A N°: 0004-00000047',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(397,8019,397,3,40861,42328,57,70033,2,0,'2022-01-14','2022-01-14',389561.99,1,1.00,'Factura A N°: 0003-00049075',NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(398,8019,398,3,40861,42339,57,70033,2,0,'2022-01-14','2022-01-14',3524.75,1,1.00,'Nota de débito A N°: 0003-00011442',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(399,8019,399,3,40861,42325,57,70033,2,0,'2022-01-14','2022-01-14',4500.00,1,1.00,'Factura C N°: 0001-00000003',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(400,8019,400,3,40861,42326,57,70033,2,0,'2022-01-14','2022-01-14',8237179.58,1,1.00,'Factura A N°: 0113-00060762',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(401,8019,401,3,40861,42341,57,70033,2,0,'2022-01-14','2022-01-14',954624.91,1,1.00,'Factura A N°: 0006-00014819',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(402,8019,402,3,40861,42342,57,70033,2,0,'2022-01-14','2022-01-14',1653261.00,1,1.00,'Factura A N°: 0005-00021326',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(403,8019,403,3,40861,42343,57,70033,2,0,'2022-01-14','2022-01-14',1633.54,1,1.00,'Factura A N°: 0011-00007449',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(404,8019,404,3,40861,42344,57,70033,2,0,'2022-01-15','2022-01-15',84373.14,1,1.00,'Factura A N°: 2172-00389250',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(405,8019,405,3,40861,42336,57,70033,2,0,'2022-01-17','2022-01-17',6234393.90,1,1.00,'Factura A N°: 0014-00012997',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(406,8019,406,3,40861,42328,57,70033,2,0,'2022-01-17','2022-01-17',3646.53,1,1.00,'Nota de débito A N°: 0003-00012840',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(407,8019,407,3,40861,42345,57,70033,2,0,'2022-01-17','2022-01-17',278925.73,1,1.00,'Factura A N°: 0004-00029195',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(408,8019,408,3,40861,42346,57,70033,2,0,'2022-01-17','2022-01-17',310.85,1,1.00,'Factura A N°: 0007-00001441',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(409,8019,409,3,40861,42315,57,70033,2,0,'2022-01-17','2022-01-17',7723869.45,1,1.00,'Factura A N°: 1593-00075468',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(410,8019,410,3,40861,42316,57,70033,2,0,'2022-01-18','2022-01-18',50460.19,1,1.00,'Factura A N°: 0004-00022464',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL);
INSERT INTO `cta_cte_cliente` VALUES (411,8019,411,3,40861,42347,57,70033,2,0,'2022-01-18','2022-01-18',125078.00,1,1.00,'Factura A N°: 0010-00008048',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(412,8019,412,3,40861,42323,57,70033,2,0,'2022-01-19','2022-01-19',3500.00,1,1.00,'Factura C N°: 0002-00000942',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(413,8019,413,3,40861,42348,57,70033,2,0,'2022-01-19','2022-01-19',866.31,1,1.00,'Factura A N°: 0113-02684748',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(414,8019,414,3,40861,42344,57,70033,2,0,'2022-01-20','2022-01-20',8281034.08,1,1.00,'Factura A N°: 2021-00120559',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(415,8019,415,3,40861,42349,57,70033,2,0,'2022-01-21','2022-01-21',55552.00,1,1.00,'Factura A N°: 0007-00068105',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(416,8019,416,3,40861,42349,57,70033,2,0,'2022-01-21','2022-01-21',55552.00,1,1.00,'Factura A N°: 0007-00068104',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(417,8019,417,3,40861,42350,57,70033,2,0,'2022-01-21','2022-01-21',48400.00,1,1.00,'Factura A N°: 0002-00004440',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(418,8019,418,3,40861,42351,57,70033,2,0,'2022-01-21','2022-01-21',1337213.35,1,1.00,'Factura A N°: 0003-00006289',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(419,8019,419,3,40861,42315,57,70033,2,0,'2022-01-21','2022-01-21',26168.52,1,1.00,'Nota de débito A N°: 1593-00014952',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(420,8019,420,3,40861,42352,57,70033,2,0,'2022-01-21','2022-01-21',342831.16,1,1.00,'Factura A N°: 0005-00183858',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(421,8019,421,3,40861,42353,57,70033,2,0,'2022-01-21','2022-01-21',630.11,1,1.00,'Factura A N°: 0003-00015720',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(422,8019,422,3,40861,42354,57,70033,2,0,'2022-01-22','2022-01-22',400.92,1,1.00,'Factura A N°: 0002-00000405',NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(423,8019,423,3,40861,42336,57,70033,1,0,'2022-01-24','2022-01-24',124687.87,1,1.00,'Nota de crédito A N°: 0014-00001712',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(424,8019,424,3,40861,42355,57,70033,2,0,'2022-01-24','2022-01-24',103.50,1,1.00,'Factura A N°: 0700-00346567',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(425,8019,425,3,40861,42356,57,70033,2,0,'2022-01-24','2022-01-24',49005.00,1,1.00,'Factura A N°: 0002-00001954',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(426,8019,426,3,40861,42357,57,70033,2,0,'2022-01-24','2022-01-24',83379.28,1,1.00,'Factura A N°: 0002-00007989',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(427,8019,427,3,40861,42357,57,70033,2,0,'2022-01-24','2022-01-24',83379.28,1,1.00,'Factura A N°: 0002-00007988',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(428,8019,428,3,40861,42358,57,70033,2,0,'2022-01-24','2022-01-24',15800.00,1,1.00,'Factura A N°: 0005-00001992',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(429,8019,429,3,40861,42359,57,70033,2,0,'2022-01-24','2022-01-24',920.01,1,1.00,'Factura A N°: 0003-00000892',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(430,8019,430,3,40861,42360,57,70033,2,0,'2022-01-24','2022-01-24',1749844.40,1,1.00,'Factura A N°: 0005-00008676',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(431,8019,431,3,40861,42361,57,70033,2,0,'2022-01-25','2022-01-25',1073976.00,1,1.00,'Factura A N°: 0002-00004403',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(432,8019,432,3,40861,42362,57,70033,2,0,'2022-01-25','2022-01-25',78892.00,1,1.00,'Factura A N°: 0002-00000307',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(433,8019,433,3,40861,42326,57,70033,2,0,'2022-01-25','2022-01-25',8297507.78,1,1.00,'Factura A N°: 0113-00061080',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL);
INSERT INTO `cta_cte_cliente` VALUES (434,8019,434,3,40861,42363,57,70033,2,0,'2022-01-25','2022-01-25',217800.00,1,1.00,'Factura A N°: 0006-00028484',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(435,8019,435,3,40861,42364,57,70033,2,0,'2022-01-25','2022-01-25',1403.99,1,1.00,'Factura A N°: 0110-00003615',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(436,8019,436,3,40861,42365,57,70033,2,0,'2022-01-25','2022-01-25',24500.00,1,1.00,'Factura C N°: 0002-00000053',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(437,8019,437,3,40861,42344,57,70033,2,0,'2022-01-25','2022-01-25',8304072.26,1,1.00,'Factura A N°: 2021-00120779',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(438,8019,438,3,40861,42366,57,70033,2,0,'2022-01-25','2022-01-25',156937.00,1,1.00,'Factura A N°: 0002-00000357',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(439,8019,439,3,40861,42367,57,70033,2,0,'2022-01-26','2022-01-26',273602.18,1,1.00,'Factura A N°: 0002-00016970',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(440,8019,440,3,40861,42353,57,70033,2,0,'2022-01-26','2022-01-26',342.96,1,1.00,'Factura A N°: 0003-00015772',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(441,8019,441,3,40861,42307,57,70033,2,0,'2022-01-27','2022-01-27',181233.45,1,1.00,'Factura A N°: 0003-00058152',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(442,8019,442,3,40861,42360,57,70033,2,0,'2022-01-27','2022-01-27',6037.42,1,1.00,'Nota de débito A N°: 0005-00001459',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(443,8019,443,3,40861,42368,57,70033,2,0,'2022-01-27','2022-01-27',13915.00,1,1.00,'Factura A N°: 0002-00006951',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(444,8019,444,3,40861,42303,57,70033,2,0,'2022-01-27','2022-01-27',272856.21,1,1.00,'Factura A N°: 0002-00003500',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(445,8019,445,3,40861,42349,57,70033,2,0,'2022-01-28','2022-01-28',55800.00,1,1.00,'Factura A N°: 0007-00068484',NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(446,8019,446,3,40861,42349,57,70033,2,0,'2022-01-28','2022-01-28',55800.00,1,1.00,'Factura A N°: 0007-00068485',NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(447,8019,447,3,40861,42336,57,70033,2,0,'2022-01-28','2022-01-28',6306053.60,1,1.00,'Factura A N°: 0013-00044729',NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(448,8019,448,3,40861,42369,57,70033,2,0,'2022-01-28','2022-01-28',201495.19,1,1.00,'Factura A N°: 0003-00010574',NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(449,8019,449,3,40861,42370,57,70033,2,0,'2022-01-28','2022-01-28',6303.87,1,1.00,'Factura A N°: 0017-00002806',NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(450,8019,450,3,40861,42371,57,70033,2,0,'2022-01-31','2022-01-31',11006.21,1,1.00,'Factura A N°: 0014-01171100',NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(451,8019,451,3,40861,42372,57,70033,2,0,'2022-01-31','2022-01-31',24894.20,1,1.00,'Factura A N°: 0002-00002622',NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(452,8019,452,3,40861,42373,57,70033,2,0,'2022-01-31','2022-01-31',2289223.20,1,1.00,'Factura A N°: 0007-00032319',NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(453,8019,453,3,40861,42344,57,70033,2,0,'2022-01-31','2022-01-31',1142.96,1,1.00,'Factura A N°: 2172-00404039',NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(454,8019,454,3,40861,42344,57,70033,2,0,'2022-01-31','2022-01-31',96911.30,1,1.00,'Factura A N°: 2172-00404038',NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(455,8019,455,3,42384,42385,57,83710,2,0,'2023-04-19','2023-04-19',107186.89,1,1.00,'Factura A N°: 0004-00145870',NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(456,8019,456,3,42384,40756,57,83710,2,0,'2023-04-24','2023-04-24',8133.88,1,1.00,'Factura A N°: 0004-00046465',NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL);
INSERT INTO `cta_cte_cliente` VALUES (457,8019,457,3,42384,42385,57,83710,2,0,'2023-04-25','2023-04-25',5744.56,1,1.00,'Factura A N°: 0004-00146188',NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(458,8019,458,3,42384,40741,57,83710,2,0,'2023-04-26','2023-04-26',9762.31,1,1.00,'Factura A N°: 0014-00018409',NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(459,8019,459,3,42384,40749,57,83710,2,0,'2023-04-27','2023-04-27',117895.91,1,1.00,'Factura A N°: 0003-00000469',NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(460,8019,460,3,42384,40761,57,83711,2,0,'2023-05-02','2023-05-02',53500.00,1,1.00,'Factura A N°: 0004-00001629',NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(461,8019,461,3,42384,40741,57,83711,2,0,'2023-05-11','2023-05-11',53634.52,1,1.00,'Factura A N°: 0014-00018704',NULL,'2023-08-19 20:58:16','2023-08-19 20:59:15','2023-08-19 20:59:15'),(462,8019,462,3,42384,40736,57,83711,2,0,'2023-05-12','2023-05-12',98728.00,1,1.00,'Factura C N°: 0002-00000029',NULL,'2023-08-19 20:58:16','2023-08-19 21:00:09','2023-08-19 21:00:09'),(463,8019,463,3,42384,42386,57,83711,2,0,'2023-05-12','2023-05-12',1910.60,1,1.00,'Factura A N°: 0004-00004085',NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(464,8019,464,3,42384,40756,57,83711,2,0,'2023-05-12','2023-05-12',1054.52,1,1.00,'Factura A N°: 0004-00046879',NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(465,8019,465,3,42384,40824,57,83711,2,0,'2023-05-17','2023-05-17',264.00,1,1.00,'Factura A N°: 0006-00001017',NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(466,8019,466,3,42384,40758,57,83711,2,0,'2023-05-18','2023-05-18',3177.99,1,1.00,'Factura A N°: 0002-00038589',NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(467,8019,467,3,42384,40746,57,83711,2,0,'2023-05-22','2023-05-22',16588.98,1,1.00,'Factura A N°: 0002-00011499',NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(468,8019,468,3,42384,42387,57,83711,2,0,'2023-05-30','2023-05-30',16000.00,1,1.00,'Factura A N°: 0006-00000940',NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(469,8019,469,3,42384,40741,57,83711,2,0,'2023-05-11','2023-05-11',53634.52,1,1.00,'Factura A N°: 0014-00018704',NULL,'2023-08-19 20:59:15','2023-08-19 20:59:15',NULL),(470,8019,470,3,42384,40736,57,83711,2,0,'2023-05-12','2023-05-12',98728.00,1,1.00,'Factura C N°: 0002-00000029',NULL,'2023-08-19 21:00:09','2023-08-19 21:00:09',NULL),(471,8019,471,3,42384,40795,57,83712,2,0,'2023-06-01','2023-06-01',1199.99,1,1.00,'Factura A N°: 0003-00002085',NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(472,8019,472,3,42384,42388,57,83712,2,0,'2023-06-05','2023-06-05',3100.00,1,1.00,'Factura B N°: 0043-00007240',NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(473,8019,473,3,42384,40736,57,83712,2,0,'2023-06-11','2023-06-11',126739.00,1,1.00,'Factura C N°: 0002-00000031',NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(474,8019,474,3,42384,42389,57,83712,2,0,'2023-06-12','2023-06-12',2250.14,1,1.00,'Factura A N°: 0004-00003204',NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(475,8019,475,3,42384,40809,57,83712,2,0,'2023-06-29','2023-06-29',3100.00,1,1.00,'Factura A N°: 0008-00004917',NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(476,8019,476,3,42384,42394,57,83714,2,0,'2023-08-01','2023-08-01',308507.00,1,1.00,'Factura A N°: 0099-00002346',NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(477,8019,477,3,42384,40746,57,83714,2,0,'2023-08-02','2023-08-02',72992.04,1,1.00,'Factura A N°: 0002-00011904',NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(478,8019,478,3,42384,40749,57,83714,2,0,'2023-08-03','2023-08-03',157590.40,1,1.00,'Factura A N°: 0003-00000483',NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(479,8019,479,3,42384,42395,57,83714,2,0,'2023-08-04','2023-08-04',240.00,1,1.00,'Factura A N°: 0001-02132533',NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL);
INSERT INTO `cta_cte_cliente` VALUES (480,8019,480,3,42384,40748,57,83714,2,0,'2023-08-07','2023-08-07',372204.88,1,1.00,'Factura A N°: 0029-00000583',NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(481,8019,481,3,42384,40756,57,83714,2,0,'2023-08-08','2023-08-08',13346.66,1,1.00,'Factura A N°: 0004-00048657',NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(482,8019,482,3,42384,42396,57,83714,2,0,'2023-08-10','2023-08-10',1800.00,1,1.00,'Factura A N°: 0005-00000988',NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(483,8019,483,3,42384,40751,57,83714,2,0,'2023-08-11','2023-08-11',46356.61,1,1.00,'Factura A N°: 0018-00115495',NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(484,8019,484,3,42384,42397,57,83714,2,0,'2023-08-14','2023-08-14',9400.00,1,1.00,'Factura A N°: 0005-00001296',NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(485,8019,485,3,42384,42396,57,83714,2,0,'2023-08-14','2023-08-14',1200.00,1,1.00,'Factura A N°: 0005-00000998',NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(486,8019,486,3,42384,42398,57,83714,2,0,'2023-08-15','2023-08-15',10700.00,1,1.00,'Factura A N°: 0004-00007145',NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(487,8019,487,3,42384,40751,57,83714,2,0,'2023-08-17','2023-08-17',16898.29,1,1.00,'Factura A N°: 0018-00115802',NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(488,8019,488,3,42384,40795,57,83714,2,0,'2023-08-17','2023-08-17',7895.00,1,1.00,'Factura A N°: 0003-00002177',NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(489,8019,489,3,42384,40736,57,83714,2,0,'2023-08-18','2023-08-18',138274.40,1,1.00,'Factura C N°: 0002-00000035',NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(490,8019,490,2,42384,42399,13,83711,1,0,'2023-05-27','2023-05-27',108900.00,1,1.00,'Factura A N°: 0001-00000001',NULL,'2023-08-19 21:12:03','2023-08-19 21:12:03',NULL),(491,8019,491,2,42384,42400,13,83712,1,0,'2023-06-09','2023-06-09',28900.00,1,1.00,'Factura A N°: 0001-00000002',NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(492,8019,492,2,42384,42401,13,83712,1,0,'2023-06-15','2023-06-15',4560.01,1,1.00,'Factura A N°: 0001-00000003',NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(493,8019,493,2,42384,42402,13,83712,1,0,'2023-06-16','2023-06-16',107100.00,1,1.00,'Factura A N°: 0001-00000004',NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(494,8019,494,2,42384,42402,13,83712,1,0,'2023-06-21','2023-06-21',19000.02,1,1.00,'Factura A N°: 0001-00000005',NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(495,8019,495,2,42384,42403,13,83712,1,0,'2023-06-21','2023-06-21',43560.00,1,1.00,'Factura A N°: 0001-00000006',NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(496,8019,496,2,42384,40828,13,83712,1,0,'2023-06-26','2023-06-26',20532.01,1,1.00,'Factura A N°: 0001-00000007',NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(497,8019,497,2,42384,40825,13,83712,1,0,'2023-06-27','2023-06-27',467394.69,1,1.00,'Factura A N°: 0001-00000008',NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(498,8019,498,2,42384,40840,13,83713,1,0,'2023-07-10','2023-07-10',143649.99,1,1.00,'Factura A N°: 0001-00000009',NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(499,8019,499,2,42384,42404,13,83713,1,0,'2023-07-28','2023-07-28',67499.85,1,1.00,'Factura A N°: 0001-00000010',NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(500,8019,500,2,42384,42405,13,83713,1,0,'2023-07-28','2023-07-28',5850.00,1,1.00,'Factura B N°: 0001-00000001',NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(501,8019,501,2,42384,40831,13,83714,1,0,'2023-08-01','2023-08-01',56099.96,1,1.00,'Factura A N°: 0001-00000011',NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(502,8019,502,2,42384,42399,13,83714,1,0,'2023-08-02','2023-08-02',53550.12,1,1.00,'Factura A N°: 0001-00000012',NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL);
INSERT INTO `cta_cte_cliente` VALUES (503,8019,503,2,42384,40826,13,83714,1,0,'2023-08-03','2023-08-03',89999.80,1,1.00,'Factura A N°: 0001-00000013',NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(504,8019,504,2,42384,40826,13,83714,1,0,'2023-08-03','2023-08-03',170999.62,1,1.00,'Factura A N°: 0001-00000014',NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(505,8019,505,2,42384,42406,13,83714,1,0,'2023-08-07','2023-08-07',19800.00,1,1.00,'Factura B N°: 0001-00000002',NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(506,8019,506,2,42384,42407,13,83714,1,0,'2023-08-07','2023-08-07',14900.00,1,1.00,'Factura B N°: 0001-00000003',NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(507,8019,507,2,42384,42408,13,83714,1,0,'2023-08-15','2023-08-15',49000.16,1,1.00,'Factura A N°: 0001-00000015',NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(508,8019,508,2,42384,42409,13,83714,1,0,'2023-08-16','2023-08-16',85399.96,1,1.00,'Factura A N°: 0001-00000016',NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(509,8019,509,3,42384,42410,57,83713,2,0,'2023-07-04','2023-07-04',1905.39,1,1.00,'Factura B N°: 0012-19157878',NULL,'2023-08-19 21:16:36','2023-08-19 21:16:36',NULL),(510,8019,510,3,42384,40817,57,83713,2,0,'2023-07-05','2023-07-05',36000.00,1,1.00,'Factura A N°: 0003-00014294',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(511,8019,511,3,42384,42411,57,83713,2,0,'2023-07-07','2023-07-07',12927.04,1,1.00,'Factura A N°: 0009-00021694',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(512,8019,512,3,42384,42410,57,83713,1,0,'2023-07-10','2023-07-10',1905.39,1,1.00,'Nota de crédito B N°: 0012-00332102',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(513,8019,513,3,42384,40767,57,83713,2,0,'2023-07-12','2023-07-12',2160.00,1,1.00,'Factura A N°: 0006-00002571',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(514,8019,514,3,42384,40762,57,83713,2,0,'2023-07-13','2023-07-13',99600.96,1,1.00,'Factura A N°: 0047-00063735',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(515,8019,515,3,42384,42410,57,83713,2,0,'2023-07-14','2023-07-14',19634.23,1,1.00,'Factura A N°: 0011-02913523',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(516,8019,516,3,42384,42395,57,83713,1,0,'2023-07-14','2023-07-14',2656.98,1,1.00,'Nota de crédito B N°: 0001-00703486',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(517,8019,517,3,42384,42395,57,83713,2,0,'2023-07-14','2023-07-14',2656.98,1,1.00,'Factura A N°: 0001-02081397',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(518,8019,518,3,42384,42410,57,83713,2,0,'2023-07-16','2023-07-16',1905.39,1,1.00,'Factura A N°: 0012-01768827',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(519,8019,519,3,42384,42410,57,83713,1,0,'2023-07-16','2023-07-16',19634.23,1,1.00,'Nota de crédito B N°: 0011-01271677',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(520,8019,520,3,42384,40762,57,83713,2,0,'2023-07-17','2023-07-17',99600.96,1,1.00,'Factura A N°: 0047-00063815',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(521,8019,521,3,42384,40762,57,83713,1,0,'2023-07-18','2023-07-18',99600.96,1,1.00,'Nota de crédito A N°: 0047-00032407',NULL,'2023-08-19 21:16:37','2023-08-19 21:19:16','2023-08-19 21:19:16'),(522,8019,522,3,42384,40795,57,83713,2,0,'2023-07-21','2023-07-21',5039.99,1,1.00,'Factura A N°: 0003-00002133',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(523,8019,523,3,42384,40736,57,83713,2,0,'2023-07-23','2023-07-23',147494.18,1,1.00,'Factura C N°: 0002-00000033',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(524,8019,524,3,42384,40795,57,83713,1,0,'2023-07-27','2023-07-27',5039.99,1,1.00,'Nota de crédito A N°: 0003-00000033',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(525,8019,525,3,42384,40795,57,83713,2,0,'2023-07-28','2023-07-28',5650.00,1,1.00,'Factura A N°: 0003-00002141',NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL);
INSERT INTO `cta_cte_cliente` VALUES (526,8019,526,3,42384,40776,57,83713,2,0,'2023-07-31','2023-07-31',5550.00,1,1.00,'Factura A N°: 0001-00001165',NULL,'2023-08-19 21:16:38','2023-08-19 21:16:38',NULL),(527,8019,527,3,42384,42412,57,83713,2,0,'2023-07-31','2023-07-31',2700.00,1,1.00,'Factura A N°: 0005-00000396',NULL,'2023-08-19 21:16:38','2023-08-19 21:16:38',NULL),(528,8019,528,3,42384,40762,57,83713,1,0,'2023-07-18','2023-07-18',99600.96,1,1.00,'Nota de crédito A N°: 0047-00032407',NULL,'2023-08-19 21:19:16','2023-08-19 21:19:16',NULL),(529,8019,529,2,42425,42426,13,103843,1,0,'2022-12-06','2022-12-06',518985.42,1,1.00,'NOTA DE DEBITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0002-00000004',NULL,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(530,8019,530,2,42425,42427,13,103843,1,0,'2022-12-15','2022-12-15',11959761.48,1,1.00,'Factura A N°: 0001-00000007',NULL,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(531,8019,531,2,42425,42428,13,103843,1,0,'2022-12-28','2022-12-28',1129008.65,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0002-00000005',NULL,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(532,8019,532,3,42425,42429,57,103843,2,0,'2023-12-01','2023-12-01',89394.80,1,1.00,'Factura A N°: 0003-00008938',NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(533,8019,533,3,42425,42430,57,103843,2,0,'2023-12-01','2023-12-01',2119.99,1,1.00,'Factura A N°: 0005-00008914',NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(534,8019,534,3,42425,42431,57,103843,2,0,'2023-12-01','2023-12-01',28749.34,1,1.00,'Factura A N°: 0011-00000828',NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(535,8019,535,3,42425,42432,57,103843,2,0,'2023-12-31','2023-12-31',37767.67,1,1.00,'Factura A N°: 0205-00091373',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(536,8019,536,3,42425,42433,57,103843,2,0,'2023-12-01','2023-12-01',75000.00,1,1.00,'Factura A N°: 0003-00000282',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(537,8019,537,3,42425,42434,57,103843,2,0,'2023-12-02','2023-12-02',66190.02,1,1.00,'Factura A N°: 0002-00001576',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(538,8019,538,3,42425,42435,57,103843,2,0,'2023-12-02','2023-12-02',20880.50,1,1.00,'Factura A N°: 0002-00000058',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(539,8019,539,3,42425,42436,57,103843,2,0,'2023-12-02','2023-12-02',11990.00,1,1.00,'Factura C N°: 0002-00009652',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(540,8019,540,3,42425,42437,57,103843,2,0,'2023-12-03','2023-12-03',20002.02,1,1.00,'Factura A N°: 0059-00003101',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(541,8019,541,3,42425,42438,57,103843,2,0,'2023-12-03','2023-12-03',4966.32,1,1.00,'Factura A N°: 5404-00011128',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(542,8019,542,3,42425,42439,57,103843,2,0,'2023-12-04','2023-12-04',12000.99,1,1.00,'Factura A N°: 0040-00039722',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(543,8019,543,3,42425,42440,57,103843,2,0,'2023-12-04','2023-12-04',695000.00,1,1.00,'Factura C N°: 0002-00000098',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(544,8019,544,3,42425,42431,57,103843,2,0,'2023-12-05','2023-12-05',9936.84,1,1.00,'Factura A N°: 0014-00000628',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(545,8019,545,3,42425,42441,57,103843,2,0,'2023-12-05','2023-12-05',112170.00,1,1.00,'Factura A N°: 0015-00000643',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(546,8019,546,3,42425,42442,57,103843,2,0,'2023-12-05','2023-12-05',50000.00,1,1.00,'Factura C N°: 0001-00000005',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(547,8019,547,3,42425,42443,57,103843,2,0,'2023-12-06','2023-12-06',2000.00,1,1.00,'Factura A N°: 0010-00001877',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(548,8019,548,3,42425,42324,57,103843,2,0,'2023-12-06','2023-12-06',20134.33,1,1.00,'Factura A N°: 0011-01625829',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL);
INSERT INTO `cta_cte_cliente` VALUES (549,8019,549,3,42425,42431,57,103843,2,0,'2023-12-07','2023-12-07',9680.00,1,1.00,'Factura A N°: 0012-00000325',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(550,8019,550,3,42425,42444,57,103843,2,0,'2023-12-09','2023-12-09',3170.01,1,1.00,'Factura A N°: 0004-00000215',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(551,8019,551,3,42425,42445,57,103843,2,0,'2023-12-10','2023-12-10',23900.00,1,1.00,'Factura A N°: 0019-00005102',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(552,8019,552,3,42425,42446,57,103843,2,0,'2023-12-11','2023-12-11',128184.77,1,1.00,'Factura A N°: 0001-00020821',NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(553,8019,553,3,42425,42447,57,103843,2,0,'2023-12-11','2023-12-11',13068.00,1,1.00,'Factura A N°: 0001-00000189',NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(554,8019,554,3,42425,42448,57,103843,2,0,'2023-12-11','2023-12-11',28500.00,1,1.00,'Factura C N°: 0001-00000058',NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(555,8019,555,3,42425,40813,57,103843,2,0,'2023-12-14','2023-12-14',60900.06,1,1.00,'Factura A N°: 10122-00001830',NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(556,8019,556,3,42425,42329,57,103843,2,0,'2023-12-15','2023-12-15',14336.00,1,1.00,'Factura A N°: 4264-03118525',NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(557,8019,557,3,42425,42431,57,103843,2,0,'2023-12-19','2023-12-19',1250.00,1,1.00,'Factura A N°: 0014-00000700',NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(558,8019,558,3,42425,42449,57,103843,2,0,'2023-12-20','2023-12-20',100330.00,1,1.00,'Factura C N°: 0001-00000035',NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(559,8019,559,3,42425,42450,57,103843,2,0,'2023-12-21','2023-12-21',19549.99,1,1.00,'Factura A N°: 9291-00001057',NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(560,8019,560,3,42425,42451,57,103843,2,0,'2023-12-22','2023-12-22',29711.55,1,1.00,'Factura A N°: 0006-00204080',NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(561,8019,561,3,42425,42452,57,103843,2,0,'2023-12-22','2023-12-22',47042.12,1,1.00,'Factura A N°: 0070-00003609',NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(562,8019,562,3,42425,42329,57,103843,2,0,'2023-12-24','2023-12-24',3630.94,1,1.00,'Factura A N°: 6364-08022731',NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(563,8019,563,3,42425,42453,57,103843,2,0,'2023-12-29','2023-12-29',49960.01,1,1.00,'Factura A N°: 0004-00000086',NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(11) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `is_a_cuenta` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `cccpr_a_cuenta_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_cccpr_a_cuenta_id` (`cccpr_a_cuenta_id`),
  CONSTRAINT `fk_cccpr_a_cuenta_id` FOREIGN KEY (`cccpr_a_cuenta_id`) REFERENCES `cta_cte_cliente_pivot_receipt` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=564 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (1,8019,1,1,NULL,0,NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(2,8019,2,2,NULL,0,NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(3,8019,3,3,NULL,0,NULL,'2022-12-13 10:08:35','2022-12-13 10:08:35',NULL),(4,8019,4,4,NULL,0,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(5,8019,5,5,NULL,0,NULL,'2022-12-13 10:08:36','2022-12-13 10:09:55','2022-12-13 10:09:55'),(6,8019,6,6,NULL,0,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(7,8019,7,7,NULL,0,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(8,8019,8,8,NULL,0,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(9,8019,9,9,NULL,0,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(10,8019,10,10,NULL,0,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(11,8019,11,11,NULL,0,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(12,8019,12,12,NULL,0,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(13,8019,13,13,NULL,0,NULL,'2022-12-13 10:08:36','2022-12-13 10:08:36',NULL),(14,8019,14,5,NULL,0,NULL,'2022-12-13 10:09:55','2022-12-13 10:09:55',NULL),(15,8019,15,14,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(16,8019,16,15,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(17,8019,17,16,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(18,8019,18,17,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(19,8019,19,18,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(20,8019,20,19,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(21,8019,21,20,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(22,8019,22,21,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(23,8019,23,22,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(24,8019,24,23,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(25,8019,25,24,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(26,8019,26,25,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(27,8019,27,26,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(28,8019,28,27,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(29,8019,29,28,NULL,0,NULL,'2022-12-13 10:10:31','2022-12-13 10:10:31',NULL),(30,8019,30,29,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(31,8019,31,30,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(32,8019,32,31,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(33,8019,33,32,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(34,8019,34,33,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(35,8019,35,34,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(36,8019,36,35,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(37,8019,37,36,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(38,8019,38,37,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(39,8019,39,38,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(40,8019,40,39,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(41,8019,41,40,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(42,8019,42,41,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(43,8019,43,42,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(44,8019,44,43,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(45,8019,45,44,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(46,8019,46,45,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(47,8019,47,46,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(48,8019,48,47,NULL,0,NULL,'2022-12-13 10:11:06','2022-12-13 10:11:06',NULL),(49,8019,49,48,NULL,0,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(50,8019,50,49,NULL,0,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(51,8019,51,50,NULL,0,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (52,8019,52,51,NULL,0,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(53,8019,53,52,NULL,0,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(54,8019,54,53,NULL,0,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(55,8019,55,54,NULL,0,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(56,8019,56,55,NULL,0,NULL,'2022-12-13 10:11:32','2022-12-13 10:11:32',NULL),(57,8019,57,56,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(58,8019,58,57,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(59,8019,59,58,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(60,8019,60,59,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(61,8019,61,60,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(62,8019,62,61,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(63,8019,63,62,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(64,8019,64,63,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(65,8019,65,64,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(66,8019,66,65,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(67,8019,67,66,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(68,8019,68,67,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(69,8019,69,68,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(70,8019,70,69,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(71,8019,71,70,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(72,8019,72,71,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(73,8019,73,72,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(74,8019,74,73,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(75,8019,75,74,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(76,8019,76,75,NULL,0,NULL,'2022-12-13 10:11:33','2022-12-13 10:11:33',NULL),(77,8019,77,76,NULL,0,NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(78,8019,78,77,NULL,0,NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(79,8019,79,78,NULL,0,NULL,'2022-12-13 10:14:01','2022-12-13 10:14:01',NULL),(80,8019,80,79,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(81,8019,81,80,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(82,8019,82,81,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(83,8019,83,82,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(84,8019,84,83,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(85,8019,85,84,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(86,8019,86,85,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(87,8019,87,86,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(88,8019,88,87,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(89,8019,89,88,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(90,8019,90,89,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(91,8019,91,90,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(92,8019,92,91,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(93,8019,93,92,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(94,8019,94,93,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(95,8019,95,94,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(96,8019,96,95,NULL,0,NULL,'2022-12-13 10:14:02','2022-12-13 10:14:02',NULL),(97,8019,97,96,NULL,0,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(98,8019,98,97,NULL,0,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(99,8019,99,98,NULL,0,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(100,8019,100,99,NULL,0,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(101,8019,101,100,NULL,0,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL),(102,8019,102,101,NULL,0,NULL,'2022-12-13 10:14:21','2022-12-13 10:14:21',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (103,8019,103,102,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(104,8019,104,103,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(105,8019,105,104,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(106,8019,106,105,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(107,8019,107,106,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(108,8019,108,107,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(109,8019,109,108,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(110,8019,110,109,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(111,8019,111,110,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(112,8019,112,111,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(113,8019,113,112,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(114,8019,114,113,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(115,8019,115,114,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(116,8019,116,115,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(117,8019,117,116,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(118,8019,118,117,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(119,8019,119,118,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(120,8019,120,119,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(121,8019,121,120,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(122,8019,122,121,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(123,8019,123,122,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(124,8019,124,123,NULL,0,NULL,'2022-12-13 10:14:22','2022-12-13 10:14:22',NULL),(125,8019,125,124,NULL,0,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(126,8019,126,125,NULL,0,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(127,8019,127,126,NULL,0,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(128,8019,128,127,NULL,0,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(129,8019,129,128,NULL,0,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(130,8019,130,129,NULL,0,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(131,8019,131,130,NULL,0,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(132,8019,132,131,NULL,0,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(133,8019,133,132,NULL,0,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(134,8019,134,133,NULL,0,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(135,8019,135,134,NULL,0,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(136,8019,136,135,NULL,0,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(137,8019,137,136,NULL,0,NULL,'2022-12-13 10:14:41','2022-12-13 10:14:41',NULL),(138,8019,138,137,NULL,0,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(139,8019,139,138,NULL,0,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(140,8019,140,139,NULL,0,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(141,8019,141,140,NULL,0,NULL,'2022-12-13 10:14:42','2022-12-13 10:14:42',NULL),(142,8019,142,141,NULL,0,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(143,8019,143,142,NULL,0,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(144,8019,144,143,NULL,0,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(145,8019,145,144,NULL,0,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(146,8019,146,145,NULL,0,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(147,8019,147,146,NULL,0,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(148,8019,148,147,NULL,0,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(149,8019,149,148,NULL,0,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(150,8019,150,149,NULL,0,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL),(151,8019,151,150,NULL,0,NULL,'2022-12-13 10:15:01','2022-12-13 10:15:01',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (152,8019,152,151,NULL,0,NULL,'2022-12-13 10:15:02','2022-12-13 10:15:02',NULL),(153,8019,153,152,NULL,0,NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(154,8019,154,153,NULL,0,NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(155,8019,155,154,NULL,0,NULL,'2022-12-13 10:15:19','2022-12-13 10:15:19',NULL),(156,8019,156,155,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(157,8019,157,156,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(158,8019,158,157,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(159,8019,159,158,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(160,8019,160,159,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(161,8019,161,160,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(162,8019,162,161,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(163,8019,163,162,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(164,8019,164,163,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(165,8019,165,164,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(166,8019,166,165,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(167,8019,167,166,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(168,8019,168,167,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(169,8019,169,168,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(170,8019,170,169,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(171,8019,171,170,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(172,8019,172,171,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(173,8019,173,172,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(174,8019,174,173,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(175,8019,175,174,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(176,8019,176,175,NULL,0,NULL,'2022-12-13 10:15:20','2022-12-13 10:15:20',NULL),(177,8019,177,176,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(178,8019,178,177,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(179,8019,179,178,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(180,8019,180,179,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(181,8019,181,180,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(182,8019,182,181,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(183,8019,183,182,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(184,8019,184,183,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(185,8019,185,184,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(186,8019,186,185,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(187,8019,187,186,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(188,8019,188,187,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(189,8019,189,188,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(190,8019,190,189,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(191,8019,191,190,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(192,8019,192,191,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(193,8019,193,192,NULL,0,NULL,'2022-12-13 10:15:43','2022-12-13 10:15:43',NULL),(194,8019,194,193,NULL,0,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(195,8019,195,194,NULL,0,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(196,8019,196,195,NULL,0,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(197,8019,197,196,NULL,0,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(198,8019,198,197,NULL,0,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(199,8019,199,198,NULL,0,NULL,'2022-12-13 10:15:44','2022-12-13 10:15:44',NULL),(200,8019,200,199,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (201,8019,201,200,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(202,8019,202,201,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(203,8019,203,202,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(204,8019,204,203,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(205,8019,205,204,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(206,8019,206,205,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(207,8019,207,206,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(208,8019,208,207,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(209,8019,209,208,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(210,8019,210,209,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(211,8019,211,210,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(212,8019,212,211,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(213,8019,213,212,NULL,0,NULL,'2022-12-13 10:16:00','2022-12-13 10:16:00',NULL),(214,8019,214,213,NULL,0,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(215,8019,215,214,NULL,0,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(216,8019,216,215,NULL,0,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(217,8019,217,216,NULL,0,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(218,8019,218,217,NULL,0,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(219,8019,219,218,NULL,0,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(220,8019,220,219,NULL,0,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(221,8019,221,220,NULL,0,NULL,'2022-12-13 10:16:01','2022-12-13 10:16:01',NULL),(222,8019,222,221,NULL,0,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(223,8019,223,222,NULL,0,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(224,8019,224,223,NULL,0,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(225,8019,225,224,NULL,0,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(226,8019,226,225,NULL,0,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(227,8019,227,226,NULL,0,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(228,8019,228,227,NULL,0,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(229,8019,229,228,NULL,0,NULL,'2022-12-13 10:16:22','2022-12-13 10:16:22',NULL),(230,8019,230,229,NULL,0,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(231,8019,231,230,NULL,0,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(232,8019,232,231,NULL,0,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(233,8019,233,232,NULL,0,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(234,8019,234,233,NULL,0,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(235,8019,235,234,NULL,0,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(236,8019,236,235,NULL,0,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(237,8019,237,236,NULL,0,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(238,8019,238,237,NULL,0,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(239,8019,239,238,NULL,0,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(240,8019,240,239,NULL,0,NULL,'2022-12-13 10:16:23','2022-12-13 10:16:23',NULL),(241,8019,241,240,NULL,0,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(242,8019,242,241,NULL,0,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(243,8019,243,242,NULL,0,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(244,8019,244,243,NULL,0,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(245,8019,245,244,NULL,0,NULL,'2022-12-13 10:16:52','2022-12-13 10:16:52',NULL),(246,8019,246,245,NULL,0,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(247,8019,247,246,NULL,0,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(248,8019,248,247,NULL,0,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(249,8019,249,248,NULL,0,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (250,8019,250,249,NULL,0,NULL,'2022-12-13 10:17:17','2022-12-13 10:17:17',NULL),(251,8019,251,250,NULL,0,NULL,'2022-12-13 10:18:07','2022-12-13 10:18:07',NULL),(252,8019,252,251,NULL,0,NULL,'2022-12-13 10:18:07','2022-12-13 10:18:07',NULL),(253,8019,253,252,NULL,0,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(254,8019,254,253,NULL,0,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(255,8019,255,254,NULL,0,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(256,8019,256,255,NULL,0,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(257,8019,257,256,NULL,0,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(258,8019,258,257,NULL,0,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(259,8019,259,258,NULL,0,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(260,8019,260,259,NULL,0,NULL,'2022-12-13 10:18:26','2022-12-13 10:18:26',NULL),(261,8019,261,260,NULL,0,NULL,'2022-12-13 10:18:27','2022-12-13 10:18:27',NULL),(262,8019,262,261,NULL,0,NULL,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(263,8019,263,262,NULL,0,NULL,'2022-12-13 10:20:01','2022-12-13 10:20:01',NULL),(264,8019,264,263,NULL,0,NULL,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(265,8019,265,264,NULL,0,NULL,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(266,8019,266,265,NULL,0,NULL,'2022-12-13 10:20:02','2022-12-13 10:20:02',NULL),(267,8019,267,266,NULL,0,NULL,'2022-12-13 10:22:09','2022-12-13 10:22:09',NULL),(268,8019,268,267,NULL,0,NULL,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(269,8019,269,268,NULL,0,NULL,'2022-12-13 10:22:27','2022-12-13 10:22:27',NULL),(270,8019,270,269,NULL,0,NULL,'2022-12-13 10:22:28','2022-12-13 10:22:28',NULL),(271,8019,271,270,NULL,0,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(272,8019,272,271,NULL,0,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(273,8019,273,272,NULL,0,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(274,8019,274,273,NULL,0,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(275,8019,275,274,NULL,0,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(276,8019,276,275,NULL,0,NULL,'2022-12-13 10:22:46','2022-12-13 10:22:46',NULL),(277,8019,277,276,NULL,0,NULL,'2022-12-13 10:23:22','2022-12-13 10:23:22',NULL),(278,8019,278,277,NULL,0,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(279,8019,279,278,NULL,0,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(280,8019,280,279,NULL,0,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(281,8019,281,280,NULL,0,NULL,'2022-12-13 10:23:23','2022-12-13 10:23:23',NULL),(282,8019,282,281,NULL,0,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(283,8019,283,282,NULL,0,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(284,8019,284,283,NULL,0,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(285,8019,285,284,NULL,0,NULL,'2022-12-13 10:23:44','2022-12-13 10:23:44',NULL),(286,8019,286,285,NULL,0,NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(287,8019,287,286,NULL,0,NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(288,8019,288,287,NULL,0,NULL,'2022-12-13 10:25:01','2022-12-13 10:25:01',NULL),(349,8019,349,348,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(350,8019,350,349,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(351,8019,351,350,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(352,8019,352,351,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(353,8019,353,352,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(354,8019,354,353,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(355,8019,355,354,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(356,8019,356,355,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(357,8019,357,356,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(358,8019,358,357,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (359,8019,359,358,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(360,8019,360,359,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(361,8019,361,360,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(362,8019,362,361,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(363,8019,363,362,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(364,8019,364,363,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(365,8019,365,364,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(366,8019,366,365,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(367,8019,367,366,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(368,8019,368,367,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(369,8019,369,368,NULL,0,NULL,'2023-05-02 22:51:24','2023-05-02 22:51:24',NULL),(370,8019,370,369,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(371,8019,371,370,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(372,8019,372,371,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(373,8019,373,372,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(374,8019,374,373,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(375,8019,375,374,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(376,8019,376,375,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(377,8019,377,376,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(378,8019,378,377,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(379,8019,379,378,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(380,8019,380,379,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(381,8019,381,380,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(382,8019,382,381,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(383,8019,383,382,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(384,8019,384,383,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(385,8019,385,384,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(386,8019,386,385,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(387,8019,387,386,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(388,8019,388,387,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(389,8019,389,388,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(390,8019,390,389,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(391,8019,391,390,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(392,8019,392,391,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(393,8019,393,392,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(394,8019,394,393,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(395,8019,395,394,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(396,8019,396,395,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(397,8019,397,396,NULL,0,NULL,'2023-05-02 22:51:25','2023-05-02 22:51:25',NULL),(398,8019,398,397,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(399,8019,399,398,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(400,8019,400,399,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(401,8019,401,400,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(402,8019,402,401,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(403,8019,403,402,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(404,8019,404,403,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(405,8019,405,404,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(406,8019,406,405,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(407,8019,407,406,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (408,8019,408,407,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(409,8019,409,408,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(410,8019,410,409,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(411,8019,411,410,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(412,8019,412,411,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(413,8019,413,412,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(414,8019,414,413,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(415,8019,415,414,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(416,8019,416,415,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(417,8019,417,416,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(418,8019,418,417,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(419,8019,419,418,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(420,8019,420,419,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(421,8019,421,420,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(422,8019,422,421,NULL,0,NULL,'2023-05-02 22:51:26','2023-05-02 22:51:26',NULL),(423,8019,423,422,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(424,8019,424,423,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(425,8019,425,424,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(426,8019,426,425,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(427,8019,427,426,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(428,8019,428,427,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(429,8019,429,428,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(430,8019,430,429,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(431,8019,431,430,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(432,8019,432,431,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(433,8019,433,432,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(434,8019,434,433,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(435,8019,435,434,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(436,8019,436,435,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(437,8019,437,436,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(438,8019,438,437,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(439,8019,439,438,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(440,8019,440,439,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(441,8019,441,440,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(442,8019,442,441,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(443,8019,443,442,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(444,8019,444,443,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(445,8019,445,444,NULL,0,NULL,'2023-05-02 22:51:27','2023-05-02 22:51:27',NULL),(446,8019,446,445,NULL,0,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(447,8019,447,446,NULL,0,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(448,8019,448,447,NULL,0,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(449,8019,449,448,NULL,0,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(450,8019,450,449,NULL,0,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(451,8019,451,450,NULL,0,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(452,8019,452,451,NULL,0,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(453,8019,453,452,NULL,0,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(454,8019,454,453,NULL,0,NULL,'2023-05-02 22:51:28','2023-05-02 22:51:28',NULL),(455,8019,455,454,NULL,0,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(456,8019,456,455,NULL,0,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (457,8019,457,456,NULL,0,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(458,8019,458,457,NULL,0,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(459,8019,459,458,NULL,0,NULL,'2023-08-19 20:57:47','2023-08-19 20:57:47',NULL),(460,8019,460,459,NULL,0,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(461,8019,461,460,NULL,0,NULL,'2023-08-19 20:58:16','2023-08-19 20:59:15','2023-08-19 20:59:15'),(462,8019,462,461,NULL,0,NULL,'2023-08-19 20:58:16','2023-08-19 21:00:09','2023-08-19 21:00:09'),(463,8019,463,462,NULL,0,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(464,8019,464,463,NULL,0,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(465,8019,465,464,NULL,0,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(466,8019,466,465,NULL,0,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(467,8019,467,466,NULL,0,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(468,8019,468,467,NULL,0,NULL,'2023-08-19 20:58:16','2023-08-19 20:58:16',NULL),(469,8019,469,460,NULL,0,NULL,'2023-08-19 20:59:15','2023-08-19 20:59:15',NULL),(470,8019,470,461,NULL,0,NULL,'2023-08-19 21:00:09','2023-08-19 21:00:09',NULL),(471,8019,471,468,NULL,0,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(472,8019,472,469,NULL,0,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(473,8019,473,470,NULL,0,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(474,8019,474,471,NULL,0,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(475,8019,475,472,NULL,0,NULL,'2023-08-19 21:10:43','2023-08-19 21:10:43',NULL),(476,8019,476,473,NULL,0,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(477,8019,477,474,NULL,0,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(478,8019,478,475,NULL,0,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(479,8019,479,476,NULL,0,NULL,'2023-08-19 21:11:33','2023-08-19 21:11:33',NULL),(480,8019,480,477,NULL,0,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(481,8019,481,478,NULL,0,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(482,8019,482,479,NULL,0,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(483,8019,483,480,NULL,0,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(484,8019,484,481,NULL,0,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(485,8019,485,482,NULL,0,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(486,8019,486,483,NULL,0,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(487,8019,487,484,NULL,0,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(488,8019,488,485,NULL,0,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(489,8019,489,486,NULL,0,NULL,'2023-08-19 21:11:34','2023-08-19 21:11:34',NULL),(490,8019,490,487,NULL,0,NULL,'2023-08-19 21:12:03','2023-08-19 21:12:03',NULL),(491,8019,491,488,NULL,0,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(492,8019,492,489,NULL,0,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(493,8019,493,490,NULL,0,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(494,8019,494,491,NULL,0,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(495,8019,495,492,NULL,0,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(496,8019,496,493,NULL,0,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(497,8019,497,494,NULL,0,NULL,'2023-08-19 21:12:19','2023-08-19 21:12:19',NULL),(498,8019,498,495,NULL,0,NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(499,8019,499,496,NULL,0,NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(500,8019,500,497,NULL,0,NULL,'2023-08-19 21:12:31','2023-08-19 21:12:31',NULL),(501,8019,501,498,NULL,0,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(502,8019,502,499,NULL,0,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(503,8019,503,500,NULL,0,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(504,8019,504,501,NULL,0,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(505,8019,505,502,NULL,0,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (506,8019,506,503,NULL,0,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(507,8019,507,504,NULL,0,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(508,8019,508,505,NULL,0,NULL,'2023-08-19 21:12:42','2023-08-19 21:12:42',NULL),(509,8019,509,506,NULL,0,NULL,'2023-08-19 21:16:36','2023-08-19 21:16:36',NULL),(510,8019,510,507,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(511,8019,511,508,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(512,8019,512,509,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(513,8019,513,510,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(514,8019,514,511,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(515,8019,515,512,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(516,8019,516,513,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(517,8019,517,514,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(518,8019,518,515,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(519,8019,519,516,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(520,8019,520,517,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(521,8019,521,518,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:19:16','2023-08-19 21:19:16'),(522,8019,522,519,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(523,8019,523,520,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(524,8019,524,521,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(525,8019,525,522,NULL,0,NULL,'2023-08-19 21:16:37','2023-08-19 21:16:37',NULL),(526,8019,526,523,NULL,0,NULL,'2023-08-19 21:16:38','2023-08-19 21:16:38',NULL),(527,8019,527,524,NULL,0,NULL,'2023-08-19 21:16:38','2023-08-19 21:16:38',NULL),(528,8019,528,518,NULL,0,NULL,'2023-08-19 21:19:16','2023-08-19 21:19:16',NULL),(529,8019,529,525,NULL,0,NULL,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(530,8019,530,526,NULL,0,NULL,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(531,8019,531,527,NULL,0,NULL,'2024-02-10 19:09:43','2024-02-10 19:09:43',NULL),(532,8019,532,528,NULL,0,NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(533,8019,533,529,NULL,0,NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(534,8019,534,530,NULL,0,NULL,'2024-02-10 19:19:55','2024-02-10 19:19:55',NULL),(535,8019,535,531,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(536,8019,536,532,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(537,8019,537,533,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(538,8019,538,534,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(539,8019,539,535,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(540,8019,540,536,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(541,8019,541,537,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(542,8019,542,538,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(543,8019,543,539,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(544,8019,544,540,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(545,8019,545,541,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(546,8019,546,542,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(547,8019,547,543,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(548,8019,548,544,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(549,8019,549,545,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(550,8019,550,546,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(551,8019,551,547,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(552,8019,552,548,NULL,0,NULL,'2024-02-10 19:19:56','2024-02-10 19:19:56',NULL),(553,8019,553,549,NULL,0,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(554,8019,554,550,NULL,0,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (555,8019,555,551,NULL,0,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(556,8019,556,552,NULL,0,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(557,8019,557,553,NULL,0,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(558,8019,558,554,NULL,0,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(559,8019,559,555,NULL,0,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(560,8019,560,556,NULL,0,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(561,8019,561,557,NULL,0,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(562,8019,562,558,NULL,0,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL),(563,8019,563,559,NULL,0,NULL,'2024-02-10 19:19:57','2024-02-10 19:19:57',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `ticket_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `cta_cte_tesoreria_moneda_id_foreign` (`moneda_id`),
  KEY `cta_cte_tesoreria_ticket_id_foreign` (`ticket_id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_ticket_id_foreign` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_cheq`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_cheq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_cheq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `chequera_tipo_id` int(10) unsigned NOT NULL,
  `serie` text COLLATE utf8mb4_unicode_ci,
  `numero_cheque` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_cheq_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` (`cta_cte_tesoreria_banco_id`),
  KEY `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` (`chequera_tipo_id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_chequera_tipo_id_foreign` FOREIGN KEY (`chequera_tipo_id`) REFERENCES `chequeras_tipos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_banco_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_cheq_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_cheq`
--

LOCK TABLES `cta_cte_tesoreria_banco_cheq` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_cheq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_banco_claves`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_banco_claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_banco_claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_banco_claves_person_id_foreign` (`person_id`),
  KEY `ct_cuenta_id` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ct_banco_id` (`cta_cte_tesoreria_banco_id`),
  CONSTRAINT `ct_banco_id` FOREIGN KEY (`cta_cte_tesoreria_banco_id`) REFERENCES `cta_cte_tesoreria_bancos` (`id`),
  CONSTRAINT `ct_cuenta_id` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_banco_claves_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_banco_claves`
--

LOCK TABLES `cta_cte_tesoreria_banco_claves` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_banco_claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_bancos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `ctacte_banco_id` int(10) unsigned NOT NULL,
  `persona_empresa` int(11) NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id` int(10) unsigned NOT NULL,
  `cuenta_contable_id_diferido` int(10) unsigned DEFAULT NULL,
  `cuenta_contable_id_pend_acred` int(10) unsigned DEFAULT NULL,
  `numero_cuenta` text COLLATE utf8mb4_unicode_ci,
  `cbu` text COLLATE utf8mb4_unicode_ci,
  `alias` text COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_bancos_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` (`ctacte_banco_id`),
  KEY `cta_cte_tesoreria_bancos_zone_id_foreign` (`zone_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` (`cuenta_contable_id`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` (`cuenta_contable_id_diferido`),
  KEY `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` (`cuenta_contable_id_pend_acred`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_ctacte_banco_id_foreign` FOREIGN KEY (`ctacte_banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_diferido_foreign` FOREIGN KEY (`cuenta_contable_id_diferido`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_foreign` FOREIGN KEY (`cuenta_contable_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_cuenta_contable_id_pend_acred_foreign` FOREIGN KEY (`cuenta_contable_id_pend_acred`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_bancos_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_bancos`
--

LOCK TABLES `cta_cte_tesoreria_bancos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuenta_tipos`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuenta_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuenta_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuenta_tipos`
--

LOCK TABLES `cta_cte_tesoreria_cuenta_tipos` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuenta_tipos` VALUES (1,NULL,'CAJA',1,NULL,NULL,NULL),(2,NULL,'BANCOS',1,NULL,NULL,NULL),(3,NULL,'CHEQUES',1,NULL,NULL,NULL),(4,NULL,'RETENCIONES EFECTUADAS',1,NULL,'2024-05-26 20:59:19',NULL),(5,NULL,'PERCEPCIONES EFECTUADAS',1,NULL,'2024-05-26 20:59:19',NULL),(6,NULL,'RESULTADO NEGATIVO',1,NULL,NULL,NULL),(7,NULL,'RESULTADO POSITIVO',1,NULL,NULL,NULL),(8,NULL,'MOVIMIENTO',1,NULL,NULL,NULL),(9,NULL,'RETENCIONES SUFRIDAS',1,NULL,NULL,NULL),(10,NULL,'PERCEPCIONES SUFRIDAS',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuenta_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_tipo_id` int(10) unsigned NOT NULL DEFAULT '8',
  `retention_type_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `cta_tes_tipo_id_foreign` (`cta_cte_tesoreria_cuenta_tipo_id`),
  KEY `cta_cte_tesoreria_cuentas_moneda_id_foreign` (`moneda_id`),
  KEY `cta_cte_tesoreria_cuentas_retention_type_id_foreign` (`retention_type_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_retention_type_id_foreign` FOREIGN KEY (`retention_type_id`) REFERENCES `retention_types` (`id`),
  CONSTRAINT `cta_tes_tipo_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_tipo_id`) REFERENCES `cta_cte_tesoreria_cuenta_tipos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,NULL,1,13,NULL,8,NULL,'Clientes - Deudores',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,NULL,1,20,NULL,8,NULL,'Anticipos Impuesto a las Ganancias',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,NULL,1,23,NULL,4,NULL,'Retenciones Impuesto a las Ganancias',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(25,NULL,1,25,NULL,4,NULL,'Retenciones de IVA',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(57,NULL,1,57,NULL,8,NULL,'Proveedores en Cta. Cte. locales',NULL,0,0,0,0,0,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,NULL,1,60,NULL,3,NULL,'Cheques emitidos ',NULL,0,1,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(62,NULL,1,62,NULL,8,NULL,'Sueldos y Jornales a pagar',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,NULL,1,140,NULL,6,NULL,'Intereses y Gastos bancarios',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(162,NULL,1,162,NULL,4,NULL,'Retenciones SUSS',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(176,NULL,1,176,NULL,3,NULL,'Cheques en Cartera',NULL,1,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(201,NULL,1,201,NULL,6,NULL,'Monotributo',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(203,NULL,1,203,NULL,6,NULL,'Autonomos',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(219,NULL,1,219,NULL,8,NULL,'Pagos AFIP',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,NULL,1,251,NULL,4,NULL,'Retenciones de IIBB Buenos Aires',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(252,NULL,1,252,NULL,4,NULL,'Retenciones de IIBB Capital Federal',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(253,NULL,1,253,NULL,4,NULL,'Retenciones de IIBB Catamarca',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(254,NULL,1,254,NULL,4,NULL,'Retenciones de IIBB Chaco',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(255,NULL,1,255,NULL,4,NULL,'Retenciones de IIBB Chubut',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(256,NULL,1,256,NULL,4,NULL,'Retenciones de IIBB Córdoba',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(257,NULL,1,257,NULL,4,NULL,'Retenciones de IIBB Corrientes',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(258,NULL,1,258,NULL,4,NULL,'Retenciones de IIBB Entre Ríos',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(259,NULL,1,259,NULL,4,NULL,'Retenciones de IIBB Formosa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(260,NULL,1,260,NULL,4,NULL,'Retenciones de IIBB Jujuy',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(261,NULL,1,261,NULL,4,NULL,'Retenciones de IIBB La Pampa',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(262,NULL,1,262,NULL,4,NULL,'Retenciones de IIBB La Rioja',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(263,NULL,1,263,NULL,4,NULL,'Retenciones de IIBB Mendoza',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(264,NULL,1,264,NULL,4,NULL,'Retenciones de IIBB Misiones',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(265,NULL,1,265,NULL,4,NULL,'Retenciones de IIBB Neuquén',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(266,NULL,1,266,NULL,4,NULL,'Retenciones de IIBB Pascua Lama',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(267,NULL,1,267,NULL,4,NULL,'Retenciones de IIBB Río Negro',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(268,NULL,1,268,NULL,4,NULL,'Retenciones de IIBB Salta',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(269,NULL,1,269,NULL,4,NULL,'Retenciones de IIBB San Juan',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (270,NULL,1,270,NULL,4,NULL,'Retenciones de IIBB San Luis',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(271,NULL,1,271,NULL,4,NULL,'Retenciones de IIBB Santa Cruz',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(272,NULL,1,272,NULL,4,NULL,'Retenciones de IIBB Santa Fe',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(273,NULL,1,273,NULL,4,NULL,'Retenciones de IIBB Santiago del Estero',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(274,NULL,1,274,NULL,4,NULL,'Retenciones de IIBB Tierra del Fuego',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(275,NULL,1,275,NULL,4,NULL,'Retenciones de IIBB Tucuman',NULL,0,0,1,0,0,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(351,NULL,1,351,NULL,8,NULL,'BANCO SIRCREB',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,NULL,1,359,NULL,8,NULL,'Caja en Pesos',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:15:40','2023-03-20 23:15:40'),(360,NULL,1,360,NULL,8,NULL,'Retenciones Bancarias de Ganancias a Favor',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,NULL,1,364,NULL,8,NULL,'Anticipo de Clientes',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,NULL,1,384,NULL,8,NULL,'Caja en Dolares',NULL,0,0,1,1,1,0,1,'2019-10-19 02:10:24','2023-03-20 23:15:40','2023-03-20 23:15:40'),(409,NULL,1,409,NULL,6,NULL,'IVA Crédito Fiscal No computable',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(418,NULL,1,418,NULL,8,NULL,'Deudas Bancarias',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,NULL,1,433,NULL,8,NULL,'Préstamo',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,NULL,1,441,NULL,8,NULL,'Leasing',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,NULL,1,448,NULL,8,NULL,'Planes de Pagos AFIP',NULL,0,0,0,1,1,0,1,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,NULL,1,450,NULL,3,NULL,'Cheques Rechazados',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(467,NULL,1,467,NULL,6,NULL,'Interés',NULL,0,0,0,0,1,0,1,'2019-10-19 02:10:24','2023-03-27 00:17:11',NULL),(468,NULL,1,14,NULL,8,NULL,'Deudores por ventas comunes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(469,NULL,1,15,NULL,8,NULL,'Deudores por ventas morosos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(470,NULL,1,16,NULL,8,NULL,'Deudores en gestión judicial',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(471,NULL,1,17,NULL,8,NULL,'Previsión deudores incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(472,NULL,1,22,NULL,8,NULL,'Anticipo Impto.Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(473,NULL,1,24,NULL,4,NULL,'Impuesto a las Ganancias (Saldo a favor)',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:55:45',NULL),(474,NULL,1,27,NULL,8,NULL,'Anticipos de proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(475,NULL,1,28,NULL,8,NULL,'Depósito en garantía alquileres',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(476,NULL,1,29,NULL,8,NULL,'Derechos adquiridos a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(477,NULL,1,30,NULL,8,NULL,'Intereses a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(478,NULL,1,31,NULL,8,NULL,'Cuentas a rendir - Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(479,NULL,1,32,NULL,8,NULL,'Alquileres no devengados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(480,NULL,1,38,NULL,8,NULL,'Equipos de computación valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (481,NULL,1,39,NULL,8,NULL,'Equipos de computación ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(482,NULL,1,40,NULL,8,NULL,'Amortización Acumulada Equipos de comput.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(483,NULL,1,42,NULL,8,NULL,'Instalaciones valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(484,NULL,1,43,NULL,8,NULL,'Instalaciones ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(485,NULL,1,44,NULL,8,NULL,'Amortización Acumulada Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(486,NULL,1,46,NULL,8,NULL,'Muebles y utiles valores históricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(487,NULL,1,47,NULL,8,NULL,'Muebles y utiles ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(488,NULL,1,48,NULL,8,NULL,'Amortización Acumulada Muebles y Útiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(489,NULL,1,50,NULL,8,NULL,'Gastos de organización valores historicos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(490,NULL,1,51,NULL,8,NULL,'Gastos de organización ajuste',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(491,NULL,1,52,NULL,8,NULL,'Amortización acumulada gs. de organización',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(492,NULL,1,58,NULL,8,NULL,'Proveedores en cta. cte. exterior',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(493,NULL,1,59,NULL,8,NULL,'Derechos de exhibición a devengar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(494,NULL,1,63,NULL,8,NULL,'Cargas sociales a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(495,NULL,1,64,NULL,8,NULL,'Sindicatos a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(496,NULL,1,67,NULL,8,NULL,'IVA Debito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(497,NULL,1,68,NULL,8,NULL,'IVA Credito Fiscal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(498,NULL,1,69,NULL,8,NULL,'Impuestos Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(499,NULL,1,70,NULL,8,NULL,'Impuestos al Combustible',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(500,NULL,1,71,NULL,8,NULL,'IVA Retenciones de terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(501,NULL,1,72,NULL,5,NULL,'IVA Percepciones realiz.por terceros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(502,NULL,1,73,NULL,8,NULL,'IVA Saldo a favor',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(503,NULL,1,74,NULL,8,NULL,'IVA a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(504,NULL,1,75,NULL,5,NULL,'Percepciones Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(505,NULL,1,76,NULL,8,NULL,'Otros Pagos AFIP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(506,NULL,1,78,NULL,8,NULL,'Impuesto a los Ingresos Brutos Pasivo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(507,NULL,1,79,NULL,8,NULL,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(508,NULL,1,80,NULL,8,NULL,'Impuesto a la Ganancia Mínima Presunta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(509,NULL,1,81,NULL,8,NULL,'AFIP - Retenciones Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(510,NULL,1,82,NULL,8,NULL,'AFIP - Plan de Facilidades Decreto 338/02',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(511,NULL,1,87,NULL,8,NULL,'Acciones en circulación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (512,NULL,1,88,NULL,8,NULL,'Ajuste del Capital',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(513,NULL,1,89,NULL,8,NULL,'Aportes Irrevocables Futuras Suscripciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(514,NULL,1,91,NULL,8,NULL,'Resultado del ejercicio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(515,NULL,1,92,NULL,8,NULL,'Resultado ejercicios anteriores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(516,NULL,1,93,NULL,8,NULL,'A.R.E.A.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(517,NULL,1,96,NULL,7,NULL,'VENTAS',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(518,NULL,1,97,NULL,7,NULL,'Honorarios',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(519,NULL,1,99,NULL,7,NULL,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(520,NULL,1,100,NULL,7,NULL,'Reintegros por exportaciones',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(521,NULL,1,102,NULL,7,NULL,'Intereses Cobrados',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(522,NULL,1,103,NULL,7,NULL,'Diferencias de cambio',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(523,NULL,1,104,NULL,7,NULL,'Descuentos obtenidos',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(524,NULL,1,110,NULL,6,NULL,'Sueldos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(525,NULL,1,111,NULL,6,NULL,'Contribuciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(526,NULL,1,112,NULL,6,NULL,'Sindicato',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(527,NULL,1,114,NULL,8,NULL,'ACA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(528,NULL,1,115,NULL,6,NULL,'Aereos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(529,NULL,1,116,NULL,6,NULL,'Alquiler',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(530,NULL,1,117,NULL,8,NULL,'AGUA AYSA',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(531,NULL,1,118,NULL,8,NULL,'TV Cablevision',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(532,NULL,1,119,NULL,1,NULL,'Caja Jubilacion Consejo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(533,NULL,1,120,NULL,6,NULL,'Celulares',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(534,NULL,1,121,NULL,3,NULL,'Cheques',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(535,NULL,1,123,NULL,8,NULL,'Comida',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(536,NULL,1,126,NULL,6,NULL,'Fletes y acarreos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(537,NULL,1,127,NULL,8,NULL,'Luz Edesur',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(538,NULL,1,128,NULL,6,NULL,'Movilidad y Viáticos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(539,NULL,1,129,NULL,8,NULL,'Mantenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(540,NULL,1,130,NULL,8,NULL,'IVA No Computable',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(541,NULL,1,131,NULL,8,NULL,'Entretenimiento',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(542,NULL,1,132,NULL,6,NULL,'Amortización Bienes de Uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(543,NULL,1,135,NULL,6,NULL,'Gastos varios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(544,NULL,1,136,NULL,6,NULL,'Ajuste por redondeo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(545,NULL,1,137,NULL,6,NULL,'Deudores Incobrables',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (546,NULL,1,141,NULL,6,NULL,'Intereses Proveedores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(547,NULL,1,143,NULL,6,NULL,'Diferencias de cambio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(548,NULL,1,144,NULL,8,NULL,'Diferencia de Cambio Bces. en M.Extranjera',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(549,NULL,1,145,NULL,6,NULL,'Diferencia tipo cambio Vendedor/Comprador',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(550,NULL,1,146,NULL,8,NULL,'Diferencia por conversion en Bce. en Mon. Extranj.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(551,NULL,1,147,NULL,8,NULL,'Diferencia de cambio CMV',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(552,NULL,1,148,NULL,8,NULL,'Diferencia de cambio PT',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(553,NULL,1,149,NULL,8,NULL,'Resultado por Exposición a la Inflación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(554,NULL,1,150,NULL,8,NULL,'Diferencia de cambio PE',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(555,NULL,1,151,NULL,8,NULL,'Diferencia de cambio Ds.Vtas.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(556,NULL,1,152,NULL,6,NULL,'Diferencia de cambio ME',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(557,NULL,1,153,NULL,6,NULL,'Descuentos otorgados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(558,NULL,1,155,NULL,6,NULL,'Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(559,NULL,1,156,NULL,6,NULL,'Impuesto a los Ingresos Brutos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(560,NULL,1,157,NULL,6,NULL,'Impuesto al Debito y Credito Bancario',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(561,NULL,1,159,NULL,6,NULL,'Pérdida por venta bienes de uso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(562,NULL,1,160,NULL,6,NULL,'Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(563,NULL,1,161,NULL,6,NULL,'Amortizaciones extraordinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(564,NULL,1,178,NULL,8,NULL,'Google',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(565,NULL,1,188,NULL,6,NULL,'Publicidad',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(566,NULL,1,191,NULL,6,NULL,'Cargas Sociales',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(567,NULL,1,192,NULL,6,NULL,'Honorarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(568,NULL,1,193,NULL,6,NULL,'Telefono Fijo',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(569,NULL,1,198,NULL,6,NULL,'Seguros',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(570,NULL,1,199,NULL,6,NULL,'Internet',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(571,NULL,1,204,NULL,6,NULL,'Multas Impositivas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(572,NULL,1,208,NULL,6,NULL,'Impuesto a los Ingresos Brutos - BS AS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(573,NULL,1,209,NULL,6,NULL,'SIRCREB',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(574,NULL,1,212,NULL,6,NULL,'Tarjeta Visa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(575,NULL,1,213,NULL,6,NULL,'Tarjeta American Express',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(576,NULL,1,214,NULL,6,NULL,'Tarjeta Mastercard',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(577,NULL,1,215,NULL,8,NULL,'Tarjeta Shopping',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (578,NULL,1,216,NULL,6,NULL,'Tarjeta Cencosud',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(579,NULL,1,217,NULL,6,NULL,'Compras',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(580,NULL,1,218,NULL,7,NULL,'Ventas No Gravadas',NULL,0,0,0,0,1,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(581,NULL,1,220,NULL,5,NULL,'Perc IVA -RG3337',NULL,0,0,0,0,0,1,0,'2020-02-06 17:23:07','2023-06-02 07:55:45',NULL),(582,NULL,1,221,NULL,6,NULL,'Imps. Internos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(583,NULL,1,222,NULL,6,NULL,'Imp. Gasoil',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(584,NULL,1,223,NULL,6,NULL,'Imp. Hídricos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(585,NULL,1,224,NULL,6,NULL,'ITC',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(586,NULL,1,225,NULL,5,NULL,'Perc IIBB  Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(587,NULL,1,226,NULL,5,NULL,'Perc IIBB  Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(588,NULL,1,227,NULL,5,NULL,'Perc IIBB  Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(589,NULL,1,228,NULL,5,NULL,'Perc IIBB  Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(590,NULL,1,229,NULL,5,NULL,'Perc IIBB  Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(591,NULL,1,230,NULL,5,NULL,'Perc IIBB  Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(592,NULL,1,231,NULL,5,NULL,'Perc IIBB  Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(593,NULL,1,232,NULL,5,NULL,'Perc IIBB  Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(594,NULL,1,233,NULL,5,NULL,'Perc IIBB  Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(595,NULL,1,234,NULL,5,NULL,'Perc IIBB  Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(596,NULL,1,235,NULL,5,NULL,'Perc IIBB  La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(597,NULL,1,236,NULL,5,NULL,'Perc IIBB  La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(598,NULL,1,237,NULL,5,NULL,'Perc IIBB  Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(599,NULL,1,238,NULL,5,NULL,'Perc IIBB  Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(600,NULL,1,239,NULL,5,NULL,'Perc IIBB  Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(601,NULL,1,240,NULL,5,NULL,'Perc IIBB  Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(602,NULL,1,241,NULL,5,NULL,'Perc IIBB  Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(603,NULL,1,242,NULL,5,NULL,'Perc IIBB  Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(604,NULL,1,243,NULL,5,NULL,'Perc IIBB  San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(605,NULL,1,244,NULL,5,NULL,'Perc IIBB  San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(606,NULL,1,245,NULL,5,NULL,'Perc IIBB  Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(607,NULL,1,246,NULL,5,NULL,'Perc IIBB  Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(608,NULL,1,247,NULL,5,NULL,'Perc IIBB  Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(609,NULL,1,248,NULL,5,NULL,'Perc IIBB  Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(610,NULL,1,249,NULL,5,NULL,'Perc IIBB  Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (611,NULL,1,250,NULL,6,NULL,'Compras No Gravadas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(612,NULL,1,276,NULL,6,NULL,'SIRCREB Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(613,NULL,1,277,NULL,6,NULL,'SIRCREB Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(614,NULL,1,278,NULL,6,NULL,'SIRCREB Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(615,NULL,1,279,NULL,6,NULL,'SIRCREB Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(616,NULL,1,280,NULL,6,NULL,'SIRCREB Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(617,NULL,1,281,NULL,6,NULL,'SIRCREB Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(618,NULL,1,282,NULL,6,NULL,'SIRCREB Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(619,NULL,1,283,NULL,6,NULL,'SIRCREB Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(620,NULL,1,284,NULL,6,NULL,'SIRCREB Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(621,NULL,1,285,NULL,6,NULL,'SIRCREB Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(622,NULL,1,286,NULL,6,NULL,'SIRCREB La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(623,NULL,1,287,NULL,6,NULL,'SIRCREB La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(624,NULL,1,288,NULL,6,NULL,'SIRCREB Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(625,NULL,1,289,NULL,6,NULL,'SIRCREB Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(626,NULL,1,290,NULL,6,NULL,'SIRCREB Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(627,NULL,1,291,NULL,6,NULL,'SIRCREB Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(628,NULL,1,292,NULL,6,NULL,'SIRCREB Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(629,NULL,1,293,NULL,6,NULL,'SIRCREB Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(630,NULL,1,294,NULL,6,NULL,'SIRCREB San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(631,NULL,1,295,NULL,6,NULL,'SIRCREB San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(632,NULL,1,296,NULL,6,NULL,'SIRCREB Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(633,NULL,1,297,NULL,6,NULL,'SIRCREB Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(634,NULL,1,298,NULL,6,NULL,'SIRCREB Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(635,NULL,1,299,NULL,6,NULL,'SIRCREB Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(636,NULL,1,300,NULL,6,NULL,'SIRCREB Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(637,NULL,1,301,NULL,8,NULL,'IIBB a Favor Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(638,NULL,1,302,NULL,8,NULL,'IIBB a Favor Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(639,NULL,1,303,NULL,8,NULL,'IIBB a Favor Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(640,NULL,1,304,NULL,8,NULL,'IIBB a Favor Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(641,NULL,1,305,NULL,8,NULL,'IIBB a Favor Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(642,NULL,1,306,NULL,8,NULL,'IIBB a Favor Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(643,NULL,1,307,NULL,8,NULL,'IIBB a Favor Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (644,NULL,1,308,NULL,8,NULL,'IIBB a Favor Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(645,NULL,1,309,NULL,8,NULL,'IIBB a Favor Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(646,NULL,1,310,NULL,8,NULL,'IIBB a Favor Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(647,NULL,1,311,NULL,8,NULL,'IIBB a Favor La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(648,NULL,1,312,NULL,8,NULL,'IIBB a Favor La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:11',NULL),(649,NULL,1,313,NULL,8,NULL,'IIBB a Favor Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:07','2023-03-27 00:17:12',NULL),(650,NULL,1,314,NULL,8,NULL,'IIBB a Favor Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(651,NULL,1,315,NULL,8,NULL,'IIBB a Favor Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(652,NULL,1,316,NULL,8,NULL,'IIBB a Favor Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(653,NULL,1,317,NULL,8,NULL,'IIBB a Favor Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(654,NULL,1,318,NULL,8,NULL,'IIBB a Favor Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(655,NULL,1,319,NULL,8,NULL,'IIBB a Favor San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(656,NULL,1,320,NULL,8,NULL,'IIBB a Favor San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(657,NULL,1,321,NULL,8,NULL,'IIBB a Favor Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(658,NULL,1,322,NULL,8,NULL,'IIBB a Favor Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(659,NULL,1,323,NULL,8,NULL,'IIBB a Favor Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(660,NULL,1,324,NULL,8,NULL,'IIBB a Favor Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(661,NULL,1,325,NULL,8,NULL,'IIBB a Favor Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(662,NULL,1,326,NULL,8,NULL,'IIBB a Pagar Buenos Aires',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(663,NULL,1,327,NULL,8,NULL,'IIBB a Pagar Capital Federal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(664,NULL,1,328,NULL,8,NULL,'IIBB a Pagar Catamarca',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(665,NULL,1,329,NULL,8,NULL,'IIBB a Pagar Chaco',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(666,NULL,1,330,NULL,8,NULL,'IIBB a Pagar Chubut',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(667,NULL,1,331,NULL,8,NULL,'IIBB a Pagar Córdoba',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(668,NULL,1,332,NULL,8,NULL,'IIBB a Pagar Corrientes',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(669,NULL,1,333,NULL,8,NULL,'IIBB a Pagar Entre Ríos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(670,NULL,1,334,NULL,8,NULL,'IIBB a Pagar Formosa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(671,NULL,1,335,NULL,8,NULL,'IIBB a Pagar Jujuy',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(672,NULL,1,336,NULL,8,NULL,'IIBB a Pagar La Pampa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(673,NULL,1,337,NULL,8,NULL,'IIBB a Pagar La Rioja',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(674,NULL,1,338,NULL,8,NULL,'IIBB a Pagar Mendoza',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(675,NULL,1,339,NULL,8,NULL,'IIBB a Pagar Misiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (676,NULL,1,340,NULL,8,NULL,'IIBB a Pagar Neuquén',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(677,NULL,1,341,NULL,8,NULL,'IIBB a Pagar Pascua Lama',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(678,NULL,1,342,NULL,8,NULL,'IIBB a Pagar Río Negro',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(679,NULL,1,343,NULL,8,NULL,'IIBB a Pagar Salta',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(680,NULL,1,344,NULL,8,NULL,'IIBB a Pagar San Juan',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(681,NULL,1,345,NULL,8,NULL,'IIBB a Pagar San Luis',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(682,NULL,1,346,NULL,8,NULL,'IIBB a Pagar Santa Cruz',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(683,NULL,1,347,NULL,8,NULL,'IIBB a Pagar Santa Fe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(684,NULL,1,348,NULL,8,NULL,'IIBB a Pagar Santiago del Estero',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(685,NULL,1,349,NULL,8,NULL,'IIBB a Pagar Tierra del Fuego',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(686,NULL,1,350,NULL,8,NULL,'IIBB a Pagar Tucuman',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(687,NULL,1,352,NULL,8,NULL,'Compensacion',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(688,NULL,1,353,NULL,8,NULL,'IVA Saldo Tecnico',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(689,NULL,1,354,NULL,8,NULL,'IVA Saldo Libre Disponibilidad',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(690,NULL,1,361,NULL,8,NULL,'Equipos de Computación',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(691,NULL,1,362,NULL,8,NULL,'Computadoras',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(692,NULL,1,363,NULL,8,NULL,'Muebles y Utiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(693,NULL,1,365,NULL,8,NULL,'Provision Honorarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(694,NULL,1,366,NULL,8,NULL,'Cta. Cte Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(695,NULL,1,367,NULL,8,NULL,'Provisión Honorarios Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(696,NULL,1,368,NULL,8,NULL,'Cuenta Particular Socio 1',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(697,NULL,1,369,NULL,8,NULL,'Capital',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(698,NULL,1,380,NULL,8,NULL,'Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(699,NULL,1,381,NULL,8,NULL,'Reserva Legal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(700,NULL,1,382,NULL,8,NULL,'Reserva Legal',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(701,NULL,1,383,NULL,8,NULL,'Resultado no asignado',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(702,NULL,1,386,NULL,8,NULL,'PLAZO FIJO',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(703,NULL,1,388,NULL,8,NULL,'ACCIONES',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(704,NULL,1,389,NULL,8,NULL,'Inmuebles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(705,NULL,1,390,NULL,8,NULL,'Vehiculos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(706,NULL,1,391,NULL,8,NULL,'Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(707,NULL,1,392,NULL,8,NULL,'MERCADERIAS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(708,NULL,1,393,NULL,8,NULL,'OTROS',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (709,NULL,1,395,NULL,8,NULL,'Cuenta Particular Socio 2',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(710,NULL,1,396,NULL,6,NULL,'Comisiones Y gastos Bancarios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(711,NULL,1,411,NULL,8,NULL,'Provisión Impuesto a las Ganancias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(712,NULL,1,412,NULL,6,NULL,'Amortización Muebles y Útiles',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(713,NULL,1,413,NULL,6,NULL,'Amortización Equipos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(714,NULL,1,414,NULL,8,NULL,'Amortizacion Acumulada Equipos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(715,NULL,1,415,NULL,8,NULL,'Amortización Acumulada Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(716,NULL,1,416,NULL,8,NULL,'Materias Primas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(717,NULL,1,419,NULL,8,NULL,'Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(718,NULL,1,420,NULL,8,NULL,'Amortización Acumulada Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(719,NULL,1,421,NULL,8,NULL,'Amortización Rodados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(720,NULL,1,422,NULL,8,NULL,'Amortización Maquinarias',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(721,NULL,1,423,NULL,8,NULL,'Accesorios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(722,NULL,1,424,NULL,8,NULL,'Amortización Acumulada Accesorios',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(723,NULL,1,426,NULL,8,NULL,'Reserva Facultativa',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(724,NULL,1,427,NULL,8,NULL,'Créditos por Impuestos Diferidos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(725,NULL,1,428,NULL,8,NULL,'Fondo de Comercio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(726,NULL,1,429,NULL,8,NULL,'Amortizacion Acumulada Fondo de Comercio',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(727,NULL,1,430,NULL,8,NULL,'Intereses a devengar AGIP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(728,NULL,1,431,NULL,8,NULL,'PFP IIBB',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(729,NULL,1,434,NULL,8,NULL,'Productos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(730,NULL,1,435,NULL,8,NULL,'Intereses a devengar PFP',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(731,NULL,1,437,NULL,8,NULL,'Imp. Ley 25413 Cred 0.6%',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(732,NULL,1,438,NULL,8,NULL,'Honorarios Directorio a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(733,NULL,1,439,NULL,8,NULL,'Reserva para Futuras Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(734,NULL,1,440,NULL,8,NULL,'TEAC - Trabajos Ejecutados a Certificar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(735,NULL,1,444,NULL,8,NULL,'Banco Santander Rio Cta Cte',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(736,NULL,1,449,NULL,8,NULL,'Leasing',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(737,NULL,1,453,NULL,8,NULL,'Inversión Central Caribe',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(738,NULL,1,454,NULL,8,NULL,'Otras Inversiones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(739,NULL,1,455,NULL,8,NULL,'Otros Créditos',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(740,NULL,1,456,NULL,8,NULL,'Provisión Honorarios Socio Gerente',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (741,NULL,1,459,NULL,8,NULL,'Moratoria SUSS a pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(742,NULL,1,460,NULL,8,NULL,'Impuestos Municipales a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(743,NULL,1,461,NULL,6,NULL,'Amortización Instalaciones',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(744,NULL,1,462,NULL,8,NULL,'Amortización Equipos de comput.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(745,NULL,1,463,NULL,8,NULL,'Cuenta Particular Socio 3',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(746,NULL,1,464,NULL,8,NULL,'Cuenta Particular Socio 4',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(747,NULL,1,465,NULL,8,NULL,'Otras Reservas',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(748,NULL,1,466,NULL,8,NULL,'IGMP (Saldo a Favor)',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(749,NULL,1,468,NULL,8,NULL,'Productos en Proceso',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(750,NULL,1,469,NULL,8,NULL,'Depósitos en Garantía Socio Gerente',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(751,NULL,1,470,NULL,8,NULL,'Fondos Embargados',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(752,NULL,1,471,NULL,8,NULL,'Cuota Solid.',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(753,NULL,1,472,NULL,8,NULL,'Anticipo Honorarios Directores',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(754,NULL,1,473,NULL,8,NULL,'SICORE a Pagar',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(755,NULL,1,476,NULL,6,NULL,'RECPAM',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL),(756,NULL,1,478,NULL,6,NULL,'CO2 - Imp. Al Carbono',NULL,0,0,0,0,0,1,1,'2020-02-06 17:23:08','2023-03-27 00:17:12',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_detail`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `is_conciliado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_detail_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_detail_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_detail`
--

LOCK TABLES `cta_cte_tesoreria_detail` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos`
--

DROP TABLE IF EXISTS `ctacte_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigoBCRA` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos`
--

LOCK TABLES `ctacte_bancos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos` DISABLE KEYS */;
INSERT INTO `ctacte_bancos` VALUES (1,NULL,'BANCO DE GALICIA Y BUENOS AIRES S.A.',7,NULL,NULL,NULL),(2,NULL,'BANCO DE LA NACION ARGENTINA',11,NULL,NULL,NULL),(3,NULL,'BANCO DE LA PROVINCIA DE BUENOS AIRES',14,NULL,NULL,NULL),(4,NULL,'INDUSTRIAL AND COMMERCIAL BANK OF CHINA',15,NULL,NULL,NULL),(5,NULL,'CITIBANK N.A.',16,NULL,NULL,NULL),(6,NULL,'BBVA BANCO FRANCES S.A.',17,NULL,NULL,NULL),(7,NULL,'THE BANK OF TOKYO-MITSUBISHI UFJ, LTD.',18,NULL,NULL,NULL),(8,NULL,'BANCO DE LA PROVINCIA DE CORDOBA S.A.',20,NULL,NULL,NULL),(9,NULL,'BANCO SUPERVIELLE S.A.',27,NULL,NULL,NULL),(10,NULL,'BANCO DE LA CIUDAD DE BUENOS AIRES',29,NULL,NULL,NULL),(11,NULL,'BANCO PATAGONIA S.A.',34,NULL,NULL,NULL),(12,NULL,'BANCO HIPOTECARIO S.A.',44,NULL,NULL,NULL),(13,NULL,'BANCO DE SAN JUAN S.A.',45,NULL,NULL,NULL),(14,NULL,'BANCO DEL TUCUMAN S.A.',60,NULL,NULL,NULL),(15,NULL,'BANCO MUNICIPAL DE ROSARIO',65,NULL,NULL,NULL),(16,NULL,'BANCO SANTANDER RIO S.A.',72,NULL,NULL,NULL),(17,NULL,'BANCO DEL CHUBUT S.A.',83,NULL,NULL,NULL),(18,NULL,'BANCO DE SANTA CRUZ S.A.',86,NULL,NULL,NULL),(19,NULL,'BANCO DE LA PAMPA SOCIEDAD DE ECONOMÍA M',93,NULL,NULL,NULL),(20,NULL,'BANCO DE CORRIENTES S.A.',94,NULL,NULL,NULL),(21,NULL,'BANCO PROVINCIA DEL NEUQUÉN SOCIEDAD ANÓ',97,NULL,NULL,NULL),(22,NULL,'BANCO INTERFINANZAS S.A.',147,NULL,NULL,NULL),(23,NULL,'HSBC BANK ARGENTINA S.A.',150,NULL,NULL,NULL),(24,NULL,'JPMORGAN CHASE BANK, NATIONAL ASSOCIATIO',165,NULL,NULL,NULL),(25,NULL,'BANCO CREDICOOP COOPERATIVO LIMITADO',191,NULL,NULL,NULL),(26,NULL,'BANCO DE VALORES S.A.',198,NULL,NULL,NULL),(27,NULL,'BANCO ROELA S.A.',247,NULL,NULL,NULL),(28,NULL,'BANCO MARIVA S.A.',254,NULL,NULL,NULL),(29,NULL,'BANCO ITAU ARGENTINA S.A.',259,NULL,NULL,NULL),(30,NULL,'BANK OF AMERICA, NATIONAL ASSOCIATION',262,NULL,NULL,NULL),(31,NULL,'BNP PARIBAS',266,NULL,NULL,NULL),(32,NULL,'BANCO PROVINCIA DE TIERRA DEL FUEGO',268,NULL,NULL,NULL),(33,NULL,'BANCO DE LA REPUBLICA ORIENTAL DEL URUGU',269,NULL,NULL,NULL),(34,NULL,'BANCO SAENZ S.A.',277,NULL,NULL,NULL),(35,NULL,'BANCO MERIDIAN S.A.',281,NULL,NULL,NULL),(36,NULL,'BANCO MACRO S.A.',285,NULL,NULL,NULL),(37,NULL,'BANCO COMAFI SOCIEDAD ANONIMA',299,NULL,NULL,NULL),(38,NULL,'BANCO DE INVERSION Y COMERCIO EXTERIOR S',300,NULL,NULL,NULL),(39,NULL,'BANCO PIANO S.A.',301,NULL,NULL,NULL),(40,NULL,'BANCO JULIO SOCIEDAD ANONIMA',305,NULL,NULL,NULL),(41,NULL,'BANCO RIOJA SOCIEDAD ANONIMA UNIPERSONAL',309,NULL,NULL,NULL),(42,NULL,'BANCO DEL SOL S.A.',310,NULL,NULL,NULL),(43,NULL,'NUEVO BANCO DEL CHACO S. A.',311,NULL,NULL,NULL),(44,NULL,'BANCO VOII S.A.',312,NULL,NULL,NULL),(45,NULL,'BANCO DE FORMOSA S.A.',315,NULL,NULL,NULL),(46,NULL,'BANCO CMF S.A.',319,NULL,NULL,NULL),(47,NULL,'BANCO DE SANTIAGO DEL ESTERO S.A.',321,NULL,NULL,NULL),(48,NULL,'BANCO INDUSTRIAL S.A.',322,NULL,NULL,NULL),(49,NULL,'NUEVO BANCO DE SANTA FE SOCIEDAD ANONIMA',330,NULL,NULL,NULL),(50,NULL,'BANCO CETELEM ARGENTINA S.A.',331,NULL,NULL,NULL),(51,NULL,'BANCO DE SERVICIOS FINANCIEROS S.A.',332,NULL,NULL,NULL),(52,NULL,'BANCO BRADESCO ARGENTINA S.A.U.',336,NULL,NULL,NULL),(53,NULL,'BANCO DE SERVICIOS Y TRANSACCIONES S.A.',338,NULL,NULL,NULL),(54,NULL,'RCI BANQUE S.A.',339,NULL,NULL,NULL),(55,NULL,'BACS BANCO DE CREDITO Y SECURITIZACION S',340,NULL,NULL,NULL),(56,NULL,'BANCO MASVENTAS S.A.',341,NULL,NULL,NULL),(57,NULL,'BANCO WANAP S.A.',384,NULL,NULL,NULL),(58,NULL,'NUEVO BANCO DE ENTRE RÍOS S.A.',386,NULL,NULL,NULL),(59,NULL,'BANCO COLUMBIA S.A.',389,NULL,NULL,NULL),(60,NULL,'BANCO BICA S.A.',426,NULL,NULL,NULL),(61,NULL,'BANCO COINAG S.A.',431,NULL,NULL,NULL),(62,NULL,'BANCO DE COMERCIO S.A.',432,NULL,NULL,NULL),(63,NULL,'FORD CREDIT COMPAÑIA FINANCIERA S.A.',44059,NULL,NULL,NULL),(64,NULL,'COMPAÑIA FINANCIERA ARGENTINA S.A.',44077,NULL,NULL,NULL),(65,NULL,'VOLKWAGEN FINANCIAL SERVICES CIA.FIN.S.A',44088,NULL,NULL,NULL),(66,NULL,'CORDIAL COMPAÑÍA FINANCIERA S.A.',44090,NULL,NULL,NULL),(67,NULL,'FCA COMPAÑIA FINANCIERA S.A.',44092,NULL,NULL,NULL);
INSERT INTO `ctacte_bancos` VALUES (68,NULL,'GPAT COMPAÑIA FINANCIERA S.A.',44093,NULL,NULL,NULL),(69,NULL,'MERCEDES-BENZ COMPAÑÍA FINANCIERA ARGENT',44094,NULL,NULL,NULL),(70,NULL,'ROMBO COMPAÑÍA FINANCIERA S.A.',44095,NULL,NULL,NULL),(71,NULL,'JOHN DEERE CREDIT COMPAÑÍA FINANCIERA S.',44096,NULL,NULL,NULL),(72,NULL,'PSA FINANCE ARGENTINA COMPAÑÍA FINANCIER',44098,NULL,NULL,NULL),(73,NULL,'TOYOTA COMPAÑÍA FINANCIERA DE ARGENTINA',44099,NULL,NULL,NULL),(74,NULL,'FINANDINO COMPAÑIA FINANCIERA S.A.',44100,NULL,NULL,NULL),(75,NULL,'MONTEMAR COMPAÑIA FINANCIERA S.A.',45056,NULL,NULL,NULL),(76,NULL,'MULTIFINANZAS COMPAÑIA FINANCIERA S.A.',45072,NULL,NULL,NULL),(77,NULL,'CAJA DE CREDITO \"CUENCA\" COOPERATIVA LIM',65203,NULL,NULL,NULL),(78,NULL,'MERCADO PAGO',NULL,NULL,NULL,NULL),(79,NULL,'UALA',NULL,NULL,NULL,NULL),(80,NULL,'ICBC',NULL,NULL,NULL,NULL),(81,NULL,'BMA SAU',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctacte_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos_datos`
--

DROP TABLE IF EXISTS `ctacte_bancos_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos_datos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cbu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_bancos_datos_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  CONSTRAINT `ctacte_bancos_datos_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos_datos`
--

LOCK TABLES `ctacte_bancos_datos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_bancos_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_cheques`
--

DROP TABLE IF EXISTS `ctacte_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_cheques` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `asiento_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id2` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) DEFAULT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_cobro` date DEFAULT NULL,
  `banco_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `cuit` text COLLATE utf8mb4_unicode_ci,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abierto_cruzado` int(11) NOT NULL DEFAULT '1',
  `is_no_a_la_orden` tinyint(1) NOT NULL DEFAULT '0',
  `numero` int(10) unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_cheques_asiento_id_foreign` (`asiento_id`),
  KEY `ctacte_cheques_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  KEY `ctacte_cheques_banco_id_foreign` (`banco_id`),
  KEY `ctacte_cheques_person_id_foreign` (`person_id`),
  KEY `ctacte_cheques_cta_cte_cliente_id2_foreign` (`cta_cte_cliente_id2`),
  KEY `ctacte_cheques_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesorer_id` (`cta_cte_tesoreria_id`),
  KEY `ctacte_cheques_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `ctacte_cheques_nf_cta_cte_id2_foreign` (`nf_cta_cte_id2`),
  KEY `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctacte_cheques_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `ctacte_cheques_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  CONSTRAINT `cta_cte_tesorer_id` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `ctacte_cheques_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id2_foreign` FOREIGN KEY (`cta_cte_cliente_id2`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `ctacte_cheques_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id2_foreign` FOREIGN KEY (`nf_cta_cte_id2`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_cheques`
--

LOCK TABLES `ctacte_cheques` WRITE;
/*!40000 ALTER TABLE `ctacte_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_centrocosto`
--

DROP TABLE IF EXISTS `ctactegastos_centrocosto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_centrocosto` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_centrocosto`
--

LOCK TABLES `ctactegastos_centrocosto` WRITE;
/*!40000 ALTER TABLE `ctactegastos_centrocosto` DISABLE KEYS */;
INSERT INTO `ctactegastos_centrocosto` VALUES (1,NULL,'OFICINA',NULL,NULL,NULL),(2,NULL,'FIJO',NULL,NULL,NULL),(3,NULL,'VARIABLE',NULL,NULL,NULL),(4,NULL,'GISELA',NULL,NULL,NULL),(5,NULL,'LIA',NULL,NULL,NULL),(6,NULL,'PADRES',NULL,NULL,NULL),(7,NULL,'CASA',NULL,NULL,NULL),(8,NULL,'VANESA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_centrocosto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_cuenta_tipo`
--

DROP TABLE IF EXISTS `ctactegastos_cuenta_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_cuenta_tipo` (
  `idCuentaTipo` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `idTipo` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idCuentaTipo`),
  KEY `ctactegastos_cuenta_tipo_idtipo_foreign` (`idTipo`),
  KEY `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_idtipo_foreign` FOREIGN KEY (`idTipo`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_cuenta_tipo`
--

LOCK TABLES `ctactegastos_cuenta_tipo` WRITE;
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` DISABLE KEYS */;
INSERT INTO `ctactegastos_cuenta_tipo` VALUES (1,NULL,NULL,3,NULL,NULL,NULL),(2,NULL,NULL,6,NULL,NULL,NULL),(3,NULL,NULL,3,NULL,NULL,NULL),(4,NULL,NULL,4,NULL,NULL,NULL),(5,NULL,NULL,5,NULL,NULL,NULL),(6,NULL,NULL,3,NULL,NULL,NULL),(7,NULL,NULL,4,NULL,NULL,NULL),(8,NULL,NULL,3,NULL,NULL,NULL),(9,NULL,NULL,4,NULL,NULL,NULL),(10,NULL,NULL,7,NULL,NULL,NULL),(11,NULL,NULL,8,NULL,NULL,NULL),(12,NULL,NULL,3,NULL,NULL,NULL),(13,NULL,NULL,3,NULL,NULL,NULL),(14,NULL,NULL,4,NULL,NULL,NULL),(15,NULL,NULL,1,NULL,NULL,NULL),(16,NULL,NULL,2,NULL,NULL,NULL),(17,NULL,NULL,5,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_mensuales`
--

DROP TABLE IF EXISTS `ctactegastos_mensuales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_mensuales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `CuentaTipo_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `TipoDeGasto_id` int(10) unsigned NOT NULL,
  `CentroCosto_id` int(10) unsigned NOT NULL,
  `gasto_cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `monto` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctactegastos_mensuales_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `ctactegastos_mensuales_tipodegasto_id_foreign` (`TipoDeGasto_id`),
  KEY `ctactegastos_mensuales_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` (`gasto_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_mensuales_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`gasto_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_tipodegasto_id_foreign` FOREIGN KEY (`TipoDeGasto_id`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_mensuales`
--

LOCK TABLES `ctactegastos_mensuales` WRITE;
/*!40000 ALTER TABLE `ctactegastos_mensuales` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctactegastos_mensuales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_tiposdegastos`
--

DROP TABLE IF EXISTS `ctactegastos_tiposdegastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_tiposdegastos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_tiposdegastos`
--

LOCK TABLES `ctactegastos_tiposdegastos` WRITE;
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` DISABLE KEYS */;
INSERT INTO `ctactegastos_tiposdegastos` VALUES (1,NULL,'Oficina',NULL,NULL,NULL),(2,NULL,'Personales',NULL,NULL,NULL),(3,NULL,'Tarjeta VISA',NULL,NULL,NULL),(4,NULL,'Tarjeta Mastercard',NULL,NULL,NULL),(5,NULL,'Debito Automatico',NULL,NULL,NULL),(6,NULL,'American Express',NULL,NULL,NULL),(7,NULL,'Tarjeta Shopping',NULL,NULL,NULL),(8,NULL,'Tarjeta Cencosud',NULL,NULL,NULL),(9,NULL,'Tarjeta Coto',NULL,NULL,NULL),(10,NULL,'Tarjeta Nativa',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha` date DEFAULT NULL,
  `hora` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profesor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cant_clases` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjuntos` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_zoom` longtext COLLATE utf8mb4_unicode_ci,
  `cod_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contraseña_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_youtube` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `materiales` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos_detail`
--

DROP TABLE IF EXISTS `cursos_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `curso_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cursos_detail_curso_id_foreign` (`curso_id`),
  CONSTRAINT `cursos_detail_curso_id_foreign` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos_detail`
--

LOCK TABLES `cursos_detail` WRITE;
/*!40000 ALTER TABLE `cursos_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_types`
--

DROP TABLE IF EXISTS `data_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data_types_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_types`
--

LOCK TABLES `data_types` WRITE;
/*!40000 ALTER TABLE `data_types` DISABLE KEYS */;
INSERT INTO `data_types` VALUES (1,'Comprobantes XLS',1,'Importación','XLS','data/imports/receipts/xls',NULL,NULL),(2,'CITI-Ventas',1,'Importación','TXT','data/imports/receipts/CitiVentas',NULL,NULL),(3,'CITI Compras',2,'Exportación','TXT','data/exports/receipts/citi',NULL,NULL),(4,'CITI Ventas',2,'Exportación','TXT','data/exports/receipts/CitiVentasExport',NULL,NULL),(5,'Convenio Multilateral',2,'Exportación','TXT','data/exports/receipts/convenio',NULL,NULL),(6,'Libro IVA Digital',2,'Exportación','TXT','data/exports/receipts/libro_iva_digital',NULL,'2019-11-20 21:43:44'),(7,'Mis Comprobantes',1,'Importacion','','data/imports/receipts/mis_comprobantes',NULL,NULL),(8,'Consulta AFIP',3,'AFIP','','data/afip/index','2019-12-06 14:49:55','2019-12-06 14:49:55');
/*!40000 ALTER TABLE `data_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_estados`
--

DROP TABLE IF EXISTS `dc_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_estados` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_estados`
--

LOCK TABLES `dc_estados` WRITE;
/*!40000 ALTER TABLE `dc_estados` DISABLE KEYS */;
INSERT INTO `dc_estados` VALUES (1,NULL,'BORRADOR',1,NULL,'2023-08-07 00:00:26',NULL),(2,NULL,'TERMINADO',1,NULL,'2023-08-07 00:00:26',NULL),(3,NULL,'ELIMINADO',1,NULL,'2023-08-13 09:18:22',NULL),(4,NULL,'PAGADO',1,NULL,'2023-08-07 00:00:26','2023-08-07 00:00:26'),(5,NULL,'CONCILIADO',1,NULL,'2023-08-07 00:00:26','2023-08-07 00:00:26');
/*!40000 ALTER TABLE `dc_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas`
--

DROP TABLE IF EXISTS `dc_firmas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_firmante_dc` tinyint(1) NOT NULL DEFAULT '0',
  `show_create_dc` tinyint(1) NOT NULL DEFAULT '0',
  `faltan_firmas` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas`
--

LOCK TABLES `dc_firmas` WRITE;
/*!40000 ALTER TABLE `dc_firmas` DISABLE KEYS */;
INSERT INTO `dc_firmas` VALUES (1,NULL,'NO',1,1,0,1,NULL,'2023-08-07 00:00:27',NULL),(2,NULL,'RECHAZADO',1,1,0,1,NULL,'2023-08-07 00:00:27',NULL),(3,NULL,'ACEPTADO',1,0,0,1,NULL,'2023-08-07 00:00:27',NULL),(4,NULL,'FALTAN FIRMAS',0,0,1,1,'2023-08-07 00:00:27','2023-08-07 00:00:27',NULL),(5,NULL,'EMITIDO',1,0,0,1,'2023-10-12 08:08:16','2023-10-12 08:08:16',NULL);
/*!40000 ALTER TABLE `dc_firmas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_ordenes`
--

DROP TABLE IF EXISTS `dc_firmas_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `user_id_que_firma` int(10) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_firmas_ordenes_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_firmas_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `dc_firmas_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_firmas_ordenes_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_ordenes`
--

LOCK TABLES `dc_firmas_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_firmas_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_firmas_reglas`
--

DROP TABLE IF EXISTS `dc_firmas_reglas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_firmas_reglas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL,
  `grupos_users_ids` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_firmas_reglas_person_id_foreign` (`person_id`),
  KEY `dc_firmas_reglas_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_firmas_reglas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_firmas_reglas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_firmas_reglas`
--

LOCK TABLES `dc_firmas_reglas` WRITE;
/*!40000 ALTER TABLE `dc_firmas_reglas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_firmas_reglas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago`
--

DROP TABLE IF EXISTS `dc_orden_de_pago`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-09-28 16:31:53',
  `dc_orden_id` bigint(20) unsigned NOT NULL DEFAULT '10',
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_person_id_foreign` (`person_id`),
  KEY `dc_orden_de_pago_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_orden_de_pago_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_orden_de_pago_dc_firma_id_foreign` (`dc_firma_id`),
  KEY `dc_orden_de_pago_dc_estado_id_foreign` (`dc_estado_id`),
  CONSTRAINT `dc_orden_de_pago_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_orden_de_pago_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_orden_de_pago_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_orden_de_pago_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_orden_de_pago_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago`
--

LOCK TABLES `dc_orden_de_pago` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago_cheques`
--

DROP TABLE IF EXISTS `dc_orden_de_pago_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago_cheques` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_de_pago_id` bigint(20) unsigned NOT NULL,
  `ctacte_cheque_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_cheques_dc_orden_de_pago_id_foreign` (`dc_orden_de_pago_id`),
  KEY `dc_orden_de_pago_cheques_ctacte_cheque_id_foreign` (`ctacte_cheque_id`),
  CONSTRAINT `dc_orden_de_pago_cheques_ctacte_cheque_id_foreign` FOREIGN KEY (`ctacte_cheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `dc_orden_de_pago_cheques_dc_orden_de_pago_id_foreign` FOREIGN KEY (`dc_orden_de_pago_id`) REFERENCES `dc_orden_de_pago` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago_cheques`
--

LOCK TABLES `dc_orden_de_pago_cheques` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_de_pago_receipts`
--

DROP TABLE IF EXISTS `dc_orden_de_pago_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_de_pago_receipts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_de_pago_id` bigint(20) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_de_pago_receipts_dc_orden_de_pago_id_foreign` (`dc_orden_de_pago_id`),
  KEY `dc_orden_de_pago_receipts_receipt_id_foreign` (`receipt_id`),
  CONSTRAINT `dc_orden_de_pago_receipts_dc_orden_de_pago_id_foreign` FOREIGN KEY (`dc_orden_de_pago_id`) REFERENCES `dc_orden_de_pago` (`id`),
  CONSTRAINT `dc_orden_de_pago_receipts_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_de_pago_receipts`
--

LOCK TABLES `dc_orden_de_pago_receipts` WRITE;
/*!40000 ALTER TABLE `dc_orden_de_pago_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_de_pago_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_orden_files`
--

DROP TABLE IF EXISTS `dc_orden_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_orden_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `file` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_orden_files_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_orden_files_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_orden_files`
--

LOCK TABLES `dc_orden_files` WRITE;
/*!40000 ALTER TABLE `dc_orden_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_orden_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes`
--

DROP TABLE IF EXISTS `dc_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `sucursal` int(11) NOT NULL DEFAULT '1',
  `numero` int(11) NOT NULL,
  `sector` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `solicitante` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `fecha_entrega` date DEFAULT NULL,
  `fecha_asignacion` datetime DEFAULT NULL,
  `fecha_cumplido` datetime DEFAULT NULL,
  `condicion_venta_id` int(10) unsigned DEFAULT NULL,
  `is_pago_adelantado` tinyint(1) DEFAULT NULL,
  `forma_de_entrega_id` int(10) unsigned DEFAULT NULL,
  `plazo_de_pago_id` int(10) unsigned DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(16,2) NOT NULL DEFAULT '1.00',
  `neto` decimal(16,2) NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `total` decimal(16,2) NOT NULL,
  `facturada` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_cc_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `is_multiples_ot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `is_completado` tinyint(1) NOT NULL DEFAULT '0',
  `dc_firma_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  KEY `dc_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_ordenes_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `dc_ordenes_conta_cc_id_foreign` (`conta_cc_id`),
  KEY `dc_ordenes_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `dc_ordenes_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  KEY `dc_ordenes_moneda_id_foreign` (`moneda_id`),
  KEY `dc_ordenes_dc_firma_id_foreign` (`dc_firma_id`),
  KEY `dc_ordenes_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `dc_ordenes_conta_cc_id_foreign` FOREIGN KEY (`conta_cc_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `dc_ordenes_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_ordenes_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`),
  CONSTRAINT `dc_ordenes_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `dc_ordenes_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `dc_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes`
--

LOCK TABLES `dc_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_compra_coti`
--

DROP TABLE IF EXISTS `dc_ordenes_compra_coti`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_compra_coti` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_coti_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_compra_coti_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_compra_coti_dc_orden_coti_id_foreign` (`dc_orden_coti_id`),
  CONSTRAINT `dc_ordenes_compra_coti_dc_orden_coti_id_foreign` FOREIGN KEY (`dc_orden_coti_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_compra_coti_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_compra_coti`
--

LOCK TABLES `dc_ordenes_compra_coti` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_compra_coti` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_compra_coti` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_compra_req`
--

DROP TABLE IF EXISTS `dc_ordenes_compra_req`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_compra_req` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_compra_req_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_compra_req_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_id_foreign` (`dc_orden_req_id`),
  KEY `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` (`dc_orden_req_detail_id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_detail_id_foreign` FOREIGN KEY (`dc_orden_req_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_compra_req_dc_orden_req_id_foreign` FOREIGN KEY (`dc_orden_req_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_compra_req`
--

LOCK TABLES `dc_ordenes_compra_req` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_compra_req` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_cotizacion_req`
--

DROP TABLE IF EXISTS `dc_ordenes_cotizacion_req`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_cotizacion_req` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_id` bigint(20) unsigned NOT NULL,
  `dc_orden_req_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_req_id_foreign` (`dc_orden_req_id`),
  KEY `dc_ordenes_cotizacion_req_dc_orden_req_detail_id_foreign` (`dc_orden_req_detail_id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_req_detail_id_foreign` FOREIGN KEY (`dc_orden_req_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_cotizacion_req_dc_orden_req_id_foreign` FOREIGN KEY (`dc_orden_req_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_cotizacion_req`
--

LOCK TABLES `dc_ordenes_cotizacion_req` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_cotizacion_req` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_cotizacion_req` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_details`
--

DROP TABLE IF EXISTS `dc_ordenes_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_origen_destino_id` bigint(20) unsigned DEFAULT NULL,
  `origendestinoable_id` int(10) unsigned DEFAULT NULL,
  `origendestinoable_type` text COLLATE utf8mb4_unicode_ci,
  `cantidades` decimal(16,2) NOT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id_destino` bigint(20) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `neto` decimal(16,2) NOT NULL,
  `desc_porc` decimal(16,2) DEFAULT NULL,
  `descuento` decimal(16,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `subtotal` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_details_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `dc_ordenes_details_system_tax_id_foreign` (`system_tax_id`),
  KEY `dc_ordenes_details_inv_producto_id_destino_foreign` (`inv_producto_id_destino`),
  KEY `dc_ordenes_details_dc_orden_origen_destino_id_foreign` (`dc_orden_origen_destino_id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_origen_destino_id_foreign` FOREIGN KEY (`dc_orden_origen_destino_id`) REFERENCES `dc_ordenes_origen_destino` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_destino_foreign` FOREIGN KEY (`inv_producto_id_destino`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_details`
--

LOCK TABLES `dc_ordenes_details` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_facturada`
--

DROP TABLE IF EXISTS `dc_ordenes_facturada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_facturada` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `dc_orden_id` bigint(20) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_facturada_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_facturada_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_facturada_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `dc_ordenes_facturada_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_facturada_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `dc_ordenes_facturada_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_facturada`
--

LOCK TABLES `dc_ordenes_facturada` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_facturada` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_facturada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_ingreso_compra`
--

DROP TABLE IF EXISTS `dc_ordenes_ingreso_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_ingreso_compra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  KEY `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` (`dc_orden_compra_detail_id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_detail_id_foreign` FOREIGN KEY (`dc_orden_compra_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_ingreso_compra_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_ingreso_compra`
--

LOCK TABLES `dc_ordenes_ingreso_compra` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_ingreso_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_origen_destino`
--

DROP TABLE IF EXISTS `dc_ordenes_origen_destino`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_origen_destino` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `modelo` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_deposito` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_origen_destino`
--

LOCK TABLES `dc_ordenes_origen_destino` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` DISABLE KEYS */;
INSERT INTO `dc_ordenes_origen_destino` VALUES (1,NULL,'Orden de Trabajo','App\\Models\\Inventario\\InvOrdenTrabajo',0,1,NULL,NULL,NULL),(2,NULL,'Centro de Costos','App\\Models\\Inventario\\InvOrdenTrabajoHorasTipo',0,1,NULL,'2023-09-12 22:21:06',NULL),(3,NULL,'Deposito','App\\Models\\Inventario\\InvDeposito',1,1,NULL,'2024-05-07 20:13:54',NULL),(4,NULL,'Empleado','App\\Models\\SyJEmpleado',0,0,NULL,'2023-07-03 22:10:43',NULL);
/*!40000 ALTER TABLE `dc_ordenes_origen_destino` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_revocadas`
--

DROP TABLE IF EXISTS `dc_ordenes_revocadas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_revocadas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `comentario` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_revocadas_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `dc_ordenes_revocadas_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_revocadas`
--

LOCK TABLES `dc_ordenes_revocadas` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_revocadas` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_revocadas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_servicio_compra`
--

DROP TABLE IF EXISTS `dc_ordenes_servicio_compra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_servicio_compra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_id` bigint(20) unsigned NOT NULL,
  `dc_orden_compra_detail_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_compra_id_foreign` (`dc_orden_compra_id`),
  KEY `dc_ordenes_servicio_compra_dc_orden_compra_detail_id_foreign` (`dc_orden_compra_detail_id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_compra_detail_id_foreign` FOREIGN KEY (`dc_orden_compra_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_compra_id_foreign` FOREIGN KEY (`dc_orden_compra_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `dc_ordenes_servicio_compra_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_servicio_compra`
--

LOCK TABLES `dc_ordenes_servicio_compra` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_servicio_compra` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_servicio_compra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_tipos`
--

DROP TABLE IF EXISTS `dc_ordenes_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `usabilidad` longtext COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_tipos`
--

LOCK TABLES `dc_ordenes_tipos` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_tipos` DISABLE KEYS */;
INSERT INTO `dc_ordenes_tipos` VALUES (1,NULL,'ORDEN DE COMPRAS',NULL,1,NULL,'2022-10-29 18:50:08',NULL),(2,NULL,'ORDEN DE VENTAS',NULL,1,NULL,'2022-10-29 18:50:08',NULL),(3,NULL,'PRESUPUESTO',NULL,1,NULL,NULL,NULL),(4,NULL,'REQUERIMIENTO',NULL,1,NULL,NULL,NULL),(5,NULL,'REMITO DE INGRESO',NULL,1,NULL,'2023-06-12 23:29:24',NULL),(6,NULL,'REMITO DE EGRESO',NULL,1,NULL,NULL,NULL),(7,NULL,'REMITO INTERNO',NULL,1,NULL,NULL,NULL),(8,NULL,'REMITO DE INGRESO','Es lo mismo que un remito de ingreso, \n        pero los productosa ingresar provienen de una Orden de Compra',1,NULL,NULL,NULL),(9,NULL,'REMITO DE SERVICIO','Es un remito de Ingreso de un servicio que se\n        asigna directo a una OT',1,NULL,NULL,NULL),(10,NULL,'ORDEN DE PAGO',NULL,1,'2023-09-28 16:31:53','2023-09-28 16:31:53',NULL),(11,NULL,'ANULACION REQUERIMIENTOS',NULL,1,'2024-04-02 23:12:31','2024-04-02 23:12:31',NULL),(12,NULL,'ANULACION COMPRAS PRODUCTOS',NULL,1,'2024-04-02 23:12:31','2024-04-02 23:12:31',NULL),(13,NULL,'ANULACION COMPRAS SERVICIOS',NULL,1,'2024-04-02 23:12:31','2024-04-02 23:12:31',NULL),(14,NULL,'REMITO DE GASTO',NULL,1,'2024-05-07 20:13:54','2024-05-07 20:13:54',NULL),(15,NULL,'COTIZACIONES',NULL,1,'2024-06-26 07:59:40','2024-06-26 07:59:40',NULL);
/*!40000 ALTER TABLE `dc_ordenes_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deudas_impositivas`
--

DROP TABLE IF EXISTS `deudas_impositivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deudas_impositivas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `vto_impuesto_id` int(10) unsigned NOT NULL,
  `periodo_deuda` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deudas_impositivas_vto_impuesto_id_foreign` (`vto_impuesto_id`),
  KEY `deudas_impositivas_person_id_foreign` (`person_id`),
  CONSTRAINT `deudas_impositivas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `deudas_impositivas_vto_impuesto_id_foreign` FOREIGN KEY (`vto_impuesto_id`) REFERENCES `vto_impuestos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deudas_impositivas`
--

LOCK TABLES `deudas_impositivas` WRITE;
/*!40000 ALTER TABLE `deudas_impositivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `deudas_impositivas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ejer_anteriores`
--

DROP TABLE IF EXISTS `ejer_anteriores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ejer_anteriores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `anio` int(11) NOT NULL,
  `ventas` decimal(16,2) DEFAULT NULL,
  `compras` decimal(16,2) DEFAULT NULL,
  `sueldos` decimal(16,2) DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `apagar` decimal(16,2) DEFAULT NULL,
  `afavor` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ejer_anteriores_person_id_foreign` (`person_id`),
  CONSTRAINT `ejer_anteriores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ejer_anteriores`
--

LOCK TABLES `ejer_anteriores` WRITE;
/*!40000 ALTER TABLE `ejer_anteriores` DISABLE KEYS */;
/*!40000 ALTER TABLE `ejer_anteriores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_civil`
--

DROP TABLE IF EXISTS `estado_civil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estado_civil` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `estado_civil_descripcion_unique` (`descripcion`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_civil`
--

LOCK TABLES `estado_civil` WRITE;
/*!40000 ALTER TABLE `estado_civil` DISABLE KEYS */;
INSERT INTO `estado_civil` VALUES (1,NULL,'Separado Legal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,'Separado de Hecho',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,'Divorciado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,'Convivencia',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,'Soltero',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,'Casado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,'Viudo',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `estado_civil` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva`
--

DROP TABLE IF EXISTS `fa_masiva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva`
--

LOCK TABLES `fa_masiva` WRITE;
/*!40000 ALTER TABLE `fa_masiva` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_detalle`
--

DROP TABLE IF EXISTS `fa_masiva_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_detalle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fa_masiva_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL DEFAULT '22',
  `activity_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `concepto_id` int(10) unsigned NOT NULL DEFAULT '1',
  `taxable_iibb` int(10) unsigned NOT NULL DEFAULT '2',
  `renglon1` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe1` decimal(20,2) DEFAULT NULL,
  `renglon2` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe2` decimal(20,2) DEFAULT NULL,
  `renglon3` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe3` decimal(20,2) DEFAULT NULL,
  `punto_venta_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date DEFAULT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_detalle_concepto_id_foreign` (`concepto_id`),
  KEY `fa_masiva_detalle_system_tax_id_foreign` (`system_tax_id`),
  KEY `fa_masiva_detalle_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fa_masiva_detalle_zone_id_foreign` (`zone_id`),
  KEY `fa_masiva_detalle_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fa_masiva_detalle_activity_id_foreign` (`activity_id`),
  CONSTRAINT `fa_masiva_detalle_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`),
  CONSTRAINT `fa_masiva_detalle_concepto_id_foreign` FOREIGN KEY (`concepto_id`) REFERENCES `fact_elec_conceptos_afip` (`id`),
  CONSTRAINT `fa_masiva_detalle_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `fac_elec_cond_frente_iva` (`id`),
  CONSTRAINT `fa_masiva_detalle_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`),
  CONSTRAINT `fa_masiva_detalle_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`),
  CONSTRAINT `fa_masiva_detalle_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_detalle`
--

LOCK TABLES `fa_masiva_detalle` WRITE;
/*!40000 ALTER TABLE `fa_masiva_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_stock`
--

DROP TABLE IF EXISTS `fa_masiva_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_stock_person_id_foreign` (`person_id`),
  KEY `fa_masiva_stock_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `fa_masiva_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fa_masiva_stock_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_stock`
--

LOCK TABLES `fa_masiva_stock` WRITE;
/*!40000 ALTER TABLE `fa_masiva_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_cond_frente_iva`
--

DROP TABLE IF EXISTS `fac_elec_cond_frente_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_cond_frente_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_cond_frente_iva_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_cond_frente_iva`
--

LOCK TABLES `fac_elec_cond_frente_iva` WRITE;
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` DISABLE KEYS */;
INSERT INTO `fac_elec_cond_frente_iva` VALUES (1,'IVA Responsable Inscripto','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'IVA Sujeto Exento','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Consumidor Final','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Responsable Monotributo','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Proveedor del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Cliente del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'IVA Liberado - Ley Nº 19.640','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'IVA Responsable Inscripto - Agente de Percepción','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Monotributista Social','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'IVA No Alcanzado','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_unidad_medidas`
--

DROP TABLE IF EXISTS `fac_elec_unidad_medidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_unidad_medidas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_unidad_medidas_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_unidad_medidas`
--

LOCK TABLES `fac_elec_unidad_medidas` WRITE;
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` DISABLE KEYS */;
INSERT INTO `fac_elec_unidad_medidas` VALUES (1,'Grs','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'Kg','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Mts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Mts2','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Mts3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Lts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'1000 Kwh','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'Unidades','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Pares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'Doc','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(11,'Quilates','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(12,'Millares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(13,'Milimetros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(14,'Mm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(15,'Km','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(16,'Hectolitros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(17,'Cm','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(18,'Cm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_conceptos_afip`
--

DROP TABLE IF EXISTS `fact_elec_conceptos_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_conceptos_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_comprobante_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_conceptos_afip`
--

LOCK TABLES `fact_elec_conceptos_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_conceptos_afip` VALUES (1,1,'Producto','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'Productos y Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` int(10) unsigned NOT NULL,
  `other_tax_id` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_other_tax_id_foreign` (`other_tax_id`),
  CONSTRAINT `fact_elec_perc_ret_other_tax_id_foreign` FOREIGN KEY (`other_tax_id`) REFERENCES `other_taxes` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret`
--

LOCK TABLES `fact_elec_perc_ret` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret` DISABLE KEYS */;
INSERT INTO `fact_elec_perc_ret` VALUES (1,NULL,'Per./Ret de Imp. a las Ganancias',1,1032,1,NULL,NULL,NULL),(2,NULL,'Per./Ret de IVA',1,1000,1,NULL,NULL,NULL),(3,NULL,'Per./Ret de IIBB',2,1006,1,NULL,NULL,NULL),(4,NULL,'Impuestos Internos',4,1001,1,NULL,NULL,NULL),(5,NULL,'Impuestos Municipales',3,1031,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `fact_elec_perc_ret` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_perc_ret_details`
--

DROP TABLE IF EXISTS `fact_elec_perc_ret_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_perc_ret_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_perc_ret_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `detalle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(10) unsigned DEFAULT NULL,
  `base_imponible` decimal(16,2) DEFAULT NULL,
  `alicuota` decimal(16,2) DEFAULT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` (`fact_elec_perc_ret_id`),
  KEY `fact_elec_perc_ret_details_person_id_foreign` (`person_id`),
  KEY `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_perc_ret_details_zone_id_foreign` (`zone_id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_perc_ret_id_foreign` FOREIGN KEY (`fact_elec_perc_ret_id`) REFERENCES `fact_elec_perc_ret` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_perc_ret_details_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_perc_ret_details`
--

LOCK TABLES `fact_elec_perc_ret_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_perc_ret_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_puntos_venta`
--

DROP TABLE IF EXISTS `fact_elec_puntos_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_puntos_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `direccion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '0000',
  `codigo_postal` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_puntos_venta_person_id_foreign` (`person_id`),
  CONSTRAINT `fact_elec_puntos_venta_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_puntos_venta`
--

LOCK TABLES `fact_elec_puntos_venta` WRITE;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipt_details`
--

DROP TABLE IF EXISTS `fact_elec_receipt_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipt_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cantidad` decimal(20,2) NOT NULL,
  `unidad_medida` text COLLATE utf8mb4_unicode_ci,
  `precio_unitario` decimal(20,2) NOT NULL,
  `neto_gravado` decimal(20,2) NOT NULL,
  `bonificacion_porcentaje` decimal(20,2) DEFAULT NULL,
  `bonificacion_monto` decimal(20,2) DEFAULT NULL,
  `bonificacion_subtotal` decimal(20,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `iva_monto` decimal(20,2) DEFAULT NULL,
  `iva_subtotal` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `codigo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipt_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_receipt_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `fact_elec_receipt_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_receipt_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipt_details`
--

LOCK TABLES `fact_elec_receipt_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipt_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipt_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipts`
--

DROP TABLE IF EXISTS `fact_elec_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date NOT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `concepto_id` int(10) unsigned NOT NULL,
  `punto_venta_id` int(10) unsigned NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL,
  `condiciones_venta` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobante_asoc` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cae` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cae_vencimiento` date DEFAULT NULL,
  `nro_comprobante_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_proceso_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_receptor` int(10) unsigned NOT NULL,
  `condicion_venta_id` int(11) DEFAULT NULL,
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opcion_transferencia` longtext COLLATE utf8mb4_unicode_ci,
  `referencia` text COLLATE utf8mb4_unicode_ci,
  `alias_cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_otros_tributos` decimal(16,2) DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipts_user_id_foreign` (`user_id`),
  KEY `fact_elec_receipts_punto_venta_id_foreign` (`punto_venta_id`),
  KEY `fact_elec_receipts_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fact_elec_receipts_person_id_foreign` (`person_id`),
  KEY `fact_elec_receipts_person_id_receptor_foreign` (`person_id_receptor`),
  KEY `fact_elec_receipts_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fact_elec_receipts_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `fact_elec_receipts_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `condicion_frente_al_iva` (`id`),
  CONSTRAINT `fact_elec_receipts_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_receptor_foreign` FOREIGN KEY (`person_id_receptor`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_punto_venta_id_foreign` FOREIGN KEY (`punto_venta_id`) REFERENCES `fact_elec_puntos_venta` (`id`),
  CONSTRAINT `fact_elec_receipts_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipts`
--

LOCK TABLES `fact_elec_receipts` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_tipos_docs_afip`
--

DROP TABLE IF EXISTS `fact_elec_tipos_docs_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_tipos_docs_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_tipo_doc_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_tipos_docs_afip`
--

LOCK TABLES `fact_elec_tipos_docs_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_tipos_docs_afip` VALUES (1,1,'CI Buenos Aires','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'CI Catamarca','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'CI Córdoba','2019-03-13 13:29:34','2019-03-13 13:29:34'),(4,4,'CI Corrientes','2019-03-13 13:29:34','2019-03-13 13:29:34'),(5,5,'CI Entre Ríos','2019-03-13 13:29:34','2019-03-13 13:29:34'),(6,6,'CI Jujuy','2019-03-13 13:29:34','2019-03-13 13:29:34'),(7,7,'CI Mendoza','2019-03-13 13:29:34','2019-03-13 13:29:34'),(8,8,'CI La Rioja','2019-03-13 13:29:34','2019-03-13 13:29:34'),(9,9,'CI Salta','2019-03-13 13:29:34','2019-03-13 13:29:34'),(10,10,'CI San Juan','2019-03-13 13:29:34','2019-03-13 13:29:34'),(11,11,'CI San Luis','2019-03-13 13:29:34','2019-03-13 13:29:34'),(12,12,'CI Santa Fe','2019-03-13 13:29:34','2019-03-13 13:29:34'),(13,13,'CI Santiago del Estero','2019-03-13 13:29:34','2019-03-13 13:29:34'),(14,14,'CI Tucumán','2019-03-13 13:29:34','2019-03-13 13:29:34'),(16,16,'CI Chaco','2019-03-13 13:29:34','2019-03-13 13:29:34'),(17,17,'CI Chubut','2019-03-13 13:29:34','2019-03-13 13:29:34'),(18,18,'CI Formosa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(19,19,'CI Misiones','2019-03-13 13:29:34','2019-03-13 13:29:34'),(20,20,'CI Neuquén','2019-03-13 13:29:34','2019-03-13 13:29:34'),(21,21,'CI La Pampa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(22,22,'CI Río Negro','2019-03-13 13:29:34','2019-03-13 13:29:34'),(23,23,'CI Santa Cruz','2019-03-13 13:29:34','2019-03-13 13:29:34'),(24,24,'CI Tierra del Fuego','2019-03-13 13:29:34','2019-03-13 13:29:34'),(80,80,'CUIT','2019-03-13 13:29:34','2019-03-13 13:29:34'),(86,86,'CUIL','2019-03-13 13:29:34','2019-03-13 13:29:34'),(87,87,'CDI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(89,89,'LE','2019-03-13 13:29:34','2019-03-13 13:29:34'),(90,90,'LC','2019-03-13 13:29:34','2019-03-13 13:29:34'),(91,91,'CI Extranjera','2019-03-13 13:29:34','2019-03-13 13:29:34'),(92,92,'en trámite','2019-03-13 13:29:34','2019-03-13 13:29:34'),(93,93,'Acta Nacimiento','2019-03-13 13:29:34','2019-03-13 13:29:34'),(94,94,'Pasaporte','2019-03-13 13:29:34','2019-03-13 13:29:34'),(95,95,'CI Bs. As. RNP','2019-03-13 13:29:34','2019-03-13 13:29:34'),(96,96,'DNI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(97,0,'CI Policía Federal','2019-03-13 13:29:34','2019-03-13 13:29:34'),(99,99,'Doc. (Otro)','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
INSERT INTO `failed_jobs` VALUES (1,NULL,'database','finance','{\"uuid\":\"a52229c2-02e9-4f80-80a1-ecf9ba329954\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":4:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:55:\\\"\\\\App\\\\Http\\\\Controllers\\\\Data\\\\BOTMisComprobantesController\\\";s:6:\\\"metodo\\\";s:21:\\\"Execute_Bot_Descargar\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":11:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:10:\\\"\\u0000*\\u0000appends\\\";a:1:{i:0;s:24:\\\"usuario_madre_habilitado\\\";}s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:8019;s:6:\\\"nombre\\\";s:20:\\\"Garcia Marco Esteban\\\";s:9:\\\"loginUser\\\";s:27:\\\"estudiogarcia.nqn@gmail.com\\\";s:9:\\\"emailUser\\\";s:27:\\\"estudiogarcia.nqn@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"23261441799\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$qL65YyX\\/UFYgHMwgCmg2N.REyVN4bfYHG2NaL3f6FrrgEH8fE2LZa\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-10-29 18:49:42\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-10-29 18:49:42\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:56490;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:20:\\\"Garcia Marco Esteban\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"23-26144179-9\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-10-25 13:16:17\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-10-25 13:16:17\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:56490;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:20:\\\"Garcia Marco Esteban\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"23-26144179-9\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-10-25 13:16:17\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-10-25 13:16:17\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:8019;s:6:\\\"nombre\\\";s:20:\\\"Garcia Marco Esteban\\\";s:9:\\\"loginUser\\\";s:27:\\\"estudiogarcia.nqn@gmail.com\\\";s:9:\\\"emailUser\\\";s:27:\\\"estudiogarcia.nqn@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"23261441799\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$qL65YyX\\/UFYgHMwgCmg2N.REyVN4bfYHG2NaL3f6FrrgEH8fE2LZa\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-10-29 18:49:42\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-10-29 18:49:42\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:15:\\\"cuit_user_admin\\\";s:15:\\\"\'23-26144179-9\'\\\";s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"23261441799\\\";s:12:\\\"clave_fiscal\\\";s:10:\\\"Marcos2025\\\";s:12:\\\"cuit_empresa\\\";s:13:\\\"23-26144179-9\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:9:\\\"operacion\\\";s:8:\\\"Emitidos\\\";s:7:\\\"periodo\\\";s:10:\\\"Mes Pasado\\\";s:12:\\\"path_of_file\\\";O:21:\\\"App\\\\Models\\\\PathOfFile\\\":28:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:12:\\\"path_of_file\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:6:{s:7:\\\"user_id\\\";i:8019;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:53:\\\"Garcia Marco Esteban Comprobantes Emitidos Mes Pasado\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-10-31 01:19:11\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-10-31 01:19:11\\\";s:2:\\\"id\\\";i:1;}s:11:\\\"\\u0000*\\u0000original\\\";a:6:{s:7:\\\"user_id\\\";i:8019;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:53:\\\"Garcia Marco Esteban Comprobantes Emitidos Mes Pasado\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-10-31 01:19:11\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-10-31 01:19:11\\\";s:2:\\\"id\\\";i:1;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:4:\\\"path\\\";s:14:\\\"23-26144179-9\\/\\\";}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/ImportarMisComprobantes.js 23261441799 Marcos2025 23-26144179-9 Emitidos \"Mes Pasado\" \'23-26144179-9\'\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Data/BOTMisComprobantesController.php(94): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Data\\BOTMisComprobantesController->Execute_Bot_Descargar(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'database\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-10-31 01:20:13',NULL);
INSERT INTO `failed_jobs` VALUES (2,NULL,'database','finance','{\"uuid\":\"d32f9d34-dd5b-4f2e-b725-0384329472b4\",\"displayName\":\"App\\\\Jobs\\\\QueueGenerica\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"delay\":null,\"timeout\":null,\"timeoutAt\":null,\"data\":{\"commandName\":\"App\\\\Jobs\\\\QueueGenerica\",\"command\":\"O:22:\\\"App\\\\Jobs\\\\QueueGenerica\\\":9:{s:28:\\\"\\u0000App\\\\Jobs\\\\QueueGenerica\\u0000data\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":4:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:11:\\\"controlador\\\";s:55:\\\"\\\\App\\\\Http\\\\Controllers\\\\Data\\\\BOTMisComprobantesController\\\";s:6:\\\"metodo\\\";s:21:\\\"Execute_Bot_Descargar\\\";s:9:\\\"variables\\\";O:29:\\\"Illuminate\\\\Support\\\\Collection\\\":11:{s:8:\\\"\\u0000*\\u0000items\\\";a:0:{}s:4:\\\"user\\\";O:8:\\\"App\\\\User\\\":28:{s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:8:\\\"\\u0000*\\u0000table\\\";s:6:\\\"tusers\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:6:\\\"idUser\\\";s:10:\\\"\\u0000*\\u0000appends\\\";a:1:{i:0;s:24:\\\"usuario_madre_habilitado\\\";}s:11:\\\"\\u0000*\\u0000fillable\\\";a:12:{i:0;s:6:\\\"nombre\\\";i:1;s:9:\\\"loginUser\\\";i:2;s:9:\\\"emailUser\\\";i:3;s:5:\\\"clave\\\";i:4;s:9:\\\"claveUser\\\";i:5;s:10:\\\"statusUser\\\";i:6;s:12:\\\"user_type_id\\\";i:7;s:5:\\\"firma\\\";i:8;s:15:\\\"suscrip_plan_id\\\";i:9;s:7:\\\"importe\\\";i:10;s:6:\\\"avatar\\\";i:11;s:18:\\\"es_empresa_externa\\\";}s:9:\\\"\\u0000*\\u0000hidden\\\";a:4:{i:0;s:8:\\\"password\\\";i:1;s:14:\\\"remember_token\\\";i:2;s:9:\\\"claveUser\\\";i:3;s:5:\\\"clave\\\";}s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:17:{s:6:\\\"idUser\\\";i:8019;s:6:\\\"nombre\\\";s:20:\\\"Garcia Marco Esteban\\\";s:9:\\\"loginUser\\\";s:27:\\\"estudiogarcia.nqn@gmail.com\\\";s:9:\\\"emailUser\\\";s:27:\\\"estudiogarcia.nqn@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"23261441799\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$qL65YyX\\/UFYgHMwgCmg2N.REyVN4bfYHG2NaL3f6FrrgEH8fE2LZa\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-10-29 18:49:42\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-10-29 18:49:42\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";s:6:\\\"person\\\";O:17:\\\"App\\\\Models\\\\Person\\\":27:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:7:\\\"persons\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:9:\\\"seguridad\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:0;s:13:\\\"\\u0000*\\u0000attributes\\\";a:21:{s:2:\\\"id\\\";i:56490;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:20:\\\"Garcia Marco Esteban\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"23-26144179-9\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-10-25 13:16:17\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-10-25 13:16:17\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:11:\\\"\\u0000*\\u0000original\\\";a:21:{s:2:\\\"id\\\";i:56490;s:7:\\\"user_id\\\";i:1;s:11:\\\"field_name1\\\";s:20:\\\"Garcia Marco Esteban\\\";s:11:\\\"field_name2\\\";N;s:13:\\\"document_type\\\";s:4:\\\"cuit\\\";s:8:\\\"document\\\";s:13:\\\"23-26144179-9\\\";s:21:\\\"cond_frente_al_iva_id\\\";N;s:10:\\\"country_id\\\";N;s:8:\\\"state_id\\\";N;s:7:\\\"zone_id\\\";N;s:14:\\\"plan_cuenta_id\\\";N;s:20:\\\"iva_creditos_tipo_id\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2021-10-25 13:16:17\\\";s:10:\\\"updated_at\\\";s:19:\\\"2021-10-25 13:16:17\\\";s:11:\\\"activity_id\\\";N;s:7:\\\"address\\\";N;s:14:\\\"person_type_id\\\";N;s:19:\\\"fa_iva_condition_id\\\";N;s:16:\\\"fa_codigo_postal\\\";N;s:5:\\\"email\\\";N;s:10:\\\"deleted_at\\\";N;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}}}s:11:\\\"\\u0000*\\u0000original\\\";a:16:{s:6:\\\"idUser\\\";i:8019;s:6:\\\"nombre\\\";s:20:\\\"Garcia Marco Esteban\\\";s:9:\\\"loginUser\\\";s:27:\\\"estudiogarcia.nqn@gmail.com\\\";s:9:\\\"emailUser\\\";s:27:\\\"estudiogarcia.nqn@gmail.com\\\";s:5:\\\"clave\\\";s:11:\\\"23261441799\\\";s:9:\\\"claveUser\\\";s:60:\\\"$2y$10$qL65YyX\\/UFYgHMwgCmg2N.REyVN4bfYHG2NaL3f6FrrgEH8fE2LZa\\\";s:5:\\\"firma\\\";N;s:6:\\\"avatar\\\";N;s:10:\\\"statusUser\\\";i:1;s:14:\\\"remember_token\\\";N;s:10:\\\"created_at\\\";s:19:\\\"2022-10-29 18:49:42\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-10-29 18:49:42\\\";s:12:\\\"user_type_id\\\";i:1;s:18:\\\"es_empresa_externa\\\";i:0;s:15:\\\"suscrip_plan_id\\\";i:1;s:7:\\\"importe\\\";s:4:\\\"0.00\\\";}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:0:{}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:10:\\\"\\u0000*\\u0000guarded\\\";a:1:{i:0;s:1:\\\"*\\\";}s:20:\\\"\\u0000*\\u0000rememberTokenName\\\";s:14:\\\"remember_token\\\";}s:15:\\\"cuit_user_admin\\\";s:15:\\\"\'23-26144179-9\'\\\";s:23:\\\"cuit_administrador_afip\\\";s:11:\\\"23261441799\\\";s:12:\\\"clave_fiscal\\\";s:10:\\\"Marcos2025\\\";s:12:\\\"cuit_empresa\\\";s:13:\\\"23-26144179-9\\\";s:5:\\\"sitio\\\";s:12:\\\"taxes.com.ar\\\";s:9:\\\"operacion\\\";s:8:\\\"Emitidos\\\";s:7:\\\"periodo\\\";s:8:\\\"Este Mes\\\";s:12:\\\"path_of_file\\\";O:21:\\\"App\\\\Models\\\\PathOfFile\\\":28:{s:10:\\\"\\u0000*\\u0000guarded\\\";a:0:{}s:8:\\\"\\u0000*\\u0000table\\\";s:12:\\\"path_of_file\\\";s:13:\\\"\\u0000*\\u0000connection\\\";s:7:\\\"finance\\\";s:13:\\\"\\u0000*\\u0000primaryKey\\\";s:2:\\\"id\\\";s:10:\\\"\\u0000*\\u0000keyType\\\";s:3:\\\"int\\\";s:12:\\\"incrementing\\\";b:1;s:7:\\\"\\u0000*\\u0000with\\\";a:0:{}s:12:\\\"\\u0000*\\u0000withCount\\\";a:0:{}s:10:\\\"\\u0000*\\u0000perPage\\\";i:15;s:6:\\\"exists\\\";b:1;s:18:\\\"wasRecentlyCreated\\\";b:1;s:13:\\\"\\u0000*\\u0000attributes\\\";a:6:{s:7:\\\"user_id\\\";i:8019;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:51:\\\"Garcia Marco Esteban Comprobantes Emitidos Este Mes\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-10-31 01:21:31\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-10-31 01:21:31\\\";s:2:\\\"id\\\";i:2;}s:11:\\\"\\u0000*\\u0000original\\\";a:6:{s:7:\\\"user_id\\\";i:8019;s:20:\\\"path_of_file_name_id\\\";i:6;s:11:\\\"descripcion\\\";s:51:\\\"Garcia Marco Esteban Comprobantes Emitidos Este Mes\\\";s:10:\\\"updated_at\\\";s:19:\\\"2022-10-31 01:21:31\\\";s:10:\\\"created_at\\\";s:19:\\\"2022-10-31 01:21:31\\\";s:2:\\\"id\\\";i:2;}s:10:\\\"\\u0000*\\u0000changes\\\";a:0:{}s:8:\\\"\\u0000*\\u0000casts\\\";a:0:{}s:17:\\\"\\u0000*\\u0000classCastCache\\\";a:0:{}s:8:\\\"\\u0000*\\u0000dates\\\";a:1:{i:0;s:10:\\\"deleted_at\\\";}s:13:\\\"\\u0000*\\u0000dateFormat\\\";N;s:10:\\\"\\u0000*\\u0000appends\\\";a:0:{}s:19:\\\"\\u0000*\\u0000dispatchesEvents\\\";a:0:{}s:14:\\\"\\u0000*\\u0000observables\\\";a:0:{}s:12:\\\"\\u0000*\\u0000relations\\\";a:0:{}s:10:\\\"\\u0000*\\u0000touches\\\";a:0:{}s:10:\\\"timestamps\\\";b:1;s:9:\\\"\\u0000*\\u0000hidden\\\";a:0:{}s:10:\\\"\\u0000*\\u0000visible\\\";a:0:{}s:11:\\\"\\u0000*\\u0000fillable\\\";a:0:{}s:16:\\\"\\u0000*\\u0000forceDeleting\\\";b:0;}s:4:\\\"path\\\";s:14:\\\"23-26144179-9\\/\\\";}}s:3:\\\"job\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";s:7:\\\"finance\\\";s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:5:\\\"delay\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}','Symfony\\Component\\Process\\Exception\\ProcessTimedOutException: The process \"node /home/forge/taxes.com.ar/resources/js/puppeteer/ImportarMisComprobantes.js 23261441799 Marcos2025 23-26144179-9 Emitidos \"Este Mes\" \'23-26144179-9\'\" exceeded the timeout of 60 seconds. in /home/forge/taxes.com.ar/vendor/symfony/process/Process.php:1213\nStack trace:\n#0 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(425): Symfony\\Component\\Process\\Process->checkTimeout()\n#1 /home/forge/taxes.com.ar/vendor/symfony/process/Process.php(249): Symfony\\Component\\Process\\Process->wait()\n#2 /home/forge/taxes.com.ar/app/Http/Controllers/Data/BOTMisComprobantesController.php(94): Symfony\\Component\\Process\\Process->run()\n#3 /home/forge/taxes.com.ar/app/Jobs/QueueGenerica.php(36): App\\Http\\Controllers\\Data\\BOTMisComprobantesController->Execute_Bot_Descargar(Object(Illuminate\\Support\\Collection))\n#4 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): App\\Jobs\\QueueGenerica->handle()\n#5 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#6 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#7 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#8 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#9 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(94): Illuminate\\Container\\Container->call(Array)\n#10 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#11 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#12 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Bus/Dispatcher.php(98): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#13 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(83): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(App\\Jobs\\QueueGenerica), false)\n#14 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(128): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#15 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Pipeline/Pipeline.php(103): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(App\\Jobs\\QueueGenerica))\n#16 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(85): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#17 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/CallQueuedHandler.php(59): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(App\\Queue\\DatabaseJob), Object(App\\Jobs\\QueueGenerica))\n#18 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Jobs/Job.php(98): Illuminate\\Queue\\CallQueuedHandler->call(Object(App\\Queue\\DatabaseJob), Array)\n#19 /home/forge/taxes.com.ar/app/Queue/DatabaseJob.php(26): Illuminate\\Queue\\Jobs\\Job->fire()\n#20 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(356): App\\Queue\\DatabaseJob->fire()\n#21 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(306): Illuminate\\Queue\\Worker->process(\'database\', Object(App\\Queue\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#22 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Worker.php(265): Illuminate\\Queue\\Worker->runJob(Object(App\\Queue\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#23 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(112): Illuminate\\Queue\\Worker->runNextJob(\'database\', \'finance\', Object(Illuminate\\Queue\\WorkerOptions))\n#24 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Queue/Console/WorkCommand.php(96): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'finance\')\n#25 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#26 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Util.php(37): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#27 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#28 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/BoundMethod.php(37): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#29 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Container/Container.php(596): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#30 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(134): Illuminate\\Container\\Container->call(Array)\n#31 /home/forge/taxes.com.ar/vendor/symfony/console/Command/Command.php(256): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#32 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Command.php(121): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Illuminate\\Console\\OutputStyle))\n#33 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(971): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#34 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(290): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#35 /home/forge/taxes.com.ar/vendor/symfony/console/Application.php(166): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#36 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Console/Application.php(93): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#37 /home/forge/taxes.com.ar/vendor/laravel/framework/src/Illuminate/Foundation/Console/Kernel.php(129): Illuminate\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#38 /home/forge/taxes.com.ar/artisan(35): Illuminate\\Foundation\\Console\\Kernel->handle(Object(Symfony\\Component\\Console\\Input\\ArgvInput), Object(Symfony\\Component\\Console\\Output\\ConsoleOutput))\n#39 {main}','2022-10-31 01:22:32',NULL);
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq`
--

DROP TABLE IF EXISTS `faq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `faq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pregunta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `respuesta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq`
--

LOCK TABLES `faq` WRITE;
/*!40000 ALTER TABLE `faq` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_upload_details`
--

DROP TABLE IF EXISTS `file_upload_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_upload_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_upload_id` int(10) unsigned NOT NULL,
  `detail` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_upload_details_file_upload_id_foreign` (`file_upload_id`),
  CONSTRAINT `file_upload_details_file_upload_id_foreign` FOREIGN KEY (`file_upload_id`) REFERENCES `file_uploads` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_upload_details`
--

LOCK TABLES `file_upload_details` WRITE;
/*!40000 ALTER TABLE `file_upload_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_upload_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_uploads`
--

DROP TABLE IF EXISTS `file_uploads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_uploads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data_type_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_uploads_data_type_id_foreign` (`data_type_id`),
  KEY `file_uploads_user_id_foreign` (`user_id`),
  KEY `file_uploads_person_id_foreign` (`person_id`),
  KEY `file_uploads_period_id_foreign` (`period_id`),
  CONSTRAINT `file_uploads_data_type_id_foreign` FOREIGN KEY (`data_type_id`) REFERENCES `data_types` (`id`),
  CONSTRAINT `file_uploads_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `file_uploads_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `file_uploads_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tusers` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_uploads`
--

LOCK TABLES `file_uploads` WRITE;
/*!40000 ALTER TABLE `file_uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_uploads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `forma_de_entrega`
--

DROP TABLE IF EXISTS `forma_de_entrega`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `forma_de_entrega` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `forma_de_entrega_person_id_foreign` (`person_id`),
  CONSTRAINT `forma_de_entrega_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `forma_de_entrega`
--

LOCK TABLES `forma_de_entrega` WRITE;
/*!40000 ALTER TABLE `forma_de_entrega` DISABLE KEYS */;
/*!40000 ALTER TABLE `forma_de_entrega` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_art_90`
--

DROP TABLE IF EXISTS `ganan_art_90`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_art_90` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,2) NOT NULL DEFAULT '0.00',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_art_90`
--

LOCK TABLES `ganan_art_90` WRITE;
/*!40000 ALTER TABLE `ganan_art_90` DISABLE KEYS */;
INSERT INTO `ganan_art_90` VALUES (1,2017,0.00,20000.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,2017,20000.00,40000.00,1000.00,0.09,20000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,2017,40000.00,60000.00,2800.00,0.12,40000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,2017,60000.00,80000.00,5200.00,0.15,60000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,2017,80000.00,120000.00,8200.00,0.19,80000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,2017,120000.00,160000.00,15800.00,0.23,120000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,2017,160000.00,240000.00,25000.00,0.27,160000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,2017,240000.00,320000.00,46600.00,0.31,240000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,2017,320000.00,999999999.99,71400.00,0.35,320000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,2018,0.00,25754.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,2018,25754.00,51508.00,1287.70,0.09,25754.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,2018,51508.00,77262.00,3605.56,0.12,51508.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,2018,77262.00,103016.00,6696.04,0.15,77262.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,2018,103016.00,154524.00,10559.14,0.19,103016.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(15,2018,154524.00,206032.00,20345.66,0.23,154524.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(16,2018,206032.00,309048.00,32192.50,0.27,206032.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(17,2018,309048.00,412064.00,60006.82,0.31,309048.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(18,2018,412064.00,999999999.99,91941.78,0.35,412064.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(19,2019,0.00,33039.81,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(20,2019,33039.81,66079.61,1651.99,0.09,33039.81,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(21,2019,66079.61,99119.42,4625.57,0.12,66079.61,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(22,2019,99119.42,132159.23,8590.35,0.15,99119.42,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(23,2019,132159.23,198238.84,13546.32,0.19,132159.23,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(24,2019,198238.84,264318.45,26101.45,0.23,198238.84,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(25,2019,264318.45,396477.68,41299.76,0.27,264318.45,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(26,2019,396477.68,528636.91,76982.75,0.31,396477.68,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(27,2019,528636.91,999999999.99,117952.11,0.35,528636.91,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(28,2016,0.00,10000.00,0.00,0.09,0.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(29,2016,10000.00,20000.00,900.00,0.14,10000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(30,2016,20000.00,30000.00,2300.00,0.19,20000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(31,2016,30000.00,60000.00,4200.00,0.23,30000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(32,2016,60000.00,90000.00,11100.00,0.27,60000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(33,2016,90000.00,120000.00,19200.00,0.31,90000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(34,2016,120000.00,999999999.00,28500.00,0.35,120000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(37,2020,0.00,47669.16,0.00,0.05,0.00,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(38,2020,47669.16,95338.32,2383.46,0.09,47669.16,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(39,2020,95338.32,143007.48,6673.68,0.12,95338.32,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(40,2020,143007.48,190676.65,12393.98,0.15,143007.48,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(41,2020,190676.65,286014.96,19544.36,0.19,190676.65,'2020-01-28 14:17:39','2022-10-29 18:49:56',NULL),(42,2020,286014.96,381353.28,37658.64,0.23,286014.96,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_art_90` VALUES (43,2020,381353.28,572029.92,59586.45,0.27,381353.28,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(44,2020,572029.92,762706.57,111069.14,0.31,572029.92,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(45,2020,762706.57,999999999.99,170178.90,0.35,762706.57,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(46,2021,0.00,64532.64,0.00,0.05,0.00,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(47,2021,64532.64,129065.29,3226.63,0.09,64532.64,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(48,2021,129065.29,193597.93,9034.57,0.12,129065.29,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(49,2021,193597.93,258130.58,16778.49,0.15,193597.93,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(50,2021,258130.58,387195.86,26458.39,0.19,258130.58,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(51,2021,387195.86,516261.14,50980.79,0.23,387195.86,'2022-10-29 18:49:57','2022-10-29 18:50:07',NULL),(52,2021,516261.14,774391.71,80665.80,0.27,516261.14,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(53,2021,774391.71,1032522.30,150361.06,0.31,774391.71,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(54,2021,1032522.30,999999999.99,230381.54,0.35,1032522.30,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(55,2022,0.00,97201.99,0.00,0.05,0.00,'2022-10-29 18:50:01','2022-10-29 18:50:02',NULL),(56,2022,97201.99,194404.01,4860.10,0.09,97201.99,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(57,2022,194404.01,291606.01,13608.29,0.12,194404.01,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(58,2022,291606.01,388808.02,25272.52,0.15,291606.01,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(59,2022,388808.02,583212.02,39852.82,0.19,388808.02,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(60,2022,583212.02,777616.02,76789.59,0.23,583212.02,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(61,2022,777616.02,1166424.03,121502.49,0.27,777616.02,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(62,2022,1166424.03,1555232.07,226480.67,0.31,1166424.03,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(63,2022,1555232.07,999999999.99,347011.15,0.35,1555232.07,'2022-10-29 18:50:01','2023-06-27 10:55:27',NULL),(64,2023,0.00,1400000.00,0.00,0.00,0.00,'2022-12-28 17:50:06','2023-09-25 21:57:47',NULL),(65,2023,1400000.00,1526000.00,0.00,0.09,1400000.00,'2022-12-28 17:50:06','2023-09-25 21:57:47',NULL),(66,2023,1526000.00,1648080.00,11340.00,0.12,1526000.00,'2022-12-28 17:50:06','2023-09-25 21:57:47',NULL),(67,2023,1648080.00,1763445.60,25989.60,0.15,1648080.00,'2022-12-28 17:50:06','2023-09-25 21:57:47',NULL),(68,2023,1763445.60,1869252.34,43294.44,0.19,1763445.60,'2022-12-28 17:50:06','2023-09-25 21:57:47',NULL),(69,2023,1869252.34,1962714.95,63397.72,0.23,1869252.34,'2022-12-28 17:50:06','2023-09-25 21:57:47',NULL),(70,2023,1962714.95,2041223.55,84894.12,0.27,1962714.95,'2022-12-28 17:50:06','2023-09-25 21:57:47',NULL),(71,2023,2041223.55,2102460.26,106091.44,0.31,2041223.55,'2022-12-28 17:50:06','2023-09-25 21:57:47',NULL),(72,2023,2102460.26,999999999.00,125074.82,0.35,2102460.26,'2022-12-28 17:50:06','2023-09-25 21:57:47',NULL);
/*!40000 ALTER TABLE `ganan_art_90` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_categorias`
--

DROP TABLE IF EXISTS `ganan_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_categorias`
--

LOCK TABLES `ganan_categorias` WRITE;
/*!40000 ALTER TABLE `ganan_categorias` DISABLE KEYS */;
INSERT INTO `ganan_categorias` VALUES (1,'Primera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,'Segunda',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(3,'Tercera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(4,'Cuarta',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_conceptos_anticipos`
--

DROP TABLE IF EXISTS `ganan_conceptos_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_conceptos_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ganan_conceptos_anticipos_nombre_unique` (`nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_conceptos_anticipos`
--

LOCK TABLES `ganan_conceptos_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` DISABLE KEYS */;
INSERT INTO `ganan_conceptos_anticipos` VALUES (1,NULL,'Anticipos',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,'Retenciones y Percepciones',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,'Saldo a Favor Anterior',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL);
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_anticipos`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_anticipos`
--

LOCK TABLES `ganan_ddjj_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_deducciones`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_deduccion_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_deducciones_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` (`ganan_deduccion_id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` FOREIGN KEY (`ganan_deduccion_id`) REFERENCES `ganan_deducciones` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_deducciones`
--

LOCK TABLES `ganan_ddjj_detail_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_ing_egr`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_ing_egr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_ing_egr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `ganan_categoria_id` int(10) unsigned NOT NULL,
  `ganan_tipo_op_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_ing_egr_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` (`ganan_categoria_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` (`ganan_tipo_op_id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` FOREIGN KEY (`ganan_categoria_id`) REFERENCES `ganan_categorias` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` FOREIGN KEY (`ganan_tipo_op_id`) REFERENCES `ganan_tipos_op` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_ing_egr`
--

LOCK TABLES `ganan_ddjj_detail_ing_egr` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjjs`
--

DROP TABLE IF EXISTS `ganan_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ingresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `ingresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `deducciones_total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `ganan_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjjs`
--

LOCK TABLES `ganan_ddjjs` WRITE;
/*!40000 ALTER TABLE `ganan_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_deducciones`
--

DROP TABLE IF EXISTS `ganan_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `generales` tinyint(1) NOT NULL DEFAULT '0',
  `particulares` tinyint(1) NOT NULL DEFAULT '0',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=173 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_deducciones`
--

LOCK TABLES `ganan_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_deducciones` DISABLE KEYS */;
INSERT INTO `ganan_deducciones` VALUES (1,NULL,2017,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,2017,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,2017,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,NULL,2017,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,NULL,2017,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,NULL,2017,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,NULL,2017,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,NULL,2017,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,NULL,2017,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,NULL,2017,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,NULL,2017,1,0,'Servicio Doméstico',51967.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,NULL,2017,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,NULL,2017,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,NULL,2017,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(15,NULL,2017,0,1,'Conyuge',48447.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(16,NULL,2017,0,1,'Hijo Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(17,NULL,2017,0,1,'Hijo Menor 18 años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(18,NULL,2017,0,1,'Hijastro Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(19,NULL,2017,0,1,'Hijastro Menor 18 Años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(20,NULL,2017,0,1,'Ganancia No Imponible',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(21,NULL,2017,0,1,'Deduccion Especial',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(22,NULL,2018,1,0,'Primas de seguro para el caso de muerte',12000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(23,NULL,2018,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(24,NULL,2018,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(25,NULL,2018,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(26,NULL,2018,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(27,NULL,2018,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(28,NULL,2018,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(29,NULL,2018,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(30,NULL,2018,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (31,NULL,2018,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(32,NULL,2018,1,0,'Servicio Doméstico',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(33,NULL,2018,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(34,NULL,2018,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(35,NULL,2018,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(36,NULL,2018,0,1,'Conyuge',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(37,NULL,2018,0,1,'Hijo Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(38,NULL,2018,0,1,'Hijo Menor 18 años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(39,NULL,2018,0,1,'Hijastro Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(40,NULL,2018,0,1,'Hijastro Menor 18 Años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(41,NULL,2018,0,1,'Ganancia No Imponible',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(42,NULL,2018,0,1,'Deduccion Especial',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(43,NULL,2019,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(44,NULL,2019,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(45,NULL,2019,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(46,NULL,2019,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(47,NULL,2019,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(48,NULL,2019,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(49,NULL,2019,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(50,NULL,2019,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(51,NULL,2019,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(52,NULL,2019,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(53,NULL,2019,1,0,'Servicio Doméstico',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(54,NULL,2019,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(55,NULL,2019,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(56,NULL,2019,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(57,NULL,2019,0,1,'Conyuge',80033.97,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(58,NULL,2019,0,1,'Hijo Incapacitado',40361.43,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(59,NULL,2019,0,1,'Hijo Menor 18 años',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(60,NULL,2019,0,1,'Hijastro Incapacitado',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(61,NULL,2019,0,1,'Hijastro Menor 18 Años',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(62,NULL,2019,0,1,'Ganancia No Imponible',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(63,NULL,2019,0,1,'Deduccion Especial',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (64,NULL,2016,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(65,NULL,2016,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(66,NULL,2016,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(67,NULL,2016,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(68,NULL,2016,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(69,NULL,2016,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(70,NULL,2016,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(71,NULL,2016,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(72,NULL,2016,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(73,NULL,2016,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(74,NULL,2016,1,0,'Servicio Doméstico',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(75,NULL,2016,1,0,'Donaciones',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(76,NULL,2016,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(77,NULL,2016,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y \n            Paramédica',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(78,NULL,2016,0,1,'Conyuge',39778.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(79,NULL,2016,0,1,'Hijo Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(80,NULL,2016,0,1,'Hijo Menor 18 años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(81,NULL,2016,0,1,'Hijastro Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(82,NULL,2016,0,1,'Hijastro Menor 18 Años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(83,NULL,2016,0,1,'Ganancia No Imponible',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(84,NULL,2016,0,1,'Deduccion Especial',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(85,NULL,2019,1,0,'Alquileres',103018.97,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(86,NULL,2020,1,0,'Alquileres',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(87,NULL,2020,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(88,NULL,2020,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(89,NULL,2020,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(90,NULL,2020,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(91,NULL,2020,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(92,NULL,2020,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(93,NULL,2020,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_deducciones` VALUES (94,NULL,2020,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(95,NULL,2020,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(96,NULL,2020,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(97,NULL,2020,1,0,'Servicio Doméstico',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(98,NULL,2020,1,0,'Donaciones',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(99,NULL,2020,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(100,NULL,2020,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(101,NULL,2020,0,1,'Conyuge',115471.38,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(102,NULL,2020,0,1,'Hijo Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(103,NULL,2020,0,1,'Hijo Menor 18 años',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(104,NULL,2020,0,1,'Hijastro Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(105,NULL,2020,0,1,'Hijastro Menor 18 Años',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(106,NULL,2020,0,1,'Ganancia No Imponible',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(107,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1',103018.79,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(108,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1 \"Nuevos Profesionales / Emprendedores',309652.93,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(109,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 2',594533.62,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(110,NULL,2021,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(111,NULL,2021,1,0,'Gastos de Sepelio',996.23,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(112,NULL,2021,1,0,'Aportes a Obras Sociales',0.00,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(113,NULL,2021,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(114,NULL,2021,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(115,NULL,2021,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(116,NULL,2021,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(117,NULL,2021,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(118,NULL,2021,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(119,NULL,2021,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(120,NULL,2021,1,0,'Servicio Doméstico',167678.40,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(121,NULL,2021,1,0,'Donaciones',0.00,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(122,NULL,2021,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(123,NULL,2021,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(124,NULL,2021,0,1,'Conyuge',156320.63,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(125,NULL,2021,0,1,'Hijo Menor 18 años',78833.08,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL);
INSERT INTO `ganan_deducciones` VALUES (126,NULL,2021,0,1,'Ganancia No Imponible',167678.40,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(127,NULL,2021,0,1,'Deduccion Especial',804856.34,1,'2022-10-29 18:49:57','2022-10-29 18:49:57',NULL),(128,NULL,2022,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(129,NULL,2022,1,0,'Gastos de Sepelio',996.23,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(130,NULL,2022,1,0,'Aportes a Obras Sociales',0.00,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(131,NULL,2022,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(132,NULL,2022,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(133,NULL,2022,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(134,NULL,2022,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(135,NULL,2022,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(136,NULL,2022,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(137,NULL,2022,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(138,NULL,2022,1,0,'Servicio Doméstico',252564.84,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(139,NULL,2022,1,0,'Donaciones',0.00,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(140,NULL,2022,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(141,NULL,2022,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(142,NULL,2022,1,0,'Alquileres',252564.84,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(143,NULL,2022,0,1,'Conyuge',235457.25,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(144,NULL,2022,0,1,'Hijo Menor 18 años',118741.97,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(145,NULL,2022,0,1,'Ganancia No Imponible',252564.84,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(146,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 2]',1212311.24,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(147,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1]',505129.68,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(148,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1 “nuevos profesionales/emprendedores”]',631412.10,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(149,NULL,2022,0,1,'Hijo Incapacitado',237483.94,1,'2022-10-29 18:50:01','2022-10-29 18:50:01',NULL),(150,NULL,2021,1,0,'Alquileres',167678.40,1,NULL,NULL,NULL),(151,NULL,2023,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(152,NULL,2023,1,0,'Aportes a Obras Sociales',0.00,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(153,NULL,2023,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(154,NULL,2023,1,0,'Gastos de Sepelio',996.23,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(155,NULL,2023,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL);
INSERT INTO `ganan_deducciones` VALUES (156,NULL,2023,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(157,NULL,2023,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(158,NULL,2023,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(159,NULL,2023,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(160,NULL,2023,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(161,NULL,2023,1,0,'Servicio Doméstico',451686.96,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(162,NULL,2023,1,0,'Donaciones',0.00,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(163,NULL,2023,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(164,NULL,2023,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(165,NULL,2023,1,0,'Alquileres',451686.96,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(166,NULL,2023,0,1,'Ganancia No Imponible',451686.96,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(167,NULL,2023,0,1,'Conyuge',421091.75,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(168,NULL,2023,0,1,'Hijo Menor 18 años',212358.14,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(169,NULL,2023,0,1,'Hijo Incapacitado',424716.28,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(170,NULL,2023,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1]',1580904.36,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(171,NULL,2023,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1 “nuevos profesionales/emprendedores”]',1806747.84,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL),(172,NULL,2023,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 2]',2168097.42,1,'2022-12-28 17:50:06','2022-12-28 17:50:06',NULL);
/*!40000 ALTER TABLE `ganan_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_tipos_op`
--

DROP TABLE IF EXISTS `ganan_tipos_op`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_tipos_op` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_tipos_op`
--

LOCK TABLES `ganan_tipos_op` WRITE;
/*!40000 ALTER TABLE `ganan_tipos_op` DISABLE KEYS */;
INSERT INTO `ganan_tipos_op` VALUES (1,NULL,'Gravado',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,NULL,'Exento',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_tipos_op` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iibb_perceptions`
--

DROP TABLE IF EXISTS `iibb_perceptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iibb_perceptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iibb_perceptions`
--

LOCK TABLES `iibb_perceptions` WRITE;
/*!40000 ALTER TABLE `iibb_perceptions` DISABLE KEYS */;
INSERT INTO `iibb_perceptions` VALUES (1,NULL,NULL,NULL,'IIBB CABA','IIBBCABA'),(2,NULL,NULL,NULL,'IIBB Bs. As.','IIBBBSAS'),(3,NULL,NULL,NULL,'Percepcion IIBB Tucuman','IIBBTucuman'),(4,NULL,NULL,NULL,'Perc IIBB Misiones','IIBBMisiones'),(5,NULL,NULL,NULL,'Perc IIBB Cordoba','IIBBCba'),(6,NULL,NULL,NULL,'Pec IIBB La Pampa','IIBB La Pampa'),(7,NULL,NULL,NULL,'Perc IIBB Rio Negro','IIBB Rio Negro'),(8,NULL,NULL,NULL,'Perc IIBB Corrientes','IIIBB Corrientes'),(9,NULL,NULL,NULL,'Perc IIBB Santiago del Estero','IIBBSantiago');
/*!40000 ALTER TABLE `iibb_perceptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_combos`
--

DROP TABLE IF EXISTS `inv_combos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_combos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `inv_product_combo_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `cantidades` int(11) NOT NULL,
  `codigo_interno` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_combos_inv_product_combo_id_foreign` (`inv_product_combo_id`),
  KEY `inv_combos_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_combos_inv_product_combo_id_foreign` FOREIGN KEY (`inv_product_combo_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_combos_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_combos`
--

LOCK TABLES `inv_combos` WRITE;
/*!40000 ALTER TABLE `inv_combos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_combos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock`
--

DROP TABLE IF EXISTS `inv_control_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_control_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock`
--

LOCK TABLES `inv_control_stock` WRITE;
/*!40000 ALTER TABLE `inv_control_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock_detail`
--

DROP TABLE IF EXISTS `inv_control_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_control_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `stock_actual` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_real` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_control_stock_detail_inv_control_stock_id_foreign` (`inv_control_stock_id`),
  KEY `inv_control_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_control_stock_detail_inv_control_stock_id_foreign` FOREIGN KEY (`inv_control_stock_id`) REFERENCES `inv_control_stock` (`id`),
  CONSTRAINT `inv_control_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_control_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock_detail`
--

LOCK TABLES `inv_control_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_control_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_depositos`
--

DROP TABLE IF EXISTS `inv_depositos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_depositos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_depositos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_depositos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_depositos`
--

LOCK TABLES `inv_depositos` WRITE;
/*!40000 ALTER TABLE `inv_depositos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_depositos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_descarga_details`
--

DROP TABLE IF EXISTS `inv_descarga_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_descarga_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_descarga_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_descarga_details_person_id_foreign` (`person_id`),
  KEY `inv_descarga_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `inv_descarga_details_inv_descarga_id_foreign` (`inv_descarga_id`),
  CONSTRAINT `inv_descarga_details_inv_descarga_id_foreign` FOREIGN KEY (`inv_descarga_id`) REFERENCES `inv_descargas` (`id`),
  CONSTRAINT `inv_descarga_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_descarga_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_descarga_details`
--

LOCK TABLES `inv_descarga_details` WRITE;
/*!40000 ALTER TABLE `inv_descarga_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_descarga_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_descargas`
--

DROP TABLE IF EXISTS `inv_descargas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_descargas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_gastos_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `fecha` datetime NOT NULL DEFAULT '2023-03-15 23:49:34',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_descargas_person_id_foreign` (`person_id`),
  KEY `inv_descargas_inv_orden_trabajo_gastos_tipo_id_foreign` (`inv_orden_trabajo_gastos_tipo_id`),
  KEY `inv_descargas_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `inv_descargas_inv_orden_trabajo_gastos_tipo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_gastos_tipo_id`) REFERENCES `inv_orden_trabajo_gastos_tipos` (`id`),
  CONSTRAINT `inv_descargas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_descargas_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_descargas`
--

LOCK TABLES `inv_descargas` WRITE;
/*!40000 ALTER TABLE `inv_descargas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_descargas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores`
--

DROP TABLE IF EXISTS `inv_indicadores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metodo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `orden` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores`
--

LOCK TABLES `inv_indicadores` WRITE;
/*!40000 ALTER TABLE `inv_indicadores` DISABLE KEYS */;
INSERT INTO `inv_indicadores` VALUES (1,NULL,'Datos Grales','datos_grales','card_info',5,1,NULL,'2022-10-29 18:50:07',NULL),(2,NULL,'Impuestos Asociados','impuestos_asociados','card_info',6,1,NULL,'2022-10-29 18:50:07',NULL),(3,NULL,'Informacion de Liquidacion','informacion_de_liquidacion','card_info',7,1,NULL,'2022-10-29 18:50:07',NULL),(4,NULL,'Cantidad Ventas del Mes','cantidad_ventas_del_mes','card',1,1,NULL,'2022-10-29 18:50:07',NULL),(5,NULL,'Total Facturado En El Mes','total_facturado_en_el_mes','card',2,1,NULL,'2022-10-29 18:50:07',NULL),(6,NULL,'Total Facturado En El Dia','total_facturado_en_el_dia','card',3,1,NULL,'2022-10-29 18:50:07',NULL),(7,NULL,'Total Facturado En El Año','total_facturado_en_el_anio','card',4,1,NULL,'2022-10-29 18:50:07',NULL),(8,NULL,'Facturacion Mensual','facturacion_mensual','grafico',8,1,NULL,'2022-10-29 18:50:07',NULL),(9,NULL,'Proyeccion de Ganancias','proyeccion_de_ganancias','tabla',9,1,NULL,'2022-10-29 18:50:07',NULL),(10,NULL,'Posicion IVA','posicion_de_iva','tabla',10,1,NULL,'2022-10-29 18:50:07',NULL);
/*!40000 ALTER TABLE `inv_indicadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores_persons`
--

DROP TABLE IF EXISTS `inv_indicadores_persons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores_persons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_indicador_id` bigint(20) unsigned NOT NULL,
  `objetivo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_indicadores_persons_person_id_foreign` (`person_id`),
  KEY `inv_indicadores_persons_inv_indicador_id_foreign` (`inv_indicador_id`),
  CONSTRAINT `inv_indicadores_persons_inv_indicador_id_foreign` FOREIGN KEY (`inv_indicador_id`) REFERENCES `inv_indicadores` (`id`),
  CONSTRAINT `inv_indicadores_persons_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores_persons`
--

LOCK TABLES `inv_indicadores_persons` WRITE;
/*!40000 ALTER TABLE `inv_indicadores_persons` DISABLE KEYS */;
INSERT INTO `inv_indicadores_persons` VALUES (1,NULL,40719,4,0.00,NULL,'2023-10-15 11:10:58','2023-10-15 11:10:58'),(2,NULL,40719,5,0.00,NULL,'2023-10-15 11:11:10','2023-10-15 11:11:10'),(3,NULL,40719,2,0.00,NULL,'2023-10-15 11:11:19','2023-10-15 11:11:19'),(4,NULL,40719,5,0.00,NULL,'2023-10-15 11:11:19','2023-10-15 11:11:19'),(5,NULL,40719,2,0.00,NULL,'2023-10-15 11:11:25','2023-10-15 11:11:25'),(6,NULL,40719,5,0.00,NULL,'2023-10-15 11:11:25','2023-10-15 11:11:25'),(7,NULL,40719,9,0.00,NULL,'2023-10-15 11:11:25','2023-10-15 11:11:25'),(8,NULL,40719,2,0.00,NULL,'2023-10-15 11:11:33','2023-10-15 11:11:33'),(9,NULL,40719,5,0.00,NULL,'2023-10-15 11:11:33','2023-10-15 11:11:33'),(10,NULL,40719,9,0.00,NULL,'2023-10-15 11:11:33','2023-10-15 11:11:33'),(11,NULL,40719,10,0.00,NULL,'2023-10-15 11:11:33','2023-10-15 11:11:33'),(12,NULL,40719,1,0.00,NULL,NULL,NULL),(13,NULL,40719,2,0.00,NULL,NULL,NULL),(14,NULL,40719,5,0.00,NULL,NULL,NULL),(15,NULL,40719,9,0.00,NULL,NULL,NULL),(16,NULL,40719,10,0.00,NULL,NULL,NULL),(17,NULL,42384,4,0.00,NULL,'2024-01-09 17:02:10','2024-01-09 17:02:10');
/*!40000 ALTER TABLE `inv_indicadores_persons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_ing_egr_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock`
--

LOCK TABLES `inv_ing_egr_stock` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock_detail`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_ing_egr_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `sumar1_restar0` tinyint(1) NOT NULL DEFAULT '1',
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` (`inv_ing_egr_stock_id`),
  KEY `inv_ing_egr_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` FOREIGN KEY (`inv_ing_egr_stock_id`) REFERENCES `inv_ing_egr_stock` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock_detail`
--

LOCK TABLES `inv_ing_egr_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_lista_de_precios`
--

DROP TABLE IF EXISTS `inv_lista_de_precios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_lista_de_precios` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `porcentaje_descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_lista_de_precios_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_lista_de_precios_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_lista_de_precios`
--

LOCK TABLES `inv_lista_de_precios` WRITE;
/*!40000 ALTER TABLE `inv_lista_de_precios` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_lista_de_precios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_clasificacion`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_clasificacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_clasificacion` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_clasificacion_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_clasificacion_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_clasificacion`
--

LOCK TABLES `inv_orden_trabajo_clasificacion` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_clasificacion` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_clasificacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_config_cc`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_config_cc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_config_cc` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `horas_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `horas_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `asiento_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_config_cc_person_id_foreign` (`person_id`),
  KEY `hcc_id_foreign` (`horas_conta_plan_cuenta_id`),
  KEY `gcc_id_foreign` (`gastos_conta_plan_cuenta_id`),
  KEY `pcc_id_foreign` (`productos_conta_plan_cuenta_id`),
  KEY `h_contra_cc_id_foreign` (`horas_contra_conta_plan_cuenta_id`),
  KEY `g_contra_cc_id_foreign` (`gastos_contra_conta_plan_cuenta_id`),
  KEY `p_contra_cc_id_foreign` (`productos_contra_conta_plan_cuenta_id`),
  KEY `ahcc_id_foreign` (`asiento_horas_cpc_id`),
  KEY `agcc_id_foreign` (`asiento_gastos_cpc_id`),
  KEY `apcc_id_foreign` (`asiento_productos_cpc_id`),
  KEY `ah_contra_cc_id_foreign` (`asiento_contra_horas_cpc_id`),
  KEY `ag_contra_cc_id_foreign` (`asiento_contra_gastos_cpc_id`),
  KEY `ap_contra_cc_id_foreign` (`asiento_contra_productos_cpc_id`),
  CONSTRAINT `ag_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `agcc_id_foreign` FOREIGN KEY (`asiento_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ah_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ahcc_id_foreign` FOREIGN KEY (`asiento_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ap_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `apcc_id_foreign` FOREIGN KEY (`asiento_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `g_contra_cc_id_foreign` FOREIGN KEY (`gastos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `gcc_id_foreign` FOREIGN KEY (`gastos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `h_contra_cc_id_foreign` FOREIGN KEY (`horas_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `hcc_id_foreign` FOREIGN KEY (`horas_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `inv_orden_trabajo_config_cc_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `p_contra_cc_id_foreign` FOREIGN KEY (`productos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `pcc_id_foreign` FOREIGN KEY (`productos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_config_cc`
--

LOCK TABLES `inv_orden_trabajo_config_cc` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_facturada`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_facturada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_facturada` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_facturada_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_facturada_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_facturada_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `inv_orden_trabajo_facturada_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `inv_orden_trabajo_facturada_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_facturada_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_facturada`
--

LOCK TABLES `inv_orden_trabajo_facturada` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_facturada` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_facturada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_files`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_files_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `inv_orden_trabajo_files_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_files`
--

LOCK TABLES `inv_orden_trabajo_files` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_gastos_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-10-29 18:50:04',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_gastos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `inv_orden_trabajo_gastos_receipt_id_foreign` (`receipt_id`),
  KEY `i_o_t_g_t_id_foreign` (`inv_orden_trabajo_gastos_tipo_id`),
  KEY `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `i_o_t_g_t_id_foreign` FOREIGN KEY (`inv_orden_trabajo_gastos_tipo_id`) REFERENCES `inv_orden_trabajo_gastos_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos`
--

LOCK TABLES `inv_orden_trabajo_gastos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_tipos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_gastos_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos_tipos`
--

LOCK TABLES `inv_orden_trabajo_gastos_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-08-15 23:36:14',
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_horas_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_ot_hora_disponible_id` bigint(20) unsigned NOT NULL,
  `cantidad` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` (`inv_orden_trabajo_horas_tipo_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_horas_inv_ot_hora_disponible_id_foreign` (`inv_ot_hora_disponible_id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_horas_tipo_id`) REFERENCES `inv_orden_trabajo_horas_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_ot_hora_disponible_id_foreign` FOREIGN KEY (`inv_ot_hora_disponible_id`) REFERENCES `inv_orden_trabajo_horas_disponibles` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas`
--

LOCK TABLES `inv_orden_trabajo_horas` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas_dispo`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cargar_asignar` int(10) unsigned NOT NULL DEFAULT '1',
  `person_id` int(10) unsigned NOT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-08-22 21:46:37',
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_dispo_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_dispo_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `inv_orden_trabajo_horas_dispo_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `inv_orden_trabajo_horas_dispo_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_dispo_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas_dispo`
--

LOCK TABLES `inv_orden_trabajo_horas_dispo` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas_disponibles`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas_disponibles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas_disponibles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_horas_dispo_id` bigint(20) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-08-15 23:36:13',
  `inv_orden_trabajo_horas_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `cantidad` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_disponibles_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_disponibles_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_ot_hs_tipo_dis` (`inv_orden_trabajo_horas_tipo_id`),
  KEY `inv_ot_horas_dispo_id` (`inv_orden_trabajo_horas_dispo_id`),
  CONSTRAINT `inv_orden_trabajo_horas_disponibles_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_disponibles_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_ot_horas_dispo_id` FOREIGN KEY (`inv_orden_trabajo_horas_dispo_id`) REFERENCES `inv_orden_trabajo_horas_dispo` (`id`),
  CONSTRAINT `inv_ot_hs_tipo_dis` FOREIGN KEY (`inv_orden_trabajo_horas_tipo_id`) REFERENCES `inv_orden_trabajo_horas_tipos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas_disponibles`
--

LOCK TABLES `inv_orden_trabajo_horas_disponibles` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_disponibles` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_disponibles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `syj_centros_costo_id` int(10) unsigned NOT NULL,
  `valor` decimal(16,2) NOT NULL DEFAULT '1.00',
  `cantidad_disponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_disponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `show_para_produccion` tinyint(1) NOT NULL DEFAULT '1',
  `show_para_horas` tinyint(1) NOT NULL DEFAULT '1',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_tipos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_tipos_syj_centros_costo_id_foreign` (`syj_centros_costo_id`),
  CONSTRAINT `inv_orden_trabajo_horas_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_tipos_syj_centros_costo_id_foreign` FOREIGN KEY (`syj_centros_costo_id`) REFERENCES `syj_centros_costos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas_tipos`
--

LOCK TABLES `inv_orden_trabajo_horas_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_productos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_productos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-10-29 18:50:04',
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe` decimal(16,2) NOT NULL DEFAULT '1.00',
  `total` decimal(16,2) NOT NULL DEFAULT '1.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_productos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_productos_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_productos_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `inv_orden_trabajo_productos_dc_orden_id_foreign` (`dc_orden_id`),
  CONSTRAINT `inv_orden_trabajo_productos_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_productos`
--

LOCK TABLES `inv_orden_trabajo_productos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_servicios`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_servicios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_servicios` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `dc_orden_detail_id` bigint(20) unsigned NOT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-08-14 22:27:06',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_servicios_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_servicios_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_servicios_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `inv_orden_trabajo_servicios_dc_orden_detail_id_foreign` (`dc_orden_detail_id`),
  CONSTRAINT `inv_orden_trabajo_servicios_dc_orden_detail_id_foreign` FOREIGN KEY (`dc_orden_detail_id`) REFERENCES `dc_ordenes_details` (`id`),
  CONSTRAINT `inv_orden_trabajo_servicios_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `inv_orden_trabajo_servicios_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_servicios_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_servicios`
--

LOCK TABLES `inv_orden_trabajo_servicios` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_servicios` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_servicios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_tareas`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_tareas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_tareas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-09-14 21:51:21',
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned NOT NULL,
  `syj_centro_costo_id` int(10) unsigned NOT NULL,
  `syj_empleado_id` int(10) unsigned NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `is_terminada` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_tareas_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_tareas_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_tareas_syj_centro_costo_id_foreign` (`syj_centro_costo_id`),
  KEY `inv_orden_trabajo_tareas_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `inv_orden_trabajo_tareas_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_tareas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_tareas_syj_centro_costo_id_foreign` FOREIGN KEY (`syj_centro_costo_id`) REFERENCES `syj_centros_costos` (`id`),
  CONSTRAINT `inv_orden_trabajo_tareas_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_tareas`
--

LOCK TABLES `inv_orden_trabajo_tareas` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_tareas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_tareas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajos`
--

DROP TABLE IF EXISTS `inv_orden_trabajos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `inv_ot_clasificacion_id` int(10) unsigned DEFAULT NULL,
  `patente` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rodado_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-10-29 18:50:03',
  `fecha_cierre` datetime DEFAULT NULL,
  `numero` int(10) unsigned NOT NULL,
  `responsable` text COLLATE utf8mb4_unicode_ci,
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `cerrada` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `inv_orden_trabajos_inv_ot_clasificacion_id_foreign` (`inv_ot_clasificacion_id`),
  KEY `inv_orden_trabajos_rodado_id_foreign` (`rodado_id`),
  KEY `inv_orden_trabajos_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `inv_orden_trabajos_inv_ot_clasificacion_id_foreign` FOREIGN KEY (`inv_ot_clasificacion_id`) REFERENCES `inv_orden_trabajo_clasificacion` (`id`),
  CONSTRAINT `inv_orden_trabajos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajos_rodado_id_foreign` FOREIGN KEY (`rodado_id`) REFERENCES `rodados` (`id`),
  CONSTRAINT `inv_orden_trabajos_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajos`
--

LOCK TABLES `inv_orden_trabajos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ot_horas_importe_dispo`
--

DROP TABLE IF EXISTS `inv_ot_horas_importe_dispo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ot_horas_importe_dispo` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `fecha` datetime NOT NULL DEFAULT '2023-09-12 22:21:06',
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `dc_firma_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ot_horas_importe_dispo_person_id_foreign` (`person_id`),
  KEY `inv_ot_horas_importe_dispo_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `inv_ot_horas_importe_dispo_dc_firma_id_foreign` (`dc_firma_id`),
  CONSTRAINT `inv_ot_horas_importe_dispo_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `inv_ot_horas_importe_dispo_dc_firma_id_foreign` FOREIGN KEY (`dc_firma_id`) REFERENCES `dc_firmas` (`id`),
  CONSTRAINT `inv_ot_horas_importe_dispo_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ot_horas_importe_dispo`
--

LOCK TABLES `inv_ot_horas_importe_dispo` WRITE;
/*!40000 ALTER TABLE `inv_ot_horas_importe_dispo` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ot_horas_importe_dispo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ot_horas_importe_disponible`
--

DROP TABLE IF EXISTS `inv_ot_horas_importe_disponible`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ot_horas_importe_disponible` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_ot_horas_importe_dispo_id` bigint(20) unsigned NOT NULL,
  `inv_orden_trabajo_horas_tipo_id` bigint(20) unsigned NOT NULL,
  `transactionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transactionable_id` int(10) unsigned DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ot_h_imp_dispo_id` (`inv_ot_horas_importe_dispo_id`),
  KEY `inv_ot_h_tipo_id` (`inv_orden_trabajo_horas_tipo_id`),
  CONSTRAINT `inv_ot_h_imp_dispo_id` FOREIGN KEY (`inv_ot_horas_importe_dispo_id`) REFERENCES `inv_ot_horas_importe_dispo` (`id`),
  CONSTRAINT `inv_ot_h_tipo_id` FOREIGN KEY (`inv_orden_trabajo_horas_tipo_id`) REFERENCES `inv_orden_trabajo_horas_tipos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ot_horas_importe_disponible`
--

LOCK TABLES `inv_ot_horas_importe_disponible` WRITE;
/*!40000 ALTER TABLE `inv_ot_horas_importe_disponible` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ot_horas_importe_disponible` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ot_link`
--

DROP TABLE IF EXISTS `inv_ot_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ot_link` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `fecha` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ot_link_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_ot_link_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ot_link`
--

LOCK TABLES `inv_ot_link` WRITE;
/*!40000 ALTER TABLE `inv_ot_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ot_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ot_link_facts`
--

DROP TABLE IF EXISTS `inv_ot_link_facts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ot_link_facts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_ot_link_id` bigint(20) unsigned NOT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ot_link_facts_inv_ot_link_id_foreign` (`inv_ot_link_id`),
  KEY `inv_ot_link_facts_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `inv_ot_link_facts_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `inv_ot_link_facts_inv_ot_link_id_foreign` FOREIGN KEY (`inv_ot_link_id`) REFERENCES `inv_ot_link` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ot_link_facts`
--

LOCK TABLES `inv_ot_link_facts` WRITE;
/*!40000 ALTER TABLE `inv_ot_link_facts` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ot_link_facts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ot_link_ots`
--

DROP TABLE IF EXISTS `inv_ot_link_ots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ot_link_ots` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_ot_link_id` bigint(20) unsigned NOT NULL,
  `inv_ot_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ot_link_ots_inv_ot_link_id_foreign` (`inv_ot_link_id`),
  KEY `inv_ot_link_ots_inv_ot_id_foreign` (`inv_ot_id`),
  CONSTRAINT `inv_ot_link_ots_inv_ot_id_foreign` FOREIGN KEY (`inv_ot_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_ot_link_ots_inv_ot_link_id_foreign` FOREIGN KEY (`inv_ot_link_id`) REFERENCES `inv_ot_link` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ot_link_ots`
--

LOCK TABLES `inv_ot_link_ots` WRITE;
/*!40000 ALTER TABLE `inv_ot_link_ots` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ot_link_ots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_product_receipt`
--

DROP TABLE IF EXISTS `inv_product_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_product_receipt` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `type_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `receiptable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `receiptable_id` int(10) unsigned NOT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descuento_por1_imp0` tinyint(1) NOT NULL DEFAULT '1',
  `descuento_porcentaje` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_con_descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_product_receipt_type_id_foreign` (`type_id`),
  KEY `inv_product_receipt_person_id_foreign` (`person_id`),
  KEY `inv_product_receipt_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_product_receipt_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_product_receipt_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_product_receipt_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_product_receipt`
--

LOCK TABLES `inv_product_receipt` WRITE;
/*!40000 ALTER TABLE `inv_product_receipt` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_product_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_producto_fotos`
--

DROP TABLE IF EXISTS `inv_producto_fotos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_producto_fotos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned NOT NULL,
  `foto` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_producto_fotos_inv_producto_id_foreign` (`inv_producto_id`),
  CONSTRAINT `inv_producto_fotos_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_producto_fotos`
--

LOCK TABLES `inv_producto_fotos` WRITE;
/*!40000 ALTER TABLE `inv_producto_fotos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_producto_fotos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_producto_prioridad`
--

DROP TABLE IF EXISTS `inv_producto_prioridad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_producto_prioridad` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_producto_prioridad`
--

LOCK TABLES `inv_producto_prioridad` WRITE;
/*!40000 ALTER TABLE `inv_producto_prioridad` DISABLE KEYS */;
INSERT INTO `inv_producto_prioridad` VALUES (1,'Alta',1,NULL,NULL,NULL),(2,'Media',1,NULL,NULL,NULL),(3,'Baja',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `inv_producto_prioridad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_productos`
--

DROP TABLE IF EXISTS `inv_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_productos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `inv_producto_tipo_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `inv_deposito_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `person_id` int(10) unsigned NOT NULL,
  `person_prov_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_externo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_interno` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fac_ele_unidad_medida_id` int(10) unsigned NOT NULL DEFAULT '8',
  `inv_rubro_sub_id` bigint(20) unsigned NOT NULL,
  `inv_ubicacion_id` bigint(20) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `margen` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `system_tax_id` int(10) unsigned DEFAULT NULL,
  `iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `inv_lista_de_precio_id` bigint(20) unsigned DEFAULT NULL,
  `inv_prioridad_id` bigint(20) unsigned NOT NULL DEFAULT '3',
  `foto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stock` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_minimo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `fecha_vto` datetime DEFAULT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `texto_corto` text COLLATE utf8mb4_unicode_ci,
  `texto_largo` text COLLATE utf8mb4_unicode_ci,
  `show_in_catalogo` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_productos_person_id_foreign` (`person_id`),
  KEY `inv_productos_person_prov_id_foreign` (`person_prov_id`),
  KEY `inv_productos_fac_ele_unidad_medida_id_foreign` (`fac_ele_unidad_medida_id`),
  KEY `inv_productos_inv_rubro_sub_id_foreign` (`inv_rubro_sub_id`),
  KEY `inv_productos_inv_ubicacion_id_foreign` (`inv_ubicacion_id`),
  KEY `inv_productos_system_tax_id_foreign` (`system_tax_id`),
  KEY `inv_productos_inv_lista_de_precio_id_foreign` (`inv_lista_de_precio_id`),
  KEY `inv_productos_inv_producto_tipo_id_foreign` (`inv_producto_tipo_id`),
  KEY `inv_productos_moneda_id_foreign` (`moneda_id`),
  KEY `inv_productos_inv_deposito_id_foreign` (`inv_deposito_id`),
  KEY `inv_productos_inv_prioridad_id_foreign` (`inv_prioridad_id`),
  CONSTRAINT `inv_productos_fac_ele_unidad_medida_id_foreign` FOREIGN KEY (`fac_ele_unidad_medida_id`) REFERENCES `fac_elec_unidad_medidas` (`id`),
  CONSTRAINT `inv_productos_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `inv_productos_inv_lista_de_precio_id_foreign` FOREIGN KEY (`inv_lista_de_precio_id`) REFERENCES `inv_lista_de_precios` (`id`),
  CONSTRAINT `inv_productos_inv_prioridad_id_foreign` FOREIGN KEY (`inv_prioridad_id`) REFERENCES `inv_producto_prioridad` (`id`),
  CONSTRAINT `inv_productos_inv_producto_tipo_id_foreign` FOREIGN KEY (`inv_producto_tipo_id`) REFERENCES `inv_productos_tipos` (`id`),
  CONSTRAINT `inv_productos_inv_rubro_sub_id_foreign` FOREIGN KEY (`inv_rubro_sub_id`) REFERENCES `inv_rubros_sub` (`id`),
  CONSTRAINT `inv_productos_inv_ubicacion_id_foreign` FOREIGN KEY (`inv_ubicacion_id`) REFERENCES `inv_ubicaciones` (`id`),
  CONSTRAINT `inv_productos_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `inv_productos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_productos_person_prov_id_foreign` FOREIGN KEY (`person_prov_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_productos_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_productos`
--

LOCK TABLES `inv_productos` WRITE;
/*!40000 ALTER TABLE `inv_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_productos_tipos`
--

DROP TABLE IF EXISTS `inv_productos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_productos_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_productos_tipos`
--

LOCK TABLES `inv_productos_tipos` WRITE;
/*!40000 ALTER TABLE `inv_productos_tipos` DISABLE KEYS */;
INSERT INTO `inv_productos_tipos` VALUES (1,NULL,'Unitario',1,NULL,NULL,NULL),(2,NULL,'Combo',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `inv_productos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_rubros`
--

DROP TABLE IF EXISTS `inv_rubros`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_rubros` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_rubros_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_rubros_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_rubros`
--

LOCK TABLES `inv_rubros` WRITE;
/*!40000 ALTER TABLE `inv_rubros` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_rubros` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_rubros_sub`
--

DROP TABLE IF EXISTS `inv_rubros_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_rubros_sub` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_rubro_id` bigint(20) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_rubros_sub_person_id_foreign` (`person_id`),
  KEY `inv_rubros_sub_inv_rubro_id_foreign` (`inv_rubro_id`),
  CONSTRAINT `inv_rubros_sub_inv_rubro_id_foreign` FOREIGN KEY (`inv_rubro_id`) REFERENCES `inv_rubros` (`id`),
  CONSTRAINT `inv_rubros_sub_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_rubros_sub`
--

LOCK TABLES `inv_rubros_sub` WRITE;
/*!40000 ALTER TABLE `inv_rubros_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_rubros_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_stock_movimientos`
--

DROP TABLE IF EXISTS `inv_stock_movimientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_stock_movimientos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `movimiento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock` decimal(16,2) NOT NULL DEFAULT '0.00',
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `transactionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transactionable_id` bigint(20) unsigned NOT NULL,
  `detalle` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_morph` (`transactionable_type`,`transactionable_id`),
  KEY `inv_stock_movimientos_person_id_foreign` (`person_id`),
  KEY `inv_stock_movimientos_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_stock_movimientos_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_stock_movimientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_stock_movimientos`
--

LOCK TABLES `inv_stock_movimientos` WRITE;
/*!40000 ALTER TABLE `inv_stock_movimientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_stock_movimientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ubicaciones`
--

DROP TABLE IF EXISTS `inv_ubicaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ubicaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_deposito_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ubicaciones_person_id_foreign` (`person_id`),
  KEY `inv_ubicaciones_inv_deposito_id_foreign` (`inv_deposito_id`),
  CONSTRAINT `inv_ubicaciones_inv_deposito_id_foreign` FOREIGN KEY (`inv_deposito_id`) REFERENCES `inv_depositos` (`id`),
  CONSTRAINT `inv_ubicaciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ubicaciones`
--

LOCK TABLES `inv_ubicaciones` WRITE;
/*!40000 ALTER TABLE `inv_ubicaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ubicaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_agrupacion`
--

DROP TABLE IF EXISTS `iva_agrupacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_agrupacion` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `ordr` int(11) NOT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_agrupacion`
--

LOCK TABLES `iva_agrupacion` WRITE;
/*!40000 ALTER TABLE `iva_agrupacion` DISABLE KEYS */;
INSERT INTO `iva_agrupacion` VALUES (1,1,1,0.00,'Operaciones con Responsables Inscriptos',1,NULL,NULL,NULL),(2,1,2,0.00,'Operaciones con Consumidores finales, Exentos y No alcanzados',1,NULL,NULL,NULL),(3,1,3,0.00,'Operaciones no gravadas y exentas',1,NULL,NULL,NULL),(4,1,4,0.00,'Credito fiscal a restituir',1,NULL,NULL,NULL),(5,2,5,0.00,'Debito fiscal a restituir',1,NULL,NULL,NULL),(6,2,6,0.00,'Total Credito Fiscal',1,NULL,NULL,NULL),(7,2,7,0.00,'Total Operaciones que no Generan Credito Fiscal',1,NULL,NULL,NULL),(8,1,8,0.00,'Operaciones con Monotributistas - Regimen Simmplificado',1,'2022-10-29 18:50:03','2022-10-29 18:50:03',NULL);
/*!40000 ALTER TABLE `iva_agrupacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_conditions`
--

DROP TABLE IF EXISTS `iva_conditions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_conditions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `iva_conditions_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_conditions`
--

LOCK TABLES `iva_conditions` WRITE;
/*!40000 ALTER TABLE `iva_conditions` DISABLE KEYS */;
INSERT INTO `iva_conditions` VALUES (1,'Monotributo',NULL,NULL),(2,'Responsable Inscripto',NULL,NULL),(3,'Otro',NULL,NULL);
/*!40000 ALTER TABLE `iva_conditions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_creditos_tipos`
--

DROP TABLE IF EXISTS `iva_creditos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_creditos_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_creditos_tipos`
--

LOCK TABLES `iva_creditos_tipos` WRITE;
/*!40000 ALTER TABLE `iva_creditos_tipos` DISABLE KEYS */;
INSERT INTO `iva_creditos_tipos` VALUES (1,0,'Compras de bienes (excepto bienes de uso)',0.00,1,NULL,NULL,NULL),(2,0,'Locaciones',0.00,1,NULL,NULL,NULL),(3,0,'Prestaciones de servicios',0.00,1,NULL,NULL,NULL),(4,0,'Inversiones de Bienes de Uso',0.00,1,NULL,NULL,NULL),(5,0,'Compras de bienes usados a consumidores finales',0.00,1,NULL,NULL,NULL),(6,0,'Tur IVA',0.00,1,NULL,NULL,NULL),(7,0,'Contribuciones de la Seguridad Social',0.00,1,NULL,NULL,NULL),(8,0,'Contribuciones de la Seguridad Social - Artículo 91 Ley 27.467',0.00,1,NULL,NULL,NULL),(9,0,'Otros Conceptos',0.00,1,NULL,NULL,NULL),(10,0,'Compras de Bienes en el Exterior',0.00,1,NULL,NULL,NULL),(11,0,'Compras de Servicios en el exterior - Impuesto ingresado a través de entidades Financieras',0.00,1,NULL,NULL,NULL),(12,0,'Compras de Servicios en el exterior - Impuesto ingresado por el responsable',0.00,1,NULL,NULL,NULL),(13,0,'Locaciones o prestaciones gravadas en el país realizadas por sujetos del exterior - Impuesto ingresado a través de entidades Financieras',0.00,1,NULL,NULL,NULL),(14,0,'Régimen especial de compensación para la estabilización de precios - Emergencia alimentaria - Ley 27.519',0.00,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `iva_creditos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_per_regimenes`
--

DROP TABLE IF EXISTS `iva_per_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_per_regimenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cod_regimen` int(11) NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_per_regimenes`
--

LOCK TABLES `iva_per_regimenes` WRITE;
/*!40000 ALTER TABLE `iva_per_regimenes` DISABLE KEYS */;
INSERT INTO `iva_per_regimenes` VALUES (1,NULL,493,'Régimen de Percepción de IVA - Comercialización de Bienes y Servicios en el Mercado Interno',NULL,NULL,NULL);
/*!40000 ALTER TABLE `iva_per_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_ret_regimenes`
--

DROP TABLE IF EXISTS `iva_ret_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_ret_regimenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cod_regimen` int(11) NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_ret_regimenes`
--

LOCK TABLES `iva_ret_regimenes` WRITE;
/*!40000 ALTER TABLE `iva_ret_regimenes` DISABLE KEYS */;
INSERT INTO `iva_ret_regimenes` VALUES (1,NULL,15,'USUARIOS DE SISTEMAS DE PAGO ELECTRONICO - INSCRIPTOS EN IVA - PAGOS EFECTUADOS POR CUALQUIER MEDIO EXCEPTO TARJETAS DE CREDITO',NULL,NULL,NULL),(2,NULL,16,'USUARIOS DE SISTEMAS DE PAGO ELECTRONICO - INSCRIPTOS EN IVA - PAGOS EFECTUADOS CON TARJETAS DE CREDITO ? SUJETOS ANEXO I RG N? 2854 Y ESTACIONES DE SERVICIO',NULL,NULL,NULL),(3,NULL,17,'USUARIOS DE SISTEMAS DE PAGO ELECTRONICO - INSCRIPTOS EN IVA - PAGOS EFECTUADOS CON TARJETAS DE CREDITO ? SUJETOS NO COMPRENDIDOS EN ANEXO I RG N? 2854',NULL,NULL,NULL),(4,NULL,18,'USUARIOS DE SISTEMAS DE PAGO ELECTRONICO - NO ACREDITEN CONDICION FRENTE AL IVA',NULL,NULL,NULL),(5,NULL,208,'INGRESOS OBTENIDOS POR LA PRODUCCION, REALIZACION Y DISTRIBUCION DE PROGRAMAS, PELICULAS Y/O GRABACIONES - ART. 8 INC. B) Y ART. 28 INC. F) DE INGRESOS OBTENIDOS POR LA PRODUCCION, REALIZACION Y DISTRIBUCION DE PROGRAMAS',NULL,NULL,NULL),(6,NULL,209,'INGRESOS OBTENIDOS POR LA COMERCIALIZACION DE ESPACIOS PUBLICITARIOS - ART. 8, INC. B) Y ART. 28 INC. G) DE LA LEY DE IVA.',NULL,NULL,NULL),(7,NULL,210,'SERVICIOS DE TRANSPORTE DE PASAJEROS, TERRESTRES, ACUATICOS O AEREOS - ART. 8 INC.B) Y ART. 28 INC. H) DE LA LEY DE IVA.',NULL,NULL,NULL),(8,NULL,211,'SERVICIOS DE ASISTENCIA SANITARIA MEDICA Y PARAMEDICA - ART. 8 INC. B) Y ART 28 INC. I) DE LA LEY DE IVA.',NULL,NULL,NULL),(9,NULL,212,'LOCACIONES O PRESTACIONES DE SERVICIOS, NO COMPRENDIDAS EN EL ART. 8, INC. B).',NULL,NULL,NULL),(10,NULL,214,'COMPRAVENTA DE COSAS MUEBLES Y LOCACIONES COMPRENDIDAS EN EL INCISO C) DEL ARTICULO 3? DE LA LEY DE IVA - ART. 8>, INC. A)',NULL,NULL,NULL),(11,NULL,215,'LOCACIONES VINCULADAS A LA OBTENCION DE CARNES Y DESPOJOS COMESTIBLES DE BOVINOS Y FRUTAS - ART. 8, INC. B) Y ART. 28, INC A) DE LA LEY DE IVA.',NULL,NULL,NULL),(12,NULL,216,'OBRAS, LOCACIONES Y PRESTACIONES OBTENCION DE ANIMALES VIVOS, FRUTAS, LEGUMBRES Y HORTALIZAS ART.8> INC.B Y ART.28> INC.B DE LA LEY DE IVA.',NULL,NULL,NULL),(13,NULL,217,'TRABAJOS SOBRE INMUEBLE AJENO - ART. 8 INC. B) Y ART. 28 INC. C) DE LA LEY DE IVA',NULL,NULL,NULL),(14,NULL,218,'INTERESES Y COMISIONES DE PRESTAMOS - ART. 8 INC. B) Y 28 INC. D) DE LA LEY DE IVA.',NULL,NULL,NULL),(15,NULL,219,'INGRESOS OBTENIDOS POR LAS EMPRESAS DE SERVICIOS COMPLEMENTARIOS (LEY 22.285) ART. 8 INC. B) Y ART 28 INC. E) DE LA LEY DE IVA',NULL,NULL,NULL),(16,NULL,225,'LOCACIONES VINCULADAS A LA OBTENCION DE CARNES Y DESPOJOS COMESTIBLES DE BOVINOS Y FRUTAS- ART. 8C)',NULL,NULL,NULL),(17,NULL,234,'IVA-RETENCION-OPERACIONES DE COMPRA-VENTA DE CHEQUES DE PAGO DIFERIDO Y CERTIFICADOS DE AVAL',NULL,NULL,NULL),(18,NULL,280,'PAGO DE HONORARIOS PROFESIONALES',NULL,NULL,NULL),(19,NULL,499,'FACTURA M-IVA-EMISION DE COMPROBANTES CON DISCRIMINACION DEL GRAVAMEN',NULL,NULL,NULL),(20,NULL,689,'VALES DE ALMUERZO',NULL,NULL,NULL),(21,NULL,690,'VALES DE ALMUERZO Y ALIMENTOS',NULL,NULL,NULL),(22,NULL,777,'IVA -Regimen de Retencion a Sujetos adheridos al Regimen Simplificado para Peque?os Contribuyentes.',NULL,NULL,NULL),(23,NULL,831,'Locacion de obras, locaciones y prestaciones de servicios realizados por empresas de limpieza de edificios, investigacion y seguridad, y recoleccion de residuos domiciliarios.',NULL,NULL,NULL),(24,NULL,966,'FACTURA A CON LEYENDA OPERACION SUJETA A RETENCION - IVA - EMISION DE COMPROBANTES CON DISCRIMINACION DEL GRAVAMEN',NULL,NULL,NULL);
/*!40000 ALTER TABLE `iva_ret_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  `base_de_dato` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `liquidators`
--

DROP TABLE IF EXISTS `liquidators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `liquidators` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `liquidators_name_unique` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `liquidators`
--

LOCK TABLES `liquidators` WRITE;
/*!40000 ALTER TABLE `liquidators` DISABLE KEYS */;
/*!40000 ALTER TABLE `liquidators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `localidad`
--

DROP TABLE IF EXISTS `localidad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `localidad` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `zone_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `localidad_descripcion_unique` (`descripcion`),
  KEY `localidad_zone_id_foreign` (`zone_id`),
  CONSTRAINT `localidad_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `localidad`
--

LOCK TABLES `localidad` WRITE;
/*!40000 ALTER TABLE `localidad` DISABLE KEYS */;
INSERT INTO `localidad` VALUES (1,NULL,22,'Capital Federal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,23,'Vicente Lopez',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,23,'San Isidro',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,23,'Lomas del Mirador',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,23,'Avellaneda',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,23,'Saenz Peña',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,23,'Caseros',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(8,NULL,23,'Moron',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `localidad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `log_debug`
--

DROP TABLE IF EXISTS `log_debug`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_debug` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `function_name` varchar(255) DEFAULT NULL,
  `message` varchar(255) DEFAULT NULL,
  `date` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15522 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `log_debug`
--

LOCK TABLES `log_debug` WRITE;
/*!40000 ALTER TABLE `log_debug` DISABLE KEYS */;
INSERT INTO `log_debug` VALUES (1,NULL,'assingMorePeriods','ejecutando funcion','2018-06-06 12:58:53',NULL),(2,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2, periodo->2018-5','2018-06-06 12:58:53',NULL),(3,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(4,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(5,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(6,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(7,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(8,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(9,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(10,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(11,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(12,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(13,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(14,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(15,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(16,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->3, periodo->2018-5','2018-06-06 12:58:53',NULL),(17,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(18,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(19,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(20,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(21,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(22,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(23,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(24,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(25,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(26,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(27,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(28,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(29,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(30,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->5, periodo->2018-5','2018-06-06 12:58:53',NULL),(31,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(32,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(33,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(34,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (35,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(36,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(37,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(38,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(39,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(40,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(41,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(42,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(43,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(44,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->96, periodo->2018-5','2018-06-06 12:58:53',NULL),(45,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(46,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(47,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(48,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(49,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(50,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(51,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(52,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(53,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(54,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(55,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(56,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(57,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(58,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->338, periodo->2018-5','2018-06-06 12:58:53',NULL),(59,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(60,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(61,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(62,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(63,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(64,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(65,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(66,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(67,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (68,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(69,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(70,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(71,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(72,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->435, periodo->2018-5','2018-06-06 12:58:53',NULL),(73,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(74,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(75,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(76,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(77,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(78,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(79,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(80,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(81,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(82,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(83,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(84,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(85,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(86,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->436, periodo->2018-5','2018-06-06 12:58:53',NULL),(87,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(88,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(89,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(90,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(91,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(92,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(93,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(94,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(95,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(96,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(97,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(98,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(99,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(100,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->448, periodo->2018-5','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (101,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(102,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(103,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(104,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(105,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(106,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(107,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(108,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(109,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(110,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(111,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(112,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(113,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(114,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->639, periodo->2018-5','2018-06-06 12:58:53',NULL),(115,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(116,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(117,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(118,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(119,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(120,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(121,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(122,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(123,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(124,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(125,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(126,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(127,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(128,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->640, periodo->2018-5','2018-06-06 12:58:53',NULL),(129,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(130,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(131,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(132,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(133,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (134,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(135,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(136,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(137,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(138,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(139,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(140,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(141,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(142,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->673, periodo->2018-5','2018-06-06 12:58:53',NULL),(143,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(144,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(145,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(146,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(147,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(148,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(149,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(150,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(151,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(152,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(153,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(154,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(155,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(156,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->784, periodo->2018-5','2018-06-06 12:58:53',NULL),(157,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(158,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(159,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(160,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(161,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(162,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(163,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(164,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(165,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(166,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (167,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(168,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(169,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(170,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1479, periodo->2018-5','2018-06-06 12:58:53',NULL),(171,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(172,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(173,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(174,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(175,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(176,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(177,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(178,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(179,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(180,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(181,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(182,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(183,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(184,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1634, periodo->2018-5','2018-06-06 12:58:54',NULL),(185,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(186,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(187,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(188,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(189,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(190,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(191,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(192,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(193,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(194,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(195,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(196,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(197,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(198,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1717, periodo->2018-5','2018-06-06 12:58:54',NULL),(199,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (200,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(201,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(202,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(203,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(204,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(205,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(206,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(207,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(208,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(209,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(210,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(211,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(212,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1729, periodo->2018-5','2018-06-06 12:58:54',NULL),(213,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(214,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(215,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(216,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(217,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(218,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(219,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(220,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(221,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(222,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(223,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(224,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(225,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(226,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1736, periodo->2018-5','2018-06-06 12:58:54',NULL),(227,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(228,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(229,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(230,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(231,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(232,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (233,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(234,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(235,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(236,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(237,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(238,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(239,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(240,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1845, periodo->2018-5','2018-06-06 12:58:54',NULL),(241,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(242,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(243,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(244,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(245,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(246,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(247,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(248,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(249,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(250,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(251,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(252,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(253,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(254,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1859, periodo->2018-5','2018-06-06 12:58:54',NULL),(255,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(256,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(257,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(258,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(259,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(260,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(261,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(262,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(263,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(264,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(265,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (266,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(267,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(268,NULL,'assingMore