-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db23-28626210-4
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-03-23 19:10:22','Actividad Generica 1','000001',NULL),(2,NULL,'2021-03-23 19:10:22','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'brardamaria@hotmail.com','3534115390',NULL,1,40719,'2021-03-26'),(2,'talabarteriabeyco@gmail.com','3534115390','',1,40733,'2021-05-18'),(3,'talabarteriabeyco@gmail.com','3534115390','',1,40733,'2021-08-21');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1061 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,3598,40720,1530,3,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',2539.05,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-15 13:53:41','2021-04-15 13:53:41'),(2,3598,40720,1530,3,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',7085.01,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-15 13:57:55','2021-04-15 13:57:55'),(3,3598,40720,1530,3,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',2539.03,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-15 13:58:06','2021-04-15 13:58:06'),(4,3598,40720,1530,3,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',707.14,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(5,3598,40720,1530,3,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',10393.28,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(6,3598,40720,1530,3,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',2240.18,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(7,3598,40720,1530,3,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',23259.42,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-15 13:58:20','2021-04-15 13:58:20'),(8,3598,40720,1530,3,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',23259.42,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-19 13:45:18','2021-04-19 13:45:18'),(9,3598,40720,1530,3,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',23259.42,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-19 13:46:56','2021-04-19 13:46:56'),(10,3598,40720,1530,3,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',23259.42,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(11,3598,40720,1530,3,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',23259.40,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-15 13:55:32','2021-04-15 13:55:32'),(12,3598,40720,1530,3,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',20789.95,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(13,3598,40720,1530,3,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',58630.19,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(14,3598,40720,1530,3,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',31685.98,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-15 13:58:34','2021-04-15 13:58:34'),(15,3598,40720,1530,3,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',31685.98,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-15 13:56:01','2021-04-15 13:56:01'),(16,3598,40720,1530,3,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',9626.34,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-15 13:56:21','2021-04-15 13:56:21'),(17,3598,40720,1530,3,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',31220.22,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(18,3598,40720,1530,3,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',413.28,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(19,3598,40720,1530,3,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',3394.29,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(20,3598,40720,1530,3,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',11401.20,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-15 13:56:38','2021-04-15 13:56:38'),(21,3598,40720,1530,3,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',21999.00,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-15 13:56:56','2021-04-15 13:56:56'),(22,3598,40720,1530,3,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',5463.00,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(23,3598,40720,1530,3,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',18951.66,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(24,3598,40720,1530,3,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',14144.75,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL);
INSERT INTO `balance_libro` VALUES (25,3598,40720,1530,3,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',14144.75,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-19 13:27:33','2021-04-19 13:27:33'),(26,3598,40720,1530,3,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',60306.92,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(27,3598,40720,1530,3,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',130028.12,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(28,3598,40720,1530,3,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',9626.34,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-19 13:26:29','2021-04-19 13:26:29'),(29,3598,40720,1530,3,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',2371.95,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-15 13:57:09','2021-04-15 13:57:09'),(30,3598,40720,1530,3,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1472.74,NULL,NULL,1,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(31,3598,40720,1530,2,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(32,3598,40720,1530,2,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',642.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(33,3598,40720,1530,2,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',199.98,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(34,3598,40720,1530,2,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1320.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(35,3598,40720,1530,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1653.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(36,3598,40720,1530,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',499.93,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(37,3598,40720,1530,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',499.95,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(38,3598,40720,1530,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1165.98,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(39,3598,40720,1530,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',2489.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(40,3598,40720,1530,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1469.98,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(41,3598,40720,1530,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',2862.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(42,3598,40720,1530,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1370.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(43,3598,40720,1530,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',2420.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(44,3598,40720,1530,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1133.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(45,3598,40720,1530,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',304.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(46,3598,40720,1530,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2700.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(47,3598,40720,1530,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',6069.70,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(48,3598,40720,1530,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1000.06,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(49,3598,40720,1530,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1430.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL);
INSERT INTO `balance_libro` VALUES (50,3598,40720,1530,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',583.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(51,3598,40720,1530,2,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',6360.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(52,3598,40720,1530,2,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',2401.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(53,3598,40720,1530,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1570.06,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(54,3598,40720,1530,2,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',3420.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(55,3598,40720,1530,2,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',802.02,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(56,3598,40720,1530,2,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',899.99,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(57,3598,40720,1530,2,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',2140.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(58,3598,40720,1530,2,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1860.00,NULL,NULL,1,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(59,3598,40720,1530,2,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1771.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(60,3598,40720,1530,2,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',750.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(61,3598,40720,1530,2,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',190.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(62,3598,40720,1530,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',871.02,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(63,3598,40720,1530,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2024.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(64,3598,40720,1530,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',4781.70,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(65,3598,40720,1530,2,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',459.90,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(66,3598,40720,1530,2,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1022.14,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(67,3598,40720,1530,2,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1010.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(68,3598,40720,1530,2,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1271.50,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(69,3598,40720,1530,2,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',200.08,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(70,3598,40720,1530,2,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',4600.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(71,3598,40720,1530,2,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',3742.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(72,3598,40720,1530,2,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',999.95,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(73,3598,40720,1530,2,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',1621.50,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(74,3598,40720,1530,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',3128.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL);
INSERT INTO `balance_libro` VALUES (75,3598,40720,1530,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',2440.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(76,3598,40720,1530,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',2420.75,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(77,3598,40720,1530,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',329.93,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(78,3598,40720,1530,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',530.11,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(79,3598,40720,1530,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',400.07,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(80,3598,40720,1530,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',2109.91,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(81,3598,40720,1530,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',880.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(82,3598,40720,1530,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',5720.10,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(83,3598,40720,1530,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1063.75,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(84,3598,40720,1530,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1007.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(85,3598,40720,1530,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',349.98,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(86,3598,40720,1530,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',2250.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(87,3598,40720,1530,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1240.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(88,3598,40720,1530,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',170.07,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(89,3598,40720,1530,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',501.88,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(90,3598,40720,1530,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1109.81,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(91,3598,40720,1530,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',2200.02,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(92,3598,40720,1530,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',996.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(93,3598,40720,1530,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1683.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(94,3598,40720,1530,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1656.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(95,3598,40720,1530,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',499.98,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(96,3598,40720,1530,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',210.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(97,3598,40720,1530,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',3919.99,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(98,3598,40720,1530,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',3252.20,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(99,3598,40720,1530,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',4275.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL);
INSERT INTO `balance_libro` VALUES (100,3598,40720,1530,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',850.12,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(101,3598,40720,1530,2,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',5159.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(102,3598,40720,1530,2,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2425.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(103,3598,40720,1530,2,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',459.69,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(104,3598,40720,1530,2,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1050.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(105,3598,40720,1530,2,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',3715.65,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(106,3598,40720,1530,2,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',630.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(107,3598,40720,1530,2,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1289.15,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(108,3598,40720,1530,2,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',2340.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(109,3598,40720,1530,2,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1136.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(110,3598,40720,1530,2,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',2736.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(111,3598,40720,1530,2,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',2080.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(112,3598,40720,1530,2,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',3002.18,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(113,3598,40720,1530,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',400.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(114,3598,40720,1530,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',2317.25,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(115,3598,40720,1530,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',918.97,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(116,3598,40720,1530,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',2080.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(117,3598,40720,1530,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',1397.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(118,3598,40720,1530,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',2093.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(119,3598,40720,1530,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',2871.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(120,3598,40720,1530,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',529.90,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(121,3598,40720,1530,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',2270.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(122,3598,40720,1530,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',2910.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(123,3598,40720,1530,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',2922.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(124,3598,40720,1530,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',657.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL);
INSERT INTO `balance_libro` VALUES (125,3598,40720,1530,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',185.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(126,3598,40720,1530,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',346.11,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(127,3598,40720,1530,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',4352.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(128,3598,40720,1530,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',704.96,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(129,3598,40720,1530,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',5337.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(130,3598,40720,1530,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1000.00,NULL,NULL,1,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(131,3598,40720,1530,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',199.97,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(132,3598,40720,1530,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1959.60,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(133,3598,40720,1530,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',2281.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(134,3598,40720,1530,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1960.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(135,3598,40720,1530,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',680.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(136,3598,40720,1530,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',499.82,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(137,3598,40720,1530,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',2162.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(138,3598,40720,1530,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',2000.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(139,3598,40720,1530,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1183.66,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(140,3598,40720,1530,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1602.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(141,3598,40720,1530,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1895.01,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(142,3598,40720,1530,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',1539.91,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(143,3598,40720,1530,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',300.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(144,3598,40720,1530,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',2600.11,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(145,3598,40720,1530,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1435.20,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(146,3598,40720,1530,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',399.93,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(147,3598,40720,1530,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',499.99,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(148,3598,40720,1530,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1010.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(149,3598,40720,1530,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',300.09,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL);
INSERT INTO `balance_libro` VALUES (150,3598,40720,1530,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',393.31,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(151,3598,40720,1530,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1630.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(152,3598,40720,1530,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',180.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(153,3598,40720,1530,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',2433.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(154,3598,40720,1530,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',2750.80,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(155,3598,40720,1530,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1728.45,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(156,3598,40720,1530,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',200.03,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(157,3598,40720,1530,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',499.93,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(158,3598,40720,1530,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',350.06,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(159,3598,40720,1530,2,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1604.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(160,3598,40720,1530,2,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',2632.25,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(161,3598,40720,1530,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1162.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(162,3598,40720,1530,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',2190.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(163,3598,40720,1530,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',380.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(164,3598,40720,1530,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1264.37,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(165,3598,40720,1530,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',420.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(166,3598,40720,1530,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',2080.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(167,3598,40720,1530,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',2263.20,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(168,3598,40720,1530,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',3220.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(169,3598,40720,1530,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',3220.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(170,3598,40720,1530,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1292.70,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(171,3598,40720,1530,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',2074.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(172,3598,40720,1530,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',919.96,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(173,3598,40720,1530,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',599.85,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(174,3598,40720,1530,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',799.94,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL);
INSERT INTO `balance_libro` VALUES (175,3598,40720,1530,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',2484.06,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(176,3598,40720,1530,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',199.99,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(177,3598,40720,1530,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',4543.19,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(178,3598,40720,1530,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',6694.15,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(179,3598,40720,1530,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',329.97,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(180,3598,40720,1530,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',650.05,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(181,3598,40720,1530,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1370.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(182,3598,40720,1530,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',2081.53,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(183,3598,40720,1530,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1960.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(184,3598,40720,1530,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',2800.02,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(185,3598,40720,1530,2,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',369.97,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(186,3598,40720,1530,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1000.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(187,3598,40720,1530,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',957.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(188,3598,40720,1530,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1400.70,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(189,3598,40720,1530,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',811.98,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(190,3598,40720,1530,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1990.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(191,3598,40720,1530,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',3879.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(192,3598,40720,1530,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',4660.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(193,3598,40720,1530,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',2238.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(194,3598,40720,1530,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',575.12,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(195,3598,40720,1530,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1675.01,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(196,3598,40720,1530,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1669.80,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(197,3598,40720,1530,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',3029.10,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(198,3598,40720,1530,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',876.06,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(199,3598,40720,1530,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',449.96,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL);
INSERT INTO `balance_libro` VALUES (200,3598,40720,1530,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',654.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(201,3598,40720,1530,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',435.00,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(202,3598,40720,1530,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',499.99,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(203,3598,40720,1530,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',450.13,NULL,NULL,1,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(204,3598,40720,1530,2,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',1623.80,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(205,3598,40720,1530,2,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',2219.50,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(206,3598,40720,1530,2,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',1020.95,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(207,3598,40720,1530,2,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',2862.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(208,3598,40720,1530,2,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',200.04,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(209,3598,40720,1530,2,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',1540.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(210,3598,40720,1530,2,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',430.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(211,3598,40720,1530,2,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',1703.80,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(212,3598,40720,1530,2,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',961.40,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(213,3598,40720,1530,2,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',919.93,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(214,3598,40720,1530,2,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',9648.50,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(215,3598,40720,1530,2,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',761.86,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(216,3598,40720,1530,2,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',1564.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(217,3598,40720,1530,2,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',1649.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(218,3598,40720,1530,2,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',2970.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(219,3598,40720,1530,2,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',3330.40,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(220,3598,40720,1530,2,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',2251.70,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(221,3598,40720,1530,2,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',5153.15,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(222,3598,40720,1530,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',4626.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(223,3598,40720,1530,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',1159.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(224,3598,40720,1530,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',1581.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL);
INSERT INTO `balance_libro` VALUES (225,3598,40720,1530,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',800.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(226,3598,40720,1530,2,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',2311.46,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(227,3598,40720,1530,2,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',1618.05,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(228,3598,40720,1530,2,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',2557.60,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(229,3598,40720,1530,2,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',2512.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(230,3598,40720,1530,2,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',2819.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(231,3598,40720,1530,2,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',1771.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(232,3598,40720,1530,2,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',377.20,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(233,3598,40720,1530,2,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',3021.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(234,3598,40720,1530,2,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',803.65,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(235,3598,40720,1530,2,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',220.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(236,3598,40720,1530,2,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',607.05,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(237,3598,40720,1530,2,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',3447.70,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(238,3598,40720,1530,2,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1792.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(239,3598,40720,1530,2,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',809.94,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(240,3598,40720,1530,2,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',2254.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(241,3598,40720,1530,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',3988.20,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(242,3598,40720,1530,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1379.99,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(243,3598,40720,1530,2,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',589.80,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(244,3598,40720,1530,2,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1675.08,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(245,3598,40720,1530,2,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1049.91,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(246,3598,40720,1530,2,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1501.00,NULL,NULL,1,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(247,3598,40720,1530,3,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',23259.42,NULL,NULL,1,'2021-04-19 15:12:28','2021-04-19 15:12:28',NULL),(248,3598,40720,1530,16,NULL,40,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',14787.80,NULL,NULL,1,'2021-04-19 15:28:53','2021-04-19 15:28:53',NULL),(249,3598,40720,1530,15,NULL,38,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',68701.41,NULL,NULL,1,'2021-04-19 15:30:28','2021-04-19 15:30:28',NULL);
INSERT INTO `balance_libro` VALUES (250,3598,40733,3040,2,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',31316.62,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(251,3598,40733,3040,2,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',55950.40,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(252,3598,40733,3040,2,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',57927.54,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(253,3598,40733,3040,2,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',53262.08,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(254,3598,40733,3040,2,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',41672.40,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(255,3598,40733,3040,2,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',27577.11,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(256,3598,40733,3040,2,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',20894.28,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(257,3598,40733,3040,2,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',48400.61,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(258,3598,40733,3040,2,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',433256.23,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(259,3598,40733,3040,2,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',55660.00,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(260,3598,40733,3040,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',25312.71,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(261,3598,40733,3040,2,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',50040.76,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(262,3598,40733,3040,2,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',54527.69,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(263,3598,40733,3040,2,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',110656.92,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(264,3598,40733,3040,2,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',71725.17,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(265,3598,40733,3040,2,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',78931.81,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(266,3598,40733,3040,2,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',115329.94,NULL,NULL,1,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(267,3598,40733,3040,3,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',300.00,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(268,3598,40733,3040,3,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',16000.00,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(269,3598,40733,3040,3,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',500.01,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(270,3598,40733,3040,3,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',33123.75,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(271,3598,40733,3040,3,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',4156.30,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(272,3598,40733,3040,3,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',680.00,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(273,3598,40733,3040,3,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',1140.00,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(274,3598,40733,3040,3,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',70943.35,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL);
INSERT INTO `balance_libro` VALUES (275,3598,40733,3040,3,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',900.00,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(276,3598,40733,3040,3,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',33123.75,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(277,3598,40733,3040,3,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',570.01,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(278,3598,40733,3040,3,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',569.99,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(279,3598,40733,3040,3,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',37849.23,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(280,3598,40733,3040,3,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',569.99,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(281,3598,40733,3040,3,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',28923.84,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(282,3598,40733,3040,3,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',2810.00,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(283,3598,40733,3040,3,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',18634.00,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(284,3598,40733,3040,3,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',11325.60,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(285,3598,40733,3040,3,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',5760.00,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(286,3598,40733,3040,3,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',1060.00,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(287,3598,40733,3040,3,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',59722.42,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(288,3598,40733,3040,3,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',570.01,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(289,3598,40733,3040,3,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',570.01,NULL,NULL,1,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(290,3598,40733,3040,3,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',12.00,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(291,3598,40733,3040,3,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',70895.17,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(292,3598,40733,3040,3,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1060.00,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(293,3598,40733,3040,3,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',570.01,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(294,3598,40733,3040,3,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',810.00,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(295,3598,40733,3040,3,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',570.01,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(296,3598,40733,3040,3,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',2049.99,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(297,3598,40733,3040,3,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1060.01,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(298,3598,40733,3040,3,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',1559.99,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(299,3598,40733,3040,3,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',569.99,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL);
INSERT INTO `balance_libro` VALUES (300,3598,40733,3040,3,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',1060.01,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(301,3598,40733,3040,3,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',1540.00,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(302,3598,40733,3040,3,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',1559.99,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(303,3598,40733,3040,3,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',19500.00,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(304,3598,40733,3040,3,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',810.00,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(305,3598,40733,3040,3,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',174675.60,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(306,3598,40733,3040,3,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',80000.00,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(307,3598,40733,3040,3,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',182105.00,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(308,3598,40733,3040,3,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',3040.00,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(309,3598,40733,3040,3,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',1100.00,NULL,NULL,1,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(310,3598,40733,3041,2,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',67082.40,NULL,NULL,1,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(311,3598,40733,3041,2,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',12724.36,NULL,NULL,1,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(312,3598,40733,3041,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',14075.93,NULL,NULL,1,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(313,3598,40733,3041,2,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',8698.69,NULL,NULL,1,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(314,3598,40733,3041,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',78737.12,NULL,NULL,1,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(315,3598,40733,3041,2,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',86074.56,NULL,NULL,1,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(316,3598,40733,3041,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',101595.23,NULL,NULL,1,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(317,3598,40733,3041,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',66696.41,NULL,NULL,1,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(318,3598,40733,3041,2,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',58256.66,NULL,NULL,1,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(319,3598,40733,3041,2,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',79696.65,NULL,NULL,1,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(320,3598,40733,3041,2,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',203072.36,NULL,NULL,1,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(321,3598,40733,3041,2,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',35846.25,NULL,NULL,1,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(322,3598,40733,3041,3,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',250179.60,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(323,3598,40733,3041,3,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',569.99,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(324,3598,40733,3041,3,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',1060.00,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL);
INSERT INTO `balance_libro` VALUES (325,3598,40733,3041,3,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',569.99,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(326,3598,40733,3041,3,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',2550.00,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(327,3598,40733,3041,3,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',569.99,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(328,3598,40733,3041,3,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',1559.99,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(329,3598,40733,3041,3,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',570.01,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(330,3598,40733,3041,3,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',50426.75,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(331,3598,40733,3041,3,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',570.01,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(332,3598,40733,3041,3,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1540.00,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(333,3598,40733,3041,3,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',569.99,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(334,3598,40733,3041,3,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',570.01,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(335,3598,40733,3041,3,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',109405.05,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(336,3598,40733,3041,3,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',3509.99,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(337,3598,40733,3041,3,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',570.01,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(338,3598,40733,3041,3,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',569.99,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(339,3598,40733,3041,3,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',107329.57,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(340,3598,40733,3041,3,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',909.99,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(341,3598,40733,3041,3,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',12938.65,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(342,3598,40733,3041,3,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1559.99,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(343,3598,40733,3041,3,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',569.99,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(344,3598,40733,3041,3,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',529.53,NULL,NULL,1,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(345,3598,40733,3042,2,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',173932.66,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(346,3598,40733,3042,2,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',53492.89,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(347,3598,40733,3042,2,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',44296.89,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(348,3598,40733,3042,2,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',37374.48,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(349,3598,40733,3042,2,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',33531.52,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL);
INSERT INTO `balance_libro` VALUES (350,3598,40733,3042,2,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',48229.38,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(351,3598,40733,3042,2,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',36239.50,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(352,3598,40733,3042,2,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',68258.52,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(353,3598,40733,3042,2,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',40061.89,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(354,3598,40733,3042,2,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',110404.03,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(355,3598,40733,3042,2,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',3061.30,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(356,3598,40733,3042,2,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',18815.50,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(357,3598,40733,3042,2,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',86378.27,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(358,3598,40733,3042,2,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',112584.09,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(359,3598,40733,3042,2,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',28683.05,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(360,3598,40733,3042,2,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',41298.51,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(361,3598,40733,3042,2,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',6776.00,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(362,3598,40733,3042,2,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',49951.22,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(363,3598,40733,3042,2,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',120641.84,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(364,3598,40733,3042,2,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',139995.31,NULL,NULL,1,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(365,3598,40733,3042,3,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',569.99,NULL,NULL,1,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(366,3598,40733,3042,3,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1489.99,NULL,NULL,1,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(367,3598,40733,3042,3,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',19500.00,NULL,NULL,1,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(368,3598,40733,3042,3,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',96596.85,NULL,NULL,1,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(369,3598,40733,3042,3,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',107329.57,NULL,NULL,1,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(370,3598,40733,3042,3,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',909.99,NULL,NULL,1,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(371,3598,40733,3042,3,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',569.99,NULL,NULL,1,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(372,3598,40733,3042,3,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',135979.80,NULL,NULL,1,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(373,3598,40733,3042,3,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',53953.90,NULL,NULL,1,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(374,3598,40733,3042,3,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',11591.80,NULL,NULL,1,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL);
INSERT INTO `balance_libro` VALUES (375,3598,40733,3042,3,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1060.01,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(376,3598,40733,3042,3,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',2160.00,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(377,3598,40733,3042,3,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1060.00,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(378,3598,40733,3042,3,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',540.00,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(379,3598,40733,3042,3,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',569.99,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(380,3598,40733,3042,3,378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',569.99,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(381,3598,40733,3042,3,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',6220.85,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(382,3598,40733,3042,3,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',7108.99,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(383,3598,40733,3042,3,381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',38000.00,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(384,3598,40733,3042,3,382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1060.00,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(385,3598,40733,3042,3,383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',69550.80,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(386,3598,40733,3042,3,384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',569.99,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(387,3598,40733,3042,3,385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',28459.20,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(388,3598,40733,3042,3,386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',570.01,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(389,3598,40733,3042,3,387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',570.01,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(390,3598,40733,3042,3,388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',3960.03,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(391,3598,40733,3042,3,389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',42487.26,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(392,3598,40733,3042,3,390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',569.99,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(393,3598,40733,3042,3,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',570.01,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(394,3598,40733,3042,3,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',570.01,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(395,3598,40733,3042,3,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',106879.30,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(396,3598,40733,3042,3,394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',27123.53,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(397,3598,40733,3042,3,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',1060.01,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(398,3598,40733,3042,3,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',569.99,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(399,3598,40733,3042,3,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',3010.00,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL);
INSERT INTO `balance_libro` VALUES (400,3598,40733,3042,3,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',570.01,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(401,3598,40733,3042,3,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1060.00,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(402,3598,40733,3042,3,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',16335.00,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(403,3598,40733,3042,3,401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',569.99,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(404,3598,40733,3042,3,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',1060.01,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(405,3598,40733,3042,3,403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',570.01,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(406,3598,40733,3042,3,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',74778.00,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(407,3598,40733,3042,3,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',569.99,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(408,3598,40733,3042,3,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',4530.00,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(409,3598,40733,3042,3,407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',569.99,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(410,3598,40733,3042,3,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1230.00,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(411,3598,40733,3042,3,409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',569.99,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(412,3598,40733,3042,3,410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',28702.74,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(413,3598,40733,3042,3,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',60000.00,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(414,3598,40733,3042,3,412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',19500.00,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(415,3598,40733,3042,3,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',27664.27,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(416,3598,40733,3042,3,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',6390.01,NULL,NULL,1,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(417,3598,40720,1531,2,415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',241.50,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(418,3598,40720,1531,2,416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1507.65,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(419,3598,40720,1531,2,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',439.92,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(420,3598,40720,1531,2,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',879.89,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(421,3598,40720,1531,2,419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',1207.50,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(422,3598,40720,1531,2,420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',6047.85,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(423,3598,40720,1531,2,421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',989.00,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(424,3598,40720,1531,2,422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',2450.00,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL);
INSERT INTO `balance_libro` VALUES (425,3598,40720,1531,2,423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',835.00,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(426,3598,40720,1531,2,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',3597.20,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(427,3598,40720,1531,2,425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',412.00,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(428,3598,40720,1531,2,426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',600.09,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(429,3598,40720,1531,2,427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',1653.70,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(430,3598,40720,1531,2,428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',499.93,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(431,3598,40720,1531,2,429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1959.99,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(432,3598,40720,1531,2,430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',5829.35,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(433,3598,40720,1531,2,431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',3646.00,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(434,3598,40720,1531,2,432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',639.97,NULL,NULL,1,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(435,3598,40720,1531,2,433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2165.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(436,3598,40720,1531,2,434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',399.90,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(437,3598,40720,1531,2,435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',600.07,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(438,3598,40720,1531,2,436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2136.70,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(439,3598,40720,1531,2,437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1390.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(440,3598,40720,1531,2,438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2229.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(441,3598,40720,1531,2,439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',5911.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(442,3598,40720,1531,2,440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',680.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(443,3598,40720,1531,2,441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',369.92,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(444,3598,40720,1531,2,442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',3419.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(445,3598,40720,1531,2,443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',3344.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(446,3598,40720,1531,2,444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1600.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(447,3598,40720,1531,2,445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',7708.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(448,3598,40720,1531,2,446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1500.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(449,3598,40720,1531,2,447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1138.50,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL);
INSERT INTO `balance_libro` VALUES (450,3598,40720,1531,2,448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',4288.35,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(451,3598,40720,1531,2,449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',3573.05,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(452,3598,40720,1531,2,450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1960.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(453,3598,40720,1531,2,451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1400.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(454,3598,40720,1531,2,452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',825.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(455,3598,40720,1531,2,453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',600.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(456,3598,40720,1531,2,454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',5915.60,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(457,3598,40720,1531,2,455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1820.02,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(458,3598,40720,1531,2,456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',2430.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(459,3598,40720,1531,2,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',4636.80,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(460,3598,40720,1531,2,458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1520.01,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(461,3598,40720,1531,2,459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1629.55,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(462,3598,40720,1531,2,460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',2291.99,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(463,3598,40720,1531,2,461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',2739.30,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(464,3598,40720,1531,2,462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',240.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(465,3598,40720,1531,2,463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',399.98,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(466,3598,40720,1531,2,464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',7340.45,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(467,3598,40720,1531,2,465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',4821.95,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(468,3598,40720,1531,2,466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',500.09,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(469,3598,40720,1531,2,467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',1872.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(470,3598,40720,1531,2,468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',2335.01,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(471,3598,40720,1531,2,469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3003.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(472,3598,40720,1531,2,470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3291.30,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(473,3598,40720,1531,2,471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',1757.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(474,3598,40720,1531,2,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',1018.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL);
INSERT INTO `balance_libro` VALUES (475,3598,40720,1531,2,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',600.08,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(476,3598,40720,1531,2,474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',3705.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(477,3598,40720,1531,2,475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',1103.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(478,3598,40720,1531,2,476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',1190.14,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(479,3598,40720,1531,2,477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',770.02,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(480,3598,40720,1531,2,478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',580.07,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(481,3598,40720,1531,2,479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',1930.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(482,3598,40720,1531,2,480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',2257.13,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(483,3598,40720,1531,2,481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',439.88,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(484,3598,40720,1531,2,482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',570.16,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(485,3598,40720,1531,2,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',592.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(486,3598,40720,1531,2,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',400.01,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(487,3598,40720,1531,2,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',1914.75,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(488,3598,40720,1531,2,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',1401.03,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(489,3598,40720,1531,2,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',2587.50,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(490,3598,40720,1531,2,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',300.03,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(491,3598,40720,1531,2,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',349.98,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(492,3598,40720,1531,2,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',399.98,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(493,3598,40720,1531,2,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',300.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(494,3598,40720,1531,2,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',439.92,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(495,3598,40720,1531,2,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',385.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(496,3598,40720,1531,2,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',1960.00,NULL,NULL,1,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(497,3598,40720,1531,2,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',835.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(498,3598,40720,1531,2,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',100.11,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(499,3598,40720,1531,2,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',100.02,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL);
INSERT INTO `balance_libro` VALUES (500,3598,40720,1531,2,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',1820.03,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(501,3598,40720,1531,2,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1035.21,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(502,3598,40720,1531,2,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1040.20,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(503,3598,40720,1531,2,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',5312.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(504,3598,40720,1531,2,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2370.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(505,3598,40720,1531,2,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2862.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(506,3598,40720,1531,2,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1380.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(507,3598,40720,1531,2,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2711.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(508,3598,40720,1531,2,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2336.80,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(509,3598,40720,1531,2,507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1649.92,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(510,3598,40720,1531,2,508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',456.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(511,3598,40720,1531,2,509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1970.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(512,3598,40720,1531,2,510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1878.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(513,3598,40720,1531,2,511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2320.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(514,3598,40720,1531,2,512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',699.93,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(515,3598,40720,1531,2,513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',710.08,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(516,3598,40720,1531,2,514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1499.95,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(517,3598,40720,1531,2,515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',400.02,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(518,3598,40720,1531,2,516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1208.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(519,3598,40720,1531,2,517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1143.10,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(520,3598,40720,1531,2,518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1112.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(521,3598,40720,1531,2,519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2900.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(522,3598,40720,1531,2,520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',1960.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(523,3598,40720,1531,2,521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',200.15,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(524,3598,40720,1531,2,522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',250.14,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL);
INSERT INTO `balance_libro` VALUES (525,3598,40720,1531,2,523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',190.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(526,3598,40720,1531,2,524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',449.84,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(527,3598,40720,1531,2,525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2000.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(528,3598,40720,1531,2,526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',849.85,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(529,3598,40720,1531,2,527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1400.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(530,3598,40720,1531,2,528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',2254.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(531,3598,40720,1531,2,529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1623.80,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(532,3598,40720,1531,2,530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',4350.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(533,3598,40720,1531,2,531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',880.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(534,3598,40720,1531,2,532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',1960.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(535,3598,40720,1531,2,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',2180.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(536,3598,40720,1531,2,534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',2507.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(537,3598,40720,1531,2,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',2800.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(538,3598,40720,1531,2,536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',1771.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(539,3598,40720,1531,2,537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',2229.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(540,3598,40720,1531,2,538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',1370.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(541,3598,40720,1531,2,539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',570.09,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(542,3598,40720,1531,2,540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',1000.04,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(543,3598,40720,1531,2,541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',549.99,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(544,3598,40720,1531,2,542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',599.92,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(545,3598,40720,1531,2,543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',598.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(546,3598,40720,1531,2,544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',282.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(547,3598,40720,1531,2,545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',2793.35,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(548,3598,40720,1531,2,546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',400.03,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(549,3598,40720,1531,2,547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',515.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL);
INSERT INTO `balance_libro` VALUES (550,3598,40720,1531,2,548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',238.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(551,3598,40720,1531,2,549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',1640.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(552,3598,40720,1531,2,550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',3312.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(553,3598,40720,1531,2,551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',3230.35,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(554,3598,40720,1531,2,552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',2756.55,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(555,3598,40720,1531,2,553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',429.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(556,3598,40720,1531,2,554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',580.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(557,3598,40720,1531,2,555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',3078.95,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(558,3598,40720,1531,2,556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',2254.00,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(559,3598,40720,1531,2,557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',499.80,NULL,NULL,1,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(560,3598,40720,1531,2,558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',452.13,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(561,3598,40720,1531,2,559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',2450.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(562,3598,40720,1531,2,560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',2089.95,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(563,3598,40720,1531,2,561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',259.97,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(564,3598,40720,1531,2,562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',1860.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(565,3598,40720,1531,2,563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',1899.80,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(566,3598,40720,1531,2,564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',2110.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(567,3598,40720,1531,2,565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',490.01,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(568,3598,40720,1531,2,566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',950.12,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(569,3598,40720,1531,2,567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',280.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(570,3598,40720,1531,2,568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',900.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(571,3598,40720,1531,2,569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',790.03,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(572,3598,40720,1531,2,570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',7580.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(573,3598,40720,1531,2,571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',462.35,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(574,3598,40720,1531,2,572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1357.98,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL);
INSERT INTO `balance_libro` VALUES (575,3598,40720,1531,2,573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',3990.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(576,3598,40720,1531,2,574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1265.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(577,3598,40720,1531,2,575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1270.12,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(578,3598,40720,1531,2,576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',399.91,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(579,3598,40720,1531,2,577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',700.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(580,3598,40720,1531,2,578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',2620.22,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(581,3598,40720,1531,2,579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1147.65,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(582,3598,40720,1531,2,580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',200.01,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(583,3598,40720,1531,2,581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',726.09,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(584,3598,40720,1531,2,582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',349.97,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(585,3598,40720,1531,2,583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',499.94,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(586,3598,40720,1531,2,584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',600.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(587,3598,40720,1531,2,585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',1895.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(588,3598,40720,1531,2,586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',2219.50,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(589,3598,40720,1531,2,587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',3220.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(590,3598,40720,1531,2,588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',499.92,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(591,3598,40720,1531,2,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',1836.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(592,3598,40720,1531,2,590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',460.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(593,3598,40720,1531,2,591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',4600.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(594,3598,40720,1531,2,592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',2000.10,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(595,3598,40720,1531,2,593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',1049.79,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(596,3598,40720,1531,2,594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',499.98,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(597,3598,40720,1531,2,595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',669.98,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(598,3598,40720,1531,2,596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',499.97,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(599,3598,40720,1531,2,597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',500.03,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL);
INSERT INTO `balance_libro` VALUES (600,3598,40720,1531,2,598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',1944.65,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(601,3598,40720,1531,2,599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',170.01,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(602,3598,40720,1531,2,600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',928.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(603,3598,40720,1531,2,601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',1771.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(604,3598,40720,1531,2,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',499.99,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(605,3598,40720,1531,2,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',1930.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(606,3598,40720,1531,2,604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',1668.91,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(607,3598,40720,1531,2,605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',551.49,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(608,3598,40720,1531,2,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1099.97,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(609,3598,40720,1531,2,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',456.05,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(610,3598,40720,1531,2,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',2495.50,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(611,3598,40720,1531,2,609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',2254.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(612,3598,40720,1531,2,610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',2542.05,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(613,3598,40720,1531,2,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',9259.80,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(614,3598,40720,1531,2,612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',680.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(615,3598,40720,1531,2,613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',2487.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(616,3598,40720,1531,2,614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1265.43,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(617,3598,40720,1531,2,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1599.99,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(618,3598,40720,1531,2,616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1029.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(619,3598,40720,1531,2,617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1894.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(620,3598,40720,1531,2,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1450.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(621,3598,40720,1531,2,619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',673.36,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(622,3598,40720,1531,2,620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',2110.00,NULL,NULL,1,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(623,3598,40720,1531,2,621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',999.86,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(624,3598,40720,1531,2,622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',2020.09,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL);
INSERT INTO `balance_libro` VALUES (625,3598,40720,1531,2,623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',660.00,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(626,3598,40720,1531,2,624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',3290.00,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(627,3598,40720,1531,2,625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',499.93,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(628,3598,40720,1531,2,626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',2587.00,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(629,3598,40720,1531,2,627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',1359.98,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(630,3598,40720,1531,2,628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',1369.81,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(631,3598,40720,1531,2,629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',499.99,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(632,3598,40720,1531,2,630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4295.25,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(633,3598,40720,1531,2,631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',200.03,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(634,3598,40720,1531,2,632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',3163.47,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(635,3598,40720,1531,2,633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',899.91,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(636,3598,40720,1531,2,634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',834.00,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(637,3598,40720,1531,2,635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',248.00,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(638,3598,40720,1531,2,636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',799.97,NULL,NULL,1,'2021-05-16 21:55:04','2021-05-17 15:59:12','2021-05-17 15:59:12'),(639,3598,40720,1531,3,637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',50364.56,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(640,3598,40720,1531,3,638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',14171.73,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(641,3598,40720,1531,3,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2371.95,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(642,3598,40720,1531,3,640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',5201.11,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(643,3598,40720,1531,3,641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',8747.01,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(644,3598,40720,1531,3,642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',36435.29,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(645,3598,40720,1531,3,643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',49746.86,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(646,3598,40720,1531,3,644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',28610.33,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(647,3598,40720,1531,3,645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',51940.30,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(648,3598,40720,1531,3,646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',8996.29,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54');
INSERT INTO `balance_libro` VALUES (649,3598,40720,1531,3,647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',13538.65,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(650,3598,40720,1531,3,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',2085.43,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(651,3598,40720,1531,3,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',14171.70,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(652,3598,40720,1531,3,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',14171.22,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(653,3598,40720,1531,3,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1455.29,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(654,3598,40720,1531,3,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',171.36,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(655,3598,40720,1531,3,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',55712.48,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(656,3598,40720,1531,3,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',257.04,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(657,3598,40720,1531,3,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',55712.48,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(658,3598,40720,1531,3,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',25800.16,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(659,3598,40720,1531,3,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',9102.31,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(660,3598,40720,1531,3,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',57.00,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(661,3598,40720,1531,3,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',71478.09,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(662,3598,40720,1531,3,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',19503.87,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(663,3598,40720,1531,3,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',16063.94,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(664,3598,40720,1531,3,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',3711.68,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(665,3598,40720,1531,3,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',13277.94,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(666,3598,40720,1531,3,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1396.10,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(667,3598,40720,1531,3,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',7555.09,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(668,3598,40720,1531,3,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7140.79,NULL,NULL,1,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(669,3598,40720,1531,3,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2858.98,NULL,NULL,1,'2021-05-16 21:55:23','2021-05-17 16:19:54','2021-05-17 16:19:54'),(670,3598,40733,3043,2,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',227026.25,NULL,NULL,1,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL);
INSERT INTO `balance_libro` VALUES (671,3598,40733,3043,2,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',194369.56,NULL,NULL,1,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(672,3598,40733,3043,2,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',49510.78,NULL,NULL,1,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(673,3598,40733,3043,2,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',14326.40,NULL,NULL,1,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(674,3598,40733,3043,2,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',23400.19,NULL,NULL,1,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(675,3598,40733,3043,2,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',140546.34,NULL,NULL,1,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(676,3598,40733,3043,2,674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',47133.13,NULL,NULL,1,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(677,3598,40733,3043,2,675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',25276.90,NULL,NULL,1,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(678,3598,40733,3043,2,676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',87363.20,NULL,NULL,1,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(679,3598,40733,3043,2,677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',62617.50,NULL,NULL,1,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(680,3598,40733,3043,2,678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',65538.44,NULL,NULL,1,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(681,3598,40733,3043,2,679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',149356.35,NULL,NULL,1,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(682,3598,40733,3043,2,680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',49675.34,NULL,NULL,1,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(683,3598,40733,3043,2,681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',56851.85,NULL,NULL,1,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(684,3598,40733,3043,2,682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',95033.40,NULL,NULL,1,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(685,3598,40733,3043,2,683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',159041.92,NULL,NULL,1,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(686,3598,40733,3043,2,684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',105360.75,NULL,NULL,1,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(687,3598,40733,3043,2,685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',7994.47,NULL,NULL,1,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(688,3598,40733,3043,2,686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',315848.72,NULL,NULL,1,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(689,3598,40733,3043,2,687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',58059.43,NULL,NULL,1,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(690,3598,40733,3043,2,688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',61435.33,NULL,NULL,1,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(691,3598,40733,3043,2,689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',11398.20,NULL,NULL,1,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(692,3598,40733,3043,2,690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',232351.21,NULL,NULL,1,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(693,3598,40733,3043,3,691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',21089.91,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(694,3598,40733,3043,3,692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',74173.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(695,3598,40733,3043,3,693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',5599.28,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL);
INSERT INTO `balance_libro` VALUES (696,3598,40733,3043,3,694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',34630.20,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(697,3598,40733,3043,3,695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1254.28,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(698,3598,40733,3043,3,696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',41809.21,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(699,3598,40733,3043,3,697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',35767.12,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(700,3598,40733,3043,3,698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',245577.97,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(701,3598,40733,3043,3,699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',690.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(702,3598,40733,3043,3,700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',670.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(703,3598,40733,3043,3,701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1400.01,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(704,3598,40733,3043,3,702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',810.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(705,3598,40733,3043,3,703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',670.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(706,3598,40733,3043,3,704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',1800.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(707,3598,40733,3043,3,705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',670.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(708,3598,40733,3043,3,706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',1230.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(709,3598,40733,3043,3,707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',25116.70,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(710,3598,40733,3043,3,708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',74252.86,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(711,3598,40733,3043,3,709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',670.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(712,3598,40733,3043,3,710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',45969.11,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(713,3598,40733,3043,3,711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',112579.84,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(714,3598,40733,3043,3,712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',199786.53,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(715,3598,40733,3043,3,713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',8893.50,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(716,3598,40733,3043,3,714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',3510.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(717,3598,40733,3043,3,715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',60681.50,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(718,3598,40733,3043,3,716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',830.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(719,3598,40733,3043,3,717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',850.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(720,3598,40733,3043,3,718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',670.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL);
INSERT INTO `balance_libro` VALUES (721,3598,40733,3043,3,719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',670.00,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(722,3598,40733,3043,3,720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',65678.80,NULL,NULL,1,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(723,3598,40733,3043,3,721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',670.00,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(724,3598,40733,3043,3,722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',670.00,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(725,3598,40733,3043,3,723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',14113.44,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(726,3598,40733,3043,3,724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',9869.61,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(727,3598,40733,3043,3,725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',13153.04,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(728,3598,40733,3043,3,726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',193801.48,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(729,3598,40733,3043,3,727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',53389.72,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(730,3598,40733,3043,3,728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',2130.00,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(731,3598,40733,3043,3,729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',670.00,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(732,3598,40733,3043,3,730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',71163.68,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(733,3598,40733,3043,3,731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',12035.63,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(734,3598,40733,3043,3,732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',326822.21,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(735,3598,40733,3043,3,733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',3000.00,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(736,3598,40733,3043,3,734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2940.00,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(737,3598,40733,3043,3,735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',19500.00,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(738,3598,40733,3043,3,736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',597.11,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(739,3598,40733,3043,3,737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',3772.30,NULL,NULL,1,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(743,3598,40720,1531,3,741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',23259.42,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(744,3598,40720,1531,3,742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',14144.75,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(745,3598,40720,1531,3,743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',9626.34,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(746,3598,40720,1531,3,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',50364.56,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(747,3598,40720,1531,3,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',14171.73,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(748,3598,40720,1531,3,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2371.95,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL);
INSERT INTO `balance_libro` VALUES (749,3598,40720,1531,3,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',5201.11,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(750,3598,40720,1531,3,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',8747.01,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(751,3598,40720,1531,3,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',36435.29,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(752,3598,40720,1531,3,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',49746.86,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(753,3598,40720,1531,3,751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',28610.33,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(754,3598,40720,1531,3,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',51940.30,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(755,3598,40720,1531,3,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',8996.29,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(756,3598,40720,1531,3,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',13538.65,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(757,3598,40720,1531,3,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',2085.43,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(758,3598,40720,1531,3,756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',14171.70,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(759,3598,40720,1531,3,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',14171.22,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(760,3598,40720,1531,3,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1455.29,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(761,3598,40720,1531,3,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',171.36,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(762,3598,40720,1531,3,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',55712.48,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(763,3598,40720,1531,3,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',257.04,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(764,3598,40720,1531,3,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',55712.48,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(765,3598,40720,1531,3,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',25800.16,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(766,3598,40720,1531,3,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',9102.31,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(767,3598,40720,1531,3,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',57.00,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(768,3598,40720,1531,3,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',71478.09,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(769,3598,40720,1531,3,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',19503.87,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(770,3598,40720,1531,3,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',16063.94,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(771,3598,40720,1531,3,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',3711.68,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(772,3598,40720,1531,3,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',13277.94,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(773,3598,40720,1531,3,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',1396.10,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL);
INSERT INTO `balance_libro` VALUES (774,3598,40720,1531,3,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',7555.09,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(775,3598,40720,1531,3,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7140.79,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(776,3598,40720,1531,3,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2858.98,NULL,NULL,1,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(777,3598,40719,6,8,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',9730.83,NULL,NULL,1,'2021-05-19 15:02:01','2021-05-19 15:02:01',NULL),(778,3598,40719,6,8,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',442.88,NULL,NULL,1,'2021-05-19 15:02:25','2021-05-19 15:02:25',NULL),(779,3598,40720,1531,8,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',442.88,NULL,NULL,1,'2021-05-19 15:04:25','2021-05-19 15:07:20','2021-05-19 15:07:20'),(780,3598,40720,1531,8,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',3277.47,NULL,NULL,1,'2021-05-19 15:05:00','2021-05-19 15:07:13','2021-05-19 15:07:13'),(781,3598,40720,1531,8,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',11326.31,NULL,NULL,1,'2021-05-19 15:10:10','2021-05-19 15:11:35','2021-05-19 15:11:35'),(782,3598,40720,1531,8,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',11416.66,NULL,NULL,1,'2021-05-19 15:11:58','2021-05-19 15:11:58',NULL),(1019,3598,40720,1532,3,1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',24629.79,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1020,3598,40720,1532,3,1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',31052.29,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1021,3598,40720,1532,3,1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',11133.51,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1022,3598,40720,1532,3,1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',285.00,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1023,3598,40720,1532,3,1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',9404.47,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1024,3598,40720,1532,3,1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6269.65,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1025,3598,40720,1532,3,1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',2291.14,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1026,3598,40720,1532,3,1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',85820.06,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1027,3598,40720,1532,3,1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',1438.91,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1028,3598,40720,1532,3,1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',444.00,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1029,3598,40720,1532,3,1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',34341.80,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1030,3598,40720,1532,3,1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',49003.60,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1031,3598,40720,1532,3,1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',9435.68,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1032,3598,40720,1532,3,1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',954.24,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1033,3598,40720,1532,3,1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',1011.39,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL);
INSERT INTO `balance_libro` VALUES (1034,3598,40720,1532,3,1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',51950.77,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1035,3598,40720,1532,3,1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',3524.45,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1036,3598,40720,1532,3,1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',18373.77,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1037,3598,40720,1532,3,1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',26589.80,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1038,3598,40720,1532,3,1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',43478.11,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1039,3598,40720,1532,3,1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',2700.00,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1040,3598,40720,1532,3,1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',16186.65,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1041,3598,40720,1532,3,1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',3788.63,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1042,3598,40720,1532,3,1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',51358.93,NULL,NULL,1,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1043,3598,40720,1532,3,1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',12415.46,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1044,3598,40720,1532,3,1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',3134.83,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1045,3598,40720,1532,3,1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',2812.97,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1046,3598,40720,1532,3,1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',16071.57,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1047,3598,40720,1532,3,1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',127603.65,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1048,3598,40720,1532,3,1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',25962.37,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1049,3598,40720,1532,3,1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',3600.00,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1050,3598,40720,1532,3,1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',4249.99,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1051,3598,40720,1532,3,1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',61218.87,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1052,3598,40720,1532,3,1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',8500.00,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1053,3598,40720,1532,3,1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',1269.53,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1054,3598,40720,1532,3,1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',30703.39,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1055,3598,40720,1532,3,1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',81306.63,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1056,3598,40720,1532,3,1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1500.00,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1057,3598,40720,1532,3,1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',63665.24,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL);
INSERT INTO `balance_libro` VALUES (1058,3598,40720,1532,3,1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',642.86,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1059,3598,40720,1532,3,1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',24629.92,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1060,3598,40720,1532,3,1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',24629.79,NULL,NULL,1,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3189 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,3598,1,40720,1530,3,217,1,2098.39,NULL,'2021-04-12 15:40:35','2021-04-15 13:53:41','2021-04-15 13:53:41'),(2,3598,1,40720,1530,3,68,1,440.66,NULL,'2021-04-12 15:40:35','2021-04-15 13:53:41','2021-04-15 13:53:41'),(3,3598,1,40720,1530,3,57,2,2539.05,NULL,'2021-04-12 15:40:35','2021-04-15 13:53:41','2021-04-15 13:53:41'),(4,3598,2,40720,1530,3,217,2,5855.38,NULL,'2021-04-12 15:40:35','2021-04-15 13:57:55','2021-04-15 13:57:55'),(5,3598,2,40720,1530,3,67,2,1229.63,NULL,'2021-04-12 15:40:35','2021-04-15 13:57:55','2021-04-15 13:57:55'),(6,3598,2,40720,1530,3,57,1,7085.01,NULL,'2021-04-12 15:40:35','2021-04-15 13:57:55','2021-04-15 13:57:55'),(7,3598,3,40720,1530,3,217,2,2098.37,NULL,'2021-04-12 15:40:35','2021-04-15 13:58:06','2021-04-15 13:58:06'),(8,3598,3,40720,1530,3,67,2,440.66,NULL,'2021-04-12 15:40:35','2021-04-15 13:58:06','2021-04-15 13:58:06'),(9,3598,3,40720,1530,3,57,1,2539.03,NULL,'2021-04-12 15:40:35','2021-04-15 13:58:06','2021-04-15 13:58:06'),(10,3598,4,40720,1530,3,217,2,584.41,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(11,3598,4,40720,1530,3,67,2,122.73,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(12,3598,4,40720,1530,3,57,1,707.14,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(13,3598,5,40720,1530,3,217,1,8589.49,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(14,3598,5,40720,1530,3,68,1,1803.79,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(15,3598,5,40720,1530,3,57,2,10393.28,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(16,3598,6,40720,1530,3,217,2,1851.39,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(17,3598,6,40720,1530,3,67,2,388.79,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(18,3598,6,40720,1530,3,57,1,2240.18,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(19,3598,7,40720,1530,3,217,2,19222.66,NULL,'2021-04-12 15:40:35','2021-04-15 13:58:20','2021-04-15 13:58:20'),(20,3598,7,40720,1530,3,67,2,4036.76,NULL,'2021-04-12 15:40:35','2021-04-15 13:58:20','2021-04-15 13:58:20'),(21,3598,7,40720,1530,3,57,1,23259.42,NULL,'2021-04-12 15:40:35','2021-04-15 13:58:20','2021-04-15 13:58:20'),(22,3598,8,40720,1530,3,217,1,19222.66,NULL,'2021-04-12 15:40:35','2021-04-19 13:45:18','2021-04-19 13:45:18'),(23,3598,8,40720,1530,3,68,1,4036.76,NULL,'2021-04-12 15:40:35','2021-04-19 13:45:18','2021-04-19 13:45:18'),(24,3598,8,40720,1530,3,57,2,23259.42,NULL,'2021-04-12 15:40:35','2021-04-19 13:45:18','2021-04-19 13:45:18'),(25,3598,9,40720,1530,3,217,2,19222.66,NULL,'2021-04-12 15:40:35','2021-04-19 13:46:56','2021-04-19 13:46:56'),(26,3598,9,40720,1530,3,67,2,4036.76,NULL,'2021-04-12 15:40:35','2021-04-19 13:46:56','2021-04-19 13:46:56'),(27,3598,9,40720,1530,3,57,1,23259.42,NULL,'2021-04-12 15:40:35','2021-04-19 13:46:56','2021-04-19 13:46:56'),(28,3598,10,40720,1530,3,217,1,19222.66,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(29,3598,10,40720,1530,3,68,1,4036.76,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(30,3598,10,40720,1530,3,57,2,23259.42,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(31,3598,11,40720,1530,3,217,1,19222.65,NULL,'2021-04-12 15:40:35','2021-04-15 13:55:32','2021-04-15 13:55:32'),(32,3598,11,40720,1530,3,68,1,4036.76,NULL,'2021-04-12 15:40:35','2021-04-15 13:55:32','2021-04-15 13:55:32'),(33,3598,11,40720,1530,3,57,2,23259.40,NULL,'2021-04-12 15:40:35','2021-04-15 13:55:32','2021-04-15 13:55:32'),(34,3598,11,40720,1530,3,136,2,0.01,NULL,'2021-04-12 15:40:35','2021-04-15 13:55:32','2021-04-15 13:55:32'),(35,3598,12,40720,1530,3,217,1,17181.78,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(36,3598,12,40720,1530,3,68,1,3608.17,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(37,3598,12,40720,1530,3,57,2,20789.95,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(38,3598,13,40720,1530,3,217,1,48454.70,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(39,3598,13,40720,1530,3,68,1,10175.49,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL);
INSERT INTO `balance_libro_details` VALUES (40,3598,13,40720,1530,3,57,2,58630.19,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(41,3598,14,40720,1530,3,217,2,26186.76,NULL,'2021-04-12 15:40:35','2021-04-15 13:58:34','2021-04-15 13:58:34'),(42,3598,14,40720,1530,3,67,2,5499.22,NULL,'2021-04-12 15:40:35','2021-04-15 13:58:34','2021-04-15 13:58:34'),(43,3598,14,40720,1530,3,57,1,31685.98,NULL,'2021-04-12 15:40:35','2021-04-15 13:58:34','2021-04-15 13:58:34'),(44,3598,15,40720,1530,3,217,1,26186.76,NULL,'2021-04-12 15:40:35','2021-04-15 13:56:01','2021-04-15 13:56:01'),(45,3598,15,40720,1530,3,68,1,5499.22,NULL,'2021-04-12 15:40:35','2021-04-15 13:56:01','2021-04-15 13:56:01'),(46,3598,15,40720,1530,3,57,2,31685.98,NULL,'2021-04-12 15:40:35','2021-04-15 13:56:01','2021-04-15 13:56:01'),(47,3598,16,40720,1530,3,217,1,7955.65,NULL,'2021-04-12 15:40:35','2021-04-15 13:56:21','2021-04-15 13:56:21'),(48,3598,16,40720,1530,3,68,1,1670.69,NULL,'2021-04-12 15:40:35','2021-04-15 13:56:21','2021-04-15 13:56:21'),(49,3598,16,40720,1530,3,57,2,9626.34,NULL,'2021-04-12 15:40:35','2021-04-15 13:56:21','2021-04-15 13:56:21'),(50,3598,17,40720,1530,3,217,1,25801.84,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(51,3598,17,40720,1530,3,68,1,5418.38,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(52,3598,17,40720,1530,3,57,2,31220.22,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(53,3598,18,40720,1530,3,217,2,341.55,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(54,3598,18,40720,1530,3,67,2,71.73,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(55,3598,18,40720,1530,3,57,1,413.28,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(56,3598,19,40720,1530,3,217,1,2805.20,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(57,3598,19,40720,1530,3,68,1,589.09,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(58,3598,19,40720,1530,3,57,2,3394.29,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(59,3598,20,40720,1530,3,217,1,9422.48,NULL,'2021-04-12 15:40:35','2021-04-15 13:56:38','2021-04-15 13:56:38'),(60,3598,20,40720,1530,3,68,1,1978.72,NULL,'2021-04-12 15:40:35','2021-04-15 13:56:38','2021-04-15 13:56:38'),(61,3598,20,40720,1530,3,57,2,11401.20,NULL,'2021-04-12 15:40:35','2021-04-15 13:56:38','2021-04-15 13:56:38'),(62,3598,21,40720,1530,3,217,1,18180.99,NULL,'2021-04-12 15:40:35','2021-04-15 13:56:56','2021-04-15 13:56:56'),(63,3598,21,40720,1530,3,68,1,3818.01,NULL,'2021-04-12 15:40:35','2021-04-15 13:56:56','2021-04-15 13:56:56'),(64,3598,21,40720,1530,3,57,2,21999.00,NULL,'2021-04-12 15:40:35','2021-04-15 13:56:56','2021-04-15 13:56:56'),(65,3598,22,40720,1530,3,250,1,5463.00,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(66,3598,22,40720,1530,3,57,2,5463.00,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(67,3598,23,40720,1530,3,217,1,15662.53,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(68,3598,23,40720,1530,3,68,1,3289.13,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(69,3598,23,40720,1530,3,57,2,18951.66,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(70,3598,24,40720,1530,3,217,1,11689.88,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(71,3598,24,40720,1530,3,68,1,2454.87,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(72,3598,24,40720,1530,3,57,2,14144.75,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(73,3598,25,40720,1530,3,217,2,11689.88,NULL,'2021-04-12 15:40:35','2021-04-19 13:27:33','2021-04-19 13:27:33'),(74,3598,25,40720,1530,3,67,2,2454.87,NULL,'2021-04-12 15:40:35','2021-04-19 13:27:33','2021-04-19 13:27:33'),(75,3598,25,40720,1530,3,57,1,14144.75,NULL,'2021-04-12 15:40:35','2021-04-19 13:27:33','2021-04-19 13:27:33'),(76,3598,26,40720,1530,3,217,1,49840.43,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(77,3598,26,40720,1530,3,68,1,10466.49,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(78,3598,26,40720,1530,3,57,2,60306.92,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL);
INSERT INTO `balance_libro_details` VALUES (79,3598,27,40720,1530,3,217,1,107461.26,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(80,3598,27,40720,1530,3,68,1,22566.86,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(81,3598,27,40720,1530,3,57,2,130028.12,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(82,3598,28,40720,1530,3,217,2,7955.65,NULL,'2021-04-12 15:40:35','2021-04-19 13:26:29','2021-04-19 13:26:29'),(83,3598,28,40720,1530,3,67,2,1670.69,NULL,'2021-04-12 15:40:35','2021-04-19 13:26:29','2021-04-19 13:26:29'),(84,3598,28,40720,1530,3,57,1,9626.34,NULL,'2021-04-12 15:40:35','2021-04-19 13:26:29','2021-04-19 13:26:29'),(85,3598,29,40720,1530,3,217,1,1960.29,NULL,'2021-04-12 15:40:35','2021-04-15 13:57:09','2021-04-15 13:57:09'),(86,3598,29,40720,1530,3,68,1,411.66,NULL,'2021-04-12 15:40:35','2021-04-15 13:57:09','2021-04-15 13:57:09'),(87,3598,29,40720,1530,3,57,2,2371.95,NULL,'2021-04-12 15:40:35','2021-04-15 13:57:09','2021-04-15 13:57:09'),(88,3598,30,40720,1530,3,217,1,1217.14,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(89,3598,30,40720,1530,3,68,1,255.60,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(90,3598,30,40720,1530,3,57,2,1472.74,NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(91,3598,31,40720,1530,2,96,2,0.83,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(92,3598,31,40720,1530,2,67,2,0.17,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(93,3598,31,40720,1530,2,13,1,1.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(94,3598,32,40720,1530,2,96,2,530.58,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(95,3598,32,40720,1530,2,67,2,111.42,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(96,3598,32,40720,1530,2,13,1,642.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(97,3598,33,40720,1530,2,96,2,165.27,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(98,3598,33,40720,1530,2,67,2,34.71,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(99,3598,33,40720,1530,2,13,1,199.98,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(100,3598,34,40720,1530,2,96,2,1090.91,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(101,3598,34,40720,1530,2,67,2,229.09,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(102,3598,34,40720,1530,2,13,1,1320.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(103,3598,35,40720,1530,2,96,2,1366.12,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(104,3598,35,40720,1530,2,67,2,286.88,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(105,3598,35,40720,1530,2,13,1,1653.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(106,3598,36,40720,1530,2,96,2,413.17,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(107,3598,36,40720,1530,2,67,2,86.76,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(108,3598,36,40720,1530,2,13,1,499.93,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(109,3598,37,40720,1530,2,96,2,413.18,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(110,3598,37,40720,1530,2,67,2,86.77,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(111,3598,37,40720,1530,2,13,1,499.95,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(112,3598,38,40720,1530,2,96,2,963.62,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(113,3598,38,40720,1530,2,67,2,202.36,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(114,3598,38,40720,1530,2,13,1,1165.98,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(115,3598,39,40720,1530,2,96,2,2057.02,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(116,3598,39,40720,1530,2,67,2,431.98,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(117,3598,39,40720,1530,2,13,1,2489.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(118,3598,40,40720,1530,2,96,2,1214.86,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(119,3598,40,40720,1530,2,67,2,255.12,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(120,3598,40,40720,1530,2,13,1,1469.98,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL);
INSERT INTO `balance_libro_details` VALUES (121,3598,41,40720,1530,2,96,2,2365.29,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(122,3598,41,40720,1530,2,67,2,496.71,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(123,3598,41,40720,1530,2,13,1,2862.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(124,3598,42,40720,1530,2,96,2,1132.23,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(125,3598,42,40720,1530,2,67,2,237.77,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(126,3598,42,40720,1530,2,13,1,1370.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(127,3598,43,40720,1530,2,96,2,2000.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(128,3598,43,40720,1530,2,67,2,420.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(129,3598,43,40720,1530,2,13,1,2420.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(130,3598,44,40720,1530,2,96,2,936.36,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(131,3598,44,40720,1530,2,67,2,196.64,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(132,3598,44,40720,1530,2,13,1,1133.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(133,3598,45,40720,1530,2,96,2,251.24,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(134,3598,45,40720,1530,2,67,2,52.76,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(135,3598,45,40720,1530,2,13,1,304.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(136,3598,46,40720,1530,2,96,2,2231.40,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(137,3598,46,40720,1530,2,67,2,468.60,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(138,3598,46,40720,1530,2,13,1,2700.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(139,3598,47,40720,1530,2,96,2,5016.28,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(140,3598,47,40720,1530,2,67,2,1053.42,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(141,3598,47,40720,1530,2,13,1,6069.70,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(142,3598,48,40720,1530,2,96,2,826.50,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(143,3598,48,40720,1530,2,67,2,173.56,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(144,3598,48,40720,1530,2,13,1,1000.06,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(145,3598,49,40720,1530,2,96,2,1181.82,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(146,3598,49,40720,1530,2,67,2,248.18,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(147,3598,49,40720,1530,2,13,1,1430.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(148,3598,50,40720,1530,2,96,2,481.82,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(149,3598,50,40720,1530,2,67,2,101.18,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(150,3598,50,40720,1530,2,13,1,583.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(151,3598,51,40720,1530,2,96,2,5256.20,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(152,3598,51,40720,1530,2,67,2,1103.80,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(153,3598,51,40720,1530,2,13,1,6360.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(154,3598,52,40720,1530,2,96,2,1984.30,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(155,3598,52,40720,1530,2,67,2,416.70,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(156,3598,52,40720,1530,2,13,1,2401.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(157,3598,53,40720,1530,2,96,2,1297.57,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(158,3598,53,40720,1530,2,67,2,272.49,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(159,3598,53,40720,1530,2,13,1,1570.06,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(160,3598,54,40720,1530,2,96,2,2826.45,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(161,3598,54,40720,1530,2,67,2,593.55,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(162,3598,54,40720,1530,2,13,1,3420.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL);
INSERT INTO `balance_libro_details` VALUES (163,3598,55,40720,1530,2,96,2,662.83,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(164,3598,55,40720,1530,2,67,2,139.19,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(165,3598,55,40720,1530,2,13,1,802.02,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(166,3598,56,40720,1530,2,96,2,743.79,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(167,3598,56,40720,1530,2,67,2,156.20,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(168,3598,56,40720,1530,2,13,1,899.99,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(169,3598,57,40720,1530,2,96,2,1768.60,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(170,3598,57,40720,1530,2,67,2,371.40,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(171,3598,57,40720,1530,2,13,1,2140.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(172,3598,58,40720,1530,2,96,2,1537.19,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(173,3598,58,40720,1530,2,67,2,322.81,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(174,3598,58,40720,1530,2,13,1,1860.00,NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(175,3598,59,40720,1530,2,96,2,1463.64,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(176,3598,59,40720,1530,2,67,2,307.36,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(177,3598,59,40720,1530,2,13,1,1771.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(178,3598,60,40720,1530,2,96,2,619.83,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(179,3598,60,40720,1530,2,67,2,130.17,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(180,3598,60,40720,1530,2,13,1,750.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(181,3598,61,40720,1530,2,96,2,157.02,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(182,3598,61,40720,1530,2,67,2,32.98,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(183,3598,61,40720,1530,2,13,1,190.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(184,3598,62,40720,1530,2,96,2,719.85,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(185,3598,62,40720,1530,2,67,2,151.17,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(186,3598,62,40720,1530,2,13,1,871.02,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(187,3598,63,40720,1530,2,96,2,1672.73,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(188,3598,63,40720,1530,2,67,2,351.27,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(189,3598,63,40720,1530,2,13,1,2024.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(190,3598,64,40720,1530,2,96,2,3951.82,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(191,3598,64,40720,1530,2,67,2,829.88,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(192,3598,64,40720,1530,2,13,1,4781.70,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(193,3598,65,40720,1530,2,96,2,380.08,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(194,3598,65,40720,1530,2,67,2,79.82,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(195,3598,65,40720,1530,2,13,1,459.90,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(196,3598,66,40720,1530,2,96,2,844.74,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(197,3598,66,40720,1530,2,67,2,177.40,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(198,3598,66,40720,1530,2,13,1,1022.14,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(199,3598,67,40720,1530,2,96,2,834.71,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(200,3598,67,40720,1530,2,67,2,175.29,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(201,3598,67,40720,1530,2,13,1,1010.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(202,3598,68,40720,1530,2,96,2,1050.83,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(203,3598,68,40720,1530,2,67,2,220.67,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(204,3598,68,40720,1530,2,13,1,1271.50,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL);
INSERT INTO `balance_libro_details` VALUES (205,3598,69,40720,1530,2,96,2,165.36,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(206,3598,69,40720,1530,2,67,2,34.72,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(207,3598,69,40720,1530,2,13,1,200.08,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(208,3598,70,40720,1530,2,96,2,3801.65,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(209,3598,70,40720,1530,2,67,2,798.35,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(210,3598,70,40720,1530,2,13,1,4600.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(211,3598,71,40720,1530,2,96,2,3092.56,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(212,3598,71,40720,1530,2,67,2,649.44,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(213,3598,71,40720,1530,2,13,1,3742.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(214,3598,72,40720,1530,2,96,2,826.40,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(215,3598,72,40720,1530,2,67,2,173.55,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(216,3598,72,40720,1530,2,13,1,999.95,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(217,3598,73,40720,1530,2,96,2,1340.08,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(218,3598,73,40720,1530,2,67,2,281.42,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(219,3598,73,40720,1530,2,13,1,1621.50,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(220,3598,74,40720,1530,2,96,2,2585.12,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(221,3598,74,40720,1530,2,67,2,542.88,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(222,3598,74,40720,1530,2,13,1,3128.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(223,3598,75,40720,1530,2,96,2,2016.53,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(224,3598,75,40720,1530,2,67,2,423.47,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(225,3598,75,40720,1530,2,13,1,2440.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(226,3598,76,40720,1530,2,96,2,2000.62,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(227,3598,76,40720,1530,2,67,2,420.13,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(228,3598,76,40720,1530,2,13,1,2420.75,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(229,3598,77,40720,1530,2,96,2,272.67,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(230,3598,77,40720,1530,2,67,2,57.26,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(231,3598,77,40720,1530,2,13,1,329.93,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(232,3598,78,40720,1530,2,96,2,438.11,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(233,3598,78,40720,1530,2,67,2,92.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(234,3598,78,40720,1530,2,13,1,530.11,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(235,3598,79,40720,1530,2,96,2,330.64,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(236,3598,79,40720,1530,2,67,2,69.43,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(237,3598,79,40720,1530,2,13,1,400.07,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(238,3598,80,40720,1530,2,96,2,1743.73,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(239,3598,80,40720,1530,2,67,2,366.18,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(240,3598,80,40720,1530,2,13,1,2109.91,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(241,3598,81,40720,1530,2,96,2,727.27,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(242,3598,81,40720,1530,2,67,2,152.73,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(243,3598,81,40720,1530,2,13,1,880.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(244,3598,82,40720,1530,2,96,2,4727.36,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(245,3598,82,40720,1530,2,67,2,992.74,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(246,3598,82,40720,1530,2,13,1,5720.10,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL);
INSERT INTO `balance_libro_details` VALUES (247,3598,83,40720,1530,2,96,2,879.13,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(248,3598,83,40720,1530,2,67,2,184.62,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(249,3598,83,40720,1530,2,13,1,1063.75,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(250,3598,84,40720,1530,2,96,2,832.23,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(251,3598,84,40720,1530,2,67,2,174.77,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(252,3598,84,40720,1530,2,13,1,1007.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(253,3598,85,40720,1530,2,96,2,289.24,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(254,3598,85,40720,1530,2,67,2,60.74,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(255,3598,85,40720,1530,2,13,1,349.98,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(256,3598,86,40720,1530,2,96,2,1859.50,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(257,3598,86,40720,1530,2,67,2,390.50,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(258,3598,86,40720,1530,2,13,1,2250.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(259,3598,87,40720,1530,2,96,2,1024.79,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(260,3598,87,40720,1530,2,67,2,215.21,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(261,3598,87,40720,1530,2,13,1,1240.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(262,3598,88,40720,1530,2,96,2,140.55,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(263,3598,88,40720,1530,2,67,2,29.52,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(264,3598,88,40720,1530,2,13,1,170.07,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(265,3598,89,40720,1530,2,96,2,414.78,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(266,3598,89,40720,1530,2,67,2,87.10,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(267,3598,89,40720,1530,2,13,1,501.88,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(268,3598,90,40720,1530,2,96,2,917.20,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(269,3598,90,40720,1530,2,67,2,192.61,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(270,3598,90,40720,1530,2,13,1,1109.81,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(271,3598,91,40720,1530,2,96,2,1818.20,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(272,3598,91,40720,1530,2,67,2,381.82,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(273,3598,91,40720,1530,2,13,1,2200.02,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(274,3598,92,40720,1530,2,96,2,823.14,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(275,3598,92,40720,1530,2,67,2,172.86,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(276,3598,92,40720,1530,2,13,1,996.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(277,3598,93,40720,1530,2,96,2,1390.91,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(278,3598,93,40720,1530,2,67,2,292.09,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(279,3598,93,40720,1530,2,13,1,1683.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(280,3598,94,40720,1530,2,96,2,1368.60,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(281,3598,94,40720,1530,2,67,2,287.40,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(282,3598,94,40720,1530,2,13,1,1656.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(283,3598,95,40720,1530,2,96,2,413.21,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(284,3598,95,40720,1530,2,67,2,86.77,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(285,3598,95,40720,1530,2,13,1,499.98,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(286,3598,96,40720,1530,2,96,2,173.55,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(287,3598,96,40720,1530,2,67,2,36.45,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(288,3598,96,40720,1530,2,13,1,210.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL);
INSERT INTO `balance_libro_details` VALUES (289,3598,97,40720,1530,2,96,2,3239.66,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(290,3598,97,40720,1530,2,67,2,680.33,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(291,3598,97,40720,1530,2,13,1,3919.99,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(292,3598,98,40720,1530,2,96,2,2687.77,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(293,3598,98,40720,1530,2,67,2,564.43,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(294,3598,98,40720,1530,2,13,1,3252.20,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(295,3598,99,40720,1530,2,96,2,3533.06,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(296,3598,99,40720,1530,2,67,2,741.94,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(297,3598,99,40720,1530,2,13,1,4275.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(298,3598,100,40720,1530,2,96,2,702.58,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(299,3598,100,40720,1530,2,67,2,147.54,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(300,3598,100,40720,1530,2,13,1,850.12,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(301,3598,101,40720,1530,2,96,2,4263.64,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(302,3598,101,40720,1530,2,67,2,895.36,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(303,3598,101,40720,1530,2,13,1,5159.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(304,3598,102,40720,1530,2,96,2,2004.13,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(305,3598,102,40720,1530,2,67,2,420.87,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(306,3598,102,40720,1530,2,13,1,2425.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(307,3598,103,40720,1530,2,96,2,379.91,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(308,3598,103,40720,1530,2,67,2,79.78,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(309,3598,103,40720,1530,2,13,1,459.69,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(310,3598,104,40720,1530,2,96,2,867.77,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(311,3598,104,40720,1530,2,67,2,182.23,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(312,3598,104,40720,1530,2,13,1,1050.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(313,3598,105,40720,1530,2,96,2,3070.79,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(314,3598,105,40720,1530,2,67,2,644.86,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(315,3598,105,40720,1530,2,13,1,3715.65,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(316,3598,106,40720,1530,2,96,2,520.66,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(317,3598,106,40720,1530,2,67,2,109.34,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(318,3598,106,40720,1530,2,13,1,630.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(319,3598,107,40720,1530,2,96,2,1065.41,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(320,3598,107,40720,1530,2,67,2,223.74,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(321,3598,107,40720,1530,2,13,1,1289.15,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(322,3598,108,40720,1530,2,96,2,1933.88,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(323,3598,108,40720,1530,2,67,2,406.12,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(324,3598,108,40720,1530,2,13,1,2340.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(325,3598,109,40720,1530,2,96,2,938.84,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(326,3598,109,40720,1530,2,67,2,197.16,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(327,3598,109,40720,1530,2,13,1,1136.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(328,3598,110,40720,1530,2,96,2,2261.16,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(329,3598,110,40720,1530,2,67,2,474.84,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(330,3598,110,40720,1530,2,13,1,2736.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL);
INSERT INTO `balance_libro_details` VALUES (331,3598,111,40720,1530,2,96,2,1719.01,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(332,3598,111,40720,1530,2,67,2,360.99,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(333,3598,111,40720,1530,2,13,1,2080.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(334,3598,112,40720,1530,2,96,2,2481.14,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(335,3598,112,40720,1530,2,67,2,521.04,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(336,3598,112,40720,1530,2,13,1,3002.18,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(337,3598,113,40720,1530,2,96,2,330.58,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(338,3598,113,40720,1530,2,67,2,69.42,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(339,3598,113,40720,1530,2,13,1,400.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(340,3598,114,40720,1530,2,96,2,1915.08,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(341,3598,114,40720,1530,2,67,2,402.17,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(342,3598,114,40720,1530,2,13,1,2317.25,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(343,3598,115,40720,1530,2,96,2,759.48,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(344,3598,115,40720,1530,2,67,2,159.49,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(345,3598,115,40720,1530,2,13,1,918.97,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(346,3598,116,40720,1530,2,96,2,1719.01,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(347,3598,116,40720,1530,2,67,2,360.99,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(348,3598,116,40720,1530,2,13,1,2080.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(349,3598,117,40720,1530,2,96,2,1154.55,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(350,3598,117,40720,1530,2,67,2,242.45,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(351,3598,117,40720,1530,2,13,1,1397.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(352,3598,118,40720,1530,2,96,2,1729.75,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(353,3598,118,40720,1530,2,67,2,363.25,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(354,3598,118,40720,1530,2,13,1,2093.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(355,3598,119,40720,1530,2,96,2,2372.73,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(356,3598,119,40720,1530,2,67,2,498.27,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(357,3598,119,40720,1530,2,13,1,2871.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(358,3598,120,40720,1530,2,96,2,437.93,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(359,3598,120,40720,1530,2,67,2,91.97,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(360,3598,120,40720,1530,2,13,1,529.90,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(361,3598,121,40720,1530,2,96,2,1876.03,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(362,3598,121,40720,1530,2,67,2,393.97,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(363,3598,121,40720,1530,2,13,1,2270.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(364,3598,122,40720,1530,2,96,2,2404.96,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(365,3598,122,40720,1530,2,67,2,505.04,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(366,3598,122,40720,1530,2,13,1,2910.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(367,3598,123,40720,1530,2,96,2,2414.88,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(368,3598,123,40720,1530,2,67,2,507.12,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(369,3598,123,40720,1530,2,13,1,2922.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(370,3598,124,40720,1530,2,96,2,542.98,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(371,3598,124,40720,1530,2,67,2,114.02,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(372,3598,124,40720,1530,2,13,1,657.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL);
INSERT INTO `balance_libro_details` VALUES (373,3598,125,40720,1530,2,96,2,152.89,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(374,3598,125,40720,1530,2,67,2,32.11,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(375,3598,125,40720,1530,2,13,1,185.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(376,3598,126,40720,1530,2,96,2,286.04,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(377,3598,126,40720,1530,2,67,2,60.07,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(378,3598,126,40720,1530,2,13,1,346.11,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(379,3598,127,40720,1530,2,96,2,3596.69,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(380,3598,127,40720,1530,2,67,2,755.31,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(381,3598,127,40720,1530,2,13,1,4352.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(382,3598,128,40720,1530,2,96,2,582.60,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(383,3598,128,40720,1530,2,67,2,122.35,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(384,3598,128,40720,1530,2,218,2,0.01,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(385,3598,128,40720,1530,2,13,1,704.96,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(386,3598,129,40720,1530,2,96,2,4410.74,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(387,3598,129,40720,1530,2,67,2,926.26,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(388,3598,129,40720,1530,2,13,1,5337.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(389,3598,130,40720,1530,2,96,2,826.45,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(390,3598,130,40720,1530,2,67,2,173.55,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(391,3598,130,40720,1530,2,13,1,1000.00,NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(392,3598,131,40720,1530,2,96,2,165.26,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(393,3598,131,40720,1530,2,67,2,34.70,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(394,3598,131,40720,1530,2,218,2,0.01,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(395,3598,131,40720,1530,2,13,1,199.97,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(396,3598,132,40720,1530,2,96,2,1619.50,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(397,3598,132,40720,1530,2,67,2,340.10,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(398,3598,132,40720,1530,2,13,1,1959.60,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(399,3598,133,40720,1530,2,96,2,1885.12,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(400,3598,133,40720,1530,2,67,2,395.88,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(401,3598,133,40720,1530,2,13,1,2281.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(402,3598,134,40720,1530,2,96,2,1619.83,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(403,3598,134,40720,1530,2,67,2,340.17,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(404,3598,134,40720,1530,2,13,1,1960.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(405,3598,135,40720,1530,2,96,2,561.98,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(406,3598,135,40720,1530,2,67,2,118.02,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(407,3598,135,40720,1530,2,13,1,680.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(408,3598,136,40720,1530,2,96,2,413.07,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(409,3598,136,40720,1530,2,67,2,86.75,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(410,3598,136,40720,1530,2,13,1,499.82,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(411,3598,137,40720,1530,2,96,2,1786.78,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(412,3598,137,40720,1530,2,67,2,375.22,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(413,3598,137,40720,1530,2,13,1,2162.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(414,3598,138,40720,1530,2,96,2,1652.89,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL);
INSERT INTO `balance_libro_details` VALUES (415,3598,138,40720,1530,2,67,2,347.11,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(416,3598,138,40720,1530,2,13,1,2000.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(417,3598,139,40720,1530,2,96,2,978.23,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(418,3598,139,40720,1530,2,67,2,205.43,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(419,3598,139,40720,1530,2,13,1,1183.66,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(420,3598,140,40720,1530,2,96,2,1323.97,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(421,3598,140,40720,1530,2,67,2,278.03,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(422,3598,140,40720,1530,2,13,1,1602.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(423,3598,141,40720,1530,2,96,2,1566.12,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(424,3598,141,40720,1530,2,67,2,328.89,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(425,3598,141,40720,1530,2,13,1,1895.01,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(426,3598,142,40720,1530,2,96,2,1272.65,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(427,3598,142,40720,1530,2,67,2,267.26,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(428,3598,142,40720,1530,2,13,1,1539.91,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(429,3598,143,40720,1530,2,96,2,247.93,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(430,3598,143,40720,1530,2,67,2,52.07,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(431,3598,143,40720,1530,2,13,1,300.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(432,3598,144,40720,1530,2,96,2,2148.85,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(433,3598,144,40720,1530,2,67,2,451.26,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(434,3598,144,40720,1530,2,13,1,2600.11,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(435,3598,145,40720,1530,2,96,2,1186.12,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(436,3598,145,40720,1530,2,67,2,249.08,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(437,3598,145,40720,1530,2,13,1,1435.20,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(438,3598,146,40720,1530,2,96,2,330.52,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(439,3598,146,40720,1530,2,67,2,69.41,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(440,3598,146,40720,1530,2,13,1,399.93,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(441,3598,147,40720,1530,2,96,2,413.21,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(442,3598,147,40720,1530,2,67,2,86.78,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(443,3598,147,40720,1530,2,13,1,499.99,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(444,3598,148,40720,1530,2,96,2,834.71,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(445,3598,148,40720,1530,2,67,2,175.29,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(446,3598,148,40720,1530,2,13,1,1010.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(447,3598,149,40720,1530,2,96,2,248.01,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(448,3598,149,40720,1530,2,67,2,52.08,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(449,3598,149,40720,1530,2,13,1,300.09,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(450,3598,150,40720,1530,2,96,2,325.07,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(451,3598,150,40720,1530,2,67,2,68.26,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(452,3598,150,40720,1530,2,13,1,393.31,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(453,3598,150,40720,1530,2,136,1,0.02,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(454,3598,151,40720,1530,2,96,2,1347.11,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(455,3598,151,40720,1530,2,67,2,282.89,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(456,3598,151,40720,1530,2,13,1,1630.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL);
INSERT INTO `balance_libro_details` VALUES (457,3598,152,40720,1530,2,96,2,148.76,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(458,3598,152,40720,1530,2,67,2,31.24,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(459,3598,152,40720,1530,2,13,1,180.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(460,3598,153,40720,1530,2,96,2,2010.74,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(461,3598,153,40720,1530,2,67,2,422.26,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(462,3598,153,40720,1530,2,13,1,2433.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(463,3598,154,40720,1530,2,96,2,2273.39,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(464,3598,154,40720,1530,2,67,2,477.41,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(465,3598,154,40720,1530,2,13,1,2750.80,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(466,3598,155,40720,1530,2,96,2,1428.47,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(467,3598,155,40720,1530,2,67,2,299.98,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(468,3598,155,40720,1530,2,13,1,1728.45,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(469,3598,156,40720,1530,2,96,2,165.31,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(470,3598,156,40720,1530,2,67,2,34.72,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(471,3598,156,40720,1530,2,13,1,200.03,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(472,3598,157,40720,1530,2,96,2,413.17,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(473,3598,157,40720,1530,2,67,2,86.76,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(474,3598,157,40720,1530,2,13,1,499.93,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(475,3598,158,40720,1530,2,96,2,289.31,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(476,3598,158,40720,1530,2,67,2,60.75,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(477,3598,158,40720,1530,2,13,1,350.06,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(478,3598,159,40720,1530,2,96,2,1325.62,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(479,3598,159,40720,1530,2,67,2,278.38,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(480,3598,159,40720,1530,2,13,1,1604.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(481,3598,160,40720,1530,2,96,2,2175.41,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(482,3598,160,40720,1530,2,67,2,456.84,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(483,3598,160,40720,1530,2,13,1,2632.25,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(484,3598,161,40720,1530,2,96,2,960.33,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(485,3598,161,40720,1530,2,67,2,201.67,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(486,3598,161,40720,1530,2,13,1,1162.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(487,3598,162,40720,1530,2,96,2,1809.92,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(488,3598,162,40720,1530,2,67,2,380.08,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(489,3598,162,40720,1530,2,13,1,2190.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(490,3598,163,40720,1530,2,96,2,314.05,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(491,3598,163,40720,1530,2,67,2,65.95,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(492,3598,163,40720,1530,2,13,1,380.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(493,3598,164,40720,1530,2,96,2,1044.94,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(494,3598,164,40720,1530,2,67,2,219.44,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(495,3598,164,40720,1530,2,13,1,1264.37,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(496,3598,164,40720,1530,2,136,1,0.01,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(497,3598,165,40720,1530,2,96,2,347.11,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(498,3598,165,40720,1530,2,67,2,72.89,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL);
INSERT INTO `balance_libro_details` VALUES (499,3598,165,40720,1530,2,13,1,420.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(500,3598,166,40720,1530,2,96,2,1719.01,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(501,3598,166,40720,1530,2,67,2,360.99,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(502,3598,166,40720,1530,2,13,1,2080.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(503,3598,167,40720,1530,2,96,2,1870.41,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(504,3598,167,40720,1530,2,67,2,392.79,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(505,3598,167,40720,1530,2,13,1,2263.20,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(506,3598,168,40720,1530,2,96,2,2661.16,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(507,3598,168,40720,1530,2,67,2,558.84,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(508,3598,168,40720,1530,2,13,1,3220.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(509,3598,169,40720,1530,2,96,2,2661.16,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(510,3598,169,40720,1530,2,67,2,558.84,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(511,3598,169,40720,1530,2,13,1,3220.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(512,3598,170,40720,1530,2,96,2,1068.35,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(513,3598,170,40720,1530,2,67,2,224.35,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(514,3598,170,40720,1530,2,13,1,1292.70,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(515,3598,171,40720,1530,2,96,2,1714.05,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(516,3598,171,40720,1530,2,67,2,359.95,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(517,3598,171,40720,1530,2,13,1,2074.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(518,3598,172,40720,1530,2,96,2,760.30,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(519,3598,172,40720,1530,2,67,2,159.66,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(520,3598,172,40720,1530,2,13,1,919.96,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(521,3598,173,40720,1530,2,96,2,495.74,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(522,3598,173,40720,1530,2,67,2,104.11,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(523,3598,173,40720,1530,2,13,1,599.85,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(524,3598,174,40720,1530,2,96,2,661.11,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(525,3598,174,40720,1530,2,67,2,138.83,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(526,3598,174,40720,1530,2,13,1,799.94,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(527,3598,175,40720,1530,2,96,2,2052.94,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(528,3598,175,40720,1530,2,67,2,431.12,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(529,3598,175,40720,1530,2,13,1,2484.06,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(530,3598,176,40720,1530,2,96,2,165.28,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(531,3598,176,40720,1530,2,67,2,34.71,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(532,3598,176,40720,1530,2,13,1,199.99,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(533,3598,177,40720,1530,2,96,2,3754.70,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(534,3598,177,40720,1530,2,67,2,788.49,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(535,3598,177,40720,1530,2,13,1,4543.19,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(536,3598,178,40720,1530,2,96,2,5532.36,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(537,3598,178,40720,1530,2,67,2,1161.79,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(538,3598,178,40720,1530,2,13,1,6694.15,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(539,3598,179,40720,1530,2,96,2,272.70,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(540,3598,179,40720,1530,2,67,2,57.27,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL);
INSERT INTO `balance_libro_details` VALUES (541,3598,179,40720,1530,2,13,1,329.97,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(542,3598,180,40720,1530,2,96,2,537.23,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(543,3598,180,40720,1530,2,67,2,112.82,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(544,3598,180,40720,1530,2,13,1,650.05,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(545,3598,181,40720,1530,2,96,2,1132.23,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(546,3598,181,40720,1530,2,67,2,237.77,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(547,3598,181,40720,1530,2,13,1,1370.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(548,3598,182,40720,1530,2,96,2,1720.27,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(549,3598,182,40720,1530,2,67,2,361.26,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(550,3598,182,40720,1530,2,13,1,2081.53,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(551,3598,183,40720,1530,2,96,2,1619.83,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(552,3598,183,40720,1530,2,67,2,340.17,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(553,3598,183,40720,1530,2,13,1,1960.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(554,3598,184,40720,1530,2,96,2,2314.07,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(555,3598,184,40720,1530,2,67,2,485.95,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(556,3598,184,40720,1530,2,13,1,2800.02,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(557,3598,185,40720,1530,2,96,2,305.76,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(558,3598,185,40720,1530,2,67,2,64.21,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(559,3598,185,40720,1530,2,13,1,369.97,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(560,3598,186,40720,1530,2,96,2,826.45,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(561,3598,186,40720,1530,2,67,2,173.55,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(562,3598,186,40720,1530,2,13,1,1000.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(563,3598,187,40720,1530,2,96,2,790.91,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(564,3598,187,40720,1530,2,67,2,166.09,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(565,3598,187,40720,1530,2,13,1,957.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(566,3598,188,40720,1530,2,96,2,1157.60,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(567,3598,188,40720,1530,2,67,2,243.10,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(568,3598,188,40720,1530,2,13,1,1400.70,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(569,3598,189,40720,1530,2,96,2,671.06,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(570,3598,189,40720,1530,2,67,2,140.92,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(571,3598,189,40720,1530,2,13,1,811.98,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(572,3598,190,40720,1530,2,96,2,1644.63,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(573,3598,190,40720,1530,2,67,2,345.37,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(574,3598,190,40720,1530,2,13,1,1990.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(575,3598,191,40720,1530,2,96,2,3205.79,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(576,3598,191,40720,1530,2,67,2,673.21,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(577,3598,191,40720,1530,2,13,1,3879.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(578,3598,192,40720,1530,2,96,2,3851.24,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(579,3598,192,40720,1530,2,67,2,808.76,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(580,3598,192,40720,1530,2,13,1,4660.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(581,3598,193,40720,1530,2,96,2,1849.59,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(582,3598,193,40720,1530,2,67,2,388.41,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL);
INSERT INTO `balance_libro_details` VALUES (583,3598,193,40720,1530,2,13,1,2238.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(584,3598,194,40720,1530,2,96,2,475.31,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(585,3598,194,40720,1530,2,67,2,99.81,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(586,3598,194,40720,1530,2,13,1,575.12,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(587,3598,195,40720,1530,2,96,2,1384.31,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(588,3598,195,40720,1530,2,67,2,290.71,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(589,3598,195,40720,1530,2,13,1,1675.01,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(590,3598,195,40720,1530,2,136,1,0.01,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(591,3598,196,40720,1530,2,96,2,1380.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(592,3598,196,40720,1530,2,67,2,289.80,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(593,3598,196,40720,1530,2,13,1,1669.80,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(594,3598,197,40720,1530,2,96,2,2503.39,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(595,3598,197,40720,1530,2,67,2,525.71,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(596,3598,197,40720,1530,2,13,1,3029.10,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(597,3598,198,40720,1530,2,96,2,724.02,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(598,3598,198,40720,1530,2,67,2,152.04,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(599,3598,198,40720,1530,2,13,1,876.06,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(600,3598,199,40720,1530,2,96,2,371.87,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(601,3598,199,40720,1530,2,67,2,78.09,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(602,3598,199,40720,1530,2,13,1,449.96,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(603,3598,200,40720,1530,2,96,2,540.50,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(604,3598,200,40720,1530,2,67,2,113.50,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(605,3598,200,40720,1530,2,13,1,654.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(606,3598,201,40720,1530,2,96,2,359.50,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(607,3598,201,40720,1530,2,67,2,75.50,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(608,3598,201,40720,1530,2,13,1,435.00,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(609,3598,202,40720,1530,2,96,2,413.21,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(610,3598,202,40720,1530,2,67,2,86.78,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(611,3598,202,40720,1530,2,13,1,499.99,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(612,3598,203,40720,1530,2,96,2,372.01,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(613,3598,203,40720,1530,2,67,2,78.12,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(614,3598,203,40720,1530,2,13,1,450.13,NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(615,3598,204,40720,1530,2,96,2,1341.98,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(616,3598,204,40720,1530,2,67,2,281.82,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(617,3598,204,40720,1530,2,13,1,1623.80,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(618,3598,205,40720,1530,2,96,2,1834.30,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(619,3598,205,40720,1530,2,67,2,385.20,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(620,3598,205,40720,1530,2,13,1,2219.50,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(621,3598,206,40720,1530,2,96,2,843.76,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(622,3598,206,40720,1530,2,67,2,177.19,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(623,3598,206,40720,1530,2,13,1,1020.95,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(624,3598,207,40720,1530,2,96,2,2365.29,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL);
INSERT INTO `balance_libro_details` VALUES (625,3598,207,40720,1530,2,67,2,496.71,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(626,3598,207,40720,1530,2,13,1,2862.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(627,3598,208,40720,1530,2,96,2,165.32,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(628,3598,208,40720,1530,2,67,2,34.72,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(629,3598,208,40720,1530,2,13,1,200.04,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(630,3598,209,40720,1530,2,96,2,1272.73,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(631,3598,209,40720,1530,2,67,2,267.27,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(632,3598,209,40720,1530,2,13,1,1540.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(633,3598,210,40720,1530,2,96,2,355.37,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(634,3598,210,40720,1530,2,67,2,74.63,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(635,3598,210,40720,1530,2,13,1,430.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(636,3598,211,40720,1530,2,96,2,1408.10,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(637,3598,211,40720,1530,2,67,2,295.70,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(638,3598,211,40720,1530,2,13,1,1703.80,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(639,3598,212,40720,1530,2,96,2,794.55,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(640,3598,212,40720,1530,2,67,2,166.85,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(641,3598,212,40720,1530,2,13,1,961.40,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(642,3598,213,40720,1530,2,96,2,760.27,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(643,3598,213,40720,1530,2,67,2,159.66,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(644,3598,213,40720,1530,2,13,1,919.93,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(645,3598,214,40720,1530,2,96,2,7973.97,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(646,3598,214,40720,1530,2,67,2,1674.53,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(647,3598,214,40720,1530,2,13,1,9648.50,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(648,3598,215,40720,1530,2,96,2,629.64,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(649,3598,215,40720,1530,2,67,2,132.22,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(650,3598,215,40720,1530,2,13,1,761.86,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(651,3598,216,40720,1530,2,96,2,1292.56,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(652,3598,216,40720,1530,2,67,2,271.44,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(653,3598,216,40720,1530,2,13,1,1564.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(654,3598,217,40720,1530,2,96,2,1362.81,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(655,3598,217,40720,1530,2,67,2,286.19,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(656,3598,217,40720,1530,2,13,1,1649.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(657,3598,218,40720,1530,2,96,2,2454.55,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(658,3598,218,40720,1530,2,67,2,515.45,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(659,3598,218,40720,1530,2,13,1,2970.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(660,3598,219,40720,1530,2,96,2,2752.40,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(661,3598,219,40720,1530,2,67,2,578.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(662,3598,219,40720,1530,2,13,1,3330.40,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(663,3598,220,40720,1530,2,96,2,1860.91,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(664,3598,220,40720,1530,2,67,2,390.79,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(665,3598,220,40720,1530,2,13,1,2251.70,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(666,3598,221,40720,1530,2,96,2,4258.80,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL);
INSERT INTO `balance_libro_details` VALUES (667,3598,221,40720,1530,2,67,2,894.35,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(668,3598,221,40720,1530,2,13,1,5153.15,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(669,3598,222,40720,1530,2,96,2,3823.14,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(670,3598,222,40720,1530,2,67,2,802.86,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(671,3598,222,40720,1530,2,13,1,4626.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(672,3598,223,40720,1530,2,96,2,957.85,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(673,3598,223,40720,1530,2,67,2,201.15,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(674,3598,223,40720,1530,2,13,1,1159.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(675,3598,224,40720,1530,2,96,2,1306.61,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(676,3598,224,40720,1530,2,67,2,274.39,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(677,3598,224,40720,1530,2,13,1,1581.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(678,3598,225,40720,1530,2,96,2,661.16,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(679,3598,225,40720,1530,2,67,2,138.84,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(680,3598,225,40720,1530,2,13,1,800.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(681,3598,226,40720,1530,2,96,2,1910.30,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(682,3598,226,40720,1530,2,67,2,401.16,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(683,3598,226,40720,1530,2,13,1,2311.46,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(684,3598,227,40720,1530,2,96,2,1337.23,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(685,3598,227,40720,1530,2,67,2,280.82,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(686,3598,227,40720,1530,2,13,1,1618.05,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(687,3598,228,40720,1530,2,96,2,2113.72,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(688,3598,228,40720,1530,2,67,2,443.88,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(689,3598,228,40720,1530,2,13,1,2557.60,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(690,3598,229,40720,1530,2,96,2,2076.03,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(691,3598,229,40720,1530,2,67,2,435.97,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(692,3598,229,40720,1530,2,13,1,2512.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(693,3598,230,40720,1530,2,96,2,2329.75,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(694,3598,230,40720,1530,2,67,2,489.25,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(695,3598,230,40720,1530,2,13,1,2819.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(696,3598,231,40720,1530,2,96,2,1463.64,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(697,3598,231,40720,1530,2,67,2,307.36,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(698,3598,231,40720,1530,2,13,1,1771.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(699,3598,232,40720,1530,2,96,2,311.74,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(700,3598,232,40720,1530,2,67,2,65.46,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(701,3598,232,40720,1530,2,13,1,377.20,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(702,3598,233,40720,1530,2,96,2,2496.69,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(703,3598,233,40720,1530,2,67,2,524.31,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(704,3598,233,40720,1530,2,13,1,3021.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(705,3598,234,40720,1530,2,96,2,664.17,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(706,3598,234,40720,1530,2,67,2,139.48,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(707,3598,234,40720,1530,2,13,1,803.65,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(708,3598,235,40720,1530,2,96,2,181.82,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL);
INSERT INTO `balance_libro_details` VALUES (709,3598,235,40720,1530,2,67,2,38.18,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(710,3598,235,40720,1530,2,13,1,220.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(711,3598,236,40720,1530,2,96,2,501.69,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(712,3598,236,40720,1530,2,67,2,105.36,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(713,3598,236,40720,1530,2,13,1,607.05,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(714,3598,237,40720,1530,2,96,2,2849.34,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(715,3598,237,40720,1530,2,67,2,598.36,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(716,3598,237,40720,1530,2,13,1,3447.70,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(717,3598,238,40720,1530,2,96,2,1480.99,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(718,3598,238,40720,1530,2,67,2,311.01,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(719,3598,238,40720,1530,2,13,1,1792.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(720,3598,239,40720,1530,2,96,2,669.37,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(721,3598,239,40720,1530,2,67,2,140.57,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(722,3598,239,40720,1530,2,13,1,809.94,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(723,3598,240,40720,1530,2,96,2,1862.81,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(724,3598,240,40720,1530,2,67,2,391.19,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(725,3598,240,40720,1530,2,13,1,2254.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(726,3598,241,40720,1530,2,96,2,3296.03,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(727,3598,241,40720,1530,2,67,2,692.17,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(728,3598,241,40720,1530,2,13,1,3988.20,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(729,3598,242,40720,1530,2,96,2,1140.49,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(730,3598,242,40720,1530,2,67,2,239.50,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(731,3598,242,40720,1530,2,13,1,1379.99,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(732,3598,243,40720,1530,2,96,2,487.45,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(733,3598,243,40720,1530,2,67,2,102.36,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(734,3598,243,40720,1530,2,13,1,589.80,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(735,3598,243,40720,1530,2,136,1,0.01,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(736,3598,244,40720,1530,2,96,2,1384.36,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(737,3598,244,40720,1530,2,67,2,290.72,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(738,3598,244,40720,1530,2,13,1,1675.08,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(739,3598,245,40720,1530,2,96,2,867.69,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(740,3598,245,40720,1530,2,67,2,182.22,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(741,3598,245,40720,1530,2,13,1,1049.91,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(742,3598,246,40720,1530,2,96,2,1240.50,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(743,3598,246,40720,1530,2,67,2,260.50,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(744,3598,246,40720,1530,2,13,1,1501.00,NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(745,3598,247,40720,1530,3,217,1,19222.66,NULL,'2021-04-19 15:12:28','2021-04-19 15:12:28',NULL),(746,3598,247,40720,1530,3,68,1,4036.76,NULL,'2021-04-19 15:12:28','2021-04-19 15:12:28',NULL),(747,3598,247,40720,1530,3,57,2,23259.42,NULL,'2021-04-19 15:12:28','2021-04-19 15:12:28',NULL),(748,3598,248,40720,1530,16,156,1,14787.80,NULL,'2021-04-19 15:28:53','2021-04-19 15:28:53',NULL),(749,3598,248,40720,1530,16,331,2,14787.80,NULL,'2021-04-19 15:28:53','2021-04-19 15:28:53',NULL),(750,3598,249,40720,1530,15,67,1,65960.86,NULL,'2021-04-19 15:30:28','2021-04-19 15:30:28',NULL);
INSERT INTO `balance_libro_details` VALUES (751,3598,249,40720,1530,15,68,2,68701.41,NULL,'2021-04-19 15:30:28','2021-04-19 15:30:28',NULL),(752,3598,249,40720,1530,15,353,1,2740.55,NULL,'2021-04-19 15:30:28','2021-04-19 15:30:28',NULL),(753,3598,250,40733,3040,2,96,2,25881.50,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(754,3598,250,40733,3040,2,67,2,5435.12,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(755,3598,250,40733,3040,2,13,1,31316.62,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(756,3598,251,40733,3040,2,96,2,46240.00,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(757,3598,251,40733,3040,2,67,2,9710.40,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(758,3598,251,40733,3040,2,13,1,55950.40,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(759,3598,252,40733,3040,2,96,2,47874.00,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(760,3598,252,40733,3040,2,67,2,10053.54,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(761,3598,252,40733,3040,2,13,1,57927.54,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(762,3598,253,40733,3040,2,96,2,44018.25,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(763,3598,253,40733,3040,2,67,2,9243.83,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(764,3598,253,40733,3040,2,13,1,53262.08,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(765,3598,254,40733,3040,2,96,2,34440.00,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(766,3598,254,40733,3040,2,67,2,7232.40,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(767,3598,254,40733,3040,2,13,1,41672.40,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(768,3598,255,40733,3040,2,96,2,22791.00,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(769,3598,255,40733,3040,2,67,2,4786.11,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(770,3598,255,40733,3040,2,13,1,27577.11,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(771,3598,256,40733,3040,2,96,2,17268.00,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(772,3598,256,40733,3040,2,67,2,3626.28,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(773,3598,256,40733,3040,2,13,1,20894.28,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(774,3598,257,40733,3040,2,96,2,40000.50,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(775,3598,257,40733,3040,2,67,2,8400.11,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(776,3598,257,40733,3040,2,13,1,48400.61,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(777,3598,258,40733,3040,2,96,2,358063.00,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(778,3598,258,40733,3040,2,67,2,75193.23,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(779,3598,258,40733,3040,2,13,1,433256.23,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(780,3598,259,40733,3040,2,96,2,46000.00,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(781,3598,259,40733,3040,2,67,2,9660.00,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(782,3598,259,40733,3040,2,13,1,55660.00,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(783,3598,260,40733,3040,2,96,2,20919.60,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(784,3598,260,40733,3040,2,67,2,4393.11,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(785,3598,260,40733,3040,2,13,1,25312.71,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(786,3598,261,40733,3040,2,96,2,41356.00,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(787,3598,261,40733,3040,2,67,2,8684.76,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(788,3598,261,40733,3040,2,13,1,50040.76,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(789,3598,262,40733,3040,2,96,2,45064.20,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(790,3598,262,40733,3040,2,67,2,9463.49,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(791,3598,262,40733,3040,2,13,1,54527.69,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL);
INSERT INTO `balance_libro_details` VALUES (792,3598,263,40733,3040,2,96,2,91452.00,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(793,3598,263,40733,3040,2,67,2,19204.92,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(794,3598,263,40733,3040,2,13,1,110656.92,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(795,3598,264,40733,3040,2,96,2,59277.00,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(796,3598,264,40733,3040,2,67,2,12448.17,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(797,3598,264,40733,3040,2,13,1,71725.17,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(798,3598,265,40733,3040,2,96,2,65232.90,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(799,3598,265,40733,3040,2,67,2,13698.91,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(800,3598,265,40733,3040,2,13,1,78931.81,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(801,3598,266,40733,3040,2,96,2,95314.00,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(802,3598,266,40733,3040,2,67,2,20015.94,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(803,3598,266,40733,3040,2,13,1,115329.94,NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(804,3598,267,40733,3040,3,250,1,300.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(805,3598,267,40733,3040,3,57,2,300.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(806,3598,268,40733,3040,3,250,1,16000.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(807,3598,268,40733,3040,3,57,2,16000.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(808,3598,269,40733,3040,3,217,2,413.23,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(809,3598,269,40733,3040,3,67,2,86.78,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(810,3598,269,40733,3040,3,57,1,500.01,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(811,3598,270,40733,3040,3,217,1,27375.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(812,3598,270,40733,3040,3,68,1,5748.75,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(813,3598,270,40733,3040,3,57,2,33123.75,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(814,3598,271,40733,3040,3,217,1,3434.96,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(815,3598,271,40733,3040,3,68,1,721.34,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(816,3598,271,40733,3040,3,57,2,4156.30,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(817,3598,272,40733,3040,3,217,1,561.98,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(818,3598,272,40733,3040,3,68,1,118.02,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(819,3598,272,40733,3040,3,57,2,680.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(820,3598,273,40733,3040,3,217,1,942.15,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(821,3598,273,40733,3040,3,68,1,197.85,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(822,3598,273,40733,3040,3,57,2,1140.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(823,3598,274,40733,3040,3,217,1,58630.87,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(824,3598,274,40733,3040,3,68,1,12312.48,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(825,3598,274,40733,3040,3,57,2,70943.35,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(826,3598,275,40733,3040,3,217,1,743.80,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(827,3598,275,40733,3040,3,68,1,156.20,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(828,3598,275,40733,3040,3,57,2,900.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(829,3598,276,40733,3040,3,217,2,27375.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(830,3598,276,40733,3040,3,67,2,5748.75,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(831,3598,276,40733,3040,3,57,1,33123.75,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(832,3598,277,40733,3040,3,217,1,471.08,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(833,3598,277,40733,3040,3,68,1,98.93,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL);
INSERT INTO `balance_libro_details` VALUES (834,3598,277,40733,3040,3,57,2,570.01,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(835,3598,278,40733,3040,3,217,1,471.07,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(836,3598,278,40733,3040,3,68,1,98.92,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(837,3598,278,40733,3040,3,57,2,569.99,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(838,3598,279,40733,3040,3,217,1,31023.96,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(839,3598,279,40733,3040,3,68,1,6515.03,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(840,3598,279,40733,3040,3,217,1,310.24,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(841,3598,279,40733,3040,3,57,2,37849.23,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(842,3598,280,40733,3040,3,217,1,471.07,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(843,3598,280,40733,3040,3,68,1,98.92,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(844,3598,280,40733,3040,3,57,2,569.99,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(845,3598,281,40733,3040,3,217,1,23904.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(846,3598,281,40733,3040,3,68,1,5019.84,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(847,3598,281,40733,3040,3,57,2,28923.84,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(848,3598,282,40733,3040,3,217,1,2322.31,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(849,3598,282,40733,3040,3,68,1,487.69,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(850,3598,282,40733,3040,3,57,2,2810.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(851,3598,283,40733,3040,3,217,1,15400.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(852,3598,283,40733,3040,3,68,1,3234.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(853,3598,283,40733,3040,3,57,2,18634.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(854,3598,284,40733,3040,3,217,1,9360.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(855,3598,284,40733,3040,3,68,1,1965.60,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(856,3598,284,40733,3040,3,57,2,11325.60,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(857,3598,285,40733,3040,3,217,1,4760.33,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(858,3598,285,40733,3040,3,68,1,999.67,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(859,3598,285,40733,3040,3,57,2,5760.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(860,3598,286,40733,3040,3,217,1,876.03,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(861,3598,286,40733,3040,3,68,1,183.97,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(862,3598,286,40733,3040,3,57,2,1060.00,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(863,3598,287,40733,3040,3,217,1,49357.37,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(864,3598,287,40733,3040,3,68,1,10365.05,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(865,3598,287,40733,3040,3,57,2,59722.42,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(866,3598,288,40733,3040,3,217,1,471.08,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(867,3598,288,40733,3040,3,68,1,98.93,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(868,3598,288,40733,3040,3,57,2,570.01,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(869,3598,289,40733,3040,3,217,1,471.08,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(870,3598,289,40733,3040,3,68,1,98.93,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(871,3598,289,40733,3040,3,57,2,570.01,NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(872,3598,290,40733,3040,3,250,1,12.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(873,3598,290,40733,3040,3,57,2,12.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(874,3598,291,40733,3040,3,217,1,58591.05,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(875,3598,291,40733,3040,3,68,1,12304.12,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL);
INSERT INTO `balance_libro_details` VALUES (876,3598,291,40733,3040,3,57,2,70895.17,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(877,3598,292,40733,3040,3,217,1,876.03,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(878,3598,292,40733,3040,3,68,1,183.97,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(879,3598,292,40733,3040,3,57,2,1060.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(880,3598,293,40733,3040,3,217,1,471.08,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(881,3598,293,40733,3040,3,68,1,98.93,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(882,3598,293,40733,3040,3,57,2,570.01,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(883,3598,294,40733,3040,3,217,1,669.42,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(884,3598,294,40733,3040,3,68,1,140.58,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(885,3598,294,40733,3040,3,57,2,810.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(886,3598,295,40733,3040,3,217,2,471.08,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(887,3598,295,40733,3040,3,67,2,98.93,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(888,3598,295,40733,3040,3,57,1,570.01,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(889,3598,296,40733,3040,3,217,1,1694.21,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(890,3598,296,40733,3040,3,68,1,355.78,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(891,3598,296,40733,3040,3,57,2,2049.99,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(892,3598,297,40733,3040,3,217,1,876.04,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(893,3598,297,40733,3040,3,68,1,183.97,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(894,3598,297,40733,3040,3,57,2,1060.01,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(895,3598,298,40733,3040,3,217,1,1289.25,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(896,3598,298,40733,3040,3,68,1,270.74,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(897,3598,298,40733,3040,3,57,2,1559.99,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(898,3598,299,40733,3040,3,217,1,471.07,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(899,3598,299,40733,3040,3,68,1,98.92,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(900,3598,299,40733,3040,3,57,2,569.99,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(901,3598,300,40733,3040,3,217,1,876.04,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(902,3598,300,40733,3040,3,68,1,183.97,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(903,3598,300,40733,3040,3,57,2,1060.01,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(904,3598,301,40733,3040,3,217,1,1272.73,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(905,3598,301,40733,3040,3,68,1,267.27,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(906,3598,301,40733,3040,3,57,2,1540.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(907,3598,302,40733,3040,3,217,2,1289.25,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(908,3598,302,40733,3040,3,67,2,270.74,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(909,3598,302,40733,3040,3,57,1,1559.99,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(910,3598,303,40733,3040,3,250,1,19500.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(911,3598,303,40733,3040,3,57,2,19500.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(912,3598,304,40733,3040,3,217,1,669.42,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(913,3598,304,40733,3040,3,68,1,140.58,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(914,3598,304,40733,3040,3,57,2,810.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(915,3598,305,40733,3040,3,217,1,144360.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(916,3598,305,40733,3040,3,68,1,30315.60,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(917,3598,305,40733,3040,3,57,2,174675.60,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL);
INSERT INTO `balance_libro_details` VALUES (918,3598,306,40733,3040,3,250,1,80000.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(919,3598,306,40733,3040,3,57,2,80000.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(920,3598,307,40733,3040,3,217,1,150500.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(921,3598,307,40733,3040,3,68,1,31605.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(922,3598,307,40733,3040,3,57,2,182105.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(923,3598,308,40733,3040,3,217,1,2512.40,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(924,3598,308,40733,3040,3,68,1,527.60,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(925,3598,308,40733,3040,3,57,2,3040.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(926,3598,309,40733,3040,3,217,1,909.09,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(927,3598,309,40733,3040,3,68,1,190.91,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(928,3598,309,40733,3040,3,57,2,1100.00,NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(929,3598,310,40733,3041,2,96,2,55440.00,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(930,3598,310,40733,3041,2,67,2,11642.40,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(931,3598,310,40733,3041,2,13,1,67082.40,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(932,3598,311,40733,3041,2,96,2,10516.00,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(933,3598,311,40733,3041,2,67,2,2208.36,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(934,3598,311,40733,3041,2,13,1,12724.36,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(935,3598,312,40733,3041,2,96,2,11633.00,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(936,3598,312,40733,3041,2,67,2,2442.93,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(937,3598,312,40733,3041,2,13,1,14075.93,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(938,3598,313,40733,3041,2,96,2,7189.00,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(939,3598,313,40733,3041,2,67,2,1509.69,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(940,3598,313,40733,3041,2,13,1,8698.69,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(941,3598,314,40733,3041,2,96,2,65072.00,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(942,3598,314,40733,3041,2,67,2,13665.12,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(943,3598,314,40733,3041,2,13,1,78737.12,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(944,3598,315,40733,3041,2,96,2,71136.00,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(945,3598,315,40733,3041,2,67,2,14938.56,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(946,3598,315,40733,3041,2,13,1,86074.56,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(947,3598,316,40733,3041,2,96,2,83963.00,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(948,3598,316,40733,3041,2,67,2,17632.23,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(949,3598,316,40733,3041,2,13,1,101595.23,NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(950,3598,317,40733,3041,2,96,2,55121.00,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(951,3598,317,40733,3041,2,67,2,11575.41,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(952,3598,317,40733,3041,2,13,1,66696.41,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(953,3598,318,40733,3041,2,96,2,48146.00,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(954,3598,318,40733,3041,2,67,2,10110.66,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(955,3598,318,40733,3041,2,13,1,58256.66,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(956,3598,319,40733,3041,2,96,2,65865.00,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(957,3598,319,40733,3041,2,67,2,13831.65,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(958,3598,319,40733,3041,2,13,1,79696.65,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL);
INSERT INTO `balance_libro_details` VALUES (959,3598,320,40733,3041,2,96,2,167828.40,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(960,3598,320,40733,3041,2,67,2,35243.96,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(961,3598,320,40733,3041,2,13,1,203072.36,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(962,3598,321,40733,3041,2,96,2,29625.00,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(963,3598,321,40733,3041,2,67,2,6221.25,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(964,3598,321,40733,3041,2,13,1,35846.25,NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(965,3598,322,40733,3041,3,217,1,206760.00,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(966,3598,322,40733,3041,3,68,1,43419.60,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(967,3598,322,40733,3041,3,57,2,250179.60,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(968,3598,323,40733,3041,3,217,1,471.07,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(969,3598,323,40733,3041,3,68,1,98.92,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(970,3598,323,40733,3041,3,57,2,569.99,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(971,3598,324,40733,3041,3,217,1,876.03,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(972,3598,324,40733,3041,3,68,1,183.97,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(973,3598,324,40733,3041,3,57,2,1060.00,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(974,3598,325,40733,3041,3,217,1,471.07,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(975,3598,325,40733,3041,3,68,1,98.92,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(976,3598,325,40733,3041,3,57,2,569.99,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(977,3598,326,40733,3041,3,217,1,2107.44,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(978,3598,326,40733,3041,3,68,1,442.56,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(979,3598,326,40733,3041,3,57,2,2550.00,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(980,3598,327,40733,3041,3,217,1,471.07,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(981,3598,327,40733,3041,3,68,1,98.92,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(982,3598,327,40733,3041,3,57,2,569.99,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(983,3598,328,40733,3041,3,217,1,1289.25,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(984,3598,328,40733,3041,3,68,1,270.74,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(985,3598,328,40733,3041,3,57,2,1559.99,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(986,3598,329,40733,3041,3,217,1,471.08,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(987,3598,329,40733,3041,3,68,1,98.93,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(988,3598,329,40733,3041,3,57,2,570.01,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(989,3598,330,40733,3041,3,217,1,41675.00,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(990,3598,330,40733,3041,3,68,1,8751.75,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(991,3598,330,40733,3041,3,57,2,50426.75,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(992,3598,331,40733,3041,3,217,1,471.08,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(993,3598,331,40733,3041,3,68,1,98.93,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(994,3598,331,40733,3041,3,57,2,570.01,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(995,3598,332,40733,3041,3,217,2,1272.73,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(996,3598,332,40733,3041,3,67,2,267.27,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(997,3598,332,40733,3041,3,57,1,1540.00,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(998,3598,333,40733,3041,3,217,1,471.07,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(999,3598,333,40733,3041,3,68,1,98.92,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1000,3598,333,40733,3041,3,57,2,569.99,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL);
INSERT INTO `balance_libro_details` VALUES (1001,3598,334,40733,3041,3,217,1,471.08,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1002,3598,334,40733,3041,3,68,1,98.93,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1003,3598,334,40733,3041,3,57,2,570.01,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1004,3598,335,40733,3041,3,217,1,90417.40,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1005,3598,335,40733,3041,3,68,1,18987.65,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1006,3598,335,40733,3041,3,57,2,109405.05,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1007,3598,336,40733,3041,3,217,1,2900.82,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1008,3598,336,40733,3041,3,68,1,609.17,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1009,3598,336,40733,3041,3,57,2,3509.99,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1010,3598,337,40733,3041,3,217,1,471.08,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1011,3598,337,40733,3041,3,68,1,98.93,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1012,3598,337,40733,3041,3,57,2,570.01,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1013,3598,338,40733,3041,3,217,1,471.07,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1014,3598,338,40733,3041,3,68,1,98.92,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1015,3598,338,40733,3041,3,57,2,569.99,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1016,3598,339,40733,3041,3,217,1,88702.12,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1017,3598,339,40733,3041,3,68,1,18627.45,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1018,3598,339,40733,3041,3,57,2,107329.57,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1019,3598,340,40733,3041,3,217,1,752.06,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1020,3598,340,40733,3041,3,68,1,157.93,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1021,3598,340,40733,3041,3,57,2,909.99,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1022,3598,341,40733,3041,3,217,1,10693.10,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1023,3598,341,40733,3041,3,68,1,2245.55,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1024,3598,341,40733,3041,3,57,2,12938.65,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1025,3598,342,40733,3041,3,217,1,1289.25,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1026,3598,342,40733,3041,3,68,1,270.74,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1027,3598,342,40733,3041,3,57,2,1559.99,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1028,3598,343,40733,3041,3,217,1,471.07,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1029,3598,343,40733,3041,3,68,1,98.92,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1030,3598,343,40733,3041,3,57,2,569.99,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1031,3598,344,40733,3041,3,217,1,437.63,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1032,3598,344,40733,3041,3,68,1,91.90,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1033,3598,344,40733,3041,3,57,2,529.53,NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(1034,3598,345,40733,3042,2,96,2,143746.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1035,3598,345,40733,3042,2,67,2,30186.66,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1036,3598,345,40733,3042,2,13,1,173932.66,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1037,3598,346,40733,3042,2,96,2,44209.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1038,3598,346,40733,3042,2,67,2,9283.89,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1039,3598,346,40733,3042,2,13,1,53492.89,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1040,3598,347,40733,3042,2,96,2,36609.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1041,3598,347,40733,3042,2,67,2,7687.89,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL);
INSERT INTO `balance_libro_details` VALUES (1042,3598,347,40733,3042,2,13,1,44296.89,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1043,3598,348,40733,3042,2,96,2,30888.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1044,3598,348,40733,3042,2,67,2,6486.48,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1045,3598,348,40733,3042,2,13,1,37374.48,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1046,3598,349,40733,3042,2,96,2,27712.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1047,3598,349,40733,3042,2,67,2,5819.52,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1048,3598,349,40733,3042,2,13,1,33531.52,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1049,3598,350,40733,3042,2,96,2,39859.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1050,3598,350,40733,3042,2,67,2,8370.38,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1051,3598,350,40733,3042,2,13,1,48229.38,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1052,3598,351,40733,3042,2,96,2,29950.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1053,3598,351,40733,3042,2,67,2,6289.50,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1054,3598,351,40733,3042,2,13,1,36239.50,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1055,3598,352,40733,3042,2,96,2,56412.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1056,3598,352,40733,3042,2,67,2,11846.52,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1057,3598,352,40733,3042,2,13,1,68258.52,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1058,3598,353,40733,3042,2,96,2,33109.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1059,3598,353,40733,3042,2,67,2,6952.89,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1060,3598,353,40733,3042,2,13,1,40061.89,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1061,3598,354,40733,3042,2,96,2,91243.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1062,3598,354,40733,3042,2,67,2,19161.03,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1063,3598,354,40733,3042,2,13,1,110404.03,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1064,3598,355,40733,3042,2,96,2,2530.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1065,3598,355,40733,3042,2,67,2,531.30,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1066,3598,355,40733,3042,2,13,1,3061.30,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1067,3598,356,40733,3042,2,96,2,15550.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1068,3598,356,40733,3042,2,67,2,3265.50,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1069,3598,356,40733,3042,2,13,1,18815.50,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1070,3598,357,40733,3042,2,96,2,71387.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1071,3598,357,40733,3042,2,67,2,14991.27,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1072,3598,357,40733,3042,2,13,1,86378.27,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1073,3598,358,40733,3042,2,96,2,93044.70,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1074,3598,358,40733,3042,2,67,2,19539.39,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1075,3598,358,40733,3042,2,13,1,112584.09,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1076,3598,359,40733,3042,2,96,2,23705.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1077,3598,359,40733,3042,2,67,2,4978.05,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1078,3598,359,40733,3042,2,13,1,28683.05,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1079,3598,360,40733,3042,2,96,2,34131.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1080,3598,360,40733,3042,2,67,2,7167.51,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1081,3598,360,40733,3042,2,13,1,41298.51,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1082,3598,361,40733,3042,2,96,1,5600.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL);
INSERT INTO `balance_libro_details` VALUES (1083,3598,361,40733,3042,2,68,1,1176.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1084,3598,361,40733,3042,2,13,2,6776.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1085,3598,362,40733,3042,2,96,2,41282.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1086,3598,362,40733,3042,2,67,2,8669.22,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1087,3598,362,40733,3042,2,13,1,49951.22,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1088,3598,363,40733,3042,2,96,2,99704.00,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1089,3598,363,40733,3042,2,67,2,20937.84,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1090,3598,363,40733,3042,2,13,1,120641.84,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1091,3598,364,40733,3042,2,96,2,115698.60,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1092,3598,364,40733,3042,2,67,2,24296.71,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1093,3598,364,40733,3042,2,13,1,139995.31,NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(1094,3598,365,40733,3042,3,217,1,471.07,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1095,3598,365,40733,3042,3,68,1,98.92,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1096,3598,365,40733,3042,3,57,2,569.99,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1097,3598,366,40733,3042,3,217,1,1231.40,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1098,3598,366,40733,3042,3,68,1,258.59,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1099,3598,366,40733,3042,3,57,2,1489.99,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1100,3598,367,40733,3042,3,250,1,19500.00,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1101,3598,367,40733,3042,3,57,2,19500.00,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1102,3598,368,40733,3042,3,217,1,79832.11,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1103,3598,368,40733,3042,3,68,1,16764.74,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1104,3598,368,40733,3042,3,57,2,96596.85,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1105,3598,369,40733,3042,3,217,2,88702.12,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1106,3598,369,40733,3042,3,67,2,18627.45,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1107,3598,369,40733,3042,3,57,1,107329.57,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1108,3598,370,40733,3042,3,217,2,752.06,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1109,3598,370,40733,3042,3,67,2,157.93,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1110,3598,370,40733,3042,3,57,1,909.99,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1111,3598,371,40733,3042,3,217,1,471.07,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1112,3598,371,40733,3042,3,68,1,98.92,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1113,3598,371,40733,3042,3,57,2,569.99,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1114,3598,372,40733,3042,3,217,1,112380.00,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1115,3598,372,40733,3042,3,68,1,23599.80,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1116,3598,372,40733,3042,3,57,2,135979.80,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1117,3598,373,40733,3042,3,217,1,44590.00,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1118,3598,373,40733,3042,3,68,1,9363.90,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1119,3598,373,40733,3042,3,57,2,53953.90,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1120,3598,374,40733,3042,3,217,2,9580.00,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1121,3598,374,40733,3042,3,67,2,2011.80,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1122,3598,374,40733,3042,3,57,1,11591.80,NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(1123,3598,375,40733,3042,3,217,1,876.04,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL);
INSERT INTO `balance_libro_details` VALUES (1124,3598,375,40733,3042,3,68,1,183.97,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1125,3598,375,40733,3042,3,57,2,1060.01,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1126,3598,376,40733,3042,3,217,1,1785.12,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1127,3598,376,40733,3042,3,68,1,374.88,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1128,3598,376,40733,3042,3,57,2,2160.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1129,3598,377,40733,3042,3,217,1,876.03,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1130,3598,377,40733,3042,3,68,1,183.97,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1131,3598,377,40733,3042,3,57,2,1060.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1132,3598,378,40733,3042,3,217,1,446.28,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1133,3598,378,40733,3042,3,68,1,93.72,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1134,3598,378,40733,3042,3,57,2,540.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1135,3598,379,40733,3042,3,217,1,471.07,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1136,3598,379,40733,3042,3,68,1,98.92,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1137,3598,379,40733,3042,3,57,2,569.99,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1138,3598,380,40733,3042,3,217,1,471.07,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1139,3598,380,40733,3042,3,68,1,98.92,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1140,3598,380,40733,3042,3,57,2,569.99,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1141,3598,381,40733,3042,3,217,1,5141.20,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1142,3598,381,40733,3042,3,68,1,1079.65,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1143,3598,381,40733,3042,3,57,2,6220.85,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1144,3598,382,40733,3042,3,217,1,5875.20,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1145,3598,382,40733,3042,3,68,1,1233.79,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1146,3598,382,40733,3042,3,57,2,7108.99,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1147,3598,383,40733,3042,3,250,1,38000.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1148,3598,383,40733,3042,3,57,2,38000.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1149,3598,384,40733,3042,3,217,1,876.03,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1150,3598,384,40733,3042,3,68,1,183.97,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1151,3598,384,40733,3042,3,57,2,1060.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1152,3598,385,40733,3042,3,217,1,57480.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1153,3598,385,40733,3042,3,68,1,12070.80,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1154,3598,385,40733,3042,3,57,2,69550.80,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1155,3598,386,40733,3042,3,217,1,471.07,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1156,3598,386,40733,3042,3,68,1,98.92,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1157,3598,386,40733,3042,3,57,2,569.99,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1158,3598,387,40733,3042,3,217,1,23520.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1159,3598,387,40733,3042,3,68,1,4939.20,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1160,3598,387,40733,3042,3,57,2,28459.20,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1161,3598,388,40733,3042,3,217,1,471.08,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1162,3598,388,40733,3042,3,68,1,98.93,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1163,3598,388,40733,3042,3,57,2,570.01,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1164,3598,389,40733,3042,3,217,1,471.08,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL);
INSERT INTO `balance_libro_details` VALUES (1165,3598,389,40733,3042,3,68,1,98.93,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1166,3598,389,40733,3042,3,57,2,570.01,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1167,3598,390,40733,3042,3,217,1,3272.75,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1168,3598,390,40733,3042,3,68,1,687.28,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1169,3598,390,40733,3042,3,57,2,3960.03,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1170,3598,391,40733,3042,3,217,1,35113.44,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1171,3598,391,40733,3042,3,68,1,7373.82,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1172,3598,391,40733,3042,3,57,2,42487.26,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1173,3598,392,40733,3042,3,217,1,471.07,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1174,3598,392,40733,3042,3,68,1,98.92,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1175,3598,392,40733,3042,3,57,2,569.99,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1176,3598,393,40733,3042,3,217,1,471.08,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1177,3598,393,40733,3042,3,68,1,98.93,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1178,3598,393,40733,3042,3,57,2,570.01,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1179,3598,394,40733,3042,3,217,2,471.08,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1180,3598,394,40733,3042,3,67,2,98.93,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1181,3598,394,40733,3042,3,57,1,570.01,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1182,3598,395,40733,3042,3,217,1,88330.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1183,3598,395,40733,3042,3,68,1,18549.30,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1184,3598,395,40733,3042,3,57,2,106879.30,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1185,3598,396,40733,3042,3,217,1,22416.14,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1186,3598,396,40733,3042,3,68,1,4707.39,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1187,3598,396,40733,3042,3,57,2,27123.53,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1188,3598,397,40733,3042,3,217,1,876.04,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1189,3598,397,40733,3042,3,68,1,183.97,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1190,3598,397,40733,3042,3,57,2,1060.01,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1191,3598,398,40733,3042,3,217,1,471.07,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1192,3598,398,40733,3042,3,68,1,98.92,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1193,3598,398,40733,3042,3,57,2,569.99,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1194,3598,399,40733,3042,3,217,1,2487.60,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1195,3598,399,40733,3042,3,68,1,522.40,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1196,3598,399,40733,3042,3,57,2,3010.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1197,3598,400,40733,3042,3,217,1,471.08,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1198,3598,400,40733,3042,3,68,1,98.93,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1199,3598,400,40733,3042,3,57,2,570.01,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1200,3598,401,40733,3042,3,217,1,876.03,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1201,3598,401,40733,3042,3,68,1,183.97,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1202,3598,401,40733,3042,3,57,2,1060.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1203,3598,402,40733,3042,3,217,1,13500.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1204,3598,402,40733,3042,3,68,1,2835.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1205,3598,402,40733,3042,3,57,2,16335.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL);
INSERT INTO `balance_libro_details` VALUES (1206,3598,403,40733,3042,3,217,1,471.07,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1207,3598,403,40733,3042,3,68,1,98.92,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1208,3598,403,40733,3042,3,57,2,569.99,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1209,3598,404,40733,3042,3,217,1,876.04,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1210,3598,404,40733,3042,3,68,1,183.97,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1211,3598,404,40733,3042,3,57,2,1060.01,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1212,3598,405,40733,3042,3,217,1,471.08,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1213,3598,405,40733,3042,3,68,1,98.93,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1214,3598,405,40733,3042,3,57,2,570.01,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1215,3598,406,40733,3042,3,217,1,61800.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1216,3598,406,40733,3042,3,68,1,12978.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1217,3598,406,40733,3042,3,57,2,74778.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1218,3598,407,40733,3042,3,217,1,471.07,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1219,3598,407,40733,3042,3,68,1,98.92,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1220,3598,407,40733,3042,3,57,2,569.99,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1221,3598,408,40733,3042,3,217,1,3743.80,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1222,3598,408,40733,3042,3,68,1,786.20,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1223,3598,408,40733,3042,3,57,2,4530.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1224,3598,409,40733,3042,3,217,1,471.07,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1225,3598,409,40733,3042,3,68,1,98.92,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1226,3598,409,40733,3042,3,57,2,569.99,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1227,3598,410,40733,3042,3,217,1,1016.53,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1228,3598,410,40733,3042,3,68,1,213.47,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1229,3598,410,40733,3042,3,57,2,1230.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1230,3598,411,40733,3042,3,217,1,471.07,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1231,3598,411,40733,3042,3,68,1,98.92,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1232,3598,411,40733,3042,3,57,2,569.99,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1233,3598,412,40733,3042,3,217,1,23721.27,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1234,3598,412,40733,3042,3,68,1,4981.47,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1235,3598,412,40733,3042,3,57,2,28702.74,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1236,3598,413,40733,3042,3,250,1,60000.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1237,3598,413,40733,3042,3,57,2,60000.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1238,3598,414,40733,3042,3,250,1,19500.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1239,3598,414,40733,3042,3,57,2,19500.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1240,3598,415,40733,3042,3,217,1,22863.03,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1241,3598,415,40733,3042,3,68,1,4801.24,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1242,3598,415,40733,3042,3,57,2,27664.27,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1243,3598,416,40733,3042,3,217,1,5281.00,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1244,3598,416,40733,3042,3,68,1,1109.01,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1245,3598,416,40733,3042,3,57,2,6390.01,NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(1246,3598,417,40720,1531,2,96,2,199.59,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL);
INSERT INTO `balance_libro_details` VALUES (1247,3598,417,40720,1531,2,67,2,41.91,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1248,3598,417,40720,1531,2,13,1,241.50,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1249,3598,418,40720,1531,2,96,2,1245.99,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1250,3598,418,40720,1531,2,67,2,261.66,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1251,3598,418,40720,1531,2,13,1,1507.65,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1252,3598,419,40720,1531,2,96,2,363.57,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1253,3598,419,40720,1531,2,67,2,76.35,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1254,3598,419,40720,1531,2,13,1,439.92,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1255,3598,420,40720,1531,2,96,2,727.18,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1256,3598,420,40720,1531,2,67,2,152.71,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1257,3598,420,40720,1531,2,13,1,879.89,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1258,3598,421,40720,1531,2,96,2,997.93,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1259,3598,421,40720,1531,2,67,2,209.57,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1260,3598,421,40720,1531,2,13,1,1207.50,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1261,3598,422,40720,1531,2,96,2,4998.22,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1262,3598,422,40720,1531,2,67,2,1049.63,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1263,3598,422,40720,1531,2,13,1,6047.85,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1264,3598,423,40720,1531,2,96,2,817.36,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1265,3598,423,40720,1531,2,67,2,171.64,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1266,3598,423,40720,1531,2,13,1,989.00,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1267,3598,424,40720,1531,2,96,2,2024.79,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1268,3598,424,40720,1531,2,67,2,425.21,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1269,3598,424,40720,1531,2,13,1,2450.00,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1270,3598,425,40720,1531,2,96,2,690.08,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1271,3598,425,40720,1531,2,67,2,144.92,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1272,3598,425,40720,1531,2,13,1,835.00,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1273,3598,426,40720,1531,2,96,2,2972.89,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1274,3598,426,40720,1531,2,67,2,624.31,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1275,3598,426,40720,1531,2,13,1,3597.20,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1276,3598,427,40720,1531,2,96,2,340.50,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1277,3598,427,40720,1531,2,67,2,71.50,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1278,3598,427,40720,1531,2,13,1,412.00,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1279,3598,428,40720,1531,2,96,2,495.94,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1280,3598,428,40720,1531,2,67,2,104.15,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1281,3598,428,40720,1531,2,13,1,600.09,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1282,3598,429,40720,1531,2,96,2,1366.69,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1283,3598,429,40720,1531,2,67,2,287.01,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1284,3598,429,40720,1531,2,13,1,1653.70,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1285,3598,430,40720,1531,2,96,2,413.17,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1286,3598,430,40720,1531,2,67,2,86.76,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1287,3598,430,40720,1531,2,13,1,499.93,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1288,3598,431,40720,1531,2,96,2,1619.83,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL);
INSERT INTO `balance_libro_details` VALUES (1289,3598,431,40720,1531,2,67,2,340.16,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1290,3598,431,40720,1531,2,13,1,1959.99,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1291,3598,432,40720,1531,2,96,2,4817.64,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1292,3598,432,40720,1531,2,67,2,1011.71,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1293,3598,432,40720,1531,2,13,1,5829.35,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1294,3598,433,40720,1531,2,96,2,3013.22,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1295,3598,433,40720,1531,2,67,2,632.78,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1296,3598,433,40720,1531,2,13,1,3646.00,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1297,3598,434,40720,1531,2,96,2,528.91,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1298,3598,434,40720,1531,2,67,2,111.07,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1299,3598,434,40720,1531,2,13,1,639.97,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1300,3598,434,40720,1531,2,136,1,0.01,NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(1301,3598,435,40720,1531,2,96,2,1789.26,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1302,3598,435,40720,1531,2,67,2,375.74,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1303,3598,435,40720,1531,2,13,1,2165.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1304,3598,436,40720,1531,2,96,2,330.50,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1305,3598,436,40720,1531,2,67,2,69.40,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1306,3598,436,40720,1531,2,13,1,399.90,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1307,3598,437,40720,1531,2,96,2,495.93,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1308,3598,437,40720,1531,2,67,2,104.14,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1309,3598,437,40720,1531,2,13,1,600.07,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1310,3598,438,40720,1531,2,96,2,1765.87,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1311,3598,438,40720,1531,2,67,2,370.83,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1312,3598,438,40720,1531,2,13,1,2136.70,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1313,3598,439,40720,1531,2,96,2,1148.76,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1314,3598,439,40720,1531,2,67,2,241.24,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1315,3598,439,40720,1531,2,13,1,1390.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1316,3598,440,40720,1531,2,96,2,1842.15,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1317,3598,440,40720,1531,2,67,2,386.85,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1318,3598,440,40720,1531,2,13,1,2229.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1319,3598,441,40720,1531,2,96,2,4885.12,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1320,3598,441,40720,1531,2,67,2,1025.88,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1321,3598,441,40720,1531,2,13,1,5911.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1322,3598,442,40720,1531,2,96,2,561.98,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1323,3598,442,40720,1531,2,67,2,118.02,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1324,3598,442,40720,1531,2,13,1,680.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1325,3598,443,40720,1531,2,96,2,305.72,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1326,3598,443,40720,1531,2,67,2,64.20,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1327,3598,443,40720,1531,2,13,1,369.92,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1328,3598,444,40720,1531,2,96,2,2825.62,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1329,3598,444,40720,1531,2,67,2,593.38,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1330,3598,444,40720,1531,2,13,1,3419.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL);
INSERT INTO `balance_libro_details` VALUES (1331,3598,445,40720,1531,2,96,2,2763.64,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1332,3598,445,40720,1531,2,67,2,580.36,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1333,3598,445,40720,1531,2,13,1,3344.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1334,3598,446,40720,1531,2,96,2,1322.31,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1335,3598,446,40720,1531,2,67,2,277.69,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1336,3598,446,40720,1531,2,13,1,1600.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1337,3598,447,40720,1531,2,96,2,6370.25,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1338,3598,447,40720,1531,2,67,2,1337.75,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1339,3598,447,40720,1531,2,13,1,7708.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1340,3598,448,40720,1531,2,96,2,1239.67,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1341,3598,448,40720,1531,2,67,2,260.33,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1342,3598,448,40720,1531,2,13,1,1500.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1343,3598,449,40720,1531,2,96,2,940.91,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1344,3598,449,40720,1531,2,67,2,197.59,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1345,3598,449,40720,1531,2,13,1,1138.50,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1346,3598,450,40720,1531,2,96,2,3544.09,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1347,3598,450,40720,1531,2,67,2,744.26,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1348,3598,450,40720,1531,2,13,1,4288.35,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1349,3598,451,40720,1531,2,96,2,2952.93,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1350,3598,451,40720,1531,2,67,2,620.12,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1351,3598,451,40720,1531,2,13,1,3573.05,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1352,3598,452,40720,1531,2,96,2,1619.83,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1353,3598,452,40720,1531,2,67,2,340.17,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1354,3598,452,40720,1531,2,13,1,1960.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1355,3598,453,40720,1531,2,96,2,1157.02,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1356,3598,453,40720,1531,2,67,2,242.98,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1357,3598,453,40720,1531,2,13,1,1400.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1358,3598,454,40720,1531,2,96,2,681.82,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1359,3598,454,40720,1531,2,67,2,143.18,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1360,3598,454,40720,1531,2,13,1,825.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1361,3598,455,40720,1531,2,96,2,495.87,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1362,3598,455,40720,1531,2,67,2,104.13,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1363,3598,455,40720,1531,2,13,1,600.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1364,3598,456,40720,1531,2,96,2,4888.93,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1365,3598,456,40720,1531,2,67,2,1026.67,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1366,3598,456,40720,1531,2,13,1,5915.60,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1367,3598,457,40720,1531,2,96,2,1504.15,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1368,3598,457,40720,1531,2,67,2,315.87,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1369,3598,457,40720,1531,2,13,1,1820.02,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1370,3598,458,40720,1531,2,96,2,2008.26,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1371,3598,458,40720,1531,2,67,2,421.74,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL);
INSERT INTO `balance_libro_details` VALUES (1372,3598,458,40720,1531,2,13,1,2430.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1373,3598,459,40720,1531,2,96,2,3832.07,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1374,3598,459,40720,1531,2,67,2,804.73,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1375,3598,459,40720,1531,2,13,1,4636.80,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1376,3598,460,40720,1531,2,96,2,1256.21,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1377,3598,460,40720,1531,2,67,2,263.80,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1378,3598,460,40720,1531,2,13,1,1520.01,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1379,3598,461,40720,1531,2,96,2,1346.74,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1380,3598,461,40720,1531,2,67,2,282.81,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1381,3598,461,40720,1531,2,13,1,1629.55,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1382,3598,462,40720,1531,2,96,2,1894.21,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1383,3598,462,40720,1531,2,67,2,397.78,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1384,3598,462,40720,1531,2,13,1,2291.99,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1385,3598,463,40720,1531,2,96,2,2263.88,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1386,3598,463,40720,1531,2,67,2,475.42,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1387,3598,463,40720,1531,2,13,1,2739.30,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1388,3598,464,40720,1531,2,96,2,198.35,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1389,3598,464,40720,1531,2,67,2,41.65,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1390,3598,464,40720,1531,2,13,1,240.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1391,3598,465,40720,1531,2,96,2,330.56,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1392,3598,465,40720,1531,2,67,2,69.42,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1393,3598,465,40720,1531,2,13,1,399.98,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1394,3598,466,40720,1531,2,96,2,6066.49,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1395,3598,466,40720,1531,2,67,2,1273.96,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1396,3598,466,40720,1531,2,13,1,7340.45,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1397,3598,467,40720,1531,2,96,2,3985.08,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1398,3598,467,40720,1531,2,67,2,836.87,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1399,3598,467,40720,1531,2,13,1,4821.95,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1400,3598,468,40720,1531,2,96,2,413.30,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1401,3598,468,40720,1531,2,67,2,86.79,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1402,3598,468,40720,1531,2,13,1,500.09,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1403,3598,469,40720,1531,2,96,2,1547.11,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1404,3598,469,40720,1531,2,67,2,324.89,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1405,3598,469,40720,1531,2,13,1,1872.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1406,3598,470,40720,1531,2,96,2,1929.76,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1407,3598,470,40720,1531,2,67,2,405.25,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1408,3598,470,40720,1531,2,13,1,2335.01,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1409,3598,471,40720,1531,2,96,2,2481.82,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1410,3598,471,40720,1531,2,67,2,521.18,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1411,3598,471,40720,1531,2,13,1,3003.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1412,3598,472,40720,1531,2,96,2,2720.08,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL);
INSERT INTO `balance_libro_details` VALUES (1413,3598,472,40720,1531,2,67,2,571.22,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1414,3598,472,40720,1531,2,13,1,3291.30,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1415,3598,473,40720,1531,2,96,2,1452.07,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1416,3598,473,40720,1531,2,67,2,304.93,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1417,3598,473,40720,1531,2,13,1,1757.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1418,3598,474,40720,1531,2,96,2,841.32,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1419,3598,474,40720,1531,2,67,2,176.68,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1420,3598,474,40720,1531,2,13,1,1018.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1421,3598,475,40720,1531,2,96,2,495.93,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1422,3598,475,40720,1531,2,67,2,104.15,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1423,3598,475,40720,1531,2,13,1,600.08,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1424,3598,476,40720,1531,2,96,2,3061.98,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1425,3598,476,40720,1531,2,67,2,643.02,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1426,3598,476,40720,1531,2,13,1,3705.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1427,3598,477,40720,1531,2,96,2,911.57,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1428,3598,477,40720,1531,2,67,2,191.43,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1429,3598,477,40720,1531,2,13,1,1103.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1430,3598,478,40720,1531,2,96,2,983.59,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1431,3598,478,40720,1531,2,67,2,206.55,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1432,3598,478,40720,1531,2,13,1,1190.14,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1433,3598,479,40720,1531,2,96,2,636.38,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1434,3598,479,40720,1531,2,67,2,133.64,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1435,3598,479,40720,1531,2,13,1,770.02,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1436,3598,480,40720,1531,2,96,2,479.40,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1437,3598,480,40720,1531,2,67,2,100.67,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1438,3598,480,40720,1531,2,13,1,580.07,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1439,3598,481,40720,1531,2,96,2,1595.04,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1440,3598,481,40720,1531,2,67,2,334.96,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1441,3598,481,40720,1531,2,13,1,1930.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1442,3598,482,40720,1531,2,96,2,1865.40,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1443,3598,482,40720,1531,2,67,2,391.73,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1444,3598,482,40720,1531,2,13,1,2257.13,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1445,3598,483,40720,1531,2,96,2,363.54,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1446,3598,483,40720,1531,2,67,2,76.34,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1447,3598,483,40720,1531,2,13,1,439.88,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1448,3598,484,40720,1531,2,96,2,471.20,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1449,3598,484,40720,1531,2,67,2,98.95,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1450,3598,484,40720,1531,2,218,2,0.01,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1451,3598,484,40720,1531,2,13,1,570.16,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1452,3598,485,40720,1531,2,96,2,489.26,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1453,3598,485,40720,1531,2,67,2,102.74,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1454,3598,485,40720,1531,2,13,1,592.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL);
INSERT INTO `balance_libro_details` VALUES (1455,3598,486,40720,1531,2,96,2,330.59,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1456,3598,486,40720,1531,2,67,2,69.42,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1457,3598,486,40720,1531,2,13,1,400.01,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1458,3598,487,40720,1531,2,96,2,1582.44,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1459,3598,487,40720,1531,2,67,2,332.31,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1460,3598,487,40720,1531,2,13,1,1914.75,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1461,3598,488,40720,1531,2,96,2,1157.88,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1462,3598,488,40720,1531,2,67,2,243.15,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1463,3598,488,40720,1531,2,13,1,1401.03,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1464,3598,489,40720,1531,2,96,2,2138.43,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1465,3598,489,40720,1531,2,67,2,449.07,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1466,3598,489,40720,1531,2,13,1,2587.50,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1467,3598,490,40720,1531,2,96,2,247.96,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1468,3598,490,40720,1531,2,67,2,52.07,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1469,3598,490,40720,1531,2,13,1,300.03,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1470,3598,491,40720,1531,2,96,2,289.24,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1471,3598,491,40720,1531,2,67,2,60.74,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1472,3598,491,40720,1531,2,13,1,349.98,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1473,3598,492,40720,1531,2,96,2,330.56,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1474,3598,492,40720,1531,2,67,2,69.42,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1475,3598,492,40720,1531,2,13,1,399.98,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1476,3598,493,40720,1531,2,96,2,247.93,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1477,3598,493,40720,1531,2,67,2,52.07,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1478,3598,493,40720,1531,2,13,1,300.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1479,3598,494,40720,1531,2,96,2,363.57,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1480,3598,494,40720,1531,2,67,2,76.35,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1481,3598,494,40720,1531,2,13,1,439.92,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1482,3598,495,40720,1531,2,96,2,318.18,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1483,3598,495,40720,1531,2,67,2,66.82,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1484,3598,495,40720,1531,2,13,1,385.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1485,3598,496,40720,1531,2,96,2,1619.83,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1486,3598,496,40720,1531,2,67,2,340.17,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1487,3598,496,40720,1531,2,13,1,1960.00,NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(1488,3598,497,40720,1531,2,96,2,690.08,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1489,3598,497,40720,1531,2,67,2,144.92,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1490,3598,497,40720,1531,2,13,1,835.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1491,3598,498,40720,1531,2,96,2,82.74,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1492,3598,498,40720,1531,2,67,2,17.37,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1493,3598,498,40720,1531,2,13,1,100.11,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1494,3598,499,40720,1531,2,96,2,82.66,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1495,3598,499,40720,1531,2,67,2,17.36,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1496,3598,499,40720,1531,2,13,1,100.02,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL);
INSERT INTO `balance_libro_details` VALUES (1497,3598,500,40720,1531,2,96,2,1504.16,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1498,3598,500,40720,1531,2,67,2,315.87,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1499,3598,500,40720,1531,2,13,1,1820.03,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1500,3598,501,40720,1531,2,96,2,855.55,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1501,3598,501,40720,1531,2,67,2,179.66,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1502,3598,501,40720,1531,2,13,1,1035.21,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1503,3598,502,40720,1531,2,96,2,859.67,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1504,3598,502,40720,1531,2,67,2,180.53,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1505,3598,502,40720,1531,2,13,1,1040.20,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1506,3598,503,40720,1531,2,96,2,4390.08,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1507,3598,503,40720,1531,2,67,2,921.92,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1508,3598,503,40720,1531,2,13,1,5312.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1509,3598,504,40720,1531,2,96,2,1958.68,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1510,3598,504,40720,1531,2,67,2,411.32,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1511,3598,504,40720,1531,2,13,1,2370.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1512,3598,505,40720,1531,2,96,2,2365.29,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1513,3598,505,40720,1531,2,67,2,496.71,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1514,3598,505,40720,1531,2,13,1,2862.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1515,3598,506,40720,1531,2,96,2,1140.50,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1516,3598,506,40720,1531,2,67,2,239.50,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1517,3598,506,40720,1531,2,13,1,1380.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1518,3598,507,40720,1531,2,96,2,2240.50,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1519,3598,507,40720,1531,2,67,2,470.50,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1520,3598,507,40720,1531,2,13,1,2711.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1521,3598,508,40720,1531,2,96,2,1931.24,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1522,3598,508,40720,1531,2,67,2,405.56,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1523,3598,508,40720,1531,2,13,1,2336.80,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1524,3598,509,40720,1531,2,96,2,1363.57,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1525,3598,509,40720,1531,2,67,2,286.35,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1526,3598,509,40720,1531,2,13,1,1649.92,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1527,3598,510,40720,1531,2,96,2,376.86,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1528,3598,510,40720,1531,2,67,2,79.14,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1529,3598,510,40720,1531,2,13,1,456.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1530,3598,511,40720,1531,2,96,2,1628.10,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1531,3598,511,40720,1531,2,67,2,341.90,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1532,3598,511,40720,1531,2,13,1,1970.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1533,3598,512,40720,1531,2,96,2,1552.07,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1534,3598,512,40720,1531,2,67,2,325.93,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1535,3598,512,40720,1531,2,13,1,1878.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1536,3598,513,40720,1531,2,96,2,1917.36,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1537,3598,513,40720,1531,2,67,2,402.64,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL);
INSERT INTO `balance_libro_details` VALUES (1538,3598,513,40720,1531,2,13,1,2320.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1539,3598,514,40720,1531,2,96,2,578.45,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1540,3598,514,40720,1531,2,67,2,121.48,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1541,3598,514,40720,1531,2,13,1,699.93,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1542,3598,515,40720,1531,2,96,2,586.84,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1543,3598,515,40720,1531,2,67,2,123.24,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1544,3598,515,40720,1531,2,13,1,710.08,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1545,3598,516,40720,1531,2,96,2,1239.63,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1546,3598,516,40720,1531,2,67,2,260.32,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1547,3598,516,40720,1531,2,13,1,1499.95,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1548,3598,517,40720,1531,2,96,2,330.60,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1549,3598,517,40720,1531,2,67,2,69.42,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1550,3598,517,40720,1531,2,13,1,400.02,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1551,3598,518,40720,1531,2,96,2,998.35,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1552,3598,518,40720,1531,2,67,2,209.65,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1553,3598,518,40720,1531,2,13,1,1208.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1554,3598,519,40720,1531,2,96,2,944.71,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1555,3598,519,40720,1531,2,67,2,198.39,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1556,3598,519,40720,1531,2,13,1,1143.10,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1557,3598,520,40720,1531,2,96,2,919.01,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1558,3598,520,40720,1531,2,67,2,192.99,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1559,3598,520,40720,1531,2,13,1,1112.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1560,3598,521,40720,1531,2,96,2,2396.69,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1561,3598,521,40720,1531,2,67,2,503.31,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1562,3598,521,40720,1531,2,13,1,2900.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1563,3598,522,40720,1531,2,96,2,1619.83,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1564,3598,522,40720,1531,2,67,2,340.17,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1565,3598,522,40720,1531,2,13,1,1960.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1566,3598,523,40720,1531,2,96,2,165.41,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1567,3598,523,40720,1531,2,67,2,34.74,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1568,3598,523,40720,1531,2,13,1,200.15,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1569,3598,524,40720,1531,2,96,2,206.74,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1570,3598,524,40720,1531,2,67,2,43.41,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1571,3598,524,40720,1531,2,13,1,250.14,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1572,3598,524,40720,1531,2,136,1,0.01,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1573,3598,525,40720,1531,2,96,2,157.02,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1574,3598,525,40720,1531,2,67,2,32.98,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1575,3598,525,40720,1531,2,13,1,190.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1576,3598,526,40720,1531,2,96,2,371.77,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1577,3598,526,40720,1531,2,67,2,78.07,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1578,3598,526,40720,1531,2,13,1,449.84,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1579,3598,527,40720,1531,2,96,2,1652.89,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL);
INSERT INTO `balance_libro_details` VALUES (1580,3598,527,40720,1531,2,67,2,347.11,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1581,3598,527,40720,1531,2,13,1,2000.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1582,3598,528,40720,1531,2,96,2,702.36,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1583,3598,528,40720,1531,2,67,2,147.49,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1584,3598,528,40720,1531,2,13,1,849.85,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1585,3598,529,40720,1531,2,96,2,1157.02,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1586,3598,529,40720,1531,2,67,2,242.98,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1587,3598,529,40720,1531,2,13,1,1400.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1588,3598,530,40720,1531,2,96,2,1862.81,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1589,3598,530,40720,1531,2,67,2,391.19,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1590,3598,530,40720,1531,2,13,1,2254.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1591,3598,531,40720,1531,2,96,2,1341.98,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1592,3598,531,40720,1531,2,67,2,281.82,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1593,3598,531,40720,1531,2,13,1,1623.80,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1594,3598,532,40720,1531,2,96,2,3595.04,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1595,3598,532,40720,1531,2,67,2,754.96,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1596,3598,532,40720,1531,2,13,1,4350.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1597,3598,533,40720,1531,2,96,2,727.27,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1598,3598,533,40720,1531,2,67,2,152.73,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1599,3598,533,40720,1531,2,13,1,880.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1600,3598,534,40720,1531,2,96,2,1619.83,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1601,3598,534,40720,1531,2,67,2,340.17,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1602,3598,534,40720,1531,2,13,1,1960.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1603,3598,535,40720,1531,2,96,2,1801.65,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1604,3598,535,40720,1531,2,67,2,378.35,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1605,3598,535,40720,1531,2,13,1,2180.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1606,3598,536,40720,1531,2,96,2,2071.90,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1607,3598,536,40720,1531,2,67,2,435.10,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1608,3598,536,40720,1531,2,13,1,2507.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1609,3598,537,40720,1531,2,96,2,2314.05,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1610,3598,537,40720,1531,2,67,2,485.95,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1611,3598,537,40720,1531,2,13,1,2800.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1612,3598,538,40720,1531,2,96,2,1463.64,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1613,3598,538,40720,1531,2,67,2,307.36,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1614,3598,538,40720,1531,2,13,1,1771.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1615,3598,539,40720,1531,2,96,2,1842.15,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1616,3598,539,40720,1531,2,67,2,386.85,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1617,3598,539,40720,1531,2,13,1,2229.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1618,3598,540,40720,1531,2,96,2,1132.23,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1619,3598,540,40720,1531,2,67,2,237.77,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1620,3598,540,40720,1531,2,13,1,1370.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL);
INSERT INTO `balance_libro_details` VALUES (1621,3598,541,40720,1531,2,96,2,471.15,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1622,3598,541,40720,1531,2,67,2,98.94,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1623,3598,541,40720,1531,2,13,1,570.09,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1624,3598,542,40720,1531,2,96,2,826.48,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1625,3598,542,40720,1531,2,67,2,173.56,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1626,3598,542,40720,1531,2,13,1,1000.04,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1627,3598,543,40720,1531,2,96,2,454.54,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1628,3598,543,40720,1531,2,67,2,95.45,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1629,3598,543,40720,1531,2,13,1,549.99,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1630,3598,544,40720,1531,2,96,2,495.80,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1631,3598,544,40720,1531,2,67,2,104.12,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1632,3598,544,40720,1531,2,13,1,599.92,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1633,3598,545,40720,1531,2,96,2,494.21,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1634,3598,545,40720,1531,2,67,2,103.79,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1635,3598,545,40720,1531,2,13,1,598.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1636,3598,546,40720,1531,2,96,2,233.06,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1637,3598,546,40720,1531,2,67,2,48.94,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1638,3598,546,40720,1531,2,13,1,282.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1639,3598,547,40720,1531,2,96,2,2308.55,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1640,3598,547,40720,1531,2,67,2,484.80,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1641,3598,547,40720,1531,2,13,1,2793.35,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1642,3598,548,40720,1531,2,96,2,330.60,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1643,3598,548,40720,1531,2,67,2,69.43,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1644,3598,548,40720,1531,2,13,1,400.03,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1645,3598,549,40720,1531,2,96,2,425.62,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1646,3598,549,40720,1531,2,67,2,89.38,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1647,3598,549,40720,1531,2,13,1,515.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1648,3598,550,40720,1531,2,96,2,196.69,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1649,3598,550,40720,1531,2,67,2,41.31,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1650,3598,550,40720,1531,2,13,1,238.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1651,3598,551,40720,1531,2,96,2,1355.37,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1652,3598,551,40720,1531,2,67,2,284.63,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1653,3598,551,40720,1531,2,13,1,1640.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1654,3598,552,40720,1531,2,96,2,2737.19,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1655,3598,552,40720,1531,2,67,2,574.81,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1656,3598,552,40720,1531,2,13,1,3312.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1657,3598,553,40720,1531,2,96,2,2669.71,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1658,3598,553,40720,1531,2,67,2,560.64,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1659,3598,553,40720,1531,2,13,1,3230.35,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1660,3598,554,40720,1531,2,96,2,2278.14,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1661,3598,554,40720,1531,2,67,2,478.41,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1662,3598,554,40720,1531,2,13,1,2756.55,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL);
INSERT INTO `balance_libro_details` VALUES (1663,3598,555,40720,1531,2,96,2,354.55,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1664,3598,555,40720,1531,2,67,2,74.45,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1665,3598,555,40720,1531,2,13,1,429.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1666,3598,556,40720,1531,2,96,2,479.34,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1667,3598,556,40720,1531,2,67,2,100.66,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1668,3598,556,40720,1531,2,13,1,580.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1669,3598,557,40720,1531,2,96,2,2544.59,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1670,3598,557,40720,1531,2,67,2,534.36,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1671,3598,557,40720,1531,2,13,1,3078.95,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1672,3598,558,40720,1531,2,96,2,1862.81,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1673,3598,558,40720,1531,2,67,2,391.19,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1674,3598,558,40720,1531,2,13,1,2254.00,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1675,3598,559,40720,1531,2,96,2,413.06,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1676,3598,559,40720,1531,2,67,2,86.74,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1677,3598,559,40720,1531,2,13,1,499.80,NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(1678,3598,560,40720,1531,2,96,2,373.67,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1679,3598,560,40720,1531,2,67,2,78.47,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1680,3598,560,40720,1531,2,13,1,452.13,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1681,3598,560,40720,1531,2,136,1,0.01,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1682,3598,561,40720,1531,2,96,2,2024.79,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1683,3598,561,40720,1531,2,67,2,425.21,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1684,3598,561,40720,1531,2,13,1,2450.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1685,3598,562,40720,1531,2,96,2,1727.23,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1686,3598,562,40720,1531,2,67,2,362.72,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1687,3598,562,40720,1531,2,13,1,2089.95,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1688,3598,563,40720,1531,2,96,2,214.85,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1689,3598,563,40720,1531,2,67,2,45.12,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1690,3598,563,40720,1531,2,13,1,259.97,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1691,3598,564,40720,1531,2,96,2,1537.19,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1692,3598,564,40720,1531,2,67,2,322.81,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1693,3598,564,40720,1531,2,13,1,1860.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1694,3598,565,40720,1531,2,96,2,1570.08,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1695,3598,565,40720,1531,2,67,2,329.72,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1696,3598,565,40720,1531,2,13,1,1899.80,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1697,3598,566,40720,1531,2,96,2,1743.80,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1698,3598,566,40720,1531,2,67,2,366.20,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1699,3598,566,40720,1531,2,13,1,2110.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1700,3598,567,40720,1531,2,96,2,404.97,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1701,3598,567,40720,1531,2,67,2,85.04,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1702,3598,567,40720,1531,2,13,1,490.01,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1703,3598,568,40720,1531,2,96,2,785.22,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1704,3598,568,40720,1531,2,67,2,164.90,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL);
INSERT INTO `balance_libro_details` VALUES (1705,3598,568,40720,1531,2,13,1,950.12,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1706,3598,569,40720,1531,2,96,2,231.40,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1707,3598,569,40720,1531,2,67,2,48.60,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1708,3598,569,40720,1531,2,13,1,280.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1709,3598,570,40720,1531,2,96,2,743.80,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1710,3598,570,40720,1531,2,67,2,156.20,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1711,3598,570,40720,1531,2,13,1,900.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1712,3598,571,40720,1531,2,96,2,652.92,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1713,3598,571,40720,1531,2,67,2,137.11,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1714,3598,571,40720,1531,2,13,1,790.03,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1715,3598,572,40720,1531,2,96,2,6264.46,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1716,3598,572,40720,1531,2,67,2,1315.54,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1717,3598,572,40720,1531,2,13,1,7580.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1718,3598,573,40720,1531,2,96,2,382.11,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1719,3598,573,40720,1531,2,67,2,80.24,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1720,3598,573,40720,1531,2,13,1,462.35,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1721,3598,574,40720,1531,2,96,2,1122.30,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1722,3598,574,40720,1531,2,67,2,235.68,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1723,3598,574,40720,1531,2,13,1,1357.98,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1724,3598,575,40720,1531,2,96,2,3297.52,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1725,3598,575,40720,1531,2,67,2,692.48,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1726,3598,575,40720,1531,2,13,1,3990.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1727,3598,576,40720,1531,2,96,2,1045.45,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1728,3598,576,40720,1531,2,67,2,219.55,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1729,3598,576,40720,1531,2,13,1,1265.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1730,3598,577,40720,1531,2,96,2,1049.69,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1731,3598,577,40720,1531,2,67,2,220.43,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1732,3598,577,40720,1531,2,13,1,1270.12,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1733,3598,578,40720,1531,2,96,2,330.50,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1734,3598,578,40720,1531,2,67,2,69.41,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1735,3598,578,40720,1531,2,13,1,399.91,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1736,3598,579,40720,1531,2,96,2,578.51,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1737,3598,579,40720,1531,2,67,2,121.49,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1738,3598,579,40720,1531,2,13,1,700.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1739,3598,580,40720,1531,2,96,2,2165.47,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1740,3598,580,40720,1531,2,67,2,454.75,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1741,3598,580,40720,1531,2,13,1,2620.22,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1742,3598,581,40720,1531,2,96,2,948.48,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1743,3598,581,40720,1531,2,67,2,199.18,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1744,3598,581,40720,1531,2,13,1,1147.65,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1745,3598,581,40720,1531,2,136,1,0.01,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1746,3598,582,40720,1531,2,96,2,165.30,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL);
INSERT INTO `balance_libro_details` VALUES (1747,3598,582,40720,1531,2,67,2,34.71,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1748,3598,582,40720,1531,2,13,1,200.01,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1749,3598,583,40720,1531,2,96,2,600.07,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1750,3598,583,40720,1531,2,67,2,126.02,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1751,3598,583,40720,1531,2,13,1,726.09,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1752,3598,584,40720,1531,2,96,2,289.23,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1753,3598,584,40720,1531,2,67,2,60.74,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1754,3598,584,40720,1531,2,13,1,349.97,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1755,3598,585,40720,1531,2,96,2,413.17,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1756,3598,585,40720,1531,2,67,2,86.77,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1757,3598,585,40720,1531,2,13,1,499.94,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1758,3598,586,40720,1531,2,96,2,495.87,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1759,3598,586,40720,1531,2,67,2,104.13,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1760,3598,586,40720,1531,2,13,1,600.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1761,3598,587,40720,1531,2,96,2,1566.12,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1762,3598,587,40720,1531,2,67,2,328.88,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1763,3598,587,40720,1531,2,13,1,1895.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1764,3598,588,40720,1531,2,96,2,1834.30,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1765,3598,588,40720,1531,2,67,2,385.20,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1766,3598,588,40720,1531,2,13,1,2219.50,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1767,3598,589,40720,1531,2,96,2,2661.16,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1768,3598,589,40720,1531,2,67,2,558.84,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1769,3598,589,40720,1531,2,13,1,3220.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1770,3598,590,40720,1531,2,96,2,413.16,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1771,3598,590,40720,1531,2,67,2,86.76,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1772,3598,590,40720,1531,2,13,1,499.92,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1773,3598,591,40720,1531,2,96,2,1517.36,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1774,3598,591,40720,1531,2,67,2,318.64,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1775,3598,591,40720,1531,2,13,1,1836.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1776,3598,592,40720,1531,2,96,2,380.17,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1777,3598,592,40720,1531,2,67,2,79.83,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1778,3598,592,40720,1531,2,13,1,460.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1779,3598,593,40720,1531,2,96,2,3801.65,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1780,3598,593,40720,1531,2,67,2,798.35,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1781,3598,593,40720,1531,2,13,1,4600.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1782,3598,594,40720,1531,2,96,2,1652.98,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1783,3598,594,40720,1531,2,67,2,347.12,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1784,3598,594,40720,1531,2,13,1,2000.10,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1785,3598,595,40720,1531,2,96,2,867.60,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1786,3598,595,40720,1531,2,67,2,182.19,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1787,3598,595,40720,1531,2,13,1,1049.79,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1788,3598,596,40720,1531,2,96,2,413.21,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL);
INSERT INTO `balance_libro_details` VALUES (1789,3598,596,40720,1531,2,67,2,86.78,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1790,3598,596,40720,1531,2,13,1,499.98,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1791,3598,596,40720,1531,2,136,1,0.01,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1792,3598,597,40720,1531,2,96,2,553.70,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1793,3598,597,40720,1531,2,67,2,116.28,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1794,3598,597,40720,1531,2,13,1,669.98,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1795,3598,598,40720,1531,2,96,2,413.20,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1796,3598,598,40720,1531,2,67,2,86.77,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1797,3598,598,40720,1531,2,13,1,499.97,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1798,3598,599,40720,1531,2,96,2,413.25,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1799,3598,599,40720,1531,2,67,2,86.78,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1800,3598,599,40720,1531,2,13,1,500.03,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1801,3598,600,40720,1531,2,96,2,1607.15,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1802,3598,600,40720,1531,2,67,2,337.50,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1803,3598,600,40720,1531,2,13,1,1944.65,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1804,3598,601,40720,1531,2,96,2,140.50,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1805,3598,601,40720,1531,2,67,2,29.51,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1806,3598,601,40720,1531,2,13,1,170.01,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1807,3598,602,40720,1531,2,96,2,766.94,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1808,3598,602,40720,1531,2,67,2,161.06,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1809,3598,602,40720,1531,2,13,1,928.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1810,3598,603,40720,1531,2,96,2,1463.64,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1811,3598,603,40720,1531,2,67,2,307.36,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1812,3598,603,40720,1531,2,13,1,1771.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1813,3598,604,40720,1531,2,96,2,413.21,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1814,3598,604,40720,1531,2,67,2,86.78,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1815,3598,604,40720,1531,2,13,1,499.99,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1816,3598,605,40720,1531,2,96,2,1595.04,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1817,3598,605,40720,1531,2,67,2,334.96,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1818,3598,605,40720,1531,2,13,1,1930.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1819,3598,606,40720,1531,2,96,2,1379.26,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1820,3598,606,40720,1531,2,67,2,289.65,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1821,3598,606,40720,1531,2,13,1,1668.91,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1822,3598,607,40720,1531,2,96,2,455.78,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1823,3598,607,40720,1531,2,67,2,95.71,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1824,3598,607,40720,1531,2,13,1,551.49,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1825,3598,608,40720,1531,2,96,2,909.07,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1826,3598,608,40720,1531,2,67,2,190.90,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1827,3598,608,40720,1531,2,13,1,1099.97,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1828,3598,609,40720,1531,2,96,2,376.89,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1829,3598,609,40720,1531,2,67,2,79.15,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1830,3598,609,40720,1531,2,218,2,0.01,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL);
INSERT INTO `balance_libro_details` VALUES (1831,3598,609,40720,1531,2,13,1,456.05,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1832,3598,610,40720,1531,2,96,2,2062.40,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1833,3598,610,40720,1531,2,67,2,433.10,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1834,3598,610,40720,1531,2,13,1,2495.50,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1835,3598,611,40720,1531,2,96,2,1862.81,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1836,3598,611,40720,1531,2,67,2,391.19,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1837,3598,611,40720,1531,2,13,1,2254.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1838,3598,612,40720,1531,2,96,2,2100.87,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1839,3598,612,40720,1531,2,67,2,441.18,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1840,3598,612,40720,1531,2,13,1,2542.05,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1841,3598,613,40720,1531,2,96,2,7652.73,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1842,3598,613,40720,1531,2,67,2,1607.07,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1843,3598,613,40720,1531,2,13,1,9259.80,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1844,3598,614,40720,1531,2,96,2,561.98,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1845,3598,614,40720,1531,2,67,2,118.02,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1846,3598,614,40720,1531,2,13,1,680.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1847,3598,615,40720,1531,2,96,2,2055.37,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1848,3598,615,40720,1531,2,67,2,431.63,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1849,3598,615,40720,1531,2,13,1,2487.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1850,3598,616,40720,1531,2,96,2,1045.81,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1851,3598,616,40720,1531,2,67,2,219.62,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1852,3598,616,40720,1531,2,13,1,1265.43,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1853,3598,617,40720,1531,2,96,2,1322.31,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1854,3598,617,40720,1531,2,67,2,277.68,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1855,3598,617,40720,1531,2,13,1,1599.99,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1856,3598,618,40720,1531,2,96,2,850.41,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1857,3598,618,40720,1531,2,67,2,178.59,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1858,3598,618,40720,1531,2,13,1,1029.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1859,3598,619,40720,1531,2,96,2,1565.29,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1860,3598,619,40720,1531,2,67,2,328.71,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1861,3598,619,40720,1531,2,13,1,1894.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1862,3598,620,40720,1531,2,96,2,1198.35,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1863,3598,620,40720,1531,2,67,2,251.65,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1864,3598,620,40720,1531,2,13,1,1450.00,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1865,3598,621,40720,1531,2,96,2,556.50,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1866,3598,621,40720,1531,2,67,2,116.86,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1867,3598,621,40720,1531,2,13,1,673.36,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1868,3598,622,40720,1531,2,96,2,1743.80,NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(1869,3598,622,40720,1531,2,67,2,366.20,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1870,3598,622,40720,1531,2,13,1,2110.00,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1871,3598,623,40720,1531,2,96,2,826.33,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL);
INSERT INTO `balance_libro_details` VALUES (1872,3598,623,40720,1531,2,67,2,173.53,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1873,3598,623,40720,1531,2,13,1,999.86,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1874,3598,624,40720,1531,2,96,2,1669.50,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1875,3598,624,40720,1531,2,67,2,350.59,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1876,3598,624,40720,1531,2,13,1,2020.09,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1877,3598,625,40720,1531,2,96,2,545.45,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1878,3598,625,40720,1531,2,67,2,114.55,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1879,3598,625,40720,1531,2,13,1,660.00,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1880,3598,626,40720,1531,2,96,2,2719.01,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1881,3598,626,40720,1531,2,67,2,570.99,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1882,3598,626,40720,1531,2,13,1,3290.00,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1883,3598,627,40720,1531,2,96,2,413.17,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1884,3598,627,40720,1531,2,67,2,86.76,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1885,3598,627,40720,1531,2,13,1,499.93,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1886,3598,628,40720,1531,2,96,2,2138.02,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1887,3598,628,40720,1531,2,67,2,448.98,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1888,3598,628,40720,1531,2,13,1,2587.00,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1889,3598,629,40720,1531,2,96,2,1123.95,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1890,3598,629,40720,1531,2,67,2,236.03,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1891,3598,629,40720,1531,2,13,1,1359.98,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1892,3598,630,40720,1531,2,96,2,1132.07,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1893,3598,630,40720,1531,2,67,2,237.74,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1894,3598,630,40720,1531,2,13,1,1369.81,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1895,3598,631,40720,1531,2,96,2,413.21,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1896,3598,631,40720,1531,2,67,2,86.78,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1897,3598,631,40720,1531,2,13,1,499.99,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1898,3598,632,40720,1531,2,96,2,3549.79,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1899,3598,632,40720,1531,2,67,2,745.46,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1900,3598,632,40720,1531,2,13,1,4295.25,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1901,3598,633,40720,1531,2,96,2,165.31,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1902,3598,633,40720,1531,2,67,2,34.72,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1903,3598,633,40720,1531,2,13,1,200.03,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1904,3598,634,40720,1531,2,96,2,2614.44,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1905,3598,634,40720,1531,2,67,2,549.03,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1906,3598,634,40720,1531,2,13,1,3163.47,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1907,3598,635,40720,1531,2,96,2,743.73,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1908,3598,635,40720,1531,2,67,2,156.18,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1909,3598,635,40720,1531,2,13,1,899.91,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1910,3598,636,40720,1531,2,96,2,689.26,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1911,3598,636,40720,1531,2,67,2,144.74,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1912,3598,636,40720,1531,2,13,1,834.00,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1913,3598,637,40720,1531,2,96,2,204.96,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL);
INSERT INTO `balance_libro_details` VALUES (1914,3598,637,40720,1531,2,67,2,43.04,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1915,3598,637,40720,1531,2,13,1,248.00,NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(1916,3598,638,40720,1531,2,96,2,661.13,NULL,'2021-05-16 21:55:04','2021-05-17 15:59:12','2021-05-17 15:59:12'),(1917,3598,638,40720,1531,2,67,2,138.84,NULL,'2021-05-16 21:55:04','2021-05-17 15:59:12','2021-05-17 15:59:12'),(1918,3598,638,40720,1531,2,13,1,799.97,NULL,'2021-05-16 21:55:04','2021-05-17 15:59:12','2021-05-17 15:59:12'),(1919,3598,639,40720,1531,3,217,1,41623.60,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1920,3598,639,40720,1531,3,68,1,8740.96,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1921,3598,639,40720,1531,3,57,2,50364.56,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1922,3598,640,40720,1531,3,217,1,11712.17,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1923,3598,640,40720,1531,3,68,1,2459.56,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1924,3598,640,40720,1531,3,57,2,14171.73,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1925,3598,641,40720,1531,3,217,2,1960.29,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1926,3598,641,40720,1531,3,67,2,411.66,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1927,3598,641,40720,1531,3,57,1,2371.95,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1928,3598,642,40720,1531,3,217,2,4298.44,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1929,3598,642,40720,1531,3,67,2,902.67,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1930,3598,642,40720,1531,3,57,1,5201.11,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1931,3598,643,40720,1531,3,217,2,7228.93,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1932,3598,643,40720,1531,3,67,2,1518.08,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1933,3598,643,40720,1531,3,57,1,8747.01,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1934,3598,644,40720,1531,3,217,1,30111.81,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1935,3598,644,40720,1531,3,68,1,6323.48,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1936,3598,644,40720,1531,3,57,2,36435.29,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1937,3598,645,40720,1531,3,217,1,41113.11,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1938,3598,645,40720,1531,3,68,1,8633.75,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1939,3598,645,40720,1531,3,57,2,49746.86,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1940,3598,646,40720,1531,3,217,1,23644.90,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1941,3598,646,40720,1531,3,68,1,4965.43,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1942,3598,646,40720,1531,3,57,2,28610.33,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1943,3598,647,40720,1531,3,217,1,42925.86,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1944,3598,647,40720,1531,3,68,1,9014.44,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1945,3598,647,40720,1531,3,57,2,51940.30,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1946,3598,648,40720,1531,3,217,1,7434.95,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1947,3598,648,40720,1531,3,68,1,1561.34,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1948,3598,648,40720,1531,3,57,2,8996.29,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54');
INSERT INTO `balance_libro_details` VALUES (1949,3598,649,40720,1531,3,217,1,11188.97,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1950,3598,649,40720,1531,3,68,1,2349.68,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1951,3598,649,40720,1531,3,57,2,13538.65,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1952,3598,650,40720,1531,3,217,1,1668.34,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1953,3598,650,40720,1531,3,68,1,350.36,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1954,3598,650,40720,1531,3,217,1,66.73,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1955,3598,650,40720,1531,3,57,2,2085.43,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1956,3598,651,40720,1531,3,217,2,11712.15,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1957,3598,651,40720,1531,3,67,2,2459.55,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1958,3598,651,40720,1531,3,57,1,14171.70,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1959,3598,652,40720,1531,3,217,1,11711.75,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1960,3598,652,40720,1531,3,68,1,2459.47,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1961,3598,652,40720,1531,3,57,2,14171.22,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1962,3598,653,40720,1531,3,217,2,1202.72,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1963,3598,653,40720,1531,3,67,2,252.57,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1964,3598,653,40720,1531,3,57,1,1455.29,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1965,3598,654,40720,1531,3,217,1,141.61,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1966,3598,654,40720,1531,3,68,1,29.74,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1967,3598,654,40720,1531,3,217,1,0.01,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1968,3598,654,40720,1531,3,57,2,171.36,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1969,3598,655,40720,1531,3,217,1,46043.37,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1970,3598,655,40720,1531,3,68,1,9669.11,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1971,3598,655,40720,1531,3,57,2,55712.48,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1972,3598,656,40720,1531,3,217,1,212.42,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1973,3598,656,40720,1531,3,68,1,44.61,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1974,3598,656,40720,1531,3,217,1,0.01,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1975,3598,656,40720,1531,3,57,2,257.04,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1976,3598,657,40720,1531,3,217,2,46043.37,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1977,3598,657,40720,1531,3,67,2,9669.11,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1978,3598,657,40720,1531,3,57,1,55712.48,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1979,3598,658,40720,1531,3,217,1,21322.44,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1980,3598,658,40720,1531,3,68,1,4477.72,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1981,3598,658,40720,1531,3,57,2,25800.16,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1982,3598,659,40720,1531,3,217,1,7522.57,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1983,3598,659,40720,1531,3,68,1,1579.74,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54');
INSERT INTO `balance_libro_details` VALUES (1984,3598,659,40720,1531,3,57,2,9102.31,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1985,3598,660,40720,1531,3,217,1,47.11,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1986,3598,660,40720,1531,3,68,1,9.89,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1987,3598,660,40720,1531,3,57,2,57.00,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1988,3598,661,40720,1531,3,217,1,59072.80,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1989,3598,661,40720,1531,3,68,1,12405.29,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1990,3598,661,40720,1531,3,57,2,71478.09,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1991,3598,662,40720,1531,3,217,1,16118.90,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1992,3598,662,40720,1531,3,68,1,3384.97,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1993,3598,662,40720,1531,3,57,2,19503.87,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1994,3598,663,40720,1531,3,217,1,13275.98,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1995,3598,663,40720,1531,3,68,1,2787.96,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1996,3598,663,40720,1531,3,57,2,16063.94,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1997,3598,664,40720,1531,3,217,2,3067.50,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1998,3598,664,40720,1531,3,67,2,644.18,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(1999,3598,664,40720,1531,3,57,1,3711.68,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2000,3598,665,40720,1531,3,217,1,10973.50,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2001,3598,665,40720,1531,3,68,1,2304.44,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2002,3598,665,40720,1531,3,57,2,13277.94,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2003,3598,666,40720,1531,3,217,2,1153.80,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2004,3598,666,40720,1531,3,67,2,242.30,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2005,3598,666,40720,1531,3,57,1,1396.10,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2006,3598,667,40720,1531,3,217,1,6243.88,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2007,3598,667,40720,1531,3,68,1,1311.21,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2008,3598,667,40720,1531,3,57,2,7555.09,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2009,3598,668,40720,1531,3,217,2,5901.48,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2010,3598,668,40720,1531,3,67,2,1239.31,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2011,3598,668,40720,1531,3,57,1,7140.79,NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2012,3598,669,40720,1531,3,217,2,2362.79,NULL,'2021-05-16 21:55:23','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2013,3598,669,40720,1531,3,67,2,496.19,NULL,'2021-05-16 21:55:23','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2014,3598,669,40720,1531,3,57,1,2858.98,NULL,'2021-05-16 21:55:23','2021-05-17 16:19:54','2021-05-17 16:19:54'),(2015,3598,670,40733,3043,2,96,2,187625.00,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2016,3598,670,40733,3043,2,67,2,39401.25,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2017,3598,670,40733,3043,2,13,1,227026.25,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2018,3598,671,40733,3043,2,96,2,160636.00,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2019,3598,671,40733,3043,2,67,2,33733.56,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL);
INSERT INTO `balance_libro_details` VALUES (2020,3598,671,40733,3043,2,13,1,194369.56,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2021,3598,672,40733,3043,2,96,2,40918.00,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2022,3598,672,40733,3043,2,67,2,8592.78,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2023,3598,672,40733,3043,2,13,1,49510.78,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2024,3598,673,40733,3043,2,96,2,11840.00,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2025,3598,673,40733,3043,2,67,2,2486.40,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2026,3598,673,40733,3043,2,13,1,14326.40,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2027,3598,674,40733,3043,2,96,2,19339.00,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2028,3598,674,40733,3043,2,67,2,4061.19,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2029,3598,674,40733,3043,2,13,1,23400.19,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2030,3598,675,40733,3043,2,96,2,116154.00,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2031,3598,675,40733,3043,2,67,2,24392.34,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2032,3598,675,40733,3043,2,13,1,140546.34,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2033,3598,676,40733,3043,2,96,2,38953.00,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2034,3598,676,40733,3043,2,67,2,8180.13,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2035,3598,676,40733,3043,2,13,1,47133.13,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2036,3598,677,40733,3043,2,96,2,20890.00,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2037,3598,677,40733,3043,2,67,2,4386.90,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2038,3598,677,40733,3043,2,13,1,25276.90,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2039,3598,678,40733,3043,2,96,2,72200.99,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2040,3598,678,40733,3043,2,67,2,15162.21,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2041,3598,678,40733,3043,2,13,1,87363.20,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2042,3598,679,40733,3043,2,96,2,51750.00,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2043,3598,679,40733,3043,2,67,2,10867.50,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2044,3598,679,40733,3043,2,13,1,62617.50,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2045,3598,680,40733,3043,2,96,2,54164.00,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2046,3598,680,40733,3043,2,67,2,11374.44,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2047,3598,680,40733,3043,2,13,1,65538.44,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2048,3598,681,40733,3043,2,96,2,123435.00,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2049,3598,681,40733,3043,2,67,2,25921.35,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2050,3598,681,40733,3043,2,13,1,149356.35,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2051,3598,682,40733,3043,2,96,2,41054.00,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2052,3598,682,40733,3043,2,67,2,8621.34,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2053,3598,682,40733,3043,2,13,1,49675.34,NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(2054,3598,683,40733,3043,2,96,2,46985.00,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2055,3598,683,40733,3043,2,67,2,9866.85,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2056,3598,683,40733,3043,2,13,1,56851.85,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2057,3598,684,40733,3043,2,96,2,78540.00,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2058,3598,684,40733,3043,2,67,2,16493.40,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2059,3598,684,40733,3043,2,13,1,95033.40,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2060,3598,685,40733,3043,2,96,2,131439.60,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL);
INSERT INTO `balance_libro_details` VALUES (2061,3598,685,40733,3043,2,67,2,27602.32,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2062,3598,685,40733,3043,2,13,1,159041.92,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2063,3598,686,40733,3043,2,96,2,87075.00,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2064,3598,686,40733,3043,2,67,2,18285.75,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2065,3598,686,40733,3043,2,13,1,105360.75,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2066,3598,687,40733,3043,2,96,2,6607.00,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2067,3598,687,40733,3043,2,67,2,1387.47,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2068,3598,687,40733,3043,2,13,1,7994.47,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2069,3598,688,40733,3043,2,96,2,261032.00,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2070,3598,688,40733,3043,2,67,2,54816.72,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2071,3598,688,40733,3043,2,13,1,315848.72,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2072,3598,689,40733,3043,2,96,2,47983.00,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2073,3598,689,40733,3043,2,67,2,10076.43,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2074,3598,689,40733,3043,2,13,1,58059.43,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2075,3598,690,40733,3043,2,96,2,50773.00,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2076,3598,690,40733,3043,2,67,2,10662.33,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2077,3598,690,40733,3043,2,13,1,61435.33,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2078,3598,691,40733,3043,2,96,1,9420.00,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2079,3598,691,40733,3043,2,68,1,1978.20,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2080,3598,691,40733,3043,2,13,2,11398.20,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2081,3598,692,40733,3043,2,96,2,192025.80,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2082,3598,692,40733,3043,2,67,2,40325.41,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2083,3598,692,40733,3043,2,13,1,232351.21,NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(2084,3598,693,40733,3043,3,217,1,17429.67,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2085,3598,693,40733,3043,3,68,1,3660.24,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2086,3598,693,40733,3043,3,57,2,21089.91,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2087,3598,694,40733,3043,3,217,1,61300.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2088,3598,694,40733,3043,3,68,1,12873.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2089,3598,694,40733,3043,3,57,2,74173.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2090,3598,695,40733,3043,3,217,1,4627.50,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2091,3598,695,40733,3043,3,68,1,971.78,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2092,3598,695,40733,3043,3,57,2,5599.28,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2093,3598,696,40733,3043,3,217,1,28620.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2094,3598,696,40733,3043,3,68,1,6010.20,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2095,3598,696,40733,3043,3,57,2,34630.20,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2096,3598,697,40733,3043,3,217,2,1028.10,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2097,3598,697,40733,3043,3,67,2,215.90,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2098,3598,697,40733,3043,3,217,2,10.28,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2099,3598,697,40733,3043,3,57,1,1254.28,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2100,3598,698,40733,3043,3,217,1,34269.84,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2101,3598,698,40733,3043,3,68,1,7196.67,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL);
INSERT INTO `balance_libro_details` VALUES (2102,3598,698,40733,3043,3,217,1,342.70,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2103,3598,698,40733,3043,3,57,2,41809.21,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2104,3598,699,40733,3043,3,217,1,29559.60,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2105,3598,699,40733,3043,3,68,1,6207.52,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2106,3598,699,40733,3043,3,57,2,35767.12,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2107,3598,700,40733,3043,3,217,1,202957.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2108,3598,700,40733,3043,3,68,1,42620.97,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2109,3598,700,40733,3043,3,57,2,245577.97,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2110,3598,701,40733,3043,3,217,1,570.25,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2111,3598,701,40733,3043,3,68,1,119.75,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2112,3598,701,40733,3043,3,57,2,690.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2113,3598,702,40733,3043,3,217,1,553.72,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2114,3598,702,40733,3043,3,68,1,116.28,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2115,3598,702,40733,3043,3,57,2,670.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2116,3598,703,40733,3043,3,217,1,1157.03,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2117,3598,703,40733,3043,3,68,1,242.98,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2118,3598,703,40733,3043,3,57,2,1400.01,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2119,3598,704,40733,3043,3,217,1,669.42,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2120,3598,704,40733,3043,3,68,1,140.58,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2121,3598,704,40733,3043,3,57,2,810.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2122,3598,705,40733,3043,3,217,1,553.72,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2123,3598,705,40733,3043,3,68,1,116.28,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2124,3598,705,40733,3043,3,57,2,670.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2125,3598,706,40733,3043,3,217,1,1487.60,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2126,3598,706,40733,3043,3,68,1,312.40,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2127,3598,706,40733,3043,3,57,2,1800.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2128,3598,707,40733,3043,3,217,1,553.72,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2129,3598,707,40733,3043,3,68,1,116.28,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2130,3598,707,40733,3043,3,57,2,670.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2131,3598,708,40733,3043,3,217,1,1016.53,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2132,3598,708,40733,3043,3,68,1,213.47,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2133,3598,708,40733,3043,3,57,2,1230.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2134,3598,709,40733,3043,3,217,1,20757.60,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2135,3598,709,40733,3043,3,68,1,4359.10,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2136,3598,709,40733,3043,3,57,2,25116.70,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2137,3598,710,40733,3043,3,217,1,61366.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2138,3598,710,40733,3043,3,68,1,12886.86,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2139,3598,710,40733,3043,3,57,2,74252.86,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2140,3598,711,40733,3043,3,217,1,553.72,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2141,3598,711,40733,3043,3,68,1,116.28,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2142,3598,711,40733,3043,3,57,2,670.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL);
INSERT INTO `balance_libro_details` VALUES (2143,3598,712,40733,3043,3,217,1,37991.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2144,3598,712,40733,3043,3,68,1,7978.11,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2145,3598,712,40733,3043,3,57,2,45969.11,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2146,3598,713,40733,3043,3,217,1,93041.19,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2147,3598,713,40733,3043,3,68,1,19538.65,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2148,3598,713,40733,3043,3,57,2,112579.84,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2149,3598,714,40733,3043,3,217,1,165112.84,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2150,3598,714,40733,3043,3,68,1,34673.69,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2151,3598,714,40733,3043,3,57,2,199786.53,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2152,3598,715,40733,3043,3,217,1,7350.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2153,3598,715,40733,3043,3,68,1,1543.50,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2154,3598,715,40733,3043,3,57,2,8893.50,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2155,3598,716,40733,3043,3,217,1,2900.83,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2156,3598,716,40733,3043,3,68,1,609.17,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2157,3598,716,40733,3043,3,57,2,3510.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2158,3598,717,40733,3043,3,217,1,50150.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2159,3598,717,40733,3043,3,68,1,10531.50,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2160,3598,717,40733,3043,3,57,2,60681.50,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2161,3598,718,40733,3043,3,217,1,685.95,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2162,3598,718,40733,3043,3,68,1,144.05,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2163,3598,718,40733,3043,3,57,2,830.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2164,3598,719,40733,3043,3,217,1,702.48,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2165,3598,719,40733,3043,3,68,1,147.52,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2166,3598,719,40733,3043,3,57,2,850.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2167,3598,720,40733,3043,3,217,1,553.72,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2168,3598,720,40733,3043,3,68,1,116.28,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2169,3598,720,40733,3043,3,57,2,670.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2170,3598,721,40733,3043,3,217,1,553.72,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2171,3598,721,40733,3043,3,68,1,116.28,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2172,3598,721,40733,3043,3,57,2,670.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2173,3598,722,40733,3043,3,217,1,54280.00,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2174,3598,722,40733,3043,3,68,1,11398.80,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2175,3598,722,40733,3043,3,57,2,65678.80,NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(2176,3598,723,40733,3043,3,217,1,553.72,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2177,3598,723,40733,3043,3,68,1,116.28,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2178,3598,723,40733,3043,3,57,2,670.00,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2179,3598,724,40733,3043,3,217,1,553.72,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2180,3598,724,40733,3043,3,68,1,116.28,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2181,3598,724,40733,3043,3,57,2,670.00,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2182,3598,725,40733,3043,3,217,1,11664.00,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2183,3598,725,40733,3043,3,68,1,2449.44,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL);
INSERT INTO `balance_libro_details` VALUES (2184,3598,725,40733,3043,3,57,2,14113.44,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2185,3598,726,40733,3043,3,217,1,8156.70,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2186,3598,726,40733,3043,3,68,1,1712.91,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2187,3598,726,40733,3043,3,57,2,9869.61,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2188,3598,727,40733,3043,3,217,1,10870.28,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2189,3598,727,40733,3043,3,68,1,2282.76,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2190,3598,727,40733,3043,3,57,2,13153.04,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2191,3598,728,40733,3043,3,217,1,160166.52,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2192,3598,728,40733,3043,3,68,1,33634.96,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2193,3598,728,40733,3043,3,57,2,193801.48,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2194,3598,729,40733,3043,3,217,1,44123.74,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2195,3598,729,40733,3043,3,68,1,9265.98,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2196,3598,729,40733,3043,3,57,2,53389.72,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2197,3598,730,40733,3043,3,217,1,1760.33,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2198,3598,730,40733,3043,3,68,1,369.67,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2199,3598,730,40733,3043,3,57,2,2130.00,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2200,3598,731,40733,3043,3,217,1,553.72,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2201,3598,731,40733,3043,3,68,1,116.28,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2202,3598,731,40733,3043,3,57,2,670.00,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2203,3598,732,40733,3043,3,217,1,58812.96,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2204,3598,732,40733,3043,3,68,1,12350.72,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2205,3598,732,40733,3043,3,57,2,71163.68,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2206,3598,733,40733,3043,3,217,1,9946.80,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2207,3598,733,40733,3043,3,68,1,2088.83,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2208,3598,733,40733,3043,3,57,2,12035.63,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2209,3598,734,40733,3043,3,217,1,270101.00,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2210,3598,734,40733,3043,3,68,1,56721.21,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2211,3598,734,40733,3043,3,57,2,326822.21,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2212,3598,735,40733,3043,3,217,1,2479.34,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2213,3598,735,40733,3043,3,68,1,520.66,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2214,3598,735,40733,3043,3,57,2,3000.00,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2215,3598,736,40733,3043,3,217,1,2429.75,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2216,3598,736,40733,3043,3,68,1,510.25,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2217,3598,736,40733,3043,3,57,2,2940.00,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2218,3598,737,40733,3043,3,250,1,19500.00,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2219,3598,737,40733,3043,3,57,2,19500.00,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2220,3598,738,40733,3043,3,217,1,493.48,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2221,3598,738,40733,3043,3,68,1,103.63,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2222,3598,738,40733,3043,3,57,2,597.11,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2223,3598,739,40733,3043,3,217,1,3117.60,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2224,3598,739,40733,3043,3,68,1,654.70,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL);
INSERT INTO `balance_libro_details` VALUES (2225,3598,739,40733,3043,3,57,2,3772.30,NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(2235,3598,743,40720,1531,3,217,2,19222.66,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2236,3598,743,40720,1531,3,67,2,4036.76,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2237,3598,743,40720,1531,3,57,1,23259.42,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2238,3598,744,40720,1531,3,217,2,11689.88,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2239,3598,744,40720,1531,3,67,2,2454.87,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2240,3598,744,40720,1531,3,57,1,14144.75,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2241,3598,745,40720,1531,3,217,2,7955.65,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2242,3598,745,40720,1531,3,67,2,1670.69,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2243,3598,745,40720,1531,3,57,1,9626.34,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2244,3598,746,40720,1531,3,217,1,41623.60,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2245,3598,746,40720,1531,3,68,1,8740.96,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2246,3598,746,40720,1531,3,57,2,50364.56,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2247,3598,747,40720,1531,3,217,1,11712.17,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2248,3598,747,40720,1531,3,68,1,2459.56,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2249,3598,747,40720,1531,3,57,2,14171.73,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2250,3598,748,40720,1531,3,217,2,1960.29,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2251,3598,748,40720,1531,3,67,2,411.66,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2252,3598,748,40720,1531,3,57,1,2371.95,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2253,3598,749,40720,1531,3,217,2,4298.44,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2254,3598,749,40720,1531,3,67,2,902.67,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2255,3598,749,40720,1531,3,57,1,5201.11,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2256,3598,750,40720,1531,3,217,2,7228.93,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2257,3598,750,40720,1531,3,67,2,1518.08,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2258,3598,750,40720,1531,3,57,1,8747.01,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2259,3598,751,40720,1531,3,217,1,30111.81,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2260,3598,751,40720,1531,3,68,1,6323.48,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2261,3598,751,40720,1531,3,57,2,36435.29,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2262,3598,752,40720,1531,3,217,1,41113.11,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2263,3598,752,40720,1531,3,68,1,8633.75,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2264,3598,752,40720,1531,3,57,2,49746.86,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2265,3598,753,40720,1531,3,217,1,23644.90,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2266,3598,753,40720,1531,3,68,1,4965.43,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2267,3598,753,40720,1531,3,57,2,28610.33,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2268,3598,754,40720,1531,3,217,1,42925.86,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2269,3598,754,40720,1531,3,68,1,9014.44,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2270,3598,754,40720,1531,3,57,2,51940.30,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2271,3598,755,40720,1531,3,217,1,7434.95,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2272,3598,755,40720,1531,3,68,1,1561.34,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2273,3598,755,40720,1531,3,57,2,8996.29,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2274,3598,756,40720,1531,3,217,1,11188.97,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL);
INSERT INTO `balance_libro_details` VALUES (2275,3598,756,40720,1531,3,68,1,2349.68,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2276,3598,756,40720,1531,3,57,2,13538.65,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2277,3598,757,40720,1531,3,217,1,1668.34,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2278,3598,757,40720,1531,3,68,1,350.36,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2279,3598,757,40720,1531,3,217,1,66.73,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2280,3598,757,40720,1531,3,57,2,2085.43,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2281,3598,758,40720,1531,3,217,2,11712.15,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2282,3598,758,40720,1531,3,67,2,2459.55,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2283,3598,758,40720,1531,3,57,1,14171.70,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2284,3598,759,40720,1531,3,217,1,11711.75,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2285,3598,759,40720,1531,3,68,1,2459.47,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2286,3598,759,40720,1531,3,57,2,14171.22,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2287,3598,760,40720,1531,3,217,2,1202.72,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2288,3598,760,40720,1531,3,67,2,252.57,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2289,3598,760,40720,1531,3,57,1,1455.29,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2290,3598,761,40720,1531,3,217,1,141.61,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2291,3598,761,40720,1531,3,68,1,29.74,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2292,3598,761,40720,1531,3,217,1,0.01,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2293,3598,761,40720,1531,3,57,2,171.36,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2294,3598,762,40720,1531,3,217,1,46043.37,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2295,3598,762,40720,1531,3,68,1,9669.11,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2296,3598,762,40720,1531,3,57,2,55712.48,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2297,3598,763,40720,1531,3,217,1,212.42,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2298,3598,763,40720,1531,3,68,1,44.61,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2299,3598,763,40720,1531,3,217,1,0.01,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2300,3598,763,40720,1531,3,57,2,257.04,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2301,3598,764,40720,1531,3,217,2,46043.37,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2302,3598,764,40720,1531,3,67,2,9669.11,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2303,3598,764,40720,1531,3,57,1,55712.48,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2304,3598,765,40720,1531,3,217,1,21322.44,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2305,3598,765,40720,1531,3,68,1,4477.72,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2306,3598,765,40720,1531,3,57,2,25800.16,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2307,3598,766,40720,1531,3,217,1,7522.57,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2308,3598,766,40720,1531,3,68,1,1579.74,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2309,3598,766,40720,1531,3,57,2,9102.31,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2310,3598,767,40720,1531,3,217,1,47.11,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2311,3598,767,40720,1531,3,68,1,9.89,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2312,3598,767,40720,1531,3,57,2,57.00,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2313,3598,768,40720,1531,3,217,1,59072.80,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2314,3598,768,40720,1531,3,68,1,12405.29,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2315,3598,768,40720,1531,3,57,2,71478.09,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL);
INSERT INTO `balance_libro_details` VALUES (2316,3598,769,40720,1531,3,217,1,16118.90,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2317,3598,769,40720,1531,3,68,1,3384.97,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2318,3598,769,40720,1531,3,57,2,19503.87,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2319,3598,770,40720,1531,3,217,1,13275.98,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2320,3598,770,40720,1531,3,68,1,2787.96,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2321,3598,770,40720,1531,3,57,2,16063.94,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2322,3598,771,40720,1531,3,217,2,3067.50,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2323,3598,771,40720,1531,3,67,2,644.18,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2324,3598,771,40720,1531,3,57,1,3711.68,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2325,3598,772,40720,1531,3,217,1,10973.50,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2326,3598,772,40720,1531,3,68,1,2304.44,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2327,3598,772,40720,1531,3,57,2,13277.94,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2328,3598,773,40720,1531,3,217,2,1153.80,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2329,3598,773,40720,1531,3,67,2,242.30,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2330,3598,773,40720,1531,3,57,1,1396.10,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2331,3598,774,40720,1531,3,217,1,6243.88,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2332,3598,774,40720,1531,3,68,1,1311.21,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2333,3598,774,40720,1531,3,57,2,7555.09,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2334,3598,775,40720,1531,3,217,2,5901.48,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2335,3598,775,40720,1531,3,67,2,1239.31,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2336,3598,775,40720,1531,3,57,1,7140.79,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2337,3598,776,40720,1531,3,217,2,2362.79,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2338,3598,776,40720,1531,3,67,2,496.19,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2339,3598,776,40720,1531,3,57,1,2858.98,NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(2340,3598,777,40719,6,8,281,1,9730.83,NULL,'2021-05-19 15:02:01','2021-05-19 15:02:01',NULL),(2341,3598,777,40719,6,8,351,2,9730.83,NULL,'2021-05-19 15:02:01','2021-05-19 15:02:01',NULL),(2342,3598,778,40719,6,8,281,1,442.88,NULL,'2021-05-19 15:02:25','2021-05-19 15:02:25',NULL),(2343,3598,778,40719,6,8,351,2,442.88,NULL,'2021-05-19 15:02:25','2021-05-19 15:02:25',NULL),(2344,3598,779,40720,1531,8,281,1,442.88,NULL,'2021-05-19 15:04:25','2021-05-19 15:07:20','2021-05-19 15:07:20'),(2345,3598,779,40720,1531,8,351,2,442.88,NULL,'2021-05-19 15:04:25','2021-05-19 15:07:20','2021-05-19 15:07:20'),(2346,3598,780,40720,1531,8,281,1,3277.47,NULL,'2021-05-19 15:05:00','2021-05-19 15:07:13','2021-05-19 15:07:13'),(2347,3598,780,40720,1531,8,351,2,3277.47,NULL,'2021-05-19 15:05:00','2021-05-19 15:07:13','2021-05-19 15:07:13'),(2348,3598,781,40720,1531,8,281,1,11326.31,NULL,'2021-05-19 15:10:10','2021-05-19 15:11:35','2021-05-19 15:11:35'),(2349,3598,781,40720,1531,8,351,2,11326.31,NULL,'2021-05-19 15:10:10','2021-05-19 15:11:35','2021-05-19 15:11:35'),(2350,3598,782,40720,1531,8,281,1,11416.66,NULL,'2021-05-19 15:11:58','2021-05-19 15:11:58',NULL),(2351,3598,782,40720,1531,8,351,2,11416.66,NULL,'2021-05-19 15:11:58','2021-05-19 15:11:58',NULL),(3064,3598,1019,40720,1532,3,217,1,20355.20,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3065,3598,1019,40720,1532,3,68,1,4274.59,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3066,3598,1019,40720,1532,3,57,2,24629.79,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3067,3598,1020,40720,1532,3,217,1,25663.05,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL);
INSERT INTO `balance_libro_details` VALUES (3068,3598,1020,40720,1532,3,68,1,5389.24,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3069,3598,1020,40720,1532,3,57,2,31052.29,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3070,3598,1021,40720,1532,3,217,1,9201.25,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3071,3598,1021,40720,1532,3,68,1,1932.26,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3072,3598,1021,40720,1532,3,57,2,11133.51,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3073,3598,1022,40720,1532,3,217,1,235.54,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3074,3598,1022,40720,1532,3,68,1,49.46,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3075,3598,1022,40720,1532,3,57,2,285.00,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3076,3598,1023,40720,1532,3,217,1,7772.29,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3077,3598,1023,40720,1532,3,68,1,1632.18,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3078,3598,1023,40720,1532,3,57,2,9404.47,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3079,3598,1024,40720,1532,3,217,2,5181.53,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3080,3598,1024,40720,1532,3,67,2,1088.12,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3081,3598,1024,40720,1532,3,57,1,6269.65,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3082,3598,1025,40720,1532,3,217,1,1893.50,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3083,3598,1025,40720,1532,3,68,1,397.64,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3084,3598,1025,40720,1532,3,57,2,2291.14,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3085,3598,1026,40720,1532,3,217,1,70925.66,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3086,3598,1026,40720,1532,3,68,1,14894.40,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3087,3598,1026,40720,1532,3,57,2,85820.06,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3088,3598,1027,40720,1532,3,217,1,1189.18,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3089,3598,1027,40720,1532,3,68,1,249.73,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3090,3598,1027,40720,1532,3,57,2,1438.91,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3091,3598,1028,40720,1532,3,217,1,366.94,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3092,3598,1028,40720,1532,3,68,1,77.05,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3093,3598,1028,40720,1532,3,217,1,0.01,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3094,3598,1028,40720,1532,3,57,2,444.00,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3095,3598,1029,40720,1532,3,217,1,28381.65,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3096,3598,1029,40720,1532,3,68,1,5960.15,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3097,3598,1029,40720,1532,3,57,2,34341.80,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3098,3598,1030,40720,1532,3,217,1,40498.84,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3099,3598,1030,40720,1532,3,68,1,8504.76,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3100,3598,1030,40720,1532,3,57,2,49003.60,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3101,3598,1031,40720,1532,3,217,1,7798.08,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3102,3598,1031,40720,1532,3,68,1,1637.60,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3103,3598,1031,40720,1532,3,57,2,9435.68,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3104,3598,1032,40720,1532,3,217,1,788.63,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3105,3598,1032,40720,1532,3,68,1,165.61,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3106,3598,1032,40720,1532,3,57,2,954.24,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3107,3598,1033,40720,1532,3,217,2,835.86,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3108,3598,1033,40720,1532,3,67,2,175.53,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL);
INSERT INTO `balance_libro_details` VALUES (3109,3598,1033,40720,1532,3,57,1,1011.39,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3110,3598,1034,40720,1532,3,217,1,42934.52,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3111,3598,1034,40720,1532,3,68,1,9016.25,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3112,3598,1034,40720,1532,3,57,2,51950.77,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3113,3598,1035,40720,1532,3,217,2,2912.77,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3114,3598,1035,40720,1532,3,67,2,611.68,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3115,3598,1035,40720,1532,3,57,1,3524.45,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3116,3598,1036,40720,1532,3,217,1,15184.93,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3117,3598,1036,40720,1532,3,68,1,3188.84,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3118,3598,1036,40720,1532,3,57,2,18373.77,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3119,3598,1037,40720,1532,3,217,1,21975.04,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3120,3598,1037,40720,1532,3,68,1,4614.76,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3121,3598,1037,40720,1532,3,57,2,26589.80,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3122,3598,1038,40720,1532,3,217,1,35932.33,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3123,3598,1038,40720,1532,3,68,1,7545.79,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3124,3598,1038,40720,1532,3,217,1,-0.01,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3125,3598,1038,40720,1532,3,57,2,43478.11,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3126,3598,1039,40720,1532,3,250,1,2700.00,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3127,3598,1039,40720,1532,3,57,2,2700.00,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3128,3598,1040,40720,1532,3,217,1,13377.40,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3129,3598,1040,40720,1532,3,68,1,2809.25,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3130,3598,1040,40720,1532,3,57,2,16186.65,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3131,3598,1041,40720,1532,3,217,1,3131.10,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3132,3598,1041,40720,1532,3,68,1,657.53,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3133,3598,1041,40720,1532,3,57,2,3788.63,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3134,3598,1042,40720,1532,3,217,1,42445.40,NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(3135,3598,1042,40720,1532,3,68,1,8913.53,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3136,3598,1042,40720,1532,3,57,2,51358.93,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3137,3598,1043,40720,1532,3,217,1,10260.71,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3138,3598,1043,40720,1532,3,68,1,2154.75,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3139,3598,1043,40720,1532,3,57,2,12415.46,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3140,3598,1044,40720,1532,3,217,2,2590.77,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3141,3598,1044,40720,1532,3,67,2,544.06,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3142,3598,1044,40720,1532,3,57,1,3134.83,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3143,3598,1045,40720,1532,3,217,2,2324.77,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3144,3598,1045,40720,1532,3,67,2,488.20,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3145,3598,1045,40720,1532,3,57,1,2812.97,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3146,3598,1046,40720,1532,3,217,1,13282.29,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3147,3598,1046,40720,1532,3,68,1,2789.28,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3148,3598,1046,40720,1532,3,57,2,16071.57,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3149,3598,1047,40720,1532,3,217,1,105457.56,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL);
INSERT INTO `balance_libro_details` VALUES (3150,3598,1047,40720,1532,3,68,1,22146.09,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3151,3598,1047,40720,1532,3,57,2,127603.65,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3152,3598,1048,40720,1532,3,217,1,21456.50,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3153,3598,1048,40720,1532,3,68,1,4505.87,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3154,3598,1048,40720,1532,3,57,2,25962.37,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3155,3598,1049,40720,1532,3,250,1,3600.00,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3156,3598,1049,40720,1532,3,57,2,3600.00,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3157,3598,1050,40720,1532,3,217,2,3512.39,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3158,3598,1050,40720,1532,3,67,2,737.60,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3159,3598,1050,40720,1532,3,57,1,4249.99,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3160,3598,1051,40720,1532,3,217,1,50594.10,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3161,3598,1051,40720,1532,3,68,1,10624.77,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3162,3598,1051,40720,1532,3,57,2,61218.87,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3163,3598,1052,40720,1532,3,250,1,8500.00,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3164,3598,1052,40720,1532,3,57,2,8500.00,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3165,3598,1053,40720,1532,3,217,2,1049.20,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3166,3598,1053,40720,1532,3,67,2,220.33,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3167,3598,1053,40720,1532,3,57,1,1269.53,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3168,3598,1054,40720,1532,3,217,1,25374.71,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3169,3598,1054,40720,1532,3,68,1,5328.69,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3170,3598,1054,40720,1532,3,217,1,-0.01,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3171,3598,1054,40720,1532,3,57,2,30703.39,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3172,3598,1055,40720,1532,3,217,1,67195.56,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3173,3598,1055,40720,1532,3,68,1,14111.07,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3174,3598,1055,40720,1532,3,57,2,81306.63,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3175,3598,1056,40720,1532,3,250,1,1500.00,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3176,3598,1056,40720,1532,3,57,2,1500.00,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3177,3598,1057,40720,1532,3,217,1,52615.90,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3178,3598,1057,40720,1532,3,68,1,11049.34,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3179,3598,1057,40720,1532,3,57,2,63665.24,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3180,3598,1058,40720,1532,3,217,2,531.29,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3181,3598,1058,40720,1532,3,67,2,111.57,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3182,3598,1058,40720,1532,3,57,1,642.86,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3183,3598,1059,40720,1532,3,217,1,20355.31,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3184,3598,1059,40720,1532,3,68,1,4274.61,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3185,3598,1059,40720,1532,3,57,2,24629.92,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3186,3598,1060,40720,1532,3,217,2,20355.20,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3187,3598,1060,40720,1532,3,67,2,4274.59,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(3188,3598,1060,40720,1532,3,57,1,24629.79,NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2021-03-23 19:10:22',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2021-03-23 19:10:22',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2021-03-23 19:10:22',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2021-03-23 19:10:22','2021-03-23 19:10:22',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2021-06-15 20:43:05','2021-06-30 13:13:19',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2021-06-15 20:43:05','2021-06-30 13:13:19',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2021-06-15 20:43:05','2021-06-30 13:13:19',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2021-06-15 20:43:05','2021-06-30 13:13:19',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-05-17 16:46:42','2022-05-17 16:46:42',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-05-17 16:46:42','2022-05-17 16:46:42',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-05-17 16:46:42','2022-05-17 16:46:42',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-05-17 16:46:42','2022-05-17 16:46:42',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1045.00,6270.00,208739.25,30,3300,NULL,'1',NULL,NULL,NULL),(2,'B',1565.00,9390.00,313108.87,45,5000,NULL,'1',NULL,NULL,NULL),(3,'C',2090.00,12540.00,417478.51,60,6700,NULL,'1',NULL,NULL,NULL),(4,'D',3130.00,18780.00,626217.78,85,10000,NULL,'1',NULL,NULL,NULL),(5,'E',4175.00,25050.00,834957.00,110,13000,NULL,'1',NULL,NULL,NULL),(6,'F',5220.00,31320.00,1043696.27,150,16500,NULL,'1',NULL,NULL,NULL),(7,'G',6260.00,37560.00,1252435.53,200,20000,NULL,'1',NULL,NULL,NULL),(8,'H',8700.00,52200.00,1739493.79,200,20000,NULL,'1',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',748382.07,62365.17,'No Excluida','0',30,3330,133455.58,288.07,288.07,1270.99,1775.18,3334.24,3334.24,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',1112459.83,92704.99,'No Excluida','0',45,5000,133455.58,555.02,555.02,1398.09,1775.18,3728.29,3728.29,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',1557443.75,129786.98,'No Excluida','0',60,6700,266911.14,949.02,876.97,1537.91,1775.18,4262.11,4190.06,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',1934273.04,161189.42,'No Excluida','0',85,10000,266911.14,1559.09,1440.47,1691.69,1775.18,5025.96,4907.34,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',2277684.56,189807.05,'No Excluida','0',110,13000,332579.74,2965.66,2300.50,1860.87,1775.18,6601.71,5936.55,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',2847105.70,237258.81,'No Excluida','0',150,16500,333638.90,4079.93,3003.79,2046.95,1775.18,7902.06,6825.92,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',3416526.83,284710.57,'No Excluida','0',200,20000,400366.71,5189.94,3745.19,2251.64,1775.18,9216.76,7772.01,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',4229985.60,352498.80,'No Excluida','0',200,20000,533822.27,11862.69,9193.62,2476.80,1775.18,16114.68,13445.60,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',4734330.03,394527.50,'Venta de Bs Muebles','0',200,20000,533822.27,NULL,14828.38,2724.49,1775.18,NULL,19328.05,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',5425770.00,452147.50,'Venta de Bs Muebles','0',200,20000,533822.27,NULL,17425.48,2996.96,1775.18,NULL,22197.62,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',6019594.89,501632.91,'Venta de Bs Muebles','0',200,20000,533822.27,NULL,20018.33,3296.62,1775.18,NULL,25090.13,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',208739.25,17394.94,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,'Clave Fiscal',NULL,NULL),(2,'Clave Ciudad',NULL,NULL),(3,'Clave ARBA',NULL,NULL),(4,'Clave ANSES',NULL,NULL),(5,'Catedral',NULL,NULL),(6,'CEMIBA',NULL,NULL),(7,'COMPRA ARG',NULL,NULL),(8,'Consejo Ciencias Economicas',NULL,NULL),(9,'Correo',NULL,NULL),(10,'CUR',NULL,NULL),(11,'Firma Digital',NULL,NULL),(12,'Interbanking',NULL,NULL),(13,'Banco Citibank',NULL,NULL),(14,'Banco Ciudad',NULL,NULL),(15,'Banco Frances',NULL,NULL),(16,'Banco Galicia',NULL,NULL),(17,'Banco HSBC',NULL,NULL),(18,'Banco Itau',NULL,NULL),(19,'Banco Nacion',NULL,NULL),(20,'Banco Macro',NULL,NULL),(21,'Banco Patagonia',NULL,NULL),(22,'Banco Provincia',NULL,NULL),(23,'Banco Santander',NULL,NULL),(24,'Banco Supervielle',NULL,NULL),(25,'Seguridad e Higiene',NULL,NULL),(26,'Sindicato - ANSES',NULL,NULL),(27,'Sindicato - AOT',NULL,NULL),(28,'Sindicato - ATSA',NULL,NULL),(29,'Sindicato - Camioneros',NULL,NULL),(30,'Sindicato - Guinchero',NULL,NULL),(31,'Sindicato - IERIC',NULL,NULL),(32,'Sindicato - La Estrella',NULL,NULL),(33,'Sindicato - Nemesis',NULL,NULL),(34,'Sindicato - Pasta',NULL,NULL),(35,'Sindicato - SEC',NULL,NULL),(36,'Sindicato - SICOP',NULL,NULL),(37,'Sindicato - SOCAYA',NULL,NULL),(38,'Sindicato - UTHGRA',NULL,NULL),(39,'Sindicato - INACAP',NULL,NULL),(40,'Sindicato - Otro',NULL,NULL),(41,'Otra',NULL,NULL),(42,'Prisma - Firma Digital',NULL,NULL),(43,'Sindicato - FATSA',NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2021-07-26 03:47:47','2021-07-29 08:43:44',NULL),(2,NULL,'Articulo 6',6,0,'2021-07-26 03:47:47','2021-07-29 08:43:44',NULL),(3,NULL,'Articulo 7',7,0,'2021-07-26 03:47:47','2021-07-29 08:43:44',NULL),(4,NULL,'Articulo 8',8,0,'2021-07-26 03:47:47','2021-07-29 08:43:44',NULL),(5,NULL,'Articulo 9',9,0,'2021-07-26 03:47:47','2021-07-29 08:43:44',NULL),(6,NULL,'Articulo 10',10,0,'2021-07-26 03:47:47','2021-07-29 08:43:44',NULL),(7,NULL,'Articulo 11',11,0,'2021-07-26 03:47:47','2021-07-29 08:43:44',NULL),(8,NULL,'Articulo 12',12,0,'2021-07-26 03:47:47','2021-07-29 08:43:44',NULL),(9,NULL,'Articulo 13',13,0,'2021-07-26 03:47:47','2021-07-29 08:43:44',NULL),(10,NULL,'Articulo 14',14,1,'2021-07-26 03:47:47','2021-07-29 08:43:44',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=482 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,NULL),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,NULL),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,NULL),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,NULL),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,NULL),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,NULL),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,NULL),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,NULL),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,NULL),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,NULL),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,NULL),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,NULL),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,NULL),(174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,NULL),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,NULL),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Tarjeta Shopping','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(216,NULL,5120157,5,1,5120100,'Tarjeta Cencosud','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL),(258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL),(347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,NULL),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,NULL),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL),(438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,NULL),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,NULL),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,NULL),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,NULL),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1053 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,3598,3,40720,40721,57,1530,2,0,'2021-03-01',2539.05,'Factura B N°: 0008-00035094',NULL,'2021-04-12 15:40:35','2021-04-15 13:53:41','2021-04-15 13:53:41'),(2,3598,3,40720,40721,57,1530,1,0,'2021-03-01',7085.01,'Nota de crédito B N°: 0008-00002819',NULL,'2021-04-12 15:40:35','2021-04-15 13:57:55','2021-04-15 13:57:55'),(3,3598,3,40720,40721,57,1530,1,0,'2021-03-03',2539.03,'Nota de crédito B N°: 0008-00002823',NULL,'2021-04-12 15:40:35','2021-04-15 13:58:06','2021-04-15 13:58:06'),(4,3598,3,40720,40722,57,1530,1,0,'2021-03-03',707.14,'Nota de crédito A N°: 0007-00005717',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(5,3598,3,40720,40722,57,1530,2,0,'2021-03-05',10393.28,'Factura A N°: 0007-00016910',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(6,3598,3,40720,40722,57,1530,1,0,'2021-03-05',2240.18,'Nota de crédito A N°: 0007-00005724',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(7,3598,3,40720,40721,57,1530,1,0,'2021-03-08',23259.42,'Nota de crédito B N°: 0008-00002832',NULL,'2021-04-12 15:40:35','2021-04-15 13:58:20','2021-04-15 13:58:20'),(8,3598,3,40720,40721,57,1530,2,0,'2021-03-08',23259.42,'Nota de débito A N°: 0008-00000178',NULL,'2021-04-12 15:40:35','2021-04-19 13:45:18','2021-04-19 13:45:18'),(9,3598,3,40720,40721,57,1530,1,0,'2021-03-08',23259.42,'Nota de crédito A N°: 0008-00003116',NULL,'2021-04-12 15:40:35','2021-04-19 13:46:56','2021-04-19 13:46:56'),(10,3598,3,40720,40721,57,1530,2,0,'2021-03-08',23259.42,'Factura A N°: 0008-00026544',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(11,3598,3,40720,40721,57,1530,2,0,'2021-03-08',23259.40,'Factura B N°: 0008-00035184',NULL,'2021-04-12 15:40:35','2021-04-15 13:55:32','2021-04-15 13:55:32'),(12,3598,3,40720,40723,57,1530,2,0,'2021-03-09',20789.95,'Factura A N°: 0001-00000730',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(13,3598,3,40720,40724,57,1530,2,0,'2021-03-10',58630.19,'Factura A N°: 0001-00007959',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(14,3598,3,40720,40724,57,1530,1,0,'2021-03-10',31685.98,'Nota de crédito B N°: 0001-00001051',NULL,'2021-04-12 15:40:35','2021-04-15 13:58:34','2021-04-15 13:58:34'),(15,3598,3,40720,40724,57,1530,2,0,'2021-03-10',31685.98,'Factura B N°: 0001-00015360',NULL,'2021-04-12 15:40:35','2021-04-15 13:56:01','2021-04-15 13:56:01'),(16,3598,3,40720,40725,57,1530,2,0,'2021-03-10',9626.34,'Factura B N°: 0003-00038787',NULL,'2021-04-12 15:40:35','2021-04-15 13:56:21','2021-04-15 13:56:21'),(17,3598,3,40720,40722,57,1530,2,0,'2021-03-12',31220.22,'Factura A N°: 0007-00017002',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(18,3598,3,40720,40722,57,1530,1,0,'2021-03-12',413.28,'Nota de crédito A N°: 0007-00005766',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(19,3598,3,40720,40722,57,1530,2,0,'2021-03-16',3394.29,'Factura A N°: 0007-00017029',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(20,3598,3,40720,40725,57,1530,2,0,'2021-03-18',11401.20,'Factura B N°: 0003-00039095',NULL,'2021-04-12 15:40:35','2021-04-15 13:56:38','2021-04-15 13:56:38'),(21,3598,3,40720,40726,57,1530,2,0,'2021-03-19',21999.00,'Factura B N°: 5090-00003193',NULL,'2021-04-12 15:40:35','2021-04-15 13:56:56','2021-04-15 13:56:56'),(22,3598,3,40720,40727,57,1530,2,0,'2021-03-19',5463.00,'Factura C N°: 0002-00000370',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(23,3598,3,40720,40721,57,1530,2,0,'2021-03-22',18951.66,'Factura A N°: 0008-00026730',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(24,3598,3,40720,40725,57,1530,2,0,'2021-03-22',14144.75,'Factura A N°: 0003-00017324',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(25,3598,3,40720,40725,57,1530,1,0,'2021-03-22',14144.75,'Nota de crédito A N°: 0003-00003759',NULL,'2021-04-12 15:40:35','2021-04-19 13:27:33','2021-04-19 13:27:33'),(26,3598,3,40720,40724,57,1530,2,0,'2021-03-23',60306.92,'Factura A N°: 0001-00008114',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL);
INSERT INTO `cta_cte_cliente` VALUES (27,3598,3,40720,40722,57,1530,2,0,'2021-03-26',130028.12,'Factura A N°: 0007-00017142',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(28,3598,3,40720,40725,57,1530,1,0,'2021-03-27',9626.34,'Nota de crédito A N°: 0003-00003782',NULL,'2021-04-12 15:40:35','2021-04-19 13:26:29','2021-04-19 13:26:29'),(29,3598,3,40720,40728,57,1530,2,0,'2021-03-29',2371.95,'Factura B N°: 0532-00042728',NULL,'2021-04-12 15:40:35','2021-04-15 13:57:09','2021-04-15 13:57:09'),(30,3598,3,40720,40729,57,1530,2,0,'2021-03-30',1472.74,'Factura A N°: 0032-00007262',NULL,'2021-04-12 15:40:35','2021-04-12 15:40:35',NULL),(31,3598,2,40720,40730,13,1530,1,0,'2021-03-01',1.00,'Factura B N°: 0003-00000001',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(32,3598,2,40720,40730,13,1530,1,0,'2021-03-02',642.00,'Factura B N°: 0003-00000002',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(33,3598,2,40720,40730,13,1530,1,0,'2021-03-02',199.98,'Factura B N°: 0003-00000003',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(34,3598,2,40720,40730,13,1530,1,0,'2021-03-02',1320.00,'Factura B N°: 0003-00000004',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(35,3598,2,40720,40730,13,1530,1,0,'2021-03-02',1653.00,'Factura B N°: 0003-00000005',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(36,3598,2,40720,40730,13,1530,1,0,'2021-03-02',499.93,'Factura B N°: 0003-00000006',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(37,3598,2,40720,40730,13,1530,1,0,'2021-03-02',499.95,'Factura B N°: 0003-00000007',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(38,3598,2,40720,40730,13,1530,1,0,'2021-03-03',1165.98,'Factura B N°: 0003-00000008',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(39,3598,2,40720,40730,13,1530,1,0,'2021-03-03',2489.00,'Factura B N°: 0003-00000009',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(40,3598,2,40720,40730,13,1530,1,0,'2021-03-03',1469.98,'Factura B N°: 0003-00000010',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(41,3598,2,40720,40730,13,1530,1,0,'2021-03-03',2862.00,'Factura B N°: 0003-00000011',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(42,3598,2,40720,40730,13,1530,1,0,'2021-03-03',1370.00,'Factura B N°: 0003-00000012',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(43,3598,2,40720,40730,13,1530,1,0,'2021-03-03',2420.00,'Factura B N°: 0003-00000013',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(44,3598,2,40720,40730,13,1530,1,0,'2021-03-03',1133.00,'Factura B N°: 0003-00000014',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(45,3598,2,40720,40730,13,1530,1,0,'2021-03-03',304.00,'Factura B N°: 0003-00000015',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(46,3598,2,40720,40730,13,1530,1,0,'2021-03-04',2700.00,'Factura B N°: 0003-00000016',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(47,3598,2,40720,40730,13,1530,1,0,'2021-03-04',6069.70,'Factura B N°: 0003-00000017',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(48,3598,2,40720,40730,13,1530,1,0,'2021-03-04',1000.06,'Factura B N°: 0003-00000018',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(49,3598,2,40720,40730,13,1530,1,0,'2021-03-04',1430.00,'Factura B N°: 0003-00000019',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(50,3598,2,40720,40730,13,1530,1,0,'2021-03-04',583.00,'Factura B N°: 0003-00000020',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(51,3598,2,40720,40730,13,1530,1,0,'2021-03-04',6360.00,'Factura B N°: 0003-00000021',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(52,3598,2,40720,40730,13,1530,1,0,'2021-03-04',2401.00,'Factura B N°: 0003-00000022',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(53,3598,2,40720,40730,13,1530,1,0,'2021-03-04',1570.06,'Factura B N°: 0003-00000023',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(54,3598,2,40720,40730,13,1530,1,0,'2021-03-04',3420.00,'Factura B N°: 0003-00000024',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL);
INSERT INTO `cta_cte_cliente` VALUES (55,3598,2,40720,40730,13,1530,1,0,'2021-03-05',802.02,'Factura B N°: 0003-00000025',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(56,3598,2,40720,40730,13,1530,1,0,'2021-03-05',899.99,'Factura B N°: 0003-00000026',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(57,3598,2,40720,40730,13,1530,1,0,'2021-03-05',2140.00,'Factura B N°: 0003-00000027',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(58,3598,2,40720,40730,13,1530,1,0,'2021-03-05',1860.00,'Factura B N°: 0003-00000028',NULL,'2021-04-12 15:42:54','2021-04-12 15:42:54',NULL),(59,3598,2,40720,40730,13,1530,1,0,'2021-03-05',1771.00,'Factura B N°: 0003-00000029',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(60,3598,2,40720,40730,13,1530,1,0,'2021-03-05',750.00,'Factura B N°: 0003-00000030',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(61,3598,2,40720,40730,13,1530,1,0,'2021-03-05',190.00,'Factura B N°: 0003-00000031',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(62,3598,2,40720,40730,13,1530,1,0,'2021-03-05',871.02,'Factura B N°: 0003-00000032',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(63,3598,2,40720,40730,13,1530,1,0,'2021-03-06',2024.00,'Factura B N°: 0003-00000033',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(64,3598,2,40720,40730,13,1530,1,0,'2021-03-06',4781.70,'Factura B N°: 0003-00000034',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(65,3598,2,40720,40730,13,1530,1,0,'2021-03-06',459.90,'Factura B N°: 0003-00000035',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(66,3598,2,40720,40730,13,1530,1,0,'2021-03-06',1022.14,'Factura B N°: 0003-00000036',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(67,3598,2,40720,40730,13,1530,1,0,'2021-03-06',1010.00,'Factura B N°: 0003-00000037',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(68,3598,2,40720,40730,13,1530,1,0,'2021-03-06',1271.50,'Factura B N°: 0003-00000038',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(69,3598,2,40720,40730,13,1530,1,0,'2021-03-06',200.08,'Factura B N°: 0003-00000039',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(70,3598,2,40720,40730,13,1530,1,0,'2021-03-06',4600.00,'Factura B N°: 0003-00000040',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(71,3598,2,40720,40730,13,1530,1,0,'2021-03-08',3742.00,'Factura B N°: 0003-00000041',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(72,3598,2,40720,40730,13,1530,1,0,'2021-03-08',999.95,'Factura B N°: 0003-00000042',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(73,3598,2,40720,40730,13,1530,1,0,'2021-03-08',1621.50,'Factura B N°: 0003-00000043',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(74,3598,2,40720,40730,13,1530,1,0,'2021-03-08',3128.00,'Factura B N°: 0003-00000044',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(75,3598,2,40720,40730,13,1530,1,0,'2021-03-08',2440.00,'Factura B N°: 0003-00000045',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(76,3598,2,40720,40730,13,1530,1,0,'2021-03-08',2420.75,'Factura B N°: 0003-00000046',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(77,3598,2,40720,40730,13,1530,1,0,'2021-03-08',329.93,'Factura B N°: 0003-00000047',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(78,3598,2,40720,40730,13,1530,1,0,'2021-03-08',530.11,'Factura B N°: 0003-00000048',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(79,3598,2,40720,40730,13,1530,1,0,'2021-03-09',400.07,'Factura B N°: 0003-00000049',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(80,3598,2,40720,40730,13,1530,1,0,'2021-03-09',2109.91,'Factura B N°: 0003-00000050',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(81,3598,2,40720,40730,13,1530,1,0,'2021-03-09',880.00,'Factura B N°: 0003-00000051',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(82,3598,2,40720,40730,13,1530,1,0,'2021-03-09',5720.10,'Factura B N°: 0003-00000052',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL);
INSERT INTO `cta_cte_cliente` VALUES (83,3598,2,40720,40730,13,1530,1,0,'2021-03-09',1063.75,'Factura B N°: 0003-00000053',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(84,3598,2,40720,40730,13,1530,1,0,'2021-03-09',1007.00,'Factura B N°: 0003-00000054',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(85,3598,2,40720,40730,13,1530,1,0,'2021-03-09',349.98,'Factura B N°: 0003-00000055',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(86,3598,2,40720,40730,13,1530,1,0,'2021-03-09',2250.00,'Factura B N°: 0003-00000056',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(87,3598,2,40720,40730,13,1530,1,0,'2021-03-09',1240.00,'Factura B N°: 0003-00000057',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(88,3598,2,40720,40730,13,1530,1,0,'2021-03-09',170.07,'Factura B N°: 0003-00000058',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(89,3598,2,40720,40730,13,1530,1,0,'2021-03-09',501.88,'Factura B N°: 0003-00000059',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(90,3598,2,40720,40730,13,1530,1,0,'2021-03-10',1109.81,'Factura B N°: 0003-00000061',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(91,3598,2,40720,40730,13,1530,1,0,'2021-03-10',2200.02,'Factura B N°: 0003-00000062',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(92,3598,2,40720,40730,13,1530,1,0,'2021-03-10',996.00,'Factura B N°: 0003-00000063',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(93,3598,2,40720,40730,13,1530,1,0,'2021-03-10',1683.00,'Factura B N°: 0003-00000064',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(94,3598,2,40720,40730,13,1530,1,0,'2021-03-10',1656.00,'Factura B N°: 0003-00000065',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(95,3598,2,40720,40730,13,1530,1,0,'2021-03-10',499.98,'Factura B N°: 0003-00000066',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(96,3598,2,40720,40730,13,1530,1,0,'2021-03-10',210.00,'Factura B N°: 0003-00000067',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(97,3598,2,40720,40731,13,1530,1,0,'2021-03-10',3919.99,'Factura A N°: 0003-00000001',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(98,3598,2,40720,40730,13,1530,1,0,'2021-03-10',3252.20,'Factura B N°: 0003-00000060',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(99,3598,2,40720,40730,13,1530,1,0,'2021-03-11',4275.00,'Factura B N°: 0003-00000068',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(100,3598,2,40720,40730,13,1530,1,0,'2021-03-11',850.12,'Factura B N°: 0003-00000069',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(101,3598,2,40720,40730,13,1530,1,0,'2021-03-11',5159.00,'Factura B N°: 0003-00000070',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(102,3598,2,40720,40730,13,1530,1,0,'2021-03-11',2425.00,'Factura B N°: 0003-00000071',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(103,3598,2,40720,40730,13,1530,1,0,'2021-03-11',459.69,'Factura B N°: 0003-00000072',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(104,3598,2,40720,40730,13,1530,1,0,'2021-03-11',1050.00,'Factura B N°: 0003-00000073',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(105,3598,2,40720,40730,13,1530,1,0,'2021-03-11',3715.65,'Factura B N°: 0003-00000074',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(106,3598,2,40720,40730,13,1530,1,0,'2021-03-12',630.00,'Factura B N°: 0003-00000075',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(107,3598,2,40720,40730,13,1530,1,0,'2021-03-12',1289.15,'Factura B N°: 0003-00000076',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(108,3598,2,40720,40730,13,1530,1,0,'2021-03-12',2340.00,'Factura B N°: 0003-00000077',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(109,3598,2,40720,40730,13,1530,1,0,'2021-03-13',1136.00,'Factura B N°: 0003-00000078',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(110,3598,2,40720,40730,13,1530,1,0,'2021-03-13',2736.00,'Factura B N°: 0003-00000079',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL);
INSERT INTO `cta_cte_cliente` VALUES (111,3598,2,40720,40730,13,1530,1,0,'2021-03-13',2080.00,'Factura B N°: 0003-00000080',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(112,3598,2,40720,40730,13,1530,1,0,'2021-03-13',3002.18,'Factura B N°: 0003-00000081',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(113,3598,2,40720,40730,13,1530,1,0,'2021-03-13',400.00,'Factura B N°: 0003-00000082',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(114,3598,2,40720,40730,13,1530,1,0,'2021-03-13',2317.25,'Factura B N°: 0003-00000083',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(115,3598,2,40720,40730,13,1530,1,0,'2021-03-13',918.97,'Factura B N°: 0003-00000084',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(116,3598,2,40720,40730,13,1530,1,0,'2021-03-15',2080.00,'Factura B N°: 0003-00000085',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(117,3598,2,40720,40730,13,1530,1,0,'2021-03-15',1397.00,'Factura B N°: 0003-00000086',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(118,3598,2,40720,40730,13,1530,1,0,'2021-03-15',2093.00,'Factura B N°: 0003-00000087',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(119,3598,2,40720,40730,13,1530,1,0,'2021-03-15',2871.00,'Factura B N°: 0003-00000088',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(120,3598,2,40720,40730,13,1530,1,0,'2021-03-15',529.90,'Factura B N°: 0003-00000089',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(121,3598,2,40720,40730,13,1530,1,0,'2021-03-15',2270.00,'Factura B N°: 0003-00000090',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(122,3598,2,40720,40730,13,1530,1,0,'2021-03-15',2910.00,'Factura B N°: 0003-00000091',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(123,3598,2,40720,40730,13,1530,1,0,'2021-03-15',2922.00,'Factura B N°: 0003-00000092',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(124,3598,2,40720,40730,13,1530,1,0,'2021-03-15',657.00,'Factura B N°: 0003-00000093',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(125,3598,2,40720,40730,13,1530,1,0,'2021-03-15',185.00,'Factura B N°: 0003-00000094',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(126,3598,2,40720,40730,13,1530,1,0,'2021-03-15',346.11,'Factura B N°: 0003-00000095',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(127,3598,2,40720,40730,13,1530,1,0,'2021-03-15',4352.00,'Factura B N°: 0003-00000096',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(128,3598,2,40720,40730,13,1530,1,0,'2021-03-15',704.96,'Factura B N°: 0003-00000097',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(129,3598,2,40720,40730,13,1530,1,0,'2021-03-16',5337.00,'Factura B N°: 0003-00000098',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(130,3598,2,40720,40730,13,1530,1,0,'2021-03-16',1000.00,'Factura B N°: 0003-00000099',NULL,'2021-04-12 15:42:55','2021-04-12 15:42:55',NULL),(131,3598,2,40720,40730,13,1530,1,0,'2021-03-16',199.97,'Factura B N°: 0003-00000100',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(132,3598,2,40720,40730,13,1530,1,0,'2021-03-16',1959.60,'Factura B N°: 0003-00000101',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(133,3598,2,40720,40730,13,1530,1,0,'2021-03-16',2281.00,'Factura B N°: 0003-00000102',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(134,3598,2,40720,40730,13,1530,1,0,'2021-03-16',1960.00,'Factura B N°: 0003-00000103',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(135,3598,2,40720,40730,13,1530,1,0,'2021-03-16',680.00,'Factura B N°: 0003-00000104',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(136,3598,2,40720,40730,13,1530,1,0,'2021-03-16',499.82,'Factura B N°: 0003-00000105',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(137,3598,2,40720,40730,13,1530,1,0,'2021-03-16',2162.00,'Factura B N°: 0003-00000106',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(138,3598,2,40720,40730,13,1530,1,0,'2021-03-16',2000.00,'Factura B N°: 0003-00000107',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL);
INSERT INTO `cta_cte_cliente` VALUES (139,3598,2,40720,40730,13,1530,1,0,'2021-03-16',1183.66,'Factura B N°: 0003-00000108',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(140,3598,2,40720,40730,13,1530,1,0,'2021-03-16',1602.00,'Factura B N°: 0003-00000109',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(141,3598,2,40720,40732,13,1530,1,0,'2021-03-16',1895.01,'Factura A N°: 0003-00000002',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(142,3598,2,40720,40730,13,1530,1,0,'2021-03-17',1539.91,'Factura B N°: 0003-00000110',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(143,3598,2,40720,40730,13,1530,1,0,'2021-03-18',300.00,'Factura B N°: 0003-00000111',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(144,3598,2,40720,40730,13,1530,1,0,'2021-03-18',2600.11,'Factura B N°: 0003-00000112',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(145,3598,2,40720,40730,13,1530,1,0,'2021-03-18',1435.20,'Factura B N°: 0003-00000113',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(146,3598,2,40720,40730,13,1530,1,0,'2021-03-18',399.93,'Factura B N°: 0003-00000114',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(147,3598,2,40720,40730,13,1530,1,0,'2021-03-18',499.99,'Factura B N°: 0003-00000115',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(148,3598,2,40720,40730,13,1530,1,0,'2021-03-18',1010.00,'Factura B N°: 0003-00000116',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(149,3598,2,40720,40730,13,1530,1,0,'2021-03-18',300.09,'Factura B N°: 0003-00000117',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(150,3598,2,40720,40730,13,1530,1,0,'2021-03-18',393.31,'Factura B N°: 0003-00000118',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(151,3598,2,40720,40730,13,1530,1,0,'2021-03-19',1630.00,'Factura B N°: 0003-00000119',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(152,3598,2,40720,40730,13,1530,1,0,'2021-03-19',180.00,'Factura B N°: 0003-00000120',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(153,3598,2,40720,40730,13,1530,1,0,'2021-03-19',2433.00,'Factura B N°: 0003-00000121',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(154,3598,2,40720,40730,13,1530,1,0,'2021-03-19',2750.80,'Factura B N°: 0003-00000122',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(155,3598,2,40720,40730,13,1530,1,0,'2021-03-19',1728.45,'Factura B N°: 0003-00000123',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(156,3598,2,40720,40730,13,1530,1,0,'2021-03-19',200.03,'Factura B N°: 0003-00000124',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(157,3598,2,40720,40730,13,1530,1,0,'2021-03-19',499.93,'Factura B N°: 0003-00000125',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(158,3598,2,40720,40730,13,1530,1,0,'2021-03-19',350.06,'Factura B N°: 0003-00000126',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(159,3598,2,40720,40730,13,1530,1,0,'2021-03-19',1604.00,'Factura B N°: 0003-00000127',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(160,3598,2,40720,40730,13,1530,1,0,'2021-03-20',2632.25,'Factura B N°: 0003-00000128',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(161,3598,2,40720,40730,13,1530,1,0,'2021-03-20',1162.00,'Factura B N°: 0003-00000129',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(162,3598,2,40720,40730,13,1530,1,0,'2021-03-20',2190.00,'Factura B N°: 0003-00000130',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(163,3598,2,40720,40730,13,1530,1,0,'2021-03-20',380.00,'Factura B N°: 0003-00000131',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(164,3598,2,40720,40730,13,1530,1,0,'2021-03-20',1264.37,'Factura B N°: 0003-00000132',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(165,3598,2,40720,40730,13,1530,1,0,'2021-03-20',420.00,'Factura B N°: 0003-00000133',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(166,3598,2,40720,40730,13,1530,1,0,'2021-03-20',2080.00,'Factura B N°: 0003-00000134',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL);
INSERT INTO `cta_cte_cliente` VALUES (167,3598,2,40720,40730,13,1530,1,0,'2021-03-20',2263.20,'Factura B N°: 0003-00000135',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(168,3598,2,40720,40730,13,1530,1,0,'2021-03-20',3220.00,'Factura B N°: 0003-00000136',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(169,3598,2,40720,40730,13,1530,1,0,'2021-03-20',3220.00,'Factura B N°: 0003-00000137',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(170,3598,2,40720,40730,13,1530,1,0,'2021-03-20',1292.70,'Factura B N°: 0003-00000138',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(171,3598,2,40720,40730,13,1530,1,0,'2021-03-20',2074.00,'Factura B N°: 0003-00000139',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(172,3598,2,40720,40730,13,1530,1,0,'2021-03-22',919.96,'Factura B N°: 0003-00000140',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(173,3598,2,40720,40730,13,1530,1,0,'2021-03-22',599.85,'Factura B N°: 0003-00000141',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(174,3598,2,40720,40730,13,1530,1,0,'2021-03-22',799.94,'Factura B N°: 0003-00000142',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(175,3598,2,40720,40730,13,1530,1,0,'2021-03-22',2484.06,'Factura B N°: 0003-00000143',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(176,3598,2,40720,40730,13,1530,1,0,'2021-03-22',199.99,'Factura B N°: 0003-00000144',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(177,3598,2,40720,40730,13,1530,1,0,'2021-03-22',4543.19,'Factura B N°: 0003-00000145',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(178,3598,2,40720,40730,13,1530,1,0,'2021-03-22',6694.15,'Factura B N°: 0003-00000146',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(179,3598,2,40720,40730,13,1530,1,0,'2021-03-22',329.97,'Factura B N°: 0003-00000147',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(180,3598,2,40720,40730,13,1530,1,0,'2021-03-22',650.05,'Factura B N°: 0003-00000148',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(181,3598,2,40720,40730,13,1530,1,0,'2021-03-22',1370.00,'Factura B N°: 0003-00000149',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(182,3598,2,40720,40730,13,1530,1,0,'2021-03-23',2081.53,'Factura B N°: 0003-00000150',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(183,3598,2,40720,40730,13,1530,1,0,'2021-03-23',1960.00,'Factura B N°: 0003-00000151',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(184,3598,2,40720,40730,13,1530,1,0,'2021-03-23',2800.02,'Factura B N°: 0003-00000152',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(185,3598,2,40720,40730,13,1530,1,0,'2021-03-23',369.97,'Factura B N°: 0003-00000153',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(186,3598,2,40720,40730,13,1530,1,0,'2021-03-23',1000.00,'Factura B N°: 0003-00000154',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(187,3598,2,40720,40730,13,1530,1,0,'2021-03-23',957.00,'Factura B N°: 0003-00000155',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(188,3598,2,40720,40730,13,1530,1,0,'2021-03-23',1400.70,'Factura B N°: 0003-00000156',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(189,3598,2,40720,40730,13,1530,1,0,'2021-03-23',811.98,'Factura B N°: 0003-00000157',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(190,3598,2,40720,40730,13,1530,1,0,'2021-03-23',1990.00,'Factura B N°: 0003-00000158',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(191,3598,2,40720,40730,13,1530,1,0,'2021-03-23',3879.00,'Factura B N°: 0003-00000159',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(192,3598,2,40720,40730,13,1530,1,0,'2021-03-23',4660.00,'Factura B N°: 0003-00000160',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(193,3598,2,40720,40730,13,1530,1,0,'2021-03-24',2238.00,'Factura B N°: 0003-00000161',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(194,3598,2,40720,40730,13,1530,1,0,'2021-03-25',575.12,'Factura B N°: 0003-00000162',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL);
INSERT INTO `cta_cte_cliente` VALUES (195,3598,2,40720,40730,13,1530,1,0,'2021-03-25',1675.01,'Factura B N°: 0003-00000163',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(196,3598,2,40720,40730,13,1530,1,0,'2021-03-25',1669.80,'Factura B N°: 0003-00000164',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(197,3598,2,40720,40730,13,1530,1,0,'2021-03-25',3029.10,'Factura B N°: 0003-00000165',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(198,3598,2,40720,40730,13,1530,1,0,'2021-03-26',876.06,'Factura B N°: 0003-00000166',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(199,3598,2,40720,40730,13,1530,1,0,'2021-03-26',449.96,'Factura B N°: 0003-00000167',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(200,3598,2,40720,40730,13,1530,1,0,'2021-03-26',654.00,'Factura B N°: 0003-00000168',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(201,3598,2,40720,40730,13,1530,1,0,'2021-03-26',435.00,'Factura B N°: 0003-00000169',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(202,3598,2,40720,40730,13,1530,1,0,'2021-03-26',499.99,'Factura B N°: 0003-00000170',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(203,3598,2,40720,40730,13,1530,1,0,'2021-03-26',450.13,'Factura B N°: 0003-00000171',NULL,'2021-04-12 15:42:56','2021-04-12 15:42:56',NULL),(204,3598,2,40720,40730,13,1530,1,0,'2021-03-27',1623.80,'Factura B N°: 0003-00000172',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(205,3598,2,40720,40730,13,1530,1,0,'2021-03-27',2219.50,'Factura B N°: 0003-00000173',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(206,3598,2,40720,40730,13,1530,1,0,'2021-03-27',1020.95,'Factura B N°: 0003-00000174',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(207,3598,2,40720,40730,13,1530,1,0,'2021-03-27',2862.00,'Factura B N°: 0003-00000175',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(208,3598,2,40720,40730,13,1530,1,0,'2021-03-27',200.04,'Factura B N°: 0003-00000176',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(209,3598,2,40720,40730,13,1530,1,0,'2021-03-27',1540.00,'Factura B N°: 0003-00000177',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(210,3598,2,40720,40730,13,1530,1,0,'2021-03-27',430.00,'Factura B N°: 0003-00000178',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(211,3598,2,40720,40730,13,1530,1,0,'2021-03-27',1703.80,'Factura B N°: 0003-00000179',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(212,3598,2,40720,40730,13,1530,1,0,'2021-03-27',961.40,'Factura B N°: 0003-00000180',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(213,3598,2,40720,40730,13,1530,1,0,'2021-03-27',919.93,'Factura B N°: 0003-00000181',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(214,3598,2,40720,40730,13,1530,1,0,'2021-03-27',9648.50,'Factura B N°: 0003-00000182',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(215,3598,2,40720,40730,13,1530,1,0,'2021-03-27',761.86,'Factura B N°: 0003-00000183',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(216,3598,2,40720,40730,13,1530,1,0,'2021-03-27',1564.00,'Factura B N°: 0003-00000184',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(217,3598,2,40720,40730,13,1530,1,0,'2021-03-27',1649.00,'Factura B N°: 0003-00000185',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(218,3598,2,40720,40730,13,1530,1,0,'2021-03-27',2970.00,'Factura B N°: 0003-00000186',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(219,3598,2,40720,40730,13,1530,1,0,'2021-03-29',3330.40,'Factura B N°: 0003-00000187',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(220,3598,2,40720,40730,13,1530,1,0,'2021-03-29',2251.70,'Factura B N°: 0003-00000188',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(221,3598,2,40720,40730,13,1530,1,0,'2021-03-29',5153.15,'Factura B N°: 0003-00000189',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(222,3598,2,40720,40730,13,1530,1,0,'2021-03-29',4626.00,'Factura B N°: 0003-00000190',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL);
INSERT INTO `cta_cte_cliente` VALUES (223,3598,2,40720,40730,13,1530,1,0,'2021-03-29',1159.00,'Factura B N°: 0003-00000191',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(224,3598,2,40720,40730,13,1530,1,0,'2021-03-29',1581.00,'Factura B N°: 0003-00000192',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(225,3598,2,40720,40730,13,1530,1,0,'2021-03-29',800.00,'Factura B N°: 0003-00000193',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(226,3598,2,40720,40730,13,1530,1,0,'2021-03-29',2311.46,'Factura B N°: 0003-00000194',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(227,3598,2,40720,40730,13,1530,1,0,'2021-03-29',1618.05,'Factura B N°: 0003-00000195',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(228,3598,2,40720,40730,13,1530,1,0,'2021-03-29',2557.60,'Factura B N°: 0003-00000196',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(229,3598,2,40720,40730,13,1530,1,0,'2021-03-29',2512.00,'Factura B N°: 0003-00000197',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(230,3598,2,40720,40730,13,1530,1,0,'2021-03-29',2819.00,'Factura B N°: 0003-00000198',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(231,3598,2,40720,40730,13,1530,1,0,'2021-03-29',1771.00,'Factura B N°: 0003-00000199',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(232,3598,2,40720,40730,13,1530,1,0,'2021-03-29',377.20,'Factura B N°: 0003-00000200',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(233,3598,2,40720,40730,13,1530,1,0,'2021-03-29',3021.00,'Factura B N°: 0003-00000201',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(234,3598,2,40720,40730,13,1530,1,0,'2021-03-29',803.65,'Factura B N°: 0003-00000202',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(235,3598,2,40720,40730,13,1530,1,0,'2021-03-29',220.00,'Factura B N°: 0003-00000203',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(236,3598,2,40720,40730,13,1530,1,0,'2021-03-29',607.05,'Factura B N°: 0003-00000204',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(237,3598,2,40720,40730,13,1530,1,0,'2021-03-30',3447.70,'Factura B N°: 0003-00000205',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(238,3598,2,40720,40730,13,1530,1,0,'2021-03-30',1792.00,'Factura B N°: 0003-00000206',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(239,3598,2,40720,40730,13,1530,1,0,'2021-03-30',809.94,'Factura B N°: 0003-00000207',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(240,3598,2,40720,40730,13,1530,1,0,'2021-03-30',2254.00,'Factura B N°: 0003-00000208',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(241,3598,2,40720,40730,13,1530,1,0,'2021-03-30',3988.20,'Factura B N°: 0003-00000209',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(242,3598,2,40720,40730,13,1530,1,0,'2021-03-31',1379.99,'Factura B N°: 0003-00000210',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(243,3598,2,40720,40730,13,1530,1,0,'2021-03-31',589.80,'Factura B N°: 0003-00000211',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(244,3598,2,40720,40730,13,1530,1,0,'2021-03-31',1675.08,'Factura B N°: 0003-00000212',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(245,3598,2,40720,40730,13,1530,1,0,'2021-03-31',1049.91,'Factura B N°: 0003-00000213',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(246,3598,2,40720,40730,13,1530,1,0,'2021-03-31',1501.00,'Factura B N°: 0003-00000214',NULL,'2021-04-12 15:42:57','2021-04-12 15:42:57',NULL),(247,3598,3,40720,40721,57,1530,2,0,'2021-03-08',23259.42,'Nota de débito A N°: 0008-00000178',NULL,'2021-04-19 15:12:28','2021-04-19 15:12:28',NULL),(248,3598,2,40733,40734,13,3040,1,0,'2021-01-05',31316.62,'Factura A N°: 0003-00000343',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(249,3598,2,40733,40735,13,3040,1,0,'2021-01-08',55950.40,'Factura A N°: 0003-00000344',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(250,3598,2,40733,40736,13,3040,1,0,'2021-01-08',57927.54,'Factura A N°: 0003-00000345',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL);
INSERT INTO `cta_cte_cliente` VALUES (251,3598,2,40733,40737,13,3040,1,0,'2021-01-08',53262.08,'Factura B N°: 0003-00000039',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(252,3598,2,40733,40738,13,3040,1,0,'2021-01-20',41672.40,'Factura A N°: 0003-00000346',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(253,3598,2,40733,40739,13,3040,1,0,'2021-01-20',27577.11,'Factura A N°: 0003-00000347',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(254,3598,2,40733,40740,13,3040,1,0,'2021-01-20',20894.28,'Factura B N°: 0003-00000040',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(255,3598,2,40733,40741,13,3040,1,0,'2021-01-22',48400.61,'Factura A N°: 0003-00000348',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(256,3598,2,40733,40735,13,3040,1,0,'2021-01-25',433256.23,'Factura A N°: 0003-00000349',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(257,3598,2,40733,40742,13,3040,1,0,'2021-01-25',55660.00,'Factura A N°: 0003-00000350',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(258,3598,2,40733,40743,13,3040,1,0,'2021-01-26',25312.71,'Factura A N°: 0003-00000351',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(259,3598,2,40733,40744,13,3040,1,0,'2021-01-26',50040.76,'Factura A N°: 0003-00000352',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(260,3598,2,40733,40745,13,3040,1,0,'2021-01-26',54527.69,'Factura A N°: 0003-00000353',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(261,3598,2,40733,40746,13,3040,1,0,'2021-01-26',110656.92,'Factura A N°: 0003-00000354',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(262,3598,2,40733,40747,13,3040,1,0,'2021-01-26',71725.17,'Factura A N°: 0003-00000355',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(263,3598,2,40733,40748,13,3040,1,0,'2021-01-29',78931.81,'Factura A N°: 0003-00000356',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(264,3598,2,40733,40749,13,3040,1,0,'2021-01-29',115329.94,'Factura A N°: 0003-00000357',NULL,'2021-04-20 17:34:43','2021-04-20 17:34:43',NULL),(265,3598,3,40733,40750,57,3040,2,0,'2021-01-04',300.00,'Factura C N°: 0106-00029091',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(266,3598,3,40733,40719,57,3040,2,0,'2021-01-04',16000.00,'Factura C N°: 0002-00000095',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(267,3598,3,40733,40751,57,3040,1,0,'2021-01-05',500.01,'Nota de crédito A N°: 2300-00023038',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(268,3598,3,40733,40752,57,3040,2,0,'2021-01-05',33123.75,'Factura A N°: 0002-00001034',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(269,3598,3,40733,40753,57,3040,2,0,'2021-01-06',4156.30,'Factura A N°: 0005-00006487',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(270,3598,3,40733,40751,57,3040,2,0,'2021-01-07',680.00,'Factura A N°: 2339-00006745',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(271,3598,3,40733,40751,57,3040,2,0,'2021-01-07',1140.00,'Factura A N°: 2319-00003722',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(272,3598,3,40733,40754,57,3040,2,0,'2021-01-07',70943.35,'Factura A N°: 0004-00015649',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(273,3598,3,40733,40751,57,3040,2,0,'2021-01-08',900.00,'Factura A N°: 2379-00004296',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(274,3598,3,40733,40752,57,3040,1,0,'2021-01-08',33123.75,'Nota de crédito A N°: 0002-00000041',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(275,3598,3,40733,40751,57,3040,2,0,'2021-01-19',570.01,'Factura A N°: 2376-00006568',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(276,3598,3,40733,40751,57,3040,2,0,'2021-01-19',569.99,'Factura A N°: 2319-00003835',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(277,3598,3,40733,40731,57,3040,2,0,'2021-01-19',37849.23,'Factura A N°: 0045-00156631',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL);
INSERT INTO `cta_cte_cliente` VALUES (278,3598,3,40733,40751,57,3040,2,0,'2021-01-19',569.99,'Factura A N°: 2338-00004075',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(279,3598,3,40733,40755,57,3040,2,0,'2021-01-19',28923.84,'Factura A N°: 0003-00002003',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(280,3598,3,40733,40751,57,3040,2,0,'2021-01-20',2810.00,'Factura A N°: 2302-00006868',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(281,3598,3,40733,40756,57,3040,2,0,'2021-01-20',18634.00,'Factura A N°: 0007-00002211',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(282,3598,3,40733,40757,57,3040,2,0,'2021-01-21',11325.60,'Factura A N°: 0002-00001812',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(283,3598,3,40733,40751,57,3040,2,0,'2021-01-22',5760.00,'Factura A N°: 2412-00002276',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(284,3598,3,40733,40751,57,3040,2,0,'2021-01-22',1060.00,'Factura A N°: 2339-00006954',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(285,3598,3,40733,40758,57,3040,2,0,'2021-01-22',59722.42,'Factura A N°: 0010-00002940',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(286,3598,3,40733,40751,57,3040,2,0,'2021-01-25',570.01,'Factura A N°: 2404-00002146',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(287,3598,3,40733,40751,57,3040,2,0,'2021-01-25',570.01,'Factura A N°: 2447-00004297',NULL,'2021-04-20 17:34:54','2021-04-20 17:34:54',NULL),(288,3598,3,40733,40750,57,3040,2,0,'2021-01-25',12.00,'Nota de débito C N°: 0106-00000639',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(289,3598,3,40733,40759,57,3040,2,0,'2021-01-25',70895.17,'Factura A N°: 0008-00003298',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(290,3598,3,40733,40751,57,3040,2,0,'2021-01-26',1060.00,'Factura A N°: 2326-00002719',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(291,3598,3,40733,40751,57,3040,2,0,'2021-01-26',570.01,'Factura A N°: 2326-00002718',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(292,3598,3,40733,40751,57,3040,2,0,'2021-01-26',810.00,'Factura A N°: 2463-00000124',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(293,3598,3,40733,40751,57,3040,1,0,'2021-01-26',570.01,'Nota de crédito A N°: 2300-00024442',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(294,3598,3,40733,40751,57,3040,2,0,'2021-01-26',2049.99,'Factura A N°: 2339-00007008',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(295,3598,3,40733,40751,57,3040,2,0,'2021-01-26',1060.01,'Factura A N°: 2339-00007009',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(296,3598,3,40733,40751,57,3040,2,0,'2021-01-27',1559.99,'Factura A N°: 2339-00007038',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(297,3598,3,40733,40751,57,3040,2,0,'2021-01-27',569.99,'Factura A N°: 2339-00007039',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(298,3598,3,40733,40751,57,3040,2,0,'2021-01-27',1060.01,'Factura A N°: 2339-00007047',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(299,3598,3,40733,40751,57,3040,2,0,'2021-01-27',1540.00,'Factura A N°: 2412-00002303',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(300,3598,3,40733,40751,57,3040,1,0,'2021-01-27',1559.99,'Nota de crédito A N°: 2300-00024481',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(301,3598,3,40733,40719,57,3040,2,0,'2021-01-27',19500.00,'Factura C N°: 0002-00000099',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(302,3598,3,40733,40751,57,3040,2,0,'2021-01-28',810.00,'Factura A N°: 2318-00009690',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(303,3598,3,40733,40757,57,3040,2,0,'2021-01-28',174675.60,'Factura A N°: 0002-00001819',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(304,3598,3,40733,40760,57,3040,2,0,'2021-01-28',80000.00,'Factura C N°: 0001-00000023',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL);
INSERT INTO `cta_cte_cliente` VALUES (305,3598,3,40733,40756,57,3040,2,0,'2021-01-28',182105.00,'Factura A N°: 0007-00002220',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(306,3598,3,40733,40751,57,3040,2,0,'2021-01-29',3040.00,'Factura A N°: 2339-00007078',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(307,3598,3,40733,40761,57,3040,2,0,'2021-01-29',1100.00,'Factura A N°: 0004-00041603',NULL,'2021-04-20 17:34:55','2021-04-20 17:34:55',NULL),(308,3598,2,40733,40762,13,3041,1,0,'2021-02-08',67082.40,'Factura A N°: 0003-00000358',NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(309,3598,2,40733,40739,13,3041,1,0,'2021-02-11',12724.36,'Factura A N°: 0003-00000359',NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(310,3598,2,40733,40763,13,3041,1,0,'2021-02-11',14075.93,'Factura A N°: 0003-00000360',NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(311,3598,2,40733,40730,13,3041,1,0,'2021-02-11',8698.69,'Factura B N°: 0003-00000041',NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(312,3598,2,40733,40764,13,3041,1,0,'2021-02-12',78737.12,'Factura A N°: 0003-00000361',NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(313,3598,2,40733,40765,13,3041,1,0,'2021-02-18',86074.56,'Factura A N°: 0003-00000362',NULL,'2021-04-20 17:38:08','2021-04-20 17:38:08',NULL),(314,3598,2,40733,40746,13,3041,1,0,'2021-02-22',101595.23,'Factura A N°: 0003-00000363',NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(315,3598,2,40733,40736,13,3041,1,0,'2021-02-22',66696.41,'Factura A N°: 0003-00000364',NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(316,3598,2,40733,40739,13,3041,1,0,'2021-02-26',58256.66,'Factura A N°: 0003-00000365',NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(317,3598,2,40733,40766,13,3041,1,0,'2021-02-26',79696.65,'Factura A N°: 0003-00000366',NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(318,3598,2,40733,40767,13,3041,1,0,'2021-02-26',203072.36,'Factura A N°: 0003-00000367',NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(319,3598,2,40733,40768,13,3041,1,0,'2021-02-26',35846.25,'Factura B N°: 0003-00000042',NULL,'2021-04-20 17:38:09','2021-04-20 17:38:09',NULL),(320,3598,3,40733,40769,57,3041,2,0,'2021-02-01',250179.60,'Factura A N°: 0005-00055458',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(321,3598,3,40733,40751,57,3041,2,0,'2021-02-01',569.99,'Factura A N°: 2319-00003971',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(322,3598,3,40733,40751,57,3041,2,0,'2021-02-01',1060.00,'Factura A N°: 2339-00007096',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(323,3598,3,40733,40751,57,3041,2,0,'2021-02-01',569.99,'Factura A N°: 2339-00007097',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(324,3598,3,40733,40751,57,3041,2,0,'2021-02-02',2550.00,'Factura A N°: 2412-00002352',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(325,3598,3,40733,40751,57,3041,2,0,'2021-02-02',569.99,'Factura A N°: 2339-00007112',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(326,3598,3,40733,40751,57,3041,2,0,'2021-02-03',1559.99,'Factura A N°: 2406-00003505',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(327,3598,3,40733,40751,57,3041,2,0,'2021-02-04',570.01,'Factura A N°: 2386-00007493',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(328,3598,3,40733,40743,57,3041,2,0,'2021-02-06',50426.75,'Factura A N°: 0002-00000452',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(329,3598,3,40733,40751,57,3041,2,0,'2021-02-09',570.01,'Factura A N°: 2339-00007216',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(330,3598,3,40733,40751,57,3041,1,0,'2021-02-09',1540.00,'Nota de crédito A N°: 2300-00025337',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(331,3598,3,40733,40751,57,3041,2,0,'2021-02-10',569.99,'Factura A N°: 2463-00000157',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(332,3598,3,40733,40751,57,3041,2,0,'2021-02-11',570.01,'Factura A N°: 2389-00006537',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL);
INSERT INTO `cta_cte_cliente` VALUES (333,3598,3,40733,40752,57,3041,2,0,'2021-02-17',109405.05,'Factura A N°: 0002-00001041',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(334,3598,3,40733,40751,57,3041,2,0,'2021-02-18',3509.99,'Factura A N°: 2379-00004682',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(335,3598,3,40733,40751,57,3041,2,0,'2021-02-19',570.01,'Factura A N°: 2377-00001931',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(336,3598,3,40733,40751,57,3041,2,0,'2021-02-19',569.99,'Factura A N°: 2302-00007348',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(337,3598,3,40733,40770,57,3041,2,0,'2021-02-24',107329.57,'Factura A N°: 0002-00000175',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(338,3598,3,40733,40751,57,3041,2,0,'2021-02-25',909.99,'Factura A N°: 2317-00002851',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(339,3598,3,40733,40755,57,3041,2,0,'2021-02-25',12938.65,'Factura A N°: 0003-00002037',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(340,3598,3,40733,40751,57,3041,2,0,'2021-02-26',1559.99,'Factura A N°: 2338-00004571',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(341,3598,3,40733,40751,57,3041,2,0,'2021-02-26',569.99,'Factura A N°: 2339-00007426',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(342,3598,3,40733,40771,57,3041,2,0,'2021-02-27',529.53,'Factura A N°: 0012-00033390',NULL,'2021-04-20 17:38:20','2021-04-20 17:38:20',NULL),(343,3598,2,40733,40772,13,3042,1,0,'2021-03-03',173932.66,'Factura A N°: 0003-00000368',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(344,3598,2,40733,40773,13,3042,1,0,'2021-03-05',53492.89,'Factura A N°: 0003-00000369',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(345,3598,2,40733,40774,13,3042,1,0,'2021-03-08',44296.89,'Factura A N°: 0003-00000370',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(346,3598,2,40733,40775,13,3042,1,0,'2021-03-10',37374.48,'Factura A N°: 0003-00000371',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(347,3598,2,40733,40776,13,3042,1,0,'2021-03-10',33531.52,'Factura A N°: 0003-00000372',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(348,3598,2,40733,40734,13,3042,1,0,'2021-03-10',48229.38,'Factura A N°: 0003-00000373',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(349,3598,2,40733,40744,13,3042,1,0,'2021-03-16',36239.50,'Factura A N°: 0003-00000374',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(350,3598,2,40733,40745,13,3042,1,0,'2021-03-17',68258.52,'Factura A N°: 0003-00000375',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(351,3598,2,40733,40741,13,3042,1,0,'2021-03-17',40061.89,'Factura A N°: 0003-00000376',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(352,3598,2,40733,40777,13,3042,1,0,'2021-03-18',110404.03,'Factura A N°: 0003-00000377',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(353,3598,2,40733,40778,13,3042,1,0,'2021-03-18',3061.30,'Factura A N°: 0003-00000378',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(354,3598,2,40733,40763,13,3042,1,0,'2021-03-19',18815.50,'Factura A N°: 0003-00000379',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(355,3598,2,40733,40736,13,3042,1,0,'2021-03-23',86378.27,'Factura A N°: 0003-00000380',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(356,3598,2,40733,40779,13,3042,1,0,'2021-03-23',112584.09,'Factura A N°: 0003-00000381',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(357,3598,2,40733,40780,13,3042,1,0,'2021-03-23',28683.05,'Factura A N°: 0003-00000382',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(358,3598,2,40733,40781,13,3042,1,0,'2021-03-25',41298.51,'Factura A N°: 0003-00000383',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(359,3598,2,40733,40766,13,3042,2,0,'2021-03-25',6776.00,'Nota de crédito A N°: 0003-00000005',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL);
INSERT INTO `cta_cte_cliente` VALUES (360,3598,2,40733,40738,13,3042,1,0,'2021-03-26',49951.22,'Factura A N°: 0003-00000384',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(361,3598,2,40733,40746,13,3042,1,0,'2021-03-29',120641.84,'Factura A N°: 0003-00000385',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(362,3598,2,40733,40767,13,3042,1,0,'2021-03-31',139995.31,'Factura A N°: 0003-00000386',NULL,'2021-04-20 18:08:05','2021-04-20 18:08:05',NULL),(363,3598,3,40733,40751,57,3042,2,0,'2021-03-01',569.99,'Factura A N°: 2317-00002920',NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(364,3598,3,40733,40751,57,3042,2,0,'2021-03-01',1489.99,'Factura A N°: 2404-00002374',NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(365,3598,3,40733,40719,57,3042,2,0,'2021-03-01',19500.00,'Factura C N°: 0002-00000108',NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(366,3598,3,40733,40770,57,3042,2,0,'2021-03-02',96596.85,'Factura A N°: 0002-00000185',NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(367,3598,3,40733,40770,57,3042,1,0,'2021-03-02',107329.57,'Nota de crédito A N°: 0002-00000012',NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(368,3598,3,40733,40751,57,3042,1,0,'2021-03-03',909.99,'Nota de crédito A N°: 2300-00026770',NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(369,3598,3,40733,40751,57,3042,2,0,'2021-03-03',569.99,'Factura A N°: 2339-00007472',NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(370,3598,3,40733,40782,57,3042,2,0,'2021-03-03',135979.80,'Factura A N°: 0003-00004037',NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(371,3598,3,40733,40757,57,3042,2,0,'2021-03-04',53953.90,'Factura A N°: 0002-00001849',NULL,'2021-04-20 18:08:13','2021-04-20 18:08:13',NULL),(372,3598,3,40733,40782,57,3042,1,0,'2021-03-04',11591.80,'Nota de crédito A N°: 0003-00000430',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(373,3598,3,40733,40751,57,3042,2,0,'2021-03-05',1060.01,'Factura A N°: 2338-00004676',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(374,3598,3,40733,40751,57,3042,2,0,'2021-03-05',2160.00,'Factura A N°: 2379-00004839',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(375,3598,3,40733,40751,57,3042,2,0,'2021-03-05',1060.00,'Factura A N°: 2377-00001999',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(376,3598,3,40733,40751,57,3042,2,0,'2021-03-05',540.00,'Factura A N°: 2319-00004306',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(377,3598,3,40733,40751,57,3042,2,0,'2021-03-08',569.99,'Factura A N°: 2319-00004328',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(378,3598,3,40733,40751,57,3042,2,0,'2021-03-08',569.99,'Factura A N°: 2379-00004848',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(379,3598,3,40733,40751,57,3042,2,0,'2021-03-08',6220.85,'Factura A N°: 2300-00013245',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(380,3598,3,40733,40754,57,3042,2,0,'2021-03-08',7108.99,'Factura A N°: 0004-00015794',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(381,3598,3,40733,40783,57,3042,2,0,'2021-03-08',38000.00,'Factura C N°: 0002-00000038',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(382,3598,3,40733,40751,57,3042,2,0,'2021-03-09',1060.00,'Factura A N°: 2302-00007702',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(383,3598,3,40733,40782,57,3042,2,0,'2021-03-09',69550.80,'Factura A N°: 0003-00004054',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(384,3598,3,40733,40751,57,3042,2,0,'2021-03-10',569.99,'Factura A N°: 2463-00000204',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(385,3598,3,40733,40757,57,3042,2,0,'2021-03-10',28459.20,'Factura A N°: 0002-00001856',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(386,3598,3,40733,40751,57,3042,2,0,'2021-03-10',570.01,'Factura A N°: 2383-00004176',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL);
INSERT INTO `cta_cte_cliente` VALUES (387,3598,3,40733,40751,57,3042,2,0,'2021-03-11',570.01,'Factura A N°: 2386-00008112',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(388,3598,3,40733,40784,57,3042,2,0,'2021-03-11',3960.03,'Factura A N°: 0007-00005700',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(389,3598,3,40733,40785,57,3042,2,0,'2021-03-11',42487.26,'Factura A N°: 0003-00000729',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(390,3598,3,40733,40751,57,3042,2,0,'2021-03-12',569.99,'Factura A N°: 2339-00007633',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(391,3598,3,40733,40751,57,3042,2,0,'2021-03-12',570.01,'Factura A N°: 2339-00007635',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(392,3598,3,40733,40751,57,3042,1,0,'2021-03-12',570.01,'Nota de crédito A N°: 2300-00027480',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(393,3598,3,40733,40752,57,3042,2,0,'2021-03-12',106879.30,'Factura A N°: 0002-00001051',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(394,3598,3,40733,40758,57,3042,2,0,'2021-03-13',27123.53,'Factura A N°: 0010-00003018',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(395,3598,3,40733,40751,57,3042,2,0,'2021-03-15',1060.01,'Factura A N°: 2453-00000921',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(396,3598,3,40733,40751,57,3042,2,0,'2021-03-15',569.99,'Factura A N°: 2338-00004790',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(397,3598,3,40733,40751,57,3042,2,0,'2021-03-15',3010.00,'Factura A N°: 2379-00004939',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(398,3598,3,40733,40751,57,3042,2,0,'2021-03-16',570.01,'Factura A N°: 2412-00002661',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(399,3598,3,40733,40751,57,3042,2,0,'2021-03-16',1060.00,'Factura A N°: 2377-00002053',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(400,3598,3,40733,40786,57,3042,2,0,'2021-03-17',16335.00,'Factura A N°: 0004-00002392',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(401,3598,3,40733,40751,57,3042,2,0,'2021-03-17',569.99,'Factura A N°: 2423-00002151',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(402,3598,3,40733,40751,57,3042,2,0,'2021-03-17',1060.01,'Factura A N°: 2338-00004844',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(403,3598,3,40733,40751,57,3042,2,0,'2021-03-19',570.01,'Factura A N°: 2412-00002690',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(404,3598,3,40733,40757,57,3042,2,0,'2021-03-22',74778.00,'Factura A N°: 0002-00001872',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(405,3598,3,40733,40751,57,3042,2,0,'2021-03-23',569.99,'Factura A N°: 2302-00007937',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(406,3598,3,40733,40751,57,3042,2,0,'2021-03-23',4530.00,'Factura A N°: 2338-00004918',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(407,3598,3,40733,40751,57,3042,2,0,'2021-03-23',569.99,'Factura A N°: 2400-00002769',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(408,3598,3,40733,40751,57,3042,2,0,'2021-03-25',1230.00,'Factura A N°: 2339-00007800',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(409,3598,3,40733,40751,57,3042,2,0,'2021-03-25',569.99,'Factura A N°: 2421-00005558',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(410,3598,3,40733,40787,57,3042,2,0,'2021-03-29',28702.74,'Factura A N°: 0011-00204552',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(411,3598,3,40733,40760,57,3042,2,0,'2021-03-30',60000.00,'Factura C N°: 0001-00000028',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(412,3598,3,40733,40719,57,3042,2,0,'2021-03-31',19500.00,'Factura C N°: 0002-00000113',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(413,3598,3,40733,40788,57,3042,2,0,'2021-03-31',27664.27,'Factura A N°: 0007-00001208',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL),(414,3598,3,40733,40753,57,3042,2,0,'2021-03-31',6390.01,'Factura A N°: 0005-00006852',NULL,'2021-04-20 18:08:14','2021-04-20 18:08:14',NULL);
INSERT INTO `cta_cte_cliente` VALUES (415,3598,2,40720,40730,13,1531,1,0,'2021-04-01',241.50,'Factura B N°: 0003-00000215',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(416,3598,2,40720,40730,13,1531,1,0,'2021-04-01',1507.65,'Factura B N°: 0003-00000216',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(417,3598,2,40720,40730,13,1531,1,0,'2021-04-01',439.92,'Factura B N°: 0003-00000217',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(418,3598,2,40720,40730,13,1531,1,0,'2021-04-03',879.89,'Factura B N°: 0003-00000218',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(419,3598,2,40720,40730,13,1531,1,0,'2021-04-03',1207.50,'Factura B N°: 0003-00000219',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(420,3598,2,40720,40730,13,1531,1,0,'2021-04-03',6047.85,'Factura B N°: 0003-00000220',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(421,3598,2,40720,40730,13,1531,1,0,'2021-04-03',989.00,'Factura B N°: 0003-00000221',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(422,3598,2,40720,40730,13,1531,1,0,'2021-04-03',2450.00,'Factura B N°: 0003-00000222',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(423,3598,2,40720,40730,13,1531,1,0,'2021-04-03',835.00,'Factura B N°: 0003-00000223',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(424,3598,2,40720,40730,13,1531,1,0,'2021-04-03',3597.20,'Factura B N°: 0003-00000224',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(425,3598,2,40720,40730,13,1531,1,0,'2021-04-03',412.00,'Factura B N°: 0003-00000225',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(426,3598,2,40720,40730,13,1531,1,0,'2021-04-03',600.09,'Factura B N°: 0003-00000226',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(427,3598,2,40720,40730,13,1531,1,0,'2021-04-03',1653.70,'Factura B N°: 0003-00000227',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(428,3598,2,40720,40730,13,1531,1,0,'2021-04-03',499.93,'Factura B N°: 0003-00000228',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(429,3598,2,40720,40731,13,1531,1,0,'2021-04-05',1959.99,'Factura A N°: 0003-00000003',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(430,3598,2,40720,40730,13,1531,1,0,'2021-04-05',5829.35,'Factura B N°: 0003-00000229',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(431,3598,2,40720,40730,13,1531,1,0,'2021-04-05',3646.00,'Factura B N°: 0003-00000230',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(432,3598,2,40720,40730,13,1531,1,0,'2021-04-05',639.97,'Factura B N°: 0003-00000231',NULL,'2021-05-16 21:55:00','2021-05-16 21:55:00',NULL),(433,3598,2,40720,40730,13,1531,1,0,'2021-04-05',2165.00,'Factura B N°: 0003-00000232',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(434,3598,2,40720,40730,13,1531,1,0,'2021-04-05',399.90,'Factura B N°: 0003-00000233',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(435,3598,2,40720,40730,13,1531,1,0,'2021-04-05',600.07,'Factura B N°: 0003-00000234',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(436,3598,2,40720,40730,13,1531,1,0,'2021-04-05',2136.70,'Factura B N°: 0003-00000235',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(437,3598,2,40720,40730,13,1531,1,0,'2021-04-05',1390.00,'Factura B N°: 0003-00000236',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(438,3598,2,40720,40730,13,1531,1,0,'2021-04-05',2229.00,'Factura B N°: 0003-00000237',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(439,3598,2,40720,40730,13,1531,1,0,'2021-04-05',5911.00,'Factura B N°: 0003-00000238',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(440,3598,2,40720,40730,13,1531,1,0,'2021-04-05',680.00,'Factura B N°: 0003-00000239',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(441,3598,2,40720,40730,13,1531,1,0,'2021-04-05',369.92,'Factura B N°: 0003-00000240',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(442,3598,2,40720,40730,13,1531,1,0,'2021-04-05',3419.00,'Factura B N°: 0003-00000241',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL);
INSERT INTO `cta_cte_cliente` VALUES (443,3598,2,40720,40730,13,1531,1,0,'2021-04-06',3344.00,'Factura B N°: 0003-00000242',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(444,3598,2,40720,40730,13,1531,1,0,'2021-04-06',1600.00,'Factura B N°: 0003-00000243',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(445,3598,2,40720,40730,13,1531,1,0,'2021-04-06',7708.00,'Factura B N°: 0003-00000244',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(446,3598,2,40720,40730,13,1531,1,0,'2021-04-06',1500.00,'Factura B N°: 0003-00000245',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(447,3598,2,40720,40730,13,1531,1,0,'2021-04-06',1138.50,'Factura B N°: 0003-00000246',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(448,3598,2,40720,40730,13,1531,1,0,'2021-04-06',4288.35,'Factura B N°: 0003-00000247',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(449,3598,2,40720,40730,13,1531,1,0,'2021-04-07',3573.05,'Factura B N°: 0003-00000248',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(450,3598,2,40720,40730,13,1531,1,0,'2021-04-07',1960.00,'Factura B N°: 0003-00000249',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(451,3598,2,40720,40730,13,1531,1,0,'2021-04-07',1400.00,'Factura B N°: 0003-00000250',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(452,3598,2,40720,40730,13,1531,1,0,'2021-04-07',825.00,'Factura B N°: 0003-00000251',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(453,3598,2,40720,40730,13,1531,1,0,'2021-04-07',600.00,'Factura B N°: 0003-00000252',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(454,3598,2,40720,40730,13,1531,1,0,'2021-04-07',5915.60,'Factura B N°: 0003-00000253',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(455,3598,2,40720,40730,13,1531,1,0,'2021-04-07',1820.02,'Factura B N°: 0003-00000254',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(456,3598,2,40720,40730,13,1531,1,0,'2021-04-07',2430.00,'Factura B N°: 0003-00000255',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(457,3598,2,40720,40730,13,1531,1,0,'2021-04-07',4636.80,'Factura B N°: 0003-00000256',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(458,3598,2,40720,40730,13,1531,1,0,'2021-04-07',1520.01,'Factura B N°: 0003-00000257',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(459,3598,2,40720,40730,13,1531,1,0,'2021-04-07',1629.55,'Factura B N°: 0003-00000258',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(460,3598,2,40720,40732,13,1531,1,0,'2021-04-08',2291.99,'Factura A N°: 0003-00000004',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(461,3598,2,40720,40730,13,1531,1,0,'2021-04-08',2739.30,'Factura B N°: 0003-00000259',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(462,3598,2,40720,40730,13,1531,1,0,'2021-04-08',240.00,'Factura B N°: 0003-00000260',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(463,3598,2,40720,40730,13,1531,1,0,'2021-04-08',399.98,'Factura B N°: 0003-00000261',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(464,3598,2,40720,40730,13,1531,1,0,'2021-04-08',7340.45,'Factura B N°: 0003-00000262',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(465,3598,2,40720,40730,13,1531,1,0,'2021-04-08',4821.95,'Factura B N°: 0003-00000263',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(466,3598,2,40720,40730,13,1531,1,0,'2021-04-08',500.09,'Factura B N°: 0003-00000264',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(467,3598,2,40720,40730,13,1531,1,0,'2021-04-08',1872.00,'Factura B N°: 0003-00000265',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(468,3598,2,40720,40730,13,1531,1,0,'2021-04-08',2335.01,'Factura B N°: 0003-00000266',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(469,3598,2,40720,40730,13,1531,1,0,'2021-04-08',3003.00,'Factura B N°: 0003-00000267',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(470,3598,2,40720,40730,13,1531,1,0,'2021-04-08',3291.30,'Factura B N°: 0003-00000268',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL);
INSERT INTO `cta_cte_cliente` VALUES (471,3598,2,40720,40730,13,1531,1,0,'2021-04-08',1757.00,'Factura B N°: 0003-00000269',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(472,3598,2,40720,40730,13,1531,1,0,'2021-04-09',1018.00,'Factura B N°: 0003-00000270',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(473,3598,2,40720,40730,13,1531,1,0,'2021-04-09',600.08,'Factura B N°: 0003-00000271',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(474,3598,2,40720,40730,13,1531,1,0,'2021-04-09',3705.00,'Factura B N°: 0003-00000272',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(475,3598,2,40720,40730,13,1531,1,0,'2021-04-09',1103.00,'Factura B N°: 0003-00000273',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(476,3598,2,40720,40730,13,1531,1,0,'2021-04-09',1190.14,'Factura B N°: 0003-00000274',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(477,3598,2,40720,40730,13,1531,1,0,'2021-04-10',770.02,'Factura B N°: 0003-00000275',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(478,3598,2,40720,40730,13,1531,1,0,'2021-04-10',580.07,'Factura B N°: 0003-00000276',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(479,3598,2,40720,40730,13,1531,1,0,'2021-04-10',1930.00,'Factura B N°: 0003-00000277',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(480,3598,2,40720,40730,13,1531,1,0,'2021-04-10',2257.13,'Factura B N°: 0003-00000278',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(481,3598,2,40720,40730,13,1531,1,0,'2021-04-10',439.88,'Factura B N°: 0003-00000279',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(482,3598,2,40720,40730,13,1531,1,0,'2021-04-10',570.16,'Factura B N°: 0003-00000280',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(483,3598,2,40720,40730,13,1531,1,0,'2021-04-10',592.00,'Factura B N°: 0003-00000281',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(484,3598,2,40720,40730,13,1531,1,0,'2021-04-12',400.01,'Factura B N°: 0003-00000282',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(485,3598,2,40720,40730,13,1531,1,0,'2021-04-12',1914.75,'Factura B N°: 0003-00000283',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(486,3598,2,40720,40730,13,1531,1,0,'2021-04-12',1401.03,'Factura B N°: 0003-00000284',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(487,3598,2,40720,40730,13,1531,1,0,'2021-04-12',2587.50,'Factura B N°: 0003-00000285',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(488,3598,2,40720,40730,13,1531,1,0,'2021-04-12',300.03,'Factura B N°: 0003-00000286',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(489,3598,2,40720,40730,13,1531,1,0,'2021-04-12',349.98,'Factura B N°: 0003-00000287',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(490,3598,2,40720,40730,13,1531,1,0,'2021-04-12',399.98,'Factura B N°: 0003-00000288',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(491,3598,2,40720,40730,13,1531,1,0,'2021-04-12',300.00,'Factura B N°: 0003-00000289',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(492,3598,2,40720,40730,13,1531,1,0,'2021-04-12',439.92,'Factura B N°: 0003-00000290',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(493,3598,2,40720,40730,13,1531,1,0,'2021-04-12',385.00,'Factura B N°: 0003-00000291',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(494,3598,2,40720,40730,13,1531,1,0,'2021-04-12',1960.00,'Factura B N°: 0003-00000292',NULL,'2021-05-16 21:55:01','2021-05-16 21:55:01',NULL),(495,3598,2,40720,40730,13,1531,1,0,'2021-04-12',835.00,'Factura B N°: 0003-00000293',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(496,3598,2,40720,40730,13,1531,1,0,'2021-04-12',100.11,'Factura B N°: 0003-00000294',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(497,3598,2,40720,40730,13,1531,1,0,'2021-04-12',100.02,'Factura B N°: 0003-00000295',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(498,3598,2,40720,40730,13,1531,1,0,'2021-04-12',1820.03,'Factura B N°: 0003-00000296',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL);
INSERT INTO `cta_cte_cliente` VALUES (499,3598,2,40720,40730,13,1531,1,0,'2021-04-13',1035.21,'Factura B N°: 0003-00000297',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(500,3598,2,40720,40730,13,1531,1,0,'2021-04-13',1040.20,'Factura B N°: 0003-00000298',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(501,3598,2,40720,40730,13,1531,1,0,'2021-04-13',5312.00,'Factura B N°: 0003-00000299',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(502,3598,2,40720,40730,13,1531,1,0,'2021-04-13',2370.00,'Factura B N°: 0003-00000300',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(503,3598,2,40720,40730,13,1531,1,0,'2021-04-13',2862.00,'Factura B N°: 0003-00000301',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(504,3598,2,40720,40730,13,1531,1,0,'2021-04-13',1380.00,'Factura B N°: 0003-00000302',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(505,3598,2,40720,40730,13,1531,1,0,'2021-04-13',2711.00,'Factura B N°: 0003-00000303',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(506,3598,2,40720,40730,13,1531,1,0,'2021-04-13',2336.80,'Factura B N°: 0003-00000304',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(507,3598,2,40720,40730,13,1531,1,0,'2021-04-13',1649.92,'Factura B N°: 0003-00000305',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(508,3598,2,40720,40730,13,1531,1,0,'2021-04-13',456.00,'Factura B N°: 0003-00000306',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(509,3598,2,40720,40730,13,1531,1,0,'2021-04-13',1970.00,'Factura B N°: 0003-00000307',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(510,3598,2,40720,40730,13,1531,1,0,'2021-04-14',1878.00,'Factura B N°: 0003-00000308',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(511,3598,2,40720,40730,13,1531,1,0,'2021-04-14',2320.00,'Factura B N°: 0003-00000309',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(512,3598,2,40720,40730,13,1531,1,0,'2021-04-14',699.93,'Factura B N°: 0003-00000310',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(513,3598,2,40720,40730,13,1531,1,0,'2021-04-14',710.08,'Factura B N°: 0003-00000311',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(514,3598,2,40720,40730,13,1531,1,0,'2021-04-14',1499.95,'Factura B N°: 0003-00000312',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(515,3598,2,40720,40730,13,1531,1,0,'2021-04-14',400.02,'Factura B N°: 0003-00000313',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(516,3598,2,40720,40730,13,1531,1,0,'2021-04-14',1208.00,'Factura B N°: 0003-00000314',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(517,3598,2,40720,40730,13,1531,1,0,'2021-04-14',1143.10,'Factura B N°: 0003-00000315',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(518,3598,2,40720,40730,13,1531,1,0,'2021-04-14',1112.00,'Factura B N°: 0003-00000316',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(519,3598,2,40720,40730,13,1531,1,0,'2021-04-15',2900.00,'Factura B N°: 0003-00000317',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(520,3598,2,40720,40730,13,1531,1,0,'2021-04-15',1960.00,'Factura B N°: 0003-00000318',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(521,3598,2,40720,40730,13,1531,1,0,'2021-04-15',200.15,'Factura B N°: 0003-00000319',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(522,3598,2,40720,40730,13,1531,1,0,'2021-04-15',250.14,'Factura B N°: 0003-00000320',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(523,3598,2,40720,40730,13,1531,1,0,'2021-04-15',190.00,'Factura B N°: 0003-00000321',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(524,3598,2,40720,40730,13,1531,1,0,'2021-04-15',449.84,'Factura B N°: 0003-00000322',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(525,3598,2,40720,40730,13,1531,1,0,'2021-04-15',2000.00,'Factura B N°: 0003-00000323',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(526,3598,2,40720,40730,13,1531,1,0,'2021-04-16',849.85,'Factura B N°: 0003-00000324',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL);
INSERT INTO `cta_cte_cliente` VALUES (527,3598,2,40720,40730,13,1531,1,0,'2021-04-16',1400.00,'Factura B N°: 0003-00000325',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(528,3598,2,40720,40730,13,1531,1,0,'2021-04-16',2254.00,'Factura B N°: 0003-00000326',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(529,3598,2,40720,40730,13,1531,1,0,'2021-04-16',1623.80,'Factura B N°: 0003-00000327',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(530,3598,2,40720,40730,13,1531,1,0,'2021-04-16',4350.00,'Factura B N°: 0003-00000328',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(531,3598,2,40720,40730,13,1531,1,0,'2021-04-17',880.00,'Factura B N°: 0003-00000329',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(532,3598,2,40720,40730,13,1531,1,0,'2021-04-17',1960.00,'Factura B N°: 0003-00000330',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(533,3598,2,40720,40730,13,1531,1,0,'2021-04-17',2180.00,'Factura B N°: 0003-00000331',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(534,3598,2,40720,40730,13,1531,1,0,'2021-04-17',2507.00,'Factura B N°: 0003-00000332',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(535,3598,2,40720,40730,13,1531,1,0,'2021-04-17',2800.00,'Factura B N°: 0003-00000333',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(536,3598,2,40720,40730,13,1531,1,0,'2021-04-17',1771.00,'Factura B N°: 0003-00000334',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(537,3598,2,40720,40730,13,1531,1,0,'2021-04-17',2229.00,'Factura B N°: 0003-00000335',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(538,3598,2,40720,40730,13,1531,1,0,'2021-04-17',1370.00,'Factura B N°: 0003-00000336',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(539,3598,2,40720,40730,13,1531,1,0,'2021-04-17',570.09,'Factura B N°: 0003-00000337',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(540,3598,2,40720,40730,13,1531,1,0,'2021-04-17',1000.04,'Factura B N°: 0003-00000338',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(541,3598,2,40720,40730,13,1531,1,0,'2021-04-19',549.99,'Factura B N°: 0003-00000339',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(542,3598,2,40720,40730,13,1531,1,0,'2021-04-19',599.92,'Factura B N°: 0003-00000340',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(543,3598,2,40720,40730,13,1531,1,0,'2021-04-19',598.00,'Factura B N°: 0003-00000341',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(544,3598,2,40720,40730,13,1531,1,0,'2021-04-19',282.00,'Factura B N°: 0003-00000342',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(545,3598,2,40720,40730,13,1531,1,0,'2021-04-19',2793.35,'Factura B N°: 0003-00000343',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(546,3598,2,40720,40730,13,1531,1,0,'2021-04-20',400.03,'Factura B N°: 0003-00000344',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(547,3598,2,40720,40730,13,1531,1,0,'2021-04-20',515.00,'Factura B N°: 0003-00000345',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(548,3598,2,40720,40730,13,1531,1,0,'2021-04-20',238.00,'Factura B N°: 0003-00000346',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(549,3598,2,40720,40730,13,1531,1,0,'2021-04-20',1640.00,'Factura B N°: 0003-00000347',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(550,3598,2,40720,40730,13,1531,1,0,'2021-04-20',3312.00,'Factura B N°: 0003-00000348',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(551,3598,2,40720,40730,13,1531,1,0,'2021-04-21',3230.35,'Factura B N°: 0003-00000349',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(552,3598,2,40720,40730,13,1531,1,0,'2021-04-21',2756.55,'Factura B N°: 0003-00000350',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(553,3598,2,40720,40730,13,1531,1,0,'2021-04-21',429.00,'Factura B N°: 0003-00000351',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(554,3598,2,40720,40730,13,1531,1,0,'2021-04-21',580.00,'Factura B N°: 0003-00000352',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL);
INSERT INTO `cta_cte_cliente` VALUES (555,3598,2,40720,40730,13,1531,1,0,'2021-04-21',3078.95,'Factura B N°: 0003-00000353',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(556,3598,2,40720,40730,13,1531,1,0,'2021-04-21',2254.00,'Factura B N°: 0003-00000354',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(557,3598,2,40720,40730,13,1531,1,0,'2021-04-21',499.80,'Factura B N°: 0003-00000355',NULL,'2021-05-16 21:55:02','2021-05-16 21:55:02',NULL),(558,3598,2,40720,40730,13,1531,1,0,'2021-04-21',452.13,'Factura B N°: 0003-00000356',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(559,3598,2,40720,40730,13,1531,1,0,'2021-04-22',2450.00,'Factura B N°: 0003-00000357',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(560,3598,2,40720,40730,13,1531,1,0,'2021-04-22',2089.95,'Factura B N°: 0003-00000358',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(561,3598,2,40720,40730,13,1531,1,0,'2021-04-22',259.97,'Factura B N°: 0003-00000359',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(562,3598,2,40720,40730,13,1531,1,0,'2021-04-22',1860.00,'Factura B N°: 0003-00000360',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(563,3598,2,40720,40730,13,1531,1,0,'2021-04-22',1899.80,'Factura B N°: 0003-00000361',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(564,3598,2,40720,40730,13,1531,1,0,'2021-04-22',2110.00,'Factura B N°: 0003-00000362',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(565,3598,2,40720,40730,13,1531,1,0,'2021-04-23',490.01,'Factura B N°: 0003-00000363',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(566,3598,2,40720,40730,13,1531,1,0,'2021-04-23',950.12,'Factura B N°: 0003-00000364',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(567,3598,2,40720,40730,13,1531,1,0,'2021-04-23',280.00,'Factura B N°: 0003-00000365',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(568,3598,2,40720,40730,13,1531,1,0,'2021-04-23',900.00,'Factura B N°: 0003-00000366',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(569,3598,2,40720,40730,13,1531,1,0,'2021-04-23',790.03,'Factura B N°: 0003-00000367',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(570,3598,2,40720,40730,13,1531,1,0,'2021-04-23',7580.00,'Factura B N°: 0003-00000368',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(571,3598,2,40720,40730,13,1531,1,0,'2021-04-23',462.35,'Factura B N°: 0003-00000369',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(572,3598,2,40720,40730,13,1531,1,0,'2021-04-23',1357.98,'Factura B N°: 0003-00000370',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(573,3598,2,40720,40730,13,1531,1,0,'2021-04-23',3990.00,'Factura B N°: 0003-00000371',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(574,3598,2,40720,40730,13,1531,1,0,'2021-04-23',1265.00,'Factura B N°: 0003-00000372',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(575,3598,2,40720,40730,13,1531,1,0,'2021-04-23',1270.12,'Factura B N°: 0003-00000373',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(576,3598,2,40720,40730,13,1531,1,0,'2021-04-23',399.91,'Factura B N°: 0003-00000374',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(577,3598,2,40720,40730,13,1531,1,0,'2021-04-23',700.00,'Factura B N°: 0003-00000375',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(578,3598,2,40720,40730,13,1531,1,0,'2021-04-23',2620.22,'Factura B N°: 0003-00000376',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(579,3598,2,40720,40730,13,1531,1,0,'2021-04-23',1147.65,'Factura B N°: 0003-00000377',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(580,3598,2,40720,40730,13,1531,1,0,'2021-04-23',200.01,'Factura B N°: 0003-00000378',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(581,3598,2,40720,40730,13,1531,1,0,'2021-04-24',726.09,'Factura B N°: 0003-00000379',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(582,3598,2,40720,40730,13,1531,1,0,'2021-04-24',349.97,'Factura B N°: 0003-00000380',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL);
INSERT INTO `cta_cte_cliente` VALUES (583,3598,2,40720,40730,13,1531,1,0,'2021-04-24',499.94,'Factura B N°: 0003-00000381',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(584,3598,2,40720,40730,13,1531,1,0,'2021-04-24',600.00,'Factura B N°: 0003-00000382',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(585,3598,2,40720,40730,13,1531,1,0,'2021-04-24',1895.00,'Factura B N°: 0003-00000383',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(586,3598,2,40720,40730,13,1531,1,0,'2021-04-24',2219.50,'Factura B N°: 0003-00000384',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(587,3598,2,40720,40730,13,1531,1,0,'2021-04-24',3220.00,'Factura B N°: 0003-00000385',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(588,3598,2,40720,40730,13,1531,1,0,'2021-04-24',499.92,'Factura B N°: 0003-00000386',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(589,3598,2,40720,40730,13,1531,1,0,'2021-04-24',1836.00,'Factura B N°: 0003-00000387',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(590,3598,2,40720,40730,13,1531,1,0,'2021-04-24',460.00,'Factura B N°: 0003-00000388',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(591,3598,2,40720,40730,13,1531,1,0,'2021-04-24',4600.00,'Factura B N°: 0003-00000389',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(592,3598,2,40720,40730,13,1531,1,0,'2021-04-24',2000.10,'Factura B N°: 0003-00000390',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(593,3598,2,40720,40730,13,1531,1,0,'2021-04-24',1049.79,'Factura B N°: 0003-00000391',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(594,3598,2,40720,40730,13,1531,1,0,'2021-04-24',499.98,'Factura B N°: 0003-00000392',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(595,3598,2,40720,40730,13,1531,1,0,'2021-04-26',669.98,'Factura B N°: 0003-00000393',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(596,3598,2,40720,40730,13,1531,1,0,'2021-04-26',499.97,'Factura B N°: 0003-00000394',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(597,3598,2,40720,40730,13,1531,1,0,'2021-04-26',500.03,'Factura B N°: 0003-00000395',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(598,3598,2,40720,40730,13,1531,1,0,'2021-04-26',1944.65,'Factura B N°: 0003-00000396',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(599,3598,2,40720,40730,13,1531,1,0,'2021-04-26',170.01,'Factura B N°: 0003-00000397',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(600,3598,2,40720,40730,13,1531,1,0,'2021-04-26',928.00,'Factura B N°: 0003-00000398',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(601,3598,2,40720,40730,13,1531,1,0,'2021-04-26',1771.00,'Factura B N°: 0003-00000399',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(602,3598,2,40720,40730,13,1531,1,0,'2021-04-26',499.99,'Factura B N°: 0003-00000400',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(603,3598,2,40720,40730,13,1531,1,0,'2021-04-26',1930.00,'Factura B N°: 0003-00000401',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(604,3598,2,40720,40730,13,1531,1,0,'2021-04-26',1668.91,'Factura B N°: 0003-00000402',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(605,3598,2,40720,40730,13,1531,1,0,'2021-04-26',551.49,'Factura B N°: 0003-00000403',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(606,3598,2,40720,40730,13,1531,1,0,'2021-04-27',1099.97,'Factura B N°: 0003-00000404',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(607,3598,2,40720,40730,13,1531,1,0,'2021-04-27',456.05,'Factura B N°: 0003-00000405',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(608,3598,2,40720,40730,13,1531,1,0,'2021-04-27',2495.50,'Factura B N°: 0003-00000406',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(609,3598,2,40720,40730,13,1531,1,0,'2021-04-27',2254.00,'Factura B N°: 0003-00000407',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(610,3598,2,40720,40730,13,1531,1,0,'2021-04-27',2542.05,'Factura B N°: 0003-00000408',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL);
INSERT INTO `cta_cte_cliente` VALUES (611,3598,2,40720,40730,13,1531,1,0,'2021-04-27',9259.80,'Factura B N°: 0003-00000409',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(612,3598,2,40720,40730,13,1531,1,0,'2021-04-27',680.00,'Factura B N°: 0003-00000410',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(613,3598,2,40720,40730,13,1531,1,0,'2021-04-28',2487.00,'Factura B N°: 0003-00000411',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(614,3598,2,40720,40730,13,1531,1,0,'2021-04-28',1265.43,'Factura B N°: 0003-00000412',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(615,3598,2,40720,40730,13,1531,1,0,'2021-04-28',1599.99,'Factura B N°: 0003-00000413',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(616,3598,2,40720,40730,13,1531,1,0,'2021-04-28',1029.00,'Factura B N°: 0003-00000414',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(617,3598,2,40720,40730,13,1531,1,0,'2021-04-28',1894.00,'Factura B N°: 0003-00000415',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(618,3598,2,40720,40730,13,1531,1,0,'2021-04-28',1450.00,'Factura B N°: 0003-00000416',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(619,3598,2,40720,40730,13,1531,1,0,'2021-04-28',673.36,'Factura B N°: 0003-00000417',NULL,'2021-05-16 21:55:03','2021-05-16 21:55:03',NULL),(620,3598,2,40720,40731,13,1531,1,0,'2021-04-29',2110.00,'Factura A N°: 0003-00000005',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(621,3598,2,40720,40730,13,1531,1,0,'2021-04-29',999.86,'Factura B N°: 0003-00000418',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(622,3598,2,40720,40730,13,1531,1,0,'2021-04-29',2020.09,'Factura B N°: 0003-00000419',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(623,3598,2,40720,40730,13,1531,1,0,'2021-04-29',660.00,'Factura B N°: 0003-00000420',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(624,3598,2,40720,40730,13,1531,1,0,'2021-04-29',3290.00,'Factura B N°: 0003-00000421',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(625,3598,2,40720,40730,13,1531,1,0,'2021-04-29',499.93,'Factura B N°: 0003-00000422',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(626,3598,2,40720,40730,13,1531,1,0,'2021-04-29',2587.00,'Factura B N°: 0003-00000423',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(627,3598,2,40720,40730,13,1531,1,0,'2021-04-29',1359.98,'Factura B N°: 0003-00000424',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(628,3598,2,40720,40730,13,1531,1,0,'2021-04-29',1369.81,'Factura B N°: 0003-00000425',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(629,3598,2,40720,40730,13,1531,1,0,'2021-04-30',499.99,'Factura B N°: 0003-00000426',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(630,3598,2,40720,40730,13,1531,1,0,'2021-04-30',4295.25,'Factura B N°: 0003-00000427',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(631,3598,2,40720,40730,13,1531,1,0,'2021-04-30',200.03,'Factura B N°: 0003-00000428',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(632,3598,2,40720,40730,13,1531,1,0,'2021-04-30',3163.47,'Factura B N°: 0003-00000429',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(633,3598,2,40720,40730,13,1531,1,0,'2021-04-30',899.91,'Factura B N°: 0003-00000430',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(634,3598,2,40720,40730,13,1531,1,0,'2021-04-30',834.00,'Factura B N°: 0003-00000431',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(635,3598,2,40720,40730,13,1531,1,0,'2021-04-30',248.00,'Factura B N°: 0003-00000432',NULL,'2021-05-16 21:55:04','2021-05-16 21:55:04',NULL),(636,3598,2,40720,40730,13,1531,1,0,'2021-04-30',799.97,'Factura B N°: 0003-00000433',NULL,'2021-05-16 21:55:04','2021-05-17 15:59:12','2021-05-17 15:59:12'),(637,3598,3,40720,40724,57,1531,2,0,'2021-04-01',50364.56,'Factura A N°: 0001-00008224',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54');
INSERT INTO `cta_cte_cliente` VALUES (638,3598,3,40720,40789,57,1531,2,0,'2021-04-01',14171.73,'Factura B N°: 0002-00014141',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(639,3598,3,40720,40728,57,1531,1,0,'2021-04-01',2371.95,'Nota de crédito B N°: 0388-00096273',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(640,3598,3,40720,40722,57,1531,1,0,'2021-04-05',5201.11,'Nota de crédito A N°: 0007-00005840',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(641,3598,3,40720,40722,57,1531,1,0,'2021-04-05',8747.01,'Nota de crédito A N°: 0007-00005850',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(642,3598,3,40720,40722,57,1531,2,0,'2021-04-05',36435.29,'Factura A N°: 0007-00017256',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(643,3598,3,40720,40724,57,1531,2,0,'2021-04-06',49746.86,'Factura A N°: 0001-00008269',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(644,3598,3,40720,40724,57,1531,2,0,'2021-04-06',28610.33,'Factura A N°: 0001-00008270',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(645,3598,3,40720,40723,57,1531,2,0,'2021-04-07',51940.30,'Factura A N°: 0001-00000774',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(646,3598,3,40720,40724,57,1531,2,0,'2021-04-10',8996.29,'Factura A N°: 0001-00008342',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(647,3598,3,40720,40724,57,1531,2,0,'2021-04-12',13538.65,'Factura A N°: 0001-00008344',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(648,3598,3,40720,40728,57,1531,2,0,'2021-04-12',2085.43,'Factura B N°: 0532-00043464',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(649,3598,3,40720,40789,57,1531,1,0,'2021-04-13',14171.70,'Nota de crédito B N°: 0002-00000887',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(650,3598,3,40720,40789,57,1531,2,0,'2021-04-13',14171.22,'Factura A N°: 0002-00022653',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(651,3598,3,40720,40722,57,1531,1,0,'2021-04-13',1455.29,'Nota de crédito A N°: 0007-00005888',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(652,3598,3,40720,40790,57,1531,2,0,'2021-04-14',171.36,'Factura B N°: 0003-00052716',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(653,3598,3,40720,40724,57,1531,2,0,'2021-04-15',55712.48,'Factura B N°: 0001-00016131',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(654,3598,3,40720,40790,57,1531,2,0,'2021-04-15',257.04,'Factura B N°: 0003-00053108',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(655,3598,3,40720,40724,57,1531,1,0,'2021-04-16',55712.48,'Nota de crédito B N°: 0001-00001098',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(656,3598,3,40720,40722,57,1531,2,0,'2021-04-19',25800.16,'Factura A N°: 0007-00017449',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(657,3598,3,40720,40722,57,1531,2,0,'2021-04-19',9102.31,'Factura A N°: 0007-00017450',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(658,3598,3,40720,40791,57,1531,2,0,'2021-04-21',57.00,'Factura A N°: 0005-00001767',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(659,3598,3,40720,40722,57,1531,2,0,'2021-04-22',71478.09,'Factura A N°: 0007-00017516',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(660,3598,3,40720,40724,57,1531,2,0,'2021-04-24',19503.87,'Factura A N°: 0001-00008505',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(661,3598,3,40720,40724,57,1531,2,0,'2021-04-24',16063.94,'Factura A N°: 0001-00008504',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54');
INSERT INTO `cta_cte_cliente` VALUES (662,3598,3,40720,40724,57,1531,1,0,'2021-04-26',3711.68,'Nota de crédito A N°: 0001-00000828',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(663,3598,3,40720,40724,57,1531,2,0,'2021-04-26',13277.94,'Factura A N°: 0001-00008513',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(664,3598,3,40720,40722,57,1531,1,0,'2021-04-27',1396.10,'Nota de crédito A N°: 0007-00005951',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(665,3598,3,40720,40789,57,1531,2,0,'2021-04-29',7555.09,'Factura A N°: 0002-00022854',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(666,3598,3,40720,40722,57,1531,1,0,'2021-04-30',7140.79,'Nota de crédito A N°: 0007-00005979',NULL,'2021-05-16 21:55:22','2021-05-17 16:19:54','2021-05-17 16:19:54'),(667,3598,3,40720,40722,57,1531,1,0,'2021-04-30',2858.98,'Nota de crédito A N°: 0007-00005975',NULL,'2021-05-16 21:55:23','2021-05-17 16:19:54','2021-05-17 16:19:54'),(668,3598,2,40733,40735,13,3043,1,0,'2021-04-05',227026.25,'Factura A N°: 0003-00000387',NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(669,3598,2,40733,40792,13,3043,1,0,'2021-04-06',194369.56,'Factura A N°: 0003-00000388',NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(670,3598,2,40733,40793,13,3043,1,0,'2021-04-07',49510.78,'Factura A N°: 0003-00000389',NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(671,3598,2,40733,40794,13,3043,1,0,'2021-04-07',14326.40,'Factura A N°: 0003-00000390',NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(672,3598,2,40733,40747,13,3043,1,0,'2021-04-07',23400.19,'Factura A N°: 0003-00000391',NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(673,3598,2,40733,40749,13,3043,1,0,'2021-04-08',140546.34,'Factura A N°: 0003-00000392',NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(674,3598,2,40733,40744,13,3043,1,0,'2021-04-08',47133.13,'Factura A N°: 0003-00000393',NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(675,3598,2,40733,40795,13,3043,1,0,'2021-04-09',25276.90,'Factura A N°: 0003-00000394',NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(676,3598,2,40733,40765,13,3043,1,0,'2021-04-13',87363.20,'Factura A N°: 0003-00000395',NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(677,3598,2,40733,40796,13,3043,1,0,'2021-04-14',62617.50,'Factura A N°: 0003-00000396',NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(678,3598,2,40733,40748,13,3043,1,0,'2021-04-14',65538.44,'Factura A N°: 0003-00000397',NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(679,3598,2,40733,40797,13,3043,1,0,'2021-04-14',149356.35,'Factura A N°: 0003-00000398',NULL,'2021-05-17 12:18:56','2021-05-17 12:18:56',NULL),(680,3598,2,40733,40764,13,3043,1,0,'2021-04-15',49675.34,'Factura A N°: 0003-00000399',NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(681,3598,2,40733,40736,13,3043,1,0,'2021-04-19',56851.85,'Factura A N°: 0003-00000400',NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(682,3598,2,40733,40798,13,3043,1,0,'2021-04-19',95033.40,'Factura A N°: 0003-00000401',NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(683,3598,2,40733,40767,13,3043,1,0,'2021-04-20',159041.92,'Factura A N°: 0003-00000402',NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(684,3598,2,40733,40746,13,3043,1,0,'2021-04-21',105360.75,'Factura A N°: 0003-00000403',NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(685,3598,2,40733,40799,13,3043,1,0,'2021-04-22',7994.47,'Factura A N°: 0003-00000404',NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(686,3598,2,40733,40800,13,3043,1,0,'2021-04-27',315848.72,'Factura A N°: 0003-00000405',NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(687,3598,2,40733,40801,13,3043,1,0,'2021-04-27',58059.43,'Factura A N°: 0003-00000406',NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(688,3598,2,40733,40802,13,3043,1,0,'2021-04-29',61435.33,'Factura A N°: 0003-00000407',NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL);
INSERT INTO `cta_cte_cliente` VALUES (689,3598,2,40733,40800,13,3043,2,0,'2021-04-29',11398.20,'Nota de crédito A N°: 0003-00000006',NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(690,3598,2,40733,40748,13,3043,1,0,'2021-04-30',232351.21,'Factura A N°: 0003-00000408',NULL,'2021-05-17 12:18:57','2021-05-17 12:18:57',NULL),(691,3598,3,40733,40803,57,3043,2,0,'2021-04-01',21089.91,'Factura A N°: 0002-00000211',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(692,3598,3,40733,40756,57,3043,2,0,'2021-04-01',74173.00,'Factura A N°: 0007-00002313',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(693,3598,3,40733,40804,57,3043,2,0,'2021-04-05',5599.28,'Factura A N°: 0011-00014262',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(694,3598,3,40733,40769,57,3043,2,0,'2021-04-05',34630.20,'Factura A N°: 0005-00056120',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(695,3598,3,40733,40731,57,3043,1,0,'2021-04-05',1254.28,'Nota de crédito A N°: 0045-00004998',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(696,3598,3,40733,40731,57,3043,2,0,'2021-04-05',41809.21,'Factura A N°: 0045-00158991',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(697,3598,3,40733,40786,57,3043,2,0,'2021-04-06',35767.12,'Factura A N°: 0004-00002425',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(698,3598,3,40733,40769,57,3043,2,0,'2021-04-06',245577.97,'Factura A N°: 0005-00056128',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(699,3598,3,40733,40751,57,3043,2,0,'2021-04-06',690.00,'Factura A N°: 2408-00005227',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(700,3598,3,40733,40751,57,3043,2,0,'2021-04-06',670.00,'Factura A N°: 2381-00005274',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(701,3598,3,40733,40751,57,3043,2,0,'2021-04-07',1400.01,'Factura A N°: 2339-00007974',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(702,3598,3,40733,40751,57,3043,2,0,'2021-04-07',810.00,'Factura A N°: 2339-00007973',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(703,3598,3,40733,40751,57,3043,2,0,'2021-04-08',670.00,'Factura A N°: 2319-00004730',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(704,3598,3,40733,40751,57,3043,2,0,'2021-04-08',1800.00,'Factura A N°: 2379-00005193',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(705,3598,3,40733,40751,57,3043,2,0,'2021-04-08',670.00,'Factura A N°: 2406-00003934',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(706,3598,3,40733,40751,57,3043,2,0,'2021-04-08',1230.00,'Factura A N°: 2453-00001136',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(707,3598,3,40733,40786,57,3043,2,0,'2021-04-12',25116.70,'Factura A N°: 0004-00002432',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(708,3598,3,40733,40782,57,3043,2,0,'2021-04-12',74252.86,'Factura A N°: 0003-00004143',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(709,3598,3,40733,40751,57,3043,2,0,'2021-04-13',670.00,'Factura A N°: 2319-00004785',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(710,3598,3,40733,40805,57,3043,2,0,'2021-04-13',45969.11,'Factura A N°: 0025-00000054',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(711,3598,3,40733,40759,57,3043,2,0,'2021-04-13',112579.84,'Factura A N°: 0008-00003740',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(712,3598,3,40733,40806,57,3043,2,0,'2021-04-13',199786.53,'Factura A N°: 0003-00011759',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(713,3598,3,40733,40782,57,3043,2,0,'2021-04-13',8893.50,'Factura A N°: 0003-00004145',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(714,3598,3,40733,40751,57,3043,2,0,'2021-04-14',3510.00,'Factura A N°: 2338-00005203',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(715,3598,3,40733,40757,57,3043,2,0,'2021-04-14',60681.50,'Factura A N°: 0002-00001896',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL);
INSERT INTO `cta_cte_cliente` VALUES (716,3598,3,40733,40751,57,3043,2,0,'2021-04-14',830.00,'Factura A N°: 2373-00002447',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(717,3598,3,40733,40751,57,3043,2,0,'2021-04-14',850.00,'Factura A N°: 2404-00002665',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(718,3598,3,40733,40751,57,3043,2,0,'2021-04-15',670.00,'Factura A N°: 2339-00008091',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(719,3598,3,40733,40751,57,3043,2,0,'2021-04-15',670.00,'Factura A N°: 2377-00002184',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(720,3598,3,40733,40757,57,3043,2,0,'2021-04-19',65678.80,'Factura A N°: 0002-00001900',NULL,'2021-05-17 12:19:09','2021-05-17 12:19:09',NULL),(721,3598,3,40733,40751,57,3043,2,0,'2021-04-19',670.00,'Factura A N°: 2339-00008113',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(722,3598,3,40733,40751,57,3043,2,0,'2021-04-19',670.00,'Factura A N°: 2339-00008110',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(723,3598,3,40733,40786,57,3043,2,0,'2021-04-20',14113.44,'Factura A N°: 0004-00002450',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(724,3598,3,40733,40786,57,3043,2,0,'2021-04-21',9869.61,'Factura A N°: 0004-00002455',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(725,3598,3,40733,40755,57,3043,2,0,'2021-04-22',13153.04,'Factura A N°: 0003-00002100',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(726,3598,3,40733,40806,57,3043,2,0,'2021-04-22',193801.48,'Factura A N°: 0003-00011806',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(727,3598,3,40733,40806,57,3043,2,0,'2021-04-22',53389.72,'Factura A N°: 0003-00011810',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(728,3598,3,40733,40751,57,3043,2,0,'2021-04-27',2130.00,'Factura A N°: 2404-00002757',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(729,3598,3,40733,40751,57,3043,2,0,'2021-04-27',670.00,'Factura A N°: 2319-00004953',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(730,3598,3,40733,40759,57,3043,2,0,'2021-04-27',71163.68,'Factura A N°: 0008-00003835',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(731,3598,3,40733,40756,57,3043,2,0,'2021-04-27',12035.63,'Factura A N°: 0007-00002349',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(732,3598,3,40733,40757,57,3043,2,0,'2021-04-28',326822.21,'Factura A N°: 0002-00001908',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(733,3598,3,40733,40807,57,3043,2,0,'2021-04-29',3000.00,'Factura A N°: 0006-00004057',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(734,3598,3,40733,40751,57,3043,2,0,'2021-04-30',2940.00,'Factura A N°: 2339-00008309',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(735,3598,3,40733,40719,57,3043,2,0,'2021-04-30',19500.00,'Factura C N°: 0002-00000118',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(736,3598,3,40733,40784,57,3043,2,0,'2021-04-30',597.11,'Factura A N°: 0007-00006856',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(737,3598,3,40733,40784,57,3043,2,0,'2021-04-30',3772.30,'Factura A N°: 0007-00006845',NULL,'2021-05-17 12:19:10','2021-05-17 12:19:10',NULL),(741,3598,3,40720,40721,57,1531,1,0,'1969-12-31',23259.42,'Nota de crédito A N°: 0008-00003116',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(742,3598,3,40720,40725,57,1531,1,0,'1969-12-31',14144.75,'Nota de crédito A N°: 0003-00003759',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(743,3598,3,40720,40725,57,1531,1,0,'1969-12-31',9626.34,'Nota de crédito A N°: 0003-00003782',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(744,3598,3,40720,40724,57,1531,2,0,'2021-04-01',50364.56,'Factura A N°: 0001-00008224',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(745,3598,3,40720,40789,57,1531,2,0,'2021-04-01',14171.73,'Factura B N°: 0002-00014141',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL);
INSERT INTO `cta_cte_cliente` VALUES (746,3598,3,40720,40728,57,1531,1,0,'2021-04-01',2371.95,'Nota de crédito B N°: 0388-00096273',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(747,3598,3,40720,40722,57,1531,1,0,'2021-04-05',5201.11,'Nota de crédito A N°: 0007-00005840',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(748,3598,3,40720,40722,57,1531,1,0,'2021-04-05',8747.01,'Nota de crédito A N°: 0007-00005850',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(749,3598,3,40720,40722,57,1531,2,0,'2021-04-05',36435.29,'Factura A N°: 0007-00017256',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(750,3598,3,40720,40724,57,1531,2,0,'2021-04-06',49746.86,'Factura A N°: 0001-00008269',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(751,3598,3,40720,40724,57,1531,2,0,'2021-04-06',28610.33,'Factura A N°: 0001-00008270',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(752,3598,3,40720,40723,57,1531,2,0,'2021-04-07',51940.30,'Factura A N°: 0001-00000774',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(753,3598,3,40720,40724,57,1531,2,0,'2021-04-10',8996.29,'Factura A N°: 0001-00008342',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(754,3598,3,40720,40724,57,1531,2,0,'2021-04-12',13538.65,'Factura A N°: 0001-00008344',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(755,3598,3,40720,40728,57,1531,2,0,'2021-04-12',2085.43,'Factura B N°: 0532-00043464',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(756,3598,3,40720,40789,57,1531,1,0,'2021-04-13',14171.70,'Nota de crédito B N°: 0002-00000887',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(757,3598,3,40720,40789,57,1531,2,0,'2021-04-13',14171.22,'Factura A N°: 0002-00022653',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(758,3598,3,40720,40722,57,1531,1,0,'2021-04-13',1455.29,'Nota de crédito A N°: 0007-00005888',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(759,3598,3,40720,40790,57,1531,2,0,'2021-04-14',171.36,'Factura B N°: 0003-00052716',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(760,3598,3,40720,40724,57,1531,2,0,'2021-04-15',55712.48,'Factura B N°: 0001-00016131',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(761,3598,3,40720,40790,57,1531,2,0,'2021-04-15',257.04,'Factura B N°: 0003-00053108',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(762,3598,3,40720,40724,57,1531,1,0,'2021-04-16',55712.48,'Nota de crédito B N°: 0001-00001098',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(763,3598,3,40720,40722,57,1531,2,0,'2021-04-19',25800.16,'Factura A N°: 0007-00017449',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(764,3598,3,40720,40722,57,1531,2,0,'2021-04-19',9102.31,'Factura A N°: 0007-00017450',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(765,3598,3,40720,40791,57,1531,2,0,'2021-04-21',57.00,'Factura A N°: 0005-00001767',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(766,3598,3,40720,40722,57,1531,2,0,'2021-04-22',71478.09,'Factura A N°: 0007-00017516',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(767,3598,3,40720,40724,57,1531,2,0,'2021-04-24',19503.87,'Factura A N°: 0001-00008505',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(768,3598,3,40720,40724,57,1531,2,0,'2021-04-24',16063.94,'Factura A N°: 0001-00008504',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(769,3598,3,40720,40724,57,1531,1,0,'2021-04-26',3711.68,'Nota de crédito A N°: 0001-00000828',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(770,3598,3,40720,40724,57,1531,2,0,'2021-04-26',13277.94,'Factura A N°: 0001-00008513',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(771,3598,3,40720,40722,57,1531,1,0,'2021-04-27',1396.10,'Nota de crédito A N°: 0007-00005951',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(772,3598,3,40720,40789,57,1531,2,0,'2021-04-29',7555.09,'Factura A N°: 0002-00022854',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL);
INSERT INTO `cta_cte_cliente` VALUES (773,3598,3,40720,40722,57,1531,1,0,'2021-04-30',7140.79,'Nota de crédito A N°: 0007-00005979',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(774,3598,3,40720,40722,57,1531,1,0,'2021-04-30',2858.98,'Nota de crédito A N°: 0007-00005975',NULL,'2021-05-17 16:49:42','2021-05-17 16:49:42',NULL),(1011,3598,3,40720,40811,57,1532,2,0,'2021-05-04',24629.79,'Factura B N°: 0002-00002783',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1012,3598,3,40720,40724,57,1532,2,0,'2021-05-05',31052.29,'Factura A N°: 0001-00008639',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1013,3598,3,40720,40724,57,1532,2,0,'2021-05-05',11133.51,'Factura A N°: 0001-00008638',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1014,3598,3,40720,40791,57,1532,2,0,'2021-05-05',285.00,'Factura A N°: 0005-00001796',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1015,3598,3,40720,40725,57,1532,2,0,'2021-05-05',9404.47,'Factura A N°: 0003-00018405',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1016,3598,3,40720,40725,57,1532,1,0,'2021-05-05',6269.65,'Nota de crédito A N°: 0003-00004038',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1017,3598,3,40720,40722,57,1532,2,0,'2021-05-06',2291.14,'Factura A N°: 0007-00017667',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1018,3598,3,40720,40722,57,1532,2,0,'2021-05-06',85820.06,'Factura A N°: 0007-00017666',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1019,3598,3,40720,40729,57,1532,2,0,'2021-05-07',1438.91,'Factura A N°: 0032-00007520',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1020,3598,3,40720,40790,57,1532,2,0,'2021-05-10',444.00,'Factura B N°: 0003-00058631',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1021,3598,3,40720,40724,57,1532,2,0,'2021-05-12',34341.80,'Factura A N°: 0001-00008703',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1022,3598,3,40720,40724,57,1532,2,0,'2021-05-12',49003.60,'Factura A N°: 0001-00008702',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1023,3598,3,40720,40725,57,1532,2,0,'2021-05-12',9435.68,'Factura A N°: 0003-00018556',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1024,3598,3,40720,40724,57,1532,2,0,'2021-05-12',954.24,'Factura A N°: 0001-00008723',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1025,3598,3,40720,40724,57,1532,1,0,'2021-05-12',1011.39,'Nota de crédito A N°: 0001-00000865',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1026,3598,3,40720,40722,57,1532,2,0,'2021-05-13',51950.77,'Factura A N°: 0007-00017798',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1027,3598,3,40720,40722,57,1532,1,0,'2021-05-13',3524.45,'Nota de crédito A N°: 0007-00006035',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1028,3598,3,40720,40722,57,1532,2,0,'2021-05-14',18373.77,'Factura A N°: 0007-00017804',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1029,3598,3,40720,40812,57,1532,2,0,'2021-05-14',26589.80,'Factura A N°: 0003-00022012',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1030,3598,3,40720,40721,57,1532,2,0,'2021-05-17',43478.11,'Factura A N°: 0008-00027386',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1031,3598,3,40720,40719,57,1532,2,0,'2021-05-18',2700.00,'Factura C N°: 0002-00000122',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1032,3598,3,40720,40813,57,1532,2,0,'2021-05-18',16186.65,'Factura A N°: 0001-00001309',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1033,3598,3,40720,40814,57,1532,2,0,'2021-05-18',3788.63,'Factura A N°: 0019-00044724',NULL,'2021-06-16 14:51:17','2021-06-16 14:51:17',NULL),(1034,3598,3,40720,40724,57,1532,2,0,'2021-05-19',51358.93,'Factura A N°: 0001-00008802',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1035,3598,3,40720,40724,57,1532,2,0,'2021-05-19',12415.46,'Factura A N°: 0001-00008803',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL);
INSERT INTO `cta_cte_cliente` VALUES (1036,3598,3,40720,40725,57,1532,1,0,'2021-05-19',3134.83,'Nota de crédito A N°: 0003-00004101',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1037,3598,3,40720,40722,57,1532,1,0,'2021-05-21',2812.97,'Nota de crédito A N°: 0007-00006075',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1038,3598,3,40720,40722,57,1532,2,0,'2021-05-21',16071.57,'Factura A N°: 0007-00017903',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1039,3598,3,40720,40724,57,1532,2,0,'2021-05-22',127603.65,'Factura A N°: 0001-00008845',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1040,3598,3,40720,40724,57,1532,2,0,'2021-05-22',25962.37,'Factura A N°: 0001-00008846',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1041,3598,3,40720,40815,57,1532,2,0,'2021-05-22',3600.00,'Factura C N°: 0002-00000133',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1042,3598,3,40720,40722,57,1532,1,0,'2021-05-22',4249.99,'Nota de crédito A N°: 0007-00006084',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1043,3598,3,40720,40723,57,1532,2,0,'2021-05-22',61218.87,'Factura A N°: 0001-00000855',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1044,3598,3,40720,40816,57,1532,2,0,'2021-05-22',8500.00,'Factura C N°: 0002-00000076',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1045,3598,3,40720,40721,57,1532,1,0,'2021-05-26',1269.53,'Nota de crédito A N°: 0008-00003216',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1046,3598,3,40720,40721,57,1532,2,0,'2021-05-26',30703.39,'Factura A N°: 0008-00027483',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1047,3598,3,40720,40722,57,1532,2,0,'2021-05-26',81306.63,'Factura A N°: 0007-00017930',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1048,3598,3,40720,40817,57,1532,2,0,'2021-05-27',1500.00,'Factura C N°: 0001-00000032',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1049,3598,3,40720,40722,57,1532,2,0,'2021-05-28',63665.24,'Factura A N°: 0007-00017968',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1050,3598,3,40720,40722,57,1532,1,0,'2021-05-28',642.86,'Nota de crédito A N°: 0007-00006095',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1051,3598,3,40720,40811,57,1532,2,0,'2021-05-31',24629.92,'Factura A N°: 0002-00023279',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL),(1052,3598,3,40720,40811,57,1532,1,0,'2021-05-31',24629.79,'Nota de crédito B N°: 0002-00000477',NULL,'2021-06-16 14:51:18','2021-06-16 14:51:18',NULL);
/*!40000 ALTER TABLE `cta_cte_cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_details`
--

DROP TABLE IF EXISTS `cta_cte_cliente_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_details_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_cliente_details_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_details_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_details_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_details_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_cliente_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_details`
--

LOCK TABLES `cta_cte_cliente_details` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_cliente_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente_pivot_receipt`
--

DROP TABLE IF EXISTS `cta_cte_cliente_pivot_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente_pivot_receipt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1053 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente_pivot_receipt`
--

LOCK TABLES `cta_cte_cliente_pivot_receipt` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (4,NULL,4,4,NULL,NULL,NULL,NULL),(5,NULL,5,5,NULL,NULL,NULL,NULL),(6,NULL,6,6,NULL,NULL,NULL,NULL),(10,NULL,10,10,NULL,NULL,NULL,NULL),(12,NULL,12,12,NULL,NULL,NULL,NULL),(13,NULL,13,13,NULL,NULL,NULL,NULL),(17,NULL,17,17,NULL,NULL,NULL,NULL),(18,NULL,18,18,NULL,NULL,NULL,NULL),(19,NULL,19,19,NULL,NULL,NULL,NULL),(22,NULL,22,22,NULL,NULL,NULL,NULL),(23,NULL,23,23,NULL,NULL,NULL,NULL),(24,NULL,24,24,NULL,NULL,NULL,NULL),(26,NULL,26,26,NULL,NULL,NULL,NULL),(27,NULL,27,27,NULL,NULL,NULL,NULL),(30,NULL,30,30,NULL,NULL,NULL,NULL),(31,NULL,31,31,NULL,NULL,NULL,NULL),(32,NULL,32,32,NULL,NULL,NULL,NULL),(33,NULL,33,33,NULL,NULL,NULL,NULL),(34,NULL,34,34,NULL,NULL,NULL,NULL),(35,NULL,35,35,NULL,NULL,NULL,NULL),(36,NULL,36,36,NULL,NULL,NULL,NULL),(37,NULL,37,37,NULL,NULL,NULL,NULL),(38,NULL,38,38,NULL,NULL,NULL,NULL),(39,NULL,39,39,NULL,NULL,NULL,NULL),(40,NULL,40,40,NULL,NULL,NULL,NULL),(41,NULL,41,41,NULL,NULL,NULL,NULL),(42,NULL,42,42,NULL,NULL,NULL,NULL),(43,NULL,43,43,NULL,NULL,NULL,NULL),(44,NULL,44,44,NULL,NULL,NULL,NULL),(45,NULL,45,45,NULL,NULL,NULL,NULL),(46,NULL,46,46,NULL,NULL,NULL,NULL),(47,NULL,47,47,NULL,NULL,NULL,NULL),(48,NULL,48,48,NULL,NULL,NULL,NULL),(49,NULL,49,49,NULL,NULL,NULL,NULL),(50,NULL,50,50,NULL,NULL,NULL,NULL),(51,NULL,51,51,NULL,NULL,NULL,NULL),(52,NULL,52,52,NULL,NULL,NULL,NULL),(53,NULL,53,53,NULL,NULL,NULL,NULL),(54,NULL,54,54,NULL,NULL,NULL,NULL),(55,NULL,55,55,NULL,NULL,NULL,NULL),(56,NULL,56,56,NULL,NULL,NULL,NULL),(57,NULL,57,57,NULL,NULL,NULL,NULL),(58,NULL,58,58,NULL,NULL,NULL,NULL),(59,NULL,59,59,NULL,NULL,NULL,NULL),(60,NULL,60,60,NULL,NULL,NULL,NULL),(61,NULL,61,61,NULL,NULL,NULL,NULL),(62,NULL,62,62,NULL,NULL,NULL,NULL),(63,NULL,63,63,NULL,NULL,NULL,NULL),(64,NULL,64,64,NULL,NULL,NULL,NULL),(65,NULL,65,65,NULL,NULL,NULL,NULL),(66,NULL,66,66,NULL,NULL,NULL,NULL),(67,NULL,67,67,NULL,NULL,NULL,NULL),(68,NULL,68,68,NULL,NULL,NULL,NULL),(69,NULL,69,69,NULL,NULL,NULL,NULL),(70,NULL,70,70,NULL,NULL,NULL,NULL),(71,NULL,71,71,NULL,NULL,NULL,NULL),(72,NULL,72,72,NULL,NULL,NULL,NULL),(73,NULL,73,73,NULL,NULL,NULL,NULL),(74,NULL,74,74,NULL,NULL,NULL,NULL),(75,NULL,75,75,NULL,NULL,NULL,NULL),(76,NULL,76,76,NULL,NULL,NULL,NULL),(77,NULL,77,77,NULL,NULL,NULL,NULL),(78,NULL,78,78,NULL,NULL,NULL,NULL),(79,NULL,79,79,NULL,NULL,NULL,NULL),(80,NULL,80,80,NULL,NULL,NULL,NULL),(81,NULL,81,81,NULL,NULL,NULL,NULL),(82,NULL,82,82,NULL,NULL,NULL,NULL),(83,NULL,83,83,NULL,NULL,NULL,NULL),(84,NULL,84,84,NULL,NULL,NULL,NULL),(85,NULL,85,85,NULL,NULL,NULL,NULL),(86,NULL,86,86,NULL,NULL,NULL,NULL),(87,NULL,87,87,NULL,NULL,NULL,NULL),(88,NULL,88,88,NULL,NULL,NULL,NULL),(89,NULL,89,89,NULL,NULL,NULL,NULL),(90,NULL,90,90,NULL,NULL,NULL,NULL),(91,NULL,91,91,NULL,NULL,NULL,NULL),(92,NULL,92,92,NULL,NULL,NULL,NULL),(93,NULL,93,93,NULL,NULL,NULL,NULL),(94,NULL,94,94,NULL,NULL,NULL,NULL),(95,NULL,95,95,NULL,NULL,NULL,NULL),(96,NULL,96,96,NULL,NULL,NULL,NULL),(97,NULL,97,97,NULL,NULL,NULL,NULL),(98,NULL,98,98,NULL,NULL,NULL,NULL),(99,NULL,99,99,NULL,NULL,NULL,NULL),(100,NULL,100,100,NULL,NULL,NULL,NULL),(101,NULL,101,101,NULL,NULL,NULL,NULL),(102,NULL,102,102,NULL,NULL,NULL,NULL),(103,NULL,103,103,NULL,NULL,NULL,NULL),(104,NULL,104,104,NULL,NULL,NULL,NULL),(105,NULL,105,105,NULL,NULL,NULL,NULL),(106,NULL,106,106,NULL,NULL,NULL,NULL),(107,NULL,107,107,NULL,NULL,NULL,NULL),(108,NULL,108,108,NULL,NULL,NULL,NULL),(109,NULL,109,109,NULL,NULL,NULL,NULL),(110,NULL,110,110,NULL,NULL,NULL,NULL),(111,NULL,111,111,NULL,NULL,NULL,NULL),(112,NULL,112,112,NULL,NULL,NULL,NULL),(113,NULL,113,113,NULL,NULL,NULL,NULL),(114,NULL,114,114,NULL,NULL,NULL,NULL),(115,NULL,115,115,NULL,NULL,NULL,NULL),(116,NULL,116,116,NULL,NULL,NULL,NULL),(117,NULL,117,117,NULL,NULL,NULL,NULL),(118,NULL,118,118,NULL,NULL,NULL,NULL),(119,NULL,119,119,NULL,NULL,NULL,NULL),(120,NULL,120,120,NULL,NULL,NULL,NULL),(121,NULL,121,121,NULL,NULL,NULL,NULL),(122,NULL,122,122,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (123,NULL,123,123,NULL,NULL,NULL,NULL),(124,NULL,124,124,NULL,NULL,NULL,NULL),(125,NULL,125,125,NULL,NULL,NULL,NULL),(126,NULL,126,126,NULL,NULL,NULL,NULL),(127,NULL,127,127,NULL,NULL,NULL,NULL),(128,NULL,128,128,NULL,NULL,NULL,NULL),(129,NULL,129,129,NULL,NULL,NULL,NULL),(130,NULL,130,130,NULL,NULL,NULL,NULL),(131,NULL,131,131,NULL,NULL,NULL,NULL),(132,NULL,132,132,NULL,NULL,NULL,NULL),(133,NULL,133,133,NULL,NULL,NULL,NULL),(134,NULL,134,134,NULL,NULL,NULL,NULL),(135,NULL,135,135,NULL,NULL,NULL,NULL),(136,NULL,136,136,NULL,NULL,NULL,NULL),(137,NULL,137,137,NULL,NULL,NULL,NULL),(138,NULL,138,138,NULL,NULL,NULL,NULL),(139,NULL,139,139,NULL,NULL,NULL,NULL),(140,NULL,140,140,NULL,NULL,NULL,NULL),(141,NULL,141,141,NULL,NULL,NULL,NULL),(142,NULL,142,142,NULL,NULL,NULL,NULL),(143,NULL,143,143,NULL,NULL,NULL,NULL),(144,NULL,144,144,NULL,NULL,NULL,NULL),(145,NULL,145,145,NULL,NULL,NULL,NULL),(146,NULL,146,146,NULL,NULL,NULL,NULL),(147,NULL,147,147,NULL,NULL,NULL,NULL),(148,NULL,148,148,NULL,NULL,NULL,NULL),(149,NULL,149,149,NULL,NULL,NULL,NULL),(150,NULL,150,150,NULL,NULL,NULL,NULL),(151,NULL,151,151,NULL,NULL,NULL,NULL),(152,NULL,152,152,NULL,NULL,NULL,NULL),(153,NULL,153,153,NULL,NULL,NULL,NULL),(154,NULL,154,154,NULL,NULL,NULL,NULL),(155,NULL,155,155,NULL,NULL,NULL,NULL),(156,NULL,156,156,NULL,NULL,NULL,NULL),(157,NULL,157,157,NULL,NULL,NULL,NULL),(158,NULL,158,158,NULL,NULL,NULL,NULL),(159,NULL,159,159,NULL,NULL,NULL,NULL),(160,NULL,160,160,NULL,NULL,NULL,NULL),(161,NULL,161,161,NULL,NULL,NULL,NULL),(162,NULL,162,162,NULL,NULL,NULL,NULL),(163,NULL,163,163,NULL,NULL,NULL,NULL),(164,NULL,164,164,NULL,NULL,NULL,NULL),(165,NULL,165,165,NULL,NULL,NULL,NULL),(166,NULL,166,166,NULL,NULL,NULL,NULL),(167,NULL,167,167,NULL,NULL,NULL,NULL),(168,NULL,168,168,NULL,NULL,NULL,NULL),(169,NULL,169,169,NULL,NULL,NULL,NULL),(170,NULL,170,170,NULL,NULL,NULL,NULL),(171,NULL,171,171,NULL,NULL,NULL,NULL),(172,NULL,172,172,NULL,NULL,NULL,NULL),(173,NULL,173,173,NULL,NULL,NULL,NULL),(174,NULL,174,174,NULL,NULL,NULL,NULL),(175,NULL,175,175,NULL,NULL,NULL,NULL),(176,NULL,176,176,NULL,NULL,NULL,NULL),(177,NULL,177,177,NULL,NULL,NULL,NULL),(178,NULL,178,178,NULL,NULL,NULL,NULL),(179,NULL,179,179,NULL,NULL,NULL,NULL),(180,NULL,180,180,NULL,NULL,NULL,NULL),(181,NULL,181,181,NULL,NULL,NULL,NULL),(182,NULL,182,182,NULL,NULL,NULL,NULL),(183,NULL,183,183,NULL,NULL,NULL,NULL),(184,NULL,184,184,NULL,NULL,NULL,NULL),(185,NULL,185,185,NULL,NULL,NULL,NULL),(186,NULL,186,186,NULL,NULL,NULL,NULL),(187,NULL,187,187,NULL,NULL,NULL,NULL),(188,NULL,188,188,NULL,NULL,NULL,NULL),(189,NULL,189,189,NULL,NULL,NULL,NULL),(190,NULL,190,190,NULL,NULL,NULL,NULL),(191,NULL,191,191,NULL,NULL,NULL,NULL),(192,NULL,192,192,NULL,NULL,NULL,NULL),(193,NULL,193,193,NULL,NULL,NULL,NULL),(194,NULL,194,194,NULL,NULL,NULL,NULL),(195,NULL,195,195,NULL,NULL,NULL,NULL),(196,NULL,196,196,NULL,NULL,NULL,NULL),(197,NULL,197,197,NULL,NULL,NULL,NULL),(198,NULL,198,198,NULL,NULL,NULL,NULL),(199,NULL,199,199,NULL,NULL,NULL,NULL),(200,NULL,200,200,NULL,NULL,NULL,NULL),(201,NULL,201,201,NULL,NULL,NULL,NULL),(202,NULL,202,202,NULL,NULL,NULL,NULL),(203,NULL,203,203,NULL,NULL,NULL,NULL),(204,NULL,204,204,NULL,NULL,NULL,NULL),(205,NULL,205,205,NULL,NULL,NULL,NULL),(206,NULL,206,206,NULL,NULL,NULL,NULL),(207,NULL,207,207,NULL,NULL,NULL,NULL),(208,NULL,208,208,NULL,NULL,NULL,NULL),(209,NULL,209,209,NULL,NULL,NULL,NULL),(210,NULL,210,210,NULL,NULL,NULL,NULL),(211,NULL,211,211,NULL,NULL,NULL,NULL),(212,NULL,212,212,NULL,NULL,NULL,NULL),(213,NULL,213,213,NULL,NULL,NULL,NULL),(214,NULL,214,214,NULL,NULL,NULL,NULL),(215,NULL,215,215,NULL,NULL,NULL,NULL),(216,NULL,216,216,NULL,NULL,NULL,NULL),(217,NULL,217,217,NULL,NULL,NULL,NULL),(218,NULL,218,218,NULL,NULL,NULL,NULL),(219,NULL,219,219,NULL,NULL,NULL,NULL),(220,NULL,220,220,NULL,NULL,NULL,NULL),(221,NULL,221,221,NULL,NULL,NULL,NULL),(222,NULL,222,222,NULL,NULL,NULL,NULL),(223,NULL,223,223,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (224,NULL,224,224,NULL,NULL,NULL,NULL),(225,NULL,225,225,NULL,NULL,NULL,NULL),(226,NULL,226,226,NULL,NULL,NULL,NULL),(227,NULL,227,227,NULL,NULL,NULL,NULL),(228,NULL,228,228,NULL,NULL,NULL,NULL),(229,NULL,229,229,NULL,NULL,NULL,NULL),(230,NULL,230,230,NULL,NULL,NULL,NULL),(231,NULL,231,231,NULL,NULL,NULL,NULL),(232,NULL,232,232,NULL,NULL,NULL,NULL),(233,NULL,233,233,NULL,NULL,NULL,NULL),(234,NULL,234,234,NULL,NULL,NULL,NULL),(235,NULL,235,235,NULL,NULL,NULL,NULL),(236,NULL,236,236,NULL,NULL,NULL,NULL),(237,NULL,237,237,NULL,NULL,NULL,NULL),(238,NULL,238,238,NULL,NULL,NULL,NULL),(239,NULL,239,239,NULL,NULL,NULL,NULL),(240,NULL,240,240,NULL,NULL,NULL,NULL),(241,NULL,241,241,NULL,NULL,NULL,NULL),(242,NULL,242,242,NULL,NULL,NULL,NULL),(243,NULL,243,243,NULL,NULL,NULL,NULL),(244,NULL,244,244,NULL,NULL,NULL,NULL),(245,NULL,245,245,NULL,NULL,NULL,NULL),(246,NULL,246,246,NULL,NULL,NULL,NULL),(247,NULL,247,247,NULL,NULL,NULL,NULL),(248,NULL,248,248,NULL,NULL,NULL,NULL),(249,NULL,249,249,NULL,NULL,NULL,NULL),(250,NULL,250,250,NULL,NULL,NULL,NULL),(251,NULL,251,251,NULL,NULL,NULL,NULL),(252,NULL,252,252,NULL,NULL,NULL,NULL),(253,NULL,253,253,NULL,NULL,NULL,NULL),(254,NULL,254,254,NULL,NULL,NULL,NULL),(255,NULL,255,255,NULL,NULL,NULL,NULL),(256,NULL,256,256,NULL,NULL,NULL,NULL),(257,NULL,257,257,NULL,NULL,NULL,NULL),(258,NULL,258,258,NULL,NULL,NULL,NULL),(259,NULL,259,259,NULL,NULL,NULL,NULL),(260,NULL,260,260,NULL,NULL,NULL,NULL),(261,NULL,261,261,NULL,NULL,NULL,NULL),(262,NULL,262,262,NULL,NULL,NULL,NULL),(263,NULL,263,263,NULL,NULL,NULL,NULL),(264,NULL,264,264,NULL,NULL,NULL,NULL),(265,NULL,265,265,NULL,NULL,NULL,NULL),(266,NULL,266,266,NULL,NULL,NULL,NULL),(267,NULL,267,267,NULL,NULL,NULL,NULL),(268,NULL,268,268,NULL,NULL,NULL,NULL),(269,NULL,269,269,NULL,NULL,NULL,NULL),(270,NULL,270,270,NULL,NULL,NULL,NULL),(271,NULL,271,271,NULL,NULL,NULL,NULL),(272,NULL,272,272,NULL,NULL,NULL,NULL),(273,NULL,273,273,NULL,NULL,NULL,NULL),(274,NULL,274,274,NULL,NULL,NULL,NULL),(275,NULL,275,275,NULL,NULL,NULL,NULL),(276,NULL,276,276,NULL,NULL,NULL,NULL),(277,NULL,277,277,NULL,NULL,NULL,NULL),(278,NULL,278,278,NULL,NULL,NULL,NULL),(279,NULL,279,279,NULL,NULL,NULL,NULL),(280,NULL,280,280,NULL,NULL,NULL,NULL),(281,NULL,281,281,NULL,NULL,NULL,NULL),(282,NULL,282,282,NULL,NULL,NULL,NULL),(283,NULL,283,283,NULL,NULL,NULL,NULL),(284,NULL,284,284,NULL,NULL,NULL,NULL),(285,NULL,285,285,NULL,NULL,NULL,NULL),(286,NULL,286,286,NULL,NULL,NULL,NULL),(287,NULL,287,287,NULL,NULL,NULL,NULL),(288,NULL,288,288,NULL,NULL,NULL,NULL),(289,NULL,289,289,NULL,NULL,NULL,NULL),(290,NULL,290,290,NULL,NULL,NULL,NULL),(291,NULL,291,291,NULL,NULL,NULL,NULL),(292,NULL,292,292,NULL,NULL,NULL,NULL),(293,NULL,293,293,NULL,NULL,NULL,NULL),(294,NULL,294,294,NULL,NULL,NULL,NULL),(295,NULL,295,295,NULL,NULL,NULL,NULL),(296,NULL,296,296,NULL,NULL,NULL,NULL),(297,NULL,297,297,NULL,NULL,NULL,NULL),(298,NULL,298,298,NULL,NULL,NULL,NULL),(299,NULL,299,299,NULL,NULL,NULL,NULL),(300,NULL,300,300,NULL,NULL,NULL,NULL),(301,NULL,301,301,NULL,NULL,NULL,NULL),(302,NULL,302,302,NULL,NULL,NULL,NULL),(303,NULL,303,303,NULL,NULL,NULL,NULL),(304,NULL,304,304,NULL,NULL,NULL,NULL),(305,NULL,305,305,NULL,NULL,NULL,NULL),(306,NULL,306,306,NULL,NULL,NULL,NULL),(307,NULL,307,307,NULL,NULL,NULL,NULL),(308,NULL,308,308,NULL,NULL,NULL,NULL),(309,NULL,309,309,NULL,NULL,NULL,NULL),(310,NULL,310,310,NULL,NULL,NULL,NULL),(311,NULL,311,311,NULL,NULL,NULL,NULL),(312,NULL,312,312,NULL,NULL,NULL,NULL),(313,NULL,313,313,NULL,NULL,NULL,NULL),(314,NULL,314,314,NULL,NULL,NULL,NULL),(315,NULL,315,315,NULL,NULL,NULL,NULL),(316,NULL,316,316,NULL,NULL,NULL,NULL),(317,NULL,317,317,NULL,NULL,NULL,NULL),(318,NULL,318,318,NULL,NULL,NULL,NULL),(319,NULL,319,319,NULL,NULL,NULL,NULL),(320,NULL,320,320,NULL,NULL,NULL,NULL),(321,NULL,321,321,NULL,NULL,NULL,NULL),(322,NULL,322,322,NULL,NULL,NULL,NULL),(323,NULL,323,323,NULL,NULL,NULL,NULL),(324,NULL,324,324,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (325,NULL,325,325,NULL,NULL,NULL,NULL),(326,NULL,326,326,NULL,NULL,NULL,NULL),(327,NULL,327,327,NULL,NULL,NULL,NULL),(328,NULL,328,328,NULL,NULL,NULL,NULL),(329,NULL,329,329,NULL,NULL,NULL,NULL),(330,NULL,330,330,NULL,NULL,NULL,NULL),(331,NULL,331,331,NULL,NULL,NULL,NULL),(332,NULL,332,332,NULL,NULL,NULL,NULL),(333,NULL,333,333,NULL,NULL,NULL,NULL),(334,NULL,334,334,NULL,NULL,NULL,NULL),(335,NULL,335,335,NULL,NULL,NULL,NULL),(336,NULL,336,336,NULL,NULL,NULL,NULL),(337,NULL,337,337,NULL,NULL,NULL,NULL),(338,NULL,338,338,NULL,NULL,NULL,NULL),(339,NULL,339,339,NULL,NULL,NULL,NULL),(340,NULL,340,340,NULL,NULL,NULL,NULL),(341,NULL,341,341,NULL,NULL,NULL,NULL),(342,NULL,342,342,NULL,NULL,NULL,NULL),(343,NULL,343,343,NULL,NULL,NULL,NULL),(344,NULL,344,344,NULL,NULL,NULL,NULL),(345,NULL,345,345,NULL,NULL,NULL,NULL),(346,NULL,346,346,NULL,NULL,NULL,NULL),(347,NULL,347,347,NULL,NULL,NULL,NULL),(348,NULL,348,348,NULL,NULL,NULL,NULL),(349,NULL,349,349,NULL,NULL,NULL,NULL),(350,NULL,350,350,NULL,NULL,NULL,NULL),(351,NULL,351,351,NULL,NULL,NULL,NULL),(352,NULL,352,352,NULL,NULL,NULL,NULL),(353,NULL,353,353,NULL,NULL,NULL,NULL),(354,NULL,354,354,NULL,NULL,NULL,NULL),(355,NULL,355,355,NULL,NULL,NULL,NULL),(356,NULL,356,356,NULL,NULL,NULL,NULL),(357,NULL,357,357,NULL,NULL,NULL,NULL),(358,NULL,358,358,NULL,NULL,NULL,NULL),(359,NULL,359,359,NULL,NULL,NULL,NULL),(360,NULL,360,360,NULL,NULL,NULL,NULL),(361,NULL,361,361,NULL,NULL,NULL,NULL),(362,NULL,362,362,NULL,NULL,NULL,NULL),(363,NULL,363,363,NULL,NULL,NULL,NULL),(364,NULL,364,364,NULL,NULL,NULL,NULL),(365,NULL,365,365,NULL,NULL,NULL,NULL),(366,NULL,366,366,NULL,NULL,NULL,NULL),(367,NULL,367,367,NULL,NULL,NULL,NULL),(368,NULL,368,368,NULL,NULL,NULL,NULL),(369,NULL,369,369,NULL,NULL,NULL,NULL),(370,NULL,370,370,NULL,NULL,NULL,NULL),(371,NULL,371,371,NULL,NULL,NULL,NULL),(372,NULL,372,372,NULL,NULL,NULL,NULL),(373,NULL,373,373,NULL,NULL,NULL,NULL),(374,NULL,374,374,NULL,NULL,NULL,NULL),(375,NULL,375,375,NULL,NULL,NULL,NULL),(376,NULL,376,376,NULL,NULL,NULL,NULL),(377,NULL,377,377,NULL,NULL,NULL,NULL),(378,NULL,378,378,NULL,NULL,NULL,NULL),(379,NULL,379,379,NULL,NULL,NULL,NULL),(380,NULL,380,380,NULL,NULL,NULL,NULL),(381,NULL,381,381,NULL,NULL,NULL,NULL),(382,NULL,382,382,NULL,NULL,NULL,NULL),(383,NULL,383,383,NULL,NULL,NULL,NULL),(384,NULL,384,384,NULL,NULL,NULL,NULL),(385,NULL,385,385,NULL,NULL,NULL,NULL),(386,NULL,386,386,NULL,NULL,NULL,NULL),(387,NULL,387,387,NULL,NULL,NULL,NULL),(388,NULL,388,388,NULL,NULL,NULL,NULL),(389,NULL,389,389,NULL,NULL,NULL,NULL),(390,NULL,390,390,NULL,NULL,NULL,NULL),(391,NULL,391,391,NULL,NULL,NULL,NULL),(392,NULL,392,392,NULL,NULL,NULL,NULL),(393,NULL,393,393,NULL,NULL,NULL,NULL),(394,NULL,394,394,NULL,NULL,NULL,NULL),(395,NULL,395,395,NULL,NULL,NULL,NULL),(396,NULL,396,396,NULL,NULL,NULL,NULL),(397,NULL,397,397,NULL,NULL,NULL,NULL),(398,NULL,398,398,NULL,NULL,NULL,NULL),(399,NULL,399,399,NULL,NULL,NULL,NULL),(400,NULL,400,400,NULL,NULL,NULL,NULL),(401,NULL,401,401,NULL,NULL,NULL,NULL),(402,NULL,402,402,NULL,NULL,NULL,NULL),(403,NULL,403,403,NULL,NULL,NULL,NULL),(404,NULL,404,404,NULL,NULL,NULL,NULL),(405,NULL,405,405,NULL,NULL,NULL,NULL),(406,NULL,406,406,NULL,NULL,NULL,NULL),(407,NULL,407,407,NULL,NULL,NULL,NULL),(408,NULL,408,408,NULL,NULL,NULL,NULL),(409,NULL,409,409,NULL,NULL,NULL,NULL),(410,NULL,410,410,NULL,NULL,NULL,NULL),(411,NULL,411,411,NULL,NULL,NULL,NULL),(412,NULL,412,412,NULL,NULL,NULL,NULL),(413,NULL,413,413,NULL,NULL,NULL,NULL),(414,NULL,414,414,NULL,NULL,NULL,NULL),(415,NULL,415,415,NULL,NULL,NULL,NULL),(416,NULL,416,416,NULL,NULL,NULL,NULL),(417,NULL,417,417,NULL,NULL,NULL,NULL),(418,NULL,418,418,NULL,NULL,NULL,NULL),(419,NULL,419,419,NULL,NULL,NULL,NULL),(420,NULL,420,420,NULL,NULL,NULL,NULL),(421,NULL,421,421,NULL,NULL,NULL,NULL),(422,NULL,422,422,NULL,NULL,NULL,NULL),(423,NULL,423,423,NULL,NULL,NULL,NULL),(424,NULL,424,424,NULL,NULL,NULL,NULL),(425,NULL,425,425,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (426,NULL,426,426,NULL,NULL,NULL,NULL),(427,NULL,427,427,NULL,NULL,NULL,NULL),(428,NULL,428,428,NULL,NULL,NULL,NULL),(429,NULL,429,429,NULL,NULL,NULL,NULL),(430,NULL,430,430,NULL,NULL,NULL,NULL),(431,NULL,431,431,NULL,NULL,NULL,NULL),(432,NULL,432,432,NULL,NULL,NULL,NULL),(433,NULL,433,433,NULL,NULL,NULL,NULL),(434,NULL,434,434,NULL,NULL,NULL,NULL),(435,NULL,435,435,NULL,NULL,NULL,NULL),(436,NULL,436,436,NULL,NULL,NULL,NULL),(437,NULL,437,437,NULL,NULL,NULL,NULL),(438,NULL,438,438,NULL,NULL,NULL,NULL),(439,NULL,439,439,NULL,NULL,NULL,NULL),(440,NULL,440,440,NULL,NULL,NULL,NULL),(441,NULL,441,441,NULL,NULL,NULL,NULL),(442,NULL,442,442,NULL,NULL,NULL,NULL),(443,NULL,443,443,NULL,NULL,NULL,NULL),(444,NULL,444,444,NULL,NULL,NULL,NULL),(445,NULL,445,445,NULL,NULL,NULL,NULL),(446,NULL,446,446,NULL,NULL,NULL,NULL),(447,NULL,447,447,NULL,NULL,NULL,NULL),(448,NULL,448,448,NULL,NULL,NULL,NULL),(449,NULL,449,449,NULL,NULL,NULL,NULL),(450,NULL,450,450,NULL,NULL,NULL,NULL),(451,NULL,451,451,NULL,NULL,NULL,NULL),(452,NULL,452,452,NULL,NULL,NULL,NULL),(453,NULL,453,453,NULL,NULL,NULL,NULL),(454,NULL,454,454,NULL,NULL,NULL,NULL),(455,NULL,455,455,NULL,NULL,NULL,NULL),(456,NULL,456,456,NULL,NULL,NULL,NULL),(457,NULL,457,457,NULL,NULL,NULL,NULL),(458,NULL,458,458,NULL,NULL,NULL,NULL),(459,NULL,459,459,NULL,NULL,NULL,NULL),(460,NULL,460,460,NULL,NULL,NULL,NULL),(461,NULL,461,461,NULL,NULL,NULL,NULL),(462,NULL,462,462,NULL,NULL,NULL,NULL),(463,NULL,463,463,NULL,NULL,NULL,NULL),(464,NULL,464,464,NULL,NULL,NULL,NULL),(465,NULL,465,465,NULL,NULL,NULL,NULL),(466,NULL,466,466,NULL,NULL,NULL,NULL),(467,NULL,467,467,NULL,NULL,NULL,NULL),(468,NULL,468,468,NULL,NULL,NULL,NULL),(469,NULL,469,469,NULL,NULL,NULL,NULL),(470,NULL,470,470,NULL,NULL,NULL,NULL),(471,NULL,471,471,NULL,NULL,NULL,NULL),(472,NULL,472,472,NULL,NULL,NULL,NULL),(473,NULL,473,473,NULL,NULL,NULL,NULL),(474,NULL,474,474,NULL,NULL,NULL,NULL),(475,NULL,475,475,NULL,NULL,NULL,NULL),(476,NULL,476,476,NULL,NULL,NULL,NULL),(477,NULL,477,477,NULL,NULL,NULL,NULL),(478,NULL,478,478,NULL,NULL,NULL,NULL),(479,NULL,479,479,NULL,NULL,NULL,NULL),(480,NULL,480,480,NULL,NULL,NULL,NULL),(481,NULL,481,481,NULL,NULL,NULL,NULL),(482,NULL,482,482,NULL,NULL,NULL,NULL),(483,NULL,483,483,NULL,NULL,NULL,NULL),(484,NULL,484,484,NULL,NULL,NULL,NULL),(485,NULL,485,485,NULL,NULL,NULL,NULL),(486,NULL,486,486,NULL,NULL,NULL,NULL),(487,NULL,487,487,NULL,NULL,NULL,NULL),(488,NULL,488,488,NULL,NULL,NULL,NULL),(489,NULL,489,489,NULL,NULL,NULL,NULL),(490,NULL,490,490,NULL,NULL,NULL,NULL),(491,NULL,491,491,NULL,NULL,NULL,NULL),(492,NULL,492,492,NULL,NULL,NULL,NULL),(493,NULL,493,493,NULL,NULL,NULL,NULL),(494,NULL,494,494,NULL,NULL,NULL,NULL),(495,NULL,495,495,NULL,NULL,NULL,NULL),(496,NULL,496,496,NULL,NULL,NULL,NULL),(497,NULL,497,497,NULL,NULL,NULL,NULL),(498,NULL,498,498,NULL,NULL,NULL,NULL),(499,NULL,499,499,NULL,NULL,NULL,NULL),(500,NULL,500,500,NULL,NULL,NULL,NULL),(501,NULL,501,501,NULL,NULL,NULL,NULL),(502,NULL,502,502,NULL,NULL,NULL,NULL),(503,NULL,503,503,NULL,NULL,NULL,NULL),(504,NULL,504,504,NULL,NULL,NULL,NULL),(505,NULL,505,505,NULL,NULL,NULL,NULL),(506,NULL,506,506,NULL,NULL,NULL,NULL),(507,NULL,507,507,NULL,NULL,NULL,NULL),(508,NULL,508,508,NULL,NULL,NULL,NULL),(509,NULL,509,509,NULL,NULL,NULL,NULL),(510,NULL,510,510,NULL,NULL,NULL,NULL),(511,NULL,511,511,NULL,NULL,NULL,NULL),(512,NULL,512,512,NULL,NULL,NULL,NULL),(513,NULL,513,513,NULL,NULL,NULL,NULL),(514,NULL,514,514,NULL,NULL,NULL,NULL),(515,NULL,515,515,NULL,NULL,NULL,NULL),(516,NULL,516,516,NULL,NULL,NULL,NULL),(517,NULL,517,517,NULL,NULL,NULL,NULL),(518,NULL,518,518,NULL,NULL,NULL,NULL),(519,NULL,519,519,NULL,NULL,NULL,NULL),(520,NULL,520,520,NULL,NULL,NULL,NULL),(521,NULL,521,521,NULL,NULL,NULL,NULL),(522,NULL,522,522,NULL,NULL,NULL,NULL),(523,NULL,523,523,NULL,NULL,NULL,NULL),(524,NULL,524,524,NULL,NULL,NULL,NULL),(525,NULL,525,525,NULL,NULL,NULL,NULL),(526,NULL,526,526,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (527,NULL,527,527,NULL,NULL,NULL,NULL),(528,NULL,528,528,NULL,NULL,NULL,NULL),(529,NULL,529,529,NULL,NULL,NULL,NULL),(530,NULL,530,530,NULL,NULL,NULL,NULL),(531,NULL,531,531,NULL,NULL,NULL,NULL),(532,NULL,532,532,NULL,NULL,NULL,NULL),(533,NULL,533,533,NULL,NULL,NULL,NULL),(534,NULL,534,534,NULL,NULL,NULL,NULL),(535,NULL,535,535,NULL,NULL,NULL,NULL),(536,NULL,536,536,NULL,NULL,NULL,NULL),(537,NULL,537,537,NULL,NULL,NULL,NULL),(538,NULL,538,538,NULL,NULL,NULL,NULL),(539,NULL,539,539,NULL,NULL,NULL,NULL),(540,NULL,540,540,NULL,NULL,NULL,NULL),(541,NULL,541,541,NULL,NULL,NULL,NULL),(542,NULL,542,542,NULL,NULL,NULL,NULL),(543,NULL,543,543,NULL,NULL,NULL,NULL),(544,NULL,544,544,NULL,NULL,NULL,NULL),(545,NULL,545,545,NULL,NULL,NULL,NULL),(546,NULL,546,546,NULL,NULL,NULL,NULL),(547,NULL,547,547,NULL,NULL,NULL,NULL),(548,NULL,548,548,NULL,NULL,NULL,NULL),(549,NULL,549,549,NULL,NULL,NULL,NULL),(550,NULL,550,550,NULL,NULL,NULL,NULL),(551,NULL,551,551,NULL,NULL,NULL,NULL),(552,NULL,552,552,NULL,NULL,NULL,NULL),(553,NULL,553,553,NULL,NULL,NULL,NULL),(554,NULL,554,554,NULL,NULL,NULL,NULL),(555,NULL,555,555,NULL,NULL,NULL,NULL),(556,NULL,556,556,NULL,NULL,NULL,NULL),(557,NULL,557,557,NULL,NULL,NULL,NULL),(558,NULL,558,558,NULL,NULL,NULL,NULL),(559,NULL,559,559,NULL,NULL,NULL,NULL),(560,NULL,560,560,NULL,NULL,NULL,NULL),(561,NULL,561,561,NULL,NULL,NULL,NULL),(562,NULL,562,562,NULL,NULL,NULL,NULL),(563,NULL,563,563,NULL,NULL,NULL,NULL),(564,NULL,564,564,NULL,NULL,NULL,NULL),(565,NULL,565,565,NULL,NULL,NULL,NULL),(566,NULL,566,566,NULL,NULL,NULL,NULL),(567,NULL,567,567,NULL,NULL,NULL,NULL),(568,NULL,568,568,NULL,NULL,NULL,NULL),(569,NULL,569,569,NULL,NULL,NULL,NULL),(570,NULL,570,570,NULL,NULL,NULL,NULL),(571,NULL,571,571,NULL,NULL,NULL,NULL),(572,NULL,572,572,NULL,NULL,NULL,NULL),(573,NULL,573,573,NULL,NULL,NULL,NULL),(574,NULL,574,574,NULL,NULL,NULL,NULL),(575,NULL,575,575,NULL,NULL,NULL,NULL),(576,NULL,576,576,NULL,NULL,NULL,NULL),(577,NULL,577,577,NULL,NULL,NULL,NULL),(578,NULL,578,578,NULL,NULL,NULL,NULL),(579,NULL,579,579,NULL,NULL,NULL,NULL),(580,NULL,580,580,NULL,NULL,NULL,NULL),(581,NULL,581,581,NULL,NULL,NULL,NULL),(582,NULL,582,582,NULL,NULL,NULL,NULL),(583,NULL,583,583,NULL,NULL,NULL,NULL),(584,NULL,584,584,NULL,NULL,NULL,NULL),(585,NULL,585,585,NULL,NULL,NULL,NULL),(586,NULL,586,586,NULL,NULL,NULL,NULL),(587,NULL,587,587,NULL,NULL,NULL,NULL),(588,NULL,588,588,NULL,NULL,NULL,NULL),(589,NULL,589,589,NULL,NULL,NULL,NULL),(590,NULL,590,590,NULL,NULL,NULL,NULL),(591,NULL,591,591,NULL,NULL,NULL,NULL),(592,NULL,592,592,NULL,NULL,NULL,NULL),(593,NULL,593,593,NULL,NULL,NULL,NULL),(594,NULL,594,594,NULL,NULL,NULL,NULL),(595,NULL,595,595,NULL,NULL,NULL,NULL),(596,NULL,596,596,NULL,NULL,NULL,NULL),(597,NULL,597,597,NULL,NULL,NULL,NULL),(598,NULL,598,598,NULL,NULL,NULL,NULL),(599,NULL,599,599,NULL,NULL,NULL,NULL),(600,NULL,600,600,NULL,NULL,NULL,NULL),(601,NULL,601,601,NULL,NULL,NULL,NULL),(602,NULL,602,602,NULL,NULL,NULL,NULL),(603,NULL,603,603,NULL,NULL,NULL,NULL),(604,NULL,604,604,NULL,NULL,NULL,NULL),(605,NULL,605,605,NULL,NULL,NULL,NULL),(606,NULL,606,606,NULL,NULL,NULL,NULL),(607,NULL,607,607,NULL,NULL,NULL,NULL),(608,NULL,608,608,NULL,NULL,NULL,NULL),(609,NULL,609,609,NULL,NULL,NULL,NULL),(610,NULL,610,610,NULL,NULL,NULL,NULL),(611,NULL,611,611,NULL,NULL,NULL,NULL),(612,NULL,612,612,NULL,NULL,NULL,NULL),(613,NULL,613,613,NULL,NULL,NULL,NULL),(614,NULL,614,614,NULL,NULL,NULL,NULL),(615,NULL,615,615,NULL,NULL,NULL,NULL),(616,NULL,616,616,NULL,NULL,NULL,NULL),(617,NULL,617,617,NULL,NULL,NULL,NULL),(618,NULL,618,618,NULL,NULL,NULL,NULL),(619,NULL,619,619,NULL,NULL,NULL,NULL),(620,NULL,620,620,NULL,NULL,NULL,NULL),(621,NULL,621,621,NULL,NULL,NULL,NULL),(622,NULL,622,622,NULL,NULL,NULL,NULL),(623,NULL,623,623,NULL,NULL,NULL,NULL),(624,NULL,624,624,NULL,NULL,NULL,NULL),(625,NULL,625,625,NULL,NULL,NULL,NULL),(626,NULL,626,626,NULL,NULL,NULL,NULL),(627,NULL,627,627,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (628,NULL,628,628,NULL,NULL,NULL,NULL),(629,NULL,629,629,NULL,NULL,NULL,NULL),(630,NULL,630,630,NULL,NULL,NULL,NULL),(631,NULL,631,631,NULL,NULL,NULL,NULL),(632,NULL,632,632,NULL,NULL,NULL,NULL),(633,NULL,633,633,NULL,NULL,NULL,NULL),(634,NULL,634,634,NULL,NULL,NULL,NULL),(635,NULL,635,635,NULL,NULL,NULL,NULL),(668,NULL,668,668,NULL,NULL,NULL,NULL),(669,NULL,669,669,NULL,NULL,NULL,NULL),(670,NULL,670,670,NULL,NULL,NULL,NULL),(671,NULL,671,671,NULL,NULL,NULL,NULL),(672,NULL,672,672,NULL,NULL,NULL,NULL),(673,NULL,673,673,NULL,NULL,NULL,NULL),(674,NULL,674,674,NULL,NULL,NULL,NULL),(675,NULL,675,675,NULL,NULL,NULL,NULL),(676,NULL,676,676,NULL,NULL,NULL,NULL),(677,NULL,677,677,NULL,NULL,NULL,NULL),(678,NULL,678,678,NULL,NULL,NULL,NULL),(679,NULL,679,679,NULL,NULL,NULL,NULL),(680,NULL,680,680,NULL,NULL,NULL,NULL),(681,NULL,681,681,NULL,NULL,NULL,NULL),(682,NULL,682,682,NULL,NULL,NULL,NULL),(683,NULL,683,683,NULL,NULL,NULL,NULL),(684,NULL,684,684,NULL,NULL,NULL,NULL),(685,NULL,685,685,NULL,NULL,NULL,NULL),(686,NULL,686,686,NULL,NULL,NULL,NULL),(687,NULL,687,687,NULL,NULL,NULL,NULL),(688,NULL,688,688,NULL,NULL,NULL,NULL),(689,NULL,689,689,NULL,NULL,NULL,NULL),(690,NULL,690,690,NULL,NULL,NULL,NULL),(691,NULL,691,691,NULL,NULL,NULL,NULL),(692,NULL,692,692,NULL,NULL,NULL,NULL),(693,NULL,693,693,NULL,NULL,NULL,NULL),(694,NULL,694,694,NULL,NULL,NULL,NULL),(695,NULL,695,695,NULL,NULL,NULL,NULL),(696,NULL,696,696,NULL,NULL,NULL,NULL),(697,NULL,697,697,NULL,NULL,NULL,NULL),(698,NULL,698,698,NULL,NULL,NULL,NULL),(699,NULL,699,699,NULL,NULL,NULL,NULL),(700,NULL,700,700,NULL,NULL,NULL,NULL),(701,NULL,701,701,NULL,NULL,NULL,NULL),(702,NULL,702,702,NULL,NULL,NULL,NULL),(703,NULL,703,703,NULL,NULL,NULL,NULL),(704,NULL,704,704,NULL,NULL,NULL,NULL),(705,NULL,705,705,NULL,NULL,NULL,NULL),(706,NULL,706,706,NULL,NULL,NULL,NULL),(707,NULL,707,707,NULL,NULL,NULL,NULL),(708,NULL,708,708,NULL,NULL,NULL,NULL),(709,NULL,709,709,NULL,NULL,NULL,NULL),(710,NULL,710,710,NULL,NULL,NULL,NULL),(711,NULL,711,711,NULL,NULL,NULL,NULL),(712,NULL,712,712,NULL,NULL,NULL,NULL),(713,NULL,713,713,NULL,NULL,NULL,NULL),(714,NULL,714,714,NULL,NULL,NULL,NULL),(715,NULL,715,715,NULL,NULL,NULL,NULL),(716,NULL,716,716,NULL,NULL,NULL,NULL),(717,NULL,717,717,NULL,NULL,NULL,NULL),(718,NULL,718,718,NULL,NULL,NULL,NULL),(719,NULL,719,719,NULL,NULL,NULL,NULL),(720,NULL,720,720,NULL,NULL,NULL,NULL),(721,NULL,721,721,NULL,NULL,NULL,NULL),(722,NULL,722,722,NULL,NULL,NULL,NULL),(723,NULL,723,723,NULL,NULL,NULL,NULL),(724,NULL,724,724,NULL,NULL,NULL,NULL),(725,NULL,725,725,NULL,NULL,NULL,NULL),(726,NULL,726,726,NULL,NULL,NULL,NULL),(727,NULL,727,727,NULL,NULL,NULL,NULL),(728,NULL,728,728,NULL,NULL,NULL,NULL),(729,NULL,729,729,NULL,NULL,NULL,NULL),(730,NULL,730,730,NULL,NULL,NULL,NULL),(731,NULL,731,731,NULL,NULL,NULL,NULL),(732,NULL,732,732,NULL,NULL,NULL,NULL),(733,NULL,733,733,NULL,NULL,NULL,NULL),(734,NULL,734,734,NULL,NULL,NULL,NULL),(735,NULL,735,735,NULL,NULL,NULL,NULL),(736,NULL,736,736,NULL,NULL,NULL,NULL),(737,NULL,737,737,NULL,NULL,NULL,NULL),(741,NULL,741,741,NULL,NULL,NULL,NULL),(742,NULL,742,742,NULL,NULL,NULL,NULL),(743,NULL,743,743,NULL,NULL,NULL,NULL),(744,NULL,744,744,NULL,NULL,NULL,NULL),(745,NULL,745,745,NULL,NULL,NULL,NULL),(746,NULL,746,746,NULL,NULL,NULL,NULL),(747,NULL,747,747,NULL,NULL,NULL,NULL),(748,NULL,748,748,NULL,NULL,NULL,NULL),(749,NULL,749,749,NULL,NULL,NULL,NULL),(750,NULL,750,750,NULL,NULL,NULL,NULL),(751,NULL,751,751,NULL,NULL,NULL,NULL),(752,NULL,752,752,NULL,NULL,NULL,NULL),(753,NULL,753,753,NULL,NULL,NULL,NULL),(754,NULL,754,754,NULL,NULL,NULL,NULL),(755,NULL,755,755,NULL,NULL,NULL,NULL),(756,NULL,756,756,NULL,NULL,NULL,NULL),(757,NULL,757,757,NULL,NULL,NULL,NULL),(758,NULL,758,758,NULL,NULL,NULL,NULL),(759,NULL,759,759,NULL,NULL,NULL,NULL),(760,NULL,760,760,NULL,NULL,NULL,NULL),(761,NULL,761,761,NULL,NULL,NULL,NULL),(762,NULL,762,762,NULL,NULL,NULL,NULL),(763,NULL,763,763,NULL,NULL,NULL,NULL);
INSERT INTO `cta_cte_cliente_pivot_receipt` VALUES (764,NULL,764,764,NULL,NULL,NULL,NULL),(765,NULL,765,765,NULL,NULL,NULL,NULL),(766,NULL,766,766,NULL,NULL,NULL,NULL),(767,NULL,767,767,NULL,NULL,NULL,NULL),(768,NULL,768,768,NULL,NULL,NULL,NULL),(769,NULL,769,769,NULL,NULL,NULL,NULL),(770,NULL,770,770,NULL,NULL,NULL,NULL),(771,NULL,771,771,NULL,NULL,NULL,NULL),(772,NULL,772,772,NULL,NULL,NULL,NULL),(773,NULL,773,773,NULL,NULL,NULL,NULL),(774,NULL,774,774,NULL,NULL,NULL,NULL),(1011,NULL,1011,1017,NULL,NULL,NULL,NULL),(1012,NULL,1012,1018,NULL,NULL,NULL,NULL),(1013,NULL,1013,1019,NULL,NULL,NULL,NULL),(1014,NULL,1014,1020,NULL,NULL,NULL,NULL),(1015,NULL,1015,1021,NULL,NULL,NULL,NULL),(1016,NULL,1016,1022,NULL,NULL,NULL,NULL),(1017,NULL,1017,1023,NULL,NULL,NULL,NULL),(1018,NULL,1018,1024,NULL,NULL,NULL,NULL),(1019,NULL,1019,1025,NULL,NULL,NULL,NULL),(1020,NULL,1020,1026,NULL,NULL,NULL,NULL),(1021,NULL,1021,1027,NULL,NULL,NULL,NULL),(1022,NULL,1022,1028,NULL,NULL,NULL,NULL),(1023,NULL,1023,1029,NULL,NULL,NULL,NULL),(1024,NULL,1024,1030,NULL,NULL,NULL,NULL),(1025,NULL,1025,1031,NULL,NULL,NULL,NULL),(1026,NULL,1026,1032,NULL,NULL,NULL,NULL),(1027,NULL,1027,1033,NULL,NULL,NULL,NULL),(1028,NULL,1028,1034,NULL,NULL,NULL,NULL),(1029,NULL,1029,1035,NULL,NULL,NULL,NULL),(1030,NULL,1030,1036,NULL,NULL,NULL,NULL),(1031,NULL,1031,1037,NULL,NULL,NULL,NULL),(1032,NULL,1032,1038,NULL,NULL,NULL,NULL),(1033,NULL,1033,1039,NULL,NULL,NULL,NULL),(1034,NULL,1034,1040,NULL,NULL,NULL,NULL),(1035,NULL,1035,1041,NULL,NULL,NULL,NULL),(1036,NULL,1036,1042,NULL,NULL,NULL,NULL),(1037,NULL,1037,1043,NULL,NULL,NULL,NULL),(1038,NULL,1038,1044,NULL,NULL,NULL,NULL),(1039,NULL,1039,1045,NULL,NULL,NULL,NULL),(1040,NULL,1040,1046,NULL,NULL,NULL,NULL),(1041,NULL,1041,1047,NULL,NULL,NULL,NULL),(1042,NULL,1042,1048,NULL,NULL,NULL,NULL),(1043,NULL,1043,1049,NULL,NULL,NULL,NULL),(1044,NULL,1044,1050,NULL,NULL,NULL,NULL),(1045,NULL,1045,1051,NULL,NULL,NULL,NULL),(1046,NULL,1046,1052,NULL,NULL,NULL,NULL),(1047,NULL,1047,1053,NULL,NULL,NULL,NULL),(1048,NULL,1048,1054,NULL,NULL,NULL,NULL),(1049,NULL,1049,1055,NULL,NULL,NULL,NULL),(1050,NULL,1050,1056,NULL,NULL,NULL,NULL),(1051,NULL,1051,1057,NULL,NULL,NULL,NULL),(1052,NULL,1052,1058,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cta_cte_cliente_pivot_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `cta_cte_tesoreria_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria`
--

LOCK TABLES `cta_cte_tesoreria` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_cuentas`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_cuentas_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_cuentas_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=757 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_cuentas`
--

LOCK TABLES `cta_cte_tesoreria_cuentas` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` DISABLE KEYS */;
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (13,NULL,13,NULL,'Clientes - Deudores',0,0,0,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(20,NULL,20,NULL,'Anticipos Impuesto a las Ganancias',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(23,NULL,23,NULL,'Retenciones Impuesto a las Ganancias',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(25,NULL,25,NULL,'Retenciones de IVA',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(57,NULL,57,NULL,'Proveedores en Cta. Cte. locales',0,0,0,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(60,NULL,60,NULL,'Cheques emitidos ',0,1,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(62,NULL,62,NULL,'Sueldos y Jornales a pagar',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(140,NULL,140,NULL,'Intereses y Gastos bancarios',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(162,NULL,162,NULL,'Retenciones SUSS',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(176,NULL,176,NULL,'Cheques en Cartera',1,0,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(201,NULL,201,NULL,'Monotributo',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(203,NULL,203,NULL,'Autonomos',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(219,NULL,219,NULL,'Pagos AFIP',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(251,NULL,251,NULL,'Retenciones de IIBB Buenos Aires',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(252,NULL,252,NULL,'Retenciones de IIBB Capital Federal',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(253,NULL,253,NULL,'Retenciones de IIBB Catamarca',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(254,NULL,254,NULL,'Retenciones de IIBB Chaco',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(255,NULL,255,NULL,'Retenciones de IIBB Chubut',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(256,NULL,256,NULL,'Retenciones de IIBB Córdoba',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(257,NULL,257,NULL,'Retenciones de IIBB Corrientes',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(258,NULL,258,NULL,'Retenciones de IIBB Entre Ríos',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(259,NULL,259,NULL,'Retenciones de IIBB Formosa',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(260,NULL,260,NULL,'Retenciones de IIBB Jujuy',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(261,NULL,261,NULL,'Retenciones de IIBB La Pampa',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(262,NULL,262,NULL,'Retenciones de IIBB La Rioja',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(263,NULL,263,NULL,'Retenciones de IIBB Mendoza',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(264,NULL,264,NULL,'Retenciones de IIBB Misiones',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(265,NULL,265,NULL,'Retenciones de IIBB Neuquén',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(266,NULL,266,NULL,'Retenciones de IIBB Pascua Lama',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(267,NULL,267,NULL,'Retenciones de IIBB Río Negro',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(268,NULL,268,NULL,'Retenciones de IIBB Salta',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(269,NULL,269,NULL,'Retenciones de IIBB San Juan',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(270,NULL,270,NULL,'Retenciones de IIBB San Luis',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(271,NULL,271,NULL,'Retenciones de IIBB Santa Cruz',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(272,NULL,272,NULL,'Retenciones de IIBB Santa Fe',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(273,NULL,273,NULL,'Retenciones de IIBB Santiago del Estero',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (274,NULL,274,NULL,'Retenciones de IIBB Tierra del Fuego',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(275,NULL,275,NULL,'Retenciones de IIBB Tucuman',0,0,1,0,0,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(351,NULL,351,NULL,'BANCO SIRCREB',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(359,NULL,359,NULL,'Caja en Pesos',0,0,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(360,NULL,360,NULL,'Retenciones Bancarias de Ganancias a Favor',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(364,NULL,364,NULL,'Anticipo de Clientes',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(384,NULL,384,NULL,'Caja en Dolares',0,0,1,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(409,NULL,409,NULL,'IVA Crédito Fiscal No computable',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(418,NULL,418,NULL,'Deudas Bancarias',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(433,NULL,433,NULL,'Préstamo',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(441,NULL,441,NULL,'Leasing',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(448,NULL,448,NULL,'Planes de Pagos AFIP',0,0,0,1,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(450,NULL,450,NULL,'Cheques Rechazados',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(467,NULL,467,NULL,'Interés',0,0,0,0,1,0,'2019-10-19 02:10:24','2019-10-19 02:10:24',NULL),(468,0,14,NULL,'Deudores por ventas comunes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(469,0,15,NULL,'Deudores por ventas morosos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(470,0,16,NULL,'Deudores en gestión judicial',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(471,0,17,NULL,'Previsión deudores incobrables',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(472,0,22,NULL,'Anticipo Impto.Ganancia Mínima Presunta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(473,0,24,NULL,'Impuesto a las Ganancias (Saldo a favor)',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(474,0,27,NULL,'Anticipos de proveedores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(475,0,28,NULL,'Depósito en garantía alquileres',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(476,0,29,NULL,'Derechos adquiridos a devengar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(477,0,30,NULL,'Intereses a devengar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(478,0,31,NULL,'Cuentas a rendir - Directores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(479,0,32,NULL,'Alquileres no devengados',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(480,0,38,NULL,'Equipos de computación valores históricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(481,0,39,NULL,'Equipos de computación ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(482,0,40,NULL,'Amortización Acumulada Equipos de comput.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(483,0,42,NULL,'Instalaciones valores históricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(484,0,43,NULL,'Instalaciones ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(485,0,44,NULL,'Amortización Acumulada Instalaciones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(486,0,46,NULL,'Muebles y utiles valores históricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(487,0,47,NULL,'Muebles y utiles ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(488,0,48,NULL,'Amortización Acumulada Muebles y Útiles',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(489,0,50,NULL,'Gastos de organización valores historicos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (490,0,51,NULL,'Gastos de organización ajuste',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(491,0,52,NULL,'Amortización acumulada gs. de organización',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(492,0,58,NULL,'Proveedores en cta. cte. exterior',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(493,0,59,NULL,'Derechos de exhibición a devengar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(494,0,63,NULL,'Cargas sociales a pagar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(495,0,64,NULL,'Sindicatos a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(496,0,67,NULL,'IVA Debito Fiscal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(497,0,68,NULL,'IVA Credito Fiscal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(498,0,69,NULL,'Impuestos Internos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(499,0,70,NULL,'Impuestos al Combustible',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(500,0,71,NULL,'IVA Retenciones de terceros',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(501,0,72,NULL,'IVA Percepciones realiz.por terceros',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(502,0,73,NULL,'IVA Saldo a favor',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(503,0,74,NULL,'IVA a pagar',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(504,0,75,NULL,'Percepciones Ingresos Brutos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(505,0,76,NULL,'Otros Pagos AFIP',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(506,0,78,NULL,'Impuesto a los Ingresos Brutos Pasivo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(507,0,79,NULL,'Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(508,0,80,NULL,'Impuesto a la Ganancia Mínima Presunta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(509,0,81,NULL,'AFIP - Retenciones Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(510,0,82,NULL,'AFIP - Plan de Facilidades Decreto 338/02',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(511,0,87,NULL,'Acciones en circulación',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(512,0,88,NULL,'Ajuste del Capital',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(513,0,89,NULL,'Aportes Irrevocables Futuras Suscripciones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(514,0,91,NULL,'Resultado del ejercicio',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(515,0,92,NULL,'Resultado ejercicios anteriores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(516,0,93,NULL,'A.R.E.A.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(517,0,96,NULL,'VENTAS',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-23 19:10:22',NULL),(518,0,97,NULL,'Honorarios',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-23 19:10:22',NULL),(519,0,99,NULL,'Descuentos obtenidos',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-23 19:10:22',NULL),(520,0,100,NULL,'Reintegros por exportaciones',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-23 19:10:22',NULL),(521,0,102,NULL,'Intereses Cobrados',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-23 19:10:22',NULL),(522,0,103,NULL,'Diferencias de cambio',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-23 19:10:22',NULL),(523,0,104,NULL,'Descuentos obtenidos',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-23 19:10:22',NULL),(524,0,110,NULL,'Sueldos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(525,0,111,NULL,'Contribuciones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(526,0,112,NULL,'Sindicato',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(527,0,114,NULL,'ACA',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (528,0,115,NULL,'Aereos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(529,0,116,NULL,'Alquiler',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(530,0,117,NULL,'AGUA AYSA',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(531,0,118,NULL,'TV Cablevision',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(532,0,119,NULL,'Caja Jubilacion Consejo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(533,0,120,NULL,'Celulares',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(534,0,121,NULL,'Cheques',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(535,0,123,NULL,'Comida',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(536,0,126,NULL,'Fletes y acarreos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(537,0,127,NULL,'Luz Edesur',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(538,0,128,NULL,'Movilidad y Viáticos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(539,0,129,NULL,'Mantenimiento',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(540,0,130,NULL,'IVA No Computable',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(541,0,131,NULL,'Entretenimiento',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(542,0,132,NULL,'Amortización Bienes de Uso',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(543,0,135,NULL,'Gastos varios',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(544,0,136,NULL,'Ajuste por redondeo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(545,0,137,NULL,'Deudores Incobrables',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(546,0,141,NULL,'Intereses Proveedores',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(547,0,143,NULL,'Diferencias de cambio',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(548,0,144,NULL,'Diferencia de Cambio Bces. en M.Extranjera',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(549,0,145,NULL,'Diferencia tipo cambio Vendedor/Comprador',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(550,0,146,NULL,'Diferencia por conversion en Bce. en Mon. Extranj.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(551,0,147,NULL,'Diferencia de cambio CMV',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(552,0,148,NULL,'Diferencia de cambio PT',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(553,0,149,NULL,'Resultado por Exposición a la Inflación',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(554,0,150,NULL,'Diferencia de cambio PE',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(555,0,151,NULL,'Diferencia de cambio Ds.Vtas.',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(556,0,152,NULL,'Diferencia de cambio ME',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(557,0,153,NULL,'Descuentos otorgados',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(558,0,155,NULL,'Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(559,0,156,NULL,'Impuesto a los Ingresos Brutos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(560,0,157,NULL,'Impuesto al Debito y Credito Bancario',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(561,0,159,NULL,'Pérdida por venta bienes de uso',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(562,0,160,NULL,'Inversiones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(563,0,161,NULL,'Amortizaciones extraordinarias',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(564,0,178,NULL,'Google',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(565,0,188,NULL,'Publicidad',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(566,0,191,NULL,'Cargas Sociales',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (567,0,192,NULL,'Honorarios',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(568,0,193,NULL,'Telefono Fijo',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(569,0,198,NULL,'Seguros',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(570,0,199,NULL,'Internet',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(571,0,204,NULL,'Multas Impositivas',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(572,0,208,NULL,'Impuesto a los Ingresos Brutos - BS AS',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(573,0,209,NULL,'SIRCREB',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(574,0,212,NULL,'Tarjeta Visa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(575,0,213,NULL,'Tarjeta American Express',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(576,0,214,NULL,'Tarjeta Mastercard',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(577,0,215,NULL,'Tarjeta Shopping',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(578,0,216,NULL,'Tarjeta Cencosud',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(579,0,217,NULL,'Compras',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(580,0,218,NULL,'Ventas No Gravadas',0,0,0,0,1,1,'2020-02-06 17:23:07','2021-03-23 19:10:22',NULL),(581,0,220,NULL,'Perc IVA -RG3337',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(582,0,221,NULL,'Imps. Internos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(583,0,222,NULL,'Imp. Gasoil',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(584,0,223,NULL,'Imp. Hídricos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(585,0,224,NULL,'ITC',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(586,0,225,NULL,'Perc IIBB  Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(587,0,226,NULL,'Perc IIBB  Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(588,0,227,NULL,'Perc IIBB  Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(589,0,228,NULL,'Perc IIBB  Chaco',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(590,0,229,NULL,'Perc IIBB  Chubut',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(591,0,230,NULL,'Perc IIBB  Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(592,0,231,NULL,'Perc IIBB  Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(593,0,232,NULL,'Perc IIBB  Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(594,0,233,NULL,'Perc IIBB  Formosa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(595,0,234,NULL,'Perc IIBB  Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(596,0,235,NULL,'Perc IIBB  La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(597,0,236,NULL,'Perc IIBB  La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(598,0,237,NULL,'Perc IIBB  Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(599,0,238,NULL,'Perc IIBB  Misiones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(600,0,239,NULL,'Perc IIBB  Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(601,0,240,NULL,'Perc IIBB  Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(602,0,241,NULL,'Perc IIBB  Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(603,0,242,NULL,'Perc IIBB  Salta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(604,0,243,NULL,'Perc IIBB  San Juan',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(605,0,244,NULL,'Perc IIBB  San Luis',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(606,0,245,NULL,'Perc IIBB  Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (607,0,246,NULL,'Perc IIBB  Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(608,0,247,NULL,'Perc IIBB  Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(609,0,248,NULL,'Perc IIBB  Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(610,0,249,NULL,'Perc IIBB  Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(611,0,250,NULL,'Compras No Gravadas',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(612,0,276,NULL,'SIRCREB Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(613,0,277,NULL,'SIRCREB Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(614,0,278,NULL,'SIRCREB Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(615,0,279,NULL,'SIRCREB Chaco',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(616,0,280,NULL,'SIRCREB Chubut',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(617,0,281,NULL,'SIRCREB Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(618,0,282,NULL,'SIRCREB Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(619,0,283,NULL,'SIRCREB Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(620,0,284,NULL,'SIRCREB Formosa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(621,0,285,NULL,'SIRCREB Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(622,0,286,NULL,'SIRCREB La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(623,0,287,NULL,'SIRCREB La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(624,0,288,NULL,'SIRCREB Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(625,0,289,NULL,'SIRCREB Misiones',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(626,0,290,NULL,'SIRCREB Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(627,0,291,NULL,'SIRCREB Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(628,0,292,NULL,'SIRCREB Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(629,0,293,NULL,'SIRCREB Salta',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(630,0,294,NULL,'SIRCREB San Juan',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(631,0,295,NULL,'SIRCREB San Luis',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(632,0,296,NULL,'SIRCREB Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(633,0,297,NULL,'SIRCREB Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(634,0,298,NULL,'SIRCREB Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(635,0,299,NULL,'SIRCREB Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(636,0,300,NULL,'SIRCREB Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(637,0,301,NULL,'IIBB a Favor Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(638,0,302,NULL,'IIBB a Favor Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(639,0,303,NULL,'IIBB a Favor Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(640,0,304,NULL,'IIBB a Favor Chaco',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(641,0,305,NULL,'IIBB a Favor Chubut',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(642,0,306,NULL,'IIBB a Favor Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(643,0,307,NULL,'IIBB a Favor Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(644,0,308,NULL,'IIBB a Favor Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(645,0,309,NULL,'IIBB a Favor Formosa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(646,0,310,NULL,'IIBB a Favor Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (647,0,311,NULL,'IIBB a Favor La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(648,0,312,NULL,'IIBB a Favor La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(649,0,313,NULL,'IIBB a Favor Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:07','2020-02-06 17:23:07',NULL),(650,0,314,NULL,'IIBB a Favor Misiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(651,0,315,NULL,'IIBB a Favor Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(652,0,316,NULL,'IIBB a Favor Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(653,0,317,NULL,'IIBB a Favor Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(654,0,318,NULL,'IIBB a Favor Salta',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(655,0,319,NULL,'IIBB a Favor San Juan',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(656,0,320,NULL,'IIBB a Favor San Luis',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(657,0,321,NULL,'IIBB a Favor Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(658,0,322,NULL,'IIBB a Favor Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(659,0,323,NULL,'IIBB a Favor Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(660,0,324,NULL,'IIBB a Favor Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(661,0,325,NULL,'IIBB a Favor Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(662,0,326,NULL,'IIBB a Pagar Buenos Aires',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(663,0,327,NULL,'IIBB a Pagar Capital Federal',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(664,0,328,NULL,'IIBB a Pagar Catamarca',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(665,0,329,NULL,'IIBB a Pagar Chaco',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(666,0,330,NULL,'IIBB a Pagar Chubut',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(667,0,331,NULL,'IIBB a Pagar Córdoba',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(668,0,332,NULL,'IIBB a Pagar Corrientes',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(669,0,333,NULL,'IIBB a Pagar Entre Ríos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(670,0,334,NULL,'IIBB a Pagar Formosa',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(671,0,335,NULL,'IIBB a Pagar Jujuy',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(672,0,336,NULL,'IIBB a Pagar La Pampa',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(673,0,337,NULL,'IIBB a Pagar La Rioja',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(674,0,338,NULL,'IIBB a Pagar Mendoza',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(675,0,339,NULL,'IIBB a Pagar Misiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(676,0,340,NULL,'IIBB a Pagar Neuquén',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(677,0,341,NULL,'IIBB a Pagar Pascua Lama',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(678,0,342,NULL,'IIBB a Pagar Río Negro',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(679,0,343,NULL,'IIBB a Pagar Salta',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(680,0,344,NULL,'IIBB a Pagar San Juan',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(681,0,345,NULL,'IIBB a Pagar San Luis',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(682,0,346,NULL,'IIBB a Pagar Santa Cruz',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(683,0,347,NULL,'IIBB a Pagar Santa Fe',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(684,0,348,NULL,'IIBB a Pagar Santiago del Estero',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (685,0,349,NULL,'IIBB a Pagar Tierra del Fuego',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(686,0,350,NULL,'IIBB a Pagar Tucuman',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(687,0,352,NULL,'Compensacion',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(688,0,353,NULL,'IVA Saldo Tecnico',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(689,0,354,NULL,'IVA Saldo Libre Disponibilidad',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(690,0,361,NULL,'Equipos de Computación',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(691,0,362,NULL,'Computadoras',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(692,0,363,NULL,'Muebles y Utiles',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(693,0,365,NULL,'Provision Honorarios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(694,0,366,NULL,'Cta. Cte Directores',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(695,0,367,NULL,'Provisión Honorarios Directores',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(696,0,368,NULL,'Cuenta Particular Socio 1',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(697,0,369,NULL,'Capital',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(698,0,380,NULL,'Instalaciones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(699,0,381,NULL,'Reserva Legal',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(700,0,382,NULL,'Reserva Legal',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(701,0,383,NULL,'Resultado no asignado',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(702,0,386,NULL,'PLAZO FIJO',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(703,0,388,NULL,'ACCIONES',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(704,0,389,NULL,'Inmuebles',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(705,0,390,NULL,'Vehiculos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(706,0,391,NULL,'Maquinarias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(707,0,392,NULL,'MERCADERIAS',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(708,0,393,NULL,'OTROS',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(709,0,395,NULL,'Cuenta Particular Socio 2',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(710,0,396,NULL,'Comisiones Y gastos Bancarios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(711,0,411,NULL,'Provisión Impuesto a las Ganancias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(712,0,412,NULL,'Amortización Muebles y Útiles',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(713,0,413,NULL,'Amortización Equipos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(714,0,414,NULL,'Amortizacion Acumulada Equipos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(715,0,415,NULL,'Amortización Acumulada Maquinarias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(716,0,416,NULL,'Materias Primas',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(717,0,419,NULL,'Rodados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(718,0,420,NULL,'Amortización Acumulada Rodados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(719,0,421,NULL,'Amortización Rodados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(720,0,422,NULL,'Amortización Maquinarias',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(721,0,423,NULL,'Accesorios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(722,0,424,NULL,'Amortización Acumulada Accesorios',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(723,0,426,NULL,'Reserva Facultativa',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL);
INSERT INTO `cta_cte_tesoreria_cuentas` VALUES (724,0,427,NULL,'Créditos por Impuestos Diferidos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(725,0,428,NULL,'Fondo de Comercio',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(726,0,429,NULL,'Amortizacion Acumulada Fondo de Comercio',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(727,0,430,NULL,'Intereses a devengar AGIP',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(728,0,431,NULL,'PFP IIBB',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(729,0,434,NULL,'Productos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(730,0,435,NULL,'Intereses a devengar PFP',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(731,0,437,NULL,'Imp. Ley 25413 Cred 0.6%',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(732,0,438,NULL,'Honorarios Directorio a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(733,0,439,NULL,'Reserva para Futuras Inversiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(734,0,440,NULL,'TEAC - Trabajos Ejecutados a Certificar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(735,0,444,NULL,'Banco Santander Rio Cta Cte',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(736,0,449,NULL,'Leasing',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(737,0,453,NULL,'Inversión Central Caribe',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(738,0,454,NULL,'Otras Inversiones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(739,0,455,NULL,'Otros Créditos',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(740,0,456,NULL,'Provisión Honorarios Socio Gerente',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(741,0,459,NULL,'Moratoria SUSS a pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(742,0,460,NULL,'Impuestos Municipales a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(743,0,461,NULL,'Amortización Instalaciones',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(744,0,462,NULL,'Amortización Equipos de comput.',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(745,0,463,NULL,'Cuenta Particular Socio 3',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(746,0,464,NULL,'Cuenta Particular Socio 4',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(747,0,465,NULL,'Otras Reservas',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(748,0,466,NULL,'IGMP (Saldo a Favor)',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(749,0,468,NULL,'Productos en Proceso',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(750,0,469,NULL,'Depósitos en Garantía Socio Gerente',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(751,0,470,NULL,'Fondos Embargados',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(752,0,471,NULL,'Cuota Solid.',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(753,0,472,NULL,'Anticipo Honorarios Directores',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(754,0,473,NULL,'SICORE a Pagar',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(755,0,476,NULL,'RECPAM',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL),(756,0,478,NULL,'CO2 - Imp. Al Carbono',0,0,0,0,0,1,'2020-02-06 17:23:08','2020-02-06 17:23:08',NULL);
/*!40000 ALTER TABLE `cta_cte_tesoreria_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_tesoreria_detail`
--

DROP TABLE IF EXISTS `cta_cte_tesoreria_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_tesoreria_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `fecha` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_tesoreria_detail_person_id_foreign` (`person_id`),
  KEY `cta_cte_tesoreria_detail_period_id_foreign` (`period_id`),
  KEY `cta_cte_tesoreria_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_tesoreria_detail_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_tesoreria_detail`
--

LOCK TABLES `cta_cte_tesoreria_detail` WRITE;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cta_cte_tesoreria_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos`
--

DROP TABLE IF EXISTS `ctacte_bancos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigoBCRA` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos`
--

LOCK TABLES `ctacte_bancos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos` DISABLE KEYS */;
INSERT INTO `ctacte_bancos` VALUES (1,NULL,'BANCO DE GALICIA Y BUENOS AIRES S.A.',7,NULL,NULL,NULL),(2,NULL,'BANCO DE LA NACION ARGENTINA',11,NULL,NULL,NULL),(3,NULL,'BANCO DE LA PROVINCIA DE BUENOS AIRES',14,NULL,NULL,NULL),(4,NULL,'INDUSTRIAL AND COMMERCIAL BANK OF CHINA',15,NULL,NULL,NULL),(5,NULL,'CITIBANK N.A.',16,NULL,NULL,NULL),(6,NULL,'BBVA BANCO FRANCES S.A.',17,NULL,NULL,NULL),(7,NULL,'THE BANK OF TOKYO-MITSUBISHI UFJ, LTD.',18,NULL,NULL,NULL),(8,NULL,'BANCO DE LA PROVINCIA DE CORDOBA S.A.',20,NULL,NULL,NULL),(9,NULL,'BANCO SUPERVIELLE S.A.',27,NULL,NULL,NULL),(10,NULL,'BANCO DE LA CIUDAD DE BUENOS AIRES',29,NULL,NULL,NULL),(11,NULL,'BANCO PATAGONIA S.A.',34,NULL,NULL,NULL),(12,NULL,'BANCO HIPOTECARIO S.A.',44,NULL,NULL,NULL),(13,NULL,'BANCO DE SAN JUAN S.A.',45,NULL,NULL,NULL),(14,NULL,'BANCO DEL TUCUMAN S.A.',60,NULL,NULL,NULL),(15,NULL,'BANCO MUNICIPAL DE ROSARIO',65,NULL,NULL,NULL),(16,NULL,'BANCO SANTANDER RIO S.A.',72,NULL,NULL,NULL),(17,NULL,'BANCO DEL CHUBUT S.A.',83,NULL,NULL,NULL),(18,NULL,'BANCO DE SANTA CRUZ S.A.',86,NULL,NULL,NULL),(19,NULL,'BANCO DE LA PAMPA SOCIEDAD DE ECONOMÍA M',93,NULL,NULL,NULL),(20,NULL,'BANCO DE CORRIENTES S.A.',94,NULL,NULL,NULL),(21,NULL,'BANCO PROVINCIA DEL NEUQUÉN SOCIEDAD ANÓ',97,NULL,NULL,NULL),(22,NULL,'BANCO INTERFINANZAS S.A.',147,NULL,NULL,NULL),(23,NULL,'HSBC BANK ARGENTINA S.A.',150,NULL,NULL,NULL),(24,NULL,'JPMORGAN CHASE BANK, NATIONAL ASSOCIATIO',165,NULL,NULL,NULL),(25,NULL,'BANCO CREDICOOP COOPERATIVO LIMITADO',191,NULL,NULL,NULL),(26,NULL,'BANCO DE VALORES S.A.',198,NULL,NULL,NULL),(27,NULL,'BANCO ROELA S.A.',247,NULL,NULL,NULL),(28,NULL,'BANCO MARIVA S.A.',254,NULL,NULL,NULL),(29,NULL,'BANCO ITAU ARGENTINA S.A.',259,NULL,NULL,NULL),(30,NULL,'BANK OF AMERICA, NATIONAL ASSOCIATION',262,NULL,NULL,NULL),(31,NULL,'BNP PARIBAS',266,NULL,NULL,NULL),(32,NULL,'BANCO PROVINCIA DE TIERRA DEL FUEGO',268,NULL,NULL,NULL),(33,NULL,'BANCO DE LA REPUBLICA ORIENTAL DEL URUGU',269,NULL,NULL,NULL),(34,NULL,'BANCO SAENZ S.A.',277,NULL,NULL,NULL),(35,NULL,'BANCO MERIDIAN S.A.',281,NULL,NULL,NULL),(36,NULL,'BANCO MACRO S.A.',285,NULL,NULL,NULL),(37,NULL,'BANCO COMAFI SOCIEDAD ANONIMA',299,NULL,NULL,NULL),(38,NULL,'BANCO DE INVERSION Y COMERCIO EXTERIOR S',300,NULL,NULL,NULL),(39,NULL,'BANCO PIANO S.A.',301,NULL,NULL,NULL),(40,NULL,'BANCO JULIO SOCIEDAD ANONIMA',305,NULL,NULL,NULL),(41,NULL,'BANCO RIOJA SOCIEDAD ANONIMA UNIPERSONAL',309,NULL,NULL,NULL),(42,NULL,'BANCO DEL SOL S.A.',310,NULL,NULL,NULL),(43,NULL,'NUEVO BANCO DEL CHACO S. A.',311,NULL,NULL,NULL),(44,NULL,'BANCO VOII S.A.',312,NULL,NULL,NULL),(45,NULL,'BANCO DE FORMOSA S.A.',315,NULL,NULL,NULL),(46,NULL,'BANCO CMF S.A.',319,NULL,NULL,NULL),(47,NULL,'BANCO DE SANTIAGO DEL ESTERO S.A.',321,NULL,NULL,NULL),(48,NULL,'BANCO INDUSTRIAL S.A.',322,NULL,NULL,NULL),(49,NULL,'NUEVO BANCO DE SANTA FE SOCIEDAD ANONIMA',330,NULL,NULL,NULL),(50,NULL,'BANCO CETELEM ARGENTINA S.A.',331,NULL,NULL,NULL),(51,NULL,'BANCO DE SERVICIOS FINANCIEROS S.A.',332,NULL,NULL,NULL),(52,NULL,'BANCO BRADESCO ARGENTINA S.A.U.',336,NULL,NULL,NULL),(53,NULL,'BANCO DE SERVICIOS Y TRANSACCIONES S.A.',338,NULL,NULL,NULL),(54,NULL,'RCI BANQUE S.A.',339,NULL,NULL,NULL),(55,NULL,'BACS BANCO DE CREDITO Y SECURITIZACION S',340,NULL,NULL,NULL),(56,NULL,'BANCO MASVENTAS S.A.',341,NULL,NULL,NULL),(57,NULL,'BANCO WANAP S.A.',384,NULL,NULL,NULL),(58,NULL,'NUEVO BANCO DE ENTRE RÍOS S.A.',386,NULL,NULL,NULL),(59,NULL,'BANCO COLUMBIA S.A.',389,NULL,NULL,NULL),(60,NULL,'BANCO BICA S.A.',426,NULL,NULL,NULL),(61,NULL,'BANCO COINAG S.A.',431,NULL,NULL,NULL),(62,NULL,'BANCO DE COMERCIO S.A.',432,NULL,NULL,NULL),(63,NULL,'FORD CREDIT COMPAÑIA FINANCIERA S.A.',44059,NULL,NULL,NULL),(64,NULL,'COMPAÑIA FINANCIERA ARGENTINA S.A.',44077,NULL,NULL,NULL),(65,NULL,'VOLKWAGEN FINANCIAL SERVICES CIA.FIN.S.A',44088,NULL,NULL,NULL),(66,NULL,'CORDIAL COMPAÑÍA FINANCIERA S.A.',44090,NULL,NULL,NULL),(67,NULL,'FCA COMPAÑIA FINANCIERA S.A.',44092,NULL,NULL,NULL);
INSERT INTO `ctacte_bancos` VALUES (68,NULL,'GPAT COMPAÑIA FINANCIERA S.A.',44093,NULL,NULL,NULL),(69,NULL,'MERCEDES-BENZ COMPAÑÍA FINANCIERA ARGENT',44094,NULL,NULL,NULL),(70,NULL,'ROMBO COMPAÑÍA FINANCIERA S.A.',44095,NULL,NULL,NULL),(71,NULL,'JOHN DEERE CREDIT COMPAÑÍA FINANCIERA S.',44096,NULL,NULL,NULL),(72,NULL,'PSA FINANCE ARGENTINA COMPAÑÍA FINANCIER',44098,NULL,NULL,NULL),(73,NULL,'TOYOTA COMPAÑÍA FINANCIERA DE ARGENTINA',44099,NULL,NULL,NULL),(74,NULL,'FINANDINO COMPAÑIA FINANCIERA S.A.',44100,NULL,NULL,NULL),(75,NULL,'MONTEMAR COMPAÑIA FINANCIERA S.A.',45056,NULL,NULL,NULL),(76,NULL,'MULTIFINANZAS COMPAÑIA FINANCIERA S.A.',45072,NULL,NULL,NULL),(77,NULL,'CAJA DE CREDITO \"CUENCA\" COOPERATIVA LIM',65203,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctacte_bancos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_bancos_datos`
--

DROP TABLE IF EXISTS `ctacte_bancos_datos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_bancos_datos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cbu` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_bancos_datos_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  CONSTRAINT `ctacte_bancos_datos_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_bancos_datos`
--

LOCK TABLES `ctacte_bancos_datos` WRITE;
/*!40000 ALTER TABLE `ctacte_bancos_datos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_bancos_datos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctacte_cheques`
--

DROP TABLE IF EXISTS `ctacte_cheques`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctacte_cheques` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `asiento_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuenta_conta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id2` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) DEFAULT NULL,
  `cheque3ros` tinyint(1) NOT NULL DEFAULT '0',
  `cheque_emitidos` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `fecha_cobro` date DEFAULT NULL,
  `banco_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `titular` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abierto_cruzado` int(11) NOT NULL DEFAULT '1',
  `numero` int(10) unsigned DEFAULT NULL,
  `foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctacte_cheques_asiento_id_foreign` (`asiento_id`),
  KEY `ctacte_cheques_cuenta_conta_id_foreign` (`cuenta_conta_id`),
  KEY `ctacte_cheques_banco_id_foreign` (`banco_id`),
  KEY `ctacte_cheques_person_id_foreign` (`person_id`),
  KEY `ctacte_cheques_cta_cte_cliente_id2_foreign` (`cta_cte_cliente_id2`),
  KEY `ctacte_cheques_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `cta_cte_tesorer_id` (`cta_cte_tesoreria_id`),
  KEY `ctacte_cheques_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `ctacte_cheques_nf_cta_cte_id2_foreign` (`nf_cta_cte_id2`),
  KEY `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `cta_cte_tesorer_id` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `ctacte_cheques_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `ctacte_bancos` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id2_foreign` FOREIGN KEY (`cta_cte_cliente_id2`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `ctacte_cheques_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctacte_cheques_cuenta_conta_id_foreign` FOREIGN KEY (`cuenta_conta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id2_foreign` FOREIGN KEY (`nf_cta_cte_id2`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `ctacte_cheques_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctacte_cheques`
--

LOCK TABLES `ctacte_cheques` WRITE;
/*!40000 ALTER TABLE `ctacte_cheques` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctacte_cheques` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_centrocosto`
--

DROP TABLE IF EXISTS `ctactegastos_centrocosto`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_centrocosto` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_centrocosto`
--

LOCK TABLES `ctactegastos_centrocosto` WRITE;
/*!40000 ALTER TABLE `ctactegastos_centrocosto` DISABLE KEYS */;
INSERT INTO `ctactegastos_centrocosto` VALUES (1,NULL,'OFICINA',NULL,NULL,NULL),(2,NULL,'FIJO',NULL,NULL,NULL),(3,NULL,'VARIABLE',NULL,NULL,NULL),(4,NULL,'GISELA',NULL,NULL,NULL),(5,NULL,'LIA',NULL,NULL,NULL),(6,NULL,'PADRES',NULL,NULL,NULL),(7,NULL,'CASA',NULL,NULL,NULL),(8,NULL,'VANESA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_centrocosto` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_cuenta_tipo`
--

DROP TABLE IF EXISTS `ctactegastos_cuenta_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_cuenta_tipo` (
  `idCuentaTipo` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `idTipo` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`idCuentaTipo`),
  KEY `ctactegastos_cuenta_tipo_idtipo_foreign` (`idTipo`),
  KEY `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_cuenta_tipo_idtipo_foreign` FOREIGN KEY (`idTipo`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_cuenta_tipo`
--

LOCK TABLES `ctactegastos_cuenta_tipo` WRITE;
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` DISABLE KEYS */;
INSERT INTO `ctactegastos_cuenta_tipo` VALUES (1,NULL,NULL,3,NULL,NULL,NULL),(2,NULL,NULL,6,NULL,NULL,NULL),(3,NULL,NULL,3,NULL,NULL,NULL),(4,NULL,NULL,4,NULL,NULL,NULL),(5,NULL,NULL,5,NULL,NULL,NULL),(6,NULL,NULL,3,NULL,NULL,NULL),(7,NULL,NULL,4,NULL,NULL,NULL),(8,NULL,NULL,3,NULL,NULL,NULL),(9,NULL,NULL,4,NULL,NULL,NULL),(10,NULL,NULL,7,NULL,NULL,NULL),(11,NULL,NULL,8,NULL,NULL,NULL),(12,NULL,NULL,3,NULL,NULL,NULL),(13,NULL,NULL,3,NULL,NULL,NULL),(14,NULL,NULL,4,NULL,NULL,NULL),(15,NULL,NULL,1,NULL,NULL,NULL),(16,NULL,NULL,2,NULL,NULL,NULL),(17,NULL,NULL,5,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_cuenta_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_mensuales`
--

DROP TABLE IF EXISTS `ctactegastos_mensuales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_mensuales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `CuentaTipo_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `TipoDeGasto_id` int(10) unsigned NOT NULL,
  `CentroCosto_id` int(10) unsigned NOT NULL,
  `gasto_cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL DEFAULT '13',
  `monto` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ctactegastos_mensuales_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `ctactegastos_mensuales_tipodegasto_id_foreign` (`TipoDeGasto_id`),
  KEY `ctactegastos_mensuales_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` (`gasto_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `ctactegastos_mensuales_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `ctactegastos_mensuales_gasto_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`gasto_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `ctactegastos_mensuales_tipodegasto_id_foreign` FOREIGN KEY (`TipoDeGasto_id`) REFERENCES `ctactegastos_tiposdegastos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_mensuales`
--

LOCK TABLES `ctactegastos_mensuales` WRITE;
/*!40000 ALTER TABLE `ctactegastos_mensuales` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctactegastos_mensuales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctactegastos_tiposdegastos`
--

DROP TABLE IF EXISTS `ctactegastos_tiposdegastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctactegastos_tiposdegastos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctactegastos_tiposdegastos`
--

LOCK TABLES `ctactegastos_tiposdegastos` WRITE;
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` DISABLE KEYS */;
INSERT INTO `ctactegastos_tiposdegastos` VALUES (1,NULL,'Oficina',NULL,NULL,NULL),(2,NULL,'Personales',NULL,NULL,NULL),(3,NULL,'Tarjeta VISA',NULL,NULL,NULL),(4,NULL,'Tarjeta Mastercard',NULL,NULL,NULL),(5,NULL,'Debito Automatico',NULL,NULL,NULL),(6,NULL,'American Express',NULL,NULL,NULL),(7,NULL,'Tarjeta Shopping',NULL,NULL,NULL),(8,NULL,'Tarjeta Cencosud',NULL,NULL,NULL),(9,NULL,'Tarjeta Coto',NULL,NULL,NULL),(10,NULL,'Tarjeta Nativa',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ctactegastos_tiposdegastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos`
--

DROP TABLE IF EXISTS `cursos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha` date DEFAULT NULL,
  `hora` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profesor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cant_clases` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duracion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjuntos` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_zoom` longtext COLLATE utf8mb4_unicode_ci,
  `cod_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contraseña_zoom` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_youtube` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `materiales` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos`
--

LOCK TABLES `cursos` WRITE;
/*!40000 ALTER TABLE `cursos` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cursos_detail`
--

DROP TABLE IF EXISTS `cursos_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cursos_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `curso_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `celular` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cursos_detail_curso_id_foreign` (`curso_id`),
  CONSTRAINT `cursos_detail_curso_id_foreign` FOREIGN KEY (`curso_id`) REFERENCES `cursos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cursos_detail`
--

LOCK TABLES `cursos_detail` WRITE;
/*!40000 ALTER TABLE `cursos_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `cursos_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `data_types`
--

DROP TABLE IF EXISTS `data_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `data_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `data_types_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `data_types`
--

LOCK TABLES `data_types` WRITE;
/*!40000 ALTER TABLE `data_types` DISABLE KEYS */;
INSERT INTO `data_types` VALUES (1,'Comprobantes XLS',1,'Importación','XLS','data/imports/receipts/xls',NULL,NULL),(2,'CITI-Ventas',1,'Importación','TXT','data/imports/receipts/CitiVentas',NULL,NULL),(3,'CITI Compras',2,'Exportación','TXT','data/exports/receipts/citi',NULL,NULL),(4,'CITI Ventas',2,'Exportación','TXT','data/exports/receipts/CitiVentasExport',NULL,NULL),(5,'Convenio Multilateral',2,'Exportación','TXT','data/exports/receipts/convenio',NULL,NULL),(6,'Libro IVA Digital',2,'Exportación','TXT','data/exports/receipts/libro_iva_digital',NULL,'2019-11-20 21:43:44'),(7,'Mis Comprobantes',1,'Importacion','','data/imports/receipts/mis_comprobantes',NULL,NULL),(8,'Consulta AFIP',3,'AFIP','','data/afip/index','2019-12-06 14:49:55','2019-12-06 14:49:55');
/*!40000 ALTER TABLE `data_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_estados`
--

DROP TABLE IF EXISTS `dc_estados`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_estados` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_estados`
--

LOCK TABLES `dc_estados` WRITE;
/*!40000 ALTER TABLE `dc_estados` DISABLE KEYS */;
INSERT INTO `dc_estados` VALUES (1,NULL,'PEDIDO',1,NULL,NULL,NULL),(2,NULL,'ACEPTADO',1,NULL,NULL,NULL),(3,NULL,'RECHAZADO',1,NULL,NULL,NULL),(4,NULL,'PAGADO',1,NULL,NULL,NULL),(5,NULL,'CONCILIADO',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_estados` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes`
--

DROP TABLE IF EXISTS `dc_ordenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_tipo_id` bigint(20) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `numero` int(11) NOT NULL,
  `sector` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `solicitante` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha` date NOT NULL,
  `fecha_entrega` date DEFAULT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `neto` decimal(16,2) NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `dc_estado_id` bigint(20) unsigned NOT NULL,
  `conta_cc_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_dc_orden_tipo_id_foreign` (`dc_orden_tipo_id`),
  KEY `dc_ordenes_person_id_foreign` (`person_id`),
  KEY `dc_ordenes_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `dc_ordenes_dc_estado_id_foreign` (`dc_estado_id`),
  KEY `dc_ordenes_conta_cc_id_foreign` (`conta_cc_id`),
  CONSTRAINT `dc_ordenes_conta_cc_id_foreign` FOREIGN KEY (`conta_cc_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `dc_ordenes_dc_estado_id_foreign` FOREIGN KEY (`dc_estado_id`) REFERENCES `dc_estados` (`id`),
  CONSTRAINT `dc_ordenes_dc_orden_tipo_id_foreign` FOREIGN KEY (`dc_orden_tipo_id`) REFERENCES `dc_ordenes_tipos` (`id`),
  CONSTRAINT `dc_ordenes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dc_ordenes_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes`
--

LOCK TABLES `dc_ordenes` WRITE;
/*!40000 ALTER TABLE `dc_ordenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_details`
--

DROP TABLE IF EXISTS `dc_ordenes_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `dc_orden_id` bigint(20) unsigned NOT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `neto` decimal(16,2) NOT NULL,
  `desc_porc` decimal(16,2) DEFAULT NULL,
  `descuento` decimal(16,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL,
  `iva` decimal(16,2) NOT NULL,
  `subtotal` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dc_ordenes_details_dc_orden_id_foreign` (`dc_orden_id`),
  KEY `dc_ordenes_details_inv_producto_id_foreign` (`inv_producto_id`),
  KEY `dc_ordenes_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `dc_ordenes_details_dc_orden_id_foreign` FOREIGN KEY (`dc_orden_id`) REFERENCES `dc_ordenes` (`id`),
  CONSTRAINT `dc_ordenes_details_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `dc_ordenes_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_details`
--

LOCK TABLES `dc_ordenes_details` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `dc_ordenes_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dc_ordenes_tipos`
--

DROP TABLE IF EXISTS `dc_ordenes_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dc_ordenes_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dc_ordenes_tipos`
--

LOCK TABLES `dc_ordenes_tipos` WRITE;
/*!40000 ALTER TABLE `dc_ordenes_tipos` DISABLE KEYS */;
INSERT INTO `dc_ordenes_tipos` VALUES (1,NULL,'COMPRAS',1,NULL,NULL,NULL),(2,NULL,'VENTAS',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `dc_ordenes_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deudas_impositivas`
--

DROP TABLE IF EXISTS `deudas_impositivas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deudas_impositivas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `vto_impuesto_id` int(10) unsigned NOT NULL,
  `periodo_deuda` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deudas_impositivas_vto_impuesto_id_foreign` (`vto_impuesto_id`),
  KEY `deudas_impositivas_person_id_foreign` (`person_id`),
  CONSTRAINT `deudas_impositivas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `deudas_impositivas_vto_impuesto_id_foreign` FOREIGN KEY (`vto_impuesto_id`) REFERENCES `vto_impuestos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deudas_impositivas`
--

LOCK TABLES `deudas_impositivas` WRITE;
/*!40000 ALTER TABLE `deudas_impositivas` DISABLE KEYS */;
/*!40000 ALTER TABLE `deudas_impositivas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ejer_anteriores`
--

DROP TABLE IF EXISTS `ejer_anteriores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ejer_anteriores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `anio` int(11) NOT NULL,
  `ventas` decimal(16,2) DEFAULT NULL,
  `compras` decimal(16,2) DEFAULT NULL,
  `sueldos` decimal(16,2) DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `apagar` decimal(16,2) DEFAULT NULL,
  `afavor` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ejer_anteriores_person_id_foreign` (`person_id`),
  CONSTRAINT `ejer_anteriores_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ejer_anteriores`
--

LOCK TABLES `ejer_anteriores` WRITE;
/*!40000 ALTER TABLE `ejer_anteriores` DISABLE KEYS */;
/*!40000 ALTER TABLE `ejer_anteriores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_civil`
--

DROP TABLE IF EXISTS `estado_civil`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estado_civil` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `estado_civil_descripcion_unique` (`descripcion`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_civil`
--

LOCK TABLES `estado_civil` WRITE;
/*!40000 ALTER TABLE `estado_civil` DISABLE KEYS */;
INSERT INTO `estado_civil` VALUES (1,NULL,'Separado Legal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,'Separado de Hecho',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,'Divorciado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,'Convivencia',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,'Soltero',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,'Casado',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,'Viudo',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `estado_civil` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva`
--

DROP TABLE IF EXISTS `fa_masiva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva`
--

LOCK TABLES `fa_masiva` WRITE;
/*!40000 ALTER TABLE `fa_masiva` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_detalle`
--

DROP TABLE IF EXISTS `fa_masiva_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_detalle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fa_masiva_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL DEFAULT '1',
  `zone_id` int(10) unsigned NOT NULL DEFAULT '22',
  `activity_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `concepto_id` int(10) unsigned NOT NULL DEFAULT '1',
  `taxable_iibb` int(10) unsigned NOT NULL DEFAULT '2',
  `renglon1` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe1` decimal(20,2) DEFAULT NULL,
  `renglon2` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe2` decimal(20,2) DEFAULT NULL,
  `renglon3` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe3` decimal(20,2) DEFAULT NULL,
  `punto_venta_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date DEFAULT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_detalle_concepto_id_foreign` (`concepto_id`),
  KEY `fa_masiva_detalle_system_tax_id_foreign` (`system_tax_id`),
  KEY `fa_masiva_detalle_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  KEY `fa_masiva_detalle_zone_id_foreign` (`zone_id`),
  KEY `fa_masiva_detalle_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fa_masiva_detalle_activity_id_foreign` (`activity_id`),
  CONSTRAINT `fa_masiva_detalle_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `activities` (`id`),
  CONSTRAINT `fa_masiva_detalle_concepto_id_foreign` FOREIGN KEY (`concepto_id`) REFERENCES `fact_elec_conceptos_afip` (`id`),
  CONSTRAINT `fa_masiva_detalle_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `fac_elec_cond_frente_iva` (`id`),
  CONSTRAINT `fa_masiva_detalle_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`),
  CONSTRAINT `fa_masiva_detalle_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`),
  CONSTRAINT `fa_masiva_detalle_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_detalle`
--

LOCK TABLES `fa_masiva_detalle` WRITE;
/*!40000 ALTER TABLE `fa_masiva_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fa_masiva_stock`
--

DROP TABLE IF EXISTS `fa_masiva_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fa_masiva_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fa_masiva_stock_person_id_foreign` (`person_id`),
  KEY `fa_masiva_stock_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `fa_masiva_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fa_masiva_stock_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fa_masiva_stock`
--

LOCK TABLES `fa_masiva_stock` WRITE;
/*!40000 ALTER TABLE `fa_masiva_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `fa_masiva_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_cond_frente_iva`
--

DROP TABLE IF EXISTS `fac_elec_cond_frente_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_cond_frente_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_cond_frente_iva_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_cond_frente_iva`
--

LOCK TABLES `fac_elec_cond_frente_iva` WRITE;
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` DISABLE KEYS */;
INSERT INTO `fac_elec_cond_frente_iva` VALUES (1,'IVA Responsable Inscripto','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'IVA Sujeto Exento','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Consumidor Final','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Responsable Monotributo','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Proveedor del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Cliente del Exterior','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'IVA Liberado - Ley Nº 19.640','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'IVA Responsable Inscripto - Agente de Percepción','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Monotributista Social','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'IVA No Alcanzado','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_cond_frente_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fac_elec_unidad_medidas`
--

DROP TABLE IF EXISTS `fac_elec_unidad_medidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fac_elec_unidad_medidas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fac_elec_unidad_medidas_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fac_elec_unidad_medidas`
--

LOCK TABLES `fac_elec_unidad_medidas` WRITE;
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` DISABLE KEYS */;
INSERT INTO `fac_elec_unidad_medidas` VALUES (1,'Grs','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(2,'Kg','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(3,'Mts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(4,'Mts2','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(5,'Mts3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(6,'Lts','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(7,'1000 Kwh','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(8,'Unidades','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(9,'Pares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(10,'Doc','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(11,'Quilates','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(12,'Millares','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(13,'Milimetros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(14,'Mm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(15,'Km','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(16,'Hectolitros','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(17,'Cm','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL),(18,'Cm 3','2019-07-15 18:37:39','2019-07-15 18:37:39',NULL);
/*!40000 ALTER TABLE `fac_elec_unidad_medidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_conceptos_afip`
--

DROP TABLE IF EXISTS `fact_elec_conceptos_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_conceptos_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_comprobante_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_conceptos_afip`
--

LOCK TABLES `fact_elec_conceptos_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_conceptos_afip` VALUES (1,1,'Producto','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'Productos y Servicios','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_conceptos_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_puntos_venta`
--

DROP TABLE IF EXISTS `fact_elec_puntos_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_puntos_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `direccion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '0000',
  `codigo_postal` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_puntos_venta_person_id_foreign` (`person_id`),
  CONSTRAINT `fact_elec_puntos_venta_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_puntos_venta`
--

LOCK TABLES `fact_elec_puntos_venta` WRITE;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_puntos_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipt_details`
--

DROP TABLE IF EXISTS `fact_elec_receipt_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipt_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cantidad` decimal(20,2) NOT NULL,
  `unidad_medida` text COLLATE utf8mb4_unicode_ci,
  `precio_unitario` decimal(20,2) NOT NULL,
  `neto_gravado` decimal(20,2) NOT NULL,
  `bonificacion_porcentaje` decimal(20,2) DEFAULT NULL,
  `bonificacion_monto` decimal(20,2) DEFAULT NULL,
  `bonificacion_subtotal` decimal(20,2) DEFAULT NULL,
  `system_tax_id` int(10) unsigned NOT NULL DEFAULT '1',
  `iva_monto` decimal(20,2) DEFAULT NULL,
  `iva_subtotal` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `codigo` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipt_details_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  KEY `fact_elec_receipt_details_system_tax_id_foreign` (`system_tax_id`),
  CONSTRAINT `fact_elec_receipt_details_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `fact_elec_receipt_details_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipt_details`
--

LOCK TABLES `fact_elec_receipt_details` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipt_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipt_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_receipts`
--

DROP TABLE IF EXISTS `fact_elec_receipts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_receipts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `fecha_comprobante` date NOT NULL,
  `fecha_facturado_desde` date DEFAULT NULL,
  `fecha_facturado_hasta` date DEFAULT NULL,
  `fecha_vencimiento_pago` date DEFAULT NULL,
  `concepto_id` int(10) unsigned NOT NULL,
  `punto_venta_id` int(10) unsigned NOT NULL,
  `tipo_comprobante_id` int(10) unsigned NOT NULL,
  `condiciones_venta` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobante_asoc` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cae` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cae_vencimiento` date DEFAULT NULL,
  `nro_comprobante_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_proceso_afip` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_receptor` int(10) unsigned NOT NULL,
  `condicion_venta_id` int(11) DEFAULT NULL,
  `cond_frente_iva_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opcion_transferencia` longtext COLLATE utf8mb4_unicode_ci,
  `alias_cbu` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fact_elec_receipts_user_id_foreign` (`user_id`),
  KEY `fact_elec_receipts_punto_venta_id_foreign` (`punto_venta_id`),
  KEY `fact_elec_receipts_tipo_comprobante_id_foreign` (`tipo_comprobante_id`),
  KEY `fact_elec_receipts_person_id_foreign` (`person_id`),
  KEY `fact_elec_receipts_person_id_receptor_foreign` (`person_id_receptor`),
  KEY `fact_elec_receipts_cond_frente_iva_id_foreign` (`cond_frente_iva_id`),
  CONSTRAINT `fact_elec_receipts_cond_frente_iva_id_foreign` FOREIGN KEY (`cond_frente_iva_id`) REFERENCES `condicion_frente_al_iva` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_person_id_receptor_foreign` FOREIGN KEY (`person_id_receptor`) REFERENCES `persons` (`id`),
  CONSTRAINT `fact_elec_receipts_punto_venta_id_foreign` FOREIGN KEY (`punto_venta_id`) REFERENCES `fact_elec_puntos_venta` (`id`),
  CONSTRAINT `fact_elec_receipts_tipo_comprobante_id_foreign` FOREIGN KEY (`tipo_comprobante_id`) REFERENCES `receipt_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_receipts`
--

LOCK TABLES `fact_elec_receipts` WRITE;
/*!40000 ALTER TABLE `fact_elec_receipts` DISABLE KEYS */;
/*!40000 ALTER TABLE `fact_elec_receipts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fact_elec_tipos_docs_afip`
--

DROP TABLE IF EXISTS `fact_elec_tipos_docs_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fact_elec_tipos_docs_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `afip_tipo_doc_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fact_elec_tipos_docs_afip`
--

LOCK TABLES `fact_elec_tipos_docs_afip` WRITE;
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` DISABLE KEYS */;
INSERT INTO `fact_elec_tipos_docs_afip` VALUES (1,1,'CI Buenos Aires','2019-03-13 13:29:34','2019-03-13 13:29:34'),(2,2,'CI Catamarca','2019-03-13 13:29:34','2019-03-13 13:29:34'),(3,3,'CI Córdoba','2019-03-13 13:29:34','2019-03-13 13:29:34'),(4,4,'CI Corrientes','2019-03-13 13:29:34','2019-03-13 13:29:34'),(5,5,'CI Entre Ríos','2019-03-13 13:29:34','2019-03-13 13:29:34'),(6,6,'CI Jujuy','2019-03-13 13:29:34','2019-03-13 13:29:34'),(7,7,'CI Mendoza','2019-03-13 13:29:34','2019-03-13 13:29:34'),(8,8,'CI La Rioja','2019-03-13 13:29:34','2019-03-13 13:29:34'),(9,9,'CI Salta','2019-03-13 13:29:34','2019-03-13 13:29:34'),(10,10,'CI San Juan','2019-03-13 13:29:34','2019-03-13 13:29:34'),(11,11,'CI San Luis','2019-03-13 13:29:34','2019-03-13 13:29:34'),(12,12,'CI Santa Fe','2019-03-13 13:29:34','2019-03-13 13:29:34'),(13,13,'CI Santiago del Estero','2019-03-13 13:29:34','2019-03-13 13:29:34'),(14,14,'CI Tucumán','2019-03-13 13:29:34','2019-03-13 13:29:34'),(16,16,'CI Chaco','2019-03-13 13:29:34','2019-03-13 13:29:34'),(17,17,'CI Chubut','2019-03-13 13:29:34','2019-03-13 13:29:34'),(18,18,'CI Formosa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(19,19,'CI Misiones','2019-03-13 13:29:34','2019-03-13 13:29:34'),(20,20,'CI Neuquén','2019-03-13 13:29:34','2019-03-13 13:29:34'),(21,21,'CI La Pampa','2019-03-13 13:29:34','2019-03-13 13:29:34'),(22,22,'CI Río Negro','2019-03-13 13:29:34','2019-03-13 13:29:34'),(23,23,'CI Santa Cruz','2019-03-13 13:29:34','2019-03-13 13:29:34'),(24,24,'CI Tierra del Fuego','2019-03-13 13:29:34','2019-03-13 13:29:34'),(80,80,'CUIT','2019-03-13 13:29:34','2019-03-13 13:29:34'),(86,86,'CUIL','2019-03-13 13:29:34','2019-03-13 13:29:34'),(87,87,'CDI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(89,89,'LE','2019-03-13 13:29:34','2019-03-13 13:29:34'),(90,90,'LC','2019-03-13 13:29:34','2019-03-13 13:29:34'),(91,91,'CI Extranjera','2019-03-13 13:29:34','2019-03-13 13:29:34'),(92,92,'en trámite','2019-03-13 13:29:34','2019-03-13 13:29:34'),(93,93,'Acta Nacimiento','2019-03-13 13:29:34','2019-03-13 13:29:34'),(94,94,'Pasaporte','2019-03-13 13:29:34','2019-03-13 13:29:34'),(95,95,'CI Bs. As. RNP','2019-03-13 13:29:34','2019-03-13 13:29:34'),(96,96,'DNI','2019-03-13 13:29:34','2019-03-13 13:29:34'),(97,0,'CI Policía Federal','2019-03-13 13:29:34','2019-03-13 13:29:34'),(99,99,'Doc. (Otro)','2019-03-13 13:29:34','2019-03-13 13:29:34');
/*!40000 ALTER TABLE `fact_elec_tipos_docs_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq`
--

DROP TABLE IF EXISTS `faq`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `faq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pregunta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `respuesta` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq`
--

LOCK TABLES `faq` WRITE;
/*!40000 ALTER TABLE `faq` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_upload_details`
--

DROP TABLE IF EXISTS `file_upload_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_upload_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_upload_id` int(10) unsigned NOT NULL,
  `detail` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_upload_details_file_upload_id_foreign` (`file_upload_id`),
  CONSTRAINT `file_upload_details_file_upload_id_foreign` FOREIGN KEY (`file_upload_id`) REFERENCES `file_uploads` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_upload_details`
--

LOCK TABLES `file_upload_details` WRITE;
/*!40000 ALTER TABLE `file_upload_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_upload_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_uploads`
--

DROP TABLE IF EXISTS `file_uploads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_uploads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `data_type_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_uploads_data_type_id_foreign` (`data_type_id`),
  KEY `file_uploads_user_id_foreign` (`user_id`),
  KEY `file_uploads_person_id_foreign` (`person_id`),
  KEY `file_uploads_period_id_foreign` (`period_id`),
  CONSTRAINT `file_uploads_data_type_id_foreign` FOREIGN KEY (`data_type_id`) REFERENCES `data_types` (`id`),
  CONSTRAINT `file_uploads_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `file_uploads_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `file_uploads_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `tusers` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_uploads`
--

LOCK TABLES `file_uploads` WRITE;
/*!40000 ALTER TABLE `file_uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_uploads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_art_90`
--

DROP TABLE IF EXISTS `ganan_art_90`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_art_90` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,2) NOT NULL DEFAULT '0.00',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_art_90`
--

LOCK TABLES `ganan_art_90` WRITE;
/*!40000 ALTER TABLE `ganan_art_90` DISABLE KEYS */;
INSERT INTO `ganan_art_90` VALUES (1,2017,0.00,20000.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,2017,20000.00,40000.00,1000.00,0.09,20000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,2017,40000.00,60000.00,2800.00,0.12,40000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,2017,60000.00,80000.00,5200.00,0.15,60000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,2017,80000.00,120000.00,8200.00,0.19,80000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,2017,120000.00,160000.00,15800.00,0.23,120000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,2017,160000.00,240000.00,25000.00,0.27,160000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,2017,240000.00,320000.00,46600.00,0.31,240000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,2017,320000.00,999999999.99,71400.00,0.35,320000.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,2018,0.00,25754.00,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,2018,25754.00,51508.00,1287.70,0.09,25754.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,2018,51508.00,77262.00,3605.56,0.12,51508.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,2018,77262.00,103016.00,6696.04,0.15,77262.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,2018,103016.00,154524.00,10559.14,0.19,103016.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(15,2018,154524.00,206032.00,20345.66,0.23,154524.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(16,2018,206032.00,309048.00,32192.50,0.27,206032.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(17,2018,309048.00,412064.00,60006.82,0.31,309048.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(18,2018,412064.00,999999999.99,91941.78,0.35,412064.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(19,2019,0.00,33039.81,0.00,0.05,0.00,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(20,2019,33039.81,66079.61,1651.99,0.09,33039.81,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(21,2019,66079.61,99119.42,4625.57,0.12,66079.61,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(22,2019,99119.42,132159.23,8590.35,0.15,99119.42,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(23,2019,132159.23,198238.84,13546.32,0.19,132159.23,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(24,2019,198238.84,264318.45,26101.45,0.23,198238.84,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(25,2019,264318.45,396477.68,41299.76,0.27,264318.45,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(26,2019,396477.68,528636.91,76982.75,0.31,396477.68,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(27,2019,528636.91,999999999.99,117952.11,0.35,528636.91,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(28,2016,0.00,10000.00,0.00,0.09,0.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(29,2016,10000.00,20000.00,900.00,0.14,10000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(30,2016,20000.00,30000.00,2300.00,0.19,20000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(31,2016,30000.00,60000.00,4200.00,0.23,30000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(32,2016,60000.00,90000.00,11100.00,0.27,60000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(33,2016,90000.00,120000.00,19200.00,0.31,90000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(34,2016,120000.00,999999999.00,28500.00,0.35,120000.00,'2020-01-28 13:48:34','2020-02-27 02:59:44',NULL),(37,2020,0.00,47669.16,0.00,0.05,0.00,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(38,2020,47669.16,95338.32,2383.46,0.09,47669.16,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(39,2020,95338.32,143007.48,6673.68,0.12,95338.32,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(40,2020,143007.48,190676.65,12393.98,0.15,143007.48,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(41,2020,190676.65,286014.96,19544.36,0.19,190676.65,'2020-01-28 14:17:39','2021-03-23 19:10:24',NULL),(42,2020,286014.96,381353.28,37658.64,0.23,286014.96,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_art_90` VALUES (43,2020,381353.28,572029.92,59586.45,0.27,381353.28,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(44,2020,572029.92,762706.57,111069.14,0.31,572029.92,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(45,2020,762706.57,999999999.99,170178.90,0.35,762706.57,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(46,2021,0.00,64532.64,0.00,0.05,0.00,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(47,2021,64532.64,129065.29,3226.63,0.09,64532.64,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(48,2021,129065.29,193597.93,9034.57,0.12,129065.29,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(49,2021,193597.93,258130.58,16778.49,0.15,193597.93,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(50,2021,258130.58,387195.86,26458.39,0.19,258130.58,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(51,2021,387195.86,516261.14,50980.79,0.23,387195.86,'2021-03-23 19:10:24','2022-06-07 11:11:11',NULL),(52,2021,516261.14,774391.71,80665.80,0.27,516261.14,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(53,2021,774391.71,1032522.30,150361.06,0.31,774391.71,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(54,2021,1032522.30,999999999.99,230381.54,0.35,1032522.30,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(55,2022,0.00,97201.99,0.00,0.05,0.00,'2022-01-11 14:07:21','2022-02-06 22:40:44',NULL),(56,2022,97201.99,194404.01,4860.10,0.09,97201.99,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(57,2022,194404.01,291606.01,13608.29,0.12,194404.01,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(58,2022,291606.01,388808.02,25272.52,0.15,291606.01,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(59,2022,388808.02,583212.02,39852.82,0.19,388808.02,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(60,2022,583212.02,777616.02,76789.59,0.23,583212.02,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(61,2022,777616.02,1166424.03,121502.49,0.27,777616.02,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(62,2022,1166424.03,1555232.07,226480.67,0.31,1166424.03,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(63,2022,1555232.07,9999999.00,347011.15,0.35,1555232.07,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL);
/*!40000 ALTER TABLE `ganan_art_90` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_categorias`
--

DROP TABLE IF EXISTS `ganan_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_categorias`
--

LOCK TABLES `ganan_categorias` WRITE;
/*!40000 ALTER TABLE `ganan_categorias` DISABLE KEYS */;
INSERT INTO `ganan_categorias` VALUES (1,'Primera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,'Segunda',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(3,'Tercera',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(4,'Cuarta',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_conceptos_anticipos`
--

DROP TABLE IF EXISTS `ganan_conceptos_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_conceptos_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ganan_conceptos_anticipos_nombre_unique` (`nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_conceptos_anticipos`
--

LOCK TABLES `ganan_conceptos_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` DISABLE KEYS */;
INSERT INTO `ganan_conceptos_anticipos` VALUES (1,NULL,'Anticipos',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,'Retenciones y Percepciones',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,'Saldo a Favor Anterior',1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL);
/*!40000 ALTER TABLE `ganan_conceptos_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_anticipos`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_anticipos`
--

LOCK TABLES `ganan_ddjj_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_deducciones`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_deduccion_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_deducciones_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` (`ganan_deduccion_id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_ganan_deduccion_id_foreign` FOREIGN KEY (`ganan_deduccion_id`) REFERENCES `ganan_deducciones` (`id`),
  CONSTRAINT `ganan_ddjj_detail_deducciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_deducciones`
--

LOCK TABLES `ganan_ddjj_detail_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjj_detail_ing_egr`
--

DROP TABLE IF EXISTS `ganan_ddjj_detail_ing_egr`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjj_detail_ing_egr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ganan_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `ganan_categoria_id` int(10) unsigned NOT NULL,
  `ganan_tipo_op_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` (`ganan_ddjj_id`),
  KEY `ganan_ddjj_detail_ing_egr_person_id_foreign` (`person_id`),
  KEY `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` (`ganan_categoria_id`),
  KEY `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` (`ganan_tipo_op_id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_categoria_id_foreign` FOREIGN KEY (`ganan_categoria_id`) REFERENCES `ganan_categorias` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_ddjj_id_foreign` FOREIGN KEY (`ganan_ddjj_id`) REFERENCES `ganan_ddjjs` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_ganan_tipo_op_id_foreign` FOREIGN KEY (`ganan_tipo_op_id`) REFERENCES `ganan_tipos_op` (`id`),
  CONSTRAINT `ganan_ddjj_detail_ing_egr_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjj_detail_ing_egr`
--

LOCK TABLES `ganan_ddjj_detail_ing_egr` WRITE;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjj_detail_ing_egr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_ddjjs`
--

DROP TABLE IF EXISTS `ganan_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ingresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `ingresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `egresos_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `deducciones_total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ganan_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `ganan_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_ddjjs`
--

LOCK TABLES `ganan_ddjjs` WRITE;
/*!40000 ALTER TABLE `ganan_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `ganan_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_deducciones`
--

DROP TABLE IF EXISTS `ganan_deducciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_deducciones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `generales` tinyint(1) NOT NULL DEFAULT '0',
  `particulares` tinyint(1) NOT NULL DEFAULT '0',
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_deducciones`
--

LOCK TABLES `ganan_deducciones` WRITE;
/*!40000 ALTER TABLE `ganan_deducciones` DISABLE KEYS */;
INSERT INTO `ganan_deducciones` VALUES (1,NULL,2017,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(2,NULL,2017,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(3,NULL,2017,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(4,NULL,2017,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(5,NULL,2017,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(6,NULL,2017,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(7,NULL,2017,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(8,NULL,2017,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(9,NULL,2017,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(10,NULL,2017,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(11,NULL,2017,1,0,'Servicio Doméstico',51967.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(12,NULL,2017,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(13,NULL,2017,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:27','2019-11-15 13:24:27',NULL),(14,NULL,2017,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(15,NULL,2017,0,1,'Conyuge',48447.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(16,NULL,2017,0,1,'Hijo Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(17,NULL,2017,0,1,'Hijo Menor 18 años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(18,NULL,2017,0,1,'Hijastro Incapacitado',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(19,NULL,2017,0,1,'Hijastro Menor 18 Años',24432.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(20,NULL,2017,0,1,'Ganancia No Imponible',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(21,NULL,2017,0,1,'Deduccion Especial',51967.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(22,NULL,2018,1,0,'Primas de seguro para el caso de muerte',12000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(23,NULL,2018,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(24,NULL,2018,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(25,NULL,2018,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(26,NULL,2018,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(27,NULL,2018,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(28,NULL,2018,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(29,NULL,2018,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(30,NULL,2018,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (31,NULL,2018,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(32,NULL,2018,1,0,'Servicio Doméstico',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(33,NULL,2018,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(34,NULL,2018,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(35,NULL,2018,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(36,NULL,2018,0,1,'Conyuge',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(37,NULL,2018,0,1,'Hijo Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(38,NULL,2018,0,1,'Hijo Menor 18 años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(39,NULL,2018,0,1,'Hijastro Incapacitado',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(40,NULL,2018,0,1,'Hijastro Menor 18 Años',31461.09,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(41,NULL,2018,0,1,'Ganancia No Imponible',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(42,NULL,2018,0,1,'Deduccion Especial',66917.91,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(43,NULL,2019,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(44,NULL,2019,1,0,'Gastos de Sepelio',999.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(45,NULL,2019,1,0,'Aportes a Obras Sociales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(46,NULL,2019,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(47,NULL,2019,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(48,NULL,2019,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(49,NULL,2019,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(50,NULL,2019,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(51,NULL,2019,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(52,NULL,2019,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(53,NULL,2019,1,0,'Servicio Doméstico',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(54,NULL,2019,1,0,'Donaciones',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(55,NULL,2019,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(56,NULL,2019,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(57,NULL,2019,0,1,'Conyuge',80033.97,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(58,NULL,2019,0,1,'Hijo Incapacitado',40361.43,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(59,NULL,2019,0,1,'Hijo Menor 18 años',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(60,NULL,2019,0,1,'Hijastro Incapacitado',206037.56,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(61,NULL,2019,0,1,'Hijastro Menor 18 Años',0.00,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(62,NULL,2019,0,1,'Ganancia No Imponible',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(63,NULL,2019,0,1,'Deduccion Especial',103018.79,1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
INSERT INTO `ganan_deducciones` VALUES (64,NULL,2016,1,0,'Primas de seguro para el caso de muerte',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(65,NULL,2016,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(66,NULL,2016,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(67,NULL,2016,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(68,NULL,2016,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(69,NULL,2016,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(70,NULL,2016,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(71,NULL,2016,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(72,NULL,2016,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(73,NULL,2016,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(74,NULL,2016,1,0,'Servicio Doméstico',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(75,NULL,2016,1,0,'Donaciones',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(76,NULL,2016,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(77,NULL,2016,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y \n            Paramédica',0.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(78,NULL,2016,0,1,'Conyuge',39778.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(79,NULL,2016,0,1,'Hijo Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(80,NULL,2016,0,1,'Hijo Menor 18 años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(81,NULL,2016,0,1,'Hijastro Incapacitado',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(82,NULL,2016,0,1,'Hijastro Menor 18 Años',19889.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(83,NULL,2016,0,1,'Ganancia No Imponible',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(84,NULL,2016,0,1,'Deduccion Especial',42318.00,1,'2020-01-28 13:48:34','2020-01-28 13:48:34',NULL),(85,NULL,2019,1,0,'Alquileres',103018.97,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(86,NULL,2020,1,0,'Alquileres',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(87,NULL,2020,1,0,'Primas de seguro para el caso de muerte',18000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(88,NULL,2020,1,0,'Gastos de Sepelio',999.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(89,NULL,2020,1,0,'Aportes a Obras Sociales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(90,NULL,2020,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(91,NULL,2020,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(92,NULL,2020,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(93,NULL,2020,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL);
INSERT INTO `ganan_deducciones` VALUES (94,NULL,2020,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(95,NULL,2020,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(96,NULL,2020,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(97,NULL,2020,1,0,'Servicio Doméstico',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(98,NULL,2020,1,0,'Donaciones',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(99,NULL,2020,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(100,NULL,2020,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(101,NULL,2020,0,1,'Conyuge',115471.38,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(102,NULL,2020,0,1,'Hijo Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(103,NULL,2020,0,1,'Hijo Menor 18 años',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(104,NULL,2020,0,1,'Hijastro Incapacitado',58232.65,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(105,NULL,2020,0,1,'Hijastro Menor 18 Años',0.00,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(106,NULL,2020,0,1,'Ganancia No Imponible',123861.17,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(107,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1',103018.79,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(108,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 1 \"Nuevos Profesionales / Emprendedores',309652.93,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(109,NULL,2020,0,1,'Deduccion Especial Art 30 Apartado 2',594533.62,1,'2020-01-28 14:17:39','2020-01-28 14:17:39',NULL),(110,NULL,2021,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(111,NULL,2021,1,0,'Gastos de Sepelio',996.23,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(112,NULL,2021,1,0,'Aportes a Obras Sociales',0.00,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(113,NULL,2021,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(114,NULL,2021,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(115,NULL,2021,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(116,NULL,2021,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(117,NULL,2021,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(118,NULL,2021,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(119,NULL,2021,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(120,NULL,2021,1,0,'Servicio Doméstico',167678.40,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(121,NULL,2021,1,0,'Donaciones',0.00,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(122,NULL,2021,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(123,NULL,2021,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(124,NULL,2021,0,1,'Conyuge',156320.63,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(125,NULL,2021,0,1,'Hijo Menor 18 años',78833.08,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL);
INSERT INTO `ganan_deducciones` VALUES (126,NULL,2021,0,1,'Ganancia No Imponible',167678.40,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(127,NULL,2021,0,1,'Deduccion Especial',804856.34,1,'2021-03-23 19:10:24','2021-03-23 19:10:24',NULL),(128,NULL,2022,1,0,'Primas de seguro para el caso de muerte',24000.00,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(129,NULL,2022,1,0,'Gastos de Sepelio',996.23,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(130,NULL,2022,1,0,'Aportes a Obras Sociales',0.00,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(131,NULL,2022,1,0,'Aportes obligatorios a Fondos de jubilaciones, retiros, pensiones o subsidios a cajas nacionales, provinciales o municipales- incluidas las Cajas de Previsión para Profesionales.',0.00,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(132,NULL,2022,1,0,'Otras deducciones del Anexo III de la RG 2437: Aportes para fondos de Jubilación, Retiros, Pensiones o Subsidios destinados al ANSES',0.00,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(133,NULL,2022,1,0,'Aportes a Cajas Provinciales o Municipales o de Previsión para Profesionales',0.00,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(134,NULL,2022,1,0,'Pagos Régimen Nacional de Trabajadores Autónomos',0.00,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(135,NULL,2022,1,0,'Aportes a Cajas Complementarias de Previsión',0.00,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(136,NULL,2022,1,0,'Aportes a Fondos Compensadores de Previsión',0.00,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(137,NULL,2022,1,0,'Intereses Crédito Hipotecario',20000.00,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(138,NULL,2022,1,0,'Servicio Doméstico',252564.84,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(139,NULL,2022,1,0,'Donaciones',0.00,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(140,NULL,2022,1,0,'Cuota médico asistencial abonado por usted y por sus familiares a cargo',0.00,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(141,NULL,2022,1,0,'Honorarios Correspondientes a los Servicios de asistencia Sanitaria, Médica y Paramédica',0.00,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(142,NULL,2022,1,0,'Alquileres',252564.84,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(143,NULL,2022,0,1,'Conyuge',235457.25,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(144,NULL,2022,0,1,'Hijo Menor 18 años',118741.97,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(145,NULL,2022,0,1,'Ganancia No Imponible',252564.84,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(146,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 2]',1212311.24,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(147,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1]',505129.68,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(148,NULL,2022,0,1,'Deducción Especial [Artículo 30, inciso c), Apartado 1 “nuevos profesionales/emprendedores”]',631412.10,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(149,NULL,2022,0,1,'Hijo Incapacitado',237483.94,1,'2022-01-11 14:07:21','2022-01-11 14:07:21',NULL),(150,NULL,2021,1,0,'Alquileres',167678.40,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ganan_deducciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ganan_tipos_op`
--

DROP TABLE IF EXISTS `ganan_tipos_op`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ganan_tipos_op` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ganan_tipos_op`
--

LOCK TABLES `ganan_tipos_op` WRITE;
/*!40000 ALTER TABLE `ganan_tipos_op` DISABLE KEYS */;
INSERT INTO `ganan_tipos_op` VALUES (1,NULL,'Gravado',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL),(2,NULL,'Exento',1,'2019-11-15 13:24:28','2019-11-15 13:24:28',NULL);
/*!40000 ALTER TABLE `ganan_tipos_op` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iibb_perceptions`
--

DROP TABLE IF EXISTS `iibb_perceptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iibb_perceptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iibb_perceptions`
--

LOCK TABLES `iibb_perceptions` WRITE;
/*!40000 ALTER TABLE `iibb_perceptions` DISABLE KEYS */;
INSERT INTO `iibb_perceptions` VALUES (1,NULL,NULL,NULL,'IIBB CABA','IIBBCABA'),(2,NULL,NULL,NULL,'IIBB Bs. As.','IIBBBSAS'),(3,NULL,NULL,NULL,'Percepcion IIBB Tucuman','IIBBTucuman'),(4,NULL,NULL,NULL,'Perc IIBB Misiones','IIBBMisiones'),(5,NULL,NULL,NULL,'Perc IIBB Cordoba','IIBBCba'),(6,NULL,NULL,NULL,'Pec IIBB La Pampa','IIBB La Pampa'),(7,NULL,NULL,NULL,'Perc IIBB Rio Negro','IIBB Rio Negro'),(8,NULL,NULL,NULL,'Perc IIBB Corrientes','IIIBB Corrientes'),(9,NULL,NULL,NULL,'Perc IIBB Santiago del Estero','IIBBSantiago');
/*!40000 ALTER TABLE `iibb_perceptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_combos`
--

DROP TABLE IF EXISTS `inv_combos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_combos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `inv_product_combo_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `cantidades` int(11) NOT NULL,
  `codigo_interno` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_combos_inv_product_combo_id_foreign` (`inv_product_combo_id`),
  KEY `inv_combos_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_combos_inv_product_combo_id_foreign` FOREIGN KEY (`inv_product_combo_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_combos_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_combos`
--

LOCK TABLES `inv_combos` WRITE;
/*!40000 ALTER TABLE `inv_combos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_combos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock`
--

DROP TABLE IF EXISTS `inv_control_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_control_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock`
--

LOCK TABLES `inv_control_stock` WRITE;
/*!40000 ALTER TABLE `inv_control_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_control_stock_detail`
--

DROP TABLE IF EXISTS `inv_control_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_control_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_control_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `stock_actual` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_real` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_diferencia` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_control_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_control_stock_detail_inv_control_stock_id_foreign` (`inv_control_stock_id`),
  KEY `inv_control_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_control_stock_detail_inv_control_stock_id_foreign` FOREIGN KEY (`inv_control_stock_id`) REFERENCES `inv_control_stock` (`id`),
  CONSTRAINT `inv_control_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_control_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_control_stock_detail`
--

LOCK TABLES `inv_control_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_control_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_control_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores`
--

DROP TABLE IF EXISTS `inv_indicadores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metodo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `orden` int(10) unsigned NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores`
--

LOCK TABLES `inv_indicadores` WRITE;
/*!40000 ALTER TABLE `inv_indicadores` DISABLE KEYS */;
INSERT INTO `inv_indicadores` VALUES (1,NULL,'Datos Grales','datos_grales','card_info',5,1,NULL,'2022-05-19 22:15:24',NULL),(2,NULL,'Impuestos Asociados','impuestos_asociados','card_info',6,1,NULL,'2022-05-19 22:15:24',NULL),(3,NULL,'Informacion de Liquidacion','informacion_de_liquidacion','card_info',7,1,NULL,'2022-05-19 22:15:24',NULL),(4,NULL,'Cantidad Ventas del Mes','cantidad_ventas_del_mes','card',1,1,NULL,'2022-05-19 22:15:24',NULL),(5,NULL,'Total Facturado En El Mes','total_facturado_en_el_mes','card',2,1,NULL,'2022-05-19 22:15:24',NULL),(6,NULL,'Total Facturado En El Dia','total_facturado_en_el_dia','card',3,1,NULL,'2022-05-19 22:15:24',NULL),(7,NULL,'Total Facturado En El Año','total_facturado_en_el_anio','card',4,1,NULL,'2022-05-19 22:15:24',NULL),(8,NULL,'Facturacion Mensual','facturacion_mensual','grafico',8,1,NULL,'2022-05-19 22:15:24',NULL),(9,NULL,'Proyeccion de Ganancias','proyeccion_de_ganancias','tabla',9,1,NULL,'2022-05-19 22:15:24',NULL),(10,NULL,'Posicion IVA','posicion_de_iva','tabla',10,1,NULL,'2022-05-19 22:15:24',NULL);
/*!40000 ALTER TABLE `inv_indicadores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_indicadores_persons`
--

DROP TABLE IF EXISTS `inv_indicadores_persons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_indicadores_persons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_indicador_id` bigint(20) unsigned NOT NULL,
  `objetivo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_indicadores_persons_person_id_foreign` (`person_id`),
  KEY `inv_indicadores_persons_inv_indicador_id_foreign` (`inv_indicador_id`),
  CONSTRAINT `inv_indicadores_persons_inv_indicador_id_foreign` FOREIGN KEY (`inv_indicador_id`) REFERENCES `inv_indicadores` (`id`),
  CONSTRAINT `inv_indicadores_persons_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_indicadores_persons`
--

LOCK TABLES `inv_indicadores_persons` WRITE;
/*!40000 ALTER TABLE `inv_indicadores_persons` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_indicadores_persons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_ing_egr_stock_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock`
--

LOCK TABLES `inv_ing_egr_stock` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ing_egr_stock_detail`
--

DROP TABLE IF EXISTS `inv_ing_egr_stock_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ing_egr_stock_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_ing_egr_stock_id` bigint(20) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `sumar1_restar0` tinyint(1) NOT NULL DEFAULT '1',
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ing_egr_stock_detail_person_id_foreign` (`person_id`),
  KEY `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` (`inv_ing_egr_stock_id`),
  KEY `inv_ing_egr_stock_detail_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_ing_egr_stock_id_foreign` FOREIGN KEY (`inv_ing_egr_stock_id`) REFERENCES `inv_ing_egr_stock` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_ing_egr_stock_detail_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ing_egr_stock_detail`
--

LOCK TABLES `inv_ing_egr_stock_detail` WRITE;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ing_egr_stock_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_lista_de_precios`
--

DROP TABLE IF EXISTS `inv_lista_de_precios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_lista_de_precios` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `porcentaje_descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_lista_de_precios_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_lista_de_precios_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_lista_de_precios`
--

LOCK TABLES `inv_lista_de_precios` WRITE;
/*!40000 ALTER TABLE `inv_lista_de_precios` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_lista_de_precios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_config_cc`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_config_cc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_config_cc` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `horas_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `horas_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `gastos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `productos_contra_conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `asiento_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_horas_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_gastos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `asiento_contra_productos_cpc_id` int(10) unsigned NOT NULL DEFAULT '217',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_config_cc_person_id_foreign` (`person_id`),
  KEY `hcc_id_foreign` (`horas_conta_plan_cuenta_id`),
  KEY `gcc_id_foreign` (`gastos_conta_plan_cuenta_id`),
  KEY `pcc_id_foreign` (`productos_conta_plan_cuenta_id`),
  KEY `h_contra_cc_id_foreign` (`horas_contra_conta_plan_cuenta_id`),
  KEY `g_contra_cc_id_foreign` (`gastos_contra_conta_plan_cuenta_id`),
  KEY `p_contra_cc_id_foreign` (`productos_contra_conta_plan_cuenta_id`),
  KEY `ahcc_id_foreign` (`asiento_horas_cpc_id`),
  KEY `agcc_id_foreign` (`asiento_gastos_cpc_id`),
  KEY `apcc_id_foreign` (`asiento_productos_cpc_id`),
  KEY `ah_contra_cc_id_foreign` (`asiento_contra_horas_cpc_id`),
  KEY `ag_contra_cc_id_foreign` (`asiento_contra_gastos_cpc_id`),
  KEY `ap_contra_cc_id_foreign` (`asiento_contra_productos_cpc_id`),
  CONSTRAINT `ag_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `agcc_id_foreign` FOREIGN KEY (`asiento_gastos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ah_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ahcc_id_foreign` FOREIGN KEY (`asiento_horas_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `ap_contra_cc_id_foreign` FOREIGN KEY (`asiento_contra_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `apcc_id_foreign` FOREIGN KEY (`asiento_productos_cpc_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `g_contra_cc_id_foreign` FOREIGN KEY (`gastos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `gcc_id_foreign` FOREIGN KEY (`gastos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `h_contra_cc_id_foreign` FOREIGN KEY (`horas_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `hcc_id_foreign` FOREIGN KEY (`horas_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `inv_orden_trabajo_config_cc_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `p_contra_cc_id_foreign` FOREIGN KEY (`productos_contra_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `pcc_id_foreign` FOREIGN KEY (`productos_conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_config_cc`
--

LOCK TABLES `inv_orden_trabajo_config_cc` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_config_cc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_facturada`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_facturada`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_facturada` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `fact_elec_receipt_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_facturada_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_facturada_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_facturada_fact_elec_receipt_id_foreign` (`fact_elec_receipt_id`),
  CONSTRAINT `inv_orden_trabajo_facturada_fact_elec_receipt_id_foreign` FOREIGN KEY (`fact_elec_receipt_id`) REFERENCES `fact_elec_receipts` (`id`),
  CONSTRAINT `inv_orden_trabajo_facturada_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_facturada_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_facturada`
--

LOCK TABLES `inv_orden_trabajo_facturada` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_facturada` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_facturada` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_gastos_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-04-28 01:14:01',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_gastos_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `inv_orden_trabajo_gastos_receipt_id_foreign` (`receipt_id`),
  KEY `i_o_t_g_t_id_foreign` (`inv_orden_trabajo_gastos_tipo_id`),
  KEY `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `i_o_t_g_t_id_foreign` FOREIGN KEY (`inv_orden_trabajo_gastos_tipo_id`) REFERENCES `inv_orden_trabajo_gastos_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_gastos_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos`
--

LOCK TABLES `inv_orden_trabajo_gastos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_gastos_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_gastos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_gastos_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_gastos_tipos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_gastos_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_gastos_tipos`
--

LOCK TABLES `inv_orden_trabajo_gastos_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_gastos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_orden_trabajo_horas_tipo_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-04-28 01:14:01',
  `syj_empleado_id` int(10) unsigned DEFAULT NULL,
  `cantidad` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` (`inv_orden_trabajo_horas_tipo_id`),
  KEY `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_horas_syj_empleado_id_foreign` (`syj_empleado_id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_horas_tipo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_horas_tipo_id`) REFERENCES `inv_orden_trabajo_horas_tipos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajo_horas_syj_empleado_id_foreign` FOREIGN KEY (`syj_empleado_id`) REFERENCES `syj_empleados` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas`
--

LOCK TABLES `inv_orden_trabajo_horas` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_horas_tipos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_horas_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_horas_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_horas_tipos_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_orden_trabajo_horas_tipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_horas_tipos`
--

LOCK TABLES `inv_orden_trabajo_horas_tipos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_horas_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajo_productos`
--

DROP TABLE IF EXISTS `inv_orden_trabajo_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajo_productos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `inv_producto_id` bigint(20) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-04-28 01:14:01',
  `cantidades` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajo_productos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajo_productos_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  KEY `inv_orden_trabajo_productos_inv_producto_id_foreign` (`inv_producto_id`),
  CONSTRAINT `inv_orden_trabajo_productos_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_inv_producto_id_foreign` FOREIGN KEY (`inv_producto_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_orden_trabajo_productos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajo_productos`
--

LOCK TABLES `inv_orden_trabajo_productos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajo_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajo_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_orden_trabajos`
--

DROP TABLE IF EXISTS `inv_orden_trabajos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_orden_trabajos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned DEFAULT NULL,
  `fecha` datetime NOT NULL DEFAULT '2022-04-28 01:14:01',
  `numero` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `titulo` text COLLATE utf8mb4_unicode_ci,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `cerrada` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_orden_trabajos_person_id_foreign` (`person_id`),
  KEY `inv_orden_trabajos_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `inv_orden_trabajos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_orden_trabajos_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_orden_trabajos`
--

LOCK TABLES `inv_orden_trabajos` WRITE;
/*!40000 ALTER TABLE `inv_orden_trabajos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_orden_trabajos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_product_receipt`
--

DROP TABLE IF EXISTS `inv_product_receipt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_product_receipt` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `type_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `receiptable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `receiptable_id` int(10) unsigned NOT NULL,
  `cantidades` decimal(16,2) NOT NULL,
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descuento_por1_imp0` tinyint(1) NOT NULL DEFAULT '1',
  `descuento_porcentaje` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_con_descuento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_product_receipt_type_id_foreign` (`type_id`),
  KEY `inv_product_receipt_person_id_foreign` (`person_id`),
  KEY `inv_product_receipt_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_product_receipt_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_product_receipt_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_product_receipt_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_product_receipt`
--

LOCK TABLES `inv_product_receipt` WRITE;
/*!40000 ALTER TABLE `inv_product_receipt` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_product_receipt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_productos`
--

DROP TABLE IF EXISTS `inv_productos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_productos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `inv_producto_tipo_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `person_id` int(10) unsigned NOT NULL,
  `person_prov_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_externo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `codigo_interno` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fac_ele_unidad_medida_id` int(10) unsigned NOT NULL DEFAULT '8',
  `inv_rubro_sub_id` bigint(20) unsigned NOT NULL,
  `inv_ubicacion_id` bigint(20) unsigned DEFAULT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `margen` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `system_tax_id` int(10) unsigned DEFAULT NULL,
  `iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `inv_lista_de_precio_id` bigint(20) unsigned DEFAULT NULL,
  `foto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stock` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock_minimo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_productos_person_id_foreign` (`person_id`),
  KEY `inv_productos_person_prov_id_foreign` (`person_prov_id`),
  KEY `inv_productos_fac_ele_unidad_medida_id_foreign` (`fac_ele_unidad_medida_id`),
  KEY `inv_productos_inv_rubro_sub_id_foreign` (`inv_rubro_sub_id`),
  KEY `inv_productos_inv_ubicacion_id_foreign` (`inv_ubicacion_id`),
  KEY `inv_productos_system_tax_id_foreign` (`system_tax_id`),
  KEY `inv_productos_inv_lista_de_precio_id_foreign` (`inv_lista_de_precio_id`),
  KEY `inv_productos_inv_producto_tipo_id_foreign` (`inv_producto_tipo_id`),
  KEY `inv_productos_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `inv_productos_fac_ele_unidad_medida_id_foreign` FOREIGN KEY (`fac_ele_unidad_medida_id`) REFERENCES `fac_elec_unidad_medidas` (`id`),
  CONSTRAINT `inv_productos_inv_lista_de_precio_id_foreign` FOREIGN KEY (`inv_lista_de_precio_id`) REFERENCES `inv_lista_de_precios` (`id`),
  CONSTRAINT `inv_productos_inv_producto_tipo_id_foreign` FOREIGN KEY (`inv_producto_tipo_id`) REFERENCES `inv_productos_tipos` (`id`),
  CONSTRAINT `inv_productos_inv_rubro_sub_id_foreign` FOREIGN KEY (`inv_rubro_sub_id`) REFERENCES `inv_rubros_sub` (`id`),
  CONSTRAINT `inv_productos_inv_ubicacion_id_foreign` FOREIGN KEY (`inv_ubicacion_id`) REFERENCES `inv_ubicaciones` (`id`),
  CONSTRAINT `inv_productos_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `inv_productos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_productos_person_prov_id_foreign` FOREIGN KEY (`person_prov_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `inv_productos_system_tax_id_foreign` FOREIGN KEY (`system_tax_id`) REFERENCES `system_taxes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_productos`
--

LOCK TABLES `inv_productos` WRITE;
/*!40000 ALTER TABLE `inv_productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_productos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_productos_tipos`
--

DROP TABLE IF EXISTS `inv_productos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_productos_tipos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_productos_tipos`
--

LOCK TABLES `inv_productos_tipos` WRITE;
/*!40000 ALTER TABLE `inv_productos_tipos` DISABLE KEYS */;
INSERT INTO `inv_productos_tipos` VALUES (1,NULL,'Unitario',1,NULL,NULL,NULL),(2,NULL,'Combo',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `inv_productos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_rubros`
--

DROP TABLE IF EXISTS `inv_rubros`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_rubros` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_rubros_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_rubros_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_rubros`
--

LOCK TABLES `inv_rubros` WRITE;
/*!40000 ALTER TABLE `inv_rubros` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_rubros` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_rubros_sub`
--

DROP TABLE IF EXISTS `inv_rubros_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_rubros_sub` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_rubro_id` bigint(20) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_rubros_sub_person_id_foreign` (`person_id`),
  KEY `inv_rubros_sub_inv_rubro_id_foreign` (`inv_rubro_id`),
  CONSTRAINT `inv_rubros_sub_inv_rubro_id_foreign` FOREIGN KEY (`inv_rubro_id`) REFERENCES `inv_rubros` (`id`),
  CONSTRAINT `inv_rubros_sub_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_rubros_sub`
--

LOCK TABLES `inv_rubros_sub` WRITE;
/*!40000 ALTER TABLE `inv_rubros_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_rubros_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_stock_movimientos`
--

DROP TABLE IF EXISTS `inv_stock_movimientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_stock_movimientos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `inv_product_id` bigint(20) unsigned NOT NULL,
  `movimiento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `stock` decimal(16,2) NOT NULL DEFAULT '0.00',
  `costo` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_sin_iva` decimal(16,2) NOT NULL DEFAULT '0.00',
  `precio_final` decimal(16,2) NOT NULL DEFAULT '0.00',
  `transactionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transactionable_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_morph` (`transactionable_type`,`transactionable_id`),
  KEY `inv_stock_movimientos_person_id_foreign` (`person_id`),
  KEY `inv_stock_movimientos_inv_product_id_foreign` (`inv_product_id`),
  CONSTRAINT `inv_stock_movimientos_inv_product_id_foreign` FOREIGN KEY (`inv_product_id`) REFERENCES `inv_productos` (`id`),
  CONSTRAINT `inv_stock_movimientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_stock_movimientos`
--

LOCK TABLES `inv_stock_movimientos` WRITE;
/*!40000 ALTER TABLE `inv_stock_movimientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_stock_movimientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inv_ubicaciones`
--

DROP TABLE IF EXISTS `inv_ubicaciones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inv_ubicaciones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inv_ubicaciones_person_id_foreign` (`person_id`),
  CONSTRAINT `inv_ubicaciones_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inv_ubicaciones`
--

LOCK TABLES `inv_ubicaciones` WRITE;
/*!40000 ALTER TABLE `inv_ubicaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `inv_ubicaciones` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_agrupacion`
--

DROP TABLE IF EXISTS `iva_agrupacion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_agrupacion` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `ordr` int(11) NOT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_agrupacion`
--

LOCK TABLES `iva_agrupacion` WRITE;
/*!40000 ALTER TABLE `iva_agrupacion` DISABLE KEYS */;
INSERT INTO `iva_agrupacion` VALUES (1,1,1,0.00,'Operaciones con Responsables Inscriptos',1,NULL,NULL,NULL),(2,1,2,0.00,'Operaciones con Consumidores finales, Exentos y No alcanzados',1,NULL,NULL,NULL),(3,1,3,0.00,'Operaciones no gravadas y exentas',1,NULL,NULL,NULL),(4,1,4,0.00,'Credito fiscal a restituir',1,NULL,NULL,NULL),(5,2,5,0.00,'Debito fiscal a restituir',1,NULL,NULL,NULL),(6,2,6,0.00,'Total Credito Fiscal',1,NULL,NULL,NULL),(7,2,7,0.00,'Total Operaciones que no Generan Credito Fiscal',1,NULL,NULL,NULL),(8,1,8,0.00,'Operaciones con Monotributistas - Regimen Simmplificado',1,'2022-03-18 08:40:59','2022-03-18 08:40:59',NULL);
/*!40000 ALTER TABLE `iva_agrupacion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_conditions`
--

DROP TABLE IF EXISTS `iva_conditions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_conditions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `iva_conditions_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_conditions`
--

LOCK TABLES `iva_conditions` WRITE;
/*!40000 ALTER TABLE `iva_conditions` DISABLE KEYS */;
INSERT INTO `iva_conditions` VALUES (1,'Monotributo',NULL,NULL),(2,'Responsable Inscripto',NULL,NULL),(3,'Otro',NULL,NULL);
/*!40000 ALTER TABLE `iva_conditions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iva_creditos_tipos`
--

DROP TABLE IF EXISTS `iva_creditos_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `iva_creditos_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iva_creditos_tipos`
--

LOCK TABLES `iva_creditos_tipos` WRITE;
/*!40000 ALTER TABLE `iva_creditos_tipos` DISABLE KEYS */;
INSERT INTO `iva_creditos_tipos` VALUES (1,0,'Compras de bienes (excepto bienes de uso)',0.00,1,NULL,NULL,NULL),(2,0,'Locaciones',0.00,1,NULL,NULL,NULL),(3,0,'Prestaciones de servicios',0.00,1,NULL,NULL,NULL),(4,0,'Inversiones de Bienes de Uso',0.00,1,NULL,NULL,NULL),(5,0,'Compras de bienes usados a consumidores finales',0.00,1,NULL,NULL,NULL),(6,0,'Tur IVA',0.00,1,NULL,NULL,NULL),(7,0,'Contribuciones de la Seguridad Social',0.00,1,NULL,NULL,NULL),(8,0,'Contribuciones de la Seguridad Social - Artículo 91 Ley 27.467',0.00,1,NULL,NULL,NULL),(9,0,'Otros Conceptos',0.00,1,NULL,NULL,NULL),(10,0,'Compras de Bienes en el Exterior',0.00,1,NULL,NULL,NULL),(11,0,'Compras de Servicios en el exterior - Impuesto ingresado a través de entidades Financieras',0.00,1,NULL,NULL,NULL),(12,0,'Compras de Servicios en el exterior - Impuesto ingresado por el responsable',0.00,1,NULL,NULL,NULL),(13,0,'Locaciones o prestaciones gravadas en el país realizadas por sujetos del exterior - Impuesto ingresado a través de entidades Financieras',0.00,1,NULL,NULL,NULL),(14,0,'Régimen especial de compensación para la estabilización de precios - Emergencia alimentaria - Ley 27.519',0.00,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `iva_creditos_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  `base_de_dato` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `liquidators`
--

DROP TABLE IF EXISTS `liquidators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `liquidators` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `liquidators_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `liquidators`
--

LOCK TABLES `liquidators` WRITE;
/*!40000 ALTER TABLE `liquidators` DISABLE KEYS */;
INSERT INTO `liquidators` VALUES (1,NULL,'Florencia',NULL,NULL,NULL),(2,NULL,'Jose Luis',NULL,NULL,NULL),(3,NULL,'Elizabet',NULL,NULL,NULL),(4,NULL,'Graciela',NULL,NULL,NULL),(5,NULL,'Agustina',NULL,NULL,NULL),(6,NULL,'Betty',NULL,NULL,NULL),(7,NULL,'Hernan',NULL,NULL,NULL);
/*!40000 ALTER TABLE `liquidators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `localidad`
--

DROP TABLE IF EXISTS `localidad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `localidad` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `zone_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `localidad_descripcion_unique` (`descripcion`),
  KEY `localidad_zone_id_foreign` (`zone_id`),
  CONSTRAINT `localidad_zone_id_foreign` FOREIGN KEY (`zone_id`) REFERENCES `zones` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `localidad`
--

LOCK TABLES `localidad` WRITE;
/*!40000 ALTER TABLE `localidad` DISABLE KEYS */;
INSERT INTO `localidad` VALUES (1,NULL,22,'Capital Federal',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(2,NULL,23,'Vicente Lopez',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(3,NULL,23,'San Isidro',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(4,NULL,23,'Lomas del Mirador',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(5,NULL,23,'Avellaneda',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(6,NULL,23,'Saenz Peña',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(7,NULL,23,'Caseros',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(8,NULL,23,'Moron',1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL),(9,3598,1,'Villa Maria',1,'2021-08-23 11:16:42','2021-08-23 11:16:42',NULL);
/*!40000 ALTER TABLE `localidad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `log_debug`
--

DROP TABLE IF EXISTS `log_debug`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_debug` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `function_name` varchar(255) DEFAULT NULL,
  `message` varchar(255) DEFAULT NULL,
  `date` datetime DEFAULT CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15061 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `log_debug`
--

LOCK TABLES `log_debug` WRITE;
/*!40000 ALTER TABLE `log_debug` DISABLE KEYS */;
INSERT INTO `log_debug` VALUES (1,NULL,'assingMorePeriods','ejecutando funcion','2018-06-06 12:58:53',NULL),(2,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->2, periodo->2018-5','2018-06-06 12:58:53',NULL),(3,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(4,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(5,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(6,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(7,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(8,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(9,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(10,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(11,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(12,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(13,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(14,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(15,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(16,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->3, periodo->2018-5','2018-06-06 12:58:53',NULL),(17,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(18,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(19,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(20,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(21,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(22,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(23,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(24,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(25,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(26,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(27,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(28,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(29,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(30,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->5, periodo->2018-5','2018-06-06 12:58:53',NULL),(31,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(32,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(33,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(34,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (35,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(36,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(37,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(38,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(39,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(40,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(41,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(42,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(43,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(44,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->96, periodo->2018-5','2018-06-06 12:58:53',NULL),(45,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(46,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(47,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(48,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(49,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(50,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(51,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(52,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(53,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(54,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(55,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(56,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(57,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(58,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->338, periodo->2018-5','2018-06-06 12:58:53',NULL),(59,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(60,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(61,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(62,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(63,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(64,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(65,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(66,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(67,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (68,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(69,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(70,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(71,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(72,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->435, periodo->2018-5','2018-06-06 12:58:53',NULL),(73,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(74,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(75,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(76,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(77,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(78,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(79,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(80,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(81,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(82,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(83,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(84,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(85,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(86,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->436, periodo->2018-5','2018-06-06 12:58:53',NULL),(87,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(88,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(89,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(90,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(91,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(92,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(93,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(94,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(95,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(96,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(97,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(98,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(99,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(100,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->448, periodo->2018-5','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (101,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(102,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(103,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(104,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(105,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(106,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(107,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(108,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(109,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(110,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(111,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(112,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(113,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(114,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->639, periodo->2018-5','2018-06-06 12:58:53',NULL),(115,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(116,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(117,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(118,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(119,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(120,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(121,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(122,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(123,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(124,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(125,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(126,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(127,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(128,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->640, periodo->2018-5','2018-06-06 12:58:53',NULL),(129,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(130,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(131,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(132,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(133,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (134,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(135,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(136,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(137,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(138,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(139,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(140,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(141,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(142,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->673, periodo->2018-5','2018-06-06 12:58:53',NULL),(143,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(144,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(145,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(146,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(147,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(148,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(149,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(150,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(151,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(152,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL),(153,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(154,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(155,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(156,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->784, periodo->2018-5','2018-06-06 12:58:53',NULL),(157,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(158,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(159,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(160,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(161,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:53',NULL),(162,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:53',NULL),(163,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:53',NULL),(164,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:53',NULL),(165,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:53',NULL),(166,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:53',NULL);
INSERT INTO `log_debug` VALUES (167,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:53',NULL),(168,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:53',NULL),(169,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:53',NULL),(170,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1479, periodo->2018-5','2018-06-06 12:58:53',NULL),(171,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:53',NULL),(172,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:53',NULL),(173,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:53',NULL),(174,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:53',NULL),(175,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(176,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(177,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(178,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(179,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(180,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(181,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(182,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(183,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(184,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1634, periodo->2018-5','2018-06-06 12:58:54',NULL),(185,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(186,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(187,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(188,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(189,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(190,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(191,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(192,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(193,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(194,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(195,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(196,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(197,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(198,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1717, periodo->2018-5','2018-06-06 12:58:54',NULL),(199,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (200,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(201,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(202,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(203,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(204,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(205,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(206,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(207,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(208,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(209,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(210,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(211,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(212,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1729, periodo->2018-5','2018-06-06 12:58:54',NULL),(213,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(214,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(215,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(216,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(217,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(218,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(219,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(220,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(221,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(222,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(223,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(224,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(225,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(226,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1736, periodo->2018-5','2018-06-06 12:58:54',NULL),(227,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(228,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(229,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(230,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(231,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(232,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (233,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(234,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(235,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(236,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(237,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(238,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(239,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(240,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1845, periodo->2018-5','2018-06-06 12:58:54',NULL),(241,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(242,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(243,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(244,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(245,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(246,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(247,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(248,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(249,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(250,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(251,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(252,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(253,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(254,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1859, periodo->2018-5','2018-06-06 12:58:54',NULL),(255,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(256,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(257,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(258,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(259,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(260,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(261,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(262,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(263,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(264,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(265,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (266,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(267,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(268,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1865, periodo->2018-5','2018-06-06 12:58:54',NULL),(269,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(270,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(271,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(272,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(273,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(274,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(275,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(276,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(277,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(278,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(279,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(280,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(281,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(282,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1870, periodo->2018-5','2018-06-06 12:58:54',NULL),(283,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(284,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(285,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(286,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(287,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(288,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(289,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(290,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(291,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(292,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(293,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(294,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(295,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(296,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1979, periodo->2018-5','2018-06-06 12:58:54',NULL),(297,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(298,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (299,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(300,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(301,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(302,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(303,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(304,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(305,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(306,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(307,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(308,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(309,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(310,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1990, periodo->2018-5','2018-06-06 12:58:54',NULL),(311,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(312,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(313,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(314,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(315,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(316,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(317,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(318,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(319,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(320,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(321,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(322,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(323,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(324,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1991, periodo->2018-5','2018-06-06 12:58:54',NULL),(325,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(326,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(327,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(328,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(329,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(330,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(331,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (332,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(333,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(334,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(335,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(336,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(337,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(338,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1992, periodo->2018-5','2018-06-06 12:58:54',NULL),(339,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(340,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(341,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(342,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(343,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(344,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(345,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(346,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(347,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(348,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(349,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(350,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL),(351,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(352,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1993, periodo->2018-5','2018-06-06 12:58:54',NULL),(353,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(354,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(355,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(356,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(357,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(358,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(359,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(360,NULL,'assingMorePeriods','While de empresa, year->2025, initial_month->1, contador->7','2018-06-06 12:58:54',NULL),(361,NULL,'assingMorePeriods','While de empresa, year->2026, initial_month->1, contador->8','2018-06-06 12:58:54',NULL),(362,NULL,'assingMorePeriods','While de empresa, year->2027, initial_month->1, contador->9','2018-06-06 12:58:54',NULL),(363,NULL,'assingMorePeriods','While de empresa, year->2028, initial_month->1, contador->10','2018-06-06 12:58:54',NULL),(364,NULL,'assingMorePeriods','While de empresa, year->2029, initial_month->1, contador->11','2018-06-06 12:58:54',NULL);
INSERT INTO `log_debug` VALUES (365,NULL,'assingMorePeriods','While de empresa, year->2030, initial_month->1, contador->12','2018-06-06 12:58:54',NULL),(366,NULL,'assingMorePeriods','Iterando cada empresa, Empres id->1994, periodo->2018-5','2018-06-06 12:58:54',NULL),(367,NULL,'assingMorePeriods','While de empresa, year->2018, initial_month->6, contador->0','2018-06-06 12:58:54',NULL),(368,NULL,'assingMorePeriods','While de empresa, year->2019, initial_month->6, contador->1','2018-06-06 12:58:54',NULL),(369,NULL,'assingMorePeriods','While de empresa, year->2020, initial_month->1, contador->2','2018-06-06 12:58:54',NULL),(370,NULL,'assingMorePeriods','While de empresa, year->2021, initial_month->1, contador->3','2018-06-06 12:58:54',NULL),(371,NULL,'assingMorePeriods','While de empresa, year->2022, initial_month->1, contador->4','2018-06-06 12:58:54',NULL),(372,NULL,'assingMorePeriods','While de empresa, year->2023, initial_month->1, contador->5','2018-06-06 12:58:54',NULL),(373,NULL,'assingMorePeriods','While de empresa, year->2024, initial_month->1, contador->6','2018-06-06 12:58:54',NULL),(374,NULL,'assingMorePeriods','While de empresa, year->2025, initial_mon