-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db23-38319643-4
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-11-22 10:04:08','Actividad Generica 1','000001',NULL),(2,NULL,'2022-11-22 10:04:08','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,'2023-02-19 11:42:13','Construcción, reforma y reparación de edificios residenciales','410011','410011'),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,'2023-02-19 11:30:45','Venta al por menor de indumentaria deportiva','477140','477140'),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL);
INSERT INTO `activities` VALUES (615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL),(616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL);
INSERT INTO `activities` VALUES (656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL),(657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL);
INSERT INTO `activities` VALUES (701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL),(702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL);
INSERT INTO `activities` VALUES (749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL),(751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL);
INSERT INTO `activities` VALUES (793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL),(795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL);
INSERT INTO `activities` VALUES (833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL),(835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,'2023-02-19 11:58:15','Obtención y dotación de personal','780000','970000'),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL);
INSERT INTO `activities` VALUES (882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL),(884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL);
INSERT INTO `activities` VALUES (928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL),(930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,'2023-02-19 11:41:44','Servicios de hogares privados que contratan servicio doméstico','970000','780009'),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,'AFIP','Santiago2022',NULL,1,40741,'2022-12-20'),(2,'AFIP','Santiago2022',NULL,1,40741,'2022-12-20'),(3,'AFIP','Santiago2022',NULL,1,40741,'2022-12-20'),(4,'AFIP','Santiago2022',NULL,1,40741,'2022-12-20'),(5,NULL,'Asdfgh3740',NULL,1,40856,'2023-01-06'),(6,NULL,'Asesoria2022',NULL,1,40774,'2023-01-19'),(7,NULL,'Cabrera2023',NULL,1,40775,'2023-01-19'),(8,NULL,'Cabrera2023',NULL,1,40775,'2023-01-23'),(9,NULL,'Asesoria2023',NULL,1,40767,'2023-02-19'),(10,NULL,'Asesoria2023',NULL,1,40767,'2023-02-19'),(11,NULL,'Asesoria2023',NULL,1,40767,'2023-02-19'),(12,NULL,'Asesoria2023',NULL,1,40767,'2023-02-19'),(13,NULL,'Asesoria2023',NULL,1,40767,'2023-02-19'),(14,NULL,'Asesoria2023',NULL,1,40767,'2023-02-19'),(15,NULL,'Asesoria2023',NULL,1,40767,'2023-02-19'),(16,NULL,'Cabrera2023',NULL,1,40775,'2023-02-19'),(17,NULL,'Cabrera2023',NULL,1,40775,'2023-02-19'),(18,NULL,'Cabrera2023',NULL,1,40775,'2023-02-19'),(19,NULL,'Cabrera2023',NULL,1,40775,'2023-02-19'),(20,NULL,'Cabrera2023',NULL,1,40775,'2023-02-19'),(21,NULL,'Asesoria2023',NULL,1,40767,'2023-02-19'),(22,NULL,'Asesoria2023',NULL,1,40767,'2023-02-19'),(23,NULL,'Asesoria2023',NULL,1,40767,'2023-02-19'),(24,NULL,'Asesoria2023',NULL,1,40767,'2023-02-22'),(25,NULL,'Asesoria2023',NULL,1,40767,'2023-02-22'),(26,NULL,'Asesoria2023',NULL,1,40767,'2023-02-22'),(27,NULL,'Asesoria2023',NULL,1,40767,'2023-02-22'),(28,NULL,'Cabrera2023',NULL,1,40775,'2023-02-28'),(29,NULL,'Cabrera2023',NULL,1,40775,'2023-02-28'),(30,NULL,'Luciano2020',NULL,3,40775,'2023-02-28');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'pantexconfecciones@gmail.com',NULL,'OSVALDO',1,40720,'2022-11-23'),(2,'very1978@hotmail.com',NULL,'VERO',2,40720,'2022-11-23'),(3,'pantexconfecciones@gmail.com',NULL,'OSVALDO',1,40720,'2022-12-20'),(4,'very1978@hotmail.com',NULL,'VERO',2,40720,'2022-12-20'),(5,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-01-03'),(6,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-01-03'),(7,'lylcell082019@gmail.com','01150940812','',1,40774,'2023-01-19'),(8,'lylcell082019@gmail.com','01150940812',NULL,1,40774,'2023-01-19'),(9,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-19'),(10,'nahirnathaliagarrido@gmail.com','01176073115',NULL,1,40767,'2023-02-19'),(11,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-19'),(12,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-19'),(13,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-19'),(14,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-19'),(15,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-19'),(16,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-19'),(17,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-19'),(18,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-19'),(19,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-19'),(20,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-22'),(21,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-22'),(22,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-22'),(23,'nahirnathaliagarrido@gmail.com','01176073115','',1,40767,'2023-02-22');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1415 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,8119,40741,3350,2,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1409589.00,NULL,NULL,1,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(2,8119,40741,3350,2,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',1725742.60,NULL,NULL,1,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(3,8119,40741,3350,2,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',289995.70,NULL,NULL,1,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(4,8119,40741,3350,2,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',73652.20,NULL,NULL,1,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(5,8119,40741,3350,3,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',9429.00,NULL,NULL,1,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(6,8119,40741,3350,3,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',849082.00,NULL,NULL,1,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(7,8119,40741,3350,3,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',24822.72,NULL,NULL,1,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(8,8119,40741,3350,3,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',29193.98,NULL,NULL,1,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(9,8119,40741,3350,3,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',112052.44,NULL,NULL,1,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(10,8119,40741,3350,3,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',77915.76,NULL,NULL,1,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(11,8119,40741,3350,3,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',1042151.87,NULL,NULL,1,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(12,8119,40741,3350,3,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1266736.05,NULL,NULL,1,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(13,8119,40741,3350,3,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',679858.98,NULL,NULL,1,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(14,8119,40741,3350,3,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',193131.69,NULL,NULL,1,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(15,8119,40741,3350,16,NULL,11,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',0.00,NULL,NULL,1,'2022-12-19 21:21:05','2022-12-19 21:22:07','2022-12-19 21:22:07'),(16,8119,40720,1543,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',157763.43,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(17,8119,40720,1543,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',231594.00,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(18,8119,40720,1543,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',233510.64,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(19,8119,40720,1543,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',225550.05,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(20,8119,40720,1543,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',223698.75,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(21,8119,40720,1543,2,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',159200.91,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(22,8119,40720,1543,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',151900.98,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(23,8119,40720,1543,2,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',233510.64,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(24,8119,40720,1543,2,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',231594.00,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(25,8119,40720,1543,2,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',656358.45,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL);
INSERT INTO `balance_libro` VALUES (26,8119,40720,1543,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',222773.10,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(27,8119,40720,1543,2,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',103164.60,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(28,8119,40720,1543,2,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',245388.00,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(29,8119,40720,1543,2,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',204122.16,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(30,8119,40720,1543,2,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',182559.96,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(31,8119,40720,1543,2,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',231103.95,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(32,8119,40720,1543,2,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',119172.90,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(33,8119,40720,1543,2,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',212028.30,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(34,8119,40720,1543,2,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',367356.00,NULL,NULL,1,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(35,8119,40720,1543,2,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',124153.26,NULL,NULL,1,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(36,8119,40720,1543,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',838203.30,NULL,NULL,1,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(37,8119,40720,1543,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',792792.00,NULL,NULL,1,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(38,8119,40720,1543,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',429550.00,NULL,NULL,1,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(39,8119,40720,1543,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',792792.00,NULL,NULL,1,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(40,8119,40720,1543,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',792792.00,NULL,NULL,1,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(41,8119,40720,1543,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',124509.00,NULL,NULL,1,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(42,8119,40720,1543,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',1542387.00,NULL,NULL,1,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(43,8119,40720,1543,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',627627.00,NULL,NULL,1,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(44,8119,40720,1543,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',164511.60,NULL,NULL,1,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(45,8119,40720,1543,3,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',110575.46,NULL,NULL,1,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(46,8119,40720,1543,3,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',128657.18,NULL,NULL,1,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(47,8119,40720,1543,3,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',94212.18,NULL,NULL,1,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(48,8119,40720,1543,3,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',1490.00,NULL,NULL,1,'2022-12-20 15:27:09','2022-12-20 16:27:45','2022-12-20 16:27:45'),(49,8119,40720,1543,3,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1578.00,NULL,NULL,1,'2022-12-20 15:27:09','2022-12-20 16:27:01','2022-12-20 16:27:01'),(50,8119,40720,1543,3,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',210889.03,NULL,NULL,1,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL);
INSERT INTO `balance_libro` VALUES (51,8119,40720,1543,3,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',38403.56,NULL,NULL,1,'2022-12-20 15:27:09','2022-12-20 16:28:27','2022-12-20 16:28:27'),(52,8119,40720,1543,3,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',373101.81,NULL,NULL,1,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(53,8119,40720,1543,3,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',331834.61,NULL,NULL,1,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL),(54,8119,40720,1543,3,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',13513.91,NULL,NULL,1,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL),(55,8119,40720,1543,3,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8050.00,NULL,NULL,1,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL),(56,8119,40720,1543,3,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',206063.00,NULL,NULL,1,'2022-12-20 16:00:48','2022-12-20 16:00:48',NULL),(57,8119,40720,1543,3,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',302500.62,NULL,NULL,1,'2022-12-20 16:02:30','2022-12-20 16:02:30',NULL),(58,8119,40720,1543,3,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',194713.20,NULL,NULL,1,'2022-12-20 16:07:16','2022-12-20 16:07:16',NULL),(59,8119,40720,1543,3,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',278300.00,NULL,NULL,1,'2022-12-20 16:08:34','2022-12-20 16:08:34',NULL),(60,8119,40720,1543,3,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',193600.00,NULL,NULL,1,'2022-12-20 16:09:23','2022-12-20 16:30:36','2022-12-20 16:30:36'),(61,8119,40720,1543,3,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',229416.00,NULL,NULL,1,'2022-12-20 16:10:29','2022-12-20 16:10:29',NULL),(62,8119,40720,1543,3,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',313128.64,NULL,NULL,1,'2022-12-20 16:13:56','2022-12-20 16:13:56',NULL),(63,8119,40720,1543,3,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',257965.95,NULL,NULL,1,'2022-12-20 16:14:47','2022-12-20 16:14:47',NULL),(64,8119,40720,1543,3,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',175138.06,NULL,NULL,1,'2022-12-20 16:15:36','2022-12-20 16:27:28','2022-12-20 16:27:28'),(65,8119,40720,1543,3,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',270961.35,NULL,NULL,1,'2022-12-20 16:16:09','2022-12-20 16:27:17','2022-12-20 16:27:17'),(66,8119,40720,1543,3,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',217800.00,NULL,NULL,1,'2022-12-20 16:17:01','2022-12-20 16:17:01',NULL),(67,8119,40720,1543,3,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',328757.00,NULL,NULL,1,'2022-12-20 16:17:22','2022-12-20 16:17:22',NULL),(68,8119,40720,1543,3,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',436810.00,NULL,NULL,1,'2022-12-20 16:18:05','2022-12-20 16:18:05',NULL),(69,8119,40720,1543,3,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',294977.43,NULL,NULL,1,'2022-12-20 16:18:21','2022-12-20 16:18:21',NULL),(70,8119,40720,1543,3,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',463319.89,NULL,NULL,1,'2022-12-20 16:18:57','2022-12-20 16:18:57',NULL),(71,8119,40720,1543,3,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',340711.80,NULL,NULL,1,'2022-12-20 16:19:17','2022-12-20 16:19:17',NULL),(72,8119,40720,1543,3,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',1578.00,NULL,NULL,1,'2022-12-20 16:27:01','2022-12-20 16:27:01',NULL),(73,8119,40720,1543,3,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',270961.35,NULL,NULL,1,'2022-12-20 16:27:17','2022-12-20 16:27:17',NULL),(74,8119,40720,1543,3,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',175138.06,NULL,NULL,1,'2022-12-20 16:27:28','2022-12-20 16:27:28',NULL);
INSERT INTO `balance_libro` VALUES (75,8119,40720,1543,3,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',38403.56,NULL,NULL,1,'2022-12-20 16:28:27','2022-12-20 16:29:57','2022-12-20 16:29:57'),(76,8119,40720,1543,3,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',193600.00,NULL,NULL,1,'2022-12-20 16:30:36','2022-12-20 16:30:36',NULL),(77,8119,40776,20318,2,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',5804500.00,NULL,NULL,1,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(78,8119,40776,20318,2,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',403535.00,NULL,NULL,1,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(79,8119,40776,20318,2,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',336846.00,NULL,NULL,1,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(80,8119,40776,20318,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1377333.75,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(81,8119,40776,20318,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3061861.40,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(82,8119,40776,20318,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',104301.93,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(83,8119,40776,20318,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',13219.25,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(84,8119,40776,20318,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',662970.00,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(85,8119,40776,20318,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',56870.00,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(86,8119,40776,20318,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',471562.50,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(87,8119,40776,20318,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2077393.50,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(88,8119,40776,20318,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1852870.50,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(89,8119,40776,20318,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',257868.00,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(90,8119,40776,20318,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',512400.00,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(91,8119,40776,20318,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',512400.00,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(92,8119,40776,20318,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',212321.20,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(93,8119,40776,20318,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',128934.00,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(94,8119,40776,20318,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',322335.00,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(95,8119,40776,20318,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',60663.20,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(96,8119,40776,20318,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',878826.00,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42');
INSERT INTO `balance_libro` VALUES (97,8119,40776,20318,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2406448.00,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(98,8119,40776,20318,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',409402.50,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(99,8119,40776,20318,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1550542.50,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(100,8119,40776,20318,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',897729.25,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(101,8119,40776,20318,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',821650.50,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(102,8119,40776,20318,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',417232.20,NULL,NULL,1,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(103,8119,40776,20318,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',32178.00,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(104,8119,40776,20318,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',2174217.50,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(105,8119,40776,20318,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',294393.00,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(106,8119,40776,20318,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1895107.50,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(107,8119,40776,20318,2,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',3811.50,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(108,8119,40776,20318,2,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',310602.50,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(109,8119,40776,20318,2,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',22990.00,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(110,8119,40776,20318,2,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',9880.00,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(111,8119,40776,20318,2,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',6276391.00,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(112,8119,40776,20318,2,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',3890.25,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(113,8119,40776,20318,2,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',4037832.50,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(114,8119,40776,20318,2,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',45486.00,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(115,8119,40776,20318,2,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',409587.75,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(116,8119,40776,20318,2,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',409587.75,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(117,8119,40776,20318,2,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',464199.45,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(118,8119,40776,20318,2,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',10890.00,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43');
INSERT INTO `balance_libro` VALUES (119,8119,40776,20318,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',505362.00,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(120,8119,40776,20318,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',937982.50,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(121,8119,40776,20318,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',150584.50,NULL,NULL,1,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(122,8119,40776,20318,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',373315.80,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(123,8119,40776,20318,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1359035.70,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(124,8119,40776,20318,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1703410.80,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(125,8119,40776,20318,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',675668.50,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(126,8119,40776,20318,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',9569212.25,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(127,8119,40776,20318,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1384633.25,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(128,8119,40776,20318,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',304315.00,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(129,8119,40776,20318,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',290101.50,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(130,8119,40776,20318,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',290101.50,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(131,8119,40776,20318,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',124982.00,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(132,8119,40776,20318,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',450168.03,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(133,8119,40776,20318,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2372904.30,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(134,8119,40776,20318,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',290101.50,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(135,8119,40776,20318,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',920719.25,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(136,8119,40776,20318,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2015170.30,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(137,8119,40776,20318,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',223722.95,NULL,NULL,1,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(138,8119,40776,20318,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',769652.00,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(139,8119,40776,20318,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',709137.00,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(140,8119,40776,20318,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',3083177.50,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43');
INSERT INTO `balance_libro` VALUES (141,8119,40776,20318,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1165099.00,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(142,8119,40776,20318,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2248095.20,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(143,8119,40776,20318,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2061338.50,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(144,8119,40776,20318,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',94198.50,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(145,8119,40776,20318,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1013836.80,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(146,8119,40776,20318,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',517335.50,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(147,8119,40776,20318,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',372852.60,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(148,8119,40776,20318,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',339380.80,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(149,8119,40776,20318,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',420980.00,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(150,8119,40776,20318,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1386320.00,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(151,8119,40776,20318,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1664162.50,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(152,8119,40776,20318,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',193401.00,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(153,8119,40776,20318,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1999958.18,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(154,8119,40776,20318,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',201465.55,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(155,8119,40776,20318,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',765004.70,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(156,8119,40776,20318,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',12852.00,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(157,8119,40776,20318,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',150403.00,NULL,NULL,1,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(158,8119,40776,20318,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2227507.75,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(159,8119,40776,20318,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2559755.00,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(160,8119,40776,20318,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2113233.20,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(161,8119,40776,20318,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',8826590.20,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(162,8119,40776,20318,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2119136.50,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43');
INSERT INTO `balance_libro` VALUES (163,8119,40776,20318,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1691147.25,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(164,8119,40776,20318,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',867958.00,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(165,8119,40776,20318,2,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',596046.00,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(166,8119,40776,20318,2,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',149011.50,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(167,8119,40776,20318,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1134374.40,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(168,8119,40776,20318,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1408680.00,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(169,8119,40776,20318,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',302575.00,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(170,8119,40776,20318,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',11495.00,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(171,8119,40776,20318,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',928521.00,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(172,8119,40776,20318,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1064025.60,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(173,8119,40776,20318,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',191696.70,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(174,8119,40776,20318,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',2104687.00,NULL,NULL,1,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(175,8119,40776,20318,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1627915.25,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(176,8119,40776,20318,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',465903.75,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(177,8119,40776,20318,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',128934.00,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(178,8119,40776,20318,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',704568.48,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(179,8119,40776,20318,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1405354.50,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(180,8119,40776,20318,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1134374.40,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(181,8119,40776,20318,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1264578.25,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(182,8119,40776,20318,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',595334.40,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(183,8119,40776,20318,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',594352.00,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(184,8119,40776,20318,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2738835.00,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44');
INSERT INTO `balance_libro` VALUES (185,8119,40776,20318,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1521575.00,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(186,8119,40776,20318,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',767500.00,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(187,8119,40776,20318,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1167075.00,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(188,8119,40776,20318,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',434843.50,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(189,8119,40776,20318,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',440125.00,NULL,NULL,1,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(190,8119,40776,20318,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',5413056.00,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(191,8119,40776,20318,2,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1008452.72,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(192,8119,40776,20318,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1747574.40,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(193,8119,40776,20318,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',791219.00,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(194,8119,40776,20318,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2122582.00,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(195,8119,40776,20318,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',612332.60,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(196,8119,40776,20318,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',105282.10,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(197,8119,40776,20318,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3727230.00,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(198,8119,40776,20318,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3043150.00,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(199,8119,40776,20318,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2035583.00,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(200,8119,40776,20318,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',598514.40,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(201,8119,40776,20318,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',458975.40,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(202,8119,40776,20318,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3024032.00,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(203,8119,40776,20318,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1180289.50,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(204,8119,40776,20318,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2496572.20,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(205,8119,40776,20318,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',258757.20,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(206,8119,40776,20318,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1567222.25,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44');
INSERT INTO `balance_libro` VALUES (207,8119,40776,20318,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',145411.75,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(208,8119,40776,20318,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',258757.20,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(209,8119,40776,20318,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',380268.00,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(210,8119,40776,20318,2,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',184200.00,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(211,8119,40776,20318,2,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',352698.10,NULL,NULL,1,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(212,8119,40776,20318,2,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',62639.20,NULL,NULL,1,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(213,8119,40776,20318,2,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',159048.45,NULL,NULL,1,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(214,8119,40776,20318,2,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',546117.00,NULL,NULL,1,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(215,8119,40776,20318,2,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',621205.00,NULL,NULL,1,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(216,8119,40776,20318,2,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',217421.75,NULL,NULL,1,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(217,8119,40776,20318,2,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',223363.34,NULL,NULL,1,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(218,8119,40776,20318,2,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',217421.75,NULL,NULL,1,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(219,8119,40776,20318,2,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3311315.33,NULL,NULL,1,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(220,8119,40776,20318,2,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',900143.04,NULL,NULL,1,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(221,8119,40720,1544,2,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',250542.60,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(222,8119,40720,1544,2,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',103520.34,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(223,8119,40720,1544,2,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',425842.56,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(224,8119,40720,1544,2,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',560363.10,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(225,8119,40720,1544,2,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',58341.36,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(226,8119,40720,1544,2,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',141228.78,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(227,8119,40720,1544,2,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',43439.00,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(228,8119,40720,1544,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',306023.52,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(229,8119,40720,1544,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',235634.19,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL);
INSERT INTO `balance_libro` VALUES (230,8119,40720,1544,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',304034.28,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(231,8119,40720,1544,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',235634.19,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(232,8119,40720,1544,2,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',329342.64,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(233,8119,40720,1544,2,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',239768.76,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(234,8119,40720,1544,2,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',252938.40,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(235,8119,40720,1544,2,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',243500.40,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(236,8119,40720,1544,2,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',328064.88,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(237,8119,40720,1544,2,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1226940.00,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(238,8119,40720,1544,2,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1600830.00,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(239,8119,40720,1544,2,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1591246.80,NULL,NULL,1,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(240,8119,40720,1544,2,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',389600.64,NULL,NULL,1,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(241,8119,40720,1544,2,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',238781.40,NULL,NULL,1,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(242,8119,40720,1544,2,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',242084.70,NULL,NULL,1,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(243,8119,40720,1544,3,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',25368.55,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(244,8119,40720,1544,3,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',23577.92,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:39:32','2023-01-16 18:39:32'),(245,8119,40720,1544,3,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',58464.22,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(246,8119,40720,1544,3,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',18389.33,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:37:14','2023-01-16 18:37:14'),(247,8119,40720,1544,3,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',117734.94,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(248,8119,40720,1544,3,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',70303.84,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(249,8119,40720,1544,3,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',63707.50,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:40:50','2023-01-16 18:40:50'),(250,8119,40720,1544,3,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',49922.67,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(251,8119,40720,1544,3,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1490.00,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:35:24','2023-01-16 18:35:24'),(252,8119,40720,1544,3,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',35630.59,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(253,8119,40720,1544,3,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',28079.32,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:40:36','2023-01-16 18:40:36');
INSERT INTO `balance_libro` VALUES (254,8119,40720,1544,3,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',15391.20,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(255,8119,40720,1544,3,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',38416.03,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(256,8119,40720,1544,3,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',33549.91,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(257,8119,40720,1544,3,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',45602.79,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(258,8119,40720,1544,3,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',15000.00,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:40:04','2023-01-16 18:40:04'),(259,8119,40720,1544,3,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',135000.00,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:39:51','2023-01-16 18:39:51'),(260,8119,40720,1544,3,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',40884.43,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:39:11','2023-01-16 18:39:11'),(261,8119,40720,1544,3,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',117540.46,NULL,NULL,1,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(262,8119,40720,1544,3,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',360122.74,NULL,NULL,1,'2023-01-16 18:15:20','2023-01-16 18:15:20',NULL),(263,8119,40720,1544,3,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',408955.80,NULL,NULL,1,'2023-01-16 18:15:56','2023-01-16 18:15:56',NULL),(264,8119,40720,1544,3,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',259883.80,NULL,NULL,1,'2023-01-16 18:19:13','2023-01-16 18:19:13',NULL),(265,8119,40720,1544,3,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',372487.61,NULL,NULL,1,'2023-01-16 18:19:58','2023-01-16 18:19:58',NULL),(266,8119,40720,1544,3,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',270961.35,NULL,NULL,1,'2023-01-16 18:21:40','2023-01-16 18:21:40',NULL),(267,8119,40720,1544,3,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',424656.76,NULL,NULL,1,'2023-01-16 18:22:14','2023-01-16 18:22:14',NULL),(268,8119,40720,1544,3,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',295387.62,NULL,NULL,1,'2023-01-16 18:23:51','2023-01-16 18:23:51',NULL),(269,8119,40720,1544,3,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',406246.61,NULL,NULL,1,'2023-01-16 18:26:05','2023-01-16 18:26:05',NULL),(270,8119,40720,1544,3,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',195415.00,NULL,NULL,1,'2023-01-16 18:28:16','2023-01-16 18:28:16',NULL),(271,8119,40720,1544,3,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',340711.80,NULL,NULL,1,'2023-01-16 18:28:49','2023-01-16 18:28:49',NULL),(272,8119,40720,1544,3,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',381585.60,NULL,NULL,1,'2023-01-16 18:29:15','2023-01-16 18:29:15',NULL),(273,8119,40720,1544,3,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',417450.00,NULL,NULL,1,'2023-01-16 18:29:55','2023-01-16 18:29:55',NULL),(274,8119,40720,1544,3,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',192428.72,NULL,NULL,1,'2023-01-16 18:30:37','2023-01-16 18:30:37',NULL),(275,8119,40720,1544,3,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',284472.09,NULL,NULL,1,'2023-01-16 18:31:09','2023-01-16 18:31:09',NULL),(276,8119,40720,1544,3,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',471234.50,NULL,NULL,1,'2023-01-16 18:31:44','2023-01-16 18:31:44',NULL),(277,8119,40741,3351,2,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',33250.00,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL);
INSERT INTO `balance_libro` VALUES (278,8119,40741,3351,2,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',33500.00,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(279,8119,40741,3351,2,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',162331.90,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(280,8119,40741,3351,2,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',305759.90,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(281,8119,40741,3351,2,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',22150.90,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(282,8119,40741,3351,2,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',69106.50,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(283,8119,40741,3351,2,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',419516.80,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(284,8119,40741,3351,2,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',240505.50,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(285,8119,40741,3351,2,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',55848.60,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(286,8119,40741,3351,2,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',267611.00,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(287,8119,40741,3351,2,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',50115.10,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(288,8119,40741,3351,2,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',39835.90,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(289,8119,40741,3351,2,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',127749.60,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(290,8119,40741,3351,2,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',228283.70,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(291,8119,40741,3351,2,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',45818.50,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(292,8119,40741,3351,2,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',46193.10,NULL,NULL,1,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(293,8119,40741,3351,2,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',46193.10,NULL,NULL,1,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(294,8119,40741,3351,2,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',56100.30,NULL,NULL,1,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(295,8119,40741,3351,2,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',19599.30,NULL,NULL,1,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(296,8119,40741,3351,3,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',29342.16,NULL,NULL,1,'2023-01-16 20:22:20','2023-01-16 20:22:20',NULL),(297,8119,40741,3351,3,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',403739.39,NULL,NULL,1,'2023-01-16 20:22:20','2023-01-16 20:22:20',NULL),(298,8119,40741,3351,3,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',613813.13,NULL,NULL,1,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(299,8119,40741,3351,3,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',43440.75,NULL,NULL,1,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(300,8119,40741,3351,3,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',12380.90,NULL,NULL,1,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(301,8119,40741,3351,3,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',133997.82,NULL,NULL,1,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL);
INSERT INTO `balance_libro` VALUES (302,8119,40741,3351,3,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',60615.00,NULL,NULL,1,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(303,8119,40741,3351,3,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',175884.16,NULL,NULL,1,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(304,8119,40741,3351,3,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',30109.94,NULL,NULL,1,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(305,8119,40741,3351,3,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',117961.28,NULL,NULL,1,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(306,8119,40741,3351,3,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',200005.00,NULL,NULL,1,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(307,8119,40741,3351,3,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',498604.40,NULL,NULL,1,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(308,8119,40741,3351,3,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',560576.50,NULL,NULL,1,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(309,8119,40741,3351,3,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',477155.58,NULL,NULL,1,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(310,8119,40856,29414,2,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1000.00,NULL,NULL,1,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(311,8119,40856,29414,2,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',157946.00,NULL,NULL,1,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(312,8119,40856,29414,2,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',12300.00,NULL,NULL,1,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(313,8119,40856,29414,2,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',64260.00,NULL,NULL,1,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(314,8119,40856,29414,2,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',15028.00,NULL,NULL,1,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(315,8119,40856,29414,2,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',19750.00,NULL,NULL,1,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(316,8119,40856,29414,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',17380.00,NULL,NULL,1,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(317,8119,40856,29414,2,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',44100.00,NULL,NULL,1,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(318,8119,40856,29414,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',131104.00,NULL,NULL,1,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(319,8119,40856,29414,2,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',19400.00,NULL,NULL,1,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(320,8119,40856,29414,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',33600.00,NULL,NULL,1,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(321,8119,40856,29414,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',19635.00,NULL,NULL,1,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(322,8119,40856,29414,3,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',10680.20,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:42:02','2023-01-16 20:42:02'),(323,8119,40856,29414,3,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',8289.80,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:42:08','2023-01-16 20:42:08'),(324,8119,40856,29414,3,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',5654.18,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:42:14','2023-01-16 20:42:14'),(325,8119,40856,29414,3,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',20000.00,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL);
INSERT INTO `balance_libro` VALUES (326,8119,40856,29414,3,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',6158.20,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:41:40','2023-01-16 20:41:40'),(327,8119,40856,29414,3,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',5633.11,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:41:47','2023-01-16 20:41:47'),(328,8119,40856,29414,3,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',5980.00,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(329,8119,40856,29414,3,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',7454.16,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:41:32','2023-01-16 20:41:32'),(330,8119,40856,29414,3,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',17630.97,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:41:23','2023-01-16 20:41:23'),(331,8119,40856,29414,3,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',718.74,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(332,8119,40856,29414,3,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',9899.00,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:41:16','2023-01-16 20:41:16'),(333,8119,40856,29414,3,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',12257.00,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:41:07','2023-01-16 20:41:07'),(334,8119,40856,29414,3,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',9771.36,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(335,8119,40856,29414,3,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',85000.00,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(336,8119,40856,29414,3,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',80000.00,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(337,8119,40856,29414,3,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',85000.00,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(338,8119,40856,29414,3,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',80000.00,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(339,8119,40856,29414,3,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',85000.00,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(340,8119,40856,29414,3,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',85000.00,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(341,8119,40856,29414,3,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',20500.00,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(342,8119,40856,29414,3,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',19720.59,NULL,NULL,1,'2023-01-16 20:40:16','2023-01-16 20:40:58','2023-01-16 20:40:58'),(343,8119,40856,29414,3,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',22387.90,NULL,NULL,1,'2023-01-16 20:40:17','2023-01-16 20:40:17',NULL),(344,8119,40774,31118,2,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',1899.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(345,8119,40774,31118,2,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',549.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(346,8119,40774,31118,2,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',6245.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(347,8119,40774,31118,2,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',2999.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(348,8119,40774,31118,2,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',699.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(349,8119,40774,31118,2,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',499.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL);
INSERT INTO `balance_libro` VALUES (350,8119,40774,31118,2,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',1049.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(351,8119,40774,31118,2,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',2000.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(352,8119,40774,31118,2,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',749.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(353,8119,40774,31118,2,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',300.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(354,8119,40774,31118,2,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',798.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(355,8119,40774,31118,2,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',300.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(356,8119,40774,31118,2,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',2259.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(357,8119,40774,31118,2,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',1499.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(358,8119,40774,31118,2,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',8686.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(359,8119,40774,31118,2,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',4375.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(360,8119,40774,31118,2,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',3200.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(361,8119,40774,31118,2,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',300.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(362,8119,40774,31118,2,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',1879.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(363,8119,40774,31118,2,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',4792.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(364,8119,40774,31118,2,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',599.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(365,8119,40774,31118,2,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',3054.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(366,8119,40774,31118,2,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',1749.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(367,8119,40774,31118,2,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',4244.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(368,8119,40774,31118,2,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',1499.00,NULL,NULL,1,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(369,8119,40774,31118,2,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',1450.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(370,8119,40774,31118,2,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',1499.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(371,8119,40774,31118,2,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',1999.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(372,8119,40774,31118,2,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',6472.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(373,8119,40774,31118,2,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',300.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(374,8119,40774,31118,2,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',2742.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL);
INSERT INTO `balance_libro` VALUES (375,8119,40774,31118,2,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',1880.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(376,8119,40774,31118,2,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1649.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(377,8119,40774,31118,2,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3192.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(378,8119,40774,31118,2,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1049.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(379,8119,40774,31118,2,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1648.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(380,8119,40774,31118,2,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1127.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(381,8119,40774,31118,2,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1693.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(382,8119,40774,31118,2,376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1098.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(383,8119,40774,31118,2,377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',19000.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(384,8119,40774,31118,2,378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',13499.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(385,8119,40774,31118,2,379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2910.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(386,8119,40774,31118,2,380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2050.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(387,8119,40774,31118,2,381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2525.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(388,8119,40774,31118,2,382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',300.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(389,8119,40774,31118,2,383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1199.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(390,8119,40774,31118,2,384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',20986.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(391,8119,40774,31118,2,385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1199.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(392,8119,40774,31118,2,386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1849.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(393,8119,40774,31118,2,387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',8468.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(394,8119,40774,31118,2,388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2249.00,NULL,NULL,1,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(395,8119,40774,31118,2,389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1799.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(396,8119,40774,31118,2,390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',8750.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(397,8119,40774,31118,2,391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1499.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(398,8119,40774,31118,2,392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3650.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(399,8119,40774,31118,2,393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1260.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL);
INSERT INTO `balance_libro` VALUES (400,8119,40774,31118,2,394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',6300.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(401,8119,40774,31118,2,395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1094.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(402,8119,40774,31118,2,396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3580.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(403,8119,40774,31118,2,397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',300.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(404,8119,40774,31118,2,398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1999.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(405,8119,40774,31118,2,399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',5797.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(406,8119,40774,31118,2,400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1499.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(407,8119,40774,31118,2,401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',649.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(408,8119,40774,31118,2,402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',4214.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(409,8119,40774,31118,2,403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1260.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(410,8119,40774,31118,2,404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',449.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(411,8119,40774,31118,2,405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',699.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(412,8119,40774,31118,2,406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',6138.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(413,8119,40774,31118,2,407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2745.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(414,8119,40774,31118,2,408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2344.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(415,8119,40774,31118,2,409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',6946.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(416,8119,40774,31118,2,410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',6614.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(417,8119,40774,31118,2,411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2707.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(418,8119,40774,31118,2,412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',650.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(419,8119,40774,31118,2,413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',3519.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(420,8119,40774,31118,2,414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2059.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(421,8119,40774,31118,2,415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2249.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(422,8119,40774,31118,2,416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1000.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(423,8119,40774,31118,2,417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1099.00,NULL,NULL,1,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(424,8119,40774,31118,2,418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1067.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL);
INSERT INTO `balance_libro` VALUES (425,8119,40774,31118,2,419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',294.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(426,8119,40774,31118,2,420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3678.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(427,8119,40774,31118,2,421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2601.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(428,8119,40774,31118,2,422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',549.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(429,8119,40774,31118,2,423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',500.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(430,8119,40774,31118,2,424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1049.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(431,8119,40774,31118,2,425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1049.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(432,8119,40774,31118,2,426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',9700.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(433,8119,40774,31118,2,427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',6249.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(434,8119,40774,31118,2,428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',603.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(435,8119,40774,31118,2,429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',5409.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(436,8119,40774,31118,2,430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1260.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(437,8119,40774,31118,2,431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',4458.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(438,8119,40774,31118,2,432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',549.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(439,8119,40774,31118,2,433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',6249.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(440,8119,40774,31118,2,434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',10680.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(441,8119,40774,31118,2,435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2520.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(442,8119,40774,31118,2,436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',799.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(443,8119,40774,31118,2,437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1499.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(444,8119,40774,31118,2,438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1199.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(445,8119,40774,31118,2,439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',3579.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(446,8119,40774,31118,2,440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1335.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(447,8119,40774,31118,2,441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',419.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(448,8119,40774,31118,2,442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',900.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(449,8119,40774,31118,2,443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',587.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL);
INSERT INTO `balance_libro` VALUES (450,8119,40774,31118,2,444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',749.00,NULL,NULL,1,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(451,8119,40774,31118,2,445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',12500.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(452,8119,40774,31118,2,446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',10000.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(453,8119,40774,31118,2,447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',12550.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(454,8119,40774,31118,2,448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',20500.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(455,8119,40774,31118,2,449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',17780.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(456,8119,40774,31118,2,450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',15500.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(457,8119,40774,31118,2,451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',7500.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(458,8119,40774,31118,2,452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',21120.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(459,8119,40774,31118,2,453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2610.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(460,8119,40774,31118,2,454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',500.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(461,8119,40774,31118,2,455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',3540.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(462,8119,40774,31118,2,456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1744.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(463,8119,40774,31118,2,457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',587.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(464,8119,40774,31118,2,458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1049.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(465,8119,40774,31118,2,459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',444.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(466,8119,40774,31118,2,460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1067.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(467,8119,40774,31118,2,461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',4018.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(468,8119,40774,31118,2,462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',3213.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(469,8119,40774,31118,2,463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',461.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(470,8119,40774,31118,2,464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',300.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(471,8119,40774,31118,2,465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2595.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(472,8119,40774,31118,2,466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',6249.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(473,8119,40774,31118,2,467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1399.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(474,8119,40774,31118,2,468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2448.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL);
INSERT INTO `balance_libro` VALUES (475,8119,40774,31118,2,469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',587.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(476,8119,40774,31118,2,470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',649.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(477,8119,40774,31118,2,471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2598.00,NULL,NULL,1,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(478,8119,40774,31118,2,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2300.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(479,8119,40774,31118,2,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1000.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(480,8119,40774,31118,2,474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',4643.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(481,8119,40774,31118,2,475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',922.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(482,8119,40774,31118,2,476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1999.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(483,8119,40774,31118,2,477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1804.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(484,8119,40774,31118,2,478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1148.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(485,8119,40774,31118,2,479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',499.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(486,8119,40774,31118,2,480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',699.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(487,8119,40774,31118,2,481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2764.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(488,8119,40774,31118,2,482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',5568.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(489,8119,40774,31118,2,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1199.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(490,8119,40774,31118,2,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',999.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(491,8119,40774,31118,2,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1499.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(492,8119,40774,31118,2,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',2598.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(493,8119,40774,31118,2,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1749.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(494,8119,40774,31118,2,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1260.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(495,8119,40774,31118,2,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',15000.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(496,8119,40774,31118,2,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',15850.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(497,8119,40774,31118,2,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',3024.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(498,8119,40774,31118,2,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',899.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(499,8119,40774,31118,2,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1000.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL);
INSERT INTO `balance_libro` VALUES (500,8119,40774,31118,2,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1049.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(501,8119,40774,31118,2,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',2344.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(502,8119,40774,31118,2,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1344.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(503,8119,40774,31118,2,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',799.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(504,8119,40774,31118,2,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1000.00,NULL,NULL,1,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(505,8119,40774,31118,2,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',500.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(506,8119,40774,31118,2,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',2644.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(507,8119,40774,31118,2,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',399.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(508,8119,40774,31118,2,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',2450.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(509,8119,40774,31118,2,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',699.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(510,8119,40774,31118,2,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1049.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(511,8119,40774,31118,2,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',949.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(512,8119,40774,31118,2,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',399.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(513,8119,40774,31118,2,507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1499.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(514,8119,40774,31118,2,508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',2249.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(515,8119,40774,31118,2,509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',2798.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(516,8119,40774,31118,2,510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1499.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(517,8119,40774,31118,2,511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',849.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(518,8119,40774,31118,2,512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',3691.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(519,8119,40774,31118,2,513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',999.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(520,8119,40774,31118,2,514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',1000.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(521,8119,40774,31118,2,515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',500.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(522,8119,40774,31118,2,516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',17000.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(523,8119,40774,31118,2,517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',9750.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(524,8119,40774,31118,2,518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2249.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL);
INSERT INTO `balance_libro` VALUES (525,8119,40774,31118,2,519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1295.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(526,8119,40774,31118,2,520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',17100.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(527,8119,40774,31118,2,521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',499.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(528,8119,40774,31118,2,522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2908.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(529,8119,40774,31118,2,523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',949.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(530,8119,40774,31118,2,524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',549.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(531,8119,40774,31118,2,525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2911.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(532,8119,40774,31118,2,526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1799.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(533,8119,40774,31118,2,527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1049.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(534,8119,40774,31118,2,528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',17247.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(535,8119,40774,31118,2,529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',549.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(536,8119,40774,31118,2,530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1499.00,NULL,NULL,1,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(537,8119,40774,31118,2,531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',549.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(538,8119,40774,31118,2,532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',549.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(539,8119,40774,31118,2,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',549.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(540,8119,40774,31118,2,534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1850.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(541,8119,40774,31118,2,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',3649.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(542,8119,40774,31118,2,536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2259.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(543,8119,40774,31118,2,537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',549.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(544,8119,40774,31118,2,538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1998.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(545,8119,40774,31118,2,539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1300.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(546,8119,40774,31118,2,540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',899.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(547,8119,40774,31118,2,541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',899.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(548,8119,40774,31118,2,542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',799.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(549,8119,40774,31118,2,543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1199.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL);
INSERT INTO `balance_libro` VALUES (550,8119,40774,31118,2,544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',18000.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(551,8119,40774,31118,2,545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',14050.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(552,8119,40774,31118,2,546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',17300.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(553,8119,40774,31118,2,547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',9100.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(554,8119,40774,31118,2,548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',11250.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(555,8119,40774,31118,2,549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1049.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(556,8119,40774,31118,2,550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',3499.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(557,8119,40774,31118,2,551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',4790.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(558,8119,40774,31118,2,552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',3249.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(559,8119,40774,31118,2,553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1149.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(560,8119,40774,31118,2,554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2760.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(561,8119,40774,31118,2,555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',300.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(562,8119,40774,31118,2,556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2750.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(563,8119,40774,31118,2,557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',7500.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(564,8119,40774,31118,2,558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1719.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(565,8119,40774,31118,2,559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3130.00,NULL,NULL,1,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(566,8119,40774,31118,2,560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2529.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(567,8119,40774,31118,2,561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3120.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(568,8119,40774,31118,2,562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',699.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(569,8119,40774,31118,2,563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1343.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(570,8119,40774,31118,2,564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1594.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(571,8119,40774,31118,2,565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2545.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(572,8119,40774,31118,2,566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2249.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(573,8119,40774,31118,2,567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',500.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(574,8119,40774,31118,2,568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2639.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL);
INSERT INTO `balance_libro` VALUES (575,8119,40774,31118,2,569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1300.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(576,8119,40774,31118,2,570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',900.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(577,8119,40774,31118,2,571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2609.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(578,8119,40774,31118,2,572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1199.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(579,8119,40774,31118,2,573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',999.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(580,8119,40774,31118,2,574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',4197.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(581,8119,40774,31118,2,575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2639.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(582,8119,40774,31118,2,576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1000.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(583,8119,40774,31118,2,577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',399.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(584,8119,40774,31118,2,578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1260.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(585,8119,40774,31118,2,579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',799.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(586,8119,40774,31118,2,580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',549.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(587,8119,40774,31118,2,581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',500.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(588,8119,40774,31118,2,582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2641.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(589,8119,40774,31118,2,583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',399.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(590,8119,40774,31118,2,584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',4348.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(591,8119,40774,31118,2,585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3249.00,NULL,NULL,1,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(592,8119,40774,31118,2,586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',900.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(593,8119,40774,31118,2,587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3139.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(594,8119,40774,31118,2,588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3199.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(595,8119,40774,31118,2,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',649.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(596,8119,40774,31118,2,590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2519.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(597,8119,40774,31118,2,591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',749.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(598,8119,40774,31118,2,592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',649.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(599,8119,40774,31118,2,593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2199.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL);
INSERT INTO `balance_libro` VALUES (600,8119,40774,31118,2,594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3405.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(601,8119,40774,31118,2,595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1398.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(602,8119,40774,31118,2,596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',399.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(603,8119,40774,31118,2,597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2599.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(604,8119,40774,31118,2,598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',300.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(605,8119,40774,31118,2,599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3192.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(606,8119,40774,31118,2,600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2144.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(607,8119,40774,31118,2,601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2300.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(608,8119,40774,31118,2,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2899.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(609,8119,40774,31118,2,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3448.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(610,8119,40774,31118,2,604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2943.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(611,8119,40774,31118,2,605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',6255.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(612,8119,40774,31118,2,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2519.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(613,8119,40774,31118,2,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2459.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(614,8119,40774,31118,2,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2145.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(615,8119,40774,31118,2,609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',4597.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(616,8119,40774,31118,2,610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2395.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(617,8119,40774,31118,2,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2449.00,NULL,NULL,1,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(618,8119,40774,31118,2,612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',350.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(619,8119,40774,31118,2,613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2159.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(620,8119,40774,31118,2,614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2249.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(621,8119,40774,31118,2,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',6866.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(622,8119,40774,31118,2,616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2469.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(623,8119,40774,31118,2,617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2219.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(624,8119,40774,31118,2,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2769.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL);
INSERT INTO `balance_libro` VALUES (625,8119,40774,31118,2,619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2344.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(626,8119,40774,31118,2,620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',300.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(627,8119,40774,31118,2,621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1245.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(628,8119,40774,31118,2,622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2094.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(629,8119,40774,31118,2,623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2998.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(630,8119,40774,31118,2,624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',300.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(631,8119,40774,31118,2,625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3850.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(632,8119,40774,31118,2,626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',6095.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(633,8119,40774,31118,2,627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1244.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(634,8119,40774,31118,2,628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2709.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(635,8119,40774,31118,2,629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2649.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(636,8119,40774,31118,2,630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2344.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(637,8119,40774,31118,2,631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3520.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(638,8119,40774,31118,2,632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2469.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(639,8119,40774,31118,2,633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1248.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(640,8119,40774,31118,2,634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',499.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(641,8119,40774,31118,2,635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2950.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(642,8119,40774,31118,2,636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1049.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(643,8119,40774,31118,2,637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5739.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(644,8119,40774,31118,2,638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',699.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(645,8119,40774,31118,2,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',499.00,NULL,NULL,1,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(646,8119,40774,31118,2,640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3249.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(647,8119,40774,31118,2,641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4149.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(648,8119,40774,31118,2,642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2210.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(649,8119,40774,31118,2,643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',499.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL);
INSERT INTO `balance_libro` VALUES (650,8119,40774,31118,2,644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',499.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(651,8119,40774,31118,2,645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2759.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(652,8119,40774,31118,2,646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',23534.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(653,8119,40774,31118,2,647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3595.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(654,8119,40774,31118,2,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',8750.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(655,8119,40774,31118,2,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',9297.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(656,8119,40774,31118,2,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5699.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(657,8119,40774,31118,2,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5992.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(658,8119,40774,31118,2,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4246.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(659,8119,40774,31118,2,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',7044.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(660,8119,40774,31118,2,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',13895.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(661,8119,40774,31118,2,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2043.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(662,8119,40774,31118,2,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4498.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(663,8119,40774,31118,2,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3960.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(664,8119,40774,31118,2,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',9897.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(665,8119,40774,31118,2,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',8102.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(666,8119,40774,31118,2,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5996.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(667,8119,40774,31118,2,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4276.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(668,8119,40774,31118,2,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2968.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(669,8119,40774,31118,2,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1999.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(670,8119,40774,31118,2,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3558.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(671,8119,40774,31118,2,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5647.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(672,8119,40774,31118,2,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5147.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(673,8119,40774,31118,2,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',8299.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(674,8119,40774,31118,2,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',10400.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL);
INSERT INTO `balance_libro` VALUES (675,8119,40774,31118,2,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',7500.00,NULL,NULL,1,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(676,8119,40774,31118,2,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',8600.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(677,8119,40774,31118,2,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',9300.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(678,8119,40774,31118,2,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1300.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(679,8119,40774,31118,2,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',499.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(680,8119,40774,31118,2,674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1959.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(681,8119,40774,31118,2,675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',799.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(682,8119,40774,31118,2,676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1843.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(683,8119,40774,31118,2,677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',649.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(684,8119,40774,31118,2,678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',6850.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(685,8119,40774,31118,2,679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4056.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(686,8119,40774,31118,2,680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',9092.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(687,8119,40774,31118,2,681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1499.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(688,8119,40774,31118,2,682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2309.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(689,8119,40774,31118,2,683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',649.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(690,8119,40774,31118,2,684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2260.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(691,8119,40774,31118,2,685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',500.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(692,8119,40774,31118,2,686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1294.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(693,8119,40774,31118,2,687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1150.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(694,8119,40774,31118,2,688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1199.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(695,8119,40774,31118,2,689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1999.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(696,8119,40774,31118,2,690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',849.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(697,8119,40774,31118,2,691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2458.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(698,8119,40774,31118,2,692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',999.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(699,8119,40774,31118,2,693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2144.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL);
INSERT INTO `balance_libro` VALUES (700,8119,40774,31118,2,694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',699.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(701,8119,40774,31118,2,695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1349.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(702,8119,40774,31118,2,696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1199.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(703,8119,40774,31118,2,697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',649.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(704,8119,40774,31118,2,698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1450.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(705,8119,40774,31118,2,699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',549.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(706,8119,40774,31118,2,700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1049.00,NULL,NULL,1,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(707,8119,40774,31118,2,701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1198.00,NULL,NULL,1,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(708,8119,40774,31118,2,702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1199.00,NULL,NULL,1,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(709,8119,40774,31118,2,703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1849.00,NULL,NULL,1,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(710,8119,40774,31118,2,704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',798.00,NULL,NULL,1,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(711,8119,40774,31118,2,705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2100.00,NULL,NULL,1,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(712,8119,40774,31118,2,706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2998.00,NULL,NULL,1,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(713,8119,40774,31118,2,707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1448.00,NULL,NULL,1,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(714,8119,40774,31118,3,708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',23111.95,NULL,NULL,1,'2023-01-19 10:48:53','2023-01-19 11:08:30','2023-01-19 11:08:30'),(715,8119,40774,31118,3,709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',7908.09,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(716,8119,40774,31118,3,710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',5100.00,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 11:08:22','2023-01-19 11:08:22'),(717,8119,40774,31118,3,711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',12298.47,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(718,8119,40774,31118,3,712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',78034.22,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(719,8119,40774,31118,3,713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',2217.89,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(720,8119,40774,31118,3,714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',50320.13,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(721,8119,40774,31118,3,715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',42882.92,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(722,8119,40774,31118,3,716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',875.72,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(723,8119,40774,31118,3,717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',443.25,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL);
INSERT INTO `balance_libro` VALUES (724,8119,40774,31118,3,718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',4261.24,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(725,8119,40774,31118,3,719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',0.00,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 11:08:04','2023-01-19 11:08:04'),(726,8119,40774,31118,3,720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',0.00,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 11:07:49','2023-01-19 11:07:49'),(727,8119,40774,31118,3,721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',0.00,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 11:07:56','2023-01-19 11:07:56'),(728,8119,40774,31118,3,722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',69000.00,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(729,8119,40774,31118,3,723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',150.00,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 11:07:41','2023-01-19 11:07:41'),(730,8119,40774,31118,3,724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',815.00,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 11:07:34','2023-01-19 11:07:34'),(731,8119,40774,31118,3,725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',163.00,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 11:07:14','2023-01-19 11:07:14'),(732,8119,40774,31118,3,726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',16000.00,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(733,8119,40774,31118,3,727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',15088.70,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(734,8119,40774,31118,3,728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',216.00,NULL,NULL,1,'2023-01-19 10:48:54','2023-01-19 11:07:23','2023-01-19 11:07:23'),(735,8119,40774,31118,3,729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',10406.00,NULL,NULL,1,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(736,8119,40774,31118,3,730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',136045.80,NULL,NULL,1,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(737,8119,40774,31118,3,731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',100022.50,NULL,NULL,1,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(738,8119,40774,31118,3,732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',7745.00,NULL,NULL,1,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(739,8119,40774,31118,3,733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',126013.45,NULL,NULL,1,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(740,8119,40774,31118,3,734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',134886.77,NULL,NULL,1,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(741,8119,40774,31118,3,735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',2500.24,NULL,NULL,1,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(742,8119,40774,31118,3,736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1168.25,NULL,NULL,1,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(743,8119,40774,31118,3,737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',13844.98,NULL,NULL,1,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(744,8119,40774,31118,3,738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',24798.24,NULL,NULL,1,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(745,8119,40774,31118,3,739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',368.34,NULL,NULL,1,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(746,8119,40774,31118,3,740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',7008.00,NULL,NULL,1,'2023-01-19 10:48:56','2023-01-19 11:07:00','2023-01-19 11:07:00'),(747,8119,40774,31118,3,741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',22321.00,NULL,NULL,1,'2023-01-19 10:48:56','2023-01-19 10:48:56',NULL);
INSERT INTO `balance_libro` VALUES (748,8119,40774,31118,3,742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1880.67,NULL,NULL,1,'2023-01-19 10:48:56','2023-01-19 10:48:56',NULL),(749,8119,40775,18805,2,743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',6665.00,NULL,NULL,1,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(750,8119,40775,18805,2,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',13915.00,NULL,NULL,1,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(751,8119,40775,18805,2,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',57106.00,NULL,NULL,1,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(752,8119,40775,18805,2,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',194931.00,NULL,NULL,1,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(753,8119,40775,18805,2,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',100000.00,NULL,NULL,1,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(754,8119,40775,18805,3,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',3450.00,NULL,NULL,1,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(755,8119,40775,18805,3,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',6282.35,NULL,NULL,1,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(756,8119,40775,18805,3,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',33999.00,NULL,NULL,1,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(757,8119,40775,18805,3,751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',4085.35,NULL,NULL,1,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(758,8119,40775,18805,3,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',7404.58,NULL,NULL,1,'2023-01-19 12:30:01','2023-01-23 18:22:05','2023-01-23 18:22:05'),(759,8119,40775,18805,3,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',40000.00,NULL,NULL,1,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(760,8119,40775,18805,3,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',398.91,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(761,8119,40775,18805,3,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',62198.84,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(762,8119,40775,18805,3,756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',100297.00,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(763,8119,40775,18805,3,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',102182.01,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(764,8119,40775,18805,3,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1168.55,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(765,8119,40775,18805,3,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',142.90,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(766,8119,40775,18805,3,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',85400.00,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(767,8119,40775,18805,3,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',3240.40,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(768,8119,40775,18805,3,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',33000.00,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(769,8119,40775,18805,3,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',5821.14,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(770,8119,40775,18805,3,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',6944.24,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(771,8119,40775,18805,3,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',16445.53,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL);
INSERT INTO `balance_libro` VALUES (772,8119,40775,18805,3,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',64132.71,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(773,8119,40775,18805,3,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',18594.45,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(774,8119,40775,18805,3,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',15025.30,NULL,NULL,1,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(775,8119,40775,18805,3,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1092.00,NULL,NULL,1,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(776,8119,40775,18805,3,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',56699.00,NULL,NULL,1,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(777,8119,40775,18805,3,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1030.73,NULL,NULL,1,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(778,8119,40775,18805,3,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',12512.15,NULL,NULL,1,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(779,8119,40775,18805,3,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',102181.96,NULL,NULL,1,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(780,8119,40775,18805,3,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',434.13,NULL,NULL,1,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(781,8119,40775,18805,3,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',5106.70,NULL,NULL,1,'2023-01-23 18:07:32','2023-01-23 18:07:32',NULL),(782,8119,40775,31294,15,NULL,191,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',58431.45,NULL,NULL,1,'2023-01-23 18:10:45','2023-01-23 18:10:45',NULL),(783,8119,40775,18805,3,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',7404.58,NULL,NULL,1,'2023-01-23 18:22:05','2023-01-23 18:22:05',NULL),(784,8119,40775,18805,7,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',333.56,NULL,NULL,1,'2023-01-23 18:24:32','2023-01-23 18:24:32',NULL),(785,8119,40775,18805,15,NULL,197,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',164625.32,NULL,NULL,1,'2023-01-23 18:25:23','2023-01-23 18:25:23',NULL),(786,8119,40883,31295,2,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',15008.00,NULL,NULL,1,'2023-02-15 15:20:46','2023-02-15 15:20:46',NULL),(787,8119,40883,31295,2,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2245.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(788,8119,40883,31295,2,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',13615.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(789,8119,40883,31295,2,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1805.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(790,8119,40883,31295,2,781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2270.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(791,8119,40883,31295,2,782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2900.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(792,8119,40883,31295,2,783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1900.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(793,8119,40883,31295,2,784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1465.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(794,8119,40883,31295,2,785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',240.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(795,8119,40883,31295,2,786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',660.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL);
INSERT INTO `balance_libro` VALUES (796,8119,40883,31295,2,787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',10955.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(797,8119,40883,31295,2,788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',22955.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(798,8119,40883,31295,2,789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',9160.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(799,8119,40883,31295,2,790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',900.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(800,8119,40883,31295,2,791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1000.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(801,8119,40883,31295,2,792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',480.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(802,8119,40883,31295,2,793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',920.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(803,8119,40883,31295,2,794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',5470.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(804,8119,40883,31295,2,795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2060.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(805,8119,40883,31295,2,796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',8945.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(806,8119,40883,31295,2,797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1120.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(807,8119,40883,31295,2,798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',14635.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(808,8119,40883,31295,2,799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3260.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(809,8119,40883,31295,2,800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1465.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(810,8119,40883,31295,2,801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',795.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(811,8119,40883,31295,2,802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3185.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(812,8119,40883,31295,2,803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2155.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(813,8119,40883,31295,2,804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',350.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(814,8119,40883,31295,2,805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',5080.00,NULL,NULL,1,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(815,8119,40883,31295,2,806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',630.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(816,8119,40883,31295,2,807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',5039.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(817,8119,40883,31295,2,808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',20190.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(818,8119,40883,31295,2,809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',3455.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(819,8119,40883,31295,2,810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1910.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(820,8119,40883,31295,2,811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',4380.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL);
INSERT INTO `balance_libro` VALUES (821,8119,40883,31295,2,812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2185.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(822,8119,40883,31295,2,813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',8710.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(823,8119,40883,31295,2,814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',5845.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(824,8119,40883,31295,2,815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',9385.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(825,8119,40883,31295,2,816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2255.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(826,8119,40883,31295,2,817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',430.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(827,8119,40883,31295,2,818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',240.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(828,8119,40883,31295,2,819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',810.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(829,8119,40883,31295,2,820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1330.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(830,8119,40883,31295,2,821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',980.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(831,8119,40883,31295,2,822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3320.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(832,8119,40883,31295,2,823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',350.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(833,8119,40883,31295,2,824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',480.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(834,8119,40883,31295,2,825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3355.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(835,8119,40883,31295,2,826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',410.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(836,8119,40883,31295,2,827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1330.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(837,8119,40883,31295,2,828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2580.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(838,8119,40883,31295,2,829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',5990.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(839,8119,40883,31295,2,830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',420.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(840,8119,40883,31295,2,831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4125.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(841,8119,40883,31295,2,832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',290.00,NULL,NULL,1,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(842,8119,40883,31295,2,833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6803.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(843,8119,40883,31295,2,834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',10528.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(844,8119,40883,31295,2,835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2300.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(845,8119,40883,31295,2,836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6410.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL);
INSERT INTO `balance_libro` VALUES (846,8119,40883,31295,2,837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1280.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(847,8119,40883,31295,2,838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',10139.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(848,8119,40883,31295,2,839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2515.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(849,8119,40883,31295,2,840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1720.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(850,8119,40883,31295,2,841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2610.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(851,8119,40883,31295,2,842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1465.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(852,8119,40883,31295,2,843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1975.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(853,8119,40883,31295,2,844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',985.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(854,8119,40883,31295,2,845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',5820.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(855,8119,40883,31295,2,846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',735.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(856,8119,40883,31295,2,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8855.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(857,8119,40883,31295,2,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',8740.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(858,8119,40883,31295,2,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1210.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(859,8119,40883,31295,2,850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',420.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(860,8119,40883,31295,2,851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',21130.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(861,8119,40883,31295,2,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',240.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(862,8119,40883,31295,2,853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',810.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(863,8119,40883,31295,2,854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2950.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(864,8119,40883,31295,2,855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',685.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(865,8119,40883,31295,2,856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',3255.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(866,8119,40883,31295,2,857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1475.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(867,8119,40883,31295,2,858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',5410.00,NULL,NULL,1,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(868,8119,40883,31295,2,859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4450.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(869,8119,40883,31295,2,860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2255.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(870,8119,40883,31295,2,861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',17750.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL);
INSERT INTO `balance_libro` VALUES (871,8119,40883,31295,2,862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4499.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(872,8119,40883,31295,2,863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6065.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(873,8119,40883,31295,2,864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',400.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(874,8119,40883,31295,2,865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4345.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(875,8119,40883,31295,2,866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2708.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(876,8119,40883,31295,2,867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1285.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(877,8119,40883,31295,2,868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',480.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(878,8119,40883,31295,2,869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',610.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(879,8119,40883,31295,2,870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2339.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(880,8119,40883,31295,2,871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2960.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(881,8119,40883,31295,2,872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',860.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(882,8119,40883,31295,2,873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1075.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(883,8119,40883,31295,2,874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1490.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(884,8119,40883,31295,2,875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2460.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(885,8119,40883,31295,2,876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1220.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(886,8119,40883,31295,2,877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',940.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(887,8119,40883,31295,2,878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',940.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(888,8119,40883,31295,2,879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',940.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(889,8119,40883,31295,2,880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',400.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(890,8119,40883,31295,2,881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1000.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(891,8119,40883,31295,2,882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',940.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(892,8119,40883,31295,2,883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',895.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(893,8119,40883,31295,2,884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2500.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(894,8119,40883,31295,2,885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',7639.00,NULL,NULL,1,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(895,8119,40883,31295,2,886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2080.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL);
INSERT INTO `balance_libro` VALUES (896,8119,40883,31295,2,887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',10385.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(897,8119,40883,31295,2,888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2075.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(898,8119,40883,31295,2,889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2320.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(899,8119,40883,31295,2,890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',9105.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(900,8119,40883,31295,2,891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4280.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(901,8119,40883,31295,2,892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',755.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(902,8119,40883,31295,2,893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1480.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(903,8119,40883,31295,2,894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',9620.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(904,8119,40883,31295,2,895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1400.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(905,8119,40883,31295,2,896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',320.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(906,8119,40883,31295,2,897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1295.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(907,8119,40883,31295,2,898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',23720.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(908,8119,40883,31295,2,899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',715.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(909,8119,40883,31295,2,900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',880.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(910,8119,40883,31295,2,901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',6439.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(911,8119,40883,31295,2,902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1560.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(912,8119,40883,31295,2,903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1475.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(913,8119,40883,31295,2,904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4726.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(914,8119,40883,31295,2,905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',4726.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(915,8119,40883,31295,2,906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1845.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(916,8119,40883,31295,2,907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',14065.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(917,8119,40883,31295,2,908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',11527.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(918,8119,40883,31295,2,909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',7540.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(919,8119,40883,31295,2,910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',16000.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(920,8119,40883,31295,2,911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',980.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL);
INSERT INTO `balance_libro` VALUES (921,8119,40883,31295,2,912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1877.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(922,8119,40883,31295,2,913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2245.00,NULL,NULL,1,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(923,8119,40883,31295,2,914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2590.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(924,8119,40883,31295,2,915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',8205.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(925,8119,40883,31295,2,916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',17055.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(926,8119,40883,31295,2,917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1560.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(927,8119,40883,31295,2,918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',370.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(928,8119,40883,31295,2,919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',685.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(929,8119,40883,31295,2,920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',10349.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(930,8119,40883,31295,2,921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',610.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(931,8119,40883,31295,2,922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',830.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(932,8119,40883,31295,2,923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',630.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(933,8119,40883,31295,2,924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3835.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(934,8119,40883,31295,2,925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',830.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(935,8119,40883,31295,2,926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1050.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(936,8119,40883,31295,2,927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',430.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(937,8119,40883,31295,2,928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',430.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(938,8119,40883,31295,2,929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1015.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(939,8119,40883,31295,2,930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1395.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(940,8119,40883,31295,2,931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1365.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(941,8119,40883,31295,2,932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',4450.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(942,8119,40883,31295,2,933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',620.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(943,8119,40883,31295,2,934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3106.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(944,8119,40883,31295,2,935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1635.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(945,8119,40883,31295,2,936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1635.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL);
INSERT INTO `balance_libro` VALUES (946,8119,40883,31295,2,937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3470.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(947,8119,40883,31295,2,938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',6100.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(948,8119,40883,31295,2,939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1080.00,NULL,NULL,1,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(949,8119,40883,31295,2,940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2610.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(950,8119,40883,31295,2,941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3315.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(951,8119,40883,31295,2,942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',860.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(952,8119,40883,31295,2,943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',17800.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(953,8119,40883,31295,2,944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',985.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(954,8119,40883,31295,2,945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',985.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(955,8119,40883,31295,2,946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',6000.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(956,8119,40883,31295,2,947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',980.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(957,8119,40883,31295,2,948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',11519.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(958,8119,40883,31295,2,949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',400.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(959,8119,40883,31295,2,950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',27580.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(960,8119,40883,31295,2,951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',6488.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(961,8119,40883,31295,2,952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',740.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(962,8119,40883,31295,2,953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',745.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(963,8119,40883,31295,2,954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2250.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(964,8119,40883,31295,2,955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',460.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(965,8119,40883,31295,2,956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',680.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(966,8119,40883,31295,2,957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2110.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(967,8119,40883,31295,2,958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2365.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(968,8119,40883,31295,2,959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',980.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(969,8119,40883,31295,2,960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',6910.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(970,8119,40883,31295,2,961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',3945.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL);
INSERT INTO `balance_libro` VALUES (971,8119,40883,31295,2,962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2344.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(972,8119,40883,31295,2,963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',6645.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(973,8119,40883,31295,2,964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2629.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(974,8119,40883,31295,2,965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2580.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(975,8119,40883,31295,2,966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',15000.00,NULL,NULL,1,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(976,8119,40883,31295,2,967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',710.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(977,8119,40883,31295,2,968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',9385.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(978,8119,40883,31295,2,969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',3005.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(979,8119,40883,31295,2,970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',3485.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(980,8119,40883,31295,2,971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',480.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(981,8119,40883,31295,2,972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2905.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(982,8119,40883,31295,2,973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',2095.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(983,8119,40883,31295,2,974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',13500.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(984,8119,40883,31295,2,975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',10145.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(985,8119,40883,31295,2,976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',9385.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(986,8119,40883,31295,2,977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',4185.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(987,8119,40883,31295,2,978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',5615.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(988,8119,40883,31295,2,979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',13600.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(989,8119,40883,31295,2,980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',21500.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(990,8119,40883,31295,2,981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',16900.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(991,8119,40883,31295,2,982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',23600.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(992,8119,40883,31295,2,983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',14800.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(993,8119,40883,31295,2,984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',19580.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(994,8119,40883,31295,2,985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',16250.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL);
INSERT INTO `balance_libro` VALUES (995,8119,40883,31295,2,986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',14580.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(996,8119,40883,31295,2,987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',13650.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(997,8119,40883,31295,2,988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',18000.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(998,8119,40883,31295,2,989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19600.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(999,8119,40883,31295,2,990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',20000.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(1000,8119,40883,31295,2,991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23100.00,NULL,NULL,1,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(1001,8119,40883,31295,2,992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19330.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1002,8119,40883,31295,2,993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19660.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1003,8119,40883,31295,2,994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21600.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1004,8119,40883,31295,2,995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23600.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1005,8119,40883,31295,2,996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17665.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1006,8119,40883,31295,2,997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23650.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1007,8119,40883,31295,2,998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',25000.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1008,8119,40883,31295,2,999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13650.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1009,8119,40883,31295,2,1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17800.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1010,8119,40883,31295,2,1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15880.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1011,8119,40883,31295,2,1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',24990.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1012,8119,40883,31295,2,1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',26600.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1013,8119,40883,31295,2,1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',14990.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1014,8119,40883,31295,2,1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15000.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1015,8119,40883,31295,2,1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16780.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1016,8119,40883,31295,2,1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19850.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1017,8119,40883,31295,2,1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16990.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1018,8119,40883,31295,2,1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21800.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL);
INSERT INTO `balance_libro` VALUES (1019,8119,40883,31295,2,1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21660.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1020,8119,40883,31295,2,1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23655.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1021,8119,40883,31295,2,1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',18990.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1022,8119,40883,31295,2,1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19900.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1023,8119,40883,31295,2,1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21990.00,NULL,NULL,1,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(1024,8119,40883,31295,2,1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23550.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1025,8119,40883,31295,2,1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17550.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1026,8119,40883,31295,2,1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16600.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1027,8119,40883,31295,2,1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21660.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1028,8119,40883,31295,2,1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23445.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1029,8119,40883,31295,2,1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21770.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1030,8119,40883,31295,2,1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19223.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1031,8119,40883,31295,2,1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17440.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1032,8119,40883,31295,2,1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15990.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1033,8119,40883,31295,2,1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',14399.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1034,8119,40883,31295,2,1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19900.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1035,8119,40883,31295,2,1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21660.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1036,8119,40883,31295,2,1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',20440.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1037,8119,40883,31295,2,1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16600.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1038,8119,40883,31295,2,1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19460.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1039,8119,40883,31295,2,1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',12440.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1040,8119,40883,31295,2,1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19970.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1041,8119,40883,31295,2,1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',18915.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1042,8119,40883,31295,2,1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19980.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL);
INSERT INTO `balance_libro` VALUES (1043,8119,40883,31295,2,1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',11990.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1044,8119,40883,31295,2,1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15110.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1045,8119,40883,31295,2,1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19988.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1046,8119,40883,31295,2,1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',18663.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1047,8119,40883,31295,2,1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19447.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1048,8119,40883,31295,2,1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23440.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1049,8119,40883,31295,2,1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22440.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1050,8119,40883,31295,2,1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',24331.00,NULL,NULL,1,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(1051,8119,40883,31295,2,1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22660.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1052,8119,40883,31295,2,1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19900.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1053,8119,40883,31295,2,1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22665.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1054,8119,40883,31295,2,1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17780.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1055,8119,40883,31295,2,1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19980.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1056,8119,40883,31295,2,1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16647.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1057,8119,40883,31295,2,1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19940.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1058,8119,40883,31295,2,1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23447.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1059,8119,40883,31295,2,1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19977.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1060,8119,40883,31295,2,1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22558.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1061,8119,40883,31295,2,1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21664.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1062,8119,40883,31295,2,1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16640.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1063,8119,40883,31295,2,1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',18800.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1064,8119,40883,31295,2,1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15980.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1065,8119,40883,31295,2,1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16910.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1066,8119,40883,31295,2,1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17990.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL);
INSERT INTO `balance_libro` VALUES (1067,8119,40883,31295,2,1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',18800.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1068,8119,40883,31295,2,1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19700.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1069,8119,40883,31295,2,1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',20000.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1070,8119,40883,31295,2,1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17800.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1071,8119,40883,31295,2,1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19250.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1072,8119,40883,31295,2,1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',18750.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1073,8119,40883,31295,2,1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19800.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1074,8119,40883,31295,2,1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21500.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1075,8119,40883,31295,2,1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23694.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1076,8119,40883,31295,2,1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16250.00,NULL,NULL,1,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(1077,8119,40883,31295,2,1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17965.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1078,8119,40883,31295,2,1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19256.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1079,8119,40883,31295,2,1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17445.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1080,8119,40883,31295,2,1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15905.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1081,8119,40883,31295,2,1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16980.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1082,8119,40883,31295,2,1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',21980.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1083,8119,40883,31295,2,1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16997.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1084,8119,40883,31295,2,1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',16580.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1085,8119,40883,31295,2,1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',19880.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1086,8119,40883,31295,2,1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22510.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1087,8119,40883,31295,2,1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17665.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1088,8119,40883,31295,2,1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',13665.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1089,8119,40883,31295,2,1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23665.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1090,8119,40883,31295,2,1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',18000.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL);
INSERT INTO `balance_libro` VALUES (1091,8119,40883,31295,2,1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',22500.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1092,8119,40883,31295,2,1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',23664.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1093,8119,40883,31295,2,1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17350.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1094,8119,40883,31295,2,1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',10990.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1095,8119,40883,31295,2,1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',17990.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1096,8119,40883,31295,2,1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',18660.00,NULL,NULL,1,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(1097,8119,40883,31295,3,1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1315027.46,NULL,NULL,1,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(1098,8119,40883,31295,3,1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',987200.07,NULL,NULL,1,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(1099,8119,40883,31295,3,1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2913.76,NULL,NULL,1,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(1100,8119,40883,31295,3,1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2913.76,NULL,NULL,1,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(1101,8119,40883,31295,3,1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',190858.92,NULL,NULL,1,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(1102,8119,40883,31295,3,1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',6333.66,NULL,NULL,1,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(1103,8119,40883,31295,3,1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',17900.00,NULL,NULL,1,'2023-02-15 15:21:03','2023-02-15 16:07:23','2023-02-15 16:07:23'),(1104,8119,40883,31295,3,1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',27304.00,NULL,NULL,1,'2023-02-15 15:21:03','2023-02-15 16:07:15','2023-02-15 16:07:15'),(1105,8119,40883,31295,3,1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',64750.00,NULL,NULL,1,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(1106,8119,40856,29415,2,1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',49420.00,NULL,NULL,1,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(1107,8119,40856,29415,2,1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',30358.00,NULL,NULL,1,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(1108,8119,40856,29415,2,1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',19335.00,NULL,NULL,1,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(1109,8119,40856,29415,2,1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',9620.00,NULL,NULL,1,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(1110,8119,40856,29415,2,1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',20000.00,NULL,NULL,1,'2023-02-15 16:36:23','2023-02-15 16:37:19','2023-02-15 16:37:19'),(1111,8119,40856,29415,2,1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',9000.00,NULL,NULL,1,'2023-02-15 16:36:23','2023-02-15 16:37:11','2023-02-15 16:37:11'),(1112,8119,40856,29415,2,1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',9620.00,NULL,NULL,1,'2023-02-15 16:36:23','2023-02-15 16:37:06','2023-02-15 16:37:06'),(1113,8119,40856,29415,2,1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',34380.00,NULL,NULL,1,'2023-02-15 16:36:23','2023-02-15 16:37:01','2023-02-15 16:37:01');
INSERT INTO `balance_libro` VALUES (1114,8119,40856,29415,2,1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',39800.00,NULL,NULL,1,'2023-02-15 16:36:23','2023-02-15 16:36:55','2023-02-15 16:36:55'),(1115,8119,40856,29415,3,1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',8494.22,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:39:06','2023-02-15 16:39:06'),(1116,8119,40856,29415,3,1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',11369.51,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:38:57','2023-02-15 16:38:57'),(1117,8119,40856,29415,3,1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',20000.00,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(1118,8119,40856,29415,3,1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5654.18,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:38:48','2023-02-15 16:38:48'),(1119,8119,40856,29415,3,1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1398.00,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:38:39','2023-02-15 16:38:39'),(1120,8119,40856,29415,3,1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7811.02,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:38:29','2023-02-15 16:38:29'),(1121,8119,40856,29415,3,1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',999.00,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:38:12','2023-02-15 16:38:12'),(1122,8119,40856,29415,3,1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',53288.23,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(1123,8119,40856,29415,3,1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',50213.85,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(1124,8119,40856,29415,3,1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8544.71,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(1125,8119,40856,29415,3,1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5941.39,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(1126,8119,40856,29415,3,1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7380.00,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(1127,8119,40856,29415,3,1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8995.00,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:37:58','2023-02-15 16:37:58'),(1128,8119,40856,29415,3,1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',499.00,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(1129,8119,40856,29415,3,1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15018.02,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:37:53','2023-02-15 16:37:53'),(1130,8119,40856,29415,3,1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8353.72,NULL,NULL,1,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(1131,8119,40856,29415,2,1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',49420.00,NULL,NULL,1,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(1132,8119,40856,29415,2,1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',30358.00,NULL,NULL,1,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(1133,8119,40856,29415,2,1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',19335.00,NULL,NULL,1,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(1134,8119,40856,29415,2,1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',9620.00,NULL,NULL,1,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(1135,8119,40856,29415,2,1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',20000.00,NULL,NULL,1,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL);
INSERT INTO `balance_libro` VALUES (1136,8119,40856,29415,2,1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',9000.00,NULL,NULL,1,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(1137,8119,40856,29415,2,1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',9620.00,NULL,NULL,1,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(1138,8119,40856,29415,2,1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',34380.00,NULL,NULL,1,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(1139,8119,40856,29415,2,1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',39800.00,NULL,NULL,1,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(1140,8119,40856,29415,3,1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',8494.22,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:49:27','2023-02-15 16:49:27'),(1141,8119,40856,29415,3,1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-01','2023-01-01',11369.51,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:49:35','2023-02-15 16:49:35'),(1142,8119,40856,29415,3,1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',20000.00,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:49:43','2023-02-15 16:49:43'),(1143,8119,40856,29415,3,1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',5654.18,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:49:51','2023-02-15 16:49:51'),(1144,8119,40856,29415,3,1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1398.00,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:50:02','2023-02-15 16:50:02'),(1145,8119,40856,29415,3,1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7811.02,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(1146,8119,40856,29415,3,1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',999.00,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:50:10','2023-02-15 16:50:10'),(1147,8119,40856,29415,3,1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',53288.23,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(1148,8119,40856,29415,3,1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',50213.85,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(1149,8119,40856,29415,3,1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',8544.71,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(1150,8119,40856,29415,3,1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',5941.39,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(1151,8119,40856,29415,3,1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',7380.00,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(1152,8119,40856,29415,3,1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',8995.00,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(1153,8119,40856,29415,3,1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',499.00,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(1154,8119,40856,29415,3,1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15018.02,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(1155,8119,40856,29415,3,1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8353.72,NULL,NULL,1,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(1156,8119,40741,3352,2,1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',246191.20,NULL,NULL,1,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(1157,8119,40741,3352,2,1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',233520.80,NULL,NULL,1,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(1158,8119,40741,3352,2,1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',43156.20,NULL,NULL,1,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(1159,8119,40741,3352,2,1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',251175.50,NULL,NULL,1,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL);
INSERT INTO `balance_libro` VALUES (1160,8119,40741,3352,2,1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',80725.60,NULL,NULL,1,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(1161,8119,40741,3352,2,1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',125960.40,NULL,NULL,1,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(1162,8119,40741,3352,2,1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',246191.20,NULL,NULL,1,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(1163,8119,40741,3352,2,1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',255354.60,NULL,NULL,1,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(1164,8119,40741,3352,2,1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',134576.00,NULL,NULL,1,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(1165,8119,40741,3352,2,1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',302074.80,NULL,NULL,1,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(1166,8119,40741,3352,3,1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',800020.00,NULL,NULL,1,'2023-02-16 08:39:16','2023-02-16 08:39:16',NULL),(1167,8119,40720,1548,3,1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',53585.71,NULL,NULL,1,'2023-02-16 08:56:54','2023-02-16 08:56:54',NULL),(1168,8119,40720,1548,3,1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',164656.80,NULL,NULL,1,'2023-02-16 08:58:20','2023-02-16 09:14:04','2023-02-16 09:14:04'),(1169,8119,40720,1548,3,1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',511830.00,NULL,NULL,1,'2023-02-16 09:00:15','2023-02-16 09:00:15',NULL),(1170,8119,40720,1548,3,1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',326700.00,NULL,NULL,1,'2023-02-16 09:00:51','2023-02-16 09:00:51',NULL),(1171,8119,40720,1548,3,1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',459800.00,NULL,NULL,1,'2023-02-16 09:01:35','2023-02-16 09:01:35',NULL),(1172,8119,40720,1548,3,1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',191422.00,NULL,NULL,1,'2023-02-16 09:02:03','2023-02-16 09:02:03',NULL),(1173,8119,40720,1548,3,1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',471228.45,NULL,NULL,1,'2023-02-16 09:03:07','2023-02-16 09:03:07',NULL),(1174,8119,40720,1548,3,1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',303468.00,NULL,NULL,1,'2023-02-16 09:03:35','2023-02-16 09:03:35',NULL),(1175,8119,40720,1548,3,1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',870151.28,NULL,NULL,1,'2023-02-16 09:04:35','2023-02-16 09:04:35',NULL),(1176,8119,40720,1548,3,1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',328757.00,NULL,NULL,1,'2023-02-16 09:05:17','2023-02-16 09:05:17',NULL),(1177,8119,40720,1548,3,1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',417450.00,NULL,NULL,1,'2023-02-16 09:05:50','2023-02-16 09:05:50',NULL),(1178,8119,40720,1548,3,1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',529508.10,NULL,NULL,1,'2023-02-16 09:06:22','2023-02-16 09:06:22',NULL),(1179,8119,40720,1548,3,1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',378965.95,NULL,NULL,1,'2023-02-16 09:06:51','2023-02-16 09:06:51',NULL),(1180,8119,40720,1548,3,1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',366041.94,NULL,NULL,1,'2023-02-16 09:07:34','2023-02-16 09:07:34',NULL),(1181,8119,40720,1548,3,1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',676428.72,NULL,NULL,1,'2023-02-16 09:08:07','2023-02-16 09:08:07',NULL),(1182,8119,40720,1548,2,1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',429283.80,NULL,NULL,1,'2023-02-16 09:11:41','2023-02-16 09:11:41',NULL),(1183,8119,40720,1548,2,1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',257468.64,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL);
INSERT INTO `balance_libro` VALUES (1184,8119,40720,1548,2,1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',226983.90,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1185,8119,40720,1548,2,1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',631553.45,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1186,8119,40720,1548,2,1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',223390.20,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1187,8119,40720,1548,2,1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',235950.00,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1188,8119,40720,1548,2,1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',232174.80,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1189,8119,40720,1548,2,1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',220304.70,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1190,8119,40720,1548,2,1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1241702.00,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1191,8119,40720,1548,2,1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',617100.00,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1192,8119,40720,1548,2,1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1588125.00,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1193,8119,40720,1548,2,1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15246000.00,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1194,8119,40720,1548,2,1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',227455.80,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1195,8119,40720,1548,2,1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',298821.60,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1196,8119,40720,1548,2,1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1524600.00,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1197,8119,40720,1548,2,1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',393250.00,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1198,8119,40720,1548,2,1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',15246000.00,NULL,NULL,1,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(1199,8119,40720,1548,3,1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',34790.16,NULL,NULL,1,'2023-02-16 09:11:49','2023-02-16 09:11:49',NULL),(1200,8119,40720,1548,3,1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',66319.26,NULL,NULL,1,'2023-02-16 09:11:49','2023-02-16 09:11:49',NULL),(1201,8119,40720,1548,3,1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2880.00,NULL,NULL,1,'2023-02-16 09:11:49','2023-02-16 09:15:26','2023-02-16 09:15:26'),(1202,8119,40720,1548,3,1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',15500.00,NULL,NULL,1,'2023-02-16 09:11:50','2023-02-16 09:15:21','2023-02-16 09:15:21'),(1203,8119,40720,1548,3,1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',44241.04,NULL,NULL,1,'2023-02-16 09:11:50','2023-02-16 09:15:07','2023-02-16 09:15:07'),(1204,8119,40720,1548,3,1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',164656.80,NULL,NULL,1,'2023-02-16 09:14:04','2023-02-16 09:14:04',NULL),(1205,8119,40775,18806,2,1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',259908.00,NULL,NULL,1,'2023-02-19 12:07:35','2023-02-19 12:09:31','2023-02-19 12:09:31'),(1206,8119,40775,18806,2,1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',32186.00,NULL,NULL,1,'2023-02-19 12:07:35','2023-02-19 12:09:57','2023-02-19 12:09:57');
INSERT INTO `balance_libro` VALUES (1207,8119,40775,18806,2,1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',13915.00,NULL,NULL,1,'2023-02-19 12:07:35','2023-02-19 12:11:05','2023-02-19 12:11:05'),(1208,8119,40775,18806,2,1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',6665.00,NULL,NULL,1,'2023-02-19 12:07:35','2023-02-19 12:11:47','2023-02-19 12:11:47'),(1209,8119,40775,18806,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',42000.00,NULL,NULL,1,'2023-02-19 12:07:35','2023-02-19 12:12:42','2023-02-19 12:12:42'),(1210,8119,40775,18806,2,1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',178000.00,NULL,NULL,1,'2023-02-19 12:07:35','2023-02-19 12:12:59','2023-02-19 12:12:59'),(1211,8119,40775,18806,2,1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',28500.00,NULL,NULL,1,'2023-02-19 12:07:35','2023-02-19 12:48:14','2023-02-19 12:48:14'),(1212,8119,40775,18806,2,1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',54329.00,NULL,NULL,1,'2023-02-19 12:07:35','2023-02-19 12:10:50','2023-02-19 12:10:50'),(1213,8119,40775,18806,2,1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',66500.00,NULL,NULL,1,'2023-02-19 12:07:35','2023-02-19 12:42:56','2023-02-19 12:42:56'),(1214,8119,40775,18806,2,1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',133000.00,NULL,NULL,1,'2023-02-19 12:07:35','2023-02-19 12:41:28','2023-02-19 12:41:28'),(1215,8119,40775,18806,3,1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',27522.94,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1216,8119,40775,18806,3,1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',11437.47,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1217,8119,40775,18806,3,1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',13499.00,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1218,8119,40775,18806,3,1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1200.80,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1219,8119,40775,18806,3,1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',5107.02,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1220,8119,40775,18806,3,1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',7967.48,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-28 12:46:16','2023-02-28 12:46:16'),(1221,8119,40775,18806,3,1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',23716.80,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1222,8119,40775,18806,3,1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',3063.36,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1223,8119,40775,18806,3,1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1652.09,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1224,8119,40775,18806,3,1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',9519.00,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1225,8119,40775,18806,3,1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1800.00,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-28 12:46:04','2023-02-28 12:46:04'),(1226,8119,40775,18806,3,1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3566.12,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1227,8119,40775,18806,3,1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',18999.00,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1228,8119,40775,18806,3,1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',398.91,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1229,8119,40775,18806,3,1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',4085.62,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL);
INSERT INTO `balance_libro` VALUES (1230,8119,40775,18806,3,1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',11000.03,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1231,8119,40775,18806,3,1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',24982.70,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1232,8119,40775,18806,3,1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',5107.02,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1233,8119,40775,18806,3,1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',5106.88,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1234,8119,40775,18806,3,1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',5664.32,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1235,8119,40775,18806,3,1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',4215.28,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1236,8119,40775,18806,3,1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',26800.00,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1237,8119,40775,18806,3,1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',8845.66,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1238,8119,40775,18806,3,1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1848.08,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1239,8119,40775,18806,3,1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',26201.97,NULL,NULL,1,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(1240,8119,40775,18806,3,1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4084.88,NULL,NULL,1,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(1241,8119,40775,18806,3,1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',5923.46,NULL,NULL,1,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(1242,8119,40775,18806,3,1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',121987.73,NULL,NULL,1,'2023-02-19 12:08:33','2023-02-28 12:48:53','2023-02-28 12:48:53'),(1243,8119,40775,18806,3,1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',4396.17,NULL,NULL,1,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(1244,8119,40775,18806,3,1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1603.25,NULL,NULL,1,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(1245,8119,40775,18806,3,1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',87920.00,NULL,NULL,1,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(1246,8119,40775,18806,3,1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10416.24,NULL,NULL,1,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(1247,8119,40775,18806,3,1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2670.45,NULL,NULL,1,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(1248,8119,40775,18806,3,1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',7465.08,NULL,NULL,1,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(1249,8119,40775,18806,3,1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',434.13,NULL,NULL,1,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(1250,8119,40775,18806,3,1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',46000.00,NULL,NULL,1,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(1251,8119,40775,18806,3,1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2643.55,NULL,NULL,1,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(1252,8119,40775,18806,3,1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6842.23,NULL,NULL,1,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(1253,8119,40775,18806,2,1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',259908.00,NULL,NULL,1,'2023-02-19 12:09:31','2023-02-19 12:09:42','2023-02-19 12:09:42');
INSERT INTO `balance_libro` VALUES (1254,8119,40775,18806,2,1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',259908.00,NULL,NULL,1,'2023-02-19 12:09:42','2023-02-19 12:09:42',NULL),(1255,8119,40775,18806,2,1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',32186.00,NULL,NULL,1,'2023-02-19 12:09:57','2023-02-19 12:09:57',NULL),(1256,8119,40775,18806,2,1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',54329.00,NULL,NULL,1,'2023-02-19 12:10:50','2023-02-19 12:10:50',NULL),(1257,8119,40775,18806,2,1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',13915.00,NULL,NULL,1,'2023-02-19 12:11:05','2023-02-19 12:11:05',NULL),(1258,8119,40775,18806,2,1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',6664.99,NULL,NULL,1,'2023-02-19 12:11:47','2023-02-19 12:11:47',NULL),(1259,8119,40775,18806,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',42000.00,NULL,NULL,1,'2023-02-19 12:12:42','2023-02-19 12:44:56','2023-02-19 12:44:56'),(1260,8119,40775,18806,2,1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',178000.00,NULL,NULL,1,'2023-02-19 12:12:59','2023-02-19 12:47:40','2023-02-19 12:47:40'),(1261,8119,40775,18806,2,1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',899333.33,NULL,NULL,1,'2023-02-19 12:41:28','2023-02-19 12:41:40','2023-02-19 12:41:40'),(1262,8119,40775,18806,2,1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',766333.33,NULL,NULL,1,'2023-02-19 12:41:40','2023-02-28 12:33:16','2023-02-28 12:33:16'),(1263,8119,40775,18806,2,1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',766335.33,NULL,NULL,1,'2023-02-19 12:42:56','2023-02-19 12:43:07','2023-02-19 12:43:07'),(1264,8119,40775,18806,2,1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',383167.66,NULL,NULL,1,'2023-02-19 12:43:07','2023-02-28 12:33:36','2023-02-28 12:33:36'),(1265,8119,40775,18806,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',204200.00,NULL,NULL,1,'2023-02-19 12:44:56','2023-02-19 12:45:27','2023-02-19 12:45:27'),(1266,8119,40775,18806,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',620000.00,NULL,NULL,1,'2023-02-19 12:45:27','2023-02-19 12:46:49','2023-02-19 12:46:49'),(1267,8119,40775,18806,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',242000.00,NULL,NULL,1,'2023-02-19 12:46:49','2023-02-28 12:35:36','2023-02-28 12:35:36'),(1268,8119,40775,18806,2,1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1025619.05,NULL,NULL,1,'2023-02-19 12:47:40','2023-02-28 12:34:14','2023-02-28 12:34:14'),(1269,8119,40775,18806,2,1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',164214.29,NULL,NULL,1,'2023-02-19 12:48:14','2023-02-28 12:33:57','2023-02-28 12:33:57'),(1270,8119,40767,6496,2,1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4900.00,NULL,NULL,1,'2023-02-19 13:12:56','2023-02-19 13:15:39','2023-02-19 13:15:39'),(1271,8119,40767,6496,2,1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',40000.00,NULL,NULL,1,'2023-02-19 13:12:56','2023-02-19 13:58:39','2023-02-19 13:58:39'),(1272,8119,40767,6496,2,1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8350.00,NULL,NULL,1,'2023-02-19 13:12:56','2023-02-19 13:15:56','2023-02-19 13:15:56'),(1273,8119,40767,6496,2,1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',32000.00,NULL,NULL,1,'2023-02-19 13:12:56','2023-02-19 13:16:16','2023-02-19 13:16:16'),(1274,8119,40767,6496,2,1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',15500.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:16:37','2023-02-19 13:16:37'),(1275,8119,40767,6496,2,1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',17500.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 14:00:51','2023-02-19 14:00:51');
INSERT INTO `balance_libro` VALUES (1276,8119,40767,6496,2,1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8050.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:55:24','2023-02-19 13:55:24'),(1277,8119,40767,6496,2,1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',45000.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:55:37','2023-02-19 13:55:37'),(1278,8119,40767,6496,2,1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',32000.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:55:57','2023-02-19 13:55:57'),(1279,8119,40767,6496,2,1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7500.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:56:07','2023-02-19 13:56:07'),(1280,8119,40767,6496,2,1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',22150.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:56:22','2023-02-19 13:56:22'),(1281,8119,40767,6496,2,1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',25050.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:56:37','2023-02-19 13:56:37'),(1282,8119,40767,6496,2,1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',15050.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:56:48','2023-02-19 13:56:48'),(1283,8119,40767,6496,2,1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',16700.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:57:03','2023-02-19 13:57:03'),(1284,8119,40767,6496,2,1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',29500.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:57:11','2023-02-19 13:57:11'),(1285,8119,40767,6496,2,1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',26000.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 14:01:01','2023-02-19 14:01:01'),(1286,8119,40767,6496,2,1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',9500.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 14:01:09','2023-02-19 14:01:09'),(1287,8119,40767,6496,2,1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8500.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:57:42','2023-02-19 13:57:42'),(1288,8119,40767,6496,2,1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',33000.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:57:53','2023-02-19 13:57:53'),(1289,8119,40767,6496,2,1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',9000.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:58:07','2023-02-19 13:58:07'),(1290,8119,40767,6496,2,1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',33000.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:58:16','2023-02-19 13:58:16'),(1291,8119,40767,6496,2,1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',13090.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 14:01:19','2023-02-19 14:01:19'),(1292,8119,40767,6496,2,1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10600.00,NULL,NULL,1,'2023-02-19 13:12:57','2023-02-19 13:59:02','2023-02-19 13:59:02'),(1293,8119,40767,6496,3,1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',23716.00,NULL,NULL,1,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(1294,8119,40767,6496,3,1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',4800.00,NULL,NULL,1,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(1295,8119,40767,6496,3,1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1047.23,NULL,NULL,1,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(1296,8119,40767,6496,3,1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1047.23,NULL,NULL,1,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(1297,8119,40767,6496,3,1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1055.42,NULL,NULL,1,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(1298,8119,40767,6496,3,1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1055.42,NULL,NULL,1,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL);
INSERT INTO `balance_libro` VALUES (1299,8119,40767,6496,3,1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1047.23,NULL,NULL,1,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(1300,8119,40767,6496,3,1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',665.45,NULL,NULL,1,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(1301,8119,40767,6496,3,1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1047.23,NULL,NULL,1,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(1302,8119,40767,6496,3,1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',60.00,NULL,NULL,1,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(1303,8119,40767,6496,3,1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',995.00,NULL,NULL,1,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(1304,8119,40767,6496,3,1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',579.18,NULL,NULL,1,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(1305,8119,40767,6496,3,1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1047.23,NULL,NULL,1,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(1306,8119,40767,6496,3,1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',961.37,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1307,8119,40767,6496,3,1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',68.00,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1308,8119,40767,6496,3,1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',51.00,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1309,8119,40767,6496,3,1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',132500.00,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1310,8119,40767,6496,3,1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1620.71,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1311,8119,40767,6496,3,1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1047.23,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1312,8119,40767,6496,3,1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',961.37,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1313,8119,40767,6496,3,1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',677.60,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1314,8119,40767,6496,3,1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',420.00,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1315,8119,40767,6496,3,1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',150.00,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1316,8119,40767,6496,3,1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1047.23,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1317,8119,40767,6496,3,1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',961.37,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1318,8119,40767,6496,3,1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1055.42,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1319,8119,40767,6496,3,1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1047.23,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1320,8119,40767,6496,3,1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1047.23,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1321,8119,40767,6496,3,1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1047.23,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1322,8119,40767,6496,3,1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',155392.81,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL);
INSERT INTO `balance_libro` VALUES (1323,8119,40767,6496,3,1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',636.99,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1324,8119,40767,6496,3,1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',961.37,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1325,8119,40767,6496,3,1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',636.99,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1326,8119,40767,6496,3,1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',27961.36,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1327,8119,40767,6496,3,1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',15387.15,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1328,8119,40767,6496,3,1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1000.00,NULL,NULL,1,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(1329,8119,40767,6496,2,1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',4900.00,NULL,NULL,1,'2023-02-19 13:15:39','2023-02-19 13:15:39',NULL),(1330,8119,40767,6496,2,1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8350.00,NULL,NULL,1,'2023-02-19 13:15:56','2023-02-19 13:15:56',NULL),(1331,8119,40767,6496,2,1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',32000.00,NULL,NULL,1,'2023-02-19 13:16:16','2023-02-19 13:16:16',NULL),(1332,8119,40767,6496,2,1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',15500.00,NULL,NULL,1,'2023-02-19 13:16:37','2023-02-19 13:16:37',NULL),(1333,8119,40767,6496,2,1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8050.00,NULL,NULL,1,'2023-02-19 13:55:24','2023-02-19 13:55:24',NULL),(1334,8119,40767,6496,2,1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',45000.00,NULL,NULL,1,'2023-02-19 13:55:37','2023-02-19 13:55:37',NULL),(1335,8119,40767,6496,2,1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',32000.00,NULL,NULL,1,'2023-02-19 13:55:57','2023-02-19 13:55:57',NULL),(1336,8119,40767,6496,2,1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',7500.00,NULL,NULL,1,'2023-02-19 13:56:07','2023-02-19 13:56:07',NULL),(1337,8119,40767,6496,2,1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',22150.00,NULL,NULL,1,'2023-02-19 13:56:22','2023-02-19 13:56:22',NULL),(1338,8119,40767,6496,2,1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',25050.00,NULL,NULL,1,'2023-02-19 13:56:37','2023-02-19 13:56:37',NULL),(1339,8119,40767,6496,2,1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',15050.00,NULL,NULL,1,'2023-02-19 13:56:48','2023-02-19 13:56:48',NULL),(1340,8119,40767,6496,2,1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',16700.00,NULL,NULL,1,'2023-02-19 13:57:03','2023-02-19 13:57:03',NULL),(1341,8119,40767,6496,2,1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',29500.00,NULL,NULL,1,'2023-02-19 13:57:11','2023-02-19 13:57:11',NULL),(1342,8119,40767,6496,2,1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',8500.00,NULL,NULL,1,'2023-02-19 13:57:42','2023-02-19 13:57:42',NULL),(1343,8119,40767,6496,2,1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',33000.00,NULL,NULL,1,'2023-02-19 13:57:53','2023-02-19 13:57:53',NULL),(1344,8119,40767,6496,2,1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',9000.00,NULL,NULL,1,'2023-02-19 13:58:07','2023-02-19 13:58:07',NULL),(1345,8119,40767,6496,2,1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',33000.00,NULL,NULL,1,'2023-02-19 13:58:16','2023-02-19 13:58:16',NULL),(1346,8119,40767,6496,2,1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',40000.00,NULL,NULL,1,'2023-02-19 13:58:39','2023-02-19 13:58:39',NULL);
INSERT INTO `balance_libro` VALUES (1347,8119,40767,6496,2,1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',10600.00,NULL,NULL,1,'2023-02-19 13:59:02','2023-02-19 13:59:02',NULL),(1348,8119,40767,6496,2,1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',17500.00,NULL,NULL,1,'2023-02-19 14:00:51','2023-02-19 14:00:51',NULL),(1349,8119,40767,6496,2,1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',26000.00,NULL,NULL,1,'2023-02-19 14:01:01','2023-02-19 14:01:01',NULL),(1350,8119,40767,6496,2,1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',9500.00,NULL,NULL,1,'2023-02-19 14:01:09','2023-02-19 14:01:09',NULL),(1351,8119,40767,6496,2,1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',13090.00,NULL,NULL,1,'2023-02-19 14:01:19','2023-02-19 14:01:19',NULL),(1354,8119,40775,18806,8,1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',52037.81,NULL,NULL,1,'2023-02-28 12:01:18','2023-02-28 12:01:18',NULL),(1355,8119,40775,18806,7,1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1165.29,NULL,NULL,1,'2023-02-28 12:10:45','2023-02-28 12:10:45',NULL),(1356,8119,40775,18806,7,1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2942.15,NULL,NULL,1,'2023-02-28 12:10:45','2023-02-28 12:10:45',NULL),(1357,8119,40775,18806,7,1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1358,8119,40775,18806,7,1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1359,8119,40775,18806,7,1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1360,8119,40775,18806,7,1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1361,8119,40775,18806,7,1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1362,8119,40775,18806,7,1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1363,8119,40775,18806,7,1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1364,8119,40775,18806,7,1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1365,8119,40775,18806,7,1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1366,8119,40775,18806,7,1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1367,8119,40775,18806,7,1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1368,8119,40775,18806,7,1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1369,8119,40775,18806,7,1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1370,8119,40775,18806,7,1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1371,8119,40775,18806,7,1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1372,8119,40775,18806,7,1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(1373,8119,40775,18806,7,1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.97,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL);
INSERT INTO `balance_libro` VALUES (1374,8119,40775,18806,7,1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.49,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1375,8119,40775,18806,7,1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.24,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1376,8119,40775,18806,7,1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.84,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1377,8119,40775,18806,7,1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.75,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1378,8119,40775,18806,7,1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.56,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1379,8119,40775,18806,7,1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.02,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1380,8119,40775,18806,7,1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.36,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1381,8119,40775,18806,7,1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.62,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1382,8119,40775,18806,7,1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.02,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1383,8119,40775,18806,7,1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.88,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1384,8119,40775,18806,7,1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.76,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1385,8119,40775,18806,7,1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.96,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1386,8119,40775,18806,7,1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.48,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1387,8119,40775,18806,7,1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.43,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1388,8119,40775,18806,7,1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'1969-12-31','1969-12-31',0.94,NULL,NULL,1,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(1389,8119,40775,18806,16,NULL,390,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',81059.67,NULL,NULL,1,'2023-02-28 12:29:06','2023-02-28 12:32:52','2023-02-28 12:32:52'),(1390,8119,40775,18806,2,1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',133000.01,NULL,NULL,1,'2023-02-28 12:33:16','2023-02-28 12:33:16',NULL),(1391,8119,40775,18806,2,1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',66500.00,NULL,NULL,1,'2023-02-28 12:33:36','2023-02-28 12:33:36',NULL),(1392,8119,40775,18806,2,1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',28500.00,NULL,NULL,1,'2023-02-28 12:33:57','2023-02-28 12:33:57',NULL),(1393,8119,40775,18806,2,1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',178000.00,NULL,NULL,1,'2023-02-28 12:34:14','2023-02-28 12:34:14',NULL),(1394,8119,40775,18806,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',42000.00,NULL,NULL,1,'2023-02-28 12:35:36','2023-02-28 12:35:36',NULL),(1395,8119,40775,18806,3,1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',5000.01,NULL,NULL,1,'2023-02-28 12:38:55','2023-02-28 12:38:55',NULL),(1396,8119,40775,18806,16,NULL,402,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',80212.09,NULL,NULL,1,'2023-02-28 12:42:01','2023-02-28 12:45:47','2023-02-28 12:45:47'),(1397,8119,40775,18806,3,1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',121987.71,NULL,NULL,1,'2023-02-28 12:48:53','2023-02-28 12:48:53',NULL);
INSERT INTO `balance_libro` VALUES (1398,8119,40775,18806,15,NULL,407,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',159780.34,NULL,NULL,1,'2023-02-28 12:52:32','2023-02-28 12:52:32',NULL),(1399,8119,40775,18806,16,NULL,408,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',81059.67,NULL,NULL,1,'2023-02-28 12:54:30','2023-02-28 12:54:30',NULL),(1400,8119,40720,1549,2,1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',224152.50,NULL,NULL,1,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(1401,8119,40720,1549,2,1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',256132.80,NULL,NULL,1,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(1402,8119,40720,1549,2,1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',229343.40,NULL,NULL,1,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(1403,8119,40720,1549,2,1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',276333.75,NULL,NULL,1,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(1404,8119,40720,1549,2,1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',276333.75,NULL,NULL,1,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(1405,8119,40720,1549,2,1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',243500.40,NULL,NULL,1,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(1406,8119,40720,1549,2,1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',237365.70,NULL,NULL,1,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(1407,8119,40720,1549,2,1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',192912.72,NULL,NULL,1,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(1408,8119,40720,1549,2,1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',311334.21,NULL,NULL,1,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(1409,8119,40720,1549,2,1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',354814.35,NULL,NULL,1,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(1410,8119,40720,1549,2,1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',290400.00,NULL,NULL,1,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(1411,8119,40720,1549,2,1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',968145.20,NULL,NULL,1,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(1412,8119,40720,1549,2,1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',367900.50,NULL,NULL,1,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(1413,8119,40720,1549,2,1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2411167.00,NULL,NULL,1,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(1414,8119,40720,1549,2,1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',784806.00,NULL,NULL,1,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL);
/*!40000 ALTER TABLE `balance_libro` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro_details`
--

DROP TABLE IF EXISTS `balance_libro_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `balance_libro_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_details_person_id_foreign` (`person_id`),
  KEY `balance_libro_details_period_id_foreign` (`period_id`),
  KEY `balance_libro_details_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_details_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_libro_details_saldo_id_foreign` (`saldo_id`),
  KEY `balance_libro_details_balance_libro_id_foreign` (`balance_libro_id`),
  CONSTRAINT `balance_libro_details_balance_libro_id_foreign` FOREIGN KEY (`balance_libro_id`) REFERENCES `balance_libro` (`id`) ON DELETE CASCADE,
  CONSTRAINT `balance_libro_details_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_details_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`),
  CONSTRAINT `balance_libro_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4330 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro_details`
--

LOCK TABLES `balance_libro_details` WRITE;
/*!40000 ALTER TABLE `balance_libro_details` DISABLE KEYS */;
INSERT INTO `balance_libro_details` VALUES (1,8119,1,40741,3350,2,96,2,1164949.59,NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(2,8119,1,40741,3350,2,67,2,244639.41,NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(3,8119,1,40741,3350,2,13,1,1409589.00,NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(4,8119,2,40741,3350,2,96,2,1561757.99,NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(5,8119,2,40741,3350,2,67,2,163984.61,NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(6,8119,2,40741,3350,2,13,1,1725742.60,NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(7,8119,3,40741,3350,2,96,2,260437.01,NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(8,8119,3,40741,3350,2,67,2,29558.69,NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(9,8119,3,40741,3350,2,13,1,289995.70,NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(10,8119,4,40741,3350,2,96,2,66653.57,NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(11,8119,4,40741,3350,2,67,2,6998.63,NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(12,8119,4,40741,3350,2,13,1,73652.20,NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(13,8119,5,40741,3350,3,217,1,8400.00,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(14,8119,5,40741,3350,3,68,1,882.00,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(15,8119,5,40741,3350,3,217,1,147.00,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(16,8119,5,40741,3350,3,57,2,9429.00,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(17,8119,6,40741,3350,3,217,1,768400.00,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(18,8119,6,40741,3350,3,68,1,80682.00,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(19,8119,6,40741,3350,3,57,2,849082.00,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(20,8119,7,40741,3350,3,217,1,22464.00,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(21,8119,7,40741,3350,3,68,1,2358.72,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(22,8119,7,40741,3350,3,57,2,24822.72,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(23,8119,8,40741,3350,3,217,1,26008.00,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(24,8119,8,40741,3350,3,68,1,2730.84,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(25,8119,8,40741,3350,3,217,1,455.14,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(26,8119,8,40741,3350,3,57,2,29193.98,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(27,8119,9,40741,3350,3,217,1,99824.00,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(28,8119,9,40741,3350,3,68,1,10481.52,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(29,8119,9,40741,3350,3,217,1,1746.92,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(30,8119,9,40741,3350,3,57,2,112052.44,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(31,8119,10,40741,3350,3,217,1,70512.00,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(32,8119,10,40741,3350,3,68,1,7403.76,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(33,8119,10,40741,3350,3,57,2,77915.76,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(34,8119,11,40741,3350,3,217,1,928420.37,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(35,8119,11,40741,3350,3,68,1,97484.14,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(36,8119,11,40741,3350,3,217,1,16247.36,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(37,8119,11,40741,3350,3,57,2,1042151.87,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(38,8119,12,40741,3350,3,217,1,1128495.37,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(39,8119,12,40741,3350,3,68,1,118492.01,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(40,8119,12,40741,3350,3,217,1,19748.67,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(41,8119,12,40741,3350,3,57,2,1266736.05,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(42,8119,13,40741,3350,3,217,1,615257.00,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL);
INSERT INTO `balance_libro_details` VALUES (43,8119,13,40741,3350,3,68,1,64601.98,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(44,8119,13,40741,3350,3,57,2,679858.98,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(45,8119,14,40741,3350,3,217,1,172054.96,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(46,8119,14,40741,3350,3,68,1,18065.77,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(47,8119,14,40741,3350,3,217,1,3010.96,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(48,8119,14,40741,3350,3,57,2,193131.69,NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(49,8119,16,40720,1543,2,96,2,130383.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(50,8119,16,40720,1543,2,67,2,27380.43,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(51,8119,16,40720,1543,2,13,1,157763.43,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(52,8119,17,40720,1543,2,96,2,191400.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(53,8119,17,40720,1543,2,67,2,40194.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(54,8119,17,40720,1543,2,13,1,231594.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(55,8119,18,40720,1543,2,96,2,192984.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(56,8119,18,40720,1543,2,67,2,40526.64,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(57,8119,18,40720,1543,2,13,1,233510.64,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(58,8119,19,40720,1543,2,96,2,186405.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(59,8119,19,40720,1543,2,67,2,39145.05,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(60,8119,19,40720,1543,2,13,1,225550.05,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(61,8119,20,40720,1543,2,96,2,184875.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(62,8119,20,40720,1543,2,67,2,38823.75,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(63,8119,20,40720,1543,2,13,1,223698.75,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(64,8119,21,40720,1543,2,96,2,131571.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(65,8119,21,40720,1543,2,67,2,27629.91,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(66,8119,21,40720,1543,2,13,1,159200.91,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(67,8119,22,40720,1543,2,96,2,125538.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(68,8119,22,40720,1543,2,67,2,26362.98,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(69,8119,22,40720,1543,2,13,1,151900.98,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(70,8119,23,40720,1543,2,96,1,192984.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(71,8119,23,40720,1543,2,68,1,40526.64,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(72,8119,23,40720,1543,2,13,2,233510.64,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(73,8119,24,40720,1543,2,96,1,191400.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(74,8119,24,40720,1543,2,68,1,40194.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(75,8119,24,40720,1543,2,13,2,231594.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(76,8119,25,40720,1543,2,96,2,542445.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(77,8119,25,40720,1543,2,67,2,113913.45,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(78,8119,25,40720,1543,2,13,1,656358.45,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(79,8119,26,40720,1543,2,96,2,184110.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(80,8119,26,40720,1543,2,67,2,38663.10,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(81,8119,26,40720,1543,2,13,1,222773.10,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(82,8119,27,40720,1543,2,96,2,85260.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(83,8119,27,40720,1543,2,67,2,17904.60,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(84,8119,27,40720,1543,2,13,1,103164.60,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL);
INSERT INTO `balance_libro_details` VALUES (85,8119,28,40720,1543,2,96,2,202800.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(86,8119,28,40720,1543,2,67,2,42588.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(87,8119,28,40720,1543,2,13,1,245388.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(88,8119,29,40720,1543,2,96,2,168696.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(89,8119,29,40720,1543,2,67,2,35426.16,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(90,8119,29,40720,1543,2,13,1,204122.16,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(91,8119,30,40720,1543,2,96,2,150876.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(92,8119,30,40720,1543,2,67,2,31683.96,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(93,8119,30,40720,1543,2,13,1,182559.96,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(94,8119,31,40720,1543,2,96,2,190995.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(95,8119,31,40720,1543,2,67,2,40108.95,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(96,8119,31,40720,1543,2,13,1,231103.95,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(97,8119,32,40720,1543,2,96,2,98490.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(98,8119,32,40720,1543,2,67,2,20682.90,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(99,8119,32,40720,1543,2,13,1,119172.90,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(100,8119,33,40720,1543,2,96,2,175230.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(101,8119,33,40720,1543,2,67,2,36798.30,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(102,8119,33,40720,1543,2,13,1,212028.30,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(103,8119,34,40720,1543,2,96,2,303600.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(104,8119,34,40720,1543,2,67,2,63756.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(105,8119,34,40720,1543,2,13,1,367356.00,NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(106,8119,35,40720,1543,2,96,2,102606.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(107,8119,35,40720,1543,2,67,2,21547.26,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(108,8119,35,40720,1543,2,13,1,124153.26,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(109,8119,36,40720,1543,2,96,2,692730.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(110,8119,36,40720,1543,2,67,2,145473.30,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(111,8119,36,40720,1543,2,13,1,838203.30,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(112,8119,37,40720,1543,2,96,2,655200.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(113,8119,37,40720,1543,2,67,2,137592.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(114,8119,37,40720,1543,2,13,1,792792.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(115,8119,38,40720,1543,2,96,2,355000.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(116,8119,38,40720,1543,2,67,2,74550.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(117,8119,38,40720,1543,2,13,1,429550.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(118,8119,39,40720,1543,2,96,2,655200.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(119,8119,39,40720,1543,2,67,2,137592.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(120,8119,39,40720,1543,2,13,1,792792.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(121,8119,40,40720,1543,2,96,1,655200.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(122,8119,40,40720,1543,2,68,1,137592.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(123,8119,40,40720,1543,2,13,2,792792.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(124,8119,41,40720,1543,2,96,2,102900.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(125,8119,41,40720,1543,2,67,2,21609.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(126,8119,41,40720,1543,2,13,1,124509.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL);
INSERT INTO `balance_libro_details` VALUES (127,8119,42,40720,1543,2,96,2,1274700.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(128,8119,42,40720,1543,2,67,2,267687.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(129,8119,42,40720,1543,2,13,1,1542387.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(130,8119,43,40720,1543,2,96,2,518700.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(131,8119,43,40720,1543,2,67,2,108927.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(132,8119,43,40720,1543,2,13,1,627627.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(133,8119,44,40720,1543,2,96,2,135960.00,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(134,8119,44,40720,1543,2,67,2,28551.60,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(135,8119,44,40720,1543,2,13,1,164511.60,NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(136,8119,45,40720,1543,3,217,1,91384.68,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(137,8119,45,40720,1543,3,68,1,19190.78,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(138,8119,45,40720,1543,3,57,2,110575.46,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(139,8119,46,40720,1543,3,217,1,106328.25,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(140,8119,46,40720,1543,3,68,1,22328.93,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(141,8119,46,40720,1543,3,57,2,128657.18,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(142,8119,47,40720,1543,3,217,1,77861.30,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(143,8119,47,40720,1543,3,68,1,16350.87,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(144,8119,47,40720,1543,3,217,1,0.01,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(145,8119,47,40720,1543,3,57,2,94212.18,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(146,8119,48,40720,1543,3,250,1,0.00,NULL,'2022-12-20 15:27:09','2022-12-20 16:27:45','2022-12-20 16:27:45'),(147,8119,48,40720,1543,3,250,1,1490.00,NULL,'2022-12-20 15:27:09','2022-12-20 16:27:45','2022-12-20 16:27:45'),(148,8119,48,40720,1543,3,57,2,1490.00,NULL,'2022-12-20 15:27:09','2022-12-20 16:27:45','2022-12-20 16:27:45'),(149,8119,49,40720,1543,3,217,1,1304.13,NULL,'2022-12-20 15:27:09','2022-12-20 16:27:01','2022-12-20 16:27:01'),(150,8119,49,40720,1543,3,68,1,273.87,NULL,'2022-12-20 15:27:09','2022-12-20 16:27:01','2022-12-20 16:27:01'),(151,8119,49,40720,1543,3,57,2,1578.00,NULL,'2022-12-20 15:27:09','2022-12-20 16:27:01','2022-12-20 16:27:01'),(152,8119,50,40720,1543,3,217,1,174288.45,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(153,8119,50,40720,1543,3,68,1,36600.57,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(154,8119,50,40720,1543,3,217,1,0.01,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(155,8119,50,40720,1543,3,57,2,210889.03,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(156,8119,51,40720,1543,3,217,1,34754.35,NULL,'2022-12-20 15:27:09','2022-12-20 16:28:27','2022-12-20 16:28:27'),(157,8119,51,40720,1543,3,68,1,3649.21,NULL,'2022-12-20 15:27:09','2022-12-20 16:28:27','2022-12-20 16:28:27'),(158,8119,51,40720,1543,3,57,2,38403.56,NULL,'2022-12-20 15:27:09','2022-12-20 16:28:27','2022-12-20 16:28:27'),(159,8119,52,40720,1543,3,217,1,308348.60,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(160,8119,52,40720,1543,3,68,1,64753.21,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(161,8119,52,40720,1543,3,57,2,373101.81,NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(162,8119,53,40720,1543,3,217,1,294347.44,NULL,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL),(163,8119,53,40720,1543,3,68,1,37487.17,NULL,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL),(164,8119,53,40720,1543,3,57,2,331834.61,NULL,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL),(165,8119,54,40720,1543,3,217,1,11168.52,NULL,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL),(166,8119,54,40720,1543,3,68,1,2345.39,NULL,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL);
INSERT INTO `balance_libro_details` VALUES (167,8119,54,40720,1543,3,57,2,13513.91,NULL,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL),(168,8119,55,40720,1543,3,250,1,8050.00,NULL,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL),(169,8119,55,40720,1543,3,57,2,8050.00,NULL,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL),(170,8119,56,40720,1543,3,217,1,170300.00,NULL,'2022-12-20 16:00:48','2022-12-20 16:00:48',NULL),(171,8119,56,40720,1543,3,68,1,35763.00,NULL,'2022-12-20 16:00:48','2022-12-20 16:00:48',NULL),(172,8119,56,40720,1543,3,57,2,206063.00,NULL,'2022-12-20 16:00:48','2022-12-20 16:00:48',NULL),(173,8119,57,40720,1543,3,217,1,250000.51,NULL,'2022-12-20 16:02:30','2022-12-20 16:02:30',NULL),(174,8119,57,40720,1543,3,68,1,52500.11,NULL,'2022-12-20 16:02:30','2022-12-20 16:02:30',NULL),(175,8119,57,40720,1543,3,57,2,302500.62,NULL,'2022-12-20 16:02:30','2022-12-20 16:02:30',NULL),(176,8119,58,40720,1543,3,217,1,160920.00,NULL,'2022-12-20 16:07:16','2022-12-20 16:07:16',NULL),(177,8119,58,40720,1543,3,68,1,33793.20,NULL,'2022-12-20 16:07:16','2022-12-20 16:07:16',NULL),(178,8119,58,40720,1543,3,57,2,194713.20,NULL,'2022-12-20 16:07:16','2022-12-20 16:07:16',NULL),(179,8119,59,40720,1543,3,217,1,230000.00,NULL,'2022-12-20 16:08:34','2022-12-20 16:08:34',NULL),(180,8119,59,40720,1543,3,68,1,48300.00,NULL,'2022-12-20 16:08:34','2022-12-20 16:08:34',NULL),(181,8119,59,40720,1543,3,57,2,278300.00,NULL,'2022-12-20 16:08:34','2022-12-20 16:08:34',NULL),(182,8119,60,40720,1543,3,217,1,160000.00,NULL,'2022-12-20 16:09:23','2022-12-20 16:30:36','2022-12-20 16:30:36'),(183,8119,60,40720,1543,3,68,1,33600.00,NULL,'2022-12-20 16:09:23','2022-12-20 16:30:36','2022-12-20 16:30:36'),(184,8119,60,40720,1543,3,57,2,193600.00,NULL,'2022-12-20 16:09:23','2022-12-20 16:30:36','2022-12-20 16:30:36'),(185,8119,61,40720,1543,3,217,1,189600.00,NULL,'2022-12-20 16:10:29','2022-12-20 16:10:29',NULL),(186,8119,61,40720,1543,3,68,1,39816.00,NULL,'2022-12-20 16:10:29','2022-12-20 16:10:29',NULL),(187,8119,61,40720,1543,3,57,2,229416.00,NULL,'2022-12-20 16:10:29','2022-12-20 16:10:29',NULL),(188,8119,62,40720,1543,3,217,1,258784.00,NULL,'2022-12-20 16:13:56','2022-12-20 16:13:56',NULL),(189,8119,62,40720,1543,3,68,1,54344.64,NULL,'2022-12-20 16:13:56','2022-12-20 16:13:56',NULL),(190,8119,62,40720,1543,3,57,2,313128.64,NULL,'2022-12-20 16:13:56','2022-12-20 16:13:56',NULL),(191,8119,63,40720,1543,3,217,1,213195.00,NULL,'2022-12-20 16:14:47','2022-12-20 16:14:47',NULL),(192,8119,63,40720,1543,3,68,1,44770.95,NULL,'2022-12-20 16:14:47','2022-12-20 16:14:47',NULL),(193,8119,63,40720,1543,3,57,2,257965.95,NULL,'2022-12-20 16:14:47','2022-12-20 16:14:47',NULL),(194,8119,64,40720,1543,3,217,1,144742.20,NULL,'2022-12-20 16:15:36','2022-12-20 16:27:28','2022-12-20 16:27:28'),(195,8119,64,40720,1543,3,68,1,30395.86,NULL,'2022-12-20 16:15:36','2022-12-20 16:27:28','2022-12-20 16:27:28'),(196,8119,64,40720,1543,3,57,2,175138.06,NULL,'2022-12-20 16:15:36','2022-12-20 16:27:28','2022-12-20 16:27:28'),(197,8119,65,40720,1543,3,217,1,223935.00,NULL,'2022-12-20 16:16:09','2022-12-20 16:27:17','2022-12-20 16:27:17'),(198,8119,65,40720,1543,3,68,1,47026.35,NULL,'2022-12-20 16:16:09','2022-12-20 16:27:17','2022-12-20 16:27:17'),(199,8119,65,40720,1543,3,57,2,270961.35,NULL,'2022-12-20 16:16:09','2022-12-20 16:27:17','2022-12-20 16:27:17'),(200,8119,66,40720,1543,3,217,1,180000.00,NULL,'2022-12-20 16:17:01','2022-12-20 16:17:01',NULL),(201,8119,66,40720,1543,3,68,1,37800.00,NULL,'2022-12-20 16:17:01','2022-12-20 16:17:01',NULL),(202,8119,66,40720,1543,3,57,2,217800.00,NULL,'2022-12-20 16:17:01','2022-12-20 16:17:01',NULL),(203,8119,67,40720,1543,3,217,1,271700.00,NULL,'2022-12-20 16:17:22','2022-12-20 16:17:22',NULL),(204,8119,67,40720,1543,3,68,1,57057.00,NULL,'2022-12-20 16:17:22','2022-12-20 16:17:22',NULL),(205,8119,67,40720,1543,3,57,2,328757.00,NULL,'2022-12-20 16:17:22','2022-12-20 16:17:22',NULL),(206,8119,68,40720,1543,3,217,1,361000.00,NULL,'2022-12-20 16:18:05','2022-12-20 16:18:05',NULL);
INSERT INTO `balance_libro_details` VALUES (207,8119,68,40720,1543,3,68,1,75810.00,NULL,'2022-12-20 16:18:05','2022-12-20 16:18:05',NULL),(208,8119,68,40720,1543,3,57,2,436810.00,NULL,'2022-12-20 16:18:05','2022-12-20 16:18:05',NULL),(209,8119,69,40720,1543,3,217,1,243783.00,NULL,'2022-12-20 16:18:21','2022-12-20 16:18:21',NULL),(210,8119,69,40720,1543,3,68,1,51194.43,NULL,'2022-12-20 16:18:21','2022-12-20 16:18:21',NULL),(211,8119,69,40720,1543,3,57,2,294977.43,NULL,'2022-12-20 16:18:21','2022-12-20 16:18:21',NULL),(212,8119,70,40720,1543,3,217,1,382909.00,NULL,'2022-12-20 16:18:57','2022-12-20 16:18:57',NULL),(213,8119,70,40720,1543,3,68,1,80410.89,NULL,'2022-12-20 16:18:57','2022-12-20 16:18:57',NULL),(214,8119,70,40720,1543,3,57,2,463319.89,NULL,'2022-12-20 16:18:57','2022-12-20 16:18:57',NULL),(215,8119,71,40720,1543,3,217,1,281580.00,NULL,'2022-12-20 16:19:17','2022-12-20 16:19:17',NULL),(216,8119,71,40720,1543,3,68,1,59131.80,NULL,'2022-12-20 16:19:17','2022-12-20 16:19:17',NULL),(217,8119,71,40720,1543,3,57,2,340711.80,NULL,'2022-12-20 16:19:17','2022-12-20 16:19:17',NULL),(218,8119,72,40720,1543,3,217,1,1304.13,NULL,'2022-12-20 16:27:01','2022-12-20 16:27:01',NULL),(219,8119,72,40720,1543,3,68,1,273.87,NULL,'2022-12-20 16:27:01','2022-12-20 16:27:01',NULL),(220,8119,72,40720,1543,3,57,2,1578.00,NULL,'2022-12-20 16:27:01','2022-12-20 16:27:01',NULL),(221,8119,73,40720,1543,3,217,1,223935.00,NULL,'2022-12-20 16:27:17','2022-12-20 16:27:17',NULL),(222,8119,73,40720,1543,3,68,1,47026.35,NULL,'2022-12-20 16:27:17','2022-12-20 16:27:17',NULL),(223,8119,73,40720,1543,3,57,2,270961.35,NULL,'2022-12-20 16:27:17','2022-12-20 16:27:17',NULL),(224,8119,74,40720,1543,3,217,1,144742.20,NULL,'2022-12-20 16:27:28','2022-12-20 16:27:28',NULL),(225,8119,74,40720,1543,3,68,1,30395.86,NULL,'2022-12-20 16:27:28','2022-12-20 16:27:28',NULL),(226,8119,74,40720,1543,3,57,2,175138.06,NULL,'2022-12-20 16:27:28','2022-12-20 16:27:28',NULL),(227,8119,75,40720,1543,3,217,1,34754.35,NULL,'2022-12-20 16:28:27','2022-12-20 16:29:57','2022-12-20 16:29:57'),(228,8119,75,40720,1543,3,68,1,3649.21,NULL,'2022-12-20 16:28:27','2022-12-20 16:29:57','2022-12-20 16:29:57'),(229,8119,75,40720,1543,3,57,2,38403.56,NULL,'2022-12-20 16:28:27','2022-12-20 16:29:57','2022-12-20 16:29:57'),(230,8119,76,40720,1543,3,217,1,160000.00,NULL,'2022-12-20 16:30:36','2022-12-20 16:30:36',NULL),(231,8119,76,40720,1543,3,68,1,33600.00,NULL,'2022-12-20 16:30:36','2022-12-20 16:30:36',NULL),(232,8119,76,40720,1543,3,57,2,193600.00,NULL,'2022-12-20 16:30:36','2022-12-20 16:30:36',NULL),(233,8119,77,40776,20318,2,96,2,4700000.00,NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(234,8119,77,40776,20318,2,67,2,987000.00,NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(235,8119,77,40776,20318,2,218,2,117500.00,NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(236,8119,77,40776,20318,2,13,1,5804500.00,NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(237,8119,78,40776,20318,2,96,2,333500.00,NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(238,8119,78,40776,20318,2,67,2,70035.00,NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(239,8119,78,40776,20318,2,13,1,403535.00,NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(240,8119,79,40776,20318,2,96,2,271650.00,NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(241,8119,79,40776,20318,2,67,2,57046.50,NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(242,8119,79,40776,20318,2,218,2,8149.50,NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(243,8119,79,40776,20318,2,13,1,336846.00,NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(244,8119,80,40776,20318,2,96,2,1115250.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42');
INSERT INTO `balance_libro_details` VALUES (245,8119,80,40776,20318,2,67,2,234202.50,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(246,8119,80,40776,20318,2,218,2,27881.25,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(247,8119,80,40776,20318,2,13,1,1377333.75,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(248,8119,81,40776,20318,2,96,2,2479240.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(249,8119,81,40776,20318,2,67,2,520640.40,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(250,8119,81,40776,20318,2,218,2,61981.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(251,8119,81,40776,20318,2,13,1,3061861.40,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(252,8119,82,40776,20318,2,96,2,84455.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(253,8119,82,40776,20318,2,67,2,17735.55,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(254,8119,82,40776,20318,2,218,2,2111.38,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(255,8119,82,40776,20318,2,13,1,104301.93,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(256,8119,83,40776,20318,2,96,2,10925.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(257,8119,83,40776,20318,2,67,2,2294.25,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(258,8119,83,40776,20318,2,13,1,13219.25,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(259,8119,84,40776,20318,2,96,2,541200.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(260,8119,84,40776,20318,2,67,2,113652.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(261,8119,84,40776,20318,2,218,2,8118.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(262,8119,84,40776,20318,2,13,1,662970.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(263,8119,85,40776,20318,2,96,2,47000.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(264,8119,85,40776,20318,2,67,2,9870.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(265,8119,85,40776,20318,2,13,1,56870.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(266,8119,86,40776,20318,2,96,2,377250.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(267,8119,86,40776,20318,2,67,2,79222.50,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(268,8119,86,40776,20318,2,218,2,15090.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(269,8119,86,40776,20318,2,13,1,471562.50,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(270,8119,87,40776,20318,2,96,2,1682100.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(271,8119,87,40776,20318,2,67,2,353241.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(272,8119,87,40776,20318,2,218,2,42052.50,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(273,8119,87,40776,20318,2,13,1,2077393.50,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(274,8119,88,40776,20318,2,96,2,1500300.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(275,8119,88,40776,20318,2,67,2,315063.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(276,8119,88,40776,20318,2,218,2,37507.50,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(277,8119,88,40776,20318,2,13,1,1852870.50,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(278,8119,89,40776,20318,2,96,2,208800.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(279,8119,89,40776,20318,2,67,2,43848.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42');
INSERT INTO `balance_libro_details` VALUES (280,8119,89,40776,20318,2,218,2,5220.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(281,8119,89,40776,20318,2,13,1,257868.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(282,8119,90,40776,20318,2,218,1,0.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(283,8119,90,40776,20318,2,218,1,512400.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(284,8119,90,40776,20318,2,13,2,512400.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(285,8119,91,40776,20318,2,218,2,0.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(286,8119,91,40776,20318,2,218,2,512400.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(287,8119,91,40776,20318,2,13,1,512400.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(288,8119,92,40776,20318,2,96,2,171920.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(289,8119,92,40776,20318,2,67,2,36103.20,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(290,8119,92,40776,20318,2,218,2,4298.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(291,8119,92,40776,20318,2,13,1,212321.20,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(292,8119,93,40776,20318,2,96,2,104400.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(293,8119,93,40776,20318,2,67,2,21924.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(294,8119,93,40776,20318,2,218,2,2610.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(295,8119,93,40776,20318,2,13,1,128934.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(296,8119,94,40776,20318,2,96,2,261000.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(297,8119,94,40776,20318,2,67,2,54810.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(298,8119,94,40776,20318,2,218,2,6525.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(299,8119,94,40776,20318,2,13,1,322335.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(300,8119,95,40776,20318,2,96,2,49120.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(301,8119,95,40776,20318,2,67,2,10315.20,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(302,8119,95,40776,20318,2,218,2,1228.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(303,8119,95,40776,20318,2,13,1,60663.20,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(304,8119,96,40776,20318,2,96,2,711600.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(305,8119,96,40776,20318,2,67,2,149436.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(306,8119,96,40776,20318,2,218,2,17790.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(307,8119,96,40776,20318,2,13,1,878826.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(308,8119,97,40776,20318,2,96,2,1988800.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(309,8119,97,40776,20318,2,67,2,417648.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(310,8119,97,40776,20318,2,13,1,2406448.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(311,8119,98,40776,20318,2,96,2,331500.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(312,8119,98,40776,20318,2,67,2,69615.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(313,8119,98,40776,20318,2,218,2,8287.50,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(314,8119,98,40776,20318,2,13,1,409402.50,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42');
INSERT INTO `balance_libro_details` VALUES (315,8119,99,40776,20318,2,96,2,1255500.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(316,8119,99,40776,20318,2,67,2,263655.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(317,8119,99,40776,20318,2,218,2,31387.50,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(318,8119,99,40776,20318,2,13,1,1550542.50,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(319,8119,100,40776,20318,2,96,2,741925.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(320,8119,100,40776,20318,2,67,2,155804.25,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(321,8119,100,40776,20318,2,13,1,897729.25,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(322,8119,101,40776,20318,2,96,2,679050.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(323,8119,101,40776,20318,2,67,2,142600.50,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(324,8119,101,40776,20318,2,13,1,821650.50,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(325,8119,102,40776,20318,2,96,2,344820.00,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(326,8119,102,40776,20318,2,67,2,72412.20,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(327,8119,102,40776,20318,2,13,1,417232.20,NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(328,8119,103,40776,20318,2,96,2,25950.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(329,8119,103,40776,20318,2,67,2,5449.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(330,8119,103,40776,20318,2,218,2,778.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(331,8119,103,40776,20318,2,13,1,32178.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(332,8119,104,40776,20318,2,96,2,1760500.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(333,8119,104,40776,20318,2,67,2,369705.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(334,8119,104,40776,20318,2,218,2,44012.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(335,8119,104,40776,20318,2,13,1,2174217.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(336,8119,105,40776,20318,2,96,2,243300.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(337,8119,105,40776,20318,2,67,2,51093.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(338,8119,105,40776,20318,2,13,1,294393.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(339,8119,106,40776,20318,2,96,2,1534500.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(340,8119,106,40776,20318,2,67,2,322245.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(341,8119,106,40776,20318,2,218,2,38362.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(342,8119,106,40776,20318,2,13,1,1895107.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(343,8119,107,40776,20318,2,96,2,3150.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(344,8119,107,40776,20318,2,67,2,661.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(345,8119,107,40776,20318,2,13,1,3811.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(346,8119,108,40776,20318,2,96,2,251500.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(347,8119,108,40776,20318,2,67,2,52815.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(348,8119,108,40776,20318,2,218,2,6287.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(349,8119,108,40776,20318,2,13,1,310602.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42');
INSERT INTO `balance_libro_details` VALUES (350,8119,109,40776,20318,2,96,2,19000.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(351,8119,109,40776,20318,2,67,2,3990.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(352,8119,109,40776,20318,2,13,1,22990.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(353,8119,110,40776,20318,2,96,2,8000.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(354,8119,110,40776,20318,2,67,2,1680.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(355,8119,110,40776,20318,2,218,2,200.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(356,8119,110,40776,20318,2,13,1,9880.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(357,8119,111,40776,20318,2,96,2,5187100.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(358,8119,111,40776,20318,2,67,2,1089291.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(359,8119,111,40776,20318,2,13,1,6276391.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(360,8119,112,40776,20318,2,96,1,3150.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(361,8119,112,40776,20318,2,68,1,661.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(362,8119,112,40776,20318,2,218,1,78.75,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(363,8119,112,40776,20318,2,13,2,3890.25,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(364,8119,113,40776,20318,2,96,2,3269500.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(365,8119,113,40776,20318,2,67,2,686595.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(366,8119,113,40776,20318,2,218,2,81737.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(367,8119,113,40776,20318,2,13,1,4037832.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(368,8119,114,40776,20318,2,96,2,36100.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(369,8119,114,40776,20318,2,67,2,7581.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(370,8119,114,40776,20318,2,218,2,1805.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(371,8119,114,40776,20318,2,13,1,45486.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(372,8119,115,40776,20318,2,96,2,331650.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(373,8119,115,40776,20318,2,67,2,69646.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(374,8119,115,40776,20318,2,218,2,8291.25,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(375,8119,115,40776,20318,2,13,1,409587.75,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(376,8119,116,40776,20318,2,96,2,331650.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(377,8119,116,40776,20318,2,67,2,69646.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(378,8119,116,40776,20318,2,218,2,8291.25,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(379,8119,116,40776,20318,2,13,1,409587.75,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(380,8119,117,40776,20318,2,96,2,375870.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(381,8119,117,40776,20318,2,67,2,78932.70,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(382,8119,117,40776,20318,2,218,2,9396.75,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(383,8119,117,40776,20318,2,13,1,464199.45,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(384,8119,118,40776,20318,2,96,2,9000.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43');
INSERT INTO `balance_libro_details` VALUES (385,8119,118,40776,20318,2,67,2,1890.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(386,8119,118,40776,20318,2,13,1,10890.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(387,8119,119,40776,20318,2,96,2,409200.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(388,8119,119,40776,20318,2,67,2,85932.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(389,8119,119,40776,20318,2,218,2,10230.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(390,8119,119,40776,20318,2,13,1,505362.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(391,8119,120,40776,20318,2,96,2,759500.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(392,8119,120,40776,20318,2,67,2,159495.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(393,8119,120,40776,20318,2,218,2,18987.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(394,8119,120,40776,20318,2,13,1,937982.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(395,8119,121,40776,20318,2,96,2,124450.00,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(396,8119,121,40776,20318,2,67,2,26134.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(397,8119,121,40776,20318,2,13,1,150584.50,NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(398,8119,122,40776,20318,2,96,2,302280.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(399,8119,122,40776,20318,2,67,2,63478.80,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(400,8119,122,40776,20318,2,218,2,7557.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(401,8119,122,40776,20318,2,13,1,373315.80,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(402,8119,123,40776,20318,2,96,2,1123170.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(403,8119,123,40776,20318,2,67,2,235865.70,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(404,8119,123,40776,20318,2,13,1,1359035.70,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(405,8119,124,40776,20318,2,96,2,1379280.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(406,8119,124,40776,20318,2,67,2,289648.80,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(407,8119,124,40776,20318,2,218,2,34482.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(408,8119,124,40776,20318,2,13,1,1703410.80,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(409,8119,125,40776,20318,2,96,2,547100.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(410,8119,125,40776,20318,2,67,2,114891.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(411,8119,125,40776,20318,2,218,2,13677.50,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(412,8119,125,40776,20318,2,13,1,675668.50,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(413,8119,126,40776,20318,2,96,2,7748350.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(414,8119,126,40776,20318,2,67,2,1627153.50,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(415,8119,126,40776,20318,2,218,2,193708.75,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(416,8119,126,40776,20318,2,13,1,9569212.25,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(417,8119,127,40776,20318,2,96,2,1144325.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(418,8119,127,40776,20318,2,67,2,240308.25,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43');
INSERT INTO `balance_libro_details` VALUES (419,8119,127,40776,20318,2,13,1,1384633.25,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(420,8119,128,40776,20318,2,96,2,251500.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(421,8119,128,40776,20318,2,67,2,52815.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(422,8119,128,40776,20318,2,13,1,304315.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(423,8119,129,40776,20318,2,96,2,234900.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(424,8119,129,40776,20318,2,67,2,49329.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(425,8119,129,40776,20318,2,218,2,5872.50,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(426,8119,129,40776,20318,2,13,1,290101.50,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(427,8119,130,40776,20318,2,96,2,234900.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(428,8119,130,40776,20318,2,67,2,49329.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(429,8119,130,40776,20318,2,218,2,5872.50,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(430,8119,130,40776,20318,2,13,1,290101.50,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(431,8119,131,40776,20318,2,96,2,101200.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(432,8119,131,40776,20318,2,67,2,21252.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(433,8119,131,40776,20318,2,218,2,2530.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(434,8119,131,40776,20318,2,13,1,124982.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(435,8119,132,40776,20318,2,96,2,364508.53,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(436,8119,132,40776,20318,2,67,2,76546.79,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(437,8119,132,40776,20318,2,218,2,9112.71,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(438,8119,132,40776,20318,2,13,1,450168.03,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(439,8119,133,40776,20318,2,96,2,1921380.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(440,8119,133,40776,20318,2,67,2,403489.80,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(441,8119,133,40776,20318,2,218,2,48034.50,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(442,8119,133,40776,20318,2,13,1,2372904.30,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(443,8119,134,40776,20318,2,96,1,234900.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(444,8119,134,40776,20318,2,68,1,49329.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(445,8119,134,40776,20318,2,218,1,5872.50,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(446,8119,134,40776,20318,2,13,2,290101.50,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(447,8119,135,40776,20318,2,96,1,760925.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(448,8119,135,40776,20318,2,68,1,159794.25,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(449,8119,135,40776,20318,2,13,2,920719.25,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(450,8119,136,40776,20318,2,96,2,1665430.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(451,8119,136,40776,20318,2,67,2,349740.30,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(452,8119,136,40776,20318,2,13,1,2015170.30,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43');
INSERT INTO `balance_libro_details` VALUES (453,8119,137,40776,20318,2,96,2,184895.00,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(454,8119,137,40776,20318,2,67,2,38827.95,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(455,8119,137,40776,20318,2,13,1,223722.95,NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(456,8119,138,40776,20318,2,96,2,623200.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(457,8119,138,40776,20318,2,67,2,130872.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(458,8119,138,40776,20318,2,218,2,15580.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(459,8119,138,40776,20318,2,13,1,769652.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(460,8119,139,40776,20318,2,96,2,574200.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(461,8119,139,40776,20318,2,67,2,120582.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(462,8119,139,40776,20318,2,218,2,14355.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(463,8119,139,40776,20318,2,13,1,709137.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(464,8119,140,40776,20318,2,96,2,2496500.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(465,8119,140,40776,20318,2,67,2,524265.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(466,8119,140,40776,20318,2,218,2,62412.50,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(467,8119,140,40776,20318,2,13,1,3083177.50,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(468,8119,141,40776,20318,2,96,2,943400.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(469,8119,141,40776,20318,2,67,2,198114.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(470,8119,141,40776,20318,2,218,2,23585.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(471,8119,141,40776,20318,2,13,1,1165099.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(472,8119,142,40776,20318,2,96,2,1820320.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(473,8119,142,40776,20318,2,67,2,382267.20,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(474,8119,142,40776,20318,2,218,2,45508.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(475,8119,142,40776,20318,2,13,1,2248095.20,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(476,8119,143,40776,20318,2,96,2,1669100.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(477,8119,143,40776,20318,2,67,2,350511.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(478,8119,143,40776,20318,2,218,2,41727.50,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(479,8119,143,40776,20318,2,13,1,2061338.50,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(480,8119,144,40776,20318,2,96,2,77850.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(481,8119,144,40776,20318,2,67,2,16348.50,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(482,8119,144,40776,20318,2,13,1,94198.50,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(483,8119,145,40776,20318,2,96,2,785920.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(484,8119,145,40776,20318,2,67,2,165043.20,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(485,8119,145,40776,20318,2,218,2,62873.60,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(486,8119,145,40776,20318,2,13,1,1013836.80,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43');
INSERT INTO `balance_libro_details` VALUES (487,8119,146,40776,20318,2,96,2,427550.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(488,8119,146,40776,20318,2,67,2,89785.50,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(489,8119,146,40776,20318,2,13,1,517335.50,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(490,8119,147,40776,20318,2,96,2,299480.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(491,8119,147,40776,20318,2,67,2,62890.80,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(492,8119,147,40776,20318,2,218,2,10481.80,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(493,8119,147,40776,20318,2,13,1,372852.60,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(494,8119,148,40776,20318,2,96,2,280480.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(495,8119,148,40776,20318,2,67,2,58900.80,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(496,8119,148,40776,20318,2,13,1,339380.80,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(497,8119,149,40776,20318,2,96,2,339500.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(498,8119,149,40776,20318,2,67,2,71295.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(499,8119,149,40776,20318,2,218,2,10185.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(500,8119,149,40776,20318,2,13,1,420980.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(501,8119,150,40776,20318,2,96,2,1118000.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(502,8119,150,40776,20318,2,67,2,234780.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(503,8119,150,40776,20318,2,218,2,33540.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(504,8119,150,40776,20318,2,13,1,1386320.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(505,8119,151,40776,20318,2,96,2,1347500.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(506,8119,151,40776,20318,2,67,2,282975.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(507,8119,151,40776,20318,2,218,2,33687.50,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(508,8119,151,40776,20318,2,13,1,1664162.50,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(509,8119,152,40776,20318,2,96,2,156600.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(510,8119,152,40776,20318,2,67,2,32886.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(511,8119,152,40776,20318,2,218,2,3915.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(512,8119,152,40776,20318,2,13,1,193401.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(513,8119,153,40776,20318,2,96,2,1652858.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(514,8119,153,40776,20318,2,67,2,347100.18,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(515,8119,153,40776,20318,2,13,1,1999958.18,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(516,8119,154,40776,20318,2,96,2,163130.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(517,8119,154,40776,20318,2,67,2,34257.30,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(518,8119,154,40776,20318,2,218,2,4078.25,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(519,8119,154,40776,20318,2,13,1,201465.55,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(520,8119,155,40776,20318,2,96,2,631192.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43');
INSERT INTO `balance_libro_details` VALUES (521,8119,155,40776,20318,2,67,2,132550.32,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(522,8119,155,40776,20318,2,218,2,1262.38,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(523,8119,155,40776,20318,2,13,1,765004.70,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(524,8119,156,40776,20318,2,96,2,10200.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(525,8119,156,40776,20318,2,67,2,2142.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(526,8119,156,40776,20318,2,218,2,510.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(527,8119,156,40776,20318,2,13,1,12852.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(528,8119,157,40776,20318,2,96,2,124300.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(529,8119,157,40776,20318,2,67,2,26103.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(530,8119,157,40776,20318,2,13,1,150403.00,NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(531,8119,158,40776,20318,2,96,2,1803650.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(532,8119,158,40776,20318,2,67,2,378766.50,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(533,8119,158,40776,20318,2,218,2,45091.25,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(534,8119,158,40776,20318,2,13,1,2227507.75,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(535,8119,159,40776,20318,2,96,2,2115500.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(536,8119,159,40776,20318,2,67,2,444255.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(537,8119,159,40776,20318,2,13,1,2559755.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(538,8119,160,40776,20318,2,96,2,1711120.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(539,8119,160,40776,20318,2,67,2,359335.20,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(540,8119,160,40776,20318,2,218,2,42778.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(541,8119,160,40776,20318,2,13,1,2113233.20,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(542,8119,161,40776,20318,2,96,2,7234910.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(543,8119,161,40776,20318,2,67,2,1519331.10,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(544,8119,161,40776,20318,2,218,2,72349.10,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(545,8119,161,40776,20318,2,13,1,8826590.20,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(546,8119,162,40776,20318,2,96,2,1715900.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(547,8119,162,40776,20318,2,67,2,360339.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(548,8119,162,40776,20318,2,218,2,42897.50,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(549,8119,162,40776,20318,2,13,1,2119136.50,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(550,8119,163,40776,20318,2,96,1,1369350.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(551,8119,163,40776,20318,2,68,1,287563.50,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(552,8119,163,40776,20318,2,218,1,34233.75,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(553,8119,163,40776,20318,2,13,2,1691147.25,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(554,8119,164,40776,20318,2,96,2,702800.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43');
INSERT INTO `balance_libro_details` VALUES (555,8119,164,40776,20318,2,67,2,147588.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(556,8119,164,40776,20318,2,218,2,17570.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(557,8119,164,40776,20318,2,13,1,867958.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(558,8119,165,40776,20318,2,96,2,492600.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(559,8119,165,40776,20318,2,67,2,103446.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(560,8119,165,40776,20318,2,13,1,596046.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(561,8119,166,40776,20318,2,96,2,123150.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(562,8119,166,40776,20318,2,67,2,25861.50,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(563,8119,166,40776,20318,2,13,1,149011.50,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(564,8119,167,40776,20318,2,96,2,879360.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(565,8119,167,40776,20318,2,67,2,184665.60,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(566,8119,167,40776,20318,2,218,2,70348.80,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(567,8119,167,40776,20318,2,13,1,1134374.40,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(568,8119,168,40776,20318,2,96,2,1118000.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(569,8119,168,40776,20318,2,67,2,234780.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(570,8119,168,40776,20318,2,218,2,55900.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(571,8119,168,40776,20318,2,13,1,1408680.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(572,8119,169,40776,20318,2,96,2,245000.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(573,8119,169,40776,20318,2,67,2,51450.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(574,8119,169,40776,20318,2,218,2,6125.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(575,8119,169,40776,20318,2,13,1,302575.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(576,8119,170,40776,20318,2,96,2,9500.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(577,8119,170,40776,20318,2,67,2,1995.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(578,8119,170,40776,20318,2,13,1,11495.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(579,8119,171,40776,20318,2,96,2,745800.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(580,8119,171,40776,20318,2,67,2,156618.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(581,8119,171,40776,20318,2,218,2,26103.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(582,8119,171,40776,20318,2,13,1,928521.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(583,8119,172,40776,20318,2,96,2,879360.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(584,8119,172,40776,20318,2,67,2,184665.60,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(585,8119,172,40776,20318,2,13,1,1064025.60,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(586,8119,173,40776,20318,2,96,2,155220.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(587,8119,173,40776,20318,2,67,2,32596.20,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(588,8119,173,40776,20318,2,218,2,3880.50,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43');
INSERT INTO `balance_libro_details` VALUES (589,8119,173,40776,20318,2,13,1,191696.70,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(590,8119,174,40776,20318,2,96,2,1704200.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(591,8119,174,40776,20318,2,67,2,357882.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(592,8119,174,40776,20318,2,218,2,42605.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(593,8119,174,40776,20318,2,13,1,2104687.00,NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(594,8119,175,40776,20318,2,96,2,1318150.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(595,8119,175,40776,20318,2,67,2,276811.50,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(596,8119,175,40776,20318,2,218,2,32953.75,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(597,8119,175,40776,20318,2,13,1,1627915.25,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(598,8119,176,40776,20318,2,96,2,377250.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(599,8119,176,40776,20318,2,67,2,79222.50,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(600,8119,176,40776,20318,2,218,2,9431.25,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(601,8119,176,40776,20318,2,13,1,465903.75,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(602,8119,177,40776,20318,2,96,2,104400.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(603,8119,177,40776,20318,2,67,2,21924.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(604,8119,177,40776,20318,2,218,2,2610.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(605,8119,177,40776,20318,2,13,1,128934.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(606,8119,178,40776,20318,2,96,2,582288.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(607,8119,178,40776,20318,2,67,2,122280.48,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(608,8119,178,40776,20318,2,13,1,704568.48,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(609,8119,179,40776,20318,2,96,1,1161450.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(610,8119,179,40776,20318,2,68,1,243904.50,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(611,8119,179,40776,20318,2,13,2,1405354.50,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(612,8119,180,40776,20318,2,96,1,879360.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(613,8119,180,40776,20318,2,68,1,184665.60,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(614,8119,180,40776,20318,2,218,1,70348.80,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(615,8119,180,40776,20318,2,13,2,1134374.40,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(616,8119,181,40776,20318,2,96,2,1023950.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(617,8119,181,40776,20318,2,67,2,215029.50,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(618,8119,181,40776,20318,2,218,2,25598.75,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(619,8119,181,40776,20318,2,13,1,1264578.25,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(620,8119,182,40776,20318,2,96,2,491200.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(621,8119,182,40776,20318,2,67,2,103152.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(622,8119,182,40776,20318,2,218,2,982.40,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44');
INSERT INTO `balance_libro_details` VALUES (623,8119,182,40776,20318,2,13,1,595334.40,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(624,8119,183,40776,20318,2,96,2,491200.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(625,8119,183,40776,20318,2,67,2,103152.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(626,8119,183,40776,20318,2,13,1,594352.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(627,8119,184,40776,20318,2,96,2,2263500.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(628,8119,184,40776,20318,2,67,2,475335.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(629,8119,184,40776,20318,2,13,1,2738835.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(630,8119,185,40776,20318,2,96,2,1257500.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(631,8119,185,40776,20318,2,67,2,264075.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(632,8119,185,40776,20318,2,13,1,1521575.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(633,8119,186,40776,20318,2,96,2,614000.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(634,8119,186,40776,20318,2,67,2,128940.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(635,8119,186,40776,20318,2,218,2,24560.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(636,8119,186,40776,20318,2,13,1,767500.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(637,8119,187,40776,20318,2,96,2,945000.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(638,8119,187,40776,20318,2,67,2,198450.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(639,8119,187,40776,20318,2,218,2,23625.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(640,8119,187,40776,20318,2,13,1,1167075.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(641,8119,188,40776,20318,2,96,2,352100.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(642,8119,188,40776,20318,2,67,2,73941.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(643,8119,188,40776,20318,2,218,2,8802.50,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(644,8119,188,40776,20318,2,13,1,434843.50,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(645,8119,189,40776,20318,2,96,2,352100.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(646,8119,189,40776,20318,2,67,2,73941.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(647,8119,189,40776,20318,2,218,2,14084.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(648,8119,189,40776,20318,2,13,1,440125.00,NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(649,8119,190,40776,20318,2,96,2,4473600.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(650,8119,190,40776,20318,2,67,2,939456.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(651,8119,190,40776,20318,2,13,1,5413056.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(652,8119,191,40776,20318,2,96,2,833432.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(653,8119,191,40776,20318,2,67,2,175020.72,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(654,8119,191,40776,20318,2,13,1,1008452.72,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(655,8119,192,40776,20318,2,96,2,1415040.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(656,8119,192,40776,20318,2,67,2,297158.40,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44');
INSERT INTO `balance_libro_details` VALUES (657,8119,192,40776,20318,2,218,2,35376.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(658,8119,192,40776,20318,2,13,1,1747574.40,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(659,8119,193,40776,20318,2,96,2,653900.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(660,8119,193,40776,20318,2,67,2,137319.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(661,8119,193,40776,20318,2,13,1,791219.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(662,8119,194,40776,20318,2,96,2,1754200.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(663,8119,194,40776,20318,2,67,2,368382.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(664,8119,194,40776,20318,2,13,1,2122582.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(665,8119,195,40776,20318,2,96,2,506060.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(666,8119,195,40776,20318,2,67,2,106272.60,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(667,8119,195,40776,20318,2,13,1,612332.60,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(668,8119,196,40776,20318,2,96,2,87010.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(669,8119,196,40776,20318,2,67,2,18272.10,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(670,8119,196,40776,20318,2,13,1,105282.10,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(671,8119,197,40776,20318,2,96,2,3018000.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(672,8119,197,40776,20318,2,67,2,633780.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(673,8119,197,40776,20318,2,218,2,75450.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(674,8119,197,40776,20318,2,13,1,3727230.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(675,8119,198,40776,20318,2,96,2,2515000.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(676,8119,198,40776,20318,2,67,2,528150.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(677,8119,198,40776,20318,2,13,1,3043150.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(678,8119,199,40776,20318,2,96,2,1682300.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(679,8119,199,40776,20318,2,67,2,353283.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(680,8119,199,40776,20318,2,13,1,2035583.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(681,8119,200,40776,20318,2,96,2,494640.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(682,8119,200,40776,20318,2,67,2,103874.40,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(683,8119,200,40776,20318,2,13,1,598514.40,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(684,8119,201,40776,20318,2,96,2,371640.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(685,8119,201,40776,20318,2,67,2,78044.40,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(686,8119,201,40776,20318,2,218,2,9291.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(687,8119,201,40776,20318,2,13,1,458975.40,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(688,8119,202,40776,20318,2,96,2,2499200.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(689,8119,202,40776,20318,2,67,2,524832.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(690,8119,202,40776,20318,2,13,1,3024032.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44');
INSERT INTO `balance_libro_details` VALUES (691,8119,203,40776,20318,2,96,2,955700.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(692,8119,203,40776,20318,2,67,2,200697.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(693,8119,203,40776,20318,2,218,2,23892.50,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(694,8119,203,40776,20318,2,13,1,1180289.50,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(695,8119,204,40776,20318,2,96,2,1981406.50,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(696,8119,204,40776,20318,2,67,2,416095.37,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(697,8119,204,40776,20318,2,218,2,99070.33,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(698,8119,204,40776,20318,2,13,1,2496572.20,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(699,8119,205,40776,20318,2,96,2,209520.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(700,8119,205,40776,20318,2,67,2,43999.20,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(701,8119,205,40776,20318,2,218,2,5238.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(702,8119,205,40776,20318,2,13,1,258757.20,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(703,8119,206,40776,20318,2,96,2,1295225.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(704,8119,206,40776,20318,2,67,2,271997.25,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(705,8119,206,40776,20318,2,13,1,1567222.25,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(706,8119,207,40776,20318,2,96,2,120175.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(707,8119,207,40776,20318,2,67,2,25236.75,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(708,8119,207,40776,20318,2,13,1,145411.75,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(709,8119,208,40776,20318,2,96,2,209520.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(710,8119,208,40776,20318,2,67,2,43999.20,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(711,8119,208,40776,20318,2,218,2,5238.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(712,8119,208,40776,20318,2,13,1,258757.20,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(713,8119,209,40776,20318,2,96,2,301800.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(714,8119,209,40776,20318,2,67,2,63378.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(715,8119,209,40776,20318,2,218,2,15090.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(716,8119,209,40776,20318,2,13,1,380268.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(717,8119,210,40776,20318,2,96,2,147360.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(718,8119,210,40776,20318,2,67,2,30945.60,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(719,8119,210,40776,20318,2,218,2,5894.40,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(720,8119,210,40776,20318,2,13,1,184200.00,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(721,8119,211,40776,20318,2,96,2,285585.50,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(722,8119,211,40776,20318,2,67,2,59972.96,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(723,8119,211,40776,20318,2,218,2,7139.64,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(724,8119,211,40776,20318,2,13,1,352698.10,NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44');
INSERT INTO `balance_libro_details` VALUES (725,8119,212,40776,20318,2,96,2,50720.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(726,8119,212,40776,20318,2,67,2,10651.20,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(727,8119,212,40776,20318,2,218,2,1268.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(728,8119,212,40776,20318,2,13,1,62639.20,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(729,8119,213,40776,20318,2,96,2,131445.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(730,8119,213,40776,20318,2,67,2,27603.45,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(731,8119,213,40776,20318,2,13,1,159048.45,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(732,8119,214,40776,20318,2,96,2,442200.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(733,8119,214,40776,20318,2,67,2,92862.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(734,8119,214,40776,20318,2,218,2,11055.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(735,8119,214,40776,20318,2,13,1,546117.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(736,8119,215,40776,20318,2,96,2,503000.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(737,8119,215,40776,20318,2,67,2,105630.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(738,8119,215,40776,20318,2,218,2,12575.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(739,8119,215,40776,20318,2,13,1,621205.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(740,8119,216,40776,20318,2,96,2,176050.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(741,8119,216,40776,20318,2,67,2,36970.50,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(742,8119,216,40776,20318,2,218,2,4401.25,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(743,8119,216,40776,20318,2,13,1,217421.75,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(744,8119,217,40776,20318,2,96,2,180861.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(745,8119,217,40776,20318,2,67,2,37980.81,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(746,8119,217,40776,20318,2,218,2,4521.53,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(747,8119,217,40776,20318,2,13,1,223363.34,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(748,8119,218,40776,20318,2,96,1,176050.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(749,8119,218,40776,20318,2,68,1,36970.50,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(750,8119,218,40776,20318,2,218,1,4401.25,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(751,8119,218,40776,20318,2,13,2,217421.75,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(752,8119,219,40776,20318,2,96,2,2729856.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(753,8119,219,40776,20318,2,67,2,573269.76,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(754,8119,219,40776,20318,2,218,2,8189.57,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(755,8119,219,40776,20318,2,13,1,3311315.33,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(756,8119,220,40776,20318,2,96,1,742080.00,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(757,8119,220,40776,20318,2,68,1,155836.80,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(758,8119,220,40776,20318,2,218,1,2226.24,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(759,8119,220,40776,20318,2,13,2,900143.04,NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44');
INSERT INTO `balance_libro_details` VALUES (760,8119,221,40720,1544,2,96,2,207060.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(761,8119,221,40720,1544,2,67,2,43482.60,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(762,8119,221,40720,1544,2,13,1,250542.60,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(763,8119,222,40720,1544,2,96,2,85554.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(764,8119,222,40720,1544,2,67,2,17966.34,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(765,8119,222,40720,1544,2,13,1,103520.34,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(766,8119,223,40720,1544,2,96,2,351936.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(767,8119,223,40720,1544,2,67,2,73906.56,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(768,8119,223,40720,1544,2,13,1,425842.56,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(769,8119,224,40720,1544,2,96,2,463110.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(770,8119,224,40720,1544,2,67,2,97253.10,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(771,8119,224,40720,1544,2,13,1,560363.10,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(772,8119,225,40720,1544,2,96,2,48216.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(773,8119,225,40720,1544,2,67,2,10125.36,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(774,8119,225,40720,1544,2,13,1,58341.36,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(775,8119,226,40720,1544,2,96,2,116718.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(776,8119,226,40720,1544,2,67,2,24510.78,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(777,8119,226,40720,1544,2,13,1,141228.78,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(778,8119,227,40720,1544,2,96,2,35900.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(779,8119,227,40720,1544,2,67,2,7539.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(780,8119,227,40720,1544,2,13,1,43439.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(781,8119,228,40720,1544,2,96,2,252912.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(782,8119,228,40720,1544,2,67,2,53111.52,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(783,8119,228,40720,1544,2,13,1,306023.52,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(784,8119,229,40720,1544,2,96,2,194739.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(785,8119,229,40720,1544,2,67,2,40895.19,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(786,8119,229,40720,1544,2,13,1,235634.19,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(787,8119,230,40720,1544,2,96,2,251268.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(788,8119,230,40720,1544,2,67,2,52766.28,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(789,8119,230,40720,1544,2,13,1,304034.28,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(790,8119,231,40720,1544,2,96,2,194739.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(791,8119,231,40720,1544,2,67,2,40895.19,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(792,8119,231,40720,1544,2,13,1,235634.19,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(793,8119,232,40720,1544,2,96,2,272184.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(794,8119,232,40720,1544,2,67,2,57158.64,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(795,8119,232,40720,1544,2,13,1,329342.64,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(796,8119,233,40720,1544,2,96,2,198156.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(797,8119,233,40720,1544,2,67,2,41612.76,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(798,8119,233,40720,1544,2,13,1,239768.76,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(799,8119,234,40720,1544,2,96,2,209040.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(800,8119,234,40720,1544,2,67,2,43898.40,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL);
INSERT INTO `balance_libro_details` VALUES (801,8119,234,40720,1544,2,13,1,252938.40,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(802,8119,235,40720,1544,2,96,2,201240.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(803,8119,235,40720,1544,2,67,2,42260.40,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(804,8119,235,40720,1544,2,13,1,243500.40,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(805,8119,236,40720,1544,2,96,2,271128.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(806,8119,236,40720,1544,2,67,2,56936.88,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(807,8119,236,40720,1544,2,13,1,328064.88,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(808,8119,237,40720,1544,2,96,2,1014000.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(809,8119,237,40720,1544,2,67,2,212940.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(810,8119,237,40720,1544,2,13,1,1226940.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(811,8119,238,40720,1544,2,96,2,1323000.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(812,8119,238,40720,1544,2,67,2,277830.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(813,8119,238,40720,1544,2,13,1,1600830.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(814,8119,239,40720,1544,2,96,2,1315080.00,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(815,8119,239,40720,1544,2,67,2,276166.80,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(816,8119,239,40720,1544,2,13,1,1591246.80,NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(817,8119,240,40720,1544,2,96,2,321984.00,NULL,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(818,8119,240,40720,1544,2,67,2,67616.64,NULL,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(819,8119,240,40720,1544,2,13,1,389600.64,NULL,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(820,8119,241,40720,1544,2,96,2,197340.00,NULL,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(821,8119,241,40720,1544,2,67,2,41441.40,NULL,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(822,8119,241,40720,1544,2,13,1,238781.40,NULL,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(823,8119,242,40720,1544,2,96,2,200070.00,NULL,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(824,8119,242,40720,1544,2,67,2,42014.70,NULL,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(825,8119,242,40720,1544,2,13,1,242084.70,NULL,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(826,8119,243,40720,1544,3,217,1,20965.74,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(827,8119,243,40720,1544,3,68,1,4402.81,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(828,8119,243,40720,1544,3,57,2,25368.55,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(829,8119,244,40720,1544,3,217,1,19485.88,NULL,'2023-01-16 18:01:46','2023-01-16 18:39:32','2023-01-16 18:39:32'),(830,8119,244,40720,1544,3,68,1,4092.04,NULL,'2023-01-16 18:01:46','2023-01-16 18:39:32','2023-01-16 18:39:32'),(831,8119,244,40720,1544,3,57,2,23577.92,NULL,'2023-01-16 18:01:46','2023-01-16 18:39:32','2023-01-16 18:39:32'),(832,8119,245,40720,1544,3,217,1,48317.53,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(833,8119,245,40720,1544,3,68,1,10146.68,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(834,8119,245,40720,1544,3,217,1,0.01,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(835,8119,245,40720,1544,3,57,2,58464.22,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(836,8119,246,40720,1544,3,217,1,15197.80,NULL,'2023-01-16 18:01:46','2023-01-16 18:37:14','2023-01-16 18:37:14'),(837,8119,246,40720,1544,3,68,1,3191.53,NULL,'2023-01-16 18:01:46','2023-01-16 18:37:14','2023-01-16 18:37:14'),(838,8119,246,40720,1544,3,57,2,18389.33,NULL,'2023-01-16 18:01:46','2023-01-16 18:37:14','2023-01-16 18:37:14'),(839,8119,247,40720,1544,3,217,1,97301.60,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(840,8119,247,40720,1544,3,68,1,20433.34,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL);
INSERT INTO `balance_libro_details` VALUES (841,8119,247,40720,1544,3,57,2,117734.94,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(842,8119,248,40720,1544,3,217,1,58102.34,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(843,8119,248,40720,1544,3,68,1,12201.49,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(844,8119,248,40720,1544,3,217,1,0.01,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(845,8119,248,40720,1544,3,57,2,70303.84,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(846,8119,249,40720,1544,3,217,1,52650.83,NULL,'2023-01-16 18:01:46','2023-01-16 18:40:50','2023-01-16 18:40:50'),(847,8119,249,40720,1544,3,68,1,11056.67,NULL,'2023-01-16 18:01:46','2023-01-16 18:40:50','2023-01-16 18:40:50'),(848,8119,249,40720,1544,3,57,2,63707.50,NULL,'2023-01-16 18:01:46','2023-01-16 18:40:50','2023-01-16 18:40:50'),(849,8119,250,40720,1544,3,217,1,41258.40,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(850,8119,250,40720,1544,3,68,1,8664.26,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(851,8119,250,40720,1544,3,217,1,0.01,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(852,8119,250,40720,1544,3,57,2,49922.67,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(853,8119,251,40720,1544,3,250,1,0.00,NULL,'2023-01-16 18:01:46','2023-01-16 18:35:24','2023-01-16 18:35:24'),(854,8119,251,40720,1544,3,250,1,1490.00,NULL,'2023-01-16 18:01:46','2023-01-16 18:35:24','2023-01-16 18:35:24'),(855,8119,251,40720,1544,3,57,2,1490.00,NULL,'2023-01-16 18:01:46','2023-01-16 18:35:24','2023-01-16 18:35:24'),(856,8119,252,40720,1544,3,217,1,29446.76,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(857,8119,252,40720,1544,3,68,1,6183.82,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(858,8119,252,40720,1544,3,217,1,0.01,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(859,8119,252,40720,1544,3,57,2,35630.59,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(860,8119,253,40720,1544,3,217,1,23206.05,NULL,'2023-01-16 18:01:46','2023-01-16 18:40:36','2023-01-16 18:40:36'),(861,8119,253,40720,1544,3,68,1,4873.27,NULL,'2023-01-16 18:01:46','2023-01-16 18:40:36','2023-01-16 18:40:36'),(862,8119,253,40720,1544,3,57,2,28079.32,NULL,'2023-01-16 18:01:46','2023-01-16 18:40:36','2023-01-16 18:40:36'),(863,8119,254,40720,1544,3,217,1,12720.00,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(864,8119,254,40720,1544,3,68,1,2671.20,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(865,8119,254,40720,1544,3,57,2,15391.20,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(866,8119,255,40720,1544,3,217,1,31748.78,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(867,8119,255,40720,1544,3,68,1,6667.25,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(868,8119,255,40720,1544,3,57,2,38416.03,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(869,8119,256,40720,1544,3,217,1,27727.21,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(870,8119,256,40720,1544,3,68,1,5822.70,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(871,8119,256,40720,1544,3,57,2,33549.91,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(872,8119,257,40720,1544,3,217,1,37688.25,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(873,8119,257,40720,1544,3,68,1,7914.53,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(874,8119,257,40720,1544,3,217,1,0.01,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(875,8119,257,40720,1544,3,57,2,45602.79,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(876,8119,258,40720,1544,3,217,1,12396.69,NULL,'2023-01-16 18:01:46','2023-01-16 18:40:04','2023-01-16 18:40:04'),(877,8119,258,40720,1544,3,68,1,2603.31,NULL,'2023-01-16 18:01:46','2023-01-16 18:40:04','2023-01-16 18:40:04'),(878,8119,258,40720,1544,3,57,2,15000.00,NULL,'2023-01-16 18:01:46','2023-01-16 18:40:04','2023-01-16 18:40:04'),(879,8119,259,40720,1544,3,217,1,111570.25,NULL,'2023-01-16 18:01:46','2023-01-16 18:39:51','2023-01-16 18:39:51');
INSERT INTO `balance_libro_details` VALUES (880,8119,259,40720,1544,3,68,1,23429.75,NULL,'2023-01-16 18:01:46','2023-01-16 18:39:51','2023-01-16 18:39:51'),(881,8119,259,40720,1544,3,57,2,135000.00,NULL,'2023-01-16 18:01:46','2023-01-16 18:39:51','2023-01-16 18:39:51'),(882,8119,260,40720,1544,3,217,1,36999.48,NULL,'2023-01-16 18:01:46','2023-01-16 18:39:11','2023-01-16 18:39:11'),(883,8119,260,40720,1544,3,68,1,3884.95,NULL,'2023-01-16 18:01:46','2023-01-16 18:39:11','2023-01-16 18:39:11'),(884,8119,260,40720,1544,3,57,2,40884.43,NULL,'2023-01-16 18:01:46','2023-01-16 18:39:11','2023-01-16 18:39:11'),(885,8119,261,40720,1544,3,217,1,97140.88,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(886,8119,261,40720,1544,3,68,1,20399.58,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(887,8119,261,40720,1544,3,57,2,117540.46,NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(888,8119,262,40720,1544,3,217,1,297622.10,NULL,'2023-01-16 18:15:20','2023-01-16 18:15:20',NULL),(889,8119,262,40720,1544,3,68,1,62500.64,NULL,'2023-01-16 18:15:20','2023-01-16 18:15:20',NULL),(890,8119,262,40720,1544,3,57,2,360122.74,NULL,'2023-01-16 18:15:20','2023-01-16 18:15:20',NULL),(891,8119,263,40720,1544,3,217,1,337980.00,NULL,'2023-01-16 18:15:56','2023-01-16 18:15:56',NULL),(892,8119,263,40720,1544,3,68,1,70975.80,NULL,'2023-01-16 18:15:56','2023-01-16 18:15:56',NULL),(893,8119,263,40720,1544,3,57,2,408955.80,NULL,'2023-01-16 18:15:56','2023-01-16 18:15:56',NULL),(894,8119,264,40720,1544,3,217,1,214780.00,NULL,'2023-01-16 18:19:13','2023-01-16 18:19:13',NULL),(895,8119,264,40720,1544,3,68,1,45103.80,NULL,'2023-01-16 18:19:13','2023-01-16 18:19:13',NULL),(896,8119,264,40720,1544,3,57,2,259883.80,NULL,'2023-01-16 18:19:13','2023-01-16 18:19:13',NULL),(897,8119,265,40720,1544,3,217,1,307841.00,NULL,'2023-01-16 18:19:58','2023-01-16 18:19:58',NULL),(898,8119,265,40720,1544,3,68,1,64646.61,NULL,'2023-01-16 18:19:58','2023-01-16 18:19:58',NULL),(899,8119,265,40720,1544,3,57,2,372487.61,NULL,'2023-01-16 18:19:58','2023-01-16 18:19:58',NULL),(900,8119,266,40720,1544,3,217,1,223935.00,NULL,'2023-01-16 18:21:40','2023-01-16 18:21:40',NULL),(901,8119,266,40720,1544,3,68,1,47026.35,NULL,'2023-01-16 18:21:40','2023-01-16 18:21:40',NULL),(902,8119,266,40720,1544,3,57,2,270961.35,NULL,'2023-01-16 18:21:40','2023-01-16 18:21:40',NULL),(903,8119,267,40720,1544,3,217,1,350956.00,NULL,'2023-01-16 18:22:14','2023-01-16 18:22:14',NULL),(904,8119,267,40720,1544,3,68,1,73700.76,NULL,'2023-01-16 18:22:14','2023-01-16 18:22:14',NULL),(905,8119,267,40720,1544,3,57,2,424656.76,NULL,'2023-01-16 18:22:14','2023-01-16 18:22:14',NULL),(906,8119,268,40720,1544,3,217,1,244122.00,NULL,'2023-01-16 18:23:51','2023-01-16 18:23:51',NULL),(907,8119,268,40720,1544,3,68,1,51265.62,NULL,'2023-01-16 18:23:51','2023-01-16 18:23:51',NULL),(908,8119,268,40720,1544,3,57,2,295387.62,NULL,'2023-01-16 18:23:51','2023-01-16 18:23:51',NULL),(909,8119,269,40720,1544,3,217,1,335741.00,NULL,'2023-01-16 18:26:05','2023-01-16 18:26:05',NULL),(910,8119,269,40720,1544,3,68,1,70505.61,NULL,'2023-01-16 18:26:05','2023-01-16 18:26:05',NULL),(911,8119,269,40720,1544,3,57,2,406246.61,NULL,'2023-01-16 18:26:05','2023-01-16 18:26:05',NULL),(912,8119,270,40720,1544,3,217,1,161500.00,NULL,'2023-01-16 18:28:16','2023-01-16 18:28:16',NULL),(913,8119,270,40720,1544,3,68,1,33915.00,NULL,'2023-01-16 18:28:16','2023-01-16 18:28:16',NULL),(914,8119,270,40720,1544,3,57,2,195415.00,NULL,'2023-01-16 18:28:16','2023-01-16 18:28:16',NULL),(915,8119,271,40720,1544,3,217,1,281580.00,NULL,'2023-01-16 18:28:49','2023-01-16 18:28:49',NULL),(916,8119,271,40720,1544,3,68,1,59131.80,NULL,'2023-01-16 18:28:49','2023-01-16 18:28:49',NULL),(917,8119,271,40720,1544,3,57,2,340711.80,NULL,'2023-01-16 18:28:49','2023-01-16 18:28:49',NULL),(918,8119,272,40720,1544,3,217,1,315360.00,NULL,'2023-01-16 18:29:15','2023-01-16 18:29:15',NULL),(919,8119,272,40720,1544,3,68,1,66225.60,NULL,'2023-01-16 18:29:15','2023-01-16 18:29:15',NULL);
INSERT INTO `balance_libro_details` VALUES (920,8119,272,40720,1544,3,57,2,381585.60,NULL,'2023-01-16 18:29:15','2023-01-16 18:29:15',NULL),(921,8119,273,40720,1544,3,217,1,345000.00,NULL,'2023-01-16 18:29:55','2023-01-16 18:29:55',NULL),(922,8119,273,40720,1544,3,68,1,72450.00,NULL,'2023-01-16 18:29:55','2023-01-16 18:29:55',NULL),(923,8119,273,40720,1544,3,57,2,417450.00,NULL,'2023-01-16 18:29:55','2023-01-16 18:29:55',NULL),(924,8119,274,40720,1544,3,217,1,159032.00,NULL,'2023-01-16 18:30:37','2023-01-16 18:30:37',NULL),(925,8119,274,40720,1544,3,68,1,33396.72,NULL,'2023-01-16 18:30:37','2023-01-16 18:30:37',NULL),(926,8119,274,40720,1544,3,57,2,192428.72,NULL,'2023-01-16 18:30:37','2023-01-16 18:30:37',NULL),(927,8119,275,40720,1544,3,217,1,235100.90,NULL,'2023-01-16 18:31:09','2023-01-16 18:31:09',NULL),(928,8119,275,40720,1544,3,68,1,49371.19,NULL,'2023-01-16 18:31:09','2023-01-16 18:31:09',NULL),(929,8119,275,40720,1544,3,57,2,284472.09,NULL,'2023-01-16 18:31:09','2023-01-16 18:31:09',NULL),(930,8119,276,40720,1544,3,217,1,389450.00,NULL,'2023-01-16 18:31:44','2023-01-16 18:31:44',NULL),(931,8119,276,40720,1544,3,68,1,81784.50,NULL,'2023-01-16 18:31:44','2023-01-16 18:31:44',NULL),(932,8119,276,40720,1544,3,57,2,471234.50,NULL,'2023-01-16 18:31:44','2023-01-16 18:31:44',NULL),(933,8119,277,40741,3351,2,96,2,27479.34,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(934,8119,277,40741,3351,2,67,2,5770.66,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(935,8119,277,40741,3351,2,13,1,33250.00,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(936,8119,278,40741,3351,2,96,2,27685.96,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(937,8119,278,40741,3351,2,67,2,5814.04,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(938,8119,278,40741,3351,2,13,1,33500.00,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(939,8119,279,40741,3351,2,96,2,134158.60,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(940,8119,279,40741,3351,2,67,2,28173.30,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(941,8119,279,40741,3351,2,13,1,162331.90,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(942,8119,280,40741,3351,2,96,2,252694.14,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(943,8119,280,40741,3351,2,67,2,53065.76,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(944,8119,280,40741,3351,2,13,1,305759.90,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(945,8119,281,40741,3351,2,96,2,20046.06,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(946,8119,281,40741,3351,2,67,2,2104.84,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(947,8119,281,40741,3351,2,13,1,22150.90,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(948,8119,282,40741,3351,2,96,2,62539.82,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(949,8119,282,40741,3351,2,67,2,6566.68,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(950,8119,282,40741,3351,2,13,1,69106.50,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(951,8119,283,40741,3351,2,96,2,379653.21,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(952,8119,283,40741,3351,2,67,2,39863.59,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(953,8119,283,40741,3351,2,13,1,419516.80,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(954,8119,284,40741,3351,2,96,2,217652.03,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(955,8119,284,40741,3351,2,67,2,22853.47,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(956,8119,284,40741,3351,2,13,1,240505.50,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(957,8119,285,40741,3351,2,96,2,50541.72,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(958,8119,285,40741,3351,2,67,2,5306.88,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(959,8119,285,40741,3351,2,13,1,55848.60,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(960,8119,286,40741,3351,2,96,2,221166.13,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL);
INSERT INTO `balance_libro_details` VALUES (961,8119,286,40741,3351,2,67,2,46444.87,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(962,8119,286,40741,3351,2,13,1,267611.00,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(963,8119,287,40741,3351,2,96,2,41417.44,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(964,8119,287,40741,3351,2,67,2,8697.66,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(965,8119,287,40741,3351,2,13,1,50115.10,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(966,8119,288,40741,3351,2,96,2,32922.23,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(967,8119,288,40741,3351,2,67,2,6913.67,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(968,8119,288,40741,3351,2,13,1,39835.90,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(969,8119,289,40741,3351,2,96,2,115610.50,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(970,8119,289,40741,3351,2,67,2,12139.10,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(971,8119,289,40741,3351,2,13,1,127749.60,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(972,8119,290,40741,3351,2,96,2,206591.59,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(973,8119,290,40741,3351,2,67,2,21692.11,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(974,8119,290,40741,3351,2,13,1,228283.70,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(975,8119,291,40741,3351,2,96,2,41464.69,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(976,8119,291,40741,3351,2,67,2,4353.81,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(977,8119,291,40741,3351,2,13,1,45818.50,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(978,8119,292,40741,3351,2,96,2,41803.71,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(979,8119,292,40741,3351,2,67,2,4389.39,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(980,8119,292,40741,3351,2,13,1,46193.10,NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(981,8119,293,40741,3351,2,96,1,41803.71,NULL,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(982,8119,293,40741,3351,2,68,1,4389.39,NULL,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(983,8119,293,40741,3351,2,13,2,46193.10,NULL,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(984,8119,294,40741,3351,2,96,2,50769.48,NULL,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(985,8119,294,40741,3351,2,67,2,5330.82,NULL,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(986,8119,294,40741,3351,2,13,1,56100.30,NULL,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(987,8119,295,40741,3351,2,96,2,17736.92,NULL,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(988,8119,295,40741,3351,2,67,2,1862.38,NULL,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(989,8119,295,40741,3351,2,13,1,19599.30,NULL,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(990,8119,296,40741,3351,3,217,1,26554.00,NULL,'2023-01-16 20:22:20','2023-01-16 20:22:20',NULL),(991,8119,296,40741,3351,3,68,1,2788.16,NULL,'2023-01-16 20:22:20','2023-01-16 20:22:20',NULL),(992,8119,296,40741,3351,3,57,2,29342.16,NULL,'2023-01-16 20:22:20','2023-01-16 20:22:20',NULL),(993,8119,297,40741,3351,3,217,1,365375.00,NULL,'2023-01-16 20:22:20','2023-01-16 20:22:20',NULL),(994,8119,297,40741,3351,3,68,1,38364.39,NULL,'2023-01-16 20:22:20','2023-01-16 20:22:20',NULL),(995,8119,297,40741,3351,3,57,2,403739.39,NULL,'2023-01-16 20:22:20','2023-01-16 20:22:20',NULL),(996,8119,298,40741,3351,3,217,1,555487.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(997,8119,298,40741,3351,3,68,1,58326.13,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(998,8119,298,40741,3351,3,57,2,613813.13,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(999,8119,299,40741,3351,3,217,1,38700.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1000,8119,299,40741,3351,3,68,1,4063.50,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1001,8119,299,40741,3351,3,217,1,677.25,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL);
INSERT INTO `balance_libro_details` VALUES (1002,8119,299,40741,3351,3,57,2,43440.75,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1003,8119,300,40741,3351,3,217,1,11029.76,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1004,8119,300,40741,3351,3,68,1,1158.12,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1005,8119,300,40741,3351,3,217,1,193.02,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1006,8119,300,40741,3351,3,57,2,12380.90,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1007,8119,301,40741,3351,3,217,1,121265.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1008,8119,301,40741,3351,3,68,1,12732.82,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1009,8119,301,40741,3351,3,57,2,133997.82,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1010,8119,302,40741,3351,3,217,1,54000.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1011,8119,302,40741,3351,3,68,1,5670.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1012,8119,302,40741,3351,3,217,1,945.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1013,8119,302,40741,3351,3,57,2,60615.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1014,8119,303,40741,3351,3,217,1,156689.67,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1015,8119,303,40741,3351,3,68,1,16452.42,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1016,8119,303,40741,3351,3,217,1,2742.07,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1017,8119,303,40741,3351,3,57,2,175884.16,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1018,8119,304,40741,3351,3,217,1,26824.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1019,8119,304,40741,3351,3,68,1,2816.52,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1020,8119,304,40741,3351,3,217,1,469.42,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1021,8119,304,40741,3351,3,57,2,30109.94,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1022,8119,305,40741,3351,3,217,1,105088.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1023,8119,305,40741,3351,3,68,1,11034.24,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1024,8119,305,40741,3351,3,217,1,1839.04,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1025,8119,305,40741,3351,3,57,2,117961.28,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1026,8119,306,40741,3351,3,217,1,181000.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1027,8119,306,40741,3351,3,68,1,19005.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1028,8119,306,40741,3351,3,57,2,200005.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1029,8119,307,40741,3351,3,217,1,444191.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1030,8119,307,40741,3351,3,68,1,46640.06,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1031,8119,307,40741,3351,3,217,1,7773.34,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1032,8119,307,40741,3351,3,57,2,498604.40,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1033,8119,308,40741,3351,3,217,1,499400.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1034,8119,308,40741,3351,3,68,1,52437.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1035,8119,308,40741,3351,3,217,1,8739.50,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1036,8119,308,40741,3351,3,57,2,560576.50,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1037,8119,309,40741,3351,3,217,1,431815.00,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1038,8119,309,40741,3351,3,68,1,45340.58,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1039,8119,309,40741,3351,3,57,2,477155.58,NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(1040,8119,310,40856,29414,2,96,2,826.45,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1041,8119,310,40856,29414,2,67,2,173.55,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1042,8119,310,40856,29414,2,13,1,1000.00,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL);
INSERT INTO `balance_libro_details` VALUES (1043,8119,311,40856,29414,2,96,2,130533.88,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1044,8119,311,40856,29414,2,67,2,27412.12,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1045,8119,311,40856,29414,2,13,1,157946.00,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1046,8119,312,40856,29414,2,96,2,10165.29,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1047,8119,312,40856,29414,2,67,2,2134.71,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1048,8119,312,40856,29414,2,13,1,12300.00,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1049,8119,313,40856,29414,2,96,2,53107.44,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1050,8119,313,40856,29414,2,67,2,11152.56,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1051,8119,313,40856,29414,2,13,1,64260.00,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1052,8119,314,40856,29414,2,96,2,12419.83,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1053,8119,314,40856,29414,2,67,2,2608.17,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1054,8119,314,40856,29414,2,13,1,15028.00,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1055,8119,315,40856,29414,2,96,2,16322.31,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1056,8119,315,40856,29414,2,67,2,3427.69,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1057,8119,315,40856,29414,2,13,1,19750.00,NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(1058,8119,316,40856,29414,2,96,2,14363.64,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1059,8119,316,40856,29414,2,67,2,3016.36,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1060,8119,316,40856,29414,2,13,1,17380.00,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1061,8119,317,40856,29414,2,96,2,36446.28,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1062,8119,317,40856,29414,2,67,2,7653.72,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1063,8119,317,40856,29414,2,13,1,44100.00,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1064,8119,318,40856,29414,2,96,2,108350.41,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1065,8119,318,40856,29414,2,67,2,22753.59,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1066,8119,318,40856,29414,2,13,1,131104.00,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1067,8119,319,40856,29414,2,96,2,16033.06,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1068,8119,319,40856,29414,2,67,2,3366.94,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1069,8119,319,40856,29414,2,13,1,19400.00,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1070,8119,320,40856,29414,2,96,2,27768.60,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1071,8119,320,40856,29414,2,67,2,5831.40,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1072,8119,320,40856,29414,2,13,1,33600.00,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1073,8119,321,40856,29414,2,96,2,16227.27,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1074,8119,321,40856,29414,2,67,2,3407.73,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1075,8119,321,40856,29414,2,13,1,19635.00,NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(1076,8119,322,40856,29414,3,250,1,0.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:42:02','2023-01-16 20:42:02'),(1077,8119,322,40856,29414,3,250,1,10680.20,NULL,'2023-01-16 20:40:16','2023-01-16 20:42:02','2023-01-16 20:42:02'),(1078,8119,322,40856,29414,3,57,2,10680.20,NULL,'2023-01-16 20:40:16','2023-01-16 20:42:02','2023-01-16 20:42:02'),(1079,8119,323,40856,29414,3,250,2,0.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:42:08','2023-01-16 20:42:08'),(1080,8119,323,40856,29414,3,250,2,8289.80,NULL,'2023-01-16 20:40:16','2023-01-16 20:42:08','2023-01-16 20:42:08'),(1081,8119,323,40856,29414,3,57,1,8289.80,NULL,'2023-01-16 20:40:16','2023-01-16 20:42:08','2023-01-16 20:42:08');
INSERT INTO `balance_libro_details` VALUES (1082,8119,324,40856,29414,3,217,1,4672.88,NULL,'2023-01-16 20:40:16','2023-01-16 20:42:14','2023-01-16 20:42:14'),(1083,8119,324,40856,29414,3,68,1,981.30,NULL,'2023-01-16 20:40:16','2023-01-16 20:42:14','2023-01-16 20:42:14'),(1084,8119,324,40856,29414,3,57,2,5654.18,NULL,'2023-01-16 20:40:16','2023-01-16 20:42:14','2023-01-16 20:42:14'),(1085,8119,325,40856,29414,3,250,1,20000.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1086,8119,325,40856,29414,3,57,2,20000.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1087,8119,326,40856,29414,3,217,1,5089.42,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:40','2023-01-16 20:41:40'),(1088,8119,326,40856,29414,3,68,1,1068.78,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:40','2023-01-16 20:41:40'),(1089,8119,326,40856,29414,3,57,2,6158.20,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:40','2023-01-16 20:41:40'),(1090,8119,327,40856,29414,3,217,1,4655.46,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:47','2023-01-16 20:41:47'),(1091,8119,327,40856,29414,3,68,1,977.65,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:47','2023-01-16 20:41:47'),(1092,8119,327,40856,29414,3,57,2,5633.11,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:47','2023-01-16 20:41:47'),(1093,8119,328,40856,29414,3,250,1,5980.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1094,8119,328,40856,29414,3,57,2,5980.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1095,8119,329,40856,29414,3,217,2,6160.46,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:32','2023-01-16 20:41:32'),(1096,8119,329,40856,29414,3,67,2,1293.70,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:32','2023-01-16 20:41:32'),(1097,8119,329,40856,29414,3,57,1,7454.16,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:32','2023-01-16 20:41:32'),(1098,8119,330,40856,29414,3,217,1,14924.44,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:23','2023-01-16 20:41:23'),(1099,8119,330,40856,29414,3,68,1,2706.53,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:23','2023-01-16 20:41:23'),(1100,8119,330,40856,29414,3,57,2,17630.97,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:23','2023-01-16 20:41:23'),(1101,8119,331,40856,29414,3,217,1,594.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1102,8119,331,40856,29414,3,68,1,124.74,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1103,8119,331,40856,29414,3,57,2,718.74,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1104,8119,332,40856,29414,3,217,1,8180.99,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:16','2023-01-16 20:41:16'),(1105,8119,332,40856,29414,3,68,1,1718.01,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:16','2023-01-16 20:41:16'),(1106,8119,332,40856,29414,3,57,2,9899.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:16','2023-01-16 20:41:16'),(1107,8119,333,40856,29414,3,217,1,10129.75,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:07','2023-01-16 20:41:07'),(1108,8119,333,40856,29414,3,68,1,2127.25,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:07','2023-01-16 20:41:07'),(1109,8119,333,40856,29414,3,57,2,12257.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:41:07','2023-01-16 20:41:07'),(1110,8119,334,40856,29414,3,250,1,9771.36,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1111,8119,334,40856,29414,3,57,2,9771.36,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1112,8119,335,40856,29414,3,217,1,70247.93,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1113,8119,335,40856,29414,3,68,1,14752.07,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1114,8119,335,40856,29414,3,57,2,85000.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1115,8119,336,40856,29414,3,217,1,66115.70,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1116,8119,336,40856,29414,3,68,1,13884.30,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1117,8119,336,40856,29414,3,57,2,80000.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1118,8119,337,40856,29414,3,217,1,70247.93,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL);
INSERT INTO `balance_libro_details` VALUES (1119,8119,337,40856,29414,3,68,1,14752.07,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1120,8119,337,40856,29414,3,57,2,85000.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1121,8119,338,40856,29414,3,217,1,66115.70,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1122,8119,338,40856,29414,3,68,1,13884.30,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1123,8119,338,40856,29414,3,57,2,80000.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1124,8119,339,40856,29414,3,217,1,70247.93,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1125,8119,339,40856,29414,3,68,1,14752.07,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1126,8119,339,40856,29414,3,57,2,85000.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1127,8119,340,40856,29414,3,217,1,70247.93,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1128,8119,340,40856,29414,3,68,1,14752.07,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1129,8119,340,40856,29414,3,57,2,85000.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1130,8119,341,40856,29414,3,250,1,20500.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1131,8119,341,40856,29414,3,57,2,20500.00,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(1132,8119,342,40856,29414,3,217,1,16298.01,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:58','2023-01-16 20:40:58'),(1133,8119,342,40856,29414,3,68,1,3422.58,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:58','2023-01-16 20:40:58'),(1134,8119,342,40856,29414,3,57,2,19720.59,NULL,'2023-01-16 20:40:16','2023-01-16 20:40:58','2023-01-16 20:40:58'),(1135,8119,343,40856,29414,3,217,1,18502.40,NULL,'2023-01-16 20:40:17','2023-01-16 20:40:17',NULL),(1136,8119,343,40856,29414,3,68,1,3885.50,NULL,'2023-01-16 20:40:17','2023-01-16 20:40:17',NULL),(1137,8119,343,40856,29414,3,57,2,22387.90,NULL,'2023-01-16 20:40:17','2023-01-16 20:40:17',NULL),(1138,8119,344,40774,31118,2,96,2,1569.42,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1139,8119,344,40774,31118,2,67,2,329.58,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1140,8119,344,40774,31118,2,13,1,1899.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1141,8119,345,40774,31118,2,96,2,453.72,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1142,8119,345,40774,31118,2,67,2,95.28,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1143,8119,345,40774,31118,2,13,1,549.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1144,8119,346,40774,31118,2,96,2,5161.16,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1145,8119,346,40774,31118,2,67,2,1083.84,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1146,8119,346,40774,31118,2,13,1,6245.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1147,8119,347,40774,31118,2,96,2,2478.51,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1148,8119,347,40774,31118,2,67,2,520.49,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1149,8119,347,40774,31118,2,13,1,2999.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1150,8119,348,40774,31118,2,96,2,577.69,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1151,8119,348,40774,31118,2,67,2,121.31,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1152,8119,348,40774,31118,2,13,1,699.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1153,8119,349,40774,31118,2,96,2,412.40,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1154,8119,349,40774,31118,2,67,2,86.60,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1155,8119,349,40774,31118,2,13,1,499.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1156,8119,350,40774,31118,2,96,2,866.94,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1157,8119,350,40774,31118,2,67,2,182.06,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1158,8119,350,40774,31118,2,13,1,1049.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL);
INSERT INTO `balance_libro_details` VALUES (1159,8119,351,40774,31118,2,96,2,1652.89,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1160,8119,351,40774,31118,2,67,2,347.11,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1161,8119,351,40774,31118,2,13,1,2000.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1162,8119,352,40774,31118,2,96,2,619.01,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1163,8119,352,40774,31118,2,67,2,129.99,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1164,8119,352,40774,31118,2,13,1,749.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1165,8119,353,40774,31118,2,96,2,247.93,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1166,8119,353,40774,31118,2,67,2,52.07,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1167,8119,353,40774,31118,2,13,1,300.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1168,8119,354,40774,31118,2,96,2,659.50,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1169,8119,354,40774,31118,2,67,2,138.50,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1170,8119,354,40774,31118,2,13,1,798.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1171,8119,355,40774,31118,2,96,2,247.93,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1172,8119,355,40774,31118,2,67,2,52.07,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1173,8119,355,40774,31118,2,13,1,300.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1174,8119,356,40774,31118,2,96,2,1866.94,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1175,8119,356,40774,31118,2,67,2,392.06,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1176,8119,356,40774,31118,2,13,1,2259.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1177,8119,357,40774,31118,2,96,2,1238.84,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1178,8119,357,40774,31118,2,67,2,260.16,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1179,8119,357,40774,31118,2,13,1,1499.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1180,8119,358,40774,31118,2,96,2,7178.52,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1181,8119,358,40774,31118,2,67,2,1507.48,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1182,8119,358,40774,31118,2,13,1,8686.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1183,8119,359,40774,31118,2,96,2,3615.71,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1184,8119,359,40774,31118,2,67,2,759.29,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1185,8119,359,40774,31118,2,13,1,4375.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1186,8119,360,40774,31118,2,96,2,2644.63,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1187,8119,360,40774,31118,2,67,2,555.37,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1188,8119,360,40774,31118,2,13,1,3200.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1189,8119,361,40774,31118,2,96,2,247.93,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1190,8119,361,40774,31118,2,67,2,52.07,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1191,8119,361,40774,31118,2,13,1,300.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1192,8119,362,40774,31118,2,96,2,1552.89,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1193,8119,362,40774,31118,2,67,2,326.11,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1194,8119,362,40774,31118,2,13,1,1879.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1195,8119,363,40774,31118,2,96,2,3960.33,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1196,8119,363,40774,31118,2,67,2,831.67,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1197,8119,363,40774,31118,2,13,1,4792.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1198,8119,364,40774,31118,2,96,2,495.04,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1199,8119,364,40774,31118,2,67,2,103.96,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL);
INSERT INTO `balance_libro_details` VALUES (1200,8119,364,40774,31118,2,13,1,599.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1201,8119,365,40774,31118,2,96,2,2523.97,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1202,8119,365,40774,31118,2,67,2,530.03,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1203,8119,365,40774,31118,2,13,1,3054.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1204,8119,366,40774,31118,2,96,2,1445.45,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1205,8119,366,40774,31118,2,67,2,303.55,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1206,8119,366,40774,31118,2,13,1,1749.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1207,8119,367,40774,31118,2,96,2,3507.44,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1208,8119,367,40774,31118,2,67,2,736.56,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1209,8119,367,40774,31118,2,13,1,4244.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1210,8119,368,40774,31118,2,96,2,1238.84,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1211,8119,368,40774,31118,2,67,2,260.16,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1212,8119,368,40774,31118,2,13,1,1499.00,NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(1213,8119,369,40774,31118,2,96,2,1198.35,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1214,8119,369,40774,31118,2,67,2,251.65,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1215,8119,369,40774,31118,2,13,1,1450.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1216,8119,370,40774,31118,2,96,2,1238.84,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1217,8119,370,40774,31118,2,67,2,260.16,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1218,8119,370,40774,31118,2,13,1,1499.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1219,8119,371,40774,31118,2,96,2,1652.07,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1220,8119,371,40774,31118,2,67,2,346.93,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1221,8119,371,40774,31118,2,13,1,1999.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1222,8119,372,40774,31118,2,96,2,5348.76,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1223,8119,372,40774,31118,2,67,2,1123.24,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1224,8119,372,40774,31118,2,13,1,6472.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1225,8119,373,40774,31118,2,96,2,247.93,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1226,8119,373,40774,31118,2,67,2,52.07,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1227,8119,373,40774,31118,2,13,1,300.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1228,8119,374,40774,31118,2,96,2,2266.11,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1229,8119,374,40774,31118,2,67,2,475.89,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1230,8119,374,40774,31118,2,13,1,2742.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1231,8119,375,40774,31118,2,96,2,1553.72,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1232,8119,375,40774,31118,2,67,2,326.28,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1233,8119,375,40774,31118,2,13,1,1880.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1234,8119,376,40774,31118,2,96,2,1362.81,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1235,8119,376,40774,31118,2,67,2,286.19,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1236,8119,376,40774,31118,2,13,1,1649.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1237,8119,377,40774,31118,2,96,2,2638.02,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1238,8119,377,40774,31118,2,67,2,553.98,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1239,8119,377,40774,31118,2,13,1,3192.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1240,8119,378,40774,31118,2,96,2,866.94,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1241,8119,378,40774,31118,2,67,2,182.06,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1242,8119,378,40774,31118,2,13,1,1049.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1243,8119,379,40774,31118,2,96,2,1361.98,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1244,8119,379,40774,31118,2,67,2,286.02,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1245,8119,379,40774,31118,2,13,1,1648.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1246,8119,380,40774,31118,2,96,2,931.40,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1247,8119,380,40774,31118,2,67,2,195.60,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1248,8119,380,40774,31118,2,13,1,1127.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1249,8119,381,40774,31118,2,96,2,1399.17,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1250,8119,381,40774,31118,2,67,2,293.83,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1251,8119,381,40774,31118,2,13,1,1693.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1252,8119,382,40774,31118,2,96,2,907.44,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1253,8119,382,40774,31118,2,67,2,190.56,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1254,8119,382,40774,31118,2,13,1,1098.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1255,8119,383,40774,31118,2,96,2,15702.48,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1256,8119,383,40774,31118,2,67,2,3297.52,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1257,8119,383,40774,31118,2,13,1,19000.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1258,8119,384,40774,31118,2,96,2,11156.20,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1259,8119,384,40774,31118,2,67,2,2342.80,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1260,8119,384,40774,31118,2,13,1,13499.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1261,8119,385,40774,31118,2,96,2,2404.96,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1262,8119,385,40774,31118,2,67,2,505.04,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1263,8119,385,40774,31118,2,13,1,2910.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1264,8119,386,40774,31118,2,96,2,1694.21,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1265,8119,386,40774,31118,2,67,2,355.79,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1266,8119,386,40774,31118,2,13,1,2050.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1267,8119,387,40774,31118,2,96,2,2086.78,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1268,8119,387,40774,31118,2,67,2,438.22,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1269,8119,387,40774,31118,2,13,1,2525.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1270,8119,388,40774,31118,2,96,2,247.93,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1271,8119,388,40774,31118,2,67,2,52.07,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1272,8119,388,40774,31118,2,13,1,300.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1273,8119,389,40774,31118,2,96,2,990.91,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1274,8119,389,40774,31118,2,67,2,208.09,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1275,8119,389,40774,31118,2,13,1,1199.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1276,8119,390,40774,31118,2,96,2,17343.80,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1277,8119,390,40774,31118,2,67,2,3642.20,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1278,8119,390,40774,31118,2,13,1,20986.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1279,8119,391,40774,31118,2,96,2,990.91,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1280,8119,391,40774,31118,2,67,2,208.09,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1281,8119,391,40774,31118,2,13,1,1199.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL);
INSERT INTO `balance_libro_details` VALUES (1282,8119,392,40774,31118,2,96,2,1528.10,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1283,8119,392,40774,31118,2,67,2,320.90,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1284,8119,392,40774,31118,2,13,1,1849.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1285,8119,393,40774,31118,2,96,2,6998.34,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1286,8119,393,40774,31118,2,67,2,1469.66,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1287,8119,393,40774,31118,2,13,1,8468.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1288,8119,394,40774,31118,2,96,2,1858.68,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1289,8119,394,40774,31118,2,67,2,390.32,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1290,8119,394,40774,31118,2,13,1,2249.00,NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(1291,8119,395,40774,31118,2,96,2,1486.78,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1292,8119,395,40774,31118,2,67,2,312.22,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1293,8119,395,40774,31118,2,13,1,1799.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1294,8119,396,40774,31118,2,96,2,7231.40,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1295,8119,396,40774,31118,2,67,2,1518.60,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1296,8119,396,40774,31118,2,13,1,8750.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1297,8119,397,40774,31118,2,96,2,1238.84,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1298,8119,397,40774,31118,2,67,2,260.16,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1299,8119,397,40774,31118,2,13,1,1499.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1300,8119,398,40774,31118,2,96,2,3016.52,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1301,8119,398,40774,31118,2,67,2,633.48,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1302,8119,398,40774,31118,2,13,1,3650.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1303,8119,399,40774,31118,2,96,2,1041.32,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1304,8119,399,40774,31118,2,67,2,218.68,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1305,8119,399,40774,31118,2,13,1,1260.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1306,8119,400,40774,31118,2,96,2,5206.61,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1307,8119,400,40774,31118,2,67,2,1093.39,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1308,8119,400,40774,31118,2,13,1,6300.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1309,8119,401,40774,31118,2,96,2,904.13,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1310,8119,401,40774,31118,2,67,2,189.87,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1311,8119,401,40774,31118,2,13,1,1094.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1312,8119,402,40774,31118,2,96,2,2958.68,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1313,8119,402,40774,31118,2,67,2,621.32,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1314,8119,402,40774,31118,2,13,1,3580.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1315,8119,403,40774,31118,2,96,2,247.93,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1316,8119,403,40774,31118,2,67,2,52.07,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1317,8119,403,40774,31118,2,13,1,300.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1318,8119,404,40774,31118,2,96,2,1652.07,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1319,8119,404,40774,31118,2,67,2,346.93,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1320,8119,404,40774,31118,2,13,1,1999.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1321,8119,405,40774,31118,2,96,2,4790.91,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1322,8119,405,40774,31118,2,67,2,1006.09,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL);
INSERT INTO `balance_libro_details` VALUES (1323,8119,405,40774,31118,2,13,1,5797.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1324,8119,406,40774,31118,2,96,2,1238.84,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1325,8119,406,40774,31118,2,67,2,260.16,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1326,8119,406,40774,31118,2,13,1,1499.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1327,8119,407,40774,31118,2,96,2,536.36,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1328,8119,407,40774,31118,2,67,2,112.64,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1329,8119,407,40774,31118,2,13,1,649.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1330,8119,408,40774,31118,2,96,2,3482.64,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1331,8119,408,40774,31118,2,67,2,731.36,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1332,8119,408,40774,31118,2,13,1,4214.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1333,8119,409,40774,31118,2,96,2,1041.32,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1334,8119,409,40774,31118,2,67,2,218.68,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1335,8119,409,40774,31118,2,13,1,1260.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1336,8119,410,40774,31118,2,96,2,371.07,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1337,8119,410,40774,31118,2,67,2,77.93,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1338,8119,410,40774,31118,2,13,1,449.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1339,8119,411,40774,31118,2,96,2,577.69,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1340,8119,411,40774,31118,2,67,2,121.31,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1341,8119,411,40774,31118,2,13,1,699.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1342,8119,412,40774,31118,2,96,2,5072.73,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1343,8119,412,40774,31118,2,67,2,1065.27,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1344,8119,412,40774,31118,2,13,1,6138.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1345,8119,413,40774,31118,2,96,2,2268.60,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1346,8119,413,40774,31118,2,67,2,476.40,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1347,8119,413,40774,31118,2,13,1,2745.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1348,8119,414,40774,31118,2,96,2,1937.19,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1349,8119,414,40774,31118,2,67,2,406.81,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1350,8119,414,40774,31118,2,13,1,2344.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1351,8119,415,40774,31118,2,96,2,5740.50,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1352,8119,415,40774,31118,2,67,2,1205.50,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1353,8119,415,40774,31118,2,13,1,6946.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1354,8119,416,40774,31118,2,96,2,5466.12,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1355,8119,416,40774,31118,2,67,2,1147.88,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1356,8119,416,40774,31118,2,13,1,6614.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1357,8119,417,40774,31118,2,96,2,2237.19,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1358,8119,417,40774,31118,2,67,2,469.81,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1359,8119,417,40774,31118,2,13,1,2707.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1360,8119,418,40774,31118,2,96,2,537.19,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1361,8119,418,40774,31118,2,67,2,112.81,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1362,8119,418,40774,31118,2,13,1,650.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1363,8119,419,40774,31118,2,96,2,2908.27,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL);
INSERT INTO `balance_libro_details` VALUES (1364,8119,419,40774,31118,2,67,2,610.73,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1365,8119,419,40774,31118,2,13,1,3519.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1366,8119,420,40774,31118,2,96,2,1701.65,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1367,8119,420,40774,31118,2,67,2,357.35,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1368,8119,420,40774,31118,2,13,1,2059.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1369,8119,421,40774,31118,2,96,2,1858.68,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1370,8119,421,40774,31118,2,67,2,390.32,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1371,8119,421,40774,31118,2,13,1,2249.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1372,8119,422,40774,31118,2,96,2,826.45,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1373,8119,422,40774,31118,2,67,2,173.55,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1374,8119,422,40774,31118,2,13,1,1000.00,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1375,8119,423,40774,31118,2,96,2,908.26,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1376,8119,423,40774,31118,2,67,2,190.74,NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(1377,8119,423,40774,31118,2,13,1,1099.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1378,8119,424,40774,31118,2,96,2,881.82,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1379,8119,424,40774,31118,2,67,2,185.18,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1380,8119,424,40774,31118,2,13,1,1067.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1381,8119,425,40774,31118,2,96,2,242.98,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1382,8119,425,40774,31118,2,67,2,51.02,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1383,8119,425,40774,31118,2,13,1,294.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1384,8119,426,40774,31118,2,96,2,3039.67,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1385,8119,426,40774,31118,2,67,2,638.33,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1386,8119,426,40774,31118,2,13,1,3678.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1387,8119,427,40774,31118,2,96,2,2149.59,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1388,8119,427,40774,31118,2,67,2,451.41,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1389,8119,427,40774,31118,2,13,1,2601.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1390,8119,428,40774,31118,2,96,2,453.72,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1391,8119,428,40774,31118,2,67,2,95.28,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1392,8119,428,40774,31118,2,13,1,549.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1393,8119,429,40774,31118,2,96,2,413.22,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1394,8119,429,40774,31118,2,67,2,86.78,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1395,8119,429,40774,31118,2,13,1,500.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1396,8119,430,40774,31118,2,96,2,866.94,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1397,8119,430,40774,31118,2,67,2,182.06,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1398,8119,430,40774,31118,2,13,1,1049.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1399,8119,431,40774,31118,2,96,2,866.94,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1400,8119,431,40774,31118,2,67,2,182.06,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1401,8119,431,40774,31118,2,13,1,1049.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1402,8119,432,40774,31118,2,96,2,8016.52,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1403,8119,432,40774,31118,2,67,2,1683.48,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1404,8119,432,40774,31118,2,13,1,9700.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL);
INSERT INTO `balance_libro_details` VALUES (1405,8119,433,40774,31118,2,96,2,5164.46,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1406,8119,433,40774,31118,2,67,2,1084.54,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1407,8119,433,40774,31118,2,13,1,6249.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1408,8119,434,40774,31118,2,96,2,498.35,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1409,8119,434,40774,31118,2,67,2,104.65,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1410,8119,434,40774,31118,2,13,1,603.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1411,8119,435,40774,31118,2,96,2,4470.25,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1412,8119,435,40774,31118,2,67,2,938.75,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1413,8119,435,40774,31118,2,13,1,5409.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1414,8119,436,40774,31118,2,96,2,1041.32,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1415,8119,436,40774,31118,2,67,2,218.68,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1416,8119,436,40774,31118,2,13,1,1260.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1417,8119,437,40774,31118,2,96,2,3684.30,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1418,8119,437,40774,31118,2,67,2,773.70,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1419,8119,437,40774,31118,2,13,1,4458.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1420,8119,438,40774,31118,2,96,2,453.72,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1421,8119,438,40774,31118,2,67,2,95.28,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1422,8119,438,40774,31118,2,13,1,549.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1423,8119,439,40774,31118,2,96,2,5164.46,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1424,8119,439,40774,31118,2,67,2,1084.54,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1425,8119,439,40774,31118,2,13,1,6249.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1426,8119,440,40774,31118,2,96,2,8826.45,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1427,8119,440,40774,31118,2,67,2,1853.55,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1428,8119,440,40774,31118,2,13,1,10680.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1429,8119,441,40774,31118,2,96,2,2082.64,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1430,8119,441,40774,31118,2,67,2,437.36,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1431,8119,441,40774,31118,2,13,1,2520.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1432,8119,442,40774,31118,2,96,2,660.33,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1433,8119,442,40774,31118,2,67,2,138.67,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1434,8119,442,40774,31118,2,13,1,799.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1435,8119,443,40774,31118,2,96,2,1238.84,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1436,8119,443,40774,31118,2,67,2,260.16,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1437,8119,443,40774,31118,2,13,1,1499.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1438,8119,444,40774,31118,2,96,2,990.91,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1439,8119,444,40774,31118,2,67,2,208.09,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1440,8119,444,40774,31118,2,13,1,1199.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1441,8119,445,40774,31118,2,96,2,2957.85,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1442,8119,445,40774,31118,2,67,2,621.15,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1443,8119,445,40774,31118,2,13,1,3579.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1444,8119,446,40774,31118,2,96,2,1103.31,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1445,8119,446,40774,31118,2,67,2,231.69,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL);
INSERT INTO `balance_libro_details` VALUES (1446,8119,446,40774,31118,2,13,1,1335.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1447,8119,447,40774,31118,2,96,2,346.28,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1448,8119,447,40774,31118,2,67,2,72.72,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1449,8119,447,40774,31118,2,13,1,419.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1450,8119,448,40774,31118,2,96,2,743.80,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1451,8119,448,40774,31118,2,67,2,156.20,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1452,8119,448,40774,31118,2,13,1,900.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1453,8119,449,40774,31118,2,96,2,485.12,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1454,8119,449,40774,31118,2,67,2,101.88,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1455,8119,449,40774,31118,2,13,1,587.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1456,8119,450,40774,31118,2,96,2,619.01,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1457,8119,450,40774,31118,2,67,2,129.99,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1458,8119,450,40774,31118,2,13,1,749.00,NULL,'2023-01-19 10:48:28','2023-01-19 10:48:28',NULL),(1459,8119,451,40774,31118,2,96,2,10330.58,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1460,8119,451,40774,31118,2,67,2,2169.42,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1461,8119,451,40774,31118,2,13,1,12500.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1462,8119,452,40774,31118,2,96,2,8264.46,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1463,8119,452,40774,31118,2,67,2,1735.54,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1464,8119,452,40774,31118,2,13,1,10000.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1465,8119,453,40774,31118,2,96,2,10371.90,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1466,8119,453,40774,31118,2,67,2,2178.10,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1467,8119,453,40774,31118,2,13,1,12550.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1468,8119,454,40774,31118,2,96,2,16942.15,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1469,8119,454,40774,31118,2,67,2,3557.85,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1470,8119,454,40774,31118,2,13,1,20500.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1471,8119,455,40774,31118,2,96,2,14694.21,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1472,8119,455,40774,31118,2,67,2,3085.79,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1473,8119,455,40774,31118,2,13,1,17780.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1474,8119,456,40774,31118,2,96,2,12809.92,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1475,8119,456,40774,31118,2,67,2,2690.08,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1476,8119,456,40774,31118,2,13,1,15500.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1477,8119,457,40774,31118,2,96,2,6198.35,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1478,8119,457,40774,31118,2,67,2,1301.65,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1479,8119,457,40774,31118,2,13,1,7500.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1480,8119,458,40774,31118,2,96,2,17454.55,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1481,8119,458,40774,31118,2,67,2,3665.45,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1482,8119,458,40774,31118,2,13,1,21120.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1483,8119,459,40774,31118,2,96,2,2157.02,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1484,8119,459,40774,31118,2,67,2,452.98,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1485,8119,459,40774,31118,2,13,1,2610.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1486,8119,460,40774,31118,2,96,2,413.22,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL);
INSERT INTO `balance_libro_details` VALUES (1487,8119,460,40774,31118,2,67,2,86.78,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1488,8119,460,40774,31118,2,13,1,500.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1489,8119,461,40774,31118,2,96,2,2925.62,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1490,8119,461,40774,31118,2,67,2,614.38,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1491,8119,461,40774,31118,2,13,1,3540.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1492,8119,462,40774,31118,2,96,2,1441.32,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1493,8119,462,40774,31118,2,67,2,302.68,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1494,8119,462,40774,31118,2,13,1,1744.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1495,8119,463,40774,31118,2,96,2,485.12,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1496,8119,463,40774,31118,2,67,2,101.88,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1497,8119,463,40774,31118,2,13,1,587.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1498,8119,464,40774,31118,2,96,2,866.94,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1499,8119,464,40774,31118,2,67,2,182.06,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1500,8119,464,40774,31118,2,13,1,1049.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1501,8119,465,40774,31118,2,96,2,366.94,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1502,8119,465,40774,31118,2,67,2,77.06,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1503,8119,465,40774,31118,2,13,1,444.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1504,8119,466,40774,31118,2,96,2,881.82,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1505,8119,466,40774,31118,2,67,2,185.18,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1506,8119,466,40774,31118,2,13,1,1067.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1507,8119,467,40774,31118,2,96,2,3320.66,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1508,8119,467,40774,31118,2,67,2,697.34,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1509,8119,467,40774,31118,2,13,1,4018.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1510,8119,468,40774,31118,2,96,2,2655.37,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1511,8119,468,40774,31118,2,67,2,557.63,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1512,8119,468,40774,31118,2,13,1,3213.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1513,8119,469,40774,31118,2,96,2,380.99,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1514,8119,469,40774,31118,2,67,2,80.01,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1515,8119,469,40774,31118,2,13,1,461.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1516,8119,470,40774,31118,2,96,2,247.93,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1517,8119,470,40774,31118,2,67,2,52.07,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1518,8119,470,40774,31118,2,13,1,300.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1519,8119,471,40774,31118,2,96,2,2144.63,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1520,8119,471,40774,31118,2,67,2,450.37,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1521,8119,471,40774,31118,2,13,1,2595.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1522,8119,472,40774,31118,2,96,2,5164.46,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1523,8119,472,40774,31118,2,67,2,1084.54,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1524,8119,472,40774,31118,2,13,1,6249.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1525,8119,473,40774,31118,2,96,2,1156.20,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1526,8119,473,40774,31118,2,67,2,242.80,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1527,8119,473,40774,31118,2,13,1,1399.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL);
INSERT INTO `balance_libro_details` VALUES (1528,8119,474,40774,31118,2,96,2,2023.14,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1529,8119,474,40774,31118,2,67,2,424.86,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1530,8119,474,40774,31118,2,13,1,2448.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1531,8119,475,40774,31118,2,96,2,485.12,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1532,8119,475,40774,31118,2,67,2,101.88,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1533,8119,475,40774,31118,2,13,1,587.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1534,8119,476,40774,31118,2,96,2,536.36,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1535,8119,476,40774,31118,2,67,2,112.64,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1536,8119,476,40774,31118,2,13,1,649.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1537,8119,477,40774,31118,2,96,2,2147.11,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1538,8119,477,40774,31118,2,67,2,450.89,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1539,8119,477,40774,31118,2,13,1,2598.00,NULL,'2023-01-19 10:48:29','2023-01-19 10:48:29',NULL),(1540,8119,478,40774,31118,2,96,2,1900.82,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1541,8119,478,40774,31118,2,67,2,399.18,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1542,8119,478,40774,31118,2,13,1,2300.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1543,8119,479,40774,31118,2,96,2,826.45,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1544,8119,479,40774,31118,2,67,2,173.55,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1545,8119,479,40774,31118,2,13,1,1000.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1546,8119,480,40774,31118,2,96,2,3837.19,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1547,8119,480,40774,31118,2,67,2,805.81,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1548,8119,480,40774,31118,2,13,1,4643.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1549,8119,481,40774,31118,2,96,2,761.98,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1550,8119,481,40774,31118,2,67,2,160.02,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1551,8119,481,40774,31118,2,13,1,922.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1552,8119,482,40774,31118,2,96,2,1652.07,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1553,8119,482,40774,31118,2,67,2,346.93,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1554,8119,482,40774,31118,2,13,1,1999.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1555,8119,483,40774,31118,2,96,2,1490.91,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1556,8119,483,40774,31118,2,67,2,313.09,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1557,8119,483,40774,31118,2,13,1,1804.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1558,8119,484,40774,31118,2,96,2,948.76,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1559,8119,484,40774,31118,2,67,2,199.24,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1560,8119,484,40774,31118,2,13,1,1148.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1561,8119,485,40774,31118,2,96,2,412.40,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1562,8119,485,40774,31118,2,67,2,86.60,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1563,8119,485,40774,31118,2,13,1,499.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1564,8119,486,40774,31118,2,96,2,577.69,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1565,8119,486,40774,31118,2,67,2,121.31,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1566,8119,486,40774,31118,2,13,1,699.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1567,8119,487,40774,31118,2,96,2,2284.29,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1568,8119,487,40774,31118,2,67,2,479.71,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL);
INSERT INTO `balance_libro_details` VALUES (1569,8119,487,40774,31118,2,13,1,2764.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1570,8119,488,40774,31118,2,96,2,4601.65,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1571,8119,488,40774,31118,2,67,2,966.35,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1572,8119,488,40774,31118,2,13,1,5568.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1573,8119,489,40774,31118,2,96,2,990.91,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1574,8119,489,40774,31118,2,67,2,208.09,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1575,8119,489,40774,31118,2,13,1,1199.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1576,8119,490,40774,31118,2,96,2,825.62,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1577,8119,490,40774,31118,2,67,2,173.38,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1578,8119,490,40774,31118,2,13,1,999.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1579,8119,491,40774,31118,2,96,2,1238.84,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1580,8119,491,40774,31118,2,67,2,260.16,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1581,8119,491,40774,31118,2,13,1,1499.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1582,8119,492,40774,31118,2,96,2,2147.11,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1583,8119,492,40774,31118,2,67,2,450.89,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1584,8119,492,40774,31118,2,13,1,2598.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1585,8119,493,40774,31118,2,96,2,1445.45,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1586,8119,493,40774,31118,2,67,2,303.55,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1587,8119,493,40774,31118,2,13,1,1749.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1588,8119,494,40774,31118,2,96,2,1041.32,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1589,8119,494,40774,31118,2,67,2,218.68,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1590,8119,494,40774,31118,2,13,1,1260.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1591,8119,495,40774,31118,2,96,2,12396.69,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1592,8119,495,40774,31118,2,67,2,2603.31,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1593,8119,495,40774,31118,2,13,1,15000.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1594,8119,496,40774,31118,2,96,2,13099.17,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1595,8119,496,40774,31118,2,67,2,2750.83,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1596,8119,496,40774,31118,2,13,1,15850.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1597,8119,497,40774,31118,2,96,2,2499.18,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1598,8119,497,40774,31118,2,67,2,524.82,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1599,8119,497,40774,31118,2,13,1,3024.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1600,8119,498,40774,31118,2,96,2,742.98,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1601,8119,498,40774,31118,2,67,2,156.02,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1602,8119,498,40774,31118,2,13,1,899.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1603,8119,499,40774,31118,2,96,2,826.45,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1604,8119,499,40774,31118,2,67,2,173.55,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1605,8119,499,40774,31118,2,13,1,1000.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1606,8119,500,40774,31118,2,96,2,866.94,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1607,8119,500,40774,31118,2,67,2,182.06,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1608,8119,500,40774,31118,2,13,1,1049.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1609,8119,501,40774,31118,2,96,2,1937.19,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL);
INSERT INTO `balance_libro_details` VALUES (1610,8119,501,40774,31118,2,67,2,406.81,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1611,8119,501,40774,31118,2,13,1,2344.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1612,8119,502,40774,31118,2,96,2,1110.75,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1613,8119,502,40774,31118,2,67,2,233.25,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1614,8119,502,40774,31118,2,13,1,1344.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1615,8119,503,40774,31118,2,96,2,660.33,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1616,8119,503,40774,31118,2,67,2,138.67,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1617,8119,503,40774,31118,2,13,1,799.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1618,8119,504,40774,31118,2,96,2,826.45,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1619,8119,504,40774,31118,2,67,2,173.55,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1620,8119,504,40774,31118,2,13,1,1000.00,NULL,'2023-01-19 10:48:30','2023-01-19 10:48:30',NULL),(1621,8119,505,40774,31118,2,96,2,413.22,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1622,8119,505,40774,31118,2,67,2,86.78,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1623,8119,505,40774,31118,2,13,1,500.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1624,8119,506,40774,31118,2,96,2,2185.13,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1625,8119,506,40774,31118,2,67,2,458.87,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1626,8119,506,40774,31118,2,13,1,2644.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1627,8119,507,40774,31118,2,96,2,329.75,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1628,8119,507,40774,31118,2,67,2,69.25,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1629,8119,507,40774,31118,2,13,1,399.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1630,8119,508,40774,31118,2,96,2,2024.79,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1631,8119,508,40774,31118,2,67,2,425.21,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1632,8119,508,40774,31118,2,13,1,2450.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1633,8119,509,40774,31118,2,96,2,577.69,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1634,8119,509,40774,31118,2,67,2,121.31,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1635,8119,509,40774,31118,2,13,1,699.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1636,8119,510,40774,31118,2,96,2,866.94,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1637,8119,510,40774,31118,2,67,2,182.06,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1638,8119,510,40774,31118,2,13,1,1049.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1639,8119,511,40774,31118,2,96,2,784.30,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1640,8119,511,40774,31118,2,67,2,164.70,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1641,8119,511,40774,31118,2,13,1,949.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1642,8119,512,40774,31118,2,96,2,329.75,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1643,8119,512,40774,31118,2,67,2,69.25,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1644,8119,512,40774,31118,2,13,1,399.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1645,8119,513,40774,31118,2,96,2,1238.84,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1646,8119,513,40774,31118,2,67,2,260.16,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1647,8119,513,40774,31118,2,13,1,1499.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1648,8119,514,40774,31118,2,96,2,1858.68,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1649,8119,514,40774,31118,2,67,2,390.32,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1650,8119,514,40774,31118,2,13,1,2249.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL);
INSERT INTO `balance_libro_details` VALUES (1651,8119,515,40774,31118,2,96,2,2312.39,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1652,8119,515,40774,31118,2,67,2,485.61,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1653,8119,515,40774,31118,2,13,1,2798.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1654,8119,516,40774,31118,2,96,2,1238.84,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1655,8119,516,40774,31118,2,67,2,260.16,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1656,8119,516,40774,31118,2,13,1,1499.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1657,8119,517,40774,31118,2,96,2,701.65,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1658,8119,517,40774,31118,2,67,2,147.35,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1659,8119,517,40774,31118,2,13,1,849.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1660,8119,518,40774,31118,2,96,2,3050.42,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1661,8119,518,40774,31118,2,67,2,640.58,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1662,8119,518,40774,31118,2,13,1,3691.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1663,8119,519,40774,31118,2,96,2,825.62,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1664,8119,519,40774,31118,2,67,2,173.38,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1665,8119,519,40774,31118,2,13,1,999.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1666,8119,520,40774,31118,2,96,2,826.45,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1667,8119,520,40774,31118,2,67,2,173.55,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1668,8119,520,40774,31118,2,13,1,1000.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1669,8119,521,40774,31118,2,96,2,413.22,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1670,8119,521,40774,31118,2,67,2,86.78,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1671,8119,521,40774,31118,2,13,1,500.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1672,8119,522,40774,31118,2,96,2,14049.59,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1673,8119,522,40774,31118,2,67,2,2950.41,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1674,8119,522,40774,31118,2,13,1,17000.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1675,8119,523,40774,31118,2,96,2,8057.85,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1676,8119,523,40774,31118,2,67,2,1692.15,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1677,8119,523,40774,31118,2,13,1,9750.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1678,8119,524,40774,31118,2,96,2,1858.68,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1679,8119,524,40774,31118,2,67,2,390.32,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1680,8119,524,40774,31118,2,13,1,2249.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1681,8119,525,40774,31118,2,96,2,1070.25,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1682,8119,525,40774,31118,2,67,2,224.75,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1683,8119,525,40774,31118,2,13,1,1295.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1684,8119,526,40774,31118,2,96,2,14132.23,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1685,8119,526,40774,31118,2,67,2,2967.77,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1686,8119,526,40774,31118,2,13,1,17100.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1687,8119,527,40774,31118,2,96,2,412.40,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1688,8119,527,40774,31118,2,67,2,86.60,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1689,8119,527,40774,31118,2,13,1,499.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1690,8119,528,40774,31118,2,96,2,2403.30,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1691,8119,528,40774,31118,2,67,2,504.70,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL);
INSERT INTO `balance_libro_details` VALUES (1692,8119,528,40774,31118,2,13,1,2908.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1693,8119,529,40774,31118,2,96,2,784.30,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1694,8119,529,40774,31118,2,67,2,164.70,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1695,8119,529,40774,31118,2,13,1,949.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1696,8119,530,40774,31118,2,96,2,453.72,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1697,8119,530,40774,31118,2,67,2,95.28,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1698,8119,530,40774,31118,2,13,1,549.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1699,8119,531,40774,31118,2,96,2,2405.79,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1700,8119,531,40774,31118,2,67,2,505.21,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1701,8119,531,40774,31118,2,13,1,2911.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1702,8119,532,40774,31118,2,96,2,1486.78,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1703,8119,532,40774,31118,2,67,2,312.22,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1704,8119,532,40774,31118,2,13,1,1799.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1705,8119,533,40774,31118,2,96,2,866.94,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1706,8119,533,40774,31118,2,67,2,182.06,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1707,8119,533,40774,31118,2,13,1,1049.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1708,8119,534,40774,31118,2,96,2,14253.72,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1709,8119,534,40774,31118,2,67,2,2993.28,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1710,8119,534,40774,31118,2,13,1,17247.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1711,8119,535,40774,31118,2,96,2,453.72,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1712,8119,535,40774,31118,2,67,2,95.28,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1713,8119,535,40774,31118,2,13,1,549.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1714,8119,536,40774,31118,2,96,2,1238.84,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1715,8119,536,40774,31118,2,67,2,260.16,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1716,8119,536,40774,31118,2,13,1,1499.00,NULL,'2023-01-19 10:48:31','2023-01-19 10:48:31',NULL),(1717,8119,537,40774,31118,2,96,2,453.72,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1718,8119,537,40774,31118,2,67,2,95.28,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1719,8119,537,40774,31118,2,13,1,549.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1720,8119,538,40774,31118,2,96,2,453.72,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1721,8119,538,40774,31118,2,67,2,95.28,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1722,8119,538,40774,31118,2,13,1,549.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1723,8119,539,40774,31118,2,96,2,453.72,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1724,8119,539,40774,31118,2,67,2,95.28,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1725,8119,539,40774,31118,2,13,1,549.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1726,8119,540,40774,31118,2,96,2,1528.93,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1727,8119,540,40774,31118,2,67,2,321.07,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1728,8119,540,40774,31118,2,13,1,1850.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1729,8119,541,40774,31118,2,96,2,3015.70,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1730,8119,541,40774,31118,2,67,2,633.30,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1731,8119,541,40774,31118,2,13,1,3649.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1732,8119,542,40774,31118,2,96,2,1866.94,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL);
INSERT INTO `balance_libro_details` VALUES (1733,8119,542,40774,31118,2,67,2,392.06,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1734,8119,542,40774,31118,2,13,1,2259.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1735,8119,543,40774,31118,2,96,2,453.72,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1736,8119,543,40774,31118,2,67,2,95.28,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1737,8119,543,40774,31118,2,13,1,549.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1738,8119,544,40774,31118,2,96,2,1651.24,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1739,8119,544,40774,31118,2,67,2,346.76,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1740,8119,544,40774,31118,2,13,1,1998.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1741,8119,545,40774,31118,2,96,2,1074.38,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1742,8119,545,40774,31118,2,67,2,225.62,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1743,8119,545,40774,31118,2,13,1,1300.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1744,8119,546,40774,31118,2,96,2,742.98,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1745,8119,546,40774,31118,2,67,2,156.02,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1746,8119,546,40774,31118,2,13,1,899.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1747,8119,547,40774,31118,2,96,2,742.98,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1748,8119,547,40774,31118,2,67,2,156.02,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1749,8119,547,40774,31118,2,13,1,899.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1750,8119,548,40774,31118,2,96,2,660.33,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1751,8119,548,40774,31118,2,67,2,138.67,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1752,8119,548,40774,31118,2,13,1,799.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1753,8119,549,40774,31118,2,96,2,990.91,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1754,8119,549,40774,31118,2,67,2,208.09,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1755,8119,549,40774,31118,2,13,1,1199.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1756,8119,550,40774,31118,2,96,2,14876.03,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1757,8119,550,40774,31118,2,67,2,3123.97,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1758,8119,550,40774,31118,2,13,1,18000.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1759,8119,551,40774,31118,2,96,2,11611.58,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1760,8119,551,40774,31118,2,67,2,2438.42,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1761,8119,551,40774,31118,2,13,1,14050.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1762,8119,552,40774,31118,2,96,2,14297.53,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1763,8119,552,40774,31118,2,67,2,3002.47,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1764,8119,552,40774,31118,2,13,1,17300.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1765,8119,553,40774,31118,2,96,2,7520.66,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1766,8119,553,40774,31118,2,67,2,1579.34,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1767,8119,553,40774,31118,2,13,1,9100.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1768,8119,554,40774,31118,2,96,2,9297.52,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1769,8119,554,40774,31118,2,67,2,1952.48,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1770,8119,554,40774,31118,2,13,1,11250.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1771,8119,555,40774,31118,2,96,2,866.94,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1772,8119,555,40774,31118,2,67,2,182.06,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1773,8119,555,40774,31118,2,13,1,1049.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL);
INSERT INTO `balance_libro_details` VALUES (1774,8119,556,40774,31118,2,96,2,2891.74,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1775,8119,556,40774,31118,2,67,2,607.26,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1776,8119,556,40774,31118,2,13,1,3499.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1777,8119,557,40774,31118,2,96,2,3958.67,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1778,8119,557,40774,31118,2,67,2,831.33,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1779,8119,557,40774,31118,2,13,1,4790.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1780,8119,558,40774,31118,2,96,2,2685.12,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1781,8119,558,40774,31118,2,67,2,563.88,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1782,8119,558,40774,31118,2,13,1,3249.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1783,8119,559,40774,31118,2,96,2,949.59,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1784,8119,559,40774,31118,2,67,2,199.41,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1785,8119,559,40774,31118,2,13,1,1149.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1786,8119,560,40774,31118,2,96,2,2281.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1787,8119,560,40774,31118,2,67,2,479.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1788,8119,560,40774,31118,2,13,1,2760.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1789,8119,561,40774,31118,2,96,2,247.93,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1790,8119,561,40774,31118,2,67,2,52.07,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1791,8119,561,40774,31118,2,13,1,300.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1792,8119,562,40774,31118,2,96,2,2272.73,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1793,8119,562,40774,31118,2,67,2,477.27,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1794,8119,562,40774,31118,2,13,1,2750.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1795,8119,563,40774,31118,2,96,2,6198.35,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1796,8119,563,40774,31118,2,67,2,1301.65,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1797,8119,563,40774,31118,2,13,1,7500.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1798,8119,564,40774,31118,2,96,2,1420.67,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1799,8119,564,40774,31118,2,67,2,298.33,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1800,8119,564,40774,31118,2,13,1,1719.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1801,8119,565,40774,31118,2,96,2,2586.78,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1802,8119,565,40774,31118,2,67,2,543.22,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1803,8119,565,40774,31118,2,13,1,3130.00,NULL,'2023-01-19 10:48:32','2023-01-19 10:48:32',NULL),(1804,8119,566,40774,31118,2,96,2,2090.08,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1805,8119,566,40774,31118,2,67,2,438.92,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1806,8119,566,40774,31118,2,13,1,2529.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1807,8119,567,40774,31118,2,96,2,2578.52,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1808,8119,567,40774,31118,2,67,2,541.48,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1809,8119,567,40774,31118,2,13,1,3120.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1810,8119,568,40774,31118,2,96,2,577.69,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1811,8119,568,40774,31118,2,67,2,121.31,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1812,8119,568,40774,31118,2,13,1,699.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1813,8119,569,40774,31118,2,96,2,1109.92,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1814,8119,569,40774,31118,2,67,2,233.08,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL);
INSERT INTO `balance_libro_details` VALUES (1815,8119,569,40774,31118,2,13,1,1343.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1816,8119,570,40774,31118,2,96,2,1317.36,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1817,8119,570,40774,31118,2,67,2,276.64,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1818,8119,570,40774,31118,2,13,1,1594.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1819,8119,571,40774,31118,2,96,2,2103.31,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1820,8119,571,40774,31118,2,67,2,441.69,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1821,8119,571,40774,31118,2,13,1,2545.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1822,8119,572,40774,31118,2,96,2,1858.68,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1823,8119,572,40774,31118,2,67,2,390.32,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1824,8119,572,40774,31118,2,13,1,2249.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1825,8119,573,40774,31118,2,96,2,413.22,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1826,8119,573,40774,31118,2,67,2,86.78,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1827,8119,573,40774,31118,2,13,1,500.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1828,8119,574,40774,31118,2,96,2,2180.99,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1829,8119,574,40774,31118,2,67,2,458.01,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1830,8119,574,40774,31118,2,13,1,2639.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1831,8119,575,40774,31118,2,96,2,1074.38,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1832,8119,575,40774,31118,2,67,2,225.62,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1833,8119,575,40774,31118,2,13,1,1300.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1834,8119,576,40774,31118,2,96,2,743.80,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1835,8119,576,40774,31118,2,67,2,156.20,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1836,8119,576,40774,31118,2,13,1,900.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1837,8119,577,40774,31118,2,96,2,2156.20,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1838,8119,577,40774,31118,2,67,2,452.80,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1839,8119,577,40774,31118,2,13,1,2609.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1840,8119,578,40774,31118,2,96,2,990.91,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1841,8119,578,40774,31118,2,67,2,208.09,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1842,8119,578,40774,31118,2,13,1,1199.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1843,8119,579,40774,31118,2,96,2,825.62,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1844,8119,579,40774,31118,2,67,2,173.38,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1845,8119,579,40774,31118,2,13,1,999.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1846,8119,580,40774,31118,2,96,2,3468.60,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1847,8119,580,40774,31118,2,67,2,728.40,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1848,8119,580,40774,31118,2,13,1,4197.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1849,8119,581,40774,31118,2,96,2,2180.99,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1850,8119,581,40774,31118,2,67,2,458.01,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1851,8119,581,40774,31118,2,13,1,2639.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1852,8119,582,40774,31118,2,96,2,826.45,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1853,8119,582,40774,31118,2,67,2,173.55,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1854,8119,582,40774,31118,2,13,1,1000.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1855,8119,583,40774,31118,2,96,2,329.75,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL);
INSERT INTO `balance_libro_details` VALUES (1856,8119,583,40774,31118,2,67,2,69.25,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1857,8119,583,40774,31118,2,13,1,399.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1858,8119,584,40774,31118,2,96,2,1041.32,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1859,8119,584,40774,31118,2,67,2,218.68,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1860,8119,584,40774,31118,2,13,1,1260.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1861,8119,585,40774,31118,2,96,2,660.33,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1862,8119,585,40774,31118,2,67,2,138.67,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1863,8119,585,40774,31118,2,13,1,799.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1864,8119,586,40774,31118,2,96,2,453.72,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1865,8119,586,40774,31118,2,67,2,95.28,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1866,8119,586,40774,31118,2,13,1,549.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1867,8119,587,40774,31118,2,96,2,413.22,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1868,8119,587,40774,31118,2,67,2,86.78,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1869,8119,587,40774,31118,2,13,1,500.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1870,8119,588,40774,31118,2,96,2,2182.65,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1871,8119,588,40774,31118,2,67,2,458.35,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1872,8119,588,40774,31118,2,13,1,2641.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1873,8119,589,40774,31118,2,96,2,329.75,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1874,8119,589,40774,31118,2,67,2,69.25,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1875,8119,589,40774,31118,2,13,1,399.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1876,8119,590,40774,31118,2,96,2,3593.38,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1877,8119,590,40774,31118,2,67,2,754.62,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1878,8119,590,40774,31118,2,13,1,4348.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1879,8119,591,40774,31118,2,96,2,2685.12,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1880,8119,591,40774,31118,2,67,2,563.88,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1881,8119,591,40774,31118,2,13,1,3249.00,NULL,'2023-01-19 10:48:33','2023-01-19 10:48:33',NULL),(1882,8119,592,40774,31118,2,96,2,743.80,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1883,8119,592,40774,31118,2,67,2,156.20,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1884,8119,592,40774,31118,2,13,1,900.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1885,8119,593,40774,31118,2,96,2,2594.22,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1886,8119,593,40774,31118,2,67,2,544.78,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1887,8119,593,40774,31118,2,13,1,3139.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1888,8119,594,40774,31118,2,96,2,2643.80,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1889,8119,594,40774,31118,2,67,2,555.20,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1890,8119,594,40774,31118,2,13,1,3199.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1891,8119,595,40774,31118,2,96,2,536.36,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1892,8119,595,40774,31118,2,67,2,112.64,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1893,8119,595,40774,31118,2,13,1,649.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1894,8119,596,40774,31118,2,96,2,2081.82,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1895,8119,596,40774,31118,2,67,2,437.18,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1896,8119,596,40774,31118,2,13,1,2519.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL);
INSERT INTO `balance_libro_details` VALUES (1897,8119,597,40774,31118,2,96,2,619.01,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1898,8119,597,40774,31118,2,67,2,129.99,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1899,8119,597,40774,31118,2,13,1,749.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1900,8119,598,40774,31118,2,96,2,536.36,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1901,8119,598,40774,31118,2,67,2,112.64,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1902,8119,598,40774,31118,2,13,1,649.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1903,8119,599,40774,31118,2,96,2,1817.35,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1904,8119,599,40774,31118,2,67,2,381.65,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1905,8119,599,40774,31118,2,13,1,2199.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1906,8119,600,40774,31118,2,96,2,2814.05,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1907,8119,600,40774,31118,2,67,2,590.95,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1908,8119,600,40774,31118,2,13,1,3405.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1909,8119,601,40774,31118,2,96,2,1155.37,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1910,8119,601,40774,31118,2,67,2,242.63,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1911,8119,601,40774,31118,2,13,1,1398.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1912,8119,602,40774,31118,2,96,2,329.75,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1913,8119,602,40774,31118,2,67,2,69.25,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1914,8119,602,40774,31118,2,13,1,399.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1915,8119,603,40774,31118,2,96,2,2147.93,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1916,8119,603,40774,31118,2,67,2,451.07,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1917,8119,603,40774,31118,2,13,1,2599.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1918,8119,604,40774,31118,2,96,2,247.93,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1919,8119,604,40774,31118,2,67,2,52.07,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1920,8119,604,40774,31118,2,13,1,300.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1921,8119,605,40774,31118,2,96,2,2638.02,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1922,8119,605,40774,31118,2,67,2,553.98,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1923,8119,605,40774,31118,2,13,1,3192.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1924,8119,606,40774,31118,2,96,2,1771.90,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1925,8119,606,40774,31118,2,67,2,372.10,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1926,8119,606,40774,31118,2,13,1,2144.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1927,8119,607,40774,31118,2,96,2,1900.83,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1928,8119,607,40774,31118,2,67,2,399.17,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1929,8119,607,40774,31118,2,13,1,2300.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1930,8119,608,40774,31118,2,96,2,2395.86,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1931,8119,608,40774,31118,2,67,2,503.14,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1932,8119,608,40774,31118,2,13,1,2899.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1933,8119,609,40774,31118,2,96,2,2849.58,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1934,8119,609,40774,31118,2,67,2,598.42,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1935,8119,609,40774,31118,2,13,1,3448.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1936,8119,610,40774,31118,2,96,2,2432.23,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1937,8119,610,40774,31118,2,67,2,510.77,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL);
INSERT INTO `balance_libro_details` VALUES (1938,8119,610,40774,31118,2,13,1,2943.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1939,8119,611,40774,31118,2,96,2,5169.42,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1940,8119,611,40774,31118,2,67,2,1085.58,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1941,8119,611,40774,31118,2,13,1,6255.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1942,8119,612,40774,31118,2,96,2,2081.82,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1943,8119,612,40774,31118,2,67,2,437.18,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1944,8119,612,40774,31118,2,13,1,2519.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1945,8119,613,40774,31118,2,96,2,2032.23,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1946,8119,613,40774,31118,2,67,2,426.77,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1947,8119,613,40774,31118,2,13,1,2459.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1948,8119,614,40774,31118,2,96,2,1772.73,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1949,8119,614,40774,31118,2,67,2,372.27,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1950,8119,614,40774,31118,2,13,1,2145.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1951,8119,615,40774,31118,2,96,2,3799.16,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1952,8119,615,40774,31118,2,67,2,797.84,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1953,8119,615,40774,31118,2,13,1,4597.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1954,8119,616,40774,31118,2,96,2,1979.34,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1955,8119,616,40774,31118,2,67,2,415.66,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1956,8119,616,40774,31118,2,13,1,2395.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1957,8119,617,40774,31118,2,96,2,2023.96,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1958,8119,617,40774,31118,2,67,2,425.04,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1959,8119,617,40774,31118,2,13,1,2449.00,NULL,'2023-01-19 10:48:34','2023-01-19 10:48:34',NULL),(1960,8119,618,40774,31118,2,96,2,289.26,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1961,8119,618,40774,31118,2,67,2,60.74,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1962,8119,618,40774,31118,2,13,1,350.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1963,8119,619,40774,31118,2,96,2,1784.30,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1964,8119,619,40774,31118,2,67,2,374.70,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1965,8119,619,40774,31118,2,13,1,2159.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1966,8119,620,40774,31118,2,96,2,1858.68,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1967,8119,620,40774,31118,2,67,2,390.32,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1968,8119,620,40774,31118,2,13,1,2249.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1969,8119,621,40774,31118,2,96,2,5674.38,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1970,8119,621,40774,31118,2,67,2,1191.62,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1971,8119,621,40774,31118,2,13,1,6866.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1972,8119,622,40774,31118,2,96,2,2040.49,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1973,8119,622,40774,31118,2,67,2,428.51,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1974,8119,622,40774,31118,2,13,1,2469.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1975,8119,623,40774,31118,2,96,2,1833.89,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1976,8119,623,40774,31118,2,67,2,385.11,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1977,8119,623,40774,31118,2,13,1,2219.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1978,8119,624,40774,31118,2,96,2,2288.43,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL);
INSERT INTO `balance_libro_details` VALUES (1979,8119,624,40774,31118,2,67,2,480.57,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1980,8119,624,40774,31118,2,13,1,2769.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1981,8119,625,40774,31118,2,96,2,1937.19,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1982,8119,625,40774,31118,2,67,2,406.81,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1983,8119,625,40774,31118,2,13,1,2344.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1984,8119,626,40774,31118,2,96,2,247.93,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1985,8119,626,40774,31118,2,67,2,52.07,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1986,8119,626,40774,31118,2,13,1,300.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1987,8119,627,40774,31118,2,96,2,1028.93,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1988,8119,627,40774,31118,2,67,2,216.07,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1989,8119,627,40774,31118,2,13,1,1245.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1990,8119,628,40774,31118,2,96,2,1730.58,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1991,8119,628,40774,31118,2,67,2,363.42,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1992,8119,628,40774,31118,2,13,1,2094.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1993,8119,629,40774,31118,2,96,2,2477.69,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1994,8119,629,40774,31118,2,67,2,520.31,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1995,8119,629,40774,31118,2,13,1,2998.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1996,8119,630,40774,31118,2,96,2,247.93,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1997,8119,630,40774,31118,2,67,2,52.07,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1998,8119,630,40774,31118,2,13,1,300.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(1999,8119,631,40774,31118,2,96,2,3181.81,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2000,8119,631,40774,31118,2,67,2,668.19,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2001,8119,631,40774,31118,2,13,1,3850.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2002,8119,632,40774,31118,2,96,2,5037.19,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2003,8119,632,40774,31118,2,67,2,1057.81,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2004,8119,632,40774,31118,2,13,1,6095.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2005,8119,633,40774,31118,2,96,2,1028.10,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2006,8119,633,40774,31118,2,67,2,215.90,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2007,8119,633,40774,31118,2,13,1,1244.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2008,8119,634,40774,31118,2,96,2,2238.84,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2009,8119,634,40774,31118,2,67,2,470.16,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2010,8119,634,40774,31118,2,13,1,2709.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2011,8119,635,40774,31118,2,96,2,2189.25,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2012,8119,635,40774,31118,2,67,2,459.75,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2013,8119,635,40774,31118,2,13,1,2649.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2014,8119,636,40774,31118,2,96,2,1937.19,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2015,8119,636,40774,31118,2,67,2,406.81,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2016,8119,636,40774,31118,2,13,1,2344.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2017,8119,637,40774,31118,2,96,2,2909.10,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2018,8119,637,40774,31118,2,67,2,610.90,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2019,8119,637,40774,31118,2,13,1,3520.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL);
INSERT INTO `balance_libro_details` VALUES (2020,8119,638,40774,31118,2,96,2,2040.49,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2021,8119,638,40774,31118,2,67,2,428.51,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2022,8119,638,40774,31118,2,13,1,2469.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2023,8119,639,40774,31118,2,96,2,1031.40,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2024,8119,639,40774,31118,2,67,2,216.60,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2025,8119,639,40774,31118,2,13,1,1248.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2026,8119,640,40774,31118,2,96,2,412.40,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2027,8119,640,40774,31118,2,67,2,86.60,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2028,8119,640,40774,31118,2,13,1,499.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2029,8119,641,40774,31118,2,96,2,2438.01,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2030,8119,641,40774,31118,2,67,2,511.99,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2031,8119,641,40774,31118,2,13,1,2950.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2032,8119,642,40774,31118,2,96,2,866.94,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2033,8119,642,40774,31118,2,67,2,182.06,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2034,8119,642,40774,31118,2,13,1,1049.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2035,8119,643,40774,31118,2,96,2,4742.98,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2036,8119,643,40774,31118,2,67,2,996.02,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2037,8119,643,40774,31118,2,13,1,5739.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2038,8119,644,40774,31118,2,96,2,577.69,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2039,8119,644,40774,31118,2,67,2,121.31,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2040,8119,644,40774,31118,2,13,1,699.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2041,8119,645,40774,31118,2,96,2,412.40,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2042,8119,645,40774,31118,2,67,2,86.60,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2043,8119,645,40774,31118,2,13,1,499.00,NULL,'2023-01-19 10:48:35','2023-01-19 10:48:35',NULL),(2044,8119,646,40774,31118,2,96,2,2685.12,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2045,8119,646,40774,31118,2,67,2,563.88,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2046,8119,646,40774,31118,2,13,1,3249.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2047,8119,647,40774,31118,2,96,2,3428.93,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2048,8119,647,40774,31118,2,67,2,720.07,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2049,8119,647,40774,31118,2,13,1,4149.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2050,8119,648,40774,31118,2,96,2,1826.44,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2051,8119,648,40774,31118,2,67,2,383.56,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2052,8119,648,40774,31118,2,13,1,2210.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2053,8119,649,40774,31118,2,96,2,412.40,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2054,8119,649,40774,31118,2,67,2,86.60,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2055,8119,649,40774,31118,2,13,1,499.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2056,8119,650,40774,31118,2,96,2,412.40,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2057,8119,650,40774,31118,2,67,2,86.60,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2058,8119,650,40774,31118,2,13,1,499.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2059,8119,651,40774,31118,2,96,2,2280.16,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2060,8119,651,40774,31118,2,67,2,478.84,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL);
INSERT INTO `balance_libro_details` VALUES (2061,8119,651,40774,31118,2,13,1,2759.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2062,8119,652,40774,31118,2,96,2,19449.59,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2063,8119,652,40774,31118,2,67,2,4084.41,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2064,8119,652,40774,31118,2,13,1,23534.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2065,8119,653,40774,31118,2,96,2,2971.07,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2066,8119,653,40774,31118,2,67,2,623.93,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2067,8119,653,40774,31118,2,13,1,3595.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2068,8119,654,40774,31118,2,96,2,7231.40,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2069,8119,654,40774,31118,2,67,2,1518.60,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2070,8119,654,40774,31118,2,13,1,8750.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2071,8119,655,40774,31118,2,96,2,7683.47,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2072,8119,655,40774,31118,2,67,2,1613.53,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2073,8119,655,40774,31118,2,13,1,9297.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2074,8119,656,40774,31118,2,96,2,4709.92,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2075,8119,656,40774,31118,2,67,2,989.08,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2076,8119,656,40774,31118,2,13,1,5699.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2077,8119,657,40774,31118,2,96,2,4952.06,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2078,8119,657,40774,31118,2,67,2,1039.94,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2079,8119,657,40774,31118,2,13,1,5992.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2080,8119,658,40774,31118,2,96,2,3509.09,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2081,8119,658,40774,31118,2,67,2,736.91,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2082,8119,658,40774,31118,2,13,1,4246.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2083,8119,659,40774,31118,2,96,2,5821.49,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2084,8119,659,40774,31118,2,67,2,1222.51,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2085,8119,659,40774,31118,2,13,1,7044.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2086,8119,660,40774,31118,2,96,2,11483.47,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2087,8119,660,40774,31118,2,67,2,2411.53,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2088,8119,660,40774,31118,2,13,1,13895.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2089,8119,661,40774,31118,2,96,2,1688.43,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2090,8119,661,40774,31118,2,67,2,354.57,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2091,8119,661,40774,31118,2,13,1,2043.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2092,8119,662,40774,31118,2,96,2,3717.36,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2093,8119,662,40774,31118,2,67,2,780.64,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2094,8119,662,40774,31118,2,13,1,4498.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2095,8119,663,40774,31118,2,96,2,3272.72,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2096,8119,663,40774,31118,2,67,2,687.28,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2097,8119,663,40774,31118,2,13,1,3960.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2098,8119,664,40774,31118,2,96,2,8179.34,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2099,8119,664,40774,31118,2,67,2,1717.66,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2100,8119,664,40774,31118,2,13,1,9897.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2101,8119,665,40774,31118,2,96,2,6695.86,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL);
INSERT INTO `balance_libro_details` VALUES (2102,8119,665,40774,31118,2,67,2,1406.14,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2103,8119,665,40774,31118,2,13,1,8102.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2104,8119,666,40774,31118,2,96,2,4955.37,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2105,8119,666,40774,31118,2,67,2,1040.63,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2106,8119,666,40774,31118,2,13,1,5996.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2107,8119,667,40774,31118,2,96,2,3533.89,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2108,8119,667,40774,31118,2,67,2,742.11,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2109,8119,667,40774,31118,2,13,1,4276.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2110,8119,668,40774,31118,2,218,2,0.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2111,8119,668,40774,31118,2,218,2,2968.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2112,8119,668,40774,31118,2,13,1,2968.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2113,8119,669,40774,31118,2,96,2,1652.07,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2114,8119,669,40774,31118,2,67,2,346.93,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2115,8119,669,40774,31118,2,13,1,1999.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2116,8119,670,40774,31118,2,96,2,2940.49,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2117,8119,670,40774,31118,2,67,2,617.51,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2118,8119,670,40774,31118,2,13,1,3558.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2119,8119,671,40774,31118,2,96,2,4666.95,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2120,8119,671,40774,31118,2,67,2,980.05,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2121,8119,671,40774,31118,2,13,1,5647.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2122,8119,672,40774,31118,2,96,2,4253.72,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2123,8119,672,40774,31118,2,67,2,893.28,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2124,8119,672,40774,31118,2,13,1,5147.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2125,8119,673,40774,31118,2,96,2,6858.68,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2126,8119,673,40774,31118,2,67,2,1440.32,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2127,8119,673,40774,31118,2,13,1,8299.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2128,8119,674,40774,31118,2,96,2,8595.04,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2129,8119,674,40774,31118,2,67,2,1804.96,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2130,8119,674,40774,31118,2,13,1,10400.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2131,8119,675,40774,31118,2,96,2,6198.35,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2132,8119,675,40774,31118,2,67,2,1301.65,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2133,8119,675,40774,31118,2,13,1,7500.00,NULL,'2023-01-19 10:48:36','2023-01-19 10:48:36',NULL),(2134,8119,676,40774,31118,2,96,2,7107.44,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2135,8119,676,40774,31118,2,67,2,1492.56,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2136,8119,676,40774,31118,2,13,1,8600.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2137,8119,677,40774,31118,2,96,2,7685.95,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2138,8119,677,40774,31118,2,67,2,1614.05,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2139,8119,677,40774,31118,2,13,1,9300.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2140,8119,678,40774,31118,2,96,2,1074.38,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2141,8119,678,40774,31118,2,67,2,225.62,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2142,8119,678,40774,31118,2,13,1,1300.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL);
INSERT INTO `balance_libro_details` VALUES (2143,8119,679,40774,31118,2,96,2,412.40,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2144,8119,679,40774,31118,2,67,2,86.60,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2145,8119,679,40774,31118,2,13,1,499.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2146,8119,680,40774,31118,2,96,2,1619.01,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2147,8119,680,40774,31118,2,67,2,339.99,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2148,8119,680,40774,31118,2,13,1,1959.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2149,8119,681,40774,31118,2,96,2,660.33,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2150,8119,681,40774,31118,2,67,2,138.67,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2151,8119,681,40774,31118,2,13,1,799.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2152,8119,682,40774,31118,2,96,2,1523.14,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2153,8119,682,40774,31118,2,67,2,319.86,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2154,8119,682,40774,31118,2,13,1,1843.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2155,8119,683,40774,31118,2,96,2,536.36,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2156,8119,683,40774,31118,2,67,2,112.64,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2157,8119,683,40774,31118,2,13,1,649.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2158,8119,684,40774,31118,2,96,2,5661.16,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2159,8119,684,40774,31118,2,67,2,1188.84,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2160,8119,684,40774,31118,2,13,1,6850.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2161,8119,685,40774,31118,2,96,2,3352.07,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2162,8119,685,40774,31118,2,67,2,703.93,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2163,8119,685,40774,31118,2,13,1,4056.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2164,8119,686,40774,31118,2,96,2,7514.06,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2165,8119,686,40774,31118,2,67,2,1577.94,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2166,8119,686,40774,31118,2,13,1,9092.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2167,8119,687,40774,31118,2,96,2,1238.84,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2168,8119,687,40774,31118,2,67,2,260.16,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2169,8119,687,40774,31118,2,13,1,1499.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2170,8119,688,40774,31118,2,96,2,1908.26,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2171,8119,688,40774,31118,2,67,2,400.74,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2172,8119,688,40774,31118,2,13,1,2309.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2173,8119,689,40774,31118,2,96,2,536.36,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2174,8119,689,40774,31118,2,67,2,112.64,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2175,8119,689,40774,31118,2,13,1,649.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2176,8119,690,40774,31118,2,96,2,1867.76,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2177,8119,690,40774,31118,2,67,2,392.24,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2178,8119,690,40774,31118,2,13,1,2260.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2179,8119,691,40774,31118,2,96,2,413.22,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2180,8119,691,40774,31118,2,67,2,86.78,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2181,8119,691,40774,31118,2,13,1,500.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2182,8119,692,40774,31118,2,96,2,1069.42,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2183,8119,692,40774,31118,2,67,2,224.58,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL);
INSERT INTO `balance_libro_details` VALUES (2184,8119,692,40774,31118,2,13,1,1294.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2185,8119,693,40774,31118,2,96,2,950.41,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2186,8119,693,40774,31118,2,67,2,199.59,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2187,8119,693,40774,31118,2,13,1,1150.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2188,8119,694,40774,31118,2,96,2,990.91,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2189,8119,694,40774,31118,2,67,2,208.09,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2190,8119,694,40774,31118,2,13,1,1199.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2191,8119,695,40774,31118,2,96,2,1652.07,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2192,8119,695,40774,31118,2,67,2,346.93,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2193,8119,695,40774,31118,2,13,1,1999.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2194,8119,696,40774,31118,2,96,2,701.65,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2195,8119,696,40774,31118,2,67,2,147.35,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2196,8119,696,40774,31118,2,13,1,849.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2197,8119,697,40774,31118,2,96,2,2031.41,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2198,8119,697,40774,31118,2,67,2,426.59,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2199,8119,697,40774,31118,2,13,1,2458.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2200,8119,698,40774,31118,2,96,2,825.62,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2201,8119,698,40774,31118,2,67,2,173.38,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2202,8119,698,40774,31118,2,13,1,999.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2203,8119,699,40774,31118,2,96,2,1771.90,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2204,8119,699,40774,31118,2,67,2,372.10,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2205,8119,699,40774,31118,2,13,1,2144.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2206,8119,700,40774,31118,2,96,2,577.69,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2207,8119,700,40774,31118,2,67,2,121.31,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2208,8119,700,40774,31118,2,13,1,699.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2209,8119,701,40774,31118,2,96,2,1114.88,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2210,8119,701,40774,31118,2,67,2,234.12,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2211,8119,701,40774,31118,2,13,1,1349.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2212,8119,702,40774,31118,2,96,2,990.91,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2213,8119,702,40774,31118,2,67,2,208.09,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2214,8119,702,40774,31118,2,13,1,1199.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2215,8119,703,40774,31118,2,96,2,536.36,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2216,8119,703,40774,31118,2,67,2,112.64,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2217,8119,703,40774,31118,2,13,1,649.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2218,8119,704,40774,31118,2,96,2,1198.35,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2219,8119,704,40774,31118,2,67,2,251.65,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2220,8119,704,40774,31118,2,13,1,1450.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2221,8119,705,40774,31118,2,96,2,453.72,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2222,8119,705,40774,31118,2,67,2,95.28,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2223,8119,705,40774,31118,2,13,1,549.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2224,8119,706,40774,31118,2,96,2,866.94,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL);
INSERT INTO `balance_libro_details` VALUES (2225,8119,706,40774,31118,2,67,2,182.06,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2226,8119,706,40774,31118,2,13,1,1049.00,NULL,'2023-01-19 10:48:37','2023-01-19 10:48:37',NULL),(2227,8119,707,40774,31118,2,96,2,990.08,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2228,8119,707,40774,31118,2,67,2,207.92,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2229,8119,707,40774,31118,2,13,1,1198.00,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2230,8119,708,40774,31118,2,96,2,990.91,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2231,8119,708,40774,31118,2,67,2,208.09,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2232,8119,708,40774,31118,2,13,1,1199.00,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2233,8119,709,40774,31118,2,96,2,1528.10,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2234,8119,709,40774,31118,2,67,2,320.90,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2235,8119,709,40774,31118,2,13,1,1849.00,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2236,8119,710,40774,31118,2,96,2,659.50,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2237,8119,710,40774,31118,2,67,2,138.50,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2238,8119,710,40774,31118,2,13,1,798.00,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2239,8119,711,40774,31118,2,96,2,1735.54,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2240,8119,711,40774,31118,2,67,2,364.46,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2241,8119,711,40774,31118,2,13,1,2100.00,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2242,8119,712,40774,31118,2,96,2,2477.69,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2243,8119,712,40774,31118,2,67,2,520.31,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2244,8119,712,40774,31118,2,13,1,2998.00,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2245,8119,713,40774,31118,2,96,2,1196.69,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2246,8119,713,40774,31118,2,67,2,251.31,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2247,8119,713,40774,31118,2,13,1,1448.00,NULL,'2023-01-19 10:48:38','2023-01-19 10:48:38',NULL),(2248,8119,714,40774,31118,3,250,1,23111.95,NULL,'2023-01-19 10:48:53','2023-01-19 11:08:30','2023-01-19 11:08:30'),(2249,8119,714,40774,31118,3,57,2,23111.95,NULL,'2023-01-19 10:48:53','2023-01-19 11:08:30','2023-01-19 11:08:30'),(2250,8119,715,40774,31118,3,217,1,6535.61,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2251,8119,715,40774,31118,3,68,1,1372.48,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2252,8119,715,40774,31118,3,57,2,7908.09,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2253,8119,716,40774,31118,3,217,1,4214.88,NULL,'2023-01-19 10:48:54','2023-01-19 11:08:22','2023-01-19 11:08:22'),(2254,8119,716,40774,31118,3,68,1,885.12,NULL,'2023-01-19 10:48:54','2023-01-19 11:08:22','2023-01-19 11:08:22'),(2255,8119,716,40774,31118,3,57,2,5100.00,NULL,'2023-01-19 10:48:54','2023-01-19 11:08:22','2023-01-19 11:08:22'),(2256,8119,717,40774,31118,3,217,1,9195.12,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2257,8119,717,40774,31118,3,68,1,1930.98,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2258,8119,717,40774,31118,3,217,1,1172.37,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2259,8119,717,40774,31118,3,57,2,12298.47,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2260,8119,718,40774,31118,3,217,1,58343.35,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2261,8119,718,40774,31118,3,68,1,12252.10,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2262,8119,718,40774,31118,3,217,1,7438.77,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2263,8119,718,40774,31118,3,57,2,78034.22,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2264,8119,719,40774,31118,3,217,2,1788.62,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL);
INSERT INTO `balance_libro_details` VALUES (2265,8119,719,40774,31118,3,67,2,375.61,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2266,8119,719,40774,31118,3,217,2,53.66,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2267,8119,719,40774,31118,3,57,1,2217.89,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2268,8119,720,40774,31118,3,217,1,35768.20,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2269,8119,720,40774,31118,3,68,1,7511.32,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2270,8119,720,40774,31118,3,217,1,7040.61,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2271,8119,720,40774,31118,3,57,2,50320.13,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2272,8119,721,40774,31118,3,217,1,34101.73,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2273,8119,721,40774,31118,3,68,1,7161.36,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2274,8119,721,40774,31118,3,217,1,1619.83,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2275,8119,721,40774,31118,3,57,2,42882.92,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2276,8119,722,40774,31118,3,217,2,600.99,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2277,8119,722,40774,31118,3,67,2,126.21,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2278,8119,722,40774,31118,3,217,2,148.52,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2279,8119,722,40774,31118,3,57,1,875.72,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2280,8119,723,40774,31118,3,217,1,366.32,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2281,8119,723,40774,31118,3,68,1,76.93,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2282,8119,723,40774,31118,3,57,2,443.25,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2283,8119,724,40774,31118,3,217,2,3521.69,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2284,8119,724,40774,31118,3,67,2,739.55,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2285,8119,724,40774,31118,3,57,1,4261.24,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2286,8119,725,40774,31118,3,250,1,0.00,NULL,'2023-01-19 10:48:54','2023-01-19 11:08:04','2023-01-19 11:08:04'),(2287,8119,725,40774,31118,3,57,2,0.00,NULL,'2023-01-19 10:48:54','2023-01-19 11:08:04','2023-01-19 11:08:04'),(2288,8119,726,40774,31118,3,250,1,0.00,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:49','2023-01-19 11:07:49'),(2289,8119,726,40774,31118,3,57,2,0.00,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:49','2023-01-19 11:07:49'),(2290,8119,727,40774,31118,3,250,1,0.00,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:56','2023-01-19 11:07:56'),(2291,8119,727,40774,31118,3,57,2,0.00,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:56','2023-01-19 11:07:56'),(2292,8119,728,40774,31118,3,217,1,62443.44,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2293,8119,728,40774,31118,3,68,1,6556.56,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2294,8119,728,40774,31118,3,57,2,69000.00,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2295,8119,729,40774,31118,3,217,1,123.97,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:41','2023-01-19 11:07:41'),(2296,8119,729,40774,31118,3,68,1,26.03,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:41','2023-01-19 11:07:41'),(2297,8119,729,40774,31118,3,57,2,150.00,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:41','2023-01-19 11:07:41'),(2298,8119,730,40774,31118,3,217,1,673.55,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:34','2023-01-19 11:07:34'),(2299,8119,730,40774,31118,3,68,1,141.45,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:34','2023-01-19 11:07:34'),(2300,8119,730,40774,31118,3,57,2,815.00,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:34','2023-01-19 11:07:34'),(2301,8119,731,40774,31118,3,217,1,134.71,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:14','2023-01-19 11:07:14'),(2302,8119,731,40774,31118,3,68,1,28.29,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:14','2023-01-19 11:07:14');
INSERT INTO `balance_libro_details` VALUES (2303,8119,731,40774,31118,3,57,2,163.00,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:14','2023-01-19 11:07:14'),(2304,8119,732,40774,31118,3,250,1,16000.00,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2305,8119,732,40774,31118,3,57,2,16000.00,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2306,8119,733,40774,31118,3,217,1,12470.00,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2307,8119,733,40774,31118,3,68,1,2618.70,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2308,8119,733,40774,31118,3,57,2,15088.70,NULL,'2023-01-19 10:48:54','2023-01-19 10:48:54',NULL),(2309,8119,734,40774,31118,3,217,1,178.51,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:23','2023-01-19 11:07:23'),(2310,8119,734,40774,31118,3,68,1,37.49,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:23','2023-01-19 11:07:23'),(2311,8119,734,40774,31118,3,57,2,216.00,NULL,'2023-01-19 10:48:54','2023-01-19 11:07:23','2023-01-19 11:07:23'),(2312,8119,735,40774,31118,3,217,1,8600.00,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2313,8119,735,40774,31118,3,68,1,1806.00,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2314,8119,735,40774,31118,3,57,2,10406.00,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2315,8119,736,40774,31118,3,217,1,115223.69,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2316,8119,736,40774,31118,3,68,1,20822.11,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2317,8119,736,40774,31118,3,57,2,136045.80,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2318,8119,737,40774,31118,3,217,1,82663.22,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2319,8119,737,40774,31118,3,68,1,17359.28,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2320,8119,737,40774,31118,3,57,2,100022.50,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2321,8119,738,40774,31118,3,217,1,6400.83,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2322,8119,738,40774,31118,3,68,1,1344.17,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2323,8119,738,40774,31118,3,57,2,7745.00,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2324,8119,739,40774,31118,3,217,1,100209.51,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2325,8119,739,40774,31118,3,68,1,21044.00,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2326,8119,739,40774,31118,3,217,1,4759.94,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2327,8119,739,40774,31118,3,57,2,126013.45,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2328,8119,740,40774,31118,3,217,1,95491.40,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2329,8119,740,40774,31118,3,68,1,20053.19,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2330,8119,740,40774,31118,3,217,1,19342.18,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2331,8119,740,40774,31118,3,57,2,134886.77,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2332,8119,741,40774,31118,3,217,1,2066.31,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2333,8119,741,40774,31118,3,68,1,433.93,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2334,8119,741,40774,31118,3,57,2,2500.24,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2335,8119,742,40774,31118,3,217,2,942.14,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2336,8119,742,40774,31118,3,67,2,197.85,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2337,8119,742,40774,31118,3,217,2,28.26,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2338,8119,742,40774,31118,3,57,1,1168.25,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2339,8119,743,40774,31118,3,217,2,11442.13,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2340,8119,743,40774,31118,3,67,2,2402.85,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2341,8119,743,40774,31118,3,57,1,13844.98,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2342,8119,744,40774,31118,3,217,1,18540.73,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL);
INSERT INTO `balance_libro_details` VALUES (2343,8119,744,40774,31118,3,68,1,3893.56,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2344,8119,744,40774,31118,3,217,1,2363.95,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2345,8119,744,40774,31118,3,57,2,24798.24,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2346,8119,745,40774,31118,3,217,2,255.26,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2347,8119,745,40774,31118,3,67,2,53.61,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2348,8119,745,40774,31118,3,217,2,59.47,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2349,8119,745,40774,31118,3,57,1,368.34,NULL,'2023-01-19 10:48:55','2023-01-19 10:48:55',NULL),(2350,8119,746,40774,31118,3,217,1,5791.74,NULL,'2023-01-19 10:48:56','2023-01-19 11:07:00','2023-01-19 11:07:00'),(2351,8119,746,40774,31118,3,68,1,1216.26,NULL,'2023-01-19 10:48:56','2023-01-19 11:07:00','2023-01-19 11:07:00'),(2352,8119,746,40774,31118,3,57,2,7008.00,NULL,'2023-01-19 10:48:56','2023-01-19 11:07:00','2023-01-19 11:07:00'),(2353,8119,747,40774,31118,3,217,1,20200.00,NULL,'2023-01-19 10:48:56','2023-01-19 10:48:56',NULL),(2354,8119,747,40774,31118,3,68,1,2121.00,NULL,'2023-01-19 10:48:56','2023-01-19 10:48:56',NULL),(2355,8119,747,40774,31118,3,57,2,22321.00,NULL,'2023-01-19 10:48:56','2023-01-19 10:48:56',NULL),(2356,8119,748,40774,31118,3,217,1,1554.27,NULL,'2023-01-19 10:48:56','2023-01-19 10:48:56',NULL),(2357,8119,748,40774,31118,3,68,1,326.40,NULL,'2023-01-19 10:48:56','2023-01-19 10:48:56',NULL),(2358,8119,748,40774,31118,3,57,2,1880.67,NULL,'2023-01-19 10:48:56','2023-01-19 10:48:56',NULL),(2359,8119,749,40775,18805,2,96,2,5508.26,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2360,8119,749,40775,18805,2,67,2,1156.74,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2361,8119,749,40775,18805,2,13,1,6665.00,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2362,8119,750,40775,18805,2,96,2,11500.00,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2363,8119,750,40775,18805,2,67,2,2415.00,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2364,8119,750,40775,18805,2,13,1,13915.00,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2365,8119,751,40775,18805,2,96,2,47195.04,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2366,8119,751,40775,18805,2,67,2,9910.96,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2367,8119,751,40775,18805,2,13,1,57106.00,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2368,8119,752,40775,18805,2,96,2,161100.00,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2369,8119,752,40775,18805,2,67,2,33831.00,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2370,8119,752,40775,18805,2,13,1,194931.00,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2371,8119,753,40775,18805,2,96,2,82644.63,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2372,8119,753,40775,18805,2,67,2,17355.37,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2373,8119,753,40775,18805,2,13,1,100000.00,NULL,'2023-01-19 12:29:54','2023-01-19 12:29:54',NULL),(2374,8119,754,40775,18805,3,217,1,2851.24,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2375,8119,754,40775,18805,3,68,1,598.76,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2376,8119,754,40775,18805,3,57,2,3450.00,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2377,8119,755,40775,18805,3,217,1,4329.07,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2378,8119,755,40775,18805,3,68,1,909.10,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2379,8119,755,40775,18805,3,217,1,1044.18,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2380,8119,755,40775,18805,3,57,2,6282.35,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2381,8119,756,40775,18805,3,217,1,28098.35,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2382,8119,756,40775,18805,3,68,1,5900.65,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL);
INSERT INTO `balance_libro_details` VALUES (2383,8119,756,40775,18805,3,57,2,33999.00,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2384,8119,757,40775,18805,3,217,1,2791.74,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2385,8119,757,40775,18805,3,68,1,586.27,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2386,8119,757,40775,18805,3,217,1,707.34,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2387,8119,757,40775,18805,3,57,2,4085.35,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2388,8119,758,40775,18805,3,217,1,5588.36,NULL,'2023-01-19 12:30:01','2023-01-23 18:22:05','2023-01-23 18:22:05'),(2389,8119,758,40775,18805,3,68,1,1173.56,NULL,'2023-01-19 12:30:01','2023-01-23 18:22:05','2023-01-23 18:22:05'),(2390,8119,758,40775,18805,3,217,1,642.66,NULL,'2023-01-19 12:30:01','2023-01-23 18:22:05','2023-01-23 18:22:05'),(2391,8119,758,40775,18805,3,57,2,7404.58,NULL,'2023-01-19 12:30:01','2023-01-23 18:22:05','2023-01-23 18:22:05'),(2392,8119,759,40775,18805,3,250,1,40000.00,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2393,8119,759,40775,18805,3,57,2,40000.00,NULL,'2023-01-19 12:30:01','2023-01-19 12:30:01',NULL),(2394,8119,760,40775,18805,3,217,1,329.68,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2395,8119,760,40775,18805,3,68,1,69.23,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2396,8119,760,40775,18805,3,57,2,398.91,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2397,8119,761,40775,18805,3,217,1,51404.00,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2398,8119,761,40775,18805,3,68,1,10794.84,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2399,8119,761,40775,18805,3,57,2,62198.84,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2400,8119,762,40775,18805,3,217,1,82890.08,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2401,8119,762,40775,18805,3,68,1,17406.92,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2402,8119,762,40775,18805,3,57,2,100297.00,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2403,8119,763,40775,18805,3,217,1,84447.94,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2404,8119,763,40775,18805,3,68,1,17734.07,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2405,8119,763,40775,18805,3,57,2,102182.01,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2406,8119,764,40775,18805,3,217,1,965.74,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2407,8119,764,40775,18805,3,68,1,202.81,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2408,8119,764,40775,18805,3,57,2,1168.55,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2409,8119,765,40775,18805,3,217,2,118.10,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2410,8119,765,40775,18805,3,67,2,24.80,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2411,8119,765,40775,18805,3,57,1,142.90,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2412,8119,766,40775,18805,3,217,1,70578.52,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2413,8119,766,40775,18805,3,68,1,14821.49,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2414,8119,766,40775,18805,3,217,1,-0.01,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2415,8119,766,40775,18805,3,57,2,85400.00,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2416,8119,767,40775,18805,3,217,1,2678.02,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2417,8119,767,40775,18805,3,68,1,562.38,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2418,8119,767,40775,18805,3,57,2,3240.40,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2419,8119,768,40775,18805,3,250,1,33000.00,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2420,8119,768,40775,18805,3,57,2,33000.00,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2421,8119,769,40775,18805,3,217,1,4068.18,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2422,8119,769,40775,18805,3,68,1,854.32,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL);
INSERT INTO `balance_libro_details` VALUES (2423,8119,769,40775,18805,3,217,1,898.64,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2424,8119,769,40775,18805,3,57,2,5821.14,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2425,8119,770,40775,18805,3,217,1,5101.58,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2426,8119,770,40775,18805,3,68,1,1071.33,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2427,8119,770,40775,18805,3,217,1,771.33,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2428,8119,770,40775,18805,3,57,2,6944.24,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2429,8119,771,40775,18805,3,217,1,13591.35,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2430,8119,771,40775,18805,3,68,1,2854.18,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2431,8119,771,40775,18805,3,57,2,16445.53,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2432,8119,772,40775,18805,3,217,1,53002.24,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2433,8119,772,40775,18805,3,68,1,11130.47,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2434,8119,772,40775,18805,3,57,2,64132.71,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2435,8119,773,40775,18805,3,217,1,15367.31,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2436,8119,773,40775,18805,3,68,1,3227.14,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2437,8119,773,40775,18805,3,57,2,18594.45,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2438,8119,774,40775,18805,3,217,1,12417.60,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2439,8119,774,40775,18805,3,68,1,2607.70,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2440,8119,774,40775,18805,3,57,2,15025.30,NULL,'2023-01-19 12:30:02','2023-01-19 12:30:02',NULL),(2441,8119,775,40775,18805,3,217,1,902.48,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2442,8119,775,40775,18805,3,68,1,189.52,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2443,8119,775,40775,18805,3,57,2,1092.00,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2444,8119,776,40775,18805,3,217,1,46858.68,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2445,8119,776,40775,18805,3,68,1,9840.32,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2446,8119,776,40775,18805,3,57,2,56699.00,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2447,8119,777,40775,18805,3,217,1,851.84,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2448,8119,777,40775,18805,3,68,1,178.89,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2449,8119,777,40775,18805,3,57,2,1030.73,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2450,8119,778,40775,18805,3,217,1,10340.62,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2451,8119,778,40775,18805,3,68,1,2171.53,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2452,8119,778,40775,18805,3,57,2,12512.15,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2453,8119,779,40775,18805,3,217,2,84447.90,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2454,8119,779,40775,18805,3,67,2,17734.06,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2455,8119,779,40775,18805,3,57,1,102181.96,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2456,8119,780,40775,18805,3,217,1,358.79,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2457,8119,780,40775,18805,3,68,1,75.34,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2458,8119,780,40775,18805,3,57,2,434.13,NULL,'2023-01-19 12:30:03','2023-01-19 12:30:03',NULL),(2459,8119,781,40775,18805,3,217,1,3484.95,NULL,'2023-01-23 18:07:32','2023-01-23 18:07:32',NULL),(2460,8119,781,40775,18805,3,68,1,731.84,NULL,'2023-01-23 18:07:32','2023-01-23 18:07:32',NULL),(2461,8119,781,40775,18805,3,221,1,889.91,NULL,'2023-01-23 18:07:32','2023-01-23 18:07:32',NULL),(2462,8119,781,40775,18805,3,57,2,5106.70,NULL,'2023-01-23 18:07:32','2023-01-23 18:07:32',NULL),(2463,8119,782,40775,31294,15,353,1,57746.20,NULL,'2023-01-23 18:10:45','2023-01-23 18:10:45',NULL);
INSERT INTO `balance_libro_details` VALUES (2464,8119,782,40775,31294,15,354,1,685.25,NULL,'2023-01-23 18:10:45','2023-01-23 18:10:45',NULL),(2465,8119,782,40775,31294,15,136,2,58431.45,NULL,'2023-01-23 18:10:45','2023-01-23 18:10:45',NULL),(2466,8119,783,40775,18805,3,217,1,5588.36,NULL,'2023-01-23 18:22:05','2023-01-23 18:22:05',NULL),(2467,8119,783,40775,18805,3,68,1,1173.56,NULL,'2023-01-23 18:22:05','2023-01-23 18:22:05',NULL),(2468,8119,783,40775,18805,3,217,1,475.01,NULL,'2023-01-23 18:22:05','2023-01-23 18:22:05',NULL),(2469,8119,783,40775,18805,3,220,1,167.65,NULL,'2023-01-23 18:22:05','2023-01-23 18:22:05',NULL),(2470,8119,783,40775,18805,3,57,2,7404.58,NULL,'2023-01-23 18:22:05','2023-01-23 18:22:05',NULL),(2471,8119,784,40775,18805,7,25,1,333.56,NULL,'2023-01-23 18:24:32','2023-01-23 18:24:32',NULL),(2472,8119,784,40775,18805,7,13,2,333.56,NULL,'2023-01-23 18:24:32','2023-01-23 18:24:32',NULL),(2473,8119,785,40775,18805,15,67,1,82427.93,NULL,'2023-01-23 18:25:23','2023-01-23 18:25:23',NULL),(2474,8119,785,40775,18805,15,68,2,105692.66,NULL,'2023-01-23 18:25:23','2023-01-23 18:25:23',NULL),(2475,8119,785,40775,18805,15,353,2,57746.20,NULL,'2023-01-23 18:25:23','2023-01-23 18:25:23',NULL),(2476,8119,785,40775,18805,15,354,2,685.25,NULL,'2023-01-23 18:25:23','2023-01-23 18:25:23',NULL),(2477,8119,785,40775,18805,15,25,2,333.56,NULL,'2023-01-23 18:25:23','2023-01-23 18:25:23',NULL),(2478,8119,785,40775,18805,15,220,2,167.65,NULL,'2023-01-23 18:25:23','2023-01-23 18:25:23',NULL),(2479,8119,785,40775,18805,15,353,1,81010.93,NULL,'2023-01-23 18:25:23','2023-01-23 18:25:23',NULL),(2480,8119,785,40775,18805,15,354,1,1186.46,NULL,'2023-01-23 18:25:23','2023-01-23 18:25:23',NULL),(2481,8119,786,40883,31295,2,96,2,12403.31,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2482,8119,786,40883,31295,2,67,2,2604.69,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2483,8119,786,40883,31295,2,13,1,15008.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2484,8119,787,40883,31295,2,96,2,1855.37,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2485,8119,787,40883,31295,2,67,2,389.63,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2486,8119,787,40883,31295,2,13,1,2245.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2487,8119,788,40883,31295,2,96,2,11252.07,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2488,8119,788,40883,31295,2,67,2,2362.93,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2489,8119,788,40883,31295,2,13,1,13615.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2490,8119,789,40883,31295,2,96,2,1491.74,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2491,8119,789,40883,31295,2,67,2,313.26,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2492,8119,789,40883,31295,2,13,1,1805.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2493,8119,790,40883,31295,2,96,2,1876.03,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2494,8119,790,40883,31295,2,67,2,393.97,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2495,8119,790,40883,31295,2,13,1,2270.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2496,8119,791,40883,31295,2,96,2,2396.69,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2497,8119,791,40883,31295,2,67,2,503.31,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2498,8119,791,40883,31295,2,13,1,2900.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2499,8119,792,40883,31295,2,96,2,1570.25,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2500,8119,792,40883,31295,2,67,2,329.75,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2501,8119,792,40883,31295,2,13,1,1900.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2502,8119,793,40883,31295,2,96,2,1210.74,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2503,8119,793,40883,31295,2,67,2,254.26,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2504,8119,793,40883,31295,2,13,1,1465.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL);
INSERT INTO `balance_libro_details` VALUES (2505,8119,794,40883,31295,2,96,2,198.35,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2506,8119,794,40883,31295,2,67,2,41.65,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2507,8119,794,40883,31295,2,13,1,240.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2508,8119,795,40883,31295,2,96,2,545.45,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2509,8119,795,40883,31295,2,67,2,114.55,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2510,8119,795,40883,31295,2,13,1,660.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2511,8119,796,40883,31295,2,96,2,9053.72,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2512,8119,796,40883,31295,2,67,2,1901.28,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2513,8119,796,40883,31295,2,13,1,10955.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2514,8119,797,40883,31295,2,96,2,18971.07,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2515,8119,797,40883,31295,2,67,2,3983.93,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2516,8119,797,40883,31295,2,13,1,22955.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2517,8119,798,40883,31295,2,96,2,7570.25,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2518,8119,798,40883,31295,2,67,2,1589.75,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2519,8119,798,40883,31295,2,13,1,9160.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2520,8119,799,40883,31295,2,96,2,743.80,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2521,8119,799,40883,31295,2,67,2,156.20,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2522,8119,799,40883,31295,2,13,1,900.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2523,8119,800,40883,31295,2,96,2,826.45,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2524,8119,800,40883,31295,2,67,2,173.55,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2525,8119,800,40883,31295,2,13,1,1000.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2526,8119,801,40883,31295,2,96,2,396.69,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2527,8119,801,40883,31295,2,67,2,83.31,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2528,8119,801,40883,31295,2,13,1,480.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2529,8119,802,40883,31295,2,96,2,760.33,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2530,8119,802,40883,31295,2,67,2,159.67,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2531,8119,802,40883,31295,2,13,1,920.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2532,8119,803,40883,31295,2,96,2,4520.66,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2533,8119,803,40883,31295,2,67,2,949.34,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2534,8119,803,40883,31295,2,13,1,5470.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2535,8119,804,40883,31295,2,96,2,1702.48,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2536,8119,804,40883,31295,2,67,2,357.52,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2537,8119,804,40883,31295,2,13,1,2060.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2538,8119,805,40883,31295,2,96,2,7392.56,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2539,8119,805,40883,31295,2,67,2,1552.44,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2540,8119,805,40883,31295,2,13,1,8945.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2541,8119,806,40883,31295,2,96,2,925.62,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2542,8119,806,40883,31295,2,67,2,194.38,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2543,8119,806,40883,31295,2,13,1,1120.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2544,8119,807,40883,31295,2,96,2,12095.04,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2545,8119,807,40883,31295,2,67,2,2539.96,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL);
INSERT INTO `balance_libro_details` VALUES (2546,8119,807,40883,31295,2,13,1,14635.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2547,8119,808,40883,31295,2,96,2,2694.21,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2548,8119,808,40883,31295,2,67,2,565.79,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2549,8119,808,40883,31295,2,13,1,3260.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2550,8119,809,40883,31295,2,96,2,1210.74,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2551,8119,809,40883,31295,2,67,2,254.26,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2552,8119,809,40883,31295,2,13,1,1465.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2553,8119,810,40883,31295,2,96,2,657.02,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2554,8119,810,40883,31295,2,67,2,137.98,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2555,8119,810,40883,31295,2,13,1,795.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2556,8119,811,40883,31295,2,96,2,2632.23,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2557,8119,811,40883,31295,2,67,2,552.77,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2558,8119,811,40883,31295,2,13,1,3185.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2559,8119,812,40883,31295,2,96,2,1780.99,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2560,8119,812,40883,31295,2,67,2,374.01,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2561,8119,812,40883,31295,2,13,1,2155.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2562,8119,813,40883,31295,2,96,2,289.26,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2563,8119,813,40883,31295,2,67,2,60.74,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2564,8119,813,40883,31295,2,13,1,350.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2565,8119,814,40883,31295,2,96,2,4198.35,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2566,8119,814,40883,31295,2,67,2,881.65,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2567,8119,814,40883,31295,2,13,1,5080.00,NULL,'2023-02-15 15:20:47','2023-02-15 15:20:47',NULL),(2568,8119,815,40883,31295,2,96,2,520.66,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2569,8119,815,40883,31295,2,67,2,109.34,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2570,8119,815,40883,31295,2,13,1,630.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2571,8119,816,40883,31295,2,96,2,4164.46,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2572,8119,816,40883,31295,2,67,2,874.54,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2573,8119,816,40883,31295,2,13,1,5039.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2574,8119,817,40883,31295,2,96,2,16685.95,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2575,8119,817,40883,31295,2,67,2,3504.05,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2576,8119,817,40883,31295,2,13,1,20190.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2577,8119,818,40883,31295,2,96,2,2855.37,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2578,8119,818,40883,31295,2,67,2,599.63,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2579,8119,818,40883,31295,2,13,1,3455.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2580,8119,819,40883,31295,2,96,2,1578.51,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2581,8119,819,40883,31295,2,67,2,331.49,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2582,8119,819,40883,31295,2,13,1,1910.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2583,8119,820,40883,31295,2,96,2,3619.83,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2584,8119,820,40883,31295,2,67,2,760.17,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2585,8119,820,40883,31295,2,13,1,4380.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2586,8119,821,40883,31295,2,96,2,1805.79,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL);
INSERT INTO `balance_libro_details` VALUES (2587,8119,821,40883,31295,2,67,2,379.21,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2588,8119,821,40883,31295,2,13,1,2185.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2589,8119,822,40883,31295,2,96,2,7198.35,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2590,8119,822,40883,31295,2,67,2,1511.65,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2591,8119,822,40883,31295,2,13,1,8710.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2592,8119,823,40883,31295,2,96,2,4830.58,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2593,8119,823,40883,31295,2,67,2,1014.42,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2594,8119,823,40883,31295,2,13,1,5845.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2595,8119,824,40883,31295,2,96,2,7756.20,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2596,8119,824,40883,31295,2,67,2,1628.80,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2597,8119,824,40883,31295,2,13,1,9385.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2598,8119,825,40883,31295,2,96,2,1863.64,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2599,8119,825,40883,31295,2,67,2,391.36,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2600,8119,825,40883,31295,2,13,1,2255.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2601,8119,826,40883,31295,2,96,2,355.37,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2602,8119,826,40883,31295,2,67,2,74.63,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2603,8119,826,40883,31295,2,13,1,430.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2604,8119,827,40883,31295,2,96,2,198.35,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2605,8119,827,40883,31295,2,67,2,41.65,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2606,8119,827,40883,31295,2,13,1,240.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2607,8119,828,40883,31295,2,96,2,669.42,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2608,8119,828,40883,31295,2,67,2,140.58,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2609,8119,828,40883,31295,2,13,1,810.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2610,8119,829,40883,31295,2,96,2,1099.17,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2611,8119,829,40883,31295,2,67,2,230.83,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2612,8119,829,40883,31295,2,13,1,1330.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2613,8119,830,40883,31295,2,96,2,809.92,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2614,8119,830,40883,31295,2,67,2,170.08,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2615,8119,830,40883,31295,2,13,1,980.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2616,8119,831,40883,31295,2,96,2,2743.80,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2617,8119,831,40883,31295,2,67,2,576.20,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2618,8119,831,40883,31295,2,13,1,3320.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2619,8119,832,40883,31295,2,96,2,289.26,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2620,8119,832,40883,31295,2,67,2,60.74,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2621,8119,832,40883,31295,2,13,1,350.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2622,8119,833,40883,31295,2,96,2,396.69,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2623,8119,833,40883,31295,2,67,2,83.31,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2624,8119,833,40883,31295,2,13,1,480.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2625,8119,834,40883,31295,2,96,2,2772.73,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2626,8119,834,40883,31295,2,67,2,582.27,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2627,8119,834,40883,31295,2,13,1,3355.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL);
INSERT INTO `balance_libro_details` VALUES (2628,8119,835,40883,31295,2,96,2,338.84,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2629,8119,835,40883,31295,2,67,2,71.16,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2630,8119,835,40883,31295,2,13,1,410.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2631,8119,836,40883,31295,2,96,2,1099.17,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2632,8119,836,40883,31295,2,67,2,230.83,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2633,8119,836,40883,31295,2,13,1,1330.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2634,8119,837,40883,31295,2,96,2,2132.23,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2635,8119,837,40883,31295,2,67,2,447.77,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2636,8119,837,40883,31295,2,13,1,2580.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2637,8119,838,40883,31295,2,96,2,4950.41,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2638,8119,838,40883,31295,2,67,2,1039.59,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2639,8119,838,40883,31295,2,13,1,5990.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2640,8119,839,40883,31295,2,96,2,347.11,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2641,8119,839,40883,31295,2,67,2,72.89,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2642,8119,839,40883,31295,2,13,1,420.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2643,8119,840,40883,31295,2,96,2,3409.09,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2644,8119,840,40883,31295,2,67,2,715.91,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2645,8119,840,40883,31295,2,13,1,4125.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2646,8119,841,40883,31295,2,96,2,239.67,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2647,8119,841,40883,31295,2,67,2,50.33,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2648,8119,841,40883,31295,2,13,1,290.00,NULL,'2023-02-15 15:20:48','2023-02-15 15:20:48',NULL),(2649,8119,842,40883,31295,2,96,2,5622.31,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2650,8119,842,40883,31295,2,67,2,1180.69,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2651,8119,842,40883,31295,2,13,1,6803.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2652,8119,843,40883,31295,2,96,2,8700.83,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2653,8119,843,40883,31295,2,67,2,1827.17,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2654,8119,843,40883,31295,2,13,1,10528.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2655,8119,844,40883,31295,2,96,2,1900.83,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2656,8119,844,40883,31295,2,67,2,399.17,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2657,8119,844,40883,31295,2,13,1,2300.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2658,8119,845,40883,31295,2,96,2,5297.52,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2659,8119,845,40883,31295,2,67,2,1112.48,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2660,8119,845,40883,31295,2,13,1,6410.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2661,8119,846,40883,31295,2,96,2,1057.85,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2662,8119,846,40883,31295,2,67,2,222.15,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2663,8119,846,40883,31295,2,13,1,1280.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2664,8119,847,40883,31295,2,96,2,8379.34,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2665,8119,847,40883,31295,2,67,2,1759.66,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2666,8119,847,40883,31295,2,13,1,10139.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2667,8119,848,40883,31295,2,96,2,2078.51,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2668,8119,848,40883,31295,2,67,2,436.49,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL);
INSERT INTO `balance_libro_details` VALUES (2669,8119,848,40883,31295,2,13,1,2515.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2670,8119,849,40883,31295,2,96,2,1421.49,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2671,8119,849,40883,31295,2,67,2,298.51,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2672,8119,849,40883,31295,2,13,1,1720.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2673,8119,850,40883,31295,2,96,2,2157.02,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2674,8119,850,40883,31295,2,67,2,452.98,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2675,8119,850,40883,31295,2,13,1,2610.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2676,8119,851,40883,31295,2,96,2,1210.74,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2677,8119,851,40883,31295,2,67,2,254.26,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2678,8119,851,40883,31295,2,13,1,1465.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2679,8119,852,40883,31295,2,96,2,1632.23,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2680,8119,852,40883,31295,2,67,2,342.77,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2681,8119,852,40883,31295,2,13,1,1975.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2682,8119,853,40883,31295,2,96,2,814.05,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2683,8119,853,40883,31295,2,67,2,170.95,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2684,8119,853,40883,31295,2,13,1,985.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2685,8119,854,40883,31295,2,96,2,4809.92,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2686,8119,854,40883,31295,2,67,2,1010.08,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2687,8119,854,40883,31295,2,13,1,5820.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2688,8119,855,40883,31295,2,96,2,607.44,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2689,8119,855,40883,31295,2,67,2,127.56,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2690,8119,855,40883,31295,2,13,1,735.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2691,8119,856,40883,31295,2,96,2,7318.18,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2692,8119,856,40883,31295,2,67,2,1536.82,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2693,8119,856,40883,31295,2,13,1,8855.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2694,8119,857,40883,31295,2,96,2,7223.14,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2695,8119,857,40883,31295,2,67,2,1516.86,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2696,8119,857,40883,31295,2,13,1,8740.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2697,8119,858,40883,31295,2,96,2,1000.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2698,8119,858,40883,31295,2,67,2,210.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2699,8119,858,40883,31295,2,13,1,1210.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2700,8119,859,40883,31295,2,96,2,347.11,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2701,8119,859,40883,31295,2,67,2,72.89,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2702,8119,859,40883,31295,2,13,1,420.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2703,8119,860,40883,31295,2,96,2,17462.81,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2704,8119,860,40883,31295,2,67,2,3667.19,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2705,8119,860,40883,31295,2,13,1,21130.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2706,8119,861,40883,31295,2,96,2,198.35,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2707,8119,861,40883,31295,2,67,2,41.65,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2708,8119,861,40883,31295,2,13,1,240.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2709,8119,862,40883,31295,2,96,2,669.42,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL);
INSERT INTO `balance_libro_details` VALUES (2710,8119,862,40883,31295,2,67,2,140.58,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2711,8119,862,40883,31295,2,13,1,810.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2712,8119,863,40883,31295,2,96,2,2438.02,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2713,8119,863,40883,31295,2,67,2,511.98,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2714,8119,863,40883,31295,2,13,1,2950.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2715,8119,864,40883,31295,2,96,2,566.12,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2716,8119,864,40883,31295,2,67,2,118.88,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2717,8119,864,40883,31295,2,13,1,685.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2718,8119,865,40883,31295,2,96,2,2690.08,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2719,8119,865,40883,31295,2,67,2,564.92,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2720,8119,865,40883,31295,2,13,1,3255.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2721,8119,866,40883,31295,2,96,2,1219.01,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2722,8119,866,40883,31295,2,67,2,255.99,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2723,8119,866,40883,31295,2,13,1,1475.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2724,8119,867,40883,31295,2,96,2,4471.07,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2725,8119,867,40883,31295,2,67,2,938.93,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2726,8119,867,40883,31295,2,13,1,5410.00,NULL,'2023-02-15 15:20:49','2023-02-15 15:20:49',NULL),(2727,8119,868,40883,31295,2,96,2,3677.69,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2728,8119,868,40883,31295,2,67,2,772.31,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2729,8119,868,40883,31295,2,13,1,4450.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2730,8119,869,40883,31295,2,96,2,1863.64,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2731,8119,869,40883,31295,2,67,2,391.36,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2732,8119,869,40883,31295,2,13,1,2255.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2733,8119,870,40883,31295,2,96,2,14669.42,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2734,8119,870,40883,31295,2,67,2,3080.58,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2735,8119,870,40883,31295,2,13,1,17750.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2736,8119,871,40883,31295,2,96,2,3718.18,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2737,8119,871,40883,31295,2,67,2,780.82,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2738,8119,871,40883,31295,2,13,1,4499.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2739,8119,872,40883,31295,2,96,2,5012.40,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2740,8119,872,40883,31295,2,67,2,1052.60,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2741,8119,872,40883,31295,2,13,1,6065.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2742,8119,873,40883,31295,2,96,2,330.58,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2743,8119,873,40883,31295,2,67,2,69.42,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2744,8119,873,40883,31295,2,13,1,400.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2745,8119,874,40883,31295,2,96,2,3590.91,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2746,8119,874,40883,31295,2,67,2,754.09,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2747,8119,874,40883,31295,2,13,1,4345.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2748,8119,875,40883,31295,2,96,2,2238.02,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2749,8119,875,40883,31295,2,67,2,469.98,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2750,8119,875,40883,31295,2,13,1,2708.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL);
INSERT INTO `balance_libro_details` VALUES (2751,8119,876,40883,31295,2,96,2,1061.98,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2752,8119,876,40883,31295,2,67,2,223.02,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2753,8119,876,40883,31295,2,13,1,1285.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2754,8119,877,40883,31295,2,96,2,396.69,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2755,8119,877,40883,31295,2,67,2,83.31,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2756,8119,877,40883,31295,2,13,1,480.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2757,8119,878,40883,31295,2,96,2,504.13,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2758,8119,878,40883,31295,2,67,2,105.87,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2759,8119,878,40883,31295,2,13,1,610.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2760,8119,879,40883,31295,2,96,2,1933.06,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2761,8119,879,40883,31295,2,67,2,405.94,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2762,8119,879,40883,31295,2,13,1,2339.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2763,8119,880,40883,31295,2,96,2,2446.28,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2764,8119,880,40883,31295,2,67,2,513.72,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2765,8119,880,40883,31295,2,13,1,2960.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2766,8119,881,40883,31295,2,96,2,710.74,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2767,8119,881,40883,31295,2,67,2,149.26,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2768,8119,881,40883,31295,2,13,1,860.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2769,8119,882,40883,31295,2,96,2,888.43,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2770,8119,882,40883,31295,2,67,2,186.57,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2771,8119,882,40883,31295,2,13,1,1075.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2772,8119,883,40883,31295,2,96,2,1231.40,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2773,8119,883,40883,31295,2,67,2,258.60,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2774,8119,883,40883,31295,2,13,1,1490.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2775,8119,884,40883,31295,2,96,2,2033.06,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2776,8119,884,40883,31295,2,67,2,426.94,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2777,8119,884,40883,31295,2,13,1,2460.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2778,8119,885,40883,31295,2,96,2,1008.26,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2779,8119,885,40883,31295,2,67,2,211.74,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2780,8119,885,40883,31295,2,13,1,1220.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2781,8119,886,40883,31295,2,96,2,776.86,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2782,8119,886,40883,31295,2,67,2,163.14,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2783,8119,886,40883,31295,2,13,1,940.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2784,8119,887,40883,31295,2,96,2,776.86,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2785,8119,887,40883,31295,2,67,2,163.14,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2786,8119,887,40883,31295,2,13,1,940.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2787,8119,888,40883,31295,2,96,2,776.86,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2788,8119,888,40883,31295,2,67,2,163.14,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2789,8119,888,40883,31295,2,13,1,940.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2790,8119,889,40883,31295,2,96,2,330.58,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2791,8119,889,40883,31295,2,67,2,69.42,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL);
INSERT INTO `balance_libro_details` VALUES (2792,8119,889,40883,31295,2,13,1,400.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2793,8119,890,40883,31295,2,96,2,826.45,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2794,8119,890,40883,31295,2,67,2,173.55,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2795,8119,890,40883,31295,2,13,1,1000.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2796,8119,891,40883,31295,2,96,2,776.86,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2797,8119,891,40883,31295,2,67,2,163.14,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2798,8119,891,40883,31295,2,13,1,940.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2799,8119,892,40883,31295,2,96,2,739.67,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2800,8119,892,40883,31295,2,67,2,155.33,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2801,8119,892,40883,31295,2,13,1,895.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2802,8119,893,40883,31295,2,96,2,2066.12,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2803,8119,893,40883,31295,2,67,2,433.88,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2804,8119,893,40883,31295,2,13,1,2500.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2805,8119,894,40883,31295,2,96,2,6313.22,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2806,8119,894,40883,31295,2,67,2,1325.78,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2807,8119,894,40883,31295,2,13,1,7639.00,NULL,'2023-02-15 15:20:50','2023-02-15 15:20:50',NULL),(2808,8119,895,40883,31295,2,96,2,1719.01,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2809,8119,895,40883,31295,2,67,2,360.99,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2810,8119,895,40883,31295,2,13,1,2080.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2811,8119,896,40883,31295,2,96,2,8582.64,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2812,8119,896,40883,31295,2,67,2,1802.36,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2813,8119,896,40883,31295,2,13,1,10385.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2814,8119,897,40883,31295,2,96,2,1714.88,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2815,8119,897,40883,31295,2,67,2,360.12,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2816,8119,897,40883,31295,2,13,1,2075.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2817,8119,898,40883,31295,2,96,2,1917.36,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2818,8119,898,40883,31295,2,67,2,402.64,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2819,8119,898,40883,31295,2,13,1,2320.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2820,8119,899,40883,31295,2,96,2,7524.79,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2821,8119,899,40883,31295,2,67,2,1580.21,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2822,8119,899,40883,31295,2,13,1,9105.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2823,8119,900,40883,31295,2,96,2,3537.19,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2824,8119,900,40883,31295,2,67,2,742.81,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2825,8119,900,40883,31295,2,13,1,4280.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2826,8119,901,40883,31295,2,96,2,623.97,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2827,8119,901,40883,31295,2,67,2,131.03,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2828,8119,901,40883,31295,2,13,1,755.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2829,8119,902,40883,31295,2,96,2,1223.14,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2830,8119,902,40883,31295,2,67,2,256.86,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2831,8119,902,40883,31295,2,13,1,1480.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2832,8119,903,40883,31295,2,96,2,7950.41,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL);
INSERT INTO `balance_libro_details` VALUES (2833,8119,903,40883,31295,2,67,2,1669.59,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2834,8119,903,40883,31295,2,13,1,9620.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2835,8119,904,40883,31295,2,96,2,1157.02,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2836,8119,904,40883,31295,2,67,2,242.98,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2837,8119,904,40883,31295,2,13,1,1400.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2838,8119,905,40883,31295,2,96,2,264.46,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2839,8119,905,40883,31295,2,67,2,55.54,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2840,8119,905,40883,31295,2,13,1,320.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2841,8119,906,40883,31295,2,96,2,1070.25,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2842,8119,906,40883,31295,2,67,2,224.75,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2843,8119,906,40883,31295,2,13,1,1295.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2844,8119,907,40883,31295,2,96,2,19603.31,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2845,8119,907,40883,31295,2,67,2,4116.69,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2846,8119,907,40883,31295,2,13,1,23720.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2847,8119,908,40883,31295,2,96,2,590.91,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2848,8119,908,40883,31295,2,67,2,124.09,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2849,8119,908,40883,31295,2,13,1,715.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2850,8119,909,40883,31295,2,96,2,727.27,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2851,8119,909,40883,31295,2,67,2,152.73,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2852,8119,909,40883,31295,2,13,1,880.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2853,8119,910,40883,31295,2,96,2,5321.49,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2854,8119,910,40883,31295,2,67,2,1117.51,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2855,8119,910,40883,31295,2,13,1,6439.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2856,8119,911,40883,31295,2,96,2,1289.26,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2857,8119,911,40883,31295,2,67,2,270.74,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2858,8119,911,40883,31295,2,13,1,1560.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2859,8119,912,40883,31295,2,96,2,1219.01,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2860,8119,912,40883,31295,2,67,2,255.99,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2861,8119,912,40883,31295,2,13,1,1475.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2862,8119,913,40883,31295,2,96,2,3905.79,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2863,8119,913,40883,31295,2,67,2,820.21,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2864,8119,913,40883,31295,2,13,1,4726.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2865,8119,914,40883,31295,2,96,2,3905.79,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2866,8119,914,40883,31295,2,67,2,820.21,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2867,8119,914,40883,31295,2,13,1,4726.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2868,8119,915,40883,31295,2,96,2,1524.79,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2869,8119,915,40883,31295,2,67,2,320.21,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2870,8119,915,40883,31295,2,13,1,1845.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2871,8119,916,40883,31295,2,96,2,11623.97,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2872,8119,916,40883,31295,2,67,2,2441.03,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2873,8119,916,40883,31295,2,13,1,14065.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL);
INSERT INTO `balance_libro_details` VALUES (2874,8119,917,40883,31295,2,96,2,9526.45,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2875,8119,917,40883,31295,2,67,2,2000.55,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2876,8119,917,40883,31295,2,13,1,11527.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2877,8119,918,40883,31295,2,96,2,6231.40,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2878,8119,918,40883,31295,2,67,2,1308.60,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2879,8119,918,40883,31295,2,13,1,7540.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2880,8119,919,40883,31295,2,96,2,13223.14,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2881,8119,919,40883,31295,2,67,2,2776.86,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2882,8119,919,40883,31295,2,13,1,16000.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2883,8119,920,40883,31295,2,96,2,809.92,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2884,8119,920,40883,31295,2,67,2,170.08,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2885,8119,920,40883,31295,2,13,1,980.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2886,8119,921,40883,31295,2,96,2,1551.24,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2887,8119,921,40883,31295,2,67,2,325.76,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2888,8119,921,40883,31295,2,13,1,1877.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2889,8119,922,40883,31295,2,96,2,1855.37,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2890,8119,922,40883,31295,2,67,2,389.63,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2891,8119,922,40883,31295,2,13,1,2245.00,NULL,'2023-02-15 15:20:51','2023-02-15 15:20:51',NULL),(2892,8119,923,40883,31295,2,96,2,2140.50,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2893,8119,923,40883,31295,2,67,2,449.50,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2894,8119,923,40883,31295,2,13,1,2590.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2895,8119,924,40883,31295,2,96,2,6780.99,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2896,8119,924,40883,31295,2,67,2,1424.01,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2897,8119,924,40883,31295,2,13,1,8205.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2898,8119,925,40883,31295,2,96,2,14095.04,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2899,8119,925,40883,31295,2,67,2,2959.96,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2900,8119,925,40883,31295,2,13,1,17055.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2901,8119,926,40883,31295,2,96,2,1289.26,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2902,8119,926,40883,31295,2,67,2,270.74,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2903,8119,926,40883,31295,2,13,1,1560.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2904,8119,927,40883,31295,2,96,2,305.79,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2905,8119,927,40883,31295,2,67,2,64.21,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2906,8119,927,40883,31295,2,13,1,370.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2907,8119,928,40883,31295,2,96,2,566.12,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2908,8119,928,40883,31295,2,67,2,118.88,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2909,8119,928,40883,31295,2,13,1,685.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2910,8119,929,40883,31295,2,96,2,8552.89,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2911,8119,929,40883,31295,2,67,2,1796.11,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2912,8119,929,40883,31295,2,13,1,10349.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2913,8119,930,40883,31295,2,96,2,504.13,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2914,8119,930,40883,31295,2,67,2,105.87,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL);
INSERT INTO `balance_libro_details` VALUES (2915,8119,930,40883,31295,2,13,1,610.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2916,8119,931,40883,31295,2,96,2,685.95,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2917,8119,931,40883,31295,2,67,2,144.05,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2918,8119,931,40883,31295,2,13,1,830.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2919,8119,932,40883,31295,2,96,2,520.66,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2920,8119,932,40883,31295,2,67,2,109.34,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2921,8119,932,40883,31295,2,13,1,630.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2922,8119,933,40883,31295,2,96,2,3169.42,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2923,8119,933,40883,31295,2,67,2,665.58,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2924,8119,933,40883,31295,2,13,1,3835.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2925,8119,934,40883,31295,2,96,2,685.95,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2926,8119,934,40883,31295,2,67,2,144.05,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2927,8119,934,40883,31295,2,13,1,830.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2928,8119,935,40883,31295,2,96,2,867.77,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2929,8119,935,40883,31295,2,67,2,182.23,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2930,8119,935,40883,31295,2,13,1,1050.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2931,8119,936,40883,31295,2,96,2,355.37,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2932,8119,936,40883,31295,2,67,2,74.63,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2933,8119,936,40883,31295,2,13,1,430.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2934,8119,937,40883,31295,2,96,2,355.37,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2935,8119,937,40883,31295,2,67,2,74.63,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2936,8119,937,40883,31295,2,13,1,430.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2937,8119,938,40883,31295,2,96,2,838.84,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2938,8119,938,40883,31295,2,67,2,176.16,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2939,8119,938,40883,31295,2,13,1,1015.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2940,8119,939,40883,31295,2,96,2,1152.89,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2941,8119,939,40883,31295,2,67,2,242.11,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2942,8119,939,40883,31295,2,13,1,1395.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2943,8119,940,40883,31295,2,96,2,1128.10,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2944,8119,940,40883,31295,2,67,2,236.90,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2945,8119,940,40883,31295,2,13,1,1365.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2946,8119,941,40883,31295,2,96,2,3677.69,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2947,8119,941,40883,31295,2,67,2,772.31,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2948,8119,941,40883,31295,2,13,1,4450.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2949,8119,942,40883,31295,2,96,2,512.40,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2950,8119,942,40883,31295,2,67,2,107.60,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2951,8119,942,40883,31295,2,13,1,620.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2952,8119,943,40883,31295,2,96,2,2566.94,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2953,8119,943,40883,31295,2,67,2,539.06,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2954,8119,943,40883,31295,2,13,1,3106.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2955,8119,944,40883,31295,2,96,2,1351.24,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL);
INSERT INTO `balance_libro_details` VALUES (2956,8119,944,40883,31295,2,67,2,283.76,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2957,8119,944,40883,31295,2,13,1,1635.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2958,8119,945,40883,31295,2,96,2,1351.24,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2959,8119,945,40883,31295,2,67,2,283.76,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2960,8119,945,40883,31295,2,13,1,1635.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2961,8119,946,40883,31295,2,96,2,2867.77,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2962,8119,946,40883,31295,2,67,2,602.23,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2963,8119,946,40883,31295,2,13,1,3470.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2964,8119,947,40883,31295,2,96,2,5041.32,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2965,8119,947,40883,31295,2,67,2,1058.68,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2966,8119,947,40883,31295,2,13,1,6100.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2967,8119,948,40883,31295,2,96,2,892.56,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2968,8119,948,40883,31295,2,67,2,187.44,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2969,8119,948,40883,31295,2,13,1,1080.00,NULL,'2023-02-15 15:20:52','2023-02-15 15:20:52',NULL),(2970,8119,949,40883,31295,2,96,2,2157.02,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2971,8119,949,40883,31295,2,67,2,452.98,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2972,8119,949,40883,31295,2,13,1,2610.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2973,8119,950,40883,31295,2,96,2,2739.67,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2974,8119,950,40883,31295,2,67,2,575.33,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2975,8119,950,40883,31295,2,13,1,3315.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2976,8119,951,40883,31295,2,96,2,710.74,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2977,8119,951,40883,31295,2,67,2,149.26,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2978,8119,951,40883,31295,2,13,1,860.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2979,8119,952,40883,31295,2,96,2,14710.74,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2980,8119,952,40883,31295,2,67,2,3089.26,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2981,8119,952,40883,31295,2,13,1,17800.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2982,8119,953,40883,31295,2,96,2,814.05,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2983,8119,953,40883,31295,2,67,2,170.95,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2984,8119,953,40883,31295,2,13,1,985.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2985,8119,954,40883,31295,2,96,2,814.05,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2986,8119,954,40883,31295,2,67,2,170.95,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2987,8119,954,40883,31295,2,13,1,985.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2988,8119,955,40883,31295,2,96,2,4958.68,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2989,8119,955,40883,31295,2,67,2,1041.32,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2990,8119,955,40883,31295,2,13,1,6000.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2991,8119,956,40883,31295,2,96,2,809.92,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2992,8119,956,40883,31295,2,67,2,170.08,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2993,8119,956,40883,31295,2,13,1,980.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2994,8119,957,40883,31295,2,96,2,9519.83,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2995,8119,957,40883,31295,2,67,2,1999.17,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2996,8119,957,40883,31295,2,13,1,11519.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL);
INSERT INTO `balance_libro_details` VALUES (2997,8119,958,40883,31295,2,96,2,330.58,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2998,8119,958,40883,31295,2,67,2,69.42,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(2999,8119,958,40883,31295,2,13,1,400.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3000,8119,959,40883,31295,2,96,2,22793.39,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3001,8119,959,40883,31295,2,67,2,4786.61,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3002,8119,959,40883,31295,2,13,1,27580.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3003,8119,960,40883,31295,2,96,2,5361.98,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3004,8119,960,40883,31295,2,67,2,1126.02,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3005,8119,960,40883,31295,2,13,1,6488.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3006,8119,961,40883,31295,2,96,2,611.57,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3007,8119,961,40883,31295,2,67,2,128.43,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3008,8119,961,40883,31295,2,13,1,740.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3009,8119,962,40883,31295,2,96,2,615.70,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3010,8119,962,40883,31295,2,67,2,129.30,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3011,8119,962,40883,31295,2,13,1,745.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3012,8119,963,40883,31295,2,96,2,1859.50,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3013,8119,963,40883,31295,2,67,2,390.50,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3014,8119,963,40883,31295,2,13,1,2250.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3015,8119,964,40883,31295,2,96,2,380.17,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3016,8119,964,40883,31295,2,67,2,79.83,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3017,8119,964,40883,31295,2,13,1,460.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3018,8119,965,40883,31295,2,96,2,561.98,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3019,8119,965,40883,31295,2,67,2,118.02,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3020,8119,965,40883,31295,2,13,1,680.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3021,8119,966,40883,31295,2,96,2,1743.80,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3022,8119,966,40883,31295,2,67,2,366.20,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3023,8119,966,40883,31295,2,13,1,2110.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3024,8119,967,40883,31295,2,96,2,1954.55,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3025,8119,967,40883,31295,2,67,2,410.45,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3026,8119,967,40883,31295,2,13,1,2365.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3027,8119,968,40883,31295,2,96,2,809.92,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3028,8119,968,40883,31295,2,67,2,170.08,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3029,8119,968,40883,31295,2,13,1,980.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3030,8119,969,40883,31295,2,96,2,5710.74,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3031,8119,969,40883,31295,2,67,2,1199.26,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3032,8119,969,40883,31295,2,13,1,6910.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3033,8119,970,40883,31295,2,96,2,3260.33,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3034,8119,970,40883,31295,2,67,2,684.67,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3035,8119,970,40883,31295,2,13,1,3945.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3036,8119,971,40883,31295,2,96,2,1937.19,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3037,8119,971,40883,31295,2,67,2,406.81,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL);
INSERT INTO `balance_libro_details` VALUES (3038,8119,971,40883,31295,2,13,1,2344.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3039,8119,972,40883,31295,2,96,2,5491.74,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3040,8119,972,40883,31295,2,67,2,1153.26,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3041,8119,972,40883,31295,2,13,1,6645.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3042,8119,973,40883,31295,2,96,2,2172.73,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3043,8119,973,40883,31295,2,67,2,456.27,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3044,8119,973,40883,31295,2,13,1,2629.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3045,8119,974,40883,31295,2,96,2,2132.23,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3046,8119,974,40883,31295,2,67,2,447.77,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3047,8119,974,40883,31295,2,13,1,2580.00,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3048,8119,975,40883,31295,2,96,2,12396.69,NULL,'2023-02-15 15:20:53','2023-02-15 15:20:53',NULL),(3049,8119,975,40883,31295,2,67,2,2603.31,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3050,8119,975,40883,31295,2,13,1,15000.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3051,8119,976,40883,31295,2,96,2,586.78,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3052,8119,976,40883,31295,2,67,2,123.22,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3053,8119,976,40883,31295,2,13,1,710.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3054,8119,977,40883,31295,2,96,2,7756.20,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3055,8119,977,40883,31295,2,67,2,1628.80,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3056,8119,977,40883,31295,2,13,1,9385.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3057,8119,978,40883,31295,2,96,2,2483.47,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3058,8119,978,40883,31295,2,67,2,521.53,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3059,8119,978,40883,31295,2,13,1,3005.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3060,8119,979,40883,31295,2,96,2,2880.17,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3061,8119,979,40883,31295,2,67,2,604.83,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3062,8119,979,40883,31295,2,13,1,3485.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3063,8119,980,40883,31295,2,96,2,396.69,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3064,8119,980,40883,31295,2,67,2,83.31,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3065,8119,980,40883,31295,2,13,1,480.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3066,8119,981,40883,31295,2,96,2,2400.83,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3067,8119,981,40883,31295,2,67,2,504.17,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3068,8119,981,40883,31295,2,13,1,2905.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3069,8119,982,40883,31295,2,96,2,1731.40,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3070,8119,982,40883,31295,2,67,2,363.60,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3071,8119,982,40883,31295,2,13,1,2095.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3072,8119,983,40883,31295,2,96,2,11157.02,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3073,8119,983,40883,31295,2,67,2,2342.98,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3074,8119,983,40883,31295,2,13,1,13500.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3075,8119,984,40883,31295,2,96,2,8384.30,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3076,8119,984,40883,31295,2,67,2,1760.70,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3077,8119,984,40883,31295,2,13,1,10145.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3078,8119,985,40883,31295,2,96,2,7756.20,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL);
INSERT INTO `balance_libro_details` VALUES (3079,8119,985,40883,31295,2,67,2,1628.80,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3080,8119,985,40883,31295,2,13,1,9385.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3081,8119,986,40883,31295,2,96,2,3458.68,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3082,8119,986,40883,31295,2,67,2,726.32,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3083,8119,986,40883,31295,2,13,1,4185.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3084,8119,987,40883,31295,2,96,2,4640.50,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3085,8119,987,40883,31295,2,67,2,974.50,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3086,8119,987,40883,31295,2,13,1,5615.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3087,8119,988,40883,31295,2,96,2,11239.67,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3088,8119,988,40883,31295,2,67,2,2360.33,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3089,8119,988,40883,31295,2,13,1,13600.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3090,8119,989,40883,31295,2,96,2,17768.60,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3091,8119,989,40883,31295,2,67,2,3731.40,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3092,8119,989,40883,31295,2,13,1,21500.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3093,8119,990,40883,31295,2,96,2,13966.94,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3094,8119,990,40883,31295,2,67,2,2933.06,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3095,8119,990,40883,31295,2,13,1,16900.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3096,8119,991,40883,31295,2,96,2,19504.13,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3097,8119,991,40883,31295,2,67,2,4095.87,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3098,8119,991,40883,31295,2,13,1,23600.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3099,8119,992,40883,31295,2,96,2,12231.40,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3100,8119,992,40883,31295,2,67,2,2568.60,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3101,8119,992,40883,31295,2,13,1,14800.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3102,8119,993,40883,31295,2,96,2,16181.82,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3103,8119,993,40883,31295,2,67,2,3398.18,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3104,8119,993,40883,31295,2,13,1,19580.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3105,8119,994,40883,31295,2,96,2,13429.75,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3106,8119,994,40883,31295,2,67,2,2820.25,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3107,8119,994,40883,31295,2,13,1,16250.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3108,8119,995,40883,31295,2,96,2,12049.59,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3109,8119,995,40883,31295,2,67,2,2530.41,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3110,8119,995,40883,31295,2,13,1,14580.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3111,8119,996,40883,31295,2,96,2,11280.99,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3112,8119,996,40883,31295,2,67,2,2369.01,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3113,8119,996,40883,31295,2,13,1,13650.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3114,8119,997,40883,31295,2,96,2,14876.03,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3115,8119,997,40883,31295,2,67,2,3123.97,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3116,8119,997,40883,31295,2,13,1,18000.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3117,8119,998,40883,31295,2,96,2,16198.35,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3118,8119,998,40883,31295,2,67,2,3401.65,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3119,8119,998,40883,31295,2,13,1,19600.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL);
INSERT INTO `balance_libro_details` VALUES (3120,8119,999,40883,31295,2,96,2,16528.93,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3121,8119,999,40883,31295,2,67,2,3471.07,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3122,8119,999,40883,31295,2,13,1,20000.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3123,8119,1000,40883,31295,2,96,2,19090.91,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3124,8119,1000,40883,31295,2,67,2,4009.09,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3125,8119,1000,40883,31295,2,13,1,23100.00,NULL,'2023-02-15 15:20:54','2023-02-15 15:20:54',NULL),(3126,8119,1001,40883,31295,2,96,2,15975.21,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3127,8119,1001,40883,31295,2,67,2,3354.79,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3128,8119,1001,40883,31295,2,13,1,19330.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3129,8119,1002,40883,31295,2,96,2,16247.93,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3130,8119,1002,40883,31295,2,67,2,3412.07,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3131,8119,1002,40883,31295,2,13,1,19660.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3132,8119,1003,40883,31295,2,96,2,17851.24,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3133,8119,1003,40883,31295,2,67,2,3748.76,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3134,8119,1003,40883,31295,2,13,1,21600.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3135,8119,1004,40883,31295,2,96,2,19504.13,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3136,8119,1004,40883,31295,2,67,2,4095.87,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3137,8119,1004,40883,31295,2,13,1,23600.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3138,8119,1005,40883,31295,2,96,2,14599.17,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3139,8119,1005,40883,31295,2,67,2,3065.83,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3140,8119,1005,40883,31295,2,13,1,17665.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3141,8119,1006,40883,31295,2,96,2,19545.45,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3142,8119,1006,40883,31295,2,67,2,4104.55,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3143,8119,1006,40883,31295,2,13,1,23650.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3144,8119,1007,40883,31295,2,96,2,20661.16,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3145,8119,1007,40883,31295,2,67,2,4338.84,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3146,8119,1007,40883,31295,2,13,1,25000.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3147,8119,1008,40883,31295,2,96,2,11280.99,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3148,8119,1008,40883,31295,2,67,2,2369.01,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3149,8119,1008,40883,31295,2,13,1,13650.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3150,8119,1009,40883,31295,2,96,2,14710.74,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3151,8119,1009,40883,31295,2,67,2,3089.26,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3152,8119,1009,40883,31295,2,13,1,17800.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3153,8119,1010,40883,31295,2,96,2,13123.97,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3154,8119,1010,40883,31295,2,67,2,2756.03,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3155,8119,1010,40883,31295,2,13,1,15880.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3156,8119,1011,40883,31295,2,96,2,20652.89,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3157,8119,1011,40883,31295,2,67,2,4337.11,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3158,8119,1011,40883,31295,2,13,1,24990.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3159,8119,1012,40883,31295,2,96,2,21983.47,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL);
INSERT INTO `balance_libro_details` VALUES (3160,8119,1012,40883,31295,2,67,2,4616.53,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3161,8119,1012,40883,31295,2,13,1,26600.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3162,8119,1013,40883,31295,2,96,2,12388.43,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3163,8119,1013,40883,31295,2,67,2,2601.57,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3164,8119,1013,40883,31295,2,13,1,14990.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3165,8119,1014,40883,31295,2,96,2,12396.69,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3166,8119,1014,40883,31295,2,67,2,2603.31,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3167,8119,1014,40883,31295,2,13,1,15000.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3168,8119,1015,40883,31295,2,96,2,13867.77,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3169,8119,1015,40883,31295,2,67,2,2912.23,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3170,8119,1015,40883,31295,2,13,1,16780.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3171,8119,1016,40883,31295,2,96,2,16404.96,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3172,8119,1016,40883,31295,2,67,2,3445.04,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3173,8119,1016,40883,31295,2,13,1,19850.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3174,8119,1017,40883,31295,2,96,2,14041.32,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3175,8119,1017,40883,31295,2,67,2,2948.68,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3176,8119,1017,40883,31295,2,13,1,16990.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3177,8119,1018,40883,31295,2,96,2,18016.53,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3178,8119,1018,40883,31295,2,67,2,3783.47,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3179,8119,1018,40883,31295,2,13,1,21800.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3180,8119,1019,40883,31295,2,96,2,17900.83,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3181,8119,1019,40883,31295,2,67,2,3759.17,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3182,8119,1019,40883,31295,2,13,1,21660.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3183,8119,1020,40883,31295,2,96,2,19549.59,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3184,8119,1020,40883,31295,2,67,2,4105.41,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3185,8119,1020,40883,31295,2,13,1,23655.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3186,8119,1021,40883,31295,2,96,2,15694.21,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3187,8119,1021,40883,31295,2,67,2,3295.79,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3188,8119,1021,40883,31295,2,13,1,18990.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3189,8119,1022,40883,31295,2,96,2,16446.28,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3190,8119,1022,40883,31295,2,67,2,3453.72,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3191,8119,1022,40883,31295,2,13,1,19900.00,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3192,8119,1023,40883,31295,2,96,2,18173.55,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3193,8119,1023,40883,31295,2,67,2,3816.45,NULL,'2023-02-15 15:20:55','2023-02-15 15:20:55',NULL),(3194,8119,1023,40883,31295,2,13,1,21990.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3195,8119,1024,40883,31295,2,96,2,19462.81,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3196,8119,1024,40883,31295,2,67,2,4087.19,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3197,8119,1024,40883,31295,2,13,1,23550.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3198,8119,1025,40883,31295,2,96,2,14504.13,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3199,8119,1025,40883,31295,2,67,2,3045.87,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL);
INSERT INTO `balance_libro_details` VALUES (3200,8119,1025,40883,31295,2,13,1,17550.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3201,8119,1026,40883,31295,2,96,2,13719.01,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3202,8119,1026,40883,31295,2,67,2,2880.99,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3203,8119,1026,40883,31295,2,13,1,16600.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3204,8119,1027,40883,31295,2,96,2,17900.83,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3205,8119,1027,40883,31295,2,67,2,3759.17,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3206,8119,1027,40883,31295,2,13,1,21660.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3207,8119,1028,40883,31295,2,96,2,19376.03,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3208,8119,1028,40883,31295,2,67,2,4068.97,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3209,8119,1028,40883,31295,2,13,1,23445.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3210,8119,1029,40883,31295,2,96,2,17991.74,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3211,8119,1029,40883,31295,2,67,2,3778.26,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3212,8119,1029,40883,31295,2,13,1,21770.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3213,8119,1030,40883,31295,2,96,2,15886.78,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3214,8119,1030,40883,31295,2,67,2,3336.22,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3215,8119,1030,40883,31295,2,13,1,19223.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3216,8119,1031,40883,31295,2,96,2,14413.22,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3217,8119,1031,40883,31295,2,67,2,3026.78,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3218,8119,1031,40883,31295,2,13,1,17440.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3219,8119,1032,40883,31295,2,96,2,13214.88,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3220,8119,1032,40883,31295,2,67,2,2775.12,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3221,8119,1032,40883,31295,2,13,1,15990.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3222,8119,1033,40883,31295,2,96,2,11900.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3223,8119,1033,40883,31295,2,67,2,2499.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3224,8119,1033,40883,31295,2,13,1,14399.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3225,8119,1034,40883,31295,2,96,2,16446.28,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3226,8119,1034,40883,31295,2,67,2,3453.72,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3227,8119,1034,40883,31295,2,13,1,19900.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3228,8119,1035,40883,31295,2,96,2,17900.83,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3229,8119,1035,40883,31295,2,67,2,3759.17,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3230,8119,1035,40883,31295,2,13,1,21660.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3231,8119,1036,40883,31295,2,96,2,16892.56,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3232,8119,1036,40883,31295,2,67,2,3547.44,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3233,8119,1036,40883,31295,2,13,1,20440.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3234,8119,1037,40883,31295,2,96,2,13719.01,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3235,8119,1037,40883,31295,2,67,2,2880.99,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3236,8119,1037,40883,31295,2,13,1,16600.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3237,8119,1038,40883,31295,2,96,2,16082.64,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3238,8119,1038,40883,31295,2,67,2,3377.36,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3239,8119,1038,40883,31295,2,13,1,19460.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL);
INSERT INTO `balance_libro_details` VALUES (3240,8119,1039,40883,31295,2,96,2,10280.99,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3241,8119,1039,40883,31295,2,67,2,2159.01,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3242,8119,1039,40883,31295,2,13,1,12440.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3243,8119,1040,40883,31295,2,96,2,16504.13,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3244,8119,1040,40883,31295,2,67,2,3465.87,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3245,8119,1040,40883,31295,2,13,1,19970.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3246,8119,1041,40883,31295,2,96,2,15632.23,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3247,8119,1041,40883,31295,2,67,2,3282.77,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3248,8119,1041,40883,31295,2,13,1,18915.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3249,8119,1042,40883,31295,2,96,2,16512.40,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3250,8119,1042,40883,31295,2,67,2,3467.60,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3251,8119,1042,40883,31295,2,13,1,19980.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3252,8119,1043,40883,31295,2,96,2,9909.09,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3253,8119,1043,40883,31295,2,67,2,2080.91,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3254,8119,1043,40883,31295,2,13,1,11990.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3255,8119,1044,40883,31295,2,96,2,12487.60,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3256,8119,1044,40883,31295,2,67,2,2622.40,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3257,8119,1044,40883,31295,2,13,1,15110.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3258,8119,1045,40883,31295,2,96,2,16519.01,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3259,8119,1045,40883,31295,2,67,2,3468.99,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3260,8119,1045,40883,31295,2,13,1,19988.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3261,8119,1046,40883,31295,2,96,2,15423.97,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3262,8119,1046,40883,31295,2,67,2,3239.03,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3263,8119,1046,40883,31295,2,13,1,18663.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3264,8119,1047,40883,31295,2,96,2,16071.90,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3265,8119,1047,40883,31295,2,67,2,3375.10,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3266,8119,1047,40883,31295,2,13,1,19447.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3267,8119,1048,40883,31295,2,96,2,19371.90,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3268,8119,1048,40883,31295,2,67,2,4068.10,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3269,8119,1048,40883,31295,2,13,1,23440.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3270,8119,1049,40883,31295,2,96,2,18545.45,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3271,8119,1049,40883,31295,2,67,2,3894.55,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3272,8119,1049,40883,31295,2,13,1,22440.00,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3273,8119,1050,40883,31295,2,96,2,20108.26,NULL,'2023-02-15 15:20:56','2023-02-15 15:20:56',NULL),(3274,8119,1050,40883,31295,2,67,2,4222.74,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3275,8119,1050,40883,31295,2,13,1,24331.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3276,8119,1051,40883,31295,2,96,2,18727.27,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3277,8119,1051,40883,31295,2,67,2,3932.73,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3278,8119,1051,40883,31295,2,13,1,22660.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3279,8119,1052,40883,31295,2,96,2,16446.28,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL);
INSERT INTO `balance_libro_details` VALUES (3280,8119,1052,40883,31295,2,67,2,3453.72,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3281,8119,1052,40883,31295,2,13,1,19900.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3282,8119,1053,40883,31295,2,96,2,18731.40,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3283,8119,1053,40883,31295,2,67,2,3933.60,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3284,8119,1053,40883,31295,2,13,1,22665.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3285,8119,1054,40883,31295,2,96,2,14694.21,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3286,8119,1054,40883,31295,2,67,2,3085.79,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3287,8119,1054,40883,31295,2,13,1,17780.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3288,8119,1055,40883,31295,2,96,2,16512.40,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3289,8119,1055,40883,31295,2,67,2,3467.60,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3290,8119,1055,40883,31295,2,13,1,19980.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3291,8119,1056,40883,31295,2,96,2,13757.85,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3292,8119,1056,40883,31295,2,67,2,2889.15,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3293,8119,1056,40883,31295,2,13,1,16647.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3294,8119,1057,40883,31295,2,96,2,16479.34,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3295,8119,1057,40883,31295,2,67,2,3460.66,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3296,8119,1057,40883,31295,2,13,1,19940.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3297,8119,1058,40883,31295,2,96,2,19377.69,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3298,8119,1058,40883,31295,2,67,2,4069.31,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3299,8119,1058,40883,31295,2,13,1,23447.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3300,8119,1059,40883,31295,2,96,2,16509.92,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3301,8119,1059,40883,31295,2,67,2,3467.08,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3302,8119,1059,40883,31295,2,13,1,19977.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3303,8119,1060,40883,31295,2,96,2,18642.98,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3304,8119,1060,40883,31295,2,67,2,3915.02,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3305,8119,1060,40883,31295,2,13,1,22558.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3306,8119,1061,40883,31295,2,96,2,17904.13,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3307,8119,1061,40883,31295,2,67,2,3759.87,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3308,8119,1061,40883,31295,2,13,1,21664.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3309,8119,1062,40883,31295,2,96,2,13752.07,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3310,8119,1062,40883,31295,2,67,2,2887.93,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3311,8119,1062,40883,31295,2,13,1,16640.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3312,8119,1063,40883,31295,2,96,2,15537.19,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3313,8119,1063,40883,31295,2,67,2,3262.81,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3314,8119,1063,40883,31295,2,13,1,18800.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3315,8119,1064,40883,31295,2,96,2,13206.61,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3316,8119,1064,40883,31295,2,67,2,2773.39,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3317,8119,1064,40883,31295,2,13,1,15980.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3318,8119,1065,40883,31295,2,96,2,13975.21,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3319,8119,1065,40883,31295,2,67,2,2934.79,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL);
INSERT INTO `balance_libro_details` VALUES (3320,8119,1065,40883,31295,2,13,1,16910.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3321,8119,1066,40883,31295,2,96,2,14867.77,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3322,8119,1066,40883,31295,2,67,2,3122.23,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3323,8119,1066,40883,31295,2,13,1,17990.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3324,8119,1067,40883,31295,2,96,2,15537.19,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3325,8119,1067,40883,31295,2,67,2,3262.81,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3326,8119,1067,40883,31295,2,13,1,18800.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3327,8119,1068,40883,31295,2,96,2,16280.99,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3328,8119,1068,40883,31295,2,67,2,3419.01,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3329,8119,1068,40883,31295,2,13,1,19700.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3330,8119,1069,40883,31295,2,96,2,16528.93,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3331,8119,1069,40883,31295,2,67,2,3471.07,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3332,8119,1069,40883,31295,2,13,1,20000.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3333,8119,1070,40883,31295,2,96,2,14710.74,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3334,8119,1070,40883,31295,2,67,2,3089.26,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3335,8119,1070,40883,31295,2,13,1,17800.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3336,8119,1071,40883,31295,2,96,2,15909.09,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3337,8119,1071,40883,31295,2,67,2,3340.91,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3338,8119,1071,40883,31295,2,13,1,19250.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3339,8119,1072,40883,31295,2,96,2,15495.87,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3340,8119,1072,40883,31295,2,67,2,3254.13,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3341,8119,1072,40883,31295,2,13,1,18750.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3342,8119,1073,40883,31295,2,96,2,16363.64,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3343,8119,1073,40883,31295,2,67,2,3436.36,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3344,8119,1073,40883,31295,2,13,1,19800.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3345,8119,1074,40883,31295,2,96,2,17768.60,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3346,8119,1074,40883,31295,2,67,2,3731.40,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3347,8119,1074,40883,31295,2,13,1,21500.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3348,8119,1075,40883,31295,2,96,2,19581.82,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3349,8119,1075,40883,31295,2,67,2,4112.18,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3350,8119,1075,40883,31295,2,13,1,23694.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3351,8119,1076,40883,31295,2,96,2,13429.75,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3352,8119,1076,40883,31295,2,67,2,2820.25,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3353,8119,1076,40883,31295,2,13,1,16250.00,NULL,'2023-02-15 15:20:57','2023-02-15 15:20:57',NULL),(3354,8119,1077,40883,31295,2,96,2,14847.11,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3355,8119,1077,40883,31295,2,67,2,3117.89,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3356,8119,1077,40883,31295,2,13,1,17965.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3357,8119,1078,40883,31295,2,96,2,15914.05,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3358,8119,1078,40883,31295,2,67,2,3341.95,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3359,8119,1078,40883,31295,2,13,1,19256.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL);
INSERT INTO `balance_libro_details` VALUES (3360,8119,1079,40883,31295,2,96,2,14417.36,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3361,8119,1079,40883,31295,2,67,2,3027.64,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3362,8119,1079,40883,31295,2,13,1,17445.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3363,8119,1080,40883,31295,2,96,2,13144.63,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3364,8119,1080,40883,31295,2,67,2,2760.37,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3365,8119,1080,40883,31295,2,13,1,15905.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3366,8119,1081,40883,31295,2,96,2,14033.06,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3367,8119,1081,40883,31295,2,67,2,2946.94,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3368,8119,1081,40883,31295,2,13,1,16980.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3369,8119,1082,40883,31295,2,96,2,18165.29,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3370,8119,1082,40883,31295,2,67,2,3814.71,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3371,8119,1082,40883,31295,2,13,1,21980.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3372,8119,1083,40883,31295,2,96,2,14047.11,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3373,8119,1083,40883,31295,2,67,2,2949.89,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3374,8119,1083,40883,31295,2,13,1,16997.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3375,8119,1084,40883,31295,2,96,2,13702.48,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3376,8119,1084,40883,31295,2,67,2,2877.52,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3377,8119,1084,40883,31295,2,13,1,16580.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3378,8119,1085,40883,31295,2,96,2,16429.75,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3379,8119,1085,40883,31295,2,67,2,3450.25,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3380,8119,1085,40883,31295,2,13,1,19880.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3381,8119,1086,40883,31295,2,96,2,18603.31,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3382,8119,1086,40883,31295,2,67,2,3906.69,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3383,8119,1086,40883,31295,2,13,1,22510.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3384,8119,1087,40883,31295,2,96,2,14599.17,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3385,8119,1087,40883,31295,2,67,2,3065.83,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3386,8119,1087,40883,31295,2,13,1,17665.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3387,8119,1088,40883,31295,2,96,2,11293.39,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3388,8119,1088,40883,31295,2,67,2,2371.61,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3389,8119,1088,40883,31295,2,13,1,13665.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3390,8119,1089,40883,31295,2,96,2,19557.85,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3391,8119,1089,40883,31295,2,67,2,4107.15,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3392,8119,1089,40883,31295,2,13,1,23665.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3393,8119,1090,40883,31295,2,96,2,14876.03,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3394,8119,1090,40883,31295,2,67,2,3123.97,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3395,8119,1090,40883,31295,2,13,1,18000.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3396,8119,1091,40883,31295,2,96,2,18595.04,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3397,8119,1091,40883,31295,2,67,2,3904.96,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3398,8119,1091,40883,31295,2,13,1,22500.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3399,8119,1092,40883,31295,2,96,2,19557.02,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL);
INSERT INTO `balance_libro_details` VALUES (3400,8119,1092,40883,31295,2,67,2,4106.98,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3401,8119,1092,40883,31295,2,13,1,23664.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3402,8119,1093,40883,31295,2,96,2,14338.84,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3403,8119,1093,40883,31295,2,67,2,3011.16,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3404,8119,1093,40883,31295,2,13,1,17350.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3405,8119,1094,40883,31295,2,96,2,9082.64,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3406,8119,1094,40883,31295,2,67,2,1907.36,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3407,8119,1094,40883,31295,2,13,1,10990.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3408,8119,1095,40883,31295,2,96,2,14867.77,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3409,8119,1095,40883,31295,2,67,2,3122.23,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3410,8119,1095,40883,31295,2,13,1,17990.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3411,8119,1096,40883,31295,2,96,2,15421.49,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3412,8119,1096,40883,31295,2,67,2,3238.51,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3413,8119,1096,40883,31295,2,13,1,18660.00,NULL,'2023-02-15 15:20:58','2023-02-15 15:20:58',NULL),(3414,8119,1097,40883,31295,3,217,1,1060506.02,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3415,8119,1097,40883,31295,3,68,1,222706.26,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3416,8119,1097,40883,31295,3,217,1,31815.18,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3417,8119,1097,40883,31295,3,57,2,1315027.46,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3418,8119,1098,40883,31295,3,217,1,796129.08,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3419,8119,1098,40883,31295,3,68,1,167187.12,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3420,8119,1098,40883,31295,3,217,1,23883.87,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3421,8119,1098,40883,31295,3,57,2,987200.07,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3422,8119,1099,40883,31295,3,217,2,2349.81,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3423,8119,1099,40883,31295,3,67,2,493.46,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3424,8119,1099,40883,31295,3,217,2,70.49,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3425,8119,1099,40883,31295,3,57,1,2913.76,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3426,8119,1100,40883,31295,3,217,2,2349.81,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3427,8119,1100,40883,31295,3,67,2,493.46,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3428,8119,1100,40883,31295,3,217,2,70.49,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3429,8119,1100,40883,31295,3,57,1,2913.76,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3430,8119,1101,40883,31295,3,217,1,153918.48,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3431,8119,1101,40883,31295,3,68,1,32322.89,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3432,8119,1101,40883,31295,3,217,1,4617.55,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3433,8119,1101,40883,31295,3,57,2,190858.92,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3434,8119,1102,40883,31295,3,217,1,5107.79,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3435,8119,1102,40883,31295,3,68,1,1072.64,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3436,8119,1102,40883,31295,3,217,1,153.23,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3437,8119,1102,40883,31295,3,57,2,6333.66,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3438,8119,1103,40883,31295,3,217,1,14793.39,NULL,'2023-02-15 15:21:03','2023-02-15 16:07:23','2023-02-15 16:07:23'),(3439,8119,1103,40883,31295,3,68,1,3106.61,NULL,'2023-02-15 15:21:03','2023-02-15 16:07:23','2023-02-15 16:07:23');
INSERT INTO `balance_libro_details` VALUES (3440,8119,1103,40883,31295,3,57,2,17900.00,NULL,'2023-02-15 15:21:03','2023-02-15 16:07:23','2023-02-15 16:07:23'),(3441,8119,1104,40883,31295,3,217,1,24709.50,NULL,'2023-02-15 15:21:03','2023-02-15 16:07:15','2023-02-15 16:07:15'),(3442,8119,1104,40883,31295,3,68,1,2594.50,NULL,'2023-02-15 15:21:03','2023-02-15 16:07:15','2023-02-15 16:07:15'),(3443,8119,1104,40883,31295,3,57,2,27304.00,NULL,'2023-02-15 15:21:03','2023-02-15 16:07:15','2023-02-15 16:07:15'),(3444,8119,1105,40883,31295,3,217,1,53512.40,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3445,8119,1105,40883,31295,3,68,1,11237.60,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3446,8119,1105,40883,31295,3,57,2,64750.00,NULL,'2023-02-15 15:21:03','2023-02-15 15:21:03',NULL),(3447,8119,1106,40856,29415,2,96,2,40842.98,NULL,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(3448,8119,1106,40856,29415,2,67,2,8577.02,NULL,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(3449,8119,1106,40856,29415,2,13,1,49420.00,NULL,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(3450,8119,1107,40856,29415,2,96,2,25089.26,NULL,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(3451,8119,1107,40856,29415,2,67,2,5268.74,NULL,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(3452,8119,1107,40856,29415,2,13,1,30358.00,NULL,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(3453,8119,1108,40856,29415,2,96,2,15979.34,NULL,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(3454,8119,1108,40856,29415,2,67,2,3355.66,NULL,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(3455,8119,1108,40856,29415,2,13,1,19335.00,NULL,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(3456,8119,1109,40856,29415,2,96,2,7950.41,NULL,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(3457,8119,1109,40856,29415,2,67,2,1669.59,NULL,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(3458,8119,1109,40856,29415,2,13,1,9620.00,NULL,'2023-02-15 16:36:23','2023-02-15 16:39:43','2023-02-15 16:39:43'),(3459,8119,1110,40856,29415,2,96,2,16528.93,NULL,'2023-02-15 16:36:23','2023-02-15 16:37:19','2023-02-15 16:37:19'),(3460,8119,1110,40856,29415,2,67,2,3471.07,NULL,'2023-02-15 16:36:23','2023-02-15 16:37:19','2023-02-15 16:37:19'),(3461,8119,1110,40856,29415,2,13,1,20000.00,NULL,'2023-02-15 16:36:23','2023-02-15 16:37:19','2023-02-15 16:37:19'),(3462,8119,1111,40856,29415,2,96,2,7438.02,NULL,'2023-02-15 16:36:23','2023-02-15 16:37:11','2023-02-15 16:37:11'),(3463,8119,1111,40856,29415,2,67,2,1561.98,NULL,'2023-02-15 16:36:23','2023-02-15 16:37:11','2023-02-15 16:37:11'),(3464,8119,1111,40856,29415,2,13,1,9000.00,NULL,'2023-02-15 16:36:23','2023-02-15 16:37:11','2023-02-15 16:37:11'),(3465,8119,1112,40856,29415,2,96,2,7950.41,NULL,'2023-02-15 16:36:23','2023-02-15 16:37:06','2023-02-15 16:37:06'),(3466,8119,1112,40856,29415,2,67,2,1669.59,NULL,'2023-02-15 16:36:23','2023-02-15 16:37:06','2023-02-15 16:37:06'),(3467,8119,1112,40856,29415,2,13,1,9620.00,NULL,'2023-02-15 16:36:23','2023-02-15 16:37:06','2023-02-15 16:37:06'),(3468,8119,1113,40856,29415,2,96,2,28413.22,NULL,'2023-02-15 16:36:23','2023-02-15 16:37:01','2023-02-15 16:37:01'),(3469,8119,1113,40856,29415,2,67,2,5966.78,NULL,'2023-02-15 16:36:23','2023-02-15 16:37:01','2023-02-15 16:37:01'),(3470,8119,1113,40856,29415,2,13,1,34380.00,NULL,'2023-02-15 16:36:23','2023-02-15 16:37:01','2023-02-15 16:37:01'),(3471,8119,1114,40856,29415,2,96,2,32892.56,NULL,'2023-02-15 16:36:23','2023-02-15 16:36:55','2023-02-15 16:36:55'),(3472,8119,1114,40856,29415,2,67,2,6907.44,NULL,'2023-02-15 16:36:23','2023-02-15 16:36:55','2023-02-15 16:36:55'),(3473,8119,1114,40856,29415,2,13,1,39800.00,NULL,'2023-02-15 16:36:23','2023-02-15 16:36:55','2023-02-15 16:36:55'),(3474,8119,1115,40856,29415,3,250,2,0.00,NULL,'2023-02-15 16:36:30','2023-02-15 16:39:06','2023-02-15 16:39:06');
INSERT INTO `balance_libro_details` VALUES (3475,8119,1115,40856,29415,3,250,2,8494.22,NULL,'2023-02-15 16:36:30','2023-02-15 16:39:06','2023-02-15 16:39:06'),(3476,8119,1115,40856,29415,3,57,1,8494.22,NULL,'2023-02-15 16:36:30','2023-02-15 16:39:06','2023-02-15 16:39:06'),(3477,8119,1116,40856,29415,3,250,1,0.00,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:57','2023-02-15 16:38:57'),(3478,8119,1116,40856,29415,3,250,1,11369.51,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:57','2023-02-15 16:38:57'),(3479,8119,1116,40856,29415,3,57,2,11369.51,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:57','2023-02-15 16:38:57'),(3480,8119,1117,40856,29415,3,250,1,20000.00,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3481,8119,1117,40856,29415,3,57,2,20000.00,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3482,8119,1118,40856,29415,3,217,1,4672.88,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:48','2023-02-15 16:38:48'),(3483,8119,1118,40856,29415,3,68,1,981.30,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:48','2023-02-15 16:38:48'),(3484,8119,1118,40856,29415,3,57,2,5654.18,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:48','2023-02-15 16:38:48'),(3485,8119,1119,40856,29415,3,217,1,1155.37,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:39','2023-02-15 16:38:39'),(3486,8119,1119,40856,29415,3,68,1,242.63,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:39','2023-02-15 16:38:39'),(3487,8119,1119,40856,29415,3,57,2,1398.00,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:39','2023-02-15 16:38:39'),(3488,8119,1120,40856,29415,3,217,1,6455.39,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:29','2023-02-15 16:38:29'),(3489,8119,1120,40856,29415,3,68,1,1355.63,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:29','2023-02-15 16:38:29'),(3490,8119,1120,40856,29415,3,57,2,7811.02,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:29','2023-02-15 16:38:29'),(3491,8119,1121,40856,29415,3,217,1,904.07,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:12','2023-02-15 16:38:12'),(3492,8119,1121,40856,29415,3,68,1,94.93,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:12','2023-02-15 16:38:12'),(3493,8119,1121,40856,29415,3,57,2,999.00,NULL,'2023-02-15 16:36:30','2023-02-15 16:38:12','2023-02-15 16:38:12'),(3494,8119,1122,40856,29415,3,217,1,42974.38,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3495,8119,1122,40856,29415,3,68,1,9024.62,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3496,8119,1122,40856,29415,3,217,1,1289.23,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3497,8119,1122,40856,29415,3,57,2,53288.23,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3498,8119,1123,40856,29415,3,217,1,40495.04,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3499,8119,1123,40856,29415,3,68,1,8503.96,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3500,8119,1123,40856,29415,3,217,1,1214.85,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3501,8119,1123,40856,29415,3,57,2,50213.85,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3502,8119,1124,40856,29415,3,217,1,6728.12,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3503,8119,1124,40856,29415,3,68,1,1412.91,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3504,8119,1124,40856,29415,3,217,1,403.68,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3505,8119,1124,40856,29415,3,57,2,8544.71,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3506,8119,1125,40856,29415,3,217,1,4678.26,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3507,8119,1125,40856,29415,3,68,1,982.43,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3508,8119,1125,40856,29415,3,217,1,280.70,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11');
INSERT INTO `balance_libro_details` VALUES (3509,8119,1125,40856,29415,3,57,2,5941.39,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3510,8119,1126,40856,29415,3,217,1,6099.17,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3511,8119,1126,40856,29415,3,68,1,1280.83,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3512,8119,1126,40856,29415,3,57,2,7380.00,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3513,8119,1127,40856,29415,3,217,1,7433.88,NULL,'2023-02-15 16:36:30','2023-02-15 16:37:58','2023-02-15 16:37:58'),(3514,8119,1127,40856,29415,3,68,1,1561.12,NULL,'2023-02-15 16:36:30','2023-02-15 16:37:58','2023-02-15 16:37:58'),(3515,8119,1127,40856,29415,3,57,2,8995.00,NULL,'2023-02-15 16:36:30','2023-02-15 16:37:58','2023-02-15 16:37:58'),(3516,8119,1128,40856,29415,3,217,1,412.40,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3517,8119,1128,40856,29415,3,68,1,86.60,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3518,8119,1128,40856,29415,3,57,2,499.00,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3519,8119,1129,40856,29415,3,217,1,12411.59,NULL,'2023-02-15 16:36:30','2023-02-15 16:37:53','2023-02-15 16:37:53'),(3520,8119,1129,40856,29415,3,68,1,2606.43,NULL,'2023-02-15 16:36:30','2023-02-15 16:37:53','2023-02-15 16:37:53'),(3521,8119,1129,40856,29415,3,57,2,15018.02,NULL,'2023-02-15 16:36:30','2023-02-15 16:37:53','2023-02-15 16:37:53'),(3522,8119,1130,40856,29415,3,217,1,6903.90,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3523,8119,1130,40856,29415,3,68,1,1449.82,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3524,8119,1130,40856,29415,3,57,2,8353.72,NULL,'2023-02-15 16:36:30','2023-02-15 16:46:11','2023-02-15 16:46:11'),(3525,8119,1131,40856,29415,2,96,2,40842.98,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3526,8119,1131,40856,29415,2,67,2,8577.02,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3527,8119,1131,40856,29415,2,13,1,49420.00,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3528,8119,1132,40856,29415,2,96,2,25089.26,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3529,8119,1132,40856,29415,2,67,2,5268.74,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3530,8119,1132,40856,29415,2,13,1,30358.00,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3531,8119,1133,40856,29415,2,96,2,15979.34,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3532,8119,1133,40856,29415,2,67,2,3355.66,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3533,8119,1133,40856,29415,2,13,1,19335.00,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3534,8119,1134,40856,29415,2,96,2,7950.41,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3535,8119,1134,40856,29415,2,67,2,1669.59,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3536,8119,1134,40856,29415,2,13,1,9620.00,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3537,8119,1135,40856,29415,2,96,2,16528.93,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3538,8119,1135,40856,29415,2,67,2,3471.07,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3539,8119,1135,40856,29415,2,13,1,20000.00,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3540,8119,1136,40856,29415,2,96,2,7438.02,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3541,8119,1136,40856,29415,2,67,2,1561.98,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3542,8119,1136,40856,29415,2,13,1,9000.00,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3543,8119,1137,40856,29415,2,96,2,7950.41,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3544,8119,1137,40856,29415,2,67,2,1669.59,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3545,8119,1137,40856,29415,2,13,1,9620.00,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3546,8119,1138,40856,29415,2,96,2,28413.22,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL);
INSERT INTO `balance_libro_details` VALUES (3547,8119,1138,40856,29415,2,67,2,5966.78,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3548,8119,1138,40856,29415,2,13,1,34380.00,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3549,8119,1139,40856,29415,2,96,2,32892.56,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3550,8119,1139,40856,29415,2,67,2,6907.44,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3551,8119,1139,40856,29415,2,13,1,39800.00,NULL,'2023-02-15 16:40:08','2023-02-15 16:40:08',NULL),(3552,8119,1140,40856,29415,3,250,2,0.00,NULL,'2023-02-15 16:47:02','2023-02-15 16:49:27','2023-02-15 16:49:27'),(3553,8119,1140,40856,29415,3,250,2,8494.22,NULL,'2023-02-15 16:47:02','2023-02-15 16:49:27','2023-02-15 16:49:27'),(3554,8119,1140,40856,29415,3,57,1,8494.22,NULL,'2023-02-15 16:47:02','2023-02-15 16:49:27','2023-02-15 16:49:27'),(3555,8119,1141,40856,29415,3,250,1,0.00,NULL,'2023-02-15 16:47:02','2023-02-15 16:49:35','2023-02-15 16:49:35'),(3556,8119,1141,40856,29415,3,250,1,11369.51,NULL,'2023-02-15 16:47:02','2023-02-15 16:49:35','2023-02-15 16:49:35'),(3557,8119,1141,40856,29415,3,57,2,11369.51,NULL,'2023-02-15 16:47:02','2023-02-15 16:49:35','2023-02-15 16:49:35'),(3558,8119,1142,40856,29415,3,250,1,20000.00,NULL,'2023-02-15 16:47:02','2023-02-15 16:49:43','2023-02-15 16:49:43'),(3559,8119,1142,40856,29415,3,57,2,20000.00,NULL,'2023-02-15 16:47:02','2023-02-15 16:49:43','2023-02-15 16:49:43'),(3560,8119,1143,40856,29415,3,217,1,4672.88,NULL,'2023-02-15 16:47:02','2023-02-15 16:49:51','2023-02-15 16:49:51'),(3561,8119,1143,40856,29415,3,68,1,981.30,NULL,'2023-02-15 16:47:02','2023-02-15 16:49:51','2023-02-15 16:49:51'),(3562,8119,1143,40856,29415,3,57,2,5654.18,NULL,'2023-02-15 16:47:02','2023-02-15 16:49:51','2023-02-15 16:49:51'),(3563,8119,1144,40856,29415,3,217,1,1155.37,NULL,'2023-02-15 16:47:02','2023-02-15 16:50:02','2023-02-15 16:50:02'),(3564,8119,1144,40856,29415,3,68,1,242.63,NULL,'2023-02-15 16:47:02','2023-02-15 16:50:02','2023-02-15 16:50:02'),(3565,8119,1144,40856,29415,3,57,2,1398.00,NULL,'2023-02-15 16:47:02','2023-02-15 16:50:02','2023-02-15 16:50:02'),(3566,8119,1145,40856,29415,3,217,1,6455.39,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3567,8119,1145,40856,29415,3,68,1,1355.63,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3568,8119,1145,40856,29415,3,57,2,7811.02,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3569,8119,1146,40856,29415,3,217,1,904.07,NULL,'2023-02-15 16:47:02','2023-02-15 16:50:10','2023-02-15 16:50:10'),(3570,8119,1146,40856,29415,3,68,1,94.93,NULL,'2023-02-15 16:47:02','2023-02-15 16:50:10','2023-02-15 16:50:10'),(3571,8119,1146,40856,29415,3,57,2,999.00,NULL,'2023-02-15 16:47:02','2023-02-15 16:50:10','2023-02-15 16:50:10'),(3572,8119,1147,40856,29415,3,217,1,42974.38,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3573,8119,1147,40856,29415,3,68,1,9024.62,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3574,8119,1147,40856,29415,3,217,1,1289.23,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3575,8119,1147,40856,29415,3,57,2,53288.23,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3576,8119,1148,40856,29415,3,217,1,40495.04,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3577,8119,1148,40856,29415,3,68,1,8503.96,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3578,8119,1148,40856,29415,3,217,1,1214.85,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3579,8119,1148,40856,29415,3,57,2,50213.85,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3580,8119,1149,40856,29415,3,217,1,6728.12,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3581,8119,1149,40856,29415,3,68,1,1412.91,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3582,8119,1149,40856,29415,3,217,1,403.68,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3583,8119,1149,40856,29415,3,57,2,8544.71,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL);
INSERT INTO `balance_libro_details` VALUES (3584,8119,1150,40856,29415,3,217,1,4678.26,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3585,8119,1150,40856,29415,3,68,1,982.43,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3586,8119,1150,40856,29415,3,217,1,280.70,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3587,8119,1150,40856,29415,3,57,2,5941.39,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3588,8119,1151,40856,29415,3,217,1,6099.17,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3589,8119,1151,40856,29415,3,68,1,1280.83,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3590,8119,1151,40856,29415,3,57,2,7380.00,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3591,8119,1152,40856,29415,3,217,1,7433.88,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3592,8119,1152,40856,29415,3,68,1,1561.12,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3593,8119,1152,40856,29415,3,57,2,8995.00,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3594,8119,1153,40856,29415,3,217,1,412.40,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3595,8119,1153,40856,29415,3,68,1,86.60,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3596,8119,1153,40856,29415,3,57,2,499.00,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3597,8119,1154,40856,29415,3,217,1,12411.59,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3598,8119,1154,40856,29415,3,68,1,2606.43,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3599,8119,1154,40856,29415,3,57,2,15018.02,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3600,8119,1155,40856,29415,3,217,1,6903.90,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3601,8119,1155,40856,29415,3,68,1,1449.82,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3602,8119,1155,40856,29415,3,57,2,8353.72,NULL,'2023-02-15 16:47:02','2023-02-15 16:47:02',NULL),(3603,8119,1156,40741,3352,2,96,2,222797.47,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3604,8119,1156,40741,3352,2,67,2,23393.73,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3605,8119,1156,40741,3352,2,13,1,246191.20,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3606,8119,1157,40741,3352,2,96,2,211331.03,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3607,8119,1157,40741,3352,2,67,2,22189.77,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3608,8119,1157,40741,3352,2,13,1,233520.80,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3609,8119,1158,40741,3352,2,96,2,39055.39,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3610,8119,1158,40741,3352,2,67,2,4100.81,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3611,8119,1158,40741,3352,2,13,1,43156.20,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3612,8119,1159,40741,3352,2,96,2,227308.13,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3613,8119,1159,40741,3352,2,67,2,23867.37,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3614,8119,1159,40741,3352,2,13,1,251175.50,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3615,8119,1160,40741,3352,2,96,2,73054.85,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3616,8119,1160,40741,3352,2,67,2,7670.75,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3617,8119,1160,40741,3352,2,13,1,80725.60,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3618,8119,1161,40741,3352,2,96,2,113991.31,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3619,8119,1161,40741,3352,2,67,2,11969.09,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3620,8119,1161,40741,3352,2,13,1,125960.40,NULL,'2023-02-16 08:39:08','2023-02-16 08:39:08',NULL),(3621,8119,1162,40741,3352,2,96,1,222797.47,NULL,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(3622,8119,1162,40741,3352,2,68,1,23393.73,NULL,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(3623,8119,1162,40741,3352,2,13,2,246191.20,NULL,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL);
INSERT INTO `balance_libro_details` VALUES (3624,8119,1163,40741,3352,2,96,2,231090.13,NULL,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(3625,8119,1163,40741,3352,2,67,2,24264.47,NULL,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(3626,8119,1163,40741,3352,2,13,1,255354.60,NULL,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(3627,8119,1164,40741,3352,2,96,2,121788.24,NULL,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(3628,8119,1164,40741,3352,2,67,2,12787.76,NULL,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(3629,8119,1164,40741,3352,2,13,1,134576.00,NULL,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(3630,8119,1165,40741,3352,2,96,2,273370.87,NULL,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(3631,8119,1165,40741,3352,2,67,2,28703.93,NULL,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(3632,8119,1165,40741,3352,2,13,1,302074.80,NULL,'2023-02-16 08:39:09','2023-02-16 08:39:09',NULL),(3633,8119,1166,40741,3352,3,217,1,724000.00,NULL,'2023-02-16 08:39:16','2023-02-16 08:39:16',NULL),(3634,8119,1166,40741,3352,3,68,1,76020.00,NULL,'2023-02-16 08:39:16','2023-02-16 08:39:16',NULL),(3635,8119,1166,40741,3352,3,57,2,800020.00,NULL,'2023-02-16 08:39:16','2023-02-16 08:39:16',NULL),(3636,8119,1167,40720,1548,3,217,1,44285.71,NULL,'2023-02-16 08:56:54','2023-02-16 08:56:54',NULL),(3637,8119,1167,40720,1548,3,68,1,9300.00,NULL,'2023-02-16 08:56:54','2023-02-16 08:56:54',NULL),(3638,8119,1167,40720,1548,3,57,2,53585.71,NULL,'2023-02-16 08:56:54','2023-02-16 08:56:54',NULL),(3639,8119,1168,40720,1548,3,217,1,136080.00,NULL,'2023-02-16 08:58:20','2023-02-16 09:14:04','2023-02-16 09:14:04'),(3640,8119,1168,40720,1548,3,68,1,28576.80,NULL,'2023-02-16 08:58:20','2023-02-16 09:14:04','2023-02-16 09:14:04'),(3641,8119,1168,40720,1548,3,57,2,164656.80,NULL,'2023-02-16 08:58:20','2023-02-16 09:14:04','2023-02-16 09:14:04'),(3642,8119,1169,40720,1548,3,217,1,423000.00,NULL,'2023-02-16 09:00:15','2023-02-16 09:00:15',NULL),(3643,8119,1169,40720,1548,3,68,1,88830.00,NULL,'2023-02-16 09:00:15','2023-02-16 09:00:15',NULL),(3644,8119,1169,40720,1548,3,57,2,511830.00,NULL,'2023-02-16 09:00:15','2023-02-16 09:00:15',NULL),(3645,8119,1170,40720,1548,3,217,1,270000.00,NULL,'2023-02-16 09:00:51','2023-02-16 09:00:51',NULL),(3646,8119,1170,40720,1548,3,68,1,56700.00,NULL,'2023-02-16 09:00:51','2023-02-16 09:00:51',NULL),(3647,8119,1170,40720,1548,3,57,2,326700.00,NULL,'2023-02-16 09:00:51','2023-02-16 09:00:51',NULL),(3648,8119,1171,40720,1548,3,217,1,380000.00,NULL,'2023-02-16 09:01:35','2023-02-16 09:01:35',NULL),(3649,8119,1171,40720,1548,3,68,1,79800.00,NULL,'2023-02-16 09:01:35','2023-02-16 09:01:35',NULL),(3650,8119,1171,40720,1548,3,57,2,459800.00,NULL,'2023-02-16 09:01:35','2023-02-16 09:01:35',NULL),(3651,8119,1172,40720,1548,3,217,1,158200.00,NULL,'2023-02-16 09:02:03','2023-02-16 09:02:03',NULL),(3652,8119,1172,40720,1548,3,68,1,33222.00,NULL,'2023-02-16 09:02:03','2023-02-16 09:02:03',NULL),(3653,8119,1172,40720,1548,3,57,2,191422.00,NULL,'2023-02-16 09:02:03','2023-02-16 09:02:03',NULL),(3654,8119,1173,40720,1548,3,217,1,389445.00,NULL,'2023-02-16 09:03:07','2023-02-16 09:03:07',NULL),(3655,8119,1173,40720,1548,3,68,1,81783.45,NULL,'2023-02-16 09:03:07','2023-02-16 09:03:07',NULL),(3656,8119,1173,40720,1548,3,57,2,471228.45,NULL,'2023-02-16 09:03:07','2023-02-16 09:03:07',NULL),(3657,8119,1174,40720,1548,3,217,1,250800.00,NULL,'2023-02-16 09:03:35','2023-02-16 09:03:35',NULL),(3658,8119,1174,40720,1548,3,68,1,52668.00,NULL,'2023-02-16 09:03:35','2023-02-16 09:03:35',NULL),(3659,8119,1174,40720,1548,3,57,2,303468.00,NULL,'2023-02-16 09:03:35','2023-02-16 09:03:35',NULL),(3660,8119,1175,40720,1548,3,217,1,719133.29,NULL,'2023-02-16 09:04:35','2023-02-16 09:04:35',NULL),(3661,8119,1175,40720,1548,3,68,1,151017.99,NULL,'2023-02-16 09:04:35','2023-02-16 09:04:35',NULL),(3662,8119,1175,40720,1548,3,57,2,870151.28,NULL,'2023-02-16 09:04:35','2023-02-16 09:04:35',NULL),(3663,8119,1176,40720,1548,3,217,1,271700.00,NULL,'2023-02-16 09:05:17','2023-02-16 09:05:17',NULL);
INSERT INTO `balance_libro_details` VALUES (3664,8119,1176,40720,1548,3,68,1,57057.00,NULL,'2023-02-16 09:05:17','2023-02-16 09:05:17',NULL),(3665,8119,1176,40720,1548,3,57,2,328757.00,NULL,'2023-02-16 09:05:17','2023-02-16 09:05:17',NULL),(3666,8119,1177,40720,1548,3,217,1,345000.00,NULL,'2023-02-16 09:05:50','2023-02-16 09:05:50',NULL),(3667,8119,1177,40720,1548,3,68,1,72450.00,NULL,'2023-02-16 09:05:50','2023-02-16 09:05:50',NULL),(3668,8119,1177,40720,1548,3,57,2,417450.00,NULL,'2023-02-16 09:05:50','2023-02-16 09:05:50',NULL),(3669,8119,1178,40720,1548,3,217,1,437610.00,NULL,'2023-02-16 09:06:22','2023-02-16 09:06:22',NULL),(3670,8119,1178,40720,1548,3,68,1,91898.10,NULL,'2023-02-16 09:06:22','2023-02-16 09:06:22',NULL),(3671,8119,1178,40720,1548,3,57,2,529508.10,NULL,'2023-02-16 09:06:22','2023-02-16 09:06:22',NULL),(3672,8119,1179,40720,1548,3,217,1,313195.00,NULL,'2023-02-16 09:06:51','2023-02-16 09:06:51',NULL),(3673,8119,1179,40720,1548,3,68,1,65770.95,NULL,'2023-02-16 09:06:51','2023-02-16 09:06:51',NULL),(3674,8119,1179,40720,1548,3,57,2,378965.95,NULL,'2023-02-16 09:06:51','2023-02-16 09:06:51',NULL),(3675,8119,1180,40720,1548,3,217,1,302514.00,NULL,'2023-02-16 09:07:34','2023-02-16 09:07:34',NULL),(3676,8119,1180,40720,1548,3,68,1,63527.94,NULL,'2023-02-16 09:07:34','2023-02-16 09:07:34',NULL),(3677,8119,1180,40720,1548,3,57,2,366041.94,NULL,'2023-02-16 09:07:34','2023-02-16 09:07:34',NULL),(3678,8119,1181,40720,1548,3,217,1,559032.00,NULL,'2023-02-16 09:08:07','2023-02-16 09:08:07',NULL),(3679,8119,1181,40720,1548,3,68,1,117396.72,NULL,'2023-02-16 09:08:07','2023-02-16 09:08:07',NULL),(3680,8119,1181,40720,1548,3,57,2,676428.72,NULL,'2023-02-16 09:08:07','2023-02-16 09:08:07',NULL),(3681,8119,1182,40720,1548,2,96,2,354780.00,NULL,'2023-02-16 09:11:41','2023-02-16 09:11:41',NULL),(3682,8119,1182,40720,1548,2,67,2,74503.80,NULL,'2023-02-16 09:11:41','2023-02-16 09:11:41',NULL),(3683,8119,1182,40720,1548,2,13,1,429283.80,NULL,'2023-02-16 09:11:41','2023-02-16 09:11:41',NULL),(3684,8119,1183,40720,1548,2,96,2,212784.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3685,8119,1183,40720,1548,2,67,2,44684.64,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3686,8119,1183,40720,1548,2,13,1,257468.64,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3687,8119,1184,40720,1548,2,96,2,187590.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3688,8119,1184,40720,1548,2,67,2,39393.90,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3689,8119,1184,40720,1548,2,13,1,226983.90,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3690,8119,1185,40720,1548,2,96,2,521945.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3691,8119,1185,40720,1548,2,67,2,109608.45,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3692,8119,1185,40720,1548,2,13,1,631553.45,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3693,8119,1186,40720,1548,2,96,2,184620.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3694,8119,1186,40720,1548,2,67,2,38770.20,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3695,8119,1186,40720,1548,2,13,1,223390.20,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3696,8119,1187,40720,1548,2,96,2,195000.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3697,8119,1187,40720,1548,2,67,2,40950.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3698,8119,1187,40720,1548,2,13,1,235950.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3699,8119,1188,40720,1548,2,96,2,191880.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3700,8119,1188,40720,1548,2,67,2,40294.80,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3701,8119,1188,40720,1548,2,13,1,232174.80,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3702,8119,1189,40720,1548,2,96,2,182070.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3703,8119,1189,40720,1548,2,67,2,38234.70,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL);
INSERT INTO `balance_libro_details` VALUES (3704,8119,1189,40720,1548,2,13,1,220304.70,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3705,8119,1190,40720,1548,2,96,2,1026200.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3706,8119,1190,40720,1548,2,67,2,215502.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3707,8119,1190,40720,1548,2,13,1,1241702.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3708,8119,1191,40720,1548,2,96,2,510000.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3709,8119,1191,40720,1548,2,67,2,107100.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3710,8119,1191,40720,1548,2,13,1,617100.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3711,8119,1192,40720,1548,2,96,2,1312500.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3712,8119,1192,40720,1548,2,67,2,275625.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3713,8119,1192,40720,1548,2,13,1,1588125.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3714,8119,1193,40720,1548,2,96,2,12600000.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3715,8119,1193,40720,1548,2,67,2,2646000.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3716,8119,1193,40720,1548,2,13,1,15246000.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3717,8119,1194,40720,1548,2,96,2,187980.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3718,8119,1194,40720,1548,2,67,2,39475.80,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3719,8119,1194,40720,1548,2,13,1,227455.80,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3720,8119,1195,40720,1548,2,96,2,246960.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3721,8119,1195,40720,1548,2,67,2,51861.60,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3722,8119,1195,40720,1548,2,13,1,298821.60,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3723,8119,1196,40720,1548,2,96,2,1260000.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3724,8119,1196,40720,1548,2,67,2,264600.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3725,8119,1196,40720,1548,2,13,1,1524600.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3726,8119,1197,40720,1548,2,96,2,325000.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3727,8119,1197,40720,1548,2,67,2,68250.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3728,8119,1197,40720,1548,2,13,1,393250.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3729,8119,1198,40720,1548,2,96,1,12600000.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3730,8119,1198,40720,1548,2,68,1,2646000.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3731,8119,1198,40720,1548,2,13,2,15246000.00,NULL,'2023-02-16 09:11:42','2023-02-16 09:11:42',NULL),(3732,8119,1199,40720,1548,3,217,1,28752.20,NULL,'2023-02-16 09:11:49','2023-02-16 09:11:49',NULL),(3733,8119,1199,40720,1548,3,68,1,6037.96,NULL,'2023-02-16 09:11:49','2023-02-16 09:11:49',NULL),(3734,8119,1199,40720,1548,3,57,2,34790.16,NULL,'2023-02-16 09:11:49','2023-02-16 09:11:49',NULL),(3735,8119,1200,40720,1548,3,217,1,54809.30,NULL,'2023-02-16 09:11:49','2023-02-16 09:11:49',NULL),(3736,8119,1200,40720,1548,3,68,1,11509.95,NULL,'2023-02-16 09:11:49','2023-02-16 09:11:49',NULL),(3737,8119,1200,40720,1548,3,217,1,0.01,NULL,'2023-02-16 09:11:49','2023-02-16 09:11:49',NULL),(3738,8119,1200,40720,1548,3,57,2,66319.26,NULL,'2023-02-16 09:11:49','2023-02-16 09:11:49',NULL),(3739,8119,1201,40720,1548,3,250,1,0.00,NULL,'2023-02-16 09:11:49','2023-02-16 09:15:26','2023-02-16 09:15:26'),(3740,8119,1201,40720,1548,3,250,1,2880.00,NULL,'2023-02-16 09:11:49','2023-02-16 09:15:26','2023-02-16 09:15:26'),(3741,8119,1201,40720,1548,3,57,2,2880.00,NULL,'2023-02-16 09:11:50','2023-02-16 09:15:26','2023-02-16 09:15:26'),(3742,8119,1202,40720,1548,3,217,1,12809.92,NULL,'2023-02-16 09:11:50','2023-02-16 09:15:21','2023-02-16 09:15:21');
INSERT INTO `balance_libro_details` VALUES (3743,8119,1202,40720,1548,3,68,1,2690.08,NULL,'2023-02-16 09:11:50','2023-02-16 09:15:21','2023-02-16 09:15:21'),(3744,8119,1202,40720,1548,3,57,2,15500.00,NULL,'2023-02-16 09:11:50','2023-02-16 09:15:21','2023-02-16 09:15:21'),(3745,8119,1203,40720,1548,3,217,1,40037.14,NULL,'2023-02-16 09:11:50','2023-02-16 09:15:07','2023-02-16 09:15:07'),(3746,8119,1203,40720,1548,3,68,1,4203.90,NULL,'2023-02-16 09:11:50','2023-02-16 09:15:07','2023-02-16 09:15:07'),(3747,8119,1203,40720,1548,3,57,2,44241.04,NULL,'2023-02-16 09:11:50','2023-02-16 09:15:07','2023-02-16 09:15:07'),(3748,8119,1204,40720,1548,3,217,1,136080.00,NULL,'2023-02-16 09:14:04','2023-02-16 09:14:04',NULL),(3749,8119,1204,40720,1548,3,68,1,28576.80,NULL,'2023-02-16 09:14:04','2023-02-16 09:14:04',NULL),(3750,8119,1204,40720,1548,3,57,2,164656.80,NULL,'2023-02-16 09:14:04','2023-02-16 09:14:04',NULL),(3751,8119,1205,40775,18806,2,96,2,214800.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:09:31','2023-02-19 12:09:31'),(3752,8119,1205,40775,18806,2,67,2,45108.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:09:31','2023-02-19 12:09:31'),(3753,8119,1205,40775,18806,2,13,1,259908.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:09:31','2023-02-19 12:09:31'),(3754,8119,1206,40775,18806,2,96,2,26600.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:09:57','2023-02-19 12:09:57'),(3755,8119,1206,40775,18806,2,67,2,5586.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:09:57','2023-02-19 12:09:57'),(3756,8119,1206,40775,18806,2,13,1,32186.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:09:57','2023-02-19 12:09:57'),(3757,8119,1207,40775,18806,2,96,2,11500.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:11:05','2023-02-19 12:11:05'),(3758,8119,1207,40775,18806,2,67,2,2415.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:11:05','2023-02-19 12:11:05'),(3759,8119,1207,40775,18806,2,13,1,13915.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:11:05','2023-02-19 12:11:05'),(3760,8119,1208,40775,18806,2,96,2,5508.26,NULL,'2023-02-19 12:07:35','2023-02-19 12:11:47','2023-02-19 12:11:47'),(3761,8119,1208,40775,18806,2,67,2,1156.74,NULL,'2023-02-19 12:07:35','2023-02-19 12:11:47','2023-02-19 12:11:47'),(3762,8119,1208,40775,18806,2,13,1,6665.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:11:47','2023-02-19 12:11:47'),(3763,8119,1209,40775,18806,2,218,2,0.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:12:42','2023-02-19 12:12:42'),(3764,8119,1209,40775,18806,2,218,2,42000.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:12:42','2023-02-19 12:12:42'),(3765,8119,1209,40775,18806,2,13,1,42000.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:12:42','2023-02-19 12:12:42'),(3766,8119,1210,40775,18806,2,218,2,0.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:12:59','2023-02-19 12:12:59'),(3767,8119,1210,40775,18806,2,218,2,178000.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:12:59','2023-02-19 12:12:59'),(3768,8119,1210,40775,18806,2,13,1,178000.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:12:59','2023-02-19 12:12:59'),(3769,8119,1211,40775,18806,2,218,2,0.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:48:14','2023-02-19 12:48:14'),(3770,8119,1211,40775,18806,2,218,2,28500.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:48:14','2023-02-19 12:48:14'),(3771,8119,1211,40775,18806,2,13,1,28500.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:48:14','2023-02-19 12:48:14'),(3772,8119,1212,40775,18806,2,96,2,44900.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:10:50','2023-02-19 12:10:50'),(3773,8119,1212,40775,18806,2,67,2,9429.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:10:50','2023-02-19 12:10:50'),(3774,8119,1212,40775,18806,2,13,1,54329.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:10:50','2023-02-19 12:10:50'),(3775,8119,1213,40775,18806,2,218,2,0.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:42:56','2023-02-19 12:42:56'),(3776,8119,1213,40775,18806,2,218,2,66500.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:42:56','2023-02-19 12:42:56'),(3777,8119,1213,40775,18806,2,13,1,66500.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:42:56','2023-02-19 12:42:56');
INSERT INTO `balance_libro_details` VALUES (3778,8119,1214,40775,18806,2,218,2,0.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:41:28','2023-02-19 12:41:28'),(3779,8119,1214,40775,18806,2,218,2,133000.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:41:28','2023-02-19 12:41:28'),(3780,8119,1214,40775,18806,2,13,1,133000.00,NULL,'2023-02-19 12:07:35','2023-02-19 12:41:28','2023-02-19 12:41:28'),(3781,8119,1215,40775,18806,3,217,1,22746.23,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3782,8119,1215,40775,18806,3,68,1,4776.71,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3783,8119,1215,40775,18806,3,57,2,27522.94,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3784,8119,1216,40775,18806,3,217,1,8278.64,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3785,8119,1216,40775,18806,3,68,1,1738.51,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3786,8119,1216,40775,18806,3,217,1,1420.32,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3787,8119,1216,40775,18806,3,57,2,11437.47,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3788,8119,1217,40775,18806,3,250,1,13499.00,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3789,8119,1217,40775,18806,3,57,2,13499.00,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3790,8119,1218,40775,18806,3,217,1,992.40,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3791,8119,1218,40775,18806,3,68,1,208.40,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3792,8119,1218,40775,18806,3,57,2,1200.80,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3793,8119,1219,40775,18806,3,217,1,3424.44,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3794,8119,1219,40775,18806,3,68,1,719.13,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3795,8119,1219,40775,18806,3,217,1,963.45,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3796,8119,1219,40775,18806,3,57,2,5107.02,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3797,8119,1220,40775,18806,3,217,1,6573.51,NULL,'2023-02-19 12:08:32','2023-02-28 12:46:16','2023-02-28 12:46:16'),(3798,8119,1220,40775,18806,3,68,1,1380.44,NULL,'2023-02-19 12:08:32','2023-02-28 12:46:16','2023-02-28 12:46:16'),(3799,8119,1220,40775,18806,3,217,1,13.53,NULL,'2023-02-19 12:08:32','2023-02-28 12:46:16','2023-02-28 12:46:16'),(3800,8119,1220,40775,18806,3,57,2,7967.48,NULL,'2023-02-19 12:08:32','2023-02-28 12:46:16','2023-02-28 12:46:16'),(3801,8119,1221,40775,18806,3,217,1,17899.47,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3802,8119,1221,40775,18806,3,68,1,3758.89,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3803,8119,1221,40775,18806,3,217,1,2058.44,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3804,8119,1221,40775,18806,3,57,2,23716.80,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3805,8119,1222,40775,18806,3,217,1,2217.31,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3806,8119,1222,40775,18806,3,68,1,465.64,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3807,8119,1222,40775,18806,3,217,1,380.41,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3808,8119,1222,40775,18806,3,57,2,3063.36,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3809,8119,1223,40775,18806,3,217,1,1365.36,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3810,8119,1223,40775,18806,3,68,1,286.73,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3811,8119,1223,40775,18806,3,57,2,1652.09,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3812,8119,1224,40775,18806,3,217,1,7866.94,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3813,8119,1224,40775,18806,3,68,1,1652.06,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3814,8119,1224,40775,18806,3,57,2,9519.00,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3815,8119,1225,40775,18806,3,250,1,0.00,NULL,'2023-02-19 12:08:32','2023-02-28 12:46:04','2023-02-28 12:46:04'),(3816,8119,1225,40775,18806,3,250,1,1800.00,NULL,'2023-02-19 12:08:32','2023-02-28 12:46:04','2023-02-28 12:46:04');
INSERT INTO `balance_libro_details` VALUES (3817,8119,1225,40775,18806,3,57,2,1800.00,NULL,'2023-02-19 12:08:32','2023-02-28 12:46:04','2023-02-28 12:46:04'),(3818,8119,1226,40775,18806,3,217,1,2947.21,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3819,8119,1226,40775,18806,3,68,1,618.91,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3820,8119,1226,40775,18806,3,57,2,3566.12,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3821,8119,1227,40775,18806,3,217,1,15701.65,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3822,8119,1227,40775,18806,3,68,1,3297.35,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3823,8119,1227,40775,18806,3,57,2,18999.00,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3824,8119,1228,40775,18806,3,217,1,329.68,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3825,8119,1228,40775,18806,3,68,1,69.23,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3826,8119,1228,40775,18806,3,57,2,398.91,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3827,8119,1229,40775,18806,3,217,1,2739.55,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3828,8119,1229,40775,18806,3,68,1,575.31,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3829,8119,1229,40775,18806,3,217,1,770.76,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3830,8119,1229,40775,18806,3,57,2,4085.62,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3831,8119,1230,40775,18806,3,217,1,9090.93,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3832,8119,1230,40775,18806,3,68,1,1909.10,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3833,8119,1230,40775,18806,3,57,2,11000.03,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3834,8119,1231,40775,18806,3,217,1,20646.86,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3835,8119,1231,40775,18806,3,68,1,4335.84,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3836,8119,1231,40775,18806,3,57,2,24982.70,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3837,8119,1232,40775,18806,3,217,1,3424.44,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3838,8119,1232,40775,18806,3,68,1,719.13,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3839,8119,1232,40775,18806,3,217,1,963.45,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3840,8119,1232,40775,18806,3,57,2,5107.02,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3841,8119,1233,40775,18806,3,217,1,3451.50,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3842,8119,1233,40775,18806,3,68,1,724.82,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3843,8119,1233,40775,18806,3,217,1,930.56,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3844,8119,1233,40775,18806,3,57,2,5106.88,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3845,8119,1234,40775,18806,3,217,1,4681.26,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3846,8119,1234,40775,18806,3,68,1,983.06,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3847,8119,1234,40775,18806,3,57,2,5664.32,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3848,8119,1235,40775,18806,3,217,1,3483.70,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3849,8119,1235,40775,18806,3,68,1,731.58,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3850,8119,1235,40775,18806,3,57,2,4215.28,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3851,8119,1236,40775,18806,3,217,1,22148.76,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3852,8119,1236,40775,18806,3,68,1,4651.24,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3853,8119,1236,40775,18806,3,57,2,26800.00,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3854,8119,1237,40775,18806,3,217,1,6440.64,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3855,8119,1237,40775,18806,3,68,1,1352.53,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3856,8119,1237,40775,18806,3,217,1,1052.49,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL);
INSERT INTO `balance_libro_details` VALUES (3857,8119,1237,40775,18806,3,57,2,8845.66,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3858,8119,1238,40775,18806,3,217,1,1527.34,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3859,8119,1238,40775,18806,3,68,1,320.74,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3860,8119,1238,40775,18806,3,57,2,1848.08,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3861,8119,1239,40775,18806,3,217,1,21654.52,NULL,'2023-02-19 12:08:32','2023-02-19 12:08:32',NULL),(3862,8119,1239,40775,18806,3,68,1,4547.45,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3863,8119,1239,40775,18806,3,57,2,26201.97,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3864,8119,1240,40775,18806,3,217,1,2957.23,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3865,8119,1240,40775,18806,3,68,1,621.02,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3866,8119,1240,40775,18806,3,217,1,506.63,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3867,8119,1240,40775,18806,3,57,2,4084.88,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3868,8119,1241,40775,18806,3,217,1,4200.67,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3869,8119,1241,40775,18806,3,68,1,882.14,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3870,8119,1241,40775,18806,3,217,1,840.65,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3871,8119,1241,40775,18806,3,57,2,5923.46,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3872,8119,1242,40775,18806,3,217,1,107252.12,NULL,'2023-02-19 12:08:33','2023-02-28 12:48:53','2023-02-28 12:48:53'),(3873,8119,1242,40775,18806,3,68,1,14735.61,NULL,'2023-02-19 12:08:33','2023-02-28 12:48:53','2023-02-28 12:48:53'),(3874,8119,1242,40775,18806,3,57,2,121987.73,NULL,'2023-02-19 12:08:33','2023-02-28 12:48:53','2023-02-28 12:48:53'),(3875,8119,1243,40775,18806,3,217,1,3633.20,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3876,8119,1243,40775,18806,3,68,1,762.97,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3877,8119,1243,40775,18806,3,57,2,4396.17,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3878,8119,1244,40775,18806,3,217,1,1325.00,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3879,8119,1244,40775,18806,3,68,1,278.25,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3880,8119,1244,40775,18806,3,57,2,1603.25,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3881,8119,1245,40775,18806,3,217,1,72661.16,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3882,8119,1245,40775,18806,3,68,1,15258.84,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3883,8119,1245,40775,18806,3,57,2,87920.00,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3884,8119,1246,40775,18806,3,217,1,7540.80,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3885,8119,1246,40775,18806,3,68,1,1583.57,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3886,8119,1246,40775,18806,3,217,1,1291.87,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3887,8119,1246,40775,18806,3,57,2,10416.24,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3888,8119,1247,40775,18806,3,217,1,2206.98,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3889,8119,1247,40775,18806,3,68,1,463.47,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3890,8119,1247,40775,18806,3,57,2,2670.45,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3891,8119,1248,40775,18806,3,217,1,6169.49,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3892,8119,1248,40775,18806,3,68,1,1295.59,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3893,8119,1248,40775,18806,3,57,2,7465.08,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3894,8119,1249,40775,18806,3,217,1,358.79,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3895,8119,1249,40775,18806,3,68,1,75.34,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3896,8119,1249,40775,18806,3,57,2,434.13,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL);
INSERT INTO `balance_libro_details` VALUES (3897,8119,1250,40775,18806,3,250,1,46000.00,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3898,8119,1250,40775,18806,3,57,2,46000.00,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3899,8119,1251,40775,18806,3,217,1,2184.75,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3900,8119,1251,40775,18806,3,68,1,458.80,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3901,8119,1251,40775,18806,3,57,2,2643.55,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3902,8119,1252,40775,18806,3,217,1,4870.68,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3903,8119,1252,40775,18806,3,68,1,1022.84,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3904,8119,1252,40775,18806,3,217,1,948.71,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3905,8119,1252,40775,18806,3,57,2,6842.23,NULL,'2023-02-19 12:08:33','2023-02-19 12:08:33',NULL),(3906,8119,1253,40775,18806,2,96,2,214800.00,NULL,'2023-02-19 12:09:31','2023-02-19 12:09:42','2023-02-19 12:09:42'),(3907,8119,1253,40775,18806,2,67,2,45108.00,NULL,'2023-02-19 12:09:31','2023-02-19 12:09:42','2023-02-19 12:09:42'),(3908,8119,1253,40775,18806,2,13,1,259908.00,NULL,'2023-02-19 12:09:31','2023-02-19 12:09:42','2023-02-19 12:09:42'),(3909,8119,1254,40775,18806,2,96,2,214800.00,NULL,'2023-02-19 12:09:42','2023-02-19 12:09:42',NULL),(3910,8119,1254,40775,18806,2,67,2,45108.00,NULL,'2023-02-19 12:09:42','2023-02-19 12:09:42',NULL),(3911,8119,1254,40775,18806,2,13,1,259908.00,NULL,'2023-02-19 12:09:42','2023-02-19 12:09:42',NULL),(3912,8119,1255,40775,18806,2,96,2,26600.00,NULL,'2023-02-19 12:09:57','2023-02-19 12:09:57',NULL),(3913,8119,1255,40775,18806,2,67,2,5586.00,NULL,'2023-02-19 12:09:57','2023-02-19 12:09:57',NULL),(3914,8119,1255,40775,18806,2,13,1,32186.00,NULL,'2023-02-19 12:09:57','2023-02-19 12:09:57',NULL),(3915,8119,1256,40775,18806,2,96,2,44900.00,NULL,'2023-02-19 12:10:50','2023-02-19 12:10:50',NULL),(3916,8119,1256,40775,18806,2,67,2,9429.00,NULL,'2023-02-19 12:10:50','2023-02-19 12:10:50',NULL),(3917,8119,1256,40775,18806,2,13,1,54329.00,NULL,'2023-02-19 12:10:50','2023-02-19 12:10:50',NULL),(3918,8119,1257,40775,18806,2,96,2,11500.00,NULL,'2023-02-19 12:11:05','2023-02-19 12:11:05',NULL),(3919,8119,1257,40775,18806,2,67,2,2415.00,NULL,'2023-02-19 12:11:05','2023-02-19 12:11:05',NULL),(3920,8119,1257,40775,18806,2,13,1,13915.00,NULL,'2023-02-19 12:11:05','2023-02-19 12:11:05',NULL),(3921,8119,1258,40775,18806,2,96,2,5508.26,NULL,'2023-02-19 12:11:47','2023-02-19 12:11:47',NULL),(3922,8119,1258,40775,18806,2,67,2,1156.73,NULL,'2023-02-19 12:11:47','2023-02-19 12:11:47',NULL),(3923,8119,1258,40775,18806,2,13,1,6664.99,NULL,'2023-02-19 12:11:47','2023-02-19 12:11:47',NULL),(3924,8119,1259,40775,18806,2,218,2,42000.00,NULL,'2023-02-19 12:12:42','2023-02-19 12:44:56','2023-02-19 12:44:56'),(3925,8119,1259,40775,18806,2,13,1,42000.00,NULL,'2023-02-19 12:12:42','2023-02-19 12:44:56','2023-02-19 12:44:56'),(3926,8119,1260,40775,18806,2,218,2,178000.00,NULL,'2023-02-19 12:12:59','2023-02-19 12:47:40','2023-02-19 12:47:40'),(3927,8119,1260,40775,18806,2,13,1,178000.00,NULL,'2023-02-19 12:12:59','2023-02-19 12:47:40','2023-02-19 12:47:40'),(3928,8119,1261,40775,18806,2,96,2,633333.33,NULL,'2023-02-19 12:41:28','2023-02-19 12:41:40','2023-02-19 12:41:40'),(3929,8119,1261,40775,18806,2,67,2,133000.00,NULL,'2023-02-19 12:41:28','2023-02-19 12:41:40','2023-02-19 12:41:40'),(3930,8119,1261,40775,18806,2,218,2,133000.00,NULL,'2023-02-19 12:41:28','2023-02-19 12:41:40','2023-02-19 12:41:40'),(3931,8119,1261,40775,18806,2,13,1,899333.33,NULL,'2023-02-19 12:41:28','2023-02-19 12:41:40','2023-02-19 12:41:40'),(3932,8119,1262,40775,18806,2,96,2,633333.33,NULL,'2023-02-19 12:41:40','2023-02-28 12:33:16','2023-02-28 12:33:16'),(3933,8119,1262,40775,18806,2,67,2,133000.00,NULL,'2023-02-19 12:41:40','2023-02-28 12:33:16','2023-02-28 12:33:16'),(3934,8119,1262,40775,18806,2,13,1,766333.33,NULL,'2023-02-19 12:41:40','2023-02-28 12:33:16','2023-02-28 12:33:16');
INSERT INTO `balance_libro_details` VALUES (3935,8119,1263,40775,18806,2,96,2,316667.49,NULL,'2023-02-19 12:42:56','2023-02-19 12:43:07','2023-02-19 12:43:07'),(3936,8119,1263,40775,18806,2,67,2,66500.17,NULL,'2023-02-19 12:42:56','2023-02-19 12:43:07','2023-02-19 12:43:07'),(3937,8119,1263,40775,18806,2,96,2,373822.11,NULL,'2023-02-19 12:42:56','2023-02-19 12:43:07','2023-02-19 12:43:07'),(3938,8119,1263,40775,18806,2,67,2,9345.55,NULL,'2023-02-19 12:42:56','2023-02-19 12:43:07','2023-02-19 12:43:07'),(3939,8119,1263,40775,18806,2,13,1,766335.33,NULL,'2023-02-19 12:42:56','2023-02-19 12:43:07','2023-02-19 12:43:07'),(3940,8119,1263,40775,18806,2,136,2,0.01,NULL,'2023-02-19 12:42:56','2023-02-19 12:43:07','2023-02-19 12:43:07'),(3941,8119,1264,40775,18806,2,96,2,316667.49,NULL,'2023-02-19 12:43:07','2023-02-28 12:33:36','2023-02-28 12:33:36'),(3942,8119,1264,40775,18806,2,67,2,66500.17,NULL,'2023-02-19 12:43:07','2023-02-28 12:33:36','2023-02-28 12:33:36'),(3943,8119,1264,40775,18806,2,13,1,383167.66,NULL,'2023-02-19 12:43:07','2023-02-28 12:33:36','2023-02-28 12:33:36'),(3944,8119,1265,40775,18806,2,96,2,200000.00,NULL,'2023-02-19 12:44:56','2023-02-19 12:45:27','2023-02-19 12:45:27'),(3945,8119,1265,40775,18806,2,67,2,4200.00,NULL,'2023-02-19 12:44:56','2023-02-19 12:45:27','2023-02-19 12:45:27'),(3946,8119,1265,40775,18806,2,13,1,204200.00,NULL,'2023-02-19 12:44:56','2023-02-19 12:45:27','2023-02-19 12:45:27'),(3947,8119,1266,40775,18806,2,96,2,200000.00,NULL,'2023-02-19 12:45:27','2023-02-19 12:46:49','2023-02-19 12:46:49'),(3948,8119,1266,40775,18806,2,67,2,420000.00,NULL,'2023-02-19 12:45:27','2023-02-19 12:46:49','2023-02-19 12:46:49'),(3949,8119,1266,40775,18806,2,13,1,620000.00,NULL,'2023-02-19 12:45:27','2023-02-19 12:46:49','2023-02-19 12:46:49'),(3950,8119,1267,40775,18806,2,96,2,200000.00,NULL,'2023-02-19 12:46:49','2023-02-28 12:35:36','2023-02-28 12:35:36'),(3951,8119,1267,40775,18806,2,67,2,42000.00,NULL,'2023-02-19 12:46:49','2023-02-28 12:35:36','2023-02-28 12:35:36'),(3952,8119,1267,40775,18806,2,13,1,242000.00,NULL,'2023-02-19 12:46:49','2023-02-28 12:35:36','2023-02-28 12:35:36'),(3953,8119,1268,40775,18806,2,96,2,847619.05,NULL,'2023-02-19 12:47:40','2023-02-28 12:34:14','2023-02-28 12:34:14'),(3954,8119,1268,40775,18806,2,67,2,178000.00,NULL,'2023-02-19 12:47:40','2023-02-28 12:34:14','2023-02-28 12:34:14'),(3955,8119,1268,40775,18806,2,13,1,1025619.05,NULL,'2023-02-19 12:47:40','2023-02-28 12:34:14','2023-02-28 12:34:14'),(3956,8119,1269,40775,18806,2,96,2,135714.29,NULL,'2023-02-19 12:48:14','2023-02-28 12:33:57','2023-02-28 12:33:57'),(3957,8119,1269,40775,18806,2,67,2,28500.00,NULL,'2023-02-19 12:48:14','2023-02-28 12:33:57','2023-02-28 12:33:57'),(3958,8119,1269,40775,18806,2,13,1,164214.29,NULL,'2023-02-19 12:48:14','2023-02-28 12:33:57','2023-02-28 12:33:57'),(3959,8119,1270,40767,6496,2,218,2,4900.00,NULL,'2023-02-19 13:12:56','2023-02-19 13:15:39','2023-02-19 13:15:39'),(3960,8119,1270,40767,6496,2,13,1,4900.00,NULL,'2023-02-19 13:12:56','2023-02-19 13:15:39','2023-02-19 13:15:39'),(3961,8119,1271,40767,6496,2,218,2,40000.00,NULL,'2023-02-19 13:12:56','2023-02-19 13:58:39','2023-02-19 13:58:39'),(3962,8119,1271,40767,6496,2,13,1,40000.00,NULL,'2023-02-19 13:12:56','2023-02-19 13:58:39','2023-02-19 13:58:39'),(3963,8119,1272,40767,6496,2,218,2,8350.00,NULL,'2023-02-19 13:12:56','2023-02-19 13:15:56','2023-02-19 13:15:56'),(3964,8119,1272,40767,6496,2,13,1,8350.00,NULL,'2023-02-19 13:12:56','2023-02-19 13:15:56','2023-02-19 13:15:56'),(3965,8119,1273,40767,6496,2,218,2,32000.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:16:16','2023-02-19 13:16:16'),(3966,8119,1273,40767,6496,2,13,1,32000.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:16:16','2023-02-19 13:16:16'),(3967,8119,1274,40767,6496,2,218,2,15500.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:16:37','2023-02-19 13:16:37'),(3968,8119,1274,40767,6496,2,13,1,15500.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:16:37','2023-02-19 13:16:37');
INSERT INTO `balance_libro_details` VALUES (3969,8119,1275,40767,6496,2,218,2,17500.00,NULL,'2023-02-19 13:12:57','2023-02-19 14:00:51','2023-02-19 14:00:51'),(3970,8119,1275,40767,6496,2,13,1,17500.00,NULL,'2023-02-19 13:12:57','2023-02-19 14:00:51','2023-02-19 14:00:51'),(3971,8119,1276,40767,6496,2,218,2,8050.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:55:24','2023-02-19 13:55:24'),(3972,8119,1276,40767,6496,2,13,1,8050.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:55:24','2023-02-19 13:55:24'),(3973,8119,1277,40767,6496,2,218,2,45000.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:55:37','2023-02-19 13:55:37'),(3974,8119,1277,40767,6496,2,13,1,45000.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:55:37','2023-02-19 13:55:37'),(3975,8119,1278,40767,6496,2,218,2,32000.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:55:57','2023-02-19 13:55:57'),(3976,8119,1278,40767,6496,2,13,1,32000.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:55:57','2023-02-19 13:55:57'),(3977,8119,1279,40767,6496,2,218,2,7500.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:56:07','2023-02-19 13:56:07'),(3978,8119,1279,40767,6496,2,13,1,7500.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:56:07','2023-02-19 13:56:07'),(3979,8119,1280,40767,6496,2,218,2,22150.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:56:22','2023-02-19 13:56:22'),(3980,8119,1280,40767,6496,2,13,1,22150.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:56:22','2023-02-19 13:56:22'),(3981,8119,1281,40767,6496,2,218,2,25050.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:56:37','2023-02-19 13:56:37'),(3982,8119,1281,40767,6496,2,13,1,25050.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:56:37','2023-02-19 13:56:37'),(3983,8119,1282,40767,6496,2,218,2,15050.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:56:48','2023-02-19 13:56:48'),(3984,8119,1282,40767,6496,2,13,1,15050.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:56:48','2023-02-19 13:56:48'),(3985,8119,1283,40767,6496,2,218,2,16700.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:57:03','2023-02-19 13:57:03'),(3986,8119,1283,40767,6496,2,13,1,16700.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:57:03','2023-02-19 13:57:03'),(3987,8119,1284,40767,6496,2,218,2,29500.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:57:11','2023-02-19 13:57:11'),(3988,8119,1284,40767,6496,2,13,1,29500.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:57:11','2023-02-19 13:57:11'),(3989,8119,1285,40767,6496,2,218,2,26000.00,NULL,'2023-02-19 13:12:57','2023-02-19 14:01:01','2023-02-19 14:01:01'),(3990,8119,1285,40767,6496,2,13,1,26000.00,NULL,'2023-02-19 13:12:57','2023-02-19 14:01:01','2023-02-19 14:01:01'),(3991,8119,1286,40767,6496,2,218,2,9500.00,NULL,'2023-02-19 13:12:57','2023-02-19 14:01:09','2023-02-19 14:01:09'),(3992,8119,1286,40767,6496,2,13,1,9500.00,NULL,'2023-02-19 13:12:57','2023-02-19 14:01:09','2023-02-19 14:01:09'),(3993,8119,1287,40767,6496,2,218,2,8500.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:57:42','2023-02-19 13:57:42'),(3994,8119,1287,40767,6496,2,13,1,8500.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:57:42','2023-02-19 13:57:42'),(3995,8119,1288,40767,6496,2,218,2,33000.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:57:53','2023-02-19 13:57:53'),(3996,8119,1288,40767,6496,2,13,1,33000.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:57:53','2023-02-19 13:57:53'),(3997,8119,1289,40767,6496,2,218,2,9000.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:58:07','2023-02-19 13:58:07'),(3998,8119,1289,40767,6496,2,13,1,9000.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:58:07','2023-02-19 13:58:07'),(3999,8119,1290,40767,6496,2,218,2,33000.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:58:16','2023-02-19 13:58:16'),(4000,8119,1290,40767,6496,2,13,1,33000.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:58:16','2023-02-19 13:58:16'),(4001,8119,1291,40767,6496,2,218,2,13090.00,NULL,'2023-02-19 13:12:57','2023-02-19 14:01:19','2023-02-19 14:01:19'),(4002,8119,1291,40767,6496,2,13,1,13090.00,NULL,'2023-02-19 13:12:57','2023-02-19 14:01:19','2023-02-19 14:01:19');
INSERT INTO `balance_libro_details` VALUES (4003,8119,1292,40767,6496,2,218,2,10600.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:59:02','2023-02-19 13:59:02'),(4004,8119,1292,40767,6496,2,13,1,10600.00,NULL,'2023-02-19 13:12:57','2023-02-19 13:59:02','2023-02-19 13:59:02'),(4005,8119,1293,40767,6496,3,217,1,19600.00,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4006,8119,1293,40767,6496,3,68,1,4116.00,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4007,8119,1293,40767,6496,3,57,2,23716.00,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4008,8119,1294,40767,6496,3,217,1,3966.94,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4009,8119,1294,40767,6496,3,68,1,833.06,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4010,8119,1294,40767,6496,3,57,2,4800.00,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4011,8119,1295,40767,6496,3,217,1,865.48,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4012,8119,1295,40767,6496,3,68,1,181.75,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4013,8119,1295,40767,6496,3,57,2,1047.23,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4014,8119,1296,40767,6496,3,217,1,865.48,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4015,8119,1296,40767,6496,3,68,1,181.75,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4016,8119,1296,40767,6496,3,57,2,1047.23,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4017,8119,1297,40767,6496,3,217,1,872.25,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4018,8119,1297,40767,6496,3,68,1,183.17,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4019,8119,1297,40767,6496,3,57,2,1055.42,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4020,8119,1298,40767,6496,3,217,1,872.25,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4021,8119,1298,40767,6496,3,68,1,183.17,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4022,8119,1298,40767,6496,3,57,2,1055.42,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4023,8119,1299,40767,6496,3,217,1,865.48,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4024,8119,1299,40767,6496,3,68,1,181.75,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4025,8119,1299,40767,6496,3,57,2,1047.23,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4026,8119,1300,40767,6496,3,217,1,549.96,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4027,8119,1300,40767,6496,3,68,1,115.49,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4028,8119,1300,40767,6496,3,57,2,665.45,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4029,8119,1301,40767,6496,3,217,1,865.48,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4030,8119,1301,40767,6496,3,68,1,181.75,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4031,8119,1301,40767,6496,3,57,2,1047.23,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4032,8119,1302,40767,6496,3,217,1,49.59,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4033,8119,1302,40767,6496,3,68,1,10.41,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4034,8119,1302,40767,6496,3,57,2,60.00,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4035,8119,1303,40767,6496,3,217,1,822.31,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4036,8119,1303,40767,6496,3,68,1,172.69,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4037,8119,1303,40767,6496,3,57,2,995.00,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4038,8119,1304,40767,6496,3,217,1,478.66,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4039,8119,1304,40767,6496,3,68,1,100.52,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4040,8119,1304,40767,6496,3,57,2,579.18,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4041,8119,1305,40767,6496,3,217,1,865.48,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4042,8119,1305,40767,6496,3,68,1,181.75,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL),(4043,8119,1305,40767,6496,3,57,2,1047.23,NULL,'2023-02-19 13:13:30','2023-02-19 13:13:30',NULL);
INSERT INTO `balance_libro_details` VALUES (4044,8119,1306,40767,6496,3,217,1,794.52,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4045,8119,1306,40767,6496,3,68,1,166.85,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4046,8119,1306,40767,6496,3,57,2,961.37,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4047,8119,1307,40767,6496,3,217,1,56.20,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4048,8119,1307,40767,6496,3,68,1,11.80,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4049,8119,1307,40767,6496,3,57,2,68.00,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4050,8119,1308,40767,6496,3,217,1,42.15,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4051,8119,1308,40767,6496,3,68,1,8.85,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4052,8119,1308,40767,6496,3,57,2,51.00,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4053,8119,1309,40767,6496,3,217,1,109504.13,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4054,8119,1309,40767,6496,3,68,1,22995.87,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4055,8119,1309,40767,6496,3,57,2,132500.00,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4056,8119,1310,40767,6496,3,217,1,1304.40,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4057,8119,1310,40767,6496,3,68,1,273.92,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4058,8119,1310,40767,6496,3,217,1,42.39,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4059,8119,1310,40767,6496,3,57,2,1620.71,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4060,8119,1311,40767,6496,3,217,1,865.48,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4061,8119,1311,40767,6496,3,68,1,181.75,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4062,8119,1311,40767,6496,3,57,2,1047.23,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4063,8119,1312,40767,6496,3,217,1,794.52,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4064,8119,1312,40767,6496,3,68,1,166.85,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4065,8119,1312,40767,6496,3,57,2,961.37,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4066,8119,1313,40767,6496,3,217,1,560.00,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4067,8119,1313,40767,6496,3,68,1,117.60,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4068,8119,1313,40767,6496,3,57,2,677.60,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4069,8119,1314,40767,6496,3,250,1,0.00,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4070,8119,1314,40767,6496,3,250,1,420.00,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4071,8119,1314,40767,6496,3,57,2,420.00,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4072,8119,1315,40767,6496,3,250,1,0.00,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4073,8119,1315,40767,6496,3,250,1,150.00,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4074,8119,1315,40767,6496,3,57,2,150.00,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4075,8119,1316,40767,6496,3,217,1,865.48,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4076,8119,1316,40767,6496,3,68,1,181.75,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4077,8119,1316,40767,6496,3,57,2,1047.23,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4078,8119,1317,40767,6496,3,217,1,794.52,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4079,8119,1317,40767,6496,3,68,1,166.85,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4080,8119,1317,40767,6496,3,57,2,961.37,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4081,8119,1318,40767,6496,3,217,1,872.25,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4082,8119,1318,40767,6496,3,68,1,183.17,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4083,8119,1318,40767,6496,3,57,2,1055.42,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4084,8119,1319,40767,6496,3,217,1,865.48,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL);
INSERT INTO `balance_libro_details` VALUES (4085,8119,1319,40767,6496,3,68,1,181.75,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4086,8119,1319,40767,6496,3,57,2,1047.23,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4087,8119,1320,40767,6496,3,217,1,865.48,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4088,8119,1320,40767,6496,3,68,1,181.75,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4089,8119,1320,40767,6496,3,57,2,1047.23,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4090,8119,1321,40767,6496,3,217,1,865.48,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4091,8119,1321,40767,6496,3,68,1,181.75,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4092,8119,1321,40767,6496,3,57,2,1047.23,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4093,8119,1322,40767,6496,3,217,1,128423.81,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4094,8119,1322,40767,6496,3,68,1,26969.00,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4095,8119,1322,40767,6496,3,57,2,155392.81,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4096,8119,1323,40767,6496,3,217,1,526.44,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4097,8119,1323,40767,6496,3,68,1,110.55,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4098,8119,1323,40767,6496,3,57,2,636.99,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4099,8119,1324,40767,6496,3,217,1,794.52,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4100,8119,1324,40767,6496,3,68,1,166.85,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4101,8119,1324,40767,6496,3,57,2,961.37,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4102,8119,1325,40767,6496,3,217,1,526.44,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4103,8119,1325,40767,6496,3,68,1,110.55,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4104,8119,1325,40767,6496,3,57,2,636.99,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4105,8119,1326,40767,6496,3,217,1,23108.56,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4106,8119,1326,40767,6496,3,68,1,4852.80,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4107,8119,1326,40767,6496,3,57,2,27961.36,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4108,8119,1327,40767,6496,3,217,1,12716.65,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4109,8119,1327,40767,6496,3,68,1,2670.50,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4110,8119,1327,40767,6496,3,57,2,15387.15,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4111,8119,1328,40767,6496,3,217,1,826.45,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4112,8119,1328,40767,6496,3,68,1,173.55,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4113,8119,1328,40767,6496,3,57,2,1000.00,NULL,'2023-02-19 13:13:31','2023-02-19 13:13:31',NULL),(4114,8119,1329,40767,6496,2,218,2,4900.00,NULL,'2023-02-19 13:15:39','2023-02-19 13:15:39',NULL),(4115,8119,1329,40767,6496,2,13,1,4900.00,NULL,'2023-02-19 13:15:39','2023-02-19 13:15:39',NULL),(4116,8119,1330,40767,6496,2,218,2,8350.00,NULL,'2023-02-19 13:15:56','2023-02-19 13:15:56',NULL),(4117,8119,1330,40767,6496,2,13,1,8350.00,NULL,'2023-02-19 13:15:56','2023-02-19 13:15:56',NULL),(4118,8119,1331,40767,6496,2,218,2,32000.00,NULL,'2023-02-19 13:16:16','2023-02-19 13:16:16',NULL),(4119,8119,1331,40767,6496,2,13,1,32000.00,NULL,'2023-02-19 13:16:16','2023-02-19 13:16:16',NULL),(4120,8119,1332,40767,6496,2,218,2,15500.00,NULL,'2023-02-19 13:16:37','2023-02-19 13:16:37',NULL),(4121,8119,1332,40767,6496,2,13,1,15500.00,NULL,'2023-02-19 13:16:37','2023-02-19 13:16:37',NULL),(4122,8119,1333,40767,6496,2,218,2,8050.00,NULL,'2023-02-19 13:55:24','2023-02-19 13:55:24',NULL),(4123,8119,1333,40767,6496,2,13,1,8050.00,NULL,'2023-02-19 13:55:24','2023-02-19 13:55:24',NULL),(4124,8119,1334,40767,6496,2,218,2,45000.00,NULL,'2023-02-19 13:55:37','2023-02-19 13:55:37',NULL),(4125,8119,1334,40767,6496,2,13,1,45000.00,NULL,'2023-02-19 13:55:37','2023-02-19 13:55:37',NULL);
INSERT INTO `balance_libro_details` VALUES (4126,8119,1335,40767,6496,2,218,2,32000.00,NULL,'2023-02-19 13:55:57','2023-02-19 13:55:57',NULL),(4127,8119,1335,40767,6496,2,13,1,32000.00,NULL,'2023-02-19 13:55:57','2023-02-19 13:55:57',NULL),(4128,8119,1336,40767,6496,2,218,2,7500.00,NULL,'2023-02-19 13:56:07','2023-02-19 13:56:07',NULL),(4129,8119,1336,40767,6496,2,13,1,7500.00,NULL,'2023-02-19 13:56:07','2023-02-19 13:56:07',NULL),(4130,8119,1337,40767,6496,2,218,2,22150.00,NULL,'2023-02-19 13:56:22','2023-02-19 13:56:22',NULL),(4131,8119,1337,40767,6496,2,13,1,22150.00,NULL,'2023-02-19 13:56:22','2023-02-19 13:56:22',NULL),(4132,8119,1338,40767,6496,2,218,2,25050.00,NULL,'2023-02-19 13:56:37','2023-02-19 13:56:37',NULL),(4133,8119,1338,40767,6496,2,13,1,25050.00,NULL,'2023-02-19 13:56:37','2023-02-19 13:56:37',NULL),(4134,8119,1339,40767,6496,2,218,2,15050.00,NULL,'2023-02-19 13:56:48','2023-02-19 13:56:48',NULL),(4135,8119,1339,40767,6496,2,13,1,15050.00,NULL,'2023-02-19 13:56:48','2023-02-19 13:56:48',NULL),(4136,8119,1340,40767,6496,2,218,2,16700.00,NULL,'2023-02-19 13:57:03','2023-02-19 13:57:03',NULL),(4137,8119,1340,40767,6496,2,13,1,16700.00,NULL,'2023-02-19 13:57:03','2023-02-19 13:57:03',NULL),(4138,8119,1341,40767,6496,2,218,2,29500.00,NULL,'2023-02-19 13:57:11','2023-02-19 13:57:11',NULL),(4139,8119,1341,40767,6496,2,13,1,29500.00,NULL,'2023-02-19 13:57:11','2023-02-19 13:57:11',NULL),(4140,8119,1342,40767,6496,2,218,2,8500.00,NULL,'2023-02-19 13:57:42','2023-02-19 13:57:42',NULL),(4141,8119,1342,40767,6496,2,13,1,8500.00,NULL,'2023-02-19 13:57:42','2023-02-19 13:57:42',NULL),(4142,8119,1343,40767,6496,2,218,2,33000.00,NULL,'2023-02-19 13:57:53','2023-02-19 13:57:53',NULL),(4143,8119,1343,40767,6496,2,13,1,33000.00,NULL,'2023-02-19 13:57:53','2023-02-19 13:57:53',NULL),(4144,8119,1344,40767,6496,2,218,2,9000.00,NULL,'2023-02-19 13:58:07','2023-02-19 13:58:07',NULL),(4145,8119,1344,40767,6496,2,13,1,9000.00,NULL,'2023-02-19 13:58:07','2023-02-19 13:58:07',NULL),(4146,8119,1345,40767,6496,2,218,2,33000.00,NULL,'2023-02-19 13:58:16','2023-02-19 13:58:16',NULL),(4147,8119,1345,40767,6496,2,13,1,33000.00,NULL,'2023-02-19 13:58:16','2023-02-19 13:58:16',NULL),(4148,8119,1346,40767,6496,2,218,2,40000.00,NULL,'2023-02-19 13:58:39','2023-02-19 13:58:39',NULL),(4149,8119,1346,40767,6496,2,13,1,40000.00,NULL,'2023-02-19 13:58:39','2023-02-19 13:58:39',NULL),(4150,8119,1347,40767,6496,2,218,2,10600.00,NULL,'2023-02-19 13:59:02','2023-02-19 13:59:02',NULL),(4151,8119,1347,40767,6496,2,13,1,10600.00,NULL,'2023-02-19 13:59:02','2023-02-19 13:59:02',NULL),(4152,8119,1348,40767,6496,2,218,2,17500.00,NULL,'2023-02-19 14:00:51','2023-02-19 14:00:51',NULL),(4153,8119,1348,40767,6496,2,13,1,17500.00,NULL,'2023-02-19 14:00:51','2023-02-19 14:00:51',NULL),(4154,8119,1349,40767,6496,2,218,2,26000.00,NULL,'2023-02-19 14:01:01','2023-02-19 14:01:01',NULL),(4155,8119,1349,40767,6496,2,13,1,26000.00,NULL,'2023-02-19 14:01:01','2023-02-19 14:01:01',NULL),(4156,8119,1350,40767,6496,2,218,2,9500.00,NULL,'2023-02-19 14:01:09','2023-02-19 14:01:09',NULL),(4157,8119,1350,40767,6496,2,13,1,9500.00,NULL,'2023-02-19 14:01:09','2023-02-19 14:01:09',NULL),(4158,8119,1351,40767,6496,2,218,2,13090.00,NULL,'2023-02-19 14:01:19','2023-02-19 14:01:19',NULL),(4159,8119,1351,40767,6496,2,13,1,13090.00,NULL,'2023-02-19 14:01:19','2023-02-19 14:01:19',NULL),(4164,8119,1354,40775,18806,8,277,1,52037.81,NULL,'2023-02-28 12:01:18','2023-02-28 12:01:18',NULL),(4165,8119,1354,40775,18806,8,351,2,52037.81,NULL,'2023-02-28 12:01:18','2023-02-28 12:01:18',NULL),(4166,8119,1355,40775,18806,7,251,1,1165.29,NULL,'2023-02-28 12:10:45','2023-02-28 12:10:45',NULL),(4167,8119,1355,40775,18806,7,13,2,1165.29,NULL,'2023-02-28 12:10:45','2023-02-28 12:10:45',NULL),(4168,8119,1356,40775,18806,7,251,1,2942.15,NULL,'2023-02-28 12:10:46','2023-02-28 12:10:46',NULL),(4169,8119,1356,40775,18806,7,13,2,2942.15,NULL,'2023-02-28 12:10:46','2023-02-28 12:10:46',NULL);
INSERT INTO `balance_libro_details` VALUES (4170,8119,1357,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4171,8119,1357,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4172,8119,1358,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4173,8119,1358,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4174,8119,1359,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4175,8119,1359,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4176,8119,1360,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4177,8119,1360,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4178,8119,1361,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4179,8119,1361,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4180,8119,1362,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4181,8119,1362,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4182,8119,1363,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4183,8119,1363,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4184,8119,1364,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4185,8119,1364,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4186,8119,1365,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4187,8119,1365,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4188,8119,1366,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4189,8119,1366,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4190,8119,1367,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4191,8119,1367,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4192,8119,1368,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4193,8119,1368,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4194,8119,1369,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4195,8119,1369,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4196,8119,1370,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4197,8119,1370,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4198,8119,1371,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4199,8119,1371,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4200,8119,1372,40775,18806,7,251,1,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4201,8119,1372,40775,18806,7,13,2,0.00,NULL,'2023-02-28 12:14:26','2023-02-28 12:14:26',NULL),(4202,8119,1373,40775,18806,7,251,1,0.97,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4203,8119,1373,40775,18806,7,13,2,0.97,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4204,8119,1374,40775,18806,7,251,1,0.49,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4205,8119,1374,40775,18806,7,13,2,0.49,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4206,8119,1375,40775,18806,7,251,1,0.24,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4207,8119,1375,40775,18806,7,13,2,0.24,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4208,8119,1376,40775,18806,7,251,1,0.84,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4209,8119,1376,40775,18806,7,13,2,0.84,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4210,8119,1377,40775,18806,7,251,1,0.75,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL);
INSERT INTO `balance_libro_details` VALUES (4211,8119,1377,40775,18806,7,13,2,0.75,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4212,8119,1378,40775,18806,7,251,1,0.56,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4213,8119,1378,40775,18806,7,13,2,0.56,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4214,8119,1379,40775,18806,7,251,1,0.02,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4215,8119,1379,40775,18806,7,13,2,0.02,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4216,8119,1380,40775,18806,7,251,1,0.36,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4217,8119,1380,40775,18806,7,13,2,0.36,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4218,8119,1381,40775,18806,7,251,1,0.62,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4219,8119,1381,40775,18806,7,13,2,0.62,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4220,8119,1382,40775,18806,7,251,1,0.02,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4221,8119,1382,40775,18806,7,13,2,0.02,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4222,8119,1383,40775,18806,7,251,1,0.88,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4223,8119,1383,40775,18806,7,13,2,0.88,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4224,8119,1384,40775,18806,7,251,1,0.76,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4225,8119,1384,40775,18806,7,13,2,0.76,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4226,8119,1385,40775,18806,7,251,1,0.96,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4227,8119,1385,40775,18806,7,13,2,0.96,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4228,8119,1386,40775,18806,7,251,1,0.48,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4229,8119,1386,40775,18806,7,13,2,0.48,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4230,8119,1387,40775,18806,7,251,1,0.43,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4231,8119,1387,40775,18806,7,13,2,0.43,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4232,8119,1388,40775,18806,7,251,1,0.94,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4233,8119,1388,40775,18806,7,13,2,0.94,NULL,'2023-02-28 12:25:43','2023-02-28 12:25:43',NULL),(4234,8119,1389,40775,18806,16,156,1,13603.36,NULL,'2023-02-28 12:29:06','2023-02-28 12:32:52','2023-02-28 12:32:52'),(4235,8119,1389,40775,18806,16,277,2,52037.81,NULL,'2023-02-28 12:29:06','2023-02-28 12:32:52','2023-02-28 12:32:52'),(4236,8119,1389,40775,18806,16,302,1,38434.45,NULL,'2023-02-28 12:29:06','2023-02-28 12:32:52','2023-02-28 12:32:52'),(4237,8119,1389,40775,18806,16,156,1,3983.65,NULL,'2023-02-28 12:29:06','2023-02-28 12:32:52','2023-02-28 12:32:52'),(4238,8119,1389,40775,18806,16,301,2,24905.10,NULL,'2023-02-28 12:29:06','2023-02-28 12:32:52','2023-02-28 12:32:52'),(4239,8119,1389,40775,18806,16,251,2,4116.76,NULL,'2023-02-28 12:29:06','2023-02-28 12:32:52','2023-02-28 12:32:52'),(4240,8119,1389,40775,18806,16,301,1,25038.21,NULL,'2023-02-28 12:29:06','2023-02-28 12:32:52','2023-02-28 12:32:52'),(4241,8119,1390,40775,18806,2,96,2,109917.36,NULL,'2023-02-28 12:33:16','2023-02-28 12:33:16',NULL),(4242,8119,1390,40775,18806,2,67,2,23082.65,NULL,'2023-02-28 12:33:16','2023-02-28 12:33:16',NULL),(4243,8119,1390,40775,18806,2,13,1,133000.01,NULL,'2023-02-28 12:33:16','2023-02-28 12:33:16',NULL),(4244,8119,1391,40775,18806,2,96,2,54958.68,NULL,'2023-02-28 12:33:36','2023-02-28 12:33:36',NULL),(4245,8119,1391,40775,18806,2,67,2,11541.32,NULL,'2023-02-28 12:33:36','2023-02-28 12:33:36',NULL),(4246,8119,1391,40775,18806,2,13,1,66500.00,NULL,'2023-02-28 12:33:36','2023-02-28 12:33:36',NULL),(4247,8119,1392,40775,18806,2,96,2,23553.72,NULL,'2023-02-28 12:33:57','2023-02-28 12:33:57',NULL),(4248,8119,1392,40775,18806,2,67,2,4946.28,NULL,'2023-02-28 12:33:57','2023-02-28 12:33:57',NULL),(4249,8119,1392,40775,18806,2,13,1,28500.00,NULL,'2023-02-28 12:33:57','2023-02-28 12:33:57',NULL);
INSERT INTO `balance_libro_details` VALUES (4250,8119,1393,40775,18806,2,96,2,147107.44,NULL,'2023-02-28 12:34:14','2023-02-28 12:34:14',NULL),(4251,8119,1393,40775,18806,2,67,2,30892.56,NULL,'2023-02-28 12:34:14','2023-02-28 12:34:14',NULL),(4252,8119,1393,40775,18806,2,13,1,178000.00,NULL,'2023-02-28 12:34:14','2023-02-28 12:34:14',NULL),(4253,8119,1394,40775,18806,2,96,2,34710.74,NULL,'2023-02-28 12:35:36','2023-02-28 12:35:36',NULL),(4254,8119,1394,40775,18806,2,67,2,7289.26,NULL,'2023-02-28 12:35:36','2023-02-28 12:35:36',NULL),(4255,8119,1394,40775,18806,2,13,1,42000.00,NULL,'2023-02-28 12:35:36','2023-02-28 12:35:36',NULL),(4256,8119,1395,40775,18806,3,217,1,4132.24,NULL,'2023-02-28 12:38:55','2023-02-28 12:38:55',NULL),(4257,8119,1395,40775,18806,3,68,1,867.77,NULL,'2023-02-28 12:38:55','2023-02-28 12:38:55',NULL),(4258,8119,1395,40775,18806,3,57,2,5000.01,NULL,'2023-02-28 12:38:55','2023-02-28 12:38:55',NULL),(4259,8119,1396,40775,18806,16,156,1,13603.36,NULL,'2023-02-28 12:42:01','2023-02-28 12:45:47','2023-02-28 12:45:47'),(4260,8119,1396,40775,18806,16,277,2,52037.81,NULL,'2023-02-28 12:42:01','2023-02-28 12:45:47','2023-02-28 12:45:47'),(4261,8119,1396,40775,18806,16,302,1,38434.45,NULL,'2023-02-28 12:42:01','2023-02-28 12:45:47','2023-02-28 12:45:47'),(4262,8119,1396,40775,18806,16,156,1,3136.07,NULL,'2023-02-28 12:42:01','2023-02-28 12:45:47','2023-02-28 12:45:47'),(4263,8119,1396,40775,18806,16,301,2,24057.52,NULL,'2023-02-28 12:42:01','2023-02-28 12:45:47','2023-02-28 12:45:47'),(4264,8119,1396,40775,18806,16,251,2,4116.76,NULL,'2023-02-28 12:42:01','2023-02-28 12:45:47','2023-02-28 12:45:47'),(4265,8119,1396,40775,18806,16,301,1,25038.21,NULL,'2023-02-28 12:42:01','2023-02-28 12:45:47','2023-02-28 12:45:47'),(4266,8119,1397,40775,18806,3,217,1,33087.05,NULL,'2023-02-28 12:48:53','2023-02-28 12:48:53',NULL),(4267,8119,1397,40775,18806,3,68,1,6948.28,NULL,'2023-02-28 12:48:53','2023-02-28 12:48:53',NULL),(4268,8119,1397,40775,18806,3,217,1,74165.05,NULL,'2023-02-28 12:48:53','2023-02-28 12:48:53',NULL),(4269,8119,1397,40775,18806,3,68,1,7787.33,NULL,'2023-02-28 12:48:53','2023-02-28 12:48:53',NULL),(4270,8119,1397,40775,18806,3,57,2,121987.71,NULL,'2023-02-28 12:48:53','2023-02-28 12:48:53',NULL),(4271,8119,1398,40775,18806,15,67,1,141446.80,NULL,'2023-02-28 12:52:32','2023-02-28 12:52:32',NULL),(4272,8119,1398,40775,18806,15,68,2,76748.57,NULL,'2023-02-28 12:52:32','2023-02-28 12:52:32',NULL),(4273,8119,1398,40775,18806,15,353,2,81010.93,NULL,'2023-02-28 12:52:32','2023-02-28 12:52:32',NULL),(4274,8119,1398,40775,18806,15,354,2,1186.46,NULL,'2023-02-28 12:52:32','2023-02-28 12:52:32',NULL),(4275,8119,1398,40775,18806,15,353,1,16312.70,NULL,'2023-02-28 12:52:32','2023-02-28 12:52:32',NULL),(4276,8119,1398,40775,18806,15,354,1,2020.84,NULL,'2023-02-28 12:52:32','2023-02-28 12:52:32',NULL),(4277,8119,1398,40775,18806,15,136,2,834.38,NULL,'2023-02-28 12:52:32','2023-02-28 12:52:32',NULL),(4278,8119,1399,40775,18806,16,156,1,13603.36,NULL,'2023-02-28 12:54:30','2023-02-28 12:54:30',NULL),(4279,8119,1399,40775,18806,16,277,2,52037.81,NULL,'2023-02-28 12:54:30','2023-02-28 12:54:30',NULL),(4280,8119,1399,40775,18806,16,302,1,38434.45,NULL,'2023-02-28 12:54:30','2023-02-28 12:54:30',NULL),(4281,8119,1399,40775,18806,16,156,1,3983.65,NULL,'2023-02-28 12:54:30','2023-02-28 12:54:30',NULL),(4282,8119,1399,40775,18806,16,301,2,24905.10,NULL,'2023-02-28 12:54:30','2023-02-28 12:54:30',NULL),(4283,8119,1399,40775,18806,16,251,2,4116.76,NULL,'2023-02-28 12:54:30','2023-02-28 12:54:30',NULL),(4284,8119,1399,40775,18806,16,301,1,25038.21,NULL,'2023-02-28 12:54:30','2023-02-28 12:54:30',NULL),(4285,8119,1400,40720,1549,2,96,2,185250.00,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4286,8119,1400,40720,1549,2,67,2,38902.50,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4287,8119,1400,40720,1549,2,13,1,224152.50,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL);
INSERT INTO `balance_libro_details` VALUES (4288,8119,1401,40720,1549,2,96,2,211680.00,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4289,8119,1401,40720,1549,2,67,2,44452.80,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4290,8119,1401,40720,1549,2,13,1,256132.80,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4291,8119,1402,40720,1549,2,96,2,189540.00,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4292,8119,1402,40720,1549,2,67,2,39803.40,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4293,8119,1402,40720,1549,2,13,1,229343.40,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4294,8119,1403,40720,1549,2,96,2,228375.00,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4295,8119,1403,40720,1549,2,67,2,47958.75,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4296,8119,1403,40720,1549,2,13,1,276333.75,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4297,8119,1404,40720,1549,2,96,2,228375.00,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4298,8119,1404,40720,1549,2,67,2,47958.75,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4299,8119,1404,40720,1549,2,13,1,276333.75,NULL,'2023-03-16 10:08:30','2023-03-16 10:08:30',NULL),(4300,8119,1405,40720,1549,2,96,2,201240.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4301,8119,1405,40720,1549,2,67,2,42260.40,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4302,8119,1405,40720,1549,2,13,1,243500.40,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4303,8119,1406,40720,1549,2,96,2,196170.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4304,8119,1406,40720,1549,2,67,2,41195.70,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4305,8119,1406,40720,1549,2,13,1,237365.70,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4306,8119,1407,40720,1549,2,96,2,159432.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4307,8119,1407,40720,1549,2,67,2,33480.72,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4308,8119,1407,40720,1549,2,13,1,192912.72,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4309,8119,1408,40720,1549,2,96,2,257301.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4310,8119,1408,40720,1549,2,67,2,54033.21,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4311,8119,1408,40720,1549,2,13,1,311334.21,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4312,8119,1409,40720,1549,2,96,2,293235.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4313,8119,1409,40720,1549,2,67,2,61579.35,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4314,8119,1409,40720,1549,2,13,1,354814.35,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4315,8119,1410,40720,1549,2,96,2,240000.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4316,8119,1410,40720,1549,2,67,2,50400.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4317,8119,1410,40720,1549,2,13,1,290400.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4318,8119,1411,40720,1549,2,96,2,800120.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4319,8119,1411,40720,1549,2,67,2,168025.20,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4320,8119,1411,40720,1549,2,13,1,968145.20,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4321,8119,1412,40720,1549,2,96,2,304050.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4322,8119,1412,40720,1549,2,67,2,63850.50,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4323,8119,1412,40720,1549,2,13,1,367900.50,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4324,8119,1413,40720,1549,2,96,2,1992700.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4325,8119,1413,40720,1549,2,67,2,418467.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4326,8119,1413,40720,1549,2,13,1,2411167.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4327,8119,1414,40720,1549,2,96,2,648600.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL);
INSERT INTO `balance_libro_details` VALUES (4328,8119,1414,40720,1549,2,67,2,136206.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL),(4329,8119,1414,40720,1549,2,13,1,784806.00,NULL,'2023-03-16 10:08:31','2023-03-16 10:08:31',NULL);
/*!40000 ALTER TABLE `balance_libro_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs`
--

DROP TABLE IF EXISTS `blogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `fecha` date NOT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `blogs_categoria_sub_id` int(10) unsigned NOT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autor` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicar` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  KEY `blogs_blogs_categoria_sub_id_foreign` (`blogs_categoria_sub_id`),
  CONSTRAINT `blogs_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`),
  CONSTRAINT `blogs_blogs_categoria_sub_id_foreign` FOREIGN KEY (`blogs_categoria_sub_id`) REFERENCES `blogs_categorias_sub` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs`
--

LOCK TABLES `blogs` WRITE;
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias`
--

DROP TABLE IF EXISTS `blogs_categorias`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias`
--

LOCK TABLES `blogs_categorias` WRITE;
/*!40000 ALTER TABLE `blogs_categorias` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categorias_sub`
--

DROP TABLE IF EXISTS `blogs_categorias_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categorias_sub` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `blogs_categoria_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blogs_categorias_sub_blogs_categoria_id_foreign` (`blogs_categoria_id`),
  CONSTRAINT `blogs_categorias_sub_blogs_categoria_id_foreign` FOREIGN KEY (`blogs_categoria_id`) REFERENCES `blogs_categorias` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categorias_sub`
--

LOCK TABLES `blogs_categorias_sub` WRITE;
/*!40000 ALTER TABLE `blogs_categorias_sub` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs_categorias_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_alicuotas`
--

DROP TABLE IF EXISTS `bs_per_alicuotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_alicuotas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `anio` int(10) unsigned NOT NULL,
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `desde` decimal(16,2) NOT NULL DEFAULT '0.00',
  `hasta` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `mas_porcentaje` decimal(16,4) NOT NULL DEFAULT '0.0000',
  `excedente` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_alicuotas`
--

LOCK TABLES `bs_per_alicuotas` WRITE;
/*!40000 ALTER TABLE `bs_per_alicuotas` DISABLE KEYS */;
INSERT INTO `bs_per_alicuotas` VALUES (1,2017,950000.00,0.00,999999999.99,0.00,0.0050,950000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,2018,1050000.00,0.00,999999999.99,0.00,0.0025,1050000.00,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,2019,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2019-11-19 21:09:50','2022-11-22 10:04:07',NULL),(4,2019,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2019-11-19 21:09:50','2022-11-22 10:04:07',NULL),(5,2019,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2019-11-19 21:09:50','2022-11-22 10:04:07',NULL),(6,2019,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-11-22 10:04:07','2022-11-22 10:04:07',NULL),(7,2020,2000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-11-22 10:04:15','2022-11-22 10:04:15',NULL),(8,2020,2000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-11-22 10:04:15','2022-11-22 10:04:15',NULL),(9,2020,2000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-11-22 10:04:15','2022-11-22 10:04:15',NULL),(10,2020,2000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-11-22 10:04:15','2022-11-22 10:04:15',NULL),(11,2021,6000000.00,0.00,3000000.00,0.00,0.0050,0.00,'2022-11-22 10:04:23','2022-11-22 10:04:23',NULL),(12,2021,6000000.00,3000000.00,6500000.00,15000.00,0.0075,3000000.00,'2022-11-22 10:04:23','2022-11-22 10:04:23',NULL),(13,2021,6000000.00,6500000.00,18000000.00,41250.00,0.0100,6500000.00,'2022-11-22 10:04:23','2022-11-22 10:04:23',NULL),(14,2021,6000000.00,18000000.00,999999999.99,156250.00,0.0125,18000000.00,'2022-11-22 10:04:23','2022-11-22 10:04:23',NULL),(15,2022,11282141.08,0.00,5641070.54,0.00,0.0050,0.00,'2023-05-30 15:05:48','2023-05-30 15:05:48',NULL),(16,2022,11282141.08,5641070.54,12222319.51,28205.35,0.0075,5641070.54,'2023-05-30 15:05:48','2023-05-30 15:05:48',NULL),(17,2022,11282141.08,12222319.51,33846423.25,77564.72,0.0100,12222319.51,'2023-05-30 15:05:48','2023-05-30 15:05:48',NULL),(18,2022,11282141.08,33846423.25,188035684.71,293802.76,0.0125,33846423.25,'2023-05-30 15:05:48','2023-05-30 15:05:48',NULL),(19,2022,11282141.08,188035684.71,564107054.14,2221171.53,0.0150,188035684.71,'2023-05-30 15:05:48','2023-05-30 15:05:48',NULL),(20,2022,11282141.08,564107054.14,999999999999.00,7682242.07,0.0175,564107054.14,'2023-05-30 15:05:48','2023-05-30 15:05:48',NULL);
/*!40000 ALTER TABLE `bs_per_alicuotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_per_ddjjs`
--

DROP TABLE IF EXISTS `bs_per_ddjjs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_per_ddjjs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `anio` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `total_bienes_gravados` decimal(16,2) NOT NULL DEFAULT '0.00',
  `total_bienes_exentos` decimal(16,2) NOT NULL DEFAULT '0.00',
  `min_no_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `base_imponible` decimal(16,2) NOT NULL DEFAULT '0.00',
  `impuesto_determinado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_pagar` decimal(16,2) NOT NULL DEFAULT '0.00',
  `saldo_a_favor` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_per_ddjjs_person_id_foreign` (`person_id`),
  CONSTRAINT `bs_per_ddjjs_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_per_ddjjs`
--

LOCK TABLES `bs_per_ddjjs` WRITE;
/*!40000 ALTER TABLE `bs_per_ddjjs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_per_ddjjs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_conceptos`
--

DROP TABLE IF EXISTS `bs_pers_conceptos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_conceptos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_conceptos`
--

LOCK TABLES `bs_pers_conceptos` WRITE;
/*!40000 ALTER TABLE `bs_pers_conceptos` DISABLE KEYS */;
INSERT INTO `bs_pers_conceptos` VALUES (1,'Inmuebles',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(2,'Derechos Reales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(3,'Naves y Aeronaves',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(4,'Automotores y otros rodados',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(5,'Dinero y depósitos en dinero',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(6,'Títulos, acciones, cuotas o participaciones sociales y otros títulos valores',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(7,'Patrimonio de empresas o explotaciones unipersonales',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(8,'Créditos y debentures',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(9,'Derechos de propiedad científica, literaria o artística, marcas, patentes y sus licencias',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(10,'Otros Bienes (incluye semovientes, antigüedades, objetos de colección, objetos de arte, ...)',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL),(11,'Objetos Personales y del Hogar',1,'2019-11-19 21:09:50','2019-11-19 21:09:50',NULL);
/*!40000 ALTER TABLE `bs_pers_conceptos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_anticipos`
--

DROP TABLE IF EXISTS `bs_pers_detail_anticipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_anticipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `ganan_concepto_anticipo_id` int(10) unsigned NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_anticipos_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` (`ganan_concepto_anticipo_id`),
  CONSTRAINT `bs_pers_detail_anticipos_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_ganan_concepto_anticipo_id_foreign` FOREIGN KEY (`ganan_concepto_anticipo_id`) REFERENCES `ganan_conceptos_anticipos` (`id`),
  CONSTRAINT `bs_pers_detail_anticipos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_anticipos`
--

LOCK TABLES `bs_pers_detail_anticipos` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_anticipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bs_pers_detail_bienes`
--

DROP TABLE IF EXISTS `bs_pers_detail_bienes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bs_pers_detail_bienes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bs_per_ddjj_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `bs_pers_concepto_id` int(10) unsigned NOT NULL,
  `concepto` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `importe_gravado` decimal(16,2) NOT NULL DEFAULT '0.00',
  `importe_exento` decimal(16,2) NOT NULL DEFAULT '0.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` (`bs_per_ddjj_id`),
  KEY `bs_pers_detail_bienes_person_id_foreign` (`person_id`),
  KEY `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` (`bs_pers_concepto_id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_per_ddjj_id_foreign` FOREIGN KEY (`bs_per_ddjj_id`) REFERENCES `bs_per_ddjjs` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_bs_pers_concepto_id_foreign` FOREIGN KEY (`bs_pers_concepto_id`) REFERENCES `bs_pers_conceptos` (`id`),
  CONSTRAINT `bs_pers_detail_bienes_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bs_pers_detail_bienes`
--

LOCK TABLES `bs_pers_detail_bienes` WRITE;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` DISABLE KEYS */;
/*!40000 ALTER TABLE `bs_pers_detail_bienes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `calle`
--

DROP TABLE IF EXISTS `calle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `calle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `localidad_id` int(10) unsigned NOT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `desdealt` int(10) unsigned DEFAULT NULL,
  `hastaalt` int(10) unsigned DEFAULT NULL,
  `codpostal` int(10) unsigned DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calle_localidad_id_foreign` (`localidad_id`),
  CONSTRAINT `calle_localidad_id_foreign` FOREIGN KEY (`localidad_id`) REFERENCES `localidad` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `calle`
--

LOCK TABLES `calle` WRITE;
/*!40000 ALTER TABLE `calle` DISABLE KEYS */;
INSERT INTO `calle` VALUES (1,NULL,1,'Ramon Falcon',6800,7500,1408,1,'2020-05-28 20:55:23','2020-05-28 20:55:23',NULL);
/*!40000 ALTER TABLE `calle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_iibb`
--

DROP TABLE IF EXISTS `categorias_iibb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_iibb` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `impuesto` decimal(16,2) DEFAULT NULL,
  `anual` decimal(16,2) DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_iibb`
--

LOCK TABLES `categorias_iibb` WRITE;
/*!40000 ALTER TABLE `categorias_iibb` DISABLE KEYS */;
INSERT INTO `categorias_iibb` VALUES (1,'A',1850.00,11100.00,370000.00,30,3300,NULL,'1',NULL,'2022-11-22 10:04:25',NULL),(2,'B',2750.00,16500.00,550000.00,45,5000,NULL,'1',NULL,'2022-11-22 10:04:25',NULL),(3,'C',3850.00,23100.00,770000.00,60,6700,NULL,'1',NULL,'2022-11-22 10:04:25',NULL),(4,'D',5300.00,31800.00,1060000.00,85,10000,NULL,'1',NULL,'2022-11-22 10:04:25',NULL),(5,'E',7000.00,42000.00,1400000.00,110,13000,NULL,'1',NULL,'2022-11-22 10:04:25',NULL),(6,'F',8750.00,52500.00,1750000.00,150,16500,NULL,'1',NULL,'2022-11-22 10:04:25',NULL),(7,'G',10500.00,63000.00,2100000.00,200,20000,NULL,'1',NULL,'2022-11-22 10:04:25',NULL),(8,'H',13000.00,78000.00,2600000.00,200,20000,NULL,'1',NULL,'2022-11-22 10:04:25',NULL);
/*!40000 ALTER TABLE `categorias_iibb` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categorias_monotributo`
--

DROP TABLE IF EXISTS `categorias_monotributo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorias_monotributo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `categoria` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facAnual` decimal(16,2) DEFAULT NULL,
  `facMensual` decimal(16,2) DEFAULT NULL,
  `actividad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empleados` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `superficie` int(11) DEFAULT NULL,
  `energia` int(11) DEFAULT NULL,
  `alquileres` decimal(16,2) DEFAULT NULL,
  `impuesto_servicio` decimal(16,2) DEFAULT NULL,
  `impuesto_venta` decimal(16,2) DEFAULT NULL,
  `sipa` decimal(16,2) DEFAULT NULL,
  `obraSocial` decimal(16,2) DEFAULT NULL,
  `totalServicio` decimal(16,2) DEFAULT NULL,
  `totalVenta` decimal(16,2) DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `desde` date DEFAULT NULL,
  `hasta` date DEFAULT NULL,
  `vigente` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categorias_monotributo`
--

LOCK TABLES `categorias_monotributo` WRITE;
/*!40000 ALTER TABLE `categorias_monotributo` DISABLE KEYS */;
INSERT INTO `categorias_monotributo` VALUES (1,'A',1414762.00,117896.00,'No Excluida','0',30,3330,230178.48,496.85,496.85,2192.15,3061.75,5750.75,5750.75,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(2,'B',2103025.00,175252.00,'No Excluida','0',45,5000,230178.48,957.27,957.27,2411.36,3061.75,6430.38,6430.38,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(3,'C',2944235.00,245352.00,'No Excluida','0',60,6700,460356.93,1636.83,1512.56,2652.52,3061.75,7351.10,7226.83,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(4,'D',3656604.00,304717.00,'No Excluida','0',85,10000,460356.93,2689.05,2484.46,2917.75,3638.26,9245.06,9040.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(5,'E',4305799.00,358816.00,'No Excluida','0',110,13000,573619.32,5115.04,3967.80,3209.55,4452.02,12776.61,11629.37,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(6,'F',5382248.00,448520.00,'No Excluida','0',150,16500,575446.12,7036.89,5180.81,3530.49,5145.02,15712.40,13856.32,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(7,'G',6458698.00,538224.00,'No Excluida','0',200,20000,690535.39,8951.39,6459.54,3883.53,5512.52,18347.44,15855.59,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(8,'H',7996484.00,666373.00,'No Excluida','0',200,20000,920713.84,20460.26,15856.76,4271.88,6615.02,31347.16,26743.66,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(9,'I',8949911.00,745825.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,25575.36,4699.08,8190.03,NULL,38464.47,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(10,'J',10257028.00,854752.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,30054.72,5169.03,9166.53,NULL,44390.28,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(11,'K',11379612.00,948301.00,'Venta de Bs Muebles','0',200,20000,920713.84,NULL,34526.76,5685.87,10505.29,NULL,50717.92,NULL,'2018-01-01',NULL,'1',NULL,NULL,NULL),(12,'Monotributo Social',1414762.00,117896.00,'No Excluida','0',0,0,0.00,0.00,0.00,0.00,0.00,0.00,0.00,NULL,'2018-01-01',NULL,'1','2020-02-27 02:46:40','2020-02-27 02:46:40',NULL),(13,'A Exento',1414762.00,117896.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2192.15,3061.75,5253.90,5253.90,'',NULL,NULL,'0',NULL,NULL,NULL),(14,'B Exento',2103025.00,175252.00,NULL,NULL,NULL,NULL,230178.48,0.00,0.00,2411.36,3061.75,5473.11,5473.11,'',NULL,NULL,'0',NULL,NULL,NULL);
/*!40000 ALTER TABLE `categorias_monotributo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `charlas_details`
--

DROP TABLE IF EXISTS `charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `charla` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charlas_details`
--

LOCK TABLES `charlas_details` WRITE;
/*!40000 ALTER TABLE `charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `charlas_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `CharlaDetail_BD` BEFORE DELETE ON `charlas_details` FOR EACH ROW insert into back_up_charlas_details (charla,person_id,modificado)
values(old.charla,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `chequeras_tipos`
--

DROP TABLE IF EXISTS `chequeras_tipos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chequeras_tipos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chequeras_tipos`
--

LOCK TABLES `chequeras_tipos` WRITE;
/*!40000 ALTER TABLE `chequeras_tipos` DISABLE KEYS */;
INSERT INTO `chequeras_tipos` VALUES (1,NULL,'Fisica',1,NULL,NULL,NULL),(2,NULL,'Electronica',1,NULL,NULL,NULL),(3,NULL,'Transferencias',1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `chequeras_tipos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cheques_transfer_emitidas`
--

DROP TABLE IF EXISTS `cheques_transfer_emitidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cheques_transfer_emitidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `cta_cte_cliente_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_detail_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_banco_cheq_id` int(10) unsigned NOT NULL,
  `fecha_emision` date NOT NULL,
  `fecha_cobro` date NOT NULL,
  `numero_cheque` int(11) NOT NULL,
  `importe` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cheques_transfer_emitidas_person_id_foreign` (`person_id`),
  KEY `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` (`cta_cte_cliente_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` (`cta_cte_tesoreria_detail_id`),
  KEY `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cte_tes_ban_che_id_foreign` (`cta_cte_tesoreria_banco_cheq_id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_cliente_detail_id_foreign` FOREIGN KEY (`cta_cte_cliente_detail_id`) REFERENCES `cta_cte_cliente_details` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_cta_cte_tesoreria_detail_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_detail_id`) REFERENCES `cta_cte_tesoreria_detail` (`id`),
  CONSTRAINT `cheques_transfer_emitidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cte_tes_ban_che_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_banco_cheq_id`) REFERENCES `cta_cte_tesoreria_banco_cheq` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cheques_transfer_emitidas`
--

LOCK TABLES `cheques_transfer_emitidas` WRITE;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `cheques_transfer_emitidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves`
--

DROP TABLE IF EXISTS `claves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves`
--

LOCK TABLES `claves` WRITE;
/*!40000 ALTER TABLE `claves` DISABLE KEYS */;
INSERT INTO `claves` VALUES (1,8119,'Clave Fiscal',NULL,'2023-02-19 11:42:31',NULL),(2,NULL,'Clave Ciudad',NULL,NULL,NULL),(3,NULL,'Clave ARBA',NULL,NULL,NULL),(4,NULL,'Clave ANSES',NULL,NULL,NULL),(5,NULL,'Catedral',NULL,NULL,NULL),(6,NULL,'CEMIBA',NULL,NULL,NULL),(7,NULL,'COMPRA ARG',NULL,NULL,NULL),(8,NULL,'Consejo Ciencias Economicas',NULL,NULL,NULL),(9,NULL,'Correo',NULL,NULL,NULL),(10,NULL,'CUR',NULL,NULL,NULL),(11,NULL,'Firma Digital',NULL,NULL,NULL),(12,NULL,'Interbanking',NULL,NULL,NULL),(13,NULL,'Banco Citibank',NULL,NULL,NULL),(14,NULL,'Banco Ciudad',NULL,NULL,NULL),(15,NULL,'Banco Frances',NULL,NULL,NULL),(16,NULL,'Banco Galicia',NULL,NULL,NULL),(17,NULL,'Banco HSBC',NULL,NULL,NULL),(18,NULL,'Banco Itau',NULL,NULL,NULL),(19,NULL,'Banco Nacion',NULL,NULL,NULL),(20,NULL,'Banco Macro',NULL,NULL,NULL),(21,NULL,'Banco Patagonia',NULL,NULL,NULL),(22,NULL,'Banco Provincia',NULL,NULL,NULL),(23,NULL,'Banco Santander',NULL,NULL,NULL),(24,NULL,'Banco Supervielle',NULL,NULL,NULL),(25,NULL,'Seguridad e Higiene',NULL,NULL,NULL),(26,NULL,'Sindicato - ANSES',NULL,NULL,NULL),(27,NULL,'Sindicato - AOT',NULL,NULL,NULL),(28,NULL,'Sindicato - ATSA',NULL,NULL,NULL),(29,NULL,'Sindicato - Camioneros',NULL,NULL,NULL),(30,NULL,'Sindicato - Guinchero',NULL,NULL,NULL),(31,NULL,'Sindicato - IERIC',NULL,NULL,NULL),(32,NULL,'Sindicato - La Estrella',NULL,NULL,NULL),(33,NULL,'Sindicato - Nemesis',NULL,NULL,NULL),(34,NULL,'Sindicato - Pasta',NULL,NULL,NULL),(35,NULL,'Sindicato - SEC',NULL,NULL,NULL),(36,NULL,'Sindicato - SICOP',NULL,NULL,NULL),(37,NULL,'Sindicato - SOCAYA',NULL,NULL,NULL),(38,NULL,'Sindicato - UTHGRA',NULL,NULL,NULL),(39,NULL,'Sindicato - INACAP',NULL,NULL,NULL),(40,NULL,'Sindicato - Otro',NULL,NULL,NULL),(41,NULL,'Otra',NULL,NULL,NULL),(42,NULL,'Prisma - Firma Digital',NULL,NULL,NULL),(43,NULL,'Sindicato - FATSA',NULL,NULL,NULL);
/*!40000 ALTER TABLE `claves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `claves_details`
--

DROP TABLE IF EXISTS `claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `claves_details_clave_id_foreign` (`clave_id`),
  KEY `claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_details`
--

LOCK TABLES `claves_details` WRITE;
/*!40000 ALTER TABLE `claves_details` DISABLE KEYS */;
INSERT INTO `claves_details` VALUES (5,8119,'AFIP','Santiago2022',NULL,1,40741,1,'2022-12-19 21:52:36','2022-12-19 21:52:36',NULL),(12,8119,NULL,'Asdfgh3740',NULL,1,40856,1,'2023-01-06 12:00:50','2023-01-06 12:00:50',NULL),(15,8119,NULL,'Asesoria2022',NULL,1,40774,1,'2023-01-19 10:15:15','2023-01-19 10:15:15',NULL),(37,8119,NULL,'Asesoria2023',NULL,1,40767,1,'2023-02-22 09:59:53','2023-02-22 09:59:53',NULL),(40,8119,NULL,'Cabrera2023',NULL,1,40775,1,'2023-02-28 12:03:55','2023-02-28 12:03:55',NULL),(41,8119,NULL,'Luciano2020',NULL,3,40775,1,'2023-02-28 12:03:55','2023-02-28 12:03:55',NULL),(42,8119,NULL,'Luciano2021',NULL,2,40775,1,'2023-02-28 12:03:55','2023-02-28 12:03:55',NULL);
/*!40000 ALTER TABLE `claves_details` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_unicode_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`forge`@`%`*/ /*!50003 TRIGGER `ClavesDetail_BD` BEFORE DELETE ON `claves_details` FOR EACH ROW insert into back_up_claves_details (clave,valor,comentario,clave_id,person_id,modificado)
values(old.clave,old.valor,old.comentario,old.clave_id,old.person_id,now()) */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `claves_mails`
--

DROP TABLE IF EXISTS `claves_mails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `claves_mails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `claves_mails`
--

LOCK TABLES `claves_mails` WRITE;
/*!40000 ALTER TABLE `claves_mails` DISABLE KEYS */;
INSERT INTO `claves_mails` VALUES (1,'Listado de Claves',1,'Claves','claves_mails/claves_listado',NULL,NULL),(3,'Listado de Mails',2,'Mails','claves_mails/mails_listado',NULL,NULL),(5,'Listado de Charlas',3,'Charlas','claves_mails/charlas_listado',NULL,NULL);
/*!40000 ALTER TABLE `claves_mails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cm_articulos_regimenes`
--

DROP TABLE IF EXISTS `cm_articulos_regimenes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cm_articulos_regimenes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `codigo` int(11) DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cm_articulos_regimenes`
--

LOCK TABLES `cm_articulos_regimenes` WRITE;
/*!40000 ALTER TABLE `cm_articulos_regimenes` DISABLE KEYS */;
INSERT INTO `cm_articulos_regimenes` VALUES (1,NULL,'Articulo 2',2,1,'2022-11-22 10:04:15','2022-11-22 10:04:16',NULL),(2,NULL,'Articulo 6',6,0,'2022-11-22 10:04:15','2022-11-22 10:04:16',NULL),(3,NULL,'Articulo 7',7,0,'2022-11-22 10:04:15','2022-11-22 10:04:16',NULL),(4,NULL,'Articulo 8',8,0,'2022-11-22 10:04:15','2022-11-22 10:04:16',NULL),(5,NULL,'Articulo 9',9,0,'2022-11-22 10:04:15','2022-11-22 10:04:16',NULL),(6,NULL,'Articulo 10',10,0,'2022-11-22 10:04:15','2022-11-22 10:04:16',NULL),(7,NULL,'Articulo 11',11,0,'2022-11-22 10:04:15','2022-11-22 10:04:16',NULL),(8,NULL,'Articulo 12',12,0,'2022-11-22 10:04:15','2022-11-22 10:04:16',NULL),(9,NULL,'Articulo 13',13,0,'2022-11-22 10:04:15','2022-11-22 10:04:16',NULL),(10,NULL,'Articulo 14',14,1,'2022-11-22 10:04:15','2022-11-22 10:04:16',NULL);
/*!40000 ALTER TABLE `cm_articulos_regimenes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cobradores`
--

DROP TABLE IF EXISTS `cobradores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cobradores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cobradores`
--

LOCK TABLES `cobradores` WRITE;
/*!40000 ALTER TABLE `cobradores` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobradores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condicion_frente_al_iva`
--

DROP TABLE IF EXISTS `condicion_frente_al_iva`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condicion_frente_al_iva` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo_afip` int(11) DEFAULT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_comprobantes_a` tinyint(1) NOT NULL DEFAULT '0',
  `show_comprobantes_b` tinyint(1) NOT NULL DEFAULT '0',
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condicion_frente_al_iva`
--

LOCK TABLES `condicion_frente_al_iva` WRITE;
/*!40000 ALTER TABLE `condicion_frente_al_iva` DISABLE KEYS */;
INSERT INTO `condicion_frente_al_iva` VALUES (1,NULL,1,'IVA Responsable Inscripto',1,0,1,NULL,NULL,NULL),(2,NULL,2,'IVA Responsable no Inscripto',0,0,1,NULL,NULL,NULL),(3,NULL,3,'IVA no Responsable',0,0,1,NULL,NULL,NULL),(4,NULL,4,'IVA Sujeto Exento',0,1,1,NULL,NULL,NULL),(5,NULL,5,'Consumidor Final',0,1,1,NULL,NULL,NULL),(6,NULL,6,'Responsable Monotributo',1,0,1,NULL,NULL,NULL),(7,NULL,7,'Sujeto no Categorizado',0,1,1,NULL,NULL,NULL),(8,NULL,8,'Proveedor del Exterior',0,1,1,NULL,NULL,NULL),(9,NULL,9,'Cliente del Exterior',0,1,1,NULL,NULL,NULL),(10,NULL,10,'IVA Liberado – Ley Nº 19.640',0,1,1,NULL,NULL,NULL),(11,NULL,11,'IVA Responsable Inscripto – Agente de Percepción',0,0,1,NULL,NULL,NULL),(12,NULL,12,'Pequeño Contribuyente Eventual',0,0,1,NULL,NULL,NULL),(13,NULL,13,'Monotributista Social',1,0,1,NULL,NULL,NULL),(14,NULL,14,'Pequeño Contribuyente Eventual Social',0,0,1,NULL,NULL,NULL),(15,NULL,NULL,'Monotributista Trabajador Independiente Promovido',1,0,1,NULL,NULL,NULL),(16,NULL,NULL,'IVA No Alcanzado',0,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `condicion_frente_al_iva` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `condiciones_venta`
--

DROP TABLE IF EXISTS `condiciones_venta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `condiciones_venta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `condiciones_venta`
--

LOCK TABLES `condiciones_venta` WRITE;
/*!40000 ALTER TABLE `condiciones_venta` DISABLE KEYS */;
INSERT INTO `condiciones_venta` VALUES (1,'Contado',NULL,NULL),(2,'Tarjeta de Debito',NULL,NULL),(3,'Tarjeta de Credito',NULL,NULL),(4,'Cuenta Corriente',NULL,NULL),(5,'Cheque',NULL,NULL),(6,'Ticket',NULL,NULL),(7,'Transferencia',NULL,NULL),(8,'Otra',NULL,NULL);
/*!40000 ALTER TABLE `condiciones_venta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas`
--

DROP TABLE IF EXISTS `consultas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas`
--

LOCK TABLES `consultas` WRITE;
/*!40000 ALTER TABLE `consultas` DISABLE KEYS */;
INSERT INTO `consultas` VALUES (1,NULL,'Estado Liquidaciones',1,NULL,NULL,NULL),(2,NULL,'Consumo',1,NULL,NULL,NULL),(3,NULL,'Resultado Liquidacion Hijas',1,'2023-03-12 23:45:11','2023-03-12 23:45:11',NULL);
/*!40000 ALTER TABLE `consultas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `consultas_aux`
--

DROP TABLE IF EXISTS `consultas_aux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `consultas_aux` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consulta_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `estado` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consultas_aux_consulta_id_foreign` (`consulta_id`),
  KEY `consultas_aux_person_id_foreign` (`person_id`),
  CONSTRAINT `consultas_aux_consulta_id_foreign` FOREIGN KEY (`consulta_id`) REFERENCES `consultas` (`id`),
  CONSTRAINT `consultas_aux_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `consultas_aux`
--

LOCK TABLES `consultas_aux` WRITE;
/*!40000 ALTER TABLE `consultas_aux` DISABLE KEYS */;
INSERT INTO `consultas_aux` VALUES (1,NULL,1,NULL,'[{\"id\":40720,\"user_id\":8119,\"field_name1\":\"COLOMBO OSVALDO\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"20-08426109-3\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-11-23T01:14:31.000000Z\",\"updated_at\":\"2022-11-23T01:14:31.000000Z\",\"activity_id\":null,\"address\":\"BERNARDO DE IRIGOYEN 378\",\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"status_liq_sueldos\":\"Abierto\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":3,\"user_id\":8119,\"person_id\":40720,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-11-23T01:14:31.000000Z\",\"updated_at\":\"2022-11-23T01:15:38.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":0,\"obligation_iibb\":3,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2020-19\",\"obligation_salaries\":1,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":1,\"person_id_administrador\":40720,\"person_id_titular\":40720,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2020-11-01T03:00:00.000000Z\",\"iibb\":\"20-08426109-3\",\"fe_leyenda\":null,\"atencion_iva\":1,\"atencion_iva_comentario\":null,\"atencion_iibb\":1,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":null,\"periods\":[{\"id\":1543,\"user_id\":8119,\"code\":\"2022-11\",\"year\":2022,\"period_number\":11,\"date_from\":\"2022-11-01\",\"date_to\":\"2022-11-30\",\"created_at\":null,\"updated_at\":\"2022-11-25T00:22:06.000000Z\",\"person_id\":40720,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":2,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":2,\"user_id\":null,\"descripcion\":\"Abierto\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]},{\"id\":40741,\"user_id\":8119,\"field_name1\":\"LOPEZ MONICA RAQUEL\",\"field_name2\":null,\"document_type\":\"cuit\",\"document\":\"27-17770418-6\",\"cond_frente_al_iva_id\":null,\"country_id\":null,\"state_id\":null,\"zone_id\":null,\"plan_cuenta_id\":null,\"iva_creditos_tipo_id\":null,\"created_at\":\"2022-12-20T00:06:09.000000Z\",\"updated_at\":\"2022-12-20T00:06:09.000000Z\",\"activity_id\":null,\"address\":null,\"person_type_id\":1,\"fa_iva_condition_id\":null,\"fa_codigo_postal\":null,\"email\":null,\"deleted_at\":null,\"status_liq_iva\":\"Pendiente\",\"status_liq_iibb\":\"Pendiente\",\"estado\":\"INCOMPLETO\",\"otros\":\"\",\"configuration\":[{\"id\":4,\"user_id\":8119,\"person_id\":40741,\"period_id\":null,\"zone_id\":null,\"settle_calc_by_coef\":0,\"created_at\":\"2022-12-20T00:06:10.000000Z\",\"updated_at\":\"2022-12-20T00:23:05.000000Z\",\"active\":2,\"enviarMail\":1,\"honorario\":\"0.00\",\"cta_cte_tesoreria_cuenta_id\":null,\"month_close\":12,\"iva_condition_id\":2,\"obligation_sell\":1,\"obligation_buy\":1,\"obligation_iva\":1,\"obligation_electronic_receipt\":1,\"obligation_iibb\":2,\"obligation_other_taxes\":null,\"liquidation_start_period\":\"2022-06\",\"obligation_salaries\":0,\"empleada_domestica\":0,\"prorratear_iva\":0,\"is_itc\":0,\"priority_order\":1,\"person_id_administrador\":40741,\"person_id_titular\":40741,\"logo_path\":null,\"certificado_afip_path\":null,\"llave_afip_path\":null,\"access_electronic_receipt\":0,\"ruta_logo_fa\":null,\"inicio_actividades\":\"2022-12-19T03:00:00.000000Z\",\"iibb\":\"27-17770418-6\",\"fe_leyenda\":null,\"atencion_iva\":0,\"atencion_iva_comentario\":null,\"atencion_iibb\":0,\"atencion_iibb_comentario\":null,\"deleted_at\":null}],\"liquidador\":{\"id\":2,\"user_id\":8119,\"person_id\":40741,\"liquidator_id\":1,\"created_at\":\"2022-12-20T00:23:05.000000Z\",\"updated_at\":\"2022-12-20T00:23:05.000000Z\",\"deleted_at\":null,\"liquidador\":{\"id\":1,\"user_id\":8119,\"name\":\"LEI Y MEL\",\"created_at\":null,\"updated_at\":\"2022-12-19T23:59:32.000000Z\",\"deleted_at\":null}},\"periods\":[{\"id\":3350,\"user_id\":null,\"code\":\"2022-11\",\"year\":2022,\"period_number\":11,\"date_from\":\"2022-11-01\",\"date_to\":\"2022-11-30\",\"created_at\":null,\"updated_at\":null,\"person_id\":40741,\"conta_status\":0,\"deleted_at\":null,\"syj_periods_status_id\":1,\"syj_sin_asiento\":0,\"syj_asiento_modificado\":0,\"syj_periods_status_emp_dom_id\":1,\"syj_periods_status_emp_dom\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null},\"syj_periods_status\":{\"id\":1,\"user_id\":null,\"descripcion\":\"Sin Usar\",\"habilitado\":1,\"created_at\":null,\"updated_at\":null,\"deleted_at\":null}}]}]',1,'2022-12-19 21:24:01','2022-12-19 21:24:01',NULL);
/*!40000 ALTER TABLE `consultas_aux` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos`
--

DROP TABLE IF EXISTS `conta_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `debe_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `haber_cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `ctactecheque_id` int(10) unsigned DEFAULT NULL,
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `adjunto` text COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `radioChecked` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `CuentaTipo_id` int(10) unsigned DEFAULT NULL,
  `CentroCosto_id` int(10) unsigned DEFAULT NULL,
  `pagado` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_person_id_foreign` (`person_id`),
  KEY `conta_asientos_period_id_foreign` (`period_id`),
  KEY `conta_asientos_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_cuentatipo_id_foreign` (`CuentaTipo_id`),
  KEY `conta_asientos_centrocosto_id_foreign` (`CentroCosto_id`),
  KEY `conta_asientos_ctactecheque_id_foreign` (`ctactecheque_id`),
  KEY `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` (`haber_cta_cte_tesoreria_cuenta_id`),
  KEY `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` (`debe_cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_centrocosto_id_foreign` FOREIGN KEY (`CentroCosto_id`) REFERENCES `ctactegastos_centrocosto` (`id`),
  CONSTRAINT `conta_asientos_ctactecheque_id_foreign` FOREIGN KEY (`ctactecheque_id`) REFERENCES `ctacte_cheques` (`id`),
  CONSTRAINT `conta_asientos_cuentatipo_id_foreign` FOREIGN KEY (`CuentaTipo_id`) REFERENCES `ctactegastos_cuenta_tipo` (`idCuentaTipo`),
  CONSTRAINT `conta_asientos_debe_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`debe_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_haber_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`haber_cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos`
--

LOCK TABLES `conta_asientos` WRITE;
/*!40000 ALTER TABLE `conta_asientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_asientos_details`
--

DROP TABLE IF EXISTS `conta_asientos_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_asientos_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `monto` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_asientos_details_conta_asiento_id_foreign` (`conta_asiento_id`),
  KEY `conta_asientos_details_person_id_foreign` (`person_id`),
  KEY `conta_asientos_details_period_id_foreign` (`period_id`),
  KEY `conta_asientos_details_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `conta_asientos_details_saldo_id_foreign` (`saldo_id`),
  KEY `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  CONSTRAINT `conta_asientos_details_conta_asiento_id_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `conta_asientos_details_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `conta_asientos_details_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `conta_asientos_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `conta_asientos_details_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_asientos_details_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_asientos_details`
--

LOCK TABLES `conta_asientos_details` WRITE;
/*!40000 ALTER TABLE `conta_asientos_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_asientos_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costo_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_centro_costo_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costo_plan_cuenta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_centro_costo_id` bigint(20) unsigned DEFAULT NULL,
  `conta_plan_cuenta_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` (`conta_centro_costo_id`),
  KEY `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` (`conta_plan_cuenta_id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_centro_costo_id_foreign` FOREIGN KEY (`conta_centro_costo_id`) REFERENCES `conta_centro_costos` (`id`),
  CONSTRAINT `conta_centro_costo_plan_cuenta_conta_plan_cuenta_id_foreign` FOREIGN KEY (`conta_plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costo_plan_cuenta`
--

LOCK TABLES `conta_centro_costo_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costo_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_centro_costos`
--

DROP TABLE IF EXISTS `conta_centro_costos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_centro_costos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_centro_costos_person_id_foreign` (`person_id`),
  CONSTRAINT `conta_centro_costos_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_centro_costos`
--

LOCK TABLES `conta_centro_costos` WRITE;
/*!40000 ALTER TABLE `conta_centro_costos` DISABLE KEYS */;
/*!40000 ALTER TABLE `conta_centro_costos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_plan_cuenta`
--

DROP TABLE IF EXISTS `conta_plan_cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_plan_cuenta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `codigo` int(11) NOT NULL,
  `tipo_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `padre` int(11) NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rubro` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `no_editable` int(11) NOT NULL DEFAULT '1',
  `tes_cta_cte` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_origen` tinyint(1) NOT NULL DEFAULT '0',
  `tes_cuenta_destino` tinyint(1) NOT NULL DEFAULT '0',
  `conta_asientos` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conta_plan_cuenta_tipo_cuenta_id_foreign` (`tipo_cuenta_id`),
  KEY `conta_plan_cuenta_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `conta_plan_cuenta_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `conta_plan_cuenta_tipo_cuenta_id_foreign` FOREIGN KEY (`tipo_cuenta_id`) REFERENCES `conta_tipo_cuentas` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1027 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_plan_cuenta`
--

LOCK TABLES `conta_plan_cuenta` WRITE;
/*!40000 ALTER TABLE `conta_plan_cuenta` DISABLE KEYS */;
INSERT INTO `conta_plan_cuenta` VALUES (1,NULL,1000000,1,1,0,'ACTIVO','Activo',NULL,1,1,0,0,0,0,NULL),(2,NULL,1100000,2,1,1000000,'ACTIVO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(3,NULL,1110000,3,1,1100000,'CAJA Y BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(4,NULL,1110100,4,1,1110000,'CAJAS','Activo',NULL,1,1,0,0,0,0,NULL),(5,NULL,1110101,5,1,1110100,'Caja Oficina','Activo',NULL,0,1,0,0,0,0,NULL),(6,NULL,1110102,5,1,1110100,'Caja Casa','Activo',NULL,0,1,0,0,0,0,NULL),(7,NULL,1110103,5,1,1110100,'Caja Dolares Casa','Activo',NULL,0,1,0,0,0,0,NULL),(8,NULL,1110104,5,1,1110100,'Banco Santander 015-372795/5','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(9,NULL,1110200,4,1,1110000,'BANCOS','Activo',NULL,1,1,0,0,0,0,NULL),(10,NULL,1110201,5,1,1110200,'Banco Santander Rio Cta Corriente','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(11,NULL,1110202,5,1,1110200,'Banco Santander Rio Cta Corriente DOLARES','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(12,NULL,1130000,3,1,1100000,'CREDITOS POR VENTAS','Activo',NULL,1,1,0,0,0,0,NULL),(13,NULL,1130101,5,1,1130100,'Clientes - Deudores','Activo',NULL,1,2,0,0,0,1,NULL),(14,NULL,1130102,5,1,1130100,'Deudores por ventas comunes','Activo',NULL,1,1,0,0,0,1,NULL),(15,NULL,1130103,5,1,1130100,'Deudores por ventas morosos','Activo',NULL,1,1,0,0,0,1,NULL),(16,NULL,1130104,5,1,1130100,'Deudores en gestión judicial','Activo',NULL,1,1,0,0,0,1,NULL),(17,NULL,1130105,5,1,1130100,'Previsión deudores incobrables','Activo',NULL,1,1,0,0,0,1,NULL),(18,NULL,1140000,3,1,1100000,'OTROS CREDITOS','Activo',NULL,1,1,0,0,0,0,NULL),(19,NULL,1140100,4,1,1140000,'Retenciones Sufridas','Activo',NULL,1,1,0,0,0,0,NULL),(20,NULL,1140301,5,1,1140300,'Anticipos Impuesto a las Ganancias','Activo',NULL,1,2,0,0,1,1,NULL),(21,NULL,1140102,5,1,1140100,'Retenciones Ingr. Brutos','Activo',NULL,0,1,0,0,0,0,NULL),(22,NULL,1140329,5,1,1140300,'Anticipo Impto.Ganancia Mínima Presunta','Activo',NULL,1,1,0,0,0,1,NULL),(23,NULL,1140105,5,1,1140100,'Retenciones Impuesto a las Ganancias','Activo',NULL,1,2,1,0,0,1,NULL),(24,NULL,1140106,5,1,1140100,'Impuesto a las Ganancias (Saldo a favor)','Activo',NULL,1,1,0,0,0,1,NULL),(25,NULL,1140107,5,1,1140100,'Retenciones de IVA','Activo',NULL,1,2,1,0,0,1,NULL),(26,NULL,1140200,4,1,1140000,'CREDITOS DIVERSOS','Activo',NULL,1,1,0,0,0,0,NULL),(27,NULL,1140201,5,1,1140200,'Anticipos de proveedores','Activo',NULL,1,1,0,0,0,1,NULL),(28,NULL,1140205,5,1,1140200,'Depósito en garantía alquileres','Activo',NULL,1,1,0,0,0,1,NULL),(29,NULL,1140206,5,1,1140200,'Derechos adquiridos a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(30,NULL,1140207,5,1,1140200,'Intereses a devengar','Activo',NULL,1,1,0,0,0,1,NULL),(31,NULL,1140208,5,1,1140200,'Cuentas a rendir - Directores','Activo',NULL,1,1,0,0,0,1,NULL),(32,NULL,1140210,5,1,1140200,'Alquileres no devengados','Activo',NULL,1,1,0,0,0,1,NULL),(33,NULL,1150000,3,1,1100000,'BIENES DE CAMBIO','Activo',NULL,1,1,0,0,0,0,NULL),(34,NULL,1150400,4,1,1150000,'MERCADERIA DE REVENTA','Activo',NULL,1,1,0,0,0,0,NULL),(35,NULL,1200000,2,1,1000000,'ACTIVO NO CORRIENTE','Activo',NULL,1,1,0,0,0,0,NULL),(36,NULL,1220000,3,1,1200000,'BIENES DE USO','Activo',NULL,1,1,0,0,0,0,NULL),(37,NULL,1220100,4,1,1220000,'EQUIPOS DE COMPUTACION','Activo',NULL,1,1,0,0,0,0,NULL),(38,NULL,1220101,5,1,1220100,'Equipos de computación valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(39,NULL,1220102,5,1,1220100,'Equipos de computación ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(40,NULL,1220108,5,1,1220100,'Amortización Acumulada Equipos de comput.','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(41,NULL,1220200,4,1,1220000,'INSTALACIONES','Activo',NULL,1,1,0,0,0,0,NULL),(42,NULL,1220201,5,1,1220200,'Instalaciones valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(43,NULL,1220202,5,1,1220200,'Instalaciones ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(44,NULL,1220206,5,1,1220200,'Amortización Acumulada Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(45,NULL,1220300,4,1,1220000,'MUEBLES Y UTILES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (46,NULL,1220301,5,1,1220300,'Muebles y utiles valores históricos','Activo',NULL,1,1,0,0,0,1,NULL),(47,NULL,1220302,5,1,1220300,'Muebles y utiles ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(48,NULL,1220306,5,1,1220300,'Amortización Acumulada Muebles y Útiles','Activo',NULL,1,1,0,0,0,1,NULL),(49,NULL,1230000,3,1,1200000,'ACTIVOS INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL),(50,NULL,1230101,5,1,1230100,'Gastos de organización valores historicos','Activo',NULL,1,1,0,0,0,1,NULL),(51,NULL,1230102,5,1,1230100,'Gastos de organización ajuste','Activo',NULL,1,1,0,0,0,1,NULL),(52,NULL,1230103,5,1,1230100,'Amortización acumulada gs. de organización','Activo',NULL,1,1,0,0,0,1,NULL),(53,NULL,2000000,1,2,0,'PASIVO','Pasivo',NULL,1,1,0,0,0,0,NULL),(54,NULL,2100000,2,2,2000000,'PASIVO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(55,NULL,2110000,3,2,2100000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(56,NULL,2110100,4,2,2110000,'Comerciales','Pasivo',NULL,1,1,0,0,0,0,NULL),(57,NULL,2110101,5,2,2110100,'Proveedores en Cta. Cte. locales','Pasivo',NULL,1,2,0,0,0,1,NULL),(58,NULL,2110102,5,2,2110100,'Proveedores en cta. cte. exterior','Pasivo',NULL,1,1,0,0,0,1,NULL),(59,NULL,2110103,5,2,2110100,'Derechos de exhibición a devengar','Pasivo',NULL,1,1,0,0,0,1,NULL),(60,NULL,2110104,5,2,2110100,'Cheques emitidos ','Pasivo',NULL,1,2,1,1,1,1,NULL),(61,NULL,2110200,4,2,2110000,'REMUNERACIONES Y CARGAS SOCIALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(62,NULL,2110201,5,2,2110200,'Sueldos y Jornales a pagar','Pasivo',NULL,1,2,0,0,1,1,NULL),(63,NULL,2110202,5,2,2110200,'Cargas sociales a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(64,NULL,2110203,5,2,2110200,'Sindicatos a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(65,NULL,2110300,4,2,2110000,'CARGAS FISCALES','Pasivo',NULL,1,1,0,0,0,0,NULL),(67,NULL,2110301,5,2,2110300,'IVA Debito Fiscal','Pasivo',NULL,1,2,0,0,0,1,NULL),(68,NULL,1140222,5,1,1140200,'IVA Credito Fiscal','Activo',NULL,1,2,0,0,0,1,NULL),(69,NULL,2110303,5,2,2110300,'Impuestos Internos','Pasivo',NULL,1,1,0,0,0,1,NULL),(70,NULL,2110304,5,2,2110300,'Impuestos al Combustible','Pasivo',NULL,1,1,0,0,0,1,NULL),(71,NULL,2110601,5,2,2110600,'IVA Retenciones de terceros','Pasivo',NULL,1,1,0,0,0,1,NULL),(72,NULL,2110306,5,2,2110300,'IVA Percepciones realiz.por terceros','Pasivo',NULL,1,2,0,0,0,1,NULL),(73,NULL,2110307,5,2,2110300,'IVA Saldo a favor','Pasivo',NULL,1,1,0,0,0,1,NULL),(74,NULL,2110308,5,2,2110300,'IVA a pagar','Pasivo',NULL,1,2,0,0,0,1,NULL),(75,NULL,2110309,5,2,2110300,'Percepciones Ingresos Brutos','Pasivo',NULL,1,1,0,0,0,1,NULL),(76,NULL,2110310,5,2,2110300,'Otros Pagos AFIP','Pasivo',NULL,1,1,0,0,0,1,NULL),(78,NULL,2110350,5,2,2110300,'Impuesto a los Ingresos Brutos Pasivo','Pasivo',NULL,1,1,0,0,0,1,NULL),(79,NULL,2110313,5,2,2110300,'Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(80,NULL,2110314,5,2,2110300,'Impuesto a la Ganancia Mínima Presunta','Pasivo',NULL,1,1,0,0,0,1,NULL),(81,NULL,2110602,5,2,2110600,'AFIP - Retenciones Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(82,NULL,2110316,5,2,2110300,'AFIP - Plan de Facilidades Decreto 338/02','Pasivo',NULL,1,1,0,0,0,1,NULL),(83,NULL,2200000,2,2,2000000,'PASIVO NO CORRIENTE','Pasivo',NULL,1,1,0,0,0,0,NULL),(84,NULL,3000000,1,2,0,'PATRIMONIO NETO','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(85,NULL,3100000,2,2,3000000,'APORTE DE LOS PROPIETARIOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(86,NULL,3110100,4,2,3110000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(87,NULL,3110101,5,2,3110100,'Acciones en circulación','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(88,NULL,3110102,5,2,3110100,'Ajuste del Capital','Patrimonio Neto',NULL,1,2,0,0,0,1,NULL),(89,NULL,3110103,5,2,3110100,'Aportes Irrevocables Futuras Suscripciones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(90,NULL,3400000,2,2,3000000,'RESULTADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(91,NULL,3410101,5,2,3410100,'Resultado del ejercicio','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (92,NULL,3410102,5,2,3410100,'Resultado ejercicios anteriores','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(93,NULL,3410103,5,2,3410100,'A.R.E.A.','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(94,NULL,4000000,1,2,0,'INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(95,NULL,4100000,2,2,4000000,'INGRESOS ORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(96,NULL,4110101,5,2,4110100,'VENTAS','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(97,NULL,4110102,5,2,4110100,'Honorarios','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(98,NULL,4110103,5,2,4110100,'Sueldo Vane','Result. Positivo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(99,NULL,4110104,5,2,4110100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(100,NULL,4110105,5,2,4110100,'Reintegros por exportaciones','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(101,NULL,4120000,3,2,4100000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(102,NULL,4120101,5,2,4120100,'Intereses Cobrados','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(103,NULL,4120102,5,2,4120100,'Diferencias de cambio','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(104,NULL,4120103,5,2,4120100,'Descuentos obtenidos','Result. Positivo',NULL,1,1,0,0,0,1,NULL),(107,NULL,5000000,1,1,0,'GASTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(108,NULL,5100000,2,1,5000000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(109,NULL,5110100,4,1,5110000,'ASIENTO DE SUELDO','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(110,NULL,5110101,5,1,5110100,'Sueldos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(111,NULL,5110102,5,1,5110100,'Contribuciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(112,NULL,5110103,5,1,5110100,'Sindicato','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(113,NULL,5120100,4,1,5120000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(114,NULL,5120101,5,1,5120100,'ACA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(115,NULL,5120102,5,1,5120100,'Aereos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(116,NULL,5120103,5,1,5120100,'Alquiler','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(117,NULL,5120104,5,1,5120100,'AGUA AYSA','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(118,NULL,5120105,5,1,5120100,'TV Cablevision','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(119,NULL,5120106,5,1,5120100,'Caja Jubilacion Consejo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(120,NULL,5120107,5,1,5120100,'Celulares','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(121,NULL,5120108,5,1,5120100,'Cheques','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(122,NULL,5120109,5,1,5120100,'Club la Nacion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(123,NULL,5120110,5,1,5120100,'Comida','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(124,NULL,5120111,5,1,5120100,'Diario Clarin','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(125,NULL,5120112,5,1,5120100,'Digital Ocean','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(126,NULL,5120113,5,1,5120100,'Fletes y acarreos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(127,NULL,5120114,5,1,5120100,'Luz Edesur','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(128,NULL,5120115,5,1,5120100,'Movilidad y Viáticos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(129,NULL,5120116,5,1,5120100,'Mantenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(130,NULL,5120117,5,1,5120100,'IVA No Computable','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(131,NULL,5120118,5,1,5120100,'Entretenimiento','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(132,NULL,5120119,5,1,5120100,'Amortización Bienes de Uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(133,NULL,5120120,5,1,5120100,'Errepar','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(134,NULL,5120121,5,1,5120100,'Hosting Página Web To Webs','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(135,NULL,5120122,5,1,5120100,'Gastos varios','Result. Negativo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (136,NULL,5120123,5,1,5120100,'Ajuste por redondeo','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(137,NULL,5120124,5,1,5120100,'Deudores Incobrables','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(138,NULL,5120125,5,1,5120100,'Faby Goncalves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(139,NULL,5130100,4,1,5130000,'GASTOS FINANCIEROS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(140,NULL,5130101,5,1,5130100,'Intereses y Gastos bancarios','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(141,NULL,5130102,5,1,5130100,'Intereses Proveedores','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(142,NULL,5130103,5,1,5130100,'Damian Financiera','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(143,NULL,5130104,5,1,5130100,'Diferencias de cambio','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(144,NULL,5130105,5,1,5130100,'Diferencia de Cambio Bces. en M.Extranjera','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(145,NULL,5130106,5,1,5130100,'Diferencia tipo cambio Vendedor/Comprador','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(146,NULL,5130107,5,1,5130100,'Diferencia por conversion en Bce. en Mon. Extranj.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(147,NULL,5130108,5,1,5130100,'Diferencia de cambio CMV','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(148,NULL,5130109,5,1,5130100,'Diferencia de cambio PT','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(149,NULL,5130110,5,1,5130100,'Resultado por Exposición a la Inflación','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(150,NULL,5130111,5,1,5130100,'Diferencia de cambio PE','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(151,NULL,5130112,5,1,5130100,'Diferencia de cambio Ds.Vtas.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(152,NULL,5130113,5,1,5130100,'Diferencia de cambio ME','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(153,NULL,5130114,5,1,5130100,'Descuentos otorgados','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(154,NULL,5140100,4,1,5140000,'IMPUESTOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(155,NULL,5140101,5,1,5140100,'Impuesto a las Ganancias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(156,NULL,5140164,5,1,5140100,'Impuesto a los Ingresos Brutos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(157,NULL,5140102,5,1,5140100,'Impuesto al Debito y Credito Bancario','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(158,NULL,5200000,2,1,5000000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(159,NULL,5210101,5,1,5210100,'Pérdida por venta bienes de uso','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(160,NULL,5210102,5,1,5210100,'Inversiones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(161,NULL,5210103,5,1,5210100,'Amortizaciones extraordinarias','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(162,NULL,1140103,5,1,1140100,'Retenciones SUSS','Activo',NULL,1,2,1,0,0,1,NULL),(163,NULL,1110122,5,1,1110100,'Banco Patagonia Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(164,NULL,1110106,5,1,1110100,'Banco HSBC','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(165,NULL,1110123,5,1,1110100,'Banco Ciudad Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(166,NULL,1110124,5,1,1110100,'Banco Nacion Cta. Cte.','Activo',NULL,0,1,0,0,0,0,NULL),(167,NULL,1110109,5,1,1110100,'Banco Galicia Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(168,NULL,1110110,5,1,1110100,'Banco Frances Vane','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(169,NULL,1110111,5,1,1110100,'Banco Patagonia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(170,NULL,1110112,5,1,1110100,'Banco Ciudad In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(171,NULL,1110113,5,1,1110100,'Banco Provincia In Time SRL','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(172,NULL,1110114,5,1,1110100,'Banco Macro PedimeOnline','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(173,NULL,1110115,5,1,1110100,'Banco Patagonia Problema Resuelto','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (174,NULL,1110116,5,1,1110100,'Banco Patagonia Graciela','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(175,NULL,1110117,5,1,1110100,'Banco Patagonia Omar','Activo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(176,NULL,1110118,5,1,1110100,'Cheques','Activo',NULL,1,2,1,1,1,0,NULL),(177,NULL,5120126,5,1,5120100,'Gisela Larzabal','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(178,NULL,5120127,5,1,5120100,'Google','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(179,NULL,5120128,5,1,5120100,'Seguro Moto','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(180,NULL,5120129,5,1,5120100,'Sueldo Agustina','Result. Negativo',NULL,0,1,0,0,0,0,NULL),(181,NULL,5120130,5,1,5120100,'Sueldo Betty','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(182,NULL,5120131,5,1,5120100,'Sueldo Elizabet','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(183,NULL,5120132,5,1,5120100,'Sueldo Florencia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(184,NULL,5120133,5,1,5120100,'Sueldo Graciela','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(185,NULL,5120134,5,1,5120100,'Sueldo Franco Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(186,NULL,5120135,5,1,5120100,'Sueldo Santiago Sanchez','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(187,NULL,5120136,5,1,5120100,'Sueldo Jose Luis','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(188,NULL,5120137,5,1,5120100,'Publicidad','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(189,NULL,5120138,5,1,5120100,'Las Nieves','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(190,NULL,5120139,5,1,5120100,'Sueldo Lidia','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(191,NULL,5120140,5,1,5120100,'Cargas Sociales','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(192,NULL,5120141,5,1,5120100,'Honorarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(193,NULL,5120142,5,1,5120100,'Telefono Fijo','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(194,NULL,5120143,5,1,5120100,'ONE DRIVE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(195,NULL,5120144,5,1,5120100,'OSDE','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(196,NULL,5120145,5,1,5120100,'SAS Constitucion','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(197,NULL,5120146,5,1,5120100,'Seguro de Vida Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(198,NULL,5120147,5,1,5120100,'Seguros','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(199,NULL,5120148,5,1,5120100,'Internet','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(200,NULL,5120149,5,1,5120100,'Seguro de Retiro Zurich','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(201,NULL,5140165,5,1,5140100,'Monotributo','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(202,NULL,5140104,5,1,5140100,'IVA In Time SRL','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(203,NULL,5140105,5,1,5140100,'Autonomos','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(204,NULL,5140106,5,1,5140100,'Multas Impositivas','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(207,NULL,5120150,5,1,5120100,'Vanesa Gastos','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(208,NULL,5140166,5,1,5140100,'Impuesto a los Ingresos Brutos - BS AS','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(209,NULL,5140107,5,1,5140100,'SIRCREB','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(210,NULL,5140108,5,1,5140100,'Consejo Ciencias Economicas','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(211,NULL,5120152,5,1,5120100,'Albano Andres','Result. Negativo',NULL,0,1,0,0,0,0,'2020-12-31 13:34:22'),(212,NULL,5120153,5,1,5120100,'Tarjeta Visa','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(213,NULL,5120154,5,1,5120100,'Tarjeta American Express','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(214,NULL,5120155,5,1,5120100,'Tarjeta Mastercard','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(215,NULL,5120156,5,1,5120100,'Imp. Municipales','Result. Negativo',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22');
INSERT INTO `conta_plan_cuenta` VALUES (216,NULL,5120157,5,1,5120100,'Perc/Ret. Imp. Ganancias','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(217,NULL,5120158,5,1,5120100,'Compras','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(218,NULL,4110106,5,2,4110100,'Ventas No Gravadas','Result. Positivo',NULL,1,2,0,0,0,1,NULL),(219,NULL,6110103,5,1,6110100,'Pagos AFIP','Movimiento',NULL,1,2,0,0,1,1,NULL),(220,NULL,5140167,5,1,5140100,'Perc IVA -RG3337','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(221,NULL,5140109,5,1,5140100,'Imps. Internos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(222,NULL,5140110,5,1,5140100,'Imp. Gasoil','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(223,NULL,5140111,5,1,5140100,'Imp. Hídricos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(224,NULL,5140112,5,1,5140100,'ITC','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(225,NULL,5140113,5,1,5140100,'Perc IIBB  Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(226,NULL,5140114,5,1,5140100,'Perc IIBB  Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(227,NULL,5140115,5,1,5140100,'Perc IIBB  Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(228,NULL,5140116,5,1,5140100,'Perc IIBB  Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(229,NULL,5140117,5,1,5140100,'Perc IIBB  Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(230,NULL,5140118,5,1,5140100,'Perc IIBB  Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(231,NULL,5140119,5,1,5140100,'Perc IIBB  Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(232,NULL,5140120,5,1,5140100,'Perc IIBB  Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(233,NULL,5140121,5,1,5140100,'Perc IIBB  Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(234,NULL,5140122,5,1,5140100,'Perc IIBB  Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(235,NULL,5140123,5,1,5140100,'Perc IIBB  La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(236,NULL,5140124,5,1,5140100,'Perc IIBB  La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(237,NULL,5140125,5,1,5140100,'Perc IIBB  Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(238,NULL,5140126,5,1,5140100,'Perc IIBB  Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(239,NULL,5140127,5,1,5140100,'Perc IIBB  Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(240,NULL,5140128,5,1,5140100,'Perc IIBB  Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(241,NULL,5140129,5,1,5140100,'Perc IIBB  Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(242,NULL,5140130,5,1,5140100,'Perc IIBB  Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(243,NULL,5140131,5,1,5140100,'Perc IIBB  San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(244,NULL,5140132,5,1,5140100,'Perc IIBB  San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(245,NULL,5140133,5,1,5140100,'Perc IIBB  Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(246,NULL,5140134,5,1,5140100,'Perc IIBB  Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(247,NULL,5140135,5,1,5140100,'Perc IIBB  Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(248,NULL,5140136,5,1,5140100,'Perc IIBB  Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(249,NULL,5140137,5,1,5140100,'Perc IIBB  Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(250,NULL,5140138,5,1,5140100,'Compras No Gravadas','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(251,NULL,1140108,5,1,1140100,'Retenciones de IIBB Buenos Aires','Activo',NULL,1,2,1,0,0,1,NULL),(252,NULL,1140109,5,1,1140100,'Retenciones de IIBB Capital Federal','Activo',NULL,1,2,1,0,0,1,NULL),(253,NULL,1140110,5,1,1140100,'Retenciones de IIBB Catamarca','Activo',NULL,1,2,1,0,0,1,NULL),(254,NULL,1140111,5,1,1140100,'Retenciones de IIBB Chaco','Activo',NULL,1,2,1,0,0,1,NULL),(255,NULL,1140112,5,1,1140100,'Retenciones de IIBB Chubut','Activo',NULL,1,2,1,0,0,1,NULL),(256,NULL,1140113,5,1,1140100,'Retenciones de IIBB Córdoba','Activo',NULL,1,2,1,0,0,1,NULL),(257,NULL,1140114,5,1,1140100,'Retenciones de IIBB Corrientes','Activo',NULL,1,2,1,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (258,NULL,1140115,5,1,1140100,'Retenciones de IIBB Entre Ríos','Activo',NULL,1,2,1,0,0,1,NULL),(259,NULL,1140116,5,1,1140100,'Retenciones de IIBB Formosa','Activo',NULL,1,2,1,0,0,1,NULL),(260,NULL,1140117,5,1,1140100,'Retenciones de IIBB Jujuy','Activo',NULL,1,2,1,0,0,1,NULL),(261,NULL,1140118,5,1,1140100,'Retenciones de IIBB La Pampa','Activo',NULL,1,2,1,0,0,1,NULL),(262,NULL,1140119,5,1,1140100,'Retenciones de IIBB La Rioja','Activo',NULL,1,2,1,0,0,1,NULL),(263,NULL,1140120,5,1,1140100,'Retenciones de IIBB Mendoza','Activo',NULL,1,2,1,0,0,1,NULL),(264,NULL,1140121,5,1,1140100,'Retenciones de IIBB Misiones','Activo',NULL,1,2,1,0,0,1,NULL),(265,NULL,1140122,5,1,1140100,'Retenciones de IIBB Neuquén','Activo',NULL,1,2,1,0,0,1,NULL),(266,NULL,1140123,5,1,1140100,'Retenciones de IIBB Pascua Lama','Activo',NULL,1,2,1,0,0,1,NULL),(267,NULL,1140124,5,1,1140100,'Retenciones de IIBB Río Negro','Activo',NULL,1,2,1,0,0,1,NULL),(268,NULL,1140125,5,1,1140100,'Retenciones de IIBB Salta','Activo',NULL,1,2,1,0,0,1,NULL),(269,NULL,1140126,5,1,1140100,'Retenciones de IIBB San Juan','Activo',NULL,1,2,1,0,0,1,NULL),(270,NULL,1140127,5,1,1140100,'Retenciones de IIBB San Luis','Activo',NULL,1,2,1,0,0,1,NULL),(271,NULL,1140128,5,1,1140100,'Retenciones de IIBB Santa Cruz','Activo',NULL,1,2,1,0,0,1,NULL),(272,NULL,1140129,5,1,1140100,'Retenciones de IIBB Santa Fe','Activo',NULL,1,2,1,0,0,1,NULL),(273,NULL,1140130,5,1,1140100,'Retenciones de IIBB Santiago del Estero','Activo',NULL,1,2,1,0,0,1,NULL),(274,NULL,1140131,5,1,1140100,'Retenciones de IIBB Tierra del Fuego','Activo',NULL,1,2,1,0,0,1,NULL),(275,NULL,1140132,5,1,1140100,'Retenciones de IIBB Tucuman','Activo',NULL,1,2,1,0,0,1,NULL),(276,NULL,5140168,5,1,5140100,'SIRCREB Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(277,NULL,5140139,5,1,5140100,'SIRCREB Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(278,NULL,5140140,5,1,5140100,'SIRCREB Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(279,NULL,5140141,5,1,5140100,'SIRCREB Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(280,NULL,5140142,5,1,5140100,'SIRCREB Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(281,NULL,5140143,5,1,5140100,'SIRCREB Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(282,NULL,5140144,5,1,5140100,'SIRCREB Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(283,NULL,5140145,5,1,5140100,'SIRCREB Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(284,NULL,5140146,5,1,5140100,'SIRCREB Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(285,NULL,5140147,5,1,5140100,'SIRCREB Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(286,NULL,5140148,5,1,5140100,'SIRCREB La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(287,NULL,5140149,5,1,5140100,'SIRCREB La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(288,NULL,5140150,5,1,5140100,'SIRCREB Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(289,NULL,5140151,5,1,5140100,'SIRCREB Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(290,NULL,5140152,5,1,5140100,'SIRCREB Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(291,NULL,5140153,5,1,5140100,'SIRCREB Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(292,NULL,5140154,5,1,5140100,'SIRCREB Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(293,NULL,5140155,5,1,5140100,'SIRCREB Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(294,NULL,5140156,5,1,5140100,'SIRCREB San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(295,NULL,5140157,5,1,5140100,'SIRCREB San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(296,NULL,5140158,5,1,5140100,'SIRCREB Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(297,NULL,5140159,5,1,5140100,'SIRCREB Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(298,NULL,5140160,5,1,5140100,'SIRCREB Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(299,NULL,5140161,5,1,5140100,'SIRCREB Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(300,NULL,5140162,5,1,5140100,'SIRCREB Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (301,NULL,1140326,5,1,1140300,'IIBB a Favor Buenos Aires','Activo',NULL,1,2,0,0,0,1,NULL),(302,NULL,1140302,5,1,1140300,'IIBB a Favor Capital Federal','Activo',NULL,1,2,0,0,0,1,NULL),(303,NULL,1140303,5,1,1140300,'IIBB a Favor Catamarca','Activo',NULL,1,2,0,0,0,1,NULL),(304,NULL,1140304,5,1,1140300,'IIBB a Favor Chaco','Activo',NULL,1,2,0,0,0,1,NULL),(305,NULL,1140305,5,1,1140300,'IIBB a Favor Chubut','Activo',NULL,1,2,0,0,0,1,NULL),(306,NULL,1140306,5,1,1140300,'IIBB a Favor Córdoba','Activo',NULL,1,2,0,0,0,1,NULL),(307,NULL,1140307,5,1,1140300,'IIBB a Favor Corrientes','Activo',NULL,1,2,0,0,0,1,NULL),(308,NULL,1140308,5,1,1140300,'IIBB a Favor Entre Ríos','Activo',NULL,1,2,0,0,0,1,NULL),(309,NULL,1140309,5,1,1140300,'IIBB a Favor Formosa','Activo',NULL,1,2,0,0,0,1,NULL),(310,NULL,1140310,5,1,1140300,'IIBB a Favor Jujuy','Activo',NULL,1,2,0,0,0,1,NULL),(311,NULL,1140311,5,1,1140300,'IIBB a Favor La Pampa','Activo',NULL,1,2,0,0,0,1,NULL),(312,NULL,1140312,5,1,1140300,'IIBB a Favor La Rioja','Activo',NULL,1,2,0,0,0,1,NULL),(313,NULL,1140313,5,1,1140300,'IIBB a Favor Mendoza','Activo',NULL,1,2,0,0,0,1,NULL),(314,NULL,1140314,5,1,1140300,'IIBB a Favor Misiones','Activo',NULL,1,2,0,0,0,1,NULL),(315,NULL,1140315,5,1,1140300,'IIBB a Favor Neuquén','Activo',NULL,1,2,0,0,0,1,NULL),(316,NULL,1140316,5,1,1140300,'IIBB a Favor Pascua Lama','Activo',NULL,1,2,0,0,0,1,NULL),(317,NULL,1140317,5,1,1140300,'IIBB a Favor Río Negro','Activo',NULL,1,2,0,0,0,1,NULL),(318,NULL,1140318,5,1,1140300,'IIBB a Favor Salta','Activo',NULL,1,2,0,0,0,1,NULL),(319,NULL,1140319,5,1,1140300,'IIBB a Favor San Juan','Activo',NULL,1,2,0,0,0,1,NULL),(320,NULL,1140320,5,1,1140300,'IIBB a Favor San Luis','Activo',NULL,1,2,0,0,0,1,NULL),(321,NULL,1140321,5,1,1140300,'IIBB a Favor Santa Cruz','Activo',NULL,1,2,0,0,0,1,NULL),(322,NULL,1140322,5,1,1140300,'IIBB a Favor Santa Fe','Activo',NULL,1,2,0,0,0,1,NULL),(323,NULL,1140323,5,1,1140300,'IIBB a Favor Santiago del Estero','Activo',NULL,1,2,0,0,0,1,NULL),(324,NULL,1140324,5,1,1140300,'IIBB a Favor Tierra del Fuego','Activo',NULL,1,2,0,0,0,1,NULL),(325,NULL,1140325,5,1,1140300,'IIBB a Favor Tucuman','Activo',NULL,1,2,0,0,0,1,NULL),(326,NULL,2110317,5,2,2110300,'IIBB a Pagar Buenos Aires','Pasivo',NULL,1,2,0,0,0,1,NULL),(327,NULL,2110318,5,2,2110300,'IIBB a Pagar Capital Federal','Pasivo',NULL,1,2,0,0,0,1,NULL),(328,NULL,2110319,5,2,2110300,'IIBB a Pagar Catamarca','Pasivo',NULL,1,2,0,0,0,1,NULL),(329,NULL,2110320,5,2,2110300,'IIBB a Pagar Chaco','Pasivo',NULL,1,2,0,0,0,1,NULL),(330,NULL,2110321,5,2,2110300,'IIBB a Pagar Chubut','Pasivo',NULL,1,2,0,0,0,1,NULL),(331,NULL,2110322,5,2,2110300,'IIBB a Pagar Córdoba','Pasivo',NULL,1,2,0,0,0,1,NULL),(332,NULL,2110323,5,2,2110300,'IIBB a Pagar Corrientes','Pasivo',NULL,1,2,0,0,0,1,NULL),(333,NULL,2110324,5,2,2110300,'IIBB a Pagar Entre Ríos','Pasivo',NULL,1,2,0,0,0,1,NULL),(334,NULL,2110325,5,2,2110300,'IIBB a Pagar Formosa','Pasivo',NULL,1,2,0,0,0,1,NULL),(335,NULL,2110326,5,2,2110300,'IIBB a Pagar Jujuy','Pasivo',NULL,1,2,0,0,0,1,NULL),(336,NULL,2110327,5,2,2110300,'IIBB a Pagar La Pampa','Pasivo',NULL,1,2,0,0,0,1,NULL),(337,NULL,2110328,5,2,2110300,'IIBB a Pagar La Rioja','Pasivo',NULL,1,2,0,0,0,1,NULL),(338,NULL,2110329,5,2,2110300,'IIBB a Pagar Mendoza','Pasivo',NULL,1,2,0,0,0,1,NULL),(339,NULL,2110330,5,2,2110300,'IIBB a Pagar Misiones','Pasivo',NULL,1,2,0,0,0,1,NULL),(340,NULL,2110331,5,2,2110300,'IIBB a Pagar Neuquén','Pasivo',NULL,1,2,0,0,0,1,NULL),(341,NULL,2110332,5,2,2110300,'IIBB a Pagar Pascua Lama','Pasivo',NULL,1,2,0,0,0,1,NULL),(342,NULL,2110333,5,2,2110300,'IIBB a Pagar Río Negro','Pasivo',NULL,1,2,0,0,0,1,NULL),(343,NULL,2110334,5,2,2110300,'IIBB a Pagar Salta','Pasivo',NULL,1,2,0,0,0,1,NULL),(344,NULL,2110335,5,2,2110300,'IIBB a Pagar San Juan','Pasivo',NULL,1,2,0,0,0,1,NULL),(345,NULL,2110336,5,2,2110300,'IIBB a Pagar San Luis','Pasivo',NULL,1,2,0,0,0,1,NULL),(346,NULL,2110337,5,2,2110300,'IIBB a Pagar Santa Cruz','Pasivo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (347,NULL,2110338,5,2,2110300,'IIBB a Pagar Santa Fe','Pasivo',NULL,1,2,0,0,0,1,NULL),(348,NULL,2110339,5,2,2110300,'IIBB a Pagar Santiago del Estero','Pasivo',NULL,1,2,0,0,0,1,NULL),(349,NULL,2110340,5,2,2110300,'IIBB a Pagar Tierra del Fuego','Pasivo',NULL,1,2,0,0,0,1,NULL),(350,NULL,2110341,5,2,2110300,'IIBB a Pagar Tucuman','Pasivo',NULL,1,2,0,0,0,1,NULL),(351,NULL,6110101,5,1,6110100,'BANCO SIRCREB','Movimiento',NULL,1,2,0,0,1,1,NULL),(352,NULL,6110102,5,1,6110100,'Compensacion','Movimiento',NULL,1,2,0,0,0,1,'2020-12-31 13:34:22'),(353,NULL,1140327,5,1,1140300,'IVA Saldo Tecnico','Activo',NULL,1,2,0,0,0,1,NULL),(354,NULL,1140328,5,1,1140300,'IVA Saldo Libre Disponibilidad','Activo',NULL,1,2,0,0,0,1,NULL),(355,NULL,6000000,1,1,0,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(356,NULL,6100000,2,1,6000000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(357,NULL,6110000,3,1,6100000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(358,NULL,4110000,3,2,4100000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(359,NULL,1110120,5,1,1110100,'Caja en Pesos','Activo',NULL,1,2,1,1,1,0,NULL),(360,NULL,1140211,5,1,1140200,'Retenciones Bancarias de Ganancias a Favor','Activo',NULL,1,2,0,0,1,1,NULL),(361,NULL,1220104,5,1,1220100,'Equipos de Computación','Activo',NULL,1,1,0,0,0,1,NULL),(362,NULL,1220105,5,1,1220100,'Computadoras','Activo',NULL,1,1,0,0,0,1,NULL),(363,NULL,1220304,5,1,1220300,'Muebles y Utiles','Activo',NULL,1,1,0,0,0,1,NULL),(364,NULL,2110105,5,2,2110100,'Anticipo de Clientes','Pasivo',NULL,1,2,0,0,1,1,NULL),(365,NULL,2110401,5,2,2110400,'Provision Honorarios','Pasivo',NULL,1,1,0,0,0,1,NULL),(366,NULL,2110106,5,2,2110100,'Cta. Cte Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(367,NULL,2110107,5,2,2110100,'Provisión Honorarios Directores','Pasivo',NULL,1,1,0,0,0,1,NULL),(368,NULL,2110110,5,2,2110100,'Cuenta Particular Socio 1','Pasivo',NULL,1,1,0,0,0,1,NULL),(369,NULL,3110104,5,2,3110100,'Capital','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(370,NULL,1120000,3,1,1100000,'INVERSIONES','Activo',NULL,1,1,0,0,0,0,NULL),(371,NULL,1160000,3,1,1100000,'OTROS ACTIVOS','Activo',NULL,1,1,0,0,0,0,NULL),(372,NULL,1160100,4,1,1160000,'OTROS','Activo',NULL,1,1,0,0,0,0,NULL),(373,NULL,2110400,4,2,2110000,'Provision de Honorarios','Pasivo',NULL,1,1,0,0,0,0,NULL),(374,NULL,3410100,4,1,3410000,'RESULTADOS ACUMULADOS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(375,NULL,3420000,3,1,3400000,'GANACIAS RESERVADAS','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(376,NULL,3420100,4,1,3420000,'Rerva Legal','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(377,NULL,1220400,4,1,1220000,'INMUEBLES','Activo',NULL,1,1,0,0,0,0,NULL),(378,NULL,1220500,4,1,1220000,'RODADOS','Activo',NULL,1,1,0,0,0,0,NULL),(379,NULL,1220600,4,1,1220000,'MAQUINARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(380,NULL,1220204,5,1,1220200,'Instalaciones','Activo',NULL,1,1,0,0,0,1,NULL),(381,NULL,3420101,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(382,NULL,3420102,5,2,3420100,'Reserva Legal','Patrimonio Neto',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(383,NULL,3410105,5,2,3410100,'Resultado no asignado','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(384,NULL,1110121,5,1,1110100,'Caja en Dolares','Activo',NULL,1,2,1,1,1,0,NULL),(385,NULL,1120100,4,1,1120000,'TEMPORARIAS','Activo',NULL,1,1,0,0,0,0,NULL),(386,NULL,1120101,5,1,1120100,'PLAZO FIJO','Activo',NULL,1,1,0,0,0,1,NULL),(387,NULL,1120200,4,1,1120000,'PERMANENTES','Activo',NULL,1,1,0,0,0,0,NULL),(388,NULL,1120201,5,1,1120200,'ACCIONES','Activo',NULL,1,1,0,0,0,1,NULL),(389,NULL,1220401,5,1,1220400,'Inmuebles','Activo',NULL,1,1,0,0,0,1,NULL),(390,NULL,1220501,5,1,1220500,'Vehiculos','Activo',NULL,1,1,0,0,0,1,NULL),(391,NULL,1220601,5,1,1220600,'Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(392,NULL,1150401,5,1,1150400,'MERCADERIAS','Activo',NULL,1,1,0,0,0,1,NULL),(393,NULL,1160101,5,1,1160100,'OTROS','Activo',NULL,1,1,0,0,0,1,NULL),(394,NULL,1230100,4,1,1230000,'INTANGIBLES','Activo',NULL,1,1,0,0,0,0,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (395,NULL,2110119,5,2,2110100,'Cuenta Particular Socio 2','Pasivo',NULL,1,1,0,0,0,1,NULL),(396,NULL,5120160,5,1,5120100,'Comisiones Y gastos Bancarios','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(397,NULL,4110100,4,2,4110000,'Ingresos Operativos','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(398,NULL,4120100,4,2,4120000,'OTROS INGRESOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(399,NULL,5110000,3,1,5100000,'GASTOS ORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(400,NULL,5120000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(401,NULL,5130000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(402,NULL,5140000,3,1,5100000,'GASTOS DE OPERACION','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(403,NULL,5210000,3,1,5200000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(404,NULL,5210100,4,1,5210000,'GASTOS EXTRAORDINARIOS','Result. Negativo',NULL,1,1,0,0,0,0,NULL),(405,NULL,6110100,4,1,6110000,'Movimiento','Movimiento',NULL,1,1,0,0,0,0,NULL),(406,NULL,1130100,4,1,1130000,'Operaciones Ordinarias','Activo',NULL,1,1,0,0,0,0,NULL),(407,NULL,3110000,3,2,3100000,'CAPITAL SOCIAL','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(408,NULL,3410000,3,2,3400000,'RESULTADOS ANTERIORES','Patrimonio Neto',NULL,1,1,0,0,0,0,NULL),(409,NULL,5110101,5,2,5110000,'IVA Crédito Fiscal No computable','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(410,NULL,1110203,5,1,1110200,'Banco ICBC Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(411,NULL,2110342,5,2,2110300,'Provisión Impuesto a las Ganancias','Pasivo',NULL,1,1,0,0,0,1,NULL),(412,NULL,5120107,5,2,5120000,'Amortización Muebles y Útiles','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(413,NULL,5120102,5,2,5120000,'Amortización Equipos','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(414,NULL,1220109,5,1,1220100,'Amortizacion Acumulada Equipos','Activo',NULL,1,1,0,0,0,1,NULL),(415,NULL,1220602,5,1,1220600,'Amortización Acumulada Maquinarias','Activo',NULL,1,1,0,0,0,1,NULL),(416,NULL,1160102,5,1,1160100,'Materias Primas','Activo',NULL,1,1,0,0,0,1,NULL),(417,NULL,1110204,5,1,1110200,'Banco Itaú Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(418,NULL,2110113,5,2,2110100,'Deudas Bancarias','Pasivo',NULL,1,2,0,1,1,1,NULL),(419,NULL,1220502,5,1,1220500,'Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(420,NULL,1220503,5,1,1220500,'Amortización Acumulada Rodados','Activo',NULL,1,1,0,0,0,1,NULL),(421,NULL,5120105,5,2,5120000,'Amortización Rodados','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(422,NULL,5120109,5,2,5120000,'Amortización Maquinarias','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(423,NULL,1220504,5,1,1220500,'Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(424,NULL,1220505,5,1,1220500,'Amortización Acumulada Accesorios','Activo',NULL,1,1,0,0,0,1,NULL),(425,NULL,1110205,5,1,1110200,'Banco Galicia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(426,NULL,3420101,5,2,3420000,'Reserva Facultativa','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(427,NULL,1140212,5,1,1140200,'Créditos por Impuestos Diferidos','Activo',NULL,1,1,0,0,0,1,NULL),(428,NULL,1160103,5,1,1160100,'Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(429,NULL,1160104,5,1,1160100,'Amortizacion Acumulada Fondo de Comercio','Activo',NULL,1,1,0,0,0,1,NULL),(430,NULL,1140213,5,1,1140200,'Intereses a devengar AGIP','Activo',NULL,1,1,0,0,0,1,NULL),(431,NULL,2110343,5,2,2110300,'PFP IIBB','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(432,NULL,1140330,5,1,1140300,'Pago a Cuenta ITC','Activo',NULL,1,2,0,0,0,1,NULL),(433,NULL,2110114,5,2,2110100,'Préstamo','Pasivo',NULL,1,2,0,1,1,1,NULL),(434,NULL,1160106,5,1,1160100,'Productos','Activo',NULL,1,1,0,0,0,1,NULL),(435,NULL,2110345,5,2,2110300,'Intereses a devengar PFP','Pasivo',NULL,1,1,0,0,0,1,NULL),(436,NULL,1110206,5,1,1110200,'Banco Provincia Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(437,NULL,1140215,5,1,1140200,'Imp. Ley 25413 Cred 0.6%','Activo',NULL,1,1,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (438,NULL,2110402,5,2,2110400,'Honorarios Directorio a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(439,NULL,3110101,5,2,3110100,'Reserva para Futuras Inversiones','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(440,NULL,1130106,5,1,1130100,'TEAC - Trabajos Ejecutados a Certificar','Activo',NULL,1,1,0,0,0,1,NULL),(441,NULL,2110115,5,2,2110100,'Leasing','Pasivo',NULL,1,2,0,1,1,1,NULL),(442,NULL,1110207,5,1,1110200,'Banco Comafi Cta. Cte','Activo',NULL,1,2,1,1,1,0,NULL),(443,NULL,2110500,4,2,2110000,'Deudas Financieras','Pasivo',NULL,1,1,0,0,0,0,NULL),(444,NULL,2110501,5,2,2110500,'Banco Santander Rio Cta Cte','Pasivo',NULL,1,1,0,0,0,1,NULL),(446,NULL,2210000,3,2,2200000,'Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(447,NULL,2210100,4,2,2210000,'Otras Deudas','Pasivo',NULL,1,1,0,0,0,0,NULL),(448,NULL,2210101,5,2,2210100,'Planes de Pagos AFIP','Pasivo',NULL,1,2,0,1,1,1,NULL),(449,NULL,2110502,5,2,2110500,'Leasing','Pasivo',NULL,1,1,0,0,0,1,NULL),(450,NULL,6110101,5,1,6110000,'Cheques Rechazados','Movimiento',NULL,1,2,0,0,1,1,NULL),(451,NULL,1110208,5,1,1110200,'Banco Patagonia Taxes Software','Activo',NULL,1,2,1,1,1,0,NULL),(452,NULL,1110209,5,1,1110200,'Banco Macro Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(453,NULL,1120202,5,1,1120200,'Inversión Central Caribe','Activo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(454,NULL,1120102,5,1,1120100,'Otras Inversiones','Activo',NULL,1,1,0,0,0,1,NULL),(455,NULL,1140216,5,1,1140200,'Otros Créditos','Activo',NULL,1,1,0,0,0,1,NULL),(456,NULL,2110403,5,2,2110400,'Provisión Honorarios Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(457,NULL,1110210,5,1,1110200,'Cheque Diferido Banco Santander Rio','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(458,NULL,1110211,5,1,1110200,'Cheque Diferido Banco Macro','Activo',NULL,1,2,1,1,1,0,'2020-12-31 13:34:22'),(459,NULL,2110204,5,2,2110200,'Moratoria SUSS a pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(460,NULL,2110344,5,2,2110300,'Impuestos Municipales a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(461,NULL,5110103,5,2,5110000,'Amortización Instalaciones','Result. Negativo',NULL,1,1,0,0,0,1,NULL),(462,NULL,5120110,5,2,5120000,'Amortización Equipos de comput.','Result. Negativo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(463,NULL,2110118,5,2,2110100,'Cuenta Particular Socio 3','Pasivo',NULL,1,1,0,0,0,1,NULL),(464,NULL,2110120,5,2,2110100,'Cuenta Particular Socio 4','Pasivo',NULL,1,1,0,0,0,1,NULL),(465,NULL,3110102,5,2,3110100,'Otras Reservas','Patrimonio Neto',NULL,1,1,0,0,0,1,NULL),(466,NULL,1140331,5,1,1140300,'IGMP (Saldo a Favor)','Activo',NULL,1,1,0,0,0,1,NULL),(467,NULL,5110104,5,2,5110000,'Interés','Result. Negativo',NULL,1,2,0,0,1,1,NULL),(468,NULL,1150402,5,1,1150400,'Productos en Proceso','Activo',NULL,1,1,0,0,0,1,NULL),(469,NULL,2110205,5,2,2110200,'Depósitos en Garantía Socio Gerente','Pasivo',NULL,1,1,0,0,0,1,NULL),(470,NULL,2110346,5,2,2110300,'Fondos Embargados','Pasivo',NULL,1,1,0,0,0,1,NULL),(471,NULL,2110347,5,2,2110300,'Cuota Solid.','Pasivo',NULL,1,1,0,0,0,1,'2020-12-31 13:34:22'),(472,NULL,1140332,5,1,1140300,'Anticipo Honorarios Directores','Activo',NULL,1,1,0,0,0,1,NULL),(473,NULL,2110348,5,2,2110300,'SICORE a Pagar','Pasivo',NULL,1,1,0,0,0,1,NULL),(474,NULL,1110212,5,1,1110200,'Banco Credicoop Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(475,NULL,1110213,5,1,1110200,'Banco Superville Cta. Cte.','Activo',NULL,1,2,1,1,1,0,NULL),(476,NULL,5110105,5,2,5110000,'RECPAM','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(477,NULL,1110125,5,1,1110100,'Caja Reales','Activo',NULL,1,2,1,1,1,0,NULL),(478,NULL,5140169,5,1,5140100,'CO2 - Imp. Al Carbono','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(479,NULL,1140300,4,1,1140000,'Anticipo de Impuestos','Activo',NULL,1,1,0,0,0,0,NULL),(480,NULL,2110600,4,2,2110000,'Retenciones Efectuadas','Pasivo',NULL,1,1,0,0,0,0,NULL),(481,NULL,4200000,2,2,4000000,'INGRESOS EXTRAORDINARIOS','Result. Positivo',NULL,1,1,0,0,0,0,NULL),(1001,NULL,5140170,5,1,5140100,'SIRTAC Córdoba','Result. Negativo',NULL,1,2,0,0,0,1,NULL);
INSERT INTO `conta_plan_cuenta` VALUES (1002,NULL,5140171,5,1,5140100,'SIRTAC Corrientes','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1003,NULL,5140172,5,1,5140100,'SIRTAC Chaco','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1004,NULL,5140173,5,1,5140100,'SIRTAC Chubut','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1005,NULL,5140174,5,1,5140100,'SIRTAC Entre Ríos','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1006,NULL,5140175,5,1,5140100,'SIRTAC Formosa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1007,NULL,5140176,5,1,5140100,'SIRTAC Jujuy','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1008,NULL,5140177,5,1,5140100,'SIRTAC La Pampa','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1009,NULL,5140178,5,1,5140100,'SIRTAC La Rioja','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1010,NULL,5140179,5,1,5140100,'SIRTAC Mendoza','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1011,NULL,5140180,5,1,5140100,'SIRTAC Misiones','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1012,NULL,5140181,5,1,5140100,'SIRTAC Neuquén','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1013,NULL,5140182,5,1,5140100,'SIRTAC Río Negro','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1014,NULL,5140183,5,1,5140100,'SIRTAC Salta','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1015,NULL,5140184,5,1,5140100,'SIRTAC San Juan','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1016,NULL,5140185,5,1,5140100,'SIRTAC San Luis','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1017,NULL,5140186,5,1,5140100,'SIRTAC Santa Cruz','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1018,NULL,5140187,5,1,5140100,'SIRTAC Santa Fe','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1019,NULL,5140188,5,1,5140100,'SIRTAC Santiago del Estero','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1020,NULL,5140189,5,1,5140100,'SIRTAC Tierra del Fuego','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1021,NULL,5140190,5,1,5140100,'SIRTAC Tucuman','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1022,NULL,5140191,5,1,5140100,'SIRTAC Capital Federal','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1023,NULL,5140192,5,1,5140100,'SIRTAC Buenos Aires','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1024,NULL,5140193,5,1,5140100,'SIRTAC Catamarca','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1025,NULL,5140194,5,1,5140100,'SIRTAC Pascua Lama','Result. Negativo',NULL,1,2,0,0,0,1,NULL),(1026,NULL,6110104,5,1,6110100,'BANCO SIRTAC','Movimiento',NULL,1,2,0,0,1,1,NULL);
/*!40000 ALTER TABLE `conta_plan_cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_asientos`
--

DROP TABLE IF EXISTS `conta_tipo_asientos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_asientos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_asientos`
--

LOCK TABLES `conta_tipo_asientos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_asientos` DISABLE KEYS */;
INSERT INTO `conta_tipo_asientos` VALUES (1,'Sueldos',NULL,NULL,NULL,11),(2,'Ingresos',NULL,NULL,NULL,9),(3,'Egresos',NULL,NULL,NULL,10),(4,'Amortizaciones',NULL,NULL,NULL,4),(5,'Banco',NULL,NULL,NULL,15),(6,'Ganancias',NULL,NULL,NULL,12),(7,'Retenciones',NULL,NULL,NULL,13),(8,'SIRCREB',NULL,NULL,NULL,14),(9,'Compensaciones',NULL,NULL,NULL,16),(10,'Pagos AFIP',NULL,NULL,NULL,17),(11,'Ajustes',NULL,NULL,NULL,3),(12,'Saldos Iniciales',NULL,NULL,NULL,1),(13,'Cancelacion de Iniciales',NULL,NULL,NULL,2),(14,'Patrimonio Neto',NULL,NULL,NULL,8),(15,'Liquidaciones IVA',NULL,NULL,NULL,18),(16,'Liquidacion IIBB',NULL,NULL,NULL,19),(17,'Asientos de Cierre',NULL,NULL,NULL,5),(18,'Reclasificacion',NULL,NULL,NULL,6),(19,'Otros',NULL,NULL,NULL,7),(20,'Cobranzas','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(21,'Pagos','2019-10-02 03:20:37','2019-10-02 03:20:37',NULL,NULL),(22,'Tesoreria','2019-10-19 02:10:24','2019-10-19 02:10:24',NULL,NULL),(23,'Ajuste por Inflacion','2020-03-01 06:39:20','2020-03-01 06:39:20',NULL,NULL),(24,'SIRTAC','2023-10-16 21:16:17','2023-10-16 21:16:17',NULL,20);
/*!40000 ALTER TABLE `conta_tipo_asientos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_cuentas`
--

DROP TABLE IF EXISTS `conta_tipo_cuentas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_cuentas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_cuentas`
--

LOCK TABLES `conta_tipo_cuentas` WRITE;
/*!40000 ALTER TABLE `conta_tipo_cuentas` DISABLE KEYS */;
INSERT INTO `conta_tipo_cuentas` VALUES (1,'Rubro',NULL,NULL,NULL),(2,'SubRubro',NULL,NULL,NULL),(3,'Grupo',NULL,NULL,NULL),(4,'SubGrupo',NULL,NULL,NULL),(5,'Cuenta',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_cuentas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conta_tipo_saldos`
--

DROP TABLE IF EXISTS `conta_tipo_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conta_tipo_saldos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `saldo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conta_tipo_saldos`
--

LOCK TABLES `conta_tipo_saldos` WRITE;
/*!40000 ALTER TABLE `conta_tipo_saldos` DISABLE KEYS */;
INSERT INTO `conta_tipo_saldos` VALUES (1,'Deudor',NULL,NULL,NULL),(2,'Acreedor',NULL,NULL,NULL);
/*!40000 ALTER TABLE `conta_tipo_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_cuits_afip`
--

DROP TABLE IF EXISTS `control_cuits_afip`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_cuits_afip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `field_name1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cuit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `control_cuits_afip_person_id_foreign` (`person_id`),
  CONSTRAINT `control_cuits_afip_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_cuits_afip`
--

LOCK TABLES `control_cuits_afip` WRITE;
/*!40000 ALTER TABLE `control_cuits_afip` DISABLE KEYS */;
/*!40000 ALTER TABLE `control_cuits_afip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `control_general`
--

DROP TABLE IF EXISTS `control_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `control_general` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` int(10) unsigned NOT NULL,
  `class_description` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `control_general_description_unique` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `control_general`
--

LOCK TABLES `control_general` WRITE;
/*!40000 ALTER TABLE `control_general` DISABLE KEYS */;
INSERT INTO `control_general` VALUES (1,'Ingresos - Egresos - Resultado',1,'Proyeccion Ganancias','control_general/proyecGanancias',NULL,NULL),(2,'IVA',2,'IVA','control_general/iva',NULL,NULL),(3,'IIBB',3,'IIBB','control_general/iibb',NULL,NULL),(4,'Por Mes',4,'Vto. Impuestos','control_general/vto',NULL,NULL),(5,'Por Impuesto',4,'Vto. Impuestos','control_general/vtoPorImpuestos',NULL,NULL);
/*!40000 ALTER TABLE `control_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cta_cte_cliente`
--

DROP TABLE IF EXISTS `cta_cte_cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cta_cte_cliente` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tipo_asiento_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `cta_cte_tesoreria_cuenta_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned NOT NULL,
  `compensado` tinyint(1) NOT NULL DEFAULT '0',
  `fecha` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `moneda_id` int(10) unsigned NOT NULL DEFAULT '1',
  `cotizacion` decimal(9,2) NOT NULL DEFAULT '1.00',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cta_cte_cliente_person_id_foreign` (`person_id`),
  KEY `cta_cte_cliente_person_id_relationed_foreign` (`person_id_relationed`),
  KEY `cta_cte_cliente_period_id_foreign` (`period_id`),
  KEY `cta_cte_cliente_saldo_id_foreign` (`saldo_id`),
  KEY `cta_cte_cliente_tipo_asiento_id_foreign` (`tipo_asiento_id`),
  KEY `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` (`cta_cte_tesoreria_cuenta_id`),
  KEY `cta_cte_cliente_moneda_id_foreign` (`moneda_id`),
  CONSTRAINT `cta_cte_cliente_cta_cte_tesoreria_cuenta_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_cuenta_id`) REFERENCES `cta_cte_tesoreria_cuentas` (`id`),
  CONSTRAINT `cta_cte_cliente_moneda_id_foreign` FOREIGN KEY (`moneda_id`) REFERENCES `monedas` (`id`),
  CONSTRAINT `cta_cte_cliente_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`),
  CONSTRAINT `cta_cte_cliente_saldo_id_foreign` FOREIGN KEY (`saldo_id`) REFERENCES `conta_tipo_saldos` (`id`),
  CONSTRAINT `cta_cte_cliente_tipo_asiento_id_foreign` FOREIGN KEY (`tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1370 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cta_cte_cliente`
--

LOCK TABLES `cta_cte_cliente` WRITE;
/*!40000 ALTER TABLE `cta_cte_cliente` DISABLE KEYS */;
INSERT INTO `cta_cte_cliente` VALUES (1,8119,2,40741,40742,13,3350,1,0,'2022-11-01',1409589.00,1,1.00,'Factura B N°: 0002-00000036',NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(2,8119,2,40741,40742,13,3350,1,0,'2022-11-04',1725742.60,1,1.00,'Factura B N°: 0002-00000037',NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(3,8119,2,40741,40742,13,3350,1,0,'2022-11-10',289995.70,1,1.00,'Factura B N°: 0002-00000038',NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(4,8119,2,40741,40742,13,3350,1,0,'2022-11-10',73652.20,1,1.00,'Factura B N°: 0002-00000039',NULL,'2022-12-19 21:12:33','2022-12-19 21:12:33',NULL),(5,8119,3,40741,40743,57,3350,2,0,'2022-11-03',9429.00,1,1.00,'Factura A N°: 0012-00029966',NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(6,8119,3,40741,40744,57,3350,2,0,'2022-11-04',849082.00,1,1.00,'Factura A N°: 0021-00000711',NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(7,8119,3,40741,40744,57,3350,2,0,'2022-11-04',24822.72,1,1.00,'Factura A N°: 0021-00000668',NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(8,8119,3,40741,40743,57,3350,2,0,'2022-11-11',29193.98,1,1.00,'Factura A N°: 0012-00030104',NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(9,8119,3,40741,40743,57,3350,2,0,'2022-11-11',112052.44,1,1.00,'Factura A N°: 0012-00030121',NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(10,8119,3,40741,40744,57,3350,2,0,'2022-11-15',77915.76,1,1.00,'Factura A N°: 0022-00000476',NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(11,8119,3,40741,40745,57,3350,2,0,'2022-11-15',1042151.87,1,1.00,'Factura A N°: 0001-00031511',NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(12,8119,3,40741,40745,57,3350,2,0,'2022-11-17',1266736.05,1,1.00,'Factura A N°: 0001-00031550',NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(13,8119,3,40741,40744,57,3350,2,0,'2022-11-29',679858.98,1,1.00,'Factura A N°: 0022-00000721',NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(14,8119,3,40741,40743,57,3350,2,0,'2022-11-29',193131.69,1,1.00,'Factura A N°: 0012-00030394',NULL,'2022-12-19 21:12:58','2022-12-19 21:12:58',NULL),(15,8119,2,40720,40746,13,1543,1,0,'2022-11-02',157763.43,1,1.00,'Factura A N°: 0003-00000257',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(16,8119,2,40720,40746,13,1543,1,0,'2022-11-03',231594.00,1,1.00,'Factura A N°: 0003-00000258',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(17,8119,2,40720,40746,13,1543,1,0,'2022-11-03',233510.64,1,1.00,'Factura A N°: 0003-00000259',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(18,8119,2,40720,40746,13,1543,1,0,'2022-11-05',225550.05,1,1.00,'Factura A N°: 0003-00000260',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(19,8119,2,40720,40746,13,1543,1,0,'2022-11-05',223698.75,1,1.00,'Factura A N°: 0003-00000261',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(20,8119,2,40720,40746,13,1543,1,0,'2022-11-05',159200.91,1,1.00,'Factura A N°: 0003-00000262',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(21,8119,2,40720,40747,13,1543,1,0,'2022-11-05',151900.98,1,1.00,'Factura A N°: 0003-00000263',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(22,8119,2,40720,40746,13,1543,2,0,'2022-11-05',233510.64,1,1.00,'Nota de crédito A N°: 0003-00000022',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(23,8119,2,40720,40746,13,1543,2,0,'2022-11-05',231594.00,1,1.00,'Nota de crédito A N°: 0003-00000023',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(24,8119,2,40720,40748,13,1543,1,0,'2022-11-07',656358.45,1,1.00,'Factura A N°: 0003-00000264',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(25,8119,2,40720,40746,13,1543,1,0,'2022-11-09',222773.10,1,1.00,'Factura A N°: 0003-00000265',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(26,8119,2,40720,40747,13,1543,1,0,'2022-11-09',103164.60,1,1.00,'Factura A N°: 0003-00000266',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL);
INSERT INTO `cta_cte_cliente` VALUES (27,8119,2,40720,40748,13,1543,1,0,'2022-11-10',245388.00,1,1.00,'Factura A N°: 0003-00000267',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(28,8119,2,40720,40746,13,1543,1,0,'2022-11-11',204122.16,1,1.00,'Factura A N°: 0003-00000268',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(29,8119,2,40720,40746,13,1543,1,0,'2022-11-11',182559.96,1,1.00,'Factura A N°: 0003-00000269',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(30,8119,2,40720,40746,13,1543,1,0,'2022-11-12',231103.95,1,1.00,'Factura A N°: 0003-00000270',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(31,8119,2,40720,40747,13,1543,1,0,'2022-11-14',119172.90,1,1.00,'Factura A N°: 0003-00000271',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(32,8119,2,40720,40746,13,1543,1,0,'2022-11-18',212028.30,1,1.00,'Factura A N°: 0003-00000272',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(33,8119,2,40720,40746,13,1543,1,0,'2022-11-18',367356.00,1,1.00,'Factura A N°: 0003-00000273',NULL,'2022-12-20 15:27:01','2022-12-20 15:27:01',NULL),(34,8119,2,40720,40747,13,1543,1,0,'2022-11-18',124153.26,1,1.00,'Factura A N°: 0003-00000274',NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(35,8119,2,40720,40748,13,1543,1,0,'2022-11-25',838203.30,1,1.00,'Factura A N°: 0003-00000275',NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(36,8119,2,40720,40749,13,1543,1,0,'2022-11-25',792792.00,1,1.00,'Factura A N°: 0003-00000276',NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(37,8119,2,40720,40749,13,1543,1,0,'2022-11-25',429550.00,1,1.00,'Factura A N°: 0003-00000277',NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(38,8119,2,40720,40749,13,1543,1,0,'2022-11-25',792792.00,1,1.00,'Factura A N°: 0003-00000278',NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(39,8119,2,40720,40749,13,1543,2,0,'2022-11-25',792792.00,1,1.00,'Nota de crédito A N°: 0003-00000024',NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(40,8119,2,40720,40747,13,1543,1,0,'2022-11-26',124509.00,1,1.00,'Factura A N°: 0003-00000279',NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(41,8119,2,40720,40750,13,1543,1,0,'2022-11-26',1542387.00,1,1.00,'Factura A N°: 0003-00000280',NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(42,8119,2,40720,40750,13,1543,1,0,'2022-11-26',627627.00,1,1.00,'Factura A N°: 0003-00000281',NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(43,8119,2,40720,40746,13,1543,1,0,'2022-11-28',164511.60,1,1.00,'Factura A N°: 0003-00000282',NULL,'2022-12-20 15:27:02','2022-12-20 15:27:02',NULL),(44,8119,3,40720,40751,57,1543,2,0,'2022-11-01',110575.46,1,1.00,'Factura A N°: 0003-00022832',NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(45,8119,3,40720,40751,57,1543,2,0,'2022-11-07',128657.18,1,1.00,'Factura A N°: 0003-00022904',NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(46,8119,3,40720,40751,57,1543,2,0,'2022-11-11',94212.18,1,1.00,'Factura A N°: 0003-00022961',NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(47,8119,3,40720,40752,57,1543,2,0,'2022-11-14',1490.00,1,1.00,'Factura B N°: 1417-01932097',NULL,'2022-12-20 15:27:09','2022-12-20 16:27:45','2022-12-20 16:27:45'),(48,8119,3,40720,40753,57,1543,2,0,'2022-11-17',1578.00,1,1.00,'Factura B N°: 0003-00005960',NULL,'2022-12-20 15:27:09','2022-12-20 16:27:01','2022-12-20 16:27:01'),(49,8119,3,40720,40751,57,1543,2,0,'2022-11-17',210889.03,1,1.00,'Factura A N°: 0003-00023026',NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(50,8119,3,40720,40754,57,1543,2,0,'2022-11-25',38403.56,1,1.00,'Factura B N°: 1346-12207211',NULL,'2022-12-20 15:27:09','2022-12-20 16:28:27','2022-12-20 16:28:27'),(51,8119,3,40720,40751,57,1543,2,0,'2022-11-25',373101.81,1,1.00,'Factura A N°: 0003-00023121',NULL,'2022-12-20 15:27:09','2022-12-20 15:27:09',NULL),(52,8119,3,40720,40755,57,1543,2,0,'2022-11-29',331834.61,1,1.00,'Factura A N°: 0004-00002715',NULL,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL);
INSERT INTO `cta_cte_cliente` VALUES (53,8119,3,40720,40751,57,1543,2,0,'2022-11-29',13513.91,1,1.00,'Factura A N°: 0003-00023150',NULL,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL),(54,8119,3,40720,40756,57,1543,2,0,'2022-11-30',8050.00,1,1.00,'Factura C N°: 0002-00000273',NULL,'2022-12-20 15:27:10','2022-12-20 15:27:10',NULL),(55,8119,3,40720,40757,57,1543,2,0,'2022-11-25',206063.00,1,1.00,'Factura A N°: 0002-00472215',NULL,'2022-12-20 16:00:48','2022-12-20 16:00:48',NULL),(56,8119,3,40720,40757,57,1543,2,0,'2022-11-09',302500.62,1,1.00,'Factura A N°: 0002-00470517',NULL,'2022-12-20 16:02:30','2022-12-20 16:02:30',NULL),(57,8119,3,40720,40758,57,1543,2,0,'2022-11-09',194713.20,1,1.00,'Factura A N°: 0003-00092926',NULL,'2022-12-20 16:07:16','2022-12-20 16:07:16',NULL),(58,8119,3,40720,40759,57,1543,2,0,'2022-11-30',278300.00,1,1.00,'Factura A N°: 0002-00099082',NULL,'2022-12-20 16:08:34','2022-12-20 16:08:34',NULL),(59,8119,3,40720,40759,57,1543,2,0,'2022-11-03',193600.00,1,1.00,'RECIBO B N°: 0002-00096391',NULL,'2022-12-20 16:09:23','2022-12-20 16:30:36','2022-12-20 16:30:36'),(60,8119,3,40720,40760,57,1543,2,0,'2022-11-04',229416.00,1,1.00,'Factura A N°: 0002-00600706',NULL,'2022-12-20 16:10:29','2022-12-20 16:10:29',NULL),(61,8119,3,40720,40761,57,1543,2,0,'2022-11-23',313128.64,1,1.00,'Factura A N°: 0002-00090685',NULL,'2022-12-20 16:13:57','2022-12-20 16:13:57',NULL),(62,8119,3,40720,40761,57,1543,2,0,'2022-11-14',257965.95,1,1.00,'Factura A N°: 0002-00089764',NULL,'2022-12-20 16:14:47','2022-12-20 16:14:47',NULL),(63,8119,3,40720,40762,57,1543,2,0,'2022-11-29',175138.06,1,1.00,'RECIBO B N°: 0006-00029414',NULL,'2022-12-20 16:15:36','2022-12-20 16:27:28','2022-12-20 16:27:28'),(64,8119,3,40720,40762,57,1543,2,0,'2022-11-10',270961.35,1,1.00,'RECIBO B N°: 0006-00027575',NULL,'2022-12-20 16:16:09','2022-12-20 16:27:17','2022-12-20 16:27:17'),(65,8119,3,40720,40763,57,1543,2,0,'2022-11-10',217800.00,1,1.00,'Factura A N°: 0016-00540540',NULL,'2022-12-20 16:17:01','2022-12-20 16:17:01',NULL),(66,8119,3,40720,40763,57,1543,2,0,'2022-11-01',328757.00,1,1.00,'Factura A N°: 0016-00539072',NULL,'2022-12-20 16:17:22','2022-12-20 16:17:22',NULL),(67,8119,3,40720,40764,57,1543,2,0,'2022-11-01',436810.00,1,1.00,'Factura A N°: 0009-00095586',NULL,'2022-12-20 16:18:05','2022-12-20 16:18:05',NULL),(68,8119,3,40720,40764,57,1543,2,0,'2022-11-01',294977.43,1,1.00,'Factura A N°: 0009-00094473',NULL,'2022-12-20 16:18:21','2022-12-20 16:18:21',NULL),(69,8119,3,40720,40765,57,1543,2,0,'2022-11-21',463319.89,1,1.00,'Factura A N°: 0005-00556355',NULL,'2022-12-20 16:18:57','2022-12-20 16:18:57',NULL),(70,8119,3,40720,40765,57,1543,2,0,'2022-11-11',340711.80,1,1.00,'Factura A N°: 0005-00555347',NULL,'2022-12-20 16:19:17','2022-12-20 16:19:17',NULL),(71,8119,3,40720,40753,57,1543,2,0,'2022-11-17',1578.00,1,1.00,'Factura A N°: 0003-00005960',NULL,'2022-12-20 16:27:01','2022-12-20 16:27:01',NULL),(72,8119,3,40720,40762,57,1543,2,0,'2022-11-10',270961.35,1,1.00,'Factura A N°: 0006-00027575',NULL,'2022-12-20 16:27:17','2022-12-20 16:27:17',NULL),(73,8119,3,40720,40762,57,1543,2,0,'2022-11-29',175138.06,1,1.00,'Factura A N°: 0006-00029414',NULL,'2022-12-20 16:27:28','2022-12-20 16:27:28',NULL),(74,8119,3,40720,40754,57,1543,2,0,'2022-11-25',38403.56,1,1.00,'Factura B N°: 1346-12207211',NULL,'2022-12-20 16:28:27','2022-12-20 16:29:57','2022-12-20 16:29:57'),(75,8119,3,40720,40759,57,1543,2,0,'2022-11-03',193600.00,1,1.00,'Factura A N°: 0002-00096391',NULL,'2022-12-20 16:30:36','2022-12-20 16:30:36',NULL),(76,8119,2,40776,40777,13,20318,1,0,'2022-12-05',5804500.00,1,1.00,'Factura A N°: 0012-00008526',NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(77,8119,2,40776,40778,13,20318,1,0,'2022-12-05',403535.00,1,1.00,'Factura A N°: 0012-00008527',NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42');
INSERT INTO `cta_cte_cliente` VALUES (78,8119,2,40776,40779,13,20318,1,0,'2022-12-05',336846.00,1,1.00,'Factura A N°: 0012-00008528',NULL,'2023-01-06 10:34:32','2023-01-06 11:16:42','2023-01-06 11:16:42'),(79,8119,2,40776,40780,13,20318,1,0,'2022-12-05',1377333.75,1,1.00,'Factura A N°: 0100-00001651',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(80,8119,2,40776,40781,13,20318,1,0,'2022-12-05',3061861.40,1,1.00,'Factura A N°: 0100-00001652',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(81,8119,2,40776,40782,13,20318,1,0,'2022-12-06',104301.93,1,1.00,'Factura A N°: 0012-00008529',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(82,8119,2,40776,40783,13,20318,1,0,'2022-12-06',13219.25,1,1.00,'Factura A N°: 0012-00008530',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(83,8119,2,40776,40784,13,20318,1,0,'2022-12-06',662970.00,1,1.00,'Factura A N°: 0012-00008531',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(84,8119,2,40776,40785,13,20318,1,0,'2022-12-06',56870.00,1,1.00,'Factura A N°: 0012-00008532',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(85,8119,2,40776,40786,13,20318,1,0,'2022-12-06',471562.50,1,1.00,'Factura A N°: 0012-00008533',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(86,8119,2,40776,40787,13,20318,1,0,'2022-12-06',2077393.50,1,1.00,'Factura A N°: 0100-00001653',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(87,8119,2,40776,40781,13,20318,1,0,'2022-12-06',1852870.50,1,1.00,'Factura A N°: 0100-00001654',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(88,8119,2,40776,40788,13,20318,1,0,'2022-12-06',257868.00,1,1.00,'Factura A N°: 0100-00001655',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(89,8119,2,40776,40789,13,20318,2,0,'2022-12-06',512400.00,1,1.00,'Nota de crédito A N°: 0012-00000790',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(90,8119,2,40776,40790,13,20318,1,0,'2022-12-06',512400.00,1,1.00,'Nota de débito B N°: 0012-00000003',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(91,8119,2,40776,40781,13,20318,1,0,'2022-12-07',212321.20,1,1.00,'Factura A N°: 0012-00008534',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(92,8119,2,40776,40788,13,20318,1,0,'2022-12-07',128934.00,1,1.00,'Factura A N°: 0100-00001656',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(93,8119,2,40776,40791,13,20318,1,0,'2022-12-12',322335.00,1,1.00,'Factura A N°: 0012-00008535',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(94,8119,2,40776,40792,13,20318,1,0,'2022-12-12',60663.20,1,1.00,'Factura A N°: 0012-00008536',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(95,8119,2,40776,40780,13,20318,1,0,'2022-12-12',878826.00,1,1.00,'Factura A N°: 0012-00008537',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(96,8119,2,40776,40793,13,20318,1,0,'2022-12-12',2406448.00,1,1.00,'Factura A N°: 0012-00008538',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(97,8119,2,40776,40780,13,20318,1,0,'2022-12-12',409402.50,1,1.00,'Factura A N°: 0012-00008539',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(98,8119,2,40776,40781,13,20318,1,0,'2022-12-12',1550542.50,1,1.00,'Factura A N°: 0012-00008540',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(99,8119,2,40776,40794,13,20318,1,0,'2022-12-12',897729.25,1,1.00,'Factura A N°: 0012-00008541',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(100,8119,2,40776,40795,13,20318,1,0,'2022-12-12',821650.50,1,1.00,'Factura A N°: 0012-00008542',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42');
INSERT INTO `cta_cte_cliente` VALUES (101,8119,2,40776,40796,13,20318,1,0,'2022-12-12',417232.20,1,1.00,'Factura A N°: 0012-00008543',NULL,'2023-01-06 10:34:33','2023-01-06 11:16:42','2023-01-06 11:16:42'),(102,8119,2,40776,40779,13,20318,1,0,'2022-12-12',32178.00,1,1.00,'Factura A N°: 0012-00008544',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(103,8119,2,40776,40797,13,20318,1,0,'2022-12-12',2174217.50,1,1.00,'Factura A N°: 0012-00008545',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(104,8119,2,40776,40798,13,20318,1,0,'2022-12-12',294393.00,1,1.00,'Factura A N°: 0012-00008546',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(105,8119,2,40776,40781,13,20318,1,0,'2022-12-12',1895107.50,1,1.00,'Factura A N°: 0012-00008547',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(106,8119,2,40776,40799,13,20318,1,0,'2022-12-12',3811.50,1,1.00,'Factura A N°: 0012-00008548',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(107,8119,2,40776,40797,13,20318,1,0,'2022-12-12',310602.50,1,1.00,'Factura A N°: 0012-00008549',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(108,8119,2,40776,40794,13,20318,1,0,'2022-12-12',22990.00,1,1.00,'Factura A N°: 0012-00008550',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(109,8119,2,40776,40780,13,20318,1,0,'2022-12-12',9880.00,1,1.00,'Factura A N°: 0012-00008551',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(110,8119,2,40776,40800,13,20318,1,0,'2022-12-12',6276391.00,1,1.00,'Factura A N°: 0100-00001657',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(111,8119,2,40776,40782,13,20318,2,0,'2022-12-12',3890.25,1,1.00,'Nota de crédito A N°: 0012-00000791',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:42','2023-01-06 11:16:42'),(112,8119,2,40776,40801,13,20318,1,0,'2022-12-14',4037832.50,1,1.00,'Factura A N°: 0012-00008552',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(113,8119,2,40776,40802,13,20318,1,0,'2022-12-14',45486.00,1,1.00,'Factura A N°: 0012-00008553',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(114,8119,2,40776,40803,13,20318,1,0,'2022-12-14',409587.75,1,1.00,'Factura A N°: 0012-00008554',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(115,8119,2,40776,40803,13,20318,1,0,'2022-12-14',409587.75,1,1.00,'Factura A N°: 0012-00008555',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(116,8119,2,40776,40803,13,20318,1,0,'2022-12-14',464199.45,1,1.00,'Factura A N°: 0012-00008556',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(117,8119,2,40776,40804,13,20318,1,0,'2022-12-14',10890.00,1,1.00,'Factura A N°: 0012-00008557',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(118,8119,2,40776,40780,13,20318,1,0,'2022-12-14',505362.00,1,1.00,'Factura A N°: 0012-00008558',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(119,8119,2,40776,40782,13,20318,1,0,'2022-12-14',937982.50,1,1.00,'Factura A N°: 0012-00008559',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(120,8119,2,40776,40799,13,20318,1,0,'2022-12-14',150584.50,1,1.00,'Factura A N°: 0012-00008560',NULL,'2023-01-06 10:34:34','2023-01-06 11:16:43','2023-01-06 11:16:43'),(121,8119,2,40776,40805,13,20318,1,0,'2022-12-14',373315.80,1,1.00,'Factura A N°: 0012-00008561',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(122,8119,2,40776,40806,13,20318,1,0,'2022-12-14',1359035.70,1,1.00,'Factura A N°: 0012-00008562',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(123,8119,2,40776,40807,13,20318,1,0,'2022-12-14',1703410.80,1,1.00,'Factura A N°: 0012-00008563',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43');
INSERT INTO `cta_cte_cliente` VALUES (124,8119,2,40776,40808,13,20318,1,0,'2022-12-14',675668.50,1,1.00,'Factura A N°: 0012-00008564',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(125,8119,2,40776,40809,13,20318,1,0,'2022-12-14',9569212.25,1,1.00,'Factura A N°: 0012-00008565',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(126,8119,2,40776,40810,13,20318,1,0,'2022-12-14',1384633.25,1,1.00,'Factura A N°: 0012-00008566',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(127,8119,2,40776,40811,13,20318,1,0,'2022-12-14',304315.00,1,1.00,'Factura A N°: 0012-00008567',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(128,8119,2,40776,40788,13,20318,1,0,'2022-12-14',290101.50,1,1.00,'Factura A N°: 0012-00008568',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(129,8119,2,40776,40788,13,20318,1,0,'2022-12-14',290101.50,1,1.00,'Factura A N°: 0012-00008569',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(130,8119,2,40776,40812,13,20318,1,0,'2022-12-14',124982.00,1,1.00,'Factura A N°: 0012-00008570',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(131,8119,2,40776,40813,13,20318,1,0,'2022-12-14',450168.03,1,1.00,'Factura A N°: 0100-00001658',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(132,8119,2,40776,40781,13,20318,1,0,'2022-12-14',2372904.30,1,1.00,'Factura A N°: 0100-00001659',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(133,8119,2,40776,40788,13,20318,2,0,'2022-12-14',290101.50,1,1.00,'Nota de crédito A N°: 0012-00000792',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(134,8119,2,40776,40794,13,20318,2,0,'2022-12-14',920719.25,1,1.00,'Nota de crédito A N°: 0012-00000793',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(135,8119,2,40776,40814,13,20318,1,0,'2022-12-14',2015170.30,1,1.00,'Factura B N°: 0012-00000176',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(136,8119,2,40776,40783,13,20318,1,0,'2022-12-16',223722.95,1,1.00,'Factura A N°: 0012-00008571',NULL,'2023-01-06 10:34:35','2023-01-06 11:16:43','2023-01-06 11:16:43'),(137,8119,2,40776,40792,13,20318,1,0,'2022-12-16',769652.00,1,1.00,'Factura A N°: 0012-00008572',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(138,8119,2,40776,40781,13,20318,1,0,'2022-12-16',709137.00,1,1.00,'Factura A N°: 0100-00001660',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(139,8119,2,40776,40815,13,20318,1,0,'2022-12-19',3083177.50,1,1.00,'Factura A N°: 0012-00008573',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(140,8119,2,40776,40805,13,20318,1,0,'2022-12-19',1165099.00,1,1.00,'Factura A N°: 0012-00008574',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(141,8119,2,40776,40780,13,20318,1,0,'2022-12-19',2248095.20,1,1.00,'Factura A N°: 0012-00008575',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(142,8119,2,40776,40780,13,20318,1,0,'2022-12-19',2061338.50,1,1.00,'Factura A N°: 0012-00008576',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(143,8119,2,40776,40778,13,20318,1,0,'2022-12-19',94198.50,1,1.00,'Factura A N°: 0012-00008577',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(144,8119,2,40776,40816,13,20318,1,0,'2022-12-19',1013836.80,1,1.00,'Factura A N°: 0012-00008578',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(145,8119,2,40776,40785,13,20318,1,0,'2022-12-19',517335.50,1,1.00,'Factura A N°: 0012-00008579',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(146,8119,2,40776,40817,13,20318,1,0,'2022-12-19',372852.60,1,1.00,'Factura A N°: 0012-00008580',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43');
INSERT INTO `cta_cte_cliente` VALUES (147,8119,2,40776,40818,13,20318,1,0,'2022-12-19',339380.80,1,1.00,'Factura A N°: 0012-00008581',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(148,8119,2,40776,40779,13,20318,1,0,'2022-12-19',420980.00,1,1.00,'Factura A N°: 0012-00008582',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(149,8119,2,40776,40779,13,20318,1,0,'2022-12-19',1386320.00,1,1.00,'Factura A N°: 0012-00008583',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(150,8119,2,40776,40781,13,20318,1,0,'2022-12-19',1664162.50,1,1.00,'Factura A N°: 0100-00001661',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(151,8119,2,40776,40788,13,20318,1,0,'2022-12-19',193401.00,1,1.00,'Factura A N°: 0100-00001662',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(152,8119,2,40776,40819,13,20318,1,0,'2022-12-19',1999958.18,1,1.00,'Factura A N°: 0100-00001663',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(153,8119,2,40776,40820,13,20318,1,0,'2022-12-19',201465.55,1,1.00,'Factura A N°: 0100-00001664',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(154,8119,2,40776,40821,13,20318,1,0,'2022-12-19',765004.70,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0012-00000050',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(155,8119,2,40776,40802,13,20318,1,0,'2022-12-21',12852.00,1,1.00,'Factura A N°: 0012-00008584',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(156,8119,2,40776,40793,13,20318,1,0,'2022-12-21',150403.00,1,1.00,'Factura A N°: 0012-00008585',NULL,'2023-01-06 10:34:36','2023-01-06 11:16:43','2023-01-06 11:16:43'),(157,8119,2,40776,40780,13,20318,1,0,'2022-12-21',2227507.75,1,1.00,'Factura A N°: 0012-00008586',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(158,8119,2,40776,40822,13,20318,1,0,'2022-12-21',2559755.00,1,1.00,'Factura A N°: 0012-00008587',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(159,8119,2,40776,40781,13,20318,1,0,'2022-12-21',2113233.20,1,1.00,'Factura A N°: 0100-00001665',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(160,8119,2,40776,40823,13,20318,1,0,'2022-12-21',8826590.20,1,1.00,'Factura A N°: 0100-00001666',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(161,8119,2,40776,40781,13,20318,1,0,'2022-12-21',2119136.50,1,1.00,'Factura A N°: 0100-00001667',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(162,8119,2,40776,40815,13,20318,2,0,'2022-12-21',1691147.25,1,1.00,'Nota de crédito A N°: 0012-00000794',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(163,8119,2,40776,40824,13,20318,1,0,'2022-12-22',867958.00,1,1.00,'Factura A N°: 0012-00008588',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(164,8119,2,40776,40825,13,20318,1,0,'2022-12-22',596046.00,1,1.00,'Factura A N°: 0012-00008589',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(165,8119,2,40776,40796,13,20318,1,0,'2022-12-22',149011.50,1,1.00,'Factura A N°: 0012-00008590',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(166,8119,2,40776,40826,13,20318,1,0,'2022-12-22',1134374.40,1,1.00,'Factura A N°: 0012-00008591',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(167,8119,2,40776,40827,13,20318,1,0,'2022-12-22',1408680.00,1,1.00,'Factura A N°: 0012-00008592',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(168,8119,2,40776,40782,13,20318,1,0,'2022-12-22',302575.00,1,1.00,'Factura A N°: 0012-00008593',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(169,8119,2,40776,40799,13,20318,1,0,'2022-12-22',11495.00,1,1.00,'Factura A N°: 0012-00008594',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43');
INSERT INTO `cta_cte_cliente` VALUES (170,8119,2,40776,40817,13,20318,1,0,'2022-12-22',928521.00,1,1.00,'Factura A N°: 0012-00008595',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(171,8119,2,40776,40826,13,20318,1,0,'2022-12-22',1064025.60,1,1.00,'Factura A N°: 0012-00008596',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(172,8119,2,40776,40782,13,20318,1,0,'2022-12-22',191696.70,1,1.00,'Factura A N°: 0012-00008597',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(173,8119,2,40776,40782,13,20318,1,0,'2022-12-22',2104687.00,1,1.00,'Factura A N°: 0012-00008598',NULL,'2023-01-06 10:34:37','2023-01-06 11:16:43','2023-01-06 11:16:43'),(174,8119,2,40776,40809,13,20318,1,0,'2022-12-22',1627915.25,1,1.00,'Factura A N°: 0012-00008599',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:43','2023-01-06 11:16:43'),(175,8119,2,40776,40791,13,20318,1,0,'2022-12-22',465903.75,1,1.00,'Factura A N°: 0100-00001668',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(176,8119,2,40776,40788,13,20318,1,0,'2022-12-22',128934.00,1,1.00,'Factura A N°: 0100-00001669',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(177,8119,2,40776,40828,13,20318,1,0,'2022-12-22',704568.48,1,1.00,'Factura A N°: 0100-00001670',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(178,8119,2,40776,40822,13,20318,2,0,'2022-12-22',1405354.50,1,1.00,'Nota de crédito A N°: 0012-00000795',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(179,8119,2,40776,40826,13,20318,2,0,'2022-12-22',1134374.40,1,1.00,'Nota de crédito A N°: 0012-00000796',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(180,8119,2,40776,40829,13,20318,1,0,'2022-12-26',1264578.25,1,1.00,'Factura A N°: 0012-00008600',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(181,8119,2,40776,40821,13,20318,1,0,'2022-12-26',595334.40,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0100-00000062',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(182,8119,2,40776,40830,13,20318,1,0,'2022-12-27',594352.00,1,1.00,'Factura A N°: 0012-00008601',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(183,8119,2,40776,40831,13,20318,1,0,'2022-12-27',2738835.00,1,1.00,'Factura A N°: 0012-00008602',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(184,8119,2,40776,40832,13,20318,1,0,'2022-12-27',1521575.00,1,1.00,'Factura A N°: 0012-00008603',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(185,8119,2,40776,40833,13,20318,1,0,'2022-12-27',767500.00,1,1.00,'Factura A N°: 0012-00008604',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(186,8119,2,40776,40834,13,20318,1,0,'2022-12-27',1167075.00,1,1.00,'Factura A N°: 0012-00008605',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(187,8119,2,40776,40791,13,20318,1,0,'2022-12-27',434843.50,1,1.00,'Factura A N°: 0012-00008606',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(188,8119,2,40776,40835,13,20318,1,0,'2022-12-27',440125.00,1,1.00,'Factura A N°: 0012-00008607',NULL,'2023-01-06 10:34:38','2023-01-06 11:16:44','2023-01-06 11:16:44'),(189,8119,2,40776,40836,13,20318,1,0,'2022-12-27',5413056.00,1,1.00,'Factura A N°: 0012-00008608',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(190,8119,2,40776,40828,13,20318,1,0,'2022-12-27',1008452.72,1,1.00,'Factura A N°: 0100-00001671',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(191,8119,2,40776,40837,13,20318,1,0,'2022-12-27',1747574.40,1,1.00,'Factura A N°: 0100-00001672',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(192,8119,2,40776,40783,13,20318,1,0,'2022-12-27',791219.00,1,1.00,'Factura A N°: 0100-00001673',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44');
INSERT INTO `cta_cte_cliente` VALUES (193,8119,2,40776,40838,13,20318,1,0,'2022-12-29',2122582.00,1,1.00,'Factura A N°: 0012-00008609',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(194,8119,2,40776,40839,13,20318,1,0,'2022-12-29',612332.60,1,1.00,'Factura A N°: 0012-00008610',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(195,8119,2,40776,40840,13,20318,1,0,'2022-12-29',105282.10,1,1.00,'Factura A N°: 0012-00008611',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(196,8119,2,40776,40801,13,20318,1,0,'2022-12-29',3727230.00,1,1.00,'Factura A N°: 0012-00008612',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(197,8119,2,40776,40841,13,20318,1,0,'2022-12-29',3043150.00,1,1.00,'Factura A N°: 0012-00008613',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(198,8119,2,40776,40842,13,20318,1,0,'2022-12-29',2035583.00,1,1.00,'Factura A N°: 0012-00008614',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(199,8119,2,40776,40842,13,20318,1,0,'2022-12-29',598514.40,1,1.00,'Factura A N°: 0012-00008615',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(200,8119,2,40776,40843,13,20318,1,0,'2022-12-29',458975.40,1,1.00,'Factura A N°: 0012-00008616',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(201,8119,2,40776,40844,13,20318,1,0,'2022-12-29',3024032.00,1,1.00,'Factura A N°: 0100-00001674',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(202,8119,2,40776,40837,13,20318,1,0,'2022-12-29',1180289.50,1,1.00,'Factura A N°: 0100-00001675',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(203,8119,2,40776,40845,13,20318,1,0,'2022-12-29',2496572.20,1,1.00,'Factura A N°: 0100-00001676',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(204,8119,2,40776,40846,13,20318,1,0,'2022-12-29',258757.20,1,1.00,'Factura A N°: 0100-00001677',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(205,8119,2,40776,40847,13,20318,1,0,'2022-12-30',1567222.25,1,1.00,'Factura A N°: 0012-00008617',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(206,8119,2,40776,40848,13,20318,1,0,'2022-12-30',145411.75,1,1.00,'Factura A N°: 0012-00008618',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(207,8119,2,40776,40846,13,20318,1,0,'2022-12-30',258757.20,1,1.00,'Factura A N°: 0012-00008619',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(208,8119,2,40776,40845,13,20318,1,0,'2022-12-30',380268.00,1,1.00,'Factura A N°: 0012-00008620',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(209,8119,2,40776,40833,13,20318,1,0,'2022-12-30',184200.00,1,1.00,'Factura A N°: 0012-00008621',NULL,'2023-01-06 10:34:39','2023-01-06 11:16:44','2023-01-06 11:16:44'),(210,8119,2,40776,40820,13,20318,1,0,'2022-12-30',352698.10,1,1.00,'Factura A N°: 0012-00008622',NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(211,8119,2,40776,40843,13,20318,1,0,'2022-12-30',62639.20,1,1.00,'Factura A N°: 0012-00008623',NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(212,8119,2,40776,40849,13,20318,1,0,'2022-12-30',159048.45,1,1.00,'Factura A N°: 0012-00008624',NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(213,8119,2,40776,40803,13,20318,1,0,'2022-12-30',546117.00,1,1.00,'Factura A N°: 0012-00008625',NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(214,8119,2,40776,40837,13,20318,1,0,'2022-12-30',621205.00,1,1.00,'Factura A N°: 0100-00001678',NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(215,8119,2,40776,40788,13,20318,1,0,'2022-12-30',217421.75,1,1.00,'Factura A N°: 0100-00001679',NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44');
INSERT INTO `cta_cte_cliente` VALUES (216,8119,2,40776,40781,13,20318,1,0,'2022-12-30',223363.34,1,1.00,'Factura A N°: 0100-00001680',NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(217,8119,2,40776,40791,13,20318,2,0,'2022-12-30',217421.75,1,1.00,'Nota de crédito A N°: 0100-00000103',NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(218,8119,2,40776,40850,13,20318,1,0,'2022-12-30',3311315.33,1,1.00,'FACTURA DE CRÉDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0012-00000051',NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(219,8119,2,40776,40850,13,20318,2,0,'2022-12-30',900143.04,1,1.00,'NOTA DE CREDITO ELECTRÓNICA MiPyMEs (FCE) A N°: 0012-00000005',NULL,'2023-01-06 10:34:40','2023-01-06 11:16:44','2023-01-06 11:16:44'),(220,8119,2,40720,40746,13,1544,1,0,'2022-12-03',250542.60,1,1.00,'Factura A N°: 0003-00000283',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(221,8119,2,40720,40747,13,1544,1,0,'2022-12-03',103520.34,1,1.00,'Factura A N°: 0003-00000284',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(222,8119,2,40720,40857,13,1544,1,0,'2022-12-03',425842.56,1,1.00,'Factura A N°: 0003-00000285',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(223,8119,2,40720,40748,13,1544,1,0,'2022-12-06',560363.10,1,1.00,'Factura A N°: 0003-00000286',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(224,8119,2,40720,40747,13,1544,1,0,'2022-12-07',58341.36,1,1.00,'Factura A N°: 0003-00000287',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(225,8119,2,40720,40747,13,1544,1,0,'2022-12-07',141228.78,1,1.00,'Factura A N°: 0003-00000288',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(226,8119,2,40720,40748,13,1544,1,0,'2022-12-07',43439.00,1,1.00,'Factura A N°: 0003-00000289',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(227,8119,2,40720,40746,13,1544,1,0,'2022-12-09',306023.52,1,1.00,'Factura A N°: 0003-00000290',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(228,8119,2,40720,40857,13,1544,1,0,'2022-12-13',235634.19,1,1.00,'Factura A N°: 0003-00000291',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(229,8119,2,40720,40857,13,1544,1,0,'2022-12-13',304034.28,1,1.00,'Factura A N°: 0003-00000292',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(230,8119,2,40720,40857,13,1544,1,0,'2022-12-16',235634.19,1,1.00,'Factura A N°: 0003-00000293',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(231,8119,2,40720,40746,13,1544,1,0,'2022-12-16',329342.64,1,1.00,'Factura A N°: 0003-00000294',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(232,8119,2,40720,40747,13,1544,1,0,'2022-12-16',239768.76,1,1.00,'Factura A N°: 0003-00000295',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(233,8119,2,40720,40746,13,1544,1,0,'2022-12-22',252938.40,1,1.00,'Factura A N°: 0003-00000296',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(234,8119,2,40720,40746,13,1544,1,0,'2022-12-22',243500.40,1,1.00,'Factura A N°: 0003-00000297',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(235,8119,2,40720,40746,13,1544,1,0,'2022-12-27',328064.88,1,1.00,'Factura A N°: 0003-00000298',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(236,8119,2,40720,40749,13,1544,1,0,'2022-12-29',1226940.00,1,1.00,'Factura A N°: 0003-00000299',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(237,8119,2,40720,40750,13,1544,1,0,'2022-12-29',1600830.00,1,1.00,'Factura A N°: 0003-00000300',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(238,8119,2,40720,40750,13,1544,1,0,'2022-12-29',1591246.80,1,1.00,'Factura A N°: 0003-00000301',NULL,'2023-01-16 17:59:12','2023-01-16 17:59:12',NULL),(239,8119,2,40720,40857,13,1544,1,0,'2022-12-30',389600.64,1,1.00,'Factura A N°: 0003-00000304',NULL,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(240,8119,2,40720,40746,13,1544,1,0,'2022-12-30',238781.40,1,1.00,'Factura A N°: 0003-00000302',NULL,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL);
INSERT INTO `cta_cte_cliente` VALUES (241,8119,2,40720,40746,13,1544,1,0,'2022-12-30',242084.70,1,1.00,'Factura A N°: 0003-00000303',NULL,'2023-01-16 17:59:13','2023-01-16 17:59:13',NULL),(242,8119,3,40720,40751,57,1544,2,0,'2022-12-02',25368.55,1,1.00,'Factura A N°: 0003-00023184',NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(243,8119,3,40720,40858,57,1544,2,0,'2022-12-04',23577.92,1,1.00,'Factura B N°: 2219-04341193',NULL,'2023-01-16 18:01:46','2023-01-16 18:39:32','2023-01-16 18:39:32'),(244,8119,3,40720,40751,57,1544,2,0,'2022-12-05',58464.22,1,1.00,'Factura A N°: 0003-00023201',NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(245,8119,3,40720,40859,57,1544,2,0,'2022-12-06',18389.33,1,1.00,'Factura B N°: 0219-00009045',NULL,'2023-01-16 18:01:46','2023-01-16 18:37:14','2023-01-16 18:37:14'),(246,8119,3,40720,40751,57,1544,2,0,'2022-12-07',117734.94,1,1.00,'Factura A N°: 0003-00023231',NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(247,8119,3,40720,40751,57,1544,2,0,'2022-12-12',70303.84,1,1.00,'Factura A N°: 0003-00023250',NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(248,8119,3,40720,40860,57,1544,2,0,'2022-12-13',63707.50,1,1.00,'Factura B N°: 10339-00002267',NULL,'2023-01-16 18:01:46','2023-01-16 18:40:50','2023-01-16 18:40:50'),(249,8119,3,40720,40751,57,1544,2,0,'2022-12-14',49922.67,1,1.00,'Factura A N°: 0003-00023287',NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(250,8119,3,40720,40752,57,1544,2,0,'2022-12-15',1490.00,1,1.00,'Factura B N°: 1411-01976329',NULL,'2023-01-16 18:01:46','2023-01-16 18:35:24','2023-01-16 18:35:24'),(251,8119,3,40720,40751,57,1544,2,0,'2022-12-15',35630.59,1,1.00,'Factura A N°: 0003-00023292',NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(252,8119,3,40720,40858,57,1544,2,0,'2022-12-17',28079.32,1,1.00,'Factura B N°: 2219-04388808',NULL,'2023-01-16 18:01:46','2023-01-16 18:40:36','2023-01-16 18:40:36'),(253,8119,3,40720,40751,57,1544,2,0,'2022-12-19',15391.20,1,1.00,'Factura A N°: 0003-00023321',NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(254,8119,3,40720,40755,57,1544,2,0,'2022-12-20',38416.03,1,1.00,'Factura A N°: 0004-00002747',NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(255,8119,3,40720,40755,57,1544,2,0,'2022-12-20',33549.91,1,1.00,'Factura A N°: 0004-00002746',NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(256,8119,3,40720,40751,57,1544,2,0,'2022-12-22',45602.79,1,1.00,'Factura A N°: 0003-00023348',NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(257,8119,3,40720,40861,57,1544,2,0,'2022-12-23',15000.00,1,1.00,'Factura B N°: 0001-00008053',NULL,'2023-01-16 18:01:46','2023-01-16 18:40:04','2023-01-16 18:40:04'),(258,8119,3,40720,40861,57,1544,2,0,'2022-12-23',135000.00,1,1.00,'Factura B N°: 0001-00008006',NULL,'2023-01-16 18:01:46','2023-01-16 18:39:51','2023-01-16 18:39:51'),(259,8119,3,40720,40754,57,1544,2,0,'2022-12-27',40884.43,1,1.00,'Factura B N°: 1346-12383868',NULL,'2023-01-16 18:01:46','2023-01-16 18:39:11','2023-01-16 18:39:11'),(260,8119,3,40720,40751,57,1544,2,0,'2022-12-29',117540.46,1,1.00,'Factura A N°: 0003-00023428',NULL,'2023-01-16 18:01:46','2023-01-16 18:01:46',NULL),(261,8119,3,40720,40862,57,1544,2,0,'2022-12-15',360122.74,1,1.00,'Factura A N°: 0001-00417159',NULL,'2023-01-16 18:15:20','2023-01-16 18:15:20',NULL),(262,8119,3,40720,40862,57,1544,2,0,'2022-12-01',408955.80,1,1.00,'Factura A N°: 0002-00036771',NULL,'2023-01-16 18:15:56','2023-01-16 18:15:56',NULL),(263,8119,3,40720,40863,57,1544,2,0,'2022-12-21',259883.80,1,1.00,'Factura A N°: 0002-00038724',NULL,'2023-01-16 18:19:13','2023-01-16 18:19:13',NULL),(264,8119,3,40720,40863,57,1544,2,0,'2022-12-30',372487.61,1,1.00,'Factura A N°: 0002-00039630',NULL,'2023-01-16 18:19:58','2023-01-16 18:19:58',NULL),(265,8119,3,40720,40762,57,1544,2,0,'2022-12-07',270961.35,1,1.00,'Factura A N°: 0006-00030266',NULL,'2023-01-16 18:21:40','2023-01-16 18:21:40',NULL);
INSERT INTO `cta_cte_cliente` VALUES (266,8119,3,40720,40762,57,1544,2,0,'2022-12-12',424656.76,1,1.00,'Factura A N°: 0006-00030702',NULL,'2023-01-16 18:22:14','2023-01-16 18:22:14',NULL),(267,8119,3,40720,40864,57,1544,2,0,'2022-12-27',295387.62,1,1.00,'Factura A N°: 0004-00135392',NULL,'2023-01-16 18:23:51','2023-01-16 18:23:51',NULL),(268,8119,3,40720,40762,57,1544,2,0,'2022-12-27',406246.61,1,1.00,'Factura A N°: 0006-00031689',NULL,'2023-01-16 18:26:05','2023-01-16 18:26:05',NULL),(269,8119,3,40720,40765,57,1544,2,0,'2022-12-23',195415.00,1,1.00,'Factura A N°: 0005-00559597',NULL,'2023-01-16 18:28:16','2023-01-16 18:28:16',NULL),(270,8119,3,40720,40765,57,1544,2,0,'2022-12-13',340711.80,1,1.00,'Factura A N°: 0005-00558547',NULL,'2023-01-16 18:28:49','2023-01-16 18:28:49',NULL),(271,8119,3,40720,40765,57,1544,2,0,'2022-12-03',381585.60,1,1.00,'Factura A N°: 0005-00557727',NULL,'2023-01-16 18:29:15','2023-01-16 18:29:15',NULL),(272,8119,3,40720,40760,57,1544,2,0,'2022-12-16',417450.00,1,1.00,'Factura A N°: 0015-00604996',NULL,'2023-01-16 18:29:55','2023-01-16 18:29:55',NULL),(273,8119,3,40720,40864,57,1544,2,0,'2022-12-20',192428.72,1,1.00,'Factura A N°: 0004-00134659',NULL,'2023-01-16 18:30:37','2023-01-16 18:30:37',NULL),(274,8119,3,40720,40864,57,1544,2,0,'2022-12-02',284472.09,1,1.00,'Factura A N°: 0004-00132895',NULL,'2023-01-16 18:31:09','2023-01-16 18:31:09',NULL),(275,8119,3,40720,40864,57,1544,2,0,'2022-12-06',471234.50,1,1.00,'Factura A N°: 0004-00133238',NULL,'2023-01-16 18:31:44','2023-01-16 18:31:44',NULL),(276,8119,2,40741,40742,13,3351,1,0,'2022-12-01',33250.00,1,1.00,'Factura B N°: 0002-00000040',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(277,8119,2,40741,40742,13,3351,1,0,'2022-12-01',33500.00,1,1.00,'Factura B N°: 0002-00000041',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(278,8119,2,40741,40742,13,3351,1,0,'2022-12-01',162331.90,1,1.00,'Factura B N°: 0002-00000042',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(279,8119,2,40741,40742,13,3351,1,0,'2022-12-01',305759.90,1,1.00,'Factura B N°: 0002-00000043',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(280,8119,2,40741,40742,13,3351,1,0,'2022-12-05',22150.90,1,1.00,'Factura B N°: 0002-00000044',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(281,8119,2,40741,40742,13,3351,1,0,'2022-12-05',69106.50,1,1.00,'Factura B N°: 0002-00000045',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(282,8119,2,40741,40742,13,3351,1,0,'2022-12-09',419516.80,1,1.00,'Factura B N°: 0002-00000046',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(283,8119,2,40741,40742,13,3351,1,0,'2022-12-09',240505.50,1,1.00,'Factura B N°: 0002-00000047',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(284,8119,2,40741,40742,13,3351,1,0,'2022-12-12',55848.60,1,1.00,'Factura B N°: 0002-00000048',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(285,8119,2,40741,40742,13,3351,1,0,'2022-12-19',267611.00,1,1.00,'Factura B N°: 0002-00000049',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(286,8119,2,40741,40742,13,3351,1,0,'2022-12-19',50115.10,1,1.00,'Factura B N°: 0002-00000050',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(287,8119,2,40741,40742,13,3351,1,0,'2022-12-19',39835.90,1,1.00,'Factura B N°: 0002-00000051',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(288,8119,2,40741,40742,13,3351,1,0,'2022-12-26',127749.60,1,1.00,'Factura B N°: 0002-00000052',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(289,8119,2,40741,40742,13,3351,1,0,'2022-12-28',228283.70,1,1.00,'Factura B N°: 0002-00000053',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(290,8119,2,40741,40742,13,3351,1,0,'2022-12-28',45818.50,1,1.00,'Factura B N°: 0002-00000054',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL),(291,8119,2,40741,40742,13,3351,1,0,'2022-12-28',46193.10,1,1.00,'Factura B N°: 0002-00000055',NULL,'2023-01-16 20:22:08','2023-01-16 20:22:08',NULL);
INSERT INTO `cta_cte_cliente` VALUES (292,8119,2,40741,40742,13,3351,2,0,'2022-12-29',46193.10,1,1.00,'Nota de crédito B N°: 0002-00000001',NULL,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(293,8119,2,40741,40742,13,3351,1,0,'2022-12-30',56100.30,1,1.00,'Factura B N°: 0002-00000056',NULL,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(294,8119,2,40741,40742,13,3351,1,0,'2022-12-30',19599.30,1,1.00,'Factura B N°: 0002-00000057',NULL,'2023-01-16 20:22:09','2023-01-16 20:22:09',NULL),(295,8119,3,40741,40744,57,3351,2,0,'2022-12-01',29342.16,1,1.00,'Factura A N°: 0021-00000788',NULL,'2023-01-16 20:22:20','2023-01-16 20:22:20',NULL),(296,8119,3,40741,40744,57,3351,2,0,'2022-12-01',403739.39,1,1.00,'Factura A N°: 0021-00000789',NULL,'2023-01-16 20:22:20','2023-01-16 20:22:20',NULL),(297,8119,3,40741,40744,57,3351,2,0,'2022-12-01',613813.13,1,1.00,'Factura A N°: 0021-00000787',NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(298,8119,3,40741,40743,57,3351,2,0,'2022-12-01',43440.75,1,1.00,'Factura A N°: 0012-00030441',NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(299,8119,3,40741,40745,57,3351,2,0,'2022-12-01',12380.90,1,1.00,'Factura A N°: 0001-00031929',NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(300,8119,3,40741,40744,57,3351,2,0,'2022-12-06',133997.82,1,1.00,'Factura A N°: 0021-00000877',NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(301,8119,3,40741,40743,57,3351,2,0,'2022-12-06',60615.00,1,1.00,'Factura A N°: 0012-00030560',NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(302,8119,3,40741,40745,57,3351,2,0,'2022-12-06',175884.16,1,1.00,'Factura A N°: 0001-00032024',NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(303,8119,3,40741,40743,57,3351,2,0,'2022-12-15',30109.94,1,1.00,'Factura A N°: 0012-00030729',NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(304,8119,3,40741,40743,57,3351,2,0,'2022-12-15',117961.28,1,1.00,'Factura A N°: 0012-00030730',NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(305,8119,3,40741,40865,57,3351,2,0,'2022-12-17',200005.00,1,1.00,'Factura A N°: 0004-00000291',NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(306,8119,3,40741,40866,57,3351,2,0,'2022-12-19',498604.40,1,1.00,'Factura A N°: 0014-00020051',NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(307,8119,3,40741,40866,57,3351,2,0,'2022-12-20',560576.50,1,1.00,'Factura A N°: 0014-00020064',NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(308,8119,3,40741,40744,57,3351,2,0,'2022-12-27',477155.58,1,1.00,'Factura A N°: 0022-00000872',NULL,'2023-01-16 20:22:21','2023-01-16 20:22:21',NULL),(309,8119,2,40856,40867,13,29414,1,0,'2022-12-01',1000.00,1,1.00,'Factura B N°: 0001-00000001',NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(310,8119,2,40856,40868,13,29414,1,0,'2022-12-05',157946.00,1,1.00,'Factura B N°: 0001-00000002',NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(311,8119,2,40856,40867,13,29414,1,0,'2022-12-05',12300.00,1,1.00,'Factura B N°: 0001-00000003',NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(312,8119,2,40856,40869,13,29414,1,0,'2022-12-08',64260.00,1,1.00,'Factura B N°: 0001-00000004',NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(313,8119,2,40856,40867,13,29414,1,0,'2022-12-09',15028.00,1,1.00,'Factura B N°: 0001-00000005',NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(314,8119,2,40856,40867,13,29414,1,0,'2022-12-09',19750.00,1,1.00,'Factura B N°: 0001-00000006',NULL,'2023-01-16 20:40:08','2023-01-16 20:40:08',NULL),(315,8119,2,40856,40867,13,29414,1,0,'2022-12-09',17380.00,1,1.00,'Factura B N°: 0001-00000007',NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(316,8119,2,40856,40869,13,29414,1,0,'2022-12-11',44100.00,1,1.00,'Factura B N°: 0001-00000008',NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(317,8119,2,40856,40870,13,29414,1,0,'2022-12-17',131104.00,1,1.00,'Factura B N°: 0001-00000009',NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL);
INSERT INTO `cta_cte_cliente` VALUES (318,8119,2,40856,40867,13,29414,1,0,'2022-12-26',19400.00,1,1.00,'Factura B N°: 0001-00000010',NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(319,8119,2,40856,40871,13,29414,1,0,'2022-12-29',33600.00,1,1.00,'Factura B N°: 0001-00000011',NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(320,8119,2,40856,40867,13,29414,1,0,'2022-12-29',19635.00,1,1.00,'Factura B N°: 0001-00000012',NULL,'2023-01-16 20:40:09','2023-01-16 20:40:09',NULL),(321,8119,3,40856,40872,57,29414,2,0,'2022-12-01',10680.20,1,1.00,'Factura B N°: 0050-04979845',NULL,'2023-01-16 20:40:16','2023-01-16 20:42:02','2023-01-16 20:42:02'),(322,8119,3,40856,40872,57,29414,1,0,'2022-12-01',8289.80,1,1.00,'Nota de crédito B N°: 0049-04635334',NULL,'2023-01-16 20:40:16','2023-01-16 20:42:08','2023-01-16 20:42:08'),(323,8119,3,40856,40873,57,29414,2,0,'2022-12-03',5654.18,1,1.00,'Factura B N°: 0943-11303286',NULL,'2023-01-16 20:40:16','2023-01-16 20:42:14','2023-01-16 20:42:14'),(324,8119,3,40856,40874,57,29414,2,0,'2022-12-08',20000.00,1,1.00,'RECIBO C N°: 0001-00000148',NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(325,8119,3,40856,40875,57,29414,2,0,'2022-12-10',6158.20,1,1.00,'Factura B N°: 0036-20140649',NULL,'2023-01-16 20:40:16','2023-01-16 20:41:40','2023-01-16 20:41:40'),(326,8119,3,40856,40875,57,29414,2,0,'2022-12-10',5633.11,1,1.00,'Factura B N°: 0025-08016865',NULL,'2023-01-16 20:40:16','2023-01-16 20:41:47','2023-01-16 20:41:47'),(327,8119,3,40856,40876,57,29414,2,0,'2022-12-14',5980.00,1,1.00,'Factura C N°: 0010-00001516',NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(328,8119,3,40856,40877,57,29414,1,0,'2022-12-14',7454.16,1,1.00,'Nota de crédito B N°: 0007-00001301',NULL,'2023-01-16 20:40:16','2023-01-16 20:41:32','2023-01-16 20:41:32'),(329,8119,3,40856,40878,57,29414,2,0,'2022-12-21',17630.97,1,1.00,'Factura B N°: 0185-00029126',NULL,'2023-01-16 20:40:16','2023-01-16 20:41:23','2023-01-16 20:41:23'),(330,8119,3,40856,40879,57,29414,2,0,'2022-12-21',718.74,1,1.00,'Factura A N°: 0005-00075585',NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(331,8119,3,40856,40880,57,29414,2,0,'2022-12-23',9899.00,1,1.00,'Factura B N°: 0090-00010655',NULL,'2023-01-16 20:40:16','2023-01-16 20:41:16','2023-01-16 20:41:16'),(332,8119,3,40856,40881,57,29414,2,0,'2022-12-23',12257.00,1,1.00,'Factura B N°: 0002-00022500',NULL,'2023-01-16 20:40:16','2023-01-16 20:41:07','2023-01-16 20:41:07'),(333,8119,3,40856,40882,57,29414,2,0,'2022-12-26',9771.36,1,1.00,'RECIBO C N°: 0002-00025552',NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(334,8119,3,40856,40883,57,29414,2,0,'2022-12-28',85000.00,1,1.00,'Factura A N°: 0001-00000001',NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(335,8119,3,40856,40883,57,29414,2,0,'2022-12-28',80000.00,1,1.00,'Factura A N°: 0001-00000002',NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(336,8119,3,40856,40883,57,29414,2,0,'2022-12-29',85000.00,1,1.00,'Factura A N°: 0001-00000003',NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(337,8119,3,40856,40883,57,29414,2,0,'2022-12-29',80000.00,1,1.00,'Factura A N°: 0001-00000004',NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(338,8119,3,40856,40883,57,29414,2,0,'2022-12-30',85000.00,1,1.00,'Factura A N°: 0001-00000005',NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(339,8119,3,40856,40883,57,29414,2,0,'2022-12-30',85000.00,1,1.00,'Factura A N°: 0001-00000006',NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(340,8119,3,40856,40884,57,29414,2,0,'2022-12-31',20500.00,1,1.00,'Factura C N°: 0002-00000121',NULL,'2023-01-16 20:40:16','2023-01-16 20:40:16',NULL),(341,8119,3,40856,40885,57,29414,2,0,'2022-12-31',19720.59,1,1.00,'Factura B N°: 0005-03473521',NULL,'2023-01-16 20:40:16','2023-01-16 20:40:58','2023-01-16 20:40:58'),(342,8119,3,40856,40879,57,29414,2,0,'2022-12-31',22387.90,1,1.00,'Factura A N°: 0005-00076059',NULL,'2023-01-16 20:40:17','2023-01-16 20:40:17',NULL);
INSERT INTO `cta_cte_cliente` VALUES (343,8119,2,40774,40886,13,31118,1,0,'2022-12-04',1899.00,1,1.00,'Factura B N°: 0004-00001128',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(344,8119,2,40774,40887,13,31118,1,0,'2022-12-04',549.00,1,1.00,'Factura B N°: 0003-00009044',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(345,8119,2,40774,40888,13,31118,1,0,'2022-12-04',6245.00,1,1.00,'Factura B N°: 0003-00009045',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(346,8119,2,40774,40889,13,31118,1,0,'2022-12-04',2999.00,1,1.00,'Factura B N°: 0003-00009046',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(347,8119,2,40774,40890,13,31118,1,0,'2022-12-04',699.00,1,1.00,'Factura B N°: 0003-00009047',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(348,8119,2,40774,40891,13,31118,1,0,'2022-12-04',499.00,1,1.00,'Factura B N°: 0003-00009048',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(349,8119,2,40774,40892,13,31118,1,0,'2022-12-04',1049.00,1,1.00,'Factura B N°: 0003-00009049',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(350,8119,2,40774,40893,13,31118,1,0,'2022-12-04',2000.00,1,1.00,'Factura B N°: 0003-00009050',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(351,8119,2,40774,40894,13,31118,1,0,'2022-12-04',749.00,1,1.00,'Factura B N°: 0003-00009051',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(352,8119,2,40774,40895,13,31118,1,0,'2022-12-04',300.00,1,1.00,'Factura B N°: 0003-00009052',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(353,8119,2,40774,40896,13,31118,1,0,'2022-12-04',798.00,1,1.00,'Factura B N°: 0003-00009053',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(354,8119,2,40774,40897,13,31118,1,0,'2022-12-04',300.00,1,1.00,'Factura B N°: 0003-00009054',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(355,8119,2,40774,40898,13,31118,1,0,'2022-12-04',2259.00,1,1.00,'Factura B N°: 0003-00009055',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(356,8119,2,40774,40899,13,31118,1,0,'2022-12-04',1499.00,1,1.00,'Factura B N°: 0003-00009056',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(357,8119,2,40774,40900,13,31118,1,0,'2022-12-04',8686.00,1,1.00,'Factura B N°: 0003-00009057',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(358,8119,2,40774,40901,13,31118,1,0,'2022-12-04',4375.00,1,1.00,'Factura B N°: 0003-00009058',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(359,8119,2,40774,40902,13,31118,1,0,'2022-12-04',3200.00,1,1.00,'Factura B N°: 0003-00009059',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(360,8119,2,40774,40902,13,31118,1,0,'2022-12-04',300.00,1,1.00,'Factura B N°: 0003-00009060',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(361,8119,2,40774,40903,13,31118,1,0,'2022-12-04',1879.00,1,1.00,'Factura B N°: 0003-00009061',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(362,8119,2,40774,40904,13,31118,1,0,'2022-12-04',4792.00,1,1.00,'Factura B N°: 0003-00009062',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(363,8119,2,40774,40905,13,31118,1,0,'2022-12-04',599.00,1,1.00,'Factura B N°: 0003-00009063',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(364,8119,2,40774,40906,13,31118,1,0,'2022-12-04',3054.00,1,1.00,'Factura B N°: 0003-00009064',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(365,8119,2,40774,40907,13,31118,1,0,'2022-12-04',1749.00,1,1.00,'Factura B N°: 0003-00009065',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(366,8119,2,40774,40908,13,31118,1,0,'2022-12-04',4244.00,1,1.00,'Factura B N°: 0003-00009066',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(367,8119,2,40774,40909,13,31118,1,0,'2022-12-04',1499.00,1,1.00,'Factura B N°: 0003-00009067',NULL,'2023-01-19 10:48:25','2023-01-19 10:48:25',NULL),(368,8119,2,40774,40910,13,31118,1,0,'2022-12-04',1450.00,1,1.00,'Factura B N°: 0003-00009068',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL);
INSERT INTO `cta_cte_cliente` VALUES (369,8119,2,40774,40911,13,31118,1,0,'2022-12-04',1499.00,1,1.00,'Factura B N°: 0003-00009069',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(370,8119,2,40774,40912,13,31118,1,0,'2022-12-04',1999.00,1,1.00,'Factura B N°: 0003-00009070',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(371,8119,2,40774,40913,13,31118,1,0,'2022-12-04',6472.00,1,1.00,'Factura B N°: 0003-00009071',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(372,8119,2,40774,40914,13,31118,1,0,'2022-12-04',300.00,1,1.00,'Factura B N°: 0003-00009072',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(373,8119,2,40774,40915,13,31118,1,0,'2022-12-04',2742.00,1,1.00,'Factura B N°: 0003-00009073',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(374,8119,2,40774,40916,13,31118,1,0,'2022-12-04',1880.00,1,1.00,'Factura B N°: 0003-00009074',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(375,8119,2,40774,40917,13,31118,1,0,'2022-12-05',1649.00,1,1.00,'Factura B N°: 0003-00009075',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(376,8119,2,40774,40918,13,31118,1,0,'2022-12-05',3192.00,1,1.00,'Factura B N°: 0003-00009076',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(377,8119,2,40774,40919,13,31118,1,0,'2022-12-05',1049.00,1,1.00,'Factura B N°: 0003-00009077',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(378,8119,2,40774,40920,13,31118,1,0,'2022-12-05',1648.00,1,1.00,'Factura B N°: 0003-00009078',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(379,8119,2,40774,40921,13,31118,1,0,'2022-12-05',1127.00,1,1.00,'Factura B N°: 0003-00009079',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(380,8119,2,40774,40922,13,31118,1,0,'2022-12-05',1693.00,1,1.00,'Factura B N°: 0003-00009080',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(381,8119,2,40774,40923,13,31118,1,0,'2022-12-05',1098.00,1,1.00,'Factura B N°: 0003-00009081',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(382,8119,2,40774,40924,13,31118,1,0,'2022-12-05',19000.00,1,1.00,'Factura B N°: 0003-00009082',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(383,8119,2,40774,40925,13,31118,1,0,'2022-12-05',13499.00,1,1.00,'Factura B N°: 0003-00009083',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(384,8119,2,40774,40926,13,31118,1,0,'2022-12-05',2910.00,1,1.00,'Factura B N°: 0003-00009084',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(385,8119,2,40774,40927,13,31118,1,0,'2022-12-05',2050.00,1,1.00,'Factura B N°: 0003-00009085',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(386,8119,2,40774,40928,13,31118,1,0,'2022-12-05',2525.00,1,1.00,'Factura B N°: 0003-00009086',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(387,8119,2,40774,40929,13,31118,1,0,'2022-12-05',300.00,1,1.00,'Factura B N°: 0003-00009087',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(388,8119,2,40774,40930,13,31118,1,0,'2022-12-05',1199.00,1,1.00,'Factura B N°: 0003-00009088',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(389,8119,2,40774,40931,13,31118,1,0,'2022-12-05',20986.00,1,1.00,'Factura B N°: 0003-00009089',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(390,8119,2,40774,40932,13,31118,1,0,'2022-12-05',1199.00,1,1.00,'Factura B N°: 0003-00009090',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(391,8119,2,40774,40933,13,31118,1,0,'2022-12-05',1849.00,1,1.00,'Factura B N°: 0003-00009091',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(392,8119,2,40774,40934,13,31118,1,0,'2022-12-05',8468.00,1,1.00,'Factura B N°: 0003-00009092',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(393,8119,2,40774,40935,13,31118,1,0,'2022-12-05',2249.00,1,1.00,'Factura B N°: 0003-00009093',NULL,'2023-01-19 10:48:26','2023-01-19 10:48:26',NULL),(394,8119,2,40774,40936,13,31118,1,0,'2022-12-05',1799.00,1,1.00,'Factura B N°: 0003-00009094',NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL);
INSERT INTO `cta_cte_cliente` VALUES (395,8119,2,40774,40937,13,31118,1,0,'2022-12-05',8750.00,1,1.00,'Factura B N°: 0003-00009095',NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(396,8119,2,40774,40938,13,31118,1,0,'2022-12-05',1499.00,1,1.00,'Factura B N°: 0003-00009096',NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(397,8119,2,40774,40939,13,31118,1,0,'2022-12-05',3650.00,1,1.00,'Factura B N°: 0003-00009097',NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(398,8119,2,40774,40940,13,31118,1,0,'2022-12-05',1260.00,1,1.00,'Factura B N°: 0003-00009098',NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(399,8119,2,40774,40941,13,31118,1,0,'2022-12-05',6300.00,1,1.00,'Factura B N°: 0003-00009099',NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(400,8119,2,40774,40942,13,31118,1,0,'2022-12-05',1094.00,1,1.00,'Factura B N°: 0003-00009100',NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(401,8119,2,40774,40943,13,31118,1,0,'2022-12-05',3580.00,1,1.00,'Factura B N°: 0003-00009101',NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(402,8119,2,40774,40944,13,31118,1,0,'2022-12-05',300.00,1,1.00,'Factura B N°: 0003-00009102',NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(403,8119,2,40774,40945,13,31118,1,0,'2022-12-05',1999.00,1,1.00,'Factura B N°: 0003-00009103',NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(404,8119,2,40774,40946,13,31118,1,0,'2022-12-05',5797.00,1,1.00,'Factura B N°: 0003-00009104',NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(405,8119,2,40774,40947,13,31118,1,0,'2022-12-05',1499.00,1,1.00,'Factura B N°: 0003-00009105',NULL,'2023-01-19 10:48:27','2023-01-19 10:48:27',NULL),(406,8119,2,40774,40948,13,31118