-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db24-27349664-1
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2022-10-25 13:45:23','Actividad Generica 1','000001',NULL),(2,NULL,'2022-10-25 13:45:23','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL),('2022-4','2022-04',2022,4,'2022-04-01','2022-04-30',716.9399,NULL,NULL,NULL),('2022-5','2022-05',2022,5,'2022-05-01','2022-05-31',753.1470,NULL,NULL,NULL),('2022-6','2022-06',2022,6,'2022-06-01','2022-06-30',793.0278,NULL,NULL,NULL),('2022-7','2022-07',2022,7,'2022-07-01','2022-07-31',851.7610,NULL,NULL,NULL),('2022-8','2022-08',2022,8,'2022-08-01','2022-08-31',911.1316,NULL,NULL,NULL),('2022-9','2022-09',2022,9,'2022-09-01','2022-09-30',967.3076,NULL,NULL,NULL),('2022-10','2022-10',2022,10,'2022-10-01','2022-10-31',1028.7060,NULL,NULL,NULL),('2022-11','2022-11',2022,11,'2022-11-01','2022-11-30',1079.2787,NULL,NULL,NULL),('2022-12','2022-12',2022,12,'2022-12-01','2022-12-31',1134.5875,NULL,NULL,NULL),('2023-1','2023-01',2023,1,'2023-01-01','2023-01-31',1202.9790,NULL,NULL,NULL),('2023-2','2023-02',2023,2,'2023-02-01','2023-02-28',1282.7091,NULL,NULL,NULL),('2023-3','2023-03',2023,3,'2023-03-01','2023-03-31',1381.1601,NULL,NULL,NULL),('2023-4','2023-04',2023,4,'2023-04-01','2023-04-30',1497.2147,NULL,NULL,NULL),('2023-5','2023-05',2023,5,'2023-05-01','2023-05-31',1613.5895,NULL,NULL,NULL),('2023-6','2023-06',2023,6,'2023-06-01','2023-06-30',1709.6115,NULL,NULL,NULL),('2023-7','2023-07',2023,7,'2023-07-01','2023-07-31',1818.0838,NULL,NULL,NULL),('2023-8','2023-08',2023,8,'2023-08-01','2023-08-31',2044.2832,NULL,NULL,NULL),('2023-9','2023-09',2023,9,'2023-09-01','2023-09-30',2304.9242,NULL,NULL,NULL),('2023-10','2023-10',2023,10,'2023-10-01','2023-10-31',2496.2730,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `api_recibidas`
--

DROP TABLE IF EXISTS `api_recibidas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `api_recibidas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `descripcion` json NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `api_recibidas_person_id_foreign` (`person_id`),
  CONSTRAINT `api_recibidas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `api_recibidas`
--

LOCK TABLES `api_recibidas` WRITE;
/*!40000 ALTER TABLE `api_recibidas` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_recibidas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=179 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
INSERT INTO `back_up_claves_details` VALUES (1,NULL,'AGUE2030',NULL,44,40721,'2022-11-15'),(2,NULL,'AGUE2030',NULL,44,40721,'2022-11-15'),(3,NULL,'Aguero2020',NULL,1,40721,'2022-11-15'),(4,NULL,'AGUE2030',NULL,44,40721,'2022-11-18'),(5,NULL,'Aguero2020',NULL,1,40721,'2022-11-18'),(6,NULL,'AGUERO2020',NULL,45,40721,'2022-11-18'),(7,NULL,'leoncito06',NULL,1,40720,'2022-11-18'),(8,NULL,'DIJBJHC',NULL,45,40720,'2022-11-18'),(9,NULL,'leoncito06',NULL,1,40720,'2022-11-18'),(10,NULL,'DIJBJHC',NULL,45,40720,'2022-11-18'),(11,NULL,'leoncito06',NULL,1,40720,'2022-11-18'),(12,NULL,'DIJBJHC',NULL,45,40720,'2022-11-18'),(13,NULL,'leoncito06',NULL,1,40720,'2022-11-18'),(14,NULL,'DIJBJHC',NULL,45,40720,'2022-11-18'),(15,NULL,'LEoncito06',NULL,1,40720,'2022-11-18'),(16,NULL,'DIJBJHC',NULL,45,40720,'2022-11-18'),(17,NULL,'LEoncito06',NULL,1,40720,'2022-11-18'),(18,NULL,'DIJBJHC',NULL,45,40720,'2022-11-18'),(19,NULL,'LEoncito06',NULL,1,40720,'2022-11-18'),(20,NULL,'DIJBJHC',NULL,45,40720,'2022-11-18'),(21,NULL,'LEoncito06',NULL,1,40720,'2022-11-18'),(22,NULL,'DIJBJHC',NULL,45,40720,'2022-11-18'),(23,NULL,'LEoncito06',NULL,1,40720,'2022-11-18'),(24,NULL,'DIJBJHC',NULL,45,40720,'2022-11-18'),(25,NULL,'LEoncito06',NULL,1,40757,'2022-11-22'),(26,NULL,'LEoncito06',NULL,1,40757,'2022-11-22'),(27,NULL,'AGUE2030',NULL,44,40721,'2022-11-22'),(28,NULL,'Aguero2020',NULL,1,40721,'2022-11-22'),(29,NULL,'AGUERO2020',NULL,45,40721,'2022-11-22'),(30,NULL,'AGUE2030',NULL,44,40721,'2022-11-22'),(31,NULL,'Aguero2020',NULL,1,40721,'2022-11-22'),(32,NULL,'AGUERO2020',NULL,45,40721,'2022-11-22'),(33,NULL,'aguero39 (aguero239)',NULL,46,40721,'2022-11-22'),(34,NULL,'LEoncito06',NULL,1,40757,'2022-11-22'),(35,NULL,'Leoncito07',NULL,45,40757,'2022-11-22'),(36,NULL,'LEONCITO06',NULL,45,40758,'2022-11-23'),(37,NULL,'leoncito06',NULL,45,40759,'2022-11-23'),(38,NULL,'leoncito06',NULL,45,40759,'2022-11-23'),(39,NULL,'LEoncito06',NULL,1,40759,'2022-11-23'),(40,NULL,'EEDFIGH',NULL,45,40719,'2022-12-12'),(41,NULL,'LEoncito06',NULL,1,40719,'2022-12-12'),(42,NULL,'EEDFIGH',NULL,45,40719,'2022-12-12'),(43,NULL,'LEoncito06',NULL,1,40719,'2022-12-12'),(44,NULL,'LEoncito06',NULL,1,40757,'2022-12-12'),(45,NULL,'Leoncito07',NULL,45,40757,'2022-12-12'),(46,NULL,'aguero2020',NULL,48,40757,'2022-12-12'),(47,NULL,'JUanacos2021','Hijo',1,40774,'2022-12-12'),(48,NULL,'2021Mendoza',NULL,45,40774,'2022-12-12'),(49,NULL,'30deAbril0150',NULL,1,40772,'2022-12-12'),(50,NULL,'JUanacos2021','Hijo',1,40774,'2022-12-12'),(51,NULL,'2021Mendoza',NULL,45,40774,'2022-12-12'),(52,NULL,'474',NULL,49,40774,'2022-12-12'),(53,NULL,'30deAbril0150',NULL,1,40771,'2022-12-12'),(54,NULL,'30deAbril0150',NULL,1,40772,'2022-12-12'),(55,NULL,'30deAbril0150',NULL,1,40772,'2022-12-12'),(56,NULL,'esperanza2022',NULL,45,40772,'2022-12-12'),(57,'USUSARIO: MUSONYES2021','esperanza2021',NULL,46,40772,'2022-12-12'),(58,NULL,'Horacio2011',NULL,1,40773,'2022-12-12'),(59,NULL,'JDBDDIE',NULL,45,40773,'2022-12-12'),(60,'USUARIO: Noviembre6','Leoncito 06',NULL,46,40773,'2022-12-12'),(61,NULL,'2150001192921',NULL,50,40773,'2022-12-12'),(62,NULL,'Horacio2011',NULL,1,40773,'2022-12-12'),(63,NULL,'JDBDDIE',NULL,45,40773,'2022-12-12'),(64,'USUARIO: Noviembre6','Leoncito 06',NULL,46,40773,'2022-12-12'),(65,NULL,'2150001192921',NULL,50,40773,'2022-12-12'),(66,NULL,'Leoncito06',NULL,51,40773,'2022-12-12'),(67,NULL,'Horacio2011',NULL,1,40773,'2022-12-13'),(68,NULL,'JDBDDIE',NULL,45,40773,'2022-12-13'),(69,'USUARIO: Noviembre6','Leoncito 06',NULL,46,40773,'2022-12-13'),(70,NULL,'2150001192921',NULL,50,40773,'2022-12-13'),(71,NULL,'Leoncito06',NULL,51,40773,'2022-12-13'),(72,NULL,'leoncito06',NULL,45,40759,'2022-12-13'),(73,NULL,'LEoncito06',NULL,1,40759,'2022-12-13'),(74,NULL,'leoncito06',NULL,45,40759,'2022-12-13'),(75,NULL,'LEoncito06',NULL,1,40759,'2022-12-13'),(76,NULL,'Gonzaver04',NULL,1,40776,'2022-12-16'),(77,NULL,'gonzaVer04',NULL,45,40776,'2022-12-16'),(78,NULL,'AGUE2030',NULL,44,40721,'2022-12-16');
INSERT INTO `back_up_claves_details` VALUES (79,NULL,'Aguero2020',NULL,1,40721,'2022-12-16'),(80,NULL,'AGUERO2020',NULL,45,40721,'2022-12-16'),(81,NULL,'aguero39 (aguero239)',NULL,46,40721,'2022-12-16'),(82,NULL,'ague2030',NULL,47,40721,'2022-12-16'),(83,NULL,'Gonzaver04',NULL,1,40776,'2022-12-16'),(84,NULL,'gonzaVer04',NULL,45,40776,'2022-12-16'),(85,'USUARIO: marianasilvestrini@gmail.com','714AI746',NULL,46,40776,'2022-12-16'),(86,NULL,'5458',NULL,49,40776,'2022-12-16'),(87,'FEDERACION PATRONAL','Gonzaver07',NULL,41,40776,'2022-12-16'),(88,'PEÑAFLOR','Gonzaver05',NULL,41,40776,'2022-12-16'),(89,'RUT','Gonzaver05',NULL,41,40776,'2022-12-16'),(90,NULL,'leoncito06',NULL,45,40759,'2022-12-23'),(91,NULL,'LEoncito06',NULL,1,40759,'2022-12-23'),(92,NULL,'LEoncito06',NULL,1,40720,'2022-12-23'),(93,NULL,'DIJBJHC',NULL,45,40720,'2022-12-23'),(94,NULL,'Gonzaver04',NULL,1,40776,'2022-12-23'),(95,NULL,'gonzaVer04',NULL,45,40776,'2022-12-23'),(96,'USUARIO: marianasilvestrini@gmail.com','714AI746',NULL,46,40776,'2022-12-23'),(97,NULL,'5458',NULL,49,40776,'2022-12-23'),(98,'FEDERACION PATRONAL','Gonzaver07',NULL,41,40776,'2022-12-23'),(99,'PEÑAFLOR','Gonzaver05',NULL,41,40776,'2022-12-23'),(100,'RUT','Gonzaver05',NULL,41,40776,'2022-12-23'),(101,NULL,'AGUE2030',NULL,44,40721,'2022-12-23'),(102,NULL,'Aguero2020',NULL,1,40721,'2022-12-23'),(103,NULL,'AGUERO2020',NULL,45,40721,'2022-12-23'),(104,NULL,'aguero39 (aguero239)',NULL,46,40721,'2022-12-23'),(105,NULL,'ague2030',NULL,47,40721,'2022-12-23'),(106,NULL,'AGUE2030',NULL,44,40721,'2022-12-23'),(107,NULL,'Aguero2020',NULL,1,40721,'2022-12-23'),(108,NULL,'AGUERO2020',NULL,45,40721,'2022-12-23'),(109,NULL,'aguero39 (aguero239)',NULL,46,40721,'2022-12-23'),(110,NULL,'ague2030',NULL,47,40721,'2022-12-23'),(111,NULL,'AGUE2030',NULL,44,40721,'2022-12-23'),(112,NULL,'Aguero2020',NULL,1,40721,'2022-12-23'),(113,NULL,'AGUERO2020',NULL,45,40721,'2022-12-23'),(114,NULL,'aguero39 (aguero239)',NULL,46,40721,'2022-12-23'),(115,NULL,'ague2030',NULL,47,40721,'2022-12-23'),(116,NULL,'30deAbril0150','ANABELLA',1,40772,'2023-02-28'),(117,NULL,'esperanza2022',NULL,45,40772,'2023-02-28'),(118,'USUSARIO: MUSONYES2021','esperanza2021',NULL,46,40772,'2023-02-28'),(119,NULL,'musonyes07',NULL,50,40772,'2023-02-28'),(120,NULL,'leoncito06',NULL,43,40772,'2023-02-28'),(121,NULL,'30deAbril0150','ANABELLA',1,40772,'2023-03-21'),(122,NULL,'esperanza2022',NULL,45,40772,'2023-03-21'),(123,'USUSARIO: MUSONYES2021','esperanza2021',NULL,46,40772,'2023-03-21'),(124,NULL,'musonyes07',NULL,50,40772,'2023-03-21'),(125,NULL,'leoncito06',NULL,43,40772,'2023-03-21'),(126,NULL,'JUanacos2021','Hijo',1,40774,'2023-04-13'),(127,NULL,'2021Mendoza',NULL,45,40774,'2023-04-13'),(128,NULL,'474',NULL,49,40774,'2023-04-13'),(129,NULL,'JUanacos2021','Hijo',1,40774,'2023-05-30'),(130,NULL,'2023Mendoza',NULL,45,40774,'2023-05-30'),(131,NULL,'474',NULL,49,40774,'2023-05-30'),(132,NULL,'Gonzaver04',NULL,1,40776,'2023-06-07'),(133,NULL,'gonzaVer04',NULL,45,40776,'2023-06-07'),(134,'USUARIO: marianasilvestrini@gmail.com','714AI746',NULL,46,40776,'2023-06-07'),(135,NULL,'5458',NULL,49,40776,'2023-06-07'),(136,'FEDERACION PATRONAL','Gonzaver07',NULL,41,40776,'2023-06-07'),(137,'PEÑAFLOR','Gonzaver05',NULL,41,40776,'2023-06-07'),(138,'RUT','Gonzaver05',NULL,41,40776,'2023-06-07'),(139,NULL,'Gonzaver04',NULL,1,40776,'2023-06-16'),(140,NULL,'gonzaVer04',NULL,45,40776,'2023-06-16'),(141,'USUARIO: marianasilvestrini@gmail.com','714AI746',NULL,46,40776,'2023-06-16'),(142,NULL,'5458',NULL,49,40776,'2023-06-16'),(143,'FEDERACION PATRONAL','Gonzaver07',NULL,41,40776,'2023-06-16'),(144,'PEÑAFLOR','Gonzaver05',NULL,41,40776,'2023-06-16'),(145,'RUT','Gonzaver05',NULL,41,40776,'2023-06-16'),(146,NULL,'Gonzaver04',NULL,1,40776,'2023-06-16'),(147,NULL,'gonzaVer04',NULL,45,40776,'2023-06-16'),(148,'USUARIO: marianasilvestrini@gmail.com','714AI746',NULL,46,40776,'2023-06-16'),(149,NULL,'5458',NULL,49,40776,'2023-06-16');
INSERT INTO `back_up_claves_details` VALUES (150,'FEDERACION PATRONAL','Gonzaver07',NULL,41,40776,'2023-06-16'),(151,'PEÑAFLOR','Gonzaver04',NULL,41,40776,'2023-06-16'),(152,'RUT','Gonzaver05',NULL,41,40776,'2023-06-16'),(153,NULL,'mendoza2021',NULL,45,40969,'2023-06-16'),(154,NULL,'Raulso2023',NULL,1,40969,'2023-06-16'),(155,NULL,'leoncito06',NULL,45,40759,'2023-06-23'),(156,NULL,'LEoncito06',NULL,1,40759,'2023-06-23'),(157,NULL,'LEONCITO06',NULL,45,40758,'2023-06-23'),(158,NULL,'LEoncito06',NULL,1,40758,'2023-06-23'),(159,NULL,'LEoncito06',NULL,1,40757,'2023-06-23'),(160,NULL,'Leoncito07',NULL,45,40757,'2023-06-23'),(161,NULL,'LEoncito06',NULL,1,40720,'2023-06-23'),(162,NULL,'DIJBJHC',NULL,45,40720,'2023-06-23'),(163,NULL,'LEoncito06',NULL,1,40757,'2023-06-23'),(164,NULL,'Leoncito06',NULL,45,40757,'2023-06-23'),(165,NULL,'AGUE2030',NULL,44,40721,'2023-06-23'),(166,NULL,'Aguero2020',NULL,1,40721,'2023-06-23'),(167,NULL,'AGUERO2020',NULL,45,40721,'2023-06-23'),(168,NULL,'aguero39 (aguero239)',NULL,46,40721,'2023-06-23'),(169,NULL,'ague2030',NULL,47,40721,'2023-06-23'),(170,NULL,'Leoncito06',NULL,1,40720,'2023-07-04'),(171,NULL,'DIJBJHC',NULL,45,40720,'2023-07-04'),(172,NULL,'Gonzaver04',NULL,1,40776,'2023-08-24'),(173,NULL,'gonzaVer04',NULL,45,40776,'2023-08-24'),(174,'USUARIO: marianasilvestrini@gmail.com','714AI746',NULL,46,40776,'2023-08-24'),(175,NULL,'5458',NULL,49,40776,'2023-08-24'),(176,'FEDERACION PATRONAL','Gonzaver07',NULL,41,40776,'2023-08-24'),(177,'PEÑAFLOR','Gonzaver04',NULL,41,40776,'2023-08-24'),(178,'RUT','Gonzaver05',NULL,41,40776,'2023-08-24');
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
INSERT INTO `back_up_mails_details` VALUES (1,'centrocomercialseguros@gmail.com','2634687685','',1,40721,'2022-11-15'),(2,'centrocomercialseguros@gmail.com','2634687685','',1,40721,'2022-11-15'),(3,'centrocomercialseguros@gmail.com','2634687685','',1,40721,'2022-11-18'),(4,'anselmosilvestrini@gmail.com','2634614351','',1,40720,'2022-11-18'),(5,'centrocomercialseguros@gmail.com','2634687685','',1,40721,'2022-11-22'),(6,'centrocomercialseguros@gmail.com','2634687685','',1,40721,'2022-11-22'),(7,'marianasilvestrini@gmail.com','2634614350',NULL,1,40719,'2022-11-29'),(8,'marianasilvestrini@gmail.com','2634614350','',1,40719,'2022-12-12'),(9,'marianasilvestrini@gmail.com','2634614350','',1,40719,'2022-12-12'),(10,'carlossozzi@gmail.com','2634628000','Hijo',1,40774,'2022-12-12'),(11,'carlossozzi@gmail.com','2634628000','Hijo',1,40774,'2022-12-12'),(12,'centrocomercialseguros@gmail.com','2634687685','',1,40721,'2022-12-16'),(13,'gverdaguer125@gmail.com',NULL,'',1,40776,'2022-12-16'),(14,'anselmosilvestrini@gmail.com','2634614351','',1,40720,'2022-12-23'),(15,'gverdaguer125@gmail.com',NULL,'',1,40776,'2022-12-23'),(16,'centrocomercialseguros@gmail.com','2634687685','',1,40721,'2022-12-23'),(17,'centrocomercialseguros@gmail.com','2634687685','',1,40721,'2022-12-23'),(18,'centrocomercialseguros@gmail.com','2634687685','',1,40721,'2022-12-23'),(19,'musonyes@yahoo.com.ar','2613076151','ANABELLA',1,40772,'2023-02-28'),(20,'musonyes@yahoo.com.ar','2613076151','ANABELLA',1,40772,'2023-03-21'),(21,'carlossozzi@gmail.com','2634628000','Hijo',1,40774,'2023-04-13'),(22,'carlossozzi@gmail.com','2634628000','Hijo',1,40774,'2023-05-30'),(23,'gverdaguer125@gmail.com',NULL,'',1,40776,'2023-06-07'),(24,'gverdaguer125@gmail.com',NULL,'',1,40776,'2023-06-16'),(25,'gverdaguer125@gmail.com',NULL,'',1,40776,'2023-06-16'),(26,'anselmosilvestrini@gmail.com','2634614351','',1,40720,'2023-06-23'),(27,'centrocomercialseguros@gmail.com','2634687685','',1,40721,'2023-06-23'),(28,'anselmosilvestrini@gmail.com','2634614351','',1,40720,'2023-07-04'),(29,'gverdaguer125@gmail.com',NULL,'',1,40776,'2023-08-24');
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `origin_id` bigint(20) unsigned DEFAULT NULL,
  `origin_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=29361 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,7986,40721,4674,2,1,'App\\Models\\Receipt',1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',208120.00,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(2,7986,40721,4674,2,2,'App\\Models\\Receipt',2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',14000.00,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(3,7986,40721,4674,2,3,'App\\Models\\Receipt',3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',217636.65,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(4,7986,40721,4674,2,4,'App\\Models\\Receipt',4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',230571.55,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(5,7986,40721,4674,2,5,'App\\Models\\Receipt',5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',21344.00,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(6,7986,40721,4674,2,6,'App\\Models\\Receipt',6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',21123.00,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(7,7986,40721,4674,2,7,'App\\Models\\Receipt',7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',19651.00,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(8,7986,40721,4674,2,8,'App\\Models\\Receipt',8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',160270.55,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(9,7986,40721,4674,2,9,'App\\Models\\Receipt',9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',150855.54,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(10,7986,40721,4674,2,10,'App\\Models\\Receipt',10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',19824.00,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(11,7986,40721,4674,2,11,'App\\Models\\Receipt',11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-23','2022-10-23',20001.00,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(12,7986,40721,4674,2,12,'App\\Models\\Receipt',12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',20399.39,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(13,7986,40721,4674,2,13,'App\\Models\\Receipt',13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',193152.30,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(14,7986,40721,4674,2,14,'App\\Models\\Receipt',14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',19888.00,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(15,7986,40721,4674,2,15,'App\\Models\\Receipt',15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',20120.00,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(16,7986,40721,4674,2,16,'App\\Models\\Receipt',16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',203548.62,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(17,7986,40721,4674,2,17,'App\\Models\\Receipt',17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',21066.10,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(18,7986,40721,4674,2,18,'App\\Models\\Receipt',18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',164366.40,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(19,7986,40721,4674,2,19,'App\\Models\\Receipt',19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',20571.21,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(20,7986,40721,4674,2,20,'App\\Models\\Receipt',20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',240477.82,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL),(21,7986,40721,4674,2,21,'App\\Models\\Receipt',21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',160270.55,NULL,NULL,1,'2022-11-18 09:52:13','2022-11-18 09:52:13',NULL);
INSERT INTO `balance_libro` VALUES (22,7986,40721,4674,2,22,'App\\Models\\Receipt',22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',18560.00,NULL,NULL,1,'2022-11-18 09:52:14','2022-11-18 09:52:14',NULL),(23,7986,40721,4674,2,23,'App\\Models\\Receipt',23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-30','2022-10-30',20159.00,NULL,NULL,1,'2022-11-18 09:52:14','2022-11-18 09:52:14',NULL),(24,7986,40721,4674,2,24,'App\\Models\\Receipt',24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',224237.20,NULL,NULL,1,'2022-11-18 09:52:14','2022-11-18 09:52:14',NULL),(25,7986,40721,4674,2,25,'App\\Models\\Receipt',25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',19511.25,NULL,NULL,1,'2022-11-18 09:52:14','2022-11-18 09:52:14',NULL),(26,7986,40721,4674,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',15509.40,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-29 09:30:02','2022-11-29 09:30:02'),(27,7986,40721,4674,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',16023.62,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-29 09:30:55','2022-11-29 09:30:55'),(28,7986,40721,4674,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',6344.12,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-29 09:41:46','2022-11-29 09:41:46'),(29,7986,40721,4674,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',98330.18,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-29 10:18:18','2022-11-29 10:18:18'),(30,7986,40721,4674,3,30,'App\\Models\\Receipt',30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',9258.54,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-25 09:58:20','2022-11-25 09:58:20'),(31,7986,40721,4674,3,31,'App\\Models\\Receipt',31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',12551.08,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-25 09:58:52','2022-11-25 09:58:52'),(32,7986,40721,4674,3,32,'App\\Models\\Receipt',32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',10173.18,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-25 09:59:45','2022-11-25 09:59:45'),(33,7986,40721,4674,3,33,'App\\Models\\Receipt',33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',4220.24,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-25 10:00:07','2022-11-25 10:00:07'),(34,7986,40721,4674,3,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',134529.02,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-29 10:33:38','2022-11-29 10:33:38'),(35,7986,40721,4674,3,35,'App\\Models\\Receipt',35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',10308.80,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-25 10:00:26','2022-11-25 10:00:26'),(36,7986,40721,4674,3,36,'App\\Models\\Receipt',36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',76455.73,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-25 10:00:37','2022-11-25 10:00:37'),(37,7986,40721,4674,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',5327.63,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-29 10:36:40','2022-11-29 10:36:40'),(38,7986,40721,4674,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',21679.53,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-29 10:25:50','2022-11-29 10:25:50'),(39,7986,40721,4674,3,39,'App\\Models\\Receipt',39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',17921.90,NULL,NULL,1,'2022-11-18 10:02:14','2022-11-18 10:02:14',NULL),(40,7986,40721,4674,3,40,'App\\Models\\Receipt',40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-08','2022-10-08',2039.83,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(41,7986,40721,4674,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',5740.23,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-29 10:19:18','2022-11-29 10:19:18');
INSERT INTO `balance_libro` VALUES (42,7986,40721,4674,3,42,'App\\Models\\Receipt',42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',26526.24,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(43,7986,40721,4674,3,43,'App\\Models\\Receipt',43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',3348.66,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-29 11:51:42','2022-11-29 11:51:42'),(44,7986,40721,4674,3,44,'App\\Models\\Receipt',44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',9569.78,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(45,7986,40721,4674,3,45,'App\\Models\\Receipt',45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',8292.14,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-25 09:37:54','2022-11-25 09:37:54'),(46,7986,40721,4674,3,46,'App\\Models\\Receipt',46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',105457.10,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(47,7986,40721,4674,3,47,'App\\Models\\Receipt',47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',6583.14,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(48,7986,40721,4674,3,48,'App\\Models\\Receipt',48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-13','2022-10-13',8292.14,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-25 09:37:32','2022-11-25 09:37:32'),(49,7986,40721,4674,3,49,'App\\Models\\Receipt',49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3235.00,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(50,7986,40721,4674,3,50,'App\\Models\\Receipt',50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',30625.00,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(51,7986,40721,4674,3,51,'App\\Models\\Receipt',51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',3820.00,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(52,7986,40721,4674,3,52,'App\\Models\\Receipt',52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',2536.06,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(53,7986,40721,4674,3,53,'App\\Models\\Receipt',53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',26938.81,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(54,7986,40721,4674,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',7548.88,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-29 09:33:28','2022-11-29 09:33:28'),(55,7986,40721,4674,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',3565.24,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-29 09:34:28','2022-11-29 09:34:28'),(56,7986,40721,4674,3,56,'App\\Models\\Receipt',56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',6453.07,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(57,7986,40721,4674,3,57,'App\\Models\\Receipt',57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',34383.72,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(58,7986,40721,4674,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',8587.02,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-29 10:49:16','2022-11-29 10:49:16'),(59,7986,40721,4674,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',4445.69,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-29 09:43:21','2022-11-29 09:43:21'),(60,7986,40721,4674,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',61682.48,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-29 10:21:25','2022-11-29 10:21:25'),(61,7986,40721,4674,3,61,'App\\Models\\Receipt',61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',11819.62,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(62,7986,40721,4674,3,62,'App\\Models\\Receipt',62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',11036.40,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL);
INSERT INTO `balance_libro` VALUES (63,7986,40721,4674,3,63,'App\\Models\\Receipt',63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',4917.22,NULL,NULL,1,'2022-11-18 10:02:15','2022-11-18 10:02:15',NULL),(64,7986,40721,4674,3,64,'App\\Models\\Receipt',64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',18277.47,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-25 10:01:06','2022-11-25 10:01:06'),(65,7986,40721,4674,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',33613.14,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-29 10:54:37','2022-11-29 10:54:37'),(66,7986,40721,4674,3,66,'App\\Models\\Receipt',66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',14146.43,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-25 10:04:17','2022-11-25 10:04:17'),(67,7986,40721,4674,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',231478.23,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-29 10:57:54','2022-11-29 10:57:54'),(68,7986,40721,4674,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',13649.33,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-29 10:38:11','2022-11-29 10:38:11'),(69,7986,40721,4674,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1812.62,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-29 10:38:39','2022-11-29 10:38:39'),(70,7986,40721,4674,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',16509.87,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-29 10:39:12','2022-11-29 10:39:12'),(71,7986,40721,4674,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',37005.18,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-29 10:40:00','2022-11-29 10:40:00'),(72,7986,40721,4674,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',41409.83,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-29 10:40:43','2022-11-29 10:40:43'),(73,7986,40721,4674,3,73,'App\\Models\\Receipt',73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',29200.00,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-18 10:02:16',NULL),(74,7986,40721,4674,3,74,'App\\Models\\Receipt',74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',7680.00,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-18 10:02:16',NULL),(75,7986,40721,4674,3,75,'App\\Models\\Receipt',75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',2604.55,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-18 10:02:16',NULL),(76,7986,40721,4674,3,76,'App\\Models\\Receipt',76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',6017.21,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-18 10:02:16',NULL),(77,7986,40721,4674,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4817.91,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-29 10:50:23','2022-11-29 10:50:23'),(78,7986,40721,4674,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',18648.39,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-29 09:36:27','2022-11-29 09:36:27'),(79,7986,40721,4674,3,79,'App\\Models\\Receipt',79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',62896.22,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-18 10:02:16',NULL),(80,7986,40721,4674,3,80,'App\\Models\\Receipt',80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',14149.94,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-25 10:04:29','2022-11-25 10:04:29'),(81,7986,40721,4674,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3291.79,NULL,NULL,1,'2022-11-18 10:02:16','2022-11-29 09:44:34','2022-11-29 09:44:34'),(82,7986,40721,4674,3,82,'App\\Models\\Receipt',82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',25139.09,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-18 10:02:17',NULL);
INSERT INTO `balance_libro` VALUES (83,7986,40721,4674,3,83,'App\\Models\\Receipt',83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',14688.43,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-18 10:02:17',NULL),(84,7986,40721,4674,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',26829.21,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-29 09:54:57','2022-11-29 09:54:57'),(85,7986,40721,4674,3,85,'App\\Models\\Receipt',85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',916.21,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-25 09:58:11','2022-11-25 09:58:11'),(86,7986,40721,4674,3,86,'App\\Models\\Receipt',86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-25','2022-10-25',3690.00,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-18 10:02:17',NULL),(87,7986,40721,4674,3,87,'App\\Models\\Receipt',87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',17194.64,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-18 10:02:17',NULL),(88,7986,40721,4674,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',7926.04,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-29 10:44:40','2022-11-29 10:44:40'),(89,7986,40721,4674,3,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',9665.00,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-30 09:40:06','2022-11-30 09:40:06'),(90,7986,40721,4674,3,90,'App\\Models\\Receipt',90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',27125.00,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-18 10:02:17',NULL),(91,7986,40721,4674,3,91,'App\\Models\\Receipt',91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',29067.67,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-18 10:02:17',NULL),(92,7986,40721,4674,3,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',4138.57,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-29 10:51:19','2022-11-29 10:51:19'),(93,7986,40721,4674,3,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1821.17,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-29 10:52:05','2022-11-29 10:52:05'),(94,7986,40721,4674,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',26938.81,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-29 09:32:34','2022-11-29 09:32:34'),(95,7986,40721,4674,3,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4420.48,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-29 09:45:31','2022-11-29 09:45:31'),(96,7986,40721,4674,3,96,'App\\Models\\Receipt',96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',14329.74,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-18 10:02:17',NULL),(97,7986,40721,4674,3,97,'App\\Models\\Receipt',97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',15356.64,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-18 10:02:17',NULL),(98,7986,40721,4674,3,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1280.41,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-29 10:22:41','2022-11-29 10:22:41'),(99,7986,40721,4674,3,99,'App\\Models\\Receipt',99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',7213.08,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-25 10:04:44','2022-11-25 10:04:44'),(100,7986,40721,4674,3,100,'App\\Models\\Receipt',100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',28739.24,NULL,NULL,1,'2022-11-18 10:02:17','2022-11-25 10:05:04','2022-11-25 10:05:04'),(105,7986,40720,1515,3,105,'App\\Models\\Receipt',105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',14680.00,NULL,NULL,1,'2022-11-18 10:44:30','2022-11-18 10:44:30',NULL),(106,7986,40720,1515,3,106,'App\\Models\\Receipt',106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',3080.00,NULL,NULL,1,'2022-11-18 10:53:29','2022-11-18 10:53:29',NULL);
INSERT INTO `balance_libro` VALUES (107,7986,40720,1515,2,107,'App\\Models\\Receipt',107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',10000.15,NULL,NULL,1,'2022-11-18 11:06:35','2022-11-18 11:07:26','2022-11-18 11:07:26'),(108,7986,40720,1515,3,108,'App\\Models\\Receipt',108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',10000.15,NULL,NULL,1,'2022-11-18 11:09:23','2022-11-18 11:09:23',NULL),(109,7986,40720,1515,3,109,'App\\Models\\Receipt',109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',56460.00,NULL,NULL,1,'2022-11-18 11:11:29','2022-11-18 11:11:29',NULL),(110,7986,40720,1515,3,110,'App\\Models\\Receipt',110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',3110.00,NULL,NULL,1,'2022-11-18 11:12:37','2022-11-18 11:12:37',NULL),(111,7986,40720,1515,3,111,'App\\Models\\Receipt',111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',9101.31,NULL,NULL,1,'2022-11-18 11:14:54','2022-11-18 11:14:54',NULL),(112,7986,40720,4823,15,23,'App\\Models\\PeriodLiquidation',NULL,23,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',138295.66,NULL,NULL,1,'2022-11-18 12:06:15','2022-11-18 12:06:15',NULL),(113,7986,40720,1515,15,27,'App\\Models\\PeriodLiquidation',NULL,27,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',147149.70,NULL,NULL,1,'2022-11-18 12:13:12','2022-11-18 12:13:12',NULL),(114,7986,40720,1515,16,25,'App\\Models\\PeriodLiquidation',NULL,25,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',592.00,NULL,NULL,1,'2022-11-18 12:14:04','2022-11-18 12:14:04',NULL),(115,7986,40759,8008,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',61573.73,NULL,NULL,1,'2022-11-23 09:34:45','2022-11-23 10:08:28','2022-11-23 10:08:28'),(116,7986,40759,8008,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',77971.23,NULL,NULL,1,'2022-11-23 09:34:45','2022-11-23 10:09:17','2022-11-23 10:09:17'),(117,7986,40759,8008,3,114,'App\\Models\\Receipt',114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1000.00,NULL,NULL,1,'2022-11-23 09:34:45','2022-12-21 08:55:25','2022-12-21 08:55:25'),(118,7986,40759,8008,3,115,'App\\Models\\Receipt',115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',320.98,NULL,NULL,1,'2022-11-23 09:34:45','2022-12-21 08:56:10','2022-12-21 08:56:10'),(119,7986,40759,8008,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',5656.07,NULL,NULL,1,'2022-11-23 09:34:45','2022-11-23 10:10:08','2022-11-23 10:10:08'),(120,7986,40759,8008,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',52666.35,NULL,NULL,1,'2022-11-23 09:34:45','2022-11-23 10:11:14','2022-11-23 10:11:14'),(121,7986,40759,8008,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',6471.98,NULL,NULL,1,'2022-11-23 09:34:45','2022-11-23 10:13:49','2022-11-23 10:13:49'),(122,7986,40759,8008,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',89046.00,NULL,NULL,1,'2022-11-23 09:34:45','2022-11-23 10:11:53','2022-11-23 10:11:53'),(123,7986,40759,8008,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',5080.13,NULL,NULL,1,'2022-11-23 09:34:45','2022-11-23 10:14:28','2022-11-23 10:14:28'),(124,7986,40759,8008,3,121,'App\\Models\\Receipt',121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',14782.15,NULL,NULL,1,'2022-11-23 09:34:45','2022-11-23 09:34:45',NULL),(125,7986,40759,8008,3,122,'App\\Models\\Receipt',122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',3577.79,NULL,NULL,1,'2022-11-23 09:34:45','2022-11-23 09:34:45',NULL),(126,7986,40759,8008,3,123,'App\\Models\\Receipt',123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',327.23,NULL,NULL,1,'2022-11-23 09:34:45','2022-11-23 09:34:45',NULL);
INSERT INTO `balance_libro` VALUES (127,7986,40759,8008,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',93441.20,NULL,NULL,1,'2022-11-23 09:34:45','2022-11-23 10:14:55','2022-11-23 10:14:55'),(128,7986,40759,8008,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',122481.42,NULL,NULL,1,'2022-11-23 09:34:46','2022-11-23 10:15:27','2022-11-23 10:15:27'),(129,7986,40759,8008,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',3908.27,NULL,NULL,1,'2022-11-23 09:34:46','2022-11-23 10:15:58','2022-11-23 10:15:58'),(130,7986,40759,8008,3,127,'App\\Models\\Receipt',127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',4508.24,NULL,NULL,1,'2022-11-23 09:34:46','2022-11-23 09:34:46',NULL),(131,7986,40759,8008,3,128,'App\\Models\\Receipt',128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',422.77,NULL,NULL,1,'2022-11-23 09:34:46','2022-11-23 09:34:46',NULL),(132,7986,40759,8008,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',49969.89,NULL,NULL,1,'2022-11-23 09:34:46','2022-11-23 10:16:20','2022-11-23 10:16:20'),(133,7986,40759,8008,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',4119.80,NULL,NULL,1,'2022-11-23 09:34:46','2022-11-23 10:16:48','2022-11-23 10:16:48'),(134,7986,40759,8008,3,131,'App\\Models\\Receipt',131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',147599.91,NULL,NULL,1,'2022-11-23 09:34:46','2022-11-23 09:34:46',NULL),(135,7986,40759,8008,3,132,'App\\Models\\Receipt',132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4031.54,NULL,NULL,1,'2022-11-23 09:34:46','2022-11-23 09:34:46',NULL),(136,7986,40759,8008,3,133,'App\\Models\\Receipt',133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',265.66,NULL,NULL,1,'2022-11-23 09:34:46','2022-11-23 09:34:46',NULL),(137,7986,40759,8008,3,112,'App\\Models\\Receipt',112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',61573.73,NULL,NULL,1,'2022-11-23 10:08:28','2022-12-21 08:54:08','2022-12-21 08:54:08'),(138,7986,40759,8008,3,113,'App\\Models\\Receipt',113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',77971.23,NULL,NULL,1,'2022-11-23 10:09:17','2022-12-21 08:53:53','2022-12-21 08:53:53'),(139,7986,40759,8008,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',5655.80,NULL,NULL,1,'2022-11-23 10:10:08','2022-11-23 10:10:43','2022-11-23 10:10:43'),(140,7986,40759,8008,3,116,'App\\Models\\Receipt',116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',5656.07,NULL,NULL,1,'2022-11-23 10:10:43','2022-11-23 10:10:43',NULL),(141,7986,40759,8008,3,117,'App\\Models\\Receipt',117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',52666.35,NULL,NULL,1,'2022-11-23 10:11:14','2022-11-23 10:11:14',NULL),(142,7986,40759,8008,3,119,'App\\Models\\Receipt',119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',89045.99,NULL,NULL,1,'2022-11-23 10:11:53','2022-11-23 10:11:53',NULL),(143,7986,40759,8008,3,118,'App\\Models\\Receipt',118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-12','2022-10-12',6471.98,NULL,NULL,1,'2022-11-23 10:13:49','2022-11-23 10:13:49',NULL),(144,7986,40759,8008,3,120,'App\\Models\\Receipt',120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-14','2022-10-14',5080.13,NULL,NULL,1,'2022-11-23 10:14:28','2022-11-23 10:14:28',NULL),(145,7986,40759,8008,3,124,'App\\Models\\Receipt',124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-18','2022-10-18',93441.20,NULL,NULL,1,'2022-11-23 10:14:55','2022-11-23 10:14:55',NULL),(146,7986,40759,8008,3,125,'App\\Models\\Receipt',125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',122481.42,NULL,NULL,1,'2022-11-23 10:15:27','2022-11-23 10:15:27',NULL);
INSERT INTO `balance_libro` VALUES (147,7986,40759,8008,3,126,'App\\Models\\Receipt',126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',3908.27,NULL,NULL,1,'2022-11-23 10:15:58','2022-11-23 10:15:58',NULL),(148,7986,40759,8008,3,129,'App\\Models\\Receipt',129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',49969.89,NULL,NULL,1,'2022-11-23 10:16:20','2022-11-23 10:16:20',NULL),(149,7986,40759,8008,3,130,'App\\Models\\Receipt',130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',4119.80,NULL,NULL,1,'2022-11-23 10:16:48','2022-11-23 10:16:48',NULL),(150,7986,40721,4674,3,26,'App\\Models\\Receipt',26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',15509.40,NULL,NULL,1,'2022-11-29 09:30:02','2022-11-29 09:30:02',NULL),(151,7986,40721,4674,3,27,'App\\Models\\Receipt',27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-01','2022-10-01',16023.62,NULL,NULL,1,'2022-11-29 09:30:55','2022-11-29 09:30:55',NULL),(152,7986,40721,4674,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',26938.81,NULL,NULL,1,'2022-11-29 09:32:34','2022-11-29 09:38:22','2022-11-29 09:38:22'),(153,7986,40721,4674,3,54,'App\\Models\\Receipt',54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',7548.88,NULL,NULL,1,'2022-11-29 09:33:28','2022-11-29 09:33:28',NULL),(154,7986,40721,4674,3,55,'App\\Models\\Receipt',55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',3565.24,NULL,NULL,1,'2022-11-29 09:34:28','2022-11-29 09:34:28',NULL),(155,7986,40721,4674,3,78,'App\\Models\\Receipt',78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-22','2022-10-22',18648.39,NULL,NULL,1,'2022-11-29 09:36:27','2022-11-29 09:36:27',NULL),(156,7986,40721,4674,3,94,'App\\Models\\Receipt',94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-29','2022-10-29',26938.81,NULL,NULL,1,'2022-11-29 09:38:22','2022-11-29 09:38:22',NULL),(157,7986,40721,4674,3,28,'App\\Models\\Receipt',28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',6344.12,NULL,NULL,1,'2022-11-29 09:41:46','2022-11-29 09:41:46',NULL),(158,7986,40721,4674,3,59,'App\\Models\\Receipt',59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',4445.69,NULL,NULL,1,'2022-11-29 09:43:21','2022-11-29 09:43:21',NULL),(159,7986,40721,4674,3,81,'App\\Models\\Receipt',81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',3291.79,NULL,NULL,1,'2022-11-29 09:44:34','2022-11-29 09:44:34',NULL),(160,7986,40721,4674,3,95,'App\\Models\\Receipt',95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4420.48,NULL,NULL,1,'2022-11-29 09:45:31','2022-11-29 09:45:31',NULL),(161,7986,40721,4674,3,84,'App\\Models\\Receipt',84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-24','2022-10-24',26829.21,NULL,NULL,1,'2022-11-29 09:54:57','2022-11-29 09:54:57',NULL),(162,7986,40721,4674,3,29,'App\\Models\\Receipt',29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-03','2022-10-03',98330.18,NULL,NULL,1,'2022-11-29 10:18:18','2022-11-29 10:18:18',NULL),(163,7986,40721,4674,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',10323.51,NULL,NULL,1,'2022-11-29 10:19:18','2022-11-29 10:20:11','2022-11-29 10:20:11'),(164,7986,40721,4674,3,41,'App\\Models\\Receipt',41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-11','2022-10-11',5740.23,NULL,NULL,1,'2022-11-29 10:20:11','2022-11-29 10:20:11',NULL),(165,7986,40721,4674,3,60,'App\\Models\\Receipt',60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-17','2022-10-17',61682.48,NULL,NULL,1,'2022-11-29 10:21:25','2022-11-29 10:21:25',NULL),(166,7986,40721,4674,3,98,'App\\Models\\Receipt',98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1280.41,NULL,NULL,1,'2022-11-29 10:22:41','2022-11-29 10:22:41',NULL),(167,7986,40721,4674,3,38,'App\\Models\\Receipt',38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',21679.53,NULL,NULL,1,'2022-11-29 10:25:50','2022-11-29 10:25:50',NULL);
INSERT INTO `balance_libro` VALUES (168,7986,40721,4674,3,34,'App\\Models\\Receipt',34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',134529.02,NULL,NULL,1,'2022-11-29 10:33:38','2022-11-29 10:33:38',NULL),(169,7986,40721,4674,3,37,'App\\Models\\Receipt',37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-06','2022-10-06',5327.63,NULL,NULL,1,'2022-11-29 10:36:40','2022-11-29 10:36:40',NULL),(170,7986,40721,4674,3,68,'App\\Models\\Receipt',68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',13649.33,NULL,NULL,1,'2022-11-29 10:38:11','2022-11-29 10:38:11',NULL),(171,7986,40721,4674,3,69,'App\\Models\\Receipt',69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',1812.62,NULL,NULL,1,'2022-11-29 10:38:39','2022-11-29 10:38:39',NULL),(172,7986,40721,4674,3,70,'App\\Models\\Receipt',70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',16509.87,NULL,NULL,1,'2022-11-29 10:39:12','2022-11-29 10:39:12',NULL),(173,7986,40721,4674,3,71,'App\\Models\\Receipt',71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',37005.18,NULL,NULL,1,'2022-11-29 10:40:00','2022-11-29 10:40:00',NULL),(174,7986,40721,4674,3,72,'App\\Models\\Receipt',72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',41409.83,NULL,NULL,1,'2022-11-29 10:40:43','2022-11-29 10:40:43',NULL),(175,7986,40721,4674,3,88,'App\\Models\\Receipt',88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-27','2022-10-27',7926.04,NULL,NULL,1,'2022-11-29 10:44:40','2022-11-29 10:44:40',NULL),(176,7986,40721,4674,3,58,'App\\Models\\Receipt',58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-15','2022-10-15',8587.02,NULL,NULL,1,'2022-11-29 10:49:16','2022-11-29 10:49:16',NULL),(177,7986,40721,4674,3,77,'App\\Models\\Receipt',77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-21','2022-10-21',4817.91,NULL,NULL,1,'2022-11-29 10:50:23','2022-11-29 10:50:23',NULL),(178,7986,40721,4674,3,92,'App\\Models\\Receipt',92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',4138.57,NULL,NULL,1,'2022-11-29 10:51:19','2022-11-29 10:51:19',NULL),(179,7986,40721,4674,3,93,'App\\Models\\Receipt',93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',1821.17,NULL,NULL,1,'2022-11-29 10:52:05','2022-11-29 10:52:05',NULL),(180,7986,40721,4674,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',33613.14,NULL,NULL,1,'2022-11-29 10:54:37','2022-11-29 10:55:47','2022-11-29 10:55:47'),(181,7986,40721,4674,3,65,'App\\Models\\Receipt',65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-19','2022-10-19',33613.14,NULL,NULL,1,'2022-11-29 10:55:47','2022-11-29 10:55:47',NULL),(182,7986,40721,4674,3,67,'App\\Models\\Receipt',67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-20','2022-10-20',231478.23,NULL,NULL,1,'2022-11-29 10:57:54','2022-11-29 10:57:54',NULL),(183,7986,40721,4674,3,134,'App\\Models\\Receipt',134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-26','2022-09-26',22604.59,NULL,NULL,1,'2022-11-29 11:14:53','2022-11-29 11:14:53',NULL),(184,7986,40721,4674,3,135,'App\\Models\\Receipt',135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',11730.37,NULL,NULL,1,'2022-11-29 11:16:12','2022-11-29 11:16:12',NULL),(185,7986,40721,4674,3,136,'App\\Models\\Receipt',136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-19','2022-07-19',268624.97,NULL,NULL,1,'2022-11-29 11:17:09','2022-11-29 11:17:09',NULL),(186,7986,40721,4674,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',27099.04,NULL,NULL,1,'2022-11-29 11:29:01','2022-11-30 09:28:36','2022-11-30 09:28:36'),(187,7986,40721,4674,3,138,'App\\Models\\Receipt',138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',3019.59,NULL,NULL,1,'2022-11-29 11:30:59','2022-11-29 11:30:59',NULL),(188,7986,40721,4674,3,139,'App\\Models\\Receipt',139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1279.08,NULL,NULL,1,'2022-11-29 11:33:34','2022-11-29 11:33:34',NULL);
INSERT INTO `balance_libro` VALUES (189,7986,40721,4674,3,140,'App\\Models\\Receipt',140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',4895.18,NULL,NULL,1,'2022-11-29 11:35:34','2022-11-29 11:35:34',NULL),(190,7986,40721,4674,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',11239.02,NULL,NULL,1,'2022-11-29 11:36:44','2022-11-30 09:50:09','2022-11-30 09:50:09'),(191,7986,40721,4674,3,142,'App\\Models\\Receipt',142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',9087.15,NULL,NULL,1,'2022-11-29 11:38:19','2022-11-29 11:38:19',NULL),(192,7986,40721,4674,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',14119.22,NULL,NULL,1,'2022-11-29 11:39:29','2022-11-30 09:28:14','2022-11-30 09:28:14'),(193,7986,40721,4674,3,144,'App\\Models\\Receipt',144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-29','2022-09-29',24805.00,NULL,NULL,1,'2022-11-29 12:06:28','2022-11-29 12:06:28',NULL),(194,7986,40721,4674,3,143,'App\\Models\\Receipt',143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-28','2022-09-28',17756.48,NULL,NULL,1,'2022-11-30 09:28:14','2022-11-30 09:28:14',NULL),(195,7986,40721,4674,3,137,'App\\Models\\Receipt',137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-26','2022-10-26',33994.63,NULL,NULL,1,'2022-11-30 09:28:36','2022-11-30 09:28:36',NULL),(196,7986,40721,4674,3,89,'App\\Models\\Receipt',89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-28','2022-10-28',9665.00,NULL,NULL,1,'2022-11-30 09:40:06','2022-11-30 09:40:06',NULL),(197,7986,40721,4674,3,145,'App\\Models\\Receipt',145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3887.85,NULL,NULL,1,'2022-11-30 09:45:53','2022-11-30 09:45:53',NULL),(198,7986,40721,4674,3,141,'App\\Models\\Receipt',141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',11323.39,NULL,NULL,1,'2022-11-30 09:50:09','2022-11-30 09:50:09',NULL),(199,7986,40719,13,2,146,'App\\Models\\Receipt',146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',21000.00,NULL,NULL,1,'2022-12-12 18:07:10','2022-12-12 18:07:10',NULL),(200,7986,40719,13,2,147,'App\\Models\\Receipt',147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6200.00,NULL,NULL,1,'2022-12-12 18:07:10','2022-12-12 18:07:10',NULL),(201,7986,40719,13,2,148,'App\\Models\\Receipt',148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6500.00,NULL,NULL,1,'2022-12-12 18:07:10','2022-12-12 18:07:10',NULL),(202,7986,40776,17351,2,149,'App\\Models\\Receipt',149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',1856400.00,NULL,NULL,1,'2022-12-16 09:51:26','2022-12-16 09:51:26',NULL),(203,7986,40776,17351,2,150,'App\\Models\\Receipt',150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',1856400.00,NULL,NULL,1,'2022-12-16 09:51:26','2022-12-16 09:51:26',NULL),(204,7986,40776,17351,2,151,'App\\Models\\Receipt',151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',1856400.00,NULL,NULL,1,'2022-12-16 09:51:26','2022-12-16 09:51:26',NULL),(205,7986,40776,17351,2,152,'App\\Models\\Receipt',152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',387861.01,NULL,NULL,1,'2022-12-16 09:51:26','2022-12-16 09:51:26',NULL),(206,7986,40721,3015,2,153,'App\\Models\\Receipt',153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',216172.55,NULL,NULL,1,'2022-12-16 10:13:47','2022-12-16 10:13:47',NULL),(207,7986,40721,3015,2,154,'App\\Models\\Receipt',154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',231390.72,NULL,NULL,1,'2022-12-16 10:13:47','2022-12-16 10:13:47',NULL),(208,7986,40721,3015,2,155,'App\\Models\\Receipt',155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',20198.00,NULL,NULL,1,'2022-12-16 10:13:47','2022-12-16 10:13:47',NULL),(209,7986,40721,3015,2,156,'App\\Models\\Receipt',156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',19870.00,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL);
INSERT INTO `balance_libro` VALUES (210,7986,40721,3015,2,157,'App\\Models\\Receipt',157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',17622.00,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(211,7986,40721,3015,2,158,'App\\Models\\Receipt',158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',20341.00,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(212,7986,40721,3015,2,159,'App\\Models\\Receipt',159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',220638.66,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(213,7986,40721,3015,2,160,'App\\Models\\Receipt',160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',19201.00,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(214,7986,40721,3015,2,161,'App\\Models\\Receipt',161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',19448.00,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(215,7986,40721,3015,2,162,'App\\Models\\Receipt',162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',244297.79,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(216,7986,40721,3015,2,163,'App\\Models\\Receipt',163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',255053.48,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(217,7986,40721,3015,2,164,'App\\Models\\Receipt',164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',20911.00,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(218,7986,40721,3015,2,165,'App\\Models\\Receipt',165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',19744.00,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(219,7986,40721,3015,2,166,'App\\Models\\Receipt',166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',19110.00,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(220,7986,40721,3015,2,167,'App\\Models\\Receipt',167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',18992.00,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(221,7986,40721,3015,2,168,'App\\Models\\Receipt',168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',216550.07,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(222,7986,40721,3015,2,169,'App\\Models\\Receipt',169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',213604.93,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(223,7986,40721,3015,2,170,'App\\Models\\Receipt',170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',17900.00,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(224,7986,40721,3015,2,171,'App\\Models\\Receipt',171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',20161.00,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(225,7986,40721,3015,2,172,'App\\Models\\Receipt',172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',20341.00,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(226,7986,40721,3015,2,173,'App\\Models\\Receipt',173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',18762.00,NULL,NULL,1,'2022-12-16 10:13:48','2022-12-16 10:13:48',NULL),(227,7986,40721,3015,3,174,'App\\Models\\Receipt',174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',1722.78,NULL,NULL,1,'2022-12-16 11:32:08','2022-12-23 09:04:44','2022-12-23 09:04:44'),(228,7986,40721,3015,3,175,'App\\Models\\Receipt',175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',16245.00,NULL,NULL,1,'2022-12-16 11:32:08','2022-12-16 11:32:08',NULL),(229,7986,40721,3015,3,176,'App\\Models\\Receipt',176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',22702.39,NULL,NULL,1,'2022-12-16 11:32:08','2022-12-23 09:40:05','2022-12-23 09:40:05'),(230,7986,40721,3015,3,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',439865.91,NULL,NULL,1,'2022-12-16 11:32:08','2022-12-23 11:37:03','2022-12-23 11:37:03');
INSERT INTO `balance_libro` VALUES (231,7986,40721,3015,3,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',5215.88,NULL,NULL,1,'2022-12-16 11:32:08','2022-12-23 11:37:23','2022-12-23 11:37:23'),(232,7986,40721,3015,3,179,'App\\Models\\Receipt',179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',22675.00,NULL,NULL,1,'2022-12-16 11:32:08','2022-12-16 11:32:08',NULL),(233,7986,40721,3015,3,180,'App\\Models\\Receipt',180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',18722.69,NULL,NULL,1,'2022-12-16 11:32:08','2022-12-16 11:32:08',NULL),(234,7986,40721,3015,3,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',270316.64,NULL,NULL,1,'2022-12-16 11:32:08','2022-12-23 11:37:57','2022-12-23 11:37:57'),(235,7986,40721,3015,3,182,'App\\Models\\Receipt',182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',0.01,NULL,NULL,1,'2022-12-16 11:32:08','2022-12-16 11:32:08',NULL),(236,7986,40721,3015,3,183,'App\\Models\\Receipt',183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',5307.44,NULL,NULL,1,'2022-12-16 11:32:08','2022-12-23 09:09:46','2022-12-23 09:09:46'),(237,7986,40721,3015,3,184,'App\\Models\\Receipt',184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',8676.01,NULL,NULL,1,'2022-12-16 11:32:08','2022-12-16 11:32:08',NULL),(238,7986,40721,3015,3,185,'App\\Models\\Receipt',185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',20591.04,NULL,NULL,1,'2022-12-16 11:32:08','2022-12-16 11:32:08',NULL),(239,7986,40721,3015,3,186,'App\\Models\\Receipt',186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',820.79,NULL,NULL,1,'2022-12-16 11:32:08','2022-12-16 11:32:08',NULL),(240,7986,40721,3015,3,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',64652.95,NULL,NULL,1,'2022-12-16 11:32:09','2022-12-23 11:38:36','2022-12-23 11:38:36'),(241,7986,40721,3015,3,188,'App\\Models\\Receipt',188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',1777.76,NULL,NULL,1,'2022-12-16 11:32:09','2022-12-23 09:11:16','2022-12-23 09:11:16'),(242,7986,40721,3015,3,189,'App\\Models\\Receipt',189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',8364.78,NULL,NULL,1,'2022-12-16 11:32:09','2022-12-16 11:32:09',NULL),(243,7986,40721,3015,3,190,'App\\Models\\Receipt',190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',36528.60,NULL,NULL,1,'2022-12-16 11:32:09','2022-12-16 11:32:09',NULL),(244,7986,40721,3015,3,191,'App\\Models\\Receipt',191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',5307.44,NULL,NULL,1,'2022-12-16 11:32:09','2022-12-23 09:12:07','2022-12-23 09:12:07'),(245,7986,40721,3015,3,192,'App\\Models\\Receipt',192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',22529.13,NULL,NULL,1,'2022-12-16 11:32:09','2022-12-23 10:55:41','2022-12-23 10:55:41'),(246,7986,40721,3015,3,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',20744.66,NULL,NULL,1,'2022-12-16 11:32:09','2022-12-23 11:39:05','2022-12-23 11:39:05'),(247,7986,40721,3015,3,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1553.41,NULL,NULL,1,'2022-12-16 11:32:09','2022-12-23 11:39:52','2022-12-23 11:39:52'),(248,7986,40721,3015,3,195,'App\\Models\\Receipt',195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',1250.00,NULL,NULL,1,'2022-12-16 11:32:09','2022-12-16 11:32:09',NULL),(249,7986,40721,3015,3,196,'App\\Models\\Receipt',196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',36110.00,NULL,NULL,1,'2022-12-16 11:32:09','2022-12-16 11:32:09',NULL),(250,7986,40721,3015,3,197,'App\\Models\\Receipt',197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',3200.00,NULL,NULL,1,'2022-12-16 11:32:09','2022-12-16 11:32:09',NULL);
INSERT INTO `balance_libro` VALUES (251,7986,40721,3015,3,198,'App\\Models\\Receipt',198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',5280.00,NULL,NULL,1,'2022-12-16 11:32:09','2022-12-16 11:32:09',NULL),(252,7986,40721,3015,3,199,'App\\Models\\Receipt',199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',17166.51,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-16 11:32:10',NULL),(253,7986,40721,3015,3,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',13851.38,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-23 11:40:45','2022-12-23 11:40:45'),(254,7986,40721,3015,3,201,'App\\Models\\Receipt',201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',3200.00,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-23 09:17:12','2022-12-23 09:17:12'),(255,7986,40721,3015,3,202,'App\\Models\\Receipt',202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',78170.89,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-23 09:17:57','2022-12-23 09:17:57'),(256,7986,40721,3015,3,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',20928.10,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-23 11:41:41','2022-12-23 11:41:41'),(257,7986,40721,3015,3,204,'App\\Models\\Receipt',204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',14146.43,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-23 09:18:30','2022-12-23 09:18:30'),(258,7986,40721,3015,3,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',5307.44,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-23 11:42:00','2022-12-23 11:42:00'),(259,7986,40721,3015,3,206,'App\\Models\\Receipt',206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',30327.26,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-23 09:19:02','2022-12-23 09:19:02'),(260,7986,40721,3015,3,207,'App\\Models\\Receipt',207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',9331.95,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-23 09:19:29','2022-12-23 09:19:29'),(261,7986,40721,3015,3,208,'App\\Models\\Receipt',208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',27921.88,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-16 11:32:10',NULL),(262,7986,40721,3015,3,209,'App\\Models\\Receipt',209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',2317.43,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-16 11:32:10',NULL),(263,7986,40721,3015,3,210,'App\\Models\\Receipt',210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',8372.72,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-23 09:20:31','2022-12-23 09:20:31'),(264,7986,40721,3015,3,211,'App\\Models\\Receipt',211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',10200.46,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-16 11:32:10',NULL),(265,7986,40721,3015,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',45137.20,NULL,NULL,1,'2022-12-16 11:32:10','2022-12-23 11:42:26','2022-12-23 11:42:26'),(266,7986,40721,3015,3,213,'App\\Models\\Receipt',213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',12379.39,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-16 11:32:11',NULL),(267,7986,40721,3015,3,214,'App\\Models\\Receipt',214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',11513.11,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-23 09:21:33','2022-12-23 09:21:33'),(268,7986,40721,3015,3,215,'App\\Models\\Receipt',215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',24853.98,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-23 09:39:53','2022-12-23 09:39:53'),(269,7986,40721,3015,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4291.54,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-23 11:42:49','2022-12-23 11:42:49'),(270,7986,40721,3015,3,217,'App\\Models\\Receipt',217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',21800.00,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-16 11:32:11',NULL);
INSERT INTO `balance_libro` VALUES (271,7986,40721,3015,3,218,'App\\Models\\Receipt',218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2673.02,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-16 11:32:11',NULL),(272,7986,40721,3015,3,219,'App\\Models\\Receipt',219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',21712.13,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-23 09:23:06','2022-12-23 09:23:06'),(273,7986,40721,3015,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',9703.38,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-23 11:43:06','2022-12-23 11:43:06'),(274,7986,40721,3015,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',41522.64,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-23 11:43:27','2022-12-23 11:43:27'),(275,7986,40721,3015,3,222,'App\\Models\\Receipt',222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',2701.74,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-16 11:32:11',NULL),(276,7986,40721,3015,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',34235.48,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-23 11:46:59','2022-12-23 11:46:59'),(277,7986,40721,3015,3,224,'App\\Models\\Receipt',224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',64937.21,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-23 09:24:08','2022-12-23 09:24:08'),(278,7986,40721,3015,3,225,'App\\Models\\Receipt',225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',52313.63,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-16 11:32:11',NULL),(279,7986,40721,3015,3,226,'App\\Models\\Receipt',226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',6639.09,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-23 10:55:14','2022-12-23 10:55:14'),(280,7986,40721,3015,3,227,'App\\Models\\Receipt',227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',29155.98,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-16 11:32:11',NULL),(281,7986,40721,3015,3,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',4302.16,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-23 11:47:40','2022-12-23 11:47:40'),(282,7986,40721,3015,3,229,'App\\Models\\Receipt',229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',913000.61,NULL,NULL,1,'2022-12-16 11:32:11','2022-12-16 11:32:11',NULL),(283,7986,40721,3015,3,230,'App\\Models\\Receipt',230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',30000.00,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-16 11:32:12',NULL),(284,7986,40721,3015,3,231,'App\\Models\\Receipt',231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',3530.00,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-16 11:32:12',NULL),(285,7986,40721,3015,3,232,'App\\Models\\Receipt',232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',17000.00,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-23 09:31:56','2022-12-23 09:31:56'),(286,7986,40721,3015,3,233,'App\\Models\\Receipt',233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',3690.00,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-23 09:32:29','2022-12-23 09:32:29'),(287,7986,40721,3015,3,234,'App\\Models\\Receipt',234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',18450.78,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-16 11:32:12',NULL),(288,7986,40721,3015,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',6013.08,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-23 11:48:15','2022-12-23 11:48:15'),(289,7986,40721,3015,3,236,'App\\Models\\Receipt',236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',62170.59,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-23 09:33:09','2022-12-23 09:33:09'),(290,7986,40721,3015,3,237,'App\\Models\\Receipt',237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',6800.03,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-23 09:33:29','2022-12-23 09:33:29');
INSERT INTO `balance_libro` VALUES (291,7986,40721,3015,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',36497.48,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-23 11:49:08','2022-12-23 11:49:08'),(292,7986,40721,3015,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',237055.57,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-23 11:48:36','2022-12-23 11:48:36'),(293,7986,40721,3015,3,240,'App\\Models\\Receipt',240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',5361.43,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-16 11:32:12',NULL),(294,7986,40721,3015,3,241,'App\\Models\\Receipt',241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',23156.40,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-16 11:32:12',NULL),(295,7986,40721,3015,3,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',29351.19,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-23 11:49:52','2022-12-23 11:49:52'),(296,7986,40721,3015,3,243,'App\\Models\\Receipt',243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',14068.33,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-23 09:34:39','2022-12-23 09:34:39'),(297,7986,40721,3015,3,244,'App\\Models\\Receipt',244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',1752.45,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-23 09:35:05','2022-12-23 09:35:05'),(298,7986,40721,3015,3,245,'App\\Models\\Receipt',245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',30009.00,NULL,NULL,1,'2022-12-16 11:32:12','2022-12-23 09:35:43','2022-12-23 09:35:43'),(299,7986,40721,3015,3,246,'App\\Models\\Receipt',246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',23005.00,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-23 10:54:59','2022-12-23 10:54:59'),(300,7986,40721,3015,3,247,'App\\Models\\Receipt',247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8024.49,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-23 09:36:11','2022-12-23 09:36:11'),(301,7986,40721,3015,3,248,'App\\Models\\Receipt',248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2580.11,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-23 09:36:38','2022-12-23 09:36:38'),(302,7986,40721,3015,3,249,'App\\Models\\Receipt',249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',18913.11,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-16 11:32:13',NULL),(303,7986,40721,3015,3,250,'App\\Models\\Receipt',250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1524.96,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-16 11:32:13',NULL),(304,7986,40721,3015,3,251,'App\\Models\\Receipt',251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',16807.24,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-16 11:32:13',NULL),(305,7986,40721,3015,3,252,'App\\Models\\Receipt',252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',29530.29,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-23 09:37:29','2022-12-23 09:37:29'),(306,7986,40721,3015,3,253,'App\\Models\\Receipt',253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',73825.73,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-23 09:37:40','2022-12-23 09:37:40'),(307,7986,40721,3015,3,254,'App\\Models\\Receipt',254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',25433.81,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-23 09:37:49','2022-12-23 09:37:49'),(308,7986,40721,3015,3,255,'App\\Models\\Receipt',255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3682.04,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-23 09:38:01','2022-12-23 09:38:01'),(309,7986,40721,3015,3,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1544.34,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-23 11:50:14','2022-12-23 11:50:14'),(310,7986,40721,3015,3,257,'App\\Models\\Receipt',257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11129.58,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-23 09:38:16','2022-12-23 09:38:16');
INSERT INTO `balance_libro` VALUES (311,7986,40721,3015,3,258,'App\\Models\\Receipt',258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',15983.45,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-23 09:38:24','2022-12-23 09:38:24'),(312,7986,40721,3015,3,259,'App\\Models\\Receipt',259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8181.52,NULL,NULL,1,'2022-12-16 11:32:13','2022-12-23 09:38:43','2022-12-23 09:38:43'),(313,7986,40720,1516,3,260,'App\\Models\\Receipt',260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',44924.88,NULL,NULL,1,'2022-12-16 11:36:36','2022-12-16 11:36:36',NULL),(314,7986,40720,1516,3,261,'App\\Models\\Receipt',261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',5082.00,NULL,NULL,1,'2022-12-16 11:36:36','2022-12-16 11:36:36',NULL),(315,7986,40776,17351,3,262,'App\\Models\\Receipt',262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',1647.61,NULL,NULL,1,'2022-12-16 11:36:58','2022-12-16 11:36:58',NULL),(316,7986,40776,17351,3,263,'App\\Models\\Receipt',263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',400.00,NULL,NULL,1,'2022-12-16 11:36:58','2022-12-16 11:36:58',NULL),(317,7986,40776,17351,3,264,'App\\Models\\Receipt',264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',17974.55,NULL,NULL,1,'2022-12-16 11:36:58','2022-12-16 11:36:58',NULL),(318,7986,40776,17351,3,265,'App\\Models\\Receipt',265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',34943.42,NULL,NULL,1,'2022-12-16 11:36:58','2022-12-16 11:36:58',NULL),(319,7986,40776,17351,3,266,'App\\Models\\Receipt',266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',3500.00,NULL,NULL,1,'2022-12-16 11:36:58','2022-12-16 11:36:58',NULL),(320,7986,40776,17351,3,267,'App\\Models\\Receipt',267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',6957.02,NULL,NULL,1,'2022-12-16 11:36:58','2022-12-16 11:36:58',NULL),(321,7986,40776,17351,3,268,'App\\Models\\Receipt',268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',53900.00,NULL,NULL,1,'2022-12-16 11:36:58','2022-12-16 11:36:58',NULL),(322,7986,40759,8009,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',60301.51,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-20 12:31:27','2022-12-20 12:31:27'),(323,7986,40759,8009,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',75455.64,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-20 12:31:47','2022-12-20 12:31:47'),(324,7986,40759,8009,3,271,'App\\Models\\Receipt',271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',16607.92,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-21 08:54:39','2022-12-21 08:54:39'),(325,7986,40759,8009,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',5991.54,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-20 12:32:19','2022-12-20 12:32:19'),(326,7986,40759,8009,3,273,'App\\Models\\Receipt',273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',3164.72,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-16 12:21:46',NULL),(327,7986,40759,8009,3,274,'App\\Models\\Receipt',274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',1000.00,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-16 12:21:46',NULL),(328,7986,40759,8009,3,275,'App\\Models\\Receipt',275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',276.39,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-16 12:21:46',NULL),(329,7986,40759,8009,3,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',56341.62,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-20 12:32:45','2022-12-20 12:32:45'),(330,7986,40759,8009,3,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',9447.07,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-20 12:33:17','2022-12-20 12:33:17');
INSERT INTO `balance_libro` VALUES (331,7986,40759,8009,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',100570.44,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-20 12:33:38','2022-12-20 12:33:38'),(332,7986,40759,8009,3,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',6469.84,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-20 12:34:26','2022-12-20 12:34:26'),(333,7986,40759,8009,3,280,'App\\Models\\Receipt',280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3790.26,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-16 12:21:46',NULL),(334,7986,40759,8009,3,281,'App\\Models\\Receipt',281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',3240.91,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-16 12:21:46',NULL),(335,7986,40759,8009,3,282,'App\\Models\\Receipt',282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',270.80,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-16 12:21:46',NULL),(336,7986,40759,8009,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',29627.07,NULL,NULL,1,'2022-12-16 12:21:46','2022-12-20 12:34:45','2022-12-20 12:34:45'),(337,7986,40759,8009,3,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',65653.06,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-20 12:35:03','2022-12-20 12:35:03'),(338,7986,40759,8009,3,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',8857.59,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-20 12:35:43','2022-12-20 12:35:43'),(339,7986,40759,8009,3,286,'App\\Models\\Receipt',286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',2323.88,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-21 09:01:44','2022-12-21 09:01:44'),(340,7986,40759,8009,3,287,'App\\Models\\Receipt',287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',3120.57,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-16 12:21:47',NULL),(341,7986,40759,8009,3,288,'App\\Models\\Receipt',288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',262.82,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-16 12:21:47',NULL),(342,7986,40759,8009,3,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',88835.51,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-20 12:36:02','2022-12-20 12:36:02'),(343,7986,40759,8009,3,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',175756.78,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-20 12:36:24','2022-12-20 12:36:24'),(344,7986,40759,8009,3,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',8670.08,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-20 12:37:42','2022-12-20 12:37:42'),(345,7986,40759,8009,3,292,'App\\Models\\Receipt',292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',38269.29,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-16 12:21:47',NULL),(346,7986,40759,8009,3,293,'App\\Models\\Receipt',293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',6138.29,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-16 12:21:47',NULL),(347,7986,40759,8009,3,294,'App\\Models\\Receipt',294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',619.51,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-16 12:21:47',NULL),(348,7986,40759,8009,3,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',88385.49,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-20 12:38:00','2022-12-20 12:38:00'),(349,7986,40759,8009,3,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',11909.23,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-20 12:38:25','2022-12-20 12:38:25'),(350,7986,40759,8009,3,297,'App\\Models\\Receipt',297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',119934.75,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-16 12:21:47',NULL);
INSERT INTO `balance_libro` VALUES (351,7986,40759,8009,3,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',96309.38,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-20 12:38:40','2022-12-20 12:38:40'),(352,7986,40759,8009,3,299,'App\\Models\\Receipt',299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8265.00,NULL,NULL,1,'2022-12-16 12:21:47','2022-12-21 09:03:20','2022-12-21 09:03:20'),(353,7986,40759,8009,2,300,'App\\Models\\Receipt',300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',16070.00,NULL,NULL,1,'2022-12-20 12:29:08','2022-12-20 12:29:08',NULL),(354,7986,40759,8009,2,301,'App\\Models\\Receipt',301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',39950.00,NULL,NULL,1,'2022-12-20 12:29:08','2022-12-20 12:29:08',NULL),(355,7986,40759,8009,2,302,'App\\Models\\Receipt',302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',47350.00,NULL,NULL,1,'2022-12-20 12:29:08','2022-12-20 12:29:08',NULL),(356,7986,40759,8009,2,303,'App\\Models\\Receipt',303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-06','2022-11-06',37429.99,NULL,NULL,1,'2022-12-20 12:29:08','2022-12-20 12:29:08',NULL),(357,7986,40759,8009,2,304,'App\\Models\\Receipt',304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',47109.99,NULL,NULL,1,'2022-12-20 12:29:08','2022-12-20 12:29:08',NULL),(358,7986,40759,8009,2,305,'App\\Models\\Receipt',305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',25170.00,NULL,NULL,1,'2022-12-20 12:29:08','2022-12-20 12:29:08',NULL),(359,7986,40759,8009,2,306,'App\\Models\\Receipt',306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',30190.00,NULL,NULL,1,'2022-12-20 12:29:08','2022-12-20 12:29:08',NULL),(360,7986,40759,8009,2,307,'App\\Models\\Receipt',307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',25320.00,NULL,NULL,1,'2022-12-20 12:29:08','2022-12-20 12:29:08',NULL),(361,7986,40759,8009,2,308,'App\\Models\\Receipt',308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',40060.00,NULL,NULL,1,'2022-12-20 12:29:09','2022-12-20 12:29:09',NULL),(362,7986,40759,8009,2,309,'App\\Models\\Receipt',309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',33560.00,NULL,NULL,1,'2022-12-20 12:29:09','2022-12-20 12:29:09',NULL),(363,7986,40759,8009,2,310,'App\\Models\\Receipt',310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',33130.01,NULL,NULL,1,'2022-12-20 12:29:09','2022-12-20 12:29:09',NULL),(364,7986,40759,8009,2,311,'App\\Models\\Receipt',311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',39340.00,NULL,NULL,1,'2022-12-20 12:29:09','2022-12-20 12:29:09',NULL),(365,7986,40759,8009,2,312,'App\\Models\\Receipt',312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-20','2022-11-20',53840.00,NULL,NULL,1,'2022-12-20 12:29:09','2022-12-20 12:29:09',NULL),(366,7986,40759,8009,2,313,'App\\Models\\Receipt',313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',22750.00,NULL,NULL,1,'2022-12-20 12:29:09','2022-12-20 12:29:09',NULL),(367,7986,40759,8009,2,314,'App\\Models\\Receipt',314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',34380.00,NULL,NULL,1,'2022-12-20 12:29:09','2022-12-20 12:29:09',NULL),(368,7986,40759,8009,2,315,'App\\Models\\Receipt',315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',33310.01,NULL,NULL,1,'2022-12-20 12:29:09','2022-12-20 12:29:09',NULL),(369,7986,40759,8009,2,316,'App\\Models\\Receipt',316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',31850.00,NULL,NULL,1,'2022-12-20 12:29:09','2022-12-20 12:29:09',NULL),(370,7986,40759,8009,2,317,'App\\Models\\Receipt',317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-27','2022-11-27',39480.00,NULL,NULL,1,'2022-12-20 12:29:09','2022-12-20 12:29:09',NULL),(371,7986,40759,8009,2,318,'App\\Models\\Receipt',318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',58980.00,NULL,NULL,1,'2022-12-20 12:29:09','2022-12-20 12:29:09',NULL);
INSERT INTO `balance_libro` VALUES (372,7986,40759,8009,2,319,'App\\Models\\Receipt',319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',46850.00,NULL,NULL,1,'2022-12-20 12:29:09','2022-12-20 12:29:09',NULL),(373,7986,40759,8009,3,269,'App\\Models\\Receipt',269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',60301.51,NULL,NULL,1,'2022-12-20 12:31:27','2022-12-20 12:31:27',NULL),(374,7986,40759,8009,3,270,'App\\Models\\Receipt',270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',75455.64,NULL,NULL,1,'2022-12-20 12:31:47','2022-12-20 12:31:47',NULL),(375,7986,40759,8009,3,272,'App\\Models\\Receipt',272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',5991.54,NULL,NULL,1,'2022-12-20 12:32:19','2022-12-20 12:32:19',NULL),(376,7986,40759,8009,3,276,'App\\Models\\Receipt',276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',56341.62,NULL,NULL,1,'2022-12-20 12:32:45','2022-12-20 12:32:45',NULL),(377,7986,40759,8009,3,277,'App\\Models\\Receipt',277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',9447.07,NULL,NULL,1,'2022-12-20 12:33:17','2022-12-20 12:33:17',NULL),(378,7986,40759,8009,3,278,'App\\Models\\Receipt',278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',100570.44,NULL,NULL,1,'2022-12-20 12:33:38','2022-12-20 12:33:38',NULL),(379,7986,40759,8009,3,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',6425.72,NULL,NULL,1,'2022-12-20 12:34:26','2022-12-21 09:00:45','2022-12-21 09:00:45'),(380,7986,40759,8009,3,283,'App\\Models\\Receipt',283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',29627.07,NULL,NULL,1,'2022-12-20 12:34:45','2022-12-20 12:34:45',NULL),(381,7986,40759,8009,3,284,'App\\Models\\Receipt',284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',65653.06,NULL,NULL,1,'2022-12-20 12:35:03','2022-12-20 12:35:03',NULL),(382,7986,40759,8009,3,285,'App\\Models\\Receipt',285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',8857.59,NULL,NULL,1,'2022-12-20 12:35:43','2022-12-20 12:35:43',NULL),(383,7986,40759,8009,3,289,'App\\Models\\Receipt',289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',88835.51,NULL,NULL,1,'2022-12-20 12:36:02','2022-12-20 12:36:02',NULL),(384,7986,40759,8009,3,290,'App\\Models\\Receipt',290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',175756.78,NULL,NULL,1,'2022-12-20 12:36:24','2022-12-20 12:36:24',NULL),(385,7986,40759,8009,3,291,'App\\Models\\Receipt',291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',8670.08,NULL,NULL,1,'2022-12-20 12:37:42','2022-12-20 12:37:42',NULL),(386,7986,40759,8009,3,295,'App\\Models\\Receipt',295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',88385.49,NULL,NULL,1,'2022-12-20 12:38:00','2022-12-20 12:38:00',NULL),(387,7986,40759,8009,3,296,'App\\Models\\Receipt',296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',11909.23,NULL,NULL,1,'2022-12-20 12:38:25','2022-12-20 12:38:25',NULL),(388,7986,40759,8009,3,298,'App\\Models\\Receipt',298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',96309.39,NULL,NULL,1,'2022-12-20 12:38:40','2022-12-20 12:38:40',NULL),(389,7986,40759,8009,3,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11744.94,NULL,NULL,1,'2022-12-20 12:43:01','2022-12-20 12:44:26','2022-12-20 12:44:26'),(390,7986,40759,8009,3,320,'App\\Models\\Receipt',320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',8609.46,NULL,NULL,1,'2022-12-20 12:44:26','2022-12-20 12:44:26',NULL),(391,7986,40759,8009,8,321,'App\\Models\\Receipt',321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3135.48,NULL,NULL,1,'2022-12-20 12:44:42','2022-12-20 12:44:42',NULL),(392,7986,40759,8009,3,279,'App\\Models\\Receipt',279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',6469.84,NULL,NULL,1,'2022-12-21 09:00:45','2022-12-21 09:00:45',NULL);
INSERT INTO `balance_libro` VALUES (393,7986,40759,8008,3,322,'App\\Models\\Receipt',322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',61573.73,NULL,NULL,1,'2022-12-21 09:13:06','2022-12-21 09:13:06',NULL),(394,7986,40759,8008,3,323,'App\\Models\\Receipt',323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-04','2022-10-04',77971.23,NULL,NULL,1,'2022-12-21 09:14:13','2022-12-21 09:14:13',NULL),(395,7986,40759,8008,3,324,'App\\Models\\Receipt',324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',1000.00,NULL,NULL,1,'2022-12-21 09:14:54','2022-12-21 09:14:54',NULL),(396,7986,40759,8008,3,325,'App\\Models\\Receipt',325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-10','2022-10-10',320.98,NULL,NULL,1,'2022-12-21 09:16:11','2022-12-21 09:16:11',NULL),(397,7986,40720,1516,3,326,'App\\Models\\Receipt',326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-07','2022-10-07',1850.00,NULL,NULL,1,'2022-12-21 10:23:15','2022-12-21 10:23:15',NULL),(398,7986,40720,1516,3,327,'App\\Models\\Receipt',327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',19370.00,NULL,NULL,1,'2022-12-21 10:24:18','2022-12-21 10:24:18',NULL),(399,7986,40720,1516,3,328,'App\\Models\\Receipt',328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',3006.83,NULL,NULL,1,'2022-12-21 10:25:25','2022-12-21 10:25:25',NULL),(400,7986,40720,1516,3,329,'App\\Models\\Receipt',329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',8305.93,NULL,NULL,1,'2022-12-21 10:26:02','2022-12-21 10:26:02',NULL),(401,7986,40720,1516,3,330,'App\\Models\\Receipt',330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',9650.54,NULL,NULL,1,'2022-12-21 10:26:51','2022-12-21 10:26:51',NULL),(402,7986,40776,17351,3,331,'App\\Models\\Receipt',331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',97850.00,NULL,NULL,1,'2022-12-22 11:52:51','2022-12-22 11:52:51',NULL),(403,7986,40776,17351,3,332,'App\\Models\\Receipt',332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',6999.99,NULL,NULL,1,'2022-12-22 11:55:06','2022-12-22 11:55:06',NULL),(404,7986,40776,17351,3,333,'App\\Models\\Receipt',333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',4700.00,NULL,NULL,1,'2022-12-22 11:56:32','2022-12-22 11:56:32',NULL),(405,7986,40776,17351,3,334,'App\\Models\\Receipt',334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',7002.02,NULL,NULL,1,'2022-12-22 11:57:47','2022-12-22 11:57:47',NULL),(406,7986,40776,17351,3,335,'App\\Models\\Receipt',335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',6999.94,NULL,NULL,1,'2022-12-22 11:58:24','2022-12-22 11:58:24',NULL),(407,7986,40776,17351,3,336,'App\\Models\\Receipt',336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',35000.13,NULL,NULL,1,'2022-12-22 11:59:34','2022-12-22 11:59:34',NULL),(408,7986,40776,17351,3,337,'App\\Models\\Receipt',337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',194.01,NULL,NULL,1,'2022-12-22 12:01:32','2022-12-22 12:01:32',NULL),(409,7986,40776,17351,3,338,'App\\Models\\Receipt',338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',25792.25,NULL,NULL,1,'2022-12-22 12:02:23','2022-12-22 12:02:23',NULL),(410,7986,40759,8008,15,265,'App\\Models\\PeriodLiquidation',NULL,265,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',127707.23,NULL,NULL,1,'2022-12-23 10:30:30','2022-12-23 10:30:30',NULL),(411,7986,40759,8009,16,353,'App\\Models\\PeriodLiquidation',NULL,353,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',22012.21,NULL,NULL,1,'2022-12-23 10:30:37','2022-12-23 10:30:37',NULL),(412,7986,40759,8009,15,268,'App\\Models\\PeriodLiquidation',NULL,268,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',310946.34,NULL,NULL,1,'2022-12-23 10:31:21','2022-12-23 10:31:21',NULL),(413,7986,40720,1516,15,279,'App\\Models\\PeriodLiquidation',NULL,279,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',162089.18,NULL,NULL,1,'2022-12-23 10:35:46','2022-12-23 10:35:46',NULL);
INSERT INTO `balance_libro` VALUES (414,7986,40720,1516,16,354,'App\\Models\\PeriodLiquidation',NULL,354,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',592.00,NULL,NULL,1,'2022-12-23 10:35:56','2022-12-23 10:35:56',NULL),(415,7986,40776,17351,15,290,'App\\Models\\PeriodLiquidation',NULL,290,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',814673.12,NULL,NULL,1,'2022-12-23 10:38:22','2022-12-23 10:38:22',NULL),(416,7986,40776,17350,15,281,'App\\Models\\PeriodLiquidation',NULL,281,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',589502.70,NULL,NULL,1,'2022-12-23 10:38:31','2023-08-24 11:28:55','2023-08-24 11:28:55'),(417,7986,40721,3015,3,339,'App\\Models\\Receipt',339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',64937.22,NULL,NULL,1,'2022-12-23 11:03:35','2022-12-23 11:03:35',NULL),(418,7986,40721,4673,15,180,'App\\Models\\PeriodLiquidation',NULL,180,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',114316.63,NULL,NULL,1,'2022-12-23 11:04:21','2022-12-23 11:59:29','2022-12-23 11:59:29'),(419,7986,40721,4674,15,191,'App\\Models\\PeriodLiquidation',NULL,191,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',395084.54,NULL,NULL,1,'2022-12-23 11:05:34','2022-12-23 11:59:22','2022-12-23 11:59:22'),(420,7986,40721,3015,3,340,'App\\Models\\Receipt',340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-05','2022-10-05',4220.24,NULL,NULL,1,'2022-12-23 11:11:32','2022-12-23 11:11:32',NULL),(421,7986,40721,3015,3,341,'App\\Models\\Receipt',341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',28739.24,NULL,NULL,1,'2022-12-23 11:12:35','2022-12-23 11:12:35',NULL),(422,7986,40721,3015,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',35926.54,NULL,NULL,1,'2022-12-23 11:17:06','2022-12-23 11:20:41','2022-12-23 11:20:41'),(423,7986,40721,3015,3,343,'App\\Models\\Receipt',343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',5759.15,NULL,NULL,1,'2022-12-23 11:18:06','2022-12-23 11:18:06',NULL),(424,7986,40721,3015,3,344,'App\\Models\\Receipt',344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6820.53,NULL,NULL,1,'2022-12-23 11:19:06','2022-12-23 11:19:06',NULL),(425,7986,40721,3015,3,345,'App\\Models\\Receipt',345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1613.79,NULL,NULL,1,'2022-12-23 11:19:44','2022-12-23 11:19:44',NULL),(426,7986,40721,3015,3,346,'App\\Models\\Receipt',346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1208.89,NULL,NULL,1,'2022-12-23 11:20:06','2022-12-23 11:20:06',NULL),(427,7986,40721,3015,3,347,'App\\Models\\Receipt',347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3211.95,NULL,NULL,1,'2022-12-23 11:20:27','2022-12-23 11:20:27',NULL),(428,7986,40721,3015,3,342,'App\\Models\\Receipt',342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',35926.54,NULL,NULL,1,'2022-12-23 11:20:41','2022-12-23 11:20:41',NULL),(429,7986,40721,3015,8,348,'App\\Models\\Receipt',348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',12618.95,NULL,NULL,1,'2022-12-23 11:22:34','2022-12-23 11:22:34',NULL),(430,7986,40721,3015,8,349,'App\\Models\\Receipt',349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',0.00,NULL,NULL,1,'2022-12-23 11:22:38','2022-12-23 11:23:04','2022-12-23 11:23:04'),(431,7986,40721,3015,8,350,'App\\Models\\Receipt',350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1292.21,NULL,NULL,1,'2022-12-23 11:22:55','2022-12-23 11:22:55',NULL),(432,7986,40721,3015,3,351,'App\\Models\\Receipt',351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',21440.15,NULL,NULL,1,'2022-12-23 11:29:36','2022-12-23 11:29:36',NULL),(433,7986,40721,3015,3,352,'App\\Models\\Receipt',352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',18628.57,NULL,NULL,1,'2022-12-23 11:32:00','2022-12-23 11:32:00',NULL);
INSERT INTO `balance_libro` VALUES (434,7986,40721,3015,3,353,'App\\Models\\Receipt',353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',2028.79,NULL,NULL,1,'2022-12-23 11:32:29','2022-12-23 11:32:29',NULL),(435,7986,40721,3015,3,177,'App\\Models\\Receipt',177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',439848.24,NULL,NULL,1,'2022-12-23 11:37:03','2022-12-23 11:37:03',NULL),(436,7986,40721,3015,3,178,'App\\Models\\Receipt',178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',5215.88,NULL,NULL,1,'2022-12-23 11:37:23','2022-12-23 11:37:23',NULL),(437,7986,40721,3015,3,181,'App\\Models\\Receipt',181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-05','2022-11-05',270316.64,NULL,NULL,1,'2022-12-23 11:37:57','2022-12-23 11:37:57',NULL),(438,7986,40721,3015,3,187,'App\\Models\\Receipt',187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',64652.95,NULL,NULL,1,'2022-12-23 11:38:36','2022-12-23 11:38:36',NULL),(439,7986,40721,3015,3,193,'App\\Models\\Receipt',193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',20744.66,NULL,NULL,1,'2022-12-23 11:39:05','2022-12-23 11:39:05',NULL),(440,7986,40721,3015,3,194,'App\\Models\\Receipt',194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',1553.41,NULL,NULL,1,'2022-12-23 11:39:52','2022-12-23 11:39:52',NULL),(441,7986,40721,3015,3,200,'App\\Models\\Receipt',200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',13851.38,NULL,NULL,1,'2022-12-23 11:40:45','2022-12-23 11:40:45',NULL),(442,7986,40721,3015,3,203,'App\\Models\\Receipt',203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-12','2022-11-12',20928.10,NULL,NULL,1,'2022-12-23 11:41:41','2022-12-23 11:41:41',NULL),(443,7986,40721,3015,3,205,'App\\Models\\Receipt',205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',5307.44,NULL,NULL,1,'2022-12-23 11:42:00','2022-12-23 11:42:00',NULL),(444,7986,40721,3015,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',45437.20,NULL,NULL,1,'2022-12-23 11:42:26','2022-12-28 10:17:14','2022-12-28 10:17:14'),(445,7986,40721,3015,3,216,'App\\Models\\Receipt',216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',4291.54,NULL,NULL,1,'2022-12-23 11:42:49','2022-12-23 11:42:49',NULL),(446,7986,40721,3015,3,220,'App\\Models\\Receipt',220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',9703.38,NULL,NULL,1,'2022-12-23 11:43:06','2022-12-23 11:43:06',NULL),(447,7986,40721,3015,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',41522.64,NULL,NULL,1,'2022-12-23 11:43:27','2022-12-28 10:08:16','2022-12-28 10:08:16'),(448,7986,40721,3015,3,223,'App\\Models\\Receipt',223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-21','2022-11-21',34235.48,NULL,NULL,1,'2022-12-23 11:46:59','2022-12-23 11:46:59',NULL),(449,7986,40721,3015,3,228,'App\\Models\\Receipt',228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',4302.06,NULL,NULL,1,'2022-12-23 11:47:40','2022-12-23 11:47:40',NULL),(450,7986,40721,3015,3,235,'App\\Models\\Receipt',235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',6013.08,NULL,NULL,1,'2022-12-23 11:48:15','2022-12-23 11:48:15',NULL),(451,7986,40721,3015,3,239,'App\\Models\\Receipt',239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',237055.57,NULL,NULL,1,'2022-12-23 11:48:36','2022-12-23 11:48:36',NULL),(452,7986,40721,3015,3,238,'App\\Models\\Receipt',238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',36497.49,NULL,NULL,1,'2022-12-23 11:49:08','2022-12-23 11:49:08',NULL),(453,7986,40721,3015,3,242,'App\\Models\\Receipt',242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',29351.19,NULL,NULL,1,'2022-12-23 11:49:52','2022-12-23 11:49:52',NULL),(454,7986,40721,3015,3,256,'App\\Models\\Receipt',256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1544.34,NULL,NULL,1,'2022-12-23 11:50:14','2022-12-23 11:50:14',NULL);
INSERT INTO `balance_libro` VALUES (455,7986,40721,3015,7,354,'App\\Models\\Receipt',354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',0.75,NULL,NULL,1,'2022-12-27 12:21:45','2022-12-27 12:21:45',NULL),(456,7986,40721,3015,7,355,'App\\Models\\Receipt',355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',2.97,NULL,NULL,1,'2022-12-27 12:21:45','2022-12-27 12:21:45',NULL),(457,7986,40721,3015,7,356,'App\\Models\\Receipt',356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',3.83,NULL,NULL,1,'2022-12-27 12:21:45','2022-12-27 12:21:45',NULL),(458,7986,40721,3015,7,357,'App\\Models\\Receipt',357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',4.15,NULL,NULL,1,'2022-12-27 12:21:45','2022-12-27 12:21:45',NULL),(459,7986,40721,3015,7,358,'App\\Models\\Receipt',358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',6.00,NULL,NULL,1,'2022-12-27 12:21:45','2022-12-27 12:21:45',NULL),(460,7986,40721,3015,7,359,'App\\Models\\Receipt',359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',8.87,NULL,NULL,1,'2022-12-27 12:21:45','2022-12-27 12:21:45',NULL),(461,7986,40721,3015,7,360,'App\\Models\\Receipt',360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',9.98,NULL,NULL,1,'2022-12-27 12:21:45','2022-12-27 12:21:45',NULL),(462,7986,40721,3015,7,361,'App\\Models\\Receipt',361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',12.90,NULL,NULL,1,'2022-12-27 12:21:45','2022-12-27 12:21:45',NULL),(463,7986,40721,3015,7,362,'App\\Models\\Receipt',362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',15.25,NULL,NULL,1,'2022-12-27 12:21:45','2022-12-27 12:21:45',NULL),(464,7986,40721,3015,7,363,'App\\Models\\Receipt',363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',15.27,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(465,7986,40721,3015,7,364,'App\\Models\\Receipt',364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',15.55,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(466,7986,40721,3015,7,365,'App\\Models\\Receipt',365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',17.48,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(467,7986,40721,3015,7,366,'App\\Models\\Receipt',366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',17.56,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(468,7986,40721,3015,7,367,'App\\Models\\Receipt',367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',17.60,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(469,7986,40721,3015,7,368,'App\\Models\\Receipt',368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',19.53,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(470,7986,40721,3015,7,369,'App\\Models\\Receipt',369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',19.59,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(471,7986,40721,3015,7,370,'App\\Models\\Receipt',370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',19.87,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(472,7986,40721,3015,7,371,'App\\Models\\Receipt',371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',20.28,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(473,7986,40721,3015,7,372,'App\\Models\\Receipt',372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',21.68,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(474,7986,40721,3015,7,373,'App\\Models\\Receipt',373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',22.30,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(475,7986,40721,3015,7,374,'App\\Models\\Receipt',374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',24.58,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL);
INSERT INTO `balance_libro` VALUES (476,7986,40721,3015,7,375,'App\\Models\\Receipt',375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',25.64,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(477,7986,40721,3015,7,376,'App\\Models\\Receipt',376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',25.89,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(478,7986,40721,3015,7,377,'App\\Models\\Receipt',377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',25.95,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(479,7986,40721,3015,7,378,'App\\Models\\Receipt',378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',27.22,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(480,7986,40721,3015,7,379,'App\\Models\\Receipt',379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',28.87,NULL,NULL,1,'2022-12-27 12:21:46','2022-12-27 12:21:46',NULL),(481,7986,40721,3015,7,380,'App\\Models\\Receipt',380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',30.00,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(482,7986,40721,3015,7,381,'App\\Models\\Receipt',381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',30.50,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(483,7986,40721,3015,7,382,'App\\Models\\Receipt',382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',31.81,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(484,7986,40721,3015,7,383,'App\\Models\\Receipt',383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',32.50,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(485,7986,40721,3015,7,384,'App\\Models\\Receipt',384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',36.56,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(486,7986,40721,3015,7,385,'App\\Models\\Receipt',385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',36.72,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(487,7986,40721,3015,7,386,'App\\Models\\Receipt',386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',36.79,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(488,7986,40721,3015,7,387,'App\\Models\\Receipt',387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',37.41,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(489,7986,40721,3015,7,388,'App\\Models\\Receipt',388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-28','2022-11-28',43.55,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(490,7986,40721,3015,7,389,'App\\Models\\Receipt',389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',45.56,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(491,7986,40721,3015,7,390,'App\\Models\\Receipt',390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',49.56,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(492,7986,40721,3015,7,391,'App\\Models\\Receipt',391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',52.50,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(493,7986,40721,3015,7,392,'App\\Models\\Receipt',392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',52.85,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(494,7986,40721,3015,7,393,'App\\Models\\Receipt',393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',55.66,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(495,7986,40721,3015,7,394,'App\\Models\\Receipt',394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-17','2022-11-17',58.21,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(496,7986,40721,3015,7,395,'App\\Models\\Receipt',395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',61.34,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL);
INSERT INTO `balance_libro` VALUES (497,7986,40721,3015,7,396,'App\\Models\\Receipt',396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',66.40,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(498,7986,40721,3015,7,397,'App\\Models\\Receipt',397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',67.37,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(499,7986,40721,3015,7,398,'App\\Models\\Receipt',398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',67.44,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(500,7986,40721,3015,7,399,'App\\Models\\Receipt',399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',68.26,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(501,7986,40721,3015,7,400,'App\\Models\\Receipt',400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',72.85,NULL,NULL,1,'2022-12-27 12:21:47','2022-12-27 12:21:47',NULL),(502,7986,40721,3015,7,401,'App\\Models\\Receipt',401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-02','2022-11-02',74.44,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(503,7986,40721,3015,7,402,'App\\Models\\Receipt',402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',76.29,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(504,7986,40721,3015,7,403,'App\\Models\\Receipt',403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',80.00,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(505,7986,40721,3015,7,404,'App\\Models\\Receipt',404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-25','2022-11-25',81.34,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(506,7986,40721,3015,7,405,'App\\Models\\Receipt',405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',86.55,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(507,7986,40721,3015,7,406,'App\\Models\\Receipt',406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-11','2022-11-11',88.21,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(508,7986,40721,3015,7,407,'App\\Models\\Receipt',407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-14','2022-11-14',89.66,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(509,7986,40721,3015,7,408,'App\\Models\\Receipt',408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',93.20,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(510,7986,40721,3015,7,409,'App\\Models\\Receipt',409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',100.42,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(511,7986,40721,3015,7,410,'App\\Models\\Receipt',410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',108.68,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(512,7986,40721,3015,7,411,'App\\Models\\Receipt',411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-24','2022-11-24',112.90,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(513,7986,40721,3015,7,412,'App\\Models\\Receipt',412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',132.81,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(514,7986,40721,3015,7,413,'App\\Models\\Receipt',413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',153.32,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(515,7986,40721,3015,7,414,'App\\Models\\Receipt',414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-01','2022-11-01',156.54,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(516,7986,40721,3015,7,415,'App\\Models\\Receipt',415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-22','2022-11-22',161.08,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(517,7986,40721,3015,7,416,'App\\Models\\Receipt',416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',173.10,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL);
INSERT INTO `balance_libro` VALUES (518,7986,40721,3015,7,417,'App\\Models\\Receipt',417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',178.12,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(519,7986,40721,3015,7,418,'App\\Models\\Receipt',418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',178.40,NULL,NULL,1,'2022-12-27 12:21:48','2022-12-27 12:21:48',NULL),(520,7986,40721,3015,7,419,'App\\Models\\Receipt',419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',195.80,NULL,NULL,1,'2022-12-27 12:21:49','2022-12-27 12:21:49',NULL),(521,7986,40721,3015,7,420,'App\\Models\\Receipt',420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',203.90,NULL,NULL,1,'2022-12-27 12:21:49','2022-12-27 12:21:49',NULL),(522,7986,40721,3015,7,421,'App\\Models\\Receipt',421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-10','2022-11-10',218.85,NULL,NULL,1,'2022-12-27 12:21:49','2022-12-27 12:21:49',NULL),(523,7986,40721,3015,7,422,'App\\Models\\Receipt',422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-09','2022-11-09',257.45,NULL,NULL,1,'2022-12-27 12:21:49','2022-12-27 12:21:49',NULL),(524,7986,40721,3015,7,423,'App\\Models\\Receipt',423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',284.25,NULL,NULL,1,'2022-12-27 12:21:49','2022-12-27 12:21:49',NULL),(525,7986,40721,3015,7,424,'App\\Models\\Receipt',424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-29','2022-11-29',293.80,NULL,NULL,1,'2022-12-27 12:21:49','2022-12-27 12:21:49',NULL),(526,7986,40721,3015,7,425,'App\\Models\\Receipt',425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-08','2022-11-08',311.63,NULL,NULL,1,'2022-12-27 12:21:49','2022-12-27 12:21:49',NULL),(527,7986,40721,3015,7,426,'App\\Models\\Receipt',426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-15','2022-11-15',326.59,NULL,NULL,1,'2022-12-27 12:21:49','2022-12-27 12:21:49',NULL),(528,7986,40721,3015,7,427,'App\\Models\\Receipt',427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-23','2022-11-23',456.76,NULL,NULL,1,'2022-12-27 12:21:49','2022-12-27 12:21:49',NULL),(529,7986,40721,4673,15,449,'App\\Models\\PeriodLiquidation',NULL,449,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',114316.60,NULL,NULL,1,'2022-12-27 12:30:34','2022-12-27 12:30:34',NULL),(530,7986,40721,4674,15,450,'App\\Models\\PeriodLiquidation',NULL,450,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',395084.51,NULL,NULL,1,'2022-12-27 12:30:53','2022-12-27 12:30:53',NULL),(531,7986,40721,3015,15,454,'App\\Models\\PeriodLiquidation',NULL,454,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',346155.90,NULL,NULL,1,'2022-12-27 12:31:12','2022-12-28 09:23:05','2022-12-28 09:23:05'),(532,7986,40721,3015,7,428,'App\\Models\\Receipt',428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-03','2022-11-03',108.68,NULL,NULL,1,'2022-12-28 09:27:35','2022-12-28 10:03:54','2022-12-28 10:03:54'),(533,7986,40721,3015,7,429,'App\\Models\\Receipt',429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',93.20,NULL,NULL,1,'2022-12-28 09:28:07','2022-12-28 10:03:47','2022-12-28 10:03:47'),(534,7986,40721,3015,7,430,'App\\Models\\Receipt',430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-07','2022-11-07',203.90,NULL,NULL,1,'2022-12-28 09:28:28','2022-12-28 10:03:40','2022-12-28 10:03:40'),(535,7986,40721,3015,3,221,'App\\Models\\Receipt',221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-19','2022-11-19',41522.64,NULL,NULL,1,'2022-12-28 10:08:16','2022-12-28 10:08:16',NULL),(536,7986,40721,3015,3,212,'App\\Models\\Receipt',212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-16','2022-11-16',45137.20,NULL,NULL,1,'2022-12-28 10:17:14','2022-12-28 10:17:14',NULL),(537,7986,40721,3015,15,472,'App\\Models\\PeriodLiquidation',NULL,472,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',346155.90,NULL,NULL,1,'2022-12-28 10:18:00','2022-12-28 10:18:00',NULL);
INSERT INTO `balance_libro` VALUES (538,7986,40721,3015,16,474,'App\\Models\\PeriodLiquidation',NULL,474,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',494625.17,NULL,NULL,1,'2022-12-30 10:12:55','2022-12-30 10:12:55',NULL),(539,7986,40759,8010,2,431,'App\\Models\\Receipt',431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1.21,NULL,NULL,1,'2023-01-11 12:09:38','2023-01-11 12:09:38',NULL),(540,7986,40759,8010,2,432,'App\\Models\\Receipt',432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1500.00,NULL,NULL,1,'2023-01-11 12:09:38','2023-01-11 12:09:38',NULL),(541,7986,40759,8010,2,433,'App\\Models\\Receipt',433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1.21,NULL,NULL,1,'2023-01-11 12:09:39','2023-01-11 12:09:39',NULL),(542,7986,40759,8010,2,434,'App\\Models\\Receipt',434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1.21,NULL,NULL,1,'2023-01-11 12:09:39','2023-01-11 12:09:39',NULL),(543,7986,40759,8010,2,435,'App\\Models\\Receipt',435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1.21,NULL,NULL,1,'2023-01-11 12:09:39','2023-01-11 12:09:39',NULL),(544,7986,40759,8010,2,436,'App\\Models\\Receipt',436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1.21,NULL,NULL,1,'2023-01-11 12:09:39','2023-01-11 12:09:39',NULL),(545,7986,40759,8010,2,437,'App\\Models\\Receipt',437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1.21,NULL,NULL,1,'2023-01-11 12:09:39','2023-01-11 12:09:39',NULL),(546,7986,40759,8010,2,438,'App\\Models\\Receipt',438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1.21,NULL,NULL,1,'2023-01-11 12:09:39','2023-01-11 12:09:39',NULL),(547,7986,40759,8010,2,439,'App\\Models\\Receipt',439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1.21,NULL,NULL,1,'2023-01-11 12:09:39','2023-01-11 12:09:39',NULL),(548,7986,40759,8010,2,440,'App\\Models\\Receipt',440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',200.00,NULL,NULL,1,'2023-01-11 12:09:39','2023-01-11 12:09:39',NULL),(549,7986,40759,8010,2,441,'App\\Models\\Receipt',441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',1500.00,NULL,NULL,1,'2023-01-11 12:09:39','2023-01-11 12:09:39',NULL),(550,7986,40759,8010,2,442,'App\\Models\\Receipt',442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',500.00,NULL,NULL,1,'2023-01-11 12:09:39','2023-01-11 12:09:39',NULL),(551,7986,40759,8010,2,443,'App\\Models\\Receipt',443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',300.00,NULL,NULL,1,'2023-01-11 12:09:39','2023-01-11 12:09:39',NULL),(552,7986,40759,8010,2,444,'App\\Models\\Receipt',444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',500.00,NULL,NULL,1,'2023-01-11 12:09:39','2023-01-11 12:09:39',NULL),(553,7986,40759,8010,2,445,'App\\Models\\Receipt',445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',800.00,NULL,NULL,1,'2023-01-11 12:09:39','2023-01-11 12:09:39',NULL),(554,7986,40759,8010,2,446,'App\\Models\\Receipt',446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',300.00,NULL,NULL,1,'2023-01-11 12:09:40','2023-01-11 12:09:40',NULL),(555,7986,40759,8010,2,447,'App\\Models\\Receipt',447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',600.00,NULL,NULL,1,'2023-01-11 12:09:40','2023-01-11 12:09:40',NULL),(556,7986,40759,8010,2,448,'App\\Models\\Receipt',448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',700.01,NULL,NULL,1,'2023-01-11 12:09:40','2023-01-11 12:09:40',NULL),(557,7986,40759,8010,2,449,'App\\Models\\Receipt',449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1700.00,NULL,NULL,1,'2023-01-11 12:09:40','2023-01-11 12:09:40',NULL),(558,7986,40759,8010,2,450,'App\\Models\\Receipt',450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',300.00,NULL,NULL,1,'2023-01-11 12:09:40','2023-01-11 12:09:40',NULL);
INSERT INTO `balance_libro` VALUES (559,7986,40759,8010,2,451,'App\\Models\\Receipt',451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',800.00,NULL,NULL,1,'2023-01-11 12:09:40','2023-01-11 12:09:40',NULL),(560,7986,40759,8010,2,452,'App\\Models\\Receipt',452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',800.00,NULL,NULL,1,'2023-01-11 12:09:40','2023-01-11 12:09:40',NULL),(561,7986,40759,8010,2,453,'App\\Models\\Receipt',453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',800.00,NULL,NULL,1,'2023-01-11 12:09:40','2023-01-11 12:09:40',NULL),(562,7986,40759,8010,2,454,'App\\Models\\Receipt',454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1399.99,NULL,NULL,1,'2023-01-11 12:09:40','2023-01-11 12:09:40',NULL),(563,7986,40759,8010,2,455,'App\\Models\\Receipt',455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1530.01,NULL,NULL,1,'2023-01-11 12:09:40','2023-01-11 12:09:40',NULL),(564,7986,40759,8010,2,456,'App\\Models\\Receipt',456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',80.01,NULL,NULL,1,'2023-01-11 12:09:40','2023-01-11 12:09:40',NULL),(565,7986,40759,8010,2,457,'App\\Models\\Receipt',457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1200.01,NULL,NULL,1,'2023-01-11 12:09:40','2023-01-11 12:09:40',NULL),(566,7986,40759,8010,2,458,'App\\Models\\Receipt',458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1600.00,NULL,NULL,1,'2023-01-11 12:09:41','2023-01-11 12:09:41',NULL),(567,7986,40759,8010,2,459,'App\\Models\\Receipt',459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',800.00,NULL,NULL,1,'2023-01-11 12:09:41','2023-01-11 12:09:41',NULL),(568,7986,40759,8010,2,460,'App\\Models\\Receipt',460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',1250.00,NULL,NULL,1,'2023-01-11 12:09:41','2023-01-11 12:09:41',NULL),(569,7986,40759,8010,2,461,'App\\Models\\Receipt',461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',400.00,NULL,NULL,1,'2023-01-11 12:09:41','2023-01-11 12:09:41',NULL),(570,7986,40759,8010,2,462,'App\\Models\\Receipt',462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',600.00,NULL,NULL,1,'2023-01-11 12:09:41','2023-01-11 12:09:41',NULL),(571,7986,40759,8010,2,463,'App\\Models\\Receipt',463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',900.00,NULL,NULL,1,'2023-01-11 12:09:41','2023-01-11 12:09:41',NULL),(572,7986,40759,8010,2,464,'App\\Models\\Receipt',464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',600.00,NULL,NULL,1,'2023-01-11 12:09:41','2023-01-11 12:09:41',NULL),(573,7986,40759,8010,2,465,'App\\Models\\Receipt',465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',2500.01,NULL,NULL,1,'2023-01-11 12:09:41','2023-01-11 12:09:41',NULL),(574,7986,40759,8010,2,466,'App\\Models\\Receipt',466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',850.00,NULL,NULL,1,'2023-01-11 12:09:41','2023-01-11 12:09:41',NULL),(575,7986,40759,8010,2,467,'App\\Models\\Receipt',467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1300.00,NULL,NULL,1,'2023-01-11 12:09:41','2023-01-11 12:09:41',NULL),(576,7986,40759,8010,2,468,'App\\Models\\Receipt',468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',700.00,NULL,NULL,1,'2023-01-11 12:09:41','2023-01-11 12:09:41',NULL),(577,7986,40759,8010,2,469,'App\\Models\\Receipt',469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1399.99,NULL,NULL,1,'2023-01-11 12:09:41','2023-01-11 12:09:41',NULL),(578,7986,40759,8010,2,470,'App\\Models\\Receipt',470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',800.00,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(579,7986,40759,8010,2,471,'App\\Models\\Receipt',471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1200.01,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL);
INSERT INTO `balance_libro` VALUES (580,7986,40759,8010,2,472,'App\\Models\\Receipt',472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1399.99,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(581,7986,40759,8010,2,473,'App\\Models\\Receipt',473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1499.99,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(582,7986,40759,8010,2,474,'App\\Models\\Receipt',474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',500.00,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(583,7986,40759,8010,2,475,'App\\Models\\Receipt',475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1449.99,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(584,7986,40759,8010,2,476,'App\\Models\\Receipt',476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1800.00,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(585,7986,40759,8010,2,477,'App\\Models\\Receipt',477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1500.00,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(586,7986,40759,8010,2,478,'App\\Models\\Receipt',478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1200.01,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(587,7986,40759,8010,2,479,'App\\Models\\Receipt',479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',1700.00,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(588,7986,40759,8010,2,480,'App\\Models\\Receipt',480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',2500.01,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(589,7986,40759,8010,2,481,'App\\Models\\Receipt',481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',900.00,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(590,7986,40759,8010,2,482,'App\\Models\\Receipt',482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',900.00,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(591,7986,40759,8010,2,483,'App\\Models\\Receipt',483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1399.99,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(592,7986,40759,8010,2,484,'App\\Models\\Receipt',484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1399.99,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(593,7986,40759,8010,2,485,'App\\Models\\Receipt',485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1399.99,NULL,NULL,1,'2023-01-11 12:09:42','2023-01-11 12:09:42',NULL),(594,7986,40759,8010,2,486,'App\\Models\\Receipt',486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1399.99,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(595,7986,40759,8010,2,487,'App\\Models\\Receipt',487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1399.99,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(596,7986,40759,8010,2,488,'App\\Models\\Receipt',488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',800.00,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(597,7986,40759,8010,2,489,'App\\Models\\Receipt',489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',400.00,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(598,7986,40759,8010,2,490,'App\\Models\\Receipt',490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',900.00,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(599,7986,40759,8010,2,491,'App\\Models\\Receipt',491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',600.00,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(600,7986,40759,8010,2,492,'App\\Models\\Receipt',492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',500.00,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL);
INSERT INTO `balance_libro` VALUES (601,7986,40759,8010,2,493,'App\\Models\\Receipt',493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',400.00,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(602,7986,40759,8010,2,494,'App\\Models\\Receipt',494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1199.99,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(603,7986,40759,8010,2,495,'App\\Models\\Receipt',495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1199.99,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(604,7986,40759,8010,2,496,'App\\Models\\Receipt',496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1399.99,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(605,7986,40759,8010,2,497,'App\\Models\\Receipt',497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',600.00,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(606,7986,40759,8010,2,498,'App\\Models\\Receipt',498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1399.99,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(607,7986,40759,8010,2,499,'App\\Models\\Receipt',499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1399.99,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(608,7986,40759,8010,2,500,'App\\Models\\Receipt',500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1100.00,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(609,7986,40759,8010,2,501,'App\\Models\\Receipt',501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',900.00,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(610,7986,40759,8010,2,502,'App\\Models\\Receipt',502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1200.01,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(611,7986,40759,8010,2,503,'App\\Models\\Receipt',503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',800.00,NULL,NULL,1,'2023-01-11 12:09:43','2023-01-11 12:09:43',NULL),(612,7986,40759,8010,2,504,'App\\Models\\Receipt',504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',930.01,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(613,7986,40759,8010,2,505,'App\\Models\\Receipt',505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',800.00,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(614,7986,40759,8010,2,506,'App\\Models\\Receipt',506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',300.00,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(615,7986,40759,8010,2,507,'App\\Models\\Receipt',507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1500.00,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(616,7986,40759,8010,2,508,'App\\Models\\Receipt',508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',1200.01,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(617,7986,40759,8010,2,509,'App\\Models\\Receipt',509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',800.00,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(618,7986,40759,8010,2,510,'App\\Models\\Receipt',510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1150.00,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(619,7986,40759,8010,2,511,'App\\Models\\Receipt',511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',800.00,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(620,7986,40759,8010,2,512,'App\\Models\\Receipt',512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',800.00,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(621,7986,40759,8010,2,513,'App\\Models\\Receipt',513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1500.00,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL);
INSERT INTO `balance_libro` VALUES (622,7986,40759,8010,2,514,'App\\Models\\Receipt',514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1399.99,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(623,7986,40759,8010,2,515,'App\\Models\\Receipt',515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',600.00,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(624,7986,40759,8010,2,516,'App\\Models\\Receipt',516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',2500.01,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(625,7986,40759,8010,2,517,'App\\Models\\Receipt',517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',800.00,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(626,7986,40759,8010,2,518,'App\\Models\\Receipt',518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1100.00,NULL,NULL,1,'2023-01-11 12:09:44','2023-01-11 12:09:44',NULL),(627,7986,40759,8010,2,519,'App\\Models\\Receipt',519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1399.99,NULL,NULL,1,'2023-01-11 12:09:45','2023-01-11 12:09:45',NULL),(628,7986,40759,8010,2,520,'App\\Models\\Receipt',520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',750.01,NULL,NULL,1,'2023-01-11 12:09:45','2023-01-11 12:09:45',NULL),(629,7986,40759,8010,2,521,'App\\Models\\Receipt',521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',500.00,NULL,NULL,1,'2023-01-11 12:09:45','2023-01-11 12:09:45',NULL),(630,7986,40759,8010,2,522,'App\\Models\\Receipt',522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1899.99,NULL,NULL,1,'2023-01-11 12:09:45','2023-01-11 12:09:45',NULL),(631,7986,40759,8010,2,523,'App\\Models\\Receipt',523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1500.00,NULL,NULL,1,'2023-01-11 12:09:45','2023-01-11 12:09:45',NULL),(632,7986,40759,8010,2,524,'App\\Models\\Receipt',524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',1300.00,NULL,NULL,1,'2023-01-11 12:09:45','2023-01-11 12:09:45',NULL),(633,7986,40759,8010,2,525,'App\\Models\\Receipt',525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',680.01,NULL,NULL,1,'2023-01-11 12:09:45','2023-01-11 12:09:45',NULL),(634,7986,40759,8010,2,526,'App\\Models\\Receipt',526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-08','2022-12-08',800.00,NULL,NULL,1,'2023-01-11 12:09:45','2023-01-11 12:09:45',NULL),(635,7986,40759,8010,2,527,'App\\Models\\Receipt',527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',1499.99,NULL,NULL,1,'2023-01-11 12:09:45','2023-01-11 12:09:45',NULL),(636,7986,40759,8010,2,528,'App\\Models\\Receipt',528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',1399.99,NULL,NULL,1,'2023-01-11 12:09:45','2023-01-11 12:09:45',NULL),(637,7986,40759,8010,2,529,'App\\Models\\Receipt',529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',1900.00,NULL,NULL,1,'2023-01-11 12:09:45','2023-01-11 12:09:45',NULL),(638,7986,40759,8010,2,530,'App\\Models\\Receipt',530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',1399.99,NULL,NULL,1,'2023-01-11 12:09:45','2023-01-11 12:09:45',NULL),(639,7986,40759,8010,2,531,'App\\Models\\Receipt',531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',800.00,NULL,NULL,1,'2023-01-11 12:09:45','2023-01-11 12:09:45',NULL),(640,7986,40759,8010,2,532,'App\\Models\\Receipt',532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',800.00,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(641,7986,40759,8010,2,533,'App\\Models\\Receipt',533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',680.01,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(642,7986,40759,8010,2,534,'App\\Models\\Receipt',534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',2200.00,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL);
INSERT INTO `balance_libro` VALUES (643,7986,40759,8010,2,535,'App\\Models\\Receipt',535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',1399.99,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(644,7986,40759,8010,2,536,'App\\Models\\Receipt',536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',800.00,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(645,7986,40759,8010,2,537,'App\\Models\\Receipt',537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',1399.99,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(646,7986,40759,8010,2,538,'App\\Models\\Receipt',538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',700.01,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(647,7986,40759,8010,2,539,'App\\Models\\Receipt',539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',800.00,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(648,7986,40759,8010,2,540,'App\\Models\\Receipt',540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',800.00,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(649,7986,40759,8010,2,541,'App\\Models\\Receipt',541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',1399.99,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(650,7986,40759,8010,2,542,'App\\Models\\Receipt',542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',1000.01,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(651,7986,40759,8010,2,543,'App\\Models\\Receipt',543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',500.00,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(652,7986,40759,8010,2,544,'App\\Models\\Receipt',544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',1500.00,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(653,7986,40759,8010,2,545,'App\\Models\\Receipt',545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',1080.00,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(654,7986,40759,8010,2,546,'App\\Models\\Receipt',546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',800.00,NULL,NULL,1,'2023-01-11 12:09:46','2023-01-11 12:09:46',NULL),(655,7986,40759,8010,2,547,'App\\Models\\Receipt',547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',2500.01,NULL,NULL,1,'2023-01-11 12:09:47','2023-01-11 12:09:47',NULL),(656,7986,40759,8010,2,548,'App\\Models\\Receipt',548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',800.00,NULL,NULL,1,'2023-01-11 12:09:47','2023-01-11 12:09:47',NULL),(657,7986,40759,8010,2,549,'App\\Models\\Receipt',549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',800.00,NULL,NULL,1,'2023-01-11 12:09:47','2023-01-11 12:09:47',NULL),(658,7986,40759,8010,2,550,'App\\Models\\Receipt',550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',800.00,NULL,NULL,1,'2023-01-11 12:09:47','2023-01-11 12:09:47',NULL),(659,7986,40759,8010,2,551,'App\\Models\\Receipt',551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1500.00,NULL,NULL,1,'2023-01-11 12:09:47','2023-01-11 12:09:47',NULL),(660,7986,40759,8010,2,552,'App\\Models\\Receipt',552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',600.00,NULL,NULL,1,'2023-01-11 12:09:47','2023-01-11 12:09:47',NULL),(661,7986,40759,8010,2,553,'App\\Models\\Receipt',553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',800.00,NULL,NULL,1,'2023-01-11 12:09:47','2023-01-11 12:09:47',NULL),(662,7986,40759,8010,2,554,'App\\Models\\Receipt',554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',600.00,NULL,NULL,1,'2023-01-11 12:09:47','2023-01-11 12:09:47',NULL),(663,7986,40759,8010,2,555,'App\\Models\\Receipt',555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',900.00,NULL,NULL,1,'2023-01-11 12:09:47','2023-01-11 12:09:47',NULL);
INSERT INTO `balance_libro` VALUES (664,7986,40759,8010,2,556,'App\\Models\\Receipt',556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1399.99,NULL,NULL,1,'2023-01-11 12:09:47','2023-01-11 12:09:47',NULL),(665,7986,40759,8010,2,557,'App\\Models\\Receipt',557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',900.00,NULL,NULL,1,'2023-01-11 12:09:47','2023-01-11 12:09:47',NULL),(666,7986,40759,8010,2,558,'App\\Models\\Receipt',558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',800.00,NULL,NULL,1,'2023-01-11 12:09:48','2023-01-11 12:09:48',NULL),(667,7986,40759,8010,2,559,'App\\Models\\Receipt',559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',800.00,NULL,NULL,1,'2023-01-11 12:09:48','2023-01-11 12:09:48',NULL),(668,7986,40759,8010,2,560,'App\\Models\\Receipt',560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',800.00,NULL,NULL,1,'2023-01-11 12:09:48','2023-01-11 12:09:48',NULL),(669,7986,40759,8010,2,561,'App\\Models\\Receipt',561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1399.99,NULL,NULL,1,'2023-01-11 12:09:48','2023-01-11 12:09:48',NULL),(670,7986,40759,8010,2,562,'App\\Models\\Receipt',562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2500.01,NULL,NULL,1,'2023-01-11 12:09:48','2023-01-11 12:09:48',NULL),(671,7986,40759,8010,2,563,'App\\Models\\Receipt',563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1000.01,NULL,NULL,1,'2023-01-11 12:09:48','2023-01-11 12:09:48',NULL),(672,7986,40759,8010,2,564,'App\\Models\\Receipt',564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2250.00,NULL,NULL,1,'2023-01-11 12:09:48','2023-01-11 12:09:48',NULL),(673,7986,40759,8010,2,565,'App\\Models\\Receipt',565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2500.01,NULL,NULL,1,'2023-01-11 12:09:48','2023-01-11 12:09:48',NULL),(674,7986,40759,8010,2,566,'App\\Models\\Receipt',566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',900.00,NULL,NULL,1,'2023-01-11 12:09:48','2023-01-11 12:09:48',NULL),(675,7986,40759,8010,2,567,'App\\Models\\Receipt',567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',2400.00,NULL,NULL,1,'2023-01-11 12:09:48','2023-01-11 12:09:48',NULL),(676,7986,40759,8010,2,568,'App\\Models\\Receipt',568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',600.00,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(677,7986,40759,8010,2,569,'App\\Models\\Receipt',569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1800.01,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(678,7986,40759,8010,2,570,'App\\Models\\Receipt',570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1649.99,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(679,7986,40759,8010,2,571,'App\\Models\\Receipt',571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',799.99,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(680,7986,40759,8010,2,572,'App\\Models\\Receipt',572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',800.00,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(681,7986,40759,8010,2,573,'App\\Models\\Receipt',573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1080.01,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(682,7986,40759,8010,2,574,'App\\Models\\Receipt',574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',600.00,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(683,7986,40759,8010,2,575,'App\\Models\\Receipt',575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',800.00,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(684,7986,40759,8010,2,576,'App\\Models\\Receipt',576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',600.00,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL);
INSERT INTO `balance_libro` VALUES (685,7986,40759,8010,2,577,'App\\Models\\Receipt',577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',1350.00,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(686,7986,40759,8010,2,578,'App\\Models\\Receipt',578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',800.00,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(687,7986,40759,8010,2,579,'App\\Models\\Receipt',579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',759.99,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(688,7986,40759,8010,2,580,'App\\Models\\Receipt',580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',900.00,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(689,7986,40759,8010,2,581,'App\\Models\\Receipt',581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',850.00,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(690,7986,40759,8010,2,582,'App\\Models\\Receipt',582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',900.00,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(691,7986,40759,8010,2,583,'App\\Models\\Receipt',583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1399.99,NULL,NULL,1,'2023-01-11 12:09:49','2023-01-11 12:09:49',NULL),(692,7986,40759,8010,2,584,'App\\Models\\Receipt',584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1000.01,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(693,7986,40759,8010,2,585,'App\\Models\\Receipt',585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1399.99,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(694,7986,40759,8010,2,586,'App\\Models\\Receipt',586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',900.00,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(695,7986,40759,8010,2,587,'App\\Models\\Receipt',587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',500.00,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(696,7986,40759,8010,2,588,'App\\Models\\Receipt',588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',2000.00,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(697,7986,40759,8010,2,589,'App\\Models\\Receipt',589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',800.00,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(698,7986,40759,8010,2,590,'App\\Models\\Receipt',590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1899.99,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(699,7986,40759,8010,2,591,'App\\Models\\Receipt',591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',500.00,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(700,7986,40759,8010,2,592,'App\\Models\\Receipt',592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',800.00,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(701,7986,40759,8010,2,593,'App\\Models\\Receipt',593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',800.00,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(702,7986,40759,8010,2,594,'App\\Models\\Receipt',594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',680.01,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(703,7986,40759,8010,2,595,'App\\Models\\Receipt',595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1919.98,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(704,7986,40759,8010,2,596,'App\\Models\\Receipt',596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',360.00,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(705,7986,40759,8010,2,597,'App\\Models\\Receipt',597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1500.00,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL);
INSERT INTO `balance_libro` VALUES (706,7986,40759,8010,2,598,'App\\Models\\Receipt',598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',800.00,NULL,NULL,1,'2023-01-11 12:09:50','2023-01-11 12:09:50',NULL),(707,7986,40759,8010,2,599,'App\\Models\\Receipt',599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',2500.01,NULL,NULL,1,'2023-01-11 12:09:51','2023-01-11 12:09:51',NULL),(708,7986,40759,8010,2,600,'App\\Models\\Receipt',600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',600.00,NULL,NULL,1,'2023-01-11 12:09:51','2023-01-11 12:09:51',NULL),(709,7986,40759,8010,2,601,'App\\Models\\Receipt',601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1399.99,NULL,NULL,1,'2023-01-11 12:09:51','2023-01-11 12:09:51',NULL),(710,7986,40759,8010,2,602,'App\\Models\\Receipt',602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',2099.99,NULL,NULL,1,'2023-01-11 12:09:51','2023-01-11 12:09:51',NULL),(711,7986,40759,8010,2,603,'App\\Models\\Receipt',603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',600.00,NULL,NULL,1,'2023-01-11 12:09:51','2023-01-11 12:09:51',NULL),(712,7986,40759,8010,2,604,'App\\Models\\Receipt',604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',900.00,NULL,NULL,1,'2023-01-11 12:09:51','2023-01-11 12:09:51',NULL),(713,7986,40759,8010,2,605,'App\\Models\\Receipt',605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1399.99,NULL,NULL,1,'2023-01-11 12:09:51','2023-01-11 12:09:51',NULL),(714,7986,40759,8010,2,606,'App\\Models\\Receipt',606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1399.99,NULL,NULL,1,'2023-01-11 12:09:51','2023-01-11 12:09:51',NULL),(715,7986,40759,8010,2,607,'App\\Models\\Receipt',607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1600.00,NULL,NULL,1,'2023-01-11 12:09:51','2023-01-11 12:09:51',NULL),(716,7986,40759,8010,2,608,'App\\Models\\Receipt',608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1350.00,NULL,NULL,1,'2023-01-11 12:09:51','2023-01-11 12:09:51',NULL),(717,7986,40759,8010,2,609,'App\\Models\\Receipt',609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1299.99,NULL,NULL,1,'2023-01-11 12:09:51','2023-01-11 12:09:51',NULL),(718,7986,40759,8010,2,610,'App\\Models\\Receipt',610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1750.00,NULL,NULL,1,'2023-01-11 12:09:52','2023-01-11 12:09:52',NULL),(719,7986,40759,8010,2,611,'App\\Models\\Receipt',611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',900.00,NULL,NULL,1,'2023-01-11 12:09:52','2023-01-11 12:09:52',NULL),(720,7986,40759,8010,2,612,'App\\Models\\Receipt',612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1499.99,NULL,NULL,1,'2023-01-11 12:09:52','2023-01-11 12:09:52',NULL),(721,7986,40759,8010,2,613,'App\\Models\\Receipt',613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',380.00,NULL,NULL,1,'2023-01-11 12:09:52','2023-01-11 12:09:52',NULL),(722,7986,40759,8010,2,614,'App\\Models\\Receipt',614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',2500.01,NULL,NULL,1,'2023-01-11 12:09:52','2023-01-11 12:09:52',NULL),(723,7986,40759,8010,2,615,'App\\Models\\Receipt',615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',800.00,NULL,NULL,1,'2023-01-11 12:09:52','2023-01-11 12:09:52',NULL),(724,7986,40759,8010,2,616,'App\\Models\\Receipt',616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1399.99,NULL,NULL,1,'2023-01-11 12:09:52','2023-01-11 12:09:52',NULL),(725,7986,40759,8010,2,617,'App\\Models\\Receipt',617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',900.00,NULL,NULL,1,'2023-01-11 12:09:52','2023-01-11 12:09:52',NULL),(726,7986,40759,8010,2,618,'App\\Models\\Receipt',618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-11','2022-12-11',1649.99,NULL,NULL,1,'2023-01-11 12:09:52','2023-01-11 12:09:52',NULL);
INSERT INTO `balance_libro` VALUES (727,7986,40759,8010,2,619,'App\\Models\\Receipt',619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1.21,NULL,NULL,1,'2023-01-11 12:09:52','2023-01-11 12:09:52',NULL),(728,7986,40759,8010,2,620,'App\\Models\\Receipt',620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1399.99,NULL,NULL,1,'2023-01-11 12:09:52','2023-01-11 12:09:52',NULL),(729,7986,40759,8010,2,621,'App\\Models\\Receipt',621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',500.00,NULL,NULL,1,'2023-01-11 12:09:52','2023-01-11 12:09:52',NULL),(730,7986,40759,8010,2,622,'App\\Models\\Receipt',622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1399.99,NULL,NULL,1,'2023-01-11 12:09:52','2023-01-11 12:09:52',NULL),(731,7986,40759,8010,2,623,'App\\Models\\Receipt',623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',300.00,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(732,7986,40759,8010,2,624,'App\\Models\\Receipt',624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',800.00,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(733,7986,40759,8010,2,625,'App\\Models\\Receipt',625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1900.00,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(734,7986,40759,8010,2,626,'App\\Models\\Receipt',626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',300.00,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(735,7986,40759,8010,2,627,'App\\Models\\Receipt',627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',300.00,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(736,7986,40759,8010,2,628,'App\\Models\\Receipt',628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1399.99,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(737,7986,40759,8010,2,629,'App\\Models\\Receipt',629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',1100.00,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(738,7986,40759,8010,2,630,'App\\Models\\Receipt',630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',800.00,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(739,7986,40759,8010,2,631,'App\\Models\\Receipt',631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',300.00,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(740,7986,40759,8010,2,632,'App\\Models\\Receipt',632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1449.99,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(741,7986,40759,8010,2,633,'App\\Models\\Receipt',633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1399.99,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(742,7986,40759,8010,2,634,'App\\Models\\Receipt',634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',800.00,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(743,7986,40759,8010,2,635,'App\\Models\\Receipt',635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1400.01,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(744,7986,40759,8010,2,636,'App\\Models\\Receipt',636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1000.01,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(745,7986,40759,8010,2,637,'App\\Models\\Receipt',637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',800.00,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(746,7986,40759,8010,2,638,'App\\Models\\Receipt',638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2500.01,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(747,7986,40759,8010,2,639,'App\\Models\\Receipt',639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',2500.01,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL);
INSERT INTO `balance_libro` VALUES (748,7986,40759,8010,2,640,'App\\Models\\Receipt',640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1399.99,NULL,NULL,1,'2023-01-11 12:09:53','2023-01-11 12:09:53',NULL),(749,7986,40759,8010,2,641,'App\\Models\\Receipt',641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',850.00,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(750,7986,40759,8010,2,642,'App\\Models\\Receipt',642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1449.99,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(751,7986,40759,8010,2,643,'App\\Models\\Receipt',643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1000.01,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(752,7986,40759,8010,2,644,'App\\Models\\Receipt',644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',1040.01,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(753,7986,40759,8010,2,645,'App\\Models\\Receipt',645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',760.00,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(754,7986,40759,8010,2,646,'App\\Models\\Receipt',646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',400.00,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(755,7986,40759,8010,2,647,'App\\Models\\Receipt',647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',1180.00,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(756,7986,40759,8010,2,648,'App\\Models\\Receipt',648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',650.00,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(757,7986,40759,8010,2,649,'App\\Models\\Receipt',649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',350.01,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(758,7986,40759,8010,2,650,'App\\Models\\Receipt',650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',2500.01,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(759,7986,40759,8010,2,651,'App\\Models\\Receipt',651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',800.00,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(760,7986,40759,8010,2,652,'App\\Models\\Receipt',652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',800.00,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(761,7986,40759,8010,2,653,'App\\Models\\Receipt',653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',800.00,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(762,7986,40759,8010,2,654,'App\\Models\\Receipt',654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1399.99,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(763,7986,40759,8010,2,655,'App\\Models\\Receipt',655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1550.01,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(764,7986,40759,8010,2,656,'App\\Models\\Receipt',656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1100.00,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(765,7986,40759,8010,2,657,'App\\Models\\Receipt',657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1399.99,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(766,7986,40759,8010,2,658,'App\\Models\\Receipt',658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',400.00,NULL,NULL,1,'2023-01-11 12:09:54','2023-01-11 12:09:54',NULL),(767,7986,40759,8010,2,659,'App\\Models\\Receipt',659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1399.99,NULL,NULL,1,'2023-01-11 12:09:55','2023-01-11 12:09:55',NULL),(768,7986,40759,8010,2,660,'App\\Models\\Receipt',660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',600.00,NULL,NULL,1,'2023-01-11 12:09:55','2023-01-11 12:09:55',NULL);
INSERT INTO `balance_libro` VALUES (769,7986,40759,8010,2,661,'App\\Models\\Receipt',661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',900.00,NULL,NULL,1,'2023-01-11 12:09:55','2023-01-11 12:09:55',NULL),(770,7986,40759,8010,2,662,'App\\Models\\Receipt',662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',900.00,NULL,NULL,1,'2023-01-11 12:09:55','2023-01-11 12:09:55',NULL),(771,7986,40759,8010,2,663,'App\\Models\\Receipt',663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1399.99,NULL,NULL,1,'2023-01-11 12:09:55','2023-01-11 12:09:55',NULL),(772,7986,40759,8010,2,664,'App\\Models\\Receipt',664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',1399.99,NULL,NULL,1,'2023-01-11 12:09:55','2023-01-11 12:09:55',NULL),(773,7986,40759,8010,2,665,'App\\Models\\Receipt',665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',800.00,NULL,NULL,1,'2023-01-11 12:09:55','2023-01-11 12:09:55',NULL),(774,7986,40759,8010,2,666,'App\\Models\\Receipt',666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',600.00,NULL,NULL,1,'2023-01-11 12:09:55','2023-01-11 12:09:55',NULL),(775,7986,40759,8010,2,667,'App\\Models\\Receipt',667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',800.00,NULL,NULL,1,'2023-01-11 12:09:55','2023-01-11 12:09:55',NULL),(776,7986,40759,8010,2,668,'App\\Models\\Receipt',668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',600.00,NULL,NULL,1,'2023-01-11 12:09:55','2023-01-11 12:09:55',NULL),(777,7986,40759,8010,2,669,'App\\Models\\Receipt',669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',1100.00,NULL,NULL,1,'2023-01-11 12:09:55','2023-01-11 12:09:55',NULL),(778,7986,40759,8010,2,670,'App\\Models\\Receipt',670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',1500.00,NULL,NULL,1,'2023-01-11 12:09:56','2023-01-11 12:09:56',NULL),(779,7986,40759,8010,2,671,'App\\Models\\Receipt',671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1000.01,NULL,NULL,1,'2023-01-11 12:09:56','2023-01-11 12:09:56',NULL),(780,7986,40759,8010,2,672,'App\\Models\\Receipt',672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',2500.01,NULL,NULL,1,'2023-01-11 12:09:56','2023-01-11 12:09:56',NULL),(781,7986,40759,8010,2,673,'App\\Models\\Receipt',673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',700.00,NULL,NULL,1,'2023-01-11 12:09:56','2023-01-11 12:09:56',NULL),(782,7986,40759,8010,2,674,'App\\Models\\Receipt',674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1399.99,NULL,NULL,1,'2023-01-11 12:09:56','2023-01-11 12:09:56',NULL),(783,7986,40759,8010,2,675,'App\\Models\\Receipt',675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1400.01,NULL,NULL,1,'2023-01-11 12:09:56','2023-01-11 12:09:56',NULL),(784,7986,40759,8010,2,676,'App\\Models\\Receipt',676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',800.00,NULL,NULL,1,'2023-01-11 12:09:56','2023-01-11 12:09:56',NULL),(785,7986,40759,8010,2,677,'App\\Models\\Receipt',677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1399.99,NULL,NULL,1,'2023-01-11 12:09:56','2023-01-11 12:09:56',NULL),(786,7986,40759,8010,2,678,'App\\Models\\Receipt',678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',600.00,NULL,NULL,1,'2023-01-11 12:09:56','2023-01-11 12:09:56',NULL),(787,7986,40759,8010,2,679,'App\\Models\\Receipt',679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',900.00,NULL,NULL,1,'2023-01-11 12:09:56','2023-01-11 12:09:56',NULL),(788,7986,40759,8010,2,680,'App\\Models\\Receipt',680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1350.00,NULL,NULL,1,'2023-01-11 12:09:56','2023-01-11 12:09:56',NULL),(789,7986,40759,8010,2,681,'App\\Models\\Receipt',681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1199.99,NULL,NULL,1,'2023-01-11 12:09:56','2023-01-11 12:09:56',NULL);
INSERT INTO `balance_libro` VALUES (790,7986,40759,8010,2,682,'App\\Models\\Receipt',682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',800.00,NULL,NULL,1,'2023-01-11 12:09:57','2023-01-11 12:09:57',NULL),(791,7986,40759,8010,2,683,'App\\Models\\Receipt',683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1800.00,NULL,NULL,1,'2023-01-11 12:09:57','2023-01-11 12:09:57',NULL),(792,7986,40759,8010,2,684,'App\\Models\\Receipt',684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1399.99,NULL,NULL,1,'2023-01-11 12:09:57','2023-01-11 12:09:57',NULL),(793,7986,40759,8010,2,685,'App\\Models\\Receipt',685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',600.00,NULL,NULL,1,'2023-01-11 12:09:57','2023-01-11 12:09:57',NULL),(794,7986,40759,8010,2,686,'App\\Models\\Receipt',686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',2000.00,NULL,NULL,1,'2023-01-11 12:09:57','2023-01-11 12:09:57',NULL),(795,7986,40759,8010,2,687,'App\\Models\\Receipt',687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1100.00,NULL,NULL,1,'2023-01-11 12:09:57','2023-01-11 12:09:57',NULL),(796,7986,40759,8010,2,688,'App\\Models\\Receipt',688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',900.00,NULL,NULL,1,'2023-01-11 12:09:57','2023-01-11 12:09:57',NULL),(797,7986,40759,8010,2,689,'App\\Models\\Receipt',689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',800.00,NULL,NULL,1,'2023-01-11 12:09:57','2023-01-11 12:09:57',NULL),(798,7986,40759,8010,2,690,'App\\Models\\Receipt',690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1900.00,NULL,NULL,1,'2023-01-11 12:09:57','2023-01-11 12:09:57',NULL),(799,7986,40759,8010,2,691,'App\\Models\\Receipt',691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',2000.00,NULL,NULL,1,'2023-01-11 12:09:57','2023-01-11 12:09:57',NULL),(800,7986,40759,8010,2,692,'App\\Models\\Receipt',692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1499.99,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL),(801,7986,40759,8010,2,693,'App\\Models\\Receipt',693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',400.00,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL),(802,7986,40759,8010,2,694,'App\\Models\\Receipt',694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1399.99,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL),(803,7986,40759,8010,2,695,'App\\Models\\Receipt',695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1449.99,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL),(804,7986,40759,8010,2,696,'App\\Models\\Receipt',696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',500.00,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL),(805,7986,40759,8010,2,697,'App\\Models\\Receipt',697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',700.00,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL),(806,7986,40759,8010,2,698,'App\\Models\\Receipt',698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1500.00,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL),(807,7986,40759,8010,2,699,'App\\Models\\Receipt',699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1100.00,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL),(808,7986,40759,8010,2,700,'App\\Models\\Receipt',700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-18','2022-12-18',1000.01,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL),(809,7986,40759,8010,2,701,'App\\Models\\Receipt',701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',800.00,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL),(810,7986,40759,8010,2,702,'App\\Models\\Receipt',702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1399.99,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL);
INSERT INTO `balance_libro` VALUES (811,7986,40759,8010,2,703,'App\\Models\\Receipt',703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',549.99,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL),(812,7986,40759,8010,2,704,'App\\Models\\Receipt',704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1800.00,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL),(813,7986,40759,8010,2,705,'App\\Models\\Receipt',705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',900.00,NULL,NULL,1,'2023-01-11 12:09:58','2023-01-11 12:09:58',NULL),(814,7986,40759,8010,2,706,'App\\Models\\Receipt',706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',750.01,NULL,NULL,1,'2023-01-11 12:09:59','2023-01-11 12:09:59',NULL),(815,7986,40759,8010,2,707,'App\\Models\\Receipt',707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',990.00,NULL,NULL,1,'2023-01-11 12:09:59','2023-01-11 12:09:59',NULL),(816,7986,40759,8010,2,708,'App\\Models\\Receipt',708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',500.00,NULL,NULL,1,'2023-01-11 12:09:59','2023-01-11 12:09:59',NULL),(817,7986,40759,8010,2,709,'App\\Models\\Receipt',709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',600.00,NULL,NULL,1,'2023-01-11 12:09:59','2023-01-11 12:09:59',NULL),(818,7986,40759,8010,2,710,'App\\Models\\Receipt',710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',900.00,NULL,NULL,1,'2023-01-11 12:09:59','2023-01-11 12:09:59',NULL),(819,7986,40759,8010,2,711,'App\\Models\\Receipt',711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',500.00,NULL,NULL,1,'2023-01-11 12:09:59','2023-01-11 12:09:59',NULL),(820,7986,40759,8010,2,712,'App\\Models\\Receipt',712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',1399.99,NULL,NULL,1,'2023-01-11 12:09:59','2023-01-11 12:09:59',NULL),(821,7986,40759,8010,2,713,'App\\Models\\Receipt',713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',650.00,NULL,NULL,1,'2023-01-11 12:09:59','2023-01-11 12:09:59',NULL),(822,7986,40759,8010,2,714,'App\\Models\\Receipt',714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',500.00,NULL,NULL,1,'2023-01-11 12:09:59','2023-01-11 12:09:59',NULL),(823,7986,40759,8010,2,715,'App\\Models\\Receipt',715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',800.00,NULL,NULL,1,'2023-01-11 12:09:59','2023-01-11 12:09:59',NULL),(824,7986,40759,8010,2,716,'App\\Models\\Receipt',716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',800.00,NULL,NULL,1,'2023-01-11 12:09:59','2023-01-11 12:09:59',NULL),(825,7986,40759,8010,2,717,'App\\Models\\Receipt',717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',800.00,NULL,NULL,1,'2023-01-11 12:09:59','2023-01-11 12:09:59',NULL),(826,7986,40759,8010,2,718,'App\\Models\\Receipt',718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',900.00,NULL,NULL,1,'2023-01-11 12:10:00','2023-01-11 12:10:00',NULL),(827,7986,40759,8010,2,719,'App\\Models\\Receipt',719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',2200.00,NULL,NULL,1,'2023-01-11 12:10:00','2023-01-11 12:10:00',NULL),(828,7986,40759,8010,2,720,'App\\Models\\Receipt',720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',800.00,NULL,NULL,1,'2023-01-11 12:10:00','2023-01-11 12:10:00',NULL),(829,7986,40759,8010,2,721,'App\\Models\\Receipt',721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',889.99,NULL,NULL,1,'2023-01-11 12:10:00','2023-01-11 12:10:00',NULL),(830,7986,40759,8010,2,722,'App\\Models\\Receipt',722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',800.00,NULL,NULL,1,'2023-01-11 12:10:00','2023-01-11 12:10:00',NULL),(831,7986,40759,8010,2,723,'App\\Models\\Receipt',723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',900.00,NULL,NULL,1,'2023-01-11 12:10:00','2023-01-11 12:10:00',NULL);
INSERT INTO `balance_libro` VALUES (832,7986,40759,8010,2,724,'App\\Models\\Receipt',724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1100.00,NULL,NULL,1,'2023-01-11 12:10:00','2023-01-11 12:10:00',NULL),(833,7986,40759,8010,2,725,'App\\Models\\Receipt',725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',600.00,NULL,NULL,1,'2023-01-11 12:10:00','2023-01-11 12:10:00',NULL),(834,7986,40759,8010,2,726,'App\\Models\\Receipt',726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',800.00,NULL,NULL,1,'2023-01-11 12:10:00','2023-01-11 12:10:00',NULL),(835,7986,40759,8010,2,727,'App\\Models\\Receipt',727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',800.00,NULL,NULL,1,'2023-01-11 12:10:00','2023-01-11 12:10:00',NULL),(836,7986,40759,8010,2,728,'App\\Models\\Receipt',728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',800.00,NULL,NULL,1,'2023-01-11 12:10:00','2023-01-11 12:10:00',NULL),(837,7986,40759,8010,2,729,'App\\Models\\Receipt',729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1399.99,NULL,NULL,1,'2023-01-11 12:10:01','2023-01-11 12:10:01',NULL),(838,7986,40759,8010,2,730,'App\\Models\\Receipt',730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',480.01,NULL,NULL,1,'2023-01-11 12:10:01','2023-01-11 12:10:01',NULL),(839,7986,40759,8010,2,731,'App\\Models\\Receipt',731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1150.00,NULL,NULL,1,'2023-01-11 12:10:01','2023-01-11 12:10:01',NULL),(840,7986,40759,8010,2,732,'App\\Models\\Receipt',732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',800.00,NULL,NULL,1,'2023-01-11 12:10:01','2023-01-11 12:10:01',NULL),(841,7986,40759,8010,2,733,'App\\Models\\Receipt',733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',800.00,NULL,NULL,1,'2023-01-11 12:10:01','2023-01-11 12:10:01',NULL),(842,7986,40759,8010,2,734,'App\\Models\\Receipt',734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',399.99,NULL,NULL,1,'2023-01-11 12:10:01','2023-01-11 12:10:01',NULL),(843,7986,40759,8010,2,735,'App\\Models\\Receipt',735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1649.99,NULL,NULL,1,'2023-01-11 12:10:01','2023-01-11 12:10:01',NULL),(844,7986,40759,8010,2,736,'App\\Models\\Receipt',736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',600.00,NULL,NULL,1,'2023-01-11 12:10:01','2023-01-11 12:10:01',NULL),(845,7986,40759,8010,2,737,'App\\Models\\Receipt',737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',800.00,NULL,NULL,1,'2023-01-11 12:10:01','2023-01-11 12:10:01',NULL),(846,7986,40759,8010,2,738,'App\\Models\\Receipt',738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',900.00,NULL,NULL,1,'2023-01-11 12:10:01','2023-01-11 12:10:01',NULL),(847,7986,40759,8010,2,739,'App\\Models\\Receipt',739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',1499.99,NULL,NULL,1,'2023-01-11 12:10:01','2023-01-11 12:10:01',NULL),(848,7986,40759,8010,2,740,'App\\Models\\Receipt',740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',240.00,NULL,NULL,1,'2023-01-11 12:10:01','2023-01-11 12:10:01',NULL),(849,7986,40759,8010,2,741,'App\\Models\\Receipt',741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1699.99,NULL,NULL,1,'2023-01-11 12:10:02','2023-01-11 12:10:02',NULL),(850,7986,40759,8010,2,742,'App\\Models\\Receipt',742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',900.00,NULL,NULL,1,'2023-01-11 12:10:02','2023-01-11 12:10:02',NULL),(851,7986,40759,8010,2,743,'App\\Models\\Receipt',743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',3800.01,NULL,NULL,1,'2023-01-11 12:10:02','2023-01-11 12:10:02',NULL),(852,7986,40759,8010,2,744,'App\\Models\\Receipt',744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1450.00,NULL,NULL,1,'2023-01-11 12:10:02','2023-01-11 12:10:02',NULL);
INSERT INTO `balance_libro` VALUES (853,7986,40759,8010,2,745,'App\\Models\\Receipt',745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',900.00,NULL,NULL,1,'2023-01-11 12:10:02','2023-01-11 12:10:02',NULL),(854,7986,40759,8010,2,746,'App\\Models\\Receipt',746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',950.01,NULL,NULL,1,'2023-01-11 12:10:02','2023-01-11 12:10:02',NULL),(855,7986,40759,8010,2,747,'App\\Models\\Receipt',747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',400.00,NULL,NULL,1,'2023-01-11 12:10:02','2023-01-11 12:10:02',NULL),(856,7986,40759,8010,2,748,'App\\Models\\Receipt',748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2600.00,NULL,NULL,1,'2023-01-11 12:10:02','2023-01-11 12:10:02',NULL),(857,7986,40759,8010,2,749,'App\\Models\\Receipt',749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',900.00,NULL,NULL,1,'2023-01-11 12:10:03','2023-01-11 12:10:03',NULL),(858,7986,40759,8010,2,750,'App\\Models\\Receipt',750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1700.00,NULL,NULL,1,'2023-01-11 12:10:03','2023-01-11 12:10:03',NULL),(859,7986,40759,8010,2,751,'App\\Models\\Receipt',751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',900.00,NULL,NULL,1,'2023-01-11 12:10:03','2023-01-11 12:10:03',NULL),(860,7986,40759,8010,2,752,'App\\Models\\Receipt',752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1600.00,NULL,NULL,1,'2023-01-11 12:10:03','2023-01-11 12:10:03',NULL),(861,7986,40759,8010,2,753,'App\\Models\\Receipt',753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',1600.00,NULL,NULL,1,'2023-01-11 12:10:03','2023-01-11 12:10:03',NULL),(862,7986,40759,8010,2,754,'App\\Models\\Receipt',754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',2400.00,NULL,NULL,1,'2023-01-11 12:10:03','2023-01-11 12:10:03',NULL),(863,7986,40759,8010,2,755,'App\\Models\\Receipt',755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',900.00,NULL,NULL,1,'2023-01-11 12:10:03','2023-01-11 12:10:03',NULL),(864,7986,40759,8010,2,756,'App\\Models\\Receipt',756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',2499.99,NULL,NULL,1,'2023-01-11 12:10:03','2023-01-11 12:10:03',NULL),(865,7986,40759,8010,2,757,'App\\Models\\Receipt',757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1600.00,NULL,NULL,1,'2023-01-11 12:10:03','2023-01-11 12:10:03',NULL),(866,7986,40759,8010,2,758,'App\\Models\\Receipt',758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1600.00,NULL,NULL,1,'2023-01-11 12:10:03','2023-01-11 12:10:03',NULL),(867,7986,40759,8010,2,759,'App\\Models\\Receipt',759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',500.00,NULL,NULL,1,'2023-01-11 12:10:04','2023-01-11 12:10:04',NULL),(868,7986,40759,8010,2,760,'App\\Models\\Receipt',760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1600.00,NULL,NULL,1,'2023-01-11 12:10:04','2023-01-11 12:10:04',NULL),(869,7986,40759,8010,2,761,'App\\Models\\Receipt',761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1350.00,NULL,NULL,1,'2023-01-11 12:10:04','2023-01-11 12:10:04',NULL),(870,7986,40759,8010,2,762,'App\\Models\\Receipt',762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',850.00,NULL,NULL,1,'2023-01-11 12:10:04','2023-01-11 12:10:04',NULL),(871,7986,40759,8010,2,763,'App\\Models\\Receipt',763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',700.00,NULL,NULL,1,'2023-01-11 12:10:04','2023-01-11 12:10:04',NULL),(872,7986,40759,8010,2,764,'App\\Models\\Receipt',764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',2900.00,NULL,NULL,1,'2023-01-11 12:10:04','2023-01-11 12:10:04',NULL),(873,7986,40759,8010,2,765,'App\\Models\\Receipt',765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',6800.01,NULL,NULL,1,'2023-01-11 12:10:04','2023-01-11 12:10:04',NULL);
INSERT INTO `balance_libro` VALUES (874,7986,40759,8010,2,766,'App\\Models\\Receipt',766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',1050.00,NULL,NULL,1,'2023-01-11 12:10:04','2023-01-11 12:10:04',NULL),(875,7986,40759,8010,2,767,'App\\Models\\Receipt',767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',900.00,NULL,NULL,1,'2023-01-11 12:10:04','2023-01-11 12:10:04',NULL),(876,7986,40759,8010,2,768,'App\\Models\\Receipt',768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2000.00,NULL,NULL,1,'2023-01-11 12:10:04','2023-01-11 12:10:04',NULL),(877,7986,40759,8010,2,769,'App\\Models\\Receipt',769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2900.00,NULL,NULL,1,'2023-01-11 12:10:04','2023-01-11 12:10:04',NULL),(878,7986,40759,8010,2,770,'App\\Models\\Receipt',770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2499.99,NULL,NULL,1,'2023-01-11 12:10:05','2023-01-11 12:10:05',NULL),(879,7986,40759,8010,2,771,'App\\Models\\Receipt',771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2900.00,NULL,NULL,1,'2023-01-11 12:10:05','2023-01-11 12:10:05',NULL),(880,7986,40759,8010,2,772,'App\\Models\\Receipt',772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',700.00,NULL,NULL,1,'2023-01-11 12:10:05','2023-01-11 12:10:05',NULL),(881,7986,40759,8010,2,773,'App\\Models\\Receipt',773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',1699.99,NULL,NULL,1,'2023-01-11 12:10:05','2023-01-11 12:10:05',NULL),(882,7986,40759,8010,2,774,'App\\Models\\Receipt',774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',900.00,NULL,NULL,1,'2023-01-11 12:10:05','2023-01-11 12:10:05',NULL),(883,7986,40759,8010,2,775,'App\\Models\\Receipt',775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2499.99,NULL,NULL,1,'2023-01-11 12:10:05','2023-01-11 12:10:05',NULL),(884,7986,40759,8010,2,776,'App\\Models\\Receipt',776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',1900.00,NULL,NULL,1,'2023-01-11 12:10:05','2023-01-11 12:10:05',NULL),(885,7986,40759,8010,2,777,'App\\Models\\Receipt',777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2900.00,NULL,NULL,1,'2023-01-11 12:10:05','2023-01-11 12:10:05',NULL),(886,7986,40759,8010,2,778,'App\\Models\\Receipt',778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2499.99,NULL,NULL,1,'2023-01-11 12:10:05','2023-01-11 12:10:05',NULL),(887,7986,40759,8010,2,779,'App\\Models\\Receipt',779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2900.00,NULL,NULL,1,'2023-01-11 12:10:05','2023-01-11 12:10:05',NULL),(888,7986,40759,8010,2,780,'App\\Models\\Receipt',780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',2699.99,NULL,NULL,1,'2023-01-11 12:10:05','2023-01-11 12:10:05',NULL),(889,7986,40759,8010,2,781,'App\\Models\\Receipt',781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',1100.00,NULL,NULL,1,'2023-01-11 12:10:05','2023-01-11 12:10:05',NULL),(890,7986,40759,8010,2,782,'App\\Models\\Receipt',782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',1049.99,NULL,NULL,1,'2023-01-11 12:10:05','2023-01-11 12:10:05',NULL),(891,7986,40759,8010,2,783,'App\\Models\\Receipt',783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',900.00,NULL,NULL,1,'2023-01-11 12:10:06','2023-01-11 12:10:06',NULL),(892,7986,40759,8010,2,784,'App\\Models\\Receipt',784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',1600.00,NULL,NULL,1,'2023-01-11 12:10:06','2023-01-11 12:10:06',NULL),(893,7986,40759,8010,2,785,'App\\Models\\Receipt',785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',1600.00,NULL,NULL,1,'2023-01-11 12:10:06','2023-01-11 12:10:06',NULL),(894,7986,40759,8010,2,786,'App\\Models\\Receipt',786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',700.00,NULL,NULL,1,'2023-01-11 12:10:06','2023-01-11 12:10:06',NULL);
INSERT INTO `balance_libro` VALUES (895,7986,40759,8010,2,787,'App\\Models\\Receipt',787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1000.01,NULL,NULL,1,'2023-01-11 12:10:06','2023-01-11 12:10:06',NULL),(896,7986,40759,8010,2,788,'App\\Models\\Receipt',788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2800.00,NULL,NULL,1,'2023-01-11 12:10:06','2023-01-11 12:10:06',NULL),(897,7986,40759,8010,2,789,'App\\Models\\Receipt',789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1600.00,NULL,NULL,1,'2023-01-11 12:10:06','2023-01-11 12:10:06',NULL),(898,7986,40759,8010,2,790,'App\\Models\\Receipt',790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',7400.00,NULL,NULL,1,'2023-01-11 12:10:06','2023-01-11 12:10:06',NULL),(899,7986,40759,8010,2,791,'App\\Models\\Receipt',791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',3720.00,NULL,NULL,1,'2023-01-11 12:10:06','2023-01-11 12:10:06',NULL),(900,7986,40759,8010,2,792,'App\\Models\\Receipt',792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2900.00,NULL,NULL,1,'2023-01-11 12:10:06','2023-01-11 12:10:06',NULL),(901,7986,40759,8010,2,793,'App\\Models\\Receipt',793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',3100.00,NULL,NULL,1,'2023-01-11 12:10:06','2023-01-11 12:10:06',NULL),(902,7986,40759,8010,2,794,'App\\Models\\Receipt',794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',3100.01,NULL,NULL,1,'2023-01-11 12:10:06','2023-01-11 12:10:06',NULL),(903,7986,40759,8010,2,795,'App\\Models\\Receipt',795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1600.00,NULL,NULL,1,'2023-01-11 12:10:07','2023-01-11 12:10:07',NULL),(904,7986,40759,8010,2,796,'App\\Models\\Receipt',796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',5800.00,NULL,NULL,1,'2023-01-11 12:10:07','2023-01-11 12:10:07',NULL),(905,7986,40759,8010,2,797,'App\\Models\\Receipt',797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2499.99,NULL,NULL,1,'2023-01-11 12:10:07','2023-01-11 12:10:07',NULL),(906,7986,40759,8010,2,798,'App\\Models\\Receipt',798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1649.99,NULL,NULL,1,'2023-01-11 12:10:07','2023-01-11 12:10:07',NULL),(907,7986,40759,8010,2,799,'App\\Models\\Receipt',799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1600.00,NULL,NULL,1,'2023-01-11 12:10:07','2023-01-11 12:10:07',NULL),(908,7986,40759,8010,2,800,'App\\Models\\Receipt',800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',3000.00,NULL,NULL,1,'2023-01-11 12:10:07','2023-01-11 12:10:07',NULL),(909,7986,40759,8010,2,801,'App\\Models\\Receipt',801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',5900.00,NULL,NULL,1,'2023-01-11 12:10:07','2023-01-11 12:10:07',NULL),(910,7986,40759,8010,2,802,'App\\Models\\Receipt',802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2900.00,NULL,NULL,1,'2023-01-11 12:10:07','2023-01-11 12:10:07',NULL),(911,7986,40759,8010,2,803,'App\\Models\\Receipt',803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2900.00,NULL,NULL,1,'2023-01-11 12:10:07','2023-01-11 12:10:07',NULL),(912,7986,40759,8010,2,804,'App\\Models\\Receipt',804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',500.00,NULL,NULL,1,'2023-01-11 12:10:07','2023-01-11 12:10:07',NULL),(913,7986,40759,8010,2,805,'App\\Models\\Receipt',805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1800.00,NULL,NULL,1,'2023-01-11 12:10:07','2023-01-11 12:10:07',NULL),(914,7986,40759,8010,2,806,'App\\Models\\Receipt',806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2599.99,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL),(915,7986,40759,8010,2,807,'App\\Models\\Receipt',807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2299.99,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL);
INSERT INTO `balance_libro` VALUES (916,7986,40759,8010,2,808,'App\\Models\\Receipt',808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',4499.99,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL),(917,7986,40759,8010,2,809,'App\\Models\\Receipt',809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',1100.00,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL),(918,7986,40759,8010,2,810,'App\\Models\\Receipt',810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',3399.99,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL),(919,7986,40759,8010,2,811,'App\\Models\\Receipt',811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2450.00,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL),(920,7986,40759,8010,2,812,'App\\Models\\Receipt',812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2729.99,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL),(921,7986,40759,8010,2,813,'App\\Models\\Receipt',813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-24','2022-12-24',2560.00,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL),(922,7986,40759,8010,2,814,'App\\Models\\Receipt',814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2500.01,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL),(923,7986,40759,8010,2,815,'App\\Models\\Receipt',815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',250.00,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL),(924,7986,40759,8010,2,816,'App\\Models\\Receipt',816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',800.00,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL),(925,7986,40759,8010,2,817,'App\\Models\\Receipt',817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2800.00,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL),(926,7986,40759,8010,2,818,'App\\Models\\Receipt',818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',450.00,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL),(927,7986,40759,8010,2,819,'App\\Models\\Receipt',819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',4850.01,NULL,NULL,1,'2023-01-11 12:10:08','2023-01-11 12:10:08',NULL),(928,7986,40759,8010,2,820,'App\\Models\\Receipt',820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1600.00,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(929,7986,40759,8010,2,821,'App\\Models\\Receipt',821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1699.99,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(930,7986,40759,8010,2,822,'App\\Models\\Receipt',822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1840.00,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(931,7986,40759,8010,2,823,'App\\Models\\Receipt',823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',900.00,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(932,7986,40759,8010,2,824,'App\\Models\\Receipt',824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',900.00,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(933,7986,40759,8010,2,825,'App\\Models\\Receipt',825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',900.00,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(934,7986,40759,8010,2,826,'App\\Models\\Receipt',826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',700.00,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(935,7986,40759,8010,2,827,'App\\Models\\Receipt',827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',1649.99,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(936,7986,40759,8010,2,828,'App\\Models\\Receipt',828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',550.01,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL);
INSERT INTO `balance_libro` VALUES (937,7986,40759,8010,2,829,'App\\Models\\Receipt',829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',550.01,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(938,7986,40759,8010,2,830,'App\\Models\\Receipt',830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',900.00,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(939,7986,40759,8010,2,831,'App\\Models\\Receipt',831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',700.00,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(940,7986,40759,8010,2,832,'App\\Models\\Receipt',832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1500.00,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(941,7986,40759,8010,2,833,'App\\Models\\Receipt',833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1440.00,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(942,7986,40759,8010,2,834,'App\\Models\\Receipt',834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1350.00,NULL,NULL,1,'2023-01-11 12:10:09','2023-01-11 12:10:09',NULL),(943,7986,40759,8010,2,835,'App\\Models\\Receipt',835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1600.00,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(944,7986,40759,8010,2,836,'App\\Models\\Receipt',836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1050.00,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(945,7986,40759,8010,2,837,'App\\Models\\Receipt',837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1600.00,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(946,7986,40759,8010,2,838,'App\\Models\\Receipt',838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1600.00,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(947,7986,40759,8010,2,839,'App\\Models\\Receipt',839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3100.01,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(948,7986,40759,8010,2,840,'App\\Models\\Receipt',840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1600.00,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(949,7986,40759,8010,2,841,'App\\Models\\Receipt',841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',1250.00,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(950,7986,40759,8010,2,842,'App\\Models\\Receipt',842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',950.00,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(951,7986,40759,8010,2,843,'App\\Models\\Receipt',843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',950.00,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(952,7986,40759,8010,2,844,'App\\Models\\Receipt',844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',700.00,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(953,7986,40759,8010,2,845,'App\\Models\\Receipt',845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1300.00,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(954,7986,40759,8010,2,846,'App\\Models\\Receipt',846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1500.00,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(955,7986,40759,8010,2,847,'App\\Models\\Receipt',847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',900.00,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(956,7986,40759,8010,2,848,'App\\Models\\Receipt',848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',700.00,NULL,NULL,1,'2023-01-11 12:10:10','2023-01-11 12:10:10',NULL),(957,7986,40759,8010,2,849,'App\\Models\\Receipt',849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1600.00,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL);
INSERT INTO `balance_libro` VALUES (958,7986,40759,8010,2,850,'App\\Models\\Receipt',850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',550.01,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(959,7986,40759,8010,2,851,'App\\Models\\Receipt',851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1000.01,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(960,7986,40759,8010,2,852,'App\\Models\\Receipt',852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',700.00,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(961,7986,40759,8010,2,853,'App\\Models\\Receipt',853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1099.99,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(962,7986,40759,8010,2,854,'App\\Models\\Receipt',854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',900.00,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(963,7986,40759,8010,2,855,'App\\Models\\Receipt',855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',5800.00,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(964,7986,40759,8010,2,856,'App\\Models\\Receipt',856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1699.99,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(965,7986,40759,8010,2,857,'App\\Models\\Receipt',857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',900.00,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(966,7986,40759,8010,2,858,'App\\Models\\Receipt',858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',550.01,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(967,7986,40759,8010,2,859,'App\\Models\\Receipt',859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',700.00,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(968,7986,40759,8010,2,860,'App\\Models\\Receipt',860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1600.00,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(969,7986,40759,8010,2,861,'App\\Models\\Receipt',861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1950.00,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(970,7986,40759,8010,2,862,'App\\Models\\Receipt',862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',1200.01,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(971,7986,40759,8010,2,863,'App\\Models\\Receipt',863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',900.00,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(972,7986,40759,8010,2,864,'App\\Models\\Receipt',864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',900.00,NULL,NULL,1,'2023-01-11 12:10:11','2023-01-11 12:10:11',NULL),(973,7986,40759,8010,2,865,'App\\Models\\Receipt',865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1600.00,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(974,7986,40759,8010,2,866,'App\\Models\\Receipt',866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2050.01,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(975,7986,40759,8010,2,867,'App\\Models\\Receipt',867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1650.00,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(976,7986,40759,8010,2,868,'App\\Models\\Receipt',868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4899.99,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(977,7986,40759,8010,2,869,'App\\Models\\Receipt',869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',900.00,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(978,7986,40759,8010,2,870,'App\\Models\\Receipt',870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2350.00,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL);
INSERT INTO `balance_libro` VALUES (979,7986,40759,8010,2,871,'App\\Models\\Receipt',871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1600.00,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(980,7986,40759,8010,2,872,'App\\Models\\Receipt',872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3649.99,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(981,7986,40759,8010,2,873,'App\\Models\\Receipt',873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2499.99,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(982,7986,40759,8010,2,874,'App\\Models\\Receipt',874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1600.00,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(983,7986,40759,8010,2,875,'App\\Models\\Receipt',875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4499.99,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(984,7986,40759,8010,2,876,'App\\Models\\Receipt',876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1399.99,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(985,7986,40759,8010,2,877,'App\\Models\\Receipt',877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',900.01,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(986,7986,40759,8010,2,878,'App\\Models\\Receipt',878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2150.00,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(987,7986,40759,8010,2,879,'App\\Models\\Receipt',879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',3800.01,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(988,7986,40759,8010,2,880,'App\\Models\\Receipt',880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',5600.00,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(989,7986,40759,8010,2,881,'App\\Models\\Receipt',881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2900.00,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(990,7986,40759,8010,2,882,'App\\Models\\Receipt',882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',4400.00,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(991,7986,40759,8010,2,883,'App\\Models\\Receipt',883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1600.00,NULL,NULL,1,'2023-01-11 12:10:12','2023-01-11 12:10:12',NULL),(992,7986,40759,8010,2,884,'App\\Models\\Receipt',884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',999.99,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(993,7986,40759,8010,2,885,'App\\Models\\Receipt',885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2200.00,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(994,7986,40759,8010,2,886,'App\\Models\\Receipt',886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',2900.00,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(995,7986,40759,8010,2,887,'App\\Models\\Receipt',887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1600.00,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(996,7986,40759,8010,2,888,'App\\Models\\Receipt',888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',1600.00,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(997,7986,40759,8010,2,889,'App\\Models\\Receipt',889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',900.00,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(998,7986,40759,8010,2,890,'App\\Models\\Receipt',890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',700.00,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(999,7986,40759,8010,2,891,'App\\Models\\Receipt',891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',999.99,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL);
INSERT INTO `balance_libro` VALUES (1000,7986,40759,8010,2,892,'App\\Models\\Receipt',892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1600.00,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1001,7986,40759,8010,2,893,'App\\Models\\Receipt',893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4499.99,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1002,7986,40759,8010,2,894,'App\\Models\\Receipt',894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',600.00,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1003,7986,40759,8010,2,895,'App\\Models\\Receipt',895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',700.00,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1004,7986,40759,8010,2,896,'App\\Models\\Receipt',896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',350.01,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1005,7986,40759,8010,2,897,'App\\Models\\Receipt',897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2499.99,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1006,7986,40759,8010,2,898,'App\\Models\\Receipt',898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2499.99,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1007,7986,40759,8010,2,899,'App\\Models\\Receipt',899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',5450.01,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1008,7986,40759,8010,2,900,'App\\Models\\Receipt',900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6299.99,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1009,7986,40759,8010,2,901,'App\\Models\\Receipt',901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2900.00,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1010,7986,40759,8010,2,902,'App\\Models\\Receipt',902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2900.00,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1011,7986,40759,8010,2,903,'App\\Models\\Receipt',903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2500.01,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1012,7986,40759,8010,2,904,'App\\Models\\Receipt',904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2600.00,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1013,7986,40759,8010,2,905,'App\\Models\\Receipt',905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1649.99,NULL,NULL,1,'2023-01-11 12:10:13','2023-01-11 12:10:13',NULL),(1014,7986,40759,8010,2,906,'App\\Models\\Receipt',906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2750.00,NULL,NULL,1,'2023-01-11 12:10:14','2023-01-11 12:10:14',NULL),(1015,7986,40759,8010,2,907,'App\\Models\\Receipt',907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1849.99,NULL,NULL,1,'2023-01-11 12:10:14','2023-01-11 12:10:14',NULL),(1016,7986,40759,8010,2,908,'App\\Models\\Receipt',908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2900.00,NULL,NULL,1,'2023-01-11 12:10:14','2023-01-11 12:10:14',NULL),(1017,7986,40759,8010,2,909,'App\\Models\\Receipt',909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',44550.00,NULL,NULL,1,'2023-01-11 12:13:49','2023-01-11 12:13:49',NULL),(1018,7986,40759,8010,2,910,'App\\Models\\Receipt',910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',42829.99,NULL,NULL,1,'2023-01-11 12:14:59','2023-01-11 12:14:59',NULL),(1019,7986,40759,8010,2,911,'App\\Models\\Receipt',911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',32310.00,NULL,NULL,1,'2023-01-11 12:15:42','2023-01-11 12:15:42',NULL),(1020,7986,40759,8010,2,912,'App\\Models\\Receipt',912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',37760.00,NULL,NULL,1,'2023-01-11 12:16:31','2023-01-11 12:16:31',NULL);
INSERT INTO `balance_libro` VALUES (1021,7986,40721,3016,2,913,'App\\Models\\Receipt',913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',153373.55,NULL,NULL,1,'2023-01-11 12:22:22','2023-01-11 12:22:22',NULL),(1022,7986,40721,3016,2,914,'App\\Models\\Receipt',914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',142603.34,NULL,NULL,1,'2023-01-11 12:22:22','2023-01-11 12:22:22',NULL),(1023,7986,40721,3016,2,915,'App\\Models\\Receipt',915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',50450.00,NULL,NULL,1,'2023-01-11 12:22:22','2023-01-11 12:22:22',NULL),(1024,7986,40721,3016,2,916,'App\\Models\\Receipt',916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',50450.00,NULL,NULL,1,'2023-01-11 12:22:22','2023-01-11 12:22:22',NULL),(1025,7986,40721,3016,2,917,'App\\Models\\Receipt',917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',50450.00,NULL,NULL,1,'2023-01-11 12:22:22','2023-01-11 12:22:22',NULL),(1026,7986,40721,3016,2,918,'App\\Models\\Receipt',918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',19833.00,NULL,NULL,1,'2023-01-11 12:22:22','2023-01-11 12:22:22',NULL),(1027,7986,40721,3016,2,919,'App\\Models\\Receipt',919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',20551.00,NULL,NULL,1,'2023-01-11 12:22:22','2023-01-11 12:22:22',NULL),(1028,7986,40721,3016,2,920,'App\\Models\\Receipt',920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',17844.00,NULL,NULL,1,'2023-01-11 12:22:22','2023-01-11 12:22:22',NULL),(1029,7986,40721,3016,2,921,'App\\Models\\Receipt',921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',226793.93,NULL,NULL,1,'2023-01-11 12:22:23','2023-01-11 12:22:23',NULL),(1030,7986,40721,3016,2,922,'App\\Models\\Receipt',922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',239310.17,NULL,NULL,1,'2023-01-11 12:22:23','2023-01-11 12:22:23',NULL),(1031,7986,40721,3016,2,923,'App\\Models\\Receipt',923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',20186.00,NULL,NULL,1,'2023-01-11 12:22:23','2023-01-11 12:22:23',NULL),(1032,7986,40721,3016,2,924,'App\\Models\\Receipt',924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',18799.00,NULL,NULL,1,'2023-01-11 12:22:23','2023-01-11 12:22:23',NULL),(1033,7986,40721,3016,2,925,'App\\Models\\Receipt',925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',19655.00,NULL,NULL,1,'2023-01-11 12:22:23','2023-01-11 12:22:23',NULL),(1034,7986,40721,3016,2,926,'App\\Models\\Receipt',926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',223889.93,NULL,NULL,1,'2023-01-11 12:22:23','2023-01-11 12:22:23',NULL),(1035,7986,40721,3016,2,927,'App\\Models\\Receipt',927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',175200.14,NULL,NULL,1,'2023-01-11 12:22:23','2023-01-11 12:22:23',NULL),(1036,7986,40721,3016,2,928,'App\\Models\\Receipt',928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',17655.00,NULL,NULL,1,'2023-01-11 12:22:23','2023-01-11 12:22:23',NULL),(1037,7986,40721,3016,2,929,'App\\Models\\Receipt',929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',19877.00,NULL,NULL,1,'2023-01-11 12:22:23','2023-01-11 12:22:23',NULL),(1038,7986,40776,17352,2,930,'App\\Models\\Receipt',930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',474052.34,NULL,NULL,1,'2023-01-11 12:26:32','2023-01-11 12:26:32',NULL),(1039,7986,40720,1517,3,931,'App\\Models\\Receipt',931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',91630.00,NULL,NULL,1,'2023-01-12 09:17:28','2023-01-12 09:17:28',NULL),(1040,7986,40721,3016,3,932,'App\\Models\\Receipt',932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',51213.18,NULL,NULL,1,'2023-01-12 10:00:59','2023-01-19 10:10:39','2023-01-19 10:10:39'),(1041,7986,40721,3016,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1909.08,NULL,NULL,1,'2023-01-12 10:00:59','2023-01-19 10:26:25','2023-01-19 10:26:25');
INSERT INTO `balance_libro` VALUES (1042,7986,40721,3016,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',13169.87,NULL,NULL,1,'2023-01-12 10:00:59','2023-01-19 10:26:51','2023-01-19 10:26:51'),(1043,7986,40721,3016,3,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',44773.97,NULL,NULL,1,'2023-01-12 10:00:59','2023-01-19 10:27:58','2023-01-19 10:27:58'),(1044,7986,40721,3016,3,936,'App\\Models\\Receipt',936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',31310.00,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-12 10:01:00',NULL),(1045,7986,40721,3016,3,937,'App\\Models\\Receipt',937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',14190.02,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-12 10:01:00',NULL),(1046,7986,40721,3016,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',24144.56,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-19 10:28:32','2023-01-19 10:28:32'),(1047,7986,40721,3016,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',26813.32,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-19 10:29:42','2023-01-19 10:29:42'),(1048,7986,40721,3016,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',16943.85,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-19 10:30:15','2023-01-19 10:30:15'),(1049,7986,40721,3016,3,941,'App\\Models\\Receipt',941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',38295.19,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-12 10:01:00',NULL),(1050,7986,40721,3016,3,942,'App\\Models\\Receipt',942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',5944.21,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-20 12:44:55','2023-01-20 12:44:55'),(1051,7986,40721,3016,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2342.76,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-19 10:31:29','2023-01-19 10:31:29'),(1052,7986,40721,3016,3,944,'App\\Models\\Receipt',944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',11171.91,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-12 10:01:00',NULL),(1053,7986,40721,3016,3,945,'App\\Models\\Receipt',945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',3516.70,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-12 10:01:00',NULL),(1054,7986,40721,3016,3,946,'App\\Models\\Receipt',946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',9966.24,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-12 10:01:00',NULL),(1055,7986,40721,3016,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',27496.42,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-19 10:32:24','2023-01-19 10:32:24'),(1056,7986,40721,3016,3,948,'App\\Models\\Receipt',948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',35111.62,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-12 10:01:00',NULL),(1057,7986,40721,3016,3,949,'App\\Models\\Receipt',949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',23954.42,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-20 12:45:49','2023-01-20 12:45:49'),(1058,7986,40721,3016,3,950,'App\\Models\\Receipt',950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',24600.34,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-19 10:10:58','2023-01-19 10:10:58'),(1059,7986,40721,3016,3,951,'App\\Models\\Receipt',951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',19530.00,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-12 10:01:00',NULL),(1060,7986,40721,3016,3,952,'App\\Models\\Receipt',952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',20775.32,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-12 10:01:00',NULL),(1061,7986,40721,3016,3,953,'App\\Models\\Receipt',953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-10','2022-12-10',30587.84,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-19 10:11:08','2023-01-19 10:11:08');
INSERT INTO `balance_libro` VALUES (1062,7986,40721,3016,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',12955.37,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-19 10:33:12','2023-01-19 10:33:12'),(1063,7986,40721,3016,3,955,'App\\Models\\Receipt',955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',16471.28,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-12 10:01:00',NULL),(1064,7986,40721,3016,3,956,'App\\Models\\Receipt',956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',8959.69,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-12 10:01:00',NULL),(1065,7986,40721,3016,3,957,'App\\Models\\Receipt',957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',29327.18,NULL,NULL,1,'2023-01-12 10:01:00','2023-01-12 10:01:00',NULL),(1066,7986,40721,3016,3,958,'App\\Models\\Receipt',958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',33809.84,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-12 10:01:01',NULL),(1067,7986,40721,3016,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',33461.54,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-19 10:34:05','2023-01-19 10:34:05'),(1068,7986,40721,3016,3,960,'App\\Models\\Receipt',960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',13439.35,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-19 10:11:24','2023-01-19 10:11:24'),(1069,7986,40721,3016,3,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',4594.50,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-19 10:35:35','2023-01-19 10:35:35'),(1070,7986,40721,3016,3,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',16091.92,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-19 10:34:41','2023-01-19 10:34:41'),(1071,7986,40721,3016,3,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',23134.80,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-19 10:35:05','2023-01-19 10:35:05'),(1072,7986,40721,3016,3,964,'App\\Models\\Receipt',964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',31090.00,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-12 10:01:01',NULL),(1073,7986,40721,3016,3,965,'App\\Models\\Receipt',965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',5483.99,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-12 10:01:01',NULL),(1074,7986,40721,3016,3,966,'App\\Models\\Receipt',966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',39199.88,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-12 10:01:01',NULL),(1075,7986,40721,3016,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',7064.07,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-19 10:36:07','2023-01-19 10:36:07'),(1076,7986,40721,3016,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',8646.50,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-19 10:36:57','2023-01-19 10:36:57'),(1077,7986,40721,3016,3,969,'App\\Models\\Receipt',969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',93833.61,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-12 10:01:01',NULL),(1078,7986,40721,3016,3,970,'App\\Models\\Receipt',970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',46048.68,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-12 10:01:01',NULL),(1079,7986,40721,3016,3,971,'App\\Models\\Receipt',971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',5696.39,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-12 10:01:01',NULL),(1080,7986,40721,3016,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',26755.11,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-19 10:38:36','2023-01-19 10:38:36'),(1081,7986,40721,3016,3,973,'App\\Models\\Receipt',973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',13779.48,NULL,NULL,1,'2023-01-12 10:01:01','2023-01-12 10:01:01',NULL);
INSERT INTO `balance_libro` VALUES (1082,7986,40721,3016,3,974,'App\\Models\\Receipt',974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',24724.80,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-20 12:49:47','2023-01-20 12:49:47'),(1083,7986,40721,3016,3,975,'App\\Models\\Receipt',975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',12587.93,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-12 10:01:02',NULL),(1084,7986,40721,3016,3,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',14760.16,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-19 10:39:55','2023-01-19 10:39:55'),(1085,7986,40721,3016,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',7639.12,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-19 10:39:26','2023-01-19 10:39:26'),(1086,7986,40721,3016,3,978,'App\\Models\\Receipt',978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',24724.80,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-20 12:49:30','2023-01-20 12:49:30'),(1087,7986,40721,3016,3,979,'App\\Models\\Receipt',979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',23954.42,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-20 12:49:09','2023-01-20 12:49:09'),(1088,7986,40721,3016,3,980,'App\\Models\\Receipt',980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',35550.00,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-12 10:01:02',NULL),(1089,7986,40721,3016,3,981,'App\\Models\\Receipt',981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',24816.67,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-12 10:01:02',NULL),(1090,7986,40721,3016,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',8766.23,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-19 10:40:26','2023-01-19 10:40:26'),(1091,7986,40721,3016,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',5276.55,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-19 10:40:59','2023-01-19 10:40:59'),(1092,7986,40721,3016,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',5511.57,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-19 10:42:25','2023-01-19 10:42:25'),(1093,7986,40721,3016,3,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',45820.99,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-19 10:41:45','2023-01-19 10:41:45'),(1094,7986,40721,3016,3,986,'App\\Models\\Receipt',986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',9746.97,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-12 10:01:02',NULL),(1095,7986,40721,3016,3,987,'App\\Models\\Receipt',987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',11300.76,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-12 10:01:02',NULL),(1096,7986,40721,3016,3,988,'App\\Models\\Receipt',988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',5338.40,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-12 10:01:02',NULL),(1097,7986,40721,3016,3,989,'App\\Models\\Receipt',989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',3690.00,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-19 10:11:41','2023-01-19 10:11:41'),(1098,7986,40721,3016,3,990,'App\\Models\\Receipt',990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',19079.28,NULL,NULL,1,'2023-01-12 10:01:02','2023-01-19 10:12:11','2023-01-19 10:12:11'),(1099,7986,40721,3016,3,991,'App\\Models\\Receipt',991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',9492.13,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-12 10:01:03',NULL),(1100,7986,40721,3016,3,992,'App\\Models\\Receipt',992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',27645.94,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-12 10:01:03',NULL),(1101,7986,40721,3016,3,993,'App\\Models\\Receipt',993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',26758.87,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-12 10:01:03',NULL);
INSERT INTO `balance_libro` VALUES (1102,7986,40721,3016,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',220712.30,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-19 10:52:06','2023-01-19 10:52:06'),(1103,7986,40721,3016,3,995,'App\\Models\\Receipt',995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',10050.01,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-19 10:12:25','2023-01-19 10:12:25'),(1104,7986,40721,3016,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',10697.82,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-19 10:51:31','2023-01-19 10:51:31'),(1105,7986,40721,3016,3,997,'App\\Models\\Receipt',997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',40827.00,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-19 10:12:36','2023-01-19 10:12:36'),(1106,7986,40721,3016,3,998,'App\\Models\\Receipt',998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',6975.00,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-12 10:01:03',NULL),(1107,7986,40721,3016,3,999,'App\\Models\\Receipt',999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',23100.00,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-12 10:01:03',NULL),(1108,7986,40721,3016,3,1000,'App\\Models\\Receipt',1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',210899.66,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-19 10:12:48','2023-01-19 10:12:48'),(1109,7986,40721,3016,3,1001,'App\\Models\\Receipt',1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',26205.15,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-12 10:01:03',NULL),(1110,7986,40721,3016,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',35181.68,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-19 10:56:46','2023-01-19 10:56:46'),(1111,7986,40721,3016,3,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',12499.91,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-19 10:57:15','2023-01-19 10:57:15'),(1112,7986,40721,3016,3,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',44242.30,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-19 10:56:10','2023-01-19 10:56:10'),(1113,7986,40721,3016,3,1005,'App\\Models\\Receipt',1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',8672.56,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-19 10:13:04','2023-01-19 10:13:04'),(1114,7986,40721,3016,3,1006,'App\\Models\\Receipt',1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',19079.28,NULL,NULL,1,'2023-01-12 10:01:03','2023-01-19 10:13:21','2023-01-19 10:13:21'),(1115,7986,40720,1517,3,1007,'App\\Models\\Receipt',1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',11300.00,NULL,NULL,1,'2023-01-12 10:13:09','2023-01-12 10:13:09',NULL),(1116,7986,40720,1517,3,1008,'App\\Models\\Receipt',1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',22520.00,NULL,NULL,1,'2023-01-12 10:14:35','2023-01-12 10:14:35',NULL),(1117,7986,40720,1517,3,1009,'App\\Models\\Receipt',1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',9000.98,NULL,NULL,1,'2023-01-12 10:17:11','2023-01-12 10:17:11',NULL),(1118,7986,40720,1517,3,1010,'App\\Models\\Receipt',1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',3999.95,NULL,NULL,1,'2023-01-12 10:17:54','2023-01-12 10:17:54',NULL),(1119,7986,40720,1517,3,1011,'App\\Models\\Receipt',1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',20893.37,NULL,NULL,1,'2023-01-12 10:20:16','2023-01-12 10:20:16',NULL),(1120,7986,40720,1517,3,1012,'App\\Models\\Receipt',1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',7100.40,NULL,NULL,1,'2023-01-12 10:21:10','2023-01-12 10:21:10',NULL),(1121,7986,40720,1517,3,1013,'App\\Models\\Receipt',1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1850.00,NULL,NULL,1,'2023-01-12 10:22:16','2023-01-12 10:22:16',NULL);
INSERT INTO `balance_libro` VALUES (1122,7986,40776,17352,3,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',850000.00,NULL,NULL,1,'2023-01-12 10:29:09','2023-01-12 10:32:10','2023-01-12 10:32:10'),(1123,7986,40776,17352,3,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',920546.29,NULL,NULL,1,'2023-01-12 10:29:09','2023-01-12 10:32:54','2023-01-12 10:32:54'),(1124,7986,40776,17352,3,1016,'App\\Models\\Receipt',1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',5900.00,NULL,NULL,1,'2023-01-12 10:29:09','2023-01-12 10:29:09',NULL),(1125,7986,40776,17352,3,1017,'App\\Models\\Receipt',1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',27400.00,NULL,NULL,1,'2023-01-12 10:29:09','2023-01-12 10:29:09',NULL),(1126,7986,40776,17352,3,1018,'App\\Models\\Receipt',1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',5700.00,NULL,NULL,1,'2023-01-12 10:29:09','2023-01-12 10:29:09',NULL),(1127,7986,40776,17352,3,1019,'App\\Models\\Receipt',1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2200.00,NULL,NULL,1,'2023-01-12 10:29:09','2023-01-12 10:29:09',NULL),(1128,7986,40776,17352,3,1020,'App\\Models\\Receipt',1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',119790.00,NULL,NULL,1,'2023-01-12 10:31:36','2023-01-12 10:31:36',NULL),(1129,7986,40776,17352,3,1014,'App\\Models\\Receipt',1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',850000.00,NULL,NULL,1,'2023-01-12 10:32:10','2023-01-12 10:32:10',NULL),(1130,7986,40776,17352,3,1015,'App\\Models\\Receipt',1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',920546.29,NULL,NULL,1,'2023-01-12 10:32:54','2023-01-12 10:32:54',NULL),(1131,7986,40776,17352,3,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',22009.04,NULL,NULL,1,'2023-01-12 10:38:06','2023-01-12 10:42:58','2023-01-12 10:42:58'),(1132,7986,40776,17352,3,1022,'App\\Models\\Receipt',1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',4000.01,NULL,NULL,1,'2023-01-12 10:40:04','2023-01-12 10:40:04',NULL),(1133,7986,40776,17352,3,1023,'App\\Models\\Receipt',1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',5000.08,NULL,NULL,1,'2023-01-12 10:41:19','2023-01-12 10:41:19',NULL),(1134,7986,40776,17352,3,1024,'App\\Models\\Receipt',1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',2000.00,NULL,NULL,1,'2023-01-12 10:42:30','2023-01-12 10:42:30',NULL),(1135,7986,40776,17352,3,1021,'App\\Models\\Receipt',1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',22009.04,NULL,NULL,1,'2023-01-12 10:42:58','2023-01-12 10:42:58',NULL),(1136,7986,40776,17352,3,1025,'App\\Models\\Receipt',1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',8800.00,NULL,NULL,1,'2023-01-12 10:45:06','2023-01-12 10:45:06',NULL),(1137,7986,40776,17352,3,1026,'App\\Models\\Receipt',1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',3999.98,NULL,NULL,1,'2023-01-12 10:48:19','2023-01-12 10:48:19',NULL),(1138,7986,40776,17352,3,1027,'App\\Models\\Receipt',1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',24000.00,NULL,NULL,1,'2023-01-12 10:49:30','2023-01-12 10:49:30',NULL),(1139,7986,40776,17352,3,1028,'App\\Models\\Receipt',1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4793.99,NULL,NULL,1,'2023-01-12 11:22:27','2023-01-12 11:22:27',NULL),(1140,7986,40776,17352,3,1029,'App\\Models\\Receipt',1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',75.55,NULL,NULL,1,'2023-01-12 11:23:41','2023-01-12 11:23:41',NULL),(1141,7986,40759,8010,3,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1000.00,NULL,NULL,1,'2023-01-17 10:46:17','2023-01-17 10:50:11','2023-01-17 10:50:11');
INSERT INTO `balance_libro` VALUES (1142,7986,40759,8010,3,1031,'App\\Models\\Receipt',1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-04','2022-12-04',22065.94,NULL,NULL,1,'2023-01-17 10:46:17','2023-01-17 10:47:39','2023-01-17 10:47:39'),(1143,7986,40759,8010,3,1032,'App\\Models\\Receipt',1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',5300.00,NULL,NULL,1,'2023-01-17 10:46:17','2023-01-17 10:46:17',NULL),(1144,7986,40759,8010,3,1033,'App\\Models\\Receipt',1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',4745.02,NULL,NULL,1,'2023-01-17 10:46:17','2023-01-17 10:46:17',NULL),(1145,7986,40759,8010,3,1034,'App\\Models\\Receipt',1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',492.46,NULL,NULL,1,'2023-01-17 10:46:17','2023-01-17 10:46:17',NULL),(1146,7986,40759,8010,3,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',82092.79,NULL,NULL,1,'2023-01-17 10:46:17','2023-01-17 10:52:19','2023-01-17 10:52:19'),(1147,7986,40759,8010,3,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',154957.17,NULL,NULL,1,'2023-01-17 10:46:17','2023-01-17 10:52:57','2023-01-17 10:52:57'),(1148,7986,40759,8010,3,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',12625.09,NULL,NULL,1,'2023-01-17 10:46:17','2023-01-17 10:54:37','2023-01-17 10:54:37'),(1149,7986,40759,8010,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',8003.72,NULL,NULL,1,'2023-01-17 10:46:17','2023-01-17 10:55:46','2023-01-17 10:55:46'),(1150,7986,40759,8010,3,1039,'App\\Models\\Receipt',1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',3724.43,NULL,NULL,1,'2023-01-17 10:46:18','2023-01-17 10:46:18',NULL),(1151,7986,40759,8010,3,1040,'App\\Models\\Receipt',1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',439.28,NULL,NULL,1,'2023-01-17 10:46:18','2023-01-17 10:46:18',NULL),(1152,7986,40759,8010,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',62280.76,NULL,NULL,1,'2023-01-17 10:46:18','2023-01-17 10:58:29','2023-01-17 10:58:29'),(1153,7986,40759,8010,3,1042,'App\\Models\\Receipt',1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',679.92,NULL,NULL,1,'2023-01-17 10:46:18','2023-01-17 10:48:16','2023-01-17 10:48:16'),(1154,7986,40759,8010,3,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',14475.07,NULL,NULL,1,'2023-01-17 10:46:18','2023-01-17 11:00:56','2023-01-17 11:00:56'),(1155,7986,40759,8010,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',99264.60,NULL,NULL,1,'2023-01-17 10:46:18','2023-01-17 11:02:03','2023-01-17 11:02:03'),(1156,7986,40759,8010,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',22827.09,NULL,NULL,1,'2023-01-17 10:46:18','2023-01-17 11:02:35','2023-01-17 11:02:35'),(1157,7986,40759,8010,3,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',42572.61,NULL,NULL,1,'2023-01-17 10:46:18','2023-01-17 11:05:12','2023-01-17 11:05:12'),(1158,7986,40759,8010,3,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',80407.51,NULL,NULL,1,'2023-01-17 10:46:18','2023-01-17 11:05:38','2023-01-17 11:05:38'),(1159,7986,40759,8010,3,1048,'App\\Models\\Receipt',1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',2153.55,NULL,NULL,1,'2023-01-17 10:46:18','2023-01-17 10:46:18',NULL),(1160,7986,40759,8010,3,1049,'App\\Models\\Receipt',1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',33.86,NULL,NULL,1,'2023-01-17 10:46:18','2023-01-17 10:46:18',NULL),(1161,7986,40759,8010,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',43759.67,NULL,NULL,1,'2023-01-17 10:46:18','2023-01-17 11:06:03','2023-01-17 11:06:03');
INSERT INTO `balance_libro` VALUES (1162,7986,40759,8010,3,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',67613.19,NULL,NULL,1,'2023-01-17 10:46:18','2023-01-17 11:07:52','2023-01-17 11:07:52'),(1163,7986,40759,8010,3,1052,'App\\Models\\Receipt',1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',214476.64,NULL,NULL,1,'2023-01-17 10:46:19','2023-01-17 10:46:19',NULL),(1164,7986,40759,8010,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',10390.14,NULL,NULL,1,'2023-01-17 10:46:19','2023-01-17 11:08:19','2023-01-17 11:08:19'),(1165,7986,40759,8010,3,1054,'App\\Models\\Receipt',1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2190.00,NULL,NULL,1,'2023-01-17 10:46:19','2023-01-17 10:47:13','2023-01-17 10:47:13'),(1166,7986,40759,8010,3,1030,'App\\Models\\Receipt',1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',1000.00,NULL,NULL,1,'2023-01-17 10:50:11','2023-01-17 10:50:11',NULL),(1167,7986,40759,8010,3,1035,'App\\Models\\Receipt',1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',82092.79,NULL,NULL,1,'2023-01-17 10:52:19','2023-01-17 10:52:19',NULL),(1168,7986,40759,8010,3,1036,'App\\Models\\Receipt',1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',154957.17,NULL,NULL,1,'2023-01-17 10:52:57','2023-01-17 10:52:57',NULL),(1169,7986,40759,8010,3,1037,'App\\Models\\Receipt',1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',12625.09,NULL,NULL,1,'2023-01-17 10:54:37','2023-01-17 10:54:37',NULL),(1170,7986,40759,8010,3,1038,'App\\Models\\Receipt',1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',8003.73,NULL,NULL,1,'2023-01-17 10:55:46','2023-01-17 10:55:46',NULL),(1171,7986,40759,8010,3,1041,'App\\Models\\Receipt',1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',62280.76,NULL,NULL,1,'2023-01-17 10:58:29','2023-01-17 10:58:29',NULL),(1172,7986,40759,8010,3,1043,'App\\Models\\Receipt',1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',14475.07,NULL,NULL,1,'2023-01-17 11:00:56','2023-01-17 11:00:56',NULL),(1173,7986,40759,8010,3,1044,'App\\Models\\Receipt',1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',99264.60,NULL,NULL,1,'2023-01-17 11:02:03','2023-01-17 11:02:03',NULL),(1174,7986,40759,8010,3,1045,'App\\Models\\Receipt',1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',22827.09,NULL,NULL,1,'2023-01-17 11:02:35','2023-01-17 11:02:35',NULL),(1175,7986,40759,8010,3,1046,'App\\Models\\Receipt',1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',42572.61,NULL,NULL,1,'2023-01-17 11:05:12','2023-01-17 11:05:12',NULL),(1176,7986,40759,8010,3,1047,'App\\Models\\Receipt',1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',80407.51,NULL,NULL,1,'2023-01-17 11:05:38','2023-01-17 11:05:38',NULL),(1177,7986,40759,8010,3,1050,'App\\Models\\Receipt',1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',43759.67,NULL,NULL,1,'2023-01-17 11:06:03','2023-01-17 11:06:03',NULL),(1178,7986,40759,8010,3,1051,'App\\Models\\Receipt',1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',67613.19,NULL,NULL,1,'2023-01-17 11:07:52','2023-01-17 11:07:52',NULL),(1179,7986,40759,8010,3,1053,'App\\Models\\Receipt',1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',10390.14,NULL,NULL,1,'2023-01-17 11:08:19','2023-01-17 11:08:19',NULL),(1180,7986,40759,8010,3,1055,'App\\Models\\Receipt',1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',8060.68,NULL,NULL,1,'2023-01-18 11:39:50','2023-01-18 11:39:50',NULL),(1181,7986,40759,8010,8,1056,'App\\Models\\Receipt',1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',691.79,NULL,NULL,1,'2023-01-18 11:40:36','2023-01-18 11:40:36',NULL);
INSERT INTO `balance_libro` VALUES (1182,7986,40721,3016,3,1057,'App\\Models\\Receipt',1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3141.17,NULL,NULL,1,'2023-01-18 11:48:08','2023-01-18 11:48:08',NULL),(1183,7986,40721,3016,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4572.25,NULL,NULL,1,'2023-01-18 11:48:38','2023-01-19 11:44:50','2023-01-19 11:44:50'),(1184,7986,40721,3016,3,1059,'App\\Models\\Receipt',1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',5451.86,NULL,NULL,1,'2023-01-18 11:49:06','2023-01-18 11:49:06',NULL),(1185,7986,40721,3016,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',17448.31,NULL,NULL,1,'2023-01-18 11:51:11','2023-01-19 12:06:42','2023-01-19 12:06:42'),(1186,7986,40721,3016,3,1061,'App\\Models\\Receipt',1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2710.12,NULL,NULL,1,'2023-01-18 11:51:32','2023-01-18 11:51:32',NULL),(1187,7986,40721,3016,3,1062,'App\\Models\\Receipt',1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',46568.59,NULL,NULL,1,'2023-01-18 12:04:50','2023-01-18 12:04:50',NULL),(1188,7986,40721,3016,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',23370.29,NULL,NULL,1,'2023-01-19 10:21:23','2023-01-19 12:06:55','2023-01-19 12:06:55'),(1189,7986,40721,3016,3,1064,'App\\Models\\Receipt',1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-04','2022-11-04',73830.00,NULL,NULL,1,'2023-01-19 10:24:30','2023-01-19 10:24:30',NULL),(1190,7986,40721,3016,3,933,'App\\Models\\Receipt',933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',1909.08,NULL,NULL,1,'2023-01-19 10:26:25','2023-01-19 10:26:25',NULL),(1191,7986,40721,3016,3,934,'App\\Models\\Receipt',934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',13169.87,NULL,NULL,1,'2023-01-19 10:26:51','2023-01-19 10:26:51',NULL),(1192,7986,40721,3016,3,935,'App\\Models\\Receipt',935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',44773.97,NULL,NULL,1,'2023-01-19 10:27:58','2023-01-19 10:27:58',NULL),(1193,7986,40721,3016,3,938,'App\\Models\\Receipt',938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',24144.56,NULL,NULL,1,'2023-01-19 10:28:32','2023-01-19 10:28:32',NULL),(1194,7986,40721,3016,3,939,'App\\Models\\Receipt',939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',26813.32,NULL,NULL,1,'2023-01-19 10:29:42','2023-01-19 10:29:42',NULL),(1195,7986,40721,3016,3,940,'App\\Models\\Receipt',940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-03','2022-12-03',16943.85,NULL,NULL,1,'2023-01-19 10:30:15','2023-01-19 10:30:15',NULL),(1196,7986,40721,3016,3,943,'App\\Models\\Receipt',943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',2342.77,NULL,NULL,1,'2023-01-19 10:31:29','2023-01-19 10:31:29',NULL),(1197,7986,40721,3016,3,947,'App\\Models\\Receipt',947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',27496.42,NULL,NULL,1,'2023-01-19 10:32:24','2023-01-19 10:32:24',NULL),(1198,7986,40721,3016,3,954,'App\\Models\\Receipt',954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',12955.37,NULL,NULL,1,'2023-01-19 10:33:12','2023-01-19 10:33:12',NULL),(1199,7986,40721,3016,3,959,'App\\Models\\Receipt',959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',33461.54,NULL,NULL,1,'2023-01-19 10:34:05','2023-01-19 10:34:05',NULL),(1200,7986,40721,3016,3,962,'App\\Models\\Receipt',962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',16091.92,NULL,NULL,1,'2023-01-19 10:34:41','2023-01-19 10:34:41',NULL),(1201,7986,40721,3016,3,963,'App\\Models\\Receipt',963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',23134.80,NULL,NULL,1,'2023-01-19 10:35:05','2023-01-19 10:35:05',NULL),(1202,7986,40721,3016,3,961,'App\\Models\\Receipt',961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',4594.50,NULL,NULL,1,'2023-01-19 10:35:35','2023-01-19 10:35:35',NULL);
INSERT INTO `balance_libro` VALUES (1203,7986,40721,3016,3,967,'App\\Models\\Receipt',967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',7064.07,NULL,NULL,1,'2023-01-19 10:36:07','2023-01-19 10:36:07',NULL),(1204,7986,40721,3016,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',8646.50,NULL,NULL,1,'2023-01-19 10:36:57','2023-01-19 10:37:26','2023-01-19 10:37:26'),(1205,7986,40721,3016,3,968,'App\\Models\\Receipt',968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-17','2022-12-17',8646.50,NULL,NULL,1,'2023-01-19 10:37:26','2023-01-19 10:37:26',NULL),(1206,7986,40721,3016,3,972,'App\\Models\\Receipt',972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',26755.10,NULL,NULL,1,'2023-01-19 10:38:36','2023-01-19 10:38:36',NULL),(1207,7986,40721,3016,3,977,'App\\Models\\Receipt',977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',7639.12,NULL,NULL,1,'2023-01-19 10:39:26','2023-01-19 10:39:26',NULL),(1208,7986,40721,3016,3,976,'App\\Models\\Receipt',976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',14760.16,NULL,NULL,1,'2023-01-19 10:39:55','2023-01-19 10:39:55',NULL),(1209,7986,40721,3016,3,982,'App\\Models\\Receipt',982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',8766.23,NULL,NULL,1,'2023-01-19 10:40:26','2023-01-19 10:40:26',NULL),(1210,7986,40721,3016,3,983,'App\\Models\\Receipt',983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',5276.55,NULL,NULL,1,'2023-01-19 10:40:59','2023-01-19 10:40:59',NULL),(1211,7986,40721,3016,3,985,'App\\Models\\Receipt',985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',45820.99,NULL,NULL,1,'2023-01-19 10:41:45','2023-01-19 10:41:45',NULL),(1212,7986,40721,3016,3,984,'App\\Models\\Receipt',984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',5511.57,NULL,NULL,1,'2023-01-19 10:42:25','2023-01-19 10:42:25',NULL),(1213,7986,40721,3016,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',26731.70,NULL,NULL,1,'2023-01-19 10:50:55','2023-01-20 12:00:20','2023-01-20 12:00:20'),(1214,7986,40721,3016,3,996,'App\\Models\\Receipt',996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',10697.82,NULL,NULL,1,'2023-01-19 10:51:31','2023-01-19 10:51:31',NULL),(1215,7986,40721,3016,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',221206.59,NULL,NULL,1,'2023-01-19 10:52:06','2023-01-19 10:54:00','2023-01-19 10:54:00'),(1216,7986,40721,3016,3,994,'App\\Models\\Receipt',994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',220712.30,NULL,NULL,1,'2023-01-19 10:54:00','2023-01-19 10:54:00',NULL),(1217,7986,40721,3016,3,1004,'App\\Models\\Receipt',1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',44242.30,NULL,NULL,1,'2023-01-19 10:56:10','2023-01-19 10:56:10',NULL),(1218,7986,40721,3016,3,1002,'App\\Models\\Receipt',1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',35181.68,NULL,NULL,1,'2023-01-19 10:56:46','2023-01-19 10:56:46',NULL),(1219,7986,40721,3016,3,1003,'App\\Models\\Receipt',1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',12499.91,NULL,NULL,1,'2023-01-19 10:57:15','2023-01-19 10:57:15',NULL),(1220,7986,40721,3016,8,1066,'App\\Models\\Receipt',1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',16125.53,NULL,NULL,1,'2023-01-19 11:00:47','2023-01-19 11:00:47',NULL),(1221,7986,40721,3016,8,1067,'App\\Models\\Receipt',1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',2670.25,NULL,NULL,1,'2023-01-19 11:01:00','2023-01-19 11:01:00',NULL),(1222,7986,40721,3016,3,1058,'App\\Models\\Receipt',1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4251.17,NULL,NULL,1,'2023-01-19 11:44:50','2023-01-19 11:44:50',NULL),(1223,7986,40721,3016,7,1068,'App\\Models\\Receipt',1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',4.65,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL);
INSERT INTO `balance_libro` VALUES (1224,7986,40721,3016,7,1069,'App\\Models\\Receipt',1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',6.33,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1225,7986,40721,3016,7,1070,'App\\Models\\Receipt',1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',7.13,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1226,7986,40721,3016,7,1071,'App\\Models\\Receipt',1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',7.15,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1227,7986,40721,3016,7,1072,'App\\Models\\Receipt',1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',8.55,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1228,7986,40721,3016,7,1073,'App\\Models\\Receipt',1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',9.71,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1229,7986,40721,3016,7,1074,'App\\Models\\Receipt',1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',10.86,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1230,7986,40721,3016,7,1075,'App\\Models\\Receipt',1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',12.97,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1231,7986,40721,3016,7,1076,'App\\Models\\Receipt',1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',14.29,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1232,7986,40721,3016,7,1077,'App\\Models\\Receipt',1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',15.40,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1233,7986,40721,3016,7,1078,'App\\Models\\Receipt',1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',16.26,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1234,7986,40721,3016,7,1079,'App\\Models\\Receipt',1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',17.24,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1235,7986,40721,3016,7,1080,'App\\Models\\Receipt',1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',19.36,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1236,7986,40721,3016,7,1081,'App\\Models\\Receipt',1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',22.37,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1237,7986,40721,3016,7,1082,'App\\Models\\Receipt',1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',23.83,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1238,7986,40721,3016,7,1083,'App\\Models\\Receipt',1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',25.84,NULL,NULL,1,'2023-01-19 11:52:46','2023-01-19 11:52:46',NULL),(1239,7986,40721,3016,7,1084,'App\\Models\\Receipt',1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',25.91,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1240,7986,40721,3016,7,1085,'App\\Models\\Receipt',1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',26.93,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1241,7986,40721,3016,7,1086,'App\\Models\\Receipt',1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',30.14,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1242,7986,40721,3016,7,1087,'App\\Models\\Receipt',1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',31.70,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1243,7986,40721,3016,7,1088,'App\\Models\\Receipt',1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',31.91,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1244,7986,40721,3016,7,1089,'App\\Models\\Receipt',1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',37.31,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL);
INSERT INTO `balance_libro` VALUES (1245,7986,40721,3016,7,1090,'App\\Models\\Receipt',1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',37.84,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1246,7986,40721,3016,7,1091,'App\\Models\\Receipt',1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',41.70,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1247,7986,40721,3016,7,1092,'App\\Models\\Receipt',1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',42.73,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1248,7986,40721,3016,7,1093,'App\\Models\\Receipt',1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',43.99,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1249,7986,40721,3016,7,1094,'App\\Models\\Receipt',1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',44.72,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1250,7986,40721,3016,7,1095,'App\\Models\\Receipt',1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',45.59,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1251,7986,40721,3016,7,1096,'App\\Models\\Receipt',1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',48.42,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1252,7986,40721,3016,7,1097,'App\\Models\\Receipt',1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-09','2022-12-09',50.25,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1253,7986,40721,3016,7,1098,'App\\Models\\Receipt',1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',50.42,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1254,7986,40721,3016,7,1099,'App\\Models\\Receipt',1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',51.51,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1255,7986,40721,3016,7,1100,'App\\Models\\Receipt',1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',52.51,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1256,7986,40721,3016,7,1101,'App\\Models\\Receipt',1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',55.12,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1257,7986,40721,3016,7,1102,'App\\Models\\Receipt',1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-16','2022-12-16',55.99,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1258,7986,40721,3016,7,1103,'App\\Models\\Receipt',1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',58.74,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1259,7986,40721,3016,7,1104,'App\\Models\\Receipt',1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',60.96,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1260,7986,40721,3016,7,1105,'App\\Models\\Receipt',1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',61.75,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1261,7986,40721,3016,7,1106,'App\\Models\\Receipt',1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',62.28,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1262,7986,40721,3016,7,1107,'App\\Models\\Receipt',1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',62.99,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1263,7986,40721,3016,7,1108,'App\\Models\\Receipt',1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',65.23,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1264,7986,40721,3016,7,1109,'App\\Models\\Receipt',1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',66.05,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1265,7986,40721,3016,7,1110,'App\\Models\\Receipt',1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',66.10,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL);
INSERT INTO `balance_libro` VALUES (1266,7986,40721,3016,7,1111,'App\\Models\\Receipt',1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',69.26,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1267,7986,40721,3016,7,1112,'App\\Models\\Receipt',1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',72.20,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1268,7986,40721,3016,7,1113,'App\\Models\\Receipt',1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',77.80,NULL,NULL,1,'2023-01-19 11:52:47','2023-01-19 11:52:47',NULL),(1269,7986,40721,3016,7,1114,'App\\Models\\Receipt',1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-23','2022-12-23',78.77,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1270,7986,40721,3016,7,1115,'App\\Models\\Receipt',1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',80.29,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1271,7986,40721,3016,7,1116,'App\\Models\\Receipt',1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',95.16,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1272,7986,40721,3016,7,1117,'App\\Models\\Receipt',1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-02','2022-12-02',101.45,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1273,7986,40721,3016,7,1118,'App\\Models\\Receipt',1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',105.70,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1274,7986,40721,3016,7,1119,'App\\Models\\Receipt',1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',106.49,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1275,7986,40721,3016,7,1120,'App\\Models\\Receipt',1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-21','2022-12-21',107.90,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1276,7986,40721,3016,7,1121,'App\\Models\\Receipt',1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',110.91,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1277,7986,40721,3016,7,1122,'App\\Models\\Receipt',1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-05','2022-12-05',115.17,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1278,7986,40721,3016,7,1123,'App\\Models\\Receipt',1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-29','2022-12-29',117.96,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1279,7986,40721,3016,7,1124,'App\\Models\\Receipt',1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',122.96,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1280,7986,40721,3016,7,1125,'App\\Models\\Receipt',1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-19','2022-12-19',133.15,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1281,7986,40721,3016,7,1126,'App\\Models\\Receipt',1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',137.50,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1282,7986,40721,3016,7,1127,'App\\Models\\Receipt',1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-22','2022-12-22',145.02,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1283,7986,40721,3016,7,1128,'App\\Models\\Receipt',1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',147.76,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1284,7986,40721,3016,7,1129,'App\\Models\\Receipt',1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-12','2022-12-12',160.58,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1285,7986,40721,3016,7,1130,'App\\Models\\Receipt',1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',163.80,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1286,7986,40721,3016,7,1131,'App\\Models\\Receipt',1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',165.86,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL);
INSERT INTO `balance_libro` VALUES (1287,7986,40721,3016,7,1132,'App\\Models\\Receipt',1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-15','2022-12-15',166.39,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1288,7986,40721,3016,7,1133,'App\\Models\\Receipt',1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',178.37,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1289,7986,40721,3016,7,1134,'App\\Models\\Receipt',1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',189.89,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1290,7986,40721,3016,7,1135,'App\\Models\\Receipt',1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-20','2022-12-20',212.88,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1291,7986,40721,3016,7,1136,'App\\Models\\Receipt',1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-06','2022-12-06',221.18,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1292,7986,40721,3016,7,1137,'App\\Models\\Receipt',1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-07','2022-12-07',221.84,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1293,7986,40721,3016,7,1138,'App\\Models\\Receipt',1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',225.88,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1294,7986,40721,3016,7,1139,'App\\Models\\Receipt',1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',282.80,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1295,7986,40721,3016,7,1140,'App\\Models\\Receipt',1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',295.42,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1296,7986,40721,3016,7,1141,'App\\Models\\Receipt',1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',301.24,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1297,7986,40721,3016,7,1142,'App\\Models\\Receipt',1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',325.21,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1298,7986,40721,3016,7,1143,'App\\Models\\Receipt',1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',425.28,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1299,7986,40721,3016,7,1144,'App\\Models\\Receipt',1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-13','2022-12-13',735.30,NULL,NULL,1,'2023-01-19 11:52:48','2023-01-19 11:52:48',NULL),(1300,7986,40721,3016,3,1060,'App\\Models\\Receipt',1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',17676.44,NULL,NULL,1,'2023-01-19 12:06:42','2023-01-19 12:06:42',NULL),(1301,7986,40721,3016,3,1063,'App\\Models\\Receipt',1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-26','2022-12-26',23370.29,NULL,NULL,1,'2023-01-19 12:06:55','2023-01-19 12:06:55',NULL),(1302,7986,40759,8010,15,559,'App\\Models\\PeriodLiquidation',NULL,559,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',343635.09,NULL,NULL,1,'2023-01-20 08:38:03','2023-01-20 08:38:03',NULL),(1303,7986,40759,8010,16,560,'App\\Models\\PeriodLiquidation',NULL,560,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',20234.88,NULL,NULL,1,'2023-01-20 09:06:08','2023-01-20 09:06:08',NULL),(1304,7986,40721,3016,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',26731.70,NULL,NULL,1,'2023-01-20 12:00:20','2023-01-20 12:41:18','2023-01-20 12:41:18'),(1305,7986,40721,3016,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',27331.43,NULL,NULL,1,'2023-01-20 12:41:18','2023-01-20 12:58:15','2023-01-20 12:58:15'),(1306,7986,40721,3016,3,1065,'App\\Models\\Receipt',1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',26731.70,NULL,NULL,1,'2023-01-20 12:58:15','2023-01-20 12:58:15',NULL);
INSERT INTO `balance_libro` VALUES (1307,7986,40720,1518,3,1145,'App\\Models\\Receipt',1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',79843.81,NULL,NULL,1,'2023-02-14 12:01:08','2023-02-14 12:01:08',NULL),(1308,7986,40721,3018,2,1146,'App\\Models\\Receipt',1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',186784.07,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1309,7986,40721,3018,2,1147,'App\\Models\\Receipt',1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',19864.00,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1310,7986,40721,3018,2,1148,'App\\Models\\Receipt',1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',20185.00,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1311,7986,40721,3018,2,1149,'App\\Models\\Receipt',1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8764.00,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1312,7986,40721,3018,2,1150,'App\\Models\\Receipt',1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',217637.86,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1313,7986,40721,3018,2,1151,'App\\Models\\Receipt',1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',19043.00,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1314,7986,40721,3018,2,1152,'App\\Models\\Receipt',1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',14355.00,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1315,7986,40721,3018,2,1153,'App\\Models\\Receipt',1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',177600.17,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1316,7986,40721,3018,2,1154,'App\\Models\\Receipt',1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',229482.55,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1317,7986,40721,3018,2,1155,'App\\Models\\Receipt',1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',189634.83,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1318,7986,40721,3018,2,1156,'App\\Models\\Receipt',1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',22500.00,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1319,7986,40721,3018,2,1157,'App\\Models\\Receipt',1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',20006.00,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1320,7986,40721,3018,2,1158,'App\\Models\\Receipt',1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',19887.00,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1321,7986,40721,3018,2,1159,'App\\Models\\Receipt',1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',17852.00,NULL,NULL,1,'2023-02-14 12:02:11','2023-02-14 12:02:11',NULL),(1322,7986,40721,3018,3,1160,'App\\Models\\Receipt',1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',7637.25,NULL,NULL,1,'2023-02-14 12:02:21','2023-02-15 10:33:29','2023-02-15 10:33:29'),(1323,7986,40721,3018,3,1161,'App\\Models\\Receipt',1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',387.65,NULL,NULL,1,'2023-02-14 12:02:21','2023-02-15 10:33:47','2023-02-15 10:33:47'),(1324,7986,40721,3018,3,1162,'App\\Models\\Receipt',1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',30536.00,NULL,NULL,1,'2023-02-14 12:02:21','2023-02-15 10:34:25','2023-02-15 10:34:25'),(1325,7986,40721,3018,3,1163,'App\\Models\\Receipt',1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',6642.57,NULL,NULL,1,'2023-02-14 12:02:21','2023-02-14 12:02:21',NULL),(1326,7986,40721,3018,3,1164,'App\\Models\\Receipt',1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',54450.00,NULL,NULL,1,'2023-02-14 12:02:21','2023-02-15 10:35:18','2023-02-15 10:35:18');
INSERT INTO `balance_libro` VALUES (1327,7986,40721,3018,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8443.73,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-17 09:50:27','2023-02-17 09:50:27'),(1328,7986,40721,3018,3,1166,'App\\Models\\Receipt',1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',20005.32,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-14 12:02:22',NULL),(1329,7986,40721,3018,3,1167,'App\\Models\\Receipt',1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',5144.34,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-23 09:20:18','2023-02-23 09:20:18'),(1330,7986,40721,3018,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7608.06,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-17 09:51:14','2023-02-17 09:51:14'),(1331,7986,40721,3018,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10787.17,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-17 09:51:44','2023-02-17 09:51:44'),(1332,7986,40721,3018,3,1170,'App\\Models\\Receipt',1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',27866.00,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-14 12:02:22',NULL),(1333,7986,40721,3018,3,1171,'App\\Models\\Receipt',1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',17321.18,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-14 12:02:22',NULL),(1334,7986,40721,3018,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',28467.08,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-17 09:53:09','2023-02-17 09:53:09'),(1335,7986,40721,3018,3,1173,'App\\Models\\Receipt',1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',17543.23,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-14 12:02:22',NULL),(1336,7986,40721,3018,3,1174,'App\\Models\\Receipt',1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',20549.73,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-14 12:02:22',NULL),(1337,7986,40721,3018,3,1175,'App\\Models\\Receipt',1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',31312.73,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-14 12:02:22',NULL),(1338,7986,40721,3018,3,1176,'App\\Models\\Receipt',1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',33265.39,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-15 10:37:05','2023-02-15 10:37:05'),(1339,7986,40721,3018,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',11167.57,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-17 09:53:53','2023-02-17 09:53:53'),(1340,7986,40721,3018,3,1178,'App\\Models\\Receipt',1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',32105.44,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-14 12:02:22',NULL),(1341,7986,40721,3018,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',40933.17,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-17 09:54:38','2023-02-17 09:54:38'),(1342,7986,40721,3018,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8273.56,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-17 09:55:47','2023-02-17 09:55:47'),(1343,7986,40721,3018,3,1181,'App\\Models\\Receipt',1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',10605.00,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-14 12:02:22',NULL),(1344,7986,40721,3018,3,1182,'App\\Models\\Receipt',1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',52225.00,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-14 12:02:22',NULL),(1345,7986,40721,3018,3,1183,'App\\Models\\Receipt',1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',48146.43,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-14 12:02:22',NULL),(1346,7986,40721,3018,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',36468.70,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-17 09:56:21','2023-02-17 09:56:21');
INSERT INTO `balance_libro` VALUES (1347,7986,40721,3018,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',84496.78,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-17 09:57:29','2023-02-17 09:57:29'),(1348,7986,40721,3018,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',49318.76,NULL,NULL,1,'2023-02-14 12:02:22','2023-02-17 09:56:54','2023-02-17 09:56:54'),(1349,7986,40721,3018,3,1187,'App\\Models\\Receipt',1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',21296.41,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-14 12:02:23',NULL),(1350,7986,40721,3018,3,1188,'App\\Models\\Receipt',1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',9847.00,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-14 12:02:23',NULL),(1351,7986,40721,3018,3,1189,'App\\Models\\Receipt',1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',4931.95,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-14 12:02:23',NULL),(1352,7986,40721,3018,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',28153.99,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-17 09:58:20','2023-02-17 09:58:20'),(1353,7986,40721,3018,3,1191,'App\\Models\\Receipt',1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',788.80,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-15 10:39:55','2023-02-15 10:39:55'),(1354,7986,40721,3018,3,1192,'App\\Models\\Receipt',1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',56629.00,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-15 10:40:38','2023-02-15 10:40:38'),(1355,7986,40721,3018,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',22240.85,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-17 09:58:55','2023-02-17 09:58:55'),(1356,7986,40721,3018,3,1194,'App\\Models\\Receipt',1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',35450.73,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-14 12:02:23',NULL),(1357,7986,40721,3018,3,1195,'App\\Models\\Receipt',1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',386104.68,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-14 12:02:23',NULL),(1358,7986,40721,3018,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4286.52,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-17 09:59:44','2023-02-17 09:59:44'),(1359,7986,40721,3018,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',69281.07,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-17 10:00:16','2023-02-17 10:00:16'),(1360,7986,40721,3018,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',15046.57,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-17 10:00:46','2023-02-17 10:00:46'),(1361,7986,40721,3018,3,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4244.13,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-17 10:01:14','2023-02-17 10:01:14'),(1362,7986,40721,3018,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4486.93,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-17 10:01:41','2023-02-17 10:01:41'),(1363,7986,40721,3018,3,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',30602.62,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-17 10:02:15','2023-02-17 10:02:15'),(1364,7986,40721,3018,3,1202,'App\\Models\\Receipt',1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',122758.20,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-15 10:42:28','2023-02-15 10:42:28'),(1365,7986,40721,3018,3,1203,'App\\Models\\Receipt',1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',42787.81,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-14 12:02:23',NULL);
INSERT INTO `balance_libro` VALUES (1366,7986,40721,3018,3,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1029.22,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-17 10:05:00','2023-02-17 10:05:00'),(1367,7986,40721,3018,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',10312.16,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-17 10:05:31','2023-02-17 10:05:31'),(1368,7986,40721,3018,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',42388.64,NULL,NULL,1,'2023-02-14 12:02:23','2023-02-17 10:06:07','2023-02-17 10:06:07'),(1369,7986,40721,3018,3,1207,'App\\Models\\Receipt',1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',18433.20,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-15 10:43:18','2023-02-15 10:43:18'),(1370,7986,40721,3018,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',7942.95,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-17 10:06:36','2023-02-17 10:06:36'),(1371,7986,40721,3018,3,1209,'App\\Models\\Receipt',1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',12384.71,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-14 12:02:24',NULL),(1372,7986,40721,3018,3,1210,'App\\Models\\Receipt',1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',10337.73,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-14 12:02:24',NULL),(1373,7986,40721,3018,3,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',60791.01,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-17 10:07:16','2023-02-17 10:07:16'),(1374,7986,40721,3018,3,1212,'App\\Models\\Receipt',1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',7892.27,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-14 12:02:24',NULL),(1375,7986,40721,3018,3,1213,'App\\Models\\Receipt',1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1583.80,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-14 12:02:24',NULL),(1376,7986,40721,3018,3,1214,'App\\Models\\Receipt',1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',4589.99,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-15 10:44:36','2023-02-15 10:44:36'),(1377,7986,40721,3018,3,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',10301.62,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-17 10:08:57','2023-02-17 10:08:57'),(1378,7986,40721,3018,3,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',25174.52,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-17 10:09:33','2023-02-17 10:09:33'),(1379,7986,40721,3018,3,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',17165.32,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-17 10:10:10','2023-02-17 10:10:10'),(1380,7986,40721,3018,3,1218,'App\\Models\\Receipt',1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',2455.00,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-15 10:45:24','2023-02-15 10:45:24'),(1381,7986,40721,3018,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',87114.82,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-17 10:10:48','2023-02-17 10:10:48'),(1382,7986,40721,3018,3,1220,'App\\Models\\Receipt',1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',15825.71,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-14 12:02:24',NULL),(1383,7986,40721,3018,3,1221,'App\\Models\\Receipt',1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',18618.73,NULL,NULL,1,'2023-02-14 12:02:24','2023-02-14 12:02:24',NULL),(1384,7986,40721,3018,3,1222,'App\\Models\\Receipt',1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1793.00,NULL,NULL,1,'2023-02-14 12:02:25','2023-02-14 12:02:25',NULL),(1385,7986,40721,3018,3,1223,'App\\Models\\Receipt',1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',132309.34,NULL,NULL,1,'2023-02-14 12:02:25','2023-02-15 10:46:41','2023-02-15 10:46:41');
INSERT INTO `balance_libro` VALUES (1386,7986,40721,3018,3,1224,'App\\Models\\Receipt',1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',44390.00,NULL,NULL,1,'2023-02-14 12:02:25','2023-02-15 10:46:50','2023-02-15 10:46:50'),(1387,7986,40721,3018,3,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',135199.31,NULL,NULL,1,'2023-02-14 12:02:25','2023-02-17 10:11:28','2023-02-17 10:11:28'),(1388,7986,40721,3018,3,1226,'App\\Models\\Receipt',1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',79640.00,NULL,NULL,1,'2023-02-14 12:02:25','2023-02-15 10:47:03','2023-02-15 10:47:03'),(1389,7986,40721,3018,3,1227,'App\\Models\\Receipt',1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',8672.56,NULL,NULL,1,'2023-02-14 12:02:25','2023-02-15 10:47:11','2023-02-15 10:47:11'),(1390,7986,40776,17353,3,1228,'App\\Models\\Receipt',1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1686.67,NULL,NULL,1,'2023-02-14 12:03:07','2023-02-14 12:03:07',NULL),(1391,7986,40776,17353,3,1229,'App\\Models\\Receipt',1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',29000.00,NULL,NULL,1,'2023-02-14 12:03:07','2023-02-14 12:03:07',NULL),(1392,7986,40776,17353,3,1230,'App\\Models\\Receipt',1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1499.99,NULL,NULL,1,'2023-02-14 12:03:08','2023-02-14 12:03:08',NULL),(1393,7986,40776,17353,3,1231,'App\\Models\\Receipt',1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',34650.00,NULL,NULL,1,'2023-02-14 12:03:08','2023-02-14 12:03:08',NULL),(1394,7986,40776,17353,3,1232,'App\\Models\\Receipt',1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',27000.00,NULL,NULL,1,'2023-02-14 12:03:08','2023-02-14 12:03:08',NULL),(1395,7986,40776,17353,3,1233,'App\\Models\\Receipt',1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',6500.00,NULL,NULL,1,'2023-02-14 12:03:08','2023-02-15 10:04:57','2023-02-15 10:04:57'),(1396,7986,40776,17353,3,1234,'App\\Models\\Receipt',1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',6039.00,NULL,NULL,1,'2023-02-14 12:03:08','2023-02-14 12:03:08',NULL),(1397,7986,40776,17353,2,1235,'App\\Models\\Receipt',1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',517148.01,NULL,NULL,1,'2023-02-14 12:03:20','2023-02-14 12:03:20',NULL),(1398,7986,40759,8014,3,1236,'App\\Models\\Receipt',1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3234.56,NULL,NULL,1,'2023-02-14 12:28:47','2023-02-15 09:02:23','2023-02-15 09:02:23'),(1399,7986,40759,8014,3,1237,'App\\Models\\Receipt',1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1000.00,NULL,NULL,1,'2023-02-14 12:28:47','2023-02-14 12:28:47',NULL),(1400,7986,40759,8014,3,1238,'App\\Models\\Receipt',1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',185.47,NULL,NULL,1,'2023-02-14 12:28:47','2023-02-14 12:28:47',NULL),(1401,7986,40759,8014,3,1239,'App\\Models\\Receipt',1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',27510.83,NULL,NULL,1,'2023-02-14 12:28:47','2023-02-17 10:36:24','2023-02-17 10:36:24'),(1402,7986,40759,8014,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',74945.51,NULL,NULL,1,'2023-02-14 12:28:47','2023-02-15 09:26:09','2023-02-15 09:26:09'),(1403,7986,40759,8014,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12602.20,NULL,NULL,1,'2023-02-14 12:28:47','2023-02-15 09:25:36','2023-02-15 09:25:36'),(1404,7986,40759,8014,3,1242,'App\\Models\\Receipt',1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4911.26,NULL,NULL,1,'2023-02-14 12:28:47','2023-02-14 12:28:47',NULL),(1405,7986,40759,8014,3,1243,'App\\Models\\Receipt',1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',511.15,NULL,NULL,1,'2023-02-14 12:28:47','2023-02-14 12:28:47',NULL);
INSERT INTO `balance_libro` VALUES (1406,7986,40759,8014,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',42548.58,NULL,NULL,1,'2023-02-14 12:28:47','2023-02-15 09:24:58','2023-02-15 09:24:58'),(1407,7986,40759,8014,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',103876.77,NULL,NULL,1,'2023-02-14 12:28:47','2023-02-15 09:24:23','2023-02-15 09:24:23'),(1408,7986,40759,8014,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8013.95,NULL,NULL,1,'2023-02-14 12:28:47','2023-02-15 09:23:45','2023-02-15 09:23:45'),(1409,7986,40759,8014,3,1247,'App\\Models\\Receipt',1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',12862.71,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-15 09:04:49','2023-02-15 09:04:49'),(1410,7986,40759,8014,3,1248,'App\\Models\\Receipt',1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',3060.32,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-14 12:28:48',NULL),(1411,7986,40759,8014,3,1249,'App\\Models\\Receipt',1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',252.66,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-14 12:28:48',NULL),(1412,7986,40759,8014,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',89119.44,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-15 09:22:16','2023-02-15 09:22:16'),(1413,7986,40759,8014,3,1251,'App\\Models\\Receipt',1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',11560.39,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-14 12:28:48',NULL),(1414,7986,40759,8014,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',106511.10,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-15 09:21:41','2023-02-15 09:21:41'),(1415,7986,40759,8014,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',12035.25,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-15 09:21:17','2023-02-15 09:21:17'),(1416,7986,40759,8014,3,1254,'App\\Models\\Receipt',1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',4843.38,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-14 12:28:48',NULL),(1417,7986,40759,8014,3,1255,'App\\Models\\Receipt',1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',518.69,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-14 12:28:48',NULL),(1418,7986,40759,8014,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',42539.19,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-15 09:20:27','2023-02-15 09:20:27'),(1419,7986,40759,8014,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',150887.24,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-15 09:19:59','2023-02-15 09:19:59'),(1420,7986,40759,8014,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',10019.03,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-15 09:19:29','2023-02-15 09:19:29'),(1421,7986,40759,8014,3,1259,'App\\Models\\Receipt',1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',4052.76,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-15 09:08:51','2023-02-15 09:08:51'),(1422,7986,40759,8014,3,1260,'App\\Models\\Receipt',1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',462.47,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-15 09:08:42','2023-02-15 09:08:42'),(1423,7986,40759,8014,3,1261,'App\\Models\\Receipt',1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',151976.45,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-15 09:09:18','2023-02-15 09:09:18'),(1424,7986,40759,8014,3,1262,'App\\Models\\Receipt',1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',7080.41,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-15 09:08:11','2023-02-15 09:08:11');
INSERT INTO `balance_libro` VALUES (1425,7986,40759,8014,3,1263,'App\\Models\\Receipt',1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',159610.08,NULL,NULL,1,'2023-02-14 12:28:48','2023-02-14 12:28:48',NULL),(1426,7986,40759,8014,2,1264,'App\\Models\\Receipt',1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1800.00,NULL,NULL,1,'2023-02-14 12:34:11','2023-02-14 12:34:11',NULL),(1427,7986,40759,8014,2,1265,'App\\Models\\Receipt',1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',2200.00,NULL,NULL,1,'2023-02-14 12:34:11','2023-02-14 12:34:11',NULL),(1428,7986,40759,8014,2,1266,'App\\Models\\Receipt',1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1050.00,NULL,NULL,1,'2023-02-14 12:34:11','2023-02-14 12:34:11',NULL),(1429,7986,40759,8014,2,1267,'App\\Models\\Receipt',1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',700.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1430,7986,40759,8014,2,1268,'App\\Models\\Receipt',1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1899.99,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1431,7986,40759,8014,2,1269,'App\\Models\\Receipt',1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',700.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1432,7986,40759,8014,2,1270,'App\\Models\\Receipt',1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',3399.99,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1433,7986,40759,8014,2,1271,'App\\Models\\Receipt',1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1600.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1434,7986,40759,8014,2,1272,'App\\Models\\Receipt',1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1100.01,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1435,7986,40759,8014,2,1273,'App\\Models\\Receipt',1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-02','2023-01-02',1600.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1436,7986,40759,8014,2,1274,'App\\Models\\Receipt',1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1399.99,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1437,7986,40759,8014,2,1275,'App\\Models\\Receipt',1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',600.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1438,7986,40759,8014,2,1276,'App\\Models\\Receipt',1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1000.01,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1439,7986,40759,8014,2,1277,'App\\Models\\Receipt',1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1950.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1440,7986,40759,8014,2,1278,'App\\Models\\Receipt',1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',3800.01,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1441,7986,40759,8014,2,1279,'App\\Models\\Receipt',1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1600.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1442,7986,40759,8014,2,1280,'App\\Models\\Receipt',1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',800.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1443,7986,40759,8014,2,1281,'App\\Models\\Receipt',1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1700.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1444,7986,40759,8014,2,1282,'App\\Models\\Receipt',1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1050.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1445,7986,40759,8014,2,1283,'App\\Models\\Receipt',1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1600.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL);
INSERT INTO `balance_libro` VALUES (1446,7986,40759,8014,2,1284,'App\\Models\\Receipt',1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',1600.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1447,7986,40759,8014,2,1285,'App\\Models\\Receipt',1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',800.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1448,7986,40759,8014,2,1286,'App\\Models\\Receipt',1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',850.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1449,7986,40759,8014,2,1287,'App\\Models\\Receipt',1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1050.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1450,7986,40759,8014,2,1288,'App\\Models\\Receipt',1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1600.00,NULL,NULL,1,'2023-02-14 12:34:12','2023-02-14 12:34:12',NULL),(1451,7986,40759,8014,2,1289,'App\\Models\\Receipt',1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',850.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1452,7986,40759,8014,2,1290,'App\\Models\\Receipt',1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',900.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1453,7986,40759,8014,2,1291,'App\\Models\\Receipt',1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',900.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1454,7986,40759,8014,2,1292,'App\\Models\\Receipt',1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',900.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1455,7986,40759,8014,2,1293,'App\\Models\\Receipt',1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',900.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1456,7986,40759,8014,2,1294,'App\\Models\\Receipt',1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',500.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1457,7986,40759,8014,2,1295,'App\\Models\\Receipt',1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',700.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1458,7986,40759,8014,2,1296,'App\\Models\\Receipt',1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',999.99,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1459,7986,40759,8014,2,1297,'App\\Models\\Receipt',1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1800.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1460,7986,40759,8014,2,1298,'App\\Models\\Receipt',1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1500.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1461,7986,40759,8014,2,1299,'App\\Models\\Receipt',1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1600.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1462,7986,40759,8014,2,1300,'App\\Models\\Receipt',1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',900.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1463,7986,40759,8014,2,1301,'App\\Models\\Receipt',1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1899.99,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1464,7986,40759,8014,2,1302,'App\\Models\\Receipt',1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1600.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1465,7986,40759,8014,2,1303,'App\\Models\\Receipt',1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1600.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1466,7986,40759,8014,2,1304,'App\\Models\\Receipt',1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',1050.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL);
INSERT INTO `balance_libro` VALUES (1467,7986,40759,8014,2,1305,'App\\Models\\Receipt',1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',700.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1468,7986,40759,8014,2,1306,'App\\Models\\Receipt',1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',2800.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1469,7986,40759,8014,2,1307,'App\\Models\\Receipt',1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',900.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1470,7986,40759,8014,2,1308,'App\\Models\\Receipt',1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',700.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1471,7986,40759,8014,2,1309,'App\\Models\\Receipt',1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',900.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1472,7986,40759,8014,2,1310,'App\\Models\\Receipt',1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',900.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1473,7986,40759,8014,2,1311,'App\\Models\\Receipt',1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',550.01,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1474,7986,40759,8014,2,1312,'App\\Models\\Receipt',1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1050.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1475,7986,40759,8014,2,1313,'App\\Models\\Receipt',1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',900.00,NULL,NULL,1,'2023-02-14 12:34:13','2023-02-14 12:34:13',NULL),(1476,7986,40759,8014,2,1314,'App\\Models\\Receipt',1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',2400.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1477,7986,40759,8014,2,1315,'App\\Models\\Receipt',1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',450.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1478,7986,40759,8014,2,1316,'App\\Models\\Receipt',1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1050.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1479,7986,40759,8014,2,1317,'App\\Models\\Receipt',1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',700.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1480,7986,40759,8014,2,1318,'App\\Models\\Receipt',1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1350.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1481,7986,40759,8014,2,1319,'App\\Models\\Receipt',1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1899.99,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1482,7986,40759,8014,2,1320,'App\\Models\\Receipt',1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1379.99,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1483,7986,40759,8014,2,1321,'App\\Models\\Receipt',1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1819.99,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1484,7986,40759,8014,2,1322,'App\\Models\\Receipt',1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1600.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1485,7986,40759,8014,2,1323,'App\\Models\\Receipt',1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1449.99,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1486,7986,40759,8014,2,1324,'App\\Models\\Receipt',1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',450.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1487,7986,40759,8014,2,1325,'App\\Models\\Receipt',1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',450.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL);
INSERT INTO `balance_libro` VALUES (1488,7986,40759,8014,2,1326,'App\\Models\\Receipt',1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',350.01,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1489,7986,40759,8014,2,1327,'App\\Models\\Receipt',1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1649.99,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1490,7986,40759,8014,2,1328,'App\\Models\\Receipt',1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1150.01,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1491,7986,40759,8014,2,1329,'App\\Models\\Receipt',1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',1100.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1492,7986,40759,8014,2,1330,'App\\Models\\Receipt',1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',550.01,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1493,7986,40759,8014,2,1331,'App\\Models\\Receipt',1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',799.99,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1494,7986,40759,8014,2,1332,'App\\Models\\Receipt',1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',800.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1495,7986,40759,8014,2,1333,'App\\Models\\Receipt',1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',900.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1496,7986,40759,8014,2,1334,'App\\Models\\Receipt',1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1600.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1497,7986,40759,8014,2,1335,'App\\Models\\Receipt',1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1800.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1498,7986,40759,8014,2,1336,'App\\Models\\Receipt',1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1100.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1499,7986,40759,8014,2,1337,'App\\Models\\Receipt',1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',999.99,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1500,7986,40759,8014,2,1338,'App\\Models\\Receipt',1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2349.99,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1501,7986,40759,8014,2,1339,'App\\Models\\Receipt',1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2900.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1502,7986,40759,8014,2,1340,'App\\Models\\Receipt',1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',550.01,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1503,7986,40759,8014,2,1341,'App\\Models\\Receipt',1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2900.00,NULL,NULL,1,'2023-02-14 12:34:14','2023-02-14 12:34:14',NULL),(1504,7986,40759,8014,2,1342,'App\\Models\\Receipt',1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1649.99,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1505,7986,40759,8014,2,1343,'App\\Models\\Receipt',1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',900.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1506,7986,40759,8014,2,1344,'App\\Models\\Receipt',1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2400.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1507,7986,40759,8014,2,1345,'App\\Models\\Receipt',1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1600.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1508,7986,40759,8014,2,1346,'App\\Models\\Receipt',1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2800.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL);
INSERT INTO `balance_libro` VALUES (1509,7986,40759,8014,2,1347,'App\\Models\\Receipt',1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1500.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1510,7986,40759,8014,2,1348,'App\\Models\\Receipt',1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1800.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1511,7986,40759,8014,2,1349,'App\\Models\\Receipt',1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2900.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1512,7986,40759,8014,2,1350,'App\\Models\\Receipt',1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1750.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1513,7986,40759,8014,2,1351,'App\\Models\\Receipt',1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',2099.99,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1514,7986,40759,8014,2,1352,'App\\Models\\Receipt',1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',700.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1515,7986,40759,8014,2,1353,'App\\Models\\Receipt',1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',1600.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1516,7986,40759,8014,2,1354,'App\\Models\\Receipt',1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2499.99,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1517,7986,40759,8014,2,1355,'App\\Models\\Receipt',1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1600.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1518,7986,40759,8014,2,1356,'App\\Models\\Receipt',1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1600.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1519,7986,40759,8014,2,1357,'App\\Models\\Receipt',1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1699.99,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1520,7986,40759,8014,2,1358,'App\\Models\\Receipt',1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1699.99,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1521,7986,40759,8014,2,1359,'App\\Models\\Receipt',1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1000.01,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1522,7986,40759,8014,2,1360,'App\\Models\\Receipt',1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1600.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1523,7986,40759,8014,2,1361,'App\\Models\\Receipt',1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2650.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1524,7986,40759,8014,2,1362,'App\\Models\\Receipt',1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2299.99,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1525,7986,40759,8014,2,1363,'App\\Models\\Receipt',1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1600.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1526,7986,40759,8014,2,1364,'App\\Models\\Receipt',1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1200.01,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1527,7986,40759,8014,2,1365,'App\\Models\\Receipt',1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',700.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1528,7986,40759,8014,2,1366,'App\\Models\\Receipt',1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1600.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1529,7986,40759,8014,2,1367,'App\\Models\\Receipt',1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',900.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL);
INSERT INTO `balance_libro` VALUES (1530,7986,40759,8014,2,1368,'App\\Models\\Receipt',1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',700.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1531,7986,40759,8014,2,1369,'App\\Models\\Receipt',1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',900.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1532,7986,40759,8014,2,1370,'App\\Models\\Receipt',1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',2650.00,NULL,NULL,1,'2023-02-14 12:34:15','2023-02-14 12:34:15',NULL),(1533,7986,40759,8014,2,1371,'App\\Models\\Receipt',1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',1600.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1534,7986,40759,8014,2,1372,'App\\Models\\Receipt',1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',900.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1535,7986,40759,8014,2,1373,'App\\Models\\Receipt',1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1150.01,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1536,7986,40759,8014,2,1374,'App\\Models\\Receipt',1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',550.01,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1537,7986,40759,8014,2,1375,'App\\Models\\Receipt',1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',550.01,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1538,7986,40759,8014,2,1376,'App\\Models\\Receipt',1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1600.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1539,7986,40759,8014,2,1377,'App\\Models\\Receipt',1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',900.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1540,7986,40759,8014,2,1378,'App\\Models\\Receipt',1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',900.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1541,7986,40759,8014,2,1379,'App\\Models\\Receipt',1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1350.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1542,7986,40759,8014,2,1380,'App\\Models\\Receipt',1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',540.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1543,7986,40759,8014,2,1381,'App\\Models\\Receipt',1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',2499.99,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1544,7986,40759,8014,2,1382,'App\\Models\\Receipt',1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',2499.99,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1545,7986,40759,8014,2,1383,'App\\Models\\Receipt',1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',5079.99,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1546,7986,40759,8014,2,1384,'App\\Models\\Receipt',1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',900.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1547,7986,40759,8014,2,1385,'App\\Models\\Receipt',1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1600.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1548,7986,40759,8014,2,1386,'App\\Models\\Receipt',1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1500.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1549,7986,40759,8014,2,1387,'App\\Models\\Receipt',1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1450.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1550,7986,40759,8014,2,1388,'App\\Models\\Receipt',1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',900.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL);
INSERT INTO `balance_libro` VALUES (1551,7986,40759,8014,2,1389,'App\\Models\\Receipt',1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1600.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1552,7986,40759,8014,2,1390,'App\\Models\\Receipt',1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',2900.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1553,7986,40759,8014,2,1391,'App\\Models\\Receipt',1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',900.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1554,7986,40759,8014,2,1392,'App\\Models\\Receipt',1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1600.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1555,7986,40759,8014,2,1393,'App\\Models\\Receipt',1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',700.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1556,7986,40759,8014,2,1394,'App\\Models\\Receipt',1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',900.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1557,7986,40759,8014,2,1395,'App\\Models\\Receipt',1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1050.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1558,7986,40759,8014,2,1396,'App\\Models\\Receipt',1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1100.00,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1559,7986,40759,8014,2,1397,'App\\Models\\Receipt',1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1000.01,NULL,NULL,1,'2023-02-14 12:34:16','2023-02-14 12:34:16',NULL),(1560,7986,40759,8014,2,1398,'App\\Models\\Receipt',1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',3799.99,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1561,7986,40759,8014,2,1399,'App\\Models\\Receipt',1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',900.00,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1562,7986,40759,8014,2,1400,'App\\Models\\Receipt',1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1600.00,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1563,7986,40759,8014,2,1401,'App\\Models\\Receipt',1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',900.00,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1564,7986,40759,8014,2,1402,'App\\Models\\Receipt',1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1649.99,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1565,7986,40759,8014,2,1403,'App\\Models\\Receipt',1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1399.99,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1566,7986,40759,8014,2,1404,'App\\Models\\Receipt',1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1300.00,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1567,7986,40759,8014,2,1405,'App\\Models\\Receipt',1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',650.00,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1568,7986,40759,8014,2,1406,'App\\Models\\Receipt',1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',600.00,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1569,7986,40759,8014,2,1407,'App\\Models\\Receipt',1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1300.00,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1570,7986,40759,8014,2,1408,'App\\Models\\Receipt',1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1399.99,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1571,7986,40759,8014,2,1409,'App\\Models\\Receipt',1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1600.00,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL);
INSERT INTO `balance_libro` VALUES (1572,7986,40759,8014,2,1410,'App\\Models\\Receipt',1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1399.99,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1573,7986,40759,8014,2,1411,'App\\Models\\Receipt',1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-08','2023-01-08',1600.00,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1574,7986,40759,8014,2,1412,'App\\Models\\Receipt',1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',4900.00,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1575,7986,40759,8014,2,1413,'App\\Models\\Receipt',1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',900.00,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1576,7986,40759,8014,2,1414,'App\\Models\\Receipt',1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',2000.00,NULL,NULL,1,'2023-02-14 12:34:17','2023-02-14 12:34:17',NULL),(1577,7986,40759,8014,2,1415,'App\\Models\\Receipt',1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',900.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1578,7986,40759,8014,2,1416,'App\\Models\\Receipt',1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1050.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1579,7986,40759,8014,2,1417,'App\\Models\\Receipt',1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1350.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1580,7986,40759,8014,2,1418,'App\\Models\\Receipt',1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1699.99,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1581,7986,40759,8014,2,1419,'App\\Models\\Receipt',1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1600.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1582,7986,40759,8014,2,1420,'App\\Models\\Receipt',1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1600.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1583,7986,40759,8014,2,1421,'App\\Models\\Receipt',1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',900.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1584,7986,40759,8014,2,1422,'App\\Models\\Receipt',1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1699.99,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1585,7986,40759,8014,2,1423,'App\\Models\\Receipt',1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1150.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1586,7986,40759,8014,2,1424,'App\\Models\\Receipt',1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1600.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1587,7986,40759,8014,2,1425,'App\\Models\\Receipt',1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1399.99,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1588,7986,40759,8014,2,1426,'App\\Models\\Receipt',1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1350.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1589,7986,40759,8014,2,1427,'App\\Models\\Receipt',1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1600.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1590,7986,40759,8014,2,1428,'App\\Models\\Receipt',1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',900.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1591,7986,40759,8014,2,1429,'App\\Models\\Receipt',1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1140.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1592,7986,40759,8014,2,1430,'App\\Models\\Receipt',1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',1500.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL);
INSERT INTO `balance_libro` VALUES (1593,7986,40759,8014,2,1431,'App\\Models\\Receipt',1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',800.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1594,7986,40759,8014,2,1432,'App\\Models\\Receipt',1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',900.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1595,7986,40759,8014,2,1433,'App\\Models\\Receipt',1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',700.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1596,7986,40759,8014,2,1434,'App\\Models\\Receipt',1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',900.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1597,7986,40759,8014,2,1435,'App\\Models\\Receipt',1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1450.00,NULL,NULL,1,'2023-02-14 12:34:18','2023-02-14 12:34:18',NULL),(1598,7986,40759,8014,2,1436,'App\\Models\\Receipt',1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',670.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1599,7986,40759,8014,2,1437,'App\\Models\\Receipt',1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1350.01,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1600,7986,40759,8014,2,1438,'App\\Models\\Receipt',1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',700.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1601,7986,40759,8014,2,1439,'App\\Models\\Receipt',1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1750.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1602,7986,40759,8014,2,1440,'App\\Models\\Receipt',1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',900.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1603,7986,40759,8014,2,1441,'App\\Models\\Receipt',1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',3400.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1604,7986,40759,8014,2,1442,'App\\Models\\Receipt',1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1600.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1605,7986,40759,8014,2,1443,'App\\Models\\Receipt',1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',500.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1606,7986,40759,8014,2,1444,'App\\Models\\Receipt',1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',2900.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1607,7986,40759,8014,2,1445,'App\\Models\\Receipt',1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',700.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1608,7986,40759,8014,2,1446,'App\\Models\\Receipt',1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',900.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1609,7986,40759,8014,2,1447,'App\\Models\\Receipt',1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',900.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1610,7986,40759,8014,2,1448,'App\\Models\\Receipt',1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',1500.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1611,7986,40759,8014,2,1449,'App\\Models\\Receipt',1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',800.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1612,7986,40759,8014,2,1450,'App\\Models\\Receipt',1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',950.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1613,7986,40759,8014,2,1451,'App\\Models\\Receipt',1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1199.99,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL);
INSERT INTO `balance_libro` VALUES (1614,7986,40759,8014,2,1452,'App\\Models\\Receipt',1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',350.01,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1615,7986,40759,8014,2,1453,'App\\Models\\Receipt',1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',900.01,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1616,7986,40759,8014,2,1454,'App\\Models\\Receipt',1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1100.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1617,7986,40759,8014,2,1455,'App\\Models\\Receipt',1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2500.01,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1618,7986,40759,8014,2,1456,'App\\Models\\Receipt',1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1050.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1619,7986,40759,8014,2,1457,'App\\Models\\Receipt',1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',900.00,NULL,NULL,1,'2023-02-14 12:34:19','2023-02-14 12:34:19',NULL),(1620,7986,40759,8014,2,1458,'App\\Models\\Receipt',1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',3899.99,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1621,7986,40759,8014,2,1459,'App\\Models\\Receipt',1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',350.01,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1622,7986,40759,8014,2,1460,'App\\Models\\Receipt',1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1750.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1623,7986,40759,8014,2,1461,'App\\Models\\Receipt',1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2900.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1624,7986,40759,8014,2,1462,'App\\Models\\Receipt',1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1399.99,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1625,7986,40759,8014,2,1463,'App\\Models\\Receipt',1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2900.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1626,7986,40759,8014,2,1464,'App\\Models\\Receipt',1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',2400.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1627,7986,40759,8014,2,1465,'App\\Models\\Receipt',1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1600.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1628,7986,40759,8014,2,1466,'App\\Models\\Receipt',1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1600.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1629,7986,40759,8014,2,1467,'App\\Models\\Receipt',1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1399.99,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1630,7986,40759,8014,2,1468,'App\\Models\\Receipt',1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',1600.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1631,7986,40759,8014,2,1469,'App\\Models\\Receipt',1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1250.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1632,7986,40759,8014,2,1470,'App\\Models\\Receipt',1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1100.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1633,7986,40759,8014,2,1471,'App\\Models\\Receipt',1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1600.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1634,7986,40759,8014,2,1472,'App\\Models\\Receipt',1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2499.99,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL);
INSERT INTO `balance_libro` VALUES (1635,7986,40759,8014,2,1473,'App\\Models\\Receipt',1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',800.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1636,7986,40759,8014,2,1474,'App\\Models\\Receipt',1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',700.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1637,7986,40759,8014,2,1475,'App\\Models\\Receipt',1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1100.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1638,7986,40759,8014,2,1476,'App\\Models\\Receipt',1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',2200.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1639,7986,40759,8014,2,1477,'App\\Models\\Receipt',1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',1050.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1640,7986,40759,8014,2,1478,'App\\Models\\Receipt',1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',500.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1641,7986,40759,8014,2,1479,'App\\Models\\Receipt',1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',790.01,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1642,7986,40759,8014,2,1480,'App\\Models\\Receipt',1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',700.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1643,7986,40759,8014,2,1481,'App\\Models\\Receipt',1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',3050.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1644,7986,40759,8014,2,1482,'App\\Models\\Receipt',1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',900.00,NULL,NULL,1,'2023-02-14 12:34:20','2023-02-14 12:34:20',NULL),(1645,7986,40759,8014,2,1483,'App\\Models\\Receipt',1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1849.99,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1646,7986,40759,8014,2,1484,'App\\Models\\Receipt',1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',900.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1647,7986,40759,8014,2,1485,'App\\Models\\Receipt',1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',850.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1648,7986,40759,8014,2,1486,'App\\Models\\Receipt',1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',900.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1649,7986,40759,8014,2,1487,'App\\Models\\Receipt',1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1050.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1650,7986,40759,8014,2,1488,'App\\Models\\Receipt',1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1600.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1651,7986,40759,8014,2,1489,'App\\Models\\Receipt',1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',500.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1652,7986,40759,8014,2,1490,'App\\Models\\Receipt',1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1699.99,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1653,7986,40759,8014,2,1491,'App\\Models\\Receipt',1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1600.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1654,7986,40759,8014,2,1492,'App\\Models\\Receipt',1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',2250.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1655,7986,40759,8014,2,1493,'App\\Models\\Receipt',1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',250.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL);
INSERT INTO `balance_libro` VALUES (1656,7986,40759,8014,2,1494,'App\\Models\\Receipt',1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1950.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1657,7986,40759,8014,2,1495,'App\\Models\\Receipt',1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1000.01,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1658,7986,40759,8014,2,1496,'App\\Models\\Receipt',1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1300.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1659,7986,40759,8014,2,1497,'App\\Models\\Receipt',1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',3150.01,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1660,7986,40759,8014,2,1498,'App\\Models\\Receipt',1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1600.01,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1661,7986,40759,8014,2,1499,'App\\Models\\Receipt',1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',900.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1662,7986,40759,8014,2,1500,'App\\Models\\Receipt',1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1699.99,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1663,7986,40759,8014,2,1501,'App\\Models\\Receipt',1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1850.01,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1664,7986,40759,8014,2,1502,'App\\Models\\Receipt',1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1050.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1665,7986,40759,8014,2,1503,'App\\Models\\Receipt',1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',500.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1666,7986,40759,8014,2,1504,'App\\Models\\Receipt',1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1750.00,NULL,NULL,1,'2023-02-14 12:34:21','2023-02-14 12:34:21',NULL),(1667,7986,40759,8014,2,1505,'App\\Models\\Receipt',1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',1649.99,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1668,7986,40759,8014,2,1506,'App\\Models\\Receipt',1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1150.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1669,7986,40759,8014,2,1507,'App\\Models\\Receipt',1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1350.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1670,7986,40759,8014,2,1508,'App\\Models\\Receipt',1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1199.98,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1671,7986,40759,8014,2,1509,'App\\Models\\Receipt',1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1649.99,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1672,7986,40759,8014,2,1510,'App\\Models\\Receipt',1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1700.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1673,7986,40759,8014,2,1511,'App\\Models\\Receipt',1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',900.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1674,7986,40759,8014,2,1512,'App\\Models\\Receipt',1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',750.01,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1675,7986,40759,8014,2,1513,'App\\Models\\Receipt',1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2650.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1676,7986,40759,8014,2,1514,'App\\Models\\Receipt',1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',999.99,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL);
INSERT INTO `balance_libro` VALUES (1677,7986,40759,8014,2,1515,'App\\Models\\Receipt',1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',550.01,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1678,7986,40759,8014,2,1516,'App\\Models\\Receipt',1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',700.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1679,7986,40759,8014,2,1517,'App\\Models\\Receipt',1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',950.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1680,7986,40759,8014,2,1518,'App\\Models\\Receipt',1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1500.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1681,7986,40759,8014,2,1519,'App\\Models\\Receipt',1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',900.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1682,7986,40759,8014,2,1520,'App\\Models\\Receipt',1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',900.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1683,7986,40759,8014,2,1521,'App\\Models\\Receipt',1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1600.01,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1684,7986,40759,8014,2,1522,'App\\Models\\Receipt',1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1600.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1685,7986,40759,8014,2,1523,'App\\Models\\Receipt',1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2150.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1686,7986,40759,8014,2,1524,'App\\Models\\Receipt',1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',800.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1687,7986,40759,8014,2,1525,'App\\Models\\Receipt',1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1300.00,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1688,7986,40759,8014,2,1526,'App\\Models\\Receipt',1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',700.01,NULL,NULL,1,'2023-02-14 12:34:22','2023-02-14 12:34:22',NULL),(1689,7986,40759,8014,2,1527,'App\\Models\\Receipt',1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2499.99,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1690,7986,40759,8014,2,1528,'App\\Models\\Receipt',1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1600.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1691,7986,40759,8014,2,1529,'App\\Models\\Receipt',1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1699.99,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1692,7986,40759,8014,2,1530,'App\\Models\\Receipt',1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1600.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1693,7986,40759,8014,2,1531,'App\\Models\\Receipt',1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',900.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1694,7986,40759,8014,2,1532,'App\\Models\\Receipt',1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1600.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1695,7986,40759,8014,2,1533,'App\\Models\\Receipt',1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2499.99,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1696,7986,40759,8014,2,1534,'App\\Models\\Receipt',1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1699.99,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1697,7986,40759,8014,2,1535,'App\\Models\\Receipt',1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1649.99,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL);
INSERT INTO `balance_libro` VALUES (1698,7986,40759,8014,2,1536,'App\\Models\\Receipt',1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1300.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1699,7986,40759,8014,2,1537,'App\\Models\\Receipt',1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2900.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1700,7986,40759,8014,2,1538,'App\\Models\\Receipt',1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1050.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1701,7986,40759,8014,2,1539,'App\\Models\\Receipt',1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1600.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1702,7986,40759,8014,2,1540,'App\\Models\\Receipt',1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1050.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1703,7986,40759,8014,2,1541,'App\\Models\\Receipt',1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1600.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1704,7986,40759,8014,2,1542,'App\\Models\\Receipt',1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2250.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1705,7986,40759,8014,2,1543,'App\\Models\\Receipt',1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',1600.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1706,7986,40759,8014,2,1544,'App\\Models\\Receipt',1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',2599.99,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1707,7986,40759,8014,2,1545,'App\\Models\\Receipt',1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',900.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1708,7986,40759,8014,2,1546,'App\\Models\\Receipt',1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',250.00,NULL,NULL,1,'2023-02-14 12:34:23','2023-02-14 12:34:23',NULL),(1709,7986,40759,8014,2,1547,'App\\Models\\Receipt',1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1600.00,NULL,NULL,1,'2023-02-14 12:34:24','2023-02-14 12:34:24',NULL),(1710,7986,40759,8014,2,1548,'App\\Models\\Receipt',1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1199.99,NULL,NULL,1,'2023-02-14 12:34:24','2023-02-14 12:34:24',NULL),(1711,7986,40759,8014,2,1549,'App\\Models\\Receipt',1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',550.01,NULL,NULL,1,'2023-02-14 12:34:24','2023-02-14 12:34:24',NULL),(1712,7986,40759,8014,2,1550,'App\\Models\\Receipt',1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',2499.99,NULL,NULL,1,'2023-02-14 12:34:24','2023-02-14 12:34:24',NULL),(1713,7986,40759,8014,2,1551,'App\\Models\\Receipt',1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1600.00,NULL,NULL,1,'2023-02-14 12:34:24','2023-02-14 12:34:24',NULL),(1714,7986,40759,8014,2,1552,'App\\Models\\Receipt',1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1600.00,NULL,NULL,1,'2023-02-14 12:34:24','2023-02-14 12:34:24',NULL),(1715,7986,40759,8014,2,1553,'App\\Models\\Receipt',1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1100.00,NULL,NULL,1,'2023-02-14 12:34:24','2023-02-14 12:34:24',NULL),(1716,7986,40759,8014,2,1554,'App\\Models\\Receipt',1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1699.99,NULL,NULL,1,'2023-02-14 12:34:24','2023-02-14 12:34:24',NULL),(1717,7986,40759,8014,2,1555,'App\\Models\\Receipt',1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1800.00,NULL,NULL,1,'2023-02-14 12:34:24','2023-02-14 12:34:24',NULL),(1718,7986,40759,8014,2,1556,'App\\Models\\Receipt',1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1600.00,NULL,NULL,1,'2023-02-14 12:34:24','2023-02-14 12:34:24',NULL);
INSERT INTO `balance_libro` VALUES (1719,7986,40759,8014,2,1557,'App\\Models\\Receipt',1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',2150.00,NULL,NULL,1,'2023-02-14 12:34:24','2023-02-14 12:34:24',NULL),(1720,7986,40759,8014,2,1558,'App\\Models\\Receipt',1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',3500.00,NULL,NULL,1,'2023-02-14 12:34:24','2023-02-14 12:34:24',NULL),(1721,7986,40759,8014,2,1559,'App\\Models\\Receipt',1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',2900.00,NULL,NULL,1,'2023-02-14 12:34:24','2023-02-14 12:34:24',NULL),(1722,7986,40759,8014,2,1560,'App\\Models\\Receipt',1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',2499.99,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1723,7986,40759,8014,2,1561,'App\\Models\\Receipt',1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',3450.00,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1724,7986,40759,8014,2,1562,'App\\Models\\Receipt',1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1000.01,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1725,7986,40759,8014,2,1563,'App\\Models\\Receipt',1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',250.00,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1726,7986,40759,8014,2,1564,'App\\Models\\Receipt',1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',700.00,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1727,7986,40759,8014,2,1565,'App\\Models\\Receipt',1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1199.99,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1728,7986,40759,8014,2,1566,'App\\Models\\Receipt',1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1550.00,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1729,7986,40759,8014,2,1567,'App\\Models\\Receipt',1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',950.00,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1730,7986,40759,8014,2,1568,'App\\Models\\Receipt',1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',700.00,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1731,7986,40759,8014,2,1569,'App\\Models\\Receipt',1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',900.00,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1732,7986,40759,8014,2,1570,'App\\Models\\Receipt',1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',5250.00,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1733,7986,40759,8014,2,1571,'App\\Models\\Receipt',1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',2049.99,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1734,7986,40759,8014,2,1572,'App\\Models\\Receipt',1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1600.00,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1735,7986,40759,8014,2,1573,'App\\Models\\Receipt',1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1150.00,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1736,7986,40759,8014,2,1574,'App\\Models\\Receipt',1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1600.00,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1737,7986,40759,8014,2,1575,'App\\Models\\Receipt',1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',900.00,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1738,7986,40759,8014,2,1576,'App\\Models\\Receipt',1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',550.01,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1739,7986,40759,8014,2,1577,'App\\Models\\Receipt',1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-15','2023-01-15',1699.99,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL);
INSERT INTO `balance_libro` VALUES (1740,7986,40759,8014,2,1578,'App\\Models\\Receipt',1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',700.00,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1741,7986,40759,8014,2,1579,'App\\Models\\Receipt',1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',350.01,NULL,NULL,1,'2023-02-14 12:34:25','2023-02-14 12:34:25',NULL),(1742,7986,40759,8014,2,1580,'App\\Models\\Receipt',1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',850.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1743,7986,40759,8014,2,1581,'App\\Models\\Receipt',1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1699.99,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1744,7986,40759,8014,2,1582,'App\\Models\\Receipt',1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1800.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1745,7986,40759,8014,2,1583,'App\\Models\\Receipt',1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1600.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1746,7986,40759,8014,2,1584,'App\\Models\\Receipt',1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',1350.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1747,7986,40759,8014,2,1585,'App\\Models\\Receipt',1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1550.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1748,7986,40759,8014,2,1586,'App\\Models\\Receipt',1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',2900.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1749,7986,40759,8014,2,1587,'App\\Models\\Receipt',1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',700.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1750,7986,40759,8014,2,1588,'App\\Models\\Receipt',1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',1600.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1751,7986,40759,8014,2,1589,'App\\Models\\Receipt',1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',400.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1752,7986,40759,8014,2,1590,'App\\Models\\Receipt',1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',900.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1753,7986,40759,8014,2,1591,'App\\Models\\Receipt',1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',700.01,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1754,7986,40759,8014,2,1592,'App\\Models\\Receipt',1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2900.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1755,7986,40759,8014,2,1593,'App\\Models\\Receipt',1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',900.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1756,7986,40759,8014,2,1594,'App\\Models\\Receipt',1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',360.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1757,7986,40759,8014,2,1595,'App\\Models\\Receipt',1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2900.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1758,7986,40759,8014,2,1596,'App\\Models\\Receipt',1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',900.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1759,7986,40759,8014,2,1597,'App\\Models\\Receipt',1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',700.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1760,7986,40759,8014,2,1598,'App\\Models\\Receipt',1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',600.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL);
INSERT INTO `balance_libro` VALUES (1761,7986,40759,8014,2,1599,'App\\Models\\Receipt',1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',900.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1762,7986,40759,8014,2,1600,'App\\Models\\Receipt',1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1649.99,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1763,7986,40759,8014,2,1601,'App\\Models\\Receipt',1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',2900.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1764,7986,40759,8014,2,1602,'App\\Models\\Receipt',1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1199.99,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1765,7986,40759,8014,2,1603,'App\\Models\\Receipt',1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',3700.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1766,7986,40759,8014,2,1604,'App\\Models\\Receipt',1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',950.00,NULL,NULL,1,'2023-02-14 12:34:26','2023-02-14 12:34:26',NULL),(1767,7986,40759,8014,2,1605,'App\\Models\\Receipt',1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1199.99,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1768,7986,40759,8014,2,1606,'App\\Models\\Receipt',1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',650.00,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1769,7986,40759,8014,2,1607,'App\\Models\\Receipt',1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1650.00,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1770,7986,40759,8014,2,1608,'App\\Models\\Receipt',1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1600.00,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1771,7986,40759,8014,2,1609,'App\\Models\\Receipt',1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1500.00,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1772,7986,40759,8014,2,1610,'App\\Models\\Receipt',1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1600.00,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1773,7986,40759,8014,2,1611,'App\\Models\\Receipt',1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',1399.99,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1774,7986,40759,8014,2,1612,'App\\Models\\Receipt',1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1600.00,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1775,7986,40759,8014,2,1613,'App\\Models\\Receipt',1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1699.99,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1776,7986,40759,8014,2,1614,'App\\Models\\Receipt',1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',3650.00,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1777,7986,40759,8014,2,1615,'App\\Models\\Receipt',1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',999.99,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1778,7986,40759,8014,2,1616,'App\\Models\\Receipt',1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',550.01,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1779,7986,40759,8014,2,1617,'App\\Models\\Receipt',1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2650.01,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1780,7986,40759,8014,2,1618,'App\\Models\\Receipt',1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',350.01,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1781,7986,40759,8014,2,1619,'App\\Models\\Receipt',1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',700.00,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL);
INSERT INTO `balance_libro` VALUES (1782,7986,40759,8014,2,1620,'App\\Models\\Receipt',1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',550.01,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1783,7986,40759,8014,2,1621,'App\\Models\\Receipt',1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2500.01,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1784,7986,40759,8014,2,1622,'App\\Models\\Receipt',1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',2000.00,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1785,7986,40759,8014,2,1623,'App\\Models\\Receipt',1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1050.00,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1786,7986,40759,8014,2,1624,'App\\Models\\Receipt',1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',1399.99,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1787,7986,40759,8014,2,1625,'App\\Models\\Receipt',1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1050.00,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1788,7986,40759,8014,2,1626,'App\\Models\\Receipt',1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1570.00,NULL,NULL,1,'2023-02-14 12:34:27','2023-02-14 12:34:27',NULL),(1789,7986,40759,8014,2,1627,'App\\Models\\Receipt',1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',900.00,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1790,7986,40759,8014,2,1628,'App\\Models\\Receipt',1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1150.00,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1791,7986,40759,8014,2,1629,'App\\Models\\Receipt',1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1000.01,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1792,7986,40759,8014,2,1630,'App\\Models\\Receipt',1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1699.99,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1793,7986,40759,8014,2,1631,'App\\Models\\Receipt',1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1600.00,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1794,7986,40759,8014,2,1632,'App\\Models\\Receipt',1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1050.00,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1795,7986,40759,8014,2,1633,'App\\Models\\Receipt',1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',250.00,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1796,7986,40759,8014,2,1634,'App\\Models\\Receipt',1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1399.99,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1797,7986,40759,8014,2,1635,'App\\Models\\Receipt',1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2999.99,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1798,7986,40759,8014,2,1636,'App\\Models\\Receipt',1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2900.01,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1799,7986,40759,8014,2,1637,'App\\Models\\Receipt',1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1600.00,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1800,7986,40759,8014,2,1638,'App\\Models\\Receipt',1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1600.00,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1801,7986,40759,8014,2,1639,'App\\Models\\Receipt',1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',2900.00,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1802,7986,40759,8014,2,1640,'App\\Models\\Receipt',1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',900.00,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL);
INSERT INTO `balance_libro` VALUES (1803,7986,40759,8014,2,1641,'App\\Models\\Receipt',1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1399.99,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1804,7986,40759,8014,2,1642,'App\\Models\\Receipt',1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',900.00,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1805,7986,40759,8014,2,1643,'App\\Models\\Receipt',1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',950.00,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1806,7986,40759,8014,2,1644,'App\\Models\\Receipt',1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',350.01,NULL,NULL,1,'2023-02-14 12:34:28','2023-02-14 12:34:28',NULL),(1807,7986,40759,8014,2,1645,'App\\Models\\Receipt',1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',900.00,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1808,7986,40759,8014,2,1646,'App\\Models\\Receipt',1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',950.00,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1809,7986,40759,8014,2,1647,'App\\Models\\Receipt',1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',700.00,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1810,7986,40759,8014,2,1648,'App\\Models\\Receipt',1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1600.00,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1811,7986,40759,8014,2,1649,'App\\Models\\Receipt',1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',900.00,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1812,7986,40759,8014,2,1650,'App\\Models\\Receipt',1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1750.00,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1813,7986,40759,8014,2,1651,'App\\Models\\Receipt',1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2999.99,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1814,7986,40759,8014,2,1652,'App\\Models\\Receipt',1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2500.01,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1815,7986,40759,8014,2,1653,'App\\Models\\Receipt',1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2500.01,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1816,7986,40759,8014,2,1654,'App\\Models\\Receipt',1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',900.00,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1817,7986,40759,8014,2,1655,'App\\Models\\Receipt',1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',900.00,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1818,7986,40759,8014,2,1656,'App\\Models\\Receipt',1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2049.99,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1819,7986,40759,8014,2,1657,'App\\Models\\Receipt',1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2499.99,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1820,7986,40759,8014,2,1658,'App\\Models\\Receipt',1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1600.00,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1821,7986,40759,8014,2,1659,'App\\Models\\Receipt',1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',900.00,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1822,7986,40759,8014,2,1660,'App\\Models\\Receipt',1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',900.00,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1823,7986,40759,8014,2,1661,'App\\Models\\Receipt',1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',2699.99,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL);
INSERT INTO `balance_libro` VALUES (1824,7986,40759,8014,2,1662,'App\\Models\\Receipt',1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1250.00,NULL,NULL,1,'2023-02-14 12:34:29','2023-02-14 12:34:29',NULL),(1825,7986,40759,8014,2,1663,'App\\Models\\Receipt',1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',900.00,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1826,7986,40759,8014,2,1664,'App\\Models\\Receipt',1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1559.99,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1827,7986,40759,8014,2,1665,'App\\Models\\Receipt',1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1900.00,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1828,7986,40759,8014,2,1666,'App\\Models\\Receipt',1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',1250.00,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1829,7986,40759,8014,2,1667,'App\\Models\\Receipt',1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',850.00,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1830,7986,40759,8014,2,1668,'App\\Models\\Receipt',1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',250.00,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1831,7986,40759,8014,2,1669,'App\\Models\\Receipt',1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',900.00,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1832,7986,40759,8014,2,1670,'App\\Models\\Receipt',1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',3100.01,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1833,7986,40759,8014,2,1671,'App\\Models\\Receipt',1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1450.00,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1834,7986,40759,8014,2,1672,'App\\Models\\Receipt',1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1600.00,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1835,7986,40759,8014,2,1673,'App\\Models\\Receipt',1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1600.00,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1836,7986,40759,8014,2,1674,'App\\Models\\Receipt',1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',900.00,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1837,7986,40759,8014,2,1675,'App\\Models\\Receipt',1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',900.00,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1838,7986,40759,8014,2,1676,'App\\Models\\Receipt',1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1699.99,NULL,NULL,1,'2023-02-14 12:34:30','2023-02-14 12:34:30',NULL),(1839,7986,40759,8014,2,1677,'App\\Models\\Receipt',1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',2900.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1840,7986,40759,8014,2,1678,'App\\Models\\Receipt',1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',2900.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1841,7986,40759,8014,2,1679,'App\\Models\\Receipt',1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1050.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1842,7986,40759,8014,2,1680,'App\\Models\\Receipt',1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',3600.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1843,7986,40759,8014,2,1681,'App\\Models\\Receipt',1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',250.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1844,7986,40759,8014,2,1682,'App\\Models\\Receipt',1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1849.99,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL);
INSERT INTO `balance_libro` VALUES (1845,7986,40759,8014,2,1683,'App\\Models\\Receipt',1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1600.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1846,7986,40759,8014,2,1684,'App\\Models\\Receipt',1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1600.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1847,7986,40759,8014,2,1685,'App\\Models\\Receipt',1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',950.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1848,7986,40759,8014,2,1686,'App\\Models\\Receipt',1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1800.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1849,7986,40759,8014,2,1687,'App\\Models\\Receipt',1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1600.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1850,7986,40759,8014,2,1688,'App\\Models\\Receipt',1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',850.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1851,7986,40759,8014,2,1689,'App\\Models\\Receipt',1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',950.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1852,7986,40759,8014,2,1690,'App\\Models\\Receipt',1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1600.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1853,7986,40759,8014,2,1691,'App\\Models\\Receipt',1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',700.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1854,7986,40759,8014,2,1692,'App\\Models\\Receipt',1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',500.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1855,7986,40759,8014,2,1693,'App\\Models\\Receipt',1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1750.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1856,7986,40759,8014,2,1694,'App\\Models\\Receipt',1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1600.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1857,7986,40759,8014,2,1695,'App\\Models\\Receipt',1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-22','2023-01-22',1170.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1858,7986,40759,8014,2,1696,'App\\Models\\Receipt',1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1600.00,NULL,NULL,1,'2023-02-14 12:34:31','2023-02-14 12:34:31',NULL),(1859,7986,40759,8014,2,1697,'App\\Models\\Receipt',1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',850.00,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1860,7986,40759,8014,2,1698,'App\\Models\\Receipt',1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1750.00,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1861,7986,40759,8014,2,1699,'App\\Models\\Receipt',1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',2900.00,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1862,7986,40759,8014,2,1700,'App\\Models\\Receipt',1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',550.01,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1863,7986,40759,8014,2,1701,'App\\Models\\Receipt',1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',350.01,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1864,7986,40759,8014,2,1702,'App\\Models\\Receipt',1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',799.99,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1865,7986,40759,8014,2,1703,'App\\Models\\Receipt',1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',1399.99,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL);
INSERT INTO `balance_libro` VALUES (1866,7986,40759,8014,2,1704,'App\\Models\\Receipt',1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1600.00,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1867,7986,40759,8014,2,1705,'App\\Models\\Receipt',1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1600.00,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1868,7986,40759,8014,2,1706,'App\\Models\\Receipt',1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1550.00,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1869,7986,40759,8014,2,1707,'App\\Models\\Receipt',1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',250.00,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1870,7986,40759,8014,2,1708,'App\\Models\\Receipt',1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',350.01,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1871,7986,40759,8014,2,1709,'App\\Models\\Receipt',1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1600.00,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1872,7986,40759,8014,2,1710,'App\\Models\\Receipt',1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',1699.99,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1873,7986,40759,8014,2,1711,'App\\Models\\Receipt',1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2099.99,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1874,7986,40759,8014,2,1712,'App\\Models\\Receipt',1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',700.00,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1875,7986,40759,8014,2,1713,'App\\Models\\Receipt',1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2150.00,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1876,7986,40759,8014,2,1714,'App\\Models\\Receipt',1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',2900.00,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1877,7986,40759,8014,2,1715,'App\\Models\\Receipt',1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',550.01,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1878,7986,40759,8014,2,1716,'App\\Models\\Receipt',1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',800.00,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1879,7986,40759,8014,2,1717,'App\\Models\\Receipt',1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',900.01,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1880,7986,40759,8014,2,1718,'App\\Models\\Receipt',1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',500.00,NULL,NULL,1,'2023-02-14 12:34:32','2023-02-14 12:34:32',NULL),(1881,7986,40759,8014,2,1719,'App\\Models\\Receipt',1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2049.99,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1882,7986,40759,8014,2,1720,'App\\Models\\Receipt',1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',800.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1883,7986,40759,8014,2,1721,'App\\Models\\Receipt',1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',600.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1884,7986,40759,8014,2,1722,'App\\Models\\Receipt',1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',550.01,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1885,7986,40759,8014,2,1723,'App\\Models\\Receipt',1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',550.01,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1886,7986,40759,8014,2,1724,'App\\Models\\Receipt',1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1600.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL);
INSERT INTO `balance_libro` VALUES (1887,7986,40759,8014,2,1725,'App\\Models\\Receipt',1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',550.01,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1888,7986,40759,8014,2,1726,'App\\Models\\Receipt',1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',2900.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1889,7986,40759,8014,2,1727,'App\\Models\\Receipt',1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',950.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1890,7986,40759,8014,2,1728,'App\\Models\\Receipt',1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1600.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1891,7986,40759,8014,2,1729,'App\\Models\\Receipt',1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',900.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1892,7986,40759,8014,2,1730,'App\\Models\\Receipt',1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',650.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1893,7986,40759,8014,2,1731,'App\\Models\\Receipt',1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1900.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1894,7986,40759,8014,2,1732,'App\\Models\\Receipt',1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',1600.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1895,7986,40759,8014,2,1733,'App\\Models\\Receipt',1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',900.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1896,7986,40759,8014,2,1734,'App\\Models\\Receipt',1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1600.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1897,7986,40759,8014,2,1735,'App\\Models\\Receipt',1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1100.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1898,7986,40759,8014,2,1736,'App\\Models\\Receipt',1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',900.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1899,7986,40759,8014,2,1737,'App\\Models\\Receipt',1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1600.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1900,7986,40759,8014,2,1738,'App\\Models\\Receipt',1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',950.00,NULL,NULL,1,'2023-02-14 12:34:33','2023-02-14 12:34:33',NULL),(1901,7986,40759,8014,2,1739,'App\\Models\\Receipt',1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2900.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1902,7986,40759,8014,2,1740,'App\\Models\\Receipt',1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2499.99,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1903,7986,40759,8014,2,1741,'App\\Models\\Receipt',1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',2900.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1904,7986,40759,8014,2,1742,'App\\Models\\Receipt',1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1100.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1905,7986,40759,8014,2,1743,'App\\Models\\Receipt',1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',1600.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1906,7986,40759,8014,2,1744,'App\\Models\\Receipt',1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',900.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1907,7986,40759,8014,2,1745,'App\\Models\\Receipt',1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',900.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL);
INSERT INTO `balance_libro` VALUES (1908,7986,40759,8014,2,1746,'App\\Models\\Receipt',1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',900.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1909,7986,40759,8014,2,1747,'App\\Models\\Receipt',1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1600.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1910,7986,40759,8014,2,1748,'App\\Models\\Receipt',1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',850.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1911,7986,40759,8014,2,1749,'App\\Models\\Receipt',1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1950.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1912,7986,40759,8014,2,1750,'App\\Models\\Receipt',1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',700.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1913,7986,40759,8014,2,1751,'App\\Models\\Receipt',1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',999.99,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1914,7986,40759,8014,2,1752,'App\\Models\\Receipt',1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2499.99,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1915,7986,40759,8014,2,1753,'App\\Models\\Receipt',1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',500.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1916,7986,40759,8014,2,1754,'App\\Models\\Receipt',1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',800.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1917,7986,40759,8014,2,1755,'App\\Models\\Receipt',1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1600.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1918,7986,40759,8014,2,1756,'App\\Models\\Receipt',1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',2900.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1919,7986,40759,8014,2,1757,'App\\Models\\Receipt',1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1449.99,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1920,7986,40759,8014,2,1758,'App\\Models\\Receipt',1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1150.01,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1921,7986,40759,8014,2,1759,'App\\Models\\Receipt',1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1250.00,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1922,7986,40759,8014,2,1760,'App\\Models\\Receipt',1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1150.01,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1923,7986,40759,8014,2,1761,'App\\Models\\Receipt',1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',1199.99,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1924,7986,40759,8014,2,1762,'App\\Models\\Receipt',1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1350.01,NULL,NULL,1,'2023-02-14 12:34:34','2023-02-14 12:34:34',NULL),(1925,7986,40759,8014,2,1763,'App\\Models\\Receipt',1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1100.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1926,7986,40759,8014,2,1764,'App\\Models\\Receipt',1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',700.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1927,7986,40759,8014,2,1765,'App\\Models\\Receipt',1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',900.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1928,7986,40759,8014,2,1766,'App\\Models\\Receipt',1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1050.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL);
INSERT INTO `balance_libro` VALUES (1929,7986,40759,8014,2,1767,'App\\Models\\Receipt',1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1440.01,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1930,7986,40759,8014,2,1768,'App\\Models\\Receipt',1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',700.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1931,7986,40759,8014,2,1769,'App\\Models\\Receipt',1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1100.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1932,7986,40759,8014,2,1770,'App\\Models\\Receipt',1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',900.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1933,7986,40759,8014,2,1771,'App\\Models\\Receipt',1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',999.99,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1934,7986,40759,8014,2,1772,'App\\Models\\Receipt',1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',500.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1935,7986,40759,8014,2,1773,'App\\Models\\Receipt',1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',850.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1936,7986,40759,8014,2,1774,'App\\Models\\Receipt',1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1500.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1937,7986,40759,8014,2,1775,'App\\Models\\Receipt',1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1600.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1938,7986,40759,8014,2,1776,'App\\Models\\Receipt',1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',749.99,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1939,7986,40759,8014,2,1777,'App\\Models\\Receipt',1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1050.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1940,7986,40759,8014,2,1778,'App\\Models\\Receipt',1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',900.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1941,7986,40759,8014,2,1779,'App\\Models\\Receipt',1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',999.99,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1942,7986,40759,8014,2,1780,'App\\Models\\Receipt',1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1600.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1943,7986,40759,8014,2,1781,'App\\Models\\Receipt',1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1600.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1944,7986,40759,8014,2,1782,'App\\Models\\Receipt',1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1600.00,NULL,NULL,1,'2023-02-14 12:34:35','2023-02-14 12:34:35',NULL),(1945,7986,40759,8014,2,1783,'App\\Models\\Receipt',1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1350.01,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1946,7986,40759,8014,2,1784,'App\\Models\\Receipt',1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1399.99,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1947,7986,40759,8014,2,1785,'App\\Models\\Receipt',1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1600.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1948,7986,40759,8014,2,1786,'App\\Models\\Receipt',1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1600.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1949,7986,40759,8014,2,1787,'App\\Models\\Receipt',1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1649.99,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL);
INSERT INTO `balance_libro` VALUES (1950,7986,40759,8014,2,1788,'App\\Models\\Receipt',1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',1649.99,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1951,7986,40759,8014,2,1789,'App\\Models\\Receipt',1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',900.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1952,7986,40759,8014,2,1790,'App\\Models\\Receipt',1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',900.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1953,7986,40759,8014,2,1791,'App\\Models\\Receipt',1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',900.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1954,7986,40759,8014,2,1792,'App\\Models\\Receipt',1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1350.01,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1955,7986,40759,8014,2,1793,'App\\Models\\Receipt',1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1000.01,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1956,7986,40759,8014,2,1794,'App\\Models\\Receipt',1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1000.01,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1957,7986,40759,8014,2,1795,'App\\Models\\Receipt',1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',350.01,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1958,7986,40759,8014,2,1796,'App\\Models\\Receipt',1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',2900.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1959,7986,40759,8014,2,1797,'App\\Models\\Receipt',1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1600.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1960,7986,40759,8014,2,1798,'App\\Models\\Receipt',1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',2550.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1961,7986,40759,8014,2,1799,'App\\Models\\Receipt',1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1600.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1962,7986,40759,8014,2,1800,'App\\Models\\Receipt',1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',900.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1963,7986,40759,8014,2,1801,'App\\Models\\Receipt',1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',900.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1964,7986,40759,8014,2,1802,'App\\Models\\Receipt',1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',900.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1965,7986,40759,8014,2,1803,'App\\Models\\Receipt',1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',900.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1966,7986,40759,8014,2,1804,'App\\Models\\Receipt',1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',2400.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1967,7986,40759,8014,2,1805,'App\\Models\\Receipt',1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',2999.99,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1968,7986,40759,8014,2,1806,'App\\Models\\Receipt',1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',900.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1969,7986,40759,8014,2,1807,'App\\Models\\Receipt',1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1350.01,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL),(1970,7986,40759,8014,2,1808,'App\\Models\\Receipt',1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1750.00,NULL,NULL,1,'2023-02-14 12:34:36','2023-02-14 12:34:36',NULL);
INSERT INTO `balance_libro` VALUES (1971,7986,40759,8014,2,1809,'App\\Models\\Receipt',1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1600.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1972,7986,40759,8014,2,1810,'App\\Models\\Receipt',1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',900.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1973,7986,40759,8014,2,1811,'App\\Models\\Receipt',1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',2900.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1974,7986,40759,8014,2,1812,'App\\Models\\Receipt',1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',900.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1975,7986,40759,8014,2,1813,'App\\Models\\Receipt',1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',700.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1976,7986,40759,8014,2,1814,'App\\Models\\Receipt',1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',900.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1977,7986,40759,8014,2,1815,'App\\Models\\Receipt',1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1000.01,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1978,7986,40759,8014,2,1816,'App\\Models\\Receipt',1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1600.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1979,7986,40759,8014,2,1817,'App\\Models\\Receipt',1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',900.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1980,7986,40759,8014,2,1818,'App\\Models\\Receipt',1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1600.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1981,7986,40759,8014,2,1819,'App\\Models\\Receipt',1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',2350.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1982,7986,40759,8014,2,1820,'App\\Models\\Receipt',1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1300.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1983,7986,40759,8014,2,1821,'App\\Models\\Receipt',1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1600.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1984,7986,40759,8014,2,1822,'App\\Models\\Receipt',1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',2900.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1985,7986,40759,8014,2,1823,'App\\Models\\Receipt',1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',1199.99,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1986,7986,40759,8014,2,1824,'App\\Models\\Receipt',1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-29','2023-01-29',950.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1987,7986,40759,8014,2,1825,'App\\Models\\Receipt',1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',700.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1988,7986,40759,8014,2,1826,'App\\Models\\Receipt',1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1600.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1989,7986,40759,8014,2,1827,'App\\Models\\Receipt',1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',700.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1990,7986,40759,8014,2,1828,'App\\Models\\Receipt',1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1600.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1991,7986,40759,8014,2,1829,'App\\Models\\Receipt',1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',900.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL);
INSERT INTO `balance_libro` VALUES (1992,7986,40759,8014,2,1830,'App\\Models\\Receipt',1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1600.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1993,7986,40759,8014,2,1831,'App\\Models\\Receipt',1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',900.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1994,7986,40759,8014,2,1832,'App\\Models\\Receipt',1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1450.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1995,7986,40759,8014,2,1833,'App\\Models\\Receipt',1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',900.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1996,7986,40759,8014,2,1834,'App\\Models\\Receipt',1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',450.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1997,7986,40759,8014,2,1835,'App\\Models\\Receipt',1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1600.00,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1998,7986,40759,8014,2,1836,'App\\Models\\Receipt',1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1200.01,NULL,NULL,1,'2023-02-14 12:34:37','2023-02-14 12:34:37',NULL),(1999,7986,40759,8014,2,1837,'App\\Models\\Receipt',1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',550.01,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2000,7986,40759,8014,2,1838,'App\\Models\\Receipt',1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',250.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2001,7986,40759,8014,2,1839,'App\\Models\\Receipt',1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',550.01,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2002,7986,40759,8014,2,1840,'App\\Models\\Receipt',1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',800.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2003,7986,40759,8014,2,1841,'App\\Models\\Receipt',1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1600.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2004,7986,40759,8014,2,1842,'App\\Models\\Receipt',1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',1600.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2005,7986,40759,8014,2,1843,'App\\Models\\Receipt',1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',900.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2006,7986,40759,8014,2,1844,'App\\Models\\Receipt',1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',550.01,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2007,7986,40759,8014,2,1845,'App\\Models\\Receipt',1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',900.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2008,7986,40759,8014,2,1846,'App\\Models\\Receipt',1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',550.01,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2009,7986,40759,8014,2,1847,'App\\Models\\Receipt',1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',600.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2010,7986,40759,8014,2,1848,'App\\Models\\Receipt',1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1900.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2011,7986,40759,8014,2,1849,'App\\Models\\Receipt',1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1600.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2012,7986,40759,8014,2,1850,'App\\Models\\Receipt',1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1100.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL);
INSERT INTO `balance_libro` VALUES (2013,7986,40759,8014,2,1851,'App\\Models\\Receipt',1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',900.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2014,7986,40759,8014,2,1852,'App\\Models\\Receipt',1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1399.99,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2015,7986,40759,8014,2,1853,'App\\Models\\Receipt',1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',550.01,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2016,7986,40759,8014,2,1854,'App\\Models\\Receipt',1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',900.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2017,7986,40759,8014,2,1855,'App\\Models\\Receipt',1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',700.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2018,7986,40759,8014,2,1856,'App\\Models\\Receipt',1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1199.99,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2019,7986,40759,8014,2,1857,'App\\Models\\Receipt',1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',900.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2020,7986,40759,8014,2,1858,'App\\Models\\Receipt',1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',550.01,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2021,7986,40759,8014,2,1859,'App\\Models\\Receipt',1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',750.01,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2022,7986,40759,8014,2,1860,'App\\Models\\Receipt',1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1600.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2023,7986,40759,8014,2,1861,'App\\Models\\Receipt',1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1150.00,NULL,NULL,1,'2023-02-14 12:34:38','2023-02-14 12:34:38',NULL),(2024,7986,40759,8014,2,1862,'App\\Models\\Receipt',1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1150.00,NULL,NULL,1,'2023-02-14 12:34:39','2023-02-14 12:34:39',NULL),(2025,7986,40759,8014,2,1863,'App\\Models\\Receipt',1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',919.99,NULL,NULL,1,'2023-02-14 12:34:39','2023-02-14 12:34:39',NULL),(2026,7986,40759,8014,2,1864,'App\\Models\\Receipt',1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',2900.00,NULL,NULL,1,'2023-02-14 12:34:39','2023-02-14 12:34:39',NULL),(2027,7986,40759,8014,2,1865,'App\\Models\\Receipt',1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',1000.01,NULL,NULL,1,'2023-02-14 12:34:39','2023-02-14 12:34:39',NULL),(2028,7986,40759,8014,3,1866,'App\\Models\\Receipt',1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',12862.72,NULL,NULL,1,'2023-02-15 09:11:22','2023-02-15 09:11:22',NULL),(2029,7986,40759,8014,3,1258,'App\\Models\\Receipt',1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',10019.02,NULL,NULL,1,'2023-02-15 09:19:29','2023-02-15 09:19:29',NULL),(2030,7986,40759,8014,3,1257,'App\\Models\\Receipt',1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-25','2023-01-25',150887.24,NULL,NULL,1,'2023-02-15 09:19:59','2023-02-15 09:19:59',NULL),(2031,7986,40759,8014,3,1256,'App\\Models\\Receipt',1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-24','2023-01-24',42539.19,NULL,NULL,1,'2023-02-15 09:20:27','2023-02-15 09:20:27',NULL),(2032,7986,40759,8014,3,1253,'App\\Models\\Receipt',1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',12035.25,NULL,NULL,1,'2023-02-15 09:21:17','2023-02-15 09:21:17',NULL),(2033,7986,40759,8014,3,1252,'App\\Models\\Receipt',1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',106511.10,NULL,NULL,1,'2023-02-15 09:21:42','2023-02-15 09:21:42',NULL);
INSERT INTO `balance_libro` VALUES (2034,7986,40759,8014,3,1250,'App\\Models\\Receipt',1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-17','2023-01-17',89119.44,NULL,NULL,1,'2023-02-15 09:22:16','2023-02-15 09:22:16',NULL),(2035,7986,40759,8014,3,1246,'App\\Models\\Receipt',1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8013.96,NULL,NULL,1,'2023-02-15 09:23:45','2023-02-15 09:23:45',NULL),(2036,7986,40759,8014,3,1245,'App\\Models\\Receipt',1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',105979.54,NULL,NULL,1,'2023-02-15 09:24:23','2023-02-15 09:24:23',NULL),(2037,7986,40759,8014,3,1244,'App\\Models\\Receipt',1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',42548.58,NULL,NULL,1,'2023-02-15 09:24:58','2023-02-15 09:24:58',NULL),(2038,7986,40759,8014,3,1241,'App\\Models\\Receipt',1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',12602.20,NULL,NULL,1,'2023-02-15 09:25:36','2023-02-15 09:25:36',NULL),(2039,7986,40759,8014,3,1240,'App\\Models\\Receipt',1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',74945.51,NULL,NULL,1,'2023-02-15 09:26:09','2023-02-15 09:26:09',NULL),(2040,7986,40759,8014,3,1867,'App\\Models\\Receipt',1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',6975.00,NULL,NULL,1,'2023-02-15 09:34:29','2023-02-15 09:34:29',NULL),(2041,7986,40759,8014,8,1868,'App\\Models\\Receipt',1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',779.26,NULL,NULL,1,'2023-02-15 09:38:19','2023-02-15 09:38:19',NULL),(2042,7986,40720,1518,3,1869,'App\\Models\\Receipt',1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-28','2022-12-28',1770.00,NULL,NULL,1,'2023-02-15 09:53:23','2023-02-15 09:53:23',NULL),(2043,7986,40720,1518,3,1870,'App\\Models\\Receipt',1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',8000.06,NULL,NULL,1,'2023-02-15 09:54:37','2023-02-15 09:54:37',NULL),(2044,7986,40720,1518,3,1871,'App\\Models\\Receipt',1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',6500.38,NULL,NULL,1,'2023-02-15 09:55:25','2023-02-15 09:55:25',NULL),(2045,7986,40720,1518,3,1872,'App\\Models\\Receipt',1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3600.21,NULL,NULL,1,'2023-02-15 09:56:06','2023-02-15 09:56:06',NULL),(2046,7986,40720,1518,3,1873,'App\\Models\\Receipt',1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',26230.00,NULL,NULL,1,'2023-02-15 09:58:10','2023-02-15 09:58:10',NULL),(2047,7986,40776,17353,3,1874,'App\\Models\\Receipt',1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-03','2023-01-03',101230.00,NULL,NULL,1,'2023-02-15 10:06:20','2023-02-15 10:06:20',NULL),(2048,7986,40776,17353,3,1875,'App\\Models\\Receipt',1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',7500.02,NULL,NULL,1,'2023-02-15 10:07:41','2023-02-15 10:07:41',NULL),(2049,7986,40776,17353,3,1876,'App\\Models\\Receipt',1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-06','2023-01-06',9312.12,NULL,NULL,1,'2023-02-15 10:09:35','2023-02-15 10:09:35',NULL),(2050,7986,40776,17353,3,1877,'App\\Models\\Receipt',1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-07','2023-01-07',35000.00,NULL,NULL,1,'2023-02-15 10:10:43','2023-02-15 10:10:43',NULL),(2051,7986,40776,17353,3,1878,'App\\Models\\Receipt',1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',7000.00,NULL,NULL,1,'2023-02-15 10:13:49','2023-02-15 10:13:49',NULL),(2052,7986,40776,17353,3,1879,'App\\Models\\Receipt',1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',9567.91,NULL,NULL,1,'2023-02-15 10:15:41','2023-02-15 10:15:41',NULL),(2053,7986,40776,17353,3,1880,'App\\Models\\Receipt',1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',62.28,NULL,NULL,1,'2023-02-15 10:16:52','2023-02-15 10:16:52',NULL),(2054,7986,40721,3016,16,687,'App\\Models\\PeriodLiquidation',NULL,687,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',483175.84,NULL,NULL,1,'2023-02-16 12:08:31','2023-02-16 12:08:31',NULL);
INSERT INTO `balance_libro` VALUES (2055,7986,40721,3016,15,686,'App\\Models\\PeriodLiquidation',NULL,686,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',283611.94,NULL,NULL,1,'2023-02-16 12:09:10','2023-02-16 12:09:10',NULL),(2056,7986,40720,1517,15,504,'App\\Models\\PeriodLiquidation',NULL,504,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',188674.86,NULL,NULL,1,'2023-02-17 09:01:33','2023-04-20 11:30:57','2023-04-20 11:30:57'),(2057,7986,40721,3018,3,1881,'App\\Models\\Receipt',1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',94190.00,NULL,NULL,1,'2023-02-17 09:16:01','2023-02-17 09:16:01',NULL),(2058,7986,40721,3018,3,1882,'App\\Models\\Receipt',1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-18','2022-11-18',21712.13,NULL,NULL,1,'2023-02-17 09:17:25','2023-02-17 09:17:25',NULL),(2059,7986,40721,3018,3,1883,'App\\Models\\Receipt',1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-26','2022-11-26',6800.03,NULL,NULL,1,'2023-02-17 09:19:10','2023-02-17 09:19:10',NULL),(2060,7986,40721,3018,3,1884,'App\\Models\\Receipt',1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',11129.58,NULL,NULL,1,'2023-02-17 09:20:08','2023-02-17 09:20:08',NULL),(2061,7986,40721,3018,3,1885,'App\\Models\\Receipt',1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-01','2022-12-01',51211.21,NULL,NULL,1,'2023-02-17 09:21:39','2023-02-17 09:21:39',NULL),(2062,7986,40721,3018,3,1886,'App\\Models\\Receipt',1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-14','2022-12-14',13439.35,NULL,NULL,1,'2023-02-17 09:25:55','2023-02-17 09:25:55',NULL),(2063,7986,40721,3018,3,1887,'App\\Models\\Receipt',1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-27','2022-12-27',19079.28,NULL,NULL,1,'2023-02-17 09:29:00','2023-02-17 09:29:00',NULL),(2064,7986,40721,3018,3,1888,'App\\Models\\Receipt',1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-30','2022-12-30',210905.41,NULL,NULL,1,'2023-02-17 09:30:39','2023-02-17 09:30:39',NULL),(2065,7986,40721,3018,3,1889,'App\\Models\\Receipt',1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',3714.31,NULL,NULL,1,'2023-02-17 09:46:24','2023-02-17 09:46:24',NULL),(2066,7986,40721,3018,3,1165,'App\\Models\\Receipt',1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-04','2023-01-04',8443.73,NULL,NULL,1,'2023-02-17 09:50:27','2023-02-17 09:50:27',NULL),(2067,7986,40721,3018,3,1168,'App\\Models\\Receipt',1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7608.06,NULL,NULL,1,'2023-02-17 09:51:14','2023-02-17 09:51:14',NULL),(2068,7986,40721,3018,3,1169,'App\\Models\\Receipt',1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',10787.17,NULL,NULL,1,'2023-02-17 09:51:44','2023-02-17 09:51:44',NULL),(2069,7986,40721,3018,3,1172,'App\\Models\\Receipt',1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',28467.08,NULL,NULL,1,'2023-02-17 09:53:09','2023-02-17 09:53:09',NULL),(2070,7986,40721,3018,3,1177,'App\\Models\\Receipt',1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-10','2023-01-10',11167.58,NULL,NULL,1,'2023-02-17 09:53:53','2023-02-17 09:53:53',NULL),(2071,7986,40721,3018,3,1179,'App\\Models\\Receipt',1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-11','2023-01-11',40933.18,NULL,NULL,1,'2023-02-17 09:54:38','2023-02-17 09:54:38',NULL),(2072,7986,40721,3018,3,1180,'App\\Models\\Receipt',1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-12','2023-01-12',8273.56,NULL,NULL,1,'2023-02-17 09:55:47','2023-02-17 09:55:47',NULL),(2073,7986,40721,3018,3,1184,'App\\Models\\Receipt',1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-13','2023-01-13',36468.70,NULL,NULL,1,'2023-02-17 09:56:21','2023-02-17 09:56:21',NULL),(2074,7986,40721,3018,3,1186,'App\\Models\\Receipt',1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',49318.76,NULL,NULL,1,'2023-02-17 09:56:54','2023-02-17 09:56:54',NULL);
INSERT INTO `balance_libro` VALUES (2075,7986,40721,3018,3,1185,'App\\Models\\Receipt',1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-14','2023-01-14',84496.78,NULL,NULL,1,'2023-02-17 09:57:29','2023-02-17 09:57:29',NULL),(2076,7986,40721,3018,3,1190,'App\\Models\\Receipt',1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-16','2023-01-16',28153.99,NULL,NULL,1,'2023-02-17 09:58:20','2023-02-17 09:58:20',NULL),(2077,7986,40721,3018,3,1193,'App\\Models\\Receipt',1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-18','2023-01-18',22240.85,NULL,NULL,1,'2023-02-17 09:58:55','2023-02-17 09:58:55',NULL),(2078,7986,40721,3018,3,1196,'App\\Models\\Receipt',1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4286.52,NULL,NULL,1,'2023-02-17 09:59:44','2023-02-17 09:59:44',NULL),(2079,7986,40721,3018,3,1197,'App\\Models\\Receipt',1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',69281.07,NULL,NULL,1,'2023-02-17 10:00:16','2023-02-17 10:00:16',NULL),(2080,7986,40721,3018,3,1198,'App\\Models\\Receipt',1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',15046.57,NULL,NULL,1,'2023-02-17 10:00:46','2023-02-17 10:00:46',NULL),(2081,7986,40721,3018,3,1199,'App\\Models\\Receipt',1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4244.13,NULL,NULL,1,'2023-02-17 10:01:14','2023-02-17 10:01:14',NULL),(2082,7986,40721,3018,3,1200,'App\\Models\\Receipt',1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',4486.93,NULL,NULL,1,'2023-02-17 10:01:41','2023-02-17 10:01:41',NULL),(2083,7986,40721,3018,3,1201,'App\\Models\\Receipt',1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-19','2023-01-19',30602.62,NULL,NULL,1,'2023-02-17 10:02:15','2023-02-17 10:02:15',NULL),(2084,7986,40721,3018,3,1204,'App\\Models\\Receipt',1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',1029.22,NULL,NULL,1,'2023-02-17 10:05:00','2023-02-17 10:05:00',NULL),(2085,7986,40721,3018,3,1205,'App\\Models\\Receipt',1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-20','2023-01-20',10312.16,NULL,NULL,1,'2023-02-17 10:05:31','2023-02-17 10:05:31',NULL),(2086,7986,40721,3018,3,1206,'App\\Models\\Receipt',1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-21','2023-01-21',42388.64,NULL,NULL,1,'2023-02-17 10:06:07','2023-02-17 10:06:07',NULL),(2087,7986,40721,3018,3,1208,'App\\Models\\Receipt',1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',7942.95,NULL,NULL,1,'2023-02-17 10:06:36','2023-02-17 10:06:36',NULL),(2088,7986,40721,3018,3,1211,'App\\Models\\Receipt',1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-23','2023-01-23',60791.01,NULL,NULL,1,'2023-02-17 10:07:16','2023-02-17 10:07:16',NULL),(2089,7986,40721,3018,3,1215,'App\\Models\\Receipt',1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-26','2023-01-26',10301.62,NULL,NULL,1,'2023-02-17 10:08:57','2023-02-17 10:08:57',NULL),(2090,7986,40721,3018,3,1216,'App\\Models\\Receipt',1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',25174.51,NULL,NULL,1,'2023-02-17 10:09:33','2023-02-17 10:09:33',NULL),(2091,7986,40721,3018,3,1217,'App\\Models\\Receipt',1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-27','2023-01-27',17165.32,NULL,NULL,1,'2023-02-17 10:10:10','2023-02-17 10:10:10',NULL),(2092,7986,40721,3018,3,1219,'App\\Models\\Receipt',1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-28','2023-01-28',87114.82,NULL,NULL,1,'2023-02-17 10:10:48','2023-02-17 10:10:48',NULL),(2093,7986,40721,3018,3,1225,'App\\Models\\Receipt',1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',135199.31,NULL,NULL,1,'2023-02-17 10:11:28','2023-02-17 10:11:28',NULL),(2094,7986,40759,8014,16,873,'App\\Models\\PeriodLiquidation',NULL,873,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',20827.41,NULL,NULL,1,'2023-02-17 11:03:49','2023-02-17 11:03:49',NULL),(2095,7986,40759,8014,15,874,'App\\Models\\PeriodLiquidation',NULL,874,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',348364.97,NULL,NULL,1,'2023-02-17 11:03:58','2023-02-17 11:03:58',NULL);
INSERT INTO `balance_libro` VALUES (2096,7986,40774,12518,1,2096,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-02-28',NULL,59852.39,NULL,NULL,1,'2023-02-17 11:16:15','2023-02-17 11:16:15',NULL),(2097,7986,40720,1518,15,864,'App\\Models\\PeriodLiquidation',NULL,864,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',210326.51,NULL,NULL,1,'2023-02-17 11:40:43','2023-02-17 11:40:43',NULL),(2098,7986,40774,12517,1,2098,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-01-31',NULL,59842.89,NULL,NULL,1,'2023-02-17 11:44:09','2023-02-17 11:44:09',NULL),(2099,7986,40776,17353,1,2099,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-01-31',NULL,64678.66,NULL,NULL,1,'2023-02-17 11:52:08','2023-02-17 15:02:41','2023-02-17 15:02:41'),(2100,7986,40776,17353,1,2100,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-01-31',NULL,64678.66,NULL,NULL,1,'2023-02-17 15:06:20','2023-02-17 15:06:20',NULL),(2101,7986,40776,17354,1,2101,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-02-28',NULL,63564.89,NULL,NULL,1,'2023-02-17 16:04:33','2023-02-17 16:04:33',NULL),(2102,7986,40721,3018,15,878,'App\\Models\\PeriodLiquidation',NULL,878,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',330561.19,NULL,NULL,1,'2023-02-23 09:42:52','2023-02-23 09:42:52',NULL),(2103,7986,40721,3018,16,876,'App\\Models\\PeriodLiquidation',NULL,876,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',461805.43,NULL,NULL,1,'2023-02-23 10:47:21','2023-02-23 10:47:21',NULL),(2104,7986,40776,17352,15,519,'App\\Models\\PeriodLiquidation',NULL,519,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',435481.04,NULL,NULL,1,'2023-02-24 12:10:13','2023-02-24 12:10:13',NULL),(2105,7986,40772,11018,1,2105,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-02-28',NULL,332631.49,NULL,NULL,1,'2023-03-03 12:46:08','2023-03-08 09:50:40','2023-03-08 09:50:40'),(2106,7986,40772,11018,1,2106,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-02-28',NULL,332631.49,NULL,NULL,1,'2023-03-08 09:58:56','2023-03-08 09:58:56',NULL),(2107,7986,40759,8015,2,1890,'App\\Models\\Receipt',1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',600.00,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL),(2108,7986,40759,8015,2,1891,'App\\Models\\Receipt',1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1600.00,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL),(2109,7986,40759,8015,2,1892,'App\\Models\\Receipt',1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',700.00,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL),(2110,7986,40759,8015,2,1893,'App\\Models\\Receipt',1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',2450.01,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL),(2111,7986,40759,8015,2,1894,'App\\Models\\Receipt',1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1800.01,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL),(2112,7986,40759,8015,2,1895,'App\\Models\\Receipt',1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',1050.00,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL),(2113,7986,40759,8015,2,1896,'App\\Models\\Receipt',1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',4500.00,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL),(2114,7986,40759,8015,2,1897,'App\\Models\\Receipt',1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1600.00,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL),(2115,7986,40759,8015,2,1898,'App\\Models\\Receipt',1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1600.00,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL);
INSERT INTO `balance_libro` VALUES (2116,7986,40759,8015,2,1899,'App\\Models\\Receipt',1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',550.01,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL),(2117,7986,40759,8015,2,1900,'App\\Models\\Receipt',1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',350.01,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL),(2118,7986,40759,8015,2,1901,'App\\Models\\Receipt',1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',550.01,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL),(2119,7986,40759,8015,2,1902,'App\\Models\\Receipt',1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',550.01,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL),(2120,7986,40759,8015,2,1903,'App\\Models\\Receipt',1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',350.01,NULL,NULL,1,'2023-03-10 09:57:08','2023-03-10 09:57:08',NULL),(2121,7986,40759,8015,2,1904,'App\\Models\\Receipt',1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1699.99,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2122,7986,40759,8015,2,1905,'App\\Models\\Receipt',1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',600.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2123,7986,40759,8015,2,1906,'App\\Models\\Receipt',1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1600.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2124,7986,40759,8015,2,1907,'App\\Models\\Receipt',1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1700.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2125,7986,40759,8015,2,1908,'App\\Models\\Receipt',1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',700.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2126,7986,40759,8015,2,1909,'App\\Models\\Receipt',1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',900.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2127,7986,40759,8015,2,1910,'App\\Models\\Receipt',1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1350.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2128,7986,40759,8015,2,1911,'App\\Models\\Receipt',1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2500.01,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2129,7986,40759,8015,2,1912,'App\\Models\\Receipt',1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1600.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2130,7986,40759,8015,2,1913,'App\\Models\\Receipt',1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2949.99,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2131,7986,40759,8015,2,1914,'App\\Models\\Receipt',1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1050.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2132,7986,40759,8015,2,1915,'App\\Models\\Receipt',1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',950.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2133,7986,40759,8015,2,1916,'App\\Models\\Receipt',1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',2900.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2134,7986,40759,8015,2,1917,'App\\Models\\Receipt',1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',900.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2135,7986,40759,8015,2,1918,'App\\Models\\Receipt',1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',1350.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2136,7986,40759,8015,2,1919,'App\\Models\\Receipt',1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',850.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL);
INSERT INTO `balance_libro` VALUES (2137,7986,40759,8015,2,1920,'App\\Models\\Receipt',1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',800.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2138,7986,40759,8015,2,1921,'App\\Models\\Receipt',1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',700.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2139,7986,40759,8015,2,1922,'App\\Models\\Receipt',1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',900.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2140,7986,40759,8015,2,1923,'App\\Models\\Receipt',1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1900.00,NULL,NULL,1,'2023-03-10 09:57:09','2023-03-10 09:57:09',NULL),(2141,7986,40759,8015,2,1924,'App\\Models\\Receipt',1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1350.01,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2142,7986,40759,8015,2,1925,'App\\Models\\Receipt',1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',700.00,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2143,7986,40759,8015,2,1926,'App\\Models\\Receipt',1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1150.00,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2144,7986,40759,8015,2,1927,'App\\Models\\Receipt',1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1649.99,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2145,7986,40759,8015,2,1928,'App\\Models\\Receipt',1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',600.00,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2146,7986,40759,8015,2,1929,'App\\Models\\Receipt',1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',749.99,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2147,7986,40759,8015,2,1930,'App\\Models\\Receipt',1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',2800.00,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2148,7986,40759,8015,2,1931,'App\\Models\\Receipt',1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',900.00,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2149,7986,40759,8015,2,1932,'App\\Models\\Receipt',1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1699.99,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2150,7986,40759,8015,2,1933,'App\\Models\\Receipt',1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',2900.00,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2151,7986,40759,8015,2,1934,'App\\Models\\Receipt',1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1399.99,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2152,7986,40759,8015,2,1935,'App\\Models\\Receipt',1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1249.99,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2153,7986,40759,8015,2,1936,'App\\Models\\Receipt',1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',900.00,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2154,7986,40759,8015,2,1937,'App\\Models\\Receipt',1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1050.00,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2155,7986,40759,8015,2,1938,'App\\Models\\Receipt',1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',850.00,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2156,7986,40759,8015,2,1939,'App\\Models\\Receipt',1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1219.98,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL),(2157,7986,40759,8015,2,1940,'App\\Models\\Receipt',1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',900.00,NULL,NULL,1,'2023-03-10 09:57:10','2023-03-10 09:57:10',NULL);
INSERT INTO `balance_libro` VALUES (2158,7986,40759,8015,2,1941,'App\\Models\\Receipt',1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1700.00,NULL,NULL,1,'2023-03-10 09:57:11','2023-03-10 09:57:11',NULL),(2159,7986,40759,8015,2,1942,'App\\Models\\Receipt',1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',3300.00,NULL,NULL,1,'2023-03-10 09:57:11','2023-03-10 09:57:11',NULL),(2160,7986,40759,8015,2,1943,'App\\Models\\Receipt',1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1699.99,NULL,NULL,1,'2023-03-10 09:57:11','2023-03-10 09:57:11',NULL),(2161,7986,40759,8015,2,1944,'App\\Models\\Receipt',1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1699.99,NULL,NULL,1,'2023-03-10 09:57:11','2023-03-10 09:57:11',NULL),(2162,7986,40759,8015,2,1945,'App\\Models\\Receipt',1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',450.00,NULL,NULL,1,'2023-03-10 09:57:11','2023-03-10 09:57:11',NULL),(2163,7986,40759,8015,2,1946,'App\\Models\\Receipt',1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1600.00,NULL,NULL,1,'2023-03-10 09:57:11','2023-03-10 09:57:11',NULL),(2164,7986,40759,8015,2,1947,'App\\Models\\Receipt',1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',550.01,NULL,NULL,1,'2023-03-10 09:57:11','2023-03-10 09:57:11',NULL),(2165,7986,40759,8015,2,1948,'App\\Models\\Receipt',1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1849.99,NULL,NULL,1,'2023-03-10 09:57:11','2023-03-10 09:57:11',NULL),(2166,7986,40759,8015,2,1949,'App\\Models\\Receipt',1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',2900.00,NULL,NULL,1,'2023-03-10 09:57:11','2023-03-10 09:57:11',NULL),(2167,7986,40759,8015,2,1950,'App\\Models\\Receipt',1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',700.00,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2168,7986,40759,8015,2,1951,'App\\Models\\Receipt',1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1600.00,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2169,7986,40759,8015,2,1952,'App\\Models\\Receipt',1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1500.00,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2170,7986,40759,8015,2,1953,'App\\Models\\Receipt',1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',799.99,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2171,7986,40759,8015,2,1954,'App\\Models\\Receipt',1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',700.00,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2172,7986,40759,8015,2,1955,'App\\Models\\Receipt',1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',3799.99,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2173,7986,40759,8015,2,1956,'App\\Models\\Receipt',1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',500.00,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2174,7986,40759,8015,2,1957,'App\\Models\\Receipt',1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',900.00,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2175,7986,40759,8015,2,1958,'App\\Models\\Receipt',1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1600.00,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2176,7986,40759,8015,2,1959,'App\\Models\\Receipt',1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',600.00,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2177,7986,40759,8015,2,1960,'App\\Models\\Receipt',1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1899.99,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2178,7986,40759,8015,2,1961,'App\\Models\\Receipt',1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',900.00,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL);
INSERT INTO `balance_libro` VALUES (2179,7986,40759,8015,2,1962,'App\\Models\\Receipt',1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',2900.00,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2180,7986,40759,8015,2,1963,'App\\Models\\Receipt',1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1399.99,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2181,7986,40759,8015,2,1964,'App\\Models\\Receipt',1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',2749.99,NULL,NULL,1,'2023-03-10 09:57:12','2023-03-10 09:57:12',NULL),(2182,7986,40759,8015,2,1965,'App\\Models\\Receipt',1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1050.00,NULL,NULL,1,'2023-03-10 09:57:13','2023-03-10 09:57:13',NULL),(2183,7986,40759,8015,2,1966,'App\\Models\\Receipt',1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',950.00,NULL,NULL,1,'2023-03-10 09:57:13','2023-03-10 09:57:13',NULL),(2184,7986,40759,8015,2,1967,'App\\Models\\Receipt',1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1600.00,NULL,NULL,1,'2023-03-10 09:57:13','2023-03-10 09:57:13',NULL),(2185,7986,40759,8015,2,1968,'App\\Models\\Receipt',1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',550.01,NULL,NULL,1,'2023-03-10 09:57:13','2023-03-10 09:57:13',NULL),(2186,7986,40759,8015,2,1969,'App\\Models\\Receipt',1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',999.99,NULL,NULL,1,'2023-03-10 09:57:13','2023-03-10 09:57:13',NULL),(2187,7986,40759,8015,2,1970,'App\\Models\\Receipt',1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1000.01,NULL,NULL,1,'2023-03-10 09:57:13','2023-03-10 09:57:13',NULL),(2188,7986,40759,8015,2,1971,'App\\Models\\Receipt',1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1600.00,NULL,NULL,1,'2023-03-10 09:57:13','2023-03-10 09:57:13',NULL),(2189,7986,40759,8015,2,1972,'App\\Models\\Receipt',1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1600.00,NULL,NULL,1,'2023-03-10 09:57:13','2023-03-10 09:57:13',NULL),(2190,7986,40759,8015,2,1973,'App\\Models\\Receipt',1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1050.00,NULL,NULL,1,'2023-03-10 09:57:13','2023-03-10 09:57:13',NULL),(2191,7986,40759,8015,2,1974,'App\\Models\\Receipt',1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1250.00,NULL,NULL,1,'2023-03-10 09:57:13','2023-03-10 09:57:13',NULL),(2192,7986,40759,8015,2,1975,'App\\Models\\Receipt',1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1399.99,NULL,NULL,1,'2023-03-10 09:57:14','2023-03-10 09:57:14',NULL),(2193,7986,40759,8015,2,1976,'App\\Models\\Receipt',1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',700.00,NULL,NULL,1,'2023-03-10 09:57:14','2023-03-10 09:57:14',NULL),(2194,7986,40759,8015,2,1977,'App\\Models\\Receipt',1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',1600.00,NULL,NULL,1,'2023-03-10 09:57:14','2023-03-10 09:57:14',NULL),(2195,7986,40759,8015,2,1978,'App\\Models\\Receipt',1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',700.00,NULL,NULL,1,'2023-03-10 09:57:14','2023-03-10 09:57:14',NULL),(2196,7986,40759,8015,2,1979,'App\\Models\\Receipt',1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',900.00,NULL,NULL,1,'2023-03-10 09:57:14','2023-03-10 09:57:14',NULL),(2197,7986,40759,8015,2,1980,'App\\Models\\Receipt',1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1699.99,NULL,NULL,1,'2023-03-10 09:57:14','2023-03-10 09:57:14',NULL),(2198,7986,40759,8015,2,1981,'App\\Models\\Receipt',1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1600.00,NULL,NULL,1,'2023-03-10 09:57:14','2023-03-10 09:57:14',NULL),(2199,7986,40759,8015,2,1982,'App\\Models\\Receipt',1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1600.00,NULL,NULL,1,'2023-03-10 09:57:14','2023-03-10 09:57:14',NULL);
INSERT INTO `balance_libro` VALUES (2200,7986,40759,8015,2,1983,'App\\Models\\Receipt',1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',500.00,NULL,NULL,1,'2023-03-10 09:57:14','2023-03-10 09:57:14',NULL),(2201,7986,40759,8015,2,1984,'App\\Models\\Receipt',1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',600.00,NULL,NULL,1,'2023-03-10 09:57:14','2023-03-10 09:57:14',NULL),(2202,7986,40759,8015,2,1985,'App\\Models\\Receipt',1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',900.00,NULL,NULL,1,'2023-03-10 09:57:14','2023-03-10 09:57:14',NULL),(2203,7986,40759,8015,2,1986,'App\\Models\\Receipt',1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',900.00,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2204,7986,40759,8015,2,1987,'App\\Models\\Receipt',1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',4799.99,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2205,7986,40759,8015,2,1988,'App\\Models\\Receipt',1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',550.01,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2206,7986,40759,8015,2,1989,'App\\Models\\Receipt',1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1600.00,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2207,7986,40759,8015,2,1990,'App\\Models\\Receipt',1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1600.00,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2208,7986,40759,8015,2,1991,'App\\Models\\Receipt',1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1649.99,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2209,7986,40759,8015,2,1992,'App\\Models\\Receipt',1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',500.00,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2210,7986,40759,8015,2,1993,'App\\Models\\Receipt',1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',750.01,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2211,7986,40759,8015,2,1994,'App\\Models\\Receipt',1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1150.01,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2212,7986,40759,8015,2,1995,'App\\Models\\Receipt',1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1749.99,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2213,7986,40759,8015,2,1996,'App\\Models\\Receipt',1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1900.00,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2214,7986,40759,8015,2,1997,'App\\Models\\Receipt',1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',900.00,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2215,7986,40759,8015,2,1998,'App\\Models\\Receipt',1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1600.00,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2216,7986,40759,8015,2,1999,'App\\Models\\Receipt',1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1600.00,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2217,7986,40759,8015,2,2000,'App\\Models\\Receipt',2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',900.00,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2218,7986,40759,8015,2,2001,'App\\Models\\Receipt',2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1800.00,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2219,7986,40759,8015,2,2002,'App\\Models\\Receipt',2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',700.00,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL),(2220,7986,40759,8015,2,2003,'App\\Models\\Receipt',2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',700.00,NULL,NULL,1,'2023-03-10 09:57:15','2023-03-10 09:57:15',NULL);
INSERT INTO `balance_libro` VALUES (2221,7986,40759,8015,2,2004,'App\\Models\\Receipt',2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1600.00,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2222,7986,40759,8015,2,2005,'App\\Models\\Receipt',2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1600.00,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2223,7986,40759,8015,2,2006,'App\\Models\\Receipt',2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',700.01,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2224,7986,40759,8015,2,2007,'App\\Models\\Receipt',2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1000.01,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2225,7986,40759,8015,2,2008,'App\\Models\\Receipt',2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1600.00,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2226,7986,40759,8015,2,2009,'App\\Models\\Receipt',2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',600.00,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2227,7986,40759,8015,2,2010,'App\\Models\\Receipt',2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1100.00,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2228,7986,40759,8015,2,2011,'App\\Models\\Receipt',2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1800.00,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2229,7986,40759,8015,2,2012,'App\\Models\\Receipt',2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',900.00,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2230,7986,40759,8015,2,2013,'App\\Models\\Receipt',2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1750.00,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2231,7986,40759,8015,2,2014,'App\\Models\\Receipt',2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1399.99,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2232,7986,40759,8015,2,2015,'App\\Models\\Receipt',2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',2049.99,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2233,7986,40759,8015,2,2016,'App\\Models\\Receipt',2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1399.99,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2234,7986,40759,8015,2,2017,'App\\Models\\Receipt',2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',700.00,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2235,7986,40759,8015,2,2018,'App\\Models\\Receipt',2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1399.99,NULL,NULL,1,'2023-03-10 09:57:16','2023-03-10 09:57:16',NULL),(2236,7986,40759,8015,2,2019,'App\\Models\\Receipt',2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1750.00,NULL,NULL,1,'2023-03-10 09:57:17','2023-03-10 09:57:17',NULL),(2237,7986,40759,8015,2,2020,'App\\Models\\Receipt',2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1600.00,NULL,NULL,1,'2023-03-10 09:57:17','2023-03-10 09:57:17',NULL),(2238,7986,40759,8015,2,2021,'App\\Models\\Receipt',2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',900.00,NULL,NULL,1,'2023-03-10 09:57:17','2023-03-10 09:57:17',NULL),(2239,7986,40759,8015,2,2022,'App\\Models\\Receipt',2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1399.99,NULL,NULL,1,'2023-03-10 09:57:17','2023-03-10 09:57:17',NULL),(2240,7986,40759,8015,2,2023,'App\\Models\\Receipt',2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1600.00,NULL,NULL,1,'2023-03-10 09:57:17','2023-03-10 09:57:17',NULL),(2241,7986,40759,8015,2,2024,'App\\Models\\Receipt',2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1800.00,NULL,NULL,1,'2023-03-10 09:57:17','2023-03-10 09:57:17',NULL);
INSERT INTO `balance_libro` VALUES (2242,7986,40759,8015,2,2025,'App\\Models\\Receipt',2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1250.00,NULL,NULL,1,'2023-03-10 09:57:17','2023-03-10 09:57:17',NULL),(2243,7986,40759,8015,2,2026,'App\\Models\\Receipt',2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',749.99,NULL,NULL,1,'2023-03-10 09:57:17','2023-03-10 09:57:17',NULL),(2244,7986,40759,8015,2,2027,'App\\Models\\Receipt',2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1250.00,NULL,NULL,1,'2023-03-10 09:57:17','2023-03-10 09:57:17',NULL),(2245,7986,40759,8015,2,2028,'App\\Models\\Receipt',2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',550.01,NULL,NULL,1,'2023-03-10 09:57:17','2023-03-10 09:57:17',NULL),(2246,7986,40759,8015,2,2029,'App\\Models\\Receipt',2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1899.99,NULL,NULL,1,'2023-03-10 09:57:17','2023-03-10 09:57:17',NULL),(2247,7986,40759,8015,2,2030,'App\\Models\\Receipt',2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1600.00,NULL,NULL,1,'2023-03-10 09:57:17','2023-03-10 09:57:17',NULL),(2248,7986,40759,8015,2,2031,'App\\Models\\Receipt',2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',500.00,NULL,NULL,1,'2023-03-10 09:57:18','2023-03-10 09:57:18',NULL),(2249,7986,40759,8015,2,2032,'App\\Models\\Receipt',2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1199.99,NULL,NULL,1,'2023-03-10 09:57:18','2023-03-10 09:57:18',NULL),(2250,7986,40759,8015,2,2033,'App\\Models\\Receipt',2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1400.01,NULL,NULL,1,'2023-03-10 09:57:18','2023-03-10 09:57:18',NULL),(2251,7986,40759,8015,2,2034,'App\\Models\\Receipt',2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1700.00,NULL,NULL,1,'2023-03-10 09:57:18','2023-03-10 09:57:18',NULL),(2252,7986,40759,8015,2,2035,'App\\Models\\Receipt',2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',1100.00,NULL,NULL,1,'2023-03-10 09:57:18','2023-03-10 09:57:18',NULL),(2253,7986,40759,8015,2,2036,'App\\Models\\Receipt',2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1600.00,NULL,NULL,1,'2023-03-10 09:57:18','2023-03-10 09:57:18',NULL),(2254,7986,40759,8015,2,2037,'App\\Models\\Receipt',2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2650.00,NULL,NULL,1,'2023-03-10 09:57:18','2023-03-10 09:57:18',NULL),(2255,7986,40759,8015,2,2038,'App\\Models\\Receipt',2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1600.00,NULL,NULL,1,'2023-03-10 09:57:18','2023-03-10 09:57:18',NULL),(2256,7986,40759,8015,2,2039,'App\\Models\\Receipt',2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',350.01,NULL,NULL,1,'2023-03-10 09:57:18','2023-03-10 09:57:18',NULL),(2257,7986,40759,8015,2,2040,'App\\Models\\Receipt',2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',900.00,NULL,NULL,1,'2023-03-10 09:57:18','2023-03-10 09:57:18',NULL),(2258,7986,40759,8015,2,2041,'App\\Models\\Receipt',2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',500.00,NULL,NULL,1,'2023-03-10 09:57:18','2023-03-10 09:57:18',NULL),(2259,7986,40759,8015,2,2042,'App\\Models\\Receipt',2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',999.99,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2260,7986,40759,8015,2,2043,'App\\Models\\Receipt',2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1100.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2261,7986,40759,8015,2,2044,'App\\Models\\Receipt',2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1600.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2262,7986,40759,8015,2,2045,'App\\Models\\Receipt',2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1600.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL);
INSERT INTO `balance_libro` VALUES (2263,7986,40759,8015,2,2046,'App\\Models\\Receipt',2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1600.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2264,7986,40759,8015,2,2047,'App\\Models\\Receipt',2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1800.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2265,7986,40759,8015,2,2048,'App\\Models\\Receipt',2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2150.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2266,7986,40759,8015,2,2049,'App\\Models\\Receipt',2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',550.01,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2267,7986,40759,8015,2,2050,'App\\Models\\Receipt',2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',2500.01,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2268,7986,40759,8015,2,2051,'App\\Models\\Receipt',2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',800.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2269,7986,40759,8015,2,2052,'App\\Models\\Receipt',2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1050.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2270,7986,40759,8015,2,2053,'App\\Models\\Receipt',2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1600.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2271,7986,40759,8015,2,2054,'App\\Models\\Receipt',2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',700.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2272,7986,40759,8015,2,2055,'App\\Models\\Receipt',2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',550.01,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2273,7986,40759,8015,2,2056,'App\\Models\\Receipt',2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2900.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2274,7986,40759,8015,2,2057,'App\\Models\\Receipt',2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1600.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2275,7986,40759,8015,2,2058,'App\\Models\\Receipt',2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2200.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2276,7986,40759,8015,2,2059,'App\\Models\\Receipt',2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',700.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2277,7986,40759,8015,2,2060,'App\\Models\\Receipt',2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',900.00,NULL,NULL,1,'2023-03-10 09:57:19','2023-03-10 09:57:19',NULL),(2278,7986,40759,8015,2,2061,'App\\Models\\Receipt',2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1400.01,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2279,7986,40759,8015,2,2062,'App\\Models\\Receipt',2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',700.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2280,7986,40759,8015,2,2063,'App\\Models\\Receipt',2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',350.01,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2281,7986,40759,8015,2,2064,'App\\Models\\Receipt',2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',700.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2282,7986,40759,8015,2,2065,'App\\Models\\Receipt',2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1800.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2283,7986,40759,8015,2,2066,'App\\Models\\Receipt',2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',900.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL);
INSERT INTO `balance_libro` VALUES (2284,7986,40759,8015,2,2067,'App\\Models\\Receipt',2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',3250.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2285,7986,40759,8015,2,2068,'App\\Models\\Receipt',2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1600.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2286,7986,40759,8015,2,2069,'App\\Models\\Receipt',2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',2500.01,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2287,7986,40759,8015,2,2070,'App\\Models\\Receipt',2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1600.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2288,7986,40759,8015,2,2071,'App\\Models\\Receipt',2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1600.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2289,7986,40759,8015,2,2072,'App\\Models\\Receipt',2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1100.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2290,7986,40759,8015,2,2073,'App\\Models\\Receipt',2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1600.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2291,7986,40759,8015,2,2074,'App\\Models\\Receipt',2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1699.99,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2292,7986,40759,8015,2,2075,'App\\Models\\Receipt',2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',900.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2293,7986,40759,8015,2,2076,'App\\Models\\Receipt',2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1600.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2294,7986,40759,8015,2,2077,'App\\Models\\Receipt',2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1750.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2295,7986,40759,8015,2,2078,'App\\Models\\Receipt',2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',600.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2296,7986,40759,8015,2,2079,'App\\Models\\Receipt',2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1649.99,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2297,7986,40759,8015,2,2080,'App\\Models\\Receipt',2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',900.00,NULL,NULL,1,'2023-03-10 09:57:20','2023-03-10 09:57:20',NULL),(2298,7986,40759,8015,2,2081,'App\\Models\\Receipt',2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',550.01,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2299,7986,40759,8015,2,2082,'App\\Models\\Receipt',2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',699.99,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2300,7986,40759,8015,2,2083,'App\\Models\\Receipt',2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1600.00,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2301,7986,40759,8015,2,2084,'App\\Models\\Receipt',2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1600.00,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2302,7986,40759,8015,2,2085,'App\\Models\\Receipt',2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1600.00,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2303,7986,40759,8015,2,2086,'App\\Models\\Receipt',2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',850.00,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2304,7986,40759,8015,2,2087,'App\\Models\\Receipt',2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',650.00,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL);
INSERT INTO `balance_libro` VALUES (2305,7986,40759,8015,2,2088,'App\\Models\\Receipt',2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',700.00,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2306,7986,40759,8015,2,2089,'App\\Models\\Receipt',2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',450.00,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2307,7986,40759,8015,2,2090,'App\\Models\\Receipt',2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1399.99,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2308,7986,40759,8015,2,2091,'App\\Models\\Receipt',2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1199.99,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2309,7986,40759,8015,2,2092,'App\\Models\\Receipt',2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1100.00,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2310,7986,40759,8015,2,2093,'App\\Models\\Receipt',2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1000.01,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2311,7986,40759,8015,2,2094,'App\\Models\\Receipt',2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',2700.01,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2312,7986,40759,8015,2,2095,'App\\Models\\Receipt',2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',1849.99,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2313,7986,40759,8015,2,2096,'App\\Models\\Receipt',2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',900.00,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2314,7986,40759,8015,2,2097,'App\\Models\\Receipt',2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1600.00,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2315,7986,40759,8015,2,2098,'App\\Models\\Receipt',2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1100.00,NULL,NULL,1,'2023-03-10 09:57:21','2023-03-10 09:57:21',NULL),(2316,7986,40759,8015,2,2099,'App\\Models\\Receipt',2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1699.99,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL),(2317,7986,40759,8015,2,2100,'App\\Models\\Receipt',2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1050.00,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL),(2318,7986,40759,8015,2,2101,'App\\Models\\Receipt',2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1050.00,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL),(2319,7986,40759,8015,2,2102,'App\\Models\\Receipt',2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1100.00,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL),(2320,7986,40759,8015,2,2103,'App\\Models\\Receipt',2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1069.99,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL),(2321,7986,40759,8015,2,2104,'App\\Models\\Receipt',2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',2499.99,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL),(2322,7986,40759,8015,2,2105,'App\\Models\\Receipt',2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',900.00,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL),(2323,7986,40759,8015,2,2106,'App\\Models\\Receipt',2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1200.01,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL),(2324,7986,40759,8015,2,2107,'App\\Models\\Receipt',2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',700.00,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL),(2325,7986,40759,8015,2,2108,'App\\Models\\Receipt',2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',2499.99,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL);
INSERT INTO `balance_libro` VALUES (2326,7986,40759,8015,2,2109,'App\\Models\\Receipt',2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1700.00,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL),(2327,7986,40759,8015,2,2110,'App\\Models\\Receipt',2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',700.00,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL),(2328,7986,40759,8015,2,2111,'App\\Models\\Receipt',2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1699.99,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL),(2329,7986,40759,8015,2,2112,'App\\Models\\Receipt',2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1600.00,NULL,NULL,1,'2023-03-10 09:57:22','2023-03-10 09:57:22',NULL),(2330,7986,40759,8015,2,2113,'App\\Models\\Receipt',2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1200.01,NULL,NULL,1,'2023-03-10 09:57:23','2023-03-10 09:57:23',NULL),(2331,7986,40759,8015,2,2114,'App\\Models\\Receipt',2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',550.01,NULL,NULL,1,'2023-03-10 09:57:23','2023-03-10 09:57:23',NULL),(2332,7986,40759,8015,2,2115,'App\\Models\\Receipt',2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1600.00,NULL,NULL,1,'2023-03-10 09:57:23','2023-03-10 09:57:23',NULL),(2333,7986,40759,8015,2,2116,'App\\Models\\Receipt',2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1600.00,NULL,NULL,1,'2023-03-10 09:57:23','2023-03-10 09:57:23',NULL),(2334,7986,40759,8015,2,2117,'App\\Models\\Receipt',2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1100.00,NULL,NULL,1,'2023-03-10 09:57:23','2023-03-10 09:57:23',NULL),(2335,7986,40759,8015,2,2118,'App\\Models\\Receipt',2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',2200.00,NULL,NULL,1,'2023-03-10 09:57:23','2023-03-10 09:57:23',NULL),(2336,7986,40759,8015,2,2119,'App\\Models\\Receipt',2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1800.00,NULL,NULL,1,'2023-03-10 09:57:23','2023-03-10 09:57:23',NULL),(2337,7986,40759,8015,2,2120,'App\\Models\\Receipt',2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',600.00,NULL,NULL,1,'2023-03-10 09:57:23','2023-03-10 09:57:23',NULL),(2338,7986,40759,8015,2,2121,'App\\Models\\Receipt',2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',500.00,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2339,7986,40759,8015,2,2122,'App\\Models\\Receipt',2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1800.01,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2340,7986,40759,8015,2,2123,'App\\Models\\Receipt',2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1600.00,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2341,7986,40759,8015,2,2124,'App\\Models\\Receipt',2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',950.00,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2342,7986,40759,8015,2,2125,'App\\Models\\Receipt',2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1449.99,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2343,7986,40759,8015,2,2126,'App\\Models\\Receipt',2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',350.01,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2344,7986,40759,8015,2,2127,'App\\Models\\Receipt',2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',900.00,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2345,7986,40759,8015,2,2128,'App\\Models\\Receipt',2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',500.00,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2346,7986,40759,8015,2,2129,'App\\Models\\Receipt',2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',450.00,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL);
INSERT INTO `balance_libro` VALUES (2347,7986,40759,8015,2,2130,'App\\Models\\Receipt',2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',4400.00,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2348,7986,40759,8015,2,2131,'App\\Models\\Receipt',2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1300.00,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2349,7986,40759,8015,2,2132,'App\\Models\\Receipt',2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1600.00,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2350,7986,40759,8015,2,2133,'App\\Models\\Receipt',2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',700.00,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2351,7986,40759,8015,2,2134,'App\\Models\\Receipt',2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',700.00,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2352,7986,40759,8015,2,2135,'App\\Models\\Receipt',2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1800.00,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2353,7986,40759,8015,2,2136,'App\\Models\\Receipt',2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',900.00,NULL,NULL,1,'2023-03-10 09:57:24','2023-03-10 09:57:24',NULL),(2354,7986,40759,8015,2,2137,'App\\Models\\Receipt',2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2499.99,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2355,7986,40759,8015,2,2138,'App\\Models\\Receipt',2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2699.99,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2356,7986,40759,8015,2,2139,'App\\Models\\Receipt',2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1600.00,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2357,7986,40759,8015,2,2140,'App\\Models\\Receipt',2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',900.00,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2358,7986,40759,8015,2,2141,'App\\Models\\Receipt',2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',2200.00,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2359,7986,40759,8015,2,2142,'App\\Models\\Receipt',2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',700.00,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2360,7986,40759,8015,2,2143,'App\\Models\\Receipt',2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',950.00,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2361,7986,40759,8015,2,2144,'App\\Models\\Receipt',2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1750.00,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2362,7986,40759,8015,2,2145,'App\\Models\\Receipt',2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1600.00,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2363,7986,40759,8015,2,2146,'App\\Models\\Receipt',2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',850.00,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2364,7986,40759,8015,2,2147,'App\\Models\\Receipt',2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',700.00,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2365,7986,40759,8015,2,2148,'App\\Models\\Receipt',2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1000.01,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2366,7986,40759,8015,2,2149,'App\\Models\\Receipt',2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',800.00,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2367,7986,40759,8015,2,2150,'App\\Models\\Receipt',2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1600.00,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL);
INSERT INTO `balance_libro` VALUES (2368,7986,40759,8015,2,2151,'App\\Models\\Receipt',2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1300.00,NULL,NULL,1,'2023-03-10 09:57:25','2023-03-10 09:57:25',NULL),(2369,7986,40759,8015,2,2152,'App\\Models\\Receipt',2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1300.00,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2370,7986,40759,8015,2,2153,'App\\Models\\Receipt',2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1250.00,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2371,7986,40759,8015,2,2154,'App\\Models\\Receipt',2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1600.00,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2372,7986,40759,8015,2,2155,'App\\Models\\Receipt',2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',900.00,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2373,7986,40759,8015,2,2156,'App\\Models\\Receipt',2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1699.99,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2374,7986,40759,8015,2,2157,'App\\Models\\Receipt',2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',700.00,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2375,7986,40759,8015,2,2158,'App\\Models\\Receipt',2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',700.00,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2376,7986,40759,8015,2,2159,'App\\Models\\Receipt',2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',800.00,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2377,7986,40759,8015,2,2160,'App\\Models\\Receipt',2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',900.00,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2378,7986,40759,8015,2,2161,'App\\Models\\Receipt',2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',749.99,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2379,7986,40759,8015,2,2162,'App\\Models\\Receipt',2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',700.00,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2380,7986,40759,8015,2,2163,'App\\Models\\Receipt',2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',2949.99,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2381,7986,40759,8015,2,2164,'App\\Models\\Receipt',2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1050.00,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2382,7986,40759,8015,2,2165,'App\\Models\\Receipt',2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',400.00,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2383,7986,40759,8015,2,2166,'App\\Models\\Receipt',2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',350.01,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2384,7986,40759,8015,2,2167,'App\\Models\\Receipt',2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1600.00,NULL,NULL,1,'2023-03-10 09:57:26','2023-03-10 09:57:26',NULL),(2385,7986,40759,8015,2,2168,'App\\Models\\Receipt',2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',950.00,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2386,7986,40759,8015,2,2169,'App\\Models\\Receipt',2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1900.00,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2387,7986,40759,8015,2,2170,'App\\Models\\Receipt',2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',900.00,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2388,7986,40759,8015,2,2171,'App\\Models\\Receipt',2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1750.00,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL);
INSERT INTO `balance_libro` VALUES (2389,7986,40759,8015,2,2172,'App\\Models\\Receipt',2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',4920.01,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2390,7986,40759,8015,2,2173,'App\\Models\\Receipt',2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1250.00,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2391,7986,40759,8015,2,2174,'App\\Models\\Receipt',2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',2499.99,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2392,7986,40759,8015,2,2175,'App\\Models\\Receipt',2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1649.99,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2393,7986,40759,8015,2,2176,'App\\Models\\Receipt',2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1600.00,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2394,7986,40759,8015,2,2177,'App\\Models\\Receipt',2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1050.00,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2395,7986,40759,8015,2,2178,'App\\Models\\Receipt',2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1600.00,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2396,7986,40759,8015,2,2179,'App\\Models\\Receipt',2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1300.00,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2397,7986,40759,8015,2,2180,'App\\Models\\Receipt',2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',1600.00,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2398,7986,40759,8015,2,2181,'App\\Models\\Receipt',2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',900.00,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2399,7986,40759,8015,2,2182,'App\\Models\\Receipt',2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',800.00,NULL,NULL,1,'2023-03-10 09:57:27','2023-03-10 09:57:27',NULL),(2400,7986,40759,8015,2,2183,'App\\Models\\Receipt',2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1750.00,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2401,7986,40759,8015,2,2184,'App\\Models\\Receipt',2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1600.00,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2402,7986,40759,8015,2,2185,'App\\Models\\Receipt',2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1550.01,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2403,7986,40759,8015,2,2186,'App\\Models\\Receipt',2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',800.00,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2404,7986,40759,8015,2,2187,'App\\Models\\Receipt',2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1450.00,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2405,7986,40759,8015,2,2188,'App\\Models\\Receipt',2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',550.01,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2406,7986,40759,8015,2,2189,'App\\Models\\Receipt',2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1099.99,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2407,7986,40759,8015,2,2190,'App\\Models\\Receipt',2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1199.99,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2408,7986,40759,8015,2,2191,'App\\Models\\Receipt',2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',2100.00,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2409,7986,40759,8015,2,2192,'App\\Models\\Receipt',2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1800.00,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL);
INSERT INTO `balance_libro` VALUES (2410,7986,40759,8015,2,2193,'App\\Models\\Receipt',2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1600.00,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2411,7986,40759,8015,2,2194,'App\\Models\\Receipt',2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',800.00,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2412,7986,40759,8015,2,2195,'App\\Models\\Receipt',2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1399.99,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2413,7986,40759,8015,2,2196,'App\\Models\\Receipt',2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',700.00,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2414,7986,40759,8015,2,2197,'App\\Models\\Receipt',2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',700.00,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2415,7986,40759,8015,2,2198,'App\\Models\\Receipt',2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',700.00,NULL,NULL,1,'2023-03-10 09:57:28','2023-03-10 09:57:28',NULL),(2416,7986,40759,8015,2,2199,'App\\Models\\Receipt',2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',2049.99,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2417,7986,40759,8015,2,2200,'App\\Models\\Receipt',2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1600.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2418,7986,40759,8015,2,2201,'App\\Models\\Receipt',2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',800.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2419,7986,40759,8015,2,2202,'App\\Models\\Receipt',2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1050.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2420,7986,40759,8015,2,2203,'App\\Models\\Receipt',2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',500.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2421,7986,40759,8015,2,2204,'App\\Models\\Receipt',2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',2900.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2422,7986,40759,8015,2,2205,'App\\Models\\Receipt',2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',2900.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2423,7986,40759,8015,2,2206,'App\\Models\\Receipt',2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',600.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2424,7986,40759,8015,2,2207,'App\\Models\\Receipt',2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',900.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2425,7986,40759,8015,2,2208,'App\\Models\\Receipt',2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1600.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2426,7986,40759,8015,2,2209,'App\\Models\\Receipt',2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1600.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2427,7986,40759,8015,2,2210,'App\\Models\\Receipt',2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1750.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2428,7986,40759,8015,2,2211,'App\\Models\\Receipt',2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',2900.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2429,7986,40759,8015,2,2212,'App\\Models\\Receipt',2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',900.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2430,7986,40759,8015,2,2213,'App\\Models\\Receipt',2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',2750.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL);
INSERT INTO `balance_libro` VALUES (2431,7986,40759,8015,2,2214,'App\\Models\\Receipt',2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',999.99,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2432,7986,40759,8015,2,2215,'App\\Models\\Receipt',2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1600.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2433,7986,40759,8015,2,2216,'App\\Models\\Receipt',2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1600.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2434,7986,40759,8015,2,2217,'App\\Models\\Receipt',2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',700.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2435,7986,40759,8015,2,2218,'App\\Models\\Receipt',2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',2100.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2436,7986,40759,8015,2,2219,'App\\Models\\Receipt',2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',900.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2437,7986,40759,8015,2,2220,'App\\Models\\Receipt',2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1600.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2438,7986,40759,8015,2,2221,'App\\Models\\Receipt',2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',2579.99,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2439,7986,40759,8015,2,2222,'App\\Models\\Receipt',2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',900.00,NULL,NULL,1,'2023-03-10 09:57:29','2023-03-10 09:57:29',NULL),(2440,7986,40759,8015,2,2223,'App\\Models\\Receipt',2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',2900.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2441,7986,40759,8015,2,2224,'App\\Models\\Receipt',2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1750.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2442,7986,40759,8015,2,2225,'App\\Models\\Receipt',2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',2049.99,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2443,7986,40759,8015,2,2226,'App\\Models\\Receipt',2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1600.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2444,7986,40759,8015,2,2227,'App\\Models\\Receipt',2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1199.99,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2445,7986,40759,8015,2,2228,'App\\Models\\Receipt',2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1649.99,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2446,7986,40759,8015,2,2229,'App\\Models\\Receipt',2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',900.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2447,7986,40759,8015,2,2230,'App\\Models\\Receipt',2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',2999.99,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2448,7986,40759,8015,2,2231,'App\\Models\\Receipt',2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1600.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2449,7986,40759,8015,2,2232,'App\\Models\\Receipt',2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',900.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2450,7986,40759,8015,2,2233,'App\\Models\\Receipt',2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1250.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2451,7986,40759,8015,2,2234,'App\\Models\\Receipt',2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1600.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL);
INSERT INTO `balance_libro` VALUES (2452,7986,40759,8015,2,2235,'App\\Models\\Receipt',2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',700.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2453,7986,40759,8015,2,2236,'App\\Models\\Receipt',2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',700.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2454,7986,40759,8015,2,2237,'App\\Models\\Receipt',2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1100.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2455,7986,40759,8015,2,2238,'App\\Models\\Receipt',2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',700.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2456,7986,40759,8015,2,2239,'App\\Models\\Receipt',2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1800.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2457,7986,40759,8015,2,2240,'App\\Models\\Receipt',2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',3050.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2458,7986,40759,8015,2,2241,'App\\Models\\Receipt',2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',1649.99,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2459,7986,40759,8015,2,2242,'App\\Models\\Receipt',2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1600.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2460,7986,40759,8015,2,2243,'App\\Models\\Receipt',2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1649.99,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2461,7986,40759,8015,2,2244,'App\\Models\\Receipt',2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',700.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2462,7986,40759,8015,2,2245,'App\\Models\\Receipt',2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1750.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2463,7986,40759,8015,2,2246,'App\\Models\\Receipt',2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',550.01,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2464,7986,40759,8015,2,2247,'App\\Models\\Receipt',2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1600.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2465,7986,40759,8015,2,2248,'App\\Models\\Receipt',2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',700.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2466,7986,40759,8015,2,2249,'App\\Models\\Receipt',2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',700.00,NULL,NULL,1,'2023-03-10 09:57:30','2023-03-10 09:57:30',NULL),(2467,7986,40759,8015,2,2250,'App\\Models\\Receipt',2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',2900.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2468,7986,40759,8015,2,2251,'App\\Models\\Receipt',2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1650.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2469,7986,40759,8015,2,2252,'App\\Models\\Receipt',2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1600.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2470,7986,40759,8015,2,2253,'App\\Models\\Receipt',2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',450.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2471,7986,40759,8015,2,2254,'App\\Models\\Receipt',2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',2999.99,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2472,7986,40759,8015,2,2255,'App\\Models\\Receipt',2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1080.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL);
INSERT INTO `balance_libro` VALUES (2473,7986,40759,8015,2,2256,'App\\Models\\Receipt',2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1600.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2474,7986,40759,8015,2,2257,'App\\Models\\Receipt',2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1120.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2475,7986,40759,8015,2,2258,'App\\Models\\Receipt',2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1369.99,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2476,7986,40759,8015,2,2259,'App\\Models\\Receipt',2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1049.99,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2477,7986,40759,8015,2,2260,'App\\Models\\Receipt',2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1200.01,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2478,7986,40759,8015,2,2261,'App\\Models\\Receipt',2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',900.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2479,7986,40759,8015,2,2262,'App\\Models\\Receipt',2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',600.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2480,7986,40759,8015,2,2263,'App\\Models\\Receipt',2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1699.99,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2481,7986,40759,8015,2,2264,'App\\Models\\Receipt',2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1600.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2482,7986,40759,8015,2,2265,'App\\Models\\Receipt',2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',350.01,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2483,7986,40759,8015,2,2266,'App\\Models\\Receipt',2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',600.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2484,7986,40759,8015,2,2267,'App\\Models\\Receipt',2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1269.99,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2485,7986,40759,8015,2,2268,'App\\Models\\Receipt',2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',4499.99,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2486,7986,40759,8015,2,2269,'App\\Models\\Receipt',2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',450.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2487,7986,40759,8015,2,2270,'App\\Models\\Receipt',2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',550.01,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2488,7986,40759,8015,2,2271,'App\\Models\\Receipt',2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',550.01,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2489,7986,40759,8015,2,2272,'App\\Models\\Receipt',2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',700.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2490,7986,40759,8015,2,2273,'App\\Models\\Receipt',2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',700.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2491,7986,40759,8015,2,2274,'App\\Models\\Receipt',2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',750.01,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2492,7986,40759,8015,2,2275,'App\\Models\\Receipt',2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1800.00,NULL,NULL,1,'2023-03-10 09:57:31','2023-03-10 09:57:31',NULL),(2493,7986,40759,8015,2,2276,'App\\Models\\Receipt',2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',600.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL);
INSERT INTO `balance_libro` VALUES (2494,7986,40759,8015,2,2277,'App\\Models\\Receipt',2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1800.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2495,7986,40759,8015,2,2278,'App\\Models\\Receipt',2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',950.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2496,7986,40759,8015,2,2279,'App\\Models\\Receipt',2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',500.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2497,7986,40759,8015,2,2280,'App\\Models\\Receipt',2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',2500.01,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2498,7986,40759,8015,2,2281,'App\\Models\\Receipt',2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',2250.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2499,7986,40759,8015,2,2282,'App\\Models\\Receipt',2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',950.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2500,7986,40759,8015,2,2283,'App\\Models\\Receipt',2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',2400.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2501,7986,40759,8015,2,2284,'App\\Models\\Receipt',2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1600.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2502,7986,40759,8015,2,2285,'App\\Models\\Receipt',2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1600.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2503,7986,40759,8015,2,2286,'App\\Models\\Receipt',2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',700.01,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2504,7986,40759,8015,2,2287,'App\\Models\\Receipt',2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1199.99,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2505,7986,40759,8015,2,2288,'App\\Models\\Receipt',2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1600.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2506,7986,40759,8015,2,2289,'App\\Models\\Receipt',2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',950.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2507,7986,40759,8015,2,2290,'App\\Models\\Receipt',2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1600.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2508,7986,40759,8015,2,2291,'App\\Models\\Receipt',2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1600.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2509,7986,40759,8015,2,2292,'App\\Models\\Receipt',2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',2900.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2510,7986,40759,8015,2,2293,'App\\Models\\Receipt',2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1699.99,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2511,7986,40759,8015,2,2294,'App\\Models\\Receipt',2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',900.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2512,7986,40759,8015,2,2295,'App\\Models\\Receipt',2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1600.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2513,7986,40759,8015,2,2296,'App\\Models\\Receipt',2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',900.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2514,7986,40759,8015,2,2297,'App\\Models\\Receipt',2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',2300.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL);
INSERT INTO `balance_libro` VALUES (2515,7986,40759,8015,2,2298,'App\\Models\\Receipt',2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1600.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2516,7986,40759,8015,2,2299,'App\\Models\\Receipt',2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1600.00,NULL,NULL,1,'2023-03-10 09:57:32','2023-03-10 09:57:32',NULL),(2517,7986,40759,8015,2,2300,'App\\Models\\Receipt',2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1300.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2518,7986,40759,8015,2,2301,'App\\Models\\Receipt',2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',900.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2519,7986,40759,8015,2,2302,'App\\Models\\Receipt',2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',700.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2520,7986,40759,8015,2,2303,'App\\Models\\Receipt',2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',700.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2521,7986,40759,8015,2,2304,'App\\Models\\Receipt',2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1600.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2522,7986,40759,8015,2,2305,'App\\Models\\Receipt',2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',900.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2523,7986,40759,8015,2,2306,'App\\Models\\Receipt',2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',900.01,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2524,7986,40759,8015,2,2307,'App\\Models\\Receipt',2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1200.01,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2525,7986,40759,8015,2,2308,'App\\Models\\Receipt',2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',700.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2526,7986,40759,8015,2,2309,'App\\Models\\Receipt',2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1350.01,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2527,7986,40759,8015,2,2310,'App\\Models\\Receipt',2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',550.01,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2528,7986,40759,8015,2,2311,'App\\Models\\Receipt',2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',350.01,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2529,7986,40759,8015,2,2312,'App\\Models\\Receipt',2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',700.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2530,7986,40759,8015,2,2313,'App\\Models\\Receipt',2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',500.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2531,7986,40759,8015,2,2314,'App\\Models\\Receipt',2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',900.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2532,7986,40759,8015,2,2315,'App\\Models\\Receipt',2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',900.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2533,7986,40759,8015,2,2316,'App\\Models\\Receipt',2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',250.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2534,7986,40759,8015,2,2317,'App\\Models\\Receipt',2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',700.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2535,7986,40759,8015,2,2318,'App\\Models\\Receipt',2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',700.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL);
INSERT INTO `balance_libro` VALUES (2536,7986,40759,8015,2,2319,'App\\Models\\Receipt',2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1699.99,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2537,7986,40759,8015,2,2320,'App\\Models\\Receipt',2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1600.00,NULL,NULL,1,'2023-03-10 09:57:33','2023-03-10 09:57:33',NULL),(2538,7986,40759,8015,2,2321,'App\\Models\\Receipt',2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1600.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2539,7986,40759,8015,2,2322,'App\\Models\\Receipt',2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',369.99,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2540,7986,40759,8015,2,2323,'App\\Models\\Receipt',2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',550.01,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2541,7986,40759,8015,2,2324,'App\\Models\\Receipt',2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',900.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2542,7986,40759,8015,2,2325,'App\\Models\\Receipt',2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1649.99,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2543,7986,40759,8015,2,2326,'App\\Models\\Receipt',2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',850.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2544,7986,40759,8015,2,2327,'App\\Models\\Receipt',2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',900.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2545,7986,40759,8015,2,2328,'App\\Models\\Receipt',2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1600.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2546,7986,40759,8015,2,2329,'App\\Models\\Receipt',2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1919.99,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2547,7986,40759,8015,2,2330,'App\\Models\\Receipt',2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1600.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2548,7986,40759,8015,2,2331,'App\\Models\\Receipt',2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',1350.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2549,7986,40759,8015,2,2332,'App\\Models\\Receipt',2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',250.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2550,7986,40759,8015,2,2333,'App\\Models\\Receipt',2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',900.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2551,7986,40759,8015,2,2334,'App\\Models\\Receipt',2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',2900.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2552,7986,40759,8015,2,2335,'App\\Models\\Receipt',2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1050.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2553,7986,40759,8015,2,2336,'App\\Models\\Receipt',2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',950.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2554,7986,40759,8015,2,2337,'App\\Models\\Receipt',2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',700.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2555,7986,40759,8015,2,2338,'App\\Models\\Receipt',2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',700.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2556,7986,40759,8015,2,2339,'App\\Models\\Receipt',2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',850.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL);
INSERT INTO `balance_libro` VALUES (2557,7986,40759,8015,2,2340,'App\\Models\\Receipt',2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',3599.99,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2558,7986,40759,8015,2,2341,'App\\Models\\Receipt',2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1150.00,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2559,7986,40759,8015,2,2342,'App\\Models\\Receipt',2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1649.99,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2560,7986,40759,8015,2,2343,'App\\Models\\Receipt',2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1649.99,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2561,7986,40759,8015,2,2344,'App\\Models\\Receipt',2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',550.01,NULL,NULL,1,'2023-03-10 09:57:34','2023-03-10 09:57:34',NULL),(2562,7986,40759,8015,2,2345,'App\\Models\\Receipt',2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',550.01,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2563,7986,40759,8015,2,2346,'App\\Models\\Receipt',2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',1150.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2564,7986,40759,8015,2,2347,'App\\Models\\Receipt',2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1050.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2565,7986,40759,8015,2,2348,'App\\Models\\Receipt',2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1000.01,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2566,7986,40759,8015,2,2349,'App\\Models\\Receipt',2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',250.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2567,7986,40759,8015,2,2350,'App\\Models\\Receipt',2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1350.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2568,7986,40759,8015,2,2351,'App\\Models\\Receipt',2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1550.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2569,7986,40759,8015,2,2352,'App\\Models\\Receipt',2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',2500.01,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2570,7986,40759,8015,2,2353,'App\\Models\\Receipt',2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1600.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2571,7986,40759,8015,2,2354,'App\\Models\\Receipt',2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',1600.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2572,7986,40759,8015,2,2355,'App\\Models\\Receipt',2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1600.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2573,7986,40759,8015,2,2356,'App\\Models\\Receipt',2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',800.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2574,7986,40759,8015,2,2357,'App\\Models\\Receipt',2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1600.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2575,7986,40759,8015,2,2358,'App\\Models\\Receipt',2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1050.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2576,7986,40759,8015,2,2359,'App\\Models\\Receipt',2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',700.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2577,7986,40759,8015,2,2360,'App\\Models\\Receipt',2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1250.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL);
INSERT INTO `balance_libro` VALUES (2578,7986,40759,8015,2,2361,'App\\Models\\Receipt',2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1019.99,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2579,7986,40759,8015,2,2362,'App\\Models\\Receipt',2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1649.99,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2580,7986,40759,8015,2,2363,'App\\Models\\Receipt',2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',2150.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2581,7986,40759,8015,2,2364,'App\\Models\\Receipt',2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1600.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2582,7986,40759,8015,2,2365,'App\\Models\\Receipt',2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1600.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2583,7986,40759,8015,2,2366,'App\\Models\\Receipt',2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',1600.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2584,7986,40759,8015,2,2367,'App\\Models\\Receipt',2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',600.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2585,7986,40759,8015,2,2368,'App\\Models\\Receipt',2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',900.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2586,7986,40759,8015,2,2369,'App\\Models\\Receipt',2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1800.00,NULL,NULL,1,'2023-03-10 09:57:35','2023-03-10 09:57:35',NULL),(2587,7986,40759,8015,2,2370,'App\\Models\\Receipt',2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1600.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2588,7986,40759,8015,2,2371,'App\\Models\\Receipt',2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1600.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2589,7986,40759,8015,2,2372,'App\\Models\\Receipt',2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1900.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2590,7986,40759,8015,2,2373,'App\\Models\\Receipt',2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',3470.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2591,7986,40759,8015,2,2374,'App\\Models\\Receipt',2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1600.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2592,7986,40759,8015,2,2375,'App\\Models\\Receipt',2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',600.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2593,7986,40759,8015,2,2376,'App\\Models\\Receipt',2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',850.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2594,7986,40759,8015,2,2377,'App\\Models\\Receipt',2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',700.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2595,7986,40759,8015,2,2378,'App\\Models\\Receipt',2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',900.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2596,7986,40759,8015,2,2379,'App\\Models\\Receipt',2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',700.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2597,7986,40759,8015,2,2380,'App\\Models\\Receipt',2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1600.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2598,7986,40759,8015,2,2381,'App\\Models\\Receipt',2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1750.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL);
INSERT INTO `balance_libro` VALUES (2599,7986,40759,8015,2,2382,'App\\Models\\Receipt',2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',900.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2600,7986,40759,8015,2,2383,'App\\Models\\Receipt',2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',950.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2601,7986,40759,8015,2,2384,'App\\Models\\Receipt',2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1600.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2602,7986,40759,8015,2,2385,'App\\Models\\Receipt',2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',650.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2603,7986,40759,8015,2,2386,'App\\Models\\Receipt',2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',550.01,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2604,7986,40759,8015,2,2387,'App\\Models\\Receipt',2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1300.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2605,7986,40759,8015,2,2388,'App\\Models\\Receipt',2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1600.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2606,7986,40759,8015,2,2389,'App\\Models\\Receipt',2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1600.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2607,7986,40759,8015,2,2390,'App\\Models\\Receipt',2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1600.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2608,7986,40759,8015,2,2391,'App\\Models\\Receipt',2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',550.01,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2609,7986,40759,8015,2,2392,'App\\Models\\Receipt',2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',850.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2610,7986,40759,8015,2,2393,'App\\Models\\Receipt',2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1150.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2611,7986,40759,8015,2,2394,'App\\Models\\Receipt',2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',550.01,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2612,7986,40759,8015,2,2395,'App\\Models\\Receipt',2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1100.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2613,7986,40759,8015,2,2396,'App\\Models\\Receipt',2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',900.00,NULL,NULL,1,'2023-03-10 09:57:36','2023-03-10 09:57:36',NULL),(2614,7986,40759,8015,2,2397,'App\\Models\\Receipt',2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1600.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2615,7986,40759,8015,2,2398,'App\\Models\\Receipt',2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',700.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2616,7986,40759,8015,2,2399,'App\\Models\\Receipt',2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',500.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2617,7986,40759,8015,2,2400,'App\\Models\\Receipt',2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',550.01,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2618,7986,40759,8015,2,2401,'App\\Models\\Receipt',2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1550.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2619,7986,40759,8015,2,2402,'App\\Models\\Receipt',2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',900.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL);
INSERT INTO `balance_libro` VALUES (2620,7986,40759,8015,2,2403,'App\\Models\\Receipt',2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',950.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2621,7986,40759,8015,2,2404,'App\\Models\\Receipt',2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',2500.01,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2622,7986,40759,8015,2,2405,'App\\Models\\Receipt',2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',900.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2623,7986,40759,8015,2,2406,'App\\Models\\Receipt',2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1500.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2624,7986,40759,8015,2,2407,'App\\Models\\Receipt',2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',1500.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2625,7986,40759,8015,2,2408,'App\\Models\\Receipt',2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-19','2023-02-19',2900.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2626,7986,40759,8015,2,2409,'App\\Models\\Receipt',2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',850.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2627,7986,40759,8015,2,2410,'App\\Models\\Receipt',2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1700.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2628,7986,40759,8015,2,2411,'App\\Models\\Receipt',2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',700.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2629,7986,40759,8015,2,2412,'App\\Models\\Receipt',2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1300.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2630,7986,40759,8015,2,2413,'App\\Models\\Receipt',2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1600.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2631,7986,40759,8015,2,2414,'App\\Models\\Receipt',2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',749.99,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2632,7986,40759,8015,2,2415,'App\\Models\\Receipt',2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1800.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2633,7986,40759,8015,2,2416,'App\\Models\\Receipt',2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1100.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2634,7986,40759,8015,2,2417,'App\\Models\\Receipt',2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1600.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2635,7986,40759,8015,2,2418,'App\\Models\\Receipt',2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',700.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2636,7986,40759,8015,2,2419,'App\\Models\\Receipt',2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1800.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2637,7986,40759,8015,2,2420,'App\\Models\\Receipt',2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1600.00,NULL,NULL,1,'2023-03-10 09:57:37','2023-03-10 09:57:37',NULL),(2638,7986,40759,8015,2,2421,'App\\Models\\Receipt',2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1600.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2639,7986,40759,8015,2,2422,'App\\Models\\Receipt',2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',700.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2640,7986,40759,8015,2,2423,'App\\Models\\Receipt',2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',999.99,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL);
INSERT INTO `balance_libro` VALUES (2641,7986,40759,8015,2,2424,'App\\Models\\Receipt',2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',2499.99,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2642,7986,40759,8015,2,2425,'App\\Models\\Receipt',2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1050.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2643,7986,40759,8015,2,2426,'App\\Models\\Receipt',2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',950.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2644,7986,40759,8015,2,2427,'App\\Models\\Receipt',2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1600.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2645,7986,40759,8015,2,2428,'App\\Models\\Receipt',2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',1050.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2646,7986,40759,8015,2,2429,'App\\Models\\Receipt',2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',500.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2647,7986,40759,8015,2,2430,'App\\Models\\Receipt',2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1450.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2648,7986,40759,8015,2,2431,'App\\Models\\Receipt',2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',550.01,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2649,7986,40759,8015,2,2432,'App\\Models\\Receipt',2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1050.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2650,7986,40759,8015,2,2433,'App\\Models\\Receipt',2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',900.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2651,7986,40759,8015,2,2434,'App\\Models\\Receipt',2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',900.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2652,7986,40759,8015,2,2435,'App\\Models\\Receipt',2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',800.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2653,7986,40759,8015,2,2436,'App\\Models\\Receipt',2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1250.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2654,7986,40759,8015,2,2437,'App\\Models\\Receipt',2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',900.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2655,7986,40759,8015,2,2438,'App\\Models\\Receipt',2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',900.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2656,7986,40759,8015,2,2439,'App\\Models\\Receipt',2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',700.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2657,7986,40759,8015,2,2440,'App\\Models\\Receipt',2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',950.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2658,7986,40759,8015,2,2441,'App\\Models\\Receipt',2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',350.01,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2659,7986,40759,8015,2,2442,'App\\Models\\Receipt',2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',350.01,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2660,7986,40759,8015,2,2443,'App\\Models\\Receipt',2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',500.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2661,7986,40759,8015,2,2444,'App\\Models\\Receipt',2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1650.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL);
INSERT INTO `balance_libro` VALUES (2662,7986,40759,8015,2,2445,'App\\Models\\Receipt',2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',500.00,NULL,NULL,1,'2023-03-10 09:57:38','2023-03-10 09:57:38',NULL),(2663,7986,40759,8015,2,2446,'App\\Models\\Receipt',2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',900.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2664,7986,40759,8015,2,2447,'App\\Models\\Receipt',2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1600.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2665,7986,40759,8015,2,2448,'App\\Models\\Receipt',2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1600.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2666,7986,40759,8015,2,2449,'App\\Models\\Receipt',2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',950.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2667,7986,40759,8015,2,2450,'App\\Models\\Receipt',2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',450.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2668,7986,40759,8015,2,2451,'App\\Models\\Receipt',2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',749.99,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2669,7986,40759,8015,2,2452,'App\\Models\\Receipt',2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',700.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2670,7986,40759,8015,2,2453,'App\\Models\\Receipt',2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',550.01,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2671,7986,40759,8015,2,2454,'App\\Models\\Receipt',2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',900.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2672,7986,40759,8015,2,2455,'App\\Models\\Receipt',2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1350.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2673,7986,40759,8015,2,2456,'App\\Models\\Receipt',2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1050.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2674,7986,40759,8015,2,2457,'App\\Models\\Receipt',2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1500.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2675,7986,40759,8015,2,2458,'App\\Models\\Receipt',2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1050.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2676,7986,40759,8015,2,2459,'App\\Models\\Receipt',2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1249.99,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2677,7986,40759,8015,2,2460,'App\\Models\\Receipt',2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',900.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2678,7986,40759,8015,2,2461,'App\\Models\\Receipt',2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',550.01,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2679,7986,40759,8015,2,2462,'App\\Models\\Receipt',2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1649.99,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2680,7986,40759,8015,2,2463,'App\\Models\\Receipt',2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1100.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2681,7986,40759,8015,2,2464,'App\\Models\\Receipt',2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1100.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2682,7986,40759,8015,2,2465,'App\\Models\\Receipt',2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',600.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL);
INSERT INTO `balance_libro` VALUES (2683,7986,40759,8015,2,2466,'App\\Models\\Receipt',2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',1050.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2684,7986,40759,8015,2,2467,'App\\Models\\Receipt',2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',500.00,NULL,NULL,1,'2023-03-10 09:57:39','2023-03-10 09:57:39',NULL),(2685,7986,40759,8015,2,2468,'App\\Models\\Receipt',2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',2499.99,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2686,7986,40759,8015,2,2469,'App\\Models\\Receipt',2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',700.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2687,7986,40759,8015,2,2470,'App\\Models\\Receipt',2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1100.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2688,7986,40759,8015,2,2471,'App\\Models\\Receipt',2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1600.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2689,7986,40759,8015,2,2472,'App\\Models\\Receipt',2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1050.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2690,7986,40759,8015,2,2473,'App\\Models\\Receipt',2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1050.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2691,7986,40759,8015,2,2474,'App\\Models\\Receipt',2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',1600.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2692,7986,40759,8015,2,2475,'App\\Models\\Receipt',2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',550.01,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2693,7986,40759,8015,2,2476,'App\\Models\\Receipt',2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',700.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2694,7986,40759,8015,2,2477,'App\\Models\\Receipt',2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',850.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2695,7986,40759,8015,2,2478,'App\\Models\\Receipt',2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',500.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2696,7986,40759,8015,2,2479,'App\\Models\\Receipt',2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',700.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2697,7986,40759,8015,2,2480,'App\\Models\\Receipt',2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',850.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2698,7986,40759,8015,2,2481,'App\\Models\\Receipt',2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',250.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2699,7986,40759,8015,2,2482,'App\\Models\\Receipt',2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',400.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2700,7986,40759,8015,2,2483,'App\\Models\\Receipt',2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',800.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2701,7986,40759,8015,2,2484,'App\\Models\\Receipt',2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1150.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2702,7986,40759,8015,2,2485,'App\\Models\\Receipt',2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1400.01,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2703,7986,40759,8015,2,2486,'App\\Models\\Receipt',2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',900.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL);
INSERT INTO `balance_libro` VALUES (2704,7986,40759,8015,2,2487,'App\\Models\\Receipt',2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',2900.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2705,7986,40759,8015,2,2488,'App\\Models\\Receipt',2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',2900.00,NULL,NULL,1,'2023-03-10 09:57:40','2023-03-10 09:57:40',NULL),(2706,7986,40759,8015,2,2489,'App\\Models\\Receipt',2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1650.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2707,7986,40759,8015,2,2490,'App\\Models\\Receipt',2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',550.01,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2708,7986,40759,8015,2,2491,'App\\Models\\Receipt',2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1150.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2709,7986,40759,8015,2,2492,'App\\Models\\Receipt',2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',500.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2710,7986,40759,8015,2,2493,'App\\Models\\Receipt',2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1600.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2711,7986,40759,8015,2,2494,'App\\Models\\Receipt',2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',800.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2712,7986,40759,8015,2,2495,'App\\Models\\Receipt',2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1550.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2713,7986,40759,8015,2,2496,'App\\Models\\Receipt',2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',700.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2714,7986,40759,8015,2,2497,'App\\Models\\Receipt',2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',700.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2715,7986,40759,8015,2,2498,'App\\Models\\Receipt',2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',550.01,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2716,7986,40759,8015,2,2499,'App\\Models\\Receipt',2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',900.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2717,7986,40759,8015,2,2500,'App\\Models\\Receipt',2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',700.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2718,7986,40759,8015,2,2501,'App\\Models\\Receipt',2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',900.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2719,7986,40759,8015,2,2502,'App\\Models\\Receipt',2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',900.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2720,7986,40759,8015,2,2503,'App\\Models\\Receipt',2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',2200.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2721,7986,40759,8015,2,2504,'App\\Models\\Receipt',2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',900.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2722,7986,40759,8015,2,2505,'App\\Models\\Receipt',2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',550.01,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2723,7986,40759,8015,2,2506,'App\\Models\\Receipt',2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',700.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2724,7986,40759,8015,2,2507,'App\\Models\\Receipt',2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1050.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL);
INSERT INTO `balance_libro` VALUES (2725,7986,40759,8015,2,2508,'App\\Models\\Receipt',2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',800.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2726,7986,40759,8015,2,2509,'App\\Models\\Receipt',2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',700.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2727,7986,40759,8015,2,2510,'App\\Models\\Receipt',2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',550.01,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2728,7986,40759,8015,2,2511,'App\\Models\\Receipt',2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',2400.00,NULL,NULL,1,'2023-03-10 09:57:41','2023-03-10 09:57:41',NULL),(2729,7986,40759,8015,2,2512,'App\\Models\\Receipt',2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1600.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2730,7986,40759,8015,2,2513,'App\\Models\\Receipt',2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1199.99,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2731,7986,40759,8015,2,2514,'App\\Models\\Receipt',2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1300.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2732,7986,40759,8015,2,2515,'App\\Models\\Receipt',2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',700.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2733,7986,40759,8015,2,2516,'App\\Models\\Receipt',2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',2900.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2734,7986,40759,8015,2,2517,'App\\Models\\Receipt',2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',900.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2735,7986,40759,8015,2,2518,'App\\Models\\Receipt',2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1600.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2736,7986,40759,8015,2,2519,'App\\Models\\Receipt',2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1600.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2737,7986,40759,8015,2,2520,'App\\Models\\Receipt',2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1600.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2738,7986,40759,8015,2,2521,'App\\Models\\Receipt',2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1600.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2739,7986,40759,8015,2,2522,'App\\Models\\Receipt',2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1000.01,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2740,7986,40759,8015,2,2523,'App\\Models\\Receipt',2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1500.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2741,7986,40759,8015,2,2524,'App\\Models\\Receipt',2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',550.01,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2742,7986,40759,8015,2,2525,'App\\Models\\Receipt',2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',900.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2743,7986,40759,8015,2,2526,'App\\Models\\Receipt',2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',1000.01,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2744,7986,40759,8015,2,2527,'App\\Models\\Receipt',2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',900.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2745,7986,40759,8015,2,2528,'App\\Models\\Receipt',2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',900.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL);
INSERT INTO `balance_libro` VALUES (2746,7986,40759,8015,2,2529,'App\\Models\\Receipt',2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1600.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2747,7986,40759,8015,2,2530,'App\\Models\\Receipt',2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',900.00,NULL,NULL,1,'2023-03-10 09:57:42','2023-03-10 09:57:42',NULL),(2748,7986,40759,8015,2,2531,'App\\Models\\Receipt',2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',900.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2749,7986,40759,8015,2,2532,'App\\Models\\Receipt',2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1750.01,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2750,7986,40759,8015,2,2533,'App\\Models\\Receipt',2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',600.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2751,7986,40759,8015,2,2534,'App\\Models\\Receipt',2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',900.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2752,7986,40759,8015,2,2535,'App\\Models\\Receipt',2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1600.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2753,7986,40759,8015,2,2536,'App\\Models\\Receipt',2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1600.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2754,7986,40759,8015,2,2537,'App\\Models\\Receipt',2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',2900.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2755,7986,40759,8015,2,2538,'App\\Models\\Receipt',2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',2499.99,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2756,7986,40759,8015,2,2539,'App\\Models\\Receipt',2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',600.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2757,7986,40759,8015,2,2540,'App\\Models\\Receipt',2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1600.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2758,7986,40759,8015,2,2541,'App\\Models\\Receipt',2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1600.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2759,7986,40759,8015,2,2542,'App\\Models\\Receipt',2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1600.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2760,7986,40759,8015,2,2543,'App\\Models\\Receipt',2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1600.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2761,7986,40759,8015,2,2544,'App\\Models\\Receipt',2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1699.99,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2762,7986,40759,8015,2,2545,'App\\Models\\Receipt',2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',800.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2763,7986,40759,8015,2,2546,'App\\Models\\Receipt',2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1600.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2764,7986,40759,8015,2,2547,'App\\Models\\Receipt',2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',2499.99,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2765,7986,40759,8015,2,2548,'App\\Models\\Receipt',2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1300.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2766,7986,40759,8015,2,2549,'App\\Models\\Receipt',2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1600.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL);
INSERT INTO `balance_libro` VALUES (2767,7986,40759,8015,2,2550,'App\\Models\\Receipt',2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',120.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2768,7986,40759,8015,2,2551,'App\\Models\\Receipt',2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',4600.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2769,7986,40759,8015,2,2552,'App\\Models\\Receipt',2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',900.00,NULL,NULL,1,'2023-03-10 09:57:43','2023-03-10 09:57:43',NULL),(2770,7986,40759,8015,2,2553,'App\\Models\\Receipt',2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1699.99,NULL,NULL,1,'2023-03-10 09:57:44','2023-03-10 09:57:44',NULL),(2771,7986,40759,8015,2,2554,'App\\Models\\Receipt',2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',3050.00,NULL,NULL,1,'2023-03-10 09:57:44','2023-03-10 09:57:44',NULL),(2772,7986,40759,8015,2,2555,'App\\Models\\Receipt',2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1699.99,NULL,NULL,1,'2023-03-10 09:57:44','2023-03-10 09:57:44',NULL),(2773,7986,40759,8015,2,2556,'App\\Models\\Receipt',2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1600.00,NULL,NULL,1,'2023-03-10 09:57:44','2023-03-10 09:57:44',NULL),(2774,7986,40759,8015,2,2557,'App\\Models\\Receipt',2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1199.99,NULL,NULL,1,'2023-03-10 09:57:44','2023-03-10 09:57:44',NULL),(2775,7986,40759,8015,2,2558,'App\\Models\\Receipt',2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',850.00,NULL,NULL,1,'2023-03-10 09:57:44','2023-03-10 09:57:44',NULL),(2776,7986,40759,8015,2,2559,'App\\Models\\Receipt',2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',979.99,NULL,NULL,1,'2023-03-10 09:57:44','2023-03-10 09:57:44',NULL),(2777,7986,40759,8015,2,2560,'App\\Models\\Receipt',2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1939.99,NULL,NULL,1,'2023-03-10 09:57:44','2023-03-10 09:57:44',NULL),(2778,7986,40759,8015,2,2561,'App\\Models\\Receipt',2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1100.00,NULL,NULL,1,'2023-03-10 09:57:44','2023-03-10 09:57:44',NULL),(2779,7986,40759,8015,2,2562,'App\\Models\\Receipt',2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1750.00,NULL,NULL,1,'2023-03-10 09:57:44','2023-03-10 09:57:44',NULL),(2780,7986,40759,8015,2,2563,'App\\Models\\Receipt',2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1600.00,NULL,NULL,1,'2023-03-10 09:57:44','2023-03-10 09:57:44',NULL),(2781,7986,40759,8015,2,2564,'App\\Models\\Receipt',2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1800.00,NULL,NULL,1,'2023-03-10 09:57:44','2023-03-10 09:57:44',NULL),(2782,7986,40759,8015,2,2565,'App\\Models\\Receipt',2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1699.99,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2783,7986,40759,8015,2,2566,'App\\Models\\Receipt',2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',900.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2784,7986,40759,8015,2,2567,'App\\Models\\Receipt',2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1450.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2785,7986,40759,8015,2,2568,'App\\Models\\Receipt',2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',700.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2786,7986,40759,8015,2,2569,'App\\Models\\Receipt',2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',700.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2787,7986,40759,8015,2,2570,'App\\Models\\Receipt',2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',350.01,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL);
INSERT INTO `balance_libro` VALUES (2788,7986,40759,8015,2,2571,'App\\Models\\Receipt',2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1300.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2789,7986,40759,8015,2,2572,'App\\Models\\Receipt',2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1600.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2790,7986,40759,8015,2,2573,'App\\Models\\Receipt',2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1399.99,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2791,7986,40759,8015,2,2574,'App\\Models\\Receipt',2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',1600.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2792,7986,40759,8015,2,2575,'App\\Models\\Receipt',2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',700.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2793,7986,40759,8015,2,2576,'App\\Models\\Receipt',2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',700.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2794,7986,40759,8015,2,2577,'App\\Models\\Receipt',2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',2900.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2795,7986,40759,8015,2,2578,'App\\Models\\Receipt',2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',600.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2796,7986,40759,8015,2,2579,'App\\Models\\Receipt',2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',2300.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2797,7986,40759,8015,2,2580,'App\\Models\\Receipt',2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',700.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2798,7986,40759,8015,2,2581,'App\\Models\\Receipt',2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',3460.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2799,7986,40759,8015,2,2582,'App\\Models\\Receipt',2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',900.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2800,7986,40759,8015,2,2583,'App\\Models\\Receipt',2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',900.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2801,7986,40759,8015,2,2584,'App\\Models\\Receipt',2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',450.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2802,7986,40759,8015,2,2585,'App\\Models\\Receipt',2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1600.00,NULL,NULL,1,'2023-03-10 09:57:45','2023-03-10 09:57:45',NULL),(2803,7986,40759,8015,2,2586,'App\\Models\\Receipt',2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',250.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2804,7986,40759,8015,2,2587,'App\\Models\\Receipt',2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1649.99,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2805,7986,40759,8015,2,2588,'App\\Models\\Receipt',2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',700.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2806,7986,40759,8015,2,2589,'App\\Models\\Receipt',2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',550.01,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2807,7986,40759,8015,2,2590,'App\\Models\\Receipt',2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',550.01,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2808,7986,40759,8015,2,2591,'App\\Models\\Receipt',2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',700.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL);
INSERT INTO `balance_libro` VALUES (2809,7986,40759,8015,2,2592,'App\\Models\\Receipt',2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1100.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2810,7986,40759,8015,2,2593,'App\\Models\\Receipt',2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',700.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2811,7986,40759,8015,2,2594,'App\\Models\\Receipt',2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',700.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2812,7986,40759,8015,2,2595,'App\\Models\\Receipt',2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2150.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2813,7986,40759,8015,2,2596,'App\\Models\\Receipt',2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',250.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2814,7986,40759,8015,2,2597,'App\\Models\\Receipt',2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1600.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2815,7986,40759,8015,2,2598,'App\\Models\\Receipt',2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',900.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2816,7986,40759,8015,2,2599,'App\\Models\\Receipt',2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',700.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2817,7986,40759,8015,2,2600,'App\\Models\\Receipt',2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',350.01,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2818,7986,40759,8015,2,2601,'App\\Models\\Receipt',2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',900.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2819,7986,40759,8015,2,2602,'App\\Models\\Receipt',2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',250.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2820,7986,40759,8015,2,2603,'App\\Models\\Receipt',2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1600.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2821,7986,40759,8015,2,2604,'App\\Models\\Receipt',2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2350.00,NULL,NULL,1,'2023-03-10 09:57:46','2023-03-10 09:57:46',NULL),(2822,7986,40759,8015,2,2605,'App\\Models\\Receipt',2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2500.01,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2823,7986,40759,8015,2,2606,'App\\Models\\Receipt',2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1350.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2824,7986,40759,8015,2,2607,'App\\Models\\Receipt',2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',2900.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2825,7986,40759,8015,2,2608,'App\\Models\\Receipt',2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1450.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2826,7986,40759,8015,2,2609,'App\\Models\\Receipt',2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1600.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2827,7986,40759,8015,2,2610,'App\\Models\\Receipt',2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2828,7986,40759,8015,2,2611,'App\\Models\\Receipt',2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2829,7986,40759,8015,2,2612,'App\\Models\\Receipt',2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL);
INSERT INTO `balance_libro` VALUES (2830,7986,40759,8015,2,2613,'App\\Models\\Receipt',2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2831,7986,40759,8015,2,2614,'App\\Models\\Receipt',2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',550.01,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2832,7986,40759,8015,2,2615,'App\\Models\\Receipt',2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',250.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2833,7986,40759,8015,2,2616,'App\\Models\\Receipt',2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1100.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2834,7986,40759,8015,2,2617,'App\\Models\\Receipt',2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2835,7986,40759,8015,2,2618,'App\\Models\\Receipt',2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',700.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2836,7986,40759,8015,2,2619,'App\\Models\\Receipt',2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2837,7986,40759,8015,2,2620,'App\\Models\\Receipt',2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',800.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2838,7986,40759,8015,2,2621,'App\\Models\\Receipt',2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',550.01,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2839,7986,40759,8015,2,2622,'App\\Models\\Receipt',2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',450.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2840,7986,40759,8015,2,2623,'App\\Models\\Receipt',2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',850.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2841,7986,40759,8015,2,2624,'App\\Models\\Receipt',2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1150.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2842,7986,40759,8015,2,2625,'App\\Models\\Receipt',2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1600.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2843,7986,40759,8015,2,2626,'App\\Models\\Receipt',2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',550.01,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2844,7986,40759,8015,2,2627,'App\\Models\\Receipt',2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1100.00,NULL,NULL,1,'2023-03-10 09:57:47','2023-03-10 09:57:47',NULL),(2845,7986,40759,8015,2,2628,'App\\Models\\Receipt',2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1600.00,NULL,NULL,1,'2023-03-10 09:57:48','2023-03-10 09:57:48',NULL),(2846,7986,40759,8015,2,2629,'App\\Models\\Receipt',2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1050.00,NULL,NULL,1,'2023-03-10 09:57:48','2023-03-10 09:57:48',NULL),(2847,7986,40759,8015,2,2630,'App\\Models\\Receipt',2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',199.99,NULL,NULL,1,'2023-03-10 09:57:48','2023-03-10 09:57:48',NULL),(2848,7986,40759,8015,2,2631,'App\\Models\\Receipt',2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1600.00,NULL,NULL,1,'2023-03-10 09:57:48','2023-03-10 09:57:48',NULL),(2849,7986,40759,8015,2,2632,'App\\Models\\Receipt',2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1959.99,NULL,NULL,1,'2023-03-10 09:57:48','2023-03-10 09:57:48',NULL),(2850,7986,40759,8015,2,2633,'App\\Models\\Receipt',2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',900.00,NULL,NULL,1,'2023-03-10 09:57:48','2023-03-10 09:57:48',NULL);
INSERT INTO `balance_libro` VALUES (2851,7986,40759,8015,2,2634,'App\\Models\\Receipt',2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',600.00,NULL,NULL,1,'2023-03-10 09:57:48','2023-03-10 09:57:48',NULL),(2852,7986,40759,8015,2,2635,'App\\Models\\Receipt',2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1100.00,NULL,NULL,1,'2023-03-10 09:57:48','2023-03-10 09:57:48',NULL),(2853,7986,40759,8015,2,2636,'App\\Models\\Receipt',2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1750.00,NULL,NULL,1,'2023-03-10 09:57:48','2023-03-10 09:57:48',NULL),(2854,7986,40759,8015,2,2637,'App\\Models\\Receipt',2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1800.00,NULL,NULL,1,'2023-03-10 09:57:48','2023-03-10 09:57:48',NULL),(2855,7986,40759,8015,2,2638,'App\\Models\\Receipt',2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1600.00,NULL,NULL,1,'2023-03-10 09:57:48','2023-03-10 09:57:48',NULL),(2856,7986,40759,8015,2,2639,'App\\Models\\Receipt',2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1050.00,NULL,NULL,1,'2023-03-10 09:57:48','2023-03-10 09:57:48',NULL),(2857,7986,40759,8015,2,2640,'App\\Models\\Receipt',2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',950.00,NULL,NULL,1,'2023-03-10 09:57:49','2023-03-10 09:57:49',NULL),(2858,7986,40759,8015,2,2641,'App\\Models\\Receipt',2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1550.01,NULL,NULL,1,'2023-03-10 09:57:49','2023-03-10 09:57:49',NULL),(2859,7986,40759,8015,3,2642,'App\\Models\\Receipt',2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',28672.40,NULL,NULL,1,'2023-03-10 09:58:06','2023-03-16 09:52:29','2023-03-16 09:52:29'),(2860,7986,40759,8015,3,2643,'App\\Models\\Receipt',2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',6337.22,NULL,NULL,1,'2023-03-10 09:58:06','2023-03-10 09:58:06',NULL),(2861,7986,40759,8015,3,2644,'App\\Models\\Receipt',2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1200.00,NULL,NULL,1,'2023-03-10 09:58:06','2023-03-10 09:58:06',NULL),(2862,7986,40759,8015,3,2645,'App\\Models\\Receipt',2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',905.75,NULL,NULL,1,'2023-03-10 09:58:06','2023-03-10 09:58:06',NULL),(2863,7986,40759,8015,3,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',123856.21,NULL,NULL,1,'2023-03-10 09:58:06','2023-03-10 10:14:22','2023-03-10 10:14:22'),(2864,7986,40759,8015,3,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',7854.20,NULL,NULL,1,'2023-03-10 09:58:06','2023-03-10 10:14:52','2023-03-10 10:14:52'),(2865,7986,40759,8015,3,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',9796.62,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-16 09:53:45','2023-03-16 09:53:45'),(2866,7986,40759,8015,3,2649,'App\\Models\\Receipt',2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',4444.94,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 09:58:07',NULL),(2867,7986,40759,8015,3,2650,'App\\Models\\Receipt',2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',430.35,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 09:58:07',NULL),(2868,7986,40759,8015,3,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',134758.14,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 10:16:06','2023-03-10 10:16:06'),(2869,7986,40759,8015,3,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',17693.68,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 10:16:42','2023-03-10 10:16:42'),(2870,7986,40759,8015,3,2653,'App\\Models\\Receipt',2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',31477.05,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 09:58:07',NULL);
INSERT INTO `balance_libro` VALUES (2871,7986,40759,8015,3,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',149188.13,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 10:17:29','2023-03-10 10:17:29'),(2872,7986,40759,8015,3,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',44952.98,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 10:17:56','2023-03-10 10:17:56'),(2873,7986,40759,8015,3,2656,'App\\Models\\Receipt',2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',4793.05,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 09:58:07',NULL),(2874,7986,40759,8015,3,2657,'App\\Models\\Receipt',2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',484.86,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 09:58:07',NULL),(2875,7986,40759,8015,3,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',149963.70,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 10:18:34','2023-03-10 10:18:34'),(2876,7986,40759,8015,3,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3172.21,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-16 09:54:55','2023-03-16 09:54:55'),(2877,7986,40759,8015,3,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',229781.10,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-17 10:48:00','2023-03-17 10:48:00'),(2878,7986,40759,8015,3,2661,'App\\Models\\Receipt',2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',3455.76,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 09:58:07',NULL),(2879,7986,40759,8015,3,2662,'App\\Models\\Receipt',2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',365.99,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 09:58:07',NULL),(2880,7986,40759,8015,3,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',88534.92,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 10:19:51','2023-03-10 10:19:51'),(2881,7986,40759,8015,3,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',11587.70,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 10:19:10','2023-03-10 10:19:10'),(2882,7986,40759,8015,3,2665,'App\\Models\\Receipt',2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',7699.00,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-16 09:52:15','2023-03-16 09:52:15'),(2883,7986,40759,8015,3,2666,'App\\Models\\Receipt',2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',150032.05,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-10 09:58:07',NULL),(2884,7986,40759,8015,3,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16768.15,NULL,NULL,1,'2023-03-10 09:58:07','2023-03-16 09:55:44','2023-03-16 09:55:44'),(2885,7986,40720,1519,3,2668,'App\\Models\\Receipt',2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',1440.07,NULL,NULL,1,'2023-03-10 09:59:54','2023-03-23 09:59:12','2023-03-23 09:59:12'),(2886,7986,40720,1519,3,2669,'App\\Models\\Receipt',2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',41688.28,NULL,NULL,1,'2023-03-10 09:59:54','2023-03-10 09:59:54',NULL),(2887,7986,40720,1519,3,2670,'App\\Models\\Receipt',2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2000.00,NULL,NULL,1,'2023-03-10 09:59:54','2023-03-10 09:59:54',NULL),(2888,7986,40776,17354,3,2671,'App\\Models\\Receipt',2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',42350.00,NULL,NULL,1,'2023-03-10 10:00:13','2023-03-10 10:00:13',NULL),(2889,7986,40776,17354,3,2672,'App\\Models\\Receipt',2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',43700.00,NULL,NULL,1,'2023-03-10 10:00:13','2023-03-10 10:00:13',NULL),(2890,7986,40776,17354,3,2673,'App\\Models\\Receipt',2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',10600.00,NULL,NULL,1,'2023-03-10 10:00:13','2023-03-10 10:00:13',NULL);
INSERT INTO `balance_libro` VALUES (2891,7986,40776,17354,3,2674,'App\\Models\\Receipt',2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',10406.00,NULL,NULL,1,'2023-03-10 10:00:13','2023-03-10 10:00:13',NULL),(2892,7986,40776,17354,3,2675,'App\\Models\\Receipt',2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',10600.00,NULL,NULL,1,'2023-03-10 10:00:13','2023-03-10 10:00:13',NULL),(2893,7986,40776,17354,3,2676,'App\\Models\\Receipt',2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',62000.00,NULL,NULL,1,'2023-03-10 10:00:13','2023-03-10 10:00:13',NULL),(2894,7986,40776,17354,3,2677,'App\\Models\\Receipt',2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',1777.41,NULL,NULL,1,'2023-03-10 10:00:13','2023-03-10 10:00:13',NULL),(2895,7986,40776,17354,3,2678,'App\\Models\\Receipt',2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',23500.00,NULL,NULL,1,'2023-03-10 10:00:13','2023-03-10 10:00:13',NULL),(2896,7986,40776,17354,2,2679,'App\\Models\\Receipt',2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',560243.67,NULL,NULL,1,'2023-03-10 10:00:42','2023-03-10 10:00:42',NULL),(2897,7986,40721,3019,2,2680,'App\\Models\\Receipt',2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',189707.43,NULL,NULL,1,'2023-03-10 10:01:47','2023-03-10 10:01:47',NULL),(2898,7986,40721,3019,2,2681,'App\\Models\\Receipt',2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',26550.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2899,7986,40721,3019,2,2682,'App\\Models\\Receipt',2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',23441.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2900,7986,40721,3019,2,2683,'App\\Models\\Receipt',2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',19872.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2901,7986,40721,3019,2,2684,'App\\Models\\Receipt',2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',25649.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2902,7986,40721,3019,2,2685,'App\\Models\\Receipt',2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',240358.03,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2903,7986,40721,3019,2,2686,'App\\Models\\Receipt',2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',235977.83,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2904,7986,40721,3019,2,2687,'App\\Models\\Receipt',2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',17699.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2905,7986,40721,3019,2,2688,'App\\Models\\Receipt',2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',25722.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2906,7986,40721,3019,2,2689,'App\\Models\\Receipt',2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',24879.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2907,7986,40721,3019,2,2690,'App\\Models\\Receipt',2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-26','2023-02-26',23990.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2908,7986,40721,3019,2,2691,'App\\Models\\Receipt',2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',284094.69,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2909,7986,40721,3019,2,2692,'App\\Models\\Receipt',2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',241338.13,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2910,7986,40721,3019,2,2693,'App\\Models\\Receipt',2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',24622.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2911,7986,40721,3019,2,2694,'App\\Models\\Receipt',2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',25321.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL);
INSERT INTO `balance_libro` VALUES (2912,7986,40721,3019,2,2695,'App\\Models\\Receipt',2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',25120.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2913,7986,40721,3019,2,2696,'App\\Models\\Receipt',2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',25411.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2914,7986,40721,3019,2,2697,'App\\Models\\Receipt',2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',25311.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2915,7986,40721,3019,2,2698,'App\\Models\\Receipt',2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',23111.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2916,7986,40721,3019,2,2699,'App\\Models\\Receipt',2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',260982.48,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2917,7986,40721,3019,2,2700,'App\\Models\\Receipt',2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',154327.03,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2918,7986,40721,3019,2,2701,'App\\Models\\Receipt',2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',24777.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2919,7986,40721,3019,2,2702,'App\\Models\\Receipt',2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',23766.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2920,7986,40721,3019,2,2703,'App\\Models\\Receipt',2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',22988.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2921,7986,40721,3019,2,2704,'App\\Models\\Receipt',2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',25199.00,NULL,NULL,1,'2023-03-10 10:01:48','2023-03-10 10:01:48',NULL),(2922,7986,40721,3019,3,2705,'App\\Models\\Receipt',2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',31416.81,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2923,7986,40721,3019,3,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',8598.76,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-17 11:09:18','2023-03-17 11:09:18'),(2924,7986,40721,3019,3,2707,'App\\Models\\Receipt',2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',38400.00,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2925,7986,40721,3019,3,2708,'App\\Models\\Receipt',2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',9474.00,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2926,7986,40721,3019,3,2709,'App\\Models\\Receipt',2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',17207.70,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2927,7986,40721,3019,3,2710,'App\\Models\\Receipt',2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',29902.04,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2928,7986,40721,3019,3,2711,'App\\Models\\Receipt',2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',10998.53,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2929,7986,40721,3019,3,2712,'App\\Models\\Receipt',2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',1027.57,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2930,7986,40721,3019,3,2713,'App\\Models\\Receipt',2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',21119.01,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2931,7986,40721,3019,3,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',47372.35,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-17 11:14:19','2023-03-17 11:14:19');
INSERT INTO `balance_libro` VALUES (2932,7986,40721,3019,3,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',18576.27,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-17 11:10:04','2023-03-17 11:10:04'),(2933,7986,40721,3019,3,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',33996.53,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-17 11:13:17','2023-03-17 11:13:17'),(2934,7986,40721,3019,3,2717,'App\\Models\\Receipt',2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',13493.20,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-28 09:05:58','2023-03-28 09:05:58'),(2935,7986,40721,3019,3,2718,'App\\Models\\Receipt',2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',4641.54,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2936,7986,40721,3019,3,2719,'App\\Models\\Receipt',2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',18643.93,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-28 09:06:13','2023-03-28 09:06:13'),(2937,7986,40721,3019,3,2720,'App\\Models\\Receipt',2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',69790.72,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2938,7986,40721,3019,3,2721,'App\\Models\\Receipt',2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',25617.18,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2939,7986,40721,3019,3,2722,'App\\Models\\Receipt',2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',1958.79,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-28 09:06:49','2023-03-28 09:06:49'),(2940,7986,40721,3019,3,2723,'App\\Models\\Receipt',2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-07','2023-02-07',9132.26,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2941,7986,40721,3019,3,2724,'App\\Models\\Receipt',2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',6264.38,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2942,7986,40721,3019,3,2725,'App\\Models\\Receipt',2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',16519.07,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2943,7986,40721,3019,3,2726,'App\\Models\\Receipt',2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-09','2023-02-09',1106.09,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2944,7986,40721,3019,3,2727,'App\\Models\\Receipt',2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',27325.00,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2945,7986,40721,3019,3,2728,'App\\Models\\Receipt',2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',40387.47,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-10 10:02:22',NULL),(2946,7986,40721,3019,3,2729,'App\\Models\\Receipt',2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',1514.02,NULL,NULL,1,'2023-03-10 10:02:22','2023-03-28 09:09:30','2023-03-28 09:09:30'),(2947,7986,40721,3019,3,2730,'App\\Models\\Receipt',2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',27488.07,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2948,7986,40721,3019,3,2731,'App\\Models\\Receipt',2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',5056.84,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2949,7986,40721,3019,3,2732,'App\\Models\\Receipt',2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-11','2023-02-11',3789.69,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2950,7986,40721,3019,3,2733,'App\\Models\\Receipt',2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',33715.38,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2951,7986,40721,3019,3,2734,'App\\Models\\Receipt',2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',36559.93,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL);
INSERT INTO `balance_libro` VALUES (2952,7986,40721,3019,3,2735,'App\\Models\\Receipt',2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',6003.45,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2953,7986,40721,3019,3,2736,'App\\Models\\Receipt',2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-13','2023-02-13',4000.01,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-28 09:09:59','2023-03-28 09:09:59'),(2954,7986,40721,3019,3,2737,'App\\Models\\Receipt',2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',1958.79,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-28 09:07:02','2023-03-28 09:07:02'),(2955,7986,40721,3019,3,2738,'App\\Models\\Receipt',2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',32769.53,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-28 09:10:43','2023-03-28 09:10:43'),(2956,7986,40721,3019,3,2739,'App\\Models\\Receipt',2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',24451.02,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2957,7986,40721,3019,3,2740,'App\\Models\\Receipt',2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',22483.18,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2958,7986,40721,3019,3,2741,'App\\Models\\Receipt',2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',10152.11,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2959,7986,40721,3019,3,2742,'App\\Models\\Receipt',2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',4909.15,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2960,7986,40721,3019,3,2743,'App\\Models\\Receipt',2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-16','2023-02-16',28168.72,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2961,7986,40721,3019,3,2744,'App\\Models\\Receipt',2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',32769.53,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-28 09:10:22','2023-03-28 09:10:22'),(2962,7986,40721,3019,3,2745,'App\\Models\\Receipt',2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',390.00,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2963,7986,40721,3019,3,2746,'App\\Models\\Receipt',2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',38954.00,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2964,7986,40721,3019,3,2747,'App\\Models\\Receipt',2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',6266.86,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2965,7986,40721,3019,3,2748,'App\\Models\\Receipt',2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',17908.51,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2966,7986,40721,3019,3,2749,'App\\Models\\Receipt',2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',34692.21,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2967,7986,40721,3019,3,2750,'App\\Models\\Receipt',2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',20338.64,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2968,7986,40721,3019,3,2751,'App\\Models\\Receipt',2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-18','2023-02-18',4719.00,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-28 09:11:02','2023-03-28 09:11:02'),(2969,7986,40721,3019,3,2752,'App\\Models\\Receipt',2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-20','2023-02-20',10756.90,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-28 09:11:18','2023-03-28 09:11:18'),(2970,7986,40721,3019,3,2753,'App\\Models\\Receipt',2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',1423.70,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2971,7986,40721,3019,3,2754,'App\\Models\\Receipt',2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',24306.39,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL);
INSERT INTO `balance_libro` VALUES (2972,7986,40721,3019,3,2755,'App\\Models\\Receipt',2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',19494.64,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2973,7986,40721,3019,3,2756,'App\\Models\\Receipt',2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',35408.88,NULL,NULL,1,'2023-03-10 10:02:23','2023-03-10 10:02:23',NULL),(2974,7986,40721,3019,3,2757,'App\\Models\\Receipt',2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',13598.31,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2975,7986,40721,3019,3,2758,'App\\Models\\Receipt',2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',12324.87,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2976,7986,40721,3019,3,2759,'App\\Models\\Receipt',2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',25250.00,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2977,7986,40721,3019,3,2760,'App\\Models\\Receipt',2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',1284000.00,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-28 09:11:51','2023-03-28 09:11:51'),(2978,7986,40721,3019,3,2761,'App\\Models\\Receipt',2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',19566.71,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2979,7986,40721,3019,3,2762,'App\\Models\\Receipt',2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',20039.20,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2980,7986,40721,3019,3,2763,'App\\Models\\Receipt',2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',9363.86,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2981,7986,40721,3019,3,2764,'App\\Models\\Receipt',2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',22079.63,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2982,7986,40721,3019,3,2765,'App\\Models\\Receipt',2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',2752.23,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2983,7986,40721,3019,3,2766,'App\\Models\\Receipt',2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-25','2023-02-25',18229.29,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2984,7986,40721,3019,3,2767,'App\\Models\\Receipt',2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',128865.65,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2985,7986,40721,3019,3,2768,'App\\Models\\Receipt',2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',12848.81,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2986,7986,40721,3019,3,2769,'App\\Models\\Receipt',2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',15956.40,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2987,7986,40721,3019,3,2770,'App\\Models\\Receipt',2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',59198.35,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2988,7986,40721,3019,3,2771,'App\\Models\\Receipt',2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',1653.16,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-28 09:12:26','2023-03-28 09:12:26'),(2989,7986,40721,3019,3,2772,'App\\Models\\Receipt',2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',721.66,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-28 09:12:15','2023-03-28 09:12:15'),(2990,7986,40721,3019,3,2773,'App\\Models\\Receipt',2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-27','2023-02-27',17474.01,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-28 09:05:45','2023-03-28 09:05:45'),(2991,7986,40721,3019,3,2774,'App\\Models\\Receipt',2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',3718.58,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL);
INSERT INTO `balance_libro` VALUES (2992,7986,40721,3019,3,2775,'App\\Models\\Receipt',2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',2836.36,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2993,7986,40721,3019,3,2776,'App\\Models\\Receipt',2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4758.11,NULL,NULL,1,'2023-03-10 10:02:24','2023-03-10 10:02:24',NULL),(2994,7986,40721,3019,3,2777,'App\\Models\\Receipt',2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',4589.99,NULL,NULL,1,'2023-03-10 10:02:25','2023-03-28 09:12:50','2023-03-28 09:12:50'),(2995,7986,40721,3019,3,2778,'App\\Models\\Receipt',2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',8672.56,NULL,NULL,1,'2023-03-10 10:02:25','2023-03-28 09:13:06','2023-03-28 09:13:06'),(2996,7986,40759,8015,3,2779,'App\\Models\\Receipt',2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',151976.45,NULL,NULL,1,'2023-03-10 10:12:33','2023-03-10 10:12:33',NULL),(2997,7986,40759,8015,3,2646,'App\\Models\\Receipt',2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-08','2023-02-08',123856.21,NULL,NULL,1,'2023-03-10 10:14:22','2023-03-10 10:14:22',NULL),(2998,7986,40759,8015,3,2647,'App\\Models\\Receipt',2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',7854.20,NULL,NULL,1,'2023-03-10 10:14:52','2023-03-10 10:14:52',NULL),(2999,7986,40759,8015,3,2651,'App\\Models\\Receipt',2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',134758.14,NULL,NULL,1,'2023-03-10 10:16:06','2023-03-10 10:16:06',NULL),(3000,7986,40759,8015,3,2652,'App\\Models\\Receipt',2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-14','2023-02-14',17693.68,NULL,NULL,1,'2023-03-10 10:16:42','2023-03-10 10:16:42',NULL),(3001,7986,40759,8015,3,2654,'App\\Models\\Receipt',2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-15','2023-02-15',149188.13,NULL,NULL,1,'2023-03-10 10:17:29','2023-03-10 10:17:29',NULL),(3002,7986,40759,8015,3,2655,'App\\Models\\Receipt',2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',44952.98,NULL,NULL,1,'2023-03-10 10:17:56','2023-03-10 10:17:56',NULL),(3003,7986,40759,8015,3,2658,'App\\Models\\Receipt',2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-22','2023-02-22',149963.70,NULL,NULL,1,'2023-03-10 10:18:34','2023-03-10 10:18:34',NULL),(3004,7986,40759,8015,3,2664,'App\\Models\\Receipt',2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',11587.70,NULL,NULL,1,'2023-03-10 10:19:10','2023-03-10 10:19:10',NULL),(3005,7986,40759,8015,3,2663,'App\\Models\\Receipt',2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',88534.92,NULL,NULL,1,'2023-03-10 10:19:51','2023-03-10 10:19:51',NULL),(3006,7986,40759,8015,3,2780,'App\\Models\\Receipt',2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',8411.68,NULL,NULL,1,'2023-03-10 10:46:15','2023-03-10 10:46:15',NULL),(3007,7986,40759,8015,8,2781,'App\\Models\\Receipt',2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',1185.50,NULL,NULL,1,'2023-03-10 10:46:40','2023-03-10 10:46:40',NULL),(3008,7986,40720,1519,3,2782,'App\\Models\\Receipt',2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',10900.84,NULL,NULL,1,'2023-03-10 10:57:57','2023-03-10 10:57:57',NULL),(3009,7986,40720,1519,3,2783,'App\\Models\\Receipt',2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',20995.42,NULL,NULL,1,'2023-03-10 10:58:54','2023-03-10 10:58:54',NULL),(3010,7986,40720,1519,3,2784,'App\\Models\\Receipt',2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-17','2023-02-17',8256.41,NULL,NULL,1,'2023-03-10 11:00:13','2023-03-10 11:00:13',NULL),(3011,7986,40720,1519,3,2785,'App\\Models\\Receipt',2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',9390.00,NULL,NULL,1,'2023-03-10 11:01:24','2023-03-10 11:01:24',NULL);
INSERT INTO `balance_libro` VALUES (3012,7986,40720,1519,3,2786,'App\\Models\\Receipt',2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',20610.00,NULL,NULL,1,'2023-03-10 11:02:27','2023-03-10 11:02:27',NULL),(3013,7986,40776,17354,3,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5001.10,NULL,NULL,1,'2023-03-10 11:28:40','2023-03-10 11:35:19','2023-03-10 11:35:19'),(3014,7986,40776,17354,3,2787,'App\\Models\\Receipt',2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-01','2023-02-01',5001.10,NULL,NULL,1,'2023-03-10 11:35:19','2023-03-10 11:35:19',NULL),(3015,7986,40776,17354,3,2788,'App\\Models\\Receipt',2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-02','2023-02-02',141670.00,NULL,NULL,1,'2023-03-10 11:38:19','2023-03-10 11:38:19',NULL),(3016,7986,40776,17354,3,2789,'App\\Models\\Receipt',2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-06','2023-02-06',38764.99,NULL,NULL,1,'2023-03-10 11:40:28','2023-03-10 11:40:28',NULL),(3017,7986,40776,17354,3,2790,'App\\Models\\Receipt',2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9900.00,NULL,NULL,1,'2023-03-10 11:42:19','2023-03-10 11:42:19',NULL),(3018,7986,40776,17354,3,2791,'App\\Models\\Receipt',2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',9149.62,NULL,NULL,1,'2023-03-10 11:44:16','2023-03-10 11:44:16',NULL),(3019,7986,40776,17354,3,2792,'App\\Models\\Receipt',2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',266.64,NULL,NULL,1,'2023-03-10 11:45:00','2023-03-10 11:45:00',NULL),(3020,7986,40759,8015,3,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',9717.61,NULL,NULL,1,'2023-03-16 09:53:45','2023-03-22 09:42:39','2023-03-22 09:42:39'),(3021,7986,40759,8015,3,2659,'App\\Models\\Receipt',2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',3172.22,NULL,NULL,1,'2023-03-16 09:54:55','2023-03-16 09:54:55',NULL),(3022,7986,40759,8015,3,2667,'App\\Models\\Receipt',2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',16768.16,NULL,NULL,1,'2023-03-16 09:55:44','2023-03-16 09:55:44',NULL),(3023,7986,40721,3019,3,2793,'App\\Models\\Receipt',2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-21','2023-02-21',13915.96,NULL,NULL,1,'2023-03-16 10:29:49','2023-03-16 10:29:49',NULL),(3024,7986,40721,3019,3,2794,'App\\Models\\Receipt',2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-23','2023-02-23',47338.52,NULL,NULL,1,'2023-03-16 10:31:00','2023-03-16 10:31:00',NULL),(3025,7986,40721,3019,3,2795,'App\\Models\\Receipt',2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',12289.06,NULL,NULL,1,'2023-03-16 11:47:46','2023-03-16 11:47:46',NULL),(3026,7986,40721,3019,3,2796,'App\\Models\\Receipt',2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',2330.73,NULL,NULL,1,'2023-03-16 11:48:11','2023-03-16 11:48:11',NULL),(3027,7986,40721,3019,3,2797,'App\\Models\\Receipt',2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',8489.73,NULL,NULL,1,'2023-03-16 12:19:21','2023-03-16 12:19:21',NULL),(3028,7986,40721,3019,3,2798,'App\\Models\\Receipt',2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',7674.40,NULL,NULL,1,'2023-03-16 12:20:34','2023-03-16 12:20:34',NULL),(3029,7986,40721,3019,3,2799,'App\\Models\\Receipt',2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',3398.87,NULL,NULL,1,'2023-03-16 12:21:14','2023-03-16 12:21:14',NULL),(3030,7986,40721,3019,3,2800,'App\\Models\\Receipt',2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-05','2023-02-05',44193.16,NULL,NULL,1,'2023-03-16 12:22:30','2023-03-16 12:22:30',NULL),(3031,7986,40759,8015,3,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',240636.90,NULL,NULL,1,'2023-03-17 10:48:00','2023-03-17 10:48:16','2023-03-17 10:48:16');
INSERT INTO `balance_libro` VALUES (3032,7986,40759,8015,3,2660,'App\\Models\\Receipt',2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-24','2023-02-24',229781.10,NULL,NULL,1,'2023-03-17 10:48:16','2023-03-17 10:48:16',NULL),(3033,7986,40721,3019,3,2706,'App\\Models\\Receipt',2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-03','2023-02-03',8598.76,NULL,NULL,1,'2023-03-17 11:09:18','2023-03-17 11:09:18',NULL),(3034,7986,40721,3019,3,2715,'App\\Models\\Receipt',2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',18576.27,NULL,NULL,1,'2023-03-17 11:10:04','2023-03-17 11:10:04',NULL),(3035,7986,40721,3019,3,2716,'App\\Models\\Receipt',2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',33996.53,NULL,NULL,1,'2023-03-17 11:13:17','2023-03-17 11:13:17',NULL),(3036,7986,40721,3019,3,2714,'App\\Models\\Receipt',2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-04','2023-02-04',47372.35,NULL,NULL,1,'2023-03-17 11:14:19','2023-03-17 11:14:19',NULL),(3037,7986,40772,11019,1,3037,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,315478.53,NULL,NULL,1,'2023-03-21 11:24:05','2023-03-21 11:24:05',NULL),(3038,7986,40759,8015,3,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',9796.62,NULL,NULL,1,'2023-03-22 09:42:39','2023-03-22 09:48:27','2023-03-22 09:48:27'),(3039,7986,40759,8015,3,2648,'App\\Models\\Receipt',2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-12','2023-02-12',9796.62,NULL,NULL,1,'2023-03-22 09:48:27','2023-03-22 09:48:27',NULL),(3040,7986,40759,8015,16,983,'App\\Models\\PeriodLiquidation',NULL,983,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',24015.33,NULL,NULL,1,'2023-03-22 12:03:54','2023-03-22 12:03:54',NULL),(3041,7986,40720,1519,15,985,'App\\Models\\PeriodLiquidation',NULL,985,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',228188.73,NULL,NULL,1,'2023-03-23 10:27:56','2023-03-23 10:27:56',NULL),(3042,7986,40720,1517,16,505,'App\\Models\\PeriodLiquidation',NULL,505,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',0.00,NULL,NULL,1,'2023-03-23 10:28:01','2023-03-23 10:28:01',NULL),(3043,7986,40720,1519,16,986,'App\\Models\\PeriodLiquidation',NULL,986,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',0.00,NULL,NULL,1,'2023-03-23 10:28:05','2023-03-23 10:28:05',NULL),(3044,7986,40720,1518,16,868,'App\\Models\\PeriodLiquidation',NULL,868,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',0.00,NULL,NULL,1,'2023-03-23 10:28:09','2023-03-23 10:28:09',NULL),(3045,7986,40776,17353,15,867,'App\\Models\\PeriodLiquidation',NULL,867,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',401728.11,NULL,NULL,1,'2023-03-23 11:38:16','2023-03-23 11:38:16',NULL),(3046,7986,40721,3019,3,2801,'App\\Models\\Receipt',2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',223250.00,NULL,NULL,1,'2023-03-28 09:15:43','2023-03-28 09:15:43',NULL),(3047,7986,40721,3019,7,2802,'App\\Models\\Receipt',2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',7.00,NULL,NULL,1,'2023-03-29 09:45:25','2023-03-29 09:45:25',NULL),(3048,7986,40721,3019,7,2803,'App\\Models\\Receipt',2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-05','2023-01-05',76.68,NULL,NULL,1,'2023-03-29 09:45:25','2023-03-29 09:45:25',NULL),(3049,7986,40721,3019,7,2804,'App\\Models\\Receipt',2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-09','2023-01-09',74.28,NULL,NULL,1,'2023-03-29 09:45:25','2023-03-29 09:45:25',NULL),(3050,7986,40721,3019,16,1024,'App\\Models\\PeriodLiquidation',NULL,1024,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',430703.91,NULL,NULL,1,'2023-03-29 09:59:18','2023-03-29 09:59:18',NULL),(3051,7986,40721,3019,15,1023,'App\\Models\\PeriodLiquidation',NULL,1023,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',378506.65,NULL,NULL,1,'2023-03-29 09:59:42','2023-03-29 09:59:42',NULL);
INSERT INTO `balance_libro` VALUES (3052,7986,40721,3020,2,2805,'App\\Models\\Receipt',2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',217636.65,NULL,NULL,1,'2023-04-12 08:59:25','2023-04-12 08:59:25',NULL),(3053,7986,40721,3020,2,2806,'App\\Models\\Receipt',2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',216495.62,NULL,NULL,1,'2023-04-12 08:59:25','2023-04-12 08:59:25',NULL),(3054,7986,40721,3020,2,2807,'App\\Models\\Receipt',2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',23411.00,NULL,NULL,1,'2023-04-12 08:59:25','2023-04-12 08:59:25',NULL),(3055,7986,40721,3020,2,2808,'App\\Models\\Receipt',2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',23199.00,NULL,NULL,1,'2023-04-12 08:59:25','2023-04-12 08:59:25',NULL),(3056,7986,40721,3020,2,2809,'App\\Models\\Receipt',2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',22133.00,NULL,NULL,1,'2023-04-12 08:59:25','2023-04-12 08:59:25',NULL),(3057,7986,40721,3020,2,2810,'App\\Models\\Receipt',2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',106062.55,NULL,NULL,1,'2023-04-12 08:59:25','2023-04-12 08:59:25',NULL),(3058,7986,40721,3020,2,2811,'App\\Models\\Receipt',2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',31067.96,NULL,NULL,1,'2023-04-12 08:59:25','2023-04-12 08:59:25',NULL),(3059,7986,40721,3020,2,2812,'App\\Models\\Receipt',2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',19872.00,NULL,NULL,1,'2023-04-12 08:59:25','2023-04-12 08:59:25',NULL),(3060,7986,40721,3020,2,2813,'App\\Models\\Receipt',2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',22142.00,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3061,7986,40721,3020,2,2814,'App\\Models\\Receipt',2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',23544.00,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3062,7986,40721,3020,2,2815,'App\\Models\\Receipt',2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',214155.48,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3063,7986,40721,3020,2,2816,'App\\Models\\Receipt',2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',22154.00,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3064,7986,40721,3020,2,2817,'App\\Models\\Receipt',2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',21344.00,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3065,7986,40721,3020,2,2818,'App\\Models\\Receipt',2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',24000.00,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3066,7986,40721,3020,2,2819,'App\\Models\\Receipt',2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',240371.34,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3067,7986,40721,3020,2,2820,'App\\Models\\Receipt',2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',29423.57,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3068,7986,40721,3020,2,2821,'App\\Models\\Receipt',2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',20076.00,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3069,7986,40721,3020,2,2822,'App\\Models\\Receipt',2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',23188.00,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3070,7986,40721,3020,2,2823,'App\\Models\\Receipt',2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',240494.76,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3071,7986,40721,3020,2,2824,'App\\Models\\Receipt',2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',152311.17,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3072,7986,40721,3020,2,2825,'App\\Models\\Receipt',2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',22377.00,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL);
INSERT INTO `balance_libro` VALUES (3073,7986,40721,3020,2,2826,'App\\Models\\Receipt',2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',18765.00,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3074,7986,40721,3020,2,2827,'App\\Models\\Receipt',2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',24510.00,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3075,7986,40721,3020,2,2828,'App\\Models\\Receipt',2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',31435.80,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3076,7986,40721,3020,2,2829,'App\\Models\\Receipt',2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',361492.34,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3077,7986,40721,3020,2,2830,'App\\Models\\Receipt',2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',375786.07,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3078,7986,40721,3020,2,2831,'App\\Models\\Receipt',2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',23678.00,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3079,7986,40721,3020,2,2832,'App\\Models\\Receipt',2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',471481.34,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3080,7986,40721,3020,2,2833,'App\\Models\\Receipt',2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',417313.27,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3081,7986,40721,3020,2,2834,'App\\Models\\Receipt',2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',22560.00,NULL,NULL,1,'2023-04-12 08:59:26','2023-04-12 08:59:26',NULL),(3082,7986,40721,3020,2,2835,'App\\Models\\Receipt',2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',21890.00,NULL,NULL,1,'2023-04-12 08:59:27','2023-04-12 08:59:27',NULL),(3083,7986,40721,3020,2,2836,'App\\Models\\Receipt',2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',486269.96,NULL,NULL,1,'2023-04-12 08:59:27','2023-04-12 08:59:27',NULL),(3084,7986,40721,3020,2,2837,'App\\Models\\Receipt',2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',498937.45,NULL,NULL,1,'2023-04-12 08:59:27','2023-04-12 08:59:27',NULL),(3085,7986,40774,12519,1,3085,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,61704.79,NULL,NULL,1,'2023-04-12 11:21:46','2023-04-12 11:21:46',NULL),(3086,7986,40759,8016,1,3086,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,312741.96,NULL,NULL,1,'2023-04-12 11:29:34','2023-04-12 11:29:34',NULL),(3087,7986,40721,3020,1,3087,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,539364.90,NULL,NULL,1,'2023-04-12 11:34:56','2023-04-12 11:34:56',NULL),(3088,7986,40776,17355,1,3088,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,60998.71,NULL,NULL,1,'2023-04-12 12:03:36','2023-04-12 12:03:36',NULL),(3089,7986,40759,8016,2,2838,'App\\Models\\Receipt',2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',800.00,NULL,NULL,1,'2023-04-12 12:16:28','2023-04-12 12:16:28',NULL),(3090,7986,40759,8016,2,2839,'App\\Models\\Receipt',2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2200.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3091,7986,40759,8016,2,2840,'App\\Models\\Receipt',2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',700.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3092,7986,40759,8016,2,2841,'App\\Models\\Receipt',2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',1600.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3093,7986,40759,8016,2,2842,'App\\Models\\Receipt',2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',2150.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL);
INSERT INTO `balance_libro` VALUES (3094,7986,40759,8016,2,2843,'App\\Models\\Receipt',2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',350.01,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3095,7986,40759,8016,2,2844,'App\\Models\\Receipt',2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1050.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3096,7986,40759,8016,2,2845,'App\\Models\\Receipt',2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1600.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3097,7986,40759,8016,2,2846,'App\\Models\\Receipt',2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1600.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3098,7986,40759,8016,2,2847,'App\\Models\\Receipt',2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',350.01,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3099,7986,40759,8016,2,2848,'App\\Models\\Receipt',2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',700.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3100,7986,40759,8016,2,2849,'App\\Models\\Receipt',2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',2430.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3101,7986,40759,8016,2,2850,'App\\Models\\Receipt',2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',350.01,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3102,7986,40759,8016,2,2851,'App\\Models\\Receipt',2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',900.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3103,7986,40759,8016,2,2852,'App\\Models\\Receipt',2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1750.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3104,7986,40759,8016,2,2853,'App\\Models\\Receipt',2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',1319.99,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3105,7986,40759,8016,2,2854,'App\\Models\\Receipt',2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',800.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3106,7986,40759,8016,2,2855,'App\\Models\\Receipt',2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',900.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3107,7986,40759,8016,2,2856,'App\\Models\\Receipt',2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1800.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3108,7986,40759,8016,2,2857,'App\\Models\\Receipt',2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1650.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3109,7986,40759,8016,2,2858,'App\\Models\\Receipt',2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2040.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3110,7986,40759,8016,2,2859,'App\\Models\\Receipt',2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',650.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3111,7986,40759,8016,2,2860,'App\\Models\\Receipt',2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2600.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3112,7986,40759,8016,2,2861,'App\\Models\\Receipt',2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',800.00,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3113,7986,40759,8016,2,2862,'App\\Models\\Receipt',2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2499.99,NULL,NULL,1,'2023-04-12 12:16:29','2023-04-12 12:16:29',NULL),(3114,7986,40759,8016,2,2863,'App\\Models\\Receipt',2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',400.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL);
INSERT INTO `balance_libro` VALUES (3115,7986,40759,8016,2,2864,'App\\Models\\Receipt',2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',500.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3116,7986,40759,8016,2,2865,'App\\Models\\Receipt',2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1500.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3117,7986,40759,8016,2,2866,'App\\Models\\Receipt',2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',500.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3118,7986,40759,8016,2,2867,'App\\Models\\Receipt',2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',2000.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3119,7986,40759,8016,2,2868,'App\\Models\\Receipt',2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1000.01,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3120,7986,40759,8016,2,2869,'App\\Models\\Receipt',2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1000.01,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3121,7986,40759,8016,2,2870,'App\\Models\\Receipt',2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1000.01,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3122,7986,40759,8016,2,2871,'App\\Models\\Receipt',2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',850.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3123,7986,40759,8016,2,2872,'App\\Models\\Receipt',2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1880.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3124,7986,40759,8016,2,2873,'App\\Models\\Receipt',2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1800.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3125,7986,40759,8016,2,2874,'App\\Models\\Receipt',2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',800.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3126,7986,40759,8016,2,2875,'App\\Models\\Receipt',2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3200.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3127,7986,40759,8016,2,2876,'App\\Models\\Receipt',2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1800.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3128,7986,40759,8016,2,2877,'App\\Models\\Receipt',2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1800.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3129,7986,40759,8016,2,2878,'App\\Models\\Receipt',2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',650.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3130,7986,40759,8016,2,2879,'App\\Models\\Receipt',2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',800.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3131,7986,40759,8016,2,2880,'App\\Models\\Receipt',2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1450.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3132,7986,40759,8016,2,2881,'App\\Models\\Receipt',2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',900.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3133,7986,40759,8016,2,2882,'App\\Models\\Receipt',2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1800.00,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3134,7986,40759,8016,2,2883,'App\\Models\\Receipt',2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1000.01,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL),(3135,7986,40759,8016,2,2884,'App\\Models\\Receipt',2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1000.01,NULL,NULL,1,'2023-04-12 12:16:30','2023-04-12 12:16:30',NULL);
INSERT INTO `balance_libro` VALUES (3136,7986,40759,8016,2,2885,'App\\Models\\Receipt',2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1200.01,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3137,7986,40759,8016,2,2886,'App\\Models\\Receipt',2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1800.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3138,7986,40759,8016,2,2887,'App\\Models\\Receipt',2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',650.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3139,7986,40759,8016,2,2888,'App\\Models\\Receipt',2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',650.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3140,7986,40759,8016,2,2889,'App\\Models\\Receipt',2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1000.01,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3141,7986,40759,8016,2,2890,'App\\Models\\Receipt',2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',800.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3142,7986,40759,8016,2,2891,'App\\Models\\Receipt',2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1800.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3143,7986,40759,8016,2,2892,'App\\Models\\Receipt',2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1200.01,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3144,7986,40759,8016,2,2893,'App\\Models\\Receipt',2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',2950.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3145,7986,40759,8016,2,2894,'App\\Models\\Receipt',2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3200.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3146,7986,40759,8016,2,2895,'App\\Models\\Receipt',2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1280.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3147,7986,40759,8016,2,2896,'App\\Models\\Receipt',2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1800.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3148,7986,40759,8016,2,2897,'App\\Models\\Receipt',2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1800.01,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3149,7986,40759,8016,2,2898,'App\\Models\\Receipt',2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1000.01,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3150,7986,40759,8016,2,2899,'App\\Models\\Receipt',2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1080.01,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3151,7986,40759,8016,2,2900,'App\\Models\\Receipt',2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',650.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3152,7986,40759,8016,2,2901,'App\\Models\\Receipt',2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',500.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3153,7986,40759,8016,2,2902,'App\\Models\\Receipt',2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1100.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3154,7986,40759,8016,2,2903,'App\\Models\\Receipt',2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3000.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3155,7986,40759,8016,2,2904,'App\\Models\\Receipt',2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1100.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3156,7986,40759,8016,2,2905,'App\\Models\\Receipt',2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',800.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL);
INSERT INTO `balance_libro` VALUES (3157,7986,40759,8016,2,2906,'App\\Models\\Receipt',2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3550.00,NULL,NULL,1,'2023-04-12 12:16:31','2023-04-12 12:16:31',NULL),(3158,7986,40759,8016,2,2907,'App\\Models\\Receipt',2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1200.01,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3159,7986,40759,8016,2,2908,'App\\Models\\Receipt',2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3200.00,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3160,7986,40759,8016,2,2909,'App\\Models\\Receipt',2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1600.00,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3161,7986,40759,8016,2,2910,'App\\Models\\Receipt',2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1200.01,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3162,7986,40759,8016,2,2911,'App\\Models\\Receipt',2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1000.01,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3163,7986,40759,8016,2,2912,'App\\Models\\Receipt',2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1800.00,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3164,7986,40759,8016,2,2913,'App\\Models\\Receipt',2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',900.00,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3165,7986,40759,8016,2,2914,'App\\Models\\Receipt',2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3440.01,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3166,7986,40759,8016,2,2915,'App\\Models\\Receipt',2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1960.01,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3167,7986,40759,8016,2,2916,'App\\Models\\Receipt',2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1600.00,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3168,7986,40759,8016,2,2917,'App\\Models\\Receipt',2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',3200.00,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3169,7986,40759,8016,2,2918,'App\\Models\\Receipt',2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',600.00,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3170,7986,40759,8016,2,2919,'App\\Models\\Receipt',2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1800.00,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3171,7986,40759,8016,2,2920,'App\\Models\\Receipt',2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',2900.00,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3172,7986,40759,8016,2,2921,'App\\Models\\Receipt',2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',650.00,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3173,7986,40759,8016,2,2922,'App\\Models\\Receipt',2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1000.01,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3174,7986,40759,8016,2,2923,'App\\Models\\Receipt',2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1000.01,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3175,7986,40759,8016,2,2924,'App\\Models\\Receipt',2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',1200.01,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3176,7986,40759,8016,2,2925,'App\\Models\\Receipt',2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1899.99,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3177,7986,40759,8016,2,2926,'App\\Models\\Receipt',2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1400.01,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL);
INSERT INTO `balance_libro` VALUES (3178,7986,40759,8016,2,2927,'App\\Models\\Receipt',2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',800.00,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3179,7986,40759,8016,2,2928,'App\\Models\\Receipt',2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1800.00,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3180,7986,40759,8016,2,2929,'App\\Models\\Receipt',2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',800.00,NULL,NULL,1,'2023-04-12 12:16:32','2023-04-12 12:16:32',NULL),(3181,7986,40759,8016,2,2930,'App\\Models\\Receipt',2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',800.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3182,7986,40759,8016,2,2931,'App\\Models\\Receipt',2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',2560.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3183,7986,40759,8016,2,2932,'App\\Models\\Receipt',2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',900.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3184,7986,40759,8016,2,2933,'App\\Models\\Receipt',2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1800.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3185,7986,40759,8016,2,2934,'App\\Models\\Receipt',2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1800.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3186,7986,40759,8016,2,2935,'App\\Models\\Receipt',2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1000.01,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3187,7986,40759,8016,2,2936,'App\\Models\\Receipt',2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',799.99,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3188,7986,40759,8016,2,2937,'App\\Models\\Receipt',2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1150.01,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3189,7986,40759,8016,2,2938,'App\\Models\\Receipt',2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1000.01,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3190,7986,40759,8016,2,2939,'App\\Models\\Receipt',2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',2800.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3191,7986,40759,8016,2,2940,'App\\Models\\Receipt',2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1800.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3192,7986,40759,8016,2,2941,'App\\Models\\Receipt',2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',2960.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3193,7986,40759,8016,2,2942,'App\\Models\\Receipt',2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',2319.99,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3194,7986,40759,8016,2,2943,'App\\Models\\Receipt',2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1800.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3195,7986,40759,8016,2,2944,'App\\Models\\Receipt',2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',3850.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3196,7986,40759,8016,2,2945,'App\\Models\\Receipt',2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',2000.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3197,7986,40759,8016,2,2946,'App\\Models\\Receipt',2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',3200.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3198,7986,40759,8016,2,2947,'App\\Models\\Receipt',2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1800.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL);
INSERT INTO `balance_libro` VALUES (3199,7986,40759,8016,2,2948,'App\\Models\\Receipt',2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1800.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3200,7986,40759,8016,2,2949,'App\\Models\\Receipt',2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',3280.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3201,7986,40759,8016,2,2950,'App\\Models\\Receipt',2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1100.00,NULL,NULL,1,'2023-04-12 12:16:33','2023-04-12 12:16:33',NULL),(3202,7986,40759,8016,2,2951,'App\\Models\\Receipt',2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1800.00,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3203,7986,40759,8016,2,2952,'App\\Models\\Receipt',2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1200.01,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3204,7986,40759,8016,2,2953,'App\\Models\\Receipt',2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',3200.00,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3205,7986,40759,8016,2,2954,'App\\Models\\Receipt',2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1300.00,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3206,7986,40759,8016,2,2955,'App\\Models\\Receipt',2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1000.01,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3207,7986,40759,8016,2,2956,'App\\Models\\Receipt',2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1800.00,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3208,7986,40759,8016,2,2957,'App\\Models\\Receipt',2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',3200.00,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3209,7986,40759,8016,2,2958,'App\\Models\\Receipt',2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1200.01,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3210,7986,40759,8016,2,2959,'App\\Models\\Receipt',2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1800.00,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3211,7986,40759,8016,2,2960,'App\\Models\\Receipt',2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1800.00,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3212,7986,40759,8016,2,2961,'App\\Models\\Receipt',2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1600.00,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3213,7986,40759,8016,2,2962,'App\\Models\\Receipt',2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1300.00,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3214,7986,40759,8016,2,2963,'App\\Models\\Receipt',2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1200.01,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3215,7986,40759,8016,2,2964,'App\\Models\\Receipt',2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',749.99,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3216,7986,40759,8016,2,2965,'App\\Models\\Receipt',2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',2299.99,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3217,7986,40759,8016,2,2966,'App\\Models\\Receipt',2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1000.01,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3218,7986,40759,8016,2,2967,'App\\Models\\Receipt',2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',650.00,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3219,7986,40759,8016,2,2968,'App\\Models\\Receipt',2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1199.99,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL);
INSERT INTO `balance_libro` VALUES (3220,7986,40759,8016,2,2969,'App\\Models\\Receipt',2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',1000.01,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3221,7986,40759,8016,2,2970,'App\\Models\\Receipt',2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',300.00,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3222,7986,40759,8016,2,2971,'App\\Models\\Receipt',2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',450.00,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3223,7986,40759,8016,2,2972,'App\\Models\\Receipt',2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',2060.00,NULL,NULL,1,'2023-04-12 12:16:34','2023-04-12 12:16:34',NULL),(3224,7986,40759,8016,2,2973,'App\\Models\\Receipt',2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',650.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3225,7986,40759,8016,2,2974,'App\\Models\\Receipt',2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',800.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3226,7986,40759,8016,2,2975,'App\\Models\\Receipt',2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',900.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3227,7986,40759,8016,2,2976,'App\\Models\\Receipt',2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',400.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3228,7986,40759,8016,2,2977,'App\\Models\\Receipt',2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',3200.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3229,7986,40759,8016,2,2978,'App\\Models\\Receipt',2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',700.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3230,7986,40759,8016,2,2979,'App\\Models\\Receipt',2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1000.01,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3231,7986,40759,8016,2,2980,'App\\Models\\Receipt',2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',600.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3232,7986,40759,8016,2,2981,'App\\Models\\Receipt',2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',700.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3233,7986,40759,8016,2,2982,'App\\Models\\Receipt',2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1500.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3234,7986,40759,8016,2,2983,'App\\Models\\Receipt',2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',800.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3235,7986,40759,8016,2,2984,'App\\Models\\Receipt',2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',800.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3236,7986,40759,8016,2,2985,'App\\Models\\Receipt',2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1050.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3237,7986,40759,8016,2,2986,'App\\Models\\Receipt',2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1000.01,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3238,7986,40759,8016,2,2987,'App\\Models\\Receipt',2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',2300.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3239,7986,40759,8016,2,2988,'App\\Models\\Receipt',2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',650.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3240,7986,40759,8016,2,2989,'App\\Models\\Receipt',2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1280.01,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL);
INSERT INTO `balance_libro` VALUES (3241,7986,40759,8016,2,2990,'App\\Models\\Receipt',2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',800.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3242,7986,40759,8016,2,2991,'App\\Models\\Receipt',2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',400.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3243,7986,40759,8016,2,2992,'App\\Models\\Receipt',2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1000.01,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3244,7986,40759,8016,2,2993,'App\\Models\\Receipt',2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',3200.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3245,7986,40759,8016,2,2994,'App\\Models\\Receipt',2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1200.01,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3246,7986,40759,8016,2,2995,'App\\Models\\Receipt',2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',600.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3247,7986,40759,8016,2,2996,'App\\Models\\Receipt',2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1800.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3248,7986,40759,8016,2,2997,'App\\Models\\Receipt',2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',650.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3249,7986,40759,8016,2,2998,'App\\Models\\Receipt',2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',800.00,NULL,NULL,1,'2023-04-12 12:16:35','2023-04-12 12:16:35',NULL),(3250,7986,40759,8016,2,2999,'App\\Models\\Receipt',2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',400.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3251,7986,40759,8016,2,3000,'App\\Models\\Receipt',3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1000.01,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3252,7986,40759,8016,2,3001,'App\\Models\\Receipt',3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',800.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3253,7986,40759,8016,2,3002,'App\\Models\\Receipt',3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1300.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3254,7986,40759,8016,2,3003,'App\\Models\\Receipt',3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',500.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3255,7986,40759,8016,2,3004,'App\\Models\\Receipt',3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1200.01,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3256,7986,40759,8016,2,3005,'App\\Models\\Receipt',3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1800.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3257,7986,40759,8016,2,3006,'App\\Models\\Receipt',3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',2400.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3258,7986,40759,8016,2,3007,'App\\Models\\Receipt',3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1500.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3259,7986,40759,8016,2,3008,'App\\Models\\Receipt',3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',600.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3260,7986,40759,8016,2,3009,'App\\Models\\Receipt',3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',650.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3261,7986,40759,8016,2,3010,'App\\Models\\Receipt',3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1800.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL);
INSERT INTO `balance_libro` VALUES (3262,7986,40759,8016,2,3011,'App\\Models\\Receipt',3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1000.01,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3263,7986,40759,8016,2,3012,'App\\Models\\Receipt',3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',9000.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3264,7986,40759,8016,2,3013,'App\\Models\\Receipt',3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',1800.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3265,7986,40759,8016,2,3014,'App\\Models\\Receipt',3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',650.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3266,7986,40759,8016,2,3015,'App\\Models\\Receipt',3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',650.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3267,7986,40759,8016,2,3016,'App\\Models\\Receipt',3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1200.01,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3268,7986,40759,8016,2,3017,'App\\Models\\Receipt',3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1650.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3269,7986,40759,8016,2,3018,'App\\Models\\Receipt',3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',3200.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3270,7986,40759,8016,2,3019,'App\\Models\\Receipt',3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1959.99,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3271,7986,40759,8016,2,3020,'App\\Models\\Receipt',3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',2400.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3272,7986,40759,8016,2,3021,'App\\Models\\Receipt',3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',750.01,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3273,7986,40759,8016,2,3022,'App\\Models\\Receipt',3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',700.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3274,7986,40759,8016,2,3023,'App\\Models\\Receipt',3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',2119.99,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3275,7986,40759,8016,2,3024,'App\\Models\\Receipt',3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',3000.00,NULL,NULL,1,'2023-04-12 12:16:36','2023-04-12 12:16:36',NULL),(3276,7986,40759,8016,2,3025,'App\\Models\\Receipt',3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1200.01,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3277,7986,40759,8016,2,3026,'App\\Models\\Receipt',3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1400.01,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3278,7986,40759,8016,2,3027,'App\\Models\\Receipt',3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',800.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3279,7986,40759,8016,2,3028,'App\\Models\\Receipt',3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',800.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3280,7986,40759,8016,2,3029,'App\\Models\\Receipt',3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',4800.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3281,7986,40759,8016,2,3030,'App\\Models\\Receipt',3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1080.01,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3282,7986,40759,8016,2,3031,'App\\Models\\Receipt',3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1800.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL);
INSERT INTO `balance_libro` VALUES (3283,7986,40759,8016,2,3032,'App\\Models\\Receipt',3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',2160.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3284,7986,40759,8016,2,3033,'App\\Models\\Receipt',3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1200.01,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3285,7986,40759,8016,2,3034,'App\\Models\\Receipt',3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',3360.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3286,7986,40759,8016,2,3035,'App\\Models\\Receipt',3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1980.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3287,7986,40759,8016,2,3036,'App\\Models\\Receipt',3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',1000.01,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3288,7986,40759,8016,2,3037,'App\\Models\\Receipt',3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1800.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3289,7986,40759,8016,2,3038,'App\\Models\\Receipt',3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',800.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3290,7986,40759,8016,2,3039,'App\\Models\\Receipt',3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1300.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3291,7986,40759,8016,2,3040,'App\\Models\\Receipt',3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',650.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3292,7986,40759,8016,2,3041,'App\\Models\\Receipt',3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',800.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3293,7986,40759,8016,2,3042,'App\\Models\\Receipt',3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1800.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3294,7986,40759,8016,2,3043,'App\\Models\\Receipt',3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',1800.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3295,7986,40759,8016,2,3044,'App\\Models\\Receipt',3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',800.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3296,7986,40759,8016,2,3045,'App\\Models\\Receipt',3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1880.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3297,7986,40759,8016,2,3046,'App\\Models\\Receipt',3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1800.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3298,7986,40759,8016,2,3047,'App\\Models\\Receipt',3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1000.01,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3299,7986,40759,8016,2,3048,'App\\Models\\Receipt',3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1800.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3300,7986,40759,8016,2,3049,'App\\Models\\Receipt',3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1959.99,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3301,7986,40759,8016,2,3050,'App\\Models\\Receipt',3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',800.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3302,7986,40759,8016,2,3051,'App\\Models\\Receipt',3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1700.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3303,7986,40759,8016,2,3052,'App\\Models\\Receipt',3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',999.99,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL);
INSERT INTO `balance_libro` VALUES (3304,7986,40759,8016,2,3053,'App\\Models\\Receipt',3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',2600.00,NULL,NULL,1,'2023-04-12 12:16:37','2023-04-12 12:16:37',NULL),(3305,7986,40759,8016,2,3054,'App\\Models\\Receipt',3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1300.00,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3306,7986,40759,8016,2,3055,'App\\Models\\Receipt',3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1000.01,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3307,7986,40759,8016,2,3056,'App\\Models\\Receipt',3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',650.00,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3308,7986,40759,8016,2,3057,'App\\Models\\Receipt',3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1200.01,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3309,7986,40759,8016,2,3058,'App\\Models\\Receipt',3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',2319.99,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3310,7986,40759,8016,2,3059,'App\\Models\\Receipt',3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',3600.00,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3311,7986,40759,8016,2,3060,'App\\Models\\Receipt',3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1000.01,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3312,7986,40759,8016,2,3061,'App\\Models\\Receipt',3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',2450.00,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3313,7986,40759,8016,2,3062,'App\\Models\\Receipt',3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',3399.99,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3314,7986,40759,8016,2,3063,'App\\Models\\Receipt',3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1240.01,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3315,7986,40759,8016,2,3064,'App\\Models\\Receipt',3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1600.00,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3316,7986,40759,8016,2,3065,'App\\Models\\Receipt',3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',900.00,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3317,7986,40759,8016,2,3066,'App\\Models\\Receipt',3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1100.00,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3318,7986,40759,8016,2,3067,'App\\Models\\Receipt',3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',650.00,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3319,7986,40759,8016,2,3068,'App\\Models\\Receipt',3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',1500.00,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3320,7986,40759,8016,2,3069,'App\\Models\\Receipt',3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1500.00,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3321,7986,40759,8016,2,3070,'App\\Models\\Receipt',3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1200.01,NULL,NULL,1,'2023-04-12 12:16:38','2023-04-12 12:16:38',NULL),(3322,7986,40759,8016,2,3071,'App\\Models\\Receipt',3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',650.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3323,7986,40759,8016,2,3072,'App\\Models\\Receipt',3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1800.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3324,7986,40759,8016,2,3073,'App\\Models\\Receipt',3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1600.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL);
INSERT INTO `balance_libro` VALUES (3325,7986,40759,8016,2,3074,'App\\Models\\Receipt',3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',3000.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3326,7986,40759,8016,2,3075,'App\\Models\\Receipt',3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1000.01,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3327,7986,40759,8016,2,3076,'App\\Models\\Receipt',3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1800.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3328,7986,40759,8016,2,3077,'App\\Models\\Receipt',3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1700.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3329,7986,40759,8016,2,3078,'App\\Models\\Receipt',3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1500.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3330,7986,40759,8016,2,3079,'App\\Models\\Receipt',3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',650.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3331,7986,40759,8016,2,3080,'App\\Models\\Receipt',3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1400.01,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3332,7986,40759,8016,2,3081,'App\\Models\\Receipt',3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1100.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3333,7986,40759,8016,2,3082,'App\\Models\\Receipt',3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',3200.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3334,7986,40759,8016,2,3083,'App\\Models\\Receipt',3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2880.01,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3335,7986,40759,8016,2,3084,'App\\Models\\Receipt',3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',3520.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3336,7986,40759,8016,2,3085,'App\\Models\\Receipt',3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',800.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3337,7986,40759,8016,2,3086,'App\\Models\\Receipt',3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1200.01,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3338,7986,40759,8016,2,3087,'App\\Models\\Receipt',3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1800.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3339,7986,40759,8016,2,3088,'App\\Models\\Receipt',3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2800.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3340,7986,40759,8016,2,3089,'App\\Models\\Receipt',3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2800.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3341,7986,40759,8016,2,3090,'App\\Models\\Receipt',3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1880.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3342,7986,40759,8016,2,3091,'App\\Models\\Receipt',3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1200.01,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3343,7986,40759,8016,2,3092,'App\\Models\\Receipt',3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',2000.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3344,7986,40759,8016,2,3093,'App\\Models\\Receipt',3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',1800.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL),(3345,7986,40759,8016,2,3094,'App\\Models\\Receipt',3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',4880.00,NULL,NULL,1,'2023-04-12 12:16:39','2023-04-12 12:16:39',NULL);
INSERT INTO `balance_libro` VALUES (3346,7986,40759,8016,2,3095,'App\\Models\\Receipt',3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1000.01,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3347,7986,40759,8016,2,3096,'App\\Models\\Receipt',3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1500.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3348,7986,40759,8016,2,3097,'App\\Models\\Receipt',3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1800.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3349,7986,40759,8016,2,3098,'App\\Models\\Receipt',3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1800.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3350,7986,40759,8016,2,3099,'App\\Models\\Receipt',3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1800.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3351,7986,40759,8016,2,3100,'App\\Models\\Receipt',3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',2400.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3352,7986,40759,8016,2,3101,'App\\Models\\Receipt',3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1800.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3353,7986,40759,8016,2,3102,'App\\Models\\Receipt',3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',4700.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3354,7986,40759,8016,2,3103,'App\\Models\\Receipt',3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',3200.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3355,7986,40759,8016,2,3104,'App\\Models\\Receipt',3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1500.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3356,7986,40759,8016,2,3105,'App\\Models\\Receipt',3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',2300.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3357,7986,40759,8016,2,3106,'App\\Models\\Receipt',3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1800.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3358,7986,40759,8016,2,3107,'App\\Models\\Receipt',3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1000.01,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3359,7986,40759,8016,2,3108,'App\\Models\\Receipt',3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1959.99,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3360,7986,40759,8016,2,3109,'App\\Models\\Receipt',3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1000.01,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3361,7986,40759,8016,2,3110,'App\\Models\\Receipt',3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1800.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3362,7986,40759,8016,2,3111,'App\\Models\\Receipt',3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1800.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3363,7986,40759,8016,2,3112,'App\\Models\\Receipt',3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1000.01,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3364,7986,40759,8016,2,3113,'App\\Models\\Receipt',3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',400.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3365,7986,40759,8016,2,3114,'App\\Models\\Receipt',3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1800.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3366,7986,40759,8016,2,3115,'App\\Models\\Receipt',3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1000.01,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL);
INSERT INTO `balance_libro` VALUES (3367,7986,40759,8016,2,3116,'App\\Models\\Receipt',3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',2250.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3368,7986,40759,8016,2,3117,'App\\Models\\Receipt',3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1800.00,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3369,7986,40759,8016,2,3118,'App\\Models\\Receipt',3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1199.99,NULL,NULL,1,'2023-04-12 12:16:40','2023-04-12 12:16:40',NULL),(3370,7986,40759,8016,2,3119,'App\\Models\\Receipt',3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',2400.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3371,7986,40759,8016,2,3120,'App\\Models\\Receipt',3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',780.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3372,7986,40759,8016,2,3121,'App\\Models\\Receipt',3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',800.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3373,7986,40759,8016,2,3122,'App\\Models\\Receipt',3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1800.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3374,7986,40759,8016,2,3123,'App\\Models\\Receipt',3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',800.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3375,7986,40759,8016,2,3124,'App\\Models\\Receipt',3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',400.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3376,7986,40759,8016,2,3125,'App\\Models\\Receipt',3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',2099.99,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3377,7986,40759,8016,2,3126,'App\\Models\\Receipt',3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',1700.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3378,7986,40759,8016,2,3127,'App\\Models\\Receipt',3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',2400.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3379,7986,40759,8016,2,3128,'App\\Models\\Receipt',3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',1000.01,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3380,7986,40759,8016,2,3129,'App\\Models\\Receipt',3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',1700.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3381,7986,40759,8016,2,3130,'App\\Models\\Receipt',3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',1160.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3382,7986,40759,8016,2,3131,'App\\Models\\Receipt',3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',1000.01,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3383,7986,40759,8016,2,3132,'App\\Models\\Receipt',3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1000.01,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3384,7986,40759,8016,2,3133,'App\\Models\\Receipt',3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1800.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3385,7986,40759,8016,2,3134,'App\\Models\\Receipt',3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1000.01,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3386,7986,40759,8016,2,3135,'App\\Models\\Receipt',3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',700.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3387,7986,40759,8016,2,3136,'App\\Models\\Receipt',3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',800.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL);
INSERT INTO `balance_libro` VALUES (3388,7986,40759,8016,2,3137,'App\\Models\\Receipt',3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',600.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3389,7986,40759,8016,2,3138,'App\\Models\\Receipt',3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',800.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3390,7986,40759,8016,2,3139,'App\\Models\\Receipt',3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1800.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3391,7986,40759,8016,2,3140,'App\\Models\\Receipt',3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1800.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3392,7986,40759,8016,2,3141,'App\\Models\\Receipt',3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1800.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3393,7986,40759,8016,2,3142,'App\\Models\\Receipt',3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1199.99,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3394,7986,40759,8016,2,3143,'App\\Models\\Receipt',3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1000.01,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3395,7986,40759,8016,2,3144,'App\\Models\\Receipt',3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',3200.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3396,7986,40759,8016,2,3145,'App\\Models\\Receipt',3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1800.00,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3397,7986,40759,8016,2,3146,'App\\Models\\Receipt',3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1000.01,NULL,NULL,1,'2023-04-12 12:16:41','2023-04-12 12:16:41',NULL),(3398,7986,40759,8016,2,3147,'App\\Models\\Receipt',3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',999.99,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3399,7986,40759,8016,2,3148,'App\\Models\\Receipt',3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',900.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3400,7986,40759,8016,2,3149,'App\\Models\\Receipt',3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1800.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3401,7986,40759,8016,2,3150,'App\\Models\\Receipt',3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',1100.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3402,7986,40759,8016,2,3151,'App\\Models\\Receipt',3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',650.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3403,7986,40759,8016,2,3152,'App\\Models\\Receipt',3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1800.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3404,7986,40759,8016,2,3153,'App\\Models\\Receipt',3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',600.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3405,7986,40759,8016,2,3154,'App\\Models\\Receipt',3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1500.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3406,7986,40759,8016,2,3155,'App\\Models\\Receipt',3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',800.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3407,7986,40759,8016,2,3156,'App\\Models\\Receipt',3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1300.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3408,7986,40759,8016,2,3157,'App\\Models\\Receipt',3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1150.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL);
INSERT INTO `balance_libro` VALUES (3409,7986,40759,8016,2,3158,'App\\Models\\Receipt',3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1800.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3410,7986,40759,8016,2,3159,'App\\Models\\Receipt',3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1150.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3411,7986,40759,8016,2,3160,'App\\Models\\Receipt',3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1800.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3412,7986,40759,8016,2,3161,'App\\Models\\Receipt',3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1800.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3413,7986,40759,8016,2,3162,'App\\Models\\Receipt',3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',1200.01,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3414,7986,40759,8016,2,3163,'App\\Models\\Receipt',3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1800.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3415,7986,40759,8016,2,3164,'App\\Models\\Receipt',3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1000.01,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3416,7986,40759,8016,2,3165,'App\\Models\\Receipt',3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1800.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3417,7986,40759,8016,2,3166,'App\\Models\\Receipt',3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1800.00,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3418,7986,40759,8016,2,3167,'App\\Models\\Receipt',3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1000.01,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3419,7986,40759,8016,2,3168,'App\\Models\\Receipt',3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1200.01,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3420,7986,40759,8016,2,3169,'App\\Models\\Receipt',3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',2000.01,NULL,NULL,1,'2023-04-12 12:16:42','2023-04-12 12:16:42',NULL),(3421,7986,40759,8016,2,3170,'App\\Models\\Receipt',3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',3200.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3422,7986,40759,8016,2,3171,'App\\Models\\Receipt',3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1800.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3423,7986,40759,8016,2,3172,'App\\Models\\Receipt',3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',1800.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3424,7986,40759,8016,2,3173,'App\\Models\\Receipt',3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',730.01,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3425,7986,40759,8016,2,3174,'App\\Models\\Receipt',3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',2600.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3426,7986,40759,8016,2,3175,'App\\Models\\Receipt',3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1300.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3427,7986,40759,8016,2,3176,'App\\Models\\Receipt',3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1000.01,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3428,7986,40759,8016,2,3177,'App\\Models\\Receipt',3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1000.01,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3429,7986,40759,8016,2,3178,'App\\Models\\Receipt',3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',650.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL);
INSERT INTO `balance_libro` VALUES (3430,7986,40759,8016,2,3179,'App\\Models\\Receipt',3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',500.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3431,7986,40759,8016,2,3180,'App\\Models\\Receipt',3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1000.01,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3432,7986,40759,8016,2,3181,'App\\Models\\Receipt',3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1000.01,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3433,7986,40759,8016,2,3182,'App\\Models\\Receipt',3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',900.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3434,7986,40759,8016,2,3183,'App\\Models\\Receipt',3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1800.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3435,7986,40759,8016,2,3184,'App\\Models\\Receipt',3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',650.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3436,7986,40759,8016,2,3185,'App\\Models\\Receipt',3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1500.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3437,7986,40759,8016,2,3186,'App\\Models\\Receipt',3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1500.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3438,7986,40759,8016,2,3187,'App\\Models\\Receipt',3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1000.01,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3439,7986,40759,8016,2,3188,'App\\Models\\Receipt',3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',900.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3440,7986,40759,8016,2,3189,'App\\Models\\Receipt',3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1600.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3441,7986,40759,8016,2,3190,'App\\Models\\Receipt',3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1800.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3442,7986,40759,8016,2,3191,'App\\Models\\Receipt',3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1350.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3443,7986,40759,8016,2,3192,'App\\Models\\Receipt',3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1800.00,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3444,7986,40759,8016,2,3193,'App\\Models\\Receipt',3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',1210.01,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3445,7986,40759,8016,2,3194,'App\\Models\\Receipt',3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1000.01,NULL,NULL,1,'2023-04-12 12:16:43','2023-04-12 12:16:43',NULL),(3446,7986,40759,8016,2,3195,'App\\Models\\Receipt',3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1600.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3447,7986,40759,8016,2,3196,'App\\Models\\Receipt',3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1000.01,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3448,7986,40759,8016,2,3197,'App\\Models\\Receipt',3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1800.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3449,7986,40759,8016,2,3198,'App\\Models\\Receipt',3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',2100.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3450,7986,40759,8016,2,3199,'App\\Models\\Receipt',3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1000.01,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL);
INSERT INTO `balance_libro` VALUES (3451,7986,40759,8016,2,3200,'App\\Models\\Receipt',3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1000.01,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3452,7986,40759,8016,2,3201,'App\\Models\\Receipt',3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1049.99,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3453,7986,40759,8016,2,3202,'App\\Models\\Receipt',3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',2700.01,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3454,7986,40759,8016,2,3203,'App\\Models\\Receipt',3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1800.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3455,7986,40759,8016,2,3204,'App\\Models\\Receipt',3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1800.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3456,7986,40759,8016,2,3205,'App\\Models\\Receipt',3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',700.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3457,7986,40759,8016,2,3206,'App\\Models\\Receipt',3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1800.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3458,7986,40759,8016,2,3207,'App\\Models\\Receipt',3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',3200.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3459,7986,40759,8016,2,3208,'App\\Models\\Receipt',3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',2100.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3460,7986,40759,8016,2,3209,'App\\Models\\Receipt',3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',650.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3461,7986,40759,8016,2,3210,'App\\Models\\Receipt',3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',2200.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3462,7986,40759,8016,2,3211,'App\\Models\\Receipt',3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',3400.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3463,7986,40759,8016,2,3212,'App\\Models\\Receipt',3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1800.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3464,7986,40759,8016,2,3213,'App\\Models\\Receipt',3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1800.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3465,7986,40759,8016,2,3214,'App\\Models\\Receipt',3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',3200.00,NULL,NULL,1,'2023-04-12 12:16:44','2023-04-12 12:16:44',NULL),(3466,7986,40759,8016,2,3215,'App\\Models\\Receipt',3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1000.01,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3467,7986,40759,8016,2,3216,'App\\Models\\Receipt',3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',2040.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3468,7986,40759,8016,2,3217,'App\\Models\\Receipt',3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',700.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3469,7986,40759,8016,2,3218,'App\\Models\\Receipt',3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1899.99,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3470,7986,40759,8016,2,3219,'App\\Models\\Receipt',3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',2760.01,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3471,7986,40759,8016,2,3220,'App\\Models\\Receipt',3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1800.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL);
INSERT INTO `balance_libro` VALUES (3472,7986,40759,8016,2,3221,'App\\Models\\Receipt',3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',999.99,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3473,7986,40759,8016,2,3222,'App\\Models\\Receipt',3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',1000.01,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3474,7986,40759,8016,2,3223,'App\\Models\\Receipt',3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',800.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3475,7986,40759,8016,2,3224,'App\\Models\\Receipt',3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1700.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3476,7986,40759,8016,2,3225,'App\\Models\\Receipt',3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',650.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3477,7986,40759,8016,2,3226,'App\\Models\\Receipt',3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1800.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3478,7986,40759,8016,2,3227,'App\\Models\\Receipt',3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1600.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3479,7986,40759,8016,2,3228,'App\\Models\\Receipt',3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1800.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3480,7986,40759,8016,2,3229,'App\\Models\\Receipt',3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1800.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3481,7986,40759,8016,2,3230,'App\\Models\\Receipt',3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1800.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3482,7986,40759,8016,2,3231,'App\\Models\\Receipt',3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1000.01,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3483,7986,40759,8016,2,3232,'App\\Models\\Receipt',3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1800.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3484,7986,40759,8016,2,3233,'App\\Models\\Receipt',3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1800.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3485,7986,40759,8016,2,3234,'App\\Models\\Receipt',3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1800.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3486,7986,40759,8016,2,3235,'App\\Models\\Receipt',3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1699.99,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3487,7986,40759,8016,2,3236,'App\\Models\\Receipt',3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1880.00,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3488,7986,40759,8016,2,3237,'App\\Models\\Receipt',3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1200.01,NULL,NULL,1,'2023-04-12 12:16:45','2023-04-12 12:16:45',NULL),(3489,7986,40759,8016,2,3238,'App\\Models\\Receipt',3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1700.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3490,7986,40759,8016,2,3239,'App\\Models\\Receipt',3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1649.99,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3491,7986,40759,8016,2,3240,'App\\Models\\Receipt',3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1600.01,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3492,7986,40759,8016,2,3241,'App\\Models\\Receipt',3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',850.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL);
INSERT INTO `balance_libro` VALUES (3493,7986,40759,8016,2,3242,'App\\Models\\Receipt',3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',800.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3494,7986,40759,8016,2,3243,'App\\Models\\Receipt',3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1800.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3495,7986,40759,8016,2,3244,'App\\Models\\Receipt',3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1000.01,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3496,7986,40759,8016,2,3245,'App\\Models\\Receipt',3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',1000.01,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3497,7986,40759,8016,2,3246,'App\\Models\\Receipt',3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-19','2023-03-19',400.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3498,7986,40759,8016,2,3247,'App\\Models\\Receipt',3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1800.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3499,7986,40759,8016,2,3248,'App\\Models\\Receipt',3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1200.01,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3500,7986,40759,8016,2,3249,'App\\Models\\Receipt',3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1500.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3501,7986,40759,8016,2,3250,'App\\Models\\Receipt',3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',1800.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3502,7986,40759,8016,2,3251,'App\\Models\\Receipt',3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',400.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3503,7986,40759,8016,2,3252,'App\\Models\\Receipt',3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1200.01,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3504,7986,40759,8016,2,3253,'App\\Models\\Receipt',3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1100.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3505,7986,40759,8016,2,3254,'App\\Models\\Receipt',3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1450.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3506,7986,40759,8016,2,3255,'App\\Models\\Receipt',3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',400.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3507,7986,40759,8016,2,3256,'App\\Models\\Receipt',3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',500.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3508,7986,40759,8016,2,3257,'App\\Models\\Receipt',3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',400.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3509,7986,40759,8016,2,3258,'App\\Models\\Receipt',3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',2450.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3510,7986,40759,8016,2,3259,'App\\Models\\Receipt',3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',749.99,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3511,7986,40759,8016,2,3260,'App\\Models\\Receipt',3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1800.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3512,7986,40759,8016,2,3261,'App\\Models\\Receipt',3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',2400.00,NULL,NULL,1,'2023-04-12 12:16:46','2023-04-12 12:16:46',NULL),(3513,7986,40759,8016,2,3262,'App\\Models\\Receipt',3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',1880.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL);
INSERT INTO `balance_libro` VALUES (3514,7986,40759,8016,2,3263,'App\\Models\\Receipt',3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1800.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3515,7986,40759,8016,2,3264,'App\\Models\\Receipt',3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',800.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3516,7986,40759,8016,2,3265,'App\\Models\\Receipt',3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1000.01,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3517,7986,40759,8016,2,3266,'App\\Models\\Receipt',3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',1000.01,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3518,7986,40759,8016,2,3267,'App\\Models\\Receipt',3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',1959.99,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3519,7986,40759,8016,2,3268,'App\\Models\\Receipt',3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',3440.01,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3520,7986,40759,8016,2,3269,'App\\Models\\Receipt',3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1049.99,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3521,7986,40759,8016,2,3270,'App\\Models\\Receipt',3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1050.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3522,7986,40759,8016,2,3271,'App\\Models\\Receipt',3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',4900.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3523,7986,40759,8016,2,3272,'App\\Models\\Receipt',3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1100.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3524,7986,40759,8016,2,3273,'App\\Models\\Receipt',3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1800.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3525,7986,40759,8016,2,3274,'App\\Models\\Receipt',3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1000.01,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3526,7986,40759,8016,2,3275,'App\\Models\\Receipt',3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',2250.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3527,7986,40759,8016,2,3276,'App\\Models\\Receipt',3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',800.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3528,7986,40759,8016,2,3277,'App\\Models\\Receipt',3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1800.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3529,7986,40759,8016,2,3278,'App\\Models\\Receipt',3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1800.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3530,7986,40759,8016,2,3279,'App\\Models\\Receipt',3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1800.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3531,7986,40759,8016,2,3280,'App\\Models\\Receipt',3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',800.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3532,7986,40759,8016,2,3281,'App\\Models\\Receipt',3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',2800.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3533,7986,40759,8016,2,3282,'App\\Models\\Receipt',3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',2000.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3534,7986,40759,8016,2,3283,'App\\Models\\Receipt',3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1000.01,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL);
INSERT INTO `balance_libro` VALUES (3535,7986,40759,8016,2,3284,'App\\Models\\Receipt',3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',799.99,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3536,7986,40759,8016,2,3285,'App\\Models\\Receipt',3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1800.00,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3537,7986,40759,8016,2,3286,'App\\Models\\Receipt',3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',2880.01,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3538,7986,40759,8016,2,3287,'App\\Models\\Receipt',3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1280.01,NULL,NULL,1,'2023-04-12 12:16:47','2023-04-12 12:16:47',NULL),(3539,7986,40759,8016,2,3288,'App\\Models\\Receipt',3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1959.99,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3540,7986,40759,8016,2,3289,'App\\Models\\Receipt',3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',700.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3541,7986,40759,8016,2,3290,'App\\Models\\Receipt',3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1000.01,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3542,7986,40759,8016,2,3291,'App\\Models\\Receipt',3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',900.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3543,7986,40759,8016,2,3292,'App\\Models\\Receipt',3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',1300.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3544,7986,40759,8016,2,3293,'App\\Models\\Receipt',3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',3200.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3545,7986,40759,8016,2,3294,'App\\Models\\Receipt',3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',2800.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3546,7986,40759,8016,2,3295,'App\\Models\\Receipt',3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',800.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3547,7986,40759,8016,2,3296,'App\\Models\\Receipt',3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1600.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3548,7986,40759,8016,2,3297,'App\\Models\\Receipt',3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',3200.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3549,7986,40759,8016,2,3298,'App\\Models\\Receipt',3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1800.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3550,7986,40759,8016,2,3299,'App\\Models\\Receipt',3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1800.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3551,7986,40759,8016,2,3300,'App\\Models\\Receipt',3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1300.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3552,7986,40759,8016,2,3301,'App\\Models\\Receipt',3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1000.01,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3553,7986,40759,8016,2,3302,'App\\Models\\Receipt',3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',2000.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3554,7986,40759,8016,2,3303,'App\\Models\\Receipt',3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1800.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3555,7986,40759,8016,2,3304,'App\\Models\\Receipt',3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1000.01,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL);
INSERT INTO `balance_libro` VALUES (3556,7986,40759,8016,2,3305,'App\\Models\\Receipt',3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1800.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3557,7986,40759,8016,2,3306,'App\\Models\\Receipt',3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',3000.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3558,7986,40759,8016,2,3307,'App\\Models\\Receipt',3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',3200.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3559,7986,40759,8016,2,3308,'App\\Models\\Receipt',3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1800.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3560,7986,40759,8016,2,3309,'App\\Models\\Receipt',3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1500.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3561,7986,40759,8016,2,3310,'App\\Models\\Receipt',3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',700.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3562,7986,40759,8016,2,3311,'App\\Models\\Receipt',3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',5000.00,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3563,7986,40759,8016,2,3312,'App\\Models\\Receipt',3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1000.01,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3564,7986,40759,8016,2,3313,'App\\Models\\Receipt',3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1000.01,NULL,NULL,1,'2023-04-12 12:16:48','2023-04-12 12:16:48',NULL),(3565,7986,40759,8016,2,3314,'App\\Models\\Receipt',3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1520.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3566,7986,40759,8016,2,3315,'App\\Models\\Receipt',3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1900.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3567,7986,40759,8016,2,3316,'App\\Models\\Receipt',3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',800.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3568,7986,40759,8016,2,3317,'App\\Models\\Receipt',3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1000.01,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3569,7986,40759,8016,2,3318,'App\\Models\\Receipt',3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',1600.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3570,7986,40759,8016,2,3319,'App\\Models\\Receipt',3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',2200.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3571,7986,40759,8016,2,3320,'App\\Models\\Receipt',3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',650.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3572,7986,40759,8016,2,3321,'App\\Models\\Receipt',3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',530.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3573,7986,40759,8016,2,3322,'App\\Models\\Receipt',3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',900.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3574,7986,40759,8016,2,3323,'App\\Models\\Receipt',3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',2000.01,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3575,7986,40759,8016,2,3324,'App\\Models\\Receipt',3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',600.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3576,7986,40759,8016,2,3325,'App\\Models\\Receipt',3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',500.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL);
INSERT INTO `balance_libro` VALUES (3577,7986,40759,8016,2,3326,'App\\Models\\Receipt',3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',2160.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3578,7986,40759,8016,2,3327,'App\\Models\\Receipt',3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',1800.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3579,7986,40759,8016,2,3328,'App\\Models\\Receipt',3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',1200.01,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3580,7986,40759,8016,2,3329,'App\\Models\\Receipt',3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',700.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3581,7986,40759,8016,2,3330,'App\\Models\\Receipt',3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',900.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3582,7986,40759,8016,2,3331,'App\\Models\\Receipt',3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',1000.01,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3583,7986,40759,8016,2,3332,'App\\Models\\Receipt',3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',3200.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3584,7986,40759,8016,2,3333,'App\\Models\\Receipt',3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',3780.00,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3585,7986,40759,8016,2,3334,'App\\Models\\Receipt',3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',2880.01,NULL,NULL,1,'2023-04-12 12:16:49','2023-04-12 12:16:49',NULL),(3586,7986,40759,8016,2,3335,'App\\Models\\Receipt',3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',2200.00,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3587,7986,40759,8016,2,3336,'App\\Models\\Receipt',3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',1800.00,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3588,7986,40759,8016,2,3337,'App\\Models\\Receipt',3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',3280.01,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3589,7986,40759,8016,2,3338,'App\\Models\\Receipt',3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',1800.00,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3590,7986,40759,8016,2,3339,'App\\Models\\Receipt',3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',1800.00,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3591,7986,40759,8016,2,3340,'App\\Models\\Receipt',3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',1500.00,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3592,7986,40759,8016,2,3341,'App\\Models\\Receipt',3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',1800.00,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3593,7986,40759,8016,2,3342,'App\\Models\\Receipt',3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',650.00,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3594,7986,40759,8016,2,3343,'App\\Models\\Receipt',3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',1500.00,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3595,7986,40759,8016,2,3344,'App\\Models\\Receipt',3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',1880.00,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3596,7986,40759,8016,2,3345,'App\\Models\\Receipt',3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',700.00,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3597,7986,40759,8016,2,3346,'App\\Models\\Receipt',3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',2499.99,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL);
INSERT INTO `balance_libro` VALUES (3598,7986,40759,8016,2,3347,'App\\Models\\Receipt',3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',1699.99,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3599,7986,40759,8016,2,3348,'App\\Models\\Receipt',3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',2900.01,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3600,7986,40759,8016,2,3349,'App\\Models\\Receipt',3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',1600.00,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3601,7986,40759,8016,2,3350,'App\\Models\\Receipt',3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-26','2023-03-26',900.00,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3602,7986,40759,8016,2,3351,'App\\Models\\Receipt',3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1880.00,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3603,7986,40759,8016,2,3352,'App\\Models\\Receipt',3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1730.01,NULL,NULL,1,'2023-04-12 12:16:50','2023-04-12 12:16:50',NULL),(3604,7986,40759,8016,2,3353,'App\\Models\\Receipt',3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1880.00,NULL,NULL,1,'2023-04-12 12:16:51','2023-04-12 12:16:51',NULL),(3605,7986,40759,8016,2,3354,'App\\Models\\Receipt',3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',900.00,NULL,NULL,1,'2023-04-12 12:16:51','2023-04-12 12:16:51',NULL),(3606,7986,40759,8016,2,3355,'App\\Models\\Receipt',3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1000.01,NULL,NULL,1,'2023-04-12 12:16:51','2023-04-12 12:16:51',NULL),(3607,7986,40759,8016,2,3356,'App\\Models\\Receipt',3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1000.01,NULL,NULL,1,'2023-04-12 12:16:51','2023-04-12 12:16:51',NULL),(3608,7986,40759,8016,2,3357,'App\\Models\\Receipt',3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',1500.00,NULL,NULL,1,'2023-04-12 12:16:51','2023-04-12 12:16:51',NULL),(3609,7986,40759,8016,2,3358,'App\\Models\\Receipt',3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1100.00,NULL,NULL,1,'2023-04-12 12:16:51','2023-04-12 12:16:51',NULL),(3610,7986,40759,8016,2,3359,'App\\Models\\Receipt',3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',400.00,NULL,NULL,1,'2023-04-12 12:16:51','2023-04-12 12:16:51',NULL),(3611,7986,40759,8016,2,3360,'App\\Models\\Receipt',3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1000.01,NULL,NULL,1,'2023-04-12 12:16:51','2023-04-12 12:16:51',NULL),(3612,7986,40759,8016,2,3361,'App\\Models\\Receipt',3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',999.99,NULL,NULL,1,'2023-04-12 12:16:51','2023-04-12 12:16:51',NULL),(3613,7986,40759,8016,2,3362,'App\\Models\\Receipt',3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',700.00,NULL,NULL,1,'2023-04-12 12:16:51','2023-04-12 12:16:51',NULL),(3614,7986,40759,8016,2,3363,'App\\Models\\Receipt',3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1000.01,NULL,NULL,1,'2023-04-12 12:16:51','2023-04-12 12:16:51',NULL),(3615,7986,40759,8016,2,3364,'App\\Models\\Receipt',3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1000.01,NULL,NULL,1,'2023-04-12 12:16:52','2023-04-12 12:16:52',NULL),(3616,7986,40759,8016,2,3365,'App\\Models\\Receipt',3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1200.01,NULL,NULL,1,'2023-04-12 12:16:52','2023-04-12 12:16:52',NULL),(3617,7986,40759,8016,2,3366,'App\\Models\\Receipt',3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1260.01,NULL,NULL,1,'2023-04-12 12:16:52','2023-04-12 12:16:52',NULL),(3618,7986,40759,8016,2,3367,'App\\Models\\Receipt',3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',900.01,NULL,NULL,1,'2023-04-12 12:16:52','2023-04-12 12:16:52',NULL);
INSERT INTO `balance_libro` VALUES (3619,7986,40759,8016,2,3368,'App\\Models\\Receipt',3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',1000.01,NULL,NULL,1,'2023-04-12 12:16:52','2023-04-12 12:16:52',NULL),(3620,7986,40759,8016,2,3369,'App\\Models\\Receipt',3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',999.99,NULL,NULL,1,'2023-04-12 12:16:52','2023-04-12 12:16:52',NULL),(3621,7986,40759,8016,2,3370,'App\\Models\\Receipt',3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1960.01,NULL,NULL,1,'2023-04-12 12:16:52','2023-04-12 12:16:52',NULL),(3622,7986,40759,8016,2,3371,'App\\Models\\Receipt',3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1950.00,NULL,NULL,1,'2023-04-12 12:16:52','2023-04-12 12:16:52',NULL),(3623,7986,40759,8016,2,3372,'App\\Models\\Receipt',3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1450.00,NULL,NULL,1,'2023-04-12 12:16:52','2023-04-12 12:16:52',NULL),(3624,7986,40759,8016,2,3373,'App\\Models\\Receipt',3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',1500.00,NULL,NULL,1,'2023-04-12 12:16:52','2023-04-12 12:16:52',NULL),(3625,7986,40759,8016,2,3374,'App\\Models\\Receipt',3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',1300.00,NULL,NULL,1,'2023-04-12 12:16:52','2023-04-12 12:16:52',NULL),(3626,7986,40759,8016,2,3375,'App\\Models\\Receipt',3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',450.00,NULL,NULL,1,'2023-04-12 12:16:52','2023-04-12 12:16:52',NULL),(3627,7986,40759,8016,2,3376,'App\\Models\\Receipt',3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',700.00,NULL,NULL,1,'2023-04-12 12:16:52','2023-04-12 12:16:52',NULL),(3628,7986,40759,8016,2,3377,'App\\Models\\Receipt',3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1800.00,NULL,NULL,1,'2023-04-12 12:16:53','2023-04-12 12:16:53',NULL),(3629,7986,40759,8016,2,3378,'App\\Models\\Receipt',3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2000.00,NULL,NULL,1,'2023-04-12 12:16:53','2023-04-12 12:16:53',NULL),(3630,7986,40759,8016,2,3379,'App\\Models\\Receipt',3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',950.00,NULL,NULL,1,'2023-04-12 12:16:53','2023-04-12 12:16:53',NULL),(3631,7986,40759,8016,2,3380,'App\\Models\\Receipt',3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',900.00,NULL,NULL,1,'2023-04-12 12:16:53','2023-04-12 12:16:53',NULL),(3632,7986,40759,8016,2,3381,'App\\Models\\Receipt',3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1100.00,NULL,NULL,1,'2023-04-12 12:16:53','2023-04-12 12:16:53',NULL),(3633,7986,40759,8016,2,3382,'App\\Models\\Receipt',3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',2800.00,NULL,NULL,1,'2023-04-12 12:16:53','2023-04-12 12:16:53',NULL),(3634,7986,40759,8016,2,3383,'App\\Models\\Receipt',3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',800.00,NULL,NULL,1,'2023-04-12 12:16:53','2023-04-12 12:16:53',NULL),(3635,7986,40759,8016,2,3384,'App\\Models\\Receipt',3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1600.00,NULL,NULL,1,'2023-04-12 12:16:53','2023-04-12 12:16:53',NULL),(3636,7986,40759,8016,2,3385,'App\\Models\\Receipt',3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1950.00,NULL,NULL,1,'2023-04-12 12:16:53','2023-04-12 12:16:53',NULL),(3637,7986,40759,8016,2,3386,'App\\Models\\Receipt',3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1000.01,NULL,NULL,1,'2023-04-12 12:16:54','2023-04-12 12:16:54',NULL),(3638,7986,40776,17355,2,3387,'App\\Models\\Receipt',3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',603339.35,NULL,NULL,1,'2023-04-12 12:17:40','2023-04-12 12:17:40',NULL),(3639,7986,40759,8016,3,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',91137.01,NULL,NULL,1,'2023-04-12 12:31:32','2023-04-19 11:52:57','2023-04-19 11:52:57');
INSERT INTO `balance_libro` VALUES (3640,7986,40759,8016,3,3389,'App\\Models\\Receipt',3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',1200.00,NULL,NULL,1,'2023-04-12 12:31:32','2023-04-12 12:31:32',NULL),(3641,7986,40759,8016,3,3390,'App\\Models\\Receipt',3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',29865.51,NULL,NULL,1,'2023-04-12 12:31:32','2023-04-19 11:51:44','2023-04-19 11:51:44'),(3642,7986,40759,8016,3,3391,'App\\Models\\Receipt',3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',3595.16,NULL,NULL,1,'2023-04-12 12:31:32','2023-04-12 12:31:32',NULL),(3643,7986,40759,8016,3,3392,'App\\Models\\Receipt',3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',1128.03,NULL,NULL,1,'2023-04-12 12:31:32','2023-04-19 11:52:14','2023-04-19 11:52:14'),(3644,7986,40759,8016,3,3393,'App\\Models\\Receipt',3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',336.73,NULL,NULL,1,'2023-04-12 12:31:32','2023-04-12 12:31:32',NULL),(3645,7986,40759,8016,3,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',87095.40,NULL,NULL,1,'2023-04-12 12:31:32','2023-04-19 11:54:08','2023-04-19 11:54:08'),(3646,7986,40759,8016,3,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',127765.52,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-19 11:54:38','2023-04-19 11:54:38'),(3647,7986,40759,8016,3,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',9465.38,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-19 11:56:00','2023-04-19 11:56:00'),(3648,7986,40759,8016,3,3397,'App\\Models\\Receipt',3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',4631.87,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-12 12:31:33',NULL),(3649,7986,40759,8016,3,3398,'App\\Models\\Receipt',3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',574.74,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-12 12:31:33',NULL),(3650,7986,40759,8016,3,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',66290.44,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-19 11:57:15','2023-04-19 11:57:15'),(3651,7986,40759,8016,3,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',14136.97,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-19 11:56:49','2023-04-19 11:56:49'),(3652,7986,40759,8016,3,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',146644.51,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-19 11:57:41','2023-04-19 11:57:41'),(3653,7986,40759,8016,3,3402,'App\\Models\\Receipt',3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',0.04,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-19 11:52:27','2023-04-19 11:52:27'),(3654,7986,40759,8016,3,3403,'App\\Models\\Receipt',3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',7609.56,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-12 12:31:33',NULL),(3655,7986,40759,8016,3,3404,'App\\Models\\Receipt',3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',494.43,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-12 12:31:33',NULL),(3656,7986,40759,8016,3,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',42852.71,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-19 11:58:10','2023-04-19 11:58:10'),(3657,7986,40759,8016,3,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',133878.08,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-19 11:58:38','2023-04-19 11:58:38'),(3658,7986,40759,8016,3,3407,'App\\Models\\Receipt',3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',14097.70,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-12 12:31:33',NULL),(3659,7986,40759,8016,3,3408,'App\\Models\\Receipt',3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',4007.14,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-12 12:31:33',NULL);
INSERT INTO `balance_libro` VALUES (3660,7986,40759,8016,3,3409,'App\\Models\\Receipt',3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',386.80,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-12 12:31:33',NULL),(3661,7986,40759,8016,3,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',80875.21,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-19 11:59:33','2023-04-19 11:59:33'),(3662,7986,40759,8016,3,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',109335.26,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-19 12:00:01','2023-04-19 12:00:01'),(3663,7986,40759,8016,3,3412,'App\\Models\\Receipt',3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',150799.91,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-12 12:31:33',NULL),(3664,7986,40759,8016,3,3413,'App\\Models\\Receipt',3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',4670.00,NULL,NULL,1,'2023-04-12 12:31:33','2023-04-19 11:52:02','2023-04-19 11:52:02'),(3665,7986,40776,17355,3,3414,'App\\Models\\Receipt',3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',7248263.00,NULL,NULL,1,'2023-04-12 12:31:54','2023-04-12 12:31:54',NULL),(3666,7986,40772,14167,12,3666,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',6003522.93,NULL,NULL,1,'2023-04-13 11:34:50','2023-04-13 11:42:44','2023-04-13 11:42:44'),(3667,7986,40772,14167,12,3667,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',6003522.93,NULL,NULL,1,'2023-04-13 11:42:50','2023-04-13 11:43:11','2023-04-13 11:43:11'),(3668,7986,40772,14167,12,3668,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',6003522.93,'ASIENTO DE APERTURA',NULL,1,'2023-04-13 11:43:11','2023-04-26 17:11:52','2023-04-26 17:11:52'),(3669,7986,40772,14167,2,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',117418.00,NULL,NULL,1,'2023-04-13 12:04:02','2023-04-13 12:06:42','2023-04-13 12:06:42'),(3670,7986,40772,14167,2,3416,'App\\Models\\Receipt',3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',19759.26,NULL,NULL,1,'2023-04-13 12:04:02','2023-04-13 12:07:09','2023-04-13 12:07:09'),(3671,7986,40772,14167,2,3417,'App\\Models\\Receipt',3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',19759.26,NULL,NULL,1,'2023-04-13 12:04:02','2023-04-13 12:07:06','2023-04-13 12:07:06'),(3672,7986,40772,14167,2,3418,'App\\Models\\Receipt',3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',1250.00,NULL,NULL,1,'2023-04-13 12:04:02','2023-04-13 12:07:03','2023-04-13 12:07:03'),(3673,7986,40772,14167,2,3419,'App\\Models\\Receipt',3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',445658.19,NULL,NULL,1,'2023-04-13 12:04:02','2023-04-13 12:06:58','2023-04-13 12:06:58'),(3674,7986,40772,14167,2,3415,'App\\Models\\Receipt',3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',117418.00,NULL,NULL,1,'2023-04-13 12:06:42','2023-04-13 12:07:13','2023-04-13 12:07:13'),(3675,7986,40772,14167,2,3420,'App\\Models\\Receipt',3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',117418.00,NULL,NULL,1,'2023-04-13 12:07:45','2023-04-13 12:10:05','2023-04-13 12:10:05'),(3676,7986,40772,14167,2,3421,'App\\Models\\Receipt',3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',19759.26,NULL,NULL,1,'2023-04-13 12:07:45','2023-04-13 12:10:02','2023-04-13 12:10:02'),(3677,7986,40772,14167,2,3422,'App\\Models\\Receipt',3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',19759.26,NULL,NULL,1,'2023-04-13 12:07:46','2023-04-13 12:09:58','2023-04-13 12:09:58'),(3678,7986,40772,14167,2,3423,'App\\Models\\Receipt',3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',1250.00,NULL,NULL,1,'2023-04-13 12:07:46','2023-04-13 12:09:55','2023-04-13 12:09:55');
INSERT INTO `balance_libro` VALUES (3679,7986,40772,14167,2,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',445658.19,NULL,NULL,1,'2023-04-13 12:07:46','2023-04-13 12:09:11','2023-04-13 12:09:11'),(3680,7986,40772,14167,2,3424,'App\\Models\\Receipt',3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',445658.19,NULL,NULL,1,'2023-04-13 12:09:11','2023-04-13 12:09:51','2023-04-13 12:09:51'),(3681,7986,40772,14167,2,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',117418.00,NULL,NULL,1,'2023-04-13 12:11:13','2023-04-14 09:51:57','2023-04-14 09:51:57'),(3682,7986,40772,14167,2,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',19759.26,NULL,NULL,1,'2023-04-13 12:11:13','2023-04-14 09:51:25','2023-04-14 09:51:25'),(3683,7986,40772,14167,2,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',19759.26,NULL,NULL,1,'2023-04-13 12:11:13','2023-04-14 09:50:08','2023-04-14 09:50:08'),(3684,7986,40772,14167,2,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',1250.00,NULL,NULL,1,'2023-04-13 12:11:13','2023-04-14 09:49:15','2023-04-14 09:49:15'),(3685,7986,40772,14167,2,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',445658.19,NULL,NULL,1,'2023-04-13 12:11:13','2023-04-13 12:12:46','2023-04-13 12:12:46'),(3686,7986,40772,14167,2,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',445658.19,NULL,NULL,1,'2023-04-13 12:12:46','2023-04-13 15:39:43','2023-04-13 15:39:43'),(3687,7986,40772,14167,2,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',445658.19,NULL,NULL,1,'2023-04-13 15:39:43','2023-04-14 09:50:37','2023-04-14 09:50:37'),(3688,7986,40772,14167,2,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',1250.00,NULL,NULL,1,'2023-04-14 09:49:15','2023-04-14 09:50:51','2023-04-14 09:50:51'),(3689,7986,40772,14167,2,3427,'App\\Models\\Receipt',3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',19759.26,NULL,NULL,1,'2023-04-14 09:50:08','2023-04-14 09:52:36','2023-04-14 09:52:36'),(3690,7986,40772,14167,2,3429,'App\\Models\\Receipt',3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',445658.19,NULL,NULL,1,'2023-04-14 09:50:37','2023-04-14 09:52:30','2023-04-14 09:52:30'),(3691,7986,40772,14167,2,3428,'App\\Models\\Receipt',3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',1250.00,NULL,NULL,1,'2023-04-14 09:50:51','2023-04-14 09:52:32','2023-04-14 09:52:32'),(3692,7986,40772,14167,2,3426,'App\\Models\\Receipt',3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',19759.26,NULL,NULL,1,'2023-04-14 09:51:25','2023-04-14 09:52:39','2023-04-14 09:52:39'),(3693,7986,40772,14167,2,3425,'App\\Models\\Receipt',3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',117418.00,NULL,NULL,1,'2023-04-14 09:51:57','2023-04-14 09:52:42','2023-04-14 09:52:42'),(3694,7986,40772,14167,2,3430,'App\\Models\\Receipt',3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',117418.00,NULL,NULL,1,'2023-04-14 09:53:53','2023-04-14 09:55:11','2023-04-14 09:55:11'),(3695,7986,40772,14167,2,3431,'App\\Models\\Receipt',3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',19759.26,NULL,NULL,1,'2023-04-14 09:53:53','2023-04-14 09:55:08','2023-04-14 09:55:08'),(3696,7986,40772,14167,2,3432,'App\\Models\\Receipt',3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',19759.26,NULL,NULL,1,'2023-04-14 09:53:53','2023-04-14 09:55:00','2023-04-14 09:55:00'),(3697,7986,40772,14167,2,3433,'App\\Models\\Receipt',3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',1250.00,NULL,NULL,1,'2023-04-14 09:53:54','2023-04-14 09:54:57','2023-04-14 09:54:57');
INSERT INTO `balance_libro` VALUES (3698,7986,40772,14167,2,3434,'App\\Models\\Receipt',3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',445658.19,NULL,NULL,1,'2023-04-14 09:53:54','2023-04-14 09:54:54','2023-04-14 09:54:54'),(3699,7986,40772,14167,2,3435,'App\\Models\\Receipt',3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',117418.00,NULL,NULL,1,'2023-04-14 09:55:36','2023-04-25 08:13:03','2023-04-25 08:13:03'),(3700,7986,40772,14167,2,3436,'App\\Models\\Receipt',3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',19759.26,NULL,NULL,1,'2023-04-14 09:55:36','2023-04-25 08:12:58','2023-04-25 08:12:58'),(3701,7986,40772,14167,2,3437,'App\\Models\\Receipt',3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-03','2022-01-03',19759.26,NULL,NULL,1,'2023-04-14 09:55:36','2023-04-25 08:12:55','2023-04-25 08:12:55'),(3702,7986,40772,14167,2,3438,'App\\Models\\Receipt',3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-06','2022-01-06',1250.00,NULL,NULL,1,'2023-04-14 09:55:36','2023-04-25 08:12:52','2023-04-25 08:12:52'),(3703,7986,40772,14167,2,3439,'App\\Models\\Receipt',3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-10','2022-01-10',445658.19,NULL,NULL,1,'2023-04-14 09:55:36','2023-04-25 08:12:49','2023-04-25 08:12:49'),(3718,7986,40772,14167,1,3718,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',147341.28,NULL,NULL,1,'2023-04-19 08:48:39','2023-04-19 08:48:39',NULL),(3719,7986,40772,14168,1,3719,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',148726.94,NULL,NULL,1,'2023-04-19 08:48:39','2023-04-19 08:48:39',NULL),(3720,7986,40772,14169,1,3720,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',160841.73,NULL,NULL,1,'2023-04-19 08:48:39','2023-04-19 08:48:40',NULL),(3721,7986,40772,14170,1,3721,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',159044.78,NULL,NULL,1,'2023-04-19 08:48:40','2023-04-19 08:48:40',NULL),(3722,7986,40772,14171,1,3722,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',181269.06,NULL,NULL,1,'2023-04-19 08:48:40','2023-04-19 08:48:40',NULL),(3723,7986,40772,14172,1,3723,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',298742.45,NULL,NULL,1,'2023-04-19 08:48:40','2023-04-19 08:48:40',NULL),(3729,7986,40772,14167,2,3729,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',603844.71,NULL,NULL,1,'2023-04-19 08:57:43','2023-04-25 10:31:17','2023-04-25 10:31:17'),(3730,7986,40772,14168,2,3730,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',555355.15,NULL,NULL,1,'2023-04-19 08:57:43','2023-04-25 10:30:56','2023-04-25 10:30:56'),(3731,7986,40772,14169,2,3731,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',986630.20,NULL,NULL,1,'2023-04-19 08:57:43','2023-04-25 10:30:32','2023-04-25 10:30:32'),(3732,7986,40772,14170,2,3732,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',724388.36,NULL,NULL,1,'2023-04-19 08:57:43','2023-04-19 08:57:43',NULL),(3733,7986,40772,14171,2,3733,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',1063408.32,NULL,NULL,1,'2023-04-19 08:57:43','2023-04-19 08:57:43',NULL),(3734,7986,40772,14172,2,3734,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2674081.99,NULL,NULL,1,'2023-04-19 08:57:43','2023-04-25 10:29:47','2023-04-25 10:29:47'),(3735,7986,40772,14173,2,3735,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1555935.34,NULL,NULL,1,'2023-04-19 08:57:43','2023-04-25 10:29:29','2023-04-25 10:29:29');
INSERT INTO `balance_libro` VALUES (3736,7986,40772,14174,2,3736,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',1811834.32,NULL,NULL,1,'2023-04-19 08:57:43','2023-04-19 08:57:43',NULL),(3737,7986,40772,14175,2,3737,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2225766.84,NULL,NULL,1,'2023-04-19 08:57:43','2023-04-25 10:28:52','2023-04-25 10:28:52'),(3738,7986,40772,14176,2,3738,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1911454.10,NULL,NULL,1,'2023-04-19 08:57:43','2023-04-25 10:28:34','2023-04-25 10:28:34'),(3739,7986,40772,11014,2,3739,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2576479.97,NULL,NULL,1,'2023-04-19 08:57:43','2023-04-25 10:28:13','2023-04-25 10:28:13'),(3740,7986,40772,11015,2,3740,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3442406.06,NULL,NULL,1,'2023-04-19 08:57:44','2023-04-25 10:27:46','2023-04-25 10:27:46'),(3741,7986,40772,14173,1,3741,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',201133.52,NULL,NULL,1,'2023-04-19 09:00:27','2023-04-19 09:00:27',NULL),(3742,7986,40772,14174,1,3742,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',229096.92,NULL,NULL,1,'2023-04-19 09:00:27','2023-04-19 09:00:27',NULL),(3743,7986,40772,14175,1,3743,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',226762.16,NULL,NULL,1,'2023-04-19 09:00:27','2023-04-19 09:00:27',NULL),(3744,7986,40772,14176,1,3744,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',234250.90,NULL,NULL,1,'2023-04-19 09:00:27','2023-04-19 09:00:27',NULL),(3745,7986,40772,11014,1,3745,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',262975.92,NULL,NULL,1,'2023-04-19 09:00:27','2023-04-19 09:00:27',NULL),(3746,7986,40772,11015,1,3746,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',421977.90,NULL,NULL,1,'2023-04-19 09:00:27','2023-04-25 08:20:56','2023-04-25 08:20:56'),(3747,7986,40759,8016,3,3388,'App\\Models\\Receipt',3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',91137.01,NULL,NULL,1,'2023-04-19 11:52:57','2023-04-19 11:52:57',NULL),(3748,7986,40759,8016,3,3394,'App\\Models\\Receipt',3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',87095.40,NULL,NULL,1,'2023-04-19 11:54:08','2023-04-19 11:54:08',NULL),(3749,7986,40759,8016,3,3395,'App\\Models\\Receipt',3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',127765.52,NULL,NULL,1,'2023-04-19 11:54:38','2023-04-19 11:54:38',NULL),(3750,7986,40759,8016,3,3396,'App\\Models\\Receipt',3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',9465.38,NULL,NULL,1,'2023-04-19 11:56:00','2023-04-19 11:56:00',NULL),(3751,7986,40759,8016,3,3400,'App\\Models\\Receipt',3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',14136.97,NULL,NULL,1,'2023-04-19 11:56:49','2023-04-19 11:56:49',NULL),(3752,7986,40759,8016,3,3399,'App\\Models\\Receipt',3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',66290.44,NULL,NULL,1,'2023-04-19 11:57:15','2023-04-19 11:57:15',NULL),(3753,7986,40759,8016,3,3401,'App\\Models\\Receipt',3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',146644.52,NULL,NULL,1,'2023-04-19 11:57:41','2023-04-19 11:57:41',NULL),(3754,7986,40759,8016,3,3405,'App\\Models\\Receipt',3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',42852.71,NULL,NULL,1,'2023-04-19 11:58:10','2023-04-19 11:58:10',NULL),(3755,7986,40759,8016,3,3406,'App\\Models\\Receipt',3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',133878.09,NULL,NULL,1,'2023-04-19 11:58:38','2023-04-19 11:58:38',NULL);
INSERT INTO `balance_libro` VALUES (3756,7986,40759,8016,3,3410,'App\\Models\\Receipt',3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',82831.87,NULL,NULL,1,'2023-04-19 11:59:33','2023-04-19 11:59:33',NULL),(3757,7986,40759,8016,3,3411,'App\\Models\\Receipt',3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',109335.26,NULL,NULL,1,'2023-04-19 12:00:01','2023-04-19 12:00:01',NULL),(3758,7986,40759,8016,3,3440,'App\\Models\\Receipt',3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',9283.60,NULL,NULL,1,'2023-04-19 12:06:42','2023-04-19 12:06:42',NULL),(3759,7986,40759,8016,8,3441,'App\\Models\\Receipt',3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',936.26,NULL,NULL,1,'2023-04-19 12:07:08','2023-04-19 12:07:08',NULL),(3760,7986,40759,8015,15,984,'App\\Models\\PeriodLiquidation',NULL,984,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',438667.39,NULL,NULL,1,'2023-04-19 12:19:12','2023-04-19 12:19:12',NULL),(3761,7986,40759,8016,15,1069,'App\\Models\\PeriodLiquidation',NULL,1069,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',458349.24,NULL,NULL,1,'2023-04-20 09:03:36','2023-04-20 09:03:36',NULL),(3762,7986,40759,8016,16,1070,'App\\Models\\PeriodLiquidation',NULL,1070,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',20855.46,NULL,NULL,1,'2023-04-20 09:19:44','2023-04-20 09:19:44',NULL),(3763,7986,40720,1520,3,3442,'App\\Models\\Receipt',3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',14000.57,NULL,NULL,1,'2023-04-20 09:25:51','2023-04-20 09:25:51',NULL),(3764,7986,40720,1520,3,3443,'App\\Models\\Receipt',3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',19350.00,NULL,NULL,1,'2023-04-20 09:27:18','2023-04-20 09:27:18',NULL),(3765,7986,40776,17355,3,3444,'App\\Models\\Receipt',3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',152580.00,NULL,NULL,1,'2023-04-20 11:05:19','2023-04-20 11:05:19',NULL),(3766,7986,40776,17355,3,3445,'App\\Models\\Receipt',3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-10','2023-02-10',20520.00,NULL,NULL,1,'2023-04-20 11:06:40','2023-04-20 11:06:40',NULL),(3767,7986,40776,17355,3,3446,'App\\Models\\Receipt',3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-12','2023-03-12',9002.29,NULL,NULL,1,'2023-04-20 11:07:51','2023-04-20 11:07:51',NULL),(3768,7986,40776,17355,3,3447,'App\\Models\\Receipt',3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',40005.80,NULL,NULL,1,'2023-04-20 11:08:43','2023-04-20 11:08:43',NULL),(3769,7986,40776,17355,3,3448,'App\\Models\\Receipt',3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',4999.99,NULL,NULL,1,'2023-04-20 11:09:44','2023-04-20 11:09:44',NULL),(3770,7986,40776,17355,3,3449,'App\\Models\\Receipt',3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',12424.55,NULL,NULL,1,'2023-04-20 11:12:17','2023-04-20 11:12:17',NULL),(3771,7986,40776,17355,3,3450,'App\\Models\\Receipt',3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',8764.84,NULL,NULL,1,'2023-04-20 11:13:25','2023-04-20 11:13:25',NULL),(3772,7986,40776,17355,3,3451,'App\\Models\\Receipt',3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',637.28,NULL,NULL,1,'2023-04-20 11:14:05','2023-04-20 11:14:05',NULL),(3773,7986,40776,17354,15,988,'App\\Models\\PeriodLiquidation',NULL,988,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',383048.42,NULL,NULL,1,'2023-04-20 11:14:47','2023-04-20 11:14:47',NULL),(3774,7986,40720,1520,15,1073,'App\\Models\\PeriodLiquidation',NULL,1073,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',234032.79,NULL,NULL,1,'2023-04-20 11:24:53','2023-04-20 11:24:53',NULL),(3775,7986,40720,1520,16,1074,'App\\Models\\PeriodLiquidation',NULL,1074,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',0.00,NULL,NULL,1,'2023-04-20 11:30:57','2023-04-20 11:30:57',NULL);
INSERT INTO `balance_libro` VALUES (3776,7986,40776,17355,15,1082,'App\\Models\\PeriodLiquidation',NULL,1082,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',1586359.09,NULL,NULL,1,'2023-04-20 11:39:01','2023-04-20 11:39:01',NULL),(3777,7986,40721,3020,3,3452,'App\\Models\\Receipt',3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-01','2023-03-01',25811.11,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:35:39',NULL),(3778,7986,40721,3020,3,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',8947.73,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:45:22','2023-04-21 10:45:22'),(3779,7986,40721,3020,3,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',18098.65,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:44:22','2023-04-21 10:44:22'),(3780,7986,40721,3020,3,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',21774.10,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:46:38','2023-04-21 10:46:38'),(3781,7986,40721,3020,3,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',54940.09,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:44:49','2023-04-21 10:44:49'),(3782,7986,40721,3020,3,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',17170.85,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:46:06','2023-04-21 10:46:06'),(3783,7986,40721,3020,3,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3133.43,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:49:25','2023-04-21 10:49:25'),(3784,7986,40721,3020,3,3459,'App\\Models\\Receipt',3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',4111.25,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:35:39',NULL),(3785,7986,40721,3020,3,3460,'App\\Models\\Receipt',3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',23213.45,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:35:39',NULL),(3786,7986,40721,3020,3,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',12132.50,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:47:49','2023-04-21 10:47:49'),(3787,7986,40721,3020,3,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7848.08,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:51:56','2023-04-21 10:51:56'),(3788,7986,40721,3020,3,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',91065.50,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:52:43','2023-04-21 10:52:43'),(3789,7986,40721,3020,3,3464,'App\\Models\\Receipt',3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',6350.06,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:35:39',NULL),(3790,7986,40721,3020,3,3465,'App\\Models\\Receipt',3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-05','2023-03-05',4701.15,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:35:39',NULL),(3791,7986,40721,3020,3,3466,'App\\Models\\Receipt',3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',36414.47,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:35:39',NULL),(3792,7986,40721,3020,3,3467,'App\\Models\\Receipt',3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',20593.18,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:35:39',NULL),(3793,7986,40721,3020,3,3468,'App\\Models\\Receipt',3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',653.45,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:35:39',NULL),(3794,7986,40721,3020,3,3469,'App\\Models\\Receipt',3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',10868.56,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:35:39',NULL),(3795,7986,40721,3020,3,3470,'App\\Models\\Receipt',3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-06','2023-03-06',56877.85,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:35:39',NULL);
INSERT INTO `balance_libro` VALUES (3796,7986,40721,3020,3,3471,'App\\Models\\Receipt',3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',49768.35,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:35:39',NULL),(3797,7986,40721,3020,3,3472,'App\\Models\\Receipt',3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',3817.92,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:35:39',NULL),(3798,7986,40721,3020,3,3473,'App\\Models\\Receipt',3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',22729.77,NULL,NULL,1,'2023-04-21 10:35:39','2023-04-21 10:35:39',NULL),(3799,7986,40721,3020,3,3474,'App\\Models\\Receipt',3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-07','2023-03-07',34906.73,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3800,7986,40721,3020,3,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',20304.32,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:56:25','2023-04-21 10:56:25'),(3801,7986,40721,3020,3,3476,'App\\Models\\Receipt',3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',26474.79,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3802,7986,40721,3020,3,3477,'App\\Models\\Receipt',3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',13102.61,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3803,7986,40721,3020,3,3478,'App\\Models\\Receipt',3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',8561.95,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3804,7986,40721,3020,3,3479,'App\\Models\\Receipt',3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',17287.06,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3805,7986,40721,3020,3,3480,'App\\Models\\Receipt',3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',9946.62,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3806,7986,40721,3020,3,3481,'App\\Models\\Receipt',3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',4412.56,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3807,7986,40721,3020,3,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',443641.02,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:57:30','2023-04-21 10:57:30'),(3808,7986,40721,3020,3,3483,'App\\Models\\Receipt',3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',30394.00,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3809,7986,40721,3020,3,3484,'App\\Models\\Receipt',3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',19898.46,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3810,7986,40721,3020,3,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',3727.11,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 11:04:09','2023-04-21 11:04:09'),(3811,7986,40721,3020,3,3486,'App\\Models\\Receipt',3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',37285.00,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3812,7986,40721,3020,3,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',17600.61,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:58:20','2023-04-21 10:58:20'),(3813,7986,40721,3020,3,3488,'App\\Models\\Receipt',3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',27664.00,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3814,7986,40721,3020,3,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',6185.44,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:59:04','2023-04-21 10:59:04'),(3815,7986,40721,3020,3,3490,'App\\Models\\Receipt',3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',34211.53,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL);
INSERT INTO `balance_libro` VALUES (3816,7986,40721,3020,3,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',10796.53,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 11:29:15','2023-04-21 11:29:15'),(3817,7986,40721,3020,3,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',13565.14,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 11:29:52','2023-04-21 11:29:52'),(3818,7986,40721,3020,3,3493,'App\\Models\\Receipt',3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',0.00,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3819,7986,40721,3020,3,3494,'App\\Models\\Receipt',3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',183.11,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3820,7986,40721,3020,3,3495,'App\\Models\\Receipt',3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',5985.96,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3821,7986,40721,3020,3,3496,'App\\Models\\Receipt',3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',47956.45,NULL,NULL,1,'2023-04-21 10:35:40','2023-04-21 10:35:40',NULL),(3822,7986,40721,3020,3,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',31603.04,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 11:31:09','2023-04-21 11:31:09'),(3823,7986,40721,3020,3,3498,'App\\Models\\Receipt',3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14','2023-03-14',183.11,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 10:35:41',NULL),(3824,7986,40721,3020,3,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',14083.62,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 11:34:52','2023-04-21 11:34:52'),(3825,7986,40721,3020,3,3500,'App\\Models\\Receipt',3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',29923.82,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 10:35:41',NULL),(3826,7986,40721,3020,3,3501,'App\\Models\\Receipt',3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',11085.65,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 10:35:41',NULL),(3827,7986,40721,3020,3,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',50483.55,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 11:33:44','2023-04-21 11:33:44'),(3828,7986,40721,3020,3,3503,'App\\Models\\Receipt',3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',200502.25,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 10:35:41',NULL),(3829,7986,40721,3020,3,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',75031.32,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 11:36:31','2023-04-21 11:36:31'),(3830,7986,40721,3020,3,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',21421.54,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 11:35:31','2023-04-21 11:35:31'),(3831,7986,40721,3020,3,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',38990.00,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-25 09:51:11','2023-04-25 09:51:11'),(3832,7986,40721,3020,3,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8363.09,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 11:37:02','2023-04-21 11:37:02'),(3833,7986,40721,3020,3,3508,'App\\Models\\Receipt',3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',39257.71,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 10:35:41',NULL),(3834,7986,40721,3020,3,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',30876.50,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 11:37:32','2023-04-21 11:37:32'),(3835,7986,40721,3020,3,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',26551.27,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 11:38:35','2023-04-21 11:38:35');
INSERT INTO `balance_libro` VALUES (3836,7986,40721,3020,3,3511,'App\\Models\\Receipt',3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',4394.68,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 10:35:41',NULL),(3837,7986,40721,3020,3,3512,'App\\Models\\Receipt',3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',22125.16,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 10:35:41',NULL),(3838,7986,40721,3020,3,3513,'App\\Models\\Receipt',3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',21260.43,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 10:35:41',NULL),(3839,7986,40721,3020,3,3514,'App\\Models\\Receipt',3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',27369.69,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 10:35:41',NULL),(3840,7986,40721,3020,3,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',82290.09,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 11:39:36','2023-04-21 11:39:36'),(3841,7986,40721,3020,3,3516,'App\\Models\\Receipt',3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',35199.42,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 10:35:41',NULL),(3842,7986,40721,3020,3,3517,'App\\Models\\Receipt',3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',5000.00,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 10:35:41',NULL),(3843,7986,40721,3020,3,3518,'App\\Models\\Receipt',3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',636.55,NULL,NULL,1,'2023-04-21 10:35:41','2023-04-21 10:35:41',NULL),(3844,7986,40721,3020,3,3519,'App\\Models\\Receipt',3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',85535.26,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 10:35:42',NULL),(3845,7986,40721,3020,3,3520,'App\\Models\\Receipt',3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-21','2023-03-21',24776.80,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 10:35:42',NULL),(3846,7986,40721,3020,3,3521,'App\\Models\\Receipt',3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-22','2023-03-22',11973.92,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 10:35:42',NULL),(3847,7986,40721,3020,3,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',27870.00,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-25 09:52:29','2023-04-25 09:52:29'),(3848,7986,40721,3020,3,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',6695.54,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 11:40:45','2023-04-21 11:40:45'),(3849,7986,40721,3020,3,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',16801.28,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 11:41:24','2023-04-21 11:41:24'),(3850,7986,40721,3020,3,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',62990.40,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 11:42:12','2023-04-21 11:42:12'),(3851,7986,40721,3020,3,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',39517.87,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 11:42:50','2023-04-21 11:42:50'),(3852,7986,40721,3020,3,3527,'App\\Models\\Receipt',3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',16402.60,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 10:35:42',NULL),(3853,7986,40721,3020,3,3528,'App\\Models\\Receipt',3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',14742.00,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 10:35:42',NULL),(3854,7986,40721,3020,3,3529,'App\\Models\\Receipt',3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',32513.85,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 10:35:42',NULL),(3855,7986,40721,3020,3,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',12320.75,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 11:46:34','2023-04-21 11:46:34');
INSERT INTO `balance_libro` VALUES (3856,7986,40721,3020,3,3531,'App\\Models\\Receipt',3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',5500.03,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 10:35:42',NULL),(3857,7986,40721,3020,3,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',23200.88,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 11:47:06','2023-04-21 11:47:06'),(3858,7986,40721,3020,3,3533,'App\\Models\\Receipt',3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',6200.01,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 10:35:42',NULL),(3859,7986,40721,3020,3,3534,'App\\Models\\Receipt',3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-28','2023-03-28',19413.23,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 10:35:42',NULL),(3860,7986,40721,3020,3,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',23008.68,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 11:48:21','2023-04-21 11:48:21'),(3861,7986,40721,3020,3,3536,'App\\Models\\Receipt',3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',40562.48,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 10:35:42',NULL),(3862,7986,40721,3020,3,3537,'App\\Models\\Receipt',3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',3642.82,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 10:35:42',NULL),(3863,7986,40721,3020,3,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',55716.65,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 11:49:32','2023-04-21 11:49:32'),(3864,7986,40721,3020,3,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',27735.51,NULL,NULL,1,'2023-04-21 10:35:42','2023-04-21 11:51:29','2023-04-21 11:51:29'),(3865,7986,40721,3020,3,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',33917.85,NULL,NULL,1,'2023-04-21 10:35:43','2023-04-21 11:52:48','2023-04-21 11:52:48'),(3866,7986,40721,3020,3,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',22528.27,NULL,NULL,1,'2023-04-21 10:35:43','2023-04-21 11:53:41','2023-04-21 11:53:41'),(3867,7986,40721,3020,3,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',8755.80,NULL,NULL,1,'2023-04-21 10:35:43','2023-04-21 11:52:17','2023-04-21 11:52:17'),(3868,7986,40721,3020,3,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',36621.63,NULL,NULL,1,'2023-04-21 10:35:43','2023-04-21 11:53:14','2023-04-21 11:53:14'),(3869,7986,40721,3020,3,3544,'App\\Models\\Receipt',3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6695.54,NULL,NULL,1,'2023-04-21 10:35:43','2023-04-21 10:35:43',NULL),(3870,7986,40721,3020,3,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',36450.00,NULL,NULL,1,'2023-04-21 10:35:43','2023-04-25 09:53:30','2023-04-25 09:53:30'),(3871,7986,40721,3020,3,3546,'App\\Models\\Receipt',3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',23087.57,NULL,NULL,1,'2023-04-21 10:35:43','2023-04-21 10:35:43',NULL),(3872,7986,40721,3020,3,3547,'App\\Models\\Receipt',3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',9561.64,NULL,NULL,1,'2023-04-21 10:35:43','2023-04-21 10:35:43',NULL),(3873,7986,40721,3020,3,3548,'App\\Models\\Receipt',3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',6897.58,NULL,NULL,1,'2023-04-21 10:35:43','2023-04-21 10:35:43',NULL),(3874,7986,40721,3020,3,3549,'App\\Models\\Receipt',3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',39602.59,NULL,NULL,1,'2023-04-21 10:37:54','2023-04-21 10:37:54',NULL),(3875,7986,40721,3020,3,3454,'App\\Models\\Receipt',3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',18098.65,NULL,NULL,1,'2023-04-21 10:44:22','2023-04-21 10:44:22',NULL);
INSERT INTO `balance_libro` VALUES (3876,7986,40721,3020,3,3456,'App\\Models\\Receipt',3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',54940.09,NULL,NULL,1,'2023-04-21 10:44:49','2023-04-21 10:44:49',NULL),(3877,7986,40721,3020,3,3453,'App\\Models\\Receipt',3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',8947.73,NULL,NULL,1,'2023-04-21 10:45:22','2023-04-21 10:45:22',NULL),(3878,7986,40721,3020,3,3457,'App\\Models\\Receipt',3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',17170.85,NULL,NULL,1,'2023-04-21 10:46:06','2023-04-21 10:46:06',NULL),(3879,7986,40721,3020,3,3455,'App\\Models\\Receipt',3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-02','2023-03-02',21774.10,NULL,NULL,1,'2023-04-21 10:46:38','2023-04-21 10:46:38',NULL),(3880,7986,40721,3020,3,3461,'App\\Models\\Receipt',3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',12132.50,NULL,NULL,1,'2023-04-21 10:47:49','2023-04-21 10:47:49',NULL),(3881,7986,40721,3020,3,3458,'App\\Models\\Receipt',3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-03','2023-03-03',3133.43,NULL,NULL,1,'2023-04-21 10:49:25','2023-04-21 10:49:25',NULL),(3882,7986,40721,3020,3,3462,'App\\Models\\Receipt',3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',7848.08,NULL,NULL,1,'2023-04-21 10:51:56','2023-04-21 10:51:56',NULL),(3883,7986,40721,3020,3,3463,'App\\Models\\Receipt',3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-04','2023-03-04',91065.50,NULL,NULL,1,'2023-04-21 10:52:43','2023-04-21 10:52:43',NULL),(3884,7986,40721,3020,3,3475,'App\\Models\\Receipt',3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-08','2023-03-08',20304.32,NULL,NULL,1,'2023-04-21 10:56:25','2023-04-21 10:56:25',NULL),(3885,7986,40721,3020,3,3482,'App\\Models\\Receipt',3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-09','2023-03-09',443641.03,NULL,NULL,1,'2023-04-21 10:57:30','2023-04-21 10:57:30',NULL),(3886,7986,40721,3020,3,3487,'App\\Models\\Receipt',3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',17600.61,NULL,NULL,1,'2023-04-21 10:58:20','2023-04-21 10:58:20',NULL),(3887,7986,40721,3020,3,3489,'App\\Models\\Receipt',3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',6185.44,NULL,NULL,1,'2023-04-21 10:59:04','2023-04-21 10:59:04',NULL),(3888,7986,40721,3020,3,3485,'App\\Models\\Receipt',3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-10','2023-03-10',3727.11,NULL,NULL,1,'2023-04-21 11:04:09','2023-04-21 11:04:09',NULL),(3889,7986,40721,3020,3,3491,'App\\Models\\Receipt',3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',10796.53,NULL,NULL,1,'2023-04-21 11:29:15','2023-04-21 11:29:15',NULL),(3890,7986,40721,3020,3,3492,'App\\Models\\Receipt',3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-11','2023-03-11',13565.14,NULL,NULL,1,'2023-04-21 11:29:52','2023-04-21 11:29:52',NULL),(3891,7986,40721,3020,3,3497,'App\\Models\\Receipt',3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13','2023-03-13',31603.04,NULL,NULL,1,'2023-04-21 11:31:09','2023-04-21 11:31:09',NULL),(3892,7986,40721,3020,3,3502,'App\\Models\\Receipt',3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',50483.55,NULL,NULL,1,'2023-04-21 11:33:44','2023-04-21 11:33:44',NULL),(3893,7986,40721,3020,3,3499,'App\\Models\\Receipt',3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15','2023-03-15',14083.62,NULL,NULL,1,'2023-04-21 11:34:52','2023-04-21 11:34:52',NULL),(3894,7986,40721,3020,3,3505,'App\\Models\\Receipt',3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',21421.54,NULL,NULL,1,'2023-04-21 11:35:31','2023-04-21 11:35:31',NULL),(3895,7986,40721,3020,3,3504,'App\\Models\\Receipt',3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16','2023-03-16',75031.31,NULL,NULL,1,'2023-04-21 11:36:31','2023-04-21 11:36:31',NULL),(3896,7986,40721,3020,3,3507,'App\\Models\\Receipt',3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',8363.10,NULL,NULL,1,'2023-04-21 11:37:02','2023-04-21 11:37:02',NULL);
INSERT INTO `balance_libro` VALUES (3897,7986,40721,3020,3,3509,'App\\Models\\Receipt',3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',30876.50,NULL,NULL,1,'2023-04-21 11:37:32','2023-04-21 11:37:32',NULL),(3898,7986,40721,3020,3,3510,'App\\Models\\Receipt',3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-18','2023-03-18',26551.27,NULL,NULL,1,'2023-04-21 11:38:35','2023-04-21 11:38:35',NULL),(3899,7986,40721,3020,3,3515,'App\\Models\\Receipt',3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-20','2023-03-20',82290.09,NULL,NULL,1,'2023-04-21 11:39:36','2023-04-21 11:39:36',NULL),(3900,7986,40721,3020,3,3523,'App\\Models\\Receipt',3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',6695.54,NULL,NULL,1,'2023-04-21 11:40:45','2023-04-21 11:40:45',NULL),(3901,7986,40721,3020,3,3524,'App\\Models\\Receipt',3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-24','2023-03-24',16801.28,NULL,NULL,1,'2023-04-21 11:41:24','2023-04-21 11:41:24',NULL),(3902,7986,40721,3020,3,3525,'App\\Models\\Receipt',3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',62990.40,NULL,NULL,1,'2023-04-21 11:42:12','2023-04-21 11:42:12',NULL),(3903,7986,40721,3020,3,3526,'App\\Models\\Receipt',3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-25','2023-03-25',39517.87,NULL,NULL,1,'2023-04-21 11:42:50','2023-04-21 11:42:50',NULL),(3904,7986,40721,3020,3,3530,'App\\Models\\Receipt',3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',12320.75,NULL,NULL,1,'2023-04-21 11:46:34','2023-04-21 11:46:34',NULL),(3905,7986,40721,3020,3,3532,'App\\Models\\Receipt',3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-27','2023-03-27',23200.88,NULL,NULL,1,'2023-04-21 11:47:06','2023-04-21 11:47:06',NULL),(3906,7986,40721,3020,3,3535,'App\\Models\\Receipt',3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',23008.67,NULL,NULL,1,'2023-04-21 11:48:21','2023-04-21 11:48:21',NULL),(3907,7986,40721,3020,3,3538,'App\\Models\\Receipt',3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',55716.65,NULL,NULL,1,'2023-04-21 11:49:32','2023-04-21 11:49:32',NULL),(3908,7986,40721,3020,3,3539,'App\\Models\\Receipt',3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29','2023-03-29',27735.51,NULL,NULL,1,'2023-04-21 11:51:29','2023-04-21 11:51:29',NULL),(3909,7986,40721,3020,3,3542,'App\\Models\\Receipt',3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',8755.80,NULL,NULL,1,'2023-04-21 11:52:17','2023-04-21 11:52:17',NULL),(3910,7986,40721,3020,3,3540,'App\\Models\\Receipt',3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',33917.85,NULL,NULL,1,'2023-04-21 11:52:48','2023-04-21 11:52:48',NULL),(3911,7986,40721,3020,3,3543,'App\\Models\\Receipt',3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',36621.63,NULL,NULL,1,'2023-04-21 11:53:14','2023-04-21 11:53:14',NULL),(3912,7986,40721,3020,3,3541,'App\\Models\\Receipt',3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30','2023-03-30',22528.27,NULL,NULL,1,'2023-04-21 11:53:41','2023-04-21 11:53:41',NULL),(3913,7986,40721,3020,3,3550,'App\\Models\\Receipt',3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-30','2023-01-30',61758.05,NULL,NULL,1,'2023-04-21 11:59:22','2023-04-21 11:59:22',NULL),(3914,7986,40721,3020,3,3551,'App\\Models\\Receipt',3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',44390.00,NULL,NULL,1,'2023-04-21 12:00:09','2023-04-21 12:00:09',NULL),(3915,7986,40721,3020,3,3552,'App\\Models\\Receipt',3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-01-31','2023-01-31',79640.00,NULL,NULL,1,'2023-04-21 12:00:36','2023-04-21 12:00:36',NULL),(3916,7986,40721,3020,3,3553,'App\\Models\\Receipt',3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-02-28','2023-02-28',22158.44,NULL,NULL,1,'2023-04-21 12:03:03','2023-04-21 12:03:03',NULL),(3917,7986,40721,3020,3,3554,'App\\Models\\Receipt',3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',39594.37,NULL,NULL,1,'2023-04-21 12:47:08','2023-04-21 12:47:08',NULL);
INSERT INTO `balance_libro` VALUES (3918,7986,40772,11015,1,3918,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',421977.90,NULL,NULL,1,'2023-04-25 08:20:56','2023-04-25 08:20:56',NULL),(3919,7986,40721,3020,3,3506,'App\\Models\\Receipt',3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-17','2023-03-17',38989.98,NULL,NULL,1,'2023-04-25 09:51:11','2023-04-25 09:51:11',NULL),(3920,7986,40721,3020,3,3522,'App\\Models\\Receipt',3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23','2023-03-23',27869.98,NULL,NULL,1,'2023-04-25 09:52:29','2023-04-25 09:52:29',NULL),(3921,7986,40721,3020,3,3545,'App\\Models\\Receipt',3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-31','2023-03-31',36449.99,NULL,NULL,1,'2023-04-25 09:53:30','2023-04-25 09:53:30',NULL),(3922,7986,40772,11015,2,3922,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3442406.06,NULL,NULL,1,'2023-04-25 10:27:46','2023-04-25 10:27:46',NULL),(3923,7986,40772,11014,2,3923,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',2576479.97,NULL,NULL,1,'2023-04-25 10:28:13','2023-04-25 10:28:13',NULL),(3924,7986,40772,14176,2,3924,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',1911454.10,NULL,NULL,1,'2023-04-25 10:28:34','2023-04-25 10:28:34',NULL),(3925,7986,40772,14175,2,3925,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2225766.84,NULL,NULL,1,'2023-04-25 10:28:52','2023-04-25 10:28:52',NULL),(3926,7986,40772,14173,2,3926,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',1555935.34,NULL,NULL,1,'2023-04-25 10:29:29','2023-04-25 10:29:29',NULL),(3927,7986,40772,14172,2,3927,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',2674081.99,NULL,NULL,1,'2023-04-25 10:29:47','2023-04-25 10:29:47',NULL),(3928,7986,40772,14169,2,3928,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',986630.20,NULL,NULL,1,'2023-04-25 10:30:32','2023-04-25 10:30:32',NULL),(3929,7986,40772,14168,2,3929,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',555355.15,NULL,NULL,1,'2023-04-25 10:30:56','2023-04-25 10:30:56',NULL),(3930,7986,40772,14167,2,3930,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',603844.71,NULL,NULL,1,'2023-04-25 10:31:17','2023-04-25 10:31:17',NULL),(3933,7986,40772,14167,5,3933,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2501026.12,NULL,NULL,1,'2023-04-25 17:11:43','2023-04-26 11:56:41','2023-04-26 11:56:41'),(3934,7986,40772,14168,5,3934,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1571488.53,NULL,NULL,1,'2023-04-25 17:11:44','2023-04-26 11:57:53','2023-04-26 11:57:53'),(3935,7986,40772,14169,5,3935,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2933586.76,NULL,NULL,1,'2023-04-25 17:11:45','2023-04-26 11:58:46','2023-04-26 11:58:46'),(3936,7986,40772,14170,5,3936,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2058068.64,NULL,NULL,1,'2023-04-25 18:52:01','2023-04-26 11:41:19','2023-04-26 11:41:19'),(3937,7986,40772,14171,5,3937,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3187559.36,NULL,NULL,1,'2023-04-25 18:52:02','2023-04-26 11:45:16','2023-04-26 11:45:16'),(3938,7986,40772,14172,5,3938,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3234797.61,NULL,NULL,1,'2023-04-25 18:52:02','2023-04-26 11:46:20','2023-04-26 11:46:20');
INSERT INTO `balance_libro` VALUES (3939,7986,40719,9,5,3939,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3319084.33,NULL,NULL,1,'2023-04-26 09:37:36','2023-04-26 09:41:16','2023-04-26 09:41:16'),(3940,7986,40719,10,5,3940,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3078765.57,NULL,NULL,1,'2023-04-26 09:37:37','2023-04-26 09:41:16','2023-04-26 09:41:16'),(3941,7986,40719,11,5,3941,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2318020.86,NULL,NULL,1,'2023-04-26 09:37:38','2023-04-26 09:41:16','2023-04-26 09:41:16'),(3942,7986,40719,12,5,3942,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5012315.78,NULL,NULL,1,'2023-04-26 09:37:39','2023-04-26 09:41:16','2023-04-26 09:41:16'),(3943,7986,40719,13,5,3943,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6445258.44,NULL,NULL,1,'2023-04-26 09:37:40','2023-04-26 09:41:16','2023-04-26 09:41:16'),(3944,7986,40719,14,5,3944,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4898797.17,NULL,NULL,1,'2023-04-26 09:37:41','2023-04-26 09:41:16','2023-04-26 09:41:16'),(3945,7986,40772,14173,5,3945,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3319084.33,NULL,NULL,1,'2023-04-26 09:38:57','2023-04-26 11:47:27','2023-04-26 11:47:27'),(3946,7986,40772,14174,5,3946,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3078765.57,NULL,NULL,1,'2023-04-26 09:38:58','2023-04-26 11:48:30','2023-04-26 11:48:30'),(3947,7986,40772,14175,5,3947,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2318020.86,NULL,NULL,1,'2023-04-26 09:38:59','2023-04-26 11:49:43','2023-04-26 11:49:43'),(3948,7986,40772,14176,5,3948,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5012315.78,NULL,NULL,1,'2023-04-26 09:39:00','2023-04-26 11:50:43','2023-04-26 11:50:43'),(3949,7986,40772,11014,5,3949,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6445258.44,NULL,NULL,1,'2023-04-26 09:39:00','2023-04-26 11:52:25','2023-04-26 11:52:25'),(3950,7986,40772,11015,5,3950,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4898797.17,NULL,NULL,1,'2023-04-26 09:39:02','2023-04-26 11:53:17','2023-04-26 11:53:17'),(3958,7986,40772,14167,3,3958,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',267258.03,NULL,NULL,1,'2023-04-26 09:54:32','2023-04-27 09:52:53','2023-04-27 09:52:53'),(3959,7986,40772,14168,3,3959,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',317419.45,NULL,NULL,1,'2023-04-26 09:54:33','2023-04-27 09:55:06','2023-04-27 09:55:06'),(3960,7986,40772,14169,3,3960,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',189191.61,NULL,NULL,1,'2023-04-26 09:54:33','2023-04-27 09:56:41','2023-04-27 09:56:41'),(3961,7986,40772,14170,3,3961,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',481339.73,NULL,NULL,1,'2023-04-26 09:54:33','2023-04-27 09:58:12','2023-04-27 09:58:12'),(3962,7986,40772,14171,3,3962,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',484975.12,NULL,NULL,1,'2023-04-26 09:54:33','2023-04-27 09:59:12','2023-04-27 09:59:12'),(3963,7986,40772,14172,3,3963,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',463384.63,NULL,NULL,1,'2023-04-26 09:54:33','2023-04-27 10:03:02','2023-04-27 10:03:02');
INSERT INTO `balance_libro` VALUES (3964,7986,40772,14173,3,3964,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',436690.55,NULL,NULL,1,'2023-04-26 09:54:34','2023-04-27 10:04:43','2023-04-27 10:04:43'),(3965,7986,40772,14174,3,3965,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',447235.81,NULL,NULL,1,'2023-04-26 09:54:34','2023-04-27 10:05:47','2023-04-27 10:05:47'),(3966,7986,40772,14175,3,3966,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',417109.32,NULL,NULL,1,'2023-04-26 09:54:34','2023-04-27 11:15:24','2023-04-27 11:15:24'),(3967,7986,40772,14176,3,3967,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',500189.21,NULL,NULL,1,'2023-04-26 09:54:34','2023-04-27 11:16:09','2023-04-27 11:16:09'),(3968,7986,40772,11014,3,3968,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',764394.66,NULL,NULL,1,'2023-04-26 09:54:35','2023-04-27 11:17:03','2023-04-27 11:17:03'),(3969,7986,40772,11015,3,3969,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',694182.85,NULL,NULL,1,'2023-04-26 09:54:36','2023-04-27 11:18:17','2023-04-27 11:18:17'),(3970,7986,40772,14170,10,3970,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-29','2022-04-29',220780.49,NULL,NULL,1,'2023-04-26 11:22:03','2023-04-26 11:22:03',NULL),(3971,7986,40772,14170,5,3971,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2058068.64,NULL,NULL,1,'2023-04-26 11:41:19','2023-04-27 10:03:12','2023-04-27 10:03:12'),(3972,7986,40772,14171,5,3972,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3187559.36,NULL,NULL,1,'2023-04-26 11:45:16','2023-04-27 10:04:35','2023-04-27 10:04:35'),(3973,7986,40772,14172,5,3973,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3234797.61,NULL,NULL,1,'2023-04-26 11:46:20','2023-04-26 16:13:33','2023-04-26 16:13:33'),(3974,7986,40772,14173,5,3974,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3319084.33,NULL,NULL,1,'2023-04-26 11:47:27','2023-04-27 10:07:17','2023-04-27 10:07:17'),(3975,7986,40772,14174,5,3975,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3078765.57,NULL,NULL,1,'2023-04-26 11:48:30','2023-04-27 10:08:44','2023-04-27 10:08:44'),(3976,7986,40772,14175,5,3976,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2318020.86,NULL,NULL,1,'2023-04-26 11:49:43','2023-04-27 10:10:19','2023-04-27 10:10:19'),(3977,7986,40772,14176,5,3977,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5012315.78,NULL,NULL,1,'2023-04-26 11:50:43','2023-04-27 10:12:27','2023-04-27 10:12:27'),(3978,7986,40772,11014,5,3978,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6445258.44,NULL,NULL,1,'2023-04-26 11:52:25','2023-04-27 10:20:29','2023-04-27 10:20:29'),(3979,7986,40772,11015,5,3979,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4898797.17,NULL,NULL,1,'2023-04-26 11:53:17','2023-04-27 10:21:57','2023-04-27 10:21:57'),(3980,7986,40772,14167,5,3980,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2501026.12,NULL,NULL,1,'2023-04-26 11:56:41','2023-04-27 09:58:19','2023-04-27 09:58:19'),(3981,7986,40772,14168,5,3981,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1571488.53,NULL,NULL,1,'2023-04-26 11:57:53','2023-04-26 16:17:58','2023-04-26 16:17:58');
INSERT INTO `balance_libro` VALUES (3982,7986,40772,14169,5,3982,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2933586.76,NULL,NULL,1,'2023-04-26 11:58:46','2023-04-27 10:01:47','2023-04-27 10:01:47'),(3983,7986,40772,11015,18,3983,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1494835.63,'DEVENGAMIENTO INTERESES PLAZOS FIJOS',NULL,1,'2023-04-26 16:03:21','2023-04-26 16:03:21',NULL),(3984,7986,40772,14172,5,3984,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3234797.61,NULL,NULL,1,'2023-04-26 16:13:33','2023-04-27 10:05:59','2023-04-27 10:05:59'),(3985,7986,40772,14168,5,3985,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1571488.53,NULL,NULL,1,'2023-04-26 16:17:58','2023-04-27 10:00:23','2023-04-27 10:00:23'),(3986,7986,40772,14167,12,3986,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-01','2022-01-01',6003522.93,'ASIENTO DE APERTURA',NULL,1,'2023-04-26 17:11:52','2023-04-27 15:34:27','2023-04-27 15:34:27'),(3987,7986,40772,14167,19,3987,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',3.52,NULL,NULL,1,'2023-04-26 17:38:21','2023-04-26 18:14:41','2023-04-26 18:14:41'),(3988,7986,40772,14168,19,3988,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',3.52,NULL,NULL,1,'2023-04-26 17:38:21','2023-04-26 18:14:41','2023-04-26 18:14:41'),(3989,7986,40772,14169,19,3989,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',3.52,NULL,NULL,1,'2023-04-26 17:38:21','2023-04-26 18:14:41','2023-04-26 18:14:41'),(3990,7986,40772,14170,19,3990,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',3.52,NULL,NULL,1,'2023-04-26 17:38:21','2023-04-26 18:14:41','2023-04-26 18:14:41'),(3991,7986,40772,14171,19,3991,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3.52,NULL,NULL,1,'2023-04-26 17:38:21','2023-04-26 18:14:41','2023-04-26 18:14:41'),(3992,7986,40772,14172,19,3992,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3.52,NULL,NULL,1,'2023-04-26 17:38:21','2023-04-26 18:14:41','2023-04-26 18:14:41'),(3993,7986,40772,14173,19,3993,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3.52,NULL,NULL,1,'2023-04-26 17:38:22','2023-04-26 18:14:41','2023-04-26 18:14:41'),(3994,7986,40772,14174,19,3994,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3.52,NULL,NULL,1,'2023-04-26 17:38:22','2023-04-26 18:14:41','2023-04-26 18:14:41'),(3995,7986,40772,14175,19,3995,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',3.52,NULL,NULL,1,'2023-04-26 17:38:22','2023-04-26 18:14:41','2023-04-26 18:14:41'),(3996,7986,40772,14176,19,3996,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',3.52,NULL,NULL,1,'2023-04-26 17:38:22','2023-04-26 18:14:41','2023-04-26 18:14:41'),(3997,7986,40772,11014,19,3997,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',3.52,NULL,NULL,1,'2023-04-26 17:38:22','2023-04-26 18:14:41','2023-04-26 18:14:41'),(3998,7986,40772,11015,19,3998,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3.52,NULL,NULL,1,'2023-04-26 17:38:22','2023-04-26 18:14:41','2023-04-26 18:14:41'),(3999,7986,40772,14170,19,3999,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-04','2022-04-04',2777832.31,'DISTRIBUCION DE UTILIDADES',NULL,1,'2023-04-26 17:43:33','2023-04-26 17:43:33',NULL);
INSERT INTO `balance_libro` VALUES (4003,7986,40772,14167,19,4003,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',6.84,NULL,NULL,1,'2023-04-26 18:16:21','2023-04-26 18:16:21',NULL),(4004,7986,40772,14168,19,4004,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',6.72,NULL,NULL,1,'2023-04-26 18:16:21','2023-04-26 18:16:21',NULL),(4005,7986,40772,14169,19,4005,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',6.59,NULL,NULL,1,'2023-04-26 18:16:21','2023-04-26 18:16:21',NULL),(4006,7986,40772,14170,19,4006,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',6.47,NULL,NULL,1,'2023-04-26 18:16:21','2023-04-26 18:16:21',NULL),(4007,7986,40772,14171,19,4007,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',6.34,NULL,NULL,1,'2023-04-26 18:16:21','2023-04-26 18:16:21',NULL),(4008,7986,40772,14172,19,4008,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',6.21,NULL,NULL,1,'2023-04-26 18:16:21','2023-04-26 18:16:21',NULL),(4009,7986,40772,14173,19,4009,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',6.08,NULL,NULL,1,'2023-04-26 18:16:21','2023-04-26 18:16:21',NULL),(4010,7986,40772,14174,19,4010,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',6.00,NULL,NULL,1,'2023-04-26 18:16:21','2023-04-26 18:16:21',NULL),(4011,7986,40772,14175,19,4011,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',6.00,NULL,NULL,1,'2023-04-26 18:16:21','2023-04-26 18:16:21',NULL),(4012,7986,40772,14176,19,4012,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',6.00,NULL,NULL,1,'2023-04-26 18:16:21','2023-04-26 18:16:21',NULL),(4013,7986,40772,11014,19,4013,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6.00,NULL,NULL,1,'2023-04-26 18:16:21','2023-04-26 18:16:22',NULL),(4014,7986,40772,11015,19,4014,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6.00,NULL,NULL,1,'2023-04-26 18:16:21','2023-04-26 18:16:22',NULL),(4015,7986,40772,14175,19,4015,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',370.00,'PAGO DEUDA INAES - RECLASIFICACION',NULL,1,'2023-04-26 18:23:15','2023-04-26 18:23:15',NULL),(4016,7986,40772,11015,4,4016,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',52145.67,'AMORTIZACION DEL EJERCICIO',NULL,1,'2023-04-26 19:00:28','2023-04-26 19:17:33','2023-04-26 19:17:33'),(4017,7986,40772,11015,4,4017,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',80688.37,'AMORTIZACION DEL EJERCICIO',NULL,1,'2023-04-26 19:17:33','2023-04-27 16:47:14','2023-04-27 16:47:14'),(4018,7986,40772,11015,19,4018,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3306.03,'TASA MUNICIPAL TERRENO 2022',NULL,1,'2023-04-27 09:18:32','2023-04-27 10:16:54','2023-04-27 10:16:54'),(4019,7986,40772,14167,3,4019,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',269083.03,NULL,NULL,1,'2023-04-27 09:52:53','2023-04-27 11:09:33','2023-04-27 11:09:33'),(4020,7986,40772,14168,3,4020,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',319244.45,NULL,NULL,1,'2023-04-27 09:55:06','2023-04-27 11:10:33','2023-04-27 11:10:33'),(4021,7986,40772,14169,3,4021,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',189191.61,NULL,NULL,1,'2023-04-27 09:56:41','2023-04-27 11:11:18','2023-04-27 11:11:18');
INSERT INTO `balance_libro` VALUES (4022,7986,40772,14170,3,4022,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',481339.73,NULL,NULL,1,'2023-04-27 09:58:12','2023-04-27 10:34:56','2023-04-27 10:34:56'),(4023,7986,40772,14167,5,4023,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',2501026.12,NULL,NULL,1,'2023-04-27 09:58:19','2023-04-27 09:58:19',NULL),(4024,7986,40772,14171,3,4024,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',484975.12,NULL,NULL,1,'2023-04-27 09:59:12','2023-04-27 11:12:44','2023-04-27 11:12:44'),(4025,7986,40772,14168,5,4025,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',1571488.53,NULL,NULL,1,'2023-04-27 10:00:23','2023-04-27 10:00:23',NULL),(4026,7986,40772,14169,5,4026,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',2933586.76,NULL,NULL,1,'2023-04-27 10:01:47','2023-04-27 10:01:47',NULL),(4027,7986,40772,14172,3,4027,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',465209.63,NULL,NULL,1,'2023-04-27 10:03:02','2023-04-27 11:13:30','2023-04-27 11:13:30'),(4028,7986,40772,14170,5,4028,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',2058068.64,NULL,NULL,1,'2023-04-27 10:03:12','2023-04-27 10:03:12',NULL),(4029,7986,40772,14171,5,4029,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',3187559.36,NULL,NULL,1,'2023-04-27 10:04:35','2023-04-27 10:04:35',NULL),(4030,7986,40772,14173,3,4030,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',438520.55,NULL,NULL,1,'2023-04-27 10:04:43','2023-04-27 11:14:07','2023-04-27 11:14:07'),(4031,7986,40772,14174,3,4031,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',445405.81,NULL,NULL,1,'2023-04-27 10:05:47','2023-04-27 11:14:49','2023-04-27 11:14:49'),(4032,7986,40772,14172,5,4032,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',3234797.61,NULL,NULL,1,'2023-04-27 10:05:59','2023-04-27 10:05:59',NULL),(4033,7986,40772,14173,5,4033,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',3319084.33,NULL,NULL,1,'2023-04-27 10:07:17','2023-04-27 10:07:17',NULL),(4034,7986,40772,14174,5,4034,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',3078765.57,NULL,NULL,1,'2023-04-27 10:08:44','2023-04-27 10:08:44',NULL),(4035,7986,40772,14175,5,4035,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',2318020.86,NULL,NULL,1,'2023-04-27 10:10:19','2023-04-27 10:10:19',NULL),(4036,7986,40772,14176,5,4036,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',5012315.78,NULL,NULL,1,'2023-04-27 10:12:27','2023-04-27 10:12:27',NULL),(4037,7986,40772,11015,19,4037,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',3306.03,'TASA MUNICIPAL TERRENO 2022',NULL,1,'2023-04-27 10:16:54','2023-04-27 10:16:54',NULL),(4038,7986,40772,11014,5,4038,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',6445258.44,NULL,NULL,1,'2023-04-27 10:20:29','2023-04-27 10:20:29',NULL),(4039,7986,40772,11015,5,4039,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',4898797.17,NULL,NULL,1,'2023-04-27 10:21:57','2023-04-27 10:21:57',NULL),(4040,7986,40772,14170,3,4040,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',481339.73,NULL,NULL,1,'2023-04-27 10:34:56','2023-04-27 11:11:57','2023-04-27 11:11:57');
INSERT INTO `balance_libro` VALUES (4041,7986,40772,14167,3,4041,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',509083.03,NULL,NULL,1,'2023-04-27 11:09:33','2023-04-27 11:29:42','2023-04-27 11:29:42'),(4042,7986,40772,14168,3,4042,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',559244.45,NULL,NULL,1,'2023-04-27 11:10:33','2023-04-27 11:31:36','2023-04-27 11:31:36'),(4043,7986,40772,14169,3,4043,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',429191.61,NULL,NULL,1,'2023-04-27 11:11:18','2023-04-27 11:33:02','2023-04-27 11:33:02'),(4044,7986,40772,14170,3,4044,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',521339.73,NULL,NULL,1,'2023-04-27 11:11:57','2023-04-27 11:34:23','2023-04-27 11:34:23'),(4045,7986,40772,14171,3,4045,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',724975.12,NULL,NULL,1,'2023-04-27 11:12:44','2023-04-27 11:35:37','2023-04-27 11:35:37'),(4046,7986,40772,14172,3,4046,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',705209.63,NULL,NULL,1,'2023-04-27 11:13:30','2023-04-27 11:36:54','2023-04-27 11:36:54'),(4047,7986,40772,14173,3,4047,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',860520.55,NULL,NULL,1,'2023-04-27 11:14:07','2023-04-27 11:38:04','2023-04-27 11:38:04'),(4048,7986,40772,14174,3,4048,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',767405.81,NULL,NULL,1,'2023-04-27 11:14:49','2023-04-27 11:39:47','2023-04-27 11:39:47'),(4049,7986,40772,14175,3,4049,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',739109.32,NULL,NULL,1,'2023-04-27 11:15:24','2023-04-27 11:42:39','2023-04-27 11:42:39'),(4050,7986,40772,14176,3,4050,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',822189.21,NULL,NULL,1,'2023-04-27 11:16:09','2023-04-27 11:44:59','2023-04-27 11:44:59'),(4051,7986,40772,11014,3,4051,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1086394.66,NULL,NULL,1,'2023-04-27 11:17:03','2023-04-27 11:47:35','2023-04-27 11:47:35'),(4052,7986,40772,11015,3,4052,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1166182.85,NULL,NULL,1,'2023-04-27 11:18:17','2023-04-27 11:49:30','2023-04-27 11:49:30'),(4053,7986,40772,14167,3,4053,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-31','2022-01-31',533074.03,NULL,NULL,1,'2023-04-27 11:29:42','2023-04-27 11:29:42',NULL),(4054,7986,40772,14168,3,4054,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',573447.65,NULL,NULL,1,'2023-04-27 11:31:36','2023-04-27 12:15:36','2023-04-27 12:15:36'),(4055,7986,40772,14169,3,4055,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',447209.61,NULL,NULL,1,'2023-04-27 11:33:02','2023-04-27 12:16:21','2023-04-27 12:16:21'),(4056,7986,40772,14170,3,4056,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',542289.73,NULL,NULL,1,'2023-04-27 11:34:23','2023-04-27 12:17:06','2023-04-27 12:17:06'),(4057,7986,40772,14171,3,4057,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',751463.12,NULL,NULL,1,'2023-04-27 11:35:37','2023-04-27 12:17:54','2023-04-27 12:17:54'),(4058,7986,40772,14172,3,4058,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',733325.63,NULL,NULL,1,'2023-04-27 11:36:54','2023-04-27 12:18:39','2023-04-27 12:18:39');
INSERT INTO `balance_libro` VALUES (4059,7986,40772,14173,3,4059,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',889582.55,NULL,NULL,1,'2023-04-27 11:38:04','2023-04-27 12:19:17','2023-04-27 12:19:17'),(4060,7986,40772,14174,3,4060,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',836097.81,NULL,NULL,1,'2023-04-27 11:39:47','2023-04-27 12:19:48','2023-04-27 12:19:48'),(4061,7986,40772,14175,3,4061,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',824866.82,NULL,NULL,1,'2023-04-27 11:42:39','2023-04-27 12:20:20','2023-04-27 12:20:20'),(4062,7986,40772,14176,3,4062,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-10-31','2022-10-31',913346.71,NULL,NULL,1,'2023-04-27 11:44:59','2023-04-27 11:44:59',NULL),(4063,7986,40772,11014,3,4063,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-11-30','2022-11-30',1199614.66,NULL,NULL,1,'2023-04-27 11:47:35','2023-04-27 11:47:35',NULL),(4064,7986,40772,11015,3,4064,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1259942.85,NULL,NULL,1,'2023-04-27 11:49:30','2023-04-27 11:53:01','2023-04-27 11:53:01'),(4065,7986,40772,11015,3,4065,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1316942.85,NULL,NULL,1,'2023-04-27 11:53:01','2023-04-27 12:22:22','2023-04-27 12:22:22'),(4066,7986,40772,14168,3,4066,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-28','2022-02-28',579447.65,NULL,NULL,1,'2023-04-27 12:15:36','2023-04-27 12:15:36',NULL),(4067,7986,40772,14169,3,4067,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31','2022-03-31',459809.61,NULL,NULL,1,'2023-04-27 12:16:21','2023-04-27 12:16:21',NULL),(4068,7986,40772,14170,3,4068,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-30','2022-04-30',556539.73,NULL,NULL,1,'2023-04-27 12:17:06','2023-04-27 12:17:06',NULL),(4069,7986,40772,14171,3,4069,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-05-31','2022-05-31',764338.12,NULL,NULL,1,'2023-04-27 12:17:54','2023-04-27 12:17:54',NULL),(4070,7986,40772,14172,3,4070,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-30','2022-06-30',745925.63,NULL,NULL,1,'2023-04-27 12:18:39','2023-04-27 12:18:39',NULL),(4071,7986,40772,14173,3,4071,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-07-31','2022-07-31',895582.55,NULL,NULL,1,'2023-04-27 12:19:17','2023-04-27 12:19:17',NULL),(4072,7986,40772,14174,3,4072,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-08-31','2022-08-31',842097.81,NULL,NULL,1,'2023-04-27 12:19:48','2023-04-27 12:19:48',NULL),(4073,7986,40772,14175,3,4073,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-09-30','2022-09-30',830866.82,NULL,NULL,1,'2023-04-27 12:20:20','2023-04-27 12:20:20',NULL),(4074,7986,40772,11015,3,4074,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1403307.85,NULL,NULL,1,'2023-04-27 12:22:22','2023-04-27 12:39:08','2023-04-27 12:39:08'),(4075,7986,40772,11015,3,4075,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1669608.39,NULL,NULL,1,'2023-04-27 12:39:08','2023-04-27 12:39:08',NULL),(4076,7986,40772,11015,23,4076,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',9691391.48,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-27 15:09:00','2023-04-27 15:10:58','2023-04-27 15:10:58'),(4077,7986,40772,11015,23,4077,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',9691391.48,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-27 15:10:58','2023-04-27 15:34:51','2023-04-27 15:34:51');
INSERT INTO `balance_libro` VALUES (4078,7986,40772,14163,12,4078,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-31','2021-12-31',6003522.93,'ASIENTO DE APERTURA',NULL,1,'2023-04-27 15:34:27','2023-04-27 15:34:27',NULL),(4079,7986,40772,11015,23,4079,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',6971772.71,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-27 15:37:05','2023-04-27 15:39:17','2023-04-27 15:39:17'),(4080,7986,40772,11015,23,4080,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',10074366.05,'Ajuste por Inflacion Asiento Anual',NULL,1,'2023-04-27 15:40:46','2023-04-27 15:40:55',NULL),(4081,7986,40772,11015,19,4081,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',1014991.67,'AJUSTE POR INFLACION DISTRIBUCION UTILIDADES',NULL,1,'2023-04-27 15:54:03','2023-04-27 15:54:03',NULL),(4082,7986,40772,11015,4,4082,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',85577.28,'AMORTIZACION DEL EJERCICIO',NULL,1,'2023-04-27 16:47:14','2023-04-27 16:50:04','2023-04-27 16:50:04'),(4083,7986,40772,11015,4,4083,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-12-31','2022-12-31',85766.22,'AMORTIZACION DEL EJERCICIO',NULL,1,'2023-04-27 16:50:04','2023-04-27 16:50:04',NULL),(4084,7986,40773,14352,1,4084,'App\\Models\\BalanceLibro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2023-03-31',NULL,115331.87,NULL,NULL,1,'2023-05-02 08:47:04','2023-05-02 08:47:04',NULL),(4085,7986,40721,3021,3,3555,'App\\Models\\Receipt',3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',21257.05,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:11:42','2023-05-23 11:11:42'),(4086,7986,40721,3021,3,3556,'App\\Models\\Receipt',3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',16365.13,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-05 12:00:40',NULL),(4087,7986,40721,3021,3,3557,'App\\Models\\Receipt',3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',32102.20,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:12:44','2023-05-23 11:12:44'),(4088,7986,40721,3021,3,3558,'App\\Models\\Receipt',3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',52766.71,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-05 12:00:40',NULL),(4089,7986,40721,3021,3,3559,'App\\Models\\Receipt',3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',48760.61,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-05 12:00:40',NULL),(4090,7986,40721,3021,3,3560,'App\\Models\\Receipt',3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',4536.48,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:13:29','2023-05-23 11:13:29'),(4091,7986,40721,3021,3,3561,'App\\Models\\Receipt',3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',29331.01,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:14:03','2023-05-23 11:14:03'),(4092,7986,40721,3021,3,3562,'App\\Models\\Receipt',3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',44411.07,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:15:21','2023-05-23 11:15:21'),(4093,7986,40721,3021,3,3563,'App\\Models\\Receipt',3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',6695.54,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:15:59','2023-05-23 11:15:59'),(4094,7986,40721,3021,3,3564,'App\\Models\\Receipt',3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',60137.91,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:16:36','2023-05-23 11:16:36'),(4095,7986,40721,3021,3,3565,'App\\Models\\Receipt',3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',27721.69,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-05 12:00:40',NULL),(4096,7986,40721,3021,3,3566,'App\\Models\\Receipt',3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2889.32,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:20:05','2023-05-23 11:20:05');
INSERT INTO `balance_libro` VALUES (4097,7986,40721,3021,3,3567,'App\\Models\\Receipt',3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',24392.30,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:20:42','2023-05-23 11:20:42'),(4098,7986,40721,3021,3,3568,'App\\Models\\Receipt',3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',27250.00,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:21:16','2023-05-23 11:21:16'),(4099,7986,40721,3021,3,3569,'App\\Models\\Receipt',3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',89704.95,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:22:04','2023-05-23 11:22:04'),(4100,7986,40721,3021,3,3570,'App\\Models\\Receipt',3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',14528.05,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:22:40','2023-05-23 11:22:40'),(4101,7986,40721,3021,3,3571,'App\\Models\\Receipt',3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',225748.83,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:24:57','2023-05-23 11:24:57'),(4102,7986,40721,3021,3,3572,'App\\Models\\Receipt',3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',43081.54,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-05 12:00:40',NULL),(4103,7986,40721,3021,3,3573,'App\\Models\\Receipt',3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',157957.15,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-05 12:00:40',NULL),(4104,7986,40721,3021,3,3574,'App\\Models\\Receipt',3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',55531.42,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:25:58','2023-05-23 11:25:58'),(4105,7986,40721,3021,3,3575,'App\\Models\\Receipt',3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',9901.13,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-05 12:00:40',NULL),(4106,7986,40721,3021,3,3576,'App\\Models\\Receipt',3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',9323.34,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-23 11:26:44','2023-05-23 11:26:44'),(4107,7986,40721,3021,3,3577,'App\\Models\\Receipt',3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',20968.19,NULL,NULL,1,'2023-05-05 12:00:40','2023-05-05 12:00:40',NULL),(4108,7986,40721,3021,3,3578,'App\\Models\\Receipt',3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',42281.82,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:27:47','2023-05-23 11:27:47'),(4109,7986,40721,3021,3,3579,'App\\Models\\Receipt',3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',22074.56,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:28:39','2023-05-23 11:28:39'),(4110,7986,40721,3021,3,3580,'App\\Models\\Receipt',3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',10972.62,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:29:09','2023-05-23 11:29:09'),(4111,7986,40721,3021,3,3581,'App\\Models\\Receipt',3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',138092.00,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:29:50','2023-05-23 11:29:50'),(4112,7986,40721,3021,3,3582,'App\\Models\\Receipt',3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',12913.00,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:30:21','2023-05-23 11:30:21'),(4113,7986,40721,3021,3,3583,'App\\Models\\Receipt',3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-13','2023-04-13',24004.92,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:30:53','2023-05-23 11:30:53'),(4114,7986,40721,3021,3,3584,'App\\Models\\Receipt',3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',39750.00,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-05 12:00:41',NULL),(4115,7986,40721,3021,3,3585,'App\\Models\\Receipt',3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',5975.34,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:32:11','2023-05-23 11:32:11');
INSERT INTO `balance_libro` VALUES (4116,7986,40721,3021,3,3586,'App\\Models\\Receipt',3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',8298.97,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:35:22','2023-05-23 11:35:22'),(4117,7986,40721,3021,3,3587,'App\\Models\\Receipt',3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',16769.44,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:35:53','2023-05-23 11:35:53'),(4118,7986,40721,3021,3,3588,'App\\Models\\Receipt',3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',17395.89,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:37:16','2023-05-23 11:37:16'),(4119,7986,40721,3021,3,3589,'App\\Models\\Receipt',3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-14','2023-04-14',18784.67,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:37:36','2023-05-23 11:37:36'),(4120,7986,40721,3021,3,3590,'App\\Models\\Receipt',3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-15','2023-04-15',53647.21,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:38:23','2023-05-23 11:38:23'),(4121,7986,40721,3021,3,3591,'App\\Models\\Receipt',3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',19673.46,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-05 12:00:41',NULL),(4122,7986,40721,3021,3,3592,'App\\Models\\Receipt',3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',20465.60,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-05 12:00:41',NULL),(4123,7986,40721,3021,3,3593,'App\\Models\\Receipt',3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',60437.58,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:39:44','2023-05-23 11:39:44'),(4124,7986,40721,3021,3,3594,'App\\Models\\Receipt',3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',35702.12,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:40:14','2023-05-23 11:40:14'),(4125,7986,40721,3021,3,3595,'App\\Models\\Receipt',3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',1628.90,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:40:42','2023-05-23 11:40:42'),(4126,7986,40721,3021,3,3596,'App\\Models\\Receipt',3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-19','2023-04-19',16142.66,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-05 12:00:41',NULL),(4127,7986,40721,3021,3,3597,'App\\Models\\Receipt',3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',23760.37,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:41:27','2023-05-23 11:41:27'),(4128,7986,40721,3021,3,3598,'App\\Models\\Receipt',3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',2840.69,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:41:48','2023-05-23 11:41:48'),(4129,7986,40721,3021,3,3599,'App\\Models\\Receipt',3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-20','2023-04-20',11871.98,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:44:13','2023-05-23 11:44:13'),(4130,7986,40721,3021,3,3600,'App\\Models\\Receipt',3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',42050.00,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:46:03','2023-05-23 11:46:03'),(4131,7986,40721,3021,3,3601,'App\\Models\\Receipt',3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',42050.00,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-23 11:45:48','2023-05-23 11:45:48'),(4132,7986,40721,3021,3,3602,'App\\Models\\Receipt',3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',24850.00,NULL,NULL,1,'2023-05-05 12:00:41','2023-05-05 12:00:41',NULL),(4133,7986,40721,3021,3,3603,'App\\Models\\Receipt',3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',10279.30,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:46:45','2023-05-23 11:46:45'),(4134,7986,40721,3021,3,3604,'App\\Models\\Receipt',3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',276184.00,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:47:27','2023-05-23 11:47:27');
INSERT INTO `balance_libro` VALUES (4135,7986,40721,3021,3,3605,'App\\Models\\Receipt',3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',45287.61,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-05 12:00:42',NULL),(4136,7986,40721,3021,3,3606,'App\\Models\\Receipt',3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',1795.08,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:48:00','2023-05-23 11:48:00'),(4137,7986,40721,3021,3,3607,'App\\Models\\Receipt',3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',558185.94,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:48:32','2023-05-23 11:48:32'),(4138,7986,40721,3021,3,3608,'App\\Models\\Receipt',3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',4466.67,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:49:16','2023-05-23 11:49:16'),(4139,7986,40721,3021,3,3609,'App\\Models\\Receipt',3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',2298.66,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:50:10','2023-05-23 11:50:10'),(4140,7986,40721,3021,3,3610,'App\\Models\\Receipt',3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',2137.68,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:49:42','2023-05-23 11:49:42'),(4141,7986,40721,3021,3,3611,'App\\Models\\Receipt',3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',2351.14,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-05 12:00:42',NULL),(4142,7986,40721,3021,3,3612,'App\\Models\\Receipt',3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-22','2023-04-22',10579.77,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:51:15','2023-05-23 11:51:15'),(4143,7986,40721,3021,3,3613,'App\\Models\\Receipt',3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',32113.71,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:55:32','2023-05-23 11:55:32'),(4144,7986,40721,3021,3,3614,'App\\Models\\Receipt',3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',23944.00,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:57:15','2023-05-23 11:57:15'),(4145,7986,40721,3021,3,3615,'App\\Models\\Receipt',3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',1247.37,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:57:46','2023-05-23 11:57:46'),(4146,7986,40721,3021,3,3616,'App\\Models\\Receipt',3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',2630.94,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:58:15','2023-05-23 11:58:15'),(4147,7986,40721,3021,3,3617,'App\\Models\\Receipt',3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',16500.55,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:58:43','2023-05-23 11:58:43'),(4148,7986,40721,3021,3,3618,'App\\Models\\Receipt',3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',31973.01,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-05 12:00:42',NULL),(4149,7986,40721,3021,3,3619,'App\\Models\\Receipt',3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',6214.80,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-05 12:00:42',NULL),(4150,7986,40721,3021,3,3620,'App\\Models\\Receipt',3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',558185.94,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:59:32','2023-05-23 11:59:32'),(4151,7986,40721,3021,3,3621,'App\\Models\\Receipt',3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',5500.03,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 11:59:47','2023-05-23 11:59:47'),(4152,7986,40721,3021,3,3622,'App\\Models\\Receipt',3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',8876.41,NULL,NULL,1,'2023-05-05 12:00:42','2023-05-23 12:00:27','2023-05-23 12:00:27'),(4153,7986,40721,3021,3,3623,'App\\Models\\Receipt',3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',30275.81,NULL,NULL,1,'2023-05-05 12:00:43','2023-05-23 12:01:20','2023-05-23 12:01:20');
INSERT INTO `balance_libro` VALUES (4154,7986,40721,3021,3,3624,'App\\Models\\Receipt',3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',11405.32,NULL,NULL,1,'2023-05-05 12:00:43','2023-05-23 12:01:53','2023-05-23 12:01:53'),(4155,7986,40721,3021,3,3625,'App\\Models\\Receipt',3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',17999.96,NULL,NULL,1,'2023-05-05 12:00:43','2023-05-23 12:02:15','2023-05-23 12:02:15'),(4156,7986,40721,3021,3,3626,'App\\Models\\Receipt',3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',15141.05,NULL,NULL,1,'2023-05-05 12:00:43','2023-05-23 12:02:50','2023-05-23 12:02:50'),(4157,7986,40721,3021,3,3627,'App\\Models\\Receipt',3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',39283.20,NULL,NULL,1,'2023-05-05 12:00:43','2023-05-23 12:03:20','2023-05-23 12:03:20'),(4158,7986,40721,3021,3,3628,'App\\Models\\Receipt',3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',19625.60,NULL,NULL,1,'2023-05-05 12:00:43','2023-05-23 12:03:44','2023-05-23 12:03:44'),(4159,7986,40721,3021,3,3629,'App\\Models\\Receipt',3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',15610.00,NULL,NULL,1,'2023-05-05 12:00:43','2023-05-05 12:00:43',NULL),(4160,7986,40721,3021,3,3630,'App\\Models\\Receipt',3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',30680.00,NULL,NULL,1,'2023-05-05 12:00:43','2023-05-05 12:00:43',NULL),(4161,7986,40721,3021,3,3631,'App\\Models\\Receipt',3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',1149500.00,NULL,NULL,1,'2023-05-05 12:00:43','2023-05-23 12:04:11','2023-05-23 12:04:11'),(4162,7986,40721,3021,3,3632,'App\\Models\\Receipt',3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',14677.10,NULL,NULL,1,'2023-05-05 12:00:44','2023-05-23 12:04:30','2023-05-23 12:04:30'),(4163,7986,40721,3021,3,3633,'App\\Models\\Receipt',3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',3781.01,NULL,NULL,1,'2023-05-05 12:00:44','2023-05-05 12:00:44',NULL),(4164,7986,40721,3021,3,3634,'App\\Models\\Receipt',3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',10730.87,NULL,NULL,1,'2023-05-05 12:00:44','2023-05-23 12:06:38','2023-05-23 12:06:38'),(4165,7986,40721,3021,3,3635,'App\\Models\\Receipt',3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',63175.89,NULL,NULL,1,'2023-05-05 12:00:44','2023-05-23 12:07:05','2023-05-23 12:07:05'),(4166,7986,40721,3021,3,3636,'App\\Models\\Receipt',3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',10192.72,NULL,NULL,1,'2023-05-05 12:00:44','2023-05-23 12:25:57','2023-05-23 12:25:57'),(4167,7986,40776,17356,3,3637,'App\\Models\\Receipt',3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',6299.99,NULL,NULL,1,'2023-05-05 12:01:13','2023-05-05 12:01:13',NULL),(4168,7986,40776,17356,3,3638,'App\\Models\\Receipt',3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',3780.00,NULL,NULL,1,'2023-05-05 12:01:13','2023-05-05 12:01:13',NULL),(4169,7986,40776,17356,3,3639,'App\\Models\\Receipt',3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',20000.02,NULL,NULL,1,'2023-05-05 12:01:13','2023-05-05 12:01:13',NULL),(4170,7986,40776,17356,3,3640,'App\\Models\\Receipt',3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-21','2023-04-21',121379.14,NULL,NULL,1,'2023-05-05 12:01:13','2023-05-05 12:01:13',NULL),(4171,7986,40776,17356,3,3641,'App\\Models\\Receipt',3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',7917.00,NULL,NULL,1,'2023-05-05 12:01:13','2023-05-19 09:47:36','2023-05-19 09:47:36'),(4172,7986,40776,17356,3,3642,'App\\Models\\Receipt',3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',4500.00,NULL,NULL,1,'2023-05-05 12:01:13','2023-05-05 12:01:13',NULL),(4173,7986,40772,11020,3,3643,'App\\Models\\Receipt',3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',122306.40,NULL,NULL,1,'2023-05-05 12:01:37','2023-05-05 12:01:37',NULL);
INSERT INTO `balance_libro` VALUES (4174,7986,40772,11020,3,3644,'App\\Models\\Receipt',3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',122306.40,NULL,NULL,1,'2023-05-05 12:01:37','2023-05-05 12:01:37',NULL),(4175,7986,40772,11020,3,3645,'App\\Models\\Receipt',3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',146800.00,NULL,NULL,1,'2023-05-05 12:01:37','2023-05-05 12:01:37',NULL),(4176,7986,40772,11020,3,3646,'App\\Models\\Receipt',3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',46800.00,NULL,NULL,1,'2023-05-05 12:01:37','2023-05-05 12:01:37',NULL),(4177,7986,40772,11020,3,3647,'App\\Models\\Receipt',3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-10','2023-04-10',7600.28,NULL,NULL,1,'2023-05-05 12:01:37','2023-05-05 12:01:37',NULL),(4178,7986,40772,11020,3,3648,'App\\Models\\Receipt',3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',13500.00,NULL,NULL,1,'2023-05-05 12:01:37','2023-05-05 12:01:37',NULL),(4179,7986,40772,11020,3,3649,'App\\Models\\Receipt',3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-28','2023-04-28',14400.00,NULL,NULL,1,'2023-05-05 12:01:37','2023-05-05 12:01:37',NULL),(4180,7986,40772,11020,3,3650,'App\\Models\\Receipt',3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',9300.00,NULL,NULL,1,'2023-05-05 12:01:37','2023-05-05 12:01:37',NULL),(4181,7986,40772,11020,3,3651,'App\\Models\\Receipt',3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',60000.00,NULL,NULL,1,'2023-05-05 12:01:37','2023-05-05 12:01:37',NULL),(4182,7986,40772,11020,3,3652,'App\\Models\\Receipt',3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',3298.43,NULL,NULL,1,'2023-05-05 12:01:37','2023-05-05 12:01:37',NULL),(4183,7986,40772,11020,3,3653,'App\\Models\\Receipt',3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',32400.00,NULL,NULL,1,'2023-05-05 12:01:37','2023-05-05 12:01:37',NULL),(4184,7986,40759,8017,3,3654,'App\\Models\\Receipt',3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2082.54,NULL,NULL,1,'2023-05-05 12:01:57','2023-05-05 12:01:57',NULL),(4185,7986,40759,8017,3,3655,'App\\Models\\Receipt',3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1200.00,NULL,NULL,1,'2023-05-05 12:01:57','2023-05-05 12:01:57',NULL),(4186,7986,40759,8017,3,3656,'App\\Models\\Receipt',3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',189.07,NULL,NULL,1,'2023-05-05 12:01:57','2023-05-05 12:01:57',NULL),(4187,7986,40759,8017,3,3657,'App\\Models\\Receipt',3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',29161.45,NULL,NULL,1,'2023-05-05 12:01:57','2023-05-11 09:26:46','2023-05-11 09:26:46'),(4188,7986,40759,8017,3,3658,'App\\Models\\Receipt',3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',57049.99,NULL,NULL,1,'2023-05-05 12:01:57','2023-05-11 09:21:01','2023-05-11 09:21:01'),(4189,7986,40759,8017,3,3659,'App\\Models\\Receipt',3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',65928.59,NULL,NULL,1,'2023-05-05 12:01:57','2023-05-11 09:22:26','2023-05-11 09:22:26'),(4190,7986,40759,8017,3,3660,'App\\Models\\Receipt',3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',15707.86,NULL,NULL,1,'2023-05-05 12:01:57','2023-06-30 10:32:39','2023-06-30 10:32:39'),(4191,7986,40759,8017,3,3661,'App\\Models\\Receipt',3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',15707.86,NULL,NULL,1,'2023-05-05 12:01:57','2023-05-11 09:27:39','2023-05-11 09:27:39'),(4192,7986,40759,8017,3,3662,'App\\Models\\Receipt',3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',9371.30,NULL,NULL,1,'2023-05-05 12:01:57','2023-06-30 10:33:01','2023-06-30 10:33:01'),(4193,7986,40759,8017,3,3663,'App\\Models\\Receipt',3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-12','2023-04-12',91752.33,NULL,NULL,1,'2023-05-05 12:01:57','2023-05-11 09:22:52','2023-05-11 09:22:52');
INSERT INTO `balance_libro` VALUES (4194,7986,40759,8017,3,3664,'App\\Models\\Receipt',3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-18','2023-04-18',11612.70,NULL,NULL,1,'2023-05-05 12:01:57','2023-05-11 09:23:23','2023-05-11 09:23:23'),(4195,7986,40759,8017,3,3665,'App\\Models\\Receipt',3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',3599.33,NULL,NULL,1,'2023-05-05 12:01:57','2023-06-30 10:33:22','2023-06-30 10:33:22'),(4196,7986,40759,8017,3,3666,'App\\Models\\Receipt',3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-24','2023-04-24',158.89,NULL,NULL,1,'2023-05-05 12:01:57','2023-06-30 10:33:49','2023-06-30 10:33:49'),(4197,7986,40759,8017,3,3667,'App\\Models\\Receipt',3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',38535.29,NULL,NULL,1,'2023-05-05 12:01:57','2023-05-11 09:23:55','2023-05-11 09:23:55'),(4198,7986,40759,8017,3,3668,'App\\Models\\Receipt',3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-26','2023-04-26',85486.50,NULL,NULL,1,'2023-05-05 12:01:57','2023-05-11 09:24:28','2023-05-11 09:24:28'),(4199,7986,40759,8017,3,3669,'App\\Models\\Receipt',3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-29','2023-04-29',180559.83,NULL,NULL,1,'2023-05-05 12:01:57','2023-06-30 10:34:19','2023-06-30 10:34:19'),(4200,7986,40759,8017,3,3670,'App\\Models\\Receipt',3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',2950.00,NULL,NULL,1,'2023-05-05 12:01:57','2023-06-30 10:34:39','2023-06-30 10:34:39'),(4201,7986,40720,1521,3,3671,'App\\Models\\Receipt',3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-11','2023-04-11',45093.51,NULL,NULL,1,'2023-05-05 12:02:22','2023-05-05 12:02:22',NULL),(4202,7986,40721,3021,2,3672,'App\\Models\\Receipt',3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',229591.45,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4203,7986,40721,3021,2,3673,'App\\Models\\Receipt',3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',215773.25,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4204,7986,40721,3021,2,3674,'App\\Models\\Receipt',3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',27456.00,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4205,7986,40721,3021,2,3675,'App\\Models\\Receipt',3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',24512.00,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4206,7986,40721,3021,2,3676,'App\\Models\\Receipt',3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-16','2023-04-16',28951.00,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4207,7986,40721,3021,2,3677,'App\\Models\\Receipt',3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',191754.75,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4208,7986,40721,3021,2,3678,'App\\Models\\Receipt',3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',31083.69,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4209,7986,40721,3021,2,3679,'App\\Models\\Receipt',3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',26305.00,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4210,7986,40721,3021,2,3680,'App\\Models\\Receipt',3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',17452.00,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4211,7986,40721,3021,2,3681,'App\\Models\\Receipt',3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-17','2023-04-17',19520.00,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4212,7986,40721,3021,2,3682,'App\\Models\\Receipt',3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',389378.00,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4213,7986,40721,3021,2,3683,'App\\Models\\Receipt',3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',29766.00,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL);
INSERT INTO `balance_libro` VALUES (4214,7986,40721,3021,2,3684,'App\\Models\\Receipt',3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-25','2023-04-25',26544.00,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4215,7986,40721,3021,2,3685,'App\\Models\\Receipt',3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',17865.00,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4216,7986,40721,3021,2,3686,'App\\Models\\Receipt',3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-27','2023-04-27',19555.00,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4217,7986,40721,3021,2,3687,'App\\Models\\Receipt',3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',40145.38,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4218,7986,40721,3021,2,3688,'App\\Models\\Receipt',3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',255256.76,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4219,7986,40721,3021,2,3689,'App\\Models\\Receipt',3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',283355.38,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4220,7986,40721,3021,2,3690,'App\\Models\\Receipt',3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',323862.55,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4221,7986,40721,3021,2,3691,'App\\Models\\Receipt',3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',361237.03,NULL,NULL,1,'2023-05-10 11:33:58','2023-05-10 11:33:58',NULL),(4222,7986,40721,3021,2,3692,'App\\Models\\Receipt',3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',323702.83,NULL,NULL,1,'2023-05-10 11:33:59','2023-05-10 11:33:59',NULL),(4223,7986,40721,3021,2,3693,'App\\Models\\Receipt',3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',40642.69,NULL,NULL,1,'2023-05-10 11:33:59','2023-05-10 11:33:59',NULL),(4224,7986,40721,3021,2,3694,'App\\Models\\Receipt',3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-30','2023-04-30',283355.38,NULL,NULL,1,'2023-05-10 11:33:59','2023-05-10 11:33:59',NULL),(4225,7986,40759,8017,2,3695,'App\\Models\\Receipt',3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1500.00,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4226,7986,40759,8017,2,3696,'App\\Models\\Receipt',3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1000.01,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4227,7986,40759,8017,2,3697,'App\\Models\\Receipt',3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',800.00,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4228,7986,40759,8017,2,3698,'App\\Models\\Receipt',3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1300.00,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4229,7986,40759,8017,2,3699,'App\\Models\\Receipt',3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1800.00,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4230,7986,40759,8017,2,3700,'App\\Models\\Receipt',3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1800.00,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4231,7986,40759,8017,2,3701,'App\\Models\\Receipt',3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1800.00,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4232,7986,40759,8017,2,3702,'App\\Models\\Receipt',3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',800.00,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4233,7986,40759,8017,2,3703,'App\\Models\\Receipt',3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',800.00,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4234,7986,40759,8017,2,3704,'App\\Models\\Receipt',3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1899.99,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL);
INSERT INTO `balance_libro` VALUES (4235,7986,40759,8017,2,3705,'App\\Models\\Receipt',3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1000.01,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4236,7986,40759,8017,2,3706,'App\\Models\\Receipt',3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1800.00,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4237,7986,40759,8017,2,3707,'App\\Models\\Receipt',3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1800.00,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4238,7986,40759,8017,2,3708,'App\\Models\\Receipt',3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1800.00,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4239,7986,40759,8017,2,3709,'App\\Models\\Receipt',3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',3600.00,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4240,7986,40759,8017,2,3710,'App\\Models\\Receipt',3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1000.01,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4241,7986,40759,8017,2,3711,'App\\Models\\Receipt',3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',2500.01,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4242,7986,40759,8017,2,3712,'App\\Models\\Receipt',3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1000.01,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4243,7986,40759,8017,2,3713,'App\\Models\\Receipt',3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1499.99,NULL,NULL,1,'2023-05-10 11:34:33','2023-05-10 11:34:33',NULL),(4244,7986,40759,8017,2,3714,'App\\Models\\Receipt',3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1800.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4245,7986,40759,8017,2,3715,'App\\Models\\Receipt',3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1800.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4246,7986,40759,8017,2,3716,'App\\Models\\Receipt',3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1880.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4247,7986,40759,8017,2,3717,'App\\Models\\Receipt',3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',800.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4248,7986,40759,8017,2,3718,'App\\Models\\Receipt',3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',900.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4249,7986,40759,8017,2,3719,'App\\Models\\Receipt',3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1959.99,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4250,7986,40759,8017,2,3720,'App\\Models\\Receipt',3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-01','2023-04-01',1500.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4251,7986,40759,8017,2,3721,'App\\Models\\Receipt',3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2000.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4252,7986,40759,8017,2,3722,'App\\Models\\Receipt',3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1100.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4253,7986,40759,8017,2,3723,'App\\Models\\Receipt',3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1180.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4254,7986,40759,8017,2,3724,'App\\Models\\Receipt',3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',3200.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4255,7986,40759,8017,2,3725,'App\\Models\\Receipt',3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1000.01,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL);
INSERT INTO `balance_libro` VALUES (4256,7986,40759,8017,2,3726,'App\\Models\\Receipt',3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',600.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4257,7986,40759,8017,2,3727,'App\\Models\\Receipt',3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1200.01,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4258,7986,40759,8017,2,3728,'App\\Models\\Receipt',3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2500.01,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4259,7986,40759,8017,2,3729,'App\\Models\\Receipt',3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2000.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4260,7986,40759,8017,2,3730,'App\\Models\\Receipt',3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',3500.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4261,7986,40759,8017,2,3731,'App\\Models\\Receipt',3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2080.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4262,7986,40759,8017,2,3732,'App\\Models\\Receipt',3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2000.00,NULL,NULL,1,'2023-05-10 11:34:34','2023-05-10 11:34:34',NULL),(4263,7986,40759,8017,2,3733,'App\\Models\\Receipt',3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',3599.99,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4264,7986,40759,8017,2,3734,'App\\Models\\Receipt',3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',3100.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4265,7986,40759,8017,2,3735,'App\\Models\\Receipt',3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',3819.99,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4266,7986,40759,8017,2,3736,'App\\Models\\Receipt',3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',900.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4267,7986,40759,8017,2,3737,'App\\Models\\Receipt',3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1500.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4268,7986,40759,8017,2,3738,'App\\Models\\Receipt',3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',3500.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4269,7986,40759,8017,2,3739,'App\\Models\\Receipt',3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',800.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4270,7986,40759,8017,2,3740,'App\\Models\\Receipt',3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',700.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4271,7986,40759,8017,2,3741,'App\\Models\\Receipt',3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1000.01,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4272,7986,40759,8017,2,3742,'App\\Models\\Receipt',3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',800.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4273,7986,40759,8017,2,3743,'App\\Models\\Receipt',3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1600.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4274,7986,40759,8017,2,3744,'App\\Models\\Receipt',3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2000.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4275,7986,40759,8017,2,3745,'App\\Models\\Receipt',3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1000.01,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4276,7986,40759,8017,2,3746,'App\\Models\\Receipt',3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',800.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL);
INSERT INTO `balance_libro` VALUES (4277,7986,40759,8017,2,3747,'App\\Models\\Receipt',3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1200.01,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4278,7986,40759,8017,2,3748,'App\\Models\\Receipt',3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2000.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4279,7986,40759,8017,2,3749,'App\\Models\\Receipt',3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1800.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4280,7986,40759,8017,2,3750,'App\\Models\\Receipt',3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',999.99,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4281,7986,40759,8017,2,3751,'App\\Models\\Receipt',3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',800.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4282,7986,40759,8017,2,3752,'App\\Models\\Receipt',3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1800.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4283,7986,40759,8017,2,3753,'App\\Models\\Receipt',3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',700.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4284,7986,40759,8017,2,3754,'App\\Models\\Receipt',3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1600.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4285,7986,40759,8017,2,3755,'App\\Models\\Receipt',3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',800.00,NULL,NULL,1,'2023-05-10 11:34:35','2023-05-10 11:34:35',NULL),(4286,7986,40759,8017,2,3756,'App\\Models\\Receipt',3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2000.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4287,7986,40759,8017,2,3757,'App\\Models\\Receipt',3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2049.99,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4288,7986,40759,8017,2,3758,'App\\Models\\Receipt',3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1000.01,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4289,7986,40759,8017,2,3759,'App\\Models\\Receipt',3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',950.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4290,7986,40759,8017,2,3760,'App\\Models\\Receipt',3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',700.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4291,7986,40759,8017,2,3761,'App\\Models\\Receipt',3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1100.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4292,7986,40759,8017,2,3762,'App\\Models\\Receipt',3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2360.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4293,7986,40759,8017,2,3763,'App\\Models\\Receipt',3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',800.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4294,7986,40759,8017,2,3764,'App\\Models\\Receipt',3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1350.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4295,7986,40759,8017,2,3765,'App\\Models\\Receipt',3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',400.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4296,7986,40759,8017,2,3766,'App\\Models\\Receipt',3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1550.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4297,7986,40759,8017,2,3767,'App\\Models\\Receipt',3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1200.01,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL);
INSERT INTO `balance_libro` VALUES (4298,7986,40759,8017,2,3768,'App\\Models\\Receipt',3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',1100.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4299,7986,40759,8017,2,3769,'App\\Models\\Receipt',3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',749.99,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4300,7986,40759,8017,2,3770,'App\\Models\\Receipt',3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',900.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4301,7986,40759,8017,2,3771,'App\\Models\\Receipt',3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2160.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4302,7986,40759,8017,2,3772,'App\\Models\\Receipt',3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',500.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4303,7986,40759,8017,2,3773,'App\\Models\\Receipt',3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',800.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4304,7986,40759,8017,2,3774,'App\\Models\\Receipt',3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2000.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4305,7986,40759,8017,2,3775,'App\\Models\\Receipt',3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-02','2023-04-02',2000.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4306,7986,40759,8017,2,3776,'App\\Models\\Receipt',3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',400.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4307,7986,40759,8017,2,3777,'App\\Models\\Receipt',3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',400.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4308,7986,40759,8017,2,3778,'App\\Models\\Receipt',3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',800.00,NULL,NULL,1,'2023-05-10 11:34:36','2023-05-10 11:34:36',NULL),(4309,7986,40759,8017,2,3779,'App\\Models\\Receipt',3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2000.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4310,7986,40759,8017,2,3780,'App\\Models\\Receipt',3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',1000.01,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4311,7986,40759,8017,2,3781,'App\\Models\\Receipt',3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',2000.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4312,7986,40759,8017,2,3782,'App\\Models\\Receipt',3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',999.99,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4313,7986,40759,8017,2,3783,'App\\Models\\Receipt',3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',300.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4314,7986,40759,8017,2,3784,'App\\Models\\Receipt',3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',800.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4315,7986,40759,8017,2,3785,'App\\Models\\Receipt',3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-03','2023-04-03',750.01,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4316,7986,40759,8017,2,3786,'App\\Models\\Receipt',3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',900.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4317,7986,40759,8017,2,3787,'App\\Models\\Receipt',3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',450.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4318,7986,40759,8017,2,3788,'App\\Models\\Receipt',3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',550.01,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL);
INSERT INTO `balance_libro` VALUES (4319,7986,40759,8017,2,3789,'App\\Models\\Receipt',3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',700.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4320,7986,40759,8017,2,3790,'App\\Models\\Receipt',3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',900.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4321,7986,40759,8017,2,3791,'App\\Models\\Receipt',3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',749.99,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4322,7986,40759,8017,2,3792,'App\\Models\\Receipt',3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',1100.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4323,7986,40759,8017,2,3793,'App\\Models\\Receipt',3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',4100.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4324,7986,40759,8017,2,3794,'App\\Models\\Receipt',3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',800.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4325,7986,40759,8017,2,3795,'App\\Models\\Receipt',3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',600.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4326,7986,40759,8017,2,3796,'App\\Models\\Receipt',3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',2000.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4327,7986,40759,8017,2,3797,'App\\Models\\Receipt',3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',2299.99,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4328,7986,40759,8017,2,3798,'App\\Models\\Receipt',3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-04','2023-04-04',900.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4329,7986,40759,8017,2,3799,'App\\Models\\Receipt',3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',350.01,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4330,7986,40759,8017,2,3800,'App\\Models\\Receipt',3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',1100.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4331,7986,40759,8017,2,3801,'App\\Models\\Receipt',3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',1800.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4332,7986,40759,8017,2,3802,'App\\Models\\Receipt',3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',450.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4333,7986,40759,8017,2,3803,'App\\Models\\Receipt',3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2200.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4334,7986,40759,8017,2,3804,'App\\Models\\Receipt',3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',1350.00,NULL,NULL,1,'2023-05-10 11:34:37','2023-05-10 11:34:37',NULL),(4335,7986,40759,8017,2,3805,'App\\Models\\Receipt',3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',749.99,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4336,7986,40759,8017,2,3806,'App\\Models\\Receipt',3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',900.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4337,7986,40759,8017,2,3807,'App\\Models\\Receipt',3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',600.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4338,7986,40759,8017,2,3808,'App\\Models\\Receipt',3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',900.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4339,7986,40759,8017,2,3809,'App\\Models\\Receipt',3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',1350.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL);
INSERT INTO `balance_libro` VALUES (4340,7986,40759,8017,2,3810,'App\\Models\\Receipt',3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',1100.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4341,7986,40759,8017,2,3811,'App\\Models\\Receipt',3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2579.99,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4342,7986,40759,8017,2,3812,'App\\Models\\Receipt',3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2000.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4343,7986,40759,8017,2,3813,'App\\Models\\Receipt',3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2000.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4344,7986,40759,8017,2,3814,'App\\Models\\Receipt',3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',700.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4345,7986,40759,8017,2,3815,'App\\Models\\Receipt',3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2000.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4346,7986,40759,8017,2,3816,'App\\Models\\Receipt',3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2160.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4347,7986,40759,8017,2,3817,'App\\Models\\Receipt',3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-05','2023-04-05',2000.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4348,7986,40759,8017,2,3818,'App\\Models\\Receipt',3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1800.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4349,7986,40759,8017,2,3819,'App\\Models\\Receipt',3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2000.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4350,7986,40759,8017,2,3820,'App\\Models\\Receipt',3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1150.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4351,7986,40759,8017,2,3821,'App\\Models\\Receipt',3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1050.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4352,7986,40759,8017,2,3822,'App\\Models\\Receipt',3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2000.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4353,7986,40759,8017,2,3823,'App\\Models\\Receipt',3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2000.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4354,7986,40759,8017,2,3824,'App\\Models\\Receipt',3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',3500.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4355,7986,40759,8017,2,3825,'App\\Models\\Receipt',3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1500.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4356,7986,40759,8017,2,3826,'App\\Models\\Receipt',3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1100.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4357,7986,40759,8017,2,3827,'App\\Models\\Receipt',3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',900.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4358,7986,40759,8017,2,3828,'App\\Models\\Receipt',3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1180.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4359,7986,40759,8017,2,3829,'App\\Models\\Receipt',3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',800.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4360,7986,40759,8017,2,3830,'App\\Models\\Receipt',3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2000.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL);
INSERT INTO `balance_libro` VALUES (4361,7986,40759,8017,2,3831,'App\\Models\\Receipt',3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',3100.00,NULL,NULL,1,'2023-05-10 11:34:38','2023-05-10 11:34:38',NULL),(4362,7986,40759,8017,2,3832,'App\\Models\\Receipt',3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2480.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4363,7986,40759,8017,2,3833,'App\\Models\\Receipt',3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2000.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4364,7986,40759,8017,2,3834,'App\\Models\\Receipt',3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2279.99,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4365,7986,40759,8017,2,3835,'App\\Models\\Receipt',3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1100.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4366,7986,40759,8017,2,3836,'App\\Models\\Receipt',3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1750.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4367,7986,40759,8017,2,3837,'App\\Models\\Receipt',3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1180.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4368,7986,40759,8017,2,3838,'App\\Models\\Receipt',3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1100.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4369,7986,40759,8017,2,3839,'App\\Models\\Receipt',3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',450.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4370,7986,40759,8017,2,3840,'App\\Models\\Receipt',3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2240.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4371,7986,40759,8017,2,3841,'App\\Models\\Receipt',3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',2900.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4372,7986,40759,8017,2,3842,'App\\Models\\Receipt',3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1700.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4373,7986,40759,8017,2,3843,'App\\Models\\Receipt',3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-06','2023-04-06',1850.01,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4374,7986,40759,8017,2,3844,'App\\Models\\Receipt',3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2000.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4375,7986,40759,8017,2,3845,'App\\Models\\Receipt',3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1350.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4376,7986,40759,8017,2,3846,'App\\Models\\Receipt',3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1399.99,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4377,7986,40759,8017,2,3847,'App\\Models\\Receipt',3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2850.01,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4378,7986,40759,8017,2,3848,'App\\Models\\Receipt',3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',5000.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4379,7986,40759,8017,2,3849,'App\\Models\\Receipt',3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',900.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4380,7986,40759,8017,2,3850,'App\\Models\\Receipt',3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',8599.99,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4381,7986,40759,8017,2,3851,'App\\Models\\Receipt',3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',450.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL);
INSERT INTO `balance_libro` VALUES (4382,7986,40759,8017,2,3852,'App\\Models\\Receipt',3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2000.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4383,7986,40759,8017,2,3853,'App\\Models\\Receipt',3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',900.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4384,7986,40759,8017,2,3854,'App\\Models\\Receipt',3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',4600.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4385,7986,40759,8017,2,3855,'App\\Models\\Receipt',3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2000.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4386,7986,40759,8017,2,3856,'App\\Models\\Receipt',3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1100.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4387,7986,40759,8017,2,3857,'App\\Models\\Receipt',3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2000.00,NULL,NULL,1,'2023-05-10 11:34:39','2023-05-10 11:34:39',NULL),(4388,7986,40759,8017,2,3858,'App\\Models\\Receipt',3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2000.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4389,7986,40759,8017,2,3859,'App\\Models\\Receipt',3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3100.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4390,7986,40759,8017,2,3860,'App\\Models\\Receipt',3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2000.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4391,7986,40759,8017,2,3861,'App\\Models\\Receipt',3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1350.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4392,7986,40759,8017,2,3862,'App\\Models\\Receipt',3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',3500.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4393,7986,40759,8017,2,3863,'App\\Models\\Receipt',3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1800.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4394,7986,40759,8017,2,3864,'App\\Models\\Receipt',3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2000.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4395,7986,40759,8017,2,3865,'App\\Models\\Receipt',3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1100.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4396,7986,40759,8017,2,3866,'App\\Models\\Receipt',3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1350.01,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4397,7986,40759,8017,2,3867,'App\\Models\\Receipt',3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1500.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4398,7986,40759,8017,2,3868,'App\\Models\\Receipt',3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1100.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4399,7986,40759,8017,2,3869,'App\\Models\\Receipt',3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1550.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4400,7986,40759,8017,2,3870,'App\\Models\\Receipt',3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',1650.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4401,7986,40759,8017,2,3871,'App\\Models\\Receipt',3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-08','2023-04-08',2000.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4402,7986,40759,8017,2,3872,'App\\Models\\Receipt',3872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',2000.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL);
INSERT INTO `balance_libro` VALUES (4403,7986,40759,8017,2,3873,'App\\Models\\Receipt',3873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-04-09','2023-04-09',3500.00,NULL,NULL,1,'2023-05-10 11:34:40','2023-05-10 11:34:40',NULL),(4404,7986,40759,8017,2,3874,'App\\Models\\Rec