-- MariaDB dump 10.19  Distrib 10.5.11-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: mysql    Database: db27-12086837-9
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actas`
--

DROP TABLE IF EXISTS `actas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `acta_tipo_id` int(10) unsigned NOT NULL,
  `num_acta` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `file` text COLLATE utf8mb4_unicode_ci,
  `resumido` text COLLATE utf8mb4_unicode_ci,
  `detalle` longtext COLLATE utf8mb4_unicode_ci,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actas_person_id_foreign` (`person_id`),
  KEY `actas_acta_tipo_id_foreign` (`acta_tipo_id`),
  CONSTRAINT `actas_acta_tipo_id_foreign` FOREIGN KEY (`acta_tipo_id`) REFERENCES `actas_tipo` (`id`),
  CONSTRAINT `actas_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas`
--

LOCK TABLES `actas` WRITE;
/*!40000 ALTER TABLE `actas` DISABLE KEYS */;
/*!40000 ALTER TABLE `actas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_modelos`
--

DROP TABLE IF EXISTS `actas_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nombre` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detalle` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_modelos`
--

LOCK TABLES `actas_modelos` WRITE;
/*!40000 ALTER TABLE `actas_modelos` DISABLE KEYS */;
INSERT INTO `actas_modelos` VALUES (1,'Convocatoria de Asamblea P/ Aprobacion de Balance','<h2><strong><u>ACTA DE DIRECTORIO Nº 1: </u></strong></h2><p><br></p><p>En la ciudad de Buenos Aires, a los <strong>03 días del mes de abril de 2017</strong>, siendo las 10:00, en la sede social de la sociedad, se reúne el Directorio de la sociedad. Su Presidente el Señor&nbsp;<strong>XXXXXXXXX</strong>, una vez que declara abierta la sesión, toma la palabra para manifestar que la presente tiene por objeto:</p><p><br></p><p>1) Elevar para su consideración los Estados Contables y la Memoria de la Sociedad, correspondientes al ejercicio económico Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01 de enero de 2016 y cerrado al 31 de diciembre de 2016.</strong></p><p>2) La&nbsp;Aprobación de la Gestión desempeñada por el Directorio y su remuneración;&nbsp;</p><p>3) La distribución entre los accionistas de los&nbsp;Resultados no Asignados al <strong>31/12/2016.</strong></p><p><br></p><p>Respecto del punto 1) El Señor Jorge <strong>XXXXXXXXX</strong> manifiesta que habiendo contado el Directorio con la debida antelación con los Estados Contables cerrados al&nbsp;<strong>31/12/2016</strong> a analizar, los mismos sean aprobados sin más trámite. La moción propuesta es aprobada unánimemente. Luego de ello, pasa a leer la Memoria correspondiente al ejercicio bajo examen, exigida por el art. 66 de la Ley de Sociedades, la que dice: “ Señores Accionistas: En cumplimiento de lo requerido por el art. 66 de la Ley de Sociedades Comerciales, elevamos el contenido de la misma, la que corresponde al ejercicio económico&nbsp;Nº <strong>XXXXXXXXX</strong>, iniciado el <strong>01/01/2016 y finalizado el 31/12/2016</strong>&nbsp;informando que:</p><ul><li>En el presente ejercicio, no se produjeron variaciones significativas en la composición de las partidas del Activo y del Pasivo.</li><li>No se realizaron ajustes contable de ninguna especie, correspondientes a ingresos o egresos de ejercicios anteriores.El ejercicio bajo examen arrojó un resultado positivo de&nbsp;<strong>$ 122.008,84</strong></li><li>En cuanto a las perspectivas comerciales de las futuras operaciones, este Directorio sigue promocionando intensamente la captación de nuevos pacientes, hecho que, a la fecha de emisión de esta Memoria se va concretando favorablemente. Es por ello, que los resultados del próximo ejercicio deberán reflejar una destacable mejoría económica y financiera, compatibles con los estándares de calidad en la prestación de los servicios que brinda la sociedad.”&nbsp;Puesta a consideración del Directorio, la Memoria también es aprobada por unanimidad, proponiéndose sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Posteriormente,&nbsp;toma la palabra el Señor&nbsp;Presidente quien manifiesta que correspondería tratar el tópico referido a la Retribución a asignar al Directorio, correspondiente al ejercicio bajo examen.&nbsp;En uso de la palabra el Señor <strong>XXXXXXXXX</strong> propone que en función de los resultados obtenidos en el ejercicio bajo examen se asigne la suma de<strong>&nbsp;$ 12.500 (pesos doce mil quinientos)</strong> como Retribución al Directorio. Puesta la moción a votación, la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas.</li></ul><p><br></p><p>Respecto del punto 2) a continuación, el Señor <strong>XXXXXXXXX</strong> mociona para que se trate la Aprobación de la gestión del Directorio correspondiente al ejercicio baja examen. La propuesta respecto de la aprobación de la Gestión del Directorio es aprobada por unanimidad, por lo que propone su inclusión en el temario a tratar en la Asamblea Anual Ordinaria de Accionistas.</p><p><br></p><p>Respecto del punto 3) luego de ello, Presidente de la sociedad, propone que sea&nbsp;incluido en el temario de la Asamblea de Accionista, la generación de una reserva facultativa de los resultados acumulados de la sociedad al&nbsp;<strong>31/12/2016</strong>, entre los accionistas, en proporción a su tenencia actual, los cuales ascendían a&nbsp;<strong>$ 215.484,18 ( Doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong>. Puesta la moción a votación,&nbsp;la misma es aprobada por unanimidad, proponiéndose, asimismo, que sea incluida en el temario a tratar por la Asamblea Anual Ordinaria de Accionistas. Asimismo y en uso de las facultades conferidas al&nbsp;Directorio por los arts. 236 y 237 de la Ley 19.550, se decide convocar a Asamblea Anual Ordinaria de Accionistas, para el día <strong>19 de Abril de 2017</strong> a las 10:00, en la sede social de la sociedad, para tratar el siguiente:</p><p><br></p><p><strong><u>ORDEN DEL DIA</u></strong></p><p>1)&nbsp;Designación de dos Accionistas para firmar el Acta.</p><p>2)&nbsp;Consideración de la Memoria y Estados Contables al <strong>31 de diciembre de 2016.</strong></p><p>3)&nbsp;Aprobación de la Gestión y Remuneración del Directorio.</p><p>4) Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016.</strong></p><p><br></p><p>No siendo para más, previa rúbrica de los intervinientes, del presente acta, se levanta la sesión, siendo las 12:15.-</p><p><br></p><p><br></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (2,'Giro normal de la empresa','<p><strong><u>ACTA DE DIRECTORIO Nº 2: </u></strong></p><p><br></p><p>En la Ciudad Autónoma de Buenos Aires, a los 30 días del mes de Noviembre de 2016 a las 10hs, se constituye el Directorio de <strong>XXXXXXXXX</strong>. con la presencia de su Presidente y Vicepresidente, el Señor <strong>XXXXXXXXX</strong> y la Señora <strong>XXXXXXXXX</strong>. </p><p><br></p><p>Por haber quórum suficiente siendo las 10.30 horas dan por iniciada la sesión que fue previamente convocada con el objeto de dar cuenta del curso de la empresa. </p><p><br></p><p>A continuación, no se dan mayores novedades y se informa la normalidad de los actos de la empresa, siendo positivo los logros obtenidos hasta el momento.</p><p><br></p><p>No habiendo más asuntos que tratar y siendo las 12.50 hs. se cierra este acto, firmando a continuación los presentes en prueba de conformidad y para constancia.-&nbsp;</p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>_________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (3,'Aprobacion Balance SA','<p><strong><u>ACTA&nbsp;DE&nbsp;ASAMBLEA&nbsp;Nº&nbsp;1:</u></strong></p><p><br></p><p>En la ciudad de Buenos Aires, siendo las 10:00, del <strong>19 de abril de 2017</strong> en la sede social de la sociedad, se reúnen en primera convocatoria los Señores Accionistas de la sociedad, con motivo de la Convocatoria a Asamblea Ordinaria de Accionistas efectuada por el Directorio el <strong>03 de Abril de 2017</strong>, para considerar el temario incluido en el Orden del Día. </p><p><br></p><p>El Presidente del Directorio Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien preside asimismo la Asamblea, da comienzo a la reunión, con la presencia de dos accionistas, todos por si, tenedores de <strong>sesenta mil ( 12.000) acciones ordinarias</strong>, nominativas no endosables, de <strong>PESOS UNO ($1,00) valor nominal </strong>cada una y con derecho a un voto por acción, que representan la totalidad de las acciones en circulación manifestando que a continuación se dará lectura al punto primero del Orden del Día, que dice:</p><p><br></p><p>\"1) Designación de dos&nbsp;Accionistas para firmar el Acta:\" Al respecto, son designados para cumplir con tal requisito, el Señor&nbsp;<strong>XXXXXXXXXX</strong> y la Señora <strong>XXXXXXXXXX</strong>.</p><p><br></p><p> Luego de ello, se pasa a tratar el punto segundo: \"2) Consideración de la Memoria y Estados&nbsp;Contables al <strong>31 de diciembre de 2016\"</strong>&nbsp;Toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien manifiesta que habiendo analizado la documentación antes de ahora, en virtud de ello, se proceda a su aprobación sin más trámite. Puesta la moción a votación, la misma es aprobada unánimemente. </p><p><br></p><p>A continuación se pasa a tratar el punto tercero del Orden del Día, cuyo texto indica: \"3) Aprobación de la Gestión y Remuneración del Directorio.” Sobre el particular, toma la palabra el Señor&nbsp;<strong>XXXXXXXXXX</strong>, quien mociona para que en atención a la actividad desarrollada por la sociedad, se apruebe la Gestión del Directorio correspondiente al ejercicio bajo examen. Puesta la moción a votación, la misma es aprobada por unanimidad. Luego de ello, la Señora <strong>XXXXXXXXXX</strong>, mociona para que en atención a la labor desarrollada por el Directorio y en virtud de los resultados obtenidos en el ejercicio bajo examen, se asigne la suma de <strong>$ 12.500 ( pesos doce mil quinientos)</strong> al Señor <strong>XXXXXXXXXX</strong> en concepto de Honorarios al Directorio.Luego de haberse analizado la propuesta se pone la moción a votación y la misma es aprobada por unanimidad. </p><p><br></p><p>A continuación se pasa a tratar el punto cuarto del Orden del Día, que dice : 4)Distribución de los Resultados no Asignados al <strong>31 de diciembre de 2016</strong>.” Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2016 ascienden a $215.484,18 (doscientos quince mil cuatroscientos ochenta y cuatro con 18/100)</strong> se propone conformar una reserva Facultativa para futuras inversiones del negocio. La moción propuesta por el Señor <strong>XXXXXXXXXX</strong>, es aprobada por unanimidad. </p><p><br></p><p>Con lo que, habiéndose agotado el temario para el que fuere convocada esta Asamblea Anual Ordinaria de Accionistas y, previa rúbrica del presente acta por los accionistas designados para tal fin, se levanta la sesión siendo las 12:00.-&nbsp;&nbsp;</p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (4,'Aprobacion Balance SRL','<p><strong><u>ACTA REUNION DE SOCIOS Nº: 1</u></strong></p><p><br></p><p>En la ciudad autónoma de Buenos Aires, el día <strong>20 de Abril de 2018</strong> y siendo las 10:00Hs se reúnen en la sede social los socios de la sociedad que representan la totalidad del capital social&nbsp;y los votos de las mismas.</p><p><br></p><p>Preside la Reunión el Sr Gerente <strong>XXXXXXXXX</strong> . Tras constatar la existencia de Quórum el Sr Gerente declara abierto el acto&nbsp;y se pasa a considerar el primer punto de la orden del día;</p><p><br></p><p>1°) Designación de dos socios para firmar el acta. El Sr Gerente mociona que el acta sea firmado por el mismo&nbsp;y por el señor <strong>XXXXXXXXX</strong> .</p><p><br></p><p>A continuación se pasa a considerar el segundo punto de la orden del día: 2°) consideración de la documentación correspondiente en los artículos 62 a 67&nbsp;ley 19.550, sus modificaciones y complementarias correspondiente al ejercicio número <strong>13</strong>, iniciado&nbsp;el <strong>1 de Enero de 2017 y finalizado el 31 de Diciembre del 2017</strong>. Continuando en el uso de la palabra el Sr Gerente, quien informa a los socios que copias de dicha documentación, incluyendo inventario, el balance general y los estados de resultados, de evolución de patrimonio neto&nbsp;y el flujo de efectivo correspondiente al citado ejercicio ha sido distribuido a los señores socios para su conocimiento.</p><p><br></p><p>Luego de intercambiar opiniones, se dan por leídos&nbsp;y aprobado los documentos mencionados. Se pasa a&nbsp;considerar el tercer punto de la orden del día.&nbsp;3°)&nbsp;Consideración de los resultados&nbsp;del ejercicio&nbsp;informa el Sr gerente&nbsp;que, tal&nbsp;como surge de la documentación antes mencionada, el resultado del <strong>13</strong> ejercicio iniciado el <strong>1° de Enero de 2017 y finalizado el 31 de diciembre de 2017 arroja una ganancia de&nbsp;$ 3.069.662,71. </strong></p><p><br></p><p>Se pasa a considerar el cuarto y último&nbsp;punto de la orden del día 4°) Distribución de las utilidades&nbsp;al <strong>31 de diciembre de 2017</strong>: Sobre esta cuestión y en virtud de los resultados positivos acumulados por la sociedad, los que al <strong>31/12/2017 asciende&nbsp;a $ 5.110.936,49</strong> se propone la siguiente distribución:</p><p><br></p><ul><li>Honorarios Gerente&nbsp;$<strong>XXXXXXXXX.</strong></li><li>Distribución de Utilidades $<strong>XXXXXXXXX.</strong></li><li>Asignación de la Reserva Legal segun Ley.</li><li>Las utilidades pendientes de asignación se destina a una reserva para futura distribución de Dividendos.</li></ul><p><br></p><p>La misión propuesta por el Señor <strong>XXXXXXXXX</strong>, es aprobado por unanimidad.</p><p><br></p><p>Con los que, habiendo agotado el temario para el que fue convocada esta asamblea, se levanta&nbsp;la sesión siendo las 12:00.-&nbsp;</p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 1</strong></p><p><br></p><p><br></p><p><br></p><p><br></p><p>__________________</p><p><strong>FIRMA SOCIO 2</strong></p><p><br></p>','2019-06-25 14:49:03','2019-08-28 13:46:04',NULL);
INSERT INTO `actas_modelos` VALUES (5,'Declaracion de Domicilio Digital','<p><strong><u>ACTA DE REUNION DEL ORGANO DE ADMINISTRACION N° 1</u></strong></p><p><br></p><p>En la Ciudad de Buenos Aires, a los <strong>11 días del mes de marzo de 2019</strong>, siendo las 14hs se reúne en la sede social, de la sociedad <strong>XXXXXXXXX </strong>SAS, sitio en la calle <strong>XXXXXXXXX </strong>, los Administradores <strong>XXXXXXXXX </strong>, Con CUIT <strong>XXXXXXXXX y</strong> <strong>XXXXXXXXX </strong>, con CUIT <strong>XXXXXXXXX</strong>, que firman al pie de la presente. </p><p><br></p><p>Toma la palabra <strong>XXXXXXXXX</strong> e Informa que en cumplimiento de la resolución Nro. 6/2017 se informa en carácter de declaración jurada que los archivos digitales de <strong>XXXXXXXXX</strong> SAS quedaran a resguardo en:</p><p><br></p><ol><li>En la sede social, situada en <strong>XXXXXXXXX </strong>CABA</li><li>En Ramon Falcon 6835 4°B, CABA.</li><li>Google Drive, CABA@gmail.com, con Acceso al Mismo para todos Los administradores titular y suplente</li></ol><p><br></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 1</strong></p><p><br></p><p><br></p><p><br></p><p>_______________________</p><p><strong>FIRMA ADMINISTRADOR 2</strong></p>','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
INSERT INTO `actas_modelos` VALUES (6,'Certificacion Contable Deuda','<p class=\"ql-align-center\"><strong>CERTIFICACION CONTABLE DE DEUDA POR&nbsp;XXX</strong></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Señores Directores de</p><p class=\"ql-align-justify\">.………</p><p class=\"ql-align-justify\">CUIT………….</p><p class=\"ql-align-justify\">Domicilio legal C.A.B.A&nbsp;&nbsp;<strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong></p><p class=\"ql-align-justify\"><br></p><p>&nbsp;<strong>Explicación del alcance de una certificación</strong></p><p><br></p><p>En mi carácter de contador público, a su pedido, y para su presentación ante …………, emito la presente certificación conforme con lo dispuesto por las normas incluidas en la sección VI de la R.T. Nº 37 de la F.A.C.P.C.E.</p><p><br></p><p>La certificación se aplica a ciertas situaciones a través de la constatación con registros contables y otra documentación de respaldo. Este trabajo profesional no constituye una auditoría ni una revisión.</p><p class=\"ql-align-justify\"><br></p><p><strong>Detalle de lo que se certifica</strong></p><p><br></p><p class=\"ql-align-justify\">Declaración preparada por la sociedad, sobre la deuda de la misma con................ por $... …, originada en …………..</p><p class=\"ql-align-justify\"><br></p><p><strong>Alcance específico de la tarea realizada</strong></p><p><br></p><p>Mi tarea profesional se limitó únicamente a cotejar la información incluida en la declaración mencionada en el párrafo precedente, con la siguiente documentación: <em>(mencionar a continuación la documentación verificada)</em></p><p><br></p><p><em>*</em></p><p><em>*</em></p><p class=\"ql-align-justify\"><br></p><p><strong>Manifestación del contador </strong></p><p><br></p><p class=\"ql-align-justify\"><span style=\"background-color: yellow;\">Sobre la base de las tareas descriptas, certifico que la información individualizada en el párrafo “</span><strong style=\"background-color: yellow;\">Detalle de lo que se certifica”, </strong><span style=\"background-color: yellow;\">concuerda con la documentación respaldatoria y registros contables señalados en el párrafo precedente</span></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Buenos Aires,... de... de...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-center\">Dr. xxxxxxxxxxxxxx</p><p class=\"ql-align-center\">Contador Público (Universidad)</p><p class=\"ql-align-center\">C.P.C.E.C.A.B.A. T° ... F° ...</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">-------------------------------------------------------------------------------------------------------------------</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Modelo ilustrativo y de Aplicación no obligatoria.</p><p class=\"ql-align-justify\">·&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;El Contador Público determinará&nbsp;sobre la base de su criterio profesional el contenido y la redacción de la certificación.</p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p><strong style=\"color: black;\"><em>&nbsp;</em></strong><strong style=\"color: black; background-color: yellow;\"><em>(*)</em></strong><em style=\"color: black;\"> A partir del 1 de noviembre de 2007, en los Informes y Certificaciones se debe consignar expresamente el domicilio del ente según el siguiente detalle:</em></p><p><em style=\"color: darkslateblue;\">• Sociedades de Hecho y Empresas Unipersonales:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Fiscal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Demás Entes:</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Legal</em></strong><em style=\"color: black;\">.</em></p><p><em style=\"color: darkslateblue;\">• Personas Físicas (no empresa unipersonal):</em><em style=\"color: black;\">&nbsp;</em><strong style=\"color: black;\"><em>Domicilio Real</em></strong></p><p><br></p><p><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\"><br></p><p class=\"ql-align-justify\">Cert.cont.de deuda por importaciones.doc</p><p><br></p>','2019-06-28 20:22:21','2019-06-28 20:22:21',NULL);
/*!40000 ALTER TABLE `actas_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `actas_tipo`
--

DROP TABLE IF EXISTS `actas_tipo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actas_tipo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tipo` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `actas_tipo_tipo_unique` (`tipo`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actas_tipo`
--

LOCK TABLES `actas_tipo` WRITE;
/*!40000 ALTER TABLE `actas_tipo` DISABLE KEYS */;
INSERT INTO `actas_tipo` VALUES (1,'Inventario y Balance','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(2,'Libro Diario','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(3,'Registro de Acciones','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(4,'Acta de Directorio','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL),(5,'Acta de Asamblea','2019-06-25 14:49:03','2019-06-25 14:49:03',NULL);
/*!40000 ALTER TABLE `actas_tipo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `activities`
--

DROP TABLE IF EXISTS `activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_afip` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_cm` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activities`
--

LOCK TABLES `activities` WRITE;
/*!40000 ALTER TABLE `activities` DISABLE KEYS */;
INSERT INTO `activities` VALUES (1,NULL,'2021-04-06 13:10:06','Actividad Generica 1','000001',NULL),(2,NULL,'2021-04-06 13:10:06','Actividad Generica 2','000002',NULL),(3,NULL,NULL,'Actividad Generica 3','000003',NULL),(4,NULL,NULL,'Actividad Generica 4','000004',NULL),(5,NULL,NULL,'Cultivo de arroz','011111',NULL),(6,NULL,NULL,'Cultivo de trigo','011112',NULL),(7,NULL,NULL,'Cultivo de cereales n.c.p., excepto los de uso forrajero','011119',NULL),(8,NULL,NULL,'Cultivo de maíz','011121',NULL),(9,NULL,NULL,'Cultivo de cereales de uso forrajero n.c.p.','011129',NULL),(10,NULL,NULL,'Cultivo de pastos de uso forrajero','011130',NULL),(11,NULL,NULL,'Cultivo de soja','011211',NULL),(12,NULL,NULL,'Cultivo de girasol','011291',NULL),(13,NULL,NULL,'Cultivo de oleaginosas n.c.p. excepto soja y girasol','011299',NULL),(14,NULL,NULL,'Cultivo de papa, batata y mandioca','011310',NULL),(15,NULL,NULL,'Cultivo de tomate','011321',NULL),(16,NULL,NULL,'Cultivo de bulbos, brotes, raíces y hortalizas de fruto n.c.p.','011329',NULL),(17,NULL,NULL,'Cultivo de hortalizas de hoja y de otras hortalizas frescas','011331',NULL),(18,NULL,NULL,'Cultivo de legumbres frescas','011341',NULL),(19,NULL,NULL,'Cultivo de legumbres secas','011342',NULL),(20,NULL,NULL,'Cultivo de tabaco','011400',NULL),(21,NULL,NULL,'Cultivo de algodón','011501',NULL),(22,NULL,NULL,'Cultivo de plantas para la obtención de fibras n.c.p.','011509',NULL),(23,NULL,NULL,'Cultivo de flores','011911',NULL),(24,NULL,NULL,'Cultivo de plantas ornamentales','011912',NULL),(25,NULL,NULL,'Cultivos temporales n.c.p.','011990',NULL),(26,NULL,NULL,'Cultivo de vid para vinificar','012110',NULL),(27,NULL,NULL,'Cultivo de uva de mesa','012121',NULL),(28,NULL,NULL,'Cultivo de frutas cítricas','012200',NULL),(29,NULL,NULL,'Cultivo de manzana y pera','012311',NULL),(30,NULL,NULL,'Cultivo de frutas de pepita n.c.p.','012319',NULL),(31,NULL,NULL,'Cultivo de frutas de carozo','012320',NULL),(32,NULL,NULL,'Cultivo de frutas tropicales y subtropicales','012410',NULL),(33,NULL,NULL,'Cultivo de frutas secas','012420',NULL),(34,NULL,NULL,'Cultivo de frutas n.c.p.','012490',NULL),(35,NULL,NULL,'Cultivo de caña de azúcar','012510',NULL),(36,NULL,NULL,'Cultivo de plantas sacaríferas n.c.p.','012590',NULL),(37,NULL,NULL,'Cultivo de frutos oleaginosos','012600',NULL),(38,NULL,NULL,'Cultivo de yerba mate','012701',NULL),(39,NULL,NULL,'Cultivo de té y otras plantas cuyas hojas se utilizan para preparar infusiones','012709',NULL),(40,NULL,NULL,'Cultivo de especias y de plantas aromáticas y medicinales','012800',NULL),(41,NULL,NULL,'Cultivos perennes n.c.p.','012900',NULL),(42,NULL,NULL,'Producción de semillas híbridas de cereales y oleaginosas','013011',NULL),(43,NULL,NULL,'Producción de semillas varietales o autofecundadas de cereales, oleaginosas, y forrajeras','013012',NULL),(44,NULL,NULL,'Producción de semillas de hortalizas y legumbres, flores y plantas ornamentales y árboles frutales','013013',NULL),(45,NULL,NULL,'Producción de semillas de cultivos agrícolas n.c.p.','013019',NULL),(46,NULL,NULL,'Producción de otras formas de propagación de cultivos agrícolas','013020',NULL),(47,NULL,NULL,'Cría de ganado bovino, excepto la realizada en cabañas y para la producción de leche','014113',NULL),(48,NULL,NULL,'Invernada  de ganado bovino excepto el engorde en corrales (Feed-Lot)','014114',NULL),(49,NULL,NULL,'Engorde en corrales (Feed-Lot)','014115',NULL),(50,NULL,NULL,'Cría de ganado bovino realizada en cabañas','014121',NULL),(51,NULL,NULL,'Cría de ganado equino, excepto la realizada en haras','014211',NULL),(52,NULL,NULL,'Cría de camélidos','014300',NULL),(53,NULL,NULL,'Cría de ganado ovino -excepto en cabañas y para la  producción de lana y leche','014410',NULL),(54,NULL,NULL,'Cría de ganado ovino realizada en cabañas','014420',NULL),(55,NULL,NULL,'Cría de ganado caprino -excepto la realizada en cabañas y para producción de pelos y de leche','014430',NULL);
INSERT INTO `activities` VALUES (56,NULL,NULL,'Cría de ganado caprino realizada en cabañas','014440',NULL),(57,NULL,NULL,'Cría de ganado porcino, excepto la realizada en cabañas','014510',NULL),(58,NULL,NULL,'Cría de ganado porcino realizado en cabañas','014520',NULL),(59,NULL,NULL,'Producción de leche bovina','014610',NULL),(60,NULL,NULL,'Producción de leche de oveja y de cabra','014620',NULL),(61,NULL,NULL,'Producción de lana y pelo de oveja y cabra (cruda)','014710',NULL),(62,NULL,NULL,'Producción de pelos de ganado n.c.p.','014720',NULL),(63,NULL,NULL,'Cría de aves de corral, excepto para la producción de huevos','014810',NULL),(64,NULL,NULL,'Producción de huevos','014820',NULL),(65,NULL,NULL,'Apicultura','014910',NULL),(66,NULL,NULL,'Cunicultura','014920',NULL),(67,NULL,NULL,'Cría de animales pelíferos, pilíferos y plumíferos, excepto de las especies ganaderas','014930',NULL),(68,NULL,NULL,'Cría de animales y obtención de productos de origen animal, n.c.p.','014990',NULL),(69,NULL,NULL,'Servicios de labranza, siembra, transplante  y  cuidados culturales','016111',NULL),(70,NULL,NULL,'Servicios de pulverización, desinfección y fumigación terrestre','016112',NULL),(71,NULL,NULL,'Servicios de pulverización, desinfección y fumigación aérea','016113',NULL),(72,NULL,NULL,'Servicios de maquinaria agrícola n.c.p., excepto los de cosecha mecánica','016119',NULL),(73,NULL,NULL,'Servicios de cosecha mecánica','016120',NULL),(74,NULL,NULL,'Servicios de contratistas de mano de obra agrícola','016130',NULL),(75,NULL,NULL,'Servicios de post cosecha','016140',NULL),(76,NULL,NULL,'Servicios de procesamiento de semillas para su siembra','016150',NULL),(77,NULL,NULL,'Servicios de apoyo agrícolas n.c.p','016190',NULL),(78,NULL,NULL,'Inseminación artificial y servicios n.c.p. para mejorar la reproducción de los animales y el rendimiento de sus productos','016210',NULL),(79,NULL,NULL,'Servicios de contratistas de mano de obra pecuaria','016220',NULL),(80,NULL,NULL,'Servicios de esquila de animales','016230',NULL),(81,NULL,NULL,'Servicios para el control de plagas, baños parasiticidas, etc.','016291',NULL),(82,NULL,NULL,'Albergue y cuidado de  animales de terceros','016292',NULL),(83,NULL,NULL,'Servicios de apoyo pecuarios n.c.p.','016299',NULL),(84,NULL,NULL,'Caza y repoblación  de animales de caza','017010',NULL),(85,NULL,NULL,'Servicios de apoyo para la caza','017020',NULL),(86,NULL,NULL,'Plantación de bosques','021010',NULL),(87,NULL,NULL,'Repoblación y conservación de bosques nativos y zonas forestadas','021020',NULL),(88,NULL,NULL,'Explotación de viveros forestales','021030',NULL),(89,NULL,NULL,'Extracción de productos forestales de bosques cultivados','022010',NULL),(90,NULL,NULL,'Extracción de productos forestales de bosques nativos','022020',NULL),(91,NULL,NULL,'Servicios forestales para la extracción de madera','024010',NULL),(92,NULL,NULL,'Servicios forestales excepto los servicios para la extracción de madera','024020',NULL),(93,NULL,NULL,'Pesca de organismos marinos, excepto cuando es realizada en buques procesadores','031110',NULL),(94,NULL,NULL,'Pesca y elaboración de productos marinos realizada a bordo de buques procesadores','031120',NULL),(95,NULL,NULL,'Recolección de organismos marinos excepto peces, crustáceos y moluscos','031130',NULL),(96,NULL,NULL,'Pesca continental: fluvial y lacustre','031200',NULL),(97,NULL,NULL,'Servicios de apoyo para la pesca','031300',NULL),(98,NULL,NULL,'Explotación de criaderos de peces, granjas piscícolas y otros frutos acuáticos  (acuicultura)','032000',NULL),(99,NULL,NULL,'Extracción y aglomeración de carbón','051000',NULL),(100,NULL,NULL,'Extracción y aglomeración de lignito','052000',NULL),(101,NULL,NULL,'Extracción de petróleo crudo','061000',NULL),(102,NULL,NULL,'Extracción de gas natural','062000',NULL),(103,NULL,NULL,'Extracción de minerales de hierro','071000',NULL),(104,NULL,NULL,'Extracción de minerales y concentrados de uranio y torio','072100',NULL);
INSERT INTO `activities` VALUES (105,NULL,NULL,'Extracción de metales preciosos','072910',NULL),(106,NULL,NULL,'Extracción de minerales metalíferos no ferrosos n.c.p., excepto minerales de uranio y torio','072990',NULL),(107,NULL,NULL,'Extracción de rocas ornamentales','081100',NULL),(108,NULL,NULL,'Extracción de piedra caliza y yeso','081200',NULL),(109,NULL,NULL,'Extracción de arenas, canto rodado y triturados pétreos','081300',NULL),(110,NULL,NULL,'Extracción de arcilla y caolín','081400',NULL),(111,NULL,NULL,'Extracción de minerales para la fabricación de abonos excepto turba','089110',NULL),(112,NULL,NULL,'Extracción de minerales para la fabricación de productos químicos','089120',NULL),(113,NULL,NULL,'Extracción y aglomeración de turba','089200',NULL),(114,NULL,NULL,'Extracción de sal','089300',NULL),(115,NULL,NULL,'Explotación de minas y canteras n.c.p.','089900',NULL),(116,NULL,NULL,'Servicios de apoyo para la extracción de petróleo y gas natural','091000',NULL),(117,NULL,NULL,'Servicios de apoyo para la minería, excepto para la extracción de petróleo y gas natual','099000',NULL),(118,NULL,NULL,'Matanza de ganado bovino','101011',NULL),(119,NULL,NULL,'Procesamiento de carne de ganado bovino','101012',NULL),(120,NULL,NULL,'Saladero y peladero de cueros de ganado bovino','101013',NULL),(121,NULL,NULL,'Producción y procesamiento de carne de aves','101020',NULL),(122,NULL,NULL,'Elaboración de fiambres y embutidos','101030',NULL),(123,NULL,NULL,'Matanza de ganado excepto el bovino y procesamiento de su carne','101040',NULL),(124,NULL,NULL,'Fabricación de aceites y grasas de origen animal','101091',NULL),(125,NULL,NULL,'Matanza de animales n.c.p. y procesamiento de su carne, elaboración de subproductos cárnicos n.c.p.','101099',NULL),(126,NULL,NULL,'Elaboración de pescados de mar, crustáceos y  productos marinos','102001',NULL),(127,NULL,NULL,'Elaboración de pescados de ríos y lagunas y otros productos fluviales y lacustres','102002',NULL),(128,NULL,NULL,'Fabricación de aceites, grasas, harinas y productos a base de pescados','102003',NULL),(129,NULL,NULL,'Preparación de conservas de frutas, hortalizas y legumbres','103011',NULL),(130,NULL,NULL,'Elaboración y envasado de dulces, mermeladas y jaleas','103012',NULL),(131,NULL,NULL,'Elaboración de jugos naturales y sus concentrados, de frutas, hortalizas y legumbres','103020',NULL),(132,NULL,NULL,'Elaboración de frutas, hortalizas y legumbres congeladas','103030',NULL),(133,NULL,NULL,'Elaboración de hortalizas y legumbres deshidratadas o desecadas, preparación n.c.p. de hortalizas y legumbres','103091',NULL),(134,NULL,NULL,'Elaboración de frutas deshidratadas o desecadas, preparación n.c.p. de frutas','103099',NULL),(135,NULL,NULL,'Elaboración de aceites y grasas vegetales  sin refinar','104011',NULL),(136,NULL,NULL,'Elaboración de aceite de oliva','104012',NULL),(137,NULL,NULL,'Elaboración de aceites y grasas vegetales refinados','104013',NULL),(138,NULL,NULL,'Elaboración de margarinas y grasas vegetales comestibles similares','104020',NULL),(139,NULL,NULL,'Elaboración de leches y productos lácteos deshidratados','105010',NULL),(140,NULL,NULL,'Elaboración de quesos','105020',NULL),(141,NULL,NULL,'Elaboración industrial de helados','105030',NULL),(142,NULL,NULL,'Elaboración de productos lácteos n.c.p.','105090',NULL),(143,NULL,NULL,'Molienda de trigo','106110',NULL),(144,NULL,NULL,'Preparación de arroz','106120',NULL),(145,NULL,NULL,'Elaboración de alimentos a base de cereales','106131',NULL),(146,NULL,NULL,'Preparación y molienda de legumbres y cereales n.c.p., excepto trigo y arroz y molienda húmeda de maíz','106139',NULL),(147,NULL,NULL,'Elaboración de almidones y productos derivados del almidón, molienda húmeda de maíz','106200',NULL),(148,NULL,NULL,'Elaboración de galletitas y bizcochos','107110',NULL),(149,NULL,NULL,'Elaboración industrial de productos de panadería, excepto galletitas y bizcochos','107121',NULL);
INSERT INTO `activities` VALUES (150,NULL,NULL,'Elaboración de productos de panadería n.c.p.','107129',NULL),(151,NULL,NULL,'Elaboración de azúcar','107200',NULL),(152,NULL,NULL,'Elaboración de cacao y chocolate','107301',NULL),(153,NULL,NULL,'Elaboración de productos de confitería n.c.p.','107309',NULL),(154,NULL,NULL,'Elaboración de pastas alimentarias frescas','107410',NULL),(155,NULL,NULL,'Elaboración de pastas alimentarias secas','107420',NULL),(156,NULL,NULL,'Elaboración de comidas preparadas para reventa','107500',NULL),(157,NULL,NULL,'Tostado, torrado y molienda de café','107911',NULL),(158,NULL,NULL,'Elaboración y molienda de hierbas aromáticas y  especias','107912',NULL),(159,NULL,NULL,'Preparación de hojas de té','107920',NULL),(160,NULL,NULL,'Elaboración de yerba mate','107930',NULL),(161,NULL,NULL,'Elaboración de extractos, jarabes y concentrados','107991',NULL),(162,NULL,NULL,'Elaboración de vinagres','107992',NULL),(163,NULL,NULL,'Elaboración de productos alimenticios n.c.p.','107999',NULL),(164,NULL,NULL,'Elaboración de alimentos preparados para animales','108000',NULL),(165,NULL,NULL,'Servicios industriales para la elaboración de alimentos y bebidas','109000',NULL),(166,NULL,NULL,'Destilación, rectificación y mezcla de bebidas espiritosas','110100',NULL),(167,NULL,NULL,'Elaboración de mosto','110211',NULL),(168,NULL,NULL,'Elaboración de vinos','110212',NULL),(169,NULL,NULL,'Elaboración de sidra y otras bebidas alcohólicas fermentadas','110290',NULL),(170,NULL,NULL,'Elaboración de cerveza, bebidas malteadas y malta','110300',NULL),(171,NULL,NULL,'Embotellado de aguas naturales y minerales','110411',NULL),(172,NULL,NULL,'Fabricación de sodas','110412',NULL),(173,NULL,NULL,'Elaboración de bebidas gaseosas, excepto soda','110420',NULL),(174,NULL,NULL,'Elaboración de hielo','110491',NULL),(175,NULL,NULL,'Elaboración de bebidas no alcohólicas n.c.p.','110492',NULL),(176,NULL,NULL,'Preparación de hojas de tabaco','120010',NULL),(177,NULL,NULL,'Elaboración de cigarrillos','120091',NULL),(178,NULL,NULL,'Elaboración de productos de tabaco n.c.p.','120099',NULL),(179,NULL,NULL,'Preparación de fibras textiles vegetales, desmotado de algodón','131110',NULL),(180,NULL,NULL,'Preparación de fibras animales de uso textil','131120',NULL),(181,NULL,NULL,'Fabricación de hilados textiles de lana, pelos y sus mezclas','131131',NULL),(182,NULL,NULL,'Fabricación de hilados textiles de algodón y sus mezclas','131132',NULL),(183,NULL,NULL,'Fabricación de hilados textiles n.c.p., excepto de lana  y de algodón','131139',NULL),(184,NULL,NULL,'Fabricación de tejidos (telas) planos de lana y sus mezclas, incluye hilanderías y tejedurías integradas','131201',NULL),(185,NULL,NULL,'Fabricación de tejidos (telas) planos de algodón y sus mezclas, incluye hilanderías y tejedurías integradas','131202',NULL),(186,NULL,NULL,'Fabricación de tejidos (telas) planos de fibras textiles n.c.p., incluye hilanderías y tejedurías integradas','131209',NULL),(187,NULL,NULL,'Acabado de productos textiles','131300',NULL),(188,NULL,NULL,'Fabricación de tejidos de punto','139100',NULL),(189,NULL,NULL,'Fabricación de frazadas, mantas, ponchos, colchas, cobertores, etc.','139201',NULL),(190,NULL,NULL,'Fabricación de ropa de cama y mantelería','139202',NULL),(191,NULL,NULL,'Fabricación de artículos de lona y sucedáneos de lona','139203',NULL),(192,NULL,NULL,'Fabricación de bolsas de materiales textiles para productos a granel','139204',NULL),(193,NULL,NULL,'Fabricación de artículos confeccionados de materiales textiles n.c.p., excepto prendas de vestir','139209',NULL),(194,NULL,NULL,'Fabricación de tapices y alfombras','139300',NULL),(195,NULL,NULL,'Fabricación de cuerdas, cordeles, bramantes y redes','139400',NULL),(196,NULL,NULL,'Fabricación de productos textiles n.c.p.','139900',NULL),(197,NULL,NULL,'Confección de ropa interior, prendas para dormir y para la playa','141110',NULL);
INSERT INTO `activities` VALUES (198,NULL,NULL,'Confección de ropa de trabajo, uniformes y guardapolvos','141120',NULL),(199,NULL,NULL,'Confección de prendas de vestir para bebés y niños','141130',NULL),(200,NULL,NULL,'Confección de prendas deportivas','141140',NULL),(201,NULL,NULL,'Fabricación de accesorios de vestir excepto de cuero','141191',NULL),(202,NULL,NULL,'Confección de prendas de vestir n.c.p., excepto prendas de piel, cuero y de punto','141199',NULL),(203,NULL,NULL,'Fabricación de accesorios de vestir de cuero','141201',NULL),(204,NULL,NULL,'Confección de prendas de vestir de cuero','141202',NULL),(205,NULL,NULL,'Terminación y teñido de pieles, fabricación de artículos de piel','142000',NULL),(206,NULL,NULL,'Fabricación de medias','143010',NULL),(207,NULL,NULL,'Fabricación de prendas de vestir y artículos similares de punto','143020',NULL),(208,NULL,NULL,'Servicios industriales para la industria confeccionista','149000',NULL),(209,NULL,NULL,'Curtido y terminación de cueros','151100',NULL),(210,NULL,NULL,'Fabricación de maletas, bolsos de mano y similares, artículos de talabartería y artículos de cuero n.c.p.','151200',NULL),(211,NULL,NULL,'Fabricación de calzado de cuero, excepto calzado deportivo y ortopédico','152011',NULL),(212,NULL,NULL,'Fabricación de calzado de materiales n.c.p., excepto calzado deportivo y ortopédico','152021',NULL),(213,NULL,NULL,'Fabricación de calzado deportivo','152031',NULL),(214,NULL,NULL,'Fabricación de partes de calzado','152040',NULL),(215,NULL,NULL,'Aserrado y cepillado de madera  nativa','161001',NULL),(216,NULL,NULL,'Aserrado y cepillado de madera implantada','161002',NULL),(217,NULL,NULL,'Fabricación de hojas de madera para enchapado, fabricación de tableros contrachapados, tableros laminados, tableros de partículas y tableros y paneles n.c.p.','162100',NULL),(218,NULL,NULL,'Fabricación de aberturas y estructuras de madera para la construcción','162201',NULL),(219,NULL,NULL,'Fabricación de viviendas prefabricadas de madera','162202',NULL),(220,NULL,NULL,'Fabricación de recipientes de madera','162300',NULL),(221,NULL,NULL,'Fabricación de ataúdes','162901',NULL),(222,NULL,NULL,'Fabricación de artículos de madera en tornerías','162902',NULL),(223,NULL,NULL,'Fabricación de productos de corcho','162903',NULL),(224,NULL,NULL,'Fabricación de productos de madera n.c.p, fabricación de artículos de paja y materiales trenzables','162909',NULL),(225,NULL,NULL,'Fabricación de pasta de madera','170101',NULL),(226,NULL,NULL,'Fabricación de papel y cartón excepto envases','170102',NULL),(227,NULL,NULL,'Fabricación de papel ondulado y envases de papel','170201',NULL),(228,NULL,NULL,'Fabricación de cartón ondulado y envases de cartón','170202',NULL),(229,NULL,NULL,'Fabricación de artículos de papel y cartón de uso doméstico e higiénico sanitario','170910',NULL),(230,NULL,NULL,'Fabricación de artículos de papel y cartón n.c.p.','170990',NULL),(231,NULL,NULL,'Impresión de diarios y revistas','181101',NULL),(232,NULL,NULL,'Impresión n.c.p., excepto de diarios y revistas','181109',NULL),(233,NULL,NULL,'Servicios relacionados con la impresión','181200',NULL),(234,NULL,NULL,'Reproducción de grabaciones','182000',NULL),(235,NULL,NULL,'Fabricación de productos de hornos de coque','191000',NULL),(236,NULL,NULL,'Fabricación de productos de la refinación del petróleo','192000',NULL),(237,NULL,NULL,'Fabricación de gases industriales y medicinales comprimidos o licuados','201110',NULL),(238,NULL,NULL,'Fabricación de curtientes naturales y sintéticos','201120',NULL),(239,NULL,NULL,'Fabricación de materias colorantes básicas, excepto pigmentos preparados','201130',NULL),(240,NULL,NULL,'Fabricación de combustible nuclear, sustancias y materiales radiactivos','201140',NULL),(241,NULL,NULL,'Fabricación de materias químicas inorgánicas básicas n.c.p.','201180',NULL),(242,NULL,NULL,'Fabricación de materias químicas orgánicas básicas n.c.p.','201190',NULL);
INSERT INTO `activities` VALUES (243,NULL,NULL,'Fabricación de alcohol','201210',NULL),(244,NULL,NULL,'Fabricación de biocombustibles excepto alcohol','201220',NULL),(245,NULL,NULL,'Fabricación de abonos y compuestos de nitrógeno','201300',NULL),(246,NULL,NULL,'Fabricación de resinas y cauchos sintéticos','201401',NULL),(247,NULL,NULL,'Fabricación de materias plásticas en formas primarias n.c.p.','201409',NULL),(248,NULL,NULL,'Fabricación de insecticidas, plaguicidas y  productos químicos de uso agropecuario','202101',NULL),(249,NULL,NULL,'Fabricación de pinturas, barnices y productos de revestimiento similares, tintas de imprenta y masillas','202200',NULL),(250,NULL,NULL,'Fabricación de preparados para limpieza, pulido y saneamiento','202311',NULL),(251,NULL,NULL,'Fabricación de jabones y detergentes','202312',NULL),(252,NULL,NULL,'Fabricación de cosméticos, perfumes y  productos de higiene y tocador','202320',NULL),(253,NULL,NULL,'Fabricación de explosivos y productos de pirotecnia','202906',NULL),(254,NULL,NULL,'Fabricación de colas, adhesivos, aprestos y cementos excepto los odontológicos obtenidos de sustancias minerales y vegetales','202907',NULL),(255,NULL,NULL,'Fabricación de productos químicos n.c.p.','202908',NULL),(256,NULL,NULL,'Fabricación de fibras manufacturadas','203000',NULL),(257,NULL,NULL,'Servicios industriales para la fabricación de sustancias y productos químicos','204000',NULL),(258,NULL,NULL,'Fabricación de medicamentos de uso humano y productos farmacéuticos','210010',NULL),(259,NULL,NULL,'Fabricación de medicamentos de uso veterinario','210020',NULL),(260,NULL,NULL,'Fabricación de sustancias químicas para la elaboración de medicamentos','210030',NULL),(261,NULL,NULL,'Fabricación de productos de laboratorio y productos botánicos de uso farmaceútico n.c.p.','210090',NULL),(262,NULL,NULL,'Fabricación de cubiertas y cámaras','221110',NULL),(263,NULL,NULL,'Recauchutado y renovación de cubiertas','221120',NULL),(264,NULL,NULL,'Fabricación de  autopartes de caucho excepto cámaras y cubiertas','221901',NULL),(265,NULL,NULL,'Fabricación  de productos de caucho n.c.p.','221909',NULL),(266,NULL,NULL,'Fabricación de envases plásticos','222010',NULL),(267,NULL,NULL,'Fabricación de productos plásticos en formas básicas y artículos de plástico n.c.p., excepto muebles','222090',NULL),(268,NULL,NULL,'Fabricación de envases de vidrio','231010',NULL),(269,NULL,NULL,'Fabricación y elaboración de vidrio plano','231020',NULL),(270,NULL,NULL,'Fabricación de productos de vidrio n.c.p.','231090',NULL),(271,NULL,NULL,'Fabricación de productos de cerámica refractaria','239100',NULL),(272,NULL,NULL,'Fabricación de ladrillos','239201',NULL),(273,NULL,NULL,'Fabricación de revestimientos cerámicos','239202',NULL),(274,NULL,NULL,'Fabricación de productos de arcilla y cerámica no refractaria para uso estructural n.c.p.','239209',NULL),(275,NULL,NULL,'Fabricación de artículos sanitarios de cerámica','239310',NULL),(276,NULL,NULL,'Fabricación de objetos cerámicos para uso doméstico excepto artefactos sanitarios','239391',NULL),(277,NULL,NULL,'Fabricación de artículos de cerámica no refractaria para uso no estructural n.c.p.','239399',NULL),(278,NULL,NULL,'Elaboración de cemento','239410',NULL),(279,NULL,NULL,'Elaboración de  yeso','239421',NULL),(280,NULL,NULL,'Elaboración de cal','239422',NULL),(281,NULL,NULL,'Fabricación de mosaicos','239510',NULL),(282,NULL,NULL,'Elaboración de hormigón','239591',NULL),(283,NULL,NULL,'Fabricación de premoldeadas para la construcción','239592',NULL),(284,NULL,NULL,'Fabricación de artículos de cemento, fibrocemento y yeso excepto hormigón y mosaicos','239593',NULL),(285,NULL,NULL,'Corte, tallado y acabado de la piedra','239600',NULL),(286,NULL,NULL,'Fabricación de productos minerales no metálicos n.c.p.','239900',NULL),(287,NULL,NULL,'Laminación y estirado. Producción de lingotes, planchas o barras fabricadas por operadores independientes','241001',NULL);
INSERT INTO `activities` VALUES (288,NULL,NULL,'Fabricación en industrias básicas de productos de hierro y acero n.c.p.','241009',NULL),(289,NULL,NULL,'Elaboración de aluminio primario y semielaborados de aluminio','242010',NULL),(290,NULL,NULL,'Fabricación de productos primarios de metales preciosos y metales no ferrosos n.c.p. y sus semielaborados','242090',NULL),(291,NULL,NULL,'Fundición de hierro y acero','243100',NULL),(292,NULL,NULL,'Fundición de metales no ferrosos','243200',NULL),(293,NULL,NULL,'Fabricación de carpintería metálica','251101',NULL),(294,NULL,NULL,'Fabricación de productos metálicos para uso estructural','251102',NULL),(295,NULL,NULL,'Fabricación de tanques, depósitos y recipientes de metal','251200',NULL),(296,NULL,NULL,'Fabricación de generadores de vapor','251300',NULL),(297,NULL,NULL,'Fabricación de armas y municiones','252000',NULL),(298,NULL,NULL,'Forjado, prensado, estampado y laminado de metales, pulvimetalurgia','259100',NULL),(299,NULL,NULL,'Tratamiento y revestimiento de metales y trabajos de metales en general','259200',NULL),(300,NULL,NULL,'Fabricación de herramientas manuales y sus accesorios','259301',NULL),(301,NULL,NULL,'Fabricación de artículos de cuchillería y utensillos de mesa y de cocina','259302',NULL),(302,NULL,NULL,'Fabricación de cerraduras, herrajes y artículos de ferretería n.c.p.','259309',NULL),(303,NULL,NULL,'Fabricación de envases metálicos','259910',NULL),(304,NULL,NULL,'Fabricación de tejidos de alambre','259991',NULL),(305,NULL,NULL,'Fabricación de cajas de seguridad','259992',NULL),(306,NULL,NULL,'Fabricación de productos metálicos de tornería y/o matricería','259993',NULL),(307,NULL,NULL,'Fabricación de productos elaborados de metal n.c.p.','259999',NULL),(308,NULL,NULL,'Fabricación de componentes electrónicos','261000',NULL),(309,NULL,NULL,'Fabricación de equipos y productos informáticos','262000',NULL),(310,NULL,NULL,'Fabricación  de equipos de comunicaciones y transmisores de radio y televisión','263000',NULL),(311,NULL,NULL,'Fabricación de receptores de radio y televisión, aparatos de grabación y reproducción de sonido y video, y productos conexos','264000',NULL),(312,NULL,NULL,'Fabricación de instrumentos y aparatos para medir, verificar, ensayar, navegar y otros fines, excepto el equipo de control de procesos industriales','265101',NULL),(313,NULL,NULL,'Fabricación de equipo de control de procesos industriales','265102',NULL),(314,NULL,NULL,'Fabricación de relojes','265200',NULL),(315,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos principalmente electrónicos y/o eléctricos','266010',NULL),(316,NULL,NULL,'Fabricación de equipo médico y quirúrgico y de aparatos ortopédicos n.c.p.','266090',NULL),(317,NULL,NULL,'Fabricación de equipamiento e instrumentos ópticos y sus accesorios','267001',NULL),(318,NULL,NULL,'Fabricación de aparatos y accesorios para fotografía excepto películas, placas y papeles sensibles','267002',NULL),(319,NULL,NULL,'Fabricación de soportes ópticos y magnéticos','268000',NULL),(320,NULL,NULL,'Fabricación de motores, generadores y transformadores eléctricos','271010',NULL),(321,NULL,NULL,'Fabricación de aparatos de distribución y control de la energía eléctrica','271020',NULL),(322,NULL,NULL,'Fabricación de acumuladores, pilas y baterías primarias','272000',NULL),(323,NULL,NULL,'Fabricación de cables de fibra óptica','273110',NULL),(324,NULL,NULL,'Fabricación de hilos y cables aislados n.c.p.','273190',NULL),(325,NULL,NULL,'Fabricación de lámparas eléctricas y equipo de iluminación','274000',NULL),(326,NULL,NULL,'Fabricación de cocinas, calefones, estufas y calefactores no eléctricos','275010',NULL),(327,NULL,NULL,'Fabricación de heladeras, freezers, lavarropas y secarropas','275020',NULL),(328,NULL,NULL,'Fabricación de ventiladores, extractores de aire, aspiradoras y similares','275091',NULL);
INSERT INTO `activities` VALUES (329,NULL,NULL,'Fabricación de planchas, calefactores, hornos eléctricos, tostadoras y otros aparatos generadores de calor','275092',NULL),(330,NULL,NULL,'Fabricación de aparatos de uso doméstico n.c.p.','275099',NULL),(331,NULL,NULL,'Fabricación  de equipo eléctrico n.c.p.','279000',NULL),(332,NULL,NULL,'Fabricación  de  motores  y  turbinas,  excepto  motores  para aeronaves, vehículos automotores   y motocicletas','281100',NULL),(333,NULL,NULL,'Fabricación de bombas','281201',NULL),(334,NULL,NULL,'Fabricación de compresores, grifos y válvulas','281301',NULL),(335,NULL,NULL,'Fabricación de cojinetes, engranajes, trenes de engranaje y piezas de transmisión','281400',NULL),(336,NULL,NULL,'Fabricación de hornos, hogares y quemadores','281500',NULL),(337,NULL,NULL,'Fabricación de maquinaria y equipo de elevación y manipulación','281600',NULL),(338,NULL,NULL,'Fabricación de maquinaria y equipo de oficina, excepto equipo informático','281700',NULL),(339,NULL,NULL,'Fabricación de  maquinaria y equipo de uso general n.c.p.','281900',NULL),(340,NULL,NULL,'Fabricación de tractores','282110',NULL),(341,NULL,NULL,'Fabricación de maquinaria y equipo de uso agropecuario y forestal','282120',NULL),(342,NULL,NULL,'Fabricación de implementos de uso agropecuario','282130',NULL),(343,NULL,NULL,'Fabricación de máquinas herramienta','282200',NULL),(344,NULL,NULL,'Fabricación de maquinaria metalúrgica','282300',NULL),(345,NULL,NULL,'Fabricación de maquinaria para la explotación de minas y canteras y para obras de construcción','282400',NULL),(346,NULL,NULL,'Fabricación de maquinaria para la elaboración de alimentos, bebidas y tabaco','282500',NULL),(347,NULL,NULL,'Fabricación de maquinaria para la elaboración de productos textiles, prendas de vestir y cueros','282600',NULL),(348,NULL,NULL,'Fabricación de maquinaria para la industria del papel y las artes gráficas','282901',NULL),(349,NULL,NULL,'Fabricación de maquinaria y equipo de uso especial n.c.p.','282909',NULL),(350,NULL,NULL,'Fabricación de vehículos automotores','291000',NULL),(351,NULL,NULL,'Fabricación de carrocerías para vehículos automotores, fabricación de remolques y semirremolques','292000',NULL),(352,NULL,NULL,'Rectificación de motores','293011',NULL),(353,NULL,NULL,'Fabricación de partes, piezas y accesorios para vehículos automotores y sus motores n.c.p.','293090',NULL),(354,NULL,NULL,'Construcción y reparación de buques','301100',NULL),(355,NULL,NULL,'Construcción y reparación de embarcaciones de recreo y deporte','301200',NULL),(356,NULL,NULL,'Fabricación y reparación de locomotoras y de material rodante para transporte ferroviario','302000',NULL),(357,NULL,NULL,'Fabricación y reparación de aeronaves','303000',NULL),(358,NULL,NULL,'Fabricación de motocicletas','309100',NULL),(359,NULL,NULL,'Fabricación de bicicletas y de sillones de ruedas ortopédicos','309200',NULL),(360,NULL,NULL,'Fabricación de equipo de transporte n.c.p.','309900',NULL),(361,NULL,NULL,'Fabricación de muebles y partes de muebles, principalmente de madera','310010',NULL),(362,NULL,NULL,'Fabricación de muebles y partes de muebles, excepto los que son principalmente de madera (metal, plástico, etc.)','310020',NULL),(363,NULL,NULL,'Fabricación de somieres y colchones','310030',NULL),(364,NULL,NULL,'Fabricación de joyas finas y artículos conexos','321011',NULL),(365,NULL,NULL,'Fabricación de objetos de platería','321012',NULL),(366,NULL,NULL,'Fabricación de bijouterie','321020',NULL),(367,NULL,NULL,'Fabricación de instrumentos de música','322001',NULL),(368,NULL,NULL,'Fabricación de artículos de deporte','323001',NULL),(369,NULL,NULL,'Fabricación de juegos y juguetes','324000',NULL),(370,NULL,NULL,'Fabricación de lápices, lapiceras,  bolígrafos, sellos y artículos similares para oficinas y artistas','329010',NULL),(371,NULL,NULL,'Fabricación de escobas, cepillos y pinceles','329020',NULL);
INSERT INTO `activities` VALUES (372,NULL,NULL,'Fabricación de carteles, señales e indicadores  -eléctricos o no-','329030',NULL),(373,NULL,NULL,'Fabricación de equipo de protección y seguridad, excepto calzado','329040',NULL),(374,NULL,NULL,'Industrias manufactureras n.c.p.','329090',NULL),(375,NULL,NULL,'Reparación y mantenimiento de productos de metal, excepto maquinaria y equipo','331101',NULL),(376,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso general','331210',NULL),(377,NULL,NULL,'Reparación y mantenimiento de maquinaria y equipo de uso agropecuario y forestal','331220',NULL),(378,NULL,NULL,'Reparación y mantenimiento de maquinaria de uso especial n.c.p.','331290',NULL),(379,NULL,NULL,'Reparación y mantenimiento de maquinaria y aparatos eléctricos','331400',NULL),(380,NULL,NULL,'Reparación y mantenimiento de máquinas y equipo n.c.p.','331900',NULL),(381,NULL,NULL,'Instalación de maquinaria y equipos industriales','332000',NULL),(382,NULL,NULL,'Generación de energía térmica convencional','351110',NULL),(383,NULL,NULL,'Generación de energía térmica nuclear','351120',NULL),(384,NULL,NULL,'Generación de energía hidráulica','351130',NULL),(385,NULL,NULL,'Generación de energía n.c.p.','351190',NULL),(386,NULL,NULL,'Transporte de energía eléctrica','351201',NULL),(387,NULL,NULL,'Comercio mayorista de energía eléctrica','351310',NULL),(388,NULL,NULL,'Distribución de energía eléctrica','351320',NULL),(389,NULL,NULL,'Fabricación de gas y procesamiento de gas natural','352010',NULL),(390,NULL,NULL,'Distribución de combustibles gaseosos por tuberías','352020',NULL),(391,NULL,NULL,'Suministro de vapor y aire acondicionado','353001',NULL),(392,NULL,NULL,'Captación, depuración y distribución de agua de fuentes subterráneas','360010',NULL),(393,NULL,NULL,'Captación, depuración y distribución de agua de fuentes superficiales','360020',NULL),(394,NULL,NULL,'Servicios de depuración de aguas residuales, alcantarillado y cloacas','370000',NULL),(395,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos no peligrosos','381100',NULL),(396,NULL,NULL,'Recolección, transporte, tratamiento y disposición final de residuos peligrosos','381200',NULL),(397,NULL,NULL,'Recuperación de materiales y desechos metálicos','382010',NULL),(398,NULL,NULL,'Recuperación de materiales y desechos no metálicos','382020',NULL),(399,NULL,NULL,'Descontaminación y otros servicios de gestión de residuos','390000',NULL),(400,NULL,NULL,'Construcción, reforma y reparación de edificios residenciales','410011',NULL),(401,NULL,NULL,'Construcción, reforma y reparación de edificios no residenciales','410021',NULL),(402,NULL,NULL,'Construcción, reforma y reparación de obras de infraestructura para el transporte','421000',NULL),(403,NULL,NULL,'Perforación de pozos de agua','422100',NULL),(404,NULL,NULL,'Construcción, reforma y reparación de redes distribución de electricidad, gas, agua, telecomunicaciones y de otros servicios públicos','422200',NULL),(405,NULL,NULL,'Construcción, reforma y reparación de obras hidráulicas','429010',NULL),(406,NULL,NULL,'Construcción de obras de ingeniería civil n.c.p.','429090',NULL),(407,NULL,NULL,'Demolición y voladura de edificios y de sus partes','431100',NULL),(408,NULL,NULL,'Movimiento de suelos y preparación de terrenos para obras','431210',NULL),(409,NULL,NULL,'Instalación de sistemas de iluminación, control y señalización eléctrica para el transporte','432110',NULL),(410,NULL,NULL,'Instalación, ejecución y mantenimiento de instalaciones eléctricas, electromecánicas y electrónicas n.c.p.','432190',NULL),(411,NULL,NULL,'Instalaciones de gas, agua, sanitarios y de climatización, con sus artefactos conexos','432200',NULL),(412,NULL,NULL,'Instalaciones de ascensores, montacargas y  escaleras mecánicas','432910',NULL),(413,NULL,NULL,'Aislamiento térmico, acústico, hídrico y antivibratorio','432920',NULL);
INSERT INTO `activities` VALUES (414,NULL,NULL,'Instalaciones para edificios y obras de ingeniería civil n.c.p.','432990',NULL),(415,NULL,NULL,'Instalaciones de carpintería, herrería de obra y artística','433010',NULL),(416,NULL,NULL,'Terminación y revestimiento de paredes y pisos','433020',NULL),(417,NULL,NULL,'Colocación de cristales en obra','433030',NULL),(418,NULL,NULL,'Pintura y trabajos de decoración','433040',NULL),(419,NULL,NULL,'Terminación de edificios n.c.p.','433090',NULL),(420,NULL,NULL,'Alquiler de equipo de construcción o demolición dotado de operarios','439100',NULL),(421,NULL,NULL,'Hincado de pilotes, cimentación y otros trabajos de hormigón armado','439910',NULL),(422,NULL,NULL,'Actividades especializadas de construcción n.c.p.','439990',NULL),(423,NULL,NULL,'Venta de autos, camionetas y utilitarios nuevos','451110',NULL),(424,NULL,NULL,'Venta de vehículos automotores nuevos n.c.p.','451190',NULL),(425,NULL,NULL,'Venta de autos, camionetas y utilitarios, usados','451210',NULL),(426,NULL,NULL,'Venta de vehículos automotores usados n.c.p.','451290',NULL),(427,NULL,NULL,'Lavado automático y manual de vehículos automotores','452101',NULL),(428,NULL,NULL,'Reparación de cámaras y cubiertas','452210',NULL),(429,NULL,NULL,'Reparación de amortiguadores,  alineación de dirección y balanceo de ruedas','452220',NULL),(430,NULL,NULL,'Instalación y reparación de parabrisas, lunetas y ventanillas, cerraduras no eléctricas y grabado de cristales','452300',NULL),(431,NULL,NULL,'Reparaciones eléctricas del tablero e instrumental, reparación y recarga de baterías, instalación de alarmas, radios, sistemas de climatización','452401',NULL),(432,NULL,NULL,'Tapizado y retapizado de automotores','452500',NULL),(433,NULL,NULL,'Reparación y pintura de carrocerías, colocación y reparación de guardabarros y protecciones exteriores','452600',NULL),(434,NULL,NULL,'Instalación y reparación de caños de escape y radiadores','452700',NULL),(435,NULL,NULL,'Mantenimiento y reparación de frenos y embragues','452800',NULL),(436,NULL,NULL,'Instalación y reparación de equipos de GNC','452910',NULL),(437,NULL,NULL,'Mantenimiento y reparación del motor n.c.p., mecánica integral','452990',NULL),(438,NULL,NULL,'Venta al por mayor de partes, piezas y accesorios de vehículos automotores','453100',NULL),(439,NULL,NULL,'Venta al por menor de cámaras y cubiertas','453210',NULL),(440,NULL,NULL,'Venta al por menor de baterías','453220',NULL),(441,NULL,NULL,'Venta al por menor de partes, piezas y accesorios nuevos n.c.p.','453291',NULL),(442,NULL,NULL,'Venta al por menor de partes, piezas y accesorios usados n.c.p.','453292',NULL),(443,NULL,NULL,'Venta de motocicletas y de sus partes, piezas y accesorios','454010',NULL),(444,NULL,NULL,'Mantenimiento y reparación de motocicletas','454020',NULL),(445,NULL,NULL,'Venta al por mayor en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461011',NULL),(446,NULL,NULL,'Venta al por mayor en comisión o consignación de semillas','461012',NULL),(447,NULL,NULL,'Venta al por mayor en comisión o consignación de frutas','461013',NULL),(448,NULL,NULL,'Acopio y acondicionamiento en comisión o consignación de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','461014',NULL),(449,NULL,NULL,'Venta al por mayor en comisión o consignación de productos agrícolas n.c.p.','461019',NULL),(450,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado bovino en pie','461021',NULL),(451,NULL,NULL,'Venta al por mayor en comisión o consignación de ganado en pie excepto bovino','461022',NULL),(452,NULL,NULL,'Venta al por mayor en comisión o consignación de productos pecuarios n.c.p.','461029',NULL),(453,NULL,NULL,'Operaciones de intermediación de carne - consignatario directo -','461031',NULL),(454,NULL,NULL,'Operaciones de intermediación de carne excepto consignatario directo','461032',NULL);
INSERT INTO `activities` VALUES (455,NULL,NULL,'Venta al por mayor en comisión o consignación de alimentos, bebidas y tabaco n.c.p.','461039',NULL),(456,NULL,NULL,'Venta al por mayor en comisión o consignación de combustibles','461040',NULL),(457,NULL,NULL,'Venta al por mayor en comisión o consignación de  madera y materiales para la construcción','461092',NULL),(458,NULL,NULL,'Venta al por mayor en comisión o consignación de minerales, metales y productos químicos industriales','461093',NULL),(459,NULL,NULL,'Venta al por mayor en comisión o consignación de  maquinaria, equipo profesional industrial y comercial, embarcaciones y aeronaves','461094',NULL),(460,NULL,NULL,'Venta al por mayor en comisión o consignación de papel, cartón, libros, revistas, diarios, materiales de embalaje y artículos de librería','461095',NULL),(461,NULL,NULL,'Venta al por mayor en comisión o consignación de  mercaderías n.c.p.','461099',NULL),(462,NULL,NULL,'Acopio de algodón','462110',NULL),(463,NULL,NULL,'Venta al por mayor de semillas y granos para forrajes','462120',NULL),(464,NULL,NULL,'Venta al por mayor de cereales (incluye arroz), oleaginosas y forrajeras excepto semillas','462131',NULL),(465,NULL,NULL,'Acopio y acondicionamiento de cereales y semillas, excepto de algodón y semillas y granos para forrajes','462132',NULL),(466,NULL,NULL,'Venta al por mayor de materias primas agrícolas y de la silvicultura n.c.p.','462190',NULL),(467,NULL,NULL,'Venta al por mayor de lanas, cueros en bruto y productos afines','462201',NULL),(468,NULL,NULL,'Venta al por mayor de materias primas pecuarias n.c.p. incluso animales vivos','462209',NULL),(469,NULL,NULL,'Venta al por mayor de productos lácteos','463111',NULL),(470,NULL,NULL,'Venta al por mayor de fiambres y quesos','463112',NULL),(471,NULL,NULL,'Venta al por mayor de carnes rojas y derivados','463121',NULL),(472,NULL,NULL,'Venta al por mayor de aves, huevos y productos de granja y de la caza n.c.p.','463129',NULL),(473,NULL,NULL,'Venta al por mayor de pescado','463130',NULL),(474,NULL,NULL,'Venta al por mayor y empaque de frutas, de legumbres y hortalizas frescas','463140',NULL),(475,NULL,NULL,'Venta al por mayor de pan, productos de confitería y pastas frescas','463151',NULL),(476,NULL,NULL,'Venta al por mayor de azúcar','463152',NULL),(477,NULL,NULL,'Venta al por mayor de aceites y grasas','463153',NULL),(478,NULL,NULL,'Venta al por mayor de café, té, yerba mate y otras infusiones y especias y condimentos','463154',NULL),(479,NULL,NULL,'Venta al por mayor de productos y subproductos de molinería n.c.p.','463159',NULL),(480,NULL,NULL,'Venta al por mayor de chocolates, golosinas y productos para kioscos y polirrubros n.c.p., excepto cigarrillos','463160',NULL),(481,NULL,NULL,'Venta al por mayor de alimentos balanceados para animales','463170',NULL),(482,NULL,NULL,'Venta al por mayor en supermercados mayoristas de alimentos','463180',NULL),(483,NULL,NULL,'Venta al por mayor de frutas, legumbres y cereales secos y en conserva','463191',NULL),(484,NULL,NULL,'Venta al por mayor de productos alimenticios n.c.p.','463199',NULL),(485,NULL,NULL,'Venta al por mayor de vino','463211',NULL),(486,NULL,NULL,'Venta al por mayor de bebidas espiritosas','463212',NULL),(487,NULL,NULL,'Venta al por mayor de bebidas alcohólicas n.c.p.','463219',NULL),(488,NULL,NULL,'Venta al por mayor de bebidas no alcohólicas','463220',NULL),(489,NULL,NULL,'Venta al por mayor de cigarrillos y productos de tabaco','463300',NULL),(490,NULL,NULL,'Venta al por mayor de tejidos (telas)','464111',NULL),(491,NULL,NULL,'Venta al por mayor de artículos de mercería','464112',NULL),(492,NULL,NULL,'Venta al por mayor de mantelería, ropa de cama y artículos textiles para el hogar','464113',NULL),(493,NULL,NULL,'Venta al por mayor de tapices y alfombras de materiales textiles','464114',NULL),(494,NULL,NULL,'Venta al por mayor de productos textiles n.c.p.','464119',NULL),(495,NULL,NULL,'Venta al por mayor de prendas de vestir de cuero','464121',NULL);
INSERT INTO `activities` VALUES (496,NULL,NULL,'Venta al por mayor de medias y prendas de punto','464122',NULL),(497,NULL,NULL,'Venta al por mayor de prendas y accesorios de vestir n.c.p., excepto uniformes y ropa de trabajo','464129',NULL),(498,NULL,NULL,'Venta al por mayor de calzado excepto el ortopédico','464130',NULL),(499,NULL,NULL,'Venta al por mayor de pieles y cueros curtidos y salados','464141',NULL),(500,NULL,NULL,'Venta al por mayor de suelas y afines','464142',NULL),(501,NULL,NULL,'Venta al por mayor de artículos de marroquinería,  paraguas y productos similares n.c.p.','464149',NULL),(502,NULL,NULL,'Venta al por mayor de uniformes y ropa de trabajo','464150',NULL),(503,NULL,NULL,'Venta al por mayor de libros y publicaciones','464211',NULL),(504,NULL,NULL,'Venta al por mayor de diarios y revistas','464212',NULL),(505,NULL,NULL,'Venta al por mayor de papel y productos de papel y cartón excepto envases','464221',NULL),(506,NULL,NULL,'Venta al por mayor de envases de papel y cartón','464222',NULL),(507,NULL,NULL,'Venta al por mayor de artículos de librería y papelería','464223',NULL),(508,NULL,NULL,'Venta al por mayor de productos farmacéuticos','464310',NULL),(509,NULL,NULL,'Venta al por mayor de productos cosméticos, de tocador y de perfumería','464320',NULL),(510,NULL,NULL,'Venta al por mayor de instrumental médico y odontológico y artículos ortopédicos','464330',NULL),(511,NULL,NULL,'Venta al por mayor de productos veterinarios','464340',NULL),(512,NULL,NULL,'Venta al por mayor de artículos de óptica y de fotografía','464410',NULL),(513,NULL,NULL,'Venta al por mayor de artículos de relojería, joyería y fantasías','464420',NULL),(514,NULL,NULL,'Venta al por mayor de electrodomésticos y artefactos para el hogar excepto equipos de audio y video','464501',NULL),(515,NULL,NULL,'Venta al por mayor de equipos de audio, video y televisión','464502',NULL),(516,NULL,NULL,'Venta al por mayor de muebles excepto de oficina, artículos de mimbre y corcho, colchones y somieres','464610',NULL),(517,NULL,NULL,'Venta al por mayor de artículos de iluminación','464620',NULL),(518,NULL,NULL,'Venta al por mayor de artículos de vidrio','464631',NULL),(519,NULL,NULL,'Venta al por mayor de artículos de bazar y menaje excepto de vidrio','464632',NULL),(520,NULL,NULL,'Venta al por mayor de materiales y productos de limpieza','464920',NULL),(521,NULL,NULL,'Venta al por mayor de juguetes','464930',NULL),(522,NULL,NULL,'Venta al por mayor de bicicletas y rodados similares','464940',NULL),(523,NULL,NULL,'Venta al por mayor de artículos de esparcimiento y deportes','464950',NULL),(524,NULL,NULL,'Venta al por mayor de flores y plantas naturales y artificiales','464991',NULL),(525,NULL,NULL,'Venta al por mayor de artículos de uso doméstico o personal n.c.p','464999',NULL),(526,NULL,NULL,'Venta al por mayor de equipos, periféricos, accesorios y programas informáticos','465100',NULL),(527,NULL,NULL,'Venta al por mayor de equipos de telefonía y comunicaciones','465210',NULL),(528,NULL,NULL,'Venta al por mayor de componentes electrónicos','465220',NULL),(529,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en los sectores agropecuario, jardinería, silvicultura, pesca y caza','465310',NULL),(530,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la elaboración de alimentos, bebidas y tabaco','465320',NULL),(531,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la fabricación de textiles, prendas y accesorios de vestir, calzado, artículos de cuero y marroquinería','465330',NULL),(532,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en imprentas, artes gráficas y actividades conexas','465340',NULL),(533,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso médico y paramédico','465350',NULL),(534,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso en la industria del plástico y del caucho','465360',NULL);
INSERT INTO `activities` VALUES (535,NULL,NULL,'Venta al por mayor de máquinas, equipos e implementos de uso especial n.c.p.','465390',NULL),(536,NULL,NULL,'Venta al por mayor de máquinas - herramienta de uso general','465400',NULL),(537,NULL,NULL,'Venta  al  por  mayor  de  vehículos,  equipos  y  máquinas  para  el transporte ferroviario, aéreo y de navegación','465500',NULL),(538,NULL,NULL,'Venta al por mayor de muebles e instalaciones para oficinas','465610',NULL),(539,NULL,NULL,'Venta al por mayor de muebles e instalaciones para la industria, el comercio y los servicios n.c.p.','465690',NULL),(540,NULL,NULL,'Venta al por mayor de máquinas y equipo de control y seguridad','465910',NULL),(541,NULL,NULL,'Venta al por mayor de maquinaria y equipo de oficina, excepto equipo informático','465920',NULL),(542,NULL,NULL,'Venta al por mayor de equipo profesional y científico e instrumentos de medida y de control n.c.p.','465930',NULL),(543,NULL,NULL,'Venta al por mayor de máquinas, equipo y materiales conexos n.c.p.','465990',NULL),(544,NULL,NULL,'Venta al por mayor de combustibles y lubricantes para automotores','466110',NULL),(545,NULL,NULL,'Fraccionamiento y distribución de gas licuado','466121',NULL),(546,NULL,NULL,'Venta al por mayor de combustibles, lubricantes, leña y carbón, excepto gas licuado y combustibles y lubricantes para automotores','466129',NULL),(547,NULL,NULL,'Venta al por mayor de metales y minerales metalíferos','466200',NULL),(548,NULL,NULL,'Venta al por mayor de aberturas','466310',NULL),(549,NULL,NULL,'Venta al por mayor de productos de madera excepto muebles','466320',NULL),(550,NULL,NULL,'Venta al por mayor de artículos de ferretería y materiales eléctricos','466330',NULL),(551,NULL,NULL,'Venta al por mayor de pinturas y productos conexos','466340',NULL),(552,NULL,NULL,'Venta al por mayor de cristales y espejos','466350',NULL),(553,NULL,NULL,'Venta al por mayor de artículos para plomería, instalación de gas y calefacción','466360',NULL),(554,NULL,NULL,'Venta al por mayor de papeles para pared, revestimiento para pisos de goma, plástico y textiles,  y artículos similares para la decoración','466370',NULL),(555,NULL,NULL,'Venta al por mayor de artículos de loza, cerámica y porcelana de uso en construcción','466391',NULL),(556,NULL,NULL,'Venta al por mayor de artículos para la construcción n.c.p.','466399',NULL),(557,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos textiles','466910',NULL),(558,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos de papel y cartón','466920',NULL),(559,NULL,NULL,'Venta al por mayor de artículos de plástico','466931',NULL),(560,NULL,NULL,'Venta al por mayor de abonos, fertilizantes y plaguicidas','466932',NULL),(561,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos de vidrio, caucho, goma y químicos n.c.p.','466939',NULL),(562,NULL,NULL,'Venta al por mayor de productos intermedios n.c.p., desperdicios y desechos metálicos','466940',NULL),(563,NULL,NULL,'Venta al por mayor de productos intermedios, desperdicios y desechos n.c.p.','466990',NULL),(564,NULL,NULL,'Venta al por mayor de insumos agropecuarios diversos','469010',NULL),(565,NULL,NULL,'Venta al por mayor de mercancías n.c.p.','469090',NULL),(566,NULL,NULL,'Venta al por menor en hipermercados','471110',NULL),(567,NULL,NULL,'Venta al por menor en supermercados','471120',NULL),(568,NULL,NULL,'Venta al por menor en minimercados','471130',NULL),(569,NULL,NULL,'Venta al por menor en kioscos, polirrubros y comercios no especializados n.c.p.','471190',NULL),(570,NULL,NULL,'Venta al por menor en comercios no especializados, sin predominio de productos alimenticios y bebidas','471900',NULL),(571,NULL,NULL,'Venta al por menor de productos lácteos','472111',NULL),(572,NULL,NULL,'Venta al por menor de fiambres y embutidos','472112',NULL),(573,NULL,NULL,'Venta al por menor de productos de almacén y dietética','472120',NULL);
INSERT INTO `activities` VALUES (574,NULL,NULL,'Venta al por menor de carnes rojas, menudencias y chacinados frescos','472130',NULL),(575,NULL,NULL,'Venta al por menor de huevos, carne de aves y  productos de granja y de la caza','472140',NULL),(576,NULL,NULL,'Venta al por menor de pescados y  productos de la pesca','472150',NULL),(577,NULL,NULL,'Venta al por menor de frutas, legumbres y hortalizas frescas','472160',NULL),(578,NULL,NULL,'Venta al por menor de pan y productos de panadería','472171',NULL),(579,NULL,NULL,'Venta al por menor de bombones, golosinas y demás productos de confitería','472172',NULL),(580,NULL,NULL,'Venta al por menor de productos alimenticios n.c.p., en comercios especializados','472190',NULL),(581,NULL,NULL,'Venta al por menor de bebidas en comercios especializados','472200',NULL),(582,NULL,NULL,'Venta al por menor de tabaco en comercios especializados','472300',NULL),(583,NULL,NULL,'Venta al por menor de combustible para vehículos automotores y motocicletas','473000',NULL),(584,NULL,NULL,'Venta al por menor de equipos, periféricos,  accesorios y programas informáticos','474010',NULL),(585,NULL,NULL,'Venta al por menor de aparatos de telefonía y comunicación','474020',NULL),(586,NULL,NULL,'Venta al por menor de hilados, tejidos y artículos de mercería','475110',NULL),(587,NULL,NULL,'Venta al por menor de confecciones para el hogar','475120',NULL),(588,NULL,NULL,'Venta al por menor de artículos textiles n.c.p. excepto prendas de vestir','475190',NULL),(589,NULL,NULL,'Venta al por menor de aberturas','475210',NULL),(590,NULL,NULL,'Venta al por menor de maderas y artículos de madera  y corcho, excepto muebles','475220',NULL),(591,NULL,NULL,'Venta al por menor de artículos de ferretería y materiales eléctricos','475230',NULL),(592,NULL,NULL,'Venta al por menor de pinturas y productos conexos','475240',NULL),(593,NULL,NULL,'Venta al por menor de artículos para plomería e instalación de gas','475250',NULL),(594,NULL,NULL,'Venta al por menor de cristales, espejos, mamparas y cerramientos','475260',NULL),(595,NULL,NULL,'Venta al por menor de papeles para pared, revestimientos para pisos y artículos similares para la decoración','475270',NULL),(596,NULL,NULL,'Venta al por menor de materiales de construcción n.c.p.','475290',NULL),(597,NULL,NULL,'Venta al por menor  de electrodomésticos, artefactos para el hogar y equipos de audio y video','475300',NULL),(598,NULL,NULL,'Venta al por menor de muebles para el hogar, artículos de mimbre y corcho','475410',NULL),(599,NULL,NULL,'Venta al por menor de colchones y somieres','475420',NULL),(600,NULL,NULL,'Venta al por menor de artículos de iluminación','475430',NULL),(601,NULL,NULL,'Venta al por menor de artículos de bazar y menaje','475440',NULL),(602,NULL,NULL,'Venta al por menor de artículos para el hogar n.c.p.','475490',NULL),(603,NULL,NULL,'Venta al por menor de libros','476110',NULL),(604,NULL,NULL,'Venta al por menor de diarios y revistas','476120',NULL),(605,NULL,NULL,'Venta al por menor de papel, cartón, materiales de embalaje y artículos de librería','476130',NULL),(606,NULL,NULL,'Venta al por menor de equipos  y artículos deportivos','476310',NULL),(607,NULL,NULL,'Venta al por menor de armas, artículos para la caza y pesca','476320',NULL),(608,NULL,NULL,'Venta al por menor de juguetes, artículos de cotillón y juegos de mesa','476400',NULL),(609,NULL,NULL,'Venta al por menor de ropa interior, medias, prendas para dormir y para la playa','477110',NULL),(610,NULL,NULL,'Venta al por menor de uniformes escolares y guardapolvos','477120',NULL),(611,NULL,NULL,'Venta al por menor de indumentaria para bebés y niños','477130',NULL),(612,NULL,NULL,'Venta al por menor de indumentaria deportiva','477140',NULL),(613,NULL,NULL,'Venta al por menor de prendas de cuero','477150',NULL),(614,NULL,NULL,'Venta al por menor de prendas y accesorios de vestir n.c.p.','477190',NULL),(615,NULL,NULL,'Venta al por menor de artículos de talabartería y artículos regionales','477210',NULL);
INSERT INTO `activities` VALUES (616,NULL,NULL,'Venta al por menor de calzado, excepto el ortopédico y el deportivo','477220',NULL),(617,NULL,NULL,'Venta al por menor de calzado deportivo','477230',NULL),(618,NULL,NULL,'Venta al por menor de artículos de marroquinería, paraguas y similares n.c.p.','477290',NULL),(619,NULL,NULL,'Venta al por menor de productos farmacéuticos y de herboristería','477310',NULL),(620,NULL,NULL,'Venta al por menor de productos cosméticos, de tocador y de perfumería','477320',NULL),(621,NULL,NULL,'Venta al por menor de instrumental médico y odontológico y artículos ortopédicos','477330',NULL),(622,NULL,NULL,'Venta al por menor de artículos de óptica y fotografía','477410',NULL),(623,NULL,NULL,'Venta al por menor de artículos de relojería y joyería','477420',NULL),(624,NULL,NULL,'Venta al por menor de bijouterie y fantasía','477430',NULL),(625,NULL,NULL,'Venta al por menor de flores, plantas, semillas, abonos, fertilizantes y otros productos de vivero','477440',NULL),(626,NULL,NULL,'Venta al por menor de materiales y productos de limpieza','477450',NULL),(627,NULL,NULL,'Venta al por menor de fuel oil, gas en garrafas, carbón y leña','477460',NULL),(628,NULL,NULL,'Venta al por menor de productos veterinarios, animales domésticos y alimento balanceado para mascotas','477470',NULL),(629,NULL,NULL,'Venta al por menor de obras de arte','477480',NULL),(630,NULL,NULL,'Venta al por menor de artículos nuevos n.c.p.','477490',NULL),(631,NULL,NULL,'Venta al por menor de muebles usados','477810',NULL),(632,NULL,NULL,'Venta al por menor de libros, revistas y similares usados','477820',NULL),(633,NULL,NULL,'Venta al por menor de antigüedades','477830',NULL),(634,NULL,NULL,'Venta al por menor de oro, monedas, sellos y similares','477840',NULL),(635,NULL,NULL,'Venta al por menor de artículos usados n.c.p. excepto+E1155 automotores y motocicletas','477890',NULL),(636,NULL,NULL,'Venta al por menor de alimentos, bebidas y tabaco en puestos móviles y mercados','478010',NULL),(637,NULL,NULL,'Venta al por menor de productos n.c.p. en puestos móviles y mercados','478090',NULL),(638,NULL,NULL,'Venta al por menor por internet','479101',NULL),(639,NULL,NULL,'Venta al por menor por correo, televisión y otros medios de comunicación n.c.p.','479109',NULL),(640,NULL,NULL,'Venta al por menor no realizada en establecimientos  n.c.p.','479900',NULL),(641,NULL,NULL,'Servicio de transporte ferroviario urbano y suburbano de pasajeros','491110',NULL),(642,NULL,NULL,'Servicio de transporte ferroviario interurbano de pasajeros','491120',NULL),(643,NULL,NULL,'Servicio de transporte ferroviario de cargas','491200',NULL),(644,NULL,NULL,'Servicio de transporte automotor urbano y suburbano regular de pasajeros','492110',NULL),(645,NULL,NULL,'Servicios de transporte automotor de pasajeros mediante taxis y remises, alquiler de autos con chofer','492120',NULL),(646,NULL,NULL,'Servicio de transporte escolar','492130',NULL),(647,NULL,NULL,'Servicio de transporte automotor urbano y suburbano no regular de pasajeros de oferta libre,  excepto mediante taxis y remises, alquiler de autos con chofer y transporte escolar','492140',NULL),(648,NULL,NULL,'Servicio de transporte automotor interurbano regular de pasajeros, E1203excepto transporte internacional','492150',NULL),(649,NULL,NULL,'Servicio de transporte automotor interurbano no regular de pasajeros','492160',NULL),(650,NULL,NULL,'Servicio de transporte automotor internacional de pasajeros','492170',NULL),(651,NULL,NULL,'Servicio de transporte automotor turístico de pasajeros','492180',NULL),(652,NULL,NULL,'Servicio de transporte automotor de pasajeros n.c.p.','492190',NULL),(653,NULL,NULL,'Servicios de mudanza','492210',NULL),(654,NULL,NULL,'Servicio de transporte automotor de cereales','492221',NULL),(655,NULL,NULL,'Servicio de transporte automotor de mercaderías a granel n.c.p.','492229',NULL),(656,NULL,NULL,'Servicio de transporte automotor de animales','492230',NULL);
INSERT INTO `activities` VALUES (657,NULL,NULL,'Servicio de transporte por camión cisterna','492240',NULL),(658,NULL,NULL,'Servicio de transporte automotor de mercaderías y sustancias peligrosas','492250',NULL),(659,NULL,NULL,'Servicio de transporte automotor urbano de carga n.c.p.','492280',NULL),(660,NULL,NULL,'Servicio de transporte automotor de cargas n.c.p.','492290',NULL),(661,NULL,NULL,'Servicio de transporte por oleoductos','493110',NULL),(662,NULL,NULL,'Servicio de transporte por poliductos y fueloductos','493120',NULL),(663,NULL,NULL,'Servicio de transporte por gasoductos','493200',NULL),(664,NULL,NULL,'Servicio de transporte marítimo de pasajeros','501100',NULL),(665,NULL,NULL,'Servicio de transporte marítimo de carga','501200',NULL),(666,NULL,NULL,'Servicio de transporte fluvial y lacustre de pasajeros','502101',NULL),(667,NULL,NULL,'Servicio de transporte fluvial y lacustre de carga','502200',NULL),(668,NULL,NULL,'Servicio de transporte aéreo de pasajeros','511000',NULL),(669,NULL,NULL,'Servicio de transporte aéreo de cargas','512000',NULL),(670,NULL,NULL,'Servicios de manipulación de carga en el ámbito terrestre','521010',NULL),(671,NULL,NULL,'Servicios de manipulación de carga en el ámbito portuario','521020',NULL),(672,NULL,NULL,'Servicios de manipulación de carga en el ámbito aéreo','521030',NULL),(673,NULL,NULL,'Servicios de almacenamiento y depósito en silos','522010',NULL),(674,NULL,NULL,'Servicios de almacenamiento y depósito en cámaras frigoríficas','522020',NULL),(675,NULL,NULL,'Servicios de usuarios directos de zona franca','522091',NULL),(676,NULL,NULL,'Servicios de gestión de depósitos fiscales','522092',NULL),(677,NULL,NULL,'Servicios de almacenamiento y depósito n.c.p.','522099',NULL),(678,NULL,NULL,'Servicios de gestión aduanera realizados por despachantes de aduana','523011',NULL),(679,NULL,NULL,'Servicios de gestión aduanera para el transporte de mercaderías n.c.p.','523019',NULL),(680,NULL,NULL,'Servicios de agencias marítimas para el transporte de mercaderías','523020',NULL),(681,NULL,NULL,'Servicios de gestión de agentes de transporte aduanero excepto agencias marítimas','523031',NULL),(682,NULL,NULL,'Servicios de operadores logísticos seguros (OLS) en el ámbito aduanero','523032',NULL),(683,NULL,NULL,'Servicios de operadores logísticos n.c.p.','523039',NULL),(684,NULL,NULL,'Servicios de gestión y logística para el transporte de mercaderías n.c.p.','523090',NULL),(685,NULL,NULL,'Servicios de explotación de infraestructura para el transporte terrestre, peajes y otros derechos','524110',NULL),(686,NULL,NULL,'Servicios  de playas de estacionamiento y garajes','524120',NULL),(687,NULL,NULL,'Servicios de estaciones terminales de ómnibus y ferroviárias','524130',NULL),(688,NULL,NULL,'Servicios complementarios para el transporte terrestre n.c.p.','524190',NULL),(689,NULL,NULL,'Servicios de explotación de infraestructura para el transporte marítimo, derechos de puerto','524210',NULL),(690,NULL,NULL,'Servicios de guarderías náuticas','524220',NULL),(691,NULL,NULL,'Servicios para la navegación','524230',NULL),(692,NULL,NULL,'Servicios complementarios para el transporte marítimo n.c.p.','524290',NULL),(693,NULL,NULL,'Servicios de explotación de infraestructura para el transporte aéreo, derechos de aeropuerto','524310',NULL),(694,NULL,NULL,'Servicios de hangares y estacionamiento de aeronaves','524320',NULL),(695,NULL,NULL,'Servicios para la aeronavegación','524330',NULL),(696,NULL,NULL,'Servicios complementarios para el transporte aéreo n.c.p.','524390',NULL),(697,NULL,NULL,'Servicio de correo postal','530010',NULL),(698,NULL,NULL,'Servicios de mensajerías.','530090',NULL),(699,NULL,NULL,'Servicios de alojamiento por hora','551010',NULL),(700,NULL,NULL,'Servicios de alojamiento en pensiones','551021',NULL),(701,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que incluyen servicio de restaurante al público','551022',NULL);
INSERT INTO `activities` VALUES (702,NULL,NULL,'Servicios de alojamiento en hoteles, hosterías y residenciales similares, excepto por hora, que no incluyen servicio de restaurante al público','551023',NULL),(703,NULL,NULL,'Servicios de hospedaje temporal n.c.p.','551090',NULL),(704,NULL,NULL,'Servicios de alojamiento en campings','552000',NULL),(705,NULL,NULL,'Servicios de restaurantes y cantinas sin espectáculo','561011',NULL),(706,NULL,NULL,'Servicios de restaurantes y cantinas con espectáculo','561012',NULL),(707,NULL,NULL,'Servicios de fast food y locales de venta de comidas y bebidas al paso','561013',NULL),(708,NULL,NULL,'Servicios de expendio de bebidas en bares','561014',NULL),(709,NULL,NULL,'Servicios de expendio de comidas y bebidas en establecimientos con servicio de mesa y/o en mostrador n.c.p.','561019',NULL),(710,NULL,NULL,'Servicios de preparación de comidas para llevar','561020',NULL),(711,NULL,NULL,'Servicio de expendio de helados','561030',NULL),(712,NULL,NULL,'Servicios de preparación de comidas realizadas por/para vendedores ambulantes.','561040',NULL),(713,NULL,NULL,'Servicios de preparación de comidas para empresas y eventos','562010',NULL),(714,NULL,NULL,'Servicios de cantinas con atención exclusiva  a los empleados o estudiantes dentro de empresas o establecimientos educativos.','562091',NULL),(715,NULL,NULL,'Servicios de comidas n.c.p.','562099',NULL),(716,NULL,NULL,'Edición de libros, folletos, y otras publicaciones','581100',NULL),(717,NULL,NULL,'Edición de directorios y listas de correos','581200',NULL),(718,NULL,NULL,'Edición de periódicos, revistas y publicaciones periódicas','581300',NULL),(719,NULL,NULL,'Edición n.c.p.','581900',NULL),(720,NULL,NULL,'Producción de filmes y videocintas','591110',NULL),(721,NULL,NULL,'Postproducción de filmes y videocintas','591120',NULL),(722,NULL,NULL,'Distribución de filmes y videocintas','591200',NULL),(723,NULL,NULL,'Exhibición de filmes y videocintas','591300',NULL),(724,NULL,NULL,'Servicios de grabación de sonido y edición de música','592000',NULL),(725,NULL,NULL,'Emisión y retransmisión de radio','601000',NULL),(726,NULL,NULL,'Emisión y retransmisión  de televisión abierta','602100',NULL),(727,NULL,NULL,'Operadores de televisión por suscripción.','602200',NULL),(728,NULL,NULL,'Emisión de señales de televisión por suscripción','602310',NULL),(729,NULL,NULL,'Producción de programas de televisión','602320',NULL),(730,NULL,NULL,'Servicios de televisión n.c.p','602900',NULL),(731,NULL,NULL,'Servicios de locutorios','611010',NULL),(732,NULL,NULL,'Servicios de telefonía fija, excepto locutorios','611090',NULL),(733,NULL,NULL,'Servicios de telefonía móvil','612000',NULL),(734,NULL,NULL,'Servicios de telecomunicaciones vía satélite, excepto servicios de transmisión de televisión','613000',NULL),(735,NULL,NULL,'Servicios de proveedores de acceso a internet','614010',NULL),(736,NULL,NULL,'Servicios de telecomunicación vía internet n.c.p.','614090',NULL),(737,NULL,NULL,'Servicios de telecomunicaciones n.c.p.','619000',NULL),(738,NULL,NULL,'Servicios de consultores en informática y suministros de programas de informática','620100',NULL),(739,NULL,NULL,'Servicios de consultores en equipo de informática','620200',NULL),(740,NULL,NULL,'Servicios de consultores en tecnología de la información','620300',NULL),(741,NULL,NULL,'Servicios de informática n.c.p.','620900',NULL),(742,NULL,NULL,'Procesamiento de datos','631110',NULL),(743,NULL,NULL,'Hospedaje de datos','631120',NULL),(744,NULL,NULL,'Actividades conexas al procesamiento y hospedaje de datos n.c.p.','631190',NULL),(745,NULL,NULL,'Portales web','631200',NULL),(746,NULL,NULL,'Agencias de noticias','639100',NULL),(747,NULL,NULL,'Servicios de información n.c.p.','639900',NULL),(748,NULL,NULL,'Servicios de la banca central','641100',NULL),(749,NULL,NULL,'Servicios de la banca mayorista','641910',NULL),(750,NULL,NULL,'Servicios de la banca de inversión','641920',NULL);
INSERT INTO `activities` VALUES (751,NULL,NULL,'Servicios de la banca minorista','641930',NULL),(752,NULL,NULL,'Servicios de intermediación financiera realizada por las compañías financieras','641941',NULL),(753,NULL,NULL,'Servicios de intermediación financiera realizada por sociedades de ahorro y préstamo para la vivienda y otros inmuebles','641942',NULL),(754,NULL,NULL,'Servicios de intermediación financiera realizada por cajas de crédito','641943',NULL),(755,NULL,NULL,'Servicios de sociedades de cartera','642000',NULL),(756,NULL,NULL,'Servicios de fideicomisos','643001',NULL),(757,NULL,NULL,'Fondos y sociedades de inversión y entidades financieras similares n.c.p.','643009',NULL),(758,NULL,NULL,'Arrendamiento financiero, leasing','649100',NULL),(759,NULL,NULL,'Actividades de crédito para financiar otras actividades económicas','649210',NULL),(760,NULL,NULL,'Servicios de entidades de tarjeta de compra y/o crédito','649220',NULL),(761,NULL,NULL,'Servicios de crédito n.c.p.','649290',NULL),(762,NULL,NULL,'Servicios de agentes de mercado abierto puros','649910',NULL),(763,NULL,NULL,'Servicios de socios inversores en sociedades regulares según Ley 19.550 - S.R.L., S.C.A, etc, excepto socios inversores en sociedades anónimas incluidos en 649999 -','649991',NULL),(764,NULL,NULL,'Servicios de financiación y actividades financieras n.c.p.','649999',NULL),(765,NULL,NULL,'Servicios de seguros de salud','651110',NULL),(766,NULL,NULL,'Servicios de seguros de vida','651120',NULL),(767,NULL,NULL,'Servicios de seguros personales excepto  los de salud y de vida','651130',NULL),(768,NULL,NULL,'Servicios de aseguradoras de riesgo de trabajo (ART)','651210',NULL),(769,NULL,NULL,'Servicios de seguros patrimoniales excepto los de las aseguradoras de riesgo de trabajo (ART)','651220',NULL),(770,NULL,NULL,'Obras Sociales','651310',NULL),(771,NULL,NULL,'Servicios de cajas de previsión social pertenecientes a asociaciones profesionales','651320',NULL),(772,NULL,NULL,'Reaseguros','652000',NULL),(773,NULL,NULL,'Administración de fondos de pensiones, excepto la seguridad social obligatoria','653000',NULL),(774,NULL,NULL,'Servicios de mercados y cajas de valores','661111',NULL),(775,NULL,NULL,'Servicios de mercados a término','661121',NULL),(776,NULL,NULL,'Servicios de bolsas de comercio','661131',NULL),(777,NULL,NULL,'Servicios bursátiles de mediación o por cuenta de terceros','661910',NULL),(778,NULL,NULL,'Servicios de casas y agencias de cambio','661920',NULL),(779,NULL,NULL,'Servicios de sociedades calificadoras de riesgos financieros','661930',NULL),(780,NULL,NULL,'Servicios de envio y recepción de fondos desde y hacia el exterior','661991',NULL),(781,NULL,NULL,'Servicios de administradoras de vales y tickets','661992',NULL),(782,NULL,NULL,'Servicios auxiliares a la intermediación financiera n.c.p.','661999',NULL),(783,NULL,NULL,'Servicios de evaluación de riesgos y daños','662010',NULL),(784,NULL,NULL,'Servicios de productores  y asesores de seguros','662020',NULL),(785,NULL,NULL,'Servicios auxiliares a los servicios de seguros n.c.p.','662090',NULL),(786,NULL,NULL,'Servicios de gestión de fondos a cambio de una retribución o por contrata','663000',NULL),(787,NULL,NULL,'Servicios de alquiler y explotación de inmuebles para fiestas, convenciones y otros eventos similares','681010',NULL),(788,NULL,NULL,'Servicios de alquiler  de consultorios médicos','681020',NULL),(789,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes urbanos propios o arrendados n.c.p.','681098',NULL),(790,NULL,NULL,'Servicios inmobiliarios realizados por cuenta propia, con bienes rurales propios o arrendados n.c.p.','681099',NULL),(791,NULL,NULL,'Servicios de administración de consorcios de edificios','682010',NULL),(792,NULL,NULL,'Servicios prestados por inmobiliarias','682091',NULL),(793,NULL,NULL,'Servicios inmobiliarios realizados a cambio de una retribución o por contrata n.c.p.','682099',NULL),(794,NULL,NULL,'Servicios jurídicos','691001',NULL);
INSERT INTO `activities` VALUES (795,NULL,NULL,'Servicios  notariales','691002',NULL),(796,NULL,NULL,'Servicios de contabilidad, auditoría y asesoría fiscal','692000',NULL),(797,NULL,NULL,'Servicios de gerenciamiento de empresas e instituciones de salud, servicios de auditoria y medicina legal, servicio de asesoramiento farmacéutico','702010',NULL),(798,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de los órganos de administración y/o fiscalización en sociedades anónimas','702091',NULL),(799,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial realizados por integrantes de cuerpos de dirección en sociedades excepto las anónimas','702092',NULL),(800,NULL,NULL,'Servicios de asesoramiento, dirección y gestión empresarial n.c.p.','702099',NULL),(801,NULL,NULL,'Servicios relacionados con la construcción.','711001',NULL),(802,NULL,NULL,'Servicios geológicos y de prospección','711002',NULL),(803,NULL,NULL,'Servicios relacionados con la electrónica y las comunicaciones','711003',NULL),(804,NULL,NULL,'Servicios de arquitectura e ingeniería y servicios conexos de asesoramiento técnico n.c.p.','711009',NULL),(805,NULL,NULL,'Ensayos y análisis técnicos','712000',NULL),(806,NULL,NULL,'Investigación  y desarrollo experimental en el campo de la ingeniería y la tecnología','721010',NULL),(807,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias médicas','721020',NULL),(808,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias agropecuarias','721030',NULL),(809,NULL,NULL,'Investigación y desarrollo experimental en el campo de las ciencias exactas y naturales n.c.p.','721090',NULL),(810,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias sociales','722010',NULL),(811,NULL,NULL,'Investigación  y desarrollo experimental en el campo de las ciencias humanas','722020',NULL),(812,NULL,NULL,'Servicios de comercialización de tiempo y espacio publicitario','731001',NULL),(813,NULL,NULL,'Servicios de publicidad n.c.p.','731009',NULL),(814,NULL,NULL,'Estudio de mercado, realización de encuestas de opinión pública','732000',NULL),(815,NULL,NULL,'Servicios de diseño especializado','741000',NULL),(816,NULL,NULL,'Servicios de fotografía','742000',NULL),(817,NULL,NULL,'Servicios de traducción e interpretación','749001',NULL),(818,NULL,NULL,'Servicios de representación e intermediación de artistas y modelos','749002',NULL),(819,NULL,NULL,'Servicios de representación e intermediación de deportistas profesionales','749003',NULL),(820,NULL,NULL,'Actividades profesionales, científicas y técnicas n.c.p.','749009',NULL),(821,NULL,NULL,'Servicios veterinarios','750000',NULL),(822,NULL,NULL,'Alquiler de automóviles sin conductor','771110',NULL),(823,NULL,NULL,'Alquiler de vehículos automotores n.c.p., sin conductor ni operarios','771190',NULL),(824,NULL,NULL,'Alquiler de equipo de transporte para vía acuática, sin operarios ni tripulación','771210',NULL),(825,NULL,NULL,'Alquiler de equipo de transporte para vía aérea, sin operarios ni tripulación','771220',NULL),(826,NULL,NULL,'Alquiler de equipo de transporte n.c.p. sin conductor ni operarios','771290',NULL),(827,NULL,NULL,'Alquiler de videos y video juegos','772010',NULL),(828,NULL,NULL,'Alquiler de prendas de vestir','772091',NULL),(829,NULL,NULL,'Alquiler de efectos personales y enseres domésticos n.c.p.','772099',NULL),(830,NULL,NULL,'Alquiler de maquinaria y equipo agropecuario y forestal, sin operarios','773010',NULL),(831,NULL,NULL,'Alquiler de maquinaria y equipo para la minería, sin operarios','773020',NULL),(832,NULL,NULL,'Alquiler de maquinaria y equipo de construcción e ingeniería civil, sin operarios','773030',NULL),(833,NULL,NULL,'Alquiler de maquinaria y equipo de oficina, incluso computadoras','773040',NULL),(834,NULL,NULL,'Alquiler de maquinaria y equipo n.c.p., sin personal','773090',NULL);
INSERT INTO `activities` VALUES (835,NULL,NULL,'Arrendamiento y gestión de bienes intangibles no financieros','774000',NULL),(836,NULL,NULL,'Obtención y dotación de personal','780000',NULL),(837,NULL,NULL,'Servicios minoristas de agencias de viajes','791100',NULL),(838,NULL,NULL,'Servicios mayoristas de agencias de viajes','791200',NULL),(839,NULL,NULL,'Servicios de turismo aventura','791901',NULL),(840,NULL,NULL,'Servicios complementarios de apoyo turístico n.c.p.','791909',NULL),(841,NULL,NULL,'Servicios de transporte de caudales y objetos de valor','801010',NULL),(842,NULL,NULL,'Servicios de sistemas de seguridad','801020',NULL),(843,NULL,NULL,'Servicios de seguridad e investigación n.c.p.','801090',NULL),(844,NULL,NULL,'Servicio combinado de apoyo a edificios','811000',NULL),(845,NULL,NULL,'Servicios de limpieza general de edificios','812010',NULL),(846,NULL,NULL,'Servicios de desinfección y exterminio de plagas en el ámbito urbano','812020',NULL),(847,NULL,NULL,'Servicios de limpieza n.c.p.','812090',NULL),(848,NULL,NULL,'Servicios de jardinería y mantenimiento de espacios verdes','813000',NULL),(849,NULL,NULL,'Servicios combinados de gestión administrativa de oficinas','821100',NULL),(850,NULL,NULL,'Servicios de fotocopiado, preparación de documentos y otros servicios de apoyo de oficina','821900',NULL),(851,NULL,NULL,'Servicios de call center','822000',NULL),(852,NULL,NULL,'Servicios de organización de convenciones y exposiciones comerciales, excepto culturales y deportivos','823000',NULL),(853,NULL,NULL,'Servicios de agencias de cobro y calificación crediticia','829100',NULL),(854,NULL,NULL,'Servicios de envase y empaque','829200',NULL),(855,NULL,NULL,'Servicios empresariales n.c.p.','829900',NULL),(856,NULL,NULL,'Servicios generales de la Administración Pública','841100',NULL),(857,NULL,NULL,'Servicios para la regulación de las actividades sanitarias, educativas, culturales, y restantes servicios sociales, excepto seguridad social obligatoria','841200',NULL),(858,NULL,NULL,'Servicios para la regulación de la actividad económica','841300',NULL),(859,NULL,NULL,'Servicios auxiliares para los servicios generales de la Administración Pública','841900',NULL),(860,NULL,NULL,'Servicios de asuntos exteriores','842100',NULL),(861,NULL,NULL,'Servicios de defensa','842200',NULL),(862,NULL,NULL,'Servicios para el orden público y la seguridad','842300',NULL),(863,NULL,NULL,'Servicios de justicia','842400',NULL),(864,NULL,NULL,'Servicios de protección civil','842500',NULL),(865,NULL,NULL,'Servicios de la seguridad social obligatoria, excepto obras sociales','843000',NULL),(866,NULL,NULL,'Guarderías y jardines maternales','851010',NULL),(867,NULL,NULL,'Enseñanza inicial, jardín de infantes y primaria','851020',NULL),(868,NULL,NULL,'Enseñanza secundaria de formación general','852100',NULL),(869,NULL,NULL,'Enseñanza secundaria de formación técnica y profesional','852200',NULL),(870,NULL,NULL,'Enseñanza  terciaria','853100',NULL),(871,NULL,NULL,'Enseñanza universitaria excepto formación de posgrado','853201',NULL),(872,NULL,NULL,'Formación de posgrado','853300',NULL),(873,NULL,NULL,'Enseñanza de idiomas','854910',NULL),(874,NULL,NULL,'Enseñanza de cursos relacionados con informática','854920',NULL),(875,NULL,NULL,'Enseñanza para adultos, excepto discapacitados','854930',NULL),(876,NULL,NULL,'Enseñanza especial y para discapacitados','854940',NULL),(877,NULL,NULL,'Enseñanza de gimnasia, deportes y actividades físicas','854950',NULL),(878,NULL,NULL,'Enseñanza artística','854960',NULL),(879,NULL,NULL,'Servicios de enseñanza n.c.p.','854990',NULL),(880,NULL,NULL,'Servicios de apoyo a la educación','855000',NULL),(881,NULL,NULL,'Servicios de internación excepto instituciones relacionadas con la salud mental','861010',NULL),(882,NULL,NULL,'Servicios de internación en instituciones relacionadas con la salud mental','861020',NULL),(883,NULL,NULL,'Servicios de  consulta médica','862110',NULL);
INSERT INTO `activities` VALUES (884,NULL,NULL,'Servicios de proveedores de atención médica domiciliaria','862120',NULL),(885,NULL,NULL,'Servicios de atención médica en dispensarios, salitas, vacunatorios y otros locales de atención primaria de la salud','862130',NULL),(886,NULL,NULL,'Servicios odontológicos','862200',NULL),(887,NULL,NULL,'Servicios de prácticas de diagnóstico en laboratorios','863110',NULL),(888,NULL,NULL,'Servicios de prácticas de diagnóstico por imágenes','863120',NULL),(889,NULL,NULL,'Servicios de prácticas de diagnóstico n.c.p.','863190',NULL),(890,NULL,NULL,'Servicios de tratamiento','863200',NULL),(891,NULL,NULL,'Servicio médico integrado de consulta, diagnóstico y tratamiento','863300',NULL),(892,NULL,NULL,'Servicios de emergencias y traslados','864000',NULL),(893,NULL,NULL,'Servicios de rehabilitación física','869010',NULL),(894,NULL,NULL,'Servicios relacionados con la salud humana n.c.p.','869090',NULL),(895,NULL,NULL,'Servicios de atención a personas con problemas de salud mental o de adicciones, con alojamiento','870100',NULL),(896,NULL,NULL,'Servicios de atención a ancianos con alojamiento','870210',NULL),(897,NULL,NULL,'Servicios de atención a personas minusválidas con alojamiento','870220',NULL),(898,NULL,NULL,'Servicios de atención a niños y adolescentes carenciados con alojamiento','870910',NULL),(899,NULL,NULL,'Servicios de atención a mujeres con alojamiento','870920',NULL),(900,NULL,NULL,'Servicios sociales con alojamiento n.c.p.','870990',NULL),(901,NULL,NULL,'Servicios sociales sin alojamiento','880000',NULL),(902,NULL,NULL,'Producción de espectáculos teatrales y musicales','900011',NULL),(903,NULL,NULL,'Composición y representación de obras teatrales, musicales y artísticas','900021',NULL),(904,NULL,NULL,'Servicios conexos a la producción de espectáculos teatrales y musicales','900030',NULL),(905,NULL,NULL,'Servicios de agencias de ventas de entradas','900040',NULL),(906,NULL,NULL,'Servicios de espectáculos artísticos n.c.p.','900091',NULL),(907,NULL,NULL,'Servicios de bibliotecas y archivos','910100',NULL),(908,NULL,NULL,'Servicios de museos y preservación de lugares y edificios históricos','910200',NULL),(909,NULL,NULL,'Servicios de jardines botánicos, zoológicos y de parques nacionales','910300',NULL),(910,NULL,NULL,'Servicios culturales n.c.p.','910900',NULL),(911,NULL,NULL,'Servicios de recepción de apuestas de quiniela, lotería y similares','920001',NULL),(912,NULL,NULL,'Servicios relacionados con juegos de azar y apuestas n.c.p.','920009',NULL),(913,NULL,NULL,'Servicios de organización, dirección y gestión de prácticas deportivas en clubes','931010',NULL),(914,NULL,NULL,'Explotación de instalaciones deportivas, excepto clubes','931020',NULL),(915,NULL,NULL,'Promoción y producción de espectáculos deportivos','931030',NULL),(916,NULL,NULL,'Servicios prestados por deportistas y atletas para la realización de prácticas deportivas','931041',NULL),(917,NULL,NULL,'Servicios prestados por profesionales y técnicos para la realización de prácticas deportivas','931042',NULL),(918,NULL,NULL,'Servicios de acondicionamiento físico','931050',NULL),(919,NULL,NULL,'Servicios para la práctica deportiva n.c.p.','931090',NULL),(920,NULL,NULL,'Servicios de parques de diversiones y parques temáticos','939010',NULL),(921,NULL,NULL,'Servicios de salones de juegos','939020',NULL),(922,NULL,NULL,'Servicios de salones de baile, discotecas y similares','939030',NULL),(923,NULL,NULL,'Servicios de entretenimiento n.c.p.','939090',NULL),(924,NULL,NULL,'Servicios de organizaciones empresariales y de empleadores','941100',NULL),(925,NULL,NULL,'Servicios de organizaciones profesionales','941200',NULL),(926,NULL,NULL,'Servicios de sindicatos','942000',NULL),(927,NULL,NULL,'Servicios de organizaciones religiosas','949100',NULL),(928,NULL,NULL,'Servicios de organizaciones políticas','949200',NULL),(929,NULL,NULL,'Servicios de mutuales, excepto mutuales de salud y financieras','949910',NULL);
INSERT INTO `activities` VALUES (930,NULL,NULL,'Servicios de consorcios de edificios','949920',NULL),(931,NULL,NULL,'Servicios de cooperativas cuando realizan varias actividades','949930',NULL),(932,NULL,NULL,'Servicios de asociaciones n.c.p.','949990',NULL),(933,NULL,NULL,'Reparación y mantenimiento de equipos informáticos','951100',NULL),(934,NULL,NULL,'Reparación y mantenimiento de equipos de telefonía y de comunicación','951200',NULL),(935,NULL,NULL,'Reparación de calzado y artículos de marroquinería','952200',NULL),(936,NULL,NULL,'Reparación de tapizados y muebles','952300',NULL),(937,NULL,NULL,'Reforma y reparación de cerraduras, duplicación de llaves. Cerrajerías','952910',NULL),(938,NULL,NULL,'Reparación de relojes y joyas. Relojerías','952920',NULL),(939,NULL,NULL,'Reparación de efectos personales y enseres domésticos n.c.p.','952990',NULL),(940,NULL,NULL,'Servicios de limpieza de prendas prestado por tintorerías rápidas','960101',NULL),(941,NULL,NULL,'Lavado y limpieza de artículos de tela, cuero y/o de piel, incluso la limpieza en seco','960102',NULL),(942,NULL,NULL,'Servicios de peluquería','960201',NULL),(943,NULL,NULL,'Servicios de tratamiento de belleza, excepto los de peluquería','960202',NULL),(944,NULL,NULL,'Pompas fúnebres y servicios conexos','960300',NULL),(945,NULL,NULL,'Servicios de centros de estética, spa y similares','960910',NULL),(946,NULL,NULL,'Servicios personales n.c.p.','960990',NULL),(947,NULL,NULL,'Servicios de hogares privados que contratan servicio doméstico','970000',NULL),(948,NULL,NULL,'Servicios de organizaciones y órganos extraterritoriales','990000',NULL),(949,NULL,NULL,'Reparación de artículos eléctricos y electrónicos de uso doméstico','952100',NULL),(950,NULL,NULL,'Venta al por menor de CD\'s y DVD\'s de audio y video grabados','476200',NULL),(951,NULL,NULL,'Venta al por mayor de CD\'s y DVD\'s de audio y video grabados.','464910',NULL),(952,NULL,NULL,'Venta al por mayor en comisión o consignación de prod. textiles, prendas de vestir, calzado excepto el ortopédico, art.de marroquinería, paraguas y similares y prod.de cuero n.c.p','461091',NULL),(953,NULL,NULL,'Perforación y sondeo, excepto perforación de pozos de petróleo, de gas, de minas e hidráulicos  y prospección de yacimientos de petróleo','431220',NULL),(954,NULL,NULL,'Reparación y mantenimiento de instrumentos médicos,ópticos y de precisión,equipo fotográfico,aparatos para medir,ensayar o navegar,relojes,excepto para uso personal o doméstico','331301',NULL),(955,NULL,NULL,'Cría de ganado equino realizada en haras','014221',NULL),(956,NULL,NULL,'Jubilado','000007',NULL),(957,NULL,NULL,'Estudiante','000008',NULL),(958,NULL,NULL,'Ama de casa','000009',NULL),(959,NULL,NULL,'Ex - Agente de la Adm. Publica','000010',NULL),(960,NULL,NULL,'Trabajo Relac. Dependencia','000011',NULL),(961,NULL,NULL,'Sin Actividad Economica','000012',NULL),(962,NULL,NULL,'Agricultura Familiar','000013',NULL);
/*!40000 ALTER TABLE `activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_fact_elec`
--

DROP TABLE IF EXISTS `afip_fact_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_fact_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_fact_elec_person_id_foreign` (`person_id`),
  KEY `afip_fact_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_fact_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_fact_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_fact_elec`
--

LOCK TABLES `afip_fact_elec` WRITE;
/*!40000 ALTER TABLE `afip_fact_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_fact_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `afip_ventanilla_elec`
--

DROP TABLE IF EXISTS `afip_ventanilla_elec`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `afip_ventanilla_elec` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_id_relationed` int(10) unsigned NOT NULL,
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `habilitado` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `afip_ventanilla_elec_person_id_foreign` (`person_id`),
  KEY `afip_ventanilla_elec_person_id_relationed_foreign` (`person_id_relationed`),
  CONSTRAINT `afip_ventanilla_elec_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `afip_ventanilla_elec_person_id_relationed_foreign` FOREIGN KEY (`person_id_relationed`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `afip_ventanilla_elec`
--

LOCK TABLES `afip_ventanilla_elec` WRITE;
/*!40000 ALTER TABLE `afip_ventanilla_elec` DISABLE KEYS */;
/*!40000 ALTER TABLE `afip_ventanilla_elec` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aj_por_infl_indices`
--

DROP TABLE IF EXISTS `aj_por_infl_indices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `aj_por_infl_indices` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anio` int(10) unsigned NOT NULL,
  `mes` int(10) unsigned NOT NULL,
  `desde` date NOT NULL,
  `hasta` date NOT NULL,
  `indice` decimal(16,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `aj_por_infl_indices`
--

LOCK TABLES `aj_por_infl_indices` WRITE;
/*!40000 ALTER TABLE `aj_por_infl_indices` DISABLE KEYS */;
INSERT INTO `aj_por_infl_indices` VALUES ('2015-1','2015-01',2015,1,'2015-01-01','2015-01-31',63.5306,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-2','2015-02',2015,2,'2015-02-01','2015-02-28',63.6887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-3','2015-03',2015,3,'2015-03-01','2015-03-31',64.3132,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-4','2015-04',2015,4,'2015-04-01','2015-04-30',64.7923,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-5','2015-05',2015,5,'2015-05-01','2015-05-31',65.7528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-6','2015-06',2015,6,'2015-06-01','2015-06-30',66.6176,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-7','2015-07',2015,7,'2015-07-01','2015-07-31',67.5751,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-8','2015-08',2015,8,'2015-08-01','2015-08-31',68.5401,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-9','2015-09',2015,9,'2015-09-01','2015-09-30',69.4659,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-10','2015-10',2015,10,'2015-10-01','2015-10-31',70.1100,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-11','2015-11',2015,11,'2015-11-01','2015-11-30',71.5122,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2015-12','2015-12',2015,12,'2015-12-01','2015-12-31',74.3012,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-1','2016-01',2016,1,'2016-01-01','2016-01-31',80.9883,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-2','2016-02',2016,2,'2016-02-01','2016-02-28',85.0377,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-3','2016-03',2016,3,'2016-03-01','2016-03-31',87.0786,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-4','2016-04',2016,4,'2016-04-01','2016-04-30',88.3847,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-5','2016-05',2016,5,'2016-05-01','2016-05-31',91.5666,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-6','2016-06',2016,6,'2016-06-01','2016-06-30',94.2220,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-7','2016-07',2016,7,'2016-07-01','2016-07-31',96.7660,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-8','2016-08',2016,8,'2016-08-01','2016-08-31',97.1531,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-9','2016-09',2016,9,'2016-09-01','2016-09-30',97.5417,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-10','2016-10',2016,10,'2016-10-01','2016-10-31',98.1270,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-11','2016-11',2016,11,'2016-11-01','2016-11-30',99.2063,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2016-12','2016-12',2016,12,'2016-12-01','2016-12-31',100.0000,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-1','2017-01',2017,1,'2017-01-01','2017-01-31',101.5859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-2','2017-02',2017,2,'2017-02-01','2017-02-28',103.6859,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-3','2017-03',2017,3,'2017-03-01','2017-03-31',106.1476,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-4','2017-04',2017,4,'2017-04-01','2017-04-30',108.9667,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-5','2017-05',2017,5,'2017-05-01','2017-05-31',110.5301,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-6','2017-06',2017,6,'2017-06-01','2017-06-30',111.8477,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-7','2017-07',2017,7,'2017-07-01','2017-07-31',113.7852,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-8','2017-08',2017,8,'2017-08-01','2017-08-31',115.3819,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-9','2017-09',2017,9,'2017-09-01','2017-09-30',117.5719,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-10','2017-10',2017,10,'2017-10-01','2017-10-31',119.3528,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2017-11','2017-11',2017,11,'2017-11-01','2017-11-30',120.9940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2017-12','2017-12',2017,12,'2017-12-01','2017-12-31',124.7956,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-1','2018-01',2018,1,'2018-01-01','2018-01-31',126.9887,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-2','2018-02',2018,2,'2018-02-01','2018-02-28',130.0606,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-3','2018-03',2018,3,'2018-03-01','2018-03-31',133.1054,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-4','2018-04',2018,4,'2018-04-01','2018-04-30',136.7512,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-5','2018-05',2018,5,'2018-05-01','2018-05-31',139.5893,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-6','2018-06',2018,6,'2018-06-01','2018-06-30',144.8053,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-7','2018-07',2018,7,'2018-07-01','2018-07-31',149.2966,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-8','2018-08',2018,8,'2018-08-01','2018-08-31',155.1034,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-9','2018-09',2018,9,'2018-09-01','2018-09-30',165.2383,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-10','2018-10',2018,10,'2018-10-01','2018-10-31',174.1473,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-11','2018-11',2018,11,'2018-11-01','2018-11-30',179.6388,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2018-12','2018-12',2018,12,'2018-12-01','2018-12-31',184.2552,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-1','2019-01',2019,1,'2019-01-01','2019-01-31',189.6101,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-2','2019-02',2019,2,'2019-02-01','2019-02-28',196.7501,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-3','2019-03',2019,3,'2019-03-01','2019-03-31',205.9571,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-4','2019-04',2019,4,'2019-04-01','2019-04-30',213.0517,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-5','2019-05',2019,5,'2019-05-01','2019-05-31',219.5691,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-6','2019-06',2019,6,'2019-06-01','2019-06-30',225.5370,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-7','2019-07',2019,7,'2019-07-01','2019-07-31',230.4940,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-8','2019-08',2019,8,'2019-08-01','2019-08-31',239.6077,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-9','2019-09',2019,9,'2019-09-01','2019-09-30',253.7102,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-10','2019-10',2019,10,'2019-10-01','2019-10-31',262.0661,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-11','2019-11',2019,11,'2019-11-01','2019-11-30',273.2158,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2019-12','2019-12',2019,12,'2019-12-01','2019-12-31',283.4442,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-1','2020-01',2020,1,'2020-01-01','2020-01-31',289.8299,'2020-03-01 06:39:20','2020-03-01 06:39:20',NULL),('2020-2','2020-02',2020,2,'2020-02-01','2020-02-29',295.6660,NULL,NULL,NULL),('2020-3','2020-03',2020,3,'2020-03-01','2020-03-31',305.5515,NULL,NULL,NULL),('2020-4','2020-04',2020,4,'2020-04-01','2020-04-30',310.1243,NULL,NULL,NULL),('2020-5','2020-05',2020,5,'2020-05-01','2020-05-31',314.9087,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-7','2012-07',2012,7,'2012-07-01','2012-07-31',40.9200,NULL,NULL,NULL),('2012-8','2012-08',2012,8,'2012-08-01','2012-08-31',41.3400,NULL,NULL,NULL),('2012-9','2012-09',2012,9,'2012-09-01','2012-09-30',41.8000,NULL,NULL,NULL),('2012-10','2012-10',2012,10,'2012-10-01','2012-10-31',42.2300,NULL,NULL,NULL),('2012-11','2012-11',2012,11,'2012-11-01','2012-11-30',42.6600,NULL,NULL,NULL),('2012-12','2012-12',2012,12,'2012-12-01','2012-12-31',43.0700,NULL,NULL,NULL),('2013-1','2013-01',2013,1,'2013-01-01','2013-01-31',43.5100,NULL,NULL,NULL),('2013-2','2013-02',2013,2,'2013-02-01','2013-02-28',43.9700,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2013-3','2013-03',2013,3,'2013-03-01','2013-03-31',44.4100,NULL,NULL,NULL),('2013-4','2013-04',2013,4,'2013-04-01','2013-04-30',44.8400,NULL,NULL,NULL),('2013-5','2013-05',2013,5,'2013-05-01','2013-05-31',45.4000,NULL,NULL,NULL),('2013-6','2013-06',2013,6,'2013-06-01','2013-06-30',46.0100,NULL,NULL,NULL),('2013-7','2013-07',2013,7,'2013-07-01','2013-07-31',46.5300,NULL,NULL,NULL),('2013-8','2013-08',2013,8,'2013-08-01','2013-08-31',47.0600,NULL,NULL,NULL),('2013-9','2013-09',2013,9,'2013-09-01','2013-09-30',47.5800,NULL,NULL,NULL),('2013-10','2013-10',2013,10,'2013-10-01','2013-10-31',48.1200,NULL,NULL,NULL),('2013-11','2013-11',2013,11,'2013-11-01','2013-11-30',48.7000,NULL,NULL,NULL),('2013-12','2013-12',2013,12,'2013-12-01','2013-12-31',49.4300,NULL,NULL,NULL),('2014-1','2014-01',2014,1,'2014-01-01','2014-01-31',51.8800,NULL,NULL,NULL),('2014-2','2014-02',2014,2,'2014-02-01','2014-02-28',54.5400,NULL,NULL,NULL),('2014-3','2014-03',2014,3,'2014-03-01','2014-03-31',55.8600,NULL,NULL,NULL),('2014-4','2014-04',2014,4,'2014-04-01','2014-04-30',56.8200,NULL,NULL,NULL),('2014-5','2014-05',2014,5,'2014-05-01','2014-05-31',57.8800,NULL,NULL,NULL),('2014-6','2014-06',2014,6,'2014-06-01','2014-06-30',58.7600,NULL,NULL,NULL),('2014-7','2014-07',2014,7,'2014-07-01','2014-07-31',59.5500,NULL,NULL,NULL),('2014-8','2014-08',2014,8,'2014-08-01','2014-08-31',60.5200,NULL,NULL,NULL),('2014-9','2014-09',2014,9,'2014-09-01','2014-09-30',61.4800,NULL,NULL,NULL),('2014-10','2014-10',2014,10,'2014-10-01','2014-10-31',62.2400,NULL,NULL,NULL),('2014-11','2014-11',2014,11,'2014-11-01','2014-11-30',62.8100,NULL,NULL,NULL),('2014-12','2014-12',2014,12,'2014-12-01','2014-12-31',63.4000,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2012-6','2012-06',2012,6,'2012-06-01','2012-06-30',40.5200,NULL,NULL,NULL),('2020-6','2020-06',2020,6,'2020-06-01','2020-06-30',321.9738,NULL,NULL,NULL),('2020-7','2020-07',2020,7,'2020-07-01','2020-07-31',328.2014,NULL,NULL,NULL),('2020-8','2020-08',2020,8,'2020-08-01','2020-08-31',337.0632,NULL,NULL,NULL),('2020-9','2020-09',2020,9,'2020-09-01','2020-09-30',346.6207,NULL,NULL,NULL),('2020-10','2020-10',2020,10,'2020-10-01','2020-10-31',359.6570,NULL,NULL,NULL),('2020-11','2020-11',2020,11,'2020-11-01','2020-11-30',371.0211,NULL,NULL,NULL),('2020-12','2020-12',2020,12,'2020-12-01','2020-12-31',385.8826,NULL,NULL,NULL),('2021-1','2021-01',2021,1,'2021-01-01','2021-01-31',401.5071,NULL,NULL,NULL),('2021-2','2021-02',2021,2,'2021-02-01','2021-02-28',415.8595,NULL,NULL,NULL),('2021-3','2021-03',2021,3,'2021-03-01','2021-03-31',435.8657,NULL,NULL,NULL),('2021-4','2021-04',2021,4,'2021-04-01','2021-04-30',453.6503,NULL,NULL,NULL),('2021-5','2021-05',2021,5,'2021-05-01','2021-05-31',468.7250,NULL,NULL,NULL),('2021-6','2021-06',2021,6,'2021-06-01','2021-06-30',483.6049,NULL,NULL,NULL),('2021-7','2021-07',2021,7,'2021-07-01','2021-07-31',498.0987,NULL,NULL,NULL),('2021-8','2021-08',2021,8,'2021-08-01','2021-08-31',510.3942,NULL,NULL,NULL),('2021-9','2021-09',2021,9,'2021-09-01','2021-09-30',528.4968,NULL,NULL,NULL),('2021-10','2021-10',2021,10,'2021-10-01','2021-10-31',547.0802,NULL,NULL,NULL);
INSERT INTO `aj_por_infl_indices` VALUES ('2021-11','2021-11',2021,11,'2021-11-01','2021-11-30',560.9184,NULL,NULL,NULL),('2021-12','2021-12',2021,12,'2021-12-01','2021-12-31',582.4575,NULL,NULL,NULL),('2022-1','2022-01',2022,1,'2022-01-01','2022-01-31',605.0317,NULL,NULL,NULL),('2022-2','2022-02',2022,2,'2022-02-01','2022-02-28',633.4341,NULL,NULL,NULL),('2022-3','2022-03',2022,3,'2022-03-01','2022-03-31',676.0566,NULL,NULL,NULL);
/*!40000 ALTER TABLE `aj_por_infl_indices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auxiliar`
--

DROP TABLE IF EXISTS `auxiliar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auxiliar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `descripcion` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auxiliar`
--

LOCK TABLES `auxiliar` WRITE;
/*!40000 ALTER TABLE `auxiliar` DISABLE KEYS */;
/*!40000 ALTER TABLE `auxiliar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_charlas_details`
--

DROP TABLE IF EXISTS `back_up_charlas_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_charlas_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `charla` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_charlas_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_charlas_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_charlas_details`
--

LOCK TABLES `back_up_charlas_details` WRITE;
/*!40000 ALTER TABLE `back_up_charlas_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_charlas_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_claves_details`
--

DROP TABLE IF EXISTS `back_up_claves_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_claves_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clave_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_claves_details_clave_id_foreign` (`clave_id`),
  KEY `back_up_claves_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_claves_details_clave_id_foreign` FOREIGN KEY (`clave_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_claves_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_claves_details`
--

LOCK TABLES `back_up_claves_details` WRITE;
/*!40000 ALTER TABLE `back_up_claves_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_claves_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `back_up_mails_details`
--

DROP TABLE IF EXISTS `back_up_mails_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `back_up_mails_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `modificado` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `back_up_mails_details_mail_id_foreign` (`mail_id`),
  KEY `back_up_mails_details_person_id_foreign` (`person_id`),
  CONSTRAINT `back_up_mails_details_mail_id_foreign` FOREIGN KEY (`mail_id`) REFERENCES `claves` (`id`),
  CONSTRAINT `back_up_mails_details_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `back_up_mails_details`
--

LOCK TABLES `back_up_mails_details` WRITE;
/*!40000 ALTER TABLE `back_up_mails_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `back_up_mails_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asiento_modelo_detail`
--

DROP TABLE IF EXISTS `balance_asiento_modelo_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asiento_modelo_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `balance_asiento_modelo_id` int(10) unsigned NOT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `plan_cuenta_id` int(10) unsigned NOT NULL,
  `saldo_id` int(10) unsigned DEFAULT NULL,
  `monto` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` (`balance_asiento_modelo_id`),
  KEY `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asiento_modelo_detail_plan_cuenta_id_foreign` (`plan_cuenta_id`),
  KEY `balance_asiento_modelo_detail_saldo_id_foreign` (`saldo_id`),
  CONSTRAINT `balance_asiento_modelo_detail_balance_asiento_modelo_id_foreign` FOREIGN KEY (`balance_asiento_modelo_id`) REFERENCES `balance_asientos_modelos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asiento_modelo_detail_plan_cuenta_id_foreign` FOREIGN KEY (`plan_cuenta_id`) REFERENCES `conta_plan_cuenta` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asiento_modelo_detail`
--

LOCK TABLES `balance_asiento_modelo_detail` WRITE;
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` DISABLE KEYS */;
INSERT INTO `balance_asiento_modelo_detail` VALUES (1,1,21,62,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,1,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(3,2,21,63,1,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(4,2,21,359,2,0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asiento_modelo_detail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_asientos_modelos`
--

DROP TABLE IF EXISTS `balance_asientos_modelos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_asientos_modelos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `period_id` int(10) unsigned NOT NULL DEFAULT '1',
  `comentario` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_asientos_modelos_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_asientos_modelos_period_id_foreign` (`period_id`),
  CONSTRAINT `balance_asientos_modelos_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_asientos_modelos_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_asientos_modelos`
--

LOCK TABLES `balance_asientos_modelos` WRITE;
/*!40000 ALTER TABLE `balance_asientos_modelos` DISABLE KEYS */;
INSERT INTO `balance_asientos_modelos` VALUES (1,NULL,21,1,'Pago de Sueldos',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL),(2,NULL,21,1,'Pago de SUSS',0.00,'2019-11-25 18:49:45','2019-11-25 18:49:45',NULL);
/*!40000 ALTER TABLE `balance_asientos_modelos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_libro`
--

DROP TABLE IF EXISTS `balance_libro`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_libro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `person_id` int(10) unsigned DEFAULT NULL,
  `period_id` int(10) unsigned DEFAULT NULL,
  `conta_tipo_asiento_id` int(10) unsigned NOT NULL,
  `receipt_id` int(10) unsigned DEFAULT NULL,
  `period_liquidation_id` int(10) unsigned DEFAULT NULL,
  `conta_asiento_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_cliente_id` int(10) unsigned DEFAULT NULL,
  `cta_cte_tesoreria_id` int(10) unsigned DEFAULT NULL,
  `nf_cta_cte_id` int(10) unsigned DEFAULT NULL,
  `inv_orden_trabajo_id` bigint(20) unsigned DEFAULT NULL,
  `syj_sueldos` tinyint(1) DEFAULT '0',
  `num_asiento` int(11) DEFAULT NULL,
  `fecha_registracion` date DEFAULT NULL,
  `fecha_vencimiento` date DEFAULT NULL,
  `total` decimal(16,2) NOT NULL,
  `comentario` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `balance_libro_person_id_foreign` (`person_id`),
  KEY `balance_libro_period_id_foreign` (`period_id`),
  KEY `balance_libro_conta_tipo_asiento_id_foreign` (`conta_tipo_asiento_id`),
  KEY `balance_libro_period_liquidation_id_foreign` (`period_liquidation_id`),
  KEY `balance_libro_conta_asiento_foreign` (`conta_asiento_id`),
  KEY `balance_libro_cta_cte_cliente_id_foreign` (`cta_cte_cliente_id`),
  KEY `balance_libro_cta_cte_tesoreria_id_foreign` (`cta_cte_tesoreria_id`),
  KEY `balance_libro_nf_cta_cte_id_foreign` (`nf_cta_cte_id`),
  KEY `balance_libro_receipt_id_foreign` (`receipt_id`),
  KEY `balance_libro_inv_orden_trabajo_id_foreign` (`inv_orden_trabajo_id`),
  CONSTRAINT `balance_libro_conta_asiento_foreign` FOREIGN KEY (`conta_asiento_id`) REFERENCES `conta_asientos` (`id`),
  CONSTRAINT `balance_libro_conta_tipo_asiento_id_foreign` FOREIGN KEY (`conta_tipo_asiento_id`) REFERENCES `conta_tipo_asientos` (`id`),
  CONSTRAINT `balance_libro_cta_cte_cliente_id_foreign` FOREIGN KEY (`cta_cte_cliente_id`) REFERENCES `cta_cte_cliente` (`id`),
  CONSTRAINT `balance_libro_cta_cte_tesoreria_id_foreign` FOREIGN KEY (`cta_cte_tesoreria_id`) REFERENCES `cta_cte_tesoreria` (`id`),
  CONSTRAINT `balance_libro_inv_orden_trabajo_id_foreign` FOREIGN KEY (`inv_orden_trabajo_id`) REFERENCES `inv_orden_trabajos` (`id`),
  CONSTRAINT `balance_libro_nf_cta_cte_id_foreign` FOREIGN KEY (`nf_cta_cte_id`) REFERENCES `nf_cta_cte` (`id`),
  CONSTRAINT `balance_libro_period_id_foreign` FOREIGN KEY (`period_id`) REFERENCES `periods` (`id`),
  CONSTRAINT `balance_libro_period_liquidation_id_foreign` FOREIGN KEY (`period_liquidation_id`) REFERENCES `period_liquidations` (`id`),
  CONSTRAINT `balance_libro_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `balance_libro_receipt_id_foreign` FOREIGN KEY (`receipt_id`) REFERENCES `receipts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6775 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_libro`
--

LOCK TABLES `balance_libro` WRITE;
/*!40000 ALTER TABLE `balance_libro` DISABLE KEYS */;
INSERT INTO `balance_libro` VALUES (1,3705,40729,7920,3,1,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',7605.00,NULL,NULL,1,'2021-07-16 23:36:03','2021-07-16 23:36:03',NULL),(2,3705,40729,7920,2,2,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',8930.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(3,3705,40729,7920,2,3,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',9400.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(4,3705,40729,7920,2,4,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1440.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(5,3705,40729,7920,2,5,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',8460.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(6,3705,40729,7920,2,6,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3900.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(7,3705,40729,7920,2,7,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',4230.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(8,3705,40729,7920,2,8,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',5640.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(9,3705,40729,7920,2,9,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',6580.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(10,3705,40729,7920,2,10,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',5170.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(11,3705,40729,7920,2,11,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',7800.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(12,3705,40729,7920,2,12,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',7520.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(13,3705,40729,7920,2,13,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1440.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(14,3705,40729,7920,2,14,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',6110.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(15,3705,40729,7920,2,15,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',3290.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(16,3705,40729,7920,2,16,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',5170.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(17,3705,40729,7920,2,17,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',7520.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(18,3705,40729,7920,2,18,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',6580.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(19,3705,40729,7920,2,19,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',4700.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(20,3705,40729,7920,2,20,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',8900.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(21,3705,40729,7920,2,21,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',8900.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(22,3705,40729,7920,2,22,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',4450.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(23,3705,40729,7920,2,23,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',8900.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(24,3705,40729,7920,2,24,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1440.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(25,3705,40729,7920,2,25,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',2820.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL);
INSERT INTO `balance_libro` VALUES (26,3705,40729,7920,2,26,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',6110.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(27,3705,40729,7920,2,27,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',7990.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(28,3705,40729,7920,2,28,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',6580.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(29,3705,40729,7920,2,29,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',3760.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(30,3705,40729,7920,2,30,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1440.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(31,3705,40729,7920,2,31,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',7800.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(32,3705,40729,7920,2,32,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',9400.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(33,3705,40729,7920,2,33,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1440.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(34,3705,40729,7920,2,34,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',8460.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(35,3705,40729,7920,2,35,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',7050.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(36,3705,40729,7920,2,36,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',3900.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(37,3705,40729,7920,2,37,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',5170.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(38,3705,40729,7920,2,38,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',5640.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(39,3705,40729,7920,2,39,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',3290.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(40,3705,40729,7920,2,40,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',4230.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(41,3705,40729,7920,2,41,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',4230.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(42,3705,40729,7920,2,42,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1440.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(43,3705,40729,7920,2,43,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1880.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(44,3705,40729,7920,2,44,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',6110.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(45,3705,40729,7920,2,45,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1440.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(46,3705,40729,7920,2,46,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',7800.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(47,3705,40729,7920,2,47,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',9870.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(48,3705,40729,7920,2,48,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',7990.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(49,3705,40729,7920,2,49,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',5170.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(50,3705,40729,7920,2,50,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',7520.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL);
INSERT INTO `balance_libro` VALUES (51,3705,40729,7920,2,51,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1440.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(52,3705,40729,7920,2,52,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',5640.00,NULL,NULL,1,'2021-07-28 21:01:45','2021-07-28 21:01:45',NULL),(53,3705,40729,7920,2,53,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1440.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(54,3705,40729,7920,2,54,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1880.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(55,3705,40729,7920,2,55,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',3900.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(56,3705,40729,7920,2,56,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',8930.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(57,3705,40729,7920,2,57,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',6580.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(58,3705,40729,7920,2,58,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',5170.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(59,3705,40729,7920,2,59,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',7800.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(60,3705,40729,7920,2,60,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',9870.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(61,3705,40729,7920,2,61,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1440.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(62,3705,40729,7920,2,62,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',7520.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(63,3705,40729,7920,2,63,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1440.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(64,3705,40729,7920,2,64,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',4700.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(65,3705,40729,7920,2,65,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',5640.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(66,3705,40729,7920,2,66,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',4700.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(67,3705,40729,7920,2,67,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',7990.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(68,3705,40729,7920,2,68,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1440.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(69,3705,40729,7920,2,69,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',5640.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(70,3705,40729,7920,2,70,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',3900.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(71,3705,40729,7920,2,71,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',6580.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(72,3705,40729,7920,2,72,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',8460.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(73,3705,40729,7920,2,73,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',7800.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(74,3705,40729,7920,2,74,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',6110.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(75,3705,40729,7920,2,75,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',5640.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL);
INSERT INTO `balance_libro` VALUES (76,3705,40729,7920,2,76,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',9870.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(77,3705,40729,7920,2,77,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',3900.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(78,3705,40729,7920,2,78,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',6110.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(79,3705,40729,7920,2,79,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',4230.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(80,3705,40729,7920,2,80,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1440.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(81,3705,40729,7920,2,81,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',7050.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(82,3705,40729,7920,2,82,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',5640.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(83,3705,40729,7920,2,83,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1440.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(84,3705,40729,7920,2,84,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',4230.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(85,3705,40729,7920,2,85,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',7520.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(86,3705,40729,7920,2,86,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',1440.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(87,3705,40729,7920,2,87,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',5640.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(88,3705,40729,7920,2,88,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',7990.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(89,3705,40729,7920,2,89,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',4700.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(90,3705,40729,7920,2,90,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',7050.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(91,3705,40729,7920,2,91,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',1440.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(92,3705,40729,7920,2,92,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',6110.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(93,3705,40729,7920,2,93,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',7800.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(94,3705,40729,7920,2,94,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',9400.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(95,3705,40729,7920,2,95,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',7800.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(96,3705,40729,7920,2,96,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',7800.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(97,3705,40729,7920,2,97,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',9870.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(98,3705,40729,7920,2,98,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',1440.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(99,3705,40729,7920,2,99,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',6110.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(100,3705,40729,7920,2,100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',8460.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL);
INSERT INTO `balance_libro` VALUES (101,3705,40729,7920,2,101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',6580.00,NULL,NULL,1,'2021-07-28 21:01:46','2021-07-28 21:01:46',NULL),(102,3705,40729,7920,2,102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',3900.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(103,3705,40729,7920,2,103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',3290.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(104,3705,40729,7920,2,104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',1440.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(105,3705,40729,7920,2,105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',2160.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(106,3705,40729,7920,2,106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',5640.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(107,3705,40729,7920,2,107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',4230.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(108,3705,40729,7920,2,108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',7800.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(109,3705,40729,7920,2,109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',9400.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(110,3705,40729,7920,2,110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',7990.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(111,3705,40729,7920,2,111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',4700.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(112,3705,40729,7920,2,112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',3900.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(113,3705,40729,7920,2,113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',8460.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(114,3705,40729,7920,2,114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',4230.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(115,3705,40729,7920,2,115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',6110.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(116,3705,40729,7920,2,116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',7520.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(117,3705,40729,7920,2,117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',2820.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(118,3705,40729,7920,2,118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',720.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(119,3705,40729,7920,2,119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',5640.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(120,3705,40729,7920,2,120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',7800.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(121,3705,40729,7920,2,121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',8460.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(122,3705,40729,7920,2,122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',3900.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(123,3705,40729,7920,2,123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',7520.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(124,3705,40729,7920,2,124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',5170.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(125,3705,40729,7920,2,125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',6110.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL);
INSERT INTO `balance_libro` VALUES (126,3705,40729,7920,2,126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1440.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(127,3705,40729,7920,2,127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',5170.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(128,3705,40729,7920,2,128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',3290.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(129,3705,40729,7920,2,129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',4700.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(130,3705,40729,7920,2,130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',6110.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(131,3705,40729,7920,2,131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',3760.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(132,3705,40729,7920,2,132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1340.01,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(133,3705,40729,7920,2,133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',720.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(134,3705,40729,7920,2,134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',6110.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(135,3705,40729,7920,2,135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',3290.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(136,3705,40729,7920,2,136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',7990.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(137,3705,40729,7920,2,137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',7800.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(138,3705,40729,7920,2,138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',8460.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(139,3705,40729,7920,2,139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',9870.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(140,3705,40729,7920,2,140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4230.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(141,3705,40729,7920,2,141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1440.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(142,3705,40729,7920,2,142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',5640.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(143,3705,40729,7920,2,143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',6580.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(144,3705,40729,7920,2,144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4700.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(145,3705,40729,7920,2,145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',2160.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(146,3705,40729,7920,2,146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',7520.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(147,3705,40729,7920,2,147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',5640.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(148,3705,40729,7920,2,148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',9870.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(149,3705,40729,7920,2,149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',7800.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(150,3705,40729,7920,2,150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',8930.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL);
INSERT INTO `balance_libro` VALUES (151,3705,40729,7920,2,151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',3900.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(152,3705,40729,7920,2,152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',4700.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(153,3705,40729,7920,2,153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',6110.00,NULL,NULL,1,'2021-07-28 21:01:47','2021-07-28 21:01:47',NULL),(154,3705,40729,7920,2,154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',5170.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(155,3705,40729,7920,2,155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',6580.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(156,3705,40729,7920,2,156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',3760.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(157,3705,40729,7920,2,157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',2820.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(158,3705,40729,7920,2,158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',4500.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(159,3705,40729,7920,2,159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5170.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(160,3705,40729,7920,2,160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',4230.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(161,3705,40729,7920,2,161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',6110.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(162,3705,40729,7920,2,162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',8930.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(163,3705,40729,7920,2,163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',4700.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(164,3705,40729,7920,2,164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',6110.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(165,3705,40729,7920,2,165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',7990.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(166,3705,40729,7920,2,166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',5640.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(167,3705,40729,7920,2,167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3760.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(168,3705,40729,7920,2,168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',6580.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(169,3705,40729,7920,2,169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',4700.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(170,3705,40729,7920,2,170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3290.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(171,3705,40729,7920,2,171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1440.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(172,3705,40729,7920,2,172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',7990.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(173,3705,40729,7920,2,173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1440.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(174,3705,40729,7920,2,174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',5170.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(175,3705,40729,7920,2,175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',6110.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL);
INSERT INTO `balance_libro` VALUES (176,3705,40729,7920,2,176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3900.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(177,3705,40729,7920,2,177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1440.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(178,3705,40729,7920,2,178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',5640.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(179,3705,40729,7920,2,179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',4230.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(180,3705,40729,7920,2,180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',9870.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(181,3705,40729,7920,2,181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',7800.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(182,3705,40729,7920,2,182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',9400.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(183,3705,40729,7920,2,183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',8460.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(184,3705,40729,7920,2,184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',8900.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(185,3705,40729,7920,2,185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',8900.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(186,3705,40729,7920,2,186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1440.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(187,3705,40729,7920,2,187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',7050.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(188,3705,40729,7920,2,188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',4700.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(189,3705,40729,7920,2,189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',7800.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(190,3705,40729,7920,2,190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',7990.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(191,3705,40729,7920,2,191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',6110.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(192,3705,40729,7920,2,192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',4700.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(193,3705,40729,7920,2,193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',720.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(194,3705,40729,7920,2,194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',5640.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(195,3705,40729,7920,2,195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',3900.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(196,3705,40729,7920,2,196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',8930.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(197,3705,40729,7920,2,197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',7050.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(198,3705,40729,7920,2,198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',4230.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(199,3705,40729,7920,2,199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',4700.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(200,3705,40729,7920,2,200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',6580.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL);
INSERT INTO `balance_libro` VALUES (201,3705,40729,7920,2,201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',2820.00,NULL,NULL,1,'2021-07-28 21:01:48','2021-07-28 21:01:48',NULL),(202,3705,40729,7920,2,202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',8460.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(203,3705,40729,7920,2,203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',7800.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(204,3705,40729,7920,2,204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',6110.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(205,3705,40729,7920,2,205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1440.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(206,3705,40729,7920,2,206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',9400.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(207,3705,40729,7920,2,207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',7990.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(208,3705,40729,7920,2,208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',3900.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(209,3705,40729,7920,2,209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',5640.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(210,3705,40729,7920,2,210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',4700.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(211,3705,40729,7920,2,211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',720.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(212,3705,40729,7920,2,212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',6110.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(213,3705,40729,7920,2,213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',4230.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(214,3705,40729,7920,2,214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1000.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(215,3705,40729,7920,2,215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',2820.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(216,3705,40729,7920,2,216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',4700.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(217,3705,40729,7920,2,217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1440.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(218,3705,40729,7920,2,218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',6110.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(219,3705,40729,7920,2,219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',7800.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(220,3705,40729,7920,2,220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',8460.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(221,3705,40729,7920,2,221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',7800.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(222,3705,40729,7920,2,222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',9400.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(223,3705,40729,7920,2,223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',4700.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(224,3705,40729,7920,2,224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1440.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(225,3705,40729,7920,2,225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',5640.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL);
INSERT INTO `balance_libro` VALUES (226,3705,40729,7920,2,226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1440.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(227,3705,40729,7920,2,227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',7520.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(228,3705,40729,7920,2,228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',7050.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(229,3705,40729,7920,2,229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',7800.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(230,3705,40729,7920,2,230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',6110.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(231,3705,40729,7920,2,231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',9870.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(232,3705,40729,7920,2,232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',5640.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(233,3705,40729,7920,2,233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',4700.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(234,3705,40729,7920,2,234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',4230.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(235,3705,40729,7920,2,235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1440.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(236,3705,40729,7920,2,236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',7990.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(237,3705,40729,7920,2,237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',5170.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(238,3705,40729,7920,2,238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',8460.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(239,3705,40729,7920,2,239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1440.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(240,3705,40729,7920,2,240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',5640.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(241,3705,40729,7920,2,241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',3290.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(242,3705,40729,7920,2,242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1440.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(243,3705,40729,7920,2,243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',9870.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(244,3705,40729,7920,2,244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',8930.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(245,3705,40729,7920,2,245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',6110.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(246,3705,40729,7920,2,246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',7050.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(247,3705,40729,7920,2,247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',5640.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(248,3705,40729,7920,2,248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',7800.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(249,3705,40729,7920,2,249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',3900.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(250,3705,40729,7920,2,250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',4700.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL);
INSERT INTO `balance_libro` VALUES (251,3705,40729,7920,2,251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',6580.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(252,3705,40729,7920,2,252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',5640.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(253,3705,40729,7920,2,253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',7050.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(254,3705,40729,7920,2,254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',720.00,NULL,NULL,1,'2021-07-28 21:01:49','2021-07-28 21:01:49',NULL),(255,3705,40729,7920,2,255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',5170.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(256,3705,40729,7920,2,256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1440.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(257,3705,40729,7920,2,257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',6110.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(258,3705,40729,7920,2,258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',5640.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(259,3705,40729,7920,2,259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4230.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(260,3705,40729,7920,2,260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',7050.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(261,3705,40729,7920,2,261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',720.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(262,3705,40729,7920,2,262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',5170.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(263,3705,40729,7920,2,263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1440.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(264,3705,40729,7920,2,264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',7520.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(265,3705,40729,7920,2,265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',6580.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(266,3705,40729,7920,2,266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4700.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(267,3705,40729,7920,2,267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',7800.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(268,3705,40729,7920,2,268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',8930.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(269,3705,40729,7920,2,269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',9870.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(270,3705,40729,7920,2,270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',7800.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(271,3705,40729,7920,2,271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',6110.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(272,3705,40729,7920,2,272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1440.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(273,3705,40729,7920,2,273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4700.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(274,3705,40729,7920,2,274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1880.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(275,3705,40729,7920,2,275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',7800.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL);
INSERT INTO `balance_libro` VALUES (276,3705,40729,7920,2,276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',8460.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(277,3705,40729,7920,2,277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',9400.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(278,3705,40729,7920,2,278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',6580.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(279,3705,40729,7920,2,279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',9870.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(280,3705,40729,7920,2,280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1440.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(281,3705,40729,7920,2,281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',6580.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(282,3705,40729,7920,2,282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',4230.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(283,3705,40729,7920,2,283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1440.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(284,3705,40729,7920,2,284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3900.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(285,3705,40729,7920,2,285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',3290.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(286,3705,40729,7920,2,286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2350.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(287,3705,40729,7920,2,287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',7800.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(288,3705,40729,7920,2,288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',7050.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(289,3705,40729,7920,2,289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',9400.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(290,3705,40729,7920,2,290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1440.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(291,3705,40729,7920,2,291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',670.01,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(292,3705,40729,7920,2,292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1440.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(293,3705,40729,7920,2,293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',5640.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(294,3705,40729,7920,2,294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',6580.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(295,3705,40729,7920,2,295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',7050.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(296,3705,40729,7920,2,296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',4700.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(297,3705,40729,7920,2,297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',3900.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(298,3705,40729,7920,2,298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',9870.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(299,3705,40729,7920,2,299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',8930.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(300,3705,40729,7920,2,300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',7800.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL);
INSERT INTO `balance_libro` VALUES (301,3705,40729,7920,2,301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1440.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(302,3705,40729,7920,2,302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',7520.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(303,3705,40729,7920,2,303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',5170.00,NULL,NULL,1,'2021-07-28 21:01:50','2021-07-28 21:01:50',NULL),(304,3705,40729,7920,2,304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1440.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(305,3705,40729,7920,2,305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',5640.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(306,3705,40729,7920,2,306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',7800.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(307,3705,40729,7920,2,307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',7990.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(308,3705,40729,7920,2,308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1440.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(309,3705,40729,7920,2,309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',5170.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(310,3705,40729,7920,2,310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',9870.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(311,3705,40729,7920,2,311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',8930.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(312,3705,40729,7920,2,312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1440.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(313,3705,40729,7920,2,313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',7520.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(314,3705,40729,7920,2,314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',6110.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(315,3705,40729,7920,2,315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',5170.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(316,3705,40729,7920,2,316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',720.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(317,3705,40729,7920,2,317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',5640.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(318,3705,40729,7920,2,318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',3900.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(319,3705,40729,7920,2,319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',2160.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(320,3705,40729,7920,2,320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',7050.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(321,3705,40729,7920,2,321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',7800.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(322,3705,40729,7920,2,322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',4700.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(323,3705,40729,7920,2,323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',5640.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(324,3705,40729,7920,2,324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',3900.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(325,3705,40729,7920,2,325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',9870.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL);
INSERT INTO `balance_libro` VALUES (326,3705,40729,7920,2,326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',8460.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(327,3705,40729,7920,2,327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',9400.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(328,3705,40729,7920,2,328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',4700.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(329,3705,40729,7920,2,329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',6580.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(330,3705,40729,7920,2,330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1440.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(331,3705,40729,7920,2,331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',1440.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(332,3705,40729,7920,2,332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',3760.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(333,3705,40729,7920,2,333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',5170.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(334,3705,40729,7920,2,334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',5640.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(335,3705,40729,7920,2,335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',4700.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(336,3705,40729,7920,2,336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',8460.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(337,3705,40729,7920,2,337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',3290.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(338,3705,40729,7920,2,338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',7520.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(339,3705,40729,7920,2,339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',9870.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(340,3705,40729,7920,2,340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',7800.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(341,3705,40729,7920,2,341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',1440.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(342,3705,40729,7920,2,342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',9400.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(343,3705,40729,7920,2,343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',7990.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(344,3705,40729,7920,2,344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',1440.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(345,3705,40729,7920,2,345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',7800.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(346,3705,40729,7920,2,346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',7990.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(347,3705,40729,7920,2,347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',5640.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(348,3705,40729,7920,2,348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1440.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(349,3705,40729,7920,2,349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',6580.00,NULL,NULL,1,'2021-07-28 21:01:51','2021-07-28 21:01:51',NULL),(350,3705,40729,7920,2,350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',7800.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL);
INSERT INTO `balance_libro` VALUES (351,3705,40729,7920,2,351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',7520.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(352,3705,40729,7920,2,352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',5170.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(353,3705,40729,7920,2,353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',8930.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(354,3705,40729,7920,2,354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',6110.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(355,3705,40729,7920,2,355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1440.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(356,3705,40729,7920,2,356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',3290.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(357,3705,40729,7920,2,357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',5640.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(358,3705,40729,7920,2,358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',9870.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(359,3705,40729,7920,2,359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',7800.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(360,3705,40729,7920,2,360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',9400.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(361,3705,40729,7920,2,361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1440.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(362,3705,40729,7920,2,362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',6580.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(363,3705,40729,7920,2,363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',7990.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(364,3705,40729,7920,2,364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',7800.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(365,3705,40729,7920,2,365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',9870.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(366,3705,40729,7920,2,366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',8930.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(367,3705,40729,7920,2,367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',9400.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(368,3705,40729,7920,2,368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',5640.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(369,3705,40729,7920,2,369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',7800.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(370,3705,40729,7920,2,370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',720.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(371,3705,40729,7920,2,371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4700.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(372,3705,40729,7920,2,372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',5640.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(373,3705,40729,7920,2,373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',6580.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(374,3705,40729,7920,2,374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4700.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL),(375,3705,40729,7920,2,375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',8900.00,NULL,NULL,1,'2021-07-28 21:01:52','2021-07-28 21:01:52',NULL);
INSERT INTO `balance_libro` VALUES (472,3705,40729,7920,3,472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',8710.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(473,3705,40729,7920,3,473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',11700.01,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(474,3705,40729,7920,3,474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',4855.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(475,3705,40729,7920,3,475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',4290.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(476,3705,40729,7920,3,476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',6350.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(477,3705,40729,7920,3,477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',17030.02,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(478,3705,40729,7920,3,478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',11700.01,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(479,3705,40729,7920,3,479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',5460.01,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(480,3705,40729,7920,3,480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',2925.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(481,3705,40729,7920,3,481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',11310.01,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(482,3705,40729,7920,3,482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',18720.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(483,3705,40729,7920,3,483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',3250.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(484,3705,40729,7920,3,484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',17725.02,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(485,3705,40729,7920,3,485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',21090.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(486,3705,40729,7920,3,486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',11225.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(487,3705,40729,7920,3,487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',9750.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(488,3705,40729,7920,3,488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',16770.02,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(489,3705,40729,7920,3,489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',11310.01,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(490,3705,40729,7920,3,490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',20865.01,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(491,3705,40729,7920,3,491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',5655.01,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(492,3705,40729,7920,3,492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1333.50,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(493,3705,40729,7920,3,493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',10920.01,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(494,3705,40729,7920,3,494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1170.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(495,3705,40729,7920,3,495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',18999.99,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(496,3705,40729,7920,3,496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',19500.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL);
INSERT INTO `balance_libro` VALUES (497,3705,40729,7920,3,497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',10660.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(498,3705,40729,7920,3,498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',10855.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(499,3705,40729,7920,3,499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',19920.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(500,3705,40729,7920,3,500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',4680.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(501,3705,40729,7920,3,501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',18330.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(502,3705,40729,7920,3,502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',11440.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(503,3705,40729,7920,3,503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',12285.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(504,3705,40729,7920,3,504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',7540.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(505,3705,40729,7920,3,505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',8385.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(506,3705,40729,7920,3,506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',17615.02,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(507,3705,40729,7920,3,507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',11050.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(508,3705,40729,7920,3,508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',11700.00,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(509,3705,40729,7920,3,509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',9360.01,NULL,NULL,1,'2021-07-28 21:18:00','2021-07-28 21:18:00',NULL),(510,3705,40729,7920,3,510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',11310.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(511,3705,40729,7920,3,511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4680.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(512,3705,40729,7920,3,512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',11050.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(513,3705,40729,7920,3,513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',11310.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(514,3705,40729,7920,3,514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',11310.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(515,3705,40729,7920,3,515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',8190.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(516,3705,40729,7920,3,516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',8970.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(517,3705,40729,7920,3,517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4680.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(518,3705,40729,7920,3,518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',9750.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(519,3705,40729,7920,3,519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',8970.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(520,3705,40729,7920,3,520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',7410.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(521,3705,40729,7920,3,521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',8580.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL);
INSERT INTO `balance_libro` VALUES (522,3705,40729,7920,3,522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',7995.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(523,3705,40729,7920,3,523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4680.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(524,3705,40729,7920,3,524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',8710.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(525,3705,40729,7920,3,525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4680.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(526,3705,40729,7920,3,526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',5850.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(527,3705,40729,7920,3,527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',5850.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(528,3705,40729,7920,3,528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',15210.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(529,3705,40729,7920,3,529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',8190.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(530,3705,40729,7920,3,530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4680.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(531,3705,40729,7920,3,531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',9945.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(532,3705,40729,7920,3,532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',10140.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(533,3705,40729,7920,3,533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',25350.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(534,3705,40729,7920,3,534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',20455.02,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(535,3705,40729,7920,3,535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',12870.02,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(536,3705,40729,7920,3,536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',9165.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(537,3705,40729,7920,3,537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',17355.02,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(538,3705,40729,7920,3,538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',11700.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(539,3705,40729,7920,3,539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',13520.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(540,3705,40729,7920,3,540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',3250.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(541,3705,40729,7920,3,541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',11895.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(542,3705,40729,7920,3,542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',24115.02,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(543,3705,40729,7920,3,543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',394.49,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(544,3705,40729,7920,3,544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',11310.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(545,3705,40729,7920,3,545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',14300.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(546,3705,40729,7920,3,546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',16185.02,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL);
INSERT INTO `balance_libro` VALUES (547,3705,40729,7920,3,547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',11700.00,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(548,3705,40729,7920,3,548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',15210.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(549,3705,40729,7920,3,549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',11700.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(550,3705,40729,7920,3,550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',9880.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(551,3705,40729,7920,3,551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',9943.45,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(552,3705,40729,7920,3,552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',18135.02,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(553,3705,40729,7920,3,553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',11700.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(554,3705,40729,7920,3,554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',11700.01,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(555,3705,40729,7920,3,555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',25025.02,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(556,3705,40729,7920,3,556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',17550.02,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(557,3705,40729,7920,3,557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',20800.02,NULL,NULL,1,'2021-07-28 21:18:01','2021-07-28 21:18:01',NULL),(558,3705,40729,7920,3,558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',394.49,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(559,3705,40729,7920,3,559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',45.05,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(560,3705,40729,7920,3,560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',5655.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(561,3705,40729,7920,3,561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',11700.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(562,3705,40729,7920,3,562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1631.25,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(563,3705,40729,7920,3,563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',8580.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(564,3705,40729,7920,3,564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',9880.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(565,3705,40729,7920,3,565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',4095.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(566,3705,40729,7920,3,566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',2730.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(567,3705,40729,7920,3,567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',4290.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(568,3705,40729,7920,3,568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',12285.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(569,3705,40729,7920,3,569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',6825.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(570,3705,40729,7920,3,570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',5850.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(571,3705,40729,7920,3,571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',9555.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL);
INSERT INTO `balance_libro` VALUES (572,3705,40729,7920,3,572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',8385.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(573,3705,40729,7920,3,573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',6825.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(574,3705,40729,7920,3,574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',6825.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(575,3705,40729,7920,3,575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',8775.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(576,3705,40729,7920,3,576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',6240.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(577,3705,40729,7920,3,577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',5850.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(578,3705,40729,7920,3,578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',9750.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(579,3705,40729,7920,3,579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',2723.90,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(580,3705,40729,7920,3,580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',34190.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(581,3705,40729,7920,3,581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',20930.02,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(582,3705,40729,7920,3,582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',3900.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(583,3705,40729,7920,3,583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',8970.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(584,3705,40729,7920,3,584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',9750.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(585,3705,40729,7920,3,585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',10920.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(586,3705,40729,7920,3,586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',4680.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(587,3705,40729,7920,3,587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',28470.02,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(588,3705,40729,7920,3,588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',11310.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(589,3705,40729,7920,3,589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',19174.99,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(590,3705,40729,7920,3,590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',26030.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(591,3705,40729,7920,3,591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',17160.02,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(592,3705,40729,7920,3,592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',26520.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(593,3705,40729,7920,3,593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',20370.02,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(594,3705,40729,7920,3,594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',9750.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(595,3705,40729,7920,3,595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',11030.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(596,3705,40729,7920,3,596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',17745.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL);
INSERT INTO `balance_libro` VALUES (597,3705,40729,7920,3,597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',14820.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(598,3705,40729,7920,3,598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',364.70,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(599,3705,40729,7920,3,599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',11790.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(600,3705,40729,7920,3,600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',11310.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(601,3705,40729,7920,3,601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',4290.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(602,3705,40729,7920,3,602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',12005.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(603,3705,40729,7920,3,603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',14430.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(604,3705,40729,7920,3,604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',9165.00,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(605,3705,40729,7920,3,605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',8970.01,NULL,NULL,1,'2021-07-28 21:18:02','2021-07-28 21:18:02',NULL),(606,3705,40729,7920,3,606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',16250.02,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(607,3705,40729,7920,3,607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',8580.00,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(608,3705,40729,7920,3,608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',9165.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(609,3705,40729,7920,3,609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',11180.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(610,3705,40729,7920,3,610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',18590.02,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(611,3705,40729,7920,3,611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',5460.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(612,3705,40729,7920,3,612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',9165.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(613,3705,40729,7920,3,613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',32305.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(614,3705,40729,7920,3,614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',11310.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(615,3705,40729,7920,3,615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',18525.02,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(616,3705,40729,7920,3,616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',14820.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(617,3705,40729,7920,3,617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',5850.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(618,3705,40729,7920,3,618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',22419.99,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(619,3705,40729,7920,3,619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',22419.99,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(620,3705,40729,7920,3,620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',22419.99,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(621,3705,40729,7920,3,621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',10530.00,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL);
INSERT INTO `balance_libro` VALUES (622,3705,40729,7920,3,622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',9750.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(623,3705,40729,7920,3,623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',4500.30,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(624,3705,40729,7920,3,624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',23010.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(625,3705,40729,7920,3,625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',33085.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(626,3705,40729,7920,3,626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',25270.00,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(627,3705,40729,7920,3,627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',11310.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(628,3705,40729,7920,3,628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',26520.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(629,3705,40729,7920,3,629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',10270.00,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(630,3705,40729,7920,3,630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',16380.02,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(631,3705,40729,7920,3,631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',28665.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(632,3705,40729,7920,3,632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',11310.01,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(633,3705,40729,7920,3,633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',4420.00,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(634,3705,40729,7920,3,634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',7020.00,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(635,3705,40729,7920,3,635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',9750.00,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(636,3705,40729,7920,3,636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',12220.00,NULL,NULL,1,'2021-07-28 21:18:03','2021-07-28 21:18:03',NULL),(637,3705,40729,7919,2,637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',7200.00,NULL,NULL,1,'2021-07-28 21:27:46','2021-07-28 21:27:46',NULL),(638,3705,40729,7919,2,638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',2070.00,NULL,NULL,1,'2021-07-28 21:27:46','2021-07-28 21:27:46',NULL),(639,3705,40729,7919,2,639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',7800.00,NULL,NULL,1,'2021-07-28 21:27:46','2021-07-28 21:27:46',NULL),(640,3705,40729,7919,2,640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',8550.00,NULL,NULL,1,'2021-07-28 21:27:46','2021-07-28 21:27:46',NULL),(641,3705,40729,7919,2,641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',6750.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(642,3705,40729,7919,2,642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',6300.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(643,3705,40729,7919,2,643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',3600.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(644,3705,40729,7919,2,644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',3900.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(645,3705,40729,7919,2,645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',4950.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(646,3705,40729,7919,2,646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',5850.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL);
INSERT INTO `balance_libro` VALUES (647,3705,40729,7919,2,647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',4500.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(648,3705,40729,7919,2,648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',4050.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(649,3705,40729,7919,2,649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',8100.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(650,3705,40729,7919,2,650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',1380.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(651,3705,40729,7919,2,651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',7200.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(652,3705,40729,7919,2,652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',5850.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(653,3705,40729,7919,2,653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',1380.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(654,3705,40729,7919,2,654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',6300.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(655,3705,40729,7919,2,655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',5400.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(656,3705,40729,7919,2,656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',3900.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(657,3705,40729,7919,2,657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',5400.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(658,3705,40729,7919,2,658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',4050.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(659,3705,40729,7919,2,659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',7650.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(660,3705,40729,7919,2,660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',8550.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(661,3705,40729,7919,2,661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',7800.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(662,3705,40729,7919,2,662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',3600.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(663,3705,40729,7919,2,663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',3900.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(664,3705,40729,7919,2,664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',4500.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(665,3705,40729,7919,2,665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6750.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(666,3705,40729,7919,2,666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6300.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(667,3705,40729,7919,2,667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',3900.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(668,3705,40729,7919,2,668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',690.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(669,3705,40729,7919,2,669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',3600.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(670,3705,40729,7919,2,670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',5850.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(671,3705,40729,7919,2,671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',900.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL);
INSERT INTO `balance_libro` VALUES (672,3705,40729,7919,2,672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',8550.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(673,3705,40729,7919,2,673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',7800.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(674,3705,40729,7919,2,674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',8100.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(675,3705,40729,7919,2,675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6300.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(676,3705,40729,7919,2,676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',1380.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(677,3705,40729,7919,2,677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',7650.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(678,3705,40729,7919,2,678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',4500.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(679,3705,40729,7919,2,679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',4500.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(680,3705,40729,7919,2,680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',7200.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(681,3705,40729,7919,2,681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',1380.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(682,3705,40729,7919,2,682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',7800.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(683,3705,40729,7919,2,683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',8550.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(684,3705,40729,7919,2,684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',7650.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(685,3705,40729,7919,2,685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',6750.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(686,3705,40729,7919,2,686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',690.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(687,3705,40729,7919,2,687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',8100.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(688,3705,40729,7919,2,688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',7650.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(689,3705,40729,7919,2,689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',3600.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(690,3705,40729,7919,2,690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',3900.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(691,3705,40729,7919,2,691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',2250.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(692,3705,40729,7919,2,692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',6750.00,NULL,NULL,1,'2021-07-28 21:27:47','2021-07-28 21:27:47',NULL),(693,3705,40729,7919,2,693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',3900.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(694,3705,40729,7919,2,694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',3900.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(695,3705,40729,7919,2,695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',7200.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(696,3705,40729,7919,2,696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',5850.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL);
INSERT INTO `balance_libro` VALUES (697,3705,40729,7919,2,697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',8550.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(698,3705,40729,7919,2,698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',6750.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(699,3705,40729,7919,2,699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',7800.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(700,3705,40729,7919,2,700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',4950.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(701,3705,40729,7919,2,701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',5850.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(702,3705,40729,7919,2,702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',4500.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(703,3705,40729,7919,2,703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',1380.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(704,3705,40729,7919,2,704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',7650.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(705,3705,40729,7919,2,705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',690.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(706,3705,40729,7919,2,706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',6300.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(707,3705,40729,7919,2,707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',5400.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(708,3705,40729,7919,2,708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',1380.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(709,3705,40729,7919,2,709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',3600.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(710,3705,40729,7919,2,710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',7650.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(711,3705,40729,7919,2,711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6300.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(712,3705,40729,7919,2,712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',3900.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(713,3705,40729,7919,2,713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',4050.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(714,3705,40729,7919,2,714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5850.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(715,3705,40729,7919,2,715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6300.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(716,3705,40729,7919,2,716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',7650.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(717,3705,40729,7919,2,717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',7800.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(718,3705,40729,7919,2,718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',8100.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(719,3705,40729,7919,2,719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',1380.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(720,3705,40729,7919,2,720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',5850.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(721,3705,40729,7919,2,721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',7200.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL);
INSERT INTO `balance_libro` VALUES (722,3705,40729,7919,2,722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',5400.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(723,3705,40729,7919,2,723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',4500.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(724,3705,40729,7919,2,724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',1380.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(725,3705,40729,7919,2,725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',3150.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(726,3705,40729,7919,2,726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',1380.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(727,3705,40729,7919,2,727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',6750.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(728,3705,40729,7919,2,728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',3900.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(729,3705,40729,7919,2,729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',8550.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(730,3705,40729,7919,2,730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',7800.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(731,3705,40729,7919,2,731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',6750.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(732,3705,40729,7919,2,732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',7650.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(733,3705,40729,7919,2,733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',3150.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(734,3705,40729,7919,2,734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',4950.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(735,3705,40729,7919,2,735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',3600.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(736,3705,40729,7919,2,736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',3900.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(737,3705,40729,7919,2,737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',690.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(738,3705,40729,7919,2,738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',5400.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(739,3705,40729,7919,2,739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',7650.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(740,3705,40729,7919,2,740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',6300.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(741,3705,40729,7919,2,741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',7200.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(742,3705,40729,7919,2,742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',5850.00,NULL,NULL,1,'2021-07-28 21:27:48','2021-07-28 21:27:48',NULL),(743,3705,40729,7919,2,743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',3600.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(744,3705,40729,7919,2,744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',5400.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(745,3705,40729,7919,2,745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',4950.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(746,3705,40729,7919,2,746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',1380.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL);
INSERT INTO `balance_libro` VALUES (747,3705,40729,7919,2,747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',6300.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(748,3705,40729,7919,2,748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',5400.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(749,3705,40729,7919,2,749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',7800.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(750,3705,40729,7919,2,750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',1380.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(751,3705,40729,7919,2,751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',7650.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(752,3705,40729,7919,2,752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',6300.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(753,3705,40729,7919,2,753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',7800.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(754,3705,40729,7919,2,754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',8550.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(755,3705,40729,7919,2,755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',6750.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(756,3705,40729,7919,2,756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',4950.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(757,3705,40729,7919,2,757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',4050.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(758,3705,40729,7919,2,758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',5850.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(759,3705,40729,7919,2,759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',3900.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(760,3705,40729,7919,2,760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',7200.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(761,3705,40729,7919,2,761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',1380.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(762,3705,40729,7919,2,762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',6300.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(763,3705,40729,7919,2,763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',5400.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(764,3705,40729,7919,2,764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',3900.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(765,3705,40729,7919,2,765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',6300.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(766,3705,40729,7919,2,766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',8100.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(767,3705,40729,7919,2,767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',8550.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(768,3705,40729,7919,2,768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',7800.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(769,3705,40729,7919,2,769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',7200.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(770,3705,40729,7919,2,770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',5850.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(771,3705,40729,7919,2,771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',1380.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL);
INSERT INTO `balance_libro` VALUES (772,3705,40729,7919,2,772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',2700.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(773,3705,40729,7919,2,773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',690.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(774,3705,40729,7919,2,774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',5400.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(775,3705,40729,7919,2,775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',7800.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(776,3705,40729,7919,2,776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',4500.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(777,3705,40729,7919,2,777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',6750.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(778,3705,40729,7919,2,778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',3150.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(779,3705,40729,7919,2,779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',650.01,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(780,3705,40729,7919,2,780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',7200.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(781,3705,40729,7919,2,781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',7800.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(782,3705,40729,7919,2,782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',2700.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(783,3705,40729,7919,2,783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',5850.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(784,3705,40729,7919,2,784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',8550.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(785,3705,40729,7919,2,785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',7800.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(786,3705,40729,7919,2,786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',8100.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(787,3705,40729,7919,2,787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',7200.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(788,3705,40729,7919,2,788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',1380.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(789,3705,40729,7919,2,789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',6750.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(790,3705,40729,7919,2,790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',5400.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(791,3705,40729,7919,2,791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',1380.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(792,3705,40729,7919,2,792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',6300.00,NULL,NULL,1,'2021-07-28 21:27:49','2021-07-28 21:27:49',NULL),(793,3705,40729,7919,2,793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',4950.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(794,3705,40729,7919,2,794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',13350.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(795,3705,40729,7919,2,795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',1380.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(796,3705,40729,7919,2,796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',6750.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL);
INSERT INTO `balance_libro` VALUES (797,3705,40729,7919,2,797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',5850.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(798,3705,40729,7919,2,798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',7200.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(799,3705,40729,7919,2,799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',6300.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(800,3705,40729,7919,2,800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',7800.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(801,3705,40729,7919,2,801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',7650.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(802,3705,40729,7919,2,802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',8100.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(803,3705,40729,7919,2,803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',4500.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(804,3705,40729,7919,2,804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',1380.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(805,3705,40729,7919,2,805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',5400.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(806,3705,40729,7919,2,806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',2250.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(807,3705,40729,7919,2,807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',6300.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(808,3705,40729,7919,2,808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',7200.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(809,3705,40729,7919,2,809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',4050.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(810,3705,40729,7919,2,810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',5400.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(811,3705,40729,7919,2,811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',6750.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(812,3705,40729,7919,2,812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',8550.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(813,3705,40729,7919,2,813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',7800.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(814,3705,40729,7919,2,814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',8100.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(815,3705,40729,7919,2,815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',1380.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(816,3705,40729,7919,2,816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',5400.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(817,3705,40729,7919,2,817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',6300.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(818,3705,40729,7919,2,818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',4950.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(819,3705,40729,7919,2,819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',2070.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(820,3705,40729,7919,2,820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',7200.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(821,3705,40729,7919,2,821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',5400.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL);
INSERT INTO `balance_libro` VALUES (822,3705,40729,7919,2,822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',6300.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(823,3705,40729,7919,2,823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',4500.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(824,3705,40729,7919,2,824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',7200.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(825,3705,40729,7919,2,825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',2070.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(826,3705,40729,7919,2,826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',6300.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(827,3705,40729,7919,2,827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',5850.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(828,3705,40729,7919,2,828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',2070.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(829,3705,40729,7919,2,829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',4050.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(830,3705,40729,7919,2,830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',7800.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(831,3705,40729,7919,2,831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',8550.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(832,3705,40729,7919,2,832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',7650.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(833,3705,40729,7919,2,833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',1380.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(834,3705,40729,7919,2,834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',6300.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(835,3705,40729,7919,2,835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',2700.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(836,3705,40729,7919,2,836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',5850.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(837,3705,40729,7919,2,837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',4950.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(838,3705,40729,7919,2,838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',1380.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(839,3705,40729,7919,2,839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',7200.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(840,3705,40729,7919,2,840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',5400.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(841,3705,40729,7919,2,841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',7650.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(842,3705,40729,7919,2,842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',7800.00,NULL,NULL,1,'2021-07-28 21:27:50','2021-07-28 21:27:50',NULL),(843,3705,40729,7919,2,843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',6750.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(844,3705,40729,7919,2,844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',3900.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(845,3705,40729,7919,2,845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',7200.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(846,3705,40729,7919,2,846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',1380.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL);
INSERT INTO `balance_libro` VALUES (847,3705,40729,7919,2,847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',7200.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(848,3705,40729,7919,2,848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',7650.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(849,3705,40729,7919,2,849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',7800.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(850,3705,40729,7919,2,850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',8550.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(851,3705,40729,7919,2,851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',5400.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(852,3705,40729,7919,2,852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',7650.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(853,3705,40729,7919,2,853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',3900.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(854,3705,40729,7919,2,854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',6300.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(855,3705,40729,7919,2,855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',7200.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(856,3705,40729,7919,2,856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',1380.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(857,3705,40729,7919,2,857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',4950.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(858,3705,40729,7919,2,858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',7200.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(859,3705,40729,7919,2,859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',1380.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(860,3705,40729,7919,2,860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',5850.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(861,3705,40729,7919,2,861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',4050.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(862,3705,40729,7919,2,862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',6750.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(863,3705,40729,7919,2,863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',8550.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(864,3705,40729,7919,2,864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',7800.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(865,3705,40729,7919,2,865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',1350.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(866,3705,40729,7919,2,866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',1380.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(867,3705,40729,7919,2,867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',6750.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(868,3705,40729,7919,2,868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',4500.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(869,3705,40729,7919,2,869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',3900.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(870,3705,40729,7919,2,870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',6300.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(871,3705,40729,7919,2,871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',7200.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL);
INSERT INTO `balance_libro` VALUES (872,3705,40729,7919,2,872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',7800.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(873,3705,40729,7919,2,873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',7200.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(874,3705,40729,7919,2,874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',8100.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(875,3705,40729,7919,2,875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',4500.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(876,3705,40729,7919,2,876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',5850.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(877,3705,40729,7919,2,877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',6750.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(878,3705,40729,7919,2,878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',7650.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(879,3705,40729,7919,2,879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',6300.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(880,3705,40729,7919,2,880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',5400.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(881,3705,40729,7919,2,881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',1380.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(882,3705,40729,7919,2,882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',2250.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(883,3705,40729,7919,2,883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',1380.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(884,3705,40729,7919,2,884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',6300.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(885,3705,40729,7919,2,885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',7200.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(886,3705,40729,7919,2,886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',4500.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(887,3705,40729,7919,2,887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',8550.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(888,3705,40729,7919,2,888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',7800.00,NULL,NULL,1,'2021-07-28 21:27:51','2021-07-28 21:27:51',NULL),(889,3705,40729,7919,2,889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',5400.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(890,3705,40729,7919,2,890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',3600.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(891,3705,40729,7919,2,891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',4950.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(892,3705,40729,7919,2,892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',7650.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(893,3705,40729,7919,2,893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',1380.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(894,3705,40729,7919,2,894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',1350.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(895,3705,40729,7919,2,895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',5850.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(896,3705,40729,7919,2,896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',6300.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL);
INSERT INTO `balance_libro` VALUES (897,3705,40729,7919,2,897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',1380.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(898,3705,40729,7919,2,898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',7200.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(899,3705,40729,7919,2,899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',4050.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(900,3705,40729,7919,2,900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',2070.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(901,3705,40729,7919,2,901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',5400.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(902,3705,40729,7919,2,902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',6300.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(903,3705,40729,7919,2,903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',7800.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(904,3705,40729,7919,2,904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',8550.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(905,3705,40729,7919,2,905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',7800.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(906,3705,40729,7919,2,906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',8100.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(907,3705,40729,7919,2,907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',7650.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(908,3705,40729,7919,2,908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',5850.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(909,3705,40729,7919,2,909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',2250.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(910,3705,40729,7919,2,910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',4500.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(911,3705,40729,7919,2,911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',5850.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(912,3705,40729,7919,2,912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1380.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(913,3705,40729,7919,2,913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',4050.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(914,3705,40729,7919,2,914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',5850.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(915,3705,40729,7919,2,915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',6750.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(916,3705,40729,7919,2,916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',3900.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(917,3705,40729,7919,2,917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',7200.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(918,3705,40729,7919,2,918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',8550.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(919,3705,40729,7919,2,919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',8100.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(920,3705,40729,7919,2,920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1380.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(921,3705,40729,7919,2,921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',7800.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL);
INSERT INTO `balance_libro` VALUES (922,3705,40729,7919,2,922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',7650.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(923,3705,40729,7919,2,923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',6750.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(924,3705,40729,7919,2,924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',4950.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(925,3705,40729,7919,2,925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',6300.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(926,3705,40729,7919,2,926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',6300.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(927,3705,40729,7919,2,927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1380.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(928,3705,40729,7919,2,928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',5400.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(929,3705,40729,7919,2,929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',7800.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(930,3705,40729,7919,2,930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',6300.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(931,3705,40729,7919,2,931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',8100.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(932,3705,40729,7919,2,932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',8550.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(933,3705,40729,7919,2,933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',7650.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(934,3705,40729,7919,2,934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',5850.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(935,3705,40729,7919,2,935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',4500.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(936,3705,40729,7919,2,936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1380.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(937,3705,40729,7919,2,937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',6750.00,NULL,NULL,1,'2021-07-28 21:27:52','2021-07-28 21:27:52',NULL),(938,3705,40729,7919,2,938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',4950.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(939,3705,40729,7919,2,939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',8100.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(940,3705,40729,7919,2,940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',7800.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(941,3705,40729,7919,2,941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',7650.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(942,3705,40729,7919,2,942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1380.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(943,3705,40729,7919,2,943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',6300.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(944,3705,40729,7919,2,944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',7800.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(945,3705,40729,7919,2,945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1380.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(946,3705,40729,7919,2,946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',8550.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL);
INSERT INTO `balance_libro` VALUES (947,3705,40729,7919,2,947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',8100.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(948,3705,40729,7919,2,948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',7800.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(949,3705,40729,7919,2,949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',6300.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(950,3705,40729,7919,2,950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',5400.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(951,3705,40729,7919,2,951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',7200.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(952,3705,40729,7919,2,952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1380.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(953,3705,40729,7919,2,953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',7650.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(954,3705,40729,7919,2,954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',5850.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(955,3705,40729,7919,2,955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1380.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(956,3705,40729,7919,2,956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1380.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(957,3705,40729,7919,2,957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',7200.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(958,3705,40729,7919,2,958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',5400.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(959,3705,40729,7919,2,959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2070.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(960,3705,40729,7919,2,960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',6300.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(961,3705,40729,7919,2,961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8550.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(962,3705,40729,7919,2,962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8100.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(963,3705,40729,7919,2,963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',5850.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(964,3705,40729,7919,2,964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',4950.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(965,3705,40729,7919,2,965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',690.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(966,3705,40729,7919,2,966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',4500.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(967,3705,40729,7919,2,967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',5850.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(968,3705,40729,7919,2,968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',7800.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(969,3705,40729,7919,2,969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',3600.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(970,3705,40729,7919,2,970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',7650.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(971,3705,40729,7919,2,971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',5400.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL);
INSERT INTO `balance_libro` VALUES (972,3705,40729,7919,2,972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',3150.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(973,3705,40729,7919,2,973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',3900.00,NULL,NULL,1,'2021-07-28 21:27:53','2021-07-28 21:27:53',NULL),(974,3705,40729,7919,3,974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',6949.99,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(975,3705,40729,7919,3,975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',8694.99,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(976,3705,40729,7919,3,976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',8879.98,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(977,3705,40729,7919,3,977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',3330.00,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(978,3705,40729,7919,3,978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',10359.99,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(979,3705,40729,7919,3,979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',13900.00,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(980,3705,40729,7919,3,980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',24679.99,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(981,3705,40729,7919,3,981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',3699.99,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(982,3705,40729,7919,3,982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',11574.99,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(983,3705,40729,7919,3,983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',11099.99,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(984,3705,40729,7919,3,984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',4254.99,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(985,3705,40729,7919,3,985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',5045.01,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(986,3705,40729,7919,3,986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',7610.01,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(987,3705,40729,7919,3,987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',8509.98,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(988,3705,40729,7919,3,988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',61.75,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(989,3705,40729,7919,3,989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',19974.98,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(990,3705,40729,7919,3,990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',4439.99,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(991,3705,40729,7919,3,991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6844.99,NULL,NULL,1,'2021-07-28 21:30:48','2021-07-28 21:30:48',NULL),(992,3705,40729,7919,3,992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',12764.98,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(993,3705,40729,7919,3,993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',4069.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(994,3705,40729,7919,3,994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',7319.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(995,3705,40729,7919,3,995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',8879.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(996,3705,40729,7919,3,996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',1446.75,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL);
INSERT INTO `balance_libro` VALUES (997,3705,40729,7919,3,997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',8984.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(998,3705,40729,7919,3,998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',16834.97,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(999,3705,40729,7919,3,999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',7399.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1000,3705,40729,7919,3,1000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',20084.97,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1001,3705,40729,7919,3,1001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',13580.00,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1002,3705,40729,7919,3,1002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',11284.98,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1003,3705,40729,7919,3,1003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',17704.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1004,3705,40729,7919,3,1004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',11654.98,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1005,3705,40729,7919,3,1005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',9434.98,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1006,3705,40729,7919,3,1006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',4994.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1007,3705,40729,7919,3,1007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',4070.00,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1008,3705,40729,7919,3,1008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',4069.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1009,3705,40729,7919,3,1009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',6500.01,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1010,3705,40729,7919,3,1010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',10914.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1011,3705,40729,7919,3,1011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',16489.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1012,3705,40729,7919,3,1012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',13239.98,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1013,3705,40729,7919,3,1013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',13239.98,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1014,3705,40729,7919,3,1014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',13794.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1015,3705,40729,7919,3,1015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',5179.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1016,3705,40729,7919,3,1016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',22039.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1017,3705,40729,7919,3,1017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',17520.00,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1018,3705,40729,7919,3,1018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',16674.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1019,3705,40729,7919,3,1019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',10730.00,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1020,3705,40729,7919,3,1020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',6289.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL);
INSERT INTO `balance_libro` VALUES (1021,3705,40729,7919,3,1021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',10729.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1022,3705,40729,7919,3,1022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',4254.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1023,3705,40729,7919,3,1023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',4439.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1024,3705,40729,7919,3,1024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',8879.98,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1025,3705,40729,7919,3,1025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',18499.98,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1026,3705,40729,7919,3,1026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',6289.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1027,3705,40729,7919,3,1027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',10359.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1028,3705,40729,7919,3,1028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',8800.00,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1029,3705,40729,7919,3,1029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',3250.00,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1030,3705,40729,7919,3,1030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',5364.99,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1031,3705,40729,7919,3,1031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',16279.98,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1032,3705,40729,7919,3,1032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',17019.98,NULL,NULL,1,'2021-07-28 21:30:49','2021-07-28 21:30:49',NULL),(1033,3705,40729,7919,3,1033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',12869.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1034,3705,40729,7919,3,1034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',6659.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1035,3705,40729,7919,3,1035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',7504.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1036,3705,40729,7919,3,1036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',7504.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1037,3705,40729,7919,3,1037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',5599.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1038,3705,40729,7919,3,1038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',18259.98,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1039,3705,40729,7919,3,1039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',18259.98,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1040,3705,40729,7919,3,1040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',8509.98,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1041,3705,40729,7919,3,1041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',3250.00,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1042,3705,40729,7919,3,1042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',14799.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1043,3705,40729,7919,3,1043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',12579.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1044,3705,40729,7919,3,1044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',3250.00,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL);
INSERT INTO `balance_libro` VALUES (1045,3705,40729,7919,3,1045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',10729.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1046,3705,40729,7919,3,1046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',11469.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1047,3705,40729,7919,3,1047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',16834.97,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1048,3705,40729,7919,3,1048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',18869.98,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1049,3705,40729,7919,3,1049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',10359.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1050,3705,40729,7919,3,1050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',4809.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1051,3705,40729,7919,3,1051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',15644.98,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1052,3705,40729,7919,3,1052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',11099.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1053,3705,40729,7919,3,1053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',10544.98,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1054,3705,40729,7919,3,1054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',61.75,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1055,3705,40729,7919,3,1055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',8800.00,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1056,3705,40729,7919,3,1056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',10914.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1057,3705,40729,7919,3,1057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',1505.25,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1058,3705,40729,7919,3,1058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',7319.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1059,3705,40729,7919,3,1059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',16489.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1060,3705,40729,7919,3,1060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',11099.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1061,3705,40729,7919,3,1061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',2557.88,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1062,3705,40729,7919,3,1062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',16409.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1063,3705,40729,7919,3,1063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',5179.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1064,3705,40729,7919,3,1064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',15750.00,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1065,3705,40729,7919,3,1065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',10729.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1066,3705,40729,7919,3,1066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',4069.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1067,3705,40729,7919,3,1067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',15909.98,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1068,3705,40729,7919,3,1068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',8509.98,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL);
INSERT INTO `balance_libro` VALUES (1069,3705,40729,7919,3,1069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',11389.98,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1070,3705,40729,7919,3,1070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',4809.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1071,3705,40729,7919,3,1071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',4809.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1072,3705,40729,7919,3,1072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',7399.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1073,3705,40729,7919,3,1073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',8509.98,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1074,3705,40729,7919,3,1074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',4439.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1075,3705,40729,7919,3,1075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',10360.00,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1076,3705,40729,7919,3,1076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',7954.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1077,3705,40729,7919,3,1077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',8139.98,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1078,3705,40729,7919,3,1078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',8509.98,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1079,3705,40729,7919,3,1079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',11839.99,NULL,NULL,1,'2021-07-28 21:30:50','2021-07-28 21:30:50',NULL),(1080,3705,40729,7919,3,1080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',3699.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1081,3705,40729,7919,3,1081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',5734.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1082,3705,40729,7919,3,1082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',3699.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1083,3705,40729,7919,3,1083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',10359.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1084,3705,40729,7919,3,1084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',11099.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1085,3705,40729,7919,3,1085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-25','2021-05-25',10359.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1086,3705,40729,7919,3,1086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',700.00,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1087,3705,40729,7919,3,1087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',4254.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1088,3705,40729,7919,3,1088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',16305.00,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1089,3705,40729,7919,3,1089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',11654.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1090,3705,40729,7919,3,1090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',9169.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1091,3705,40729,7919,3,1091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',10359.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1092,3705,40729,7919,3,1092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',4500.30,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL);
INSERT INTO `balance_libro` VALUES (1093,3705,40729,7919,3,1093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',18000.01,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1094,3705,40729,7919,3,1094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',4070.00,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1095,3705,40729,7919,3,1095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',9434.98,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1096,3705,40729,7919,3,1096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',10729.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1097,3705,40729,7919,3,1097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',3250.00,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1098,3705,40729,7919,3,1098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',7504.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1099,3705,40729,7919,3,1099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',18000.01,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1100,3705,40729,7919,3,1100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',2590.00,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1101,3705,40729,7919,3,1101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',16489.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1102,3705,40729,7919,3,1102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',16674.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1103,3705,40729,7919,3,1103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',11469.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1104,3705,40729,7919,3,1104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',6580.00,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1105,3705,40729,7919,3,1105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',12949.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1106,3705,40729,7919,3,1106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',12129.98,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1107,3705,40729,7919,3,1107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',17389.98,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1108,3705,40729,7919,3,1108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',16464.97,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1109,3705,40729,7919,3,1109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1345.00,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1110,3705,40729,7919,3,1110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',20269.98,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1111,3705,40729,7919,3,1111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',18000.01,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1112,3705,40729,7919,3,1112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',12499.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1113,3705,40729,7919,3,1113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',3699.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1114,3705,40729,7919,3,1114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',6289.99,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1115,3705,40729,7919,3,1115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',19260.01,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1116,3705,40729,7919,3,1116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',5470.00,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL);
INSERT INTO `balance_libro` VALUES (1117,3705,40729,7919,3,1117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',9620.00,NULL,NULL,1,'2021-07-28 21:30:51','2021-07-28 21:30:51',NULL),(1118,3705,40729,7919,3,1118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',17519.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1119,3705,40729,7919,3,1119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',13689.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1120,3705,40729,7919,3,1120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',17829.98,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1121,3705,40729,7919,3,1121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',17389.98,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1122,3705,40729,7919,3,1122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',6025.00,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1123,3705,40729,7919,3,1123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',10360.00,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1124,3705,40729,7919,3,1124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',4439.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1125,3705,40729,7919,3,1125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',7399.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1126,3705,40729,7919,3,1126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',11099.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1127,3705,40729,7919,3,1127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',17149.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1128,3705,40729,7919,3,1128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',15750.00,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1129,3705,40729,7919,3,1129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',3699.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1130,3705,40729,7919,3,1130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8694.98,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1131,3705,40729,7919,3,1131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',4809.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1132,3705,40729,7919,3,1132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',4069.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1133,3705,40729,7919,3,1133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',4069.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1134,3705,40729,7919,3,1134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',8139.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1135,3705,40729,7919,3,1135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',5919.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1136,3705,40729,7919,3,1136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',4439.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1137,3705,40729,7919,3,1137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',5919.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1138,3705,40729,7919,3,1138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',7214.99,NULL,NULL,1,'2021-07-28 21:30:52','2021-07-28 21:30:52',NULL),(1139,3705,40729,7921,2,1139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1440.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1140,3705,40729,7921,2,1140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',6110.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL);
INSERT INTO `balance_libro` VALUES (1141,3705,40729,7921,2,1141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',5640.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1142,3705,40729,7921,2,1142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',4200.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1143,3705,40729,7921,2,1143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',5640.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1144,3705,40729,7921,2,1144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',4230.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1145,3705,40729,7921,2,1145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',6580.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1146,3705,40729,7921,2,1146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',1440.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1147,3705,40729,7921,2,1147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',5170.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1148,3705,40729,7921,2,1148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',7050.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1149,3705,40729,7921,2,1149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',8400.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1150,3705,40729,7921,2,1150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',7520.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1151,3705,40729,7921,2,1151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',9870.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1152,3705,40729,7921,2,1152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',7990.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1153,3705,40729,7921,2,1153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',9400.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1154,3705,40729,7921,2,1154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',5640.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1155,3705,40729,7921,2,1155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',1440.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1156,3705,40729,7921,2,1156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',4700.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1157,3705,40729,7921,2,1157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',7990.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1158,3705,40729,7921,2,1158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',6580.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1159,3705,40729,7921,2,1159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',4200.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1160,3705,40729,7921,2,1160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',9400.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1161,3705,40729,7921,2,1161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',8460.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1162,3705,40729,7921,2,1162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',7520.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1163,3705,40729,7921,2,1163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',6110.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1164,3705,40729,7921,2,1164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',8400.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL);
INSERT INTO `balance_libro` VALUES (1165,3705,40729,7921,2,1165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',5170.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1166,3705,40729,7921,2,1166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',6110.00,NULL,NULL,1,'2021-08-03 11:54:03','2021-08-03 11:54:03',NULL),(1167,3705,40729,7921,2,1167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',8930.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1168,3705,40729,7921,2,1168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',6580.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1169,3705,40729,7921,2,1169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',8460.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1170,3705,40729,7921,2,1170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',7520.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1171,3705,40729,7921,2,1171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',5170.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1172,3705,40729,7921,2,1172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',6110.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1173,3705,40729,7921,2,1173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',2350.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1174,3705,40729,7921,2,1174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1000.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1175,3705,40729,7921,2,1175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',6110.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1176,3705,40729,7921,2,1176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',7050.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1177,3705,40729,7921,2,1177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1440.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1178,3705,40729,7921,2,1178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',5640.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1179,3705,40729,7921,2,1179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',6580.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1180,3705,40729,7921,2,1180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',7990.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1181,3705,40729,7921,2,1181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',9870.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1182,3705,40729,7921,2,1182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',8460.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1183,3705,40729,7921,2,1183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1440.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1184,3705,40729,7921,2,1184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',5170.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1185,3705,40729,7921,2,1185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',4230.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1186,3705,40729,7921,2,1186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',7170.01,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1187,3705,40729,7921,2,1187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',1670.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1188,3705,40729,7921,2,1188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',7050.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL);
INSERT INTO `balance_libro` VALUES (1189,3705,40729,7921,2,1189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',8400.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1190,3705,40729,7921,2,1190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',6110.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1191,3705,40729,7921,2,1191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',8400.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1192,3705,40729,7921,2,1192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',8930.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1193,3705,40729,7921,2,1193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',9870.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1194,3705,40729,7921,2,1194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',8460.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1195,3705,40729,7921,2,1195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',5640.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1196,3705,40729,7921,2,1196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',4700.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1197,3705,40729,7921,2,1197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',9400.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1198,3705,40729,7921,2,1198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',5640.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1199,3705,40729,7921,2,1199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',5640.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1200,3705,40729,7921,2,1200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',6580.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1201,3705,40729,7921,2,1201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',4700.00,NULL,NULL,1,'2021-08-03 11:54:04','2021-08-03 11:54:04',NULL),(1202,3705,40729,7921,2,1202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',8400.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1203,3705,40729,7921,2,1203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',9870.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1204,3705,40729,7921,2,1204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',8460.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1205,3705,40729,7921,2,1205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',9400.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1206,3705,40729,7921,2,1206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',7520.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1207,3705,40729,7921,2,1207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',4230.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1208,3705,40729,7921,2,1208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',6580.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1209,3705,40729,7921,2,1209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',2350.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1210,3705,40729,7921,2,1210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',5170.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1211,3705,40729,7921,2,1211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',8400.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1212,3705,40729,7921,2,1212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',1340.01,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL);
INSERT INTO `balance_libro` VALUES (1213,3705,40729,7921,2,1213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',8900.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1214,3705,40729,7921,2,1214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',4900.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1215,3705,40729,7921,2,1215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',7050.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1216,3705,40729,7921,2,1216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',5170.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1217,3705,40729,7921,2,1217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',8400.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1218,3705,40729,7921,2,1218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',9870.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1219,3705,40729,7921,2,1219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',8460.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1220,3705,40729,7921,2,1220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',7520.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1221,3705,40729,7921,2,1221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',8400.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1222,3705,40729,7921,2,1222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',4700.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1223,3705,40729,7921,2,1223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',8400.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1224,3705,40729,7921,2,1224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',7990.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1225,3705,40729,7921,2,1225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',3760.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1226,3705,40729,7921,2,1226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',5170.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1227,3705,40729,7921,2,1227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',6110.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1228,3705,40729,7921,2,1228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',7990.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1229,3705,40729,7921,2,1229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',8400.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1230,3705,40729,7921,2,1230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',6110.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1231,3705,40729,7921,2,1231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',5640.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1232,3705,40729,7921,2,1232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',8400.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1233,3705,40729,7921,2,1233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',9870.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1234,3705,40729,7921,2,1234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',8930.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1235,3705,40729,7921,2,1235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',9400.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1236,3705,40729,7921,2,1236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',7050.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL);
INSERT INTO `balance_libro` VALUES (1237,3705,40729,7921,2,1237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',5640.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1238,3705,40729,7921,2,1238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',4700.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1239,3705,40729,7921,2,1239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',8460.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1240,3705,40729,7921,2,1240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',7050.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1241,3705,40729,7921,2,1241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',6110.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1242,3705,40729,7921,2,1242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',4200.00,NULL,NULL,1,'2021-08-03 11:54:05','2021-08-03 11:54:05',NULL),(1243,3705,40729,7921,2,1243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',7520.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1244,3705,40729,7921,2,1244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',8930.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1245,3705,40729,7921,2,1245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',8460.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1246,3705,40729,7921,2,1246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1440.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1247,3705,40729,7921,2,1247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',9400.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1248,3705,40729,7921,2,1248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1440.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1249,3705,40729,7921,2,1249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',6580.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1250,3705,40729,7921,2,1250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',4200.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1251,3705,40729,7921,2,1251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',9870.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1252,3705,40729,7921,2,1252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',8930.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1253,3705,40729,7921,2,1253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',7990.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1254,3705,40729,7921,2,1254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1440.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1255,3705,40729,7921,2,1255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',5640.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1256,3705,40729,7921,2,1256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',2820.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1257,3705,40729,7921,2,1257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',6110.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1258,3705,40729,7921,2,1258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',1440.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1259,3705,40729,7921,2,1259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',8460.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1260,3705,40729,7921,2,1260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',8400.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL);
INSERT INTO `balance_libro` VALUES (1261,3705,40729,7921,2,1261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',9870.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1262,3705,40729,7921,2,1262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',4200.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1263,3705,40729,7921,2,1263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',7990.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1264,3705,40729,7921,2,1264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',5640.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1265,3705,40729,7921,2,1265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',7520.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1266,3705,40729,7921,2,1266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',4700.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1267,3705,40729,7921,2,1267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1440.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1268,3705,40729,7921,2,1268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',4230.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1269,3705,40729,7921,2,1269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',1440.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1270,3705,40729,7921,2,1270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',8930.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1271,3705,40729,7921,2,1271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',8460.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1272,3705,40729,7921,2,1272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',7520.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1273,3705,40729,7921,2,1273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',1410.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1274,3705,40729,7921,2,1274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',4200.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1275,3705,40729,7921,2,1275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',7990.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1276,3705,40729,7921,2,1276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',9870.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1277,3705,40729,7921,2,1277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',6580.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1278,3705,40729,7921,2,1278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',4230.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1279,3705,40729,7921,2,1279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',2350.00,NULL,NULL,1,'2021-08-03 11:54:06','2021-08-03 11:54:06',NULL),(1280,3705,40729,7921,2,1280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',8400.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1281,3705,40729,7921,2,1281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',9400.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1282,3705,40729,7921,2,1282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1440.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1283,3705,40729,7921,2,1283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',7990.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1284,3705,40729,7921,2,1284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',8930.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL);
INSERT INTO `balance_libro` VALUES (1285,3705,40729,7921,2,1285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',1440.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1286,3705,40729,7921,2,1286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',7520.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1287,3705,40729,7921,2,1287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',5170.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1288,3705,40729,7921,2,1288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',8400.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1289,3705,40729,7921,2,1289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',9870.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1290,3705,40729,7921,2,1290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',9400.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1291,3705,40729,7921,2,1291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',7520.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1292,3705,40729,7921,2,1292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',8400.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1293,3705,40729,7921,2,1293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',1440.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1294,3705,40729,7921,2,1294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',9870.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1295,3705,40729,7921,2,1295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',8400.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1296,3705,40729,7921,2,1296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',9400.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1297,3705,40729,7921,2,1297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',8460.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1298,3705,40729,7921,2,1298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',7990.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1299,3705,40729,7921,2,1299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',7990.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1300,3705,40729,7921,2,1300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',6110.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1301,3705,40729,7921,2,1301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',8400.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1302,3705,40729,7921,2,1302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',5640.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1303,3705,40729,7921,2,1303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',8930.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1304,3705,40729,7921,2,1304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',9800.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1305,3705,40729,7921,2,1305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',4900.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1306,3705,40729,7921,2,1306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',9400.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1307,3705,40729,7921,2,1307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1440.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1308,3705,40729,7921,2,1308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',1440.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL);
INSERT INTO `balance_libro` VALUES (1309,3705,40729,7921,2,1309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',8460.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1310,3705,40729,7921,2,1310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',7520.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1311,3705,40729,7921,2,1311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',10340.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1312,3705,40729,7921,2,1312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',8930.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1313,3705,40729,7921,2,1313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',5640.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1314,3705,40729,7921,2,1314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',6110.00,NULL,NULL,1,'2021-08-03 11:54:07','2021-08-03 11:54:07',NULL),(1315,3705,40729,7921,2,1315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',7990.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1316,3705,40729,7921,2,1316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1440.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1317,3705,40729,7921,2,1317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',10340.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1318,3705,40729,7921,2,1318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',9870.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1319,3705,40729,7921,2,1319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',8400.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1320,3705,40729,7921,2,1320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',2820.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1321,3705,40729,7921,2,1321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',8460.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1322,3705,40729,7921,2,1322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1440.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1323,3705,40729,7921,2,1323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',6580.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1324,3705,40729,7921,2,1324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',10810.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1325,3705,40729,7921,2,1325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',4200.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1326,3705,40729,7921,2,1326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',8930.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1327,3705,40729,7921,2,1327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',10340.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1328,3705,40729,7921,2,1328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',8400.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1329,3705,40729,7921,2,1329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',5640.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1330,3705,40729,7921,2,1330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',2160.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1331,3705,40729,7921,2,1331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',11280.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1332,3705,40729,7921,2,1332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',6110.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL);
INSERT INTO `balance_libro` VALUES (1333,3705,40729,7921,2,1333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',7520.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1334,3705,40729,7921,2,1334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',8930.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1335,3705,40729,7921,2,1335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',7990.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1336,3705,40729,7921,2,1336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',9870.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1337,3705,40729,7921,2,1337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',2820.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1338,3705,40729,7921,2,1338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',1340.01,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1339,3705,40729,7921,2,1339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',7990.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1340,3705,40729,7921,2,1340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1440.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1341,3705,40729,7921,2,1341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',6580.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1342,3705,40729,7921,2,1342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',6110.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1343,3705,40729,7921,2,1343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',1440.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1344,3705,40729,7921,2,1344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',11280.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1345,3705,40729,7921,2,1345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',8400.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1346,3705,40729,7921,2,1346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',5640.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1347,3705,40729,7921,2,1347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',9400.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1348,3705,40729,7921,2,1348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',11750.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1349,3705,40729,7921,2,1349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',8400.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1350,3705,40729,7921,2,1350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',12220.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1351,3705,40729,7921,2,1351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',6580.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1352,3705,40729,7921,2,1352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',1440.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1353,3705,40729,7921,2,1353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',4700.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1354,3705,40729,7921,2,1354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',12600.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1355,3705,40729,7921,2,1355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',8460.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1356,3705,40729,7921,2,1356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',5170.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL);
INSERT INTO `balance_libro` VALUES (1357,3705,40729,7921,2,1357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',7050.00,NULL,NULL,1,'2021-08-03 11:54:08','2021-08-03 11:54:08',NULL),(1358,3705,40729,7921,2,1358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',4700.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1359,3705,40729,7921,2,1359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',4200.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1360,3705,40729,7921,2,1360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',10810.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1361,3705,40729,7921,2,1361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',6110.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1362,3705,40729,7921,2,1362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',12220.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1363,3705,40729,7921,2,1363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',4900.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1364,3705,40729,7921,2,1364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',9400.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1365,3705,40729,7921,2,1365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',8400.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1366,3705,40729,7921,2,1366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',8460.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1367,3705,40729,7921,2,1367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',7520.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1368,3705,40729,7921,2,1368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',11280.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1369,3705,40729,7921,2,1369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',940.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1370,3705,40729,7921,2,1370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',1440.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1371,3705,40729,7921,2,1371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',720.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1372,3705,40729,7921,2,1372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',12220.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1373,3705,40729,7921,2,1373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',8400.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1374,3705,40729,7921,2,1374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',10810.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1375,3705,40729,7921,2,1375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',6580.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1376,3705,40729,7921,2,1376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',4200.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1377,3705,40729,7921,2,1377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',8930.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1378,3705,40729,7921,2,1378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',11280.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1379,3705,40729,7921,2,1379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',12220.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1380,3705,40729,7921,2,1380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',2160.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL);
INSERT INTO `balance_libro` VALUES (1381,3705,40729,7921,2,1381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',7990.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1382,3705,40729,7921,2,1382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',12600.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1383,3705,40729,7921,2,1383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',8930.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1384,3705,40729,7921,2,1384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',4700.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1385,3705,40729,7921,2,1385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',6110.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1386,3705,40729,7921,2,1386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1440.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1387,3705,40729,7921,2,1387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',5170.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1388,3705,40729,7921,2,1388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',8400.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1389,3705,40729,7921,2,1389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',11280.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1390,3705,40729,7921,2,1390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',4700.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1391,3705,40729,7921,2,1391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',12690.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1392,3705,40729,7921,2,1392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',9870.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1393,3705,40729,7921,2,1393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',5640.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1394,3705,40729,7921,2,1394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',4230.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1395,3705,40729,7921,2,1395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',8400.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1396,3705,40729,7921,2,1396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',5170.00,NULL,NULL,1,'2021-08-03 11:54:09','2021-08-03 11:54:09',NULL),(1397,3705,40729,7921,2,1397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',6580.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1398,3705,40729,7921,2,1398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',3760.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1399,3705,40729,7921,2,1399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',1440.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1400,3705,40729,7921,2,1400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',8930.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1401,3705,40729,7921,2,1401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',8400.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1402,3705,40729,7921,2,1402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',11280.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1403,3705,40729,7921,2,1403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',2160.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1404,3705,40729,7921,2,1404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',12690.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL);
INSERT INTO `balance_libro` VALUES (1405,3705,40729,7921,2,1405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',9400.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1406,3705,40729,7921,2,1406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',5640.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1407,3705,40729,7921,2,1407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',4200.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1408,3705,40729,7921,2,1408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',4230.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1409,3705,40729,7921,2,1409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',6110.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1410,3705,40729,7921,2,1410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',7990.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1411,3705,40729,7921,2,1411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',4700.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1412,3705,40729,7921,2,1412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',4200.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1413,3705,40729,7921,2,1413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',9800.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1414,3705,40729,7921,2,1414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',7050.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1415,3705,40729,7921,2,1415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1440.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1416,3705,40729,7921,2,1416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',6110.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1417,3705,40729,7921,2,1417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',4700.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1418,3705,40729,7921,2,1418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',7990.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1419,3705,40729,7921,2,1419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',5640.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1420,3705,40729,7921,2,1420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',1440.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1421,3705,40729,7921,2,1421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',12690.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1422,3705,40729,7921,2,1422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',9870.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1423,3705,40729,7921,2,1423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',12600.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1424,3705,40729,7921,2,1424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',4700.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1425,3705,40729,7921,2,1425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',4200.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1426,3705,40729,7921,2,1426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',7050.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1427,3705,40729,7921,2,1427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1000.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1428,3705,40729,7921,2,1428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',6580.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL);
INSERT INTO `balance_libro` VALUES (1429,3705,40729,7921,2,1429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',720.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1430,3705,40729,7921,2,1430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',4230.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1431,3705,40729,7921,2,1431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',4200.00,NULL,NULL,1,'2021-08-03 11:54:10','2021-08-03 11:54:10',NULL),(1432,3705,40729,7921,2,1432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',10340.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1433,3705,40729,7921,2,1433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',5640.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1434,3705,40729,7921,2,1434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3760.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1435,3705,40729,7921,2,1435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',6110.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1436,3705,40729,7921,2,1436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1440.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1437,3705,40729,7921,2,1437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',12690.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1438,3705,40729,7921,2,1438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',11280.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1439,3705,40729,7921,2,1439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',12220.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1440,3705,40729,7921,2,1440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',12600.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1441,3705,40729,7921,2,1441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',4900.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1442,3705,40729,7921,2,1442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',1340.01,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1443,3705,40729,7921,2,1443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',4200.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1444,3705,40729,7921,2,1444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',8460.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1445,3705,40729,7921,2,1445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',5640.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1446,3705,40729,7921,2,1446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',8400.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1447,3705,40729,7921,2,1447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1440.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1448,3705,40729,7921,2,1448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',9400.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1449,3705,40729,7921,2,1449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',7520.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1450,3705,40729,7921,2,1450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',12690.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1451,3705,40729,7921,2,1451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',10810.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1452,3705,40729,7921,2,1452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',4200.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL);
INSERT INTO `balance_libro` VALUES (1453,3705,40729,7921,2,1453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',3760.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1454,3705,40729,7921,2,1454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',1440.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1455,3705,40729,7921,2,1455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',4700.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1456,3705,40729,7921,2,1456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',6110.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1457,3705,40729,7921,2,1457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',6580.00,NULL,NULL,1,'2021-08-03 11:54:11','2021-08-03 11:54:11',NULL),(1458,3705,40729,7921,2,1458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4900.00,NULL,NULL,1,'2021-08-03 11:54:12','2021-08-03 11:54:12',NULL),(1459,3705,40729,7921,2,1459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',8400.00,NULL,NULL,1,'2021-08-03 11:54:12','2021-08-03 11:54:12',NULL),(1460,3705,40729,7921,2,1460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',6580.00,NULL,NULL,1,'2021-08-03 11:54:12','2021-08-03 11:54:12',NULL),(1461,3705,40729,7921,2,1461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',11280.00,NULL,NULL,1,'2021-08-03 11:54:12','2021-08-03 11:54:12',NULL),(1462,3705,40729,7921,2,1462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1440.00,NULL,NULL,1,'2021-08-03 11:54:12','2021-08-03 11:54:12',NULL),(1463,3705,40729,7921,2,1463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',4700.00,NULL,NULL,1,'2021-08-03 11:54:12','2021-08-03 11:54:12',NULL),(1464,3705,40729,7921,2,1464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',6110.00,NULL,NULL,1,'2021-08-03 11:54:12','2021-08-03 11:54:12',NULL),(1465,3705,40729,7921,2,1465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',12220.00,NULL,NULL,1,'2021-08-03 11:54:12','2021-08-03 11:54:12',NULL),(1466,3705,40729,7921,2,1466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',8400.00,NULL,NULL,1,'2021-08-03 11:54:12','2021-08-03 11:54:12',NULL),(1467,3705,40729,7921,2,1467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',11280.00,NULL,NULL,1,'2021-08-03 11:54:12','2021-08-03 11:54:12',NULL),(1468,3705,40729,7921,2,1468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',3290.00,NULL,NULL,1,'2021-08-03 11:54:12','2021-08-03 11:54:12',NULL),(1469,3705,40729,7921,2,1469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',1440.00,NULL,NULL,1,'2021-08-03 11:54:12','2021-08-03 11:54:12',NULL),(1470,3705,40729,7921,2,1470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',5170.00,NULL,NULL,1,'2021-08-03 11:54:12','2021-08-03 11:54:12',NULL),(1471,3705,40729,7921,3,1471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',11700.01,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1472,3705,40729,7921,3,1472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',21060.02,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1473,3705,40729,7921,3,1473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',2005.10,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1474,3705,40729,7921,3,1474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',25935.02,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1475,3705,40729,7921,3,1475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',24849.99,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1476,3705,40729,7921,3,1476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',2340.00,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL);
INSERT INTO `balance_libro` VALUES (1477,3705,40729,7921,3,1477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',11700.01,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1478,3705,40729,7921,3,1478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-02','2021-07-02',5850.01,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1479,3705,40729,7921,3,1479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',11700.01,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1480,3705,40729,7921,3,1480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',27770.01,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1481,3705,40729,7921,3,1481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',21490.01,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1482,3705,40729,7921,3,1482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-03','2021-07-03',26795.01,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1483,3705,40729,7921,3,1483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',210.35,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1484,3705,40729,7921,3,1484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',14860.01,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1485,3705,40729,7921,3,1485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-05','2021-07-05',1622.25,NULL,NULL,1,'2021-08-03 11:54:59','2021-08-03 11:54:59',NULL),(1486,3705,40729,7921,3,1486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',4600.00,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1487,3705,40729,7921,3,1487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',22935.02,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1488,3705,40729,7921,3,1488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',5460.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1489,3705,40729,7921,3,1489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-06','2021-07-06',11700.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1490,3705,40729,7921,3,1490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',31750.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1491,3705,40729,7921,3,1491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',11310.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1492,3705,40729,7921,3,1492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-07','2021-07-07',29840.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1493,3705,40729,7921,3,1493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',11310.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1494,3705,40729,7921,3,1494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',11310.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1495,3705,40729,7921,3,1495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',8190.00,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1496,3705,40729,7921,3,1496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',7800.00,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1497,3705,40729,7921,3,1497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',8190.00,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1498,3705,40729,7921,3,1498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',9945.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1499,3705,40729,7921,3,1499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',19110.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1500,3705,40729,7921,3,1500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',7410.00,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL);
INSERT INTO `balance_libro` VALUES (1501,3705,40729,7921,3,1501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',21060.02,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1502,3705,40729,7921,3,1502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',11389.99,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1503,3705,40729,7921,3,1503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',28410.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1504,3705,40729,7921,3,1504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',3120.00,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1505,3705,40729,7921,3,1505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',7410.00,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1506,3705,40729,7921,3,1506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',22660.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1507,3705,40729,7921,3,1507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',11310.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1508,3705,40729,7921,3,1508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',23130.02,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1509,3705,40729,7921,3,1509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',19920.02,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1510,3705,40729,7921,3,1510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',19500.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1511,3705,40729,7921,3,1511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',15680.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1512,3705,40729,7921,3,1512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-08','2021-07-08',6825.00,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1513,3705,40729,7921,3,1513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-09','2021-07-09',24105.02,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1514,3705,40729,7921,3,1514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',11310.01,NULL,NULL,1,'2021-08-03 11:55:00','2021-08-03 11:55:00',NULL),(1515,3705,40729,7921,3,1515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',15600.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1516,3705,40729,7921,3,1516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-10','2021-07-10',29370.03,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1517,3705,40729,7921,3,1517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-11','2021-07-11',37550.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1518,3705,40729,7921,3,1518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',6630.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1519,3705,40729,7921,3,1519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-12','2021-07-12',10530.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1520,3705,40729,7921,3,1520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',13260.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1521,3705,40729,7921,3,1521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',23325.02,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1522,3705,40729,7921,3,1522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',7215.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1523,3705,40729,7921,3,1523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-13','2021-07-13',19695.02,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1524,3705,40729,7921,3,1524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',12090.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL);
INSERT INTO `balance_libro` VALUES (1525,3705,40729,7921,3,1525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',12090.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1526,3705,40729,7921,3,1526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',16225.02,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1527,3705,40729,7921,3,1527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',12090.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1528,3705,40729,7921,3,1528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-14','2021-07-14',21060.02,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1529,3705,40729,7921,3,1529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',32570.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1530,3705,40729,7921,3,1530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',9360.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1531,3705,40729,7921,3,1531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',8580.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1532,3705,40729,7921,3,1532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',13650.02,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1533,3705,40729,7921,3,1533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',10140.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1534,3705,40729,7921,3,1534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',7800.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1535,3705,40729,7921,3,1535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',6630.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1536,3705,40729,7921,3,1536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',5880.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1537,3705,40729,7921,3,1537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',8385.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1538,3705,40729,7921,3,1538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',10390.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1539,3705,40729,7921,3,1539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',8970.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1540,3705,40729,7921,3,1540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-15','2021-07-15',27225.02,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1541,3705,40729,7921,3,1541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',30050.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1542,3705,40729,7921,3,1542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',5850.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1543,3705,40729,7921,3,1543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-16','2021-07-16',11895.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1544,3705,40729,7921,3,1544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',21375.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1545,3705,40729,7921,3,1545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',7605.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1546,3705,40729,7921,3,1546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',7450.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1547,3705,40729,7921,3,1547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',5850.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1548,3705,40729,7921,3,1548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',7410.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL);
INSERT INTO `balance_libro` VALUES (1549,3705,40729,7921,3,1549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',12090.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1550,3705,40729,7921,3,1550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-17','2021-07-17',6240.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1551,3705,40729,7921,3,1551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',325.61,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1552,3705,40729,7921,3,1552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',11310.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1553,3705,40729,7921,3,1553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',7020.00,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1554,3705,40729,7921,3,1554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',6435.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1555,3705,40729,7921,3,1555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',10140.01,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1556,3705,40729,7921,3,1556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',23050.02,NULL,NULL,1,'2021-08-03 11:55:01','2021-08-03 11:55:01',NULL),(1557,3705,40729,7921,3,1557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',20085.02,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1558,3705,40729,7921,3,1558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',20710.02,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1559,3705,40729,7921,3,1559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',12870.02,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1560,3705,40729,7921,3,1560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-19','2021-07-19',1795.10,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1561,3705,40729,7921,3,1561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',34245.02,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1562,3705,40729,7921,3,1562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',22090.02,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1563,3705,40729,7921,3,1563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',11700.01,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1564,3705,40729,7921,3,1564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',9790.00,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1565,3705,40729,7921,3,1565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',6240.00,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1566,3705,40729,7921,3,1566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',24220.02,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1567,3705,40729,7921,3,1567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-20','2021-07-20',3497.62,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1568,3705,40729,7921,3,1568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',31320.01,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1569,3705,40729,7921,3,1569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',12090.02,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1570,3705,40729,7921,3,1570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',15055.01,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1571,3705,40729,7921,3,1571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',12090.02,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1572,3705,40729,7921,3,1572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',10920.01,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL);
INSERT INTO `balance_libro` VALUES (1573,3705,40729,7921,3,1573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',11310.01,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1574,3705,40729,7921,3,1574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-21','2021-07-21',16420.02,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1575,3705,40729,7921,3,1575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',10530.00,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1576,3705,40729,7921,3,1576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',4680.00,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1577,3705,40729,7921,3,1577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',7450.00,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1578,3705,40729,7921,3,1578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',10920.01,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1579,3705,40729,7921,3,1579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',5890.00,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1580,3705,40729,7921,3,1580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',43100.01,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1581,3705,40729,7921,3,1581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',9360.00,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1582,3705,40729,7921,3,1582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-22','2021-07-22',6000.00,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1583,3705,40729,7921,3,1583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',19790.01,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1584,3705,40729,7921,3,1584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',16124.99,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1585,3705,40729,7921,3,1585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-23','2021-07-23',7099.99,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1586,3705,40729,7921,3,1586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',44620.01,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1587,3705,40729,7921,3,1587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',12090.01,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1588,3705,40729,7921,3,1588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',44620.01,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1589,3705,40729,7921,3,1589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24','2021-07-24',30580.00,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1590,3705,40729,7921,3,1590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',15100.00,NULL,NULL,1,'2021-08-03 11:55:02','2021-08-03 11:55:02',NULL),(1591,3705,40729,7921,3,1591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',12090.01,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1592,3705,40729,7921,3,1592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',20165.01,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1593,3705,40729,7921,3,1593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',9750.01,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1594,3705,40729,7921,3,1594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',5070.00,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1595,3705,40729,7921,3,1595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',13260.02,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1596,3705,40729,7921,3,1596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-26','2021-07-26',15990.02,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL);
INSERT INTO `balance_libro` VALUES (1597,3705,40729,7921,3,1597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',5460.01,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1598,3705,40729,7921,3,1598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',11310.01,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1599,3705,40729,7921,3,1599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',27460.01,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1600,3705,40729,7921,3,1600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',18970.02,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1601,3705,40729,7921,3,1601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',9945.01,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1602,3705,40729,7921,3,1602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',3550.00,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1603,3705,40729,7921,3,1603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27','2021-07-27',5850.01,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1604,3705,40729,7921,3,1604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',11700.01,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1605,3705,40729,7921,3,1605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',8190.00,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1606,3705,40729,7921,3,1606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',4290.00,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1607,3705,40729,7921,3,1607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28','2021-07-28',19110.01,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1608,3705,40729,7921,3,1608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3491.72,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1609,3705,40729,7921,3,1609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',10310.43,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1610,3705,40729,7921,3,1610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',11505.01,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1611,3705,40729,7921,3,1611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-29','2021-07-29',3550.00,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1612,3705,40729,7921,3,1612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-30','2021-07-30',11310.01,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1613,3705,40729,7921,3,1613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-31','2021-07-31',11700.01,NULL,NULL,1,'2021-08-03 11:55:03','2021-08-03 11:55:03',NULL),(1614,3705,40729,7915,2,1614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',3510.00,NULL,NULL,1,'2021-08-03 12:43:26','2021-08-03 12:43:26',NULL),(1615,3705,40729,7915,2,1615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',6240.00,NULL,NULL,1,'2021-08-03 12:43:26','2021-08-03 12:43:26',NULL),(1616,3705,40729,7915,2,1616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',1800.00,NULL,NULL,1,'2021-08-03 12:43:26','2021-08-03 12:43:26',NULL),(1617,3705,40729,7915,2,1617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',2730.00,NULL,NULL,1,'2021-08-03 12:43:26','2021-08-03 12:43:26',NULL),(1618,3705,40729,7915,2,1618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',4290.00,NULL,NULL,1,'2021-08-03 12:43:26','2021-08-03 12:43:26',NULL),(1619,3705,40729,7915,2,1619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',5200.00,NULL,NULL,1,'2021-08-03 12:43:26','2021-08-03 12:43:26',NULL),(1620,3705,40729,7915,2,1620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',4290.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL);
INSERT INTO `balance_libro` VALUES (1621,3705,40729,7915,2,1621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',7410.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1622,3705,40729,7915,2,1622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',6630.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1623,3705,40729,7915,2,1623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',4290.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1624,3705,40729,7915,2,1624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',6240.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1625,3705,40729,7915,2,1625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',1950.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1626,3705,40729,7915,2,1626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',3900.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1627,3705,40729,7915,2,1627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',7800.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1628,3705,40729,7915,2,1628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',2730.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1629,3705,40729,7915,2,1629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',7020.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1630,3705,40729,7915,2,1630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',2340.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1631,3705,40729,7915,2,1631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',7800.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1632,3705,40729,7915,2,1632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',5850.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1633,3705,40729,7915,2,1633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',2400.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1634,3705,40729,7915,2,1634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',4680.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1635,3705,40729,7915,2,1635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',3900.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1636,3705,40729,7915,2,1636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',5850.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1637,3705,40729,7915,2,1637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',6630.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1638,3705,40729,7915,2,1638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',1800.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1639,3705,40729,7915,2,1639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',7410.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1640,3705,40729,7915,2,1640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',6630.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1641,3705,40729,7915,2,1641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',3900.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1642,3705,40729,7915,2,1642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',6240.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1643,3705,40729,7915,2,1643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',4290.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1644,3705,40729,7915,2,1644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',5200.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL);
INSERT INTO `balance_libro` VALUES (1645,3705,40729,7915,2,1645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',5850.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1646,3705,40729,7915,2,1646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',1200.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1647,3705,40729,7915,2,1647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',6630.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1648,3705,40729,7915,2,1648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',4680.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1649,3705,40729,7915,2,1649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',3900.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1650,3705,40729,7915,2,1650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',2730.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1651,3705,40729,7915,2,1651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',7020.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1652,3705,40729,7915,2,1652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',5200.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1653,3705,40729,7915,2,1653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',6240.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1654,3705,40729,7915,2,1654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',5460.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1655,3705,40729,7915,2,1655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',3900.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1656,3705,40729,7915,2,1656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',2340.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1657,3705,40729,7915,2,1657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',1200.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1658,3705,40729,7915,2,1658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',4290.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1659,3705,40729,7915,2,1659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',2730.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1660,3705,40729,7915,2,1660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',6240.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1661,3705,40729,7915,2,1661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',4680.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1662,3705,40729,7915,2,1662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',3510.00,NULL,NULL,1,'2021-08-03 12:43:27','2021-08-03 12:43:27',NULL),(1663,3705,40729,7915,2,1663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',5460.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1664,3705,40729,7915,2,1664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',3900.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1665,3705,40729,7915,2,1665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',1200.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1666,3705,40729,7915,2,1666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',7410.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1667,3705,40729,7915,2,1667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',5850.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1668,3705,40729,7915,2,1668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',5200.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL);
INSERT INTO `balance_libro` VALUES (1669,3705,40729,7915,2,1669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',6630.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1670,3705,40729,7915,2,1670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',4290.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1671,3705,40729,7915,2,1671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',3120.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1672,3705,40729,7915,2,1672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',6630.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1673,3705,40729,7915,2,1673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',4680.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1674,3705,40729,7915,2,1674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',3900.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1675,3705,40729,7915,2,1675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',5200.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1676,3705,40729,7915,2,1676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',6240.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1677,3705,40729,7915,2,1677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',1800.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1678,3705,40729,7915,2,1678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',5460.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1679,3705,40729,7915,2,1679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',7410.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1680,3705,40729,7915,2,1680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',5850.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1681,3705,40729,7915,2,1681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',3510.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1682,3705,40729,7915,2,1682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',7500.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1683,3705,40729,7915,2,1683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',3500.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1684,3705,40729,7915,2,1684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',8580.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1685,3705,40729,7915,2,1685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',3510.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1686,3705,40729,7915,2,1686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',6630.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1687,3705,40729,7915,2,1687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',5200.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1688,3705,40729,7915,2,1688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',7020.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1689,3705,40729,7915,2,1689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',6240.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1690,3705,40729,7915,2,1690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',7800.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1691,3705,40729,7915,2,1691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',6630.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1692,3705,40729,7915,2,1692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',3900.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL);
INSERT INTO `balance_libro` VALUES (1693,3705,40729,7915,2,1693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',2340.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1694,3705,40729,7915,2,1694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',5200.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1695,3705,40729,7915,2,1695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',7800.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1696,3705,40729,7915,2,1696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',8580.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1697,3705,40729,7915,2,1697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',5850.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1698,3705,40729,7915,2,1698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',8190.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1699,3705,40729,7915,2,1699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',7410.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1700,3705,40729,7915,2,1700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',8580.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1701,3705,40729,7915,2,1701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',5850.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1702,3705,40729,7915,2,1702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',1200.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1703,3705,40729,7915,2,1703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',4680.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1704,3705,40729,7915,2,1704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',5200.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1705,3705,40729,7915,2,1705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',3900.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1706,3705,40729,7915,2,1706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',2730.00,NULL,NULL,1,'2021-08-03 12:43:28','2021-08-03 12:43:28',NULL),(1707,3705,40729,7915,2,1707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',6240.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1708,3705,40729,7915,2,1708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',4680.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1709,3705,40729,7915,2,1709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',7020.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1710,3705,40729,7915,2,1710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',2340.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1711,3705,40729,7915,2,1711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',7800.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1712,3705,40729,7915,2,1712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',7800.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1713,3705,40729,7915,2,1713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',4290.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1714,3705,40729,7915,2,1714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',3510.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1715,3705,40729,7915,2,1715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',5850.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1716,3705,40729,7915,2,1716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',8580.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL);
INSERT INTO `balance_libro` VALUES (1717,3705,40729,7915,2,1717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',3900.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1718,3705,40729,7915,2,1718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',5070.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1719,3705,40729,7915,2,1719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',5200.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1720,3705,40729,7915,2,1720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',7800.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1721,3705,40729,7915,2,1721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',6630.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1722,3705,40729,7915,2,1722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',7800.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1723,3705,40729,7915,2,1723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',8190.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1724,3705,40729,7915,2,1724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',7800.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1725,3705,40729,7915,2,1725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',1200.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1726,3705,40729,7915,2,1726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',4680.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1727,3705,40729,7915,2,1727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',5070.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1728,3705,40729,7915,2,1728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',5200.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1729,3705,40729,7915,2,1729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',3900.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1730,3705,40729,7915,2,1730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',7800.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1731,3705,40729,7915,2,1731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',5460.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1732,3705,40729,7915,2,1732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',3900.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1733,3705,40729,7915,2,1733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',6630.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1734,3705,40729,7915,2,1734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',7410.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1735,3705,40729,7915,2,1735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',7410.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1736,3705,40729,7915,2,1736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',5850.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1737,3705,40729,7915,2,1737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',5200.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1738,3705,40729,7915,2,1738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',4290.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1739,3705,40729,7915,2,1739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',2340.00,NULL,NULL,1,'2021-08-03 12:43:29','2021-08-03 12:43:29',NULL),(1740,3705,40729,7915,2,1740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',6240.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL);
INSERT INTO `balance_libro` VALUES (1741,3705,40729,7915,2,1741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',4680.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1742,3705,40729,7915,2,1742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1200.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1743,3705,40729,7915,2,1743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',2730.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1744,3705,40729,7915,2,1744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',5460.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1745,3705,40729,7915,2,1745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',6700.01,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1746,3705,40729,7915,2,1746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',3350.01,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1747,3705,40729,7915,2,1747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',7800.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1748,3705,40729,7915,2,1748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',5070.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1749,3705,40729,7915,2,1749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',8190.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1750,3705,40729,7915,2,1750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',5200.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1751,3705,40729,7915,2,1751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',2730.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1752,3705,40729,7915,2,1752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',4680.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1753,3705,40729,7915,2,1753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',5200.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1754,3705,40729,7915,2,1754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',5460.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1755,3705,40729,7915,2,1755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',2340.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1756,3705,40729,7915,2,1756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',6630.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1757,3705,40729,7915,2,1757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',1200.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1758,3705,40729,7915,2,1758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',5070.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1759,3705,40729,7915,2,1759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',5200.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1760,3705,40729,7915,2,1760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',6240.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1761,3705,40729,7915,2,1761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',3120.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1762,3705,40729,7915,2,1762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',5850.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1763,3705,40729,7915,2,1763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',7800.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1764,3705,40729,7915,2,1764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',7020.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL);
INSERT INTO `balance_libro` VALUES (1765,3705,40729,7915,2,1765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',5070.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1766,3705,40729,7915,2,1766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',7020.00,NULL,NULL,1,'2021-08-03 12:43:30','2021-08-03 12:43:30',NULL),(1767,3705,40729,7915,2,1767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',8580.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1768,3705,40729,7915,2,1768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',5200.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1769,3705,40729,7915,2,1769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',7800.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1770,3705,40729,7915,2,1770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',1200.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1771,3705,40729,7915,2,1771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',3900.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1772,3705,40729,7915,2,1772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',6630.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1773,3705,40729,7915,2,1773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',8190.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1774,3705,40729,7915,2,1774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',6630.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1775,3705,40729,7915,2,1775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',1800.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1776,3705,40729,7915,2,1776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',5850.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1777,3705,40729,7915,2,1777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',6240.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1778,3705,40729,7915,2,1778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',5200.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1779,3705,40729,7915,2,1779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',7800.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1780,3705,40729,7915,2,1780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',5200.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1781,3705,40729,7915,2,1781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',7800.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1782,3705,40729,7915,2,1782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',8580.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1783,3705,40729,7915,2,1783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',7020.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1784,3705,40729,7915,2,1784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',5070.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1785,3705,40729,7915,2,1785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',2730.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1786,3705,40729,7915,2,1786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',5850.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1787,3705,40729,7915,2,1787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',3510.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1788,3705,40729,7915,2,1788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',7410.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL);
INSERT INTO `balance_libro` VALUES (1789,3705,40729,7915,2,1789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',8580.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1790,3705,40729,7915,2,1790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',6630.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1791,3705,40729,7915,2,1791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',4680.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1792,3705,40729,7915,2,1792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',6240.00,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1793,3705,40729,7915,2,1793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',6700.01,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1794,3705,40729,7915,2,1794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',3350.01,NULL,NULL,1,'2021-08-03 12:43:31','2021-08-03 12:43:31',NULL),(1795,3705,40729,7915,2,1795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',6630.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1796,3705,40729,7915,2,1796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',4680.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1797,3705,40729,7915,2,1797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',8190.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1798,3705,40729,7915,2,1798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',7410.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1799,3705,40729,7915,2,1799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',5460.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1800,3705,40729,7915,2,1800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',4680.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1801,3705,40729,7915,2,1801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1800.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1802,3705,40729,7915,2,1802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',5850.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1803,3705,40729,7915,2,1803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',5600.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1804,3705,40729,7915,2,1804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',6630.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1805,3705,40729,7915,2,1805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',8580.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1806,3705,40729,7915,2,1806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',3510.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1807,3705,40729,7915,2,1807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',1200.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1808,3705,40729,7915,2,1808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',7020.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1809,3705,40729,7915,2,1809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',6630.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1810,3705,40729,7915,2,1810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',7800.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1811,3705,40729,7915,2,1811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',3120.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1812,3705,40729,7915,2,1812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',5600.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL);
INSERT INTO `balance_libro` VALUES (1813,3705,40729,7915,2,1813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',6630.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1814,3705,40729,7915,2,1814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',4680.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1815,3705,40729,7915,2,1815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',8190.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1816,3705,40729,7915,2,1816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',7410.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1817,3705,40729,7915,2,1817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',8400.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1818,3705,40729,7915,2,1818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',5850.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1819,3705,40729,7915,2,1819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',8400.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1820,3705,40729,7915,2,1820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',3510.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1821,3705,40729,7915,2,1821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',2730.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1822,3705,40729,7915,2,1822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',5600.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1823,3705,40729,7915,2,1823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',3500.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1824,3705,40729,7915,2,1824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',6240.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1825,3705,40729,7915,2,1825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',4680.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1826,3705,40729,7915,2,1826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',2800.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1827,3705,40729,7915,2,1827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',7800.00,NULL,NULL,1,'2021-08-03 12:43:32','2021-08-03 12:43:32',NULL),(1828,3705,40729,7915,2,1828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',8400.00,NULL,NULL,1,'2021-08-03 12:43:33','2021-08-03 12:43:33',NULL),(1829,3705,40729,7915,2,1829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',6630.00,NULL,NULL,1,'2021-08-03 12:43:33','2021-08-03 12:43:33',NULL),(1830,3705,40729,7915,2,1830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',5600.00,NULL,NULL,1,'2021-08-03 12:43:33','2021-08-03 12:43:33',NULL),(1831,3705,40729,7915,2,1831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',5850.00,NULL,NULL,1,'2021-08-03 12:43:33','2021-08-03 12:43:33',NULL),(1832,3705,40729,7915,2,1832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',5600.00,NULL,NULL,1,'2021-08-03 12:43:33','2021-08-03 12:43:33',NULL),(1833,3705,40729,7915,2,1833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',7410.00,NULL,NULL,1,'2021-08-03 12:43:33','2021-08-03 12:43:33',NULL),(1834,3705,40729,7915,2,1834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',8580.00,NULL,NULL,1,'2021-08-03 12:43:33','2021-08-03 12:43:33',NULL),(1835,3705,40729,7915,2,1835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',7800.00,NULL,NULL,1,'2021-08-03 12:43:33','2021-08-03 12:43:33',NULL),(1836,3705,40729,7915,2,1836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',1200.00,NULL,NULL,1,'2021-08-03 12:43:33','2021-08-03 12:43:33',NULL);
INSERT INTO `balance_libro` VALUES (1837,3705,40729,7915,2,1837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',7410.00,NULL,NULL,1,'2021-08-03 12:43:33','2021-08-03 12:43:33',NULL),(1838,3705,40729,7915,2,1838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',5600.00,NULL,NULL,1,'2021-08-03 12:43:33','2021-08-03 12:43:33',NULL),(1839,3705,40729,7915,2,1839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',1660.00,NULL,NULL,1,'2021-08-03 12:43:33','2021-08-03 12:43:33',NULL),(1840,3705,40729,7915,3,1840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',14080.00,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1841,3705,40729,7915,3,1841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',4800.01,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1842,3705,40729,7915,3,1842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',17200.01,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1843,3705,40729,7915,3,1843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',15640.00,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1844,3705,40729,7915,3,1844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',11200.00,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1845,3705,40729,7915,3,1845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',185.25,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1846,3705,40729,7915,3,1846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',9600.01,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1847,3705,40729,7915,3,1847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',4479.99,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1848,3705,40729,7915,3,1848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',14320.00,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1849,3705,40729,7915,3,1849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',1375.50,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1850,3705,40729,7915,3,1850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',9240.01,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1851,3705,40729,7915,3,1851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',13440.00,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1852,3705,40729,7915,3,1852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',11800.01,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1853,3705,40729,7915,3,1853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',2200.00,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1854,3705,40729,7915,3,1854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',7639.99,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1855,3705,40729,7915,3,1855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',13880.00,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1856,3705,40729,7915,3,1856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',11200.00,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1857,3705,40729,7915,3,1857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',14560.00,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1858,3705,40729,7915,3,1858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',17200.01,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1859,3705,40729,7915,3,1859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',14985.99,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1860,3705,40729,7915,3,1860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',8000.00,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL);
INSERT INTO `balance_libro` VALUES (1861,3705,40729,7915,3,1861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',13280.00,NULL,NULL,1,'2021-08-03 12:47:52','2021-08-03 12:47:52',NULL),(1862,3705,40729,7915,3,1862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',7320.00,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1863,3705,40729,7915,3,1863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',27120.01,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1864,3705,40729,7915,3,1864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',27120.01,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1865,3705,40729,7915,3,1865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',9840.01,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1866,3705,40729,7915,3,1866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',16240.00,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1867,3705,40729,7915,3,1867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',14400.00,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1868,3705,40729,7915,3,1868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',3840.01,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1869,3705,40729,7915,3,1869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',8709.99,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1870,3705,40729,7915,3,1870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',7440.00,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1871,3705,40729,7915,3,1871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',4650.00,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1872,3705,40729,7915,3,1872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',4800.00,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1873,3705,40729,7915,3,1873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',4640.00,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1874,3705,40729,7915,3,1874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',5440.00,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1875,3705,40729,7915,3,1875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',7200.01,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1876,3705,40729,7915,3,1876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',8000.00,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1877,3705,40729,7915,3,1877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',5120.00,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1878,3705,40729,7915,3,1878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',7440.00,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1879,3705,40729,7915,3,1879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',7285.00,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1880,3705,40729,7915,3,1880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',5890.00,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1881,3705,40729,7915,3,1881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',8989.99,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1882,3705,40729,7915,3,1882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',7594.99,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1883,3705,40729,7915,3,1883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',7934.99,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL),(1884,3705,40729,7915,3,1884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',8679.99,NULL,NULL,1,'2021-08-03 12:47:53','2021-08-03 12:47:53',NULL);
INSERT INTO `balance_libro` VALUES (1885,3705,40729,7915,3,1885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',5610.00,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1886,3705,40729,7915,3,1886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',2479.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1887,3705,40729,7915,3,1887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',10600.00,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1888,3705,40729,7915,3,1888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',9299.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1889,3705,40729,7915,3,1889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',7470.00,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1890,3705,40729,7915,3,1890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',8709.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1891,3705,40729,7915,3,1891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',8554.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1892,3705,40729,7915,3,1892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',6540.00,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1893,3705,40729,7915,3,1893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',4060.00,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1894,3705,40729,7915,3,1894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',7779.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1895,3705,40729,7915,3,1895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',6820.00,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1896,3705,40729,7915,3,1896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',13790.00,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1897,3705,40729,7915,3,1897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',7749.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1898,3705,40729,7915,3,1898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',8059.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1899,3705,40729,7915,3,1899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',5920.00,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1900,3705,40729,7915,3,1900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',90.10,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1901,3705,40729,7915,3,1901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',8834.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1902,3705,40729,7915,3,1902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',3564.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1903,3705,40729,7915,3,1903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',4030.00,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1904,3705,40729,7915,3,1904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',3720.00,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1905,3705,40729,7915,3,1905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1239.00,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1906,3705,40729,7915,3,1906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',5500.01,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1907,3705,40729,7915,3,1907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',14020.01,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1908,3705,40729,7915,3,1908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',9299.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL);
INSERT INTO `balance_libro` VALUES (1909,3705,40729,7915,3,1909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',6120.01,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1910,3705,40729,7915,3,1910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',8709.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1911,3705,40729,7915,3,1911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',6199.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1912,3705,40729,7915,3,1912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',12859.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1913,3705,40729,7915,3,1913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',5579.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1914,3705,40729,7915,3,1914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',6354.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1915,3705,40729,7915,3,1915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',8554.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1916,3705,40729,7915,3,1916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',4959.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1917,3705,40729,7915,3,1917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',7979.99,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1918,3705,40729,7915,3,1918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',9220.01,NULL,NULL,1,'2021-08-03 12:47:54','2021-08-03 12:47:54',NULL),(1919,3705,40729,7915,3,1919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',2400.01,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1920,3705,40729,7915,3,1920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',11464.99,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1921,3705,40729,7915,3,1921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',8679.99,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1922,3705,40729,7915,3,1922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',6430.01,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1923,3705,40729,7915,3,1923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',2118.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1924,3705,40729,7915,3,1924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',9299.99,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1925,3705,40729,7915,3,1925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',4650.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1926,3705,40729,7915,3,1926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',13480.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1927,3705,40729,7915,3,1927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',4960.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1928,3705,40729,7915,3,1928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',5965.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1929,3705,40729,7915,3,1929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',4340.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1930,3705,40729,7915,3,1930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',6820.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1931,3705,40729,7915,3,1931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',10844.98,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1932,3705,40729,7915,3,1932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',8600.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL);
INSERT INTO `balance_libro` VALUES (1933,3705,40729,7915,3,1933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',9299.99,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1934,3705,40729,7915,3,1934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',5035.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1935,3705,40729,7915,3,1935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',17585.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1936,3705,40729,7915,3,1936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',8989.99,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1937,3705,40729,7915,3,1937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',9065.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1938,3705,40729,7915,3,1938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',5100.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1939,3705,40729,7915,3,1939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',4650.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1940,3705,40729,7915,3,1940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',7285.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1941,3705,40729,7915,3,1941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',12550.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1942,3705,40729,7915,3,1942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',8679.99,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1943,3705,40729,7915,3,1943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',3410.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1944,3705,40729,7915,3,1944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',6199.99,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1945,3705,40729,7915,3,1945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',7359.99,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1946,3705,40729,7915,3,1946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',5579.99,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1947,3705,40729,7915,3,1947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',3564.99,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1948,3705,40729,7915,3,1948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',12000.01,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1949,3705,40729,7915,3,1949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',2400.01,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1950,3705,40729,7915,3,1950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',8369.99,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1951,3705,40729,7915,3,1951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',12850.00,NULL,NULL,1,'2021-08-03 12:47:55','2021-08-03 12:47:55',NULL),(1952,3705,40729,7915,3,1952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',5579.99,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL),(1953,3705,40729,7915,3,1953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',8835.00,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL),(1954,3705,40729,7915,3,1954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',7749.99,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL),(1955,3705,40729,7915,3,1955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',16345.00,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL),(1956,3705,40729,7915,3,1956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',16345.00,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL);
INSERT INTO `balance_libro` VALUES (1957,3705,40729,7915,3,1957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',3795.01,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL),(1958,3705,40729,7915,3,1958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',18070.00,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL),(1959,3705,40729,7915,3,1959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',7360.00,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL),(1960,3705,40729,7915,3,1960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',4800.00,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL),(1961,3705,40729,7915,3,1961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',4805.00,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL),(1962,3705,40729,7915,3,1962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',5965.00,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL),(1963,3705,40729,7915,3,1963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',7670.00,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL),(1964,3705,40729,7915,3,1964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',6509.99,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL),(1965,3705,40729,7915,3,1965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30','2021-01-30',6199.99,NULL,NULL,1,'2021-08-03 12:47:56','2021-08-03 12:47:56',NULL),(1966,3705,40729,7916,2,1966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',9492.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1967,3705,40729,7916,2,1967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',3900.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1968,3705,40729,7916,2,1968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',4680.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1969,3705,40729,7916,2,1969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',2730.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1970,3705,40729,7916,2,1970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',6240.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1971,3705,40729,7916,2,1971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',3510.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1972,3705,40729,7916,2,1972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',7800.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1973,3705,40729,7916,2,1973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',5850.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1974,3705,40729,7916,2,1974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',4290.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1975,3705,40729,7916,2,1975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',1200.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1976,3705,40729,7916,2,1976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7800.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1977,3705,40729,7916,2,1977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',8190.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1978,3705,40729,7916,2,1978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',6800.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1979,3705,40729,7916,2,1979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',1800.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1980,3705,40729,7916,2,1980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',5070.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL);
INSERT INTO `balance_libro` VALUES (1981,3705,40729,7916,2,1981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',6240.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1982,3705,40729,7916,2,1982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',3400.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1983,3705,40729,7916,2,1983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7020.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1984,3705,40729,7916,2,1984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',4680.00,NULL,NULL,1,'2021-08-03 12:51:35','2021-08-03 12:51:35',NULL),(1985,3705,40729,7916,2,1985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',4680.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1986,3705,40729,7916,2,1986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',6630.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1987,3705,40729,7916,2,1987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',7800.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1988,3705,40729,7916,2,1988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',7020.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1989,3705,40729,7916,2,1989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',1200.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1990,3705,40729,7916,2,1990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',5850.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1991,3705,40729,7916,2,1991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',4680.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1992,3705,40729,7916,2,1992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',1950.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1993,3705,40729,7916,2,1993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',5460.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1994,3705,40729,7916,2,1994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',6800.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1995,3705,40729,7916,2,1995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',19050.02,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1996,3705,40729,7916,2,1996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',7800.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1997,3705,40729,7916,2,1997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',3900.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1998,3705,40729,7916,2,1998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',1200.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(1999,3705,40729,7916,2,1999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',3510.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2000,3705,40729,7916,2,2000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',5850.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2001,3705,40729,7916,2,2001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',2730.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2002,3705,40729,7916,2,2002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',6630.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2003,3705,40729,7916,2,2003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',6800.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2004,3705,40729,7916,2,2004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',4680.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL);
INSERT INTO `balance_libro` VALUES (2005,3705,40729,7916,2,2005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',1200.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2006,3705,40729,7916,2,2006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',4680.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2007,3705,40729,7916,2,2007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',3900.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2008,3705,40729,7916,2,2008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',7800.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2009,3705,40729,7916,2,2009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',6800.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2010,3705,40729,7916,2,2010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',5850.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2011,3705,40729,7916,2,2011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',6630.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2012,3705,40729,7916,2,2012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',2340.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2013,3705,40729,7916,2,2013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',7410.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2014,3705,40729,7916,2,2014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',5850.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2015,3705,40729,7916,2,2015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',5460.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2016,3705,40729,7916,2,2016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',4680.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2017,3705,40729,7916,2,2017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',7800.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2018,3705,40729,7916,2,2018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',6800.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2019,3705,40729,7916,2,2019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',5460.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2020,3705,40729,7916,2,2020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',6240.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2021,3705,40729,7916,2,2021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',3900.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2022,3705,40729,7916,2,2022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',3400.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2023,3705,40729,7916,2,2023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',5460.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2024,3705,40729,7916,2,2024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',6630.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2025,3705,40729,7916,2,2025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',2340.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2026,3705,40729,7916,2,2026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',1800.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2027,3705,40729,7916,2,2027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',5070.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2028,3705,40729,7916,2,2028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',5200.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL);
INSERT INTO `balance_libro` VALUES (2029,3705,40729,7916,2,2029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',7410.00,NULL,NULL,1,'2021-08-03 12:51:36','2021-08-03 12:51:36',NULL),(2030,3705,40729,7916,2,2030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',4680.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2031,3705,40729,7916,2,2031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',1200.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2032,3705,40729,7916,2,2032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',5850.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2033,3705,40729,7916,2,2033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',3900.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2034,3705,40729,7916,2,2034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',4290.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2035,3705,40729,7916,2,2035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',8190.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2036,3705,40729,7916,2,2036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',6800.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2037,3705,40729,7916,2,2037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',4680.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2038,3705,40729,7916,2,2038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',7700.02,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2039,3705,40729,7916,2,2039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',6800.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2040,3705,40729,7916,2,2040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7020.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2041,3705,40729,7916,2,2041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',5460.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2042,3705,40729,7916,2,2042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',3900.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2043,3705,40729,7916,2,2043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',1200.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2044,3705,40729,7916,2,2044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',7410.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2045,3705,40729,7916,2,2045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',6630.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2046,3705,40729,7916,2,2046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',1950.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2047,3705,40729,7916,2,2047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',2730.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2048,3705,40729,7916,2,2048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',7410.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2049,3705,40729,7916,2,2049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',6800.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2050,3705,40729,7916,2,2050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',5460.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2051,3705,40729,7916,2,2051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',6240.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2052,3705,40729,7916,2,2052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',3900.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL);
INSERT INTO `balance_libro` VALUES (2053,3705,40729,7916,2,2053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',4680.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2054,3705,40729,7916,2,2054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',6630.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2055,3705,40729,7916,2,2055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',5850.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2056,3705,40729,7916,2,2056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',1200.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2057,3705,40729,7916,2,2057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',6630.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2058,3705,40729,7916,2,2058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',5850.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2059,3705,40729,7916,2,2059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',8190.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2060,3705,40729,7916,2,2060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',6800.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2061,3705,40729,7916,2,2061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',7800.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2062,3705,40729,7916,2,2062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',2730.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2063,3705,40729,7916,2,2063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',4290.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2064,3705,40729,7916,2,2064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',3400.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2065,3705,40729,7916,2,2065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',5460.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2066,3705,40729,7916,2,2066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',6240.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2067,3705,40729,7916,2,2067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',8580.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2068,3705,40729,7916,2,2068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',6630.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2069,3705,40729,7916,2,2069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',5850.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2070,3705,40729,7916,2,2070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',7800.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2071,3705,40729,7916,2,2071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',2340.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2072,3705,40729,7916,2,2072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',7800.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2073,3705,40729,7916,2,2073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',6630.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2074,3705,40729,7916,2,2074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',4680.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2075,3705,40729,7916,2,2075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',6240.00,NULL,NULL,1,'2021-08-03 12:51:37','2021-08-03 12:51:37',NULL),(2076,3705,40729,7916,2,2076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',1200.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL);
INSERT INTO `balance_libro` VALUES (2077,3705,40729,7916,2,2077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',5850.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2078,3705,40729,7916,2,2078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',3400.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2079,3705,40729,7916,2,2079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',3900.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2080,3705,40729,7916,2,2080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',6240.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2081,3705,40729,7916,2,2081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',6800.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2082,3705,40729,7916,2,2082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',5070.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2083,3705,40729,7916,2,2083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',6240.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2084,3705,40729,7916,2,2084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',3400.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2085,3705,40729,7916,2,2085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',4680.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2086,3705,40729,7916,2,2086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',2340.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2087,3705,40729,7916,2,2087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',6800.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2088,3705,40729,7916,2,2088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',7800.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2089,3705,40729,7916,2,2089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',8580.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2090,3705,40729,7916,2,2090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',3510.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2091,3705,40729,7916,2,2091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',5850.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2092,3705,40729,7916,2,2092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',5850.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2093,3705,40729,7916,2,2093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',5850.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2094,3705,40729,7916,2,2094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',7020.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2095,3705,40729,7916,2,2095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',1200.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2096,3705,40729,7916,2,2096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',3120.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2097,3705,40729,7916,2,2097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',7410.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2098,3705,40729,7916,2,2098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',6240.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2099,3705,40729,7916,2,2099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',6800.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2100,3705,40729,7916,2,2100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',5460.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL);
INSERT INTO `balance_libro` VALUES (2101,3705,40729,7916,2,2101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',5850.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2102,3705,40729,7916,2,2102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',7410.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2103,3705,40729,7916,2,2103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',8580.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2104,3705,40729,7916,2,2104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',7800.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2105,3705,40729,7916,2,2105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',3900.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2106,3705,40729,7916,2,2106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',6800.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2107,3705,40729,7916,2,2107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',3510.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2108,3705,40729,7916,2,2108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',1200.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2109,3705,40729,7916,2,2109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',5460.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2110,3705,40729,7916,2,2110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',7410.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2111,3705,40729,7916,2,2111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',8190.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2112,3705,40729,7916,2,2112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',3400.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2113,3705,40729,7916,2,2113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',6630.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2114,3705,40729,7916,2,2114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',6800.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2115,3705,40729,7916,2,2115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',3510.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2116,3705,40729,7916,2,2116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',5070.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2117,3705,40729,7916,2,2117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',2730.00,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2118,3705,40729,7916,2,2118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',7700.02,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2119,3705,40729,7916,2,2119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',7700.02,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2120,3705,40729,7916,2,2120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',3850.01,NULL,NULL,1,'2021-08-03 12:51:38','2021-08-03 12:51:38',NULL),(2121,3705,40729,7916,2,2121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',7700.02,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2122,3705,40729,7916,2,2122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',7800.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2123,3705,40729,7916,2,2123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',6800.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2124,3705,40729,7916,2,2124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',8580.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL);
INSERT INTO `balance_libro` VALUES (2125,3705,40729,7916,2,2125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',4290.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2126,3705,40729,7916,2,2126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',2730.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2127,3705,40729,7916,2,2127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',5850.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2128,3705,40729,7916,2,2128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',6240.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2129,3705,40729,7916,2,2129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',4680.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2130,3705,40729,7916,2,2130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',1800.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2131,3705,40729,7916,2,2131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',2730.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2132,3705,40729,7916,2,2132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',6600.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2133,3705,40729,7916,2,2133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',8190.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2134,3705,40729,7916,2,2134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',3900.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2135,3705,40729,7916,2,2135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',5070.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2136,3705,40729,7916,2,2136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',6240.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2137,3705,40729,7916,2,2137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',5460.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2138,3705,40729,7916,2,2138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',7410.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2139,3705,40729,7916,2,2139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',6800.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2140,3705,40729,7916,2,2140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',2730.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2141,3705,40729,7916,2,2141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',8580.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2142,3705,40729,7916,2,2142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',6630.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2143,3705,40729,7916,2,2143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',5850.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2144,3705,40729,7916,2,2144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',7800.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2145,3705,40729,7916,2,2145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',6240.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2146,3705,40729,7916,2,2146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',3900.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2147,3705,40729,7916,2,2147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',2400.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2148,3705,40729,7916,2,2148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',8580.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL);
INSERT INTO `balance_libro` VALUES (2149,3705,40729,7916,2,2149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',7800.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2150,3705,40729,7916,2,2150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',6800.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2151,3705,40729,7916,2,2151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1800.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2152,3705,40729,7916,2,2152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3510.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2153,3705,40729,7916,2,2153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',5850.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2154,3705,40729,7916,2,2154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',6630.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2155,3705,40729,7916,2,2155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',5460.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2156,3705,40729,7916,2,2156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',1800.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2157,3705,40729,7916,2,2157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',6240.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2158,3705,40729,7916,2,2158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',4290.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2159,3705,40729,7916,2,2159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',7800.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2160,3705,40729,7916,2,2160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',8580.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2161,3705,40729,7916,2,2161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',7410.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2162,3705,40729,7916,2,2162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',3400.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2163,3705,40729,7916,2,2163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',6630.00,NULL,NULL,1,'2021-08-03 12:51:39','2021-08-03 12:51:39',NULL),(2164,3705,40729,7916,2,2164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',1560.00,NULL,NULL,1,'2021-08-03 12:51:40','2021-08-03 12:51:40',NULL),(2165,3705,40729,7916,3,2165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',5589.99,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2166,3705,40729,7916,3,2166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',7759.99,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2167,3705,40729,7916,3,2167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',2800.00,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2168,3705,40729,7916,3,2168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',7130.00,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2169,3705,40729,7916,3,2169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',11779.98,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2170,3705,40729,7916,3,2170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',2790.00,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2171,3705,40729,7916,3,2171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',9299.99,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2172,3705,40729,7916,3,2172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',11944.99,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL);
INSERT INTO `balance_libro` VALUES (2173,3705,40729,7916,3,2173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7130.00,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2174,3705,40729,7916,3,2174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',2800.00,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2175,3705,40729,7916,3,2175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7139.99,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2176,3705,40729,7916,3,2176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',2800.00,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2177,3705,40729,7916,3,2177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',13349.99,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2178,3705,40729,7916,3,2178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',7130.00,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2179,3705,40729,7916,3,2179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',8844.98,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2180,3705,40729,7916,3,2180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3255.00,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2181,3705,40729,7916,3,2181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',8679.99,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2182,3705,40729,7916,3,2182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',1239.00,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2183,3705,40729,7916,3,2183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',14434.99,NULL,NULL,1,'2021-08-03 12:53:37','2021-08-03 12:53:37',NULL),(2184,3705,40729,7916,3,2184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',3100.00,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2185,3705,40729,7916,3,2185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',9299.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2186,3705,40729,7916,3,2186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',4340.00,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2187,3705,40729,7916,3,2187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',8379.98,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2188,3705,40729,7916,3,2188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',6364.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2189,3705,40729,7916,3,2189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',6820.00,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2190,3705,40729,7916,3,2190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',6820.00,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2191,3705,40729,7916,3,2191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',15519.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2192,3705,40729,7916,3,2192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',15519.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2193,3705,40729,7916,3,2193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',930.00,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2194,3705,40729,7916,3,2194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',14124.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2195,3705,40729,7916,3,2195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',7594.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2196,3705,40729,7916,3,2196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',5744.98,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL);
INSERT INTO `balance_libro` VALUES (2197,3705,40729,7916,3,2197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',4040.00,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2198,3705,40729,7916,3,2198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',9929.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2199,3705,40729,7916,3,2199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',8999.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2200,3705,40729,7916,3,2200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',5114.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2201,3705,40729,7916,3,2201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',4340.00,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2202,3705,40729,7916,3,2202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',11634.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2203,3705,40729,7916,3,2203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',6509.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2204,3705,40729,7916,3,2204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',9299.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2205,3705,40729,7916,3,2205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',3100.00,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2206,3705,40729,7916,3,2206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',8989.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2207,3705,40729,7916,3,2207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',11324.98,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2208,3705,40729,7916,3,2208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',5589.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2209,3705,40729,7916,3,2209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',6509.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2210,3705,40729,7916,3,2210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',6275.00,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2211,3705,40729,7916,3,2211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',6509.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2212,3705,40729,7916,3,2212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',13659.99,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2213,3705,40729,7916,3,2213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',8525.00,NULL,NULL,1,'2021-08-03 12:53:38','2021-08-03 12:53:38',NULL),(2214,3705,40729,7916,3,2214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',8999.99,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2215,3705,40729,7916,3,2215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',0.00,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2216,3705,40729,7916,3,2216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',9299.99,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2217,3705,40729,7916,3,2217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',13349.99,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2218,3705,40729,7916,3,2218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',5899.99,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2219,3705,40729,7916,3,2219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',5579.99,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2220,3705,40729,7916,3,2220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',4805.00,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL);
INSERT INTO `balance_libro` VALUES (2221,3705,40729,7916,3,2221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',6929.99,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2222,3705,40729,7916,3,2222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',5270.00,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2223,3705,40729,7916,3,2223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',9929.99,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2224,3705,40729,7916,3,2224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',2944.99,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2225,3705,40729,7916,3,2225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',9299.99,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2226,3705,40729,7916,3,2226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',13970.00,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2227,3705,40729,7916,3,2227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',11479.98,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2228,3705,40729,7916,3,2228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',3720.00,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2229,3705,40729,7916,3,2229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',6664.99,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2230,3705,40729,7916,3,2230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',7285.00,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2231,3705,40729,7916,3,2231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',8999.99,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2232,3705,40729,7916,3,2232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',9299.99,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2233,3705,40729,7916,3,2233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',9309.99,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2234,3705,40729,7916,3,2234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-16','2021-02-16',7440.00,NULL,NULL,1,'2021-08-03 12:53:39','2021-08-03 12:53:39',NULL),(2235,3705,40729,7916,3,2235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-16','2021-02-16',6665.00,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2236,3705,40729,7916,3,2236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',8999.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2237,3705,40729,7916,3,2237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',9299.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2238,3705,40729,7916,3,2238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',9299.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2239,3705,40729,7916,3,2239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',5269.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2240,3705,40729,7916,3,2240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',6354.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2241,3705,40729,7916,3,2241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',17600.00,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2242,3705,40729,7916,3,2242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',5579.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2243,3705,40729,7916,3,2243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',1324.50,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2244,3705,40729,7916,3,2244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',7760.00,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL);
INSERT INTO `balance_libro` VALUES (2245,3705,40729,7916,3,2245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',7904.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2246,3705,40729,7916,3,2246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',5890.00,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2247,3705,40729,7916,3,2247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',6209.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2248,3705,40729,7916,3,2248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',3564.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2249,3705,40729,7916,3,2249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',9299.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2250,3705,40729,7916,3,2250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',2280.00,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2251,3705,40729,7916,3,2251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',9299.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2252,3705,40729,7916,3,2252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-20','2021-02-20',9309.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2253,3705,40729,7916,3,2253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',5899.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2254,3705,40729,7916,3,2254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',9299.99,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2255,3705,40729,7916,3,2255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',11800.00,NULL,NULL,1,'2021-08-03 12:53:40','2021-08-03 12:53:40',NULL),(2256,3705,40729,7916,3,2256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',9309.99,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2257,3705,40729,7916,3,2257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',9309.99,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2258,3705,40729,7916,3,2258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',4959.99,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2259,3705,40729,7916,3,2259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',12399.99,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2260,3705,40729,7916,3,2260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',14280.00,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2261,3705,40729,7916,3,2261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',9299.99,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2262,3705,40729,7916,3,2262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',8070.00,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2263,3705,40729,7916,3,2263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',6820.00,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2264,3705,40729,7916,3,2264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',3410.00,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2265,3705,40729,7916,3,2265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',9299.99,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2266,3705,40729,7916,3,2266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',7139.99,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2267,3705,40729,7916,3,2267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',9929.99,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2268,3705,40729,7916,3,2268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',3874.99,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL);
INSERT INTO `balance_libro` VALUES (2269,3705,40729,7916,3,2269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',2800.00,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2270,3705,40729,7916,3,2270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',9299.99,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2271,3705,40729,7916,3,2271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',25500.00,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2272,3705,40729,7916,3,2272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',5899.99,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2273,3705,40729,7916,3,2273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',11334.99,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2274,3705,40729,7916,3,2274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',10367.98,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2275,3705,40729,7916,3,2275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',8214.99,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2276,3705,40729,7916,3,2276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',3100.00,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2277,3705,40729,7916,3,2277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',7440.00,NULL,NULL,1,'2021-08-03 12:53:41','2021-08-03 12:53:41',NULL),(2278,3705,40729,7916,3,2278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',3720.00,NULL,NULL,1,'2021-08-03 12:53:42','2021-08-03 12:53:42',NULL),(2279,3705,40729,7916,3,2279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',9299.99,NULL,NULL,1,'2021-08-03 12:53:42','2021-08-03 12:53:42',NULL),(2280,3705,40729,7916,3,2280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',4340.00,NULL,NULL,1,'2021-08-03 12:53:42','2021-08-03 12:53:42',NULL),(2281,3705,40729,7916,3,2281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',4030.00,NULL,NULL,1,'2021-08-03 12:53:42','2021-08-03 12:53:42',NULL),(2282,3705,40729,7916,3,2282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',5425.00,NULL,NULL,1,'2021-08-03 12:53:42','2021-08-03 12:53:42',NULL),(2283,3705,40729,7916,3,2283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-27','2021-02-27',8999.99,NULL,NULL,1,'2021-08-03 12:53:42','2021-08-03 12:53:42',NULL),(2284,3705,40729,7917,2,2284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',6800.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2285,3705,40729,7917,2,2285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',8580.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2286,3705,40729,7917,2,2286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',6240.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2287,3705,40729,7917,2,2287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1800.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2288,3705,40729,7917,2,2288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',5460.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2289,3705,40729,7917,2,2289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3900.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2290,3705,40729,7917,2,2290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',4290.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2291,3705,40729,7917,2,2291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',5070.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2292,3705,40729,7917,2,2292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1200.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL);
INSERT INTO `balance_libro` VALUES (2293,3705,40729,7917,2,2293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1560.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2294,3705,40729,7917,2,2294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',4290.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2295,3705,40729,7917,2,2295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1800.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2296,3705,40729,7917,2,2296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',5850.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2297,3705,40729,7917,2,2297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',4680.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2298,3705,40729,7917,2,2298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',8580.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2299,3705,40729,7917,2,2299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',5460.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2300,3705,40729,7917,2,2300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',6800.00,NULL,NULL,1,'2021-08-03 12:55:18','2021-08-03 12:55:18',NULL),(2301,3705,40729,7917,2,2301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1200.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2302,3705,40729,7917,2,2302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',6630.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2303,3705,40729,7917,2,2303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',4680.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2304,3705,40729,7917,2,2304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',2730.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2305,3705,40729,7917,2,2305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',3900.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2306,3705,40729,7917,2,2306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1800.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2307,3705,40729,7917,2,2307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',3900.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2308,3705,40729,7917,2,2308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',5460.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2309,3705,40729,7917,2,2309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',2730.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2310,3705,40729,7917,2,2310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1200.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2311,3705,40729,7917,2,2311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',6630.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2312,3705,40729,7917,2,2312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',3700.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2313,3705,40729,7917,2,2313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',5070.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2314,3705,40729,7917,2,2314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',3900.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2315,3705,40729,7917,2,2315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',1800.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2316,3705,40729,7917,2,2316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',3510.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL);
INSERT INTO `balance_libro` VALUES (2317,3705,40729,7917,2,2317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1200.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2318,3705,40729,7917,2,2318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',6240.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2319,3705,40729,7917,2,2319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',7800.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2320,3705,40729,7917,2,2320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',5850.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2321,3705,40729,7917,2,2321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',3900.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2322,3705,40729,7917,2,2322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',5070.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2323,3705,40729,7917,2,2323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1800.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2324,3705,40729,7917,2,2324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',1950.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2325,3705,40729,7917,2,2325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',4290.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2326,3705,40729,7917,2,2326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',8580.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2327,3705,40729,7917,2,2327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',6630.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2328,3705,40729,7917,2,2328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',7400.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2329,3705,40729,7917,2,2329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',4290.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2330,3705,40729,7917,2,2330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',2730.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2331,3705,40729,7917,2,2331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',7410.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2332,3705,40729,7917,2,2332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',5850.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2333,3705,40729,7917,2,2333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1200.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2334,3705,40729,7917,2,2334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',3700.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2335,3705,40729,7917,2,2335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',3510.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2336,3705,40729,7917,2,2336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',1800.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2337,3705,40729,7917,2,2337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',1800.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2338,3705,40729,7917,2,2338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',6240.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2339,3705,40729,7917,2,2339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',3510.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2340,3705,40729,7917,2,2340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',5070.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL);
INSERT INTO `balance_libro` VALUES (2341,3705,40729,7917,2,2341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',7400.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2342,3705,40729,7917,2,2342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',7800.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2343,3705,40729,7917,2,2343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',4680.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2344,3705,40729,7917,2,2344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',5460.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2345,3705,40729,7917,2,2345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',2340.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2346,3705,40729,7917,2,2346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',6240.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2347,3705,40729,7917,2,2347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',3120.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2348,3705,40729,7917,2,2348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',5070.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2349,3705,40729,7917,2,2349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',2730.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2350,3705,40729,7917,2,2350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',7400.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2351,3705,40729,7917,2,2351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',7410.00,NULL,NULL,1,'2021-08-03 12:55:19','2021-08-03 12:55:19',NULL),(2352,3705,40729,7917,2,2352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',3700.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2353,3705,40729,7917,2,2353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',3900.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2354,3705,40729,7917,2,2354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',2730.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2355,3705,40729,7917,2,2355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',8500.01,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2356,3705,40729,7917,2,2356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',8500.01,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2357,3705,40729,7917,2,2357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',4290.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2358,3705,40729,7917,2,2358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',7400.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2359,3705,40729,7917,2,2359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',7800.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2360,3705,40729,7917,2,2360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',5460.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2361,3705,40729,7917,2,2361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1800.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2362,3705,40729,7917,2,2362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',6630.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2363,3705,40729,7917,2,2363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',1170.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2364,3705,40729,7917,2,2364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',5850.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL);
INSERT INTO `balance_libro` VALUES (2365,3705,40729,7917,2,2365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1200.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2366,3705,40729,7917,2,2366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',4290.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2367,3705,40729,7917,2,2367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',3900.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2368,3705,40729,7917,2,2368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',2340.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2369,3705,40729,7917,2,2369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',5850.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2370,3705,40729,7917,2,2370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',6630.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2371,3705,40729,7917,2,2371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',7410.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2372,3705,40729,7917,2,2372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',7400.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2373,3705,40729,7917,2,2373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',4680.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2374,3705,40729,7917,2,2374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1200.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2375,3705,40729,7917,2,2375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',5850.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2376,3705,40729,7917,2,2376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',5850.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2377,3705,40729,7917,2,2377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',3700.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2378,3705,40729,7917,2,2378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',3900.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2379,3705,40729,7917,2,2379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',6630.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2380,3705,40729,7917,2,2380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1560.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2381,3705,40729,7917,2,2381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',7410.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2382,3705,40729,7917,2,2382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',7400.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2383,3705,40729,7917,2,2383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',8500.01,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2384,3705,40729,7917,2,2384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',4680.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2385,3705,40729,7917,2,2385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',3900.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2386,3705,40729,7917,2,2386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',6630.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2387,3705,40729,7917,2,2387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',7800.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2388,3705,40729,7917,2,2388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',7400.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL);
INSERT INTO `balance_libro` VALUES (2389,3705,40729,7917,2,2389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',4290.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2390,3705,40729,7917,2,2390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1200.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2391,3705,40729,7917,2,2391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',4290.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2392,3705,40729,7917,2,2392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',5850.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2393,3705,40729,7917,2,2393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',7020.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2394,3705,40729,7917,2,2394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',6240.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2395,3705,40729,7917,2,2395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',3700.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2396,3705,40729,7917,2,2396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',4680.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2397,3705,40729,7917,2,2397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',3700.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2398,3705,40729,7917,2,2398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',5070.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2399,3705,40729,7917,2,2399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',1800.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2400,3705,40729,7917,2,2400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',5850.00,NULL,NULL,1,'2021-08-03 12:55:20','2021-08-03 12:55:20',NULL),(2401,3705,40729,7917,2,2401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',8580.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2402,3705,40729,7917,2,2402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',7400.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2403,3705,40729,7917,2,2403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',4290.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2404,3705,40729,7917,2,2404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',4680.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2405,3705,40729,7917,2,2405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',7020.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2406,3705,40729,7917,2,2406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',3120.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2407,3705,40729,7917,2,2407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',5460.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2408,3705,40729,7917,2,2408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',3900.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2409,3705,40729,7917,2,2409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',2730.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2410,3705,40729,7917,2,2410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',5700.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2411,3705,40729,7917,2,2411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',8580.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2412,3705,40729,7917,2,2412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',6630.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL);
INSERT INTO `balance_libro` VALUES (2413,3705,40729,7917,2,2413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',5460.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2414,3705,40729,7917,2,2414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',3900.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2415,3705,40729,7917,2,2415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',6630.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2416,3705,40729,7917,2,2416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',3900.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2417,3705,40729,7917,2,2417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',7800.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2418,3705,40729,7917,2,2418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',8190.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2419,3705,40729,7917,2,2419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',5070.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2420,3705,40729,7917,2,2420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',6240.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2421,3705,40729,7917,2,2421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',6630.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2422,3705,40729,7917,2,2422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',7800.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2423,3705,40729,7917,2,2423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',3700.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2424,3705,40729,7917,2,2424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',4680.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2425,3705,40729,7917,2,2425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',5850.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2426,3705,40729,7917,2,2426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1200.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2427,3705,40729,7917,2,2427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',8580.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2428,3705,40729,7917,2,2428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',5460.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2429,3705,40729,7917,2,2429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',7020.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2430,3705,40729,7917,2,2430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',5070.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2431,3705,40729,7917,2,2431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',3700.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2432,3705,40729,7917,2,2432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',5850.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2433,3705,40729,7917,2,2433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',5460.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2434,3705,40729,7917,2,2434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1800.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2435,3705,40729,7917,2,2435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',6630.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2436,3705,40729,7917,2,2436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1200.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL);
INSERT INTO `balance_libro` VALUES (2437,3705,40729,7917,2,2437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',6630.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2438,3705,40729,7917,2,2438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',8580.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2439,3705,40729,7917,2,2439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1950.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2440,3705,40729,7917,2,2440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',7800.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2441,3705,40729,7917,2,2441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',6240.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2442,3705,40729,7917,2,2442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',8190.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2443,3705,40729,7917,2,2443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',7400.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2444,3705,40729,7917,2,2444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',7410.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2445,3705,40729,7917,2,2445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',4680.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2446,3705,40729,7917,2,2446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',5850.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2447,3705,40729,7917,2,2447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',3510.00,NULL,NULL,1,'2021-08-03 12:55:21','2021-08-03 12:55:21',NULL),(2448,3705,40729,7917,2,2448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',6630.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2449,3705,40729,7917,2,2449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',4290.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2450,3705,40729,7917,2,2450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',5070.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2451,3705,40729,7917,2,2451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1170.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2452,3705,40729,7917,2,2452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',7800.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2453,3705,40729,7917,2,2453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',6630.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2454,3705,40729,7917,2,2454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',4680.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2455,3705,40729,7917,2,2455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',3510.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2456,3705,40729,7917,2,2456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',5850.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2457,3705,40729,7917,2,2457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1200.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2458,3705,40729,7917,2,2458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',8190.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2459,3705,40729,7917,2,2459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',7400.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2460,3705,40729,7917,2,2460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',5850.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL);
INSERT INTO `balance_libro` VALUES (2461,3705,40729,7917,2,2461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',5070.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2462,3705,40729,7917,2,2462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',4680.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2463,3705,40729,7917,2,2463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',7020.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2464,3705,40729,7917,2,2464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',4680.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2465,3705,40729,7917,2,2465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',8580.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2466,3705,40729,7917,2,2466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',3700.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2467,3705,40729,7917,2,2467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1200.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2468,3705,40729,7917,2,2468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',5850.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2469,3705,40729,7917,2,2469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',6240.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2470,3705,40729,7917,2,2470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',1200.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2471,3705,40729,7917,2,2471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',7800.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2472,3705,40729,7917,2,2472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',8190.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2473,3705,40729,7917,2,2473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',7400.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2474,3705,40729,7917,2,2474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',4680.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2475,3705,40729,7917,2,2475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',3120.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2476,3705,40729,7917,2,2476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',3900.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2477,3705,40729,7917,2,2477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',5070.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2478,3705,40729,7917,2,2478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',1170.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2479,3705,40729,7917,2,2479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',7800.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2480,3705,40729,7917,2,2480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',6240.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2481,3705,40729,7917,2,2481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',7410.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2482,3705,40729,7917,2,2482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',3900.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2483,3705,40729,7917,2,2483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',8580.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2484,3705,40729,7917,2,2484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',8190.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL);
INSERT INTO `balance_libro` VALUES (2485,3705,40729,7917,2,2485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',7400.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2486,3705,40729,7917,2,2486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',6240.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2487,3705,40729,7917,2,2487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',4680.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2488,3705,40729,7917,2,2488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',7020.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2489,3705,40729,7917,2,2489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',3700.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2490,3705,40729,7917,2,2490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',4290.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2491,3705,40729,7917,2,2491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',1200.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2492,3705,40729,7917,2,2492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',3900.00,NULL,NULL,1,'2021-08-03 12:55:22','2021-08-03 12:55:22',NULL),(2493,3705,40729,7917,2,2493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',3120.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2494,3705,40729,7917,2,2494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',3120.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2495,3705,40729,7917,2,2495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',7400.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2496,3705,40729,7917,2,2496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1950.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2497,3705,40729,7917,2,2497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',3510.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2498,3705,40729,7917,2,2498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',6240.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2499,3705,40729,7917,2,2499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1200.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2500,3705,40729,7917,2,2500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',7410.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2501,3705,40729,7917,2,2501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',8580.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2502,3705,40729,7917,2,2502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',4680.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2503,3705,40729,7917,2,2503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',3120.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2504,3705,40729,7917,2,2504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',6630.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2505,3705,40729,7917,2,2505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',1170.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2506,3705,40729,7917,2,2506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3900.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2507,3705,40729,7917,2,2507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',7410.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2508,3705,40729,7917,2,2508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',7400.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL);
INSERT INTO `balance_libro` VALUES (2509,3705,40729,7917,2,2509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',8580.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2510,3705,40729,7917,2,2510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',7020.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2511,3705,40729,7917,2,2511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',1200.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2512,3705,40729,7917,2,2512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',5460.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2513,3705,40729,7917,2,2513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',4680.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2514,3705,40729,7917,2,2514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3120.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2515,3705,40729,7917,2,2515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3700.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2516,3705,40729,7917,2,2516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',6240.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2517,3705,40729,7917,2,2517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',4290.00,NULL,NULL,1,'2021-08-03 12:55:23','2021-08-03 12:55:23',NULL),(2518,3705,40729,7917,3,2518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',12420.00,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2519,3705,40729,7917,3,2519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',8369.99,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2520,3705,40729,7917,3,2520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',3720.00,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2521,3705,40729,7917,3,2521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',6664.99,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2522,3705,40729,7917,3,2522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',15220.00,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2523,3705,40729,7917,3,2523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',9299.99,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2524,3705,40729,7917,3,2524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',24229.99,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2525,3705,40729,7917,3,2525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',9929.99,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2526,3705,40729,7917,3,2526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',165.30,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2527,3705,40729,7917,3,2527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',6199.99,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2528,3705,40729,7917,3,2528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',852.00,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2529,3705,40729,7917,3,2529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',7235.01,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2530,3705,40729,7917,3,2530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',8369.99,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2531,3705,40729,7917,3,2531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',3720.00,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2532,3705,40729,7917,3,2532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',8680.00,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL);
INSERT INTO `balance_libro` VALUES (2533,3705,40729,7917,3,2533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',10230.01,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2534,3705,40729,7917,3,2534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',7750.00,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2535,3705,40729,7917,3,2535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',7440.01,NULL,NULL,1,'2021-08-03 12:56:23','2021-08-03 12:56:23',NULL),(2536,3705,40729,7917,3,2536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',11780.01,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2537,3705,40729,7917,3,2537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',14880.00,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2538,3705,40729,7917,3,2538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',11780.01,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2539,3705,40729,7917,3,2539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',8989.99,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2540,3705,40729,7917,3,2540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',3874.99,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2541,3705,40729,7917,3,2541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',6820.00,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2542,3705,40729,7917,3,2542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-06','2021-03-06',6509.99,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2543,3705,40729,7917,3,2543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',3874.99,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2544,3705,40729,7917,3,2544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',17670.01,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2545,3705,40729,7917,3,2545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',5269.99,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2546,3705,40729,7917,3,2546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',6820.00,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2547,3705,40729,7917,3,2547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',6044.99,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2548,3705,40729,7917,3,2548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',8990.01,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2549,3705,40729,7917,3,2549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',6354.99,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2550,3705,40729,7917,3,2550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',6924.99,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2551,3705,40729,7917,3,2551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',6975.00,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2552,3705,40729,7917,3,2552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',10384.98,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2553,3705,40729,7917,3,2553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',358.63,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2554,3705,40729,7917,3,2554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',6200.01,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2555,3705,40729,7917,3,2555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',9299.99,NULL,NULL,1,'2021-08-03 12:56:24','2021-08-03 12:56:24',NULL),(2556,3705,40729,7917,3,2556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',6510.00,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL);
INSERT INTO `balance_libro` VALUES (2557,3705,40729,7917,3,2557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',14880.00,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2558,3705,40729,7917,3,2558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',14260.01,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2559,3705,40729,7917,3,2559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',8989.99,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2560,3705,40729,7917,3,2560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',6200.01,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2561,3705,40729,7917,3,2561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',8679.99,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2562,3705,40729,7917,3,2562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2944.99,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2563,3705,40729,7917,3,2563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',11160.01,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2564,3705,40729,7917,3,2564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',7285.00,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2565,3705,40729,7917,3,2565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',17515.00,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2566,3705,40729,7917,3,2566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',9299.99,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2567,3705,40729,7917,3,2567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',4289.99,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2568,3705,40729,7917,3,2568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',7594.99,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2569,3705,40729,7917,3,2569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',5579.99,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2570,3705,40729,7917,3,2570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',7130.00,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2571,3705,40729,7917,3,2571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',7130.00,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2572,3705,40729,7917,3,2572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',7750.01,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2573,3705,40729,7917,3,2573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',8679.99,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2574,3705,40729,7917,3,2574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',9920.01,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2575,3705,40729,7917,3,2575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',7594.99,NULL,NULL,1,'2021-08-03 12:56:25','2021-08-03 12:56:25',NULL),(2576,3705,40729,7917,3,2576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',13950.00,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2577,3705,40729,7917,3,2577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',6200.01,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2578,3705,40729,7917,3,2578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',9299.99,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2579,3705,40729,7917,3,2579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',7130.00,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2580,3705,40729,7917,3,2580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',9920.01,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL);
INSERT INTO `balance_libro` VALUES (2581,3705,40729,7917,3,2581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',3100.00,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2582,3705,40729,7917,3,2582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',2324.99,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2583,3705,40729,7917,3,2583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',8680.00,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2584,3705,40729,7917,3,2584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',12399.99,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2585,3705,40729,7917,3,2585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',5269.99,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2586,3705,40729,7917,3,2586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',7440.00,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2587,3705,40729,7917,3,2587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',8679.99,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2588,3705,40729,7917,3,2588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',2790.00,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2589,3705,40729,7917,3,2589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',5269.99,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2590,3705,40729,7917,3,2590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',6199.99,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2591,3705,40729,7917,3,2591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',6509.99,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2592,3705,40729,7917,3,2592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',6825.00,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2593,3705,40729,7917,3,2593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4495.00,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2594,3705,40729,7917,3,2594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4185.00,NULL,NULL,1,'2021-08-03 12:56:26','2021-08-03 12:56:26',NULL),(2595,3705,40729,7917,3,2595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',8989.99,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2596,3705,40729,7917,3,2596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1860.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2597,3705,40729,7917,3,2597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4495.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2598,3705,40729,7917,3,2598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4185.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2599,3705,40729,7917,3,2599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',3410.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2600,3705,40729,7917,3,2600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4185.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2601,3705,40729,7917,3,2601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1410.75,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2602,3705,40729,7917,3,2602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',300.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2603,3705,40729,7917,3,2603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',25334.30,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2604,3705,40729,7917,3,2604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',13795.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL);
INSERT INTO `balance_libro` VALUES (2605,3705,40729,7917,3,2605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',12400.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2606,3705,40729,7917,3,2606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',6820.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2607,3705,40729,7917,3,2607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',3564.99,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2608,3705,40729,7917,3,2608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',10645.01,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2609,3705,40729,7917,3,2609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',2064.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2610,3705,40729,7917,3,2610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',9299.99,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2611,3705,40729,7917,3,2611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',5580.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2612,3705,40729,7917,3,2612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',9920.01,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2613,3705,40729,7917,3,2613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',4340.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2614,3705,40729,7917,3,2614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',3100.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2615,3705,40729,7917,3,2615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',7820.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2616,3705,40729,7917,3,2616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',8059.99,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2617,3705,40729,7917,3,2617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',11780.01,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2618,3705,40729,7917,3,2618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',5579.99,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2619,3705,40729,7917,3,2619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',4030.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2620,3705,40729,7917,3,2620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',4185.00,NULL,NULL,1,'2021-08-03 12:56:27','2021-08-03 12:56:27',NULL),(2621,3705,40729,7917,3,2621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',3410.00,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2622,3705,40729,7917,3,2622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',5580.00,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2623,3705,40729,7917,3,2623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',8835.00,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2624,3705,40729,7917,3,2624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',9765.00,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2625,3705,40729,7917,3,2625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',7285.00,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2626,3705,40729,7917,3,2626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',1082.00,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2627,3705,40729,7917,3,2627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1788.41,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2628,3705,40729,7917,3,2628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',4185.00,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL);
INSERT INTO `balance_libro` VALUES (2629,3705,40729,7917,3,2629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',4340.01,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2630,3705,40729,7917,3,2630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',6199.99,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2631,3705,40729,7917,3,2631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',2634.99,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2632,3705,40729,7917,3,2632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1860.00,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2633,3705,40729,7917,3,2633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',9299.99,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2634,3705,40729,7917,3,2634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',2479.99,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2635,3705,40729,7917,3,2635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',2479.99,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2636,3705,40729,7917,3,2636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',6509.99,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2637,3705,40729,7917,3,2637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',4185.00,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2638,3705,40729,7917,3,2638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',6664.99,NULL,NULL,1,'2021-08-03 12:56:28','2021-08-03 12:56:28',NULL),(2639,3705,40729,7917,3,2639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',6509.99,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2640,3705,40729,7917,3,2640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',5890.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2641,3705,40729,7917,3,2641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',4185.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2642,3705,40729,7917,3,2642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',7285.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2643,3705,40729,7917,3,2643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',5579.99,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2644,3705,40729,7917,3,2644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',3100.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2645,3705,40729,7917,3,2645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',4030.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2646,3705,40729,7917,3,2646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',4030.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2647,3705,40729,7917,3,2647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',4340.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2648,3705,40729,7917,3,2648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',4030.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2649,3705,40729,7917,3,2649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',7594.99,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2650,3705,40729,7917,3,2650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',3100.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2651,3705,40729,7917,3,2651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',6200.01,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2652,3705,40729,7917,3,2652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',6509.99,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL);
INSERT INTO `balance_libro` VALUES (2653,3705,40729,7917,3,2653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',3720.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2654,3705,40729,7917,3,2654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',7130.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2655,3705,40729,7917,3,2655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',4030.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2656,3705,40729,7917,3,2656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',8989.99,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2657,3705,40729,7917,3,2657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',16430.01,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2658,3705,40729,7917,3,2658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',8060.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2659,3705,40729,7917,3,2659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',4030.00,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2660,3705,40729,7917,3,2660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',10385.01,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2661,3705,40729,7917,3,2661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',3874.99,NULL,NULL,1,'2021-08-03 12:56:29','2021-08-03 12:56:29',NULL),(2662,3705,40729,7917,3,2662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',5579.99,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2663,3705,40729,7917,3,2663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',7749.99,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2664,3705,40729,7917,3,2664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',6510.00,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2665,3705,40729,7917,3,2665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',3205.00,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2666,3705,40729,7917,3,2666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',6044.99,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2667,3705,40729,7917,3,2667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',5269.99,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2668,3705,40729,7917,3,2668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',15500.01,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2669,3705,40729,7917,3,2669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',8679.99,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2670,3705,40729,7917,3,2670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',6509.99,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2671,3705,40729,7917,3,2671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',4960.00,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2672,3705,40729,7917,3,2672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',10075.00,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2673,3705,40729,7917,3,2673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',8989.99,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2674,3705,40729,7917,3,2674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',11160.01,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2675,3705,40729,7917,3,2675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',6354.99,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2676,3705,40729,7917,3,2676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',8060.00,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL);
INSERT INTO `balance_libro` VALUES (2677,3705,40729,7917,3,2677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',4030.00,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2678,3705,40729,7917,3,2678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',7545.01,NULL,NULL,1,'2021-08-03 12:56:30','2021-08-03 12:56:30',NULL),(2679,3705,40729,7917,3,2679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3255.00,NULL,NULL,1,'2021-08-03 12:56:31','2021-08-03 12:56:31',NULL),(2680,3705,40729,7917,3,2680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3720.00,NULL,NULL,1,'2021-08-03 12:56:31','2021-08-03 12:56:31',NULL),(2681,3705,40729,7917,3,2681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',14415.00,NULL,NULL,1,'2021-08-03 12:56:31','2021-08-03 12:56:31',NULL),(2682,3705,40729,7917,3,2682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',5114.99,NULL,NULL,1,'2021-08-03 12:56:31','2021-08-03 12:56:31',NULL),(2683,3705,40729,7917,3,2683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',3564.99,NULL,NULL,1,'2021-08-03 12:56:31','2021-08-03 12:56:31',NULL),(2684,3705,40729,7917,3,2684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',9610.00,NULL,NULL,1,'2021-08-03 12:56:31','2021-08-03 12:56:31',NULL),(2685,3705,40729,7917,3,2685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',5114.99,NULL,NULL,1,'2021-08-03 12:56:31','2021-08-03 12:56:31',NULL),(2686,3705,40729,7917,3,2686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',8680.00,NULL,NULL,1,'2021-08-03 12:56:31','2021-08-03 12:56:31',NULL),(2687,3705,40729,7917,3,2687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',9609.99,NULL,NULL,1,'2021-08-03 12:56:31','2021-08-03 12:56:31',NULL),(2688,3705,40729,7917,3,2688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',9300.00,NULL,NULL,1,'2021-08-03 12:56:31','2021-08-03 12:56:31',NULL),(2689,3705,40729,7918,2,2689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',7410.00,NULL,NULL,1,'2021-08-03 12:57:33','2021-08-03 12:57:33',NULL),(2690,3705,40729,7918,2,2690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3120.00,NULL,NULL,1,'2021-08-03 12:57:33','2021-08-03 12:57:33',NULL),(2691,3705,40729,7918,2,2691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',7400.00,NULL,NULL,1,'2021-08-03 12:57:33','2021-08-03 12:57:33',NULL),(2692,3705,40729,7918,2,2692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',8190.00,NULL,NULL,1,'2021-08-03 12:57:33','2021-08-03 12:57:33',NULL),(2693,3705,40729,7918,2,2693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',5850.00,NULL,NULL,1,'2021-08-03 12:57:33','2021-08-03 12:57:33',NULL),(2694,3705,40729,7918,2,2694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3900.00,NULL,NULL,1,'2021-08-03 12:57:33','2021-08-03 12:57:33',NULL),(2695,3705,40729,7918,2,2695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',7020.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2696,3705,40729,7918,2,2696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',4680.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2697,3705,40729,7918,2,2697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6630.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2698,3705,40729,7918,2,2698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',3700.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2699,3705,40729,7918,2,2699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',12750.02,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2700,3705,40729,7918,2,2700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',8500.01,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL);
INSERT INTO `balance_libro` VALUES (2701,3705,40729,7918,2,2701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',3700.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2702,3705,40729,7918,2,2702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',4680.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2703,3705,40729,7918,2,2703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',7020.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2704,3705,40729,7918,2,2704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',8580.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2705,3705,40729,7918,2,2705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',7400.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2706,3705,40729,7918,2,2706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',6240.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2707,3705,40729,7918,2,2707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',3510.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2708,3705,40729,7918,2,2708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',2340.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2709,3705,40729,7918,2,2709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',4680.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2710,3705,40729,7918,2,2710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',5850.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2711,3705,40729,7918,2,2711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',7400.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2712,3705,40729,7918,2,2712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',6240.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2713,3705,40729,7918,2,2713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1800.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2714,3705,40729,7918,2,2714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4290.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2715,3705,40729,7918,2,2715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',5460.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2716,3705,40729,7918,2,2716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',6630.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2717,3705,40729,7918,2,2717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4290.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2718,3705,40729,7918,2,2718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',8580.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2719,3705,40729,7918,2,2719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',7800.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2720,3705,40729,7918,2,2720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2730.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2721,3705,40729,7918,2,2721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',4680.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2722,3705,40729,7918,2,2722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',7800.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2723,3705,40729,7918,2,2723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',5070.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2724,3705,40729,7918,2,2724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',4290.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL);
INSERT INTO `balance_libro` VALUES (2725,3705,40729,7918,2,2725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',3510.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2726,3705,40729,7918,2,2726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',3900.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2727,3705,40729,7918,2,2727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',3900.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2728,3705,40729,7918,2,2728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',4680.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2729,3705,40729,7918,2,2729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',5850.00,NULL,NULL,1,'2021-08-03 12:57:34','2021-08-03 12:57:34',NULL),(2730,3705,40729,7918,2,2730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',6240.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2731,3705,40729,7918,2,2731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',4680.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2732,3705,40729,7918,2,2732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1200.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2733,3705,40729,7918,2,2733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',7800.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2734,3705,40729,7918,2,2734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',8580.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2735,3705,40729,7918,2,2735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',7800.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2736,3705,40729,7918,2,2736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',2490.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2737,3705,40729,7918,2,2737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6300.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2738,3705,40729,7918,2,2738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',8100.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2739,3705,40729,7918,2,2739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',7650.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2740,3705,40729,7918,2,2740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',4500.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2741,3705,40729,7918,2,2741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',4950.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2742,3705,40729,7918,2,2742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',5400.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2743,3705,40729,7918,2,2743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',2700.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2744,3705,40729,7918,2,2744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3900.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2745,3705,40729,7918,2,2745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',7650.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2746,3705,40729,7918,2,2746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',5850.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2747,3705,40729,7918,2,2747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',7800.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2748,3705,40729,7918,2,2748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',8550.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL);
INSERT INTO `balance_libro` VALUES (2749,3705,40729,7918,2,2749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',6750.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2750,3705,40729,7918,2,2750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',3600.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2751,3705,40729,7918,2,2751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',8550.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2752,3705,40729,7918,2,2752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',7650.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2753,3705,40729,7918,2,2753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',3600.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2754,3705,40729,7918,2,2754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',5400.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2755,3705,40729,7918,2,2755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',7800.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2756,3705,40729,7918,2,2756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',6300.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2757,3705,40729,7918,2,2757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',3150.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2758,3705,40729,7918,2,2758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',2070.00,NULL,NULL,1,'2021-08-03 12:57:35','2021-08-03 12:57:35',NULL),(2759,3705,40729,7918,2,2759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',5850.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2760,3705,40729,7918,2,2760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',7650.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2761,3705,40729,7918,2,2761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',5400.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2762,3705,40729,7918,2,2762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',4500.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2763,3705,40729,7918,2,2763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',5850.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2764,3705,40729,7918,2,2764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',8100.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2765,3705,40729,7918,2,2765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',4500.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2766,3705,40729,7918,2,2766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',1380.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2767,3705,40729,7918,2,2767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',6300.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2768,3705,40729,7918,2,2768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',3600.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2769,3705,40729,7918,2,2769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',6300.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2770,3705,40729,7918,2,2770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',6750.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2771,3705,40729,7918,2,2771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',5400.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2772,3705,40729,7918,2,2772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',8900.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL);
INSERT INTO `balance_libro` VALUES (2773,3705,40729,7918,2,2773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',4450.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2774,3705,40729,7918,2,2774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2700.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2775,3705,40729,7918,2,2775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',5400.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2776,3705,40729,7918,2,2776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',7200.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2777,3705,40729,7918,2,2777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1380.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2778,3705,40729,7918,2,2778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',7650.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2779,3705,40729,7918,2,2779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',7800.00,NULL,NULL,1,'2021-08-03 12:57:36','2021-08-03 12:57:36',NULL),(2780,3705,40729,7918,2,2780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',6300.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2781,3705,40729,7918,2,2781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',4050.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2782,3705,40729,7918,2,2782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2700.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2783,3705,40729,7918,2,2783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1600.01,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2784,3705,40729,7918,2,2784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2700.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2785,3705,40729,7918,2,2785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',7200.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2786,3705,40729,7918,2,2786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',7800.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2787,3705,40729,7918,2,2787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',7650.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2788,3705,40729,7918,2,2788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',5850.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2789,3705,40729,7918,2,2789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4050.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2790,3705,40729,7918,2,2790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2070.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2791,3705,40729,7918,2,2791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',2700.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2792,3705,40729,7918,2,2792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',6300.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2793,3705,40729,7918,2,2793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',3150.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2794,3705,40729,7918,2,2794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',5400.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2795,3705,40729,7918,2,2795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4500.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2796,3705,40729,7918,2,2796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',6300.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL);
INSERT INTO `balance_libro` VALUES (2797,3705,40729,7918,2,2797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',1380.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2798,3705,40729,7918,2,2798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2700.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2799,3705,40729,7918,2,2799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',4050.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2800,3705,40729,7918,2,2800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',690.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2801,3705,40729,7918,2,2801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',3900.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2802,3705,40729,7918,2,2802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',8550.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2803,3705,40729,7918,2,2803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',7800.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2804,3705,40729,7918,2,2804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',7650.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2805,3705,40729,7918,2,2805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',6750.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2806,3705,40729,7918,2,2806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2250.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2807,3705,40729,7918,2,2807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',5850.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2808,3705,40729,7918,2,2808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',4500.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2809,3705,40729,7918,2,2809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',5400.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2810,3705,40729,7918,2,2810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',2070.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2811,3705,40729,7918,2,2811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',6750.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2812,3705,40729,7918,2,2812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',3150.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2813,3705,40729,7918,2,2813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',8550.00,NULL,NULL,1,'2021-08-03 12:57:37','2021-08-03 12:57:37',NULL),(2814,3705,40729,7918,2,2814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',7650.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2815,3705,40729,7918,2,2815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',7800.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2816,3705,40729,7918,2,2816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',2760.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2817,3705,40729,7918,2,2817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',5400.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2818,3705,40729,7918,2,2818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',7200.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2819,3705,40729,7918,2,2819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',900.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2820,3705,40729,7918,2,2820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',5850.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL);
INSERT INTO `balance_libro` VALUES (2821,3705,40729,7918,2,2821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',3900.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2822,3705,40729,7918,2,2822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',2070.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2823,3705,40729,7918,2,2823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',6300.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2824,3705,40729,7918,2,2824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',7200.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2825,3705,40729,7918,2,2825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',7800.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2826,3705,40729,7918,2,2826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',8100.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2827,3705,40729,7918,2,2827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',2070.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2828,3705,40729,7918,2,2828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',4950.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2829,3705,40729,7918,2,2829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',3150.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2830,3705,40729,7918,2,2830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',3900.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2831,3705,40729,7918,2,2831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',5850.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2832,3705,40729,7918,2,2832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',5400.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2833,3705,40729,7918,2,2833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',4500.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2834,3705,40729,7918,2,2834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',1380.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2835,3705,40729,7918,2,2835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',7800.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2836,3705,40729,7918,2,2836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',7650.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2837,3705,40729,7918,2,2837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',6300.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2838,3705,40729,7918,2,2838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',690.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2839,3705,40729,7918,2,2839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',5400.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2840,3705,40729,7918,2,2840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',4500.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2841,3705,40729,7918,2,2841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',3900.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2842,3705,40729,7918,2,2842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',5850.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2843,3705,40729,7918,2,2843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',3150.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2844,3705,40729,7918,2,2844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',1380.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL);
INSERT INTO `balance_libro` VALUES (2845,3705,40729,7918,2,2845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',7200.00,NULL,NULL,1,'2021-08-03 12:57:38','2021-08-03 12:57:38',NULL),(2846,3705,40729,7918,2,2846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',8550.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2847,3705,40729,7918,2,2847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',1380.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2848,3705,40729,7918,2,2848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',7650.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2849,3705,40729,7918,2,2849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',5400.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2850,3705,40729,7918,2,2850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',3600.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2851,3705,40729,7918,2,2851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',5850.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2852,3705,40729,7918,2,2852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',7200.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2853,3705,40729,7918,2,2853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',7800.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2854,3705,40729,7918,2,2854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',4050.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2855,3705,40729,7918,2,2855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',6750.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2856,3705,40729,7918,2,2856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',1380.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2857,3705,40729,7918,2,2857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',3150.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2858,3705,40729,7918,2,2858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',4500.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2859,3705,40729,7918,2,2859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',6300.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2860,3705,40729,7918,2,2860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',5400.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2861,3705,40729,7918,2,2861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',4950.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2862,3705,40729,7918,2,2862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',3600.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2863,3705,40729,7918,2,2863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',4500.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2864,3705,40729,7918,2,2864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',5850.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2865,3705,40729,7918,2,2865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',7800.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2866,3705,40729,7918,2,2866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',8100.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2867,3705,40729,7918,2,2867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',7650.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2868,3705,40729,7918,2,2868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',6300.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL);
INSERT INTO `balance_libro` VALUES (2869,3705,40729,7918,2,2869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',3600.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2870,3705,40729,7918,2,2870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',7650.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2871,3705,40729,7918,2,2871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',4950.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2872,3705,40729,7918,2,2872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',5850.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2873,3705,40729,7918,2,2873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',4500.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2874,3705,40729,7918,2,2874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',8550.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2875,3705,40729,7918,2,2875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',7800.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2876,3705,40729,7918,2,2876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',5850.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2877,3705,40729,7918,2,2877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',2250.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2878,3705,40729,7918,2,2878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',5850.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2879,3705,40729,7918,2,2879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',7200.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2880,3705,40729,7918,2,2880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',4950.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2881,3705,40729,7918,2,2881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',6300.00,NULL,NULL,1,'2021-08-03 12:57:39','2021-08-03 12:57:39',NULL),(2882,3705,40729,7918,2,2882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',5400.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2883,3705,40729,7918,2,2883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',3150.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2884,3705,40729,7918,2,2884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',7800.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2885,3705,40729,7918,2,2885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1380.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2886,3705,40729,7918,2,2886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',7650.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2887,3705,40729,7918,2,2887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',7200.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2888,3705,40729,7918,2,2888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',8550.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2889,3705,40729,7918,2,2889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',7650.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2890,3705,40729,7918,2,2890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',8100.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2891,3705,40729,7918,2,2891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',6300.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2892,3705,40729,7918,2,2892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',2700.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL);
INSERT INTO `balance_libro` VALUES (2893,3705,40729,7918,2,2893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',2070.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2894,3705,40729,7918,2,2894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',6300.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2895,3705,40729,7918,2,2895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',4500.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2896,3705,40729,7918,2,2896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',8550.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2897,3705,40729,7918,2,2897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',7800.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2898,3705,40729,7918,2,2898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',7650.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2899,3705,40729,7918,2,2899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',1380.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2900,3705,40729,7918,2,2900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',4500.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2901,3705,40729,7918,2,2901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',5850.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2902,3705,40729,7918,2,2902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',3900.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2903,3705,40729,7918,2,2903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',6750.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2904,3705,40729,7918,2,2904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',5400.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2905,3705,40729,7918,2,2905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',5850.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2906,3705,40729,7918,2,2906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1380.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2907,3705,40729,7918,2,2907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',3600.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2908,3705,40729,7918,2,2908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',7650.00,NULL,NULL,1,'2021-08-03 12:57:40','2021-08-03 12:57:40',NULL),(2909,3705,40729,7918,2,2909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',6300.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2910,3705,40729,7918,2,2910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',4500.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2911,3705,40729,7918,2,2911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',2700.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2912,3705,40729,7918,2,2912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',4050.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2913,3705,40729,7918,2,2913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',5850.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2914,3705,40729,7918,2,2914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',2070.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2915,3705,40729,7918,2,2915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',6750.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2916,3705,40729,7918,2,2916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',3150.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL);
INSERT INTO `balance_libro` VALUES (2917,3705,40729,7918,2,2917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',3600.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2918,3705,40729,7918,2,2918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',1380.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2919,3705,40729,7918,2,2919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',6300.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2920,3705,40729,7918,2,2920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',5850.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2921,3705,40729,7918,2,2921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4950.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2922,3705,40729,7918,2,2922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',6750.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2923,3705,40729,7918,2,2923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',3150.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2924,3705,40729,7918,2,2924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',7200.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2925,3705,40729,7918,2,2925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',6300.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2926,3705,40729,7918,2,2926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',5400.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2927,3705,40729,7918,2,2927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',3600.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2928,3705,40729,7918,2,2928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',13350.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2929,3705,40729,7918,2,2929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',4450.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2930,3705,40729,7918,2,2930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',5850.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2931,3705,40729,7918,2,2931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7200.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2932,3705,40729,7918,2,2932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',4950.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2933,3705,40729,7918,2,2933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',6300.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2934,3705,40729,7918,2,2934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',5400.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2935,3705,40729,7918,2,2935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',3150.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2936,3705,40729,7918,2,2936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7800.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2937,3705,40729,7918,2,2937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7650.00,NULL,NULL,1,'2021-08-03 12:57:41','2021-08-03 12:57:41',NULL),(2938,3705,40729,7918,3,2938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',8989.99,NULL,NULL,1,'2021-08-03 12:58:58','2021-08-03 12:58:58',NULL),(2939,3705,40729,7918,3,2939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6510.00,NULL,NULL,1,'2021-08-03 12:58:58','2021-08-03 12:58:58',NULL),(2940,3705,40729,7918,3,2940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',6510.00,NULL,NULL,1,'2021-08-03 12:58:58','2021-08-03 12:58:58',NULL);
INSERT INTO `balance_libro` VALUES (2941,3705,40729,7918,3,2941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',12400.01,NULL,NULL,1,'2021-08-03 12:58:58','2021-08-03 12:58:58',NULL),(2942,3705,40729,7918,3,2942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',4340.00,NULL,NULL,1,'2021-08-03 12:58:58','2021-08-03 12:58:58',NULL),(2943,3705,40729,7918,3,2943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',3410.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2944,3705,40729,7918,3,2944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',12090.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2945,3705,40729,7918,3,2945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',9299.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2946,3705,40729,7918,3,2946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',12400.01,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2947,3705,40729,7918,3,2947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',11375.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2948,3705,40729,7918,3,2948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',11375.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2949,3705,40729,7918,3,2949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',58.50,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2950,3705,40729,7918,3,2950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',8680.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2951,3705,40729,7918,3,2951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',6659.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2952,3705,40729,7918,3,2952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',9299.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2953,3705,40729,7918,3,2953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',3410.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2954,3705,40729,7918,3,2954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',10224.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2955,3705,40729,7918,3,2955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',10644.48,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2956,3705,40729,7918,3,2956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2479.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2957,3705,40729,7918,3,2957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',6820.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2958,3705,40729,7918,3,2958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',14104.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2959,3705,40729,7918,3,2959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',1479.75,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2960,3705,40729,7918,3,2960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',9299.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2961,3705,40729,7918,3,2961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',8989.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2962,3705,40729,7918,3,2962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',7440.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2963,3705,40729,7918,3,2963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6509.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2964,3705,40729,7918,3,2964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',4254.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL);
INSERT INTO `balance_libro` VALUES (2965,3705,40729,7918,3,2965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',8800.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2966,3705,40729,7918,3,2966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',5179.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2967,3705,40729,7918,3,2967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',7280.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2968,3705,40729,7918,3,2968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',3410.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2969,3705,40729,7918,3,2969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',11099.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2970,3705,40729,7918,3,2970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',16570.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2971,3705,40729,7918,3,2971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',8139.98,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2972,3705,40729,7918,3,2972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6199.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2973,3705,40729,7918,3,2973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',6509.99,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2974,3705,40729,7918,3,2974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',8680.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2975,3705,40729,7918,3,2975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',10200.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2976,3705,40729,7918,3,2976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',8370.00,NULL,NULL,1,'2021-08-03 12:58:59','2021-08-03 12:58:59',NULL),(2977,3705,40729,7918,3,2977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',9620.00,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2978,3705,40729,7918,3,2978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',12050.01,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2979,3705,40729,7918,3,2979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',6949.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2980,3705,40729,7918,3,2980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',7749.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2981,3705,40729,7918,3,2981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',7310.00,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2982,3705,40729,7918,3,2982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',5729.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2983,3705,40729,7918,3,2983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',7285.00,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2984,3705,40729,7918,3,2984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',4030.00,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2985,3705,40729,7918,3,2985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',5364.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2986,3705,40729,7918,3,2986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',9620.00,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2987,3705,40729,7918,3,2987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',15749.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2988,3705,40729,7918,3,2988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',8189.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL);
INSERT INTO `balance_libro` VALUES (2989,3705,40729,7918,3,2989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',14429.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2990,3705,40729,7918,3,2990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',14429.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2991,3705,40729,7918,3,2991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',5785.01,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2992,3705,40729,7918,3,2992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',7954.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2993,3705,40729,7918,3,2993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',21669.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2994,3705,40729,7918,3,2994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',7769.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2995,3705,40729,7918,3,2995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',2590.00,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2996,3705,40729,7918,3,2996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',10729.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2997,3705,40729,7918,3,2997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',9989.98,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2998,3705,40729,7918,3,2998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',7029.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(2999,3705,40729,7918,3,2999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',6844.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(3000,3705,40729,7918,3,3000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',7399.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(3001,3705,40729,7918,3,3001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',7029.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(3002,3705,40729,7918,3,3002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',10729.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(3003,3705,40729,7918,3,3003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',4809.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(3004,3705,40729,7918,3,3004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',11099.99,NULL,NULL,1,'2021-08-03 12:59:00','2021-08-03 12:59:00',NULL),(3005,3705,40729,7918,3,3005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4809.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3006,3705,40729,7918,3,3006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4439.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3007,3705,40729,7918,3,3007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',8324.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3008,3705,40729,7918,3,3008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',10359.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3009,3705,40729,7918,3,3009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',20700.03,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3010,3705,40729,7918,3,3010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',5179.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3011,3705,40729,7918,3,3011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',6659.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3012,3705,40729,7918,3,3012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',4440.00,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL);
INSERT INTO `balance_libro` VALUES (3013,3705,40729,7918,3,3013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',6765.00,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3014,3705,40729,7918,3,3014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',3699.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3015,3705,40729,7918,3,3015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',9249.98,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3016,3705,40729,7918,3,3016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',9169.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3017,3705,40729,7918,3,3017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',18999.98,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3018,3705,40729,7918,3,3018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',3330.00,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3019,3705,40729,7918,3,3019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',4624.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3020,3705,40729,7918,3,3020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',16279.98,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3021,3705,40729,7918,3,3021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',9064.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3022,3705,40729,7918,3,3022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',9250.00,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3023,3705,40729,7918,3,3023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',7029.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3024,3705,40729,7918,3,3024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',19739.98,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3025,3705,40729,7918,3,3025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',3515.00,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3026,3705,40729,7918,3,3026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',175.50,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3027,3705,40729,7918,3,3027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',10359.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3028,3705,40729,7918,3,3028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',13160.01,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3029,3705,40729,7918,3,3029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',5179.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3030,3705,40729,7918,3,3030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',9910.00,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3031,3705,40729,7918,3,3031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',20084.97,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3032,3705,40729,7918,3,3032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',9620.00,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3033,3705,40729,7918,3,3033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',1326.75,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3034,3705,40729,7918,3,3034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',2557.88,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3035,3705,40729,7918,3,3035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',11100.00,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3036,3705,40729,7918,3,3036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',8745.00,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL);
INSERT INTO `balance_libro` VALUES (3037,3705,40729,7918,3,3037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',16860.00,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3038,3705,40729,7918,3,3038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',6289.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3039,3705,40729,7918,3,3039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',4809.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3040,3705,40729,7918,3,3040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',8139.99,NULL,NULL,1,'2021-08-03 12:59:01','2021-08-03 12:59:01',NULL),(3041,3705,40729,7918,3,3041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',5919.99,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3042,3705,40729,7918,3,3042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',10729.99,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3043,3705,40729,7918,3,3043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',8509.98,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3044,3705,40729,7918,3,3044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',7954.99,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3045,3705,40729,7918,3,3045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',6580.00,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3046,3705,40729,7918,3,3046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',8139.98,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3047,3705,40729,7918,3,3047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',10649.99,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3048,3705,40729,7918,3,3048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',6949.99,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3049,3705,40729,7918,3,3049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',16144.98,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3050,3705,40729,7918,3,3050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',12869.99,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3051,3705,40729,7918,3,3051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',11389.98,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3052,3705,40729,7918,3,3052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',10834.99,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3053,3705,40729,7918,3,3053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',10360.00,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3054,3705,40729,7918,3,3054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',6210.00,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3055,3705,40729,7918,3,3055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',9434.98,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3056,3705,40729,7918,3,3056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',2220.00,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3057,3705,40729,7918,3,3057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',18499.98,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3058,3705,40729,7918,3,3058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',15539.98,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3059,3705,40729,7918,3,3059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',4439.99,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3060,3705,40729,7918,3,3060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',9250.00,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL);
INSERT INTO `balance_libro` VALUES (3061,3705,40729,7918,3,3061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',6844.99,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3062,3705,40729,7918,3,3062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',7029.99,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3063,3705,40729,7918,3,3063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',6580.00,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3064,3705,40729,7918,3,3064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',8879.98,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3065,3705,40729,7918,3,3065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',12050.00,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3066,3705,40729,7918,3,3066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',5179.99,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3067,3705,40729,7918,3,3067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',8694.98,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3068,3705,40729,7918,3,3068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',4439.99,NULL,NULL,1,'2021-08-03 12:59:02','2021-08-03 12:59:02',NULL),(3069,3705,40729,7918,3,3069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',19609.98,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3070,3705,40729,7918,3,3070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',11100.00,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3071,3705,40729,7918,3,3071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',6659.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3072,3705,40729,7918,3,3072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',17229.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3073,3705,40729,7918,3,3073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',4439.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3074,3705,40729,7918,3,3074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',7029.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3075,3705,40729,7918,3,3075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',3699.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3076,3705,40729,7918,3,3076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',6500.01,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3077,3705,40729,7918,3,3077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',10359.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3078,3705,40729,7918,3,3078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',8139.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3079,3705,40729,7918,3,3079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',8984.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3080,3705,40729,7918,3,3080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',592.01,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3081,3705,40729,7918,3,3081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',5650.01,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3082,3705,40729,7918,3,3082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',14059.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3083,3705,40729,7918,3,3083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',14825.00,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3084,3705,40729,7918,3,3084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',9460.01,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL);
INSERT INTO `balance_libro` VALUES (3085,3705,40729,7918,3,3085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',11310.01,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3086,3705,40729,7918,3,3086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',9460.01,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3087,3705,40729,7918,3,3087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',18734.98,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3088,3705,40729,7918,3,3088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',11284.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3089,3705,40729,7918,3,3089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',19369.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3090,3705,40729,7918,3,3090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',19369.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3091,3705,40729,7918,3,3091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',17334.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3092,3705,40729,7918,3,3092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',5919.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3093,3705,40729,7918,3,3093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',9434.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3094,3705,40729,7918,3,3094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',6210.00,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3095,3705,40729,7918,3,3095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',7029.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3096,3705,40729,7918,3,3096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',13689.99,NULL,NULL,1,'2021-08-03 12:59:03','2021-08-03 12:59:03',NULL),(3097,3705,40763,9445,3,3097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',10653.30,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3098,3705,40763,9445,3,3098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-02','2021-01-02',6309.07,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3099,3705,40763,9445,3,3099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-04','2021-01-04',7836.53,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3100,3705,40763,9445,3,3100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',6727.78,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3101,3705,40763,9445,3,3101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',3951.88,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3102,3705,40763,9445,3,3102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',1530.02,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3103,3705,40763,9445,3,3103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',4624.58,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3104,3705,40763,9445,3,3104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',4085.50,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3105,3705,40763,9445,3,3105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-05','2021-01-05',7548.43,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3106,3705,40763,9445,3,3106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',9197.83,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3107,3705,40763,9445,3,3107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',8846.99,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3108,3705,40763,9445,3,3108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',369.00,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL);
INSERT INTO `balance_libro` VALUES (3109,3705,40763,9445,3,3109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',5413.92,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3110,3705,40763,9445,3,3110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-06','2021-01-06',2414.19,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3111,3705,40763,9445,3,3111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',500.00,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3112,3705,40763,9445,3,3112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',13406.15,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3113,3705,40763,9445,3,3113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-07','2021-01-07',3920.21,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3114,3705,40763,9445,3,3114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',3154.26,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3115,3705,40763,9445,3,3115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',6761.98,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3116,3705,40763,9445,3,3116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-08','2021-01-08',10787.14,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3117,3705,40763,9445,3,3117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-09','2021-01-09',16450.93,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3118,3705,40763,9445,3,3118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',1368.29,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3119,3705,40763,9445,3,3119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-11','2021-01-11',9197.50,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3120,3705,40763,9445,3,3120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',12100.00,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3121,3705,40763,9445,3,3121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',3524.25,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3122,3705,40763,9445,3,3122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',3004.67,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3123,3705,40763,9445,3,3123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',14433.50,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3124,3705,40763,9445,3,3124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',4011.00,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3125,3705,40763,9445,3,3125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',1286.06,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3126,3705,40763,9445,3,3126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-12','2021-01-12',2467.31,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3127,3705,40763,9445,3,3127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',5402.00,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3128,3705,40763,9445,3,3128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-13','2021-01-13',79.04,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3129,3705,40763,9445,3,3129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',11084.07,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3130,3705,40763,9445,3,3130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',1734.52,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3131,3705,40763,9445,3,3131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-14','2021-01-14',11013.90,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3132,3705,40763,9445,3,3132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',2135.91,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL);
INSERT INTO `balance_libro` VALUES (3133,3705,40763,9445,3,3133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',23575.00,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3134,3705,40763,9445,3,3134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',1514.92,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3135,3705,40763,9445,3,3135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',11609.99,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3136,3705,40763,9445,3,3136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-15','2021-01-15',271.16,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3137,3705,40763,9445,3,3137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',12363.32,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3138,3705,40763,9445,3,3138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-16','2021-01-16',11588.69,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3139,3705,40763,9445,3,3139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',9508.37,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3140,3705,40763,9445,3,3140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1870.24,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3141,3705,40763,9445,3,3141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',17735.02,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3142,3705,40763,9445,3,3142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',1565.90,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3143,3705,40763,9445,3,3143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',242.13,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3144,3705,40763,9445,3,3144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-18','2021-01-18',5009.10,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3145,3705,40763,9445,3,3145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',2627.93,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3146,3705,40763,9445,3,3146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',1486.44,NULL,NULL,1,'2021-08-05 01:15:10','2021-08-05 01:15:10',NULL),(3147,3705,40763,9445,3,3147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-19','2021-01-19',4100.50,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3148,3705,40763,9445,3,3148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',3322.26,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3149,3705,40763,9445,3,3149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-20','2021-01-20',2589.27,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3150,3705,40763,9445,3,3150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',2156.73,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3151,3705,40763,9445,3,3151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',12380.07,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3152,3705,40763,9445,3,3152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',5553.60,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3153,3705,40763,9445,3,3153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',4026.52,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3154,3705,40763,9445,3,3154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',1753.56,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3155,3705,40763,9445,3,3155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-21','2021-01-21',635.89,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3156,3705,40763,9445,3,3156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',2526.36,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL);
INSERT INTO `balance_libro` VALUES (3157,3705,40763,9445,3,3157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',842.12,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3158,3705,40763,9445,3,3158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',14701.98,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3159,3705,40763,9445,3,3159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',12064.68,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3160,3705,40763,9445,3,3160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-22','2021-01-22',10121.88,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3161,3705,40763,9445,3,3161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',6515.50,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3162,3705,40763,9445,3,3162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-23','2021-01-23',12732.94,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3163,3705,40763,9445,3,3163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',2968.27,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3164,3705,40763,9445,3,3164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',8347.70,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3165,3705,40763,9445,3,3165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',7954.94,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3166,3705,40763,9445,3,3166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-25','2021-01-25',0.02,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3167,3705,40763,9445,3,3167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',18001.07,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3168,3705,40763,9445,3,3168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',7354.49,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3169,3705,40763,9445,3,3169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',2579.91,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3170,3705,40763,9445,3,3170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',21450.85,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3171,3705,40763,9445,3,3171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1333.45,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3172,3705,40763,9445,3,3172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-26','2021-01-26',1565.90,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3173,3705,40763,9445,3,3173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',11415.78,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3174,3705,40763,9445,3,3174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',9444.91,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3175,3705,40763,9445,3,3175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',5917.95,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3176,3705,40763,9445,3,3176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',6130.91,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3177,3705,40763,9445,3,3177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-27','2021-01-27',1795.90,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3178,3705,40763,9445,3,3178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',3919.89,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3179,3705,40763,9445,3,3179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-28','2021-01-28',550.78,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3180,3705,40763,9445,3,3180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',5976.43,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL);
INSERT INTO `balance_libro` VALUES (3181,3705,40763,9445,3,3181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',3613.33,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3182,3705,40763,9445,3,3182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',2572.10,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3183,3705,40763,9445,3,3183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',14915.18,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3184,3705,40763,9445,3,3184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',300.02,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3185,3705,40763,9445,3,3185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-29','2021-01-29',7941.12,NULL,NULL,1,'2021-08-05 01:15:11','2021-08-05 01:15:11',NULL),(3186,3705,40763,9446,2,3186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',49.00,NULL,NULL,1,'2021-08-05 21:33:45','2021-08-05 21:33:45',NULL),(3187,3705,40763,9446,2,3187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1218.00,NULL,NULL,1,'2021-08-05 21:33:45','2021-08-05 21:33:45',NULL),(3188,3705,40763,9446,2,3188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',134.40,NULL,NULL,1,'2021-08-05 21:33:45','2021-08-05 21:33:45',NULL),(3189,3705,40763,9446,2,3189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',573.00,NULL,NULL,1,'2021-08-05 21:33:45','2021-08-05 21:33:45',NULL),(3190,3705,40763,9446,2,3190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',485.00,NULL,NULL,1,'2021-08-05 21:33:45','2021-08-05 21:33:45',NULL),(3191,3705,40763,9446,2,3191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',629.00,NULL,NULL,1,'2021-08-05 21:33:45','2021-08-05 21:33:45',NULL),(3192,3705,40763,9446,2,3192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',310.00,NULL,NULL,1,'2021-08-05 21:33:45','2021-08-05 21:33:45',NULL),(3193,3705,40763,9446,2,3193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',1205.00,NULL,NULL,1,'2021-08-05 21:33:45','2021-08-05 21:33:45',NULL),(3194,3705,40763,9446,2,3194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',773.00,NULL,NULL,1,'2021-08-05 21:33:45','2021-08-05 21:33:45',NULL),(3195,3705,40763,9446,3,3195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',9938.27,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3196,3705,40763,9446,3,3196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',7716.19,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3197,3705,40763,9446,3,3197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',3989.76,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3198,3705,40763,9446,3,3198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-01','2021-02-01',10803.56,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3199,3705,40763,9446,3,3199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',471.18,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3200,3705,40763,9446,3,3200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',5329.19,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3201,3705,40763,9446,3,3201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',7481.42,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3202,3705,40763,9446,3,3202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',6126.50,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3203,3705,40763,9446,3,3203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',23438.78,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3204,3705,40763,9446,3,3204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',5024.20,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL);
INSERT INTO `balance_libro` VALUES (3205,3705,40763,9446,3,3205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-02','2021-02-02',4077.39,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3206,3705,40763,9446,3,3206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',12506.44,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3207,3705,40763,9446,3,3207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',6242.31,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3208,3705,40763,9446,3,3208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',10193.25,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3209,3705,40763,9446,3,3209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',2364.99,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3210,3705,40763,9446,3,3210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3331.39,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3211,3705,40763,9446,3,3211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-03','2021-02-03',3970.05,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3212,3705,40763,9446,3,3212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',3523.94,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3213,3705,40763,9446,3,3213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',2364.02,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3214,3705,40763,9446,3,3214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',5415.28,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3215,3705,40763,9446,3,3215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',11135.46,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3216,3705,40763,9446,3,3216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',6114.54,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3217,3705,40763,9446,3,3217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-04','2021-02-04',15537.62,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3218,3705,40763,9446,3,3218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',4276.78,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3219,3705,40763,9446,3,3219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',11266.54,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3220,3705,40763,9446,3,3220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',1835.97,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3221,3705,40763,9446,3,3221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-05','2021-02-05',2634.42,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3222,3705,40763,9446,3,3222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',12498.10,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3223,3705,40763,9446,3,3223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-06','2021-02-06',4589.99,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3224,3705,40763,9446,3,3224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',12100.00,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3225,3705,40763,9446,3,3225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',4441.50,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3226,3705,40763,9446,3,3226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',11695.13,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3227,3705,40763,9446,3,3227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-08','2021-02-08',5626.20,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3228,3705,40763,9446,3,3228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',635.78,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL);
INSERT INTO `balance_libro` VALUES (3229,3705,40763,9446,3,3229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',3287.71,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3230,3705,40763,9446,3,3230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',5052.37,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3231,3705,40763,9446,3,3231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-09','2021-02-09',11683.83,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3232,3705,40763,9446,3,3232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-10','2021-02-10',5500.75,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3233,3705,40763,9446,3,3233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',13032.31,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3234,3705,40763,9446,3,3234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',5882.08,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3235,3705,40763,9446,3,3235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',3302.22,NULL,NULL,1,'2021-08-05 21:35:21','2021-08-05 21:35:21',NULL),(3236,3705,40763,9446,3,3236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',9543.14,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3237,3705,40763,9446,3,3237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-11','2021-02-11',3561.47,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3238,3705,40763,9446,3,3238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',11380.15,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3239,3705,40763,9446,3,3239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',7642.47,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3240,3705,40763,9446,3,3240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',13080.20,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3241,3705,40763,9446,3,3241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-12','2021-02-12',304.52,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3242,3705,40763,9446,3,3242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-13','2021-02-13',6239.12,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3243,3705,40763,9446,3,3243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',11380.15,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3244,3705,40763,9446,3,3244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-15','2021-02-15',4221.20,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3245,3705,40763,9446,3,3245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-16','2021-02-16',5094.15,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3246,3705,40763,9446,3,3246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-16','2021-02-16',6252.80,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3247,3705,40763,9446,3,3247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-16','2021-02-16',304.52,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3248,3705,40763,9446,3,3248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',7058.13,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3249,3705,40763,9446,3,3249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',5492.32,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3250,3705,40763,9446,3,3250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',3045.86,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3251,3705,40763,9446,3,3251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-17','2021-02-17',9349.39,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3252,3705,40763,9446,3,3252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',3939.95,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL);
INSERT INTO `balance_libro` VALUES (3253,3705,40763,9446,3,3253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',3056.21,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3254,3705,40763,9446,3,3254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-18','2021-02-18',17343.98,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3255,3705,40763,9446,3,3255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',10855.58,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3256,3705,40763,9446,3,3256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',17405.67,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3257,3705,40763,9446,3,3257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-19','2021-02-19',932.86,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3258,3705,40763,9446,3,3258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',3746.58,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3259,3705,40763,9446,3,3259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-22','2021-02-22',4977.66,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3260,3705,40763,9446,3,3260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',6934.43,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3261,3705,40763,9446,3,3261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-23','2021-02-23',12329.00,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3262,3705,40763,9446,3,3262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',879.00,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3263,3705,40763,9446,3,3263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-24','2021-02-24',6516.64,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3264,3705,40763,9446,3,3264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',7448.55,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3265,3705,40763,9446,3,3265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',2111.53,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3266,3705,40763,9446,3,3266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',23361.66,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3267,3705,40763,9446,3,3267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',5799.72,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3268,3705,40763,9446,3,3268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-25','2021-02-25',2169.64,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3269,3705,40763,9446,3,3269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',770.00,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3270,3705,40763,9446,3,3270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',13100.89,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3271,3705,40763,9446,3,3271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',8320.25,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3272,3705,40763,9446,3,3272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',3137.87,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3273,3705,40763,9446,3,3273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',12119.64,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3274,3705,40763,9446,3,3274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-02-26','2021-02-26',80.05,NULL,NULL,1,'2021-08-05 21:35:22','2021-08-05 21:35:22',NULL),(3275,3705,40763,9447,2,3275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',147.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3276,3705,40763,9447,2,3276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',160.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL);
INSERT INTO `balance_libro` VALUES (3277,3705,40763,9447,2,3277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',35.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3278,3705,40763,9447,2,3278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',306.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3279,3705,40763,9447,2,3279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',35.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3280,3705,40763,9447,2,3280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',82.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3281,3705,40763,9447,2,3281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',134.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3282,3705,40763,9447,2,3282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',214.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3283,3705,40763,9447,2,3283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',270.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3284,3705,40763,9447,2,3284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',717.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3285,3705,40763,9447,2,3285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',250.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3286,3705,40763,9447,2,3286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',27.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3287,3705,40763,9447,2,3287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',500.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3288,3705,40763,9447,2,3288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',197.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3289,3705,40763,9447,2,3289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',2005.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3290,3705,40763,9447,2,3290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',780.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3291,3705,40763,9447,2,3291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',462.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3292,3705,40763,9447,2,3292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',422.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3293,3705,40763,9447,2,3293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',300.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3294,3705,40763,9447,2,3294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',35.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3295,3705,40763,9447,2,3295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',858.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3296,3705,40763,9447,2,3296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',62.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3297,3705,40763,9447,2,3297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',220.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3298,3705,40763,9447,2,3298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',303.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3299,3705,40763,9447,2,3299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',664.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3300,3705,40763,9447,2,3300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',507.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3301,3705,40763,9447,2,3301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',520.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL);
INSERT INTO `balance_libro` VALUES (3302,3705,40763,9447,2,3302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',570.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3303,3705,40763,9447,2,3303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',200.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3304,3705,40763,9447,2,3304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',398.00,NULL,NULL,1,'2021-08-05 21:37:12','2021-08-05 21:37:12',NULL),(3305,3705,40763,9447,2,3305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',497.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3306,3705,40763,9447,2,3306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',169.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3307,3705,40763,9447,2,3307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',375.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3308,3705,40763,9447,2,3308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',590.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3309,3705,40763,9447,2,3309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',593.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3310,3705,40763,9447,2,3310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',395.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3311,3705,40763,9447,2,3311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',625.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3312,3705,40763,9447,2,3312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',168.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3313,3705,40763,9447,2,3313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',803.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3314,3705,40763,9447,2,3314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',161.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3315,3705,40763,9447,2,3315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',322.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3316,3705,40763,9447,2,3316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',428.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3317,3705,40763,9447,2,3317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',392.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3318,3705,40763,9447,2,3318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',298.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3319,3705,40763,9447,2,3319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',687.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3320,3705,40763,9447,2,3320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1210.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3321,3705,40763,9447,2,3321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1460.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3322,3705,40763,9447,2,3322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',730.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3323,3705,40763,9447,2,3323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',165.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3324,3705,40763,9447,2,3324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',755.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3325,3705,40763,9447,2,3325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',187.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3326,3705,40763,9447,2,3326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',488.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL);
INSERT INTO `balance_libro` VALUES (3327,3705,40763,9447,2,3327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',520.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3328,3705,40763,9447,2,3328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',583.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3329,3705,40763,9447,2,3329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',350.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3330,3705,40763,9447,2,3330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',287.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3331,3705,40763,9447,2,3331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',335.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3332,3705,40763,9447,2,3332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',257.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3333,3705,40763,9447,2,3333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',765.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3334,3705,40763,9447,2,3334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1027.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3335,3705,40763,9447,2,3335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',392.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3336,3705,40763,9447,2,3336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',401.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3337,3705,40763,9447,2,3337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',578.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3338,3705,40763,9447,2,3338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',264.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3339,3705,40763,9447,2,3339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',500.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3340,3705,40763,9447,2,3340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',125.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3341,3705,40763,9447,2,3341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2449.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3342,3705,40763,9447,2,3342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',490.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3343,3705,40763,9447,2,3343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',407.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3344,3705,40763,9447,2,3344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',130.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3345,3705,40763,9447,2,3345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1965.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3346,3705,40763,9447,2,3346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',752.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3347,3705,40763,9447,2,3347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',737.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3348,3705,40763,9447,2,3348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',660.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3349,3705,40763,9447,2,3349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',340.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3350,3705,40763,9447,2,3350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',468.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3351,3705,40763,9447,2,3351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',567.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL);
INSERT INTO `balance_libro` VALUES (3352,3705,40763,9447,2,3352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',4556.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3353,3705,40763,9447,2,3353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',264.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3354,3705,40763,9447,2,3354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1065.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3355,3705,40763,9447,2,3355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',613.00,NULL,NULL,1,'2021-08-05 21:37:13','2021-08-05 21:37:13',NULL),(3356,3705,40763,9447,2,3356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1564.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3357,3705,40763,9447,2,3357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',756.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3358,3705,40763,9447,2,3358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1510.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3359,3705,40763,9447,2,3359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',838.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3360,3705,40763,9447,2,3360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',360.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3361,3705,40763,9447,2,3361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',672.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3362,3705,40763,9447,2,3362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',395.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3363,3705,40763,9447,2,3363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',259.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3364,3705,40763,9447,2,3364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1568.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3365,3705,40763,9447,2,3365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',385.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3366,3705,40763,9447,2,3366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',500.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3367,3705,40763,9447,2,3367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',180.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3368,3705,40763,9447,2,3368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1481.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3369,3705,40763,9447,2,3369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',1000.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3370,3705,40763,9447,2,3370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',752.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3371,3705,40763,9447,2,3371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',247.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3372,3705,40763,9447,2,3372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',363.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3373,3705,40763,9447,2,3373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',740.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3374,3705,40763,9447,2,3374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1249.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3375,3705,40763,9447,2,3375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1296.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL);
INSERT INTO `balance_libro` VALUES (3376,3705,40763,9447,2,3376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1380.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3377,3705,40763,9447,2,3377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',821.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3378,3705,40763,9447,2,3378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',462.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3379,3705,40763,9447,2,3379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',370.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3380,3705,40763,9447,2,3380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',712.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3381,3705,40763,9447,2,3381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1249.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3382,3705,40763,9447,2,3382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',820.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3383,3705,40763,9447,2,3383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',382.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3384,3705,40763,9447,2,3384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',566.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3385,3705,40763,9447,2,3385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-13','2021-03-13',1690.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3386,3705,40763,9447,2,3386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',496.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3387,3705,40763,9447,2,3387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',699.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3388,3705,40763,9447,2,3388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-14','2021-03-14',423.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3389,3705,40763,9447,2,3389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',547.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3390,3705,40763,9447,2,3390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',447.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3391,3705,40763,9447,2,3391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',1417.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3392,3705,40763,9447,2,3392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',510.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3393,3705,40763,9447,2,3393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',758.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3394,3705,40763,9447,2,3394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',359.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3395,3705,40763,9447,2,3395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',344.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3396,3705,40763,9447,2,3396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',1981.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3397,3705,40763,9447,2,3397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',281.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3398,3705,40763,9447,2,3398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',526.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3399,3705,40763,9447,2,3399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',270.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3400,3705,40763,9447,2,3400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',199.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL);
INSERT INTO `balance_libro` VALUES (3401,3705,40763,9447,2,3401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',522.00,NULL,NULL,1,'2021-08-05 21:37:14','2021-08-05 21:37:14',NULL),(3402,3705,40763,9447,2,3402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',637.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3403,3705,40763,9447,2,3403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',608.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3404,3705,40763,9447,2,3404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',646.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3405,3705,40763,9447,2,3405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',125.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3406,3705,40763,9447,2,3406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',2122.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3407,3705,40763,9447,2,3407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',489.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3408,3705,40763,9447,2,3408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',320.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3409,3705,40763,9447,2,3409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1014.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3410,3705,40763,9447,2,3410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',859.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3411,3705,40763,9447,2,3411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',410.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3412,3705,40763,9447,2,3412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',339.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3413,3705,40763,9447,2,3413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',446.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3414,3705,40763,9447,2,3414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',176.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3415,3705,40763,9447,2,3415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',579.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3416,3705,40763,9447,2,3416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',620.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3417,3705,40763,9447,2,3417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',196.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3418,3705,40763,9447,2,3418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',337.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3419,3705,40763,9447,2,3419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',317.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3420,3705,40763,9447,2,3420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',901.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3421,3705,40763,9447,2,3421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',716.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3422,3705,40763,9447,2,3422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',441.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3423,3705,40763,9447,2,3423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',512.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3424,3705,40763,9447,2,3424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',477.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3425,3705,40763,9447,2,3425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',539.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL);
INSERT INTO `balance_libro` VALUES (3426,3705,40763,9447,2,3426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',436.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3427,3705,40763,9447,2,3427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',978.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3428,3705,40763,9447,2,3428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',662.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3429,3705,40763,9447,2,3429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',934.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3430,3705,40763,9447,2,3430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',769.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3431,3705,40763,9447,2,3431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',451.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3432,3705,40763,9447,2,3432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1351.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3433,3705,40763,9447,2,3433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',278.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3434,3705,40763,9447,2,3434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',1495.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3435,3705,40763,9447,2,3435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',675.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3436,3705,40763,9447,2,3436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',351.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3437,3705,40763,9447,2,3437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',384.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3438,3705,40763,9447,2,3438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',291.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3439,3705,40763,9447,2,3439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',559.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3440,3705,40763,9447,2,3440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',557.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3441,3705,40763,9447,2,3441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',486.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3442,3705,40763,9447,2,3442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',862.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3443,3705,40763,9447,2,3443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',1353.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3444,3705,40763,9447,2,3444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',220.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3445,3705,40763,9447,2,3445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',584.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3446,3705,40763,9447,2,3446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',330.00,NULL,NULL,1,'2021-08-05 21:37:15','2021-08-05 21:37:15',NULL),(3447,3705,40763,9447,2,3447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',510.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3448,3705,40763,9447,2,3448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',543.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3449,3705,40763,9447,2,3449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',352.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3450,3705,40763,9447,2,3450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',639.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL);
INSERT INTO `balance_libro` VALUES (3451,3705,40763,9447,2,3451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',393.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3452,3705,40763,9447,2,3452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',152.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3453,3705,40763,9447,2,3453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1025.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3454,3705,40763,9447,2,3454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',663.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3455,3705,40763,9447,2,3455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',3228.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3456,3705,40763,9447,2,3456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',271.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3457,3705,40763,9447,2,3457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',376.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3458,3705,40763,9447,2,3458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',456.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3459,3705,40763,9447,2,3459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',420.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3460,3705,40763,9447,2,3460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',150.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3461,3705,40763,9447,2,3461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',630.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3462,3705,40763,9447,2,3462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',392.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3463,3705,40763,9447,2,3463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',579.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3464,3705,40763,9447,2,3464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',618.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3465,3705,40763,9447,2,3465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',411.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3466,3705,40763,9447,2,3466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',2015.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3467,3705,40763,9447,2,3467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',2871.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3468,3705,40763,9447,2,3468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',682.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3469,3705,40763,9447,2,3469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',595.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3470,3705,40763,9447,2,3470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',467.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3471,3705,40763,9447,2,3471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',646.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3472,3705,40763,9447,2,3472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',514.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3473,3705,40763,9447,2,3473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',909.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3474,3705,40763,9447,2,3474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',75.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3475,3705,40763,9447,2,3475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1363.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL);
INSERT INTO `balance_libro` VALUES (3476,3705,40763,9447,2,3476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',915.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3477,3705,40763,9447,2,3477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',717.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3478,3705,40763,9447,2,3478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',327.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3479,3705,40763,9447,2,3479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',731.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3480,3705,40763,9447,2,3480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1678.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3481,3705,40763,9447,2,3481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',540.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3482,3705,40763,9447,2,3482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',373.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3483,3705,40763,9447,2,3483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',321.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3484,3705,40763,9447,2,3484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',600.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3485,3705,40763,9447,2,3485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',428.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3486,3705,40763,9447,2,3486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',415.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3487,3705,40763,9447,2,3487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1253.00,NULL,NULL,1,'2021-08-05 21:37:16','2021-08-05 21:37:16',NULL),(3488,3705,40763,9447,2,3488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',728.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3489,3705,40763,9447,2,3489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',675.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3490,3705,40763,9447,2,3490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1385.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3491,3705,40763,9447,2,3491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',210.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3492,3705,40763,9447,2,3492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',120.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3493,3705,40763,9447,2,3493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',657.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3494,3705,40763,9447,2,3494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',175.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3495,3705,40763,9447,2,3495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1437.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3496,3705,40763,9447,2,3496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',372.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3497,3705,40763,9447,2,3497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',207.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3498,3705,40763,9447,2,3498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',706.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3499,3705,40763,9447,2,3499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',480.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3500,3705,40763,9447,2,3500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',603.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL);
INSERT INTO `balance_libro` VALUES (3501,3705,40763,9447,2,3501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',660.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3502,3705,40763,9447,2,3502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',510.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3503,3705,40763,9447,2,3503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',762.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3504,3705,40763,9447,2,3504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1351.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3505,3705,40763,9447,2,3505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',438.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3506,3705,40763,9447,2,3506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1033.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3507,3705,40763,9447,2,3507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',844.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3508,3705,40763,9447,2,3508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',497.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3509,3705,40763,9447,2,3509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1200.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3510,3705,40763,9447,2,3510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',1276.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3511,3705,40763,9447,2,3511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',170.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3512,3705,40763,9447,2,3512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-20','2021-03-20',295.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3513,3705,40763,9447,2,3513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',978.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3514,3705,40763,9447,2,3514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',280.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3515,3705,40763,9447,2,3515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-21','2021-03-21',501.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3516,3705,40763,9447,2,3516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1738.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3517,3705,40763,9447,2,3517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',165.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3518,3705,40763,9447,2,3518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',283.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3519,3705,40763,9447,2,3519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',843.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3520,3705,40763,9447,2,3520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',466.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3521,3705,40763,9447,2,3521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',505.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3522,3705,40763,9447,2,3522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',548.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3523,3705,40763,9447,2,3523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',641.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3524,3705,40763,9447,2,3524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',729.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3525,3705,40763,9447,2,3525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',221.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL);
INSERT INTO `balance_libro` VALUES (3526,3705,40763,9447,2,3526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',75.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3527,3705,40763,9447,2,3527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',1278.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3528,3705,40763,9447,2,3528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',662.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3529,3705,40763,9447,2,3529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',215.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3530,3705,40763,9447,2,3530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',550.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3531,3705,40763,9447,2,3531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',644.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3532,3705,40763,9447,2,3532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',915.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3533,3705,40763,9447,2,3533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',360.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3534,3705,40763,9447,2,3534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',147.00,NULL,NULL,1,'2021-08-05 21:37:17','2021-08-05 21:37:17',NULL),(3535,3705,40763,9447,2,3535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',478.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3536,3705,40763,9447,2,3536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',864.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3537,3705,40763,9447,2,3537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',553.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3538,3705,40763,9447,2,3538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',135.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3539,3705,40763,9447,2,3539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',574.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3540,3705,40763,9447,2,3540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',972.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3541,3705,40763,9447,2,3541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',602.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3542,3705,40763,9447,2,3542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',926.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3543,3705,40763,9447,2,3543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',334.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3544,3705,40763,9447,2,3544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',445.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3545,3705,40763,9447,2,3545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',125.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3546,3705,40763,9447,2,3546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',252.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3547,3705,40763,9447,2,3547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-28','2021-03-28',1086.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3548,3705,40763,9447,2,3548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-28','2021-03-28',600.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3549,3705,40763,9447,2,3549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-28','2021-03-28',796.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3550,3705,40763,9447,2,3550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',614.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL);
INSERT INTO `balance_libro` VALUES (3551,3705,40763,9447,2,3551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',205.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3552,3705,40763,9447,2,3552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',1064.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3553,3705,40763,9447,2,3553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',576.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3554,3705,40763,9447,2,3554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',426.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3555,3705,40763,9447,2,3555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',40.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3556,3705,40763,9447,2,3556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',157.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3557,3705,40763,9447,2,3557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',530.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3558,3705,40763,9447,2,3558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',247.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3559,3705,40763,9447,2,3559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',897.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3560,3705,40763,9447,2,3560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',440.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3561,3705,40763,9447,2,3561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',441.00,NULL,NULL,1,'2021-08-05 21:37:18','2021-08-05 21:37:18',NULL),(3562,3705,40763,9447,3,3562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',6516.62,NULL,NULL,1,'2021-08-05 21:38:42','2021-08-05 21:38:42',NULL),(3563,3705,40763,9447,3,3563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',1321.37,NULL,NULL,1,'2021-08-05 21:38:42','2021-08-05 21:38:42',NULL),(3564,3705,40763,9447,3,3564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',8293.20,NULL,NULL,1,'2021-08-05 21:38:42','2021-08-05 21:38:42',NULL),(3565,3705,40763,9447,3,3565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-01','2021-03-01',4452.24,NULL,NULL,1,'2021-08-05 21:38:42','2021-08-05 21:38:42',NULL),(3566,3705,40763,9447,3,3566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',541.01,NULL,NULL,1,'2021-08-05 21:38:42','2021-08-05 21:38:42',NULL),(3567,3705,40763,9447,3,3567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',4474.51,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3568,3705,40763,9447,3,3568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',7279.62,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3569,3705,40763,9447,3,3569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',5847.92,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3570,3705,40763,9447,3,3570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',1864.20,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3571,3705,40763,9447,3,3571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',4687.04,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3572,3705,40763,9447,3,3572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',0.13,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3573,3705,40763,9447,3,3573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',378.48,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3574,3705,40763,9447,3,3574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-02','2021-03-02',17210.01,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL);
INSERT INTO `balance_libro` VALUES (3575,3705,40763,9447,3,3575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',12100.00,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3576,3705,40763,9447,3,3576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',15013.00,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3577,3705,40763,9447,3,3577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',3831.53,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3578,3705,40763,9447,3,3578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',7626.21,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3579,3705,40763,9447,3,3579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-03','2021-03-03',4925.42,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3580,3705,40763,9447,3,3580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',14800.54,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3581,3705,40763,9447,3,3581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',8032.60,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3582,3705,40763,9447,3,3582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-04','2021-03-04',3626.11,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3583,3705,40763,9447,3,3583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',9036.58,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3584,3705,40763,9447,3,3584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',13367.69,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3585,3705,40763,9447,3,3585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-05','2021-03-05',5877.68,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3586,3705,40763,9447,3,3586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',452.94,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3587,3705,40763,9447,3,3587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',6051.84,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3588,3705,40763,9447,3,3588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',9733.90,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3589,3705,40763,9447,3,3589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',6095.14,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3590,3705,40763,9447,3,3590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',6095.14,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3591,3705,40763,9447,3,3591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-08','2021-03-08',6401.74,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3592,3705,40763,9447,3,3592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',11330.25,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3593,3705,40763,9447,3,3593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',10699.14,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3594,3705,40763,9447,3,3594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',10247.52,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3595,3705,40763,9447,3,3595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-09','2021-03-09',14989.24,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3596,3705,40763,9447,3,3596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',6416.27,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3597,3705,40763,9447,3,3597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',7442.87,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3598,3705,40763,9447,3,3598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',7641.09,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL);
INSERT INTO `balance_libro` VALUES (3599,3705,40763,9447,3,3599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',14659.27,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3600,3705,40763,9447,3,3600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-10','2021-03-10',1176.20,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3601,3705,40763,9447,3,3601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',1700.13,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3602,3705,40763,9447,3,3602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',6761.05,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3603,3705,40763,9447,3,3603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-11','2021-03-11',2547.91,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3604,3705,40763,9447,3,3604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',11925.23,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3605,3705,40763,9447,3,3605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',8105.92,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3606,3705,40763,9447,3,3606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',21257.45,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3607,3705,40763,9447,3,3607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',7496.85,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3608,3705,40763,9447,3,3608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',9079.79,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3609,3705,40763,9447,3,3609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-12','2021-03-12',58.18,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3610,3705,40763,9447,3,3610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',17045.38,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3611,3705,40763,9447,3,3611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',5224.55,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3612,3705,40763,9447,3,3612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',9508.91,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3613,3705,40763,9447,3,3613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',7959.75,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3614,3705,40763,9447,3,3614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-15','2021-03-15',4080.32,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3615,3705,40763,9447,3,3615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',0.13,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3616,3705,40763,9447,3,3616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',4205.81,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3617,3705,40763,9447,3,3617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',1310.92,NULL,NULL,1,'2021-08-05 21:38:43','2021-08-05 21:38:43',NULL),(3618,3705,40763,9447,3,3618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',2503.46,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3619,3705,40763,9447,3,3619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-16','2021-03-16',8018.71,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3620,3705,40763,9447,3,3620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',6452.29,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3621,3705,40763,9447,3,3621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',6687.49,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3622,3705,40763,9447,3,3622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-17','2021-03-17',9335.08,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL);
INSERT INTO `balance_libro` VALUES (3623,3705,40763,9447,3,3623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',7285.22,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3624,3705,40763,9447,3,3624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',1510.85,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3625,3705,40763,9447,3,3625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',11635.26,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3626,3705,40763,9447,3,3626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-18','2021-03-18',613.25,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3627,3705,40763,9447,3,3627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4559.90,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3628,3705,40763,9447,3,3628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',13368.41,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3629,3705,40763,9447,3,3629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',16285.55,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3630,3705,40763,9447,3,3630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',4341.72,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3631,3705,40763,9447,3,3631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1937.88,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3632,3705,40763,9447,3,3632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',12706.23,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3633,3705,40763,9447,3,3633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',7455.75,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3634,3705,40763,9447,3,3634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',6916.42,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3635,3705,40763,9447,3,3635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-19','2021-03-19',1790.00,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3636,3705,40763,9447,3,3636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',8777.00,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3637,3705,40763,9447,3,3637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',8031.20,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3638,3705,40763,9447,3,3638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',3072.43,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3639,3705,40763,9447,3,3639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1776.39,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3640,3705,40763,9447,3,3640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1607.48,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3641,3705,40763,9447,3,3641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',3696.13,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3642,3705,40763,9447,3,3642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',1520.61,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3643,3705,40763,9447,3,3643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',4384.79,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3644,3705,40763,9447,3,3644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',4668.59,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3645,3705,40763,9447,3,3645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',6886.61,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3646,3705,40763,9447,3,3646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',8358.24,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL);
INSERT INTO `balance_libro` VALUES (3647,3705,40763,9447,3,3647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',9436.16,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3648,3705,40763,9447,3,3648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',2369.85,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3649,3705,40763,9447,3,3649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-22','2021-03-22',6508.00,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3650,3705,40763,9447,3,3650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',2955.23,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3651,3705,40763,9447,3,3651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',17552.36,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3652,3705,40763,9447,3,3652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',8769.98,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3653,3705,40763,9447,3,3653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',4133.71,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3654,3705,40763,9447,3,3654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-23','2021-03-23',7522.86,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3655,3705,40763,9447,3,3655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',6791.32,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3656,3705,40763,9447,3,3656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',0.08,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3657,3705,40763,9447,3,3657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',2220.24,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3658,3705,40763,9447,3,3658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-24','2021-03-24',414.62,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3659,3705,40763,9447,3,3659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',8303.43,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3660,3705,40763,9447,3,3660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',9538.13,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3661,3705,40763,9447,3,3661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',12163.46,NULL,NULL,1,'2021-08-05 21:38:44','2021-08-05 21:38:44',NULL),(3662,3705,40763,9447,3,3662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-25','2021-03-25',1684.79,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3663,3705,40763,9447,3,3663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',18885.35,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3664,3705,40763,9447,3,3664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',5927.14,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3665,3705,40763,9447,3,3665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',3851.01,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3666,3705,40763,9447,3,3666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',4091.41,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3667,3705,40763,9447,3,3667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-26','2021-03-26',11769.47,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3668,3705,40763,9447,3,3668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',8348.86,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3669,3705,40763,9447,3,3669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-27','2021-03-27',1604.95,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3670,3705,40763,9447,3,3670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',4882.73,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL);
INSERT INTO `balance_libro` VALUES (3671,3705,40763,9447,3,3671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',13105.64,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3672,3705,40763,9447,3,3672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',2512.44,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3673,3705,40763,9447,3,3673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',328.93,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3674,3705,40763,9447,3,3674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',367.78,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3675,3705,40763,9447,3,3675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-29','2021-03-29',2614.00,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3676,3705,40763,9447,3,3676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',2936.95,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3677,3705,40763,9447,3,3677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',6138.44,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3678,3705,40763,9447,3,3678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-30','2021-03-30',15991.41,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3679,3705,40763,9447,3,3679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',4088.95,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3680,3705,40763,9447,3,3680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',9054.87,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3681,3705,40763,9447,3,3681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',18691.92,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3682,3705,40763,9447,3,3682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-03-31','2021-03-31',903.99,NULL,NULL,1,'2021-08-05 21:38:45','2021-08-05 21:38:45',NULL),(3683,3705,40763,9448,2,3683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',883.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3684,3705,40763,9448,2,3684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2076.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3685,3705,40763,9448,2,3685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',1062.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3686,3705,40763,9448,2,3686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',235.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3687,3705,40763,9448,2,3687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',386.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3688,3705,40763,9448,2,3688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-02','2021-04-02',2755.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3689,3705,40763,9448,2,3689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',1421.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3690,3705,40763,9448,2,3690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',520.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3691,3705,40763,9448,2,3691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',418.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3692,3705,40763,9448,2,3692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',185.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3693,3705,40763,9448,2,3693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',202.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3694,3705,40763,9448,2,3694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',192.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL);
INSERT INTO `balance_libro` VALUES (3695,3705,40763,9448,2,3695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',158.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3696,3705,40763,9448,2,3696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',715.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3697,3705,40763,9448,2,3697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',874.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3698,3705,40763,9448,2,3698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',570.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3699,3705,40763,9448,2,3699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1289.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3700,3705,40763,9448,2,3700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',382.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3701,3705,40763,9448,2,3701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1749.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3702,3705,40763,9448,2,3702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-08','2021-04-08',449.00,NULL,NULL,1,'2021-08-05 21:40:19','2021-08-05 21:40:19',NULL),(3703,3705,40763,9448,2,3703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',320.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3704,3705,40763,9448,2,3704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',344.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3705,3705,40763,9448,2,3705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',509.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3706,3705,40763,9448,2,3706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',130.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3707,3705,40763,9448,2,3707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',601.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3708,3705,40763,9448,2,3708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',777.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3709,3705,40763,9448,2,3709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',449.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3710,3705,40763,9448,2,3710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',713.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3711,3705,40763,9448,2,3711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',155.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3712,3705,40763,9448,2,3712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',803.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3713,3705,40763,9448,2,3713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',193.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3714,3705,40763,9448,2,3714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',767.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3715,3705,40763,9448,2,3715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',406.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3716,3705,40763,9448,2,3716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',390.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3717,3705,40763,9448,2,3717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',291.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3718,3705,40763,9448,2,3718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',375.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3719,3705,40763,9448,2,3719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1396.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL);
INSERT INTO `balance_libro` VALUES (3720,3705,40763,9448,2,3720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',425.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3721,3705,40763,9448,2,3721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',407.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3722,3705,40763,9448,2,3722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',583.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3723,3705,40763,9448,2,3723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',389.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3724,3705,40763,9448,2,3724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',143.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3725,3705,40763,9448,2,3725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',662.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3726,3705,40763,9448,2,3726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',579.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3727,3705,40763,9448,2,3727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',305.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3728,3705,40763,9448,2,3728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',248.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3729,3705,40763,9448,2,3729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',497.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3730,3705,40763,9448,2,3730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',459.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3731,3705,40763,9448,2,3731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',195.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3732,3705,40763,9448,2,3732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',338.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3733,3705,40763,9448,2,3733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',395.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3734,3705,40763,9448,2,3734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',566.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3735,3705,40763,9448,2,3735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',866.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3736,3705,40763,9448,2,3736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2023.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3737,3705,40763,9448,2,3737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',530.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3738,3705,40763,9448,2,3738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',811.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3739,3705,40763,9448,2,3739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',989.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3740,3705,40763,9448,2,3740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',316.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3741,3705,40763,9448,2,3741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',518.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3742,3705,40763,9448,2,3742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',405.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3743,3705,40763,9448,2,3743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',241.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3744,3705,40763,9448,2,3744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',578.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL);
INSERT INTO `balance_libro` VALUES (3745,3705,40763,9448,2,3745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',1021.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3746,3705,40763,9448,2,3746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',238.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3747,3705,40763,9448,2,3747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',435.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3748,3705,40763,9448,2,3748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',602.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3749,3705,40763,9448,2,3749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',454.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3750,3705,40763,9448,2,3750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',524.00,NULL,NULL,1,'2021-08-05 21:40:20','2021-08-05 21:40:20',NULL),(3751,3705,40763,9448,2,3751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',362.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3752,3705,40763,9448,2,3752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',1375.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3753,3705,40763,9448,2,3753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',287.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3754,3705,40763,9448,2,3754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',450.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3755,3705,40763,9448,2,3755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',332.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3756,3705,40763,9448,2,3756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',820.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3757,3705,40763,9448,2,3757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',406.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3758,3705,40763,9448,2,3758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',374.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3759,3705,40763,9448,2,3759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',199.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3760,3705,40763,9448,2,3760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',901.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3761,3705,40763,9448,2,3761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',364.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3762,3705,40763,9448,2,3762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',356.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3763,3705,40763,9448,2,3763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',690.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3764,3705,40763,9448,2,3764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',426.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3765,3705,40763,9448,2,3765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',617.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3766,3705,40763,9448,2,3766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',248.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3767,3705,40763,9448,2,3767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',129.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3768,3705,40763,9448,2,3768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',320.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL),(3769,3705,40763,9448,2,3769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',785.00,NULL,NULL,1,'2021-08-05 21:40:21','2021-08-05 21:40:21',NULL);
INSERT INTO `balance_libro` VALUES (3770,3705,40763,9448,3,3770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',6794.00,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3771,3705,40763,9448,3,3771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2359.85,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3772,3705,40763,9448,3,3772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',2557.99,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3773,3705,40763,9448,3,3773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-01','2021-04-01',0.13,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3774,3705,40763,9448,3,3774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-02','2021-04-02',12862.07,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3775,3705,40763,9448,3,3775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-02','2021-04-02',12707.21,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3776,3705,40763,9448,3,3776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-02','2021-04-02',4100.74,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3777,3705,40763,9448,3,3777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',12386.88,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3778,3705,40763,9448,3,3778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',10253.98,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3779,3705,40763,9448,3,3779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',12114.47,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3780,3705,40763,9448,3,3780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',10289.50,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3781,3705,40763,9448,3,3781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-03','2021-04-03',199.03,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3782,3705,40763,9448,3,3782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',18453.04,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3783,3705,40763,9448,3,3783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',3208.84,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3784,3705,40763,9448,3,3784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',6439.04,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3785,3705,40763,9448,3,3785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',9144.80,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3786,3705,40763,9448,3,3786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-05','2021-04-05',2661.00,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3787,3705,40763,9448,3,3787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',8101.99,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3788,3705,40763,9448,3,3788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',2337.33,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3789,3705,40763,9448,3,3789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',5910.58,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3790,3705,40763,9448,3,3790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',2732.95,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3791,3705,40763,9448,3,3791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',1833.44,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3792,3705,40763,9448,3,3792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',22719.96,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3793,3705,40763,9448,3,3793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',2570.28,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL);
INSERT INTO `balance_libro` VALUES (3794,3705,40763,9448,3,3794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-06','2021-04-06',4315.51,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3795,3705,40763,9448,3,3795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',1499.00,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3796,3705,40763,9448,3,3796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',12100.00,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3797,3705,40763,9448,3,3797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',8015.38,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3798,3705,40763,9448,3,3798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-07','2021-04-07',7862.78,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3799,3705,40763,9448,3,3799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',18464.53,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3800,3705,40763,9448,3,3800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',9750.49,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3801,3705,40763,9448,3,3801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',20587.54,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3802,3705,40763,9448,3,3802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-09','2021-04-09',3023.06,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3803,3705,40763,9448,3,3803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',6353.88,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3804,3705,40763,9448,3,3804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-10','2021-04-10',13975.24,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3805,3705,40763,9448,3,3805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',24804.28,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3806,3705,40763,9448,3,3806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',5363.96,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3807,3705,40763,9448,3,3807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',4343.10,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3808,3705,40763,9448,3,3808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',789.00,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3809,3705,40763,9448,3,3809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',5246.05,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3810,3705,40763,9448,3,3810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',15528.47,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3811,3705,40763,9448,3,3811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-12','2021-04-12',5279.00,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3812,3705,40763,9448,3,3812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',14409.52,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3813,3705,40763,9448,3,3813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',4930.35,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3814,3705,40763,9448,3,3814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',8471.11,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3815,3705,40763,9448,3,3815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',0.13,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3816,3705,40763,9448,3,3816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',1618.33,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3817,3705,40763,9448,3,3817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2483.39,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL);
INSERT INTO `balance_libro` VALUES (3818,3705,40763,9448,3,3818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',412.32,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3819,3705,40763,9448,3,3819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-13','2021-04-13',2899.60,NULL,NULL,1,'2021-08-05 21:41:27','2021-08-05 21:41:27',NULL),(3820,3705,40763,9448,3,3820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',8765.55,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3821,3705,40763,9448,3,3821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',1502.02,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3822,3705,40763,9448,3,3822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',5933.11,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3823,3705,40763,9448,3,3823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4418.66,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3824,3705,40763,9448,3,3824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',4279.22,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3825,3705,40763,9448,3,3825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',10647.25,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3826,3705,40763,9448,3,3826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-14','2021-04-14',227.44,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3827,3705,40763,9448,3,3827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',4546.70,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3828,3705,40763,9448,3,3828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',2473.19,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3829,3705,40763,9448,3,3829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-15','2021-04-15',28576.04,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3830,3705,40763,9448,3,3830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',8500.98,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3831,3705,40763,9448,3,3831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',10117.55,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3832,3705,40763,9448,3,3832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',2850.09,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3833,3705,40763,9448,3,3833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-16','2021-04-16',14119.37,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3834,3705,40763,9448,3,3834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-17','2021-04-17',8743.78,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3835,3705,40763,9448,3,3835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',28576.04,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3836,3705,40763,9448,3,3836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',2473.19,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3837,3705,40763,9448,3,3837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',11191.56,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3838,3705,40763,9448,3,3838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',10593.50,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3839,3705,40763,9448,3,3839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-19','2021-04-19',5786.99,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3840,3705,40763,9448,3,3840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',1739.62,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3841,3705,40763,9448,3,3841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',1643.85,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL);
INSERT INTO `balance_libro` VALUES (3842,3705,40763,9448,3,3842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',7197.73,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3843,3705,40763,9448,3,3843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',13170.51,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3844,3705,40763,9448,3,3844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',944.68,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3845,3705,40763,9448,3,3845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-20','2021-04-20',10517.85,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3846,3705,40763,9448,3,3846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',468.99,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3847,3705,40763,9448,3,3847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',9099.25,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3848,3705,40763,9448,3,3848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',30031.76,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3849,3705,40763,9448,3,3849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',7403.89,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3850,3705,40763,9448,3,3850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-21','2021-04-21',7810.45,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3851,3705,40763,9448,3,3851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',2473.19,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3852,3705,40763,9448,3,3852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',28576.04,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3853,3705,40763,9448,3,3853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',2633.13,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3854,3705,40763,9448,3,3854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',1911.00,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3855,3705,40763,9448,3,3855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',0.10,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3856,3705,40763,9448,3,3856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',719.61,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3857,3705,40763,9448,3,3857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',3872.75,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3858,3705,40763,9448,3,3858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-22','2021-04-22',2124.00,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3859,3705,40763,9448,3,3859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',11211.33,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3860,3705,40763,9448,3,3860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',5650.68,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3861,3705,40763,9448,3,3861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1507.50,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3862,3705,40763,9448,3,3862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',8174.76,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3863,3705,40763,9448,3,3863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',17336.14,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3864,3705,40763,9448,3,3864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-23','2021-04-23',1104.43,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL),(3865,3705,40763,9448,3,3865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',9777.36,NULL,NULL,1,'2021-08-05 21:41:28','2021-08-05 21:41:28',NULL);
INSERT INTO `balance_libro` VALUES (3866,3705,40763,9448,3,3866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-24','2021-04-24',3132.07,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3867,3705,40763,9448,3,3867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',16518.16,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3868,3705,40763,9448,3,3868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',1180.11,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3869,3705,40763,9448,3,3869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',737.62,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3870,3705,40763,9448,3,3870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',7793.80,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3871,3705,40763,9448,3,3871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',5560.00,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3872,3705,40763,9448,3,3872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',9490.87,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3873,3705,40763,9448,3,3873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-26','2021-04-26',4553.47,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3874,3705,40763,9448,3,3874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',2260.69,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3875,3705,40763,9448,3,3875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',833.84,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3876,3705,40763,9448,3,3876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-27','2021-04-27',20365.01,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3877,3705,40763,9448,3,3877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',1627.57,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3878,3705,40763,9448,3,3878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',177.74,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3879,3705,40763,9448,3,3879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',2374.70,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3880,3705,40763,9448,3,3880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',7771.82,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3881,3705,40763,9448,3,3881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-28','2021-04-28',9331.77,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3882,3705,40763,9448,3,3882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-29','2021-04-29',2.37,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3883,3705,40763,9448,3,3883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',12809.46,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3884,3705,40763,9448,3,3884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',2271.65,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3885,3705,40763,9448,3,3885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',0.00,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3886,3705,40763,9448,3,3886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-04-30','2021-04-30',12852.60,NULL,NULL,1,'2021-08-05 21:41:29','2021-08-05 21:41:29',NULL),(3887,3705,40763,9449,2,3887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',276.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3888,3705,40763,9449,2,3888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',233.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3889,3705,40763,9449,2,3889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',913.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL);
INSERT INTO `balance_libro` VALUES (3890,3705,40763,9449,2,3890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',457.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3891,3705,40763,9449,2,3891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',768.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3892,3705,40763,9449,2,3892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',752.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3893,3705,40763,9449,2,3893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',270.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3894,3705,40763,9449,2,3894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',483.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3895,3705,40763,9449,2,3895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',80.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3896,3705,40763,9449,2,3896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',812.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3897,3705,40763,9449,2,3897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',267.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3898,3705,40763,9449,2,3898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',1101.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3899,3705,40763,9449,2,3899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',645.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3900,3705,40763,9449,2,3900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',56.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3901,3705,40763,9449,2,3901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',148.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3902,3705,40763,9449,2,3902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',444.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3903,3705,40763,9449,2,3903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',155.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3904,3705,40763,9449,2,3904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',771.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3905,3705,40763,9449,2,3905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',286.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3906,3705,40763,9449,2,3906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',1784.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3907,3705,40763,9449,2,3907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',807.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3908,3705,40763,9449,2,3908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',314.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3909,3705,40763,9449,2,3909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',963.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3910,3705,40763,9449,2,3910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',255.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3911,3705,40763,9449,2,3911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',442.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3912,3705,40763,9449,2,3912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',706.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3913,3705,40763,9449,2,3913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',369.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3914,3705,40763,9449,2,3914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',926.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL);
INSERT INTO `balance_libro` VALUES (3915,3705,40763,9449,2,3915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',672.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3916,3705,40763,9449,2,3916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',420.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3917,3705,40763,9449,2,3917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',160.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3918,3705,40763,9449,2,3918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',771.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3919,3705,40763,9449,2,3919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',614.00,NULL,NULL,1,'2021-08-05 21:42:56','2021-08-05 21:42:56',NULL),(3920,3705,40763,9449,2,3920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',431.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3921,3705,40763,9449,2,3921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',288.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3922,3705,40763,9449,2,3922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',245.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3923,3705,40763,9449,2,3923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',430.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3924,3705,40763,9449,2,3924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',1150.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3925,3705,40763,9449,2,3925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',1038.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3926,3705,40763,9449,2,3926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',908.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3927,3705,40763,9449,2,3927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',608.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3928,3705,40763,9449,2,3928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',645.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3929,3705,40763,9449,2,3929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',410.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3930,3705,40763,9449,2,3930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',568.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3931,3705,40763,9449,2,3931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',933.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3932,3705,40763,9449,2,3932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',624.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3933,3705,40763,9449,2,3933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',360.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3934,3705,40763,9449,2,3934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',565.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3935,3705,40763,9449,2,3935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',537.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3936,3705,40763,9449,2,3936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',1008.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3937,3705,40763,9449,2,3937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',943.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3938,3705,40763,9449,2,3938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',230.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3939,3705,40763,9449,2,3939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',560.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL);
INSERT INTO `balance_libro` VALUES (3940,3705,40763,9449,2,3940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',1192.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3941,3705,40763,9449,2,3941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',289.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3942,3705,40763,9449,2,3942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',457.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3943,3705,40763,9449,2,3943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-09','2021-05-09',452.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3944,3705,40763,9449,2,3944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',287.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3945,3705,40763,9449,2,3945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',327.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3946,3705,40763,9449,2,3946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',156.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3947,3705,40763,9449,2,3947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',407.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3948,3705,40763,9449,2,3948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',979.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3949,3705,40763,9449,2,3949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',620.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3950,3705,40763,9449,2,3950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',265.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3951,3705,40763,9449,2,3951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',372.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3952,3705,40763,9449,2,3952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',215.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3953,3705,40763,9449,2,3953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',773.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3954,3705,40763,9449,2,3954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',703.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3955,3705,40763,9449,2,3955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',703.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3956,3705,40763,9449,2,3956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',494.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3957,3705,40763,9449,2,3957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',1793.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3958,3705,40763,9449,2,3958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',312.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3959,3705,40763,9449,2,3959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',342.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3960,3705,40763,9449,2,3960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',2211.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3961,3705,40763,9449,2,3961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',340.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3962,3705,40763,9449,2,3962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',786.00,NULL,NULL,1,'2021-08-05 21:42:57','2021-08-05 21:42:57',NULL),(3963,3705,40763,9449,2,3963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',3359.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3964,3705,40763,9449,2,3964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',622.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL);
INSERT INTO `balance_libro` VALUES (3965,3705,40763,9449,2,3965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',595.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3966,3705,40763,9449,2,3966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',371.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3967,3705,40763,9449,2,3967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',691.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3968,3705,40763,9449,2,3968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',562.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3969,3705,40763,9449,2,3969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',160.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3970,3705,40763,9449,2,3970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',523.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3971,3705,40763,9449,2,3971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',523.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3972,3705,40763,9449,2,3972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',833.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3973,3705,40763,9449,2,3973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',532.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3974,3705,40763,9449,2,3974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',509.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3975,3705,40763,9449,2,3975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',140.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3976,3705,40763,9449,2,3976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',915.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3977,3705,40763,9449,2,3977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',541.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3978,3705,40763,9449,2,3978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',222.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3979,3705,40763,9449,2,3979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',321.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3980,3705,40763,9449,2,3980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',383.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3981,3705,40763,9449,2,3981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',548.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3982,3705,40763,9449,2,3982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',371.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3983,3705,40763,9449,2,3983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',377.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3984,3705,40763,9449,2,3984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',425.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3985,3705,40763,9449,2,3985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',1020.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3986,3705,40763,9449,2,3986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',519.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3987,3705,40763,9449,2,3987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',1892.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3988,3705,40763,9449,2,3988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',649.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3989,3705,40763,9449,2,3989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',766.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL);
INSERT INTO `balance_libro` VALUES (3990,3705,40763,9449,2,3990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-16','2021-05-16',2829.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3991,3705,40763,9449,2,3991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',1884.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3992,3705,40763,9449,2,3992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',353.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3993,3705,40763,9449,2,3993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',711.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3994,3705,40763,9449,2,3994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',482.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3995,3705,40763,9449,2,3995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',1114.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3996,3705,40763,9449,2,3996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',442.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3997,3705,40763,9449,2,3997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',338.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3998,3705,40763,9449,2,3998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',715.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(3999,3705,40763,9449,2,3999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',1341.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(4000,3705,40763,9449,2,4000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',971.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(4001,3705,40763,9449,2,4001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',710.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(4002,3705,40763,9449,2,4002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',760.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(4003,3705,40763,9449,2,4003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',184.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(4004,3705,40763,9449,2,4004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',250.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(4005,3705,40763,9449,2,4005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',523.00,NULL,NULL,1,'2021-08-05 21:42:58','2021-08-05 21:42:58',NULL),(4006,3705,40763,9449,2,4006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-18','2021-05-18',502.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4007,3705,40763,9449,2,4007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',435.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4008,3705,40763,9449,2,4008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',553.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4009,3705,40763,9449,2,4009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',375.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4010,3705,40763,9449,2,4010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',572.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4011,3705,40763,9449,2,4011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',856.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4012,3705,40763,9449,2,4012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',946.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4013,3705,40763,9449,2,4013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',1896.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4014,3705,40763,9449,2,4014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',561.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL);
INSERT INTO `balance_libro` VALUES (4015,3705,40763,9449,2,4015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',298.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4016,3705,40763,9449,2,4016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',926.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4017,3705,40763,9449,2,4017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',228.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4018,3705,40763,9449,2,4018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',187.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4019,3705,40763,9449,2,4019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',860.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4020,3705,40763,9449,2,4020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',887.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4021,3705,40763,9449,2,4021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',1030.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4022,3705,40763,9449,2,4022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',372.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4023,3705,40763,9449,2,4023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',260.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4024,3705,40763,9449,2,4024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',619.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4025,3705,40763,9449,2,4025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',205.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4026,3705,40763,9449,2,4026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',1439.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4027,3705,40763,9449,2,4027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',499.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4028,3705,40763,9449,2,4028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',447.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4029,3705,40763,9449,2,4029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',310.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4030,3705,40763,9449,2,4030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',290.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4031,3705,40763,9449,2,4031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',3539.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4032,3705,40763,9449,2,4032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',348.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4033,3705,40763,9449,2,4033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',2199.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4034,3705,40763,9449,2,4034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',1371.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4035,3705,40763,9449,2,4035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',345.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4036,3705,40763,9449,2,4036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',736.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4037,3705,40763,9449,2,4037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',625.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4038,3705,40763,9449,2,4038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',439.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4039,3705,40763,9449,2,4039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',507.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL);
INSERT INTO `balance_libro` VALUES (4040,3705,40763,9449,2,4040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',960.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4041,3705,40763,9449,2,4041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',944.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4042,3705,40763,9449,2,4042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',274.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4043,3705,40763,9449,2,4043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',764.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4044,3705,40763,9449,2,4044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',769.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4045,3705,40763,9449,2,4045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',1353.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4046,3705,40763,9449,2,4046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',894.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4047,3705,40763,9449,2,4047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',950.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4048,3705,40763,9449,2,4048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',741.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4049,3705,40763,9449,2,4049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',568.00,NULL,NULL,1,'2021-08-05 21:42:59','2021-08-05 21:42:59',NULL),(4050,3705,40763,9449,2,4050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',828.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4051,3705,40763,9449,2,4051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',753.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4052,3705,40763,9449,2,4052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-23','2021-05-23',528.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4053,3705,40763,9449,2,4053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-23','2021-05-23',931.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4054,3705,40763,9449,2,4054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-23','2021-05-23',532.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4055,3705,40763,9449,2,4055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-23','2021-05-23',1092.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4056,3705,40763,9449,2,4056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-23','2021-05-23',824.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4057,3705,40763,9449,2,4057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',852.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4058,3705,40763,9449,2,4058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',100.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4059,3705,40763,9449,2,4059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',788.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4060,3705,40763,9449,2,4060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',764.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4061,3705,40763,9449,2,4061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',1194.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4062,3705,40763,9449,2,4062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',958.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4063,3705,40763,9449,2,4063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',675.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4064,3705,40763,9449,2,4064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',623.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL);
INSERT INTO `balance_libro` VALUES (4065,3705,40763,9449,2,4065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',981.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4066,3705,40763,9449,2,4066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',607.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4067,3705,40763,9449,2,4067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',677.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4068,3705,40763,9449,2,4068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',220.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4069,3705,40763,9449,2,4069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',280.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4070,3705,40763,9449,2,4070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',217.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4071,3705,40763,9449,2,4071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',529.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4072,3705,40763,9449,2,4072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',559.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4073,3705,40763,9449,2,4073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',628.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4074,3705,40763,9449,2,4074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',1596.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4075,3705,40763,9449,2,4075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',615.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4076,3705,40763,9449,2,4076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',289.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4077,3705,40763,9449,2,4077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-25','2021-05-25',193.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4078,3705,40763,9449,2,4078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-25','2021-05-25',365.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4079,3705,40763,9449,2,4079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-25','2021-05-25',657.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4080,3705,40763,9449,2,4080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',272.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4081,3705,40763,9449,2,4081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',215.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4082,3705,40763,9449,2,4082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',466.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4083,3705,40763,9449,2,4083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',265.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4084,3705,40763,9449,2,4084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',251.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4085,3705,40763,9449,2,4085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',744.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4086,3705,40763,9449,2,4086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',185.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4087,3705,40763,9449,2,4087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',503.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4088,3705,40763,9449,2,4088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',782.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL),(4089,3705,40763,9449,2,4089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',800.00,NULL,NULL,1,'2021-08-05 21:43:00','2021-08-05 21:43:00',NULL);
INSERT INTO `balance_libro` VALUES (4090,3705,40763,9449,2,4090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',1041.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4091,3705,40763,9449,2,4091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',280.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4092,3705,40763,9449,2,4092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',438.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4093,3705,40763,9449,2,4093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',2135.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4094,3705,40763,9449,2,4094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',739.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4095,3705,40763,9449,2,4095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',339.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4096,3705,40763,9449,2,4096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',280.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4097,3705,40763,9449,2,4097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',182.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4098,3705,40763,9449,2,4098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',965.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4099,3705,40763,9449,2,4099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',693.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4100,3705,40763,9449,2,4100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',184.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4101,3705,40763,9449,2,4101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',454.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4102,3705,40763,9449,2,4102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',869.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4103,3705,40763,9449,2,4103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',412.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4104,3705,40763,9449,2,4104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',200.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4105,3705,40763,9449,2,4105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',245.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4106,3705,40763,9449,2,4106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1987.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4107,3705,40763,9449,2,4107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',821.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4108,3705,40763,9449,2,4108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1529.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4109,3705,40763,9449,2,4109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',351.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4110,3705,40763,9449,2,4110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',790.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4111,3705,40763,9449,2,4111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',917.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4112,3705,40763,9449,2,4112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',1216.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4113,3705,40763,9449,2,4113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',134.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4114,3705,40763,9449,2,4114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',795.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL);
INSERT INTO `balance_libro` VALUES (4115,3705,40763,9449,2,4115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1300.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4116,3705,40763,9449,2,4116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',445.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4117,3705,40763,9449,2,4117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',542.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4118,3705,40763,9449,2,4118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',647.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4119,3705,40763,9449,2,4119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',2001.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4120,3705,40763,9449,2,4120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',325.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4121,3705,40763,9449,2,4121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1342.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4122,3705,40763,9449,2,4122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',599.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4123,3705,40763,9449,2,4123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',460.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4124,3705,40763,9449,2,4124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',500.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4125,3705,40763,9449,2,4125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',597.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4126,3705,40763,9449,2,4126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',584.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4127,3705,40763,9449,2,4127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',379.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4128,3705,40763,9449,2,4128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',467.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4129,3705,40763,9449,2,4129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',350.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4130,3705,40763,9449,2,4130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',542.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4131,3705,40763,9449,2,4131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',2221.00,NULL,NULL,1,'2021-08-05 21:43:01','2021-08-05 21:43:01',NULL),(4132,3705,40763,9449,2,4132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',2331.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4133,3705,40763,9449,2,4133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',788.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4134,3705,40763,9449,2,4134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',360.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4135,3705,40763,9449,2,4135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',1642.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4136,3705,40763,9449,2,4136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',554.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4137,3705,40763,9449,2,4137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',703.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4138,3705,40763,9449,2,4138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1908.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL);
INSERT INTO `balance_libro` VALUES (4139,3705,40763,9449,2,4139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1100.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4140,3705,40763,9449,2,4140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',472.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4141,3705,40763,9449,2,4141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',617.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4142,3705,40763,9449,2,4142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',278.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4143,3705,40763,9449,2,4143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',553.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4144,3705,40763,9449,2,4144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',807.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4145,3705,40763,9449,2,4145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',946.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4146,3705,40763,9449,2,4146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',273.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4147,3705,40763,9449,2,4147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',346.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4148,3705,40763,9449,2,4148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1477.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4149,3705,40763,9449,2,4149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1506.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4150,3705,40763,9449,2,4150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',304.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4151,3705,40763,9449,2,4151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1151.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4152,3705,40763,9449,2,4152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',776.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4153,3705,40763,9449,2,4153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1638.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4154,3705,40763,9449,2,4154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',246.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4155,3705,40763,9449,2,4155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1341.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4156,3705,40763,9449,2,4156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',430.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4157,3705,40763,9449,2,4157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1983.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4158,3705,40763,9449,2,4158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1128.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4159,3705,40763,9449,2,4159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1020.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4160,3705,40763,9449,2,4160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1270.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4161,3705,40763,9449,2,4161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',821.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4162,3705,40763,9449,2,4162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',1231.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL);
INSERT INTO `balance_libro` VALUES (4163,3705,40763,9449,2,4163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',899.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4164,3705,40763,9449,2,4164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',894.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4165,3705,40763,9449,2,4165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',727.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4166,3705,40763,9449,2,4166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',737.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4167,3705,40763,9449,2,4167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',1012.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4168,3705,40763,9449,2,4168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',282.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4169,3705,40763,9449,2,4169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',1407.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4170,3705,40763,9449,2,4170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',672.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4171,3705,40763,9449,2,4171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',830.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4172,3705,40763,9449,2,4172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',530.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4173,3705,40763,9449,2,4173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',528.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4174,3705,40763,9449,2,4174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',294.00,NULL,NULL,1,'2021-08-05 21:43:02','2021-08-05 21:43:02',NULL),(4175,3705,40763,9449,2,4175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',213.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4176,3705,40763,9449,2,4176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',845.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4177,3705,40763,9449,2,4177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',570.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4178,3705,40763,9449,2,4178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',432.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4179,3705,40763,9449,2,4179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',958.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4180,3705,40763,9449,2,4180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',917.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4181,3705,40763,9449,2,4181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',370.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4182,3705,40763,9449,2,4182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1672.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4183,3705,40763,9449,2,4183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',642.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4184,3705,40763,9449,2,4184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',535.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4185,3705,40763,9449,2,4185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',729.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4186,3705,40763,9449,2,4186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1504.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4187,3705,40763,9449,2,4187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',428.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL);
INSERT INTO `balance_libro` VALUES (4188,3705,40763,9449,2,4188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',710.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4189,3705,40763,9449,2,4189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1466.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4190,3705,40763,9449,2,4190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',314.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4191,3705,40763,9449,2,4191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',400.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4192,3705,40763,9449,2,4192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1199.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4193,3705,40763,9449,2,4193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',614.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4194,3705,40763,9449,2,4194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1107.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4195,3705,40763,9449,2,4195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',300.00,NULL,NULL,1,'2021-08-05 21:43:03','2021-08-05 21:43:03',NULL),(4196,3705,40763,9449,3,4196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',2623.63,NULL,NULL,1,'2021-08-05 21:44:10','2021-08-05 21:44:10',NULL),(4197,3705,40763,9449,3,4197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-03','2021-05-03',7234.00,NULL,NULL,1,'2021-08-05 21:44:10','2021-08-05 21:44:10',NULL),(4198,3705,40763,9449,3,4198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',14710.41,NULL,NULL,1,'2021-08-05 21:44:10','2021-08-05 21:44:10',NULL),(4199,3705,40763,9449,3,4199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',5184.07,NULL,NULL,1,'2021-08-05 21:44:10','2021-08-05 21:44:10',NULL),(4200,3705,40763,9449,3,4200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',2727.67,NULL,NULL,1,'2021-08-05 21:44:10','2021-08-05 21:44:10',NULL),(4201,3705,40763,9449,3,4201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',4961.36,NULL,NULL,1,'2021-08-05 21:44:10','2021-08-05 21:44:10',NULL),(4202,3705,40763,9449,3,4202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',0.13,NULL,NULL,1,'2021-08-05 21:44:10','2021-08-05 21:44:10',NULL),(4203,3705,40763,9449,3,4203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',16591.85,NULL,NULL,1,'2021-08-05 21:44:10','2021-08-05 21:44:10',NULL),(4204,3705,40763,9449,3,4204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-04','2021-05-04',15606.42,NULL,NULL,1,'2021-08-05 21:44:10','2021-08-05 21:44:10',NULL),(4205,3705,40763,9449,3,4205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',20321.50,NULL,NULL,1,'2021-08-05 21:44:10','2021-08-05 21:44:10',NULL),(4206,3705,40763,9449,3,4206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',12172.35,NULL,NULL,1,'2021-08-05 21:44:10','2021-08-05 21:44:10',NULL),(4207,3705,40763,9449,3,4207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',14084.46,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4208,3705,40763,9449,3,4208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',12220.26,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4209,3705,40763,9449,3,4209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',5522.73,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4210,3705,40763,9449,3,4210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',8606.47,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4211,3705,40763,9449,3,4211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',1878.24,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL);
INSERT INTO `balance_libro` VALUES (4212,3705,40763,9449,3,4212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-05','2021-05-05',6190.23,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4213,3705,40763,9449,3,4213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',18524.50,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4214,3705,40763,9449,3,4214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',1466.08,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4215,3705,40763,9449,3,4215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-06','2021-05-06',2841.65,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4216,3705,40763,9449,3,4216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-07','2021-05-07',7879.78,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4217,3705,40763,9449,3,4217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-08','2021-05-08',32955.54,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4218,3705,40763,9449,3,4218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',1646.16,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4219,3705,40763,9449,3,4219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',6222.25,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4220,3705,40763,9449,3,4220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',816.13,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4221,3705,40763,9449,3,4221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',22276.40,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4222,3705,40763,9449,3,4222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',0.00,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4223,3705,40763,9449,3,4223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-10','2021-05-10',14102.00,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4224,3705,40763,9449,3,4224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',4749.66,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4225,3705,40763,9449,3,4225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',812.88,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4226,3705,40763,9449,3,4226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',2563.09,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4227,3705,40763,9449,3,4227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',2627.20,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4228,3705,40763,9449,3,4228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-11','2021-05-11',2557.99,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4229,3705,40763,9449,3,4229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',4483.84,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4230,3705,40763,9449,3,4230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',10004.54,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4231,3705,40763,9449,3,4231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',4259.30,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4232,3705,40763,9449,3,4232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',9714.09,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4233,3705,40763,9449,3,4233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',16800.37,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4234,3705,40763,9449,3,4234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',2850.01,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4235,3705,40763,9449,3,4235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',3287.71,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL);
INSERT INTO `balance_libro` VALUES (4236,3705,40763,9449,3,4236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',141.89,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4237,3705,40763,9449,3,4237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-12','2021-05-12',217.84,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4238,3705,40763,9449,3,4238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',6352.54,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4239,3705,40763,9449,3,4239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',10372.41,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4240,3705,40763,9449,3,4240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-13','2021-05-13',89.98,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4241,3705,40763,9449,3,4241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',15016.17,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4242,3705,40763,9449,3,4242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',562.34,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4243,3705,40763,9449,3,4243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',13941.89,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4244,3705,40763,9449,3,4244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',3938.78,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4245,3705,40763,9449,3,4245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-14','2021-05-14',4290.26,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4246,3705,40763,9449,3,4246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',8605.98,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4247,3705,40763,9449,3,4247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',9593.35,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4248,3705,40763,9449,3,4248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',13416.85,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4249,3705,40763,9449,3,4249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',4551.54,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4250,3705,40763,9449,3,4250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-15','2021-05-15',8060.59,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4251,3705,40763,9449,3,4251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',7121.33,NULL,NULL,1,'2021-08-05 21:44:11','2021-08-05 21:44:11',NULL),(4252,3705,40763,9449,3,4252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',6294.14,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4253,3705,40763,9449,3,4253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',3352.73,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4254,3705,40763,9449,3,4254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',0.10,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4255,3705,40763,9449,3,4255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',2488.16,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4256,3705,40763,9449,3,4256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',6845.80,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4257,3705,40763,9449,3,4257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',7873.64,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4258,3705,40763,9449,3,4258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',5182.12,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4259,3705,40763,9449,3,4259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-17','2021-05-17',1625.74,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL);
INSERT INTO `balance_libro` VALUES (4260,3705,40763,9449,3,4260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',7624.16,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4261,3705,40763,9449,3,4261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',24175.73,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4262,3705,40763,9449,3,4262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',10525.91,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4263,3705,40763,9449,3,4263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',2570.12,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4264,3705,40763,9449,3,4264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',2549.25,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4265,3705,40763,9449,3,4265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',8887.56,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4266,3705,40763,9449,3,4266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',17659.35,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4267,3705,40763,9449,3,4267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',9386.34,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4268,3705,40763,9449,3,4268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',2982.76,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4269,3705,40763,9449,3,4269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',258.47,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4270,3705,40763,9449,3,4270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',524.75,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4271,3705,40763,9449,3,4271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',190.26,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4272,3705,40763,9449,3,4272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',10756.34,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4273,3705,40763,9449,3,4273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',10129.21,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4274,3705,40763,9449,3,4274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',6826.54,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4275,3705,40763,9449,3,4275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-19','2021-05-19',1787.23,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4276,3705,40763,9449,3,4276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',9116.29,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4277,3705,40763,9449,3,4277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',10066.24,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4278,3705,40763,9449,3,4278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-20','2021-05-20',4415.42,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4279,3705,40763,9449,3,4279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',14961.65,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4280,3705,40763,9449,3,4280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',22747.03,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4281,3705,40763,9449,3,4281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21','2021-05-21',8593.58,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4282,3705,40763,9449,3,4282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',7361.38,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4283,3705,40763,9449,3,4283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',4259.98,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL);
INSERT INTO `balance_libro` VALUES (4284,3705,40763,9449,3,4284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',20438.06,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4285,3705,40763,9449,3,4285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22','2021-05-22',3437.40,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4286,3705,40763,9449,3,4286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',6868.08,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4287,3705,40763,9449,3,4287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',770.14,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4288,3705,40763,9449,3,4288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',1166.20,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4289,3705,40763,9449,3,4289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',737.62,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4290,3705,40763,9449,3,4290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',7163.88,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4291,3705,40763,9449,3,4291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',5424.73,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4292,3705,40763,9449,3,4292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',2361.22,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4293,3705,40763,9449,3,4293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-24','2021-05-24',13544.90,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4294,3705,40763,9449,3,4294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',12646.18,NULL,NULL,1,'2021-08-05 21:44:12','2021-08-05 21:44:12',NULL),(4295,3705,40763,9449,3,4295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',1154.01,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4296,3705,40763,9449,3,4296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',1285.99,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4297,3705,40763,9449,3,4297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',11912.34,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4298,3705,40763,9449,3,4298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',5574.19,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4299,3705,40763,9449,3,4299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',913.38,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4300,3705,40763,9449,3,4300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',9768.60,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4301,3705,40763,9449,3,4301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',136.75,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4302,3705,40763,9449,3,4302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-26','2021-05-26',5069.05,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4303,3705,40763,9449,3,4303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27','2021-05-27',540.06,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4304,3705,40763,9449,3,4304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',10087.14,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4305,3705,40763,9449,3,4305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',13636.24,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4306,3705,40763,9449,3,4306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',4461.79,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4307,3705,40763,9449,3,4307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28','2021-05-28',18008.07,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL);
INSERT INTO `balance_libro` VALUES (4308,3705,40763,9449,3,4308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',14267.36,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4309,3705,40763,9449,3,4309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',10000.00,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4310,3705,40763,9449,3,4310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-29','2021-05-29',2789.95,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4311,3705,40763,9449,3,4311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',11.08,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4312,3705,40763,9449,3,4312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-30','2021-05-30',1570.49,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4313,3705,40763,9449,3,4313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',12100.00,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4314,3705,40763,9449,3,4314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',3795.32,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4315,3705,40763,9449,3,4315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',12339.68,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4316,3705,40763,9449,3,4316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',0.00,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4317,3705,40763,9449,3,4317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2272.55,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4318,3705,40763,9449,3,4318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',2674.92,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4319,3705,40763,9449,3,4319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1724.98,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4320,3705,40763,9449,3,4320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',4328.80,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4321,3705,40763,9449,3,4321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',1851.82,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4322,3705,40763,9449,3,4322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',11843.40,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4323,3705,40763,9449,3,4323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-31','2021-05-31',37.83,NULL,NULL,1,'2021-08-05 21:44:13','2021-08-05 21:44:13',NULL),(4324,3705,40763,9450,2,4324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',717.00,NULL,NULL,1,'2021-08-05 21:45:54','2021-08-05 21:45:54',NULL),(4325,3705,40763,9450,2,4325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',2867.00,NULL,NULL,1,'2021-08-05 21:45:54','2021-08-05 21:45:54',NULL),(4326,3705,40763,9450,2,4326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',339.00,NULL,NULL,1,'2021-08-05 21:45:54','2021-08-05 21:45:54',NULL),(4327,3705,40763,9450,2,4327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',782.00,NULL,NULL,1,'2021-08-05 21:45:54','2021-08-05 21:45:54',NULL),(4328,3705,40763,9450,2,4328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',420.00,NULL,NULL,1,'2021-08-05 21:45:54','2021-08-05 21:45:54',NULL),(4329,3705,40763,9450,2,4329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1082.00,NULL,NULL,1,'2021-08-05 21:45:54','2021-08-05 21:45:54',NULL),(4330,3705,40763,9450,2,4330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',934.00,NULL,NULL,1,'2021-08-05 21:45:54','2021-08-05 21:45:54',NULL),(4331,3705,40763,9450,2,4331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',433.00,NULL,NULL,1,'2021-08-05 21:45:54','2021-08-05 21:45:54',NULL);
INSERT INTO `balance_libro` VALUES (4332,3705,40763,9450,2,4332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',613.00,NULL,NULL,1,'2021-08-05 21:45:54','2021-08-05 21:45:54',NULL),(4333,3705,40763,9450,2,4333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',586.00,NULL,NULL,1,'2021-08-05 21:45:54','2021-08-05 21:45:54',NULL),(4334,3705,40763,9450,2,4334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1628.00,NULL,NULL,1,'2021-08-05 21:45:54','2021-08-05 21:45:54',NULL),(4335,3705,40763,9450,2,4335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',700.00,NULL,NULL,1,'2021-08-05 21:45:54','2021-08-05 21:45:54',NULL),(4336,3705,40763,9450,2,4336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',465.00,NULL,NULL,1,'2021-08-05 21:45:54','2021-08-05 21:45:54',NULL),(4337,3705,40763,9450,2,4337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',736.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4338,3705,40763,9450,2,4338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',245.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4339,3705,40763,9450,2,4339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',715.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4340,3705,40763,9450,2,4340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',161.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4341,3705,40763,9450,2,4341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1969.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4342,3705,40763,9450,2,4342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',526.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4343,3705,40763,9450,2,4343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',190.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4344,3705,40763,9450,2,4344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',494.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4345,3705,40763,9450,2,4345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',894.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4346,3705,40763,9450,2,4346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',396.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4347,3705,40763,9450,2,4347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',903.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4348,3705,40763,9450,2,4348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',468.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4349,3705,40763,9450,2,4349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',195.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4350,3705,40763,9450,2,4350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1099.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4351,3705,40763,9450,2,4351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',641.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4352,3705,40763,9450,2,4352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-01','2021-06-01',1390.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4353,3705,40763,9450,2,4353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',240.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4354,3705,40763,9450,2,4354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',871.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4355,3705,40763,9450,2,4355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',989.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4356,3705,40763,9450,2,4356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',708.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL);
INSERT INTO `balance_libro` VALUES (4357,3705,40763,9450,2,4357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1680.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4358,3705,40763,9450,2,4358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',443.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4359,3705,40763,9450,2,4359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',2824.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4360,3705,40763,9450,2,4360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',429.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4361,3705,40763,9450,2,4361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',862.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4362,3705,40763,9450,2,4362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1788.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4363,3705,40763,9450,2,4363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',403.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4364,3705,40763,9450,2,4364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',815.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4365,3705,40763,9450,2,4365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',759.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4366,3705,40763,9450,2,4366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',448.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4367,3705,40763,9450,2,4367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1507.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4368,3705,40763,9450,2,4368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',657.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4369,3705,40763,9450,2,4369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',551.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4370,3705,40763,9450,2,4370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',1339.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4371,3705,40763,9450,2,4371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',346.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4372,3705,40763,9450,2,4372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',620.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4373,3705,40763,9450,2,4373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',462.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4374,3705,40763,9450,2,4374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',195.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4375,3705,40763,9450,2,4375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',704.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4376,3705,40763,9450,2,4376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',150.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4377,3705,40763,9450,2,4377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',697.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4378,3705,40763,9450,2,4378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',438.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4379,3705,40763,9450,2,4379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',501.00,NULL,NULL,1,'2021-08-05 21:45:55','2021-08-05 21:45:55',NULL),(4380,3705,40763,9450,2,4380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',232.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4381,3705,40763,9450,2,4381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',558.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL);
INSERT INTO `balance_libro` VALUES (4382,3705,40763,9450,2,4382,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',850.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4383,3705,40763,9450,2,4383,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',215.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4384,3705,40763,9450,2,4384,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',485.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4385,3705,40763,9450,2,4385,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',335.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4386,3705,40763,9450,2,4386,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',640.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4387,3705,40763,9450,2,4387,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',892.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4388,3705,40763,9450,2,4388,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',567.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4389,3705,40763,9450,2,4389,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',486.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4390,3705,40763,9450,2,4390,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',530.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4391,3705,40763,9450,2,4391,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',787.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4392,3705,40763,9450,2,4392,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',810.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4393,3705,40763,9450,2,4393,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1162.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4394,3705,40763,9450,2,4394,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',210.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4395,3705,40763,9450,2,4395,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',460.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4396,3705,40763,9450,2,4396,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',170.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4397,3705,40763,9450,2,4397,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',357.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4398,3705,40763,9450,2,4398,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',830.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4399,3705,40763,9450,2,4399,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',714.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4400,3705,40763,9450,2,4400,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',346.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4401,3705,40763,9450,2,4401,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',360.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4402,3705,40763,9450,2,4402,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',492.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4403,3705,40763,9450,2,4403,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1628.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4404,3705,40763,9450,2,4404,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',2335.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4405,3705,40763,9450,2,4405,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',985.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4406,3705,40763,9450,2,4406,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1745.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL);
INSERT INTO `balance_libro` VALUES (4407,3705,40763,9450,2,4407,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',127.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4408,3705,40763,9450,2,4408,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',698.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4409,3705,40763,9450,2,4409,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',726.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4410,3705,40763,9450,2,4410,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1750.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4411,3705,40763,9450,2,4411,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1070.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4412,3705,40763,9450,2,4412,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',288.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4413,3705,40763,9450,2,4413,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1050.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4414,3705,40763,9450,2,4414,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',152.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4415,3705,40763,9450,2,4415,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',946.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4416,3705,40763,9450,2,4416,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',350.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4417,3705,40763,9450,2,4417,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',202.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4418,3705,40763,9450,2,4418,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',1540.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4419,3705,40763,9450,2,4419,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',332.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4420,3705,40763,9450,2,4420,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',355.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4421,3705,40763,9450,2,4421,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',495.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4422,3705,40763,9450,2,4422,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',870.00,NULL,NULL,1,'2021-08-05 21:45:56','2021-08-05 21:45:56',NULL),(4423,3705,40763,9450,2,4423,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',608.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4424,3705,40763,9450,2,4424,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1470.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4425,3705,40763,9450,2,4425,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',274.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4426,3705,40763,9450,2,4426,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1600.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4427,3705,40763,9450,2,4427,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',984.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4428,3705,40763,9450,2,4428,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',480.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4429,3705,40763,9450,2,4429,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1152.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4430,3705,40763,9450,2,4430,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',162.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL);
INSERT INTO `balance_libro` VALUES (4431,3705,40763,9450,2,4431,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',245.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4432,3705,40763,9450,2,4432,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',138.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4433,3705,40763,9450,2,4433,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1070.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4434,3705,40763,9450,2,4434,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',829.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4435,3705,40763,9450,2,4435,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',560.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4436,3705,40763,9450,2,4436,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',975.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4437,3705,40763,9450,2,4437,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',466.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4438,3705,40763,9450,2,4438,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',590.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4439,3705,40763,9450,2,4439,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',590.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4440,3705,40763,9450,2,4440,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',330.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4441,3705,40763,9450,2,4441,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1822.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4442,3705,40763,9450,2,4442,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1053.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4443,3705,40763,9450,2,4443,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',475.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4444,3705,40763,9450,2,4444,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1248.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4445,3705,40763,9450,2,4445,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',869.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4446,3705,40763,9450,2,4446,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1474.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4447,3705,40763,9450,2,4447,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1839.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4448,3705,40763,9450,2,4448,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',799.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4449,3705,40763,9450,2,4449,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',11822.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4450,3705,40763,9450,2,4450,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',6238.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4451,3705,40763,9450,2,4451,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1032.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4452,3705,40763,9450,2,4452,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',1185.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4453,3705,40763,9450,2,4453,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',200.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4454,3705,40763,9450,2,4454,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',982.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL);
INSERT INTO `balance_libro` VALUES (4455,3705,40763,9450,2,4455,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',257.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4456,3705,40763,9450,2,4456,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',449.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4457,3705,40763,9450,2,4457,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',961.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4458,3705,40763,9450,2,4458,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',394.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4459,3705,40763,9450,2,4459,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',341.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4460,3705,40763,9450,2,4460,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',280.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4461,3705,40763,9450,2,4461,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',734.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4462,3705,40763,9450,2,4462,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',699.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4463,3705,40763,9450,2,4463,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',905.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4464,3705,40763,9450,2,4464,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',1772.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4465,3705,40763,9450,2,4465,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',342.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4466,3705,40763,9450,2,4466,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',790.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4467,3705,40763,9450,2,4467,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',1323.00,NULL,NULL,1,'2021-08-05 21:45:57','2021-08-05 21:45:57',NULL),(4468,3705,40763,9450,2,4468,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',2119.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4469,3705,40763,9450,2,4469,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',1182.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4470,3705,40763,9450,2,4470,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',355.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4471,3705,40763,9450,2,4471,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',544.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4472,3705,40763,9450,2,4472,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',560.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4473,3705,40763,9450,2,4473,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-06','2021-06-06',3050.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4474,3705,40763,9450,2,4474,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',40.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4475,3705,40763,9450,2,4475,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',535.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4476,3705,40763,9450,2,4476,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',1074.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4477,3705,40763,9450,2,4477,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',609.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4478,3705,40763,9450,2,4478,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',532.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4479,3705,40763,9450,2,4479,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',423.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL);
INSERT INTO `balance_libro` VALUES (4480,3705,40763,9450,2,4480,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',680.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4481,3705,40763,9450,2,4481,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',1231.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4482,3705,40763,9450,2,4482,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',2564.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4483,3705,40763,9450,2,4483,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',1055.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4484,3705,40763,9450,2,4484,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',526.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4485,3705,40763,9450,2,4485,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',1161.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4486,3705,40763,9450,2,4486,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',297.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4487,3705,40763,9450,2,4487,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',785.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4488,3705,40763,9450,2,4488,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',352.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4489,3705,40763,9450,2,4489,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',1369.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4490,3705,40763,9450,2,4490,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',2417.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4491,3705,40763,9450,2,4491,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',694.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4492,3705,40763,9450,2,4492,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',425.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4493,3705,40763,9450,2,4493,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',305.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4494,3705,40763,9450,2,4494,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',677.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4495,3705,40763,9450,2,4495,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',300.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4496,3705,40763,9450,2,4496,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',370.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4497,3705,40763,9450,2,4497,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',200.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4498,3705,40763,9450,2,4498,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',2849.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4499,3705,40763,9450,2,4499,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',84.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4500,3705,40763,9450,2,4500,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',150.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4501,3705,40763,9450,2,4501,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',475.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4502,3705,40763,9450,2,4502,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',594.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4503,3705,40763,9450,2,4503,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1184.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL);
INSERT INTO `balance_libro` VALUES (4504,3705,40763,9450,2,4504,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',210.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4505,3705,40763,9450,2,4505,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',425.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4506,3705,40763,9450,2,4506,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',2511.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4507,3705,40763,9450,2,4507,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1166.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4508,3705,40763,9450,2,4508,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1273.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4509,3705,40763,9450,2,4509,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',155.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4510,3705,40763,9450,2,4510,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',100.00,NULL,NULL,1,'2021-08-05 21:45:58','2021-08-05 21:45:58',NULL),(4511,3705,40763,9450,2,4511,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1290.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4512,3705,40763,9450,2,4512,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',780.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4513,3705,40763,9450,2,4513,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',346.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4514,3705,40763,9450,2,4514,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',2211.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4515,3705,40763,9450,2,4515,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',56.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4516,3705,40763,9450,2,4516,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',752.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4517,3705,40763,9450,2,4517,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',638.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4518,3705,40763,9450,2,4518,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',1061.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4519,3705,40763,9450,2,4519,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',842.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4520,3705,40763,9450,2,4520,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',430.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4521,3705,40763,9450,2,4521,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',320.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4522,3705,40763,9450,2,4522,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',812.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4523,3705,40763,9450,2,4523,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',457.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4524,3705,40763,9450,2,4524,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',84.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4525,3705,40763,9450,2,4525,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1512.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4526,3705,40763,9450,2,4526,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1112.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4527,3705,40763,9450,2,4527,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',524.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4528,3705,40763,9450,2,4528,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',280.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL);
INSERT INTO `balance_libro` VALUES (4529,3705,40763,9450,2,4529,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',3085.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4530,3705,40763,9450,2,4530,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',199.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4531,3705,40763,9450,2,4531,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',150.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4532,3705,40763,9450,2,4532,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',207.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4533,3705,40763,9450,2,4533,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',877.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4534,3705,40763,9450,2,4534,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',567.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4535,3705,40763,9450,2,4535,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',773.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4536,3705,40763,9450,2,4536,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',629.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4537,3705,40763,9450,2,4537,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',850.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4538,3705,40763,9450,2,4538,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',551.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4539,3705,40763,9450,2,4539,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',467.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4540,3705,40763,9450,2,4540,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',696.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4541,3705,40763,9450,2,4541,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1023.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4542,3705,40763,9450,2,4542,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',465.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4543,3705,40763,9450,2,4543,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',342.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4544,3705,40763,9450,2,4544,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',310.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4545,3705,40763,9450,2,4545,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',130.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4546,3705,40763,9450,2,4546,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',307.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4547,3705,40763,9450,2,4547,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',171.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4548,3705,40763,9450,2,4548,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',641.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4549,3705,40763,9450,2,4549,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',907.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4550,3705,40763,9450,2,4550,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',297.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4551,3705,40763,9450,2,4551,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',632.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4552,3705,40763,9450,2,4552,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',945.00,NULL,NULL,1,'2021-08-05 21:45:59','2021-08-05 21:45:59',NULL),(4553,3705,40763,9450,2,4553,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1292.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL);
INSERT INTO `balance_libro` VALUES (4554,3705,40763,9450,2,4554,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',2290.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4555,3705,40763,9450,2,4555,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1356.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4556,3705,40763,9450,2,4556,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',215.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4557,3705,40763,9450,2,4557,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',274.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4558,3705,40763,9450,2,4558,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',512.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4559,3705,40763,9450,2,4559,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',486.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4560,3705,40763,9450,2,4560,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1033.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4561,3705,40763,9450,2,4561,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',1172.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4562,3705,40763,9450,2,4562,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',924.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4563,3705,40763,9450,2,4563,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',474.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4564,3705,40763,9450,2,4564,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',549.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4565,3705,40763,9450,2,4565,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',924.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4566,3705,40763,9450,2,4566,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',820.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4567,3705,40763,9450,2,4567,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',100.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4568,3705,40763,9450,2,4568,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',288.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4569,3705,40763,9450,2,4569,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',238.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4570,3705,40763,9450,2,4570,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',944.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4571,3705,40763,9450,2,4571,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',679.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4572,3705,40763,9450,2,4572,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',367.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4573,3705,40763,9450,2,4573,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1390.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4574,3705,40763,9450,2,4574,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',657.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4575,3705,40763,9450,2,4575,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1414.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4576,3705,40763,9450,2,4576,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1051.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4577,3705,40763,9450,2,4577,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',297.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL);
INSERT INTO `balance_libro` VALUES (4578,3705,40763,9450,2,4578,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',436.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4579,3705,40763,9450,2,4579,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',807.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4580,3705,40763,9450,2,4580,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',331.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4581,3705,40763,9450,2,4581,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',989.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4582,3705,40763,9450,2,4582,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',697.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4583,3705,40763,9450,2,4583,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1813.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4584,3705,40763,9450,2,4584,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',307.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4585,3705,40763,9450,2,4585,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',529.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4586,3705,40763,9450,2,4586,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',772.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4587,3705,40763,9450,2,4587,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',620.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4588,3705,40763,9450,2,4588,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',939.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4589,3705,40763,9450,2,4589,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',130.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4590,3705,40763,9450,2,4590,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',770.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4591,3705,40763,9450,2,4591,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',464.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4592,3705,40763,9450,2,4592,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',560.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4593,3705,40763,9450,2,4593,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',500.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4594,3705,40763,9450,2,4594,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',2230.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4595,3705,40763,9450,2,4595,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1594.00,NULL,NULL,1,'2021-08-05 21:46:00','2021-08-05 21:46:00',NULL),(4596,3705,40763,9450,2,4596,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',150.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4597,3705,40763,9450,2,4597,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',488.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4598,3705,40763,9450,2,4598,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',510.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4599,3705,40763,9450,2,4599,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1084.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4600,3705,40763,9450,2,4600,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',425.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4601,3705,40763,9450,2,4601,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1162.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4602,3705,40763,9450,2,4602,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',1599.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL);
INSERT INTO `balance_libro` VALUES (4603,3705,40763,9450,2,4603,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',517.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4604,3705,40763,9450,2,4604,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',822.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4605,3705,40763,9450,2,4605,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1415.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4606,3705,40763,9450,2,4606,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',868.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4607,3705,40763,9450,2,4607,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',397.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4608,3705,40763,9450,2,4608,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',2324.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4609,3705,40763,9450,2,4609,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',305.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4610,3705,40763,9450,2,4610,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1622.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4611,3705,40763,9450,2,4611,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',225.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4612,3705,40763,9450,2,4612,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1060.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4613,3705,40763,9450,2,4613,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',510.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4614,3705,40763,9450,2,4614,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',465.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4615,3705,40763,9450,2,4615,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',876.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4616,3705,40763,9450,2,4616,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',464.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4617,3705,40763,9450,2,4617,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',245.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4618,3705,40763,9450,2,4618,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1820.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4619,3705,40763,9450,2,4619,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1302.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4620,3705,40763,9450,2,4620,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',575.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4621,3705,40763,9450,2,4621,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',597.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4622,3705,40763,9450,2,4622,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',555.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4623,3705,40763,9450,2,4623,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1603.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4624,3705,40763,9450,2,4624,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1033.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4625,3705,40763,9450,2,4625,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',494.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4626,3705,40763,9450,2,4626,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',407.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL);
INSERT INTO `balance_libro` VALUES (4627,3705,40763,9450,2,4627,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',348.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4628,3705,40763,9450,2,4628,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',828.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4629,3705,40763,9450,2,4629,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1288.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4630,3705,40763,9450,2,4630,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',180.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4631,3705,40763,9450,2,4631,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1732.00,NULL,NULL,1,'2021-08-05 21:46:01','2021-08-05 21:46:01',NULL),(4632,3705,40763,9450,2,4632,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',650.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4633,3705,40763,9450,2,4633,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1938.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4634,3705,40763,9450,2,4634,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',408.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4635,3705,40763,9450,2,4635,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',376.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4636,3705,40763,9450,2,4636,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',887.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4637,3705,40763,9450,2,4637,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',460.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4638,3705,40763,9450,2,4638,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',712.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4639,3705,40763,9450,2,4639,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',515.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4640,3705,40763,9450,2,4640,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',574.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4641,3705,40763,9450,2,4641,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',1517.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4642,3705,40763,9450,2,4642,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',477.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4643,3705,40763,9450,2,4643,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',385.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4644,3705,40763,9450,2,4644,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',616.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4645,3705,40763,9450,2,4645,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',300.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4646,3705,40763,9450,2,4646,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',398.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4647,3705,40763,9450,2,4647,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',30.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4648,3705,40763,9450,2,4648,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',725.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4649,3705,40763,9450,2,4649,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',204.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4650,3705,40763,9450,2,4650,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',434.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4651,3705,40763,9450,2,4651,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',368.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL);
INSERT INTO `balance_libro` VALUES (4652,3705,40763,9450,2,4652,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',480.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4653,3705,40763,9450,2,4653,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-13','2021-06-13',149.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4654,3705,40763,9450,2,4654,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',732.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4655,3705,40763,9450,2,4655,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1250.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4656,3705,40763,9450,2,4656,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',297.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4657,3705,40763,9450,2,4657,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',145.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4658,3705,40763,9450,2,4658,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1259.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4659,3705,40763,9450,2,4659,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',170.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4660,3705,40763,9450,2,4660,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',793.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4661,3705,40763,9450,2,4661,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',609.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4662,3705,40763,9450,2,4662,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',663.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4663,3705,40763,9450,2,4663,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',293.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4664,3705,40763,9450,2,4664,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1199.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4665,3705,40763,9450,2,4665,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',665.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4666,3705,40763,9450,2,4666,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',521.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4667,3705,40763,9450,2,4667,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1097.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4668,3705,40763,9450,2,4668,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',133.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4669,3705,40763,9450,2,4669,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1099.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4670,3705,40763,9450,2,4670,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',657.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4671,3705,40763,9450,2,4671,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',587.00,NULL,NULL,1,'2021-08-05 21:46:02','2021-08-05 21:46:02',NULL),(4672,3705,40763,9450,2,4672,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1085.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4673,3705,40763,9450,2,4673,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',148.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4674,3705,40763,9450,2,4674,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',620.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4675,3705,40763,9450,2,4675,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',478.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL);
INSERT INTO `balance_libro` VALUES (4676,3705,40763,9450,2,4676,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1014.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4677,3705,40763,9450,2,4677,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',562.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4678,3705,40763,9450,2,4678,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',340.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4679,3705,40763,9450,2,4679,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',323.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4680,3705,40763,9450,2,4680,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',200.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4681,3705,40763,9450,2,4681,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',185.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4682,3705,40763,9450,2,4682,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',358.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4683,3705,40763,9450,2,4683,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',250.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4684,3705,40763,9450,2,4684,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',794.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4685,3705,40763,9450,2,4685,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',416.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4686,3705,40763,9450,2,4686,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',279.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4687,3705,40763,9450,2,4687,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',186.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4688,3705,40763,9450,2,4688,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',490.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4689,3705,40763,9450,2,4689,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',487.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4690,3705,40763,9450,2,4690,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',441.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4691,3705,40763,9450,2,4691,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1875.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4692,3705,40763,9450,2,4692,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',762.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4693,3705,40763,9450,2,4693,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',327.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4694,3705,40763,9450,2,4694,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',330.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4695,3705,40763,9450,2,4695,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',601.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4696,3705,40763,9450,2,4696,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',223.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4697,3705,40763,9450,2,4697,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1296.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4698,3705,40763,9450,2,4698,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',113.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4699,3705,40763,9450,2,4699,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',298.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4700,3705,40763,9450,2,4700,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',210.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL);
INSERT INTO `balance_libro` VALUES (4701,3705,40763,9450,2,4701,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',801.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4702,3705,40763,9450,2,4702,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',523.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4703,3705,40763,9450,2,4703,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',380.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4704,3705,40763,9450,2,4704,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',268.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4705,3705,40763,9450,2,4705,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',3901.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4706,3705,40763,9450,2,4706,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',338.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4707,3705,40763,9450,2,4707,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',310.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4708,3705,40763,9450,2,4708,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',450.00,NULL,NULL,1,'2021-08-05 21:46:03','2021-08-05 21:46:03',NULL),(4709,3705,40763,9450,2,4709,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',228.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4710,3705,40763,9450,2,4710,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',170.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4711,3705,40763,9450,2,4711,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',888.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4712,3705,40763,9450,2,4712,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',867.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4713,3705,40763,9450,2,4713,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',410.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4714,3705,40763,9450,2,4714,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',258.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4715,3705,40763,9450,2,4715,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',396.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4716,3705,40763,9450,2,4716,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1102.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4717,3705,40763,9450,2,4717,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',652.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4718,3705,40763,9450,2,4718,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',265.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4719,3705,40763,9450,2,4719,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',825.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4720,3705,40763,9450,2,4720,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',437.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4721,3705,40763,9450,2,4721,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',417.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4722,3705,40763,9450,2,4722,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',542.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4723,3705,40763,9450,2,4723,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',410.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4724,3705,40763,9450,2,4724,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',392.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4725,3705,40763,9450,2,4725,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',479.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL);
INSERT INTO `balance_libro` VALUES (4726,3705,40763,9450,2,4726,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',426.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4727,3705,40763,9450,2,4727,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',223.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4728,3705,40763,9450,2,4728,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',342.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4729,3705,40763,9450,2,4729,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1163.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4730,3705,40763,9450,2,4730,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',960.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4731,3705,40763,9450,2,4731,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',251.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4732,3705,40763,9450,2,4732,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',766.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4733,3705,40763,9450,2,4733,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',366.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4734,3705,40763,9450,2,4734,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',251.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4735,3705,40763,9450,2,4735,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',423.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4736,3705,40763,9450,2,4736,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',811.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4737,3705,40763,9450,2,4737,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',462.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4738,3705,40763,9450,2,4738,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1482.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4739,3705,40763,9450,2,4739,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',880.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4740,3705,40763,9450,2,4740,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',110.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4741,3705,40763,9450,2,4741,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',394.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4742,3705,40763,9450,2,4742,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',1394.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4743,3705,40763,9450,2,4743,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',918.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4744,3705,40763,9450,2,4744,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',842.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4745,3705,40763,9450,2,4745,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',427.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4746,3705,40763,9450,2,4746,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',208.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4747,3705,40763,9450,2,4747,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',296.00,NULL,NULL,1,'2021-08-05 21:46:04','2021-08-05 21:46:04',NULL),(4748,3705,40763,9450,2,4748,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',306.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4749,3705,40763,9450,2,4749,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',219.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4750,3705,40763,9450,2,4750,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',823.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL);
INSERT INTO `balance_libro` VALUES (4751,3705,40763,9450,2,4751,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',215.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4752,3705,40763,9450,2,4752,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',445.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4753,3705,40763,9450,2,4753,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',285.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4754,3705,40763,9450,2,4754,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',277.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4755,3705,40763,9450,2,4755,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1455.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4756,3705,40763,9450,2,4756,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1132.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4757,3705,40763,9450,2,4757,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',757.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4758,3705,40763,9450,2,4758,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',556.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4759,3705,40763,9450,2,4759,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',323.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4760,3705,40763,9450,2,4760,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',618.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4761,3705,40763,9450,2,4761,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',858.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4762,3705,40763,9450,2,4762,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',262.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4763,3705,40763,9450,2,4763,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',192.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4764,3705,40763,9450,2,4764,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',434.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4765,3705,40763,9450,2,4765,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',514.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4766,3705,40763,9450,2,4766,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',150.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4767,3705,40763,9450,2,4767,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',682.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4768,3705,40763,9450,2,4768,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1198.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4769,3705,40763,9450,2,4769,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1376.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4770,3705,40763,9450,2,4770,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',899.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4771,3705,40763,9450,2,4771,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',490.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4772,3705,40763,9450,2,4772,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',321.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4773,3705,40763,9450,2,4773,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',260.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4774,3705,40763,9450,2,4774,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',2646.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4775,3705,40763,9450,2,4775,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',655.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL);
INSERT INTO `balance_libro` VALUES (4776,3705,40763,9450,2,4776,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',170.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4777,3705,40763,9450,2,4777,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',192.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4778,3705,40763,9450,2,4778,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',248.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4779,3705,40763,9450,2,4779,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',250.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4780,3705,40763,9450,2,4780,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',1108.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4781,3705,40763,9450,2,4781,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',4677.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4782,3705,40763,9450,2,4782,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',550.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4783,3705,40763,9450,2,4783,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',390.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4784,3705,40763,9450,2,4784,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',282.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4785,3705,40763,9450,2,4785,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',793.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4786,3705,40763,9450,2,4786,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',624.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4787,3705,40763,9450,2,4787,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',483.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4788,3705,40763,9450,2,4788,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',402.00,NULL,NULL,1,'2021-08-05 21:46:05','2021-08-05 21:46:05',NULL),(4789,3705,40763,9450,2,4789,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',388.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4790,3705,40763,9450,2,4790,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',411.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4791,3705,40763,9450,2,4791,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',566.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4792,3705,40763,9450,2,4792,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',734.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4793,3705,40763,9450,2,4793,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',667.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4794,3705,40763,9450,2,4794,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',150.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4795,3705,40763,9450,2,4795,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',310.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4796,3705,40763,9450,2,4796,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',320.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4797,3705,40763,9450,2,4797,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',516.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4798,3705,40763,9450,2,4798,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',947.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4799,3705,40763,9450,2,4799,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1425.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4800,3705,40763,9450,2,4800,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',422.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL);
INSERT INTO `balance_libro` VALUES (4801,3705,40763,9450,2,4801,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1670.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4802,3705,40763,9450,2,4802,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1284.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4803,3705,40763,9450,2,4803,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',595.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4804,3705,40763,9450,2,4804,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',495.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4805,3705,40763,9450,2,4805,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',728.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4806,3705,40763,9450,2,4806,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',704.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4807,3705,40763,9450,2,4807,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',214.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4808,3705,40763,9450,2,4808,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',400.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4809,3705,40763,9450,2,4809,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',642.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4810,3705,40763,9450,2,4810,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',635.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4811,3705,40763,9450,2,4811,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',707.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4812,3705,40763,9450,2,4812,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',3872.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4813,3705,40763,9450,2,4813,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',681.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4814,3705,40763,9450,2,4814,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1020.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4815,3705,40763,9450,2,4815,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',706.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4816,3705,40763,9450,2,4816,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',736.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4817,3705,40763,9450,2,4817,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',692.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4818,3705,40763,9450,2,4818,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1134.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4819,3705,40763,9450,2,4819,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1184.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4820,3705,40763,9450,2,4820,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1846.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4821,3705,40763,9450,2,4821,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',912.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4822,3705,40763,9450,2,4822,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1539.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4823,3705,40763,9450,2,4823,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',222.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4824,3705,40763,9450,2,4824,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',927.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL);
INSERT INTO `balance_libro` VALUES (4825,3705,40763,9450,2,4825,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1049.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4826,3705,40763,9450,2,4826,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',203.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4827,3705,40763,9450,2,4827,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',210.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4828,3705,40763,9450,2,4828,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1065.00,NULL,NULL,1,'2021-08-05 21:46:06','2021-08-05 21:46:06',NULL),(4829,3705,40763,9450,2,4829,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1764.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4830,3705,40763,9450,2,4830,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',937.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4831,3705,40763,9450,2,4831,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',587.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4832,3705,40763,9450,2,4832,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',982.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4833,3705,40763,9450,2,4833,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',333.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4834,3705,40763,9450,2,4834,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',1212.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4835,3705,40763,9450,2,4835,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',332.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4836,3705,40763,9450,2,4836,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',145.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4837,3705,40763,9450,2,4837,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',233.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4838,3705,40763,9450,2,4838,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',915.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4839,3705,40763,9450,2,4839,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',281.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4840,3705,40763,9450,2,4840,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',190.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4841,3705,40763,9450,2,4841,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',555.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4842,3705,40763,9450,2,4842,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',917.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4843,3705,40763,9450,2,4843,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',557.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4844,3705,40763,9450,2,4844,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',941.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4845,3705,40763,9450,2,4845,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',480.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4846,3705,40763,9450,2,4846,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',804.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4847,3705,40763,9450,2,4847,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',260.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4848,3705,40763,9450,2,4848,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1540.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4849,3705,40763,9450,2,4849,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',401.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL);
INSERT INTO `balance_libro` VALUES (4850,3705,40763,9450,2,4850,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',707.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4851,3705,40763,9450,2,4851,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',921.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4852,3705,40763,9450,2,4852,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',674.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4853,3705,40763,9450,2,4853,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',408.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4854,3705,40763,9450,2,4854,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',264.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4855,3705,40763,9450,2,4855,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',894.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4856,3705,40763,9450,2,4856,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',545.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4857,3705,40763,9450,2,4857,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',832.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4858,3705,40763,9450,2,4858,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1648.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4859,3705,40763,9450,2,4859,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',456.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4860,3705,40763,9450,2,4860,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',2719.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4861,3705,40763,9450,2,4861,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',175.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4862,3705,40763,9450,2,4862,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1730.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4863,3705,40763,9450,2,4863,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',840.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4864,3705,40763,9450,2,4864,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1076.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4865,3705,40763,9450,2,4865,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1636.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4866,3705,40763,9450,2,4866,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',2518.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4867,3705,40763,9450,2,4867,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',2611.00,NULL,NULL,1,'2021-08-05 21:46:07','2021-08-05 21:46:07',NULL),(4868,3705,40763,9450,2,4868,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',192.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4869,3705,40763,9450,2,4869,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',305.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4870,3705,40763,9450,2,4870,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1262.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4871,3705,40763,9450,2,4871,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',781.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4872,3705,40763,9450,2,4872,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',481.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4873,3705,40763,9450,2,4873,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',935.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL);
INSERT INTO `balance_libro` VALUES (4874,3705,40763,9450,2,4874,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',545.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4875,3705,40763,9450,2,4875,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',400.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4876,3705,40763,9450,2,4876,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',200.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4877,3705,40763,9450,2,4877,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',423.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4878,3705,40763,9450,2,4878,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',487.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4879,3705,40763,9450,2,4879,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',929.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4880,3705,40763,9450,2,4880,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',725.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4881,3705,40763,9450,2,4881,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1064.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4882,3705,40763,9450,2,4882,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1422.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4883,3705,40763,9450,2,4883,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',445.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4884,3705,40763,9450,2,4884,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1303.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4885,3705,40763,9450,2,4885,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1238.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4886,3705,40763,9450,2,4886,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',630.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4887,3705,40763,9450,2,4887,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',315.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4888,3705,40763,9450,2,4888,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',390.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4889,3705,40763,9450,2,4889,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',347.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4890,3705,40763,9450,2,4890,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',197.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4891,3705,40763,9450,2,4891,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',863.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4892,3705,40763,9450,2,4892,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',742.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4893,3705,40763,9450,2,4893,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',363.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4894,3705,40763,9450,2,4894,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1245.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4895,3705,40763,9450,2,4895,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',615.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4896,3705,40763,9450,2,4896,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1249.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4897,3705,40763,9450,2,4897,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',275.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL);
INSERT INTO `balance_libro` VALUES (4898,3705,40763,9450,2,4898,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',1615.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4899,3705,40763,9450,2,4899,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',1179.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4900,3705,40763,9450,2,4900,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',1301.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4901,3705,40763,9450,2,4901,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',1180.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4902,3705,40763,9450,2,4902,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',482.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4903,3705,40763,9450,2,4903,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',863.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4904,3705,40763,9450,2,4904,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',716.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4905,3705,40763,9450,2,4905,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',751.00,NULL,NULL,1,'2021-08-05 21:46:08','2021-08-05 21:46:08',NULL),(4906,3705,40763,9450,2,4906,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',172.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4907,3705,40763,9450,2,4907,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',879.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4908,3705,40763,9450,2,4908,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-20','2021-06-20',1137.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4909,3705,40763,9450,2,4909,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',1157.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4910,3705,40763,9450,2,4910,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',462.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4911,3705,40763,9450,2,4911,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',290.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4912,3705,40763,9450,2,4912,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',290.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4913,3705,40763,9450,2,4913,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',780.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4914,3705,40763,9450,2,4914,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',289.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4915,3705,40763,9450,2,4915,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',2595.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4916,3705,40763,9450,2,4916,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',705.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4917,3705,40763,9450,2,4917,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',983.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4918,3705,40763,9450,2,4918,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',632.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4919,3705,40763,9450,2,4919,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',506.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4920,3705,40763,9450,2,4920,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',840.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4921,3705,40763,9450,2,4921,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',1057.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL);
INSERT INTO `balance_libro` VALUES (4922,3705,40763,9450,2,4922,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',921.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4923,3705,40763,9450,2,4923,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',733.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4924,3705,40763,9450,2,4924,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',478.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4925,3705,40763,9450,2,4925,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',300.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4926,3705,40763,9450,2,4926,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',407.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4927,3705,40763,9450,2,4927,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',200.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4928,3705,40763,9450,2,4928,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',290.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4929,3705,40763,9450,2,4929,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',853.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4930,3705,40763,9450,2,4930,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',798.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4931,3705,40763,9450,2,4931,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',195.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4932,3705,40763,9450,2,4932,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1039.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4933,3705,40763,9450,2,4933,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1243.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4934,3705,40763,9450,2,4934,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',458.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4935,3705,40763,9450,2,4935,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',883.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4936,3705,40763,9450,2,4936,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1013.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4937,3705,40763,9450,2,4937,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',115.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4938,3705,40763,9450,2,4938,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',921.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4939,3705,40763,9450,2,4939,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',432.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4940,3705,40763,9450,2,4940,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1104.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4941,3705,40763,9450,2,4941,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',400.00,NULL,NULL,1,'2021-08-05 21:46:09','2021-08-05 21:46:09',NULL),(4942,3705,40763,9450,2,4942,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',230.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4943,3705,40763,9450,2,4943,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',440.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4944,3705,40763,9450,2,4944,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',426.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4945,3705,40763,9450,2,4945,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',2119.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4946,3705,40763,9450,2,4946,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',275.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL);
INSERT INTO `balance_libro` VALUES (4947,3705,40763,9450,2,4947,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',507.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4948,3705,40763,9450,2,4948,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',590.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4949,3705,40763,9450,2,4949,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4950,3705,40763,9450,2,4950,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',165.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4951,3705,40763,9450,2,4951,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',168.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4952,3705,40763,9450,2,4952,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',644.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4953,3705,40763,9450,2,4953,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',983.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4954,3705,40763,9450,2,4954,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',3624.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4955,3705,40763,9450,2,4955,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1332.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4956,3705,40763,9450,2,4956,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',836.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4957,3705,40763,9450,2,4957,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',620.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4958,3705,40763,9450,2,4958,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',330.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4959,3705,40763,9450,2,4959,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1161.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4960,3705,40763,9450,2,4960,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',519.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4961,3705,40763,9450,2,4961,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',532.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4962,3705,40763,9450,2,4962,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1218.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4963,3705,40763,9450,2,4963,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',581.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4964,3705,40763,9450,2,4964,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',541.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4965,3705,40763,9450,2,4965,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1163.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4966,3705,40763,9450,2,4966,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',448.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4967,3705,40763,9450,2,4967,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',615.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4968,3705,40763,9450,2,4968,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',116.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4969,3705,40763,9450,2,4969,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',164.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4970,3705,40763,9450,2,4970,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1120.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4971,3705,40763,9450,2,4971,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',550.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL);
INSERT INTO `balance_libro` VALUES (4972,3705,40763,9450,2,4972,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1055.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4973,3705,40763,9450,2,4973,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',479.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4974,3705,40763,9450,2,4974,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',1955.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4975,3705,40763,9450,2,4975,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',445.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4976,3705,40763,9450,2,4976,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',780.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4977,3705,40763,9450,2,4977,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',521.00,NULL,NULL,1,'2021-08-05 21:46:10','2021-08-05 21:46:10',NULL),(4978,3705,40763,9450,2,4978,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',617.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4979,3705,40763,9450,2,4979,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',217.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4980,3705,40763,9450,2,4980,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',583.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4981,3705,40763,9450,2,4981,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',290.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4982,3705,40763,9450,2,4982,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',629.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4983,3705,40763,9450,2,4983,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1416.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4984,3705,40763,9450,2,4984,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',426.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4985,3705,40763,9450,2,4985,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',495.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4986,3705,40763,9450,2,4986,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',486.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4987,3705,40763,9450,2,4987,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',478.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4988,3705,40763,9450,2,4988,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',225.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4989,3705,40763,9450,2,4989,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1704.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4990,3705,40763,9450,2,4990,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1610.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4991,3705,40763,9450,2,4991,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',460.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4992,3705,40763,9450,2,4992,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',340.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4993,3705,40763,9450,2,4993,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',217.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4994,3705,40763,9450,2,4994,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',445.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4995,3705,40763,9450,2,4995,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',721.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4996,3705,40763,9450,2,4996,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',454.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL);
INSERT INTO `balance_libro` VALUES (4997,3705,40763,9450,2,4997,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',104.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4998,3705,40763,9450,2,4998,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',834.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(4999,3705,40763,9450,2,4999,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',579.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5000,3705,40763,9450,2,5000,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',817.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5001,3705,40763,9450,2,5001,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',254.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5002,3705,40763,9450,2,5002,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',993.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5003,3705,40763,9450,2,5003,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',347.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5004,3705,40763,9450,2,5004,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',887.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5005,3705,40763,9450,2,5005,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',320.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5006,3705,40763,9450,2,5006,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',260.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5007,3705,40763,9450,2,5007,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',884.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5008,3705,40763,9450,2,5008,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',840.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5009,3705,40763,9450,2,5009,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',3204.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5010,3705,40763,9450,2,5010,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',449.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5011,3705,40763,9450,2,5011,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',670.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5012,3705,40763,9450,2,5012,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',408.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5013,3705,40763,9450,2,5013,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',409.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5014,3705,40763,9450,2,5014,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',270.00,NULL,NULL,1,'2021-08-05 21:46:11','2021-08-05 21:46:11',NULL),(5015,3705,40763,9450,2,5015,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',152.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5016,3705,40763,9450,2,5016,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1007.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5017,3705,40763,9450,2,5017,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1704.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5018,3705,40763,9450,2,5018,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',2274.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5019,3705,40763,9450,2,5019,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',165.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5020,3705,40763,9450,2,5020,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',155.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5021,3705,40763,9450,2,5021,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',430.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL);
INSERT INTO `balance_libro` VALUES (5022,3705,40763,9450,2,5022,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',395.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5023,3705,40763,9450,2,5023,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1009.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5024,3705,40763,9450,2,5024,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',410.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5025,3705,40763,9450,2,5025,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1024.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5026,3705,40763,9450,2,5026,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',487.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5027,3705,40763,9450,2,5027,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',334.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5028,3705,40763,9450,2,5028,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',465.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5029,3705,40763,9450,2,5029,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',383.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5030,3705,40763,9450,2,5030,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',581.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5031,3705,40763,9450,2,5031,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',1270.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5032,3705,40763,9450,2,5032,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',261.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5033,3705,40763,9450,2,5033,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',317.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5034,3705,40763,9450,2,5034,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',361.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5035,3705,40763,9450,2,5035,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',584.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5036,3705,40763,9450,2,5036,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',85.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5037,3705,40763,9450,2,5037,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',308.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5038,3705,40763,9450,2,5038,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',215.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5039,3705,40763,9450,2,5039,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',245.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5040,3705,40763,9450,2,5040,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',479.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5041,3705,40763,9450,2,5041,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',578.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5042,3705,40763,9450,2,5042,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1585.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5043,3705,40763,9450,2,5043,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',667.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5044,3705,40763,9450,2,5044,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',437.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5045,3705,40763,9450,2,5045,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1738.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5046,3705,40763,9450,2,5046,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1072.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL);
INSERT INTO `balance_libro` VALUES (5047,3705,40763,9450,2,5047,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',554.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5048,3705,40763,9450,2,5048,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',880.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5049,3705,40763,9450,2,5049,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1373.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5050,3705,40763,9450,2,5050,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',652.00,NULL,NULL,1,'2021-08-05 21:46:12','2021-08-05 21:46:12',NULL),(5051,3705,40763,9450,2,5051,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1011.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5052,3705,40763,9450,2,5052,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',110.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5053,3705,40763,9450,2,5053,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',667.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5054,3705,40763,9450,2,5054,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',1180.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5055,3705,40763,9450,2,5055,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',559.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5056,3705,40763,9450,2,5056,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',740.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5057,3705,40763,9450,2,5057,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',456.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5058,3705,40763,9450,2,5058,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',435.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5059,3705,40763,9450,2,5059,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',634.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5060,3705,40763,9450,2,5060,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',556.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5061,3705,40763,9450,2,5061,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1249.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5062,3705,40763,9450,2,5062,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1380.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5063,3705,40763,9450,2,5063,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',312.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5064,3705,40763,9450,2,5064,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1200.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5065,3705,40763,9450,2,5065,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',2586.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5066,3705,40763,9450,2,5066,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',427.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5067,3705,40763,9450,2,5067,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',722.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5068,3705,40763,9450,2,5068,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',460.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5069,3705,40763,9450,2,5069,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1034.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5070,3705,40763,9450,2,5070,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',847.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL);
INSERT INTO `balance_libro` VALUES (5071,3705,40763,9450,2,5071,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',557.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5072,3705,40763,9450,2,5072,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',56.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5073,3705,40763,9450,2,5073,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',242.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5074,3705,40763,9450,2,5074,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',514.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5075,3705,40763,9450,2,5075,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',603.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5076,3705,40763,9450,2,5076,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',3171.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5077,3705,40763,9450,2,5077,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',844.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5078,3705,40763,9450,2,5078,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1170.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5079,3705,40763,9450,2,5079,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1248.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5080,3705,40763,9450,2,5080,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1721.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5081,3705,40763,9450,2,5081,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',195.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5082,3705,40763,9450,2,5082,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',495.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5083,3705,40763,9450,2,5083,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',165.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5084,3705,40763,9450,2,5084,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1074.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5085,3705,40763,9450,2,5085,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',754.00,NULL,NULL,1,'2021-08-05 21:46:13','2021-08-05 21:46:13',NULL),(5086,3705,40763,9450,2,5086,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',711.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5087,3705,40763,9450,2,5087,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1179.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5088,3705,40763,9450,2,5088,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',305.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5089,3705,40763,9450,2,5089,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',643.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5090,3705,40763,9450,2,5090,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',2559.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5091,3705,40763,9450,2,5091,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1198.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5092,3705,40763,9450,2,5092,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',894.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5093,3705,40763,9450,2,5093,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',557.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5094,3705,40763,9450,2,5094,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',741.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL);
INSERT INTO `balance_libro` VALUES (5095,3705,40763,9450,2,5095,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1531.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5096,3705,40763,9450,2,5096,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',242.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5097,3705,40763,9450,2,5097,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',1190.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5098,3705,40763,9450,2,5098,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',815.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5099,3705,40763,9450,2,5099,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',550.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5100,3705,40763,9450,2,5100,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',642.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5101,3705,40763,9450,2,5101,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',715.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5102,3705,40763,9450,2,5102,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',498.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5103,3705,40763,9450,2,5103,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',729.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5104,3705,40763,9450,2,5104,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',877.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5105,3705,40763,9450,2,5105,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',399.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5106,3705,40763,9450,2,5106,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',687.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5107,3705,40763,9450,2,5107,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',400.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5108,3705,40763,9450,2,5108,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',735.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5109,3705,40763,9450,2,5109,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',1071.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5110,3705,40763,9450,2,5110,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',1805.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5111,3705,40763,9450,2,5111,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',560.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5112,3705,40763,9450,2,5112,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',307.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5113,3705,40763,9450,2,5113,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',733.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5114,3705,40763,9450,2,5114,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',192.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5115,3705,40763,9450,2,5115,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',589.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5116,3705,40763,9450,2,5116,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',534.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5117,3705,40763,9450,2,5117,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',595.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5118,3705,40763,9450,2,5118,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',719.00,NULL,NULL,1,'2021-08-05 21:46:14','2021-08-05 21:46:14',NULL),(5119,3705,40763,9450,2,5119,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',676.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL);
INSERT INTO `balance_libro` VALUES (5120,3705,40763,9450,2,5120,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-27','2021-06-27',1930.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5121,3705,40763,9450,2,5121,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',169.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5122,3705,40763,9450,2,5122,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',1352.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5123,3705,40763,9450,2,5123,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',720.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5124,3705,40763,9450,2,5124,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',290.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5125,3705,40763,9450,2,5125,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',472.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5126,3705,40763,9450,2,5126,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',296.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5127,3705,40763,9450,2,5127,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',629.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5128,3705,40763,9450,2,5128,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',1032.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5129,3705,40763,9450,2,5129,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',747.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5130,3705,40763,9450,2,5130,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',685.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5131,3705,40763,9450,2,5131,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',512.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5132,3705,40763,9450,2,5132,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',569.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5133,3705,40763,9450,2,5133,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',282.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5134,3705,40763,9450,2,5134,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',702.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5135,3705,40763,9450,2,5135,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',673.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5136,3705,40763,9450,2,5136,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',501.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5137,3705,40763,9450,2,5137,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',2538.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5138,3705,40763,9450,2,5138,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',175.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5139,3705,40763,9450,2,5139,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',613.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5140,3705,40763,9450,2,5140,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',550.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5141,3705,40763,9450,2,5141,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',1932.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5142,3705,40763,9450,2,5142,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',188.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5143,3705,40763,9450,2,5143,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',397.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5144,3705,40763,9450,2,5144,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',290.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL);
INSERT INTO `balance_libro` VALUES (5145,3705,40763,9450,2,5145,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',839.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5146,3705,40763,9450,2,5146,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',866.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5147,3705,40763,9450,2,5147,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',263.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5148,3705,40763,9450,2,5148,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',338.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5149,3705,40763,9450,2,5149,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',667.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5150,3705,40763,9450,2,5150,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',295.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5151,3705,40763,9450,2,5151,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',606.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5152,3705,40763,9450,2,5152,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',258.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5153,3705,40763,9450,2,5153,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',324.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5154,3705,40763,9450,2,5154,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',843.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5155,3705,40763,9450,2,5155,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',693.00,NULL,NULL,1,'2021-08-05 21:46:15','2021-08-05 21:46:15',NULL),(5156,3705,40763,9450,2,5156,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',205.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5157,3705,40763,9450,2,5157,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',380.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5158,3705,40763,9450,2,5158,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',970.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5159,3705,40763,9450,2,5159,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',375.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5160,3705,40763,9450,2,5160,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',4312.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5161,3705,40763,9450,2,5161,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1330.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5162,3705,40763,9450,2,5162,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',140.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5163,3705,40763,9450,2,5163,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',326.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5164,3705,40763,9450,2,5164,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',522.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5165,3705,40763,9450,2,5165,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',380.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5166,3705,40763,9450,2,5166,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',812.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5167,3705,40763,9450,2,5167,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',2356.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5168,3705,40763,9450,2,5168,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',334.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5169,3705,40763,9450,2,5169,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1504.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL);
INSERT INTO `balance_libro` VALUES (5170,3705,40763,9450,2,5170,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',579.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5171,3705,40763,9450,2,5171,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',565.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5172,3705,40763,9450,2,5172,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',320.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5173,3705,40763,9450,2,5173,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',587.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5174,3705,40763,9450,2,5174,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',188.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5175,3705,40763,9450,2,5175,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',375.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5176,3705,40763,9450,2,5176,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',774.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5177,3705,40763,9450,2,5177,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',677.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5178,3705,40763,9450,2,5178,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',642.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5179,3705,40763,9450,2,5179,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',1342.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5180,3705,40763,9450,2,5180,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',2142.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5181,3705,40763,9450,2,5181,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',596.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5182,3705,40763,9450,2,5182,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',684.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5183,3705,40763,9450,2,5183,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',247.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5184,3705,40763,9450,2,5184,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',306.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5185,3705,40763,9450,2,5185,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1733.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5186,3705,40763,9450,2,5186,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',355.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5187,3705,40763,9450,2,5187,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1067.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5188,3705,40763,9450,2,5188,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',950.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5189,3705,40763,9450,2,5189,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',354.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5190,3705,40763,9450,2,5190,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',471.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5191,3705,40763,9450,2,5191,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',608.00,NULL,NULL,1,'2021-08-05 21:46:16','2021-08-05 21:46:16',NULL),(5192,3705,40763,9450,2,5192,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',336.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5193,3705,40763,9450,2,5193,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',439.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5194,3705,40763,9450,2,5194,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',688.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL);
INSERT INTO `balance_libro` VALUES (5195,3705,40763,9450,2,5195,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',290.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5196,3705,40763,9450,2,5196,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',533.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5197,3705,40763,9450,2,5197,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1129.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5198,3705,40763,9450,2,5198,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1523.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5199,3705,40763,9450,2,5199,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',395.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5200,3705,40763,9450,2,5200,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',697.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5201,3705,40763,9450,2,5201,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2447.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5202,3705,40763,9450,2,5202,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',245.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5203,3705,40763,9450,2,5203,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3248.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5204,3705,40763,9450,2,5204,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',752.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5205,3705,40763,9450,2,5205,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',245.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5206,3705,40763,9450,2,5206,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',316.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5207,3705,40763,9450,2,5207,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1073.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5208,3705,40763,9450,2,5208,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',663.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5209,3705,40763,9450,2,5209,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',630.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5210,3705,40763,9450,2,5210,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',769.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5211,3705,40763,9450,2,5211,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',238.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5212,3705,40763,9450,2,5212,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',728.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5213,3705,40763,9450,2,5213,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',643.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5214,3705,40763,9450,2,5214,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',537.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5215,3705,40763,9450,2,5215,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',250.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5216,3705,40763,9450,2,5216,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1058.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5217,3705,40763,9450,2,5217,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',920.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5218,3705,40763,9450,2,5218,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3309.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL);
INSERT INTO `balance_libro` VALUES (5219,3705,40763,9450,2,5219,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',430.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5220,3705,40763,9450,2,5220,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1342.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5221,3705,40763,9450,2,5221,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',879.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5222,3705,40763,9450,2,5222,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1348.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5223,3705,40763,9450,2,5223,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',617.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5224,3705,40763,9450,2,5224,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2833.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5225,3705,40763,9450,2,5225,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',399.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5226,3705,40763,9450,2,5226,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1314.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5227,3705,40763,9450,2,5227,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',328.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5228,3705,40763,9450,2,5228,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1812.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5229,3705,40763,9450,2,5229,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1306.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5230,3705,40763,9450,2,5230,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1052.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5231,3705,40763,9450,2,5231,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',260.00,NULL,NULL,1,'2021-08-05 21:46:17','2021-08-05 21:46:17',NULL),(5232,3705,40763,9450,3,5232,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',6051.42,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5233,3705,40763,9450,3,5233,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',15145.54,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5234,3705,40763,9450,3,5234,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',10184.55,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5235,3705,40763,9450,3,5235,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',7079.97,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5236,3705,40763,9450,3,5236,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',7047.88,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5237,3705,40763,9450,3,5237,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',9882.67,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5238,3705,40763,9450,3,5238,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',4386.16,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5239,3705,40763,9450,3,5239,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1280.63,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5240,3705,40763,9450,3,5240,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',16017.72,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5241,3705,40763,9450,3,5241,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',1791.92,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5242,3705,40763,9450,3,5242,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',16707.19,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL);
INSERT INTO `balance_libro` VALUES (5243,3705,40763,9450,3,5243,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-02','2021-06-02',8087.90,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5244,3705,40763,9450,3,5244,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',20628.76,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5245,3705,40763,9450,3,5245,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',4955.82,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5246,3705,40763,9450,3,5246,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',14798.64,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5247,3705,40763,9450,3,5247,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',492.32,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5248,3705,40763,9450,3,5248,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-03','2021-06-03',13062.63,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5249,3705,40763,9450,3,5249,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',6350.33,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5250,3705,40763,9450,3,5250,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-04','2021-06-04',11022.39,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5251,3705,40763,9450,3,5251,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',20986.00,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5252,3705,40763,9450,3,5252,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',18211.67,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5253,3705,40763,9450,3,5253,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-05','2021-06-05',7730.33,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5254,3705,40763,9450,3,5254,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',11660.30,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5255,3705,40763,9450,3,5255,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',6235.46,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5256,3705,40763,9450,3,5256,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',11701.06,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5257,3705,40763,9450,3,5257,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',4781.56,NULL,NULL,1,'2021-08-05 21:47:18','2021-08-05 21:47:18',NULL),(5258,3705,40763,9450,3,5258,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',3937.13,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5259,3705,40763,9450,3,5259,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',2457.46,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5260,3705,40763,9450,3,5260,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',4419.85,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5261,3705,40763,9450,3,5261,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',428.17,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5262,3705,40763,9450,3,5262,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-07','2021-06-07',15554.20,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5263,3705,40763,9450,3,5263,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',12100.00,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5264,3705,40763,9450,3,5264,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',14068.26,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5265,3705,40763,9450,3,5265,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',11376.85,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5266,3705,40763,9450,3,5266,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',7219.61,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL);
INSERT INTO `balance_libro` VALUES (5267,3705,40763,9450,3,5267,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-08','2021-06-08',13254.25,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5268,3705,40763,9450,3,5268,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',7720.12,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5269,3705,40763,9450,3,5269,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',9145.76,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5270,3705,40763,9450,3,5270,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',9308.72,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5271,3705,40763,9450,3,5271,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',7661.30,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5272,3705,40763,9450,3,5272,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',12033.21,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5273,3705,40763,9450,3,5273,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',921.80,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5274,3705,40763,9450,3,5274,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-09','2021-06-09',10148.07,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5275,3705,40763,9450,3,5275,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',8026.74,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5276,3705,40763,9450,3,5276,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4412.11,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5277,3705,40763,9450,3,5277,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',18327.98,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5278,3705,40763,9450,3,5278,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',4984.05,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5279,3705,40763,9450,3,5279,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',0.00,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5280,3705,40763,9450,3,5280,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-10','2021-06-10',7531.00,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5281,3705,40763,9450,3,5281,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',12150.42,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5282,3705,40763,9450,3,5282,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-11','2021-06-11',9247.59,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5283,3705,40763,9450,3,5283,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-12','2021-06-12',8517.92,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5284,3705,40763,9450,3,5284,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1792.86,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5285,3705,40763,9450,3,5285,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',14761.90,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5286,3705,40763,9450,3,5286,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',6224.95,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5287,3705,40763,9450,3,5287,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',11031.13,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5288,3705,40763,9450,3,5288,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',1820.71,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5289,3705,40763,9450,3,5289,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',6939.35,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5290,3705,40763,9450,3,5290,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',2895.65,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL);
INSERT INTO `balance_libro` VALUES (5291,3705,40763,9450,3,5291,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',14296.68,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5292,3705,40763,9450,3,5292,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',6452.80,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5293,3705,40763,9450,3,5293,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',459.63,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5294,3705,40763,9450,3,5294,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',3129.51,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5295,3705,40763,9450,3,5295,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-14','2021-06-14',10130.70,NULL,NULL,1,'2021-08-05 21:47:19','2021-08-05 21:47:19',NULL),(5296,3705,40763,9450,3,5296,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',4182.74,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5297,3705,40763,9450,3,5297,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',6828.09,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5298,3705,40763,9450,3,5298,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1582.93,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5299,3705,40763,9450,3,5299,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',2126.48,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5300,3705,40763,9450,3,5300,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1092.22,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5301,3705,40763,9450,3,5301,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',1676.24,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5302,3705,40763,9450,3,5302,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',6757.72,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5303,3705,40763,9450,3,5303,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',965.05,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5304,3705,40763,9450,3,5304,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',6921.96,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5305,3705,40763,9450,3,5305,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',11526.25,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5306,3705,40763,9450,3,5306,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',0.13,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5307,3705,40763,9450,3,5307,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',11127.94,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5308,3705,40763,9450,3,5308,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-15','2021-06-15',705.41,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5309,3705,40763,9450,3,5309,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',17709.55,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5310,3705,40763,9450,3,5310,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',16070.34,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5311,3705,40763,9450,3,5311,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',12178.23,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5312,3705,40763,9450,3,5312,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',6102.01,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5313,3705,40763,9450,3,5313,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',8012.56,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5314,3705,40763,9450,3,5314,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-16','2021-06-16',6950.46,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL);
INSERT INTO `balance_libro` VALUES (5315,3705,40763,9450,3,5315,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',3990.90,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5316,3705,40763,9450,3,5316,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',8770.50,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5317,3705,40763,9450,3,5317,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',3534.40,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5318,3705,40763,9450,3,5318,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',6529.97,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5319,3705,40763,9450,3,5319,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-17','2021-06-17',140.74,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5320,3705,40763,9450,3,5320,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',10979.66,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5321,3705,40763,9450,3,5321,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-18','2021-06-18',9973.59,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5322,3705,40763,9450,3,5322,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',16532.82,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5323,3705,40763,9450,3,5323,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-19','2021-06-19',1554.40,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5324,3705,40763,9450,3,5324,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-21','2021-06-21',10889.00,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5325,3705,40763,9450,3,5325,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',16532.82,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5326,3705,40763,9450,3,5326,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',3529.97,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5327,3705,40763,9450,3,5327,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',12432.48,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5328,3705,40763,9450,3,5328,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',3031.98,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5329,3705,40763,9450,3,5329,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',10251.11,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5330,3705,40763,9450,3,5330,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-22','2021-06-22',6565.20,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5331,3705,40763,9450,3,5331,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',16532.82,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5332,3705,40763,9450,3,5332,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1332.08,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5333,3705,40763,9450,3,5333,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',2854.87,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5334,3705,40763,9450,3,5334,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',8348.72,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5335,3705,40763,9450,3,5335,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',1794.27,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5336,3705,40763,9450,3,5336,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',9094.83,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5337,3705,40763,9450,3,5337,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',9918.68,NULL,NULL,1,'2021-08-05 21:47:20','2021-08-05 21:47:20',NULL),(5338,3705,40763,9450,3,5338,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',6779.16,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL);
INSERT INTO `balance_libro` VALUES (5339,3705,40763,9450,3,5339,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',7112.55,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5340,3705,40763,9450,3,5340,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-23','2021-06-23',16563.65,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5341,3705,40763,9450,3,5341,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',16532.82,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5342,3705,40763,9450,3,5342,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',6416.58,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5343,3705,40763,9450,3,5343,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',5705.44,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5344,3705,40763,9450,3,5344,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',569.34,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5345,3705,40763,9450,3,5345,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',13533.80,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5346,3705,40763,9450,3,5346,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',4210.67,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5347,3705,40763,9450,3,5347,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',4752.00,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5348,3705,40763,9450,3,5348,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-24','2021-06-24',10141.60,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5349,3705,40763,9450,3,5349,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',21318.76,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5350,3705,40763,9450,3,5350,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25','2021-06-25',32209.92,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5351,3705,40763,9450,3,5351,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',28032.68,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5352,3705,40763,9450,3,5352,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26','2021-06-26',3255.91,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5353,3705,40763,9450,3,5353,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',23160.03,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5354,3705,40763,9450,3,5354,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',7252.69,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5355,3705,40763,9450,3,5355,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',13637.68,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5356,3705,40763,9450,3,5356,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-28','2021-06-28',5645.20,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5357,3705,40763,9450,3,5357,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',7493.74,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5358,3705,40763,9450,3,5358,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',6423.48,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5359,3705,40763,9450,3,5359,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',17848.81,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5360,3705,40763,9450,3,5360,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',910.36,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5361,3705,40763,9450,3,5361,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',862.49,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5362,3705,40763,9450,3,5362,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',2064.04,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL);
INSERT INTO `balance_libro` VALUES (5363,3705,40763,9450,3,5363,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',0.08,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5364,3705,40763,9450,3,5364,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',2742.08,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5365,3705,40763,9450,3,5365,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29','2021-06-29',4556.44,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5366,3705,40763,9450,3,5366,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3828.00,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5367,3705,40763,9450,3,5367,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',24.45,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5368,3705,40763,9450,3,5368,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',17673.22,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5369,3705,40763,9450,3,5369,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1825.15,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5370,3705,40763,9450,3,5370,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',2923.61,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5371,3705,40763,9450,3,5371,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',12343.57,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5372,3705,40763,9450,3,5372,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',13031.92,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5373,3705,40763,9450,3,5373,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',1622.37,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5374,3705,40763,9450,3,5374,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',5933.90,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5375,3705,40763,9450,3,5375,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',5999.33,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5376,3705,40763,9450,3,5376,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',3101.88,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5377,3705,40763,9450,3,5377,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',0.00,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5378,3705,40763,9450,3,5378,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30','2021-06-30',80.11,NULL,NULL,1,'2021-08-05 21:47:21','2021-08-05 21:47:21',NULL),(5379,NULL,40763,9451,2,5379,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',793.00,NULL,NULL,1,'2021-08-05 21:48:57','2021-08-05 21:48:57',NULL),(5380,NULL,40763,9451,2,5380,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',700.00,NULL,NULL,1,'2021-08-05 21:48:57','2021-08-05 21:48:57',NULL),(5381,NULL,40763,9451,2,5381,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-01','2021-07-01',460.00,NULL,NULL,1,'2021-08